% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/05_content.R
\name{as_word_field}
\alias{as_word_field}
\title{'Word' computed field}
\usage{
as_word_field(x, props = NULL, width = 0.1, height = 0.15, unit = "in")
}
\arguments{
\item{x}{computed field strings}

\item{props}{text properties (see \code{\link[=fp_text_default]{fp_text_default()}} or \code{\link[officer:fp_text]{officer::fp_text()}})
object to be used to format the text. If not specified, it will use
the default text properties of the cell(s).}

\item{width, height}{size computed field}

\item{unit}{unit for width and height, one of "in", "cm", "mm".}
}
\description{
This function is used to insert
'Word' computed field into flextable.

It is used to add it to the content of a cell of the
flextable with the functions \code{\link[=compose]{compose()}}, \code{\link[=append_chunks]{append_chunks()}}
or \code{\link[=prepend_chunks]{prepend_chunks()}}.

This has only effect on 'Word' output. If you want to
condition its execution only for Word output, you can
use it in the post processing step (see
\code{set_flextable_defaults(post_process_docx = ...)})

\strong{Do not forget to update the computed field in Word}.
Fields are defined but are not computed, this computing is an
operation that has to be made by 'Microsoft Word'
(select all text and hit \code{F9} when on mac os).
}
\examples{
library(flextable)

# define some default values ----
set_flextable_defaults(font.size = 22, border.color = "gray")

# an example with append_chunks ----
pp_docx = function(x) {
  x <- add_header_lines(x, "Page ")
  x <- append_chunks(
    x = x, i = 1, part = "header", j = 1,
    as_word_field(x = "Page")
  )
  align(x, part = "header", align = "left")
}
ft_1 <- flextable(cars)
ft_1 <- autofit(ft_1)
ft_1 <- pp_docx(ft_1)

## or:
# set_flextable_defaults(post_process_docx = pp_docx)
## to prevent this line addition when output is not docx

# print(ft_1, preview = "docx")

# an example with compose ----

library(officer)
ft_2 <- flextable(head(cars))
ft_2 <- add_footer_lines(ft_2, "temp text")
ft_2 <- compose(
  x = ft_2, part = "footer", i = 1, j = 1,
  as_paragraph("p. ",
               as_word_field(x = "Page", width = .05),
               " on ", as_word_field(x = "NumPages", width = .05))
)
ft_2 <- autofit(ft_2, part = c("header", "body"))

doc <- read_docx()
doc <- body_add_flextable(doc, ft_2)
doc <- body_add_break(doc)
doc <- body_add_flextable(doc, ft_2)
outfile <- print(doc, target = tempfile(fileext = ".docx"))

# reset default values ----
init_flextable_defaults()
}
\seealso{
Other chunk elements for paragraph: 
\code{\link{as_bracket}()},
\code{\link{as_b}()},
\code{\link{as_chunk}()},
\code{\link{as_equation}()},
\code{\link{as_highlight}()},
\code{\link{as_image}()},
\code{\link{as_i}()},
\code{\link{as_sub}()},
\code{\link{as_sup}()},
\code{\link{colorize}()},
\code{\link{gg_chunk}()},
\code{\link{grid_chunk}()},
\code{\link{hyperlink_text}()},
\code{\link{linerange}()},
\code{\link{lollipop}()},
\code{\link{minibar}()},
\code{\link{plot_chunk}()}
}
\concept{chunk elements for paragraph}
