% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/paste_linter.R
\name{paste_linter}
\alias{paste_linter}
\title{Raise lints for several common poor usages of paste()}
\usage{
paste_linter(allow_empty_sep = FALSE, allow_to_string = FALSE)
}
\arguments{
\item{allow_empty_sep}{Logical, default \code{FALSE}. If \code{TRUE}, usage of
\code{paste()} with \code{sep = ""} is not linted.}

\item{allow_to_string}{Logical, default \code{FALSE}. If \code{TRUE}, usage of
\code{paste()} and \code{paste0()} with \code{collapse = ", "} is not linted.}
}
\description{
The following issues are linted by default by this linter
(and each can be turned off optionally):
}
\details{
\enumerate{
\item Block usage of \code{\link[=paste]{paste()}} with \code{sep = ""}. \code{\link[=paste0]{paste0()}} is a faster, more concise alternative.
\item Block usage of \code{paste()} or \code{paste0()} with \code{collapse = ", "}. \code{\link[=toString]{toString()}} is a direct
wrapper for this, and alternatives like \code{\link[glue:glue_collapse]{glue::glue_collapse()}} might give better messages for humans.
\item Block usage of \code{paste0()} that supplies \verb{sep=} -- this is not a formal argument to \code{paste0}, and
is likely to be a mistake.
}
}
\seealso{
\link{linters} for a complete list of linters available in lintr.
}
\section{Tags}{
\link[=best_practices_linters]{best_practices}, \link[=consistency_linters]{consistency}
}
