% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/redundant_ifelse_linter.R
\name{redundant_ifelse_linter}
\alias{redundant_ifelse_linter}
\title{Prevent ifelse() from being used to produce TRUE/FALSE or 1/0}
\usage{
redundant_ifelse_linter(allow10 = FALSE)
}
\arguments{
\item{allow10}{Logical, default \code{FALSE}. If \code{TRUE}, usage like
\code{ifelse(x, 1, 0)} is allowed, i.e., only usage like
\code{ifelse(x, TRUE, FALSE)} is linted.}
}
\description{
Expressions like \code{ifelse(x, TRUE, FALSE)} and \code{ifelse(x, FALSE, TRUE)} are
redundant; just \code{x} or \code{!x} suffice in R code where logical vectors are a
core data structure. \code{ifelse(x, 1, 0)} is also \code{as.numeric(x)}, but even
this should only be needed rarely.
}
\seealso{
\link{linters} for a complete list of linters available in lintr.
}
\section{Tags}{
\link[=best_practices_linters]{best_practices}, \link[=consistency_linters]{consistency}, \link[=efficiency_linters]{efficiency}
}
