% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/thin_draws.R
\name{thin_draws}
\alias{thin_draws}
\alias{thin}
\alias{thin_draws.draws}
\alias{thin_draws.rvar}
\title{Thin \code{draws} objects}
\usage{
thin_draws(x, thin = NULL, ...)

\method{thin_draws}{draws}(x, thin = NULL, ...)

\method{thin_draws}{rvar}(x, thin = NULL, ...)
}
\arguments{
\item{x}{(draws) A \code{draws} object or another \R object for which the method
is defined.}

\item{thin}{(positive numeric) The period for selecting draws. Must
be between 1 and the number of iterations. If the value is not an
integer, the draws will be selected such that the number of draws
returned is equal to round(ndraws(x) / thin). Intervals between
selected draws will be either ceiling(thin) or floor(thin), such
that the average interval will be close to the thin value. If
\code{NULL}, it will be automatically calculated based on bulk and
tail effective sample size as suggested by Säilynoja et
al. (2022).}

\item{...}{Arguments passed to individual methods (if applicable).}
}
\value{
A \code{draws} object of the same class as \code{x}.
}
\description{
Thin \code{\link{draws}} objects to reduce their size and autocorrelation in
the chains.
}
\examples{
x <- example_draws()
niterations(x)

x <- thin_draws(x, thin = 5)
niterations(x)

}
\references{
Teemu Säilynoja, Paul-Christian Bürkner, and Aki Vehtari (2022).
Graphical test for discrete uniformity and its applications in
goodness-of-fit evaluation and multiple sample comparison.
\emph{Statistics and Computing}. 32, 32. doi:10.1007/s11222-022-10090-6
}
