% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/methods.R
\name{cv-indices}
\alias{cv-indices}
\alias{cvfolds}
\alias{cv_ids}
\title{Create cross-validation folds}
\usage{
cvfolds(n, K, seed = sample.int(.Machine$integer.max, 1))

cv_ids(
  n,
  K,
  out = c("foldwise", "indices"),
  seed = sample.int(.Machine$integer.max, 1)
)
}
\arguments{
\item{n}{Number of observations.}

\item{K}{Number of folds. Must be at least 2 and not exceed \code{n}.}

\item{seed}{Pseudorandom number generation (PRNG) seed by which the same
results can be obtained again if needed. Passed to argument \code{seed} of
\code{\link[=set.seed]{set.seed()}}, but can also be \code{NA} to not call \code{\link[=set.seed]{set.seed()}} at all.}

\item{out}{Format of the output, either \code{"foldwise"} or \code{"indices"}. See
below for details.}
}
\value{
\code{\link[=cvfolds]{cvfolds()}} returns a vector of length \code{n} such that each element is
an integer between 1 and \code{K} denoting which fold the corresponding data
point belongs to. The return value of \code{\link[=cv_ids]{cv_ids()}} depends on the \code{out}
argument. If \code{out = "foldwise"}, the return value is a \code{list} with \code{K}
elements, each being a \code{list} with elements \code{tr} and \code{ts} giving the
training and test indices, respectively, for the corresponding fold. If
\code{out = "indices"}, the return value is a \code{list} with elements \code{tr} and \code{ts}
each being a \code{list} with \code{K} elements giving the training and test indices,
respectively, for each fold.
}
\description{
These are helper functions to create cross-validation (CV) folds, i.e., to
split up the indices from 1 to \code{n} into \code{K} subsets ("folds") for
\eqn{K}-fold CV. These functions are potentially useful when creating the
\code{cvfits} and \code{cvfun} arguments for \code{\link[=init_refmodel]{init_refmodel()}}. The return value is
different for these two methods, see below for details.
}
\examples{
n <- 100
set.seed(1234)
y <- rnorm(n)
cv <- cv_ids(n, K = 5, seed = 9876)
# Mean within the test set of each fold:
cvmeans <- sapply(cv, function(fold) mean(y[fold$ts]))

}
