% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/reduce.R
\name{reduce_right}
\alias{reduce_right}
\alias{reduce2_right}
\alias{accumulate_right}
\title{Reduce from the right (retired)}
\usage{
reduce_right(.x, .f, ..., .init)

reduce2_right(.x, .y, .f, ..., .init)

accumulate_right(.x, .f, ..., .init)
}
\arguments{
\item{.x}{A list or atomic vector.}

\item{.f}{For \code{reduce()}, a 2-argument function. The function will be passed
the accumulated value as the first argument and the "next" value as the
second argument.

For \code{reduce2()}, a 3-argument function. The function will be passed the
accumulated value as the first argument, the next value of \code{.x} as the
second argument, and the next value of \code{.y} as the third argument.

The reduction terminates early if \code{.f} returns a value wrapped in
a \code{\link[=done]{done()}}.}

\item{...}{Additional arguments passed on to the reduce function.

We now generally recommend against using \code{...} to pass additional
(constant) arguments to \code{.f}. Instead use a shorthand anonymous function:

\if{html}{\out{<div class="sourceCode R">}}\preformatted{# Instead of
x |> reduce(f, 1, 2, collapse = ",")
# do:
x |> reduce(\\(x, y) f(x, y, 1, 2, collapse = ","))
}\if{html}{\out{</div>}}

This makes it easier to understand which arguments belong to which
function and will tend to yield better error messages.}

\item{.init}{If supplied, will be used as the first value to start
the accumulation, rather than using \code{.x[[1]]}. This is useful if
you want to ensure that \code{reduce} returns a correct value when \code{.x}
is empty. If missing, and \code{.x} is empty, will throw an error.}

\item{.y}{For \code{reduce2()} an additional
argument that is passed to \code{.f}. If \code{init} is not set, \code{.y}
should be 1 element shorter than \code{.x}.}
}
\description{
\ifelse{html}{\href{https://lifecycle.r-lib.org/articles/stages.html#deprecated}{\figure{lifecycle-deprecated.svg}{options: alt='[Deprecated]'}}}{\strong{[Deprecated]}}

\code{reduce_right()} is soft-deprecated as of purrr 0.3.0. Please use
the \code{.dir} argument of \code{reduce()} instead. Note that the algorithm
has changed. Whereas \code{reduce_right()} computed \code{f(f(3, 2), 1)},
\verb{reduce(.dir = \\"backward\\")} computes \code{f(1, f(2, 3))}. This is the
standard way of reducing from the right.

To update your code with the same reduction as \code{reduce_right()},
simply reverse your vector and use a left reduction:

\if{html}{\out{<div class="sourceCode R">}}\preformatted{# Before:
reduce_right(1:3, f)

# After:
reduce(rev(1:3), f)
}\if{html}{\out{</div>}}

\code{reduce2_right()} is deprecated as of purrr 0.3.0 without
replacement. It is not clear what algorithmic properties should a
right reduction have in this case. Please reach out if you know
about a use case for a right reduction with a ternary function.
}
\keyword{internal}
