% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/wglm.R
\name{wglm}
\alias{wglm}
\title{Logistic Regression Using IPCW}
\usage{
wglm(
  regressor.event,
  formula.censor,
  times,
  data,
  cause = NA,
  fitter = "coxph",
  product.limit = FALSE
)
}
\arguments{
\item{regressor.event}{[formula] a formula with empty left hand side and the covariates for the logistic regression on the right hand side.}

\item{formula.censor}{[formula] a formula used to fit the censoring model.}

\item{times}{[numeric vector] time points at which to model the probability of experiencing an event.}

\item{data}{[data.frame] dataset containing the time at which the event occured, the type of event, and regressors used to fit the censoring and logistic models.}

\item{cause}{[character or numeric] the cause of interest. Defaults to the first cause.}

\item{fitter}{[character] routine to fit the Cox regression models.}

\item{product.limit}{[logical] if \code{TRUE} the survival is computed using the product limit estimator.}
}
\value{
an object of class \code{"wglm"}.
}
\description{
Logistic regression over multiple timepoints
where right-censoring is handle using inverse probability of censoring weighting.
}
\details{
First, a Cox model is fitted (argument formula.censor)
and the censoring probabilities are computed relative to each timepoint (argument times) to obtain the censoring weights.
Then, for each timepoint, a logistic regression is fitted with the appropriate censoring weights
and where the outcome is the indicator of having experience the event of interest (argument cause) at or before the timepoint.
}
\examples{
library(survival)

set.seed(10)
n <- 250
tau <- 1:5
d <- sampleData(n, outcome = "competing.risks")
dFull <- d[event!=0] ## remove censoring
dSurv <- d[event!=2] ## remove competing risk

#### no censoring ####
e.wglm <- wglm(regressor.event = ~ X1, formula.censor = Surv(time,event==0) ~ 1,
               times = tau, data = dFull, product.limit = TRUE)
e.wglm ## same as a logistic regression

summary(ate(e.wglm, data = dFull, times = tau, treatment = "X1", verbose = FALSE))

#### right-censoring ####
## no covariante in the censoring model (independent censoring)
eC.wglm <- wglm(regressor.event = ~ X1, formula.censor = Surv(time,event==0) ~ 1,
               times = tau, data = dSurv, product.limit = TRUE)
eC.wglm

## with covariates in the censoring model
eC2.wglm <- wglm(regressor.event = ~ X1 + X8,
                formula.censor = Surv(time,event==0) ~ X1*X8,
                 times = tau, data = dSurv)
eC2.wglm

#### Competing risks ####
## here Kaplan-Meier as censoring model
eCR.wglm <- wglm(regressor.event = ~ X1,
                 formula.censor = Surv(time,event==0) ~ strata(X1),
                 times = tau, data = d, cause = 1, product.limit = TRUE)
eCR.wglm

}
