% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/nse-inject.R
\name{englue}
\alias{englue}
\title{Defuse function arguments with glue}
\usage{
englue(x, env = caller_env(), error_call = current_env(), error_arg = "x")
}
\arguments{
\item{x}{A string to interpolate with glue operators.}

\item{env}{User environment where the interpolation data lives in
case you're wrapping \code{englue()} in another function.}

\item{error_call}{The execution environment of a currently
running function, e.g. \code{caller_env()}. The function will be
mentioned in error messages as the source of the error. See the
\code{call} argument of \code{\link[=abort]{abort()}} for more information.}

\item{error_arg}{An argument name as a string. This argument
will be mentioned in error messages as the input that is at the
origin of a problem.}
}
\description{
\code{englue()} creates a string with the \link[=glue-operators]{glue operators} \verb{\{} and \verb{\{\{}. These operators are
normally used to inject names within \link[=dyn-dots]{dynamic dots}.
\code{englue()} makes them available anywhere within a function.

\code{englue()} must be used inside a function. \code{englue("{{ var }}")}
\link[=topic-defuse]{defuses} the argument \code{var} and transforms it to a
string using the default name operation.
}
\details{
\code{englue("{{ var }}")} is equivalent to \code{as_label(enquo(var))}. It
\link[=topic-defuse]{defuses} \code{arg} and transforms the expression to a
string with \code{\link[=as_label]{as_label()}}.

In dynamic dots, using only \verb{\{} is allowed. In \code{englue()} you must
use \verb{\{\{} at least once. Use \code{glue::glue()} for simple
interpolation.

Before using \code{englue()} in a package, first ensure that glue is
installed by adding it to your \verb{Imports:} section.

\if{html}{\out{<div class="sourceCode r">}}\preformatted{usethis::use_package("glue", "Imports")
}\if{html}{\out{</div>}}
}
\section{Wrapping \code{englue()}}{


You can provide englue semantics to a user provided string by supplying \code{env}.
In this example we create a variant of \code{englue()} that supports a
special \code{.qux} pronoun by:
\itemize{
\item Creating an environment \code{masked_env} that inherits from the user
env, the one where their data lives.
\item Overriding the \code{error_arg} and \code{error_call} arguments to point to
our own argument name and call environment. This pattern is
slightly different from usual error context passing because
\code{englue()} is a backend function that uses its own error context
by default (and not a checking function that uses \emph{your} error
context by default).
}

\if{html}{\out{<div class="sourceCode r">}}\preformatted{my_englue <- function(text) \{
  masked_env <- env(caller_env(), .qux = "QUX")

  englue(
    text,
    env = masked_env,
    error_arg = "text",
    error_call = current_env()
  )
\}

# Users can then use your wrapper as they would use `englue()`:
fn <- function(x) \{
  foo <- "FOO"
  my_englue("\{\{ x \}\}_\{.qux\}_\{foo\}")
\}

fn(bar)
#> [1] "bar_QUX_FOO"
}\if{html}{\out{</div>}}

If you are creating a low level package on top of englue(), you
should also consider exposing \code{env}, \code{error_arg} and \code{error_call}
in your \code{englue()} wrapper so users can wrap your wrapper.
}

\examples{
g <- function(var) englue("{{ var }}")
g(cyl)
g(1 + 1)
g(!!letters)

# These are equivalent to
as_label(quote(cyl))
as_label(quote(1 + 1))
as_label(letters)

}
\seealso{
\itemize{
\item \ifelse{html}{\link[=topic-inject]{Injecting with !!, !!!, and glue syntax}}{\link[=topic-inject]{Injecting with !!, !!!, and glue syntax}}
}
}
