% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/visualization.R
\name{AugmentPlot}
\alias{AugmentPlot}
\title{Augments ggplot2-based plot with a PNG image.}
\usage{
AugmentPlot(plot, width = 10, height = 10, dpi = 100)
}
\arguments{
\item{plot}{A ggplot object}

\item{width, height}{Width and height of PNG version of plot}

\item{dpi}{Plot resolution}
}
\value{
A ggplot object
}
\description{
Creates "vector-friendly" plots. Does this by saving a copy of the plot as a PNG file,
then adding the PNG image with \code{\link[ggplot2]{annotation_raster}} to a blank plot
of the same dimensions as \code{plot}. Please note: original legends and axes will be lost
during augmentation.
}
\examples{
\dontrun{
data("pbmc_small")
plot <- DimPlot(object = pbmc_small)
AugmentPlot(plot = plot)
}

}
\concept{visualization}
