% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/get_skimmers.R
\name{get_default_skimmers}
\alias{get_default_skimmers}
\alias{get_one_default_skimmer}
\alias{get_default_skimmer_names}
\alias{get_one_default_skimmer_names}
\alias{get_sfl}
\title{View default skimmer names and functions}
\usage{
get_default_skimmers(skim_type = NULL)

get_one_default_skimmer(skim_type)

get_default_skimmer_names(skim_type = NULL)

get_one_default_skimmer_names(skim_type)

get_sfl(skim_type)
}
\arguments{
\item{skim_type}{The class of the column being skimmed.}
}
\description{
These utility functions look up the currently-available defaults for one or
more \code{skim_type}'s. They work with all defaults in the \code{skimr} package, as
well as the defaults in any package that extends \code{skimr}. See
\code{\link[=get_skimmers]{get_skimmers()}} for writing lookup methods for different.
}
\details{
The functions differ in return type and whether or not the result is in
a list. \code{\link[=get_default_skimmers]{get_default_skimmers()}} and \code{\link[=get_one_default_skimmer]{get_one_default_skimmer()}} return
functions. The former returns functions within a typed list, i.e.
\code{list(numeric = list(...functions...))}.

The functions differ in return type and whether or not the result is in
a list. \code{\link[=get_default_skimmer_names]{get_default_skimmer_names()}} and \code{\link[=get_one_default_skimmer_names]{get_one_default_skimmer_names()}}
return a list of character vectors or a single character vector.

\code{\link[=get_sfl]{get_sfl()}} returns the skimmer function list for a particular \code{skim_type}.
It differs from \code{\link[=get_default_skimmers]{get_default_skimmers()}} in that the returned \code{sfl} contains
a list of functions and a \code{skim_type}.
}
\section{Functions}{
\itemize{
\item \code{get_one_default_skimmer()}: Get the functions associated with one
\code{skim_type}.

\item \code{get_default_skimmer_names()}: Get the names of the functions used in one
or more \code{skim_type}'s.

\item \code{get_one_default_skimmer_names()}: Get the names of the functions used in one
\code{skim_type}.

\item \code{get_sfl()}: Get the \code{sfl} for a \code{skim_type}.

}}
