% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/svTestData.R
\name{svTestData}
\alias{svTestData}
\alias{is.svTestData}
\alias{stats}
\alias{stats.svTestData}
\alias{print.svTestData}
\alias{summary.svTestData}
\alias{protocol_junit.svTestData}
\title{Objects of class 'svTestData' contain results from running a test}
\usage{
is.svTestData(x)

stats(object, ...)

\method{stats}{svTestData}(object, ...)

\method{print}{svTestData}(x, all = FALSE, header = TRUE, file = "", append = FALSE, ...)

\method{summary}{svTestData}(object, header = TRUE, file = "", append = FALSE, ...)

\method{protocol_junit}{svTestData}(object, ...)
}
\arguments{
\item{x}{Any kind of object, or a 'svTestData' object in the case of
\code{\link[=print]{print()}}.}

\item{object}{A 'svTestData' object.}

\item{...}{Further arguments to pass to methods. Not used yet.}

\item{all}{Do we print concise report for all test, or only for the tests
that fail or produce an error?}

\item{header}{Do we print a header or not?}

\item{file}{Character. The path to the file where to write the report. If
\code{file = ""}, the report is output to the console.}

\item{append}{Do we append to this file?}
}
\value{
\code{\link[=is.svTestData]{is.svTestData()}} returns \code{TRUE} if the object is an 'svTestData'. The
various methods serve to extract or print content in the object.
}
\description{
The 'svTestData' contains results of test run. The \code{checkxxx()} functions and
the \code{runTest()} method generate one such object which is located in the
\code{.Log} object in \code{.GlobalEnv}. It is then possible to display and report
information it contains in various ways to analyze the results.
}
\examples{
foo <- function(x, y = 2)
  return(x * y)
is.test(foo)  # No
# Create test cases for this function
test(foo) <- function() {
  checkEqualsNumeric(4, foo(2))
  checkEqualsNumeric(5, foo(2, 3))
  checkEqualsNumeric(5, foo(nonexists))
}
# Generate a 'svTestData' object by running the test
obj <- runTest(foo)  # Equivalent to runTest(test(foo)), but shorter
obj
summary(obj)
stats(obj)
is.svTestData(obj)

rm(foo, obj)
}
\seealso{
\code{\link[=svTest]{svTest()}}, \code{\link[=is.svSuiteData]{is.svSuiteData()}}, \code{\link[=Log]{Log()}}, \code{\link[=checkEquals]{checkEquals()}}
}
\author{
Philippe Grosjean
}
\concept{unit testing}
\keyword{utilities}
