% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/tween_components.R
\name{tween_components}
\alias{tween_components}
\title{Interpolate individual component}
\usage{
tween_components(
  .data,
  ease,
  nframes,
  time,
  id = NULL,
  range = NULL,
  enter = NULL,
  exit = NULL,
  enter_length = 0,
  exit_length = 0
)
}
\arguments{
\item{.data}{A data.frame with components at different stages}

\item{ease}{The easing function to use. Either a single string or one for
each column in the data set.}

\item{nframes}{The number of frames to calculate for the tween}

\item{time}{An unquoted expression giving the timepoint for the different
stages of the components. Will be evaluated in the context of \code{.data} so can
refer to a column from that}

\item{id}{An unquoted expression giving the component id for each row. Will
be evaluated in the context of \code{.data} so can refer to a column from that}

\item{range}{The range of time points to include in the tween. If \code{NULL} it
will use the range of \code{time}}

\item{enter, exit}{functions that calculate a start state for new observations
that appear in \code{to} or an end state for observations that are not present in
\code{to}. If \code{NULL} the new/old observations will not be part of the tween. The
function gets a data.frame with either the start state of the exiting
observations, or the end state of the entering observations and must return
a modified version of that data.frame. See the \emph{Match, Enter, and Exit}
section for more information.}

\item{enter_length, exit_length}{The lenght of the opening and closing
transitions if \code{enter} and/or \code{exit} is given. Measured in the same units as
\code{time}}
}
\value{
A data.frame with the same columns as \code{.data} along with \code{.id} giving
the component id, \code{.phase} giving the state of each component in each frame,
and \code{.frame} giving the frame membership of each row.
}
\description{
This function is much like \code{\link[=tween_elements]{tween_elements()}} but with a slightly different
syntax and support for many of the newer features such as enter/exits and
tween phase identification. Furthermore it uses tidy evaluation for time and
id, making it easier to change these on the fly. The biggest change in terms
of functionality compared to \code{tween_elements()} is that the easing function
is now given per column and not per row. If different easing functions are
needed for each transition then \code{tween_elements()} is needed.
}
\examples{

from_zero <- function(x) {x$x <- 0; x}

data <- data.frame(
  x = c(1, 2, 2, 1, 2, 2),
  y = c(1, 2, 2, 2, 1, 1),
  time = c(1, 4, 10, 4, 8, 10),
  id = c(1, 1, 1, 2, 2, 2)
)

data <- tween_components(data, 'cubic-in-out', nframes = 100, time = time,
                         id = id, enter = from_zero, enter_length = 4)

}
\seealso{
Other data.frame tween: 
\code{\link{tween_along}()},
\code{\link{tween_appear}()},
\code{\link{tween_elements}()},
\code{\link{tween_events}()},
\code{\link{tween_states}()}
}
\concept{data.frame tween}
