# SPDX-License-Identifier: BSD-3-Clause
#
# Copyright 2022 Raritan Inc. All rights reserved.
#
# This file was generated by IdlC from TimerEventManager.idl.

use strict;

package Raritan::RPC::event::TimerEventManager_2_0_0;

use parent qw(Raritan::RPC::RemoteObject);

use constant typeId => "event.TimerEventManager:2.0.0";

sub new {
    my ($class, $agent, $rid, $typeId) = @_;
    $typeId = $typeId || Raritan::RPC::event::TimerEventManager_2_0_0::typeId;
    return $class->SUPER::new($agent, $rid, $typeId);
}

use constant NO_ERROR => 0;

use constant ERR_INVALID_SCHEDULE => 1;

use constant ERR_UNKNOWN_EVENT_ID => 2;

use constant ERR_CREATE_EVENT_ID_FAILED => 3;

use constant ERR_MAX_TIMERS_CREATED => 4;

use constant JAN => 1;

use constant FEB => 2;

use constant MAR => 3;

use constant APR => 4;

use constant MAY => 5;

use constant JUN => 6;

use constant JUL => 7;

use constant AUG => 8;

use constant SEP => 9;

use constant OCT => 10;

use constant NOV => 11;

use constant DEC => 12;

use constant SUN => 0;

use constant MON => 1;

use constant TUE => 2;

use constant WED => 3;

use constant THU => 4;

use constant FRI => 5;

use constant SAT => 6;

use Raritan::RPC::event::TimerEventManager_2_0_0::Schedule;

sub addTimerEvent($$$) {
    my ($self, $schedule, $eventId) = @_;
    my $agent = $self->{'agent'};
    my $args = {};
    $args->{'schedule'} = Raritan::RPC::event::TimerEventManager_2_0_0::Schedule::encode($schedule);
    my $rsp = $agent->json_rpc($self->{'rid'}, 'addTimerEvent', $args);
    $$eventId = [];
    for (my $i0 = 0; $i0 <= $#{$rsp->{'eventId'}}; $i0++) {
        $$eventId->[$i0] = $rsp->{'eventId'}->[$i0];
    }
    my $_ret_;
    $_ret_ = $rsp->{'_ret_'};
    return $_ret_;
}

use Raritan::RPC::event::TimerEventManager_2_0_0::Schedule;

sub modifyTimerEvent($$$) {
    my ($self, $eventId, $schedule) = @_;
    my $agent = $self->{'agent'};
    my $args = {};
    $args->{'eventId'} = [];
    for (my $i0 = 0; $i0 <= $#{$eventId}; $i0++) {
        $args->{'eventId'}->[$i0] = "$eventId->[$i0]";
    }
    $args->{'schedule'} = Raritan::RPC::event::TimerEventManager_2_0_0::Schedule::encode($schedule);
    my $rsp = $agent->json_rpc($self->{'rid'}, 'modifyTimerEvent', $args);
    my $_ret_;
    $_ret_ = $rsp->{'_ret_'};
    return $_ret_;
}

sub deleteTimerEvent($$) {
    my ($self, $eventId) = @_;
    my $agent = $self->{'agent'};
    my $args = {};
    $args->{'eventId'} = [];
    for (my $i0 = 0; $i0 <= $#{$eventId}; $i0++) {
        $args->{'eventId'}->[$i0] = "$eventId->[$i0]";
    }
    my $rsp = $agent->json_rpc($self->{'rid'}, 'deleteTimerEvent', $args);
    my $_ret_;
    $_ret_ = $rsp->{'_ret_'};
    return $_ret_;
}

use Raritan::RPC::event::TimerEventManager_2_0_0::TimerEvent;

sub listTimerEvents($) {
    my ($self) = @_;
    my $agent = $self->{'agent'};
    my $args = {};
    my $rsp = $agent->json_rpc($self->{'rid'}, 'listTimerEvents', $args);
    my $_ret_;
    $_ret_ = [];
    for (my $i0 = 0; $i0 <= $#{$rsp->{'_ret_'}}; $i0++) {
        $_ret_->[$i0] = Raritan::RPC::event::TimerEventManager_2_0_0::TimerEvent::decode($agent, $rsp->{'_ret_'}->[$i0]);
    }
    return $_ret_;
}

Raritan::RPC::Registry::registerProxyClass('event.TimerEventManager', 2, 0, 0, 'Raritan::RPC::event::TimerEventManager_2_0_0');
1;
