#![doc = r"Note: This module was autogenerated by num-format-dev."]
use crate::error::Error;
use crate::format::Format;
use crate::grouping::Grouping;
use crate::strings::{DecimalStr, InfinityStr, MinusSignStr, NanStr, PlusSignStr, SeparatorStr};
use core::str::FromStr;
const AVAILABLE_NAMES: [&'static str; 538usize] = [
    "af",
    "af-NA",
    "agq",
    "ak",
    "am",
    "ar",
    "ar-AE",
    "ar-BH",
    "ar-DJ",
    "ar-DZ",
    "ar-EG",
    "ar-EH",
    "ar-ER",
    "ar-IL",
    "ar-IQ",
    "ar-JO",
    "ar-KM",
    "ar-KW",
    "ar-LB",
    "ar-LY",
    "ar-MA",
    "ar-MR",
    "ar-OM",
    "ar-PS",
    "ar-QA",
    "ar-SA",
    "ar-SD",
    "ar-SO",
    "ar-SS",
    "ar-SY",
    "ar-TD",
    "ar-TN",
    "ar-YE",
    "as",
    "asa",
    "ast",
    "az",
    "az-Cyrl",
    "az-Latn",
    "bas",
    "be",
    "bem",
    "bez",
    "bg",
    "bm",
    "bn",
    "bn-IN",
    "bo",
    "bo-IN",
    "br",
    "brx",
    "bs",
    "bs-Cyrl",
    "bs-Latn",
    "ca",
    "ca-AD",
    "ca-ES-VALENCIA",
    "ca-FR",
    "ca-IT",
    "ccp",
    "ccp-IN",
    "ce",
    "cgg",
    "chr",
    "ckb",
    "ckb-IR",
    "cs",
    "cu",
    "cy",
    "da",
    "da-GL",
    "dav",
    "de",
    "de-AT",
    "de-BE",
    "de-CH",
    "de-IT",
    "de-LI",
    "de-LU",
    "dje",
    "dsb",
    "dua",
    "dyo",
    "dz",
    "ebu",
    "ee",
    "ee-TG",
    "el",
    "el-CY",
    "en",
    "en-001",
    "en-150",
    "en-AG",
    "en-AI",
    "en-AS",
    "en-AT",
    "en-AU",
    "en-BB",
    "en-BE",
    "en-BI",
    "en-BM",
    "en-BS",
    "en-BW",
    "en-BZ",
    "en-CA",
    "en-CC",
    "en-CH",
    "en-CK",
    "en-CM",
    "en-CX",
    "en-CY",
    "en-DE",
    "en-DG",
    "en-DK",
    "en-DM",
    "en-ER",
    "en-FI",
    "en-FJ",
    "en-FK",
    "en-FM",
    "en-GB",
    "en-GD",
    "en-GG",
    "en-GH",
    "en-GI",
    "en-GM",
    "en-GU",
    "en-GY",
    "en-HK",
    "en-IE",
    "en-IL",
    "en-IM",
    "en-IN",
    "en-IO",
    "en-JE",
    "en-JM",
    "en-KE",
    "en-KI",
    "en-KN",
    "en-KY",
    "en-LC",
    "en-LR",
    "en-LS",
    "en-MG",
    "en-MH",
    "en-MO",
    "en-MP",
    "en-MS",
    "en-MT",
    "en-MU",
    "en-MW",
    "en-MY",
    "en-NA",
    "en-NF",
    "en-NG",
    "en-NL",
    "en-NR",
    "en-NU",
    "en-NZ",
    "en-PG",
    "en-PH",
    "en-PK",
    "en-PN",
    "en-PR",
    "en-PW",
    "en-RW",
    "en-SB",
    "en-SC",
    "en-SD",
    "en-SE",
    "en-SG",
    "en-SH",
    "en-SI",
    "en-SL",
    "en-SS",
    "en-SX",
    "en-SZ",
    "en-TC",
    "en-TK",
    "en-TO",
    "en-TT",
    "en-TV",
    "en-TZ",
    "en-UG",
    "en-UM",
    "en-US-POSIX",
    "en-VC",
    "en-VG",
    "en-VI",
    "en-VU",
    "en-WS",
    "en-ZA",
    "en-ZM",
    "en-ZW",
    "eo",
    "es",
    "es-419",
    "es-AR",
    "es-BO",
    "es-BR",
    "es-BZ",
    "es-CL",
    "es-CO",
    "es-CR",
    "es-CU",
    "es-DO",
    "es-EA",
    "es-EC",
    "es-GQ",
    "es-GT",
    "es-HN",
    "es-IC",
    "es-MX",
    "es-NI",
    "es-PA",
    "es-PE",
    "es-PH",
    "es-PR",
    "es-PY",
    "es-SV",
    "es-US",
    "es-UY",
    "es-VE",
    "et",
    "eu",
    "ewo",
    "fa",
    "fa-AF",
    "ff",
    "ff-Latn",
    "ff-Latn-BF",
    "ff-Latn-CM",
    "ff-Latn-GH",
    "ff-Latn-GM",
    "ff-Latn-GN",
    "ff-Latn-GW",
    "ff-Latn-LR",
    "ff-Latn-MR",
    "ff-Latn-NE",
    "ff-Latn-NG",
    "ff-Latn-SL",
    "fi",
    "fil",
    "fo",
    "fo-DK",
    "fr",
    "fr-BE",
    "fr-BF",
    "fr-BI",
    "fr-BJ",
    "fr-BL",
    "fr-CA",
    "fr-CD",
    "fr-CF",
    "fr-CG",
    "fr-CH",
    "fr-CI",
    "fr-CM",
    "fr-DJ",
    "fr-DZ",
    "fr-GA",
    "fr-GF",
    "fr-GN",
    "fr-GP",
    "fr-GQ",
    "fr-HT",
    "fr-KM",
    "fr-LU",
    "fr-MA",
    "fr-MC",
    "fr-MF",
    "fr-MG",
    "fr-ML",
    "fr-MQ",
    "fr-MR",
    "fr-MU",
    "fr-NC",
    "fr-NE",
    "fr-PF",
    "fr-PM",
    "fr-RE",
    "fr-RW",
    "fr-SC",
    "fr-SN",
    "fr-SY",
    "fr-TD",
    "fr-TG",
    "fr-TN",
    "fr-VU",
    "fr-WF",
    "fr-YT",
    "fur",
    "fy",
    "ga",
    "gd",
    "gl",
    "gsw",
    "gsw-FR",
    "gsw-LI",
    "gu",
    "guz",
    "gv",
    "ha",
    "ha-GH",
    "ha-NE",
    "haw",
    "he",
    "hi",
    "hr",
    "hr-BA",
    "hsb",
    "hu",
    "hy",
    "ia",
    "id",
    "ig",
    "ii",
    "is",
    "it",
    "it-CH",
    "it-SM",
    "it-VA",
    "ja",
    "jgo",
    "jmc",
    "jv",
    "ka",
    "kab",
    "kam",
    "kde",
    "kea",
    "khq",
    "ki",
    "kk",
    "kkj",
    "kl",
    "kln",
    "km",
    "kn",
    "ko",
    "ko-KP",
    "kok",
    "ks",
    "ksb",
    "ksf",
    "ksh",
    "ku",
    "kw",
    "ky",
    "lag",
    "lb",
    "lg",
    "lkt",
    "ln",
    "ln-AO",
    "ln-CF",
    "ln-CG",
    "lo",
    "lrc",
    "lrc-IQ",
    "lt",
    "lu",
    "luo",
    "luy",
    "lv",
    "mas",
    "mas-TZ",
    "mer",
    "mfe",
    "mg",
    "mgh",
    "mgo",
    "mi",
    "mk",
    "ml",
    "mn",
    "mr",
    "ms",
    "ms-BN",
    "ms-SG",
    "mt",
    "mua",
    "my",
    "mzn",
    "naq",
    "nb",
    "nb-SJ",
    "nd",
    "nds",
    "nds-NL",
    "ne",
    "ne-IN",
    "nl",
    "nl-AW",
    "nl-BE",
    "nl-BQ",
    "nl-CW",
    "nl-SR",
    "nl-SX",
    "nmg",
    "nn",
    "nnh",
    "nus",
    "nyn",
    "om",
    "om-KE",
    "or",
    "os",
    "os-RU",
    "pa",
    "pa-Arab",
    "pa-Guru",
    "pl",
    "prg",
    "ps",
    "pt",
    "pt-AO",
    "pt-CH",
    "pt-CV",
    "pt-GQ",
    "pt-GW",
    "pt-LU",
    "pt-MO",
    "pt-MZ",
    "pt-PT",
    "pt-ST",
    "pt-TL",
    "qu",
    "qu-BO",
    "qu-EC",
    "rm",
    "rn",
    "ro",
    "ro-MD",
    "rof",
    "root",
    "ru",
    "ru-BY",
    "ru-KG",
    "ru-KZ",
    "ru-MD",
    "ru-UA",
    "rw",
    "rwk",
    "sah",
    "saq",
    "sbp",
    "sd",
    "se",
    "se-FI",
    "se-SE",
    "seh",
    "ses",
    "sg",
    "shi",
    "shi-Latn",
    "shi-Tfng",
    "si",
    "sk",
    "sl",
    "smn",
    "sn",
    "so",
    "so-DJ",
    "so-ET",
    "so-KE",
    "sq",
    "sq-MK",
    "sq-XK",
    "sr",
    "sr-Cyrl",
    "sr-Cyrl-BA",
    "sr-Cyrl-ME",
    "sr-Cyrl-XK",
    "sr-Latn",
    "sr-Latn-BA",
    "sr-Latn-ME",
    "sr-Latn-XK",
    "sv",
    "sv-AX",
    "sv-FI",
    "sw",
    "sw-CD",
    "sw-KE",
    "sw-UG",
    "ta",
    "ta-LK",
    "ta-MY",
    "ta-SG",
    "te",
    "teo",
    "teo-KE",
    "tg",
    "th",
    "ti",
    "ti-ER",
    "tk",
    "to",
    "tr",
    "tr-CY",
    "tt",
    "twq",
    "tzm",
    "ug",
    "uk",
    "ur",
    "ur-IN",
    "uz",
    "uz-Arab",
    "uz-Cyrl",
    "uz-Latn",
    "vai",
    "vai-Latn",
    "vai-Vaii",
    "vi",
    "vo",
    "vun",
    "wae",
    "wo",
    "xh",
    "xog",
    "yav",
    "yi",
    "yo",
    "yo-BJ",
    "yue",
    "yue-Hans",
    "yue-Hant",
    "zgh",
    "zh",
    "zh-Hans",
    "zh-Hans-HK",
    "zh-Hans-MO",
    "zh-Hans-SG",
    "zh-Hant",
    "zh-Hant-HK",
    "zh-Hant-MO",
    "zu",
];
#[doc = r"<b><u>A key type</u></b>. Represents formats from the [Unicode Consortium]'s"]
#[doc = r"[Common Locale Data Repository (CLDR)]. Implements [`Format`]."]
#[doc = r""]
#[doc = r"# Example"]
#[doc = r"```"]
#[doc = r"use num_format::{Buffer, Locale};"]
#[doc = r""]
#[doc = r"fn main() {"]
#[doc = r"    // Using the French format from the Unicode Common Locale Data Repository..."]
#[doc = r"    let mut buf = Buffer::new();"]
#[doc = r"    buf.write_formatted(&(-1000000), &Locale::fr);"]
#[doc = r#"    assert_eq!("-1\u{202f}000\u{202f}000", buf.as_str());"#]
#[doc = r""]
#[doc = r"    // Note:"]
#[doc = r#"    // U+202F is the "NARROW NO-BREAK SPACE" code point."#]
#[doc = r"    // When displayed to the screen, it looks like a space."]
#[doc = r"}"]
#[doc = r"```"]
#[doc = r""]
#[doc = r" [`Format`]: trait.Format.html"]
#[doc = r" [Common Locale Data Repository (CLDR)]: https://en.wikipedia.org/wiki/Common_Locale_Data_Repository"]
#[doc = r" [Unicode Consortium]: https://en.wikipedia.org/wiki/Unicode_Consortium"]
#[allow(non_camel_case_types, missing_docs)]
#[derive(Copy, Clone, Debug, Eq, PartialEq, Ord, PartialOrd, Hash)]
#[cfg_attr(feature = "with-serde", derive(Serialize, Deserialize))]
pub enum Locale {
    af,
    af_NA,
    agq,
    ak,
    am,
    ar,
    ar_AE,
    ar_BH,
    ar_DJ,
    ar_DZ,
    ar_EG,
    ar_EH,
    ar_ER,
    ar_IL,
    ar_IQ,
    ar_JO,
    ar_KM,
    ar_KW,
    ar_LB,
    ar_LY,
    ar_MA,
    ar_MR,
    ar_OM,
    ar_PS,
    ar_QA,
    ar_SA,
    ar_SD,
    ar_SO,
    ar_SS,
    ar_SY,
    ar_TD,
    ar_TN,
    ar_YE,
    as_,
    asa,
    ast,
    az,
    az_Cyrl,
    az_Latn,
    bas,
    be,
    bem,
    bez,
    bg,
    bm,
    bn,
    bn_IN,
    bo,
    bo_IN,
    br,
    brx,
    bs,
    bs_Cyrl,
    bs_Latn,
    ca,
    ca_AD,
    ca_ES_VALENCIA,
    ca_FR,
    ca_IT,
    ccp,
    ccp_IN,
    ce,
    cgg,
    chr,
    ckb,
    ckb_IR,
    cs,
    cu,
    cy,
    da,
    da_GL,
    dav,
    de,
    de_AT,
    de_BE,
    de_CH,
    de_IT,
    de_LI,
    de_LU,
    dje,
    dsb,
    dua,
    dyo,
    dz,
    ebu,
    ee,
    ee_TG,
    el,
    el_CY,
    en,
    en_001,
    en_150,
    en_AG,
    en_AI,
    en_AS,
    en_AT,
    en_AU,
    en_BB,
    en_BE,
    en_BI,
    en_BM,
    en_BS,
    en_BW,
    en_BZ,
    en_CA,
    en_CC,
    en_CH,
    en_CK,
    en_CM,
    en_CX,
    en_CY,
    en_DE,
    en_DG,
    en_DK,
    en_DM,
    en_ER,
    en_FI,
    en_FJ,
    en_FK,
    en_FM,
    en_GB,
    en_GD,
    en_GG,
    en_GH,
    en_GI,
    en_GM,
    en_GU,
    en_GY,
    en_HK,
    en_IE,
    en_IL,
    en_IM,
    en_IN,
    en_IO,
    en_JE,
    en_JM,
    en_KE,
    en_KI,
    en_KN,
    en_KY,
    en_LC,
    en_LR,
    en_LS,
    en_MG,
    en_MH,
    en_MO,
    en_MP,
    en_MS,
    en_MT,
    en_MU,
    en_MW,
    en_MY,
    en_NA,
    en_NF,
    en_NG,
    en_NL,
    en_NR,
    en_NU,
    en_NZ,
    en_PG,
    en_PH,
    en_PK,
    en_PN,
    en_PR,
    en_PW,
    en_RW,
    en_SB,
    en_SC,
    en_SD,
    en_SE,
    en_SG,
    en_SH,
    en_SI,
    en_SL,
    en_SS,
    en_SX,
    en_SZ,
    en_TC,
    en_TK,
    en_TO,
    en_TT,
    en_TV,
    en_TZ,
    en_UG,
    en_UM,
    en_US_POSIX,
    en_VC,
    en_VG,
    en_VI,
    en_VU,
    en_WS,
    en_ZA,
    en_ZM,
    en_ZW,
    eo,
    es,
    es_419,
    es_AR,
    es_BO,
    es_BR,
    es_BZ,
    es_CL,
    es_CO,
    es_CR,
    es_CU,
    es_DO,
    es_EA,
    es_EC,
    es_GQ,
    es_GT,
    es_HN,
    es_IC,
    es_MX,
    es_NI,
    es_PA,
    es_PE,
    es_PH,
    es_PR,
    es_PY,
    es_SV,
    es_US,
    es_UY,
    es_VE,
    et,
    eu,
    ewo,
    fa,
    fa_AF,
    ff,
    ff_Latn,
    ff_Latn_BF,
    ff_Latn_CM,
    ff_Latn_GH,
    ff_Latn_GM,
    ff_Latn_GN,
    ff_Latn_GW,
    ff_Latn_LR,
    ff_Latn_MR,
    ff_Latn_NE,
    ff_Latn_NG,
    ff_Latn_SL,
    fi,
    fil,
    fo,
    fo_DK,
    fr,
    fr_BE,
    fr_BF,
    fr_BI,
    fr_BJ,
    fr_BL,
    fr_CA,
    fr_CD,
    fr_CF,
    fr_CG,
    fr_CH,
    fr_CI,
    fr_CM,
    fr_DJ,
    fr_DZ,
    fr_GA,
    fr_GF,
    fr_GN,
    fr_GP,
    fr_GQ,
    fr_HT,
    fr_KM,
    fr_LU,
    fr_MA,
    fr_MC,
    fr_MF,
    fr_MG,
    fr_ML,
    fr_MQ,
    fr_MR,
    fr_MU,
    fr_NC,
    fr_NE,
    fr_PF,
    fr_PM,
    fr_RE,
    fr_RW,
    fr_SC,
    fr_SN,
    fr_SY,
    fr_TD,
    fr_TG,
    fr_TN,
    fr_VU,
    fr_WF,
    fr_YT,
    fur,
    fy,
    ga,
    gd,
    gl,
    gsw,
    gsw_FR,
    gsw_LI,
    gu,
    guz,
    gv,
    ha,
    ha_GH,
    ha_NE,
    haw,
    he,
    hi,
    hr,
    hr_BA,
    hsb,
    hu,
    hy,
    ia,
    id,
    ig,
    ii,
    is,
    it,
    it_CH,
    it_SM,
    it_VA,
    ja,
    jgo,
    jmc,
    jv,
    ka,
    kab,
    kam,
    kde,
    kea,
    khq,
    ki,
    kk,
    kkj,
    kl,
    kln,
    km,
    kn,
    ko,
    ko_KP,
    kok,
    ks,
    ksb,
    ksf,
    ksh,
    ku,
    kw,
    ky,
    lag,
    lb,
    lg,
    lkt,
    ln,
    ln_AO,
    ln_CF,
    ln_CG,
    lo,
    lrc,
    lrc_IQ,
    lt,
    lu,
    luo,
    luy,
    lv,
    mas,
    mas_TZ,
    mer,
    mfe,
    mg,
    mgh,
    mgo,
    mi,
    mk,
    ml,
    mn,
    mr,
    ms,
    ms_BN,
    ms_SG,
    mt,
    mua,
    my,
    mzn,
    naq,
    nb,
    nb_SJ,
    nd,
    nds,
    nds_NL,
    ne,
    ne_IN,
    nl,
    nl_AW,
    nl_BE,
    nl_BQ,
    nl_CW,
    nl_SR,
    nl_SX,
    nmg,
    nn,
    nnh,
    nus,
    nyn,
    om,
    om_KE,
    or,
    os,
    os_RU,
    pa,
    pa_Arab,
    pa_Guru,
    pl,
    prg,
    ps,
    pt,
    pt_AO,
    pt_CH,
    pt_CV,
    pt_GQ,
    pt_GW,
    pt_LU,
    pt_MO,
    pt_MZ,
    pt_PT,
    pt_ST,
    pt_TL,
    qu,
    qu_BO,
    qu_EC,
    rm,
    rn,
    ro,
    ro_MD,
    rof,
    root,
    ru,
    ru_BY,
    ru_KG,
    ru_KZ,
    ru_MD,
    ru_UA,
    rw,
    rwk,
    sah,
    saq,
    sbp,
    sd,
    se,
    se_FI,
    se_SE,
    seh,
    ses,
    sg,
    shi,
    shi_Latn,
    shi_Tfng,
    si,
    sk,
    sl,
    smn,
    sn,
    so,
    so_DJ,
    so_ET,
    so_KE,
    sq,
    sq_MK,
    sq_XK,
    sr,
    sr_Cyrl,
    sr_Cyrl_BA,
    sr_Cyrl_ME,
    sr_Cyrl_XK,
    sr_Latn,
    sr_Latn_BA,
    sr_Latn_ME,
    sr_Latn_XK,
    sv,
    sv_AX,
    sv_FI,
    sw,
    sw_CD,
    sw_KE,
    sw_UG,
    ta,
    ta_LK,
    ta_MY,
    ta_SG,
    te,
    teo,
    teo_KE,
    tg,
    th,
    ti,
    ti_ER,
    tk,
    to,
    tr,
    tr_CY,
    tt,
    twq,
    tzm,
    ug,
    uk,
    ur,
    ur_IN,
    uz,
    uz_Arab,
    uz_Cyrl,
    uz_Latn,
    vai,
    vai_Latn,
    vai_Vaii,
    vi,
    vo,
    vun,
    wae,
    wo,
    xh,
    xog,
    yav,
    yi,
    yo,
    yo_BJ,
    yue,
    yue_Hans,
    yue_Hant,
    zgh,
    zh,
    zh_Hans,
    zh_Hans_HK,
    zh_Hans_MO,
    zh_Hans_SG,
    zh_Hant,
    zh_Hant_HK,
    zh_Hant_MO,
    zu,
}
impl Locale {
    #[doc = r" Constructs a [`Locale`] from its name. For a list of available names, see"]
    #[doc = r" [`available_names`]."]
    #[doc = r""]
    #[doc = r" # Errors"]
    #[doc = r""]
    #[doc = r" Returns an error if the name provided cannot be"]
    #[doc = r" parsed into a [`Locale`]."]
    #[doc = r""]
    #[doc = r" [`available_names`]: enum.Locale.html#method.available_names"]
    #[doc = r" [`Locale`]: enum.Locale.html"]
    pub fn from_name<S>(name: S) -> Result<Locale, Error>
    where
        S: AsRef<str>,
    {
        let name = name.as_ref();
        name.parse::<Locale>()
    }
    #[doc = r" Returns a static slice of all available names."]
    pub fn available_names() -> &'static [&'static str] {
        &AVAILABLE_NAMES
    }
    #[doc = r" Returns the locale's decimal representation."]
    pub fn decimal(&self) -> &'static str {
        use self::Locale::*;
        match self {
            af => ",",
            af_NA => ",",
            agq => ",",
            ak => ".",
            am => ".",
            ar => "\u{66b}",
            ar_AE => "\u{66b}",
            ar_BH => "\u{66b}",
            ar_DJ => "\u{66b}",
            ar_DZ => ",",
            ar_EG => "\u{66b}",
            ar_EH => ".",
            ar_ER => "\u{66b}",
            ar_IL => "\u{66b}",
            ar_IQ => "\u{66b}",
            ar_JO => "\u{66b}",
            ar_KM => "\u{66b}",
            ar_KW => "\u{66b}",
            ar_LB => "\u{66b}",
            ar_LY => ",",
            ar_MA => ",",
            ar_MR => "\u{66b}",
            ar_OM => "\u{66b}",
            ar_PS => "\u{66b}",
            ar_QA => "\u{66b}",
            ar_SA => "\u{66b}",
            ar_SD => "\u{66b}",
            ar_SO => "\u{66b}",
            ar_SS => "\u{66b}",
            ar_SY => "\u{66b}",
            ar_TD => "\u{66b}",
            ar_TN => ",",
            ar_YE => "\u{66b}",
            as_ => ".",
            asa => ".",
            ast => ",",
            az => ",",
            az_Cyrl => ",",
            az_Latn => ",",
            bas => ",",
            be => ",",
            bem => ".",
            bez => ".",
            bg => ",",
            bm => ".",
            bn => ".",
            bn_IN => ".",
            bo => ".",
            bo_IN => ".",
            br => ",",
            brx => ".",
            bs => ",",
            bs_Cyrl => ",",
            bs_Latn => ",",
            ca => ",",
            ca_AD => ",",
            ca_ES_VALENCIA => ",",
            ca_FR => ",",
            ca_IT => ",",
            ccp => ".",
            ccp_IN => ".",
            ce => ".",
            cgg => ".",
            chr => ".",
            ckb => "\u{66b}",
            ckb_IR => "\u{66b}",
            cs => ",",
            cu => ".",
            cy => ".",
            da => ",",
            da_GL => ",",
            dav => ".",
            de => ",",
            de_AT => ",",
            de_BE => ",",
            de_CH => ".",
            de_IT => ",",
            de_LI => ".",
            de_LU => ",",
            dje => ".",
            dsb => ",",
            dua => ",",
            dyo => ",",
            dz => ".",
            ebu => ".",
            ee => ".",
            ee_TG => ".",
            el => ",",
            el_CY => ",",
            en => ".",
            en_001 => ".",
            en_150 => ",",
            en_AG => ".",
            en_AI => ".",
            en_AS => ".",
            en_AT => ",",
            en_AU => ".",
            en_BB => ".",
            en_BE => ",",
            en_BI => ".",
            en_BM => ".",
            en_BS => ".",
            en_BW => ".",
            en_BZ => ".",
            en_CA => ".",
            en_CC => ".",
            en_CH => ",",
            en_CK => ".",
            en_CM => ".",
            en_CX => ".",
            en_CY => ".",
            en_DE => ",",
            en_DG => ".",
            en_DK => ",",
            en_DM => ".",
            en_ER => ".",
            en_FI => ",",
            en_FJ => ".",
            en_FK => ".",
            en_FM => ".",
            en_GB => ".",
            en_GD => ".",
            en_GG => ".",
            en_GH => ".",
            en_GI => ".",
            en_GM => ".",
            en_GU => ".",
            en_GY => ".",
            en_HK => ".",
            en_IE => ".",
            en_IL => ".",
            en_IM => ".",
            en_IN => ".",
            en_IO => ".",
            en_JE => ".",
            en_JM => ".",
            en_KE => ".",
            en_KI => ".",
            en_KN => ".",
            en_KY => ".",
            en_LC => ".",
            en_LR => ".",
            en_LS => ".",
            en_MG => ".",
            en_MH => ".",
            en_MO => ".",
            en_MP => ".",
            en_MS => ".",
            en_MT => ".",
            en_MU => ".",
            en_MW => ".",
            en_MY => ".",
            en_NA => ".",
            en_NF => ".",
            en_NG => ".",
            en_NL => ",",
            en_NR => ".",
            en_NU => ".",
            en_NZ => ".",
            en_PG => ".",
            en_PH => ".",
            en_PK => ".",
            en_PN => ".",
            en_PR => ".",
            en_PW => ".",
            en_RW => ".",
            en_SB => ".",
            en_SC => ".",
            en_SD => ".",
            en_SE => ",",
            en_SG => ".",
            en_SH => ".",
            en_SI => ",",
            en_SL => ".",
            en_SS => ".",
            en_SX => ".",
            en_SZ => ".",
            en_TC => ".",
            en_TK => ".",
            en_TO => ".",
            en_TT => ".",
            en_TV => ".",
            en_TZ => ".",
            en_UG => ".",
            en_UM => ".",
            en_US_POSIX => ".",
            en_VC => ".",
            en_VG => ".",
            en_VI => ".",
            en_VU => ".",
            en_WS => ".",
            en_ZA => ",",
            en_ZM => ".",
            en_ZW => ".",
            eo => ",",
            es => ",",
            es_419 => ".",
            es_AR => ",",
            es_BO => ",",
            es_BR => ".",
            es_BZ => ".",
            es_CL => ",",
            es_CO => ",",
            es_CR => ",",
            es_CU => ".",
            es_DO => ".",
            es_EA => ",",
            es_EC => ",",
            es_GQ => ",",
            es_GT => ".",
            es_HN => ".",
            es_IC => ",",
            es_MX => ".",
            es_NI => ".",
            es_PA => ".",
            es_PE => ".",
            es_PH => ",",
            es_PR => ".",
            es_PY => ",",
            es_SV => ".",
            es_US => ".",
            es_UY => ",",
            es_VE => ",",
            et => ",",
            eu => ",",
            ewo => ",",
            fa => "\u{66b}",
            fa_AF => "\u{66b}",
            ff => ",",
            ff_Latn => ",",
            ff_Latn_BF => ",",
            ff_Latn_CM => ",",
            ff_Latn_GH => ",",
            ff_Latn_GM => ",",
            ff_Latn_GN => ",",
            ff_Latn_GW => ",",
            ff_Latn_LR => ",",
            ff_Latn_MR => ",",
            ff_Latn_NE => ",",
            ff_Latn_NG => ",",
            ff_Latn_SL => ",",
            fi => ",",
            fil => ".",
            fo => ",",
            fo_DK => ",",
            fr => ",",
            fr_BE => ",",
            fr_BF => ",",
            fr_BI => ",",
            fr_BJ => ",",
            fr_BL => ",",
            fr_CA => ",",
            fr_CD => ",",
            fr_CF => ",",
            fr_CG => ",",
            fr_CH => ",",
            fr_CI => ",",
            fr_CM => ",",
            fr_DJ => ",",
            fr_DZ => ",",
            fr_GA => ",",
            fr_GF => ",",
            fr_GN => ",",
            fr_GP => ",",
            fr_GQ => ",",
            fr_HT => ",",
            fr_KM => ",",
            fr_LU => ",",
            fr_MA => ",",
            fr_MC => ",",
            fr_MF => ",",
            fr_MG => ",",
            fr_ML => ",",
            fr_MQ => ",",
            fr_MR => ",",
            fr_MU => ",",
            fr_NC => ",",
            fr_NE => ",",
            fr_PF => ",",
            fr_PM => ",",
            fr_RE => ",",
            fr_RW => ",",
            fr_SC => ",",
            fr_SN => ",",
            fr_SY => ",",
            fr_TD => ",",
            fr_TG => ",",
            fr_TN => ",",
            fr_VU => ",",
            fr_WF => ",",
            fr_YT => ",",
            fur => ",",
            fy => ",",
            ga => ".",
            gd => ".",
            gl => ",",
            gsw => ".",
            gsw_FR => ".",
            gsw_LI => ".",
            gu => ".",
            guz => ".",
            gv => ".",
            ha => ".",
            ha_GH => ".",
            ha_NE => ".",
            haw => ".",
            he => ".",
            hi => ".",
            hr => ",",
            hr_BA => ",",
            hsb => ",",
            hu => ",",
            hy => ",",
            ia => ",",
            id => ",",
            ig => ".",
            ii => ".",
            is => ",",
            it => ",",
            it_CH => ".",
            it_SM => ",",
            it_VA => ",",
            ja => ".",
            jgo => ",",
            jmc => ".",
            jv => ",",
            ka => ",",
            kab => ",",
            kam => ".",
            kde => ".",
            kea => ",",
            khq => ".",
            ki => ".",
            kk => ",",
            kkj => ",",
            kl => ",",
            kln => ".",
            km => ",",
            kn => ".",
            ko => ".",
            ko_KP => ".",
            kok => ".",
            ks => "\u{66b}",
            ksb => ".",
            ksf => ",",
            ksh => ",",
            ku => ",",
            kw => ".",
            ky => ",",
            lag => ".",
            lb => ",",
            lg => ".",
            lkt => ".",
            ln => ",",
            ln_AO => ",",
            ln_CF => ",",
            ln_CG => ",",
            lo => ",",
            lrc => "\u{66b}",
            lrc_IQ => "\u{66b}",
            lt => ",",
            lu => ",",
            luo => ".",
            luy => ".",
            lv => ",",
            mas => ".",
            mas_TZ => ".",
            mer => ".",
            mfe => ".",
            mg => ".",
            mgh => ",",
            mgo => ".",
            mi => ".",
            mk => ",",
            ml => ".",
            mn => ".",
            mr => ".",
            ms => ".",
            ms_BN => ",",
            ms_SG => ".",
            mt => ".",
            mua => ",",
            my => ".",
            mzn => "\u{66b}",
            naq => ".",
            nb => ",",
            nb_SJ => ",",
            nd => ".",
            nds => ".",
            nds_NL => ".",
            ne => ".",
            ne_IN => ".",
            nl => ",",
            nl_AW => ",",
            nl_BE => ",",
            nl_BQ => ",",
            nl_CW => ",",
            nl_SR => ",",
            nl_SX => ",",
            nmg => ",",
            nn => ",",
            nnh => ",",
            nus => ".",
            nyn => ".",
            om => ".",
            om_KE => ".",
            or => ".",
            os => ",",
            os_RU => ",",
            pa => ".",
            pa_Arab => "\u{66b}",
            pa_Guru => ".",
            pl => ",",
            prg => ".",
            ps => "\u{66b}",
            pt => ",",
            pt_AO => ",",
            pt_CH => ",",
            pt_CV => ",",
            pt_GQ => ",",
            pt_GW => ",",
            pt_LU => ",",
            pt_MO => ",",
            pt_MZ => ",",
            pt_PT => ",",
            pt_ST => ",",
            pt_TL => ",",
            qu => ".",
            qu_BO => ",",
            qu_EC => ".",
            rm => ".",
            rn => ",",
            ro => ",",
            ro_MD => ",",
            rof => ".",
            root => ".",
            ru => ",",
            ru_BY => ",",
            ru_KG => ",",
            ru_KZ => ",",
            ru_MD => ",",
            ru_UA => ",",
            rw => ",",
            rwk => ".",
            sah => ",",
            saq => ".",
            sbp => ".",
            sd => "\u{66b}",
            se => ",",
            se_FI => ",",
            se_SE => ",",
            seh => ",",
            ses => ".",
            sg => ",",
            shi => ",",
            shi_Latn => ",",
            shi_Tfng => ",",
            si => ".",
            sk => ",",
            sl => ",",
            smn => ",",
            sn => ".",
            so => ".",
            so_DJ => ".",
            so_ET => ".",
            so_KE => ".",
            sq => ",",
            sq_MK => ",",
            sq_XK => ",",
            sr => ",",
            sr_Cyrl => ",",
            sr_Cyrl_BA => ",",
            sr_Cyrl_ME => ",",
            sr_Cyrl_XK => ",",
            sr_Latn => ",",
            sr_Latn_BA => ",",
            sr_Latn_ME => ",",
            sr_Latn_XK => ",",
            sv => ",",
            sv_AX => ",",
            sv_FI => ",",
            sw => ".",
            sw_CD => ",",
            sw_KE => ".",
            sw_UG => ".",
            ta => ".",
            ta_LK => ".",
            ta_MY => ".",
            ta_SG => ".",
            te => ".",
            teo => ".",
            teo_KE => ".",
            tg => ",",
            th => ".",
            ti => ".",
            ti_ER => ".",
            tk => ",",
            to => ".",
            tr => ",",
            tr_CY => ",",
            tt => ",",
            twq => ".",
            tzm => ",",
            ug => ".",
            uk => ",",
            ur => ".",
            ur_IN => "\u{66b}",
            uz => ",",
            uz_Arab => "\u{66b}",
            uz_Cyrl => ",",
            uz_Latn => ",",
            vai => ".",
            vai_Latn => ".",
            vai_Vaii => ".",
            vi => ",",
            vo => ".",
            vun => ".",
            wae => ",",
            wo => ",",
            xh => ".",
            xog => ".",
            yav => ",",
            yi => ".",
            yo => ".",
            yo_BJ => ".",
            yue => ".",
            yue_Hans => ".",
            yue_Hant => ".",
            zgh => ",",
            zh => ".",
            zh_Hans => ".",
            zh_Hans_HK => ".",
            zh_Hans_MO => ".",
            zh_Hans_SG => ".",
            zh_Hant => ".",
            zh_Hant_HK => ".",
            zh_Hant_MO => ".",
            zu => ".",
        }
    }
    #[doc = r" Returns the locale's [`Grouping`]."]
    #[doc = r""]
    #[doc = r" [`Grouping`]: enum.Grouping.html"]
    pub fn grouping(&self) -> Grouping {
        use self::Grouping::*;
        use self::Locale::*;
        match self {
            af => Standard,
            af_NA => Standard,
            agq => Standard,
            ak => Standard,
            am => Standard,
            ar => Standard,
            ar_AE => Standard,
            ar_BH => Standard,
            ar_DJ => Standard,
            ar_DZ => Standard,
            ar_EG => Standard,
            ar_EH => Standard,
            ar_ER => Standard,
            ar_IL => Standard,
            ar_IQ => Standard,
            ar_JO => Standard,
            ar_KM => Standard,
            ar_KW => Standard,
            ar_LB => Standard,
            ar_LY => Standard,
            ar_MA => Standard,
            ar_MR => Standard,
            ar_OM => Standard,
            ar_PS => Standard,
            ar_QA => Standard,
            ar_SA => Standard,
            ar_SD => Standard,
            ar_SO => Standard,
            ar_SS => Standard,
            ar_SY => Standard,
            ar_TD => Standard,
            ar_TN => Standard,
            ar_YE => Standard,
            as_ => Indian,
            asa => Standard,
            ast => Standard,
            az => Standard,
            az_Cyrl => Standard,
            az_Latn => Standard,
            bas => Standard,
            be => Standard,
            bem => Standard,
            bez => Standard,
            bg => Standard,
            bm => Standard,
            bn => Indian,
            bn_IN => Indian,
            bo => Standard,
            bo_IN => Standard,
            br => Standard,
            brx => Indian,
            bs => Standard,
            bs_Cyrl => Standard,
            bs_Latn => Standard,
            ca => Standard,
            ca_AD => Standard,
            ca_ES_VALENCIA => Standard,
            ca_FR => Standard,
            ca_IT => Standard,
            ccp => Indian,
            ccp_IN => Indian,
            ce => Standard,
            cgg => Standard,
            chr => Standard,
            ckb => Standard,
            ckb_IR => Standard,
            cs => Standard,
            cu => Standard,
            cy => Standard,
            da => Standard,
            da_GL => Standard,
            dav => Standard,
            de => Standard,
            de_AT => Standard,
            de_BE => Standard,
            de_CH => Standard,
            de_IT => Standard,
            de_LI => Standard,
            de_LU => Standard,
            dje => Standard,
            dsb => Standard,
            dua => Standard,
            dyo => Standard,
            dz => Indian,
            ebu => Standard,
            ee => Standard,
            ee_TG => Standard,
            el => Standard,
            el_CY => Standard,
            en => Standard,
            en_001 => Standard,
            en_150 => Standard,
            en_AG => Standard,
            en_AI => Standard,
            en_AS => Standard,
            en_AT => Standard,
            en_AU => Standard,
            en_BB => Standard,
            en_BE => Standard,
            en_BI => Standard,
            en_BM => Standard,
            en_BS => Standard,
            en_BW => Standard,
            en_BZ => Standard,
            en_CA => Standard,
            en_CC => Standard,
            en_CH => Standard,
            en_CK => Standard,
            en_CM => Standard,
            en_CX => Standard,
            en_CY => Standard,
            en_DE => Standard,
            en_DG => Standard,
            en_DK => Standard,
            en_DM => Standard,
            en_ER => Standard,
            en_FI => Standard,
            en_FJ => Standard,
            en_FK => Standard,
            en_FM => Standard,
            en_GB => Standard,
            en_GD => Standard,
            en_GG => Standard,
            en_GH => Standard,
            en_GI => Standard,
            en_GM => Standard,
            en_GU => Standard,
            en_GY => Standard,
            en_HK => Standard,
            en_IE => Standard,
            en_IL => Standard,
            en_IM => Standard,
            en_IN => Indian,
            en_IO => Standard,
            en_JE => Standard,
            en_JM => Standard,
            en_KE => Standard,
            en_KI => Standard,
            en_KN => Standard,
            en_KY => Standard,
            en_LC => Standard,
            en_LR => Standard,
            en_LS => Standard,
            en_MG => Standard,
            en_MH => Standard,
            en_MO => Standard,
            en_MP => Standard,
            en_MS => Standard,
            en_MT => Standard,
            en_MU => Standard,
            en_MW => Standard,
            en_MY => Standard,
            en_NA => Standard,
            en_NF => Standard,
            en_NG => Standard,
            en_NL => Standard,
            en_NR => Standard,
            en_NU => Standard,
            en_NZ => Standard,
            en_PG => Standard,
            en_PH => Standard,
            en_PK => Standard,
            en_PN => Standard,
            en_PR => Standard,
            en_PW => Standard,
            en_RW => Standard,
            en_SB => Standard,
            en_SC => Standard,
            en_SD => Standard,
            en_SE => Standard,
            en_SG => Standard,
            en_SH => Standard,
            en_SI => Standard,
            en_SL => Standard,
            en_SS => Standard,
            en_SX => Standard,
            en_SZ => Standard,
            en_TC => Standard,
            en_TK => Standard,
            en_TO => Standard,
            en_TT => Standard,
            en_TV => Standard,
            en_TZ => Standard,
            en_UG => Standard,
            en_UM => Standard,
            en_US_POSIX => Posix,
            en_VC => Standard,
            en_VG => Standard,
            en_VI => Standard,
            en_VU => Standard,
            en_WS => Standard,
            en_ZA => Standard,
            en_ZM => Standard,
            en_ZW => Standard,
            eo => Standard,
            es => Standard,
            es_419 => Standard,
            es_AR => Standard,
            es_BO => Standard,
            es_BR => Standard,
            es_BZ => Standard,
            es_CL => Standard,
            es_CO => Standard,
            es_CR => Standard,
            es_CU => Standard,
            es_DO => Standard,
            es_EA => Standard,
            es_EC => Standard,
            es_GQ => Standard,
            es_GT => Standard,
            es_HN => Standard,
            es_IC => Standard,
            es_MX => Standard,
            es_NI => Standard,
            es_PA => Standard,
            es_PE => Standard,
            es_PH => Standard,
            es_PR => Standard,
            es_PY => Standard,
            es_SV => Standard,
            es_US => Standard,
            es_UY => Standard,
            es_VE => Standard,
            et => Standard,
            eu => Standard,
            ewo => Standard,
            fa => Standard,
            fa_AF => Standard,
            ff => Standard,
            ff_Latn => Standard,
            ff_Latn_BF => Standard,
            ff_Latn_CM => Standard,
            ff_Latn_GH => Standard,
            ff_Latn_GM => Standard,
            ff_Latn_GN => Standard,
            ff_Latn_GW => Standard,
            ff_Latn_LR => Standard,
            ff_Latn_MR => Standard,
            ff_Latn_NE => Standard,
            ff_Latn_NG => Standard,
            ff_Latn_SL => Standard,
            fi => Standard,
            fil => Standard,
            fo => Standard,
            fo_DK => Standard,
            fr => Standard,
            fr_BE => Standard,
            fr_BF => Standard,
            fr_BI => Standard,
            fr_BJ => Standard,
            fr_BL => Standard,
            fr_CA => Standard,
            fr_CD => Standard,
            fr_CF => Standard,
            fr_CG => Standard,
            fr_CH => Standard,
            fr_CI => Standard,
            fr_CM => Standard,
            fr_DJ => Standard,
            fr_DZ => Standard,
            fr_GA => Standard,
            fr_GF => Standard,
            fr_GN => Standard,
            fr_GP => Standard,
            fr_GQ => Standard,
            fr_HT => Standard,
            fr_KM => Standard,
            fr_LU => Standard,
            fr_MA => Standard,
            fr_MC => Standard,
            fr_MF => Standard,
            fr_MG => Standard,
            fr_ML => Standard,
            fr_MQ => Standard,
            fr_MR => Standard,
            fr_MU => Standard,
            fr_NC => Standard,
            fr_NE => Standard,
            fr_PF => Standard,
            fr_PM => Standard,
            fr_RE => Standard,
            fr_RW => Standard,
            fr_SC => Standard,
            fr_SN => Standard,
            fr_SY => Standard,
            fr_TD => Standard,
            fr_TG => Standard,
            fr_TN => Standard,
            fr_VU => Standard,
            fr_WF => Standard,
            fr_YT => Standard,
            fur => Standard,
            fy => Standard,
            ga => Standard,
            gd => Standard,
            gl => Standard,
            gsw => Standard,
            gsw_FR => Standard,
            gsw_LI => Standard,
            gu => Indian,
            guz => Standard,
            gv => Standard,
            ha => Standard,
            ha_GH => Standard,
            ha_NE => Standard,
            haw => Standard,
            he => Standard,
            hi => Indian,
            hr => Standard,
            hr_BA => Standard,
            hsb => Standard,
            hu => Standard,
            hy => Standard,
            ia => Standard,
            id => Standard,
            ig => Standard,
            ii => Standard,
            is => Standard,
            it => Standard,
            it_CH => Standard,
            it_SM => Standard,
            it_VA => Standard,
            ja => Standard,
            jgo => Standard,
            jmc => Standard,
            jv => Standard,
            ka => Standard,
            kab => Standard,
            kam => Standard,
            kde => Standard,
            kea => Standard,
            khq => Standard,
            ki => Standard,
            kk => Standard,
            kkj => Standard,
            kl => Standard,
            kln => Standard,
            km => Standard,
            kn => Standard,
            ko => Standard,
            ko_KP => Standard,
            kok => Indian,
            ks => Indian,
            ksb => Standard,
            ksf => Standard,
            ksh => Standard,
            ku => Standard,
            kw => Standard,
            ky => Standard,
            lag => Standard,
            lb => Standard,
            lg => Standard,
            lkt => Standard,
            ln => Standard,
            ln_AO => Standard,
            ln_CF => Standard,
            ln_CG => Standard,
            lo => Standard,
            lrc => Standard,
            lrc_IQ => Standard,
            lt => Standard,
            lu => Standard,
            luo => Standard,
            luy => Standard,
            lv => Standard,
            mas => Standard,
            mas_TZ => Standard,
            mer => Standard,
            mfe => Standard,
            mg => Standard,
            mgh => Standard,
            mgo => Standard,
            mi => Standard,
            mk => Standard,
            ml => Indian,
            mn => Standard,
            mr => Indian,
            ms => Standard,
            ms_BN => Standard,
            ms_SG => Standard,
            mt => Standard,
            mua => Standard,
            my => Standard,
            mzn => Standard,
            naq => Standard,
            nb => Standard,
            nb_SJ => Standard,
            nd => Standard,
            nds => Standard,
            nds_NL => Standard,
            ne => Standard,
            ne_IN => Standard,
            nl => Standard,
            nl_AW => Standard,
            nl_BE => Standard,
            nl_BQ => Standard,
            nl_CW => Standard,
            nl_SR => Standard,
            nl_SX => Standard,
            nmg => Standard,
            nn => Standard,
            nnh => Standard,
            nus => Standard,
            nyn => Standard,
            om => Standard,
            om_KE => Standard,
            or => Indian,
            os => Standard,
            os_RU => Standard,
            pa => Indian,
            pa_Arab => Standard,
            pa_Guru => Indian,
            pl => Standard,
            prg => Standard,
            ps => Standard,
            pt => Standard,
            pt_AO => Standard,
            pt_CH => Standard,
            pt_CV => Standard,
            pt_GQ => Standard,
            pt_GW => Standard,
            pt_LU => Standard,
            pt_MO => Standard,
            pt_MZ => Standard,
            pt_PT => Standard,
            pt_ST => Standard,
            pt_TL => Standard,
            qu => Standard,
            qu_BO => Standard,
            qu_EC => Standard,
            rm => Standard,
            rn => Standard,
            ro => Standard,
            ro_MD => Standard,
            rof => Standard,
            root => Standard,
            ru => Standard,
            ru_BY => Standard,
            ru_KG => Standard,
            ru_KZ => Standard,
            ru_MD => Standard,
            ru_UA => Standard,
            rw => Standard,
            rwk => Standard,
            sah => Standard,
            saq => Standard,
            sbp => Standard,
            sd => Standard,
            se => Standard,
            se_FI => Standard,
            se_SE => Standard,
            seh => Standard,
            ses => Standard,
            sg => Standard,
            shi => Standard,
            shi_Latn => Standard,
            shi_Tfng => Standard,
            si => Standard,
            sk => Standard,
            sl => Standard,
            smn => Standard,
            sn => Standard,
            so => Standard,
            so_DJ => Standard,
            so_ET => Standard,
            so_KE => Standard,
            sq => Standard,
            sq_MK => Standard,
            sq_XK => Standard,
            sr => Standard,
            sr_Cyrl => Standard,
            sr_Cyrl_BA => Standard,
            sr_Cyrl_ME => Standard,
            sr_Cyrl_XK => Standard,
            sr_Latn => Standard,
            sr_Latn_BA => Standard,
            sr_Latn_ME => Standard,
            sr_Latn_XK => Standard,
            sv => Standard,
            sv_AX => Standard,
            sv_FI => Standard,
            sw => Standard,
            sw_CD => Standard,
            sw_KE => Standard,
            sw_UG => Standard,
            ta => Indian,
            ta_LK => Indian,
            ta_MY => Standard,
            ta_SG => Standard,
            te => Indian,
            teo => Standard,
            teo_KE => Standard,
            tg => Standard,
            th => Standard,
            ti => Standard,
            ti_ER => Standard,
            tk => Standard,
            to => Standard,
            tr => Standard,
            tr_CY => Standard,
            tt => Standard,
            twq => Standard,
            tzm => Standard,
            ug => Standard,
            uk => Standard,
            ur => Standard,
            ur_IN => Standard,
            uz => Standard,
            uz_Arab => Standard,
            uz_Cyrl => Standard,
            uz_Latn => Standard,
            vai => Standard,
            vai_Latn => Standard,
            vai_Vaii => Standard,
            vi => Standard,
            vo => Standard,
            vun => Standard,
            wae => Standard,
            wo => Standard,
            xh => Standard,
            xog => Standard,
            yav => Standard,
            yi => Standard,
            yo => Standard,
            yo_BJ => Standard,
            yue => Standard,
            yue_Hans => Standard,
            yue_Hant => Standard,
            zgh => Standard,
            zh => Standard,
            zh_Hans => Standard,
            zh_Hans_HK => Standard,
            zh_Hans_MO => Standard,
            zh_Hans_SG => Standard,
            zh_Hant => Standard,
            zh_Hant_HK => Standard,
            zh_Hant_MO => Standard,
            zu => Standard,
        }
    }
    #[doc = r" Returns the locale's infinity representation."]
    pub fn infinity(&self) -> &'static str {
        use self::Locale::*;
        match self {
            af => "\u{221e}",
            af_NA => "\u{221e}",
            agq => "\u{221e}",
            ak => "\u{221e}",
            am => "\u{221e}",
            ar => "\u{221e}",
            ar_AE => "\u{221e}",
            ar_BH => "\u{221e}",
            ar_DJ => "\u{221e}",
            ar_DZ => "\u{221e}",
            ar_EG => "\u{221e}",
            ar_EH => "\u{221e}",
            ar_ER => "\u{221e}",
            ar_IL => "\u{221e}",
            ar_IQ => "\u{221e}",
            ar_JO => "\u{221e}",
            ar_KM => "\u{221e}",
            ar_KW => "\u{221e}",
            ar_LB => "\u{221e}",
            ar_LY => "\u{221e}",
            ar_MA => "\u{221e}",
            ar_MR => "\u{221e}",
            ar_OM => "\u{221e}",
            ar_PS => "\u{221e}",
            ar_QA => "\u{221e}",
            ar_SA => "\u{221e}",
            ar_SD => "\u{221e}",
            ar_SO => "\u{221e}",
            ar_SS => "\u{221e}",
            ar_SY => "\u{221e}",
            ar_TD => "\u{221e}",
            ar_TN => "\u{221e}",
            ar_YE => "\u{221e}",
            as_ => "\u{221e}",
            asa => "\u{221e}",
            ast => "\u{221e}",
            az => "\u{221e}",
            az_Cyrl => "\u{221e}",
            az_Latn => "\u{221e}",
            bas => "\u{221e}",
            be => "\u{221e}",
            bem => "\u{221e}",
            bez => "\u{221e}",
            bg => "\u{221e}",
            bm => "\u{221e}",
            bn => "\u{221e}",
            bn_IN => "\u{221e}",
            bo => "\u{221e}",
            bo_IN => "\u{221e}",
            br => "\u{221e}",
            brx => "\u{221e}",
            bs => "\u{221e}",
            bs_Cyrl => "\u{221e}",
            bs_Latn => "\u{221e}",
            ca => "\u{221e}",
            ca_AD => "\u{221e}",
            ca_ES_VALENCIA => "\u{221e}",
            ca_FR => "\u{221e}",
            ca_IT => "\u{221e}",
            ccp => "\u{221e}",
            ccp_IN => "\u{221e}",
            ce => "\u{221e}",
            cgg => "\u{221e}",
            chr => "\u{221e}",
            ckb => "\u{221e}",
            ckb_IR => "\u{221e}",
            cs => "\u{221e}",
            cu => "\u{221e}",
            cy => "\u{221e}",
            da => "\u{221e}",
            da_GL => "\u{221e}",
            dav => "\u{221e}",
            de => "\u{221e}",
            de_AT => "\u{221e}",
            de_BE => "\u{221e}",
            de_CH => "\u{221e}",
            de_IT => "\u{221e}",
            de_LI => "\u{221e}",
            de_LU => "\u{221e}",
            dje => "\u{221e}",
            dsb => "\u{221e}",
            dua => "\u{221e}",
            dyo => "\u{221e}",
            dz => "\u{f42}\u{fb2}\u{f44}\u{f66}\u{f0b}\u{f58}\u{f7a}\u{f51}",
            ebu => "\u{221e}",
            ee => "\u{221e}",
            ee_TG => "\u{221e}",
            el => "\u{221e}",
            el_CY => "\u{221e}",
            en => "\u{221e}",
            en_001 => "\u{221e}",
            en_150 => "\u{221e}",
            en_AG => "\u{221e}",
            en_AI => "\u{221e}",
            en_AS => "\u{221e}",
            en_AT => "\u{221e}",
            en_AU => "\u{221e}",
            en_BB => "\u{221e}",
            en_BE => "\u{221e}",
            en_BI => "\u{221e}",
            en_BM => "\u{221e}",
            en_BS => "\u{221e}",
            en_BW => "\u{221e}",
            en_BZ => "\u{221e}",
            en_CA => "\u{221e}",
            en_CC => "\u{221e}",
            en_CH => "\u{221e}",
            en_CK => "\u{221e}",
            en_CM => "\u{221e}",
            en_CX => "\u{221e}",
            en_CY => "\u{221e}",
            en_DE => "\u{221e}",
            en_DG => "\u{221e}",
            en_DK => "\u{221e}",
            en_DM => "\u{221e}",
            en_ER => "\u{221e}",
            en_FI => "\u{221e}",
            en_FJ => "\u{221e}",
            en_FK => "\u{221e}",
            en_FM => "\u{221e}",
            en_GB => "\u{221e}",
            en_GD => "\u{221e}",
            en_GG => "\u{221e}",
            en_GH => "\u{221e}",
            en_GI => "\u{221e}",
            en_GM => "\u{221e}",
            en_GU => "\u{221e}",
            en_GY => "\u{221e}",
            en_HK => "\u{221e}",
            en_IE => "\u{221e}",
            en_IL => "\u{221e}",
            en_IM => "\u{221e}",
            en_IN => "\u{221e}",
            en_IO => "\u{221e}",
            en_JE => "\u{221e}",
            en_JM => "\u{221e}",
            en_KE => "\u{221e}",
            en_KI => "\u{221e}",
            en_KN => "\u{221e}",
            en_KY => "\u{221e}",
            en_LC => "\u{221e}",
            en_LR => "\u{221e}",
            en_LS => "\u{221e}",
            en_MG => "\u{221e}",
            en_MH => "\u{221e}",
            en_MO => "\u{221e}",
            en_MP => "\u{221e}",
            en_MS => "\u{221e}",
            en_MT => "\u{221e}",
            en_MU => "\u{221e}",
            en_MW => "\u{221e}",
            en_MY => "\u{221e}",
            en_NA => "\u{221e}",
            en_NF => "\u{221e}",
            en_NG => "\u{221e}",
            en_NL => "\u{221e}",
            en_NR => "\u{221e}",
            en_NU => "\u{221e}",
            en_NZ => "\u{221e}",
            en_PG => "\u{221e}",
            en_PH => "\u{221e}",
            en_PK => "\u{221e}",
            en_PN => "\u{221e}",
            en_PR => "\u{221e}",
            en_PW => "\u{221e}",
            en_RW => "\u{221e}",
            en_SB => "\u{221e}",
            en_SC => "\u{221e}",
            en_SD => "\u{221e}",
            en_SE => "\u{221e}",
            en_SG => "\u{221e}",
            en_SH => "\u{221e}",
            en_SI => "\u{221e}",
            en_SL => "\u{221e}",
            en_SS => "\u{221e}",
            en_SX => "\u{221e}",
            en_SZ => "\u{221e}",
            en_TC => "\u{221e}",
            en_TK => "\u{221e}",
            en_TO => "\u{221e}",
            en_TT => "\u{221e}",
            en_TV => "\u{221e}",
            en_TZ => "\u{221e}",
            en_UG => "\u{221e}",
            en_UM => "\u{221e}",
            en_US_POSIX => "INF",
            en_VC => "\u{221e}",
            en_VG => "\u{221e}",
            en_VI => "\u{221e}",
            en_VU => "\u{221e}",
            en_WS => "\u{221e}",
            en_ZA => "\u{221e}",
            en_ZM => "\u{221e}",
            en_ZW => "\u{221e}",
            eo => "\u{221e}",
            es => "\u{221e}",
            es_419 => "\u{221e}",
            es_AR => "\u{221e}",
            es_BO => "\u{221e}",
            es_BR => "\u{221e}",
            es_BZ => "\u{221e}",
            es_CL => "\u{221e}",
            es_CO => "\u{221e}",
            es_CR => "\u{221e}",
            es_CU => "\u{221e}",
            es_DO => "\u{221e}",
            es_EA => "\u{221e}",
            es_EC => "\u{221e}",
            es_GQ => "\u{221e}",
            es_GT => "\u{221e}",
            es_HN => "\u{221e}",
            es_IC => "\u{221e}",
            es_MX => "\u{221e}",
            es_NI => "\u{221e}",
            es_PA => "\u{221e}",
            es_PE => "\u{221e}",
            es_PH => "\u{221e}",
            es_PR => "\u{221e}",
            es_PY => "\u{221e}",
            es_SV => "\u{221e}",
            es_US => "\u{221e}",
            es_UY => "\u{221e}",
            es_VE => "\u{221e}",
            et => "\u{221e}",
            eu => "\u{221e}",
            ewo => "\u{221e}",
            fa => "\u{221e}",
            fa_AF => "\u{221e}",
            ff => "\u{221e}",
            ff_Latn => "\u{221e}",
            ff_Latn_BF => "\u{221e}",
            ff_Latn_CM => "\u{221e}",
            ff_Latn_GH => "\u{221e}",
            ff_Latn_GM => "\u{221e}",
            ff_Latn_GN => "\u{221e}",
            ff_Latn_GW => "\u{221e}",
            ff_Latn_LR => "\u{221e}",
            ff_Latn_MR => "\u{221e}",
            ff_Latn_NE => "\u{221e}",
            ff_Latn_NG => "\u{221e}",
            ff_Latn_SL => "\u{221e}",
            fi => "\u{221e}",
            fil => "\u{221e}",
            fo => "\u{221e}",
            fo_DK => "\u{221e}",
            fr => "\u{221e}",
            fr_BE => "\u{221e}",
            fr_BF => "\u{221e}",
            fr_BI => "\u{221e}",
            fr_BJ => "\u{221e}",
            fr_BL => "\u{221e}",
            fr_CA => "\u{221e}",
            fr_CD => "\u{221e}",
            fr_CF => "\u{221e}",
            fr_CG => "\u{221e}",
            fr_CH => "\u{221e}",
            fr_CI => "\u{221e}",
            fr_CM => "\u{221e}",
            fr_DJ => "\u{221e}",
            fr_DZ => "\u{221e}",
            fr_GA => "\u{221e}",
            fr_GF => "\u{221e}",
            fr_GN => "\u{221e}",
            fr_GP => "\u{221e}",
            fr_GQ => "\u{221e}",
            fr_HT => "\u{221e}",
            fr_KM => "\u{221e}",
            fr_LU => "\u{221e}",
            fr_MA => "\u{221e}",
            fr_MC => "\u{221e}",
            fr_MF => "\u{221e}",
            fr_MG => "\u{221e}",
            fr_ML => "\u{221e}",
            fr_MQ => "\u{221e}",
            fr_MR => "\u{221e}",
            fr_MU => "\u{221e}",
            fr_NC => "\u{221e}",
            fr_NE => "\u{221e}",
            fr_PF => "\u{221e}",
            fr_PM => "\u{221e}",
            fr_RE => "\u{221e}",
            fr_RW => "\u{221e}",
            fr_SC => "\u{221e}",
            fr_SN => "\u{221e}",
            fr_SY => "\u{221e}",
            fr_TD => "\u{221e}",
            fr_TG => "\u{221e}",
            fr_TN => "\u{221e}",
            fr_VU => "\u{221e}",
            fr_WF => "\u{221e}",
            fr_YT => "\u{221e}",
            fur => "\u{221e}",
            fy => "\u{221e}",
            ga => "\u{221e}",
            gd => "\u{221e}",
            gl => "\u{221e}",
            gsw => "\u{221e}",
            gsw_FR => "\u{221e}",
            gsw_LI => "\u{221e}",
            gu => "\u{221e}",
            guz => "\u{221e}",
            gv => "\u{221e}",
            ha => "\u{221e}",
            ha_GH => "\u{221e}",
            ha_NE => "\u{221e}",
            haw => "\u{221e}",
            he => "\u{221e}",
            hi => "\u{221e}",
            hr => "\u{221e}",
            hr_BA => "\u{221e}",
            hsb => "\u{221e}",
            hu => "\u{221e}",
            hy => "\u{221e}",
            ia => "\u{221e}",
            id => "\u{221e}",
            ig => "\u{221e}",
            ii => "\u{221e}",
            is => "\u{221e}",
            it => "\u{221e}",
            it_CH => "\u{221e}",
            it_SM => "\u{221e}",
            it_VA => "\u{221e}",
            ja => "\u{221e}",
            jgo => "\u{221e}",
            jmc => "\u{221e}",
            jv => "\u{221e}",
            ka => "\u{221e}",
            kab => "\u{221e}",
            kam => "\u{221e}",
            kde => "\u{221e}",
            kea => "\u{221e}",
            khq => "\u{221e}",
            ki => "\u{221e}",
            kk => "\u{221e}",
            kkj => "\u{221e}",
            kl => "\u{221e}",
            kln => "\u{221e}",
            km => "\u{221e}",
            kn => "\u{221e}",
            ko => "\u{221e}",
            ko_KP => "\u{221e}",
            kok => "\u{221e}",
            ks => "\u{221e}",
            ksb => "\u{221e}",
            ksf => "\u{221e}",
            ksh => "\u{221e}",
            ku => "\u{221e}",
            kw => "\u{221e}",
            ky => "\u{221e}",
            lag => "\u{221e}",
            lb => "\u{221e}",
            lg => "\u{221e}",
            lkt => "\u{221e}",
            ln => "\u{221e}",
            ln_AO => "\u{221e}",
            ln_CF => "\u{221e}",
            ln_CG => "\u{221e}",
            lo => "\u{221e}",
            lrc => "\u{221e}",
            lrc_IQ => "\u{221e}",
            lt => "\u{221e}",
            lu => "\u{221e}",
            luo => "\u{221e}",
            luy => "\u{221e}",
            lv => "\u{221e}",
            mas => "\u{221e}",
            mas_TZ => "\u{221e}",
            mer => "\u{221e}",
            mfe => "\u{221e}",
            mg => "\u{221e}",
            mgh => "\u{221e}",
            mgo => "\u{221e}",
            mi => "\u{221e}",
            mk => "\u{221e}",
            ml => "\u{221e}",
            mn => "\u{221e}",
            mr => "\u{221e}",
            ms => "\u{221e}",
            ms_BN => "\u{221e}",
            ms_SG => "\u{221e}",
            mt => "\u{221e}",
            mua => "\u{221e}",
            my => "\u{221e}",
            mzn => "\u{221e}",
            naq => "\u{221e}",
            nb => "\u{221e}",
            nb_SJ => "\u{221e}",
            nd => "\u{221e}",
            nds => "\u{221e}",
            nds_NL => "\u{221e}",
            ne => "\u{221e}",
            ne_IN => "\u{221e}",
            nl => "\u{221e}",
            nl_AW => "\u{221e}",
            nl_BE => "\u{221e}",
            nl_BQ => "\u{221e}",
            nl_CW => "\u{221e}",
            nl_SR => "\u{221e}",
            nl_SX => "\u{221e}",
            nmg => "\u{221e}",
            nn => "\u{221e}",
            nnh => "\u{221e}",
            nus => "\u{221e}",
            nyn => "\u{221e}",
            om => "\u{221e}",
            om_KE => "\u{221e}",
            or => "\u{221e}",
            os => "\u{221e}",
            os_RU => "\u{221e}",
            pa => "\u{221e}",
            pa_Arab => "\u{221e}",
            pa_Guru => "\u{221e}",
            pl => "\u{221e}",
            prg => "\u{221e}",
            ps => "\u{221e}",
            pt => "\u{221e}",
            pt_AO => "\u{221e}",
            pt_CH => "\u{221e}",
            pt_CV => "\u{221e}",
            pt_GQ => "\u{221e}",
            pt_GW => "\u{221e}",
            pt_LU => "\u{221e}",
            pt_MO => "\u{221e}",
            pt_MZ => "\u{221e}",
            pt_PT => "\u{221e}",
            pt_ST => "\u{221e}",
            pt_TL => "\u{221e}",
            qu => "\u{221e}",
            qu_BO => "\u{221e}",
            qu_EC => "\u{221e}",
            rm => "\u{221e}",
            rn => "\u{221e}",
            ro => "\u{221e}",
            ro_MD => "\u{221e}",
            rof => "\u{221e}",
            root => "\u{221e}",
            ru => "\u{221e}",
            ru_BY => "\u{221e}",
            ru_KG => "\u{221e}",
            ru_KZ => "\u{221e}",
            ru_MD => "\u{221e}",
            ru_UA => "\u{221e}",
            rw => "\u{221e}",
            rwk => "\u{221e}",
            sah => "\u{221e}",
            saq => "\u{221e}",
            sbp => "\u{221e}",
            sd => "\u{221e}",
            se => "\u{221e}",
            se_FI => "\u{221e}",
            se_SE => "\u{221e}",
            seh => "\u{221e}",
            ses => "\u{221e}",
            sg => "\u{221e}",
            shi => "\u{221e}",
            shi_Latn => "\u{221e}",
            shi_Tfng => "\u{221e}",
            si => "\u{221e}",
            sk => "\u{221e}",
            sl => "\u{221e}",
            smn => "\u{221e}",
            sn => "\u{221e}",
            so => "\u{221e}",
            so_DJ => "\u{221e}",
            so_ET => "\u{221e}",
            so_KE => "\u{221e}",
            sq => "\u{221e}",
            sq_MK => "\u{221e}",
            sq_XK => "\u{221e}",
            sr => "\u{221e}",
            sr_Cyrl => "\u{221e}",
            sr_Cyrl_BA => "\u{221e}",
            sr_Cyrl_ME => "\u{221e}",
            sr_Cyrl_XK => "\u{221e}",
            sr_Latn => "\u{221e}",
            sr_Latn_BA => "\u{221e}",
            sr_Latn_ME => "\u{221e}",
            sr_Latn_XK => "\u{221e}",
            sv => "\u{221e}",
            sv_AX => "\u{221e}",
            sv_FI => "\u{221e}",
            sw => "\u{221e}",
            sw_CD => "\u{221e}",
            sw_KE => "\u{221e}",
            sw_UG => "\u{221e}",
            ta => "\u{221e}",
            ta_LK => "\u{221e}",
            ta_MY => "\u{221e}",
            ta_SG => "\u{221e}",
            te => "\u{221e}",
            teo => "\u{221e}",
            teo_KE => "\u{221e}",
            tg => "\u{221e}",
            th => "\u{221e}",
            ti => "\u{221e}",
            ti_ER => "\u{221e}",
            tk => "\u{221e}",
            to => "\u{221e}",
            tr => "\u{221e}",
            tr_CY => "\u{221e}",
            tt => "\u{221e}",
            twq => "\u{221e}",
            tzm => "\u{221e}",
            ug => "\u{221e}",
            uk => "\u{221e}",
            ur => "\u{221e}",
            ur_IN => "\u{221e}",
            uz => "\u{221e}",
            uz_Arab => "\u{221e}",
            uz_Cyrl => "\u{221e}",
            uz_Latn => "\u{221e}",
            vai => "\u{221e}",
            vai_Latn => "\u{221e}",
            vai_Vaii => "\u{221e}",
            vi => "\u{221e}",
            vo => "\u{221e}",
            vun => "\u{221e}",
            wae => "\u{221e}",
            wo => "\u{221e}",
            xh => "\u{221e}",
            xog => "\u{221e}",
            yav => "\u{221e}",
            yi => "\u{221e}",
            yo => "\u{221e}",
            yo_BJ => "\u{221e}",
            yue => "\u{221e}",
            yue_Hans => "\u{221e}",
            yue_Hant => "\u{221e}",
            zgh => "\u{221e}",
            zh => "\u{221e}",
            zh_Hans => "\u{221e}",
            zh_Hans_HK => "\u{221e}",
            zh_Hans_MO => "\u{221e}",
            zh_Hans_SG => "\u{221e}",
            zh_Hant => "\u{221e}",
            zh_Hant_HK => "\u{221e}",
            zh_Hant_MO => "\u{221e}",
            zu => "\u{221e}",
        }
    }
    #[doc = r" Returns the locale's minus sign representation."]
    pub fn minus_sign(&self) -> &'static str {
        use self::Locale::*;
        match self {
            af => "-",
            af_NA => "-",
            agq => "-",
            ak => "-",
            am => "-",
            ar => "\u{61c}-",
            ar_AE => "\u{61c}-",
            ar_BH => "\u{61c}-",
            ar_DJ => "\u{61c}-",
            ar_DZ => "\u{200e}-",
            ar_EG => "\u{61c}-",
            ar_EH => "\u{200e}-",
            ar_ER => "\u{61c}-",
            ar_IL => "\u{61c}-",
            ar_IQ => "\u{61c}-",
            ar_JO => "\u{61c}-",
            ar_KM => "\u{61c}-",
            ar_KW => "\u{61c}-",
            ar_LB => "\u{61c}-",
            ar_LY => "\u{200e}-",
            ar_MA => "\u{200e}-",
            ar_MR => "\u{61c}-",
            ar_OM => "\u{61c}-",
            ar_PS => "\u{61c}-",
            ar_QA => "\u{61c}-",
            ar_SA => "\u{61c}-",
            ar_SD => "\u{61c}-",
            ar_SO => "\u{61c}-",
            ar_SS => "\u{61c}-",
            ar_SY => "\u{61c}-",
            ar_TD => "\u{61c}-",
            ar_TN => "\u{200e}-",
            ar_YE => "\u{61c}-",
            as_ => "-",
            asa => "-",
            ast => "-",
            az => "-",
            az_Cyrl => "-",
            az_Latn => "-",
            bas => "-",
            be => "-",
            bem => "-",
            bez => "-",
            bg => "-",
            bm => "-",
            bn => "-",
            bn_IN => "-",
            bo => "-",
            bo_IN => "-",
            br => "-",
            brx => "-",
            bs => "-",
            bs_Cyrl => "-",
            bs_Latn => "-",
            ca => "-",
            ca_AD => "-",
            ca_ES_VALENCIA => "-",
            ca_FR => "-",
            ca_IT => "-",
            ccp => "-",
            ccp_IN => "-",
            ce => "-",
            cgg => "-",
            chr => "-",
            ckb => "\u{200f}-",
            ckb_IR => "\u{200f}-",
            cs => "-",
            cu => "-",
            cy => "-",
            da => "-",
            da_GL => "-",
            dav => "-",
            de => "-",
            de_AT => "-",
            de_BE => "-",
            de_CH => "-",
            de_IT => "-",
            de_LI => "-",
            de_LU => "-",
            dje => "-",
            dsb => "-",
            dua => "-",
            dyo => "-",
            dz => "-",
            ebu => "-",
            ee => "-",
            ee_TG => "-",
            el => "-",
            el_CY => "-",
            en => "-",
            en_001 => "-",
            en_150 => "-",
            en_AG => "-",
            en_AI => "-",
            en_AS => "-",
            en_AT => "-",
            en_AU => "-",
            en_BB => "-",
            en_BE => "-",
            en_BI => "-",
            en_BM => "-",
            en_BS => "-",
            en_BW => "-",
            en_BZ => "-",
            en_CA => "-",
            en_CC => "-",
            en_CH => "-",
            en_CK => "-",
            en_CM => "-",
            en_CX => "-",
            en_CY => "-",
            en_DE => "-",
            en_DG => "-",
            en_DK => "-",
            en_DM => "-",
            en_ER => "-",
            en_FI => "-",
            en_FJ => "-",
            en_FK => "-",
            en_FM => "-",
            en_GB => "-",
            en_GD => "-",
            en_GG => "-",
            en_GH => "-",
            en_GI => "-",
            en_GM => "-",
            en_GU => "-",
            en_GY => "-",
            en_HK => "-",
            en_IE => "-",
            en_IL => "-",
            en_IM => "-",
            en_IN => "-",
            en_IO => "-",
            en_JE => "-",
            en_JM => "-",
            en_KE => "-",
            en_KI => "-",
            en_KN => "-",
            en_KY => "-",
            en_LC => "-",
            en_LR => "-",
            en_LS => "-",
            en_MG => "-",
            en_MH => "-",
            en_MO => "-",
            en_MP => "-",
            en_MS => "-",
            en_MT => "-",
            en_MU => "-",
            en_MW => "-",
            en_MY => "-",
            en_NA => "-",
            en_NF => "-",
            en_NG => "-",
            en_NL => "-",
            en_NR => "-",
            en_NU => "-",
            en_NZ => "-",
            en_PG => "-",
            en_PH => "-",
            en_PK => "-",
            en_PN => "-",
            en_PR => "-",
            en_PW => "-",
            en_RW => "-",
            en_SB => "-",
            en_SC => "-",
            en_SD => "-",
            en_SE => "-",
            en_SG => "-",
            en_SH => "-",
            en_SI => "-",
            en_SL => "-",
            en_SS => "-",
            en_SX => "-",
            en_SZ => "-",
            en_TC => "-",
            en_TK => "-",
            en_TO => "-",
            en_TT => "-",
            en_TV => "-",
            en_TZ => "-",
            en_UG => "-",
            en_UM => "-",
            en_US_POSIX => "-",
            en_VC => "-",
            en_VG => "-",
            en_VI => "-",
            en_VU => "-",
            en_WS => "-",
            en_ZA => "-",
            en_ZM => "-",
            en_ZW => "-",
            eo => "-",
            es => "-",
            es_419 => "-",
            es_AR => "-",
            es_BO => "-",
            es_BR => "-",
            es_BZ => "-",
            es_CL => "-",
            es_CO => "-",
            es_CR => "-",
            es_CU => "-",
            es_DO => "-",
            es_EA => "-",
            es_EC => "-",
            es_GQ => "-",
            es_GT => "-",
            es_HN => "-",
            es_IC => "-",
            es_MX => "-",
            es_NI => "-",
            es_PA => "-",
            es_PE => "-",
            es_PH => "-",
            es_PR => "-",
            es_PY => "-",
            es_SV => "-",
            es_US => "-",
            es_UY => "-",
            es_VE => "-",
            et => "\u{2212}",
            eu => "\u{2212}",
            ewo => "-",
            fa => "\u{200e}\u{2212}",
            fa_AF => "\u{200e}\u{2212}",
            ff => "-",
            ff_Latn => "-",
            ff_Latn_BF => "-",
            ff_Latn_CM => "-",
            ff_Latn_GH => "-",
            ff_Latn_GM => "-",
            ff_Latn_GN => "-",
            ff_Latn_GW => "-",
            ff_Latn_LR => "-",
            ff_Latn_MR => "-",
            ff_Latn_NE => "-",
            ff_Latn_NG => "-",
            ff_Latn_SL => "-",
            fi => "\u{2212}",
            fil => "-",
            fo => "\u{2212}",
            fo_DK => "\u{2212}",
            fr => "-",
            fr_BE => "-",
            fr_BF => "-",
            fr_BI => "-",
            fr_BJ => "-",
            fr_BL => "-",
            fr_CA => "-",
            fr_CD => "-",
            fr_CF => "-",
            fr_CG => "-",
            fr_CH => "-",
            fr_CI => "-",
            fr_CM => "-",
            fr_DJ => "-",
            fr_DZ => "-",
            fr_GA => "-",
            fr_GF => "-",
            fr_GN => "-",
            fr_GP => "-",
            fr_GQ => "-",
            fr_HT => "-",
            fr_KM => "-",
            fr_LU => "-",
            fr_MA => "-",
            fr_MC => "-",
            fr_MF => "-",
            fr_MG => "-",
            fr_ML => "-",
            fr_MQ => "-",
            fr_MR => "-",
            fr_MU => "-",
            fr_NC => "-",
            fr_NE => "-",
            fr_PF => "-",
            fr_PM => "-",
            fr_RE => "-",
            fr_RW => "-",
            fr_SC => "-",
            fr_SN => "-",
            fr_SY => "-",
            fr_TD => "-",
            fr_TG => "-",
            fr_TN => "-",
            fr_VU => "-",
            fr_WF => "-",
            fr_YT => "-",
            fur => "-",
            fy => "-",
            ga => "-",
            gd => "-",
            gl => "-",
            gsw => "\u{2212}",
            gsw_FR => "\u{2212}",
            gsw_LI => "\u{2212}",
            gu => "-",
            guz => "-",
            gv => "-",
            ha => "-",
            ha_GH => "-",
            ha_NE => "-",
            haw => "-",
            he => "\u{200e}-",
            hi => "-",
            hr => "-",
            hr_BA => "-",
            hsb => "-",
            hu => "-",
            hy => "-",
            ia => "-",
            id => "-",
            ig => "-",
            ii => "-",
            is => "-",
            it => "-",
            it_CH => "-",
            it_SM => "-",
            it_VA => "-",
            ja => "-",
            jgo => "-",
            jmc => "-",
            jv => "-",
            ka => "-",
            kab => "-",
            kam => "-",
            kde => "-",
            kea => "-",
            khq => "-",
            ki => "-",
            kk => "-",
            kkj => "-",
            kl => "-",
            kln => "-",
            km => "-",
            kn => "-",
            ko => "-",
            ko_KP => "-",
            kok => "-",
            ks => "\u{200e}-\u{200e}",
            ksb => "-",
            ksf => "-",
            ksh => "\u{2212}",
            ku => "-",
            kw => "-",
            ky => "-",
            lag => "-",
            lb => "-",
            lg => "-",
            lkt => "-",
            ln => "-",
            ln_AO => "-",
            ln_CF => "-",
            ln_CG => "-",
            lo => "-",
            lrc => "\u{200e}-\u{200e}",
            lrc_IQ => "\u{200e}-\u{200e}",
            lt => "\u{2212}",
            lu => "-",
            luo => "-",
            luy => "-",
            lv => "-",
            mas => "-",
            mas_TZ => "-",
            mer => "-",
            mfe => "-",
            mg => "-",
            mgh => "-",
            mgo => "-",
            mi => "-",
            mk => "-",
            ml => "-",
            mn => "-",
            mr => "-",
            ms => "-",
            ms_BN => "-",
            ms_SG => "-",
            mt => "-",
            mua => "-",
            my => "-",
            mzn => "\u{200e}-\u{200e}",
            naq => "-",
            nb => "\u{2212}",
            nb_SJ => "\u{2212}",
            nd => "-",
            nds => "-",
            nds_NL => "-",
            ne => "-",
            ne_IN => "-",
            nl => "-",
            nl_AW => "-",
            nl_BE => "-",
            nl_BQ => "-",
            nl_CW => "-",
            nl_SR => "-",
            nl_SX => "-",
            nmg => "-",
            nn => "\u{2212}",
            nnh => "-",
            nus => "-",
            nyn => "-",
            om => "-",
            om_KE => "-",
            or => "-",
            os => "-",
            os_RU => "-",
            pa => "-",
            pa_Arab => "\u{200e}-\u{200e}",
            pa_Guru => "-",
            pl => "-",
            prg => "-",
            ps => "\u{200e}-\u{200e}",
            pt => "-",
            pt_AO => "-",
            pt_CH => "-",
            pt_CV => "-",
            pt_GQ => "-",
            pt_GW => "-",
            pt_LU => "-",
            pt_MO => "-",
            pt_MZ => "-",
            pt_PT => "-",
            pt_ST => "-",
            pt_TL => "-",
            qu => "-",
            qu_BO => "-",
            qu_EC => "-",
            rm => "\u{2212}",
            rn => "-",
            ro => "-",
            ro_MD => "-",
            rof => "-",
            root => "-",
            ru => "-",
            ru_BY => "-",
            ru_KG => "-",
            ru_KZ => "-",
            ru_MD => "-",
            ru_UA => "-",
            rw => "-",
            rwk => "-",
            sah => "-",
            saq => "-",
            sbp => "-",
            sd => "\u{61c}-",
            se => "\u{2212}",
            se_FI => "\u{2212}",
            se_SE => "\u{2212}",
            seh => "-",
            ses => "-",
            sg => "-",
            shi => "-",
            shi_Latn => "-",
            shi_Tfng => "-",
            si => "-",
            sk => "-",
            sl => "\u{2212}",
            smn => "-",
            sn => "-",
            so => "-",
            so_DJ => "-",
            so_ET => "-",
            so_KE => "-",
            sq => "-",
            sq_MK => "-",
            sq_XK => "-",
            sr => "-",
            sr_Cyrl => "-",
            sr_Cyrl_BA => "-",
            sr_Cyrl_ME => "-",
            sr_Cyrl_XK => "-",
            sr_Latn => "-",
            sr_Latn_BA => "-",
            sr_Latn_ME => "-",
            sr_Latn_XK => "-",
            sv => "\u{2212}",
            sv_AX => "\u{2212}",
            sv_FI => "\u{2212}",
            sw => "-",
            sw_CD => "-",
            sw_KE => "-",
            sw_UG => "-",
            ta => "-",
            ta_LK => "-",
            ta_MY => "-",
            ta_SG => "-",
            te => "-",
            teo => "-",
            teo_KE => "-",
            tg => "-",
            th => "-",
            ti => "-",
            ti_ER => "-",
            tk => "-",
            to => "-",
            tr => "-",
            tr_CY => "-",
            tt => "-",
            twq => "-",
            tzm => "-",
            ug => "-",
            uk => "-",
            ur => "\u{200e}-",
            ur_IN => "\u{200e}-\u{200e}",
            uz => "-",
            uz_Arab => "\u{200e}-\u{200e}",
            uz_Cyrl => "-",
            uz_Latn => "-",
            vai => "-",
            vai_Latn => "-",
            vai_Vaii => "-",
            vi => "-",
            vo => "-",
            vun => "-",
            wae => "-",
            wo => "-",
            xh => "-",
            xog => "-",
            yav => "-",
            yi => "-",
            yo => "-",
            yo_BJ => "-",
            yue => "-",
            yue_Hans => "-",
            yue_Hant => "-",
            zgh => "-",
            zh => "-",
            zh_Hans => "-",
            zh_Hans_HK => "-",
            zh_Hans_MO => "-",
            zh_Hans_SG => "-",
            zh_Hant => "-",
            zh_Hant_HK => "-",
            zh_Hant_MO => "-",
            zu => "-",
        }
    }
    #[doc = r" Returns the locale's name."]
    pub fn name(&self) -> &'static str {
        use self::Locale::*;
        match self {
            af => "af",
            af_NA => "af-NA",
            agq => "agq",
            ak => "ak",
            am => "am",
            ar => "ar",
            ar_AE => "ar-AE",
            ar_BH => "ar-BH",
            ar_DJ => "ar-DJ",
            ar_DZ => "ar-DZ",
            ar_EG => "ar-EG",
            ar_EH => "ar-EH",
            ar_ER => "ar-ER",
            ar_IL => "ar-IL",
            ar_IQ => "ar-IQ",
            ar_JO => "ar-JO",
            ar_KM => "ar-KM",
            ar_KW => "ar-KW",
            ar_LB => "ar-LB",
            ar_LY => "ar-LY",
            ar_MA => "ar-MA",
            ar_MR => "ar-MR",
            ar_OM => "ar-OM",
            ar_PS => "ar-PS",
            ar_QA => "ar-QA",
            ar_SA => "ar-SA",
            ar_SD => "ar-SD",
            ar_SO => "ar-SO",
            ar_SS => "ar-SS",
            ar_SY => "ar-SY",
            ar_TD => "ar-TD",
            ar_TN => "ar-TN",
            ar_YE => "ar-YE",
            as_ => "as",
            asa => "asa",
            ast => "ast",
            az => "az",
            az_Cyrl => "az-Cyrl",
            az_Latn => "az-Latn",
            bas => "bas",
            be => "be",
            bem => "bem",
            bez => "bez",
            bg => "bg",
            bm => "bm",
            bn => "bn",
            bn_IN => "bn-IN",
            bo => "bo",
            bo_IN => "bo-IN",
            br => "br",
            brx => "brx",
            bs => "bs",
            bs_Cyrl => "bs-Cyrl",
            bs_Latn => "bs-Latn",
            ca => "ca",
            ca_AD => "ca-AD",
            ca_ES_VALENCIA => "ca-ES-VALENCIA",
            ca_FR => "ca-FR",
            ca_IT => "ca-IT",
            ccp => "ccp",
            ccp_IN => "ccp-IN",
            ce => "ce",
            cgg => "cgg",
            chr => "chr",
            ckb => "ckb",
            ckb_IR => "ckb-IR",
            cs => "cs",
            cu => "cu",
            cy => "cy",
            da => "da",
            da_GL => "da-GL",
            dav => "dav",
            de => "de",
            de_AT => "de-AT",
            de_BE => "de-BE",
            de_CH => "de-CH",
            de_IT => "de-IT",
            de_LI => "de-LI",
            de_LU => "de-LU",
            dje => "dje",
            dsb => "dsb",
            dua => "dua",
            dyo => "dyo",
            dz => "dz",
            ebu => "ebu",
            ee => "ee",
            ee_TG => "ee-TG",
            el => "el",
            el_CY => "el-CY",
            en => "en",
            en_001 => "en-001",
            en_150 => "en-150",
            en_AG => "en-AG",
            en_AI => "en-AI",
            en_AS => "en-AS",
            en_AT => "en-AT",
            en_AU => "en-AU",
            en_BB => "en-BB",
            en_BE => "en-BE",
            en_BI => "en-BI",
            en_BM => "en-BM",
            en_BS => "en-BS",
            en_BW => "en-BW",
            en_BZ => "en-BZ",
            en_CA => "en-CA",
            en_CC => "en-CC",
            en_CH => "en-CH",
            en_CK => "en-CK",
            en_CM => "en-CM",
            en_CX => "en-CX",
            en_CY => "en-CY",
            en_DE => "en-DE",
            en_DG => "en-DG",
            en_DK => "en-DK",
            en_DM => "en-DM",
            en_ER => "en-ER",
            en_FI => "en-FI",
            en_FJ => "en-FJ",
            en_FK => "en-FK",
            en_FM => "en-FM",
            en_GB => "en-GB",
            en_GD => "en-GD",
            en_GG => "en-GG",
            en_GH => "en-GH",
            en_GI => "en-GI",
            en_GM => "en-GM",
            en_GU => "en-GU",
            en_GY => "en-GY",
            en_HK => "en-HK",
            en_IE => "en-IE",
            en_IL => "en-IL",
            en_IM => "en-IM",
            en_IN => "en-IN",
            en_IO => "en-IO",
            en_JE => "en-JE",
            en_JM => "en-JM",
            en_KE => "en-KE",
            en_KI => "en-KI",
            en_KN => "en-KN",
            en_KY => "en-KY",
            en_LC => "en-LC",
            en_LR => "en-LR",
            en_LS => "en-LS",
            en_MG => "en-MG",
            en_MH => "en-MH",
            en_MO => "en-MO",
            en_MP => "en-MP",
            en_MS => "en-MS",
            en_MT => "en-MT",
            en_MU => "en-MU",
            en_MW => "en-MW",
            en_MY => "en-MY",
            en_NA => "en-NA",
            en_NF => "en-NF",
            en_NG => "en-NG",
            en_NL => "en-NL",
            en_NR => "en-NR",
            en_NU => "en-NU",
            en_NZ => "en-NZ",
            en_PG => "en-PG",
            en_PH => "en-PH",
            en_PK => "en-PK",
            en_PN => "en-PN",
            en_PR => "en-PR",
            en_PW => "en-PW",
            en_RW => "en-RW",
            en_SB => "en-SB",
            en_SC => "en-SC",
            en_SD => "en-SD",
            en_SE => "en-SE",
            en_SG => "en-SG",
            en_SH => "en-SH",
            en_SI => "en-SI",
            en_SL => "en-SL",
            en_SS => "en-SS",
            en_SX => "en-SX",
            en_SZ => "en-SZ",
            en_TC => "en-TC",
            en_TK => "en-TK",
            en_TO => "en-TO",
            en_TT => "en-TT",
            en_TV => "en-TV",
            en_TZ => "en-TZ",
            en_UG => "en-UG",
            en_UM => "en-UM",
            en_US_POSIX => "en-US-POSIX",
            en_VC => "en-VC",
            en_VG => "en-VG",
            en_VI => "en-VI",
            en_VU => "en-VU",
            en_WS => "en-WS",
            en_ZA => "en-ZA",
            en_ZM => "en-ZM",
            en_ZW => "en-ZW",
            eo => "eo",
            es => "es",
            es_419 => "es-419",
            es_AR => "es-AR",
            es_BO => "es-BO",
            es_BR => "es-BR",
            es_BZ => "es-BZ",
            es_CL => "es-CL",
            es_CO => "es-CO",
            es_CR => "es-CR",
            es_CU => "es-CU",
            es_DO => "es-DO",
            es_EA => "es-EA",
            es_EC => "es-EC",
            es_GQ => "es-GQ",
            es_GT => "es-GT",
            es_HN => "es-HN",
            es_IC => "es-IC",
            es_MX => "es-MX",
            es_NI => "es-NI",
            es_PA => "es-PA",
            es_PE => "es-PE",
            es_PH => "es-PH",
            es_PR => "es-PR",
            es_PY => "es-PY",
            es_SV => "es-SV",
            es_US => "es-US",
            es_UY => "es-UY",
            es_VE => "es-VE",
            et => "et",
            eu => "eu",
            ewo => "ewo",
            fa => "fa",
            fa_AF => "fa-AF",
            ff => "ff",
            ff_Latn => "ff-Latn",
            ff_Latn_BF => "ff-Latn-BF",
            ff_Latn_CM => "ff-Latn-CM",
            ff_Latn_GH => "ff-Latn-GH",
            ff_Latn_GM => "ff-Latn-GM",
            ff_Latn_GN => "ff-Latn-GN",
            ff_Latn_GW => "ff-Latn-GW",
            ff_Latn_LR => "ff-Latn-LR",
            ff_Latn_MR => "ff-Latn-MR",
            ff_Latn_NE => "ff-Latn-NE",
            ff_Latn_NG => "ff-Latn-NG",
            ff_Latn_SL => "ff-Latn-SL",
            fi => "fi",
            fil => "fil",
            fo => "fo",
            fo_DK => "fo-DK",
            fr => "fr",
            fr_BE => "fr-BE",
            fr_BF => "fr-BF",
            fr_BI => "fr-BI",
            fr_BJ => "fr-BJ",
            fr_BL => "fr-BL",
            fr_CA => "fr-CA",
            fr_CD => "fr-CD",
            fr_CF => "fr-CF",
            fr_CG => "fr-CG",
            fr_CH => "fr-CH",
            fr_CI => "fr-CI",
            fr_CM => "fr-CM",
            fr_DJ => "fr-DJ",
            fr_DZ => "fr-DZ",
            fr_GA => "fr-GA",
            fr_GF => "fr-GF",
            fr_GN => "fr-GN",
            fr_GP => "fr-GP",
            fr_GQ => "fr-GQ",
            fr_HT => "fr-HT",
            fr_KM => "fr-KM",
            fr_LU => "fr-LU",
            fr_MA => "fr-MA",
            fr_MC => "fr-MC",
            fr_MF => "fr-MF",
            fr_MG => "fr-MG",
            fr_ML => "fr-ML",
            fr_MQ => "fr-MQ",
            fr_MR => "fr-MR",
            fr_MU => "fr-MU",
            fr_NC => "fr-NC",
            fr_NE => "fr-NE",
            fr_PF => "fr-PF",
            fr_PM => "fr-PM",
            fr_RE => "fr-RE",
            fr_RW => "fr-RW",
            fr_SC => "fr-SC",
            fr_SN => "fr-SN",
            fr_SY => "fr-SY",
            fr_TD => "fr-TD",
            fr_TG => "fr-TG",
            fr_TN => "fr-TN",
            fr_VU => "fr-VU",
            fr_WF => "fr-WF",
            fr_YT => "fr-YT",
            fur => "fur",
            fy => "fy",
            ga => "ga",
            gd => "gd",
            gl => "gl",
            gsw => "gsw",
            gsw_FR => "gsw-FR",
            gsw_LI => "gsw-LI",
            gu => "gu",
            guz => "guz",
            gv => "gv",
            ha => "ha",
            ha_GH => "ha-GH",
            ha_NE => "ha-NE",
            haw => "haw",
            he => "he",
            hi => "hi",
            hr => "hr",
            hr_BA => "hr-BA",
            hsb => "hsb",
            hu => "hu",
            hy => "hy",
            ia => "ia",
            id => "id",
            ig => "ig",
            ii => "ii",
            is => "is",
            it => "it",
            it_CH => "it-CH",
            it_SM => "it-SM",
            it_VA => "it-VA",
            ja => "ja",
            jgo => "jgo",
            jmc => "jmc",
            jv => "jv",
            ka => "ka",
            kab => "kab",
            kam => "kam",
            kde => "kde",
            kea => "kea",
            khq => "khq",
            ki => "ki",
            kk => "kk",
            kkj => "kkj",
            kl => "kl",
            kln => "kln",
            km => "km",
            kn => "kn",
            ko => "ko",
            ko_KP => "ko-KP",
            kok => "kok",
            ks => "ks",
            ksb => "ksb",
            ksf => "ksf",
            ksh => "ksh",
            ku => "ku",
            kw => "kw",
            ky => "ky",
            lag => "lag",
            lb => "lb",
            lg => "lg",
            lkt => "lkt",
            ln => "ln",
            ln_AO => "ln-AO",
            ln_CF => "ln-CF",
            ln_CG => "ln-CG",
            lo => "lo",
            lrc => "lrc",
            lrc_IQ => "lrc-IQ",
            lt => "lt",
            lu => "lu",
            luo => "luo",
            luy => "luy",
            lv => "lv",
            mas => "mas",
            mas_TZ => "mas-TZ",
            mer => "mer",
            mfe => "mfe",
            mg => "mg",
            mgh => "mgh",
            mgo => "mgo",
            mi => "mi",
            mk => "mk",
            ml => "ml",
            mn => "mn",
            mr => "mr",
            ms => "ms",
            ms_BN => "ms-BN",
            ms_SG => "ms-SG",
            mt => "mt",
            mua => "mua",
            my => "my",
            mzn => "mzn",
            naq => "naq",
            nb => "nb",
            nb_SJ => "nb-SJ",
            nd => "nd",
            nds => "nds",
            nds_NL => "nds-NL",
            ne => "ne",
            ne_IN => "ne-IN",
            nl => "nl",
            nl_AW => "nl-AW",
            nl_BE => "nl-BE",
            nl_BQ => "nl-BQ",
            nl_CW => "nl-CW",
            nl_SR => "nl-SR",
            nl_SX => "nl-SX",
            nmg => "nmg",
            nn => "nn",
            nnh => "nnh",
            nus => "nus",
            nyn => "nyn",
            om => "om",
            om_KE => "om-KE",
            or => "or",
            os => "os",
            os_RU => "os-RU",
            pa => "pa",
            pa_Arab => "pa-Arab",
            pa_Guru => "pa-Guru",
            pl => "pl",
            prg => "prg",
            ps => "ps",
            pt => "pt",
            pt_AO => "pt-AO",
            pt_CH => "pt-CH",
            pt_CV => "pt-CV",
            pt_GQ => "pt-GQ",
            pt_GW => "pt-GW",
            pt_LU => "pt-LU",
            pt_MO => "pt-MO",
            pt_MZ => "pt-MZ",
            pt_PT => "pt-PT",
            pt_ST => "pt-ST",
            pt_TL => "pt-TL",
            qu => "qu",
            qu_BO => "qu-BO",
            qu_EC => "qu-EC",
            rm => "rm",
            rn => "rn",
            ro => "ro",
            ro_MD => "ro-MD",
            rof => "rof",
            root => "root",
            ru => "ru",
            ru_BY => "ru-BY",
            ru_KG => "ru-KG",
            ru_KZ => "ru-KZ",
            ru_MD => "ru-MD",
            ru_UA => "ru-UA",
            rw => "rw",
            rwk => "rwk",
            sah => "sah",
            saq => "saq",
            sbp => "sbp",
            sd => "sd",
            se => "se",
            se_FI => "se-FI",
            se_SE => "se-SE",
            seh => "seh",
            ses => "ses",
            sg => "sg",
            shi => "shi",
            shi_Latn => "shi-Latn",
            shi_Tfng => "shi-Tfng",
            si => "si",
            sk => "sk",
            sl => "sl",
            smn => "smn",
            sn => "sn",
            so => "so",
            so_DJ => "so-DJ",
            so_ET => "so-ET",
            so_KE => "so-KE",
            sq => "sq",
            sq_MK => "sq-MK",
            sq_XK => "sq-XK",
            sr => "sr",
            sr_Cyrl => "sr-Cyrl",
            sr_Cyrl_BA => "sr-Cyrl-BA",
            sr_Cyrl_ME => "sr-Cyrl-ME",
            sr_Cyrl_XK => "sr-Cyrl-XK",
            sr_Latn => "sr-Latn",
            sr_Latn_BA => "sr-Latn-BA",
            sr_Latn_ME => "sr-Latn-ME",
            sr_Latn_XK => "sr-Latn-XK",
            sv => "sv",
            sv_AX => "sv-AX",
            sv_FI => "sv-FI",
            sw => "sw",
            sw_CD => "sw-CD",
            sw_KE => "sw-KE",
            sw_UG => "sw-UG",
            ta => "ta",
            ta_LK => "ta-LK",
            ta_MY => "ta-MY",
            ta_SG => "ta-SG",
            te => "te",
            teo => "teo",
            teo_KE => "teo-KE",
            tg => "tg",
            th => "th",
            ti => "ti",
            ti_ER => "ti-ER",
            tk => "tk",
            to => "to",
            tr => "tr",
            tr_CY => "tr-CY",
            tt => "tt",
            twq => "twq",
            tzm => "tzm",
            ug => "ug",
            uk => "uk",
            ur => "ur",
            ur_IN => "ur-IN",
            uz => "uz",
            uz_Arab => "uz-Arab",
            uz_Cyrl => "uz-Cyrl",
            uz_Latn => "uz-Latn",
            vai => "vai",
            vai_Latn => "vai-Latn",
            vai_Vaii => "vai-Vaii",
            vi => "vi",
            vo => "vo",
            vun => "vun",
            wae => "wae",
            wo => "wo",
            xh => "xh",
            xog => "xog",
            yav => "yav",
            yi => "yi",
            yo => "yo",
            yo_BJ => "yo-BJ",
            yue => "yue",
            yue_Hans => "yue-Hans",
            yue_Hant => "yue-Hant",
            zgh => "zgh",
            zh => "zh",
            zh_Hans => "zh-Hans",
            zh_Hans_HK => "zh-Hans-HK",
            zh_Hans_MO => "zh-Hans-MO",
            zh_Hans_SG => "zh-Hans-SG",
            zh_Hant => "zh-Hant",
            zh_Hant_HK => "zh-Hant-HK",
            zh_Hant_MO => "zh-Hant-MO",
            zu => "zu",
        }
    }
    #[doc = r" Returns the locale's NaN representation."]
    pub fn nan(&self) -> &'static str {
        use self::Locale::*;
        match self {  af => "NaN" ,   af_NA => "NaN" ,   agq => "NaN" ,   ak => "NaN" ,   am => "NaN" ,   ar => "\u{644}\u{64a}\u{633}\u{a0}\u{631}\u{642}\u{645}" ,   ar_AE => "\u{644}\u{64a}\u{633}\u{a0}\u{631}\u{642}\u{645}" ,   ar_BH => "\u{644}\u{64a}\u{633}\u{a0}\u{631}\u{642}\u{645}" ,   ar_DJ => "\u{644}\u{64a}\u{633}\u{a0}\u{631}\u{642}\u{645}" ,   ar_DZ => "\u{644}\u{64a}\u{633}\u{a0}\u{631}\u{642}\u{645}\u{64b}\u{627}" ,   ar_EG => "\u{644}\u{64a}\u{633}\u{a0}\u{631}\u{642}\u{645}" ,   ar_EH => "\u{644}\u{64a}\u{633}\u{a0}\u{631}\u{642}\u{645}\u{64b}\u{627}" ,   ar_ER => "\u{644}\u{64a}\u{633}\u{a0}\u{631}\u{642}\u{645}" ,   ar_IL => "\u{644}\u{64a}\u{633}\u{a0}\u{631}\u{642}\u{645}" ,   ar_IQ => "\u{644}\u{64a}\u{633}\u{a0}\u{631}\u{642}\u{645}" ,   ar_JO => "\u{644}\u{64a}\u{633}\u{a0}\u{631}\u{642}\u{645}" ,   ar_KM => "\u{644}\u{64a}\u{633}\u{a0}\u{631}\u{642}\u{645}" ,   ar_KW => "\u{644}\u{64a}\u{633}\u{a0}\u{631}\u{642}\u{645}" ,   ar_LB => "\u{644}\u{64a}\u{633}\u{a0}\u{631}\u{642}\u{645}" ,   ar_LY => "\u{644}\u{64a}\u{633}\u{a0}\u{631}\u{642}\u{645}\u{64b}\u{627}" ,   ar_MA => "\u{644}\u{64a}\u{633}\u{a0}\u{631}\u{642}\u{645}\u{64b}\u{627}" ,   ar_MR => "\u{644}\u{64a}\u{633}\u{a0}\u{631}\u{642}\u{645}" ,   ar_OM => "\u{644}\u{64a}\u{633}\u{a0}\u{631}\u{642}\u{645}" ,   ar_PS => "\u{644}\u{64a}\u{633}\u{a0}\u{631}\u{642}\u{645}" ,   ar_QA => "\u{644}\u{64a}\u{633}\u{a0}\u{631}\u{642}\u{645}" ,   ar_SA => "\u{644}\u{64a}\u{633}\u{a0}\u{631}\u{642}\u{645}" ,   ar_SD => "\u{644}\u{64a}\u{633}\u{a0}\u{631}\u{642}\u{645}" ,   ar_SO => "\u{644}\u{64a}\u{633}\u{a0}\u{631}\u{642}\u{645}" ,   ar_SS => "\u{644}\u{64a}\u{633}\u{a0}\u{631}\u{642}\u{645}" ,   ar_SY => "\u{644}\u{64a}\u{633}\u{a0}\u{631}\u{642}\u{645}" ,   ar_TD => "\u{644}\u{64a}\u{633}\u{a0}\u{631}\u{642}\u{645}" ,   ar_TN => "\u{644}\u{64a}\u{633}\u{a0}\u{631}\u{642}\u{645}\u{64b}\u{627}" ,   ar_YE => "\u{644}\u{64a}\u{633}\u{a0}\u{631}\u{642}\u{645}" ,   as_ => "NaN" ,   asa => "NaN" ,   ast => "ND" ,   az => "NaN" ,   az_Cyrl => "NaN" ,   az_Latn => "NaN" ,   bas => "NaN" ,   be => "NaN" ,   bem => "NaN" ,   bez => "NaN" ,   bg => "NaN" ,   bm => "NaN" ,   bn => "NaN" ,   bn_IN => "NaN" ,   bo => "NaN" ,   bo_IN => "NaN" ,   br => "NaN" ,   brx => "NaN" ,   bs => "NaN" ,   bs_Cyrl => "NaN" ,   bs_Latn => "NaN" ,   ca => "NaN" ,   ca_AD => "NaN" ,   ca_ES_VALENCIA => "NaN" ,   ca_FR => "NaN" ,   ca_IT => "NaN" ,   ccp => "NaN" ,   ccp_IN => "NaN" ,   ce => "\u{422}\u{435}\u{440}\u{445}\u{44c}\u{430}\u{448}\u{a0}\u{434}\u{430}\u{446}" ,   cgg => "NaN" ,   chr => "NaN" ,   ckb => "NaN" ,   ckb_IR => "NaN" ,   cs => "NaN" ,   cu => "NaN" ,   cy => "NaN" ,   da => "NaN" ,   da_GL => "NaN" ,   dav => "NaN" ,   de => "NaN" ,   de_AT => "NaN" ,   de_BE => "NaN" ,   de_CH => "NaN" ,   de_IT => "NaN" ,   de_LI => "NaN" ,   de_LU => "NaN" ,   dje => "NaN" ,   dsb => "NaN" ,   dua => "NaN" ,   dyo => "NaN" ,   dz => "\u{f68}\u{f44}\u{f0b}\u{f58}\u{f51}" ,   ebu => "NaN" ,   ee => "mnn" ,   ee_TG => "mnn" ,   el => "NaN" ,   el_CY => "NaN" ,   en => "NaN" ,   en_001 => "NaN" ,   en_150 => "NaN" ,   en_AG => "NaN" ,   en_AI => "NaN" ,   en_AS => "NaN" ,   en_AT => "NaN" ,   en_AU => "NaN" ,   en_BB => "NaN" ,   en_BE => "NaN" ,   en_BI => "NaN" ,   en_BM => "NaN" ,   en_BS => "NaN" ,   en_BW => "NaN" ,   en_BZ => "NaN" ,   en_CA => "NaN" ,   en_CC => "NaN" ,   en_CH => "NaN" ,   en_CK => "NaN" ,   en_CM => "NaN" ,   en_CX => "NaN" ,   en_CY => "NaN" ,   en_DE => "NaN" ,   en_DG => "NaN" ,   en_DK => "NaN" ,   en_DM => "NaN" ,   en_ER => "NaN" ,   en_FI => "NaN" ,   en_FJ => "NaN" ,   en_FK => "NaN" ,   en_FM => "NaN" ,   en_GB => "NaN" ,   en_GD => "NaN" ,   en_GG => "NaN" ,   en_GH => "NaN" ,   en_GI => "NaN" ,   en_GM => "NaN" ,   en_GU => "NaN" ,   en_GY => "NaN" ,   en_HK => "NaN" ,   en_IE => "NaN" ,   en_IL => "NaN" ,   en_IM => "NaN" ,   en_IN => "NaN" ,   en_IO => "NaN" ,   en_JE => "NaN" ,   en_JM => "NaN" ,   en_KE => "NaN" ,   en_KI => "NaN" ,   en_KN => "NaN" ,   en_KY => "NaN" ,   en_LC => "NaN" ,   en_LR => "NaN" ,   en_LS => "NaN" ,   en_MG => "NaN" ,   en_MH => "NaN" ,   en_MO => "NaN" ,   en_MP => "NaN" ,   en_MS => "NaN" ,   en_MT => "NaN" ,   en_MU => "NaN" ,   en_MW => "NaN" ,   en_MY => "NaN" ,   en_NA => "NaN" ,   en_NF => "NaN" ,   en_NG => "NaN" ,   en_NL => "NaN" ,   en_NR => "NaN" ,   en_NU => "NaN" ,   en_NZ => "NaN" ,   en_PG => "NaN" ,   en_PH => "NaN" ,   en_PK => "NaN" ,   en_PN => "NaN" ,   en_PR => "NaN" ,   en_PW => "NaN" ,   en_RW => "NaN" ,   en_SB => "NaN" ,   en_SC => "NaN" ,   en_SD => "NaN" ,   en_SE => "NaN" ,   en_SG => "NaN" ,   en_SH => "NaN" ,   en_SI => "NaN" ,   en_SL => "NaN" ,   en_SS => "NaN" ,   en_SX => "NaN" ,   en_SZ => "NaN" ,   en_TC => "NaN" ,   en_TK => "NaN" ,   en_TO => "NaN" ,   en_TT => "NaN" ,   en_TV => "NaN" ,   en_TZ => "NaN" ,   en_UG => "NaN" ,   en_UM => "NaN" ,   en_US_POSIX => "NaN" ,   en_VC => "NaN" ,   en_VG => "NaN" ,   en_VI => "NaN" ,   en_VU => "NaN" ,   en_WS => "NaN" ,   en_ZA => "NaN" ,   en_ZM => "NaN" ,   en_ZW => "NaN" ,   eo => "NaN" ,   es => "NaN" ,   es_419 => "NaN" ,   es_AR => "NaN" ,   es_BO => "NaN" ,   es_BR => "NaN" ,   es_BZ => "NaN" ,   es_CL => "NaN" ,   es_CO => "NaN" ,   es_CR => "NaN" ,   es_CU => "NaN" ,   es_DO => "NaN" ,   es_EA => "NaN" ,   es_EC => "NaN" ,   es_GQ => "NaN" ,   es_GT => "NaN" ,   es_HN => "NaN" ,   es_IC => "NaN" ,   es_MX => "NaN" ,   es_NI => "NaN" ,   es_PA => "NaN" ,   es_PE => "NaN" ,   es_PH => "NaN" ,   es_PR => "NaN" ,   es_PY => "NaN" ,   es_SV => "NaN" ,   es_US => "NaN" ,   es_UY => "NaN" ,   es_VE => "NaN" ,   et => "NaN" ,   eu => "NaN" ,   ewo => "NaN" ,   fa => "\u{646}\u{627}\u{639}\u{62f}\u{62f}" ,   fa_AF => "\u{646}\u{627}\u{639}\u{62f}\u{62f}" ,   ff => "NaN" ,   ff_Latn => "NaN" ,   ff_Latn_BF => "NaN" ,   ff_Latn_CM => "NaN" ,   ff_Latn_GH => "NaN" ,   ff_Latn_GM => "NaN" ,   ff_Latn_GN => "NaN" ,   ff_Latn_GW => "NaN" ,   ff_Latn_LR => "NaN" ,   ff_Latn_MR => "NaN" ,   ff_Latn_NE => "NaN" ,   ff_Latn_NG => "NaN" ,   ff_Latn_SL => "NaN" ,   fi => "ep\u{e4}luku" ,   fil => "NaN" ,   fo => "NaN" ,   fo_DK => "NaN" ,   fr => "NaN" ,   fr_BE => "NaN" ,   fr_BF => "NaN" ,   fr_BI => "NaN" ,   fr_BJ => "NaN" ,   fr_BL => "NaN" ,   fr_CA => "NaN" ,   fr_CD => "NaN" ,   fr_CF => "NaN" ,   fr_CG => "NaN" ,   fr_CH => "NaN" ,   fr_CI => "NaN" ,   fr_CM => "NaN" ,   fr_DJ => "NaN" ,   fr_DZ => "NaN" ,   fr_GA => "NaN" ,   fr_GF => "NaN" ,   fr_GN => "NaN" ,   fr_GP => "NaN" ,   fr_GQ => "NaN" ,   fr_HT => "NaN" ,   fr_KM => "NaN" ,   fr_LU => "NaN" ,   fr_MA => "NaN" ,   fr_MC => "NaN" ,   fr_MF => "NaN" ,   fr_MG => "NaN" ,   fr_ML => "NaN" ,   fr_MQ => "NaN" ,   fr_MR => "NaN" ,   fr_MU => "NaN" ,   fr_NC => "NaN" ,   fr_NE => "NaN" ,   fr_PF => "NaN" ,   fr_PM => "NaN" ,   fr_RE => "NaN" ,   fr_RW => "NaN" ,   fr_SC => "NaN" ,   fr_SN => "NaN" ,   fr_SY => "NaN" ,   fr_TD => "NaN" ,   fr_TG => "NaN" ,   fr_TN => "NaN" ,   fr_VU => "NaN" ,   fr_WF => "NaN" ,   fr_YT => "NaN" ,   fur => "NaN" ,   fy => "NaN" ,   ga => "NaN" ,   gd => "NaN" ,   gl => "NaN" ,   gsw => "NaN" ,   gsw_FR => "NaN" ,   gsw_LI => "NaN" ,   gu => "NaN" ,   guz => "NaN" ,   gv => "NaN" ,   ha => "NaN" ,   ha_GH => "NaN" ,   ha_NE => "NaN" ,   haw => "NaN" ,   he => "NaN" ,   hi => "NaN" ,   hr => "NaN" ,   hr_BA => "NaN" ,   hsb => "NaN" ,   hu => "NaN" ,   hy => "\u{548}\u{579}\u{539}" ,   ia => "NaN" ,   id => "NaN" ,   ig => "NaN" ,   ii => "NaN" ,   is => "NaN" ,   it => "NaN" ,   it_CH => "NaN" ,   it_SM => "NaN" ,   it_VA => "NaN" ,   ja => "NaN" ,   jgo => "NaN" ,   jmc => "NaN" ,   jv => "NaN" ,   ka => "\u{10d0}\u{10e0}\u{a0}\u{10d0}\u{10e0}\u{10d8}\u{10e1}\u{a0}\u{10e0}\u{10d8}\u{10ea}\u{10ee}\u{10d5}\u{10d8}" ,   kab => "NaN" ,   kam => "NaN" ,   kde => "NaN" ,   kea => "NaN" ,   khq => "NaN" ,   ki => "NaN" ,   kk => "\u{441}\u{430}\u{43d}\u{a0}\u{435}\u{43c}\u{435}\u{441}" ,   kkj => "NaN" ,   kl => "NaN" ,   kln => "NaN" ,   km => "NaN" ,   kn => "NaN" ,   ko => "NaN" ,   ko_KP => "NaN" ,   kok => "NaN" ,   ks => "NaN" ,   ksb => "NaN" ,   ksf => "NaN" ,   ksh => "\u{a4}\u{a4}\u{a4}" ,   ku => "NaN" ,   kw => "NaN" ,   ky => "\u{441}\u{430}\u{43d}\u{a0}\u{44d}\u{43c}\u{435}\u{441}" ,   lag => "NaN" ,   lb => "NaN" ,   lg => "NaN" ,   lkt => "NaN" ,   ln => "NaN" ,   ln_AO => "NaN" ,   ln_CF => "NaN" ,   ln_CG => "NaN" ,   lo => "\u{e9a}\u{ecd}\u{ec8}\u{200b}\u{ec1}\u{ea1}\u{ec8}\u{e99}\u{200b}\u{ec2}\u{e95}\u{200b}\u{ec0}\u{ea5}\u{e81}" ,   lrc => "NaN" ,   lrc_IQ => "NaN" ,   lt => "NaN" ,   lu => "NaN" ,   luo => "NaN" ,   luy => "NaN" ,   lv => "NS" ,   mas => "NaN" ,   mas_TZ => "NaN" ,   mer => "NaN" ,   mfe => "NaN" ,   mg => "NaN" ,   mgh => "NaN" ,   mgo => "NaN" ,   mi => "NaN" ,   mk => "NaN" ,   ml => "NaN" ,   mn => "NaN" ,   mr => "NaN" ,   ms => "NaN" ,   ms_BN => "NaN" ,   ms_SG => "NaN" ,   mt => "NaN" ,   mua => "NaN" ,   my => "\u{1002}\u{100f}\u{1014}\u{103a}\u{1038}\u{1019}\u{101f}\u{102f}\u{1010}\u{103a}\u{101e}\u{1031}\u{102c}" ,   mzn => "NaN" ,   naq => "NaN" ,   nb => "NaN" ,   nb_SJ => "NaN" ,   nd => "NaN" ,   nds => "NaN" ,   nds_NL => "NaN" ,   ne => "NaN" ,   ne_IN => "NaN" ,   nl => "NaN" ,   nl_AW => "NaN" ,   nl_BE => "NaN" ,   nl_BQ => "NaN" ,   nl_CW => "NaN" ,   nl_SR => "NaN" ,   nl_SX => "NaN" ,   nmg => "NaN" ,   nn => "NaN" ,   nnh => "NaN" ,   nus => "NaN" ,   nyn => "NaN" ,   om => "NaN" ,   om_KE => "NaN" ,   or => "NaN" ,   os => "\u{41d}\u{41d}" ,   os_RU => "\u{41d}\u{41d}" ,   pa => "NaN" ,   pa_Arab => "NaN" ,   pa_Guru => "NaN" ,   pl => "NaN" ,   prg => "NaN" ,   ps => "NaN" ,   pt => "NaN" ,   pt_AO => "NaN" ,   pt_CH => "NaN" ,   pt_CV => "NaN" ,   pt_GQ => "NaN" ,   pt_GW => "NaN" ,   pt_LU => "NaN" ,   pt_MO => "NaN" ,   pt_MZ => "NaN" ,   pt_PT => "NaN" ,   pt_ST => "NaN" ,   pt_TL => "NaN" ,   qu => "NaN" ,   qu_BO => "NaN" ,   qu_EC => "NaN" ,   rm => "NaN" ,   rn => "NaN" ,   ro => "NaN" ,   ro_MD => "NaN" ,   rof => "NaN" ,   root => "NaN" ,   ru => "\u{43d}\u{435}\u{a0}\u{447}\u{438}\u{441}\u{43b}\u{43e}" ,   ru_BY => "\u{43d}\u{435}\u{a0}\u{447}\u{438}\u{441}\u{43b}\u{43e}" ,   ru_KG => "\u{43d}\u{435}\u{a0}\u{447}\u{438}\u{441}\u{43b}\u{43e}" ,   ru_KZ => "\u{43d}\u{435}\u{a0}\u{447}\u{438}\u{441}\u{43b}\u{43e}" ,   ru_MD => "\u{43d}\u{435}\u{a0}\u{447}\u{438}\u{441}\u{43b}\u{43e}" ,   ru_UA => "\u{43d}\u{435}\u{a0}\u{447}\u{438}\u{441}\u{43b}\u{43e}" ,   rw => "NaN" ,   rwk => "NaN" ,   sah => "\u{447}\u{44b}\u{44b}\u{4bb}\u{44b}\u{43b}\u{430}\u{a0}\u{431}\u{443}\u{43e}\u{442}\u{430}\u{445}" ,   saq => "NaN" ,   sbp => "NaN" ,   sd => "NaN" ,   se => "\u{a4}\u{a4}\u{a4}" ,   se_FI => "\u{a4}\u{a4}\u{a4}" ,   se_SE => "\u{a4}\u{a4}\u{a4}" ,   seh => "NaN" ,   ses => "NaN" ,   sg => "NaN" ,   shi => "NaN" ,   shi_Latn => "NaN" ,   shi_Tfng => "NaN" ,   si => "NaN" ,   sk => "NaN" ,   sl => "NaN" ,   smn => "epiloho" ,   sn => "NaN" ,   so => "NaN" ,   so_DJ => "NaN" ,   so_ET => "NaN" ,   so_KE => "NaN" ,   sq => "NaN" ,   sq_MK => "NaN" ,   sq_XK => "NaN" ,   sr => "NaN" ,   sr_Cyrl => "NaN" ,   sr_Cyrl_BA => "NaN" ,   sr_Cyrl_ME => "NaN" ,   sr_Cyrl_XK => "NaN" ,   sr_Latn => "NaN" ,   sr_Latn_BA => "NaN" ,   sr_Latn_ME => "NaN" ,   sr_Latn_XK => "NaN" ,   sv => "\u{a4}\u{a4}\u{a4}" ,   sv_AX => "\u{a4}\u{a4}\u{a4}" ,   sv_FI => "\u{a4}\u{a4}\u{a4}" ,   sw => "NaN" ,   sw_CD => "NaN" ,   sw_KE => "NaN" ,   sw_UG => "NaN" ,   ta => "NaN" ,   ta_LK => "NaN" ,   ta_MY => "NaN" ,   ta_SG => "NaN" ,   te => "NaN" ,   teo => "NaN" ,   teo_KE => "NaN" ,   tg => "NaN" ,   th => "NaN" ,   ti => "NaN" ,   ti_ER => "NaN" ,   tk => "san\u{a0}d\u{e4}l" ,   to => "TF" ,   tr => "NaN" ,   tr_CY => "NaN" ,   tt => "NaN" ,   twq => "NaN" ,   tzm => "NaN" ,   ug => "NaN" ,   uk => "NaN" ,   ur => "NaN" ,   ur_IN => "NaN" ,   uz => "son\u{a0}emas" ,   uz_Arab => "NaN" ,   uz_Cyrl => "\u{4b3}\u{430}\u{49b}\u{438}\u{49b}\u{438}\u{439}\u{a0}\u{441}\u{43e}\u{43d}\u{a0}\u{44d}\u{43c}\u{430}\u{441}" ,   uz_Latn => "son\u{a0}emas" ,   vai => "NaN" ,   vai_Latn => "NaN" ,   vai_Vaii => "NaN" ,   vi => "NaN" ,   vo => "NaN" ,   vun => "NaN" ,   wae => "NaN" ,   wo => "NaN" ,   xh => "NaN" ,   xog => "NaN" ,   yav => "NaN" ,   yi => "NaN" ,   yo => "NaN" ,   yo_BJ => "NaN" ,   yue => "\u{975e}\u{6578}\u{503c}" ,   yue_Hans => "\u{975e}\u{6570}\u{503c}" ,   yue_Hant => "\u{975e}\u{6578}\u{503c}" ,   zgh => "NaN" ,   zh => "NaN" ,   zh_Hans => "NaN" ,   zh_Hans_HK => "NaN" ,   zh_Hans_MO => "NaN" ,   zh_Hans_SG => "NaN" ,   zh_Hant => "\u{975e}\u{6578}\u{503c}" ,   zh_Hant_HK => "\u{975e}\u{6578}\u{503c}" ,   zh_Hant_MO => "\u{975e}\u{6578}\u{503c}" ,   zu => "NaN" ,  }
    }
    #[doc = r" Returns the locale's plus sign representation."]
    pub fn plus_sign(&self) -> &'static str {
        use self::Locale::*;
        match self {
            af => "+",
            af_NA => "+",
            agq => "+",
            ak => "+",
            am => "+",
            ar => "\u{61c}+",
            ar_AE => "\u{61c}+",
            ar_BH => "\u{61c}+",
            ar_DJ => "\u{61c}+",
            ar_DZ => "\u{200e}+",
            ar_EG => "\u{61c}+",
            ar_EH => "\u{200e}+",
            ar_ER => "\u{61c}+",
            ar_IL => "\u{61c}+",
            ar_IQ => "\u{61c}+",
            ar_JO => "\u{61c}+",
            ar_KM => "\u{61c}+",
            ar_KW => "\u{61c}+",
            ar_LB => "\u{61c}+",
            ar_LY => "\u{200e}+",
            ar_MA => "\u{200e}+",
            ar_MR => "\u{61c}+",
            ar_OM => "\u{61c}+",
            ar_PS => "\u{61c}+",
            ar_QA => "\u{61c}+",
            ar_SA => "\u{61c}+",
            ar_SD => "\u{61c}+",
            ar_SO => "\u{61c}+",
            ar_SS => "\u{61c}+",
            ar_SY => "\u{61c}+",
            ar_TD => "\u{61c}+",
            ar_TN => "\u{200e}+",
            ar_YE => "\u{61c}+",
            as_ => "+",
            asa => "+",
            ast => "+",
            az => "+",
            az_Cyrl => "+",
            az_Latn => "+",
            bas => "+",
            be => "+",
            bem => "+",
            bez => "+",
            bg => "+",
            bm => "+",
            bn => "+",
            bn_IN => "+",
            bo => "+",
            bo_IN => "+",
            br => "+",
            brx => "+",
            bs => "+",
            bs_Cyrl => "+",
            bs_Latn => "+",
            ca => "+",
            ca_AD => "+",
            ca_ES_VALENCIA => "+",
            ca_FR => "+",
            ca_IT => "+",
            ccp => "+",
            ccp_IN => "+",
            ce => "+",
            cgg => "+",
            chr => "+",
            ckb => "\u{200f}+",
            ckb_IR => "\u{200f}+",
            cs => "+",
            cu => "+",
            cy => "+",
            da => "+",
            da_GL => "+",
            dav => "+",
            de => "+",
            de_AT => "+",
            de_BE => "+",
            de_CH => "+",
            de_IT => "+",
            de_LI => "+",
            de_LU => "+",
            dje => "+",
            dsb => "+",
            dua => "+",
            dyo => "+",
            dz => "+",
            ebu => "+",
            ee => "+",
            ee_TG => "+",
            el => "+",
            el_CY => "+",
            en => "+",
            en_001 => "+",
            en_150 => "+",
            en_AG => "+",
            en_AI => "+",
            en_AS => "+",
            en_AT => "+",
            en_AU => "+",
            en_BB => "+",
            en_BE => "+",
            en_BI => "+",
            en_BM => "+",
            en_BS => "+",
            en_BW => "+",
            en_BZ => "+",
            en_CA => "+",
            en_CC => "+",
            en_CH => "+",
            en_CK => "+",
            en_CM => "+",
            en_CX => "+",
            en_CY => "+",
            en_DE => "+",
            en_DG => "+",
            en_DK => "+",
            en_DM => "+",
            en_ER => "+",
            en_FI => "+",
            en_FJ => "+",
            en_FK => "+",
            en_FM => "+",
            en_GB => "+",
            en_GD => "+",
            en_GG => "+",
            en_GH => "+",
            en_GI => "+",
            en_GM => "+",
            en_GU => "+",
            en_GY => "+",
            en_HK => "+",
            en_IE => "+",
            en_IL => "+",
            en_IM => "+",
            en_IN => "+",
            en_IO => "+",
            en_JE => "+",
            en_JM => "+",
            en_KE => "+",
            en_KI => "+",
            en_KN => "+",
            en_KY => "+",
            en_LC => "+",
            en_LR => "+",
            en_LS => "+",
            en_MG => "+",
            en_MH => "+",
            en_MO => "+",
            en_MP => "+",
            en_MS => "+",
            en_MT => "+",
            en_MU => "+",
            en_MW => "+",
            en_MY => "+",
            en_NA => "+",
            en_NF => "+",
            en_NG => "+",
            en_NL => "+",
            en_NR => "+",
            en_NU => "+",
            en_NZ => "+",
            en_PG => "+",
            en_PH => "+",
            en_PK => "+",
            en_PN => "+",
            en_PR => "+",
            en_PW => "+",
            en_RW => "+",
            en_SB => "+",
            en_SC => "+",
            en_SD => "+",
            en_SE => "+",
            en_SG => "+",
            en_SH => "+",
            en_SI => "+",
            en_SL => "+",
            en_SS => "+",
            en_SX => "+",
            en_SZ => "+",
            en_TC => "+",
            en_TK => "+",
            en_TO => "+",
            en_TT => "+",
            en_TV => "+",
            en_TZ => "+",
            en_UG => "+",
            en_UM => "+",
            en_US_POSIX => "+",
            en_VC => "+",
            en_VG => "+",
            en_VI => "+",
            en_VU => "+",
            en_WS => "+",
            en_ZA => "+",
            en_ZM => "+",
            en_ZW => "+",
            eo => "+",
            es => "+",
            es_419 => "+",
            es_AR => "+",
            es_BO => "+",
            es_BR => "+",
            es_BZ => "+",
            es_CL => "+",
            es_CO => "+",
            es_CR => "+",
            es_CU => "+",
            es_DO => "+",
            es_EA => "+",
            es_EC => "+",
            es_GQ => "+",
            es_GT => "+",
            es_HN => "+",
            es_IC => "+",
            es_MX => "+",
            es_NI => "+",
            es_PA => "+",
            es_PE => "+",
            es_PH => "+",
            es_PR => "+",
            es_PY => "+",
            es_SV => "+",
            es_US => "+",
            es_UY => "+",
            es_VE => "+",
            et => "+",
            eu => "+",
            ewo => "+",
            fa => "\u{200e}+",
            fa_AF => "\u{200e}+",
            ff => "+",
            ff_Latn => "+",
            ff_Latn_BF => "+",
            ff_Latn_CM => "+",
            ff_Latn_GH => "+",
            ff_Latn_GM => "+",
            ff_Latn_GN => "+",
            ff_Latn_GW => "+",
            ff_Latn_LR => "+",
            ff_Latn_MR => "+",
            ff_Latn_NE => "+",
            ff_Latn_NG => "+",
            ff_Latn_SL => "+",
            fi => "+",
            fil => "+",
            fo => "+",
            fo_DK => "+",
            fr => "+",
            fr_BE => "+",
            fr_BF => "+",
            fr_BI => "+",
            fr_BJ => "+",
            fr_BL => "+",
            fr_CA => "+",
            fr_CD => "+",
            fr_CF => "+",
            fr_CG => "+",
            fr_CH => "+",
            fr_CI => "+",
            fr_CM => "+",
            fr_DJ => "+",
            fr_DZ => "+",
            fr_GA => "+",
            fr_GF => "+",
            fr_GN => "+",
            fr_GP => "+",
            fr_GQ => "+",
            fr_HT => "+",
            fr_KM => "+",
            fr_LU => "+",
            fr_MA => "+",
            fr_MC => "+",
            fr_MF => "+",
            fr_MG => "+",
            fr_ML => "+",
            fr_MQ => "+",
            fr_MR => "+",
            fr_MU => "+",
            fr_NC => "+",
            fr_NE => "+",
            fr_PF => "+",
            fr_PM => "+",
            fr_RE => "+",
            fr_RW => "+",
            fr_SC => "+",
            fr_SN => "+",
            fr_SY => "+",
            fr_TD => "+",
            fr_TG => "+",
            fr_TN => "+",
            fr_VU => "+",
            fr_WF => "+",
            fr_YT => "+",
            fur => "+",
            fy => "+",
            ga => "+",
            gd => "+",
            gl => "+",
            gsw => "+",
            gsw_FR => "+",
            gsw_LI => "+",
            gu => "+",
            guz => "+",
            gv => "+",
            ha => "+",
            ha_GH => "+",
            ha_NE => "+",
            haw => "+",
            he => "\u{200e}+",
            hi => "+",
            hr => "+",
            hr_BA => "+",
            hsb => "+",
            hu => "+",
            hy => "+",
            ia => "+",
            id => "+",
            ig => "+",
            ii => "+",
            is => "+",
            it => "+",
            it_CH => "+",
            it_SM => "+",
            it_VA => "+",
            ja => "+",
            jgo => "+",
            jmc => "+",
            jv => "+",
            ka => "+",
            kab => "+",
            kam => "+",
            kde => "+",
            kea => "+",
            khq => "+",
            ki => "+",
            kk => "+",
            kkj => "+",
            kl => "+",
            kln => "+",
            km => "+",
            kn => "+",
            ko => "+",
            ko_KP => "+",
            kok => "+",
            ks => "\u{200e}+\u{200e}",
            ksb => "+",
            ksf => "+",
            ksh => "+",
            ku => "+",
            kw => "+",
            ky => "+",
            lag => "+",
            lb => "+",
            lg => "+",
            lkt => "+",
            ln => "+",
            ln_AO => "+",
            ln_CF => "+",
            ln_CG => "+",
            lo => "+",
            lrc => "\u{200e}+\u{200e}",
            lrc_IQ => "\u{200e}+\u{200e}",
            lt => "+",
            lu => "+",
            luo => "+",
            luy => "+",
            lv => "+",
            mas => "+",
            mas_TZ => "+",
            mer => "+",
            mfe => "+",
            mg => "+",
            mgh => "+",
            mgo => "+",
            mi => "+",
            mk => "+",
            ml => "+",
            mn => "+",
            mr => "+",
            ms => "+",
            ms_BN => "+",
            ms_SG => "+",
            mt => "+",
            mua => "+",
            my => "+",
            mzn => "\u{200e}+\u{200e}",
            naq => "+",
            nb => "+",
            nb_SJ => "+",
            nd => "+",
            nds => "+",
            nds_NL => "+",
            ne => "+",
            ne_IN => "+",
            nl => "+",
            nl_AW => "+",
            nl_BE => "+",
            nl_BQ => "+",
            nl_CW => "+",
            nl_SR => "+",
            nl_SX => "+",
            nmg => "+",
            nn => "+",
            nnh => "+",
            nus => "+",
            nyn => "+",
            om => "+",
            om_KE => "+",
            or => "+",
            os => "+",
            os_RU => "+",
            pa => "+",
            pa_Arab => "\u{200e}+\u{200e}",
            pa_Guru => "+",
            pl => "+",
            prg => "+",
            ps => "\u{200e}+\u{200e}",
            pt => "+",
            pt_AO => "+",
            pt_CH => "+",
            pt_CV => "+",
            pt_GQ => "+",
            pt_GW => "+",
            pt_LU => "+",
            pt_MO => "+",
            pt_MZ => "+",
            pt_PT => "+",
            pt_ST => "+",
            pt_TL => "+",
            qu => "+",
            qu_BO => "+",
            qu_EC => "+",
            rm => "+",
            rn => "+",
            ro => "+",
            ro_MD => "+",
            rof => "+",
            root => "+",
            ru => "+",
            ru_BY => "+",
            ru_KG => "+",
            ru_KZ => "+",
            ru_MD => "+",
            ru_UA => "+",
            rw => "+",
            rwk => "+",
            sah => "+",
            saq => "+",
            sbp => "+",
            sd => "\u{61c}+",
            se => "+",
            se_FI => "+",
            se_SE => "+",
            seh => "+",
            ses => "+",
            sg => "+",
            shi => "+",
            shi_Latn => "+",
            shi_Tfng => "+",
            si => "+",
            sk => "+",
            sl => "+",
            smn => "+",
            sn => "+",
            so => "+",
            so_DJ => "+",
            so_ET => "+",
            so_KE => "+",
            sq => "+",
            sq_MK => "+",
            sq_XK => "+",
            sr => "+",
            sr_Cyrl => "+",
            sr_Cyrl_BA => "+",
            sr_Cyrl_ME => "+",
            sr_Cyrl_XK => "+",
            sr_Latn => "+",
            sr_Latn_BA => "+",
            sr_Latn_ME => "+",
            sr_Latn_XK => "+",
            sv => "+",
            sv_AX => "+",
            sv_FI => "+",
            sw => "+",
            sw_CD => "+",
            sw_KE => "+",
            sw_UG => "+",
            ta => "+",
            ta_LK => "+",
            ta_MY => "+",
            ta_SG => "+",
            te => "+",
            teo => "+",
            teo_KE => "+",
            tg => "+",
            th => "+",
            ti => "+",
            ti_ER => "+",
            tk => "+",
            to => "+",
            tr => "+",
            tr_CY => "+",
            tt => "+",
            twq => "+",
            tzm => "+",
            ug => "+",
            uk => "+",
            ur => "\u{200e}+",
            ur_IN => "\u{200e}+\u{200e}",
            uz => "+",
            uz_Arab => "\u{200e}+\u{200e}",
            uz_Cyrl => "+",
            uz_Latn => "+",
            vai => "+",
            vai_Latn => "+",
            vai_Vaii => "+",
            vi => "+",
            vo => "+",
            vun => "+",
            wae => "+",
            wo => "+",
            xh => "+",
            xog => "+",
            yav => "+",
            yi => "+",
            yo => "+",
            yo_BJ => "+",
            yue => "+",
            yue_Hans => "+",
            yue_Hant => "+",
            zgh => "+",
            zh => "+",
            zh_Hans => "+",
            zh_Hans_HK => "+",
            zh_Hans_MO => "+",
            zh_Hans_SG => "+",
            zh_Hant => "+",
            zh_Hant_HK => "+",
            zh_Hant_MO => "+",
            zu => "+",
        }
    }
    #[doc = r" Returns the locale's separator representation, if any."]
    pub fn separator(&self) -> &'static str {
        use self::Locale::*;
        match self {
            af => "\u{a0}",
            af_NA => "\u{a0}",
            agq => "\u{a0}",
            ak => ",",
            am => ",",
            ar => "\u{66c}",
            ar_AE => "\u{66c}",
            ar_BH => "\u{66c}",
            ar_DJ => "\u{66c}",
            ar_DZ => ".",
            ar_EG => "\u{66c}",
            ar_EH => ",",
            ar_ER => "\u{66c}",
            ar_IL => "\u{66c}",
            ar_IQ => "\u{66c}",
            ar_JO => "\u{66c}",
            ar_KM => "\u{66c}",
            ar_KW => "\u{66c}",
            ar_LB => "\u{66c}",
            ar_LY => ".",
            ar_MA => ".",
            ar_MR => "\u{66c}",
            ar_OM => "\u{66c}",
            ar_PS => "\u{66c}",
            ar_QA => "\u{66c}",
            ar_SA => "\u{66c}",
            ar_SD => "\u{66c}",
            ar_SO => "\u{66c}",
            ar_SS => "\u{66c}",
            ar_SY => "\u{66c}",
            ar_TD => "\u{66c}",
            ar_TN => ".",
            ar_YE => "\u{66c}",
            as_ => ",",
            asa => ",",
            ast => ".",
            az => ".",
            az_Cyrl => ".",
            az_Latn => ".",
            bas => "\u{a0}",
            be => "\u{a0}",
            bem => ",",
            bez => ",",
            bg => "\u{a0}",
            bm => ",",
            bn => ",",
            bn_IN => ",",
            bo => ",",
            bo_IN => ",",
            br => "\u{a0}",
            brx => ",",
            bs => ".",
            bs_Cyrl => ".",
            bs_Latn => ".",
            ca => ".",
            ca_AD => ".",
            ca_ES_VALENCIA => ".",
            ca_FR => ".",
            ca_IT => ".",
            ccp => ",",
            ccp_IN => ",",
            ce => ",",
            cgg => ",",
            chr => ",",
            ckb => "\u{66c}",
            ckb_IR => "\u{66c}",
            cs => "\u{a0}",
            cu => ",",
            cy => ",",
            da => ".",
            da_GL => ".",
            dav => ",",
            de => ".",
            de_AT => "\u{a0}",
            de_BE => ".",
            de_CH => "\u{2019}",
            de_IT => ".",
            de_LI => "\u{2019}",
            de_LU => ".",
            dje => "\u{a0}",
            dsb => ".",
            dua => "\u{a0}",
            dyo => "\u{a0}",
            dz => ",",
            ebu => ",",
            ee => ",",
            ee_TG => ",",
            el => ".",
            el_CY => ".",
            en => ",",
            en_001 => ",",
            en_150 => ".",
            en_AG => ",",
            en_AI => ",",
            en_AS => ",",
            en_AT => ".",
            en_AU => ",",
            en_BB => ",",
            en_BE => ".",
            en_BI => ",",
            en_BM => ",",
            en_BS => ",",
            en_BW => ",",
            en_BZ => ",",
            en_CA => ",",
            en_CC => ",",
            en_CH => ".",
            en_CK => ",",
            en_CM => ",",
            en_CX => ",",
            en_CY => ",",
            en_DE => ".",
            en_DG => ",",
            en_DK => ".",
            en_DM => ",",
            en_ER => ",",
            en_FI => "\u{a0}",
            en_FJ => ",",
            en_FK => ",",
            en_FM => ",",
            en_GB => ",",
            en_GD => ",",
            en_GG => ",",
            en_GH => ",",
            en_GI => ",",
            en_GM => ",",
            en_GU => ",",
            en_GY => ",",
            en_HK => ",",
            en_IE => ",",
            en_IL => ",",
            en_IM => ",",
            en_IN => ",",
            en_IO => ",",
            en_JE => ",",
            en_JM => ",",
            en_KE => ",",
            en_KI => ",",
            en_KN => ",",
            en_KY => ",",
            en_LC => ",",
            en_LR => ",",
            en_LS => ",",
            en_MG => ",",
            en_MH => ",",
            en_MO => ",",
            en_MP => ",",
            en_MS => ",",
            en_MT => ",",
            en_MU => ",",
            en_MW => ",",
            en_MY => ",",
            en_NA => ",",
            en_NF => ",",
            en_NG => ",",
            en_NL => ".",
            en_NR => ",",
            en_NU => ",",
            en_NZ => ",",
            en_PG => ",",
            en_PH => ",",
            en_PK => ",",
            en_PN => ",",
            en_PR => ",",
            en_PW => ",",
            en_RW => ",",
            en_SB => ",",
            en_SC => ",",
            en_SD => ",",
            en_SE => "\u{a0}",
            en_SG => ",",
            en_SH => ",",
            en_SI => ".",
            en_SL => ",",
            en_SS => ",",
            en_SX => ",",
            en_SZ => ",",
            en_TC => ",",
            en_TK => ",",
            en_TO => ",",
            en_TT => ",",
            en_TV => ",",
            en_TZ => ",",
            en_UG => ",",
            en_UM => ",",
            en_US_POSIX => ",",
            en_VC => ",",
            en_VG => ",",
            en_VI => ",",
            en_VU => ",",
            en_WS => ",",
            en_ZA => "\u{a0}",
            en_ZM => ",",
            en_ZW => ",",
            eo => "\u{a0}",
            es => ".",
            es_419 => ",",
            es_AR => ".",
            es_BO => ".",
            es_BR => ",",
            es_BZ => ",",
            es_CL => ".",
            es_CO => ".",
            es_CR => "\u{a0}",
            es_CU => ",",
            es_DO => ",",
            es_EA => ".",
            es_EC => ".",
            es_GQ => ".",
            es_GT => ",",
            es_HN => ",",
            es_IC => ".",
            es_MX => ",",
            es_NI => ",",
            es_PA => ",",
            es_PE => ",",
            es_PH => ".",
            es_PR => ",",
            es_PY => ".",
            es_SV => ",",
            es_US => ",",
            es_UY => ".",
            es_VE => ".",
            et => "\u{a0}",
            eu => ".",
            ewo => "\u{a0}",
            fa => "\u{66c}",
            fa_AF => "\u{66c}",
            ff => "\u{a0}",
            ff_Latn => "\u{a0}",
            ff_Latn_BF => "\u{a0}",
            ff_Latn_CM => "\u{a0}",
            ff_Latn_GH => "\u{a0}",
            ff_Latn_GM => "\u{a0}",
            ff_Latn_GN => "\u{a0}",
            ff_Latn_GW => "\u{a0}",
            ff_Latn_LR => "\u{a0}",
            ff_Latn_MR => "\u{a0}",
            ff_Latn_NE => "\u{a0}",
            ff_Latn_NG => "\u{a0}",
            ff_Latn_SL => "\u{a0}",
            fi => "\u{a0}",
            fil => ",",
            fo => ".",
            fo_DK => ".",
            fr => "\u{202f}",
            fr_BE => "\u{202f}",
            fr_BF => "\u{202f}",
            fr_BI => "\u{202f}",
            fr_BJ => "\u{202f}",
            fr_BL => "\u{202f}",
            fr_CA => "\u{a0}",
            fr_CD => "\u{202f}",
            fr_CF => "\u{202f}",
            fr_CG => "\u{202f}",
            fr_CH => "\u{202f}",
            fr_CI => "\u{202f}",
            fr_CM => "\u{202f}",
            fr_DJ => "\u{202f}",
            fr_DZ => "\u{202f}",
            fr_GA => "\u{202f}",
            fr_GF => "\u{202f}",
            fr_GN => "\u{202f}",
            fr_GP => "\u{202f}",
            fr_GQ => "\u{202f}",
            fr_HT => "\u{202f}",
            fr_KM => "\u{202f}",
            fr_LU => ".",
            fr_MA => ".",
            fr_MC => "\u{202f}",
            fr_MF => "\u{202f}",
            fr_MG => "\u{202f}",
            fr_ML => "\u{202f}",
            fr_MQ => "\u{202f}",
            fr_MR => "\u{202f}",
            fr_MU => "\u{202f}",
            fr_NC => "\u{202f}",
            fr_NE => "\u{202f}",
            fr_PF => "\u{202f}",
            fr_PM => "\u{202f}",
            fr_RE => "\u{202f}",
            fr_RW => "\u{202f}",
            fr_SC => "\u{202f}",
            fr_SN => "\u{202f}",
            fr_SY => "\u{202f}",
            fr_TD => "\u{202f}",
            fr_TG => "\u{202f}",
            fr_TN => "\u{202f}",
            fr_VU => "\u{202f}",
            fr_WF => "\u{202f}",
            fr_YT => "\u{202f}",
            fur => ".",
            fy => ".",
            ga => ",",
            gd => ",",
            gl => ".",
            gsw => "\u{2019}",
            gsw_FR => "\u{2019}",
            gsw_LI => "\u{2019}",
            gu => ",",
            guz => ",",
            gv => ",",
            ha => ",",
            ha_GH => ",",
            ha_NE => ",",
            haw => ",",
            he => ",",
            hi => ",",
            hr => ".",
            hr_BA => ".",
            hsb => ".",
            hu => "\u{a0}",
            hy => "\u{a0}",
            ia => ".",
            id => ".",
            ig => ",",
            ii => ",",
            is => ".",
            it => ".",
            it_CH => "\u{2019}",
            it_SM => ".",
            it_VA => ".",
            ja => ",",
            jgo => ".",
            jmc => ",",
            jv => ".",
            ka => "\u{a0}",
            kab => "\u{a0}",
            kam => ",",
            kde => ",",
            kea => "\u{a0}",
            khq => "\u{a0}",
            ki => ",",
            kk => "\u{a0}",
            kkj => ".",
            kl => ".",
            kln => ",",
            km => ".",
            kn => ",",
            ko => ",",
            ko_KP => ",",
            kok => ",",
            ks => "\u{66c}",
            ksb => ",",
            ksf => "\u{a0}",
            ksh => "\u{a0}",
            ku => ".",
            kw => ",",
            ky => "\u{a0}",
            lag => ",",
            lb => ".",
            lg => ",",
            lkt => ",",
            ln => ".",
            ln_AO => ".",
            ln_CF => ".",
            ln_CG => ".",
            lo => ".",
            lrc => "\u{66c}",
            lrc_IQ => "\u{66c}",
            lt => "\u{a0}",
            lu => ".",
            luo => ",",
            luy => ",",
            lv => "\u{a0}",
            mas => ",",
            mas_TZ => ",",
            mer => ",",
            mfe => "\u{a0}",
            mg => ",",
            mgh => ".",
            mgo => ",",
            mi => ",",
            mk => ".",
            ml => ",",
            mn => ",",
            mr => ",",
            ms => ",",
            ms_BN => ".",
            ms_SG => ",",
            mt => ",",
            mua => ".",
            my => ",",
            mzn => "\u{66c}",
            naq => ",",
            nb => "\u{a0}",
            nb_SJ => "\u{a0}",
            nd => ",",
            nds => ",",
            nds_NL => ",",
            ne => ",",
            ne_IN => ",",
            nl => ".",
            nl_AW => ".",
            nl_BE => ".",
            nl_BQ => ".",
            nl_CW => ".",
            nl_SR => ".",
            nl_SX => ".",
            nmg => "\u{a0}",
            nn => "\u{a0}",
            nnh => ".",
            nus => ",",
            nyn => ",",
            om => ",",
            om_KE => ",",
            or => ",",
            os => "\u{a0}",
            os_RU => "\u{a0}",
            pa => ",",
            pa_Arab => "\u{66c}",
            pa_Guru => ",",
            pl => "\u{a0}",
            prg => ",",
            ps => "\u{66c}",
            pt => ".",
            pt_AO => "\u{a0}",
            pt_CH => "\u{a0}",
            pt_CV => "\u{a0}",
            pt_GQ => "\u{a0}",
            pt_GW => "\u{a0}",
            pt_LU => "\u{a0}",
            pt_MO => "\u{a0}",
            pt_MZ => "\u{a0}",
            pt_PT => "\u{a0}",
            pt_ST => "\u{a0}",
            pt_TL => "\u{a0}",
            qu => ",",
            qu_BO => ".",
            qu_EC => ",",
            rm => "\u{2019}",
            rn => ".",
            ro => ".",
            ro_MD => ".",
            rof => ",",
            root => ",",
            ru => "\u{a0}",
            ru_BY => "\u{a0}",
            ru_KG => "\u{a0}",
            ru_KZ => "\u{a0}",
            ru_MD => "\u{a0}",
            ru_UA => "\u{a0}",
            rw => ".",
            rwk => ",",
            sah => "\u{a0}",
            saq => ",",
            sbp => ",",
            sd => "\u{66c}",
            se => "\u{a0}",
            se_FI => "\u{a0}",
            se_SE => "\u{a0}",
            seh => ".",
            ses => "\u{a0}",
            sg => ".",
            shi => "\u{a0}",
            shi_Latn => "\u{a0}",
            shi_Tfng => "\u{a0}",
            si => ",",
            sk => "\u{a0}",
            sl => ".",
            smn => "\u{a0}",
            sn => ",",
            so => ",",
            so_DJ => ",",
            so_ET => ",",
            so_KE => ",",
            sq => "\u{a0}",
            sq_MK => "\u{a0}",
            sq_XK => "\u{a0}",
            sr => ".",
            sr_Cyrl => ".",
            sr_Cyrl_BA => ".",
            sr_Cyrl_ME => ".",
            sr_Cyrl_XK => ".",
            sr_Latn => ".",
            sr_Latn_BA => ".",
            sr_Latn_ME => ".",
            sr_Latn_XK => ".",
            sv => "\u{a0}",
            sv_AX => "\u{a0}",
            sv_FI => "\u{a0}",
            sw => ",",
            sw_CD => ".",
            sw_KE => ",",
            sw_UG => ",",
            ta => ",",
            ta_LK => ",",
            ta_MY => ",",
            ta_SG => ",",
            te => ",",
            teo => ",",
            teo_KE => ",",
            tg => "\u{a0}",
            th => ",",
            ti => ",",
            ti_ER => ",",
            tk => "\u{a0}",
            to => ",",
            tr => ".",
            tr_CY => ".",
            tt => "\u{a0}",
            twq => "\u{a0}",
            tzm => "\u{a0}",
            ug => ",",
            uk => "\u{a0}",
            ur => ",",
            ur_IN => "\u{66c}",
            uz => "\u{a0}",
            uz_Arab => "\u{66c}",
            uz_Cyrl => "\u{a0}",
            uz_Latn => "\u{a0}",
            vai => ",",
            vai_Latn => ",",
            vai_Vaii => ",",
            vi => ".",
            vo => ",",
            vun => ",",
            wae => "\u{2019}",
            wo => ".",
            xh => "\u{a0}",
            xog => ",",
            yav => "\u{a0}",
            yi => ",",
            yo => ",",
            yo_BJ => ",",
            yue => ",",
            yue_Hans => ",",
            yue_Hant => ",",
            zgh => "\u{a0}",
            zh => ",",
            zh_Hans => ",",
            zh_Hans_HK => ",",
            zh_Hans_MO => ",",
            zh_Hans_SG => ",",
            zh_Hant => ",",
            zh_Hant_HK => ",",
            zh_Hant_MO => ",",
            zu => ",",
        }
    }
}
impl Format for Locale {
    #[inline(always)]
    fn decimal(&self) -> DecimalStr<'_> {
        DecimalStr::new(self.decimal()).unwrap()
    }
    #[inline(always)]
    fn grouping(&self) -> Grouping {
        self.grouping()
    }
    #[inline(always)]
    fn infinity(&self) -> InfinityStr<'_> {
        InfinityStr::new(self.infinity()).unwrap()
    }
    #[inline(always)]
    fn minus_sign(&self) -> MinusSignStr<'_> {
        MinusSignStr::new(self.minus_sign()).unwrap()
    }
    #[inline(always)]
    fn nan(&self) -> NanStr<'_> {
        NanStr::new(self.nan()).unwrap()
    }
    #[inline(always)]
    fn plus_sign(&self) -> PlusSignStr<'_> {
        PlusSignStr::new(self.plus_sign()).unwrap()
    }
    #[inline(always)]
    fn separator(&self) -> SeparatorStr<'_> {
        SeparatorStr::new(self.separator()).unwrap()
    }
}
impl FromStr for Locale {
    type Err = Error;
    #[doc = r" Same as [`from_name`]."]
    #[doc = r""]
    #[doc = r" [`from_name`]: enum.Locale.html#method.from_name"]
    fn from_str(s: &str) -> Result<Self, Self::Err> {
        use self::Locale::*;
        let locale = match s {
            "af" => af,
            "af-NA" => af_NA,
            "agq" => agq,
            "ak" => ak,
            "am" => am,
            "ar" => ar,
            "ar-AE" => ar_AE,
            "ar-BH" => ar_BH,
            "ar-DJ" => ar_DJ,
            "ar-DZ" => ar_DZ,
            "ar-EG" => ar_EG,
            "ar-EH" => ar_EH,
            "ar-ER" => ar_ER,
            "ar-IL" => ar_IL,
            "ar-IQ" => ar_IQ,
            "ar-JO" => ar_JO,
            "ar-KM" => ar_KM,
            "ar-KW" => ar_KW,
            "ar-LB" => ar_LB,
            "ar-LY" => ar_LY,
            "ar-MA" => ar_MA,
            "ar-MR" => ar_MR,
            "ar-OM" => ar_OM,
            "ar-PS" => ar_PS,
            "ar-QA" => ar_QA,
            "ar-SA" => ar_SA,
            "ar-SD" => ar_SD,
            "ar-SO" => ar_SO,
            "ar-SS" => ar_SS,
            "ar-SY" => ar_SY,
            "ar-TD" => ar_TD,
            "ar-TN" => ar_TN,
            "ar-YE" => ar_YE,
            "as" => as_,
            "asa" => asa,
            "ast" => ast,
            "az" => az,
            "az-Cyrl" => az_Cyrl,
            "az-Latn" => az_Latn,
            "bas" => bas,
            "be" => be,
            "bem" => bem,
            "bez" => bez,
            "bg" => bg,
            "bm" => bm,
            "bn" => bn,
            "bn-IN" => bn_IN,
            "bo" => bo,
            "bo-IN" => bo_IN,
            "br" => br,
            "brx" => brx,
            "bs" => bs,
            "bs-Cyrl" => bs_Cyrl,
            "bs-Latn" => bs_Latn,
            "ca" => ca,
            "ca-AD" => ca_AD,
            "ca-ES-VALENCIA" => ca_ES_VALENCIA,
            "ca-FR" => ca_FR,
            "ca-IT" => ca_IT,
            "ccp" => ccp,
            "ccp-IN" => ccp_IN,
            "ce" => ce,
            "cgg" => cgg,
            "chr" => chr,
            "ckb" => ckb,
            "ckb-IR" => ckb_IR,
            "cs" => cs,
            "cu" => cu,
            "cy" => cy,
            "da" => da,
            "da-GL" => da_GL,
            "dav" => dav,
            "de" => de,
            "de-AT" => de_AT,
            "de-BE" => de_BE,
            "de-CH" => de_CH,
            "de-IT" => de_IT,
            "de-LI" => de_LI,
            "de-LU" => de_LU,
            "dje" => dje,
            "dsb" => dsb,
            "dua" => dua,
            "dyo" => dyo,
            "dz" => dz,
            "ebu" => ebu,
            "ee" => ee,
            "ee-TG" => ee_TG,
            "el" => el,
            "el-CY" => el_CY,
            "en" => en,
            "en-001" => en_001,
            "en-150" => en_150,
            "en-AG" => en_AG,
            "en-AI" => en_AI,
            "en-AS" => en_AS,
            "en-AT" => en_AT,
            "en-AU" => en_AU,
            "en-BB" => en_BB,
            "en-BE" => en_BE,
            "en-BI" => en_BI,
            "en-BM" => en_BM,
            "en-BS" => en_BS,
            "en-BW" => en_BW,
            "en-BZ" => en_BZ,
            "en-CA" => en_CA,
            "en-CC" => en_CC,
            "en-CH" => en_CH,
            "en-CK" => en_CK,
            "en-CM" => en_CM,
            "en-CX" => en_CX,
            "en-CY" => en_CY,
            "en-DE" => en_DE,
            "en-DG" => en_DG,
            "en-DK" => en_DK,
            "en-DM" => en_DM,
            "en-ER" => en_ER,
            "en-FI" => en_FI,
            "en-FJ" => en_FJ,
            "en-FK" => en_FK,
            "en-FM" => en_FM,
            "en-GB" => en_GB,
            "en-GD" => en_GD,
            "en-GG" => en_GG,
            "en-GH" => en_GH,
            "en-GI" => en_GI,
            "en-GM" => en_GM,
            "en-GU" => en_GU,
            "en-GY" => en_GY,
            "en-HK" => en_HK,
            "en-IE" => en_IE,
            "en-IL" => en_IL,
            "en-IM" => en_IM,
            "en-IN" => en_IN,
            "en-IO" => en_IO,
            "en-JE" => en_JE,
            "en-JM" => en_JM,
            "en-KE" => en_KE,
            "en-KI" => en_KI,
            "en-KN" => en_KN,
            "en-KY" => en_KY,
            "en-LC" => en_LC,
            "en-LR" => en_LR,
            "en-LS" => en_LS,
            "en-MG" => en_MG,
            "en-MH" => en_MH,
            "en-MO" => en_MO,
            "en-MP" => en_MP,
            "en-MS" => en_MS,
            "en-MT" => en_MT,
            "en-MU" => en_MU,
            "en-MW" => en_MW,
            "en-MY" => en_MY,
            "en-NA" => en_NA,
            "en-NF" => en_NF,
            "en-NG" => en_NG,
            "en-NL" => en_NL,
            "en-NR" => en_NR,
            "en-NU" => en_NU,
            "en-NZ" => en_NZ,
            "en-PG" => en_PG,
            "en-PH" => en_PH,
            "en-PK" => en_PK,
            "en-PN" => en_PN,
            "en-PR" => en_PR,
            "en-PW" => en_PW,
            "en-RW" => en_RW,
            "en-SB" => en_SB,
            "en-SC" => en_SC,
            "en-SD" => en_SD,
            "en-SE" => en_SE,
            "en-SG" => en_SG,
            "en-SH" => en_SH,
            "en-SI" => en_SI,
            "en-SL" => en_SL,
            "en-SS" => en_SS,
            "en-SX" => en_SX,
            "en-SZ" => en_SZ,
            "en-TC" => en_TC,
            "en-TK" => en_TK,
            "en-TO" => en_TO,
            "en-TT" => en_TT,
            "en-TV" => en_TV,
            "en-TZ" => en_TZ,
            "en-UG" => en_UG,
            "en-UM" => en_UM,
            "en-US-POSIX" => en_US_POSIX,
            "en-VC" => en_VC,
            "en-VG" => en_VG,
            "en-VI" => en_VI,
            "en-VU" => en_VU,
            "en-WS" => en_WS,
            "en-ZA" => en_ZA,
            "en-ZM" => en_ZM,
            "en-ZW" => en_ZW,
            "eo" => eo,
            "es" => es,
            "es-419" => es_419,
            "es-AR" => es_AR,
            "es-BO" => es_BO,
            "es-BR" => es_BR,
            "es-BZ" => es_BZ,
            "es-CL" => es_CL,
            "es-CO" => es_CO,
            "es-CR" => es_CR,
            "es-CU" => es_CU,
            "es-DO" => es_DO,
            "es-EA" => es_EA,
            "es-EC" => es_EC,
            "es-GQ" => es_GQ,
            "es-GT" => es_GT,
            "es-HN" => es_HN,
            "es-IC" => es_IC,
            "es-MX" => es_MX,
            "es-NI" => es_NI,
            "es-PA" => es_PA,
            "es-PE" => es_PE,
            "es-PH" => es_PH,
            "es-PR" => es_PR,
            "es-PY" => es_PY,
            "es-SV" => es_SV,
            "es-US" => es_US,
            "es-UY" => es_UY,
            "es-VE" => es_VE,
            "et" => et,
            "eu" => eu,
            "ewo" => ewo,
            "fa" => fa,
            "fa-AF" => fa_AF,
            "ff" => ff,
            "ff-Latn" => ff_Latn,
            "ff-Latn-BF" => ff_Latn_BF,
            "ff-Latn-CM" => ff_Latn_CM,
            "ff-Latn-GH" => ff_Latn_GH,
            "ff-Latn-GM" => ff_Latn_GM,
            "ff-Latn-GN" => ff_Latn_GN,
            "ff-Latn-GW" => ff_Latn_GW,
            "ff-Latn-LR" => ff_Latn_LR,
            "ff-Latn-MR" => ff_Latn_MR,
            "ff-Latn-NE" => ff_Latn_NE,
            "ff-Latn-NG" => ff_Latn_NG,
            "ff-Latn-SL" => ff_Latn_SL,
            "fi" => fi,
            "fil" => fil,
            "fo" => fo,
            "fo-DK" => fo_DK,
            "fr" => fr,
            "fr-BE" => fr_BE,
            "fr-BF" => fr_BF,
            "fr-BI" => fr_BI,
            "fr-BJ" => fr_BJ,
            "fr-BL" => fr_BL,
            "fr-CA" => fr_CA,
            "fr-CD" => fr_CD,
            "fr-CF" => fr_CF,
            "fr-CG" => fr_CG,
            "fr-CH" => fr_CH,
            "fr-CI" => fr_CI,
            "fr-CM" => fr_CM,
            "fr-DJ" => fr_DJ,
            "fr-DZ" => fr_DZ,
            "fr-GA" => fr_GA,
            "fr-GF" => fr_GF,
            "fr-GN" => fr_GN,
            "fr-GP" => fr_GP,
            "fr-GQ" => fr_GQ,
            "fr-HT" => fr_HT,
            "fr-KM" => fr_KM,
            "fr-LU" => fr_LU,
            "fr-MA" => fr_MA,
            "fr-MC" => fr_MC,
            "fr-MF" => fr_MF,
            "fr-MG" => fr_MG,
            "fr-ML" => fr_ML,
            "fr-MQ" => fr_MQ,
            "fr-MR" => fr_MR,
            "fr-MU" => fr_MU,
            "fr-NC" => fr_NC,
            "fr-NE" => fr_NE,
            "fr-PF" => fr_PF,
            "fr-PM" => fr_PM,
            "fr-RE" => fr_RE,
            "fr-RW" => fr_RW,
            "fr-SC" => fr_SC,
            "fr-SN" => fr_SN,
            "fr-SY" => fr_SY,
            "fr-TD" => fr_TD,
            "fr-TG" => fr_TG,
            "fr-TN" => fr_TN,
            "fr-VU" => fr_VU,
            "fr-WF" => fr_WF,
            "fr-YT" => fr_YT,
            "fur" => fur,
            "fy" => fy,
            "ga" => ga,
            "gd" => gd,
            "gl" => gl,
            "gsw" => gsw,
            "gsw-FR" => gsw_FR,
            "gsw-LI" => gsw_LI,
            "gu" => gu,
            "guz" => guz,
            "gv" => gv,
            "ha" => ha,
            "ha-GH" => ha_GH,
            "ha-NE" => ha_NE,
            "haw" => haw,
            "he" => he,
            "hi" => hi,
            "hr" => hr,
            "hr-BA" => hr_BA,
            "hsb" => hsb,
            "hu" => hu,
            "hy" => hy,
            "ia" => ia,
            "id" => id,
            "ig" => ig,
            "ii" => ii,
            "is" => is,
            "it" => it,
            "it-CH" => it_CH,
            "it-SM" => it_SM,
            "it-VA" => it_VA,
            "ja" => ja,
            "jgo" => jgo,
            "jmc" => jmc,
            "jv" => jv,
            "ka" => ka,
            "kab" => kab,
            "kam" => kam,
            "kde" => kde,
            "kea" => kea,
            "khq" => khq,
            "ki" => ki,
            "kk" => kk,
            "kkj" => kkj,
            "kl" => kl,
            "kln" => kln,
            "km" => km,
            "kn" => kn,
            "ko" => ko,
            "ko-KP" => ko_KP,
            "kok" => kok,
            "ks" => ks,
            "ksb" => ksb,
            "ksf" => ksf,
            "ksh" => ksh,
            "ku" => ku,
            "kw" => kw,
            "ky" => ky,
            "lag" => lag,
            "lb" => lb,
            "lg" => lg,
            "lkt" => lkt,
            "ln" => ln,
            "ln-AO" => ln_AO,
            "ln-CF" => ln_CF,
            "ln-CG" => ln_CG,
            "lo" => lo,
            "lrc" => lrc,
            "lrc-IQ" => lrc_IQ,
            "lt" => lt,
            "lu" => lu,
            "luo" => luo,
            "luy" => luy,
            "lv" => lv,
            "mas" => mas,
            "mas-TZ" => mas_TZ,
            "mer" => mer,
            "mfe" => mfe,
            "mg" => mg,
            "mgh" => mgh,
            "mgo" => mgo,
            "mi" => mi,
            "mk" => mk,
            "ml" => ml,
            "mn" => mn,
            "mr" => mr,
            "ms" => ms,
            "ms-BN" => ms_BN,
            "ms-SG" => ms_SG,
            "mt" => mt,
            "mua" => mua,
            "my" => my,
            "mzn" => mzn,
            "naq" => naq,
            "nb" => nb,
            "nb-SJ" => nb_SJ,
            "nd" => nd,
            "nds" => nds,
            "nds-NL" => nds_NL,
            "ne" => ne,
            "ne-IN" => ne_IN,
            "nl" => nl,
            "nl-AW" => nl_AW,
            "nl-BE" => nl_BE,
            "nl-BQ" => nl_BQ,
            "nl-CW" => nl_CW,
            "nl-SR" => nl_SR,
            "nl-SX" => nl_SX,
            "nmg" => nmg,
            "nn" => nn,
            "nnh" => nnh,
            "nus" => nus,
            "nyn" => nyn,
            "om" => om,
            "om-KE" => om_KE,
            "or" => or,
            "os" => os,
            "os-RU" => os_RU,
            "pa" => pa,
            "pa-Arab" => pa_Arab,
            "pa-Guru" => pa_Guru,
            "pl" => pl,
            "prg" => prg,
            "ps" => ps,
            "pt" => pt,
            "pt-AO" => pt_AO,
            "pt-CH" => pt_CH,
            "pt-CV" => pt_CV,
            "pt-GQ" => pt_GQ,
            "pt-GW" => pt_GW,
            "pt-LU" => pt_LU,
            "pt-MO" => pt_MO,
            "pt-MZ" => pt_MZ,
            "pt-PT" => pt_PT,
            "pt-ST" => pt_ST,
            "pt-TL" => pt_TL,
            "qu" => qu,
            "qu-BO" => qu_BO,
            "qu-EC" => qu_EC,
            "rm" => rm,
            "rn" => rn,
            "ro" => ro,
            "ro-MD" => ro_MD,
            "rof" => rof,
            "root" => root,
            "ru" => ru,
            "ru-BY" => ru_BY,
            "ru-KG" => ru_KG,
            "ru-KZ" => ru_KZ,
            "ru-MD" => ru_MD,
            "ru-UA" => ru_UA,
            "rw" => rw,
            "rwk" => rwk,
            "sah" => sah,
            "saq" => saq,
            "sbp" => sbp,
            "sd" => sd,
            "se" => se,
            "se-FI" => se_FI,
            "se-SE" => se_SE,
            "seh" => seh,
            "ses" => ses,
            "sg" => sg,
            "shi" => shi,
            "shi-Latn" => shi_Latn,
            "shi-Tfng" => shi_Tfng,
            "si" => si,
            "sk" => sk,
            "sl" => sl,
            "smn" => smn,
            "sn" => sn,
            "so" => so,
            "so-DJ" => so_DJ,
            "so-ET" => so_ET,
            "so-KE" => so_KE,
            "sq" => sq,
            "sq-MK" => sq_MK,
            "sq-XK" => sq_XK,
            "sr" => sr,
            "sr-Cyrl" => sr_Cyrl,
            "sr-Cyrl-BA" => sr_Cyrl_BA,
            "sr-Cyrl-ME" => sr_Cyrl_ME,
            "sr-Cyrl-XK" => sr_Cyrl_XK,
            "sr-Latn" => sr_Latn,
            "sr-Latn-BA" => sr_Latn_BA,
            "sr-Latn-ME" => sr_Latn_ME,
            "sr-Latn-XK" => sr_Latn_XK,
            "sv" => sv,
            "sv-AX" => sv_AX,
            "sv-FI" => sv_FI,
            "sw" => sw,
            "sw-CD" => sw_CD,
            "sw-KE" => sw_KE,
            "sw-UG" => sw_UG,
            "ta" => ta,
            "ta-LK" => ta_LK,
            "ta-MY" => ta_MY,
            "ta-SG" => ta_SG,
            "te" => te,
            "teo" => teo,
            "teo-KE" => teo_KE,
            "tg" => tg,
            "th" => th,
            "ti" => ti,
            "ti-ER" => ti_ER,
            "tk" => tk,
            "to" => to,
            "tr" => tr,
            "tr-CY" => tr_CY,
            "tt" => tt,
            "twq" => twq,
            "tzm" => tzm,
            "ug" => ug,
            "uk" => uk,
            "ur" => ur,
            "ur-IN" => ur_IN,
            "uz" => uz,
            "uz-Arab" => uz_Arab,
            "uz-Cyrl" => uz_Cyrl,
            "uz-Latn" => uz_Latn,
            "vai" => vai,
            "vai-Latn" => vai_Latn,
            "vai-Vaii" => vai_Vaii,
            "vi" => vi,
            "vo" => vo,
            "vun" => vun,
            "wae" => wae,
            "wo" => wo,
            "xh" => xh,
            "xog" => xog,
            "yav" => yav,
            "yi" => yi,
            "yo" => yo,
            "yo-BJ" => yo_BJ,
            "yue" => yue,
            "yue-Hans" => yue_Hans,
            "yue-Hant" => yue_Hant,
            "zgh" => zgh,
            "zh" => zh,
            "zh-Hans" => zh_Hans,
            "zh-Hans-HK" => zh_Hans_HK,
            "zh-Hans-MO" => zh_Hans_MO,
            "zh-Hans-SG" => zh_Hans_SG,
            "zh-Hant" => zh_Hant,
            "zh-Hant-HK" => zh_Hant_HK,
            "zh-Hant-MO" => zh_Hant_MO,
            "zu" => zu,
            _ => return Err(Error::parse_locale(s)),
        };
        Ok(locale)
    }
}
