#!/bin/sh
[ "$1" = "-h" ] && cat <<tac

This example tests the following features of the sanitizer:

   - HTML defanging in headers
   - HTML defanging in text/ parts

tac

rm -f test.log test.out
touch test.log test.out

for WB in 0 1; do
  $ANOMY/bin/sanitizer.pl -nofprot $SAN_CONF \
    'file_list_1 = (?i)evil$' 'file_list_1_policy = mangle' \
    'header_rev = 0' \
    "feat_testing = 1" \
    'feat_log_inline = 2' \
    'file_list_2_policy = accept' \
    'file_list_2 = (?i)\.txt$' \
    "feat_webbugs = $WB" \
    'feat_log_stderr = 0' <<EOF 2>>test.log >>test.out
From xxx@example.com  Thu Aug  3 07:32:10 2000
Return-Path: <xxx@example.com>
Received: from example.com (root@example.com [149.144.245.5])
	by example.com (8.9.3/8.9.3) with ESMTP id HAA01305
	for <bre@example.com>; Thu, 3 Aug 2000 07:32:03 GMT
From: xxx@example.com
Date: Thu, 3 Aug 2000 06:39:59 GMT
Message-Id: <200008030639.GAA23780@example.com>
MIME-Version: 1.0
Sender: xxx@example.com
Subject: <applet blah blah>
To: fake@example.com
Content-Type: multipart/mixed; boundary="=ABACAB:=_0006@@UtD0uere5ZCIrVlOp0vV"

--=ABACAB:=_0006@@UtD0uere5ZCIrVlOp0vV
Content-Type: text/plain; charset="iso-8859-1"
Content-Disposition: attachment; filename="html-test.txt"
Content-Transfer-Encoding: 8bit

<html>
 <head>
  <meta refresh="...">
 </head>
 <body>
 	<style type=evil>blah blah blah blah
	blah blah blah blah blah blah blah blah blah blah blah blah blah blah blah blah
	blah blah blah blah blah blah blah blah blah blah blah blah blah blah blah blah
	blah blah blah blah blah blah blah blah blah blah blah blah blah blah blah blah
	blah blah blah blah blah blah blah blah blah blah blah blah blah blah blah blah
	on 
	multiple
	lines, blah
	blah
	blah
	blah.</style>
	<applet>ble</applet>
	<!-- <script language="javascript"> bla bla </script> -->
	<object>moo</object>
	<embed>moo</embed>
	<frame>baa baa</frame>
	<iframe>baaaa baa</iframe>	
	<layer>evil hotmail exploit layer!</layer>
	<ilayer>does the ilayer tag exist?</ilayer>
	<p style="evil">
	<form action="do something really evil" method="post">
	<img src="http://some.evil.bug.host/">
	<img dynsrc="http://some.evil.bug.host/">
	&{[code]};
	<img src=&{[code]};>
	<img src="mocha:[code]">
	<img src="blah"onmouseover="[code]">
	<img src="blah>" onmouseover="[code]">
 	<link rel=blablah>
	<div>
 	<a href="bleh" onAbort="goobygooby">test</a>	
 	<a href="bleh" onBlur="goobygooby">test</a>
 	<a href="bleh" onChange="goobygooby">test</a>
 	<a href="bleh" onClick="goobygooby">test</a>
 	<a href="bleh" onDblClick="goobygooby">test</a>
 	<a href="bleh" onDragDrop="goobygooby">test</a>
 	<a href="bleh" onError="goobygooby">test</a>
 	<a href="bleh" onFocus="goobygooby">test</a>
 	<a href="bleh" onKeyDown="goobygooby">test</a>
 	<a href="bleh" onKeyPress="goobygooby">test</a>
 	<a href="bleh" onKeyUp="goobygooby">test</a>
 	<a href="bleh" onMouseDown="goobygooby">test</a>
 	<a href="bleh" onMouseMove="goobygooby">test</a>
 	<a href="bleh" onMouseOut="goobygooby">test</a>
 	<a href="bleh" onMouseUp="goobygooby">test</a>
 	<a href="bleh" onMove="goobygooby">test</a>
 	<a href="bleh" onReset="goobygooby">test</a>
 	<a href="bleh" onResize="goobygooby">test</a>
 	<a href="bleh" onSelect="goobygooby">test</a>
 	<a href="bleh" onSubmit="goobygooby">test</a>
 	<a href="bleh" onUnload="&#122orro%20">test</a>
	<a href="javascript:DoSomething(blah)">blah blah</a>
	</div>
	</p>
 </body>
</html>

--=ABACAB:=_0006@@UtD0uere5ZCIrVlOp0vV--
EOF
done
