// SPDX-FileCopyrightText: 2006-2024 Knut Reinert & Freie Universität Berlin
// SPDX-FileCopyrightText: 2016-2024 Knut Reinert & MPI für molekulare Genetik
// SPDX-License-Identifier: BSD-3-Clause

/*!\file
 * \author Rene Rahn <rene.rahn AT fu-berlin.de>
 * \brief Meta-header for the \link utility_type_pack Utility / Type Pack submodule \endlink.
 */

/*!\defgroup utility_type_pack Type Pack
 * \brief Provides metaprogramming utilities for working on template parameter packs.
 * \ingroup utility
 * \see utility
 *
 * \details
 *
 * This module contains auxiliary functions, algorithms and traits on
 * [template parameter packs](https://en.cppreference.com/w/cpp/language/parameter_pack).
 * All traits on a template parameter pack are defined in the header `<seqan3/utility/type_pack/traits.hpp>`.
 */

/*!\namespace seqan3::pack_traits
 * \brief Namespace containing traits for working on type packs.
 */

#pragma once

#include <seqan3/utility/type_pack/traits.hpp>
