/*----- PROTECTED REGION ID(TangoTestClass.cpp) ENABLED START -----*/
//=============================================================================
//
// file :        TangoTestClass.cpp
//
// description : C++ source for the TangoTestClass.
//               A singleton class derived from DeviceClass.
//               It implements the command and attribute list
//               and all properties and methods required
//               by the TangoTest once per process.
//
// project :     TANGO Device Server for testing generic clients
//
// This file is part of Tango device class.
// 
// Tango is free software: you can redistribute it and/or modify
// it under the terms of the GNU General Public License as published by
// the Free Software Foundation, either version 3 of the License, or
// (at your option) any later version.
// 
// Tango is distributed in the hope that it will be useful,
// but WITHOUT ANY WARRANTY; without even the implied warranty of
// MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
// GNU General Public License for more details.
// 
// You should have received a copy of the GNU General Public License
// along with Tango.  If not, see <http://www.gnu.org/licenses/>.
// 
//=============================================================================
//                This file is generated by POGO
//        (Program Obviously used to Generate tango Object)
//=============================================================================


#include <tango/tango.h>
#include "TangoTest.h"
#include "TangoTestClass.h"

/*----- PROTECTED REGION END -----*/	//	TangoTestClass.cpp

//-------------------------------------------------------------------
/**
 *	Create TangoTestClass singleton and
 *	return it in a C function for Python usage
 */
//-------------------------------------------------------------------
extern "C" {
#ifdef _TG_WINDOWS_

__declspec(dllexport)

#endif

	Tango::DeviceClass *_create_TangoTest_class(const char *name) {
		return TangoTest_ns::TangoTestClass::init(name);
	}
}

namespace TangoTest_ns
{
//===================================================================
//	Initialize pointer for singleton pattern
//===================================================================
TangoTestClass *TangoTestClass::_instance = NULL;

//===================================================================
//	Class constants
//===================================================================
constexpr long boolean_spectrumAttrib::X_DATA_SIZE;
constexpr long boolean_spectrum_roAttrib::X_DATA_SIZE;
constexpr long double_spectrumAttrib::X_DATA_SIZE;
constexpr long double_spectrum_roAttrib::X_DATA_SIZE;
constexpr long float_spectrumAttrib::X_DATA_SIZE;
constexpr long float_spectrum_roAttrib::X_DATA_SIZE;
constexpr long long64_spectrum_roAttrib::X_DATA_SIZE;
constexpr long long_spectrumAttrib::X_DATA_SIZE;
constexpr long long_spectrum_roAttrib::X_DATA_SIZE;
constexpr long short_spectrumAttrib::X_DATA_SIZE;
constexpr long short_spectrum_roAttrib::X_DATA_SIZE;
constexpr long string_spectrumAttrib::X_DATA_SIZE;
constexpr long string_spectrum_roAttrib::X_DATA_SIZE;
constexpr long uchar_spectrumAttrib::X_DATA_SIZE;
constexpr long uchar_spectrum_roAttrib::X_DATA_SIZE;
constexpr long ulong64_spectrum_roAttrib::X_DATA_SIZE;
constexpr long ulong_spectrum_roAttrib::X_DATA_SIZE;
constexpr long ushort_spectrumAttrib::X_DATA_SIZE;
constexpr long ushort_spectrum_roAttrib::X_DATA_SIZE;
constexpr long waveAttrib::X_DATA_SIZE;
constexpr long enum_spectrumAttrib::X_DATA_SIZE;
constexpr long enum_spectrum_roAttrib::X_DATA_SIZE;
constexpr long boolean_imageAttrib::X_DATA_SIZE;
constexpr long boolean_imageAttrib::Y_DATA_SIZE;
constexpr long boolean_image_roAttrib::X_DATA_SIZE;
constexpr long boolean_image_roAttrib::Y_DATA_SIZE;
constexpr long double_imageAttrib::X_DATA_SIZE;
constexpr long double_imageAttrib::Y_DATA_SIZE;
constexpr long double_image_roAttrib::X_DATA_SIZE;
constexpr long double_image_roAttrib::Y_DATA_SIZE;
constexpr long float_imageAttrib::X_DATA_SIZE;
constexpr long float_imageAttrib::Y_DATA_SIZE;
constexpr long float_image_roAttrib::X_DATA_SIZE;
constexpr long float_image_roAttrib::Y_DATA_SIZE;
constexpr long long64_image_roAttrib::X_DATA_SIZE;
constexpr long long64_image_roAttrib::Y_DATA_SIZE;
constexpr long long_imageAttrib::X_DATA_SIZE;
constexpr long long_imageAttrib::Y_DATA_SIZE;
constexpr long long_image_roAttrib::X_DATA_SIZE;
constexpr long long_image_roAttrib::Y_DATA_SIZE;
constexpr long short_imageAttrib::X_DATA_SIZE;
constexpr long short_imageAttrib::Y_DATA_SIZE;
constexpr long short_image_roAttrib::X_DATA_SIZE;
constexpr long short_image_roAttrib::Y_DATA_SIZE;
constexpr long string_imageAttrib::X_DATA_SIZE;
constexpr long string_imageAttrib::Y_DATA_SIZE;
constexpr long string_image_roAttrib::X_DATA_SIZE;
constexpr long string_image_roAttrib::Y_DATA_SIZE;
constexpr long uchar_imageAttrib::X_DATA_SIZE;
constexpr long uchar_imageAttrib::Y_DATA_SIZE;
constexpr long uchar_image_roAttrib::X_DATA_SIZE;
constexpr long uchar_image_roAttrib::Y_DATA_SIZE;
constexpr long ulong64_image_roAttrib::X_DATA_SIZE;
constexpr long ulong64_image_roAttrib::Y_DATA_SIZE;
constexpr long ulong_image_roAttrib::X_DATA_SIZE;
constexpr long ulong_image_roAttrib::Y_DATA_SIZE;
constexpr long ushort_imageAttrib::X_DATA_SIZE;
constexpr long ushort_imageAttrib::Y_DATA_SIZE;
constexpr long ushort_image_roAttrib::X_DATA_SIZE;
constexpr long ushort_image_roAttrib::Y_DATA_SIZE;
constexpr long enum_image_roAttrib::X_DATA_SIZE;
constexpr long enum_image_roAttrib::Y_DATA_SIZE;
constexpr long enum_imageAttrib::X_DATA_SIZE;
constexpr long enum_imageAttrib::Y_DATA_SIZE;
//--------------------------------------------------------
/**
 * method : 		TangoTestClass::TangoTestClass(std::string &s)
 * description : 	constructor for the TangoTestClass
 *
 * @param s	The class name
 */
//--------------------------------------------------------
TangoTestClass::TangoTestClass(std::string &s):Tango::DeviceClass(s)
{
	TANGO_LOG_INFO << "Entering TangoTestClass constructor" << std::endl;
	set_default_property();
	write_class_property();

	/*----- PROTECTED REGION ID(TangoTestClass::constructor) ENABLED START -----*/
	
	/*----- PROTECTED REGION END -----*/	//	TangoTestClass::constructor

	TANGO_LOG_INFO << "Leaving TangoTestClass constructor" << std::endl;
}

//--------------------------------------------------------
/**
 * method : 		TangoTestClass::~TangoTestClass()
 * description : 	destructor for the TangoTestClass
 */
//--------------------------------------------------------
TangoTestClass::~TangoTestClass()
{
	/*----- PROTECTED REGION ID(TangoTestClass::destructor) ENABLED START -----*/
	
	/*----- PROTECTED REGION END -----*/	//	TangoTestClass::destructor

	_instance = NULL;
}


//--------------------------------------------------------
/**
 * method : 		TangoTestClass::init
 * description : 	Create the object if not already done.
 *                  Otherwise, just return a pointer to the object
 *
 * @param	name	The class name
 */
//--------------------------------------------------------
TangoTestClass *TangoTestClass::init(const char *name)
{
	if (_instance == NULL)
	{
		try
		{
			std::string s(name);
			_instance = new TangoTestClass(s);
		}
		catch (std::bad_alloc &)
		{
			throw;
		}
	}
	return _instance;
}

//--------------------------------------------------------
/**
 * method : 		TangoTestClass::instance
 * description : 	Check if object already created,
 *                  and return a pointer to the object
 */
//--------------------------------------------------------
TangoTestClass *TangoTestClass::instance()
{
	if (_instance == NULL)
	{
		std::cerr << "Class is not initialized !!" << std::endl;
		exit(-1);
	}
	return _instance;
}



//===================================================================
//	Command execution method calls
//===================================================================
//--------------------------------------------------------
/**
 * method : 		CrashFromDevelopperThreadClass::execute()
 * description : 	method to trigger the execution of the command.
 *
 * @param	device	The device on which the command must be executed
 * @param	in_any	The command input data
 *
 *	returns The command output data (packed in the Any object)
 */
//--------------------------------------------------------
CORBA::Any *CrashFromDevelopperThreadClass::execute(Tango::DeviceImpl *device, TANGO_UNUSED(const CORBA::Any &in_any))
{
	TANGO_LOG_INFO << "CrashFromDevelopperThreadClass::execute(): arrived" << std::endl;
	((static_cast<TangoTest *>(device))->crash_from_developper_thread());
	return new CORBA::Any();
}

//--------------------------------------------------------
/**
 * method : 		CrashFromOmniThreadClass::execute()
 * description : 	method to trigger the execution of the command.
 *
 * @param	device	The device on which the command must be executed
 * @param	in_any	The command input data
 *
 *	returns The command output data (packed in the Any object)
 */
//--------------------------------------------------------
CORBA::Any *CrashFromOmniThreadClass::execute(Tango::DeviceImpl *device, TANGO_UNUSED(const CORBA::Any &in_any))
{
	TANGO_LOG_INFO << "CrashFromOmniThreadClass::execute(): arrived" << std::endl;
	((static_cast<TangoTest *>(device))->crash_from_omni_thread());
	return new CORBA::Any();
}

//--------------------------------------------------------
/**
 * method : 		DevBooleanClass::execute()
 * description : 	method to trigger the execution of the command.
 *
 * @param	device	The device on which the command must be executed
 * @param	in_any	The command input data
 *
 *	returns The command output data (packed in the Any object)
 */
//--------------------------------------------------------
CORBA::Any *DevBooleanClass::execute(Tango::DeviceImpl *device, const CORBA::Any &in_any)
{
	TANGO_LOG_INFO << "DevBooleanClass::execute(): arrived" << std::endl;
	Tango::DevBoolean argin;
	extract(in_any, argin);
	return insert((static_cast<TangoTest *>(device))->dev_boolean(argin));
}

//--------------------------------------------------------
/**
 * method : 		DevDoubleClass::execute()
 * description : 	method to trigger the execution of the command.
 *
 * @param	device	The device on which the command must be executed
 * @param	in_any	The command input data
 *
 *	returns The command output data (packed in the Any object)
 */
//--------------------------------------------------------
CORBA::Any *DevDoubleClass::execute(Tango::DeviceImpl *device, const CORBA::Any &in_any)
{
	TANGO_LOG_INFO << "DevDoubleClass::execute(): arrived" << std::endl;
	Tango::DevDouble argin;
	extract(in_any, argin);
	return insert((static_cast<TangoTest *>(device))->dev_double(argin));
}

//--------------------------------------------------------
/**
 * method : 		DevFloatClass::execute()
 * description : 	method to trigger the execution of the command.
 *
 * @param	device	The device on which the command must be executed
 * @param	in_any	The command input data
 *
 *	returns The command output data (packed in the Any object)
 */
//--------------------------------------------------------
CORBA::Any *DevFloatClass::execute(Tango::DeviceImpl *device, const CORBA::Any &in_any)
{
	TANGO_LOG_INFO << "DevFloatClass::execute(): arrived" << std::endl;
	Tango::DevFloat argin;
	extract(in_any, argin);
	return insert((static_cast<TangoTest *>(device))->dev_float(argin));
}

//--------------------------------------------------------
/**
 * method : 		DevLongClass::execute()
 * description : 	method to trigger the execution of the command.
 *
 * @param	device	The device on which the command must be executed
 * @param	in_any	The command input data
 *
 *	returns The command output data (packed in the Any object)
 */
//--------------------------------------------------------
CORBA::Any *DevLongClass::execute(Tango::DeviceImpl *device, const CORBA::Any &in_any)
{
	TANGO_LOG_INFO << "DevLongClass::execute(): arrived" << std::endl;
	Tango::DevLong argin;
	extract(in_any, argin);
	return insert((static_cast<TangoTest *>(device))->dev_long(argin));
}

//--------------------------------------------------------
/**
 * method : 		DevLong64Class::execute()
 * description : 	method to trigger the execution of the command.
 *
 * @param	device	The device on which the command must be executed
 * @param	in_any	The command input data
 *
 *	returns The command output data (packed in the Any object)
 */
//--------------------------------------------------------
CORBA::Any *DevLong64Class::execute(Tango::DeviceImpl *device, const CORBA::Any &in_any)
{
	TANGO_LOG_INFO << "DevLong64Class::execute(): arrived" << std::endl;
	Tango::DevLong64 argin;
	extract(in_any, argin);
	return insert((static_cast<TangoTest *>(device))->dev_long64(argin));
}

//--------------------------------------------------------
/**
 * method : 		DevShortClass::execute()
 * description : 	method to trigger the execution of the command.
 *
 * @param	device	The device on which the command must be executed
 * @param	in_any	The command input data
 *
 *	returns The command output data (packed in the Any object)
 */
//--------------------------------------------------------
CORBA::Any *DevShortClass::execute(Tango::DeviceImpl *device, const CORBA::Any &in_any)
{
	TANGO_LOG_INFO << "DevShortClass::execute(): arrived" << std::endl;
	Tango::DevShort argin;
	extract(in_any, argin);
	return insert((static_cast<TangoTest *>(device))->dev_short(argin));
}

//--------------------------------------------------------
/**
 * method : 		DevStringClass::execute()
 * description : 	method to trigger the execution of the command.
 *
 * @param	device	The device on which the command must be executed
 * @param	in_any	The command input data
 *
 *	returns The command output data (packed in the Any object)
 */
//--------------------------------------------------------
CORBA::Any *DevStringClass::execute(Tango::DeviceImpl *device, const CORBA::Any &in_any)
{
	TANGO_LOG_INFO << "DevStringClass::execute(): arrived" << std::endl;
	Tango::DevString argin;
	extract(in_any, argin);
	return insert((static_cast<TangoTest *>(device))->dev_string(argin));
}

//--------------------------------------------------------
/**
 * method : 		DevULongClass::execute()
 * description : 	method to trigger the execution of the command.
 *
 * @param	device	The device on which the command must be executed
 * @param	in_any	The command input data
 *
 *	returns The command output data (packed in the Any object)
 */
//--------------------------------------------------------
CORBA::Any *DevULongClass::execute(Tango::DeviceImpl *device, const CORBA::Any &in_any)
{
	TANGO_LOG_INFO << "DevULongClass::execute(): arrived" << std::endl;
	Tango::DevULong argin;
	extract(in_any, argin);
	return insert((static_cast<TangoTest *>(device))->dev_ulong(argin));
}

//--------------------------------------------------------
/**
 * method : 		DevULong64Class::execute()
 * description : 	method to trigger the execution of the command.
 *
 * @param	device	The device on which the command must be executed
 * @param	in_any	The command input data
 *
 *	returns The command output data (packed in the Any object)
 */
//--------------------------------------------------------
CORBA::Any *DevULong64Class::execute(Tango::DeviceImpl *device, const CORBA::Any &in_any)
{
	TANGO_LOG_INFO << "DevULong64Class::execute(): arrived" << std::endl;
	Tango::DevULong64 argin;
	extract(in_any, argin);
	return insert((static_cast<TangoTest *>(device))->dev_ulong64(argin));
}

//--------------------------------------------------------
/**
 * method : 		DevUShortClass::execute()
 * description : 	method to trigger the execution of the command.
 *
 * @param	device	The device on which the command must be executed
 * @param	in_any	The command input data
 *
 *	returns The command output data (packed in the Any object)
 */
//--------------------------------------------------------
CORBA::Any *DevUShortClass::execute(Tango::DeviceImpl *device, const CORBA::Any &in_any)
{
	TANGO_LOG_INFO << "DevUShortClass::execute(): arrived" << std::endl;
	Tango::DevUShort argin;
	extract(in_any, argin);
	return insert((static_cast<TangoTest *>(device))->dev_ushort(argin));
}

//--------------------------------------------------------
/**
 * method : 		DevVarCharArrayClass::execute()
 * description : 	method to trigger the execution of the command.
 *
 * @param	device	The device on which the command must be executed
 * @param	in_any	The command input data
 *
 *	returns The command output data (packed in the Any object)
 */
//--------------------------------------------------------
CORBA::Any *DevVarCharArrayClass::execute(Tango::DeviceImpl *device, const CORBA::Any &in_any)
{
	TANGO_LOG_INFO << "DevVarCharArrayClass::execute(): arrived" << std::endl;
	const Tango::DevVarCharArray *argin;
	extract(in_any, argin);
	return insert((static_cast<TangoTest *>(device))->dev_var_char_array(argin));
}

//--------------------------------------------------------
/**
 * method : 		DevVarDoubleArrayClass::execute()
 * description : 	method to trigger the execution of the command.
 *
 * @param	device	The device on which the command must be executed
 * @param	in_any	The command input data
 *
 *	returns The command output data (packed in the Any object)
 */
//--------------------------------------------------------
CORBA::Any *DevVarDoubleArrayClass::execute(Tango::DeviceImpl *device, const CORBA::Any &in_any)
{
	TANGO_LOG_INFO << "DevVarDoubleArrayClass::execute(): arrived" << std::endl;
	const Tango::DevVarDoubleArray *argin;
	extract(in_any, argin);
	return insert((static_cast<TangoTest *>(device))->dev_var_double_array(argin));
}

//--------------------------------------------------------
/**
 * method : 		DevVarDoubleStringArrayClass::execute()
 * description : 	method to trigger the execution of the command.
 *
 * @param	device	The device on which the command must be executed
 * @param	in_any	The command input data
 *
 *	returns The command output data (packed in the Any object)
 */
//--------------------------------------------------------
CORBA::Any *DevVarDoubleStringArrayClass::execute(Tango::DeviceImpl *device, const CORBA::Any &in_any)
{
	TANGO_LOG_INFO << "DevVarDoubleStringArrayClass::execute(): arrived" << std::endl;
	const Tango::DevVarDoubleStringArray *argin;
	extract(in_any, argin);
	return insert((static_cast<TangoTest *>(device))->dev_var_double_string_array(argin));
}

//--------------------------------------------------------
/**
 * method : 		DevVarFloatArrayClass::execute()
 * description : 	method to trigger the execution of the command.
 *
 * @param	device	The device on which the command must be executed
 * @param	in_any	The command input data
 *
 *	returns The command output data (packed in the Any object)
 */
//--------------------------------------------------------
CORBA::Any *DevVarFloatArrayClass::execute(Tango::DeviceImpl *device, const CORBA::Any &in_any)
{
	TANGO_LOG_INFO << "DevVarFloatArrayClass::execute(): arrived" << std::endl;
	const Tango::DevVarFloatArray *argin;
	extract(in_any, argin);
	return insert((static_cast<TangoTest *>(device))->dev_var_float_array(argin));
}

//--------------------------------------------------------
/**
 * method : 		DevVarLong64ArrayClass::execute()
 * description : 	method to trigger the execution of the command.
 *
 * @param	device	The device on which the command must be executed
 * @param	in_any	The command input data
 *
 *	returns The command output data (packed in the Any object)
 */
//--------------------------------------------------------
CORBA::Any *DevVarLong64ArrayClass::execute(Tango::DeviceImpl *device, const CORBA::Any &in_any)
{
	TANGO_LOG_INFO << "DevVarLong64ArrayClass::execute(): arrived" << std::endl;
	const Tango::DevVarLong64Array *argin;
	extract(in_any, argin);
	return insert((static_cast<TangoTest *>(device))->dev_var_long64_array(argin));
}

//--------------------------------------------------------
/**
 * method : 		DevVarLongArrayClass::execute()
 * description : 	method to trigger the execution of the command.
 *
 * @param	device	The device on which the command must be executed
 * @param	in_any	The command input data
 *
 *	returns The command output data (packed in the Any object)
 */
//--------------------------------------------------------
CORBA::Any *DevVarLongArrayClass::execute(Tango::DeviceImpl *device, const CORBA::Any &in_any)
{
	TANGO_LOG_INFO << "DevVarLongArrayClass::execute(): arrived" << std::endl;
	const Tango::DevVarLongArray *argin;
	extract(in_any, argin);
	return insert((static_cast<TangoTest *>(device))->dev_var_long_array(argin));
}

//--------------------------------------------------------
/**
 * method : 		DevVarLongStringArrayClass::execute()
 * description : 	method to trigger the execution of the command.
 *
 * @param	device	The device on which the command must be executed
 * @param	in_any	The command input data
 *
 *	returns The command output data (packed in the Any object)
 */
//--------------------------------------------------------
CORBA::Any *DevVarLongStringArrayClass::execute(Tango::DeviceImpl *device, const CORBA::Any &in_any)
{
	TANGO_LOG_INFO << "DevVarLongStringArrayClass::execute(): arrived" << std::endl;
	const Tango::DevVarLongStringArray *argin;
	extract(in_any, argin);
	return insert((static_cast<TangoTest *>(device))->dev_var_long_string_array(argin));
}

//--------------------------------------------------------
/**
 * method : 		DevVarShortArrayClass::execute()
 * description : 	method to trigger the execution of the command.
 *
 * @param	device	The device on which the command must be executed
 * @param	in_any	The command input data
 *
 *	returns The command output data (packed in the Any object)
 */
//--------------------------------------------------------
CORBA::Any *DevVarShortArrayClass::execute(Tango::DeviceImpl *device, const CORBA::Any &in_any)
{
	TANGO_LOG_INFO << "DevVarShortArrayClass::execute(): arrived" << std::endl;
	const Tango::DevVarShortArray *argin;
	extract(in_any, argin);
	return insert((static_cast<TangoTest *>(device))->dev_var_short_array(argin));
}

//--------------------------------------------------------
/**
 * method : 		DevVarStringArrayClass::execute()
 * description : 	method to trigger the execution of the command.
 *
 * @param	device	The device on which the command must be executed
 * @param	in_any	The command input data
 *
 *	returns The command output data (packed in the Any object)
 */
//--------------------------------------------------------
CORBA::Any *DevVarStringArrayClass::execute(Tango::DeviceImpl *device, const CORBA::Any &in_any)
{
	TANGO_LOG_INFO << "DevVarStringArrayClass::execute(): arrived" << std::endl;
	const Tango::DevVarStringArray *argin;
	extract(in_any, argin);
	return insert((static_cast<TangoTest *>(device))->dev_var_string_array(argin));
}

//--------------------------------------------------------
/**
 * method : 		DevVarULong64ArrayClass::execute()
 * description : 	method to trigger the execution of the command.
 *
 * @param	device	The device on which the command must be executed
 * @param	in_any	The command input data
 *
 *	returns The command output data (packed in the Any object)
 */
//--------------------------------------------------------
CORBA::Any *DevVarULong64ArrayClass::execute(Tango::DeviceImpl *device, const CORBA::Any &in_any)
{
	TANGO_LOG_INFO << "DevVarULong64ArrayClass::execute(): arrived" << std::endl;
	const Tango::DevVarULong64Array *argin;
	extract(in_any, argin);
	return insert((static_cast<TangoTest *>(device))->dev_var_ulong64_array(argin));
}

//--------------------------------------------------------
/**
 * method : 		DevVarULongArrayClass::execute()
 * description : 	method to trigger the execution of the command.
 *
 * @param	device	The device on which the command must be executed
 * @param	in_any	The command input data
 *
 *	returns The command output data (packed in the Any object)
 */
//--------------------------------------------------------
CORBA::Any *DevVarULongArrayClass::execute(Tango::DeviceImpl *device, const CORBA::Any &in_any)
{
	TANGO_LOG_INFO << "DevVarULongArrayClass::execute(): arrived" << std::endl;
	const Tango::DevVarULongArray *argin;
	extract(in_any, argin);
	return insert((static_cast<TangoTest *>(device))->dev_var_ulong_array(argin));
}

//--------------------------------------------------------
/**
 * method : 		DevVarUShortArrayClass::execute()
 * description : 	method to trigger the execution of the command.
 *
 * @param	device	The device on which the command must be executed
 * @param	in_any	The command input data
 *
 *	returns The command output data (packed in the Any object)
 */
//--------------------------------------------------------
CORBA::Any *DevVarUShortArrayClass::execute(Tango::DeviceImpl *device, const CORBA::Any &in_any)
{
	TANGO_LOG_INFO << "DevVarUShortArrayClass::execute(): arrived" << std::endl;
	const Tango::DevVarUShortArray *argin;
	extract(in_any, argin);
	return insert((static_cast<TangoTest *>(device))->dev_var_ushort_array(argin));
}

//--------------------------------------------------------
/**
 * method : 		DevVoidClass::execute()
 * description : 	method to trigger the execution of the command.
 *
 * @param	device	The device on which the command must be executed
 * @param	in_any	The command input data
 *
 *	returns The command output data (packed in the Any object)
 */
//--------------------------------------------------------
CORBA::Any *DevVoidClass::execute(Tango::DeviceImpl *device, TANGO_UNUSED(const CORBA::Any &in_any))
{
	TANGO_LOG_INFO << "DevVoidClass::execute(): arrived" << std::endl;
	((static_cast<TangoTest *>(device))->dev_void());
	return new CORBA::Any();
}

//--------------------------------------------------------
/**
 * method : 		DumpExecutionStateClass::execute()
 * description : 	method to trigger the execution of the command.
 *
 * @param	device	The device on which the command must be executed
 * @param	in_any	The command input data
 *
 *	returns The command output data (packed in the Any object)
 */
//--------------------------------------------------------
CORBA::Any *DumpExecutionStateClass::execute(Tango::DeviceImpl *device, TANGO_UNUSED(const CORBA::Any &in_any))
{
	TANGO_LOG_INFO << "DumpExecutionStateClass::execute(): arrived" << std::endl;
	((static_cast<TangoTest *>(device))->dump_execution_state());
	return new CORBA::Any();
}

//--------------------------------------------------------
/**
 * method : 		SwitchStatesClass::execute()
 * description : 	method to trigger the execution of the command.
 *
 * @param	device	The device on which the command must be executed
 * @param	in_any	The command input data
 *
 *	returns The command output data (packed in the Any object)
 */
//--------------------------------------------------------
CORBA::Any *SwitchStatesClass::execute(Tango::DeviceImpl *device, TANGO_UNUSED(const CORBA::Any &in_any))
{
	TANGO_LOG_INFO << "SwitchStatesClass::execute(): arrived" << std::endl;
	((static_cast<TangoTest *>(device))->switch_states());
	return new CORBA::Any();
}


//===================================================================
//	Properties management
//===================================================================
//--------------------------------------------------------
/**
 *	Method     : TangoTestClass::get_class_property()
 *	Description: Get the class property for specified name.
 */
//--------------------------------------------------------
Tango::DbDatum TangoTestClass::get_class_property(std::string &prop_name)
{
	for (unsigned int i=0 ; i<cl_prop.size() ; i++)
		if (cl_prop[i].name == prop_name)
			return cl_prop[i];
	//	if not found, returns  an empty DbDatum
	return Tango::DbDatum(prop_name);
}

//--------------------------------------------------------
/**
 *	Method     : TangoTestClass::get_default_device_property()
 *	Description: Return the default value for device property.
 */
//--------------------------------------------------------
Tango::DbDatum TangoTestClass::get_default_device_property(std::string &prop_name)
{
	for (unsigned int i=0 ; i<dev_def_prop.size() ; i++)
		if (dev_def_prop[i].name == prop_name)
			return dev_def_prop[i];
	//	if not found, return  an empty DbDatum
	return Tango::DbDatum(prop_name);
}

//--------------------------------------------------------
/**
 *	Method     : TangoTestClass::get_default_class_property()
 *	Description: Return the default value for class property.
 */
//--------------------------------------------------------
Tango::DbDatum TangoTestClass::get_default_class_property(std::string &prop_name)
{
	for (unsigned int i=0 ; i<cl_def_prop.size() ; i++)
		if (cl_def_prop[i].name == prop_name)
			return cl_def_prop[i];
	//	if not found, return  an empty DbDatum
	return Tango::DbDatum(prop_name);
}


//--------------------------------------------------------
/**
 *	Method     : TangoTestClass::set_default_property()
 *	Description: Set default property (class and device) for wizard.
 *                For each property, add to wizard property name and description.
 *                If default value has been set, add it to wizard property and
 *                store it in a DbDatum.
 */
//--------------------------------------------------------
void TangoTestClass::set_default_property()
{
	std::string	prop_name;
	std::string	prop_desc;
	std::string	prop_def;
	std::vector<std::string>	vect_data;

	//	Set Default Class Properties

	//	Set Default device Properties
	prop_name = "Mthreaded_impl";
	prop_desc = "Multi-threaded implementation (true/false";
	prop_def  = "";
	vect_data.clear();
	if (prop_def.length()>0)
	{
		Tango::DbDatum	data(prop_name);
		data << vect_data ;
		dev_def_prop.push_back(data);
		add_wiz_dev_prop(prop_name, prop_desc,  prop_def);
	}
	else
		add_wiz_dev_prop(prop_name, prop_desc);
	prop_name = "Sleep_period";
	prop_desc = "Data generation period (in ms";
	prop_def  = "";
	vect_data.clear();
	if (prop_def.length()>0)
	{
		Tango::DbDatum	data(prop_name);
		data << vect_data ;
		dev_def_prop.push_back(data);
		add_wiz_dev_prop(prop_name, prop_desc,  prop_def);
	}
	else
		add_wiz_dev_prop(prop_name, prop_desc);
	prop_name = "UShort_image_ro_size";
	prop_desc = "Size of the ushort_image_ro attribute";
	prop_def  = "251";
	vect_data.clear();
	vect_data.push_back("251");
	if (prop_def.length()>0)
	{
		Tango::DbDatum	data(prop_name);
		data << vect_data ;
		dev_def_prop.push_back(data);
		add_wiz_dev_prop(prop_name, prop_desc,  prop_def);
	}
	else
		add_wiz_dev_prop(prop_name, prop_desc);
}

//--------------------------------------------------------
/**
 *	Method     : TangoTestClass::write_class_property()
 *	Description: Set class description fields as property in database
 */
//--------------------------------------------------------
void TangoTestClass::write_class_property()
{
	//	First time, check if database used
	if (Tango::Util::_UseDb == false)
		return;

	Tango::DbData	data;
	std::string	classname = get_name();
	std::string	header;

	//	Put title
	Tango::DbDatum	title("ProjectTitle");
	std::string	str_title("TANGO Device Server for testing generic clients");
	title << str_title;
	data.push_back(title);

	//	Put Description
	Tango::DbDatum	description("Description");
	std::vector<std::string>	str_desc;
	str_desc.push_back("A device to test generic clients. It offers a \"echo\" like command for");
	str_desc.push_back("each TANGO data type (i.e. each command returns an exact copy of <argin>).");
	description << str_desc;
	data.push_back(description);

	//  Put inheritance
	Tango::DbDatum	inher_datum("InheritedFrom");
	std::vector<std::string> inheritance;
	inheritance.push_back("TANGO_BASE_CLASS");
	inher_datum << inheritance;
	data.push_back(inher_datum);

	//	Call database and and values
	get_db_class()->put_property(data);
}

//===================================================================
//	Factory methods
//===================================================================

//--------------------------------------------------------
/**
 *	Method     : TangoTestClass::device_factory()
 *	Description: Create the device object(s)
 *                and store them in the device list
 */
//--------------------------------------------------------
void TangoTestClass::device_factory(const Tango::DevVarStringArray *devlist_ptr)
{
	/*----- PROTECTED REGION ID(TangoTestClass::device_factory_before) ENABLED START -----*/
	
	//	Add your own code
	
	/*----- PROTECTED REGION END -----*/	//	TangoTestClass::device_factory_before

	//	Create devices and add it into the device list
	for (unsigned long i=0 ; i<devlist_ptr->length() ; i++)
	{
		TANGO_LOG_DEBUG << "Device name : " << (*devlist_ptr)[i].in() << std::endl;
		device_list.push_back(new TangoTest(this, (*devlist_ptr)[i]));
	}

	//	Manage dynamic attributes if any
	erase_dynamic_attributes(devlist_ptr, get_class_attr()->get_attr_list());

	//	Export devices to the outside world
	for (unsigned long i=1 ; i<=devlist_ptr->length() ; i++)
	{
		//	Add dynamic attributes if any
		TangoTest *dev = static_cast<TangoTest *>(device_list[device_list.size()-i]);
		dev->add_dynamic_attributes();

		//	Check before if database used.
		if ((Tango::Util::_UseDb == true) && (Tango::Util::_FileDb == false))
			export_device(dev);
		else
			export_device(dev, dev->get_name().c_str());
	}

	/*----- PROTECTED REGION ID(TangoTestClass::device_factory_after) ENABLED START -----*/
	
	//	Add your own code
	
	/*----- PROTECTED REGION END -----*/	//	TangoTestClass::device_factory_after
}
//--------------------------------------------------------
/**
 *	Method     : TangoTestClass::attribute_factory()
 *	Description: Create the attribute object(s)
 *                and store them in the attribute list
 */
//--------------------------------------------------------
void TangoTestClass::attribute_factory(std::vector<Tango::Attr *> &att_list)
{
	/*----- PROTECTED REGION ID(TangoTestClass::attribute_factory_before) ENABLED START -----*/
	
	//	Add your own code
	
	/*----- PROTECTED REGION END -----*/	//	TangoTestClass::attribute_factory_before
	//	Attribute : ampli
	ampliAttrib	*ampli = new ampliAttrib();
	Tango::UserDefaultAttrProp	ampli_prop;
	//	description	not set for ampli
	//	label	not set for ampli
	//	unit	not set for ampli
	//	standard_unit	not set for ampli
	//	display_unit	not set for ampli
	//	format	not set for ampli
	//	max_value	not set for ampli
	//	min_value	not set for ampli
	//	max_alarm	not set for ampli
	//	min_alarm	not set for ampli
	//	max_warning	not set for ampli
	//	min_warning	not set for ampli
	//	delta_t	not set for ampli
	//	delta_val	not set for ampli
	ampli->set_default_properties(ampli_prop);
	//	Not Polled
	ampli->set_disp_level(Tango::OPERATOR);
	//	Not Memorized
	att_list.push_back(ampli);

	//	Attribute : boolean_scalar
	boolean_scalarAttrib	*boolean_scalar = new boolean_scalarAttrib();
	Tango::UserDefaultAttrProp	boolean_scalar_prop;
	boolean_scalar_prop.set_description("A boolean scalar attribute");
	boolean_scalar_prop.set_label("boolean_scalar");
	//	unit	not set for boolean_scalar
	//	standard_unit	not set for boolean_scalar
	//	display_unit	not set for boolean_scalar
	//	format	not set for boolean_scalar
	//	max_value	not set for boolean_scalar
	//	min_value	not set for boolean_scalar
	//	max_alarm	not set for boolean_scalar
	//	min_alarm	not set for boolean_scalar
	//	max_warning	not set for boolean_scalar
	//	min_warning	not set for boolean_scalar
	//	delta_t	not set for boolean_scalar
	//	delta_val	not set for boolean_scalar
	boolean_scalar->set_default_properties(boolean_scalar_prop);
	//	Not Polled
	boolean_scalar->set_disp_level(Tango::OPERATOR);
	//	Not Memorized
	att_list.push_back(boolean_scalar);

	//	Attribute : double_scalar
	double_scalarAttrib	*double_scalar = new double_scalarAttrib();
	Tango::UserDefaultAttrProp	double_scalar_prop;
	//	description	not set for double_scalar
	//	label	not set for double_scalar
	//	unit	not set for double_scalar
	//	standard_unit	not set for double_scalar
	//	display_unit	not set for double_scalar
	//	format	not set for double_scalar
	//	max_value	not set for double_scalar
	//	min_value	not set for double_scalar
	//	max_alarm	not set for double_scalar
	//	min_alarm	not set for double_scalar
	//	max_warning	not set for double_scalar
	//	min_warning	not set for double_scalar
	//	delta_t	not set for double_scalar
	//	delta_val	not set for double_scalar
	double_scalar->set_default_properties(double_scalar_prop);
	//	Not Polled
	double_scalar->set_disp_level(Tango::OPERATOR);
	//	Not Memorized
	att_list.push_back(double_scalar);

	//	Attribute : double_scalar_rww
	double_scalar_rwwAttrib	*double_scalar_rww = new double_scalar_rwwAttrib();
	Tango::UserDefaultAttrProp	double_scalar_rww_prop;
	//	description	not set for double_scalar_rww
	//	label	not set for double_scalar_rww
	//	unit	not set for double_scalar_rww
	//	standard_unit	not set for double_scalar_rww
	//	display_unit	not set for double_scalar_rww
	//	format	not set for double_scalar_rww
	//	max_value	not set for double_scalar_rww
	//	min_value	not set for double_scalar_rww
	//	max_alarm	not set for double_scalar_rww
	//	min_alarm	not set for double_scalar_rww
	//	max_warning	not set for double_scalar_rww
	//	min_warning	not set for double_scalar_rww
	//	delta_t	not set for double_scalar_rww
	//	delta_val	not set for double_scalar_rww
	double_scalar_rww->set_default_properties(double_scalar_rww_prop);
	//	Not Polled
	double_scalar_rww->set_disp_level(Tango::OPERATOR);
	//	Not Memorized
	att_list.push_back(double_scalar_rww);

	//	Attribute : double_scalar_w
	double_scalar_wAttrib	*double_scalar_w = new double_scalar_wAttrib();
	Tango::UserDefaultAttrProp	double_scalar_w_prop;
	//	description	not set for double_scalar_w
	//	label	not set for double_scalar_w
	//	unit	not set for double_scalar_w
	//	standard_unit	not set for double_scalar_w
	//	display_unit	not set for double_scalar_w
	//	format	not set for double_scalar_w
	//	max_value	not set for double_scalar_w
	//	min_value	not set for double_scalar_w
	//	max_alarm	not set for double_scalar_w
	//	min_alarm	not set for double_scalar_w
	//	max_warning	not set for double_scalar_w
	//	min_warning	not set for double_scalar_w
	//	delta_t	not set for double_scalar_w
	//	delta_val	not set for double_scalar_w
	double_scalar_w->set_default_properties(double_scalar_w_prop);
	//	Not Polled
	double_scalar_w->set_disp_level(Tango::OPERATOR);
	//	Not Memorized
	att_list.push_back(double_scalar_w);

	//	Attribute : float_scalar
	float_scalarAttrib	*float_scalar = new float_scalarAttrib();
	Tango::UserDefaultAttrProp	float_scalar_prop;
	float_scalar_prop.set_description("A float attribute");
	float_scalar_prop.set_label("float_scalar");
	//	unit	not set for float_scalar
	//	standard_unit	not set for float_scalar
	//	display_unit	not set for float_scalar
	//	format	not set for float_scalar
	//	max_value	not set for float_scalar
	//	min_value	not set for float_scalar
	//	max_alarm	not set for float_scalar
	//	min_alarm	not set for float_scalar
	//	max_warning	not set for float_scalar
	//	min_warning	not set for float_scalar
	//	delta_t	not set for float_scalar
	//	delta_val	not set for float_scalar
	float_scalar->set_default_properties(float_scalar_prop);
	//	Not Polled
	float_scalar->set_disp_level(Tango::OPERATOR);
	//	Not Memorized
	att_list.push_back(float_scalar);

	//	Attribute : long64_scalar
	long64_scalarAttrib	*long64_scalar = new long64_scalarAttrib();
	Tango::UserDefaultAttrProp	long64_scalar_prop;
	//	description	not set for long64_scalar
	//	label	not set for long64_scalar
	//	unit	not set for long64_scalar
	//	standard_unit	not set for long64_scalar
	//	display_unit	not set for long64_scalar
	//	format	not set for long64_scalar
	//	max_value	not set for long64_scalar
	//	min_value	not set for long64_scalar
	//	max_alarm	not set for long64_scalar
	//	min_alarm	not set for long64_scalar
	//	max_warning	not set for long64_scalar
	//	min_warning	not set for long64_scalar
	//	delta_t	not set for long64_scalar
	//	delta_val	not set for long64_scalar
	long64_scalar->set_default_properties(long64_scalar_prop);
	//	Not Polled
	long64_scalar->set_disp_level(Tango::OPERATOR);
	//	Not Memorized
	att_list.push_back(long64_scalar);

	//	Attribute : long_scalar
	long_scalarAttrib	*long_scalar = new long_scalarAttrib();
	Tango::UserDefaultAttrProp	long_scalar_prop;
	//	description	not set for long_scalar
	//	label	not set for long_scalar
	//	unit	not set for long_scalar
	//	standard_unit	not set for long_scalar
	//	display_unit	not set for long_scalar
	//	format	not set for long_scalar
	//	max_value	not set for long_scalar
	//	min_value	not set for long_scalar
	//	max_alarm	not set for long_scalar
	//	min_alarm	not set for long_scalar
	//	max_warning	not set for long_scalar
	//	min_warning	not set for long_scalar
	//	delta_t	not set for long_scalar
	//	delta_val	not set for long_scalar
	long_scalar->set_default_properties(long_scalar_prop);
	//	Not Polled
	long_scalar->set_disp_level(Tango::OPERATOR);
	//	Not Memorized
	att_list.push_back(long_scalar);

	//	Attribute : long_scalar_rww
	long_scalar_rwwAttrib	*long_scalar_rww = new long_scalar_rwwAttrib();
	Tango::UserDefaultAttrProp	long_scalar_rww_prop;
	//	description	not set for long_scalar_rww
	//	label	not set for long_scalar_rww
	//	unit	not set for long_scalar_rww
	//	standard_unit	not set for long_scalar_rww
	//	display_unit	not set for long_scalar_rww
	//	format	not set for long_scalar_rww
	//	max_value	not set for long_scalar_rww
	//	min_value	not set for long_scalar_rww
	//	max_alarm	not set for long_scalar_rww
	//	min_alarm	not set for long_scalar_rww
	//	max_warning	not set for long_scalar_rww
	//	min_warning	not set for long_scalar_rww
	//	delta_t	not set for long_scalar_rww
	//	delta_val	not set for long_scalar_rww
	long_scalar_rww->set_default_properties(long_scalar_rww_prop);
	//	Not Polled
	long_scalar_rww->set_disp_level(Tango::OPERATOR);
	//	Not Memorized
	att_list.push_back(long_scalar_rww);

	//	Attribute : long_scalar_w
	long_scalar_wAttrib	*long_scalar_w = new long_scalar_wAttrib();
	Tango::UserDefaultAttrProp	long_scalar_w_prop;
	//	description	not set for long_scalar_w
	//	label	not set for long_scalar_w
	//	unit	not set for long_scalar_w
	//	standard_unit	not set for long_scalar_w
	//	display_unit	not set for long_scalar_w
	//	format	not set for long_scalar_w
	//	max_value	not set for long_scalar_w
	//	min_value	not set for long_scalar_w
	//	max_alarm	not set for long_scalar_w
	//	min_alarm	not set for long_scalar_w
	//	max_warning	not set for long_scalar_w
	//	min_warning	not set for long_scalar_w
	//	delta_t	not set for long_scalar_w
	//	delta_val	not set for long_scalar_w
	long_scalar_w->set_default_properties(long_scalar_w_prop);
	//	Not Polled
	long_scalar_w->set_disp_level(Tango::OPERATOR);
	//	Not Memorized
	att_list.push_back(long_scalar_w);

	//	Attribute : no_value
	no_valueAttrib	*no_value = new no_valueAttrib();
	Tango::UserDefaultAttrProp	no_value_prop;
	//	description	not set for no_value
	//	label	not set for no_value
	//	unit	not set for no_value
	//	standard_unit	not set for no_value
	//	display_unit	not set for no_value
	//	format	not set for no_value
	//	max_value	not set for no_value
	//	min_value	not set for no_value
	//	max_alarm	not set for no_value
	//	min_alarm	not set for no_value
	//	max_warning	not set for no_value
	//	min_warning	not set for no_value
	//	delta_t	not set for no_value
	//	delta_val	not set for no_value
	no_value->set_default_properties(no_value_prop);
	//	Not Polled
	no_value->set_disp_level(Tango::OPERATOR);
	//	Not Memorized
	att_list.push_back(no_value);

	//	Attribute : short_scalar
	short_scalarAttrib	*short_scalar = new short_scalarAttrib();
	Tango::UserDefaultAttrProp	short_scalar_prop;
	//	description	not set for short_scalar
	//	label	not set for short_scalar
	//	unit	not set for short_scalar
	//	standard_unit	not set for short_scalar
	//	display_unit	not set for short_scalar
	//	format	not set for short_scalar
	//	max_value	not set for short_scalar
	//	min_value	not set for short_scalar
	//	max_alarm	not set for short_scalar
	//	min_alarm	not set for short_scalar
	//	max_warning	not set for short_scalar
	//	min_warning	not set for short_scalar
	//	delta_t	not set for short_scalar
	//	delta_val	not set for short_scalar
	short_scalar->set_default_properties(short_scalar_prop);
	//	Not Polled
	short_scalar->set_disp_level(Tango::OPERATOR);
	//	Not Memorized
	att_list.push_back(short_scalar);

	//	Attribute : short_scalar_ro
	short_scalar_roAttrib	*short_scalar_ro = new short_scalar_roAttrib();
	Tango::UserDefaultAttrProp	short_scalar_ro_prop;
	//	description	not set for short_scalar_ro
	//	label	not set for short_scalar_ro
	//	unit	not set for short_scalar_ro
	//	standard_unit	not set for short_scalar_ro
	//	display_unit	not set for short_scalar_ro
	//	format	not set for short_scalar_ro
	//	max_value	not set for short_scalar_ro
	//	min_value	not set for short_scalar_ro
	//	max_alarm	not set for short_scalar_ro
	//	min_alarm	not set for short_scalar_ro
	//	max_warning	not set for short_scalar_ro
	//	min_warning	not set for short_scalar_ro
	//	delta_t	not set for short_scalar_ro
	//	delta_val	not set for short_scalar_ro
	short_scalar_ro->set_default_properties(short_scalar_ro_prop);
	//	Not Polled
	short_scalar_ro->set_disp_level(Tango::OPERATOR);
	//	Not Memorized
	att_list.push_back(short_scalar_ro);

	//	Attribute : short_scalar_rww
	short_scalar_rwwAttrib	*short_scalar_rww = new short_scalar_rwwAttrib();
	Tango::UserDefaultAttrProp	short_scalar_rww_prop;
	//	description	not set for short_scalar_rww
	//	label	not set for short_scalar_rww
	//	unit	not set for short_scalar_rww
	//	standard_unit	not set for short_scalar_rww
	//	display_unit	not set for short_scalar_rww
	//	format	not set for short_scalar_rww
	//	max_value	not set for short_scalar_rww
	//	min_value	not set for short_scalar_rww
	//	max_alarm	not set for short_scalar_rww
	//	min_alarm	not set for short_scalar_rww
	//	max_warning	not set for short_scalar_rww
	//	min_warning	not set for short_scalar_rww
	//	delta_t	not set for short_scalar_rww
	//	delta_val	not set for short_scalar_rww
	short_scalar_rww->set_default_properties(short_scalar_rww_prop);
	//	Not Polled
	short_scalar_rww->set_disp_level(Tango::OPERATOR);
	//	Not Memorized
	att_list.push_back(short_scalar_rww);

	//	Attribute : short_scalar_w
	short_scalar_wAttrib	*short_scalar_w = new short_scalar_wAttrib();
	Tango::UserDefaultAttrProp	short_scalar_w_prop;
	//	description	not set for short_scalar_w
	//	label	not set for short_scalar_w
	//	unit	not set for short_scalar_w
	//	standard_unit	not set for short_scalar_w
	//	display_unit	not set for short_scalar_w
	//	format	not set for short_scalar_w
	//	max_value	not set for short_scalar_w
	//	min_value	not set for short_scalar_w
	//	max_alarm	not set for short_scalar_w
	//	min_alarm	not set for short_scalar_w
	//	max_warning	not set for short_scalar_w
	//	min_warning	not set for short_scalar_w
	//	delta_t	not set for short_scalar_w
	//	delta_val	not set for short_scalar_w
	short_scalar_w->set_default_properties(short_scalar_w_prop);
	//	Not Polled
	short_scalar_w->set_disp_level(Tango::OPERATOR);
	//	Not Memorized
	att_list.push_back(short_scalar_w);

	//	Attribute : string_scalar
	string_scalarAttrib	*string_scalar = new string_scalarAttrib();
	Tango::UserDefaultAttrProp	string_scalar_prop;
	//	description	not set for string_scalar
	//	label	not set for string_scalar
	//	unit	not set for string_scalar
	//	standard_unit	not set for string_scalar
	//	display_unit	not set for string_scalar
	//	format	not set for string_scalar
	//	max_value	not set for string_scalar
	//	min_value	not set for string_scalar
	//	max_alarm	not set for string_scalar
	//	min_alarm	not set for string_scalar
	//	max_warning	not set for string_scalar
	//	min_warning	not set for string_scalar
	//	delta_t	not set for string_scalar
	//	delta_val	not set for string_scalar
	string_scalar->set_default_properties(string_scalar_prop);
	//	Not Polled
	string_scalar->set_disp_level(Tango::OPERATOR);
	//	Not Memorized
	att_list.push_back(string_scalar);

	//	Attribute : throw_exception
	throw_exceptionAttrib	*throw_exception = new throw_exceptionAttrib();
	Tango::UserDefaultAttrProp	throw_exception_prop;
	//	description	not set for throw_exception
	//	label	not set for throw_exception
	//	unit	not set for throw_exception
	//	standard_unit	not set for throw_exception
	//	display_unit	not set for throw_exception
	//	format	not set for throw_exception
	//	max_value	not set for throw_exception
	//	min_value	not set for throw_exception
	//	max_alarm	not set for throw_exception
	//	min_alarm	not set for throw_exception
	//	max_warning	not set for throw_exception
	//	min_warning	not set for throw_exception
	//	delta_t	not set for throw_exception
	//	delta_val	not set for throw_exception
	throw_exception->set_default_properties(throw_exception_prop);
	//	Not Polled
	throw_exception->set_disp_level(Tango::OPERATOR);
	//	Not Memorized
	att_list.push_back(throw_exception);

	//	Attribute : uchar_scalar
	uchar_scalarAttrib	*uchar_scalar = new uchar_scalarAttrib();
	Tango::UserDefaultAttrProp	uchar_scalar_prop;
	//	description	not set for uchar_scalar
	uchar_scalar_prop.set_label("uchar_scalar");
	//	unit	not set for uchar_scalar
	//	standard_unit	not set for uchar_scalar
	//	display_unit	not set for uchar_scalar
	//	format	not set for uchar_scalar
	//	max_value	not set for uchar_scalar
	//	min_value	not set for uchar_scalar
	//	max_alarm	not set for uchar_scalar
	//	min_alarm	not set for uchar_scalar
	//	max_warning	not set for uchar_scalar
	//	min_warning	not set for uchar_scalar
	//	delta_t	not set for uchar_scalar
	//	delta_val	not set for uchar_scalar
	uchar_scalar->set_default_properties(uchar_scalar_prop);
	//	Not Polled
	uchar_scalar->set_disp_level(Tango::OPERATOR);
	//	Not Memorized
	att_list.push_back(uchar_scalar);

	//	Attribute : ulong64_scalar
	ulong64_scalarAttrib	*ulong64_scalar = new ulong64_scalarAttrib();
	Tango::UserDefaultAttrProp	ulong64_scalar_prop;
	//	description	not set for ulong64_scalar
	//	label	not set for ulong64_scalar
	//	unit	not set for ulong64_scalar
	//	standard_unit	not set for ulong64_scalar
	//	display_unit	not set for ulong64_scalar
	//	format	not set for ulong64_scalar
	//	max_value	not set for ulong64_scalar
	//	min_value	not set for ulong64_scalar
	//	max_alarm	not set for ulong64_scalar
	//	min_alarm	not set for ulong64_scalar
	//	max_warning	not set for ulong64_scalar
	//	min_warning	not set for ulong64_scalar
	//	delta_t	not set for ulong64_scalar
	//	delta_val	not set for ulong64_scalar
	ulong64_scalar->set_default_properties(ulong64_scalar_prop);
	//	Not Polled
	ulong64_scalar->set_disp_level(Tango::OPERATOR);
	//	Not Memorized
	att_list.push_back(ulong64_scalar);

	//	Attribute : ushort_scalar
	ushort_scalarAttrib	*ushort_scalar = new ushort_scalarAttrib();
	Tango::UserDefaultAttrProp	ushort_scalar_prop;
	//	description	not set for ushort_scalar
	ushort_scalar_prop.set_label("ushort_scalar");
	//	unit	not set for ushort_scalar
	//	standard_unit	not set for ushort_scalar
	//	display_unit	not set for ushort_scalar
	//	format	not set for ushort_scalar
	//	max_value	not set for ushort_scalar
	//	min_value	not set for ushort_scalar
	//	max_alarm	not set for ushort_scalar
	//	min_alarm	not set for ushort_scalar
	//	max_warning	not set for ushort_scalar
	//	min_warning	not set for ushort_scalar
	//	delta_t	not set for ushort_scalar
	//	delta_val	not set for ushort_scalar
	ushort_scalar->set_default_properties(ushort_scalar_prop);
	//	Not Polled
	ushort_scalar->set_disp_level(Tango::OPERATOR);
	//	Not Memorized
	att_list.push_back(ushort_scalar);

	//	Attribute : ulong_scalar
	ulong_scalarAttrib	*ulong_scalar = new ulong_scalarAttrib();
	Tango::UserDefaultAttrProp	ulong_scalar_prop;
	//	description	not set for ulong_scalar
	//	label	not set for ulong_scalar
	//	unit	not set for ulong_scalar
	//	standard_unit	not set for ulong_scalar
	//	display_unit	not set for ulong_scalar
	//	format	not set for ulong_scalar
	//	max_value	not set for ulong_scalar
	//	min_value	not set for ulong_scalar
	//	max_alarm	not set for ulong_scalar
	//	min_alarm	not set for ulong_scalar
	//	max_warning	not set for ulong_scalar
	//	min_warning	not set for ulong_scalar
	//	delta_t	not set for ulong_scalar
	//	delta_val	not set for ulong_scalar
	ulong_scalar->set_default_properties(ulong_scalar_prop);
	//	Not Polled
	ulong_scalar->set_disp_level(Tango::OPERATOR);
	//	Not Memorized
	att_list.push_back(ulong_scalar);

	//	Attribute : enum_scalar
	enum_scalarAttrib	*enum_scalar = new enum_scalarAttrib();
	Tango::UserDefaultAttrProp	enum_scalar_prop;
	//	description	not set for enum_scalar
	//	label	not set for enum_scalar
	//	unit	not set for enum_scalar
	//	standard_unit	not set for enum_scalar
	//	display_unit	not set for enum_scalar
	//	format	not set for enum_scalar
	//	max_value	not set for enum_scalar
	//	min_value	not set for enum_scalar
	//	max_alarm	not set for enum_scalar
	//	min_alarm	not set for enum_scalar
	//	max_warning	not set for enum_scalar
	//	min_warning	not set for enum_scalar
	//	delta_t	not set for enum_scalar
	//	delta_val	not set for enum_scalar
	{
		std::vector<std::string> labels;
		labels.push_back("LABEL0");
		labels.push_back("LABEL1");
		labels.push_back("LABEL2");
		enum_scalar_prop.set_enum_labels(labels);
	}
	enum_scalar->set_default_properties(enum_scalar_prop);
	//	Not Polled
	enum_scalar->set_disp_level(Tango::OPERATOR);
	//	Not Memorized
	att_list.push_back(enum_scalar);

	//	Attribute : freq
	freqAttrib	*freq = new freqAttrib();
	Tango::UserDefaultAttrProp	freq_prop;
	//	description	not set for freq
	//	label	not set for freq
	//	unit	not set for freq
	//	standard_unit	not set for freq
	//	display_unit	not set for freq
	//	format	not set for freq
	//	max_value	not set for freq
	//	min_value	not set for freq
	//	max_alarm	not set for freq
	//	min_alarm	not set for freq
	//	max_warning	not set for freq
	//	min_warning	not set for freq
	//	delta_t	not set for freq
	//	delta_val	not set for freq
	freq->set_default_properties(freq_prop);
	//	Not Polled
	freq->set_disp_level(Tango::OPERATOR);
	//	Not Memorized
	att_list.push_back(freq);

	//	Attribute : enum_scalar_ro
	enum_scalar_roAttrib	*enum_scalar_ro = new enum_scalar_roAttrib();
	Tango::UserDefaultAttrProp	enum_scalar_ro_prop;
	//	description	not set for enum_scalar_ro
	//	label	not set for enum_scalar_ro
	//	unit	not set for enum_scalar_ro
	//	standard_unit	not set for enum_scalar_ro
	//	display_unit	not set for enum_scalar_ro
	//	format	not set for enum_scalar_ro
	//	max_value	not set for enum_scalar_ro
	//	min_value	not set for enum_scalar_ro
	//	max_alarm	not set for enum_scalar_ro
	//	min_alarm	not set for enum_scalar_ro
	//	max_warning	not set for enum_scalar_ro
	//	min_warning	not set for enum_scalar_ro
	//	delta_t	not set for enum_scalar_ro
	//	delta_val	not set for enum_scalar_ro
	{
		std::vector<std::string> labels;
		labels.push_back("LABEL3");
		labels.push_back("LABEL4");
		labels.push_back("LABEL5");
		enum_scalar_ro_prop.set_enum_labels(labels);
	}
	enum_scalar_ro->set_default_properties(enum_scalar_ro_prop);
	//	Not Polled
	enum_scalar_ro->set_disp_level(Tango::OPERATOR);
	//	Not Memorized
	att_list.push_back(enum_scalar_ro);

	//	Attribute : echo_mode
	echo_modeAttrib	*echo_mode = new echo_modeAttrib();
	Tango::UserDefaultAttrProp	echo_mode_prop;
	//	description	not set for echo_mode
	//	label	not set for echo_mode
	//	unit	not set for echo_mode
	//	standard_unit	not set for echo_mode
	//	display_unit	not set for echo_mode
	//	format	not set for echo_mode
	//	max_value	not set for echo_mode
	//	min_value	not set for echo_mode
	//	max_alarm	not set for echo_mode
	//	min_alarm	not set for echo_mode
	//	max_warning	not set for echo_mode
	//	min_warning	not set for echo_mode
	//	delta_t	not set for echo_mode
	//	delta_val	not set for echo_mode
	echo_mode->set_default_properties(echo_mode_prop);
	//	Not Polled
	echo_mode->set_disp_level(Tango::OPERATOR);
	//	Not Memorized
	att_list.push_back(echo_mode);

	//	Attribute : boolean_spectrum
	boolean_spectrumAttrib	*boolean_spectrum = new boolean_spectrumAttrib();
	Tango::UserDefaultAttrProp	boolean_spectrum_prop;
	//	description	not set for boolean_spectrum
	boolean_spectrum_prop.set_label("boolean_spectrum");
	//	unit	not set for boolean_spectrum
	//	standard_unit	not set for boolean_spectrum
	//	display_unit	not set for boolean_spectrum
	//	format	not set for boolean_spectrum
	//	max_value	not set for boolean_spectrum
	//	min_value	not set for boolean_spectrum
	//	max_alarm	not set for boolean_spectrum
	//	min_alarm	not set for boolean_spectrum
	//	max_warning	not set for boolean_spectrum
	//	min_warning	not set for boolean_spectrum
	//	delta_t	not set for boolean_spectrum
	//	delta_val	not set for boolean_spectrum
	boolean_spectrum->set_default_properties(boolean_spectrum_prop);
	//	Not Polled
	boolean_spectrum->set_disp_level(Tango::OPERATOR);
	//	Not Memorized
	att_list.push_back(boolean_spectrum);

	//	Attribute : boolean_spectrum_ro
	boolean_spectrum_roAttrib	*boolean_spectrum_ro = new boolean_spectrum_roAttrib();
	Tango::UserDefaultAttrProp	boolean_spectrum_ro_prop;
	//	description	not set for boolean_spectrum_ro
	//	label	not set for boolean_spectrum_ro
	//	unit	not set for boolean_spectrum_ro
	//	standard_unit	not set for boolean_spectrum_ro
	//	display_unit	not set for boolean_spectrum_ro
	//	format	not set for boolean_spectrum_ro
	//	max_value	not set for boolean_spectrum_ro
	//	min_value	not set for boolean_spectrum_ro
	//	max_alarm	not set for boolean_spectrum_ro
	//	min_alarm	not set for boolean_spectrum_ro
	//	max_warning	not set for boolean_spectrum_ro
	//	min_warning	not set for boolean_spectrum_ro
	//	delta_t	not set for boolean_spectrum_ro
	//	delta_val	not set for boolean_spectrum_ro
	boolean_spectrum_ro->set_default_properties(boolean_spectrum_ro_prop);
	//	Not Polled
	boolean_spectrum_ro->set_disp_level(Tango::OPERATOR);
	//	Not Memorized
	att_list.push_back(boolean_spectrum_ro);

	//	Attribute : double_spectrum
	double_spectrumAttrib	*double_spectrum = new double_spectrumAttrib();
	Tango::UserDefaultAttrProp	double_spectrum_prop;
	//	description	not set for double_spectrum
	//	label	not set for double_spectrum
	//	unit	not set for double_spectrum
	//	standard_unit	not set for double_spectrum
	//	display_unit	not set for double_spectrum
	//	format	not set for double_spectrum
	//	max_value	not set for double_spectrum
	//	min_value	not set for double_spectrum
	//	max_alarm	not set for double_spectrum
	//	min_alarm	not set for double_spectrum
	//	max_warning	not set for double_spectrum
	//	min_warning	not set for double_spectrum
	//	delta_t	not set for double_spectrum
	//	delta_val	not set for double_spectrum
	double_spectrum->set_default_properties(double_spectrum_prop);
	//	Not Polled
	double_spectrum->set_disp_level(Tango::OPERATOR);
	//	Not Memorized
	att_list.push_back(double_spectrum);

	//	Attribute : double_spectrum_ro
	double_spectrum_roAttrib	*double_spectrum_ro = new double_spectrum_roAttrib();
	Tango::UserDefaultAttrProp	double_spectrum_ro_prop;
	//	description	not set for double_spectrum_ro
	//	label	not set for double_spectrum_ro
	//	unit	not set for double_spectrum_ro
	//	standard_unit	not set for double_spectrum_ro
	//	display_unit	not set for double_spectrum_ro
	//	format	not set for double_spectrum_ro
	//	max_value	not set for double_spectrum_ro
	//	min_value	not set for double_spectrum_ro
	//	max_alarm	not set for double_spectrum_ro
	//	min_alarm	not set for double_spectrum_ro
	//	max_warning	not set for double_spectrum_ro
	//	min_warning	not set for double_spectrum_ro
	//	delta_t	not set for double_spectrum_ro
	//	delta_val	not set for double_spectrum_ro
	double_spectrum_ro->set_default_properties(double_spectrum_ro_prop);
	//	Not Polled
	double_spectrum_ro->set_disp_level(Tango::OPERATOR);
	//	Not Memorized
	att_list.push_back(double_spectrum_ro);

	//	Attribute : float_spectrum
	float_spectrumAttrib	*float_spectrum = new float_spectrumAttrib();
	Tango::UserDefaultAttrProp	float_spectrum_prop;
	float_spectrum_prop.set_description("A float spectrum attribute");
	float_spectrum_prop.set_label("float_spectrum");
	//	unit	not set for float_spectrum
	//	standard_unit	not set for float_spectrum
	//	display_unit	not set for float_spectrum
	//	format	not set for float_spectrum
	//	max_value	not set for float_spectrum
	//	min_value	not set for float_spectrum
	//	max_alarm	not set for float_spectrum
	//	min_alarm	not set for float_spectrum
	//	max_warning	not set for float_spectrum
	//	min_warning	not set for float_spectrum
	//	delta_t	not set for float_spectrum
	//	delta_val	not set for float_spectrum
	float_spectrum->set_default_properties(float_spectrum_prop);
	//	Not Polled
	float_spectrum->set_disp_level(Tango::OPERATOR);
	//	Not Memorized
	att_list.push_back(float_spectrum);

	//	Attribute : float_spectrum_ro
	float_spectrum_roAttrib	*float_spectrum_ro = new float_spectrum_roAttrib();
	Tango::UserDefaultAttrProp	float_spectrum_ro_prop;
	//	description	not set for float_spectrum_ro
	//	label	not set for float_spectrum_ro
	//	unit	not set for float_spectrum_ro
	//	standard_unit	not set for float_spectrum_ro
	//	display_unit	not set for float_spectrum_ro
	//	format	not set for float_spectrum_ro
	//	max_value	not set for float_spectrum_ro
	//	min_value	not set for float_spectrum_ro
	//	max_alarm	not set for float_spectrum_ro
	//	min_alarm	not set for float_spectrum_ro
	//	max_warning	not set for float_spectrum_ro
	//	min_warning	not set for float_spectrum_ro
	//	delta_t	not set for float_spectrum_ro
	//	delta_val	not set for float_spectrum_ro
	float_spectrum_ro->set_default_properties(float_spectrum_ro_prop);
	//	Not Polled
	float_spectrum_ro->set_disp_level(Tango::OPERATOR);
	//	Not Memorized
	att_list.push_back(float_spectrum_ro);

	//	Attribute : long64_spectrum_ro
	long64_spectrum_roAttrib	*long64_spectrum_ro = new long64_spectrum_roAttrib();
	Tango::UserDefaultAttrProp	long64_spectrum_ro_prop;
	//	description	not set for long64_spectrum_ro
	//	label	not set for long64_spectrum_ro
	//	unit	not set for long64_spectrum_ro
	//	standard_unit	not set for long64_spectrum_ro
	//	display_unit	not set for long64_spectrum_ro
	//	format	not set for long64_spectrum_ro
	//	max_value	not set for long64_spectrum_ro
	//	min_value	not set for long64_spectrum_ro
	//	max_alarm	not set for long64_spectrum_ro
	//	min_alarm	not set for long64_spectrum_ro
	//	max_warning	not set for long64_spectrum_ro
	//	min_warning	not set for long64_spectrum_ro
	//	delta_t	not set for long64_spectrum_ro
	//	delta_val	not set for long64_spectrum_ro
	long64_spectrum_ro->set_default_properties(long64_spectrum_ro_prop);
	//	Not Polled
	long64_spectrum_ro->set_disp_level(Tango::OPERATOR);
	//	Not Memorized
	att_list.push_back(long64_spectrum_ro);

	//	Attribute : long_spectrum
	long_spectrumAttrib	*long_spectrum = new long_spectrumAttrib();
	Tango::UserDefaultAttrProp	long_spectrum_prop;
	//	description	not set for long_spectrum
	//	label	not set for long_spectrum
	//	unit	not set for long_spectrum
	//	standard_unit	not set for long_spectrum
	//	display_unit	not set for long_spectrum
	//	format	not set for long_spectrum
	//	max_value	not set for long_spectrum
	//	min_value	not set for long_spectrum
	//	max_alarm	not set for long_spectrum
	//	min_alarm	not set for long_spectrum
	//	max_warning	not set for long_spectrum
	//	min_warning	not set for long_spectrum
	//	delta_t	not set for long_spectrum
	//	delta_val	not set for long_spectrum
	long_spectrum->set_default_properties(long_spectrum_prop);
	//	Not Polled
	long_spectrum->set_disp_level(Tango::OPERATOR);
	//	Not Memorized
	att_list.push_back(long_spectrum);

	//	Attribute : long_spectrum_ro
	long_spectrum_roAttrib	*long_spectrum_ro = new long_spectrum_roAttrib();
	Tango::UserDefaultAttrProp	long_spectrum_ro_prop;
	//	description	not set for long_spectrum_ro
	//	label	not set for long_spectrum_ro
	//	unit	not set for long_spectrum_ro
	//	standard_unit	not set for long_spectrum_ro
	//	display_unit	not set for long_spectrum_ro
	//	format	not set for long_spectrum_ro
	//	max_value	not set for long_spectrum_ro
	//	min_value	not set for long_spectrum_ro
	//	max_alarm	not set for long_spectrum_ro
	//	min_alarm	not set for long_spectrum_ro
	//	max_warning	not set for long_spectrum_ro
	//	min_warning	not set for long_spectrum_ro
	//	delta_t	not set for long_spectrum_ro
	//	delta_val	not set for long_spectrum_ro
	long_spectrum_ro->set_default_properties(long_spectrum_ro_prop);
	//	Not Polled
	long_spectrum_ro->set_disp_level(Tango::OPERATOR);
	//	Not Memorized
	att_list.push_back(long_spectrum_ro);

	//	Attribute : short_spectrum
	short_spectrumAttrib	*short_spectrum = new short_spectrumAttrib();
	Tango::UserDefaultAttrProp	short_spectrum_prop;
	//	description	not set for short_spectrum
	//	label	not set for short_spectrum
	//	unit	not set for short_spectrum
	//	standard_unit	not set for short_spectrum
	//	display_unit	not set for short_spectrum
	//	format	not set for short_spectrum
	//	max_value	not set for short_spectrum
	//	min_value	not set for short_spectrum
	//	max_alarm	not set for short_spectrum
	//	min_alarm	not set for short_spectrum
	//	max_warning	not set for short_spectrum
	//	min_warning	not set for short_spectrum
	//	delta_t	not set for short_spectrum
	//	delta_val	not set for short_spectrum
	short_spectrum->set_default_properties(short_spectrum_prop);
	//	Not Polled
	short_spectrum->set_disp_level(Tango::OPERATOR);
	//	Not Memorized
	att_list.push_back(short_spectrum);

	//	Attribute : short_spectrum_ro
	short_spectrum_roAttrib	*short_spectrum_ro = new short_spectrum_roAttrib();
	Tango::UserDefaultAttrProp	short_spectrum_ro_prop;
	//	description	not set for short_spectrum_ro
	//	label	not set for short_spectrum_ro
	//	unit	not set for short_spectrum_ro
	//	standard_unit	not set for short_spectrum_ro
	//	display_unit	not set for short_spectrum_ro
	//	format	not set for short_spectrum_ro
	//	max_value	not set for short_spectrum_ro
	//	min_value	not set for short_spectrum_ro
	//	max_alarm	not set for short_spectrum_ro
	//	min_alarm	not set for short_spectrum_ro
	//	max_warning	not set for short_spectrum_ro
	//	min_warning	not set for short_spectrum_ro
	//	delta_t	not set for short_spectrum_ro
	//	delta_val	not set for short_spectrum_ro
	short_spectrum_ro->set_default_properties(short_spectrum_ro_prop);
	//	Not Polled
	short_spectrum_ro->set_disp_level(Tango::OPERATOR);
	//	Not Memorized
	att_list.push_back(short_spectrum_ro);

	//	Attribute : string_spectrum
	string_spectrumAttrib	*string_spectrum = new string_spectrumAttrib();
	Tango::UserDefaultAttrProp	string_spectrum_prop;
	//	description	not set for string_spectrum
	//	label	not set for string_spectrum
	//	unit	not set for string_spectrum
	//	standard_unit	not set for string_spectrum
	//	display_unit	not set for string_spectrum
	//	format	not set for string_spectrum
	//	max_value	not set for string_spectrum
	//	min_value	not set for string_spectrum
	//	max_alarm	not set for string_spectrum
	//	min_alarm	not set for string_spectrum
	//	max_warning	not set for string_spectrum
	//	min_warning	not set for string_spectrum
	//	delta_t	not set for string_spectrum
	//	delta_val	not set for string_spectrum
	string_spectrum->set_default_properties(string_spectrum_prop);
	//	Not Polled
	string_spectrum->set_disp_level(Tango::OPERATOR);
	//	Not Memorized
	att_list.push_back(string_spectrum);

	//	Attribute : string_spectrum_ro
	string_spectrum_roAttrib	*string_spectrum_ro = new string_spectrum_roAttrib();
	Tango::UserDefaultAttrProp	string_spectrum_ro_prop;
	//	description	not set for string_spectrum_ro
	//	label	not set for string_spectrum_ro
	//	unit	not set for string_spectrum_ro
	//	standard_unit	not set for string_spectrum_ro
	//	display_unit	not set for string_spectrum_ro
	//	format	not set for string_spectrum_ro
	//	max_value	not set for string_spectrum_ro
	//	min_value	not set for string_spectrum_ro
	//	max_alarm	not set for string_spectrum_ro
	//	min_alarm	not set for string_spectrum_ro
	//	max_warning	not set for string_spectrum_ro
	//	min_warning	not set for string_spectrum_ro
	//	delta_t	not set for string_spectrum_ro
	//	delta_val	not set for string_spectrum_ro
	string_spectrum_ro->set_default_properties(string_spectrum_ro_prop);
	//	Not Polled
	string_spectrum_ro->set_disp_level(Tango::OPERATOR);
	//	Not Memorized
	att_list.push_back(string_spectrum_ro);

	//	Attribute : uchar_spectrum
	uchar_spectrumAttrib	*uchar_spectrum = new uchar_spectrumAttrib();
	Tango::UserDefaultAttrProp	uchar_spectrum_prop;
	uchar_spectrum_prop.set_description("An unsigned char spectrum attribute");
	uchar_spectrum_prop.set_label("uchar_spectrum");
	//	unit	not set for uchar_spectrum
	//	standard_unit	not set for uchar_spectrum
	//	display_unit	not set for uchar_spectrum
	//	format	not set for uchar_spectrum
	uchar_spectrum_prop.set_max_value("255");
	uchar_spectrum_prop.set_min_value("0");
	//	max_alarm	not set for uchar_spectrum
	//	min_alarm	not set for uchar_spectrum
	//	max_warning	not set for uchar_spectrum
	//	min_warning	not set for uchar_spectrum
	//	delta_t	not set for uchar_spectrum
	//	delta_val	not set for uchar_spectrum
	uchar_spectrum->set_default_properties(uchar_spectrum_prop);
	//	Not Polled
	uchar_spectrum->set_disp_level(Tango::OPERATOR);
	//	Not Memorized
	att_list.push_back(uchar_spectrum);

	//	Attribute : uchar_spectrum_ro
	uchar_spectrum_roAttrib	*uchar_spectrum_ro = new uchar_spectrum_roAttrib();
	Tango::UserDefaultAttrProp	uchar_spectrum_ro_prop;
	//	description	not set for uchar_spectrum_ro
	//	label	not set for uchar_spectrum_ro
	//	unit	not set for uchar_spectrum_ro
	//	standard_unit	not set for uchar_spectrum_ro
	//	display_unit	not set for uchar_spectrum_ro
	//	format	not set for uchar_spectrum_ro
	//	max_value	not set for uchar_spectrum_ro
	//	min_value	not set for uchar_spectrum_ro
	//	max_alarm	not set for uchar_spectrum_ro
	//	min_alarm	not set for uchar_spectrum_ro
	//	max_warning	not set for uchar_spectrum_ro
	//	min_warning	not set for uchar_spectrum_ro
	//	delta_t	not set for uchar_spectrum_ro
	//	delta_val	not set for uchar_spectrum_ro
	uchar_spectrum_ro->set_default_properties(uchar_spectrum_ro_prop);
	//	Not Polled
	uchar_spectrum_ro->set_disp_level(Tango::OPERATOR);
	//	Not Memorized
	att_list.push_back(uchar_spectrum_ro);

	//	Attribute : ulong64_spectrum_ro
	ulong64_spectrum_roAttrib	*ulong64_spectrum_ro = new ulong64_spectrum_roAttrib();
	Tango::UserDefaultAttrProp	ulong64_spectrum_ro_prop;
	//	description	not set for ulong64_spectrum_ro
	//	label	not set for ulong64_spectrum_ro
	//	unit	not set for ulong64_spectrum_ro
	//	standard_unit	not set for ulong64_spectrum_ro
	//	display_unit	not set for ulong64_spectrum_ro
	//	format	not set for ulong64_spectrum_ro
	//	max_value	not set for ulong64_spectrum_ro
	//	min_value	not set for ulong64_spectrum_ro
	//	max_alarm	not set for ulong64_spectrum_ro
	//	min_alarm	not set for ulong64_spectrum_ro
	//	max_warning	not set for ulong64_spectrum_ro
	//	min_warning	not set for ulong64_spectrum_ro
	//	delta_t	not set for ulong64_spectrum_ro
	//	delta_val	not set for ulong64_spectrum_ro
	ulong64_spectrum_ro->set_default_properties(ulong64_spectrum_ro_prop);
	//	Not Polled
	ulong64_spectrum_ro->set_disp_level(Tango::OPERATOR);
	//	Not Memorized
	att_list.push_back(ulong64_spectrum_ro);

	//	Attribute : ulong_spectrum_ro
	ulong_spectrum_roAttrib	*ulong_spectrum_ro = new ulong_spectrum_roAttrib();
	Tango::UserDefaultAttrProp	ulong_spectrum_ro_prop;
	//	description	not set for ulong_spectrum_ro
	//	label	not set for ulong_spectrum_ro
	//	unit	not set for ulong_spectrum_ro
	//	standard_unit	not set for ulong_spectrum_ro
	//	display_unit	not set for ulong_spectrum_ro
	//	format	not set for ulong_spectrum_ro
	//	max_value	not set for ulong_spectrum_ro
	//	min_value	not set for ulong_spectrum_ro
	//	max_alarm	not set for ulong_spectrum_ro
	//	min_alarm	not set for ulong_spectrum_ro
	//	max_warning	not set for ulong_spectrum_ro
	//	min_warning	not set for ulong_spectrum_ro
	//	delta_t	not set for ulong_spectrum_ro
	//	delta_val	not set for ulong_spectrum_ro
	ulong_spectrum_ro->set_default_properties(ulong_spectrum_ro_prop);
	//	Not Polled
	ulong_spectrum_ro->set_disp_level(Tango::OPERATOR);
	//	Not Memorized
	att_list.push_back(ulong_spectrum_ro);

	//	Attribute : ushort_spectrum
	ushort_spectrumAttrib	*ushort_spectrum = new ushort_spectrumAttrib();
	Tango::UserDefaultAttrProp	ushort_spectrum_prop;
	ushort_spectrum_prop.set_description("An unsigned short spectrum attribute");
	ushort_spectrum_prop.set_label("ushort_spectrum");
	//	unit	not set for ushort_spectrum
	//	standard_unit	not set for ushort_spectrum
	//	display_unit	not set for ushort_spectrum
	//	format	not set for ushort_spectrum
	//	max_value	not set for ushort_spectrum
	//	min_value	not set for ushort_spectrum
	//	max_alarm	not set for ushort_spectrum
	//	min_alarm	not set for ushort_spectrum
	//	max_warning	not set for ushort_spectrum
	//	min_warning	not set for ushort_spectrum
	//	delta_t	not set for ushort_spectrum
	//	delta_val	not set for ushort_spectrum
	ushort_spectrum->set_default_properties(ushort_spectrum_prop);
	//	Not Polled
	ushort_spectrum->set_disp_level(Tango::OPERATOR);
	//	Not Memorized
	att_list.push_back(ushort_spectrum);

	//	Attribute : ushort_spectrum_ro
	ushort_spectrum_roAttrib	*ushort_spectrum_ro = new ushort_spectrum_roAttrib();
	Tango::UserDefaultAttrProp	ushort_spectrum_ro_prop;
	//	description	not set for ushort_spectrum_ro
	//	label	not set for ushort_spectrum_ro
	//	unit	not set for ushort_spectrum_ro
	//	standard_unit	not set for ushort_spectrum_ro
	//	display_unit	not set for ushort_spectrum_ro
	//	format	not set for ushort_spectrum_ro
	//	max_value	not set for ushort_spectrum_ro
	//	min_value	not set for ushort_spectrum_ro
	//	max_alarm	not set for ushort_spectrum_ro
	//	min_alarm	not set for ushort_spectrum_ro
	//	max_warning	not set for ushort_spectrum_ro
	//	min_warning	not set for ushort_spectrum_ro
	//	delta_t	not set for ushort_spectrum_ro
	//	delta_val	not set for ushort_spectrum_ro
	ushort_spectrum_ro->set_default_properties(ushort_spectrum_ro_prop);
	//	Not Polled
	ushort_spectrum_ro->set_disp_level(Tango::OPERATOR);
	//	Not Memorized
	att_list.push_back(ushort_spectrum_ro);

	//	Attribute : wave
	waveAttrib	*wave = new waveAttrib();
	Tango::UserDefaultAttrProp	wave_prop;
	//	description	not set for wave
	//	label	not set for wave
	//	unit	not set for wave
	//	standard_unit	not set for wave
	//	display_unit	not set for wave
	//	format	not set for wave
	//	max_value	not set for wave
	//	min_value	not set for wave
	//	max_alarm	not set for wave
	//	min_alarm	not set for wave
	//	max_warning	not set for wave
	//	min_warning	not set for wave
	//	delta_t	not set for wave
	//	delta_val	not set for wave
	wave->set_default_properties(wave_prop);
	//	Not Polled
	wave->set_disp_level(Tango::OPERATOR);
	//	Not Memorized
	att_list.push_back(wave);

	//	Attribute : enum_spectrum
	enum_spectrumAttrib	*enum_spectrum = new enum_spectrumAttrib();
	Tango::UserDefaultAttrProp	enum_spectrum_prop;
	//	description	not set for enum_spectrum
	//	label	not set for enum_spectrum
	//	unit	not set for enum_spectrum
	//	standard_unit	not set for enum_spectrum
	//	display_unit	not set for enum_spectrum
	//	format	not set for enum_spectrum
	//	max_value	not set for enum_spectrum
	//	min_value	not set for enum_spectrum
	//	max_alarm	not set for enum_spectrum
	//	min_alarm	not set for enum_spectrum
	//	max_warning	not set for enum_spectrum
	//	min_warning	not set for enum_spectrum
	//	delta_t	not set for enum_spectrum
	//	delta_val	not set for enum_spectrum
	{
		std::vector<std::string> labels;
		labels.push_back("LABEL6");
		labels.push_back("LABEL7");
		labels.push_back("LABEL8");
		enum_spectrum_prop.set_enum_labels(labels);
	}
	enum_spectrum->set_default_properties(enum_spectrum_prop);
	//	Not Polled
	enum_spectrum->set_disp_level(Tango::OPERATOR);
	//	Not Memorized
	att_list.push_back(enum_spectrum);

	//	Attribute : enum_spectrum_ro
	enum_spectrum_roAttrib	*enum_spectrum_ro = new enum_spectrum_roAttrib();
	Tango::UserDefaultAttrProp	enum_spectrum_ro_prop;
	//	description	not set for enum_spectrum_ro
	//	label	not set for enum_spectrum_ro
	//	unit	not set for enum_spectrum_ro
	//	standard_unit	not set for enum_spectrum_ro
	//	display_unit	not set for enum_spectrum_ro
	//	format	not set for enum_spectrum_ro
	//	max_value	not set for enum_spectrum_ro
	//	min_value	not set for enum_spectrum_ro
	//	max_alarm	not set for enum_spectrum_ro
	//	min_alarm	not set for enum_spectrum_ro
	//	max_warning	not set for enum_spectrum_ro
	//	min_warning	not set for enum_spectrum_ro
	//	delta_t	not set for enum_spectrum_ro
	//	delta_val	not set for enum_spectrum_ro
	{
		std::vector<std::string> labels;
		labels.push_back("LABEL9");
		labels.push_back("LABEL10");
		labels.push_back("LABEL11");
		enum_spectrum_ro_prop.set_enum_labels(labels);
	}
	enum_spectrum_ro->set_default_properties(enum_spectrum_ro_prop);
	//	Not Polled
	enum_spectrum_ro->set_disp_level(Tango::OPERATOR);
	//	Not Memorized
	att_list.push_back(enum_spectrum_ro);

	//	Attribute : boolean_image
	boolean_imageAttrib	*boolean_image = new boolean_imageAttrib();
	Tango::UserDefaultAttrProp	boolean_image_prop;
	//	description	not set for boolean_image
	//	label	not set for boolean_image
	//	unit	not set for boolean_image
	//	standard_unit	not set for boolean_image
	//	display_unit	not set for boolean_image
	//	format	not set for boolean_image
	//	max_value	not set for boolean_image
	//	min_value	not set for boolean_image
	//	max_alarm	not set for boolean_image
	//	min_alarm	not set for boolean_image
	//	max_warning	not set for boolean_image
	//	min_warning	not set for boolean_image
	//	delta_t	not set for boolean_image
	//	delta_val	not set for boolean_image
	boolean_image->set_default_properties(boolean_image_prop);
	//	Not Polled
	boolean_image->set_disp_level(Tango::OPERATOR);
	//	Not Memorized
	att_list.push_back(boolean_image);

	//	Attribute : boolean_image_ro
	boolean_image_roAttrib	*boolean_image_ro = new boolean_image_roAttrib();
	Tango::UserDefaultAttrProp	boolean_image_ro_prop;
	//	description	not set for boolean_image_ro
	boolean_image_ro_prop.set_label("boolean_image");
	//	unit	not set for boolean_image_ro
	//	standard_unit	not set for boolean_image_ro
	//	display_unit	not set for boolean_image_ro
	//	format	not set for boolean_image_ro
	//	max_value	not set for boolean_image_ro
	//	min_value	not set for boolean_image_ro
	//	max_alarm	not set for boolean_image_ro
	//	min_alarm	not set for boolean_image_ro
	//	max_warning	not set for boolean_image_ro
	//	min_warning	not set for boolean_image_ro
	//	delta_t	not set for boolean_image_ro
	//	delta_val	not set for boolean_image_ro
	boolean_image_ro->set_default_properties(boolean_image_ro_prop);
	//	Not Polled
	boolean_image_ro->set_disp_level(Tango::OPERATOR);
	//	Not Memorized
	att_list.push_back(boolean_image_ro);

	//	Attribute : double_image
	double_imageAttrib	*double_image = new double_imageAttrib();
	Tango::UserDefaultAttrProp	double_image_prop;
	//	description	not set for double_image
	//	label	not set for double_image
	//	unit	not set for double_image
	//	standard_unit	not set for double_image
	//	display_unit	not set for double_image
	//	format	not set for double_image
	//	max_value	not set for double_image
	//	min_value	not set for double_image
	//	max_alarm	not set for double_image
	//	min_alarm	not set for double_image
	//	max_warning	not set for double_image
	//	min_warning	not set for double_image
	//	delta_t	not set for double_image
	//	delta_val	not set for double_image
	double_image->set_default_properties(double_image_prop);
	//	Not Polled
	double_image->set_disp_level(Tango::OPERATOR);
	//	Not Memorized
	att_list.push_back(double_image);

	//	Attribute : double_image_ro
	double_image_roAttrib	*double_image_ro = new double_image_roAttrib();
	Tango::UserDefaultAttrProp	double_image_ro_prop;
	//	description	not set for double_image_ro
	//	label	not set for double_image_ro
	//	unit	not set for double_image_ro
	//	standard_unit	not set for double_image_ro
	//	display_unit	not set for double_image_ro
	//	format	not set for double_image_ro
	//	max_value	not set for double_image_ro
	//	min_value	not set for double_image_ro
	//	max_alarm	not set for double_image_ro
	//	min_alarm	not set for double_image_ro
	//	max_warning	not set for double_image_ro
	//	min_warning	not set for double_image_ro
	//	delta_t	not set for double_image_ro
	//	delta_val	not set for double_image_ro
	double_image_ro->set_default_properties(double_image_ro_prop);
	//	Not Polled
	double_image_ro->set_disp_level(Tango::OPERATOR);
	//	Not Memorized
	att_list.push_back(double_image_ro);

	//	Attribute : float_image
	float_imageAttrib	*float_image = new float_imageAttrib();
	Tango::UserDefaultAttrProp	float_image_prop;
	//	description	not set for float_image
	//	label	not set for float_image
	//	unit	not set for float_image
	//	standard_unit	not set for float_image
	//	display_unit	not set for float_image
	//	format	not set for float_image
	//	max_value	not set for float_image
	//	min_value	not set for float_image
	//	max_alarm	not set for float_image
	//	min_alarm	not set for float_image
	//	max_warning	not set for float_image
	//	min_warning	not set for float_image
	//	delta_t	not set for float_image
	//	delta_val	not set for float_image
	float_image->set_default_properties(float_image_prop);
	//	Not Polled
	float_image->set_disp_level(Tango::OPERATOR);
	//	Not Memorized
	att_list.push_back(float_image);

	//	Attribute : float_image_ro
	float_image_roAttrib	*float_image_ro = new float_image_roAttrib();
	Tango::UserDefaultAttrProp	float_image_ro_prop;
	float_image_ro_prop.set_description("A float image attribute");
	float_image_ro_prop.set_label("float_image");
	//	unit	not set for float_image_ro
	//	standard_unit	not set for float_image_ro
	//	display_unit	not set for float_image_ro
	//	format	not set for float_image_ro
	float_image_ro_prop.set_max_value("255");
	float_image_ro_prop.set_min_value("0");
	//	max_alarm	not set for float_image_ro
	//	min_alarm	not set for float_image_ro
	//	max_warning	not set for float_image_ro
	//	min_warning	not set for float_image_ro
	//	delta_t	not set for float_image_ro
	//	delta_val	not set for float_image_ro
	float_image_ro->set_default_properties(float_image_ro_prop);
	//	Not Polled
	float_image_ro->set_disp_level(Tango::OPERATOR);
	//	Not Memorized
	att_list.push_back(float_image_ro);

	//	Attribute : long64_image_ro
	long64_image_roAttrib	*long64_image_ro = new long64_image_roAttrib();
	Tango::UserDefaultAttrProp	long64_image_ro_prop;
	//	description	not set for long64_image_ro
	//	label	not set for long64_image_ro
	//	unit	not set for long64_image_ro
	//	standard_unit	not set for long64_image_ro
	//	display_unit	not set for long64_image_ro
	//	format	not set for long64_image_ro
	//	max_value	not set for long64_image_ro
	//	min_value	not set for long64_image_ro
	//	max_alarm	not set for long64_image_ro
	//	min_alarm	not set for long64_image_ro
	//	max_warning	not set for long64_image_ro
	//	min_warning	not set for long64_image_ro
	//	delta_t	not set for long64_image_ro
	//	delta_val	not set for long64_image_ro
	long64_image_ro->set_default_properties(long64_image_ro_prop);
	//	Not Polled
	long64_image_ro->set_disp_level(Tango::OPERATOR);
	//	Not Memorized
	att_list.push_back(long64_image_ro);

	//	Attribute : long_image
	long_imageAttrib	*long_image = new long_imageAttrib();
	Tango::UserDefaultAttrProp	long_image_prop;
	//	description	not set for long_image
	//	label	not set for long_image
	//	unit	not set for long_image
	//	standard_unit	not set for long_image
	//	display_unit	not set for long_image
	//	format	not set for long_image
	//	max_value	not set for long_image
	//	min_value	not set for long_image
	//	max_alarm	not set for long_image
	//	min_alarm	not set for long_image
	//	max_warning	not set for long_image
	//	min_warning	not set for long_image
	//	delta_t	not set for long_image
	//	delta_val	not set for long_image
	long_image->set_default_properties(long_image_prop);
	//	Not Polled
	long_image->set_disp_level(Tango::OPERATOR);
	//	Not Memorized
	att_list.push_back(long_image);

	//	Attribute : long_image_ro
	long_image_roAttrib	*long_image_ro = new long_image_roAttrib();
	Tango::UserDefaultAttrProp	long_image_ro_prop;
	//	description	not set for long_image_ro
	//	label	not set for long_image_ro
	//	unit	not set for long_image_ro
	//	standard_unit	not set for long_image_ro
	//	display_unit	not set for long_image_ro
	//	format	not set for long_image_ro
	//	max_value	not set for long_image_ro
	//	min_value	not set for long_image_ro
	//	max_alarm	not set for long_image_ro
	//	min_alarm	not set for long_image_ro
	//	max_warning	not set for long_image_ro
	//	min_warning	not set for long_image_ro
	//	delta_t	not set for long_image_ro
	//	delta_val	not set for long_image_ro
	long_image_ro->set_default_properties(long_image_ro_prop);
	//	Not Polled
	long_image_ro->set_disp_level(Tango::OPERATOR);
	//	Not Memorized
	att_list.push_back(long_image_ro);

	//	Attribute : short_image
	short_imageAttrib	*short_image = new short_imageAttrib();
	Tango::UserDefaultAttrProp	short_image_prop;
	//	description	not set for short_image
	//	label	not set for short_image
	//	unit	not set for short_image
	//	standard_unit	not set for short_image
	//	display_unit	not set for short_image
	//	format	not set for short_image
	//	max_value	not set for short_image
	//	min_value	not set for short_image
	//	max_alarm	not set for short_image
	//	min_alarm	not set for short_image
	//	max_warning	not set for short_image
	//	min_warning	not set for short_image
	//	delta_t	not set for short_image
	//	delta_val	not set for short_image
	short_image->set_default_properties(short_image_prop);
	//	Not Polled
	short_image->set_disp_level(Tango::OPERATOR);
	//	Not Memorized
	att_list.push_back(short_image);

	//	Attribute : short_image_ro
	short_image_roAttrib	*short_image_ro = new short_image_roAttrib();
	Tango::UserDefaultAttrProp	short_image_ro_prop;
	//	description	not set for short_image_ro
	//	label	not set for short_image_ro
	//	unit	not set for short_image_ro
	//	standard_unit	not set for short_image_ro
	//	display_unit	not set for short_image_ro
	//	format	not set for short_image_ro
	//	max_value	not set for short_image_ro
	//	min_value	not set for short_image_ro
	//	max_alarm	not set for short_image_ro
	//	min_alarm	not set for short_image_ro
	//	max_warning	not set for short_image_ro
	//	min_warning	not set for short_image_ro
	//	delta_t	not set for short_image_ro
	//	delta_val	not set for short_image_ro
	short_image_ro->set_default_properties(short_image_ro_prop);
	//	Not Polled
	short_image_ro->set_disp_level(Tango::OPERATOR);
	//	Not Memorized
	att_list.push_back(short_image_ro);

	//	Attribute : string_image
	string_imageAttrib	*string_image = new string_imageAttrib();
	Tango::UserDefaultAttrProp	string_image_prop;
	//	description	not set for string_image
	//	label	not set for string_image
	//	unit	not set for string_image
	//	standard_unit	not set for string_image
	//	display_unit	not set for string_image
	//	format	not set for string_image
	//	max_value	not set for string_image
	//	min_value	not set for string_image
	//	max_alarm	not set for string_image
	//	min_alarm	not set for string_image
	//	max_warning	not set for string_image
	//	min_warning	not set for string_image
	//	delta_t	not set for string_image
	//	delta_val	not set for string_image
	string_image->set_default_properties(string_image_prop);
	//	Not Polled
	string_image->set_disp_level(Tango::OPERATOR);
	//	Not Memorized
	att_list.push_back(string_image);

	//	Attribute : string_image_ro
	string_image_roAttrib	*string_image_ro = new string_image_roAttrib();
	Tango::UserDefaultAttrProp	string_image_ro_prop;
	//	description	not set for string_image_ro
	//	label	not set for string_image_ro
	//	unit	not set for string_image_ro
	//	standard_unit	not set for string_image_ro
	//	display_unit	not set for string_image_ro
	//	format	not set for string_image_ro
	//	max_value	not set for string_image_ro
	//	min_value	not set for string_image_ro
	//	max_alarm	not set for string_image_ro
	//	min_alarm	not set for string_image_ro
	//	max_warning	not set for string_image_ro
	//	min_warning	not set for string_image_ro
	//	delta_t	not set for string_image_ro
	//	delta_val	not set for string_image_ro
	string_image_ro->set_default_properties(string_image_ro_prop);
	//	Not Polled
	string_image_ro->set_disp_level(Tango::OPERATOR);
	//	Not Memorized
	att_list.push_back(string_image_ro);

	//	Attribute : uchar_image
	uchar_imageAttrib	*uchar_image = new uchar_imageAttrib();
	Tango::UserDefaultAttrProp	uchar_image_prop;
	//	description	not set for uchar_image
	//	label	not set for uchar_image
	//	unit	not set for uchar_image
	//	standard_unit	not set for uchar_image
	//	display_unit	not set for uchar_image
	//	format	not set for uchar_image
	//	max_value	not set for uchar_image
	//	min_value	not set for uchar_image
	//	max_alarm	not set for uchar_image
	//	min_alarm	not set for uchar_image
	//	max_warning	not set for uchar_image
	//	min_warning	not set for uchar_image
	//	delta_t	not set for uchar_image
	//	delta_val	not set for uchar_image
	uchar_image->set_default_properties(uchar_image_prop);
	//	Not Polled
	uchar_image->set_disp_level(Tango::OPERATOR);
	//	Not Memorized
	att_list.push_back(uchar_image);

	//	Attribute : uchar_image_ro
	uchar_image_roAttrib	*uchar_image_ro = new uchar_image_roAttrib();
	Tango::UserDefaultAttrProp	uchar_image_ro_prop;
	uchar_image_ro_prop.set_description("An unsigned char image attribute");
	uchar_image_ro_prop.set_label("uchar_image");
	//	unit	not set for uchar_image_ro
	//	standard_unit	not set for uchar_image_ro
	//	display_unit	not set for uchar_image_ro
	//	format	not set for uchar_image_ro
	uchar_image_ro_prop.set_max_value("255");
	uchar_image_ro_prop.set_min_value("0");
	//	max_alarm	not set for uchar_image_ro
	//	min_alarm	not set for uchar_image_ro
	//	max_warning	not set for uchar_image_ro
	//	min_warning	not set for uchar_image_ro
	//	delta_t	not set for uchar_image_ro
	//	delta_val	not set for uchar_image_ro
	uchar_image_ro->set_default_properties(uchar_image_ro_prop);
	//	Not Polled
	uchar_image_ro->set_disp_level(Tango::OPERATOR);
	//	Not Memorized
	att_list.push_back(uchar_image_ro);

	//	Attribute : ulong64_image_ro
	ulong64_image_roAttrib	*ulong64_image_ro = new ulong64_image_roAttrib();
	Tango::UserDefaultAttrProp	ulong64_image_ro_prop;
	//	description	not set for ulong64_image_ro
	//	label	not set for ulong64_image_ro
	//	unit	not set for ulong64_image_ro
	//	standard_unit	not set for ulong64_image_ro
	//	display_unit	not set for ulong64_image_ro
	//	format	not set for ulong64_image_ro
	//	max_value	not set for ulong64_image_ro
	//	min_value	not set for ulong64_image_ro
	//	max_alarm	not set for ulong64_image_ro
	//	min_alarm	not set for ulong64_image_ro
	//	max_warning	not set for ulong64_image_ro
	//	min_warning	not set for ulong64_image_ro
	//	delta_t	not set for ulong64_image_ro
	//	delta_val	not set for ulong64_image_ro
	ulong64_image_ro->set_default_properties(ulong64_image_ro_prop);
	//	Not Polled
	ulong64_image_ro->set_disp_level(Tango::OPERATOR);
	//	Not Memorized
	att_list.push_back(ulong64_image_ro);

	//	Attribute : ulong_image_ro
	ulong_image_roAttrib	*ulong_image_ro = new ulong_image_roAttrib();
	Tango::UserDefaultAttrProp	ulong_image_ro_prop;
	//	description	not set for ulong_image_ro
	//	label	not set for ulong_image_ro
	//	unit	not set for ulong_image_ro
	//	standard_unit	not set for ulong_image_ro
	//	display_unit	not set for ulong_image_ro
	//	format	not set for ulong_image_ro
	//	max_value	not set for ulong_image_ro
	//	min_value	not set for ulong_image_ro
	//	max_alarm	not set for ulong_image_ro
	//	min_alarm	not set for ulong_image_ro
	//	max_warning	not set for ulong_image_ro
	//	min_warning	not set for ulong_image_ro
	//	delta_t	not set for ulong_image_ro
	//	delta_val	not set for ulong_image_ro
	ulong_image_ro->set_default_properties(ulong_image_ro_prop);
	//	Not Polled
	ulong_image_ro->set_disp_level(Tango::OPERATOR);
	//	Not Memorized
	att_list.push_back(ulong_image_ro);

	//	Attribute : ushort_image
	ushort_imageAttrib	*ushort_image = new ushort_imageAttrib();
	Tango::UserDefaultAttrProp	ushort_image_prop;
	//	description	not set for ushort_image
	//	label	not set for ushort_image
	//	unit	not set for ushort_image
	//	standard_unit	not set for ushort_image
	//	display_unit	not set for ushort_image
	//	format	not set for ushort_image
	//	max_value	not set for ushort_image
	//	min_value	not set for ushort_image
	//	max_alarm	not set for ushort_image
	//	min_alarm	not set for ushort_image
	//	max_warning	not set for ushort_image
	//	min_warning	not set for ushort_image
	//	delta_t	not set for ushort_image
	//	delta_val	not set for ushort_image
	ushort_image->set_default_properties(ushort_image_prop);
	//	Not Polled
	ushort_image->set_disp_level(Tango::OPERATOR);
	//	Not Memorized
	att_list.push_back(ushort_image);

	//	Attribute : ushort_image_ro
	ushort_image_roAttrib	*ushort_image_ro = new ushort_image_roAttrib();
	Tango::UserDefaultAttrProp	ushort_image_ro_prop;
	ushort_image_ro_prop.set_description("An unsigned short image attribute");
	ushort_image_ro_prop.set_label("ushort_image_ro");
	//	unit	not set for ushort_image_ro
	//	standard_unit	not set for ushort_image_ro
	//	display_unit	not set for ushort_image_ro
	//	format	not set for ushort_image_ro
	ushort_image_ro_prop.set_max_value("255");
	ushort_image_ro_prop.set_min_value("0");
	//	max_alarm	not set for ushort_image_ro
	//	min_alarm	not set for ushort_image_ro
	//	max_warning	not set for ushort_image_ro
	//	min_warning	not set for ushort_image_ro
	//	delta_t	not set for ushort_image_ro
	//	delta_val	not set for ushort_image_ro
	ushort_image_ro->set_default_properties(ushort_image_ro_prop);
	//	Not Polled
	ushort_image_ro->set_disp_level(Tango::OPERATOR);
	//	Not Memorized
	att_list.push_back(ushort_image_ro);

	//	Attribute : enum_image_ro
	enum_image_roAttrib	*enum_image_ro = new enum_image_roAttrib();
	Tango::UserDefaultAttrProp	enum_image_ro_prop;
	//	description	not set for enum_image_ro
	//	label	not set for enum_image_ro
	//	unit	not set for enum_image_ro
	//	standard_unit	not set for enum_image_ro
	//	display_unit	not set for enum_image_ro
	//	format	not set for enum_image_ro
	//	max_value	not set for enum_image_ro
	//	min_value	not set for enum_image_ro
	//	max_alarm	not set for enum_image_ro
	//	min_alarm	not set for enum_image_ro
	//	max_warning	not set for enum_image_ro
	//	min_warning	not set for enum_image_ro
	//	delta_t	not set for enum_image_ro
	//	delta_val	not set for enum_image_ro
	{
		std::vector<std::string> labels;
		labels.push_back("LABEL12");
		labels.push_back("LABEL13");
		labels.push_back("LABEL14");
		enum_image_ro_prop.set_enum_labels(labels);
	}
	enum_image_ro->set_default_properties(enum_image_ro_prop);
	//	Not Polled
	enum_image_ro->set_disp_level(Tango::OPERATOR);
	//	Not Memorized
	att_list.push_back(enum_image_ro);

	//	Attribute : enum_image
	enum_imageAttrib	*enum_image = new enum_imageAttrib();
	Tango::UserDefaultAttrProp	enum_image_prop;
	//	description	not set for enum_image
	//	label	not set for enum_image
	//	unit	not set for enum_image
	//	standard_unit	not set for enum_image
	//	display_unit	not set for enum_image
	//	format	not set for enum_image
	//	max_value	not set for enum_image
	//	min_value	not set for enum_image
	//	max_alarm	not set for enum_image
	//	min_alarm	not set for enum_image
	//	max_warning	not set for enum_image
	//	min_warning	not set for enum_image
	//	delta_t	not set for enum_image
	//	delta_val	not set for enum_image
	{
		std::vector<std::string> labels;
		labels.push_back("LABEL15");
		labels.push_back("LABEL16");
		labels.push_back("LABEL17");
		enum_image_prop.set_enum_labels(labels);
	}
	enum_image->set_default_properties(enum_image_prop);
	//	Not Polled
	enum_image->set_disp_level(Tango::OPERATOR);
	//	Not Memorized
	att_list.push_back(enum_image);


	//	Create a list of static attributes
	create_static_attribute_list(get_class_attr()->get_attr_list());
	/*----- PROTECTED REGION ID(TangoTestClass::attribute_factory_after) ENABLED START -----*/
	
	//	Add your own code
	
	/*----- PROTECTED REGION END -----*/	//	TangoTestClass::attribute_factory_after
}
//--------------------------------------------------------
/**
 *	Method     : TangoTestClass::pipe_factory()
 *	Description: Create the pipe object(s)
 *                and store them in the pipe list
 */
//--------------------------------------------------------
void TangoTestClass::pipe_factory()
{
	/*----- PROTECTED REGION ID(TangoTestClass::pipe_factory_before) ENABLED START -----*/
	
	//	Add your own code
	
	/*----- PROTECTED REGION END -----*/	//	TangoTestClass::pipe_factory_before
	Tango::UserDefaultPipeProp udpp;
	string_long_short_roClass	*pstring_long_short_ro = new string_long_short_roClass("string_long_short_ro",Tango::OPERATOR);
	udpp.set_description("Pipe example");
	udpp.set_label("");
	pstring_long_short_ro->set_default_properties(udpp);
	pipe_list.push_back(pstring_long_short_ro);

	generic_blob_rwClass	*pgeneric_blob_rw = new generic_blob_rwClass("generic_blob_rw",Tango::OPERATOR);
	udpp.set_description("Pipe to write and read dynamic data structure");
	udpp.set_label("");
	pgeneric_blob_rw->set_default_properties(udpp);
	pipe_list.push_back(pgeneric_blob_rw);

	/*----- PROTECTED REGION ID(TangoTestClass::pipe_factory_after) ENABLED START -----*/
	
	//	Add your own code
	
	/*----- PROTECTED REGION END -----*/	//	TangoTestClass::pipe_factory_after
}
//--------------------------------------------------------
/**
 *	Method     : TangoTestClass::command_factory()
 *	Description: Create the command object(s)
 *                and store them in the command list
 */
//--------------------------------------------------------
void TangoTestClass::command_factory()
{
	/*----- PROTECTED REGION ID(TangoTestClass::command_factory_before) ENABLED START -----*/
	
	//	Add your own code
	
	/*----- PROTECTED REGION END -----*/	//	TangoTestClass::command_factory_before


	//	Command CrashFromDevelopperThread
	CrashFromDevelopperThreadClass	*pCrashFromDevelopperThreadCmd =
		new CrashFromDevelopperThreadClass("CrashFromDevelopperThread",
			Tango::DEV_VOID, Tango::DEV_VOID,
			"",
			"",
			Tango::EXPERT);
	command_list.push_back(pCrashFromDevelopperThreadCmd);

	//	Command CrashFromOmniThread
	CrashFromOmniThreadClass	*pCrashFromOmniThreadCmd =
		new CrashFromOmniThreadClass("CrashFromOmniThread",
			Tango::DEV_VOID, Tango::DEV_VOID,
			"",
			"",
			Tango::EXPERT);
	command_list.push_back(pCrashFromOmniThreadCmd);

	//	Command DevBoolean
	DevBooleanClass	*pDevBooleanCmd =
		new DevBooleanClass("DevBoolean",
			Tango::DEV_BOOLEAN, Tango::DEV_BOOLEAN,
			"Any boolean value",
			"Echo of the argin value",
			Tango::OPERATOR);
	command_list.push_back(pDevBooleanCmd);

	//	Command DevDouble
	DevDoubleClass	*pDevDoubleCmd =
		new DevDoubleClass("DevDouble",
			Tango::DEV_DOUBLE, Tango::DEV_DOUBLE,
			"Any DevDouble value",
			"Echo of the argin value",
			Tango::OPERATOR);
	command_list.push_back(pDevDoubleCmd);

	//	Command DevFloat
	DevFloatClass	*pDevFloatCmd =
		new DevFloatClass("DevFloat",
			Tango::DEV_FLOAT, Tango::DEV_FLOAT,
			"Any DevFloat value",
			"Echo of the argin value",
			Tango::OPERATOR);
	command_list.push_back(pDevFloatCmd);

	//	Command DevLong
	DevLongClass	*pDevLongCmd =
		new DevLongClass("DevLong",
			Tango::DEV_LONG, Tango::DEV_LONG,
			"Any DevLong value",
			"Echo of the argin value",
			Tango::OPERATOR);
	command_list.push_back(pDevLongCmd);

	//	Command DevLong64
	DevLong64Class	*pDevLong64Cmd =
		new DevLong64Class("DevLong64",
			Tango::DEV_LONG64, Tango::DEV_LONG64,
			"Any DevLong64 value",
			"Echo of the argin value",
			Tango::OPERATOR);
	command_list.push_back(pDevLong64Cmd);

	//	Command DevShort
	DevShortClass	*pDevShortCmd =
		new DevShortClass("DevShort",
			Tango::DEV_SHORT, Tango::DEV_SHORT,
			"Any DevShort value",
			"Echo of the argin value",
			Tango::OPERATOR);
	command_list.push_back(pDevShortCmd);

	//	Command DevString
	DevStringClass	*pDevStringCmd =
		new DevStringClass("DevString",
			Tango::DEV_STRING, Tango::DEV_STRING,
			"-",
			"-",
			Tango::OPERATOR);
	command_list.push_back(pDevStringCmd);

	//	Command DevULong
	DevULongClass	*pDevULongCmd =
		new DevULongClass("DevULong",
			Tango::DEV_ULONG, Tango::DEV_ULONG,
			"Any DevULong",
			"Echo of the argin value",
			Tango::OPERATOR);
	command_list.push_back(pDevULongCmd);

	//	Command DevULong64
	DevULong64Class	*pDevULong64Cmd =
		new DevULong64Class("DevULong64",
			Tango::DEV_ULONG64, Tango::DEV_ULONG64,
			"Any DevULong64 value",
			"Echo of the argin value",
			Tango::OPERATOR);
	command_list.push_back(pDevULong64Cmd);

	//	Command DevUShort
	DevUShortClass	*pDevUShortCmd =
		new DevUShortClass("DevUShort",
			Tango::DEV_USHORT, Tango::DEV_USHORT,
			"Any DevUShort value",
			"Echo of the argin value",
			Tango::OPERATOR);
	command_list.push_back(pDevUShortCmd);

	//	Command DevVarCharArray
	DevVarCharArrayClass	*pDevVarCharArrayCmd =
		new DevVarCharArrayClass("DevVarCharArray",
			Tango::DEVVAR_CHARARRAY, Tango::DEVVAR_CHARARRAY,
			"-",
			"-",
			Tango::OPERATOR);
	command_list.push_back(pDevVarCharArrayCmd);

	//	Command DevVarDoubleArray
	DevVarDoubleArrayClass	*pDevVarDoubleArrayCmd =
		new DevVarDoubleArrayClass("DevVarDoubleArray",
			Tango::DEVVAR_DOUBLEARRAY, Tango::DEVVAR_DOUBLEARRAY,
			"-",
			"-",
			Tango::OPERATOR);
	command_list.push_back(pDevVarDoubleArrayCmd);

	//	Command DevVarDoubleStringArray
	DevVarDoubleStringArrayClass	*pDevVarDoubleStringArrayCmd =
		new DevVarDoubleStringArrayClass("DevVarDoubleStringArray",
			Tango::DEVVAR_DOUBLESTRINGARRAY, Tango::DEVVAR_DOUBLESTRINGARRAY,
			"-",
			"-",
			Tango::OPERATOR);
	command_list.push_back(pDevVarDoubleStringArrayCmd);

	//	Command DevVarFloatArray
	DevVarFloatArrayClass	*pDevVarFloatArrayCmd =
		new DevVarFloatArrayClass("DevVarFloatArray",
			Tango::DEVVAR_FLOATARRAY, Tango::DEVVAR_FLOATARRAY,
			"-",
			"-",
			Tango::OPERATOR);
	command_list.push_back(pDevVarFloatArrayCmd);

	//	Command DevVarLong64Array
	DevVarLong64ArrayClass	*pDevVarLong64ArrayCmd =
		new DevVarLong64ArrayClass("DevVarLong64Array",
			Tango::DEVVAR_LONG64ARRAY, Tango::DEVVAR_LONG64ARRAY,
			"",
			"",
			Tango::OPERATOR);
	command_list.push_back(pDevVarLong64ArrayCmd);

	//	Command DevVarLongArray
	DevVarLongArrayClass	*pDevVarLongArrayCmd =
		new DevVarLongArrayClass("DevVarLongArray",
			Tango::DEVVAR_LONGARRAY, Tango::DEVVAR_LONGARRAY,
			"-",
			"-",
			Tango::OPERATOR);
	command_list.push_back(pDevVarLongArrayCmd);

	//	Command DevVarLongStringArray
	DevVarLongStringArrayClass	*pDevVarLongStringArrayCmd =
		new DevVarLongStringArrayClass("DevVarLongStringArray",
			Tango::DEVVAR_LONGSTRINGARRAY, Tango::DEVVAR_LONGSTRINGARRAY,
			"-",
			"-",
			Tango::OPERATOR);
	command_list.push_back(pDevVarLongStringArrayCmd);

	//	Command DevVarShortArray
	DevVarShortArrayClass	*pDevVarShortArrayCmd =
		new DevVarShortArrayClass("DevVarShortArray",
			Tango::DEVVAR_SHORTARRAY, Tango::DEVVAR_SHORTARRAY,
			"-",
			"-",
			Tango::OPERATOR);
	command_list.push_back(pDevVarShortArrayCmd);

	//	Command DevVarStringArray
	DevVarStringArrayClass	*pDevVarStringArrayCmd =
		new DevVarStringArrayClass("DevVarStringArray",
			Tango::DEVVAR_STRINGARRAY, Tango::DEVVAR_STRINGARRAY,
			"-",
			"-",
			Tango::OPERATOR);
	command_list.push_back(pDevVarStringArrayCmd);

	//	Command DevVarULong64Array
	DevVarULong64ArrayClass	*pDevVarULong64ArrayCmd =
		new DevVarULong64ArrayClass("DevVarULong64Array",
			Tango::DEVVAR_ULONG64ARRAY, Tango::DEVVAR_ULONG64ARRAY,
			"",
			"",
			Tango::OPERATOR);
	command_list.push_back(pDevVarULong64ArrayCmd);

	//	Command DevVarULongArray
	DevVarULongArrayClass	*pDevVarULongArrayCmd =
		new DevVarULongArrayClass("DevVarULongArray",
			Tango::DEVVAR_ULONGARRAY, Tango::DEVVAR_ULONGARRAY,
			"-",
			"-",
			Tango::OPERATOR);
	command_list.push_back(pDevVarULongArrayCmd);

	//	Command DevVarUShortArray
	DevVarUShortArrayClass	*pDevVarUShortArrayCmd =
		new DevVarUShortArrayClass("DevVarUShortArray",
			Tango::DEVVAR_USHORTARRAY, Tango::DEVVAR_USHORTARRAY,
			"-",
			"-",
			Tango::OPERATOR);
	command_list.push_back(pDevVarUShortArrayCmd);

	//	Command DevVoid
	DevVoidClass	*pDevVoidCmd =
		new DevVoidClass("DevVoid",
			Tango::DEV_VOID, Tango::DEV_VOID,
			"N/A",
			"N/A",
			Tango::OPERATOR);
	command_list.push_back(pDevVoidCmd);

	//	Command DumpExecutionState
	DumpExecutionStateClass	*pDumpExecutionStateCmd =
		new DumpExecutionStateClass("DumpExecutionState",
			Tango::DEV_VOID, Tango::DEV_VOID,
			"",
			"",
			Tango::EXPERT);
	command_list.push_back(pDumpExecutionStateCmd);

	//	Command SwitchStates
	SwitchStatesClass	*pSwitchStatesCmd =
		new SwitchStatesClass("SwitchStates",
			Tango::DEV_VOID, Tango::DEV_VOID,
			"",
			"",
			Tango::OPERATOR);
	command_list.push_back(pSwitchStatesCmd);

	/*----- PROTECTED REGION ID(TangoTestClass::command_factory_after) ENABLED START -----*/
	
	//	Add your own code
	
	/*----- PROTECTED REGION END -----*/	//	TangoTestClass::command_factory_after
}

//===================================================================
//	Dynamic attributes related methods
//===================================================================

//--------------------------------------------------------
/**
 * method : 		TangoTestClass::create_static_attribute_list
 * description : 	Create the a list of static attributes
 *
 * @param	att_list	the created attribute list
 */
//--------------------------------------------------------
void TangoTestClass::create_static_attribute_list(std::vector<Tango::Attr *> &att_list)
{
	for (unsigned long i=0 ; i<att_list.size() ; i++)
	{
		std::string att_name(att_list[i]->get_name());
		std::transform(att_name.begin(), att_name.end(), att_name.begin(), ::tolower);
		defaultAttList.push_back(att_name);
	}

	TANGO_LOG_INFO << defaultAttList.size() << " attributes in default list" << std::endl;

	/*----- PROTECTED REGION ID(TangoTestClass::create_static_att_list) ENABLED START -----*/
	
	/*----- PROTECTED REGION END -----*/	//	TangoTestClass::create_static_att_list
}


//--------------------------------------------------------
/**
 * method : 		TangoTestClass::erase_dynamic_attributes
 * description : 	delete the dynamic attributes if any.
 *
 * @param	devlist_ptr	the device list pointer
 * @param	list of all attributes
 */
//--------------------------------------------------------
void TangoTestClass::erase_dynamic_attributes(const Tango::DevVarStringArray *devlist_ptr, std::vector<Tango::Attr *> &att_list)
{
	Tango::Util *tg = Tango::Util::instance();

	for (unsigned long i=0 ; i<devlist_ptr->length() ; i++)
	{
		Tango::DeviceImpl *dev_impl = tg->get_device_by_name(((std::string)(*devlist_ptr)[i]).c_str());
		TangoTest *dev = static_cast<TangoTest *> (dev_impl);

		std::vector<Tango::Attribute *> &dev_att_list = dev->get_device_attr()->get_attribute_list();
		std::vector<Tango::Attribute *>::iterator ite_att;
		for (ite_att=dev_att_list.begin() ; ite_att != dev_att_list.end() ; ++ite_att)
		{
			std::string att_name((*ite_att)->get_name_lower());
			if ((att_name == "state") || (att_name == "status"))
				continue;
			std::vector<std::string>::iterator ite_str = find(defaultAttList.begin(), defaultAttList.end(), att_name);
			if (ite_str == defaultAttList.end())
			{
				TANGO_LOG_INFO << att_name << " is a UNWANTED dynamic attribute for device " << (*devlist_ptr)[i] << std::endl;
				Tango::Attribute &att = dev->get_device_attr()->get_attr_by_name(att_name.c_str());
				dev->remove_attribute(att_list[att.get_attr_idx()], true, false);
				--ite_att;
			}
		}
	}
	/*----- PROTECTED REGION ID(TangoTestClass::erase_dynamic_attributes) ENABLED START -----*/
	
	/*----- PROTECTED REGION END -----*/	//	TangoTestClass::erase_dynamic_attributes
}

//--------------------------------------------------------
/**
 *	Method     : TangoTestClass::get_attr_object_by_name()
 *	Description: returns Tango::Attr * object found by name
 */
//--------------------------------------------------------
Tango::Attr *TangoTestClass::get_attr_object_by_name(std::vector<Tango::Attr *> &att_list, std::string attname)
{
	std::vector<Tango::Attr *>::iterator it;
	for (it=att_list.begin() ; it<att_list.end() ; ++it)
		if ((*it)->get_name()==attname)
			return (*it);
	//	Attr does not exist
	return NULL;
}


/*----- PROTECTED REGION ID(TangoTestClass::Additional Methods) ENABLED START -----*/

/*----- PROTECTED REGION END -----*/	//	TangoTestClass::Additional Methods
} //	namespace
