[section {ToC serialization format}]

Here we specify the format used by the doctools v2 packages to
serialize tables of contents as immutable values for transport,
comparison, etc.

[para]

We distinguish between [term regular] and [term canonical]
serializations.

While a table of contents may have more than one regular serialization
only exactly one of them will be [term canonical].

[para]

[list_begin definitions][comment {-- serializations --}]
[def {regular serialization}]

[list_begin enumerated][comment {-- regular points --}]
[enum]
The serialization of any table of contents is a nested Tcl dictionary.

[enum]
This dictionary holds a single key, [const doctools::toc], and its
value. This value holds the contents of the table of contents.

[enum]

The contents of the table of contents are a Tcl dictionary holding the
title of the table of contents, a label, and its elements. The
relevant keys and their values are

[list_begin definitions][comment {-- keywords --}]
[def [const title]]
The value is a string containing the title of the table of contents.

[def [const label]]
The value is a string containing a label for the table of contents.

[def [const items]]
The value is a Tcl list holding the elements of the table, in the
order they are to be shown.

[para]
Each element is a Tcl list holding the type of the item, and its
description, in this order. An alternative description would be that
it is a Tcl dictionary holding a single key, the item type, mapped to
the item description.

[para]
The two legal item types and their descriptions are

[list_begin definitions][comment {-- item types --}]
[def [const reference]]
This item describes a single entry in the table of contents,
referencing a single document.

To this end its value is a Tcl dictionary containing an id for the
referenced document, a label, and a longer textual description which
can be associated with the entry.

The relevant keys and their values are

[list_begin definitions][comment {-- reference keywords --}]
[def [const id]]
The value is a string containing the id of the document associated
with the entry.

[def [const label]]
The value is a string containing a label for this entry. This string
also identifies the entry, and no two entries (references and
divisions) in the containing list are allowed to have the same label.

[def [const desc]]
The value is a string containing a longer description for this entry.

[list_end][comment {-- reference keywords --}]


[def [const division]]
This item describes a group of entries in the table of contents,
inducing a hierarchy of entries.

To this end its value is a Tcl dictionary containing a label for the
group, an optional id to a document for the whole group, and the list
of entries in the group.

The relevant keys and their values are

[list_begin definitions][comment {-- division keywords --}]
[def [const id]]
The value is a string containing the id of the document associated
with the whole group. This key is optional.

[def [const label]]
The value is a string containing a label for the group. This string
also identifies the entry, and no two entries (references and
divisions) in the containing list are allowed to have the same label.

[def [const items]]
The value is a Tcl list holding the elements of the group, in the
order they are to be shown.

This list has the same structure as the value for the keyword
[const items] used to describe the whole table of contents, see
above. This closes the recusrive definition of the structure, with
divisions holding the same type of elements as the whole table of
contents, including other divisions.

[list_end][comment {-- division keywords --}]
[list_end][comment {-- item types --}]
[list_end][comment {-- keywords --}]
[list_end][comment {-- regular points --}]

[def {canonical serialization}]

The canonical serialization of a table of contents has the format as
specified in the previous item, and then additionally satisfies the
constraints below, which make it unique among all the possible
serializations of this table of contents.

[list_begin enumerated][comment {-- canonical points --}]
[enum]

The keys found in all the nested Tcl dictionaries are sorted in
ascending dictionary order, as generated by Tcl's builtin command
[cmd {lsort -increasing -dict}].

[list_end][comment {-- canonical points --}]
[list_end][comment {-- serializations --}]
