#!/usr/bin/python

##
## Copyright (C) 2011-2012 Andrew Atkinson
##
##-------------------------------------------------------------------
## This program is free software: you can redistribute it and/or modify
## it under the terms of the GNU General Public License as published by
## the Free Software Foundation, either version 3 of the License, or
## (at your option) any later version.
##
## This program is distributed in the hope that it will be useful,
## but WITHOUT ANY WARRANTY; without even the implied warranty of
## MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
## GNU General Public License for more details.
##
## You should have received a copy of the GNU General Public License
## along with this program.  If not, see <http://www.gnu.org/licenses/>.
##-------------------------------------------------------------------

import codecs
import errno
import os
import shlex
import subprocess
import wx


def Structure(dir):
    """makes directories selected in Struct"""

    #Start with the Survey Dir
    try:
        os.makedirs(dir)
    except OSError as e:
        if e.errno == errno.EEXIST:
            pass
        else:
            print('Something went wrong trying to create:\n' + dir)
            raise


def CreateFile(fname, fcontents, overwrite, add2rep, repostype):
    createfile = overwrite | (not(os.path.exists(fname)))
    name = os.path.basename(fname)
    if not createfile:
        message = name + ''' already exists.
Would you like to overwrite.
(No, will skip the file)'''
        dlg = wx.MessageDialog(None, message, 'Existing file',
                               style=wx.YES_NO)
        temp = dlg.ShowModal()
        if temp == wx.ID_YES:
            createfile = True
        else:
            print('Not written file ' + name)
        dlg.Destroy()
    if createfile:
        with codecs.open(fname, encoding='utf8', mode='w') as finalfile:
            finalfile.write(fcontents.getvalue())
            print('Written file ' + name)
            if add2rep:
                command = repostype + ' add \"' + fname + '\"'
                ShellCall(command)
    return


def ShellCall(command, cwd=None):
    '''Calls the terminal command and pipes the output to the wx window'''
    output = subprocess.Popen(command, shell=True,
                                stdout=subprocess.PIPE,
                                stderr=subprocess.PIPE,
                                universal_newlines=True,
                                cwd=cwd)
    out, err = output.communicate()
    if out:
        print(str(out))
    if err:
        print(str(err))
