/*****************************************************************************

    libTRAVIS - Class library for trajectory analysis and visualization

    Copyright (C) 2015-2021 Martin Thomas

    This program is free software: you can redistribute it and/or modify
    it under the terms of the GNU General Public License as published by
    the Free Software Foundation, either version 3 of the License, or
    (at your option) any later version.

    This program is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
    GNU General Public License for more details.

    You should have received a copy of the GNU General Public License
    along with this program.  If not, see <http://www.gnu.org/licenses/>.

*****************************************************************************/


#ifndef LT_ELEMENT_H
#define LT_ELEMENT_H


#include "../config.h"


#ifdef NEW_CHARGEVAR


#include "vector.h"

#include <stdexcept>
#include <string>

namespace Libtravis {

namespace Travis {

struct Element
{
	unsigned int atomicNumber;
	std::string name;
	double mass;
	double covalentRadius;
	double vdWRadius;
};

namespace Elements {

class UnknownElement : public std::runtime_error
{
public:
	UnknownElement() : std::runtime_error("Elements: Element not known") {}
};

const Element &findElement(unsigned int atomicNumber);
const Element &findElement(const std::string &name);

}

}

}

#endif

#endif


