(*
    Tux Commander - UTranslation_EN - English Localization constants
    Copyright (C) 2008 Tomas Bzatek <tbzatek@users.sourceforge.net>
    Check for updates on tuxcmd.sourceforge.net

    This program is free software; you can redistribute it and/or modify
    it under the terms of the GNU General Public License as published by
    the Free Software Foundation; either version 2 of the License, or
    (at your option) any later version.

    This program is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
    GNU General Public License for more details.

    You should have received a copy of the GNU General Public License
    along with this program; if not, write to the Free Software
    Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
*)
unit UTranslation_EN;

(***************************************************************************
 * Info for translators:
     - please use UTF-8 encoding when making translations, the whole GTK+ 2
       is using it to display non-ASCII characters properly
     - please change the few lines at the bottom of this file to your
       locale string (e.g. en_US for English translation)
***************************************************************************)

interface

implementation

uses ULocale;

const LANGenF2Button_Caption = 'F2 - Rename';
      LANGenF3Button_Caption = 'F3 - View';
      LANGenF4Button_Caption = 'F4 - Edit';
      LANGenF5Button_Caption = 'F5 - Copy';
      LANGenF6Button_Caption = 'F6 - Move';
      LANGenF7Button_Caption = 'F7 - MkDir';
      LANGenF8Button_Caption = 'F8 - Delete';

      LANGenmnuFile_Caption = '_File';
      LANGenmnuMark_Caption = '_Mark';
      LANGenmnuCommands_Caption = '_Commands';
      LANGenmnuHelp_Caption = '_Help';
      LANGenmiExit_Caption = 'E_xit';
      LANGenmiSelectGroup_Caption = 'Select _Group...';
      LANGenmiUnselectGroup_Caption = '_Unselect Group...';
      LANGenmiSelectAll_Caption = '_Select All';
      LANGenmiUnselectAll_Caption = 'U_nselect All';
      LANGenmiInvertSelection_Caption = '_Invert Selection';
      LANGenmiRefresh_Caption = '_Refresh';
      LANGenmiAbout_Caption = '_About...';

      LANGenColumn1_Caption = 'Name';
      LANGenColumn2_Caption = 'Ext';
      LANGenColumn3_Caption = 'Size';
      LANGenColumn4_Caption = 'Date';
      LANGenColumn5_Caption = 'Attr';

      LANGenExpandSelection = 'Expand selection';
      LANGenShrinkSelection = 'Shrink selection';
      LANGenNoMatchesFound = 'No matches found';
      LANGenNoFilesSelected = 'No files selected!';
      LANGenSelectedFilesDirectories = '%d selected files/directories';
      LANGenDirectoryS = 'directory %s';
      LANGenFileS = 'file %s';
      LANGenDoYouReallyWantToDeleteTheS = 'Do you really want to delete the %s ?';
      LANGenDoYouReallyWantToDeleteTheSS = 'Do you really want to delete the %s ?'#10'%s';
      LANGenCopyFiles = 'Copy files';
      LANGenMoveRenameFiles = 'Move/Rename files';
      LANGenCopyDFileDirectoriesTo = 'Copy %d file/directories to';
      LANGenMoveRenameDFileDirectoriesTo = 'Move/Rename %d file/directories to';
      LANGenCopySC = 'Copy:';
      LANGenMoveRenameSC = 'Move/Rename:';

      LANGenQuickFind = '  Quick Find:';

      LANGenAboutString = 'Tux Commander'#10'Version %s'#10'Build date: %s'#10#10'Copyright (c) 2009 Tomas Bzatek'#10'E-mail: tbzatek@users.sourceforge.net'#10'Website: http://tuxcmd.sourceforge.net/';
      LANGenAboutStringGnome = 'version %s'#10'Build date: %s'#10'Website: http://tuxcmd.sourceforge.net/';
      LANGenDiskStatFmt = '%s of %s free';
//      LANGenDiskStatFmt = '<span weight="bold">%s</span> of <span weight="bold">%s</span> free';
      LANGenDiskStatVolNameFmt = '[%s]  %s of %s free';
//      LANGenDiskStatVolNameFmt = '[%s]  <span weight="bold">%s</span> of <span weight="bold">%s</span> free';
//      LANGenDiskStatVolNameFmt = '<span style="italic">[%s]</span> <span weight="bold">%s</span> of <span weight="bold">%s</span> free';
      LANGenStatusLineFmt = '%s of %s in %d of %d files selected';
      LANGenPanelStrings : array[boolean] of string = ('right', 'left');

      LANGenDIR = '<DIR>';
      LANGenErrorGettingListingForSPanel = 'Error getting listing for %s panel:'#10'    %s'#10#10'Path = ''%s''';
      LANGenErrorGettingListingForSPanelNoPath = 'Error getting listing for %s panel:'#10'    %s';
      LANGenErrorCreatingNewDirectorySInSPanel = 'Error creating new directory ''%s'' in %s panel:'#10'    %s';
      LANGenErrorCreatingNewDirectorySInSPanelNoPath = 'Error creating new directory in %s panel:'#10'    %s';
      LANGenTheFileDirectory = 'The file/directory';
      LANGenCouldNotBeDeleted = 'could not be deleted';
      LANGenCouldNotBeDeletedS = 'could not be deleted:  %s';
      LANGenUserCancelled = 'User cancelled!';
      LANGenTheDirectorySIsNotEmpty = 'The directory %s is not empty!';
      LANGenCannotCopyFile = 'Cannot copy file';
      LANGenCopyError = 'Copy error';
      LANGenMoveError = 'Move error';
      LANGenOverwriteS = 'Overwrite: %s';
      LANGenWithFileS = 'With file: %s';
      LANGenOvewriteSBytesS = '%s bytes, %s';
      LANGenTheFile = 'The file';
      LANGenCopy = 'Copy';
      LANGenMove = 'Move';
      LANGenTheDirectory = 'The directory';
      LANGenTheSymbolicLink = 'The symbolic link';
      LANGenCannotMoveFile = 'Cannot move file';
      LANGenCouldNotBeCreated = 'could not be created';
      LANGenCouldNotBeCreatedS = 'could not be created:  %s';
      LANGenFromS = 'From: %s';
      LANGenToS = 'To: %s';
      LANGenCannotCopyFileToItself = 'Cannot copy file to itself';
      LANGenMemoryAllocationFailed = 'Memory allocation failed:';
      LANGenCannotOpenSourceFile = 'Cannot open source file';
      LANGenCannotOpenDestinationFile = 'Cannot open destination file';
      LANGenCannotCloseDestinationFile = 'Cannot close destination file';
      LANGenCannotCloseSourceFile = 'Cannot close source file';
      LANGenCannotReadFromSourceFile = 'Cannot read from source file';
      LANGenCannotWriteToDestinationFile = 'Cannot write to destination file';

      LANGenUnknownException = 'Unknown Exception';
      LANGenNoAccess = 'No Access';
      LANGenUnknownError = 'Unknown Error';

      LANGenCreateANewDirectory = 'Create a new directory';
      LANGenEnterDirectoryName = 'Enter _directory name:';

      LANGenOverwriteQuestion = 'Overwrite question';
      LANGenOverwriteButton_Caption = '_Overwrite';
      LANGenOverwriteAllButton_Caption = 'Overwrite _all';
      LANGenSkipButton_Caption = '_Skip';
      LANGenOverwriteAllOlderButton_Caption = 'Overwrite all ol_der';
      LANGenSkipAllButton_Caption = 'S_kip all';
      LANGenRenameButton_Caption = '_Rename';
      LANGenAppendButton_Caption = 'A_ppend';
      LANGenRename = 'Rename';
      LANGenRenameFile = 'Rename file ''%s'' to';
      LANGenIgnoreButton_Caption = '_Ignore';

      LANGenProgress = 'Progress';
      LANGenCancel = '_Cancel';
      LANGenDelete = 'Delete:';

      LANGenSpecifyFileType = '_Specify file type:';

      LANGenRemoveDirectory = 'Remove directory';
      LANGenDoYouWantToDeleteItWithAllItsFilesAndSubdirectories = 'Do you want to delete it with all its files and subdirectories?';
      LANGenRetry = '_Retry';
      LANGenDeleteButton_Caption = '_Delete';
      LANGenAll = '_All';

      LANGenCopyFilesSC = 'Copy files:';
      LANGenAppendQuestion = 'Are you sure you want to append file ''%s'' to ''%s''?';
      LANGenPreparingList = 'Preparing list...'; 

      LANGenYouMustSelectAValidFile = 'You must select a valid file!';
      LANGenmiVerifyChecksums = '_Verify checksums';
      LANGenVerifyChecksumsCaption = 'Verify checksums';
      LANGenCheckButtonCaptionCheck = '_Check';
      LANGenCheckButtonCaptionStop = '_Stop';
      LANGenFileListTooltip = '[?] - Not checked'#10'[OK] - Checksum OK'#10'[BAD] - Checksum BAD'#10'[N/A] - File not available';
      LANGenFilenameColumnCaption = 'Filename';
      LANGenTheFileSYouAreTryingToOpenIsQuiteBig = 'The file ''%s'' you are trying to open is quite big (%s bytes). It may not be a valid checksum file.'#10#10'Do you want to load it anyway?';
      LANGenAnErrorOccuredWhileInitializingMemoryBlock = 'An error occured while initializing memory block. Close some programs and try it again.';
      LANGenAnErrorOccuredWhileOpeningFileSS = 'An error occured while opening file ''%s'':'#10'  %s';
      LANGenAnErrorOccuredWhileReadingFileSS = 'An error occured while reading file ''%s'':'#10'  %s';
      LANGenChecksumNotChecked = '<span weight="bold">Status:</span> Not checked';
      LANGenChecksumChecking = '<span weight="bold">Status:</span> Checking...';
      LANGenChecksumInterrupted = '<span weight="bold">Status:</span> Interrupted';
      LANGenChecksumDOK = '<span weight="bold">Status:</span> %d%% OK';

      LANGenmiCreateChecksumsCaption = '_Create checksums...';
      LANGenYouMustSelectAtLeastOneFileToCalculateChecksum = 'You must select at least one file to calculate checksum!';
      LANGenCreateChecksumsCaption = 'Create checksums';
      LANGenCCHKSUMPage1Text = 'You are going to make checksums for'#10'the selected files. If you didn''t selected'#10'all files you want, close this druid and'#10'select more files.';
      LANGenCCHKSUMPage4Text = 'The druid is ready to make checksums for your'#10'selected files. This operation can take a few minutes.'#10'Press Forward to continue.';
      LANGenCCHKSUMPage6Text = 'There were errors making the checksum:';
      LANGenCCHKSUMPage7Text = 'The checksum creation is finished and'#10'your files are ready.'#10#10'Click "Finish" to exit.';
      LANGenCCHKSUMPage1Title = '<span size="xx-large" weight="ultrabold">Prepare files for checksum</span>';
      LANGenCCHKSUMPage2Title = '<span size="xx-large" weight="ultrabold">Select checksums file type</span>';
      LANGenCCHKSUMPage3Title = '<span size="xx-large" weight="ultrabold">Choose filename</span>';
      LANGenCCHKSUMPage4Title = '<span size="xx-large" weight="ultrabold">Ready to check</span>';
      LANGenCCHKSUMPage5Title = '<span size="xx-large" weight="ultrabold">Processing...</span>';
      LANGenCCHKSUMPage6Title = '<span size="xx-large" weight="ultrabold">Error!</span>';
      LANGenCCHKSUMPage7Title = '<span size="xx-large" weight="ultrabold">Finished</span>';
      LANGenCCHKSUMSFVFile = 'SFV File';
      LANGenCCHKSUMMD5sumFile = 'MD5sum File';
      LANGenCCHKSUMFileName = 'File _Name:';
      LANGenCCHKSUMCreateSeparateChecksumFiles = 'Create _separate checksum files';
      LANGenCCHKSUMNowProcessingFileS = 'Now processing file: %s';
      LANGenCCHKSUMFinishCaption = '_Finish';
      LANGenCCHKSUMAreYouSureYouWantToAbortTheProcessing = 'Are you sure you want to abort the processing?';
      LANGenCCHKSUMAnErrorOccuredWhileOpeningFileSS = 'An error occured while opening file ''%s'': %s'#10;
      LANGenCCHKSUMAnErrorOccuredWhileReadingFileSS = 'An error occured while reading file ''%s'': %s'#10;
      LANGenCCHKSUMAnErrorOccuredWhileWritingFileSS = 'An error occured while writing file ''%s'': %s'#10;

      LANGenAnErrorOccuredWhileWritingFileSS = 'An error occured while writing file ''%s'':'#10'  %s';
      LANGenTheTargetFileSAlreadyExistsDoYouWantToOverwriteIt = 'The target file ''%s'' already exists. Do you want to overwrite it?';
      LANGenTheTargetFileSCannotBeRemovedS = 'The target file ''%s'' cannot be removed: %s';
      LANGenMergeCaption = 'Merge';
      LANGenPleaseInsertNextDiskOrGiveDifferentLocation = 'Please insert next disk, or give different location:';
      LANGenMergeOfSSucceeded = 'Merge of ''%s'' succeeded (CRC checksum OK).';
      LANGenWarningCreatedFileFailsCRCCheck = 'Warning: Created file fails CRC check!';
      LANGenMergeOfSSucceeded_NoCRCFileAvailable = 'Merge of ''%s'' succeeded (no CRC file available).';
      LANGenMergeSAndAllFilesWithAscendingNamesToTheFollowingDirectory = 'Merge ''%s'' and all files with ascending names to the following directory:';
      LANGenMergeSC = 'Merge:';
      LANGenmiSplitFileCaption = '_Split File...';
      LANGenmiMergeFilesCaption = '_Merge Files...';

      LANGenSplitTheFileSToDirectory = '_Split the file ''%s'' to directory:';
      LANGenSplitSC = 'Split:';
      LANGenSplitFile = 'Split File';
      LANGenBytesPerFile = '_Bytes per file:';
      LANGenAutomatic = 'Automatic';
      LANGenDeleteFilesOnTargetDisk = '_Delete files on target disk (usable for removable media)';
      LANGenSplitCaption = 'Split';
      LANGenCannotOpenFileS = 'Cannot open file ''%s''';
      LANGenCannotSplitTheFileToMoreThan999Parts = 'Cannot split the file to more than 999 parts!';
      LANGenThereAreSomeFilesInTheTargetDirectorySDoYouWantToDeleteThem = 'There are some files in the target directory:'#10'%s'#10'Do you want to delete them?';
      LANGenThereAreDFilesInTheTargetDirectoryDoYouWantToDeleteThem = 'There are %d files in the target directory. Do you want to delete them?';
      LANGenAnErrorOccuredWhileOperationS = 'An error occured while operation: %s';
      LANGenSplitOfSSucceeded = 'Split of ''%s'' succeeded.';
      LANGenSplitOfSFailed = 'Split of ''%s'' failed!';

      LANGenmnuShow_Caption = 'Sho_w';
      LANGenmiShowDotFiles_Caption = 'Show _dot files';
      LANGenTheFileYouAreTryingToOpenIsQuiteBig = 'The file you are trying to open is quite big. Loading it in an externel application (such as gedit) can cause system slowdown.'#10'Do you want to continue?';
      LANGenCannotExecuteSPleaseCheckTheConfiguration = 'Cannot execute ''%s''. Please check the configuration or set the file type association correctly.';
      LANGenEdit = 'Edit';
      LANGenEnterFilenameToEdit = '_Enter filename to edit:';

      LANGenmnuSettings_Caption = 'Se_ttings';
      LANGenmiFileTypes_Caption = 'File _types...';
      LANGenThereIsNoApplicationAssociatedWithS = 'There is no application associated with "%s".'#10#10'You can configure Tux Commander to associate applications with file types. Do you want to associate an application with this file type now?';
      LANGenErrorExecutingCommand = 'Error executing command!';
      LANGenEditFileTypesCaption = 'Edit File Types';
      LANGenTitleLabel_Caption = '<span size="x-large" weight="ultrabold">File Types Configuration</span>';
      LANGenExtensionsColumn = 'Extensions';
      LANGenDescriptionColumn = 'Description';
      LANGenFileTypesList = 'File types list';
      LANGenActionName = 'Action Name';
      LANGenCommand = 'Command';
      LANGenSetDefaultActionButton_Caption = '_Set as default';
      LANGenRunInTerminalCheckBox_Caption = 'Run in _Terminal';
      LANGenAutodetectCheckBox_Caption = 'Autodetect _GUI application';
      LANGenBrowseButton_Caption = '_Browse...';
      LANGenCommandLabel_Caption = 'Co_mmand:';
      LANGenDescriptionLabel_Caption = 'D_escription:';
      LANGenFNameExtLabel_Caption = 'A_dd extension:';
      LANGenNotebookPageExtensions = 'File type';
      LANGenNotebookPageActions = 'Actions';
      LANGenDefault = ' (default)';
      LANGenCannotSaveFileTypeAssociationsBecauseOtherProcess = 'Cannot save file type associations, because other process has updated it while running this instance of application.';

      LANGenDefaultColor = 'De_fault color';
      LANGenIcon = '_Icon:';
      LANGenBrowseForIcon = 'Browse for icon';
      LANGenSelectFileTypeColor = 'Select File Type Color';
      LANGenColor = 'Co_lor:';

      LANGenmiChangePermissions_Caption = 'Change Per_missions...';
      LANGenmiChangeOwner_Caption = 'Change _Owner/Group...';
      LANGenmiCreateSymlink_Caption = 'Create Sym_link...';
      LANGenmiEditSymlink_Caption = '_Edit Symlink...';
      LANGenChmodProgress = 'Change permissions:';
      LANGenChownProgress = 'Change owner:';
      LANGenYouMustSelectAValidSymbolicLink = 'You must select a valid symbolic link!';
      LANGenPopupRunS = 'E_xecute %s';
      LANGenPopupOpenS = 'O_pen %s';
      LANGenPopupGoUp = '_Go up';
      LANGenPopupOpenWithS = 'Open with %s';
      LANGenPopupDefault = ' (default)';
      LANGenPopupOpenWith = 'O_pen with...';
      LANGenPopupViewFile = '_View file';
      LANGenPopupEditFile = 'Ed_it file';
      LANGenPopupMakeSymlink = 'Make _symlink';
      LANGenPopupRename = '_Rename';
      LANGenPopupDelete = '_Delete';
      LANGenDialogChangePermissions = 'Change permissions';
      LANGenCouldNotBeChmoddedS = 'could not be chmodded:  %s';
      LANGenDialogChangeOwner = 'Change owner';
      LANGenCouldNotBeChownedS = 'could not be chowned:  %s';
      LANGenDialogMakeSymlink = 'Make symlink';
      LANGenDialogEditSymlink = 'Edit symlink';
      LANGenFEditSymlink_Caption = 'Edit symbolic link';
      LANGenFEditSymlink_SymbolicLinkFilename = '_Symbolic link filename:';
      LANGenFEditSymlink_SymbolicLinkPointsTo = 'Symbolic link points _to:';

      LANGenFChmod_Caption = 'Access Permissions';
      LANGenFChmod_PermissionFrame = 'Permissions';
      LANGenFChmod_FileFrame = 'File';
      LANGenFChmod_ApplyRecursivelyFor = 'Apply _recursively for';
      LANGenFChmod_miAllFiles = 'All files and directories';
      LANGenFChmod_miDirectories = 'Directories only';
      LANGenFChmod_OctalLabel = '_Octal:';
      LANGenFChmod_SUID = 'SUID - Set user ID on execution';
      LANGenFChmod_SGID = 'SGID - Set group ID on execution';
      LANGenFChmod_Sticky = 'Sticky bit';
      LANGenFChmod_RUSR = 'RUSR - Read by owner';
      LANGenFChmod_WUSR = 'WUSR - Write by owner';
      LANGenFChmod_XUSR = 'XUSR - Execute/Search by owner';
      LANGenFChmod_RGRP = 'RGRP - Read by group';
      LANGenFChmod_WGRP = 'WGRP - Write by group';
      LANGenFChmod_XGRP = 'XGRP - Execute/Search by group';
      LANGenFChmod_ROTH = 'ROTH - Read by others';
      LANGenFChmod_WOTH = 'WOTH - Write by others';
      LANGenFChmod_XOTH = 'XOTH - Execute/Search by others';
      LANGenFChmod_TextLabel = '<span weight="ultrabold">Text:</span>  %s';
      LANGenFChmod_FileLabel = '<span weight="ultrabold">File:</span> %s'#10'<span weight="ultrabold">Text:</span> %s'#10 +
                               '<span weight="ultrabold">Octal:</span> %d'#10'<span weight="ultrabold">Owner:</span> %s'#10 +
                               '<span weight="ultrabold">Group:</span> %s';

      LANGenFChown_Caption = 'Change owner/group';
      LANGenFChown_OwnerFrame = 'User name';
      LANGenFChown_GroupFrame = 'Group name';
      LANGenFChown_FileFrame = 'File';
      LANGenFChown_ApplyRecursively = 'Apply _recursively';

      LANGenFSymlink_Caption = 'Create symbolic link';
      LANGenFSymlink_ExistingFilename = '_Existing filename (filename symlink will point to):';
      LANGenFSymlink_SymlinkFilename = '_Symbolic link filename:';

      LANGenmnuBookmarks_Caption = '_Bookmarks';
      LANGenmiAddBookmark_Caption = 'Add Bookmark';
      LANGenmiEditBookmarks_Caption = 'Edit Bookmarks';
      LANGenBookmarkPopupDelete_Caption = '_Delete';
      LANGenmiPreferences_Caption = '_Preferences...';
      LANGenTheCurrentDirectoryAlreadyExistsInTheBookmarksList = 'The current directory already exists in the bookmarks list';
      LANGenSomeOtherInstanceChanged = 'Some other instance of Tux Commander changed the configuration. Do you want to apply the new settings?'#10#10'Warning: If you press No at this point, the configuration will be overwritten on this instance'' exit!';
      
      LANGenPreferences_Caption = 'Preferences';
      LANGenPreferences_TitleLabel_Caption = '<span size="x-large" weight="ultrabold">Application Preferences</span>';
      LANGenPreferences_GeneralPage = 'General';
      LANGenPreferences_FontsPage = 'Fonts';
      LANGenPreferences_ColorsPage = 'Colors';
      LANGenPreferences_RowHeight = 'Row _height:';
      LANGenPreferences_NumHistoryItems = 'Co_mmandline history items:';
      LANGenPreferences_Default = '_Default';
      LANGenPreferences_ClearReadonlyAttribute = 'Clear _readonly attribute when copying from CD-ROM';
      LANGenPreferences_DisableMouseRenaming = 'Disable _mouse renaming';
      LANGenPreferences_ShowFiletypeIconsInList = 'Show _filetype icons';
      LANGenPreferences_ExternalAppsLabel = '<span weight="ultrabold">External programs</span>';
      LANGenPreferences_Viewer = '_Viewer:';
      LANGenPreferences_Editor = '_Editor:';
      LANGenPreferences_Terminal = '_Terminal:';
      LANGenPreferences_ListFont = 'List Font:';
      LANGenPreferences_Change = 'Change...';
      LANGenPreferences_UseDefaultFont = 'Use _default font';
      LANGenPreferences_Foreground = 'Foreground';
      LANGenPreferences_Background = 'Background';
      LANGenPreferences_NormalItem = 'Normal Item:';
      LANGenPreferences_SetToDefaultToUseGTKThemeColors = 'Set to default to use GTK theme colors';
      LANGenPreferences_Cursor = 'Cursor:';
      LANGenPreferences_InactiveItem = 'Inactive Item:';
      LANGenPreferences_SelectedItem = 'Selected Item:';
      LANGenPreferences_LinkItem = 'Symbolic links:';
      LANGenPreferences_LinkItemHint = 'Set to default to show symlinks using default normal item colors';
      LANGenPreferences_DotFileItem = 'Dot files:';
      LANGenPreferences_DotFileItemHint = 'Set to default to show dot-files using default normal item colors';
      LANGenPreferences_BrowseForApplication = 'Browse for application';
      LANGenPreferences_DefaultS = 'Default: %s';
      LANGenPreferences_SelectFont = 'Select font';

  (***************  STRINGS ADDED TO v0.4.101  **********************************************************************************)
      LANGenBookmarkButton_Tooltip = 'Show bookmarks';
      LANGenUpButton_Tooltip = 'Go to the upper directory';
      LANGenRootButton_Tooltip = 'Go to the root directory (/)';
      LANGenHomeButton_Tooltip = 'Go to the home directory (/home/user)';
      LANGenLeftEqualButton_Tooltip = 'Switch the right panel to the same directory';
      LANGenRightEqualButton_Tooltip = 'Switch the left panel to the same directory';
      LANGenmiShowDirectorySizes_Caption = 'Show d_irectory sizes';
      LANGenmiTargetSource_Caption = 'Target = S_ource';
      LANGenFileTypeDirectory = 'Directory';
      LANGenFileTypeFile = 'File';
      LANGenFileTypeMetafile = 'This is a common meta-item';
      LANGenPreferencesPanelsPage = 'Panels';
      LANGenPreferencesApplicationsPage = 'Applications';
      LANGenPreferencesExperimentalPage = 'Experimental';
      LANGenPreferencesSelectAllDirectoriesCheckBox_Caption = 'Select _also directories when selecting all';
      LANGenPreferencesNewStyleAltOCheckBox_Caption = '_New style Alt+O';
      LANGenPreferencesNewStyleAltOCheckBox_Tooltip = 'Stay in the same directory when switching directory opposite panel by pressing Ctrl/Alt+O';
      LANGenPreferencesShowFuncButtonsCheckBox_Caption = 'Show function _key buttons';
      LANGenPreferencesSizeFormatLabel_Caption = '_Size format:';
      LANGenPreferencesmiSizeFormat1 = 'System';
      LANGenPreferencesmiSizeFormat6 = 'Dynamic';
      LANGenPreferencesAutodetectXApp = 'Autodetect X app';
      LANGenPreferencesAlwaysRunInTerminal = 'Always run in terminal';
      LANGenPreferencesNeverRunInTerminal = 'Never run in terminal';
      LANGenPreferencesCmdLineBehaviourLabel_Caption = '_Executing from commandline:';
      LANGenPreferencesFeatures = 'Features';
      LANGenPreferencesDisableMouseRename_Tooltip = 'You can still perform quick-rename by pressing Shift+F6';
      LANGenPreferencesDisableFileTipsCheckBox_Caption = 'Disable file _tooltips';
      LANGenPreferencesDisableFileTipsCheckBox_Tooltip = 'Don''t show panel tooltips if the text in a comlumn is truncated';
      LANGenPreferencesShow = 'Show';
      LANGenPreferencesDirsInBoldCheckBox_Caption = 'Directories in _bold';
      LANGenPreferencesDisableDirectoryBracketsCheckBox_Caption = 'Hide directory b_rackets';
      LANGenPreferencesOctalPermissionsCheckBox_Caption = 'Show _octal permissions';
      LANGenPreferencesOctalPermissionsCheckBox_Tooltip = 'Show file/directory permissions as a number instead of text form (-rw-rw-rw-)';
      LANGenPreferencesMovement = 'Movement';
      LANGenPreferencesLynxLikeMotionCheckBox_Caption = '_Lynx-like motion';
      LANGenPreferencesInsertMovesDownCheckBox_Caption = '_Insert moves down';
      LANGenPreferencesSpaceMovesDownCheckBox_Caption = '_Space moves down';
      LANGenPreferencesViewer = 'Viewer';
      LANGenPreferencesCommandSC = 'Command:';
      LANGenPreferencesUseInternalViewer = 'Use _internal viewer';
      LANGenPreferencesEditor = 'Editor';
      LANGenPreferencesTerminal = 'Terminal';
      LANGenPreferencesExperimentalFeatures = 'Experimental features';
      LANGenPreferencesExperimentalWarningLabel_Caption = '<span weight="ultrabold">Warning:</span> These features are currently under development and may not work properly. Use them at your own risk!';
      LANGenPreferencesFocusRefreshCheckBox_Caption = 'Perform _refresh on window focus';
      LANGenPreferencesFocusRefreshCheckBox_Tooltip = 'Very slow panel refreshing at this moment';
      LANGenPreferencesWMCompatModeCheckBox_Caption = '_WM Compatibility mode';
      LANGenPreferencesWMCompatModeCheckBox_Tooltip = 'Use if you have some window manager issues (for example IceWM doesn''t perform window maximize correctly)';
      LANGenPreferencesCompatUseLibcSystemCheckBox_Caption = 'Use libc _system() for executing programs';
      LANGenPreferencesCompatUseLibcSystemCheckBox_Tooltip = 'Use in case of freeze or crash problems when launching external applications';

  (***************  STRINGS ADDED TO v0.5.70  **********************************************************************************)
      LANGenmiSearchCaption2 = '_Search...';
      LANGenmiNoMounterBarCaption = 'Do_n''t show mounter bar';
      LANGenmiShowOneMounterBarCaption = 'Show _one mounter bar';
      LANGenmiShowTwoMounterBarCaption = 'Show _two mounter bars';
      LANGenmnuNetworkCaption = 'N_etwork';
      LANGenmiConnectionsCaption = '_Connections...';
      LANGenmiOpenConnectionCaption = '_Open connection...';
      LANGenmiQuickConnectCaption = '_Quick connect...';
      LANGenmnuPluginsCaption = 'Pl_ugins';
      LANGenmiTestPluginCaption = '_Test plugin...';
      LANGenmiMounterSettingsCaption = '_Mounter Settings...';
      LANGenmiColumnsCaption = 'P_anel Columns...';
      LANGenmiSavePositionCaption = '_Save position';
      LANGenmiMountCaption = '_Mount';
      LANGenmiUmountCaption = '_Umount';
      LANGenmiEjectCaption = '_Eject';
      LANGenmiDuplicateTabCaption = 'Duplicate current tab';
      LANGenmiCloseTabCaption = 'Close current tab';
      LANGenmiCloseAllTabsCaption = 'Close all tabs';
      LANGenCannotDetermineDestinationEngine = 'Cannot determine destination engine. Please enter correct path and try it again.';
      LANGenCannotLoadFile = 'Cannot load file ''%s''. Please check the permissions.';
      LANGenMountPointDevice = 'Mount Point: %s'#10'Device: %s';
      LANGenMountSC = 'Mount:';
      LANGenNoPluginsFound = 'No plugins found';
      LANGenPluginAbout = 'About...';
      LANGenCouldntOpenURI = 'Couldn''t open the URI specified. Please check the consistency of the resource identifier and the access permission.';
      LANGenPluginAboutInside = 'Plugin: %s'#10#10'%s'#10'%s';
      LANGenAreYouSureCloseAllTabs = 'Are you sure you want to close all inactive tabs?';
      LANGenCouldntOpenURIArchive = 'Couldn''t open the archive. Please check consistency and access permissions.';
      LANGenThereIsNoModuleAvailable = 'There are no VFS modules available that can handle this connection';
      LANGenIgnoreError = 'Do you really want to ignore the error? The source file will be then deleted';
      LANGenErrorMount = 'There was an error while mounting the device ''%s'':'#10#10;
      LANGenErrorUmount = 'There was an error while umounting the device ''%s'':'#10#10;
      LANGenErrorEject = 'There was an error while ejecting the device ''%s'':'#10#10;

      LANGenMounterPrefs_Caption = 'Mounter Settings';
      LANGenMounterPrefs_TitleLabelCaption = 'Mounter Settings';
      LANGenMounterPrefs_ListViewFrameCaption = 'Mounter';
      LANGenMounterPrefs_MountName = 'Mount Name';
      LANGenMounterPrefs_MountPoint = 'Mount Point';
      LANGenMounterPrefs_Device = 'Device';
      LANGenMounterPrefs_MoveUpButtonTooltip = 'Move item up';
      LANGenMounterPrefs_MoveDownButtonTooltip = 'Move item down';
      LANGenMounterPrefs_UseFSTabDefaultsCheckBox = 'Use _fstab default items';
      LANGenMounterPrefs_UseFSTabDefaultsCheckBoxTooltip = 'By checking this, the mounter bar will be filled by default items found in the /etc/fstab (system mountlist file)';
      LANGenMounterPrefs_ToggleModeCheckBox = 'Buttons stay _down when mounted';
      LANGenMounterPrefs_ToggleModeCheckBoxTooltip = 'When checked, the mounter buttons will stay down if the device is mounted; another click will cause umounting them (eject in this case)';
      LANGenMounterPrefs_PropertiesFrameCaption = 'Mounter item properties';
      LANGenMounterPrefs_DisplayTextLabelCaption = 'Displayed _Text:';
      LANGenMounterPrefs_MountPointLabelCaption = 'Mount _Point:';
      LANGenMounterPrefs_MountDeviceLabelCaption = '_Device:';
      LANGenMounterPrefs_DeviceTypeLabelCaption = 'Device T_ype:';
      LANGenMounterPrefs_miLocalDiskCaption = 'Local disk';
      LANGenMounterPrefs_miRemovableCaption = 'Removable';
      LANGenMounterPrefs_miCDCaption = 'CD/DVD drive';
      LANGenMounterPrefs_miFloppyCaption = 'Floppy drive';
      LANGenMounterPrefs_miNetworkCaption = 'Network';
      LANGenMounterPrefs_MountCommandLabelCaption = 'Mount _Command:';
      LANGenMounterPrefs_UmountCommandLabelCaption = 'Umount C_ommand:';
      LANGenMounterPrefs_MountCommandEntryTooltip = 'Syntax: use %dev for substitution of the device and %dir for the mount point or leave blank for default mount'#10'Note: beware of interactive commands, tuxcmd could freeze!'#10'Example: smbmount %dev %dir -o username=netuser,password=somepass';
      LANGenMounterPrefs_UmountCommandEntryTooltip = 'Syntax: use %dev for substitution of the device and %dir for the mount point or leave blank for default umount'#10'Example: smbumount $dir';
      LANGenMounterPrefs_IconLabelCaption = '_Icon:';

      LANGenConnMgr_Caption = 'Open New Connection';
      LANGenConnMgr_ConnectButton = 'Co_nnect';
      LANGenConnMgr_OpenConnection = 'Open Connection';
      LANGenConnMgr_NameColumn = 'Name';
      LANGenConnMgr_URIColumn = 'URI';
      LANGenConnMgr_AddConnectionButtonCaption = '_Add site...';
      LANGenConnMgr_AddConnectionButtonTooltip = 'Add new connection';
      LANGenConnMgr_EditButtonCaption = '_Edit...';
      LANGenConnMgr_EditButtonTooltip = 'Edit selected connection';
      LANGenConnMgr_RemoveButtonCaption = '_Remove site';
      LANGenConnMgr_RemoveButtonTooltip = 'Delete selected connection';
      LANGenConnMgr_DoYouWantDelete = 'Do you really want to delete the connection ''%s''?';

      LANGenConnProp_FTP = 'FTP';
      LANGenConnProp_SFTP = 'SFTP (ssh subsystem)';
      LANGenConnProp_SMB = 'Windows share (SMB)';
      LANGenConnProp_HTTP = 'WebDAV (HTTP)';
      LANGenConnProp_HTTPS = 'Secure WebDAV (HTTPS)';
      LANGenConnProp_Other = 'Other <span style="italic">(please specify in URI)</span>';
      LANGenConnProp_Caption = 'Connection properties';
      LANGenConnProp_VFSModule = '_VFS module:';
      LANGenConnProp_URI = '_URI:';
      LANGenConnProp_URIEntryTooltip = 'Correct URI should contain service type prefix and server address';
      LANGenConnProp_DetailedInformations = 'Detailed informations';
      LANGenConnProp_Name = '_Name:';
      LANGenConnProp_Server = 'Se_rver[:port]:';
      LANGenConnProp_Username = 'Us_ername:';
      LANGenConnProp_UserNameEntryTooltip = 'Leave blank for anonymous login';
      LANGenConnProp_Password = '_Password:';
      LANGenConnProp_TargetDirectory = 'Target _directory:';
      LANGenConnProp_ServiceType = '_Service type:';
      LANGenConnProp_MaskPassword = '_Mask password';
      LANGenConnProp_MenuItemCaption = 'Default <span style="italic">(all suitable modules)</span>';

      LANGenConnLogin_Caption = 'Authentication required';
      LANGenConnLogin_Login = 'Login';
      LANGenConnLogin_ExperimentalWarningLabelCaption = 'You must log in to access %s';
      LANGenConnLogin_Username = '_Username:';
      LANGenConnLogin_Password = '_Password:';
      LANGenConnLogin_AnonymousCheckButton = '_Anonymous';

      LANGenColumns_Caption = 'Panel Columns Settings';
      LANGenColumns_Title = 'Panel Columns Settings';
      LANGenColumns_MoveUpButtonTooltip = 'Move item up';
      LANGenColumns_MoveDownButtonTooltip = 'Move item down';
      LANGenColumns_TitlesLongName = 'Name';
      LANGenColumns_TitlesLongNameExt = 'Name + Extension';
      LANGenColumns_TitlesLongExt = 'Extension';
      LANGenColumns_TitlesLongSize = 'Size';
      LANGenColumns_TitlesLongDateTime = 'Date + Time';
      LANGenColumns_TitlesLongDate = 'Date';
      LANGenColumns_TitlesLongTime = 'Time';
      LANGenColumns_TitlesLongUser = 'User';
      LANGenColumns_TitlesLongGroup = 'Group';
      LANGenColumns_TitlesLongAttr = 'Attributes';
      LANGenColumns_TitlesShortName = 'Name';
      LANGenColumns_TitlesShortNameExt = 'Name';
      LANGenColumns_TitlesShortExt = 'Ext';
      LANGenColumns_TitlesShortSize = 'Size';
      LANGenColumns_TitlesShortDateTime = 'Date';
      LANGenColumns_TitlesShortDate = 'Date';
      LANGenColumns_TitlesShortTime = 'Time';
      LANGenColumns_TitlesShortUser = 'User';
      LANGenColumns_TitlesShortGroup = 'Group';
      LANGenColumns_TitlesShortAttr = 'Attr';

      LANGenTestPlugin_Caption = 'Test VFS Plugin';
      LANGenTestPlugin_Title = 'Test VFS Plugin';
      LANGenTestPlugin_ExperimentalWarningLabelCaption = '<span weight="ultrabold">Warning:</span> The VFS subsystem and its plugins are under heavy development and may contain bugs. Use this function under your own risk!';
      LANGenTestPlugin_Plugin = '_Plugin:';
      LANGenTestPlugin_Command = 'Co_mmand:';
      LANGenTestPlugin_Username = '_Username:';
      LANGenTestPlugin_Password = '_Password:';
      LANGenTestPlugin_AnonymousCheckButton = '_Anonymous login (doesn''t call VFSLogin)';
      LANGenTestPlugin_NoPluginsFound = 'No plugins found';

      LANGenRemoteWait_Caption = 'Operation in progress';
      LANGenRemoteWait_OperationInProgress = 'Operation in progress, please be patient...';
      LANGenRemoteWait_ItemsFound = 'Items found so far: %d';

      LANGenSearch_Bytes = 'Bytes';
      LANGenSearch_kB = 'kB';
      LANGenSearch_MB = 'MB';
      LANGenSearch_days = 'days';
      LANGenSearch_weeks = 'weeks';
      LANGenSearch_months = 'months';
      LANGenSearch_years = 'years';
      LANGenSearch_Caption = 'Find Files';
      LANGenSearch_General = 'General';
      LANGenSearch_Advanced = 'Advanced';
      LANGenSearch_SearchResults = 'Search _Results:';
      LANGenSearch_SearchFor = 'Search _for:';
      LANGenSearch_FileMaskEntryTooltip = 'Tip: Use colons (";") to specify multiple files to find';
      LANGenSearch_SearchIn = 'Search _in:';
      LANGenSearch_SearchArchivesCheckButton = 'Search _archives';
      LANGenSearch_FindText = 'Find _text:';
      LANGenSearch_FindTextEntryTooltip = 'Leave blank for no text matching'#10'Please note that we are using UTF-8 in GUI part';
      LANGenSearch_CaseSensitiveCheckButton = 'Cas_e sensitive';
      LANGenSearch_StayCurrentFSCheckButton = 'Include other files_ystems';
      LANGenSearch_CaseSensitiveMatchCheckButton = 'Ca_se sensitive';
      LANGenSearch_Size = 'Size';
      LANGenSearch_Date = 'Date';
      LANGenSearch_BiggerThan = '_Bigger than';
      LANGenSearch_SmallerThan = '_Smaller than';
      LANGenSearch_ModifiedBetweenRadioButton = '_Modified between';
      LANGenSearch_NotModifiedAfterRadioButton = '_Not modified after';
      LANGenSearch_ModifiedLastRadioButton = 'Mod_ified in the last';
      LANGenSearch_ModifiedNotLastRadionButton =  'No_t modified in the last';
      LANGenSearch_ModifiedBetweenEntry1 = '"Please use this date format:" c';
      LANGenSearch_ViewButtonCaption = '_View file';
      LANGenSearch_NewSearchButtonCaption = '_New search';
      LANGenSearch_GoToFileButtonCaption = '_Go to file';
      LANGenSearch_FeedToListboxButtonCaption = 'Feed to _listbox';
      LANGenSearch_StatusSC = 'Status:';
      LANGenSearch_Ready = 'Ready.';
      LANGenSearch_PreparingToSearch = 'Preparing to search.';
      LANGenSearch_SearchInProgress = 'Search in progress:';
      LANGenSearch_UserCancelled = 'User cancelled.';
      LANGenSearch_SearchFinished = 'Search finished';
      LANGenSearch_FilesFound = '%d files found';
      LANGenSearch_And = 'and';

  (***************  STRINGS ADDED TO v0.5.82  **********************************************************************************)
      LANGenCloseOpenConnection = 'You''re trying to open new connection over the another active connection. By continuing, the previous connection will be closed and replaced by the new requested one.'#10#10'Do you want to continue?';
      LANGenDuplicateTabWarning = 'You are trying to open a new tab from a remote directory. However, engine cloning is not supported. The directory in the new tab will point to a local filesystem.';
      LANGenDontShowAgain = '_Don''t show this message again';
      LANGenSwitchOtherPanelWarning = 'You are trying to open the remote directory in the opposite panel. However, engine cloning is not supported. The target directory will not be switched.';
      LANGenOpenConnectionsWarning = 'There are some active connections opened in the panel. By closing the application, these connections will be disconnected.'#10#10'Do you want to continue quit?';
      LANGenmiDisconnect_Caption = '_Disconnect';
      LANGenDisconnectButton_Tooltip = 'Disconnect active connection';
      LANGenLeaveArchiveButton_Tooltip = 'Close current archive';
      LANGenOpenTerminalButton_Tooltip = 'Opens a new terminal windows from the current directory';
      LANGenOpenTerminalButton_Caption = 'Open Te_rminal';
      LANGenShowTextUIDsCheckBox_Caption = 'Show text _UIDs';
      LANGenShowTextUIDsCheckBox_Tooltip = 'Show textual User and Group informations instead of numbers (UID/GID)';

  (***************  STRINGS ADDED TO v0.5.100  **********************************************************************************)
      LANGenmiNewTab_Caption = 'New folder _tab';
      LANGenFilePopupMenu_Properties = '_Properties';
      LANGenCommandEntry_Tooltip = 'Use %s as file/directory placeholder';
      LANGenmiFiles_Caption = 'Files only';

  (***************  STRINGS ADDED TO v0.6.31  **********************************************************************************)
      LANGenPasswordButton_Tooltip = 'Archive requires password.'#10'Click to set';
      LANGenHandleRunFromArchive_Bytes = 'bytes';
      LANGenHandleRunFromArchive_FileTypeDesc_Unknown = '(unknown)';
      LANGenHandleRunFromArchive_NotAssociated = '(not associated)';
      LANGenHandleRunFromArchive_SelfExecutable = '(self-executable)';
      LANGenHandleRunFromArchive_CouldntCreateTemporaryDirectory = 'Couldn''t create temporary directory "%s": %s.'#10#10'Please check the temporary directory settings and try it again.';
      LANGenFRunFromVFS_Caption = 'Packed file properties';
      LANGenFRunFromVFS_TitleLabel = 'File Properties';
      LANGenFRunFromVFS_FileNameLabel = 'File name:';
      LANGenFRunFromVFS_FileTypeLabel = 'File type:';
      LANGenFRunFromVFS_SizeLabel = 'Size:';
      LANGenFRunFromVFS_PackedSizeLabel = 'Compressed size:';
      LANGenFRunFromVFS_DateLabel = 'Modify date:';
      LANGenFRunFromVFS_InfoLabel = 'Opening files directly from archives is not supported. By clicking the buttons below the file (all files respectively) will be extracted to a temporary location. Temporary files will be deleted when you close Tux Commander.';
      LANGenFRunFromVFS_OpensWithLabel = 'Open with:';
      LANGenFRunFromVFS_ExecuteButton = 'E_xtract and open';
      LANGenFRunFromVFS_ExecuteAllButton = 'Extract _all and open';
      LANGenFSetPassword_Caption = 'Set password';
      LANGenFSetPassword_Label1_Caption = 'Password required';
      LANGenFSetPassword_Label2_Caption = 'The archive is encrypted and requires password in order to extract the data';
      LANGenFSetPassword_ShowPasswordCheckButton = 'Un_mask password';

  (***************  STRINGS ADDED TO v0.6.48  **********************************************************************************)
      LANGenCopyFileNamesToClipboard = '_Copy file names to clipboard';
      LANGenCopyFullPathNamesToClipboard = 'Copy _full path names to clipboard';
      LANGenCopyPathToClipboard = '_Copy path to clipboard';
      LANGenPreferences_DateFormatLabel_Caption = 'Date _format:';
      LANGenPreferences_System = 'System';
      LANGenPreferences_Custom = 'Custom...';
      LANGenPreferences_CustomDateFormatEntry_Tooltip = 'Enter custom date format string.'#10'Please see "man strftime" for syntax reference.';
      LANGenPreferences_TimeFormatLabel_Caption = '_Time format:';
      LANGenPreferences_CustomTimeFormatEntry_Tooltip = 'Enter custom time format string.'#10'Please see "man strftime" for syntax reference.';
      LANGenPreferences_DateTimeFormatLabel_Caption = 'Date/time _order:';
      LANGenPreferences_QuickRenameSkipExtCheckBox = 'Select name part only on quick-rename';
      LANGenPreferences_QuickRenameSkipExtCheckBox_Tooltip = 'Exclude filename extension from the selection when doing quick-rename';
      LANGenPreferences_SortDirectoriesLikeFilesCheckBox = 'Sort directories lik_e files';
      LANGenPreferences_SortDirectoriesLikeFilesCheckBox_Tooltip = 'Check this to allow sorting directories along with files. Directories are always first in the list.'#10'Unchecked: directories are always sorted by name.';
      LANGenPreferences_QuickSearchLabel_Caption = 'Quick search _keystroke:';
      LANGenPreferences_QuickSearchOptionMenu_Tooltip = 'The Ctrl+S/Alt+S and "/" keystrokes are always active, regardless on this setting.';
      LANGenPreferences_QuickSearch_Option1 = 'Ctrl+S/Alt+S and "/" only';
      LANGenPreferences_QuickSearch_Option2 = 'Ctrl+Alt+letters';
      LANGenPreferences_QuickSearch_Option3 = 'Alt+letters';
      LANGenPreferences_QuickSearch_Option4 = 'letters directly';
      LANGenPreferences_TempPathLabel_Caption = 'Temporary files';
      LANGenPreferences_VFSTempPathLabel_Caption = '_VFS temp files:';
      LANGenPreferences_VFSTempPathEntry_Tooltip = 'Location of temporary files used by VFS subsystem, e.g. when opening files directly from archives. All temporary files are cleaned on exit.';

  (***************  STRINGS ADDED TO v0.6.67  **********************************************************************************)
      LANGenPreferences_RightClickSelectCheckBox = 'Rig_ht mouse button selection mode';
      LANGenPreferences_RightClickSelectCheckBox_Tooltip = 'Use right mouse button to select, like mc.';
      LANGenGtkMountOperation_ConnectAnonymously = 'Connect _anonymously';
      LANGenGtkMountOperation_ConnectAsUser = 'Connect as u_ser:';
      LANGenGtkMountOperation_Username = '_Username:';
      LANGenGtkMountOperation_Domain = '_Domain:';
      LANGenGtkMountOperation_Password = '_Password:';
      LANGenGtkMountOperation_DoNotSavePassword = 'Do no_t save password';
      LANGenGtkMountOperation_ForgetPasswordImmediately = 'Forget password _immediately';
      LANGenGtkMountOperation_RememberPasswordUntilYouLogout = 'Remember password until you _logout';
      LANGenGtkMountOperation_SavePasswordInConnectionManager = '_Save password in Connection Manager';
      LANGenGtkMountOperation_RememberForever = 'Remember _forever';
      LANGenFSymlink_RelativePath = '_Relative path';
      LANGenFConnectionManager_DuplicateButton_Caption = 'D_uplicate...';
      LANGenFConnectionManager_DuplicateButton_Tooltip = 'Duplicate selected connection';
      LANGenFConnectionManager_DoNotSavePasswordsCheckBox_Label = '_Do not store passwords internally (but still use gnome-keyring)';
      LANGenFConnectionManager_DoNotSavePasswordsCheckBox_Tooltip = 'By checking this option on, Tux Commander will never save passwords into its connection list. Due to the GVFS nature, gnome-keyring will still be used to retrieve stored passwords from your desktop session.';
      LANGenFConnectionManager_DoNotSynchronizeKeyringCheckBox_Label = 'Do not synchronize passwords to gnome-_keyring';
      LANGenFConnectionManager_DoNotSynchronizeKeyringCheckBox_Tooltip = 'Don''t tell gnome-keyring to save any passwords.';
      LANGenFConnectionManager_DuplicateMenuItem_Caption = 'D_uplicate...';
      LANGenFQuickConnect_Caption = 'Quick connect';
      LANGenFQuickConnect_TitleLabel_Caption = 'Quick connect';
      LANGenFQuickConnect_ConnectToURILabel_Caption = 'C_onnect to URI:';
      LANGenLinkToS = 'Link to %s';
      LANGenOpenDirectoryInBackgroundTab = 'Open directory in _background tab';
      LANGenTheActiveConnectionHasNotBeenSaved = 'The active connection has not been saved. Do you want to save it to Connection Manager?'#10#10'%s';
      LANGenTheArchiveIsEncryptedAndRequiresPassword = 'The archive is encrypted and requires password';



(********************************************************************************************************************************)
procedure SetTranslation;
begin
  LANGF2Button_Caption := LANGenF2Button_Caption;
  LANGF3Button_Caption := LANGenF3Button_Caption;
  LANGF4Button_Caption := LANGenF4Button_Caption;
  LANGF5Button_Caption := LANGenF5Button_Caption;
  LANGF6Button_Caption := LANGenF6Button_Caption;
  LANGF7Button_Caption := LANGenF7Button_Caption;
  LANGF8Button_Caption := LANGenF8Button_Caption;

  LANGmnuFile_Caption := LANGenmnuFile_Caption;
  LANGmnuMark_Caption := LANGenmnuMark_Caption;
  LANGmnuCommands_Caption := LANGenmnuCommands_Caption;
  LANGmnuHelp_Caption := LANGenmnuHelp_Caption;
  LANGmiExit_Caption := LANGenmiExit_Caption;
  LANGmiSelectGroup_Caption := LANGenmiSelectGroup_Caption;
  LANGmiUnselectGroup_Caption := LANGenmiUnselectGroup_Caption;
  LANGmiSelectAll_Caption := LANGenmiSelectAll_Caption;
  LANGmiUnselectAll_Caption := LANGenmiUnselectAll_Caption;
  LANGmiInvertSelection_Caption := LANGenmiInvertSelection_Caption;
  LANGmiRefresh_Caption := LANGenmiRefresh_Caption;
  LANGmiAbout_Caption := LANGenmiAbout_Caption;

  LANGColumn1_Caption := LANGenColumn1_Caption;
  LANGColumn2_Caption := LANGenColumn2_Caption;
  LANGColumn3_Caption := LANGenColumn3_Caption;
  LANGColumn4_Caption := LANGenColumn4_Caption;
  LANGColumn5_Caption := LANGenColumn5_Caption;

  LANGExpandSelection := LANGenExpandSelection;
  LANGShrinkSelection := LANGenShrinkSelection;
  LANGNoMatchesFound := LANGenNoMatchesFound;
  LANGNoFilesSelected := LANGenNoFilesSelected;
  LANGSelectedFilesDirectories := LANGenSelectedFilesDirectories;
  LANGDirectoryS := LANGenDirectoryS;
  LANGFileS := LANGenFileS;
  LANGDoYouReallyWantToDeleteTheS := LANGenDoYouReallyWantToDeleteTheS;
  LANGDoYouReallyWantToDeleteTheSS := LANGenDoYouReallyWantToDeleteTheSS;
  LANGCopyFiles := LANGenCopyFiles;
  LANGMoveRenameFiles := LANGenMoveRenameFiles;
  LANGCopyDFileDirectoriesTo := LANGenCopyDFileDirectoriesTo;
  LANGMoveRenameDFileDirectoriesTo := LANGenMoveRenameDFileDirectoriesTo;
  LANGCopySC := LANGenCopySC;
  LANGMoveRenameSC := LANGenMoveRenameSC;

  LANGQuickFind := LANGenQuickFind;

  LANGAboutString := LANGenAboutString;
  LANGAboutStringGnome := LANGenAboutStringGnome;
  LANGDiskStatFmt := LANGenDiskStatFmt;
  LANGDiskStatVolNameFmt := LANGenDiskStatVolNameFmt;
  LANGStatusLineFmt := LANGenStatusLineFmt;
  LANGPanelStrings[False] := LANGenPanelStrings[False];
  LANGPanelStrings[True] := LANGenPanelStrings[True];
  LANGDIR := LANGenDIR;
  LANGErrorGettingListingForSPanel := LANGenErrorGettingListingForSPanel;
  LANGErrorGettingListingForSPanelNoPath := LANGenErrorGettingListingForSPanelNoPath;
  LANGErrorCreatingNewDirectorySInSPanel := LANGenErrorCreatingNewDirectorySInSPanel;
  LANGErrorCreatingNewDirectorySInSPanelNoPath := LANGenErrorCreatingNewDirectorySInSPanelNoPath;
  LANGTheFileDirectory := LANGenTheFileDirectory;
  LANGCouldNotBeDeleted := LANGenCouldNotBeDeleted;
  LANGCouldNotBeDeletedS := LANGenCouldNotBeDeletedS;
  LANGUserCancelled := LANGenUserCancelled;
  LANGTheDirectorySIsNotEmpty := LANGenTheDirectorySIsNotEmpty;
  LANGCannotCopyFile := LANGenCannotCopyFile;
  LANGCopyError := LANGenCopyError;
  LANGMoveError := LANGenMoveError;
  LANGOverwriteS := LANGenOverwriteS;
  LANGWithFileS := LANGenWithFileS;
  LANGOvewriteSBytesS := LANGenOvewriteSBytesS;
  LANGTheFile := LANGenTheFile;
  LANGCopy := LANGenCopy;
  LANGMove := LANGenMove;
  LANGTheDirectory := LANGenTheDirectory;
  LANGTheSymbolicLink := LANGenTheSymbolicLink;
  LANGCannotMoveFile := LANGenCannotMoveFile;
  LANGCouldNotBeCreated := LANGenCouldNotBeCreated;
  LANGCouldNotBeCreatedS := LANGenCouldNotBeCreatedS;
  LANGFromS := LANGenFromS;
  LANGToS := LANGenToS;
  LANGCannotCopyFileToItself := LANGenCannotCopyFileToItself;
  LANGMemoryAllocationFailed := LANGenMemoryAllocationFailed;
  LANGCannotOpenSourceFile := LANGenCannotOpenSourceFile;
  LANGCannotOpenDestinationFile := LANGenCannotOpenDestinationFile;
  LANGCannotCloseDestinationFile := LANGenCannotCloseDestinationFile;
  LANGCannotCloseSourceFile := LANGenCannotCloseSourceFile;
  LANGCannotReadFromSourceFile := LANGenCannotReadFromSourceFile;
  LANGCannotWriteToDestinationFile := LANGenCannotWriteToDestinationFile;

  LANGUnknownException := LANGenUnknownException;
  LANGNoAccess := LANGenNoAccess;
  LANGUnknownError := LANGenUnknownError;

  LANGCreateANewDirectory := LANGenCreateANewDirectory;
  LANGEnterDirectoryName := LANGenEnterDirectoryName;

  LANGOverwriteQuestion := LANGenOverwriteQuestion;
  LANGOverwriteButton_Caption := LANGenOverwriteButton_Caption;
  LANGOverwriteAllButton_Caption := LANGenOverwriteAllButton_Caption;
  LANGSkipButton_Caption := LANGenSkipButton_Caption;
  LANGOverwriteAllOlderButton_Caption := LANGenOverwriteAllOlderButton_Caption;
  LANGSkipAllButton_Caption := LANGenSkipAllButton_Caption;
  LANGRenameButton_Caption := LANGenRenameButton_Caption;
  LANGAppendButton_Caption := LANGenAppendButton_Caption;
  LANGRename := LANGenRename;
  LANGRenameFile := LANGenRenameFile;
  LANGIgnoreButton_Caption := LANGenIgnoreButton_Caption;

  LANGProgress := LANGenProgress;
  LANGCancel := LANGenCancel;
  LANGDelete := LANGenDelete;

  LANGSpecifyFileType := LANGenSpecifyFileType;

  LANGRemoveDirectory := LANGenRemoveDirectory;
  LANGDoYouWantToDeleteItWithAllItsFilesAndSubdirectories := LANGenDoYouWantToDeleteItWithAllItsFilesAndSubdirectories;
  LANGRetry := LANGenRetry;
  LANGDeleteButton_Caption := LANGenDeleteButton_Caption;
  LANGAll := LANGenAll;

  LANGCopyFilesSC := LANGenCopyFilesSC;
  LANGAppendQuestion := LANGenAppendQuestion;
  LANGPreparingList := LANGenPreparingList;

  LANGYouMustSelectAValidFile := LANGenYouMustSelectAValidFile;
  LANGmiVerifyChecksums := LANGenmiVerifyChecksums;
  LANGVerifyChecksumsCaption := LANGenVerifyChecksumsCaption;
  LANGCheckButtonCaptionCheck := LANGenCheckButtonCaptionCheck;
  LANGCheckButtonCaptionStop := LANGenCheckButtonCaptionStop;
  LANGFileListTooltip := LANGenFileListTooltip;
  LANGFilenameColumnCaption := LANGenFilenameColumnCaption;
  LANGTheFileSYouAreTryingToOpenIsQuiteBig := LANGenTheFileSYouAreTryingToOpenIsQuiteBig;
  LANGAnErrorOccuredWhileInitializingMemoryBlock := LANGenAnErrorOccuredWhileInitializingMemoryBlock;
  LANGAnErrorOccuredWhileOpeningFileSS := LANGenAnErrorOccuredWhileOpeningFileSS;
  LANGAnErrorOccuredWhileReadingFileSS := LANGenAnErrorOccuredWhileReadingFileSS;
  LANGChecksumNotChecked := LANGenChecksumNotChecked;
  LANGChecksumChecking := LANGenChecksumChecking;
  LANGChecksumInterrupted := LANGenChecksumInterrupted;
  LANGChecksumDOK := LANGenChecksumDOK;

  LANGmiCreateChecksumsCaption := LANGenmiCreateChecksumsCaption;
  LANGYouMustSelectAtLeastOneFileToCalculateChecksum := LANGenYouMustSelectAtLeastOneFileToCalculateChecksum;
  LANGCreateChecksumsCaption := LANGenCreateChecksumsCaption;
  LANGCCHKSUMPage1Text := LANGenCCHKSUMPage1Text;
  LANGCCHKSUMPage4Text := LANGenCCHKSUMPage4Text;
  LANGCCHKSUMPage6Text := LANGenCCHKSUMPage6Text;
  LANGCCHKSUMPage7Text := LANGenCCHKSUMPage7Text;
  LANGCCHKSUMPage1Title := LANGenCCHKSUMPage1Title;
  LANGCCHKSUMPage2Title := LANGenCCHKSUMPage2Title;
  LANGCCHKSUMPage3Title := LANGenCCHKSUMPage3Title;
  LANGCCHKSUMPage4Title := LANGenCCHKSUMPage4Title;
  LANGCCHKSUMPage5Title := LANGenCCHKSUMPage5Title;
  LANGCCHKSUMPage6Title := LANGenCCHKSUMPage6Title;
  LANGCCHKSUMPage7Title := LANGenCCHKSUMPage7Title;
  LANGCCHKSUMSFVFile := LANGenCCHKSUMSFVFile;
  LANGCCHKSUMMD5sumFile := LANGenCCHKSUMMD5sumFile;
  LANGCCHKSUMFileName := LANGenCCHKSUMFileName;
  LANGCCHKSUMCreateSeparateChecksumFiles := LANGenCCHKSUMCreateSeparateChecksumFiles;
  LANGCCHKSUMNowProcessingFileS := LANGenCCHKSUMNowProcessingFileS;
  LANGCCHKSUMFinishCaption := LANGenCCHKSUMFinishCaption;
  LANGCCHKSUMAreYouSureYouWantToAbortTheProcessing := LANGenCCHKSUMAreYouSureYouWantToAbortTheProcessing;
  LANGCCHKSUMAnErrorOccuredWhileOpeningFileSS := LANGenCCHKSUMAnErrorOccuredWhileOpeningFileSS;
  LANGCCHKSUMAnErrorOccuredWhileReadingFileSS := LANGenCCHKSUMAnErrorOccuredWhileReadingFileSS;
  LANGCCHKSUMAnErrorOccuredWhileWritingFileSS := LANGenCCHKSUMAnErrorOccuredWhileWritingFileSS;

  LANGAnErrorOccuredWhileWritingFileSS := LANGenAnErrorOccuredWhileWritingFileSS;
  LANGTheTargetFileSAlreadyExistsDoYouWantToOverwriteIt := LANGenTheTargetFileSAlreadyExistsDoYouWantToOverwriteIt;
  LANGTheTargetFileSCannotBeRemovedS := LANGenTheTargetFileSCannotBeRemovedS;
  LANGMergeCaption := LANGenMergeCaption;
  LANGPleaseInsertNextDiskOrGiveDifferentLocation := LANGenPleaseInsertNextDiskOrGiveDifferentLocation;
  LANGMergeOfSSucceeded := LANGenMergeOfSSucceeded;
  LANGWarningCreatedFileFailsCRCCheck := LANGenWarningCreatedFileFailsCRCCheck;
  LANGMergeOfSSucceeded_NoCRCFileAvailable := LANGenMergeOfSSucceeded_NoCRCFileAvailable;
  LANGMergeSAndAllFilesWithAscendingNamesToTheFollowingDirectory := LANGenMergeSAndAllFilesWithAscendingNamesToTheFollowingDirectory;
  LANGMergeSC := LANGenMergeSC;
  LANGmiSplitFileCaption := LANGenmiSplitFileCaption;
  LANGmiMergeFilesCaption := LANGenmiMergeFilesCaption;

  LANGSplitTheFileSToDirectory := LANGenSplitTheFileSToDirectory;
  LANGSplitSC := LANGenSplitSC;
  LANGSplitFile := LANGenSplitFile;
  LANGBytesPerFile := LANGenBytesPerFile;
  LANGAutomatic := LANGenAutomatic;
  LANGDeleteFilesOnTargetDisk := LANGenDeleteFilesOnTargetDisk;
  LANGSplitCaption := LANGenSplitCaption;
  LANGCannotOpenFileS := LANGenCannotOpenFileS;
  LANGCannotSplitTheFileToMoreThan999Parts := LANGenCannotSplitTheFileToMoreThan999Parts;
  LANGThereAreSomeFilesInTheTargetDirectorySDoYouWantToDeleteThem := LANGenThereAreSomeFilesInTheTargetDirectorySDoYouWantToDeleteThem;
  LANGThereAreDFilesInTheTargetDirectoryDoYouWantToDeleteThem := LANGenThereAreDFilesInTheTargetDirectoryDoYouWantToDeleteThem;
  LANGAnErrorOccuredWhileOperationS := LANGenAnErrorOccuredWhileOperationS;
  LANGSplitOfSSucceeded := LANGenSplitOfSSucceeded;
  LANGSplitOfSFailed := LANGenSplitOfSFailed;

  LANGmnuShow_Caption := LANGenmnuShow_Caption;
  LANGmiShowDotFiles_Caption := LANGenmiShowDotFiles_Caption;
  LANGTheFileYouAreTryingToOpenIsQuiteBig := LANGenTheFileYouAreTryingToOpenIsQuiteBig;
  LANGCannotExecuteSPleaseCheckTheConfiguration := LANGenCannotExecuteSPleaseCheckTheConfiguration;
  LANGEdit := LANGenEdit;
  LANGEnterFilenameToEdit := LANGenEnterFilenameToEdit;

  LANGmnuSettings_Caption := LANGenmnuSettings_Caption;
  LANGmiFileTypes_Caption := LANGenmiFileTypes_Caption;
  LANGThereIsNoApplicationAssociatedWithS := LANGenThereIsNoApplicationAssociatedWithS;
  LANGErrorExecutingCommand := LANGenErrorExecutingCommand;
  LANGEditFileTypesCaption := LANGenEditFileTypesCaption;
  LANGTitleLabel_Caption := LANGenTitleLabel_Caption;
  LANGExtensionsColumn := LANGenExtensionsColumn;
  LANGDescriptionColumn := LANGenDescriptionColumn;
  LANGFileTypesList := LANGenFileTypesList;
  LANGActionName := LANGenActionName;
  LANGCommand := LANGenCommand;
  LANGSetDefaultActionButton_Caption := LANGenSetDefaultActionButton_Caption;
  LANGRunInTerminalCheckBox_Caption := LANGenRunInTerminalCheckBox_Caption;
  LANGAutodetectCheckBox_Caption := LANGenAutodetectCheckBox_Caption;
  LANGBrowseButton_Caption := LANGenBrowseButton_Caption;
  LANGCommandLabel_Caption := LANGenCommandLabel_Caption;
  LANGDescriptionLabel_Caption := LANGenDescriptionLabel_Caption;
  LANGFNameExtLabel_Caption := LANGenFNameExtLabel_Caption;
  LANGNotebookPageExtensions := LANGenNotebookPageExtensions;
  LANGNotebookPageActions := LANGenNotebookPageActions;
  LANGDefault := LANGenDefault;
  LANGCannotSaveFileTypeAssociationsBecauseOtherProcess := LANGenCannotSaveFileTypeAssociationsBecauseOtherProcess;

  LANGDefaultColor := LANGenDefaultColor;
  LANGIcon := LANGenIcon;
  LANGBrowseForIcon := LANGenBrowseForIcon;
  LANGSelectFileTypeColor := LANGenSelectFileTypeColor;
  LANGColor := LANGenColor;

  LANGmiChangePermissions_Caption := LANGenmiChangePermissions_Caption;
  LANGmiChangeOwner_Caption := LANGenmiChangeOwner_Caption;
  LANGmiCreateSymlink_Caption := LANGenmiCreateSymlink_Caption;
  LANGmiEditSymlink_Caption := LANGenmiEditSymlink_Caption;
  LANGChmodProgress := LANGenChmodProgress;
  LANGChownProgress := LANGenChownProgress;
  LANGYouMustSelectAValidSymbolicLink := LANGenYouMustSelectAValidSymbolicLink;
  LANGPopupRunS := LANGenPopupRunS;
  LANGPopupOpenS := LANGenPopupOpenS;
  LANGPopupGoUp := LANGenPopupGoUp;
  LANGPopupOpenWithS := LANGenPopupOpenWithS;
  LANGPopupDefault := LANGenPopupDefault;
  LANGPopupOpenWith := LANGenPopupOpenWith;
  LANGPopupViewFile := LANGenPopupViewFile;
  LANGPopupEditFile := LANGenPopupEditFile;
  LANGPopupMakeSymlink := LANGenPopupMakeSymlink;
  LANGPopupRename := LANGenPopupRename;
  LANGPopupDelete := LANGenPopupDelete;
  LANGDialogChangePermissions := LANGenDialogChangePermissions;
  LANGCouldNotBeChmoddedS := LANGenCouldNotBeChmoddedS;
  LANGDialogChangeOwner := LANGenDialogChangeOwner;
  LANGCouldNotBeChownedS := LANGenCouldNotBeChownedS;
  LANGDialogMakeSymlink := LANGenDialogMakeSymlink;
  LANGDialogEditSymlink := LANGenDialogEditSymlink;
  LANGFEditSymlink_Caption := LANGenFEditSymlink_Caption;
  LANGFEditSymlink_SymbolicLinkFilename := LANGenFEditSymlink_SymbolicLinkFilename;
  LANGFEditSymlink_SymbolicLinkPointsTo := LANGenFEditSymlink_SymbolicLinkPointsTo;

  LANGFChmod_Caption := LANGenFChmod_Caption;
  LANGFChmod_PermissionFrame := LANGenFChmod_PermissionFrame;
  LANGFChmod_FileFrame := LANGenFChmod_FileFrame;
  LANGFChmod_ApplyRecursivelyFor := LANGenFChmod_ApplyRecursivelyFor;
  LANGFChmod_miAllFiles := LANGenFChmod_miAllFiles;
  LANGFChmod_miDirectories := LANGenFChmod_miDirectories;
  LANGFChmod_OctalLabel := LANGenFChmod_OctalLabel;
  LANGFChmod_SUID := LANGenFChmod_SUID;
  LANGFChmod_SGID := LANGenFChmod_SGID;
  LANGFChmod_Sticky := LANGenFChmod_Sticky;
  LANGFChmod_RUSR := LANGenFChmod_RUSR;
  LANGFChmod_WUSR := LANGenFChmod_WUSR;
  LANGFChmod_XUSR := LANGenFChmod_XUSR;
  LANGFChmod_RGRP := LANGenFChmod_RGRP;
  LANGFChmod_WGRP := LANGenFChmod_WGRP;
  LANGFChmod_XGRP := LANGenFChmod_XGRP;
  LANGFChmod_ROTH := LANGenFChmod_ROTH;
  LANGFChmod_WOTH := LANGenFChmod_WOTH;
  LANGFChmod_XOTH := LANGenFChmod_XOTH;
  LANGFChmod_TextLabel := LANGenFChmod_TextLabel;
  LANGFChmod_FileLabel := LANGenFChmod_FileLabel;
  LANGFChown_Caption := LANGenFChown_Caption;
  LANGFChown_OwnerFrame := LANGenFChown_OwnerFrame;
  LANGFChown_GroupFrame := LANGenFChown_GroupFrame;
  LANGFChown_FileFrame := LANGenFChown_FileFrame;
  LANGFChown_ApplyRecursively := LANGenFChown_ApplyRecursively;

  LANGFSymlink_Caption := LANGenFSymlink_Caption;
  LANGFSymlink_ExistingFilename := LANGenFSymlink_ExistingFilename;
  LANGFSymlink_SymlinkFilename := LANGenFSymlink_SymlinkFilename;

  LANGmnuBookmarks_Caption := LANGenmnuBookmarks_Caption;
  LANGmiAddBookmark_Caption := LANGenmiAddBookmark_Caption;
  LANGmiEditBookmarks_Caption := LANGenmiEditBookmarks_Caption;
  LANGBookmarkPopupDelete_Caption := LANGenBookmarkPopupDelete_Caption;
  LANGmiPreferences_Caption := LANGenmiPreferences_Caption;
  LANGTheCurrentDirectoryAlreadyExistsInTheBookmarksList := LANGenTheCurrentDirectoryAlreadyExistsInTheBookmarksList;
  LANGSomeOtherInstanceChanged := LANGenSomeOtherInstanceChanged;

  LANGPreferences_Caption := LANGenPreferences_Caption;
  LANGPreferences_TitleLabel_Caption := LANGenPreferences_TitleLabel_Caption;
  LANGPreferences_GeneralPage := LANGenPreferences_GeneralPage;
  LANGPreferences_FontsPage := LANGenPreferences_FontsPage;
  LANGPreferences_ColorsPage := LANGenPreferences_ColorsPage;
  LANGPreferences_RowHeight := LANGenPreferences_RowHeight;
  LANGPreferences_NumHistoryItems := LANGenPreferences_NumHistoryItems;
  LANGPreferences_Default := LANGenPreferences_Default;
  LANGPreferences_ClearReadonlyAttribute := LANGenPreferences_ClearReadonlyAttribute;
  LANGPreferences_DisableMouseRenaming := LANGenPreferences_DisableMouseRenaming;
  LANGPreferences_ShowFiletypeIconsInList := LANGenPreferences_ShowFiletypeIconsInList;
  LANGPreferences_ExternalAppsLabel := LANGenPreferences_ExternalAppsLabel;
  LANGPreferences_Viewer := LANGenPreferences_Viewer;
  LANGPreferences_Editor := LANGenPreferences_Editor;
  LANGPreferences_Terminal := LANGenPreferences_Terminal;
  LANGPreferences_ListFont := LANGenPreferences_ListFont;
  LANGPreferences_Change := LANGenPreferences_Change;
  LANGPreferences_UseDefaultFont := LANGenPreferences_UseDefaultFont;
  LANGPreferences_Foreground := LANGenPreferences_Foreground;
  LANGPreferences_Background := LANGenPreferences_Background;
  LANGPreferences_NormalItem := LANGenPreferences_NormalItem;
  LANGPreferences_SetToDefaultToUseGTKThemeColors := LANGenPreferences_SetToDefaultToUseGTKThemeColors;
  LANGPreferences_Cursor := LANGenPreferences_Cursor;
  LANGPreferences_InactiveItem := LANGenPreferences_InactiveItem;
  LANGPreferences_SelectedItem := LANGenPreferences_SelectedItem;
  LANGPreferences_LinkItem := LANGenPreferences_LinkItem;
  LANGPreferences_LinkItemHint := LANGenPreferences_LinkItemHint;
  LANGPreferences_DotFileItem := LANGenPreferences_DotFileItem;
  LANGPreferences_DotFileItemHint := LANGenPreferences_DotFileItemHint;
  LANGPreferences_BrowseForApplication := LANGenPreferences_BrowseForApplication;
  LANGPreferences_DefaultS := LANGenPreferences_DefaultS;
  LANGPreferences_SelectFont := LANGenPreferences_SelectFont;

  LANGBookmarkButton_Tooltip := LANGenBookmarkButton_Tooltip;
  LANGUpButton_Tooltip := LANGenUpButton_Tooltip;
  LANGRootButton_Tooltip := LANGenRootButton_Tooltip;
  LANGHomeButton_Tooltip := LANGenHomeButton_Tooltip;
  LANGLeftEqualButton_Tooltip := LANGenLeftEqualButton_Tooltip;
  LANGRightEqualButton_Tooltip := LANGenRightEqualButton_Tooltip;
  LANGmiShowDirectorySizes_Caption := LANGenmiShowDirectorySizes_Caption;
  LANGmiTargetSource_Caption := LANGenmiTargetSource_Caption;
  LANGFileTypeDirectory := LANGenFileTypeDirectory;
  LANGFileTypeFile := LANGenFileTypeFile;
  LANGFileTypeMetafile := LANGenFileTypeMetafile;
  LANGPreferencesPanelsPage := LANGenPreferencesPanelsPage;
  LANGPreferencesApplicationsPage := LANGenPreferencesApplicationsPage;
  LANGPreferencesExperimentalPage := LANGenPreferencesExperimentalPage;
  LANGPreferencesSelectAllDirectoriesCheckBox_Caption := LANGenPreferencesSelectAllDirectoriesCheckBox_Caption;
  LANGPreferencesNewStyleAltOCheckBox_Caption := LANGenPreferencesNewStyleAltOCheckBox_Caption;
  LANGPreferencesNewStyleAltOCheckBox_Tooltip := LANGenPreferencesNewStyleAltOCheckBox_Tooltip;
  LANGPreferencesShowFuncButtonsCheckBox_Caption := LANGenPreferencesShowFuncButtonsCheckBox_Caption;
  LANGPreferencesSizeFormatLabel_Caption := LANGenPreferencesSizeFormatLabel_Caption;
  LANGPreferencesmiSizeFormat1 := LANGenPreferencesmiSizeFormat1;
  LANGPreferencesmiSizeFormat6 := LANGenPreferencesmiSizeFormat6;
  LANGPreferencesAutodetectXApp := LANGenPreferencesAutodetectXApp;
  LANGPreferencesAlwaysRunInTerminal := LANGenPreferencesAlwaysRunInTerminal;
  LANGPreferencesNeverRunInTerminal := LANGenPreferencesNeverRunInTerminal;
  LANGPreferencesCmdLineBehaviourLabel_Caption := LANGenPreferencesCmdLineBehaviourLabel_Caption;
  LANGPreferencesFeatures := LANGenPreferencesFeatures;
  LANGPreferencesDisableMouseRename_Tooltip := LANGenPreferencesDisableMouseRename_Tooltip;
  LANGPreferencesDisableFileTipsCheckBox_Caption := LANGenPreferencesDisableFileTipsCheckBox_Caption;
  LANGPreferencesDisableFileTipsCheckBox_Tooltip := LANGenPreferencesDisableFileTipsCheckBox_Tooltip;
  LANGPreferencesShow := LANGenPreferencesShow;
  LANGPreferencesDirsInBoldCheckBox_Caption := LANGenPreferencesDirsInBoldCheckBox_Caption;
  LANGPreferencesDisableDirectoryBracketsCheckBox_Caption := LANGenPreferencesDisableDirectoryBracketsCheckBox_Caption;
  LANGPreferencesOctalPermissionsCheckBox_Caption := LANGenPreferencesOctalPermissionsCheckBox_Caption;
  LANGPreferencesOctalPermissionsCheckBox_Tooltip := LANGenPreferencesOctalPermissionsCheckBox_Tooltip;
  LANGPreferencesMovement := LANGenPreferencesMovement;
  LANGPreferencesLynxLikeMotionCheckBox_Caption := LANGenPreferencesLynxLikeMotionCheckBox_Caption;
  LANGPreferencesInsertMovesDownCheckBox_Caption := LANGenPreferencesInsertMovesDownCheckBox_Caption;
  LANGPreferencesSpaceMovesDownCheckBox_Caption := LANGenPreferencesSpaceMovesDownCheckBox_Caption;
  LANGPreferencesViewer := LANGenPreferencesViewer;
  LANGPreferencesCommandSC := LANGenPreferencesCommandSC;
  LANGPreferencesUseInternalViewer := LANGenPreferencesUseInternalViewer;
  LANGPreferencesEditor := LANGenPreferencesEditor;
  LANGPreferencesTerminal := LANGenPreferencesTerminal;
  LANGPreferencesExperimentalFeatures := LANGenPreferencesExperimentalFeatures;
  LANGPreferencesExperimentalWarningLabel_Caption := LANGenPreferencesExperimentalWarningLabel_Caption;
  LANGPreferencesFocusRefreshCheckBox_Caption := LANGenPreferencesFocusRefreshCheckBox_Caption;
  LANGPreferencesFocusRefreshCheckBox_Tooltip := LANGenPreferencesFocusRefreshCheckBox_Tooltip;
  LANGPreferencesWMCompatModeCheckBox_Caption := LANGenPreferencesWMCompatModeCheckBox_Caption;
  LANGPreferencesWMCompatModeCheckBox_Tooltip := LANGenPreferencesWMCompatModeCheckBox_Tooltip;
  LANGPreferencesCompatUseLibcSystemCheckBox_Caption := LANGenPreferencesCompatUseLibcSystemCheckBox_Caption;
  LANGPreferencesCompatUseLibcSystemCheckBox_Tooltip := LANGenPreferencesCompatUseLibcSystemCheckBox_Tooltip;

  LANGmiSearchCaption2 := LANGenmiSearchCaption2;
  LANGmiNoMounterBarCaption := LANGenmiNoMounterBarCaption;
  LANGmiShowOneMounterBarCaption := LANGenmiShowOneMounterBarCaption;
  LANGmiShowTwoMounterBarCaption := LANGenmiShowTwoMounterBarCaption;
  LANGmnuNetworkCaption := LANGenmnuNetworkCaption;
  LANGmiConnectionsCaption := LANGenmiConnectionsCaption;
  LANGmiOpenConnectionCaption := LANGenmiOpenConnectionCaption;
  LANGmiQuickConnectCaption := LANGenmiQuickConnectCaption;
  LANGmnuPluginsCaption := LANGenmnuPluginsCaption;
  LANGmiTestPluginCaption := LANGenmiTestPluginCaption;
  LANGmiMounterSettingsCaption := LANGenmiMounterSettingsCaption;
  LANGmiColumnsCaption := LANGenmiColumnsCaption;
  LANGmiSavePositionCaption := LANGenmiSavePositionCaption;
  LANGmiMountCaption := LANGenmiMountCaption;
  LANGmiUmountCaption := LANGenmiUmountCaption;
  LANGmiEjectCaption := LANGenmiEjectCaption;
  LANGmiDuplicateTabCaption := LANGenmiDuplicateTabCaption;
  LANGmiCloseTabCaption := LANGenmiCloseTabCaption;
  LANGmiCloseAllTabsCaption := LANGenmiCloseAllTabsCaption;
  LANGCannotDetermineDestinationEngine := LANGenCannotDetermineDestinationEngine;
  LANGCannotLoadFile := LANGenCannotLoadFile;
  LANGMountPointDevice := LANGenMountPointDevice;
  LANGMountSC := LANGenMountSC;
  LANGNoPluginsFound := LANGenNoPluginsFound;
  LANGPluginAbout := LANGenPluginAbout;
  LANGCouldntOpenURI := LANGenCouldntOpenURI;
  LANGPluginAboutInside := LANGenPluginAboutInside;
  LANGAreYouSureCloseAllTabs := LANGenAreYouSureCloseAllTabs;
  LANGCouldntOpenURIArchive := LANGenCouldntOpenURIArchive;
  LANGThereIsNoModuleAvailable := LANGenThereIsNoModuleAvailable;
  LANGIgnoreError := LANGenIgnoreError;
  LANGErrorMount := LANGenErrorMount;
  LANGErrorUmount := LANGenErrorUmount;
  LANGErrorEject := LANGenErrorEject;

  LANGMounterPrefs_Caption := LANGenMounterPrefs_Caption;
  LANGMounterPrefs_TitleLabelCaption := LANGenMounterPrefs_TitleLabelCaption;
  LANGMounterPrefs_ListViewFrameCaption := LANGenMounterPrefs_ListViewFrameCaption;
  LANGMounterPrefs_MountName := LANGenMounterPrefs_MountName;
  LANGMounterPrefs_MountPoint := LANGenMounterPrefs_MountPoint;
  LANGMounterPrefs_Device := LANGenMounterPrefs_Device;
  LANGMounterPrefs_MoveUpButtonTooltip := LANGenMounterPrefs_MoveUpButtonTooltip;
  LANGMounterPrefs_MoveDownButtonTooltip := LANGenMounterPrefs_MoveDownButtonTooltip;
  LANGMounterPrefs_UseFSTabDefaultsCheckBox := LANGenMounterPrefs_UseFSTabDefaultsCheckBox;
  LANGMounterPrefs_UseFSTabDefaultsCheckBoxTooltip := LANGenMounterPrefs_UseFSTabDefaultsCheckBoxTooltip;
  LANGMounterPrefs_ToggleModeCheckBox := LANGenMounterPrefs_ToggleModeCheckBox;
  LANGMounterPrefs_ToggleModeCheckBoxTooltip := LANGenMounterPrefs_ToggleModeCheckBoxTooltip;
  LANGMounterPrefs_PropertiesFrameCaption := LANGenMounterPrefs_PropertiesFrameCaption;
  LANGMounterPrefs_DisplayTextLabelCaption := LANGenMounterPrefs_DisplayTextLabelCaption;
  LANGMounterPrefs_MountPointLabelCaption := LANGenMounterPrefs_MountPointLabelCaption;
  LANGMounterPrefs_MountDeviceLabelCaption := LANGenMounterPrefs_MountDeviceLabelCaption;
  LANGMounterPrefs_DeviceTypeLabelCaption := LANGenMounterPrefs_DeviceTypeLabelCaption;
  LANGMounterPrefs_miLocalDiskCaption := LANGenMounterPrefs_miLocalDiskCaption;
  LANGMounterPrefs_miRemovableCaption := LANGenMounterPrefs_miRemovableCaption;
  LANGMounterPrefs_miCDCaption := LANGenMounterPrefs_miCDCaption;
  LANGMounterPrefs_miFloppyCaption := LANGenMounterPrefs_miFloppyCaption;
  LANGMounterPrefs_miNetworkCaption := LANGenMounterPrefs_miNetworkCaption;
  LANGMounterPrefs_MountCommandLabelCaption := LANGenMounterPrefs_MountCommandLabelCaption;
  LANGMounterPrefs_UmountCommandLabelCaption := LANGenMounterPrefs_UmountCommandLabelCaption;
  LANGMounterPrefs_MountCommandEntryTooltip := LANGenMounterPrefs_MountCommandEntryTooltip;
  LANGMounterPrefs_UmountCommandEntryTooltip := LANGenMounterPrefs_UmountCommandEntryTooltip;
  LANGMounterPrefs_IconLabelCaption := LANGenMounterPrefs_IconLabelCaption;

  LANGConnMgr_Caption := LANGenConnMgr_Caption;
  LANGConnMgr_ConnectButton := LANGenConnMgr_ConnectButton;
  LANGConnMgr_OpenConnection := LANGenConnMgr_OpenConnection;
  LANGConnMgr_NameColumn := LANGenConnMgr_NameColumn;
  LANGConnMgr_URIColumn := LANGenConnMgr_URIColumn;
  LANGConnMgr_AddConnectionButtonCaption := LANGenConnMgr_AddConnectionButtonCaption;
  LANGConnMgr_AddConnectionButtonTooltip := LANGenConnMgr_AddConnectionButtonTooltip;
  LANGConnMgr_EditButtonCaption := LANGenConnMgr_EditButtonCaption;
  LANGConnMgr_EditButtonTooltip := LANGenConnMgr_EditButtonTooltip;
  LANGConnMgr_RemoveButtonCaption := LANGenConnMgr_RemoveButtonCaption;
  LANGConnMgr_RemoveButtonTooltip := LANGenConnMgr_RemoveButtonTooltip;
  LANGConnMgr_DoYouWantDelete := LANGenConnMgr_DoYouWantDelete;

  LANGConnProp_FTP := LANGenConnProp_FTP;
  LANGConnProp_SFTP := LANGenConnProp_SFTP;
  LANGConnProp_SMB := LANGenConnProp_SMB;
  LANGConnProp_HTTP := LANGenConnProp_HTTP;
  LANGConnProp_HTTPS := LANGenConnProp_HTTPS;
  LANGConnProp_Other := LANGenConnProp_Other;
  LANGConnProp_Caption := LANGenConnProp_Caption;
  LANGConnProp_VFSModule := LANGenConnProp_VFSModule;
  LANGConnProp_URI := LANGenConnProp_URI;
  LANGConnProp_URIEntryTooltip := LANGenConnProp_URIEntryTooltip;
  LANGConnProp_DetailedInformations := LANGenConnProp_DetailedInformations;
  LANGConnProp_Name := LANGenConnProp_Name;
  LANGConnProp_Server := LANGenConnProp_Server;
  LANGConnProp_Username := LANGenConnProp_Username;
  LANGConnProp_UserNameEntryTooltip := LANGenConnProp_UserNameEntryTooltip;
  LANGConnProp_Password := LANGenConnProp_Password;
  LANGConnProp_TargetDirectory := LANGenConnProp_TargetDirectory;
  LANGConnProp_ServiceType := LANGenConnProp_ServiceType; 
  LANGConnProp_MaskPassword := LANGenConnProp_MaskPassword; 
  LANGConnProp_MenuItemCaption := LANGenConnProp_MenuItemCaption; 

  LANGConnLogin_Caption := LANGenConnLogin_Caption; 
  LANGConnLogin_Login := LANGenConnLogin_Login;
  LANGConnLogin_ExperimentalWarningLabelCaption := LANGenConnLogin_ExperimentalWarningLabelCaption; 
  LANGConnLogin_Username := LANGenConnLogin_Username; 
  LANGConnLogin_Password := LANGenConnLogin_Password; 
  LANGConnLogin_AnonymousCheckButton := LANGenConnLogin_AnonymousCheckButton; 

  LANGColumns_Caption := LANGenColumns_Caption;
  LANGColumns_Title := LANGenColumns_Title;
  LANGColumns_MoveUpButtonTooltip := LANGenColumns_MoveUpButtonTooltip;
  LANGColumns_MoveDownButtonTooltip := LANGenColumns_MoveDownButtonTooltip; 
  LANGColumns_TitlesLongName := LANGenColumns_TitlesLongName; 
  LANGColumns_TitlesLongNameExt := LANGenColumns_TitlesLongNameExt; 
  LANGColumns_TitlesLongExt := LANGenColumns_TitlesLongExt;
  LANGColumns_TitlesLongSize := LANGenColumns_TitlesLongSize; 
  LANGColumns_TitlesLongDateTime := LANGenColumns_TitlesLongDateTime; 
  LANGColumns_TitlesLongDate := LANGenColumns_TitlesLongDate; 
  LANGColumns_TitlesLongTime := LANGenColumns_TitlesLongTime; 
  LANGColumns_TitlesLongUser := LANGenColumns_TitlesLongUser; 
  LANGColumns_TitlesLongGroup := LANGenColumns_TitlesLongGroup;
  LANGColumns_TitlesLongAttr := LANGenColumns_TitlesLongAttr; 
  LANGColumns_TitlesShortName := LANGenColumns_TitlesShortName; 
  LANGColumns_TitlesShortNameExt := LANGenColumns_TitlesShortNameExt; 
  LANGColumns_TitlesShortExt := LANGenColumns_TitlesShortExt;
  LANGColumns_TitlesShortSize := LANGenColumns_TitlesShortSize;
  LANGColumns_TitlesShortDateTime := LANGenColumns_TitlesShortDateTime;
  LANGColumns_TitlesShortDate := LANGenColumns_TitlesShortDate; 
  LANGColumns_TitlesShortTime := LANGenColumns_TitlesShortTime; 
  LANGColumns_TitlesShortUser := LANGenColumns_TitlesShortUser; 
  LANGColumns_TitlesShortGroup := LANGenColumns_TitlesShortGroup; 
  LANGColumns_TitlesShortAttr := LANGenColumns_TitlesShortAttr; 

  LANGTestPlugin_Caption := LANGenTestPlugin_Caption; 
  LANGTestPlugin_Title := LANGenTestPlugin_Title; 
  LANGTestPlugin_ExperimentalWarningLabelCaption := LANGenTestPlugin_ExperimentalWarningLabelCaption;
  LANGTestPlugin_Plugin := LANGenTestPlugin_Plugin; 
  LANGTestPlugin_Command := LANGenTestPlugin_Command; 
  LANGTestPlugin_Username := LANGenTestPlugin_Username;
  LANGTestPlugin_Password := LANGenTestPlugin_Password; 
  LANGTestPlugin_AnonymousCheckButton := LANGenTestPlugin_AnonymousCheckButton; 
  LANGTestPlugin_NoPluginsFound := LANGenTestPlugin_NoPluginsFound; 

  LANGRemoteWait_Caption := LANGenRemoteWait_Caption; 
  LANGRemoteWait_OperationInProgress := LANGenRemoteWait_OperationInProgress;
  LANGRemoteWait_ItemsFound := LANGenRemoteWait_ItemsFound; 

  LANGSearch_Bytes := LANGenSearch_Bytes; 
  LANGSearch_kB := LANGenSearch_kB; 
  LANGSearch_MB := LANGenSearch_MB; 
  LANGSearch_days := LANGenSearch_days;
  LANGSearch_weeks := LANGenSearch_weeks; 
  LANGSearch_months := LANGenSearch_months; 
  LANGSearch_years := LANGenSearch_years; 
  LANGSearch_Caption := LANGenSearch_Caption; 
  LANGSearch_General := LANGenSearch_General; 
  LANGSearch_Advanced := LANGenSearch_Advanced;
  LANGSearch_SearchResults := LANGenSearch_SearchResults; 
  LANGSearch_SearchFor := LANGenSearch_SearchFor; 
  LANGSearch_FileMaskEntryTooltip := LANGenSearch_FileMaskEntryTooltip; 
  LANGSearch_SearchIn := LANGenSearch_SearchIn; 
  LANGSearch_SearchArchivesCheckButton := LANGenSearch_SearchArchivesCheckButton;
  LANGSearch_FindText := LANGenSearch_FindText;
  LANGSearch_FindTextEntryTooltip := LANGenSearch_FindTextEntryTooltip;
  LANGSearch_CaseSensitiveCheckButton := LANGenSearch_CaseSensitiveCheckButton;
  LANGSearch_StayCurrentFSCheckButton := LANGenSearch_StayCurrentFSCheckButton;
  LANGSearch_CaseSensitiveMatchCheckButton := LANGenSearch_CaseSensitiveMatchCheckButton;
  LANGSearch_Size := LANGenSearch_Size;
  LANGSearch_Date := LANGenSearch_Date;
  LANGSearch_BiggerThan := LANGenSearch_BiggerThan;
  LANGSearch_SmallerThan := LANGenSearch_SmallerThan;
  LANGSearch_ModifiedBetweenRadioButton := LANGenSearch_ModifiedBetweenRadioButton;
  LANGSearch_NotModifiedAfterRadioButton := LANGenSearch_NotModifiedAfterRadioButton;
  LANGSearch_ModifiedLastRadioButton := LANGenSearch_ModifiedLastRadioButton;
  LANGSearch_ModifiedNotLastRadionButton := LANGenSearch_ModifiedNotLastRadionButton;
  LANGSearch_ModifiedBetweenEntry1 := LANGenSearch_ModifiedBetweenEntry1;
  LANGSearch_ViewButtonCaption := LANGenSearch_ViewButtonCaption;
  LANGSearch_NewSearchButtonCaption := LANGenSearch_NewSearchButtonCaption;
  LANGSearch_GoToFileButtonCaption := LANGenSearch_GoToFileButtonCaption;
  LANGSearch_FeedToListboxButtonCaption := LANGenSearch_FeedToListboxButtonCaption;
  LANGSearch_StatusSC := LANGenSearch_StatusSC;
  LANGSearch_Ready := LANGenSearch_Ready;
  LANGSearch_PreparingToSearch := LANGenSearch_PreparingToSearch;
  LANGSearch_SearchInProgress := LANGenSearch_SearchInProgress;
  LANGSearch_UserCancelled := LANGenSearch_UserCancelled;
  LANGSearch_SearchFinished := LANGenSearch_SearchFinished;
  LANGSearch_FilesFound := LANGenSearch_FilesFound;
  LANGSearch_And := LANGenSearch_And;
  
  LANGCloseOpenConnection := LANGenCloseOpenConnection;
  LANGDuplicateTabWarning := LANGenDuplicateTabWarning;
  LANGDontShowAgain := LANGenDontShowAgain;
  LANGSwitchOtherPanelWarning := LANGenSwitchOtherPanelWarning;
  LANGOpenConnectionsWarning := LANGenOpenConnectionsWarning;
  LANGmiDisconnect_Caption := LANGenmiDisconnect_Caption;
  LANGDisconnectButton_Tooltip := LANGenDisconnectButton_Tooltip;
  LANGLeaveArchiveButton_Tooltip := LANGenLeaveArchiveButton_Tooltip;
  LANGOpenTerminalButton_Tooltip := LANGenOpenTerminalButton_Tooltip;
  LANGOpenTerminalButton_Caption := LANGenOpenTerminalButton_Caption;
  LANGShowTextUIDsCheckBox_Caption := LANGenShowTextUIDsCheckBox_Caption;
  LANGShowTextUIDsCheckBox_Tooltip := LANGenShowTextUIDsCheckBox_Tooltip;
  
  LANGmiNewTab_Caption := LANGenmiNewTab_Caption;
  LANGFilePopupMenu_Properties := LANGenFilePopupMenu_Properties;
  LANGCommandEntry_Tooltip := LANGenCommandEntry_Tooltip;
  LANGmiFiles_Caption := LANGenmiFiles_Caption;
  
  LANGPasswordButton_Tooltip := LANGenPasswordButton_Tooltip;
  LANGHandleRunFromArchive_Bytes := LANGenHandleRunFromArchive_Bytes;
  LANGHandleRunFromArchive_FileTypeDesc_Unknown := LANGenHandleRunFromArchive_FileTypeDesc_Unknown;
  LANGHandleRunFromArchive_NotAssociated := LANGenHandleRunFromArchive_NotAssociated;
  LANGHandleRunFromArchive_SelfExecutable := LANGenHandleRunFromArchive_SelfExecutable;
  LANGHandleRunFromArchive_CouldntCreateTemporaryDirectory := LANGenHandleRunFromArchive_CouldntCreateTemporaryDirectory;
  LANGFRunFromVFS_Caption := LANGenFRunFromVFS_Caption;
  LANGFRunFromVFS_TitleLabel := LANGenFRunFromVFS_TitleLabel;
  LANGFRunFromVFS_FileNameLabel := LANGenFRunFromVFS_FileNameLabel;
  LANGFRunFromVFS_FileTypeLabel := LANGenFRunFromVFS_FileTypeLabel;
  LANGFRunFromVFS_SizeLabel := LANGenFRunFromVFS_SizeLabel;
  LANGFRunFromVFS_PackedSizeLabel := LANGenFRunFromVFS_PackedSizeLabel;
  LANGFRunFromVFS_DateLabel := LANGenFRunFromVFS_DateLabel;
  LANGFRunFromVFS_InfoLabel := LANGenFRunFromVFS_InfoLabel;
  LANGFRunFromVFS_OpensWithLabel := LANGenFRunFromVFS_OpensWithLabel;
  LANGFRunFromVFS_ExecuteButton := LANGenFRunFromVFS_ExecuteButton;
  LANGFRunFromVFS_ExecuteAllButton := LANGenFRunFromVFS_ExecuteAllButton;
  LANGFSetPassword_Caption := LANGenFSetPassword_Caption;
  LANGFSetPassword_Label1_Caption := LANGenFSetPassword_Label1_Caption;
  LANGFSetPassword_Label2_Caption := LANGenFSetPassword_Label2_Caption;
  LANGFSetPassword_ShowPasswordCheckButton := LANGenFSetPassword_ShowPasswordCheckButton;

  LANGCopyFileNamesToClipboard := LANGenCopyFileNamesToClipboard;
  LANGCopyFullPathNamesToClipboard := LANGenCopyFullPathNamesToClipboard;
  LANGCopyPathToClipboard := LANGenCopyPathToClipboard;
  LANGPreferences_DateFormatLabel_Caption := LANGenPreferences_DateFormatLabel_Caption;
  LANGPreferences_System := LANGenPreferences_System;
  LANGPreferences_Custom := LANGenPreferences_Custom;
  LANGPreferences_CustomDateFormatEntry_Tooltip := LANGenPreferences_CustomDateFormatEntry_Tooltip;
  LANGPreferences_TimeFormatLabel_Caption := LANGenPreferences_TimeFormatLabel_Caption;
  LANGPreferences_CustomTimeFormatEntry_Tooltip := LANGenPreferences_CustomTimeFormatEntry_Tooltip;
  LANGPreferences_DateTimeFormatLabel_Caption := LANGenPreferences_DateTimeFormatLabel_Caption;
  LANGPreferences_QuickRenameSkipExtCheckBox := LANGenPreferences_QuickRenameSkipExtCheckBox;
  LANGPreferences_QuickRenameSkipExtCheckBox_Tooltip := LANGenPreferences_QuickRenameSkipExtCheckBox_Tooltip;
  LANGPreferences_SortDirectoriesLikeFilesCheckBox := LANGenPreferences_SortDirectoriesLikeFilesCheckBox;
  LANGPreferences_SortDirectoriesLikeFilesCheckBox_Tooltip := LANGenPreferences_SortDirectoriesLikeFilesCheckBox_Tooltip;
  LANGPreferences_QuickSearchLabel_Caption := LANGenPreferences_QuickSearchLabel_Caption;
  LANGPreferences_QuickSearchOptionMenu_Tooltip := LANGenPreferences_QuickSearchOptionMenu_Tooltip;
  LANGPreferences_QuickSearch_Option1 := LANGenPreferences_QuickSearch_Option1;
  LANGPreferences_QuickSearch_Option2 := LANGenPreferences_QuickSearch_Option2;
  LANGPreferences_QuickSearch_Option3 := LANGenPreferences_QuickSearch_Option3;
  LANGPreferences_QuickSearch_Option4 := LANGenPreferences_QuickSearch_Option4;
  LANGPreferences_TempPathLabel_Caption := LANGenPreferences_TempPathLabel_Caption;
  LANGPreferences_VFSTempPathLabel_Caption := LANGenPreferences_VFSTempPathLabel_Caption;
  LANGPreferences_VFSTempPathEntry_Tooltip := LANGenPreferences_VFSTempPathEntry_Tooltip;

  LANGPreferences_RightClickSelectCheckBox := LANGenPreferences_RightClickSelectCheckBox;
  LANGPreferences_RightClickSelectCheckBox_Tooltip := LANGenPreferences_RightClickSelectCheckBox_Tooltip;
  LANGGtkMountOperation_ConnectAnonymously := LANGenGtkMountOperation_ConnectAnonymously;
  LANGGtkMountOperation_ConnectAsUser := LANGenGtkMountOperation_ConnectAsUser;
  LANGGtkMountOperation_Username := LANGenGtkMountOperation_Username;
  LANGGtkMountOperation_Domain := LANGenGtkMountOperation_Domain;
  LANGGtkMountOperation_Password := LANGenGtkMountOperation_Password;
  LANGGtkMountOperation_DoNotSavePassword :=  LANGenGtkMountOperation_DoNotSavePassword;
  LANGGtkMountOperation_ForgetPasswordImmediately := LANGenGtkMountOperation_ForgetPasswordImmediately;
  LANGGtkMountOperation_RememberPasswordUntilYouLogout := LANGenGtkMountOperation_RememberPasswordUntilYouLogout;
  LANGGtkMountOperation_SavePasswordInConnectionManager := LANGenGtkMountOperation_SavePasswordInConnectionManager;
  LANGGtkMountOperation_RememberForever := LANGenGtkMountOperation_RememberForever;
  LANGFSymlink_RelativePath := LANGenFSymlink_RelativePath;
  LANGFConnectionManager_DuplicateButton_Caption := LANGenFConnectionManager_DuplicateButton_Caption;
  LANGFConnectionManager_DuplicateButton_Tooltip := LANGenFConnectionManager_DuplicateButton_Tooltip;
  LANGFConnectionManager_DoNotSavePasswordsCheckBox_Label := LANGenFConnectionManager_DoNotSavePasswordsCheckBox_Label;
  LANGFConnectionManager_DoNotSavePasswordsCheckBox_Tooltip := LANGenFConnectionManager_DoNotSavePasswordsCheckBox_Tooltip;
  LANGFConnectionManager_DoNotSynchronizeKeyringCheckBox_Label := LANGenFConnectionManager_DoNotSynchronizeKeyringCheckBox_Label;
  LANGFConnectionManager_DoNotSynchronizeKeyringCheckBox_Tooltip := LANGenFConnectionManager_DoNotSynchronizeKeyringCheckBox_Tooltip;
  LANGFConnectionManager_DuplicateMenuItem_Caption := LANGenFConnectionManager_DuplicateMenuItem_Caption;
  LANGFQuickConnect_Caption := LANGenFQuickConnect_Caption;
  LANGFQuickConnect_TitleLabel_Caption := LANGenFQuickConnect_TitleLabel_Caption;
  LANGFQuickConnect_ConnectToURILabel_Caption := LANGenFQuickConnect_ConnectToURILabel_Caption;
  LANGLinkToS := LANGenLinkToS;
  LANGOpenDirectoryInBackgroundTab := LANGenOpenDirectoryInBackgroundTab;
  LANGTheActiveConnectionHasNotBeenSaved := LANGenTheActiveConnectionHasNotBeenSaved;
  LANGTheArchiveIsEncryptedAndRequiresPassword := LANGenTheArchiveIsEncryptedAndRequiresPassword;
end;

initialization
  AddTranslation('US', @SetTranslation);
  AddTranslation('EN', @SetTranslation);
  AddTranslation('en_US', @SetTranslation);
  AddTranslation('C', @SetTranslation);     //  Please don't add this line to your translations, it is default "C" locale (of course English)
end.
