               
#include <vdk/vdk.h>
#include "kill.xpm"

class MyForm: public VDKForm
{ 
  VDKCustomButton* helloButton;
  VDKCustomButton* closeButton;
  VDKLabel* label;
public:
  MyForm(VDKApplication* app, gchar* title):
    VDKForm(app,title) {}
  ~MyForm() {}
void Setup()
{
  VDKBox* box = new VDKBox(this);
  box->Add(helloButton = new VDKCustomButton(this,"Hello"));
  helloButton->SetTip("Says \"hello\"");
  box->Add(closeButton = new VDKCustomButton(this,(const char*) kill_xpm ,"DISMISS"));
  closeButton->SetTip("Closes hello application");
  box->Add(label = new VDKLabel(this," "));
  Add(box);
  SetSize(200,100);
}   
  
bool SayHello(VDKObject*)
{
  label->Caption="Hello world !"; return true;
}  

bool Quit(VDKObject*) { Close(); return true; }
  
DECLARE_SIGNAL_MAP(MyForm);  
};  
   

DEFINE_SIGNAL_MAP(MyForm,VDKForm)
  ON_SIGNAL(helloButton,clicked_signal,SayHello),
  ON_SIGNAL(closeButton,clicked_signal,Quit) 
END_SIGNAL_MAP       

   
 
class MyApp: public VDKApplication
{
  
public:
  MyApp(int* argc, char** argv): VDKApplication(argc,argv) {}
  ~MyApp() {}
  void Setup()
  {
    MainForm = new MyForm(this,"hello world");
    MainForm->Setup();
    MainForm->Show(); 
  }
}; 
 

int main (int argc, char *argv[])   
{
  MyApp app(&argc, argv); 
  app.Run();       
  return 0;  
}






