# -*- coding: utf-8 -*-
# This software is distributed under the two-clause BSD license.

import sys

if sys.version_info < (3, 8):
    import pkg_resources

    __version__ = pkg_resources.get_distribution('volatildap').version

else:
    import importlib.metadata

    __version__ = importlib.metadata.version('volatildap')

from .control import ProxyServer
from .core import TLSConfig
from .server import LdapServer

LOCALHOST_TLS_CONFIG = TLSConfig(
    root="""-----BEGIN CERTIFICATE-----
MIID2jCCAsKgAwIBAgIUAN5irJT39KnT3lnSZWQZK3efdgMwDQYJKoZIhvcNAQEL
BQAwMjEiMCAGA1UEAwwZU2VsZi1zaWduZWQgbG9jYWwgQ0EgUm9vdDEMMAoGA1UE
CwwDRGV2MB4XDTIwMTAwMTEyMjA1MVoXDTMwMDkyOTEyMjA1MVowMjEiMCAGA1UE
AwwZU2VsZi1zaWduZWQgbG9jYWwgQ0EgUm9vdDEMMAoGA1UECwwDRGV2MIIBIjAN
BgkqhkiG9w0BAQEFAAOCAQ8AMIIBCgKCAQEA14ROH69F4fonw4D4noJmj8zfDGyo
staum82rhHkl45uow3TirzKRtpZfGlK4OTbnLmnfPowOGSn9S5363PGD6AGKeISd
rfwvV7oWsErtT16+ZIW6UcgFFXrRulAHB5WsHk0UnKC80oMB51AwoEMSpila3uaN
uBCktT6jKExG3gL6svPxYXDdo90Og+NVYSueshF2M+i9ieAvoLMt3+v9diJlOc8y
3I5tzic7jwy4c2oykJBV7NyHRyzHIbW6g5TdgV7Khfa6MEosvI/ZYWeRddRfj+sa
c3l3ZedllxkMjClmhMqbnCyCybiaUUC+OAG2cuAY/AuZoJE5+7i4ap0xSwIDAQAB
o4HnMIHkMBIGA1UdEwEB/wQIMAYBAf8CAQEwDgYDVR0PAQH/BAQDAgEGMB0GA1Ud
DgQWBBS41orJFInbS5ylCTyPedkuXYIvuDBtBgNVHSMEZjBkgBS41orJFInbS5yl
CTyPedkuXYIvuKE2pDQwMjEiMCAGA1UEAwwZU2VsZi1zaWduZWQgbG9jYWwgQ0Eg
Um9vdDEMMAoGA1UECwwDRGV2ghQA3mKslPf0qdPeWdJlZBkrd592AzAwBgNVHR4E
KTAnoCUwEYIPLnZvbGF0aWxkYXAub3JnMBCCDnZvbGF0aWxkYXAub3JnMA0GCSqG
SIb3DQEBCwUAA4IBAQDUeEpJ1GBshmDAAU+8/R58yk1aPR7diTd9UFhj112dioyx
68VHyylNelpDRYtHWioDEY4HXiAjYskgNomXCS6wsJ9GxhVE0TrqpV5Cac/qMn4q
B7bL2xLPY0/6kuFKdQn+npYcDa+SEgme0Eo2ZHGCxxFLtHmweYP9KfkgzlQ9KEgc
N6YN6ydNOdW5fzMolzG7vtkImTN6H6X535m89m9w8YFlokyyOL+owZIh+fEIWd9f
KaAlJ5fUzFAkEAZ+pNKngcbAiPeTo+gJaVju+yVNyUT1nRt+nfJedv1vRuNmrAAM
oLOhxbep7D7Q4sIZw/5JIVOiqvfJSp7JUv60qgQu
-----END CERTIFICATE-----
""",
    chain=[
        """-----BEGIN CERTIFICATE-----
MIIDxzCCAq+gAwIBAgIBAjANBgkqhkiG9w0BAQsFADAyMSIwIAYDVQQDDBlTZWxm
LXNpZ25lZCBsb2NhbCBDQSBSb290MQwwCgYDVQQLDANEZXYwHhcNMjAxMDAxMTIy
MDUyWhcNMzAwOTI5MTIyMDUyWjAyMSIwIAYDVQQDDBlTZWxmLXNpZ25lZCBsb2Nh
bCBDQSBSb290MQwwCgYDVQQLDANEZXYwggEiMA0GCSqGSIb3DQEBAQUAA4IBDwAw
ggEKAoIBAQDwnjz/KgvWI8oIw7o80MCnjArd7cBCWluubsmpHTIHuM19+9m0DKq2
64iPu1aRWIJVmWT8KzL0UZX6DSw7eHVv70OrI1QVs7VN3yEh67EEA8H+cCNIaGxh
MsnFmqbh6V8dRZO9pJ8LZKgnCGofT4VHOE0KvEapHQ59yF2kMMFURsM5ap/BRuoT
7g8zrpC5QTBJI85lY8dEgP04ZAw0963y7NdmMSEaWFf2pmEBn2HCpqdjHANGzp1W
+8qXp2ROZIDmVozyNfDrZnlWv1QjwQDGNe/Rv/MCOKm3tpjakqTc5U5nePawRfdg
gYeG/taIdJp0y30WXznaLhwpwPV7atipAgMBAAGjgecwgeQwEgYDVR0TAQH/BAgw
BgEB/wIBADAOBgNVHQ8BAf8EBAMCAQYwHQYDVR0OBBYEFOIHgsJ0vMDhF6P9jisA
q2DTEhkIMG0GA1UdIwRmMGSAFLjWiskUidtLnKUJPI952S5dgi+4oTakNDAyMSIw
IAYDVQQDDBlTZWxmLXNpZ25lZCBsb2NhbCBDQSBSb290MQwwCgYDVQQLDANEZXaC
FADeYqyU9/Sp095Z0mVkGSt3n3YDMDAGA1UdHgQpMCegJTARgg8udm9sYXRpbGRh
cC5vcmcwEIIOdm9sYXRpbGRhcC5vcmcwDQYJKoZIhvcNAQELBQADggEBACEix+CG
EAqdWuApQVemZO+8CsYiwv8H2TXGc6Kl3xmjCKzCfYyKbAr6Egj+1TzuddUFccLP
T+ZIKrGMkENRMhhe9XHeP2rdK1QxlrhSqWoRt/Efn0CGPlxrwKeym5n9Nf8r0iJy
cUdDTxhF99HPW2bBfbsLX+S03l8u7dGNlPuoFEtPaLVau25K8Eorrag8KuqODv3O
f7bItdpfnklP6UovGbmvDp8hP5/bsljhBb8R3u/EhrqU61F1tVVLs92kz8fdiSlg
4zXeGPv4AjgxwFCRNfvKgAu3uR2OxrxuJ0OCoxsjmfcY/HGP8sxuH1Yhn9GaWVV0
WLLZ+kcsJ1FrAUA=
-----END CERTIFICATE-----
""",
    ],
    certificate="""-----BEGIN CERTIFICATE-----
MIIDgjCCAmqgAwIBAgIBAjANBgkqhkiG9w0BAQsFADAyMSIwIAYDVQQDDBlTZWxm
LXNpZ25lZCBsb2NhbCBDQSBSb290MQwwCgYDVQQLDANEZXYwHhcNMjAxMDAxMTIy
MDUyWhcNMzAwOTI5MTIyMDUyWjAxMSEwHwYDVQQDDBhsb2NhbGhvc3Qudm9sYXRp
bGRhcC5vcmcxDDAKBgNVBAsMA0RldjCCASIwDQYJKoZIhvcNAQEBBQADggEPADCC
AQoCggEBAOma6WnZjjBuQErNm2RPLkkL/rXnM3XE2xIzSQxmNXq2cLF/MrpSp8js
fl4wgBjIq0zUdBUQHail0PRX3/flr5w4x7LUyFwffC6GCNXHCNJn+oqUPH2P8+6Z
kRASiD5EG+OI5+5hXPZtc/qphlcYULc/4ySl0NUnJGXjCt1y9isCWM3tfJQZHMIT
cT2jjd0oprw1sxEtGY7vVk8J8yWC8rXjRD8VoIYdCQmKaIFE+PreCuJmu3w9pae2
1DvLRqHbXlwqfb15bUUiNMwi8iEytY2Rd2gVJp0PJwe19nOqcI/y76WCSA8v4EFh
WC8mCBErIHW9+LxYJry8iDtYSHHcfp8CAwEAAaOBozCBoDAjBgNVHREEHDAaghhs
b2NhbGhvc3Qudm9sYXRpbGRhcC5vcmcwHQYDVR0OBBYEFIMNcukT7FadiOVYdgZp
iOnQ0v8rMFoGA1UdIwRTMFGAFOIHgsJ0vMDhF6P9jisAq2DTEhkIoTakNDAyMSIw
IAYDVQQDDBlTZWxmLXNpZ25lZCBsb2NhbCBDQSBSb290MQwwCgYDVQQLDANEZXaC
AQIwDQYJKoZIhvcNAQELBQADggEBAJ6/CU/2ciyDvHTAlCu5tsjAkflabrAkWEVf
Bl7g1hcHV4Bl+wO0Sr1aG380LmaukWqQfwWp9B6Cu6/xNnGET7N1rcui+FqFCuCt
raBcevdc85Eg8zApOdf8IPyDq3GWSgNA3/GepepNE3MaTTEXx8+FEHnpLUNgfzeP
9aerXFJJm0V2r6zIGhHuRrAPguhhrXuiDUj9ZoF/lKnQOAlt8kNXWHdbqaIlUoOg
06yYm5ZmDDN9PxX+emGDnhPnuh/IRJiIwk2nQiMkxQEAyZFNus0KOwQ13uKVkZUQ
83GGvPV6UXcGcpxdpQq64kjkDuCdfvH4ACMPqDNhV/R4UzUhm6M=
-----END CERTIFICATE-----
""",
    key="""-----BEGIN PRIVATE KEY-----
MIIEvgIBADANBgkqhkiG9w0BAQEFAASCBKgwggSkAgEAAoIBAQDpmulp2Y4wbkBK
zZtkTy5JC/615zN1xNsSM0kMZjV6tnCxfzK6UqfI7H5eMIAYyKtM1HQVEB2opdD0
V9/35a+cOMey1MhcH3wuhgjVxwjSZ/qKlDx9j/PumZEQEog+RBvjiOfuYVz2bXP6
qYZXGFC3P+MkpdDVJyRl4wrdcvYrAljN7XyUGRzCE3E9o43dKKa8NbMRLRmO71ZP
CfMlgvK140Q/FaCGHQkJimiBRPj63griZrt8PaWnttQ7y0ah215cKn29eW1FIjTM
IvIhMrWNkXdoFSadDycHtfZzqnCP8u+lgkgPL+BBYVgvJggRKyB1vfi8WCa8vIg7
WEhx3H6fAgMBAAECggEAWROG+aPJglIoFd386O0Aez4lq/szNi8QUgpYSnAW6Gn0
4tnb4Axwij8TmJrp3Yl3OF6yvO1eQdaorONtNbvRkMJd86ULmYUv9xWI/OteQ8z+
TiVkQ4TGwS6xj+1hIk0aTVMBDXb22ci2ttg5r7BH5vhnhqvry7uXN3qxw+t4TsFl
zzMge38GvNglKZBQQxaaMPP3ejG8mkX3TJLt5KxlEOFuIvHiiDFM2wsenPPccDwt
cAukNnQFuln/hVEZpwl6zYaSXvk3DoEXZtrDuYYsuIThqVl3in4WtBAPJz1Lorhe
KUm5PmBwNfHHO86htiZJMgIwNgvDnpd6tCwNuyYXMQKBgQD5LF6E7YW7Ioihsrvi
/vxAT+Az9gnUHNL43PaQq3fAheRGFpXTPa7jQYPY+xG+dAcwvPi7RLKYs3No78S/
2dYrA4gkCfQkE9M/odmW1ZbJPvNbNfk0t923iEwOhoGerAo/zxG1NC7n664/s+jd
7w/Rr9Jt8gr6Lih5zda6uA2wwwKBgQDwAVoHdhCP006OC3lHYiEJWZCuuAtftiVy
F5j2gg06H7PvIvJbU6jV5PSI2CXlpKSuDab/EZN9aPeIO7sj9yGuSRxMFM2G5+sO
5h7g79fuNJTJQdUg6oYZ2wIz52CPLjg2h9PlHVPMPYDON0ftAkndFMPVcmMJ02hN
AJVDpg8c9QKBgQC/pB1qNVimji/x1YrmUmDmgciZjkEO78BfgWrt58MpwpDISzSe
jJGG3euvJaMHDSw+kwjm1zZZdaNs8QQs3jj3SjcaKMGqQck25p94f/wB+jWnUELE
Biozr1N31IG67OzRGMywxlrRKxYQjqmqj+RlzMmWoBNLSdb9n4/oegiliwKBgAtU
pQFxK3r+yNif5gvesByW4+O7wJ22JbJrNsd8gE9cK8yAY9y36GKguoKzYaajzTqC
Xn3wQHxNNlJyL3WVNzvZK8LTwJg73rcHWjHYYONYDCYsO3mgWNBjrIjyxXY9Al5g
rzpD1i7wQGJ77aNc1kvfrRconVBbcLMh8eoNruz5AoGBAOuMEusCURo8XbKFQfu2
yi1TW1s1Oc3icvZFlLiNxUk+JDPjV6+KtJgGgdBWyhDTldsqdSO8tlwU626yANQG
xSFWF3tN34jbAl//jVkiYY8TELc8vTy7NxlrEFWZWzm2vDiBaweu/QRlRI6b7BDK
+hneY9lzJ85H1Df29M4WvT8e
-----END PRIVATE KEY-----
""",
)
