/*
 * Decompiled with CFR 0.152.
 */
package ptolemy.plot;

import java.awt.Color;
import java.awt.Container;
import java.awt.Dimension;
import java.awt.EventQueue;
import java.awt.FlowLayout;
import java.awt.Font;
import java.awt.FontMetrics;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Rectangle;
import java.awt.RenderingHints;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.KeyEvent;
import java.awt.event.KeyListener;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.awt.event.MouseMotionListener;
import java.awt.image.BufferedImage;
import java.awt.print.PageFormat;
import java.awt.print.Printable;
import java.awt.print.PrinterException;
import java.awt.print.PrinterJob;
import java.io.BufferedOutputStream;
import java.io.BufferedReader;
import java.io.BufferedWriter;
import java.io.DataInputStream;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.PrintWriter;
import java.io.Writer;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.Enumeration;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.Vector;
import javax.print.attribute.HashPrintRequestAttributeSet;
import javax.swing.ImageIcon;
import javax.swing.JButton;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.SwingUtilities;
import ptolemy.plot.EPSGraphics;
import ptolemy.plot.PlotApplet;
import ptolemy.plot.PlotFormatter;
import ptolemy.util.FileUtilities;
import ptolemy.util.StringUtilities;

public class PlotBox
extends JPanel
implements Printable {
    public static final String PTPLOT_RELEASE = "5.7";
    protected transient double _yMax = 0.0;
    protected transient double _yMin = 0.0;
    protected transient double _xMax = 0.0;
    protected transient double _xMin = 0.0;
    protected double _padding = 0.05;
    protected transient boolean _xRangeGiven = false;
    protected transient boolean _yRangeGiven = false;
    protected transient boolean _rangesGivenByZooming = false;
    protected double _xlowgiven;
    protected double _xhighgiven;
    protected double _ylowgiven;
    protected double _yhighgiven;
    protected double _xBottom = Double.MAX_VALUE;
    protected double _xTop = -1.7976931348623157E308;
    protected double _yBottom = Double.MAX_VALUE;
    protected double _yTop = -1.7976931348623157E308;
    protected boolean _xlog = false;
    protected boolean _ylog = false;
    protected static final double _LOG10SCALE = 1.0 / Math.log(10.0);
    protected boolean _grid = true;
    protected boolean _wrap = false;
    protected double _wrapHigh;
    protected double _wrapLow;
    protected Color _background = Color.white;
    protected Color _foreground = Color.black;
    protected int _topPadding = 10;
    protected int _bottomPadding = 5;
    protected int _rightPadding = 10;
    protected int _leftPadding = 10;
    protected int _ulx = 1;
    protected int _uly = 1;
    protected int _lrx = 100;
    protected int _lry = 100;
    protected Rectangle _specifiedPlotRectangle = null;
    protected double _yscale = 1.0;
    protected double _xscale = 1.0;
    protected boolean _usecolor = true;
    protected static Color[] _colors = new Color[]{new Color(0xFF0000), new Color(255), new Color(43690), new Color(0), new Color(16753920), new Color(5473931), new Color(16744272), new Color(4565791), new Color(9454125), new Color(0xA0A0A0), new Color(0x14FF14), new Color(0xFFFF00)};
    protected int _width = 500;
    protected int _height = 300;
    protected int _preferredWidth = 500;
    protected int _preferredHeight = 300;
    public URL _documentBase = null;
    private boolean _actionsDeferred = false;
    private List _deferredActions;
    private String _filespec = null;
    private static final Color _boxColor = Color.orange;
    private double _ytickMax = 0.0;
    private double _ytickMin = 0.0;
    private double _xtickMax = 0.0;
    private double _xtickMin = 0.0;
    private int _yExp = 0;
    private int _xExp = 0;
    private double _ytickscale = 0.0;
    private double _xtickscale = 0.0;
    private Font _labelFont = null;
    private Font _superscriptFont = null;
    private Font _titleFont = null;
    private FontMetrics _labelFontMetrics = null;
    private FontMetrics _superscriptFontMetrics = null;
    private FontMetrics _titleFontMetrics = null;
    private transient int _gridCurJuke = 0;
    private transient double _gridBase = 0.0;
    private transient String[] _errorMsg;
    private String _xlabel;
    private String _ylabel;
    private String _title;
    private Vector _legendStrings = new Vector();
    private Vector _legendDatasets = new Vector();
    private Vector _xticks = null;
    private Vector _xticklabels = null;
    private Vector _yticks = null;
    private Vector _yticklabels = null;
    private transient JButton _fillButton = null;
    private transient JButton _formatButton = null;
    boolean _originalXRangeGiven = false;
    boolean _originalYRangeGiven = false;
    double _originalXlow = 0.0;
    double _originalXhigh = 0.0;
    double _originalYlow = 0.0;
    double _originalYhigh = 0.0;
    protected transient BufferedImage _plotImage = null;
    private transient JButton _printButton = null;
    private transient JButton _resetButton = null;
    private transient int _zoomx = -1;
    private transient int _zoomy = -1;
    private transient int _zoomxn = -1;
    private transient int _zoomyn = -1;
    private transient boolean _zoomin = false;
    private transient boolean _zoomout = false;
    private transient boolean _drawn = false;
    private transient boolean _zooming = false;

    public String ReadPlotApplet() {
        String string = "error\nReadApplet() not implemented\nNO SENSIBLE USER INTERACTION PRESENT";
        return string;
    }

    public PlotBox() {
        this.setOpaque(true);
        this.setLayout(new FlowLayout(2, 2, 2));
        this.addMouseListener(new ZoomListener());
        this.addKeyListener(new CommandListener());
        this.addMouseMotionListener(new DragListener());
        this._measureFonts();
    }

    public synchronized void addLegend(int n, String string) {
        this._plotImage = null;
        if (string == null || string.equals("")) {
            return;
        }
        this._legendStrings.addElement(string);
        this._legendDatasets.addElement(n);
    }

    public synchronized void addXTick(String string, double d) {
        this._plotImage = null;
        if (this._xticks == null) {
            this._xticks = new Vector();
            this._xticklabels = new Vector();
        }
        this._xticks.addElement(d);
        this._xticklabels.addElement(string);
    }

    public synchronized void addYTick(String string, double d) {
        this._plotImage = null;
        if (this._yticks == null) {
            this._yticks = new Vector();
            this._yticklabels = new Vector();
        }
        this._yticks.addElement(d);
        this._yticklabels.addElement(string);
    }

    public synchronized void clear(boolean bl) {
        this._plotImage = null;
        this._xBottom = Double.MAX_VALUE;
        this._xTop = -1.7976931348623157E308;
        this._yBottom = Double.MAX_VALUE;
        this._yTop = -1.7976931348623157E308;
        if (bl) {
            this._yMax = 0.0;
            this._yMin = 0.0;
            this._xMax = 0.0;
            this._xMin = 0.0;
            this._xRangeGiven = false;
            this._yRangeGiven = false;
            this._originalXRangeGiven = false;
            this._originalYRangeGiven = false;
            this._rangesGivenByZooming = false;
            this._xlog = false;
            this._ylog = false;
            this._grid = true;
            this._wrap = false;
            this._usecolor = true;
            this._filespec = null;
            this._xlabel = null;
            this._ylabel = null;
            this._title = null;
            this._legendStrings = new Vector();
            this._legendDatasets = new Vector();
            this._xticks = null;
            this._xticklabels = null;
            this._yticks = null;
            this._yticklabels = null;
        }
    }

    public synchronized void clearLegends() {
        this._plotImage = null;
        this._legendStrings = new Vector();
        this._legendDatasets = new Vector();
    }

    public void deferIfNecessary(Runnable runnable) {
        if (EventQueue.isDispatchThread()) {
            runnable.run();
        } else {
            if (this._deferredActions == null) {
                this._deferredActions = new LinkedList();
            }
            this._deferredActions.add(runnable);
            if (!this._actionsDeferred) {
                Runnable runnable2 = new Runnable(){

                    public void run() {
                        PlotBox.this._executeDeferredActions();
                    }
                };
                try {
                    SwingUtilities.invokeLater(runnable2);
                }
                catch (Exception exception) {
                    // empty catch block
                }
                this._actionsDeferred = true;
            }
        }
    }

    public synchronized void export(OutputStream outputStream) {
        try {
            EPSGraphics ePSGraphics = new EPSGraphics(outputStream, this._width, this._height);
            this._drawPlot(ePSGraphics, false);
            ePSGraphics.showpage();
        }
        catch (RuntimeException runtimeException) {
            String string = "Export failed: " + runtimeException.getMessage();
            JOptionPane.showMessageDialog(this, string, "Ptolemy Plot Message", 0);
            throw (RuntimeException)runtimeException.fillInStackTrace();
        }
    }

    public synchronized BufferedImage exportImage() {
        Rectangle rectangle = new Rectangle(this._preferredWidth, this._preferredHeight);
        return this.exportImage(new BufferedImage(rectangle.width, rectangle.height, 2), rectangle, this._defaultImageRenderingHints(), false);
    }

    public synchronized BufferedImage exportImage(Rectangle rectangle) {
        return this.exportImage(new BufferedImage(rectangle.width, rectangle.height, 2), rectangle, this._defaultImageRenderingHints(), false);
    }

    public synchronized BufferedImage exportImage(BufferedImage bufferedImage, Rectangle rectangle, RenderingHints renderingHints, boolean bl) {
        Graphics2D graphics2D = bufferedImage.createGraphics();
        graphics2D.addRenderingHints(this._defaultImageRenderingHints());
        if (!bl) {
            graphics2D.setColor(Color.white);
            graphics2D.fill(rectangle);
        }
        this._drawPlot(graphics2D, false, rectangle);
        return bufferedImage;
    }

    public synchronized BufferedImage exportImage(BufferedImage bufferedImage) {
        return this.exportImage(bufferedImage, new Rectangle(bufferedImage.getWidth(), bufferedImage.getHeight()), this._defaultImageRenderingHints(), true);
    }

    public synchronized void fillPlot() {
        this.setXRange(this._xBottom, this._xTop);
        this.setYRange(this._yBottom, this._yTop);
        this.repaint();
    }

    public boolean getColor() {
        return this._usecolor;
    }

    public Color[] getColors() {
        return _colors;
    }

    public static Color getColorByName(String string) {
        try {
            if (string.startsWith("#")) {
                string = string.substring(1);
            }
            Color color = new Color(Integer.parseInt(string, 16));
            return color;
        }
        catch (NumberFormatException numberFormatException) {
            String[][] stringArrayArray = new String[][]{{"black", "00000"}, {"white", "ffffff"}, {"red", "ff0000"}, {"green", "00ff00"}, {"blue", "0000ff"}, {"yellow", "ffff00"}};
            for (int i = 0; i < stringArrayArray.length; ++i) {
                if (!string.equals(stringArrayArray[i][0])) continue;
                try {
                    Color color = new Color(Integer.parseInt(stringArrayArray[i][1], 16));
                    return color;
                }
                catch (NumberFormatException numberFormatException2) {
                    // empty catch block
                }
            }
            return null;
        }
    }

    public String getDataurl() {
        return this._filespec;
    }

    public URL getDocumentBase() {
        return this._documentBase;
    }

    public boolean getGrid() {
        return this._grid;
    }

    public synchronized String getLegend(int n) {
        int n2 = this._legendDatasets.indexOf(n, 0);
        if (n2 != -1) {
            return (String)this._legendStrings.elementAt(n2);
        }
        return null;
    }

    public synchronized int getLegendDataset(String string) {
        int n = this._legendStrings.indexOf(string);
        if (n == -1) {
            return -1;
        }
        return (Integer)this._legendDatasets.get(n);
    }

    public Rectangle getPlotRectangle() {
        return new Rectangle(this._ulx, this._uly, this._lrx - this._ulx, this._lry - this._uly);
    }

    public synchronized Dimension getPreferredSize() {
        return new Dimension(this._preferredWidth, this._preferredHeight);
    }

    public synchronized String getTitle() {
        if (this._title == null) {
            return "";
        }
        return this._title;
    }

    public synchronized double[] getXAutoRange() {
        double[] dArray = new double[]{this._xBottom, this._xTop};
        return dArray;
    }

    public synchronized String getXLabel() {
        return this._xlabel;
    }

    public boolean getXLog() {
        return this._xlog;
    }

    public synchronized double[] getXRange() {
        double[] dArray = new double[2];
        if (this._xRangeGiven) {
            dArray[0] = this._xlowgiven;
            dArray[1] = this._xhighgiven;
        } else {
            dArray[0] = this._xMin + (this._xMax - this._xMin) * this._padding;
            dArray[1] = this._xMax - (this._xMax - this._xMin) * this._padding;
        }
        return dArray;
    }

    public synchronized Vector[] getXTicks() {
        if (this._xticks == null) {
            return null;
        }
        Vector[] vectorArray = new Vector[]{this._xticks, this._xticklabels};
        return vectorArray;
    }

    public synchronized double[] getYAutoRange() {
        double[] dArray = new double[]{this._yBottom, this._yTop};
        return dArray;
    }

    public String getYLabel() {
        return this._ylabel;
    }

    public boolean getYLog() {
        return this._ylog;
    }

    public synchronized double[] getYRange() {
        double[] dArray = new double[2];
        if (this._yRangeGiven) {
            dArray[0] = this._ylowgiven;
            dArray[1] = this._yhighgiven;
        } else {
            dArray[0] = this._yMin + (this._yMax - this._yMin) * this._padding;
            dArray[1] = this._yMax - (this._yMax - this._yMin) * this._padding;
        }
        return dArray;
    }

    public synchronized Vector[] getYTicks() {
        if (this._yticks == null) {
            return null;
        }
        Vector[] vectorArray = new Vector[]{this._yticks, this._yticklabels};
        return vectorArray;
    }

    public void init() {
        this.setButtons(true);
        if (this._filespec != null) {
            this.parseFile(this._filespec, this._documentBase);
        }
    }

    public synchronized void paintComponent(Graphics graphics) {
        BufferedImage bufferedImage = this._plotImage;
        if (bufferedImage == null) {
            Rectangle rectangle = this.getBounds();
            this._plotImage = bufferedImage = new BufferedImage(rectangle.width, rectangle.height, 5);
            Graphics2D graphics2D = bufferedImage.createGraphics();
            super.paintComponent(graphics2D);
            this._drawPlot(graphics2D, true);
        }
        graphics.drawImage(bufferedImage, 0, 0, null);
    }

    public void parseFile(String string) {
        this.parseFile(string, null);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public synchronized void parseFile(String string, URL uRL) {
        Object object;
        DataInputStream dataInputStream = null;
        if (string == null || string.length() == 0) {
            dataInputStream = new DataInputStream(System.in);
        } else {
            try {
                object = null;
                if (uRL == null && this._documentBase != null) {
                    uRL = this._documentBase;
                }
                if (uRL == null) {
                    object = new URL(string);
                } else {
                    try {
                        object = new URL(uRL, string);
                    }
                    catch (NullPointerException nullPointerException) {
                        object = new URL(string);
                    }
                }
                dataInputStream = new DataInputStream(((URL)object).openStream());
            }
            catch (MalformedURLException malformedURLException) {
                try {
                    dataInputStream = new DataInputStream(new FileInputStream(string));
                }
                catch (FileNotFoundException fileNotFoundException) {
                    this._errorMsg = new String[2];
                    this._errorMsg[0] = "File not found: " + string;
                    this._errorMsg[1] = fileNotFoundException.getMessage();
                    return;
                }
                catch (SecurityException securityException) {
                    this._errorMsg = new String[2];
                    this._errorMsg[0] = "Security Exception: " + string;
                    this._errorMsg[1] = securityException.getMessage();
                    return;
                }
            }
            catch (IOException iOException) {
                this._errorMsg = new String[3];
                this._errorMsg[0] = "Failure opening URL: ";
                this._errorMsg[1] = " " + string;
                this._errorMsg[2] = iOException.getMessage();
                return;
            }
        }
        try {
            object = new BufferedReader(new InputStreamReader(dataInputStream));
            String string2 = ((BufferedReader)object).readLine();
            while (string2 != null) {
                this._parseLine(string2);
                string2 = ((BufferedReader)object).readLine();
            }
        }
        catch (MalformedURLException malformedURLException) {
            this._errorMsg = new String[2];
            this._errorMsg[0] = "Malformed URL: " + string;
            this._errorMsg[1] = malformedURLException.getMessage();
            return;
        }
        catch (IOException iOException) {
            this._errorMsg = new String[2];
            this._errorMsg[0] = "Failure reading data: " + string;
            this._errorMsg[1] = iOException.getMessage();
            this._errorMsg[1] = iOException.getMessage();
        }
        finally {
            try {
                dataInputStream.close();
            }
            catch (IOException iOException) {}
        }
    }

    public synchronized int print(Graphics graphics, PageFormat pageFormat, int n) throws PrinterException {
        if (graphics == null) {
            return 1;
        }
        if (n >= 1) {
            return 1;
        }
        Graphics2D graphics2D = (Graphics2D)graphics;
        double d = pageFormat.getImageableWidth() / (double)this.getWidth();
        double d2 = pageFormat.getImageableHeight() / (double)this.getHeight();
        double d3 = Math.min(d, d2);
        graphics2D.translate((int)pageFormat.getImageableX(), (int)pageFormat.getImageableY());
        graphics2D.scale(d3, d3);
        this._drawPlot(graphics, true);
        return 0;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public synchronized void read(InputStream inputStream) throws IOException {
        try {
            BufferedReader bufferedReader = new BufferedReader(new InputStreamReader(inputStream));
            try {
                String string = bufferedReader.readLine();
                while (string != null) {
                    this._parseLine(string);
                    string = bufferedReader.readLine();
                }
            }
            finally {
                bufferedReader.close();
            }
        }
        catch (IOException iOException) {
            this._errorMsg = new String[2];
            this._errorMsg[0] = "Failure reading input data.";
            this._errorMsg[1] = iOException.getMessage();
            throw iOException;
        }
    }

    public synchronized void read(String string) {
        this._parseLine(string);
    }

    public synchronized void removeLegend(int n) {
        int n2 = this._legendDatasets.size();
        int n3 = -1;
        boolean bl = false;
        for (int i = 0; i < n2 && !bl; ++i) {
            if ((Integer)this._legendDatasets.get(i) != n) continue;
            n3 = i;
            bl = true;
        }
        if (bl) {
            this._legendDatasets.remove(n3);
            this._legendStrings.remove(n3);
        }
    }

    public synchronized void renameLegend(int n, String string) {
        int n2 = this._legendDatasets.indexOf(n, 0);
        if (n2 != -1) {
            this._legendStrings.setElementAt(string, n2);
            this._plotImage = null;
        }
    }

    public synchronized void resetAxes() {
        this.setXRange(this._originalXlow, this._originalXhigh);
        this.setYRange(this._originalYlow, this._originalYhigh);
        this.repaint();
    }

    public void samplePlot() {
    }

    public synchronized void setBackground(Color color) {
        this._plotImage = null;
        this._background = color;
        super.setBackground(this._background);
    }

    public synchronized void setBounds(int n, int n2, int n3, int n4) {
        this._width = n3;
        this._height = n4;
        this._plotImage = null;
        super.setBounds(n, n2, this._width, this._height);
    }

    public synchronized void setButtons(boolean bl) {
        ImageIcon imageIcon;
        URL uRL;
        this._plotImage = null;
        if (this._printButton == null) {
            uRL = null;
            try {
                uRL = FileUtilities.nameToURL("$CLASSPATH/ptolemy/plot/img/print.gif", null, null);
            }
            catch (IOException iOException) {
                iOException.printStackTrace();
            }
            if (uRL != null) {
                imageIcon = new ImageIcon(uRL);
                this._printButton = new JButton(imageIcon);
                this._printButton.setBorderPainted(false);
            } else {
                this._printButton = new JButton("P");
            }
            this._printButton.setPreferredSize(new Dimension(20, 20));
            this._printButton.setToolTipText("Print the plot.");
            this._printButton.addActionListener(new ButtonListener());
            this.add(this._printButton);
        }
        this._printButton.setVisible(bl);
        if (this._resetButton == null) {
            uRL = null;
            try {
                uRL = FileUtilities.nameToURL("$CLASSPATH/ptolemy/plot/img/reset.gif", null, null);
            }
            catch (IOException iOException) {
                iOException.printStackTrace();
            }
            if (uRL != null) {
                imageIcon = new ImageIcon(uRL);
                this._resetButton = new JButton(imageIcon);
                this._resetButton.setBorderPainted(false);
            } else {
                this._resetButton = new JButton("R");
            }
            this._resetButton.setPreferredSize(new Dimension(20, 20));
            this._resetButton.setToolTipText("Reset X and Y ranges to their original values");
            this._resetButton.addActionListener(new ButtonListener());
            this.add(this._resetButton);
        }
        this._resetButton.setVisible(bl);
        if (this._formatButton == null) {
            uRL = null;
            try {
                uRL = FileUtilities.nameToURL("$CLASSPATH/ptolemy/plot/img/format.gif", null, null);
            }
            catch (IOException iOException) {
                iOException.printStackTrace();
            }
            if (uRL != null) {
                imageIcon = new ImageIcon(uRL);
                this._formatButton = new JButton(imageIcon);
                this._formatButton.setBorderPainted(false);
            } else {
                this._formatButton = new JButton("S");
            }
            this._formatButton.setPreferredSize(new Dimension(20, 20));
            this._formatButton.setToolTipText("Set the plot format");
            this._formatButton.addActionListener(new ButtonListener());
            this.add(this._formatButton);
        }
        this._formatButton.setVisible(bl);
        if (this._fillButton == null) {
            uRL = null;
            try {
                uRL = FileUtilities.nameToURL("$CLASSPATH/ptolemy/plot/img/fill.gif", null, null);
            }
            catch (IOException iOException) {
                iOException.printStackTrace();
            }
            if (uRL != null) {
                imageIcon = new ImageIcon(uRL);
                this._fillButton = new JButton(imageIcon);
                this._fillButton.setBorderPainted(false);
            } else {
                this._fillButton = new JButton("F");
            }
            this._fillButton.setPreferredSize(new Dimension(20, 20));
            this._fillButton.setToolTipText("Rescale the plot to fit the data");
            this._fillButton.addActionListener(new ButtonListener());
            this.add(this._fillButton);
        }
        this._fillButton.setVisible(bl);
    }

    public synchronized void setColor(boolean bl) {
        this._plotImage = null;
        this._usecolor = bl;
    }

    public synchronized void setColors(Color[] colorArray) {
        this._plotImage = null;
        _colors = colorArray;
    }

    public void setDataurl(String string) {
        this._filespec = string;
    }

    public void setDocumentBase(URL uRL) {
        this._documentBase = uRL;
    }

    public synchronized void setForeground(Color color) {
        this._plotImage = null;
        this._foreground = color;
        super.setForeground(this._foreground);
    }

    public synchronized void setGrid(boolean bl) {
        this._plotImage = null;
        this._grid = bl;
    }

    public synchronized void setLabelFont(String string) {
        this._plotImage = null;
        this._labelFont = Font.decode(string);
        this._labelFontMetrics = this.getFontMetrics(this._labelFont);
    }

    public synchronized void setPlotRectangle(Rectangle rectangle) {
        this._plotImage = null;
        this._specifiedPlotRectangle = rectangle;
    }

    public synchronized void setSize(int n, int n2) {
        this._plotImage = null;
        this._width = n;
        this._height = n2;
        this._preferredWidth = n;
        this._preferredHeight = n2;
        super.setSize(n, n2);
    }

    public synchronized void setTitle(String string) {
        this._plotImage = null;
        this._title = string;
    }

    public synchronized void setTitleFont(String string) {
        this._plotImage = null;
        this._titleFont = Font.decode(string);
        this._titleFontMetrics = this.getFontMetrics(this._titleFont);
    }

    public synchronized void setWrap(boolean bl) {
        this._plotImage = null;
        this._wrap = bl;
        if (!this._xRangeGiven) {
            if (this._xBottom > this._xTop) {
                this.setXRange(0.0, 0.0);
            } else {
                this.setXRange(this._xBottom, this._xTop);
            }
        }
        this._wrapLow = this._xlowgiven;
        this._wrapHigh = this._xhighgiven;
    }

    public synchronized void setXLabel(String string) {
        this._plotImage = null;
        this._xlabel = string;
    }

    public synchronized void setXLog(boolean bl) {
        this._plotImage = null;
        this._xlog = bl;
    }

    public synchronized void setXRange(double d, double d2) {
        this._plotImage = null;
        this._xRangeGiven = true;
        this._xlowgiven = d;
        this._xhighgiven = d2;
        this._setXRange(d, d2);
    }

    public synchronized void setYLabel(String string) {
        this._plotImage = null;
        this._ylabel = string;
    }

    public synchronized void setYLog(boolean bl) {
        this._plotImage = null;
        this._ylog = bl;
    }

    public synchronized void setYRange(double d, double d2) {
        this._plotImage = null;
        this._yRangeGiven = true;
        this._ylowgiven = d;
        this._yhighgiven = d2;
        this._setYRange(d, d2);
    }

    public void write(OutputStream outputStream) {
        this.write(outputStream, null);
    }

    public synchronized void write(OutputStream outputStream, String string) {
        this.write(new OutputStreamWriter(outputStream), string);
    }

    public synchronized void write(Writer writer, String string) {
        PrintWriter printWriter = new PrintWriter((Writer)new BufferedWriter(writer), false);
        if (string == null) {
            printWriter.println("<?xml version=\"1.0\" standalone=\"yes\"?>");
            printWriter.println("<!DOCTYPE plot PUBLIC \"-//UC Berkeley//DTD PlotML 1//EN\"");
            printWriter.println("    \"http://ptolemy.eecs.berkeley.edu/xml/dtd/PlotML_1.dtd\">");
        } else {
            printWriter.println("<?xml version=\"1.0\" standalone=\"no\"?>");
            printWriter.println("<!DOCTYPE plot SYSTEM \"" + string + "\">");
        }
        printWriter.println("<plot>");
        printWriter.println("<!-- Ptolemy plot, version 5.7 , PlotML format. -->");
        this.writeFormat(printWriter);
        this.writeData(printWriter);
        printWriter.println("</plot>");
        printWriter.flush();
    }

    public synchronized void writeData(PrintWriter printWriter) {
    }

    public synchronized void writeFormat(PrintWriter printWriter) {
        int n;
        int n2;
        if (this._title != null) {
            printWriter.println("<title>" + this._title + "</title>");
        }
        if (this._xlabel != null) {
            printWriter.println("<xLabel>" + this._xlabel + "</xLabel>");
        }
        if (this._ylabel != null) {
            printWriter.println("<yLabel>" + this._ylabel + "</yLabel>");
        }
        if (this._xRangeGiven) {
            printWriter.println("<xRange min=\"" + this._xlowgiven + "\" max=\"" + this._xhighgiven + "\"/>");
        }
        if (this._yRangeGiven) {
            printWriter.println("<yRange min=\"" + this._ylowgiven + "\" max=\"" + this._yhighgiven + "\"/>");
        }
        if (this._xticks != null && this._xticks.size() > 0) {
            printWriter.println("<xTicks>");
            n2 = this._xticks.size() - 1;
            for (n = 0; n <= n2; ++n) {
                printWriter.println("  <tick label=\"" + (String)this._xticklabels.elementAt(n) + "\" position=\"" + this._xticks.elementAt(n) + "\"/>");
            }
            printWriter.println("</xTicks>");
        }
        if (this._yticks != null && this._yticks.size() > 0) {
            printWriter.println("<yTicks>");
            n2 = this._yticks.size() - 1;
            for (n = 0; n <= n2; ++n) {
                printWriter.println("  <tick label=\"" + (String)this._yticklabels.elementAt(n) + "\" position=\"" + this._yticks.elementAt(n) + "\"/>");
            }
            printWriter.println("</yTicks>");
        }
        if (this._xlog) {
            printWriter.println("<xLog/>");
        }
        if (this._ylog) {
            printWriter.println("<yLog/>");
        }
        if (!this._grid) {
            printWriter.println("<noGrid/>");
        }
        if (this._wrap) {
            printWriter.println("<wrap/>");
        }
        if (!this._usecolor) {
            printWriter.println("<noColor/>");
        }
    }

    public synchronized void writeOldSyntax(OutputStream outputStream) {
        PrintWriter printWriter = new PrintWriter(new BufferedOutputStream(outputStream), false);
        this._writeOldSyntax(printWriter);
        printWriter.flush();
        if (outputStream != System.out) {
            printWriter.close();
        }
    }

    public synchronized void zoom(double d, double d2, double d3, double d4) {
        this.setXRange(d, d3);
        this.setYRange(d2, d4);
        this.repaint();
    }

    protected synchronized void _drawPlot(Graphics graphics, boolean bl) {
        Rectangle rectangle = this.getBounds();
        this._drawPlot(graphics, bl, rectangle);
    }

    protected synchronized void _drawPlot(Graphics graphics, boolean bl, Rectangle rectangle) {
        int n;
        double d;
        int n2;
        double d2;
        int n3;
        Object object;
        Object object2;
        int n4;
        Object object3;
        if (graphics == null) {
            return;
        }
        graphics.setPaintMode();
        if (this._errorMsg != null) {
            int n5;
            int n6 = n5 = this._labelFontMetrics.getHeight() + 2;
            graphics.setColor(Color.black);
            for (int i = 0; i < this._errorMsg.length; ++i) {
                graphics.drawString(this._errorMsg[i], 10, n6);
                n6 += n5;
                System.err.println(this._errorMsg[i]);
            }
            return;
        }
        if (!this._xRangeGiven) {
            if (this._xBottom > this._xTop) {
                this._setXRange(0.0, 0.0);
            } else {
                this._setXRange(this._xBottom, this._xTop);
            }
        }
        if (!this._yRangeGiven) {
            if (this._yBottom > this._yTop) {
                this._setYRange(0.0, 0.0);
            } else {
                this._setYRange(this._yBottom, this._yTop);
            }
        }
        Rectangle rectangle2 = null;
        if (this._specifiedPlotRectangle != null) {
            rectangle2 = new Rectangle(Math.max(0, this._specifiedPlotRectangle.x), Math.max(0, this._specifiedPlotRectangle.y), Math.min(rectangle.width, this._specifiedPlotRectangle.width), Math.min(rectangle.height, this._specifiedPlotRectangle.height));
        }
        int n7 = 0;
        int n8 = this._titleFontMetrics.getHeight();
        if (this._title == null) {
            this._title = "";
        }
        if (this._title != null || this._yExp != 0) {
            n7 = n8 + this._topPadding;
        }
        Font font = graphics.getFont();
        graphics.setFont(this._labelFont);
        graphics.setColor(this._foreground);
        int n9 = this._labelFontMetrics.getHeight();
        int n10 = n9 / 2;
        int n11 = rectangle.height - 5;
        int n12 = rectangle.width - this._rightPadding;
        if (this._xlog) {
            this._xExp = (int)Math.floor(this._xtickMin);
        }
        if (this._xExp != 0 && this._xticks == null) {
            String string = Integer.toString(this._xExp);
            n12 -= this._superscriptFontMetrics.stringWidth(string);
            graphics.setFont(this._superscriptFont);
            if (!this._xlog) {
                graphics.drawString(string, n12, n11 - n10);
                graphics.setFont(this._labelFont);
                graphics.drawString("x10", n12 -= this._labelFontMetrics.stringWidth("x10"), n11);
            }
            this._bottomPadding = 3 * n9 / 2 + 5;
        }
        if (this._xlabel != null && this._bottomPadding < n9 + 5) {
            this._bottomPadding = n9 + 5;
        }
        this._uly = rectangle2 != null ? rectangle2.y : n7 + 5;
        this._lry = rectangle2 != null ? rectangle2.y + rectangle2.height : rectangle.height - n9 - this._bottomPadding - 3;
        int n13 = this._lry - this._uly;
        this._yscale = (double)n13 / (this._yMax - this._yMin);
        this._ytickscale = (double)n13 / (this._ytickMax - this._ytickMin);
        int n14 = 2 + n13 / (n9 + 10);
        double d3 = this._roundUp((this._ytickMax - this._ytickMin) / (double)n14);
        double d4 = d3 * Math.ceil(this._ytickMin / d3);
        int n15 = 0;
        String[] stringArray = new String[n14];
        int[] nArray = new int[n14];
        int n16 = 0;
        if (this._yticks == null) {
            object3 = null;
            if (this._ylog) {
                object3 = this._gridInit(d4, d3, true, null);
            }
            n4 = this._numFracDigits(d3);
            double d5 = d4;
            if (this._ylog) {
                d5 = this._gridStep((Vector)object3, d4, d3, this._ylog);
            }
            double d6 = d5;
            while (d6 <= this._ytickMax && n16 < n14) {
                object2 = this._ylog ? this._formatLogNum(d6, n4) : this._formatNum(d6, n4);
                stringArray[n16] = object2;
                int n17 = this._labelFontMetrics.stringWidth((String)object2);
                nArray[n16++] = n17;
                if (n17 > n15) {
                    n15 = n17;
                }
                d6 = this._gridStep((Vector)object3, d6, d3, this._ylog);
            }
        } else {
            object3 = this._yticklabels.elements();
            while (object3.hasMoreElements()) {
                String string = (String)object3.nextElement();
                int n18 = this._labelFontMetrics.stringWidth(string);
                if (n18 <= n15) continue;
                n15 = n18;
            }
        }
        this._ulx = rectangle2 != null ? rectangle2.x : (this._ylabel != null ? n15 + this._labelFontMetrics.stringWidth("W") + this._leftPadding : n15 + this._leftPadding);
        int n19 = this._drawLegend(graphics, rectangle.width - this._rightPadding, this._uly);
        this._lrx = rectangle2 != null ? rectangle2.x + rectangle2.width : rectangle.width - n19 - this._rightPadding;
        n4 = this._lrx - this._ulx;
        this._xscale = (double)n4 / (this._xMax - this._xMin);
        this._xtickscale = (double)n4 / (this._xtickMax - this._xtickMin);
        graphics.setColor(Color.white);
        graphics.fillRect(this._ulx, this._uly, n4, n13);
        graphics.setColor(this._foreground);
        graphics.drawRect(this._ulx, this._uly, n4, n13);
        int n20 = 5;
        int n21 = this._ulx + n20;
        int n22 = this._lrx - n20;
        if (this._yticks == null) {
            object = null;
            double d7 = d4;
            if (this._ylog) {
                object = this._gridInit(d4, d3, true, null);
                d7 = this._gridStep((Vector)object, d4, d3, this._ylog);
                n14 = n16;
            }
            n16 = 0;
            n3 = this._ylog;
            d2 = d7;
            while (d2 <= this._ytickMax && n16 < n14) {
                n2 = this._lry - (int)((d2 - this._ytickMin) * this._ytickscale);
                int n23 = 0;
                if (n16 > 0 && !this._ylog) {
                    n23 = n10;
                }
                graphics.drawLine(this._ulx, n2, n21, n2);
                graphics.drawLine(this._lrx, n2, n22, n2);
                if (this._grid && n2 != this._uly && n2 != this._lry) {
                    graphics.setColor(Color.lightGray);
                    graphics.drawLine(n21, n2, n22, n2);
                    graphics.setColor(this._foreground);
                }
                if (this._ylog && stringArray[n16].indexOf(101) != -1) {
                    n3 = 0;
                }
                graphics.drawString(stringArray[n16], this._ulx - nArray[n16++] - 4, n2 + n23);
                d2 = this._gridStep((Vector)object, d2, d3, this._ylog);
            }
            if (this._ylog) {
                Vector vector = this._gridInit(d4, d3, false, (Vector)object);
                if (vector.size() > 0) {
                    d = d3 > 1.0 ? 1.0 : d3;
                    double d8 = this._gridStep(vector, d4, d, this._ylog);
                    while (d8 <= this._ytickMax) {
                        n = this._lry - (int)((d8 - this._ytickMin) * this._ytickscale);
                        if (this._grid && n != this._uly && n != this._lry) {
                            graphics.setColor(Color.lightGray);
                            graphics.drawLine(this._ulx + 1, n, this._lrx - 1, n);
                            graphics.setColor(this._foreground);
                        }
                        d8 = this._gridStep(vector, d8, d, this._ylog);
                    }
                }
                this._yExp = n3 != 0 ? (int)Math.floor(d7) : 0;
            }
            if (this._yExp != 0) {
                graphics.drawString("x10", 2, n7);
                graphics.setFont(this._superscriptFont);
                graphics.drawString(Integer.toString(this._yExp), this._labelFontMetrics.stringWidth("x10") + 2, n7 - n10);
                graphics.setFont(this._labelFont);
            }
        } else {
            object = this._yticks.elements();
            object2 = this._yticklabels.elements();
            while (object2.hasMoreElements()) {
                String string = (String)object2.nextElement();
                double d9 = (Double)object.nextElement();
                if (d9 > this._yMax || d9 < this._yMin) continue;
                int n24 = this._lry - (int)((d9 - this._yMin) * this._yscale);
                n2 = 0;
                if (d9 < (double)(this._lry - n9)) {
                    n2 = n10;
                }
                graphics.drawLine(this._ulx, n24, n21, n24);
                graphics.drawLine(this._lrx, n24, n22, n24);
                if (this._grid && n24 != this._uly && n24 != this._lry) {
                    graphics.setColor(Color.lightGray);
                    graphics.drawLine(n21, n24, n22, n24);
                    graphics.setColor(this._foreground);
                }
                graphics.drawString(string, this._ulx - this._labelFontMetrics.stringWidth(string) - 3, n24 + n2);
            }
        }
        int n25 = this._uly + n20;
        int n26 = this._lry - n20;
        int n27 = this._labelFontMetrics.stringWidth("8");
        if (this._xticks == null) {
            Object object4;
            n3 = 10;
            d2 = 0.0;
            n2 = 0;
            if (this._xlog) {
                n3 = 2 + n4 / (n27 * 6 + 10);
            } else {
                int n28 = 0;
                while (n28++ <= 10) {
                    int n29;
                    int n30;
                    d2 = this._roundUp((this._xtickMax - this._xtickMin) / (double)n3);
                    n2 = this._numFracDigits(d2);
                    int n31 = this._numIntDigits(this._xtickMax);
                    if (n31 < (n = this._numIntDigits(this._xtickMin))) {
                        n31 = n;
                    }
                    if ((n3 = 2 + n4 / ((n30 = n27 * (n2 + 2 + n31)) + 10)) - (n29 = n3) > 1 && n29 - n3 > 1) continue;
                    break;
                }
            }
            d2 = this._roundUp((this._xtickMax - this._xtickMin) / (double)n3);
            n2 = this._numFracDigits(d2);
            double d10 = d2 * Math.ceil(this._xtickMin / d2);
            Vector vector = null;
            double d11 = d10;
            if (this._xlog) {
                vector = this._gridInit(d10, d2, true, null);
                d11 = this._gridRoundUp(vector, d10);
            }
            boolean bl2 = this._xlog;
            double d12 = d11;
            while (d12 <= this._xtickMax) {
                if (this._xlog) {
                    object4 = this._formatLogNum(d12, n2);
                    if (((String)object4).indexOf(101) != -1) {
                        bl2 = false;
                    }
                } else {
                    object4 = this._formatNum(d12, n2);
                }
                n21 = this._ulx + (int)((d12 - this._xtickMin) * this._xtickscale);
                graphics.drawLine(n21, this._uly, n21, n25);
                graphics.drawLine(n21, this._lry, n21, n26);
                if (this._grid && n21 != this._ulx && n21 != this._lrx) {
                    graphics.setColor(Color.lightGray);
                    graphics.drawLine(n21, n25, n21, n26);
                    graphics.setColor(this._foreground);
                }
                int n32 = n21 - this._labelFontMetrics.stringWidth((String)object4) / 2;
                graphics.drawString((String)object4, n32, this._lry + 3 + n9);
                d12 = this._gridStep(vector, d12, d2, this._xlog);
            }
            if (this._xlog) {
                d12 = d2 > 1.0 ? 1.0 : d2;
                d11 = d12 * Math.ceil(this._xtickMin / d12);
                object4 = this._gridInit(d11, d12, false, vector);
                if (((Vector)object4).size() > 0) {
                    double d13 = this._gridStep((Vector)object4, d11, d12, this._xlog);
                    while (d13 <= this._xtickMax) {
                        n21 = this._ulx + (int)((d13 - this._xtickMin) * this._xtickscale);
                        if (this._grid && n21 != this._ulx && n21 != this._lrx) {
                            graphics.setColor(Color.lightGray);
                            graphics.drawLine(n21, this._uly + 1, n21, this._lry - 1);
                            graphics.setColor(this._foreground);
                        }
                        d13 = this._gridStep((Vector)object4, d13, d12, this._xlog);
                    }
                }
                if (bl2) {
                    this._xExp = (int)Math.floor(d11);
                    graphics.setFont(this._superscriptFont);
                    graphics.drawString(Integer.toString(this._xExp), n12, n11 - n10);
                    graphics.setFont(this._labelFont);
                    graphics.drawString("x10", n12 -= this._labelFontMetrics.stringWidth("x10"), n11);
                } else {
                    this._xExp = 0;
                }
            }
        } else {
            Enumeration enumeration = this._xticks.elements();
            Enumeration enumeration2 = this._xticklabels.elements();
            d = 0.0;
            while (enumeration2.hasMoreElements()) {
                int n33;
                String string = (String)enumeration2.nextElement();
                double d14 = (Double)enumeration.nextElement();
                if (d14 > this._xMax || d14 < this._xMin || !((double)(n33 = (n21 = this._ulx + (int)((d14 - this._xMin) * this._xscale)) - this._labelFontMetrics.stringWidth(string) / 2) > d)) continue;
                d = n21 + this._labelFontMetrics.stringWidth(string) / 2 + 10;
                graphics.drawString(string, n33, this._lry + 3 + n9);
                graphics.drawLine(n21, this._uly, n21, n25);
                graphics.drawLine(n21, this._lry, n21, n26);
                if (!this._grid || n21 == this._ulx || n21 == this._lrx) continue;
                graphics.setColor(Color.lightGray);
                graphics.drawLine(n21, n25, n21, n26);
                graphics.setColor(this._foreground);
            }
        }
        graphics.setColor(this._foreground);
        if (this._title != null) {
            graphics.setFont(this._titleFont);
            int n34 = this._ulx + (n4 - this._titleFontMetrics.stringWidth(this._title)) / 2;
            graphics.drawString(this._title, n34, n7);
        }
        graphics.setFont(this._labelFont);
        if (this._xlabel != null) {
            int n35 = this._ulx + (n4 - this._labelFontMetrics.stringWidth(this._xlabel)) / 2;
            graphics.drawString(this._xlabel, n35, n11);
        }
        int n36 = 2 + this._labelFontMetrics.stringWidth("W") / 2;
        if (this._ylabel != null) {
            int n37 = this._ylabel.length();
            if (graphics instanceof Graphics2D) {
                int n38 = this._uly + (this._lry - this._uly) / 2 + this._labelFontMetrics.stringWidth(this._ylabel) / 2 - n27;
                Graphics2D graphics2D = (Graphics2D)graphics;
                int n39 = n36 + n10 - 2;
                graphics2D.rotate(Math.toRadians(-90.0), n39, n38);
                graphics2D.drawString(this._ylabel, n39, n38);
                graphics2D.rotate(Math.toRadians(90.0), n39, n38);
            } else {
                int n40 = this._uly + (this._lry - this._uly) / 2 - n37 * n10 + n9;
                for (n2 = 0; n2 < n37; ++n2) {
                    String string = this._ylabel.substring(n2, n2 + 1);
                    int n41 = this._labelFontMetrics.stringWidth(string);
                    graphics.drawString(string, n36 - n41 / 2, n40);
                    n40 += n9;
                }
            }
        }
        graphics.setFont(font);
    }

    protected void _drawPoint(Graphics graphics, int n, long l, long l2, boolean bl) {
        boolean bl2;
        if (graphics == null) {
            return;
        }
        boolean bl3 = bl2 = l2 <= (long)this._lry && l2 >= (long)this._uly && l <= (long)this._lrx && l >= (long)this._ulx;
        if (!bl2 && bl) {
            return;
        }
        graphics.fillRect((int)l - 6, (int)l2 - 6, 6, 6);
    }

    protected void _help() {
        String string = "Ptolemy plot package\nBy: Edward A. Lee\nand Christopher Brooks\nVersion 5.7, Build: $Id: PlotBox.java,v 1.283.4.3 2008/04/01 01:19:02 cxh Exp $\n\nKey bindings:\n   Cntrl-c:  copy plot to clipboard (EPS format), if permitted\n   D: dump plot data to standard out\n   E: export plot to standard out (EPS format)\n   F: fill plot\n   H or ?: print help message (this message)\n   Cntrl-D or Q: quit\nFor more information, see\nhttp://ptolemy.eecs.berkeley.edu/java/ptplot\n";
        JOptionPane.showMessageDialog(this, string, "Ptolemy Plot Help Window", 1);
    }

    protected boolean _parseLine(String string) {
        String string2 = string.toLowerCase();
        if (string2.startsWith("#")) {
            return true;
        }
        if (string2.startsWith("titletext:")) {
            this.setTitle(string.substring(10).trim());
            return true;
        }
        if (string2.startsWith("title:")) {
            this.setTitle(string.substring(6).trim());
            return true;
        }
        if (string2.startsWith("xlabel:")) {
            this.setXLabel(string.substring(7).trim());
            return true;
        }
        if (string2.startsWith("ylabel:")) {
            this.setYLabel(string.substring(7).trim());
            return true;
        }
        if (string2.startsWith("xrange:")) {
            int n = string.indexOf(",", 7);
            if (n > 0) {
                String string3 = string.substring(7, n).trim();
                String string4 = string.substring(n + 1).trim();
                try {
                    Double d = Double.valueOf(string3);
                    Double d2 = Double.valueOf(string4);
                    this.setXRange(d, d2);
                }
                catch (NumberFormatException numberFormatException) {
                    // empty catch block
                }
            }
            return true;
        }
        if (string2.startsWith("yrange:")) {
            int n = string.indexOf(",", 7);
            if (n > 0) {
                String string5 = string.substring(7, n).trim();
                String string6 = string.substring(n + 1).trim();
                try {
                    Double d = Double.valueOf(string5);
                    Double d3 = Double.valueOf(string6);
                    this.setYRange(d, d3);
                }
                catch (NumberFormatException numberFormatException) {
                    // empty catch block
                }
            }
            return true;
        }
        if (string2.startsWith("xticks:")) {
            this._parsePairs(string.substring(7), true);
            return true;
        }
        if (string2.startsWith("yticks:")) {
            this._parsePairs(string.substring(7), false);
            return true;
        }
        if (string2.startsWith("xlog:")) {
            this._xlog = string2.indexOf("off", 5) < 0;
            return true;
        }
        if (string2.startsWith("ylog:")) {
            this._ylog = string2.indexOf("off", 5) < 0;
            return true;
        }
        if (string2.startsWith("grid:")) {
            this._grid = string2.indexOf("off", 5) < 0;
            return true;
        }
        if (string2.startsWith("wrap:")) {
            this._wrap = string2.indexOf("off", 5) < 0;
            return true;
        }
        if (string2.startsWith("color:")) {
            this._usecolor = string2.indexOf("off", 6) < 0;
            return true;
        }
        return false;
    }

    protected void _setButtonsVisibility(boolean bl) {
        this._plotImage = null;
        this._printButton.setVisible(bl);
        this._fillButton.setVisible(bl);
        this._formatButton.setVisible(bl);
        this._resetButton.setVisible(bl);
    }

    protected void _setPadding(double d) {
        this._plotImage = null;
        this._padding = d;
    }

    protected void _writeOldSyntax(PrintWriter printWriter) {
        int n;
        int n2;
        printWriter.println("# Ptolemy plot, version 2.0");
        if (this._title != null) {
            printWriter.println("TitleText: " + this._title);
        }
        if (this._xlabel != null) {
            printWriter.println("XLabel: " + this._xlabel);
        }
        if (this._ylabel != null) {
            printWriter.println("YLabel: " + this._ylabel);
        }
        if (this._xRangeGiven) {
            printWriter.println("XRange: " + this._xlowgiven + ", " + this._xhighgiven);
        }
        if (this._yRangeGiven) {
            printWriter.println("YRange: " + this._ylowgiven + ", " + this._yhighgiven);
        }
        if (this._xticks != null && this._xticks.size() > 0) {
            printWriter.print("XTicks: ");
            n2 = this._xticks.size() - 1;
            for (n = 0; n < n2; ++n) {
                printWriter.print("\"" + (String)this._xticklabels.elementAt(n) + "\" " + this._xticks.elementAt(n) + ", ");
            }
            printWriter.println("\"" + (String)this._xticklabels.elementAt(n2) + "\" " + this._xticks.elementAt(n2));
        }
        if (this._yticks != null && this._yticks.size() > 0) {
            printWriter.print("YTicks: ");
            n2 = this._yticks.size() - 1;
            for (n = 0; n < n2; ++n) {
                printWriter.print("\"" + (String)this._yticklabels.elementAt(n) + "\" " + this._yticks.elementAt(n) + ", ");
            }
            printWriter.println("\"" + (String)this._yticklabels.elementAt(n2) + "\" " + this._yticks.elementAt(n2));
        }
        if (this._xlog) {
            printWriter.println("XLog: on");
        }
        if (this._ylog) {
            printWriter.println("YLog: on");
        }
        if (!this._grid) {
            printWriter.println("Grid: off");
        }
        if (this._wrap) {
            printWriter.println("Wrap: on");
        }
        if (!this._usecolor) {
            printWriter.println("Color: off");
        }
    }

    private int _drawLegend(Graphics graphics, int n, int n2) {
        if (graphics == null) {
            return 0;
        }
        Font font = graphics.getFont();
        graphics.setFont(this._labelFont);
        int n3 = this._labelFontMetrics.getHeight();
        Enumeration enumeration = this._legendStrings.elements();
        Enumeration enumeration2 = this._legendDatasets.elements();
        int n4 = n2 + n3;
        int n5 = 0;
        while (enumeration.hasMoreElements()) {
            int n6;
            String string = (String)enumeration.nextElement();
            int n7 = (Integer)enumeration2.nextElement();
            if (n7 < 0) continue;
            if (this._usecolor) {
                n6 = n7 % _colors.length;
                graphics.setColor(_colors[n6]);
            }
            this._drawPoint(graphics, n7, n - 3, n4 - 3, false);
            graphics.setColor(this._foreground);
            n6 = this._labelFontMetrics.stringWidth(string);
            if (n6 > n5) {
                n5 = n6;
            }
            graphics.drawString(string, n - 15 - n6, n4);
            n4 += n3;
        }
        graphics.setFont(font);
        return 22 + n5;
    }

    private synchronized void _executeDeferredActions() {
        try {
            Iterator iterator = this._deferredActions.iterator();
            while (iterator.hasNext()) {
                Runnable runnable = (Runnable)iterator.next();
                runnable.run();
            }
        }
        finally {
            this._actionsDeferred = false;
            this._deferredActions.clear();
        }
    }

    private String _formatLogNum(double d, int n) {
        int n2 = (int)d;
        String string = n2 >= 0 && n2 < 10 ? "" + n2 : (n2 < 0 && n2 > -10 ? "-" + -n2 : Integer.toString(n2));
        string = d >= 0.0 ? (d - (double)((int)d) < 0.001 ? "1e" + string : this._formatNum(Math.pow(10.0, d - (double)((int)d)), n)) : (-d - (double)((int)(-d)) < 0.001 ? "1e" + string : this._formatNum(Math.pow(10.0, d - (double)((int)d)) * 10.0, n));
        return this.toExponential(string);
    }

    private String _formatNum(double d, int n) {
        double d2 = 0.5;
        if (d < 0.0) {
            d2 = -0.5;
        }
        String string = Double.toString(d + d2 * Math.pow(10.0, -n));
        int n2 = string.lastIndexOf(".");
        StringBuffer stringBuffer = new StringBuffer();
        if (n2 < 0) {
            if (n <= 0) {
                stringBuffer.append(string);
                return this.toExponential(stringBuffer);
            }
            stringBuffer.append(".");
            for (int i = 0; i < n; ++i) {
                stringBuffer.append("0");
            }
            return this.toExponential(stringBuffer);
        }
        int n3 = n - (string.length() - n2 - 1);
        if (n3 <= 0) {
            int n4 = n2 + n + 1;
            if (n == 0) {
                --n4;
            }
            stringBuffer.append(string.substring(0, n4));
            return this.toExponential(stringBuffer);
        }
        stringBuffer.append(string);
        for (int i = 0; i < n3; ++i) {
            stringBuffer.append("0");
        }
        return this.toExponential(stringBuffer);
    }

    public String toExponential(StringBuffer stringBuffer) {
        String string = stringBuffer.toString();
        if (PlotApplet.normalexponent) {
            string = string.replaceAll("e-", "x10^-");
            string = string.replaceAll("e+", "x10^");
            string = string.replaceAll("e", "x10^");
        }
        return string;
    }

    public String toExponential(String string) {
        String string2 = string.toString();
        if (PlotApplet.normalexponent) {
            string2 = string2.replaceAll("e-", "x10^-");
            string2 = string2.replaceAll("e+", "x10^");
            string2 = string2.replaceAll("e", "x10^");
        }
        return string2;
    }

    private Vector _gridInit(double d, double d2, boolean bl, Vector vector) {
        Vector<Double> vector2 = new Vector<Double>(10);
        double d3 = Math.pow(10.0, d2);
        int n = 1;
        if (bl) {
            if (d3 <= 3.5) {
                n = d3 > 2.0 ? 2 : (d3 > 1.26 ? 5 : (d3 > 1.125 ? 10 : (int)Math.rint(1.0 / d2)));
            }
        } else {
            n = d3 > 10.0 ? 1 : (d3 > 3.0 ? 2 : (d3 > 2.0 ? 5 : (d3 > 1.125 ? 10 : 100)));
        }
        int n2 = 0;
        for (int i = 0; i < n; ++i) {
            double d4 = (double)i * 1.0 / (double)n * 10.0;
            double d5 = _LOG10SCALE * Math.log(d4);
            if (d5 == Double.NEGATIVE_INFINITY) {
                d5 = 0.0;
            }
            if (vector != null && n2 < vector.size()) {
                while (n2 < vector.size() && (Double)vector.elementAt(n2) < d5) {
                    ++n2;
                }
                if (n2 < vector.size()) {
                    if (!(Math.abs((Double)vector.elementAt(n2) - d5) > 1.0E-5)) continue;
                    vector2.addElement(d5);
                    continue;
                }
                vector2.addElement(d5);
                continue;
            }
            vector2.addElement(d5);
        }
        this._gridCurJuke = 0;
        if (d == -0.0) {
            d = 0.0;
        }
        this._gridBase = Math.floor(d);
        double d6 = d - this._gridBase;
        this._gridCurJuke = -1;
        while (this._gridCurJuke + 1 < vector2.size() && d6 >= (Double)vector2.elementAt(this._gridCurJuke + 1)) {
            ++this._gridCurJuke;
        }
        return vector2;
    }

    private double _gridRoundUp(Vector vector, double d) {
        int n;
        double d2 = d - Math.floor(d);
        for (n = 0; n < vector.size() && d2 >= (Double)vector.elementAt(n); ++n) {
        }
        if (n >= vector.size()) {
            return d;
        }
        return Math.floor(d) + (Double)vector.elementAt(n);
    }

    private double _gridStep(Vector vector, double d, double d2, boolean bl) {
        if (bl) {
            if (++this._gridCurJuke >= vector.size()) {
                this._gridCurJuke = 0;
                this._gridBase += Math.ceil(d2);
            }
            if (this._gridCurJuke >= vector.size()) {
                return d + d2;
            }
            return this._gridBase + (Double)vector.elementAt(this._gridCurJuke);
        }
        return d + d2;
    }

    private void _measureFonts() {
        if (this._labelFont == null) {
            this._labelFont = new Font("Helvetica", 0, 12);
        }
        if (this._superscriptFont == null) {
            this._superscriptFont = new Font("Helvetica", 0, 9);
        }
        if (this._titleFont == null) {
            this._titleFont = new Font("Helvetica", 1, 14);
        }
        this._labelFontMetrics = this.getFontMetrics(this._labelFont);
        this._superscriptFontMetrics = this.getFontMetrics(this._superscriptFont);
        this._titleFontMetrics = this.getFontMetrics(this._titleFont);
    }

    private int _numFracDigits(double d) {
        int n;
        for (n = 0; n <= 15 && d != Math.floor(d); d *= 10.0, ++n) {
        }
        return n;
    }

    private int _numIntDigits(double d) {
        int n;
        for (n = 0; n <= 15 && (double)((int)d) != 0.0; ++n) {
            d /= 10.0;
        }
        return n;
    }

    private void _parsePairs(String string, boolean bl) {
        if (bl) {
            this._xticks = null;
            this._xticklabels = null;
        } else {
            this._yticks = null;
            this._yticklabels = null;
        }
        int n = 0;
        boolean bl2 = true;
        while (bl2) {
            int n2 = string.indexOf(",", n);
            String string2 = null;
            if (n2 > n) {
                string2 = string.substring(n, n2).trim();
            } else {
                string2 = string.substring(n).trim();
                bl2 = false;
            }
            int n3 = -1;
            int n4 = 0;
            if (string2.startsWith("\"")) {
                n3 = string2.indexOf("\"", 1);
                n4 = 1;
            } else {
                n3 = string2.indexOf(" ");
            }
            if (n3 > 0) {
                String string3 = string2.substring(n4, n3);
                String string4 = string2.substring(n3 + 1).trim();
                try {
                    double d = Double.valueOf(string4);
                    if (bl) {
                        this.addXTick(string3, d);
                    } else {
                        this.addYTick(string3, d);
                    }
                }
                catch (NumberFormatException numberFormatException) {
                    System.err.println("Warning from PlotBox: Unable to parse ticks: " + numberFormatException.getMessage());
                }
            }
            n = n2 + 1;
            n2 = string.indexOf(",", n);
        }
    }

    private RenderingHints _defaultImageRenderingHints() {
        RenderingHints renderingHints = new RenderingHints(null);
        renderingHints.put(RenderingHints.KEY_ANTIALIASING, RenderingHints.VALUE_ANTIALIAS_ON);
        return renderingHints;
    }

    private double _roundUp(double d) {
        int n;
        if ((d *= Math.pow(10.0, -(n = (int)Math.floor(Math.log(d) * _LOG10SCALE)))) > 5.0) {
            d = 10.0;
        } else if (d > 2.0) {
            d = 5.0;
        } else if (d > 1.0) {
            d = 2.0;
        }
        return d *= Math.pow(10.0, n);
    }

    private void _setXRange(double d, double d2) {
        this._plotImage = null;
        if (!this._originalXRangeGiven) {
            this._originalXlow = d;
            this._originalXhigh = d2;
            this._originalXRangeGiven = true;
        }
        if (d > d2) {
            d = -1.0;
            d2 = 1.0;
        } else if (d == d2) {
            d -= 1.0;
            d2 += 1.0;
        }
        this._xMin = d - (d2 - d) * this._padding;
        this._xMax = d2 + (d2 - d) * this._padding;
        double d3 = Math.max(Math.abs(this._xMin), Math.abs(this._xMax));
        this._xExp = (int)Math.floor(Math.log(d3) * _LOG10SCALE);
        if (this._xExp > 2 || this._xExp < -2) {
            double d4 = 1.0 / Math.pow(10.0, this._xExp);
            this._xtickMin = this._xMin * d4;
            this._xtickMax = this._xMax * d4;
        } else {
            this._xtickMin = this._xMin;
            this._xtickMax = this._xMax;
            this._xExp = 0;
        }
    }

    private void _setYRange(double d, double d2) {
        this._plotImage = null;
        if (!this._originalYRangeGiven) {
            this._originalYlow = d;
            this._originalYhigh = d2;
            this._originalYRangeGiven = true;
        }
        if (d > d2) {
            d = -1.0;
            d2 = 1.0;
        } else if (d == d2) {
            d -= 0.1;
            d2 += 0.1;
        }
        this._yMin = d - (d2 - d) * this._padding;
        this._yMax = d2 + (d2 - d) * this._padding;
        double d3 = Math.max(Math.abs(this._yMin), Math.abs(this._yMax));
        this._yExp = (int)Math.floor(Math.log(d3) * _LOG10SCALE);
        if (this._yExp > 2 || this._yExp < -2) {
            double d4 = 1.0 / Math.pow(10.0, this._yExp);
            this._ytickMin = this._yMin * d4;
            this._ytickMax = this._yMax * d4;
        } else {
            this._ytickMin = this._yMin;
            this._ytickMax = this._yMax;
            this._yExp = 0;
        }
    }

    void _zoom(int n, int n2) {
        this._zooming = false;
        Graphics graphics = this.getGraphics();
        if (graphics == null) {
            return;
        }
        if (this._zoomin && this._drawn) {
            if (this._zoomxn != -1 || this._zoomyn != -1) {
                int n3 = Math.min(this._zoomx, this._zoomxn);
                int n4 = Math.max(this._zoomx, this._zoomxn);
                int n5 = Math.min(this._zoomy, this._zoomyn);
                int n6 = Math.max(this._zoomy, this._zoomyn);
                graphics.setXORMode(_boxColor);
                graphics.drawRect(n3, n5, n4 - n3, n6 - n5);
                graphics.setPaintMode();
                if (n2 > this._lry) {
                    n2 = this._lry;
                }
                if (n2 < this._uly) {
                    n2 = this._uly;
                }
                if (n > this._lrx) {
                    n = this._lrx;
                }
                if (n < this._ulx) {
                    n = this._ulx;
                }
                if (Math.abs(this._zoomx - n) > 5 && Math.abs(this._zoomy - n2) > 5) {
                    double d = this._xMin + (double)(this._zoomx - this._ulx) / this._xscale;
                    double d2 = this._xMin + (double)(n - this._ulx) / this._xscale;
                    if (d < d2) {
                        this.setXRange(d, d2);
                    } else {
                        this.setXRange(d2, d);
                    }
                    d = this._yMax - (double)(this._zoomy - this._uly) / this._yscale;
                    d2 = this._yMax - (double)(n2 - this._uly) / this._yscale;
                    if (d < d2) {
                        this.setYRange(d, d2);
                    } else {
                        this.setYRange(d2, d);
                    }
                }
                this.repaint();
            }
        } else if (this._zoomout && this._drawn) {
            graphics.setXORMode(_boxColor);
            int n7 = Math.abs(this._zoomx - this._zoomxn);
            int n8 = Math.abs(this._zoomy - this._zoomyn);
            graphics.drawRect(this._zoomx - 15 - n7, this._zoomy - 15 - n8, 30 + n7 * 2, 30 + n8 * 2);
            graphics.setPaintMode();
            double d = (double)Math.abs(this._zoomx - n) / 30.0;
            double d3 = (double)Math.abs(this._zoomy - n2) / 30.0;
            double d4 = this._xMax + (this._xMax - this._xMin) * d;
            double d5 = this._xMin - (this._xMax - this._xMin) * d;
            double d6 = this._yMax + (this._yMax - this._yMin) * d3;
            double d7 = this._yMin - (this._yMax - this._yMin) * d3;
            this.zoom(d5, d7, d4, d6);
            this.repaint();
        } else if (!this._drawn) {
            this.repaint();
        }
        this._drawn = false;
        this._zoomout = false;
        this._zoomin = false;
        this._zoomy = -1;
        this._zoomx = -1;
        this._zoomyn = -1;
        this._zoomxn = -1;
    }

    void _zoomBox(int n, int n2) {
        if (!this._zooming) {
            return;
        }
        Graphics graphics = this.getGraphics();
        if (graphics == null) {
            return;
        }
        if (n2 > this._lry) {
            n2 = this._lry;
        }
        if (n2 < this._uly) {
            n2 = this._uly;
        }
        if (n > this._lrx) {
            n = this._lrx;
        }
        if (n < this._ulx) {
            n = this._ulx;
        }
        if (this._zoomx != -1 || this._zoomy != -1) {
            if (!this._zoomin && !this._zoomout) {
                if (n2 < this._zoomy) {
                    this._zoomout = true;
                    graphics.setXORMode(_boxColor);
                    graphics.drawRect(this._zoomx - 15, this._zoomy - 15, 30, 30);
                } else if (n2 > this._zoomy) {
                    this._zoomin = true;
                }
            }
            if (this._zoomin) {
                int n3;
                int n4;
                int n5;
                int n6;
                if ((this._zoomxn != -1 || this._zoomyn != -1) && this._drawn) {
                    n6 = Math.min(this._zoomx, this._zoomxn);
                    n5 = Math.max(this._zoomx, this._zoomxn);
                    n4 = Math.min(this._zoomy, this._zoomyn);
                    n3 = Math.max(this._zoomy, this._zoomyn);
                    graphics.setXORMode(_boxColor);
                    graphics.drawRect(n6, n4, n5 - n6, n3 - n4);
                }
                if (n2 > this._zoomy) {
                    this._zoomxn = n;
                    this._zoomyn = n2;
                    n6 = Math.min(this._zoomx, this._zoomxn);
                    n5 = Math.max(this._zoomx, this._zoomxn);
                    n4 = Math.min(this._zoomy, this._zoomyn);
                    n3 = Math.max(this._zoomy, this._zoomyn);
                    graphics.setXORMode(_boxColor);
                    graphics.drawRect(n6, n4, n5 - n6, n3 - n4);
                    this._drawn = true;
                    return;
                }
                this._drawn = false;
            } else if (this._zoomout) {
                int n7;
                int n8;
                if ((this._zoomxn != -1 || this._zoomyn != -1) && this._drawn) {
                    n8 = Math.abs(this._zoomx - this._zoomxn);
                    n7 = Math.abs(this._zoomy - this._zoomyn);
                    graphics.setXORMode(_boxColor);
                    graphics.drawRect(this._zoomx - 15 - n8, this._zoomy - 15 - n7, 30 + n8 * 2, 30 + n7 * 2);
                }
                if (n2 < this._zoomy) {
                    this._zoomxn = n;
                    this._zoomyn = n2;
                    n8 = Math.abs(this._zoomx - this._zoomxn);
                    n7 = Math.abs(this._zoomy - this._zoomyn);
                    graphics.setXORMode(_boxColor);
                    graphics.drawRect(this._zoomx - 15 - n8, this._zoomy - 15 - n7, 30 + n8 * 2, 30 + n7 * 2);
                    this._drawn = true;
                    return;
                }
                this._drawn = false;
            }
        }
        graphics.setPaintMode();
    }

    void _zoomStart(int n, int n2) {
        if (n2 > this._lry) {
            n2 = this._lry;
        }
        if (n2 < this._uly) {
            n2 = this._uly;
        }
        if (n > this._lrx) {
            n = this._lrx;
        }
        if (n < this._ulx) {
            n = this._ulx;
        }
        this._zoomx = n;
        this._zoomy = n2;
        this._zooming = true;
    }

    class CommandListener
    implements KeyListener {
        private boolean _control = false;
        private boolean _shift = false;

        CommandListener() {
        }

        public void keyPressed(KeyEvent keyEvent) {
            int n = keyEvent.getKeyCode();
            switch (n) {
                case 17: {
                    this._control = true;
                    break;
                }
                case 16: {
                    this._shift = true;
                    break;
                }
                case 67: {
                    if (!this._control) break;
                    PlotBox.this.export(null);
                    String string = "Encapsulated PostScript (EPS) exported to clipboard.";
                    JOptionPane.showMessageDialog(PlotBox.this, string, "Ptolemy Plot Message", 1);
                    break;
                }
                case 68: {
                    if (!this._control && this._shift) {
                        PlotBox.this.write(System.out);
                        String string = "Plot data sent to standard out.";
                        JOptionPane.showMessageDialog(PlotBox.this, string, "Ptolemy Plot Message", 1);
                    }
                    if (!this._control) break;
                    StringUtilities.exit(1);
                    break;
                }
                case 69: {
                    if (this._control || !this._shift) break;
                    PlotBox.this.export(System.out);
                    String string = "Encapsulated PostScript (EPS) exported to standard out.";
                    JOptionPane.showMessageDialog(PlotBox.this, string, "Ptolemy Plot Message", 1);
                    break;
                }
                case 70: {
                    if (this._control || !this._shift) break;
                    PlotBox.this.fillPlot();
                    break;
                }
                case 72: {
                    if (this._control || !this._shift) break;
                    PlotBox.this._help();
                    break;
                }
                case 81: {
                    if (this._control) break;
                    StringUtilities.exit(1);
                    break;
                }
                case 47: {
                    if (!this._shift) break;
                    PlotBox.this._help();
                    break;
                }
            }
        }

        public void keyReleased(KeyEvent keyEvent) {
            int n = keyEvent.getKeyCode();
            switch (n) {
                case 17: {
                    this._control = false;
                    break;
                }
                case 16: {
                    this._shift = false;
                    break;
                }
            }
        }

        public void keyTyped(KeyEvent keyEvent) {
        }
    }

    public class DragListener
    implements MouseMotionListener {
        public void mouseDragged(MouseEvent mouseEvent) {
            PlotBox.this._zoomBox(mouseEvent.getX(), mouseEvent.getY());
        }

        public void mouseMoved(MouseEvent mouseEvent) {
        }
    }

    public class ZoomListener
    implements MouseListener {
        public void mouseClicked(MouseEvent mouseEvent) {
            PlotBox.this.requestFocus();
        }

        public void mouseEntered(MouseEvent mouseEvent) {
        }

        public void mouseExited(MouseEvent mouseEvent) {
        }

        public void mousePressed(MouseEvent mouseEvent) {
            if ((mouseEvent.getModifiers() & 0x10) != 0 || mouseEvent.getModifiers() == 0) {
                PlotBox.this._zoomStart(mouseEvent.getX(), mouseEvent.getY());
            }
        }

        public void mouseReleased(MouseEvent mouseEvent) {
            if ((mouseEvent.getModifiers() & 0x10) != 0 || mouseEvent.getModifiers() == 0) {
                PlotBox.this._zoom(mouseEvent.getX(), mouseEvent.getY());
            }
        }
    }

    class ButtonListener
    implements ActionListener {
        ButtonListener() {
        }

        public void actionPerformed(ActionEvent actionEvent) {
            if (actionEvent.getSource() == PlotBox.this._fillButton) {
                PlotBox.this.fillPlot();
            } else if (actionEvent.getSource() == PlotBox.this._printButton) {
                HashPrintRequestAttributeSet hashPrintRequestAttributeSet = new HashPrintRequestAttributeSet();
                PrinterJob printerJob = PrinterJob.getPrinterJob();
                printerJob.setPrintable(PlotBox.this);
                if (printerJob.printDialog(hashPrintRequestAttributeSet)) {
                    try {
                        printerJob.print(hashPrintRequestAttributeSet);
                    }
                    catch (Exception exception) {
                        Container container = PlotBox.this.getTopLevelAncestor();
                        JOptionPane.showMessageDialog(container, "Printing failed:\n" + exception.toString(), "Print Error", 2);
                    }
                }
            } else if (actionEvent.getSource() == PlotBox.this._resetButton) {
                PlotBox.this.resetAxes();
            } else if (actionEvent.getSource() == PlotBox.this._formatButton) {
                PlotFormatter plotFormatter = new PlotFormatter(PlotBox.this);
                plotFormatter.openModal();
            }
        }
    }
}

