/*
 * Decompiled with CFR 0.152.
 */
package org.jmol.viewer;

import java.awt.Component;
import java.awt.Event;
import java.awt.event.KeyEvent;
import java.awt.event.KeyListener;
import org.jmol.util.Escape;
import org.jmol.util.Logger;
import org.jmol.viewer.ActionManager;
import org.jmol.viewer.Viewer;

public abstract class MouseManager
implements KeyListener {
    protected Viewer viewer;
    private ActionManager actionManager;
    private String keyBuffer = "";

    abstract boolean handleOldJvm10Event(Event var1);

    MouseManager(Component component, Viewer viewer, ActionManager actionManager) {
        this.viewer = viewer;
        this.actionManager = actionManager;
        component.addKeyListener(this);
    }

    void clear() {
    }

    void removeMouseListeners11() {
    }

    void removeMouseListeners14() {
    }

    void dispose() {
        Component component = this.viewer.getDisplay();
        if (component == null) {
            return;
        }
        this.actionManager.dispose();
        this.removeMouseListeners11();
        this.removeMouseListeners14();
        component.removeKeyListener(this);
    }

    private void clearKeyBuffer() {
        if (this.keyBuffer.length() == 0) {
            return;
        }
        this.keyBuffer = "";
        if (this.viewer.getBooleanProperty("showKeyStrokes")) {
            this.viewer.evalStringQuiet("!set echo _KEYSTROKES; set echo bottom left;echo \"\"");
        }
    }

    private void addKeyBuffer(char c) {
        if (c == '\n') {
            this.sendKeyBuffer();
            return;
        }
        if (c == '\b') {
            if (this.keyBuffer.length() > 0) {
                this.keyBuffer = this.keyBuffer.substring(0, this.keyBuffer.length() - 1);
            }
        } else {
            this.keyBuffer = this.keyBuffer + c;
        }
        if (this.viewer.getBooleanProperty("showKeyStrokes")) {
            this.viewer.evalStringQuiet("!set echo _KEYSTROKES; set echo bottom left;echo " + Escape.escape("\u0001" + this.keyBuffer));
        }
    }

    private void sendKeyBuffer() {
        String string = this.keyBuffer;
        if (this.viewer.getBooleanProperty("showKeyStrokes")) {
            this.viewer.evalStringQuiet("!set echo _KEYSTROKES; set echo bottom left;echo " + Escape.escape(this.keyBuffer));
        }
        this.clearKeyBuffer();
        this.viewer.script(string);
    }

    public void keyTyped(KeyEvent keyEvent) {
        if (Logger.debugging) {
            Logger.debug("ActionmManager keyTyped: " + keyEvent.getKeyCode());
        }
        keyEvent.consume();
        if (!this.viewer.menuEnabled()) {
            return;
        }
        char c = keyEvent.getKeyChar();
        int n = keyEvent.getModifiers() & 0xA;
        if (n != 0) {
            switch (c) {
                case '\u000b': 
                case 'k': {
                    boolean bl = !this.viewer.getBooleanProperty("allowKeyStrokes");
                    switch (n) {
                        case 2: {
                            this.viewer.setBooleanProperty("allowKeyStrokes", bl);
                            this.viewer.setBooleanProperty("showKeyStrokes", true);
                            break;
                        }
                        case 8: 
                        case 10: {
                            this.viewer.setBooleanProperty("allowKeyStrokes", bl);
                            this.viewer.setBooleanProperty("showKeyStrokes", false);
                        }
                    }
                    this.clearKeyBuffer();
                    this.viewer.refresh(3, "showkey");
                }
            }
            return;
        }
        if (!this.viewer.getBooleanProperty("allowKeyStrokes")) {
            return;
        }
        this.addKeyBuffer(c);
    }

    public void keyPressed(KeyEvent keyEvent) {
        this.actionManager.keyPressed(keyEvent);
    }

    public void keyReleased(KeyEvent keyEvent) {
        this.actionManager.keyReleased(keyEvent);
    }

    void mouseEntered(long l, int n, int n2) {
        this.actionManager.mouseEntered(l, n, n2);
    }

    void mouseExited(long l, int n, int n2) {
        this.actionManager.mouseExited(l, n, n2);
    }

    void setMouseMode() {
        this.clearKeyBuffer();
        this.actionManager.setMouseMode();
    }

    void mouseClicked(long l, int n, int n2, int n3, int n4) {
        this.clearKeyBuffer();
        this.actionManager.mouseClicked(l, n, n2, n3, 1);
    }

    protected void mouseMoved(long l, int n, int n2, int n3) {
        this.clearKeyBuffer();
        this.actionManager.mouseMoved(l, n, n2, n3);
    }

    void mouseWheel(long l, int n, int n2) {
        this.clearKeyBuffer();
        this.actionManager.mouseWheel(l, n, n2);
    }

    void mousePressed(long l, int n, int n2, int n3, boolean bl) {
        this.clearKeyBuffer();
        this.actionManager.mousePressed(l, n, n2, n3);
    }

    void mouseReleased(long l, int n, int n2, int n3) {
        this.actionManager.mouseReleased(l, n, n2, n3);
    }

    void mouseDragged(long l, int n, int n2, int n3) {
        this.actionManager.mouseDragged(l, n, n2, n3);
    }
}

