#ifndef _EVENT_H_
#define _EVENT_H_

/*
 * event.h:	
 *
 * this is where eventually all of the event related stuff will go,
 * some of which is in write.* right now and other in buddies.*
 *
 */

#include "includes.h"
#include "buddies.h"

#define WRITE_COMMAND "write"

// this is to deal with includes not going in the order we want:
struct bud_utrec;
struct buddy;

// event:		do stuff when something happens
// 	this function gets invoked when a buddy logs in or logs out,
// 	and does stuff depending on the runtime configs.  at this point
// 	the params should be the expanded versions of the format strings
// 	supplied by the user
// params:
// 	write_cmd: the command to execute to write the user
// 	status_mesg: the message to print to the local tty
// 	cmd:	another arbitrary command to execute
// return: void
void event(const struct buddy *b, const struct bud_utrec *u, short write);

// fork_and_exec:	guess what it does?
// params:
// 	command:	the command to be executed
// returns:
// 	the pid of the child on success (for cleanup later on maybe)
// 	-1 on error
pid_t fork_and_exec(const char *command);

#endif // _EVENT_H_
