###############################################################################
#
# Tests for XlsxWriter.
#
# SPDX-License-Identifier: BSD-2-Clause
# Copyright (c), 2013-2021, John McNamara, jmcnamara@cpan.org
#

import unittest
from io import StringIO
from ..helperfunctions import _xml_to_list
from ...styles import Styles
from ...workbook import Workbook


class TestAssembleStyles(unittest.TestCase):
    """
    Test assembling a complete Styles file.

    """
    def test_assemble_xml_file(self):
        """Test for border colour styles."""
        self.maxDiff = None

        fh = StringIO()
        style = Styles()
        style._set_filehandle(fh)

        workbook = Workbook()

        workbook.add_format({
            'left': 1,
            'right': 1,
            'top': 1,
            'bottom': 1,
            'diag_border': 1,
            'diag_type': 3,
            'left_color': 'red',
            'right_color': 'red',
            'top_color': 'red',
            'bottom_color': 'red',
            'diag_color': 'red'})

        workbook._set_default_xf_indices()
        workbook._prepare_format_properties()

        style._set_style_properties([
            workbook.xf_formats,
            workbook.palette,
            workbook.font_count,
            workbook.num_format_count,
            workbook.border_count,
            workbook.fill_count,
            workbook.custom_colors,
            workbook.dxf_formats,
            workbook.has_comments,
        ])

        style._assemble_xml_file()
        workbook.fileclosed = 1

        exp = _xml_to_list("""
                <?xml version="1.0" encoding="UTF-8" standalone="yes"?>
                <styleSheet xmlns="http://schemas.openxmlformats.org/spreadsheetml/2006/main">
                  <fonts count="1">
                    <font>
                      <sz val="11"/>
                      <color theme="1"/>
                      <name val="Calibri"/>
                      <family val="2"/>
                      <scheme val="minor"/>
                    </font>
                  </fonts>
                  <fills count="2">
                    <fill>
                      <patternFill patternType="none"/>
                    </fill>
                    <fill>
                      <patternFill patternType="gray125"/>
                    </fill>
                  </fills>
                  <borders count="2">
                    <border>
                      <left/>
                      <right/>
                      <top/>
                      <bottom/>
                      <diagonal/>
                    </border>
                    <border diagonalUp="1" diagonalDown="1">
                      <left style="thin">
                        <color rgb="FFFF0000"/>
                      </left>
                      <right style="thin">
                        <color rgb="FFFF0000"/>
                      </right>
                      <top style="thin">
                        <color rgb="FFFF0000"/>
                      </top>
                      <bottom style="thin">
                        <color rgb="FFFF0000"/>
                      </bottom>
                      <diagonal style="thin">
                        <color rgb="FFFF0000"/>
                      </diagonal>
                    </border>
                  </borders>
                  <cellStyleXfs count="1">
                    <xf numFmtId="0" fontId="0" fillId="0" borderId="0"/>
                  </cellStyleXfs>
                  <cellXfs count="2">
                    <xf numFmtId="0" fontId="0" fillId="0" borderId="0" xfId="0"/>
                    <xf numFmtId="0" fontId="0" fillId="0" borderId="1" xfId="0" applyBorder="1"/>
                  </cellXfs>
                  <cellStyles count="1">
                    <cellStyle name="Normal" xfId="0" builtinId="0"/>
                  </cellStyles>
                  <dxfs count="0"/>
                  <tableStyles count="0" defaultTableStyle="TableStyleMedium9" defaultPivotStyle="PivotStyleLight16"/>
                </styleSheet>
                """)

        got = _xml_to_list(fh.getvalue())

        self.assertEqual(got, exp)
