/*******************************************************************************
 * Copyright (c) 2015 Olivier Langella <Olivier.Langella@moulon.inra.fr>.
 *
 * This file is part of XTPcpp.
 *
 *     XTPcpp is free software: you can redistribute it and/or modify
 *     it under the terms of the GNU General Public License as published by
 *     the Free Software Foundation, either version 3 of the License, or
 *     (at your option) any later version.
 *
 *     XTPcpp is distributed in the hope that it will be useful,
 *     but WITHOUT ANY WARRANTY; without even the implied warranty of
 *     MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *     GNU General Public License for more details.
 *
 *     You should have received a copy of the GNU General Public License
 *     along with XTPcpp.  If not, see <http://www.gnu.org/licenses/>.
 *
 * Contributors:
 *     Olivier Langella <Olivier.Langella@moulon.inra.fr> - initial API and
 *implementation
 ******************************************************************************/
#ifndef XPIPFILE_H
#define XPIPFILE_H

#include <QUrl>
#include <QFileInfo>
#include "../core/project.h"
#include "../utils/workmonitor.h"

class XpipFile
{
  public:
  XpipFile(const QUrl &xpip_source);
  XpipFile(const QFileInfo &xpip_source);
  XpipFile(const XpipFile &other);
  ~XpipFile();

  ProjectSp getProjectSp(WorkMonitorInterface *p_monitor) const;

  private:
  const QUrl _xpip_source;
};

#endif // XPIPFILE_H
