/**
 * \file core/condor_process/condorqxmlsaxhandler.h
 * \date 15/9/2017
 * \author Olivier Langella
 * \brief parse condor_q XML
 */


/*******************************************************************************
 * Copyright (c) 2017 Olivier Langella <Olivier.Langella@u-psud.fr>.
 *
 * This file is part of XTPcpp.
 *
 *     XTPcpp is free software: you can redistribute it and/or modify
 *     it under the terms of the GNU General Public License as published by
 *     the Free Software Foundation, either version 3 of the License, or
 *     (at your option) any later version.
 *
 *     XTPcpp is distributed in the hope that it will be useful,
 *     but WITHOUT ANY WARRANTY; without even the implied warranty of
 *     MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *     GNU General Public License for more details.
 *
 *     You should have received a copy of the GNU General Public License
 *     along with XTPcpp.  If not, see <http://www.gnu.org/licenses/>.
 *
 * Contributors:
 *     Olivier Langella <Olivier.Langella@u-psud.fr> - initial API and
 *implementation
 ******************************************************************************/

#pragma once

#include <QXmlDefaultHandler>

class CondorProcess;

/** \def CondorJobStatus
 * */
enum class CondorJobStatus : std::int8_t
{
  Unexpanded     = 0, ///< 0 Unexpanded U
  Idle           = 1, ///< 1 Idle I
  Running        = 2, ///< 2 Running R
  Removed        = 3, ///< 3 Removed X
  Completed      = 4, ///< 4 Completed C
  Held           = 5, ///< 5 Held H
  Submission_err = 6  ///< 6 Submission_err E
};

class CondorQxmlSaxHandler : public QXmlDefaultHandler
{
  public:
  CondorQxmlSaxHandler(CondorProcess *p_condor_process);
  ~CondorQxmlSaxHandler();

  bool startElement(const QString &namespaceURI,
                    const QString &localName,
                    const QString &qName,
                    const QXmlAttributes &attributes);

  bool endElement(const QString &namespaceURI,
                  const QString &localName,
                  const QString &qName);

  bool startDocument();

  bool endDocument();

  bool characters(const QString &str);

  bool fatalError(const QXmlParseException &exception);
  bool error(const QXmlParseException &exception);

  QString errorString() const;

  private:
  bool startElement_c(QXmlAttributes attributes);
  bool startElement_a(QXmlAttributes attributes);
  bool endElement_c();
  bool endElement_a();
  bool endElement_i();
  bool endElement_s();

  private:
  CondorProcess *mp_condorProcess;

  std::vector<QString> m_tagStack;
  QString m_errorStr;
  QString m_currentText;

  QString m_inName;
  CondorJobStatus m_condorJobStatus;
  std::size_t m_currentProcId;
  QString m_currentRemoteHost;
  QString m_currentLastRemoteHost;

  std::int8_t m_countStatus[10];
  bool m_isEmpty;
};
