/* yForth? - A Forth interpreter written in ANSI C
 * Copyright (C) 2012 Luca Padovani
 *
 * This program is free software: you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation, either version 3 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program.  If not, see <http://www.gnu.org/licenses/>.
 * ------------------------------------------------------------------------
 * Module name:     locals.h
 * Abstract:        include file for "locals" word set
 */

#ifdef DECLARE_WORDS
#	ifdef PROTOTYPES
#		undef PROTOTYPES
#	endif
#	undef __LOCALS_H__
#else
#	ifndef PROTOTYPES
#		define PROTOTYPES
#	endif
#endif

#ifndef __LOCALS_H__
#define __LOCALS_H__

#include "yforth.h"
#include "macro.h"

/**************************************************************************/
/* PROTOTYPES *************************************************************/
/**************************************************************************/

code(paren_local_paren,				"(local)",				COMP_ONLY)

code(paren_bp_restore_paren,		"(bp!)",				0)
code(paren_bp_save_paren,			"(bp@)",				0)
code(paren_read_local_paren,		"(rLocal)",				0)
code(paren_write_local_paren,		"(wLocal)",				0)

#ifdef PROTOTYPES

/**************************************************************************/
/* AUXILIARY FUNCTIONS PROTOTYPES *****************************************/
/**************************************************************************/

void clear_locals(void);
void free_locals(void);
void init_locals(void);
void declare_local(Char *s, UCell u);
struct word_def *get_first_local(void);
int locals_defined(void);

#endif

#endif

