/*
 * Decompiled with CFR 0.152.
 */
package edu.cornell.med.icb.goby.compression;

import com.google.protobuf.GeneratedMessage;
import com.google.protobuf.Message;
import com.google.protobuf.MessageLite;
import edu.cornell.med.icb.goby.alignments.AlignmentCollectionHandler;
import edu.cornell.med.icb.goby.compression.ChunkCodec;
import edu.cornell.med.icb.goby.compression.ChunkCodecHelper;
import edu.cornell.med.icb.goby.compression.GZipChunkCodec;
import edu.cornell.med.icb.goby.compression.HybridChunkCodec1;
import edu.cornell.med.icb.goby.compression.ProtobuffCollectionHandler;
import edu.cornell.med.icb.goby.util.WarningCounter;
import edu.cornell.med.icb.goby.util.dynoptions.DynamicOptionClient;
import edu.cornell.med.icb.goby.util.dynoptions.DynamicOptionRegistry;
import edu.cornell.med.icb.goby.util.dynoptions.RegisterThis;
import java.io.ByteArrayOutputStream;
import java.io.DataOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.io.PrintStream;
import java.io.PrintWriter;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class MessageChunksWriter {
    private static final Log LOG = LogFactory.getLog(MessageChunksWriter.class);
    public static final byte DELIMITER_CONTENT = -1;
    public static final int DELIMITER_LENGTH = 7;
    public static final int SIZE_OF_MESSAGE_LENGTH = 4;
    private ChunkCodec chunkCodec = null;
    private static final int DEFAULT_CHUNK_SIZE = 10000;
    private int numEntriesPerChunk = 10000;
    private final DataOutputStream out;
    private int numAppended;
    private long totalEntriesWritten;
    private long totalBytesWritten;
    private long currentChunkStartOffset;
    private long writtenBytes = 0L;
    private final boolean compressingCodec;
    private static final int OPTION_NOT_SET = -1;
    @RegisterThis
    public static final DynamicOptionClient doc = new DynamicOptionClient(MessageChunksWriter.class, "compressing-codec:boolean, when true compress protocol buffers with new chunk codec.:false", "template-compression:boolean, when true use template compression.:true", "codec:string, name of the chunk codec to use.:gzip", String.format("chunk-size:integer, the number of entries per chunk.:%d", -1));
    private boolean useTemplateCompression;
    private static WarningCounter chunkSizeWarning = new WarningCounter(1);

    public static DynamicOptionClient doc() {
        DynamicOptionRegistry.register(AlignmentCollectionHandler.doc());
        return doc;
    }

    public void setNumEntriesPerChunk(int numEntriesPerChunk) {
        if (numEntriesPerChunk != this.numEntriesPerChunk) {
            LOG.warn((Object)("Using chunk-size=" + numEntriesPerChunk));
        }
        this.numEntriesPerChunk = numEntriesPerChunk;
    }

    public MessageChunksWriter(OutputStream output) {
        this.out = new DataOutputStream(output);
        this.compressingCodec = doc.getBoolean("compressing-codec");
        String codecName = doc.getString("codec");
        this.chunkCodec = ChunkCodecHelper.load(codecName);
        assert (this.chunkCodec != null) : "ChunkCodec could not be loaded. Check your configuration.";
        this.useTemplateCompression = doc.getBoolean("template-compression");
        this.numEntriesPerChunk = doc.getInteger("chunk-size");
        if (this.numEntriesPerChunk == -1) {
            this.numEntriesPerChunk = this.chunkCodec.getSuggestedChunkSize();
        }
        chunkSizeWarning.warn(LOG, "Using chunk-size=" + this.numEntriesPerChunk, new Object[0]);
    }

    public void writeAsNeeded(GeneratedMessage.Builder collectionBuilder) throws IOException {
        this.writeAsNeeded(collectionBuilder, 1);
    }

    public long writeAsNeeded(GeneratedMessage.Builder collectionBuilder, int multiplicity) throws IOException {
        this.totalEntriesWritten += (long)Math.max(1, multiplicity);
        if (++this.numAppended >= this.numEntriesPerChunk) {
            this.flush(collectionBuilder);
        }
        return this.currentChunkStartOffset;
    }

    public long getCurrentChunkStartOffset() {
        return this.currentChunkStartOffset;
    }

    public void flush(GeneratedMessage.Builder collectionBuilder) throws IOException {
        if (this.totalEntriesWritten == 0L || this.numAppended > 0) {
            this.currentChunkStartOffset = this.writtenBytes;
            assert (this.out.size() == Integer.MAX_VALUE || (long)this.out.size() == this.writtenBytes);
            if (LOG.isTraceEnabled()) {
                LOG.trace((Object)"writing zero bytes length=7");
            }
            this.out.writeByte(this.chunkCodec.registrationCode());
            ++this.writtenBytes;
            for (int i = 0; i < 7; ++i) {
                this.out.writeByte(-1);
                ++this.writtenBytes;
            }
            MessageLite protobuffCollection = collectionBuilder.clone().build();
            ByteArrayOutputStream compressedBytes = this.chunkCodec.encode((Message)protobuffCollection);
            int serializedSize = compressedBytes.size();
            if (LOG.isTraceEnabled()) {
                LOG.trace((Object)("serialized compressed size: " + serializedSize));
            }
            this.out.writeInt(serializedSize);
            this.writtenBytes += 4L;
            byte[] bytes = compressedBytes.toByteArray();
            this.out.write(bytes);
            this.writtenBytes += (long)bytes.length;
            compressedBytes.close();
            this.totalBytesWritten += (long)(serializedSize + 4 + 7);
            if (LOG.isTraceEnabled()) {
                LOG.trace((Object)("current offset: " + this.totalBytesWritten));
            }
            this.out.flush();
            this.numAppended = 0;
            collectionBuilder.clear();
        }
    }

    public void close(GeneratedMessage.Builder collectionBuilder) throws IOException {
        this.flush(collectionBuilder);
        this.out.writeByte(255);
        ++this.writtenBytes;
        for (int i = 0; i < 7; ++i) {
            this.out.writeByte(-1);
            ++this.writtenBytes;
        }
        this.out.writeInt(0);
        this.writtenBytes += 4L;
        this.out.flush();
    }

    public long getTotalEntriesWritten() {
        return this.totalEntriesWritten;
    }

    public long getTotalBytesWritten() {
        return this.totalBytesWritten;
    }

    public void printStats(PrintWriter writer) {
        writer.println("Total logical entries written: " + this.totalEntriesWritten);
        writer.println("Total bytes written: " + this.totalBytesWritten);
        writer.println("Average bytes/logical entry: " + (float)this.totalBytesWritten / (float)this.totalEntriesWritten);
        writer.flush();
    }

    public void printStats(PrintStream out) {
        this.printStats(new PrintWriter(out));
    }

    public int getAppendedInChunk() {
        return this.numAppended;
    }

    public void setParser(ProtobuffCollectionHandler protobuffCollectionHandler) {
        if (this.chunkCodec == null) {
            this.chunkCodec = protobuffCollectionHandler instanceof AlignmentCollectionHandler ? (this.compressingCodec ? new HybridChunkCodec1() : new GZipChunkCodec()) : new GZipChunkCodec();
        }
        protobuffCollectionHandler.setUseTemplateCompression(this.useTemplateCompression);
        this.chunkCodec.setHandler(protobuffCollectionHandler);
    }
}

