// Code generated by protoc-gen-go. DO NOT EDIT.
// source: google/ads/googleads/v0/resources/user_list.proto

package resources // import "google.golang.org/genproto/googleapis/ads/googleads/v0/resources"

import proto "github.com/golang/protobuf/proto"
import fmt "fmt"
import math "math"
import wrappers "github.com/golang/protobuf/ptypes/wrappers"
import common "google.golang.org/genproto/googleapis/ads/googleads/v0/common"
import enums "google.golang.org/genproto/googleapis/ads/googleads/v0/enums"

// Reference imports to suppress errors if they are not otherwise used.
var _ = proto.Marshal
var _ = fmt.Errorf
var _ = math.Inf

// This is a compile-time assertion to ensure that this generated file
// is compatible with the proto package it is being compiled against.
// A compilation error at this line likely means your copy of the
// proto package needs to be updated.
const _ = proto.ProtoPackageIsVersion2 // please upgrade the proto package

// A user list. This is a list of users a customer may target.
type UserList struct {
	// The resource name of the user list.
	// User list resource names have the form:
	//
	// `customers/{customer_id}/userLists/{user_list_id}`
	ResourceName string `protobuf:"bytes,1,opt,name=resource_name,json=resourceName,proto3" json:"resource_name,omitempty"`
	// Id of the user list.
	Id *wrappers.Int64Value `protobuf:"bytes,2,opt,name=id,proto3" json:"id,omitempty"`
	// A flag that indicates if a user may edit a list. Depends on the list
	// ownership and list type. For example, external remarketing user lists are
	// not editable.
	//
	// This field is read-only.
	ReadOnly *wrappers.BoolValue `protobuf:"bytes,3,opt,name=read_only,json=readOnly,proto3" json:"read_only,omitempty"`
	// Name of this user list. Depending on its access_reason, the user list name
	// may not be unique (e.g. if access_reason=SHARED)
	Name *wrappers.StringValue `protobuf:"bytes,4,opt,name=name,proto3" json:"name,omitempty"`
	// Description of this user list.
	Description *wrappers.StringValue `protobuf:"bytes,5,opt,name=description,proto3" json:"description,omitempty"`
	// Membership status of this user list. Indicates whether a user list is open
	// or active. Only open user lists can accumulate more users and can be
	// targeted to.
	MembershipStatus enums.UserListMembershipStatusEnum_UserListMembershipStatus `protobuf:"varint,6,opt,name=membership_status,json=membershipStatus,proto3,enum=google.ads.googleads.v0.enums.UserListMembershipStatusEnum_UserListMembershipStatus" json:"membership_status,omitempty"`
	// An ID from external system. It is used by user list sellers to correlate
	// IDs on their systems.
	IntegrationCode *wrappers.StringValue `protobuf:"bytes,7,opt,name=integration_code,json=integrationCode,proto3" json:"integration_code,omitempty"`
	// Number of days a user's cookie stays on your list since its most recent
	// addition to the list. This field must be between 0 and 540 inclusive.
	// However, for CRM based userlists, this field can be set to 10000 which
	// means no expiration.
	//
	// It'll be ignored for logical_user_list.
	MembershipLifeSpan *wrappers.Int64Value `protobuf:"bytes,8,opt,name=membership_life_span,json=membershipLifeSpan,proto3" json:"membership_life_span,omitempty"`
	// Estimated number of users in this user list, on the Google Display Network.
	// This value is null if the number of users has not yet been determined.
	//
	// This field is read-only.
	SizeForDisplay *wrappers.Int64Value `protobuf:"bytes,9,opt,name=size_for_display,json=sizeForDisplay,proto3" json:"size_for_display,omitempty"`
	// Size range in terms of number of users of the UserList, on the Google
	// Display Network.
	//
	// This field is read-only.
	SizeRangeForDisplay enums.UserListSizeRangeEnum_UserListSizeRange `protobuf:"varint,10,opt,name=size_range_for_display,json=sizeRangeForDisplay,proto3,enum=google.ads.googleads.v0.enums.UserListSizeRangeEnum_UserListSizeRange" json:"size_range_for_display,omitempty"`
	// Estimated number of users in this user list in the google.com domain.
	// These are the users available for targeting in Search campaigns.
	// This value is null if the number of users has not yet been determined.
	//
	// This field is read-only.
	SizeForSearch *wrappers.Int64Value `protobuf:"bytes,11,opt,name=size_for_search,json=sizeForSearch,proto3" json:"size_for_search,omitempty"`
	// Size range in terms of number of users of the UserList, for Search ads.
	//
	// This field is read-only.
	SizeRangeForSearch enums.UserListSizeRangeEnum_UserListSizeRange `protobuf:"varint,12,opt,name=size_range_for_search,json=sizeRangeForSearch,proto3,enum=google.ads.googleads.v0.enums.UserListSizeRangeEnum_UserListSizeRange" json:"size_range_for_search,omitempty"`
	// Type of this list.
	//
	// This field is read-only.
	Type enums.UserListTypeEnum_UserListType `protobuf:"varint,13,opt,name=type,proto3,enum=google.ads.googleads.v0.enums.UserListTypeEnum_UserListType" json:"type,omitempty"`
	// Indicating the reason why this user list membership status is closed. It is
	// only populated on lists that were automatically closed due to inactivity,
	// and will be cleared once the list membership status becomes open.
	ClosingReason enums.UserListClosingReasonEnum_UserListClosingReason `protobuf:"varint,14,opt,name=closing_reason,json=closingReason,proto3,enum=google.ads.googleads.v0.enums.UserListClosingReasonEnum_UserListClosingReason" json:"closing_reason,omitempty"`
	// Indicates the reason this account has been granted access to the list.
	// The reason can be SHARED, OWNED, LICENSED or SUBSCRIBED.
	//
	// This field is read-only.
	AccessReason enums.AccessReasonEnum_AccessReason `protobuf:"varint,15,opt,name=access_reason,json=accessReason,proto3,enum=google.ads.googleads.v0.enums.AccessReasonEnum_AccessReason" json:"access_reason,omitempty"`
	// Indicates if this share is still enabled. When a UserList is shared with
	// the user this field is set to ENABLED. Later the userList owner can decide
	// to revoke the share and make it DISABLED.
	// The default value of this field is set to ENABLED.
	AccountUserListStatus enums.UserListAccessStatusEnum_UserListAccessStatus `protobuf:"varint,16,opt,name=account_user_list_status,json=accountUserListStatus,proto3,enum=google.ads.googleads.v0.enums.UserListAccessStatusEnum_UserListAccessStatus" json:"account_user_list_status,omitempty"`
	// Indicates if this user list is eligible for Google Search Network.
	EligibleForSearch *wrappers.BoolValue `protobuf:"bytes,17,opt,name=eligible_for_search,json=eligibleForSearch,proto3" json:"eligible_for_search,omitempty"`
	// Indicates this user list is eligible for Google Display Network.
	//
	// This field is read-only.
	EligibleForDisplay *wrappers.BoolValue `protobuf:"bytes,18,opt,name=eligible_for_display,json=eligibleForDisplay,proto3" json:"eligible_for_display,omitempty"`
	// The user list.
	//
	// Exactly one must be set.
	//
	// Types that are valid to be assigned to UserList:
	//	*UserList_CrmBasedUserList
	//	*UserList_SimilarUserList
	UserList             isUserList_UserList `protobuf_oneof:"user_list"`
	XXX_NoUnkeyedLiteral struct{}            `json:"-"`
	XXX_unrecognized     []byte              `json:"-"`
	XXX_sizecache        int32               `json:"-"`
}

func (m *UserList) Reset()         { *m = UserList{} }
func (m *UserList) String() string { return proto.CompactTextString(m) }
func (*UserList) ProtoMessage()    {}
func (*UserList) Descriptor() ([]byte, []int) {
	return fileDescriptor_user_list_be045e08990b40e2, []int{0}
}
func (m *UserList) XXX_Unmarshal(b []byte) error {
	return xxx_messageInfo_UserList.Unmarshal(m, b)
}
func (m *UserList) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	return xxx_messageInfo_UserList.Marshal(b, m, deterministic)
}
func (dst *UserList) XXX_Merge(src proto.Message) {
	xxx_messageInfo_UserList.Merge(dst, src)
}
func (m *UserList) XXX_Size() int {
	return xxx_messageInfo_UserList.Size(m)
}
func (m *UserList) XXX_DiscardUnknown() {
	xxx_messageInfo_UserList.DiscardUnknown(m)
}

var xxx_messageInfo_UserList proto.InternalMessageInfo

func (m *UserList) GetResourceName() string {
	if m != nil {
		return m.ResourceName
	}
	return ""
}

func (m *UserList) GetId() *wrappers.Int64Value {
	if m != nil {
		return m.Id
	}
	return nil
}

func (m *UserList) GetReadOnly() *wrappers.BoolValue {
	if m != nil {
		return m.ReadOnly
	}
	return nil
}

func (m *UserList) GetName() *wrappers.StringValue {
	if m != nil {
		return m.Name
	}
	return nil
}

func (m *UserList) GetDescription() *wrappers.StringValue {
	if m != nil {
		return m.Description
	}
	return nil
}

func (m *UserList) GetMembershipStatus() enums.UserListMembershipStatusEnum_UserListMembershipStatus {
	if m != nil {
		return m.MembershipStatus
	}
	return enums.UserListMembershipStatusEnum_UNSPECIFIED
}

func (m *UserList) GetIntegrationCode() *wrappers.StringValue {
	if m != nil {
		return m.IntegrationCode
	}
	return nil
}

func (m *UserList) GetMembershipLifeSpan() *wrappers.Int64Value {
	if m != nil {
		return m.MembershipLifeSpan
	}
	return nil
}

func (m *UserList) GetSizeForDisplay() *wrappers.Int64Value {
	if m != nil {
		return m.SizeForDisplay
	}
	return nil
}

func (m *UserList) GetSizeRangeForDisplay() enums.UserListSizeRangeEnum_UserListSizeRange {
	if m != nil {
		return m.SizeRangeForDisplay
	}
	return enums.UserListSizeRangeEnum_UNSPECIFIED
}

func (m *UserList) GetSizeForSearch() *wrappers.Int64Value {
	if m != nil {
		return m.SizeForSearch
	}
	return nil
}

func (m *UserList) GetSizeRangeForSearch() enums.UserListSizeRangeEnum_UserListSizeRange {
	if m != nil {
		return m.SizeRangeForSearch
	}
	return enums.UserListSizeRangeEnum_UNSPECIFIED
}

func (m *UserList) GetType() enums.UserListTypeEnum_UserListType {
	if m != nil {
		return m.Type
	}
	return enums.UserListTypeEnum_UNSPECIFIED
}

func (m *UserList) GetClosingReason() enums.UserListClosingReasonEnum_UserListClosingReason {
	if m != nil {
		return m.ClosingReason
	}
	return enums.UserListClosingReasonEnum_UNSPECIFIED
}

func (m *UserList) GetAccessReason() enums.AccessReasonEnum_AccessReason {
	if m != nil {
		return m.AccessReason
	}
	return enums.AccessReasonEnum_UNSPECIFIED
}

func (m *UserList) GetAccountUserListStatus() enums.UserListAccessStatusEnum_UserListAccessStatus {
	if m != nil {
		return m.AccountUserListStatus
	}
	return enums.UserListAccessStatusEnum_UNSPECIFIED
}

func (m *UserList) GetEligibleForSearch() *wrappers.BoolValue {
	if m != nil {
		return m.EligibleForSearch
	}
	return nil
}

func (m *UserList) GetEligibleForDisplay() *wrappers.BoolValue {
	if m != nil {
		return m.EligibleForDisplay
	}
	return nil
}

type isUserList_UserList interface {
	isUserList_UserList()
}

type UserList_CrmBasedUserList struct {
	CrmBasedUserList *common.CrmBasedUserListInfo `protobuf:"bytes,19,opt,name=crm_based_user_list,json=crmBasedUserList,proto3,oneof"`
}

type UserList_SimilarUserList struct {
	SimilarUserList *common.SimilarUserListInfo `protobuf:"bytes,20,opt,name=similar_user_list,json=similarUserList,proto3,oneof"`
}

func (*UserList_CrmBasedUserList) isUserList_UserList() {}

func (*UserList_SimilarUserList) isUserList_UserList() {}

func (m *UserList) GetUserList() isUserList_UserList {
	if m != nil {
		return m.UserList
	}
	return nil
}

func (m *UserList) GetCrmBasedUserList() *common.CrmBasedUserListInfo {
	if x, ok := m.GetUserList().(*UserList_CrmBasedUserList); ok {
		return x.CrmBasedUserList
	}
	return nil
}

func (m *UserList) GetSimilarUserList() *common.SimilarUserListInfo {
	if x, ok := m.GetUserList().(*UserList_SimilarUserList); ok {
		return x.SimilarUserList
	}
	return nil
}

// XXX_OneofFuncs is for the internal use of the proto package.
func (*UserList) XXX_OneofFuncs() (func(msg proto.Message, b *proto.Buffer) error, func(msg proto.Message, tag, wire int, b *proto.Buffer) (bool, error), func(msg proto.Message) (n int), []interface{}) {
	return _UserList_OneofMarshaler, _UserList_OneofUnmarshaler, _UserList_OneofSizer, []interface{}{
		(*UserList_CrmBasedUserList)(nil),
		(*UserList_SimilarUserList)(nil),
	}
}

func _UserList_OneofMarshaler(msg proto.Message, b *proto.Buffer) error {
	m := msg.(*UserList)
	// user_list
	switch x := m.UserList.(type) {
	case *UserList_CrmBasedUserList:
		b.EncodeVarint(19<<3 | proto.WireBytes)
		if err := b.EncodeMessage(x.CrmBasedUserList); err != nil {
			return err
		}
	case *UserList_SimilarUserList:
		b.EncodeVarint(20<<3 | proto.WireBytes)
		if err := b.EncodeMessage(x.SimilarUserList); err != nil {
			return err
		}
	case nil:
	default:
		return fmt.Errorf("UserList.UserList has unexpected type %T", x)
	}
	return nil
}

func _UserList_OneofUnmarshaler(msg proto.Message, tag, wire int, b *proto.Buffer) (bool, error) {
	m := msg.(*UserList)
	switch tag {
	case 19: // user_list.crm_based_user_list
		if wire != proto.WireBytes {
			return true, proto.ErrInternalBadWireType
		}
		msg := new(common.CrmBasedUserListInfo)
		err := b.DecodeMessage(msg)
		m.UserList = &UserList_CrmBasedUserList{msg}
		return true, err
	case 20: // user_list.similar_user_list
		if wire != proto.WireBytes {
			return true, proto.ErrInternalBadWireType
		}
		msg := new(common.SimilarUserListInfo)
		err := b.DecodeMessage(msg)
		m.UserList = &UserList_SimilarUserList{msg}
		return true, err
	default:
		return false, nil
	}
}

func _UserList_OneofSizer(msg proto.Message) (n int) {
	m := msg.(*UserList)
	// user_list
	switch x := m.UserList.(type) {
	case *UserList_CrmBasedUserList:
		s := proto.Size(x.CrmBasedUserList)
		n += 2 // tag and wire
		n += proto.SizeVarint(uint64(s))
		n += s
	case *UserList_SimilarUserList:
		s := proto.Size(x.SimilarUserList)
		n += 2 // tag and wire
		n += proto.SizeVarint(uint64(s))
		n += s
	case nil:
	default:
		panic(fmt.Sprintf("proto: unexpected type %T in oneof", x))
	}
	return n
}

func init() {
	proto.RegisterType((*UserList)(nil), "google.ads.googleads.v0.resources.UserList")
}

func init() {
	proto.RegisterFile("google/ads/googleads/v0/resources/user_list.proto", fileDescriptor_user_list_be045e08990b40e2)
}

var fileDescriptor_user_list_be045e08990b40e2 = []byte{
	// 825 bytes of a gzipped FileDescriptorProto
	0x1f, 0x8b, 0x08, 0x00, 0x00, 0x00, 0x00, 0x00, 0x02, 0xff, 0xac, 0x96, 0x4d, 0x4f, 0xe3, 0x46,
	0x18, 0xc7, 0xeb, 0x40, 0x29, 0x99, 0x90, 0xb7, 0x09, 0x54, 0x16, 0xad, 0x2a, 0x68, 0x55, 0x09,
	0xa9, 0x92, 0x9d, 0x02, 0x6a, 0x2b, 0x81, 0x5a, 0x25, 0x29, 0x50, 0x50, 0xa0, 0xc8, 0xa1, 0x1c,
	0xaa, 0x48, 0xd6, 0xc4, 0x9e, 0x98, 0x91, 0xec, 0x19, 0x6b, 0xc6, 0xa6, 0x0a, 0x3d, 0xed, 0x61,
	0xbf, 0xc8, 0x1e, 0xf7, 0xa3, 0xac, 0xf6, 0xb4, 0x9f, 0x68, 0xe5, 0xf1, 0x4b, 0xec, 0xb0, 0x21,
	0x3e, 0xec, 0x6d, 0xfc, 0xf8, 0xf9, 0xfd, 0xff, 0xf3, 0x3c, 0xf3, 0x62, 0x83, 0x9f, 0x1d, 0xc6,
	0x1c, 0x17, 0xeb, 0xc8, 0x16, 0x7a, 0x3c, 0x8c, 0x46, 0x8f, 0x5d, 0x9d, 0x63, 0xc1, 0x42, 0x6e,
	0x61, 0xa1, 0x87, 0x02, 0x73, 0xd3, 0x25, 0x22, 0xd0, 0x7c, 0xce, 0x02, 0x06, 0xf7, 0xe3, 0x3c,
	0x0d, 0xd9, 0x42, 0xcb, 0x10, 0xed, 0xb1, 0xab, 0x65, 0xc8, 0xae, 0xbe, 0x4c, 0xd5, 0x62, 0x9e,
	0xc7, 0xe8, 0x5c, 0x52, 0xc4, 0x9a, 0xbb, 0x4b, 0xa7, 0x81, 0x69, 0xe8, 0x09, 0x1d, 0x59, 0x16,
	0x16, 0xc2, 0xe4, 0x18, 0x09, 0x46, 0x13, 0xe4, 0xe4, 0x65, 0x24, 0xb3, 0x30, 0x13, 0x58, 0x04,
	0x28, 0x08, 0x53, 0xbf, 0xd3, 0xb2, 0xb0, 0xe5, 0x32, 0x41, 0xa8, 0x53, 0xb4, 0xfe, 0xa3, 0x2c,
	0xed, 0x61, 0x6f, 0x82, 0xb9, 0x78, 0x20, 0x7e, 0xd1, 0xfe, 0xb7, 0xb2, 0x02, 0x82, 0x3c, 0x61,
	0x93, 0x23, 0xea, 0xe0, 0x84, 0x3c, 0x2c, 0x4b, 0x06, 0x33, 0x3f, 0x65, 0xbe, 0x4b, 0x18, 0xf9,
	0x34, 0x09, 0xa7, 0xfa, 0x7f, 0x1c, 0xf9, 0x3e, 0xe6, 0xc9, 0x6c, 0xbe, 0x7f, 0x5f, 0x07, 0x9b,
	0xff, 0x08, 0xcc, 0x87, 0x44, 0x04, 0xf0, 0x07, 0x50, 0x4f, 0xd7, 0xd1, 0xa4, 0xc8, 0xc3, 0xaa,
	0xb2, 0xa7, 0x1c, 0x54, 0x8d, 0xad, 0x34, 0x78, 0x83, 0x3c, 0x0c, 0x7f, 0x02, 0x15, 0x62, 0xab,
	0x95, 0x3d, 0xe5, 0xa0, 0x76, 0xf8, 0x4d, 0xb2, 0x09, 0xb4, 0x54, 0x5e, 0xbb, 0xa4, 0xc1, 0x2f,
	0xc7, 0xf7, 0xc8, 0x0d, 0xb1, 0x51, 0x21, 0x36, 0xfc, 0x15, 0x54, 0x39, 0x46, 0xb6, 0xc9, 0xa8,
	0x3b, 0x53, 0xd7, 0x24, 0xb3, 0xfb, 0x8c, 0xe9, 0x33, 0xe6, 0xc6, 0xc8, 0x66, 0x94, 0xfc, 0x37,
	0x75, 0x67, 0xb0, 0x0b, 0xd6, 0xe5, 0x0c, 0xd6, 0x25, 0xf3, 0xed, 0x33, 0x66, 0x14, 0x70, 0x42,
	0x9d, 0x98, 0x92, 0x99, 0xf0, 0x77, 0x50, 0xb3, 0xb1, 0xb0, 0x38, 0xf1, 0x03, 0xc2, 0xa8, 0xfa,
	0x65, 0x09, 0x30, 0x0f, 0xc0, 0x57, 0x0a, 0x68, 0x3f, 0x5b, 0x33, 0x75, 0x63, 0x4f, 0x39, 0x68,
	0x1c, 0xde, 0x69, 0xcb, 0xf6, 0xbd, 0x6c, 0xbd, 0x96, 0x76, 0xf0, 0x3a, 0xe3, 0x47, 0x12, 0x3f,
	0xa3, 0xa1, 0xb7, 0xf4, 0xa5, 0xd1, 0xf2, 0x16, 0x22, 0xf0, 0x02, 0xb4, 0x08, 0x0d, 0xb0, 0xc3,
	0x51, 0x34, 0x25, 0xd3, 0x62, 0x36, 0x56, 0xbf, 0x2a, 0x51, 0x48, 0x33, 0x47, 0x0d, 0x98, 0x8d,
	0xe1, 0x35, 0xd8, 0xce, 0xd5, 0xe2, 0x92, 0x29, 0x36, 0x85, 0x8f, 0xa8, 0xba, 0xb9, 0x7a, 0xd9,
	0xe0, 0x1c, 0x1c, 0x92, 0x29, 0x1e, 0xf9, 0x88, 0xc2, 0x33, 0xd0, 0x92, 0xbb, 0x71, 0xca, 0xb8,
	0x69, 0x13, 0xe1, 0xbb, 0x68, 0xa6, 0x56, 0x57, 0x4b, 0x35, 0x22, 0xe8, 0x9c, 0xf1, 0x3f, 0x63,
	0x04, 0xfe, 0x0f, 0xbe, 0x9e, 0x6f, 0xea, 0x82, 0x18, 0x90, 0x6d, 0x3e, 0x2f, 0xd9, 0xe6, 0x11,
	0x79, 0xc2, 0x46, 0xa4, 0x51, 0xe8, 0x6f, 0x16, 0x35, 0x3a, 0x22, 0x1d, 0xe6, 0xcc, 0x07, 0xa0,
	0x99, 0xd5, 0x20, 0x30, 0xe2, 0xd6, 0x83, 0x5a, 0x5b, 0x5d, 0x42, 0x3d, 0x29, 0x61, 0x24, 0x09,
	0x38, 0x03, 0x3b, 0x0b, 0x15, 0x24, 0x52, 0x5b, 0x9f, 0xb5, 0x00, 0x98, 0x2f, 0x20, 0xb1, 0xbe,
	0x05, 0xeb, 0xd1, 0xb9, 0x56, 0xeb, 0xd2, 0xe9, 0xb4, 0xa4, 0xd3, 0xdd, 0xcc, 0x2f, 0x9a, 0x44,
	0x01, 0x43, 0x2a, 0xc1, 0x10, 0x34, 0x8a, 0x57, 0x9c, 0xda, 0x90, 0xda, 0x37, 0x25, 0xb5, 0x07,
	0x31, 0x6c, 0x48, 0xb6, 0x60, 0x52, 0x78, 0x63, 0xd4, 0xad, 0xfc, 0x23, 0x44, 0xa0, 0x5e, 0xb8,
	0xd3, 0xd5, 0x66, 0xa9, 0x8a, 0x7a, 0x92, 0xc9, 0x99, 0xe5, 0x03, 0xc6, 0x16, 0xca, 0x3d, 0xc1,
	0xd7, 0x0a, 0x50, 0x91, 0x65, 0xb1, 0x90, 0x06, 0x66, 0xee, 0x42, 0x8d, 0x8f, 0x74, 0x4b, 0xda,
	0x0d, 0x4b, 0x16, 0x19, 0xbb, 0x7c, 0xe2, 0x38, 0xe7, 0x5f, 0x18, 0x3b, 0x89, 0x5b, 0xb6, 0x94,
	0xf1, 0x79, 0xbe, 0x02, 0x1d, 0xec, 0x12, 0x87, 0x4c, 0xdc, 0xc2, 0x66, 0x69, 0xaf, 0xbc, 0x08,
	0xdb, 0x29, 0x36, 0x5f, 0xff, 0x21, 0xd8, 0x2e, 0x68, 0xa5, 0x47, 0x07, 0xae, 0x14, 0x83, 0x39,
	0xb1, 0xf4, 0x34, 0x60, 0xd0, 0xb1, 0xb8, 0x67, 0x4e, 0x90, 0xc0, 0xf6, 0xbc, 0x45, 0x6a, 0x47,
	0x8a, 0x1d, 0x2f, 0xed, 0x4d, 0xfc, 0x0d, 0xd7, 0x06, 0xdc, 0xeb, 0x47, 0x64, 0x5a, 0xee, 0x25,
	0x9d, 0xb2, 0xbf, 0xbe, 0x30, 0x5a, 0xd6, 0x42, 0x1c, 0x22, 0xd0, 0x16, 0xc4, 0x23, 0x2e, 0xe2,
	0x39, 0x93, 0x6d, 0x69, 0x72, 0xb4, 0xca, 0x64, 0x14, 0x83, 0x0b, 0x1e, 0x4d, 0x51, 0x0c, 0xf7,
	0x6b, 0xa0, 0x9a, 0x49, 0xf7, 0x3f, 0x28, 0xe0, 0x47, 0x8b, 0x79, 0xda, 0xca, 0xdf, 0x94, 0x7e,
	0x3d, 0x15, 0xb8, 0x8d, 0x1a, 0x76, 0xab, 0xfc, 0x7b, 0x95, 0x30, 0x0e, 0x73, 0x11, 0x75, 0x34,
	0xc6, 0x1d, 0xdd, 0xc1, 0x54, 0xb6, 0x33, 0xfd, 0xda, 0xfa, 0x44, 0xbc, 0xf0, 0xb3, 0x74, 0x92,
	0x8d, 0xde, 0x54, 0xd6, 0x2e, 0x7a, 0xbd, 0xb7, 0x95, 0xfd, 0x8b, 0x58, 0xb2, 0x67, 0x0b, 0x2d,
	0x1e, 0x46, 0xa3, 0xfb, 0xae, 0x66, 0xa4, 0x99, 0xef, 0xd2, 0x9c, 0x71, 0xcf, 0x16, 0xe3, 0x2c,
	0x67, 0x7c, 0xdf, 0x1d, 0x67, 0x39, 0x93, 0x0d, 0x39, 0x89, 0xa3, 0x8f, 0x01, 0x00, 0x00, 0xff,
	0xff, 0xbc, 0x72, 0x4d, 0xf8, 0xb0, 0x09, 0x00, 0x00,
}
