#!/bin/sh
# SPDX-License-Identifier: BSD-2-Clause
# SPDX-FileCopyrightText: © 2025 Antoine Le Gonidec <vv221@dotslashplay.it>
set -o errexit

###
# Reus 2
# send your bug reports to vv221@dotslashplay.it
###

script_version=20250828.1

PLAYIT_COMPATIBILITY_LEVEL='2.33'

GAME_ID='reus-2'
GAME_NAME='Reus 2'

ARCHIVE_BASE_2_NAME='setup_reus_2_1.8.3_(83845).exe'
ARCHIVE_BASE_2_MD5='5384f9e5fdf5375219adf7f8b8643567'
ARCHIVE_BASE_2_TYPE='innosetup'
ARCHIVE_BASE_2_SIZE='3999785'
ARCHIVE_BASE_2_VERSION='1.8.3-gog83845'
ARCHIVE_BASE_2_URL='https://www.gog.com/game/reus_2'

ARCHIVE_BASE_1_NAME='setup_reus_2_1.8.0_(83653).exe'
ARCHIVE_BASE_1_MD5='2ced0663287c4540efaffac336d42b88'
ARCHIVE_BASE_1_TYPE='innosetup'
ARCHIVE_BASE_1_SIZE='3858778'
ARCHIVE_BASE_1_VERSION='1.8.0-gog83653'

ARCHIVE_BASE_0_NAME='setup_reus_2_1.6.3_(80797).exe'
ARCHIVE_BASE_0_MD5='7d8a3aa3d7f7457cf8ef4fba979e3a7e'
ARCHIVE_BASE_0_TYPE='innosetup'
ARCHIVE_BASE_0_SIZE='3234044'
ARCHIVE_BASE_0_VERSION='1.6.3-gog80797'

UNITY3D_NAME='reus 2'

CONTENT_PATH_DEFAULT='.'

WINE_PERSISTENT_DIRECTORIES='
users/${USER}/AppData/LocalLow/Abbey Games/Reus 2'

PACKAGES_LIST='
PKG_BIN
PKG_DATA'

PKG_BIN_ARCH='64'
PKG_BIN_DEPENDENCIES_SIBLINGS='
PKG_DATA'

PKG_DATA_ID="${GAME_ID}-data"
PKG_DATA_DESCRIPTION='data'

# Load common functions.

PLAYIT_LIB_PATHS="
$PWD
${XDG_DATA_HOME:="${HOME}/.local/share"}/play.it
/usr/local/share/games/play.it
/usr/local/share/play.it
/usr/share/games/play.it
/usr/share/play.it"

if [ -z "$PLAYIT_LIB2" ]; then
	for playit_lib_path in $PLAYIT_LIB_PATHS; do
		if [ -e "${playit_lib_path}/libplayit2.sh" ]; then
			PLAYIT_LIB2="${playit_lib_path}/libplayit2.sh"
			break
		fi
	done
fi
if [ -z "$PLAYIT_LIB2" ]; then
	printf '\n\033[1;31mError:\033[0m\n'
	printf 'libplayit2.sh not found.\n'
	exit 1
fi
# shellcheck source=libplayit2.sh
. "$PLAYIT_LIB2"

# Run default initialisation actions.

initialization_default "$@"

# Extract game data.

archive_extraction_default

# Include game data.

content_inclusion_icons 'PKG_DATA'
content_inclusion_default

# Write launchers.

launchers_generation

# Build packages.

packages_generation
print_instructions

# Clean up.

working_directory_cleanup

exit 0
