      SUBROUTINE T2STAT(T2OLD,T2NEW,SYVEC1,SYVEC2,NSIZET,NSMSZ1,NSMSZ2,
     &                  ISPIN,ICONVG,TOL,NLIST,TYPE)
C
C THIS ROUTINE ACCEPTS TWO T1 VECTORS AND FINDS THE LARGEST
C  AND RMS DIFFERENCE BETWEEN THEIR ELEMENTS AND DETERMINES
C  IF THEY ARE IDENTICAL TO WITHIN A SET TOLERANCE.
C
C INPUT:  
C       T2OLD - ONE OF THE TWO T1 VECTORS.
C       T2NEW - THE OTHER T1 VECTOR.
C       SYVEC1- THE AB SYMMETRY VECTOR FOR THIS SPIN CASE
C       SYVEC2- THE IJ SYMMETRY VECTOR FOR THIS SPIN CASE
C       NSIZET- LENGTH OF THE SYMMETRY-PACKED T2 VECTOR.
C       NSMSZ1- LENGTH OF THE AB SYMMETRY VECTOR 
C       NSMSZ2- LENGTH OF THE IJ SYMMETRY VECTOR 
C       ISPIN - THE SPIN CASE
C       TOL   - THE CONVERGENCE CRITERION
C       NLIST - THE LIST NUMBER ON WHICH THE VALUES RESIDE
C       TYPE  - ?????????
C
C OUTPUT:
C       ICONVG- RETURNED AS "0" IF VALUES ARE CONVERGED, "1"
C               OTHERWISE.
C
CEND
      IMPLICIT DOUBLE PRECISION (A-H,O-Z)
      INTEGER A,B,SYVEC1(NSMSZ1),SYVEC2(NSMSZ2) 
      CHARACTER*1 TYPE
      CHARACTER*2 SPCASE(3)
      DIMENSION T2OLD(NSIZET),T2NEW(NSIZET)
      COMMON /FLAGS/ IFLAGS(100)
      DATA SPCASE /'AA','BB','AB'/
      DATA ONEM /-1.0/
C
      IF(NSIZET.EQ.0)RETURN
C
C FORM T2DIFF = T2NEW - T2OLD
C
      LSTOLD=43+ISPIN+NLIST
      LSTNEW=60+ISPIN
      CALL GETALL(T2OLD,NSIZET,1,LSTOLD)
      CALL GETALL(T2NEW,NSIZET,1,LSTNEW)
      CALL VADD(T2OLD,T2NEW,T2OLD,NSIZET,ONEM)
      RMSDIF=SNRM2(NSIZET,T2OLD,1)
      RMSDIF=RMSDIF/FLOAT(NSIZET)
      MAXDIF=ISAMAX(NSIZET,T2OLD,1)
      DIFMAX=T2OLD(MAXDIF)
      IF(DABS(DIFMAX).GT.TOL)ICONVG=1
      CALL PCKIND(MAXDIF,ISPIN,SYVEC1,SYVEC2,NSMSZ1,NSMSZ2,I,J,A,B)
      IF(IFLAGS(1).GE.10)THEN
       WRITE(*,100)TYPE,'2',SPCASE(ISPIN),RMSDIF,DIFMAX,I,J,A,B
  100  FORMAT(T9,A1,A1,T19,A2,T24,F13.10,T37,F13.10,T52,I3,T57,I3,T62,
     &        I3,T67,I3)
      ENDIF
      RETURN
      END
