/**
 * Licensed to the Apache Software Foundation (ASF) under one
 * or more contributor license agreements.  See the NOTICE file
 * distributed with this work for additional information
 * regarding copyright ownership.  The ASF licenses this file
 * to you under the Apache License, Version 2.0 (the
 * "License"); you may not use this file except in compliance
 * with the License.  You may obtain a copy of the License at
 *
 *     http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */

package org.apache.jena.riot;

import org.apache.jena.riot.writer.TestJsonLD10Writer;
import org.junit.runner.RunWith ;
import org.junit.runners.Suite ;
import org.junit.runners.Suite.SuiteClasses ;

@RunWith(Suite.class)
@SuiteClasses(
{
    TestSysRIOT.class
    , TestLangRIOT.class
    , TestSyntaxDetermination.class
    , TestJenaReaderRIOT.class
    , TestReadData.class
    , TestRiotReader.class
    , TestRDFParser.class
    , TestParserRegistry.class
    , TestRDFWriter.class
    , TestRDFParser.class
    , TestParseURISchemeBases.class

    , TestTurtleWriter.class
    , TestTurtleWriterPretty.class

    , TestJsonLDReader.class
    , TestJsonLD10Writer.class
})

public class TS_RiotGeneral
{}

