# 14.10.5 (2022-06-30)

### Security (17 changes)

- [Fix group IP restrictions not enforced for container registry requests](gitlab-org/security/gitlab@b146ad7b8c6fba9d3c5bea365ff8afd49949dcb0) ([merge request](gitlab-org/security/gitlab!2552))
- [Update rack gem to version 2.2.3.1](gitlab-org/security/gitlab@09ebb50ceee5a2226c1f70fa1d6c25391d51dda6) ([merge request](gitlab-org/security/gitlab!2554))
- [Gitlab Runner version upgrade](gitlab-org/security/gitlab@c91bfdb4f96e70e377a84b99c4edaa2fdecb8e16) ([merge request](gitlab-org/security/gitlab!2567))
- [Update ProjectAttributesTransformer to use fixed number of attributes](gitlab-org/security/gitlab@6f892fb2a4b84473c3796533551f915c16cf77d9) ([merge request](gitlab-org/security/gitlab!2549))
- [Escape deploy key title to prevent XSS](gitlab-org/security/gitlab@153a7c447e03a509b7f06ac7381f4f9db414c9ea) ([merge request](gitlab-org/security/gitlab!2494))
- [Sanitize ZenTao breadcrumb links](gitlab-org/security/gitlab@530c7be82ae90138898ff99008d994b1c85d8cf1) ([merge request](gitlab-org/security/gitlab!2557))
- [Fix permissions in the project labels API](gitlab-org/security/gitlab@f2c71f64c258bef9f56f4892d11a4dbf20d668e6) ([merge request](gitlab-org/security/gitlab!2534))
- [Security fix sentry issue leaks and access level check](gitlab-org/security/gitlab@c644d94f58e30e1a9d87521b039a347412f0fead) ([merge request](gitlab-org/security/gitlab!2501))
- [Check permissions before exposing user two factor enabled](gitlab-org/security/gitlab@8a623e8a4fdbd3421ac3ae0e37e156b7d3b04970) ([merge request](gitlab-org/security/gitlab!2525))
- [Filter milestone release by user access](gitlab-org/security/gitlab@d7d6431a52808107a71f15d29e856eef2cb313e5) ([merge request](gitlab-org/security/gitlab!2537))
- [Fix the required access level in the Conan packages finder](gitlab-org/security/gitlab@756fb242c4d6acf6cfd95fa39f37410eaf009747) ([merge request](gitlab-org/security/gitlab!2485))
- [Allow inviting only groups with subset of allowed domains to groups](gitlab-org/security/gitlab@ca50492a32a2e367b0bc75dae0f91dc52d23b2ed) ([merge request](gitlab-org/security/gitlab!2512))
- [Fix open redirect vulnerability](gitlab-org/security/gitlab@1450068a44d67af3cbe09fedcc4b1e9b4ea2e586) ([merge request](gitlab-org/security/gitlab!2540))
- [Adds a filter based on user access to Runner jobs endpoint](gitlab-org/security/gitlab@dafaf3e50e8b1a18ff362cbb60e9482c9d60fc33) ([merge request](gitlab-org/security/gitlab!2497))
- [Prevent runners from picking IP restricted jobs](gitlab-org/security/gitlab@0fad0cdde00b68c2a0f19ffa2681b438fcad4097) ([merge request](gitlab-org/security/gitlab!2503))
- [Restrict CI lint access to pipeline creators](gitlab-org/security/gitlab@c5b79e969f10e3604eff16a9edef716e700cd201) ([merge request](gitlab-org/security/gitlab!2515))
- [Catch endless headers when reading HTTP responses](gitlab-org/security/gitlab@65379002bd7a0259c425455c937b110bd96096dc) ([merge request](gitlab-org/security/gitlab!2529))

## 14.10.4 (2022-06-01)

### Security (7 changes)

- [Fix IP restrictions not applying to deploy tokens](gitlab-org/security/gitlab@8866d00e50f1d2857d54130239851f21404d7432) ([merge request](gitlab-org/security/gitlab!2471))
- [Trigger token should respect group IP restrictions](gitlab-org/security/gitlab@8534ca1be10f115dad2e0c1a4e167673049e401a) ([merge request](gitlab-org/security/gitlab!2478))
- [Fix content injection in Jira issue title](gitlab-org/security/gitlab@b8f82ec8d7ddf30c656642bff12de8fc8b5930a2) ([merge request](gitlab-org/security/gitlab!2464))
- [Subgroup member can list members of parent group](gitlab-org/security/gitlab@b59c49fa7b681a93bbe4bc69b20e72930a8b9d8d) ([merge request](gitlab-org/security/gitlab!2480))
- [Do not allow project member import when membership is locked](gitlab-org/security/gitlab@baed30570206b5ed9973ad8bfac5462721745a5d) ([merge request](gitlab-org/security/gitlab!2447))
- [Disable changing user attributes when updating SCIM provisioned user](gitlab-org/security/gitlab@ae4eb58668513f38c0daf1dc3b977c6b22a9a476) ([merge request](gitlab-org/security/gitlab!2454))
- [Allow only job owner to run interactive terminal](gitlab-org/security/gitlab@b0819e77b5a65d4412b42f27a513c02cc056a2b8) ([merge request](gitlab-org/security/gitlab!2433))

## 14.10.3 (2022-05-20)

### Added (1 change)

- [Add option to disable seperated caches](gitlab-org/gitlab@c39af3e813d5d242068a8ae7e8e011284fd385c9) by @Taucher2003 ([merge request](gitlab-org/gitlab!88013))

### Fixed (1 change)

- [Fix assignee filtering on group/project issues list](gitlab-org/gitlab@317c3a6e1e799f53d7e0812921bbffc4f4733d58) ([merge request](gitlab-org/gitlab!87729))

## 14.10.2 (2022-05-04)

### Fixed (2 changes)

- [Resolve "Fork relationship is not respected for certain projects"](gitlab-org/gitlab@881099bc27d9696ea3b9bcc2a1e43c3207ee4bb3) ([merge request](gitlab-org/gitlab!86476))
- [Fix mappings errors for ES6.8](gitlab-org/gitlab@5caac54a746a331d828d4e3ce24273cd6173c86f) ([merge request](gitlab-org/gitlab!86476)) **GitLab Enterprise Edition**

### Other (1 change)

- [Add documentation for mr settings audit events part 1](gitlab-org/gitlab@95bfdae5a677de5ac9d0d5ceccd42e88ca4f99c4) ([merge request](gitlab-org/gitlab!86476))

## 14.10.1 (2022-04-29)

### Security (14 changes)

- [Add suffix to cache name to add isolation](gitlab-org/security/gitlab@9ff0233c191339f4dd042b7f55d1ffd66b3f9a2b) ([merge request](gitlab-org/security/gitlab!2426))
- [Update Import/Export merge/push access levels & exclude ci config path](gitlab-org/security/gitlab@40f32316dad5bb0779907261215b3526ed8871fc) ([merge request](gitlab-org/security/gitlab!2404))
- [Prevent maintainers from editing PipelineSchedule](gitlab-org/security/gitlab@2ce3805447b4b3b7336d46d1d21dcd9e173c40be) ([merge request](gitlab-org/security/gitlab!2421))
- [Add validation to pypi file sha256 values](gitlab-org/security/gitlab@afc796f43df09a2e43f40beaffec942a80ad973d) ([merge request](gitlab-org/security/gitlab!2415))
- [Conan Token uses PAT rather than ID in payload](gitlab-org/security/gitlab@2679b802ac4cd9bd36190bcca691177c5568a981) ([merge request](gitlab-org/security/gitlab!2412))
- [[security] Fix markdown API disclosing issue titles of limited projects](gitlab-org/security/gitlab@66088697787bcd55a727602da4f7fdd51b997eb0) ([merge request](gitlab-org/security/gitlab!2407))
- [Verify that mentioned user can read TODO's note](gitlab-org/security/gitlab@fd166c1b4cc01e2bbbecabbab706deb423fa17f6) ([merge request](gitlab-org/security/gitlab!2397))
- [Invalidate markdown cache to clear up stored XSS](gitlab-org/security/gitlab@0a0aee802c8b7760ffb0213e67129863d1769313) ([merge request](gitlab-org/security/gitlab!2418))
- [Allow rate limiting of deploy tokens](gitlab-org/security/gitlab@8de550917a4b86a3ca3e132465d7d2c8394c4493) ([merge request](gitlab-org/security/gitlab!2395))
- [Disable wiki access with CI_JOB_TOKEN when improper access level](gitlab-org/security/gitlab@516dbcd83cb2bbda6b15e22f4fafdaed661f4eb1) ([merge request](gitlab-org/security/gitlab!2408))
- [Sanitize error input to prevent HTML/CSS injection in messages](gitlab-org/security/gitlab@c3f62e0f2965fe871463ed7a8b6e438cd2e1f515) ([merge request](gitlab-org/security/gitlab!2379))
- [Secure debug trace artifact download](gitlab-org/security/gitlab@d889fb31417a8b8c38f73341da7576e856a96c5b) ([merge request](gitlab-org/security/gitlab!2376))
- [Use password type for all secret integration properties](gitlab-org/security/gitlab@c4e2f9c3e86d832c143086f05fad382f6a218c50) ([merge request](gitlab-org/security/gitlab!2409))
- [Limit CI job group_name regexp](gitlab-org/security/gitlab@9e3fbfce686aac48402a097c16616ffffe27c32f) ([merge request](gitlab-org/security/gitlab!2382))

## 14.10.0 (2022-04-21)

### Added (141 changes)

- [Add a dropdown to switch language in code blocks](gitlab-org/gitlab@3b72b32536c5fc66e32af33ead8d6609f96df2fe) ([merge request](gitlab-org/gitlab!69131))
- [Wraps Jupyter Notebook Diff in a feature flag](gitlab-org/gitlab@bd75c1583e1c6b994bcbfc90a1a7921485c22fd4) ([merge request](gitlab-org/gitlab!85079))
- [Track related epics blocked added on usage data](gitlab-org/gitlab@37be6bcfe05d1af1443008d8c3abc6ee52f51a21) ([merge request](gitlab-org/gitlab!84503)) **GitLab Enterprise Edition**
- [Optimize followed users queries](gitlab-org/gitlab@a93a42b8aeaed4d3099b49bc18a07b11814fd704) ([merge request](gitlab-org/gitlab!84856))
- [Enable feature flag by default](gitlab-org/gitlab@a901c405c63b255dc6f1a159a6b9b594719f0e7c) ([merge request](gitlab-org/gitlab!85270))
- [Enable policy type selection page by default](gitlab-org/gitlab@a99a9df36c335d727478fc0ddb6543876188bfc5) ([merge request](gitlab-org/gitlab!83600)) **GitLab Enterprise Edition**
- [Add DS_IMAGE_SUFFIX to enable Gemnasium FIPS](gitlab-org/gitlab@aaa62e9d83b68ce23269e9b46d091e6802035faa) ([merge request](gitlab-org/gitlab!85106))
- [feat: Add SAST/SD template support for FIPS images](gitlab-org/gitlab@8b1989350dd0bf096b175244aca2a6c45c5ec16f) ([merge request](gitlab-org/gitlab!84839))
- [Enable FF ci_trigger_forward_variables](gitlab-org/gitlab@850c9c3945cef068c43f103443778d83550d7d60) ([merge request](gitlab-org/gitlab!85263))
- [Add gitlab-pages http server timeout options documentation](gitlab-org/gitlab@3169be7dff244c5e7388e341be8e6936fae4024e) ([merge request](gitlab-org/gitlab!84944))
- [Namespace onboarding action for license scanning](gitlab-org/gitlab@59d45d87d2a4abb372895e8b9209546054b5de1d) ([merge request](gitlab-org/gitlab!77782)) **GitLab Enterprise Edition**
- [Enable feature flag by default](gitlab-org/gitlab@cd0cf705715563d5dc7e9a3b37e63f24200d10e5) ([merge request](gitlab-org/gitlab!82679)) **GitLab Enterprise Edition**
- [Default to the current group when importing from GitHub](gitlab-org/gitlab@5fd18ea76894b946bde60f6da334540b312cc9e9) ([merge request](gitlab-org/gitlab!84323))
- [Add metrics image UI for Alerts](gitlab-org/gitlab@3467ff1b476fbe12aede384bf0c7e03a6917eb29) ([merge request](gitlab-org/gitlab!84129))
- [Extend decomposition prometheus metric with information about CI](gitlab-org/gitlab@4f58363ce4068bfd215dc082bcb4fb27028e0b63) ([merge request](gitlab-org/gitlab!85178))
- [Introduce a onboarding_complete setting for GitLab Pages](gitlab-org/gitlab@5e36289c4aaefff842fdb20c0d0624bbce4e31e4) ([merge request](gitlab-org/gitlab!73551))
- [Nullify dependent associations in batches on user deletion](gitlab-org/gitlab@f934106bec76e5cd4d77b86ad116aeb180f3c516) ([merge request](gitlab-org/gitlab!84709))
- [Add option to add DAST_SUBMIT_FIELD](gitlab-org/gitlab@52a4060f9aa2380190fe3a24f499b04598525bc5) ([merge request](gitlab-org/gitlab!84100)) **GitLab Enterprise Edition**
- [Default group/project issues list page to Vue refactor](gitlab-org/gitlab@99e1bbda26b82cee2c6ca75e26afb8cf1905988b) ([merge request](gitlab-org/gitlab!83299))
- [Move arkose settings into database](gitlab-org/gitlab@b4ca26d77edfc17bbbfe24c50d94a580101c9d03) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/84415))
- [Bump GitLab Pages to 1.57.0](gitlab-org/gitlab@16b6d391684d2ffa3bef5281328fe8b1e6b6f4e9) ([merge request](gitlab-org/gitlab!85179))
- [Update Security Policy to use FIPS images when FIPS Mode is enabled](gitlab-org/gitlab@e16c90f7119b80a699ebb0d3de9efb07d4e0fe84) ([merge request](gitlab-org/gitlab!85150)) **GitLab Enterprise Edition**
- [Add ttl expiration to user otp_secrets](gitlab-org/gitlab@18d316ae80113330b3624bdf954551e3fff0d64a) ([merge request](gitlab-org/gitlab!84985))
- [Implement wiki async page load](gitlab-org/gitlab@93d049bb772389b2e567de799ab1265ac5d87f6a) ([merge request](gitlab-org/gitlab!85076))
- [Allow uploading audio and video in content editor](gitlab-org/gitlab@7da260cea1fcbc6ababdc58bc7b804aca48df43f) ([merge request](gitlab-org/gitlab!84594))
- [Add identifer to response](gitlab-org/gitlab@03ba2c10bca4ef792e8eff6c7c6b03128ba9ccde) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/84990)) **GitLab Enterprise Edition**
- [Implement first iteration of the agents REST API](gitlab-org/gitlab@f7b265a5c68a912a172f1c4b5b4fa66a9bce8384) by @tuxtimo ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/83270))
- [Backfill routes namespace_id for projects](gitlab-org/gitlab@8bda0cf8ccf4df51ba7d56ece263cebda30c60dd) ([merge request](gitlab-org/gitlab!81121))
- [Add periodic re-aggregation worker for VSA](gitlab-org/gitlab@2bb347b735e44b9cb558c55373bc8925deee40ec) ([merge request](gitlab-org/gitlab!84171))
- [Fire a Snowplow events with its definition on FE](gitlab-org/gitlab@24a6b0f5f0d6179f0c33169b15a92e127e5510d8) ([merge request](gitlab-org/gitlab!84122))
- [Added MATLAB template](gitlab-org/gitlab@a42830f85ca42b2377aa959ce9b6381180822970) by @nbhoski ([merge request](gitlab-org/gitlab!82914))
- [Add new route for DAST profile library](gitlab-org/gitlab@eecb515827aa756c2017c0afe4b08bfaca32ae18) ([merge request](gitlab-org/gitlab!84451)) **GitLab Enterprise Edition**
- [Allow SKIP=remote option to be specified during backup](gitlab-org/gitlab@59f9f0704f2ae29cf15a0e951ab1ce50f0dfb249) by @kakakikikeke ([merge request](gitlab-org/gitlab!83816))
- [Add a feature flag to control when we could prevent users to login](gitlab-org/gitlab@191e2093d1facf13f675031ad1b7d3cff3974830) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/84971)) **GitLab Enterprise Edition**
- [Allow bypassing registration when joining project](gitlab-org/gitlab@1d21bef5a2877b39eac8aae67845e8035c05df32) ([merge request](gitlab-org/gitlab!83225)) **GitLab Enterprise Edition**
- [Track blocking epics removed on usage data](gitlab-org/gitlab@798a01887aad4a789aefd0580785255bed773e50) ([merge request](gitlab-org/gitlab!84408)) **GitLab Enterprise Edition**
- [Add application settings to support inactive project deletion feature](gitlab-org/gitlab@60b8b509e7282fd9e9a18dde85174a9770840360) ([merge request](gitlab-org/gitlab!84519))
- [Add epics.relative_position column if missing](gitlab-org/gitlab@a53a6b80320427742768d4dd9faa6e9c027bf20b) ([merge request](gitlab-org/gitlab!84733))
- [Include inherited group links on group members page](gitlab-org/gitlab@4ae7ac3be1d64b0696d2ec3d92dd3e66433164d2) by @wwwjon ([merge request](gitlab-org/gitlab!71465))
- [Implement wiki page async load](gitlab-org/gitlab@93bc27aabf0bc51d2a2ac9276e6991b9a8398bc8) ([merge request](gitlab-org/gitlab!84690))
- [Add omniauth provider AliCloud](gitlab-org/gitlab@d8265f091083bd662fec5b4a65a46c28538f90a9) by @zhanglinjie ([merge request](gitlab-org/gitlab!83925))
- [Different copy on trial/registration flow](gitlab-org/gitlab@afab628557293e38049ef1a0b605380c7e15444f) ([merge request](gitlab-org/gitlab!83778)) **GitLab Enterprise Edition**
- [Add support for the deduplicated container repositories size](gitlab-org/gitlab@faa6448d6f80ae35c528776c31bfcb8c90a0df99) ([merge request](gitlab-org/gitlab!83980))
- [Fire a Snowplow events with its definition on BE](gitlab-org/gitlab@ac138099dd94f69865d55ff49df136fbd7b0a5f6) ([merge request](gitlab-org/gitlab!83480)) **GitLab Enterprise Edition**
- [Adding FIPS support to DAST API/API Fuzzing latest CI template](gitlab-org/gitlab@e726b3879e5826346af0be6155ea7b1085905dc0) ([merge request](gitlab-org/gitlab!84312)) **GitLab Enterprise Edition**
- [Repeat the captcha check during the login](gitlab-org/gitlab@f85640d7477f6a016219cb444c3acf6d2d03c942) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/83633)) **GitLab Enterprise Edition**
- [Allow Invitations API to receive user_ids](gitlab-org/gitlab@bd4c83b8771e0e9270368596360dbfe890da4040) ([merge request](gitlab-org/gitlab!81019))
- [Add groups release API](gitlab-org/gitlab@1bc89dbd6f6d641aff196850a46689e5701633e8) ([merge request](gitlab-org/gitlab!77783))
- [Adds container_registry_size to project_statistics](gitlab-org/gitlab@56c0aa26a1a43fed6da104bd0d82b3859973800a) ([merge request](gitlab-org/gitlab!84271))
- [Add not null and delete cascade constraints on project_namespace_id](gitlab-org/gitlab@54e3627c2ffbf6c5c1d01262445a147f38367f27) ([merge request](gitlab-org/gitlab!82309))
- [Enable incremental repository backups](gitlab-org/gitlab@757e9e8dd0acb925b925d5f358f4fc28d5ba641a) ([merge request](gitlab-org/gitlab!84536))
- [Add minute limit banner](gitlab-org/gitlab@41c10cd2e541da29f2ff1e658c0e96db7108eb90) ([merge request](gitlab-org/gitlab!84644))
- [Create unique index on projects namespace_id and name](gitlab-org/gitlab@16502ac598fabfa32e1314c6e1cc5ba640d9c2ce) ([merge request](gitlab-org/gitlab!83884))
- [Add resolve thread to permission table](gitlab-org/gitlab@523cf5005d32650792c8ddd952e8baf5ec0b1c36) ([merge request](gitlab-org/gitlab!84598))
- [Add audit events for merge request settings](gitlab-org/gitlab@1bfe37d3038135b8790699109438b94b2f0674ef) ([merge request](gitlab-org/gitlab!83922)) **GitLab Enterprise Edition**
- [Support security report schema version 14.1.1](gitlab-org/gitlab@31bc204c1e6184b5d8205cac4f0014129c7b3bef) ([merge request](gitlab-org/gitlab!83430))
- [Add ability to query awaiting billable members](gitlab-org/gitlab@24beb9fe990d9d9f89609151edc9361e0a3d7ab7) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/84074))
- [Add arkose verify response details to custom attributes](gitlab-org/gitlab@5afeadbb70cff19fb7717dc57af02511aaf7e584) ([merge request](gitlab-org/gitlab!84394)) **GitLab Enterprise Edition**
- [Implement detailed github status reporting](gitlab-org/gitlab@f693a63b35acb6d9d82bfde4de411b117b71aeab) ([merge request](gitlab-org/gitlab!83493))
- [Allow invitation service to receive user_ids](gitlab-org/gitlab@07422cb28dd3626078d04c93f805dfa893b19790) ([merge request](gitlab-org/gitlab!83534))
- [Create status index for batched migrations](gitlab-org/gitlab@9653cb5a38a5a6b7ba0eb7b1b0b4337ecc1e3b22) ([merge request](gitlab-org/gitlab!84470))
- [Allow to put migrations on hold for some time](gitlab-org/gitlab@5a7ec0fac6d10e537ddcb539e11966f31ffd09e1) ([merge request](gitlab-org/gitlab!84166))
- [Add dast_submit_field to DAST site profile](gitlab-org/gitlab@ae5c2556eac99dde7a48090d608f6613bc03dd14) ([merge request](gitlab-org/gitlab!84245))
- [Add missing authorization](gitlab-org/gitlab@b0adb655354a5d029b2dc65255901563d0c2cd2e) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/84425)) **GitLab Enterprise Edition**
- [Add Commit Author to Pipeline List Page](gitlab-org/gitlab@60c83f3ec42ceb34e2bff8944296cfbdcf6b8f67) by @Taucher2003 ([merge request](gitlab-org/gitlab!84226))
- [Track blocking epics added on usage ping](gitlab-org/gitlab@275aa1c697b7e113c25264d163a58fd43bcae8de) ([merge request](gitlab-org/gitlab!84400)) **GitLab Enterprise Edition**
- [Add clear cache button to dependency proxy](gitlab-org/gitlab@1ada2ced100a131591aff01eaa5190a9f98ca55b) ([merge request](gitlab-org/gitlab!83786))
- [Track linked epics removed on usage ping](gitlab-org/gitlab@8cb3edc32db88926160c77b456798cece3052d65) ([merge request](gitlab-org/gitlab!83547)) **GitLab Enterprise Edition**
- [Added deprecation notice to cluster creation pages](gitlab-org/gitlab@f16ffd74c5a6be2261cccbf6e511c750e6b80ca7) ([merge request](gitlab-org/gitlab!83886))
- [Created new feature flags for free and paid users](gitlab-org/gitlab@5393d8c3a0f2a41d4febcdd1abdd405739bb7db8) ([merge request](gitlab-org/gitlab!82704)) **GitLab Enterprise Edition**
- [Add new CI/CD template for Liquibase](gitlab-org/gitlab@9008f546da240a428b62170c54d8e25e100f5a19) by @szandany ([merge request](gitlab-org/gitlab!81817))
- [Added a clipboard button to the "Branches" page in "Repository"](gitlab-org/gitlab@fe1d7438951f5cfb4509cadde6d065022794c474) by @DavidRotert ([merge request](gitlab-org/gitlab!80017))
- [Add changed_by field to API members entities](gitlab-org/gitlab@c0e336bc0b0ccb4bb9376d9d9928b7bc1f854269) by @remyj38 ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/66518))
- [Support executable flag in repository files API](gitlab-org/gitlab@909aee045e573eaf62c4766f7d301029adc7faa1) by @tuxtimo ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/83499))
- [Adds kind field to JobType](gitlab-org/gitlab@5232517ccb8d14b5dd4a1c29de885231f802c0e0) ([merge request](gitlab-org/gitlab!83627))
- [Merge branch 'ahmetkaramercan17-master-patch-18116' into 'master'](gitlab-org/gitlab@25be580b697e5697df4288e5b5064bc1a3e3a480) ([merge request](!80925))
- [awardEmoji: Display custom emoji](gitlab-org/gitlab@8f8eb1a844fa0668cd7a9a060bb44e198ecec3ff) ([merge request](gitlab-org/gitlab!77478))
- [Enable Value Stream Analytics consistency check](gitlab-org/gitlab@20198e10c37e417b71c1c0f815fbe087d40cb774) ([merge request](gitlab-org/gitlab!84153)) **GitLab Enterprise Edition**
- [Create index on `security_findings`(`scan_id`, `id`)](gitlab-org/gitlab@30f8a95b03f625122b1e9f50901211da08cc490d) ([merge request](gitlab-org/gitlab!84185))
- [Display the tier of the environment on page](gitlab-org/gitlab@39765b0bb48576d83022cfe87450b0a49ba59fd3) ([merge request](gitlab-org/gitlab!83429))
- [Use the remote ip for the captcha check](gitlab-org/gitlab@cab8b8829fe6d3e566a77f03eb5444d2bd7f1cb3) ([merge request](gitlab-org/gitlab!83985)) **GitLab Enterprise Edition**
- [Add page size selector to vulnerability report](gitlab-org/gitlab@93d74803cf2abc3a86d471e8f317f6030c645af4) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/83604)) **GitLab Enterprise Edition**
- [Add a temporary specialized index on project_namespace_id](gitlab-org/gitlab@eb4d21d3e5c0d4008259d97dbcdf7cea55bfc333) ([merge request](gitlab-org/gitlab!84072))
- [Support template button focus state](gitlab-org/gitlab@fab61c5c0b851e93b79d223b0984ece5b8c843c4) by @ahmetkaramercan17 ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/80925))
- [Remove pipeline_schedules_with_tags feature flag](gitlab-org/gitlab@ef49afae034b5a00e039b6d4cd15972dae3611b3) by @KevSlashNull ([merge request](gitlab-org/gitlab!83465))
- [Introduce new Group Feature model and database structure](gitlab-org/gitlab@8964f64d41daf4f7fd17ee5b06b80e762c78f0b6) ([merge request](gitlab-org/gitlab!82017))
- [Search the user by username or email](gitlab-org/gitlab@e993ebc2cff19a09d993e5b0a48947d7e9cd2dd0) ([merge request](gitlab-org/gitlab!83871)) **GitLab Enterprise Edition**
- [Add collapsed comparer for license_scanning](gitlab-org/gitlab@44f732013487cacc9e3ef6d921ae0b6539bce100) ([merge request](gitlab-org/gitlab!82526)) **GitLab Enterprise Edition**
- [Add harbor registry list page](gitlab-org/gitlab@94a33f80e33704d11679b99b670a86071ddeb82d) by @orozot ([merge request](gitlab-org/gitlab!81008))
- [Add commit diff stats](gitlab-org/gitlab@a7a5a656b4d3a50b74e6a329155789f94204983a) ([merge request](gitlab-org/gitlab!83749))
- [Fix project name duplicates and missing project namespace ids](gitlab-org/gitlab@a12776af66e8c39ad92d5d6bd9b2355ec6e052a2) ([merge request](gitlab-org/gitlab!83587))
- [Add user limit notification for invite members modal](gitlab-org/gitlab@801c1f172b6e5e669bd31a565d79ff7eba2d27e0) ([merge request](gitlab-org/gitlab!82909))
- [Add Runner releases API URL to ApplicationSetting](gitlab-org/gitlab@c9a8ff5a2bb21846c1336286f21f59e3de79e18c) ([merge request](gitlab-org/gitlab!83549))
- [Add link to create group in general project settings](gitlab-org/gitlab@a6a91fc58f03995982ebd6e35dd05b250db24ce2) ([merge request](gitlab-org/gitlab!83748))
- [Implement sort param for bulk imports API](gitlab-org/gitlab@e3d21409c01d894b999d937abff6dd0a073f196f) ([merge request](gitlab-org/gitlab!83458))
- [Add notification_level to namespace_root_storage_statistics table](gitlab-org/gitlab@ff6267cb883ccd1fb702f5b6c64744c9922a346d) ([merge request](gitlab-org/gitlab!83338))
- [Detect projects built for Apple iOS platform](gitlab-org/gitlab@b26d73a4de29046bc47c449c919f89e1c2e8a99c) ([merge request](gitlab-org/gitlab!80361))
- [feat: Add CI_GITLAB_FIPS_MODE to predefined CI variables](gitlab-org/gitlab@1a7a70174e26079843fc089c114970c3bcad8e2a) ([merge request](gitlab-org/gitlab!83891))
- [Add a test group cleanup worker to remove test groups on production](gitlab-org/gitlab@bcc945d2abaf7db1adf6c0e25b28a82c8d04e75c) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/83585))
- [Allow administrators to set active pipelines limits](gitlab-org/gitlab@4d4e0a242608ac561b1e5cd7c52f7ef99fd633f0) ([merge request](gitlab-org/gitlab!83855))
- [New Group Runners administration view](gitlab-org/gitlab@5a0439343f69475e2acab7ff18395875014ede7d) ([merge request](gitlab-org/gitlab!82622))
- [Allow restore tasks to be skipped using SKIP](gitlab-org/gitlab@480f737e603ea447ae0e645a4887a3978546ad7f) ([merge request](gitlab-org/gitlab!83783))
- [Track api usage of the gitlab cli](gitlab-org/gitlab@63639224ce880c2ac8d5a8b0301f474665c6fd16) ([merge request](gitlab-org/gitlab!83464))
- [Add support for the nested repositories container registry access token](gitlab-org/gitlab@cc8268ee817029e943960d9de353adbdbabd4a78) ([merge request](gitlab-org/gitlab!83756))
- [Handle auth error for container registry](gitlab-org/gitlab@06ba9523d947fea4155c81194173190ded6a7163) ([merge request](gitlab-org/gitlab!83278)) **GitLab Enterprise Edition**
- [Introduce API for Change Failure Rate DORA metric](gitlab-org/gitlab@c8305d27083acd49417c9036aa49ab2852a1c5ae) ([merge request](gitlab-org/gitlab!83514))
- [Added a create cluster page for the FF](gitlab-org/gitlab@8463632ffe55ea6bc8051886da938a1a0841a667) ([merge request](gitlab-org/gitlab!83041))
- [Ensure project backfilling has finished](gitlab-org/gitlab@20998ccb968611bb50f307d3fae0c83164b0017c) ([merge request](gitlab-org/gitlab!82176))
- [Add endpoint to decide if the ArkoseLabs integration should be triggered](gitlab-org/gitlab@30b0f796ba8ee0f03d1df9050e12713e28acbb30) ([merge request](gitlab-org/gitlab!82751))
- [Add delete endpoint for related epics](gitlab-org/gitlab@9584af7c8550cfda5c877ab45059a597e2c972eb) ([merge request](gitlab-org/gitlab!83307)) **GitLab Enterprise Edition**
- [FIPS SSH key configuration settings](gitlab-org/gitlab@ee76f7187b9d12876b87200e044cfe486032500f) ([merge request](gitlab-org/gitlab!81917))
- [Add creator_id to deploy_tokens](gitlab-org/gitlab@40c4143a79db86c0fe0e59575ac94cd397d7b817) ([merge request](gitlab-org/gitlab!83023))
- [Mark Import trackers as timed out with entities](gitlab-org/gitlab@5e23c718d4a32fe4db35638d8698a2e9aafcf358) ([merge request](gitlab-org/gitlab!83530))
- [Add ArkoseLabs verify request service](gitlab-org/gitlab@607b5569bd56084e1dd034a248adb7a50195b3fa) ([merge request](gitlab-org/gitlab!83099))
- [Add DB Grafana config as application settings](gitlab-org/gitlab@cc12dc696f3f4ff41e77eaf9b4c9cb83f402b139) ([merge request](gitlab-org/gitlab!82348))
- [When no iterations are present show empty state](gitlab-org/gitlab@52aeccae45270a2a75dd462b986610996d8ed194) by @sstern ([merge request](gitlab-org/gitlab!79067)) **GitLab Enterprise Edition**
- [Add timeout status to bulk importer](gitlab-org/gitlab@0c14911b0427a036faa471e91bca76ea3cdc5b15) ([merge request](gitlab-org/gitlab!83313))
- [Remove improved_emoji_picker feature flag](gitlab-org/gitlab@ba2094afa6f7021f0cdbdfbf518ed472e8c05391) ([merge request](gitlab-org/gitlab!82117))
- [Expose github stats in realtime_changes private API](gitlab-org/gitlab@0fb3f04c59e1e7912623f9afeb843def13cca4c0) ([merge request](gitlab-org/gitlab!83497))
- [Trigger an email when seat overage occurs](gitlab-org/gitlab@5b32ac5ce1cb62e3e32f6c4fcd3df939618f1056) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/79807)) **GitLab Enterprise Edition**
- [Implement GET API for GATs and PATs](gitlab-org/gitlab@5be27d6677ec0d1a63a415da56d09eba8b682145) by @tuxtimo ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/82714))
- [Implement history for project imports](gitlab-org/gitlab@c07eba6c606e3edf014f2fa17ef4a26666b60855) ([merge request](gitlab-org/gitlab!83207))
- [Expose import url and status in projects API](gitlab-org/gitlab@df58da3390cfb6d803f5ced4843ac63b2f93f3d2) ([merge request](gitlab-org/gitlab!82498))
- [Render plantuml/kroki diagrams in content editor](gitlab-org/gitlab@e45c5f1d71d2c45f037fcbe4149736a436a824d7) ([merge request](gitlab-org/gitlab!77875))
- [Add "Created on" & "Last activity" columns to groups and projects page](gitlab-org/gitlab@484fe31b91102f6d89d5e914bb9727672b9a4426) ([merge request](gitlab-org/gitlab!82918))
- [Implement API to get single Project Remote Mirror](gitlab-org/gitlab@fe5a94c2496292a876e74e9b5ec561de1c532e23) by @tuxtimo ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/82770))
- [Extend workers and services to support namespace for Security Policies](gitlab-org/gitlab@10feb38e5297372bcf863973de315a768bbf8a28) ([merge request](gitlab-org/gitlab!82695)) **GitLab Enterprise Edition**
- [Graceful degradation for refs endpoint](gitlab-org/gitlab@ebe9cdfcee8e9777b70f6fadd76774aa86cfe23c) ([merge request](gitlab-org/gitlab!83088))
- [Add create endpoint for related epics](gitlab-org/gitlab@1ee01f0fb4c56dc3758957987f3ad19705fc2ea8) ([merge request](gitlab-org/gitlab!82985)) **GitLab Enterprise Edition**
- [Expose `namespace_id` in users GET API for admins](gitlab-org/gitlab@408abb792b534918e39691632d2d0897b3734701) by @tuxtimo ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/82045))
- [Add Project template for Middleman](gitlab-org/gitlab@1eeda79e95a4a60e891818dfb089af9360fb495b) ([merge request](gitlab-org/gitlab!82231))
- [Implement DELETE API for Remote Mirrors](gitlab-org/gitlab@19d1fc2c90e24e870635e04dea80cdc89bb5f734) by @tuxtimo ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/82778))
- [Add target_id option to TodosMarkAllDone mutation](gitlab-org/gitlab@c8dccf44e3dbf3b3838a9397b05bb5deb71482c7) ([merge request](gitlab-org/gitlab!83110))
- [Add ability to enable SAST at project creation](gitlab-org/gitlab@d29a2e9b333eefbeb20b08bcf2a9609d5d455f74) ([merge request](gitlab-org/gitlab!83138))
- [Implement API to get single MR rule](gitlab-org/gitlab@aea85351b7e630638d3399e3ff5eafc4edd75557) by @tuxtimo ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/82767)) **GitLab Enterprise Edition**
- [Add `Migration[2.0]` that enforces `restrict_gitlab_migration`](gitlab-org/gitlab@efeaa328def22e7741fec7bc8f97693195c1af6a) ([merge request](gitlab-org/gitlab!82505))
- [Allow administrators to change plan limits via the UI](gitlab-org/gitlab@8ed789d536ec8931a49eb65464a5852d022ddb99) ([merge request](gitlab-org/gitlab!82521))
- [Enable service ping for error tracking features](gitlab-org/gitlab@6c9e060af4a56135b695b9dd6e81478c2c510d05) ([merge request](gitlab-org/gitlab!83148))
- [Show expired security report information on "pipeline security tab"](gitlab-org/gitlab@3ebe6780af2e878339e13234c057affd9490f994) ([merge request](gitlab-org/gitlab!82508)) **GitLab Enterprise Edition**
- [Send a notification email when a new email address is added](gitlab-org/gitlab@bef7c5cefe6752fc1244c877c889b1365725bd93) by @rpadovani ([merge request](gitlab-org/gitlab!81211))
- [Include code_coverage in presented build for runner](gitlab-org/gitlab@56943486e62e8889358e3acb1e48a2786cdbb788) ([merge request](gitlab-org/gitlab!82672))

### Fixed (147 changes)

- [Remove geo database from db_config_names](gitlab-org/gitlab@a6034cf0bb1ef53932ef96adfc9005574f8d2735) ([merge request](gitlab-org/gitlab!84991))
- [Fixed spacing for the loading icon in time tracker](gitlab-org/gitlab@06b1c35ca736c7748c9b05d0c8eb96b0470fb0de) ([merge request](gitlab-org/gitlab!85335))
- [Increase the visibility of the keyboard shortcut for Global Search](gitlab-org/gitlab@e0e75e0fafadbc315c7f81b8777f2bf52fdf6b55) ([merge request](gitlab-org/gitlab!84085))
- [Update stage name to use truncate](gitlab-org/gitlab@1359711eb28604a1d30ef0080775160a012009b1) ([merge request](gitlab-org/gitlab!85139))
- [banzai: Get Custom Emoji from group as well](gitlab-org/gitlab@de6999b7ed58f1f6e46cc794d7b7fa0a573235ae) ([merge request](gitlab-org/gitlab!84304))
- [Add scope to CustomEmoji to find emoji for resource](gitlab-org/gitlab@cba2c20303e0a1d450a48f78ae692afedabc19c9) ([merge request](gitlab-org/gitlab!84304))
- [AwardEmoji: Don't look up url for built-in emoji](gitlab-org/gitlab@853408a19788bdc1d221802448d5d57b57d8f0c9) ([merge request](gitlab-org/gitlab!84304))
- [Fix rendering failure for the 'Verified' badge](gitlab-org/gitlab@c5f16c4a23837839418f198b032f5fc4344fee5a) ([merge request](gitlab-org/gitlab!84862))
- [Update links to CI/CD docs](gitlab-org/gitlab@745a3a5f100e92c8906945efdd26aa17f95392a5) ([merge request](gitlab-org/gitlab!85308))
- [Add default scan execution policies stage to pipeline](gitlab-org/gitlab@74ab5b3c7473e17992e8d08952182e58fea4d011) ([merge request](gitlab-org/gitlab!84640)) **GitLab Enterprise Edition**
- [Move VSA aggregation migration to migrate folder](gitlab-org/gitlab@3db7d3eb42a14251d4faee0258e375baa8720a3f) ([merge request](gitlab-org/gitlab!85164))
- [Enable fix_related_environments_for_merge_requests FF by default](gitlab-org/gitlab@2e84650a1ba21c4af3c993ba4832da0fc5918599) ([merge request](gitlab-org/gitlab!85251))
- [Fix the conditions when we scope to gitlab-org](gitlab-org/gitlab@88c1d835ce10fab1cdf84322a13c96929301644a) ([merge request](gitlab-org/gitlab!85189)) **GitLab Enterprise Edition**
- [Use lowercase values in user search ordering](gitlab-org/gitlab@e59a09227c692bd8b89d3b7208cf97db4a4eb37e) ([merge request](gitlab-org/gitlab!81828))
- [Always select an environment's  last deployment by deploy date](gitlab-org/gitlab@df8cc48b825d766e429a257f905652dea73fbb94) ([merge request](gitlab-org/gitlab!85202))
- [Fix infinite activities requests on profile](gitlab-org/gitlab@b0ee9a508bf12e9ed9abee00427fae6246aa9aa0) ([merge request](gitlab-org/gitlab!84999))
- [Adds timeout to notebook rendering](gitlab-org/gitlab@a2469d3d75b6f2b788293eae333e9aa17a07b6e0) ([merge request](gitlab-org/gitlab!85069))
- [Fix query params parsing when NOT operator is used](gitlab-org/gitlab@5fc73f19481544202aa71e3696ef019deae501ce) ([merge request](gitlab-org/gitlab!84569)) **GitLab Enterprise Edition**
- [Fix regression with logic to add user primary email to emails](gitlab-org/gitlab@21210646866a682134d2720ea7dbcecb0fcd2fe4) ([merge request](gitlab-org/gitlab!85169))
- [Updated the terraform empty state](gitlab-org/gitlab@77671465de3ea5bbfdaf2e63c8f9f481ca624d4f) ([merge request](gitlab-org/gitlab!84411))
- [Allow empty future subscriptions on seat link sync](gitlab-org/gitlab@2ec0d5e3b1b0684c9fcd67f22e95e5ebdf0d01d4) ([merge request](gitlab-org/gitlab!84533)) **GitLab Enterprise Edition**
- [Fix import button width on Issue list page](gitlab-org/gitlab@7bfea1b97a96532192bf8e555852d88740624bf4) ([merge request](gitlab-org/gitlab!84677))
- [Fixes infinite loop when rendering Ipynb Diffs](gitlab-org/gitlab@a8fdf5f9cd9c87ac9c3975312215625b40b449af) ([merge request](gitlab-org/gitlab!85142))
- [Merged MR notification: Fix sprintf evaluation](gitlab-org/gitlab@57f9078aea8adcc11dab6241094f9b9817b50f80) by @inakimalerba ([merge request](gitlab-org/gitlab!84920))
- [Guard against Deployment#deployed_by being nil](gitlab-org/gitlab@49c776f8b745e25a5a4189b1e540529845fb9b90) ([merge request](gitlab-org/gitlab!85032))
- [Search Autocomplete: Review how icons are generated](gitlab-org/gitlab@85a3bea582c7c3b40a669b0c697d6d1a6f2f0daf) ([merge request](gitlab-org/gitlab!82724))
- [Switch from respond_with_navigational to redirect_to](gitlab-org/gitlab@9af9f3c3941f59a1ec8d3eb2bf696a2048024e93) ([merge request](gitlab-org/gitlab!85127))
- [Adds timeout for notebook rendering on CustomDiff](gitlab-org/gitlab@ce1bf1ff315b00bdbf4a4bc4b9d273dcbb85a710) ([merge request](gitlab-org/gitlab!85124))
- [Change `Create commit` button variant to confirm](gitlab-org/gitlab@de420f3b42853e6ed093b4fb84d652193c6da011) ([merge request](gitlab-org/gitlab!84728))
- [Remove ci_destroy_all_expired_service feature flag](gitlab-org/gitlab@c9cde7d59373ab102f650d8624984fcda3c5a229) ([merge request](gitlab-org/gitlab!84512))
- [Fix tooltip and truncation on incident list](gitlab-org/gitlab@43e8d7dcec2e2cb3dde133de30c812e062e6e3a1) ([merge request](gitlab-org/gitlab!83027))
- [Fix "sticky" user popovers](gitlab-org/gitlab@9d772ad54c503f32d8da9ffdfe4dc92d7c45f248) ([merge request](gitlab-org/gitlab!85120))
- [Include *.jira.com in Jira Connect CSP frame ancestors](gitlab-org/gitlab@6df3824611d5f4aad8612a6f905a937d49c65be5) ([merge request](gitlab-org/gitlab!84967))
- [Fix doc link to code suggestions in MR diff tab](gitlab-org/gitlab@88e2f2ba3dad1e4db6db725900c21d496e0cbc64) ([merge request](gitlab-org/gitlab!84958))
- [Fix impersonation created_at audit event field](gitlab-org/gitlab@6038dc0dab5abd16cae992438d5126b73ca8a5b6) ([merge request](gitlab-org/gitlab!85082)) **GitLab Enterprise Edition**
- [Add validation for invalid protected branches for](gitlab-org/gitlab@d79660fe354b789a53c2aebf783d3017ed03c99d) ([merge request](gitlab-org/gitlab!84107)) **GitLab Enterprise Edition**
- [Keep edited timestamp when reacting to old notes](gitlab-org/gitlab@96aaeb37ad0ed939b62dca30880e9d3c24a8b8d2) ([merge request](gitlab-org/gitlab!84568))
- [Remove early exit to allow marking as complete](gitlab-org/gitlab@75b3bc2615edc94bbf24fe4c81db896e6b5fe4eb) ([merge request](gitlab-org/gitlab!84531))
- [Fix scroll to line number](gitlab-org/gitlab@3df36a8f034284e05290640d3619cf8adb07cbeb) ([merge request](gitlab-org/gitlab!84562))
- [Change pipeline status to canceled](gitlab-org/gitlab@4747bd591875ae4578d0010d5c5db814cc4f6915) ([merge request](gitlab-org/gitlab!84774))
- [Fix Value Stream Analytics doc links](gitlab-org/gitlab@b8ac8d750684d9146cba2aa9eeb55301edaa5a5b) ([merge request](gitlab-org/gitlab!84492)) **GitLab Enterprise Edition**
- [Change button variant to confirm](gitlab-org/gitlab@1dace867f615ecf6497faac1217765b0e4169593) ([merge request](gitlab-org/gitlab!84736)) **GitLab Enterprise Edition**
- [Add ability to pre/post-date audit events](gitlab-org/gitlab@ff275b33da360cea8fe7fe0a950465df1843df0d) ([merge request](gitlab-org/gitlab!84061))
- [Fix undefined method error for Compare, Commit controllers](gitlab-org/gitlab@de205022da57410dfbd2f52e17f14786b31f20ce) ([merge request](gitlab-org/gitlab!84176))
- [Do not try to update a deleted record](gitlab-org/gitlab@6e29a3cb081352c2ae7f36857dbec8f204a97827) ([merge request](gitlab-org/gitlab!84700))
- [Hide New Epic button on boards for guest users](gitlab-org/gitlab@589d436f81aa7f7485de1c2d36507c1fe39efc34) ([merge request](gitlab-org/gitlab!84583)) **GitLab Enterprise Edition**
- [Fix Licensee::InvalidLicense exception](gitlab-org/gitlab@d117b6967a1555d3e326c8947c63137819103067) ([merge request](gitlab-org/gitlab!84344))
- [Revert mergeability check changes](gitlab-org/gitlab@97a131bfcc9a631b7d13582021366383f9f4a491) ([merge request](gitlab-org/gitlab!84669))
- [Add the ability to parse CWE-{number} format](gitlab-org/gitlab@7059b473916679a5893cde409d8fbef2bd807822) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/84313)) **GitLab Enterprise Edition**
- [Fix required data for referenced commands](gitlab-org/gitlab@fde871b8ca23affaf7bfe05c19434f0ed6585fc4) ([merge request](gitlab-org/gitlab!84053))
- [Fix missing clear cache text inside the dependency proxy dropdown](gitlab-org/gitlab@0f88dc246854dd8894d22408aef23c96417f1d3a) ([merge request](gitlab-org/gitlab!84620))
- [Add search keyboard shortcut to docs](gitlab-org/gitlab@9dbf6ec6d4a56ba14da410a4a0137a9332d2477f) ([merge request](gitlab-org/gitlab!84601))
- [Fix for code search bug in Safari when zoomed](gitlab-org/gitlab@b4beec4b61b1ddd7505372cad810037537b812a9) ([merge request](gitlab-org/gitlab!84363))
- [Fix the rubygems extraction service to not create subtransactions](gitlab-org/gitlab@fea6c6b753dd65bc3936a6c92c1448d79cf50d9b) ([merge request](gitlab-org/gitlab!84590))
- [Fix package file cleanup worker with PyPI files](gitlab-org/gitlab@075e8e710403e3fcbdf8bbfed65b3e0e1f17b476) ([merge request](gitlab-org/gitlab!84073))
- [Fix stale object error in Environment Stop](gitlab-org/gitlab@5f00b2e965cec9c9a310f29286b8881884684435) ([merge request](gitlab-org/gitlab!84291))
- [Remove Milestone token wildcard values](gitlab-org/gitlab@41fda0882df548bacd4e469c7ab15cad19904fc0) ([merge request](gitlab-org/gitlab!84561)) **GitLab Enterprise Edition**
- [Fix incorrect empty state for filtered tag list](gitlab-org/gitlab@e84d86a6ff9fa3f538db5eb870eee7e88cc7b4b5) ([merge request](gitlab-org/gitlab!84556))
- [Reconfigure DB load balancing connection on code reload](gitlab-org/gitlab@b617e90415c5efaf1cf7764c6df745f938f58c4c) ([merge request](gitlab-org/gitlab!84528))
- [Fix URL blocker when object storage enabled but type is disabled](gitlab-org/gitlab@7560d2dcf6ad03288bd1ef9b6a4f9270daf523e1) ([merge request](gitlab-org/gitlab!84511))
- [Count nil artifact size as zero when recalculating](gitlab-org/gitlab@ce604106947bbf213cbff59cd932be1f8266d45c) ([merge request](gitlab-org/gitlab!84509))
- [Remove FF ci_fix_order_of_subsequent_jobs](gitlab-org/gitlab@a3c2e9e399ced038b8e4c5844a9b54c637f68ab9) ([merge request](gitlab-org/gitlab!84506))
- [Remove pending builds from the queue on conflict](gitlab-org/gitlab@68a9e9a70e0c2a0c98f32b071ff76fb9e526e58e) ([merge request](gitlab-org/gitlab!84359))
- [Add polling for commit pipeline status](gitlab-org/gitlab@be0aac05a8ca67ecc8a53be5ccdd001be2771c51) ([merge request](gitlab-org/gitlab!84201))
- [Include X-Forwarded-Host when proxying and rewriting Host in Workhorse](gitlab-org/gitlab@8506644aab08c6d51c62321a0a4d144022b2e074) ([merge request](gitlab-org/gitlab!84368))
- [Fixed UX bug in agent creation modal](gitlab-org/gitlab@407fbace1f0e44ada3fc4509bcb607ab2a7c6c1e) ([merge request](gitlab-org/gitlab!84225))
- [Do not use GOPATH in default CI template](gitlab-org/gitlab@ad6a72e656e455b07ae2863ed338c28e1f495a70) ([merge request](gitlab-org/gitlab!84365))
- [Move checks from mergeable to mergeable_state?](gitlab-org/gitlab@736d44ce7de313a012c465e1ba6196922929adf1) ([merge request](gitlab-org/gitlab!82465))
- [Use article tag on embedded snippets](gitlab-org/gitlab@92ca547da8f5fe7b98db45de8029c10923d6ab8c) by @joshbouganim ([merge request](gitlab-org/gitlab!83639))
- [Fix iteration dates adding timezone offset](gitlab-org/gitlab@a8e8f502a6c6b39190d2e5926d4778ef32d5df5b) ([merge request](gitlab-org/gitlab!84432)) **GitLab Enterprise Edition**
- [Add polling to commit box graph](gitlab-org/gitlab@04c2c5a67562c104249da6a3cce6db3d31765160) ([merge request](gitlab-org/gitlab!83890))
- [Add customers-dot URL to CSP not only in dev](gitlab-org/gitlab@6d485027406ddafa624e110e71b19b13daad7c65) ([merge request](gitlab-org/gitlab!84396))
- [Preserve sibling elements in settings search](gitlab-org/gitlab@6900d26c45efcce0b7aa34cad3ad3aa6cae9244e) ([merge request](gitlab-org/gitlab!84385))
- [Show quick actions link when editing comments](gitlab-org/gitlab@3c4b932837bce90621150898b0f7dbc40cd36b4e) ([merge request](gitlab-org/gitlab!83687))
- [Test scanner creation](gitlab-org/gitlab@ae38614cade953e107f3c849d9c460d2ec8f5b36) ([merge request](gitlab-org/gitlab!84160)) **GitLab Enterprise Edition**
- [Fix null argument handling in background migration Rake task](gitlab-org/gitlab@b6f60ccc7f17032942af3c97179d6c12fe328747) ([merge request](gitlab-org/gitlab!84318))
- [Quote project key in Jira JQL queries](gitlab-org/gitlab@113823330c05825918e92196e267c4f3d204c87a) ([merge request](gitlab-org/gitlab!84349)) **GitLab Enterprise Edition**
- [Handle commit being nil](gitlab-org/gitlab@ff3c1a70c0667efc6ce283606b92df1471f569c3) ([merge request](gitlab-org/gitlab!84321))
- [Check task with no-break space](gitlab-org/gitlab@d18df2cd915765dd1320e9009bf698335d8c7728) by @tchandelle ([merge request](gitlab-org/gitlab!80674))
- [Avoid milestone icon shrinking](gitlab-org/gitlab@2785ed192f7959a774b4ff786017778dbe6871ae) ([merge request](gitlab-org/gitlab!84247))
- [Update BulkImports::EntityWorker deduplication strategy](gitlab-org/gitlab@f75d57894ba0b0674fef1a65e24df17139ce498c) ([merge request](gitlab-org/gitlab!84204))
- [Handle nil values in Grape length limit validator](gitlab-org/gitlab@9d26c3f3b104f6eca7437640537327eec80488d4) ([merge request](gitlab-org/gitlab!84240))
- [Add SAML default membership asynchronously](gitlab-org/gitlab@9f8777d1592adcd26cee0959cdcfca631a1a773d) ([merge request](gitlab-org/gitlab!83619))
- [Set account string when 2fa creation fails](gitlab-org/gitlab@fb94b29eaa35a16f3e203be7256c12661c093c87) ([merge request](gitlab-org/gitlab!84082))
- [Fix scope of project export download throttling](gitlab-org/gitlab@ec7b9c18c47cb9d3980843eb46410aba888ff46b) by @eggerd ([merge request](gitlab-org/gitlab!82925))
- [Preload group root ancestor for Group Projects API](gitlab-org/gitlab@ddd7690eda8a363c2788018e5ada5792f5513954) ([merge request](gitlab-org/gitlab!81838))
- [Update secret detection template to remove fetch on historic scan](gitlab-org/gitlab@9f7a605adf38a6e4f7fb71b20dde4d3e5f57a8ce) ([merge request](gitlab-org/gitlab!84179))
- [Fix bug when decrementing open MR count](gitlab-org/gitlab@34489c5a7f65856c59be9db33d93ae37e4e3fd71) ([merge request](gitlab-org/gitlab!83516))
- [Do not schedule project import when migrating using GitLab Migration](gitlab-org/gitlab@2de2fa05fc79a0f6f5faac93339c8aecf5809798) ([merge request](gitlab-org/gitlab!84055))
- [Mark token encryption job as completed when there are no users](gitlab-org/gitlab@f72f97e172cf7244f6d3fd37f603ae77615f8568) ([merge request](gitlab-org/gitlab!83850))
- [Allow ConnectionNotEstablished for DB rake tasks using validate_config](gitlab-org/gitlab@f1ab65469504c88e5793293f0095d79fd4c0dc23) ([merge request](gitlab-org/gitlab!84167))
- [Fix link deletion](gitlab-org/gitlab@a6d3efc598c6096e8bc1e67e54edbb89f3352a1b) ([merge request](gitlab-org/gitlab!83866))
- [Allow auditor to view group VSA analytics](gitlab-org/gitlab@eb0275d9607091a009e2e8a19e001ac7b8b35091) ([merge request](gitlab-org/gitlab!84058)) **GitLab Enterprise Edition**
- [Allow auditor to read group contribution analytics](gitlab-org/gitlab@448b87a81958a66c303c38a4f8c85175b8d2732d) ([merge request](gitlab-org/gitlab!83722)) **GitLab Enterprise Edition**
- [Handle escaped underscores in usernames](gitlab-org/gitlab@740a84f1736d4288cad1eb7c468324ff5853199e) ([merge request](gitlab-org/gitlab!83987))
- [Fix 500 error when visiting a non-existing integration](gitlab-org/gitlab@cfb038202e8a994deaa7b451d6ad78a2a29debd4) ([merge request](gitlab-org/gitlab!84076))
- [Expire relevant ETag caches for realtime_changes endpoints](gitlab-org/gitlab@9db1d178845f2fc1b4a4190f802d3d387ae7fb66) ([merge request](gitlab-org/gitlab!83849))
- [Allow auditor to view repository analytics](gitlab-org/gitlab@7de245e4a0b5cb991ea173aae6a21e403b5591a9) ([merge request](gitlab-org/gitlab!84047)) **GitLab Enterprise Edition**
- [Fix GraphQL pagination for vulnerabilities](gitlab-org/gitlab@bc304711af967cac9cbb2527d15fa0ced962cbf4) ([merge request](gitlab-org/gitlab!83476)) **GitLab Enterprise Edition**
- [Use cached column list for members union query](gitlab-org/gitlab@26834341dd7a88ee44d2f1b9ef7ff8f60ee95037) ([merge request](gitlab-org/gitlab!80421))
- [Add unique keyField for Blob types](gitlab-org/gitlab@5d023ddbea9d1b1496c1f1827aefd2cc9ce4e6db) ([merge request](gitlab-org/gitlab!83941))
- [Allow auditor to view devops adoption analytics](gitlab-org/gitlab@3aa656ad214001217e650a8bcdb1ce19eb9ee1d8) ([merge request](gitlab-org/gitlab!83731)) **GitLab Enterprise Edition**
- [Fixed `receiveDashboardValidationWarningsFailure`](gitlab-org/gitlab@da23f331e1498c3c901041837ca9a02f3ebb54d5) by @gotounix ([merge request](gitlab-org/gitlab!82876))
- [Handle BulkImports::ExportStatus incorrect export status value](gitlab-org/gitlab@fd9ed0969cb1fe3eda4cee33e4bd765725666a5f) ([merge request](gitlab-org/gitlab!83811))
- [Refactor environment empty state to use scope](gitlab-org/gitlab@43de07ebfdb876eb23c69842d793012da86fa53b) ([merge request](gitlab-org/gitlab!83422))
- [Remove attempted redirection on non-HTML requests](gitlab-org/gitlab@a7d28aca972c1660b0d8d7cc5a838b191e9b858b) ([merge request](gitlab-org/gitlab!83742))
- [Fix project permission toggle behavior](gitlab-org/gitlab@eda15b06820de7aeda8935290032b40a8305b216) ([merge request](gitlab-org/gitlab!83503))
- [Fix project permission toggle behavior](gitlab-org/gitlab@281631c44a910545c8d56f0afdaedab9e5002246)
- [Fixed crm db seed trying to seed non-root groups](gitlab-org/gitlab@c71943526765ff9ed44aa692565079df514616f0) by @leetickett ([merge request](gitlab-org/gitlab!83462))
- [Don't include compliance pipeline definition in scheduled security orchestration pipelines](gitlab-org/gitlab@286739d3e85600c8f6fd09aa72879b1eb2e94b93) ([merge request](gitlab-org/gitlab!82613)) **GitLab Enterprise Edition**
- [Fix code quality report display](gitlab-org/gitlab@7e67f483ccfcf98f3a373db32800ac148c13da76) by @nanmu42 ([merge request](gitlab-org/gitlab!83502))
- [Raise exception when gitaly-backup could not be found](gitlab-org/gitlab@eb823f56af7f8aa436290bbf50a2a27a9286c975) ([merge request](gitlab-org/gitlab!83555))
- [Replace success variant with the confirm](gitlab-org/gitlab@a6f5ac1f34065669ae8ba9df61a8a54d420417f6) ([merge request](gitlab-org/gitlab!83678)) **GitLab Enterprise Edition**
- [Updated ComplianceViolation merged_at where checks to use DATE()](gitlab-org/gitlab@c7af0ca214dd3c4607fe54b6b4c671c236b42e9d) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/83288)) **GitLab Enterprise Edition**
- [Fix missing metrics for Sidekiq exporter server](gitlab-org/gitlab@0e77c1819035d672160269a9bba966ce2bd6bac9) ([merge request](gitlab-org/gitlab!83407))
- [Fix incorrect new group path in import history](gitlab-org/gitlab@6b3074880353ba7923ffd111eb329d8afbff4453) ([merge request](gitlab-org/gitlab!83491))
- [Scope Geo replication details progressbar popup target by site ID](gitlab-org/gitlab@f2dd8faaaf1f355b69061dbdb58aa358324de862) ([merge request](gitlab-org/gitlab!83637)) **GitLab Enterprise Edition**
- [Allow auditor to view grop productivity analytics](gitlab-org/gitlab@58026486e38629b4c7aff5a1348573a78a1f858c) ([merge request](gitlab-org/gitlab!83532)) **GitLab Enterprise Edition**
- [Fix credentials detection for UrlSanitizer](gitlab-org/gitlab@7197ccad172bcc17410083418437276cea779dd1) ([merge request](gitlab-org/gitlab!83444))
- [Revert Protected Environment group access inheritence](gitlab-org/gitlab@493a1d63987ca4d7a6ee6f759a6cbc5018326758) ([merge request](gitlab-org/gitlab!83573))
- [Add an example path for gitaly_backup_path setting](gitlab-org/gitlab@ba5bd521268e0f63ceb7d514ef4d1bc8709d61d3) ([merge request](gitlab-org/gitlab!83569))
- [Suggestions: use template from target project instead of source project](gitlab-org/gitlab@1c64a7a6f4e61ae7bc0d926cb19d1250af50df0e) by @trakos ([merge request](gitlab-org/gitlab!82657))
- [Fix issue with delete project container text](gitlab-org/gitlab@7a2fe82fffd8ae9b26d9849ef1ed04270ae996ce) ([merge request](gitlab-org/gitlab!82941)) **GitLab Enterprise Edition**
- [Fix error in table when text is too long](gitlab-org/gitlab@b1f7558424f2b4c9c3da42f5bf64f19eed0487cb) ([merge request](gitlab-org/gitlab!83489))
- [Ensure ci_environment_status always return latest deployment status](gitlab-org/gitlab@ce47e982fb512440a1a2f50352571cb0640b6d44) ([merge request](gitlab-org/gitlab!83199))
- [Fix create issue in board with weight](gitlab-org/gitlab@479487ca8134ec0342475af48ce3b428c6b86ac1) ([merge request](gitlab-org/gitlab!83487)) **GitLab Enterprise Edition**
- [Fix GraphQlController not logging sessionless user](gitlab-org/gitlab@39cee0ce29ab3be4f3e1cc61ad9bbccc685a9fc9) ([merge request](gitlab-org/gitlab!83144))
- [Limit audit events controller to 31 days date range](gitlab-org/gitlab@fdfd9cbed8b58f6a83073270c59dfe5d5360ced5) ([merge request](gitlab-org/gitlab!83077)) **GitLab Enterprise Edition**
- [Fix ComplianceViolationResolver pagination with sorting](gitlab-org/gitlab@6d745e1365a24b54596d7401c3ce9c70b7f84c7d) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/83303)) **GitLab Enterprise Edition**
- [Fix PA for projects in nested groups](gitlab-org/gitlab@72116c7d43261412caa631dc582192e5a364889c) ([merge request](gitlab-org/gitlab!83282)) **GitLab Enterprise Edition**
- [Improve topic avatar copy](gitlab-org/gitlab@d399c7f306ac3857f306f2736180114e1676d608) ([merge request](gitlab-org/gitlab!83093))
- [Handle CRM objects when moving groups](gitlab-org/gitlab@859e14db890ae0b88e85d8513e4af0c6a04849cb) by @leetickett ([merge request](gitlab-org/gitlab!80540))
- [Always pass data payloads as a hash for hooks](gitlab-org/gitlab@1b956a6ea5048d999e8184656b55319cb79a86a1) ([merge request](gitlab-org/gitlab!83143))
- [Adding a forced UTF-8 conversion to prevent encoding errors](gitlab-org/gitlab@4fc0307863b40828440e06cffba4b89d08651b2f) ([merge request](gitlab-org/gitlab!79996))
- [Allow admins to invite groups they are not a member of for group](gitlab-org/gitlab@7b2a4941404009ad17b6b57e82b75a6438ed30cd) ([merge request](gitlab-org/gitlab!83002))
- [Update manual job message for protected jobs](gitlab-org/gitlab@fb371e6c0523f0b0b70ba2b62f16b4359867d39b) ([merge request](gitlab-org/gitlab!82907)) **GitLab Enterprise Edition**
- [Use last focused markdown field for quoted reply](gitlab-org/gitlab@bc23424ac431796ec1999af0e08f77c61f6ab22a) ([merge request](gitlab-org/gitlab!83284))
- [Retain membership record for a personal project’s owner after transfer](gitlab-org/gitlab@0e56b243fb5a39af6ba3e3fbae6ae912c7a28caa) ([merge request](gitlab-org/gitlab!83175))
- [Improve backup logging](gitlab-org/gitlab@04756cfcc71a59be60394642afece0f8c80c7563) ([merge request](gitlab-org/gitlab!83055))
- [Refetch runners list data after runner is updated](gitlab-org/gitlab@a68a1849a7b159f854f0acf6eb9ee3068deecc33) ([merge request](gitlab-org/gitlab!82502))
- [Fix markdown header toolbar showing in compact preview view](gitlab-org/gitlab@57d28d0410f5a256ba6fc4399f1f8eec58bac337) ([merge request](gitlab-org/gitlab!83244))
- [Fix vulnerability list clearing when already-selected filter is clicked](gitlab-org/gitlab@654ea526a5688e14f89f37dc511ba0404868c52b) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/83243)) **GitLab Enterprise Edition**
- [Upgrade rack-proxy to v0.7.2](gitlab-org/gitlab@b3734e7bcd0a894d4cc87513ce1bd22c9993227d) ([merge request](gitlab-org/gitlab!83241))
- [Convert seconds to minutes for the shared runner usage chart](gitlab-org/gitlab@2d6226318035862de017a9585660214ab611d7b1) ([merge request](gitlab-org/gitlab!83048)) **GitLab Enterprise Edition**
- [Fix NoMethodError for CommitController](gitlab-org/gitlab@c735208ee96c2a03f150c36ba0817821bc3c35d9) ([merge request](gitlab-org/gitlab!83123))
- [Fix backups not working when feature_flags table does not exist](gitlab-org/gitlab@e2862180f78dd9d03363cb571ee9ad6ed3954db3) ([merge request](gitlab-org/gitlab!83101))
- [SAST flawfinder + semgrep: add missing extensions](gitlab-org/gitlab@08785b0f9501296969d435a54e275e2c1a3e8869) by @blueur ([merge request](gitlab-org/gitlab!68348))

### Changed (227 changes)

- [Geo Sites - Empty Search State](gitlab-org/gitlab@4b04bd6f6e777af0acdbd7f2bde9e10e010fc6bb) ([merge request](gitlab-org/gitlab!85136)) **GitLab Enterprise Edition**
- [Use GlAvatar in environments dashboard](gitlab-org/gitlab@1056b8e706a9d722231449c66398c91dfd2ae0cc) ([merge request](gitlab-org/gitlab!84686))
- [Reduce size of file header buttons](gitlab-org/gitlab@5f491df89155a59a0e64ed566c8f036152c4e737) ([merge request](gitlab-org/gitlab!85322))
- [Remove setting link from branches page](gitlab-org/gitlab@afe86399caa591da06973027406573884092f2f9) ([merge request](gitlab-org/gitlab!85323))
- [Bump Gitaly to v14.10.0.pre.rc1](gitlab-org/gitlab@6d9b812e468c505822cbd40386f5202e33c23e61) by @nick.thomas ([merge request](gitlab-org/gitlab!84388))
- [Downgrade coverage-check approval rule to premium](gitlab-org/gitlab@7d72ece689b26ac97b17280808e9bf84ac61c16f) ([merge request](gitlab-org/gitlab!84290)) **GitLab Enterprise Edition**
- [Migrate localization checkbox](gitlab-org/gitlab@c33136b53112e1a30ae260ce575710cdf28e2339) ([merge request](gitlab-org/gitlab!84765))
- [Remove security_scan_succeeded from code](gitlab-org/gitlab@8f9e556e82775c147c1bc28327a0200bd1954f7f) by @svdj ([merge request](gitlab-org/gitlab!84222)) **GitLab Enterprise Edition**
- [Make OmniAuth initializer return Geo proxied URL when it exists](gitlab-org/gitlab@7d451b2f20d6614c1f2b36eaf8faa0047c31f157) ([merge request](gitlab-org/gitlab!82703)) **GitLab Enterprise Edition**
- [Replace generic checkbox with GitLab UI component](gitlab-org/gitlab@ba918ac8fec890408127f11e414886fb2b8038b3) ([merge request](gitlab-org/gitlab!84883)) **GitLab Enterprise Edition**
- [This MR replaces generic checkbox](gitlab-org/gitlab@3755d6c41ba3367ecbd7324e7f65469ee988b785) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/85327)) **GitLab Enterprise Edition**
- [Update variant to confirm](gitlab-org/gitlab@eec443bf1fea3b2df69140a6ad9f29fd5dde58b3) ([merge request](gitlab-org/gitlab!84763))
- [Use GlBroadcastMessage in Broadcast Message admin settings page](gitlab-org/gitlab@01af9dda9e3fb20a7a624146f710c6130a8f02fc) ([merge request](gitlab-org/gitlab!83251))
- [Change snippet award emoji state from active to selected](gitlab-org/gitlab@cfb995abdafa217143c8c1092f812fd6d8381012) ([merge request](gitlab-org/gitlab!85242))
- [Disable image deletion during registry migration](gitlab-org/gitlab@bcd6726ac82a898553e92371ed92678e4a34ff5a) ([merge request](gitlab-org/gitlab!85130))
- [Use Pajamas components for checkboxes in webhook forms](gitlab-org/gitlab@13825aeb4db3d273be28b747c4c4eeab53c27981) ([merge request](gitlab-org/gitlab!84753))
- [Update GITLAB_KAS_VERSION to 14.10.0](gitlab-org/gitlab@79642e1266aab46ac7f36f1d685c364d7baaf7f2) ([merge request](gitlab-org/gitlab!85273))
- [Update icon to long arrow](gitlab-org/gitlab@ca5188a2d30c6b9abd3523e3f0ba1d7cf4342ac4) ([merge request](gitlab-org/gitlab!85272))
- [Pass hash instead of URI to Elasticsearch client](gitlab-org/gitlab@a1b716a5ca904ddbe420df251da6df3ad31aae95) ([merge request](gitlab-org/gitlab!85122)) **GitLab Enterprise Edition**
- [Port checkboxes in spam settings to pajamas](gitlab-org/gitlab@5a30335f90e719716e884f9cb89f0f117cbcb840) ([merge request](gitlab-org/gitlab!84830))
- [Add spotbugs to analyzer order](gitlab-org/gitlab@1e9c5c77c72db1950ae6ad6650b361497e2d3199) ([merge request](gitlab-org/gitlab!85260))
- [Update variant to confirm](gitlab-org/gitlab@e0ba797decfa5b91013e8b9b332eebbd76031116) ([merge request](gitlab-org/gitlab!84730))
- [Allow invitations API to handle user invites as well as emails](gitlab-org/gitlab@3f7c9ba7532dff4500d1992a1d8a5b2a3e89145a) ([merge request](gitlab-org/gitlab!80733))
- [Use pajamas checkbox for group owners can manage default branch checkbox](gitlab-org/gitlab@54b70fdc45ee29dad5abec6f555bda91b484d56a) ([merge request](gitlab-org/gitlab!84851))
- [Migrate button to GlButton variants](gitlab-org/gitlab@17810d8d61dc9818c860e941c4063e3bb7ab0f3e) ([merge request](gitlab-org/gitlab!84804))
- [Updates checkboxes in Admin -> Settings -> General](gitlab-org/gitlab@cd82a922a141ef56d8529d801f10a9d785000dff) ([merge request](gitlab-org/gitlab!84761))
- [Use Pajamas styled checkbox in Admin help page form](gitlab-org/gitlab@9eb29c01245849d3d4df3e9ff7bafe53f54c5d73) ([merge request](gitlab-org/gitlab!84770))
- [Migrate checkboxes on user preferences page to be Pajamas compliant](gitlab-org/gitlab@5f4b0b7df9afff61a84d5e3c734eef1f556d7db3) ([merge request](gitlab-org/gitlab!84838))
- [Change variant to confirm](gitlab-org/gitlab@57d0372290c00377587c12bce9c9d24d4ed24fc4) ([merge request](gitlab-org/gitlab!84720)) **GitLab Enterprise Edition**
- [Update auto-deploy-image to v2.23.0](gitlab-org/gitlab@ad827355222d020543dc5fccae85e9e980769e7d) ([merge request](gitlab-org/gitlab!85214))
- [Change delete project confirmation modal to default size](gitlab-org/gitlab@6708d6564128841b395c5eca35f89b6b6cad5538) ([merge request](gitlab-org/gitlab!84532))
- [Migrate checkboxes on admin group edit page to be Pajamas compliant](gitlab-org/gitlab@9f760488a7a860908433921164a79c6afd9be286) ([merge request](gitlab-org/gitlab!84847))
- [Change subgroups to use official `subgroup` icon](gitlab-org/gitlab@dbb66e1fa4c67a14670c3882e43157b50c3d9466) ([merge request](gitlab-org/gitlab!85005))
- [Prevent global user searches](gitlab-org/gitlab@7664bf962586d137d0cef70864553806ab0d8a2c) ([merge request](gitlab-org/gitlab!84186))
- [Move diff overflow warning into component](gitlab-org/gitlab@17d02a4004ec3a3800ccaa96730d2228e9220d5d) ([merge request](gitlab-org/gitlab!83970))
- [Add more helpful error when not authorized to update](gitlab-org/gitlab@9ee36ff74d579e92453601dae6c33a67f0c9e941) ([merge request](gitlab-org/gitlab!84105))
- [Hide IP Address label when no space is available](gitlab-org/gitlab@8a08a443e76b1a9927580497df2ae886cf5343f8) ([merge request](gitlab-org/gitlab!84049))
- [Re-backfill escalation statuses](gitlab-org/gitlab@f91a6a0f0f94f8f49be993eca6baac74950ffad6) ([merge request](gitlab-org/gitlab!83159))
- [Update monitor deprecation notices](gitlab-org/gitlab@f5c88c1e22ab22839e425393a448b2cff4afe335) ([merge request](gitlab-org/gitlab!85065))
- [Update unprotect branch button variant and size](gitlab-org/gitlab@3d12efbe18a343988a7d348e6471c7c466cf87fa) ([merge request](gitlab-org/gitlab!84793))
- [Update checkbox third party offers to be Pajamas compliant](gitlab-org/gitlab@2a7026bebe4f93eb39f416e79ce9c7bb67245be1) ([merge request](gitlab-org/gitlab!84790))
- [Migrate checkboxes on user notifications page to be Pajamas compliant](gitlab-org/gitlab@977e30c8454fe3f56e09b330081ef38c5d3d0e26) ([merge request](gitlab-org/gitlab!84843))
- [Migrate pipeline setting checkbox to Pajamas design system](gitlab-org/gitlab@66a8dc3a144e00ab47046e6568aa9f6f365d0859) ([merge request](gitlab-org/gitlab!84758))
- [Use pajamas checkbox for appearance header and footer form](gitlab-org/gitlab@c1318de6c0fadfc75cde3404e9e6e1dbbaa1381a) ([merge request](gitlab-org/gitlab!84850))
- [Improve readability for MR review emails](gitlab-org/gitlab@3584f5db00422ba5edca6d2b8100d5f575e449a0) ([merge request](gitlab-org/gitlab!84815))
- [Update brand header logo to match tanuki height](gitlab-org/gitlab@0ad35209f0be50ac307b0a99f690dac763cd07da) ([merge request](gitlab-org/gitlab!84939))
- [Port admin hooks form to be pajamas compliant](gitlab-org/gitlab@22df1b980a8b29ee25b8f02229bc1ee2c2648b35) ([merge request](gitlab-org/gitlab!84791))
- [Migrate account limits checkboxes](gitlab-org/gitlab@b1107c1118e82d159df2fc03f1c498281332a0df) ([merge request](gitlab-org/gitlab!84739))
- [Update corpus management file size formatting to appear cleaner](gitlab-org/gitlab@dffa5d6314c8f40b3760077e662fcdd003969240) ([merge request](gitlab-org/gitlab!84233)) **GitLab Enterprise Edition**
- [Migrate admin pages settings to GitLab UI](gitlab-org/gitlab@89e1f7b10076c66845f2a28788da02f60e91a3dc) ([merge request](gitlab-org/gitlab!84805))
- [Replace generic checkbox with GitLab UI element](gitlab-org/gitlab@b234c2a1c9e41a0fcda7efcb2f31f553d0a41a80) ([merge request](gitlab-org/gitlab!84745))
- [Replace generic checkbox with GitLab UI component](gitlab-org/gitlab@228ee325df0fbf45339f78df7d690435c348d6d0) ([merge request](gitlab-org/gitlab!84859))
- [Replace generic chackbox with GitLab UI element](gitlab-org/gitlab@7df5ab618846568c58a0a42dcb84e978a86bd8fb) ([merge request](gitlab-org/gitlab!84826))
- [Enable vulnerability_reads_table by default](gitlab-org/gitlab@e112ef644a8be748ab611148deff70c9fc2006e3) ([merge request](gitlab-org/gitlab!84905)) **GitLab Enterprise Edition**
- [Replace generic checkbox with GitLab UI component](gitlab-org/gitlab@6802c153ae6800d5f777f965a9d3e3dfafa0a073) ([merge request](gitlab-org/gitlab!84903))
- [Allow unconfirmed users in non-admin searches](gitlab-org/gitlab@a40898af0ff48b396f9deb049fbea3a64534e208) ([merge request](gitlab-org/gitlab!85097)) **GitLab Enterprise Edition**
- [Replace generic checkbox with GitLab UI element](gitlab-org/gitlab@c640c44f91201d72379415b2685debe51e4fd2f2) ([merge request](gitlab-org/gitlab!84819))
- [Run all deployment jobs for the common pipeline with same environment](gitlab-org/gitlab@d886be0725bc6c8af1a977fef78089c1bba8adda) ([merge request](gitlab-org/gitlab!84922))
- [Replace generic checkbox with GitLab UI component](gitlab-org/gitlab@6fc1886dd42e3dce46f942a57c2b620e294b7008) ([merge request](gitlab-org/gitlab!84858))
- [Remove group_import_export feature flag](gitlab-org/gitlab@c5ff1bef58d408490200a52d2f970aee24e1f050) ([merge request](gitlab-org/gitlab!84444))
- [Migrate checkbox for performance optimization settings](gitlab-org/gitlab@0be603323a5d2aca280bea6f3176f16ae40fdd7c) ([merge request](gitlab-org/gitlab!84797))
- [Recommend Helm for installing the GitLab agent](gitlab-org/gitlab@0ecc5a4f98e087437358d2690aff1d0e3beed276) ([merge request](gitlab-org/gitlab!84219))
- [Read encrypted properties](gitlab-org/gitlab@2cf5ee3809ea338057a8a2c447f9b10b047dde0c) ([merge request](gitlab-org/gitlab!80507))
- [Use Pajamas checkbox for ldap_access_setting.html.haml](gitlab-org/gitlab@8426d66cb49f4d36410fd567e9ff697db6a084d3) ([merge request](gitlab-org/gitlab!84852)) **GitLab Enterprise Edition**
- [Geo status: Explicate item counts](gitlab-org/gitlab@8fb91144c3a09374a649d533c5c8daebaad5167e) ([merge request](gitlab-org/gitlab!83004)) **GitLab Enterprise Edition**
- [Add GlButton classes to complete button migration](gitlab-org/gitlab@2f20560218d3e293bb21f69e4f48cc2528dd9dbc) ([merge request](gitlab-org/gitlab!84786))
- [Change button label](gitlab-org/gitlab@17cc32935633081648281d3a6eff71b1366b0612) ([merge request](gitlab-org/gitlab!84680))
- [Add remaining storage size to namespace storage email notification](gitlab-org/gitlab@cb824d06387698453c0f89f1e419066b5d607bd9) ([merge request](gitlab-org/gitlab!84416))
- [Make WebIDE dropdown fullwidth](gitlab-org/gitlab@c978f267ed6b04af353dfde6624b83b13f48ed98) ([merge request](gitlab-org/gitlab!84442))
- [Modify container-scanning template to automatically apply `FIPS` image](gitlab-org/gitlab@965cc5c09c0429a36977cbf3b979b6b5c3da42ba) ([merge request](gitlab-org/gitlab!84465))
- [This MR adds info badge to DAST configuration card](gitlab-org/gitlab@a510f49ac47a48b41fbc738d17aa67fb13691a6a) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/83723)) **GitLab Enterprise Edition**
- [Move Alerts metric image API to CE](gitlab-org/gitlab@7dc5e160752eee584a3e91e191c939b56d2747df) ([merge request](gitlab-org/gitlab!84918))
- [Migrate form checkbox in the Grafana admin settings](gitlab-org/gitlab@c523be218bb5a9982ff26cbc95370b07a08963c4) ([merge request](gitlab-org/gitlab!84772))
- [This MR replaces generic checkbox](gitlab-org/gitlab@c15468dd179336d7512432e1e29b19ee284ed201) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/84863)) **GitLab Enterprise Edition**
- [This MR replaces generic checkbox](gitlab-org/gitlab@7a4e82b1cc7adebd69efa9527298ef0c655dfb7e) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/84848)) **GitLab Enterprise Edition**
- [Add help link for escalation status dropdown](gitlab-org/gitlab@e8893853e4bd27d2c25040e22c9b1c4fc47e32ac) ([merge request](gitlab-org/gitlab!83180)) **GitLab Enterprise Edition**
- [Use GlAvatar in environments dashboard](gitlab-org/gitlab@29e4ec70ee3c7ec774dcf8e82d4bb449a317eefa) ([merge request](gitlab-org/gitlab!84689))
- [Enable vulnerability_report_pagination feature flag by default](gitlab-org/gitlab@c188d1dca991b8c3d52f61942d3340690b4e1df5) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/84553)) **GitLab Enterprise Edition**
- [Replace generic checkbox with GitLab UI component](gitlab-org/gitlab@ee672e1e2a408e445a73056f2ce07555be8b7e0f) ([merge request](gitlab-org/gitlab!84857))
- [Use pajamas checkbox for user access level form](gitlab-org/gitlab@3a60faf8e8c78cdfd08f476774f07a6e1ea8f780) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/84849))
- [Add HTML5 validation to about your company form](gitlab-org/gitlab@968b605df4d7d71ecce9a5d3faae7dc0306f9a84) ([merge request](gitlab-org/gitlab!84662)) **GitLab Enterprise Edition**
- [Document Kubernetes 1.21 as supported](gitlab-org/gitlab@db7f4173853159799b5818eae663f88617d55214) ([merge request](gitlab-org/gitlab!84816))
- [Migrate snowplow checkbox](gitlab-org/gitlab@12424d0f9b10c90abf648c3c8848d2eeab36be9b) ([merge request](gitlab-org/gitlab!84798))
- [Migrate sourcegraph checkboxes](gitlab-org/gitlab@69594bdb9877f3e9520b3b0a0cb610bab4e69de2) ([merge request](gitlab-org/gitlab!84795))
- [Add more verbose error message if 2FA required](gitlab-org/gitlab@f228a19e35196d24a9a93766a19929fec3711fad) ([merge request](gitlab-org/gitlab!84405))
- [Port app settings checkboxes](gitlab-org/gitlab@a3582c35dee152b68445b00389872c9c25af9eaa) ([merge request](gitlab-org/gitlab!84729))
- [Port checkbox in pipeline schedules](gitlab-org/gitlab@bd464f14473b8381b2cbbfddeee39335a1d58369) ([merge request](gitlab-org/gitlab!84784))
- [Change variant to confirm](gitlab-org/gitlab@3c08b183492e2c431c48a24acc6fefc7acf6aa28) ([merge request](gitlab-org/gitlab!84785))
- [Change variant to confirm](gitlab-org/gitlab@36e246b3cc32431998be19d049282f37e00a265b) ([merge request](gitlab-org/gitlab!84768))
- [Change variant to confirm](gitlab-org/gitlab@8770cf544e771ca3d002880f5dc5f995024ae819) ([merge request](gitlab-org/gitlab!84766))
- [Add validation for confidentiality notes](gitlab-org/gitlab@a839c720ce7e2f529d874e7270e9ab4d20145e92) ([merge request](gitlab-org/gitlab!83847))
- [Add status to DependencyProxy::Manifest type in GraphQL](gitlab-org/gitlab@5bad251e7be0cb877341e31a55f0c170fad2883f) ([merge request](gitlab-org/gitlab!84200))
- [Migrate admin email checkboxes](gitlab-org/gitlab@23082f0ad36925953b3754c9d649ffe47ab2f495) ([merge request](gitlab-org/gitlab!84759))
- [Migrate group auto devops form to GitLab UI](gitlab-org/gitlab@bc2ccb66c508d1b1208673aff7a683c791efbb16) ([merge request](gitlab-org/gitlab!84750))
- [Change variant to confirm](gitlab-org/gitlab@2b5ffd8ff1aa0c74459e9abf6c196139932e9b57) ([merge request](gitlab-org/gitlab!84734))
- [Change variant to confirm](gitlab-org/gitlab@9efa5459d8f8b1a503a1e5a31c39a77e2f96565a) ([merge request](gitlab-org/gitlab!84717))
- [Update to rails 6.1.4.7](gitlab-org/gitlab@ca931fddcf79ae9bfad1c6e50c58cdf9fbf8e55d) ([merge request](gitlab-org/gitlab!84638))
- [Change variant to confirm](gitlab-org/gitlab@39417a4332f4d762f088c96596581f2f92f28bdd) ([merge request](gitlab-org/gitlab!84722))
- [Adds a project scoped unique file name constraint for Secure Files](gitlab-org/gitlab@ac418c0a54f9bd9ca064f59a918ed4af3376109c) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/83628))
- [Improve accessibility of Admin application settings page](gitlab-org/gitlab@de4866d62cc0f3d573c021f478174c6263baa45d) ([merge request](gitlab-org/gitlab!84651))
- [Updated encyption key generation for Secure Files](gitlab-org/gitlab@7e3d5508a63b366302ed0b44cc4ffd04cf3b710e) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/83652))
- [Find topic by case insensitive name for detail page](gitlab-org/gitlab@f55748d3d7d3684c4149e4d60035c91e84f594d8) by @wwwjon ([merge request](gitlab-org/gitlab!84064))
- [Bump Gitaly server to v14.10.0.pre.rc1](gitlab-org/gitlab@3abef5e90e1bcbf6c7a19b61ee53c544543ceb9b) ([merge request](gitlab-org/gitlab!84646))
- [Update GlButton variant to confirm in test cases](gitlab-org/gitlab@af6b3c746f97b19535bfa2e9a7c977e8dc35a409) ([merge request](gitlab-org/gitlab!84632)) **GitLab Enterprise Edition**
- [Added educational text about K8s deployments](gitlab-org/gitlab@2dfad6d50ba50e9eb370ec160558cdb04759e25d) ([merge request](gitlab-org/gitlab!84224))
- [Polish Jira issue fields UI](gitlab-org/gitlab@3bd26ef23a4a192175c274516bd65de9cfa52c05) ([merge request](gitlab-org/gitlab!84353)) **GitLab Enterprise Edition**
- [Use SHA256 fingerprint instead of MD5 for LFS token secret](gitlab-org/gitlab@ea76f3c26c99159711a4e7b5eaea6477a43f091e) ([merge request](gitlab-org/gitlab!84606))
- [Fix: notify service i18n for MR and Issues](gitlab-org/gitlab@fb5a54ad4b8013130b1d990825c6094e5e344ffb) by @JeremyWuuuuu ([merge request](!84123))
- [Remove the ip check from the captcha challenge check](gitlab-org/gitlab@fbd1778d13afacd9996db03d4b3fe3ff2cf96a50) ([merge request](gitlab-org/gitlab!84540)) **GitLab Enterprise Edition**
- [Polish UI of epic roadmap view](gitlab-org/gitlab@3d80702194ea269239cd63ee0af96c13e8eab10b) ([merge request](gitlab-org/gitlab!84268)) **GitLab Enterprise Edition**
- [Only admins can search blocked and banned users](gitlab-org/gitlab@e17ce9fb04280f774debe138f85283601030ae20) ([merge request](gitlab-org/gitlab!84080)) **GitLab Enterprise Edition**
- [Polish jira_connect users UI](gitlab-org/gitlab@c10cf65b17bfb3b9b2e0e31feef10f853beed8ee) ([merge request](gitlab-org/gitlab!84260))
- [Remove support for file checksum to Secure File uploads](gitlab-org/gitlab@2d1a57c6b726f8b733a56de1b3f79e2939bd150e) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/84314))
- [Updated Kubernetes clusters UI](gitlab-org/gitlab@d1873459e2c297244bbff8a1369f3bc32b1ccbf5) ([merge request](gitlab-org/gitlab!84108))
- [Ignore unindexed projects that have no repository](gitlab-org/gitlab@b5ed9e3880a38a3e2432fcb8fd6de0b579fa95a1) ([merge request](gitlab-org/gitlab!83870)) **GitLab Enterprise Edition**
- [Add repository size to Plan Limits](gitlab-org/gitlab@50afaa9f8ecfca724c5877a5ef378b8c1d49e5dc) by @zhzhang93 ([merge request](gitlab-org/gitlab!83819))
- [Refactor DAST Profiles to use GraphQL fragments](gitlab-org/gitlab@09ee60ae75b288ddd229f3b3e772fa06174765d2) ([merge request](gitlab-org/gitlab!84172)) **GitLab Enterprise Edition**
- [Keep labels sorted by title after mutation](gitlab-org/gitlab@0128b699857c491095625a65f85b2c3e81e9c3c4) ([merge request](gitlab-org/gitlab!83946))
- [Move liquibase template up one directory](gitlab-org/gitlab@d156f2e06bab9cdc3ed18942df785bf70c9f601b) ([merge request](gitlab-org/gitlab!84440))
- [Show UsageData buttons only if cache exists](gitlab-org/gitlab@1e30c3fa6ad2f5d44108623e52373a1ec45dc19e) ([merge request](gitlab-org/gitlab!83490))
- [Extend namespace gitlab_subscription API](gitlab-org/gitlab@ea5eedfca67503daf0f97d48e5f09216c042e33e) ([merge request](gitlab-org/gitlab!84069)) **GitLab Enterprise Edition**
- [Serialize and deserialize by default for LocalStorageSync component](gitlab-org/gitlab@d808cf4de65e361fead701876899eb6809079c02) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/84159))
- [Update group overview icons to match sidebar icons](gitlab-org/gitlab@4301922d6847a9053aba2cc2d917113be08e2e2e) ([merge request](gitlab-org/gitlab!84113))
- [Don't generate MD5 fingerprint in FIPS mode](gitlab-org/gitlab@ac7c376d892f25e46accbeb96e8b2bb9372224af) ([merge request](gitlab-org/gitlab!84390))
- [Log deprecated/unsupported report schema versions](gitlab-org/gitlab@5caa90d02f6eaf1285aea4c7c3831abd232aabee) ([merge request](gitlab-org/gitlab!84117)) **GitLab Enterprise Edition**
- [Update DAST site profile mutations to return payload](gitlab-org/gitlab@1f66f68e54cdcaec9d8214883f301db25610df02) ([merge request](gitlab-org/gitlab!84257)) **GitLab Enterprise Edition**
- [Update DAST Scanner Profile Mutations to return payload](gitlab-org/gitlab@3c7b7d436e3e90a4173b6cc2e3f1c8a45a417f38) ([merge request](gitlab-org/gitlab!83383)) **GitLab Enterprise Edition**
- [Replace compliance dashboard with new compliance violations report](gitlab-org/gitlab@245757494fd39934e88ee4352999744d4a501f67) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/83959)) **GitLab Enterprise Edition**
- [Do not allow to change note's confidentiality](gitlab-org/gitlab@3839c16ac44cd08aaf4086623d587b29dcdcf479) ([merge request](gitlab-org/gitlab!84174))
- [Removing the ignored column project_pages_metadata.artifacts_archive_id](gitlab-org/gitlab@ee5fe2823b5de11c75145368ad152ba5121d3569) ([merge request](gitlab-org/gitlab!83660))
- [Merge topics with same name](gitlab-org/gitlab@ff6cc894fd1cfbb62ce8e92e1fa2c0d572126052) by @wwwjon ([merge request](gitlab-org/gitlab!81503))
- [Updated language on vulnerability report page](gitlab-org/gitlab@b652f30b38d51aaeb0ef964b1463faaf37013afc) ([merge request](gitlab-org/gitlab!82438)) **GitLab Enterprise Edition**
- [Remove gray background from milestone page](gitlab-org/gitlab@040386e28ea0d800b32cb747656e7bfff7ca92d9) ([merge request](gitlab-org/gitlab!83557))
- [Replace runners 'active' filters with 'paused'](gitlab-org/gitlab@65f2450e086dc1c5a4089f8c03b86fcb8bef3c67) ([merge request](gitlab-org/gitlab!83865))
- [Merge branch '356485-refactor-detected-licenses' into 'master'](gitlab-org/gitlab@d74aea9c4b94b42df76876483f472775e3cdc754) ([merge request](gitlab-org/gitlab!83831)) **GitLab Enterprise Edition**
- [Migrate alert to shared partial in import group](gitlab-org/gitlab@2139a7624fdae80420889ba2e447668505cdd47f) ([merge request](gitlab-org/gitlab!83399))
- [Ensure Workhorse AWS endpoint is only used for S3](gitlab-org/gitlab@d048a860bfd79d9d7c0426d9feceb19438c07852) ([merge request](gitlab-org/gitlab!83695))
- [Use GlAvatar in design note](gitlab-org/gitlab@92123bb03fd0f2ed179be273cae84dcb2cac55c2) ([merge request](gitlab-org/gitlab!84033))
- [Change license compliance to use warning alert](gitlab-org/gitlab@e33222973e5ae02d5df6c825d76c97a89dad4068) ([merge request](gitlab-org/gitlab!83831))
- [Migrate alert to shared partial in notifications](gitlab-org/gitlab@d1ea722206d6e9daec6779524b13990f8016975a) ([merge request](gitlab-org/gitlab!82693))
- [Change user popover avatar to supported size](gitlab-org/gitlab@8e6888e6cfa5c893b3c3d7fd5042a904c2518ecd) ([merge request](gitlab-org/gitlab!84199))
- [gitlab/setup_helper: Migrate Gitaly to use runtime directory](gitlab-org/gitlab@95c236c089e6199e50a9b502dbf07c8aaca4ed09) ([merge request](gitlab-org/gitlab!83921))
- [Feat(License): update license type names](gitlab-org/gitlab@f3dc3ec3951da3c56a2d95481a6dfeeefce91150) ([merge request](gitlab-org/gitlab!83611)) **GitLab Enterprise Edition**
- [Add binaries folder and remove build flags in Go CI-Template](gitlab-org/gitlab@4336bc220501db12f14d600fa30a92e4bd98b4e7) ([merge request](gitlab-org/gitlab!77994))
- [Roadmap App with Tree View](gitlab-org/gitlab@e2e0cb4fb51c1dd42c0936fce405557557efa203) ([merge request](gitlab-org/gitlab!82795)) **GitLab Enterprise Edition**
- [Remove link to content editor feedback issue](gitlab-org/gitlab@f22dab40f18cdf14bb47a2c096502885f044f892) ([merge request](gitlab-org/gitlab!83529))
- [Remove user_email_lookup_limit column](gitlab-org/gitlab@887b515d6ae9cfd0ed4b47b2d0286e2118304fcf) ([merge request](gitlab-org/gitlab!83358))
- [Change container registry policy banner](gitlab-org/gitlab@6c5117753dd11de1666f6b970313f08c9734cd73) ([merge request](gitlab-org/gitlab!83667))
- [FIPS support for API keys endpoint](gitlab-org/gitlab@b0a90d53719a5d2e4bdc55b989e7fcf2e06b59c7) ([merge request](gitlab-org/gitlab!82911))
- [Migrate diff stats view to component](gitlab-org/gitlab@b1e93200ca6321f5360d072ccfd4f09fed6ac0aa) ([merge request](gitlab-org/gitlab!83882))
- [Adds status popover in runners table header](gitlab-org/gitlab@6ab9eac8ada979d0ed48a82e3e87de1623a0b396) ([merge request](gitlab-org/gitlab!83305))
- [Add labels to the 'Note on MR' webhook payload](gitlab-org/gitlab@2a01b2c24e09b1dd545ed99dc544c86a275335cf) ([merge request](gitlab-org/gitlab!83536))
- [Update locked tooltip for project runners](gitlab-org/gitlab@aae74d7477434519127681369f9c3e792eceffd7) ([merge request](gitlab-org/gitlab!84037))
- [Update the translations](gitlab-org/gitlab@1d380c048664bbb243073ee43de57f616da7912b) ([merge request](gitlab-org/gitlab!84032))
- [Filter out project bots from user results on invite members](gitlab-org/gitlab@7a9a10c83aa790929ff1abddbc605967c1979b90) ([merge request](gitlab-org/gitlab!83651))
- [Switch grad hat icon with bulb for learn gitlab](gitlab-org/gitlab@7b5020ffd2f18bc6e2f3e8baa6c74cb4a1644d23) ([merge request](gitlab-org/gitlab!83421))
- [Remove go to profile text from tooltips](gitlab-org/gitlab@dd199dcbddc309cdd763e5bbcdcd9a6cc11cf2d2) ([merge request](gitlab-org/gitlab!83906))
- [Update "locked" tooltips and text](gitlab-org/gitlab@7e3c2e3b01cf9c9de561788260935aaa221850b4) ([merge request](gitlab-org/gitlab!83588))
- [Add index to improve speed of vulnerabilities](gitlab-org/gitlab@f43b924222934ac51739537b3fa8ff058d97bcb9) ([merge request](gitlab-org/gitlab!83028))
- [Update button text in pipeline editor](gitlab-org/gitlab@de41a49784dccfe1a832723a60aab2146c8b7b1c) ([merge request](gitlab-org/gitlab!83912))
- [Make the shared/groups/_dropdown Pajamas compliant](gitlab-org/gitlab@029cf71050ed86d5281d503a578e2c711885ba8c) ([merge request](gitlab-org/gitlab!81370))
- [Update help popover icon](gitlab-org/gitlab@394087787c5c27244195a1a10443e692d8cadcfa) ([merge request](gitlab-org/gitlab!83735))
- [Support attn alias for attention](gitlab-org/gitlab@03e94951382b2202037f50204cc7d44cb9ed1644) ([merge request](gitlab-org/gitlab!83876))
- [Issue 323331 - createFlash called twice in search fetchProjects](gitlab-org/gitlab@321284e59af43fb9bef9893760e2604b74f6b67c) ([merge request](gitlab-org/gitlab!82101))
- [Update help link in UI to remove 'ee'](gitlab-org/gitlab@96f153c6ac901143ec73c1c6ee576b27b74c64d5) ([merge request](gitlab-org/gitlab!83767))
- [Issue 351689 - Prevent autocomplete searches under X characters](gitlab-org/gitlab@8610b290eb9d12db29102eb7684816e04c127ca9) ([merge request](gitlab-org/gitlab!82011))
- [Update DAST profile summary to hide empty values](gitlab-org/gitlab@229146124db1e5f2fb5bd0c337c8d1be571a9b54) ([merge request](gitlab-org/gitlab!83737)) **GitLab Enterprise Edition**
- [Updated wording for the agent token instructions](gitlab-org/gitlab@f72a0a0a0a9ba1b97cd76fcda3eee0df629430bf) ([merge request](gitlab-org/gitlab!83685))
- [Optimise ci_namespace_mirrors_for_group_members to search prefix](gitlab-org/gitlab@123ecd49064c1cd983a6d406dbb21f4b3ab1a6fa) ([merge request](gitlab-org/gitlab!83521))
- [Relocate runner IP Address to Runner column](gitlab-org/gitlab@74421bd2ad34125a361a4816e741253f8dfe947c) ([merge request](gitlab-org/gitlab!83841))
- [Redirect deprecated SSE to Web IDE](gitlab-org/gitlab@049fcae4d7743132001843ed3c0edaf61ebdde06) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/80347))
- [Migrate export group alerts to be Pajamas compliant](gitlab-org/gitlab@cd47a4aadc7837d749741b22a85ac80e2d6c18cb) ([merge request](gitlab-org/gitlab!83471))
- [Adjust ProjectExportWorker urgency](gitlab-org/gitlab@b7a17db6c97a8b9e7554f41b2c4f67b8c35d336f) ([merge request](gitlab-org/gitlab!83829))
- [Specify that the committer email is checked](gitlab-org/gitlab@0ca0adead8b333d965f4be1ad0036f491a9ec624) ([merge request](gitlab-org/gitlab!83675)) **GitLab Enterprise Edition**
- [Use GlAvatar in project_list_item component](gitlab-org/gitlab@2b5aa792cd2c56941a43bfae9f847434eff3462c) ([merge request](gitlab-org/gitlab!83806))
- [Remove the jira_connect_installation_update flag](gitlab-org/gitlab@21903484af6364de04fe280b90b56b5d5c426ab3) ([merge request](gitlab-org/gitlab!83790))
- [Add stricter e-mail validation for on push notification](gitlab-org/gitlab@3163947a665fa509c0df22f32d7a6bacff6961a0) by @lenikadali ([merge request](gitlab-org/gitlab!81377))
- [Geo migrations settings are included by default](gitlab-org/gitlab@b31d0afee764aeed553b276ce161bdf232ff5672) ([merge request](gitlab-org/gitlab!83350)) **GitLab Enterprise Edition**
- [Default multi_json to Oj](gitlab-org/gitlab@67e8efb3e4c04586e17eb71bfbc05ddd18e458dc) ([merge request](gitlab-org/gitlab!83762))
- [Update button text for DAST On-demand scans](gitlab-org/gitlab@e22383c5501bc139b639fe92ddd891702d71cff2) ([merge request](gitlab-org/gitlab!83368)) **GitLab Enterprise Edition**
- [gitlab/setup_helper: Migrate Gitaly to use runtime directory](gitlab-org/gitlab@a3995840a4f92da63464d01f782318186764e8af) ([merge request](gitlab-org/gitlab!83750))
- [Hide "Users in Subscription" card for Ultimate plans](gitlab-org/gitlab@98d725bf2402b95351b5dfce7533ae515949d4c7) ([merge request](gitlab-org/gitlab!81286)) **GitLab Enterprise Edition**
- [Update copy for DAST Profile library page](gitlab-org/gitlab@8c5ddb5a06b02f7e01b6db39ba82a5f2bae78d80) ([merge request](gitlab-org/gitlab!83375)) **GitLab Enterprise Edition**
- [Period limit default Insights yaml](gitlab-org/gitlab@bf4b837da79c3a33b1b4ff378927f95781c8ec87) ([merge request](gitlab-org/gitlab!83718)) **GitLab Enterprise Edition**
- [Change default search rate limits](gitlab-org/gitlab@cdf566e80d85049cf8f0cbd8378130b3ca9eead9) ([merge request](gitlab-org/gitlab!83474))
- [Adjust icons and button wording for license compliance](gitlab-org/gitlab@39a4e79e012a135e1d19b9adba4ca8ea856b09e4) ([merge request](gitlab-org/gitlab!83703))
- [Generalize empty array for all scanners](gitlab-org/gitlab@1863e378574d3a384a0dede6811270753e065fd3) ([merge request](gitlab-org/gitlab!82644)) **GitLab Enterprise Edition**
- [Update mutation to unassign security policy from a group](gitlab-org/gitlab@91f82fc80f6cbaf86424bb70ef61cd4d281ae8bb) ([merge request](gitlab-org/gitlab!83190)) **GitLab Enterprise Edition**
- [Force Host header rewrite in Workhorse for Geo proxying](gitlab-org/gitlab@131dd305f388427d8bc380631b2a63898af130be) ([merge request](gitlab-org/gitlab!83550)) **GitLab Enterprise Edition**
- [Order projects by real last update](gitlab-org/gitlab@df50868507cc2ed3a57ee41a95a767fd2bae3a07) by @wwwjon ([merge request](gitlab-org/gitlab!82488))
- [Use neutral colours for nav background](gitlab-org/gitlab@af906641c4e7c9fc67c33c31f142a63b3db514d9) ([merge request](gitlab-org/gitlab!83593))
- [Capture user feedback in `Feedback` not `Meta` for Google Cloud app](gitlab-org/gitlab@7feb0ebe6cf235cc2c56b070ef97fd0df91e4cd4) ([merge request](gitlab-org/gitlab!83324))
- [Remove unnecessary html respond](gitlab-org/gitlab@14e817696db07429ef873511e015ecddb482f32d) ([merge request](gitlab-org/gitlab!83533))
- [Use instrumentation classes for Service Ping metrics](gitlab-org/gitlab@6fb00a70c4eda4ec5ede00dc52e64b7ff9d370ba) ([merge request](gitlab-org/gitlab!81139))
- [Expose membership_lock on group detail API](gitlab-org/gitlab@691bf90da4972e15a6028757fb8ca1ae5348308a) by @jtymes ([merge request](gitlab-org/gitlab!82271)) **GitLab Enterprise Edition**
- [Remove block_namespace_serialization feature flag](gitlab-org/gitlab@fef06e63c0f7a73b85a8686bde9c1e8b6db22c8f) ([merge request](gitlab-org/gitlab!83572))
- [Update mutation to create and assign security policy to a group](gitlab-org/gitlab@039cc7184bae6f7b9e296e3397aab7d716a137d6) ([merge request](gitlab-org/gitlab!83191)) **GitLab Enterprise Edition**
- [This MR adds new empty state for corpus management](gitlab-org/gitlab@b087a911458b9d08d26feefa143d781226b07119) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/82707)) **GitLab Enterprise Edition**
- [Adding upload checksum to Secure Files API](gitlab-org/gitlab@e3ade86748635306f2f4b4df8c690862719e9ba5) ([merge request](gitlab-org/gitlab!83192))
- [Update tooltips for runner statuses](gitlab-org/gitlab@125a7c07df302bbc8ff0711abc26b33a6ac615a5) ([merge request](gitlab-org/gitlab!83276))
- [Ignore format of unmatched route](gitlab-org/gitlab@9a14f547e32ac5130fe392473f679c536f386156) ([merge request](gitlab-org/gitlab!83523))
- [Remove feature flag ci_use_new_monthly_minutes](gitlab-org/gitlab@9d0566ff825701668afdf9630d087660adc2adce) ([merge request](gitlab-org/gitlab!83274)) **GitLab Enterprise Edition**
- [Add overage check for members and groups](gitlab-org/gitlab@5749edb18a754488d937c489c51e1c7307a0fcce) ([merge request](gitlab-org/gitlab!78287)) **GitLab Enterprise Edition**
- [Global Search - Enable Header Search Default](gitlab-org/gitlab@64d3f3620f4b5fe19b32ca91b44434d74e7e6d05) ([merge request](gitlab-org/gitlab!79993))
- [More helpful empty states for milestones](gitlab-org/gitlab@e3ebb7c41a81560f54ce37d217cea0ee7296dded) ([merge request](gitlab-org/gitlab!81190))
- [Remove omniauth_login_minimal_scopes feature flag](gitlab-org/gitlab@bb7641aa831481e3d5af0a8d0a5039da7c49e668) ([merge request](gitlab-org/gitlab!83453))
- [Link to previous path when viewing blame on renamed files](gitlab-org/gitlab@638f56213643bf84e2b3287518896dc689d71738) by @tchandelle ([merge request](gitlab-org/gitlab!80231))
- [Use gl-drawer for pipeline editor help drawer](gitlab-org/gitlab@b5835ba51927bcac8cf876dd8ca442ae7c60cf98) ([merge request](gitlab-org/gitlab!83044))
- [Limit the number of commits in push merge request emails](gitlab-org/gitlab@931bad569d7535beea367e71160929fae4c3ca08) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/82801))
- [Remove integration_form_sections feature flag](gitlab-org/gitlab@d728e322427f86981e488130cd55a748a00898f8) ([merge request](gitlab-org/gitlab!83271))
- [Enable refactor_blob_viewer by default](gitlab-org/gitlab@89092523957cc6d4e92aa40f89f83dcb46b4c474) ([merge request](gitlab-org/gitlab!80638))
- [Enforce schema validation for security reports](gitlab-org/gitlab@27b25fe8aeeb1c6b8ae602b2d9ec3e1c557cbe1e) ([merge request](gitlab-org/gitlab!82716)) **GitLab Enterprise Edition**
- [Use GraphQL alias to simplify vulnerability list id property](gitlab-org/gitlab@9c4588f2be993f664685777e820f73de4cc9d6d4) ([merge request](gitlab-org/gitlab!83250)) **GitLab Enterprise Edition**
- [Ignore search param for autosave on issue new form](gitlab-org/gitlab@d07ae262dbd9939b73561b513760df55ed783c1a) ([merge request](gitlab-org/gitlab!82568))
- [Remove reliance on Flash styling](gitlab-org/gitlab@87eb822670d8788ff086be9c59a9863cec4abc8e) ([merge request](gitlab-org/gitlab!82501)) **GitLab Enterprise Edition**
- [Add BlocksUnsafeSerialization to Namespace](gitlab-org/gitlab@be35c93a2570805a1aea7e29a9c7677acefc1636) ([merge request](gitlab-org/gitlab!82661))
- [Update mutation to commit security policy to a group](gitlab-org/gitlab@7fb419dc2e7fb9df3bcc481781474825dcdf5295) ([merge request](gitlab-org/gitlab!83188)) **GitLab Enterprise Edition**
- [Increase remote import URL character length limit from 512 to 2048](gitlab-org/gitlab@5bea4f572ecbb6508bb7f55ab4c20ba3ca18c192) ([merge request](gitlab-org/gitlab!80885))
- [Migrate alert to gitlab-ui](gitlab-org/gitlab@50174178b2c1062d03642b841033712879c5aae7) ([merge request](gitlab-org/gitlab!83300))
- [Add empty state for Instance OAuth app page](gitlab-org/gitlab@b2659c6b0f27060e34bf9bfe7b1899eec5cc4623) ([merge request](gitlab-org/gitlab!83279))
- [Prevent encrypted fields from being serialized by default](gitlab-org/gitlab@0890001e31f4d30dccf61a8fa32e503bdda08f33) ([merge request](gitlab-org/gitlab!83272))
- [Added severity to issues REST API](gitlab-org/gitlab@3693c7f1c79ab964baf3105165a8de79448d1aa2) by @stingrayza ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/82696))
- [Don't trigger a sentry error for Gitaly exceptions](gitlab-org/gitlab@c3df27acb4e0f2ec43fb5891f2c24c3d8ce5507c) ([merge request](gitlab-org/gitlab!83084))
- [Add index to improve speed of vulnerability_reads](gitlab-org/gitlab@66dcd5b321d31b28028acbf45f2a266887b3c2c8) ([merge request](gitlab-org/gitlab!82942))
- [Update the runner page alerts](gitlab-org/gitlab@8ac14a90c72f4a44efaf6d2df741a83fc789867f) ([merge request](gitlab-org/gitlab!83238))
- [Alias user_email_lookup_limit to search_rate_limit](gitlab-org/gitlab@a8a6588116279c22c60227e6ae60da914409ac8c) ([merge request](gitlab-org/gitlab!83213))
- [Create about your company page for registration flow](gitlab-org/gitlab@5b141d2456cc991517518f421bb47e4cb8cf0ee0) ([merge request](gitlab-org/gitlab!82529)) **GitLab Enterprise Edition**

### Deprecated (4 changes)

- [Deprecate modifying notes confidentiality on API](gitlab-org/gitlab@a57aa3a34490fac4067188d0db10f257b8fc16a7) ([merge request](gitlab-org/gitlab!83542))
- [Deprecate updating an iteration's attributes via GraphQL](gitlab-org/gitlab@14e438b733002f1d95c3d905da0db340e062a46f) ([merge request](gitlab-org/gitlab!83349)) **GitLab Enterprise Edition**
- [Deprecate manual iteration creation](gitlab-org/gitlab@3e9f9a9c0a2c10469c3f996870f5fff38b3792ee) ([merge request](gitlab-org/gitlab!83046)) **GitLab Enterprise Edition**
- [Deprecate deleting iterations via the GraphQL API](gitlab-org/gitlab@f31acb083196948c8e4c0c7780f28bbf57384f7a) ([merge request](gitlab-org/gitlab!83483)) **GitLab Enterprise Edition**

### Removed (16 changes)

- [Remove the "Upgrade {rocket-emoji}" link from the user dropdown menu](gitlab-org/gitlab@b7102280cd3a68c66acd3fd2098c5491403c8699) ([merge request](gitlab-org/gitlab!84392)) **GitLab Enterprise Edition**
- [Remove runner list in group settings](gitlab-org/gitlab@be34638c4fda55c12064f84c277a9f3d38b8fbae) ([merge request](gitlab-org/gitlab!84165))
- [Remove diff_settings_usage_data flag](gitlab-org/gitlab@f692d00cc965a7af920ba3c9245d32616a2ffd70) ([merge request](gitlab-org/gitlab!84539))
- [Remove bitmap creation housekeeping option](gitlab-org/gitlab@249c5b2833b299940ddfebabb3560ad66b903967) ([merge request](gitlab-org/gitlab!83984))
- [Remove unused MD5 generation logic for InsecureKey](gitlab-org/gitlab@27f9fb1e3c5871b5936e75dcb106a51b7e7796df) ([merge request](gitlab-org/gitlab!84364))
- [Remove users_expanding_widgets_usage_data feature flag](gitlab-org/gitlab@390a966ec1812f5e21fa66013e480007abf89711) ([merge request](gitlab-org/gitlab!84317))
- [Remove mrc_api_use_raw_diffs_from_gitaly flag](gitlab-org/gitlab@4251a0f463b7a5f1999f302a5444e6193e13c136) ([merge request](gitlab-org/gitlab!84327))
- [Remove usage_data_diff_searches feature flag](gitlab-org/gitlab@924b7d24a6088967a07955da3c598bd26220ae98) ([merge request](gitlab-org/gitlab!84320))
- [Remove remove_import_data_on_failure feature flag](gitlab-org/gitlab@9aabd518a811e830c55d54c3d8daf4ec17a33e7d) ([merge request](gitlab-org/gitlab!84040))
- [Removal notice for rerequest review](gitlab-org/gitlab@872934ff6b49ee37070aeadcfc7f77492216b01b) ([merge request](gitlab-org/gitlab!84007))
- [Cleanup api_kaminari_count_with_limit feature flag](gitlab-org/gitlab@4dd097fcb27809f0092d0079434b320c06ca095d) by @jaspreet-3911 ([merge request](gitlab-org/gitlab!81084))
- [Remove invite_team_email experiment code](gitlab-org/gitlab@a9e56a64bcdbdb9761d93f5fc61c71a937c2dd84) ([merge request](gitlab-org/gitlab!82799))
- [Remove new_dir_modal feature flag](gitlab-org/gitlab@692c1767bf4cbc341638f75454a7affadb99477a) ([merge request](gitlab-org/gitlab!83518))
- [Remove feature flag gitaly_backup](gitlab-org/gitlab@13e4026e5e703633583ba7666afc815ad303a447) ([merge request](gitlab-org/gitlab!83254))
- [Remove Balsamiq File Preview](gitlab-org/gitlab@174aeb62a8efaf75a44cf49315e8af647809b464) ([merge request](gitlab-org/gitlab!82924))
- [Revert "Add Sbom Survey Banner"](gitlab-org/gitlab@5874355413c1d91a4fcd5690882eb3e6a3692d21) ([merge request](gitlab-org/gitlab!82068))

### Security (25 changes)

- [Add authorization to composer package archive download](gitlab-org/gitlab@cae37bcd229235f1fb0163200d0a3632b39f64d3) by @trakos ([merge request](gitlab-org/gitlab!77950))
- [Remove ci_safe_artifact_content_type feature flag](gitlab-org/gitlab@03c43e46fec0be78cc8735bf94ac0c56eb634ad3) ([merge request](gitlab-org/gitlab!84457))
- [Fix artifact content-type raw endpoint](gitlab-org/gitlab@1a60a674fecb87b9751a27a8098a0341c5344775) ([merge request](gitlab-org/gitlab!83826))
- [Disallow login if password matches a fixed list](gitlab-org/gitlab@26c7148eb83b6b20fc56da87ea7aa8164bcdf6f8) ([merge request](gitlab-org/gitlab!84094))
- [Upgrade swagger-ui dependency](gitlab-org/gitlab@44dacc8179443ef9268f98ebf25478f30ae435db) ([merge request](gitlab-org/gitlab!84094))
- [Update devise-two-factor to 4.0.2](gitlab-org/gitlab@6b02bf46ec1bc33e76a0ce8e2cbc90466a7a5b49) ([merge request](gitlab-org/gitlab!84094))
- [Fix kroki exploit](gitlab-org/gitlab@4e0fbc6fe4eab95c7a1701b4d7b6a9b99b58866e) ([merge request](gitlab-org/gitlab!84094))
- [GitLab Pages Security Updates for 14.9](gitlab-org/gitlab@0439dfc6ee2732a5dc6ece1252c7317a52bdaed6) ([merge request](gitlab-org/gitlab!84094))
- [Revert "JH need more complex passwords"](gitlab-org/gitlab@8e1715c7ccbf33bcfdc93f4c18ee0ad82db62cad) ([merge request](gitlab-org/gitlab!84094))
- [Escape original content in reference redactor](gitlab-org/gitlab@389be4c9877860af1c05bdb1c42acfc4f3aaaa42) ([merge request](gitlab-org/gitlab!84094))
- [Fix blind SSRF when looking up SSH host keys for mirroring](gitlab-org/gitlab@435dbb25f5c44eb38e3f8a4cc8251477428d4b3d) ([merge request](gitlab-org/gitlab!84094))
- [Hide features a user shouldn't be able to see in a list of forks](gitlab-org/gitlab@0ff446c53c2358cde08f36da2d20090a020b8d77) ([merge request](gitlab-org/gitlab!82639))
- [Modify release link format check to avoid regex if string is too long](gitlab-org/gitlab@2cfab0cbb70050c4901dd3abe765f1e5388eb278) ([merge request](gitlab-org/gitlab!84094))
- [Project import maps members' created_by_id users based on source user ID](gitlab-org/gitlab@51cbabf1f9b8081ad6187970f30d2ce203b9db4c) ([merge request](gitlab-org/gitlab!84094))
- [Monkey patch of RDoc to prevent Ruby segfault](gitlab-org/gitlab@d1f2d3cf3c0ecf08ea2477aea99c98f3ccec14fb) ([merge request](gitlab-org/gitlab!84094))
- [Escape user provided string to prevent XSS](gitlab-org/gitlab@927205e78ebc4a768ac891b8d1b7dc34dbf4770f) ([merge request](gitlab-org/gitlab!84094))
- [Masks variables in error messages](gitlab-org/gitlab@280766e8a515c6ad4289c05ab463b14521660f16) ([merge request](gitlab-org/gitlab!84094))
- [Security fix for CI/CD analytics visibility](gitlab-org/gitlab@22941c3290817717075c00f505e879dc020cbb9f) ([merge request](gitlab-org/gitlab!84094))
- [Limit the number of tags associated with a CI runner](gitlab-org/gitlab@e226dc55ef11e4edca66dfda17959940c3c3947c) ([merge request](gitlab-org/gitlab!84094))
- [Latest commit exposed through fork of a private project](gitlab-org/gitlab@d4a675cd32528883fb12ccdfc25411114596279b) ([merge request](gitlab-org/gitlab!84094))
- [Redact InvalidURIError error messages](gitlab-org/gitlab@b6ec483a90b1a285cc66327c22655ed051ac0e8d) ([merge request](gitlab-org/gitlab!84094))
- [Fix access for approval rules API](gitlab-org/gitlab@15854f37f5c5606bc5a319b9c8d4b59c804f89cc) ([merge request](gitlab-org/gitlab!84094))
- [Fix Asana integration restricted branch filter](gitlab-org/gitlab@263c695a01612d1c13c5d67bbbf38b9ed4e3a145) ([merge request](gitlab-org/gitlab!84094))
- [Add state param validation for Bitbucket OAuth flow](gitlab-org/gitlab@7f5d12da48f4a899b77cc29bf8b5575c49283cf6) ([merge request](gitlab-org/gitlab!83598))
- [Fix artifacts content-type](gitlab-org/gitlab@e2e17fe6c668b9e781eb849a4fc4a52374855e43) ([merge request](gitlab-org/gitlab!83515))

### Performance (19 changes)

- [Optimise Security::Finding cleanup by clearing build_id scope](gitlab-org/gitlab@88c71e08b4d276abe8d840d739ee1047961ec8c6) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/84283)) **GitLab Enterprise Edition**
- [Drop trace-inclusive artifact removal index from ci_job_artifacts](gitlab-org/gitlab@84a57dc965d20124050277977b9ce5227491edb8) ([merge request](gitlab-org/gitlab!84308))
- [Make `User#ci_owned_runners` to use unnest index instead of GIN](gitlab-org/gitlab@7304cf06fdccdd17a3e783bf92f5fec670ec2ffc) ([merge request](gitlab-org/gitlab!83843))
- [Fix remaining N+1 queries in EnvironmentSerializer](gitlab-org/gitlab@db4fca18304584a630ac4200538c1f7fff6035df) ([merge request](gitlab-org/gitlab!82746))
- [Remove ci_artifact_fast_removal_large_loop_limit feature flag](gitlab-org/gitlab@ee473019798a0f7107e269f9a0f7da1bfcd7717d) ([merge request](gitlab-org/gitlab!84516))
- [Finalize asynchronously built index](gitlab-org/gitlab@7a3087a5d1855552edeee288b3e26f8e12a57812) ([merge request](gitlab-org/gitlab!83668))
- [Resolve "ActionView::Template::Error: 4:Deadline Exceeded."](gitlab-org/gitlab@8469644af62c812160505910651dc07e236e62d6) ([merge request](gitlab-org/gitlab!84269))
- [Optimize the query on Environment Detail page](gitlab-org/gitlab@dac25abdbf3db0a58e95d7f247fb8ff36b57431e) ([merge request](gitlab-org/gitlab!83498))
- [Improve query performance of attention requests count](gitlab-org/gitlab@14f1a3aadfab9823c6edfd2857c6637e350c56db) ([merge request](gitlab-org/gitlab!84140))
- [Fix discussions N+1 queries](gitlab-org/gitlab@3eed8ffc449bc9044d986bf69af05777dd2e242a) ([merge request](gitlab-org/gitlab!83544))
- [Optimize User#ci_owned_runners query V3](gitlab-org/gitlab@e4efeb7eb87ca0b85a6d53ab3d8aa599961b46dc) ([merge request](gitlab-org/gitlab!82692))
- [Do not include highlighted_diff_email css for each note](gitlab-org/gitlab@0e8275a74c175e532ef8254b30e01a1f68e16825) ([merge request](gitlab-org/gitlab!83385))
- [Schedule async index build for ci_job_artifacts](gitlab-org/gitlab@c29adfe7b51f4b6324b72a5abe678fcb8a459a03) ([merge request](gitlab-org/gitlab!83664))
- [Registry import enqueuer uses migration_plan](gitlab-org/gitlab@85305dd5e6cd2fa419c94c7d0d2cabb673b134bf) ([merge request](gitlab-org/gitlab!83365)) **GitLab Enterprise Edition**
- [Prevent loading wiki content for destroy and diff actions](gitlab-org/gitlab@b78a24824d07d0e030a36ca36c039918e0460581) ([merge request](gitlab-org/gitlab!83595))
- [Make the Invite Modal load conditionally](gitlab-org/gitlab@72b8bb6cf685b356d58352b0abd489c17d27c4ae) ([merge request](gitlab-org/gitlab!83128))
- [Load highlight.js languages asynchronously](gitlab-org/gitlab@780039e921881ba86c122732714bd6a51830a9e4) ([merge request](gitlab-org/gitlab!83193))
- [Move updating statistics logic outside of the transaction](gitlab-org/gitlab@09422ff6eed738c365058a4fcd68b6cf5ef28f94) ([merge request](gitlab-org/gitlab!83018)) **GitLab Enterprise Edition**
- [Caches the by email lookup logic for user in member creation](gitlab-org/gitlab@a1e8d2bfb20ac4db3dc575cbedb02acee5c65c4f) ([merge request](gitlab-org/gitlab!82196))

### Other (66 changes)

- [Finalize traversal_ids background migrations](gitlab-org/gitlab@1fd26b1bf86d900885ca3e255b7221d184583a21) ([merge request](gitlab-org/gitlab!65510))
- [Add tests for vulnerability_report.vue](gitlab-org/gitlab@e80ee6d1d31d003238134484418fc7abd2f6fbcd) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/85293)) **GitLab Enterprise Edition**
- [Use StatisticsCard in usage_quotas/seats](gitlab-org/gitlab@d7e1c5e0bb8175c85dab8b7ec2799f2908105921) ([merge request](gitlab-org/gitlab!82399)) **GitLab Enterprise Edition**
- [Add new packages build infos finder](gitlab-org/gitlab@246709ea3a7dece310de55e7d8fad4fd755a4ca3) ([merge request](gitlab-org/gitlab!85073))
- [Fix usage of distance_of_time_in_words_to_now](gitlab-org/gitlab@3a7078a53094d11599d5d0efc2ecbe8adacafe95) by @edith007 ([merge request](gitlab-org/gitlab!81180))
- [Add unique index for work item type names with no namespace](gitlab-org/gitlab@7b5d932c35b654fee084b73ff44885188f9d34d8) ([merge request](gitlab-org/gitlab!84787))
- [Fix Style/OpenStructUse offenses](gitlab-org/gitlab@ce54ba05584a426e1e452b61cbccd1a7dc885f08) by @edith007 ([merge request](gitlab-org/gitlab!75238))
- [Fix Style/OpenStructUse offenses by using `Struct`](gitlab-org/gitlab@c45a1f067fad0d6f14559d1391c6bf3c4b61c316) by @edith007 ([merge request](gitlab-org/gitlab!75993))
- [Refactor pipeline schedule variables](gitlab-org/gitlab@634bb8201df849c360be994468715cd3f325fb28) ([merge request](gitlab-org/gitlab!81127))
- [Bump Gitlab Shell version](gitlab-org/gitlab@41c003be8476d374473731439cf7a5412735f6a5) ([merge request](gitlab-org/gitlab!84558))
- [Refactor: Introduce BaseThirdPartyWiki](gitlab-org/gitlab@ffc0924b34a4f453708027ab18605d9790b87e2b) by @chaomao ([merge request](gitlab-org/gitlab!82616))
- [Update RelationExportService to not export if recently exported](gitlab-org/gitlab@662e1bd7669e314967c28df366b04060d38842dd) ([merge request](gitlab-org/gitlab!84207))
- [Makes BackfillWorkItemTypeIdOnIssues migration more efficient](gitlab-org/gitlab@10ba7bc36d434eed29e3e1f0c64145b170edd5b0) ([merge request](gitlab-org/gitlab!84213))
- [Backfill dependency proxy size in namespace stats](gitlab-org/gitlab@e5289bec580113e641f1e814e754e08f8c26fbd3) ([merge request](gitlab-org/gitlab!79937))
- [Use statistics card in storage app](gitlab-org/gitlab@7f3519b362e5ac5234ddd070c1715a53d5fc1286) ([merge request](gitlab-org/gitlab!79525)) **GitLab Enterprise Edition**
- [Set usage_activity_by_stage_monthly.create.merge_requests to removed](gitlab-org/gitlab@f54906e6635232eabddc678372cf51d190f99fd6) ([merge request](gitlab-org/gitlab!83940))
- [Remove obsolete wiki notes](gitlab-org/gitlab@db2aab7a110da617b11e69ba86562c6007da8574) ([merge request](gitlab-org/gitlab!83391))
- [Chore: remove track_editor_edit_actions FF](gitlab-org/gitlab@a1c1020e8c0d2b8a882dffb0cdcf22d1537515f2) ([merge request](gitlab-org/gitlab!84223))
- [Removes ci_validate_job_length ff](gitlab-org/gitlab@a111c80f5121e4dc3fae234618c08d4eeeb7c009) ([merge request](gitlab-org/gitlab!83320))
- [Update BulkImports::PipelineWorker Ndjson perform delay](gitlab-org/gitlab@38515dcd7314ac3c7f5ebcdbc03e5625b76f5bd2) ([merge request](gitlab-org/gitlab!84285))
- [Remove import_project_from_remote_file ff](gitlab-org/gitlab@8344d215a8383600ba6f80debcc009475bbbc94d) ([merge request](gitlab-org/gitlab!84266))
- [Add temp index for notes without discussion_id](gitlab-org/gitlab@61ec9cd98492180d45ae8dbddcbf1b5bb90df469) ([merge request](gitlab-org/gitlab!84038))
- [Document how to add a new built-in project template](gitlab-org/gitlab@e3fc3ef5002679f037f1e27a3293c4ee1d3e92a2) ([merge request](gitlab-org/gitlab!71472))
- [Fix Style/OpenStructUse offenses](gitlab-org/gitlab@d8f5e12ae7e84e7a32b9f8304028708947609ccd) by @edith007 ([merge request](gitlab-org/gitlab!75996))
- [Geo: (SSF) State machine refactoring](gitlab-org/gitlab@d7025c1337abde970bb67a45170d237a08e94bb6) ([merge request](gitlab-org/gitlab!83553))
- [Run project after import when GitLab Migration is complete](gitlab-org/gitlab@7dfc57dff7bedca79d1bf1b010af8daaa7aa841e) ([merge request](gitlab-org/gitlab!83966))
- [Fix Style/OpenStructUse offenses](gitlab-org/gitlab@e940bac6be96a2d0e42af80ffaf61b37aac4afbf) by @edith007 ([merge request](gitlab-org/gitlab!75217))
- [When building from source, require nodeJS >= 14.15.0](gitlab-org/gitlab@321fc6c4c7ae7bc831aa31241d78486ba7d8290b) ([merge request](gitlab-org/gitlab!83947))
- [Remove switch editing controls feature flag](gitlab-org/gitlab@716a98ca735534ff6ca1df2485e92bd12856d43b) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/83760))
- [Simplify third party container repository delete tags services](gitlab-org/gitlab@a743b1c73ad3ed875f4e17d16f4cee32251c8d9a) by @edith007 ([merge request](gitlab-org/gitlab!81184))
- [Remove the unused instance variable from the controller](gitlab-org/gitlab@cca4c9e8f68bfab401b9bf892c442c4f0b22d534) by @edith007 ([merge request](gitlab-org/gitlab!81193))
- [Expose HTTP code during GitHub importer errors](gitlab-org/gitlab@463c8c6645bd008f500f397b14cd6ab499ab1813) ([merge request](gitlab-org/gitlab!83818))
- [Workhorse: bump gitaly client](gitlab-org/gitlab@8ac124dbc878b24a2660a81926c83f9871d33782) ([merge request](gitlab-org/gitlab!83858))
- [Bump Gitlab Shell version](gitlab-org/gitlab@d10d31550507c0f3430c8d37ffb367f406f45314) ([merge request](gitlab-org/gitlab!83860))
- [Remove header_read_timeout_buffered_io featureflag](gitlab-org/gitlab@8cda0d0765df9f4ff4b7f9e41ee6838cb344d2cd) ([merge request](gitlab-org/gitlab!83729))
- [Move compliance framework auditor to a new class](gitlab-org/gitlab@7871542d2751598ae7fc828e01210122d875038d) ([merge request](gitlab-org/gitlab!82589)) **GitLab Enterprise Edition**
- [Cleanup secret variables refactoring in variables builder](gitlab-org/gitlab@b668969cb9de120691e49116b64b18fc95795cb8) ([merge request](gitlab-org/gitlab!83428))
- [Resolve Performance/DeletePrefix rubocop offenses](gitlab-org/gitlab@6d0654f3779954412d02e7a8fdde88ab0f17f533) by @edith007 ([merge request](gitlab-org/gitlab!81331)) **GitLab Enterprise Edition**
- [Fix typo in milestones empty state](gitlab-org/gitlab@cd5a099d9f2051bc0405a3fc25ea76ceef66dacb) ([merge request](gitlab-org/gitlab!83736))
- [Added read_usage_quotas ability to ProjectPolicy](gitlab-org/gitlab@efcc97cc4dc87024770df40f5f1931a9727348e6) ([merge request](gitlab-org/gitlab!82396))
- [Update API doc to show correct return type](gitlab-org/gitlab@a7b8941fef5cbc4b783962bf083f7b0297eae37e) ([merge request](gitlab-org/gitlab!81895)) **GitLab Enterprise Edition**
- [Clean up after fixing issue when admin changes email](gitlab-org/gitlab@8ab267b902183ace0255b4b95de1c08c5a08720b) ([merge request](gitlab-org/gitlab!83185))
- [Remove use_model_load_balancing feature flag](gitlab-org/gitlab@d99860de6486c2c0fbcede1f990cf7930ba47b88) ([merge request](gitlab-org/gitlab!83162))
- [Lazy initialization for user popovers](gitlab-org/gitlab@12ac522714e0f3fb8d17fdbff96f17e3bb294e72) by @cyberap ([merge request](gitlab-org/gitlab!80597))
- [Migrate groups show page to GlTabs](gitlab-org/gitlab@b61591c64c6525d3951cc6704af271bd2e541619) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/81253))
- [Track related epics added on usage ping](gitlab-org/gitlab@113fa62f433dc616cbfb95fca2f6e0a7963aac22) ([merge request](gitlab-org/gitlab!83323)) **GitLab Enterprise Edition**
- [Remove `verify_protected_tags_for_pull_mirror` feature flag](gitlab-org/gitlab@96c5583f5092e2af45401195e48565f49516f375) ([merge request](gitlab-org/gitlab!83610))
- [Remove feature flag `spread_parallel_import`](gitlab-org/gitlab@1f8097114e5e52e3fa1c24c6ee65c4b04eb30258) ([merge request](gitlab-org/gitlab!83608))
- [Resolve Rails/FindById rubocop offenses](gitlab-org/gitlab@dadd2772a5efca5bff9afedf2c85a9f54ba1faf9) by @edith007 ([merge request](gitlab-org/gitlab!81390)) **GitLab Enterprise Edition**
- [Remove admin_application_settings_service_usage_data_center feature flag](gitlab-org/gitlab@ef597de6ad4563d998db669bc10fc9373e6ec190) ([merge request](gitlab-org/gitlab!83265))
- [Cleanup draft column data](gitlab-org/gitlab@d1cdd34b46466c12adc7438d55d2977a3b6d422e) ([merge request](gitlab-org/gitlab!70735))
- [Resolve Rails/BelongsTo rubocop offenses](gitlab-org/gitlab@1c1c64c05a9e95c0a389f29637b840d2673e049a) by @edith007 ([merge request](gitlab-org/gitlab!81382))
- [Remove bulk_expire_project_artifacts feature flag](gitlab-org/gitlab@1b1d0c86fc8a26b8198e32fd4bda14f5aa142242) ([merge request](gitlab-org/gitlab!83509))
- [Backfill work_item_type_id for all Issues](gitlab-org/gitlab@1e07844446d3f929e328ad46b072273c2ab84543) ([merge request](gitlab-org/gitlab!71869))
- [Remove geo_token_user_authentication feature flag](gitlab-org/gitlab@bed4933195326953d6bcd184ab8dfc9fa24aba1f) ([merge request](gitlab-org/gitlab!83405)) **GitLab Enterprise Edition**
- [Modeling for Multi Access Levels in Deployment Approval](gitlab-org/gitlab@61b1b9ea1b5337615f5d0e2a85084964283570f3) ([merge request](gitlab-org/gitlab!82800))
- [Update GitLab Runner Helm Chart to 0.39.0](gitlab-org/gitlab@6b2b27f483efe847a9e5d1dfeebf166a87410e4f) ([merge request](gitlab-org/gitlab!83332))
- [Cleanup show_report_validation_warnings flag](gitlab-org/gitlab@f2ced7432c2165833e12fafc9bc94b379dac0b21) ([merge request](gitlab-org/gitlab!82405))
- [Add tests for vulnerability report pagination feature](gitlab-org/gitlab@7618a30c43034342b1adb827c33a121f69238370) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/83098)) **GitLab Enterprise Edition**
- [Remove temp index on id in vulnerability_occurrences](gitlab-org/gitlab@4fb3577be045d4a66aafc46b8f6e9da33115f9a4) ([merge request](gitlab-org/gitlab!78698))
- [Fix the offences introduced by Performance/OpenStruct](gitlab-org/gitlab@eebf72d8c64f0042b5413baa9653f52d799acd99) by @edith007 ([merge request](gitlab-org/gitlab!70902))
- [Move BASE_FILTERS from filters/constants to security_dashboard/helpers](gitlab-org/gitlab@d820d64536c94227d3e2c11a4877c27c27ba795d) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/83240)) **GitLab Enterprise Edition**
- [Add migration_plan to container_repositories](gitlab-org/gitlab@614fca0b0c476660c89d1199af4cb56ec78c0127) ([merge request](gitlab-org/gitlab!83061))
- [Bump Gitlab Shell version](gitlab-org/gitlab@953e2fe05ac2d11bccfbc0eb61ff0b50c91e7e9a) ([merge request](gitlab-org/gitlab!83203))
- [Convert ci_builds-runner_id FK to LFK](gitlab-org/gitlab@5e114952616994acb802e5ded373fc07e53a3aaa) ([merge request](gitlab-org/gitlab!83129))
- [Fix related epic links and issue links specs fixtures](gitlab-org/gitlab@ffc7df0cdbdda91fec15d2c4437e64dd7d073d50) ([merge request](gitlab-org/gitlab!82623))

## 14.9.5 (2022-06-01)

### Security (7 changes)

- [Fix IP restrictions not applying to deploy tokens](gitlab-org/security/gitlab@b429997e253110ea5eb4d20a8b90e9879be97300) ([merge request](gitlab-org/security/gitlab!2472))
- [Trigger token should respect group IP restrictions](gitlab-org/security/gitlab@326993794bba8659208cde212433a5a19fd3e5a9) ([merge request](gitlab-org/security/gitlab!2477))
- [Fix content injection in Jira issue title](gitlab-org/security/gitlab@c968f7be35d829bfefbf089794343d2d20cdd078) ([merge request](gitlab-org/security/gitlab!2465))
- [Subgroup member can list members of parent group](gitlab-org/security/gitlab@1606689819eeae574bd5d65c8c971c2d4eb19e41) ([merge request](gitlab-org/security/gitlab!2481))
- [Do not allow project member import when membership is locked](gitlab-org/security/gitlab@e8324068c61c4c58d50646d4fa8dff77c4d147ae) ([merge request](gitlab-org/security/gitlab!2448))
- [Disable changing user attributes when updating SCIM provisioned user](gitlab-org/security/gitlab@9d5aca002edb2e0ab3c7d5b6eb00ea781d3dde9f) ([merge request](gitlab-org/security/gitlab!2455))
- [Allow only job owner to run interactive terminal](gitlab-org/security/gitlab@c9fe31e3a963c421db3d9c47c65dd98a2867a699) ([merge request](gitlab-org/security/gitlab!2434))

## 14.9.4 (2022-04-29)

### Security (15 changes)

- [Fixes infinite loop when rendering Ipynb Diffs](gitlab-org/security/gitlab@9836b8e3873e1390e1f6746a1039749c312739b5) ([merge request](gitlab-org/security/gitlab!2401))
- [Update Import/Export merge/push access levels & exclude ci config path](gitlab-org/security/gitlab@8a27e1e56e965d6b69545a2efb4f55f20cc57b2e) ([merge request](gitlab-org/security/gitlab!2371))
- [Prevent maintainers from editing PipelineSchedule](gitlab-org/security/gitlab@ee86557a26d0c3f8a983a6f20384f6b778d4ab0b) ([merge request](gitlab-org/security/gitlab!2422))
- [Add validation to pypi file sha256 values](gitlab-org/security/gitlab@7f78a6b9060745d9fea7f7dc71d4cf090b8e9ab5) ([merge request](gitlab-org/security/gitlab!2416))
- [Conan Token uses PAT rather than ID in payload](gitlab-org/security/gitlab@574b7397e4b32630276cf1e5896ad4a72e82f02b) ([merge request](gitlab-org/security/gitlab!2345))
- [[security] Fix markdown API disclosing issue titles of limited projects](gitlab-org/security/gitlab@ff61b763d040ece83387eb7c0f70d0d97aafbd66) ([merge request](gitlab-org/security/gitlab!2406))
- [Verify that mentioned user can read TODO's note](gitlab-org/security/gitlab@7771534e395f9f433cafa9984cbeeebf86a2d797) ([merge request](gitlab-org/security/gitlab!2396))
- [Invalidate markdown cache to clear up stored XSS](gitlab-org/security/gitlab@0768d53609d530bee4ef118a929bdd7ac6cbd5de) ([merge request](gitlab-org/security/gitlab!2419))
- [Allow rate limiting of deploy tokens](gitlab-org/security/gitlab@8738e74dbecece0e0fcdaf5df1323437db77b947) ([merge request](gitlab-org/security/gitlab!2384))
- [Add suffix to cache name to add isolation](gitlab-org/security/gitlab@d722e72125ded23ea4fd0eeeb775576f7cdd7181) ([merge request](gitlab-org/security/gitlab!2374))
- [Disable wiki access with CI_JOB_TOKEN when improper access level](gitlab-org/security/gitlab@13524db78a32d13e4081a30cc0db9215c404b435) ([merge request](gitlab-org/security/gitlab!2390))
- [Sanitize error input to prevent HTML/CSS injection in messages](gitlab-org/security/gitlab@a83683c13f7a0a8af94a88562f5904bfcb1b58e0) ([merge request](gitlab-org/security/gitlab!2377))
- [Secure debug trace artifact download](gitlab-org/security/gitlab@811ce49adeddb56de0a1ca26652017197fe1b97a) ([merge request](gitlab-org/security/gitlab!2366))
- [Use password type for all secret integration properties](gitlab-org/security/gitlab@f38cec8b26fa0e33da9247af9e8c53c01e6ec0c6) ([merge request](gitlab-org/security/gitlab!2410))
- [Limit CI job group_name regexp](gitlab-org/security/gitlab@5a08c0b9dff4518dff91990eecae0ab76c5cf4ed) ([merge request](gitlab-org/security/gitlab!2380))

## 14.9.3 (2022-04-12)

### Fixed (4 changes)

- [Revert Protected Environment group access inheritence](gitlab-org/gitlab@488fd8f3f6770eebae10c815398534ff41d57546) ([merge request](gitlab-org/gitlab!84664))
- [Fix URL blocker when object storage enabled but type is disabled](gitlab-org/gitlab@d0da89768774de9cf635af530ed7386e65f92d40) ([merge request](gitlab-org/gitlab!84664))
- [Remove pending builds from the queue on conflict](gitlab-org/gitlab@8c88898dfd1619cc635ce5b98e30eebd91da497f) ([merge request](gitlab-org/gitlab!84664))
- [Fix null argument handling in background migration Rake task](gitlab-org/gitlab@23e1eb3272828b3546e18efdfaea5a8077cb20f4) ([merge request](gitlab-org/gitlab!84664))

## 14.9.2 (2022-03-31)

### Security (20 changes)

- [Quarantine UsageDataNonSqlMetrics failing test](gitlab-org/security/gitlab@123fc00ff9f407284ce05007ddc373e1bd0aeede) ([merge request](gitlab-org/security/gitlab!2364))
- [Disallow login if password matches a fixed list](gitlab-org/security/gitlab@1a128ae3fb17b3d83974bb08034e4ba7a7d54e3b) ([merge request](gitlab-org/security/gitlab!2357))
- [Update devise-two-factor to 4.0.2](gitlab-org/security/gitlab@17c70b13dcd437c05de63b3286245af8e6f42210) ([merge request](gitlab-org/security/gitlab!2349))
- [Limit the number of tags associated with a CI runner](gitlab-org/security/gitlab@ed5daced882a0206e050c4f676a888ac1c2417b1) ([merge request](gitlab-org/security/gitlab!2303))
- [GitLab Pages Security Updates for 14.9](gitlab-org/security/gitlab@79709cabf71a57a336f490636a7e32a208fe0229) ([merge request](gitlab-org/security/gitlab!2327))
- [Upgrade swagger-ui dependency](gitlab-org/security/gitlab@14280c1d844be3ffc2f30f5321a818a7b6c51770) ([merge request](gitlab-org/security/gitlab!2336))
- [Modify release link format check to avoid regex if string is too long](gitlab-org/security/gitlab@f516d883b46e1441410476dc140d69fde51cdf0f) ([merge request](gitlab-org/security/gitlab!2307))
- [Masks variables in error messages](gitlab-org/security/gitlab@9cf62118390c0cfba3d36a4231a30a7836f06e2f) ([merge request](gitlab-org/security/gitlab!2308))
- [Escape user provided string to prevent XSS](gitlab-org/security/gitlab@2da3502aef64ed1b01c13d82418950cf284098c6) ([merge request](gitlab-org/security/gitlab!2313))
- [Monkey patch of RDoc to prevent Ruby segfault](gitlab-org/security/gitlab@0ae4925089a1b5fd7c9abeeb0756b3a50e05799a) ([merge request](gitlab-org/security/gitlab!2321))
- [Project import maps members' created_by_id users based on source user ID](gitlab-org/security/gitlab@3826f2a7c652d3f74e45bfef8888601ca1c86ba1) ([merge request](gitlab-org/security/gitlab!2301))
- [Redact InvalidURIError error messages](gitlab-org/security/gitlab@59b60e9cf8f79d6f41000d34a4434c5a04988030) ([merge request](gitlab-org/security/gitlab!2295))
- [Fix access for approval rules API](gitlab-org/security/gitlab@7890215aa29624cd67c5bc8ac25175f2866479b7) ([merge request](gitlab-org/security/gitlab!2322))
- [Fix kroki exploit](gitlab-org/security/gitlab@b2a44b407ab85ca056a271ba4e708128ef08d25f) ([merge request](gitlab-org/security/gitlab!2306))
- [Fix blind SSRF when looking up SSH host keys for mirroring](gitlab-org/security/gitlab@5a9509b52584302c508bd6dff1454f80aae371ea) ([merge request](gitlab-org/security/gitlab!2309))
- [Escape original content in reference redactor](gitlab-org/security/gitlab@b33b170a2c2df8285999f3631e8a53d35e0eed22) ([merge request](gitlab-org/security/gitlab!2317))
- [Security fix for CI/CD analytics visibility](gitlab-org/security/gitlab@f3febd00b440475b2aca0b9bd6728fa5f8750288) ([merge request](gitlab-org/security/gitlab!2304))
- [Latest commit exposed through fork of a private project](gitlab-org/security/gitlab@3f20d4f294a12ceb33bec19d86790f582fb7fb48) ([merge request](gitlab-org/security/gitlab!2294))
- [Fix Asana integration restricted branch filter](gitlab-org/security/gitlab@08aa0f55b1b715f7311ee6502cd6f8a1b875f878) ([merge request](gitlab-org/security/gitlab!2300))
- [Revert "JH need more complex passwords"](gitlab-org/security/gitlab@e2fb87ec5d4e235d6b83454980cec9c049849a1c) ([merge request](gitlab-org/security/gitlab!2352))

## 14.9.1 (2022-03-23)

### Fixed (1 change)

- [Fix backups not working when feature_flags table does not exist](gitlab-org/gitlab@4cc3cd6cf6eb256a9837ef92a6fdb4991cd1642c) ([merge request](gitlab-org/gitlab!83388))

### Changed (1 change)

- [Alias user_email_lookup_limit to search_rate_limit](gitlab-org/gitlab@424c277fc4c994df60ea68acb8988537526108e4) ([merge request](gitlab-org/gitlab!83388))

## 14.9.0 (2022-03-21)

### Added (119 changes)

- [Toggle the related_epics_widge feature flag](gitlab-org/gitlab@8f64bbbc5c485fcdb7453f3c42949a37e030a71f) ([merge request](gitlab-org/gitlab!82333)) **GitLab Enterprise Edition**
- [Add Time to Restore Service DORA metric](gitlab-org/gitlab@0ccf5b4ae6bca2fa1ea128228e14bb63153283ce) ([merge request](gitlab-org/gitlab!82510)) **GitLab Enterprise Edition**
- [Added possiblity to create new token from the UI](gitlab-org/gitlab@8f36ef50c87ea78e33409c3ddcbbb04782fa5e15) ([merge request](gitlab-org/gitlab!82690))
- [Add param to Wiki REST endpoint to retrieve different page versions](gitlab-org/gitlab@53b8b9fe4952d7c11a80cd52f4dab8e6d8bfa7de) ([merge request](gitlab-org/gitlab!82838))
- [Add Harbor integration](gitlab-org/gitlab@bcb79d53fd54e545cf80416beb77360e06262c22) by @prajnamas ([merge request](gitlab-org/gitlab!80999))
- [MR widget: update merge commit message when default changed](gitlab-org/gitlab@b005b8e80ba8691ec24a5063e4a133d21e56532e) by @trakos ([merge request](gitlab-org/gitlab!77425))
- [Support agent registration without config](gitlab-org/gitlab@388f87faad5adf5c68ba4850a82b1d4433290b0f) ([merge request](gitlab-org/gitlab!82036))
- [Add `RestrictGitlabSchema` that enforces `restrict_gitlab_migration`](gitlab-org/gitlab@6bdac41133bebcf66c308dc31f589046b1dc0725) ([merge request](gitlab-org/gitlab!73756))
- [Enable the vsa_incremental_worker FF by default](gitlab-org/gitlab@d04a006d125f94b34c7eef4f6b85a37292bc7500) ([merge request](gitlab-org/gitlab!82975))
- [Add deployment approval comment field](gitlab-org/gitlab@5dfb9cabb2d2aee7eff447e34021c8b7ca24eed4) ([merge request](gitlab-org/gitlab!82743)) **GitLab Enterprise Edition**
- [Support iteration property for issues api](gitlab-org/gitlab@406a79a51c6dc35cd8207a7426a8582cd20ecfc4) ([merge request](gitlab-org/gitlab!82813)) **GitLab Enterprise Edition**
- [Filter archived issues / MRs from GraphQL](gitlab-org/gitlab@a7fde3da984bc52b887203fa57998c93f9c6fc5f) ([merge request](gitlab-org/gitlab!82673))
- [Purge `security_findings` records periodically](gitlab-org/gitlab@9cee0b65a405f4510fd5a77c2dcdcaf4ad95e003) ([merge request](gitlab-org/gitlab!81423)) **GitLab Enterprise Edition**
- [Upgrade GitLab Pages to 1.56.0](gitlab-org/gitlab@891adfa4d15e31f0d6087a6d22644cb9a06fe3e2) ([merge request](gitlab-org/gitlab!82901))
- [Stream audit event on merge request approval](gitlab-org/gitlab@39d59e2adbb92572ef077918773a9110d7924e1a) ([merge request](gitlab-org/gitlab!82471)) **GitLab Enterprise Edition**
- [Use batches for pull request import jobs](gitlab-org/gitlab@b5507c4df013a527266cb0e7914a1d525e2f30eb) ([merge request](gitlab-org/gitlab!82891))
- [Verify protected tags permissions for pull mirroring](gitlab-org/gitlab@b96fe042b134448a40e6be71dc438d74133920aa) ([merge request](gitlab-org/gitlab!82890))
- [Document how to use CI `dependencies` and `parallel:matrix` together](gitlab-org/gitlab@681db1577821d9ed4612d2d060a3413aa4ea883b) ([merge request](gitlab-org/gitlab!82734))
- [Add security training urls](gitlab-org/gitlab@942e93418c6aae0f85afd991e4cbc7a659521fba) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/82442)) **GitLab Enterprise Edition**
- [Add `Enterprise` filter to members search bar](gitlab-org/gitlab@4f1b22da7fdeecd89130954a268ba8cae585f317) ([merge request](gitlab-org/gitlab!82059)) **GitLab Enterprise Edition**
- [Add VulnerabilityReadsFinder to speed up API responses](gitlab-org/gitlab@cf39e3350372fb806e6528a63a7ec7898c83049b) ([merge request](gitlab-org/gitlab!76220)) **GitLab Enterprise Edition**
- [Copy metric images from alert to new incident](gitlab-org/gitlab@5f62b91fa1eb6e4ba593f46bdc8caf34eecc9c76) ([merge request](gitlab-org/gitlab!79703)) **GitLab Enterprise Edition**
- [Expose UserInteractions for participants of a merge request](gitlab-org/gitlab@c0bcfde737e0e3a4c39f36234157e8103ef86cca) ([merge request](gitlab-org/gitlab!82257))
- [Remove wiki_front_matter FF](gitlab-org/gitlab@8045da7944102e54bb172a5ef3c5a8088459c360) ([merge request](gitlab-org/gitlab!81833))
- [Add default branch to Pipelines page filter if no search term provided](gitlab-org/gitlab@039b1145c3e477899681aeba7a27600cad9d45d5) ([merge request](gitlab-org/gitlab!82245))
- [Creates asynchronously index on ci_job_artifacts table](gitlab-org/gitlab@88112e32fff550f742e334bc5c19c4cbc947800e) ([merge request](gitlab-org/gitlab!82585))
- [GraphQL: Add notificationEmail to GroupMembers](gitlab-org/gitlab@0068380ce0105d50afb5fa419d9c90478f3132a9) ([merge request](gitlab-org/gitlab!81954))
- [Add external status checks total to ping](gitlab-org/gitlab@0f9770573a9aba52ab3ba94c09315a5f498728f3) ([merge request](gitlab-org/gitlab!82416)) **GitLab Enterprise Edition**
- [Add CAPTCHA to REST API](gitlab-org/gitlab@dc9fb467df0c59c9632525e8753aab12a8d91457) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/80793))
- [Implement GET APIs for Deploy Tokens](gitlab-org/gitlab@fd6c86aa82c162720cca29c12ac8e33d55a5f8c0) by @tuxtimo ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/82467))
- [Add namespace to Security Policy Orchestration Configuration](gitlab-org/gitlab@b77aefa62c7aac43d50d29de3adeb227760615ae) ([merge request](gitlab-org/gitlab!82013)) **GitLab Enterprise Edition**
- [Add deployment approval UI MVC](gitlab-org/gitlab@d39dff988a3efa1a082afe0ebec5be6bf6fd4939) ([merge request](gitlab-org/gitlab!80759)) **GitLab Enterprise Edition**
- [Add support for failure status status checks](gitlab-org/gitlab@37bc22744f7ecc3b6b8c3cee74ad7e45aea04b58) ([merge request](gitlab-org/gitlab!81005)) **GitLab Enterprise Edition**
- [Allow to list related epics on REST API](gitlab-org/gitlab@92d9f4329badbcc7f7db24184ae63db0d756e172) ([merge request](gitlab-org/gitlab!82332)) **GitLab Enterprise Edition**
- [Add `coverage_report` keyword to CI config](gitlab-org/gitlab@eae7dfc843783e270607d71c6db0c1ab6a52a8d1) ([merge request](gitlab-org/gitlab!81378))
- [Add audit logs when unassigning CI runner from a project](gitlab-org/gitlab@25f9eb27389dcec34f8b1b2b2003eee6c15b07d9) ([merge request](gitlab-org/gitlab!81540)) **GitLab Enterprise Edition**
- [Permalink to the latest release](gitlab-org/gitlab@4305f93ea5ba859bf4154d70dcdc83632deef2a8) ([merge request](gitlab-org/gitlab!78679))
- [Allow the /merge quick action through graphql create note](gitlab-org/gitlab@a201e850fee679ad2bc28858daf00755f87cef5a) ([merge request](gitlab-org/gitlab!82248))
- [Add projects with status checks to ping](gitlab-org/gitlab@d16eca98fa26b3bb065a2a2154b2249d41860fd8) ([merge request](gitlab-org/gitlab!82427)) **GitLab Enterprise Edition**
- [Add security training providers](gitlab-org/gitlab@562d3ab8e8cbbcc3dd2688727030052011d1954d) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/81104))
- [Add OpenSSL FIPS mode detection and env var](gitlab-org/gitlab@f3172799557172ca414cb17459e629e59e2e069c) ([merge request](gitlab-org/gitlab!82004))
- [Support Vault EE namespaces](gitlab-org/gitlab@86894deb6653ddd44111401b63107f4df7f0195a) by @aleksanderzak ([merge request](gitlab-org/gitlab!80590))
- [Add free user cap feature flag and controls](gitlab-org/gitlab@7b7114d8870dccfb74163162c3757c51da1a4df5) ([merge request](gitlab-org/gitlab!80518)) **GitLab Enterprise Edition**
- [Add support stackprof in GitLab profiler](gitlab-org/gitlab@4c42d3ac32dc3cde4b485952e4fca03de86d20a5) ([merge request](gitlab-org/gitlab!82249))
- [Include invited groups into protected environments API](gitlab-org/gitlab@6f73dec2a64989a23d24ac85a2a701a90e9067bc) ([merge request](gitlab-org/gitlab!81029)) **GitLab Enterprise Edition**
- [Add wiki page render option to wiki API](gitlab-org/gitlab@be93a263833ff42abd8b09313a6857fb83e8dcad) ([merge request](gitlab-org/gitlab!81134))
- [Remove rate_limit_user_sign_up_endpoint feature flag](gitlab-org/gitlab@2a506163fd32fc5bf4efc5273930b76f2919dd1e) ([merge request](gitlab-org/gitlab!82092))
- [Expose committers on mergeRequest GraphQL type](gitlab-org/gitlab@627a989aef6a44bc7e3c1538d276d5b115db7d33) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/79965))
- [Add backend interface to look up for security training](gitlab-org/gitlab@72812ce313a47e5385e58b4b008b7427a0fe716e) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/81861)) **GitLab Enterprise Edition**
- [Show security report warnings on pipeline security tab](gitlab-org/gitlab@22e8a70f7e573b39834384156efea65187b37a70) ([merge request](gitlab-org/gitlab!80934)) **GitLab Enterprise Edition**
- [Allow to destroy related epics association on internal API](gitlab-org/gitlab@c4dab676900eccc30c466c45dea6d154ff91a93c) ([merge request](gitlab-org/gitlab!82035)) **GitLab Enterprise Edition**
- [Add frontend routing to Geo GraphQL specific sites](gitlab-org/gitlab@cbf0218b10d37af4a3c54b7358649e484a444805) ([merge request](gitlab-org/gitlab!80106)) **GitLab Enterprise Edition**
- [Add audit logs when assigning CI runner to project](gitlab-org/gitlab@13f562bbde2e5335584d7ac235270a3f4d0e63ea) ([merge request](gitlab-org/gitlab!81508)) **GitLab Enterprise Edition**
- [Merge/squash commit templates: add %{all_commits} variable](gitlab-org/gitlab@ceb64735cbac1fc5b5a176efafd789817cdeb34a) by @trakos ([merge request](gitlab-org/gitlab!81097))
- [Add size to image details heade](gitlab-org/gitlab@6d9d013cd88e7a4e1f0d775c1d432293d58e4afd) ([merge request](gitlab-org/gitlab!82114))
- [Feat(Licesing): update upload to activate](gitlab-org/gitlab@36b4b17e98ad066038b89097e23dfd00d9423d3d) ([merge request](gitlab-org/gitlab!80904)) **GitLab Enterprise Edition**
- [Send a notification when a new access token is created](gitlab-org/gitlab@8c1d3e4a7b9242ec7cabd5392ee9be0719d65fd1) by @rpadovani ([merge request](gitlab-org/gitlab!81340))
- [Add audit event for project deploy tokens](gitlab-org/gitlab@7ab7ea0d89ccd8446d864f6a5d3f4826100aed76) ([merge request](gitlab-org/gitlab!81829)) **GitLab Enterprise Edition**
- [Add audit event for group deploy tokens](gitlab-org/gitlab@eea536482d3c7b2a03baafc7ce51265ee77aff1e) ([merge request](gitlab-org/gitlab!82251)) **GitLab Enterprise Edition**
- [Add suggestion to use short-living tokens to end-users](gitlab-org/gitlab@ee2e5fd4f7f95e5426aac04e1f70a9bf652f93f9) ([merge request](gitlab-org/gitlab!81323))
- [Add comment to Deployment Approvals](gitlab-org/gitlab@31f63645ff9603ac6c1e2b282576d1daa41173f7) ([merge request](gitlab-org/gitlab!82142)) **GitLab Enterprise Edition**
- [Parse pasted markdown](gitlab-org/gitlab@42449f07567d06c41d39378036a759ba58415d05) ([merge request](gitlab-org/gitlab!78394))
- [Remove rate_limit_user_by_id_endpoint feature flag](gitlab-org/gitlab@37c0084c0a4d745e00206da6fca9c16fbc1110bf) ([merge request](gitlab-org/gitlab!82108))
- [Remove rate_limit_username_exists_endpoint feature flag](gitlab-org/gitlab@6c018f2133b0372ff6e79d4a6a60cfcea80e2d14) ([merge request](gitlab-org/gitlab!82105))
- [Remove rate_limit_profile_update_username feature flag](gitlab-org/gitlab@cf9f96bc79cf8532cb405c259030b61fde53b0ee) ([merge request](gitlab-org/gitlab!82095))
- [Expose sum of weights for epic board lists on GraphQL endpoint](gitlab-org/gitlab@32b10dfbaeea605c6ab2f726650f1034693ad465) ([merge request](gitlab-org/gitlab!76440)) **GitLab Enterprise Edition**
- [Add security scan status to GraphQL API](gitlab-org/gitlab@c1ecdd58a472608760235927b2e6f34c5ab0657b) ([merge request](gitlab-org/gitlab!81305)) **GitLab Enterprise Edition**
- [Add saved replies](gitlab-org/gitlab@832f32cc313dcdec9dbf95242213af7c1f37ce76) ([merge request](gitlab-org/gitlab!80807))
- [Backfill all project namespaces](gitlab-org/gitlab@6a08c2b64f98d8f9a19f2f215813da38fb7a3401) ([merge request](gitlab-org/gitlab!77371))
- [Implement API endpoint to get single SSH key for specific user](gitlab-org/gitlab@9e64387c0e3fafce54ff43c212443c9a195c99bc) by @tuxtimo ([merge request](gitlab-org/gitlab!81790))
- [Add job_variables_attributes to play build API](gitlab-org/gitlab@b669e48a4b8e23f1913d93e738386011f478057d) ([merge request](gitlab-org/gitlab!81317))
- [Use fair queueing for Loose Foreign Keys](gitlab-org/gitlab@9738b0324e251e058fdccd3bb4ece57dbeac1479) ([merge request](gitlab-org/gitlab!81888))
- [Add application setting for cleanup policy caching](gitlab-org/gitlab@d0c1b163f8d2ef90e97a40f6b38a789696b5171c) ([merge request](gitlab-org/gitlab!80902))
- [Add GraphQL Todoable interface for to-do targets](gitlab-org/gitlab@4539cd906e27969dadcc9661d97dd60f73bc9cc5) by @KevSlashNull ([merge request](gitlab-org/gitlab!73603))
- [Add circuit breaker for gitlab experimentation](gitlab-org/gitlab@54056a316d1c67bcadc82e1a7ea2dfc579cd6c0a) ([merge request](gitlab-org/gitlab!81834))
- [Add delete endpoint for Alert metric images](gitlab-org/gitlab@9226d47f7c50a39bddf1b8850550dfd5a4291254) ([merge request](gitlab-org/gitlab!81107)) **GitLab Enterprise Edition**
- [Enable Loose Foreign Keys partition rotation](gitlab-org/gitlab@a424373c2557314bd1f6aac893e2c11a3fddc2b4) ([merge request](gitlab-org/gitlab!81793))
- [Add scan method to dast site profile GraphQL API](gitlab-org/gitlab@40fa9ce8d12b026d830cf914fa5478e533e7aceb) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/78745)) **GitLab Enterprise Edition**
- [Filter a pipeline by author](gitlab-org/gitlab@d704138cb32a10b2cf078d9f2bd66922bbbaf6c2) by @genctys ([merge request](gitlab-org/gitlab!79470))
- [Allow to pass suggestedColors to ColorPicker](gitlab-org/gitlab@55babfe9fb03831c83dc5128efe3f635f65b87ff) by @wwwjon ([merge request](gitlab-org/gitlab!81604))
- [Add security_and_compliance_access_level to Projects API](gitlab-org/gitlab@2bd37b450c9027e3eff7451f309d5a2d45458736) by @ytans ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/81086))
- [Add user and system note filters to note_authors association](gitlab-org/gitlab@fcea425c2849e574d9dfac3efd3a5c1ff99c33b9) ([merge request](gitlab-org/gitlab!81436))
- [Add analytics to detect deployment jobs being executed](gitlab-org/gitlab@95dd6e9eff1767ec6ffe8f7a59a04ab7d7889573) ([merge request](gitlab-org/gitlab!79272))
- [Add filters and sorting to compliance violations GraphQL type](gitlab-org/gitlab@bf343e65f31ada9cd2d8249e0574e1f2f15a149f) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/78681)) **GitLab Enterprise Edition**
- [Add encoding field to wiki API](gitlab-org/gitlab@05fd6cb19ed2dd7dade727d36eca0349948db16b) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/81150))
- [Add ingestion for Finding Evidence](gitlab-org/gitlab@855b613c0f62e6cfa67814c293151919663318d0) ([merge request](gitlab-org/gitlab!75287)) **GitLab Enterprise Edition**
- [Feat(Licensing): add Offline cloud type](gitlab-org/gitlab@aa32508aede618cc48540a162d0f00df8cc1ae9e) ([merge request](gitlab-org/gitlab!80833)) **GitLab Enterprise Edition**
- [Add webhook delivery method options to config/mail_room.yml](gitlab-org/gitlab@43165dd6bdd66f89bc4d4db5373f67ccb1254f04) ([merge request](gitlab-org/gitlab!80832))
- [Improve strikethrough in Markdown editor](gitlab-org/gitlab@103a129e63677818ffc9c3c0eac160c9c3f564aa) by @smokris ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/81092))
- [Created compliance violation GraphQL type and added to Group type](gitlab-org/gitlab@7e69ac7f6f90209e364b5c46a4c927857b36013e) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/80995)) **GitLab Enterprise Edition**
- [Implement colour attribute for epics](gitlab-org/gitlab@c428bacd9c61ab4387423586253d8f1a7ca5744c) by @espadav8 ([merge request](gitlab-org/gitlab!79940))
- [Add basic FIPS class](gitlab-org/gitlab@360940b1e162c7b10e18de46bade2a81b80629ae) ([merge request](gitlab-org/gitlab!81418))
- [Add Dark Mode support to the image_tag helper](gitlab-org/gitlab@c6fde03a5158a9f42d8c00082766c767f22a5551) ([merge request](gitlab-org/gitlab!81219))
- [Add upload & update endpoints for alert metrics](gitlab-org/gitlab@829f9695ae7ded05c276f9ae3b6f6d3ea6fc3c53) ([merge request](gitlab-org/gitlab!80982)) **GitLab Enterprise Edition**
- [API: Add endpoint to reset runner token with old token](gitlab-org/gitlab@f027a6f2f1db7c91e2823f3400892b730ecc0a67) by @KyleFromKitware ([merge request](gitlab-org/gitlab!74336))
- [Added updated_state_by_user to reviewers and assignees](gitlab-org/gitlab@d2cacb034a5b21ce02a1441905bc54aa9869ca3c) ([merge request](gitlab-org/gitlab!75927))
- [Swapable cleaner/raw diffs for Notebooks](gitlab-org/gitlab@4677ac06d61e19f0f64a6b0559df72f809996b7f) ([merge request](gitlab-org/gitlab!75500))
- [Upgrade GitLab Pages to 1.55.0](gitlab-org/gitlab@e2cde448a6180d2bb91900c2ce3aa7a0d1dfc14f) ([merge request](gitlab-org/gitlab!81261))
- [Enable pending builds table queuing strategy](gitlab-org/gitlab@65e3bb48e1dd06235ef435f8318ca1787053831a) ([merge request](gitlab-org/gitlab!81238))
- [Add a timeline event pipeline filter to TimelineEvent](gitlab-org/gitlab@a9fb9fdc81d6ddc2c9fe231d80b2fecb32ccebcc) ([merge request](gitlab-org/gitlab!79852)) **GitLab Enterprise Edition**
- [Add read API for Alert Metric Images](gitlab-org/gitlab@8adf04476edf0895406e0b3a3c9e0d75a0b083bd) ([merge request](gitlab-org/gitlab!80442)) **GitLab Enterprise Edition**
- [Support scoped iteration report](gitlab-org/gitlab@5267e55682c71ff60ad818a54123d53d868b7313) ([merge request](gitlab-org/gitlab!81216)) **GitLab Enterprise Edition**
- [Add mutation to promote timeline event from a note](gitlab-org/gitlab@72201bf665c68b0c1bd864068d5cd387eec50f5b) ([merge request](gitlab-org/gitlab!80633)) **GitLab Enterprise Edition**
- [Add active and passive profiles](gitlab-org/gitlab@7907d2f76d4cb7274fbf4e6252a938e9d5cc17a2) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/78492)) **GitLab Enterprise Edition**
- [Support scoping for timebox report via GraphQL](gitlab-org/gitlab@00c656261a7bbb23913947366be3aab7641d4083) ([merge request](gitlab-org/gitlab!79327)) **GitLab Enterprise Edition**
- [Add aggregated VSA consistency check service](gitlab-org/gitlab@19fecb63b6492ca434199ada710c619b6d973689) ([merge request](gitlab-org/gitlab!79942))
- [Return runner editUrl via GraphQL API](gitlab-org/gitlab@4f27ed7c775586a2618f9b301343262406c0f8c9) ([merge request](gitlab-org/gitlab!80926))
- [Add the total time chart to each VSA stage](gitlab-org/gitlab@9c048ea7b6b8034f9ade0209eb69553a1aee5a01) ([merge request](gitlab-org/gitlab!80255)) **GitLab Enterprise Edition**
- [Workhorse: Allow HTTPS for backends](gitlab-org/gitlab@24fbcde50729bd9a58634b0aceb5d3756e5d3302) ([merge request](gitlab-org/gitlab!81061))
- [Adds cross_project_pipeline_available  to NamespaceType](gitlab-org/gitlab@bf83faf50fea5b43af2b627f5aee86a5dfb5389e) ([merge request](gitlab-org/gitlab!80381))
- [Add readme in repo creation for reg flow](gitlab-org/gitlab@d51b0c899f14c5ea2fdbb0387f9311d2de8753f4) ([merge request](gitlab-org/gitlab!79770)) **GitLab Enterprise Edition**
- [Hide markdown preview tab if editing non-markdown formats](gitlab-org/gitlab@596d3f204316790ea2ac19a11be0a0b14ceeaa34) by @espadav8 ([merge request](gitlab-org/gitlab!80178))
- [Log CI runner unregistration audit events](gitlab-org/gitlab@aa9612f1bb8ea820a7490e80290ce2bc77a05200) ([merge request](gitlab-org/gitlab!79754)) **GitLab Enterprise Edition**
- [Add a consolidated button to edit blobs](gitlab-org/gitlab@02314fd77728f731dc55b22033fa6c8a5b766613) ([merge request](gitlab-org/gitlab!80715))
- [Calculate storage statistics for dependency proxy](gitlab-org/gitlab@b8c1f4d851aa72ed144bed44fc233dde43e1be4a) ([merge request](gitlab-org/gitlab!79358))
- [Latest release badge documentation inclusion](gitlab-org/gitlab@8572186d5a8b192edf218bb2c266a1d0fc0adbf8) ([merge request](gitlab-org/gitlab!80897))
- [Add slash command to page incident](gitlab-org/gitlab@f0a8c6f5c5f1835dd8ec97de9fb72156e947cde2) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/79977)) **GitLab Enterprise Edition**
- [Expose container repository sizes](gitlab-org/gitlab@d964a1d7acaf7a851d9ffeac5cf4373ccc52fde9) ([merge request](gitlab-org/gitlab!80412))
- [Create RelatedEpic table and model](gitlab-org/gitlab@f2a49bb242f103503011bad7c8acfb77375298ff) ([merge request](gitlab-org/gitlab!80499))

### Fixed (132 changes)

- [Cleaned up clusters_helper and cluster index haml](gitlab-org/gitlab@02e3bcc76b763124ce50ce869978e1011ffd43bd) ([merge request](gitlab-org/gitlab!82637))
- [Update holder name column to 50 limit constraint](gitlab-org/gitlab@5901bc8701c3bb2ca6f7fc21487013d59302a517) ([merge request](gitlab-org/gitlab!82587))
- [Improve wording for vulnerabilities_allowed](gitlab-org/gitlab@d4242b41a8668fa0da779a5addba281cebd9be7e) ([merge request](gitlab-org/gitlab!82742)) **GitLab Enterprise Edition**
- [Add missing input box for search rate limiting configuration](gitlab-org/gitlab@635d4811cc2613b5299ffc96bf27725c935faa1b) ([merge request](gitlab-org/gitlab!82944))
- [Handle Jira Connect installation updates](gitlab-org/gitlab@19722d41355992ee56a3f045f70b93b957249658) ([merge request](gitlab-org/gitlab!83038))
- [Return a 422 error for Changelog::Error exception](gitlab-org/gitlab@896a7c1de30abb1329d4e6bcb92ceebad6317632) ([merge request](gitlab-org/gitlab!80850))
- [Fix empty state pipelines page](gitlab-org/gitlab@a638ee1aa98d05b2cc5d63c19a4aff8061c1f609) ([merge request](gitlab-org/gitlab!83030))
- [Update attribute indirection](gitlab-org/gitlab@9bf63a5b2bab3d8c93a967a13348bc9853870fa9) ([merge request](gitlab-org/gitlab!82932)) **GitLab Enterprise Edition**
- [Fixed incorrect minimum number of users on subscription purchase flow](gitlab-org/gitlab@db461b03c91a6c6a8f32724dff19cb74933572ad) ([merge request](gitlab-org/gitlab!82480)) **GitLab Enterprise Edition**
- [Refactor remove topic avatar](gitlab-org/gitlab@136b739fcc5b04ed76f4c94d2305c77af0cc8ba5) ([merge request](gitlab-org/gitlab!82894))
- [Fix default Ci config path](gitlab-org/gitlab@03dd150afcb7353fd4d4903a9ca59705b2b109d9) ([merge request](gitlab-org/gitlab!82827))
- [Fix ci.json: Remove Nesting from Secrets Rule](gitlab-org/gitlab@ee33d4da70cc300335192cdaaca3a20260d4cca3) ([merge request](gitlab-org/gitlab!82484))
- [Fix DevopsAdoption usage metric gathering](gitlab-org/gitlab@47676bd58f6463bcb265ead7eaf737fb921d5c66) ([merge request](gitlab-org/gitlab!82904)) **GitLab Enterprise Edition**
- [Fix Epic and Label != filtered search suggestions not showing](gitlab-org/gitlab@c9b18202657080149c72fc317be64dfe10f11ca1) ([merge request](gitlab-org/gitlab!82814))
- [Handle recursion when creating ApplicationSettings](gitlab-org/gitlab@4b59d55ada4b0212e2aece9f3c52ec9281739ebf) ([merge request](gitlab-org/gitlab!82930))
- [Fall back to avaiable scope if scope is invalid](gitlab-org/gitlab@b9da1851edf685a39e58c6b5bfbd6a169cad1378) ([merge request](gitlab-org/gitlab!82847))
- [Fix sourcegraph breaking on projects/:id](gitlab-org/gitlab@248ab5c8b02e3e21a1a206b4032653afbb065c90) ([merge request](gitlab-org/gitlab!82447))
- [Find or initialize Scanners using project_id](gitlab-org/gitlab@8090f3da0944805673ac8189c3fcfe43591573cc) ([merge request](gitlab-org/gitlab!82923)) **GitLab Enterprise Edition**
- [Add responsive property to area charts in CI minutes](gitlab-org/gitlab@a97e275af9ba3405862792ad1ab252e5fe980b98) ([merge request](gitlab-org/gitlab!82741)) **GitLab Enterprise Edition**
- [Additional spec to capture bug in latest release permalink and fix same](gitlab-org/gitlab@f9f9f8300d8565e4315bb4c0cb4d54dccf522d60) ([merge request](gitlab-org/gitlab!82896))
- [Global Search - Fix ref based searches](gitlab-org/gitlab@08e0800ee2cc9ee85709f1689b212b4d028cd822) ([merge request](gitlab-org/gitlab!80857))
- [Remove duplicate new cluster button](gitlab-org/gitlab@e43022603d6c7bb7243d7444816c8cb190559192) ([merge request](gitlab-org/gitlab!82654))
- [Increase token preview length in runner audit logs](gitlab-org/gitlab@68acf3dbd2705bc8a640643a97254e25c6059316) ([merge request](gitlab-org/gitlab!82523)) **GitLab Enterprise Edition**
- [Fix unexpected height stretch of CI job duration badge](gitlab-org/gitlab@0b9adf4ae7c163bf0ab691306e4f068562231b66) by @nanmu42 ([merge request](gitlab-org/gitlab!82670))
- [Allow setting push events branch filter for group hooks](gitlab-org/gitlab@9f3ad7d9753a989ad5b532ffd947687b6c647eef) ([merge request](gitlab-org/gitlab!82531)) **GitLab Enterprise Edition**
- [Support CRM contacts only in root groups](gitlab-org/gitlab@227c3221888c925d21d8a7d17f8d552384e07e1d) by @leetickett ([merge request](gitlab-org/gitlab!78959))
- [UI Bug Fix: Expand the early checks when using /merge quick action](gitlab-org/gitlab@513a636c4327658243c64e1380babb565f8259d9) ([merge request](gitlab-org/gitlab!82170)) **GitLab Enterprise Edition**
- [Fix an inaccurate help page link](gitlab-org/gitlab@4cbaffb4f06699ba295af31a4c0d7a11d5a71d30) ([merge request](gitlab-org/gitlab!82147))
- [Add validation for rule/yaml modes switch](gitlab-org/gitlab@1a87f7fbe9544c9bd17abc82fa3f84acfa2a95cd) ([merge request](gitlab-org/gitlab!82451)) **GitLab Enterprise Edition**
- [Fix namespace usage quotas storage pagination](gitlab-org/gitlab@bd5c66fcfa06c7ebd74937efea3b14cb339d9082) ([merge request](gitlab-org/gitlab!80752))
- [Replace applications destroy alert with GlModal](gitlab-org/gitlab@6b4cd07d9724821d20c8e546926703ad97030394) ([merge request](gitlab-org/gitlab!80799))
- [Don't allow filtering by `in` alone on issue/MR dashboard](gitlab-org/gitlab@138f3d1a76ab05f9e73db667eafd3e94bbe70e19) ([merge request](gitlab-org/gitlab!82664))
- [Allow invite group modal to render when membership is locked](gitlab-org/gitlab@8d2ebd4d78459c48cf95a6b597886aaf0756e9e5) ([merge request](gitlab-org/gitlab!82636)) **GitLab Enterprise Edition**
- [Scan MR description when syncing builds with Jira](gitlab-org/gitlab@9db551e82528eaac1645f2acc7561441473b4c17) ([merge request](gitlab-org/gitlab!82204))
- [Set resoure_iteration_events to ghost user](gitlab-org/gitlab@004f78ac56a0f3a4303f6b93fc44059902c5343a) ([merge request](gitlab-org/gitlab!82060)) **GitLab Enterprise Edition**
- [Update BulkImports Export to handle unexpected failure](gitlab-org/gitlab@3fba81a5bf6cc47722a5d8f2e63b4026b81a4d30) ([merge request](gitlab-org/gitlab!82221))
- [Fix UsageDataQueries API not returning a query](gitlab-org/gitlab@7467adf89b4f5ef47eb9054a40e19b3de1eb7117) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/81823)) **GitLab Enterprise Edition**
- [Fixed user cap evaluation for all OAuth login](gitlab-org/gitlab@0938f9f1c9b5a19cf107aa9e198505dc8cfb9fd2) ([merge request](gitlab-org/gitlab!81272)) **GitLab Enterprise Edition**
- [Fix retrying of batched background migrations](gitlab-org/gitlab@80c517ffc5f2a9724e2614d70f1540a95718955f) ([merge request](gitlab-org/gitlab!82387))
- [Allow merge commits for SD](gitlab-org/gitlab@ce04cea13b325aa7f0399b721f96842d93bb0ea0) ([merge request](gitlab-org/gitlab!82546))
- [Fix startup crash in Puma single mode](gitlab-org/gitlab@076ac5bba2eda70f13bccd892549f40a6e09d380) ([merge request](gitlab-org/gitlab!81983))
- [Decouple policy name update from yaml/rule modes](gitlab-org/gitlab@b98c6a483022199e8f3927726bca893c79ac72c6) ([merge request](gitlab-org/gitlab!82337)) **GitLab Enterprise Edition**
- [Poll folder for changes in new environments page](gitlab-org/gitlab@0ac66e447cb52f0228d67fbf58dda419f4b01fda) ([merge request](gitlab-org/gitlab!81043))
- [Remove empty approvers in regards to](gitlab-org/gitlab@7b9b2ddc71543f932750279bb8c052fb5614dc3a) ([merge request](gitlab-org/gitlab!82338)) **GitLab Enterprise Edition**
- [Check authorization to view billableMembersCount](gitlab-org/gitlab@1a23f5e64e33527163dcb5e5b546a9f30108ced5) ([merge request](gitlab-org/gitlab!82479)) **GitLab Enterprise Edition**
- [Refactor repo deletion existence checking](gitlab-org/gitlab@86e7d744aa5cd08a9e8312b4c464ac19bcb20fa6) ([merge request](gitlab-org/gitlab!81799))
- [Make hr in markdown visible in darkmode](gitlab-org/gitlab@78d9d3c983e670f6832916e1749ce3e2fb7cbc99) by @dianapaula19 ([merge request](gitlab-org/gitlab!81559))
- [Fix filters presence check to take value into consideration](gitlab-org/gitlab@1b9dbdc99817b0dc7a516fcf46c1bf9b18e0b539) ([merge request](gitlab-org/gitlab!82462))
- [Param requires_python is optional for pypi](gitlab-org/gitlab@22a7e20d06e2ab32bf3c947763ea8b1fa03a1417) ([merge request](gitlab-org/gitlab!81946))
- [Ensure that the spaces between frontmatter are kept](gitlab-org/gitlab@aa1c697b288e4205301f0d3e7dec04533cba49f0) by @tchandelle ([merge request](gitlab-org/gitlab!81470))
- [Fix sourcemap recovery error in Content Editor](gitlab-org/gitlab@2e46ff7fa3332bec0fc7a7f9053904b34762bf89) ([merge request](gitlab-org/gitlab!82040))
- [Users who can read group should read group token](gitlab-org/gitlab@7fa729107e73f0a80de96afbd356372a36ce06a0) ([merge request](gitlab-org/gitlab!81843))
- [Fix bot token name in issues](gitlab-org/gitlab@86a01c368b981ac8848f211a90b9d479e79985e7) ([merge request](gitlab-org/gitlab!81843))
- [Allow inherited members of groups to deploy protected environments](gitlab-org/gitlab@decab235e844088309bdefbd8d2fbddbe61cb90b) ([merge request](gitlab-org/gitlab!82415))
- [Update group bulk edit issues user docs](gitlab-org/gitlab@eb943abc5618acedd482edc31da655b5a2e72831) ([merge request](gitlab-org/gitlab!82406))
- [Fix variable in _prometheus.html.haml so it shows as a code block](gitlab-org/gitlab@3c8716d9c4e0edd10b808837934a0fe0a0f8b1f0) ([merge request](gitlab-org/gitlab!82395))
- [Project settings: fix semi-linear merge description](gitlab-org/gitlab@7e2b13257ec62cb41324c3c0835f7a201f897a9f) by @trakos ([merge request](gitlab-org/gitlab!82261))
- [Fix rake task to seed Geo tracking database](gitlab-org/gitlab@7b55621331c7c42b9bf460a9e83ada9a908db714) ([merge request](gitlab-org/gitlab!82340)) **GitLab Enterprise Edition**
- [Fix remove button overlap with other components](gitlab-org/gitlab@4974a54bb041930f9b7a8c5fc1124d87abdf1519) ([merge request](gitlab-org/gitlab!82346)) **GitLab Enterprise Edition**
- [Include merge-requests in RESERVED_REFS_NAMES](gitlab-org/gitlab@f610f865f1dd92f0408c12d9a97590f5f9892744) ([merge request](gitlab-org/gitlab!82326))
- [Pass issue ID to merge request creation form](gitlab-org/gitlab@1e72978788cc1a439c54c070f2f64101b642957b) ([merge request](gitlab-org/gitlab!81886))
- [Apply omniauth defaults when no arguments are given](gitlab-org/gitlab@07fba40d80f502ac1aa7adaa99e8dcbac603dccc) ([merge request](gitlab-org/gitlab!81752))
- [Fix `Verify SAML Configuration` button](gitlab-org/gitlab@910f9a47af94165c587d19c83e55ca97df2316ac) ([merge request](gitlab-org/gitlab!80978)) **GitLab Enterprise Edition**
- [Replace success variant with the confirm](gitlab-org/gitlab@0b3828cdbd96a4a2159ef1f95abf257dac16f9c3) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/82207)) **GitLab Enterprise Edition**
- [Modify Union sql construction](gitlab-org/gitlab@5ca65cb8298ab3627a4f014105dcae660b267832) ([merge request](gitlab-org/gitlab!82077))
- [Restart Action Cable server when Redis disconnects](gitlab-org/gitlab@12b8a5635b97629ccab4ac6529747e418e975c42) ([merge request](gitlab-org/gitlab!80822))
- [Cache namespace first Auto DevOps config](gitlab-org/gitlab@9579939d83b350e06129b4501dc87e944a32bc07) ([merge request](gitlab-org/gitlab!80937))
- [Global Search - Header Search Snippets](gitlab-org/gitlab@2e9739f18020efa33a5bec6b2e818b5c120c67de) ([merge request](gitlab-org/gitlab!80844))
- [Fix NoMethodError when visiting repo analytics](gitlab-org/gitlab@afcedad0eaca6cfb3a3878e24af3c9d488286b3b) ([merge request](gitlab-org/gitlab!81988)) **GitLab Enterprise Edition**
- [Skip navigation modal for cancel button](gitlab-org/gitlab@554492fd1323a1da69f890828a2db167be777efb) ([merge request](gitlab-org/gitlab!81516))
- [Handle not existing training ID for securityTrainingUpdate mutation](gitlab-org/gitlab@af4ec86a05cbef3991af0c787177b7ff204d54c7) ([merge request](gitlab-org/gitlab!81023)) **GitLab Enterprise Edition**
- [Fix VSA error with scoped labels](gitlab-org/gitlab@565294145c7b2864fdc169e383973e85ee42938e) ([merge request](gitlab-org/gitlab!82083)) **GitLab Enterprise Edition**
- [Fix markdown serialization in content editor](gitlab-org/gitlab@b9713c00a9bf76fb1eebc22b5a57a629063fc7ad) ([merge request](gitlab-org/gitlab!81849))
- [Fix the month view on CI usage by minutes bar chart](gitlab-org/gitlab@c45a93a7654eb2473b3557a3a8f075763084c69e) by @parkourkarthik ([merge request](gitlab-org/gitlab!81185))
- [Hard delete bulk snippets](gitlab-org/gitlab@2e739ceeac54f28092b9520aa7022e51f6359c1f) ([merge request](gitlab-org/gitlab!82020))
- [Allow popups and links within mermaid diagrams](gitlab-org/gitlab@2dd16c32ddde176ee6dda228cd88f4df770b01b7) ([merge request](gitlab-org/gitlab!82012))
- [Fixed bug preventing agent creation from agent tab](gitlab-org/gitlab@bfb1a0030de1724b75fcd5b5bf085524ee802029) ([merge request](gitlab-org/gitlab!81071))
- [Prevent database deadlocks when deleting projects](gitlab-org/gitlab@b8c771578a6592f698cef25a8770ea3539f3f18b) ([merge request](gitlab-org/gitlab!81266))
- [Fix mermaid background in dark mode](gitlab-org/gitlab@68cb78b22268fada1f9f2a8c96793dd347130612) ([merge request](gitlab-org/gitlab!81865))
- [Change Edit to Open in Blob view to maintain consistency](gitlab-org/gitlab@a02c14952dc6069a5ff8e6be395318f15cfbcf26) by @rajanamistry ([merge request](gitlab-org/gitlab!81759))
- [Fix loading spinner for legacy Filtered search dropdown](gitlab-org/gitlab@ebf450dac0b54bffb836bf9afcf7a4ab9520bad2) ([merge request](gitlab-org/gitlab!81953))
- [Replace RegistrySearch component with  PersistedSearch](gitlab-org/gitlab@ec1ee3e62af68ff5d2bdc992b1a2756d4ede261a) by @orozot ([merge request](gitlab-org/gitlab!80994))
- [Fix sending BlobContent query with empty variables](gitlab-org/gitlab@91a808af620b1d6101312e19a83b7740ec648952) ([merge request](gitlab-org/gitlab!81156))
- [Add container to qrtly reconciliation banner](gitlab-org/gitlab@4b01e28713a34d780a83ef11df574bded2b8d48d) ([merge request](gitlab-org/gitlab!81517)) **GitLab Enterprise Edition**
- [Add container for manual renewal banner](gitlab-org/gitlab@20b95750bfed341e801ff6c8552a36417a2778f5) ([merge request](gitlab-org/gitlab!81517)) **GitLab Enterprise Edition**
- [Make loading spinner Pajamas compliant](gitlab-org/gitlab@6010b760f886993f808b846add835d8354eeaba4) ([merge request](gitlab-org/gitlab!81801))
- [Reset paging when sort is changed on vulnerability report](gitlab-org/gitlab@8e98a4469d7ddad22acb35af8d0644195617ec83) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/81870)) **GitLab Enterprise Edition**
- [Fix job page copy source branch button](gitlab-org/gitlab@6aa1d555c347d5d73b4cdb9d56ce7fa6c5d512a3) by @leetickett ([merge request](gitlab-org/gitlab!76022))
- [Raise error when diff note import fails](gitlab-org/gitlab@9490ef6ead244cc457975c1bb9e8afcd5dc6d2d1) ([merge request](gitlab-org/gitlab!81014))
- [Fix group members tooltip label](gitlab-org/gitlab@01969906f1f7cc158167d3734768324a8e51437d) by @ali_o_kan ([merge request](gitlab-org/gitlab!81210))
- [Fix loading icon in activity calendar](gitlab-org/gitlab@4c63009b296e536cc281b79bc0f0195267a2f91a) ([merge request](gitlab-org/gitlab!81552))
- [Fix rendering vulnerability markdown description](gitlab-org/gitlab@5c3ee8d41673c80f25834d475da23b4b6a38f00a) ([merge request](gitlab-org/gitlab!77958)) **GitLab Enterprise Edition**
- [Filter commented_approvers for user note authors](gitlab-org/gitlab@5ce58821fc246927747faa0f76f6ac7e632d9c15) ([merge request](gitlab-org/gitlab!81563))
- [Remove fix_comment_scroll feature flag](gitlab-org/gitlab@af6bf959fd86a248f093c7399b9764e3111bb6ed) ([merge request](gitlab-org/gitlab!79835))
- [Fix error from invalid sha for `include` files](gitlab-org/gitlab@32fe798699dd18681ac9cb6ad5348e2fe50909c1) ([merge request](gitlab-org/gitlab!81036))
- [Fix GRPC 500 from BlobsResolver](gitlab-org/gitlab@8eb9f47a6e67b37747c6204a57928c10cb7baa66) ([merge request](gitlab-org/gitlab!80747))
- [Add error for cross pipeline dependencies](gitlab-org/gitlab@2d2ff9dc0f974a47d729f51623204cb86882d2a0) ([merge request](gitlab-org/gitlab!80513))
- [Handle received header fallback for missing Delivered-To](gitlab-org/gitlab@8eeeb3d78921b7ec073c70a55aaa76364c395b42) ([merge request](gitlab-org/gitlab!81489))
- [Fix erroneous all warning from race condition](gitlab-org/gitlab@3e4134e69afe27c3c820a0fe7c32b2cb9e3956e4) ([merge request](gitlab-org/gitlab!81224))
- [Remove unnecessary margin to the right of the Show comment only dropdown](gitlab-org/gitlab@b5ae5cce465f9cd653a5f240a29c997f47301ce7) by @rajanamistry ([merge request](gitlab-org/gitlab!81449))
- [Expose merge request flag as boolean in the pipeline entity](gitlab-org/gitlab@c27f9a675dc567726c49fb10fe9446f36682b071) ([merge request](gitlab-org/gitlab!81431))
- [Fix pull/push mirror authentication fields](gitlab-org/gitlab@c8ce96c6d6126ab591d0e598efb1993e39eb77dc) ([merge request](gitlab-org/gitlab!81419))
- [Allow admin to register group runners at all times](gitlab-org/gitlab@71ba4d375cfb322e968cc4ceaeaa591f50d2531d) ([merge request](gitlab-org/gitlab!81297))
- [Fix cross-database modification when resetting CI minutes](gitlab-org/gitlab@5f21e7cc3d0bfc52ff82bbce1d1f47ee0dd8a84b) ([merge request](gitlab-org/gitlab!80161))
- [Ensures audit events are visible to auditor](gitlab-org/gitlab@0afc16252ce6b95af2464e59d278db9ffcba9f1b) ([merge request](gitlab-org/gitlab!81497)) **GitLab Enterprise Edition**
- [Enable removing import data on failure by default](gitlab-org/gitlab@440e3962fd4d44097a104602d540bc54d5e02aae) ([merge request](gitlab-org/gitlab!81404))
- [Fix flash color when there is an error](gitlab-org/gitlab@cf6420d41734cee464cb0fd549169cf0a32fa682) by @ali_o_kan ([merge request](gitlab-org/gitlab!81052))
- [Allow assigning users with private profiles](gitlab-org/gitlab@f13ca808192ef98097c0fee739ad38cc555cad7d) ([merge request](gitlab-org/gitlab!81099))
- [Fix multiple modals showing when canceling note](gitlab-org/gitlab@30fb9b9699b84b57550a4758b882d65b1fd8fc0b) ([merge request](gitlab-org/gitlab!81310))
- [Allow admin to register project runners at all times](gitlab-org/gitlab@3d8c4f488b08fdab1908031b4b9546e8b67fc1f9) ([merge request](gitlab-org/gitlab!81298))
- [Block execution of cyclical pipelines](gitlab-org/gitlab@12f9e6dbc07baaa297e80b5562bc5612a0589bb4) ([merge request](gitlab-org/gitlab!81287))
- [Ensures audit events are visible to auditor](gitlab-org/gitlab@662a01dcb9d26d916b8186957e3a4c9dd8640075) ([merge request](gitlab-org/gitlab!81267)) **GitLab Enterprise Edition**
- [Truncate Jira app key to be no longer than 64](gitlab-org/gitlab@084ec2d644f453f2bae0970c9fe2d1642d0e1835) ([merge request](gitlab-org/gitlab!80922))
- [Ensure cleanup job artifacts task does not include pipeline artifacts](gitlab-org/gitlab@1a36a02ce63d4001b105705690ee8da77ee892bb) ([merge request](gitlab-org/gitlab!81022))
- [Avoid idling in transaction when fetching source for merge requests](gitlab-org/gitlab@1349b8cf09bdc0396522ff10aee04124ec86fa40) ([merge request](gitlab-org/gitlab!80876))
- [Fix response of `securityTrainingUpdate` mutation](gitlab-org/gitlab@a9fcbb72f1449357a5692b04818b8b983ce287e4) ([merge request](gitlab-org/gitlab!80731)) **GitLab Enterprise Edition**
- [Remove CachingArrayResolver from epic issues](gitlab-org/gitlab@ba02cfd09d56bdc87e42c7c6cfaa0a9ddf0a37e2) ([merge request](gitlab-org/gitlab!80635)) **GitLab Enterprise Edition**
- [Do not mirror protected tags restricted for a creation](gitlab-org/gitlab@e72300fca11097a0c244795b06e43130348eb3b7) ([merge request](gitlab-org/gitlab!80388)) **GitLab Enterprise Edition**
- [Hide white box at bottom of MR diff page](gitlab-org/gitlab@7dc62567ce0d6ec5e650e0538a39e8bde1bece27) ([merge request](gitlab-org/gitlab!81117))
- [Stop backup files from requiring directories to exist when skipped](gitlab-org/gitlab@e2541c622021b709013d915a283920ec4173691c) ([merge request](gitlab-org/gitlab!81098))
- [Fix the Content Editor strikethrough shortcut docs](gitlab-org/gitlab@bd689aafcd91ea64742b4a25d0528b8ab602397a) by @smokris ([merge request](gitlab-org/gitlab!81091))
- [Fix TypeError from Tags::Reference](gitlab-org/gitlab@9a2ee6777644e2dd5d81ea843ea46f69561b241d) ([merge request](gitlab-org/gitlab!80845))
- [Fix copy button in Enable Review App modal](gitlab-org/gitlab@11d275b36d9c7da44946365bfa51e7ebaf319640) by @aeboyaci ([merge request](gitlab-org/gitlab!80561))
- [Pass all options from member entity](gitlab-org/gitlab@d8b7136c5f930b7db6d261d462df46b48db93fdc) ([merge request](gitlab-org/gitlab!81046))
- [Automatically adapt the CSP when snowplow is enabled](gitlab-org/gitlab@7f73ea342359eb628117f332e59263bb79bc617c) ([merge request](gitlab-org/gitlab!78624))
- [Fix toolbar buttons in Markdown field](gitlab-org/gitlab@bd6522df2cb9019276204da7e6ccc1f052b2678f) ([merge request](gitlab-org/gitlab!80919))
- [Fix Replace button form path](gitlab-org/gitlab@5c6ac77fad63912a2254aba9b2c48f8aeabe5c5a) ([merge request](gitlab-org/gitlab!80953))
- [Allow project admin to read project approvals](gitlab-org/gitlab@b103c49e3c200bc9cce0615a1a55427501bd0dd7) ([merge request](gitlab-org/gitlab!80652)) **GitLab Enterprise Edition**
- [Dynamically add AWS URLs to CSP on EKS auth page](gitlab-org/gitlab@6f448c0396315ddda967ed55dd9feefd11c6011e) ([merge request](gitlab-org/gitlab!80576))
- [Do not count group bot users from shared group towards seat usage](gitlab-org/gitlab@dabae884b2f1afaa37213689568811c4bdd0d79d) ([merge request](gitlab-org/gitlab!80889)) **GitLab Enterprise Edition**
- [Make contribution graph email grouping ignore case](gitlab-org/gitlab@c524cfacbd2a3be25d303c503e34a7be4bf8a9b1) ([merge request](gitlab-org/gitlab!80701))
- [Don't return 500 error in Commits API when repository is missing](gitlab-org/gitlab@95177859a3421535adc36fa5bb190069d7fbd233) ([merge request](gitlab-org/gitlab!80410))

### Changed (194 changes)

- [Add iteration selector to board scope](gitlab-org/gitlab@ed7049fb25e7d4bebc6d74a980d2bd58255c6666) ([merge request](gitlab-org/gitlab!69052)) **GitLab Enterprise Edition**
- [Block limited broadcast address (255.255.255.255) in UrlBlocker](gitlab-org/gitlab@9ba2dfbeb1e21540e9350859eec6823e73700468) ([merge request](gitlab-org/gitlab!82571))
- [Migrate to unique indices in projects runners tokens](gitlab-org/gitlab@66c9c3b9e1f1828431119ab3f282495c058d4b1f) ([merge request](gitlab-org/gitlab!81991))
- [Track git blame clicks from code search results](gitlab-org/gitlab@cbf4c4c64a68e5e8a65e5bc4d46ae7a5bf44adf5) ([merge request](gitlab-org/gitlab!82533))
- [Split cluster creation page into two pages](gitlab-org/gitlab@d6e1b58f7547f40db9b53f1c27c7eb12d7b178e0) ([merge request](gitlab-org/gitlab!80730))
- [Prevent group owners from deleting certain project runners](gitlab-org/gitlab@4b488c3049ac9318bdf58ce424a405acc14c99b7) ([merge request](gitlab-org/gitlab!82023))
- [Remove unnecessary Edit tab in WebIDE](gitlab-org/gitlab@578ef1438606d0e3c2b8e7e288f4fea744361756) by @Bisht13 ([merge request](gitlab-org/gitlab!81366))
- [Switch AWS "easy button" icons with radio buttons](gitlab-org/gitlab@5e1115f55e58e059af361c097aaad71bbba8d953) ([merge request](gitlab-org/gitlab!82203))
- [Update error message with importing container repository](gitlab-org/gitlab@fbe5608fae60004a06e0a2855988dbe769cd3948) ([merge request](gitlab-org/gitlab!82730))
- [Update runner Pause/Resume button labels](gitlab-org/gitlab@6963d4a34f79d659b05a7235c0d655d1ae0f9a51) ([merge request](gitlab-org/gitlab!82702))
- [Update Jira integration form to have sections](gitlab-org/gitlab@fc40199266c55b6c50ba3a6af5995ad8803dca7f) ([merge request](gitlab-org/gitlab!82970))
- [Set geo_job_artifact_replication default to true](gitlab-org/gitlab@4bc1a37e76291b5b84eae9243b3ee35fe5c3e650) ([merge request](gitlab-org/gitlab!82906)) **GitLab Enterprise Edition**
- [Use checkboxes to select target roles for broadcast messages](gitlab-org/gitlab@bb22d0083401a8d3964924194b3e3b812ccc502b) ([merge request](gitlab-org/gitlab!80131))
- [Add frontend validation to avoid duplicate asset link names](gitlab-org/gitlab@965d07d9966853d3f95905af134932ba0d0b60ae) by @emanuelfarias ([merge request](gitlab-org/gitlab!81591))
- [Adding Secure Files upload limit](gitlab-org/gitlab@3710372c3530bea064640204e57fdc7562d19c65) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/82858))
- [Promote exp: change_continuous_onboarding_link_urls](gitlab-org/gitlab@4c43e3cef10f11ec69962da60db3f4bfcd466605) ([merge request](gitlab-org/gitlab!80906))
- [Move two-factor authentication callout to the todo-list page](gitlab-org/gitlab@16f27135ede22584735d57fe9f1d32c6a485808d) ([merge request](gitlab-org/gitlab!82612))
- [Use new vulnerability report for pipeline security tab](gitlab-org/gitlab@b4551ff88a5eef51c653554f9c4aee621ff5ebc2) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/81760)) **GitLab Enterprise Edition**
- [Update job page for blocked deployments](gitlab-org/gitlab@e56c04cb5db42f4b43f716b91ff71192308f5b75) ([merge request](gitlab-org/gitlab!82456)) **GitLab Enterprise Edition**
- [Remove block_project_serialization feature flag](gitlab-org/gitlab@2912ac093f963107630ba4e7b1788d9a473bafa1) ([merge request](gitlab-org/gitlab!82866))
- [Migrate two-factor auth error message to shared HAML partial](gitlab-org/gitlab@65604eaf0ce4be6ee88316d6cd013dded62a994c) ([merge request](gitlab-org/gitlab!82753))
- [Enable the `geo_token_user_authentication` FF by default](gitlab-org/gitlab@33378ee41d6c487eb688aaf438c0e04dfd070a45) ([merge request](gitlab-org/gitlab!82835))
- [Do not ensure HEAD is default_branch on snippets](gitlab-org/gitlab@81f2238ec2d21bfa8d6e34214474d0b5f9fd2feb) ([merge request](gitlab-org/gitlab!82731))
- [Project authorization is unique per user, project](gitlab-org/gitlab@7fc54b1ca86c382662c389ddece169c7cbb0a407) ([merge request](gitlab-org/gitlab!82460))
- [Change CI lint primary button style](gitlab-org/gitlab@186169740baf93a12bf9bff4ba78496fd18adbfe) by @gtsiolis ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/81611))
- [Add pipeline editor walkthrough feature permanently](gitlab-org/gitlab@4efb2b11021600a0f895c59d78f9bb0584933717) ([merge request](gitlab-org/gitlab!82682))
- [Add error when acccess denied due to credit card](gitlab-org/gitlab@f2344f3820cf62ab475598c61041d56903a7ab7e) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/80657)) **GitLab Enterprise Edition**
- [Turn the subscribable banner into an alert](gitlab-org/gitlab@2e1ea8ecd8963778cfe84334bca000f1ad127ac6) ([merge request](gitlab-org/gitlab!81236)) **GitLab Enterprise Edition**
- [Add configurable search rate limits](gitlab-org/gitlab@803ba15846843113f7eda03dd6d062f413074f9d) ([merge request](gitlab-org/gitlab!80631))
- [Improve email notification styling](gitlab-org/gitlab@5e88a2bcedc112c83fe6f7321f7c67fd3008432c) by @smokris ([merge request](gitlab-org/gitlab!78604))
- [Enable API kaminari count with limit](gitlab-org/gitlab@2b8dcb45a380ee40c2a3760ec89afa03c4fa8cc4) by @jaspreet-3911 ([merge request](gitlab-org/gitlab!82003))
- [Bump GITLAB_KAS_VERSION to 14.9.0](gitlab-org/gitlab@4f09d013774b45590f3dab71faba2e0fb3b79aef) ([merge request](gitlab-org/gitlab!82765))
- [Revise merge-conflict modal text](gitlab-org/gitlab@b6fa39a018486ee93bf450e21d257bba6eeba8dd) ([merge request](gitlab-org/gitlab!80666))
- [Rename remove user action](gitlab-org/gitlab@af0a2866bddb68f56ef2812ac00f87e6a296ead5) ([merge request](gitlab-org/gitlab!82109))
- [Search presenter is a noop when given empty results](gitlab-org/gitlab@2b309e390b2474358908d6799ada2fee0b5969ae) ([merge request](gitlab-org/gitlab!82619))
- [Restyle project deletion and restoration containers](gitlab-org/gitlab@05503faf43544769f53497b9e2f0effa0dfb11a6) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/82313)) **GitLab Enterprise Edition**
- [Remove new environments table feature flag](gitlab-org/gitlab@2a7690c59e83439f1133d7c34f63578deb5e8771) ([merge request](gitlab-org/gitlab!80948))
- [Add link to incident title](gitlab-org/gitlab@32642d5e4cbb3a564df265791e1ba7a2f7553ef3) ([merge request](gitlab-org/gitlab!82373))
- [Remove type from ruby template](gitlab-org/gitlab@5c928b128332cbd18e1e4fef3af2bf05bb374681) ([merge request](gitlab-org/gitlab!82686))
- [Enable feature flags to resume artifact removal](gitlab-org/gitlab@818e748f7e56f56cba0f13ebc8a3b8a64643af61) ([merge request](gitlab-org/gitlab!82681))
- [Validate urls before attempting to download](gitlab-org/gitlab@bf1443c0bc54a0b2fff8f8594eeb35cedb28cc7a) ([merge request](gitlab-org/gitlab!80700))
- [Parse Snowplow value as Number](gitlab-org/gitlab@da274cf499696aa40bcfec54e4f30ba5148fdf40) ([merge request](gitlab-org/gitlab!81928))
- [Remove placeholder and move error message in the form](gitlab-org/gitlab@6eb7350a58ec89904db0442ed5606a908d8471ab) ([merge request](gitlab-org/gitlab!82404))
- [Update auto-build-image to v1.9.1](gitlab-org/gitlab@b0f44e42e5b6593317cd7083619b8b4412d42e00) ([merge request](gitlab-org/gitlab!80289))
- [Remove feature flag to read finding evidence model](gitlab-org/gitlab@73b17f4fdeccefecef074d2026279d0c89e8d1bf) ([merge request](gitlab-org/gitlab!82450)) **GitLab Enterprise Edition**
- [Removed compliance_violations_graphql_type feature flag](gitlab-org/gitlab@085a7f27317fdb41eabfad27e6483388c2ddb909) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/82603)) **GitLab Enterprise Edition**
- [Enable show_report_validation_warnings by default](gitlab-org/gitlab@94a9eb8f03d636b79c0629752f1ac335c1e9ba47) ([merge request](gitlab-org/gitlab!82520))
- [Use follow redirects middleware in the Container Registry clients](gitlab-org/gitlab@ffb7697483299fc496affc694e9a0884051a64f5) ([merge request](gitlab-org/gitlab!82614))
- [Use SAX parser for cobertura coverage reports](gitlab-org/gitlab@6dc4483658c6183db12877fe34ab2014b8322343) ([merge request](gitlab-org/gitlab!82610))
- [Migrate spinners in approver suggestion partial](gitlab-org/gitlab@e65ad1e60e1975cf7706d6f5477024820bd1c418) ([merge request](gitlab-org/gitlab!82503)) **GitLab Enterprise Edition**
- [Release chat notification branch filter for deployments](gitlab-org/gitlab@ad9573df04405d5577cf68dd7df52a52f34fb1ee) ([merge request](gitlab-org/gitlab!82583))
- [Add no-sort-reset prop to vulnerability list](gitlab-org/gitlab@43e72012072b081bdde47af1729c077daa6bac05) ([merge request](gitlab-org/gitlab!82588)) **GitLab Enterprise Edition**
- [Update placeholder text in import projects table](gitlab-org/gitlab@80c5f0dce139cb17347379078667849685a54096) ([merge request](gitlab-org/gitlab!82575))
- [Reduce the number of buckets in Sidekiq histograms](gitlab-org/gitlab@7c912e143b6ea039ce58ee023cc9991e8d52136b) ([merge request](gitlab-org/gitlab!82509))
- [Wrap alert in a DIV](gitlab-org/gitlab@eddeceff21fa85221d0b8b4deb3f00a582586cfe) by @gitlab-dependency-update-bot ([merge request](gitlab-org/gitlab!81282)) **GitLab Enterprise Edition**
- [Remove vulnerability_finding_replace_metadata flag](gitlab-org/gitlab@0a84a07e9c995f60cef7e6bc0e0687105dae1727) ([merge request](gitlab-org/gitlab!82440)) **GitLab Enterprise Edition**
- [Update group-level compliance framework to match project settings](gitlab-org/gitlab@7f68de064f68e9e9e0c4b7c420d8cce2ac43c1e9) ([merge request](gitlab-org/gitlab!82492)) **GitLab Enterprise Edition**
- [Merge injected KUBECONFIGs for clusters and agents](gitlab-org/gitlab@bc2b67cf6e88f6afb241dd9861c60795c38fccc5) ([merge request](gitlab-org/gitlab!82246))
- [Fallback to basic search on archived projects](gitlab-org/gitlab@5ba09f808887fc96b91d18aac18341d5353d0885) ([merge request](gitlab-org/gitlab!82517)) **GitLab Enterprise Edition**
- [Added cluster Actions menu to group and admin view](gitlab-org/gitlab@cfe32c2fe7e9c119cfc3b392adbb8778521ce57c) ([merge request](gitlab-org/gitlab!81846))
- [Remove feature flags for runner token prefix](gitlab-org/gitlab@29bbf97e2bc9b22ef35cc92fb076c14cf2f3fb57) ([merge request](gitlab-org/gitlab!81839))
- [Fix RSpec/TimecopTravel offenses (Part 2/2)](gitlab-org/gitlab@6a092c053c6195c187afe6589ea52ee6152ee2d4) by @KevSlashNull ([merge request](gitlab-org/gitlab!76034))
- [Disallow integrated error tracking by default](gitlab-org/gitlab@99ebbe65a746cf04c0eeccc7b93a815f87b4ba64) ([merge request](gitlab-org/gitlab!81767))
- [Improve and internationalize Deployment Approval error messages](gitlab-org/gitlab@3dbac553b737cee798eaec5f3394661fb7a890fa) ([merge request](gitlab-org/gitlab!82454)) **GitLab Enterprise Edition**
- [Update new issue form to match Pajamas specs](gitlab-org/gitlab@8832a74998ba32b3be15e2bef8ba4a5b157540c7) ([merge request](gitlab-org/gitlab!82425))
- [Refactor(Groups SSO): migrate to gl-tabs](gitlab-org/gitlab@bde7a342ac79b1c9d0490677cbad7996a8930f42) ([merge request](gitlab-org/gitlab!82512)) **GitLab Enterprise Edition**
- [Enable cleanup policies throttling by default](gitlab-org/gitlab@3cd38afaf2cb736d424e0dec41d481ceeb6109ee) ([merge request](gitlab-org/gitlab!80815))
- [Global Search - Support non-js searches](gitlab-org/gitlab@65317192013f24f8374e9ba06720cdad00265208) ([merge request](gitlab-org/gitlab!80964))
- [Update icon, remove text, and switch](gitlab-org/gitlab@f46ec577443c20f1267838234af83e565743cc22) ([merge request](gitlab-org/gitlab!80395))
- [Allow to hide deployment target on New Project page](gitlab-org/gitlab@31e632190cb09ca72392a731601ff20ad3714d6f) by @wwwjon ([merge request](gitlab-org/gitlab!82485))
- [Support GraphQL authentication with project tokens](gitlab-org/gitlab@16913601c1852fd09fc6bdc89cd4263fc1e6b1e8) ([merge request](gitlab-org/gitlab!82316))
- [Migrate Epic Tabs to use Button Group](gitlab-org/gitlab@5f12034bb14cdb1968c3636f4f0db4a388859e82) ([merge request](gitlab-org/gitlab!81978)) **GitLab Enterprise Edition**
- [Extend billable members count to accept requested hosted plan parameter](gitlab-org/gitlab@7703838094e42a16a950aaa3674fe31544bbd0a7) ([merge request](gitlab-org/gitlab!82049)) **GitLab Enterprise Edition**
- [Bump Auto Deploy Image verion to v2.22.0](gitlab-org/gitlab@28e8783ce990ddf443c25e8ab39c38f75a08c6d9) ([merge request](gitlab-org/gitlab!82461))
- [Consider non-default config files for Security UI](gitlab-org/gitlab@9a74d9ba9bf2a68dde0149aaa3c8c4992b409e5f) ([merge request](gitlab-org/gitlab!81027))
- [Migrate loading spinners](gitlab-org/gitlab@0e22efabb4ca4ffa3077130c9d0fb4ccc310eefd) ([merge request](gitlab-org/gitlab!82236))
- [Update project compliance frameworks settings](gitlab-org/gitlab@c1aec2f8a65f1d012cfc2e9aae429eab38d4c3a1) ([merge request](gitlab-org/gitlab!81889)) **GitLab Enterprise Edition**
- [Issue 349398 - Update search field in Global Search](gitlab-org/gitlab@c7720cb353ff473821a5cf17500fe7bc72531822) ([merge request](gitlab-org/gitlab!80916))
- [Header Search Refactor - Handle Errors in the component](gitlab-org/gitlab@f0d356994a99ad4bb6ad938bcb085fd17be7b714) ([merge request](gitlab-org/gitlab!80746))
- [Migrate spinners in archived projects partial](gitlab-org/gitlab@223b665a5985429409fa2d229ca925eeb65b3167) ([merge request](gitlab-org/gitlab!82385))
- [Migrate spinners in user's overview](gitlab-org/gitlab@9a365876efc4bd00e195833667c3736249cdf6ab) ([merge request](gitlab-org/gitlab!82379))
- [Migrate spinners in explore groups partial](gitlab-org/gitlab@b3e58fccee2018a3326c3ea4e16ea8bd0eb1fa47) ([merge request](gitlab-org/gitlab!82377))
- [Creates audit event when approval rule is deleted](gitlab-org/gitlab@1f1d3801c8648ba4e5491364bcb9f924a05dc155) ([merge request](gitlab-org/gitlab!82297)) **GitLab Enterprise Edition**
- [Creates audit event on approval rule creation](gitlab-org/gitlab@adcddf4419f946b1f31449300149f919508efd2a) ([merge request](gitlab-org/gitlab!81973)) **GitLab Enterprise Edition**
- [Update Auto DevOps docker versions to 20.x](gitlab-org/gitlab@f71efa773512bda0430400817ff0f22fd906a156) ([merge request](gitlab-org/gitlab!82353))
- [Remove constraints from sprints table](gitlab-org/gitlab@444a02c30a39a844e40bcc0ab9b00fde2c835013) ([merge request](gitlab-org/gitlab!82169))
- [Move Geo repository updated event creation into a worker](gitlab-org/gitlab@d12d94cc3e35d6e0593e5639d2628a6f1d8b4f5d) ([merge request](gitlab-org/gitlab!80971)) **GitLab Enterprise Edition**
- [Migrate loading icon to be Pajamas compliant](gitlab-org/gitlab@9b70879b5dd948fdcacddb91a720658995cab83c) ([merge request](gitlab-org/gitlab!81985))
- [Migrate loading spinners](gitlab-org/gitlab@0382386fc0c5eb3f67bcd4ffc3c21ca85a5cb6b3) ([merge request](gitlab-org/gitlab!82334))
- [Move default branch protection to repository settings](gitlab-org/gitlab@1a8206261fbda415a12792893cf6e6277fd84bae) ([merge request](gitlab-org/gitlab!81012))
- [Migrate loading spinners](gitlab-org/gitlab@dc0024941f8766631a88768c206ccc19c51658d7) ([merge request](gitlab-org/gitlab!82324))
- [Update registration enabled callout](gitlab-org/gitlab@bb5253b2516dc17578d9bb05cf5e04d44028a547) ([merge request](gitlab-org/gitlab!80972))
- [Migrate loading spinners](gitlab-org/gitlab@a14c08ae439075b20874fdaa874812bfda4f2198) ([merge request](gitlab-org/gitlab!82238))
- [Iteration search uses cadence and iteration titles](gitlab-org/gitlab@2ef936654487e08fe3944bb5548302e3867253d5) ([merge request](gitlab-org/gitlab!81615)) **GitLab Enterprise Edition**
- [Display license ID retrieved from CustomersDot](gitlab-org/gitlab@6d9df1c3c44ca74bd8e4d23a7ed48f34dd898da0) ([merge request](gitlab-org/gitlab!82112)) **GitLab Enterprise Edition**
- [Re-introduce role-targeted broadcast messages](gitlab-org/gitlab@c7a8a89c7513b0951f6b0994fe7505b3a9100810) ([merge request](gitlab-org/gitlab!81232))
- [Use GlAvatar in security dashboard](gitlab-org/gitlab@c5ac6e5ea076ab5451c6a62cf9a3cc30fc0c665e) ([merge request](gitlab-org/gitlab!82172)) **GitLab Enterprise Edition**
- [Remove personal_project_owner_with_owner_access feature flag](gitlab-org/gitlab@ad3f27b2a70e29c026d5a92e834ec72462a1182a) ([merge request](gitlab-org/gitlab!82088))
- [Use the environment tier for jira connect deployment environment type](gitlab-org/gitlab@87a9dfa80b339fa71db4838fc76696b420c4dbff) by @alanandrade ([merge request](gitlab-org/gitlab!80539))
- [Add unique index for security training providers](gitlab-org/gitlab@8cfba7dbb1a7203de0b4998b14976e67e7753e75) ([merge request](gitlab-org/gitlab!82235))
- [Allow tags as target of pipeline scheduled](gitlab-org/gitlab@f6e9762d39ab883f33853a107057b5ed370e630b) by @KevSlashNull ([merge request](gitlab-org/gitlab!81476))
- [Migrate group/project member spinners](gitlab-org/gitlab@bfa13484ec47ece14aff14f0e3fba4b7c5f478a0) ([merge request](gitlab-org/gitlab!82225))
- [Migrate legacy spinner](gitlab-org/gitlab@02e6cb553e7338ca40d5e05f3c49593a201e5d4e) ([merge request](gitlab-org/gitlab!81840))
- [Disable multi-project viz for free users](gitlab-org/gitlab@d362c451cfeeca06ec04ba6f5d8c731a9a391f89) ([merge request](gitlab-org/gitlab!79889))
- [Update Import object persistence approach](gitlab-org/gitlab@489555c94e0e24467e12b5a2ef5b9375800d2e78) ([merge request](gitlab-org/gitlab!79963))
- [Correct text of Banner message label](gitlab-org/gitlab@24ed46db54b5196442e3742f91485d0ebc3c8437) ([merge request](gitlab-org/gitlab!81221)) **GitLab Enterprise Edition**
- [Remove non-human created tokens from PAT list](gitlab-org/gitlab@7b893669b389b340759877d11c329dbff305759c) ([merge request](gitlab-org/gitlab!80716)) **GitLab Enterprise Edition**
- [Remove non-human created tokens from PAT list](gitlab-org/gitlab@34ded80954ee5e3c966c6602bb24b6feb00d0555) ([merge request](gitlab-org/gitlab!80716)) **GitLab Enterprise Edition**
- [Update maximum allowable lifetime message for PAT](gitlab-org/gitlab@5c71c8adc2c36c47fbc4303e9a89d95c27a85807) ([merge request](gitlab-org/gitlab!81949)) **GitLab Enterprise Edition**
- [Disable the PA commit button when there are no changes](gitlab-org/gitlab@632aefed5070daeb034e127c2df5edf27d59e633) ([merge request](gitlab-org/gitlab!81531))
- [Add the "Support Ukraine" tanuki](gitlab-org/gitlab@72585cf30f5ef613bb3056e93e12985a69f82e3b) ([merge request](gitlab-org/gitlab!82050))
- [Link new issue to original via checkbox](gitlab-org/gitlab@4c30e09e1b3b8b84bce36770ce59a351bd87fedb) by @smokris ([merge request](gitlab-org/gitlab!80556))
- [Migrate gfm loading spinner](gitlab-org/gitlab@f79d23fc39b1e83211ae426d28c10ac40dc5b743) ([merge request](gitlab-org/gitlab!82111))
- [Use report-declared version of the schema](gitlab-org/gitlab@0ecb51dee1eae742f8c0e294f1ef68468fb37324) ([merge request](gitlab-org/gitlab!81907)) **GitLab Enterprise Edition**
- [Migrate MAINTAINER access memberships to OWNER](gitlab-org/gitlab@0ff770b001fe3c6f3766a8fd32bbdcac17c70439) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/80146))
- [Surface validation errors as warnings](gitlab-org/gitlab@855c036adebba757cdbc928259288d6b66521867) ([merge request](gitlab-org/gitlab!80930)) **GitLab Enterprise Edition**
- [Migrate loading icon](gitlab-org/gitlab@a66ddd653a41b6e549a590218d004b7f1399e744) ([merge request](gitlab-org/gitlab!82042))
- [Geo secondary proxying: serve assets locally](gitlab-org/gitlab@c350122401906ee1c74066b96f71b721b72dd222) ([merge request](gitlab-org/gitlab!79761)) **GitLab Enterprise Edition**
- [Replace n/a with a hyphen in the runners table](gitlab-org/gitlab@69ac20935dd4ed56e8b9a5fedd56f2d013bf7fa7) ([merge request](gitlab-org/gitlab!81904))
- [Update Secret Detection template](gitlab-org/gitlab@ef2904cd4e61c386fc6c8a040e6a806e23c7a9f8) ([merge request](gitlab-org/gitlab!80326))
- [Add alert and disable active checkbox](gitlab-org/gitlab@fd5388c670b38f483d9458cf9a9300b60f6c072a) ([merge request](gitlab-org/gitlab!81896))
- [Improve UI text of sign-in restrictions](gitlab-org/gitlab@9a1f8721ed0b8c87258194323d5d4b443b0e92f2) ([merge request](gitlab-org/gitlab!81776))
- [Put deprecated serverless features behind feature flag](gitlab-org/gitlab@ef88f5c53871d6c7ad795887751381f0276de1ea) ([merge request](gitlab-org/gitlab!81493))
- [Add BlocksUnsafeSerialization to Project](gitlab-org/gitlab@9b3f3d30f385f6fe1c972a5b91b8d6bda9dc7426) ([merge request](gitlab-org/gitlab!81900))
- [Add default_branch to KAS responses](gitlab-org/gitlab@73788fa265be7c6bcc2852e64ee07f4e7f3b06af) ([merge request](gitlab-org/gitlab!81950))
- [Use GlButtonGroup instead of GlSegmentedControl](gitlab-org/gitlab@4f5a1079ea2b6c96c5d62dd3a8b7323e927b103a) ([merge request](gitlab-org/gitlab!81278)) **GitLab Enterprise Edition**
- [Change loading state jobs tab](gitlab-org/gitlab@a1dcec6771d3d65c477b94e7fa8d9425e40db8c7) ([merge request](gitlab-org/gitlab!81568))
- [Increase pipeline editor debounce to 500ms](gitlab-org/gitlab@c6de5d893856852b8ea23c38199eb6e63c42a3e1) ([merge request](gitlab-org/gitlab!81534))
- [Set danger variant and label to delete WA Device](gitlab-org/gitlab@5a2e927aed0c8ad2d30d1b02fee19dceec5dd850) ([merge request](gitlab-org/gitlab!81868))
- [Set danger variant and label to destroy oauth app](gitlab-org/gitlab@45ced1f5836302b14801af57624058ed71c241d0) ([merge request](gitlab-org/gitlab!81854))
- [Set variants and labels to abuse report buttons](gitlab-org/gitlab@fce6201af9a961ecafa023b07b21665bfbde3228) ([merge request](gitlab-org/gitlab!81871))
- [Set danger variant to delete artifact button](gitlab-org/gitlab@94a283f6447149ed9bae4c81f7d21966f86959c5) ([merge request](gitlab-org/gitlab!81877))
- [Set danger variant & labels for appearance buttons](gitlab-org/gitlab@8c3b077aee8e6f1270a07f8f721d44b3dde21cf8) ([merge request](gitlab-org/gitlab!81878))
- [Improve Sourcegraph settings text](gitlab-org/gitlab@da795bdf58234910ce2c3a1339cf1dfe863292d6) ([merge request](gitlab-org/gitlab!81223))
- [Remove pipeline editor button from blob view](gitlab-org/gitlab@932a7de395f0ed97d2e9545677e591040aad99a4) ([merge request](gitlab-org/gitlab!81903))
- [Refine copy for Jira integration](gitlab-org/gitlab@c9e336f4811de2e32ca79f3bf2ada1996a1fb259) ([merge request](gitlab-org/gitlab!81819))
- [Project quality summary: add test runs empty state](gitlab-org/gitlab@bbe504d8f0b499f1b21e22ed60e112078141465f) ([merge request](gitlab-org/gitlab!78498))
- [Backfill `member_namespace_id` for `GroupMember`](gitlab-org/gitlab@019e70a88d1abddc2b590eb6ba7e9cb0b95c1370) ([merge request](gitlab-org/gitlab!78715))
- [Merge branch 'user-validation-failed-message' into 'master'](gitlab-org/gitlab@6d582ea07e7b560945f4d89b56802f62920d5657) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/80304))
- [Improve user validation failed message](gitlab-org/gitlab@8a37bdae51be4f7c283bf37e2d984f948e020c3c) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/80304))
- [Remove releases with NULL tags and add not-NULL constraint](gitlab-org/gitlab@9896cafbbcbb9ca8dc8febe96d1ad14d636d1279) ([merge request](gitlab-org/gitlab!80664))
- [Replace success with confim variant](gitlab-org/gitlab@3f0c7a8e2a5f7c1580cbbcb34e7deb274572fdab) ([merge request](gitlab-org/gitlab!81837))
- [Suggest backend reviewer for erb and haml files](gitlab-org/gitlab@0ef97f29b696626cdd380e56f67a52d35878c9e3) ([merge request](gitlab-org/gitlab!81542))
- [Add Gitlab.revision to Gitlab::JsonCache cache_key by default](gitlab-org/gitlab@5cd29114c5846471e053577198cb9ad5942a3e1a) ([merge request](gitlab-org/gitlab!81413))
- [Replace window.confirm with GlModa in environment actions](gitlab-org/gitlab@94ec1ed345e5db641956a33b2cc97bb618f38203) ([merge request](gitlab-org/gitlab!80425))
- [Use instrumentation classes for Service Ping generation](gitlab-org/gitlab@22174f888e7cc8853bf698d413a9585b81d151ad) ([merge request](gitlab-org/gitlab!81520))
- [Remove null constraint from security_scan_succeeded column](gitlab-org/gitlab@cc442d0ddbb132fe2b7ac52105ac7e54379b9bd0) by @svdj ([merge request](gitlab-org/gitlab!81322))
- [Improve the labels on Kubernetes Agent UI](gitlab-org/gitlab@7a78b512e7f825dd31cef0e429669c93e7fb4584) ([merge request](gitlab-org/gitlab!81606))
- [Expose created_at when serializing Deployment Approvals](gitlab-org/gitlab@428038a04d30bf048b10de1a2acae4e913a1069a) ([merge request](gitlab-org/gitlab!81487)) **GitLab Enterprise Edition**
- [Split rebase action buttons into two separate buttons](gitlab-org/gitlab@696f7462255c2604f97a46ab6472b895aadd4465) by @KevSlashNull ([merge request](gitlab-org/gitlab!81335))
- [Reword 'build' to 'pipeline' in todos](gitlab-org/gitlab@fee372c20e83539ae5e9b41ce03181eb87a9fc9f) by @KevSlashNull ([merge request](gitlab-org/gitlab!75901))
- [Update pipeline labels](gitlab-org/gitlab@ad48c74a8b0542b0db3f74aeff1eb32c9e48df89) ([merge request](gitlab-org/gitlab!81032))
- [Re-position the erase log button](gitlab-org/gitlab@54003d98518906d74c9b0f3484f695a631a78f19) ([merge request](gitlab-org/gitlab!81049))
- [Adjust incident list column widths and truncation ](gitlab-org/gitlab@b1b639c986813bfe9ee8e819156671c1a1ab6fdf) ([merge request](gitlab-org/gitlab!80645))
- [Replace the gitlab import haml modal with a GlModal](gitlab-org/gitlab@42bcf23bdcc38cfbc14ae1296aff949721df6689) ([merge request](gitlab-org/gitlab!80863))
- [Adds a notification for a future dated license](gitlab-org/gitlab@7fa25e26d01c92b7af3c731e4d494dc80ee4d2ab) ([merge request](gitlab-org/gitlab!77304)) **GitLab Enterprise Edition**
- [Use strong params for ProjectsController by default](gitlab-org/gitlab@8dc1b646fe9da7a95f74cfb2d9d51b72bdbed619) ([merge request](gitlab-org/gitlab!81392))
- [Update iteration lists](gitlab-org/gitlab@d72a96bf2bb35dd8a80bc674f1770500bcc84c20) ([merge request](gitlab-org/gitlab!78039)) **GitLab Enterprise Edition**
- [Improve accessibility on empty project page](gitlab-org/gitlab@747130b16d92231a506c86b1b7d46eac7f5dafa1) ([merge request](gitlab-org/gitlab!81265))
- [Use GlAvatar in operations dashboard](gitlab-org/gitlab@22b275427d636ae0b5ff3333ec5a660e62e02454) ([merge request](gitlab-org/gitlab!81233)) **GitLab Enterprise Edition**
- [Update trial status reminder design](gitlab-org/gitlab@2ef8e7b8049bf059241280b3906814a56120acd8) ([merge request](gitlab-org/gitlab!80611)) **GitLab Enterprise Edition**
- [Hide issue header dropdown button if there are no actions](gitlab-org/gitlab@e09446bbd1179cf7b9ad6d316d065e23a4bc2c77) by @KevSlashNull ([merge request](gitlab-org/gitlab!76055))
- [Use groups API for Approvals form by default](gitlab-org/gitlab@1722e7adc88ff3abe51fcf287f91dc293aa2dcd3) ([merge request](gitlab-org/gitlab!80933)) **GitLab Enterprise Edition**
- [Remove the VSA duration chart stage dropdown](gitlab-org/gitlab@a5a58e7e7aeb329ed261897c999817cc77b47816) ([merge request](gitlab-org/gitlab!80365)) **GitLab Enterprise Edition**
- [Introduce new jobs tab](gitlab-org/gitlab@573741bcde8a1e62231c820f8fe992f5ca01363a) ([merge request](gitlab-org/gitlab!79631))
- [Rate limit epic create service](gitlab-org/gitlab@de97dfabebb77f1cbcccc28f2217e92a9e8fbe55) ([merge request](gitlab-org/gitlab!80909)) **GitLab Enterprise Edition**
- [Use sentence case for trigger events](gitlab-org/gitlab@73c8339829e3004dcd7e951ebdf7f8e188a2002f) ([merge request](gitlab-org/gitlab!80899))
- [Remove GlAlert contained prop](gitlab-org/gitlab@4d4ae050480e41cc796908879c08bd02f53e8c7b) ([merge request](gitlab-org/gitlab!81167)) **GitLab Enterprise Edition**
- [Switched title to h1 on issues](gitlab-org/gitlab@62fe29f4c160b8b439503b1acc26fe44a2e17ad4) ([merge request](gitlab-org/gitlab!75248))
- [Improve Amazon EKS settings text](gitlab-org/gitlab@111b8f2c031b6bebd348682641112b02698960b3) ([merge request](gitlab-org/gitlab!81114))
- [Stop using type, and use type_new instead](gitlab-org/gitlab@3e6da3aaa23204f45b35b3698d07b984b9ed76ce) ([merge request](gitlab-org/gitlab!80065))
- [Drop show_diff_preview_in_email column](gitlab-org/gitlab@8395ee778260fa68fd4e6f956b4bcb3e9e064d55) ([merge request](gitlab-org/gitlab!81200))
- [Add aria-label and tooltip to the emoji picker](gitlab-org/gitlab@a59272bceca5f866fbb43dd02da1daa01b8c7d42) ([merge request](gitlab-org/gitlab!68297))
- [Update cleanup policy parameters](gitlab-org/gitlab@40398dffd2b17b93f8dca1807de08e12b9049f51) ([merge request](gitlab-org/gitlab!80809))
- [Increase text limit of maintainer_note field](gitlab-org/gitlab@9e754ee50718ccc95f4e28ec1f8509a20088e27e) ([merge request](gitlab-org/gitlab!81137))
- [Clear future subscriptions info on license destroy](gitlab-org/gitlab@80b5526d8fb38198773f41e9afc7d1f6b5714822) ([merge request](gitlab-org/gitlab!80330)) **GitLab Enterprise Edition**
- [Change button variant to confirm in Web IDE modals](gitlab-org/gitlab@b4603317985e5ec556bbd92f66f1f47f3418e0ee) ([merge request](gitlab-org/gitlab!80780))
- [Allow only topic names that are case insensitive unique](gitlab-org/gitlab@c98cb46f3378ebf7405a3e99f434ed8fb0fba271) by @wwwjon ([merge request](gitlab-org/gitlab!79826))
- [Return project delete errors](gitlab-org/gitlab@72d3dcf6c382c060ec0ac0cf376ff05eda8d355c) ([merge request](gitlab-org/gitlab!78500))
- [Replace GlSegmentedControl with GlDropdown](gitlab-org/gitlab@6d20f713f7a37fddc869b486ca0e543f71470441) ([merge request](gitlab-org/gitlab!81113))
- [Change the order column of topics to non_private_projects_count](gitlab-org/gitlab@99f6dfc88b70a531b695d9d54df2c6bb28ac293e) by @wwwjon ([merge request](gitlab-org/gitlab!80478))
- [Removed rate_limited_service_issues_create flag](gitlab-org/gitlab@e2e94cce73d89d27f11403eaa5bdce6f90ed59a4) ([merge request](gitlab-org/gitlab!80990))
- [Migrate create protected branch form to GlToggle](gitlab-org/gitlab@66ed251bb9dbe7defbec50f600a82855b084b6b1) ([merge request](gitlab-org/gitlab!80548))
- [Deprecate test reports relationship with requirements](gitlab-org/gitlab@bd97abee754fb3acd64a18845d77332df9c31ab7) ([merge request](gitlab-org/gitlab!78120)) **GitLab Enterprise Edition**
- [Update registry regex to allow 4 levels](gitlab-org/gitlab@410c970974170522ba87fc5b0cd52f00ce72863c) ([merge request](gitlab-org/gitlab!80929))
- [Validate NOT NULL on security_findings.uuid column](gitlab-org/gitlab@e0e968681363a80e1e17146aa6f073643d72eafc) ([merge request](gitlab-org/gitlab!80912))
- [Migrate edit protected branch form to GlToggle](gitlab-org/gitlab@1648af2459591cb3f86b4a2862feb4b94bc70b3c) ([merge request](gitlab-org/gitlab!80549))
- [Clean up feature flag publish_project_deleted_event to enable by default](gitlab-org/gitlab@4d49dff5001aa842e250bb42aa55dfd16154e63b) ([merge request](gitlab-org/gitlab!80875))
- [Default to delayed deletion for projects not in personal namespace](gitlab-org/gitlab@b420e180be529965e6e6111aa06be187d46d4cec) ([merge request](gitlab-org/gitlab!80139))
- [Enable scan_result_policy by default](gitlab-org/gitlab@d39e2c8a0756d2fc520e668137267aa021bde65e) ([merge request](gitlab-org/gitlab!80831)) **GitLab Enterprise Edition**
- [Append URL issue description to template](gitlab-org/gitlab@3a6ed05de16d6e5e0d705973785db400750dbd4e) by @smokris ([merge request](gitlab-org/gitlab!80554))
- [Remove fork_project_form feature flag](gitlab-org/gitlab@9e2d32da4ae18da3b441583c0b36e04726e536ae) ([merge request](gitlab-org/gitlab!77181))
- [Add SUPPORTED_VERSIONS and DEPRECATED_VERSIONS to SchemaValidator](gitlab-org/gitlab@d79f6b5bfbdac89e4d375e8fe5f76d22f39513c3) ([merge request](gitlab-org/gitlab!80498))
- [Update documentation for Usage quota](gitlab-org/gitlab@e039019fc82f899cb950dc7d12d398f17adceb93) ([merge request](gitlab-org/gitlab!80182))

### Deprecated (3 changes)

- [Deprecate VALIDATE_SCHEMA configuration variable](gitlab-org/gitlab@959c1422f429f8e7411a89eaff9119ffdd3b7159) ([merge request](gitlab-org/gitlab!82449))
- [Add deprecation notice to NetworkPolicyConnection](gitlab-org/gitlab@8337c8bb4da57a543c9a1312e4e7d953d870dfbb) ([merge request](gitlab-org/gitlab!82441)) **GitLab Enterprise Edition**
- [feat: Update SECURE_ANALYZER_PREFIX in all Sec Section templates](gitlab-org/gitlab@382bd94d9ef13b07603f29ce39b54b4699cf8f77) ([merge request](gitlab-org/gitlab!80342))

### Removed (10 changes)

- [Clean up import and other invite members modal rollout pieces](gitlab-org/gitlab@20f015094137ad2703d5116afbd55e7bf3cbb500) ([merge request](gitlab-org/gitlab!82821))
- [Untrack external_pull_requests row deletions](gitlab-org/gitlab@75ac2ecd0935b2969650bbff52c7fbc8eb343364) ([merge request](gitlab-org/gitlab!82476))
- [Remove support for unsafe regular expressions](gitlab-org/gitlab@4c75b10e3c9c7a0740d99dae0d4fea20bf48868e) ([merge request](gitlab-org/gitlab!79611))
- [Drop unused partitioned_foreign_keys table](gitlab-org/gitlab@42913c5ab28e980c244bbd42bfba4dd34bb4c2b1) ([merge request](gitlab-org/gitlab!82215))
- [Cleanup Code Quality Walkthrough experiment](gitlab-org/gitlab@2333b6ecc57cbdd95e69a7c30b254e7ba3ac44c0) ([merge request](gitlab-org/gitlab!82106))
- [Cleanup Ci Runner Templates experiment](gitlab-org/gitlab@6634d3a35dfd7bd3d5220de859f50b06e5a99f19) ([merge request](gitlab-org/gitlab!81168))
- [Remove :cluster_vulnerabilities feature flag](gitlab-org/gitlab@e7b5b39bbb1ebfe8012de88222c88b1fef4aa00a) ([merge request](gitlab-org/gitlab!81462)) **GitLab Enterprise Edition**
- [Clean up forcibly_show_trial_status_popover experiment](gitlab-org/gitlab@1b93b0c39b65422c07807b4f849778cbd0834efb) ([merge request](gitlab-org/gitlab!80413))
- [Remove `security_report_ingestion_framework` feature flag](gitlab-org/gitlab@db93cc96fe2ef4478531f7f27b212500b0b98df1) ([merge request](gitlab-org/gitlab!81021)) **GitLab Enterprise Edition**
- [Remove cache_shared_runners_enabled FF](gitlab-org/gitlab@ed2cd31564381453db86800027e5ff823fd53602) ([merge request](gitlab-org/gitlab!81143))

### Security (16 changes)

- [Set nosniff header on assets requests](gitlab-org/gitlab@72b2cb327beba926ad3a62af525521820d79f7a7) ([merge request](gitlab-org/gitlab!82563))
- [Default enable header_read_timeout_buffered_io](gitlab-org/gitlab@4dde99e1d90e7cb115d113a6cc132d11b7b65488) ([merge request](gitlab-org/gitlab!81910))
- [Escape branch names in push instructions](gitlab-org/gitlab@e1f3fd2be8b76cdd45e6f44615f5eed185a0844b) ([merge request](gitlab-org/gitlab!82448))
- [Create Error.rb, update ProcessPolicyService](gitlab-org/gitlab@e2250af72ad76e736d3adc5977a97af346570094) by @FacVain ([merge request](gitlab-org/gitlab!79667)) **GitLab Enterprise Edition**
- [Add Integration.encrypted_properties](gitlab-org/gitlab@0ee6c61d8051661ffbc789f1af81a5c63c412fed) ([merge request](gitlab-org/gitlab!80219))
- [Warn when snippet contains unretrievable files](gitlab-org/gitlab@f9dc8a613d6fe05c55f9384141597a2664210c24)
- [Change runners_token prefix for Group and Project](gitlab-org/gitlab@08873630734bdd1efbcf7eb9b0e334c7b3babcb0)
- [Add runners_token prefix to Group and Project](gitlab-org/gitlab@518468d38df9bf0d62ede1f70f383d495ed333a0)
- [Only expose `id` and `name` attributes when serializing deploy token](gitlab-org/gitlab@b893d583b15e68ed8065148773165d79c5fce7ec) ([merge request](gitlab-org/gitlab!81587))
- [Prevent DOS when rendering math markdown](gitlab-org/gitlab@40b1b67a4c437304ab4646207cb5bbb420ce9ec8)
- [Limit commands_changes to certain keys](gitlab-org/gitlab@ae5a7735ffebfeed8d99e266a41a196eca0d60c2)
- [Reset password field on page load](gitlab-org/gitlab@76b35cdba11c280a29f89af3dfbb395a9af44f99)
- [Check permission when creating members through service](gitlab-org/gitlab@2063a3b626e9927380633603719a3c6bbe9dc447)
- [Check for unsafe characters in email addresses before sending](gitlab-org/gitlab@97f804b394ee1e2b36972b12240d27c7ad1bc671)
- [Anonymous user can enumerate all users through GraphQL endpoint](gitlab-org/gitlab@8e550ad519d1c74f82b8e3f900a212ffb495e626)
- [Exif metadata not stripped when uploading image attachments via Emails](gitlab-org/gitlab@5dd9cc8fe85e0435db0891e22b22dc58ebb824d7) ([merge request](gitlab-org/gitlab!80735))

### Performance (10 changes)

- [Improve performance of group releases endpoints](gitlab-org/gitlab@c259d6af344b1016cb332f1683d24fcba4353125) ([merge request](gitlab-org/gitlab!80093))
- [Load highlight.js languages asynchronously](gitlab-org/gitlab@6b881013f3b8152d2a10138118eef91f6d872595) ([merge request](gitlab-org/gitlab!82638))
- [Add index on releases table to resolve cicd settings page timeout](gitlab-org/gitlab@74e0a1394f144ed0e4cf2c2000574ee8a0f3cfc9) ([merge request](gitlab-org/gitlab!82506))
- [Fix slow query for "All" tabs in "Your projects" activity page](gitlab-org/gitlab@c12eb806b05da2abfd282e3c9fd5bf7058b4e7cf) ([merge request](gitlab-org/gitlab!82296))
- [Drop old index for security ci builds on name and id parser](gitlab-org/gitlab@7e03d6ad1bbbcc861f8e5e4a6ec815db7c1c5c3f) ([merge request](gitlab-org/gitlab!82354))
- [Create new index for security ci builds with new features](gitlab-org/gitlab@fdd7c1db3d5b1086a72e29b0f5bd1b202d121637) ([merge request](gitlab-org/gitlab!82047))
- [Recreate index for security builds to include fuzzing jobs](gitlab-org/gitlab@c49556695136d525f05bc4eef0c9af1146d9d958) ([merge request](gitlab-org/gitlab!81586))
- [Schedule async weekend build of index for job traces](gitlab-org/gitlab@1487cf22f9cc62cd872b4f34584fe5feba6daca3) ([merge request](gitlab-org/gitlab!81341))
- [Decrease the default fast statement timeout](gitlab-org/gitlab@f4590fd25760f9a2faa3f83b8d8364b85404a1a3) ([merge request](gitlab-org/gitlab!81270))
- [GlTableLite in favor of GlTable for runners list](gitlab-org/gitlab@eff40efc7d434ae03a57b348a8cd8b4d78591750) ([merge request](gitlab-org/gitlab!80928))

### Other (82 changes)

- [Adjust NullifyOrphanRunnerIdOnCiBuilds batch parameters](gitlab-org/gitlab@4c0efcd32868b6bdb156f3d692a3ed9bf2388a72) ([merge request](gitlab-org/gitlab!83094))
- [Remove duplicate releases from projects](gitlab-org/gitlab@81a5a6f417922316a4a9d45fe8f6d22b34be3ae3) ([merge request](gitlab-org/gitlab!82335))
- [Pass formats explicitly when rendering .html format](gitlab-org/gitlab@0481fdffaa0f0b591f4c4513976ab9b5350e7e92) by @edith007 ([merge request](gitlab-org/gitlab!75784))
- [Complete environments `GET` API docs](gitlab-org/gitlab@dd75643207db136116dce6d969710e4f6adf95cc) by @tuxtimo ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/82980))
- [Add statistics seats card](gitlab-org/gitlab@b7e33581018e9ffa955a250a77a9d43394c1b069) ([merge request](gitlab-org/gitlab!80260)) **GitLab Enterprise Edition**
- [Remove `maxlength` limit from the project description textarea](gitlab-org/gitlab@8089d69fd4dcab624b39e5c05b35de37c0834f62) ([merge request](gitlab-org/gitlab!82812))
- [Add support for relating epics](gitlab-org/gitlab@0a36bbc54b9db652e4f9a3d2b6d770936371f6b8) ([merge request](gitlab-org/gitlab!82128)) **GitLab Enterprise Edition**
- [Revert changes about moving methods to base class](gitlab-org/gitlab@88ad6814dfd0c17c1ea78609de30fd6897957e9a) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/82849)) **GitLab Enterprise Edition**
- [Add list related epic links API documentation](gitlab-org/gitlab@709930602b75acce740056bfefb806ce2ad4e208) ([merge request](gitlab-org/gitlab!82628))
- [Remove restrict_special_characters_in_project_path feature flag](gitlab-org/gitlab@9aa12e3b7d5e485fd94fcec3b06cbb4906b52480) ([merge request](gitlab-org/gitlab!82807))
- [Update import manifest alert](gitlab-org/gitlab@a15c7181b47acdc661a29e34690d9908ba2ae440) ([merge request](gitlab-org/gitlab!82761))
- [Update gcp signup offer to alert partial](gitlab-org/gitlab@f05cb91d5142b1d699e8e0f9bb5876fb8e61100e) ([merge request](gitlab-org/gitlab!82759))
- [Update runner edit alert to use partial](gitlab-org/gitlab@b661d85b502b634f331d9175b2b5d40737abe90d) ([merge request](gitlab-org/gitlab!82758))
- [Fix GraphQL/FieldMethod offense (Part 1/2)](gitlab-org/gitlab@ff8b0e5be942f5b8d1de67e19ac28d2180d10c3e) by @KevSlashNull ([merge request](gitlab-org/gitlab!76020))
- [Remove dependency list usage data from Redis](gitlab-org/gitlab@91b4a64615b667331cc1ee8407e623c2e520103e) ([merge request](gitlab-org/gitlab!82604)) **GitLab Enterprise Edition**
- [Remove corpus management feature flags](gitlab-org/gitlab@b504880a7f839d48025938fe632269a1be926cc8) ([merge request](gitlab-org/gitlab!82463)) **GitLab Enterprise Edition**
- [Fix artifacts with wrong expire_at date](gitlab-org/gitlab@bbc5329a58bd25c629ac9f318b92e3b37c16db08) ([merge request](gitlab-org/gitlab!82084))
- [Update data in batches while deleting a user](gitlab-org/gitlab@049a428c8e008f822d79011cbd978456a40a9751) ([merge request](gitlab-org/gitlab!81429)) **GitLab Enterprise Edition**
- [Document performance implication of the feature flags](gitlab-org/gitlab@bfce1da9a755c3a62844cc62022a27d65be23464) ([merge request](gitlab-org/gitlab!81880))
- [Remove real-time feature flags](gitlab-org/gitlab@ea7853ac062b234a13444b0a92da773ce1b2f0b4) ([merge request](gitlab-org/gitlab!82378))
- [Move reactive cache methods to base class](gitlab-org/gitlab@0e91a796b8ca11be25284a12cfceb8f19ade63e9) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/82442)) **GitLab Enterprise Edition**
- [This enables the pipeline_schedules_with_tags feature flag](gitlab-org/gitlab@ed19925c1b86a58044047fe721e7aedd5ec95171) ([merge request](gitlab-org/gitlab!82428))
- [Remove the invite members modal feature flag](gitlab-org/gitlab@f953bfffaa7c46aa0cb0d3d7ed1b63df0f2e7be3) ([merge request](gitlab-org/gitlab!81940)) **GitLab Enterprise Edition**
- [Remove feature flag `project_owners_list_project_pending_deletion`](gitlab-org/gitlab@323e070bb6208855509c87f5c894c5e105b0141b) ([merge request](gitlab-org/gitlab!82372)) **GitLab Enterprise Edition**
- [Update Web IDE copy](gitlab-org/gitlab@0b8d1bae9702cc0be39ccb4715f31c5c0585a050) ([merge request](gitlab-org/gitlab!82256))
- [Add dispensable_render methods](gitlab-org/gitlab@1780145c511648bd7811e0f617a14d98f1e37be9) ([merge request](gitlab-org/gitlab!81546))
- [Remove ci_pipeline_merge_request_presence_check feature flag](gitlab-org/gitlab@3b06ee0014336480b7c180a1821b2b964db9250b) ([merge request](gitlab-org/gitlab!82107))
- [Remove default_merge_ref_for_diffs feature fflag](gitlab-org/gitlab@2608f81c4d52d751c4390b33fd7042292d622765) ([merge request](gitlab-org/gitlab!82069))
- [Remove rearrange_pipeline_table feature flag](gitlab-org/gitlab@6ace75f59f3c42abdfdf8a9078e02308a097a914) ([merge request](gitlab-org/gitlab!81924))
- [Add RelatedEpicsLinks::DestroyService](gitlab-org/gitlab@b6da269cf095fdd82dcd56a1e1a0f469caf5e80d) ([merge request](gitlab-org/gitlab!81610)) **GitLab Enterprise Edition**
- [Ignore requirements_management_test_reports.requirement_id column](gitlab-org/gitlab@778ffb36ec8eaa10ec9791aadc7806b707dcdb5d) ([merge request](gitlab-org/gitlab!82134)) **GitLab Enterprise Edition**
- [Add nullify job for orphan runner_id columns of ci_builds](gitlab-org/gitlab@b44fac47468e79efb2ec92a4dd0326ef9a489d11) ([merge request](gitlab-org/gitlab!81410))
- [Rerun ConvertStringifiedRawMetadataHashToJson inline](gitlab-org/gitlab@1e4c6529f3d862b830e5ce524ba27ffee80e4617) ([merge request](gitlab-org/gitlab!80768))
- [Update GlAlert in security dashboard table](gitlab-org/gitlab@f9211802661ed7de62113dfb7cc3983dee402975) ([merge request](gitlab-org/gitlab!82014)) **GitLab Enterprise Edition**
- [Fix GraphQL/OrderedFields offenses](gitlab-org/gitlab@321b3ca23e7efb069ecd6346da6e0684b1f68de7) by @edith007 ([merge request](gitlab-org/gitlab!81469))
- [Remove context_commits feature flag](gitlab-org/gitlab@960ccee0fc4962bb2c0cfb88fd94313366b5b710) ([merge request](gitlab-org/gitlab!80881))
- [Remove deprecated package application setting](gitlab-org/gitlab@e3e1cdd682037dd65b34e7ef84b42332510a2adc) ([merge request](gitlab-org/gitlab!80842))
- [Remove feature flag for bulk inserting job tags](gitlab-org/gitlab@f78b53e0fb59848b54b89cce8025963a1d5cca87) ([merge request](gitlab-org/gitlab!79243))
- [Cleanup back-filling CI queuing tables migration](gitlab-org/gitlab@af8fa00f4ceb2fb2e02658a2715c059136a5a3f7) ([merge request](gitlab-org/gitlab!81602))
- [Fix GraphQL/OrderedFields offenses](gitlab-org/gitlab@868a9d2575c2883f32e2ae5cf419ace538cc7bec) by @edith007 ([merge request](gitlab-org/gitlab!81474))
- [Fix GraphQL/OrderedFields offenses](gitlab-org/gitlab@0ec8ab44613d558ead33856d283d2d902ccf0eb0) by @edith007 ([merge request](gitlab-org/gitlab!81466))
- [Fix GraphQL/OrderedFields offenses](gitlab-org/gitlab@def8caf919ad9712b43d2047e74934f821624db2) by @edith007 ([merge request](gitlab-org/gitlab!81478))
- [Remove snippets_binary_blob FF](gitlab-org/gitlab@ca06b30a7eaa1629a87535084d3a8759c55e9c91) ([merge request](gitlab-org/gitlab!81827))
- [Remove usage_data_i_snippets_show FF](gitlab-org/gitlab@32ae392e789989f35f30b8288b51ca5d6b5ade61) ([merge request](gitlab-org/gitlab!81822))
- [Implement Gitlab mirror scheduling tracker](gitlab-org/gitlab@b1194aa8a9af09e9eb6e6f0bc84d3654754232e8) ([merge request](gitlab-org/gitlab!81249))
- [Add certificate_based_clusters FF to Service Ping](gitlab-org/gitlab@33601c638476cbb671f46dde724939dda85c20e6) ([merge request](gitlab-org/gitlab!81311))
- [danger: Use changelog rule from gitlab-dangerfiles](gitlab-org/gitlab@59d5f1b34b23fd573ce1d506cc8e98ab34a61c57) ([merge request](gitlab-org/gitlab!81290))
- [Resolve Rails/LinkToBlank rubocop offenses](gitlab-org/gitlab@04fd3292dfdd8764e8503639ddb09572b5a321ec) by @edith007 ([merge request](gitlab-org/gitlab!81397)) **GitLab Enterprise Edition**
- [Resolve Rails/IndexBy rubocop offenses](gitlab-org/gitlab@6ad4f10a77aa5b3c422f6dc38278125b37f08641) by @edith007 ([merge request](gitlab-org/gitlab!81391)) **GitLab Enterprise Edition**
- [Fix Rails/SaveBang offenses](gitlab-org/gitlab@36fc826acad51070955162828969bcd39a058f60) by @edith007 ([merge request](gitlab-org/gitlab!81246)) **GitLab Enterprise Edition**
- [Remove feature flag `group_merge_request_approval_settings_feature_flag`](gitlab-org/gitlab@ef2be58240abeb54263d31696844b614ecb4ba37) ([merge request](gitlab-org/gitlab!81252)) **GitLab Enterprise Edition**
- [Move shared code for related epic links](gitlab-org/gitlab@1881821dbcccac5eecd9ea7f3c57d5dedfb03fca) ([merge request](gitlab-org/gitlab!81320)) **GitLab Enterprise Edition**
- [Remove the `container_expiration_policies_historic_entry` feature flag](gitlab-org/gitlab@2a1259f2137db65b3e068cccafa9c8c182fe1dcc) ([merge request](gitlab-org/gitlab!80826))
- [Fix GraphQL/OrderedFields offenses](gitlab-org/gitlab@1c211096525e7bde3f65e2cace007e2ec47d00ca) by @edith007 ([merge request](gitlab-org/gitlab!81481))
- [Fix GraphQL/OrderedFields offenses](gitlab-org/gitlab@a39986e8dda55b1ee8c7c797245b60eb07a02974) by @edith007 ([merge request](gitlab-org/gitlab!81471))
- [Fix GraphQL/OrderedFields offenses](gitlab-org/gitlab@5f9d3afd383f43e9870b3943371e41c0c65e540c) by @edith007 ([merge request](gitlab-org/gitlab!81467))
- [Fix GraphQL/OrderedFields offenses](gitlab-org/gitlab@aea3aec7de86702e490a7e3a2acbdc7c35bbbfe7) by @edith007 ([merge request](gitlab-org/gitlab!81414)) **GitLab Enterprise Edition**
- [Fix GraphQL/OrderedFields offenses](gitlab-org/gitlab@a7b989d814f7851aec719ace35665dbd9c63c06a) by @edith007 ([merge request](gitlab-org/gitlab!81428))
- [Fix GraphQL/OrderedFields offenses](gitlab-org/gitlab@85c0032cbb3f94370d4498814f177d7224838bef) by @edith007 ([merge request](gitlab-org/gitlab!81425)) **GitLab Enterprise Edition**
- [Support load timings for non-Chromium browsers](gitlab-org/gitlab@fdbde7c998b42d8622c0dfe7ce3c5f1da2c09600) by @davebarr ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/81260))
- [Resolve Rails/ShortI18n rubocop offenses](gitlab-org/gitlab@481b3bc0b13ca8e7d50cc142de4186aa572dff2c) by @edith007 ([merge request](gitlab-org/gitlab!81399))
- [Migrate projects create from template page to GlTabs](gitlab-org/gitlab@a607d8131003415c479e74ec2ded124ea2d252b8) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/81254))
- [Memoize group secret variables on the variables builder](gitlab-org/gitlab@669cedbbd7e4d0f6e55ca4dc5ed30767db35b065) ([merge request](gitlab-org/gitlab!79936))
- [Resolve Performance/Sum rubocop offenses](gitlab-org/gitlab@c223a6021f565fea96b3fbae4ee7c59b2b1738b5) by @edith007 ([merge request](gitlab-org/gitlab!81350)) **GitLab Enterprise Edition**
- [Resolve Performance/DeleteSuffix rubocop offenses](gitlab-org/gitlab@fd5987e7ff762dacc6a78f8b025635bd9058ae4c) by @edith007 ([merge request](gitlab-org/gitlab!81344))
- [Remove feature flag for Group Projects API Plan Preloading](gitlab-org/gitlab@79469788adb49b64cc6bcb09c1f3ac8aac7b3e67) ([merge request](gitlab-org/gitlab!81324)) **GitLab Enterprise Edition**
- [Show an IPv6 sample in placeholder text](gitlab-org/gitlab@3f626453daca70c0df3a2b28708545c93302f61e) ([merge request](gitlab-org/gitlab!80792)) **GitLab Enterprise Edition**
- [Fix GraphQL/OrderedArguments offense (Part 6/6)](gitlab-org/gitlab@8d7a0608a4be68f3f650c9ea986427d869f4cb40) by @KevSlashNull ([merge request](gitlab-org/gitlab!76028))
- [Add advanced_search metrics to the dictionary](gitlab-org/gitlab@66057046f073a33b9f9c618e6fc5dee7dbb4af53) ([merge request](gitlab-org/gitlab!81003)) **GitLab Enterprise Edition**
- [Rename usage column in storage projects-list](gitlab-org/gitlab@eb69a2db015389981355328a52e572f64c9b484e) ([merge request](gitlab-org/gitlab!81144)) **GitLab Enterprise Edition**
- [Set worker resource boundary for ImportRequirementsCsvWorker](gitlab-org/gitlab@5f23bc1dced38334e2a14de7232dfcb805c48b7c) by @edith007 ([merge request](gitlab-org/gitlab!81229)) **GitLab Enterprise Edition**
- [Clean up roadmap_settings feature flag](gitlab-org/gitlab@fb7bd832a5c9bdbd6318c744a1d6618b209e6481) ([merge request](gitlab-org/gitlab!80975))
- [Fix GraphQL/FieldDefinitions offense (Part 4/4)](gitlab-org/gitlab@f06a2c460efb3cebf087be61c8393b8e49c05137) by @KevSlashNull ([merge request](gitlab-org/gitlab!76017))
- [Fix GraphQL/OrderedArguments offense (Part 5/6)](gitlab-org/gitlab@210baf44a6eb8c254261119b30022d3f30f5734c) by @KevSlashNull ([merge request](gitlab-org/gitlab!76027))
- [Simplify container repository delete tags services](gitlab-org/gitlab@67e8cf3f8308b14615d1f30d8afdca973f4f8b9b) by @edith007 ([merge request](gitlab-org/gitlab!81187))
- [Make labels sort dropdown pajamas compliant](gitlab-org/gitlab@47dee9f25e1e7cb23fb0fb4863465a8fc35ac81c) ([merge request](gitlab-org/gitlab!80702))
- [Fix Style/OpenStructUse offenses in auth provider specs](gitlab-org/gitlab@cad9f4cccf016bbabcbbef18d042ee4a0bb079f8) by @edith007 ([merge request](gitlab-org/gitlab!75277))
- [Remove the generic_packages feature flag](gitlab-org/gitlab@a6b06521df3d9beffdfbdb02146990c4c813da0e) ([merge request](gitlab-org/gitlab!80886))
- [Remove delegate as it's redundant due to SimpleDelegator](gitlab-org/gitlab@46d5c76e0b953bc004cb6a4656a8e0f8dd8842ee) by @edith007 ([merge request](gitlab-org/gitlab!75883))
- [Remove unneeded override in Ci::PipelinePresenter](gitlab-org/gitlab@35ae95950999d2efbbc35fc9076335ed2afffd3f) by @edith007 ([merge request](gitlab-org/gitlab!75854))
- [Clean up issue_boards_filtered_search feature flag](gitlab-org/gitlab@a97ed09ffb0d88007b21a314ab48b2e50d7c4bfa) ([merge request](gitlab-org/gitlab!80771))
- [Add table for storing issue tsvector](gitlab-org/gitlab@ceabf5a8ad0d67768b05a58a84b242495645a57c) ([merge request](gitlab-org/gitlab!71913))

## 14.8.6 (2022-04-29)

### Security (14 changes)

- [Update Import/Export merge/push access levels & exclude ci config path](gitlab-org/security/gitlab@abfa8d4c128316b1ba095ff8eda7e86018e47caf) ([merge request](gitlab-org/security/gitlab!2372))
- [Prevent maintainers from editing PipelineSchedule](gitlab-org/security/gitlab@761a7777cb480d02b9c3418aa7317eba7c0eaff1) ([merge request](gitlab-org/security/gitlab!2423))
- [Add validation to pypi file sha256 values](gitlab-org/security/gitlab@712cc01aee2be4b6a9847746a080f190041367d5) ([merge request](gitlab-org/security/gitlab!2417))
- [Conan Token uses PAT rather than ID in payload](gitlab-org/security/gitlab@ba3070c90dd1b575982df22c256b0e3f97a9e919) ([merge request](gitlab-org/security/gitlab!2346))
- [[security] Fix markdown API disclosing issue titles of limited projects](gitlab-org/security/gitlab@fd3cb263e8f165a4a1a7894c08ddf254f9cf1e92) ([merge request](gitlab-org/security/gitlab!2405))
- [Verify that mentioned user can read TODO's note](gitlab-org/security/gitlab@e54be58cc79011d7c79dae94b993774ab36ef232) ([merge request](gitlab-org/security/gitlab!2398))
- [Invalidate markdown cache to clear up stored XSS](gitlab-org/security/gitlab@160cdda98c80e052abbb4bec226ad63fe9c9e403) ([merge request](gitlab-org/security/gitlab!2420))
- [Allow rate limiting of deploy tokens](gitlab-org/security/gitlab@78f7ee3d7e1258375ddcea3a20e3798092e89d41) ([merge request](gitlab-org/security/gitlab!2385))
- [Add suffix to cache name to add isolation](gitlab-org/security/gitlab@184d49640f5dcc4ac1522c874a7b5e0c16d2e05f) ([merge request](gitlab-org/security/gitlab!2373))
- [Disable wiki access with CI_JOB_TOKEN when improper access level](gitlab-org/security/gitlab@db93d134394675a4335c92557a55ac4381ed303f) ([merge request](gitlab-org/security/gitlab!2391))
- [Sanitize error input to prevent HTML/CSS injection in messages](gitlab-org/security/gitlab@333dd602091810639912702c80034468ff6f8aa0) ([merge request](gitlab-org/security/gitlab!2378))
- [Secure debug trace artifact download](gitlab-org/security/gitlab@266d812ba2e8e9936269323465c867983e3a2ebf) ([merge request](gitlab-org/security/gitlab!2367))
- [Use password type for all secret integration properties](gitlab-org/security/gitlab@eda2b8f02b34ead354ef07b9e41be006cf90f51b) ([merge request](gitlab-org/security/gitlab!2411))
- [Limit CI job group_name regexp](gitlab-org/security/gitlab@03ab6e9f312fb6fe50a6361f7bc78d527b223b96) ([merge request](gitlab-org/security/gitlab!2381))

## 14.8.5 (2022-03-31)

### Security (21 changes)

- [Update to commonmarker 0.23.4](gitlab-org/security/gitlab@51532ccc5f1b6b053d4ca6c54496607e62f8f25c) ([merge request](gitlab-org/security/gitlab!2282))
- [Revert merge request approval groups behavior](gitlab-org/security/gitlab@dd9724e429033974da6c3852dc6fd33f0f2b0a46) ([merge request](gitlab-org/security/gitlab!2334))
- [Disallow login if password matches a fixed list](gitlab-org/security/gitlab@6779d5f2948425a7ad7f19a6e10f82cc10b80989) ([merge request](gitlab-org/security/gitlab!2358))
- [Update devise-two-factor to 4.0.2](gitlab-org/security/gitlab@0329d2d82a9064c0bae36e7b993ee40df7c999bc) ([merge request](gitlab-org/security/gitlab!2350))
- [Limit the number of tags associated with a CI runner](gitlab-org/security/gitlab@8d5938c08fe66c22f1bc54ff76cc9daf2de86b1a) ([merge request](gitlab-org/security/gitlab!2302))
- [GitLab Pages Security Updates for 14.9](gitlab-org/security/gitlab@5a5a862c8a9e37ca2ea84133f92b216eaa7cd148) ([merge request](gitlab-org/security/gitlab!2328))
- [Upgrade swagger-ui dependency](gitlab-org/security/gitlab@afcb570867db61347bb6a4e243bb2557340191be) ([merge request](gitlab-org/security/gitlab!2337))
- [Modify release link format check to avoid regex if string is too long](gitlab-org/security/gitlab@a3ab0ff9c470c1c6e5b4fd055ddd02dffce32652) ([merge request](gitlab-org/security/gitlab!2243))
- [Masks variables in error messages](gitlab-org/security/gitlab@94236bbdb8eef6600562bdc4e242e07eaed8c50f) ([merge request](gitlab-org/security/gitlab!2291))
- [Escape user provided string to prevent XSS](gitlab-org/security/gitlab@03e695d4c34546582b503b3f7712246206b56b99) ([merge request](gitlab-org/security/gitlab!2314))
- [Monkey patch of RDoc to prevent Ruby segfault](gitlab-org/security/gitlab@14eec4487387bc0c999f1c48b046a3ed3848c5a1) ([merge request](gitlab-org/security/gitlab!2232))
- [Project import maps members' created_by_id users based on source user ID](gitlab-org/security/gitlab@7fd7ab3f57e8d8b4e0aed42aebe9a8b7436a6255) ([merge request](gitlab-org/security/gitlab!2238))
- [Redact InvalidURIError error messages](gitlab-org/security/gitlab@0592c182bfd60aee501c4c66f47a71c9469f2bcd) ([merge request](gitlab-org/security/gitlab!2296))
- [Fix access for approval rules API](gitlab-org/security/gitlab@987e06bacba224519adf94cda73b5a8b2e7b917a) ([merge request](gitlab-org/security/gitlab!2323))
- [Fix kroki exploit](gitlab-org/security/gitlab@bf056c683af25ec4b94c0efa7166eea399ed6502) ([merge request](gitlab-org/security/gitlab!2277))
- [Fix blind SSRF when looking up SSH host keys for mirroring](gitlab-org/security/gitlab@3c853a32a73aba15e309d05111b744455a360cca) ([merge request](gitlab-org/security/gitlab!2310))
- [Escape original content in reference redactor](gitlab-org/security/gitlab@00ee99bc3834d9d59572272064c9ad6abeae5975) ([merge request](gitlab-org/security/gitlab!2318))
- [Security fix for CI/CD analytics visibility](gitlab-org/security/gitlab@691d69be77ae3c8e0a2598b75ccf336b672fd540) ([merge request](gitlab-org/security/gitlab!2273))
- [Latest commit exposed through fork of a private project](gitlab-org/security/gitlab@6ca7a3b040edac06b23a697bfc2bf46f457d6b81) ([merge request](gitlab-org/security/gitlab!2271))
- [Fix Asana integration restricted branch filter](gitlab-org/security/gitlab@4c1db692b4e99fab6cdbb818cf02fb879f6d4886) ([merge request](gitlab-org/security/gitlab!2218))
- [Revert "JH need more complex passwords"](gitlab-org/security/gitlab@919aa2b28645d49fb71508362a0c61da39893c69) ([merge request](gitlab-org/security/gitlab!2353))

## 14.8.4 (2022-03-16)

### Added (1 change)

- [Detect and fix artifacts with backfilled expire_at](gitlab-org/gitlab@a627e0ac2f71e48235b956a7f744608b1cf9632f) ([merge request](gitlab-org/gitlab!83013))

### Fixed (1 change)

- [Pass issue ID to merge request creation form](gitlab-org/gitlab@86c4ec0d5f73a7139a8a22021e73171c354f9326) ([merge request](gitlab-org/gitlab!83013))

### Changed (1 change)

- [Enable feature flags to resume artifact removal on self-managed](gitlab-org/gitlab@07dcfcfc11428900de446d195e673be127ad4f07) ([merge request](gitlab-org/gitlab!83013))

## 14.8.3 (2022-03-14)

### Fixed (3 changes)

- [Fix rake task to setup the Geo tracking database](gitlab-org/gitlab@5382a63c46b205bf49b096e834f7241d6bdd6814) ([merge request](gitlab-org/gitlab!82782)) **GitLab Enterprise Edition**
- [Fix handling of resource iteration events when deleting a User](gitlab-org/gitlab@f26db84ae16d36186b70e630fcb6c3706976ce96) ([merge request](gitlab-org/gitlab!82782)) **GitLab Enterprise Edition**
- [Ensure cleanup job artifacts task does not include pipeline artifacts](gitlab-org/gitlab@c75ecbaeb59be774d8f449b180b772bd0f611a8d) ([merge request](gitlab-org/gitlab!82782))

### Changed (1 change)

- [Remove runners token prefix feature flags](gitlab-org/gitlab@9f316b9a606df7751b56b4eb966c1c02f6d6b3a0) ([merge request](gitlab-org/gitlab!82119))

## 14.8.2 (2022-02-25)

### Security (8 changes)

- [Limit commands_changes to certain keys](gitlab-org/security/gitlab@7a4e348b3ea3d34469bcd353286474c25288d836) ([merge request](gitlab-org/security/gitlab!2225))
- [Add runners_token prefix to Group and Project](gitlab-org/security/gitlab@87bd94f7252f887f22f971ffd59044b355712042) ([merge request](gitlab-org/security/gitlab!2248))
- [Anonymous user can enumerate all users through GraphQL endpoint](gitlab-org/security/gitlab@945da4fadb156ce862bdd12ee5625f57709b590d) ([merge request](gitlab-org/security/gitlab!2213))
- [Check for unsafe characters in email addresses before sending](gitlab-org/security/gitlab@641b23f6b1ad827536ea704c848330a068fc0472) ([merge request](gitlab-org/security/gitlab!2206))
- [Warn when snippet contains unretrievable files](gitlab-org/security/gitlab@d703ecef74f7d73eab3d5345af3a5d60f28c9d7f) ([merge request](gitlab-org/security/gitlab!2205))
- [Prevent DOS when rendering math markdown](gitlab-org/security/gitlab@cedf63be73dc9c37352e425cf8b8cf4e16980935) ([merge request](gitlab-org/security/gitlab!2219))
- [Check permission when creating members through service](gitlab-org/security/gitlab@6228fd285e7062dd1c2e88f8ca33bc8e9a0f4fad) ([merge request](gitlab-org/security/gitlab!2209))
- [Reset password field on page load](gitlab-org/security/gitlab@5ece8645add37c3e77f28d7afb8f28ce4bbe2b7f) ([merge request](gitlab-org/security/gitlab!2224))

## 14.8.1 (2022-02-23)

### Fixed (3 changes)

- [Allow assigning users with private profiles with quick-actions](gitlab-org/gitlab@be36d36a5a0a3d2f0a3b507acd1ab1762e1b0f34) ([merge request](gitlab-org/gitlab!81398))
- [Stop backup files from requiring directories to exist when skipped](gitlab-org/gitlab@f8002e4fe2c83bf01557020e20be5d29f70b20c6) ([merge request](gitlab-org/gitlab!81398))
- [Fix toolbar buttons in Markdown field](gitlab-org/gitlab@74c058e49eb014662a12247ae5fc5bbfb367af0e) ([merge request](gitlab-org/gitlab!81398))

## 14.8.0 (2022-02-21)

### Added (134 changes)

- [Add fields to PipelineSecurityReportFindingType](gitlab-org/gitlab@732f134e9342df18dd3f0c31668f5d43b82b35ac) ([merge request](gitlab-org/gitlab!75001)) **GitLab Enterprise Edition**
- [Add overage confirmation modal](gitlab-org/gitlab@0d26cab716b54fdbdc224e5f72b109ffb276dd90) ([merge request](gitlab-org/gitlab!79644)) **GitLab Enterprise Edition**
- [Add custom tags to the Datadog integration](gitlab-org/gitlab@694a0512374106d42b2fe8296a3bf9d0714f35e3) by @AdrianLC ([merge request](gitlab-org/gitlab!79665))
- [Save sort on querystring for vulnerability report](gitlab-org/gitlab@0000d7993aea7420d914641124a4b3aae4e6b8e5) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/80140)) **GitLab Enterprise Edition**
- [Pipeline and other fixes to community contribution](gitlab-org/gitlab@091a55c1d2dcbd9b3b3041548dec3403af57df19) ([merge request](gitlab-org/gitlab!78899))
- [Allow broadcast messages to be targeted to the current user's role](gitlab-org/gitlab@cbfa1e26b2ccb41ea0cc050dcba4943e2575bc2a) ([merge request](gitlab-org/gitlab!77498))
- [Provide FF to project edit action](gitlab-org/gitlab@e35d9ec63567f6360bf1d086df6130ed2380e41c) ([merge request](gitlab-org/gitlab!80805)) **GitLab Enterprise Edition**
- [Stream audit events using audit event JSON](gitlab-org/gitlab@156e6741c0ac457821f71e49ba9b9d2ebd71cd86) ([merge request](gitlab-org/gitlab!80297)) **GitLab Enterprise Edition**
- [Add CI minutes usage charts to group usage quotas](gitlab-org/gitlab@0157ce737c68f966eb1f1d3226da33c936f46354) ([merge request](gitlab-org/gitlab!80321)) **GitLab Enterprise Edition**
- [Defaulted roadmap_settings to true](gitlab-org/gitlab@1bc7cfa4415c717c926b41c7d97106e192dd10e4) ([merge request](gitlab-org/gitlab!80766))
- [GraphQL: Expose token_expires_at property and sorting](gitlab-org/gitlab@800bf64eb87a83d78c19cfa9d2c2c196884043b6) by @KyleFromKitware ([merge request](gitlab-org/gitlab!79135))
- [Add scan method to dast site profile](gitlab-org/gitlab@cb8679b4c5f6cc1abcf6847021725f6967e72042) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/78745))
- [Enable admin runner read-only runner view](gitlab-org/gitlab@a8f249d0a0bc999d823de2adbae1b022e3a2beb7) ([merge request](gitlab-org/gitlab!80726))
- [Enable corpus management for self-managed installs](gitlab-org/gitlab@5e076a822e18a30422cf0906e44ed0ec669251c1) ([merge request](gitlab-org/gitlab!80570)) **GitLab Enterprise Edition**
- [Fix(SM: Subscription): Refresh local state](gitlab-org/gitlab@b40b5a91ac7dc008cd77fa955ca0943f30d4c121) ([merge request](gitlab-org/gitlab!80482)) **GitLab Enterprise Edition**
- [Enable Service Usage data page by default](gitlab-org/gitlab@197ba70e725f4acb935a94ddcf594c0d21474a1d) ([merge request](gitlab-org/gitlab!80651))
- [Exclude pending memberships from billable members count](gitlab-org/gitlab@2ef98e1b549d7c0b433ac702f69d3f418fdc813c) ([merge request](gitlab-org/gitlab!79377)) **GitLab Enterprise Edition**
- [Make granting of open-source license to public projects configurable](gitlab-org/gitlab@cfdf221afd43c23a2940fe1abe17f66ce47fd706) ([merge request](gitlab-org/gitlab!79855))
- [Enable prohibition of hex branch names](gitlab-org/gitlab@90e848582fcaa1801a02bb1b2892c469b5ed874b) ([merge request](gitlab-org/gitlab!80603))
- [Add dependency_proxy_size to GraphQL type](gitlab-org/gitlab@d898fc91b1ab2bed851352721834aa8c1ba8b16d) ([merge request](gitlab-org/gitlab!80402))
- [Removed work_items_hierarchy feature flag](gitlab-org/gitlab@4e50d3797279effd0a21d23bd4db55086ee671bd) ([merge request](gitlab-org/gitlab!80004))
- [Add the ability to ban users in the Admin Area](gitlab-org/gitlab@aee60e7d75360563ad3d5b9e540c9969dfc20b45) ([merge request](gitlab-org/gitlab!79783))
- [Add "Delete" group button to the groups dashboard](gitlab-org/gitlab@356482ce914c09168671ada12155d0d2e34c70df) ([merge request](gitlab-org/gitlab!79312))
- [Registry import enqueuer](gitlab-org/gitlab@9ebf63832e55c731c6896670d0d12c8ea27d6e21) ([merge request](gitlab-org/gitlab!78613))
- [Add crm system notes](gitlab-org/gitlab@2729386bae652f45391c018b0fd5fb63a3080251) by @leetickett ([merge request](gitlab-org/gitlab!77816))
- [Extend the GraphQL interface with `securityTrainingUpdate` mutation](gitlab-org/gitlab@7655fb2ef3d443fd11e41a3f170cb253e4eb79c4) ([merge request](gitlab-org/gitlab!78687)) **GitLab Enterprise Edition**
- [Add alert metric image table and basic model](gitlab-org/gitlab@0adf9f76c46be0100ad5df14fa91cb5ff081ad1d) ([merge request](gitlab-org/gitlab!80339))
- [Add required approvals to Protected Environment settings](gitlab-org/gitlab@65ffaea172efa43a28ed052cb049dd2d0d745f3d) ([merge request](gitlab-org/gitlab!78931)) **GitLab Enterprise Edition**
- [Add GEMNASIUM_LIBRARY_SCAN_ENABLED variable](gitlab-org/gitlab@3f5c5dda30bfe70889401b9353d7f118ab86255e) ([merge request](gitlab-org/gitlab!80226))
- [Allow to list project group ancestors on REST API](gitlab-org/gitlab@25d21e699c2472c9021f1bd6571261ef3a2adfa4) ([merge request](gitlab-org/gitlab!79671))
- [Upgrade GitLab Pages to 1.54.0](gitlab-org/gitlab@a014857041df691d27c1fb6336bba8355f532461) ([merge request](gitlab-org/gitlab!80406))
- [Add `public_projects_count` counter to topics](gitlab-org/gitlab@4b79ed2389e21677a060e2aaea19f60a43f0b2ff) by @wwwjon ([merge request](gitlab-org/gitlab!79140))
- [Registry import observer worker](gitlab-org/gitlab@0493b2525e8b5a3123e12bd4f0be8e8c14a22997) ([merge request](gitlab-org/gitlab!79692))
- [Add support for contacts autocompletion](gitlab-org/gitlab@543067dd93c7b72ccc5be0dda00d946520077bf8) ([merge request](gitlab-org/gitlab!79639))
- [Add the registry migration guard job](gitlab-org/gitlab@e5e0c6a2f8386bc44c8e56def620fe334824c01b) ([merge request](gitlab-org/gitlab!79634))
- [Save audit events for start/stop user impersonation to group level](gitlab-org/gitlab@82954c4b3aeeb11605e4a4ce1d2aed0e38adf0d9) ([merge request](gitlab-org/gitlab!79340)) **GitLab Enterprise Edition**
- [Add ability to download Service Ping payload](gitlab-org/gitlab@428e758243d13720c53cb7eb8e89a5331c679a58) ([merge request](gitlab-org/gitlab!78857))
- [Backfill route namespace_id for namespaces](gitlab-org/gitlab@93beae4aea556412c213234f970fc281df5fa2f5) ([merge request](gitlab-org/gitlab!78393))
- [Support position params in issue creation mutation](gitlab-org/gitlab@42dd3d1376eda2e94d0ee710a3eed60b89fc8a8f) ([merge request](gitlab-org/gitlab!79397))
- [Add dependency proxy migrate rake task](gitlab-org/gitlab@007224aa6c43ac70cab2624330b8ddd53d5b26ac) ([merge request](gitlab-org/gitlab!79663))
- [Add script to track clicks for RF offer](gitlab-org/gitlab@e76a22e0b002636365cc87402da705c950a17633) ([merge request](gitlab-org/gitlab!79559)) **GitLab Enterprise Edition**
- [Add owner_valid to Dast::ProfileScheduleType](gitlab-org/gitlab@08cd9b3cf8dd5170b5629024a208343e63994149) ([merge request](gitlab-org/gitlab!71214)) **GitLab Enterprise Edition**
- [Add deprecation notice to the Serverless UI](gitlab-org/gitlab@ba4dae4aa22a9b59bad0d5a9e57db41a771ac9db) ([merge request](gitlab-org/gitlab!80233))
- [Add Project Access Tokens to credentials inventory](gitlab-org/gitlab@538a5c670b9bc3c9e48133ef346cf20a09be15bb) ([merge request](gitlab-org/gitlab!79645)) **GitLab Enterprise Edition**
- [Copy contacts when moving an issue](gitlab-org/gitlab@04a8db0ada5324b32f7b520cd49668e69dc7a47f) ([merge request](gitlab-org/gitlab!80069))
- [Request deployment target info from users](gitlab-org/gitlab@83f1d280d446b2e0d616c917cf7d7840007c2f83) ([merge request](gitlab-org/gitlab!79873))
- [Add utility method to add parameters to a URL](gitlab-org/gitlab@e4266d5cf40e46c09e239fa781e3c8689403d905) ([merge request](gitlab-org/gitlab!79758))
- [Enable invite member modal by default](gitlab-org/gitlab@5aae7959fae2bda3b8edf74f1300f902358a58b7) ([merge request](gitlab-org/gitlab!79679))
- [Add GraphQL API endpoint access from primary to secondary Geo nodes](gitlab-org/gitlab@125b4fcee99bc635597bec4d7d3b34e30248ed65) ([merge request](gitlab-org/gitlab!79431)) **GitLab Enterprise Edition**
- [Add epic sort by last created or updated](gitlab-org/gitlab@b8c4af272bf1d9cd3bac018bc49a555a5f4f4ad5) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/79923)) **GitLab Enterprise Edition**
- [Add epic sort by last created or updated](gitlab-org/gitlab@e456516cad18f4dbc36cbffffca66e042245bab4) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/79923)) **GitLab Enterprise Edition**
- [Add simple multi select for when the number of](gitlab-org/gitlab@fafb7d33287e1849db1ea8e42a198101780831c5) ([merge request](gitlab-org/gitlab!79571)) **GitLab Enterprise Edition**
- [Cache shared runners enabled check](gitlab-org/gitlab@42d74a1168bb8a8d341de254561541417a00fd59) ([merge request](gitlab-org/gitlab!80056))
- [Implement fair queueing for LFK](gitlab-org/gitlab@68410b2dc945ae15c3a9a403b982fd7cec8ba620) ([merge request](gitlab-org/gitlab!79116))
- [Add max_batch_size to batched migrations table](gitlab-org/gitlab@d40b94a4268374d5d7c79927bb52594360fef7ad) ([merge request](gitlab-org/gitlab!79848))
- [Add setting to not display code diffs in MR review emails](gitlab-org/gitlab@9950838ee3ddd0c5d88f9ac76d0e7fa20968e18f) by @joe-snyder ([merge request](gitlab-org/gitlab!79229))
- [Add attention requests to the MR list view](gitlab-org/gitlab@735603d3b043347d9f9bb10336475a889430ce64) ([merge request](gitlab-org/gitlab!77136))
- [Add version column to the Agent listing page](gitlab-org/gitlab@eed6b9a66943ed10558d3e8f7e7a83c2ceffef3b) ([merge request](gitlab-org/gitlab!78553))
- [Add owners array to webhook data](gitlab-org/gitlab@d46bea3f5bc0e7e9db871ffa98922cf4867f8689) ([merge request](gitlab-org/gitlab!79285))
- [Enable searching for MRs by updated_at](gitlab-org/gitlab@544d23eb380e72b3f398cc6cdabb9a29de4d865d) ([merge request](gitlab-org/gitlab!79872))
- [Support "ecdsa-sk" and "ed25519-sk" SSH keys](gitlab-org/gitlab@782a634c663f7db5d27ffdf948d22c9da91549a1) ([merge request](gitlab-org/gitlab!78934))
- [Promote the trial_registrations_with_reassurance experiment](gitlab-org/gitlab@0c2fa2c16a645c7616c1abac638c53042e7e5f72) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/78920)) **GitLab Enterprise Edition**
- [Record and publish application boot time](gitlab-org/gitlab@335317a0a024264e182bae7324fdacdf4c0262b6) ([merge request](gitlab-org/gitlab!79139))
- [Add GraphQL create API for incident timeline events](gitlab-org/gitlab@033b1622f1d3a32cc646261feeb853bfc6087ef6) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/78884)) **GitLab Enterprise Edition**
- [Populate data for vulnerability_reads from vulnerabilities](gitlab-org/gitlab@6b66dd6c7b52c723c12dfdd0d530acf9846709b1) ([merge request](gitlab-org/gitlab!75441))
- [Remove deployment_approvals feature flag](gitlab-org/gitlab@32d1e07b3ed1103ae8bbc993a0b3633ced2e0352) ([merge request](gitlab-org/gitlab!79681)) **GitLab Enterprise Edition**
- [Added Qualys IaC Security template](gitlab-org/gitlab@6fc4eae57cb4f65c494118234da8009999f50c5d) by @mbachhav ([merge request](gitlab-org/gitlab!77362))
- [CI/CD analytics: Add metric tiles](gitlab-org/gitlab@9124f81f2c65bb905c610f2c9ba7099fbe1218de) ([merge request](gitlab-org/gitlab!78655)) **GitLab Enterprise Edition**
- [Show KAS version on admin dashboard](gitlab-org/gitlab@84a5106cd9f0ca76decf66c565ce3609a6fd3bc3) ([merge request](gitlab-org/gitlab!79720))
- [Add validation to check if branches are valid for security policy](gitlab-org/gitlab@0fa2a7b4b6b9c60782cf4709feff148c20055637) ([merge request](gitlab-org/gitlab!78714)) **GitLab Enterprise Edition**
- [Add Container Registry migration notification APIs](gitlab-org/gitlab@ada11f37e8cd5fd485113b827d111bce754dd5be) ([merge request](gitlab-org/gitlab!79200))
- [Allow group maintainers to list provisioned users for a group](gitlab-org/gitlab@4733c36bae3a79bb39410e78d80ce140e57f6fef) ([merge request](gitlab-org/gitlab!79600)) **GitLab Enterprise Edition**
- [Upgrade GitLab Pages to 1.53.0](gitlab-org/gitlab@a538e469791a4cd1507d4c69a2a25d19f6b4518b) ([merge request](gitlab-org/gitlab!79628))
- [Enable Configure with a MR button for Container Scanning](gitlab-org/gitlab@ecf0b83300cc9223ecf2534a877b712179ef8e93) ([merge request](gitlab-org/gitlab!79202)) **GitLab Enterprise Edition**
- [Enable json_limited_encoder ff by default](gitlab-org/gitlab@a8c92a485e7b1d5451cc86276a044a89046d6edc) ([merge request](gitlab-org/gitlab!79612))
- [Add Blob#symlink? boolean method](gitlab-org/gitlab@1e6d3f3abb4d3d8aff7866484139eb4397b07f47) ([merge request](gitlab-org/gitlab!79590))
- [Feat(SM: Subscription History): add future subscr](gitlab-org/gitlab@ad7f40bcc940e066d6436ccf57e12a719390354c) ([merge request](gitlab-org/gitlab!79015)) **GitLab Enterprise Edition**
- [Remove extract_mr_diff_commit_deletions FF](gitlab-org/gitlab@df2ab6ed91d663e86b50e9977042de8f47e51349) ([merge request](gitlab-org/gitlab!79548))
- [Add enabling container-scanning for project with GraphQL](gitlab-org/gitlab@682fb105e900a3158e225e349af70006c223901c) ([merge request](gitlab-org/gitlab!79201)) **GitLab Enterprise Edition**
- [Add median to CI/CD lead time chart](gitlab-org/gitlab@f16769f14615ef929fd455e04a7504ea68fe5590) ([merge request](gitlab-org/gitlab!78999)) **GitLab Enterprise Edition**
- [Feat(SM: Subscription Activation): size + text](gitlab-org/gitlab@dc353ad13001d5b37696e3203f70b3c46f0cb34e) **GitLab Enterprise Edition**
- [Bump GitLab pages to 1.52.0](gitlab-org/gitlab@ee9474a02cf96a3257f61a683ee8ecacc2c33b96) ([merge request](gitlab-org/gitlab!79529))
- [Feat(SM: Subscription Activation): size + text](gitlab-org/gitlab@eb3b3fb22951e29a6d7937fc5a6d0325dcd847b2) ([merge request](gitlab-org/gitlab!79334)) **GitLab Enterprise Edition**
- [Remove `vue_epics_list` and legacy code](gitlab-org/gitlab@0c516d3b7ff1bc4a575ec3d090aee9485cd07d06) ([merge request](gitlab-org/gitlab!79404)) **GitLab Enterprise Edition**
- [Add triggers to sync vulnerability_reads](gitlab-org/gitlab@b9bf81f189e0f9c120fe074552a0a33612e175d7) ([merge request](gitlab-org/gitlab!75230))
- [Add ability to search for an escalation policy by name](gitlab-org/gitlab@f7bb2b1de6ffad50783c881e4dc99a6fb12b3250) ([merge request](gitlab-org/gitlab!78950)) **GitLab Enterprise Edition**
- [Expose language field in GraphQL blob type](gitlab-org/gitlab@a33ef7674aa529c7bd2196342fb415bdcbba400d) ([merge request](gitlab-org/gitlab!78895))
- [Adds mergeRequestInteraction to GraphQL MemberInterface type](gitlab-org/gitlab@09ee9d960f2432b2e4e4de625ee5ac0d090b2c70) ([merge request](gitlab-org/gitlab!77048))
- [Ask for feedback on the Agent listing page](gitlab-org/gitlab@f4bb6c4ed85322ca719aa0e1856e96fb36f893dc) ([merge request](gitlab-org/gitlab!78567))
- [Re-remove foreign keys on GitLab.com](gitlab-org/gitlab@8ed4f00ef1246136b9d6881985a95f406cf97c50) ([merge request](gitlab-org/gitlab!79418))
- [Add Planning Hierarchy page](gitlab-org/gitlab@7d4ae6b96c6ad9145da3ba90cc1fa4e10b1ecfc0) ([merge request](gitlab-org/gitlab!79315))
- [Enable Gitlab Shell rate limit by default](gitlab-org/gitlab@eda5a6a0b4a4dfdc3393fbbfa0432e0155e2aa99) ([merge request](gitlab-org/gitlab!79419))
- [Enable bulk job tags insertion by default](gitlab-org/gitlab@70ced4e140c2a6723a5dfe0f92d210d6012fae99) ([merge request](gitlab-org/gitlab!79415))
- [GraphQL: Add jobs field to CiRunner](gitlab-org/gitlab@f6e4eed3e63b4d1da1f7cd39f5acee753ae24f2b) ([merge request](gitlab-org/gitlab!79123))
- [Add a GraphQL resolvers to get pipeline counts by scope](gitlab-org/gitlab@2fd7902d4f1b6209df65588e697b6bd3b6e5851d) ([merge request](gitlab-org/gitlab!77949))
- [Pass custom slots from HelpPopover to GlPopover](gitlab-org/gitlab@87d190eb7ff1bde814ab91e806b75c7fe008b808) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/79319))
- [Enable project owners to list their projects pending deletion by default](gitlab-org/gitlab@01e4eb80211709fa2c44e3068d9db98e95297ab8) ([merge request](gitlab-org/gitlab!79104)) **GitLab Enterprise Edition**
- [Hide ancestor groups in group invites](gitlab-org/gitlab@fdd0423d7a45eb0bfe342786d26032cffdda11e9) ([merge request](gitlab-org/gitlab!78106))
- [Track api usage of the jetbrains plugin](gitlab-org/gitlab@abf7ea974612f0cd3da8ed4fc00bde53b3b28ad9) ([merge request](gitlab-org/gitlab!78713))
- [Indicate locked users in Admin Area users list](gitlab-org/gitlab@d61dc91e2dff72b45368e3703f9743e86a3df13d) ([merge request](gitlab-org/gitlab!79160))
- [Add metric tile component](gitlab-org/gitlab@38b7f1ea051a4d45fe5ee6120c7c5296fe45383c) ([merge request](gitlab-org/gitlab!79153))
- [Support iteration search by cadence title](gitlab-org/gitlab@75e3079e25fb70e08ed33e9019cbbc8743ca3a17) ([merge request](gitlab-org/gitlab!76231)) **GitLab Enterprise Edition**
- [Add badge for invited user](gitlab-org/gitlab@d255256b23079c08f474b625083dc48d1ebd421e) ([merge request](gitlab-org/gitlab!78407))
- [Remove import_redis_increment_by feature flag](gitlab-org/gitlab@5864218b753d495a0942c398802f8e26912217a1) ([merge request](gitlab-org/gitlab!79130))
- [Submit ServicePing generation errors to Version app](gitlab-org/gitlab@3a66f6bf348f4b7d901127082f8caa292f298aa4) ([merge request](gitlab-org/gitlab!78028))
- [Add mutation for updating user preferences](gitlab-org/gitlab@1706b68fd203aa3baf70ca26ee187bfc5ac8a676) ([merge request](gitlab-org/gitlab!79127))
- [Add Graphql mutation to update timeline event](gitlab-org/gitlab@cd15de7b2fdf06ea65ed16556a884f4c2d155af8) ([merge request](gitlab-org/gitlab!79016)) **GitLab Enterprise Edition**
- [Log project export timings](gitlab-org/gitlab@cb1925222737f9886761d70218f04e6890346727) ([merge request](gitlab-org/gitlab!79093))
- [Re-enable sanboxed mermaid FF with a fix](gitlab-org/gitlab@8db1c36c802556ba38e284cd7331a5283611693a) ([merge request](gitlab-org/gitlab!79043))
- [Redirect in-app trial users to the feature](gitlab-org/gitlab@4b5c46c6a755f537dd975bf931397357d8ae217d) ([merge request](gitlab-org/gitlab!78917)) **GitLab Enterprise Edition**
- [Add more issue due_date filters to API](gitlab-org/gitlab@393e4a5c2d92208c82d934a5a47e5e3025425b6b) by @leetickett ([merge request](gitlab-org/gitlab!78460))
- [Add support for the gitlab container registry API](gitlab-org/gitlab@f4504543103ea5dc5dd1ac436e39f2fe616ebf9a) ([merge request](gitlab-org/gitlab!78452))
- [CI Runners: Support sorting by token_expires_at](gitlab-org/gitlab@a4182be45c13baa0276722fd8626052efb7faeea) by @KyleFromKitware ([merge request](gitlab-org/gitlab!78939))
- [Restrict JWT requests when importing repositories](gitlab-org/gitlab@c6c6d609b137583041535e44f763e3c4bcaf65bd) ([merge request](gitlab-org/gitlab!78489))
- [Show deprecation notification in pipeline page](gitlab-org/gitlab@1c8ca0874c257cb48183079ad1491fd5cc7c69d1) ([merge request](gitlab-org/gitlab!77876))
- [Allow project owners to list & restore their projects pending deletion](gitlab-org/gitlab@1248d0f3d78d703e0cdf1e49ab4ff6f721323bcd) ([merge request](gitlab-org/gitlab!76484)) **GitLab Enterprise Edition**
- [Allow merge requests to be sorted by title](gitlab-org/gitlab@84cc023c5198c1f870249139c3cc831d21ef66c9) ([merge request](gitlab-org/gitlab!76472))
- [Add everage to CI/CD deployment chart](gitlab-org/gitlab@d9fb45d66528e64a20591e75d8bd2a0cb3375397) ([merge request](gitlab-org/gitlab!78358)) **GitLab Enterprise Edition**
- [Add improved readme content for all new projects](gitlab-org/gitlab@e9241478b98a40bd7d05e1e8fc9070b474b6cc59) ([merge request](gitlab-org/gitlab!77706))
- [Adds dependency_proxy_size to namespace statistics](gitlab-org/gitlab@2fd34490d3c4109ad87e1a6f4d56b9afafb750f0) ([merge request](gitlab-org/gitlab!78560))
- [GraphQL: Add projects property to CiRunner type](gitlab-org/gitlab@613fa6194e7e2e1b493740c1bc8399f8feef932a) ([merge request](gitlab-org/gitlab!78547))
- [Add identifier to VSA summary metrics](gitlab-org/gitlab@f037767d3f538a069a95cc8abc28084546de4a74) ([merge request](gitlab-org/gitlab!78470))
- [GraphQL: Add groups property to Runner type](gitlab-org/gitlab@1101f5699fd2af691aec9ab1eb12861fb432c76f) ([merge request](gitlab-org/gitlab!78454))
- [Add verification header for streamed events](gitlab-org/gitlab@d44d003052f8a3bceacfbd8eac2073c99c579297) ([merge request](gitlab-org/gitlab!78273))
- [Hide issue contacts and quick actions](gitlab-org/gitlab@93e96b73089c754976fc5e83795c12c17503bfaa) by @leetickett ([merge request](gitlab-org/gitlab!77822))
- [Update templates for repository size RF CTA](gitlab-org/gitlab@916bbaf14d3c6ebd2319ec7ab4125997972e844b) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/77355)) **GitLab Enterprise Edition**
- [Adds dependency_proxy_size to root storage stats](gitlab-org/gitlab@33e4c4e6c89a810c52430fa79ab3b9eee09d7e8e) ([merge request](gitlab-org/gitlab!78565))
- [CI Runners: Add token expiration field](gitlab-org/gitlab@874d5f8072adf51027b9ee2751fa5d3356dbad63) by @KyleFromKitware ([merge request](gitlab-org/gitlab!77899))
- [Add state/province selector to trials](gitlab-org/gitlab@3510cbd99eb805b8c633f5daabf4cca0dc29eca8) ([merge request](gitlab-org/gitlab!78484)) **GitLab Enterprise Edition**
- [Add audit logging for runner registration](gitlab-org/gitlab@99c2f2930b3d30eddc755c2c0dff0d92cc243ebf) ([merge request](gitlab-org/gitlab!77109)) **GitLab Enterprise Edition**
- [Support default templates for issues/MRs via .gitlab/ folders](gitlab-org/gitlab@3aa3426880b85916a04147b1c891455ebfee175e) by @davebarr ([merge request](gitlab-org/gitlab!78302))
- [Allow querying recent boards in a group or project](gitlab-org/gitlab@5b026dd5465d09461f51e221a88640247b9d6123) ([merge request](gitlab-org/gitlab!78076))
- [Add url_text column to issuable metric images](gitlab-org/gitlab@31d4b47ddf4fc5394ca6f5d7b8bbdc91dfb9a5b1) ([merge request](gitlab-org/gitlab!78430))
- [Add migration for backfilling project namespaces](gitlab-org/gitlab@b88c1e81a2c32357da42037a7667e42c5c5ad52e) ([merge request](gitlab-org/gitlab!73640))

### Fixed (168 changes)

- [Allow specifying project name on importing an exported GitLab project](gitlab-org/gitlab@32e6193a498ce10ad0ae7cba9393652da5b41c68) by @zhzhang93 ([merge request](gitlab-org/gitlab!80150))
- [Clean up wrong max_seats_used batch two](gitlab-org/gitlab@5691252a3a804c8f3fba632693be1739e2365c1a) ([merge request](gitlab-org/gitlab!79705))
- [Fix Date::Error exception when viewing audit logs for an invalid date](gitlab-org/gitlab@2d3064509b29ed48dbba26c6307af064a8329e1b) ([merge request](gitlab-org/gitlab!80634)) **GitLab Enterprise Edition**
- [Revert "Merge branch 'if-personal_project_owners' into 'master'"](gitlab-org/gitlab@8f98dbae4804eef2a9f740f25c0aa39d48779e2f) ([merge request](gitlab-org/gitlab!80723))
- [Fix unit display for VSA charts](gitlab-org/gitlab@0a53ce8214149c36fd33311b89b5da369a359741) ([merge request](gitlab-org/gitlab!80707)) **GitLab Enterprise Edition**
- [Added merge policy for design collection](gitlab-org/gitlab@2a2a838ce36ff895c6696d8c4436e064cb291ec3) ([merge request](gitlab-org/gitlab!80705))
- [Fix merge request tabs background leakage](gitlab-org/gitlab@a5ba0956e1d4e04c7246a06d6df75cfb0f62f02d) ([merge request](gitlab-org/gitlab!80612))
- [Fix position when creating issue in issue boards](gitlab-org/gitlab@3c49f96b53d7eceeb0c9bf42233a1952aa6b4903) ([merge request](gitlab-org/gitlab!80429))
- [Delete issue contacts if project root changed](gitlab-org/gitlab@d11319c4a12a38b9587445e8ba536208bbc62cd8) by @leetickett ([merge request](gitlab-org/gitlab!80394))
- [Revert user already exists to members API](gitlab-org/gitlab@e640b9d73b9a447bf458c5b146d42119653d321b) ([merge request](gitlab-org/gitlab!80672))
- [Avoid exceptions from un-symbolizable job names](gitlab-org/gitlab@f9b475c72c4d0b4352679667553e298f022c4a7c) ([merge request](gitlab-org/gitlab!80417))
- [Block external fork mirrors](gitlab-org/gitlab@f165783d139ecc5245d2ed20418ab035298bb63e) ([merge request](gitlab-org/gitlab!80626))
- [Allow testing of disabled hooks](gitlab-org/gitlab@32a2063ebf67ef0b5ee347b81326fd43d87126ad) ([merge request](gitlab-org/gitlab!80615))
- [Fix duplicate draft help text](gitlab-org/gitlab@b824b9ac6c471f82689a1f67de809d493e98db23) ([merge request](gitlab-org/gitlab!79411))
- [Stop browser from caching learn gitlab](gitlab-org/gitlab@b0260a7ff8afc97fe20fd40ac92614fee2b70d38) ([merge request](gitlab-org/gitlab!80423)) **GitLab Enterprise Edition**
- [Add ref param to project level ci/lint](gitlab-org/gitlab@edb848b767350266a350c76e6515587b2cd68ad1) by @thadc23 ([merge request](gitlab-org/gitlab!79992))
- [Apply PJs styling to Pages DNS badge](gitlab-org/gitlab@034336c40c70ac150f38f32d9eb59e87df8c7f2c) ([merge request](gitlab-org/gitlab!79858))
- [Fix missing discussion_id in GitHub imports](gitlab-org/gitlab@ab0598917c09b2697ef84dd117bb5b1c68ac2b62) ([merge request](gitlab-org/gitlab!80584))
- [Allows invite modal to re-invite single users](gitlab-org/gitlab@0ce00442ebd35088fa32add0fa8a169cf202efb5) ([merge request](gitlab-org/gitlab!80177))
- [Add encoding for url params for board filtered search](gitlab-org/gitlab@4e1e934b89f7e45a88d6e98e0bd5d020b766f4a7) by @sstern ([merge request](gitlab-org/gitlab!80006))
- [Handle Gitaly error on fetching total-branches for pipeline editor](gitlab-org/gitlab@b7bbef2f034c1ff036ad8d680fb9f81a7941698a) ([merge request](gitlab-org/gitlab!80467))
- [Fix typo in Pull mirror verification](gitlab-org/gitlab@1b20f827741bcf1ba66e831703099886e0260561) ([merge request](gitlab-org/gitlab!80408)) **GitLab Enterprise Edition**
- [Allow to toggle requirements_access_level on REST API](gitlab-org/gitlab@68364a93c2e8aba6b001a58380a8f833513a3ea4) ([merge request](gitlab-org/gitlab!79968)) **GitLab Enterprise Edition**
- [Allow GC to run if deduplication service runs into an error](gitlab-org/gitlab@569557f02d71733a7231ac88bfd46827f3d83759) ([merge request](gitlab-org/gitlab!80269))
- [Render submit button only once in Pages settings](gitlab-org/gitlab@96278df4c4286753d5413010df5d91bff2ba89c8) ([merge request](gitlab-org/gitlab!79545))
- [Update GitHub PRs Importer to force update repository](gitlab-org/gitlab@4b20a3def1b3957f8e038c43dd04723ceecac4ef) ([merge request](gitlab-org/gitlab!80379))
- [Use strong parameters for CompareController](gitlab-org/gitlab@557fcc3bfd5c4c8c743ca9d25f622de1b5e59e15) ([merge request](gitlab-org/gitlab!80396))
- [Fix default sort for tags page](gitlab-org/gitlab@778a3882d78e501bf31ce4edab194413538a416b) ([merge request](gitlab-org/gitlab!80232))
- [Update namespace statistics when project is destroyed](gitlab-org/gitlab@1e78b395bbc29cce9db1542df6b6c4489d47b23e) ([merge request](gitlab-org/gitlab!78862))
- [Don't rebase when the branch protected from force push](gitlab-org/gitlab@14db567b70d9e9e37ed5080fe4e770b0286b03db) ([merge request](gitlab-org/gitlab!80329))
- [fix: Reintroduce top-level SAST_ANALYZER_IMAGE_TAG for SCS](gitlab-org/gitlab@d45a7685c7ba4a32483634908d7e31c67b1a77c6) ([merge request](gitlab-org/gitlab!80338))
- [Fix typo in Gitlab::Changelog::Release](gitlab-org/gitlab@23e9266884ec3d67fbfd25ed69baf64c198a0541) ([merge request](gitlab-org/gitlab!80314))
- [Merge branch...](gitlab-org/gitlab@66f5a8403643b5852268681efd5072587dee7506) ([merge request](gitlab-org/gitlab!80113))
- [Fix corpus delete by updating corpus fetch](gitlab-org/gitlab@905a0f73d3e6306b53f9282203cdceb1cda9e00b) ([merge request](gitlab-org/gitlab!80095)) **GitLab Enterprise Edition**
- [Return an error for an invalid ref_name](gitlab-org/gitlab@ca87a51358066e10788f9e5e9e1e27e4199b5f91) ([merge request](gitlab-org/gitlab!79531))
- [Fix Geo checksummable check failing when file is nil](gitlab-org/gitlab@89675a1a564431eb179de8f77a8e363186686eeb) ([merge request](gitlab-org/gitlab!80280)) **GitLab Enterprise Edition**
- [Fix layout issues for project tokens in credentials inventory](gitlab-org/gitlab@2c171971a39a4842742cc31272db94dc8c840a2c) ([merge request](gitlab-org/gitlab!80273)) **GitLab Enterprise Edition**
- [Use StrongParameters for ExtractsRef](gitlab-org/gitlab@32683c2db708bee85276c90dd977d3502e486a5e) ([merge request](gitlab-org/gitlab!79997))
- [Remove label hover state css override in right sidebars](gitlab-org/gitlab@9aeb49557fe36b303083ad1fe57510e91b714c3e) ([merge request](gitlab-org/gitlab!80211))
- [Change minutes field to shared_runners_duration](gitlab-org/gitlab@ee407a3d340b0e3ef261af6101a001d2fe041da6) ([merge request](gitlab-org/gitlab!80197)) **GitLab Enterprise Edition**
- [Don't record the exception when the repository already exists](gitlab-org/gitlab@2219fe6d68c3508e2056409d36518332bdbf43f5) ([merge request](gitlab-org/gitlab!80090))
- [Allow sorting epics by created & updated dates](gitlab-org/gitlab@8ba1fafb9d6bdd69d41f5869e6176f594a767270) ([merge request](gitlab-org/gitlab!80173)) **GitLab Enterprise Edition**
- [Use StrongParameters for ProjectsController](gitlab-org/gitlab@06c8a4e53594067570413c4a63ddb4597d295113) ([merge request](gitlab-org/gitlab!79956))
- [Reject reply by email to notification if the from email is not verified](gitlab-org/gitlab@6c33182ce0898ce0d29207c83623d1f6617c2b48) ([merge request](gitlab-org/gitlab!79932))
- [Fix Typo in Protected Tags Settings](gitlab-org/gitlab@2c1f0c0893cd32c99cd56f02f6fe2104e7417551) by @Taucher2003 ([merge request](gitlab-org/gitlab!80028))
- [Roadmap - Fix today indicator alignment](gitlab-org/gitlab@09ec9ebcb369b5d82b7c4652abcad15d2956266d) ([merge request](gitlab-org/gitlab!80126)) **GitLab Enterprise Edition**
- [MacOS remove horizontal scroll in left navigation](gitlab-org/gitlab@f83e25cedf3d4636cef263d9e545608a44309120) by @OmerFarukMerey ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/80015)) **GitLab Enterprise Edition**
- [Remove secondary variant from agent modal cancel button](gitlab-org/gitlab@3e1d9e70413de3a0e6b4a0bf0796afdf7819e77e) ([merge request](gitlab-org/gitlab!79664))
- [Add width and alt tag to image in trial flow second step](gitlab-org/gitlab@f12103cdf9f690a01c63e1474bcd033fdbbc81cc) ([merge request](gitlab-org/gitlab!79971))
- [Fix provisioned_users API endpoint with full_path](gitlab-org/gitlab@b4de6aa133a72babd3d55b227e626e585f8b0429) ([merge request](gitlab-org/gitlab!80061)) **GitLab Enterprise Edition**
- [Verify project id in API](gitlab-org/gitlab@f059837f4d94a98678206f19e43fb56e0f26668f) ([merge request](gitlab-org/gitlab!80086))
- [Fix NoMethodError for calling modified_paths on nil pipeline](gitlab-org/gitlab@fe96b2d02c1803b56efce655340175575777c0cf) ([merge request](gitlab-org/gitlab!80089))
- [Introduce concept of parse errors for quick actions](gitlab-org/gitlab@a033bff843c4094e29ace281467231068ddf489b) ([merge request](gitlab-org/gitlab!79948))
- [Test the logical path rather than the real path](gitlab-org/gitlab@4d6382e2260332b98628975067e3c57baaaf6beb) ([merge request](gitlab-org/gitlab!79738))
- [Fix merge requests page dark mode](gitlab-org/gitlab@a892991d6dda477724ce941b1470224425718327) ([merge request](gitlab-org/gitlab!80026))
- [Remove container-image: from location on the Dependency List](gitlab-org/gitlab@0fc93315a28604bb48ae8844bc2d759cd2014780) ([merge request](gitlab-org/gitlab!79767)) **GitLab Enterprise Edition**
- [Remove dangling running entries from ci running builds table](gitlab-org/gitlab@0f69fdc0f64587e7d06bbb322168a7d447a46acf) ([merge request](gitlab-org/gitlab!79444))
- [Reject MIME parts with unsupported encoding](gitlab-org/gitlab@0ea5a23d8992601f6d0aaa218955fe3d8c8dd2e1) ([merge request](gitlab-org/gitlab!78699))
- [Drop legacy finished at in Deployment](gitlab-org/gitlab@b8f911e22d1fc71c5d629ccd1fa06b98a6145b4c) ([merge request](gitlab-org/gitlab!73172))
- [Use strong_parameters for RefsController](gitlab-org/gitlab@69d9bf58e05d2f5f586c8f4b629a7ba88d98b74f) ([merge request](gitlab-org/gitlab!79951))
- [Check for group confidential access in EpicsFinder](gitlab-org/gitlab@f5458eb612b6b912704f29332e24c933b3cdf46f) ([merge request](gitlab-org/gitlab!79236)) **GitLab Enterprise Edition**
- [Allow searching of users using less than 3 chars](gitlab-org/gitlab@614a690fd490e3416f2f93316bfea166926b7e7e) ([merge request](gitlab-org/gitlab!79927))
- [Fix label links in MR system notes](gitlab-org/gitlab@4daa5ea85c2f43911b5471a68335d106b55730e0) ([merge request](gitlab-org/gitlab!79928))
- [Epic boards - Hide toggled off Open column](gitlab-org/gitlab@e91a562739557725c5d63fef29ce15add2448590) ([merge request](gitlab-org/gitlab!79911))
- [Fix for rate lmiting test errrors](gitlab-org/gitlab@c7bcfdcb3d07691214eede278693e4c68f42323d) ([merge request](gitlab-org/gitlab!79836)) **GitLab Enterprise Edition**
- [Catch GitLab::HTTP:ERRORS while streaming auditevents](gitlab-org/gitlab@2344fddb03d8b771562c066897798e5a3183d75b) ([merge request](gitlab-org/gitlab!79410)) **GitLab Enterprise Edition**
- [Fix missing upvote/downvote counts on Epics list](gitlab-org/gitlab@c3000afb66062d736b079085e26764e1f8e89f42) ([merge request](gitlab-org/gitlab!79844)) **GitLab Enterprise Edition**
- [Roadmap - Fix bar width for week layout](gitlab-org/gitlab@dabd416aa6dc31c863b44c1bf23052fb96cd006f) ([merge request](gitlab-org/gitlab!79814)) **GitLab Enterprise Edition**
- [Improve dashboard projects blank state code](gitlab-org/gitlab@38fb3bbd4de8f4299b611a46f35df7fa834d1c63) ([merge request](gitlab-org/gitlab!79782))
- [Fix how busy is displayed in group/project members list](gitlab-org/gitlab@953da37daad786dbabe2db830174953730667d60) ([merge request](gitlab-org/gitlab!79780))
- [Fix NoMethodError for RefsController](gitlab-org/gitlab@3879534f816b427673121c3dd26c48da6bfb52df) ([merge request](gitlab-org/gitlab!79779))
- [Merge stable Jobs/Deploy.gitlab-ci.yml into latest](gitlab-org/gitlab@c01598fdb32e5e3aec0d3a608b75aa8e3535c0ad) ([merge request](gitlab-org/gitlab!79240))
- [Create specific CE display_public_email? user helper](gitlab-org/gitlab@5a56f514c62d8777275b5e2b9b687662a224e654) ([merge request](gitlab-org/gitlab!79752))
- [REST: Fix scope of GET /projects/:id/runners endpoint](gitlab-org/gitlab@b5ded2bc9ea6bc91ec1e58f2fba14829517d9ca5) ([merge request](gitlab-org/gitlab!79733))
- [Validate that reference exists for atom format](gitlab-org/gitlab@b5b4bdf20caaf3848f561a2c9bdeee8f86ed6e9b) ([merge request](gitlab-org/gitlab!79635))
- [Fix reverse tabnabbing vulnerability with improper URL protocol](gitlab-org/gitlab@2a025add6edc4eb9a096b5ce9d34444fe0167cb1) ([merge request](gitlab-org/gitlab!79727))
- [Allow mergeability check when merge_status is already checking](gitlab-org/gitlab@b535f1ff45c8d661ba1c9818b26f5a41b32ae5ad) ([merge request](gitlab-org/gitlab!79723))
- [Validate sort parameter for branches page and branches API](gitlab-org/gitlab@f3158d91ec05339d0ba7a2205505dbffa6b58e68) ([merge request](gitlab-org/gitlab!79476))
- [Fix deep linking into settings panels](gitlab-org/gitlab@850f979021d81c0a5b33dea54d6151d8e2563b2c) ([merge request](gitlab-org/gitlab!79689))
- [Deduplicate findings by comparing the UUIDs](gitlab-org/gitlab@179484a367405777e3e20cffc6b0d68dc6dc4f1a) ([merge request](gitlab-org/gitlab!79680)) **GitLab Enterprise Edition**
- [Fix Popen not always returning error code](gitlab-org/gitlab@93b8cae9c68a9fc5a3eeeb1a638a05215ee96730) ([merge request](gitlab-org/gitlab!79564))
- [REST: Follow shared runners setting](gitlab-org/gitlab@4f12dcf77f622ecff4741f40e5b7774c7f9ab556) ([merge request](gitlab-org/gitlab!79448))
- [Fix spacing issue in the packages version details](gitlab-org/gitlab@8c794e8b3cb7ea3822122f489c74cfb84c1a7bfb) ([merge request](gitlab-org/gitlab!79622))
- [REST: Fix scope of /groups/:id/runners?type endpoint](gitlab-org/gitlab@16bfce401ad2e3e55f83745b568d6c9214d065ad) ([merge request](gitlab-org/gitlab!79447))
- [Add darkmode variant for black-normal color](gitlab-org/gitlab@822f913bda58929d923f67952ab96c5c309cb04e) ([merge request](gitlab-org/gitlab!79232))
- [Enable Zip64 support](gitlab-org/gitlab@908ff65d87aa29acaa9a41bb6aac606a8a38b747) ([merge request](gitlab-org/gitlab!79596))
- [Fix arrow that was overlapping button in Admin -> Users](gitlab-org/gitlab@bdb0a9bb8cdb7ac8f5d1b7cadda5a9050473e683) by @orozot ([merge request](gitlab-org/gitlab!79029))
- [Fix search term case sensitivity for transfer namespace](gitlab-org/gitlab@d8256211ca5a786aafbf07348c9d94f33acaa4f9) ([merge request](gitlab-org/gitlab!79595))
- [Show underscores in branch name in merge request](gitlab-org/gitlab@0ce5bd488f89fc46c7758f654d8e942049118540) by @brcampbell1 ([merge request](gitlab-org/gitlab!79566))
- [Fix editor browser modal when creating new MR](gitlab-org/gitlab@df3db1dfd6f5362c5b67bf8cf871fc4b20a42160) ([merge request](gitlab-org/gitlab!79032))
- [Fix NoMethodError when commit is missing](gitlab-org/gitlab@78ae06a4f0a51674a4c124892ca027f15493c594) ([merge request](gitlab-org/gitlab!79553))
- [Fix incorrect render in JUnit merge UI with null or blank name value](gitlab-org/gitlab@2234a465e8cc7590023f6cd8703abca29e6f01ed) ([merge request](gitlab-org/gitlab!79539))
- [Add id to user of ZentaoSerializers](gitlab-org/gitlab@866d958584a5cf68c9c29de7265537b6d2e087a2) by @icbd **GitLab Enterprise Edition**
- [Remove invalid groups from sharing in invite group modal](gitlab-org/gitlab@cae3614ee9fa59a0c22259bba48c06bac4830a80)
- [Add id to user of ZentaoSerializers](gitlab-org/gitlab@7fe670bfd0c8372083a54aae45059e2473e62ebb) by @icbd ([merge request](gitlab-org/gitlab!79205)) **GitLab Enterprise Edition**
- [Remove invalid groups from sharing in invite group modal](gitlab-org/gitlab@fd5a6666de48c18d43935ca6859502251d95f66b) ([merge request](gitlab-org/gitlab!79036))
- [Revert "Merge branch 'revert-b59c6630' into 'master'"](gitlab-org/gitlab@26ec9653da00ab073103c4635649fbf2b8189d1f) ([merge request](gitlab-org/gitlab!79391))
- [Geo: Mark object stored files verified](gitlab-org/gitlab@8c91e7cbe273b92a7e5efda8eb5ad1753f11ecf5) ([merge request](gitlab-org/gitlab!79469)) **GitLab Enterprise Edition**
- [Fix exception when epic has no author](gitlab-org/gitlab@43f8b543ac0a51b8ccc0bb629161c678199174d0) ([merge request](gitlab-org/gitlab!79252))
- [Use finding signatures in deduplication logic](gitlab-org/gitlab@7b452dba078bce8c931dab02f0a25de126fbb291) ([merge request](gitlab-org/gitlab!79491)) **GitLab Enterprise Edition**
- [Use strong parameters for CommitsController](gitlab-org/gitlab@b5d792d527aa48e47779490dc8ebafcfd70035e5) ([merge request](gitlab-org/gitlab!79485))
- [Don't return 500 error for tags in atom format](gitlab-org/gitlab@3f0579e178b4205cb157ee209cc8c7949891e47f) ([merge request](gitlab-org/gitlab!79483))
- [Use strong_parameters for ForksController#index](gitlab-org/gitlab@824dce639f1039cc5422701d5fc2baf43d9e9864) ([merge request](gitlab-org/gitlab!79482))
- [Fix NoMethodError for empty changelog](gitlab-org/gitlab@aedbd810e7052fc14e49beeabac3f3e1f4de3fa7) ([merge request](gitlab-org/gitlab!79481))
- [Fix typo in RepositoryController#cleanup](gitlab-org/gitlab@f2194e69d0b9311e95106aa6752a025b9821a931) ([merge request](gitlab-org/gitlab!79480))
- [Restrict pagination per_page possible values](gitlab-org/gitlab@459e83fd5595ebdf1600a302791057f1ae28f3e8) ([merge request](gitlab-org/gitlab!79479))
- [Fix input parameter validation for tags controller](gitlab-org/gitlab@47730e3e159d7a5bdd6299845055528c965c3d09) ([merge request](gitlab-org/gitlab!79464))
- [Fix NoMethodError for UnfoldPresenter](gitlab-org/gitlab@2add7932af1a3f52ee18a9f6e42be6a4d0a22401) ([merge request](gitlab-org/gitlab!79468))
- [Deprecate and replace MR with approval rules metric](gitlab-org/gitlab@50f221fed9ccca74cfe989b9517a78053b07f181) ([merge request](gitlab-org/gitlab!78664)) **GitLab Enterprise Edition**
- [Sign out before redirecting to login page](gitlab-org/gitlab@0878ebf82ad9b7144651208af5d8c6614f4d9f02) ([merge request](gitlab-org/gitlab!78214))
- [Restore the lost success event handler for hiding the verification modal](gitlab-org/gitlab@f6c336e990e25dbaf483395ea59c329402355b62) ([merge request](gitlab-org/gitlab!79422)) **GitLab Enterprise Edition**
- [Dedup Ci::RunnerProjects](gitlab-org/gitlab@5db54a84dc56e8428f8173932ac9435ea146859f) ([merge request](gitlab-org/gitlab!79011))
- [Allow searching of users using less than 3 chars](gitlab-org/gitlab@2f85f21f11f8b53d3800a9bb8ddf5bc9482a495c) ([merge request](gitlab-org/gitlab!79401))
- [Allow all users within a group to view all compliance frameworks](gitlab-org/gitlab@b7eb6ed70ce602db00bb3f3afdee416e6161a2f2) ([merge request](gitlab-org/gitlab!79133)) **GitLab Enterprise Edition**
- [Sort vulnerability identifiers on ingestion to prevent Deadlock errors](gitlab-org/gitlab@d0ea399892e21a55236474c9f1fe74d16a66671f) ([merge request](gitlab-org/gitlab!79372)) **GitLab Enterprise Edition**
- [Refactor issue move to not require group_id param](gitlab-org/gitlab@88512cefa5455e3926534a0034c8cddc6cef10bb) ([merge request](gitlab-org/gitlab!79309))
- [Pass URI to elasticsearch client instead of string](gitlab-org/gitlab@598d3969e5415dbea216b48192f16eccf623d1ee) ([merge request](gitlab-org/gitlab!79374)) **GitLab Enterprise Edition**
- [Add rouge-ruby Comment.Doc style support](gitlab-org/gitlab@fa82d19c9d38f3a7f66a95a968db0543d4920bdc) by @zsgsdesign ([merge request](gitlab-org/gitlab!78985))
- [Fix long label overflow in the sidebar](gitlab-org/gitlab@56b30f0b39d064148061eedc1a92ccd716f4c181) by @smortex ([merge request](gitlab-org/gitlab!79181))
- [Fix hidden notifications dropdown on smaller screens](gitlab-org/gitlab@a4f5719d014c599309f659f1f89fc299dd38f551) ([merge request](gitlab-org/gitlab!79360))
- [Change epic list payload variable to uppercase](gitlab-org/gitlab@33036955a69da8d1fc1ec02ee0a43af30ee52910) by @orozot ([merge request](gitlab-org/gitlab!79359)) **GitLab Enterprise Edition**
- [Change trials_link_url name to callouts_trials_link_url](gitlab-org/gitlab@c230624921248c16c52975eb1a63704c5e224133) by @orozot ([merge request](gitlab-org/gitlab!79338)) **GitLab Enterprise Edition**
- [Only call the resolved service if we resolve all the active notes](gitlab-org/gitlab@382c653cc88f86876bf8c8d18fc56bb2cb1c77d8) ([merge request](gitlab-org/gitlab!79142))
- [Gracefully handle unexpected severities in code quality report](gitlab-org/gitlab@5de9508be618cc0a169ff04460ad6dc21066e388) ([merge request](gitlab-org/gitlab!79304))
- [Ensure mergeability check runs on specific cases](gitlab-org/gitlab@76e5f067c857cf3b3a440becfb0503c4a6efd32b) ([merge request](gitlab-org/gitlab!79311))
- [Re-align "Register" and "Cancel" buttons in Agent installation modal](gitlab-org/gitlab@17fe351f237858ca3d36c02cbab46e8021fc6fb2) ([merge request](gitlab-org/gitlab!79188))
- [Geo: Fix verification failures of remote stored files](gitlab-org/gitlab@177468e219c291b1f3feb2be9f0eb5be7c05503b) ([merge request](gitlab-org/gitlab!79303)) **GitLab Enterprise Edition**
- [Update project export job status upon failure](gitlab-org/gitlab@c62d89cd2fb592b1f9d7d0d6c3268960ea00ac93) ([merge request](gitlab-org/gitlab!79257))
- [GitLab Version - CE Admin Dashboard](gitlab-org/gitlab@54f7c39067823b7ee84f465b24c4c1fa273c6936) ([merge request](gitlab-org/gitlab!79258))
- [Ensure git url validation is always performed](gitlab-org/gitlab@a7f879ba216b492b708769aa2a579fc8cb98e7e7) ([merge request](gitlab-org/gitlab!78495))
- [Bump default auto-deploy-image to 2.18.1](gitlab-org/gitlab@a7460adf86ad62cfe43dfca8acb9350daa425cce) ([merge request](gitlab-org/gitlab!79280))
- [Set class name for the proxy ingestion tasks](gitlab-org/gitlab@a2ea0d058a26ddd2252ca6909d55f69f5dd056bb) ([merge request](gitlab-org/gitlab!79169)) **GitLab Enterprise Edition**
- [Show issuable reference title in milestone description](gitlab-org/gitlab@934f4af115958fffefb4226f47eafa2a3a89bf8e) by @wwwjon ([merge request](gitlab-org/gitlab!79027))
- [Prevent Group API N+1 loading group plans](gitlab-org/gitlab@3182a9464822dc2d15c61fc1c6fa970e7fd267c4) ([merge request](gitlab-org/gitlab!77538)) **GitLab Enterprise Edition**
- [Fix issue sticky header doesn't align left in fluid layout](gitlab-org/gitlab@01c21d394117a817945fc255eab8696cd1c012a2) ([merge request](gitlab-org/gitlab!78859))
- [Enable ci_order_subsequent_jobs_by_stage by default](gitlab-org/gitlab@c1bdf8f2b8822fe813a5878be1af765ee02fb594) ([merge request](gitlab-org/gitlab!79109))
- [Exempt bot users for groups from license seat usage](gitlab-org/gitlab@9184bcd07d77365bd2cf8619405377854ce19619) by @fh1ch ([merge request](gitlab-org/gitlab!79101)) **GitLab Enterprise Edition**
- [Fix incorrect max_seats_used values](gitlab-org/gitlab@038167790afec90fb7103f69a4d9d2d087670f1e) ([merge request](gitlab-org/gitlab!78107))
- [Fix the primary button on KAS installation modal](gitlab-org/gitlab@14f8afedc140ab9c09e219d15547a7e33ccac50b) ([merge request](gitlab-org/gitlab!78864))
- [Fix typo in message](gitlab-org/gitlab@06e7bbc631bf6810ef7206914007d47ceb25a5cd) ([merge request](gitlab-org/gitlab!78900))
- [Fix broken references when previewing SP payload](gitlab-org/gitlab@a50e2bbd844d6f67962baebb1eb1b80da408b8d5) ([merge request](gitlab-org/gitlab!78701))
- [Use Bitbucket repo description over project description when importing](gitlab-org/gitlab@e0399247740c320a27152eafca593cf879c28c44) by @nicosullivan ([merge request](gitlab-org/gitlab!78160))
- [Guard create issue button in boards against submitting spaces](gitlab-org/gitlab@36ecfa9f819cf59a460d448c559bf1143161d1e3) by @sstern ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/78505))
- [Replace offsetTop with getBoundingClientRect for roadmap_setting panel](gitlab-org/gitlab@f078cf8f1e8fc69a089df939f746dd49870b2f93) by @orozot ([merge request](gitlab-org/gitlab!78992))
- [Fix import/export not checking upload result](gitlab-org/gitlab@b67a5b5a12498d57cd877023b7385f7251e57de8) ([merge request](gitlab-org/gitlab!78905))
- [Update `resolved_on_default_branch` attribute in batches](gitlab-org/gitlab@683e1c9e5ac33b809a14deb21ecedb77cf63cef9) ([merge request](gitlab-org/gitlab!78960)) **GitLab Enterprise Edition**
- [Add missing Git authentication support for group level bot build tokens](gitlab-org/gitlab@3a1dae667023be8cc5b04472faa39a0cc6cb3fc8) by @fh1ch ([merge request](gitlab-org/gitlab!78595))
- [Update `Project.updated_at` if other timestamps change](gitlab-org/gitlab@b21f9db220caf2dea304ccf138587b8192e11178) by @wwwjon ([merge request](gitlab-org/gitlab!78572))
- [Remove project loads for dast profiles policy checks](gitlab-org/gitlab@34efffe85f13c306572e83ae16b0e93dbeac3e11) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/78312)) **GitLab Enterprise Edition**
- [Do not require credit card validation when it is present](gitlab-org/gitlab@75b2eba0df0949692ce776d46dd8e4e87e34b974) ([merge request](gitlab-org/gitlab!78910)) **GitLab Enterprise Edition**
- [Fix CI instance variable cache misses](gitlab-org/gitlab@0410fb860b32971f59786cc9cbdbabe254c5fd65) ([merge request](gitlab-org/gitlab!78944))
- [Fix cluster integration HTTP adapter](gitlab-org/gitlab@332652b988fe017ceba8ac79dd1ae17550b9b57d) ([merge request](gitlab-org/gitlab!78737))
- [Clear childrenEpic state when changing roadmap sort order](gitlab-org/gitlab@41c3324c8706659be7f926e5c0a98bb4b05247ff) by @espadav8 ([merge request](gitlab-org/gitlab!78275)) **GitLab Enterprise Edition**
- [Prevent compliance pipelines from overwriting child pipelines](gitlab-org/gitlab@b3dcb160802e8ef4319638fb657a4d39070eecce) ([merge request](gitlab-org/gitlab!78878)) **GitLab Enterprise Edition**
- [Fix selection summary not showing on vulnerability report](gitlab-org/gitlab@e3bbcc5bf2a4518ede0cd0ad8955f5df1ee6dbec) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/78869)) **GitLab Enterprise Edition**
- [Fix runner count when tabs are used](gitlab-org/gitlab@0805e28d115c312361852eed4f5ef6ab05aa4329) ([merge request](gitlab-org/gitlab!78706))
- [fix: Fix incorrect il8n referenece for Vulnerability Dismissal](gitlab-org/gitlab@5cd6952fb8712d3311fef16993825cd54aceee9f) ([merge request](gitlab-org/gitlab!78692)) **GitLab Enterprise Edition**
- [Allow strings and nested arrays of strings for before/after script](gitlab-org/gitlab@1163adc7f0d6d63bb51141d7a82fdf70b98c3912) by @guillaume.chauvel ([merge request](gitlab-org/gitlab!74792))
- [Extract MergeRequestDiffCommit deletions](gitlab-org/gitlab@b545abbf102de8137757fbef9b714bd477f7e4c4) ([merge request](gitlab-org/gitlab!75963))
- [Reject MIME parts with unsupported encoding](gitlab-org/gitlab@516891d681ef14b4c816cc3d7a5ff4f57b67f1fb) ([merge request](gitlab-org/gitlab!77688))
- [Add user's preferred language to cache key of MR title partial](gitlab-org/gitlab@93ae17ec2c56f2512d44822b048a77604812ce0d) ([merge request](gitlab-org/gitlab!78640))
- [Transition abuse_reports_controller spec](gitlab-org/gitlab@50d9c79a072419445b40b706eba3857a969eeb31) by @leetickett ([merge request](gitlab-org/gitlab!76922))
- [Calculate location fingerprint by signature for findings if available](gitlab-org/gitlab@32bf56fc2930eceee9593dacaecb833cedda9848) ([merge request](gitlab-org/gitlab!78389)) **GitLab Enterprise Edition**
- [Extend Google Cloud Storage max transfer timeout to 60 minutes](gitlab-org/gitlab@4fe77a6a5f7525a3a8c31015c13b0b4e5529dbda) ([merge request](gitlab-org/gitlab!78526))
- [Add spacing for pipeline editor alert close button](gitlab-org/gitlab@aa5434f27c5b88b0beb28a83127113a3b779e8ba) ([merge request](gitlab-org/gitlab!78600))
- [Fix check for valid custom pages domains](gitlab-org/gitlab@71f3a88ce7265521fc8ea6aa5e570dc6a548f244) by @mlegner ([merge request](gitlab-org/gitlab!77247))
- [Add missing tooltip and aria-label for commit description toggle](gitlab-org/gitlab@4644573dfc97d5d79dbb8c26204a90db60438d5e) by @nicosullivan ([merge request](gitlab-org/gitlab!78969))
- [Users who can read project can read bot names](gitlab-org/gitlab@933798cc498d4fe6c39e248e2009624c8f4bb475) ([merge request](gitlab-org/gitlab!78319))

### Changed (216 changes)

- [Use GlAvatar in env dashboard project header](gitlab-org/gitlab@3fcf9edaf55f39a3dfb9744c33c342aa8ff8c5bf) ([merge request](gitlab-org/gitlab!80776)) **GitLab Enterprise Edition**
- [Remove legacy license compliance approval_status](gitlab-org/gitlab@4db506dc60af05418325c9dc39ef145717873bb5) ([merge request](gitlab-org/gitlab!79266)) **GitLab Enterprise Edition**
- [Allow setting feature flag for a single namespace](gitlab-org/gitlab@1a6dd64eea9cf49f126ee2ae861bd3630fd6a38f) ([merge request](gitlab-org/gitlab!79555))
- [No-coverage lines more prominent than covered lines](gitlab-org/gitlab@2c7db3fff1130dede6a0355ff2da7f4ca0f810bf) by @MMSandal ([merge request](gitlab-org/gitlab!80743))
- [Global Search - Optimize SearchContext](gitlab-org/gitlab@b90de6c9ed456d0565c7217a02867ad0c3e0562b) ([merge request](gitlab-org/gitlab!80791))
- [Geo: Job Artifacts replication using SSF](gitlab-org/gitlab@4fbccfcb2451faff6fc63e0442ed53c2c76d3fd4) ([merge request](gitlab-org/gitlab!75264))
- [Update to Puma 5.6.2](gitlab-org/gitlab@624a6067225cda864cfb5c5651fadfbd12303236) ([merge request](gitlab-org/gitlab!80583))
- [Handle invalid URL for DAST Site Profile](gitlab-org/gitlab@ebdb3c04444c84c047a4f9e33e67d2caac8b902b) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/80170))
- [Use `system-err` if no failure/error message was given in JUnit output](gitlab-org/gitlab@80a6a3e1a1fcbdf270563be22b8acd269e8f5843) by @jdyl ([merge request](gitlab-org/gitlab!80722))
- [Use pagination for vulnerability report](gitlab-org/gitlab@87cf025cc9b062832e943640d43caf5868f6ed98) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/79834)) **GitLab Enterprise Edition**
- [Handle invalid URL for DAST Site Profile](gitlab-org/gitlab@5407670fa2354448ae76de2f78b9435a360ce825) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/80170))
- [Handle invalid URL for DAST Site Profile](gitlab-org/gitlab@4523782fcf363bb0109a178a95db22821e2a4446) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/80170))
- [Updated the docs to include new agent information](gitlab-org/gitlab@286336517a481e3b8bcfe4e82519807ea41b6e7b) ([merge request](gitlab-org/gitlab!80748))
- [Fixed constant wording for clearer understanding](gitlab-org/gitlab@91cc7057ba05de5d194d7e6a0a2616761a4a286c) ([merge request](gitlab-org/gitlab!79167)) **GitLab Enterprise Edition**
- [Remove feature flag for the container registry Google CDN feature](gitlab-org/gitlab@8a642b8e42927944ff84041dd5f76e3389713d63) ([merge request](gitlab-org/gitlab!80622))
- [Add jobs template for Dependency Scanning and License Scanning](gitlab-org/gitlab@f99974161fb323a0a59481ae48fcd544d9d2bd98) ([merge request](gitlab-org/gitlab!79454))
- [Replicate integrations indices for type_new](gitlab-org/gitlab@bc3cf1581c3b87158deba2d3227572485667b2bf) ([merge request](gitlab-org/gitlab!80560))
- [Add missing translations](gitlab-org/gitlab@1bd3800b5e277da103d1fbb85eaa971085af15b2) ([merge request](gitlab-org/gitlab!80616)) **GitLab Enterprise Edition**
- [Replace the bitbucket import modal with a GlModal](gitlab-org/gitlab@516ee15f05ef5464ea09365156c84bfbb93e9e52) ([merge request](gitlab-org/gitlab!80434))
- [Update status icons for requirements](gitlab-org/gitlab@e4d5c3cb1c261381217edd4241c2e29c477fa65f) ([merge request](gitlab-org/gitlab!80775)) **GitLab Enterprise Edition**
- [Bump cluster management project template for 14.8](gitlab-org/gitlab@cccd05e3f420e792e8d5c915705c16d6093072af) ([merge request](gitlab-org/gitlab!80646))
- [Remove dast_sharded_cloned_ci_builds feature flag](gitlab-org/gitlab@dc522c8879c4b954340bf88d129a8dc481c6998b) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/80133)) **GitLab Enterprise Edition**
- [Switch to GlTabs for markdown header component](gitlab-org/gitlab@51c05183e669c617c6c979337efc263a84f71e9b) ([merge request](gitlab-org/gitlab!80153))
- [Link by commit and name for pipeline](gitlab-org/gitlab@8bf2a9fbae8b32dff090e7ec5660f7338e8ae2ab) ([merge request](gitlab-org/gitlab!80648))
- [Add approvers when editing scan result policies](gitlab-org/gitlab@b40ee4d12ea1e69ce381fed00d6672d3c7068092) ([merge request](gitlab-org/gitlab!80029)) **GitLab Enterprise Edition**
- [Move findings deletion into a worker](gitlab-org/gitlab@1a231d0e573fc5e3a6597c01514bebe0c841f18c) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/80096)) **GitLab Enterprise Edition**
- [Replace window.confirm with GlModa in deployment actions](gitlab-org/gitlab@b678d445835befcba9a6d7afa6abf37aba570a6d) ([merge request](gitlab-org/gitlab!80360))
- [Modify upload license error language](gitlab-org/gitlab@d689744100e3e655a40ce619a55484e46709bfce) ([merge request](gitlab-org/gitlab!80382)) **GitLab Enterprise Edition**
- [Make integrations type_new trigger null-safe](gitlab-org/gitlab@2e114fcee3ceb294d2a95d415824446c3a4f2b4a) ([merge request](gitlab-org/gitlab!80537))
- [Default on :cluster_vulnerabilities feature flag](gitlab-org/gitlab@38e34090ed9b4e942d7dc58ff40ef7e331c698f4) ([merge request](gitlab-org/gitlab!78140))
- [Improve UI message for unfinished pipelines](gitlab-org/gitlab@be41aa289d597e69b75b249cfff4b92d3ede46f1) ([merge request](gitlab-org/gitlab!74726))
- [Drop temporary index on vulnerability_occurrences](gitlab-org/gitlab@f09b6071cb33947ce175cdbd1fd2bbb3ef5566bf) ([merge request](gitlab-org/gitlab!52120))
- [Change file input on upload license page to a dropzone](gitlab-org/gitlab@ce1c426d689ace07641add0904266d5b204dbc31) ([merge request](gitlab-org/gitlab!77363)) **GitLab Enterprise Edition**
- [Allow offline cloud license upload](gitlab-org/gitlab@98215f5eb33afe0b1d8eb97a00d78abc8a4eb757) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/79957)) **GitLab Enterprise Edition**
- [Improve UI text of group settings page](gitlab-org/gitlab@360db80bf29eef546a8ca0ffb3ae7ddb675178e3) ([merge request](gitlab-org/gitlab!80457))
- [Edit UI text to comply with standards](gitlab-org/gitlab@1759c46e43f36f779f621918162c5470c892cf63) ([merge request](gitlab-org/gitlab!80460))
- [Show default value in squash and merge commit template textareas](gitlab-org/gitlab@0c5beda938d90b9de6292cb306e87e4c138abc88) by @trakos ([merge request](gitlab-org/gitlab!77081))
- [Treat API requests from the frontend as web traffic in the rate limiter](gitlab-org/gitlab@5e823d824aa416b6b8bcf5cf88b3d42a6a78a46a) ([merge request](gitlab-org/gitlab!80404))
- [Update KAS to v14.8.1](gitlab-org/gitlab@f873b6569b995f36d48d208e8fc6230d3e535c4a) ([merge request](gitlab-org/gitlab!80527))
- [Put feature flag for reading from finding_evidence](gitlab-org/gitlab@a6d2e2039620ffb673eb562f7303786c1601db34) ([merge request](gitlab-org/gitlab!79883)) **GitLab Enterprise Edition**
- [Remove the border from the signub box on the trial registration page](gitlab-org/gitlab@2e5ba72dd5419e5910073e984b1d8f9cdd9154f1) ([merge request](gitlab-org/gitlab!80451)) **GitLab Enterprise Edition**
- [Upgrade CI images to Debian bullseye](gitlab-org/gitlab@b66c5cb36cab22595d53b1102a3878344eb58ef5) ([merge request](gitlab-org/gitlab!80362))
- [Update confirmation button variant and label](gitlab-org/gitlab@989a28c17d160710b9fb7cf317832c7f6cadd708) ([merge request](gitlab-org/gitlab!80357))
- [Limit on-demand scans tabs counts](gitlab-org/gitlab@9bdccd695718d3f05396a475a581deb964d51d02) ([merge request](gitlab-org/gitlab!79851)) **GitLab Enterprise Edition**
- [Bump Gitlab Shell version to 13.23.2](gitlab-org/gitlab@e553f5ae6df2f5fa456a15df57b15f9b26bba79d) ([merge request](gitlab-org/gitlab!80462))
- [Geo Sites - Filter by Search](gitlab-org/gitlab@d8479184c7b267d01cf4bce331fd9e467f3c27eb) ([merge request](gitlab-org/gitlab!79550)) **GitLab Enterprise Edition**
- [Add feature flag toggle for elastic migration worker](gitlab-org/gitlab@b3c1a78908ba4d111d835564f6da08792876c6f2) ([merge request](gitlab-org/gitlab!80310)) **GitLab Enterprise Edition**
- [Add a memory report link in the Performance Bar](gitlab-org/gitlab@558e451c5b6116999f21cb3b13c5a6bcc207983a) ([merge request](gitlab-org/gitlab!78670))
- [Add vue js fork confirmation modal](gitlab-org/gitlab@4c6fe2801a8324a528a3993af8e6c194af12f2a8) ([merge request](gitlab-org/gitlab!77549))
- [Jira create branch: Alert when lacking permissions](gitlab-org/gitlab@0e18d47cb92efea8f3b485db38c0dc6025bf6357) ([merge request](gitlab-org/gitlab!80043))
- [Replace window.confirm with GlModa in pipeline manual actions](gitlab-org/gitlab@a40410512357a713bc6a24168fa7237ced9275ea) ([merge request](gitlab-org/gitlab!80156))
- [Exclude guests being billable for ultimate trials](gitlab-org/gitlab@16a78be09a86450bd484ec4c0feeb4cb4872bdd2) ([merge request](gitlab-org/gitlab!80284)) **GitLab Enterprise Edition**
- [Add message for user count overage](gitlab-org/gitlab@e4375a34b6b3807082dfe3273df1f59063430666) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/80149)) **GitLab Enterprise Edition**
- [Refactor NamespaceStatistics into CE](gitlab-org/gitlab@2bae697a4dea21e3245e2a787cbe434364500f40) ([merge request](gitlab-org/gitlab!79657))
- [Remove limited class from global_alert](gitlab-org/gitlab@f96def7496ad0ea4167d8aea93f8f539f19ed634) ([merge request](gitlab-org/gitlab!79235))
- [Changed the deployment target option](gitlab-org/gitlab@3f42f9045ea6b66d06887c1f7d8bf2d46b63303b) ([merge request](gitlab-org/gitlab!80262))
- [Remove `ci_skip_require_credit_card_for_addon_ci_minutes` feature flag](gitlab-org/gitlab@6c147ac4da49c2a9d2ec2600b9a5b00740e366b3) ([merge request](gitlab-org/gitlab!80252))
- [Make rate limiting of /users/:id configurable](gitlab-org/gitlab@cd6ddb364e267832e5253fd522f36c7520fe55cf) ([merge request](gitlab-org/gitlab!78364))
- [Use better colors for activity calendar in darkmode](gitlab-org/gitlab@00ab070d0bebf657505cb6f64d06d8f8cb474805) ([merge request](gitlab-org/gitlab!79838))
- [Convert timestamps to utc in license usage export](gitlab-org/gitlab@34bea73fad73634d477f4e8fc3a17feecae28dd0) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/79832)) **GitLab Enterprise Edition**
- [Update copy for API Security in DAST](gitlab-org/gitlab@54ed61d49bccd522d9a988219d46871ee190348c) ([merge request](gitlab-org/gitlab!80068))
- [Exclude pending_destruction packages when creating one](gitlab-org/gitlab@0b64d92f6f1b4f1ff8d1fb9db5296c57ab79a033) ([merge request](gitlab-org/gitlab!79868))
- [Set danger variant and label to leave group](gitlab-org/gitlab@b1ffd91f033965e724624e4c3d86cebf2c42f819) ([merge request](gitlab-org/gitlab!80141))
- [Clean up Create Branch from Jira form](gitlab-org/gitlab@4a005a4717f9a07464b91c38435401db554b9d0f) ([merge request](gitlab-org/gitlab!79922))
- [Improve retry tooltip for failed pipeline](gitlab-org/gitlab@52d9593e4a7687c729ee5a830abd16f99ff9a28f) ([merge request](gitlab-org/gitlab!79888))
- [Deprecate custom geo:db:* rake tasks in favor of built-in tasks](gitlab-org/gitlab@40a486187ca788df77a3c68c59cef747de3921a9) ([merge request](gitlab-org/gitlab!77269)) **GitLab Enterprise Edition**
- [Make squash/rebase failed messages better](gitlab-org/gitlab@ce088cd40744369654bfdd190b59355a23a09056) ([merge request](gitlab-org/gitlab!79152))
- [Enable storage purchase via GitLab by default](gitlab-org/gitlab@2cfec65140f29fa1918d9e1ea69e076670ed6dc9) ([merge request](gitlab-org/gitlab!80058))
- [Remove early_prepare_for_mergeability feature flag](gitlab-org/gitlab@1f646ea8b36682350df111946896a9897b3cd35a) ([merge request](gitlab-org/gitlab!80042))
- [Add tooltip to project variables in CI/CD settings](gitlab-org/gitlab@78261494cfaa90425463d9d87cba366412b921cc) ([merge request](gitlab-org/gitlab!79778))
- [feat: Bump major security-code-scan sast version for 15.0](gitlab-org/gitlab@925cee67b9501fbc3075294b4fc6e5b5980fb374) ([merge request](gitlab-org/gitlab!79569))
- [Add link to group pipeline usage quota](gitlab-org/gitlab@c68833b096566bf2197a4b69fb61808fc0e727d8) ([merge request](gitlab-org/gitlab!79969))
- [Update auto-build-image to v1.5.0](gitlab-org/gitlab@bda3b9d031628b97e5b0f940288d04688546d400) ([merge request](gitlab-org/gitlab!79652))
- [Update Go to version 1.17.6, workhorse](gitlab-org/gitlab@bf63170d547a9965e953ad4403f7f6b8b636d5ea) ([merge request](gitlab-org/gitlab!79562))
- [Simplify CI_DEPLOY_FREEZE conditions in Auto DevOps](gitlab-org/gitlab@1674b4b15fc2237d9e75d2b86937807fe9eb0fac) ([merge request](gitlab-org/gitlab!79976))
- [Replace window.confirm with GlModal for noteable notes delete and edit](gitlab-org/gitlab@67679f46b7399ac11e6909ef3f0de6e2161d88ef) ([merge request](gitlab-org/gitlab!78879))
- [Add severity level to compliance violations table](gitlab-org/gitlab@8faf152a534b0c8b0514e0bb5ede6bca0a804fec) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/79523))
- [Move VSA metrics to shared analytics](gitlab-org/gitlab@20c17ab23d33a88ca32d6365fa9a00c891e9d656) ([merge request](gitlab-org/gitlab!79824)) **GitLab Enterprise Edition**
- [Remove redundant index_epic_issues_on_epic_id](gitlab-org/gitlab@08ea1d3852ceb280560ae98125d211c03fd3b10d) ([merge request](gitlab-org/gitlab!79925))
- [Remove vue_integration_form feature flag](gitlab-org/gitlab@d60c6f464aa6e687a517b82aa144f6e0f48a9fb5) ([merge request](gitlab-org/gitlab!79603))
- [Remove enable_ci_variable_caching feature flag](gitlab-org/gitlab@5d1068bda295b3a101d3f4121a02ed56dafb142e) ([merge request](gitlab-org/gitlab!79819))
- [Improve the project deletion UI text](gitlab-org/gitlab@2ff35c24dbde968c4af93ca9fca5e77d95a4003f) ([merge request](gitlab-org/gitlab!79363))
- [Improve copy on Slack app delete project modal](gitlab-org/gitlab@60534c0224e1885b8ddc745731ef0b53f07d067c) ([merge request](gitlab-org/gitlab!79714)) **GitLab Enterprise Edition**
- [Improve delete webhook modal copy](gitlab-org/gitlab@67f5c772edc13f009f10d6404c528dea1cd1421c) ([merge request](gitlab-org/gitlab!79718))
- [Change protected branches selector internals](gitlab-org/gitlab@0c6f228a682c57dbe4c3cb307affc61532773721) ([merge request](gitlab-org/gitlab!79451)) **GitLab Enterprise Edition**
- [Alias wip* methods to -> draft*](gitlab-org/gitlab@90065a2b84eaefcc91ad2c980519e801a15f2072) ([merge request](gitlab-org/gitlab!79797))
- [Remove new_route_ci_minutes_purchase feature flag](gitlab-org/gitlab@d3015405004b601e6437783c2db34080cd380aa2) ([merge request](gitlab-org/gitlab!79686))
- [Remove WIP support from commits](gitlab-org/gitlab@8ddead16dc42e8bee7b0bda92426647cfe982927) ([merge request](gitlab-org/gitlab!79695))
- [Add tooltips for pipeline icons](gitlab-org/gitlab@bf22bf798f3dbdbe73d5d4aacc3cd9dabbc7afd7) ([merge request](gitlab-org/gitlab!79763))
- [Hide `None` & `Any` token wildcards](gitlab-org/gitlab@2b9a731b7dade094ecbeed81f21371a954450db6) ([merge request](gitlab-org/gitlab!79728)) **GitLab Enterprise Edition**
- [Give immediate feedback when awarding an issuable](gitlab-org/gitlab@84deccab35365609acd102422ba21cd834fbf497) by @KevSlashNull ([merge request](gitlab-org/gitlab!75808))
- [Remove WIP support from Merge Requests](gitlab-org/gitlab@97abfb8bfae9eac9be50b646c8d1124357e79c3f) ([merge request](gitlab-org/gitlab!79693))
- [Undo filter milestones dropdown in boards by state](gitlab-org/gitlab@e18f2711f1c6445b9274386799f562f6167ed395) by @sstern ([merge request](gitlab-org/gitlab!79554))
- [Fix Kubernetes Agent label capitalization](gitlab-org/gitlab@f85c259b0e6f494f4d54e9028e4a1c01bb5f2328) ([merge request](gitlab-org/gitlab!79682))
- [Add quickSuggestions to Pipeline Editor](gitlab-org/gitlab@38f1fc7e4c34c01a3c3bbe0c0ffa4f1c6bbe807b) ([merge request](gitlab-org/gitlab!79670))
- [Update bitbucket logo](gitlab-org/gitlab@aeefdd9df3bcc5a15a80f7181fc754ccc0fedee7) ([merge request](gitlab-org/gitlab!69192))
- [Update Atlassian logo](gitlab-org/gitlab@a6a21292151826f56b1cd4e74fa6c2a95094413d) ([merge request](gitlab-org/gitlab!69194))
- [Update Twitter logo](gitlab-org/gitlab@ccadb1a35c4bac23d3b2f7b2384c0411f3dfd506) ([merge request](gitlab-org/gitlab!69191))
- [Update Facebook logo](gitlab-org/gitlab@4eb92a9a8e2ae12a8f8d50847041f4b19fac8989) ([merge request](gitlab-org/gitlab!69189))
- [Remove github_importer_use_diff_note_with_suggestions feature flag](gitlab-org/gitlab@0fce5dd2dfe705760b18277894b0e4fa7c6a5524) ([merge request](gitlab-org/gitlab!79661))
- [Error on delete tag when importing repository](gitlab-org/gitlab@820ff2a8f109913f4696dcd9db503fe2eec75210) ([merge request](gitlab-org/gitlab!79660))
- [Treat API requests from the frontend as web traffic in the rate limiter](gitlab-org/gitlab@e77b3686ccd7af6951f0ef690bf2f0f053dee483) ([merge request](gitlab-org/gitlab!79341))
- [Enable jobs tab vue by default](gitlab-org/gitlab@50d0f4e2328b1bcf09826b082cbf4d9d4a2d0159) ([merge request](gitlab-org/gitlab!79659))
- [Update Auth0 logo](gitlab-org/gitlab@09cf9529f1736fa505b12d9f9481d69a2d1bf7b0) ([merge request](gitlab-org/gitlab!69193))
- [Hide user cap alert if viewing pending members](gitlab-org/gitlab@8a70a652efd9b62aec080969a4e796a67396d3a4) ([merge request](gitlab-org/gitlab!79618)) **GitLab Enterprise Edition**
- [Geo Sites - Filter By Status](gitlab-org/gitlab@bd82e5917ad65cf29c7938146a5c227f52da71b2) ([merge request](gitlab-org/gitlab!79070)) **GitLab Enterprise Edition**
- [Add indeterminate state to select all checkbox on vulnerability report](gitlab-org/gitlab@dde9f6e450fd91407accd3fb84f125a175250342) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/79398)) **GitLab Enterprise Edition**
- [Update to ruby-magic v0.5.4](gitlab-org/gitlab@91318d98f3d20b06626edf03011075d11472778b) ([merge request](gitlab-org/gitlab!79388))
- [Add combined registration to trial registration flow](gitlab-org/gitlab@5078efb2425a5086aea1ca8035103f016d03ce33) ([merge request](gitlab-org/gitlab!79437))
- [Update rubyzip gem to v2.3.2](gitlab-org/gitlab@98d32a3bfd1fd330540d96903c65cf42dd65cac4) ([merge request](gitlab-org/gitlab!79602))
- [Don't notify Sentry about PreReceiveErrors](gitlab-org/gitlab@245c482098ee367dd140658eeca62c2ab51f9349) ([merge request](gitlab-org/gitlab!79558))
- [Show disabled CI action icon when unauthorized](gitlab-org/gitlab@cf74bdab7a8238a447a922fa555a220e3bb6540f) ([merge request](gitlab-org/gitlab!76959))
- [Enable the pipelines table redesign by default](gitlab-org/gitlab@aef9bb4040e9136371c96313b6daaf9cfe071bc8) ([merge request](gitlab-org/gitlab!79452))
- [Change settings copy](gitlab-org/gitlab@7d1f521e3d9a120a791100c14da53ea547b4a57f) ([merge request](gitlab-org/gitlab!79541))
- [Edit UI text of project permissions](gitlab-org/gitlab@2959d2de5918a2e3325ce60bbc7a22672b8dce45) ([merge request](gitlab-org/gitlab!78748))
- [Add instrumentation class to by-stage-secure metrics](gitlab-org/gitlab@6ee8e88fb764e37a62cc84a8d4023fbcbe17d0d5) ([merge request](gitlab-org/gitlab!76836)) **GitLab Enterprise Edition**
- [Return pretty error validation messages for Security Policy](gitlab-org/gitlab@7e0e5a4334bca72ea588f73ead6b19ef92253426) ([merge request](gitlab-org/gitlab!78916)) **GitLab Enterprise Edition**
- [Hide search bar when registry is empty](gitlab-org/gitlab@8203c487fcff1c57c5180681000790100e4e7b8a) by @KevSlashNull ([merge request](gitlab-org/gitlab!75915))
- [Bump Gitlab Shell version](gitlab-org/gitlab@16910907ad8e89e6a9c6daab865b67c79d8c3b5c) ([merge request](gitlab-org/gitlab!79502))
- [Update styling of date range indicator](gitlab-org/gitlab@bce045861adddea70978d5b7c972a0bc9e36069c) ([merge request](gitlab-org/gitlab!78108))
- [Show error message for permissions](gitlab-org/gitlab@61496e8764f514c3ec2d2c96c61b262010608b0c) ([merge request](gitlab-org/gitlab!79242))
- [Show error message for permissions](gitlab-org/gitlab@b2dfdcb927e888fe6bd27be9eb2a9fe511c9df56)
- [Change contact details for support](gitlab-org/gitlab@4e705e29f2ac0002fa9ecadea1c58d6cc87c990f) ([merge request](gitlab-org/gitlab!78609))
- [Skip redundant checks for runners already scoped to a project](gitlab-org/gitlab@6cef95a994830643a077a2a9a0501f95024f2b18) ([merge request](gitlab-org/gitlab!79346))
- [Swap FK ci_pipelines to projects for LFK](gitlab-org/gitlab@1716da959240ac1a8a90114cda721753518b30b9) ([merge request](gitlab-org/gitlab!79277))
- [Reorganize Kubernetes clusters action button menu](gitlab-org/gitlab@04a4c42df07df7d2560d6c95a8ccac2b4edb18f7) ([merge request](gitlab-org/gitlab!79305))
- [feat(badge): Migrate diff LFS badge to glbadge](gitlab-org/gitlab@fc575676697e2a4561820feb5bde95ee8fc00d66) ([merge request](gitlab-org/gitlab!78413))
- [Enable linear roots in UpdateAllMirrorsWorker](gitlab-org/gitlab@de22b4edad8e3b4391515a3beb7303042202b316) ([merge request](gitlab-org/gitlab!77854)) **GitLab Enterprise Edition**
- [Default enable issue_boards_filtered_search](gitlab-org/gitlab@827f9434e2fdfcdbe984dd236eb33bcf51225ae0) by @sstern ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/78230))
- [Add confirmation modal for merge](gitlab-org/gitlab@3a20c6410e4fb240caff10fb3728a6e17efd7bed) ([merge request](gitlab-org/gitlab!78722))
- [Update navigation badge to pajamas styling](gitlab-org/gitlab@fffb3db66186ecd7b56d65f10b571e41777c0021) ([merge request](gitlab-org/gitlab!79390))
- [Allow developers to read Kubernetes clusters](gitlab-org/gitlab@722985df1406cc7c49d93fb72147e440a569202e) ([merge request](gitlab-org/gitlab!77407))
- [Enable `security_report_ingestion_framework` FF by default](gitlab-org/gitlab@17184621c0e963f7930f3d4c7ba2357144686763) ([merge request](gitlab-org/gitlab!79364)) **GitLab Enterprise Edition**
- [Add text for all branches](gitlab-org/gitlab@63718b047e713f0ee6db45a1db571c1140d5655b) ([merge request](gitlab-org/gitlab!79370)) **GitLab Enterprise Edition**
- [Swap FK ci_pipeline_schedules to projects for LFK](gitlab-org/gitlab@eb5eb7b069b4af9a7b8d215e5a296e825be42b5f) ([merge request](gitlab-org/gitlab!79270))
- [Content for hand raise leads](gitlab-org/gitlab@1befa032c2127c593963e846011434022e3355e9) ([merge request](gitlab-org/gitlab!79256)) **GitLab Enterprise Edition**
- [Improve UI text for style compliance](gitlab-org/gitlab@8641e274098a0c9144f16750872836653060653b) ([merge request](gitlab-org/gitlab!78756))
- [Swap FK ci_builds to projects for LFK](gitlab-org/gitlab@511221eb8bcce9ec998d1dda4823414e6da1ef79) ([merge request](gitlab-org/gitlab!79275))
- [Packages list sort by Published and store pref](gitlab-org/gitlab@67ae4d8a2672ebeb85cd3280642be600616f3490) ([merge request](gitlab-org/gitlab!78386))
- [Remove projects that are marked for deletion from UI](gitlab-org/gitlab@69b2ac8026ea90e399c9e349597be145e35c32d2) ([merge request](gitlab-org/gitlab!75742))
- [Swap FK ci_sources_projects to projects for LFK](gitlab-org/gitlab@b01cf0614c285bd8a1cec48d14c44fc6fa48cb7a) ([merge request](gitlab-org/gitlab!79269))
- [Swap FK ci_job_token_project_scope_links to projects for LFK](gitlab-org/gitlab@ed97fc5739f8bd8e699574afd4c4ec55dca9b14b) ([merge request](gitlab-org/gitlab!79268))
- [Add alert after Slack application is installed](gitlab-org/gitlab@278e401bba0f090224e7169b2ffae5699aff5736) ([merge request](gitlab-org/gitlab!79233)) **GitLab Enterprise Edition**
- [Swap FK ci_runner_projects to projects for LFK](gitlab-org/gitlab@92ce5750de0a0a883a8fb65eb49ea4f732f92928) ([merge request](gitlab-org/gitlab!79022))
- [Swap FK ci_job_artifacts to projects for LFK](gitlab-org/gitlab@3eb69eebab55459b0823ff12d4b3974fc7bcebc2) ([merge request](gitlab-org/gitlab!79026))
- [Update UI for MR pipeline rename](gitlab-org/gitlab@dbcc0895c709c7070439cc7f6ada273fddcf11db) ([merge request](gitlab-org/gitlab!79224))
- [Swap FK vulnerability_feedback to ci_pipelines for LFK](gitlab-org/gitlab@0c7e5b94c9a71cfa1510174b0bc31abb1b070320) ([merge request](gitlab-org/gitlab!79105))
- [Only fetch namespaces if search value changes](gitlab-org/gitlab@3f22e42417ba66903324340515c088f1599122c3) ([merge request](gitlab-org/gitlab!78994))
- [Add error code to project export command status log](gitlab-org/gitlab@78895a359ca0b6506e9cf23866c1f020ebe5fa97) ([merge request](gitlab-org/gitlab!79193))
- [Swap FK dast_site_profiles_pipelines to ci_pipelines for LFK](gitlab-org/gitlab@7efa6cb1976b362fded4c6e54ad19709cd31094e) ([merge request](gitlab-org/gitlab!79103))
- [Add compatibility alert to Jira Connect App](gitlab-org/gitlab@7e79f5930558f1c37dd886faa5002f1452d04ca8) ([merge request](gitlab-org/gitlab!78866))
- [Swap FK ci_subscriptions_projects to projects for LFK](gitlab-org/gitlab@ca7812d26c9d2c4f14ae0f9424aadee331fbccab) ([merge request](gitlab-org/gitlab!79042))
- [Replace window.confirm with GlModal for noteable discussions](gitlab-org/gitlab@20e05799c765193e8720cf4c0ef56019ef0c910d) ([merge request](gitlab-org/gitlab!78661))
- [Replace window.confirm with GlModal for board setting sidebar](gitlab-org/gitlab@0eae96df678e2d337ae70d5544dc9ebc64d205b8) ([merge request](gitlab-org/gitlab!78097))
- [Swap FK ci_project_monthly_usages to projects for LFK](gitlab-org/gitlab@1f1ec8694fd9a1b5d5bcbe58b2567da459671ddc) ([merge request](gitlab-org/gitlab!79073))
- [Add IDE preview success metrics](gitlab-org/gitlab@e11d4a7c64126185b68f37ed5532db681f7c5e08) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/78952))
- [Swap FK ci_stages to projects for LFK](gitlab-org/gitlab@dbc0fb73824c5cbd650c194e2aefca322ad2b9d4) ([merge request](gitlab-org/gitlab!78945))
- [Improve UI text for style compliance](gitlab-org/gitlab@13529a0c6f5085866e7c206316ed8c3728ed90b4) ([merge request](gitlab-org/gitlab!78853)) **GitLab Enterprise Edition**
- [Replace window.confirm with GlModal for repository index](gitlab-org/gitlab@5c2bdf2ae136d3f974063fb911a7526671690875) ([merge request](gitlab-org/gitlab!78907))
- [Hide subs expiration banner before eligible](gitlab-org/gitlab@c50aac982ed3b6c9ac2cb55c609cffbf4dabbc82) ([merge request](gitlab-org/gitlab!77625)) **GitLab Enterprise Edition**
- [Remove export_reduce_relation_batch_size feature flag](gitlab-org/gitlab@7db41adaeb2a1ae3df6bb9e2609f044647f1c670) ([merge request](gitlab-org/gitlab!79132))
- [Update runner registration token reset modal](gitlab-org/gitlab@73f80a03948592b666e2d51758b385f95dde440d) ([merge request](gitlab-org/gitlab!79136))
- [Swap FK ci_pipelines to merge_requests for LFK](gitlab-org/gitlab@e991d61c19f1197ed7f9441ba23ef9ed5536c355) ([merge request](gitlab-org/gitlab!78574))
- [Swap FK ci_job_token_project_scope_links to projects for LFK](gitlab-org/gitlab@cd3dc6e47ad461e4bdf2392a69b118decfdc6e83) ([merge request](gitlab-org/gitlab!79069))
- [Add Cluster Image Scanning to AutoDevOps](gitlab-org/gitlab@f0adeb683d0e006c036e4580d0a299dbe9809afd) ([merge request](gitlab-org/gitlab!78271))
- [Update iteration dropdowns in sidebars/board list](gitlab-org/gitlab@4c458201ba4af050012d5205dc7ab1954f5a13b3) ([merge request](gitlab-org/gitlab!78361)) **GitLab Enterprise Edition**
- [Add unit test for trials_link_url](gitlab-org/gitlab@db33b61af6e65caae6dccd0f372cec8d318bb226) by @orozot ([merge request](gitlab-org/gitlab!78872)) **GitLab Enterprise Edition**
- [Refactor hello_deferred path to jh_else_ce](gitlab-org/gitlab@5de1b0a23d4b929081e6a2169e1f38b780db83ec) by @orozot ([merge request](gitlab-org/gitlab!78872))
- [Extract callout content trails link to variable](gitlab-org/gitlab@d7b774da7a0d5c000dacb7fe79527eb4629a46c0) by @orozot ([merge request](gitlab-org/gitlab!78872)) **GitLab Enterprise Edition**
- [Boards - Fix top elements alignment](gitlab-org/gitlab@08b2142a003dd74612cfd68acc93def126212ed0) ([merge request](gitlab-org/gitlab!78428))
- [Swap FK ci_refs to projects for LFK](gitlab-org/gitlab@3383b327e2a84c64536c02fc2d478b7f29072769) ([merge request](gitlab-org/gitlab!79065))
- [Swap FK ci_sources_pipelines to projects for LFK](gitlab-org/gitlab@11b4ece681f3eacb08fede0fd81726eb06db0e5e) ([merge request](gitlab-org/gitlab!79062))
- [Hide user avatar for blocked and unconfirmed users](gitlab-org/gitlab@565dc6f44762fc631c013875756acba2cba13c69) ([merge request](gitlab-org/gitlab!77250))
- [Swap FK ci_builds_metadata to projects for LFK](gitlab-org/gitlab@6544a4abaf832daf26490a21bbb9e836ea9127c6) ([merge request](gitlab-org/gitlab!79039))
- [Improve OmniAuth sign in description](gitlab-org/gitlab@43acbf24b781885ca49644581fcf3fbbd36eb3c1) by @scootergrisen ([merge request](gitlab-org/gitlab!72438))
- [Swap FK ci_variables to projects for LFK](gitlab-org/gitlab@f5feec0e744911138b233a548fa43da455dcbd69) ([merge request](gitlab-org/gitlab!78946))
- [Swap FK ci_subscriptions_projects to projects for LFK](gitlab-org/gitlab@8107fe95875c1a4d59aa8e7e874268363b1fe551) ([merge request](gitlab-org/gitlab!79024))
- [Swap FK ci_triggers to projects for LFK](gitlab-org/gitlab@6f1546ce9e1706ff6e59b56645191ac8dab8fb2c) ([merge request](gitlab-org/gitlab!79021))
- [Swap FK external_pull_requests to projects for LFK](gitlab-org/gitlab@2dfceed9d70cf3cf7060142016523f6f4cd706e1) ([merge request](gitlab-org/gitlab!79019))
- [Add Pajamas badge for diverged from upstream](gitlab-org/gitlab@78e8a2896a718cf4c92116039ce81b9940af2d54) ([merge request](gitlab-org/gitlab!78984))
- [Refactor system notes for alerts and incidents for consistentcy](gitlab-org/gitlab@3b3f92bacc3541f49b19d4d7c9a3e7f572b7cf85) ([merge request](gitlab-org/gitlab!78243))
- [Improve explanation for Advanced Project settings](gitlab-org/gitlab@bf9c0b1e92adde26fbb1edec26008b8c5ca3953a) ([merge request](gitlab-org/gitlab!78290))
- [Handle path not found without throwing, accept array as path](gitlab-org/gitlab@7aa8ff9bd8896de63872967a874279067bb6faf7) ([merge request](gitlab-org/gitlab!78261))
- [Add scan result policy into policy editor](gitlab-org/gitlab@5bc6ae0dddeb19c1746901b2b210266fdaa82b64) ([merge request](gitlab-org/gitlab!77814)) **GitLab Enterprise Edition**
- [Use gl-badge for web IDE activity bar](gitlab-org/gitlab@036d6cea1614a45ee7be4a66fb6333d17b300102) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/78965))
- [Geo Sites - NA Verification Help](gitlab-org/gitlab@be2075f14b69898902766262778b614ee48f15f2) ([merge request](gitlab-org/gitlab!78947)) **GitLab Enterprise Edition**
- [Disable sync for offline cloud licenses](gitlab-org/gitlab@6184e4018e2000e1ecb8a49a797d3e437cdd7a61) ([merge request](gitlab-org/gitlab!78728)) **GitLab Enterprise Edition**
- [Geo Sites - Update replication button](gitlab-org/gitlab@9a898f4ecd729f0c7042199a45565eb8450ca6b0) ([merge request](gitlab-org/gitlab!78927)) **GitLab Enterprise Edition**
- [Geo Forms - Fix Buttons](gitlab-org/gitlab@6471ad685f24be68170b075f73dfdca71885a8ca) ([merge request](gitlab-org/gitlab!78924)) **GitLab Enterprise Edition**
- [VSA metrics: Only render decimal places for floats](gitlab-org/gitlab@de98f4d5ac34c03540dffddfe1d3b7894d8a766d) ([merge request](gitlab-org/gitlab!78675))
- [Swap FK vulnerability_statistics to ci_pipelines for LFK](gitlab-org/gitlab@da3e27e091d722794bde807893c674ffaa9ae6f8) ([merge request](gitlab-org/gitlab!78599))
- [Remove instructions to install Agent if KAS is not set up](gitlab-org/gitlab@51d7f1e05425031463688adc97a35d586ab92953) ([merge request](gitlab-org/gitlab!78168))
- [Update iteration changed notification format](gitlab-org/gitlab@79f89989f62e9af2a8a078e3f4cace722574575e) ([merge request](gitlab-org/gitlab!78250)) **GitLab Enterprise Edition**
- [Lowercased runner because it's referring to agent](gitlab-org/gitlab@909978158ef46a88bb0d69fd38f1fe1b6991204d) ([merge request](gitlab-org/gitlab!78725))
- [Keep branch when going to Pipeline Editor through nav](gitlab-org/gitlab@48c95031377b2cbd1a057f186b939fa59906d5a0) ([merge request](gitlab-org/gitlab!78594))
- [Swap FK vulnerability_occurrence_pipelines to ci_pipelines for LFK](gitlab-org/gitlab@51f3ff916edbd3fd5aac78732f75d6e2d8f00ee7) ([merge request](gitlab-org/gitlab!78601))
- [Swap FK dast_profiles_pipelines to ci_pipelines for LFK](gitlab-org/gitlab@18f11e7f31d6a4bf07300065e8980a86e98b238f) ([merge request](gitlab-org/gitlab!78597))
- [Limit the length of generated anchor URL for markdown headers](gitlab-org/gitlab@32b2723912e4b35bfb0701dfe374c8197f64facf) ([merge request](gitlab-org/gitlab!78672))
- [Treat API requests from the frontend as web traffic in the rate limiter](gitlab-org/gitlab@a5440d5bf6f617cb2342e76811b37a7c2d7986ea) ([merge request](gitlab-org/gitlab!78082))
- [Handle members who are existing hierarchy members](gitlab-org/gitlab@d74a9d9991ce856a948424e3d7216750206e3418) ([merge request](gitlab-org/gitlab!76850)) **GitLab Enterprise Edition**
- [Fix empty line to contain two values](gitlab-org/gitlab@872dfcc8d94d9d6edee8cad61bc8531ac200b627) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/78678)) **GitLab Enterprise Edition**
- [Swap FK merge_trains to ci_pipelines for LFK](gitlab-org/gitlab@e7bfb7dd322c66361ff8cb67057d01866ecb5a03) ([merge request](gitlab-org/gitlab!78568))
- [Add Pajamas complient "whats new" badge](gitlab-org/gitlab@2a9007343d4047f241924838057cc8e5f881345e) ([merge request](gitlab-org/gitlab!78524))
- [Swap FK ci_triggers to users for LFK](gitlab-org/gitlab@3540dcc5a4f80df4ba5f43a9b726af21212a5f8c) ([merge request](gitlab-org/gitlab!78563))
- [Extract container registry page common component](gitlab-org/gitlab@6b62906cc0d0077612df461e79efd2bb69817dfa) by @orozot ([merge request](gitlab-org/gitlab!77833))
- [Update secret detection template to be more robust](gitlab-org/gitlab@9a1dbbadf89e1eb6c729206542e11161abf71129) ([merge request](gitlab-org/gitlab!78321))
- [Remove feature flag for auto-linking LFS objects in forks](gitlab-org/gitlab@dd5724c49c3f6ce2e0f910f636f84a8ccb2549c1) ([merge request](gitlab-org/gitlab!78592))
- [Enable ci_skip_require_credit_card_for_addon_ci_minutes by default](gitlab-org/gitlab@3410f7977bd42cac416b1ed3db785bf0d19ff377) ([merge request](gitlab-org/gitlab!78591))
- [Loosen rule to detect cyclical pipelines](gitlab-org/gitlab@9254fa578747056703bd11b308c89ed95adc399f) ([merge request](gitlab-org/gitlab!78171))
- [Swap FK merge_requests to ci_pipelines for LFK](gitlab-org/gitlab@27ce821111e9d851f5ae080e4a6d3921634936cc) ([merge request](gitlab-org/gitlab!78566))
- [Swap FK ci_sources_pipelines to projects for LFK](gitlab-org/gitlab@9f2dc374ed970df1c39a671cf449dc9690f15f99) ([merge request](gitlab-org/gitlab!78090))
- [Remove summary from Finding Evidence](gitlab-org/gitlab@44fa8380e8f353b14b19d4dabe956fe9f22f2e14) ([merge request](gitlab-org/gitlab!77710))
- [Geo UI - Rename Nodes to Sites](gitlab-org/gitlab@4254017865c20fb01252bfa653351005e37ce937) ([merge request](gitlab-org/gitlab!78310)) **GitLab Enterprise Edition**
- [Remove FF custom_preloader_for_deployments](gitlab-org/gitlab@b173add5839e1e6c518530556620c97dab991acc) ([merge request](gitlab-org/gitlab!78197))
- [Update group#shared_externally to include projects](gitlab-org/gitlab@14197fbf378b0ba4571c7de5594ed5ef44a31238) ([merge request](gitlab-org/gitlab!78270)) **GitLab Enterprise Edition**
- [Improve the labels on Kubernetes Agent UI](gitlab-org/gitlab@85a377fd4618728a91b2183b25ff1ad0ffc8e4e9) ([merge request](gitlab-org/gitlab!77845))

### Deprecated (12 changes)

- [Add warning for deprecation notice on logs page](gitlab-org/gitlab@524b57fe9758fe787bb06f0d011f14323cd27d7b) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/79506))
- [feat: Update SECURE_ANALYZER_PREFIX in all Sec Section templates](gitlab-org/gitlab@c20808b214f2a2304027a834561852a0e0026fd1) ([merge request](gitlab-org/gitlab!79063))
- [Require `auto-deploy use_kube_context` to be present](gitlab-org/gitlab@48663c8f268d94ff2de99c28e36741603ede856f) ([merge request](gitlab-org/gitlab!79240))
- [Change merged_by deprecation to breaking change](gitlab-org/gitlab@7f9f577976f1186f83e8dc1d0e22121a17fbe7b1) ([merge request](gitlab-org/gitlab!79669))
- [Deprecate /groups/:id/runners?type=project_type](gitlab-org/gitlab@2f9faca20aa8ee6cd9ae790c5ef60eb369fbe40a) ([merge request](gitlab-org/gitlab!79450))
- [REST API: Deprecate active/paused values in status filters](gitlab-org/gitlab@d493fea4927329758424e662c30b5ef2de0d0642) ([merge request](gitlab-org/gitlab!79349))
- [GraphQL: Deprecate active field in RunnerUpdateInput](gitlab-org/gitlab@67410860c452c65583e9a1e79996bef1d7cd9cb0) ([merge request](gitlab-org/gitlab!79131))
- [REST API: Deprecate ‘active’ property for Runners](gitlab-org/gitlab@3ca9f3e7fb54b2568e62ef733c862fff10c062a8) ([merge request](gitlab-org/gitlab!79244))
- [GraphQL: Deprecate active field for RunnerType](gitlab-org/gitlab@f42fa2c42be43c6be34fd62566eb689799c84b8c) ([merge request](gitlab-org/gitlab!79017))
- [GraphQL: Deprecate active filter for Runners resolver](gitlab-org/gitlab@e1aee64fbfbee97a50fca50b55d74b2031d3c27f) ([merge request](gitlab-org/gitlab!79018))
- [Deprecate Runner API maintainer_note](gitlab-org/gitlab@1f56df9b059ac368877889326b4f7a5c6b649d9e) ([merge request](gitlab-org/gitlab!78677))
- [Deprecate Gitlab Shell's self_signed_cert setting](gitlab-org/gitlab@4374e0351830fba7db2099e68413b259eefab4e2) ([merge request](gitlab-org/gitlab!78078))

### Removed (21 changes)

- [Remove deprecated CanMutateSpammable](gitlab-org/gitlab@d9f911149c0c15cca91d9f0643a8f0c9119783f7) ([merge request](gitlab-org/gitlab!80778))
- [Remove unused partial remove_approver](gitlab-org/gitlab@6381f48c7bcaaae40921e8bc62cdc15b79b5780d) ([merge request](gitlab-org/gitlab!80582))
- [git: Stop calling Gitaly's Cleanup RPC](gitlab-org/gitlab@9a63b10c932d67014ceaf68ef72d5505ae0b2465) ([merge request](gitlab-org/gitlab!80485))
- [Remove the billing in side nav experiment](gitlab-org/gitlab@99d194de05bc266cb3a71ab489c17f9377c4e7c7) ([merge request](gitlab-org/gitlab!80306)) **GitLab Enterprise Edition**
- [Remove unique index](gitlab-org/gitlab@493715d878adce00eba5cb0b5efa6bd8fe35a085) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/79683))
- [rake/info: Stop reporting Git version](gitlab-org/gitlab@5f31c7de4d499bc97c331ca853651023773934b0) ([merge request](gitlab-org/gitlab!80048))
- [system_check: Remove Git version check](gitlab-org/gitlab@9d036a37c66f890a614556504af4dd0931c0a75d) ([merge request](gitlab-org/gitlab!80048))
- [system_check: Remove Git configuration check](gitlab-org/gitlab@469849c307269c137f1845e8260f683b10dfff87) ([merge request](gitlab-org/gitlab!80048))
- [Remove unused WIP regex](gitlab-org/gitlab@0ad8a5451832fba1c6b17e516f449a0b76f82f20) ([merge request](gitlab-org/gitlab!79856))
- [Remove the loose_foreign_key_cleanup FF](gitlab-org/gitlab@cc1805c4fc3480f10742373578aa342fd75f75e2) ([merge request](gitlab-org/gitlab!79831))
- [Remove feature flag](gitlab-org/gitlab@ccfa41280a2359ea1a850755fb8bd2c0fc8664dd) ([merge request](gitlab-org/gitlab!79707))
- [Remove security_finding_build_disable_joins feature flag](gitlab-org/gitlab@81ce34f28e73ad7f7f1fe5571d2e5b521ddafc29) ([merge request](gitlab-org/gitlab!79704))
- [Remove vulnerability_history feature flag](gitlab-org/gitlab@e95671953d747eed9bda479bd3c1b49d6a3149ae) ([merge request](gitlab-org/gitlab!79186))
- [Remove instance_security_dashboard feature flag](gitlab-org/gitlab@eb53bce4233949fc80ae2cd6587e325741f39734) ([merge request](gitlab-org/gitlab!79187))
- [Remove all code related to Gitlab::RequestProfile](gitlab-org/gitlab@ff5d698d6507c313e76490ef924bb09415b70e24) ([merge request](gitlab-org/gitlab!78911))
- [Remove duplicate data_category: entry](gitlab-org/gitlab@fa07e581af7dd9232f6926901d2043e62900edab) ([merge request](gitlab-org/gitlab!78621))
- [Remove paid feature callout badge](gitlab-org/gitlab@78d50cd46706b3d2996c849e1186b573c4267f97) ([merge request](gitlab-org/gitlab!78954))
- [Disable sandboxed_mermaid feature flag](gitlab-org/gitlab@524979a74aa733eda4301c8e24162f532b88219b) ([merge request](gitlab-org/gitlab!79045))
- [Remove incident labeled metric](gitlab-org/gitlab@66ba7cd73f074542db48be3fe9ff268b0c878380) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/78447))
- [Drop `position` column from `security_findings` table](gitlab-org/gitlab@4ce8c43a1f8a11b4fb38015ff8728d410f0c09bc) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/78665))
- [Remove username suggestion for trial registration](gitlab-org/gitlab@f86647431d200028628691e393f5da01d39d4f74) ([merge request](gitlab-org/gitlab!78686)) **GitLab Enterprise Edition**

### Security (8 changes)

- [Upgrade to Rails v6.1.4.6](gitlab-org/gitlab@f9879f031441b0b280dad9c3538e307b933cb9ab) ([merge request](gitlab-org/gitlab!80579))
- [Fixes typo on pipeline model](gitlab-org/gitlab@9d2fbf7b3877e0fe33483dcb07569d155f672123)
- [Add Gitlab::BufferedIo with header read timeout](gitlab-org/gitlab@a8807ee52d0b22b68beb31f0cad6ad5b77b4caf6) ([merge request](gitlab-org/gitlab!78065))
- [Ignore spoofable Reply-To address in Service Desk](gitlab-org/gitlab@1be6d168a885f147b9fd71fa93165522bcdd0391) ([merge request](gitlab-org/gitlab!79677))
- [Enable Secure attribute for frontend cookies](gitlab-org/gitlab@9104396d0cdaa832fa3846061072ea238ab26068) ([merge request](gitlab-org/gitlab!79383))
- [Block recursive webhooks](gitlab-org/gitlab@0536b9e7be125f8af0f0fd290e1b128b8a8a4471) ([merge request](gitlab-org/gitlab!79085))
- [Sanitize link markup for vulnerability chat messages](gitlab-org/gitlab@60913a4b1b461e72ddeecde0254449444bb41e8c) ([merge request](gitlab-org/gitlab!78669)) **GitLab Enterprise Edition**
- [Adding a conditional to prevent an unauthorized route](gitlab-org/gitlab@1fa306fb7e85621242a2e0ac40fbe13326b7f84d) ([merge request](gitlab-org/gitlab!78490))

### Performance (17 changes)

- [Refactor building project secret variables](gitlab-org/gitlab@c59017aee6854f00add37a0fc635b4ce4cb45b1f) ([merge request](gitlab-org/gitlab!79850))
- [Enable branches API rate limit cache](gitlab-org/gitlab@0cc3485a9d7f207938e8a70b1693eebfad49e89e) ([merge request](gitlab-org/gitlab!80613))
- [Enable caching on tags API](gitlab-org/gitlab@cf0390e9e934a8e041c78b39cab5cde62939e4d0) ([merge request](gitlab-org/gitlab!80606))
- [Enable JSON limited encoder](gitlab-org/gitlab@28287bda0bf0c869d2d3a30e6e7af31314c1e4a0) ([merge request](gitlab-org/gitlab!80627))
- [Enable repository API rate limit cache](gitlab-org/gitlab@58ee1738c771d19d8d298742e02438cae5ac3217) ([merge request](gitlab-org/gitlab!80624))
- [Enable caching on merge requests API](gitlab-org/gitlab@b2cdc30f493db426c6be444eadbffd753c576291) ([merge request](gitlab-org/gitlab!80609))
- [Enable Grape/Gitlab::Json hook](gitlab-org/gitlab@60aaff3bd1145134d89e1c41393d35271d2b8657) ([merge request](gitlab-org/gitlab!80604))
- [Add partial index for active Cluster Image Scanning vulnerabilities](gitlab-org/gitlab@286352f129f0b8bd302533bdb35ae4eaadd77d8e) ([merge request](gitlab-org/gitlab!80300))
- [Reduce Redis calls for instance level variables](gitlab-org/gitlab@2998c15be6e00d35f91c66ca5a86cb1ccb577b15) ([merge request](gitlab-org/gitlab!79435))
- [Optimize User#ci_owned_runners query](gitlab-org/gitlab@79085e714552254dd82621b581e4a6d4a923c3a4) ([merge request](gitlab-org/gitlab!79729))
- [Add compound index for `vulnerabilities` table on `project_id` and `id`](gitlab-org/gitlab@26b89a55b03c7a857d483e46b6a179620dd78e32) ([merge request](gitlab-org/gitlab!79171))
- [Cache CI expire_in parsing](gitlab-org/gitlab@5fc166b9993598f7c9d9da00015be5ab6c681f76) ([merge request](gitlab-org/gitlab!78953))
- [Speed up project exports by moving the archive to the cache dir](gitlab-org/gitlab@23efa56bfb203c92b16f3967b876c063baceb496) ([merge request](gitlab-org/gitlab!78986))
- [Fix cross join query for Ci::Runner#projects](gitlab-org/gitlab@7f29e633b52a4d1ac2e2fcd0c069711066c42f4a) ([merge request](gitlab-org/gitlab!78372))
- [Remove ci_preload_runner_tags feature flag](gitlab-org/gitlab@b5be11f7c3de6febd58f2ee340e422c692d9980a) ([merge request](gitlab-org/gitlab!78663))
- [Optimize decryption of CI variables](gitlab-org/gitlab@d0ff854f0068aa3cc793ac583016764165aa7e07) ([merge request](gitlab-org/gitlab!78440))
- [Improve Sidekiq jobs that use DB load balancing](gitlab-org/gitlab@418e80689aa902413ce25317614b01a95262cdf1) ([merge request](gitlab-org/gitlab!78471))

### Other (66 changes)

- [Revert "Merge branch 'role-targeted-broadcast' into 'master'"](gitlab-org/gitlab@ac8cc851b95dc4786742d15abce502d7dfe0b5cd) ([merge request](gitlab-org/gitlab!80893))
- [Add foreign key to ci_builds runner_id](gitlab-org/gitlab@53884146bf8875e24423981df84c7c2f0b23e9ec) ([merge request](gitlab-org/gitlab!80203))
- [Fix Style/OpenStructUse offenses for import service and spec helpers](gitlab-org/gitlab@d762ddf0c88641a9ab75b6cb52b197e023038ba9) by @edith007 ([merge request](gitlab-org/gitlab!75280))
- [Remove new_route_storage_purchase feature flag](gitlab-org/gitlab@e1d1585414033d0ddd816e242fd0b9965cf81fc7) ([merge request](gitlab-org/gitlab!80568))
- [Fix Style/OpenStructUse offenses in project cluster_controller_spec](gitlab-org/gitlab@2f0a58906046ad44021b7072f89e4320aa22eb6a) by @edith007 ([merge request](gitlab-org/gitlab!75214))
- [Fix Style/OpenStructUse offenses in project clusters_spec](gitlab-org/gitlab@99cf4cdda5730f3416ee83c6000a068acd9251f0) by @edith007 ([merge request](gitlab-org/gitlab!75224))
- [Fix Style/OpenStructUse offenses in group cluster controller specs](gitlab-org/gitlab@c9cb2feda92fb132aeacf6421abc1e6f3083d186) by @edith007 ([merge request](gitlab-org/gitlab!75190))
- [Backfill CI queuing tables](gitlab-org/gitlab@31e260d6928ba531bd6009680cff4c7cba0ff736) ([merge request](gitlab-org/gitlab!80172))
- [Mentioned breaking change label in contribution guide](gitlab-org/gitlab@551f07cfe00fb5ba0719083d2c3b73150cf845c9) ([merge request](gitlab-org/gitlab!80487))
- [Migration for deleting service template records](gitlab-org/gitlab@406a32616554aea83150b1a573b317303e0ffb18) by @lenikadali ([merge request](gitlab-org/gitlab!79737))
- [Make starrers sort dropdown Pajamas-compliant](gitlab-org/gitlab@6629bbcbf087f18418c6183d4f2785de74e7c10f) ([merge request](gitlab-org/gitlab!78708))
- [Remove track_application_boot_time FF](gitlab-org/gitlab@31d451bb5c167f4b38bbf5d80503fc2dd5d80aa6) ([merge request](gitlab-org/gitlab!80366))
- [Add statistics card component with tests](gitlab-org/gitlab@457f0ebc7b539c4021697c336f9d5209553f1ad3) ([merge request](gitlab-org/gitlab!80261)) **GitLab Enterprise Edition**
- [Moving gitlab_loose_foreign_key to config/ directory](gitlab-org/gitlab@b29a03836da9b6349746d3edc73f153387379526) by @edith007 ([merge request](gitlab-org/gitlab!80064))
- [Remove Geo proxying metrics feature flag](gitlab-org/gitlab@ca87691602ea72e01a2ee865741a6537e6f31766) ([merge request](gitlab-org/gitlab!80018)) **GitLab Enterprise Edition**
- [Update comment for ActiveModel::Serializers::JSON in presenter](gitlab-org/gitlab@698c8e3bab8a8b0cddc7104a8ce0dc9bdfcd834b) by @edith007 ([merge request](gitlab-org/gitlab!75858))
- [Truncate before vulnerability link index creation](gitlab-org/gitlab@58b4b540566246dfff5222321859dd88d745c699) ([merge request](gitlab-org/gitlab!79637))
- [Remove the FF ci_find_runners_by_ci_mirrors](gitlab-org/gitlab@31ea7607e1bf94d41dcf58e61618bfd99706b55d) ([merge request](gitlab-org/gitlab!79879))
- [Remove ::Gitlab::Utils::StrongMemoize inclusion as it's duplicate](gitlab-org/gitlab@7e7724a23ff6542886320c455d1424c20cb7542e) by @edith007 ([merge request](gitlab-org/gitlab!75857))
- [Remove Gitlab::Utils::StrongMemoize inclusion as it's duplicate](gitlab-org/gitlab@20c6604b39d70bd2fa04df3c130509eafb1c96d2) by @edith007 ([merge request](gitlab-org/gitlab!75863))
- [Add documentation links to Merge Request settings page](gitlab-org/gitlab@6f34f447df18a2674fdf4646244fe3fb0a0fae0a) ([merge request](gitlab-org/gitlab!79999))
- [Remove FF ci_order_subsequent_jobs_by_stage](gitlab-org/gitlab@f87e7dbdea45294cd2af75b0c8a5aa107ab022dd) ([merge request](gitlab-org/gitlab!79952))
- [Remove the `packages_installable_package_files` feature flag](gitlab-org/gitlab@724b0766c58a3fb025f091b659f012cb923acaae) ([merge request](gitlab-org/gitlab!79745))
- [Update badge in accessibility issue body](gitlab-org/gitlab@ce8ed5b344e5ebfc2ea1496eb1939fc85dc0320f) ([merge request](gitlab-org/gitlab!79777))
- [Unify image pin style for diffs/design management](gitlab-org/gitlab@8e85a2189246247bdfe003759425bc6d97513c93) ([merge request](gitlab-org/gitlab!75627))
- [Cleanup after variables builder](gitlab-org/gitlab@009ba486b47c275016baf16f40a6d8218ac660b9) ([merge request](gitlab-org/gitlab!79330))
- [Update external authorization docs](gitlab-org/gitlab@066c832566cf72396cb271154ee2a8d2ee58db03) ([merge request](gitlab-org/gitlab!79676))
- [Cleanup PopulateTestReportsIssueId background migration jobs](gitlab-org/gitlab@adea69c5247b3f0d97cba76aac2d73168f0456c2) ([merge request](gitlab-org/gitlab!79633))
- [Set type of Web IDE commit button to submit](gitlab-org/gitlab@a3389934d5049815c2ebca543ffeca64ac4206ca) by @tchandelle ([merge request](gitlab-org/gitlab!79259))
- [Remove redundant index on clusters_kubernetes_namespaces](gitlab-org/gitlab@dc77e8e19e33daf8bf71bdae6879492e9ebb7bbc) ([merge request](gitlab-org/gitlab!79597))
- [Fix Rails/SaveBang offenses](gitlab-org/gitlab@4575769dedb71f5da555a086f8c9820e895824ed) by @edith007
- [Fix Rails/SaveBang offenses](gitlab-org/gitlab@06f13583cd7d1310d0c90d8eed25e9d52ffd276c) by @edith007 ([merge request](gitlab-org/gitlab!75974))
- [Pass formats explicitly when rendering .md file](gitlab-org/gitlab@a4dc45e341314fc1e74657292b1d9ef70f61523c) by @edith007 ([merge request](gitlab-org/gitlab!75781)) **GitLab Enterprise Edition**
- [Fix Rails/SaveBang offenses](gitlab-org/gitlab@d06cdd6bbfbecac2ef312065887696dcd591924a) by @edith007 ([merge request](gitlab-org/gitlab!75975))
- [Finalize backfilling ci mirror tables](gitlab-org/gitlab@8f1eb28f6e05dd8c11e5fc949d1bb3e7e2fbe732) ([merge request](gitlab-org/gitlab!79344))
- [Delete tributejs for autocomplete](gitlab-org/gitlab@b2115644ff2437c1275fe9aaf02d60830f62c48a) ([merge request](gitlab-org/gitlab!78564))
- [Remove feature flags for configuring object store files deletion](gitlab-org/gitlab@9aefd98b7ffe8adc3db800bbfff4418a6fa2c72c) ([merge request](gitlab-org/gitlab!79249))
- [Fixes OpenStruct use in design_management specs](gitlab-org/gitlab@459ad59fb867502682559ebb575ed486b9f2b7fc) by @mehulsharma ([merge request](gitlab-org/gitlab!74408))
- [Fix Style/OpenStructUse offenses](gitlab-org/gitlab@91922beacc73fa0542a8b853e0315c1ca3bfe426) by @edith007 ([merge request](gitlab-org/gitlab!75226))
- [Remove FF ci_namespace_project_mirrors](gitlab-org/gitlab@b2cc96dc03cd901e6a9b8dc5f878f270725b8b47) ([merge request](gitlab-org/gitlab!79221))
- [Remove ci_runner_projects_disable_joins feature flag](gitlab-org/gitlab@952653cc8903acecdbf947dfff608b26906b3264) ([merge request](gitlab-org/gitlab!79196))
- [Fix Rails/SaveBang offenses](gitlab-org/gitlab@b173fe212f1ad72767efb5c357281d16c55e6f05) by @edith007 ([merge request](gitlab-org/gitlab!75984))
- [Update seat_usage references](gitlab-org/gitlab@f1ab2925b750ab54e4abd90e6c8c5dc80e63a8bb) ([merge request](gitlab-org/gitlab!78450)) **GitLab Enterprise Edition**
- [Add World.prepend_mod to allow JH override](gitlab-org/gitlab@ba2f4de97244909787d08ce28fe9252ef7af262d) by @chaomao ([merge request](gitlab-org/gitlab!79098)) **GitLab Enterprise Edition**
- [Fix Rails/SaveBang offenses](gitlab-org/gitlab@4462d511c804b9493b6ec1249944077b57a2f96b) by @edith007 ([merge request](gitlab-org/gitlab!75986))
- [Fix OpenStruct use in metadata_extraction_service](gitlab-org/gitlab@a8057eb8a9417d50610466add52969eb4fa50a47) by @mehulsharma ([merge request](gitlab-org/gitlab!74271))
- [Fix Rails/SaveBang offenses](gitlab-org/gitlab@01b295e5e628f469bf88f2381f6295f81b4df87e) by @edith007 ([merge request](gitlab-org/gitlab!75983))
- [Remove feature flag `ff_external_audit_events_namespace`](gitlab-org/gitlab@20720f5329335385ec9a822ca67390f6957ef7ef) by @davebarr ([merge request](gitlab-org/gitlab!79117)) **GitLab Enterprise Edition**
- [Add gl-pr-3 to top_nav_menu_item to account for chevron](gitlab-org/gitlab@daee1c9bf2879defbd152d643d6060da121b2b9e) ([merge request](gitlab-org/gitlab!64359))
- [Fix Rails/SaveBang offenses](gitlab-org/gitlab@0630b159c0790bd3e965cdb2e21b90bc8479fe6a) by @edith007 ([merge request](gitlab-org/gitlab!75955)) **GitLab Enterprise Edition**
- [Remove ci_decompose_for_namespace_monthly_usage_query feature flag](gitlab-org/gitlab@d4e7fb041f98fcdd03a64eddbcbaa7e2d3edbfb1) ([merge request](gitlab-org/gitlab!79004))
- [Fix RSpec/TimecopFreeze offenses (Part 1/2)](gitlab-org/gitlab@269d158b679c29fe367e5caa1ed30038587a86b6) by @KevSlashNull ([merge request](gitlab-org/gitlab!76031))
- [Fix display of times in access and deploy token table](gitlab-org/gitlab@c281d063f841378847d2712033a3e36040a1cdc6) by @edith007 ([merge request](gitlab-org/gitlab!75840))
- [Fix GraphQL/OrderedArguments offense (Part 4/6)](gitlab-org/gitlab@618510e2d5ef368724d44c9ec624fa33f4825f74) by @KevSlashNull ([merge request](gitlab-org/gitlab!76026))
- [Fix GraphQL/FieldDefinitions offense (Part 1/4)](gitlab-org/gitlab@62a0a2037cc4b584ab8adcb6d9abc2130a18aac8) by @KevSlashNull ([merge request](gitlab-org/gitlab!76014))
- [Update missing branch widget text to include branch name](gitlab-org/gitlab@c580a27dda198a772fa27c7f7f20469248f2560e) ([merge request](gitlab-org/gitlab!78439))
- [Revert frontend API rate limits change](gitlab-org/gitlab@47d7d954d15871cfe1725f62811916b35c22e423) ([merge request](gitlab-org/gitlab!78893))
- [Separate deployments creation from pipeline job creation](gitlab-org/gitlab@deedfe19613c517d1c49010bca678fea024c577c) ([merge request](gitlab-org/gitlab!77734))
- [Move the merge train helper icon to near the merge button](gitlab-org/gitlab@e8ec1722dace7eba12021e102cbb4b54c8566eae) ([merge request](gitlab-org/gitlab!78525))
- [Reschedule migration for self-managed](gitlab-org/gitlab@87b58670191d51e3ebc671a7886fa71b0b88f2f4) ([merge request](gitlab-org/gitlab!78509)) **GitLab Enterprise Edition**
- [Remove unnecessary index on cluster_agent_tokens](gitlab-org/gitlab@6fce8363544a245f0ec623040d3413c5b59f0c32) ([merge request](gitlab-org/gitlab!78348))
- [Remove `net-ssh`, `ed25519`, and `bcrypt_pbkdf` gems from dependencies](gitlab-org/gitlab@91a7c32b6a2e00dc27ee885e3beb666ea6b390a7) ([merge request](gitlab-org/gitlab!78532))
- [Update GitLab Runner Helm Chart to 0.37.1](gitlab-org/gitlab@185f6478720d1b4351226b20f4001d376e3d5014) ([merge request](gitlab-org/gitlab!78584))
- [Update GitLab Runner Helm Chart to 0.37.0](gitlab-org/gitlab@d6a1ee24018d2d96982a2bc7de5663391ba61dc6) ([merge request](gitlab-org/gitlab!78584))
- [Use `ssh_data` gem instead of `net-ssh` and `sshkey` where possible](gitlab-org/gitlab@59a0ee8605d509753c9aec719f8e0da77bcc679d) ([merge request](gitlab-org/gitlab!77424))
- [Remove feature flag already default enabled](gitlab-org/gitlab@9b7059a4bf9dc2ecdce1910a931cc6967d05b5ad) ([merge request](gitlab-org/gitlab!78238)) **GitLab Enterprise Edition**

## 14.7.7 (2022-03-31)

### Security (21 changes)

- [Update to commonmarker 0.23.4](gitlab-org/security/gitlab@eb4b231173c86901f93b5b7781716b1f7706dad1) ([merge request](gitlab-org/security/gitlab!2283))
- [Revert merge request approval groups behavior](gitlab-org/security/gitlab@08e3ecced649f6ad241db6de7050b1502f7bef21) ([merge request](gitlab-org/security/gitlab!2333))
- [Disallow login if password matches a fixed list](gitlab-org/security/gitlab@02a69ab32da1ac67d855de3ee388d0bd2bb6586e) ([merge request](gitlab-org/security/gitlab!2359))
- [Update devise-two-factor to 4.0.2](gitlab-org/security/gitlab@c9fde96c7780f5b883cd1ac63d7ac3d5f4d78dc6) ([merge request](gitlab-org/security/gitlab!2351))
- [Limit the number of tags associated with a CI runner](gitlab-org/security/gitlab@00124d5f8ba0d7437d1f6f19b029754bf481185b) ([merge request](gitlab-org/security/gitlab!2305))
- [GitLab Pages Security Updates for 14.9](gitlab-org/security/gitlab@d335917e233658fa9d4452053469c3582ef38368) ([merge request](gitlab-org/security/gitlab!2325))
- [Upgrade swagger-ui dependency](gitlab-org/security/gitlab@7a8ce32f70fd0338817705651ee0dbe0a277d5f1) ([merge request](gitlab-org/security/gitlab!2338))
- [Modify release link format check to avoid regex if string is too long](gitlab-org/security/gitlab@e18dc2be245bca7e192c8536d1ba7de2ad798c43) ([merge request](gitlab-org/security/gitlab!2244))
- [Masks variables in error messages](gitlab-org/security/gitlab@1706c5cf9b939a6ab0682db7b8945feb851a3f8b) ([merge request](gitlab-org/security/gitlab!2292))
- [Escape user provided string to prevent XSS](gitlab-org/security/gitlab@c57edf9ab52810d455e41d71bad4e4d12c098cad) ([merge request](gitlab-org/security/gitlab!2315))
- [Monkey patch of RDoc to prevent Ruby segfault](gitlab-org/security/gitlab@f9e5597d1864d03bf1f0103787becbc84886968d) ([merge request](gitlab-org/security/gitlab!2233))
- [Project import maps members' created_by_id users based on source user ID](gitlab-org/security/gitlab@3ea1e477e0596f15e040f42b59fa86953d057128) ([merge request](gitlab-org/security/gitlab!2239))
- [Redact InvalidURIError error messages](gitlab-org/security/gitlab@a42ede835e32f44b68c1affe78a7ee48332bb30a) ([merge request](gitlab-org/security/gitlab!2297))
- [Fix access for approval rules API](gitlab-org/security/gitlab@b8c3997763d1e041dc2b82e464a99a5b2f15a798) ([merge request](gitlab-org/security/gitlab!2324))
- [Fix kroki exploit](gitlab-org/security/gitlab@ad123e33510103af4fb00378ef1fc8dae4cacb21) ([merge request](gitlab-org/security/gitlab!2278))
- [Fix blind SSRF when looking up SSH host keys for mirroring](gitlab-org/security/gitlab@0209f44cb4876f0a9ef13d4c8875a95a0cda1e2f) ([merge request](gitlab-org/security/gitlab!2311))
- [Escape original content in reference redactor](gitlab-org/security/gitlab@f63861d8fe7b2b8d161162063e7995782cbfada8) ([merge request](gitlab-org/security/gitlab!2319))
- [Security fix for CI/CD analytics visibility](gitlab-org/security/gitlab@fea6a4ff80862f9dba493405d03d82cf129e8854) ([merge request](gitlab-org/security/gitlab!2274))
- [Latest commit exposed through fork of a private project](gitlab-org/security/gitlab@b573cea38cdce020e5f25fb9de60e0e506c87a9b) ([merge request](gitlab-org/security/gitlab!2272))
- [Fix Asana integration restricted branch filter](gitlab-org/security/gitlab@56e2d9ae3de4f587d2c8a5aa111c2922553d6b7b) ([merge request](gitlab-org/security/gitlab!2214))
- [Revert "JH need more complex passwords"](gitlab-org/security/gitlab@2419522b02700ce98e0c4d6e7bfd4d28b6464506) ([merge request](gitlab-org/security/gitlab!2354))

## 14.7.6 (2022-03-24)

### Added (1 change)

- [Detect and fix artifacts with backfilled expire_at](gitlab-org/gitlab@92938348905581798fa669051a61c107d082d908) ([merge request](gitlab-org/gitlab!83054))

### Changed (2 changes)

- [Enable feature flags to resume artifact removal on self-managed](gitlab-org/gitlab@45e4aba7099e0b6963674d192dc87edfe9ff8cdb) ([merge request](gitlab-org/gitlab!83054))
- [Remove runners token prefix feature flags](gitlab-org/gitlab@d57e7e1966cac500ba830dca7843cb315a34a4e4) ([merge request](gitlab-org/gitlab!82121))

## 14.7.5 (2022-03-09)

### Fixed (1 change)

- [Ensure cleanup job artifacts task does not include pipeline artifacts](gitlab-org/gitlab@7b5e91bc78c46109e48537b20239d4ab649a971a) ([merge request](gitlab-org/gitlab!82430))

### Other (1 change)

- [Change to truncate table before adding finding_link_url_idx](gitlab-org/gitlab@6411ec61f40cb8648cea24ed26c1d69c8b910891) ([merge request](gitlab-org/gitlab!82430))

## 14.7.4 (2022-02-25)

### Security (8 changes)

- [Limit commands_changes to certain keys](gitlab-org/security/gitlab@59351be8d1d868e31bc849482b266e4047710eeb) ([merge request](gitlab-org/security/gitlab!2226))
- [Add runners_token prefix to Group and Project](gitlab-org/security/gitlab@74615b7fd5359c4da7f1a3ca9052685e81e1690f) ([merge request](gitlab-org/security/gitlab!2249))
- [Anonymous user can enumerate all users through GraphQL endpoint](gitlab-org/security/gitlab@e213dfc546020d3f88b40cdfc0f877138b0aaef5) ([merge request](gitlab-org/security/gitlab!2119))
- [Check for unsafe characters in email addresses before sending](gitlab-org/security/gitlab@395385ffccfd9d25063531ea955b179d9bc4f0c5) ([merge request](gitlab-org/security/gitlab!2207))
- [Warn when snippet contains unretrievable files](gitlab-org/security/gitlab@dc4b3c00284e17bcbf20ec2ae1ee7e8a7efae9b2) ([merge request](gitlab-org/security/gitlab!2204))
- [Prevent DOS when rendering math markdown](gitlab-org/security/gitlab@f01674f210dee4c803b4850292d16412463b18e3) ([merge request](gitlab-org/security/gitlab!2200))
- [Check permission when creating members through service](gitlab-org/security/gitlab@4f9b302511ddfaf07af8d08d848252e0c64ff307) ([merge request](gitlab-org/security/gitlab!2210))
- [Reset password field on page load](gitlab-org/security/gitlab@1a6541462e1ddd58ea9a172fbd3c0b9026760784) ([merge request](gitlab-org/security/gitlab!2193))

## 14.7.3 (2022-02-15)

### Fixed (2 changes)

- [Update GitHub PRs Importer to force update repository](gitlab-org/gitlab@33f12736b070362cb89e9bbb4b3aa7d86fc373c3) ([merge request](gitlab-org/gitlab!80595))
- [Fix Geo checksummable check failing when file is nil](gitlab-org/gitlab@f49e3ea3e4d4ca7a64607687f9aaa974801b6bf9) ([merge request](gitlab-org/gitlab!80595)) **GitLab Enterprise Edition**

### Changed (1 change)

- [Properly exclude pending_destruction packages when creating one](gitlab-org/gitlab@9fb9f1ca8a2342225b7017c211f85175a4ef56dd) ([merge request](gitlab-org/gitlab!80595))

## 14.7.2 (2022-02-08)

### Added (1 change)

- [Allow self-hosted instances to render same-origin Iframe](gitlab-org/gitlab@eb7c78363cdfc670286967872d8458fc5f6d82e8) ([merge request](gitlab-org/gitlab!79966))

### Fixed (4 changes)

- [Geo: Fix reverify object stored files](gitlab-org/gitlab@603700dcca3b8f25a3b80b44b11a73df549c0cb3) ([merge request](gitlab-org/gitlab!79966)) **GitLab Enterprise Edition**
- [Geo: Fix verification failures of remote stored files](gitlab-org/gitlab@2eb8ac7e88dcd40f0e8266966655962e4d6e3171) ([merge request](gitlab-org/gitlab!79966)) **GitLab Enterprise Edition**
- [GitLab Version - CE Admin Dashboard [RUN ALL RSPEC] [RUN AS-IF-FOSS]](gitlab-org/gitlab@f2253ce2d729fa202a26b54f3ca870b932ea1855) ([merge request](gitlab-org/gitlab!79966))
- [Fix cluster integration HTTP adapter](gitlab-org/gitlab@c05027ef4d7ec35fc16e8e16dc6e5af201f665c3) ([merge request](gitlab-org/gitlab!79966))

### Changed (1 change)

- [Update to ruby-magic v0.5.4](gitlab-org/gitlab@ced6ef1001730dc2851f58f7db3229d1c585b9d3) ([merge request](gitlab-org/gitlab!79966))

### Removed (1 change)

- [Disable sandboxed_mermaid feature flag by default](gitlab-org/gitlab@70c40d43169bd48d360ed7a6a03c33c05d5e3738) ([merge request](gitlab-org/gitlab!79966))

## 14.7.1 (2022-02-03)

### Security

See https://about.gitlab.com/releases/2022/02/03/security-release-gitlab-14-7-1-released/

## 14.7.0 (2022-01-21)

### Added (84 changes)

- [Add verification before namespace creation](gitlab-org/gitlab@62c6ea0ff38f4a90ede4d5200e78206cdb71d29b) ([merge request](gitlab-org/gitlab!77315))
- [Add GraphQL mutation to destroy timeline events](gitlab-org/gitlab@71a1be80522bd01d3434dde6a5bb009454e65839) ([merge request](gitlab-org/gitlab!78192)) **GitLab Enterprise Edition**
- [ApplicationSetting: Add runner_token_expiration_interval field](gitlab-org/gitlab@d62621aa82714995cfe84c056773b291775b77bc) by @KyleFromKitware ([merge request](gitlab-org/gitlab!77884))
- [Rate limit Gitlab Shell operations](gitlab-org/gitlab@ddda5851babbad2f89b7ba37b0437b87e55950e5) ([merge request](gitlab-org/gitlab!78373))
- [Add `Delete` button to label edit view](gitlab-org/gitlab@07fa8e097bfc1143cfe362a0a4f2031d4792b73b) ([merge request](gitlab-org/gitlab!77917))
- [Enable autocomplete on cadence iteration create/edit pages](gitlab-org/gitlab@f0f99fc37266ebffb82134419bde8346ca799091) by @espadav8 ([merge request](gitlab-org/gitlab!78272)) **GitLab Enterprise Edition**
- [Extend GraphQL API interface with `securityTrainingProviders` field](gitlab-org/gitlab@d182af0c80834ddfc6f5db0587202f013351a42e) ([merge request](gitlab-org/gitlab!78195)) **GitLab Enterprise Edition**
- [Hierarchy page to show work items](gitlab-org/gitlab@a88b585c3b8cc4fd4fd11229e175ed4e24dead13) ([merge request](gitlab-org/gitlab!76720))
- [Add group level access token UI](gitlab-org/gitlab@a1a5cb34efe5218b562c69e621fc586625b3ed0a) by @fh1ch ([merge request](gitlab-org/gitlab!77449))
- [Remove ci_archived_build_trace_checksum feature flag](gitlab-org/gitlab@fbdec367917ae9f8ec4577f6de6ecd292755d5d0) ([merge request](gitlab-org/gitlab!78368))
- [Add scan result policies into the policy](gitlab-org/gitlab@71e49518d368fa7ab6a20a7ce295b5025923179f) ([merge request](gitlab-org/gitlab!77810)) **GitLab Enterprise Edition**
- [Enable logging when recursive webhook detected](gitlab-org/gitlab@2c9dc9a4b3d8b9f510369277f9d9fb12c319ee57) ([merge request](gitlab-org/gitlab!78343))
- [Enable sandboxed_mermaid feature flag](gitlab-org/gitlab@da35abbc144db7737f0633cc7c3b4121e7db1ad5) ([merge request](gitlab-org/gitlab!78283))
- [Feat(SM Subscription History): trim table size](gitlab-org/gitlab@1f43ddd699ee4934878f99d9741dc3ccbeb48e1a) ([merge request](gitlab-org/gitlab!78183)) **GitLab Enterprise Edition**
- [Add subsidized cost factor for Open Source plan](gitlab-org/gitlab@f71cc9528fb35bf963845913c67cf1ad69e144e9) ([merge request](gitlab-org/gitlab!77882)) **GitLab Enterprise Edition**
- [Remove expired agent activity events as new events are created](gitlab-org/gitlab@8aa9f25450d99139cc806cc985422a1ae0808b50) ([merge request](gitlab-org/gitlab!75709))
- [Add docs for pages domain rate-limits](gitlab-org/gitlab@12555484fbbe1687188644806e2c0880859f1977) ([merge request](gitlab-org/gitlab!77969))
- [Add a temporary index for Member.state](gitlab-org/gitlab@4a0852c64aee2312a4475db720d9acb04beeb075) ([merge request](gitlab-org/gitlab!77298))
- [Adding Secure Files data model and file uploader](gitlab-org/gitlab@92da2973e1cfc22b988ec4a24a5e36da6e1ff426) ([merge request](gitlab-org/gitlab!77886))
- [Expose internal_url setting for Geo secondaries](gitlab-org/gitlab@0af8fa9eba99528d17cbadc3a811575fea862897) ([merge request](gitlab-org/gitlab!77179)) **GitLab Enterprise Edition**
- [Add the `draft` argument to GraphQL MergeRequestsResolver](gitlab-org/gitlab@701214248ec36e6b79c4db3cd78cd315ba62e7f2) ([merge request](gitlab-org/gitlab!78181))
- [Send a rejection email if incoming emails are too large](gitlab-org/gitlab@d9e1fb2be07af9f43f8cda7ceca2f362586830f1) ([merge request](gitlab-org/gitlab!77638))
- [Clean up escalations after changing incident proj](gitlab-org/gitlab@75943f4afd57a030e8c3667d47a938d9d3bf02c1) ([merge request](gitlab-org/gitlab!77086)) **GitLab Enterprise Edition**
- [Support default templates for issues/MRs via .gitlab/ folders](gitlab-org/gitlab@9cdca50399671316824442cbb00f3c27f4a82a13) by @davebarr ([merge request](gitlab-org/gitlab!76326))
- [Add link to the self-managed trial flow from SaaS trial signup](gitlab-org/gitlab@c68e39aab18b6d373369b1b4fce5d9f99b1c2fae) ([merge request](gitlab-org/gitlab!76476)) **GitLab Enterprise Edition**
- [feat: Bump Code-Quality image to 0.85.26](gitlab-org/gitlab@fb862e4f77f377e269a15d6bdbbd3b1b2f0fe22f) ([merge request](gitlab-org/gitlab!78125))
- [Allow issue contacts from parent groups](gitlab-org/gitlab@380cc55a36a2e0e738f8c58e03f18b344712d99b) by @leetickett ([merge request](gitlab-org/gitlab!77352))
- [Allow to wrap inline code in other marks](gitlab-org/gitlab@e3b9f1ab6a7002c5d7ed1b4917b7a3e5aa54d016) ([merge request](gitlab-org/gitlab!78081))
- [Registration features info for ip restriction](gitlab-org/gitlab@70dad3a46c4e7a8aa052014b1972ebe1d6feaa32) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/74022)) **GitLab Enterprise Edition**
- [Add approve button on pending members table](gitlab-org/gitlab@844577de50d75d35eaad3950ea972f677d721889) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/75756)) **GitLab Enterprise Edition**
- [Upgrade GitLab Pages to 1.51.0](gitlab-org/gitlab@fe8eab56e1af1cb531b80bdd9418b80aab045387) ([merge request](gitlab-org/gitlab!78066))
- [Indicate locked users in Admin Area](gitlab-org/gitlab@ecb69f22f0bcf9e45638441edc8a096060138179) ([merge request](gitlab-org/gitlab!77729))
- [Include the project name VSA stage records](gitlab-org/gitlab@2277b12463d6ba32a68737f396a001842e530f07) ([merge request](gitlab-org/gitlab!77841)) **GitLab Enterprise Edition**
- [Accept maintainer_note in REST runner registration](gitlab-org/gitlab@574e6f6e2ee3d80b89a09abb7346b60e94e06269) ([merge request](gitlab-org/gitlab!77779))
- [Enforce unique contact email for group hierarchy](gitlab-org/gitlab@6895e1ad1ec27efebd0750d0351917ebbba38c6f) by @leetickett ([merge request](gitlab-org/gitlab!77830))
- [Add maintainer_note field to CI runners table](gitlab-org/gitlab@0ecabcff56b140cd7a9211500d44072d2c020f8c) ([merge request](gitlab-org/gitlab!77767))
- [GitLab Version - Help Dropdown Version](gitlab-org/gitlab@a12657ea63d161613d2b1ce88cb01029d196f9e5) ([merge request](gitlab-org/gitlab!74830))
- [Add support for backing up Packages](gitlab-org/gitlab@7d89a2283e629ddad1695189774f66d2c1e4d8d4) ([merge request](gitlab-org/gitlab!77532))
- [Allow to configure log level of Gitlab:Logger (by env variable)](gitlab-org/gitlab@f5718975c73f2469eb437d7f0e40c7b9ab3c0cdb) by @wwwjon ([merge request](gitlab-org/gitlab!77667))
- [REST API: add field merge_user to MR response](gitlab-org/gitlab@5246e6c9ebd5d717ddc1c48bcba39e754656bf34) by @trakos ([merge request](gitlab-org/gitlab!77658))
- [Add index for selecting active agent tokens](gitlab-org/gitlab@732ecd9ce4ad55e6149f62501acd51c70b168508) ([merge request](gitlab-org/gitlab!77923))
- [Add vulnerabilityFindingDismiss GraphQL mutation](gitlab-org/gitlab@3a3e04be0d988de3d0742eae81cb34de25be3b9c) ([merge request](gitlab-org/gitlab!77372)) **GitLab Enterprise Edition**
- [Enable filtering agent tokens by status](gitlab-org/gitlab@caab657574087d94a02a6e8fca482e6683f8acfe) ([merge request](gitlab-org/gitlab!77735))
- [Add customer relations group setting](gitlab-org/gitlab@3ecdc804ab926194bf7b6687ce6e850480b400e5) by @leetickett ([merge request](gitlab-org/gitlab!77386))
- [Add namespace_id reference to routes](gitlab-org/gitlab@b8eb9f1daf0f17f9f4b1a7024f7b8a471937892e) ([merge request](gitlab-org/gitlab!77571))
- [Add scan result policy into policy list](gitlab-org/gitlab@f8846f093036b1e44f406f0817455563341b8e20) ([merge request](gitlab-org/gitlab!77778)) **GitLab Enterprise Edition**
- [Add package managers api paths to details type](gitlab-org/gitlab@d00938625158efc2dbc15228962787ab1fa82eef) ([merge request](gitlab-org/gitlab!77518))
- [Adds API feature configuring default mr target](gitlab-org/gitlab@1e3a3ddfc408d43de1ce018525912c6f19953581) ([merge request](gitlab-org/gitlab!77169))
- [Enable autocomplete features on iteration forms](gitlab-org/gitlab@bcb5110c0a49760cf4fbc03f0e13f80c2cd28ff3) by @espadav8 ([merge request](gitlab-org/gitlab!77511)) **GitLab Enterprise Edition**
- [Add editAdminUrl to Runner GraphQL API](gitlab-org/gitlab@62dd4d2257bf3322d06fb3e45223dca94468ab1a) ([merge request](gitlab-org/gitlab!77748))
- [Expose iteration ordinal number via APIs](gitlab-org/gitlab@e558ef90dcbed60c0e234f2ec3a8733a0fc040e8) ([merge request](gitlab-org/gitlab!77650)) **GitLab Enterprise Edition**
- [Add enable and disable advanced search rake tasks](gitlab-org/gitlab@4de079337744c963657174e43fd72dbfe42a638b) ([merge request](gitlab-org/gitlab!75946)) **GitLab Enterprise Edition**
- [Allow to hide personalization questions on New Group page](gitlab-org/gitlab@f64750a2ce222c7f0199408a6f5d53a1d6bff36e) by @wwwjon ([merge request](gitlab-org/gitlab!76920))
- [Registration features info for sending emails](gitlab-org/gitlab@657c11fec93bb29b8e3bd28f8b9c9330f1498a43) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/74042)) **GitLab Enterprise Edition**
- [Add Group Access Token API endpoints](gitlab-org/gitlab@de7db9d75eecc16266f9331fa99aa7ab8cdf2e1e) by @fh1ch ([merge request](gitlab-org/gitlab!77236))
- [GraphQL: Add count property to RunnerType’s connection](gitlab-org/gitlab@fcaa5681819bc800acc0e1ae751420e6e994c193) ([merge request](gitlab-org/gitlab!77578))
- [Add GraphQL mutation to revoke an agent token](gitlab-org/gitlab@43d8a69cfbdd26e55a61d13fada73d9012a77242) ([merge request](gitlab-org/gitlab!77635))
- [Schedule recalculating UUID for all `Vulnerabilities::Finding` records](gitlab-org/gitlab@88326bacf0d0dd14c04aed23f0506cf6ff51d45b) ([merge request](gitlab-org/gitlab!75546))
- [Add migration to enqueue background worker](gitlab-org/gitlab@853e639114a473a00338f5b42c0085fbee8e91a9) ([merge request](gitlab-org/gitlab!76714))
- [Add createdAt to Runner GraphQL API](gitlab-org/gitlab@f91730711cf4c452b90863fadd3dd4fcbedc7093) ([merge request](gitlab-org/gitlab!77561))
- [Add search and sorting to tags](gitlab-org/gitlab@ee4c64d2c469291e3b51a88e20bc658c58f52004) ([merge request](gitlab-org/gitlab!76759))
- [Update gitlab-omniauth-openid-connect gem to support ECSDA keys](gitlab-org/gitlab@1c8377c8cf95ec518561a65323766856d1f76d81) ([merge request](gitlab-org/gitlab!77491))
- [Remove dependency proxy feature flag](gitlab-org/gitlab@5237844f3fcfc918376d20012a703ed1a2525b4a) ([merge request](gitlab-org/gitlab!77477))
- [Upgrade GitLab Pages to 1.50.0](gitlab-org/gitlab@7bae98c9590cd2ad1b17e5a1abd4737320632ada) ([merge request](gitlab-org/gitlab!77405))
- [Add HTTP status to LFS push client error messages](gitlab-org/gitlab@4e1acedbfd28b3adf9c0a0569843e80f2d5d6ef8) ([merge request](gitlab-org/gitlab!77334))
- [Add group crm settings](gitlab-org/gitlab@083c1f8f6eb4accca6b6707a32866a59260504c6) by @leetickett ([merge request](gitlab-org/gitlab!76983))
- [Add co_authored_by to merge commit templates](gitlab-org/gitlab@143e577c77c56339473561ddeeb0e0c75073f8ff) by @trakos ([merge request](gitlab-org/gitlab!76042))
- [Allow filtering epics by author_username and not[author_username]](gitlab-org/gitlab@5d759493f94eafb3361ab1080d31beeff6203375) by @espadav8 ([merge request](gitlab-org/gitlab!77151)) **GitLab Enterprise Edition**
- [Add `ref_path` to PipelineType](gitlab-org/gitlab@f1cb789d3d0267455a7242f6a8de63688f65eb26) by @genctys ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/72591))
- [Allow LDAP failover](gitlab-org/gitlab@3a900c1b39be153b37be3db8e60bcfb8de51513b) by @sathieu ([merge request](gitlab-org/gitlab!77000))
- [Add Backup and Restore tasks for Terraform States](gitlab-org/gitlab@58a8d4f80b24f2e6dc6d99a2675ea220310d044b) ([merge request](gitlab-org/gitlab!63347))
- [Handle syncing alert escalation status to incident](gitlab-org/gitlab@badcfcd2aa91748bf67adfcfd22b316199723e91) ([merge request](gitlab-org/gitlab!75706))
- [Added possibility to remove agent from UI](gitlab-org/gitlab@6b5b5e8f5879e896efcb76a8eb9fff16282f4881) ([merge request](gitlab-org/gitlab!77199))
- [Add "Scan library" tab](gitlab-org/gitlab@d3ca75aacca08c7651b0c0b8bd49a3253aac8e51) ([merge request](gitlab-org/gitlab!77107)) **GitLab Enterprise Edition**
- [Enable github_importer_use_diff_note_with_suggestions by default](gitlab-org/gitlab@eaab50eb575d73513ac2f2eef4f85adbbccb0043) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/74096))
- [Rename projects set for delayed deletion](gitlab-org/gitlab@268d41a518a7021f75881e46290e533ac85ab3df) ([merge request](gitlab-org/gitlab!76675))
- [Add unique userid count for Geo proxied requests](gitlab-org/gitlab@27ae10f38bbeffa53d729881b854f63402e86d82) ([merge request](gitlab-org/gitlab!76587)) **GitLab Enterprise Edition**
- [Add rate limiting for user email lookup](gitlab-org/gitlab@fe9363276e8e6027c851b83ec6bf13ec6a412878) ([merge request](gitlab-org/gitlab!76760))
- [Export Project LFS Objects as part of GitLab Migration](gitlab-org/gitlab@7867db2c22fb9c9850e1dcb49f26fa2b89a665c6) ([merge request](gitlab-org/gitlab!77018))
- [Add GraphQL query to retrieve timeline events](gitlab-org/gitlab@e18bf545fa62c1e15977bed1f55c94de88285932) ([merge request](gitlab-org/gitlab!76232)) **GitLab Enterprise Edition**
- [Limit Sidekiq push_bulk to a maximum of 1000 jobs in one go by default](gitlab-org/gitlab@8e2664ed46c4d172024a1c52673fc6ea3a1be667) ([merge request](gitlab-org/gitlab!77088))
- [Add revoked status to cluster agent tokens](gitlab-org/gitlab@283842444a31d6ebab0ae22559e6e71dd918e691) ([merge request](gitlab-org/gitlab!76505))
- [Allow passing in an epic parent_id when updating epics](gitlab-org/gitlab@d71076d540cd7a888ffbdc34748c493d229c4f5e) by @espadav8 ([merge request](gitlab-org/gitlab!76510)) **GitLab Enterprise Edition**
- [Add database.flavor to usage data](gitlab-org/gitlab@9179c6fc3d589d2a042d3716b3577bb0b1644989) ([merge request](gitlab-org/gitlab!75587))

### Fixed (98 changes)

- [Fix copying/pasting images in the Content Editor](gitlab-org/gitlab@0cbc98ec5e900b1e5cd9bc70330038b6bd1facb8) ([merge request](gitlab-org/gitlab!78295))
- [Fix security dashboard showing wrong count for more than 100 projects](gitlab-org/gitlab@bdceb76ca0d67b8aeb3d60ceddd9f546f15880b9) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/78074)) **GitLab Enterprise Edition**
- [Fix default emaildomain when creating RAT users](gitlab-org/gitlab@b8f08407b9b3551e9a6f2e194cc68d4621b16f53) by @cruelsmith ([merge request](gitlab-org/gitlab!74506))
- [Show blocked status label in deployments view](gitlab-org/gitlab@95fc512756749b80d46863975b98e9ba8c081bf1) ([merge request](gitlab-org/gitlab!78234)) **GitLab Enterprise Edition**
- [Dependency proxy settings are built on access](gitlab-org/gitlab@b45f64264ef2d86a9461bce01f329515c06a4cf8) ([merge request](gitlab-org/gitlab!77553))
- [Allow git protocol to be used for repository imports](gitlab-org/gitlab@0f5eade690d7b5f744ea19a5a4e84bb126e4b60e) ([merge request](gitlab-org/gitlab!78479))
- [Show "Issues" menu when Jira issues is enabled](gitlab-org/gitlab@807e746aeb02406309e9dc40afca0d5f4b4c7428) ([merge request](gitlab-org/gitlab!78467)) **GitLab Enterprise Edition**
- [Order child epics in roadmap by configured sort order](gitlab-org/gitlab@53a095bf9d319b69d95517895495d84f0801b0dc) by @espadav8 ([merge request](gitlab-org/gitlab!78249)) **GitLab Enterprise Edition**
- [Fix disabled style for mirror settings field](gitlab-org/gitlab@105e3ac6aa244fd202d846fed19b30cdde07360d) ([merge request](gitlab-org/gitlab!78399))
- [Destroy trace chunks and data when deleting pipelines](gitlab-org/gitlab@70987ae1fad949e03f9812a2baa5635c64d0dd23) ([merge request](gitlab-org/gitlab!78116))
- [Fix authorized_groups to include sub groups as well](gitlab-org/gitlab@2273ebc4d6defa6b76be38bf4fd026926d5e0704) by @wwwjon ([merge request](gitlab-org/gitlab!76556))
- [Fix margin for submit button with captcha](gitlab-org/gitlab@b6b3509f1bb98adeaa4a24bc40faa8e8e8799176) ([merge request](gitlab-org/gitlab!78316))
- [Migrate Epics tabs to Vue](gitlab-org/gitlab@186fe2573fc3b97481a234764f238ca782184792) ([merge request](gitlab-org/gitlab!77653)) **GitLab Enterprise Edition**
- [Fix N+1 issue when associating DAST profiles and CI Builds](gitlab-org/gitlab@1136d945411c12e328d96faf9d019167c629e086) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/75448)) **GitLab Enterprise Edition**
- [Geo: Fix undefined separate_verification_state_table?](gitlab-org/gitlab@17bb757f0b2781606194e3c504ea9fd468981c0b) ([merge request](gitlab-org/gitlab!78293)) **GitLab Enterprise Edition**
- [Error Tracking: Fix collecting errors for golang](gitlab-org/gitlab@e0d5bee3b05bf7c90dbc36c788a77924006939d0) by @bastianccm ([merge request](gitlab-org/gitlab!78199))
- [Notify admins 15 days prior to license expiration](gitlab-org/gitlab@c58f99d5aaa7f70b1d727d9c4591dbe030867bdb) ([merge request](gitlab-org/gitlab!78000)) **GitLab Enterprise Edition**
- [Fix auditor user able to bulk select vulns on vulnerability report](gitlab-org/gitlab@0d18a578bc1fcd8ea7cec17ac2e5eeae8bd6df46) ([merge request](gitlab-org/gitlab!78241)) **GitLab Enterprise Edition**
- [Fix autoscroll to comments on issues](gitlab-org/gitlab@2884857277ce2b6c1c01635f04022117258f9ac1) ([merge request](gitlab-org/gitlab!76340))
- [Strip + reference format from HTML links](gitlab-org/gitlab@4a9a163cfe57669a96cf7f52babe5296817f81ce) ([merge request](gitlab-org/gitlab!78229))
- [Allow developers to fork into group](gitlab-org/gitlab@ddcf166129acb5aee41547d2f6edd5596b7a49b2) ([merge request](gitlab-org/gitlab!78204))
- [Use normal font weight and border for 'Subscribe' buttons](gitlab-org/gitlab@dc35d3c742b89c7e15648b3de05e81bad0158483) by @KevSlashNull ([merge request](gitlab-org/gitlab!75961))
- [Improve visibility radio option text on new project page](gitlab-org/gitlab@bce954ea1ed798fd0cac0a9ff6660a94f53ca34c) ([merge request](gitlab-org/gitlab!78083))
- [Fix schema registration in the pipeline editor](gitlab-org/gitlab@8710212ee7ade8321f0c3cdc2cb4615cad365017) ([merge request](gitlab-org/gitlab!77743))
- [Boards - Fix weight assigned to wrong card](gitlab-org/gitlab@fe2abc0bc79a20c2017ff082b3ad220be2f6b222) ([merge request](gitlab-org/gitlab!78161)) **GitLab Enterprise Edition**
- [Remove unnecessary CSS in VSA](gitlab-org/gitlab@2e80c7955adfa1c05ad5bf56c32e169642312f67) ([merge request](gitlab-org/gitlab!78175))
- [Fix shift after VSA path load](gitlab-org/gitlab@51961b486dae6db5d09b0c958b96d3ef4a2eef8d) ([merge request](gitlab-org/gitlab!77960))
- [Fix Incident sidebar on issue boards](gitlab-org/gitlab@743ee5d690df326d441702aaa06041ca5e38505b) ([merge request](gitlab-org/gitlab!78021))
- [Always autofill group slug](gitlab-org/gitlab@f4c35074e597fb95738fdc7977f20665062bf01f) ([merge request](gitlab-org/gitlab!78152))
- [Update excon to v0.90.0](gitlab-org/gitlab@4efa0b3feee70cd1f1b95e100fbdd858a674d7d2) ([merge request](gitlab-org/gitlab!78147))
- [Format issue list counts](gitlab-org/gitlab@2a359443494573caf5fab88a72df45d504fc5a56) ([merge request](gitlab-org/gitlab!77986))
- [Ignore multiple <code> when syntax highlighting](gitlab-org/gitlab@7a6fb02d8c4c6a9755dcc849913813b9c57cf35c) ([merge request](gitlab-org/gitlab!77796))
- [Waive credit card validation if project has paid CI/CD minutes](gitlab-org/gitlab@7c2e0e1bf79c63bb1436ed2cb1aa1c97baf9441b) ([merge request](gitlab-org/gitlab!77829)) **GitLab Enterprise Edition**
- [Fix toggle code block button in Content Editor](gitlab-org/gitlab@766da0c228f5b1bf6dae79c45fa67fbb5844e260) ([merge request](gitlab-org/gitlab!78071))
- [Use the same email validation for User and Email](gitlab-org/gitlab@866a5fa0f6ba9c71d728a8c7b4f7007d9fa9d755) ([merge request](gitlab-org/gitlab!77785))
- [Expose new monthIso8601 GraphQL option to fix CI minutes usage sorting](gitlab-org/gitlab@43cd0bbd9ec6e59ae7bad449dd21ee10a67f0267) by @davebarr ([merge request](gitlab-org/gitlab!78006))
- [Improve ReadTotalTimeout to start with reading](gitlab-org/gitlab@7448b7927973ba17af2d5a5121b2f5b221eb4405) ([merge request](gitlab-org/gitlab!77879))
- [Update excon gem to v0.89.0](gitlab-org/gitlab@af75482f39e73d3670d82f4dd7050bd6bd46a4ab) ([merge request](gitlab-org/gitlab!78007))
- [Fix infinite loop in Content Editor codeblocks](gitlab-org/gitlab@2fe3c8849ba12a03608de211b3cf3d5eb334f8e4) ([merge request](gitlab-org/gitlab!77965))
- [Only show owners & admins CI minutes purchase notifications](gitlab-org/gitlab@723c7229d3e927b6552bdd84b8cbcd120fb3a24a) ([merge request](gitlab-org/gitlab!77118)) **GitLab Enterprise Edition**
- [Restric access to crm to reporter+](gitlab-org/gitlab@e495d6a5c83c7e9e194d425e5558385749cae73e) by @leetickett ([merge request](gitlab-org/gitlab!77825))
- [Fix destruction of projects with pipelines](gitlab-org/gitlab@1cbf0709c5df11aa273350054ad276edf50e16fb) ([merge request](gitlab-org/gitlab!77941))
- [Fix invalid raw_metadata being persisted](gitlab-org/gitlab@14835eb9bfda4c1a107f20c0c7f6594a89a3fa16) ([merge request](gitlab-org/gitlab!76151))
- [Disable copy-code button for mermaid diagrams](gitlab-org/gitlab@ca5833e1c8adeda25c9a2e5ea64349307bef3c84) ([merge request](gitlab-org/gitlab!77935))
- [Return 401 when using invalid tokens in oauth/token/info](gitlab-org/gitlab@3e0738ce3ae3d4b19d728f3cc719857b5f7c88ce) ([merge request](gitlab-org/gitlab!77644))
- [Fix the text on Kubenetes Agent modal](gitlab-org/gitlab@60d29a672dceb8a41e13f2754339aef3dccacff0) ([merge request](gitlab-org/gitlab!77933))
- [Add patch for WikiCloth Lua vulnerability](gitlab-org/gitlab@6c03aad1d81c574b695b207eb4335d6905f24ba5) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/76174))
- [Notify admins 15 days prior to license expiration](gitlab-org/gitlab@b07a83f73772ff9abdbd44153c4203a117661d0e) ([merge request](gitlab-org/gitlab!77608)) **GitLab Enterprise Edition**
- [Fix image comment note submission](gitlab-org/gitlab@a2e81cec76c72053f676dcea082a7b75b3f2037e) ([merge request](gitlab-org/gitlab!77864))
- [Fix last update time for project in group page](gitlab-org/gitlab@a290c395c7af5012052045136a95bfde8de45dce) by @orozot ([merge request](gitlab-org/gitlab!77356))
- [Fix missing autosave support in Epic create form](gitlab-org/gitlab@3c479a42896e4b9390232c8d5b0bce6635dc9e89) ([merge request](gitlab-org/gitlab!77859)) **GitLab Enterprise Edition**
- [Remove menu when is not possible to delete](gitlab-org/gitlab@3d10359ebe5e2c9f32ce51e27239ba5a9d0593a8) ([merge request](gitlab-org/gitlab!77692))
- [Correctly pass instance in EDITOR_READY_EVENT](gitlab-org/gitlab@6be7d6bee5a2d1ad70a9d04013f5fdc3746f62a9) ([merge request](gitlab-org/gitlab!77852))
- [Merge/squash commit templates: avoid breaking Git trailers](gitlab-org/gitlab@77922683758f9772d4b88f53a9e9cabf38267944) by @trakos ([merge request](gitlab-org/gitlab!77758))
- [Prevent design discussions without login](gitlab-org/gitlab@73a6999553598919ea2db32bb3266e56cea03852) ([merge request](gitlab-org/gitlab!77563))
- [Remove cluster image scanning dropdown item from scanner filter](gitlab-org/gitlab@343443b4abb7102549c67b498d96163eacfe2250) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/77738)) **GitLab Enterprise Edition**
- [Fix hook log path for service hooks](gitlab-org/gitlab@b9141ad9c798d0e4219c922d5f2ee0ec8735661e) ([merge request](gitlab-org/gitlab!77741))
- [Fix pipeline schedule resets to UTC on edit](gitlab-org/gitlab@d5298c293fc60a14ce431b63a13493025be2814f) by @JonstonChan ([merge request](gitlab-org/gitlab!77723))
- [Use correct namespace method](gitlab-org/gitlab@375ee7ac45a4e9f554339752e6ec207e2b662787) ([merge request](gitlab-org/gitlab!77678))
- [Re-add EachBatch include for failed_verification_timeouts](gitlab-org/gitlab@6285caf988103d29883e55fbc1b3d34c6699cd0f) ([merge request](gitlab-org/gitlab!77676)) **GitLab Enterprise Edition**
- [Fix Sidekiq reporting to Sentry outside of job contexts](gitlab-org/gitlab@4ee15af663a4277e43cd53798168edfac7367428) ([merge request](gitlab-org/gitlab!77659))
- [Fix sticky filters not working on vulnerability report](gitlab-org/gitlab@d57da00d0771100f1b7a278715882088fadc24ec) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/77647)) **GitLab Enterprise Edition**
- [Fix Kubernetes Agent Link on Project page](gitlab-org/gitlab@eff9a85753bfc0d6d4ed5316d65c2d49bf17cc2b) ([merge request](gitlab-org/gitlab!77645))
- [Externalize strings for translation in todos](gitlab-org/gitlab@224f2ead1c3592dd7372de94e05d5d0d65342dbc) ([merge request](gitlab-org/gitlab!77402))
- [Update Rails to v6.1.4.4](gitlab-org/gitlab@a091fd5e95b7033453c236d7f8e188cebd8b94ff) ([merge request](gitlab-org/gitlab!77630))
- [Fix input group text border color](gitlab-org/gitlab@4ba08fe6ad7bc85e760fc0b6c9fcb7bac898c19a) ([merge request](gitlab-org/gitlab!77607))
- [Match address of host when checking whether to login](gitlab-org/gitlab@d8d066def6db36708a6373ec1640ef4401c66647) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/73492)) **GitLab Enterprise Edition**
- [Improve LFS client performance and fix compatibility with Azure DevOps](gitlab-org/gitlab@6e532b4d22abcac66b54993ab27fc791db13e40f) ([merge request](gitlab-org/gitlab!77326))
- [Do not fail report ingestion if there is an invalid finding](gitlab-org/gitlab@c752c229fc0bb68fdf0503301c192ffd364aca3a) ([merge request](gitlab-org/gitlab!77591)) **GitLab Enterprise Edition**
- [Update acme-client to v2.0.9](gitlab-org/gitlab@c0a40f092db148ec87dc0bb09d75f664e7ebd305) ([merge request](gitlab-org/gitlab!77534))
- [Update rouge gem version](gitlab-org/gitlab@bad64f0b050212029e5a7ae2b4d5ea696b36ee48) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/76884))
- [Adjust bottom margin for loose markdown lists](gitlab-org/gitlab@c197e14dbd8fb307c4580e26d1196e703315b449) ([merge request](gitlab-org/gitlab!77275))
- [Remove running build entries when calling doom on a build](gitlab-org/gitlab@bedc9243d29e8c5bbfd8a1c17373e8d09c5f388a) ([merge request](gitlab-org/gitlab!77507))
- [Fix migration for cases with empty strings](gitlab-org/gitlab@8d5405a6516ee07721fadcc43c1da27fc0b7a177) ([merge request](gitlab-org/gitlab!77506))
- [Fix 500 errors when renaming projects with underscores](gitlab-org/gitlab@4a70f4ef144347dc9dc98240cfc63693e2458855) ([merge request](gitlab-org/gitlab!77485))
- [Geo: adapt verification timed out query to use state table](gitlab-org/gitlab@2b6d41e07fc4be9318aa0402856cb4f23aa46dc3) ([merge request](gitlab-org/gitlab!77364)) **GitLab Enterprise Edition**
- [Allow admins to foce confirm emails](gitlab-org/gitlab@e3a73408c5d8fea67dc613fb54225c925115eb50) ([merge request](gitlab-org/gitlab!77287))
- [Ignore new line differences when deciding whether to squash MR](gitlab-org/gitlab@7b38fbeeddbaed7fc34470ee29a7d6a0c7bd2793) by @trakos ([merge request](gitlab-org/gitlab!77429))
- [Fix re-use of extensions between instances](gitlab-org/gitlab@6c29b2da23027c526be90091370a9dcb663a46c2) ([merge request](gitlab-org/gitlab!77319))
- [Fix nil actor errors in Sentry API handler](gitlab-org/gitlab@fa51f84199e4ef09d3c7d5fe96927bf2aebfed3d) ([merge request](gitlab-org/gitlab!77340))
- [Removes the dismiss button from the pipeline header alert](gitlab-org/gitlab@e1f8647c94e84033856f94ac0bedf49e31b6e908) ([merge request](gitlab-org/gitlab!77128))
- [Call dependency proxy cleanup workers in purge](gitlab-org/gitlab@ed164a8c593f4e4a34db9e3f056721ee30f67563) ([merge request](gitlab-org/gitlab!77043))
- [Add Auth0, JWT, and Shibboleth to list of providers with icons](gitlab-org/gitlab@67a5600d4b36f1a673be94ed75aab70426d63a78) ([merge request](gitlab-org/gitlab!77213))
- [Fix Prometheus endpoint to return created alerts](gitlab-org/gitlab@d473fefa655b7d362f8ebcc4d1205b2955d466fd) ([merge request](gitlab-org/gitlab!77168))
- [Make time track help state top margin consistent](gitlab-org/gitlab@010bca712fd8db81589e8cd4d73b90983735868c) ([merge request](gitlab-org/gitlab!77087))
- [Validate against duplicates in job needs](gitlab-org/gitlab@1aa37265cf00ac987cd33a56823db7bfdd0238a5) ([merge request](gitlab-org/gitlab!77083))
- [Fix MergeRequest's MergeUser for non-MWPS merges in GraphQL API](gitlab-org/gitlab@a65d4e2b68f3849c9d5193e38fcf300aa0985549) by @trakos ([merge request](gitlab-org/gitlab!76043))
- [Align roadmap quarters to calendar quarters](gitlab-org/gitlab@e0e4058d7d934bdc3db3c06ab8449b3d35049621) by @espadav8 ([merge request](gitlab-org/gitlab!76927)) **GitLab Enterprise Edition**
- [checks: Fix revalidation of preexisting commits](gitlab-org/gitlab@d86514f1068552632ea4988d705b18803938f696) ([merge request](gitlab-org/gitlab!76106))
- [Fix project import from remote to import from S3](gitlab-org/gitlab@242c4c8f6128580d78da81e18a655c7dbda7a380) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/75170))
- [Mark vulnerabilities as not resolved on default branch on ingestion](gitlab-org/gitlab@80e79c7adc9574a485628b1479ababd98600551d) ([merge request](gitlab-org/gitlab!77060)) **GitLab Enterprise Edition**
- [Skip updating vulnerability statistics if there are no new records](gitlab-org/gitlab@e580999f2b52996769a80a0930f5fc846bf7b7a2) ([merge request](gitlab-org/gitlab!77056)) **GitLab Enterprise Edition**
- [Remove legacy pages config updates](gitlab-org/gitlab@a1a540c0c4db7376cce601cc87e14f9193302c3b) ([merge request](gitlab-org/gitlab!76918))
- [Do not check SSO session for git operations originating from CI/CD jobs](gitlab-org/gitlab@fc84cab8beb8e64df750e7e4019978d4551f886f) ([merge request](gitlab-org/gitlab!76909)) **GitLab Enterprise Edition**
- [MR Documentation suggestions](gitlab-org/gitlab@9f4cf0975108469e83ec16fb30530f69c2fdc4a9) by @lzampier ([merge request](gitlab-org/gitlab!66778))
- [Drop reindexing leftovers only if exclusive lease is granted](gitlab-org/gitlab@0b4a82f2120527a21a502ca8531d7da0726c3dd5) ([merge request](gitlab-org/gitlab!75290))
- [Fix import project from gitlab.com error](gitlab-org/gitlab@677873e2d0df439cda3a5a92eabaf76e354fa9bb) by @orozot ([merge request](gitlab-org/gitlab!76768))
- [Fix filename overflowing modal when importing](gitlab-org/gitlab@b49c821609cee720da8d277488fd2969f3f97d25) by @KevSlashNull ([merge request](gitlab-org/gitlab!75891))

### Changed (135 changes)

- [Change hashing algorithm in webpack](gitlab-org/gitlab@8d42ec95c12041ce8738828a9e07e7569afd8bea) ([merge request](gitlab-org/gitlab!78581))
- [Swap FK ci_pipeline_artifacts to projects for LFK](gitlab-org/gitlab@5e3f68fc65480679d2e12aaab0ca05729e56c079) ([merge request](gitlab-org/gitlab!78058))
- [Remove permitted_attributes_for_import_export feature flag](gitlab-org/gitlab@8897e37db2c20621fc59371f4e3c38c0f6048ad2) ([merge request](gitlab-org/gitlab!75090))
- [Do not add a failed build todo before auto-retry](gitlab-org/gitlab@971b38d23fd1359b6e9838ec3df8e5a3a6745fc9) ([merge request](gitlab-org/gitlab!77972))
- [Redesign new policy form](gitlab-org/gitlab@eedf5c443a761b90d3b9f4cf31c8c5afc150fb99) ([merge request](gitlab-org/gitlab!77482)) **GitLab Enterprise Edition**
- [Labels widget - focus first item on search](gitlab-org/gitlab@13986d5bb220d21830b8462170daf856c59bc3e2) ([merge request](gitlab-org/gitlab!78425))
- [Add shared runner tab to group CI/CD analytics](gitlab-org/gitlab@927f165c4d6d02006ddb2acca84c7b3cde97644d) ([merge request](gitlab-org/gitlab!78014)) **GitLab Enterprise Edition**
- [Update sort name from Last updated to Updated date](gitlab-org/gitlab@546e0a86241a332bde96bacd991876db06ea6c69) ([merge request](gitlab-org/gitlab!77684))
- [Warn when mention all users in a group](gitlab-org/gitlab@1c858cc3e2c13f05068f83a3bb81451084c3c1f4) ([merge request](gitlab-org/gitlab!77624))
- [Check for removed external issues before creation](gitlab-org/gitlab@cb2ee27d217c9616f297b05e9ce473aec94d920c) ([merge request](gitlab-org/gitlab!78323)) **GitLab Enterprise Edition**
- [Replace Member created state with active](gitlab-org/gitlab@58655c28e5232fd4b79cd85693f526ffc7591303) ([merge request](gitlab-org/gitlab!76653))
- [Polish Slack application edit page UI](gitlab-org/gitlab@bc80b81cdf3207196b294d19752e56a4a070eb05) ([merge request](gitlab-org/gitlab!78252)) **GitLab Enterprise Edition**
- [Enable feature flag bulk_expire_project_artifacts](gitlab-org/gitlab@df74c6101841f141a5cd993665f0bce1c75606fc) ([merge request](gitlab-org/gitlab!78429))
- [Make pipeline badges Pajamas-complient](gitlab-org/gitlab@855d9ddf8511364a892f3bb1b6c12f97770d350a) ([merge request](gitlab-org/gitlab!77980))
- [Format email code blocks and code blocks in emails](gitlab-org/gitlab@d9e12b8fd319285d0415b794750e531bff5f11ba) by @smokris ([merge request](gitlab-org/gitlab!76977))
- [Geo Sites - Icon Actions](gitlab-org/gitlab@2bf77ebf3f0b27edca536737aa7a88afd7a05786) ([merge request](gitlab-org/gitlab!78410)) **GitLab Enterprise Edition**
- [Geo - Rename routes from Nodes to Sites](gitlab-org/gitlab@7e9d16fa36764634c7eb230f81dcae68fcd9cdff) ([merge request](gitlab-org/gitlab!78150)) **GitLab Enterprise Edition**
- [Cleanup after AddPrimaryEmailToEmailsIfUserConfirmed](gitlab-org/gitlab@074490e6d9646d5757bfc5b309530f4bfb564c2f) ([merge request](gitlab-org/gitlab!76141))
- [Change default shallow clone depth to 20](gitlab-org/gitlab@07ed1b8bbfd9e9088cc0aa30de35547aeec54f92) ([merge request](gitlab-org/gitlab!77576))
- [Update webhook badges to pajamas](gitlab-org/gitlab@173a008c9800be87ef6fc7991bf84b44fd62cd8a) ([merge request](gitlab-org/gitlab!78325))
- [Update button text to expand all files](gitlab-org/gitlab@95d919a3ea9b4fbe3dee9b2155417491285ede38) ([merge request](gitlab-org/gitlab!78322))
- [Ignnore Finding Evidence summary column](gitlab-org/gitlab@888bfec3014f5b9fe6df528a25ff22d2c22774a1) ([merge request](gitlab-org/gitlab!78314)) **GitLab Enterprise Edition**
- [Add LFK ci_daily_build_group_report_results to projects](gitlab-org/gitlab@59186e18639f1de38dd299584a1b7a31da4fb72b) ([merge request](gitlab-org/gitlab!78149))
- [Enable by default the feature flag to track Geo proxy events](gitlab-org/gitlab@3254c186c2c148ffd66646c17b7d22a6ec8da652) ([merge request](gitlab-org/gitlab!78301)) **GitLab Enterprise Edition**
- [Update on-demand scans breadcrumbs](gitlab-org/gitlab@b880dcb10a7a24989f9cfe9bb5986ceb20eacad8) ([merge request](gitlab-org/gitlab!78063)) **GitLab Enterprise Edition**
- [Change pipeline page layout to fluid](gitlab-org/gitlab@33bab2ef1a7f96860a3761238492868cb4ce3109) ([merge request](gitlab-org/gitlab!78124))
- [Default to fluid layout for the pipeline editor](gitlab-org/gitlab@b3cad6c69325d466090c742e813f938dddfe6be0) ([merge request](gitlab-org/gitlab!78038))
- [Skip failed builds](gitlab-org/gitlab@ba8a9b5b2b3f51c04f472ee7592be34c2411c742) ([merge request](gitlab-org/gitlab!78218)) **GitLab Enterprise Edition**
- [Redirect to on-demand scan form after editing a DAST profile](gitlab-org/gitlab@d5edfabb6dbbb706801305a09bd4625f5cdff5b3) ([merge request](gitlab-org/gitlab!77819)) **GitLab Enterprise Edition**
- [Conditionally disable group user cap enablement](gitlab-org/gitlab@a746c36cf8ca59483cf885a05984b68d7545621a) ([merge request](gitlab-org/gitlab!76130)) **GitLab Enterprise Edition**
- [Use normalized license data in csv export](gitlab-org/gitlab@c77746663f2777f9fa645d8c0fee4543b34c07a1) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/78266)) **GitLab Enterprise Edition**
- [Enable vue-router in package registry](gitlab-org/gitlab@37277b57975d68b8ac6144ccd7f998a815f05cd8) ([merge request](gitlab-org/gitlab!77762))
- [Replace window.confirm with GlModal for registration token reset](gitlab-org/gitlab@ba77f398a904f3147985e17de2a34b85c4cf97f2) ([merge request](gitlab-org/gitlab!77883))
- [Enable `packages_installable_package_files` by default](gitlab-org/gitlab@a72b417afc0c0a026258b4d04b808ad30e86be0d) ([merge request](gitlab-org/gitlab!78254))
- [Labels widget - focus first item on search](gitlab-org/gitlab@2a3760507fd6874dac0e6b6a286978df649ab916) ([merge request](gitlab-org/gitlab!78246))
- [Increase exclusive lease timeout](gitlab-org/gitlab@45cd1d6f10d4e59ae36317adc687cbb5c4b68760) ([merge request](gitlab-org/gitlab!78240)) **GitLab Enterprise Edition**
- [Add offline, stale count to runner admins section](gitlab-org/gitlab@1351c794534c43fcb14df4d32da98ad4a73c158d) ([merge request](gitlab-org/gitlab!77871))
- [Enable trial onboarding flow for other sources](gitlab-org/gitlab@d95bb41326a8487ed1dceaa06ea7e500353873a4) ([merge request](gitlab-org/gitlab!77992)) **GitLab Enterprise Edition**
- [Add member_namespace_id to members table](gitlab-org/gitlab@4dae8709826eaede354d906370cd91a0fa230911) ([merge request](gitlab-org/gitlab!77592))
- [Convert trial lead creation form to Vue](gitlab-org/gitlab@bcbe2b3ddfb71609295262857d313b8743ea1e48) ([merge request](gitlab-org/gitlab!77537)) **GitLab Enterprise Edition**
- [Update approval settings to toast on success](gitlab-org/gitlab@ad8c805970245dc3c3118a318ff0e23fc19a2a5d) ([merge request](gitlab-org/gitlab!77975)) **GitLab Enterprise Edition**
- [Format total count of runners in tabs by locale](gitlab-org/gitlab@3b516f7d4359f5a4c15f9b9b769ecce7990f85d5) ([merge request](gitlab-org/gitlab!78187))
- [Updated Group/Project home panel ID copy-on-click](gitlab-org/gitlab@55072ccd0870eab2031c4f453b8951b015910faa) by @stingrayza ([merge request](gitlab-org/gitlab!75904))
- [Update MR head pipeline when pipeline event is published](gitlab-org/gitlab@5a8dd34937474f90d39bc4a9a2332fb69ae6b90a) ([merge request](gitlab-org/gitlab!78172))
- [Removes FK for ci_pipeline_schedules to users](gitlab-org/gitlab@abea2e32298f4efcda6fe062d626f9c1e3a1c66a) ([merge request](gitlab-org/gitlab!78163))
- [Removes FK for ci_job_token_project_scope_links to users](gitlab-org/gitlab@3a12e4cd830d5a9c910484377388f7187aa18306) ([merge request](gitlab-org/gitlab!78162))
- [Swap FK ci_build_report_results to projects for LFK](gitlab-org/gitlab@6fbc44b7e47ce8ba2e39da88fdb694ecaf8e992a) ([merge request](gitlab-org/gitlab!78157))
- [Swap FK ci_resource_groups to projects for LFK](gitlab-org/gitlab@fe98ddccf9d5f9fa2cc2cfec5f8132101bf2cf11) ([merge request](gitlab-org/gitlab!78156))
- [Swap FK ci_freeze_periods to projects for LFK](gitlab-org/gitlab@84bac9521da055ef8bc7e66fcab4443cf238a1a8) ([merge request](gitlab-org/gitlab!78155))
- [Add LFK ci_unit_tests to projects on project_id](gitlab-org/gitlab@3e4b59847decb8f8954862c1581e566ece04d9b4) ([merge request](gitlab-org/gitlab!78146))
- [Enable new rich text/source toggle in self-managed](gitlab-org/gitlab@ccac603d81f009b5fae616e9b3298b7d8d0fc6ba) ([merge request](gitlab-org/gitlab!77995))
- [Nullify project_namespace_id reference](gitlab-org/gitlab@9699e82fbb26b6921b01f1eb2e15189f106605da) ([merge request](gitlab-org/gitlab!78046))
- [Geo Nodes Form - Object Storage Beta Badge](gitlab-org/gitlab@578cdcfe5b81f2de7a49131b82a9afd56a1323cd) ([merge request](gitlab-org/gitlab!77989)) **GitLab Enterprise Edition**
- [Update total count of runners for each type](gitlab-org/gitlab@92512ba6c3fdb2f36e49f552e525bdd914098dee) ([merge request](gitlab-org/gitlab!77752))
- [Clean up add GitLab to Slack app](gitlab-org/gitlab@1c86cc581f5d74c87dc79e0891ad7bc172b0c0c9) ([merge request](gitlab-org/gitlab!78094)) **GitLab Enterprise Edition**
- [Fix help text for checkboxes on integrations form](gitlab-org/gitlab@dc0edd94ffa032702dac1669a216b0c41962469e) ([merge request](gitlab-org/gitlab!77885))
- [Encrypt static_object_token_encrypted field via background migration](gitlab-org/gitlab@12f6ada924e737e6d0ecf4f50bf45fc9b7f3fe80) ([merge request](gitlab-org/gitlab!76684))
- [Migrate enable Gitpod confirmation modal to `GlModal`](gitlab-org/gitlab@699354cc7380c6b4346aefaafc8e9b154d5ab198) ([merge request](gitlab-org/gitlab!77716))
- [Allow skipping CI when rebasing in UI](gitlab-org/gitlab@ef01df71974b083fcb773b397253a55c074e710c) by @KevSlashNull ([merge request](gitlab-org/gitlab!76056))
- [Update Nokogiri to v1.12.5](gitlab-org/gitlab@e3c195f6db687cccddf2bd3dcd07b873e853b197) ([merge request](gitlab-org/gitlab!77631))
- [Use badges for branches/tags in commit page](gitlab-org/gitlab@6a13a3aee811edba6c436dc101b6142e7f31dd13) ([merge request](gitlab-org/gitlab!77851))
- [Update DAST On-demand scan template](gitlab-org/gitlab@8f13ed956909aa9528afd1d89145012d052f9a4e) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/73564)) **GitLab Enterprise Edition**
- [Update secret-detection git log command](gitlab-org/gitlab@7c0576b5901f5fef72b5b4ae949534b92871e503) ([merge request](gitlab-org/gitlab!77722))
- [Add validation for new_user_signups_cap enabling](gitlab-org/gitlab@708d3a4891bf5575f3e891e43d860d3d70cc52d3) ([merge request](gitlab-org/gitlab!75906)) **GitLab Enterprise Edition**
- [Update upload a license file docs](gitlab-org/gitlab@2e39fcc0ea0af37d4a397f195b6b0f1a8b99c80a) ([merge request](gitlab-org/gitlab!77311)) **GitLab Enterprise Edition**
- [Reposition and restyle integration reset button](gitlab-org/gitlab@f4a072b67ab4aef9f6a27bc1fb20478cb6fa2ea3) ([merge request](gitlab-org/gitlab!77921))
- [Add merge trains copy to ff merge](gitlab-org/gitlab@e795349c99768f8f6599688e4c4b2897746b8848) ([merge request](gitlab-org/gitlab!77904))
- [Remove carat from dropdown button](gitlab-org/gitlab@41f50cde39f7a9347d96c566a77e26dd838df853) ([merge request](gitlab-org/gitlab!77870))
- [Convert OAuth2 authorization panel to GitLab UI utility classes](gitlab-org/gitlab@7783f443a91240c6fe0fc6bfd1060fc373a286e2) ([merge request](gitlab-org/gitlab!77621))
- [Translate settings string in user preferences](gitlab-org/gitlab@d1928d59b92e33bc992192a286e9ee5fc2ce3d60) ([merge request](gitlab-org/gitlab!77439))
- [Replaced browser confirm modal with GlModal for lock button](gitlab-org/gitlab@46b3429a5afcaba64e1be54c4acd0ea4bc2a5f7e) ([merge request](gitlab-org/gitlab!77690)) **GitLab Enterprise Edition**
- [Enable linear versions in GroupDescendantsFinder](gitlab-org/gitlab@3c7dc938bfe474d55503bdfa0c95ccf4eb78ea4d) ([merge request](gitlab-org/gitlab!75877))
- [Create Deployments in Separate Transaction](gitlab-org/gitlab@b74b75293717263e52ac8da3c77be7a4801996e9) ([merge request](gitlab-org/gitlab!77840))
- [Improve UI text of external authentication](gitlab-org/gitlab@2fb0a9fa6e6a2647910f6110115e80e1a169243b) ([merge request](gitlab-org/gitlab!75822))
- [Update search badges to pajamas](gitlab-org/gitlab@a60ee44463c5bea59847a8ceebc15af74db2cb95) ([merge request](gitlab-org/gitlab!77812))
- [Switch from confirm to default](gitlab-org/gitlab@0d7434f06046bfef8d01f86b7f3526cd2002df5e) ([merge request](gitlab-org/gitlab!77780))
- [Improve UI text of group webhooks page](gitlab-org/gitlab@8272c8ce1bd721a8783137e5efc6595524ac8757) ([merge request](gitlab-org/gitlab!76187))
- [Refactor admin labels to use shared HAML partial](gitlab-org/gitlab@a016abab7d3a95f2bb04db557e0e5e84fd4aa42e) ([merge request](gitlab-org/gitlab!77546))
- [Update flash alerts of Admin Runner UI](gitlab-org/gitlab@c7d1fc6075a38186d3877d5b812c6d8ea8822e21) ([merge request](gitlab-org/gitlab!77669))
- [Sort followed users events by id desc](gitlab-org/gitlab@d67b33e8b2b5f636abaa12ae711bd3ef66523408) ([merge request](gitlab-org/gitlab!77436))
- [GitLab Version - Update Version Status Indicator](gitlab-org/gitlab@e8826a3c4221a9793f88a9a0e817653a037641ca) ([merge request](gitlab-org/gitlab!77521))
- [Prevent raising validation errors for SyncDashboardsWorker](gitlab-org/gitlab@e7f36851f7b02e1c4e67b159b961caef7816a840) ([merge request](gitlab-org/gitlab!77657))
- [Update snippet search badge to use pajamas](gitlab-org/gitlab@b1fd72385f1c416a9109cae62267039c00705e8c) ([merge request](gitlab-org/gitlab!77726))
- [Improve outbound requests settings UI text](gitlab-org/gitlab@8ecdf1de3e9b4428f3836c886db470121998585b) ([merge request](gitlab-org/gitlab!77488))
- [Remove Geo pages verification feature flag](gitlab-org/gitlab@9a76f4e6712e855a491e90fe69e501e34508f9c1) ([merge request](gitlab-org/gitlab!77551)) **GitLab Enterprise Edition**
- [Geo: Verify LFS objects](gitlab-org/gitlab@aa4207006a9b63d2c3731e680551eb886c90df9e) ([merge request](gitlab-org/gitlab!76363)) **GitLab Enterprise Edition**
- [Add support for user_id, group_id and group_path](gitlab-org/gitlab@a2187ab03790d31cf0a92f17ed01ff83c2d1c4af) ([merge request](gitlab-org/gitlab!76595)) **GitLab Enterprise Edition**
- [Remove `log_import_export_relation_creation` feature flag](gitlab-org/gitlab@ad7c30ff1d8054915adf35b164314c36e4e48720) ([merge request](gitlab-org/gitlab!77144))
- [Remove feature flag optimize_merge_request_parser](gitlab-org/gitlab@ff5b66f0dac674acd11070ca4e4501720f16162f) ([merge request](gitlab-org/gitlab!68379))
- [Update look and feel of runner heading](gitlab-org/gitlab@f3cf2fee21f932765556b79fe343c56a49fc6884) ([merge request](gitlab-org/gitlab!77519))
- [Move the Runner edit page to an `/edit` path](gitlab-org/gitlab@0db46eaeb1973543394374737e5f040600989ebb) ([merge request](gitlab-org/gitlab!77514))
- [User linear version UserGroupNotificationSettingsFinder#execute](gitlab-org/gitlab@9d4a65977f91211ba6ac52a0706dbff39eb929d7) ([merge request](gitlab-org/gitlab!75645))
- [Refactored sidebar jobs details container badge](gitlab-org/gitlab@14fcb9fe7ce2773bfb25caeb42b657475cbbedf1) ([merge request](gitlab-org/gitlab!77675))
- [Remove deployments_archive feature flag](gitlab-org/gitlab@616cfcc6e78979b43540c74019c1ae2906b207c5) ([merge request](gitlab-org/gitlab!77490))
- [Update Coverage-Fuzzing yml and use last package file in corpus](gitlab-org/gitlab@0bb3bcc59c61aedc459e8a81c8ebbbfcf3b928da) ([merge request](gitlab-org/gitlab!77228)) **GitLab Enterprise Edition**
- [Make strings in user preferences translatable](gitlab-org/gitlab@df4151982ee381efa303a1f6a514069d0ea39f42) ([merge request](gitlab-org/gitlab!77483))
- [Deprecate plaintext field static_objects_external_storage_auth_token](gitlab-org/gitlab@733e5ddd605435b7cbe10449f1e58c8ac3b04988) ([merge request](gitlab-org/gitlab!77579))
- [Add createAlert as alternative to createFlash](gitlab-org/gitlab@a205f845c65ef8728b7489b320c3ce656de7f5de) ([merge request](gitlab-org/gitlab!76136))
- [Increase icon size for categories in emoji picker](gitlab-org/gitlab@f075efeacac0720f13528a1cd740e5c5105016b3) ([merge request](gitlab-org/gitlab!77577))
- [Update acts-as-taggable-on gem version](gitlab-org/gitlab@c84e36fedbb4ecdb2834810eb15c07584f0b68bc) ([merge request](gitlab-org/gitlab!77565))
- [Refactored Badges on environment items](gitlab-org/gitlab@055cd12f11c10dfb0e502faf9ed0adc836a05b21) ([merge request](gitlab-org/gitlab!77113))
- [Update nuget version regex](gitlab-org/gitlab@d1f2e41a4d4e23e7a2f4391725a8347740d2dd19) ([merge request](gitlab-org/gitlab!77543))
- [Remove commit templates variable placeholders from settings](gitlab-org/gitlab@940da33d70644349f97219087fe1fa18b5c3fe5e) by @trakos ([merge request](gitlab-org/gitlab!77350))
- [Externalize strings for translation on dashboard](gitlab-org/gitlab@006ae2d6172f3c10e3764db9f8c55d2ef6b2640b) ([merge request](gitlab-org/gitlab!77432))
- [Make strings in top nav translatable](gitlab-org/gitlab@03c5a413485f24c6014427b2de8b654728566ecc) ([merge request](gitlab-org/gitlab!77475)) **GitLab Enterprise Edition**
- [Fail remote mirror if LFS sync fails](gitlab-org/gitlab@10c8a8ba9c1fd1bb731e27afa1006bc8c31f6bd4) ([merge request](gitlab-org/gitlab!77339))
- [Update Azure storage Gem dependencies](gitlab-org/gitlab@2741aefc230f467e0574682333cb07a9b3df7e80) ([merge request](gitlab-org/gitlab!77472))
- [Add Pajamas-complient badge for runners](gitlab-org/gitlab@f8e41cd2351fe2f64099bf8762d02f0281ee630a) ([merge request](gitlab-org/gitlab!77399))
- [Translate labels in user main settings](gitlab-org/gitlab@9cb8eb9e01c9f3b64eb3c41e7069096dda558d0e) ([merge request](gitlab-org/gitlab!77450))
- [Allow hidden pacakge files to be downloaded](gitlab-org/gitlab@e6eecff1491a3817451fd481f4e79a6852beda53) ([merge request](gitlab-org/gitlab!77291))
- [Externalize strings for translation user's chat settings](gitlab-org/gitlab@c9d0b0c87a4cd56a420d73e3d2778662e80109f4) ([merge request](gitlab-org/gitlab!77433))
- [Use "never contacted" wording in runner's frontend](gitlab-org/gitlab@2048b5e101b868c8c27db07221feaf6878247010) ([merge request](gitlab-org/gitlab!77375))
- [Rename routes for project services](gitlab-org/gitlab@523c3082b4186f1f2ca63bad9e5573a9f3137eb2) ([merge request](gitlab-org/gitlab!77376))
- [Update button variant and category](gitlab-org/gitlab@9d6c6562651cab2129c3a815d22b4ef37b66e340) ([merge request](gitlab-org/gitlab!77313))
- [Alter phone constraint bigger](gitlab-org/gitlab@74d33307a6b254d889f5dcbd67c583b665d41a0f) by @memorycancel ([merge request](gitlab-org/gitlab!76516))
- [Set feature flag lfs_auto_link_fork_source to true by default](gitlab-org/gitlab@0b5407ccc9a198b1e779850d4c4951a7b63afb70) ([merge request](gitlab-org/gitlab!77341))
- [Registration Flow - Don't pre-select role](gitlab-org/gitlab@81fea3beaae533a27a041850b691c06b900697ac) by @tarunvelli ([merge request](gitlab-org/gitlab!76051))
- [Remove find_tag_via_gitaly feature flag](gitlab-org/gitlab@cf9515de7a31631b18cfef1580bba90e2f1abdcb) ([merge request](gitlab-org/gitlab!77303))
- [Adjusts Member awaiting scope to be distinct](gitlab-org/gitlab@0f117a67c9c59afef603db58e0a186a815e08dfc) ([merge request](gitlab-org/gitlab!76864)) **GitLab Enterprise Edition**
- [Add fail flag to pipeline trigger examples](gitlab-org/gitlab@666c22848f6ff042d5fde38b6649ca2c81f5eb6e) ([merge request](gitlab-org/gitlab!77095))
- [Release Geo: Treat missing blobs as sync failed](gitlab-org/gitlab@1ee0241c957ec82ce10616f69e916833514da2ff) ([merge request](gitlab-org/gitlab!77274)) **GitLab Enterprise Edition**
- [Delete events in batches when project is destroyed](gitlab-org/gitlab@7d633be80765ddd75436dd94663c01f2da27b728) ([merge request](gitlab-org/gitlab!77031))
- [Add limitation warning for permission export](gitlab-org/gitlab@079fe3bbe45129c149d3981b752ea2ebde273e91) ([merge request](gitlab-org/gitlab!77121)) **GitLab Enterprise Edition**
- [Change texts about credit card verification](gitlab-org/gitlab@cc868d4accbb5f44259c66a463b0bb23ff9148c4) ([merge request](gitlab-org/gitlab!77111)) **GitLab Enterprise Edition**
- [Treat API requests from the frontend as web traffic in the rate limiter](gitlab-org/gitlab@7b54a4b5184003f85919921c2aa8a7ba3848c989) ([merge request](gitlab-org/gitlab!76965))
- [Restyle "hints" on appearance settings](gitlab-org/gitlab@c17e794bd8d2cb427bb04d775afb9b1acaef1454) by @KevSlashNull ([merge request](gitlab-org/gitlab!75871))
- [Do not show participants invisible to the user](gitlab-org/gitlab@d07f416fbeb5f924a41c064138512da035f1905f) ([merge request](gitlab-org/gitlab!77021))
- [Use connects_to to connect to the Geo tracking DB](gitlab-org/gitlab@235cfc0308426acfc22e5ad29fd29d91c4c54d08) ([merge request](gitlab-org/gitlab!76700)) **GitLab Enterprise Edition**
- [Add CI_JOB_JWT_V2 with iss and aud format changes](gitlab-org/gitlab@25081011347036615ae981314f6cfcb252f4e671) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/72555))
- [Migrate the visibility change confirmation to vue](gitlab-org/gitlab@db85f7235a474ee1bb48ba194f15aae274b6e90d) ([merge request](gitlab-org/gitlab!76417))
- [Drop jira_use_first_ref_by_oid feature flag](gitlab-org/gitlab@ce5c275e4ccc00ce67b8c885d504aa220335059e) ([merge request](gitlab-org/gitlab!76611))
- [Update button variant to confirm](gitlab-org/gitlab@2d80d85cbfaa8a80145a992c933c25866a3b7c86) ([merge request](gitlab-org/gitlab!77022))
- [Remove OAuth paths from protected paths rate limit](gitlab-org/gitlab@cf35d50245622626d178ab21fe1b429bc85cb729) ([merge request](gitlab-org/gitlab!76882))
- [Add vulnerability_states for scan_result_policies](gitlab-org/gitlab@a7e8caeb92aea8508503bdd90eb08fcc1e74271b) ([merge request](gitlab-org/gitlab!76865)) **GitLab Enterprise Edition**
- [Add toggle method to control use_minimum_char_limit](gitlab-org/gitlab@a4d04c0b2d3786cd0ba3e158cadc4bdbd547aa57) by @orozot ([merge request](gitlab-org/gitlab!76835))

### Removed (13 changes)

- [Remove feedback link in discover security point](gitlab-org/gitlab@e721427a2c56d337ec8899741ba6f146ec055379) ([merge request](gitlab-org/gitlab!78313)) **GitLab Enterprise Edition**
- [Revert "Merge branch 'rajat/work-hierarchy' into 'master'"](gitlab-org/gitlab@025fa4da03ea514fa83feb5a8b5b0dff98bc1a48) ([merge request](gitlab-org/gitlab!78395))
- [Remove cached_mr_widget feature flag](gitlab-org/gitlab@38c4ca9b293730ab4e9015f371234aee2422e654) ([merge request](gitlab-org/gitlab!78355))
- [Remove automatic addition of incident label](gitlab-org/gitlab@d4a57b8fc3b879a02760b7be4780f23ee9a26ee7) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/78258))
- [Delete paginatable_namespace_drop_down_for_project_creation FF](gitlab-org/gitlab@a20daa48a9b8331264b21571ff4bd709efa5b1a7) ([merge request](gitlab-org/gitlab!72240))
- [Remove redis MultiStore implementation](gitlab-org/gitlab@c66fb99d1e09f3b061c5d8a678a17f772376f4ef) ([merge request](gitlab-org/gitlab!78049))
- [Remove "Saved scans" tab from DAST configuration](gitlab-org/gitlab@011bf15a10f914ab9f57eff5d5cf513c2e928b74) ([merge request](gitlab-org/gitlab!77288)) **GitLab Enterprise Edition**
- [Remove EXMOD experiment documentation](gitlab-org/gitlab@f355b4d84cc9e3beb6ea28c1046c50c36b3ac766) ([merge request](gitlab-org/gitlab!78091))
- [Remove delete_branch_confirmation_modals feature flag](gitlab-org/gitlab@336301f70b9f2af71ed73bdfe101b83747f08fd7) ([merge request](gitlab-org/gitlab!77231))
- [Remove problematic query from obselete open environment in diff feature](gitlab-org/gitlab@90f07756725877199ef1661fdabad84b8acd0d4d) ([merge request](gitlab-org/gitlab!77963))
- [Remove LooseIndexScanDistinctCount class](gitlab-org/gitlab@e105810c007104bc48edb5c88a9544115a7319a0) ([merge request](gitlab-org/gitlab!77746))
- [Delete vue_issuables_list feature flag](gitlab-org/gitlab@3abadcad5791b8b40a9db9905a4275b9fee4e144) ([merge request](gitlab-org/gitlab!77051))
- [Remove vulnerability_location_image_filter feature flag](gitlab-org/gitlab@a9a8fde623c5936f667c5fed890394478a4cf3b9) ([merge request](gitlab-org/gitlab!76298))

### Security (4 changes)

- [Upgrade mermaid js library](gitlab-org/gitlab@7ad21d909cea9e2ec1dec848c2c395aee745db8b) ([merge request](gitlab-org/gitlab!78176))
- [Rate limit /users/sign_up](gitlab-org/gitlab@9c15124fdb59b50fd210837d803dba3ed1723284) ([merge request](gitlab-org/gitlab!77835))
- [Rate limit update username action](gitlab-org/gitlab@5e4cc7ebac15542c14fa82ba408d21d75345d774) ([merge request](gitlab-org/gitlab!77221))
- [Enforce rate limit per IP on /users/:username/exists](gitlab-org/gitlab@5e9c4d189b90caec408c3649b84d2787c8931cfa) ([merge request](gitlab-org/gitlab!77119))

### Performance (12 changes)

- [Avoid extra Sidekiq jobs for expiring CI etags](gitlab-org/gitlab@dc29dc66328fc6609c134d6569f8a6c0c74c9309) ([merge request](gitlab-org/gitlab!78468))
- [Optimize query for issue neighbors](gitlab-org/gitlab@1833947a07026c195175ab4056336e4b6b480a30) ([merge request](gitlab-org/gitlab!78443))
- [Improve on-demand scans polling performances](gitlab-org/gitlab@186f44f9760b0c5760c7ddd27bb34f4f1789006c) ([merge request](gitlab-org/gitlab!78375)) **GitLab Enterprise Edition**
- [Remove ci_decompose_belonging_to_parent_group feature flag](gitlab-org/gitlab@c6926279b2e790d32146cf66b19a770fe443acd0) ([merge request](gitlab-org/gitlab!77944))
- [Optimize protected branches/tags matching](gitlab-org/gitlab@d95f91c344faacb36aad43adae2412c038d48280) ([merge request](gitlab-org/gitlab!77988))
- [Add index for resolving timeouts on environments page](gitlab-org/gitlab@171f3decb6f2e52739d2de9a0a868f62b715e2db) ([merge request](gitlab-org/gitlab!75767))
- [Inline diff line rendering](gitlab-org/gitlab@839bc405f542ea98d16a6a0b3bc9cb4566b08906) ([merge request](gitlab-org/gitlab!57237))
- [Utilize C version of CommonMark renderer](gitlab-org/gitlab@cc2380771b8c314bf325a2fe7212a02ef9675e37) ([merge request](gitlab-org/gitlab!75800))
- [Improve epic swimlanes query performance for group board](gitlab-org/gitlab@42de05b81420534abd05ce531436e08f9d906b53) ([merge request](gitlab-org/gitlab!75378)) **GitLab Enterprise Edition**
- [Fix slow events query for followed users](gitlab-org/gitlab@17b71e6ce339424ac6f5658da345b7b3e307b7e6) ([merge request](gitlab-org/gitlab!77028))
- [Read running builds from denormalized table upon assignment](gitlab-org/gitlab@7f669ae8570cc373581464861d764b0334c3a1c4) ([merge request](gitlab-org/gitlab!77104))
- [Introduce an optimized labels query on group transfer](gitlab-org/gitlab@7cdf20af2a29ab118663ce32dbb59794e93c12a4) ([merge request](gitlab-org/gitlab!77034))

### Other (68 changes)

- [Geo: Verify uploads](gitlab-org/gitlab@ddf052cf83d329149f359cd690447bbeccd95de0) ([merge request](gitlab-org/gitlab!78068)) **GitLab Enterprise Edition**
- [Add columns in prep of registry import](gitlab-org/gitlab@8d2ee3c7055dd089760d9fd8ffb1e6a0b7da130d) ([merge request](gitlab-org/gitlab!77725))
- [Remove ci_running_builds FK to projects](gitlab-org/gitlab@5e0a4b2309ba8d6d94533e8d52cc976152007cfb) ([merge request](gitlab-org/gitlab!78027))
- [Remove `scim_token_vue` feature flag](gitlab-org/gitlab@a99950d4a544ec74a67aaa44e3667d83920318da) ([merge request](gitlab-org/gitlab!78220))
- [Remove FK security_scans.build_id as we have LFK](gitlab-org/gitlab@fc438951bc97aca0e818730e51f83b730f3f2796) ([merge request](gitlab-org/gitlab!77919))
- [Add backfill migrations for ci namespace/project mirrors](gitlab-org/gitlab@10412e26ab4772f0a70975e3509eecad18d1ea01) ([merge request](gitlab-org/gitlab!76327))
- [Add package file cleanup jobs](gitlab-org/gitlab@d039bfa25a695d87a9486a5c56b190d42ecac65a) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/77212))
- [Remove ci_store_trace_outside_transaction feature flag](gitlab-org/gitlab@2efe1c3552b13e55e4ed6aacc75f50f87b4830cd) ([merge request](gitlab-org/gitlab!78465))
- [Fix Rails/SaveBang offenses](gitlab-org/gitlab@67db38fc01aeefe8ebce455c223d0292bd5d2ce4) by @edith007 ([merge request](gitlab-org/gitlab!75940)) **GitLab Enterprise Edition**
- [Remove FK dast_scanner_profiles_builds.ci_build_id as we have LFK](gitlab-org/gitlab@ac5eacabbdb89c6311df7763a07ae78a0067d8f4) ([merge request](gitlab-org/gitlab!77910))
- [Remove FK requirements_management_test_reports.build_id as we have LFK](gitlab-org/gitlab@aa91697c133b208b48b95e7df1d3f7bea2800018) ([merge request](gitlab-org/gitlab!77912))
- [Remove FK dast_site_profiles_builds.ci_build_id as we have LFK](gitlab-org/gitlab@89d4d45ea795febdbe6d49f0e6fcf107ab598f14) ([merge request](gitlab-org/gitlab!77916))
- [Fix GraphQL/FieldDefinitions offense (Part 3/4)](gitlab-org/gitlab@e3939b1b2814393988c642cc22d4ac01fba00df0) by @KevSlashNull ([merge request](gitlab-org/gitlab!76016))
- [Fix GraphQL/ArgumentName offense](gitlab-org/gitlab@10601fb5bf124aa47aa89119428b3655fa22f9e6) by @KevSlashNull ([merge request](gitlab-org/gitlab!76013))
- [Fix Rails/SaveBang offenses](gitlab-org/gitlab@2f817b54d9bb7a793c0e187b7541314a885bb44f) by @edith007 ([merge request](gitlab-org/gitlab!75988))
- [Fix Rails/SaveBang offenses](gitlab-org/gitlab@8c1b0a556c085cdd178dbbd150d04648c87092d9) by @edith007 ([merge request](gitlab-org/gitlab!75970)) **GitLab Enterprise Edition**
- [Fix Gitlab/DelegatePredicateMethods offenses](gitlab-org/gitlab@2a2bc7c5e700bf0531753ae3e58eb847d95d3dcc) by @edith007 ([merge request](gitlab-org/gitlab!76010))
- [Remove alllow database cross join from runner_matchers](gitlab-org/gitlab@7f4df5cc89b944c2227128cb88df063a078a629d) ([merge request](gitlab-org/gitlab!78084))
- [Remove opt_in_sidekiq_status feature flag](gitlab-org/gitlab@73166fc00e91a7c02ce77920b5f0685cd84f03d1) ([merge request](gitlab-org/gitlab!78279))
- [chore: Mark previous Recalculation background migrations as succeeded](gitlab-org/gitlab@4d50836b166c3e61879b44606820aa558667a6d6) ([merge request](gitlab-org/gitlab!77052))
- [Limit subscription page container to 990px](gitlab-org/gitlab@ffd11f2cb270a8a578b86ad7f5403c90fc5a56be) ([merge request](gitlab-org/gitlab!77947)) **GitLab Enterprise Edition**
- [Improve SSH key format validation](gitlab-org/gitlab@053b079d82c58a185afc4010440c78c64024944a) ([merge request](gitlab-org/gitlab!77996))
- [Remove `admin_deploy_keys_vue` feature flag](gitlab-org/gitlab@18f44e6f41b198e5986b0eee0e29c2b3806f111d) ([merge request](gitlab-org/gitlab!78144))
- [Remove `hide_access_tokens` feature flag](gitlab-org/gitlab@74f72fde3fa8b5c9298adc67ca149b5637519d32) ([merge request](gitlab-org/gitlab!78148))
- [Remove show.html.erb as Rails 5 now supports nonce-based CSP headers](gitlab-org/gitlab@dd23e8540b8a3e3ae3b5e93480422426c87ca039) by @edith007 ([merge request](gitlab-org/gitlab!75998))
- [Fix Rails/SaveBang offenses](gitlab-org/gitlab@9ee72296a506b389593abc5d0f5182a3e2a21f6a) by @edith007 ([merge request](gitlab-org/gitlab!75976))
- [Remove ci_pending_builds FK to projects](gitlab-org/gitlab@671e495b24f812df2f36b59ec1be592023aae85e) ([merge request](gitlab-org/gitlab!78010))
- [Truncate ci_namespace_mirrors and ci_project_mirrors](gitlab-org/gitlab@63143a7853b61a155d90d5ff3f3e033cedaf5b71) ([merge request](gitlab-org/gitlab!77953))
- [Remove feature flag multiple_gpg_signatures](gitlab-org/gitlab@e6f08a7853161ef2c3597bfa151ef7816f0dbf04) ([merge request](gitlab-org/gitlab!78112))
- [Backfill TestReports issue_id column](gitlab-org/gitlab@d1045bff47b7a231a5fc79990be5c3869f19457c) ([merge request](gitlab-org/gitlab!77770))
- [Fix Style/OpenStructUse offenses for users and package specs](gitlab-org/gitlab@a61455cd231d54ddee54cb6ebbd63ff5e1550df4) by @edith007 ([merge request](gitlab-org/gitlab!75240))
- [Fix Style/OpenStructUse offense for Gitlab::Database::Migrations::Runner](gitlab-org/gitlab@895a968955624e3f80d65523b7f9428a34e54791) by @edith007 ([merge request](gitlab-org/gitlab!75323))
- [Fix Style/OpenStructUse offenses](gitlab-org/gitlab@85f034ff82119df755959ff71edbe32454411fba) by @edith007 ([merge request](gitlab-org/gitlab!75289))
- [Pass formats explicitly when rendering .html file](gitlab-org/gitlab@9ab0a173f11a09248a65692f586e82fa5841b063) by @edith007 ([merge request](gitlab-org/gitlab!75775)) **GitLab Enterprise Edition**
- [Fix Rails/SaveBang offenses](gitlab-org/gitlab@11dd30f1eba382d96a84aa0985f812a175f290de) by @edith007 ([merge request](gitlab-org/gitlab!75969)) **GitLab Enterprise Edition**
- [Pass formats explicitly when rendering kerberos error](gitlab-org/gitlab@bcbf3501ece285a6fef2a5be057e27b69c522cfe) by @edith007 ([merge request](gitlab-org/gitlab!76011)) **GitLab Enterprise Edition**
- [Fix Style/OpenStructUse offenses in gitlab_controller_spec](gitlab-org/gitlab@e20818ecb8485a22e0e6d2341c79564bbca654aa) by @edith007 ([merge request](gitlab-org/gitlab!75194))
- [Pass formats explicitly when rendering .md file](gitlab-org/gitlab@d0a56f252c025fa25ac706387ef5a6094e3a267d) by @edith007 ([merge request](gitlab-org/gitlab!75779)) **GitLab Enterprise Edition**
- [Adjust license upload page style](gitlab-org/gitlab@a224cdf8d9c3a8252f1853b3fd6a3365d49ae163) ([merge request](gitlab-org/gitlab!77670)) **GitLab Enterprise Edition**
- [Pass formats explicitly when rendering html](gitlab-org/gitlab@29f03fb2ba7dd9590b95b3b457160ca81b50fe5a) by @edith007 ([merge request](gitlab-org/gitlab!75772))
- [Remove index_merge_requests_on_title index from merge_requests table](gitlab-org/gitlab@ffa845bf5d480a528a7183beeb4bf536465cf9a3) by @edith007 ([merge request](gitlab-org/gitlab!75823))
- [Improve 'Add an SSH key' page](gitlab-org/gitlab@2a2596f2d7ea8e2afa151da430c2061193bd31e3) ([merge request](gitlab-org/gitlab!77403))
- [Fix Rails/SaveBang offenses](gitlab-org/gitlab@de123aba96869395eb4878d00947fcb35f27306a) by @edith007 ([merge request](gitlab-org/gitlab!75929)) **GitLab Enterprise Edition**
- [Remove "show_relevant_approval_rule_approvers" feature flag](gitlab-org/gitlab@afcfaa8cef0c35ba907fd54c6c4188b621fa3f0d) ([merge request](gitlab-org/gitlab!77227))
- [Cleanup pipeline logger feature flags](gitlab-org/gitlab@ec525e62a32e70c12b7e773c072fd645f2f8975f) ([merge request](gitlab-org/gitlab!77973))
- [Remove the dast_view_scans feature flag](gitlab-org/gitlab@0d05f8de936646d95d4d5fa4c60a24014701e57e) ([merge request](gitlab-org/gitlab!77672)) **GitLab Enterprise Edition**
- [Refactor all the specs to use `:integration` rather than `:service`](gitlab-org/gitlab@2930cf7c19308df5524b2bb431e02827a77cf73e) by @edith007 ([merge request](gitlab-org/gitlab!75997))
- [Fix Gitlab/DelegatePredicateMethods offenses](gitlab-org/gitlab@223ebf2c17861e2c4adbee2b00ffb2b36b45277a) by @edith007 ([merge request](gitlab-org/gitlab!76007)) **GitLab Enterprise Edition**
- [Remove foreign key constraint ci_runner_namespaces.namespace_id](gitlab-org/gitlab@2bed6a32c702a787ef4521c449255d47145b94af) ([merge request](gitlab-org/gitlab!77727))
- [Remove foreign key ci_daily_build_group_report_results.group_id](gitlab-org/gitlab@d801789b2ebb064386366bd3673124899af3b5ba) ([merge request](gitlab-org/gitlab!77721))
- [Deprecate agent token deletion mutation](gitlab-org/gitlab@fd65575598150ac1a23da513d7ab3aaadc2cc2d2) ([merge request](gitlab-org/gitlab!77837))
- [Use an enum for agent token statuses](gitlab-org/gitlab@2f6db027701195d978bd8238bb55d3e3b60c96a8) ([merge request](gitlab-org/gitlab!77735))
- [Remove foreign key ci_pending_builds.namespace_id](gitlab-org/gitlab@668cc33add3476588f83d12e959fd293f9432709) ([merge request](gitlab-org/gitlab!77724))
- [Pass formats explicitly when rendering .md file](gitlab-org/gitlab@7b068a4d88bfa440e3eeafa811bd7da81e5397b8) by @edith007 ([merge request](gitlab-org/gitlab!75778)) **GitLab Enterprise Edition**
- [Raise custom errors when backup creation fails](gitlab-org/gitlab@5689d89da7ceeff03b75db174f898aca9df7fe0c) ([merge request](gitlab-org/gitlab!76754))
- [Pass formats explicitly when rendering .md file](gitlab-org/gitlab@7360983df1c4bd9ce5ea4c0198db7675f0c786e8) by @edith007 ([merge request](gitlab-org/gitlab!75777)) **GitLab Enterprise Edition**
- [Use design system badges for project domains](gitlab-org/gitlab@62e5e7b6b7814d131337f24488bd059a9935c292) ([merge request](gitlab-org/gitlab!77613))
- [Add package file status attribute](gitlab-org/gitlab@e7420d284fafa321cfe3d81d12cadd028f312019) ([merge request](gitlab-org/gitlab!76767))
- [Remove foreign key ci_minutes_additional_packs.namespace_id](gitlab-org/gitlab@aff84c0895e16483554a5aaa19dbc5bd459c2d7a) ([merge request](gitlab-org/gitlab!77550))
- [Remove foreign key ci_group_variables.group_id as we have loose fK](gitlab-org/gitlab@ed2adc84f919c11193be49b2040892a087973e93) ([merge request](gitlab-org/gitlab!77494))
- [Remove feature flag `ff_limit_ssh_key_lifetime`](gitlab-org/gitlab@23e9f7c0bd53915b92f82e735f6463956478cf77) ([merge request](gitlab-org/gitlab!77568))
- [Cleanup after DropInvalidSecurityFindings migration](gitlab-org/gitlab@f8059937c176a19c9795dcbf324098f0f800c5a3) ([merge request](gitlab-org/gitlab!75134))
- [Remove foreign key project_pages_metadata.ci_job_artifacts](gitlab-org/gitlab@d2c9fe10b1ce996c5aef14123668b29b32098d5a) ([merge request](gitlab-org/gitlab!76996))
- [Update GitLab Runner Helm Chart to 0.36.0](gitlab-org/gitlab@bff5d0848213999f67c87ce228db0f93a3820290) ([merge request](gitlab-org/gitlab!77082))
- [Fix GraphQL/OrderedArguments offense (Part 3/6)](gitlab-org/gitlab@55c5417e1e56f83a87660852cab73174382e94be) by @KevSlashNull ([merge request](gitlab-org/gitlab!76025))
- [Pass formats explicitly when rendering .html format](gitlab-org/gitlab@2e8f39197824f4e3203a17f4dc64eb7a0164f8f4) by @edith007 ([merge request](gitlab-org/gitlab!75782))
- [Fix Gitlab/DelegatePredicateMethods offenses](gitlab-org/gitlab@518700a11025b0000ff3ce011638417a882612b0) by @edith007 ([merge request](gitlab-org/gitlab!76001))
- [Fix Rails/SaveBang offenses](gitlab-org/gitlab@513b0e1dbdf95ea595e7548ff26929e0be30ce29) by @edith007 ([merge request](gitlab-org/gitlab!75894)) **GitLab Enterprise Edition**

## 14.6.7 (2022-03-31)

### Changed (1 change)

- [Remove runners token prefix feature flags](gitlab-org/gitlab@70330bc3f8c34c4620d7e5c4a9943ec3574e5ee6) ([merge request](gitlab-org/gitlab!82122))

## 14.6.6 (2022-03-01)

### Fixed (3 changes)

- [Ensure cleanup job artifacts task does not include pipeline artifacts](gitlab-org/gitlab@3fc3472de8bfa971985d122573e9896b17606678) ([merge request](gitlab-org/gitlab!81885))
- [Fix Geo checksummable check failing when file is nil](gitlab-org/gitlab@38b55f334c558377de0b1b0d7f853e62723d9791) ([merge request](gitlab-org/gitlab!81885)) **GitLab Enterprise Edition**
- [Resolve "Imports fail in 14.5.2 fail with HTTParty::UnsupportedURIScheme error"](gitlab-org/gitlab@b7cbf0c19d9702a0db3ee9a8f8897df5d7da72f1) ([merge request](gitlab-org/gitlab!81885))

## 14.6.5 (2022-02-25)

### Security (8 changes)

- [Limit commands_changes to certain keys](gitlab-org/security/gitlab@138c437f2819d62ce4750fb84399d8868c844b01) ([merge request](gitlab-org/security/gitlab!2227))
- [Add runners_token prefix to Group and Project](gitlab-org/security/gitlab@682d4e9b63d3d36901638edc75c1b265460d42dc) ([merge request](gitlab-org/security/gitlab!2250))
- [Anonymous user can enumerate all users through GraphQL endpoint](gitlab-org/security/gitlab@2b00a8036b291d3ad5de551a5e13c2a0a39d0234) ([merge request](gitlab-org/security/gitlab!2102))
- [Check for unsafe characters in email addresses before sending](gitlab-org/security/gitlab@6bc653b3dadefb3d2c80823786d43e6b7f8c4620) ([merge request](gitlab-org/security/gitlab!2208))
- [Warn when snippet contains unretrievable files](gitlab-org/security/gitlab@f9ae9515ec98ab934f4aa3a35af0aca806bbe21d) ([merge request](gitlab-org/security/gitlab!2203))
- [Prevent DOS when rendering math markdown](gitlab-org/security/gitlab@fd6d496df6f4b5eb3da0b851f9ff8ebb1d68d3f2) ([merge request](gitlab-org/security/gitlab!2201))
- [Check permission when creating members through service](gitlab-org/security/gitlab@948e5103285de2a6cdb5152ff2c13ae4db2f4cda) ([merge request](gitlab-org/security/gitlab!2211))
- [Reset password field on page load](gitlab-org/security/gitlab@1417b463f2771a4b17e068dea9de3aa6c4540962) ([merge request](gitlab-org/security/gitlab!2194))

## 14.6.4 (2022-02-03)

### Security

See https://about.gitlab.com/releases/2022/02/03/security-release-gitlab-14-7-1-released/

## 14.6.3 (2022-01-18)

### Fixed (4 changes)

- [Fix destruction of projects with pipelines](gitlab-org/gitlab@83e1616fe46b933c5b78b2d43e08463fdae4264a) ([merge request](gitlab-org/gitlab!78401))
- [Geo: Resolve "undefined method each_batch"](gitlab-org/gitlab@a38bf23ebd0a9931ec5bb91377955824dcda39ea) ([merge request](gitlab-org/gitlab!78401)) **GitLab Enterprise Edition**
- [Fix migration for cases with empty strings](gitlab-org/gitlab@ddda8880db35b7d48ca8e4ec8efe54954d64f41f) ([merge request](gitlab-org/gitlab!78401))
- [Geo: adapt verification timed out query to use state table](gitlab-org/gitlab@89212752226d6c5f34830e3f4a73c5a56764ed17) ([merge request](gitlab-org/gitlab!78401)) **GitLab Enterprise Edition**

## 14.6.2 (2022-01-10)

No changes.

## 14.6.1 (2022-01-04)

### Fixed (2 changes)

- [Ignore new line differences when deciding whether to squash MR](gitlab-org/gitlab@9d25380756bbc11ad5d18ea268b0ed0b60bf92fb) ([merge request](gitlab-org/gitlab!77499))
- [Fix re-use of extensions between instances](gitlab-org/gitlab@0ad3357123bbb72493b965b0ab769dab81890397) ([merge request](gitlab-org/gitlab!77499))

## 14.6.0 (2021-12-21)

### Added (76 changes)

- [Create table to store merge request compliance violations](gitlab-org/gitlab@6020f42812e3dc09d4163488e35d9a75f20da9ff) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/74290))
- [Upgrade GitLab Pages to 1.49.0](gitlab-org/gitlab@b10f47f58cc3c7998e6815580405d00575595715) ([merge request](gitlab-org/gitlab!76908))
- [Add create crm organization component](gitlab-org/gitlab@20998c7f182a6f12001ac10b515fc8c20147b56a) by @leetickett ([merge request](gitlab-org/gitlab!76059))
- [Registration features info for setting repo size](gitlab-org/gitlab@d857bc88bfe2dff493b73934c39ac89c25a4381a) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/73222)) **GitLab Enterprise Edition**
- [Log structured message when LFS object is auto-linked from parent](gitlab-org/gitlab@fe545efa9f3c138a1f65bed0f021525b8cb3fc22) ([merge request](gitlab-org/gitlab!76818))
- [Enable display_outdated_line_diff by default](gitlab-org/gitlab@3f368ddb4378101757f7a3ce7a92d0d36bcf7823) ([merge request](gitlab-org/gitlab!76887))
- [Default enable webauthn feature flag](gitlab-org/gitlab@81a6ee387a3f4b593859c04d52245312b9b194ba) by @kingjan1999 ([merge request](gitlab-org/gitlab!50735))
- [Update return type for previousStageJobsOrNeeds](gitlab-org/gitlab@ca6c6a70b0e054b24cd331b0ce6bedb383a86dff) ([merge request](gitlab-org/gitlab!76444))
- [Add support for Rel-License microformat](gitlab-org/gitlab@dd445481700a90c9e9fd645c2315e94b22df4889) ([merge request](gitlab-org/gitlab!76471))
- [Add error alerts and badge for webhooks](gitlab-org/gitlab@d366378ce6612db8316a07e60eb139d4e7eb39da) ([merge request](gitlab-org/gitlab!76871))
- [Add alert for rate limited webhooks](gitlab-org/gitlab@d163f4c929d696884438cb139329cdb3bae75803) ([merge request](gitlab-org/gitlab!76743))
- [Expose iid in pipelines api](gitlab-org/gitlab@a7f53bddf1cfc64d471b13312dd01c42015799c4) ([merge request](gitlab-org/gitlab!76625))
- [Implement separate status for bulk imports](gitlab-org/gitlab@96db744c439129de268cf05f4e7e5b41597ff751) ([merge request](gitlab-org/gitlab!73960))
- [Include parent_iid and parent link in epic responses](gitlab-org/gitlab@16c439adab336b115f9cfa532e5ff4e640a21ddc) by @espadav8 ([merge request](gitlab-org/gitlab!76443)) **GitLab Enterprise Edition**
- [Add `ClusterImageScanningType` to `VulnerabilitiesResolver`](gitlab-org/gitlab@38d8bf4f680a8a5f8f391e162ef3cfa41578ebec) ([merge request](gitlab-org/gitlab!75797)) **GitLab Enterprise Edition**
- [Add ability to retry scans from on-demand scans list](gitlab-org/gitlab@d703847ed921e394ee655afd851b4b36ccd41e61) ([merge request](gitlab-org/gitlab!76448)) **GitLab Enterprise Edition**
- [Add ability to cancel on-demand scans](gitlab-org/gitlab@a77440d405caa34a9e8a6d9661ae32d31124aa99) ([merge request](gitlab-org/gitlab!76448)) **GitLab Enterprise Edition**
- [Add Geo proxied/local events service ping](gitlab-org/gitlab@b500b2cf65ec30ec832dd68259e2d979fb75fe01) ([merge request](gitlab-org/gitlab!76389)) **GitLab Enterprise Edition**
- [Allow use of `when` and `rules`](gitlab-org/gitlab@035e3d34a78b4675ae17e2e64969fa3bdd4a724b) ([merge request](gitlab-org/gitlab!76158))
- [Add Workhorse metrics for secondary proxy requests](gitlab-org/gitlab@a2d4990281f1e130e2267003ded6c02c6abaf7aa) ([merge request](gitlab-org/gitlab!75936)) **GitLab Enterprise Edition**
- [Delete project events before the project](gitlab-org/gitlab@eb8bb098c76575a0cdb558b9f162881ab5527258) ([merge request](gitlab-org/gitlab!76465))
- [Capture job executor value in ci_runners table](gitlab-org/gitlab@251420dc2a2a2e509c079d5b90836c447fc9de78) ([merge request](gitlab-org/gitlab!76368))
- [Add markdown support for Vulnerability Description](gitlab-org/gitlab@0a6c6fddd18359b9184cb6c6e00617693fcb2fde) ([merge request](gitlab-org/gitlab!75859)) **GitLab Enterprise Edition**
- [ADd deprecation warning for group import/export](gitlab-org/gitlab@c11f62f5b8447df1c6d9be35c36265a71d850c20) ([merge request](gitlab-org/gitlab!76442))
- [Add sticky header to group migration table](gitlab-org/gitlab@61fbe8b507adc82fdc95ccef1dd5b1c428a8a19d) ([merge request](gitlab-org/gitlab!76439))
- [Add a total number of jobs run by a runner](gitlab-org/gitlab@a8d84a77a63b9585366c5fdc3737a82679aaae76) ([merge request](gitlab-org/gitlab!76211))
- [GraphQL: Allow filtering runners by active status](gitlab-org/gitlab@39183eb80c31ff868370d851d7d1d221ef1aa2c6) ([merge request](gitlab-org/gitlab!76108))
- [Log an activity event when an Agent connects](gitlab-org/gitlab@0d50fdfb0c8a2c1306d71d7ba1cb826dbc8751ac) ([merge request](gitlab-org/gitlab!75487))
- [Added tracking events for the validation errors](gitlab-org/gitlab@6b3867a319acc08d1cfaab12afddd32398a152f3) ([merge request](gitlab-org/gitlab!75255))
- [Add handling for pending incident escalations](gitlab-org/gitlab@1bd8f8e3c49896558d51d82a9abb22830648f4a7) ([merge request](gitlab-org/gitlab!74337)) **GitLab Enterprise Edition**
- [Add future_subscriptions column](gitlab-org/gitlab@eb3f46880d5ee5e0b46064940e6600633362febc) ([merge request](gitlab-org/gitlab!75716))
- [Create data model for Deployment Approvals](gitlab-org/gitlab@c4d5ac49db3d87792ef4eadd6c55b1129ccac3d4) ([merge request](gitlab-org/gitlab!74932))
- [Add event streaming metrics](gitlab-org/gitlab@2a4da833925458f1a43af248ab0b44246a71a407) ([merge request](gitlab-org/gitlab!75504)) **GitLab Enterprise Edition**
- [Enable bulk delete in tags list](gitlab-org/gitlab@edc3beb193a3d686c4f2c780a690c68a05793d16) ([merge request](gitlab-org/gitlab!75655))
- [Encrypt plaintext static_objects_external_storage_auth_token](gitlab-org/gitlab@a37ffbb1add2a243bdc0e2a0b4aa0f0965b79aff) ([merge request](gitlab-org/gitlab!75417))
- [Enable SSH key lifetime settings by default](gitlab-org/gitlab@e38f70c752c917936b04e696975595eb359870cb) ([merge request](gitlab-org/gitlab!76217)) **GitLab Enterprise Edition**
- [Adds graphql markdown field for Vulnerability Description](gitlab-org/gitlab@3ad73fc5f61aeb697a09f5897b61a310975fdfea) ([merge request](gitlab-org/gitlab!76202)) **GitLab Enterprise Edition**
- [Add first_commit and first_multiline_commit to commit template](gitlab-org/gitlab@be1b5c22d1f8919e154c4cdc59e63b6d75961799) by @trakos ([merge request](gitlab-org/gitlab!75819))
- [Add the "Scheduled" tab to the on-demand scans page](gitlab-org/gitlab@0cf30a7340ce32fb31d2beb5daeebf2d68857e34) ([merge request](gitlab-org/gitlab!75372)) **GitLab Enterprise Edition**
- [Add index snippets on project_id and title](gitlab-org/gitlab@d5b0bcaf05b845b1e97492b39cab7ae6c0bfe66a) ([merge request](gitlab-org/gitlab!76161))
- [Put vuln finding link ingest behind feature flag](gitlab-org/gitlab@654fb040de721e31449fa0106ac56a9805d3979c) ([merge request](gitlab-org/gitlab!76167))
- [Add stale runners filters and badge](gitlab-org/gitlab@82e179e89a70e94d0a36f71a33c15241496289e7) ([merge request](gitlab-org/gitlab!75244))
- [Add feature to limit the lifetime of SSH keys](gitlab-org/gitlab@02fef58edab24c092da1140e79b782b3d25d1e83) ([merge request](gitlab-org/gitlab!75098))
- [Add Task work item type to the database](gitlab-org/gitlab@b003d23b3350f95b6ccc07d72e0a79e3f3b33c35) ([merge request](gitlab-org/gitlab!75447))
- [Remove importer usage ping feature flag](gitlab-org/gitlab@d93a676545584712f48d3afeb733bb5891d182fe) ([merge request](gitlab-org/gitlab!75663))
- [Enable FF multiple_gpg_signatures](gitlab-org/gitlab@14c1db2f6c8fd4ef317ca3c183672f420f5838ef) ([merge request](gitlab-org/gitlab!74385))
- [Fixed sign-in via LDAP when a user cap is set](gitlab-org/gitlab@79d33c5132a820aa6e8b726608c652e638cd5df4) ([merge request](gitlab-org/gitlab!75555)) **GitLab Enterprise Edition**
- [Support expanded reference formats for URLs](gitlab-org/gitlab@175b336a81cd1b50f4aa7f5bddb551aec93651be) ([merge request](gitlab-org/gitlab!75719))
- [Create vulnerability read model](gitlab-org/gitlab@90ca3058d1e44a60c56d505052ecb4f95e32ad7f) ([merge request](gitlab-org/gitlab!74733))
- [Execute build hooks on pending status](gitlab-org/gitlab@242d363597e47ef5507b64012d1554683c487c2c) ([merge request](gitlab-org/gitlab!75737))
- [Include `Last Activity` in User Permissions CSV export](gitlab-org/gitlab@c95987e5a5b98f9b60e3d78d7c143f65a9d421bc) ([merge request](gitlab-org/gitlab!75652)) **GitLab Enterprise Edition**
- [Introduce API to transfer groups to a new parent group](gitlab-org/gitlab@c3f71ada42976cd4cb980df616b33c7cb701fb1d) ([merge request](gitlab-org/gitlab!75205))
- [Added Snowplow events to the Clusters page](gitlab-org/gitlab@eb01d7be919cd15e2d01be0329885fe51ffe402b) ([merge request](gitlab-org/gitlab!75223))
- [Return job failure reason in API responses](gitlab-org/gitlab@7b143a405dac3f184b2f6253afb90b83dcb39c1a) by @albertvaka ([merge request](gitlab-org/gitlab!74888))
- [Add project CI CD tab tracking](gitlab-org/gitlab@ecdd2b6bc9d4afecd8062b40754b90c5498df7d6) ([merge request](gitlab-org/gitlab!75187))
- [Add incident_management_timeline_events table](gitlab-org/gitlab@7d8c3c4c5cc85ba50de4fbde83b174c7addaa89f) ([merge request](gitlab-org/gitlab!74530))
- [Set `CS_DEFAULT_BRANCH_IMAGE` in Auto DevOps template](gitlab-org/gitlab@77d1224ba0ee259e99a471cf394ce31dd34667c8) ([merge request](gitlab-org/gitlab!74627))
- [Add confidential filter to board list in GraphQL](gitlab-org/gitlab@28d98d1aafba58a51840e9becc4aec31fd90e802) ([merge request](gitlab-org/gitlab!75380))
- [Add canCurrentUserPushToBranch permission](gitlab-org/gitlab@c38e4ccde4272ef572b531d478f9803d1e7e4234) ([merge request](gitlab-org/gitlab!75017))
- [Use Keyset pagination for Groups API by default](gitlab-org/gitlab@39e5b880c94d38cb349eda3e875001211598993b) ([merge request](gitlab-org/gitlab!75078))
- [Add GraphQL type and resolver for agent activity events](gitlab-org/gitlab@a61b8130687e4b60a0c59ede4f7f9b2a902d4adf) ([merge request](gitlab-org/gitlab!74651))
- [Create default squash commit message using customizable template](gitlab-org/gitlab@42375dd47442ec61f05e7b1eed52f447a30429bc) by @trakos ([merge request](gitlab-org/gitlab!74340))
- [Display issue crm contacts in UI](gitlab-org/gitlab@db0b92544f740b3ffe4e55e1d14f08f84dfacac1) by @leetickett ([merge request](gitlab-org/gitlab!74346))
- [Create a note when replied to the email creating the service desk issue](gitlab-org/gitlab@ebcfb38567c59197d9975cb893d78b21ef76894e) ([merge request](gitlab-org/gitlab!71749))
- [Update Member entity to expose member state](gitlab-org/gitlab@2f60cfca85e36327b26a2267f58f76633c66dc45) ([merge request](gitlab-org/gitlab!74624)) **GitLab Enterprise Edition**
- [Remove tag limit feature flag](gitlab-org/gitlab@39952697e877d9075c37764fec310111dae45908) ([merge request](gitlab-org/gitlab!74813))
- [Migrate remaining U2fRegistrations to WebauthnRegistrations](gitlab-org/gitlab@453758b6f0f3556903488a839ac59bbe4d0061d6) ([merge request](gitlab-org/gitlab!74671))
- [Create `agent_activity_events` table for storing Agent activity](gitlab-org/gitlab@4ef36dfb25fe6104c3240e247cf43eaf01bc47ae) ([merge request](gitlab-org/gitlab!74577))
- [Invite members for tasks](gitlab-org/gitlab@dc21cfe23f0796b37230b9911790e3158f8acce7) ([merge request](gitlab-org/gitlab!74898))
- [Add issue customer relations contacts quick actions](gitlab-org/gitlab@b5e6f7b38b39ec6124c5582fab4647ed1dadd654) by @leetickett ([merge request](gitlab-org/gitlab!73413))
- [Allow board issue filtering by iteration cadence ID in GraphQL](gitlab-org/gitlab@42202aeab8e419f0068074c09cc8c2e6a2d2d36a) ([merge request](gitlab-org/gitlab!74451)) **GitLab Enterprise Edition**
- [Make invite members in quick menu permanent](gitlab-org/gitlab@74e014e6a0e2419738126c2a99642ac5d76ac8cc) ([merge request](gitlab-org/gitlab!74760))
- [Partition pruning for the web_hook_logs table](gitlab-org/gitlab@988a96c7e03315df8acac41610784338bf53a0de) ([merge request](gitlab-org/gitlab!74739))
- [Moved user cap worker logic to User](gitlab-org/gitlab@aee2f5bccc0fd32b3201e3cf2ef1416497b779e7) ([merge request](gitlab-org/gitlab!73991)) **GitLab Enterprise Edition**
- [Validate batched migration jobs](gitlab-org/gitlab@f9652cad762a4b97dffa4427029a6f4760c48090) ([merge request](gitlab-org/gitlab!72607))
- [Track created_at on CI minutes records](gitlab-org/gitlab@bf88bdf14db22e501d446c05e29708f291af0372) ([merge request](gitlab-org/gitlab!74533))

### Fixed (93 changes)

- [Fix foreign key and index names in `ci_sources_pipelines`](gitlab-org/gitlab@3fa6e65f34085580ee5ec51770a79faea4e73f44) ([merge request](gitlab-org/gitlab!76171))
- [Strip leading and trailing whitespace from user's name](gitlab-org/gitlab@51ce5737d1e8f3e4967ab5356a298e6af2c5b8a8) ([merge request](gitlab-org/gitlab!76706))
- [Ensure all scanners are translated in alerts](gitlab-org/gitlab@75fd592a9992741681f831cf3c54840f2b7415ff) ([merge request](gitlab-org/gitlab!76940))
- [Fixed cache_key ids](gitlab-org/gitlab@37291085032e8d38028129a9d25d2cce80a6c13e) by @akumar1503 ([merge request](gitlab-org/gitlab!75454))
- [Fix N+1 problem for system notes metadata association](gitlab-org/gitlab@3bc94ab8b4106a9f0171d01c5f30ac5396fed21d) ([merge request](gitlab-org/gitlab!76951))
- [Fix updating emails for group notifications](gitlab-org/gitlab@89ca2e3a19ea0e8693864cd2f837cbebd432913f) ([merge request](gitlab-org/gitlab!76636))
- [Handle nil services error in external pipeline validation](gitlab-org/gitlab@cb1742b80e73baa83f6bd475827c41e5b01b2ab7) ([merge request](gitlab-org/gitlab!76902))
- [Fix expose status in Runners API](gitlab-org/gitlab@6b007a608fd72bc95f9b1b20d3e6e727f9a72260) ([merge request](gitlab-org/gitlab!76761))
- [Fix N+1 problem for notes association](gitlab-org/gitlab@fad40e756e89cba6f39d398f3970152fca78a136) ([merge request](gitlab-org/gitlab!76764))
- [Copy auth field objects when serializing values](gitlab-org/gitlab@5eebc6b3d86e3eab26ba96e0b606cca80bb85cee) ([merge request](gitlab-org/gitlab!76845)) **GitLab Enterprise Edition**
- [Update gitlab-markup gem to 1.8.0](gitlab-org/gitlab@cd57920a1aac2522d42067919c5c469fca9be06c) ([merge request](gitlab-org/gitlab!76386))
- [Expose finished_at in job details JSON](gitlab-org/gitlab@049a865798e336ea73a9756e1acad93be0ff18dc) by @KevSlashNull ([merge request](gitlab-org/gitlab!76668))
- [Fix OlderDeploymentsDropService drops manual deployments](gitlab-org/gitlab@1c2bca949583139e9a0b6613e9f758932c47584a) ([merge request](gitlab-org/gitlab!76632))
- [Unescape and sanitize protected tag name on create and update](gitlab-org/gitlab@a5d837098f0188714df935454682fd0a0140e7a6) ([merge request](gitlab-org/gitlab!76198))
- [Gracefully handle bad dependency scanner input](gitlab-org/gitlab@a139d7db9b881d4cb7f210a36fa301551f43911a) ([merge request](gitlab-org/gitlab!76597)) **GitLab Enterprise Edition**
- [Fix CI/CD settings available when CI/CD is off](gitlab-org/gitlab@b213e3958d0f6e59485e27b1962f2f83cae47d39) by @KevSlashNull ([merge request](gitlab-org/gitlab!76009))
- [Add new line to code nav popover](gitlab-org/gitlab@07f0995a41624fc202313f330a70fa237d958342) ([merge request](gitlab-org/gitlab!76545))
- [Error Tracking: Allow event payload to contain null bytes](gitlab-org/gitlab@cf5d0a4dad83a7286745b6be7c8cda1271e26ff2) ([merge request](gitlab-org/gitlab!76279))
- [Only trigger housekeeping once per push](gitlab-org/gitlab@12353a2281ef7ab6dd64c6234e96b00861f58b0e) ([merge request](gitlab-org/gitlab!75581))
- [Link existing LFS objects from parent fork during uploads](gitlab-org/gitlab@0a374212eae43589c0309b84f6498079053e67a1) ([merge request](gitlab-org/gitlab!75972))
- [Fix SMIME signed email sending, do not overwrite Content-Disposition](gitlab-org/gitlab@8dc47e60863415e317c2184afda1e8b8ba9adc97) by @bufferoverflow ([merge request](gitlab-org/gitlab!76233))
- [GithubImporter: Fallback to LegacyDiffNote when DiffNote fails](gitlab-org/gitlab@0b8c2beaf4a7e12206a456a32312e9629e623eed) ([merge request](gitlab-org/gitlab!76376))
- [Fixed NoMethodError on import from GitHub Enterprise on RFC1918 IP](gitlab-org/gitlab@e10c6951e0296d384cfaa9bde5db8efeb2b9e97b) by @colinbarr ([merge request](gitlab-org/gitlab!76060))
- [Fix issue sidebar keyboard shortcuts](gitlab-org/gitlab@57abb1cdcafb23e7c5f0b31b2602e159e4a7cb82) ([merge request](gitlab-org/gitlab!76415))
- [Fix 'Erase job log' button is misleading](gitlab-org/gitlab@b742d57ed51aadc95590133b34c2b5ed8d0d8bea) by @KevSlashNull ([merge request](gitlab-org/gitlab!75892))
- [Generate human readable message on duplicate dotenv variables](gitlab-org/gitlab@eda1c64e57e6328c51932492b1d39a688992d148) ([merge request](gitlab-org/gitlab!75861))
- [Optimize query for issue neighbors](gitlab-org/gitlab@cbc50b76a7caafa6bf6ea2d4ef7d75b98242d262) ([merge request](gitlab-org/gitlab!76073))
- [Fix commit sha being used instead of tag for tagged pipelines](gitlab-org/gitlab@9ee563ec913be019ddbaf57cbdf1d0bc5aa19872) ([merge request](gitlab-org/gitlab!76047))
- [Ensure Jira users and labels have `id` attribute](gitlab-org/gitlab@fb59909b09f692103e201e80996824c3f83a8dfc) ([merge request](gitlab-org/gitlab!75966)) **GitLab Enterprise Edition**
- [Present pipeline coverage in pipeline API entity as string](gitlab-org/gitlab@0582b70a590b717a0f2a1af3f3b3ab889c1aad55) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/76299))
- [Fix user list selection is not in sync with UI](gitlab-org/gitlab@6bd6e91f45d8f84ca62eaa67233cdc6400af541b) by @KevSlashNull ([merge request](gitlab-org/gitlab!75928))
- [Fix schedule ID is show on schedule edit page](gitlab-org/gitlab@1a4d10e8f5bb3464361e87904b622d86c7544249) by @KevSlashNull ([merge request](gitlab-org/gitlab!75804))
- [Use additional headers for matching service desk email](gitlab-org/gitlab@acf5c801cfe6153f54e7d6fac64437f3f42236d4) ([merge request](gitlab-org/gitlab!75443))
- [Fix vulnerability report tab querystring removed when filters changed](gitlab-org/gitlab@aaf6dc48796bce839207f780cc4f0851d17ab527) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/76208)) **GitLab Enterprise Edition**
- [Fix occasional failure when updating labels from sidebar](gitlab-org/gitlab@52e7bdbe62f0e04388a60c2da4c3fd3c124d5e24) ([merge request](gitlab-org/gitlab!76099))
- [Fix wrong end date in query for contributions](gitlab-org/gitlab@3a358c55644d6d685fd370fdb8e491ef9a6837fc) ([merge request](gitlab-org/gitlab!76077))
- [Copy manual variables when retrying job](gitlab-org/gitlab@b73f9d390a32a7c02cfff6b83ff6de78e478ae81) ([merge request](gitlab-org/gitlab!75720))
- [Fix some private contributions being hidden on the contribution calendar](gitlab-org/gitlab@826220e196c1bd41b659b8755fb99fee2c23b1bb) by @eggerd ([merge request](gitlab-org/gitlab!74826))
- [Fix permissions for label promotion via API](gitlab-org/gitlab@be1b386c4a387ee03ba7d5f8dcda0b5922a91d2e) ([merge request](gitlab-org/gitlab!75930))
- [Fix serverity and alert sidebar edit button style](gitlab-org/gitlab@7c6d82df028c3fd505a273958b5b3e20b29ec8f4) by @orozot ([merge request](gitlab-org/gitlab!75914))
- [Pass current_user when rendering Markdown in email](gitlab-org/gitlab@d789d73f07f2a0fa68b55ff1ba2bfc1823a436f4) ([merge request](gitlab-org/gitlab!75635))
- [Fix infinite loop on saml login of a blocked user](gitlab-org/gitlab@00a4831dfff04da1b4c4e4b7219d288ebcf8a047) ([merge request](gitlab-org/gitlab!75887))
- [Add ci_status.scss for commit piplines page](gitlab-org/gitlab@2b31f599daa64849917104486faa68be86381dd7) by @orozot ([merge request](gitlab-org/gitlab!75878))
- [Fix button variant in maintenance mode settings](gitlab-org/gitlab@6a683d68670b994906df0a7fd52219c09efae824) by @KevSlashNull ([merge request](gitlab-org/gitlab!75870))
- [Fix epic date changes without user input](gitlab-org/gitlab@813257fd5e470e6374310330d8883a078db13535) ([merge request](gitlab-org/gitlab!75817))
- [Fix cut off focus ring in commit container](gitlab-org/gitlab@16b9d6fbb84d4f5e15e979af7580c3d8a9170513) by @KevSlashNull ([merge request](gitlab-org/gitlab!75812))
- [Add patch for WikiCloth](gitlab-org/gitlab@c8a0ad0bb54ca6bb80c730eeac5bb1ebcadf5f9b) ([merge request](...))
- [Fix pride flag emoji rendering](gitlab-org/gitlab@a568cb884a8113ba36a666eb52363ece32223bbf) ([merge request](gitlab-org/gitlab!75011))
- [Fix order in monthly events boundary query](gitlab-org/gitlab@ccae3d568d13992ef761c530cbae998e4950274f) ([merge request](gitlab-org/gitlab!75722))
- [Do not run service discovery for DB load balancing for rake tasks](gitlab-org/gitlab@e460765de45bf01c3e94ca5ed0f79926cce843d2) ([merge request](gitlab-org/gitlab!75612))
- [Ensure current user and variables are updated when playing a job](gitlab-org/gitlab@8b3ba6f3c0a72d17476cfb86a52373c7dc604fbd) ([merge request](gitlab-org/gitlab!75657))
- [Allow creating a group access token for a group with SSO enforcement](gitlab-org/gitlab@96150fbc52fe39ccadceef231cf3fda65688a758) ([merge request](gitlab-org/gitlab!75023)) **GitLab Enterprise Edition**
- [Fixes pending note avatar size in diff view](gitlab-org/gitlab@748c33737782bfe6ed1cc2615b1e900ae17a1972) ([merge request](gitlab-org/gitlab!75130))
- [Fix link to docs in the "Transfer Group" section](gitlab-org/gitlab@6bb12aedf6d2f2508d4fc403efa4ce6a2a3d61c7) by @gizero ([merge request](gitlab-org/gitlab!66246))
- [Fix Wiki Pipeline network error if wiki does not exist](gitlab-org/gitlab@c3d0947e5bca64b69ddfb2e70e9ec2ceacafe8ab) ([merge request](gitlab-org/gitlab!74731))
- [Fix for hexadecimal branch deletion](gitlab-org/gitlab@dc82ec85d4ea6f6fa7846c3f0939959996075724) ([merge request](gitlab-org/gitlab!75344))
- [Fix column order in jobs tab in the pipelines details page](gitlab-org/gitlab@7edd0b370ac9c9a7fbd8d2b67d35f892d9f85549) ([merge request](gitlab-org/gitlab!75160))
- [Fix import from remote object storage documentation](gitlab-org/gitlab@dcf9e51c57b6816d56126237648b64d4a5e5da2d) ([merge request](gitlab-org/gitlab!75158))
- [Fix Gitlab Pages deployment wrong if a project has a public folder](gitlab-org/gitlab@653d77132e9094391660c9de7549834ab97258b0) by @sodepr ([merge request](gitlab-org/gitlab!74952))
- [Catch YAML errors when parsing security policies](gitlab-org/gitlab@19a5e9153e307b7bf9d81b5f64c654a289390055) ([merge request](gitlab-org/gitlab!75092)) **GitLab Enterprise Edition**
- [Fix Debian Sources file name](gitlab-org/gitlab@a629da2abe6deca7071e587c77da72acd3df60e3) by @sathieu ([merge request](gitlab-org/gitlab!74445))
- [Fix the SSL_CERT_DIR logging on git operations](gitlab-org/gitlab@6f7b88c7bb4874dd603c07373b89d3feefc40941) ([merge request](gitlab-org/gitlab!75196))
- [Fix cross database transaction when blocking users](gitlab-org/gitlab@0f030f83991f32aeeeb2cf670a3b918f73c0826c) ([merge request](gitlab-org/gitlab!75195))
- [Support Action Cable on GCP Memorystore](gitlab-org/gitlab@57141bd04ccd71ce1fd4a2984b8a33597d4a9b35) ([merge request](gitlab-org/gitlab!75173))
- [Update dependency proxy copy and help text](gitlab-org/gitlab@d94017a793f6aaec2d46f8dbabb493cce5df485a) ([merge request](gitlab-org/gitlab!74806))
- [Only display user bio for confirmed and active users](gitlab-org/gitlab@f2d0766731a753c3194c0f2930b8c1a5be0fc654) ([merge request](gitlab-org/gitlab!75032))
- [Heartbeat runner only for specific job-context requests](gitlab-org/gitlab@aa5e73e7a7c51c035dd0e5532d05ec0eda19c830) ([merge request](https://gitlab.com/foo/bar/-/merge_requests/123))
- [Sort months of the CI minutes chart app](gitlab-org/gitlab@55da27bed7efc74dbc34f3259dfc5ab8a4586830) ([merge request](gitlab-org/gitlab!74917)) **GitLab Enterprise Edition**
- [Fix broken project creation without import sources](gitlab-org/gitlab@e97a9e239f2ad84eeb84cd5af4664521ada8882b) ([merge request](gitlab-org/gitlab!75121))
- [Do not try to auto-complete vulnerabilities if the user is nil](gitlab-org/gitlab@3e0173cc3d6e644f6422222642e885a7e39ec66c) ([merge request](gitlab-org/gitlab!75112)) **GitLab Enterprise Edition**
- [Do not show primary email as secondary email in admin view](gitlab-org/gitlab@c00c8fd22adaf1b0f96f8b3048c789458dfc32e7) ([merge request](gitlab-org/gitlab!75095)) **GitLab Enterprise Edition**
- [Ensure coverage approval rule sync is successful](gitlab-org/gitlab@791b267b28570c8391b214ba7a6e16cf085285d7) ([merge request](gitlab-org/gitlab!75087)) **GitLab Enterprise Edition**
- [Fix Sidekiq sleep time for jobs that use replicas](gitlab-org/gitlab@80e0b45eb19ada2081a95c89346a800b1ea72444) ([merge request](gitlab-org/gitlab!75081))
- [Fix border spacing on multi-line comments](gitlab-org/gitlab@4b2f5e38af82b593f14335172004bb4dd18c25fb) ([merge request](gitlab-org/gitlab!74486)) **GitLab Enterprise Edition**
- [Add retries to github importer on client errors](gitlab-org/gitlab@2cf4f47daefd4190ed1e9fe5896b32fd70a5ea92) ([merge request](gitlab-org/gitlab!74966))
- [Update dotNET-Core.gitlab-ci.yml template image](gitlab-org/gitlab@2209c3d60523c9c92f36b2b24802ecfa8cc5b329) by @softis-software ([merge request](gitlab-org/gitlab!74744))
- [Fix wrong default branch imported with Bitbucket Server](gitlab-org/gitlab@006f6c73a3480892f03c9152ed5d30f966cf2e1e) ([merge request](gitlab-org/gitlab!74858))
- [Upgrading ipynbdiff to 0.3.8](gitlab-org/gitlab@f7bce9de5ebe7c00a52e92f7bb1fd5503ae41d2f) ([merge request](gitlab-org/gitlab!74820))
- [Allow to create issues by email when it contains only quotes](gitlab-org/gitlab@8cebd721e9c1ec75ad8da7b526646e9866fa953a) ([merge request](gitlab-org/gitlab!74413))
- [Grant permissions for oauth users based on scopes](gitlab-org/gitlab@33390e155221d5cb0dc48e33ccee635934d61739) ([merge request](gitlab-org/gitlab!74646))
- [Fix security report schema validation logic](gitlab-org/gitlab@262b237145469287e3e5714687bd7c95b7a4bd9d) ([merge request](gitlab-org/gitlab!74793)) **GitLab Enterprise Edition**
- [Fix docs error in NuGet API](gitlab-org/gitlab@e6a43962aa566a7ebe4b1dd242ade7f79dad93b8) by @wwwjon ([merge request](gitlab-org/gitlab!74780))
- [Allow uploading up to 10 files](gitlab-org/gitlab@451f9c6ce071b3dd727d1cc097da9c58a08c4dc7) ([merge request](gitlab-org/gitlab!74377))
- [Fix issue and MR exports to support NOT filters](gitlab-org/gitlab@cc00ac7f1c2989336002214e2e2428f47d23cdb5) ([merge request](gitlab-org/gitlab!74764))
- [Create missing /root/.gnupg dir in Scala.gitlab-ci.yml](gitlab-org/gitlab@45825580daede20e597658ca6f83fb23bf982250) by @carlosrogue ([merge request](gitlab-org/gitlab!71561))
- [Don't try to generate url for an finding records](gitlab-org/gitlab@b686da2581c5cbaed62155bc145d503ead95f1fd) ([merge request](gitlab-org/gitlab!74724)) **GitLab Enterprise Edition**
- [Use gpg --recv-keys instead of curl in Scala.gitlab-ci.yml](gitlab-org/gitlab@965546cbf22671f8c86e9eeaa0e9ee651003cff9) by @carlosrogue ([merge request](gitlab-org/gitlab!71561))
- [Error Tracking: Support exceptions from Python's repl](gitlab-org/gitlab@bb6706cdd66e3d94b0dfa8882a60b0cf84178e92) ([merge request](gitlab-org/gitlab!74717))
- [Move VSA stage options to footer](gitlab-org/gitlab@17755bf7ed6b5cf1f700ff21d490c08839099082) ([merge request](gitlab-org/gitlab!74683)) **GitLab Enterprise Edition**
- [Fix discussions filter not working](gitlab-org/gitlab@aaba5cf78aa57442ad38ab880142485a509ef972) ([merge request](gitlab-org/gitlab!74662))
- [Remove deprecated apt-key usage on Scala.gitlab-ci.yml](gitlab-org/gitlab@531c292205adc0975b693eb9642bef4551f9f629) by @carlosrogue ([merge request](gitlab-org/gitlab!71561))
- [Fix display of times in access and deploy token table](gitlab-org/gitlab@5346cfc625ffe68d9376a1cab00e61321ab2ac07) by @edith007 ([merge request](gitlab-org/gitlab!72212))
- [Add emoji aliases for :) and :(](gitlab-org/gitlab@c6fc80be61a03e069cd1b21355bb2a3bb942293a) ([merge request](gitlab-org/gitlab!74204))

### Changed (95 changes)

- [Use linear version GroupsWithTemplatesFinder#extended_group_search](gitlab-org/gitlab@5fe40a793d74ec6b17b566a3974ded3b593afc1d) ([merge request](gitlab-org/gitlab!75981)) **GitLab Enterprise Edition**
- [Add Pajamas badge for pipelines license tab](gitlab-org/gitlab@5eef869f95c55ce05fd30a19d249486ac1516baa) ([merge request](gitlab-org/gitlab!76997)) **GitLab Enterprise Edition**
- [Add copy issue URL button to vulnerability error message](gitlab-org/gitlab@46c207ebba53cb25cf6ea424768680fec3b532c2) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/76215)) **GitLab Enterprise Edition**
- [Make badge in admin/users/_access_levels.html.haml Pajamas compliant](gitlab-org/gitlab@63feb703eca8de278693ba1b43061e8d58779c3c) ([merge request](gitlab-org/gitlab!76973))
- [Update badges for ci builds to use helper](gitlab-org/gitlab@89a1adbe264929792a1e32ebd9e11fa2d67dcb58) ([merge request](gitlab-org/gitlab!76791))
- [Update project runner badges to pajamas](gitlab-org/gitlab@cbc62f37616cd13e343b82e0a37ed3d3df5fdf7c) ([merge request](gitlab-org/gitlab!76985))
- [Removes all ci_optimize_project_records_destruction ff](gitlab-org/gitlab@651259ee3593e5bba2d9571420396a14a8125939) ([merge request](gitlab-org/gitlab!72600))
- [Update user signups cap to allow values greater than licensed user count](gitlab-org/gitlab@75a71bc0d3abd9c4c47a4a8065a98aa2d7b68796) ([merge request](gitlab-org/gitlab!76829)) **GitLab Enterprise Edition**
- [Make use of the project data served by Rails](gitlab-org/gitlab@4d1eb551e32b1ef72f52ded40f9e576998ae2378) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/72218))
- [Remove Analytics menu item from unlicensed EE](gitlab-org/gitlab@fd29568620702c0dddf2ebe961f276a1df9fa80f) ([merge request](gitlab-org/gitlab!76212)) **GitLab Enterprise Edition**
- [Geo: Treat missing files as sync failures](gitlab-org/gitlab@af2a926a098eb8105142c61e430da5047b3d833b) ([merge request](gitlab-org/gitlab!76801)) **GitLab Enterprise Edition**
- [Remove FF avoid_cross_joins_environments_in_self_and_descendants](gitlab-org/gitlab@4c768671cf241ff1563202b1e85eb13c31e893f7) ([merge request](gitlab-org/gitlab!76857))
- [Remove cached_mr_title feature flag](gitlab-org/gitlab@6e5e2013f2ea697a351c1ff705e9990fd0e3c837) ([merge request](gitlab-org/gitlab!74228))
- [Update cluster badge to pajamas](gitlab-org/gitlab@df1299ce646ddc76f60a7f334dd6bbd52b0efe1e) ([merge request](gitlab-org/gitlab!76608))
- [Hide user avatar for blocked and unconfirmed users](gitlab-org/gitlab@f2a83cd8e4bf2324b81ad517b229a3d63fd55faa) ([merge request](gitlab-org/gitlab!75921))
- [Order jobs returned desc](gitlab-org/gitlab@e22564510977831a51acbf11c74f6f79d10daca7) ([merge request](gitlab-org/gitlab!76227))
- [Enhance the sidebar to use gl-link focus styling](gitlab-org/gitlab@2acf75da39a4a1630c014ada0bd45f26187b262e) ([merge request](gitlab-org/gitlab!76144))
- [Default improved_container_scan_matching to true](gitlab-org/gitlab@180899a2b6542b68081ec6c39b7fd6fbd6af0918) ([merge request](gitlab-org/gitlab!76285))
- [Add Pajamas-complient protected tags badge](gitlab-org/gitlab@2ce21565cb28698c6201b9f3662c4962d7fa78ba) ([merge request](gitlab-org/gitlab!76552))
- [Split up yaml and humanized policy previews](gitlab-org/gitlab@bc78d76ee02fbe9b6dd7d65e03a60ac765fdd7c0) ([merge request](gitlab-org/gitlab!75386)) **GitLab Enterprise Edition**
- [Use finding_evidence over raw_metadata](gitlab-org/gitlab@adcf3d514325ff3150bb3617cd3214eee7494c28) ([merge request](gitlab-org/gitlab!75140)) **GitLab Enterprise Edition**
- [When dependency proxy is disabled remove the menu](gitlab-org/gitlab@e32c7726bd7d42d96a7473d6ebc4250e15b52e76) ([merge request](gitlab-org/gitlab!76079))
- [Clean up clone_job_variables_at_job_retry](gitlab-org/gitlab@cacedf0f76e4e214480b038dad9f42667c06f8ae) ([merge request](gitlab-org/gitlab!76162))
- [Remove branches_pagination_without_count FF](gitlab-org/gitlab@f14159033cfa8e49253db2031f0a0a7f14628b97) ([merge request](gitlab-org/gitlab!76526))
- [Enable deployments_archive feature flag by default](gitlab-org/gitlab@36c35d4a5eec0eafe09e42a4aa7df9b7a4bef65a) ([merge request](gitlab-org/gitlab!75824))
- [Migrate auto-devops setting to GlBadge abstraction](gitlab-org/gitlab@aeab12c9ee8bdfaf6b628d085254c8f97759ae0e) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/76416))
- [Geo - Use Rails 6 many databases support](gitlab-org/gitlab@82798f1caf2c1a42f193f512d61a79618b8b5a86) ([merge request](gitlab-org/gitlab!73109)) **GitLab Enterprise Edition**
- [Tanuki Emoji: switch fallback emoji to Noto Emoji](gitlab-org/gitlab@89e739e3b61865cb40b4c3c8ba322980628e122e) ([merge request](gitlab-org/gitlab!76479))
- [Display tag messages with line endings](gitlab-org/gitlab@9a23492d59758e7c72fcd877425e8fff1a7137ef) by @KevSlashNull ([merge request](gitlab-org/gitlab!75896))
- [Migrate badges to be compliant with the Pajamas design system](gitlab-org/gitlab@99ad081f1cde5ddd3f25f7667cfa683d7bd7c7b0) ([merge request](gitlab-org/gitlab!76257))
- [Merge feature flags related to new CI minutes tracking](gitlab-org/gitlab@28fd1d2c537738feebacf6dcb915118319448f29) ([merge request](gitlab-org/gitlab!75755)) **GitLab Enterprise Edition**
- [Add loose foreign key for Terraform state versions](gitlab-org/gitlab@7fa3cb45b5e621723549156b18fbc71aff7c2c39) ([merge request](gitlab-org/gitlab!74524))
- [Remove load_balancing_for_update_all_mirrors_worker FF](gitlab-org/gitlab@304290485f083f30ce624d6830e1058dabc169a3) ([merge request](gitlab-org/gitlab!76336))
- [Separate CI minutes notification levels between new and legacy](gitlab-org/gitlab@2e94399fa549652df73d347158b0c39c7271bbf4) ([merge request](gitlab-org/gitlab!75512)) **GitLab Enterprise Edition**
- [Allow external Spamcheck API key to be blank](gitlab-org/gitlab@b18777151b0fe840108b2d0c79318715cee1c8a0) ([merge request](gitlab-org/gitlab!76303))
- [Migrate badges in Admin -> Groups -> Show](gitlab-org/gitlab@c218e0a1125b51489ec31fa9453bad01b2cff309) ([merge request](gitlab-org/gitlab!76251))
- [Migrate badge in Group -> CI/CD -> Auto DevOps](gitlab-org/gitlab@e3621af855c594c50299af104c8a9346110306fc) ([merge request](gitlab-org/gitlab!76246))
- [Migrate badge component in the admin -> projects area](gitlab-org/gitlab@a543fc8f4407fffc5f655e32ad8c1f743a58b6b1) ([merge request](gitlab-org/gitlab!76239))
- [Fix: web ide text color in dark theme](gitlab-org/gitlab@5acf8ea271b6be6c239ececd2b77c6ace5386684) by @orozot ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/76046))
- [Make DORA data visible for admins](gitlab-org/gitlab@c241e6dcaec4f56aae733082cd376c298ee9705a) ([merge request](gitlab-org/gitlab!76204))
- [Improve runner deletion modal](gitlab-org/gitlab@5dcb3bc9c9a7a16aae4c5f34d18bc778410aa5a5) ([merge request](gitlab-org/gitlab!75432))
- [Handle query timeouts better](gitlab-org/gitlab@2671aada0b73f0d967fc011a7aa7fd52ebc2fd8c) ([merge request](gitlab-org/gitlab!75034))
- [Add cleanup migration for BackfillUserNamespace](gitlab-org/gitlab@3c86027edd1c759b25c9ec59279744b40f427454) ([merge request](gitlab-org/gitlab!73495))
- [Modify pending member approval endpoint](gitlab-org/gitlab@99f5e8c12c9a8831c8139c54fb1ec5dd9ca84c61) ([merge request](gitlab-org/gitlab!75769)) **GitLab Enterprise Edition**
- [Use confirm variant for 'New requirement' button](gitlab-org/gitlab@f0fd71f07ac1fab7fc87cf23c9777c8f47a44783) by @KevSlashNull ([merge request](gitlab-org/gitlab!76052)) **GitLab Enterprise Edition**
- [Add title with the file name to file_row component](gitlab-org/gitlab@6b684ab5c0d4f46e85cc80e6d3d497524516619b) by @ruben.meza ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/75934))
- [Enable linear version User#membership_groups](gitlab-org/gitlab@1200642b27fac465ea096a0df4e4c8f954b40114) ([merge request](gitlab-org/gitlab!74529))
- [UI text updates in new OAuth applications view](gitlab-org/gitlab@471e729fd3d4c256e2a73839a327f5edded85722) ([merge request](gitlab-org/gitlab!72703))
- [Change job duration label to 'Elapsed time' when in progress](gitlab-org/gitlab@3c9916bb7b1b0f5bfdaec180e22d9b8a9e96927a) by @KevSlashNull ([merge request](gitlab-org/gitlab!75811))
- [Add link for failed pipelines](gitlab-org/gitlab@78e1598c7d0ebfdc4fcdb93b4565d114b21fc33e) ([merge request](gitlab-org/gitlab!75654))
- [Pipelines show full job names](gitlab-org/gitlab@f67371939639e0b6014199ea8bb8c3e99f91e249) by @albertvaka ([merge request](gitlab-org/gitlab!74879))
- [Cleanup unaccessible todos when user leaves public project](gitlab-org/gitlab@84611a7d65589bbea6b593f19ad874bce09433a0) ([merge request](gitlab-org/gitlab!74829))
- [Add space between columns in runner table](gitlab-org/gitlab@6f1fbc2417386dd3b8a23c693c500836ca50e76b) ([merge request](gitlab-org/gitlab!75636))
- [Fixed an event for focus](gitlab-org/gitlab@1d327469b55405a1ef5bc9bc52656d11cb2b2901) ([merge request](gitlab-org/gitlab!75629))
- [Remove feature flag `create_vulnerabilities_via_api`](gitlab-org/gitlab@7d8ac5e29b6ccdd5d5c24dd14f73db82eeff1cad) ([merge request](gitlab-org/gitlab!75685))
- [Adapt to size changes when displaying tooltips](gitlab-org/gitlab@a8dbf7c3b16d241f22b6772e01ba04e604137a24) ([merge request](gitlab-org/gitlab!75020))
- [Rework markdown footnote processing](gitlab-org/gitlab@8614e0a92889381dd8b9f147965caeaa9b9b4686) ([merge request](gitlab-org/gitlab!75054))
- [Add Helm-chart storage limits to API and UI](gitlab-org/gitlab@618aa52faa4eb0c6fc7a2e47e63a53bff78fdb2c) by @mlegner ([merge request](gitlab-org/gitlab!75117))
- [Default jira_use_first_ref_by_oid feature flag to true](gitlab-org/gitlab@6cb137ba64e527e816a8deac71137e2387edd37a) ([merge request](gitlab-org/gitlab!73510))
- [Remove chevron for menu button](gitlab-org/gitlab@4aef1a2d2a30de3e47bfc0257bfb0d46c0a04c6f) ([merge request](gitlab-org/gitlab!75394))
- [Change icon to review-list](gitlab-org/gitlab@2b08f5d6f3648ebf010b1d8bf58864923938c27b) ([merge request](gitlab-org/gitlab!75393))
- [Expose failed import error through API](gitlab-org/gitlab@79e80b522d940cf819ecfd0eef3387e6ab49699e) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/75440))
- [Remove ci_new_query_for_pending_stuck_jobs feature flag](gitlab-org/gitlab@e41fa62474b20075a6f53cb5c1359eaefb9194fc) ([merge request](gitlab-org/gitlab!75420))
- [Enable job trace store outside database transaction by default](gitlab-org/gitlab@b90899f8b97482e1bb1ef3dd8f0e546d658e7184) ([merge request](gitlab-org/gitlab!75414))
- [Change namespace type default to 'User'](gitlab-org/gitlab@76454805043d19441715549835f9124662863feb) ([merge request](gitlab-org/gitlab!74592))
- [Load only one scan_finding_rule per policy](gitlab-org/gitlab@db5acf823aca3e95af740d92a42194823ce6feeb) ([merge request](gitlab-org/gitlab!71858)) **GitLab Enterprise Edition**
- [Add line number and import_type to the import status API](gitlab-org/gitlab@7d784019140f00767aedf2ef940acb849f88a2a5) ([merge request](gitlab-org/gitlab!75331))
- [Refine the take-out-of-draft message](gitlab-org/gitlab@0d54e6a943fb5a74684a2057083e188e5e873798) ([merge request](gitlab-org/gitlab!74855))
- [Improve copy when no iteration found in sidebar](gitlab-org/gitlab@e0d3a44f8b257636d2d3efa7ae113e9ec98cf7ad) ([merge request](gitlab-org/gitlab!71010)) **GitLab Enterprise Edition**
- [Update UI message for merge conflicts](gitlab-org/gitlab@650ef4e748847c75e695f2c6772fbe56db084e4f) ([merge request](gitlab-org/gitlab!74655))
- [Change remediated badge icon from wrench to check-circle-dashed](gitlab-org/gitlab@5978966a55cd53dfab2816eb889c3592e4e0a53f) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/74689)) **GitLab Enterprise Edition**
- [Do not require startDate when creating a manual iteration cadence](gitlab-org/gitlab@a267aa3a8dc438877592add694ddcec4ee456a9c) ([merge request](gitlab-org/gitlab!75147))
- [Show disabled fork button for user without enough permissions](gitlab-org/gitlab@01329d6ad7b1033eec01379a3808a5af0ad26871) ([merge request](gitlab-org/gitlab!74876))
- [Copy variables when retrying job](gitlab-org/gitlab@891a4821f229348b6cf5d853583f92e693b0e3dc) ([merge request](gitlab-org/gitlab!75042))
- [Relocate online runners count in search bar](gitlab-org/gitlab@2bd69e208cb32cbc7dca6941927d4fbf30d09549) ([merge request](gitlab-org/gitlab!74877))
- [Prevent runner list IP and version overflow](gitlab-org/gitlab@3013b5434d4c94af2c247461f1cbada3e99e5652) ([merge request](gitlab-org/gitlab!74707))
- [Add more merging messages from the community](gitlab-org/gitlab@164200c719af4f57bdcb204359c67ae911be5b6d) ([merge request](gitlab-org/gitlab!74720))
- [Remove diff limiting feature flags](gitlab-org/gitlab@184f494933bc83f59ac8452918aed0a9441ecd7f) ([merge request](gitlab-org/gitlab!64228))
- [Add URL to rejection_message if terms_not_accepted](gitlab-org/gitlab@33839690dfb5a101a6b237304f90149d5cff954f) by @jgay ([merge request](gitlab-org/gitlab!75082))
- [Drop FindingPipelines and Findings in bg migration](gitlab-org/gitlab@391452f55a11f5fb439980a215016db2cfb982bb) ([merge request](gitlab-org/gitlab!74008))
- [Enable preserve_latest_wal_locations_for_idempotent_jobs by default](gitlab-org/gitlab@2842e05cac072ea7594e7e8056dfb5fd31f9dec4) ([merge request](gitlab-org/gitlab!74902))
- [Enable linear version of `groups_including_descendants_by`](gitlab-org/gitlab@0bb75d09bd372bfb181ddb2d9c0553063ea519b2) ([merge request](gitlab-org/gitlab!74275))
- [Migrate snippets tabs to rails helper](gitlab-org/gitlab@2bdb960f3e7b934f4e6f2a37298c78971fb85236) ([merge request](gitlab-org/gitlab!74867))
- [Remove surface_environment_creation_failure feature flag](gitlab-org/gitlab@08c5550685b6b53626ef6f46ba3c24a0f8f4d531) ([merge request](gitlab-org/gitlab!74773))
- [Improve UI message: creating branch from fork](gitlab-org/gitlab@662d45f54179cab656c8ffb68b37db250ba937bf) ([merge request](gitlab-org/gitlab!74198))
- [Add Shimo integration sidebar menu and landing page](gitlab-org/gitlab@f7f713265577d443f03ccaa49eea36f0980cae6b) by @icbd ([merge request](gitlab-org/gitlab!74140))
- [Enable External MR diff verification by default](gitlab-org/gitlab@77a411b50d32f1ae226ec1e9ce0a88cff2dab2ec) ([merge request](gitlab-org/gitlab!63975)) **GitLab Enterprise Edition**
- [Remove support for sticking to old and new keys](gitlab-org/gitlab@9622020c06c3afc9b91bfcaef9a29c3e64db0100) ([merge request](gitlab-org/gitlab!74784))
- [Add BaseEdge base class](gitlab-org/gitlab@5e02ef43bc655456ce3004a1f47a6dcf5200c1d2) ([merge request](gitlab-org/gitlab!71476))
- [Split out main, and geo DB out of CI transactions](gitlab-org/gitlab@1517b07e9fe485e5d51dd8c55a1e159c8dafa169) ([merge request](gitlab-org/gitlab!74737)) **GitLab Enterprise Edition**
- [Migrate button variants](gitlab-org/gitlab@329ec7e1eaf7141a0876771be2d756c34d0f4977) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/74718)) **GitLab Enterprise Edition**
- [Update gl-modal buttons in user status modal](gitlab-org/gitlab@9aae10a373c444e47dbd7c35ee17b3aa0ab597ed) by @yo ([merge request](gitlab-org/gitlab!59460))
- [Do not select "My company or team" radio box by default](gitlab-org/gitlab@2d93592bc061d93eef5d1a4399a9b3d4521f66cf) ([merge request](gitlab-org/gitlab!74681))
- [Allow squashing in MRs with single commit](gitlab-org/gitlab@869875fed3d0396f529989211382962f2addc957) by @trakos ([merge request](gitlab-org/gitlab!74464))
- [Start using v1.x of our IAC analyzer](gitlab-org/gitlab@9e59964b0cf318677dbbd7126d9c8f33570fdf1a) ([merge request](gitlab-org/gitlab!74560))

### Deprecated (2 changes)

- [Ignore position column](gitlab-org/gitlab@9f7517d2114409bfbba4169ef489a494c8eb2937) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/76311)) **GitLab Enterprise Edition**
- [Deprecate ApiFuzzingCiConfigurationCreate fields](gitlab-org/gitlab@d3f335b100bce0fea2bbb846d75300740805750a) ([merge request](gitlab-org/gitlab!74783)) **GitLab Enterprise Edition**

### Removed (4 changes)

- [Remove `force_company_trial` experiment](gitlab-org/gitlab@e5b9c0d44614dfa6fd476bd5e68b986b43478761) ([merge request](gitlab-org/gitlab!76982))
- [Remove the configureIacScanningViaMr feature flag](gitlab-org/gitlab@2da8ae7b1a76a68513a235756ef244f9ed66ebd4) ([merge request](gitlab-org/gitlab!75721))
- [Remove sast_entry_points experiment](gitlab-org/gitlab@07470fffe85c28fe529aee214f4cf67399c68b96) ([merge request](gitlab-org/gitlab!75014))
- [Remove reference to lower_relation_max_count_limit](gitlab-org/gitlab@8a3163c3025735eb73227ef94d1c0a5cfa13abd8) ([merge request](gitlab-org/gitlab!75482))

### Security (5 changes)

- [Enable visibility filter on Epics menu pill count](gitlab-org/gitlab@0dcd256df0fa812f84e91eb92fcc9884a1ea20d1) ([merge request](gitlab-org/gitlab!76456)) **GitLab Enterprise Edition**
- [Use Gitlab::Json to serialize sessions](gitlab-org/gitlab@7e7cf0b8df64c3ef44def9a085dc2af9dda6d004) ([merge request](gitlab-org/gitlab!72701))
- [Update Puma to version 5.5.2](gitlab-org/gitlab@32d23747fc560f7eafc0eb52fae04a1633e5bded) ([merge request](gitlab-org/gitlab!75642))
- [Disallow non-members unlocking project files](gitlab-org/gitlab@fd76d6850c5179cfedee5263fffd17d3d16f53e1) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/74541)) **GitLab Enterprise Edition**
- [Use a more precise Sourcegraph URL in CSP](gitlab-org/gitlab@29399b2e60a5a22e49973d99e611137549712ac4) ([merge request](gitlab-org/gitlab!72552))

### Performance (18 changes)

- [Limit the amount of ids loaded when using package build infos](gitlab-org/gitlab@253271229a1310708c8b7d108d79b3c501ffc145) ([merge request](gitlab-org/gitlab!75672))
- [Update dependency proxy API to use cleanup worker](gitlab-org/gitlab@a737fe60d820a15e64d4457c1ef2f3e82d6f59f5) ([merge request](gitlab-org/gitlab!76696))
- [Utilize C version of CommonMark renderer](gitlab-org/gitlab@9fa609c7bd77d45cc9110e360ed9ce66b73e22d5) ([merge request](gitlab-org/gitlab!76405))
- [Add index to projects on marked_for_deletion_at field is null](gitlab-org/gitlab@cec0d009f73a4cc962b682c70ca444bcc47c76b8) ([merge request](gitlab-org/gitlab!75888))
- [Only enqueue Jira workers when configured](gitlab-org/gitlab@fd52c4350199b7867d02667c1b8b11a61dd86969) ([merge request](gitlab-org/gitlab!76134))
- [Add index to improve contribution graph query](gitlab-org/gitlab@6c5d441791191b69c5444cc6d1fd81891de57687) ([merge request](gitlab-org/gitlab!76081))
- [Simplify sanitizing emojis from localStorage](gitlab-org/gitlab@90467765284290ed68255a4feb883fc8ac956dc1) ([merge request](gitlab-org/gitlab!75011))
- [Optimize finding environment for BlobController](gitlab-org/gitlab@ed11580c047a0bdf92a176b88febf26a0a18f975) ([merge request](gitlab-org/gitlab!75518))
- [Improve index for calendar query](gitlab-org/gitlab@e37bd6155daa1b31c55170455054e9b3643c7feb) ([merge request](gitlab-org/gitlab!74970))
- [Replace Banzai based label rendering in VSA](gitlab-org/gitlab@c89bb6148a25ca563244d8675bcd049c46f33a3c) ([merge request](gitlab-org/gitlab!75415))
- [Bulk insert job tags when creating a CI pipelines](gitlab-org/gitlab@180b3ff3de375f504bfe227a57b9471daec37a9b) ([merge request](gitlab-org/gitlab!73198))
- [Enable load balancing for update all mirrors by default](gitlab-org/gitlab@df741a6f4e6c2d34c9893398cb6d945bf646914d) ([merge request](gitlab-org/gitlab!75335))
- [Avoid N+1 issue linking DAST profiles and builds](gitlab-org/gitlab@a85fff3be3327e23c037dddc3efc8336abbe6d24) ([merge request](gitlab-org/gitlab!74967)) **GitLab Enterprise Edition**
- [Reduce variables transformations when creating a new pipeline](gitlab-org/gitlab@119f1cd83e544c9850e592f44f1d36da8310f6bc) ([merge request](gitlab-org/gitlab!73378))
- [Replace Ci::Runner with linear scopes](gitlab-org/gitlab@af61def78729c50f86a481416ee26b3e56cd4d54) ([merge request](gitlab-org/gitlab!70385))
- [Enable perform FindTag RPC request for a single tag](gitlab-org/gitlab@6a46459420f4261085969de5b3d36ecc41c9884d) ([merge request](gitlab-org/gitlab!74802))
- [Use linear version of User#ci_owned_runners](gitlab-org/gitlab@a3454700d18eb04ed9dbc37c9af9b9b040611989) ([merge request](gitlab-org/gitlab!68848))
- [Remove trigram index on notes](gitlab-org/gitlab@2a6c75fa8a192dc54c1c558d332c5707559c6488) ([merge request](gitlab-org/gitlab!71982))

### Other (59 changes)

- [Use design system badge in admin project page](gitlab-org/gitlab@7503810f2db3c390d5e95f1930da16b61efd03b8) ([merge request](gitlab-org/gitlab!76775))
- [Fix GraphQL/OrderedArguments offense (Part 1/6)](gitlab-org/gitlab@9afc8328eb6baf5d0e20ab185d8bb40b5b6f44a9) by @KevSlashNull ([merge request](gitlab-org/gitlab!76023))
- [Fix GraphQL/FieldDefinitions offense (Part 2/4)](gitlab-org/gitlab@0f54a8b4664fe806791d7eac183bf2cec6019f4b) by @KevSlashNull ([merge request](gitlab-org/gitlab!76015))
- [Remove abort_deleted_project_pipelines flag](gitlab-org/gitlab@07e7c74bc9e5104f4faf15cb376a109b96cf8c87) ([merge request](gitlab-org/gitlab!76794))
- [Remove vulnerability_occurrences_location_temp_index](gitlab-org/gitlab@7630ce18b73aae7226a107c8db84ae81c92bf942) ([merge request](gitlab-org/gitlab!76749))
- [Snowplow ED first run for data-attributes](gitlab-org/gitlab@3e17fac17b3565e9f8096da7ceb9aafc06b2edf5) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/73809)) **GitLab Enterprise Edition**
- [Remove additional vulnerability finding links](gitlab-org/gitlab@9d6bea163af8987ca5915bd626dd4c1e62a44b22) ([merge request](gitlab-org/gitlab!76580))
- [Merge CI queuing denomalization feature flags into a single one](gitlab-org/gitlab@78556e3fce4ad3a9a37b41f3365feebb424fdd16) ([merge request](gitlab-org/gitlab!76543))
- [Fix Gitlab/DelegatePredicateMethods offenses](gitlab-org/gitlab@b861ed30fd8d05d3e5e776edfdee0e0ee8e0b532) by @edith007 ([merge request](gitlab-org/gitlab!76006)) **GitLab Enterprise Edition**
- [Delegate Requirement model attributes](gitlab-org/gitlab@058fd93adc3c69f4b15ab6bf9e33fdd7adcdb448) ([merge request](gitlab-org/gitlab!74296)) **GitLab Enterprise Edition**
- [Use rails helper to render mark_for_deletion badge](gitlab-org/gitlab@a3da5bdf4483b6de714c4f80cdede4387fc20619) ([merge request](gitlab-org/gitlab!76560)) **GitLab Enterprise Edition**
- [Delete invalid epic_issue records migration](gitlab-org/gitlab@66e146e010aa9d09dcb8d8eb0eb0cccfd19be0ce) ([merge request](gitlab-org/gitlab!73007))
- [Fix Gitlab/DelegatePredicateMethods offenses](gitlab-org/gitlab@595e28bfef06cb1e061865c84da23151b6eea364) by @edith007 ([merge request](gitlab-org/gitlab!76002))
- [Fix Gitlab/DelegatePredicateMethods offenses](gitlab-org/gitlab@810cbc51291d251d8358fb085e9106e721c87e7b) by @edith007 ([merge request](gitlab-org/gitlab!76003))
- [Fix Rails/SaveBang offenses](gitlab-org/gitlab@f57e94cbe63a40e2f0306bf14c5025fd6e679be2) by @edith007 ([merge request](gitlab-org/gitlab!75971))
- [Make projects storage badge pajamas compliant](gitlab-org/gitlab@fc682a790b939fb72d4f635fbe61487836c53995) ([merge request](gitlab-org/gitlab!76548))
- [Fix Gitlab/DelegatePredicateMethods offenses](gitlab-org/gitlab@0cc1311f7fd74376b5988c7608e2abca685ec09c) by @edith007 ([merge request](gitlab-org/gitlab!76004)) **GitLab Enterprise Edition**
- [Make milestone page tabs Pajamas-compliant](gitlab-org/gitlab@0fba9e9786654b66424c9fe67e1047ace417cb74) ([merge request](gitlab-org/gitlab!75944))
- [Implement syncing ci_project_mirrors and ci_namespace_mirrors tables](gitlab-org/gitlab@052dfa0564670a492b4336f6f3044b805fd90448) ([merge request](gitlab-org/gitlab!75517))
- [Convert single tab partial to Pajamas](gitlab-org/gitlab@6843ec6f72dc18623fc55cd1abe629ee071389d2) ([merge request](gitlab-org/gitlab!74010))
- [Fix Rails/SaveBang offenses](gitlab-org/gitlab@c75e847546eba8cbcecb5e4113d6ec39902866f3) by @edith007 ([merge request](gitlab-org/gitlab!75973))
- [Fix Rails/SaveBang offenses](gitlab-org/gitlab@011d417cf5791dbabab790766d3c570765d5b78b) by @edith007 ([merge request](gitlab-org/gitlab!75968)) **GitLab Enterprise Edition**
- [Fix Rails/SaveBang offenses](gitlab-org/gitlab@53709c45cf02f4d4fae68af3954a7f1a582eda7f) by @edith007 ([merge request](gitlab-org/gitlab!75951)) **GitLab Enterprise Edition**
- [Fix Rails/SaveBang offenses](gitlab-org/gitlab@abe38ad3834dea8ff5a438c33e2f731e2b8bedc0) by @edith007 ([merge request](gitlab-org/gitlab!75925)) **GitLab Enterprise Edition**
- [Remove ::VisibleApprovable inclusion as it's duplicate](gitlab-org/gitlab@56343658f2a84d950c3a36d1218147ce441ec50c) by @edith007 ([merge request](gitlab-org/gitlab!75886))
- [Pass formats explicitly when rendering .html format](gitlab-org/gitlab@f04e197f4ba199dcfba234a1197e994af1952e76) by @edith007 ([merge request](gitlab-org/gitlab!75785))
- [Apply feedback to Snowplow event definitions](gitlab-org/gitlab@149ee8761a4af6216d7af4938858db6fc0ea8cf2) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/73794)) **GitLab Enterprise Edition**
- [Hide search settings component in usage quota page](gitlab-org/gitlab@a37595f3a84c3731ff331365ca1e4b5fe123d7ee) ([merge request](gitlab-org/gitlab!75712)) **GitLab Enterprise Edition**
- [Fix Style/OpenStructUse offenses](gitlab-org/gitlab@4b68ce23b9debc8a95cebf791ac0db589ea9a13a) by @edith007 ([merge request](gitlab-org/gitlab!75215))
- [Fix Style/OpenStructUse offenses](gitlab-org/gitlab@4545f2fcc2f4de8831d4f26299f747082a91ae76) by @edith007 ([merge request](gitlab-org/gitlab!75222))
- [Fix Style/OpenStructUse offenses](gitlab-org/gitlab@0ab791aafb7a3f46c594cfc7b3064cadcf2053a3) by @edith007 ([merge request](gitlab-org/gitlab!75322))
- [Fix Style/OpenStructUse offenses](gitlab-org/gitlab@41337acd84caca36b67373ff9cc7fa9f46806165) by @edith007 ([merge request](gitlab-org/gitlab!75188))
- [Merge branch '341849_cleanup_reference_cache_memoization_ff' into 'master'](gitlab-org/gitlab@a60b2d4b3efae11f96c058d68707722fce346a26) ([merge request](gitlab-org/gitlab!74511))
- [Cleanup feature flag "reference_cache_memoization"](gitlab-org/gitlab@b5c7b417d508302c41d19cec82f6fa0066aa2a6f) ([merge request](gitlab-org/gitlab!74511))
- [Prepare projects and namespaces loose foreign keys](gitlab-org/gitlab@b6fb0d4adcf074f513b8f9d07f0718673f6a6a19) ([merge request](gitlab-org/gitlab!75559))
- [Fix Style/OpenStructUse offenses](gitlab-org/gitlab@76e531841335110535fe0c79850d0bba44a242ab) by @edith007 ([merge request](gitlab-org/gitlab!74957))
- [Fix Style/OpenStructUse offenses](gitlab-org/gitlab@444ad4234c90e04460d020a1169d3eec23e8adea) by @edith007 ([merge request](gitlab-org/gitlab!75281))
- [Merge maintain feature flags for new queuing mechanism](gitlab-org/gitlab@910bbbfab9ffb42c5e21c2c1fab17720a0401e65) ([merge request](gitlab-org/gitlab!75425))
- [Remove decoupling projects-runners feature flags](gitlab-org/gitlab@bb253ec5c91935ac95ad2a2fe4f1bf3f57a781ea) ([merge request](gitlab-org/gitlab!75422))
- [Fix Style/OpenStructUse offenses](gitlab-org/gitlab@a4afd6e3f4ec08f0eeb59e49796913b27400f303) by @edith007 ([merge request](gitlab-org/gitlab!75283))
- [Make design note pin compliant with Pajamas](gitlab-org/gitlab@6c7b826bf247a1d539ce5663f88d06db44765cb1) ([merge request](gitlab-org/gitlab!75004))
- [Remove the `validate_namespace_parent_type` feature flag](gitlab-org/gitlab@557963723100852b44e045f69bc1fea1b8d3089c) ([merge request](gitlab-org/gitlab!75088))
- [Fill TestReport#issue_id field when creating new objects](gitlab-org/gitlab@75dfe32cc737e491d07d01b8ab839f8598bab7bb) ([merge request](gitlab-org/gitlab!74923)) **GitLab Enterprise Edition**
- [Remove ci_predefined_vars_in_builder feature flag](gitlab-org/gitlab@31aa6433d2c639b57e106710b156c5f4f490da6f) ([merge request](gitlab-org/gitlab!75009))
- [Fix Style/OpenStructUse offenses](gitlab-org/gitlab@cbbbd0b8364e957e68f9e27d3cf550ae0d49af37) by @edith007 ([merge request](gitlab-org/gitlab!75186))
- [Make Service Desk Pajamas Design compliant](gitlab-org/gitlab@c9a40be04ec7bda0bb1c0c4df8237e97b9839b44) ([merge request](gitlab-org/gitlab!74795))
- [Improve Blame Page rendering performance](gitlab-org/gitlab@4bc4ddcf06603dbd13c2999a88f9594d182c9fa1) by @cyberap ([merge request](gitlab-org/gitlab!74799))
- [Fix OpenStruct use](gitlab-org/gitlab@d9819978c3fe6b05eff242b28356f7c6e3ffc56e) by @mehulsharma ([merge request](gitlab-org/gitlab!74976)) **GitLab Enterprise Edition**
- [Update GitLab Runner Helm Chart to 0.35.0](gitlab-org/gitlab@76424c1f1c7b9c38b0f6afa5c927c99a0a8e4678) ([merge request](gitlab-org/gitlab!74959))
- [Improve service desk service settings input tips](gitlab-org/gitlab@d8cbdf7c3e4c2efac0a2fc59bd05f3a8f9d35a78) ([merge request](gitlab-org/gitlab!73864))
- [Remove PropagateServiceTemplateWorker and queue](gitlab-org/gitlab@195ce97a5b804346478fe4f2c3599bc6aef71abe) by @lenikadali ([merge request](gitlab-org/gitlab!73387))
- [Remove unused CommitsBetween wrapper](gitlab-org/gitlab@2e417f1c037c6b80d20c5dc4c125ae18c5ba9100) ([merge request](gitlab-org/gitlab!74407))
- [Enhance SSO enforcement warning message](gitlab-org/gitlab@d8c31664f415bac0bbffd34df95a21ffbeb34df7) ([merge request](gitlab-org/gitlab!73233)) **GitLab Enterprise Edition**
- [Fix offenses introduced by Style/OpenStructUse](gitlab-org/gitlab@6d4208b2310243041e49fa912635383d8cadb87b) by @edith007 ([merge request](gitlab-org/gitlab!74203))
- [Fix OpenStruct use](gitlab-org/gitlab@6bc58b036b77051ffb3c708fbf958fdf5195b815) by @mehulsharma ([merge request](gitlab-org/gitlab!74412))
- [Fix OpenStruct use](gitlab-org/gitlab@dfaa8a393685edb8fdda33803c7df2e8917c3387) by @mehulsharma ([merge request](gitlab-org/gitlab!74421))
- [Fix OpenStruct use](gitlab-org/gitlab@60451303098187cb922d29c9088a3e74892aa0d7) by @mehulsharma ([merge request](gitlab-org/gitlab!74618))
- [Fix OpenStruct use](gitlab-org/gitlab@f8466f5943a1afeabaf9cf781f7804a8df515a0e) by @mehulsharma ([merge request](gitlab-org/gitlab!74702))
- [Update Sidekiq to 6.3.1](gitlab-org/gitlab@22e8bc0af656717e56428a7227c467fe08021c66) ([merge request](gitlab-org/gitlab!73973))

## 14.5.4 (2022-02-03)

### Security

See https://about.gitlab.com/releases/2022/02/03/security-release-gitlab-14-7-1-released/

## 14.5.3 (2022-01-11)

No changes.

## 14.5.2 (2021-12-03)

No changes.

## 14.5.1 (2021-12-01)

### Fixed (4 changes)

- [Check validation for license only if new record](gitlab-org/gitlab@3e34c2dc431a2b1c1828f5154a4d2be350359b16) ([merge request](gitlab-org/gitlab!75498)) **GitLab Enterprise Edition**
- [Fix for hexadecimal branch deletion](gitlab-org/gitlab@eb74cd44edac0c16c44aa11d710b742586c31741) ([merge request](gitlab-org/gitlab!75498))
- [Fix the SSL_CERT_DIR logging on git operations](gitlab-org/gitlab@6ef3b63ad5e58baa0e0e0a922fe43a2fb4494508) ([merge request](gitlab-org/gitlab!75498))
- [Support Action Cable on GCP Memorystore](gitlab-org/gitlab@d62aa5bcbad5851209a9d248ca267d0c46d1e7c9) ([merge request](gitlab-org/gitlab!75498))

## 14.5.0 (2021-11-19)

### Added (113 changes)

- [Show warning for markdown structure changes](gitlab-org/gitlab@9b44058536cff8e36996dc04820636a3c39cef2f) ([merge request](gitlab-org/gitlab!71064))
- [Implement Pipeline Editor Walkthrough experiment](gitlab-org/gitlab@2ab23a789a355eb2f1a923b263f2194f72665b5f) ([merge request](gitlab-org/gitlab!73050))
- [Add endpoint for activating all pending members](gitlab-org/gitlab@fb949a578e625f21242fccf20ad8883efb425e56) ([merge request](gitlab-org/gitlab!73849)) **GitLab Enterprise Edition**
- [Add Yaml Source Editor Extension](gitlab-org/gitlab@fe4f8022b129997263cc3e26c597b4c77df878a7) ([merge request](gitlab-org/gitlab!72764))
- [Introduced the Source Editor Instance module](gitlab-org/gitlab@7dbdf10e35cf793e0219344d0830dfcbb229667d) ([merge request](gitlab-org/gitlab!74566))
- [Add total counters in each runner type tab](gitlab-org/gitlab@b852ba5b2da2cabae8eaf5bf1f4f9b950b0576de) ([merge request](gitlab-org/gitlab!74196))
- [Add customer relations organizations viewer](gitlab-org/gitlab@9db2c7fef64053f78eebbc6bf12978ca46d08979) by @leetickett ([merge request](gitlab-org/gitlab!73508))
- [Add customer relations contacts viewer](gitlab-org/gitlab@22a90aa556d503e617b22a8795754197a807dab1) by @leetickett ([merge request](gitlab-org/gitlab!73429))
- [Add endpoint for activating an waiting member](gitlab-org/gitlab@c9857c9dc7f3196ee14f9ff40bd3bc8a4382329e) ([merge request](gitlab-org/gitlab!73845)) **GitLab Enterprise Edition**
- [Add keyset pagination for tags API](gitlab-org/gitlab@e9c3b012dcba273ec9eb2c5aaa4c8163d295cd9a) ([merge request](gitlab-org/gitlab!74239))
- [Enable loose_foreign_key_cleanup FF by default](gitlab-org/gitlab@8e8864cf97eae6f3e9d8bd1187d743d88f243fe9) ([merge request](gitlab-org/gitlab!74499))
- [Allow reporters to see the service desk email address](gitlab-org/gitlab@b12fcd0eccdc9fc66ec0647d7939eb53310a374d) ([merge request](gitlab-org/gitlab!74179))
- [Upgrade GitLab Pages to 1.48.0](gitlab-org/gitlab@a8e068be055bc0bb5805321b175dc6f70278461b) ([merge request](gitlab-org/gitlab!74483))
- [Implement deep linking for project VSA filters](gitlab-org/gitlab@cd4c047cc1c70529c2782b89f5bc9662b8978445) ([merge request](gitlab-org/gitlab!72777))
- [Feature: Let OmniAuth support DingTalk](gitlab-org/gitlab@b1999a4b44c0e6fb2290a4386d7cd0d6a0f0f953) by @icbd ([merge request](gitlab-org/gitlab!72071))
- [Add group SAML configuration changes to group audit events](gitlab-org/gitlab@490388aa861ef9e1a1779f88653e2706739f6fcf) ([merge request](gitlab-org/gitlab!73656)) **GitLab Enterprise Edition**
- [Add migration for backfilling project namespaces](gitlab-org/gitlab@6af415608ee18595c057f977cea2cc263eb344f2) ([merge request](gitlab-org/gitlab!72527))
- [Audit changes to compliance frameworks](gitlab-org/gitlab@77d672bb1177b59c7b62a41a49b018ac5048c9be) ([merge request](gitlab-org/gitlab!74292)) **GitLab Enterprise Edition**
- [Enable dependency_proxy_manifest_workhorse by dflt](gitlab-org/gitlab@8f22a47b4176c13bf7f39e11df1bef93cfcd73b7) ([merge request](gitlab-org/gitlab!73770))
- [Upgrade GitLab Pages to 1.47.0](gitlab-org/gitlab@a2cf642816798d61d244a588a6f969c54c776c51) ([merge request](gitlab-org/gitlab!74280))
- [Add exists support to includes:rules CI config](gitlab-org/gitlab@c73f2fd42120fb6104e8e29f8de6de12d503eb18) ([merge request](gitlab-org/gitlab!71745))
- [Enable configure_iac_scanning_via_mr by default](gitlab-org/gitlab@86d830fa9345b17cd86a1e5878a4c0ed7ec711b3) ([merge request](gitlab-org/gitlab!73268))
- [Allow Minimal Access role for top-level SAML Group Links](gitlab-org/gitlab@2b2a80a2c0ffb36ce32339521294ef335410c0cd) ([merge request](gitlab-org/gitlab!72825)) **GitLab Enterprise Edition**
- [Add slash command to promote issue to incident](gitlab-org/gitlab@9a27a599a83ff0af1006be31d00ab4c6579da579) ([merge request](gitlab-org/gitlab!73992))
- [Add member approval service](gitlab-org/gitlab@5fcbee2d37cf1243232f672ddbb7e849fa1ad044) ([merge request](gitlab-org/gitlab!73483)) **GitLab Enterprise Edition**
- [Enable linear GroupPlanPreloader ancestors queries](gitlab-org/gitlab@6905dd1c49c1b045cb555bcb1ea23e72f435d325) ([merge request](gitlab-org/gitlab!72594)) **GitLab Enterprise Edition**
- [Create default merge commit message using customizable template](gitlab-org/gitlab@61729d8adb84b735feac21ab4213786408b4e05a) by @trakos ([merge request](gitlab-org/gitlab!64437))
- [GithubImporter: Thread diff notes](gitlab-org/gitlab@2b6b33c4bf0a5c18905e556edcf9510f315bda74) ([merge request](gitlab-org/gitlab!73595))
- [Query all partitions when loading loose FK records](gitlab-org/gitlab@44af21f9488cb99dfd4c646408a5ec420e29cf45) ([merge request](gitlab-org/gitlab!74072))
- [Remove flag that hides event streaming from graphQL schema](gitlab-org/gitlab@eba5b07100d5255d250137ed1f8f356fca70664f) ([merge request](gitlab-org/gitlab!74092)) **GitLab Enterprise Edition**
- [Add opensource plan to database](gitlab-org/gitlab@1e8248435b2d9a447cbb268cc66f43ca75a983f9) ([merge request](gitlab-org/gitlab!73925))
- [Add wiki migration to projects and groups](gitlab-org/gitlab@9acfe49a03331800cbc2aaeb5ced38341471f788) ([merge request](gitlab-org/gitlab!72146)) **GitLab Enterprise Edition**
- [Send invite team email after a root group is created](gitlab-org/gitlab@e5f31632956ab62f37850c676cd2ee3d84f3c689) ([merge request](gitlab-org/gitlab!72470))
- [Render inherited templates from group in service desk](gitlab-org/gitlab@9887a3617731374cea9ef4599bb75f4d2325e6a6) ([merge request](gitlab-org/gitlab!71176))
- [Add indexes to aggregated VSA tables](gitlab-org/gitlab@3e11d29f59fd08d1ffbf23de6665890cf3e788a9) ([merge request](gitlab-org/gitlab!73427))
- [Add required label to tag name in release form](gitlab-org/gitlab@9d268fe047e9c20a5bf3a6bf651c1bb1e98276e5) ([merge request](gitlab-org/gitlab!73759))
- [Add modal to warn group owners the impact of changing user cap](gitlab-org/gitlab@16b44b500f2394578d9c4e78d2561fa36d3405bf) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/72805)) **GitLab Enterprise Edition**
- [Add issues set crm contacts service and graphql mutation](gitlab-org/gitlab@6b0c5e6ccbc849ecc65a8fe3a704b06407e54f39) by @leetickett ([merge request](gitlab-org/gitlab!72686))
- [Add pagination support for FindAllTagsRequest](gitlab-org/gitlab@440c1357fcea2a3fd1b61a33c7db97d21ebc2c7e) ([merge request](gitlab-org/gitlab!70199))
- [Enable linear ancestors for groups](gitlab-org/gitlab@524d55023cd37cd8697bd5b97c619c4d49ff006f) ([merge request](gitlab-org/gitlab!72490))
- [Add note regarding topic visibility to admin doc](gitlab-org/gitlab@5ae0eb97ec6f1108836f472d9484c1a037b8d02a) by @wwwjon ([merge request](gitlab-org/gitlab!73934))
- [Track Shared Runners duration separate from CI minutes consumption](gitlab-org/gitlab@2d79fae14d5584a6885da4585bfab7b033e75ea9) ([merge request](gitlab-org/gitlab!73933)) **GitLab Enterprise Edition**
- [Show blocked icon on epic blocked issues](gitlab-org/gitlab@12a16d1895afd13687c0c78b714beb0ea6dd940a) ([merge request](gitlab-org/gitlab!72229)) **GitLab Enterprise Edition**
- [Add Sentry configs to application  settings](gitlab-org/gitlab@8b15bbbd5acf1537c7d2516b592a3d81ed7b6454) ([merge request](gitlab-org/gitlab!73381))
- [Add helpful text to project select modal](gitlab-org/gitlab@3d3dbe631de4a6d8633fe77e76033f853c8c8df5) ([merge request](gitlab-org/gitlab!73766))
- [Enable linear ApplicationSettings ancestors queries](gitlab-org/gitlab@6ab1a7ae58ba829700230f8016db6ee8c39c0855) ([merge request](gitlab-org/gitlab!72500)) **GitLab Enterprise Edition**
- [Enable pipeline_editor_mini_graph feature flag by default](gitlab-org/gitlab@779b703805f0dc5aa7bbcf13b075738f158b9b03) ([merge request](gitlab-org/gitlab!73612))
- [Limit issues one user can quickly create using service desk](gitlab-org/gitlab@cdbd23328c311270873dbab346c322c494edb43f) ([merge request](gitlab-org/gitlab!73346))
- [Add Helm metadata to GraphQL](gitlab-org/gitlab@2b58d6ccd253e73fdbed3d4892ff28e8ecee1f37) by @sathieu ([merge request](gitlab-org/gitlab!71963))
- [Enable linear EE Group ancestors queries](gitlab-org/gitlab@d2cf27b20fbf7dcd6ae80c2d4848694015426fd3) ([merge request](gitlab-org/gitlab!73532)) **GitLab Enterprise Edition**
- [Remove redundant index_events_on_target_type_and_target_id](gitlab-org/gitlab@7c3d5fb203591cbb6cb6ef8833965ea394b960e2) ([merge request](gitlab-org/gitlab!73712))
- [Rollout user namespace & project tracking](gitlab-org/gitlab@57c880783d323587b1b38f38f97ecdcbce38a3b6) ([merge request](gitlab-org/gitlab!73677))
- [Unblock LDAP blocked user on sign-in with other auth methods](gitlab-org/gitlab@8190473e461f1bf0409108082701d073def1be03) ([merge request](gitlab-org/gitlab!73471))
- [Add queuing mechanic for reindexing](gitlab-org/gitlab@446ebbc9549c6f00529e2238d2b1adc1734968e3) ([merge request](gitlab-org/gitlab!73480))
- [Topic management: add link to topic detail page](gitlab-org/gitlab@db82cd254c0667a8fd9bcb0c762dfb7c14767a82) by @wwwjon ([merge request](gitlab-org/gitlab!73648))
- [Add jobArtifacts to PipelineType](gitlab-org/gitlab@22787ff46e8a5935a9904167fdc5c758372c8390) by @genctys ([merge request](gitlab-org/gitlab!72412))
- [Track processed loose FK records](gitlab-org/gitlab@dac93679a0374abbd138263d545f1db7c06fb422) ([merge request](gitlab-org/gitlab!73541))
- [Update user attributes for Group SAML enterprise users](gitlab-org/gitlab@d1db69ca88fc8fe78b3e6626e55e503bbbeee7ce) ([merge request](gitlab-org/gitlab!72792)) **GitLab Enterprise Edition**
- [Add 'show' page for topic](gitlab-org/gitlab@3b325e920700a30e6cda601462fcce1e87ab6614) by @wwwjon ([merge request](gitlab-org/gitlab!71830))
- [Record transaction duration during migrations](gitlab-org/gitlab@3afb6966876aaa3738b13524ea3406cd93e070fa) ([merge request](gitlab-org/gitlab!72181))
- [Add corpus create mutation and service](gitlab-org/gitlab@07e6c2ebee1c9d02e5bb9c5396b8dc65306f1bb4) ([merge request](gitlab-org/gitlab!71992)) **GitLab Enterprise Edition**
- [Update scroll position to synchronize the Jump To Next button](gitlab-org/gitlab@65e7685f25228dd1aa9eef7c86c3492503f33340) ([merge request](gitlab-org/gitlab!71508))
- [Add created_at to the GraphQL LicenseType](gitlab-org/gitlab@53256ffebba0a407c1219e11f2ad6805f7f3c026) ([merge request](gitlab-org/gitlab!72905)) **GitLab Enterprise Edition**
- [Speed up searching environments by ref deployed](gitlab-org/gitlab@3dac2744978d1e60e625a73756011277ce3de51d) ([merge request](gitlab-org/gitlab!72781))
- [Add customer relations menu item and root apps](gitlab-org/gitlab@5bcce5792a2aa237e3004f12ace933bec4535885) by @leetickett ([merge request](gitlab-org/gitlab!72787))
- [Enable linear ParticipantsService ancestors queries](gitlab-org/gitlab@e910d9e20b0399075fdb5c3185e92030af4adeec) ([merge request](gitlab-org/gitlab!72593))
- [Enable linear MembersFinder ancestors queries](gitlab-org/gitlab@9af3cdf155b92a90ab067177ba0a8153da085826) ([merge request](gitlab-org/gitlab!72592))
- [Promote empty_repo_upload experiment](gitlab-org/gitlab@396f2c495369c354f6d4d8f76a2922c9920ebac0) ([merge request](gitlab-org/gitlab!73111))
- [Adding Special diff rendering for .ipynb notebooks](gitlab-org/gitlab@46a0f612b0d4cefb8ebdfa93864622ea0b94b727) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/71477))
- [VSA: Add deployment frequency links](gitlab-org/gitlab@fb9c7aaa932c11a25b9c914a0992f75c805a685c) ([merge request](gitlab-org/gitlab!72485)) **GitLab Enterprise Edition**
- [Enables the mr_changes_fluid_layout flag by default](gitlab-org/gitlab@0f3a585321a79df4925477157613d4ce49fc2842) ([merge request](gitlab-org/gitlab!73261))
- [Adds vulnerability state to Vulnerability-Check](gitlab-org/gitlab@586e14b7462ce11bf69ef233279f9875caa5e73b) ([merge request](gitlab-org/gitlab!72405))
- [Enable logging of Sidekiq bulk job insertions](gitlab-org/gitlab@4fea71a9a5da31c3fa049cb578f7a7c48c734d45) ([merge request](gitlab-org/gitlab!73223))
- [Remove group_authorized_agents feature flag](gitlab-org/gitlab@a8cb522b6b0ab8d9d46c288d6988712e90530b65) ([merge request](gitlab-org/gitlab!71441))
- [Add Prometheus metrics for loose foreign keys](gitlab-org/gitlab@3076b64925711a2900110ddd63e45a660b6b9537) ([merge request](gitlab-org/gitlab!73192))
- [Include state_id when gathering VSA data](gitlab-org/gitlab@f576360f0921ac39b827463985a94797fae729af) ([merge request](gitlab-org/gitlab!72974))
- [Loose foreign key definition experiment](gitlab-org/gitlab@d906530828b3045b0449a1ff4a8213f0571342ce) ([merge request](gitlab-org/gitlab!73146))
- [Enable real-time issue assignees by default](gitlab-org/gitlab@099f9e0e513190bed76863dd6af1dbae6591a8f4) ([merge request](gitlab-org/gitlab!71953))
- [Feature: add user track script entry point](gitlab-org/gitlab@697834c6e26857cda5e66efa069a12cd3408fd24) by @orozot ([merge request](gitlab-org/gitlab!73097))
- [Fix spec to properly support many databases](gitlab-org/gitlab@3bdf92cb1ceefd0969025bf17a0f042dffa9cbca) ([merge request](gitlab-org/gitlab!70063))
- [Enable group-level MR approval settings by default](gitlab-org/gitlab@b20b34405af236b1b2e8b334466224e3c7055095) ([merge request](gitlab-org/gitlab!73058)) **GitLab Enterprise Edition**
- [Enable linear GroupTree ancestors queries](gitlab-org/gitlab@a532cfbde60dab31467cff218db51d9178de9484) ([merge request](gitlab-org/gitlab!72494))
- [Annotate DAST models strings for localization](gitlab-org/gitlab@f85a7cbb5a358dfd2d4c5a4b9385c3ab0e50458f) ([merge request](gitlab-org/gitlab!72799)) **GitLab Enterprise Edition**
- [Persist credit card network](gitlab-org/gitlab@44a6f14acf300e6d7ed18d6c1b417cb34a4ebf5a) ([merge request](gitlab-org/gitlab!72272))
- [Adds DB column for merge request assignee state](gitlab-org/gitlab@11cf2cd3c5c5d01f29ba55dc3cc305782cdcb1e7) ([merge request](gitlab-org/gitlab!72677))
- [Add native systemd units](gitlab-org/gitlab@857efa0d218a883a53c0f4075492d2f4af9a89ab) by @behrmann ([merge request](gitlab-org/gitlab!53847))
- [Clean up migration to populate commit users](gitlab-org/gitlab@9800171fc1aba6a3e5fd5e408b60bce82c4d3954) ([merge request](gitlab-org/gitlab!72219))
- [Enabled variables for CI services](gitlab-org/gitlab@a0b96c07d0fa21a88aaf36a752328a16cd6c54bf) by @ST-Apps1 ([merge request](gitlab-org/gitlab!72025))
- [Add runtime_runner_features column to ci_builds_metadata](gitlab-org/gitlab@1632f48e944728844e37514c531625d856e4bb27) ([merge request](gitlab-org/gitlab!72378))
- [Add metric for users associating group milestones to releases](gitlab-org/gitlab@5618ea7a90f2a74e1c548c9a570c3299aae35048) ([merge request](gitlab-org/gitlab!71650))
- [Loose foreign key worker implementation](gitlab-org/gitlab@1a1e4bdf8267aceee709c1d20509151ef8ab2366) ([merge request](gitlab-org/gitlab!69165))
- [Added kaniko ci template to build docker images](gitlab-org/gitlab@91a10b11726bb27d2652b4705a7b9e6b9db308dd) ([merge request](gitlab-org/gitlab!72400))
- [Invite members for task experiment](gitlab-org/gitlab@56afab221043f7199cb7de4b434ac6c0c2998988) ([merge request](gitlab-org/gitlab!69299))
- [Remove FF verification_state_backfill_worker](gitlab-org/gitlab@9726601c0273c7a30b223cbb6f7a26a42b204330) ([merge request](gitlab-org/gitlab!72762)) **GitLab Enterprise Edition**
- [Add 'tencent_serverless_framework' to built-in project template](gitlab-org/gitlab@69f2c1d5b641fee434fe65ae3e0ba3fe8b856b98) ([merge request](gitlab-org/gitlab!71458))
- [Merge branch 'mw/clearup-ff_group_membership_export' into 'master'](gitlab-org/gitlab@1222dd099b01226f05c92f9dbcde2c5207c5ba1c) ([merge request](gitlab-org/gitlab!72624)) **GitLab Enterprise Edition**
- [Allow custom support email without configuring custom project suffix](gitlab-org/gitlab@6bcf1b17da2e28ceb6bfa644d6643d52f3bb4f98) ([merge request](gitlab-org/gitlab!71940))
- [Add median lead time for changes to VSA](gitlab-org/gitlab@b26ee08d7910092308b429378aff7f84e69e8b6b) ([merge request](gitlab-org/gitlab!72283)) **GitLab Enterprise Edition**
- [Remove ff_group_membership_export flag](gitlab-org/gitlab@445a68ce019b072bc6268a4b141d90daa6b80a52) ([merge request](gitlab-org/gitlab!72624)) **GitLab Enterprise Edition**
- [Move Agent usage metrics to Core](gitlab-org/gitlab@ca2e56efc791c9e67ddc22e7c83faeea28383fd6) ([merge request](gitlab-org/gitlab!72086))
- [Enable Agent creation in Core](gitlab-org/gitlab@fc6adf3d27b048a0db8ee2c4524f9b5ade8e6504) ([merge request](gitlab-org/gitlab!71882))
- [Move Agent KUBECONFIG variable generation to core](gitlab-org/gitlab@0ee1914b42171a3b2ca6e5378103bb4513d6f2f9) ([merge request](gitlab-org/gitlab!72085))
- [Sync creating requirements with requirements issue](gitlab-org/gitlab@34449b20ccba8018d0427ed12ee55ebc70389923) ([merge request](gitlab-org/gitlab!71104)) **GitLab Enterprise Edition**
- [Add user caps to group's membership settings](gitlab-org/gitlab@365904e82491e027a22b1ea84e883795e8d8b387) ([merge request](gitlab-org/gitlab!72006)) **GitLab Enterprise Edition**
- [Remove the rails_apdex_counters feature flag](gitlab-org/gitlab@f8e5122d0178a701a0836ba99b6fc4e88739ad87) ([merge request](gitlab-org/gitlab!72427))
- [Add CustomerRelations::IssueContact model](gitlab-org/gitlab@5c6b2c4bc62826d7cbda4094637468fa63f30d77) by @leetickett ([merge request](gitlab-org/gitlab!72246))
- [Cleanup project_storage_ui feature flag](gitlab-org/gitlab@0438d9d77383a8456480c1050baf2e2f4cbba689) ([merge request](gitlab-org/gitlab!71270))
- [Add created_at filters to MR resolver](gitlab-org/gitlab@72d09bd815b1aaed8d5fc5d6e26c9f669669fbe0) ([merge request](gitlab-org/gitlab!72498))
- [Add integration with ZenTao](gitlab-org/gitlab@398fd4f01643aff08e579e1a83e8552f8b91575e) by @icbd ([merge request](gitlab-org/gitlab!69602))
- [Move Agent CI tunnel functionality to Core](gitlab-org/gitlab@eec9855d6869dc19858340bf1647156349324aa6) ([merge request](gitlab-org/gitlab!71972))
- [Add Debian endpoint for distribution key](gitlab-org/gitlab@dd0552011089b074b13c422f208ce35d6dfb31fb) by @sathieu ([merge request](gitlab-org/gitlab!71716))
- [Filter issues by releaseTag in GraphQL](gitlab-org/gitlab@df4fad342f1b120eafa636d8e43cd73e06d83844) ([merge request](gitlab-org/gitlab!71012))
- [Add 'Explore topics' page](gitlab-org/gitlab@745b7d7c7b45c7cc89c692359da4b71a58c42592) by @wwwjon ([merge request](gitlab-org/gitlab!62443))

### Fixed (123 changes)

- [Fix SAML SSO redirects for pseudonymized URLS](gitlab-org/gitlab@aa6f3db27821292fc072343cd0134e99f8eb93ba) ([merge request](gitlab-org/gitlab!74476))
- [Add suggestion_commit_message length validation](gitlab-org/gitlab@df22130968eae889cdf89d66fc7a10e58eabe79d) by @trakos ([merge request](gitlab-org/gitlab!74310))
- [GithubImporter: Fix import duration metric](gitlab-org/gitlab@4ef1a8e3865fd1ae76d1b9f52de3cd21944daa81) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/74610))
- [Fix a bug with the metadata during the npm package upload](gitlab-org/gitlab@ec6908c336bcaf7b2321715ae77aaad62752f0bb) ([merge request](gitlab-org/gitlab!74588))
- [Fix error when Origin header is null](gitlab-org/gitlab@969951adbc875a1c45f37e14ccdaf90489b4b50f) ([merge request](gitlab-org/gitlab!74581))
- [Fix loading authors in issues list](gitlab-org/gitlab@d23866a9d2f5f4b3b92ca1615a857b1464b4c515) ([merge request](gitlab-org/gitlab!74562))
- [Fix regression in code blocks in the Content Editor](gitlab-org/gitlab@fcc0f65481d30f4bedc6a3cd188316de7d14e00e) ([merge request](gitlab-org/gitlab!74520))
- [Fix sysvinit Sidekiq logging](gitlab-org/gitlab@6f7e676a346036f10753f9d5a5880c845e3c58bb) ([merge request](gitlab-org/gitlab!73850))
- [Fix setting block animation issues](gitlab-org/gitlab@88aff5d7d8afc417d37cc0166205df62508befe9) ([merge request](gitlab-org/gitlab!74411))
- [Remove presence validator on name on WebauthnRegistration](gitlab-org/gitlab@9c88b3ad8ac9728cc248dd9a4a2a84cbe74564d0) ([merge request](gitlab-org/gitlab!74376))
- [Fix common errors in AuthorizedProjectsWorker](gitlab-org/gitlab@3f8caeda714051e288b2346aa2beebab2450e602) ([merge request](gitlab-org/gitlab!74055))
- [Fix widget dropdown title overflow](gitlab-org/gitlab@7572bc6e5f2c4b9401dd1ce4bdbd77561b2826ea) ([merge request](gitlab-org/gitlab!74358))
- [Don't transform empty .ipynb diffs](gitlab-org/gitlab@a306f0f4cadf9fb2b40dd1ca84c39f7f051d83d6) ([merge request](gitlab-org/gitlab!74299))
- [Allow destruction of records in archived pending_delete projects](gitlab-org/gitlab@f8c6c9508346664157db3094ce8f2f1faef20a51) ([merge request](gitlab-org/gitlab!73863))
- [Allow to create service desk issues for all quoted emails](gitlab-org/gitlab@bcdf73f999c8ec6a9912594a7664081000964324) ([merge request](gitlab-org/gitlab!73397))
- [Fix bug due to fuzzy matching in Infrastructure Registry](gitlab-org/gitlab@5a4da09185c10915cb4e2e8e13c176a29233d145) ([merge request](gitlab-org/gitlab!73588))
- [Fix no repo error message for group-level wikis](gitlab-org/gitlab@f3a0725f2a599a53790d35fab011540e5d61f241) ([merge request](gitlab-org/gitlab!74133)) **GitLab Enterprise Edition**
- [Fix commit msg color for dark mode graph](gitlab-org/gitlab@533bc79998d58c21c99a224ec84c02202887720f) ([merge request](gitlab-org/gitlab!74050))
- [Fixes broken trigger layout](gitlab-org/gitlab@3941d96ac395b3e9accb6c0488ef86e9c12c7e64) ([merge request](gitlab-org/gitlab!74213))
- [Fix agent install page paths](gitlab-org/gitlab@6932f814a0a08ef5c232f5214829e3af1e2ef4be) ([merge request](gitlab-org/gitlab!74120))
- [Reduce noise in cluster cleanup workers](gitlab-org/gitlab@f3e541c092bd73b529b4f3e1b2b5f36f372b1004) ([merge request](gitlab-org/gitlab!74117))
- [Fix scoped board milestone/iteration Timebox global ID](gitlab-org/gitlab@a3569025baa1b7f42ef494ff651ac8f975dc435b) ([merge request](gitlab-org/gitlab!73875)) **GitLab Enterprise Edition**
- [Prevent overflowing of runner tags](gitlab-org/gitlab@38e06e46908256138c9aa696101e53e3aaee46dd) ([merge request](gitlab-org/gitlab!74071))
- [Fix manifest workhorse upload](gitlab-org/gitlab@a8545c048e70c17d08af62a65f6f50e14cc59eea) ([merge request](gitlab-org/gitlab!73810))
- [Extend the OverrideUuids service logic](gitlab-org/gitlab@942553b2b2b7e5cabdd29ed04d34fd0a72f55088) ([merge request](gitlab-org/gitlab!73563)) **GitLab Enterprise Edition**
- [Fix foreign_key  of using on data_fields](gitlab-org/gitlab@fc1244a50bc17b762a10ecb1f29c65fb06a43522) by @icbd ([merge request](gitlab-org/gitlab!73456))
- [Vulnerability Report: Fix typo in description text](gitlab-org/gitlab@ebb1d6293ec35767e5a6cb483469957a03c3af4b) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/74047)) **GitLab Enterprise Edition**
- [Fix built-in template import creating duplicate audit logs](gitlab-org/gitlab@e45a50039b18647a9c4b0c6a565adf02fb70b66f) ([merge request](gitlab-org/gitlab!73822)) **GitLab Enterprise Edition**
- [Fix merge requests not importing for older projects](gitlab-org/gitlab@49daa959ac0ac056d54ca965e4788b08a9c18378) ([merge request](gitlab-org/gitlab!74031))
- [Add sidebar highlight and fix link](gitlab-org/gitlab@927e921b1d3cc2231f9f38969e5abb5181c0d6a7) by @icbd ([merge request](gitlab-org/gitlab!73245))
- [Fix 2FA setup for LDAP users](gitlab-org/gitlab@c29aca2e77e42802b495f09066abbc6c8823486c) ([merge request](gitlab-org/gitlab!73538))
- [Recalculate project authorizations on group transfer](gitlab-org/gitlab@63ab878f71d374b657005058bed2c776c19a2632) by @vfazio ([merge request](gitlab-org/gitlab!72550))
- [Clear closure references when issue is reopened](gitlab-org/gitlab@06ae33b82e3b96e29a7ca3c60c2a139911c3b23f) ([merge request](gitlab-org/gitlab!73958))
- [Prevent Git operations from checking replication lag on non-Geo sites](gitlab-org/gitlab@369dbc7c2e0c0b8764b26b0f12dacac8b111050a) ([merge request](gitlab-org/gitlab!73952)) **GitLab Enterprise Edition**
- [Allow non-group Agent projects to authorize themselves](gitlab-org/gitlab@6a5201ede1bc5eef7e4403becd5e827c2eac9168) ([merge request](gitlab-org/gitlab!73917))
- [Vulnerability Modal: Fix issue with long URLs](gitlab-org/gitlab@5258a998fa4a1db5b03b8df3b876aa6518ae09eb) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/73713)) **GitLab Enterprise Edition**
- [Fix Type error about namespace through provides on members page](gitlab-org/gitlab@4597c630af4303aad371afbfd5a668039241ae68) ([merge request](gitlab-org/gitlab!73687))
- [Fix pipeline editor crashing the browser when getting a 500 error](gitlab-org/gitlab@6f7a848589b9547cfd63c040a9dfe01512f20d15) ([merge request](gitlab-org/gitlab!73861))
- [Reset subscription max seats used on new term](gitlab-org/gitlab@78dae45f419e989db38bf0282364a325ad11506f) ([merge request](gitlab-org/gitlab!73078)) **GitLab Enterprise Edition**
- [Fix issue rebalance banner](gitlab-org/gitlab@8383b1b19cabd99e02ba5247f0bd421989a527cf) ([merge request](gitlab-org/gitlab!73608))
- [Disable query cache when outside Rails executor](gitlab-org/gitlab@23152fd9f74f92ed6360dafbb074553c61af0450) ([merge request](gitlab-org/gitlab!73814))
- [Fix todo API when used with Alerts](gitlab-org/gitlab@d3e62ab765d2ce35105dd5e264e796be37459a75) ([merge request](gitlab-org/gitlab!73812))
- [Add remediation based on cve or id](gitlab-org/gitlab@84a557d426d78960fd5fcc01bbe9f4e16cf603e6) by @ssarka ([merge request](gitlab-org/gitlab!73581)) **GitLab Enterprise Edition**
- [Wrap Sidekiq scheduler threads in Rails reloader](gitlab-org/gitlab@7c2e4a6cabdc736c839d52bcdea45d653fe1ed42) ([merge request](gitlab-org/gitlab!73716))
- [Fix quick action permissions to match UI](gitlab-org/gitlab@8e85fac366e8d6e329ede3e616b35db7c788cec2) ([merge request](gitlab-org/gitlab!73710))
- [Skip retrying for reads on connection errors if primary only](gitlab-org/gitlab@7d0c81a7576fe7a8fc5d926346c8635c0504a245) ([merge request](gitlab-org/gitlab!73715))
- [Fix illustration paths in survey response page](gitlab-org/gitlab@e9f76ac046a897b6e1fa4193772ec6bb896e4887) ([merge request](gitlab-org/gitlab!73705)) **GitLab Enterprise Edition**
- [Fix MR commits with missing committers/authors](gitlab-org/gitlab@9b553e50f3add5c638fc79c62cbe07f5be991d5f) ([merge request](gitlab-org/gitlab!73307))
- [Fix: update broken pipeline layout](gitlab-org/gitlab@af0a80f94d8b9ad1a815dd336f7bb43cd25ddf6e) ([merge request](gitlab-org/gitlab!73477))
- [Use the To header when sending pipeline emails](gitlab-org/gitlab@3b5330e9bcf66d7f66ff5b51dbb60adcf2197f67) ([merge request](gitlab-org/gitlab!73363))
- [Cleanup sticky_environments_in_job_retry feature flag](gitlab-org/gitlab@a4e3412d88e7feb4def05b253aef7f760d0cbaf4) ([merge request](gitlab-org/gitlab!73606))
- [Improve tracking of requests in rate limiter](gitlab-org/gitlab@7c3c7942b3570672dadfe6858317c0fe537a29f4) ([merge request](gitlab-org/gitlab!73343))
- [Check correct permissions before showing Release Evidence link](gitlab-org/gitlab@dffa6549fdb8fe1abd092ba531c476eea02f5367) ([merge request](gitlab-org/gitlab!73574))
- [Fix ghost button on payment step for subscriptions](gitlab-org/gitlab@ae7bd2c62116008240278e6bf33e5fd497ceda87) ([merge request](gitlab-org/gitlab!73293)) **GitLab Enterprise Edition**
- [Allow SSO callbacks through maintenance mode](gitlab-org/gitlab@b59f528b254d6b40d62dace7c78416237db5d102) ([merge request](gitlab-org/gitlab!73550)) **GitLab Enterprise Edition**
- [Fix error on environment rollback](gitlab-org/gitlab@bdd4abadb56c417f31841e6fcc0804bed0f0d196) ([merge request](gitlab-org/gitlab!73473))
- [Fix permission check for confidential quick action](gitlab-org/gitlab@561f4402419cf535d97b16331439e0a71cfe68b6) ([merge request](gitlab-org/gitlab!73515))
- [Fix Geo: Secondaries may be orphaning Upload files](gitlab-org/gitlab@d4e54efcfe1d9fbdcb24e7bc6cd4fb0ea1861988) ([merge request](gitlab-org/gitlab!69763)) **GitLab Enterprise Edition**
- [Add better error handling to BulkImports::GroupLoader](gitlab-org/gitlab@b470e9bbe761094f4d90f200dd58def3837014ed) ([merge request](gitlab-org/gitlab!73191))
- [Ensure that GlSingleStat animates](gitlab-org/gitlab@1402f8303ac1a5582ce405d6bb53af8c09c50b61) ([merge request](gitlab-org/gitlab!72759))
- [Fix tasklist header counts in Test Cases](gitlab-org/gitlab@0303c8b1322093c0d8f26bb8ef079f5a78772411) ([merge request](gitlab-org/gitlab!73453)) **GitLab Enterprise Edition**
- [Allow relative WebP image embed in markdown](gitlab-org/gitlab@9d9618fc821f12d1441b668e8f6ce7ae0cd6ca4b) by @KevSlashNull ([merge request](gitlab-org/gitlab!73426))
- [Fix uninitialized constant STICK_OBJECT](gitlab-org/gitlab@be042a560485a17907613828147981b675255060) by @leetickett ([merge request](gitlab-org/gitlab!73405))
- [Increase file import size validator timeout](gitlab-org/gitlab@d7bbc0784a5badf2c3810d5f3b209e94437c55b3) ([merge request](gitlab-org/gitlab!73400))
- [Fix breadcrumb click event handling](gitlab-org/gitlab@5d05b3d8a5c688ec06d63b252d373ed3b64cf336) ([merge request](gitlab-org/gitlab!73287))
- [Do not update feedback when it is persisted](gitlab-org/gitlab@18861c4269a6d246f777e63c99c42ef27bc73e58) ([merge request](gitlab-org/gitlab!73311)) **GitLab Enterprise Edition**
- [Increase the deduplication TTL for future jobs](gitlab-org/gitlab@24318caeb54f6479e2aafe3c46c1c7e3a2694743) ([merge request](gitlab-org/gitlab!73257))
- [Fix filtering of "Not connected" runners](gitlab-org/gitlab@e4ccc98de6febe9f550c53a5c7207523e446a4e1) ([merge request](gitlab-org/gitlab!73292))
- [Exclude project bots from deactivation in DeactivateDormantUsersWorker](gitlab-org/gitlab@7320c15f48c10ea67979dbe26cb50179cfe7eabf) ([merge request](gitlab-org/gitlab!73028))
- [Fix 2FA management on Safari](gitlab-org/gitlab@65389a3bafd68315abe54e09ab081e64fea5656a) ([merge request](gitlab-org/gitlab!73218))
- [Fix slight scroll bounce when jumping between unresolved discussions](gitlab-org/gitlab@78cd69f9013aa77a4c5e28a7f12cc62f6d8ce36e) ([merge request](gitlab-org/gitlab!73281))
- [Don't limit number of Gitaly client keepalives](gitlab-org/gitlab@4636ed9bdeab3f3a664c52e8876b17391c0bbc19) ([merge request](gitlab-org/gitlab!73302))
- [Silence unknown PostgreSQL OIDs warnings](gitlab-org/gitlab@71917b7313e7232a623a52f5ebbedf7936790f7e) ([merge request](gitlab-org/gitlab!73244))
- [Do not auto-retry unrecoverable job failure](gitlab-org/gitlab@f049bb62c76a6192136fc45f4e8516812c53cb13) ([merge request](gitlab-org/gitlab!73150))
- [Fix: filename display when copy/paste in comment](gitlab-org/gitlab@f4737a3a585d2e205bca19e5b3ba3f2d5a7e344d) by @orozot ([merge request](gitlab-org/gitlab!72878))
- [Do now unescape branch name when deleting branch](gitlab-org/gitlab@f3e44598b1a9e06fc93a6ec58c0acb3b89c5a1fc) ([merge request](gitlab-org/gitlab!73253))
- [Enable surface_environment_creation_failure feature flag by default](gitlab-org/gitlab@82a474083a87962473a45bd25bab8bd0ed6af7e1) ([merge request](gitlab-org/gitlab!72194))
- [Prevent timeouts when updating `share_with_group_lock` of a group](gitlab-org/gitlab@2dfecc4fa25ed9b87ca4fc8dc45ba4bbb6a32a96) ([merge request](gitlab-org/gitlab!72955))
- [Fix epic board scope text](gitlab-org/gitlab@aec0eb917ad7c9165cd23097012e33b28bb304c0) ([merge request](gitlab-org/gitlab!73234))
- [Standardize error message field in structured logs](gitlab-org/gitlab@400dd57ba4207079d70b9b0fcd509297b2b5da3a) ([merge request](gitlab-org/gitlab!73196))
- [Make `LoadBalancer` to configure pool sizes of all classes](gitlab-org/gitlab@fcc216a23746cfa52ba86a869f26e0a2c40fb8f0) ([merge request](gitlab-org/gitlab!72989))
- [Sort epic ancestors in hierarchical order in graphQL endpoint](gitlab-org/gitlab@758d5a3738d85677f45b8e988514b7a06c82dee0) ([merge request](gitlab-org/gitlab!72811)) **GitLab Enterprise Edition**
- [Fix cascading settings attr reader behavior](gitlab-org/gitlab@f7c013d8931d84dba719cd929147dfa9f3b578f5) by @gizero ([merge request](gitlab-org/gitlab!72962))
- [Don't fail DeleteStoredFilesWorker if one of the files is missing](gitlab-org/gitlab@7915af8aae24a76586a43eaf08e68de3677d11e1) ([merge request](gitlab-org/gitlab!73084))
- [Schedule AutoFix background job after ingesting the security reports](gitlab-org/gitlab@f496649ec5100ebda2933ca4d0693f1fe8b45df4) ([merge request](gitlab-org/gitlab!72957)) **GitLab Enterprise Edition**
- [Move yaml processor secrets configuration to EE](gitlab-org/gitlab@80adf2e64a5b547925398f123a20528876e7cfa3) ([merge request](gitlab-org/gitlab!73017)) **GitLab Enterprise Edition**
- [Remove the pipelines link from Auto DevOps toast](gitlab-org/gitlab@0c144e2ff0c51c9d47ca3b880a3cbce60882bf7f) ([merge request](gitlab-org/gitlab!73054))
- [Fix 'private method 'load' called' when posting non-whitelisted webhook](gitlab-org/gitlab@0fcfb496c725d3c87f888474378c04bb7de281bf) by @perlun ([merge request](gitlab-org/gitlab!72672))
- [Change manage events metric counter method](gitlab-org/gitlab@e8e0288768709f812f12cdb2fae13c82ada96529) ([merge request](gitlab-org/gitlab!72975))
- [Fix `canUpdate` console error on external issues](gitlab-org/gitlab@e093779ae951f21359966475a9bfdcb21326f244) ([merge request](gitlab-org/gitlab!72950)) **GitLab Enterprise Edition**
- [Show captcha verification on issue boards](gitlab-org/gitlab@fddd98bf2fd70ca2591e16259558d8ae488de155) ([merge request](gitlab-org/gitlab!72818))
- [Fix error when archiving requirements](gitlab-org/gitlab@500cef40295d5158d4a16847cbe22c2ab645d411) ([merge request](gitlab-org/gitlab!73010)) **GitLab Enterprise Edition**
- [Persist solution, message and description fields](gitlab-org/gitlab@ed62453626233c9c411648acb72d7ccf82270fd8) ([merge request](gitlab-org/gitlab!72883)) **GitLab Enterprise Edition**
- [Skip st_diff setting on LegacyDiffNote during import](gitlab-org/gitlab@e2c6b1390b0e4d17fbe9924dc619a3545905c6db) ([merge request](gitlab-org/gitlab!72897))
- [Use `overridden_uuid` as primary lookup for the report finding](gitlab-org/gitlab@643582f6c1b0e70f823938f2e0ec481406ef1c58) ([merge request](gitlab-org/gitlab!72835)) **GitLab Enterprise Edition**
- [Remove duplicate text from create group description](gitlab-org/gitlab@1467e1d396beb37032566cba8c2ca8556c3f5e96) ([merge request](gitlab-org/gitlab!72954))
- [Add reschedule option to Resource Group worker](gitlab-org/gitlab@63cc19469b1d7fd2085cc78efc76cbc46850ef66) ([merge request](gitlab-org/gitlab!72961))
- [Fix SMIME signature for emails on push](gitlab-org/gitlab@20439de242730db94622f1cf92ad2a6cac159ecd) ([merge request](gitlab-org/gitlab!72956))
- [Fix error 500 loading branch with UTF-8 characters with performance bar](gitlab-org/gitlab@cbbe03492b18ee07901bde5f055c2b4cd0a00a44) ([merge request](gitlab-org/gitlab!72925))
- [Fix file mode changes not always visible in MRs](gitlab-org/gitlab@3fbaa336ea9f8a54df8f41bfd0e63b504dc25eaf) by @hypemc ([merge request](gitlab-org/gitlab!72937))
- [Allow job token to perform all release REST API operations](gitlab-org/gitlab@3cea963ff14e61f60fe9fff45d81fd3bdbd39d1d) by @guillaume.chauvel ([merge request](gitlab-org/gitlab!72448))
- [Fix 2+ discussions on one line not working](gitlab-org/gitlab@b6a340c9cd8dccebcb0f165d5757b536506423b2) ([merge request](gitlab-org/gitlab!72915))
- [Fix issues with frame-src CSP directive](gitlab-org/gitlab@ee10fb1e26b51b91befa68a19b537986b365f957) ([merge request](gitlab-org/gitlab!72830))
- [Fix shared runners form injections](gitlab-org/gitlab@467733230658dcc101ae5c60f9b11bcd5592c866) ([merge request](gitlab-org/gitlab!72907))
- [Fix deployment merge request link creation](gitlab-org/gitlab@dcda9b1eebf5a88f1219cf7bc6983ca1d7af411d) ([merge request](gitlab-org/gitlab!72757))
- [Add latest commit hash to compare cache key](gitlab-org/gitlab@2cd7de9991329356e27f72b7902af1a54d964520) ([merge request](gitlab-org/gitlab!72388))
- [Move DAST CI Job keys to the EE Variant](gitlab-org/gitlab@cc91cf3e86b862441990a5b15c8f40f2ed172c2c) ([merge request](gitlab-org/gitlab!72829)) **GitLab Enterprise Edition**
- [Fix issue with CSP using Safari in dev mode](gitlab-org/gitlab@1890efe73df4173104917c7031c38764c355272f) ([merge request](gitlab-org/gitlab!72728))
- [Remove compliance framework section for unlicensed EE](gitlab-org/gitlab@3578a1c857c7a32f776ccca445faea415ab350a7) ([merge request](gitlab-org/gitlab!72691)) **GitLab Enterprise Edition**
- [Fix unnecessary epics fetch req with empty filters](gitlab-org/gitlab@689b1f691ad88b3426a1bbe791f24e18d4288b56) ([merge request](gitlab-org/gitlab!72774)) **GitLab Enterprise Edition**
- [Fix object deduplication on Geo first sync](gitlab-org/gitlab@f7fd7b0392476503b1d2d7d040861de1cfc42186) ([merge request](gitlab-org/gitlab!72605)) **GitLab Enterprise Edition**
- [Allow newlines in HTTP URLs](gitlab-org/gitlab@f1c1b914082c6c90ee2964f956436ce1709e86e3) ([merge request](gitlab-org/gitlab!72655))
- [Fix `Security::OverrideUuidsService` matching logic](gitlab-org/gitlab@25db632a95b5f2575d937864b8ee02dd55ab4952) ([merge request](gitlab-org/gitlab!72723)) **GitLab Enterprise Edition**
- [Add cloak-startup class and apply to mobile overlay](gitlab-org/gitlab@b4d6183adbbf96cefbd74ab7971b72010f5f202f) by @leetickett ([merge request](gitlab-org/gitlab!71148))
- [Stop polling when checking task lists on an issue](gitlab-org/gitlab@7b42afcd7fa71a0c09ed8899fe90740914cb7499) ([merge request](gitlab-org/gitlab!72629))
- [Modify error message for clarity](gitlab-org/gitlab@cba9950182b23a78dda3da5994167fb0ac5c284b) ([merge request](gitlab-org/gitlab!72658))
- [Ensure Azure-related gems are loaded](gitlab-org/gitlab@b221a58d23caf99293a61ca7f2987eaa247f23a5) ([merge request](gitlab-org/gitlab!72433))
- [Ensure commits limit is always positive](gitlab-org/gitlab@bb179a08051c46555d96e7c446702aa4ada300b9) ([merge request](gitlab-org/gitlab!72274))
- [Add DEFAULT_CERT_DIR handling to Spamcheck and fix Gitaly GRPC Bug](gitlab-org/gitlab@2c6b10b8ce4d3dbbc76415c58ee8ed493311d4c8) ([merge request](gitlab-org/gitlab!72386))
- [Fix a join in the postgres_indexes view](gitlab-org/gitlab@1ab9822a16cace04f1efd6b9d057fb2da1dfd60f) ([merge request](gitlab-org/gitlab!72540))
- [Fix spacing around code quality problem icon in diff view](gitlab-org/gitlab@3b6a3ecb77d0406d9f4fd0f83560ef56baf342b7) by @antonykor.ak ([merge request](gitlab-org/gitlab!72137)) **GitLab Enterprise Edition**
- [Transaction metrics from workers are not collected](gitlab-org/gitlab@c64c0191b944c889539b172d77d7e1913b30ad55) ([merge request](gitlab-org/gitlab!72108))
- [Fix nil value in location column in vulnerability_occurrences](gitlab-org/gitlab@9f192fd6c4d7859879e4582051023b5cb0c02143) ([merge request](gitlab-org/gitlab!72224)) **GitLab Enterprise Edition**

### Changed (142 changes)

- [Update deprecation notice](gitlab-org/gitlab@4d9e007e329055246968251a225f5e305702308e) ([merge request](gitlab-org/gitlab!74729))
- [Increase LFS token entropy for keys/deploy keys](gitlab-org/gitlab@9a2e2837a94603b0beff2d26ddd27019b47433b1) ([merge request](gitlab-org/gitlab!74699))
- [Fixes cross-db modification for Ci::JobArtifacts::DestroyBatchService](gitlab-org/gitlab@78e6a0de07eacc59da0cb85bbe889f54f0caea0c) ([merge request](gitlab-org/gitlab!74583))
- [Remove query_project_ci_feature_usages_for_coverage flag](gitlab-org/gitlab@b92364cc5ac02aeba68a17412b92c2a1e9481242) ([merge request](gitlab-org/gitlab!74230)) **GitLab Enterprise Edition**
- [Replace `window.confirm` with `GlModal` confirmation](gitlab-org/gitlab@ee280ed2b763d1278ad38c6e7e8a0aff092f617a) ([merge request](gitlab-org/gitlab!73950))
- [Update audit events to filter by username](gitlab-org/gitlab@406fef79f6b2e06cef5a57d348ccebb78662e3e9) ([merge request](gitlab-org/gitlab!73742)) **GitLab Enterprise Edition**
- [Fix OpenStruct use](gitlab-org/gitlab@e52f31cd736617f19018b23c376f3b834dc7b256) by @mehulsharma ([merge request](gitlab-org/gitlab!74192))
- [Fix OpenStruct use](gitlab-org/gitlab@7077c3d2bd4ecd9a6a2f7c2d5c0cf399d5ef8617) by @mehulsharma ([merge request](gitlab-org/gitlab!74420))
- [Move API fuzzing YAML generation to the client](gitlab-org/gitlab@6e204daf0ee57b4f9486f0c1a46a7b1f0040fced) ([merge request](gitlab-org/gitlab!74514)) **GitLab Enterprise Edition**
- [Use after_commit in Vulnerabilities::Feedback](gitlab-org/gitlab@82ce5be4a8a9451e5f180bacbf5bfa39463cb5ed) ([merge request](gitlab-org/gitlab!74508))
- [Use allowlist of allowed attributes for imported models](gitlab-org/gitlab@4af697f6983abfb13a356ae8f9ec65124d45b8db) ([merge request](gitlab-org/gitlab!72152))
- [Use image digest for Auto DevOps deployments](gitlab-org/gitlab@782c95ec8dfaf50e259cefcdd30ff8c7995098de) by @kinolaev ([merge request](gitlab-org/gitlab!68783))
- [Make capitalization of incident management objects uniform in modal](gitlab-org/gitlab@294974a95b8a94953a47ac8a974e4f7882e683b5) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/74453))
- [feat: Update default PAT prefix when not set](gitlab-org/gitlab@0762b5ca672b8eabe3567ed3b3bd73fdf90abe00) ([merge request](gitlab-org/gitlab!74439))
- [Use rectangular avatar on topic detail page](gitlab-org/gitlab@242281e38af1cca1ff522076449fedaff0d1912e) by @wwwjon ([merge request](gitlab-org/gitlab!74424))
- [Fix OpenStruct use](gitlab-org/gitlab@e960176b022d49e95cb04a37ab91b8e0a3fd4786) by @mehulsharma ([merge request](gitlab-org/gitlab!74419))
- [Fixed OpenStruct use offense](gitlab-org/gitlab@924eb6d05e99001dc04d00c5a637086a19ebc73b) by @mehulsharma ([merge request](gitlab-org/gitlab!73398))
- [Fix OpenStruct usage](gitlab-org/gitlab@b7b81a84417c6d92301e3267fb8534c77a4a968f) by @mehulsharma ([merge request](gitlab-org/gitlab!74405))
- [Release the NPM metadata abbreviated support](gitlab-org/gitlab@b6e2d1462922f5699451697c6d3f762122869071) ([merge request](gitlab-org/gitlab!74409))
- [Deprecation of the cert-based K8s integration](gitlab-org/gitlab@9c2253808d054d48146df3203203d7a7ae5f95ac) ([merge request](gitlab-org/gitlab!74194))
- [Use token authentication in the Debian distribution APIs](gitlab-org/gitlab@e81e649f72acf09023b8ff28717c84cb802f78d5) by @sathieu ([merge request](gitlab-org/gitlab!71911))
- [Get cluster_id from kubernetes_resource for CIS](gitlab-org/gitlab@2bcd97376543347ee65d3468c48c2134939bc222) ([merge request](gitlab-org/gitlab!74300)) **GitLab Enterprise Edition**
- [Remove Apollo error suppression feature flag](gitlab-org/gitlab@65dd9c132dad0d8c41f35c33d19374cbb24fd2a0) ([merge request](gitlab-org/gitlab!74291))
- [Show validation error for setting project suffix](gitlab-org/gitlab@16b13f2ddf5c198a3f53749c4a7bbefb101edf46) ([merge request](gitlab-org/gitlab!73458))
- [Update admin deploy keys table to comply with Pajamas design system](gitlab-org/gitlab@62bdd95d3a1a5d805fc74995ab855ae6b1286c2d) ([merge request](gitlab-org/gitlab!73860))
- [Go back denylist for importing project](gitlab-org/gitlab@90cf3aca8a230a5c5e1251b97ef581217c1783ca) ([merge request](gitlab-org/gitlab!74248))
- [Add shared_runners_duration field to NamespaceMonthlyUsageType](gitlab-org/gitlab@56813743c4b208e3bb65f0525b72b6d52edc3d74) ([merge request](gitlab-org/gitlab!74114))
- [Update vendored cluster management project template](gitlab-org/gitlab@dd487e2d5c0b3eb7d19aa9a0e2fac6674daf46b8) ([merge request](gitlab-org/gitlab!74118))
- [Move creation of external cross-references into background worker](gitlab-org/gitlab@200f731230da192375ceac6276b1779bff5129ef) ([merge request](gitlab-org/gitlab!72794))
- [Enable by default new refactored page](gitlab-org/gitlab@c019228102cf9b303fed28d0403c0a0214f7659b) ([merge request](gitlab-org/gitlab!73367))
- [Remove cached_loading_hints feature flag](gitlab-org/gitlab@6a0dd5846d3716d060a45e5e9d99c8cb3fb82a25) ([merge request](gitlab-org/gitlab!74226))
- [Restore TagsFinder class interface](gitlab-org/gitlab@707830697dfb8f9bb72364f8629b9e348fdbdfce) ([merge request](gitlab-org/gitlab!74210))
- [Refactor profile authentication log to show relevent events](gitlab-org/gitlab@aebb2e0c2db0306b178b9348cb56483e07788671) ([merge request](gitlab-org/gitlab!73890))
- [Redirect to Pipeline Editor from Suggest Pipeline banner CTA](gitlab-org/gitlab@82418b00474d7950e39af4121a664a70c4e0ca40) ([merge request](gitlab-org/gitlab!73514))
- [Fixed OpenStruct use](gitlab-org/gitlab@e1f7f314bb2f7ca024a3b2ea84930e4005fce8e4) by @mehulsharma ([merge request](gitlab-org/gitlab!73935)) **GitLab Enterprise Edition**
- [Create ProjectNamespace when a Project is created](gitlab-org/gitlab@63220fc84e2e581e2c5e5967a9655bbc1ec1dd14) ([merge request](gitlab-org/gitlab!70972))
- [Source Editor Extension module](gitlab-org/gitlab@6e41c79c94e225220f28ff6173b0d579535f36cd) ([merge request](gitlab-org/gitlab!73797))
- [Update workflow propeties in CI json schema](gitlab-org/gitlab@edd6282071e6dac437ee6aca44bbca6106cf8266) ([merge request](gitlab-org/gitlab!74164))
- [Avoid sending send-data headers in API response body](gitlab-org/gitlab@fe3740277d26bf53a147f26b9fbfb3308723a4f3) ([merge request](gitlab-org/gitlab!74161))
- [Fixed OpenStruct use](gitlab-org/gitlab@572063f311cddb76ec567d5d763c3d218fa34774) by @mehulsharma ([merge request](gitlab-org/gitlab!73932))
- [Add tooltip and commit title to pipeline editor's status header](gitlab-org/gitlab@2b56a27749d6e5c4ce41232d30a53ba4a3706729) ([merge request](gitlab-org/gitlab!73724))
- [Add user popup to CI pipeline header](gitlab-org/gitlab@18c3d927c691f265b2c19b29f3c252772f1f1865) by @KevSlashNull ([merge request](gitlab-org/gitlab!60841))
- [Redirect to continuous onboarding after trial reg](gitlab-org/gitlab@d48f786d554066533355850bbcc4e19d02af67c5) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/73594)) **GitLab Enterprise Edition**
- [Add read_at to dependency proxy objects](gitlab-org/gitlab@af9efed71e5739b63bf78c1d08dcc5399ac388dc) ([merge request](gitlab-org/gitlab!73842))
- [Add pipeline artifacts size to admin area project statistics](gitlab-org/gitlab@510aa2d6c5c1255a3832a430cbd5c7e099e666b2) by @guillaume.chauvel ([merge request](gitlab-org/gitlab!72216))
- [Spin reviewer on UX label](gitlab-org/gitlab@2561d97993dcba11251d4ce00dd12ea7e6717fd6) ([merge request](gitlab-org/gitlab!51127))
- [Refactor fetching board scope to GraphQL](gitlab-org/gitlab@703f89dff03efeab9732d1962257ba5b3903ab87) ([merge request](gitlab-org/gitlab!73604)) **GitLab Enterprise Edition**
- [Use allowlist for importing project attributes](gitlab-org/gitlab@c8c6f4687836bef271b162c5992ae034ad0ce080) ([merge request](gitlab-org/gitlab!72457))
- [Filter runner type via tabs](gitlab-org/gitlab@2f27901f299eb7555a486316110af253cbeb26a6) ([merge request](gitlab-org/gitlab!73680))
- [Update runner status badges and locked icon](gitlab-org/gitlab@02ab624c7642d0e1eaeb580e87fcdd4564913b28) ([merge request](gitlab-org/gitlab!73254))
- [Reorganise Jira Connect UI](gitlab-org/gitlab@b000e17571d15d04b89bc0264495dfa7a6b65d92) ([merge request](gitlab-org/gitlab!73714))
- [Update Rugged to v1.2.0](gitlab-org/gitlab@5def0d1caf9138d7ae7853ca65397ee5b5ce43f2) ([merge request](gitlab-org/gitlab!73915))
- [Vulnerability Chart: Fix selected state of buttons](gitlab-org/gitlab@31c993cd04803978ecebd8930f019fd5cd699cc8) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/73516)) **GitLab Enterprise Edition**
- [Log when primary host for DB load balancing is marked offline](gitlab-org/gitlab@9a13e3ee52e545fb3d8b02937045184b03ee3912) ([merge request](gitlab-org/gitlab!73904))
- [Review Adv Search admin UI text](gitlab-org/gitlab@998c396d2654eaf2d9dc5087961724939e0d2426) ([merge request](gitlab-org/gitlab!73269))
- [Load MR widget artifacts on mount](gitlab-org/gitlab@139a59e67ae54dd95ca87354c08b7906c6b964f8) ([merge request](gitlab-org/gitlab!71785))
- [Change API permissions to set epic of an issue](gitlab-org/gitlab@f97684dea8d3058001a88aabcb49c49c3a1de51c) ([merge request](gitlab-org/gitlab!66865)) **GitLab Enterprise Edition**
- [Use path_with_namespace for delete confirmation phrase](gitlab-org/gitlab@451f206d17989f0d6017bca6d5fc45e065504bf2) ([merge request](gitlab-org/gitlab!73506))
- [Flash a warning when not using index aliases](gitlab-org/gitlab@14d035b487afa677ad461bb672d98d6e5a95fa61) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/71609)) **GitLab Enterprise Edition**
- [Toggle file tree bolding based on file "Viewed" status](gitlab-org/gitlab@b3cc00ac9ea8e950ed9fc349a8fee858e0fb0d0f) ([merge request](gitlab-org/gitlab!73688))
- [Change Geo SSH proxy to internal primary URL](gitlab-org/gitlab@d7111269af72e6a331e87954559868ab864b2f8f) ([merge request](gitlab-org/gitlab!73738)) **GitLab Enterprise Edition**
- [Add empty state for CI mintues](gitlab-org/gitlab@8abb5284b3ff43a58d67c9cb4bb0e4c2a7939c61) ([merge request](gitlab-org/gitlab!73681)) **GitLab Enterprise Edition**
- [Runner status won't return "paused"](gitlab-org/gitlab@7c5173b6345f8d83a5313fa0364a072207ad7744) ([merge request](gitlab-org/gitlab!73530))
- [Add policy name to ScanExecutionPolicyCommit mutation](gitlab-org/gitlab@35a53cae27785da6d0b851a3709d8548cdb0f533) ([merge request](gitlab-org/gitlab!71994)) **GitLab Enterprise Edition**
- [Update omniauth-oauth2 and remove error verification monkey-patch](gitlab-org/gitlab@e54d847effd7dc00008c40f9f387365830a7f061) ([merge request](gitlab-org/gitlab!73658))
- [Add optional include_jobs param for CI lint APIs](gitlab-org/gitlab@55762622ad4c2982a7bb88ac60bd621a922d7241) ([merge request](gitlab-org/gitlab!72539))
- [Shift a user's contribution calendar based on their timezone setting](gitlab-org/gitlab@45f0d6aadc77fd0fd966d2d7c1eb911c6ccbb056) by @davebarr ([merge request](gitlab-org/gitlab!72938))
- [Updated texts and illustrations on Kubernetes page](gitlab-org/gitlab@9154ad4a14a2c74e8d43615c0860d0647cdd56ff) ([merge request](gitlab-org/gitlab!73586))
- [Improve run pipeline ux](gitlab-org/gitlab@32bfb6ac3e6ecc951f2928f625d6fea54f6a60ef) ([merge request](gitlab-org/gitlab!73479))
- [Add project count and coverage count to tooltip](gitlab-org/gitlab@bf87128d1707c90271802405f6806cc391fd01cb) ([merge request](gitlab-org/gitlab!73215)) **GitLab Enterprise Edition**
- [Remove not_null constraint and default for public_email](gitlab-org/gitlab@9ba66b0181b8c36e90b70c76b7dc26dc5d36def9) ([merge request](gitlab-org/gitlab!72514))
- [Replaced v-html with v-safe-html](gitlab-org/gitlab@7448898ed877680d979e7dd93618c53080c800bd) by @mehulsharma ([merge request](gitlab-org/gitlab!73371))
- [Refactor manual variables form](gitlab-org/gitlab@770107542007fa2094d0c83f82a3cc5965501921) ([merge request](gitlab-org/gitlab!73013))
- [Remove jira_connect_asymmetric_jwt feature flag](gitlab-org/gitlab@d5bbb49f5360cf50df66bbf1501a1b627000dab0) ([merge request](gitlab-org/gitlab!73540))
- [Revert temporary change for sending expiration email for all ssh keys](gitlab-org/gitlab@62dad96d489597400e3bf4bc4de1ea084ea1101a) ([merge request](gitlab-org/gitlab!73185))
- [Add clarification of repo size limits](gitlab-org/gitlab@e9fa6a15f912e834a282953940df6d271ec68c5d) ([merge request](gitlab-org/gitlab!73531))
- [Pluralize DevOps Report to DevOps Reports](gitlab-org/gitlab@13e84237be2d43fc6812efa7d870e5e2dd6c8ef7) ([merge request](gitlab-org/gitlab!73319))
- [Add limit-container-width to Jira create branch](gitlab-org/gitlab@1b29508bdb8a84f736b8a5395451d96e710f3f59) ([merge request](gitlab-org/gitlab!73521))
- [Restore namespace requirement for project deletion confirmation](gitlab-org/gitlab@d20ed309e7351854da31db2c4690bef7738e405d) ([merge request](gitlab-org/gitlab!73176))
- [Handle `Errno::ENETUNREACH` in `Gitlab::HTTP`](gitlab-org/gitlab@9e1e36c1e71c1f142b12b2f34562edf8cc047824) ([merge request](gitlab-org/gitlab!73507))
- [Enable `terms_of_service_vue` feature flag by default](gitlab-org/gitlab@b8174778b9593cbba708be6db472f1007af6c91b) ([merge request](gitlab-org/gitlab!73502))
- [Add links to Jira-related error messages](gitlab-org/gitlab@4a4c9839edb7ffdcbe59745212a314b6a4707741) ([merge request](gitlab-org/gitlab!72854))
- [Update breadcrumb toggle to inline](gitlab-org/gitlab@16e7f7a248accc22cd3cf08e821f734450899a9c) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/72754))
- [Use GlAvatar in approval rule selector](gitlab-org/gitlab@20082d12e5174f3da1bed0d0d15d39b150fe417e) ([merge request](gitlab-org/gitlab!73334)) **GitLab Enterprise Edition**
- [Change the active link color in the sidebar](gitlab-org/gitlab@61ed7221c570530ce2eb22b0b0ba653e172737be) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/73077))
- [Moved clusters empty state to Vue component](gitlab-org/gitlab@b28bf503503cc9de7e734c1d661afa74b0bc2d57) ([merge request](gitlab-org/gitlab!73064))
- [Store trace files outside of a database transaction](gitlab-org/gitlab@6d80cdc624a8a27699201ec3c1036b1b5485a648) ([merge request](gitlab-org/gitlab!66203))
- [Exclude internal API and Geo git_ssh routes from secondary proxying](gitlab-org/gitlab@6b01a82a705882227e0000d524960bc9622ddd58) ([merge request](gitlab-org/gitlab!73202)) **GitLab Enterprise Edition**
- [Remove jQuery from Jira connect app](gitlab-org/gitlab@f531c64b3ad62fb69ff7809bebd7ce9bdcb67831) ([merge request](gitlab-org/gitlab!72105))
- [Add GITLAB_CDN_HOST to frame-src and worker-src](gitlab-org/gitlab@63daa954bd7ed4581852a12482dcfe0ad2c3d465) ([merge request](gitlab-org/gitlab!72542))
- [Only delete data from Elasticsearch 30 days after subscription expires](gitlab-org/gitlab@39a1ed5f4aabda478b56fb522c8c8e508354b47f) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/72923)) **GitLab Enterprise Edition**
- [feat: Set PersonalAccessToken default prefix](gitlab-org/gitlab@1f7d3d1832abd3c47fb6d0e8245477fc9fe2cdc6) ([merge request](gitlab-org/gitlab!73314))
- [Turn on Feature Flag of ZenTao](gitlab-org/gitlab@499a27c8587abe2dc8f6ea0f1e5f673641a138db) by @icbd ([merge request](gitlab-org/gitlab!72958))
- [Skip already imported merge requests on importer](gitlab-org/gitlab@4ac0e6711f357abe1e96ff53091fbaaa7b98ba50) ([merge request](gitlab-org/gitlab!69478))
- [Say when MR was approved by me](gitlab-org/gitlab@2846f45a8b547c95d826645be4a10f92c93eeaf6) by @KevSlashNull ([merge request](gitlab-org/gitlab!63174))
- [Update clusters index help paths](gitlab-org/gitlab@b74b6367a1b5b67e266e58950e182e03d657baa7) ([merge request](gitlab-org/gitlab!72012))
- [Change question marks to Learn More in Settings](gitlab-org/gitlab@1bea1a18a4323239c38ee47e1e1dc81be1cc2950) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/73130))
- [Enable dependency proxy by default](gitlab-org/gitlab@d9c19aa16db2fae08f8adae58cdfaf7cc4a49814) ([merge request](gitlab-org/gitlab!73290))
- [Re-position merge train help icon](gitlab-org/gitlab@00cd1f2e28fe9e881572eddbbe817069f15e2a8f) ([merge request](gitlab-org/gitlab!73184)) **GitLab Enterprise Edition**
- [Rename crm related policies and consider feature flag status](gitlab-org/gitlab@9b46e46671dbf2ffd2b7b7b4a8f8507799f8b782) by @leetickett ([merge request](gitlab-org/gitlab!73209))
- [Remove skip_legacy_diff_note_callback_on_import feature flag](gitlab-org/gitlab@d2e74ca749f3aaeeb147a0c1788818334f9170df) ([merge request](gitlab-org/gitlab!73207))
- [Use secured analyzer image for cluster image scanning](gitlab-org/gitlab@a10845868073e609ada3b2ac6f916581c2bb5cad) ([merge request](gitlab-org/gitlab!72940)) **GitLab Enterprise Edition**
- [Edit UI text](gitlab-org/gitlab@88e7205228551acfc08e51c6f09893201c6fae37) ([merge request](gitlab-org/gitlab!71985))
- [Add response in Publish a package file endpoint](gitlab-org/gitlab@18148d1dd5b247d9819ff56ca56aa9b82fc3260c) ([merge request](gitlab-org/gitlab!72201))
- [Update copy of branches_to_be_notified label](gitlab-org/gitlab@f3dcb70e907d72e6a723d6d91104c537ee9c914a) ([merge request](gitlab-org/gitlab!73098))
- [Migrate Terraform template to use rules syntax](gitlab-org/gitlab@a8684074106ba89f88680119a912e036c6393f2d) by @willianpaixao ([merge request](gitlab-org/gitlab!69634))
- [Link Pipeline Editor button to open in correct branch](gitlab-org/gitlab@2e42c5b1b9e3d1f074061d9004e0dec48a7105c9) ([merge request](gitlab-org/gitlab!73011))
- [Admin: card match can have different holder name](gitlab-org/gitlab@a9d489ca0d3d1f6985abbbd251ef05f9c1431702) ([merge request](gitlab-org/gitlab!72574)) **GitLab Enterprise Edition**
- [Fix translation of title of ZenTao](gitlab-org/gitlab@dd0fd0c5051f101c827ad8754a9f2b27e7b92914) by @icbd ([merge request](gitlab-org/gitlab!72960)) **GitLab Enterprise Edition**
- [Add "Load more" button to environment dropdown](gitlab-org/gitlab@995503b722f4d4d21adf2274bf0ebee016967168) ([merge request](gitlab-org/gitlab!72731)) **GitLab Enterprise Edition**
- [Convert dropdowns in Admin / Visiblity and access to radio buttons](gitlab-org/gitlab@6e0c8d37b0b5b203e855e046ac4300566c1f9ffa) ([merge request](gitlab-org/gitlab!72721))
- [Make cosmetic improvements to Geo Admin UI](gitlab-org/gitlab@166df95959632f25b6077a2ae3f17e4e4a1f01b4) ([merge request](gitlab-org/gitlab!72035)) **GitLab Enterprise Edition**
- [Remove the left-overs of `use-deprecated-sizes` attributes](gitlab-org/gitlab@fa536eede049a96e6ef94c356981c78e2d4cbdfa) ([merge request](gitlab-org/gitlab!73012))
- [Remove stage default from CI schema](gitlab-org/gitlab@99f2bd99e146a62eed4922cc83a22e45f18f5c98) ([merge request](gitlab-org/gitlab!72747))
- [Enable feature flag default on](gitlab-org/gitlab@caa0906e7f06d01bf310b4062b998a2d04319d2a) ([merge request](gitlab-org/gitlab!72837))
- [Replace registration token in registration modal](gitlab-org/gitlab@972d777103aa0f81efc80ec369fa1263d3863066) ([merge request](gitlab-org/gitlab!72705))
- [Move register runner information to a dropdown](gitlab-org/gitlab@e4071f727ba70745f4e48c12e43a7301a79b5bc4) ([merge request](gitlab-org/gitlab!72529))
- [Run GraphQL docs rake task on changes](gitlab-org/gitlab@15ceccd30c6dafb4e32aa801ce55207c83814a46) ([merge request](gitlab-org/gitlab!72891))
- [Removes cross-joins FF in MergeRequest#environements](gitlab-org/gitlab@48359ce146c03a020904a1b530cf9560dabbcb22) ([merge request](gitlab-org/gitlab!72884))
- [Redirect Geo HTTP(s) pulls to different path with missing repo](gitlab-org/gitlab@c98b04348cb7bed4dfe5438fac3808dac0526f95) ([merge request](gitlab-org/gitlab!72881)) **GitLab Enterprise Edition**
- [Hide private group name when access request is denied](gitlab-org/gitlab@a5594b08d3e21cbe10cc3aa3a5b2493567a790e5) ([merge request](gitlab-org/gitlab!72708))
- [Improve empty state when artifacts fail to load](gitlab-org/gitlab@e9bc002c93a11bf171f1b6ab8e105fd41714ae8e) by @mehulsharma ([merge request](gitlab-org/gitlab!71666))
- [Change enforcement label to status](gitlab-org/gitlab@63bdd6720e026dcde8f361a18872aeefb016824c) ([merge request](gitlab-org/gitlab!72394)) **GitLab Enterprise Edition**
- [Remove retarget_merge_requests feature flag](gitlab-org/gitlab@8d38b170a6c92d174b8109b9c5ab1491a33705e8) ([merge request](gitlab-org/gitlab!72782))
- [Handle MissingPersonalAccessTokenError on Go middleware](gitlab-org/gitlab@0ebc748804404d13b2b37a04e98a2ed6a3741421) ([merge request](gitlab-org/gitlab!72671))
- [Add missing labels when password is filled out](gitlab-org/gitlab@e9d27520a5e540e576564768a4b7b3544ce535c2) ([merge request](gitlab-org/gitlab!71970))
- [UI polish on the webhook log page](gitlab-org/gitlab@91733c8dcf9ed694b144ee238a982c4a3009801c) ([merge request](gitlab-org/gitlab!71872))
- [Fix ZenTao spelling](gitlab-org/gitlab@c9c4b607bccd1d758f171e6cfaf1c1b806b08349) by @icbd ([merge request](gitlab-org/gitlab!72561)) **GitLab Enterprise Edition**
- [Update audit events date range filter](gitlab-org/gitlab@ff64ae2df3ee5116405f901d186a8e0d34b53007) ([merge request](gitlab-org/gitlab!71671)) **GitLab Enterprise Edition**
- [Improve merge blocked text](gitlab-org/gitlab@94ab56adecf63ecfb7e2d9b3218f27e67d78c789) ([merge request](gitlab-org/gitlab!72520)) **GitLab Enterprise Edition**
- [Show CSV and json artifact download on security tab and merge request](gitlab-org/gitlab@f285c4917b5c90e1e2c01be4eb431b9b8cdac0d6) ([merge request](gitlab-org/gitlab!72060))
- [Add custom label GitHub status check checkbox](gitlab-org/gitlab@3091c55fe6cce44df58fc5830710672cd0677295) ([merge request](gitlab-org/gitlab!72566)) **GitLab Enterprise Edition**
- [Use default timeouts for Jira calls](gitlab-org/gitlab@9d854558304b005bfb385f61ed11dd11a13ab8c8) ([merge request](gitlab-org/gitlab!72571))
- [Deduplicate http transport creation](gitlab-org/gitlab@c8a45af37ee4fb99ee84241c78fa3a5331d1c09b) ([merge request](gitlab-org/gitlab!69471))
- [Update Terraform.latest.gitlab-ci.yml template](gitlab-org/gitlab@a36e00c1b8a42bf22280734cd21cd26c8323ba43) by @willianpaixao ([merge request](gitlab-org/gitlab!71188))
- [Does not update Geo node if running on a primary site](gitlab-org/gitlab@651dd5cf0c671d9ecce213ef3cdb2bae9e7af59c) ([merge request](gitlab-org/gitlab!72530)) **GitLab Enterprise Edition**
- [Remove `roadmap_daterange_filter` ff & legacy code](gitlab-org/gitlab@605d5dca2b2dd53364ffa70ce8d70a08ea58acb3) ([merge request](gitlab-org/gitlab!72419)) **GitLab Enterprise Edition**
- [Use Gitlab::HTTP in download method](gitlab-org/gitlab@e225ad3e80db5af9e4cae6fbb175e0b47048eb7f) ([merge request](gitlab-org/gitlab!72465))
- [Order Deployments by Finish Time](gitlab-org/gitlab@75c9f7e32b16a4b7069b283d2d0c2d7f026507ad) ([merge request](gitlab-org/gitlab!71767))
- [Enable flag group_authorized_agents by default](gitlab-org/gitlab@09bb3c0445a5787c97fe26e9f8e83049647bce5e) ([merge request](gitlab-org/gitlab!72319))
- [Drop Vulnerabilites that would be invalid as well](gitlab-org/gitlab@317151e170fcdf7d50550a05f701b8b7d7a8f405) ([merge request](gitlab-org/gitlab!71752))
- [Rename Import Uploader Extension Allowlist Constant](gitlab-org/gitlab@27bf30563fba8d71ebfe28dd92a13b4633165611) ([merge request](gitlab-org/gitlab!63236))

### Deprecated (1 change)

- [Remove include MR description checkbox and deprecate related API field](gitlab-org/gitlab@18819eeca2922f9d52959c99f9d9ce28940e6784) by @trakos ([merge request](gitlab-org/gitlab!64437))

### Removed (6 changes)

- [Remove chat_names -> ci_pipeline_chat_data FK](gitlab-org/gitlab@155c821a513aaec5e525ce79f4d35bdaf7dc5670) ([merge request](gitlab-org/gitlab!74404))
- [Remove deprecated WIP from GraphQL](gitlab-org/gitlab@29a85cfe949c428afe362c2b8dd2e54b8e497ee7) ([merge request](gitlab-org/gitlab!73349))
- [Remove frontend for editing of Jira labels](gitlab-org/gitlab@83e98e05d3843e881d338a3fecdd06b29c49f03a) ([merge request](gitlab-org/gitlab!73668)) **GitLab Enterprise Edition**
- [Remove jobs and projects columns](gitlab-org/gitlab@e15a5196f4368ba951e3f8108d2ca058a9af863b) ([merge request](gitlab-org/gitlab!73472))
- [Remove the DORA DF feature flag in VSA](gitlab-org/gitlab@8d83b74453f8d4c18f67ee6b4958027bc2970a41) ([merge request](gitlab-org/gitlab!73719))
- [Remove product analytics tracking](gitlab-org/gitlab@eae5f187c4d0ab6dcd0168d5db89850740ae0c9b) ([merge request](gitlab-org/gitlab!72042))

### Security (15 changes)

- [Add reCAPTCHA to password reset and confirmation email forms](gitlab-org/gitlab@6fa2efdfe258414b2acf41fba11044e997a88ad7) ([merge request](gitlab-org/gitlab!72331))
- [Highlight usage of unicode bidi characters](gitlab-org/gitlab@3fb44197195b5789b99a13f7bf482e9a895dfc58)
- [Fix dompurify.js to prevent path traversal attacks](gitlab-org/gitlab@bff4673d75cefd130b567f1b02ba3f26d62f983d)
- [Refresh authorizations on transfer of groups having project shares](gitlab-org/gitlab@f35d2f170059bf667936b7bca7a72c6f30c677d3)
- [Don't allow author to resolve discussions when MR is locked via GraphQL](gitlab-org/gitlab@ba230b385b1246ec19b755a61745de28efcf782e)
- [Workhorse: Allow uploading only a single file](gitlab-org/gitlab@254e11b7a8d2ac081cf5602c19646040453af7fc)
- [Adding a '[redacted]' to mask private email addresses](gitlab-org/gitlab@b84cf6dd7ddfc1c17c2327150975930669cadf95)
- [Avoid decoding the whole tiff image on isTIFF check](gitlab-org/gitlab@486ee8411cde78eb3a510456f3e3e6277f360c45)
- [Respect visibility level settings when updating project via API](gitlab-org/gitlab@35a1f06f3748a0da0d50c72db5e18698a7116627)
- [Only include visible groups a project is shared with](gitlab-org/gitlab@4d1265e4ac6cda24ae7a12fbb5183e64de0472a8)
- [Stop using 'self' in the CSP's frame-src directive](gitlab-org/gitlab@005603b24f2dc92dc78be53c1a0b647657c12c7c) ([merge request](gitlab-org/gitlab!71345))
- [Do not display the root password by default](gitlab-org/gitlab@b4b8d80d00780fbb80ecac7506dcdcfb328d4f03)
- [Group owners should see SCIM token only once](gitlab-org/gitlab@7cec14e42e40e6489665828ee88bb6fa9f9653c1) **GitLab Enterprise Edition**
- [Set PipelineSchedules to inactive](gitlab-org/gitlab@03d2b9600b226593b896a222f291202fff0d40ac)
- [Do not allow Applications API to create apps with blank scopes](gitlab-org/gitlab@0c59b0a577915c3ed530ef2dee1543f7251aaaa5)

### Performance (25 changes)

- [Enable API v3 `branches/:sha` partial response](gitlab-org/gitlab@7a20e62e39bebbe6ca2fcc2c638e1527a4620af5) ([merge request](gitlab-org/gitlab!74355))
- [Avoid cross-joins in PipelinesForMergeRequestFinder](gitlab-org/gitlab@51df5a072802b71d0c69f7a7ea411b83c1429fbf) ([merge request](gitlab-org/gitlab!74293))
- [Improve ETag caching for issue discussions](gitlab-org/gitlab@4c550234b090a2de5c47469ea4791fbdc1ef9faf) ([merge request](gitlab-org/gitlab!74272))
- [GraphQL user.groups node authorization DB query count optimization](gitlab-org/gitlab@58fd8844fbc4c1abb331213755dc9868dbd6efa2) ([merge request](gitlab-org/gitlab!73121))
- [Remove unused index index_for_resource_group on ci_builds](gitlab-org/gitlab@27c4a288e1788fa0b3715717f6bed36ed99fbfef) ([merge request](gitlab-org/gitlab!74018))
- [Remove startup JS call for issue notes](gitlab-org/gitlab@62afe29cc5cbead8c0a24ee7de80a7c0b04f106f) ([merge request](gitlab-org/gitlab!74146))
- [Use keyset pagination when fixing diff commits](gitlab-org/gitlab@0687ed31ca5f002c96132d0d733d931fdca2d677) ([merge request](gitlab-org/gitlab!73836))
- [Enable workhorse_use_sidechannel by default](gitlab-org/gitlab@a09edca131894868c060ab9e2b1b5d99a9e6a3c1) ([merge request](gitlab-org/gitlab!73536))
- [Omit query params for discussions.json](gitlab-org/gitlab@31aa4311d1429a39d936b368c56d0c926497516e) ([merge request](gitlab-org/gitlab!73089))
- [Add index to events table support UMAU metric](gitlab-org/gitlab@8b781a35d79e5214d3195c9f3e135c359d32355f) ([merge request](gitlab-org/gitlab!73273))
- [Use new worker/service to refresh authorizations of project members](gitlab-org/gitlab@f28aeac8c21d39a02e18524efbdb5c5b9563e3e9) ([merge request](gitlab-org/gitlab!73337))
- [Add an index on vulnerability_occurrence_pipelines](gitlab-org/gitlab@a09fb11d6fccb7fb4d951717016df521b147db36) ([merge request](gitlab-org/gitlab!73255))
- [Add index for cluster_id in vulnerability_occurrences location](gitlab-org/gitlab@3b6bc848186e2e17fad3ef3d6247317c5240d381) ([merge request](gitlab-org/gitlab!72882))
- [Default enable new_graphql_keyset_pagination](gitlab-org/gitlab@6032662ecba69405c891e8aa9fe6dc983fe0b72f) ([merge request](gitlab-org/gitlab!72942))
- [Omit WHERE clause for NOT labels filter when empty](gitlab-org/gitlab@dce09398e054c26d9aae5fce884e34af62e9055d) ([merge request](gitlab-org/gitlab!73230))
- [Remove releases author_id index](gitlab-org/gitlab@45f7b0d53fba3b2f8beca308b77f79462e16c43a) ([merge request](gitlab-org/gitlab!72993))
- [Optimize JIRA ref lookup](gitlab-org/gitlab@1993feb5e100c04f33c876ba1b9b7a9083227d8a) ([merge request](gitlab-org/gitlab!72739))
- [Recreate broken ci_builds index](gitlab-org/gitlab@3c69765c0aaf8360171d8fb929eb62a1421e5368) ([merge request](gitlab-org/gitlab!71990))
- [Fix N+1 query in VulnerabilitiesResolver](gitlab-org/gitlab@17d45deea3692293f20b9ce17024d69483966f75) ([merge request](gitlab-org/gitlab!72985)) **GitLab Enterprise Edition**
- [Cleanup update_deployment_after_transaction_commit feature flag](gitlab-org/gitlab@f823b146446019eb6b0f6f17214ba0bc7e36d566) ([merge request](gitlab-org/gitlab!72755))
- [Search for group descendants through a btree](gitlab-org/gitlab@ec0cdd21e7b09b4e06aba529f4b9f8813a133a17) ([merge request](gitlab-org/gitlab!69535))
- [Improve TBT on file source view](gitlab-org/gitlab@95dae81e11ab95bf8793471b00e5213dcffbddf8) ([merge request](gitlab-org/gitlab!72606))
- [Cache CI variables used for rules evaluation](gitlab-org/gitlab@084f1ad54b0eafa53d21c83e002efc005d487e4a) ([merge request](gitlab-org/gitlab!72602))
- [Speed up Sidekiq size limiter middleware](gitlab-org/gitlab@af9327e6ea6e1915aa4f392ac0519c51f41de965) ([merge request](gitlab-org/gitlab!72435))
- [Remove use of Redis multi in Sidekiq client](gitlab-org/gitlab@e2afebc199f13f5d9321d5883e47916d3d0a7bbf) ([merge request](gitlab-org/gitlab!72473))

### Other (78 changes)

- [Fix the offenses introduced by Style/OpenStructUse](gitlab-org/gitlab@8f392435bbc402476b06b6ca197d388398c8b3bb) by @edith007 ([merge request](gitlab-org/gitlab!74197))
- [Fix OpenStruct use](gitlab-org/gitlab@29afe4ac550e25ef377298e117af18c49d8ea7d5) by @mehulsharma ([merge request](gitlab-org/gitlab!74415)) **GitLab Enterprise Edition**
- [Fix OpenStruct use](gitlab-org/gitlab@cab0eb279117f1e349d0fffda8686c07fcfada7f) by @mehulsharma ([merge request](gitlab-org/gitlab!74620))
- [Set total of Progress bar nil when replication is disabled](gitlab-org/gitlab@64716b33b1a79c1d4991d23324cc8625c8dee47d) by @edith007 ([merge request](gitlab-org/gitlab!68303)) **GitLab Enterprise Edition**
- [Add post deploy migration to remove open_project_data](gitlab-org/gitlab@e5543c4b536b41a82d78500464648157bbbc51e8) by @lenikadali ([merge request](gitlab-org/gitlab!71116))
- [Create pipeline trigger application limits](gitlab-org/gitlab@e7b6e65aff212a749fb40232a79c4fc4089ab805) ([merge request](gitlab-org/gitlab!73985))
- [Convert admin users page tabs to Pajamas](gitlab-org/gitlab@b82a4bd4a65a0788a643b10815aca79cb1a256e1) ([merge request](gitlab-org/gitlab!74011))
- [Geo: Remove legacy code for upload sync](gitlab-org/gitlab@3fc77c2bf6828f8f3bb602324085644e02e14b90) ([merge request](gitlab-org/gitlab!72714))
- [Cleanup feature flag gitaly_tags_finder](gitlab-org/gitlab@ede40667b60504b6b69108875d1c1551ea8a452f) ([merge request](gitlab-org/gitlab!74406))
- [Remove `paginated_tree_graphql_query` feature flag](gitlab-org/gitlab@af6c4bf7f749bce63ec8bf4767175c55c34ff45e) ([merge request](gitlab-org/gitlab!72512))
- [Convert labels page tabs to Pajamas](gitlab-org/gitlab@ad9a628a3139c458c2e0e551a95025a00b99d7e0) ([merge request](gitlab-org/gitlab!74006))
- [Set user's highlight theme for the Blame page during SSR](gitlab-org/gitlab@3d9da5c498baafe93f8774b69107b519dcaa4503) by @cyberap ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/74335))
- [Convert projects dashboard tabs to Pajamas](gitlab-org/gitlab@fefe70a1826261e0d943032f4db7f1e61f4c0ffc) ([merge request](gitlab-org/gitlab!74004))
- [Convert snippets page tabs to Pajamas](gitlab-org/gitlab@f151421ec1c75750c3e736c500e4c197e51dab0e) ([merge request](gitlab-org/gitlab!73995))
- [Convert projects explore page tabs to Pajamas](gitlab-org/gitlab@f599bf0ccb146cfcb84f655ecbd2a6b9d8546774) ([merge request](gitlab-org/gitlab!74007))
- [Convert admin users page tabs to Pajamas](gitlab-org/gitlab@c96a99d2f8addd95540bd40b203a520ff222ddf6) ([merge request](gitlab-org/gitlab!74014))
- [Convert pipeline schedules page tabs to Pajamas](gitlab-org/gitlab@60ff426c309e191f7b1af8586906b5c3d4ff33a7) ([merge request](gitlab-org/gitlab!74002))
- [Convert commit tabs to pajamas](gitlab-org/gitlab@ce5e44e69c8ce593bbc7fe6e15ddd90d0e83eba8) ([merge request](gitlab-org/gitlab!73970))
- [Decouple group's storage table from feature flag](gitlab-org/gitlab@0aa7613a05c05dc99d3277495197367dcb617624) ([merge request](gitlab-org/gitlab!73237)) **GitLab Enterprise Edition**
- [Add with_highest_role_minimal_access to statistics](gitlab-org/gitlab@15b863d07246e475ba7627726cf6b701f1a4e925) ([merge request](gitlab-org/gitlab!73651))
- [Update GlTab helpers](gitlab-org/gitlab@09d95dcac1938ccf49e7cfed4fcbbe6a3dfcb280) ([merge request](gitlab-org/gitlab!74181))
- [Hide details for invited members in seats usage](gitlab-org/gitlab@5601765b04a4aaadde4e40f24591fc4e8ef5df63) ([merge request](gitlab-org/gitlab!74224)) **GitLab Enterprise Edition**
- [Adds margin to billings page](gitlab-org/gitlab@e0de376b574c1801e76acf036722f4595a5f2a60) ([merge request](gitlab-org/gitlab!74221)) **GitLab Enterprise Edition**
- [Enabling jupyter_clean_diff by default](gitlab-org/gitlab@a578853e0d21f8dcfec3c176f8e51d0b5b3e7df7) ([merge request](gitlab-org/gitlab!74187))
- [Remove report_on_long_redis_durations flag](gitlab-org/gitlab@11eb211ee655d9d95b02275b678c431d5e2c36b5) ([merge request](gitlab-org/gitlab!74183))
- [Replace dotenv constants with application limits](gitlab-org/gitlab@8fc6799a56220d78d6910220d55aac9525f905fe) ([merge request](gitlab-org/gitlab!73855))
- [Convert search tabs to pajamas](gitlab-org/gitlab@c0d202b20fefd7f06c6152b07640844c62369043) ([merge request](gitlab-org/gitlab!73983))
- [Convert blob editor tabs to pajamas](gitlab-org/gitlab@77f6de74044cf0f5b61f9dafe68281bfb1d90058) ([merge request](gitlab-org/gitlab!73993))
- [Convert markdown field tabs to pajamas](gitlab-org/gitlab@b288ae83d010442b89ecd55ff64508c1446d7411) ([merge request](gitlab-org/gitlab!73987))
- [Convert credential inventory tabs to pajamas](gitlab-org/gitlab@389c65bdcaaa80ea06c4004c94ec5aa134ae45a9) ([merge request](gitlab-org/gitlab!73974)) **GitLab Enterprise Edition**
- [Migrate requirement to work items](gitlab-org/gitlab@d787d48626a92fcd545c10947b9c9c5bc0e1347e) ([merge request](gitlab-org/gitlab!71778))
- [Convert explore tabs to pajamas](gitlab-org/gitlab@e043fff6625130c7b1f144056f11f5daf0220557) ([merge request](gitlab-org/gitlab!73956))
- [Convert explore tabs to pajamas](gitlab-org/gitlab@e406816c3f528621123f9e7f1a6d111f90a08bc2) ([merge request](gitlab-org/gitlab!73959))
- [Remove rate limiter feature flag](gitlab-org/gitlab@395d7ca5a95e1e0e6dd2c0af139f93d7cf057df6) ([merge request](gitlab-org/gitlab!73939))
- [Improve Blame Page rendering performance](gitlab-org/gitlab@32e45383f01517c687294b2e72aeb8f9f9f74a97) by @cyberap ([merge request](gitlab-org/gitlab!73885))
- [Convert product analytics tabs to pajamas](gitlab-org/gitlab@8c18ed02a7d1020c233ab767e743dc4455ddcf37) ([merge request](gitlab-org/gitlab!73862))
- [Drop ci_build_trace_sections table and related](gitlab-org/gitlab@b24c3873de1f99179ebfd115ce44ee2fef993b6b) ([merge request](gitlab-org/gitlab!73841))
- [Changed the chronological order of Job history sequence on CI Job](gitlab-org/gitlab@729f105ee2b2ee65d28c0e6ebd5aed5372a7af66) by @edith007 ([merge request](gitlab-org/gitlab!68753))
- [Remove FF ci_create_external_pr_pipeline_async](gitlab-org/gitlab@cb49dc14536d3b1c7837a8e30c5f7b15792f5667) ([merge request](gitlab-org/gitlab!73828))
- [Remove FF ci_new_artifact_file_reader](gitlab-org/gitlab@ca8e9af383be73b826a9df6cb12682661860ca54) ([merge request](gitlab-org/gitlab!73763))
- [Fix the Style/OpenStructUse Cop offense for Guardfile](gitlab-org/gitlab@ad3b51bbdb948f37926a32ceaf395adee8049457) by @edith007 ([merge request](gitlab-org/gitlab!65386))
- [Remove the packages_remove_cross_joins_to_pipelines feature flag](gitlab-org/gitlab@aad1b85da4e13e357782bfa1036b1a6c0a53cbba) ([merge request](gitlab-org/gitlab!73751))
- [Remove the container_registry_expiration_policies_caching feature flag](gitlab-org/gitlab@7cced2645d8ee55c02d9ebf0e5b028bb006e546d) ([merge request](gitlab-org/gitlab!73737))
- [Remove include_sti_condition flag](gitlab-org/gitlab@a4b4fbfe224232cc8550b3db92240e5d5f16b053) ([merge request](gitlab-org/gitlab!73734))
- [Expose 'blocked' attribute on epic issues endpoint](gitlab-org/gitlab@036e9852a72dcc8f43bb805afcf13db50a4d4316) ([merge request](gitlab-org/gitlab!73308)) **GitLab Enterprise Edition**
- [Removed new_customersdot_staging_url feature flag](gitlab-org/gitlab@35eda894e1cd509380ff91461381df65e06004d5) ([merge request](gitlab-org/gitlab!73666))
- [Remove variable_inside_variable feature flag](gitlab-org/gitlab@9e60bd9a471849eaaff7aa954afc714778f245aa) ([merge request](gitlab-org/gitlab!73662))
- [Add spacing at top of project/group blank new forms](gitlab-org/gitlab@b9353cee2290e603b214e2fb91b43f263d40166a) ([merge request](gitlab-org/gitlab!73205))
- [Exclude ProjectNamespaces from GraphQL namespace results](gitlab-org/gitlab@baf4ef770f03a1234224d29c88731791b8c3a3b2) ([merge request](gitlab-org/gitlab!73351))
- [Pass formats explicitly when rendering .md.erb](gitlab-org/gitlab@4a307a690bd6aeed824317056a0dde14bfdc7bd4) by @edith007 ([merge request](gitlab-org/gitlab!73420)) **GitLab Enterprise Edition**
- [Remove pipeline association from Vulnerabilities::Finding](gitlab-org/gitlab@84b9c5bcaa988e30501632c66de068fbfa489673) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/73115)) **GitLab Enterprise Edition**
- [Remove release_evidence feature flag](gitlab-org/gitlab@8d9f643b380b72d14ba6c0fa7d0bf789291d61f4) ([merge request](gitlab-org/gitlab!73503))
- [Fix the offences introduced by Performance/OpenStruct](gitlab-org/gitlab@4b9efcaf9bed5895d312679ee60c8aa1537900d7) by @edith007 ([merge request](gitlab-org/gitlab!70900))
- [Add icons to project's storage table](gitlab-org/gitlab@450f6c19708f0fb5d95800f841560ad3d56d2e8d) ([merge request](gitlab-org/gitlab!72524))
- [Cleanup unused tagging records](gitlab-org/gitlab@2cd94915d477b0e6fc7199a13a6a66c1ca015a37) ([merge request](gitlab-org/gitlab!73260))
- [Backfill default namespace as User namespace](gitlab-org/gitlab@f9d95243da3e0f9006fe4dcdfda8cc9492655970) ([merge request](gitlab-org/gitlab!71510))
- [Pass formats explicitly when rendering svg icons](gitlab-org/gitlab@2852c6055781cab52202cb32deb0cc2e6462eaac) by @edith007 ([merge request](gitlab-org/gitlab!73418))
- [Pass formats explicitly when rendering svg icons](gitlab-org/gitlab@6f9b1968774a9b87a4cd9b69dba6d724148270e1) by @edith007 ([merge request](gitlab-org/gitlab!73417))
- [Pass formats explicitly when rendering svg icons](gitlab-org/gitlab@e0a3233df796f3d9f35c977024c3dd13c0cd3f89) by @edith007 ([merge request](gitlab-org/gitlab!73415))
- [Enable quarantined service ping metrics](gitlab-org/gitlab@7197509e00b6929f88da465ec9dba59ff0d2311d) ([merge request](gitlab-org/gitlab!73348)) **GitLab Enterprise Edition**
- [Replace v-html with v-safe-html to improve frontend security posture](gitlab-org/gitlab@809b12710d0e65671cddfc8a6c8a88fe5d48c30f) by @edith007 ([merge request](gitlab-org/gitlab!72912))
- [Improve User Exprience for Blame page](gitlab-org/gitlab@53ec56009b1092a58e57fe003eb91f2797e53b90) by @cyberap ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/73173))
- [Mark all time events ServicePing metric as broken](gitlab-org/gitlab@3af1f00ff62be735735d3fce875c1f9a09276631) ([merge request](gitlab-org/gitlab!73266))
- [Restore MR to populate MR diff commit users](gitlab-org/gitlab@422f65be80087c0f2c7d83186e7b866d70870570) ([merge request](gitlab-org/gitlab!73068))
- [Fixing the deprecation warning as using `.` in template has deprecated](gitlab-org/gitlab@58d603bd3dfeddb0194d23c7df7e99cf869c50e1) by @edith007 ([merge request](gitlab-org/gitlab!72842))
- [Drop redundant broken index](gitlab-org/gitlab@6f061f0b9c33c666769ef16a993c2c6ab053a9c7) ([merge request](gitlab-org/gitlab!72889))
- [Refactor protected paths UI and documentation](gitlab-org/gitlab@0f8fc0b0f2cac8d1deca5a6f9d671db7564cb761) ([merge request](gitlab-org/gitlab!72157))
- [Update GitLab Runner Helm Chart to 0.34.0](gitlab-org/gitlab@39538ec722da0fe70d5b570bde2762cc0f03700e) ([merge request](gitlab-org/gitlab!73001))
- [Update gitlab-dangerfiles to 2.3.1](gitlab-org/gitlab@cd8dd8e4a9151e6e487efb045ced15e2cca51b8a) ([merge request](gitlab-org/gitlab!72422))
- [Remove the dast_on_demand_scans_scheduler feature flag](gitlab-org/gitlab@e12031e32b4e24dc36ea246d6fa4e433cc340887) ([merge request](gitlab-org/gitlab!72953)) **GitLab Enterprise Edition**
- [Fix storage row line height](gitlab-org/gitlab@ebb97b803461a0c0007ff70e202427814e9cf7d9) ([merge request](gitlab-org/gitlab!72861)) **GitLab Enterprise Edition**
- [Remove managed cluster alerts feature flag](gitlab-org/gitlab@e76d58137167358d2a934846cbdca299d9ba2e5e) ([merge request](gitlab-org/gitlab!63829))
- [Schedule migration to remove duplicate Findings](gitlab-org/gitlab@59da2c5664f161dc8cbd1eed5b7afb3fce43b65c) ([merge request](gitlab-org/gitlab!72528))
- [Show all storage types in project's storage usage](gitlab-org/gitlab@8d5273b22a395ddcfc901d2c82db242ef17be938) ([merge request](gitlab-org/gitlab!72582))
- [Remove ci_synchronous_artifact_parsing feature flag](gitlab-org/gitlab@06c45bd2db99fe8fda85b2d383a6472c104137f6) ([merge request](gitlab-org/gitlab!72618))
- [Add pipeline artifacts, packages and uploads size to group REST API](gitlab-org/gitlab@fc6fdede8e459e83df4d048868ee96f3e1a49489) by @guillaume.chauvel ([merge request](gitlab-org/gitlab!72075))
- [Add pipeline artifacts and uploads sizes to project REST API](gitlab-org/gitlab@58d66f28faf42ae98ca11ff1ba0bdd9180e988ad) by @guillaume.chauvel ([merge request](gitlab-org/gitlab!72075))
- [Remove not used parameter from epics finder](gitlab-org/gitlab@49fce172b57b2f376a114726b1dd1900fe36a238) ([merge request](gitlab-org/gitlab!72285)) **GitLab Enterprise Edition**

## 14.4.5 (2022-01-11)

No changes.

## 14.4.4 (2021-12-03)

No changes.

## 14.4.3 (2021-12-01)

### Fixed (6 changes)

- [Check validation only if new record of license](gitlab-org/gitlab@5e0834a921dad1b1e07119de629ea44eb0ad5733) ([merge request](gitlab-org/gitlab!75421)) **GitLab Enterprise Edition**
- [Fix for hexadecimal branch deletion](gitlab-org/gitlab@fc3c2f211d5a2f190032c4d0109e2bcb31050b4d) ([merge request](gitlab-org/gitlab!75421))
- [Geo - Fix no repo error message for group-level wikis](gitlab-org/gitlab@bdf3a712a4bfe245dfa7e7a90c24f2fdb482e309) ([merge request](gitlab-org/gitlab!75421)) **GitLab Enterprise Edition**
- [Prevent Git operations from checking replication lag on non-Geo-secondary sites](gitlab-org/gitlab@c158c01027f61aadd1c72f0817731d368d0d58cc) ([merge request](gitlab-org/gitlab!75421)) **GitLab Enterprise Edition**
- [Allow SSO callbacks through maintenance mode](gitlab-org/gitlab@1acae9807b1808ac360a4be098a50c547c9540b9) by @dzaporozhets ([merge request](gitlab-org/gitlab!75421)) **GitLab Enterprise Edition**
- [Fix 2FA setup for LDAP users](gitlab-org/gitlab@9b9a7230aed3ffeef3e8f608dd1a569397c71684) ([merge request](gitlab-org/gitlab!75421))

## 14.4.2 (2021-11-08)

### Fixed (3 changes)

- [Skip retrying for reads on connection errors if primary only](gitlab-org/gitlab@8e1976ed75bd6c606d49c83863cf46bf3c4d5070) ([merge request](gitlab-org/gitlab!73919))
- [Fix error 500 loading branch with UTF-8 characters with performance bar](gitlab-org/gitlab@67ddc428472d57bb3d8a4a84eb0750487a175f75) ([merge request](gitlab-org/gitlab!73919))
- [Skip st_diff callback setting on LegacyDiffNote when importing](gitlab-org/gitlab@84f5c66321473cd702b3b671584054fcf3d141ae) ([merge request](gitlab-org/gitlab!73919))

### Changed (1 change)

- [Remove skip_legacy_diff_note_callback_on_import from legacy diff note](gitlab-org/gitlab@547a2ec29ea9e9299eab727899c3d90886ffc21c) ([merge request](gitlab-org/gitlab!73919))

### Performance (1 change)

- [Prevent Sidekiq size limiter middleware from running multiple times on the same job](gitlab-org/gitlab@294c01be38d400607536fb20a2038e098c0f0e28) ([merge request](gitlab-org/gitlab!73919))

## 14.4.1 (2021-10-28)

### Security (13 changes)

- [Highlight usage of unicode bidi characters](gitlab-org/security/gitlab@cef762a270783780112c7bf318e353a39de1aa1e) ([merge request](gitlab-org/security/gitlab!1937))
- [Fix dompurify.js to prevent path traversal attacks](gitlab-org/security/gitlab@9a891cbe465a302f260f0f81fc490cacb9e8c70e) ([merge request](gitlab-org/security/gitlab!1929))
- [Refresh authorizations on transfer of groups having project shares](gitlab-org/security/gitlab@bdf8b6e90d0a1f719c0f389f29ea5dc41c22f119) ([merge request](gitlab-org/security/gitlab!1916))
- [Adding a '[redacted]' to mask private email addresses](gitlab-org/security/gitlab@324fe6286b266c3990676bc93b3f6ab03eea5f6b) ([merge request](gitlab-org/security/gitlab!1927))
- [Do not allow Applications API to create apps with blank scopes](gitlab-org/security/gitlab@4e2c4d2a88acf7167e1078e8a27679545ab90c9c) ([merge request](gitlab-org/security/gitlab!1922))
- [Don't allow author to resolve discussions when MR is locked via GraphQL](gitlab-org/security/gitlab@34ffcb55a70ad6db38292f79fe73c05fb2655738) ([merge request](gitlab-org/security/gitlab!1919))
- [Workhorse: Allow uploading only a single file](gitlab-org/security/gitlab@0aee710db4bbab84c78b9e38f459bfca606aaf80) ([merge request](gitlab-org/security/gitlab!1913))
- [Set PipelineSchedules to inactive](gitlab-org/security/gitlab@de405edc9de4519656675ed6825534aac6b738da) ([merge request](gitlab-org/security/gitlab!1911))
- [Do not display the root password by default](gitlab-org/security/gitlab@138a62f89ce6616d63e3cf18eeda291a380b9ebc) ([merge request](gitlab-org/security/gitlab!1909))
- [Group owners should see SCIM token only once](gitlab-org/security/gitlab@43d19f580543d0203b1d841f921536474ca4be38) ([merge request](gitlab-org/security/gitlab!1906)) **GitLab Enterprise Edition**
- [Respect visibility level settings when updating project via API](gitlab-org/security/gitlab@f96258f3622cf72b46158f22c4660ff60a2c25ae) ([merge request](gitlab-org/security/gitlab!1903))
- [Avoid decoding the whole tiff image on isTIFF check](gitlab-org/security/gitlab@b93683df51ce85f909d5072ec2a0e7756d64038e) ([merge request](gitlab-org/security/gitlab!1899))
- [Remove external_webhook_token from exported project](gitlab-org/security/gitlab@874aa74a23fc3c44f390500bc8379c30ebc51452) ([merge request](gitlab-org/security/gitlab!1872))

## 14.4.0 (2021-10-21)

### Added (79 changes)

- [Upgrade GitLab Pages to 1.46.0](gitlab-org/gitlab@e606ddc078a2fe55658abb33924fac5699376953) ([merge request](gitlab-org/gitlab!72383))
- [Support math expressions in the Content Editor](gitlab-org/gitlab@3e60388da219b0b33fa032f50bf087fd5b7845c0) ([merge request](gitlab-org/gitlab!72153))
- [Add Reviewer names](gitlab-org/gitlab@925c1246984a33b4c408848298dc544757656499) ([merge request](gitlab-org/gitlab!72244))
- [Geo: Enable Upload replication using SSF by default](gitlab-org/gitlab@99543ee585f7f35f84f19e08b2ccba6428341a2b) ([merge request](gitlab-org/gitlab!72199)) **GitLab Enterprise Edition**
- [Add username attribute support for GitLab.com Group SAML SSO](gitlab-org/gitlab@085254b32ebdb6269636c774de9d88cbabc5bed9) ([merge request](gitlab-org/gitlab!72134)) **GitLab Enterprise Edition**
- [Expose issue contacts via GraphQL](gitlab-org/gitlab@2dc68a486afeffd1b64b78fcbeae537c030d7dfa) by @leetickett ([merge request](gitlab-org/gitlab!71889))
- [Add source instance version validation for project](gitlab-org/gitlab@44c33c0ceb7c4507c94f1c7fda5811d81d5fdf9c) ([merge request](gitlab-org/gitlab!71423))
- [Add top-level GraphQL query for single board list](gitlab-org/gitlab@2740bda696e362f7fd92f567b3e13f063b6677cf) ([merge request](gitlab-org/gitlab!67909))
- [Allow to setup Documentation pages URL for help pages redirects](gitlab-org/gitlab@3f3566ab09ce35ac3a636a22e65e40927e63cab9) ([merge request](gitlab-org/gitlab!71737))
- [DevOps Adoption: Add "trend over time" graph](gitlab-org/gitlab@ef874e312ca65ed14101c41d09e69bfa9869a19e) ([merge request](gitlab-org/gitlab!70518)) **GitLab Enterprise Edition**
- [Improve data zoom on contribution analytics](gitlab-org/gitlab@13d202a2f08fb7c45ebfa475ab258d20b68bc982) ([merge request](gitlab-org/gitlab!72004)) **GitLab Enterprise Edition**
- [Add cluster_image_scanning CI parser to update location data](gitlab-org/gitlab@c28d8ab7e6367258ddfbbeb25e0492c0a324c6f7) ([merge request](gitlab-org/gitlab!71794)) **GitLab Enterprise Edition**
- [Enable on-demand scans scheduler](gitlab-org/gitlab@fff487ba8404497c28f547c13f6322adf05ea6b5) ([merge request](gitlab-org/gitlab!72097)) **GitLab Enterprise Edition**
- [Add EE variant of Resolvers::ProjectPipelinesResolver](gitlab-org/gitlab@a463cdfb92c0b65fcbf1f88ac5fe967fb8dd8458) ([merge request](gitlab-org/gitlab!69983)) **GitLab Enterprise Edition**
- [Implement PostUploadPackWithSidechannel client in Workhorse](gitlab-org/gitlab@c82a66e14df6a61d7a72a5c91e63ec3829f9f1f2) ([merge request](gitlab-org/gitlab!71047))
- [Introduce status column for the security_scans table and populate it](gitlab-org/gitlab@82ca4611de10d84e3f71d5a53e2adb0f56600308) ([merge request](gitlab-org/gitlab!71944))
- [Add contact update mutation to GraphQL](gitlab-org/gitlab@36e00a538964c38997cc4ead8e6e405bfde60237) by @leetickett ([merge request](gitlab-org/gitlab!71866))
- [Add support for load balancing multiple databases](gitlab-org/gitlab@771f94fc7fac48a353c66eab22bc25ccd6f18d54) ([merge request](gitlab-org/gitlab!67773))
- [Admin: listing matching card details of an user](gitlab-org/gitlab@74e3fc25beeb3bbc142864df192acad845d73407) ([merge request](gitlab-org/gitlab!71533)) **GitLab Enterprise Edition**
- [Import repository with project migration](gitlab-org/gitlab@a6d2a4297a26c72f1168c9713085d8b324487648) ([merge request](gitlab-org/gitlab!70326))
- [Graceful degradation for Branches controller](gitlab-org/gitlab@ac36712c9e89441b21fbdf391d70a2ae31df384f) ([merge request](gitlab-org/gitlab!70970))
- [Add ability to set iteration on issue creation via GraphQL API](gitlab-org/gitlab@8821ec56982cbec2503d862f2684231048666647) ([merge request](gitlab-org/gitlab!71689)) **GitLab Enterprise Edition**
- [Avoid cross-joins in PipelinesForMergeRequestFinder](gitlab-org/gitlab@4e95bcd85840bda5a60a93096eec2235a10f0677) ([merge request](gitlab-org/gitlab!68549))
- [Remove ci_resource_group_process_modes feature flag](gitlab-org/gitlab@7eb40a877b386f3c2f097e0fe22e592763b61d9b) ([merge request](gitlab-org/gitlab!71365))
- [Add customer relations contact create mutation](gitlab-org/gitlab@78cd670bfc5605de4ee906e5074b25c8f10e4e75) by @leetickett ([merge request](gitlab-org/gitlab!70733))
- [Sync requirement and requirement issues state](gitlab-org/gitlab@5b06b0d63227ebf8f7ba8e59ba4f4af3c528037a) ([merge request](gitlab-org/gitlab!70607)) **GitLab Enterprise Edition**
- [Keep credit card non-sensitive info](gitlab-org/gitlab@b5381bcab8271401dda80323ef44a8f18887d159) ([merge request](gitlab-org/gitlab!71171)) **GitLab Enterprise Edition**
- [Subscriptions hand raise lead API client](gitlab-org/gitlab@cd0ad142152f07acd5d50439ac7b58a89a84f8b4) ([merge request](gitlab-org/gitlab!71723)) **GitLab Enterprise Edition**
- [Add metric for users associating milestones to releases](gitlab-org/gitlab@bf999ff05c4d3f47aea31fd87a6bd1d6dcda0a0a) ([merge request](gitlab-org/gitlab!71287))
- [Add meta data in user_credit_card_validations](gitlab-org/gitlab@0d08d597a30d1cd8e73f78fc3b64ad79418aa3e3) ([merge request](gitlab-org/gitlab!71032))
- [Link to a search for feature flag name in project](gitlab-org/gitlab@8d1c153c04b54f1710596d523ea46880a9851eb2) ([merge request](gitlab-org/gitlab!70417)) **GitLab Enterprise Edition**
- [Add includeSubepics argument to issue filters in GraphQL](gitlab-org/gitlab@5a913e8455e9881be20c73c095bb077c7655acfb) ([merge request](gitlab-org/gitlab!71610)) **GitLab Enterprise Edition**
- [Warn users of impacted escalation policies on leave/delete](gitlab-org/gitlab@de25310c6c6a987003bb1c3948f7713960af917a) ([merge request](gitlab-org/gitlab!69411)) **GitLab Enterprise Edition**
- [Add confidential issues filtering for GraphQL API](gitlab-org/gitlab@733862877c48d3666d85922b956de186f6d93305) ([merge request](gitlab-org/gitlab!71355))
- [Measure Sidekiq enqueue latency for scheduled jobs](gitlab-org/gitlab@c4c42d29cf4c33d913479ebcb916a4fdf45ab002) ([merge request](gitlab-org/gitlab!71615))
- [Add ability to set iteration on issue creation via GraphQL API](gitlab-org/gitlab@25b287bfee614a0b8844a5ecf62ac26173327ea2) ([merge request](gitlab-org/gitlab!70007)) **GitLab Enterprise Edition**
- [Add issue_customer_relations_contacts linking table](gitlab-org/gitlab@3f6597a9aa88e023223d0f91e633be2d54ca99e9) by @leetickett ([merge request](gitlab-org/gitlab!71007))
- [Add config field gitlab_kas.external_k8s_proxy_url](gitlab-org/gitlab@e0137111fbbd28316f38da30075aba641e702b98) ([merge request](gitlab-org/gitlab!71512))
- [Add DependencyProxySettings mutation](gitlab-org/gitlab@e2d7d722887c8a6edc2b52a1e8871bce4781c4a2) ([merge request](gitlab-org/gitlab!71274))
- [Added feature flag to show terraform banner](gitlab-org/gitlab@361e943b17924bbc14b26a2d8e1864d9c234c670) ([merge request](gitlab-org/gitlab!71462))
- [Promote jobs_to_be_done experiment](gitlab-org/gitlab@26781e4305c97d64a9dc9bf2c1dd31702bff9daf) ([merge request](gitlab-org/gitlab!71122))
- [Feat(Cloud Activation Form Modal): loading button](gitlab-org/gitlab@67403800753894384f77f603a2b0bc5587ccd77f) ([merge request](gitlab-org/gitlab!71385)) **GitLab Enterprise Edition**
- [Return runner webUrl via GraphQL API](gitlab-org/gitlab@f708096867cabf5829119cd4d83c902fa24b5c8b) ([merge request](gitlab-org/gitlab!70692))
- [Add option of 60 days to container image expiration policy](gitlab-org/gitlab@c7be549c5f1727b474ff91212a42216f3115181f) by @pataar ([merge request](gitlab-org/gitlab!70148))
- [Add missing keywords to CI schema](gitlab-org/gitlab@f1d0f6edadb5c20ab20efe0637e3698adc5ba2b5) ([merge request](gitlab-org/gitlab!70779))
- [BulkImports: Handle network errors](gitlab-org/gitlab@337e284574a89bfb67d82a567152d7651814a976) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/68582))
- [Add sorting to DA overview table](gitlab-org/gitlab@87145f1c815d2c5f6e46270e108dbdda0c45b80a) ([merge request](gitlab-org/gitlab!70937)) **GitLab Enterprise Edition**
- [Document how to migrate off Gitaly Cluster](gitlab-org/gitlab@855db4a1816db79cd3d48c75597a48e3f55ac6b5) ([merge request](gitlab-org/gitlab!71223))
- [Make it possible to define custom request duration thresholds](gitlab-org/gitlab@5c52eddb1487a2876f0589affaf8a746ff84b3e9) ([merge request](gitlab-org/gitlab!69877))
- [Implement rate-limiting for a deprecated API endpoint](gitlab-org/gitlab@5b9e642e5b591fa0cc5bbbddc18530cafa4e1c22) ([merge request](gitlab-org/gitlab!70310))
- [Extend EE::Types::Ci::PipelineType with dast_profile](gitlab-org/gitlab@ea048ea3ab508a3d7f573adb0ee978f0cf1325fe) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/69808)) **GitLab Enterprise Edition**
- [Add `links` and `message` field to VulnerabilityType](gitlab-org/gitlab@3360a18c7fa4ae8a4b452b86ca8adb21454f73d1) ([merge request](gitlab-org/gitlab!71207)) **GitLab Enterprise Edition**
- [Allow relate quick action on issue create](gitlab-org/gitlab@763d5577565ce9b14d99b87577a9ac17b95fbb7f) ([merge request](gitlab-org/gitlab!71193))
- [Allow plus character in project names](gitlab-org/gitlab@22714f512393017b538b8995ecb270c12deeddbd) by @lzampier ([merge request](gitlab-org/gitlab!67997))
- [Render frontmatter codeblock in the Content Editor](gitlab-org/gitlab@d84bcddf3a3c6c0b188a5a7a09ba49ae347c1eaa) ([merge request](gitlab-org/gitlab!70854))
- [Add support for wbr in content editor](gitlab-org/gitlab@772f061eac6bd4cca2c3511f9978d0d246c3cd2a) ([merge request](gitlab-org/gitlab!69365))
- [Enable live tracking and enforcement of CI minutes](gitlab-org/gitlab@55adb3a7e1fabb9a20bf4dcd7a08dcd5ad09097e) ([merge request](gitlab-org/gitlab!71072)) **GitLab Enterprise Edition**
- [Send "setup for company" in trial form to CustomersDot](gitlab-org/gitlab@b7e4d09eeb8f83194032e1463d126a4a9d2a4a6d) ([merge request](gitlab-org/gitlab!70569))
- [Perform validations on the parent of a namespace/group by default](gitlab-org/gitlab@5dd7051f880f01a5ee0d43e7472c46c0de824352) ([merge request](gitlab-org/gitlab!70365))
- [Added support for test coverage badge color configuration](gitlab-org/gitlab@13ca69c7e4cf42c47a8c99f33a5e8bc7ed511357) by @szaboi ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/69164))
- [Move cluster agent GraphQL mutations and supporting services to core](gitlab-org/gitlab@8e45ef80d137f4b76008ac1e1044d6f38cf61823) ([merge request](gitlab-org/gitlab!70887))
- [Move cluster agent GraphQL types and resolvers to core](gitlab-org/gitlab@5f54a7c09133de4a833390b1b510af02744da9f8) ([merge request](gitlab-org/gitlab!70759))
- [Address the PK Overflow risk for the taggins - Step 3](gitlab-org/gitlab@f9b8e8d7c55b8959468b6f1594ea83c965b9e5c3) ([merge request](gitlab-org/gitlab!69639))
- [Remove i_testing_metrics_report_artifact_uploaders feature flag](gitlab-org/gitlab@1a4f15be1a8c12c96a70463b8e1b2c3e01cfcd1d) ([merge request](gitlab-org/gitlab!70957))
- [Remove usage_data_i_testing_test_case_parsed feature flag](gitlab-org/gitlab@af7d2e9f6926914fc6fee750c466b15e44e1a9f3) ([merge request](gitlab-org/gitlab!70953))
- [Enable FF "paginated_tree_graphql_query" by default](gitlab-org/gitlab@ade0b92eb1736575e4e6530db5920cd1222a8bed) ([merge request](gitlab-org/gitlab!70913))
- [Add user permissions for runners in GraphQL API](gitlab-org/gitlab@8d9c658cb4a2b952407779f7a64b0dc11960195f) ([merge request](gitlab-org/gitlab!70809))
- [Always enable the database load balancer](gitlab-org/gitlab@f38900c90d7ff75eaeaf15265d177e4b1fae5c22) ([merge request](gitlab-org/gitlab!68042))
- [Add endpoints for project relations exports](gitlab-org/gitlab@5e9ebbd16ea73d22f41e3aa9f005cb532fe5f0cc) ([merge request](gitlab-org/gitlab!70330))
- [Upgrade Pages to 1.45.0](gitlab-org/gitlab@8853ba52e3a2bd66051b845f47b67b6eef9916b3) ([merge request](gitlab-org/gitlab!70752))
- [Support FIFO/LIFO process modes to Resource Group](gitlab-org/gitlab@a100cb945bc9bcd4c531c1889059f8a8f6e29e61) ([merge request](gitlab-org/gitlab!67015))
- [Add documentation to Files API Rate Limits](gitlab-org/gitlab@3da4af85c9bbf210b8adde556ebb255700fc2983) ([merge request](gitlab-org/gitlab!68645))
- [Add security_orchestration_policy to pipeline source filter](gitlab-org/gitlab@b5a6dfec3faf5c7df11e3a68c30ce642aeabf49b) ([merge request](gitlab-org/gitlab!69985)) **GitLab Enterprise Edition**
- [Add sign-in count to external pipeline validation](gitlab-org/gitlab@838d1f55a83cdbf00b7d99206156fac351115aaf) ([merge request](gitlab-org/gitlab!70668))
- [Add negated issueType filter to issue resolver (group and project)](gitlab-org/gitlab@4cca803a06aad048f7478b8eb51c6934958b3bc6) ([merge request](gitlab-org/gitlab!70635))
- [Add clone issue to REST API](gitlab-org/gitlab@33e9e55a35631392ce88f4a4823d11d0ae3cc797) ([merge request](gitlab-org/gitlab!57740))
- [Add runner_features column to ci_builds_metadata](gitlab-org/gitlab@319d59940117374d3bebf7fa53d55b7bc3c19763) ([merge request](gitlab-org/gitlab!70189))
- [Extend /help/instance_configuration with Git LFS rate limit](gitlab-org/gitlab@455ad3b28580c1da1f6a5cea6a2f37794e07dd72) by @wwwjon ([merge request](gitlab-org/gitlab!70397))
- [API: Add endpoint to reset runner authentication token](gitlab-org/gitlab@c2e34204a0b6ef305ac76a68f9f7c9216eb0f379) by @KyleFromKitware ([merge request](gitlab-org/gitlab!69561))

### Fixed (96 changes)

- [Fix Analytics Author filters](gitlab-org/gitlab@17c9eb627e135ce61b51c81a541d844602cb4305) ([merge request](gitlab-org/gitlab!72492))
- [Allow maintainers to set MR approval settings](gitlab-org/gitlab@de58cb9ca02037b4df2fc2f14040503026ddf5b7) ([merge request](gitlab-org/gitlab!72493)) **GitLab Enterprise Edition**
- [Fix: update links in billing page](gitlab-org/gitlab@c8d6f73497df3080b5080977f3fe03085e1506fe) by @orozot ([merge request](gitlab-org/gitlab!72259)) **GitLab Enterprise Edition**
- [Update onboarding template project](gitlab-org/gitlab@1f5160ad9e8a2dcfcc5f628f525734e423bb75b9) ([merge request](gitlab-org/gitlab!72355)) **GitLab Enterprise Edition**
- [Fix handling Service Ping response DevOps metrics](gitlab-org/gitlab@e06fe59cd272e35a2009f499a006f7da8ae7640f) ([merge request](gitlab-org/gitlab!72344))
- [Add guard clause to ensure incoming params](gitlab-org/gitlab@0f3b20cde204f1cb28dce6e7c794fac0cd5a0a64) ([merge request](gitlab-org/gitlab!72241))
- [MR Analytics: Add pipelines sanity check](gitlab-org/gitlab@f204f965a9fbd875b2491ec88d77c9f7558dec49) ([merge request](gitlab-org/gitlab!72210)) **GitLab Enterprise Edition**
- [Replace calls to LoadBalancing with ::Gitlab::Database::LoadBalancing](gitlab-org/gitlab@d54189d088a90daa7f1fda4bea2334acf5b172b5) ([merge request](gitlab-org/gitlab!72205))
- [Change shared runner settings on import on conflict with group](gitlab-org/gitlab@e5680f9350f863c2ad2e14e5d495ae8df5aa413e) ([merge request](gitlab-org/gitlab!71846))
- [Fix undefined method `use_primary!' error in GDK](gitlab-org/gitlab@5c3638936934b90049c0bf5a8d9f017fb721e750) by @leetickett ([merge request](gitlab-org/gitlab!72247))
- [Guard against exceptions from unfound DiffNotes](gitlab-org/gitlab@580072f86097f4156fc01eb16863b7e746c2a4fb) ([merge request](gitlab-org/gitlab!72242))
- [Replace success button in the add linked issue](gitlab-org/gitlab@7d3d847c76e6dbd7bfcd357ffb31236860419aed) ([merge request](gitlab-org/gitlab!72211))
- [Ensure correct group for DA chart](gitlab-org/gitlab@0065f5a8db8410868566e58e9c4af31015cf8162) ([merge request](gitlab-org/gitlab!72176)) **GitLab Enterprise Edition**
- [Fix cut-off dropdown in board breadcrumbs](gitlab-org/gitlab@49feed59a9f572f3210e353b5b5816717a414bfe) ([merge request](gitlab-org/gitlab!72168))
- [Fix non-restarted skipped bridge jobs](gitlab-org/gitlab@ad8ffd504c5898570666a1789ef463c0030196ee) ([merge request](gitlab-org/gitlab!72141))
- [Don't run WAL queries when not using replicas](gitlab-org/gitlab@9599f8669a9395d5193be1b226b4c136f28f8e90) ([merge request](gitlab-org/gitlab!71736))
- [Enable syntax highlighting for new files](gitlab-org/gitlab@4d0a4fc7b0cc9ec616a67853b97cd96e731d2ed6) ([merge request](gitlab-org/gitlab!71801))
- [Add go, nuget, and sbt to Dependencies API filters](gitlab-org/gitlab@1d996aa6ecefeea103fa05f02131000918d08b7c) ([merge request](gitlab-org/gitlab!72022)) **GitLab Enterprise Edition**
- [Present sbt, nuget, and go in Dependency List page](gitlab-org/gitlab@e2907ff57a11be60f3bb1c8dc8157de0a00d8156) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/72021)) **GitLab Enterprise Edition**
- [Fix detail page of NuGet package with missing metadata](gitlab-org/gitlab@412acd19f95c5a56699c9cb248afd31e8f0a3476) by @wwwjon ([merge request](gitlab-org/gitlab!72013))
- [Remove local form errors flash](gitlab-org/gitlab@52ea002f636cae726fb452ad4146919c0f700d4a) ([merge request](gitlab-org/gitlab!71945))
- [Make CI minutes consumption increment idempotently](gitlab-org/gitlab@f82d4f06987fc7736e0d0fc84c8cfdfd2b7d938f) ([merge request](gitlab-org/gitlab!71840)) **GitLab Enterprise Edition**
- [Boards - Sort closed issues by closedAt date](gitlab-org/gitlab@c89f00d681dab5ff00096913af170f043b052e10) ([merge request](gitlab-org/gitlab!71698))
- [Gracefully track errors raised by sending CI minutes notifications](gitlab-org/gitlab@2036f9a11fc272cf5cb6e0ecbaae5eeefa454df3) ([merge request](gitlab-org/gitlab!71815)) **GitLab Enterprise Edition**
- [Add IssuesFieldExtension to set relative positions](gitlab-org/gitlab@5c62b8c87c22a8d722c66bdeaf475f01bc1a29f8) ([merge request](gitlab-org/gitlab!71164))
- [Update strategies used for DB count approximation for read-only DB](gitlab-org/gitlab@09a35759c3de4665cd3b7769eaf82a11de32d03d) ([merge request](gitlab-org/gitlab!71925))
- [Mark the `created_at` attribute as read-only to prevent updating it](gitlab-org/gitlab@21d7ee36bb6e11fe2d1b51a3ab5cf0734efae0f2) ([merge request](gitlab-org/gitlab!71399))
- [Disable caching of MergeToRefService call in mergeability check](gitlab-org/gitlab@36f8fbf83cdf7e539165bc73f742bfd2e39a0290) ([merge request](gitlab-org/gitlab!71909))
- [Return the correct project in job/allowed_agents API response](gitlab-org/gitlab@95364c467bcf2e3765f58fef18b8d759031022af) ([merge request](gitlab-org/gitlab!71876))
- [Use pessimistic locking when accessing Terraform state](gitlab-org/gitlab@ac3916a5d29d16de4ce8359d0d100dace6e82e24) ([merge request](gitlab-org/gitlab!71873))
- [Sanitize given scan types before querying the security_scans](gitlab-org/gitlab@a06867f1eb2e7c091be0067eb1b10b7071b2f512) ([merge request](gitlab-org/gitlab!71836))
- [Fix auto-renew of LetsEncrypt domains for Pages](gitlab-org/gitlab@b3a7e0d5268b90722a372674ad7f0c248a6e9872) ([merge request](gitlab-org/gitlab!71697))
- [Show hint if input value is invalid](gitlab-org/gitlab@b1b2a440e4afd624559153c697a50a5c1ee37e7c) ([merge request](gitlab-org/gitlab!71582)) **GitLab Enterprise Edition**
- [Fix inline JavaScript HAML linter not working](gitlab-org/gitlab@8f32460266e31bad3f66155df31735a34a756328) ([merge request](gitlab-org/gitlab!71798))
- [Add ON DELETE constraint to security_policy_management_project_id](gitlab-org/gitlab@402154b0df873e6edb91267980b27ef5a4e231dc) ([merge request](gitlab-org/gitlab!71391))
- [Fix merge request approvals accordion](gitlab-org/gitlab@016ac9c025e5ed11e208dba86f5af8609e1dc0d1) ([merge request](gitlab-org/gitlab!69252)) **GitLab Enterprise Edition**
- [Fix undefined method error in validate_remote_git_endpoint service](gitlab-org/gitlab@a93a088faecdd667c76790c47e2bae00b6d203dc) ([merge request](gitlab-org/gitlab!71670))
- [Hide filters UI in Roadmap within epic page](gitlab-org/gitlab@c35f81070d988c0a1c5d337245c1ac20de29761c) ([merge request](gitlab-org/gitlab!71726)) **GitLab Enterprise Edition**
- [Fix storing first_mentioned_in_commit_at attribute](gitlab-org/gitlab@900db121a1e2914656ad8678b00f25e93d076515) ([merge request](gitlab-org/gitlab!71639))
- [Redirect Geo git push operations to primary external URL](gitlab-org/gitlab@98780b7eb910720fdc4ded20dd7f6ba3f39d8e27) ([merge request](gitlab-org/gitlab!71711)) **GitLab Enterprise Edition**
- [Fix spacing between note badges](gitlab-org/gitlab@f629eb9b3ab799815fb0e6d05dc186840ed6d369) by @TaehyeokKang ([merge request](gitlab-org/gitlab!71208))
- [Fix project statistics Uploads](gitlab-org/gitlab@7ebd4cb24c56cb8a26082ca06242d5ab5823dfad) by @guillaume.chauvel ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/71370))
- [Move required styles for issue-token to core](gitlab-org/gitlab@297c1112d5cce610f98e1189d13c00465d27949e) by @michael.telgkamp ([merge request](gitlab-org/gitlab!71531))
- [Fix default values for the deprecated API throttle](gitlab-org/gitlab@86cb92849da9ed37a1f9962613eb4c366f270f8b) ([merge request](gitlab-org/gitlab!71449))
- [Fix dependency proxy image prefix](gitlab-org/gitlab@f4c9a981b55492c53b9d233846d6364a4e344649) ([merge request](gitlab-org/gitlab!71511))
- [Upgrade mermaid-js to v8.13.2](gitlab-org/gitlab@0dc2971222642e39b3af5a6832f50a57586dcc94) ([merge request](gitlab-org/gitlab!71415))
- [Don't retry errors when there are no replicas](gitlab-org/gitlab@0f27854a100931c96d18b79b9d903511c352405c) ([merge request](gitlab-org/gitlab!71489))
- [Delete issues css](gitlab-org/gitlab@97ffda63a12a951e8a5bce650487ce319b0196b0) ([merge request](gitlab-org/gitlab!71478))
- [Use GlAlert for external issues list errors](gitlab-org/gitlab@824b40be15edf9744ac06f52f55dcf6ee229b4ff) ([merge request](gitlab-org/gitlab!71256)) **GitLab Enterprise Edition**
- [Fix tabs switching between tree and roadmap](gitlab-org/gitlab@25e066d8364bb7127668bfbdc3f8fbce72dea9a7) ([merge request](gitlab-org/gitlab!71398)) **GitLab Enterprise Edition**
- [Fix: change dropdown background to transparent](gitlab-org/gitlab@87cec043a6eecba6189e61ea4dec5d6295b830b1) by @orozot ([merge request](gitlab-org/gitlab!71264))
- [Use GlAlert for integrations table errors](gitlab-org/gitlab@14123f51ffd9aa3ad202845f9ef98fbf2822eb3d) ([merge request](gitlab-org/gitlab!71255))
- [Removes reporting on non-existant failures for import rake task](gitlab-org/gitlab@2c6af766cf1044f730e325b4043e48f187c15ce3) ([merge request](gitlab-org/gitlab!71402))
- [Fix compliance framework labels readability](gitlab-org/gitlab@645b035a9e2c97e20e6a350d780658a6a93108ff) ([merge request](gitlab-org/gitlab!71301)) **GitLab Enterprise Edition**
- [Fix clipped broadcast message on login page when using custom header](gitlab-org/gitlab@593862859242f4318d935bc3529ee34547fc9f81) ([merge request](gitlab-org/gitlab!71227))
- [Fix issue search optimization in GraphQL](gitlab-org/gitlab@e0dee49402c289c4a53c16297e2f2da09aa81809) ([merge request](gitlab-org/gitlab!71351))
- [Expand template names when tracking inclusion](gitlab-org/gitlab@223a3c66bae0af4b233663d0f7cf6cd523229c24) ([merge request](gitlab-org/gitlab!71157))
- [Fix incorrect date in type of work chart](gitlab-org/gitlab@56ef35edb7d7ab0d68a61676b7f8d24262780713) ([merge request](gitlab-org/gitlab!71350)) **GitLab Enterprise Edition**
- [Fix: translate upload license tips](gitlab-org/gitlab@b5bb563377d941bd8db979242345cc61da1a0c98) by @orozot ([merge request](gitlab-org/gitlab!70640)) **GitLab Enterprise Edition**
- [Reapply table-layout fixed in repository file list](gitlab-org/gitlab@b20c171a54f1414cf5b98e4b1d086ed53e943103) ([merge request](gitlab-org/gitlab!71327))
- [Global Search - Upvote Tooltip Alignment](gitlab-org/gitlab@08e0e2c0adb067d5cbe8af9ed2786b54ebc2f14d) ([merge request](gitlab-org/gitlab!71226))
- [Prevent group wiki writes on read-only DBs](gitlab-org/gitlab@900b071936852a0675efd8938115f836284b5709) ([merge request](gitlab-org/gitlab!71314)) **GitLab Enterprise Edition**
- [Fix incorrect trigger of issue/epic autocomplete](gitlab-org/gitlab@09faec22a1ded63f52201d62edc43382161e5f29) ([merge request](gitlab-org/gitlab!71191)) **GitLab Enterprise Edition**
- [Fix Web IDE renaming empty content](gitlab-org/gitlab@04340139969234f992dd69bd0c807b3439afbee1) ([merge request](gitlab-org/gitlab!71130))
- [Fix milestone references in group context](gitlab-org/gitlab@c91b498592b73039a5d68e43e31359e8e55b6021) ([merge request](gitlab-org/gitlab!71269))
- [Value of `lock_memberships_to_ldap` should not affect authorizations](gitlab-org/gitlab@deb229258b6e659695dfc5df0de6f378ecc36cad) ([merge request](gitlab-org/gitlab!71253))
- [Remove file upload type restirction](gitlab-org/gitlab@32563ed72ca7aaca330bd8f8a2d1223127a11453) ([merge request](gitlab-org/gitlab!71082))
- [Fixed post merge ci status bug](gitlab-org/gitlab@b21dc4140ff30c16c571afdad29a0dba6f639d8e) ([merge request](gitlab-org/gitlab!70719))
- [Generate startup css as if com_and_canary](gitlab-org/gitlab@64eaa2de7dee16fff0d62b4231cc2b1631f0171f) by @leetickett ([merge request](gitlab-org/gitlab!71134))
- [Disable form on admin appearance sign-in page preview](gitlab-org/gitlab@4060fbbb578246b9d4acc6d2a534add63cfd397c) ([merge request](gitlab-org/gitlab!70736))
- [Add connection fallback to ActiveRecordProxy](gitlab-org/gitlab@b1b48aa28b302914c317f51beca546707ffda367) ([merge request](gitlab-org/gitlab!71059))
- [Update GitLab Shell to v13.21.1](gitlab-org/gitlab@ec1e172b96d2186ec0b914a95850e3ae353ccb0f) ([merge request](gitlab-org/gitlab!71037))
- [Fix Australian timezone abbreviations in tooltips](gitlab-org/gitlab@5451d41c1586cc83525178734b7c45b0b5234075) ([merge request](gitlab-org/gitlab!70723))
- [Merge branch 'jswain_combined_registration_auto_trial_params' into 'master'](gitlab-org/gitlab@4d1d5a4bc1dcc7b4c5969cc0c3cebf0dbbd665f3) ([merge request](gitlab-org/gitlab!70823)) **GitLab Enterprise Edition**
- [Provide namespace_id default value](gitlab-org/gitlab@45dfc11d0858e731d1544f98f93a193166e5ad92) ([merge request](gitlab-org/gitlab!70823))
- [Fix CSV issues import max file size message](gitlab-org/gitlab@f0e9076caeab2a8d786ad06128832c0abf4e41c6) by @JonstonChan ([merge request](gitlab-org/gitlab!68223))
- [Fix unmet prerequisites help URL](gitlab-org/gitlab@8b798847612a5ce3386d6dfb6df0371d5aea4e4b) ([merge request](gitlab-org/gitlab!70976))
- [Fix polling on vuln details page](gitlab-org/gitlab@5dd1f8c11e06a61476425db0696e292af09d2407) ([merge request](gitlab-org/gitlab!70961)) **GitLab Enterprise Edition**
- [Fix rule all branches not using monospace font](gitlab-org/gitlab@fe0df34d5f291d7eac1129bc15f5ac722b24c544) ([merge request](gitlab-org/gitlab!70943)) **GitLab Enterprise Edition**
- [Fix sum of LFS objects size with identical value](gitlab-org/gitlab@d2b2d298e41fdf237e40c404c005cea7a0924686) by @guillaume.chauvel ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/70610))
- [Fix project group share setting wording](gitlab-org/gitlab@56cedf5ba1f0437784ced6855922386d770bf4ff) ([merge request](gitlab-org/gitlab!70636))
- [Fix gitaly-backup TLS connections](gitlab-org/gitlab@e36cf16acc44cb223aee93b4d36c4d0281f3476f) ([merge request](gitlab-org/gitlab!70883))
- [Fix Content-Disposition header not working in Azure Blob storage](gitlab-org/gitlab@e586b6e3a58d66850ac32924c9ad1342daf24f1b) ([merge request](gitlab-org/gitlab!70874))
- [Handle ConnectionNotEstablished in the DB LB](gitlab-org/gitlab@cf3a0e3580c8649f1e2abe2f620993f739c3dba9) ([merge request](gitlab-org/gitlab!68042))
- [MR Analytics: Add yAxis formatter](gitlab-org/gitlab@9d7769a3a90ddd1712d5f1e6633d5f102a2a59e2) ([merge request](gitlab-org/gitlab!70573)) **GitLab Enterprise Edition**
- [Remove unnecessary route](gitlab-org/gitlab@d7b1c4dea176e84c706580806984ffa11753be7f) ([merge request](gitlab-org/gitlab!70277))
- [Fix address requires string literal i18n helpers](gitlab-org/gitlab@ee4394c4237fcd65a1e9d0597603210034634988) by @elcordova ([merge request](gitlab-org/gitlab!70767))
- [Fix DB connection check for Geo user routing](gitlab-org/gitlab@f908364d9888fa4cd37c6e5ca2555f1b936a9f39) ([merge request](gitlab-org/gitlab!70621)) **GitLab Enterprise Edition**
- [Update to commonmarker gem 0.23.2](gitlab-org/gitlab@57c5bad16c533bf7937f56bc05cbcc6a3d72004a) ([merge request](gitlab-org/gitlab!70612))
- [Focus on input when dropdown is shown on issue creation page](gitlab-org/gitlab@00a431b287132f8b833cf10ad99a2e61d50ec9e8) ([merge request](gitlab-org/gitlab!70703))
- [Replace public_send with send in doctor rake task](gitlab-org/gitlab@386ee2b5f21a5a8184ee78350f11a12803d118e1) ([merge request](gitlab-org/gitlab!69062))
- [Open sidebar after user creates a new item in boards](gitlab-org/gitlab@a8304104fe5158369354377df8a35001ec576e29) ([merge request](gitlab-org/gitlab!70352))
- [Geo: Fix maintenance mode causing Unhealthy secondary status](gitlab-org/gitlab@01551e03a1313d3f95dca66b5d27082ec59506b8) ([merge request](gitlab-org/gitlab!70010)) **GitLab Enterprise Edition**
- [Allow BoardListType.issues to filter by negated issueType in GraphQL](gitlab-org/gitlab@9debb183be68909ff7bf61adfaa02fb3a7e1b2e9) ([merge request](gitlab-org/gitlab!70554))
- [Add additional properties to policy_details helper](gitlab-org/gitlab@5645f93c630fe14fad2c418bc635cedde47c56b2) ([merge request](gitlab-org/gitlab!70553)) **GitLab Enterprise Edition**
- [Persist feedback alert for SAST Configuration](gitlab-org/gitlab@3343c3171a3e6ea202ca5f9db3751799fe8c6222) ([merge request](gitlab-org/gitlab!70517)) **GitLab Enterprise Edition**

### Changed (80 changes)

- [Implement Dependency proxy via Workhorse injectors](gitlab-org/gitlab@b3e6d6c37efba1418ecb33f6037582b1f8553f99) ([merge request](gitlab-org/gitlab!71890))
- [Added v-scrolling to both editors](gitlab-org/gitlab@2802a43f2f97f987ba0ddaeafc36c8c90beaeb6f) by @mehulsharma ([merge request](gitlab-org/gitlab!71136))
- [Update auto-deploy-image to v2.14.0](gitlab-org/gitlab@354fb973fc32958dd81dd70b5ab516f4ee26d9a8) ([merge request](gitlab-org/gitlab!72027))
- [Adjust update_runners_registration_token permission](gitlab-org/gitlab@6182eecf3b3a466864c2c192b4fcef9908822eeb) ([merge request](gitlab-org/gitlab!71965))
- [Remove feature flag member_destroy_async_auth_refresh](gitlab-org/gitlab@edde4d7ffabb30f69691f6bd99e06c82b4dfab8a) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/72338))
- [Disable create list button after clicked once](gitlab-org/gitlab@8d8de87a0be0628f23a1cda888a11559a079167c) ([merge request](gitlab-org/gitlab!72048))
- [Preselect all projects in group coverage analytics](gitlab-org/gitlab@88d4f5793b3d1f05675ca896d7514a7d1deb5243) ([merge request](gitlab-org/gitlab!72051)) **GitLab Enterprise Edition**
- [Allow longer Helm channel names](gitlab-org/gitlab@7e57516919e5cee8ae8c38890d4b8a18d10e54f0) by @sathieu ([merge request](gitlab-org/gitlab!71806))
- [Enable create_vulnerabilities_via_api by default](gitlab-org/gitlab@1a635aa386c3fb1dd6d6369fbfcbe16015aa85df) ([merge request](gitlab-org/gitlab!72204)) **GitLab Enterprise Edition**
- [Use allowlist of allowed attributes for imported models](gitlab-org/gitlab@3f30823920caef67d589e6f06c1cee2380d3d080) ([merge request](gitlab-org/gitlab!71296))
- [Refactor the usage of Secret Scanning to Secret Detection](gitlab-org/gitlab@48d35ae9509bc14affc7bd52fdd415f7b21b1434) ([merge request](gitlab-org/gitlab!71824))
- [Improve Git HTTPS message given when Gitaly unavailable](gitlab-org/gitlab@772df282e60924413931e0b0736fe11d94f4d3de) ([merge request](gitlab-org/gitlab!71120))
- [Remove `performance_roadmap` ff and legacy code](gitlab-org/gitlab@7be12de8acaa583818cb370f566a8e4d394b4259) ([merge request](gitlab-org/gitlab!71828)) **GitLab Enterprise Edition**
- [Respect security scanner schema](gitlab-org/gitlab@b7ea3dc21229f8c6a59087aca5b2e8c0368645f2) ([merge request](gitlab-org/gitlab!69961)) **GitLab Enterprise Edition**
- [Default enable use_upsert_query_for_mr_metrics FF](gitlab-org/gitlab@37723ac46e66416d1a7cb3e661d51f5525ba3d8b) ([merge request](gitlab-org/gitlab!72120))
- [Support Jira Connect asymmetric JWTs](gitlab-org/gitlab@e100bd3dfbf08eb27f2ee2c3b84438931144cf00) ([merge request](gitlab-org/gitlab!71080))
- [Improve translatability of email confirmation page](gitlab-org/gitlab@2809b8bbe0a1b8913ad097473612c17d09951db1) ([merge request](gitlab-org/gitlab!71165))
- [Remove vulnerability flags feature flag](gitlab-org/gitlab@d80460b160b2fb2f6704c10ea5108dee4785457e) ([merge request](gitlab-org/gitlab!71966))
- [Styling updates of the protected environments edit access dropdown](gitlab-org/gitlab@6582038a0b3dda66199cc4a309aae6a35ba70e98) ([merge request](gitlab-org/gitlab!71119)) **GitLab Enterprise Edition**
- [Clean up oauth buttons on sign in/up](gitlab-org/gitlab@72e5bf594fed8112539c89f97f77ba5bf81f708a) ([merge request](gitlab-org/gitlab!71263))
- [Improve merge train help text](gitlab-org/gitlab@c28b6bbd3c78d76f32816c51f006ea1ffb7e150c) ([merge request](gitlab-org/gitlab!71687)) **GitLab Enterprise Edition**
- [Update branch name to use monospace](gitlab-org/gitlab@cd6c3b3ccebb3a18bead8e572e509b7edc863eb2) ([merge request](gitlab-org/gitlab!71393)) **GitLab Enterprise Edition**
- [Remove redundant help text from runners](gitlab-org/gitlab@a0e98ddbd79b557fb97c1a9164bb14f47efc2669) ([merge request](gitlab-org/gitlab!71915))
- [Proxy Geo secondary HTTP pushes + lfs through Workhorse](gitlab-org/gitlab@f1812b88bd4498051cc2b011127dba8c6448f725) ([merge request](gitlab-org/gitlab!71732)) **GitLab Enterprise Edition**
- [Update compliance report title and navigation](gitlab-org/gitlab@906d78136dd1f7812e4af5c55c7f6ecfe1a438b2) ([merge request](gitlab-org/gitlab!71383)) **GitLab Enterprise Edition**
- [Change MR draft status notification from flash to tast](gitlab-org/gitlab@9aee4d3ef920636c2a0e51331efc796b6e4ae028) ([merge request](gitlab-org/gitlab!71887))
- [Allow minimal access value for UserHighestRole](gitlab-org/gitlab@a1165f69aaa0e62b9effd0733185ff2bd4fc45ab) ([merge request](gitlab-org/gitlab!71814)) **GitLab Enterprise Edition**
- [Add jsonb field for Finding Evidence](gitlab-org/gitlab@679ebf13709aa8440e58baa05539ad72b6e12e9b) ([merge request](gitlab-org/gitlab!70097))
- [Geo: Increase reliability of certain one-time jobs](gitlab-org/gitlab@b731a55c30cf8cbfd38fefc46659de1fe6a6d0f4) ([merge request](gitlab-org/gitlab!71419)) **GitLab Enterprise Edition**
- [Geo: Reduce unnecessary resource usage](gitlab-org/gitlab@a3bfd4b6cc11ecae16d9414c8d3337c0383271fa) ([merge request](gitlab-org/gitlab!71419)) **GitLab Enterprise Edition**
- [Geo: Reduce unnecessary resource usage](gitlab-org/gitlab@93127cfc6803616db47b321a826e643c1468d75a) ([merge request](gitlab-org/gitlab!71419)) **GitLab Enterprise Edition**
- [GithubImporter: Format diff note suggestions to the gitlab format](gitlab-org/gitlab@e4f59f2ecb0dd9958ab48c50dcd42ee0c6517ea8) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/71411))
- [system_check: Bump minimum required Git version to v2.33.0](gitlab-org/gitlab@8094ba64d14af82094fbcdcacc3d54c7aecee09f) ([merge request](gitlab-org/gitlab!71813))
- [Update SAST config primary action button variant](gitlab-org/gitlab@105b5e63a55545868c3a26b8fdfd8ed7939bb2d4) ([merge request](gitlab-org/gitlab!71783)) **GitLab Enterprise Edition**
- [Add rake task to pause or resume elastic indexing](gitlab-org/gitlab@6a60c27a05219d16980c924fffe6231cc1f4ef9d) ([merge request](gitlab-org/gitlab!71426)) **GitLab Enterprise Edition**
- [Changed cluster type badge to gitlab-ui element](gitlab-org/gitlab@f39cda9d1d654f58d379345db0eabfc23290f2a1) ([merge request](gitlab-org/gitlab!71504))
- [Move advanced_search_multi_project_select FF to user actor](gitlab-org/gitlab@1d43d927e587d3fff1ec94404c442da11033fdee) ([merge request](gitlab-org/gitlab!71416)) **GitLab Enterprise Edition**
- [Implement Dependency proxy via Workhorse injectors](gitlab-org/gitlab@c9c9a36a7decac3a0ee6986d4e42730814ccb250) ([merge request](gitlab-org/gitlab!68157))
- [Replace namespaces unique index on name and parent_id](gitlab-org/gitlab@db628d9df92faaee0b50bef7a1b525c2c2f974dc) ([merge request](gitlab-org/gitlab!71390))
- [Remove orchestration policies feature flag](gitlab-org/gitlab@705218f2d9be1d17f70f2dcaa91ac81c18827bb0) ([merge request](gitlab-org/gitlab!71516)) **GitLab Enterprise Edition**
- [Redirect threat_monitoring policies endpoints](gitlab-org/gitlab@a07a65b574471cf6b19a02b39140327455f0e4f5) ([merge request](gitlab-org/gitlab!71517)) **GitLab Enterprise Edition**
- [Add tooltips to runners badges](gitlab-org/gitlab@7e0ab139085e6b3da86b4be1dfafb42b7d043b16) ([merge request](gitlab-org/gitlab!71404))
- [Remove beta badge from GitLab Migration](gitlab-org/gitlab@b7fb1e66ebc384d67623c5ce3a287c41e9c851cd) ([merge request](gitlab-org/gitlab!71643))
- [Show author badge in comments](gitlab-org/gitlab@4a90dc4244ad54b9518d1818d2fcf2efb869e93c) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/40198))
- [Toggle banner using suggest_pipeline_enabled application setting](gitlab-org/gitlab@fac9b2b23bc60c0a53d7a1b7a950ed46d8b38ab9) ([merge request](gitlab-org/gitlab!71015))
- [Enable merge requests discussions cache](gitlab-org/gitlab@de3fa103478f104456ccdab85efe752178c03c92) ([merge request](gitlab-org/gitlab!71635))
- [Edit UI text of Abuse reports settings](gitlab-org/gitlab@2549f52084da0f575d1584b3c0afd73abfe60ffc) ([merge request](gitlab-org/gitlab!71276))
- [Prevent Workhorse panics when Geo proxy URL is unset](gitlab-org/gitlab@b3d88bdafdcbdf97eebd52596c4cd6967d3a4c26) ([merge request](gitlab-org/gitlab!71285)) **GitLab Enterprise Edition**
- [Improve deployment information on Jira Cloud app](gitlab-org/gitlab@1b0cbfb845f387eaa9e67edfcb1e504592623fb2) by @rbordignon ([merge request](gitlab-org/gitlab!70880))
- [Migrate branches nav from Bootstrap tabs to GlTabs](gitlab-org/gitlab@2b8a42b251094f9d811a6ba71cb03a4b9deddf55) ([merge request](gitlab-org/gitlab!71461))
- [Allow dots in Helm channel, but forbid repeated dots](gitlab-org/gitlab@de0602ad3197e37ac0d6a59f0271c3141dd5a04e) by @sathieu ([merge request](gitlab-org/gitlab!69278))
- [Remove analyzer_pipeline metrics join to ci_builds](gitlab-org/gitlab@f12722fd6c7e0e673c68e138632a6dabe9653039) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/71210)) **GitLab Enterprise Edition**
- [Update cluster management project template with new version of Falco](gitlab-org/gitlab@ee66cfee8865be5b1a959097451aa25b1a198fba) ([merge request](gitlab-org/gitlab!71446))
- [Update UI text in Group general settings](gitlab-org/gitlab@3b2b26758b6b6ea3af890190bf5eabc853c30c76) ([merge request](gitlab-org/gitlab!69869))
- [Allow removal of cloud licenses](gitlab-org/gitlab@7f7e8de72eea09b7e51eb74c26e73698fed75a0d) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/71481)) **GitLab Enterprise Edition**
- [Remove default value for time zone user preference](gitlab-org/gitlab@4840ed7f831c7d1fc6fd3a403b575bd0ed103c64) ([merge request](gitlab-org/gitlab!70834))
- [Exclude secret_detection findings from autoresolution](gitlab-org/gitlab@231545fd4cb47598b21e0bb6fbc364dd749bfec9) ([merge request](gitlab-org/gitlab!71436)) **GitLab Enterprise Edition**
- [Enable repo size limit and ip restriction](gitlab-org/gitlab@30bdbd2a95cd5af7e040116ea447f36e56a0e0a2) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/70912)) **GitLab Enterprise Edition**
- [Remove `async_filtering` feature flag](gitlab-org/gitlab@00bbc6810d5ac3099f3ee86c615587f36a7d6af3) ([merge request](gitlab-org/gitlab!71035))
- [Convert ee/geo/db/schema.rb to ee/geo/db/structure.sql](gitlab-org/gitlab@e900df0bcc90d24bb939de6e247fed9871562d31) ([merge request](gitlab-org/gitlab!71222)) **GitLab Enterprise Edition**
- [Updated the Cluster Agent Token table heading](gitlab-org/gitlab@d59a4d4a385927eb39248a4b75a6fdd2d9353d2e) ([merge request](gitlab-org/gitlab!71197)) **GitLab Enterprise Edition**
- [Fix DB load balance autoloading/code-reloading](gitlab-org/gitlab@91b7cf3e70237cdbd00b4d7ba4a82d21b28dc435) ([merge request](gitlab-org/gitlab!71218))
- [Remove "files" from end of default commit message in Web IDE](gitlab-org/gitlab@f096a5554a0743955d0706144cfc888c32947363) by @scootergrisen ([merge request](gitlab-org/gitlab!70582))
- [Ensure merge request header strings are internationalized](gitlab-org/gitlab@60611e55051d2d5614054957ce4e5fae233924c0) ([merge request](gitlab-org/gitlab!71093))
- [Add namespace_ancestry_ids migration](gitlab-org/gitlab@1fae3ce0c92aa764cdb15cb8438d3975dccb7ef1) ([merge request](gitlab-org/gitlab!70042)) **GitLab Enterprise Edition**
- [Update Copy on License Compliance CTA](gitlab-org/gitlab@c2dbfa7a023a0458008214bed0371b702faed78b) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/70923)) **GitLab Enterprise Edition**
- [Remove download text from pipeline artifact dropdown items](gitlab-org/gitlab@466b1125e758fdf87bfe3a5944ac659d0dbae8bf) by @fabsrc ([merge request](gitlab-org/gitlab!70982))
- [Add suggest_pipeline_enabled to application_settings](gitlab-org/gitlab@048800044f3a4d9c01d1977fc14559a1463cc4a1) ([merge request](gitlab-org/gitlab!70756))
- [Update deprecated GlIcon size in IDE preview navigator](gitlab-org/gitlab@b2b4570795732a0eae4665f03f7f1c064d03e53b) by @jameschensmith ([merge request](gitlab-org/gitlab!70960))
- [Block move and clone of requirement issues](gitlab-org/gitlab@3c18b544bbc2bb423e1ddc0a5c1944af48baf9d7) ([merge request](gitlab-org/gitlab!70439)) **GitLab Enterprise Edition**
- [Remove owner validation in AdditionalPack transfer](gitlab-org/gitlab@f5a1bcecabee1cc1ce91275026cec8c4f67b0035) ([merge request](gitlab-org/gitlab!70790)) **GitLab Enterprise Edition**
- [Update Rouge syntax highlighting gem](gitlab-org/gitlab@879628c8260b2b5813ce4d90a01a890bd0afe274) ([merge request](gitlab-org/gitlab!70738))
- [Check anonymous search access in API endpoints](gitlab-org/gitlab@5c2f3a7758cbba21bb229f0680945bb25a08d221) ([merge request](gitlab-org/gitlab!70290)) **GitLab Enterprise Edition**
- [Merge boards Apollo client](gitlab-org/gitlab@32dd42f07bcc37e9ed4d077dd42ba501840bb292) ([merge request](gitlab-org/gitlab!70375))
- [Bump swagger-ui-dist to 3.52.3](gitlab-org/gitlab@2d5caeba4714fcb860bc96789d2e40e1247bb39f) by @bufferoverflow ([merge request](gitlab-org/gitlab!70740))
- [Assign trial to only eligible namespace](gitlab-org/gitlab@16e6aeddd380f87fb4b13c38f15d5f4b66f26ae2) ([merge request](gitlab-org/gitlab!70196)) **GitLab Enterprise Edition**
- [Remove cutoff logic for expiration message](gitlab-org/gitlab@6ff13cf0e1217bcd459ef2a7c1d82c70098a6889) ([merge request](gitlab-org/gitlab!70584)) **GitLab Enterprise Edition**
- [Replace "Any branch" with "All branches"](gitlab-org/gitlab@1b256d5a93c9a76b71d07f9ef4a4e7d08bf73a8c) ([merge request](gitlab-org/gitlab!70552))
- [Re-organize Environment Action Buttons](gitlab-org/gitlab@528a22f0d7b4eda3a40b65c59f85d1b0eda44469) ([merge request](gitlab-org/gitlab!70228))
- [Fix multiple translation strings](gitlab-org/gitlab@6609b9fa4e3433ffa66a0ebb680a909e1b19071e) by @scootergrisen ([merge request](gitlab-org/gitlab!70182))

### Removed (9 changes)

- [Remove shared runners CTE FF](gitlab-org/gitlab@b47f6a628664b74d4f3aed1a1acf4b3178ac1cb2) ([merge request](gitlab-org/gitlab!72370))
- [Remove bio-html and cached_markdown_version from user_details](gitlab-org/gitlab@c045bb54932fa708163aa59b65de6ffe598f3fbd) ([merge request](gitlab-org/gitlab!71663))
- [Remove obsolete column for DevOps analytics](gitlab-org/gitlab@7fb3dcc912ad28fa859614ec099d746c8cd2d9d6) ([merge request](gitlab-org/gitlab!71907))
- [Drop Delayed Project Removal column from Namespaces](gitlab-org/gitlab@6262b4c53d99eeac2146b919f8cf43264d4ce256) ([merge request](gitlab-org/gitlab!71077))
- [Remove ignoring framework column for compliance project settings](gitlab-org/gitlab@973da3fc3a4b28a587c24118803d39b2998618d7) ([merge request](gitlab-org/gitlab!71634)) **GitLab Enterprise Edition**
- [Remove unused Debian distribution methods](gitlab-org/gitlab@bde080e16a3743523310c7b6929f26193bee835a) by @sathieu ([merge request](gitlab-org/gitlab!71502))
- [Remove project_level_issues_analytics FF](gitlab-org/gitlab@deba920fce7df9aed3ddb0ed49c5f899f9ad6d5d) ([merge request](gitlab-org/gitlab!71382))
- [Removed instance level serverless domains feature](gitlab-org/gitlab@e834417cb802979e6eba8073b5b6736b9168a8dc) ([merge request](gitlab-org/gitlab!71283))
- [Remove feature flag `ci_parallel_minutes_reset`](gitlab-org/gitlab@e106986cd1349c73347fd83592ebd7d2e876ca8b) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/71041)) **GitLab Enterprise Edition**

### Security (34 changes)

- [Add autocomplete attribute to most password fields](gitlab-org/gitlab@8a71c388de0e238b3e77e0dad55262023fb03533) ([merge request](gitlab-org/gitlab!72329))
- [Rename profile password fields so password managers understand](gitlab-org/gitlab@16820a9eea57095918942771c51845972e5cd408) ([merge request](gitlab-org/gitlab!71237))
- [Fix reverse tabnabbing issue](gitlab-org/gitlab@d133ec2ba23ea87e0bd8270a24341e9403757e01) ([merge request](gitlab-org/gitlab!71756))
- [Use v-safe-html in project_list_item.vue](gitlab-org/gitlab@14c07dd906f3666119c4cb6b3c4e3c2e338a5e54) by @Fall1ngStar ([merge request](gitlab-org/gitlab!70730))
- [Require password confirmation when user changes their primary email](gitlab-org/gitlab@086303a7529c480db08ee39173299f2ef4271b37) ([merge request](gitlab-org/gitlab!69439))
- [Fix XSS in Jira link](gitlab-org/gitlab@406fa2dfc40f5b7c54fd329f88125c37b851c631) **GitLab Enterprise Edition**
- [Return 404 if model id wasn't passed to UploadsController](gitlab-org/gitlab@c5fac89577d5576c570486dab91d7af099043f42)
- [Scrub artifacts signed URL in SendEntry logs](gitlab-org/gitlab@e9d2f771e6ca5d0eb84e90fa1973f90356ffce7c)
- [Prevent double-impersonation and impersonation breakout](gitlab-org/gitlab@780c8592b1e5c9f3ebb25682d22868d3e41d0ff8)
- [Clear session access tokens when starting/stopping impersonation](gitlab-org/gitlab@413f65cf961b9330d4455a3c7c96dbb5c3076593)
- [Require password param for 2FA changes](gitlab-org/gitlab@2fee55910eb9294aac3d096009e18afbf701b2e8)
- [Prevent users from bypassing 2FA on certain pages](gitlab-org/gitlab@5a52554984c540c0211a91169956cc7f3b8e511f)
- [Use validated URL when sending request to Gitea Importer](gitlab-org/gitlab@7af8abd4df9a98f7a1ae7c4ec9840d0a7a8c684d)
- [Fix permissions check on project members import](gitlab-org/gitlab@3b34c4e1e960dabc982c147b996ea4a3228f36fe)
- [Fix fogbugz importer DNS Rebind SSRF](gitlab-org/gitlab@395649cc463054467cfa9265f0f6d8a1a943226d)
- [Require group admin access to list pending invites](gitlab-org/gitlab@f4b8af4e6829d0ccfbf2f34caa0183908d622d66)
- [Do not export and import repository_size_limit](gitlab-org/gitlab@215ac57160a36faa55adfb4069c48a6e993be0f6)
- [Escapes MR approval rule names correctly](gitlab-org/gitlab@a3af82b0f065cbf449c8285db91d8837a7208f17)
- [Disable exporting pipeline triggers on project export](gitlab-org/gitlab@4195b918418786babcc71af51b61ea3fad107a8a)
- [Add pagination to dependencies API](gitlab-org/gitlab@5eeb99760ce78b28e8e77361daec438a1c588d31) **GitLab Enterprise Edition**
- [Filter shared groups autocomplete by permitted](gitlab-org/gitlab@faf9969eb78296e8f20bee8bac6563f6f02ea07a) **GitLab Enterprise Edition**
- [Apply account locking to password reset page](gitlab-org/gitlab@38a3aceb6e20e52d6f2a554dcdf6c4828d2d49a2)
- [Verify state before using errors from OAuth2 OmniAuth providers](gitlab-org/gitlab@79457dafe5558446504e7cdda33f2731e4033d62)
- [Fix GFM autocomplete xss](gitlab-org/gitlab@bd9bc17acd5930c5830f67ae8becdf7b8e7b4550)
- [Remove related project access tokens when a project is deleted](gitlab-org/gitlab@ff76361cba4561a13fca600afe431a50137e4f45)
- [Do not allow status checks to exist with external protected branches](gitlab-org/gitlab@dd5d6c9dda012e3776eddf89ddbc74073b5d40d5) **GitLab Enterprise Edition**
- [Permission check issuable template API data](gitlab-org/gitlab@dbad14b7fac92ed9cae602a3e30676703f406e62) **GitLab Enterprise Edition**
- [Require access token for git when 2fa is required](gitlab-org/gitlab@79c523c3f9ade423ad960f8bd30b686759eda29f)
- [Prohibit anonymous access for specific user API endpoint](gitlab-org/gitlab@635002da5981dc88c0942bb11ae4a14e7601362f)
- [Respect disabled import sources when initiating import via API](gitlab-org/gitlab@0dec589a9811e4ed72002116fcc89ca65447cb72)
- [Prevent showing not allowed subgroup epics](gitlab-org/gitlab@c77693d4154db385a292b1a290598b145ac20a57) **GitLab Enterprise Edition**
- [Prevent moving epic issues to different group hierarchy](gitlab-org/gitlab@eefca514c7716dc7071de8a3de9567f1a97d66df) **GitLab Enterprise Edition**
- [Fix denial-of-service attack in Markdown parser](gitlab-org/gitlab@1315787019130f5e65ef00dc166721dd703a2908)
- [Enforce configured scopes for Oauth applications](gitlab-org/gitlab@31cc65d79b44e43108f7eeac06496c12cf9f8ee3)

### Performance (27 changes)

- [Set X-Requested-With for startup JS requests](gitlab-org/gitlab@5b10ead1fc4d7fdf8836f210a70825ba1834cd7b) ([merge request](gitlab-org/gitlab!72360))
- [Use Group linear ancestor scopes](gitlab-org/gitlab@e2664d387b9e50ea25253044bb6792983dd5992c) ([merge request](gitlab-org/gitlab!70708)) **GitLab Enterprise Edition**
- [Skip secure product metrics in service ping](gitlab-org/gitlab@a7895ff78405735fc0a9be4e9339f45aec7d6023) ([merge request](gitlab-org/gitlab!72198)) **GitLab Enterprise Edition**
- [Clean up failed archive when no more attempts left](gitlab-org/gitlab@22bdd739efbfabc999544aac0c17f6719024237e) ([merge request](gitlab-org/gitlab!71878))
- [Render gitaly-unavailable error for Tags page](gitlab-org/gitlab@9a20a93028cc1ff4e9191f3204549a2f71393705) ([merge request](gitlab-org/gitlab!71078))
- [Enable FF "reference_cache_memoization" by default](gitlab-org/gitlab@a1ad071bc5d8bb2a31545c90f02d91d4d78cf045) ([merge request](gitlab-org/gitlab!71731))
- [Enable FF "tags_finder_gitaly" by default](gitlab-org/gitlab@bf59b0925716dd5342cd9d77396ca0adf74d5ff3) ([merge request](gitlab-org/gitlab!71743))
- [Quarantine broken security_products_usage metrics](gitlab-org/gitlab@417a1319e87b37aea0b987736d2920e17a50f1b6) ([merge request](gitlab-org/gitlab!71722)) **GitLab Enterprise Edition**
- [Preload user project access in group API](gitlab-org/gitlab@c6bc7f71703844a96e0781da5c1e4d12ac2b0c23) ([merge request](gitlab-org/gitlab!71631))
- [User ParticipantService linear ancestor scopes](gitlab-org/gitlab@133206812814dbea34ad7c9673bcb8849d2497f3) ([merge request](gitlab-org/gitlab!70684))
- [Use GroupPlansPreloader linear ancestor scopes](gitlab-org/gitlab@5bffbad5917195c4eff72570a5798e5a5aa81d29) ([merge request](gitlab-org/gitlab!70685)) **GitLab Enterprise Edition**
- [Use specialized worker to refresh authorizations on group-share update](gitlab-org/gitlab@fa1d31ee1f88ba8d659f3d14ef06bc2867ee19ae) ([merge request](gitlab-org/gitlab!70361))
- [Disable BatchLoader replace_methods by default](gitlab-org/gitlab@cac51506144d441abf74026b788ee5c9fedb0452) ([merge request](gitlab-org/gitlab!71364))
- [Avoid loading project namespace for id](gitlab-org/gitlab@c5b9c6b5c600827f24b0d97bf30c97644abada19) ([merge request](gitlab-org/gitlab!71051))
- [Use MembersFinder ancestors linear scopes](gitlab-org/gitlab@ea414318775364ceeecc5d5a9b812fcdc5f7d758) ([merge request](gitlab-org/gitlab!70583))
- [Use ApplicationSetting ancestors linear scopes](gitlab-org/gitlab@d7aaa809a62bd5a9668f06fe554c1f12c8dbec66) ([merge request](gitlab-org/gitlab!70579)) **GitLab Enterprise Edition**
- [Disable replace_methods in users autocomplete](gitlab-org/gitlab@6d0b7babd98d253fe65153653a8e3ba23372ac7e) ([merge request](gitlab-org/gitlab!71262))
- [Remove priority sort from board list issues](gitlab-org/gitlab@30820e968005dafccf66be6fc5fe534bd8c05d4a) ([merge request](gitlab-org/gitlab!70674))
- [Use GroupTree ancestors linear scopes](gitlab-org/gitlab@c1f9f33079d41594f41507f830d90164caecc59d) ([merge request](gitlab-org/gitlab!70503))
- [Replace Group ancestors scope with linear version](gitlab-org/gitlab@bd908d325f2989e184c016bbf6ffa2f34ac9f7b3) ([merge request](gitlab-org/gitlab!70495))
- [Add concurrent index for selecting resource_group from ci_builds](gitlab-org/gitlab@f5fb3b4b90e0806453f7ffa418edf904d9c6632f) ([merge request](gitlab-org/gitlab!70911))
- [Skip keep_around commit callback if `skip_keep_around_commits` is true](gitlab-org/gitlab@7abd7d2d47888ea92459534a42734ac734bc0eef) ([merge request](gitlab-org/gitlab!69910))
- [Add index for vulnerability_occurrences image location](gitlab-org/gitlab@44e892e7f517e26ec52cdfb9d9b8c7552b20e761) ([merge request](gitlab-org/gitlab!70275))
- [Improve retrieving default branch of empty repos](gitlab-org/gitlab@c5ccb9261e05c38fbe0956bc563556481e32c783) ([merge request](gitlab-org/gitlab!70116))
- [Update pending builds namespace traversal ids](gitlab-org/gitlab@9aa02e07af6a936244b88b4c873a866cea4fb65e) ([merge request](gitlab-org/gitlab!70691))
- [Use specialized worker to refresh authorizations on project transfer](gitlab-org/gitlab@34f5f02a72b710cf97b6ed8526dc42b4c026aa07) ([merge request](gitlab-org/gitlab!70356))
- [Add a `uniq` filter to SHAs passed to the keep around service](gitlab-org/gitlab@e3b599c5bdcebd15b117e039b58e4c98349ac652) ([merge request](gitlab-org/gitlab!70323))

### Other (41 changes)

- [Remove feature flag for pipeline editor drawer](gitlab-org/gitlab@28f635fffc9f2db4d2c43bff9afac4b2b3f44bdc) ([merge request](gitlab-org/gitlab!72237))
- [Improve UX of group two factor grace period input](gitlab-org/gitlab@84208b270b1ce7148a1db0caaca50e2111348342) ([merge request](gitlab-org/gitlab!72280))
- [Remove metrics that keeps count of deleted container images](gitlab-org/gitlab@96806577b479cddf2e0e1b0a8a417702ee5e3865) by @edith007 ([merge request](gitlab-org/gitlab!70983)) **GitLab Enterprise Edition**
- [Remove metric that keeps track of published Debian packages](gitlab-org/gitlab@5193a7f3c2512c05cffab2627ae0a86f9a45a535) by @edith007 ([merge request](gitlab-org/gitlab!70988)) **GitLab Enterprise Edition**
- [Remove the FF ci_idempotent_pipeline_process_worker](gitlab-org/gitlab@30b3172abc9592c640412641f9f420201bcfc019) ([merge request](gitlab-org/gitlab!72297))
- [Remove metric that keeps track of downloaded container images](gitlab-org/gitlab@460b8f2e3a41a5fbf6e6ecfc83c4ead68c23a28c) by @edith007 ([merge request](gitlab-org/gitlab!70985)) **GitLab Enterprise Edition**
- [Add Google Analytics ID to gitlab_standard schema for snowplow](gitlab-org/gitlab@a9522b5e8afd76353fc9fb0d92d32e46b03b7f6f) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/71242))
- [Remove metric that keeps track of published container images](gitlab-org/gitlab@2a4246d2ad491d1f96437a5277a7f0931dd8bf6c) by @edith007 ([merge request](gitlab-org/gitlab!70987)) **GitLab Enterprise Edition**
- [Remove the FF ci_include_rules](gitlab-org/gitlab@53e9d5fb9f1fd021566b1d2f5cd1556207be9194) ([merge request](gitlab-org/gitlab!72122))
- [Always use rate limiting Redis](gitlab-org/gitlab@5bc8987a710cc84aa399d99f3336523bffbc957f) ([merge request](gitlab-org/gitlab!72113))
- [Cleanup delete orphaned deployments background migration](gitlab-org/gitlab@233858c7e8e63cc3b3405621ceee8c73d73c8495) ([merge request](gitlab-org/gitlab!66600))
- [Remove feature flag disable_joins_upstream_downstream_projects](gitlab-org/gitlab@76d008a4d5b5bc4a08760e3d1c863b0668767c6b) ([merge request](gitlab-org/gitlab!71968))
- [Do not append hash to pseudonymized URL](gitlab-org/gitlab@768d0801050fe83d8e81a6abbf9cbf34bfb6534a) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/71335))
- [Remove test summary widget usage ping feature flag](gitlab-org/gitlab@5d780fc9ec7b0dbfc6df1bed102c5b6006a409c6) ([merge request](gitlab-org/gitlab!71781))
- [Remove sync_namespace_name_with_cdot flag](gitlab-org/gitlab@467a39884503f3f387760b503943e447e8fa6c7e) ([merge request](gitlab-org/gitlab!71763))
- [Set `assumeImmutableResults` to `true` in access tokens Apollo config](gitlab-org/gitlab@a2d295513d9ba4a336997388b696302110bf12b5) by @imrishabh18 ([merge request](gitlab-org/gitlab!70873))
- [Remove unused struct field](gitlab-org/gitlab@916a647334b542ad4b011c28a511bc4a5dd9ac10) ([merge request](gitlab-org/gitlab!71738))
- [Re Reschedule Delete Orphaned Deployments BG migration](gitlab-org/gitlab@4fc0ad4eebce4f76bad344913cf16c340dfb0d62) ([merge request](gitlab-org/gitlab!71700))
- [Refactor compliance framework UI and documentation](gitlab-org/gitlab@0b3b96373f0633fd333f87d0446faa9657a9831b) ([merge request](gitlab-org/gitlab!70258)) **GitLab Enterprise Edition**
- [Remove the FF ci_pipeline_add_job_with_lock](gitlab-org/gitlab@7bb475a84b5411dd71cf04d62dc760837af432a6) ([merge request](gitlab-org/gitlab!71652))
- [Remove project authorizations API FF](gitlab-org/gitlab@6a4e306aa856dc9cbfb31d070f5edc20491ff10d) ([merge request](gitlab-org/gitlab!71638))
- [Revise UI text for Usage Statistics](gitlab-org/gitlab@6f7df4eabd0fe12bd735562b1c61704f62438d08) ([merge request](gitlab-org/gitlab!71473))
- [Removes `track_epic_boards_activity` feature flag](gitlab-org/gitlab@3a3c53a19f8e14a11872afc5bfbea9be1ebb7a7e) ([merge request](gitlab-org/gitlab!71552))
- [Remove pages_smart_check_outdated_sha feature flag](gitlab-org/gitlab@b68e407fe931b4c6c2912926c8a576448cba65ea) ([merge request](gitlab-org/gitlab!71530))
- [Additional tests of #work_in_progress?](gitlab-org/gitlab@bab351e939be61d330dc683bbeb638a132410079) ([merge request](gitlab-org/gitlab!71437))
- [Use varchar_pattern_ops indexes for labels](gitlab-org/gitlab@dbf00facaf0d5aab14455f524d0608a133abd14c) ([merge request](gitlab-org/gitlab!70770))
- [Update runner status descriptions](gitlab-org/gitlab@471c067f8de82a6ae83282cad16fec9dfed0fb30) ([merge request](gitlab-org/gitlab!71447))
- [Make build_id param as required when updating CI minutes async](gitlab-org/gitlab@fd716d443a31f7a22716c2feec11deb65f084d65) ([merge request](gitlab-org/gitlab!71297)) **GitLab Enterprise Edition**
- [Remove FF ci_remove_update_retried_from_process_pipeline](gitlab-org/gitlab@6d3b53f4fd3925ca38cf0c75e9941d60e23e71f3) ([merge request](gitlab-org/gitlab!71201))
- [Filter Welcome to GitLab console message from capybara](gitlab-org/gitlab@511d56f0fdbec074930037f587737d7066002a1c) by @leetickett ([merge request](gitlab-org/gitlab!71151))
- [Remove redundant index on taggings table](gitlab-org/gitlab@5124a0375265ede986eed631e9cfad7cf1400642) ([merge request](gitlab-org/gitlab!71083))
- [Update additional CI minute docs](gitlab-org/gitlab@1d74e66b394c9d5418f0d2f277bd61ddb3de1b98) ([merge request](gitlab-org/gitlab!70934))
- [Drop old int4 PK column for push_event_payloads](gitlab-org/gitlab@6e19f4eee1eafd432619d7fbf0d897ef2e622776) ([merge request](gitlab-org/gitlab!70920))
- [Drop old int4 PK column for events](gitlab-org/gitlab@2de6a4f4784f68e2a8e2680b1273d76f9ad21023) ([merge request](gitlab-org/gitlab!70915))
- [Remove foreign key from terraform_state_versions to ci_builds](gitlab-org/gitlab@1f99a8584dd7573c64e658712d504474404120f7) ([merge request](gitlab-org/gitlab!70743))
- [Drop old int4 PK columns for ci_sources_pipelines](gitlab-org/gitlab@fecfc17771721bd94dbb4a2ca60ce97f149e5e60) ([merge request](gitlab-org/gitlab!70896))
- [Drop old int4 PK columns for ci_job_artifacts](gitlab-org/gitlab@751d343ebf822966ec66bc59e954601ca6639a66) ([merge request](gitlab-org/gitlab!70884))
- [Cleanup bigint conversion for ci_builds_metadata](gitlab-org/gitlab@fbf66ae98289e7ad5b0d8a126b8b92d8a29aa8fb) ([merge request](gitlab-org/gitlab!69712))
- [Remove pipeline foreign keys from package tables](gitlab-org/gitlab@3b8d317b98a2054f2a6251b02940974bb3a74d5d) ([merge request](gitlab-org/gitlab!70614))
- [Cleanup bigint conversion for ci_builds](gitlab-org/gitlab@176992aa2b2e76b22637a07d5bafbd6541324a7d) ([merge request](gitlab-org/gitlab!70351))
- [Drop support for data-track-event](gitlab-org/gitlab@ac6027fbef6adf41643412a84945fda6f15c9666) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/70234))

## 14.3.6 (2021-12-03)

No changes.

## 14.3.5 (2021-11-26)

### Fixed (6 changes)

- [Allow SSO callbacks through maintenance mode](gitlab-org/gitlab@f9b250145ac3db5fb01698839f1b5f3d9d349945) ([merge request](gitlab-org/gitlab!75145)) **GitLab Enterprise Edition**
- [Geo - Fix no repo error message for group-level wikis](gitlab-org/gitlab@5560e012bd6f35431d4d1cea389807ca475c2ce5) ([merge request](gitlab-org/gitlab!75145)) **GitLab Enterprise Edition**
- [Prevent Git operations from checking replication lag on non-Geo-secondary sites](gitlab-org/gitlab@35344d81d5e07bfb4db997be6c4f99f39a16562e) ([merge request](gitlab-org/gitlab!75145)) **GitLab Enterprise Edition**
- [Fix error 500 loading branch with UTF-8 characters with performance bar](gitlab-org/gitlab@08b47c2870cc338021bb3f945ac6736e46abf376) ([merge request](gitlab-org/gitlab!75145))
- [Remove defaultAuthors from MR Analytics and VSA](gitlab-org/gitlab@be95c921623056d31e2cbc0a7bc96de3aa66ca65) ([merge request](gitlab-org/gitlab!75145))
- [Allow SSO callbacks through maintenance mode](gitlab-org/gitlab@0727751512d41537356b295d6b889e05c6a07480) ([merge request](gitlab-org/gitlab!74706)) **GitLab Enterprise Edition**

## 14.3.4 (2021-10-28)

### Security (13 changes)

- [Highlight usage of unicode bidi characters](gitlab-org/security/gitlab@0b9bcafa73bc12ad873f75584b993f7b94f1f2e7) ([merge request](gitlab-org/security/gitlab!1938))
- [Fix dompurify.js to prevent path traversal attacks](gitlab-org/security/gitlab@6599afd4d7357ab356fcb773af19f8388978b3ed) ([merge request](gitlab-org/security/gitlab!1930))
- [Refresh authorizations on transfer of groups having project shares](gitlab-org/security/gitlab@faad71f44a1b1048b73897d450c923a18ec18c0b) ([merge request](gitlab-org/security/gitlab!1917))
- [Do not allow Applications API to create apps with blank scopes](gitlab-org/security/gitlab@293931500c84ef7ea9a2117d3ddf094f8ac15dcf) ([merge request](gitlab-org/security/gitlab!1923))
- [Don't allow author to resolve discussions when MR is locked via GraphQL](gitlab-org/security/gitlab@5027cb2b0303645a921b95d324d3d55dcf7632e4) ([merge request](gitlab-org/security/gitlab!1920))
- [Workhorse: Allow uploading only a single file](gitlab-org/security/gitlab@c18c2ddfa34a4c3e476136ab3eba9be7f265ad59) ([merge request](gitlab-org/security/gitlab!1914))
- [Group owners should see SCIM token only once](gitlab-org/security/gitlab@3d6664461da720fb256d8e139961b383e33a3b90) ([merge request](gitlab-org/security/gitlab!1907)) **GitLab Enterprise Edition**
- [Respect visibility level settings when updating project via API](gitlab-org/security/gitlab@124ca62c02bfa8ef6f7de7b328f80756fd01c052) ([merge request](gitlab-org/security/gitlab!1904))
- [Avoid decoding the whole tiff image on isTIFF check](gitlab-org/security/gitlab@8e6ffd52f50170a5cf2761e50a3d6efaca5fe64f) ([merge request](gitlab-org/security/gitlab!1900))
- [Adding a '[redacted]' to mask private email addresses](gitlab-org/security/gitlab@6f2a2b2240eb7590bbc773f35d3927d4854a31b5) ([merge request](gitlab-org/security/gitlab!1894))
- [Do not display the root password by default](gitlab-org/security/gitlab@87893548183fc4a111e12c0bdb3e409175a41668) ([merge request](gitlab-org/security/gitlab!1803))
- [Set PipelineSchedules to inactive](gitlab-org/security/gitlab@0e77e1cd938f876f3e9c049a84486c8c90cd0f3f) ([merge request](gitlab-org/security/gitlab!1879))
- [Remove external_webhook_token from exported project](gitlab-org/security/gitlab@1362f7481aad5e4295da11f0db53e31600c7c7b5) ([merge request](gitlab-org/security/gitlab!1866))

## 14.3.3 (2021-10-12)

### Fixed (3 changes)

- [Disable caching of MergeToRefService call in mergeability check](gitlab-org/gitlab@ea9f38fb3ce1f9b345ca699b5f9ae7b36726a56f) ([merge request](gitlab-org/gitlab!72179))
- [Fix 2FA setup for users with no password](gitlab-org/gitlab@c6d5cdfc3fa1a1dc0a6686a8f189972c03403f7a) ([merge request](gitlab-org/gitlab!72179))
- [Fix dependency proxy image prefix](gitlab-org/gitlab@deb9719db05e99dec787bd76c5e96408f92eb802) ([merge request](gitlab-org/gitlab!72179))

## 14.3.2 (2021-10-01)

### Fixed (1 change)

- [Update GitLab Shell to v13.21.1](gitlab-org/gitlab@9e9e41f2ae9bdb89355c0f9cef486950bbaf361c) ([merge request](gitlab-org/gitlab!71513))

### Changed (1 change)

- [Remove `async_filtering` feature flag](gitlab-org/gitlab@c4277c1fed0de3d86694390641612bfcde30cc92) ([merge request](gitlab-org/gitlab!71513))

## 14.3.1 (2021-09-30)

### Security (29 changes)

- [Fix permissions check on project members import](gitlab-org/security/gitlab@63ba9ad2a1067eb74df493e273707bb64a13a197) ([merge request](gitlab-org/security/gitlab!1858))
- [Require password param for 2FA changes](gitlab-org/security/gitlab@f246cfbd15344ba74a0182276bf63f0b5f1a4a31) ([merge request](gitlab-org/security/gitlab!1813))
- [Respect disabled import sources when initiating import via API](gitlab-org/security/gitlab@046e964b0151fc8c58063281a39af063ffb678bd) ([merge request](gitlab-org/security/gitlab!1846))
- [Return 404 if model id wasn't passed to UploadsController](gitlab-org/security/gitlab@747e6f0e4aec39462f296fd56b37df1c255d29cb) ([merge request](gitlab-org/security/gitlab!1843))
- [Scrub artifacts signed URL in SendEntry logs](gitlab-org/security/gitlab@f6c57892ddc9518efaace1021346b42b4c805a1c) ([merge request](gitlab-org/security/gitlab!1840))
- [Prevent double-impersonation and impersonation breakout](gitlab-org/security/gitlab@615d418f9315ca3b3619689c47201f618cf6bde9) ([merge request](gitlab-org/security/gitlab!1834))
- [Clear session access tokens when starting/stopping impersonation](gitlab-org/security/gitlab@62c2e0d3ed73f2d7ded90d04fe232ff6ae2f6136) ([merge request](gitlab-org/security/gitlab!1831))
- [Prevent users from bypassing 2FA on certain pages](gitlab-org/security/gitlab@0b41838b36da09a9230de4d8449040a701464de7) ([merge request](gitlab-org/security/gitlab!1827))
- [Use validated URL when sending request to Gitea Importer](gitlab-org/security/gitlab@26731d762f6503fe1b8b509be11c56e77601a552) ([merge request](gitlab-org/security/gitlab!1822))
- [Fix XSS in Jira link](gitlab-org/security/gitlab@d41060acb2aa151119042db9162a102d4e2c15ab) ([merge request](gitlab-org/security/gitlab!1819)) **GitLab Enterprise Edition**
- [Fix fogbugz importer DNS Rebind SSRF](gitlab-org/security/gitlab@cc13d57c66cc65e6f920bdeab57b9fdb9d6baac1) ([merge request](gitlab-org/security/gitlab!1814))
- [Remove related project access tokens when a project is deleted](gitlab-org/security/gitlab@d32c0d57d5b39601034c4c4ae983ea80c05db429) ([merge request](gitlab-org/security/gitlab!1810))
- [Require group admin access to list pending invites](gitlab-org/security/gitlab@911bb0cb78e00934c491af59729fa84fffae7676) ([merge request](gitlab-org/security/gitlab!1793))
- [Do not export and import repository_size_limit](gitlab-org/security/gitlab@0f3feca459895fc6665f8b0dfc16d4dcd7112944) ([merge request](gitlab-org/security/gitlab!1770))
- [Escapes MR approval rule names correctly](gitlab-org/security/gitlab@4fcd97230bbc31780fe14d75694bb6433d57e677) ([merge request](gitlab-org/security/gitlab!1807))
- [Filter shared groups autocomplete by permitted](gitlab-org/security/gitlab@b5144abb0516af61686402c2ad720967d11cb03c) ([merge request](gitlab-org/security/gitlab!1804)) **GitLab Enterprise Edition**
- [Require access token for git when 2fa is required](gitlab-org/security/gitlab@ea22f67b47bf0d6c801f2bf6c9672c0ea5afd30c) ([merge request](gitlab-org/security/gitlab!1794))
- [Prohibit anonymous access for specific user API endpoint](gitlab-org/security/gitlab@c52890997ad574812ae4da968f2f6ecfd9f7ff59) ([merge request](gitlab-org/security/gitlab!1792))
- [Disable exporting pipeline triggers on project export](gitlab-org/security/gitlab@f7f18fbdd8e81a9b3e0650250316c7bb17ac1956) ([merge request](gitlab-org/security/gitlab!1791))
- [Add pagination to dependencies API](gitlab-org/security/gitlab@203328889059564ba6085663b21355149c01e501) ([merge request](gitlab-org/security/gitlab!1726)) **GitLab Enterprise Edition**
- [Do not allow status checks to exist with external protected branches](gitlab-org/security/gitlab@327d8080e7e7b0bc77b7933f8026ec0cf1abd99a) ([merge request](gitlab-org/security/gitlab!1788)) **GitLab Enterprise Edition**
- [Permission check issuable template API data](gitlab-org/security/gitlab@de7851c2ab58c31df49c8a406ed0c3f3ad779e26) ([merge request](gitlab-org/security/gitlab!1785)) **GitLab Enterprise Edition**
- [Apply account locking to password reset page](gitlab-org/security/gitlab@050dfa71191ffaea77a4a18e0dea1f3336f40db5) ([merge request](gitlab-org/security/gitlab!1782))
- [Enforce configured scopes for Oauth applications](gitlab-org/security/gitlab@ce83bb14b5a4521f889086a439f1628041843589) ([merge request](gitlab-org/security/gitlab!1779))
- [Verify state before using errors from OAuth2 OmniAuth providers](gitlab-org/security/gitlab@dcc2cad6c03255ac70f29ed9c0f6c8bc11ac1018) ([merge request](gitlab-org/security/gitlab!1776))
- [Prevent moving epic issues to different group hierarchy](gitlab-org/security/gitlab@167601717f2ad46fee2320af6ac49674026501be) ([merge request](gitlab-org/security/gitlab!1772)) **GitLab Enterprise Edition**
- [Fix GFM autocomplete xss](gitlab-org/security/gitlab@8816ab6af1d1aa752f22da7850d4d1c983f2d43a) ([merge request](gitlab-org/security/gitlab!1767))
- [Prevent showing not allowed subgroup epics](gitlab-org/security/gitlab@b841c78c47b6a56b618186720bffc26922807356) ([merge request](gitlab-org/security/gitlab!1764)) **GitLab Enterprise Edition**
- [Fix denial-of-service attack in Markdown parser](gitlab-org/security/gitlab@5e5973b5c28862381729408ba4df650c3d4f7ce0) ([merge request](gitlab-org/security/gitlab!1730))

## 14.3.0 (2021-09-21)

### Added (111 changes)

- [Add organizations update mutation to GraphQL](gitlab-org/gitlab@9375734734a090d186da58cb5d1ece7d886318f8) by @leetickett ([merge request](gitlab-org/gitlab!69559))
- [Auto-scope board to iteration cadence](gitlab-org/gitlab@3015a0232caa9641266130bd905942ece2758d16) ([merge request](gitlab-org/gitlab!69030))
- [Decouple project runners queuing query from projects table](gitlab-org/gitlab@04a2a99342e8db67058ee6534e4166ca0a8a4914) ([merge request](gitlab-org/gitlab!70415))
- [Add owner validation for project namespaces](gitlab-org/gitlab@a30da0a109d54f5254498d70977e3e2be69f9901) ([merge request](gitlab-org/gitlab!69201))
- [Add ProjectNamespace model and DB relationships](gitlab-org/gitlab@6914cf3c13c2ca6f325ae273944f4c2172691451) ([merge request](gitlab-org/gitlab!69201))
- [Upgrade Pages to 1.44.0](gitlab-org/gitlab@2e2263965716a3dd7c3f427f9876d50183a9a3ef) ([merge request](gitlab-org/gitlab!70484))
- [Add docs on how to use AWS server side encryption for backups](gitlab-org/gitlab@00eeff9dd13ad4a515655630cc9f006ca2ec8c75) ([merge request](gitlab-org/gitlab!70327))
- [Persist projects configured to use an Agent](gitlab-org/gitlab@3a80bebfcb49b4315c91d3ac3863f06d692fc000) ([merge request](gitlab-org/gitlab!67295))
- [Enable Pages replication with Geo by default](gitlab-org/gitlab@5f9c6a945c6f46294ede78b5b1ae82b2d8239c92) ([merge request](gitlab-org/gitlab!70434)) **GitLab Enterprise Edition**
- [Address the PK Overflow risk for the ci_build_needs - Step 3](gitlab-org/gitlab@c789075c2907e6689d61e9f3c0ff6943018a4c9c) ([merge request](gitlab-org/gitlab!69473))
- [Extend `marginalia` to provide `db_config_name`](gitlab-org/gitlab@24e07a2a61cc981f401fd886e39940305cc3699c) ([merge request](gitlab-org/gitlab!67328))
- [Enable Roadmap daterange presets](gitlab-org/gitlab@3dccdb1fc8a795ea8e6fd23710362f0ef8b6a146) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/55639)) **GitLab Enterprise Edition**
- [Test project namespace is destroyed with project_namespace.rb](gitlab-org/gitlab@93ff65e15fa779f6ecebef03a98443972efd6222) ([merge request](gitlab-org/gitlab!69200))
- [Add DastSiteValidations status filter (disabled)](gitlab-org/gitlab@dd35063df15f3e542487de378b988043b0c3f249) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/70126)) **GitLab Enterprise Edition**
- [Allow using inherited description templates on service desk](gitlab-org/gitlab@1b8efb7913d6dbe562c01bfb0a1189cb7b939aef) ([merge request](gitlab-org/gitlab!67786)) **GitLab Enterprise Edition**
- [Gitaly repository tree keyset pagination](gitlab-org/gitlab@fd8c25e35a4e5126053ec534f0f3ac62167f3c2f) ([merge request](gitlab-org/gitlab!67509))
- [Sort scoped labels first in issuable sidebar](gitlab-org/gitlab@622853e25838fc0a2e287bbf5ce3b6cfa79aa19a) by @leetickett ([merge request](gitlab-org/gitlab!67794))
- [Enable surfacing false positives for vulnerabilities](gitlab-org/gitlab@9314dffe0d085d2db733d0ebf7f419683cd5e9b4) ([merge request](gitlab-org/gitlab!69700))
- [Remove related todos when a design is archived](gitlab-org/gitlab@e3672ba77d7ff44d5782c3d2e359753184512e2d) ([merge request](gitlab-org/gitlab!69730))
- [Updated vendored cluster management project tpl](gitlab-org/gitlab@e57a501ebef36140d1bfd860221ce6df3ed16635) ([merge request](gitlab-org/gitlab!69405))
- [Configure the sidekiq job limits through settings](gitlab-org/gitlab@186465daacfe9c4b4205e2e1b1d168ff076d46af) ([merge request](gitlab-org/gitlab!68982))
- [GraphQL for dependency proxy ttl policies](gitlab-org/gitlab@fc7454cc3dc87f9313b23bdfb62c0b75e138119c) ([merge request](gitlab-org/gitlab!68900))
- [Track CI minutes usage on a monthly basis](gitlab-org/gitlab@c798d81ab3ca22d84e4e6463532ffdd4168ab99e) ([merge request](gitlab-org/gitlab!70183)) **GitLab Enterprise Edition**
- [Added connectivity status to Kubernetes Agents](gitlab-org/gitlab@236e20be245070d640d7821ccebb22ddb4d5ef39) ([merge request](gitlab-org/gitlab!69345)) **GitLab Enterprise Edition**
- [Display icon for hidden issues on group/project issue boards](gitlab-org/gitlab@e4d2dc410b8a69432a243b01f6c75f24593b3dc3) ([merge request](gitlab-org/gitlab!69558))
- [Add milestoneWildcardId to board issues graphQL endpoint](gitlab-org/gitlab@75fd1f06a24b2b1b9a25c9adcfc828d4f462c17b) ([merge request](gitlab-org/gitlab!70105))
- [Support multiple dbs in MigrationHelpers](gitlab-org/gitlab@cd71cf542b5f7f66a2d2bd1c71c0043a5ae7e080) ([merge request](gitlab-org/gitlab!67753))
- [Add unauthenticated API throttle settings to admin area](gitlab-org/gitlab@2b4723b543c4699ced0c41d9254759ca1f76807a) ([merge request](gitlab-org/gitlab!69486))
- [Apply throttling settings for unauthenticated API requests](gitlab-org/gitlab@356b77296604b00623048052d2e7122ddbd1f44a) ([merge request](gitlab-org/gitlab!69388))
- [Add `throttle_unauthenticated_api_*` columns to application settings](gitlab-org/gitlab@004732b07e95d0712423ea67762f3ebb1134e88a) ([merge request](gitlab-org/gitlab!69384))
- [Track resolving a thread through a new issue action](gitlab-org/gitlab@b02e032ac476de9f77d0449390e037bb43c7a08a) ([merge request](gitlab-org/gitlab!69879))
- [Reject pending approval users via API](gitlab-org/gitlab@27e2be86ff3aaa89bf49e339f88fe81288785c08) ([merge request](gitlab-org/gitlab!69420))
- [Add connected agents to cluster agents GraphQL response](gitlab-org/gitlab@05430d7a153990ee7c736c70d74ab99f06af847f) ([merge request](gitlab-org/gitlab!69820)) **GitLab Enterprise Edition**
- [Introduce max saml message size setting](gitlab-org/gitlab@93d46378eccb37ae33875a6f7615a69ff106b98f) ([merge request](gitlab-org/gitlab!69647)) **GitLab Enterprise Edition**
- [Add group contacts query to GraphQL](gitlab-org/gitlab@d7dd36719ac1b99ca6aa97d731f14cf81a9d5288) by @leetickett ([merge request](gitlab-org/gitlab!69510))
- [Merge branch '322839-dp-graphql-image-prefix' into 'master'](gitlab-org/gitlab@1803322077256145581df58aa38ec513dfd41d7e) ([merge request](gitlab-org/gitlab!69114))
- [Enable ci_build_tags_limit by default](gitlab-org/gitlab@bfcb5bc84f40a169485360d01e19590a8653ceb5) ([merge request](gitlab-org/gitlab!69506))
- [Reimplement tree pagination for Rugged](gitlab-org/gitlab@cd3dc3ad6b25ae0d09925ea14f15b5a32f69b2bd) ([merge request](gitlab-org/gitlab!69480))
- [Address the PK Overflow risk for the ci_build_trace_chunks - Step 3](gitlab-org/gitlab@3752ea6ceff6c1e1e4e3815e95c6fc47db5aaa61) ([merge request](gitlab-org/gitlab!69632))
- [Address the PK Overflow risk for the ci_builds_runner_session - Step 3](gitlab-org/gitlab@8001124342e180f40bc0d15c2a0b9ba5583d2bc2) ([merge request](gitlab-org/gitlab!68542))
- [Apply throttling settings to Files API](gitlab-org/gitlab@2773f95d533d14a7903d2c8217abdd26ceaba5f3) ([merge request](gitlab-org/gitlab!68561))
- [Add more details to Protected Branches Audit Events](gitlab-org/gitlab@42a399f7ef30a0cc4d1e69ced5a29c7dcf3dc17d) by @adrien.gooris ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/68869)) **GitLab Enterprise Edition**
- [Allow sorting issues by their title](gitlab-org/gitlab@f667b284592af7054843447833900faddd6c6d34) by @espadav8 ([merge request](gitlab-org/gitlab!67234))
- [Added filter bar to project VSA](gitlab-org/gitlab@89c078668b1e26e4dd611938ebc64e8927186d53) ([merge request](gitlab-org/gitlab!67340))
- [Track CI minutes notifications for new monthly tracking](gitlab-org/gitlab@936681b6ebf237e2c447f3cf6ea219e6bac9ed60) ([merge request](gitlab-org/gitlab!69059))
- [Support refname in external repo CI configuration](gitlab-org/gitlab@8909656ce7d3c2263e7bc72d0462af1bcfa9110d) by @jspricke ([merge request](gitlab-org/gitlab!68603))
- [Keyset pagination for Groups API](gitlab-org/gitlab@4c9e7cc5721d8e7adc00c847e2f6e08df2284f45) ([merge request](gitlab-org/gitlab!68346))
- [repository: Always use `ListBlobs()` to enumerate new blobs](gitlab-org/gitlab@fb65481d34cde47ef98a5a1d62ba5a5befa11b93) ([merge request](gitlab-org/gitlab!69449))
- [Add `latest` column into `security_scans` table](gitlab-org/gitlab@794d1c2f328e137f406d1019815caf40bc77d6da) ([merge request](gitlab-org/gitlab!69494))
- [Add not filters for MR Analytics](gitlab-org/gitlab@55f86ef9655046de591734a144436fa769fc0602) ([merge request](gitlab-org/gitlab!69359)) **GitLab Enterprise Edition**
- [Validate user website_url](gitlab-org/gitlab@f651f986e457e4c4a0e96138c0d4b9e96ac91801) ([merge request](gitlab-org/gitlab!69624))
- [Adding terraform fmt to the Terraform template](gitlab-org/gitlab@fb2c1d72491c7f989f6d7a2e3b4d570017821edc) by @willianpaixao ([merge request](gitlab-org/gitlab!69470))
- [Address the PK Overflow risk for the ci_sources_pipelines - Step 3](gitlab-org/gitlab@07f34bb1a5319fb9ba513b1d562e7edd7b178f46) ([merge request](gitlab-org/gitlab!69281))
- [Added /unapprove quick-action](gitlab-org/gitlab@f376e95272507f7aeae099aa8fff1df460c0b588) by @lzampier ([merge request](gitlab-org/gitlab!69225)) **GitLab Enterprise Edition**
- [Split diff commit migrations into smaller chunks](gitlab-org/gitlab@bcf1f22361561dac505304fb617d7e444622c8b5) ([merge request](gitlab-org/gitlab!69392))
- [Add `hidden` field to GraphQL `Issue` type](gitlab-org/gitlab@2c7c87c03477aa01b323ee6162c8b7e182215939) ([merge request](gitlab-org/gitlab!69323))
- [Add ProjectNamespace model and DB relationships](gitlab-org/gitlab@75efa8f4348770d0978c399b0439f57b5d6ecc4a) ([merge request](gitlab-org/gitlab!68825))
- [Add dependency proxy image prefix to group type](gitlab-org/gitlab@7005dd077fb148fcbbbb9f18b3694719179bf070) ([merge request](gitlab-org/gitlab!69114))
- [Backfill projects with CI coverage usage](gitlab-org/gitlab@1b1bf867fe2dbb4d933243f53135a264488e1ac4) ([merge request](gitlab-org/gitlab!69115))
- [Add Mailgun endpoint for receiving permanent failures](gitlab-org/gitlab@9c8a128ea056ee9170c7a32ad28a65900ec873aa) ([merge request](gitlab-org/gitlab!68307))
- [Clean up group_level_protected_environments feature flag](gitlab-org/gitlab@38ed6acf94b2609365c52522070c0c5218d67bc4) ([merge request](gitlab-org/gitlab!69272))
- [Add paginated tree graphQL query](gitlab-org/gitlab@edf6a2599a55d62a14ca5489b7db2c7f8b0051e7) ([merge request](gitlab-org/gitlab!69274))
- [Auto-DevOps: respect deploy freezes](gitlab-org/gitlab@ebb55727b36a3d21752838d0effd74a4ae435062) ([merge request](gitlab-org/gitlab!69205))
- [Add new VSA partitioned tables](gitlab-org/gitlab@0a29fd921e219835fb8529f42fad9a735a92f3b5) ([merge request](gitlab-org/gitlab!68950))
- [Readding state column for members table](gitlab-org/gitlab@3c8ef22d59796a48a4fb447b4d2c2b7bb128bbb9) ([merge request](gitlab-org/gitlab!69220))
- [Address the PK Overflow risk for the ci_job_artifacts - Step 3](gitlab-org/gitlab@773a7ec9993ba960fe4da208f5d76037dc911459) ([merge request](gitlab-org/gitlab!68770))
- [Add organizations to GraphQL](gitlab-org/gitlab@b0e0e336ddc722ff093763e307ba6e619aaac4d3) by @leetickett ([merge request](gitlab-org/gitlab!69318))
- [Mark the PostReceive worker as idempotent](gitlab-org/gitlab@cb87e136cbb7edae9a25e6eae903287ec8f99d5a) ([merge request](gitlab-org/gitlab!69305))
- [Added connectivity status to Kubernetes Agents](gitlab-org/gitlab@9a15f565fcd54585209eb70348acad48c11cd38d) ([merge request](gitlab-org/gitlab!69345)) **GitLab Enterprise Edition**
- [Use Gitaly API to sort tags](gitlab-org/gitlab@f94c86655c131ebd58e00137ddedc6b592321eda) ([merge request](gitlab-org/gitlab!69101))
- [Promote continuous onboarding A variant](gitlab-org/gitlab@6726be7f1bce5510e107dd8eff4964ff5484607b) ([merge request](gitlab-org/gitlab!68965))
- [Allow support for description lists in content editor](gitlab-org/gitlab@32b0de5f5306cb597b8b22ef0c3a527bef792e9c) ([merge request](gitlab-org/gitlab!69149))
- [Support AWS SSE-KMS in backups](gitlab-org/gitlab@3963b2511f01c84ab60b272ea10d4c47dba2ac02) ([merge request](gitlab-org/gitlab!64765))
- [Add new methods to support the PK migration - STEP 3](gitlab-org/gitlab@bccdbd7d6fab25bf03168c36f7901138e7624b53) ([merge request](gitlab-org/gitlab!68849))
- [Add ability to Delete Freeze Periods](gitlab-org/gitlab@a28b5a4a1f4efa190cdec5e5d7cf94eed247cf18) by @jayaddison ([merge request](gitlab-org/gitlab!66331))
- [Add DevOps Adoption Overview table](gitlab-org/gitlab@f3f97c345e9415ff777df671b689778f23753efb) ([merge request](gitlab-org/gitlab!68447)) **GitLab Enterprise Edition**
- [Render video in content editor](gitlab-org/gitlab@7fedc5e0e49733087a9db7943e4f6fdf5d0e40ec) by @leetickett ([merge request](gitlab-org/gitlab!69169))
- [Upgrade GitLab Pages to 1.43.0](gitlab-org/gitlab@1d8174ef6967f8b938e5e5d29baef591acb39559) ([merge request](gitlab-org/gitlab!69213))
- [Requirement migration: Sync title and description changes](gitlab-org/gitlab@0e35aed745501b6927737bf6f91813a972fb4011) ([merge request](gitlab-org/gitlab!64929)) **GitLab Enterprise Edition**
- [Render audio in content editor](gitlab-org/gitlab@933fe8e190a740cac6832f4fce589f9a78edc879) by @leetickett ([merge request](gitlab-org/gitlab!68598))
- [Adds k8s 1.20 to EKS list](gitlab-org/gitlab@051061a011b4fae351bdbe7924a524e374c34a58) ([merge request](gitlab-org/gitlab!69094))
- [API: Add endpoint to reset runner registration token](gitlab-org/gitlab@0fff8430cce18307af5af6758fb17079b2ade55c) by @KyleFromKitware ([merge request](gitlab-org/gitlab!68590))
- [Add personalization questions to group creation](gitlab-org/gitlab@9a0cfbd18ff9d82109495395197ed568300b2fd5) ([merge request](gitlab-org/gitlab!67249))
- [Fix unban specs](gitlab-org/gitlab@253ee313ecca7ca6ddc454c879d2400ddfe4fc88) ([merge request](gitlab-org/gitlab!68332))
- [Log backtrace when SAVEPOINT is discovered](gitlab-org/gitlab@19e38656b64d062f3ce51840718ab25da0038ff7) ([merge request](gitlab-org/gitlab!69023))
- [Improve serialization of content editor extensions](gitlab-org/gitlab@7105591794230453ac15434e9d11115c69d01305) ([merge request](gitlab-org/gitlab!68877))
- [Removes load_balancing_for_expire_job_cache_worker FF](gitlab-org/gitlab@2d89ab5f53635b31fa151a23dcf234c67897bff6) ([merge request](gitlab-org/gitlab!69004))
- [Enable the FF ci_include_rules by default](gitlab-org/gitlab@396a922cd0dcdd1ea54d951da3f19cf76e3d03c3) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/67409))
- [Allow arbitrary html tags in content editor](gitlab-org/gitlab@ce0f7f66c9c7781b849fc707f5b9853f91d5d843) ([merge request](gitlab-org/gitlab!68224))
- [Expose web_url to Compare API endpoint](gitlab-org/gitlab@aea0869776dd9ca4770721d164fc79ebed2e7e9e) ([merge request](gitlab-org/gitlab!68676))
- [Add configure integrations button to project view](gitlab-org/gitlab@c14589e70baacf5d406fb2e604c2bd5c0525225d) ([merge request](gitlab-org/gitlab!67536))
- [Steal pending merge request diff commit user jobs](gitlab-org/gitlab@b98a2d0c6164e81cae5b6f739f0fc7bf9aa930f2) ([merge request](gitlab-org/gitlab!68769))
- [Database work to support inherited templates on service desk](gitlab-org/gitlab@200fe009bd68086edc0127346f28224159f471cb) ([merge request](gitlab-org/gitlab!67546))
- [Add param to allow scoped caching of Repo#merge_to_ref](gitlab-org/gitlab@84a4415eb01bbbb175235ffdf4ad9a499c28ce89) ([merge request](gitlab-org/gitlab!68790))
- [Allow to create epic from ancestor board](gitlab-org/gitlab@a077194fdd8b9b66a90284cfa27a6d9728dc86f4) ([merge request](gitlab-org/gitlab!68039)) **GitLab Enterprise Edition**
- [BG migration for populating stage event hash](gitlab-org/gitlab@c91abc0d5b37e6a414fd69398a0db36482b00922) ([merge request](gitlab-org/gitlab!67939))
- [Add VulnerabilityCreate GraphQL mutation](gitlab-org/gitlab@51205f5519b3f0ce5319678a61292dbeee946cd4) ([merge request](gitlab-org/gitlab!68158)) **GitLab Enterprise Edition**
- [Add direct group dependency proxy env variable](gitlab-org/gitlab@62e16f4d71849b5b4038e945471d73f324ba483f) ([merge request](gitlab-org/gitlab!68661))
- [Persist groups configured to use an Agent](gitlab-org/gitlab@09c33dc7073cd8e382b664166a22b2cbf4b1f968) ([merge request](gitlab-org/gitlab!68023))
- [Test case return 404 instead of 500 error](gitlab-org/gitlab@cfc199ab2bb888e6814424aa1ac334339be32004) ([merge request](gitlab-org/gitlab!68548)) **GitLab Enterprise Edition**
- [Add approvalRules to MergeRequest GraphQL API](gitlab-org/gitlab@8339099bc6d88d745cf24d6eb43dd33e051992c1) ([merge request](gitlab-org/gitlab!68502)) **GitLab Enterprise Edition**
- [Add Files API throttling to application settings](gitlab-org/gitlab@e989361e3f24e19af6e3a61794ac915f3492e8aa) ([merge request](gitlab-org/gitlab!68559))
- [Add support for fetching merge requests via RSS / Atom](gitlab-org/gitlab@5afc10add8dea007a32b5e2c986b0d37f2e5040b) by @kingjan1999 ([merge request](gitlab-org/gitlab!66336))
- [Enable new vulnerability report project filter by default](gitlab-org/gitlab@4dd50c39dda68f2ea5de29d721002503ca6b7535) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/68456))
- [Allow title attribute in elements in content editor](gitlab-org/gitlab@29e0ecb1f9df1b420b7ee9a125b14dc990c9abcc) ([merge request](gitlab-org/gitlab!68086))
- [Allow editing the structure of tables](gitlab-org/gitlab@06cd45afb825847037b9cd3f36db98a9073504e4) ([merge request](gitlab-org/gitlab!68473))
- [Adds a button to retry a failed migration](gitlab-org/gitlab@0037970cf71f97ec6630ebfe8541399d0931840a) ([merge request](gitlab-org/gitlab!67504))
- [Add system note for issue type changes](gitlab-org/gitlab@b8881bd71b52a484ba2c42e8e7db27a1305adeee) ([merge request](gitlab-org/gitlab!68239))
- [Add contacts table and model](gitlab-org/gitlab@13f5241af4c923b39021217700ffd741df049c39) by @leetickett ([merge request](gitlab-org/gitlab!67985))
- [Add oncall_users to oncall schedule Graphql type](gitlab-org/gitlab@077b9a1d6a2ff9938e47f049badb3a2ef667ecf5) ([merge request](gitlab-org/gitlab!68237)) **GitLab Enterprise Edition**
- [Add gauge metric on ci queue size](gitlab-org/gitlab@d86702b9dcc2a84c5b9c771dfc9f8412d3cf3d64) ([merge request](gitlab-org/gitlab!67420))

### Fixed (120 changes)

- [Fix AddUpvotesToMergeRequests migration](gitlab-org/gitlab@7b1870038d4cb494156908acf58fe4159f69357c) ([merge request](gitlab-org/gitlab!70594)) **GitLab Enterprise Edition**
- [Add yAxis formatter](gitlab-org/gitlab@a3f4b8e6645e43f1f7ae1cbf0920f4274605ae6d) ([merge request](gitlab-org/gitlab!70373))
- [Fix composer package version regex](gitlab-org/gitlab@5bc407b1fada44f5b30f39930906edc6d784193c) by @leopold.jacquot ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/70251))
- [Use configurable page size for jobs in stages](gitlab-org/gitlab@c3eb03198bc08b2428a5fa92168d5fea8a6d9f2b) ([merge request](gitlab-org/gitlab!69853))
- [Fix for approval check popover bug](gitlab-org/gitlab@03d3f3b7c651ccacb6b1246c3124209d2da6e66b) ([merge request](gitlab-org/gitlab!65579)) **GitLab Enterprise Edition**
- [Shorten session TTL of anonymous blob access](gitlab-org/gitlab@7196ca925f9b8ce5f569a72736649998cecb0f8c) ([merge request](gitlab-org/gitlab!70444))
- [Makes kubectl annotate work in Helm 2to3 migration Jobs](gitlab-org/gitlab@645cf7a48bd0b7e717fa4fb30323911d59b62baf) by @erik.forsberg ([merge request](gitlab-org/gitlab!70389))
- [Use the correct project path in generated `KUBECONFIG` file](gitlab-org/gitlab@57d828bf8f7aa3071900aa0501536ccc7a492a39) ([merge request](gitlab-org/gitlab!70452)) **GitLab Enterprise Edition**
- [Removes cleanup job from Terraform.latest](gitlab-org/gitlab@239253ecce15f7ca968c4eee70c679174094d264) ([merge request](gitlab-org/gitlab!70383))
- [Geo Nodes - Fix flex alignment](gitlab-org/gitlab@bdaf430386a34352ed9c75d4b0d64bf551ff20b4) ([merge request](gitlab-org/gitlab!70319)) **GitLab Enterprise Edition**
- [Do not cache user email from github if email is nil/private](gitlab-org/gitlab@c89d61bee17af1da2bcd10de9531e72db3287c72) ([merge request](gitlab-org/gitlab!70293))
- [Change non-breaking space to space in email](gitlab-org/gitlab@5d7259c8438038fa42d4cc131087c48465975611) by @scootergrisen ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/70202))
- [Add metric to service ping if has defintion](gitlab-org/gitlab@c75e2c57c2785eb046e991430ecdb0838e7794e5) ([merge request](gitlab-org/gitlab!70061))
- [Open reply box on resolved design discussions](gitlab-org/gitlab@c931fa4fcda640d757749bd8dbd3b0275acc04df) ([merge request](gitlab-org/gitlab!70359))
- [Add GraphQL type for agent metadata](gitlab-org/gitlab@e06c6cf6a9f3c3abc1023cc1b97cce4257810120) ([merge request](gitlab-org/gitlab!70343)) **GitLab Enterprise Edition**
- [Include author in commit message from core team community members](gitlab-org/gitlab@092b24472af34fdbdc36f6a799700b77043bc665) by @leetickett ([merge request](gitlab-org/gitlab!69076))
- [Refactor the helm presenter](gitlab-org/gitlab@78b3bba1b1f53774f8c6d5bc619aef14308920bc) ([merge request](gitlab-org/gitlab!69223))
- [Prevent vuln table header from cutting off dropdown](gitlab-org/gitlab@8d7b32f5ed8fdfe9f17327218359edf8b97ffc54) ([merge request](gitlab-org/gitlab!69954)) **GitLab Enterprise Edition**
- [Only render "No artifacts found" when not loading](gitlab-org/gitlab@c6118524ecfa768e3d630333b41d470949dd6982) ([merge request](gitlab-org/gitlab!68843))
- [Upgrade fog-aws to v3.12.0](gitlab-org/gitlab@9b8ffd2b223c70c3c7f20336ea36b20fec05739b) ([merge request](gitlab-org/gitlab!68969))
- [Fix Geo Pages replication for selective sync](gitlab-org/gitlab@fd5fabbc4b05c29070446229d9bb7bc229cd957a) ([merge request](gitlab-org/gitlab!70190)) **GitLab Enterprise Edition**
- [Dynamically read pool sizes for LB configurations](gitlab-org/gitlab@4082c09a3ad3bae0cc14fdb16cfd233ca2e445cf) ([merge request](gitlab-org/gitlab!70060))
- [tags: Always enable fix for verification of long tag messages](gitlab-org/gitlab@cc9556429a2b3b84c847db0230733f7e84edb2be) ([merge request](gitlab-org/gitlab!70051))
- [Fix editing network policies without policy management project](gitlab-org/gitlab@c7ebc9e085b02866209b875a093898714927109a) ([merge request](gitlab-org/gitlab!70171)) **GitLab Enterprise Edition**
- [Fix not being able to delete unparseable policies](gitlab-org/gitlab@95a0902078fee35139af77d7c9d74a89510260d4) ([merge request](gitlab-org/gitlab!70114)) **GitLab Enterprise Edition**
- [Check if root ancestor has an active trial](gitlab-org/gitlab@53262f665b20643c56837c7be584995606529a07) ([merge request](gitlab-org/gitlab!70109))
- [Fix text ellipsis on linked issues/MRs](gitlab-org/gitlab@6aa0ef81bde3b50b4e3bf3432034ce1c7a1a8af4) ([merge request](gitlab-org/gitlab!70049))
- [Fix overlap of error message and sidebar on boards](gitlab-org/gitlab@da57dc643fe2a8bf7961a3887125c6af0b3b083d) ([merge request](gitlab-org/gitlab!70030))
- [Use global ids when updating board scope](gitlab-org/gitlab@d108201135744f9d5cda69a99b6e47710bca07a6) ([merge request](gitlab-org/gitlab!69715)) **GitLab Enterprise Edition**
- [Fix displaying label text in labels dropdown in dark mode](gitlab-org/gitlab@c6009408c64edc50b889603c24bc408b0f73289d) ([merge request](gitlab-org/gitlab!70037))
- [Don't release primary connections in the DB LB](gitlab-org/gitlab@95d3ff341cafd8fd5098fefbc7847c93603c9adc) ([merge request](gitlab-org/gitlab!69988))
- [Add epic board scope to newly created epic](gitlab-org/gitlab@9a6a760c7c042a1d0a091ca8cf9213a954154234) ([merge request](gitlab-org/gitlab!70028)) **GitLab Enterprise Edition**
- [Invalidate ES namespace cache when transferring groups](gitlab-org/gitlab@64b6bc923b511842a6104a30b1556e26e80e82b3) ([merge request](gitlab-org/gitlab!70005)) **GitLab Enterprise Edition**
- [Use SafeRequestStore in the DB LB](gitlab-org/gitlab@2584f6ea38e2c08c5a71af70a9871cf6e480274a) ([merge request](gitlab-org/gitlab!70003))
- [Fix display of relative/absolute time in PAT and deploy token tables](gitlab-org/gitlab@c504b0bb363e828a4a79884fbdc622e7962e4fe7) ([merge request](gitlab-org/gitlab!66262))
- [Symbolize load balancer configuration keys](gitlab-org/gitlab@0952ac82795ce9c3ca7825e6dc71313be7e5a494) ([merge request](gitlab-org/gitlab!69995))
- [Fix GitHub Importer outdated diff notes not showing](gitlab-org/gitlab@bc2f24820aed2370994e94abcd731cc88768025b) ([merge request](gitlab-org/gitlab!69977))
- [Fix Elastic::MigrationWorker current_migration](gitlab-org/gitlab@f682052a0d2a76814d0b90c7e66e4a483dfc487e) ([merge request](gitlab-org/gitlab!69958)) **GitLab Enterprise Edition**
- [Fix comments cutting off the left side of wide characters](gitlab-org/gitlab@f7f0b0dc927c080fa9c00b5d054ff996482f0a73) ([merge request](gitlab-org/gitlab!69952))
- [Make group and project fields fullPath argument case-insensitive](gitlab-org/gitlab@37d2f7218518448c9ac4cea384cf1235f41f4e3e) ([merge request](gitlab-org/gitlab!69924))
- [Prevent opening sidebar when clicking on board card title](gitlab-org/gitlab@3f93050618e09642988331c174b9c672ccd0cb65) ([merge request](gitlab-org/gitlab!69720))
- [Do not cache .terraform.lock.hcl](gitlab-org/gitlab@5b41e03bb0610b28c32665b8670cca5fb839cade) ([merge request](gitlab-org/gitlab!68269))
- [Prevent creation of too long file name](gitlab-org/gitlab@7136f5941f261917f51864612ac7b567d7bf94ed) ([merge request](gitlab-org/gitlab!69500))
- [Ensure Milestones Are Displayed With Few Results](gitlab-org/gitlab@146c481dd419a5dd007f140e5747a6541ef63726) ([merge request](gitlab-org/gitlab!69507))
- [Replace vsa stage slug with id](gitlab-org/gitlab@97d5c52a76708f05c0f1481384425345d820663f) ([merge request](gitlab-org/gitlab!69640)) **GitLab Enterprise Edition**
- [Load config variables from external project](gitlab-org/gitlab@6b5b4096127a4ee32033aa4b398f2f5f9fc73c81) ([merge request](gitlab-org/gitlab!69646))
- [Fix creating issue in milestone list](gitlab-org/gitlab@e7b3a1184cfe110ad6c70eb13df989b6ef8385f4) ([merge request](gitlab-org/gitlab!69529)) **GitLab Enterprise Edition**
- [Fix header order in CI/CD pipeline's job tab](gitlab-org/gitlab@f2988ee52d59ffe4ba9bf57e758843360446ddac) by @JonstonChan ([merge request](gitlab-org/gitlab!69704))
- [Make RepositoryUpdateMirrorWorker idempotent](gitlab-org/gitlab@0c05d8b8159b4944f356a8c544b9a5659e16a7b0) ([merge request](gitlab-org/gitlab!69725))
- [Fix selected for User#commit_email input](gitlab-org/gitlab@bdca30a81d444a812d0521087d93f83c11573dfe) ([merge request](gitlab-org/gitlab!69234))
- [Allow additional minute transfer for Users](gitlab-org/gitlab@d480822075a6f5abb5f68d998fb1a0525b47551b) ([merge request](gitlab-org/gitlab!69556)) **GitLab Enterprise Edition**
- [Fix labels applied to a wrong issue](gitlab-org/gitlab@9534cf6211f0e2323c16559fa9f5c303f648bb47) ([merge request](gitlab-org/gitlab!69609))
- [Max width for sidebar dropdown widgets](gitlab-org/gitlab@eb9fab5271ab43ad6abfd2c73e80ee02efb2952d) ([merge request](gitlab-org/gitlab!68431))
- [Fix yaml viewer padding not changing color](gitlab-org/gitlab@925866290aebe058d56f6c76372f46a7c1984db9) ([merge request](gitlab-org/gitlab!69563)) **GitLab Enterprise Edition**
- [Remove paste event listener on destroy](gitlab-org/gitlab@966a4c283c5a1c7dc8346900b1dd1d53d99c7a72) ([merge request](gitlab-org/gitlab!69453))
- [Fix formatting bubble menu in Content Editor](gitlab-org/gitlab@a9c73f1841e174b2074891332004f0bb4f06556e) ([merge request](gitlab-org/gitlab!69324))
- [Fix group membership CSV export for invited users](gitlab-org/gitlab@732b8b8c9df18be50a63255d6be6755d9e5aaa1a) ([merge request](gitlab-org/gitlab!69065))
- [Remove table-layout: fixed style from the tree table of files](gitlab-org/gitlab@80a1c6de952caa6a7b86146358f06c3bb0ca106c) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/69445))
- [Remove the existing duplicates of DastSiteTokens](gitlab-org/gitlab@2f345de94bdc7fe3cb3d6365dcfc641bc401a064) ([merge request](!68578))
- [Update Audit Logging for Feature Flags](gitlab-org/gitlab@cc12468fc905ba407d21a6ffc71214d10700ae92) ([merge request](gitlab-org/gitlab!68408))
- [Error on newlines in sidekiq-cluster arguments](gitlab-org/gitlab@91e7b17cd14b89170d1668f82bf8b7be64daac4e) ([merge request](gitlab-org/gitlab!69237))
- [Reduce DA pagerefresh rate](gitlab-org/gitlab@bb4867bd04d847afcd78176cb9623fab8103d1aa) ([merge request](gitlab-org/gitlab!69056)) **GitLab Enterprise Edition**
- [Fix security report schema validation](gitlab-org/gitlab@2b0a3380764ca20ab491507db020462fea23ca72) ([merge request](gitlab-org/gitlab!69292)) **GitLab Enterprise Edition**
- [Fix disappearing badge in commit image thread edit](gitlab-org/gitlab@7dac314f249d49671ea92c8853d43da4e6a31319) ([merge request](gitlab-org/gitlab!69137))
- [Fix - Some users cannot move issues in epic swimlanes](gitlab-org/gitlab@d5536cfab1482edb2c15c8d5bb6f7a8ed6416a50) ([merge request](gitlab-org/gitlab!68922)) **GitLab Enterprise Edition**
- [Logged out users can view public group epic boards](gitlab-org/gitlab@a067f7517613aa47e0bfcaafb5db06fcb1c83b30) ([merge request](gitlab-org/gitlab!69218)) **GitLab Enterprise Edition**
- [Reschedule 'ExtractProjectTopicsIntoSeparateTable' post migration](gitlab-org/gitlab@7f45515dd4f820f6902088d0ef807f6177db2661) by @wwwjon ([merge request](gitlab-org/gitlab!69199))
- [Update relative positions on querying board issues](gitlab-org/gitlab@9729e06b523270f3cd1f1ba66e5d737569923e1a) ([merge request](gitlab-org/gitlab!68715))
- [Patch `grape-entity` to prevent having NameError loop](gitlab-org/gitlab@28fc953b70044d792a06562c7f3b22249287e5eb) ([merge request](gitlab-org/gitlab!69040))
- [Catch Helm invalid versions](gitlab-org/gitlab@443a3d8b9ed320364ee7790fecfefea6a5973521) by @sathieu ([merge request](gitlab-org/gitlab!68976))
- [Fix broken image for runner templates](gitlab-org/gitlab@54b92d1d447ab60000fda7d75da4fdc4d68bfdf6) ([merge request](gitlab-org/gitlab!69080))
- [Disallow editing the environment name](gitlab-org/gitlab@e2468c614ed0f72c2e10d1948ea09fc5a23d1740) ([merge request](gitlab-org/gitlab!68550))
- [Fix visibility reference check](gitlab-org/gitlab@7fb9af870057569036d81556bc94a4e3e494d9a9) ([merge request](gitlab-org/gitlab!68174))
- [Add missing graphQL ids](gitlab-org/gitlab@2ca888d789103d9219fb6320f670e0d9454f40fb) ([merge request](gitlab-org/gitlab!68948))
- [Don't override setup_for_company in subscription flow](gitlab-org/gitlab@578273be68978108e50ebf6f5385d02beb588ca3) ([merge request](gitlab-org/gitlab!68868))
- [Skip highlighting cache for diffs with unsupported characters](gitlab-org/gitlab@d5a1dd7429dae38a747b9a042b3fa7eea942ef1e) ([merge request](gitlab-org/gitlab!69069))
- [Use the last Helm chart when downloading](gitlab-org/gitlab@9dfd15f6876710df96539410f4982311ee811deb) by @sathieu ([merge request](gitlab-org/gitlab!68968))
- [Fix OrphanedInviteTokensCleanup migration](gitlab-org/gitlab@affc79c69873e73ec5b3cf7fcf74857ab4f663ce) ([merge request](gitlab-org/gitlab!68784))
- [Fix downstream counter badge link](gitlab-org/gitlab@9b029853aa86194727cc980113cc46a260e814b1) ([merge request](gitlab-org/gitlab!68962)) **GitLab Enterprise Edition**
- [Only set User#commit_email with user input](gitlab-org/gitlab@e467a3b438ebd5ec99853a5d48b1aae1b0668aaa) ([merge request](gitlab-org/gitlab!68591))
- [Fix Connection#exists? when using the DB LB](gitlab-org/gitlab@abbc8b8f10a70a1ecd92aa7c17161247b599bf8c) ([merge request](gitlab-org/gitlab!68855))
- [Fix contributors detection in changelog generation](gitlab-org/gitlab@35d6b799c0179e4f829f8221dd5598264f0a15b4) ([merge request](gitlab-org/gitlab!68938))
- [Downgrade grpc from 1.38.0 to 1.30.2](gitlab-org/gitlab@f427fdfaae7fe1495f1e68ec5cf0ac1fe1240c27) ([merge request](gitlab-org/gitlab!68865))
- [Let non-members set confidential flag on issue](gitlab-org/gitlab@518fe9a1124bc3606d06d6c23198c9426bd93b17) ([merge request](gitlab-org/gitlab!68459))
- [Fix displaying weight of 0 for issues in epic tree](gitlab-org/gitlab@7a7f95f0876916af15c04a229217b7c6ece91067) ([merge request](gitlab-org/gitlab!68914)) **GitLab Enterprise Edition**
- [Fix epic swimlanes list drag drop reordering](gitlab-org/gitlab@2dd83ce4acfd7c4c44544274f8372a727c18dd82) ([merge request](gitlab-org/gitlab!68908)) **GitLab Enterprise Edition**
- [Show create-jira on pipeline and MR when enabled](gitlab-org/gitlab@e32b110729de421293bd93498e9bc2ec6db66503) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/68821)) **GitLab Enterprise Edition**
- [Fix new project page in dark mode](gitlab-org/gitlab@3356ff712058380d00ea2b50138c4f7c5b00abea) ([merge request](gitlab-org/gitlab!68102))
- [Move service_desk_setting to CE in project import export](gitlab-org/gitlab@11b05504e967a93284dd2c3a3241f0376ddbd077) by @leetickett ([merge request](gitlab-org/gitlab!68896))
- [Add default option to notification_email input](gitlab-org/gitlab@6b07127a00ab998eed3057fc1bfff9a0659c6d3f) ([merge request](gitlab-org/gitlab!68687))
- [Fix overflowing text in OmniAuth login buttons](gitlab-org/gitlab@8524712d083cd83f1f7f381942ef019cc40b1e3a) ([merge request](gitlab-org/gitlab!68884))
- [Use `binary` property on the file object](gitlab-org/gitlab@5691316795bfd3afcf40edaa4185db67e67db625) ([merge request](gitlab-org/gitlab!68705))
- [Handle errors without causes](gitlab-org/gitlab@36dd486c4c6f9f0ea997be24bee4d3cd3343b301) ([merge request](gitlab-org/gitlab!68858))
- [Fix bug validating EE project features](gitlab-org/gitlab@ee3790388b748f45a3cbadc987593dac23a54a2d) ([merge request](gitlab-org/gitlab!68523))
- [Fix Live Markdown Preview in personal and subgroup projects](gitlab-org/gitlab@1a2a9fe95ea2b484ad8c1ce8d8f4b9714696e104) ([merge request](gitlab-org/gitlab!68803))
- [Send rotation email inline when deleting user](gitlab-org/gitlab@2616e2dab6a224422de4f4f533f2d6eb091b8cd5) ([merge request](gitlab-org/gitlab!68811)) **GitLab Enterprise Edition**
- [Use type to detect password fields in integrations instead of name](gitlab-org/gitlab@95917eb2d0bbfd6566e67ebff85e28619b52e2f0) ([merge request](gitlab-org/gitlab!68786))
- [Use dynamic mapping in trigger to sync `integrations.type_new`](gitlab-org/gitlab@21db2a36c42dadec7c3bea82ed85daa66eaf6aa0) ([merge request](gitlab-org/gitlab!68558))
- [Fix Epic bulk updates leaking to other epics](gitlab-org/gitlab@dc53ff7b8fcb4d80e852ecc0e582da30741ebb4c) ([merge request](gitlab-org/gitlab!68730)) **GitLab Enterprise Edition**
- [Drop un-used db/ci_migrate symlink](gitlab-org/gitlab@503e25c35c75eac4cddc634d9bc1ae89ee90851b) ([merge request](gitlab-org/gitlab!68710))
- [Fix getAction is undefined bug in Web IDE markdown files](gitlab-org/gitlab@66a8019f4fb785dd014c67f9ce0c09522ea52fab) ([merge request](gitlab-org/gitlab!68583))
- [Remove substransaction from wiki event creation](gitlab-org/gitlab@18e78d233a9e06300631d0ac1349f2f819284ac2) ([merge request](gitlab-org/gitlab!68627))
- [Fix namespace checks for live quota consumption](gitlab-org/gitlab@4f2e7ab31e8d9c2c93c61b5830d1cda67d759891) ([merge request](gitlab-org/gitlab!68646)) **GitLab Enterprise Edition**
- [Fix project importers pagination issues](gitlab-org/gitlab@0f385b5c55186554a898818c3f953f8fedd2a949) ([merge request](gitlab-org/gitlab!68270))
- [Use `binary` property on the file object](gitlab-org/gitlab@bf5486b585b304908721389e3ef8ab3fdd60874a) ([merge request](gitlab-org/gitlab!68643))
- [Fix links to Jira docs](gitlab-org/gitlab@ed8055c80c68589cf7abb1eefae39c99de6dc801) ([merge request](gitlab-org/gitlab!68644))
- [Enable the FF ci_new_artifact_file_reader by default](gitlab-org/gitlab@2be876558bfdf6c3fc7ce78f647db95c5cfae6ee) ([merge request](gitlab-org/gitlab!68293))
- [Remove redundant callbacks, rely instead on validations](gitlab-org/gitlab@a1077343d8d5dcb9ab0d14640926d2a8de25aa5c) ([merge request](gitlab-org/gitlab!68048))
- [Fix tooltip on issue sidebar](gitlab-org/gitlab@6b454c44d2ff5251ff45129abef59cbe09a07e9e) ([merge request](gitlab-org/gitlab!68614))
- [Reduce the spacing of list items for Content Editor](gitlab-org/gitlab@7730ff6518416013e68aa752c5c6109a8b151555) ([merge request](gitlab-org/gitlab!68612))
- [Respect namespaces with unlimited minutes](gitlab-org/gitlab@7eb5fc0b160f644fdb918e91d87a8c1eac385ddc) ([merge request](gitlab-org/gitlab!68599))
- [Fix some edge cases with Content Editor serializing](gitlab-org/gitlab@9034aab3ca536caafdd8a3506c1002e9786d484e) ([merge request](gitlab-org/gitlab!66187))
- [Geo: Replicate wiki and design repository HEAD ref](gitlab-org/gitlab@7aaa1413c3a772e89423818fce2b2de46b459066) ([merge request](gitlab-org/gitlab!68324)) **GitLab Enterprise Edition**
- [Fix designCollection object after design is uploaded](gitlab-org/gitlab@1c367ecf10fadbc75560428c8b2b0fac07d099a0) ([merge request](gitlab-org/gitlab!68521))
- [Wrap pipeline artifact dropdown item names](gitlab-org/gitlab@ed2bbe1f86b4b494dc732652a480e0494e12a57c) ([merge request](gitlab-org/gitlab!68545))
- [Fix SSO SAML redirection not including query string](gitlab-org/gitlab@4ede4460ddd14e93d05d2ed7c9c01921c39d3086) ([merge request](gitlab-org/gitlab!68498))
- [Add fix for 'old' file type](gitlab-org/gitlab@7b43391dfd9804b747ed4bf1be6baf82c4b51ec1) ([merge request](gitlab-org/gitlab!67735))
- [Fix invite url on invited emails](gitlab-org/gitlab@0399c50ccc99de7bfe1de18ac29e3a11f93cebb2) ([merge request](gitlab-org/gitlab!68388))
- [Track build minutes for disabled shared runners](gitlab-org/gitlab@271267ed46008248953cd70a8a40b9c26a6ad9b3) ([merge request](gitlab-org/gitlab!67024)) **GitLab Enterprise Edition**
- [Validate the uniqueness of pipeline variables](gitlab-org/gitlab@a143ad44cd7bd4113f22709818288eadeecb1b2f) ([merge request](gitlab-org/gitlab!66556))

### Changed (109 changes)

- [Reset notification level when CI minutes limit change](gitlab-org/gitlab@771646f49387e44ff91ab4eca88cfc7bdb231441) ([merge request](gitlab-org/gitlab!69063)) **GitLab Enterprise Edition**
- [Associate successful DAST validations with sites](gitlab-org/gitlab@626803901ffda5266104fbb7a786fb0807fdf45e) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/70140)) **GitLab Enterprise Edition**
- [Use new code quality version 0.85.24-gitlab.1](gitlab-org/gitlab@9782fd2c5452b720e92131e3ef16f99fd2bc09d2) ([merge request](gitlab-org/gitlab!70325))
- [Add notice when runner projects are updated](gitlab-org/gitlab@1fd3099ac0ae9e6489d634d2dc6b850f011d1a7f) ([merge request](gitlab-org/gitlab!70151))
- [Change DAST url download text to button](gitlab-org/gitlab@a5494666f381dfee8c2d95ebd3d7b965a7f0c555) ([merge request](gitlab-org/gitlab!70280)) **GitLab Enterprise Edition**
- [Update expired message for namespace](gitlab-org/gitlab@831c4e21b04353a206e3d4e6c14fbecfdca315c2) ([merge request](gitlab-org/gitlab!69454)) **GitLab Enterprise Edition**
- [Measure image scaler duration for cached images](gitlab-org/gitlab@e6333fb2162eaf7172c469ff320e9f4c25c3df7b) ([merge request](gitlab-org/gitlab!70483))
- [Use allowlist of allowed attributes for imported models](gitlab-org/gitlab@f43fafe59d777601b725cfdd326ae47a5ee20e8b) ([merge request](gitlab-org/gitlab!70168))
- [Migrate admin projects tabs styles](gitlab-org/gitlab@b7fcc0bd36872f04b7c2dda2cfe671468bc0aff5) ([merge request](gitlab-org/gitlab!69298))
- [Rebalance issues relative position without transaction](gitlab-org/gitlab@8834fda84d2a88c10718a5e59bfa62a06d6a2c50) ([merge request](gitlab-org/gitlab!68746))
- [Show project suffix input as disabled](gitlab-org/gitlab@9cd9ca44998f09d4002ffa7a979daf21d15159a6) ([merge request](gitlab-org/gitlab!69857))
- [Update board list settings drawer style](gitlab-org/gitlab@1937928383c9fe23d6e77f6735efdcbaea281d91) ([merge request](gitlab-org/gitlab!69946))
- [Set different session cookie for Geo secondaries](gitlab-org/gitlab@4653ff48801884650f743cc632df01e5a7788784) ([merge request](gitlab-org/gitlab!69759)) **GitLab Enterprise Edition**
- [Geo: Alternate redownload and normal design sync attempts](gitlab-org/gitlab@f9bd2d7a4a4cd9aedac5931c395c9e728e549c01) ([merge request](gitlab-org/gitlab!70329)) **GitLab Enterprise Edition**
- [Geo: Alternate redownload and normal SSF sync attempts](gitlab-org/gitlab@bc6c2a5c8edfc3eb115031097da46a415e2a1737) ([merge request](gitlab-org/gitlab!70329)) **GitLab Enterprise Edition**
- [Geo: Alternate redownload and normal project syncs](gitlab-org/gitlab@37faf15512ff4bfa7c3a28c888f1a8565659c88e) ([merge request](gitlab-org/gitlab!70329)) **GitLab Enterprise Edition**
- [Geo: Reduce frequency of redownload attempts](gitlab-org/gitlab@f63ab921fc36bfa5951f2cf39af0306d071265a4) ([merge request](gitlab-org/gitlab!70329)) **GitLab Enterprise Edition**
- [Update Devise sign_in path for Geo secondaries](gitlab-org/gitlab@ee925603caccc5dabda7e93f88db7b52f05a80b4) ([merge request](gitlab-org/gitlab!69748)) **GitLab Enterprise Edition**
- [Fix policy editor performance](gitlab-org/gitlab@d44df987b63ac1fc1f8909211f3ad1455ed304d0) ([merge request](gitlab-org/gitlab!70024)) **GitLab Enterprise Edition**
- [Fix DORA deployment frequency in VSA](gitlab-org/gitlab@5dbc5751a258552ff4438cf21dc55c1385b77fd4) ([merge request](gitlab-org/gitlab!69654))
- [Clean up settings_block.vue](gitlab-org/gitlab@31e30d257cee503b9c52a1e7828261dd34ff253d) ([merge request](gitlab-org/gitlab!68921))
- [Don't allow anonymous users to search with text](gitlab-org/gitlab@5b7fd6638db0f3d655c36cfceed4b2978c0e7985) ([merge request](gitlab-org/gitlab!70223))
- [Add migrations to swap ci_builds.id column](gitlab-org/gitlab@8931ded2078012a9d07b250d95c536eb1eead031) ([merge request](gitlab-org/gitlab!70245))
- [Fix policy preview for non-parseable policies](gitlab-org/gitlab@c41ba9bdfc89279c27d421f17f4939f999caa8ac) ([merge request](gitlab-org/gitlab!70104)) **GitLab Enterprise Edition**
- [Add CI/CD variables for Auto Build and Auto Deploy image versions](gitlab-org/gitlab@89d5502fc9da51bf037e5dbe4a9cfc82fa2853cc) ([merge request](gitlab-org/gitlab!70088))
- [Update parser gem to 3.0.2.0](gitlab-org/gitlab@5cb1d06f3799a58b5d8947f0815fd04d5687ad83) ([merge request](gitlab-org/gitlab!70207))
- [Disable Sendfile interface for serving Sidekiq Web assets](gitlab-org/gitlab@ba8bd315473b9e784821fc2a9a4198dceabea18c) ([merge request](gitlab-org/gitlab!70113))
- [Enable updated delete branch modal styles](gitlab-org/gitlab@6c4d4508720dab4a98466d0cfccf075646519d36) ([merge request](gitlab-org/gitlab!70185))
- [Add worker_class argument to Sidekiq queues APIs](gitlab-org/gitlab@63979ec0d90d0725d0124ae4658e2021730691c6) ([merge request](gitlab-org/gitlab!70179))
- [Change Ci::Minutes:AdditionalPack text limit](gitlab-org/gitlab@ce5fcda2623aa08271366c81e84e420427b43bec) ([merge request](gitlab-org/gitlab!70064)) **GitLab Enterprise Edition**
- [Remove package_details_apollo feature flag](gitlab-org/gitlab@6e659c7adb427a57cc4e83b90a8b60aa93d534ff) ([merge request](gitlab-org/gitlab!69649))
- [Add migrations to swap ci_builds.id column](gitlab-org/gitlab@fc124d114ddfca1e833d012172a0ac8fee8bd5b9) ([merge request](gitlab-org/gitlab!65201))
- [Add abuse actions to account lock email text](gitlab-org/gitlab@a0b43cca4497faecddcdc14ead25964c212d2c28) ([merge request](gitlab-org/gitlab!69590))
- [Security MR-widget: Clarify dismissed state](gitlab-org/gitlab@acc26917851abfa9376b253b85e8607007085a60) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/69943)) **GitLab Enterprise Edition**
- [Default on policies feature flag](gitlab-org/gitlab@8c64bd7e4cba8bcdf9c23d44c1e7d3b9bfa30d0b) ([merge request](gitlab-org/gitlab!69804)) **GitLab Enterprise Edition**
- [Update UI text for artifacts expiration setting](gitlab-org/gitlab@71fc0ed8178c5debb12e33322ca55e52eeb975aa) ([merge request](gitlab-org/gitlab!69957))
- [Use GlAlert instead of a custom alert class](gitlab-org/gitlab@ccb0bd218c2f12a1602eb678873df122e4ee2946) ([merge request](gitlab-org/gitlab!69854)) **GitLab Enterprise Edition**
- [Generate iids with implicit locking by default](gitlab-org/gitlab@c2900fb1469886997e92d98d035567c0061acc1d) ([merge request](gitlab-org/gitlab!69769))
- [Update profile conflict message](gitlab-org/gitlab@f7726c3edb59b99c23c46d65066565b9a0152034) ([merge request](gitlab-org/gitlab!69900)) **GitLab Enterprise Edition**
- [Add a link to site profiles management](gitlab-org/gitlab@8dc84610c38181117e94591440556bd59d30c514) ([merge request](gitlab-org/gitlab!69900)) **GitLab Enterprise Edition**
- [Use similarity sort in search project dropdown](gitlab-org/gitlab@2113d9619cfed22aa0fff988bf3c08a1c7f46623) ([merge request](gitlab-org/gitlab!69899))
- [Diff stats dropdown styling update due to migration to GlDropdown](gitlab-org/gitlab@228b70ae4b246daad75945074d33db5ca58b63a2) ([merge request](gitlab-org/gitlab!68385))
- [Update CODEOWNERS - Marcia - Configure](gitlab-org/gitlab@ddc646f98cc28289d14d3f999221367a5a32e4d6) ([merge request](gitlab-org/gitlab!69545))
- [Review group general settings](gitlab-org/gitlab@7a61f6acdbd81f3839e860957f56ad4165599261) ([merge request](gitlab-org/gitlab!69858))
- [Update UI text and link for variable warning](gitlab-org/gitlab@047c2196625c9df98e15dba31223dc7766545e2b) ([merge request](gitlab-org/gitlab!69830))
- [Retry archive if left in incomplete state](gitlab-org/gitlab@8deb1c7094c0bb3bae966e7c451265de68debf95) ([merge request](gitlab-org/gitlab!68906))
- [Remove File-By-File preference cookie](gitlab-org/gitlab@35d850db0fcfaa1e8d00b575f0bd45af79ff3590) ([merge request](gitlab-org/gitlab!69788))
- [Add migration to swap ci_builds.stage_id column](gitlab-org/gitlab@4f2f2fc2e0f0e9b8d7c933227a7341b9c0b43de5) ([merge request](gitlab-org/gitlab!66688))
- [Update Graphql dastProfileUpdate mutation to include Schedule](gitlab-org/gitlab@34d76ecb851039bbb674fe3430fab6cbe23889e5) ([merge request](gitlab-org/gitlab!66445))
- [Support restoring repository backups in parallel](gitlab-org/gitlab@b00d37ee54f7366535cf9b03dee6834e0310d0c1) ([merge request](gitlab-org/gitlab!69330))
- [Roll back support for caching encoding detection](gitlab-org/gitlab@e20c483a8d62f10abed64167c7a75aa0f10c5cd3) ([merge request](gitlab-org/gitlab!69581))
- [Allow to open table editing dropdown from headers](gitlab-org/gitlab@3e4a349ad4aa6ec1fe63a8aaebcd375acefe85c8) ([merge request](gitlab-org/gitlab!69499))
- [Rename `throttle_unauthenticated_*` attributes in application settings](gitlab-org/gitlab@3edf9e107b1c70ed08ecfab0170e77f231930646) ([merge request](gitlab-org/gitlab!69543))
- [Prepare the DB LB for always being enabled](gitlab-org/gitlab@e5c5dff040458cd24f66d35824c4fef170325641) ([merge request](gitlab-org/gitlab!68857))
- [Move group's "allow request access" to new section](gitlab-org/gitlab@f205ed4189bc93f7b689e25d0a1c3861a3828b2a) ([merge request](gitlab-org/gitlab!69217))
- [Fix integer columns on new VSA table](gitlab-org/gitlab@d80caad0c2f27fd2c082c5a1085fc0efd156869f) ([merge request](gitlab-org/gitlab!69531))
- [Update GitLab User Doc for EKS supported version](gitlab-org/gitlab@98feb6b48331dfe582e4f4cd47fcfd63ef632b24) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/69387))
- [Resize Jupyter images to fit within the parent box](gitlab-org/gitlab@12032ed70e0aa7c15b12f33403b3716b6a86a100) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/68654))
- [Renders images on the repository of .ipynb files](gitlab-org/gitlab@b40466ca2c99d2ad37cdf9b9dbccf4078df94d60) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/69075))
- [Update help text for API Fuzzing Configuration](gitlab-org/gitlab@175b4099da3a7416c51f8f1e93f889f39c91d47b) ([merge request](gitlab-org/gitlab!69429)) **GitLab Enterprise Edition**
- [Eanble sort_by_project_users_by_project_authorizations_user_id FF](gitlab-org/gitlab@d453b9edd7a811daddfe856cead0de694cb79ecd) ([merge request](gitlab-org/gitlab!69431))
- [Move CI job token details to new page in CI docs](gitlab-org/gitlab@c03bd900e34da4e938783d8c5a437d5095c05316) ([merge request](gitlab-org/gitlab!69422))
- [Improve UI text for maintenance mode](gitlab-org/gitlab@2909006ef1483a48fd50efb2d8948c48483be3cc) ([merge request](gitlab-org/gitlab!69264))
- [Update security policy editor rule button styling](gitlab-org/gitlab@3a0f198a595fecd44f7d8611884b28862b1732bc) ([merge request](gitlab-org/gitlab!69412)) **GitLab Enterprise Edition**
- [Show up to 200 jobs per CI stage](gitlab-org/gitlab@866adb8a09414fd5cc8461605352257c947ffd97) ([merge request](gitlab-org/gitlab!69314))
- [Update `project/clusters/` CODEOWNERS](gitlab-org/gitlab@fb44b0b001b3109bbbf7aaa097ffe8e955a531d7) ([merge request](gitlab-org/gitlab!69351))
- [Zoom into design image upto 100% of actual size](gitlab-org/gitlab@d79dd4151f0af62da3f2f50c0f2709090c2b29ed) ([merge request](gitlab-org/gitlab!68755))
- [Adds DB fixtures to create base work item types](gitlab-org/gitlab@e005e57ca06b4ca1a0755ed3ab7cd5cd2be8182c) ([merge request](gitlab-org/gitlab!69021))
- [Add configurable maximum YAML file size and depth](gitlab-org/gitlab@b12164a3e8f67559d7a3066a3892e7ad5374b01b) by @discinaround ([merge request](gitlab-org/gitlab!68593))
- [Add customized README file when creating new Security Policy Project](gitlab-org/gitlab@d3fec98d4703a145bda6f8edfc38a2caec890ae1) ([merge request](gitlab-org/gitlab!68901)) **GitLab Enterprise Edition**
- [Remove ci_job_trace_force_encode feature flag](gitlab-org/gitlab@a8aec1f652f67ccd60474e0bd05679d8b8bfa1fc) ([merge request](gitlab-org/gitlab!69229))
- [Add pipeline_artifacts_size to projectSatisticsType](gitlab-org/gitlab@3c85d5193f53ecad28e1ccbba7e10060d6420ab8) ([merge request](gitlab-org/gitlab!69224))
- [Enable bulk_import feature flag by default](gitlab-org/gitlab@ed1849e125b6c087b502792484fd5bdaf98f0280) ([merge request](gitlab-org/gitlab!69110))
- [Update Geo node to Geo site](gitlab-org/gitlab@117a4dea442effc7618baa47cc700b2abc3caf58) ([merge request](gitlab-org/gitlab!68991))
- [Update to Ruby 2.7.4](gitlab-org/gitlab@c4eb10aeed0bb20360955fb61323a2d6c3285e65) ([merge request](gitlab-org/gitlab!68363))
- [Group Settings CI/CD h4 expand](gitlab-org/gitlab@150c7bf32ada427dbf4d4ecd54a3262d2df40dfd) by @quatauta ([merge request](gitlab-org/gitlab!68706))
- [Catch all errors when processing Debian changes](gitlab-org/gitlab@55f4fe6625139b7c178bca16d8e11254637f5e9f) by @sathieu ([merge request](gitlab-org/gitlab!69141))
- [Externalize messages on EKS settings page](gitlab-org/gitlab@776cb1a38de7dc217386bdf9f55a208005151cfd) by @JonstonChan ([merge request](gitlab-org/gitlab!69125))
- [Externalize page-title messages](gitlab-org/gitlab@818702617d12e3818b57fee65959c51599097be9) by @JonstonChan ([merge request](gitlab-org/gitlab!69124))
- [Externalize add_to_breadcrumbs messages](gitlab-org/gitlab@786c3f7f5556ba9e907b8ed4e576e76af935aec1) by @JonstonChan ([merge request](gitlab-org/gitlab!69123))
- [Add warning to when converting runner to specific](gitlab-org/gitlab@d25f47a0ab69986a3e7dc71e05a365fe7f1716f2) ([merge request](gitlab-org/gitlab!68966))
- [Update incident management limits UI text](gitlab-org/gitlab@b4dd5f7d8824969a23096b8200cf6093242f409c) ([merge request](gitlab-org/gitlab!68828)) **GitLab Enterprise Edition**
- [Scope i18n strings that are incorrectly unscoped](gitlab-org/gitlab@77c6493f466df4b425dbc063572967f96426f647) by @JonstonChan ([merge request](gitlab-org/gitlab!69005))
- [Unscope i18n strings that are incorrectly scoped](gitlab-org/gitlab@c13eabbad21513c9e1487156369a5f9ee12e36cd) by @JonstonChan ([merge request](gitlab-org/gitlab!69002))
- [Externalize breadcrumb_title message](gitlab-org/gitlab@d3ceacb085cb668be7eb4e10e1cc009e29fa7c38) by @JonstonChan ([merge request](gitlab-org/gitlab!68999))
- [Externalize submit "Save changes" message](gitlab-org/gitlab@a4f4528534ccbe213829e99d4b295c0e10df305e) by @JonstonChan ([merge request](gitlab-org/gitlab!68910))
- [Use Gitlab::Ci::Lint in /ci/lint API endpoint](gitlab-org/gitlab@919e5bddb505abf403147206b91a37a545f2e377) ([merge request](gitlab-org/gitlab!68860))
- [Require a LoadBalancer for service discovery](gitlab-org/gitlab@ea7a01bfceec1f81af394338e5c6ab5e1dafff69) ([merge request](gitlab-org/gitlab!68856))
- [Only show tooltip on truncate](gitlab-org/gitlab@5013d50cb41e1c341974fadf5d4aa476da42e4c8) ([merge request](gitlab-org/gitlab!68889))
- [Remove scanner_type argument from GraphQL mutation](gitlab-org/gitlab@1ef6230f463f6a8c8354f1623106ca00b4339379) ([merge request](gitlab-org/gitlab!68951)) **GitLab Enterprise Edition**
- [Remove runner "locked" toggle where not used](gitlab-org/gitlab@64291433a841b9a29766f002cfccadb531110cee) ([merge request](gitlab-org/gitlab!68833))
- [Fetch discussions using GraphQL](gitlab-org/gitlab@02de2063d26a427dfbaaced1541421f310913c9c) ([merge request](gitlab-org/gitlab!68180))
- [Prepopulate new issue with link to the parent](gitlab-org/gitlab@d95d1e5dd6b5f2ebeea79b97eda1367c75ce17d2) by @smokris ([merge request](gitlab-org/gitlab!68226))
- [Group Settings Default initial branch h4 expand](gitlab-org/gitlab@4a991eb788ab7dd1c55a2139471f984fe15e6934) by @quatauta ([merge request](gitlab-org/gitlab!68667))
- [Always use `SetFullPath` RPC](gitlab-org/gitlab@955a97c4a049040b7633b9c18e9cafe79dfcd83c) ([merge request](gitlab-org/gitlab!68745))
- [Making cross-reference links distinctly visible](gitlab-org/gitlab@465859fa49149aed4f4f2238f8c833687400ca4c) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/68063))
- [Pipeline Security: Rename "scanner" to "tool"](gitlab-org/gitlab@78fbfe4294f70cec6fba639c0d2f8efe26cc6863) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/68713)) **GitLab Enterprise Edition**
- [Set blocked Omniauth accounts to blocked_pending_approval](gitlab-org/gitlab@e55a945907c967e27994fe1c4cbf6db6835e5aaa) by @vfazio ([merge request](gitlab-org/gitlab!63650))
- [Stringify policy yaml response in scanExecutionPolicies graphql query](gitlab-org/gitlab@a5847351af8aeb83b970e9dc6019bc796fba6395) ([merge request](gitlab-org/gitlab!68656)) **GitLab Enterprise Edition**
- [Improve error message for TransferService](gitlab-org/gitlab@21b9cf4975690f9952d0c82e6cac9799f9646e0d) ([merge request](gitlab-org/gitlab!68536))
- [Geo SSF: fix texting in admin area](gitlab-org/gitlab@7841a215413474fa221ba42cc61e4dae6382f39d) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/68588)) **GitLab Enterprise Edition**
- [Split for_project_paths into two queries](gitlab-org/gitlab@595d0b322722a43e7abfe58d0b783e81ae5b7a62) ([merge request](gitlab-org/gitlab!68457))
- [Migrate epic sidebar participants to widget](gitlab-org/gitlab@34ff5a78d0a22972cedfed0b8d164ad4e34192f6) ([merge request](gitlab-org/gitlab!68438)) **GitLab Enterprise Edition**
- [Remove the usage_data_design_action feature flag](gitlab-org/gitlab@9ea9f55d389d140a9e9e5e36d1f6981d9f5cc583) ([merge request](gitlab-org/gitlab!68534))
- [Vulnerabilities CSV: Rename "scanner" to "tool"](gitlab-org/gitlab@083307fed998b18ddd5cd719be9ffed1e7bc0bf1) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/68238)) **GitLab Enterprise Edition**
- [Remove feature flags for DAST disable_joins](gitlab-org/gitlab@2fd44466282ef61adb34441282246d76026efd88) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/68440)) **GitLab Enterprise Edition**
- [Migrate epic sidebar ancestors to widget](gitlab-org/gitlab@47302502f9d154d414bdff88b9fce62efb9110d2) ([merge request](gitlab-org/gitlab!68428)) **GitLab Enterprise Edition**
- [Disable Vulnerability Finding Link creation](gitlab-org/gitlab@144d35ebddd4e8a8fe3e9e69c7d17e7301602877) ([merge request](gitlab-org/gitlab!68381)) **GitLab Enterprise Edition**
- [Remove feature flag milestone_reference_pattern](gitlab-org/gitlab@154ae7d5d8bc1b1558665a527d54355ee45a1067) ([merge request](gitlab-org/gitlab!68358))

### Deprecated (1 change)

- [Consider repository_push_audit_events deprecated](gitlab-org/gitlab@15b9442ad50b8ff11528fa3643fcb0e904ba615f) ([merge request](gitlab-org/gitlab!69024))

### Removed (16 changes)

- [Remove ci_templates_total_unique metrics](gitlab-org/gitlab@5ccf6e7f208fdae7840a74f29002ffd59fe5657f) ([merge request](gitlab-org/gitlab!69615))
- [Disable method instrumentation initialization](gitlab-org/gitlab@1458985e7d83a3029de9aec7850006daabad3314) ([merge request](gitlab-org/gitlab!69662))
- [Remove feature flag for env_vars_resource_group](gitlab-org/gitlab@61d86ca772e950bca449d57cbe3f01824ec5c5bb) ([merge request](gitlab-org/gitlab!70014))
- [Add migration to remove projects.container_registry_enabled](gitlab-org/gitlab@684002d9d2ce44f49174354228d632743685d3ae) ([merge request](gitlab-org/gitlab!69998))
- [Update docs regarding pages legacy storage in 14.3](gitlab-org/gitlab@da1549a01d5f98ab402f08fea96fbe668af5f54c) ([merge request](gitlab-org/gitlab!69383))
- [Remove experience level functionality](gitlab-org/gitlab@699ea2b42b48350108a340ca40a88c36fd0a0c4c) ([merge request](gitlab-org/gitlab!69491))
- [Remove Markdown support for bio field](gitlab-org/gitlab@e5d7fa818beee7a61d075f5dd4e30254417e79d5) ([merge request](gitlab-org/gitlab!68628))
- [Remove FF load balancing for deployments hooks worker](gitlab-org/gitlab@4f99eb1b5dd698ca0a0e17a7c2ae27ac23379e98) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/69557))
- [Remove GitLab Pages legacy storage lease](gitlab-org/gitlab@2afa44348e983b1468bd9e1f48da80e03795df10) ([merge request](gitlab-org/gitlab!69377))
- [Stop deploying GitLab Pages to legacy storage](gitlab-org/gitlab@0882ce0e831ffcbea8b9566fadcd3d8928dda8f3) ([merge request](gitlab-org/gitlab!69287))
- [Remove Clair deprecation warning](gitlab-org/gitlab@fc69cd195ce1595e464cb35bcc37c71e6cfac455) ([merge request](gitlab-org/gitlab!69428)) **GitLab Enterprise Edition**
- [Remove feature flag gitaly_backup](gitlab-org/gitlab@25e7fb5a55e9d72ed7f486e3a714a9ec16001974) ([merge request](gitlab-org/gitlab!68510))
- [Remove name parameter from pipeline finder](gitlab-org/gitlab@ba78bb2a74ad358ce917c15c6077ebd5098c706f) ([merge request](gitlab-org/gitlab!68997))
- [Remove seat_link_enabled from ApplicationSettings db table](gitlab-org/gitlab@ea3197d558804706eb8812f313aa645d3fca48a5) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/66534))
- [Remove cloud_license_enabled database column](gitlab-org/gitlab@748c20e9bea811ec97cd4c5be2318afa45f9dd53) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/65541))
- [merge_request: Drop checks whether a squash is in progress](gitlab-org/gitlab@b5b78c33c9f003f61201fb68462c56219b71e6d3) ([merge request](gitlab-org/gitlab!68647))

### Security (14 changes)

- [OAuth Access Tokens generated by new applications have expiry](gitlab-org/gitlab@74b9b5993c67b35e082ff5005645bdcfec206318) ([merge request](gitlab-org/gitlab!69514))
- [Sanitize emojis when reading from LocalStorage](gitlab-org/gitlab@2e07ba0574f2258e54b6ca0e21f56bd11ee78f7d) ([merge request](gitlab-org/gitlab!68988))
- [Always include default config for DOMPurify](gitlab-org/gitlab@de0647b6a03f363ab7fa6f067f11501af8d8af74) ([merge request](gitlab-org/gitlab!69269))
- [Deny access for repository coverage info for guests](gitlab-org/gitlab@f04ef9b180359e75fbc6e61fea49ca400760c7a1) ([merge request](gitlab-org/gitlab!68947)) **GitLab Enterprise Edition**
- [Prevent non-admins from configuring Jira connect app](gitlab-org/gitlab@36b00195a4a5df27ecf44d5e96c8c9ecc959c8c8)
- [Update apollo_upload_server dependency](gitlab-org/gitlab@a360142bb99b37e48051c2455246f0fd4e6cd542)
- [Ensure shared group members lose project access after group deletion](gitlab-org/gitlab@8f1962ad6865c2dfc0452f1089d12889b5f3f087)
- [Update Import/Export to use public email when mapping users](gitlab-org/gitlab@c9375914fbc78f94bcb97762842b4208bc4659a1) **GitLab Enterprise Edition**
- [Update mermaid to 8.11.5](gitlab-org/gitlab@ba3db73a2c8d34e4664a78983feb2befdc10afff) by @bufferoverflow ([merge request](gitlab-org/gitlab!68282))
- [Escape issue reference and title for Jira issues](gitlab-org/gitlab@8c4450ee6328e77abf2d090dcb74b5fb675e13f6) **GitLab Enterprise Edition**
- [Fix stored XSS vulnerability in Datadog settings form](gitlab-org/gitlab@e96534e084a74b237323f7a55b8d62c6be8445e9)
- [Inherit user external status while creating project bots](gitlab-org/gitlab@04e5ab35b8678fb3d615dba44dfd97f9c89b022e)
- [Require sign in for .keys endpoint on non-public instances](gitlab-org/gitlab@8951195f9787d8df0d1faaad8ce7a6a975e29853)
- [Only create jira connect NS subscriptions for admins](gitlab-org/gitlab@6b88a3155df206d0c76725236334e590558ccc65)

### Performance (43 changes)

- [Add index for selecting resource_group from ci_builds](gitlab-org/gitlab@aa8ee780d6e720fe4027cf17e18c5d69bcf3af30) ([merge request](gitlab-org/gitlab!70279))
- [Perform FindTag RPC request for a single tag](gitlab-org/gitlab@3180cf1cec79995159efe9d8cb9978d9a497a39a) ([merge request](gitlab-org/gitlab!70181))
- [Remove redundant permission checks for GraphQL job type](gitlab-org/gitlab@c101a53e438674ac05b1ff39a819580ce42951fa) ([merge request](gitlab-org/gitlab!69982))
- [Avoid a duplicated SQL condition in the NPM metadata endpoint](gitlab-org/gitlab@daef07bdb72571879bd187857214cfa97ef78c6e) ([merge request](gitlab-org/gitlab!70173))
- [Remove preload_repo_cache feature flag](gitlab-org/gitlab@c39f6dd8e8bcc8ac01d5024b9e12598b12a45ebd) ([merge request](gitlab-org/gitlab!70132))
- [Limit updates to Web Hook backoff interval](gitlab-org/gitlab@95ab29229db83c5918d173922944060ef8f88bc5) ([merge request](gitlab-org/gitlab!69955))
- [Fix N+1 in projects API](gitlab-org/gitlab@f97aff42d29e50c86b659a6ea285a371ac5ba700) ([merge request](gitlab-org/gitlab!69949))
- [Remove cache_merge_to_ref_calls feature flag](gitlab-org/gitlab@ab017f16e4b2168bc74de8ccd226e5e56e9952f3) ([merge request](gitlab-org/gitlab!69904))
- [Limit max pagination count for relations to 1000](gitlab-org/gitlab@d0df47b80af56dbfb84f779804dd33b2b4bd719c) ([merge request](gitlab-org/gitlab!69620))
- [Batch loading of open issues count from Redis](gitlab-org/gitlab@21b3bc3ea6621a3a6623c933878e3d3735913e1e) ([merge request](gitlab-org/gitlab!69479))
- [Decrease WebHooks::LogExecutionWorker retries](gitlab-org/gitlab@dfeb0e69e202d2ec65ad6b44ba6161f96a9b5703) ([merge request](gitlab-org/gitlab!69834))
- [Use specialized worker to refresh authorizations on group-share removal](gitlab-org/gitlab@0a82b83854300fb272f2e1da1956883b093f9af6) ([merge request](gitlab-org/gitlab!69739))
- [Run UserRefreshFromReplicaWorker jobs on the replica db by default](gitlab-org/gitlab@220738943ec90b5a2081d57bd313eded889baab7) ([merge request](gitlab-org/gitlab!69728))
- [push_rules: Implement bulk-checking of file sizes](gitlab-org/gitlab@8a5681f2feafa52e8f36c93ecf84cbf56ba651d7) ([merge request](gitlab-org/gitlab!69449))
- [Reduce DB queries when loading root_ancestor](gitlab-org/gitlab@d2680a353f6d250c2d5aa28ae0d4862c2ec2cdbd) ([merge request](gitlab-org/gitlab!69533))
- [Release cached merge_request show.json](gitlab-org/gitlab@e67a069a78cddfbb90156ebb9422a6c323c15260) ([merge request](gitlab-org/gitlab!69618))
- [Release diffs_batch cached rendering](gitlab-org/gitlab@c7d293f0a386724a309153923e4a70320b6d1af1) ([merge request](gitlab-org/gitlab!69617))
- [Fix n+1 for award_emoji field when fetching epics](gitlab-org/gitlab@1d4bf92ae235908e541e88a6396433b3d9803ce6) ([merge request](gitlab-org/gitlab!69528)) **GitLab Enterprise Edition**
- [Remove pipeline variable unique validation](gitlab-org/gitlab@162c9c1b8602ee705d8e2b1c6773f64e4cd1940b) ([merge request](gitlab-org/gitlab!69595))
- [Splits up auto_cancelable_pipelines query, adds limit](gitlab-org/gitlab@ad64acb2e0f41b48db03e0ac3d99867e27340df0) ([merge request](gitlab-org/gitlab!68585))
- [Use linear version GroupsWithTemplatesFinder#extended_group_search](gitlab-org/gitlab@b4ea0323f91a9b19cbee7e328797de260ae060d2) ([merge request](gitlab-org/gitlab!68936)) **GitLab Enterprise Edition**
- [Use linear version ApplicationSettings#elasticsearch_limited_namespaces](gitlab-org/gitlab@8078e245cb3bce435abb40e3b07766f70243c2da) ([merge request](gitlab-org/gitlab!68931)) **GitLab Enterprise Edition**
- [Use linear version User#groups_with_developer_maintainer_project_access](gitlab-org/gitlab@d568481f854ad29f133ef300f34b84c7b5a4c976) ([merge request](gitlab-org/gitlab!68851))
- [Move vulnerability statistics update out of transaction](gitlab-org/gitlab@8de7a2fb5f4b3f518f8325437ed23d0afc08c5d0) ([merge request](gitlab-org/gitlab!69045)) **GitLab Enterprise Edition**
- [Use linear version of User#manageable_groups](gitlab-org/gitlab@f9818cfe32299fc04c3bc8e5837ba66dacbbe5ce) ([merge request](gitlab-org/gitlab!68845))
- [Decrease epics, child epics and child issues max page size](gitlab-org/gitlab@8978337ee0cab9dcb75c03e87192ecf5b7e97da4) ([merge request](gitlab-org/gitlab!68403)) **GitLab Enterprise Edition**
- [Caching the protected branch check](gitlab-org/gitlab@f5f2644d39604e094cecf52f951eca1248a9c0f8) ([merge request](gitlab-org/gitlab!64738))
- [Enable caching of MergeToRefService responses](gitlab-org/gitlab@356f15652385cb7630ab4a4d3e7b6b6daf31a897) ([merge request](gitlab-org/gitlab!69019))
- [Remove the npm_presenter_queries_tuning FF](gitlab-org/gitlab@0c29fc19c2093d0f4ed50959ac84d22d53eb989d) ([merge request](gitlab-org/gitlab!69058))
- [Use linear version of User#membership_groups](gitlab-org/gitlab@fc9371979d192ef6b761184f049c1bcd75d33fee) ([merge request](gitlab-org/gitlab!68842))
- [Use linear version of groups_including_descendants_by](gitlab-org/gitlab@5434af3edbbb1e6d784ee96e6b499f932e5eb62b) ([merge request](gitlab-org/gitlab!68835))
- [Optimize StuckCiJobsWorker running builds query](gitlab-org/gitlab@e5ef10c611aa71299a46ba8ac60db1e0eee6eb3b) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/68891))
- [Use reference cache for iterations](gitlab-org/gitlab@81109da95d4628fad060bc8e414506fe9337d6d7) ([merge request](gitlab-org/gitlab!67431)) **GitLab Enterprise Edition**
- [Cache content_sha256 field for Files API](gitlab-org/gitlab@91bf332a1736f48bc7df3a7cee8cb502dad31061) ([merge request](gitlab-org/gitlab!67280))
- [Eliminate N+1 queries for pipeline GraphQL endpoint](gitlab-org/gitlab@cec7261f50f09539df3bd0bdccdb17d6e2f6f00f) ([merge request](gitlab-org/gitlab!68729))
- [Upgrade grape-path-helpers to 1.7.0](gitlab-org/gitlab@0a82a7e91ae649d09ad865146c21fb02279eacc8) ([merge request](gitlab-org/gitlab!68916))
- [Remove `safe_find_or_create_by!` usage](gitlab-org/gitlab@84e7ea128206b9fd12a9ea409836615bf08d6533) ([merge request](gitlab-org/gitlab!68859))
- [Remove feature flag used to enable subtransactions counter](gitlab-org/gitlab@296f7f653a30e5b2b5d8f00fb8e8417012cb4355) ([merge request](gitlab-org/gitlab!68764))
- [Remove safe_find_or_create_by! calls](gitlab-org/gitlab@94e08bc132f410dcafc35b6110689f736617eed1) ([merge request](gitlab-org/gitlab!68649))
- [checks: Always enable batched computation of commits](gitlab-org/gitlab@295f2e3845b8f9c4c9310c91fb5ed788a1eaab9d) ([merge request](gitlab-org/gitlab!68747))
- [Never fetch more than 101 commits when processing a git push](gitlab-org/gitlab@81be7217f8670f5faa930bbd867951408040e123) ([merge request](gitlab-org/gitlab!67491))
- [Reduce Gitaly calls for keeping around refs of published notes](gitlab-org/gitlab@a47de44666327cb713093eb0c3a105d0e19830ad) ([merge request](gitlab-org/gitlab!68337))
- [Use the ListCommits RPC, not CommitsBetween, when processing git push](gitlab-org/gitlab@2a3182749c565f6b357c0432fc37d9c50a9c6420) ([merge request](gitlab-org/gitlab!68470))

### Other (56 changes)

- [Remove optimized_issuable_label_filter flag](gitlab-org/gitlab@7f1c9cc71a827584227b697a4367d7b63d1e42d7) ([merge request](gitlab-org/gitlab!70289))
- [Snowplow event dictionary first run for Vue files](gitlab-org/gitlab@b48ec7b325ef782c86850e2bb090d27802108174) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/70450)) **GitLab Enterprise Edition**
- [Add Snowplow event dictionary for Vue files](gitlab-org/gitlab@74ee2d053e35ff4d71ac787ad948724282d44e8d) ([merge request](gitlab-org/gitlab!67981)) **GitLab Enterprise Edition**
- [Remove track_all_ci_template_inclusions FF](gitlab-org/gitlab@75b9287a604bb82321b784739d7fb77f29f1a5f3) ([merge request](gitlab-org/gitlab!70380))
- [Plain replace of track-event to track-action](gitlab-org/gitlab@9078236d088632b2b72df65666d35680fc01b6df) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/56904)) **GitLab Enterprise Edition**
- [Remove FF ci_daily_limit_for_pipeline_schedules](gitlab-org/gitlab@a2f1f86bcdcd1fe9faeac262d2135445686d1c44) ([merge request](gitlab-org/gitlab!70163))
- [Remove FF ci_modified_paths_of_external_prs](gitlab-org/gitlab@0a43715f40d73ea9a38934fa54dfbca65d7e61a1) ([merge request](gitlab-org/gitlab!70161))
- [Update the helm documentation](gitlab-org/gitlab@dc8b51f21af9325ea5144b1e68351587edfe3749) ([merge request](gitlab-org/gitlab!70178))
- [Finalize conversion to bigint for ci_builds_metadata](gitlab-org/gitlab@21415536061b9ac91e7b1e3b698b1b09534d6152) ([merge request](gitlab-org/gitlab!65692))
- [Add status columns to dependency proxy tables](gitlab-org/gitlab@209658cd6e8f6d83727c94bd42079ffa8f3575f8) ([merge request](gitlab-org/gitlab!69901))
- [Remove load performance widget usage data flag](gitlab-org/gitlab@487442b036ab31232a559e3e9b178df28baf1962) ([merge request](gitlab-org/gitlab!68847)) **GitLab Enterprise Edition**
- [Finalize conversion to bigint for taggings](gitlab-org/gitlab@b6856991f3aa150e36318922534a56590f704397) ([merge request](gitlab-org/gitlab!66625))
- [Clean up feature flag for pipeline editor branch switcher](gitlab-org/gitlab@a8f2168ed1fe6fa61650145b29c7e869b3fb376d) ([merge request](gitlab-org/gitlab!66717))
- [Track all CI template inclusions](gitlab-org/gitlab@258d2f2ea227a0aec2c933768b8cff7fec40a928) ([merge request](gitlab-org/gitlab!69204))
- [Revert "Merge branch...](gitlab-org/gitlab@2ee987bc775dcaa4432dfacd20a17cc82921ffc0) ([merge request](gitlab-org/gitlab!69812))
- [Remove the default enabled feature flag](gitlab-org/gitlab@1630d748a49a401d1d0ba78c129fabc0924c3c6e) ([merge request](gitlab-org/gitlab!69755))
- [Fix: update error budget documentation](gitlab-org/gitlab@2d5f19a14d1e34277e2c57617a2fd84aca0cbc66) ([merge request](gitlab-org/gitlab!69732))
- [Cleanup bigint conversion for geo_job_artifact_deleted_events](gitlab-org/gitlab@2ca0e62a01f887a3d9c260c11030f80045e10802) ([merge request](gitlab-org/gitlab!69722))
- [Cleanup bigint conversion for deployments](gitlab-org/gitlab@dc6dac21cb8f76c7d21357487ac1bb1d6ac9edd4) ([merge request](gitlab-org/gitlab!69719))
- [Cleanup bigint conversion for ci_stages](gitlab-org/gitlab@45b010cbf8891db59aef73f58d5f8e617d9a9b0b) ([merge request](gitlab-org/gitlab!69714))
- [Remove use_insert_all_in_internal_id feature flag](gitlab-org/gitlab@26a8a7ff654b0a015c70d14e44b14321c99d0b1a) ([merge request](gitlab-org/gitlab!69598))
- [Remove metrics report usage data feature flag](gitlab-org/gitlab@72a1657d0bf624a4568e10eddb554aa6d3720c22) ([merge request](gitlab-org/gitlab!68657)) **GitLab Enterprise Edition**
- [Remove the FF ci_fix_commit_status_retried](gitlab-org/gitlab@fed8e557c0d1e62134aa9187219fdaa2166d111d) ([merge request](gitlab-org/gitlab!69555))
- [Remove bigint conversion triggers for events](gitlab-org/gitlab@bfd5ac61e24c2f8533b23a82878906d85cc49f6a) ([merge request](gitlab-org/gitlab!69337))
- [Move usage_graph component to vue_shared folder](gitlab-org/gitlab@9003a12c1bc4aa82fece65b28149a22d47455144) ([merge request](gitlab-org/gitlab!69374))
- [Prepare ci_builds swap indexes for async creation](gitlab-org/gitlab@bdab6b9c92a2d19687b7b3ca5dc74eca695b8cf0) ([merge request](gitlab-org/gitlab!69404))
- [Bump fast_gettext to the latest](gitlab-org/gitlab@329c5a3b810437e6b9d046cd3a94e09769da2814) ([merge request](gitlab-org/gitlab!69236))
- [Introduce versioned GitLab migration class](gitlab-org/gitlab@137f716c6b118e65651c8df26edcc606bc71c413) ([merge request](gitlab-org/gitlab!68986))
- [Remove bigint conversion triggers for push_event_payloads](gitlab-org/gitlab@7d5a2605a949f0b3eaa9eec5232e5d15e097b197) ([merge request](gitlab-org/gitlab!69339))
- [Fix contextual help link and other minor improvements](gitlab-org/gitlab@012d10086d32d4c8e73c6c8c372f0682a41d73f5) ([merge request](gitlab-org/gitlab!68838)) **GitLab Enterprise Edition**
- [Clean up :graphql_board_list feature flag](gitlab-org/gitlab@cfccf9032a8fd0cab2962fe2fdde20f327932867) ([merge request](gitlab-org/gitlab!67815))
- [Revert "Merge branch 'stuck-ci-jobs-worker-optimize-running' into 'master'"](gitlab-org/gitlab@af23fa473a470d81f5a07b1a00072b38ce7c35d9) ([merge request](gitlab-org/gitlab!69163))
- [Cleanup used membership invites](gitlab-org/gitlab@8c4879e7e5be46969823aa64ab676e57e809d5a2) ([merge request](gitlab-org/gitlab!69064))
- [Remove temp index on approval_project_rules](gitlab-org/gitlab@c2efc57d6ed6e3221fb5652a9ddd12283ee731aa) ([merge request](gitlab-org/gitlab!68579))
- [Add models for dependency proxy ttl policies](gitlab-org/gitlab@d40a4e5a0b14270cc18443fcc8a6c971ec339bbb) ([merge request](gitlab-org/gitlab!68809))
- [Bump prometheus-client-mmap to 14.0](gitlab-org/gitlab@877b827e1039644167a344dacc5d05cb9c9eee1e) ([merge request](gitlab-org/gitlab!68987))
- [Update GitLab Shell to v13.21.0](gitlab-org/gitlab@142c6e006e536fbd603ffe41061b45f049bfb292) ([merge request](gitlab-org/gitlab!68985))
- [Remove enabled runner_graphql_query feature flag](gitlab-org/gitlab@fefdb1c3c74c0d78339eb5a2dc83fb91fafa6c0f) ([merge request](gitlab-org/gitlab!68944))
- [Remove upsert_issue_metrics feature flag](gitlab-org/gitlab@2e627c8b2705ea1431a58916a18cf39122bb63eb) ([merge request](gitlab-org/gitlab!68829))
- [Remove optimize_safe_find_or_create_by FF](gitlab-org/gitlab@54715b730f58f88a8426a35384083f64653194d3) ([merge request](gitlab-org/gitlab!68827))
- [Remove column from project_settings](gitlab-org/gitlab@0c9181486033adf7e32a76b6996a5df3cdd0c386) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/68854))
- [Remove the "local file reviews" feature flag](gitlab-org/gitlab@d58a1049c74210cdb43c2bef401fa0857db4bf7f) ([merge request](gitlab-org/gitlab!68813))
- [Prepare async indexes for ci table int8 swaps](gitlab-org/gitlab@25c10c86b0a70f55ba67f3a0b52afcb3d1cc4bf9) ([merge request](gitlab-org/gitlab!68888))
- [Remove store_mentions_without_subtransactions FF](gitlab-org/gitlab@185df145797a9e72e81ec97c2da0587d151b403b) ([merge request](gitlab-org/gitlab!68826))
- [Remove unused other_storage_counter](gitlab-org/gitlab@1c8be2482ae8a13dbc5e00980ad17f6ada3a9ed9) ([merge request](gitlab-org/gitlab!68736))
- [Remove enabled runner_detailed_view_vue_ui flag](gitlab-org/gitlab@e7644ad7544aa06d7f47a7e88df6fc3c657fb9d2) ([merge request](gitlab-org/gitlab!68839))
- [Remove web performance widget usage data flag](gitlab-org/gitlab@0d55ceb00913a4ef2e3f628268c03462c46c74b1) ([merge request](gitlab-org/gitlab!68837)) **GitLab Enterprise Edition**
- [Finalize conversion to bigint for events](gitlab-org/gitlab@a69fa0532997f389601c273b69dcb5b09d8219dd) ([merge request](gitlab-org/gitlab!64779))
- [Remove column from project_settings](gitlab-org/gitlab@c8c78bad3263b15b0ab61223000fb39c45e9dc64) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/68798))
- [Fix instrumentation meta method definition](gitlab-org/gitlab@62d9bae05f72eb1fca4a5cfe06ceaa3c3de787fa) ([merge request](gitlab-org/gitlab!68568))
- [Remove board_new_list feature flag](gitlab-org/gitlab@ec1eb8d0e115e8cd7fbdcd683d3cadd0536f4b88) ([merge request](gitlab-org/gitlab!59826))
- [Prepare indexes on events for bigint column conversions](gitlab-org/gitlab@e05745930510e30c3b69a22f66450bde5fc48e65) ([merge request](gitlab-org/gitlab!68426))
- [Remove `track_unique_visits` feature flag](gitlab-org/gitlab@9ba606897436e4356568bbf62d78e7b8f596b996) by @edith007 ([merge request](gitlab-org/gitlab!68569))
- [Remove deprecated deployment workers](gitlab-org/gitlab@237d7a54fdac62847f8078228fc2ed6692f33f7e) by @edith007 ([merge request](gitlab-org/gitlab!67683))
- [Remove the FF ci_reset_bridge_with_subsequent_jobs](gitlab-org/gitlab@a4a75095b9b0250d0b1bdadea90c8a4cd24449b2) ([merge request](gitlab-org/gitlab!68295))
- [Removes ci_same_stage_job_needs ff](gitlab-org/gitlab@5e509cf7aa90041a541b19dda563120a359f0bf9) ([merge request](gitlab-org/gitlab!68041))

## 14.2.7 (2021-11-26)

### Fixed (3 changes)

- [Prevent Git operations from checking replication lag on non-Geo-secondary sites](gitlab-org/gitlab@84734dab92e0bf9e304ee7bf1579346cc48d26c3) ([merge request](gitlab-org/gitlab!75119)) **GitLab Enterprise Edition**
- [Remove defaultAuthors from MR Analytics and VSA](gitlab-org/gitlab@1a15d4d1be939a9e38124827f563ed9ec2612a75) ([merge request](gitlab-org/gitlab!75119))
- [Let non-members set confidential flag when creating an issue in public project](gitlab-org/gitlab@d093cc62e6263629b36a449c9464d9b8644d4d74) ([merge request](gitlab-org/gitlab!75119))

### Changed (4 changes)

- [Geo: Alternate redownload and normal design sync attempts](gitlab-org/gitlab@d401e3ec94e6dba9ea76a9682893352f28d446cb) ([merge request](gitlab-org/gitlab!75119)) **GitLab Enterprise Edition**
- [Geo: Alternate redownload and normal SSF sync attempts](gitlab-org/gitlab@00eeff14a9bfeabe9107fc38ce9d7d2eee06384b) ([merge request](gitlab-org/gitlab!75119)) **GitLab Enterprise Edition**
- [Geo: Alternate redownload and normal project syncs](gitlab-org/gitlab@fac9bb8c11db13d34b311f4ebd18f84fa7a575d3) ([merge request](gitlab-org/gitlab!75119)) **GitLab Enterprise Edition**
- [Geo: Reduce frequency of redownload attempts](gitlab-org/gitlab@d18381e4788a8652d3e36cec5d4bce343c48209c) ([merge request](gitlab-org/gitlab!75119)) **GitLab Enterprise Edition**

## 14.2.6 (2021-10-28)

### Security (13 changes)

- [Highlight usage of unicode bidi characters](gitlab-org/security/gitlab@18a768bb3cd19b6dc780bb85d91a93605ec8aa4f) ([merge request](gitlab-org/security/gitlab!1939))
- [Fix dompurify.js to prevent path traversal attacks](gitlab-org/security/gitlab@cfd7c715162c22060b9b80268ef501a9e604421a) ([merge request](gitlab-org/security/gitlab!1931))
- [Refresh authorizations on transfer of groups having project shares](gitlab-org/security/gitlab@3fc08eb869156a090b015e78da79c8ced16a7162) ([merge request](gitlab-org/security/gitlab!1918))
- [Do not allow Applications API to create apps with blank scopes](gitlab-org/security/gitlab@c4ffc8c0ee5356bcb9b76dbfa92517589b4225a8) ([merge request](gitlab-org/security/gitlab!1924))
- [Don't allow author to resolve discussions when MR is locked via GraphQL](gitlab-org/security/gitlab@fe2d0b6f250b60619da97f162c93c9e645daf4af) ([merge request](gitlab-org/security/gitlab!1921))
- [Workhorse: Allow uploading only a single file](gitlab-org/security/gitlab@89b04599592b7dfc0e4883cfde5d3ecd9ea855b2) ([merge request](gitlab-org/security/gitlab!1915))
- [Group owners should see SCIM token only once](gitlab-org/security/gitlab@d52c1e41f38039db075a7a3418b8eb9ed8474c2a) ([merge request](gitlab-org/security/gitlab!1908)) **GitLab Enterprise Edition**
- [Respect visibility level settings when updating project via API](gitlab-org/security/gitlab@3051d6a00d1a56133a77ecd24313bafb4565d576) ([merge request](gitlab-org/security/gitlab!1905))
- [Avoid decoding the whole tiff image on isTIFF check](gitlab-org/security/gitlab@bab7f45def8fc81fe4b0961a21b4c90a60358ff9) ([merge request](gitlab-org/security/gitlab!1901))
- [Adding a '[redacted]' to mask private email addresses](gitlab-org/security/gitlab@8eb9749f40b87b9b49b034bceb263219a4d3b114) ([merge request](gitlab-org/security/gitlab!1895))
- [Do not display the root password by default](gitlab-org/security/gitlab@4ccf08b6645b9f616657edd266d9d31e3602d170) ([merge request](gitlab-org/security/gitlab!1802))
- [Set PipelineSchedules to inactive](gitlab-org/security/gitlab@ebee16945325d22ceb5c07b7ba48df6fd0b2f067) ([merge request](gitlab-org/security/gitlab!1878))
- [Remove external_webhook_token from exported project](gitlab-org/security/gitlab@f3ef12185902f3ed5c9d62ffce07418fd704a753) ([merge request](gitlab-org/security/gitlab!1865))

## 14.2.5 (2021-09-30)

### Security (28 changes)

- [Require password param for 2FA changes](gitlab-org/security/gitlab@5693760a3edf82774a4e19b9bb561be87316be54) ([merge request](gitlab-org/security/gitlab!1815))
- [Fix permissions check on project members import](gitlab-org/security/gitlab@f9b4200427833e370638aa63851d6801a40c404c) ([merge request](gitlab-org/security/gitlab!1859))
- [Respect disabled import sources when initiating import via API](gitlab-org/security/gitlab@3c9af055ece281fcaab0b8dcc277e0ce9133ad31) ([merge request](gitlab-org/security/gitlab!1847))
- [Return 404 if model id wasn't passed to UploadsController](gitlab-org/security/gitlab@dd4616362040d2b812d69ff2ecf78e70ff4b9ae3) ([merge request](gitlab-org/security/gitlab!1844))
- [Scrub artifacts signed URL in SendEntry logs](gitlab-org/security/gitlab@41d275bb73943ba6f970d6678b49c9336194af35) ([merge request](gitlab-org/security/gitlab!1841))
- [Prevent double-impersonation and impersonation breakout](gitlab-org/security/gitlab@c0ab498adda057f4d87969d74c32a3ea95df297c) ([merge request](gitlab-org/security/gitlab!1835))
- [Clear session access tokens when starting/stopping impersonation](gitlab-org/security/gitlab@fd39d88b348d525818820d2496afe08612420023) ([merge request](gitlab-org/security/gitlab!1832))
- [Use validated URL when sending request to Gitea Importer](gitlab-org/security/gitlab@328e3c726c693b32666e0fb32eda0b7a6f22d8ad) ([merge request](gitlab-org/security/gitlab!1821))
- [Fix XSS in Jira link](gitlab-org/security/gitlab@868d8b9c4a1e9e9019a7ff51da11f75051e452c3) ([merge request](gitlab-org/security/gitlab!1817)) **GitLab Enterprise Edition**
- [Fix fogbugz importer DNS Rebind SSRF](gitlab-org/security/gitlab@4f4b5a15a3508084f921442b3a7f42ba0448f1bb) ([merge request](gitlab-org/security/gitlab!1681))
- [Remove related project access tokens when a project is deleted](gitlab-org/security/gitlab@282e81198f80f1fda912da5bc6f671d778b19ca9) ([merge request](gitlab-org/security/gitlab!1811))
- [Require group admin access to list pending invites](gitlab-org/security/gitlab@1ce85345787025222c915fe5fa314bad8994b6ba) ([merge request](gitlab-org/security/gitlab!1720))
- [Do not export and import repository_size_limit](gitlab-org/security/gitlab@359f14e41dfc355a13041cdf1dbcd082c254200c) ([merge request](gitlab-org/security/gitlab!1769))
- [Escapes MR approval rule names correctly](gitlab-org/security/gitlab@d84739982599197ff337d69d818634544270e142) ([merge request](gitlab-org/security/gitlab!1808))
- [Filter shared groups autocomplete by permitted](gitlab-org/security/gitlab@3a2b4c7ff1eb2ba3e84840ba2800c13d6491d726) ([merge request](gitlab-org/security/gitlab!1805)) **GitLab Enterprise Edition**
- [Require access token for git when 2fa is required](gitlab-org/security/gitlab@deb4e7e5f941c82450d382c1b85f6325e367394f) ([merge request](gitlab-org/security/gitlab!1795))
- [Disable exporting pipeline triggers on project export](gitlab-org/security/gitlab@417761bb2f67f03bfe803163bad97da7b9fa088b) ([merge request](gitlab-org/security/gitlab!1789))
- [Add pagination to dependencies API](gitlab-org/security/gitlab@2f84755ba54580df126054a561d8cc4731f936d3) ([merge request](gitlab-org/security/gitlab!1724)) **GitLab Enterprise Edition**
- [Permission check issuable template API data](gitlab-org/security/gitlab@a90614e2efc813ca5f13a9aa9b51f13f0e8934aa) ([merge request](gitlab-org/security/gitlab!1786)) **GitLab Enterprise Edition**
- [Apply account locking to password reset page](gitlab-org/security/gitlab@6bbd77c0748e59eacff51edb6264d6099ee14a38) ([merge request](gitlab-org/security/gitlab!1783))
- [Enforce configured scopes for Oauth applications](gitlab-org/security/gitlab@a9f44bb19cbfc460cd05627a80ef17c39cdde86b) ([merge request](gitlab-org/security/gitlab!1780))
- [Verify state before using errors from OAuth2 OmniAuth providers](gitlab-org/security/gitlab@6f70292d0fa3efbe99c44748a463df189830cc35) ([merge request](gitlab-org/security/gitlab!1777))
- [Prevent moving epic issues to different group hierarchy](gitlab-org/security/gitlab@979d40003794014d5930709a257e9a5c75df10e6) ([merge request](gitlab-org/security/gitlab!1773)) **GitLab Enterprise Edition**
- [Prevent showing not allowed subgroup epics](gitlab-org/security/gitlab@2f72e4062f6cd7256ffff31172b00c012a5910e1) ([merge request](gitlab-org/security/gitlab!1765)) **GitLab Enterprise Edition**
- [Do not allow status checks to exist with external protected branches](gitlab-org/security/gitlab@dd08837d054c574f94f80e806cc7b49de342cc57) ([merge request](gitlab-org/security/gitlab!1762)) **GitLab Enterprise Edition**
- [Fix GFM autocomplete xss](gitlab-org/security/gitlab@5afba618ef89fdce544f498a30e7366e3f6cb788) ([merge request](gitlab-org/security/gitlab!1747))
- [Prohibit anonymous access for specific user API endpoint](gitlab-org/security/gitlab@a813bd8a8f07ffa0477efd3a3936b436e5ec6b17) ([merge request](gitlab-org/security/gitlab!1736))
- [Fix denial-of-service attack in Markdown parser](gitlab-org/security/gitlab@f618ad9c104882ac5f707b162e8119805252019e) ([merge request](gitlab-org/security/gitlab!1729))

## 14.2.4 (2021-09-17)

### Fixed (2 changes)

- [Fix Elastic::MigrationWorker current_migration (2nd attempt)](gitlab-org/gitlab@65bf8636d35edc6f580c7f09e1ffafc46ca5fbdb) ([merge request](gitlab-org/gitlab!70494)) **GitLab Enterprise Edition**
- [Removes cleanup job from Terraform.latest](gitlab-org/gitlab@6085d73d1a88aa98310f775fe2ff74584948e1a9) ([merge request](gitlab-org/gitlab!70494))

## 14.2.3 (2021-09-01)

### Fixed (4 changes)

- [Fix Live Markdown Preview in personal and subgroup projects](gitlab-org/gitlab@20553f93703c0bc076c8e1a4fbc4ce07e2e914b7) ([merge request](gitlab-org/gitlab!69316))
- [Fix OrphanedInviteTokensCleanup migration](gitlab-org/gitlab@9c59b2fbdfeb250de66a9d2b9424cde9680f86c3) ([merge request](gitlab-org/gitlab!69316))
- [Reset severity_levels default](gitlab-org/gitlab@34e65788679cfbdeec28357a01a8b303ba61418f) ([merge request](gitlab-org/gitlab!69316))
- [Geo: Replicate multi-arch containers](gitlab-org/gitlab@fdf88767320016a84c83e896b9f9b90291de89e0) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/67624)) **GitLab Enterprise Edition**

## 14.2.2 (2021-08-31)

### Security (9 changes)

- [Prevent non-admins from configuring Jira connect app](gitlab-org/security/gitlab@1bc56361c9daa90accea65836d5a424168a2c544) ([merge request](gitlab-org/security/gitlab!1697))
- [Only create jira connect NS subscriptions for admins](gitlab-org/security/gitlab@c160da2cb32a5774fef149155cfd397981bf9173) ([merge request](gitlab-org/security/gitlab!1698))
- [Update apollo_upload_server dependency](gitlab-org/security/gitlab@5ef659b8c9a5a7338830171c62943d3b8bb16410) ([merge request](gitlab-org/security/gitlab!1699))
- [Ensure shared group members lose project access after group deletion](gitlab-org/security/gitlab@c94e934234a90f82e7fe291ed0f1d6a763b9a977) ([merge request](gitlab-org/security/gitlab!1683))
- [Update Import/Export to use public email when mapping users](gitlab-org/security/gitlab@13fb902c55c2dfe7ec2bf35f58a9cb3d93905d9a) ([merge request](gitlab-org/security/gitlab!1669)) **GitLab Enterprise Edition**
- [Require sign in for .keys endpoint on non-public instances](gitlab-org/security/gitlab@0979dd458e8fa0d4f5e184ef0b9ea042d79f6c14) ([merge request](gitlab-org/security/gitlab!1676))
- [Inherit user external status while creating project bots](gitlab-org/security/gitlab@93062909ffc093cb8f718a3ea3f2976292a9b9af) ([merge request](gitlab-org/security/gitlab!1675))
- [Escape issue reference and title for Jira issues](gitlab-org/security/gitlab@d25ef8599ec03ee80ef1bff7067b2269836400cf) ([merge request](gitlab-org/security/gitlab!1673)) **GitLab Enterprise Edition**
- [Fix stored XSS vulnerability in Datadog settings form](gitlab-org/security/gitlab@23b98dac7864992898992a153950247ac6ccb933) ([merge request](gitlab-org/security/gitlab!1670))

## 14.2.1 (2021-08-23)

### Fixed (1 change)

- [Drop un-used db/ci_migrate symlink](gitlab-org/gitlab@1154311625345e120407c0c397c7d4a27848a739) ([merge request](gitlab-org/gitlab!68723))

### Changed (2 changes)

- [Reorder vuln check criteria](gitlab-org/gitlab@9bbb20db46362a859632e7bb88deba985318ca2c) ([merge request](gitlab-org/gitlab!68723)) **GitLab Enterprise Edition**
- [Don't override vulnerability feedback UUID anymore](gitlab-org/gitlab@5f8372fb782c9416ae5ab582009a4399cb7d3750) ([merge request](gitlab-org/gitlab!68723)) **GitLab Enterprise Edition**

## 14.2.0 (2021-08-20)

### Added (128 changes)

- [Add missing Ci::Build graphql mutations](gitlab-org/gitlab@b0389d7d0da358b550392cf20178c2faea6dbd61) ([merge request](gitlab-org/gitlab!68399))
- [Introduce a table to store job trace metadata](gitlab-org/gitlab@66ac715bd050922f83e754f1f2b27c27848fa2b2) ([merge request](gitlab-org/gitlab!68171))
- [Promote the contact_sales_btn_in_app experiment to product feature](gitlab-org/gitlab@273a053eff53c29ce55f70358b2ebd593a64c7ff) ([merge request](gitlab-org/gitlab!65598))
- [Upgrade GitLab Pages to v1.42.0](gitlab-org/gitlab@5de522492fa0a3d013eef5d75103a93f350036c2) ([merge request](gitlab-org/gitlab!68341))
- [Enable the instance-level overrides feature](gitlab-org/gitlab@b8ab6f1e1c1120a8b53fa0864627bc7a5ff6603f) ([merge request](gitlab-org/gitlab!67927))
- [Add support for inline diff in content editor](gitlab-org/gitlab@c10baec8a0efb6c6a59909cd8c1772c9d7cab042) ([merge request](gitlab-org/gitlab!68231))
- [Update security policies pipeline processor to support secret detection](gitlab-org/gitlab@797d5d844d5533ea6561dc2e584d8b15b0c47b71) ([merge request](gitlab-org/gitlab!67223)) **GitLab Enterprise Edition**
- [Render references in content editor](gitlab-org/gitlab@efc45686c1d1804d8367a292fc63164aa1d7f6c2) ([merge request](gitlab-org/gitlab!68230))
- [Add copy feature to CI job page](gitlab-org/gitlab@5d72b702b7d78566110714a30d9742d32e8e32d0) ([merge request](gitlab-org/gitlab!68148))
- [Limit number of files per pages site](gitlab-org/gitlab@48df27a71ab7c3845172671b20e2cf2e3dcf6fe2) ([merge request](gitlab-org/gitlab!67761))
- [Added new user callout for the Terraform banner](gitlab-org/gitlab@c52952f613e4dfd1ab5cbde859b8f3d1a1ce51eb) ([merge request](gitlab-org/gitlab!68138))
- [Markdown Live preview for Source Editor](gitlab-org/gitlab@2fffee2645d5bb9a4b8b269c578ebca9f9f73fbf) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/68020))
- [Create table zentao_tracker_data](gitlab-org/gitlab@161e6d31110c591b041b76717a98024f5963a3f7) ([merge request](gitlab-org/gitlab!67938))
- [Start tracking project ci feature usages](gitlab-org/gitlab@ce79c6e6e88fc6e9fe2721ccaea801322bd83e13) ([merge request](gitlab-org/gitlab!68186))
- [Add support for task list in content editor](gitlab-org/gitlab@0f07bf94eeed25828118633cc80e9d6db06c682b) ([merge request](gitlab-org/gitlab!68121))
- [Add support for subscript/superscript](gitlab-org/gitlab@79c6a33fa8c64630d2c8318df2bc3a148571e80d) ([merge request](gitlab-org/gitlab!68106))
- [Enable agent registration UI](gitlab-org/gitlab@aae65bb2daddffb001062a08e563b733c709422a) ([merge request](gitlab-org/gitlab!63718)) **GitLab Enterprise Edition**
- [Add support for meta tag DAST site validation](gitlab-org/gitlab@446eb73c72154b0cc835f77681d174e452e8c186) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/67553)) **GitLab Enterprise Edition**
- [Include reply in email egenrated notes](gitlab-org/gitlab@1b6793b1735e0bdb15ff8885afc3a4c44b58eec5) ([merge request](gitlab-org/gitlab!67615))
- [Allow sorting merge requests by latest closed at](gitlab-org/gitlab@e8eec2be09c22e9d34d4ae872ebaf9ada8d6e9e7) ([merge request](gitlab-org/gitlab!67041))
- [Enable seat usage export](gitlab-org/gitlab@96a57bd55a58a139a3b6a71dfa188754da98b5fb) ([merge request](gitlab-org/gitlab!67934)) **GitLab Enterprise Edition**
- [Show artifact downloads for security reports](gitlab-org/gitlab@66e2a2c14c1db3ef5e0bb5eafbe8450ab0ab9e1f) ([merge request](gitlab-org/gitlab!67701))
- [Expose integrated error tracking to services](gitlab-org/gitlab@08a65298328d1215a4c2abc09c1c5b1a7329c976) ([merge request](gitlab-org/gitlab!66847))
- [Render emojis in the Content Editor](gitlab-org/gitlab@27836b5914ab2e677a1bf83a75c7b0ae46c45646) ([merge request](gitlab-org/gitlab!67986))
- [Add dependency link to package type](gitlab-org/gitlab@6bb31a828706c216e68a6f775acb533732374623) ([merge request](gitlab-org/gitlab!67828))
- [Enabled diff virtual scrolling by default](gitlab-org/gitlab@2889ee338ef5fa9eb1e034cc9c29ba00b97709ee) ([merge request](gitlab-org/gitlab!67983))
- [Enables ci_same_stage_job_needs by default](gitlab-org/gitlab@8faa92bc2c5ee9aa0be2ebf6936f7e1cf74c5762) ([merge request](gitlab-org/gitlab!67851))
- [Remove agent_kubeconfig_ci_variable feature flag](gitlab-org/gitlab@57b3effb251f08cbdf2f394f27e293efbf7df872) ([merge request](gitlab-org/gitlab!67734))
- [Prune database partitions older than a retention period](gitlab-org/gitlab@c8b84ced3234b086cb4e6b99452bf8f3e7e49803) ([merge request](gitlab-org/gitlab!67056))
- [Add vulnerabilities_allowed into rules](gitlab-org/gitlab@0f90ed3eeee90352cea72c9aaf2b125d4ca667ab) ([merge request](gitlab-org/gitlab!66685)) **GitLab Enterprise Edition**
- [Add organizations table and model](gitlab-org/gitlab@6a69edffe8b16154cd584c4775c6806e26800b98) ([merge request](gitlab-org/gitlab!67551))
- [Support setting Rails asset host via gitlab.yml](gitlab-org/gitlab@d11ace2405a4af37e85b329ac00e1deec4ca3dca) ([merge request](gitlab-org/gitlab!67710))
- [Disable project/group sharing when User Cap set](gitlab-org/gitlab@108f4f0a04a02aa57ac032aa8518d753719b93c1) ([merge request](gitlab-org/gitlab!67229))
- [Expose timelogs in GraphQL query type](gitlab-org/gitlab@6b0f410efd348ae2a12ff3b6a9ca32c1420810c6) ([merge request](gitlab-org/gitlab!67185))
- [Enable ci_daily_limit_for_pipeline_schedules by default](gitlab-org/gitlab@c8058482a2a41d886bf816fc253305bb278e2dc1) ([merge request](gitlab-org/gitlab!67835))
- [Track changes in merge request approval settings in Audit Events](gitlab-org/gitlab@630bfeaeccf9641015353c300f02b4d225c6dbd5) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/66234)) **GitLab Enterprise Edition**
- [Store hashcode for VSA stage events](gitlab-org/gitlab@760ab23cfb152a0a3ae4a5df0414f18d0ff552f4) ([merge request](gitlab-org/gitlab!67259))
- [Remove ci_jobs_trace_size_limit feature flag](gitlab-org/gitlab@99468602a8450030a63c232d0cc4379e02ed7db6) ([merge request](gitlab-org/gitlab!67770))
- [Index issues on project_id, state_id, created, id](gitlab-org/gitlab@49aed743bdd9ff27451cd8a2c8368db137aae4f8) ([merge request](gitlab-org/gitlab!67304))
- [Feat: enable report abuse button for snippets](gitlab-org/gitlab@449a7e04dd5d65de656dc7e7f6b4867debd07b66) ([merge request](gitlab-org/gitlab!66913))
- [Add tooltip to No Target text in corpus management](gitlab-org/gitlab@736e7a6dfab827b861304fc7f6c893f9700ed480) ([merge request](gitlab-org/gitlab!67345))
- [Remove code quality usage feature flag](gitlab-org/gitlab@dc2466ef052f4749dbc706627fd1b47d8033ff0e) ([merge request](gitlab-org/gitlab!67792))
- [Add severity_levels validation and usage](gitlab-org/gitlab@33e1a9f9f06795f5b8b44c947851d0ccac1189b0) ([merge request](gitlab-org/gitlab!67064)) **GitLab Enterprise Edition**
- [Add support for adding attachments in Content Editor](gitlab-org/gitlab@86ee34786dca713d3dfca6ee64190099497925ac) ([merge request](gitlab-org/gitlab!67728))
- [Add expired tokens alert to personal access tokens profile page](gitlab-org/gitlab@ce93996be8b89115d3265d86ad2d6ee224e6d4f3) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/66915)) **GitLab Enterprise Edition**
- [Show topics in the project list](gitlab-org/gitlab@f9cb6e706c8104be6b96d44693416f79183b507c) ([merge request](gitlab-org/gitlab!65335))
- [Add pipeline iid dropdown](gitlab-org/gitlab@0052c811f0241b39870bf7d308539d7f340f1848) ([merge request](gitlab-org/gitlab!67625))
- [Mark completed jobs as successful](gitlab-org/gitlab@82a928011f15da3aa3aae94b5a758cf4541b3048) ([merge request](gitlab-org/gitlab!67687))
- [Add namespace field to User type in GraphQL](gitlab-org/gitlab@9169e2639da6d162e120c2dd66eda511b6194978) ([merge request](gitlab-org/gitlab!67641))
- [Add view pipeline button in pipeline editor](gitlab-org/gitlab@dd5e9f74604ea891412885b8c0a24547e2c8961f) ([merge request](gitlab-org/gitlab!67474))
- [Add a bubblemenu for text format to Content Editor](gitlab-org/gitlab@8a8a9842b54aa54d9cf197403c145fb7cd05533f) ([merge request](gitlab-org/gitlab!67363))
- [Adds APIs and their specs to projectionist example file](gitlab-org/gitlab@b7d12b6871066146492a7b7350c1bb17e2d181d1) ([merge request](gitlab-org/gitlab!67626))
- [Add rule_index to security_orchestration_policy_rule_schedules](gitlab-org/gitlab@01d1d4398f1c4e99a3f2146a8bdeac0ae5375261) ([merge request](gitlab-org/gitlab!67586))
- [Extend graphql repository with paginated tree field](gitlab-org/gitlab@c97bac9f191f785287324d684b75cfefb45fe325) ([merge request](gitlab-org/gitlab!66751))
- [Add support for security policy project for Projects::CreateService](gitlab-org/gitlab@75e3e09a6f30a26e64ac901b136bd524bccd6a20) ([merge request](gitlab-org/gitlab!66448)) **GitLab Enterprise Edition**
- [Expose vulnerabilities_allowed](gitlab-org/gitlab@d14b3c9ada83fa9047488f312b229f46b9941f4b) ([merge request](gitlab-org/gitlab!66680)) **GitLab Enterprise Edition**
- [Deploy token access for the Dependency Proxy](gitlab-org/gitlab@9a6cee64edba05d571f81fe071fda946969736d4) ([merge request](gitlab-org/gitlab!67552))
- [Remove compare_repo_dropdown feature flag](gitlab-org/gitlab@33c2a0f4a05e1d096c001c2f3c1dc7c683ac568e) ([merge request](gitlab-org/gitlab!67193))
- [Add mutation to change namespace shared runners setting](gitlab-org/gitlab@2bbc69a6d2b519534e4f534618a9683130161139) ([merge request](gitlab-org/gitlab!67256))
- [Add severity_levels into approval_project_rules](gitlab-org/gitlab@ae7afa58f4cfa91919c01fcacad24b142502fed6) ([merge request](gitlab-org/gitlab!67062))
- [Add admin_verify track to in-product marketing emails](gitlab-org/gitlab@67b920db2d46e83201023fdebbdc120dd99511ba) ([merge request](gitlab-org/gitlab!67147))
- [Add instance setting for delayed project deletion](gitlab-org/gitlab@d2c9d6267f2cb55bb0bcea383d2261c75d5536f7) ([merge request](gitlab-org/gitlab!67230)) **GitLab Enterprise Edition**
- [Add Snowplow Tracking to Environment Actions](gitlab-org/gitlab@2d5dc001670c1894bc7190377be8d8ee97d92752) ([merge request](gitlab-org/gitlab!66968))
- [Finalize converting geo_job_artifact_deleted_events](gitlab-org/gitlab@fafde4d21574912c0fbccf2bf7085d82418118c9) ([merge request](gitlab-org/gitlab!66763))
- [Remove feature flag search_sort_issues_by_popularity](gitlab-org/gitlab@4adb461f6a7c8ea2a102a774d0ea053b3a0428f4) ([merge request](gitlab-org/gitlab!67515))
- [Cancel pipelines before deleting](gitlab-org/gitlab@d738b59412b780eca267dee40fe1bd63e513e6bb) ([merge request](gitlab-org/gitlab!67063))
- [Add structured logging to MergeRequestMergeabilityCheckWorker](gitlab-org/gitlab@d971a728f534df518ab74117526d3099db62df0d) ([merge request](gitlab-org/gitlab!67440))
- [Allow immediate deletion of groups](gitlab-org/gitlab@80637ccb22b7e24209c1ef6f7a0832163b89756e) ([merge request](gitlab-org/gitlab!66951)) **GitLab Enterprise Edition**
- [Add application and DB layer validations for flag_type uniqueness](gitlab-org/gitlab@1eb5b25a7ff521a4cb55f872c561a21c4a33b04d) ([merge request](gitlab-org/gitlab!67300)) **GitLab Enterprise Edition**
- [Add pronunciation to GitLab profile page](gitlab-org/gitlab@5e6b224b48f58f7dda8920566ba5fc8c4309aed8) ([merge request](gitlab-org/gitlab!67111))
- [Add trial_short track to in-product marketing emails](gitlab-org/gitlab@f74e5e5369a9b5d307b86b24d1a9bb607eb089b8) ([merge request](gitlab-org/gitlab!66943))
- [Deploy token access for the dependency proxy](gitlab-org/gitlab@b723758c42028c10cba8bde2b6ee04f9bfe59f3d) ([merge request](gitlab-org/gitlab!64363))
- [Generate Debian component files for udeb and source files](gitlab-org/gitlab@4a55b9ff9616844b083db2f4d8e187d40138c43f) ([merge request](gitlab-org/gitlab!65188))
- [Log deprecations to dedicated log file](gitlab-org/gitlab@36be9eca6c23897be2b1f560dbc0e0f4ba25d21a) ([merge request](gitlab-org/gitlab!66815))
- [Add button for reactivating/extending trial](gitlab-org/gitlab@dfe79df4f34fe5c7b7beb91902e9715a10524c36) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/66049)) **GitLab Enterprise Edition**
- [Add secret_detection to security_orchestration_policy JSON schema](gitlab-org/gitlab@a08527c5f4b2ab1501e6aefe5a8209d5bef6c2ea) ([merge request](gitlab-org/gitlab!67124)) **GitLab Enterprise Edition**
- [Add assigned issue and pending todo counts to /users_count API](gitlab-org/gitlab@eb340792858e66823d64857576eb47686c3f8e89) ([merge request](gitlab-org/gitlab!66909))
- [GraphQL: Add sharedRunnersSetting to Group/Namespace](gitlab-org/gitlab@835e72bdcf40ab6693637af3d05895eb4a885452) ([merge request](gitlab-org/gitlab!67022))
- [feat: Add environments survey alert](gitlab-org/gitlab@48f4a30dbd532413b87a7affe6490c17007d39b3) ([merge request](gitlab-org/gitlab!67243))
- [Allow Limitable to use override feature flag](gitlab-org/gitlab@d9d4ac4a194e3ffa0aa2a249b70d18c02105e311) ([merge request](gitlab-org/gitlab!67151))
- [Retain trigger time of alerts](gitlab-org/gitlab@93fe1effc69dadf139311352640e36ed2ce864f3) ([merge request](gitlab-org/gitlab!65635))
- [Add mutation to lock/unlock project paths](gitlab-org/gitlab@bdcf4a8172cfb68fde6e0343c7c367104b969237) ([merge request](gitlab-org/gitlab!66186)) **GitLab Enterprise Edition**
- [Use non-predefined variables inside CI include blocks](gitlab-org/gitlab@7de0bbfe90d802869b2ebf6dfe38302e80c9369e) ([merge request](gitlab-org/gitlab!66852))
- [Allow resetting issue labels](gitlab-org/gitlab@4ff90dab42d538e4723cacfb7541a0af2b1be574) ([merge request](gitlab-org/gitlab!66859))
- [Exposed created_at to billable members API](gitlab-org/gitlab@498e439d65cb8201ddb8d7d73bd55627a7b2f636) ([merge request](gitlab-org/gitlab!67127)) **GitLab Enterprise Edition**
- [Add pagination support for get_tree_entries RPC](gitlab-org/gitlab@d4bf66a7b9d4a9630d903a2bb20b74a7defc8816) ([merge request](gitlab-org/gitlab!66657))
- [Introduce AutoDeleteCronWorker for Environments](gitlab-org/gitlab@355df1117e587c062fabaf4318fa5d04fcc76b66) ([merge request](gitlab-org/gitlab!66732))
- [Enable DAST runner site validation by default](gitlab-org/gitlab@8cbd2c66c1b9905b495e215a5c4da09bd655504a) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/67096)) **GitLab Enterprise Edition**
- [Return signature in InRelease and Release.gpg endpoints](gitlab-org/gitlab@e1d915e397ad4b3eaf43880fe8cf0c012470a0a0) ([merge request](gitlab-org/gitlab!67061))
- [Add pages_file_entries to plan_limits](gitlab-org/gitlab@8924a81387d5fd7b2e2f85698ad721acf8f9911c) ([merge request](gitlab-org/gitlab!64925))
- [Add the compliance framework label to group projects listing](gitlab-org/gitlab@78c8851d4403f878076c698a6b6cc528db019ff3) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/66819)) **GitLab Enterprise Edition**
- [Adds ProjectSetComplianceFramework GraphQL Mutation](gitlab-org/gitlab@a55e3de11bcf1278b199208269d7127eeff4287d) ([merge request](gitlab-org/gitlab!66244)) **GitLab Enterprise Edition**
- [Add timelog summary to time tracking report](gitlab-org/gitlab@b8208723bb27d8f7e35537fb5bd186507fad272a) ([merge request](gitlab-org/gitlab!67006))
- [Plug Debian SignDistributionService in GenerateDistributionService](gitlab-org/gitlab@4457d342ad6acf9b7c12859a847d87184ed2e91e) ([merge request](gitlab-org/gitlab!66907))
- [Add team_short track to in-product marketing emails](gitlab-org/gitlab@6f38ab407df09680d638200843fbd273cc992f2e) ([merge request](gitlab-org/gitlab!66854))
- [Add Mailgun endpoint for receiving permanent failures](gitlab-org/gitlab@0f371ed75c04ffe81ccce6e11105581e3eaeed86) ([merge request](gitlab-org/gitlab!66397))
- [Render CSV parsing errors](gitlab-org/gitlab@91fd2b5d235e3ec1dbe23d23a8aa2e35d9a55d05) ([merge request](gitlab-org/gitlab!66683))
- [Added state column to members table](gitlab-org/gitlab@834bd3d6136b07a2416239582b587ae42bc516e6) ([merge request](gitlab-org/gitlab!66550))
- [Trial onboarding for trial registrations](gitlab-org/gitlab@39a90e95acad44c50f85c85158cb2a442b3d6ecd) ([merge request](gitlab-org/gitlab!66836)) **GitLab Enterprise Edition**
- [Display pending user count when modifying user cap](gitlab-org/gitlab@9ceeb7b5778037e8989962f270cd74541ce19732) ([merge request](gitlab-org/gitlab!66654)) **GitLab Enterprise Edition**
- [Search for epics by iid if search starts with &](gitlab-org/gitlab@5522a5ffb6a0522e11dd684cce5c5e99ae6c24ce) ([merge request](gitlab-org/gitlab!65249)) **GitLab Enterprise Edition**
- [Add PyPI package endpoints for project and group path (escaped)](gitlab-org/gitlab@c9f7a1785ebb5a902edf55e507218275c947266c) ([merge request](gitlab-org/gitlab!66087))
- [Add Debian API endpoint for deb, udeb, ... files](gitlab-org/gitlab@6a576a69c550da0fbb2b7af7a5d6487b4ba369ce) ([merge request](gitlab-org/gitlab!64923))
- [Support setting timelog summary via API](gitlab-org/gitlab@4cedb18ca1f036cc952cdaa680c9419cc8ee8306) ([merge request](gitlab-org/gitlab!66793))
- [Geo: Add verification of snippet repositories](gitlab-org/gitlab@e5d32d05684ec533e6701dd80b3a23d21304498a) ([merge request](gitlab-org/gitlab!66878)) **GitLab Enterprise Edition**
- [Add support for propagation correlation IDs from trusted CIDRs](gitlab-org/gitlab@5e865c2e680203509f2b170dd835d11c0677764e) ([merge request](gitlab-org/gitlab!66715))
- [Debian CRUD group distribution endpoints](gitlab-org/gitlab@c2c871e575763f1977b3429c48382f82792c192a) ([merge request](gitlab-org/gitlab!66188))
- [Added error classes for specific backup rake task](gitlab-org/gitlab@94ab3594ca1a331c9d488462298c10142a376eda) ([merge request](gitlab-org/gitlab!66260))
- [Automatically resync verification failures](gitlab-org/gitlab@c615061fe0dcf0dadb977c0df581b925d142c38d) ([merge request](gitlab-org/gitlab!66851)) **GitLab Enterprise Edition**
- [Add log count of active jobs](gitlab-org/gitlab@ed6b8745c0e816c5f459ef0bf70fe0766cadf4f0) ([merge request](gitlab-org/gitlab!64623))
- [Add saml_provider_id query param to Users API](gitlab-org/gitlab@0e78d90629614d1762079f4aea6b1cf42325064d) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/66167)) **GitLab Enterprise Edition**
- [Add vulnerability_amount column](gitlab-org/gitlab@7c391302180171dd9832842bda2e9b6ad9b3f96b) ([merge request](gitlab-org/gitlab!66673))
- [Add error tracking client key](gitlab-org/gitlab@4eaa6cc66db16684d3e2b58292e9bfccc6e56f09) ([merge request](gitlab-org/gitlab!66466))
- [Add a badge for project invite members](gitlab-org/gitlab@d993263a5fa90fb07092feddd2c6208788b6cfb2) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/66611)) **GitLab Enterprise Edition**
- [Expose security scanners in MR approval rules API](gitlab-org/gitlab@c324301e2144abef01423becbbfaa7afc649f95c) ([merge request](gitlab-org/gitlab!66116)) **GitLab Enterprise Edition**
- [Add overridden_uuid column to security_findings](gitlab-org/gitlab@ce5165d1db875b30cdd92a97e9aa607f14fc380c) ([merge request](gitlab-org/gitlab!66689))
- [Add Jira Connect branches controller](gitlab-org/gitlab@b102fd6743d758000a4b6e45c4dbdb2cfaff7e66) ([merge request](gitlab-org/gitlab!66032))
- [Add signed_file to Debian distributions](gitlab-org/gitlab@28c0435afcabf22019b7e475731fff12ac7c7227) ([merge request](gitlab-org/gitlab!66470))
- [Add new BulkImports endpoint to start new migration](gitlab-org/gitlab@0632ee50bb08dedd78704b46cc88d68a5a2ac64a) ([merge request](gitlab-org/gitlab!66353))
- [Add service to sign Debian distribution](gitlab-org/gitlab@95f1e8572a1d6835bde312518914c63e35788c3a) ([merge request](gitlab-org/gitlab!64926))
- [Implement Scheduling Logic for DAST On-demand Scheduler](gitlab-org/gitlab@ddd59ed419e30b2d849898522bb93880d4300410) ([merge request](gitlab-org/gitlab!65327))
- [Sync vulnerability rules](gitlab-org/gitlab@fbb848e45448bb68d61c2d2454b080fa1e1793fb) ([merge request](gitlab-org/gitlab!66115)) **GitLab Enterprise Edition**
- [Add Fuzz Testing to DevOps Adoption](gitlab-org/gitlab@6b26ed63b3fb2b5c5d23ea9489ee8e655363e026) ([merge request](gitlab-org/gitlab!66446)) **GitLab Enterprise Edition**
- [Removes `mr_collapsed_approval_rules` feature flag](gitlab-org/gitlab@21fb28f1fd1cd7dae9dd5336cab432785f998f49) ([merge request](gitlab-org/gitlab!66457))
- [Add descendantGroups field to Group type](gitlab-org/gitlab@9a5dd5ea4a97344892dfe290c806ea139a9f2d94) ([merge request](gitlab-org/gitlab!65255))
- [Added user_cap_reached? to Group](gitlab-org/gitlab@9e3ab675343a8a133d3db6b5379ba57fd7ba6e3b) ([merge request](gitlab-org/gitlab!66264)) **GitLab Enterprise Edition**
- [Add security scanners column into](gitlab-org/gitlab@ad8618b9d6684de286315aa06a0c0d38e06c5744) ([merge request](gitlab-org/gitlab!66114))
- [Save visited URL to recent searches and update weight token list](gitlab-org/gitlab@94b4363b06a8ec706467905e0e3d77692b8c952e) ([merge request](gitlab-org/gitlab!66361))

### Fixed (137 changes)

- [Resolve layout issues in notes form](gitlab-org/gitlab@d33a507320c68e2b0812c6a750a9651fc6218e91) ([merge request](gitlab-org/gitlab!68414))
- [Set db name when creating connection with new pool size](gitlab-org/gitlab@b15f7229312f5ef3be0e973c37dc6e85934b0ef9) ([merge request](gitlab-org/gitlab!68335))
- [Project reporters can drag cards in group board](gitlab-org/gitlab@3f6610dbfc7a6e0c87947d379bcd4e065d12f83b) ([merge request](gitlab-org/gitlab!68126))
- [Added ability to create assignee list of descendants](gitlab-org/gitlab@8aee0745d70bfbc18456ac14d1dc31524942b317) ([merge request](gitlab-org/gitlab!66016))
- [Merge branch 'dreedy-fix-application_experiment-publish_to_database' into 'master'](gitlab-org/gitlab@2784a285bf1a19e20673793a461d60c1e6b123cd) ([merge request](gitlab-org/gitlab!68389))
- [Run serivce discovery on load balancing configuration](gitlab-org/gitlab@788373a15d4bcc2fffd43e230f5227ad37a7d995) ([merge request](gitlab-org/gitlab!68378))
- [Fix intermittent 'branch not found' errors when pushing creates an MR](gitlab-org/gitlab@8ab5d0dbf082657889a62f4b6868dce87d9e27c7) ([merge request](gitlab-org/gitlab!68362))
- [Fix reference pattern for iterations](gitlab-org/gitlab@4176fa758b7ad7f97d9108cf6687cd92002b2d4a) ([merge request](gitlab-org/gitlab!68350)) **GitLab Enterprise Edition**
- [Include all available groups as import target](gitlab-org/gitlab@6530b9a6ac3a96d8493bf29cc2aa4f8f5146e576) ([merge request](gitlab-org/gitlab!68302))
- [Allow to apply issue inherited templates using URL](gitlab-org/gitlab@02f50c65b0514dce7282cdd49466d361c6f19b4f) ([merge request](gitlab-org/gitlab!67686)) **GitLab Enterprise Edition**
- [Increase spacing between buttons to 8px](gitlab-org/gitlab@0b060a7e62982f7486e77546ffc9a47073010c41) ([merge request](gitlab-org/gitlab!68179))
- [Noop migrations containing faulty SQL regex](gitlab-org/gitlab@4fe9fac7b32dc6c9210aa3f94aaf3385fe180494) ([merge request](gitlab-org/gitlab!68296))
- [Add migration to update ultimate trial plan limits](gitlab-org/gitlab@af185ed0d94666139a4ae523486d79d2d26e7f6b) ([merge request](gitlab-org/gitlab!67703))
- [Fix Security::FindingsFinder to return only the latest findings](gitlab-org/gitlab@38ab2ecef202027ccf6e82d6f854d347d4379b4d) ([merge request](gitlab-org/gitlab!68266)) **GitLab Enterprise Edition**
- [Reset oncall-schedule form on cancel or close](gitlab-org/gitlab@6a27ee3c3ba5916cad4025670eb54224ce9bbbf8) ([merge request](gitlab-org/gitlab!68076)) **GitLab Enterprise Edition**
- [Do not run refresh_member_authorized_projects callback when importing](gitlab-org/gitlab@d44fcf64e17cc996f2dc76cc1139013c984122de) ([merge request](gitlab-org/gitlab!67975))
- [Resolve todo when resolve button is clicked](gitlab-org/gitlab@aad1c72d16bf30668d4d6b4be2b4a4dcf01acafc) ([merge request](gitlab-org/gitlab!67026))
- [Hide notification warning for private comments](gitlab-org/gitlab@28d6e0b713a3f493ecfe7991c39a26bfc7779056) ([merge request](gitlab-org/gitlab!68252))
- [Remove broken "default" storage initialiser](gitlab-org/gitlab@56bea218e8fedada1754228ea343f8e52ec9419f) ([merge request](gitlab-org/gitlab!68096))
- [When ordering epics by title, do so case-insensitively](gitlab-org/gitlab@26c06b42142868e44e67203a682742ae2cc6df40) ([merge request](gitlab-org/gitlab!67125)) **GitLab Enterprise Edition**
- [Fix spacing between dropdowns in policy editor](gitlab-org/gitlab@e92004104642a1531abddb2070300b45b30b53d4) ([merge request](gitlab-org/gitlab!68205)) **GitLab Enterprise Edition**
- [Fix: Container repository geo syncs stuck in started state](gitlab-org/gitlab@9361b2bf5a2b20dfb9936c5bf409c6ad145c06fd) ([merge request](gitlab-org/gitlab!68080)) **GitLab Enterprise Edition**
- [Use sub-batches in BackfillIntegrationsTypeNew background migration](gitlab-org/gitlab@82c41eece6e385796720d6b655e0f2faac7c856c) ([merge request](gitlab-org/gitlab!67971))
- [Always use the newest commit in a branch for push events](gitlab-org/gitlab@694ca4e437c7b83eb6bd16d304342b882c716d1d) ([merge request](gitlab-org/gitlab!68168))
- [Fix mirror repo table buttons in _mirror_repos.html.haml](gitlab-org/gitlab@6a5afc3afb77d2466552ea51ef18ec144f1cb6ef) ([merge request](gitlab-org/gitlab!68179))
- [Optimize #latest_successful_for_refs method](gitlab-org/gitlab@44fe828ed82d49aa35651a8ff676188955ef7474) ([merge request](gitlab-org/gitlab!67315))
- [Github Importer: Ensure to fail and log imports on exceptions](gitlab-org/gitlab@752512e0ddd5b39bfd45d7788d0e8adbc36bf7c6) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/67454))
- [Delete backups/tmp after restore](gitlab-org/gitlab@70c0e8b5dae6d5bb46c1ca3d07a7b4b3b2abb7ec) ([merge request](gitlab-org/gitlab!67741))
- [Enable the feature flag by default](gitlab-org/gitlab@ce3fff9df470f14afd773fcee60c650fbac006d4) ([merge request](gitlab-org/gitlab!67972))
- [Fix due date tooltip on milestone in sidebar](gitlab-org/gitlab@59a6f8df8a69490c73303ebc51ec185ff7a5bf64) ([merge request](gitlab-org/gitlab!68130))
- [Add Conan to filters](gitlab-org/gitlab@09e1b50f3f72767d00d48a7ab36a5d5938c20edf) ([merge request](gitlab-org/gitlab!67884)) **GitLab Enterprise Edition**
- [Move audit events promo illustration and update text](gitlab-org/gitlab@8292187a159fb958d2299333f4ea9f67cabdfe50) ([merge request](gitlab-org/gitlab!67873)) **GitLab Enterprise Edition**
- [Delete private subgroups todos when removing member](gitlab-org/gitlab@f4602b494712e7599f626c8398fcbafd86d21722) ([merge request](gitlab-org/gitlab!68094)) **GitLab Enterprise Edition**
- [fix: Regenerate locale/gitlab.pot](gitlab-org/gitlab@a945b87c443c6ca8bca0087325ad69375b5006cb) ([merge request](gitlab-org/gitlab!67243))
- [Remove class to fix dark mode readability](gitlab-org/gitlab@d85dee9ff5da493fa08dcc1b9906169e7180ba08) ([merge request](gitlab-org/gitlab!68057))
- [Fix adding or updating vulnerability history comments](gitlab-org/gitlab@e0919ad30e9c3d05c07f6dc126a1446dd4bab9d7) ([merge request](gitlab-org/gitlab!68053))
- [checks: Fix combinatorial explosion in `#commits_for()`](gitlab-org/gitlab@755ed5e360a3e844e69f0ee408e6fcf5a992a6b2) ([merge request](gitlab-org/gitlab!67827))
- [Fix code block input rules](gitlab-org/gitlab@550f64c1c4e5db9da117e92e452f5a2b3e45350f) ([merge request](gitlab-org/gitlab!67980))
- [Fix N+1 database queries in pipeline databuilder](gitlab-org/gitlab@042dd0904c747c7b6e3d1b329fdc57f73fe59567) ([merge request](gitlab-org/gitlab!67238))
- [Ensure service discovery runs before results are used](gitlab-org/gitlab@7f407002f099361b71cfd847c29076bee387eba3) ([merge request](gitlab-org/gitlab!67899))
- [fix: Update locale/gitlab.pot](gitlab-org/gitlab@8d43b9a6ff30525379efc1fb6f71ac069e4010bf) ([merge request](gitlab-org/gitlab!67243))
- [Fix basic search full count load](gitlab-org/gitlab@a5b71685514df851fd4adfa3a5c30997edcd9675) ([merge request](gitlab-org/gitlab!67959))
- [Update Pikaday colors for dark mode](gitlab-org/gitlab@7303e099b0d55734c494d35520572925fb81a5a6) ([merge request](gitlab-org/gitlab!65247))
- [copy: Clarify gift card currency in copy](gitlab-org/gitlab@d3cac3cb6e9c63eeeaa5b5ec61ff2b6ef573df64) ([merge request](gitlab-org/gitlab!67243))
- [Fix connection search path being reset](gitlab-org/gitlab@2b4e0ec8318c1caf684307796fc1b40f4f127a29) ([merge request](gitlab-org/gitlab!67725))
- [Fix policy_editor environment picker](gitlab-org/gitlab@63f2617f946596832484ed429b22facab8e4d2ad) ([merge request](gitlab-org/gitlab!67888)) **GitLab Enterprise Edition**
- [Hide reference path on project board cards](gitlab-org/gitlab@745463582a2b65c3b528161c92fe814110f1ed85) ([merge request](gitlab-org/gitlab!67713))
- [Restrict Runner.locked to project runners](gitlab-org/gitlab@f13ac9372b8a652b4aa890b2eca60e5820c210ca) ([merge request](gitlab-org/gitlab!62105))
- [Refactor the nuget package updater service](gitlab-org/gitlab@1df93ae5b05ec5b65af0dc423908204f779257ae) ([merge request](gitlab-org/gitlab!66728))
- [Fix UI of project topics popover](gitlab-org/gitlab@a69856f69022fce287dde6eeb76f9ca9f2a838e2) ([merge request](gitlab-org/gitlab!67825))
- [Handle some WebHookService errors](gitlab-org/gitlab@8273de31461df70dc4de308b6d7e0db8f9ab3868) ([merge request](gitlab-org/gitlab!67555))
- [Fix group runner sort dropdown](gitlab-org/gitlab@6df5fb1067d64ea5236542213dde7d593477ad49) ([merge request](gitlab-org/gitlab!67681))
- [Get branches from rules using rule_index for security policy](gitlab-org/gitlab@f8ea455f77d73a40e91bc780f4380ce3a89983c5) ([merge request](gitlab-org/gitlab!67607)) **GitLab Enterprise Edition**
- [Fix environments regex for etag restful](gitlab-org/gitlab@b045ab5d101806fd85c4c7b7bd9961cbdf67aa57) ([merge request](gitlab-org/gitlab!67708))
- [Fix feature flag check for security policy project](gitlab-org/gitlab@4b5da3c24d790908091f6b6c22b1611adf97803c) ([merge request](gitlab-org/gitlab!67654)) **GitLab Enterprise Edition**
- [Fix punctuation on help line](gitlab-org/gitlab@2ab0ee394e66aadd8858ae06967c173f2901d4be) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/67742)) **GitLab Enterprise Edition**
- [Fix pipeline status layout in pipeline editor](gitlab-org/gitlab@8b93d5e1795d44a97f4e3748e154cbb4e2db47a2) ([merge request](gitlab-org/gitlab!67709))
- [Fix the npm package already taken validator](gitlab-org/gitlab@d32556e93a4364301df11cf885c55cab9b23778f) ([merge request](gitlab-org/gitlab!67107))
- [Ensure SAML Group Sync runs anytime SAML Group Links exist](gitlab-org/gitlab@6da2725d6c512535da26e8dd3bf033aed41e86df) ([merge request](gitlab-org/gitlab!67633)) **GitLab Enterprise Edition**
- [Delete test cases when migrating project to a free group](gitlab-org/gitlab@9dd8f87aa8f8bc74d55ff3e67b5b4d0dcd3ae93a) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/67374)) **GitLab Enterprise Edition**
- [Conditionally render create project button](gitlab-org/gitlab@e2be8c827b71e6e88936810fa59d78563029d42a) ([merge request](gitlab-org/gitlab!64196))
- [checks: Fix mismatch in `#new_commits()` signature](gitlab-org/gitlab@3b934ec025da7c194d6c99d1d2499532a74ff52a) ([merge request](gitlab-org/gitlab!67581))
- [Use correct fingerprint values in recalculate finding UUIDs migration](gitlab-org/gitlab@84a66d666f3e87abff30752cef566a5837604b6e) ([merge request](gitlab-org/gitlab!67578)) **GitLab Enterprise Edition**
- [Fix displaying the actual plan name on the billings page](gitlab-org/gitlab@6acefc493abf85ecec6cca31e7d0fda6ede755c3) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/67572)) **GitLab Enterprise Edition**
- [Refactor stop environments service](gitlab-org/gitlab@868d37615865f11771fd384c6c9d121af2fcb670) ([merge request](gitlab-org/gitlab!67485))
- [Fix `StoreReportService` by falling back to find by location approach](gitlab-org/gitlab@5274e118980235d36e323959267fa1f59d6f3c03) ([merge request](gitlab-org/gitlab!67568)) **GitLab Enterprise Edition**
- [Fix preloading unrelated associations for CommitStatus](gitlab-org/gitlab@1bcd7c0ea5c61fba8a7bae73f5834971c4207518) ([merge request](gitlab-org/gitlab!67439))
- [Accept all 2xx HTTP responses when testing the Datadog integration](gitlab-org/gitlab@6f113615d7db7b154237b6e3c7898d4243d867a2) ([merge request](gitlab-org/gitlab!67524))
- [Refactor init logic of merge request options on project settings page](gitlab-org/gitlab@5046693207e3d49052a0c49c7cd9b155aaba03aa) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/67334))
- [Enable the FF ci_modified_paths_of_external_prs](gitlab-org/gitlab@bbe6048a6e28764fcb731f14a4731ae583fa12f3) ([merge request](gitlab-org/gitlab!67458))
- [Code-Quality.gitlab-ci.yml: automatically clean-up docker container](gitlab-org/gitlab@65fec3a4316d294fcfe9f0efd4d7faf81ea926ce) ([merge request](gitlab-org/gitlab!66910))
- [Update min selectable number for subscription buy process](gitlab-org/gitlab@ac7b25f3b4310945dd8ee72f8681a1a6b30070a2) ([merge request](gitlab-org/gitlab!67430)) **GitLab Enterprise Edition**
- [Make `DbCleaner` and `BeforeAllAdapter` to support many connections](gitlab-org/gitlab@2625e7a41ab0d22c3df2f9937cec13fc000737e0) ([merge request](gitlab-org/gitlab!67330))
- [feat: Add one more i18n translation string](gitlab-org/gitlab@58edbc171d217caeee917e3cee22ee6e8aa84abb) ([merge request](gitlab-org/gitlab!67243))
- [Fix double escaping when clicking WebIDE button](gitlab-org/gitlab@509e0a6251d745fcc63b8202e0eb5749fb1c5939) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/67360))
- [Fix some button border colors in dark mode](gitlab-org/gitlab@72645ee3e3331be014b8c8ab7ad211b96e7851ee) ([merge request](gitlab-org/gitlab!67389))
- [Reschedule `latest_pipeline_id` population with all artifact types](gitlab-org/gitlab@f22009e14da925a1f031211c9529e8986e2200fb) ([merge request](gitlab-org/gitlab!67163))
- [feat: Fix environments survey i18n strings](gitlab-org/gitlab@31bbd796e1e617e1507295af7aa1fae9e4a82c5b) ([merge request](gitlab-org/gitlab!67243))
- [Set `latest_pipeline_id` and mark project as vulnerable first](gitlab-org/gitlab@99055f4f157e39f13c47d54cd52eedb23886b817) ([merge request](gitlab-org/gitlab!67165)) **GitLab Enterprise Edition**
- [Fix assignee avatar tooltip w special char names](gitlab-org/gitlab@b1118c62131ba162e9037608fe6332f80f86672e) ([merge request](gitlab-org/gitlab!67250))
- [Geo Node Form Regression - Realitive URLs broken](gitlab-org/gitlab@99a11efdf7cfc49fed7fddedfbcd835fc83d5d6b) ([merge request](gitlab-org/gitlab!67253)) **GitLab Enterprise Edition**
- [Fix Stickiness to Match Unleash API](gitlab-org/gitlab@228279665f2711fa819c56edcb1d805554ae7634) ([merge request](gitlab-org/gitlab!66676))
- [Use new and old paths instead of just the new path for diff batching](gitlab-org/gitlab@89a8c4f937cd74fe05c87072b74599a86541a11f) ([merge request](gitlab-org/gitlab!66873))
- [Continue code quality widget polling while parsing](gitlab-org/gitlab@0ba54b5fa0762755d7d5914e3b02fe5c0ea19ea2) ([merge request](gitlab-org/gitlab!67176))
- [Fix empty recursive query for base_and_ancestors](gitlab-org/gitlab@a65e45494b41dfbc0710c88a6dc7c8f83d7cc3de) ([merge request](gitlab-org/gitlab!67182))
- [fix: Atom feed for commit list should point to path](gitlab-org/gitlab@ef0a744cbd61e241d89b88fc2981f22da1d63362) ([merge request](gitlab-org/gitlab!65599))
- [Add missing `Delete user and contributions` action in admin user view](gitlab-org/gitlab@8cb36fada3407a9ed901b631a11ed7ec7cef1793) ([merge request](gitlab-org/gitlab!67161))
- [Replace the success btn with the confirm button](gitlab-org/gitlab@aa65e97fb8bdfad48fe93f7f4bd91f1fc140452d) ([merge request](gitlab-org/gitlab!67148))
- [Run sync BuildFinishedWorker operations always before](gitlab-org/gitlab@99a695e1cb25b2b77c54b267f98fcefdc213e831) ([merge request](gitlab-org/gitlab!67117)) **GitLab Enterprise Edition**
- [Prevent weightSum to be updated on child epic fetch](gitlab-org/gitlab@9b6b548be76840616604657f09804bce934aa978) ([merge request](gitlab-org/gitlab!67116)) **GitLab Enterprise Edition**
- [Fix Review App Multiple Deletion API payload](gitlab-org/gitlab@0bad1c716da56201307c6eacd5e142a09a6a99f0) ([merge request](gitlab-org/gitlab!67102))
- [Fix redirect loop when relative url root is blank](gitlab-org/gitlab@d586b5b796c5ce94c4db7e0a9d6991e4b3b008f7) ([merge request](gitlab-org/gitlab!67094))
- [Fix backup.rake from trying to tar non-existent directories](gitlab-org/gitlab@042a203f45ef9ac957bb4863223b88273f4314e0) ([merge request](gitlab-org/gitlab!67090))
- [Fix `Ci::Artifactable#selective_sync_scope` cross-join DBs](gitlab-org/gitlab@6ac86e5781a191bc97e2eb94bafd604d745318c6) ([merge request](gitlab-org/gitlab!66703)) **GitLab Enterprise Edition**
- [Use parent integration settings when reverting from custom settings](gitlab-org/gitlab@c61dd33e9e1d8c6dcbd7b252820c8e6feae414df) ([merge request](gitlab-org/gitlab!66663))
- [Adjust documentation paths](gitlab-org/gitlab@207328a036b6b3639edde60f1e423baafe607568) ([merge request](gitlab-org/gitlab!67037))
- [Rescue stuck resource groups](gitlab-org/gitlab@5468378c847f9f33baa7770ba2a45684fe745071) ([merge request](gitlab-org/gitlab!66729))
- [Decode square brackets with "queryToObject"](gitlab-org/gitlab@957390387d54eb7a8fc27825972949b919426d3f) ([merge request](gitlab-org/gitlab!66846))
- [Advanced Search should index trials regardless of seats](gitlab-org/gitlab@1983c5ffabf2ca9aaad8bd6828ddf218ae904ccb) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/66665)) **GitLab Enterprise Edition**
- [Validate timezone presence on schedule creation form](gitlab-org/gitlab@ae06e067657b6822185f3e525314d1e8f674d2eb) ([merge request](gitlab-org/gitlab!66946)) **GitLab Enterprise Edition**
- [Update timeout help page URLs in job sidebar](gitlab-org/gitlab@3fefa96f21f535f8beac9224da88baa232ab2716) ([merge request](gitlab-org/gitlab!63992))
- [Fix dates being incorrectly set on epic creation](gitlab-org/gitlab@d2f0b0a7ae36c62540ebf631d2bb2619bc7fcf2c) ([merge request](gitlab-org/gitlab!66809)) **GitLab Enterprise Edition**
- [Fix contribution analytics MR closed count param](gitlab-org/gitlab@b8c3613c46d707bdbf1437f9bf7060e8660e6edc) ([merge request](gitlab-org/gitlab!66805)) **GitLab Enterprise Edition**
- [Fix alert positioning and content for oncall schedules page](gitlab-org/gitlab@4b228dce42ca41b802aaef26fdc5f1a534da92cf) ([merge request](gitlab-org/gitlab!66858)) **GitLab Enterprise Edition**
- [Delete pipeline subscriptions when migrating project to a free group](gitlab-org/gitlab@67223c66bd62a70acfa62e09315e00ecbc78d8f5) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/66695)) **GitLab Enterprise Edition**
- [Remove trial suffix from plan titles that include it](gitlab-org/gitlab@739805449ba860e34b3129b5523bf08b14e1f969) ([merge request](gitlab-org/gitlab!66578)) **GitLab Enterprise Edition**
- [Fix "Remove" button in Slack app integration](gitlab-org/gitlab@23e700d56c86c08db55496a0c5de2915c16e213d) ([merge request](gitlab-org/gitlab!66506))
- [Fix :admin_compliance_framework to only be true if the user is an owner](gitlab-org/gitlab@bbcc3fccfdaec47c07214b2d258d3df169419a53) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/66745)) **GitLab Enterprise Edition**
- [Fix SAML SSO login redirects not working](gitlab-org/gitlab@6e9734208d3a0c59ab38d1b8fee43031b8e8fa6e) ([merge request](gitlab-org/gitlab!66791)) **GitLab Enterprise Edition**
- [Fix Error 500 viewing pipelines with invalid UTF-8 data](gitlab-org/gitlab@e804c0090501fb4c92e067f16f962018efef1f26) ([merge request](gitlab-org/gitlab!66686))
- [Map jira users for server version by 'key' attribute](gitlab-org/gitlab@6f8b19797e3c566ebb2327c8c52fec0215edb689) ([merge request](gitlab-org/gitlab!66670))
- [Fix missing CSS variables in Darkmode](gitlab-org/gitlab@5609901ed087928ec7ea734472ace7a2ce3df074) ([merge request](gitlab-org/gitlab!66640))
- [Fix whats new top positioning with system-header and performance-bar](gitlab-org/gitlab@ad34170b6b0f805c011982b7771196ab0c104be4) ([merge request](gitlab-org/gitlab!66660))
- [GithubImporter: match user by external id only from github.com](gitlab-org/gitlab@26560527f3f0483c4c232fa7c27e66ee788c2340) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/66387))
- [Hide edit severity btn for users without permissions](gitlab-org/gitlab@bc2a389988695fbf213d8288011e598458d4feb0) ([merge request](gitlab-org/gitlab!66642))
- [Fix group level vulnerability permissions](gitlab-org/gitlab@35634bd2d585c5dd1b6f702224679e595b9d059c) ([merge request](gitlab-org/gitlab!66312)) **GitLab Enterprise Edition**
- [Ignore searching in full path in GroupsFinder](gitlab-org/gitlab@308b908f087969127e63525bdfaf0fd73e79b3bc) ([merge request](gitlab-org/gitlab!66431))
- [Fix 400 errors not being logged in multipart middleware](gitlab-org/gitlab@25a7daed2336f0ce72601f7d58cc5876813fff46) ([merge request](gitlab-org/gitlab!66595))
- [Fix subgroup epic path on epic boards](gitlab-org/gitlab@882e5ff17d5b11314a9b7fc5eb7e359462370851) ([merge request](gitlab-org/gitlab!66587)) **GitLab Enterprise Edition**
- [Remove extra margin above issue navigation tabs](gitlab-org/gitlab@069959aca43ae654d4aa7c380e5dc0e23459d7e8) ([merge request](gitlab-org/gitlab!60824))
- [Activate correct nav item for Admin::LicensesController](gitlab-org/gitlab@8055de728315842c5bb5d79204e24a67f2e7ed12) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/66051)) **GitLab Enterprise Edition**
- [Prevent terms from being created if blank](gitlab-org/gitlab@93a88ddb8aa26bd7aac9f8ee0fa56ac6ddcff768) ([merge request](gitlab-org/gitlab!66437))
- [Delete PATs when transfering project to a free group](gitlab-org/gitlab@6e311075dc7f222e1af24b7f689e7eae3f7c0fe2) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/65803)) **GitLab Enterprise Edition**
- [Fix epic tab dropdown menu overlay on mobile](gitlab-org/gitlab@3a442ae6b69e9b30ea7d26607ca7febf0832701b) ([merge request](gitlab-org/gitlab!66498)) **GitLab Enterprise Edition**
- [Use the correct text for tooltip](gitlab-org/gitlab@e770d5dcafa74bb6dbabad2dfc53922a7001afd5) ([merge request](gitlab-org/gitlab!66454))
- [Fix audit events empty space](gitlab-org/gitlab@27f000537f2a087441617cb2aac3d98649af6ce6) ([merge request](gitlab-org/gitlab!52590)) **GitLab Enterprise Edition**
- [Extend basic authentication detection for rate limiting](gitlab-org/gitlab@dcf8011ae3d29a6d10eb9169d0a79812e309604c) ([merge request](gitlab-org/gitlab!63287))
- [Fix labels dropdown causing form submission](gitlab-org/gitlab@cf104525ed49cb9bc4fa0e8a9dd810be7c669868) ([merge request](gitlab-org/gitlab!66435))
- [Fix: Sidekiq workers delete each other's metrics](gitlab-org/gitlab@52edbc6e312c826c5b47f5cf65d60adee770b031) ([merge request](gitlab-org/gitlab!66432))
- [Drop invalid UTF-8 when displaying in job logs](gitlab-org/gitlab@c481f5a64640cf2f08ca5315a6b9fae1f8736806) ([merge request](gitlab-org/gitlab!66423))
- [Fix spam checking to consider updater of issue instead of author](gitlab-org/gitlab@427224db3ee6c98267b39f4cf2ed49f2060d0e6e) ([merge request](gitlab-org/gitlab!66408))
- [Return error when moving issues between not authorized lists](gitlab-org/gitlab@f2aa6c9247c43c04fc4c994b58f82cfa083e9837) ([merge request](gitlab-org/gitlab!66101))
- [Look up SSH keys by SHA256 fingerprint, not MD5 fingerprint](gitlab-org/gitlab@1428e0e4e087b2e9b8a2250eca5d982d3b984e8e) ([merge request](gitlab-org/gitlab!66371))
- [Skip already downloaded LFS objects in mirror updates](gitlab-org/gitlab@36ad365c4779f9e7ceb24bd2a6b8adbef6bc393c) ([merge request](gitlab-org/gitlab!66340))
- [Bump gitlab-omniauth-openid-connect to v0.8.0](gitlab-org/gitlab@89a28e5b42c119cc1c929ec8aff0b0e4d51ae08c) ([merge request](gitlab-org/gitlab!65782))
- [Better links on the subscription details page](gitlab-org/gitlab@92328777180b62a546b06e921f8a5a3bcdf7025c) ([merge request](gitlab-org/gitlab!66319)) **GitLab Enterprise Edition**
- [Allow group bot to http authenticate](gitlab-org/gitlab@a33ec9fe408eae176eabdc571ccfb77ed608bdde) ([merge request](gitlab-org/gitlab!65788))

### Changed (117 changes)

- [Update create merge request button on last push event](gitlab-org/gitlab@72ad366f7e8e6c9af33df5a804f72727300505fb) ([merge request](gitlab-org/gitlab!63103))
- [Deprecate Secure user scan metrics](gitlab-org/gitlab@c4ae56bccaefc7bd43c38284df671be7268eb987) ([merge request](gitlab-org/gitlab!67738)) **GitLab Enterprise Edition**
- [Move sast latest template to stable](gitlab-org/gitlab@b0f2ee726da6fb3008829273ddc8cbe613220df3) ([merge request](gitlab-org/gitlab!68429))
- [Migrate epic sidebar todo button to widget](gitlab-org/gitlab@455b0ca188261b3b958aaaf0c5706aa35678b179) ([merge request](gitlab-org/gitlab!68325)) **GitLab Enterprise Edition**
- [Remove optional languge from Compliance framework label](gitlab-org/gitlab@0b309a01d512b9e8e80cfc6f80d09bf182d41ec1) ([merge request](gitlab-org/gitlab!68304))
- [Add empty artifacts message](gitlab-org/gitlab@dd81c5735070c4c62250bb8d7fcde8afdf6d045b) ([merge request](gitlab-org/gitlab!68166))
- [Flatten CI config rules](gitlab-org/gitlab@0b8c81b80ac547ef4e1eca25e101e5c23cc18322) ([merge request](gitlab-org/gitlab!67922))
- [Provide more information in design version selector](gitlab-org/gitlab@0328208f54812ca37ed9d1f6f922f1458aa435d0) ([merge request](gitlab-org/gitlab!67844))
- [Set immutable results to true](gitlab-org/gitlab@e1c1ff7531c0901243bb4a259e813b7bb8ab9d93) ([merge request](gitlab-org/gitlab!68265))
- [Renames the Base terraform template jobs for better scaling](gitlab-org/gitlab@133c2c15a860e78c07f482eb72576d8172ec3436) ([merge request](gitlab-org/gitlab!67719)) **GitLab Enterprise Edition**
- [Remove CI builds for test and staging stages in VSA](gitlab-org/gitlab@755fdd441370d8e18482f7b5dd6a23a6c8325ae4) ([merge request](gitlab-org/gitlab!68000))
- [Update Auto DevOps' auto-deploy-image to v2.12.0](gitlab-org/gitlab@c1a4dbaf97763326a2f65a0603316383ee25dda5) ([merge request](gitlab-org/gitlab!68103))
- [Remove protocol from Dependency Proxy UI](gitlab-org/gitlab@c4120fb1988fe7ae0576bc124f84eb774453864b) ([merge request](gitlab-org/gitlab!68099))
- [Replace plain text application secret with copy button](gitlab-org/gitlab@7953fb39fd0a356f5ca557695aa5a944d7bb4ee3) ([merge request](gitlab-org/gitlab!67453))
- [Improve button layout](gitlab-org/gitlab@249edf5117ee7b9807a0b39ca86f11359dfefaf7) ([merge request](gitlab-org/gitlab!68074))
- [Open addon purchase in the same window](gitlab-org/gitlab@facf1d48951a98b277d4ecc1ac1575485dd5e827) ([merge request](gitlab-org/gitlab!68009)) **GitLab Enterprise Edition**
- [Remove efficient_counter_attribute flag](gitlab-org/gitlab@9118e2bc181855accdede835fd7ee7de22a3679b) ([merge request](gitlab-org/gitlab!68056))
- [Updated message on DevOps Adoption Report](gitlab-org/gitlab@cf05575659cc1aa29048fa7dc2b25254340a1c27) ([merge request](gitlab-org/gitlab!68034)) **GitLab Enterprise Edition**
- [Move issue_type enum to WorkItem::Type base_type](gitlab-org/gitlab@cfd2c0d16cf82b1176aa29e712ae23b90f653652) ([merge request](gitlab-org/gitlab!67434))
- [Add group value stream metrics UI to project VSA](gitlab-org/gitlab@5a549aad8eecd25be2d7dff7d984e25af495c02c) ([merge request](gitlab-org/gitlab!66835))
- [Count epics against issue creation rate limit](gitlab-org/gitlab@2849252226dc08971915b10b87e7995509a55aa6) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/67179)) **GitLab Enterprise Edition**
- [Migrate Markdown Editor toolbar buttons to GlButton](gitlab-org/gitlab@4bf3cc6e0ab8ae26ab00f1d753d14b3625e7e200) ([merge request](gitlab-org/gitlab!67872))
- [Change date time formatting for corpus managment](gitlab-org/gitlab@8b897aca8323a4fdad053b0fcfa15cdb349f6d16) ([merge request](gitlab-org/gitlab!66947))
- [Global Search - Add spacing/border to code results](gitlab-org/gitlab@a9e194a03817ff25c19bb54ea85d3ad247a4443c) ([merge request](gitlab-org/gitlab!67548))
- [Standarize board column highlight style](gitlab-org/gitlab@fe023377603c70f45c44c2b8beeab2f9ef91c9fd) ([merge request](gitlab-org/gitlab!67817))
- [Added linked pipelines to commit](gitlab-org/gitlab@a116a7509ea394b47de27c92dbc6378e2613dd3b) ([merge request](gitlab-org/gitlab!66564)) **GitLab Enterprise Edition**
- [Update nothing-here-block to utilize Pajamas spacing scale](gitlab-org/gitlab@df607786c9c0870c5394171b7ca0efdd90f1791a) ([merge request](gitlab-org/gitlab!67893))
- [Show due date in gray when issue is closed in issues list](gitlab-org/gitlab@d4c66ab0d1f3bab72956dfdd117cb09b618e2e64) ([merge request](gitlab-org/gitlab!67874))
- [Refactor the Ci::Minutes::Additional pack service](gitlab-org/gitlab@3aa0402f9cd0d1cef845da6857b7583fe0d967d7) ([merge request](gitlab-org/gitlab!67513)) **GitLab Enterprise Edition**
- [Enable ci_skip_before_parsing_yaml by default](gitlab-org/gitlab@511f4c7133556548eb7efef185b626832a0244a4) ([merge request](gitlab-org/gitlab!67839))
- [Added cloneDeep to prevent mutating cache](gitlab-org/gitlab@0dfe7d745f1f6f64189217725cfaf25e38772085) ([merge request](gitlab-org/gitlab!67762))
- [Don't show due date in red on epic related issues if issue is closed](gitlab-org/gitlab@debe45db3fab5f04786f5e3f7ae42581ee32b006) ([merge request](gitlab-org/gitlab!67492))
- [Deprecate build trace sections tables by renaming](gitlab-org/gitlab@612ebc64a6ad2689226b75e80f405a81714015d2) ([merge request](gitlab-org/gitlab!67618))
- [Return API error when inviting restricted email](gitlab-org/gitlab@22d33f610962a60139ed4502ae4a10ffe2b9fe25) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/64807)) **GitLab Enterprise Edition**
- [Migrate md header buttons to gl-buttons](gitlab-org/gitlab@ea2677962494a278899b25c01992816c5e05db70) ([merge request](gitlab-org/gitlab!67058))
- [Removed dependency on $ from the highlighter](gitlab-org/gitlab@21e1291645007dd8f3cf2d7d683a786bafebee07) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/67771))
- [Show tax line even when tax has zero amount](gitlab-org/gitlab@1fa181bdc0ebf9bc1ff549302e139a758df8061c) ([merge request](gitlab-org/gitlab!67479)) **GitLab Enterprise Edition**
- [Update design management wording in activity feed](gitlab-org/gitlab@b8e97f970b3fc7f4910a13d904298dd902bc4983) ([merge request](gitlab-org/gitlab!67599))
- [Revert Dependency Proxy permission](gitlab-org/gitlab@7dc1c46c26424c3f534f20a64b02a75bee5c82ea) ([merge request](gitlab-org/gitlab!67696))
- [Placeholder for "Number of employees" in trial](gitlab-org/gitlab@162a68a1edd0c31292bc8e854750760fab8aac85) ([merge request](gitlab-org/gitlab!67688)) **GitLab Enterprise Edition**
- [Allow 10% overage for true-ups when uploading a license](gitlab-org/gitlab@62d53a437d4caf5aba8862c482dfdb4c80eaaa25) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/67508)) **GitLab Enterprise Edition**
- [Prepare On-Demand DAST for CI sharding initiative](gitlab-org/gitlab@63777dad18a270b5816b6eb5ddd8a8d2d54635d2) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/66709))
- [Move DevOps Score callout to Vue](gitlab-org/gitlab@da1decdf345504589caa6b0495808aabd5bf5760) ([merge request](gitlab-org/gitlab!67482))
- [Change Evidence Supporting Messages to array](gitlab-org/gitlab@0a29032709474631ce6a95c3e09eb2f769df0ba5) ([merge request](gitlab-org/gitlab!67620)) **GitLab Enterprise Edition**
- [Remove feature flag](gitlab-org/gitlab@7b4d27b032a8d4b37634d4fd4f9b5a7613213a64) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/65473))
- [Make `ci_structure.sql` to be equal](gitlab-org/gitlab@260c1406999c6494abe3f120f31817b5d4cb48c7) ([merge request](gitlab-org/gitlab!67433))
- [Add deployment_id to deployment payloads](gitlab-org/gitlab@def00feaeb7f84026c17f18ed6ddb63d4470cbbf) ([merge request](gitlab-org/gitlab!67577))
- [Allow downloading archives using PRIVATE-TOKEN](gitlab-org/gitlab@0ed8b60830ceea4c1bf61acabfb39882386c0926) ([merge request](gitlab-org/gitlab!67470))
- [Global Search - Track top nav searches](gitlab-org/gitlab@8795067b6f6445c34cc029301816f0ea40830a14) ([merge request](gitlab-org/gitlab!67187))
- [Allow licenses with a 10% overage of users for renewals](gitlab-org/gitlab@df904001810d236f3707dcb2008b57e634b23489) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/67507)) **GitLab Enterprise Edition**
- [Render base path error based on report status](gitlab-org/gitlab@0c9b80900b15aff49b9d56859b49201d35135d86) ([merge request](gitlab-org/gitlab!67370))
- [Backfill `type_new` column on integrations](gitlab-org/gitlab@b03e5680586ab456e51cbadad85a2e9f65cffedc) ([merge request](gitlab-org/gitlab!66928))
- [Configure Elasticsearch Ruby client without retry by default](gitlab-org/gitlab@1b7c3ff7be6f5607a26d023f63cd51c7efa75e83) ([merge request](gitlab-org/gitlab!67273)) **GitLab Enterprise Edition**
- [Update copy in account recovery settings global alert](gitlab-org/gitlab@f30bd5cd42b8bb75698cb1679cc39114366df819) ([merge request](gitlab-org/gitlab!66693))
- [Allow setting of container registry visibility in project settings UI](gitlab-org/gitlab@b733c4c0f3b603a3fac1d166eb4e022b12cadc8f) ([merge request](gitlab-org/gitlab!55079))
- [Add Gitlab::GithubImport::Logger with default values](gitlab-org/gitlab@394d44a22c96f4443d1c8bd33255ba97d4d7e897) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/65968))
- [Expose iid in the pipelines entity](gitlab-org/gitlab@6ec7689cee6ae2d0c58abba7eaf808dd1875e4e6) ([merge request](gitlab-org/gitlab!67365))
- [Added a hack to set labels](gitlab-org/gitlab@aa14b441f7b443e2389235e66ff2fd70b78e2aa6) ([merge request](gitlab-org/gitlab!67322))
- [Update terms of service docs and UI text](gitlab-org/gitlab@45d1020ef7bddd1bb268da83caaaff9848126023) ([merge request](gitlab-org/gitlab!67002))
- [Allow usage of severity quickaction on create](gitlab-org/gitlab@a503a45625d1f819ebd57be31e55093a2f901b40) ([merge request](gitlab-org/gitlab!67380))
- [Implement JWT for customers-dot proxy](gitlab-org/gitlab@68d9fb11446cbfe156a8ac437d99ea6ef9c2e510) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/65204))
- [Use 'branch' icon instead of 'fork'](gitlab-org/gitlab@a19a6cb658c0a9938e09ef500834dd7f7657899d) ([merge request](gitlab-org/gitlab!67087))
- [Remove dataBackground property from chart](gitlab-org/gitlab@6b8084d3992ff9f6797250aa6f0325201aa9df7f) ([merge request](gitlab-org/gitlab!67323))
- [Update UI help links](gitlab-org/gitlab@72b04e98c294853144c4a74b92bfbb8433c94470) ([merge request](gitlab-org/gitlab!67164)) **GitLab Enterprise Edition**
- [Update runner description text](gitlab-org/gitlab@7644bdaab8eeee8727a449a9eaaec61e7c6f4e5f) ([merge request](gitlab-org/gitlab!67153))
- [Handle int and bigint namespaces.id column](gitlab-org/gitlab@1f78b6c6d27bef78180a99e434851a29972b3e62) ([merge request](gitlab-org/gitlab!67288))
- [copy: Update survey callout text](gitlab-org/gitlab@5c16aff831ea73b59ad8783cbef44acdd54723ee) ([merge request](gitlab-org/gitlab!67243))
- [Changed the column order in the jobs table](gitlab-org/gitlab@8ca06871584e69757bdf5d14134b234118f005df) ([merge request](gitlab-org/gitlab!67071))
- [Add field validations for Finding Evidence models](gitlab-org/gitlab@773d965be22c399b471aa10fa96fd39f749a5ec9) ([merge request](gitlab-org/gitlab!66394)) **GitLab Enterprise Edition**
- [Use gitaly-backup for repository backups by default](gitlab-org/gitlab@4a71440b65a007d3e8723cda7c1d82add279fa08) ([merge request](gitlab-org/gitlab!67082))
- [Enhance UX on Environment Form with Loading Icon](gitlab-org/gitlab@9b63a6789a4efa9059788e1d33f646ac7569790c) ([merge request](gitlab-org/gitlab!66750))
- [Include retried jobs in pipeline payloads for Datadog integration](gitlab-org/gitlab@a5327bf567c1c0d05319f4ecaf9eb54316e1eb39) ([merge request](gitlab-org/gitlab!67031))
- [Expose mergeRequestCounts for Issue GraphQL type](gitlab-org/gitlab@67ebd3eea7e70ae6229bbedc966ffe0e4da7a4da) ([merge request](gitlab-org/gitlab!65931))
- [Hide pull mirror update time from guest visitors](gitlab-org/gitlab@11c73b3a757f20903fb2ebf41b39e58a2576e199) ([merge request](gitlab-org/gitlab!67133))
- [Use feature flag for finding links](gitlab-org/gitlab@1083165950fb2f3171cc2ce63a588ca8cfe01b53) ([merge request](gitlab-org/gitlab!66868)) **GitLab Enterprise Edition**
- [Unified preloading stylesheets](gitlab-org/gitlab@a712e481804acd57d7dadca3c1c6cfba38438ec4) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/67045))
- [Promote source activity as the invite email body](gitlab-org/gitlab@08b9c03a0034471a43e0c100540e99a55b4add11) ([merge request](gitlab-org/gitlab!66560))
- [Include deployment_tier to pipeline environment hook attributes](gitlab-org/gitlab@925656b989c8095223389bd01a04ae248aa0c5ca) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/66744))
- [Imrpove model validation when adding spent time](gitlab-org/gitlab@4d8f719c70fc5e297608d115936d2bd682837fee) ([merge request](gitlab-org/gitlab!66973))
- [Boards sidebar design tweaks](gitlab-org/gitlab@241af67cf80bdc6fe8bb0d2b5826fcc2f4eefb5a) ([merge request](gitlab-org/gitlab!65297))
- [Make experiments API a filter of features API](gitlab-org/gitlab@b7cfcaf8738ed7f808aa17a694576afafb1a8b7e) ([merge request](gitlab-org/gitlab!66488)) **GitLab Enterprise Edition**
- [Add filitering by issue type in issue boards](gitlab-org/gitlab@357de2d72600ce90b77954152deeee7c7f3113da) ([merge request](gitlab-org/gitlab!66871))
- [Fix alt tag on participant avatars](gitlab-org/gitlab@34cb32772a4290ca80504d7a5a4a37144a966cb6) ([merge request](gitlab-org/gitlab!66952))
- [Use popovers for inline code quality](gitlab-org/gitlab@6bbf1dcb5943f4d54ead7d7b6976765cfbe8fab8) ([merge request](gitlab-org/gitlab!64371)) **GitLab Enterprise Edition**
- [Update UI text for CI/CD settings](gitlab-org/gitlab@21d8a6422b7d537a57ea7b3fb720b8562f1b35d3) ([merge request](gitlab-org/gitlab!66902)) **GitLab Enterprise Edition**
- [Use gitaly-backup for repository backups by default](gitlab-org/gitlab@cb8a1c47a59df1b599cbb2e8338c4a45a5e7f19b) ([merge request](gitlab-org/gitlab!66019))
- [Add request and response to SupportingMessage](gitlab-org/gitlab@a446cd93ee9ac8fb188210727f7969f56640b937) ([merge request](gitlab-org/gitlab!66398))
- [Remove DOMPurify attribute sanitization](gitlab-org/gitlab@9dcf3f0b663ec9ed516d25e59ef5e946e1de09b1) ([merge request](gitlab-org/gitlab!66502))
- [Update documentation to use compliance report not compliance dashboard](gitlab-org/gitlab@5f486d1b8319e1a742b12999d25693dfde21acf4) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/66730)) **GitLab Enterprise Edition**
- [Make vulnerability-dismissal error more descriptive](gitlab-org/gitlab@11df1ff9b59a1b9188118ef1af67888492eda2c7) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/66722)) **GitLab Enterprise Edition**
- [Increase contrast for successful pipelines in charts](gitlab-org/gitlab@975b1a97af86fe912af138711d6831e26a05a911) ([merge request](gitlab-org/gitlab!66426))
- [Add labels as search token in Jira issues list](gitlab-org/gitlab@9c2bacff3dddea3d06a0cd3a84e15d5f3676b2c4) ([merge request](gitlab-org/gitlab!65817)) **GitLab Enterprise Edition**
- [Add linked pipelines to component](gitlab-org/gitlab@0e4ec627c373246ff9c347fa9054aca016787521) ([merge request](gitlab-org/gitlab!66748)) **GitLab Enterprise Edition**
- [ff: Remove `:list_commits` feature flag](gitlab-org/gitlab@e8a98485fe74bf18904865eb12a372cd4a13aa3a) ([merge request](gitlab-org/gitlab!66741))
- [flags: Drop `fetch_remote_params` feature flag](gitlab-org/gitlab@f1ef0bd00ce621880033a6420e4ae634037070bc) ([merge request](gitlab-org/gitlab!66513))
- [flags: Drop `update_remote_mirror_inmemory` feature flag](gitlab-org/gitlab@62586dbc942d7d9f242556d3a165044f853b8332) ([merge request](gitlab-org/gitlab!66513))
- [Migrate Edit Environments Form to Vue](gitlab-org/gitlab@961d0d8a6d612860834c27424ddeddab0975005f) ([merge request](gitlab-org/gitlab!66573))
- [Sort according to the field in Dependency List](gitlab-org/gitlab@52c76470c1c1258b53841d4598a4fe013f61c507) ([merge request](gitlab-org/gitlab!66672)) **GitLab Enterprise Edition**
- [Show minor ellipsis when loading large blobs](gitlab-org/gitlab@077bd312a56996a5e0f6cffa890ebda062474b8d) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/66652))
- [Polish tab count and create button in test cases](gitlab-org/gitlab@e02a2af69c347c9480091a44009a8f16af0ea027) ([merge request](gitlab-org/gitlab!66608)) **GitLab Enterprise Edition**
- [Edit Grafana UI text in admin area](gitlab-org/gitlab@697c2f4b4b9fb52d0f74cea66ce28be5baa3c99f) ([merge request](gitlab-org/gitlab!66405))
- [Add link to GitLab Changelog With Version Check](gitlab-org/gitlab@c70f0e828d8eca8a2e58182ff35e3c44c73e59cf) ([merge request](gitlab-org/gitlab!66486))
- [The readme checkbox for new projects is checked by default](gitlab-org/gitlab@d71342649242ea28c75f8cbce04c97ccd32cc72e) ([merge request](gitlab-org/gitlab!66558))
- [Add linked pipelines to component](gitlab-org/gitlab@d3cb02d059a61341b6aa88df6b6fb2828579c5c5) ([merge request](gitlab-org/gitlab!66274))
- [Move the compliance framework selector to a new expandable section](gitlab-org/gitlab@c6582d8ca858aa505b7d94984f10b21839cee593) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/66429)) **GitLab Enterprise Edition**
- [Skip in-product marketing emails when on trial](gitlab-org/gitlab@e43b7f200dbbb2706d45faeda77285e9a074ab3e) ([merge request](gitlab-org/gitlab!66269)) **GitLab Enterprise Edition**
- [Force user to re-enter integration password](gitlab-org/gitlab@fc7722996d41d733d0143f0878b954b8dda2e079) ([merge request](gitlab-org/gitlab!65569)) **GitLab Enterprise Edition**
- [Migrate the deprecated "urlParamsToObject" to "queryToObject"](gitlab-org/gitlab@13ac932c97c399fe04698890b244a836e7bb8e9e) ([merge request](gitlab-org/gitlab!65499)) **GitLab Enterprise Edition**
- [Remove prevent_retry_of_retried_jobs feature flag](gitlab-org/gitlab@66360678bc17617a0dd0cd24d0a3601f97075a78) ([merge request](gitlab-org/gitlab!66407))
- [Add dast-runner-validation to Secure-Binaries YAML](gitlab-org/gitlab@0bd402ff0a0963145b16eba3479209589a19ba16) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/66501)) **GitLab Enterprise Edition**
- [Fix missing amount in Contribution Analytics](gitlab-org/gitlab@a272c572f2ed01abb4e245ccb43cc35cf2e71173) ([merge request](gitlab-org/gitlab!66385)) **GitLab Enterprise Edition**
- [Migrate New Environments Form to Vue](gitlab-org/gitlab@c155d2b127f09fe8d5122d2b63a727587f6a5621) ([merge request](gitlab-org/gitlab!66192))
- [Allow updating merged results pipelines and merge trains via API](gitlab-org/gitlab@624d6690f4efb9d5fe6b86bcd7e5b3fa0bb4c74e) ([merge request](gitlab-org/gitlab!56237))
- [Handle team-managed (next-gen) Jira projects](gitlab-org/gitlab@c69f02df9508b15def55ab759bfdc88280d2464d) ([merge request](gitlab-org/gitlab!66250)) **GitLab Enterprise Edition**
- [Remove badge cache](gitlab-org/gitlab@19e12bea89de5b7041a199910a57c0f73f38c90b) ([merge request](gitlab-org/gitlab!65638))
- [Enable writes to CI builds metadata table by default](gitlab-org/gitlab@61293c6159c3816db5c8ad0273e2a292c73b3adc) ([merge request](gitlab-org/gitlab!66163))
- [Nginx: modernise TLS config](gitlab-org/gitlab@61df826cd3d557d6f6246713e21963ba92df1cca) ([merge request](gitlab-org/gitlab!65345))

### Deprecated (2 changes)

- [Deprecate sorting vulnerabilities by title in GraphQL API](gitlab-org/gitlab@bc8dc2b0f191e9d7b12352c145f97ae0d8d21440) ([merge request](gitlab-org/gitlab!66917)) **GitLab Enterprise Edition**
- [Deprecate container_registry_enabled in projects public API](gitlab-org/gitlab@123c561f2fc007709d041f35c73009090a9170ed) ([merge request](gitlab-org/gitlab!62662))

### Removed (11 changes)

- [Cleanup group empty state experiment](gitlab-org/gitlab@857d2eac9fd14d7699701c8f8d2d6e54051b9a3e) ([merge request](gitlab-org/gitlab!68370))
- [Remove devops_adoption_feature feature flag](gitlab-org/gitlab@e48a811c8e8c3ad2d1da81509f45b5bfe99b9f70) ([merge request](gitlab-org/gitlab!67861))
- [Remove sec_dependency_scanning_ui_enable Feature Flag](gitlab-org/gitlab@8b307a108cc9df4600b0ef12577e38fbe41decf6) ([merge request](gitlab-org/gitlab!67585))
- [Remove scan_execution_policy_ui feature flag](gitlab-org/gitlab@e456b564ada08ac9bc98ffcafeaef5fd7b070949) ([merge request](gitlab-org/gitlab!67642)) **GitLab Enterprise Edition**
- [Drop FF load_balancing_for_pipeline_notification_worker](gitlab-org/gitlab@e246cb2977dadb102d0f7d5c86a1e22745eada83) ([merge request](gitlab-org/gitlab!67456))
- [Remove the similarity_search feature flag](gitlab-org/gitlab@992270b9d247df8b73dc780eda4eae69676f100d) ([merge request](gitlab-org/gitlab!67310))
- [Remove unused `Gitlab::Database::MultiThreadedMigration`](gitlab-org/gitlab@d593fe3651ad9962f70ef71325fa940130b2553d) ([merge request](gitlab-org/gitlab!67333))
- [Remove 'one_megabyte_file_size_limit' feature flag](gitlab-org/gitlab@3bf77e477d8d46cfd66b196d01247f7712a7ae83) ([merge request](gitlab-org/gitlab!66850))
- [Remove group invites from new user registration](gitlab-org/gitlab@523559b918f3af2a5f7f26921532eae3f76ace94) ([merge request](gitlab-org/gitlab!66554)) **GitLab Enterprise Edition**
- [Remove not_null constraint on project_fingerprint](gitlab-org/gitlab@9515ded6205ae6af1b9a3231b80298029d9728af) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/66194)) **GitLab Enterprise Edition**
- [Remove marketing email opt-in for self-managed](gitlab-org/gitlab@3e23d77a1af419b1774d2b767ea2f5a192f12fd5) ([merge request](gitlab-org/gitlab!66255))

### Security (19 changes)

- [Sanitize default branch name in repo settings](gitlab-org/gitlab@38401468bc6740589698d9bf0c6e1f24b99c0a8c) ([merge request](gitlab-org/gitlab!67567))
- [Add project member validation for domain limitation](gitlab-org/gitlab@7c920bbc9b0b11eeed2b4c675160f5cc5d95c69c)
- [Hide project-level CI/CD Analytics for Guests](gitlab-org/gitlab@7ac6a6218f2b9c9afbf8182b047b2cbd6a747ec0)
- [Only allow invite to be accepted by user with matching email](gitlab-org/gitlab@391bc665d7535f97c852b9d73f6a8fd098bcbfd8)
- [Add html escaping for default branch name](gitlab-org/gitlab@dbdc999e35be70fd7c21d881c925dfdae6526d83)
- [Filter todos whose target users no longer have access to](gitlab-org/gitlab@16516b2a3a12aee7950110c73cd48d0b8a4b5fcc)
- [Configure OmniAuth to use GitLab AppLogger](gitlab-org/gitlab@d13b0d392f25db2512fe40565bb068d8920dbc46)
- [Add permissions check to pipelines#show action](gitlab-org/gitlab@d2a4ccdcf6335131fe3a1055c0bdd92d6e746a4f)
- [Prevent impersonation in gitlab-shell SSH certs](gitlab-org/gitlab@748e6639b429f88cbcc3c1873bf3b10f34ad078b)
- [Do not show email address in error message](gitlab-org/gitlab@03497fbd357fa30ed2280ff2a1d4188c9c16df95) **GitLab Enterprise Edition**
- [Disallow non-members to set issue metadata on issue create](gitlab-org/gitlab@ec30a8d87167084cf033031b58531720bd1e3bc3)
- [Prevent guests from linking issues with errors](gitlab-org/gitlab@6c520f98137bee8d4dcdeb566cafb0cc174b8b98)
- [Block impersonation token use if it is not permitted](gitlab-org/gitlab@de812b202430fca3f271ae5c4e1b98e40abaac24)
- [Fix Protected Environment Accesses Cleanup](gitlab-org/gitlab@85e9ab0336ea92cb3941721fb7e6d8017eea3424) **GitLab Enterprise Edition**
- [Updates oauth to 0.5.6](gitlab-org/gitlab@1d4f7f01c624e69710a39beeed1e1a2b3286fd09)
- [Remove impersonation token from api response for non-admin user](gitlab-org/gitlab@ba04748936bba512f83a7d62aa395f9e0f02c79b)
- [Use oauth_app id instead of uid](gitlab-org/gitlab@d5b61695843c41a54e1f97ab7a44769de6bce142) **GitLab Enterprise Edition**
- [Restrict access to instance-level security features for reporters](gitlab-org/gitlab@5deba06177dad7fd09f7a1b264d4a6f0179cbba0) **GitLab Enterprise Edition**
- [Fix XSS in Mermaid Markdown rendering](gitlab-org/gitlab@7ba708f3b35278b06e912f9933618d0f34f0fbf5)

### Performance (23 changes)

- [Use common namespace ancestor queries](gitlab-org/gitlab@52e59891210e87316bf6db9df7270b3674b049e2) ([merge request](gitlab-org/gitlab!68072))
- [Do not use subtransactions when updating ci minutes usage](gitlab-org/gitlab@da13592ca045ae2c5a5987cda6459fed8dc37ebe) ([merge request](gitlab-org/gitlab!68471))
- [Avoid subtransaction in UserInteractedProject](gitlab-org/gitlab@048edfe05d0d3e58efb5d970768b7315f1ad1fbf) ([merge request](gitlab-org/gitlab!68448))
- [Reduce N+1 Gitaly queries when publishing multiple draft notes](gitlab-org/gitlab@b870a652789ec4cbd5f6f65c37ec012b11dcb2f5) ([merge request](gitlab-org/gitlab!68045))
- [Memoize namespace monthly usage to reduce SQL queries](gitlab-org/gitlab@f558ca40fea462f2ec493e158feda641b691c19f) ([merge request](gitlab-org/gitlab!68219))
- [Include database load balancing for Deployments HooksWorker](gitlab-org/gitlab@ab050d675d24416fc416f99260a0c9007dadd94d) ([merge request](gitlab-org/gitlab!67878))
- [Use default project filter for issue/merge request project searches](gitlab-org/gitlab@38f930b936a6e0129aaacaabbc5795bdb15a8f4c) ([merge request](gitlab-org/gitlab!67921))
- [Improve raw blobs downloading](gitlab-org/gitlab@91f0a0771e1562f87cb6b198c02818b0b0fb0f24) ([merge request](gitlab-org/gitlab!67155))
- [Use common namespace ancestor queries](gitlab-org/gitlab@c6652bdafce5c52710556ce75f94308be09cd41f) ([merge request](gitlab-org/gitlab!67565))
- [Query multiple group descendants at once](gitlab-org/gitlab@809a10e7955a4789d578e36ecb91a4e8a62b8fe1) ([merge request](gitlab-org/gitlab!67653))
- [Use new service to refresh authorizations of project members](gitlab-org/gitlab@d748c4747e8e2852e452ca3433d6cfa020b02ed4) ([merge request](gitlab-org/gitlab!67477))
- [Cache commit stats for a single commit](gitlab-org/gitlab@8aa2681f5d9bf4472094b9ea9f1e7b8836457875) ([merge request](gitlab-org/gitlab!67592))
- [Query ActiveRecord::Relation descendants](gitlab-org/gitlab@83e9f6e22a30abe7bcdb6d8d688fa16907b03976) ([merge request](gitlab-org/gitlab!67562))
- [checks: Speed up retrieving commits via quarantine directory](gitlab-org/gitlab@0a90028f1133ec9de7455afe738ab8d529cd3775) ([merge request](gitlab-org/gitlab!67210))
- [Reduce Markdown cache updates during deploy](gitlab-org/gitlab@463d7aeb40f538abb18334ef3cad0061135f0efd) ([merge request](gitlab-org/gitlab!67239))
- [Query ActiveRecord::Relation descendants](gitlab-org/gitlab@07a3097642be99165ee8f6e9b9dc5c74791b2c09) ([merge request](gitlab-org/gitlab!65891))
- [Reduce repaints on blame page](gitlab-org/gitlab@8a65b1e56d55bb11c1aa87bb863c0f98d4cace2f) ([merge request](gitlab-org/gitlab!67050))
- [geo: Pass authentication header via `#fetch_remote`](gitlab-org/gitlab@0c8a54398646fe1d64da5b2ed88934108b700b01) ([merge request](gitlab-org/gitlab!66822)) **GitLab Enterprise Edition**
- [Disable creating user mentions during import](gitlab-org/gitlab@d11191f125e6addcb40d2f56a566661899f5e2a8) ([merge request](gitlab-org/gitlab!66792))
- [Remove flag guarding batched computation of changes size](gitlab-org/gitlab@02755cd55cc005eb3ae3c60ba8f2b641c7b77f5c) ([merge request](gitlab-org/gitlab!66527))
- [Move merge-request merge_pipeline to cached_widget](gitlab-org/gitlab@6af0742133e849d5e0800ebef75c3356e565ccb2) ([merge request](gitlab-org/gitlab!59968))
- [Optimize scanning for references process](gitlab-org/gitlab@7b6fa26743edc24e65b7c5f9eaeae5fe0a4a7b0c) ([merge request](gitlab-org/gitlab!65847))
- [Move versions icon to CSS](gitlab-org/gitlab@90331b9428a9f101554a2fb5b3c68b11c5da7bf6) ([merge request](gitlab-org/gitlab!65843))

### Other (87 changes)

- [Make commit and design user mention indexes unique](gitlab-org/gitlab@221d5414dafcd99fa45ac0c35a413988459897d7) ([merge request](gitlab-org/gitlab!68433))
- [Add index on historical_data (recored_at) to improve queries](gitlab-org/gitlab@6f42db358a33433c612ab9fb04b0c3c9c585111c) ([merge request](gitlab-org/gitlab!68435))
- [Fix and reschedule background migration](gitlab-org/gitlab@0e243385923ae6a142b43fac9182398209876a83) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/68305))
- [Finalize conversion of ci_stages.id to bigint](gitlab-org/gitlab@84247dd0f2d8ac70a24b281a4f6f464bfaf943f7) ([merge request](gitlab-org/gitlab!66088))
- [Reschedules migration for uuid recalculation](gitlab-org/gitlab@f54ca835ac888f3ad5fdb35216c88dd1d8d52202) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/68200))
- [Remove pipelineGraphLayersView feature flag](gitlab-org/gitlab@582ecdb8b1b87cbd8acd59236ce21055fbe56d87) ([merge request](gitlab-org/gitlab!68040))
- [Pass **kwargs to the conn. for LB defined methods](gitlab-org/gitlab@db8faf0954071eceda603a870d9bde720283030d) ([merge request](gitlab-org/gitlab!68061))
- [Remove subscribable_subscription_banner flag](gitlab-org/gitlab@35f3121feb6aff6dd450693dfe7e30957ae84664) ([merge request](gitlab-org/gitlab!68257)) **GitLab Enterprise Edition**
- [Finalize conversion to bigint for ci_sources_pipelines](gitlab-org/gitlab@e5a025f516dbffa937dd849a97b65691e30d4369) ([merge request](gitlab-org/gitlab!66120))
- [Remove `ci_skip_before_parsing_yaml` FF](gitlab-org/gitlab@8d34ef0f8a9f8f7e7b54ce14b2c4ca683290d5e4) ([merge request](gitlab-org/gitlab!68287))
- [Cleanup invalid membership invites](gitlab-org/gitlab@29d3503946bf4b7287281f3fe7a1befa17779894) ([merge request](gitlab-org/gitlab!67760))
- [Rename GraphQL query resource from "instanceDashboard" to "instance"](gitlab-org/gitlab@2dd314939f57af599e9b23ace2290bed4adea792) ([merge request](gitlab-org/gitlab!67278)) **GitLab Enterprise Edition**
- [Disable updating the historical vulnerability statistics by default](gitlab-org/gitlab@60c931e6dbedeef3931eb8dc89bd4f5095f97f65) ([merge request](gitlab-org/gitlab!68189)) **GitLab Enterprise Edition**
- [Rename strip_attributes method](gitlab-org/gitlab@b4a754a976e3e49176fbfeef85db7191e40499a2) ([merge request](gitlab-org/gitlab!68193))
- [Updating the description for ecosystem metric](gitlab-org/gitlab@865ce2b2dcd2f320b0a34790175112a0a546b42c) ([merge request](gitlab-org/gitlab!68169))
- [Add ResetJobTokenScopeEnabledAgain migration](gitlab-org/gitlab@fb876346163d894138a363bc3e31031c27055bfb) ([merge request](gitlab-org/gitlab!68079))
- [Remove by default enabled feature flag](gitlab-org/gitlab@044d6166762622961bd03baf17619dc6e35bdff1) ([merge request](gitlab-org/gitlab!68165))
- [Remove docs redirects raketask](gitlab-org/gitlab@4c0835b38c05c3922ba4dcb35611024c2d51ec24) ([merge request](gitlab-org/gitlab!68149))
- [Remove pipelineGraphLayersView feature flag](gitlab-org/gitlab@d08880a41af0ab63a19f3ca0709541e16d8a5741) ([merge request](gitlab-org/gitlab!67969))
- [Remove jira_issue_association_on_merge_request feature flag](gitlab-org/gitlab@a43f09ec37e9933c9e513484cb70e81484830bec) ([merge request](gitlab-org/gitlab!68036)) **GitLab Enterprise Edition**
- [Finalize ci_job_artifacts conversion to bigint](gitlab-org/gitlab@3b9143606aadb3e733f1c602ba9cfd6fc3ad6c25) ([merge request](gitlab-org/gitlab!65601))
- [Migrate the deprecated "urlParamsToObject" to "queryToObject"](gitlab-org/gitlab@ceeb7dc048425cba841b14ac4a307680692a1267) ([merge request](gitlab-org/gitlab!65920)) **GitLab Enterprise Edition**
- [Include Puma worker PID in structured log](gitlab-org/gitlab@5df76410285bd2e9c695fc5b780a54ded1d08085) ([merge request](gitlab-org/gitlab!66694))
- [Denormalize ci_builds into security_scans](gitlab-org/gitlab@bf4f0409e90535d5cb6f0e55e2c39e2127a8ddc2) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/66963)) **GitLab Enterprise Edition**
- [Bump factory_bot_rails for Ruby3 support](gitlab-org/gitlab@06d14dfe8951b20b2f11fe1aeee9c08a9db6df8e) ([merge request](gitlab-org/gitlab!67866))
- [Additional namespace validation for AdditionalPack](gitlab-org/gitlab@6fdee1a78ffdd306c9b0ba26df9bcd70e82a3e51) ([merge request](gitlab-org/gitlab!67848)) **GitLab Enterprise Edition**
- [Finalize job_id conversion to bigint for ci_job_artifacts](gitlab-org/gitlab@794805ed543d53f1daf798db145057000d02415b) ([merge request](gitlab-org/gitlab!67774))
- [Use text links in MR approval settings section of UI](gitlab-org/gitlab@7ecc2da2fdb3dd798a48e6451fb67fc8b8a05517) ([merge request](gitlab-org/gitlab!67737)) **GitLab Enterprise Edition**
- [Remove jira_connect_create_branch feature flag](gitlab-org/gitlab@4c3c562c5d996ebf00ad2342aae8f87141b68073) ([merge request](gitlab-org/gitlab!67471))
- [Refactor documentation links for SP disabled](gitlab-org/gitlab@3f38ea4f6d4938d8aeae8f3dd5773f0e76db2830) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/67384)) **GitLab Enterprise Edition**
- [Swap multiple_database_metrics FF for env var](gitlab-org/gitlab@ebbdd30dfb0d7d2f3c8fcc5daec41f3c5fed862e) ([merge request](gitlab-org/gitlab!66885))
- [Update limitations of members API docs](gitlab-org/gitlab@b1a540756c39b406611e459f20cbf89c407f0dee) ([merge request](gitlab-org/gitlab!67659))
- [Migrate the deprecated "urlParamsToObject" to "queryToObject"](gitlab-org/gitlab@146a4fae422271a0a2d0f395c5880ed36aff68fb) **GitLab Enterprise Edition**
- [Remove runner_list_view_vue_ui feature flag](gitlab-org/gitlab@1532ee45d4c31ccaf4331da33833996371e68708) ([merge request](gitlab-org/gitlab!67021))
- [Update internal API docs](gitlab-org/gitlab@282eaa342da16351fec71f89c3e9ff19461f72ac) ([merge request](gitlab-org/gitlab!67606))
- [Finalize conversion to bigint for ci_builds_runner_session](gitlab-org/gitlab@5d13cf3dd04af2f33daaac4b20052821d6bcb7d6) ([merge request](gitlab-org/gitlab!66433))
- [Migrate the deprecated "urlParamsToObject" to "queryToObject"](gitlab-org/gitlab@74e0ace7766e39955e70729ab4dd3ca66499d707) ([merge request](gitlab-org/gitlab!65912))
- [Finalize conversion to bigint for push_event_payloads](gitlab-org/gitlab@109700f62258b7591c4916495ca9d627ea51cae7) ([merge request](gitlab-org/gitlab!67299))
- [Finalize conversion to bigint for ci_build_needs](gitlab-org/gitlab@e8e551327a43aff88239d61d4491ef286f04c85f) ([merge request](gitlab-org/gitlab!65216))
- [Refine Documentation pages URL UI and documentation](gitlab-org/gitlab@8020c533eb7732d0cee32de033cf78c00afb6750) ([merge request](gitlab-org/gitlab!67293)) **GitLab Enterprise Edition**
- [Prepare indexes for bigint column conversions](gitlab-org/gitlab@e09fc6977889568a584d246f23e07d18c738342e) ([merge request](gitlab-org/gitlab!67532))
- [Revise UI text for PlantUML settings](gitlab-org/gitlab@d5178727ff065f829609834ca841814f1a174571) ([merge request](gitlab-org/gitlab!67497))
- [Follow-up pass for renaming Usage Ping/Data](gitlab-org/gitlab@26f3da5ad01697c1446a4d5e9430ec3202d4304b) ([merge request](gitlab-org/gitlab!66990))
- [Finalize converting deployments to bigint](gitlab-org/gitlab@e8d78b6fee41133a48c4e1a768705bae6ab2736f) ([merge request](gitlab-org/gitlab!67341))
- [Remove the FF ci_wildcard_file_paths](gitlab-org/gitlab@4cf9beb453de21c5955a1cec2474cc21f949f7a9) ([merge request](gitlab-org/gitlab!67441))
- [Revise admin area Pages settings UI](gitlab-org/gitlab@7c675c278ebee925def48f306c4853b3ebf31a25) ([merge request](gitlab-org/gitlab!66368))
- [Remove feature flag related to valid hosts list](gitlab-org/gitlab@1c2a29fe7dc98c6a88ea348cc788bbe29edc867a) ([merge request](gitlab-org/gitlab!65755))
- [Refactor timezone UI and documentation](gitlab-org/gitlab@b4fbf3532a1f2c773c2f662e7ca3fdc0f97a2583) ([merge request](gitlab-org/gitlab!67301))
- [Migrate the deprecated "urlParamsToObject" to "queryToObject"](gitlab-org/gitlab@5cf900baa1d938562c3a1e89f67df78a7a55a30b) ([merge request](gitlab-org/gitlab!65917)) **GitLab Enterprise Edition**
- [Migrate the deprecated "urlParamsToObject" to "queryToObject"](gitlab-org/gitlab@0a7ced21384192c3c8c8aa3b37fcd91c99faa023) ([merge request](gitlab-org/gitlab!65904)) **GitLab Enterprise Edition**
- [Migrate the deprecated "urlParamsToObject" to "queryToObject"](gitlab-org/gitlab@4b2236b92593baf24ecabab53f0fa101ea49dc0e) ([merge request](gitlab-org/gitlab!65903)) **GitLab Enterprise Edition**
- [Migrate the deprecated "urlParamsToObject" to "queryToObject"](gitlab-org/gitlab@b401f8e26d977feddc9c992281315028f5b998d9) ([merge request](gitlab-org/gitlab!65896))
- [Migrate the deprecated "urlParamsToObject" to "queryToObject"](gitlab-org/gitlab@1dea45c7c6d472cf985aad60e58b38567c59155e) ([merge request](gitlab-org/gitlab!65897)) **GitLab Enterprise Edition**
- [Migrate the deprecated "urlParamsToObject" to "queryToObject"](gitlab-org/gitlab@497ee293308fd85a725fee9480f4cd038005fd3f) ([merge request](gitlab-org/gitlab!65919)) **GitLab Enterprise Edition**
- [For consistency do not use CSS calc for simple calculation of margin-top](gitlab-org/gitlab@2cfdc8e2279772adb865dc202f624ed0f49de95a) ([merge request](gitlab-org/gitlab!67270))
- [Remove unused code](gitlab-org/gitlab@3c71929b1a3eb0d3089c2f9d4be5552c807aa2d8) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/67162)) **GitLab Enterprise Edition**
- [Reschedule Delete Orphaned Deployments BG migration](gitlab-org/gitlab@e61df7c8566b8d02b5144ee448f08e3ec0138a23) ([merge request](gitlab-org/gitlab!66813))
- [Finalize conversion to bigint for push_event_payloads](gitlab-org/gitlab@2e0ca4e445707aced673035490a2307dccdea879) ([merge request](gitlab-org/gitlab!65795))
- [Finalize conversion to bigint for ci_build_trace_chunks](gitlab-org/gitlab@8228341c4300542d770e1648f31a43f39c4270f6) ([merge request](gitlab-org/gitlab!66123))
- [Remove `gitlab_subscription_future_renewal` feature flag](gitlab-org/gitlab@45da0404be71e6c8a3ba006e82c492e3e71670bc) ([merge request](gitlab-org/gitlab!66829)) **GitLab Enterprise Edition**
- [Remove dast_configuration_ui feature flag](gitlab-org/gitlab@31da8512f850a3ccf19736ea1b02f932252b1ae6) ([merge request](gitlab-org/gitlab!66817)) **GitLab Enterprise Edition**
- [Fix the offenses introduced by Style/RegexpLiteralMixedPreserve](gitlab-org/gitlab@c61e416600a96646c1bd5c8347c8da0c85510958) ([merge request](gitlab-org/gitlab!66753)) **GitLab Enterprise Edition**
- [Removes unused gitorious logos](gitlab-org/gitlab@437b63b84146c9034706c3204b4bb3ade5cffbec) ([merge request](gitlab-org/gitlab!66786))
- [Revised Package Registry settings text](gitlab-org/gitlab@381032baf203c738ecccc4f53f097afde0409977) ([merge request](gitlab-org/gitlab!66395))
- [Revert backfill on ci_build_trace_sections](gitlab-org/gitlab@27262d7b8d81b5b00b691d6365dbf3730108a4fb) ([merge request](gitlab-org/gitlab!66627))
- [Clean up evalute_protected_tag_for_release_permissions feature flag](gitlab-org/gitlab@dde58c83f7c41ca0234969e55c31e115c339f7ec) ([merge request](gitlab-org/gitlab!66713))
- [Update service ping metric implementation guidelines](gitlab-org/gitlab@09ef8592d13dc69a380266d21d4486211b3f2c48) ([merge request](gitlab-org/gitlab!66616))
- [Add tracking events for the dependency proxy](gitlab-org/gitlab@e2885e45de15a42610f50f8c10527c597ca05f33) ([merge request](gitlab-org/gitlab!65812))
- [Remove redundant indexes for devops adoption](gitlab-org/gitlab@7878b74a6b7337f52c151691a73f4f673ed51df2) ([merge request](gitlab-org/gitlab!66644))
- [Add area of focus to members](gitlab-org/gitlab@864c59d66dfc9eab9bd8f1079059e8dc556027ca) ([merge request](gitlab-org/gitlab!64956))
- [Fix up the docs warning detected by the vale latin term rule](gitlab-org/gitlab@e4dc09b314c8aab45f0f42472c98aa2e62d02774) ([merge request](gitlab-org/gitlab!66325))
- [Update help text in runner update form](gitlab-org/gitlab@ce01eb60183252708f0a7aa3d110fc06038b8bbf) ([merge request](gitlab-org/gitlab!66148))
- [Migrate the deprecated "urlParamsToObject" to "queryToObject"](gitlab-org/gitlab@c9c3690fdf399fd916fc95b39517b434dd3c68bf) ([merge request](gitlab-org/gitlab!65900)) **GitLab Enterprise Edition**
- [Migrate the deprecated "urlParamsToObject" to "queryToObject"](gitlab-org/gitlab@1d010a6f352fd7485a3e013ee93c0dbef4823904) ([merge request](gitlab-org/gitlab!65902)) **GitLab Enterprise Edition**
- [Migrate the deprecated "urlParamsToObject" to "queryToObject"](gitlab-org/gitlab@65aaf601b08def9f3f687bd505c7677d3d53cdd3) ([merge request](gitlab-org/gitlab!65914)) **GitLab Enterprise Edition**
- [Migrate the deprecated "urlParamsToObject" to "queryToObject"](gitlab-org/gitlab@90e8802292658cb4cee37b2729460274fbab548d) ([merge request](gitlab-org/gitlab!65916)) **GitLab Enterprise Edition**
- [Log when a container repository is selected](gitlab-org/gitlab@0ee8d9f9877db52ffc353e2cce46e0090763c0e4) ([merge request](gitlab-org/gitlab!66182))
- [Expose init aux viewer](gitlab-org/gitlab@625005ebec644c1708262b9b299b140b9fa25041) ([merge request](gitlab-org/gitlab!66528))
- [Remove service templates](gitlab-org/gitlab@359813b6c03f1063422f449b04a8a76b7c82de27) ([merge request](gitlab-org/gitlab!64975))
- [Remove merge_request_draft_filter feature flag](gitlab-org/gitlab@292afd630b937353844091f0b876c17c19fcf83f) ([merge request](gitlab-org/gitlab!66507))
- [Remove unused cluster application logos](gitlab-org/gitlab@d9297157da4eebb3d0cdfd5e8cf8bfbdcd9f8f50) ([merge request](gitlab-org/gitlab!66485))
- [Update GitLab Runner Helm Chart to 0.31.0](gitlab-org/gitlab@a27f4ca670d9bcf70fd694a3d9df79657a2ef451) ([merge request](gitlab-org/gitlab!66447))
- [Revise UI text for Kroki settings](gitlab-org/gitlab@3489047a1c2429cda2c1e2305424c4b4ba68bb08) ([merge request](gitlab-org/gitlab!66258))
- [Add Chrome to Jira connect working browsers](gitlab-org/gitlab@ff0c52d346f7c00b441070a159ba6173852a2536) ([merge request](gitlab-org/gitlab!66236))
- [Refactor polling interval multiplier configuration UI and docs](gitlab-org/gitlab@b8ef9101f45759b19d982f3f6ae74cf92e2a31d1) ([merge request](gitlab-org/gitlab!66342))
- [Add helpful text to URL group validation and limit text](gitlab-org/gitlab@59a5a6266cb0d5434596170ffa36e4e74b8d2c2c) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/65369)) **GitLab Enterprise Edition**
- [Refactor external storage admin area configuration UI and docs](gitlab-org/gitlab@497ba4fc8f4ec1d234c9f5f1ec5c69712b8c7cb3) ([merge request](gitlab-org/gitlab!66219))

## 14.1.8 (2021-11-15)

### Fixed (1 change)

- [Prevent Git operations from checking replication lag on non-Geo-secondary sites](gitlab-org/gitlab@5abc66f89524b63873b0ce96b0f78c0acc2687f6) ([merge request](gitlab-org/gitlab!73980)) **GitLab Enterprise Edition**

### Changed (4 changes)

- [Geo: Alternate redownload and normal design sync attempts](gitlab-org/gitlab@c23c94e9d791770fd169723845b12097b8512a9e) ([merge request](gitlab-org/gitlab!73980)) **GitLab Enterprise Edition**
- [Geo: Alternate redownload and normal SSF sync attempts](gitlab-org/gitlab@5aba12770829d43041ef4307049ed500c02b1d77) ([merge request](gitlab-org/gitlab!73980)) **GitLab Enterprise Edition**
- [Geo: Alternate redownload and normal project syncs](gitlab-org/gitlab@4d3a5798e1f136a027c0b7aab6a35afb3c207ce7) ([merge request](gitlab-org/gitlab!73980)) **GitLab Enterprise Edition**
- [Geo: Reduce frequency of redownload attempts](gitlab-org/gitlab@795271787c70b7c92a85daa253d2d61561603443) ([merge request](gitlab-org/gitlab!73980)) **GitLab Enterprise Edition**

## 14.1.7 (2021-09-30)

### Security (28 changes)

- [Require password param for 2FA changes](gitlab-org/security/gitlab@4e16401a77264ef3127f0bb314fa0abab11216c7) ([merge request](gitlab-org/security/gitlab!1816))
- [Fix permissions check on project members import](gitlab-org/security/gitlab@be54b3f4890fa89d58cb02be79c65025f606bd6c) ([merge request](gitlab-org/security/gitlab!1860))
- [Respect disabled import sources when initiating import via API](gitlab-org/security/gitlab@b76b6229c93447954efc5719e6dd61eb601afdc4) ([merge request](gitlab-org/security/gitlab!1848))
- [Return 404 if model id wasn't passed to UploadsController](gitlab-org/security/gitlab@8ab1cfaafba21a9e90ef41677993af2afdcd920a) ([merge request](gitlab-org/security/gitlab!1845))
- [Scrub artifacts signed URL in SendEntry logs](gitlab-org/security/gitlab@5bae93b2f085d5dac58e411bffb5ca518fe7df98) ([merge request](gitlab-org/security/gitlab!1842))
- [Prevent double-impersonation and impersonation breakout](gitlab-org/security/gitlab@7c82d0f2a1dbfb0a23d6a5cdaee448307ffc6972) ([merge request](gitlab-org/security/gitlab!1836))
- [Clear session access tokens when starting/stopping impersonation](gitlab-org/security/gitlab@a4d529eb7c8eeb3e9c42ae3d81514d79a905cdb7) ([merge request](gitlab-org/security/gitlab!1833))
- [Use validated URL when sending request to Gitea Importer](gitlab-org/security/gitlab@b30536e6c9aa969c76bcd167f00db5a0e07ace7a) ([merge request](gitlab-org/security/gitlab!1820))
- [Fix XSS in Jira link](gitlab-org/security/gitlab@9ace10c46744ee220c649d2da0eeb3e99216ee7d) ([merge request](gitlab-org/security/gitlab!1625)) **GitLab Enterprise Edition**
- [Fix fogbugz importer DNS Rebind SSRF](gitlab-org/security/gitlab@9d7107665d6ed931ef4b2feeb0287bc71b89232c) ([merge request](gitlab-org/security/gitlab!1682))
- [Remove related project access tokens when a project is deleted](gitlab-org/security/gitlab@b86096865949f07f6a2020603959117d9c84877b) ([merge request](gitlab-org/security/gitlab!1812))
- [Require group admin access to list pending invites](gitlab-org/security/gitlab@404b344edd61b2f13c3498cd545c2b40165ee536) ([merge request](gitlab-org/security/gitlab!1721))
- [Do not export and import repository_size_limit](gitlab-org/security/gitlab@56f563980f944f1a5e3935ad82070e6719cd5a0c) ([merge request](gitlab-org/security/gitlab!1768))
- [Escapes MR approval rule names correctly](gitlab-org/security/gitlab@ea64f981ce70a0e1e6ee58e64a6007e82f48e071) ([merge request](gitlab-org/security/gitlab!1809))
- [Filter shared groups autocomplete by permitted](gitlab-org/security/gitlab@59999ab27cba402589b27d204cf29678100e948b) ([merge request](gitlab-org/security/gitlab!1806)) **GitLab Enterprise Edition**
- [Require access token for git when 2fa is required](gitlab-org/security/gitlab@6a4a75efd7685a69ffa7cc4c027c7058013cca45) ([merge request](gitlab-org/security/gitlab!1796))
- [Disable exporting pipeline triggers on project export](gitlab-org/security/gitlab@8a8c78ed054def210013a849195939d7888fcf65) ([merge request](gitlab-org/security/gitlab!1790))
- [Add pagination to dependencies API](gitlab-org/security/gitlab@2a963ad670c60d1f3078fdf446ea755c5862fa26) ([merge request](gitlab-org/security/gitlab!1725)) **GitLab Enterprise Edition**
- [Permission check issuable template API data](gitlab-org/security/gitlab@9d95d13bc714e46b5e3697288c4b398cb5aee88b) ([merge request](gitlab-org/security/gitlab!1787)) **GitLab Enterprise Edition**
- [Apply account locking to password reset page](gitlab-org/security/gitlab@47ee79b1983de886f5ebe04b2975c2e37aa938ce) ([merge request](gitlab-org/security/gitlab!1784))
- [Enforce configured scopes for Oauth applications](gitlab-org/security/gitlab@acf2d894c91aa7fb72ea32b10e50e94441885399) ([merge request](gitlab-org/security/gitlab!1781))
- [Verify state before using errors from OAuth2 OmniAuth providers](gitlab-org/security/gitlab@20073576508aa239e52d8ff911c1dfd3df8af670) ([merge request](gitlab-org/security/gitlab!1778))
- [Prevent moving epic issues to different group hierarchy](gitlab-org/security/gitlab@93c6ec69b7bc6c9124a2a5350cebebb57f63a28f) ([merge request](gitlab-org/security/gitlab!1774)) **GitLab Enterprise Edition**
- [Prevent showing not allowed subgroup epics](gitlab-org/security/gitlab@72a11e72425a033f3464d6ff12b4d06e12ec9faf) ([merge request](gitlab-org/security/gitlab!1766)) **GitLab Enterprise Edition**
- [Do not allow status checks to exist with external protected branches](gitlab-org/security/gitlab@8f96c013ccbbe9c52b3f03fb0d247debb1b157a8) ([merge request](gitlab-org/security/gitlab!1763)) **GitLab Enterprise Edition**
- [Fix GFM autocomplete xss](gitlab-org/security/gitlab@fd92dabddff5ae5d67a98aef5d858438520a2f06) ([merge request](gitlab-org/security/gitlab!1748))
- [Prohibit anonymous access for specific user API endpoint](gitlab-org/security/gitlab@2e8a386430309a931dbbd47fba7540a53399ad64) ([merge request](gitlab-org/security/gitlab!1737))
- [Fix denial-of-service attack in Markdown parser](gitlab-org/security/gitlab@5b6ed5212f880e2397dbea9ffc74cf0a35bd4411) ([merge request](gitlab-org/security/gitlab!1728))

## 14.1.6 (2021-09-27)

### Fixed (1 change)

- [Fix Elastic::MigrationWorker current_migration (2nd attempt)](gitlab-org/gitlab@f07c7a5f173a2fc053247664f21c03d29df543a4) ([merge request](gitlab-org/gitlab!71187)) **GitLab Enterprise Edition**

## 14.1.5 (2021-09-02)

### Fixed (1 change)

- [Geo: Replicate multi-arch containers](gitlab-org/gitlab@4f74fe9fb6f53cd877d8f793e2ef74c4177006d1) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/67624)) **GitLab Enterprise Edition**

## 14.1.4 (2021-08-31)

### Security (8 changes)

- [Update apollo_upload_server dependency](gitlab-org/security/gitlab@34e7e3b7590fd76d0f618091551651e8065edfd2) ([merge request](gitlab-org/security/gitlab!1700))
- [Ensure shared group members lose project access after group deletion](gitlab-org/security/gitlab@4a7b8203776b719c06186c1b189a8cf21572fcd4) ([merge request](gitlab-org/security/gitlab!1684))
- [Fix stored XSS vulnerability in Datadog settings form](gitlab-org/security/gitlab@0906814af604e7fcab54a96bccadcba11207387d) ([merge request](gitlab-org/security/gitlab!1671))
- [Inherit user external status while creating project bots](gitlab-org/security/gitlab@d5a26c4145d917b5b49e207e03669d2b7e4ee617) ([merge request](gitlab-org/security/gitlab!1665))
- [Escape issue reference and title for Jira issues](gitlab-org/security/gitlab@4153444b76421ddf3a7fd21f1fc0500700a4e263) ([merge request](gitlab-org/security/gitlab!1662)) **GitLab Enterprise Edition**
- [Require sign in for .keys endpoint on non-public instances](gitlab-org/security/gitlab@b090b3f6dee6d21d93595c5e46e6c5c7fc30f1fb) ([merge request](gitlab-org/security/gitlab!1658))
- [Only create jira connect NS subscriptions for admins](gitlab-org/security/gitlab@3f2040c0e2c90f3fcafdbf0f86bd2591bd458dff) ([merge request](gitlab-org/security/gitlab!1648))
- [Prevent non-admins from configuring Jira connect app](gitlab-org/security/gitlab@fa864c0a2eaf450033f4c594cea07d9f24144cd6) ([merge request](gitlab-org/security/gitlab!1644))

## 14.1.3 (2021-08-17)

### Fixed (2 changes)

- [Geo 2.0 Regression - Add ability to remove primary](gitlab-org/gitlab@1635f3d07d421edd2a83be109d7c54635aa4f58c) ([merge request](gitlab-org/gitlab!68383)) **GitLab Enterprise Edition**
- [[RUN AS-IF-FOSS] AS Fix SAML SSO login redirects not working](gitlab-org/gitlab@7b551e3d2a4ba6127549c613ee95e2c12c014b90) ([merge request](gitlab-org/gitlab!68383)) **GitLab Enterprise Edition**

### Changed (1 change)

- [Resolve "operator does not exist: integer[] || bigint in...](gitlab-org/gitlab@99e6457b6d9d39805dc7758c47091cf6ad0f2bdd) ([merge request](gitlab-org/gitlab!68383))

## 14.1.2 (2021-08-03)

### Security (19 changes)

- [Add project member validation for domain limitation](gitlab-org/security/gitlab@d17016dde463811c81a22c07aeab817ff7b5757c) ([merge request](gitlab-org/security/gitlab!1564))
- [Hide project-level CI/CD Analytics for Guests](gitlab-org/security/gitlab@ce3b41daadd795e906b5bbbec424a494c491a1d4) ([merge request](gitlab-org/security/gitlab!1600))
- [Only allow invite to be accepted by user with matching email](gitlab-org/security/gitlab@9d9e439c6a923fa4791a056e599c7b7e76de59a1) ([merge request](gitlab-org/security/gitlab!1632))
- [Add html escaping for default branch name](gitlab-org/security/gitlab@549101007452bd43d866d314b1c787120cfcb36a) ([merge request](gitlab-org/security/gitlab!1630))
- [Configure OmniAuth to use GitLab AppLogger](gitlab-org/security/gitlab@0b234f0058bbaa0415ab43182761757c332764d1) ([merge request](gitlab-org/security/gitlab!1615))
- [Add permissions check to pipelines#show action](gitlab-org/security/gitlab@6901d52d5265d126419e78848344ae9a886ee1a7) ([merge request](gitlab-org/security/gitlab!1612))
- [Prevent impersonation in gitlab-shell SSH certs](gitlab-org/security/gitlab@82a878ba276c6500af5aa3d951819240535127de) ([merge request](gitlab-org/security/gitlab!1609))
- [Fix Protected Environment Accesses Cleanup](gitlab-org/security/gitlab@0c954547dbdee6a47fc755eebef0882852080579) ([merge request](gitlab-org/security/gitlab!1606)) **GitLab Enterprise Edition**
- [Use oauth_app id instead of uid](gitlab-org/security/gitlab@9c49cbbbc730eb16ef109c1f1fc1b167768d5dd3) ([merge request](gitlab-org/security/gitlab!1603)) **GitLab Enterprise Edition**
- [Block impersonation token use if it is not permitted](gitlab-org/security/gitlab@1a73b228549dfe1fe98f44a8cee8e3ebcc36d841) ([merge request](gitlab-org/security/gitlab!1583))
- [Fix XSS in Mermaid Markdown rendering](gitlab-org/security/gitlab@6bff57b10739c42d177371dbf44143d92de1e595) ([merge request](gitlab-org/security/gitlab!1488))
- [Do not show email address in error message](gitlab-org/security/gitlab@fdee78b193d9744253c7b7d671247cc50175c643) ([merge request](gitlab-org/security/gitlab!1596)) **GitLab Enterprise Edition**
- [Updates oauth to 0.5.6](gitlab-org/security/gitlab@bfa3de880659b0156cf8c2a7085b1705596380a4) ([merge request](gitlab-org/security/gitlab!1592))
- [Fix tag ref detection for pipelines](gitlab-org/security/gitlab@87a03ffd263ad153a911e14512cb7776b98a435d) ([merge request](gitlab-org/security/gitlab!1591))
- [Disallow non-members to set issue metadata on issue create](gitlab-org/security/gitlab@abe9d660ce3314c1540ec20b3a0640e623c56ecc) ([merge request](gitlab-org/security/gitlab!1586))
- [Prevent guests from linking issues with errors](gitlab-org/security/gitlab@4a74667407b725176c4722e86bba3f942ffc9487) ([merge request](gitlab-org/security/gitlab!1587))
- [Filter todos whose target users no longer have access to](gitlab-org/security/gitlab@a05dd90c43ae84bb37956217d9cf4effd1edae50) ([merge request](gitlab-org/security/gitlab!1556))
- [Remove impersonation token from api response for non-admin user](gitlab-org/security/gitlab@928eaf1b82d45fbfa0d82b6515d192453b944ab9) ([merge request](gitlab-org/security/gitlab!1565))
- [Restrict access to instance-level security features for reporters](gitlab-org/security/gitlab@d4097341cede050e0066fa2a5445cbf51a1cc1bd) ([merge request](gitlab-org/security/gitlab!1561)) **GitLab Enterprise Edition**

## 14.1.1 (2021-07-28)

### Added (1 change)

- [RackAttack: extend basic authentication detection for rate limiting](gitlab-org/gitlab@ad521c88bfa8da185380397aa2e6e8972a28b04e) ([merge request](gitlab-org/gitlab!66726))

### Fixed (3 changes)

- [Prevent terms from being created if blank](gitlab-org/gitlab@29e5ebe23869cfe1325d8f7ab2ec17a3a8670f61) ([merge request](gitlab-org/gitlab!66726))
- [Fix: Sidekiq workers delete each other's metrics](gitlab-org/gitlab@d6d8ed55392a90cc55aa6213ebae80008d0df3e0) ([merge request](gitlab-org/gitlab!66726))
- [Resolve "Bulk dismissal checkboxes don't appear on group vulnerability report"](gitlab-org/gitlab@77b2cf8b935aba08f23c00cf5fdc746849a65e74) ([merge request](gitlab-org/gitlab!66726)) **GitLab Enterprise Edition**

### Other (1 change)

- [Revert backfill on ci_build_trace_sections](gitlab-org/gitlab@a67a8d734440d50c5fdbb0c559b5d2a2f6e48fae) ([merge request](gitlab-org/gitlab!66726))

## 14.1.0 (2021-07-21)

### Added (123 changes)

- [Add ability to set `squash_option` in the Project API](gitlab-org/gitlab@0cd893d72f410351411563e54af9e1d3f6fd789f) ([merge request](gitlab-org/gitlab!66122))
- [Add ref to pipeline graphql schema](gitlab-org/gitlab@4f4f2ec9adf86f841828b87f39639684ee2051f0) ([merge request](gitlab-org/gitlab!66241))
- [Upsell the GitLab Managed Terraform state if the repo contains `.tf` files](gitlab-org/gitlab@e2763f345fde0232092e6b099550c715c503e03e) ([merge request](gitlab-org/gitlab!65870))
- [Add mailgun endpoint for receiveing permanent failures](gitlab-org/gitlab@af2a6a81b92110c27da08528c5ed5dfe1ebf3f7d) ([merge request](gitlab-org/gitlab!65078))
- [Add error tracking collector](gitlab-org/gitlab@90e16440fc02e74d426a8c023a2e6a0f9d430990) ([merge request](gitlab-org/gitlab!65767))
- [Add Vulnerability Management metric for Devops Adoption API](gitlab-org/gitlab@4ef341255b5620a68a9ee3b4f8a570bac0bb1202) ([merge request](gitlab-org/gitlab!66081))
- [Allow immediate deletion of projects](gitlab-org/gitlab@1752841832fcbe88bd9da3b3720697bcce2be9dc) ([merge request](gitlab-org/gitlab!65522)) **GitLab Enterprise Edition**
- [Make database changes to persist false_positive information](gitlab-org/gitlab@10ff49e8bca5a0510fc2599bf378f1aecbe16394) ([merge request](gitlab-org/gitlab!65573))
- [Added user_cap to setting update service](gitlab-org/gitlab@f88b2f61621c4177adbd3ac68fa7e53f95aab811) ([merge request](gitlab-org/gitlab!65542))
- [Audit successful GPG key creation and removal](gitlab-org/gitlab@f32cc873fac3b730af86bb8095862190770174ff) ([merge request](gitlab-org/gitlab!65973)) **GitLab Enterprise Edition**
- [Enable sidekiq load balancing by default](gitlab-org/gitlab@a36a0b84264738c942363798a9dab3a6b51895a7) ([merge request](gitlab-org/gitlab!65669))
- [Add Pipeline Editor branch selector](gitlab-org/gitlab@13b69f776686e98fa0752c303aebb8c64320c264) ([merge request](gitlab-org/gitlab!61793))
- [Introduce multiple oncall schedules feature](gitlab-org/gitlab@643a821b2314347b6932a36642ab9a77271652e8) ([merge request](gitlab-org/gitlab!65827)) **GitLab Enterprise Edition**
- [Track secure scans](gitlab-org/gitlab@4e38000304a5f900bf9049fdf5e5a4de488f8bfb) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/64578)) **GitLab Enterprise Edition**
- [Redirect to the new default branch from a deleted default branch](gitlab-org/gitlab@3ab93d237c5ef8bf9be2a17d7b177dcf9aaca674) ([merge request](gitlab-org/gitlab!65469))
- [Add button to insert images in content editor](gitlab-org/gitlab@359961ca833e3b0f1f31b03dec68ab5efb2dfabe) ([merge request](gitlab-org/gitlab!63939))
- [Add support for rendering tables in content editor](gitlab-org/gitlab@51035cfad7a5b51427b4bf7f9d8398049f473dee) ([merge request](gitlab-org/gitlab!63945))
- [Release the Helm charts registry](gitlab-org/gitlab@ff3de432b40b91173490084c56092fe0178736c9) ([merge request](gitlab-org/gitlab!65768))
- [Allow configuring Redis trace chunks instance](gitlab-org/gitlab@607f6703c5136d9684a9d7176eba85bf7b3d5f19) ([merge request](gitlab-org/gitlab!65871))
- [Add warning when import url does not ends with .git](gitlab-org/gitlab@2d909b1b1477bdb5228576d46fdc4eccb0afd61b) ([merge request](gitlab-org/gitlab!65739))
- [Adds ID to group, stage, and detailed status](gitlab-org/gitlab@326a4a9d21de0ac4b29225d86f793452d7168057) ([merge request](gitlab-org/gitlab!64630))
- [Removed the compliance_dashboard_drawer feature flag](gitlab-org/gitlab@0351c9db623f5965d2015091b7bcde902c8fd740) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/65943)) **GitLab Enterprise Edition**
- [Upgrade GitLab Pages to 1.41.0](gitlab-org/gitlab@18c7524a21e8abf53f59d39aa333a6e67e5e13f5) ([merge request](gitlab-org/gitlab!66033))
- [Enable GraphQL Runner API](gitlab-org/gitlab@e6d9456e6730b21bb167b52f736a7026ba906ee5) ([merge request](gitlab-org/gitlab!65942))
- [Add Collected Data Categories Service Ping metric](gitlab-org/gitlab@ff900fe685fae48c77174598cc98247c9c144057) ([merge request](gitlab-org/gitlab!65336))
- [Show progress of an epic on epic board cards](gitlab-org/gitlab@788e814331973744e48862b4f8878b4f63dc5bf8) ([merge request](gitlab-org/gitlab!64622)) **GitLab Enterprise Edition**
- [Add graphql mutation to enable dependency scanning](gitlab-org/gitlab@b342443ef2e9cd11ca258d335f7cc12a1877d30e) ([merge request](gitlab-org/gitlab!64710)) **GitLab Enterprise Edition**
- [Enable sec_dependency_scanning_ui_enable by default](gitlab-org/gitlab@132a5d6fdb71921733d6bd0c08a2dc3d577398af) ([merge request](gitlab-org/gitlab!58363)) **GitLab Enterprise Edition**
- [Add policy type filter](gitlab-org/gitlab@2a791915afc4afe061f1be42c5f7bb3386c1f0fc) ([merge request](gitlab-org/gitlab!65500)) **GitLab Enterprise Edition**
- [Adds audit event when compliance framework changed](gitlab-org/gitlab@6f7186c52af863637d445ac3c8f8f3005622effb) ([merge request](gitlab-org/gitlab!65343)) **GitLab Enterprise Edition**
- [Allow copying Epic reference from sidebar](gitlab-org/gitlab@442aa2b51b46490ccfd6cb0bd2b8c133da5d48b7) ([merge request](gitlab-org/gitlab!65550)) **GitLab Enterprise Edition**
- [Audit successful key destroy action](gitlab-org/gitlab@e2943e7199d3139f8d279c95a21ed5621412480d) ([merge request](gitlab-org/gitlab!65615)) **GitLab Enterprise Edition**
- [Add observability to Snowplow tracking](gitlab-org/gitlab@fd135d450a1b9a2bbc56ae7f0383605975010574) ([merge request](gitlab-org/gitlab!65664))
- [Support providing kind to internal Network Policies edit API](gitlab-org/gitlab@b007a9ba5311b27983f34db9e1ac9122b7e223bf) ([merge request](gitlab-org/gitlab!65476)) **GitLab Enterprise Edition**
- [Add Running Container Scanning CI Template](gitlab-org/gitlab@f22a8edfe14d47597e02e42dca095356805e007a) ([merge request](gitlab-org/gitlab!64220)) **GitLab Enterprise Edition**
- [Add pause and resume to background migrations](gitlab-org/gitlab@32f6ba0477c42e5ec7acb47c137c2170440a7abf) ([merge request](gitlab-org/gitlab!65512))
- [Display Helm packages in the package registry](gitlab-org/gitlab@e14e343debcc31ab0a8258fd986fae9f766b7377) ([merge request](gitlab-org/gitlab!65688))
- [Feat(Blob): Add CSV render support for Blob Viewer](gitlab-org/gitlab@ccc0d8ae4892f8ee87e9ba2ae5ff91d7fab70f43) ([merge request](gitlab-org/gitlab!65050))
- [Added user_cap column to namespace_settings](gitlab-org/gitlab@672c54a0b6b49f2aa49bd5af9837ae0156f1f2b8) ([merge request](gitlab-org/gitlab!65470))
- [Wiki repositories use default branch when creating the repo](gitlab-org/gitlab@e1743a5e79b1c1e43390a4794f4ee1a817dacd22) ([merge request](gitlab-org/gitlab!65221))
- [Allow sort by popularity for issues via GraphQL](gitlab-org/gitlab@89de38a6bbb8efdb4ec088782c885b3027ea05f7) ([merge request](gitlab-org/gitlab!65323))
- [Allow sort by blocking issues via GraphQL](gitlab-org/gitlab@552576ffe9659ce790f8e10f8423b5adba7e1234) ([merge request](gitlab-org/gitlab!65323)) **GitLab Enterprise Edition**
- [Expose GraphQL query complexity score](gitlab-org/gitlab@8eefd99c0ae9d9fdc94148a090695fb2458bd4b8) ([merge request](gitlab-org/gitlab!52448))
- [Extend NetworkPolicy GraphQL API with `Environments` field](gitlab-org/gitlab@77a1cab8963fbfbcfc9cca2837800c021e2f0b29) ([merge request](gitlab-org/gitlab!65314)) **GitLab Enterprise Edition**
- [Remove ff_external_status_checks feature flag](gitlab-org/gitlab@22cccda58751a0e3aad78ee2fbe4bb43927fbce7) ([merge request](gitlab-org/gitlab!65053)) **GitLab Enterprise Edition**
- [Accept GitHub source highlight URL argument format](gitlab-org/gitlab@c87dfa3fcf89f23f756a18fd178c9bde82169e19) ([merge request](gitlab-org/gitlab!65453))
- [Add emoji name to tooltip](gitlab-org/gitlab@9022559ef4a0465c51d67175d3f61ddd02f19f8b) ([merge request](gitlab-org/gitlab!65439))
- [Do not export certain models when using Relations Export API](gitlab-org/gitlab@7c5cef46687ec0fb2a4344509d393c46399b52c4) ([merge request](gitlab-org/gitlab!65347))
- [Add Coverage fuzzing to DevopsAdoption API](gitlab-org/gitlab@f1d4e0c5dde9a8b6934e61f527227746d2c314c4) ([merge request](gitlab-org/gitlab!65253))
- [Extend Plan limits API with `terraform_module_max_file_size`](gitlab-org/gitlab@07804f5472e897ae7d70465b33e2a0282d42f5b0) ([merge request](gitlab-org/gitlab!65425))
- [Add dependency scanning to DevopsAdoption API](gitlab-org/gitlab@0b0198255f3b10606458f4d0996c1550b9d4a790) ([merge request](gitlab-org/gitlab!64624))
- [Add Bulk Imports API to view user initiated imports](gitlab-org/gitlab@c10058e690c2de140805baa4a08a15c47e5a381a) ([merge request](gitlab-org/gitlab!64335))
- [Allow sort and expose expired field for milestones](gitlab-org/gitlab@771d9576f5dc27e30fbc2df990b22764bfb028f8) ([merge request](gitlab-org/gitlab!64572))
- [Add group-level DORA metrics to GraphQL endpoint](gitlab-org/gitlab@b23f814969a4691a3651030483558d334641f0bc) ([merge request](gitlab-org/gitlab!65279)) **GitLab Enterprise Edition**
- [Make the variable type for the GitLab CI secret configurable](gitlab-org/gitlab@0ff59c782a585ad3a2b9a2bdf6626a31c5ea145b) ([merge request](gitlab-org/gitlab!54858)) **GitLab Enterprise Edition**
- [Add GitLab revision to Prometheus metric](gitlab-org/gitlab@36046c63b2dea241070c91a07a7650a3b65bec55) ([merge request](gitlab-org/gitlab!65276))
- [Add project-level DORA metrics to GraphQL endpoint](gitlab-org/gitlab@ef0cffc8119734c6639e2ab8d8671e019b508d50) ([merge request](gitlab-org/gitlab!64961)) **GitLab Enterprise Edition**
- [Remove project from Job Token Scope via GraphQL](gitlab-org/gitlab@c20de7a97f482e312ddf842e45a5098f8455a4f3) ([merge request](gitlab-org/gitlab!64522))
- [Add timezone to web operations](gitlab-org/gitlab@868f0c45a9dbdd6d110f9f7d637946981971aa6d) ([merge request](gitlab-org/gitlab!64084))
- [Add CIJobToken project allow list resolver](gitlab-org/gitlab@08e8188af04a8f2fafe86190a7dc90a252d23ad1) ([merge request](gitlab-org/gitlab!64095))
- [Add ability to search for cluster image scanning jobs](gitlab-org/gitlab@3579088ee97b2d1a26e3d2dbba726c3a9b7f61a6) ([merge request](gitlab-org/gitlab!64616)) **GitLab Enterprise Edition**
- [Add target branch in pipeline editor for blank projects](gitlab-org/gitlab@c9e9a6254dc35cd5892a3885c1284f0f0fa06fa2) ([merge request](gitlab-org/gitlab!64575))
- [Add jobCount and projectCount to GraphQL CiRunner](gitlab-org/gitlab@af9e0ea5e9a532b373d89db29edf5899eaec88e6) ([merge request](gitlab-org/gitlab!64117))
- [Remove gitlab_experiment_middleware feature flag](gitlab-org/gitlab@62d5345c70cad5a2db32042d1898716e611d8dcd) ([merge request](gitlab-org/gitlab!65081))
- [Add instance-level audit event when admin status changes](gitlab-org/gitlab@6724b3e03cc3a9aca261cec28b9e3db92a1517a6) ([merge request](gitlab-org/gitlab!65168)) **GitLab Enterprise Edition**
- [Add link to admin area on project view and group view](gitlab-org/gitlab@ded9a9d5716f3e1c63f39f2d73ca16134ed0210e) ([merge request](gitlab-org/gitlab!63410))
- [Add support for legacy blob viewers](gitlab-org/gitlab@440dd4f481a2a52776a04f263d1c49822e633890) ([merge request](gitlab-org/gitlab!64839))
- [Preserve user authorship during bulk imports](gitlab-org/gitlab@31245e13593a3e57385e3384877c0aa3696372ad) ([merge request](gitlab-org/gitlab!64908))
- [Add usage ping features frontend checkboxes](gitlab-org/gitlab@295bd62308977822e2fecdf6e5d518f5bcb99024) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/64186))
- [Remove kubernetes_agent_on_gitlab_com feature flag](gitlab-org/gitlab@dfdf249cb7943bcbbbf7e03983253554960812e1) ([merge request](gitlab-org/gitlab!60081))
- [Add system note when escalating to users](gitlab-org/gitlab@6bd709f4a1e4bc674d095c6b7941bc93bd323b3e) ([merge request](gitlab-org/gitlab!64899)) **GitLab Enterprise Edition**
- [Remove project_finder_similarity_sort feature flag](gitlab-org/gitlab@abb677ddbe651da7d04c876cc9a4667ca94b58e3) ([merge request](gitlab-org/gitlab!64361))
- [Track usage data for Network Policies UI](gitlab-org/gitlab@4a15309619053a4e20f2f32003d6a8444e9821ba) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/64731)) **GitLab Enterprise Edition**
- [Add compliance_frameworks_with_pipeline to usage ping](gitlab-org/gitlab@fd420b4799d32066d0896a5f6e3747a60b3c0958) ([merge request](gitlab-org/gitlab!64601)) **GitLab Enterprise Edition**
- [Remove ci_quota_check_on_retries feature flag](gitlab-org/gitlab@0ab0678dc1a0a1a934b66948770d49b725511b5b) ([merge request](gitlab-org/gitlab!65044)) **GitLab Enterprise Edition**
- [Add scan execution policies to the policy list](gitlab-org/gitlab@aa2cf5e2afd6c23a37aa9340b82dc4312007b80f) ([merge request](gitlab-org/gitlab!64783)) **GitLab Enterprise Edition**
- [Allow passing PAT name and scopes via the URL](gitlab-org/gitlab@e4e1292d8cd4c38fa0e5332ed7debdf7b7639b74) ([merge request](gitlab-org/gitlab!64897))
- [Add summary to timelogs](gitlab-org/gitlab@3f649999296a6314aadd99676ea324b2063f3225) ([merge request](gitlab-org/gitlab!64552))
- [Allow specifying an access level for Project Access Tokens](gitlab-org/gitlab@962c6b39c32a86ef4896112e5b47886747a14708) ([merge request](gitlab-org/gitlab!63725))
- [Send purchase source to customers API](gitlab-org/gitlab@49237198c8a72abf679ceda15b1608434bb78e7e) ([merge request](gitlab-org/gitlab!64905)) **GitLab Enterprise Edition**
- [Sync destruction between requirements and issues](gitlab-org/gitlab@1c18084384954d6d3bdf1a41a9424d94a1896a09) ([merge request](gitlab-org/gitlab!64291)) **GitLab Enterprise Edition**
- [Add CI/CD templates picker for empty pipelines page](gitlab-org/gitlab@7aefdbc42ce4c10a9c1cbaf1d7584ebaa4a074a0) ([merge request](gitlab-org/gitlab!64200))
- [Save last_synced_at on licenses table](gitlab-org/gitlab@116158c93f8839688cb2f69b1f4c606d1e91cbfa) ([merge request](gitlab-org/gitlab!64656))
- [Add validate account button on CI/CD shared runners page](gitlab-org/gitlab@1ac97dcf31f72a3e8cbb4b3e5c01d87beea798cc) ([merge request](gitlab-org/gitlab!64861)) **GitLab Enterprise Edition**
- [Relate issues and requirements](gitlab-org/gitlab@a9c39abbf219cc0d73676df316e94ee299c581ae) ([merge request](gitlab-org/gitlab!64189))
- [Add present_on_default_branch to Vulnerabilites](gitlab-org/gitlab@8f7c762b0e153438459bf8299db7fa4277e1b47d) ([merge request](gitlab-org/gitlab!64704))
- [Helm charts index API endpoint](gitlab-org/gitlab@6fd633c24f7d7e8a79e57439ab6056afb22db39a) ([merge request](gitlab-org/gitlab!62757))
- [Add backup logger class](gitlab-org/gitlab@820d264e8d0a7ae564ad825ccd4442ade5242a17) ([merge request](gitlab-org/gitlab!63832))
- [Add configuration for locating gitaly-backup](gitlab-org/gitlab@abc8d061a375e268805df27c2e8a1cc0693f9ecb) ([merge request](gitlab-org/gitlab!64834))
- [Adding raw_plain_data type to snippets](gitlab-org/gitlab@d7cb66c01ddfd22f9962cca5402addd230367451) ([merge request](gitlab-org/gitlab!64243))
- [Allow to query discussion design on GraphQL](gitlab-org/gitlab@25613d74ac74a9f1b697e00d89499fe2f21e746c) ([merge request](gitlab-org/gitlab!64550))
- [Converts the diff row component into a functional component](gitlab-org/gitlab@61b90085ef4d39c5280cc7939c0e5f0c83e281e4) ([merge request](gitlab-org/gitlab!63854))
- [Add `state` argument for the PipelineSecurityReportFindingsResolver](gitlab-org/gitlab@d550e65acc7526ad94938ac329f07991d58f9f1c) ([merge request](gitlab-org/gitlab!64762)) **GitLab Enterprise Edition**
- [Add NOT filtering to epic roadmap filtered search](gitlab-org/gitlab@8b62510509261edf35725d114b7003bc9e426a85) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/64483)) **GitLab Enterprise Edition**
- [Show access level of Project Access Token in UI and API](gitlab-org/gitlab@1df3db0851c333b055deca10079a721265ee2763) ([merge request](gitlab-org/gitlab!64681))
- [Add CI variable CI_MERGE_REQUEST_APPROVED](gitlab-org/gitlab@dff9601fa5b641831d266ffa8a299d5ac8f4057f) ([merge request](gitlab-org/gitlab!64677)) **GitLab Enterprise Edition**
- [Add compliance framework label to compliance dashboard](gitlab-org/gitlab@83d33fe5b54ce5c03d21db49a08ff3f6eefeda89) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/64283)) **GitLab Enterprise Edition**
- [Display Feature Flags Related to Issues](gitlab-org/gitlab@5b79efa72311d3846f003566123115d71e61369c) ([merge request](gitlab-org/gitlab!64538)) **GitLab Enterprise Edition**
- [Update styling on policy editor page](gitlab-org/gitlab@5a8461052e305484920e2a349f1385215bba0c96) ([merge request](gitlab-org/gitlab!62970)) **GitLab Enterprise Edition**
- [Remove ci_drop_new_builds_when_ci_quota_exceeded feature flag](gitlab-org/gitlab@9dcfedfe8dc97531a67b203e70d5f146f70c8e62) ([merge request](gitlab-org/gitlab!64709)) **GitLab Enterprise Edition**
- [Adds sha argument to lint](gitlab-org/gitlab@a728acee92cfb89945b3255230016045dd39cc95) ([merge request](gitlab-org/gitlab!64415))
- [Add Debian API endpoint for Packages files](gitlab-org/gitlab@8d33f75e2554b550be04ca646fcfbee55a30278d) ([merge request](gitlab-org/gitlab!64068))
- [Add option to order epics by title on list page](gitlab-org/gitlab@4474d1a6fba3efcc4374509eff072b4c3ad351d5) ([merge request](gitlab-org/gitlab!63767)) **GitLab Enterprise Edition**
- [Add wal cached counter metric](gitlab-org/gitlab@a146fc0dba73b3b193dc484c7ee43de7b8ec620f) ([merge request](gitlab-org/gitlab!64210))
- [Accept repository_update_events in SystemHooks API](gitlab-org/gitlab@d629b1a2556d73a9bbc7d6dd8149028d202041df) ([merge request](gitlab-org/gitlab!64670))
- [Added omniauth_user check when verifying user cap](gitlab-org/gitlab@21cafcbdcce25424cfcaca5356fa1fef3d43a902) **GitLab Enterprise Edition**
- [Add the ability to deep link into group/project member tabs](gitlab-org/gitlab@db589f28af5f997068da2a6f75e27b3cf9611298) ([merge request](gitlab-org/gitlab!64365))
- [Allow changing AdditionalPack namespace](gitlab-org/gitlab@d8d3b217f72f75a3332163d2ac4a90be00621492) ([merge request](gitlab-org/gitlab!64212)) **GitLab Enterprise Edition**
- [BulkImports: Import Group Avatar](gitlab-org/gitlab@0f1d882377147e1977beceb34f19cfee42f9acea) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/62714))
- [Allow admins to limit registration of project and group runners](gitlab-org/gitlab@6309e13bdbb8fbe42849a8e2f78012944302f45a) ([merge request](gitlab-org/gitlab!61407))
- [Populate `latest_pipeline_id` values for `vulnerability_statistics`](gitlab-org/gitlab@917d469e906ff2d050048005d90341b17b0e49a8) ([merge request](gitlab-org/gitlab!63451)) **GitLab Enterprise Edition**
- [Add support for horizontal rule in content editor](gitlab-org/gitlab@d4b66969d6dcc52d8adbdb574c03120faee45602) ([merge request](gitlab-org/gitlab!63943))
- [Add state of merge request diff to the entity](gitlab-org/gitlab@ac2e38224f0b67684d3ddf5f35de041f815e4ef8) ([merge request](gitlab-org/gitlab!64195))
- [Associate Build with DAST Site and Scanner profile](gitlab-org/gitlab@0c8757624e68fd90c25f1e1b26152c1f4d2c25a7) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/63362))
- [Show pronouns in user popover](gitlab-org/gitlab@7513e38b8badcf14d5a40252895e64a3dfb6c0b0) ([merge request](gitlab-org/gitlab!63611))
- [Create API to update upcoming reconciliations](gitlab-org/gitlab@217e570c5691f683171e55fa17edaba1a4b3618b) ([merge request](gitlab-org/gitlab!63047)) **GitLab Enterprise Edition**
- [Add layout for "first mile"](gitlab-org/gitlab@82d09f270836a2cb843cfa2694bcfaa5317bbefe) ([merge request](gitlab-org/gitlab!62965))
- [Adds status to StageType in gql](gitlab-org/gitlab@ce690aaf94132b3f584cc2de892b2af684d797a9) ([merge request](gitlab-org/gitlab!61177))
- [Expose SAST & DAST devops adoption metrics](gitlab-org/gitlab@430037a8ebe2104000c7c2b1a24127e1227a17f9) ([merge request](gitlab-org/gitlab!63868)) **GitLab Enterprise Edition**
- [Allow sorting by title in REST/GraphQL API](gitlab-org/gitlab@cec733fe115b2a8ee3479ea0195b20e677741e2a) ([merge request](gitlab-org/gitlab!63756)) **GitLab Enterprise Edition**
- [Add in-product marketing emails](gitlab-org/gitlab@bf1b79e99157adfec0e605654700ad8db43afc71) ([merge request](gitlab-org/gitlab!64109))
- [Commit registration invite page to product](gitlab-org/gitlab@9fef92d31c71a2711b3a47c419339447591866dd) ([merge request](gitlab-org/gitlab!64001))
- [Support specifying a milestone for MR via push options](gitlab-org/gitlab@be94b8a3c57405115802cfc8cec71a6eacf9ca3c) ([merge request](gitlab-org/gitlab!63960))

### Fixed (150 changes)

- [Fix error when creating or deleting a board list](gitlab-org/gitlab@5b348fb06bd81719629b2a960addce38334ac15b) ([merge request](gitlab-org/gitlab!66297))
- [Skip LFS fragment on redirect](gitlab-org/gitlab@559e7a5c1ce499eb98e1ec183159b13d0437d2fe) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/65751))
- [Fix scanner comparison error](gitlab-org/gitlab@e582ef4f33fcdab9e133e1cc42e4677534b688c4) ([merge request](gitlab-org/gitlab!66322))
- [Fix background color of markdown code in dark mode](gitlab-org/gitlab@fc328c70613f849a27cec7b3ac4ea0611d4fdb19) ([merge request](gitlab-org/gitlab!66254))
- [Fix transposed rows and cols](gitlab-org/gitlab@a1f3afb43df702a4040604e1930f9110ccd2854b) ([merge request](gitlab-org/gitlab!66287))
- [Fix wiki repositories with wrong HEAD](gitlab-org/gitlab@4bb1d0e17713c993594882f1cf15c31838a83b06) ([merge request](gitlab-org/gitlab!66232))
- [Fix public selection of pages permissions](gitlab-org/gitlab@3333b06161a9200ecc8d0af9ee8b0ecf8939f833) ([merge request](gitlab-org/gitlab!66238))
- [Geo: Replicate the HEAD ref](gitlab-org/gitlab@30667e5d9ca4b83916ad539e0c2dc5245637d2d1) ([merge request](gitlab-org/gitlab!65783)) **GitLab Enterprise Edition**
- [Remove useless delete button in group settings](gitlab-org/gitlab@feaf24e7c656c7ef418f0ec478f8401e4acfcd0a) ([merge request](gitlab-org/gitlab!66067)) **GitLab Enterprise Edition**
- [Allow cleartext communication with KAS in production](gitlab-org/gitlab@81c5fdae75585897b1a3c8a6b9da55363a2c3c23) ([merge request](gitlab-org/gitlab!66135))
- [Automatically create integration webhooks when missing](gitlab-org/gitlab@c2259e5e3129e0e9dc9c00a996f4fa956596c8cb) ([merge request](gitlab-org/gitlab!65577))
- [Fix snippet url helper when repository is not present](gitlab-org/gitlab@e702e4c91d836e331dc0022d319159c0448609e6) ([merge request](gitlab-org/gitlab!66149))
- [Adjust Groups API call used in Search Group Projects select](gitlab-org/gitlab@4bb8c88e894d16ef69fb30bf894964aaeee5926d) ([merge request](gitlab-org/gitlab!66172))
- [Fix snippets display issues on mobile devices](gitlab-org/gitlab@8986231996e52334eb913d9b7ab05b255cf729e4) ([merge request](gitlab-org/gitlab!65685))
- [Fixed the header color in fly-outs for Dark mode](gitlab-org/gitlab@c0f932411ac4c537e5c6c8165a2585f305f3e619) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/66138))
- [Fixed association between Finding, Finding Links](gitlab-org/gitlab@2b5ac0a8d5e242c03ac0eafc76e59ea8383a32ca) ([merge request](gitlab-org/gitlab!66103)) **GitLab Enterprise Edition**
- [Correct check for displaying SubEpic counts on boards](gitlab-org/gitlab@b9f4933910b5cce9ace8b0b99e6e415505608b5f) ([merge request](gitlab-org/gitlab!65756)) **GitLab Enterprise Edition**
- [Preload correct latest test report for requirements](gitlab-org/gitlab@d7f4636639c122ab5e6ac1f8eac5bdded22e1d76) ([merge request](gitlab-org/gitlab!66091))
- [Fix "Confirm user" button on tabs other than "Account"](gitlab-org/gitlab@d1f311c119f92222af88e2867736df78a93cb5b1) ([merge request](gitlab-org/gitlab!66004))
- [Add trigger_source for empty page tracking event](gitlab-org/gitlab@938003e8e271b3769ca03dd8e75ca8da00c43d81) ([merge request](gitlab-org/gitlab!66083))
- [Fix GET requests from graphql client when using relative url](gitlab-org/gitlab@19ec2c8da4c92a1354701e58b86947d57b1e844e) ([merge request](gitlab-org/gitlab!66053))
- [Ensure pages visibility levels are correct](gitlab-org/gitlab@0e5493b618f12b243a90725423447ec40c376fe9) ([merge request](gitlab-org/gitlab!65723))
- [Fix the write permission of the Releases with Protected Tag](gitlab-org/gitlab@229009d4bf23bab1b8b8972757952edaf945900a) ([merge request](gitlab-org/gitlab!66042))
- [Fix labelFilterParam value in issuable_list_root](gitlab-org/gitlab@a683a0f82816c70b911ccdb7d03c6b89cd1ac81a) ([merge request](gitlab-org/gitlab!65949)) **GitLab Enterprise Edition**
- [Fix filePath not being stored in GraphQL log tree cache](gitlab-org/gitlab@f8d175ef7a6384d1a424ecde786ae8b0798e4804) ([merge request](gitlab-org/gitlab!66029))
- [Fix user popovers in design management discussions](gitlab-org/gitlab@61b5dce3aef97fa46b063b971e53881925301633) ([merge request](gitlab-org/gitlab!66027))
- [Update confirmation button text in edit modals](gitlab-org/gitlab@2f159fd7180d248b17608ce4d81c6f3028fed6f4) ([merge request](gitlab-org/gitlab!65991)) **GitLab Enterprise Edition**
- [Revert to use merge requests count for group view](gitlab-org/gitlab@6ac1224121cd58599735b9ef9578ce0285d9508c) ([merge request](gitlab-org/gitlab!64640))
- [Remove transaction when migrating diff commits](gitlab-org/gitlab@650a6dee0aab0fa76fa19d0ba4f9ac67682e2772) ([merge request](gitlab-org/gitlab!65746))
- [Replace `deprecated_project_avatar` in `create_issue_form.vue`](gitlab-org/gitlab@2423c5c2f745e5eeacca9903d9029c04738c8d02) ([merge request](gitlab-org/gitlab!65842)) **GitLab Enterprise Edition**
- [Fix validation method regarding MIME type keys](gitlab-org/gitlab@0b4e1788d14edaf16e3ce999fd0520b3d2467e01) ([merge request](gitlab-org/gitlab!65954))
- [Replace the success btn to the confirm btn in the preferences page](gitlab-org/gitlab@4958268382f93f78e0e3afaa0d3934d59739fba2) ([merge request](gitlab-org/gitlab!65836))
- [Use ProjectAvatar in `frequent_items_list_item.vue`](gitlab-org/gitlab@651b52efc70d761c95e465ad8ac1712177b3fb98) ([merge request](gitlab-org/gitlab!65857))
- [Strip whitespace from GraphQL queries using GET](gitlab-org/gitlab@d88abce55e9cc61f531e77aa3a6d6930d052c767) ([merge request](gitlab-org/gitlab!65564))
- [Make job_token_scope_enabled project setting false by default](gitlab-org/gitlab@024ec9e077cc26a58b3ef1c5ad8fc5d1f0b941b4) ([merge request](gitlab-org/gitlab!64962))
- [Use namespaced security report type for Cluster Image Scanning](gitlab-org/gitlab@9e4b3bc018fa7d27ab2e1eaca9bda4fd687a9237) ([merge request](gitlab-org/gitlab!65802)) **GitLab Enterprise Edition**
- [Fix race condition on container repository create](gitlab-org/gitlab@f8ae33ca2ae2f15b2e78b4d29329700f733304b4) ([merge request](gitlab-org/gitlab!65358))
- [Fix WebIDE image being base64](gitlab-org/gitlab@89256d4df66e1cc34ad6b4c5789b7e2dd59da329) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/65165))
- [Fix Issue check_for_spam? for bots](gitlab-org/gitlab@bf0bad9d9f9f403b79676cf77f7a2b3fbe7bc716) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/65661))
- [Fix scan execution policy selection](gitlab-org/gitlab@203618037e1ed848cb0b912fd03c0dbf1f38d71a) ([merge request](gitlab-org/gitlab!65553)) **GitLab Enterprise Edition**
- [Advanced Search: Fix inaccessible ES server error](gitlab-org/gitlab@31e6e995a6f287ea08e12d18c933dcebef223cc7) ([merge request](gitlab-org/gitlab!65731)) **GitLab Enterprise Edition**
- [Migrate drawer titles to title slot](gitlab-org/gitlab@efc552c893c919234f6a8018d9f50f08572cde2f) ([merge request](gitlab-org/gitlab!65587))
- [Fix timebox charts events computing](gitlab-org/gitlab@d6d9c48b8e2d88545c7cd885eb0c88788ecb4f78) ([merge request](gitlab-org/gitlab!65737)) **GitLab Enterprise Edition**
- [Fix bug in DORA GraphQL endpoint](gitlab-org/gitlab@5d6ad2c0624e1a59e6670d9648a4de5c34bb2cd2) ([merge request](gitlab-org/gitlab!65653)) **GitLab Enterprise Edition**
- [Correctly positioned the is-above flyouts](gitlab-org/gitlab@8d11496482852aa16c0d3bfa95a466fe13111eaf) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/65735))
- [Add another guard clause to password_expired_if_applicable](gitlab-org/gitlab@366b1d7457e12f1454c1001f93d7d43330ddd59d) ([merge request](gitlab-org/gitlab!65575))
- [Allow Bulk Import to use relative GitLab URL](gitlab-org/gitlab@8b871c337bcbebff0924ca80ec4a8ec71fd1dadb) ([merge request](gitlab-org/gitlab!65444))
- [Hide Renew button if less than 15 days for term end date](gitlab-org/gitlab@2fbdc5f2e88d9d1a0049c8f4acec8da2689d9d89) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/65070)) **GitLab Enterprise Edition**
- [Fix default url for Monitor sidebar menu](gitlab-org/gitlab@9129adb35ffe0f88c2dc3732f7547fd0cf2fb849) ([merge request](gitlab-org/gitlab!65639))
- [Fix vulnerability report filter dropdown button text truncation](gitlab-org/gitlab@a65218b7f710868aca5cf21d87b38532315a8681) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/65634)) **GitLab Enterprise Edition**
- [Fixed broken ui link](gitlab-org/gitlab@991e9149b59a1490d18f673c15a90c7526bece85) ([merge request](gitlab-org/gitlab!65682))
- [Fix icon size for usage quotas and billing](gitlab-org/gitlab@0eb1ddd005256befb5d5a7f46c3fca81c011d452) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/65650)) **GitLab Enterprise Edition**
- [Fix LFS objects not downloading from Bitbucket](gitlab-org/gitlab@e2268e41fd457672a85722cde3b914088726fa47) ([merge request](gitlab-org/gitlab!65380))
- [Fix CAPTCHA modal for setting issue non-confidential](gitlab-org/gitlab@07416fdf1a8013fa57b25bee26a375a9814a5a84) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/65659))
- [Fix typo for dismissible](gitlab-org/gitlab@a218ceaf110acf2787d1a389059aa3625ca4141c) ([merge request](gitlab-org/gitlab!65656))
- [Display correct label for named-list report types](gitlab-org/gitlab@648dc48a87804e5127e2d696a229851e13fa1c60) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/65507)) **GitLab Enterprise Edition**
- [Handle git exceptions in wiki create and update services](gitlab-org/gitlab@1dd451933d9304cb3eb1b8a33f2e2a6b6520257b) ([merge request](gitlab-org/gitlab!64873))
- [Do not create audit event for failed logins on read-only DB](gitlab-org/gitlab@d073e7326aeaadfa8b38cdc170cb5ae6a8d48696) ([merge request](gitlab-org/gitlab!65504)) **GitLab Enterprise Edition**
- [Fix git clone for projects with a trailing dot over HTTP](gitlab-org/gitlab@0391bf572fb12d1c54aa155d529d7dc6fa5a1653) ([merge request](gitlab-org/gitlab!65489))
- [Always encode group path for labels API](gitlab-org/gitlab@ec59ce97c3d334ad359e460857c8c2db3293159e) ([merge request](gitlab-org/gitlab!65350)) **GitLab Enterprise Edition**
- [Return empty strings for Jira links when URL is not set](gitlab-org/gitlab@746cfabfb414ce349d36ee9b6a7127bd2c26adee) ([merge request](gitlab-org/gitlab!65547))
- [Fix pipeline count on merge request tab](gitlab-org/gitlab@014927f06255b3ea0d34f97eeef2ca6ce30b2628) ([merge request](gitlab-org/gitlab!65536))
- [Define deduplication strategy in Resource Group Worker](gitlab-org/gitlab@d26139b3d2f13a508ab9bc137031bf090513cd50) ([merge request](gitlab-org/gitlab!65233))
- [Allow users to setup Jenkins without username](gitlab-org/gitlab@9213f4935c1617e94dff360cf63397ac9ff4b18f) ([merge request](gitlab-org/gitlab!65525))
- [Hide group-level DORA charts if not licensed](gitlab-org/gitlab@672747385fb4dcbe3e522187ec72c1e4cf1d5ddd) ([merge request](gitlab-org/gitlab!65478)) **GitLab Enterprise Edition**
- [Fix uninitialized constant Audit::UpdateService](gitlab-org/gitlab@38c9fb90a4b0505aaa78e0360d7cdeadfaa810b8) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/65519)) **GitLab Enterprise Edition**
- [Add prefix to autocomplete path](gitlab-org/gitlab@c4c246d18d2c982d3327bcb811572ec2fdbaf829) ([merge request](gitlab-org/gitlab!65508))
- [Fix cache update for schedules and policies](gitlab-org/gitlab@16e8c26103334a40e5fc9224bbe3eb23fc48ceba) ([merge request](gitlab-org/gitlab!65491)) **GitLab Enterprise Edition**
- [Fix WebIDE dropdown background color](gitlab-org/gitlab@c484c192754076e904958c656160dfd80abce1ca) ([merge request](gitlab-org/gitlab!65412))
- [Add option to force notification on expired subscriptions](gitlab-org/gitlab@5a6b865695b51492bfb965564502b826b17fc16c) ([merge request](gitlab-org/gitlab!64838)) **GitLab Enterprise Edition**
- [Fix alignment issues](gitlab-org/gitlab@27b7fca56e1103adf5208024af5317f1ea8252d8) ([merge request](gitlab-org/gitlab!65351))
- [Reduce noisy code quality diff errors on MR page](gitlab-org/gitlab@f3e0148b42e448151fa56694f77c7bce96dec40a) ([merge request](gitlab-org/gitlab!64661)) **GitLab Enterprise Edition**
- [Only disable pause indexing when migration running needs indexing paused](gitlab-org/gitlab@879558dca6bb050b2381088b4a7fc577c95263b6) ([merge request](gitlab-org/gitlab!65281)) **GitLab Enterprise Edition**
- [Fix caching for pagination headers](gitlab-org/gitlab@3f4b3514cb915b3cc70b4029c312e5835f0f651c) ([merge request](gitlab-org/gitlab!64723))
- [Catch Git::CommandError in Branches::CreateService](gitlab-org/gitlab@f0e2eef5f5d58450d1b240b74fe867939b5bc9c2) ([merge request](gitlab-org/gitlab!64727))
- [Bugfix: Disable the ability from the FE to use Approver != in MR search](gitlab-org/gitlab@a85a5f55194767b064821c6979f21356bd910e7c) ([merge request](gitlab-org/gitlab!56310))
- [Raise the error when repository storage move fails](gitlab-org/gitlab@8f5a54736cc0fa0840972bcfee955e7c36c2d794) ([merge request](gitlab-org/gitlab!65292))
- [Fix PopulateLatestPipelineIds background migration](gitlab-org/gitlab@81d14eacc2fc154e7ca0df6312fd407d912c1e61) ([merge request](gitlab-org/gitlab!65280)) **GitLab Enterprise Edition**
- [Add license check to status checks rendering](gitlab-org/gitlab@f9f6f513d4defce5230be28425efb4614658b67d) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/65246)) **GitLab Enterprise Edition**
- [Fix create issue dropdown button wrapping](gitlab-org/gitlab@2e7de65c66e7dd47d1c0973d3cf7865ecabbc23c) ([merge request](gitlab-org/gitlab!65254))
- [Fix plans cards width on lg screens](gitlab-org/gitlab@77aabb5c924888ffca0b5228a21093c71218d1a9) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/65222)) **GitLab Enterprise Edition**
- [Return issue feedback from loader when there is no issue link](gitlab-org/gitlab@b8f44623bc55a3ed1abf2e6144c467e457452896) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/65191)) **GitLab Enterprise Edition**
- [Fix deploy keys not working with LFS auth check](gitlab-org/gitlab@3e4a574906486e7a9fb6fd119296810d5994a8fe) ([merge request](gitlab-org/gitlab!65205))
- [Fix review-bar-component height](gitlab-org/gitlab@1386605add9adb7a01d4c7933b4ee5e36c38c120) ([merge request](gitlab-org/gitlab!64668))
- [Use small ellipsis button in DAST saved scans and profiles](gitlab-org/gitlab@6f2f61393c1da1f06caf4bffdbede325819f5342) ([merge request](gitlab-org/gitlab!65176)) **GitLab Enterprise Edition**
- [Update a user highest role when removed from group](gitlab-org/gitlab@e443da4b8611b9cb2bd1b2f37e6c33a68b9612db) ([merge request](gitlab-org/gitlab!65164))
- [Fix wiki encoding error creating event](gitlab-org/gitlab@1d35b844bed585a3c6fcc54271c5bc86ea3446e9) ([merge request](gitlab-org/gitlab!65132))
- [Update connect_instance_spec.rb](gitlab-org/gitlab@0f88d420a65757fe5c126d2aa94bcf3d5dbf3506) ([merge request](gitlab-org/gitlab!65153))
- [Default cableBackend to authBackend](gitlab-org/gitlab@ff9bd308ebece371baef1387d4bd6aebe91af9d1) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/65068))
- [Fix double scrollbar in some dropdowns](gitlab-org/gitlab@ad8c22de839212158e6f2345437ea0bee19ff557) ([merge request](gitlab-org/gitlab!64969))
- [Wrap Labels and Members menu items with access levels checks](gitlab-org/gitlab@e3165a4d998af0717e8c00795aee6c26389770f0) ([merge request](gitlab-org/gitlab!65005))
- [Takes per page setting into account when paginate](gitlab-org/gitlab@c5c32ad2c8c52294a651de664ec93d0b0797a2c7) ([merge request](gitlab-org/gitlab!64285))
- [Show create-jira-issue when gitlab issues disabled](gitlab-org/gitlab@bcee661f9e770517ec72334d5b9e4c107e9163ca) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/64889)) **GitLab Enterprise Edition**
- [Guard Compliance CI evaluation against blank path](gitlab-org/gitlab@9706ba3a371b53958995863080b727824ac0430c) ([merge request](gitlab-org/gitlab!64994)) **GitLab Enterprise Edition**
- [Skip saving the diffs whitespace setting if the user isn't logged in](gitlab-org/gitlab@e07458f045b32dbf8a11ee11a9e749a4966d69e7) ([merge request](gitlab-org/gitlab!65094))
- [Fix Group avatar API endpoint](gitlab-org/gitlab@ea3f7bd4dcf20cedbdc2ca2543f99fc5f02fa1f1) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/64804))
- [Allow nil for remaining ci cd settings](gitlab-org/gitlab@672fc080709f158b05a7ed5a1dce4aabac12d7dd) ([merge request](gitlab-org/gitlab!64472))
- [Fix 2FA Download codes button](gitlab-org/gitlab@24fa6d1f1a2eca571362a03ed56a2ee9c1fe6760) ([merge request](gitlab-org/gitlab!64963))
- [Fix breadcrumbs and page title for 2FA page](gitlab-org/gitlab@bcabebbcb56707c30b4bbcb035b70f13adf3ef03) ([merge request](gitlab-org/gitlab!64938))
- [Fix return codes for getting an inexisting release](gitlab-org/gitlab@8e011e6674cd6d4fbb7b820aaa89baaac439352f) ([merge request](gitlab-org/gitlab!64591))
- [Show the default "default branch" in the API for empty projects](gitlab-org/gitlab@5ce07d4974b068499c85d159de2513aac3dde6be) ([merge request](gitlab-org/gitlab!64944))
- [Persist Direct Asset Path on Release Updates](gitlab-org/gitlab@6c29da3eb6b515c3d8f7ea19188b1f881f48a2f0) ([merge request](gitlab-org/gitlab!64719))
- [Fix svg logos for empty pipeline templates](gitlab-org/gitlab@d07e2ab050f4eedea6da75e618309fb98248a25f) ([merge request](gitlab-org/gitlab!64428))
- [Ensure displayNamespaceID is included](gitlab-org/gitlab@ff142eadadabf9050451f925276ea5482bf470ae) ([merge request](gitlab-org/gitlab!64904)) **GitLab Enterprise Edition**
- [Drone hook API endpoint](gitlab-org/gitlab@dd42fd2957fb10afcf10c24c0e2254dc103454fa) ([merge request](gitlab-org/gitlab!64871))
- [Fix NuGet installs with symbol packages](gitlab-org/gitlab@246b31a94ddf1ad7be87510f7b30efa3ec532e89) ([merge request](gitlab-org/gitlab!64803))
- [Change PHP template for PHP 8](gitlab-org/gitlab@c4b5950da351aad479f9515e8699eca9257f1f07) ([merge request](gitlab-org/gitlab!64863))
- [Update embedded snippet file links to open in new tab](gitlab-org/gitlab@55c6def595b1ecc640c6b713db24ebdd13277bc4) ([merge request](gitlab-org/gitlab!64219))
- [Fix typo with credit card](gitlab-org/gitlab@ac0b29c6cca7ab912460e95e1fd8f8991772f58e) ([merge request](gitlab-org/gitlab!64817)) **GitLab Enterprise Edition**
- [Fix error when loading incident issue with alert](gitlab-org/gitlab@0678a49a0cff494370d631a5f53629566ac69fcd) ([merge request](gitlab-org/gitlab!64827))
- [Fix state value in the lfs_object_registry table](gitlab-org/gitlab@6231e52db37818f56efa1f0aa19153da39ffbb14) ([merge request](gitlab-org/gitlab!64801)) **GitLab Enterprise Edition**
- [Fix broken Time Tracking Reports on Issuables](gitlab-org/gitlab@d69d0f9ceaa5589bed4f00eacbff43db2521b204) ([merge request](gitlab-org/gitlab!64797))
- [Fix frequent items timestamps not updated](gitlab-org/gitlab@2a3335566b6b3c65f92508cf3ec2b8ee5ac34256) ([merge request](gitlab-org/gitlab!64737))
- [Fix bug where Milestone page led to console error](gitlab-org/gitlab@e720e677d008a006292040d026a4393a89fc2471) ([merge request](gitlab-org/gitlab!64775))
- [Include hours into elapsed time in jobs](gitlab-org/gitlab@280ab3a2e66429105788d55e0fd430efd6a8cc8a) ([merge request](gitlab-org/gitlab!64721))
- [Fix retry-lock problem on pipeline cancel](gitlab-org/gitlab@85c299819121e6f3d372d3685a83df05455c6e41) ([merge request](gitlab-org/gitlab!63080))
- [Fix link for commit-type security report items](gitlab-org/gitlab@a7098dbbb6f271f1a3168d0b539424578d798fad) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/64565)) **GitLab Enterprise Edition**
- [Fix submit button not being clickable](gitlab-org/gitlab@845cb6473e3e187c6c880cf42a73426821044253) ([merge request](gitlab-org/gitlab!64315)) **GitLab Enterprise Edition**
- [Fix top position on board sidebar](gitlab-org/gitlab@52d8c768af4cf9a6b6e2d84cca4eb989bb912bd3) ([merge request](gitlab-org/gitlab!62051))
- [Carry line_range info forward on unchanged positions](gitlab-org/gitlab@1e5301204e3fc236d4dc11cfc14f8dc06d5999a7) ([merge request](gitlab-org/gitlab!64267))
- [Force ASCII-8BIT encodings in CI job trace](gitlab-org/gitlab@f0d3c6905e029ac55b2aff4cf860c63522afecd0) ([merge request](gitlab-org/gitlab!64631))
- [Fix pages deployment storage migration](gitlab-org/gitlab@55f8b0129d8e54a532e93881fe1a29eebfc51131) ([merge request](gitlab-org/gitlab!64697))
- [Show warning when files are hidden in an MR](gitlab-org/gitlab@791e1975def8bf2ddee6bdb42b3f868cbcb0a688) ([merge request](gitlab-org/gitlab!64515))
- [Allow ancestor milestones to be set to an MR via push options](gitlab-org/gitlab@dd36ee326c16a8c1e1648b17142d6e695663f0f5) ([merge request](gitlab-org/gitlab!64678))
- [Group Avatar API: ensure to send the remote filename](gitlab-org/gitlab@7edcf42a53212b94195ff1c6d9c6749342cc510c) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/64650))
- [Bump the sys-filesystem version to prevent errors in System Info](gitlab-org/gitlab@613ee9051f5128de85fda5c35c0b047a4e5a81f2) ([merge request](gitlab-org/gitlab!64638))
- [Fix missing attributes on token audit events](gitlab-org/gitlab@a7713e44271e3f0c0c0073414febbafc77fcf48c) ([merge request](gitlab-org/gitlab!63958)) **GitLab Enterprise Edition**
- [Fix Zuora frame size after client-side error](gitlab-org/gitlab@1dc1e3e5cb9947480488655f311172a362dd2c55) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/64595)) **GitLab Enterprise Edition**
- [Fix infrastructure menu link to the first visible menu item](gitlab-org/gitlab@2ed7e99ebd4d44d8b628975314aa21bd332361bc) ([merge request](gitlab-org/gitlab!64592))
- [Upgrade omniauth-azure-activedirectory-v2 to v1.0.0](gitlab-org/gitlab@eee74a26887ebfd52049fae0637b4eac784673b5) ([merge request](gitlab-org/gitlab!64559))
- [GithubImporter: Avoid failing when PullRequest has empty body](gitlab-org/gitlab@2e5585ac07d4064ca955646b6cef391215ecf6d3) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/64558))
- [Update margin-left on widget attachment to match content start](gitlab-org/gitlab@b054719340ce39346d0d967f974d66b35f6092ec) ([merge request](gitlab-org/gitlab!64079))
- [Allow Projects with Freeze Periods to be Deleted](gitlab-org/gitlab@a9a9f0b6cf5093d896bacf09596c902a5a9195ed) ([merge request](gitlab-org/gitlab!64338))
- [Fix expiring subscription message on subgroups](gitlab-org/gitlab@5627974d0a0aa4313550cf078d24632e5d3b5fe9) ([merge request](gitlab-org/gitlab!64507)) **GitLab Enterprise Edition**
- [Constraint status checks to protected branches](gitlab-org/gitlab@bb838dc6ecb580e632f991c6e80ad6e9c7e56e25) ([merge request](gitlab-org/gitlab!63422)) **GitLab Enterprise Edition**
- [Enable deep linking on environments page for tabs](gitlab-org/gitlab@d905945c9bc9f919b7282cc01d95a15ad1c5de98) ([merge request](gitlab-org/gitlab!64331))
- [Fix sidekiq:migrate_jobs tasks in production mode](gitlab-org/gitlab@9971da5d6ae65e98e403ff429e6bc91ec6bcb88d) ([merge request](gitlab-org/gitlab!64414))
- [Fix a bug where the displayNamespaceId](gitlab-org/gitlab@0b8959670bf6c061199c9c077407fd5a057d6b0a) ([merge request](gitlab-org/gitlab!64397)) **GitLab Enterprise Edition**
- [Remove add button from Devops Adoption](gitlab-org/gitlab@7c30991b53efb1478c06cbcee1ea80625a2d3449) ([merge request](gitlab-org/gitlab!64400)) **GitLab Enterprise Edition**
- [Create close issue event on issue move](gitlab-org/gitlab@46d221927ce4c28df467b0c13f5fc9b16eea3200) ([merge request](gitlab-org/gitlab!64197)) **GitLab Enterprise Edition**
- [Fix missing "Clear" button on namespace search](gitlab-org/gitlab@a0596df386c4878ae90c59fc6809c7a5336e7073) ([merge request](gitlab-org/gitlab!64378))
- [Remove disable_composer_callback feature flag](gitlab-org/gitlab@99c36e440b29f3e23a2b707d39ac49aafef21679) ([merge request](gitlab-org/gitlab!64336))
- [Fix group avatar API](gitlab-org/gitlab@f8573b56c4cdfa6a4733311f6c495b7be707e899) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/63934))
- [Fix environment folder broken layout](gitlab-org/gitlab@6b8fe36c6b4dfbfa97bca39f86a9be312f637caa) ([merge request](gitlab-org/gitlab!64280))
- [Fix redirection for DAST Scanner Profile](gitlab-org/gitlab@d6dbe84562f0da1b5056acf3ce3dea10bbcd2a4b) ([merge request](gitlab-org/gitlab!64175)) **GitLab Enterprise Edition**
- [Fix visibility of issue enforcement setting](gitlab-org/gitlab@4f99af95dee23e1d07dd7af73f6c77ac1729f1d6) ([merge request](gitlab-org/gitlab!64073)) **GitLab Enterprise Edition**
- [Fix too many redirects during Geo check task](gitlab-org/gitlab@6d80e6a82454f6cd4626b60f16cdad605ec7089f) ([merge request](gitlab-org/gitlab!64265)) **GitLab Enterprise Edition**
- [Format network policies update time](gitlab-org/gitlab@6020f38c9561bc8e5aa1758ebd7075370205c3f6) ([merge request](gitlab-org/gitlab!64205)) **GitLab Enterprise Edition**
- [Use user permissions](gitlab-org/gitlab@ad434a48ea74a065b53d390077d720c7cdf607b6) ([merge request](gitlab-org/gitlab!64125))
- [Display license start date without special format](gitlab-org/gitlab@64e34537ac84713eacc823da4f048bc90e395906) ([merge request](gitlab-org/gitlab!64022)) **GitLab Enterprise Edition**

### Changed (137 changes)

- [Move admin user actions from cards to a dropdown](gitlab-org/gitlab@f77a237d60114f95777c7b01060708c4a3b6a680) ([merge request](gitlab-org/gitlab!64648))
- [Use configured browser locales for date formatting](gitlab-org/gitlab@ce46da1b791f930ac8e7d7780d2cc4678eec1532) ([merge request](gitlab-org/gitlab!65740))
- [Update GraphQL project type field container_registry_enabled](gitlab-org/gitlab@5370ae995cc2c6ffea5e15b39a8ef7b2af1fdc9b) ([merge request](gitlab-org/gitlab!66059))
- [Enable load balancing for Jira Connect workers](gitlab-org/gitlab@299b7e29da831829630dacedac5d1e66bfdc3172) ([merge request](gitlab-org/gitlab!66286))
- [ContainerRepositoriesFinder now checks container registry visibility](gitlab-org/gitlab@383359466c4c9519ea9f5f9bb3df7130db9c5f90) ([merge request](gitlab-org/gitlab!66157))
- [Drop support for Safari 13.0](gitlab-org/gitlab@a66265a17f695dd480128e7b927cdbe86b53497d) ([merge request](gitlab-org/gitlab!66231))
- [Add Finding Evidence Assets](gitlab-org/gitlab@54b0a25e55ccc7ce5a6d395dd063214d837abfa5) ([merge request](gitlab-org/gitlab!65675))
- [Search epic by title in issues](gitlab-org/gitlab@2f08c27c220e3720c7afb429a233f93b01460d13) ([merge request](gitlab-org/gitlab!66024))
- [Migrate Add To Do button to widget](gitlab-org/gitlab@6cfa6b8ee1537695d5751f6f23d262613937d1b1) ([merge request](gitlab-org/gitlab!65709))
- [Makes the feature_name field for UserCallout nullable](gitlab-org/gitlab@69a1222205f74507d6bccbfaaacd7242ad18ed3b) ([merge request](gitlab-org/gitlab!66237))
- [Add a runner cost factor for new public projects](gitlab-org/gitlab@6ef0fa86a39dc5f768797b5fcec9dd142dd6fdc0) ([merge request](gitlab-org/gitlab!65155)) **GitLab Enterprise Edition**
- [Create environment column in policies list](gitlab-org/gitlab@8054ddac18be39a7425069f9a66b557d7f752a9e) ([merge request](gitlab-org/gitlab!65866)) **GitLab Enterprise Edition**
- [Filter service ping payload by category](gitlab-org/gitlab@8406a84441ee33bc8e61d3f339c24a8fdc25a7bb) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/65944))
- [Schedule MergeRequestCleanupRefsWorker more efficiently](gitlab-org/gitlab@0080186adfc96a196ba259b619e7dac23aff395b) ([merge request](gitlab-org/gitlab!65647))
- [Update urlParams on Jira issues list page](gitlab-org/gitlab@5179afecaea91a7e68b5b8994dd9c98340cbba02) ([merge request](gitlab-org/gitlab!66054)) **GitLab Enterprise Edition**
- [Remove snippet_spam feature flag](gitlab-org/gitlab@1304f57ca84fdc8edad1aec76e612f892ad6f3d5) ([merge request](gitlab-org/gitlab!66118))
- [Update DevOps Score doc and callout](gitlab-org/gitlab@a9079bb147f6d0851367f03850eb623db5ae63c6) ([merge request](gitlab-org/gitlab!64786))
- [Add sort by popularity to issues](gitlab-org/gitlab@5cc63c5d58c342e4722ea933bf04760630a8cac1) ([merge request](gitlab-org/gitlab!65452))
- [Rename project / group removal to deletion](gitlab-org/gitlab@b45cf6ff0e738fcfadd3162388b15a8e7dd98d3e) ([merge request](gitlab-org/gitlab!66064)) **GitLab Enterprise Edition**
- [Swimlanes - Fetch more epics button](gitlab-org/gitlab@0b9519b3be30a595ae39e73f2ea9d61a7ac23cf1) ([merge request](gitlab-org/gitlab!65121))
- [Change style of add button on License Compliance page](gitlab-org/gitlab@f4ee8502ad77b0cacbaa80b09cba81e74b42823f) ([merge request](gitlab-org/gitlab!66000)) **GitLab Enterprise Edition**
- [Change success color](gitlab-org/gitlab@40a54471a3c56151bed5428eaae8442b6832dcea) ([merge request](gitlab-org/gitlab!65987))
- [Optimized blob view loading in repository](gitlab-org/gitlab@d1e175f89a1eb8fec9c9bc18dccb4e80c3cf24d6) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/65859))
- [Require encryption on builds tokens](gitlab-org/gitlab@e704102921ad3c0248044d678003dc8452482782) ([merge request](gitlab-org/gitlab!65166))
- [GithubImporter: Count fetched/import objects globally and by project](gitlab-org/gitlab@de4fd2ce3825ac6d2fe7adc4bbbfe86251d4aa93) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/65700))
- [Improve Error Tracking models](gitlab-org/gitlab@a92eb02c4e577cf94af8e2a415d11d0512f887a6) ([merge request](gitlab-org/gitlab!65753))
- [Ignore cloud_license_enabled in ApplicationSetting](gitlab-org/gitlab@d3b0239ff0430f3638db9958ac4131b2f83ca0a8) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/65951)) **GitLab Enterprise Edition**
- [Extracted Admin E-mail notification code from EE to core](gitlab-org/gitlab@181ebaa8e5ee94f80a7d26a9166f1e1b008a1c6c) ([merge request](gitlab-org/gitlab!64931))
- [Update Admin Area's Runner Details Page UI](gitlab-org/gitlab@4b18738e2749db8d9ee1a223ca6a05f8055bf820) ([merge request](gitlab-org/gitlab!65948))
- [Add upvotes_count to issues](gitlab-org/gitlab@aeaf3eb433412915fc4b57516a69159446b1102c) ([merge request](gitlab-org/gitlab!65250))
- [Update Admin Area's Runners Page UI](gitlab-org/gitlab@f3ef2a3257da0f7eb6316f969fee1bffb34b3b78) ([merge request](gitlab-org/gitlab!65901))
- [Increment DAST_VERSION in on-demand DAST template](gitlab-org/gitlab@672757e51ea8f739b7b55a3b3c16bd2f2d662e1d) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/65218)) **GitLab Enterprise Edition**
- [Update the Discord integration embed](gitlab-org/gitlab@e4f38f3f72a46c19a4917b59f71b9f5251060153) ([merge request](gitlab-org/gitlab!65893))
- [Update UI text for CI token scope setting](gitlab-org/gitlab@cdd383041e09c4947489c5f6d8597636c34b7508) ([merge request](gitlab-org/gitlab!65744))
- [Optimised the hash retrieval from URL](gitlab-org/gitlab@e76fa57d5022012fa27f6e16c94047f66eadd3e8) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/65854))
- [Update warnings for ci minute quotas](gitlab-org/gitlab@de82b75a26d21d96384398844741bab8608edbf3) ([merge request](gitlab-org/gitlab!65818)) **GitLab Enterprise Edition**
- [Update gitlab-labkit to v0.20.0](gitlab-org/gitlab@e22930f32a5aca7b77d224b1e4862df14161b128) ([merge request](gitlab-org/gitlab!65809))
- [Update requirement import modal to show focus](gitlab-org/gitlab@ab161f59d6fffa59882c80e79ca1597f4b474c38) ([merge request](gitlab-org/gitlab!65447)) **GitLab Enterprise Edition**
- [Mask runner registration](gitlab-org/gitlab@ddc541bb444ccdba4be077211609c603f57eda61) ([merge request](gitlab-org/gitlab!65551))
- [Update DAST version for offline environments](gitlab-org/gitlab@11eac5eb81936bb248db227f8da5f05d69d9bc39) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/65603)) **GitLab Enterprise Edition**
- [Add Finding Evidence Supporting Messages](gitlab-org/gitlab@065416b87421ea3e276b95d95677b820ce582c18) ([merge request](gitlab-org/gitlab!65686))
- [Update buildkite.rb](gitlab-org/gitlab@2425955cfe720955f481917a825d25f3345ab8ba) ([merge request](gitlab-org/gitlab!65658))
- [Use load balancing for Jira Connect workers](gitlab-org/gitlab@1b0b3d253d44f15ad519e492e646bc6e98f967d0) ([merge request](gitlab-org/gitlab!64715))
- [Start reading project_features.container_registry_access_level](gitlab-org/gitlab@aeff2cf9f841076ee6a1e2bb3d45a1689e38205a) ([merge request](gitlab-org/gitlab!65540))
- [Rearrange milestone form](gitlab-org/gitlab@36542b1d528d8c9fd8f0164279d092007025bd99) ([merge request](gitlab-org/gitlab!65718))
- [Update license compliance icons](gitlab-org/gitlab@d75c43ee01d86d169ffb4cee50f47289075848d2) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/64584)) **GitLab Enterprise Edition**
- [Improve consistency of admin user dropdown actions](gitlab-org/gitlab@5547886a61bb2330139446bbc68e6ce098f8674c) ([merge request](gitlab-org/gitlab!65668))
- [Remove cloud_license_enabled application setting](gitlab-org/gitlab@d598d2a85a7e262f1f0a25ef7e6566d9de3cde37) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/65538)) **GitLab Enterprise Edition**
- [Remove date from Seat Link data fields](gitlab-org/gitlab@8fa98066bdc82e3b9039029fac7e0fe2fbdc2105) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/65190)) **GitLab Enterprise Edition**
- [Update dot style for DORA lead time graphs](gitlab-org/gitlab@b7d5c68c51d93b9681647fa21710617349b1856c) ([merge request](gitlab-org/gitlab!65555)) **GitLab Enterprise Edition**
- [Schedule devops adoption calculation only for pending namespaces](gitlab-org/gitlab@9193e19ed055814b3ab6df4aa6b2ed83d64be70c) ([merge request](gitlab-org/gitlab!65443)) **GitLab Enterprise Edition**
- [Move "Show latest version" button to the left](gitlab-org/gitlab@d1c4e90e3d8588693178122ab10a3438d52f1e46) ([merge request](gitlab-org/gitlab!65338))
- [Allow wiki pages to be empty](gitlab-org/gitlab@2bc6eefbedc3015d9b49e34e20fdb2d3be1f7ec7) ([merge request](gitlab-org/gitlab!65521))
- [Bump Nokogiri from v1.11.4 to v1.11.5](gitlab-org/gitlab@4c49f6980fd1aadfe622fa7a13db3ffe487be591) ([merge request](gitlab-org/gitlab!65597))
- [Log and advise about push-rule-rejected commit](gitlab-org/gitlab@ae30a545cd7fcd34c59531bccf3ebbaaf9e2ec09) ([merge request](gitlab-org/gitlab!64933)) **GitLab Enterprise Edition**
- [Update supported browser versions](gitlab-org/gitlab@0849d34993c01805e794a64f2d1e4bde15d8f788) ([merge request](gitlab-org/gitlab!63994))
- [Merge branch '334976-fix-misleading-upgrade-cta-jira-issues' into 'master'](gitlab-org/gitlab@b7a38de74932e04248ec77d0bd750433acf3d312) ([merge request](gitlab-org/gitlab!65302))
- [Update timestamp fields to Standard](gitlab-org/gitlab@28d9eb2afd64e7fd1d0cd211c48a28a47eec562b) ([merge request](gitlab-org/gitlab!65523))
- [Update copy and type for sync subscription banner](gitlab-org/gitlab@36474d85fc9a6f0bdaa5f77bd27d852f43c3c63e) ([merge request](gitlab-org/gitlab!65316))
- [Upgraded Monaco to 0.25.2](gitlab-org/gitlab@281b581885f23e7e311c7ca19f7bc140acbedb7a) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/63400)) **GitLab Enterprise Edition**
- [Reintroduce lfs_link_existing_object feature flag](gitlab-org/gitlab@b9bd7169450001edde4946f48c90446965e6c34b) ([merge request](gitlab-org/gitlab!65437))
- [Show 'Delete' button to developers in Wiki](gitlab-org/gitlab@8babca59505c323ad739f335a337fa1a71f8f003) ([merge request](gitlab-org/gitlab!65420))
- [Switch back to pg_query](gitlab-org/gitlab@5a6b009504317c6bcbd4c36171cd74f961ed63a9) ([merge request](gitlab-org/gitlab!65416))
- [Use Gitaly long timeout for resolving conflicts](gitlab-org/gitlab@2afa172683dc8257e2f28d70ecaf3ffadfdfece2) ([merge request](gitlab-org/gitlab!65394))
- [Add upvotes field to issues index](gitlab-org/gitlab@3431b3ef3df2a214a773b449cc7b8de284ca228c) ([merge request](gitlab-org/gitlab!64683)) **GitLab Enterprise Edition**
- [Identicon - Align GitLab UI Colors](gitlab-org/gitlab@b05e2e2b0a4aee57d968b90737b69a2ae31c5c6f) ([merge request](gitlab-org/gitlab!65058)) **GitLab Enterprise Edition**
- [Update color scheme of createFlash](gitlab-org/gitlab@355659cf1ef25465edb5228d6bac7c147f193719) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/65315))
- [Fix misleading upgrade CTA in Jira configuration](gitlab-org/gitlab@703c55429e659a4ecdf50864fa1e9adc62e39a95) ([merge request](gitlab-org/gitlab!65302))
- [Sort fork form namespaces alphabetically](gitlab-org/gitlab@727106f000c40f0963cb2549ecb45260222720fa) ([merge request](gitlab-org/gitlab!65178))
- [Present error when DAST profile not found](gitlab-org/gitlab@d6d35d573136eacad2775825ca5a60d221b79dc0) ([merge request](gitlab-org/gitlab!64679))
- [Add selected to description](gitlab-org/gitlab@650eac6656704667e62253164957aecb967a7775) ([merge request](gitlab-org/gitlab!65184))
- [Remove the sec_secret_detection_ui_enable feature flag](gitlab-org/gitlab@7d3cb546730fd644ec5e14a0a9aa712cc11f5f19) ([merge request](gitlab-org/gitlab!65055)) **GitLab Enterprise Edition**
- [Block external pull mirrors for forks](gitlab-org/gitlab@ea13d159356916dfc8c37a9c8fb06104d396f327) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/60735))
- [DRY deactivate dormant user worker spec](gitlab-org/gitlab@826f278a7918d1cc24a390f5c2ffcc4a5844f3c7) ([merge request](gitlab-org/gitlab!65226))
- [Fix sorting bug in dependency list](gitlab-org/gitlab@bf0849ac3290e747e4c3d8efbf806f60ce9ed954) ([merge request](gitlab-org/gitlab!63500)) **GitLab Enterprise Edition**
- [Create or update a cloud license on sync/activate](gitlab-org/gitlab@ab3dd3913695945b49e920e3c86f32ffdd2a5c20) ([merge request](gitlab-org/gitlab!64825)) **GitLab Enterprise Edition**
- [Truncate body length](gitlab-org/gitlab@fd3480dec9e5dd28e4b813168a1bac635a83bb35) ([merge request](gitlab-org/gitlab!65195)) **GitLab Enterprise Edition**
- [Update dictionary renderer to include data category](gitlab-org/gitlab@b4559327085e3e2b5a8ccdcdd9656c99d26bb55c) ([merge request](gitlab-org/gitlab!64641))
- [Add policy type column](gitlab-org/gitlab@b7d8ca57f8bc7114e578f9b90e31f4ef861b609d) ([merge request](gitlab-org/gitlab!65075)) **GitLab Enterprise Edition**
- [Trial CTA source split](gitlab-org/gitlab@dd7cde6028eaed91abcadc0ace40c4d4f8e1f56f) ([merge request](gitlab-org/gitlab!64848)) **GitLab Enterprise Edition**
- [Change the number of pipelines per page to 15](gitlab-org/gitlab@02da71f3cd22173c65d1063f0a87a1bce1f12443) ([merge request](gitlab-org/gitlab!64285))
- [Revise the navbar to use sentence case](gitlab-org/gitlab@9e677ac05dc994bdcc5eb3a2e44e056bfccee85b) ([merge request](gitlab-org/gitlab!60324))
- [Update status column in Threat Monitoring](gitlab-org/gitlab@4c6499712f26ea649b8fbfa1644adf40f73a2eb6) ([merge request](gitlab-org/gitlab!64959)) **GitLab Enterprise Edition**
- [Bump import job status expiration to 24h](gitlab-org/gitlab@d6c0b2a55518c490782468d3f7170c4bca52c622) ([merge request](gitlab-org/gitlab!65066))
- [Promote new_repo experiment](gitlab-org/gitlab@06da8d4cdc98f71311d419f6c986a6e739fedc9b) ([merge request](gitlab-org/gitlab!64651))
- [Re-named the remaining EditorLite files](gitlab-org/gitlab@00c3f33effc2cf40dbea42ec94ede1e432d3f98d) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/64909))
- [Update compliance dashboard empty state](gitlab-org/gitlab@92278867fb87c9d65329a9f9f9a6d9cdb68c36ab) ([merge request](gitlab-org/gitlab!64936)) **GitLab Enterprise Edition**
- [Polish formatted_stage_count for analytics](gitlab-org/gitlab@035db94f1193130c304e8fb73bfe8c578b48e174) ([merge request](gitlab-org/gitlab!64960))
- [VSA: Change item count to 1000+](gitlab-org/gitlab@4af12b457c1a7a7ea2bb60a56ae54409bd52539c) ([merge request](gitlab-org/gitlab!64789)) **GitLab Enterprise Edition**
- [Move Scan PORO to CE [RUN AS-IF-FOSS]](gitlab-org/gitlab@bd817787d1dc88e45526b92c3e48e1a6a34da6d7) ([merge request](gitlab-org/gitlab!64790))
- [Enable ci_job_trace_force_encode feature flag by default](gitlab-org/gitlab@3b2396ddb1de8504e8611741a4c9c6cdd1c903a8) ([merge request](gitlab-org/gitlab!64955))
- [Move migration to a pre-deployment migration](gitlab-org/gitlab@2050852f3f5adcf252c81c606f5e2de5dee85b03) ([merge request](gitlab-org/gitlab!64948)) **GitLab Enterprise Edition**
- [Remove access request controls in admin area](gitlab-org/gitlab@b7faa327eb8553d04366f3f3e4a9297d3131461c) ([merge request](gitlab-org/gitlab!64659))
- [Revise UI text for third-party offers](gitlab-org/gitlab@294b85eb7c83cdff3950322ee7a06c68b9523651) ([merge request](gitlab-org/gitlab!64943))
- [Add documentation for billable member sorting](gitlab-org/gitlab@c3487a06ac93454040f385692c4b3e61bddda11e) ([merge request](gitlab-org/gitlab!64911))
- [Add confirmation modal to "Sync now" LDAP button](gitlab-org/gitlab@9c316cc35879410a2c4d75ae9c545d67393a5bc1) ([merge request](gitlab-org/gitlab!64555)) **GitLab Enterprise Edition**
- [Add correct extension to dotnet CI template](gitlab-org/gitlab@ab15294353a6b78de99153e1a8cab108c63e32d9) ([merge request](gitlab-org/gitlab!64901))
- [Rename ci examples readmes to index](gitlab-org/gitlab@c9a96e20dbf3aa2aeaec5f027ce3e3d4d2e31429) ([merge request](gitlab-org/gitlab!64885))
- [Update copy for DAST code snippet modal](gitlab-org/gitlab@9e782ede13a2cd78ea15fcc986e9aa1284455e3e) ([merge request](gitlab-org/gitlab!64788)) **GitLab Enterprise Edition**
- [Add source version check to Bulk Import](gitlab-org/gitlab@80c22fd67bd8e60babd3752f91de8f618f578320) ([merge request](gitlab-org/gitlab!63886))
- [Fix deprecated GlIcon size and property](gitlab-org/gitlab@72163f87f634b33195258a7a5b1435c31ba3493a) ([merge request](gitlab-org/gitlab!63003))
- [Rename usage ping to service ping](gitlab-org/gitlab@db8e2c3ba5c829c83b993616b07c21ab908fde2c) ([merge request](gitlab-org/gitlab!64732))
- [Use minimal layout in trial flow](gitlab-org/gitlab@c0ba92fa4fa40de6f85a25edd2179d635ab14117) ([merge request](gitlab-org/gitlab!63588))
- [Fix admin mode when authenticating with LDAP](gitlab-org/gitlab@a87172353c8c7aa688f1895222ee6b652908b02c) ([merge request](gitlab-org/gitlab!64823))
- [Simplify the sign in page after confirmation](gitlab-org/gitlab@8c7d3a45e8001eef9f0c7be75ce5534624a8a99d) ([merge request](gitlab-org/gitlab!64370))
- [Enable FF ci_reset_bridge_with_subsequent_jobs by default](gitlab-org/gitlab@838875292f010d00f1bbaad631ec3b95069c73ad) ([merge request](gitlab-org/gitlab!64778))
- [Sort milestones by due date in filtered search](gitlab-org/gitlab@df5f2741a53123e05445e42cf076996f9383d211) ([merge request](gitlab-org/gitlab!64617))
- [Add searchability to ci template dropdown](gitlab-org/gitlab@361633ca1410e044b708de9fec0f039e9f080b50) ([merge request](gitlab-org/gitlab!63268)) **GitLab Enterprise Edition**
- [Remove deprecated API elements](gitlab-org/gitlab@0d4615ce2287429dd06770d6d13939a5d6628fcf) ([merge request](gitlab-org/gitlab!64752))
- [Remove unncessary type options](gitlab-org/gitlab@0d97d1e9e28a271c15bbfbd009a23309d3fb099f) ([merge request](gitlab-org/gitlab!63919))
- [Migrate top-centered toasts to bottom-left](gitlab-org/gitlab@b74175ca02761751e7f18c3936eb4d571a9d2a71) ([merge request](gitlab-org/gitlab!63919)) **GitLab Enterprise Edition**
- [Upgrade @gitlab/ui to v30.0.0](gitlab-org/gitlab@39b9d1c9d0b155fbcb86690d2402d3e568db9585) ([merge request](gitlab-org/gitlab!63919))
- [Remove web_hooks_rate_limit feature flag](gitlab-org/gitlab@9bd9d414afe3cae800ba0b93a5ffa91891809a11) ([merge request](gitlab-org/gitlab!64708))
- [Default-enable :update_remote_mirror_inmemory feature flag](gitlab-org/gitlab@bfdf0dc256aa0e747e94b09a12f1f2d8b5ab6a75) ([merge request](gitlab-org/gitlab!64702))
- [Default-enable :fetch_remote_params feature flag](gitlab-org/gitlab@877a101ac6fcf924b2428fd256bed3982854c4b2) ([merge request](gitlab-org/gitlab!64701))
- [Remove the regulated tab from compliance frameworks list](gitlab-org/gitlab@d1d9cdb68ae7732dbdb67008db724ba95f95b57d) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/64690)) **GitLab Enterprise Edition**
- [Move Debian regexp to ::Packages::Debian](gitlab-org/gitlab@f836ae221c5eff7dc77be2d6663643daa1638784) ([merge request](gitlab-org/gitlab!64068))
- [Add Pending Alert Escalations table](gitlab-org/gitlab@e5cc867503dfbd54f99df90cce6be39bc4fde712) ([merge request](gitlab-org/gitlab!64274))
- [Add parameters to in app purchase links](gitlab-org/gitlab@07533e376295cbfc8dcfe529cc1ef5ea5ce87a3f) ([merge request](gitlab-org/gitlab!64395))
- [Search: add ability to sort epics](gitlab-org/gitlab@df6a2a949e84896af9d32aa5558ad5fe387d25de) ([merge request](gitlab-org/gitlab!64402)) **GitLab Enterprise Edition**
- [Support repository moved message with all container types](gitlab-org/gitlab@6c612d69bb26d51a0decb830add384161844cc28) ([merge request](gitlab-org/gitlab!64012))
- [Allow billable member sorting by last activity](gitlab-org/gitlab@fb491cef0630d0da90f6ff1c3a613d465a95b153) ([merge request](gitlab-org/gitlab!64620)) **GitLab Enterprise Edition**
- [Render confidential icon in epic tree for epics](gitlab-org/gitlab@df4415158e06a4e827cf9c417c8848000a8d91e6) ([merge request](gitlab-org/gitlab!64567))
- [Sort epic list in issue sidebar by title](gitlab-org/gitlab@3dc5b05e4fc541471d77026983a7ddc3ee977770) ([merge request](gitlab-org/gitlab!63730)) **GitLab Enterprise Edition**
- [GithubImporter: Count and log each object imported](gitlab-org/gitlab@decb7bfb0aac26dc5d5c2f7e15421302c57a2cf6) ([merge request](gitlab-org/gitlab!64256))
- [Standardize UI text for protected branches and protected tags](gitlab-org/gitlab@9134784ebd9ac61665ed38f525c662b62e21964b) ([merge request](gitlab-org/gitlab!63959))
- [Allow to promote confidential issues into confidential epics](gitlab-org/gitlab@aa8034b927f3ca8dd3c69626b8fa05318b930a92) ([merge request](gitlab-org/gitlab!64253))
- [Sort by similarity in Search Group's Project dropdown](gitlab-org/gitlab@dd4b1a1b5963d3c13026804ce6ee00d53b5f90a3) ([merge request](gitlab-org/gitlab!64241))
- [Refactor db selection in SidekiqServerMiddleware](gitlab-org/gitlab@18501e372c2dd3bd0c4d43120afd756aed04bcff) ([merge request](gitlab-org/gitlab!63304))
- [Renamed EditorLite to SourceEditor](gitlab-org/gitlab@849b4aac6e7d7a228d383f2042f9496c5365528f) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/64302)) **GitLab Enterprise Edition**
- [Remove job dependency for Vulnerability-Check](gitlab-org/gitlab@76551c13ead5ae01be2f2118f07fde6d2e2db558) ([merge request](gitlab-org/gitlab!64333)) **GitLab Enterprise Edition**
- [Reduce horizontal padding in new top nav](gitlab-org/gitlab@400b4200940d13049a0dbc040ebd0f3b725d3b6b) ([merge request](gitlab-org/gitlab!64357))
- [Add descriptions for EpicStateEnum](gitlab-org/gitlab@6a5b63e4c9405d744abda67ac1e6e54ca56e9a15) ([merge request](gitlab-org/gitlab!63915)) **GitLab Enterprise Edition**
- [Relabel access token fields](gitlab-org/gitlab@53180d13efd7411ec8194a25b4e8578bed5e8353) ([merge request](gitlab-org/gitlab!62616))
- [Pajamas-compliant dismiss button for HAML alerts](gitlab-org/gitlab@edf4fec49d8bc6d4c12fb1a3b6a73720693996d2) ([merge request](gitlab-org/gitlab!63792))
- [Add validation to additional pack purchase_xid](gitlab-org/gitlab@1647549088bed44b12388deb82828695dc290c7a) ([merge request](gitlab-org/gitlab!63866)) **GitLab Enterprise Edition**
- [Use standard filter for scanner filter on non-project level vuln report](gitlab-org/gitlab@f5d989895af22827c7f4be3e1d2cef3e552f8d41) ([merge request](gitlab-org/gitlab!63940)) **GitLab Enterprise Edition**

### Deprecated (1 change)

- [Deprecate GraphQL PrometheusServiceID argument](gitlab-org/gitlab@b86b6f90fad607ac058bec59e40568752a724ca9) ([merge request](gitlab-org/gitlab!62645))

### Removed (24 changes)

- [Remove securityScansSucceeded from DevOps Adoption](gitlab-org/gitlab@eac43a025ccb01b1502dad2542985686cdada1de) ([merge request](gitlab-org/gitlab!66291)) **GitLab Enterprise Edition**
- [Remove old license page logic](gitlab-org/gitlab@a90ec139423285cd8046a6373603c4b79d85e46d) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/65978)) **GitLab Enterprise Edition**
- [Remove trace_memory_allocations FF](gitlab-org/gitlab@aac6b96b7e46895e4221bae2033c7686ba3c9926) ([merge request](gitlab-org/gitlab!66022))
- [Undo CTE fix for PG11](gitlab-org/gitlab@d8daab8c792e4c1b4cdbd166414ceeebd85a23ca) ([merge request](gitlab-org/gitlab!58499))
- [Delete framework column from project_compliance_framework_settings](gitlab-org/gitlab@89dbf6592975fc8cec8949669a0f63a7083dd891) ([merge request](gitlab-org/gitlab!65546))
- [Removed ff sidebar_refactor from views](gitlab-org/gitlab@6c3da94333ca25b629fd2d259249386a5ee1d842) ([merge request](gitlab-org/gitlab!64384))
- [Remove productivity_analytics_scatterplot flag](gitlab-org/gitlab@86047a245f868867b27830ea4dae0c7a2ee20650) ([merge request](gitlab-org/gitlab!65456)) **GitLab Enterprise Edition**
- [Remove cycle analytics scatterplot ff](gitlab-org/gitlab@12d74f0e309488e057e9a091215be0e8fddf7c89) ([merge request](gitlab-org/gitlab!65515)) **GitLab Enterprise Edition**
- [Remove the approvals_commented_by feature flag](gitlab-org/gitlab@7e1715d0b857c638756fb851d5e78ca258ae2f47) ([merge request](gitlab-org/gitlab!65319))
- [Remove the use_workhorse_s3_client feature flag](gitlab-org/gitlab@152f6ad7ede46eb0fc7205b921ae290be174c4e3) ([merge request](gitlab-org/gitlab!65321))
- [Remove the use_distinct_in_shas_cte FF](gitlab-org/gitlab@4068bbd9b0e5f219444fa3bfe63c75b468b081f4) ([merge request](gitlab-org/gitlab!65027))
- [Remove un-used Event archived action](gitlab-org/gitlab@3351661fd57e704d89602b789948bf801fb252d4) ([merge request](gitlab-org/gitlab!64543))
- [Remove Frontend to Edit Legacy Flags](gitlab-org/gitlab@21c7e932706643c2d768fa7f6cec991a13c01e6e) ([merge request](gitlab-org/gitlab!64005))
- [Removes pipeline_filter_jobs feature flag](gitlab-org/gitlab@34b1a2285b84be61bf61f4dd7d932150322b1c24) ([merge request](gitlab-org/gitlab!64919))
- [Remove Clusters Applications Fluentd Table](gitlab-org/gitlab@6d6e6cf4a9eb6c7ab9bd47c453a05676217c30d9) ([merge request](gitlab-org/gitlab!63758))
- [Drop deprecated Prometheus settings in gitlab.yml](gitlab-org/gitlab@0e3e4062ee5db1d09f6929883aa9f86204184d77) ([merge request](gitlab-org/gitlab!64264))
- [Remove ability to enable/disable seat link from settings](gitlab-org/gitlab@ae9b4072befbb882cb75afdbead5b96d013625d3) ([merge request](gitlab-org/gitlab!64160)) **GitLab Enterprise Edition**
- [Drop index_ci_builds_on_protected index](gitlab-org/gitlab@baa41860d52495b7f35e5b49025b55b0c5147f5d) ([merge request](gitlab-org/gitlab!64229))
- [Remove Legacy Flags from Feature Flag Table](gitlab-org/gitlab@f7097cf1c1b3dd6d3bec67a4e3717ae32defc5e8) ([merge request](gitlab-org/gitlab!64007))
- [Enable the new project sidebar](gitlab-org/gitlab@8aafc4b18bc42628aa8f19552dae811f0d5eaef6) ([merge request](gitlab-org/gitlab!63850))
- [Remove omit_commit_sha feature flag](gitlab-org/gitlab@05b4762c3a36fd1b457f79e587ee9218dcdcc5a3) ([merge request](gitlab-org/gitlab!64421))
- [Drop LB FF for ExpirePipelineCacheWorker](gitlab-org/gitlab@170984c79395707ab9cd4dfc060ff83d8efe3ca6) ([merge request](gitlab-org/gitlab!64181))
- [Remove new_release_page feature flag](gitlab-org/gitlab@abc9814684792e8f8d62846b36f46e4622906487) ([merge request](gitlab-org/gitlab!64153))
- [Drop load-balancing FF in PipelineHooksWorker](gitlab-org/gitlab@eae1cf34cb6e58393d6f74caf9b9541e5e29fcfc) ([merge request](gitlab-org/gitlab!64107))

### Security (17 changes)

- [Update addressable gem to v2.8.0](gitlab-org/gitlab@62b7b1d3f28a98019fde619bde4e0e0530e821ef) ([merge request](gitlab-org/gitlab!66202))
- [Disable file and network premailer strategies](gitlab-org/gitlab@c194597ae04e812f3b5be7339412413a04703ae4)
- [Add total http read timeout](gitlab-org/gitlab@5d7b5696955c2928d82adaf50ed73f53cb1939bf)
- [Update rdoc to 6.3.1](gitlab-org/gitlab@20d56f81f9aa282cb2e195a916f4c5e0fcb8084d)
- [Forbid GET requests with mutations](gitlab-org/gitlab@7d16feb31fb360123c4b8ddaa85de6ddb5ddf119)
- [Prevent GraphQL API access by deactivated users](gitlab-org/gitlab@414b5fb0b34fd6640369314013924c5524aa16a5)
- [Add sanitizing for name field](gitlab-org/gitlab@5fee1e3d52934f770e6f0334a0fbee5b891de5b6)
- [Fix XSS on audit log for feature flag actions](gitlab-org/gitlab@70e0b2630f5e439017931b196e5ebcf2ff4e9cdb)
- [Copy feature visibility settings to a fork](gitlab-org/gitlab@c2ef1c24770b024e0cb5a1d3346b8743aec28e47)
- [Avoid disclosing project in web IDE](gitlab-org/gitlab@09324e21488351e0c09806ad727b4c1e957ad288)
- [Allow only same-origin URLs for Edit Release Cancel button](gitlab-org/gitlab@cfff402646e95d30183168efdbda8d114c5f89c0)
- [Add new username validation](gitlab-org/gitlab@b14210fd775c1f384191410bd327a318a5293ffb)
- [Removes security_ci_lint_authorization code](gitlab-org/gitlab@8a69d1f03947e3f85f48dd920c1bff3639609875) ([merge request](gitlab-org/gitlab!64092))
- [Update Nokogiri to 1.11.4](gitlab-org/gitlab@dcf26b79caa46ee31bd5e3ad7ca95bec7e59e5be)
- [Fix deploy key fallback issue in protected branch](gitlab-org/gitlab@58d1df0c6a3149c5c07825036be5e8fe3f1edd1c)
- [Sanitize input on pasteGFM](gitlab-org/gitlab@a5fcd806ff4e6e7510f9981c5d8eacab571a64d7)
- [Fix merge request diff display issue with unsupported encoding](gitlab-org/gitlab@7fa23a8854aed205af22fc904db117dbecec389f)

### Performance (31 changes)

- [Update anscestor deduplication in pipeline graph](gitlab-org/gitlab@12790c458eac27bda671e609ca9b07d2bb6cad4e) ([merge request](gitlab-org/gitlab!66283))
- [Enqueue async, non-blocking jobs for group-group share actions](gitlab-org/gitlab@dc475336c83a324eaafe105864cb8b569a307447) ([merge request](gitlab-org/gitlab!66349))
- [Immediately show parent row](gitlab-org/gitlab@f5f66238b66656138f6411b8af43d978a192b0dd) ([merge request](gitlab-org/gitlab!66176))
- [Improve sort by popularity for issues board](gitlab-org/gitlab@e87edb6bccd20d37b4f424ca195aad3f57017d51) ([merge request](gitlab-org/gitlab!66140))
- [Adjustments to compare caching](gitlab-org/gitlab@9b2f6917b7512720897c2a1f7b4c18945c75dc2d) ([merge request](gitlab-org/gitlab!65839))
- [Move link icon to CSS](gitlab-org/gitlab@9fb7127e8dfd351652d5c3a5930c7fbfd9da04b5) ([merge request](gitlab-org/gitlab!65835))
- [Lazy load avatars](gitlab-org/gitlab@b8efcdf7cf3ec9760c1ff468549de5982bcbe284) ([merge request](gitlab-org/gitlab!65745))
- [Increase page size exponentially](gitlab-org/gitlab@0175d9c776f3c6890fe87e807882a19adc32c9ae) ([merge request](gitlab-org/gitlab!65654))
- [Reduce space needed for merge request diff commits](gitlab-org/gitlab@43a3ce63af857909f3dd6051ca686e3254613086) ([merge request](gitlab-org/gitlab!63669))
- [Preload project user authorizations on REST API](gitlab-org/gitlab@f0b0358b27cc9a153d0a6452bf37ab456b51d003) ([merge request](gitlab-org/gitlab!65602))
- [Remove replica selection change FF](gitlab-org/gitlab@3848ff313b41e52d5ab2ad3c47f4d91a9c352a57) ([merge request](gitlab-org/gitlab!65545))
- [Remove redundant call to RenderService](gitlab-org/gitlab@9b8af9c7505aea0442ba87ab170f0a43ca4fc378) ([merge request](gitlab-org/gitlab!65494))
- [Cache rendered compare entity](gitlab-org/gitlab@b49afc54b836ce9fc053a34a9d931b17872b14a9) ([merge request](gitlab-org/gitlab!64418))
- [Use linear root_ancestor when possible](gitlab-org/gitlab@0b1bd65439992857c5725425f0d44668fdd93887) ([merge request](gitlab-org/gitlab!65401))
- [Schedule requirements processing conditionally](gitlab-org/gitlab@b1ba1aa7a945226a3d24dc96371686bd9381a27f) ([merge request](gitlab-org/gitlab!65322)) **GitLab Enterprise Edition**
- [Fix Namespace#all_projects performance](gitlab-org/gitlab@e0cc0fc67ca41caa9e0b7f67814414f56ad51a2c) ([merge request](gitlab-org/gitlab!65296))
- [Improve LoadBalancer#all_caught_up? logic](gitlab-org/gitlab@c5dd0858774a712ab4ea2f7f039530c013d8e4f8) ([merge request](gitlab-org/gitlab!65248))
- [Drop full index on ci_builds.token](gitlab-org/gitlab@e7f43db607d70b4cb3c042cb84d671ee0fc29287) ([merge request](gitlab-org/gitlab!65025))
- [Linear traversal query for Namespace#self_and_ancestors](gitlab-org/gitlab@c26e1ae1bebbe31ed47d5e16bdfe0f348b17c41a) ([merge request](gitlab-org/gitlab!61163))
- [Use async job when creating/updating EpicIssue](gitlab-org/gitlab@03c651f6b0a7d714e0f267302d39313161d9f709) ([merge request](gitlab-org/gitlab!64524)) **GitLab Enterprise Edition**
- [Enable milestone reference caching](gitlab-org/gitlab@619c21e3b02f526c19ebb59df1596f6598a67c71) ([merge request](gitlab-org/gitlab!62742))
- [git_access: Use batched new blobs check](gitlab-org/gitlab@f73f0c7bfb080384d2f9f8f4a139f353a62a0830) ([merge request](gitlab-org/gitlab!64503))
- [Eliminate some N+1 queries on project-pipeline GraphQL endpoint](gitlab-org/gitlab@82099148697c6d2de854d5af1df58dfb29551c8a) ([merge request](gitlab-org/gitlab!64700))
- [Improve the performance of project/users API](gitlab-org/gitlab@5b7f3608c191fcaece081d3e67b4f128cb4d848a) ([merge request](gitlab-org/gitlab!64528))
- [Replacement partial index for ci_builds.token](gitlab-org/gitlab@0205c7d01c192235447b3fe4ccf0a99eb34a5c26) ([merge request](gitlab-org/gitlab!64221))
- [Use materialied CTE to improve builds fair scheduling](gitlab-org/gitlab@8fbbcb87137f7693ecd9833fa5df238af35a1436) ([merge request](gitlab-org/gitlab!64605))
- [Speed up initial page load on Releases page](gitlab-org/gitlab@efb7212fa71ad570bd3e32b5c7374efc54228f34) ([merge request](gitlab-org/gitlab!63914))
- [Remove replica selection change FF for LB](gitlab-org/gitlab@cb8d9048ea5e7da265941e2702ed945182e4e1ec) ([merge request](gitlab-org/gitlab!64300))
- [Remove duplicate where condition](gitlab-org/gitlab@f968729aee1dc062161247df05786a98a5f5e4c2) ([merge request](gitlab-org/gitlab!64214))
- [Implement pending builds queue builder in a separate class](gitlab-org/gitlab@e9368df2d44c54ef965bac6d37c4d5b35c86e024) ([merge request](gitlab-org/gitlab!64093))
- [Utilize load balancing for BuildQueueWorker](gitlab-org/gitlab@57a35133e18c43c0c110371c4b3e6012af215a11) ([merge request](gitlab-org/gitlab!64180))

### Other (58 changes)

- [Support reindexing unique indexes](gitlab-org/gitlab@982f22573b9975f6097834ecf76c62915f68dda6) ([merge request](gitlab-org/gitlab!65966))
- [Revise group Pages size UI text](gitlab-org/gitlab@526a8ca626c063a32b8d9fd0d9abba5b22be9535) ([merge request](gitlab-org/gitlab!65862)) **GitLab Enterprise Edition**
- [First run for events dictionary for backend](gitlab-org/gitlab@2f2e27cb53a3509387216d7fc99e0bf35501524f) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/62422)) **GitLab Enterprise Edition**
- [Record message size transmitted over action cable](gitlab-org/gitlab@31407b25c1f77ab57b4e000e4f82ae4d6d8cdf0a) ([merge request](gitlab-org/gitlab!65286))
- [Migrate the deprecated "urlParamsToObject" to "queryToObject"](gitlab-org/gitlab@8c321d20d47230e9925abb1e151c9e6006a5440f) ([merge request](gitlab-org/gitlab!65898)) **GitLab Enterprise Edition**
- [Rename License.usage_ping to License.customer_service_enabled](gitlab-org/gitlab@63ed6908275668d2aeb48328b5dfec121b15442a) ([merge request](gitlab-org/gitlab!65834)) **GitLab Enterprise Edition**
- [Remove codequality_mr_diff_annotations flag](gitlab-org/gitlab@74b47ffe5bb656af9cd4acc4be23d218c634f6e7) ([merge request](gitlab-org/gitlab!65960)) **GitLab Enterprise Edition**
- [Remove temporary feature flags](gitlab-org/gitlab@d7049bc4e817a07b64659469dd48e6a6894610e7) ([merge request](gitlab-org/gitlab!65544))
- [Remove the codequality_mr_diff feature flag](gitlab-org/gitlab@3d29d6688ea82163c93a198071d15a4c206ee604) ([merge request](gitlab-org/gitlab!63461)) **GitLab Enterprise Edition**
- [Add troubleshooting section to batched migrations docs](gitlab-org/gitlab@354021bcf53db7148e2a809e1e5c5de5596683e4) ([merge request](gitlab-org/gitlab!65513))
- [Migrate the deprecated "urlParamsToObject" to "queryToObject"](gitlab-org/gitlab@b09ea9f2ce741f1c716bbd26a329b57bb22cfee1) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/65894))
- [Fix security scan query timeout](gitlab-org/gitlab@bda826eb4191b728b8a5e1066992df1cff7bd7fd) ([merge request](gitlab-org/gitlab!65742))
- [Index batched migration jobs by max value](gitlab-org/gitlab@2d5ef1590c5838288c49098916c38ddc8d5d51fa) ([merge request](gitlab-org/gitlab!65838))
- [Delete legacy operations feature flags](gitlab-org/gitlab@f8b0938512861b3587cd4d3f639497b61ca9403d) ([merge request](gitlab-org/gitlab!63742))
- [Avoid splitting strings in repository maintenance UI](gitlab-org/gitlab@9991ad6bb0c1c9695815cb30268f19c3fd375ebd) ([merge request](gitlab-org/gitlab!65717))
- [Fix GLIcon size property](gitlab-org/gitlab@4db2830055a87cfad119b81f25feb85c09557843) ([merge request](gitlab-org/gitlab!63014))
- [Only reindex btree and gist indexes](gitlab-org/gitlab@ef4d7992c7499a741cc1c06ae19da8fec04d7e23) ([merge request](gitlab-org/gitlab!65655))
- [Refactoring string literals used for snowplow tracking in the sidebar](gitlab-org/gitlab@de218bbea3ae074b02600e92b6afdb7890a8cbee) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/65646)) **GitLab Enterprise Edition**
- [Refactor health status widget to use Apollo](gitlab-org/gitlab@90a2f8c15e10e97e7d20159e3a4647e4c81ec33a) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/6498)) **GitLab Enterprise Edition**
- [Migrate the deprecated "urlParamsToObject" to "queryToObject"](gitlab-org/gitlab@5c8c65cff8402a001374d29ef36d4cfca52df374) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/65398))
- [Improve gradle QA scenario](gitlab-org/gitlab@85558babfcd274db51c001a64e24c55966b4a69b) ([merge request](gitlab-org/gitlab!64419))
- [Update help for renamed documentation index](gitlab-org/gitlab@5a633772d51cdd7b9ece984a65a3601ef1cb5e2a) ([merge request](gitlab-org/gitlab!65624))
- [Improves repository storage-related UI and documentation](gitlab-org/gitlab@c75a61989f1460e871e0b6a8a55ee5946e84fd4f) ([merge request](gitlab-org/gitlab!65424))
- [Refactor health status widget to use Apollo](gitlab-org/gitlab@7374bf930c60c135909c26a4c8a839a89d003d8e) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/6498)) **GitLab Enterprise Edition**
- [Add rel property to help link](gitlab-org/gitlab@5e190f2f014ceb1ca00ae4963edc5a12cb50c6f5) ([merge request](gitlab-org/gitlab!65428))
- [Initialize conversion of ci_builds_metadata.id for bigint migration](gitlab-org/gitlab@af8c85075ce35cfe6578b1f761f11aec4c05693c) ([merge request](gitlab-org/gitlab!65477))
- [Remove project_statistics_sync feature flag](gitlab-org/gitlab@bc97e4b4a9f55a8826cc0f918a4d208cca0364d6) ([merge request](gitlab-org/gitlab!65435))
- [Improve repository maintenance UI and documentation](gitlab-org/gitlab@17a8bd10cb78fd7116eaf80c76d766175f1714ba) ([merge request](gitlab-org/gitlab!65117))
- [Migrate push_event_payloads.event_id back to integer (GitLab.com only)](gitlab-org/gitlab@dff68f62feebeffad35cf0f91b4e38f605495c79) ([merge request](gitlab-org/gitlab!65112))
- [Remove cached_markdown_blob feature flag](gitlab-org/gitlab@6d73a189cda67eaab7e2c78b5d730bbaabf06f69) ([merge request](gitlab-org/gitlab!65306))
- [Remove sort_dependency_vulnerabilities feature flag](gitlab-org/gitlab@b9e6510d14a92c76f1957a3f21976edb75285563) ([merge request](gitlab-org/gitlab!65295)) **GitLab Enterprise Edition**
- [Move prometheus service creation to the background job](gitlab-org/gitlab@a17b3d270c481dad35fe63905fa45f5f97845bbc) ([merge request](gitlab-org/gitlab!63539))
- [Add BG migration to delete orphaned deployments](gitlab-org/gitlab@098dd2f613346a189b25e56a4c1331bb536e7b6d) ([merge request](gitlab-org/gitlab!64588))
- [Remove by default enabled feature flag](gitlab-org/gitlab@41863bad8f0d0364d0caaa2b04d59dc1cfc85cdd) ([merge request](gitlab-org/gitlab!65151))
- [Enable new Rails connection handling](gitlab-org/gitlab@bbd1d564f971d749e89feabbfb3cc957f26cae92) ([merge request](gitlab-org/gitlab!65107))
- [Review and revise Audit Events UI text](gitlab-org/gitlab@4e4d6ecb6e3a9c5257a268e5f6efcdf83c6a1b36) ([merge request](gitlab-org/gitlab!60703)) **GitLab Enterprise Edition**
- [Add service desk project key validation error message](gitlab-org/gitlab@e022f59bf66e29724914cc65ad188a8b6ff424b8) ([merge request](gitlab-org/gitlab!64352))
- [Remove FF ci_fix_pipeline_status_for_dag_needs_manual](gitlab-org/gitlab@9dd55ed41f256b63c265d08506dfe8e6cdb6a3ef) ([merge request](gitlab-org/gitlab!64777))
- [Add FK for deployments.environment_id to environments table](gitlab-org/gitlab@343591ed3e8c304062ce0551699d2bfad25a33bf) ([merge request](gitlab-org/gitlab!64585))
- [Remove ci_artifacts_exclude feature flag](gitlab-org/gitlab@703711e4f5d097c00ca9cb13a5d1d41dc388a89b) ([merge request](gitlab-org/gitlab!64227))
- [Finalize conversion to bigint for push_event_payloads](gitlab-org/gitlab@b4def6d47dfb2648851f31d2ab83f1310a4628ef) ([merge request](gitlab-org/gitlab!64577))
- [Log WaitableWorker inline job executions](gitlab-org/gitlab@91ec53627907303b69951fc30cbe615da5c1494d) ([merge request](gitlab-org/gitlab!63997))
- [Remove default-enabled cascading_namespace_settings feature flag](gitlab-org/gitlab@ef2c2c8d1b68eff57a2b3ceea27bb265502ae645) ([merge request](gitlab-org/gitlab!64347))
- [Track finished_at timestamp for schema migrations](gitlab-org/gitlab@be15d17a8c84e7f09d5f413c43a177b679e08b0a) ([merge request](gitlab-org/gitlab!64204))
- [Drop remove_on_close column from labels table in envs where it exists](gitlab-org/gitlab@5fdca55006f089a4f01c1cf74f4c81e299e4e89e) ([merge request](gitlab-org/gitlab!62839))
- [Toggle codequality diff annotations flag](gitlab-org/gitlab@ba8277b89ffd762aa3cf368b893e6656e9f1e68e) ([merge request](gitlab-org/gitlab!64536))
- [Remove usage_data_code_review_aggregation feature flag](gitlab-org/gitlab@a7413e4284216cda36e26c90edcf6ab8c9a00521) ([merge request](gitlab-org/gitlab!64626))
- [Remove FF ci_workflow_rules_variables](gitlab-org/gitlab@3e25217fa3ce91da557275df41f4124dd7142e63) ([merge request](gitlab-org/gitlab!64557))
- [Cleanup group_devops_adoption feature flag](gitlab-org/gitlab@0783e2984f62fbc74612257bb44fb00d6959e510) ([merge request](gitlab-org/gitlab!64498)) **GitLab Enterprise Edition**
- [Remove ci_pipeline_latest feature flag](gitlab-org/gitlab@196edc110bb973cb29cc933e0343bba3326271d4) ([merge request](gitlab-org/gitlab!64423))
- [Remove ci_runners_tokens_optional_encryption ff](gitlab-org/gitlab@66c514ec56a1ffeba6a3a999c1cfb9bcfdc4ca5a) ([merge request](gitlab-org/gitlab!64425))
- [Update GitLab Runner Helm Chart to 0.30.0](gitlab-org/gitlab@d6bc1474cb288b8a234cda55ec427f831ce31bda) ([merge request](gitlab-org/gitlab!64462))
- [Decrease epic issues and child epics page size](gitlab-org/gitlab@4542ea3217d257a1f5c26cda5f2ee8d607950e86) ([merge request](gitlab-org/gitlab!63563)) **GitLab Enterprise Edition**
- [Remove invite_signup_page_interaction experiment](gitlab-org/gitlab@9fa990747351f1f8fbd1d323fe48c67c5e783735) ([merge request](gitlab-org/gitlab!63798))
- [Add internal docs for changing CI minute namespace](gitlab-org/gitlab@50d5ecf1dc2ebb9f6c2a3b6dcd5aa4b8161561de) ([merge request](gitlab-org/gitlab!64409)) **GitLab Enterprise Edition**
- [Add more logging to track encoding errors appending CI traces](gitlab-org/gitlab@6f240a53fe0d56910347a0615d575ac8c3e7215e) ([merge request](gitlab-org/gitlab!63920))
- [Remove diffs gradual load feature flag](gitlab-org/gitlab@027d7c4327b5b6205a84281239027273517bf81b) ([merge request](gitlab-org/gitlab!55478))
- [Remove partial index for Hashed Storage migration](gitlab-org/gitlab@3ed017a1023d7b0941a7606b69e6caee8d22f15c) ([merge request](gitlab-org/gitlab!62920))

## 14.0.12 (2021-11-05)

### Changed (4 changes)

- [Geo: Alternate redownload and normal design sync attempts](gitlab-org/gitlab@ed34172e5c7425316480efb732a9429e93e81017) ([merge request](gitlab-org/gitlab!73722)) **GitLab Enterprise Edition**
- [Geo: Alternate redownload and normal SSF sync attempts](gitlab-org/gitlab@c0f2f40b98c4b9fc72c21c474a2224e045263ea2) ([merge request](gitlab-org/gitlab!73722)) **GitLab Enterprise Edition**
- [Geo: Alternate redownload and normal project syncs](gitlab-org/gitlab@6370a7258719d5eb0ad83c54383ecb7f4fd54fc2) ([merge request](gitlab-org/gitlab!73722)) **GitLab Enterprise Edition**
- [Geo: Reduce frequency of redownload attempts](gitlab-org/gitlab@1bcd41f28733b01286a42689857f6530c0805186) ([merge request](gitlab-org/gitlab!73722)) **GitLab Enterprise Edition**

## 14.0.11 (2021-09-23)

### Fixed (1 change)

- [Fix Elastic::MigrationWorker current_migration](gitlab-org/gitlab@0b72aace30bff0fda7a114862ec1e389ddaa5ead) ([merge request](gitlab-org/gitlab!71101)) **GitLab Enterprise Edition**

## 14.0.10 (2021-09-02)

No changes.

## 14.0.9 (2021-08-31)

### Security (9 changes)

- [Update apollo_upload_server dependency](gitlab-org/security/gitlab@ced741d93fa664f0c152f524949258bf969b7667) ([merge request](gitlab-org/security/gitlab!1701))
- [Ensure shared group members lose project access after group deletion](gitlab-org/security/gitlab@3a41f4e29c01188aaaf01ab5e3deec2a9eeed18e) ([merge request](gitlab-org/security/gitlab!1685))
- [Fix stored XSS vulnerability in Datadog settings form](gitlab-org/security/gitlab@269e5bf96b5e97c3b8e6f6b8b3f593d958de2ecb) ([merge request](gitlab-org/security/gitlab!1672))
- [Inherit user external status while creating project bots](gitlab-org/security/gitlab@5bae4e53bd4c363270b2fc2e308b81d2a2a388a6) ([merge request](gitlab-org/security/gitlab!1666))
- [Escape issue reference and title for Jira issues](gitlab-org/security/gitlab@0397f2b393d563559c49c39c0ba1d192d08a10d7) ([merge request](gitlab-org/security/gitlab!1663)) **GitLab Enterprise Edition**
- [Require sign in for .keys endpoint on non-public instances](gitlab-org/security/gitlab@13a7f6001f663b3745159fa37b518ba4a43355bd) ([merge request](gitlab-org/security/gitlab!1659))
- [Update Import/Export to use public email when mapping users](gitlab-org/security/gitlab@f3d1b800af55986cef83aeaf4df1312e3070f0c5) ([merge request](gitlab-org/security/gitlab!1654)) **GitLab Enterprise Edition**
- [Only create jira connect NS subscriptions for admins](gitlab-org/security/gitlab@34bdcd45f24eaa051702834fb6c3568e45721004) ([merge request](gitlab-org/security/gitlab!1647))
- [Prevent non-admins from configuring Jira connect app](gitlab-org/security/gitlab@4af692246224b1cd1e2fe3c6d0ac2613c0f8fe39) ([merge request](gitlab-org/security/gitlab!1643))

## 14.0.8 (2021-08-25)

### Fixed (1 change)

- [Fix: Sidekiq workers delete each other's metrics](gitlab-org/gitlab@98a85fcbcdf2f8dfef83e552a850591e8952c057) ([merge request](gitlab-org/gitlab!68761))

### Changed (1 change)

- [Resolve "operator does not exist: integer[] || bigint in...](gitlab-org/gitlab@273cc43f7928e89fd11237b58fdfdfb8a24e5493) ([merge request](gitlab-org/gitlab!68761))

### Other (1 change)

- [Revert backfill on ci_build_trace_sections](gitlab-org/gitlab@10a5ad9dce9014eb8af6493402dcdd1658dbd62a) ([merge request](gitlab-org/gitlab!68761))

## 14.0.7 (2021-08-03)

### Security (18 changes)

- [Add project member validation for domain limitation](gitlab-org/security/gitlab@f9a0e78111cbbfe93b6f8ca27bd9f064e146d005) ([merge request](gitlab-org/security/gitlab!1563))
- [Hide project-level CI/CD Analytics for Guests](gitlab-org/security/gitlab@56a17ae80c1f179bcdf939d6b8e71737f9501949) ([merge request](gitlab-org/security/gitlab!1574))
- [Only allow invite to be accepted by user with matching email](gitlab-org/security/gitlab@a79d0e6dbbc32247c10c4928a04f0149071eb5fe) ([merge request](gitlab-org/security/gitlab!1633))
- [Add html escaping for default branch name](gitlab-org/security/gitlab@d26f0c4d5ef386100d40e92f815b7e754fccacc3) ([merge request](gitlab-org/security/gitlab!1631))
- [Configure OmniAuth to use GitLab AppLogger](gitlab-org/security/gitlab@dfcff90cb86fac0dff05d8bd5f25f46da2cc8ce0) ([merge request](gitlab-org/security/gitlab!1616))
- [Add permissions check to pipelines#show action](gitlab-org/security/gitlab@c611a8154dc5776a0767b4153ff8963d46e7f39a) ([merge request](gitlab-org/security/gitlab!1613))
- [Prevent impersonation in gitlab-shell SSH certs](gitlab-org/security/gitlab@320457b16cbfd5dec4e05937c4d61b96aba4c290) ([merge request](gitlab-org/security/gitlab!1610))
- [Fix Protected Environment Accesses Cleanup](gitlab-org/security/gitlab@99846cdeda6acf6223fb0ee5364e375765d3cbb1) ([merge request](gitlab-org/security/gitlab!1607)) **GitLab Enterprise Edition**
- [Do not show email address in error message](gitlab-org/security/gitlab@5c4adf419e38f0fd9d540d2f7cd9d14888bc6b96) ([merge request](gitlab-org/security/gitlab!1597)) **GitLab Enterprise Edition**
- [Disallow non-members to set issue metadata on issue create](gitlab-org/security/gitlab@0bb4499e5f4514beb647d0e6ac3f9b15720c42ce) ([merge request](gitlab-org/security/gitlab!1581))
- [Prevent guests from linking issues with errors](gitlab-org/security/gitlab@94462a56e9490ddd85ec7d1d869b6fda2042fb99) ([merge request](gitlab-org/security/gitlab!1588))
- [Block impersonation token use if it is not permitted](gitlab-org/security/gitlab@31b8bc506dd89a576a2cda094c711c22be764398) ([merge request](gitlab-org/security/gitlab!1584))
- [Updates oauth to 0.5.6](gitlab-org/security/gitlab@c839b6107c41bcd02e048d0ae0499c140bfbec1c) ([merge request](gitlab-org/security/gitlab!1568))
- [Remove impersonation token from api response for non-admin user](gitlab-org/security/gitlab@845dc284cc8ee8736e4f65740d61ffeb197f7b7c) ([merge request](gitlab-org/security/gitlab!1566))
- [Filter todos whose target users no longer have access to](gitlab-org/security/gitlab@a6c81e5cadb277f80d1b9565700f8b1f201cfb05) ([merge request](gitlab-org/security/gitlab!1554))
- [Fix tag ref detection for pipelines](gitlab-org/security/gitlab@cd5f61dc50c44d69896b38f3bd44129a8f1f01d8) ([merge request](gitlab-org/security/gitlab!1548))
- [Restrict access to instance-level security features for reporters](gitlab-org/security/gitlab@c8a75e8032c68065524a85f7030960b614a915bd) ([merge request](gitlab-org/security/gitlab!1539)) **GitLab Enterprise Edition**
- [Fix XSS in Mermaid Markdown rendering](gitlab-org/security/gitlab@86139e79c13cf87183cdec9f84ec114cdfc6d215) ([merge request](gitlab-org/security/gitlab!1489))

## 14.0.6 (2021-07-20)

### Fixed (4 changes)

- [Fix validation method regarding MIME type keys](gitlab-org/gitlab@2cc6d89cc77368b9472c8ec22e97bb3481409fb3) ([merge request](gitlab-org/gitlab!66403))
- [Geo: Fix snippet verification by replicating the HEAD ref](gitlab-org/gitlab@4dbf36af8553775603c170784ad8bfcdc436a669) ([merge request](gitlab-org/gitlab!66403)) **GitLab Enterprise Edition**
- [Fix LFS objects not downloading with Bitbucket](gitlab-org/gitlab@161776f9a4975dfeb2760b06e83160def902c61f) ([merge request](gitlab-org/gitlab!66403))
- [Replace Excon with Faraday for requesting object storage](gitlab-org/gitlab@a223d526d5b97f248c8810ef0b968d2c3b0323e0) ([merge request](gitlab-org/gitlab!66403))

## 14.0.5 (2021-07-08)

### Fixed (4 changes)

- [Return empty strings for Jira links when URL is not set](gitlab-org/gitlab@6da7890d8137b1879297ad81c6737312d6f672b3) ([merge request](gitlab-org/gitlab!65728))
- [Add prefix to autocomplete path](gitlab-org/gitlab@5256ab7db346610a816ebb975ae9a6ce0d853435) ([merge request](gitlab-org/gitlab!65728))
- [Do not create audit event for failed logins on read-only DB](gitlab-org/gitlab@30c7944ddddfe92566b3f66a7f549bef3ffd8d82) ([merge request](gitlab-org/gitlab!65728)) **GitLab Enterprise Edition**
- [Fix git clone for projects with a trailing dot over HTTP](gitlab-org/gitlab@a91be9412a09b069390cc33c14d1bc72216cdbf0) ([merge request](gitlab-org/gitlab!65728))

### Other (1 change)

- [Initialize conversion of ci_builds_metadata.id for bigint migration](gitlab-org/gitlab@34522b102be43118063aa3245d23af313173700d) ([merge request](gitlab-org/gitlab!65728))

## 14.0.4 (2021-07-07)

### Security (1 change)

- [Disable file and network premailer strategies](gitlab-org/security/gitlab@4af58e3d8ee1b25048f34208db6e685cf0bf1411) ([merge request](gitlab-org/security/gitlab!1544))

## 14.0.3 (2021-07-06)

### Fixed (7 changes)

- [Fix deploy keys not working with LFS auth check](gitlab-org/gitlab@134b244c7f59f8a20cb191bc0d2aaa43171f3d6e) ([merge request](gitlab-org/gitlab!65498))
- [DevOps Adoption - ensure displayNamespaceId is included](gitlab-org/gitlab@1166130f1e6786a8c96735b6518241fb704047b1) ([merge request](gitlab-org/gitlab!65498)) **GitLab Enterprise Edition**
- [Geo - Fix state value in the lfs_object_registry table](gitlab-org/gitlab@b6f30299d255949b79d149ee71ee50025ac0c8c2) ([merge request](gitlab-org/gitlab!65498)) **GitLab Enterprise Edition**
- [Fix broken Time Tracking Reports on Issuable sidebar](gitlab-org/gitlab@da0b4a92f791a3f621ec8da8e2fbb0ad4e39d399) ([merge request](gitlab-org/gitlab!65498))
- [Fix bug where Milestone page led to console error](gitlab-org/gitlab@179948d489ed92f5d8158c23190430e819941a29) ([merge request](gitlab-org/gitlab!65498))
- [Fix frequent items timestamps not updated](gitlab-org/gitlab@481d4d36252dc91291afe9dacd7d48558878d27f) ([merge request](gitlab-org/gitlab!65498))
- [Fix pages deployment storage migration](gitlab-org/gitlab@0eab6e579890c557bf97dd48dd6a2a7adaf97358) ([merge request](gitlab-org/gitlab!65498))

### Changed (2 changes)

- [Geo - Move migration to a pre-deployment migration](gitlab-org/gitlab@84327652855cafe36c574df798322b63d0649561) ([merge request](gitlab-org/gitlab!65498)) **GitLab Enterprise Edition**
- [Reintroduce recursive_approach_for_all_projects default-enabled](gitlab-org/gitlab@14b3aa69cad85541ae6b845b346c80d1eaea099b) ([merge request](gitlab-org/gitlab!65498))

## 14.0.2 (2021-07-01)

### Added (1 change)

- [Added omniauth_user check when verifying user cap](gitlab-org/security/gitlab@68c5d856fbf83f5f5ade562ea84b6aa06db96c60) ([merge request](gitlab-org/security/gitlab!1501)) **GitLab Enterprise Edition**

### Security (14 changes)

- [Update rdoc to 6.3.1](gitlab-org/security/gitlab@341334cbb2d822f6aa057933934b819c34b87932) ([merge request](gitlab-org/security/gitlab!1533))
- [Forbid GET requests with mutations](gitlab-org/security/gitlab@895c99b35efa6795fb050bfb4ef4574f3e32a373) ([merge request](gitlab-org/security/gitlab!1528))
- [Prevent GraphQL API access by deactivated users](gitlab-org/security/gitlab@2dda4163dadc04b59ee3367990b72bee933adf9b) ([merge request](gitlab-org/security/gitlab!1525))
- [Add sanitizing for name field](gitlab-org/security/gitlab@ecb5a598b87d670906df67ed4432426a375efa05) ([merge request](gitlab-org/security/gitlab!1499))
- [Copy feature visibility settings to a fork](gitlab-org/security/gitlab@fcc87978b1c865c8bdcb3fc5d8dc221b7370192c) ([merge request](gitlab-org/security/gitlab!1522))
- [Fix XSS on audit log for feature flag actions](gitlab-org/security/gitlab@94fc41d49e828a6457f1de31f2b239b087679c12) ([merge request](gitlab-org/security/gitlab!1521))
- [Avoid disclosing project in web IDE](gitlab-org/security/gitlab@9de99878401713bc5f3a76ca85901dc3a9ca0cd8) ([merge request](gitlab-org/security/gitlab!1511))
- [Sanitize input on pasteGFM](gitlab-org/security/gitlab@7bb97cfa11a11bb0725bc707dec73831e16fe177) ([merge request](gitlab-org/security/gitlab!1514))
- [Fix merge request diff display issue with unsupported encoding](gitlab-org/security/gitlab@8c21afdce6c6214c14db1863df1aad80ed501377) ([merge request](gitlab-org/security/gitlab!1509))
- [Fix deploy key fallback issue in protected branch](gitlab-org/security/gitlab@a24aa5412a8f1dad01359de6b2f0b66bb741f5d4) ([merge request](gitlab-org/security/gitlab!1508))
- [Add total http read timeout](gitlab-org/security/gitlab@cf4e0aa0a3f668fb63de6721d062c3157fdd9f84) ([merge request](gitlab-org/security/gitlab!1507))
- [Allow only same-origin URLs for Edit Release Cancel button](gitlab-org/security/gitlab@4b78e1e31f0a23b964953b1766d156e12a75115f) ([merge request](gitlab-org/security/gitlab!1506))
- [Update Nokogiri to 1.11.4](gitlab-org/security/gitlab@c43001973ca1b684b4719f5559819179be2394da) ([merge request](gitlab-org/security/gitlab!1500))
- [Add new username validation](gitlab-org/security/gitlab@c904a128f2c2262288d00f673294423316318f4d) ([merge request](gitlab-org/security/gitlab!1498))

## 14.0.1 (2021-06-24)

### Fixed (3 changes)

- [Remove add button from Devops Adoption](gitlab-org/gitlab@1c60bdf5daf64f10f001eeb5134f08a53a148d90) ([merge request](gitlab-org/gitlab!64764)) **GitLab Enterprise Edition**
- [DevOps Adoption - ensure displayNamespaceId is included](gitlab-org/gitlab@9eb7cd5212cfc19f4cd6578c8e4afc7b4da27eab) ([merge request](gitlab-org/gitlab!64764)) **GitLab Enterprise Edition**
- [Add Helm-2to3.gitlab-ci.yml to Auto DevOps](gitlab-org/gitlab@61ac7f46b06fcf151be62407dc0837a44843800e) ([merge request](gitlab-org/gitlab!64764))

## 14.0.0 (2021-06-21)

### Added (116 changes)

- [Add Packages::Helm::ProcessFileService](gitlab-org/gitlab@dae2f102ec92a656eb56a753fa7dc625e3489ae3) ([merge request](gitlab-org/gitlab!62760))
- [Add unique index for Helm packages](gitlab-org/gitlab@cb08762e7c878e3dd0a1ca9f922f387f8b8e453a) ([merge request](gitlab-org/gitlab!62760))
- [Disable policies linked to no container repositories](gitlab-org/gitlab@120e0486368cff65da3782de377c82ec47a0b28e) ([merge request](gitlab-org/gitlab!62461))
- [Allow storing detection_method in vulnerability findings](gitlab-org/gitlab@e2a66be7a2b5d3f14c3698e0c74214b4164c0b9c) ([merge request](gitlab-org/gitlab!63989))
- [Expose `humanTimeEstimate` & `humanTotalTimeSpent`](gitlab-org/gitlab@4d078467643f9d3c48e43b18c706bb42746b9434) ([merge request](gitlab-org/gitlab!64081))
- [Make max diff files and max diff lines configurable](gitlab-org/gitlab@3e26e2528384efcd6e1b0b2e28c6aca687a23d6a) ([merge request](gitlab-org/gitlab!56722))
- [Add GraphQL endpoint to list agent configurations (via KAS)](gitlab-org/gitlab@d91cbf733ddbb6b9369efe1fecdb8b6fce6384ee) ([merge request](gitlab-org/gitlab!62646)) **GitLab Enterprise Edition**
- [Add checkbox in group settings for prevent sharing outside hierarchy](gitlab-org/gitlab@86eb11f2523f441f9a97f69c950816596208b0ab) ([merge request](gitlab-org/gitlab!63810))
- [Add "Enterprise" badge to users that are provisioned via SAML/SCIM](gitlab-org/gitlab@5f961f652a202d7dcbe872d827a48eb0e2bfd17b) ([merge request](gitlab-org/gitlab!63474)) **GitLab Enterprise Edition**
- [Update Bulk Import state more accurately](gitlab-org/gitlab@cea74ea42d4464c30ff39ca929b2bdadcb7083de) ([merge request](gitlab-org/gitlab!63883))
- [Enable DB Load-balancer flag USE_NEW_LOAD_BALANCER_QUERY by default](gitlab-org/gitlab@b44a37ba10472f7797867b988e41f7548c093e02) ([merge request](gitlab-org/gitlab!63910))
- [Allow toggle job_token_scope_enabled via GraphQL](gitlab-org/gitlab@3ca540c424d26e8f9cad16f846a7ca4366cd74b1) ([merge request](gitlab-org/gitlab!63778))
- [Publish package hash on Package Page](gitlab-org/gitlab@df0417560c5eb9438a1dcba46b94adcc191a8ae2) ([merge request](gitlab-org/gitlab!63279))
- [Add backend support for Coverage-Check rule](gitlab-org/gitlab@d8d6a39c1dc6fa51d5c29aea777f2d7bc820c9d8) ([merge request](gitlab-org/gitlab!63079))
- [Add project setting to toggle job token scope](gitlab-org/gitlab@99aacbf5339605d7e7116285e245508f48370456) ([merge request](gitlab-org/gitlab!63446))
- [Scope JobToken to only authorized projects](gitlab-org/gitlab@a8016a6bb4a7f446d77b7738260425fa65c01e01) ([merge request](gitlab-org/gitlab!63446))
- [Scope JobToken to only authorized projects](gitlab-org/gitlab@22718b69b813d7af3d17eac79b66ade310678392) ([merge request](gitlab-org/gitlab!63446))
- [Mark pending todo as done when resolving design discussions](gitlab-org/gitlab@0a27c129bc1ccab09be9f5e71ed194b55394caaf) ([merge request](gitlab-org/gitlab!62951))
- [Migration for fixing missing traversal ids](gitlab-org/gitlab@cb53af00930569beb75ee50f713858fb99fb90bc) ([merge request](gitlab-org/gitlab!63847))
- [Add qrtly reconciliation alert](gitlab-org/gitlab@c263de9b122c2e00899674b65d3cc0f5e5bf8d10) ([merge request](gitlab-org/gitlab!63181)) **GitLab Enterprise Edition**
- [Enable by default FF sidebar_refactor](gitlab-org/gitlab@8fefd5b5a6e5f1bf4963038c433d7bdfbe570f33) ([merge request](gitlab-org/gitlab!61679))
- [Add time_change in Issue, MR and Note webhook](gitlab-org/gitlab@56bf4a7f980bdb6304d4e71717e3ff8274b9b6b5) ([merge request](gitlab-org/gitlab!55087))
- [Prepopulates the pipeline editor with a 3 stage template](gitlab-org/gitlab@d8a1ad6125ba7f6cb33c8f67cbf67e751f94c3e9) ([merge request](gitlab-org/gitlab!63498))
- [Add commit type to generic security reports](gitlab-org/gitlab@3a367350f0339a6faa44db5e3d86cc7e3e933c2d) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/63723)) **GitLab Enterprise Edition**
- [Adjust indexes for iterations and iteration cadences](gitlab-org/gitlab@45702b59f5dace0b416ec7908dcf13e72e23fc57) ([merge request](gitlab-org/gitlab!62348))
- [Epic Boards](gitlab-org/gitlab@0531b906b69fa81b99672ff15975e7eb1dfd6cbe) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/62644)) **GitLab Enterprise Edition**
- [Add order_project_path to package graphql API sort](gitlab-org/gitlab@76ed62782a0dd62f9dd66a31ce127afd3cd0c40f) ([merge request](gitlab-org/gitlab!62473))
- [Add provisioning group to pipeline validation payload](gitlab-org/gitlab@43d8c865b51da106fd75b2875b956a30259dba88) ([merge request](gitlab-org/gitlab!63606)) **GitLab Enterprise Edition**
- [Add index for description in ci_runners table](gitlab-org/gitlab@b9b33ee15c9d1a9f8ed166314dce862d84903f22) ([merge request](gitlab-org/gitlab!63036))
- [Show security report scan errors on pipeline view](gitlab-org/gitlab@61418b8ad3a66e062ae486839c40331e8c837302) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/62971)) **GitLab Enterprise Edition**
- [Upgrade GitLab Pages to 1.40.0](gitlab-org/gitlab@6eaf97ebc6828d06bc9a0d90e96969ccb89a0793) ([merge request](gitlab-org/gitlab!63610))
- [Check hierarchy sharing settings in GroupLinks::CreateService](gitlab-org/gitlab@aa55411bd92550190098e9410233a67794618087) ([merge request](gitlab-org/gitlab!63107))
- [Allow user to create epics via epic board list](gitlab-org/gitlab@df231ee29d04e0bfce6b40ba5c45a9d2ab010816) ([merge request](gitlab-org/gitlab!62455)) **GitLab Enterprise Edition**
- [Create table for tracking ci minute purchases](gitlab-org/gitlab@d9d7332981ed423b40f25016254ef6e71d263054) ([merge request](gitlab-org/gitlab!62393)) **GitLab Enterprise Edition**
- [Add epic's note system_note_meta to import/export](gitlab-org/gitlab@ca32a0f9d848b4d8a8086dd2aab15525b92cdbcf) ([merge request](gitlab-org/gitlab!63551)) **GitLab Enterprise Edition**
- [Add Group Avatar endpoint](gitlab-org/gitlab@b8f7c83542d4ec5a994228098c426d002d2813c3) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/62596))
- [Add Content Editor support for wikis](gitlab-org/gitlab@2dddbe794cf79b28c98cd11002860a16563958f7) ([merge request](gitlab-org/gitlab!62919))
- [Enable CORS headers for OpenID Connect discovery endpoints](gitlab-org/gitlab@fdfb3420cca8d54baaa8181b126433fbaf41bb8b) ([merge request](gitlab-org/gitlab!63276))
- [Add a GET endpoint to user preferences](gitlab-org/gitlab@d0a597155ae4f526626ad494777202b1ccc8b2ad) ([merge request](gitlab-org/gitlab!63462))
- [Escaped markdown not interpreted as shortcuts](gitlab-org/gitlab@f8e1fb75d5eac0876ffdd249f26943799fdd0be7) ([merge request](gitlab-org/gitlab!63452))
- [Allow to make test cases confidential](gitlab-org/gitlab@fa6b3af2e457b2ea056ccfd89fc0a2bc8c4d697e) ([merge request](gitlab-org/gitlab!63098)) **GitLab Enterprise Edition**
- [Add is_shared and runner_type to hooks and API responses](gitlab-org/gitlab@342cd36c4bc4b94caf45eb8516bba985f967dbb6) ([merge request](gitlab-org/gitlab!62942))
- [Enable reporting of usage data for Jira integration](gitlab-org/gitlab@45ce55af6f7f9de0de064dfcbf42e51589d8bf7b) ([merge request](gitlab-org/gitlab!63184))
- [Create metric events for service desk emails](gitlab-org/gitlab@1ec39fb2ff13f1828821b6e1844a3b779337cbc7) ([merge request](gitlab-org/gitlab!63037))
- [Add option to disable printing of root password during DB seeding](gitlab-org/gitlab@9e06ec3a768a08320eea3818b056d3416072c7b1) ([merge request](gitlab-org/gitlab!63271))
- [Allow users to specify their pronouns](gitlab-org/gitlab@5c6be0aaabeb0b4d34ec5d149d0a6ffb8b4e8971) ([merge request](gitlab-org/gitlab!63221))
- [Gracefully handle query timeouts for project VSA](gitlab-org/gitlab@c334e13a81c1f53986429c6f5a14508401baae60) ([merge request](gitlab-org/gitlab!63301))
- [Add title and tooltip to diff preferences dropdown](gitlab-org/gitlab@b6762723f91eb15bd45dc0550b0ac79f622ae47b) ([merge request](gitlab-org/gitlab!61840))
- [Add group-level lead time charts](gitlab-org/gitlab@84a5e859181c7b7d7475bd26e8cc7969455ee486) ([merge request](gitlab-org/gitlab!62941)) **GitLab Enterprise Edition**
- [Change pipeline url to have underline](gitlab-org/gitlab@ee4ad9fa9738e45d6a74cdc2abba73f9869ce548) ([merge request](gitlab-org/gitlab!63325))
- [Add danger for merge trains](gitlab-org/gitlab@a7337266dd61ced6f27d1763d4e890c359401288) ([merge request](gitlab-org/gitlab!63094))
- [Optionally include trailers in the commits API](gitlab-org/gitlab@b8fefa073aeedcf2c34a0d4d1b36c5df88fe4a20) ([merge request](gitlab-org/gitlab!63228))
- [Add compliance tab to redesigned Security-Configuration Page](gitlab-org/gitlab@632524a7b5a441b54577568713578539e8769dd6) ([merge request](gitlab-org/gitlab!63078))
- [Instrumenting project sidebar menus](gitlab-org/gitlab@6e4caf1fffb5b73884362cc74757f5c60cac6035) ([merge request](gitlab-org/gitlab!62030))
- [Add upcoming_reconciliations table and model](gitlab-org/gitlab@b28478bdf19bd78c4a452b8da63849a390387789) ([merge request](gitlab-org/gitlab!63054))
- [Support graceful shutdown of Workhorse connections](gitlab-org/gitlab@73f323b077834b80574b807853e3f5b0fd11b780) ([merge request](gitlab-org/gitlab!62701))
- [Add Clone with VS Code for SSH](gitlab-org/gitlab@d0ee6aa31e987003b54d71356fd70371055573d3) ([merge request](gitlab-org/gitlab!59396))
- [Get ancestors of an Epic using GraphQL](gitlab-org/gitlab@63aa2fb0628c110bdba6d4234d4eb63f3954ab02) ([merge request](gitlab-org/gitlab!61154)) **GitLab Enterprise Edition**
- [Add wiki page diff url to Slack notification message](gitlab-org/gitlab@452b791834cbc7530ce3854c2503a6234ed880f0) ([merge request](gitlab-org/gitlab!63082))
- [Allow administrators to enable automatic deactivation of dormant users](gitlab-org/gitlab@029bc739503ba10b90d438851526c8eccac505ef) ([merge request](gitlab-org/gitlab!62969))
- [Add pipeline source to custom CI_JOB_JWT claims](gitlab-org/gitlab@572ad1851d9ae2f47e7da560e7f071d5f184c6b2) ([merge request](gitlab-org/gitlab!62754))
- [Display credit card status in /admin/users/:id page](gitlab-org/gitlab@7914eeffb19b8eeb991be0b21e86672aeae7c3c1) ([merge request](gitlab-org/gitlab!62803)) **GitLab Enterprise Edition**
- [Allow users to delete items from the package file list](gitlab-org/gitlab@750cca34851a633eeea0d0012371264affe68c32) ([merge request](gitlab-org/gitlab!62179))
- [Show generic 'code' type on vuln details](gitlab-org/gitlab@b9af9a5e1734cfce757ea884681f3c1de5f785b2) ([merge request](gitlab-org/gitlab!62861)) **GitLab Enterprise Edition**
- [Add ability to search instanceSecurityDashboard.projects GraphQL query](gitlab-org/gitlab@e6d18ad71821410f33edb6196f9cf9636f375934) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/62933)) **GitLab Enterprise Edition**
- [Add `latest_pipeline_id` column to `vulnerability_statistics` table](gitlab-org/gitlab@d99873557afd16716de7249b5e0511ae3a43d420) ([merge request](gitlab-org/gitlab!62610))
- [Import group boards & board lists via ndjson when using Bulk Import](gitlab-org/gitlab@1d5dab27000c359bf148bdaf6011fa19e755bf3e) ([merge request](gitlab-org/gitlab!62668)) **GitLab Enterprise Edition**
- [Add an option to expose description_html in Release API](gitlab-org/gitlab@687a7cc9bf3360151dc055dd84e87ec4ce000b3f) ([merge request](gitlab-org/gitlab!62802))
- [Render table types on generic vulnerability report](gitlab-org/gitlab@3f4feebaab10d79d5567b733bb0fd8bc7b844d7c) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/62546)) **GitLab Enterprise Edition**
- [Remove Web Application Firewall related frontend files](gitlab-org/gitlab@2e2382d16b3595c9a9adb5a7fe0c176ee198f702) ([merge request](gitlab-org/gitlab!61489)) **GitLab Enterprise Edition**
- [Add link to navigate to profile settings page](gitlab-org/gitlab@0fdb5b9536764e6573da243ed84516f3ab9e2b3d) ([merge request](gitlab-org/gitlab!62791))
- [Persist the `page` parameter for VSA pagination](gitlab-org/gitlab@3df8ae120ad7ba7edff4e9a075a804ab3d24cba0) ([merge request](gitlab-org/gitlab!62439)) **GitLab Enterprise Edition**
- [Adds block_changes_at to LicenseType in GraphQL](gitlab-org/gitlab@344eec81dc069f821756f8f2fc8b4f0c935574d0) ([merge request](gitlab-org/gitlab!62510)) **GitLab Enterprise Edition**
- [Add .drafts scope to MergeRequests](gitlab-org/gitlab@93c77e146328d539476f7aaca365629df1c8f342) ([merge request](gitlab-org/gitlab!62718))
- [Add delete branch modals behind feature flag](gitlab-org/gitlab@e006d7b35cfcdb6c4c95ab6dc5b8dd54a0a8dbed) ([merge request](gitlab-org/gitlab!56782))
- [Add the documentation for sidekiq routing rules](gitlab-org/gitlab@4a476ebb0735bb761b0f46d9c0d6a17ce2b3c33f) ([merge request](gitlab-org/gitlab!60479))
- [Helm chart download API endpoint](gitlab-org/gitlab@13ff8bde2fdf7b8cd81cc7024000733c88728033) ([merge request](gitlab-org/gitlab!61014))
- [Add custom header text to free personal namespaces billing page](gitlab-org/gitlab@f711ee6ab906d14604dbc1dd7fd3fb301bd08a1a) ([merge request](gitlab-org/gitlab!62365))
- [Add delete escalation policy GraphQL mutation](gitlab-org/gitlab@64f1ae7cb0cf8a9a5c8f930c95beb7a504c00ee9) ([merge request](gitlab-org/gitlab!62009))
- [Add file-location component for generic security reports](gitlab-org/gitlab@893aa26510e5a96df7535757a8d3214c1d0a036d) ([merge request](gitlab-org/gitlab!62653)) **GitLab Enterprise Edition**
- [Store CI runner config data](gitlab-org/gitlab@dca1424b5efdf5900e9b3a3e17a3572509af5aba) ([merge request](gitlab-org/gitlab!57953))
- [Expose the state field for vulnerability findings](gitlab-org/gitlab@29e8f53a59d511e65604490742b73992219e375a) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/62147)) **GitLab Enterprise Edition**
- [Add graphql API to list Scan Execution Policies](gitlab-org/gitlab@6db5e69a42438e766e510b59e1288fc67c87b8c2) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/62403)) **GitLab Enterprise Edition**
- [Support custom messages in the cherry-pick API](gitlab-org/gitlab@5a7d3be2be0aac8b3c66864775e0b0e8fbd960d0) ([merge request](gitlab-org/gitlab!62481))
- [Add post migration to cleanup orphaned records](gitlab-org/gitlab@0d346291f613e7e3191e844d4bbd4a1f06a71a09) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/61787))
- [GraphQl: Allow filtering epics by negated parameters](gitlab-org/gitlab@b44e246b909cb929f87a93b937d28fbe93fd3261) ([merge request](gitlab-org/gitlab!61823))
- [Add finding evidence header](gitlab-org/gitlab@d79129b4f1a4dd2d27e94bf2975b880df426966e) ([merge request](gitlab-org/gitlab!61402))
- [Add module-name component for generic security reports](gitlab-org/gitlab@6144a4a1a6eb3e2e459d00e925544a4112821153) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/62447)) **GitLab Enterprise Edition**
- [Use assignee sidebar widget in the alert drawer](gitlab-org/gitlab@7c29ff14ffcad46869c97086edb3cac9c6ce48cf) ([merge request](gitlab-org/gitlab!61839)) **GitLab Enterprise Edition**
- [Add 'show_whitespace_in_diffs' to the UserPreferences endpoint](gitlab-org/gitlab@896b2d6efee062f89b7daebcf4ee551fc7e153e4) ([merge request](gitlab-org/gitlab!62245))
- [Update button variants alignment and spacing](gitlab-org/gitlab@b7a9bbd3f0752a33b264e50dd85706d39faacb10) ([merge request](gitlab-org/gitlab!61791))
- [Allow recording of experiment subjects](gitlab-org/gitlab@2d6bff529163940b8e7f6ef342cb51b9c4cae1a3) ([merge request](gitlab-org/gitlab!61914))
- [Set the git default branch to "main"](gitlab-org/gitlab@a8bfdf5729ec45c3bbcb0f2dff7a901f0ed54884) ([merge request](gitlab-org/gitlab!62467))
- [Add memory view to Performance Bar](gitlab-org/gitlab@865cd871e58d58e2dc372c45c5e7722435fb88a3) ([merge request](gitlab-org/gitlab!61332))
- [Add user IP data to external pipeline validation service](gitlab-org/gitlab@410b7bceb82136eddf3709a612c9bea946d93afd) ([merge request](gitlab-org/gitlab!62438))
- [Backfill primary key migration for self-managed instances](gitlab-org/gitlab@3da2450dc1d9ca7ab0157792ea395e9d248b382c) ([merge request](gitlab-org/gitlab!61321))
- [Makes the invite button on empty projects permanent](gitlab-org/gitlab@20ded4ce65e8e3928fe577a97a540fc294f58f68) ([merge request](gitlab-org/gitlab!62417))
- [Restrict trial during free signup to company users](gitlab-org/gitlab@26aa54acfa50e08ea96d667940a9d2d6e7b78c5c) ([merge request](gitlab-org/gitlab!62382))
- [Add credit card validation checkbox to admin users panel](gitlab-org/gitlab@508e926c0bb2ee2ad2c43b7f7e434c9faf344b69) ([merge request](gitlab-org/gitlab!62160))
- [Delay worker execution for workers utilizing LB](gitlab-org/gitlab@1c82d36c06cdfc04a8259faf587423a693a24991) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/62374))
- [Optionally start a trial during free signup](gitlab-org/gitlab@c6ed9500c8d0ae9a51b0a0278cd7454c18ed75b6) ([merge request](gitlab-org/gitlab!62174))
- [Adds content to createCommit mutation](gitlab-org/gitlab@bd5eaf0b2eda7890aa0db47f3f63031c8589693f) ([merge request](gitlab-org/gitlab!60938))
- [Add dast_runner_site_validation feature flag](gitlab-org/gitlab@c5a9d59cd97cb99f12ed34189a60dfd22fedcc66) ([merge request](gitlab-org/gitlab!62299))
- [Add GraphQL types for escalation policies and rules](gitlab-org/gitlab@2879b4a12d34491ad2100667392e0bcea183c8aa) ([merge request](gitlab-org/gitlab!62299))
- [Debian Group and Project Distribution Keys schema](gitlab-org/gitlab@38ca1e1860bc7181d7c19c8de0bd54a4fdfd853f) ([merge request](gitlab-org/gitlab!62012))
- [Compress oversized Sidekiq job payload before dispatching into Redis](gitlab-org/gitlab@ce40f0010967d17b40c17b7b1d7c8a7040374187) ([merge request](gitlab-org/gitlab!62012))
- [Add metrics to calculate rate of project imports](gitlab-org/gitlab@8b694f1b82a226c06a546123996601de02014274) ([merge request](gitlab-org/gitlab!62012))
- [Enable Kroki on reStructuredText and Textile documents](gitlab-org/gitlab@9d799fd9d5b702f7ad190a4063935aeef2ee5597) ([merge request](gitlab-org/gitlab!62012))
- [Add admin page for batched background migrations](gitlab-org/gitlab@575187d9fdbdc1bd6a374a1abec6b6e1e3a6b24a) ([merge request](gitlab-org/gitlab!62012))
- [Remove threat_monitoring_alerts feature flag](gitlab-org/gitlab@2efff7692093008ebd8fb0495aad303ddbc16e53) ([merge request](gitlab-org/gitlab!62148))
- [Add GraphQL types for escalation policies and rules](gitlab-org/gitlab@078890677fbd80545445e9b424e42463a0ca0df7) ([merge request](gitlab-org/gitlab!61439))
- [Update button variants and avatar layout](gitlab-org/gitlab@4bf39340d0afc449d6c112f0c114cb2fc9828d79) ([merge request](gitlab-org/gitlab!61504))
- [Add admin page for batched background migrations](gitlab-org/gitlab@0203c5dd44f5f97318d08f75c69c604055ee1bf5) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/60911))
- [Add Sidekiq payload compression log fields](gitlab-org/gitlab@4ab91e3ecfbe3063f42eb307b956c159fd555801) ([merge request](gitlab-org/gitlab!61667))
- [Add Sidekiq payload decomression server middleware](gitlab-org/gitlab@4a9999355056dad75cf79c544239d9c2ec0ac156) ([merge request](gitlab-org/gitlab!61667))
- [Implement Sidekiq job payload compressor](gitlab-org/gitlab@32b110e80331890a694e36642f0f2cbb1befd62d) ([merge request](gitlab-org/gitlab!61667))

### Fixed (161 changes)

- [Only update required instance CI template when the parameter is present](gitlab-org/gitlab@c68b31bf53fa46c6582328ec624b1c4192435c68) ([merge request](gitlab-org/gitlab!63344))
- [Bugfix: avoid 500  when resending confirmation](gitlab-org/gitlab@c793f4db1a65003b3b8e8d5e93b896af94ef7e38) ([merge request](gitlab-org/gitlab!64234))
- [Deal with invalid caches](gitlab-org/gitlab@56203843d2a5f489bda9cf01537c4b8f55bfffac) ([merge request](gitlab-org/gitlab!63395))
- [Fix CI/CD > Pipelines active routes](gitlab-org/gitlab@86573c3fb3122535e8597ed85169a1d96d44fb44) ([merge request](gitlab-org/gitlab!64119))
- [Fix unreachable ES url exception](gitlab-org/gitlab@a778d4f76de5e554e8c6a84aed0eb57ff31aec13) ([merge request](gitlab-org/gitlab!63764)) **GitLab Enterprise Edition**
- [Fix problems with ldap users with expired password](gitlab-org/gitlab@e521e9736b3d2d444d239636f5af780d4df98bcc) ([merge request](gitlab-org/gitlab!63466))
- [Fix DA dropdown alignment](gitlab-org/gitlab@0abf60e391fc90fb4ce0bdc92338db2e0e2d2903) ([merge request](gitlab-org/gitlab!64174)) **GitLab Enterprise Edition**
- [Normalize buttons whitespace to only rely on margins](gitlab-org/gitlab@520f936fba16f15ed53824b6fd6a773d6444feee) ([merge request](gitlab-org/gitlab!64078))
- [JS error on continuous onboarding welcome page](gitlab-org/gitlab@4480ea1f2981cbf8db4b74c05e23a5c43592f752) ([merge request](gitlab-org/gitlab!63830)) **GitLab Enterprise Edition**
- [Only show coverage fuzzing artifact download when the job exists](gitlab-org/gitlab@7d462536bb0c43733a705ea35ecb65818d0a6326) ([merge request](gitlab-org/gitlab!63957))
- [Align file line numbers for some Safari users](gitlab-org/gitlab@1801b1f7fc8bd90a4c17e92bf184dfd2fe1ce2bd) ([merge request](gitlab-org/gitlab!63132))
- [Use context-aware translation for cloud license](gitlab-org/gitlab@a99df9bfb96e9d553763113a13209fd8d6376ce8) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/64162)) **GitLab Enterprise Edition**
- [Fix Embedded Snippet CSS to remove unnecessary vertical scroll bar](gitlab-org/gitlab@7e268f512aff5e8f44d344cdb4d44e2b95da7c4f) ([merge request](gitlab-org/gitlab!62945))
- [Rebuild iterations automation index](gitlab-org/gitlab@42c4987315f357284cfab40240ef5c7d86d7b489) ([merge request](gitlab-org/gitlab!63858))
- [Fix migration for SSH key expiration enforcement](gitlab-org/gitlab@5df1166f3e824c08c3a7d5d051e68215af95e1b6) ([merge request](gitlab-org/gitlab!64124))
- [Fix spacing between deploy buttons in MR widget](gitlab-org/gitlab@4bbd3fcf2da42dae3647300e5441cd96665d2d0b) ([merge request](gitlab-org/gitlab!64078))
- [Fix blank state styling for welcome screens](gitlab-org/gitlab@dfca5d63c5593cb522b170c3d5941427856e8213) ([merge request](gitlab-org/gitlab!64082))
- [Fix sidebar item on Jira issue details page](gitlab-org/gitlab@1d2bcbcd411102377d4de7b8fef98653925ffe34) ([merge request](gitlab-org/gitlab!63954)) **GitLab Enterprise Edition**
- [checks: Fix LFS pointer checks only verifying first reference](gitlab-org/gitlab@b37691bcaecbd090280dcded103a3c323498d5cc) ([merge request](gitlab-org/gitlab!61355))
- [Fix NameError Admin::ApplicationSettings::UpdateService](gitlab-org/gitlab@5b4e81e10e84b4d92d37f1b2151fe38b8465da0a) ([merge request](gitlab-org/gitlab!64055))
- [Fix CI editor template not updating on commit](gitlab-org/gitlab@56e33f473e99ff98dfd0d8921fd47c970d4c5231) ([merge request](gitlab-org/gitlab!64029))
- [Add select_rows to the list of NON_STICKY_READS](gitlab-org/gitlab@d095deff7524ed2e11dd05c6feaa7afaf49b5dc5) ([merge request](gitlab-org/gitlab!63893))
- [Allow nil on delegated CI/CD settings](gitlab-org/gitlab@9b71913e96f703b022f0927644c382e84012ca8c) ([merge request](gitlab-org/gitlab!63809))
- [Fetch from all parent groups in issue epic select](gitlab-org/gitlab@8a8d2017011e5bbef4d7e6a561dde63220477f5d) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/63618)) **GitLab Enterprise Edition**
- [Prevent CI schema from registering if schema_linting flag is off](gitlab-org/gitlab@2d3db8025650746cd5f27ad942d49e7fb63e704d) ([merge request](gitlab-org/gitlab!63552))
- [Conditionally render create group buttons](gitlab-org/gitlab@ef09a654c4c23cb716de5348f1b93270c4c317a1) ([merge request](gitlab-org/gitlab!63871))
- [Do not trim wiki content by default](gitlab-org/gitlab@e8e492d034770037abb04581e95c0e3942f234b4) ([merge request](gitlab-org/gitlab!63930))
- [Show the bytes when git reports the file as undiffable](gitlab-org/gitlab@de19a30b8e339c8603b817ffdfb6a5f60a333173) ([merge request](gitlab-org/gitlab!62445))
- [Use unstranslated names for telemetry on membership](gitlab-org/gitlab@64a5c41156b1a153fd77984132c1b82d387fdb38) ([merge request](gitlab-org/gitlab!63906))
- [Hide search icon on larger breakpoints again](gitlab-org/gitlab@399519194933202c21f2d6a25456b5cee49bbca8) ([merge request](gitlab-org/gitlab!63861))
- [Use user config for first day of week in issue datepicker](gitlab-org/gitlab@285a4d6bfe29dfaebb8fbd6bd8cafc60ad6f2c1f) ([merge request](gitlab-org/gitlab!63821))
- [Fix accessing the errors property of the scan objects](gitlab-org/gitlab@38a4febd36bd3b89cdc5c65b6e40f69d4b2c55e1) ([merge request](gitlab-org/gitlab!63808)) **GitLab Enterprise Edition**
- [Gracefully handle unknown failure reason in runner CI job](gitlab-org/gitlab@4e52147696c760610939df5260e15aa4427c43f5) ([merge request](gitlab-org/gitlab!63828))
- [Check Security::Scan resources to identify ran security jobs](gitlab-org/gitlab@0b4b2ca47398429f08740dfbae173e1521275f98) ([merge request](gitlab-org/gitlab!63807)) **GitLab Enterprise Edition**
- [Fix bug where disabling usage ping via gitlab.rb did not work](gitlab-org/gitlab@c4c513b8a6f0e1b23485e7a05b9311de6f6742fe) ([merge request](gitlab-org/gitlab!63784))
- [Add default_branch support for Project API](gitlab-org/gitlab@24e3c5bfd58d56882e885daf09b075020024f8fd) ([merge request](gitlab-org/gitlab!63771))
- [Avoid idling in transaction while saving project export object](gitlab-org/gitlab@fa4e7efb5ed98a0648a0477649f37dd76bfdd561) ([merge request](gitlab-org/gitlab!63350))
- [Fix timeouts on expiring SSH keys](gitlab-org/gitlab@08e99e90260915fbccb58e45d1fa92aa1d02afb9) ([merge request](gitlab-org/gitlab!63623))
- [Only check for modified paths when the branch is updated](gitlab-org/gitlab@c3329e788a824152078857aa7558c167ec13edb5) ([merge request](gitlab.com/gitlab-org/gitlab/-/merge_requests/63523)) **GitLab Enterprise Edition**
- [Change meta tag theme color to match theme](gitlab-org/gitlab@493e5b79e0856892733e281d9118d09dcf9eadd5) ([merge request](gitlab-org/gitlab!63648))
- [fix: VulnerabilityFinding equality should exclude other record types](gitlab-org/gitlab@356e004a1cd12d9047fb1a43965e4e535e75b101) ([merge request](gitlab-org/gitlab!63554)) **GitLab Enterprise Edition**
- [Fix trendline error](gitlab-org/gitlab@8b5eadfa9f9450a98698ed0c7915ddf7025061ee) ([merge request](gitlab-org/gitlab!63312)) **GitLab Enterprise Edition**
- [Fix unintentional cleanup of Import/Export tmp files](gitlab-org/gitlab@45f991a1c0cb21148a0f5a9766e60412d3c8fa38) ([merge request](gitlab-org/gitlab!63065))
- [Use issueable reference prefix in basic search results](gitlab-org/gitlab@fba94120e74a6fd6e5cdb4d0750910abc1b94c1d) ([merge request](gitlab-org/gitlab!63164))
- [Calculate mergeability check sync on first widget load](gitlab-org/gitlab@46ffa7b826ddf560f7a827ea4c40ed8454c2c490) ([merge request](gitlab-org/gitlab!63506))
- [Fix fetch policy in pipeline editor branch switcher](gitlab-org/gitlab@e7ee68235b411e58cc496dff7993338ea63d7e56) ([merge request](gitlab-org/gitlab!62275))
- [Fix upload-file-experiment-trigger setting incorrect base route](gitlab-org/gitlab@f528dd41f688b0dd723a74d993532ddd7524fe60) ([merge request](gitlab-org/gitlab!63487))
- [Add guard - diff missing from merge_request_diffs](gitlab-org/gitlab@a3cac1386911794fd0e63a1b3afc253d5af9fb9e) ([merge request](gitlab-org/gitlab!63338))
- [Resolve Yajl encoding incompatibility](gitlab-org/gitlab@bc56a61fc4f0cdf5d700a47e6170b5304584d912) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/63379))
- [Fix MR approval by reporters](gitlab-org/gitlab@ce0f10f69fa660c731a244451f60e87b48142e41) ([merge request](gitlab-org/gitlab!63153)) **GitLab Enterprise Edition**
- [Fix conflict resolve to handle FailedPrecondition error correctly](gitlab-org/gitlab@4214e8b561d79bcdb4788ff552fb486c1b06a132) ([merge request](gitlab-org/gitlab!61988))
- [Repurpose Key.expired_today_and_not_notified scope](gitlab-org/gitlab@02f2bf821791331fb8c47bbb7fc43c6a0fa9fb9d) ([merge request](gitlab-org/gitlab!62114))
- [Fix escaping characters in authors name for "Pending Comments" dropdown](gitlab-org/gitlab@2b4768797cb4a66fe2df33d60a5176d7d9330d7a) ([merge request](gitlab-org/gitlab!63349))
- [Fix links in code quality widget](gitlab-org/gitlab@102652819993e263567386b398d70edfaa73d40e) ([merge request](gitlab-org/gitlab!63346))
- [Fix spam detection with Akismet client](gitlab-org/gitlab@ba1815659837e00d04b4dcd0a6a4426a41e81138) ([merge request](gitlab-org/gitlab!63117))
- [Do not display bulk selection when user is auditor](gitlab-org/gitlab@bd27eb022dfd047fe0e4a5514242324dd611081e) ([merge request](gitlab-org/gitlab!62685)) **GitLab Enterprise Edition**
- [Add guard condition for when cilium](gitlab-org/gitlab@2e7fd9662f0e7396a770a40eceb5777af86be0c7) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/63258)) **GitLab Enterprise Edition**
- [Enable HTML labels in Mermaid](gitlab-org/gitlab@80570c0a1a790ccc668c84aa076c8e520e4f43eb) ([merge request](gitlab-org/gitlab!63101))
- [Upgrade gitaly dependency to use proper go modules versioning](gitlab-org/gitlab@c75ac6642b3151b5730ba6d5641a866b3f76c346) ([merge request](gitlab-org/gitlab!63284))
- [Fix MR diff compare with previous version](gitlab-org/gitlab@116280a6448ae08d41e63e057a2f92e3bbaba2df) ([merge request](gitlab-org/gitlab!62535))
- [Use tag helper to generate custom emojis](gitlab-org/gitlab@4346a386773e2096165821a5885695935c621cf9) ([merge request](gitlab-org/gitlab!63275))
- [Allow GraphQL MemberInterface to support null users](gitlab-org/gitlab@86b0a8c9c75c29c4dccd20839df22eadb186c511) ([merge request](gitlab-org/gitlab!63262))
- [Fix blank error message for codequality diff](gitlab-org/gitlab@f6721845e2529a76985cdd9481c4afa1f20b0238) ([merge request](gitlab-org/gitlab!63230)) **GitLab Enterprise Edition**
- [Fix known issues with the CSP](gitlab-org/gitlab@f3e12343371fd29cae5e996416b1bdce57e648a2) ([merge request](gitlab-org/gitlab!63206))
- [Whitelist pages in mermaid rendering](gitlab-org/gitlab@e1a4b221e3d4d7d822e3ddb007865779ae1a6b1c) ([merge request](gitlab-org/gitlab!62451))
- [Fix pipeline graph visualization lines disappearing](gitlab-org/gitlab@4242057e0456e2b9b88165dc97e815fe3edc7dcc) ([merge request](gitlab-org/gitlab!63083))
- [Set CSP back to disabled by default](gitlab-org/gitlab@226b5c8dc96e1c9d91a2dd083e0b5d3ddc3eb184) ([merge request](gitlab-org/gitlab!62961))
- [Fix Advanced Search retry migration button](gitlab-org/gitlab@aace51ef8ca37552919261ca5d4832a75f62e41a) ([merge request](gitlab-org/gitlab!63012)) **GitLab Enterprise Edition**
- [Permit symbols when loading mail_room.yml](gitlab-org/gitlab@b2fb691e17e180e765e253f7fbedb122bf79c183) ([merge request](gitlab-org/gitlab!62780))
- [Use `#use_open_file` for NuGet metadata extraction](gitlab-org/gitlab@6c112a100a9129d8ec88d4604b94042de924f746) ([merge request](gitlab-org/gitlab!62471))
- [Fix iteration wildcard id filtering for boards](gitlab-org/gitlab@c094a3215315355ecfe18a6ab9fdafe63d87073a) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/62801)) **GitLab Enterprise Edition**
- [Fix reference to `isSquashReadOnly`](gitlab-org/gitlab@e0ed769c5be91cfe0b2397bf24a8585ba1459edc) ([merge request](gitlab-org/gitlab!62851))
- [Prevent error when accessing optional needs in pipeline graph](gitlab-org/gitlab@f0b4301d636383b64f8850fbd996801fcab2b645) ([merge request](gitlab-org/gitlab!62948))
- [Prevent prepending single quote to issue CSV exports](gitlab-org/gitlab@b4d1a6ed5145e38a7edb510155e396b7802e5f36) ([merge request](gitlab-org/gitlab!62730))
- [Record impersonation details on Auditor](gitlab-org/gitlab@20b7c5d6c53acfc41d087a5367ddd5b882a47dab) ([merge request](gitlab-org/gitlab!62257)) **GitLab Enterprise Edition**
- [Set default retries for mailers to 3](gitlab-org/gitlab@d1b9c81059109afca661427a874b12c64f1f5bba) ([merge request](gitlab-org/gitlab!62814))
- [Fix non-custom Total stage in VSA](gitlab-org/gitlab@df2c5bb9cc2cf625722b71a4f706ccf9839c47d7) ([merge request](gitlab-org/gitlab!62889)) **GitLab Enterprise Edition**
- [Do not enforce UTF-8 in any forms](gitlab-org/gitlab@c697eb6e8f77df493e6da85cb0d004400fbe470c) ([merge request](gitlab-org/gitlab!62820))
- [Fix indexer running longer than lock timeout](gitlab-org/gitlab@be5ddaf6b670593968f1d00877d5f63129508d53) ([merge request](gitlab-org/gitlab!62366)) **GitLab Enterprise Edition**
- [Fix junit report attachment in tests with error](gitlab-org/gitlab@15b5b59254c7e4ace8a92827e529ccdf69d6d451) ([merge request](gitlab-org/gitlab!62874))
- [Force use of UTC in formatting seconds into MM:SS](gitlab-org/gitlab@347ae9254788d47d0ec0a536c22021af5318e23b) ([merge request](gitlab-org/gitlab!62873))
- [Fix known issues with the CSP](gitlab-org/gitlab@c827770c8a2f7bda98d88211a8d07aef9e42c87a) ([merge request](gitlab-org/gitlab!62615))
- [Fix CSP issues related to captchas](gitlab-org/gitlab@c7f10973eab348ab62c5fe6907a328cc83cd862c) ([merge request](gitlab-org/gitlab!62849))
- [Fix "Security & Compliance" access for auditors](gitlab-org/gitlab@9541fe044ca52c7daebd7608e2ef75c6201e6b98) ([merge request](gitlab-org/gitlab!62837)) **GitLab Enterprise Edition**
- [Add the deduplication hash to the job payload](gitlab-org/gitlab@88ace86eb8442fbf849fb2ccb23cb0cc4d82fc91) ([merge request](gitlab-org/gitlab!62842))
- [Authorize GraphQL Vulnerabilities::IssueLink type](gitlab-org/gitlab@90692666eb913398888c434514a59cb2d3716d66) ([merge request](gitlab-org/gitlab!62815)) **GitLab Enterprise Edition**
- [Fix the `requiring_cleanup` scope](gitlab-org/gitlab@1d40aa404a84d6d04d6b401cfba239f6f4163a46) ([merge request](gitlab-org/gitlab!62827))
- [Do not remove export when uploading via URL](gitlab-org/gitlab@c2e09e8fae35f18d8ad53a34cd932a4b387c1e71) ([merge request](gitlab-org/gitlab!62763))
- [Set iteration state based on updated dates](gitlab-org/gitlab@97809627d8fe274c4fe3a84c2ecfedd165dcbeef) ([merge request](gitlab-org/gitlab!62558))
- [Update google-protobuf to v3.17.1](gitlab-org/gitlab@bc8f2e0d6d4ffd8ca0195295e5c0b2d208f287e0) ([merge request](gitlab-org/gitlab!62792))
- [Fix CSS for MR widget for dark mode](gitlab-org/gitlab@978ea85dd470ec12787f4435ed77586ab8742483) ([merge request](gitlab-org/gitlab!62783))
- [Fix shared runner minutes reset on self-managed](gitlab-org/gitlab@bba3204bf91bff6d8b13aefb91b13af6347d5270) ([merge request](gitlab-org/gitlab!62781)) **GitLab Enterprise Edition**
- [Fix layout, spacing, and style of reaction emoji on issuables](gitlab-org/gitlab@60b799d6b3e36ddd59f0383c9a579be64bccb394) ([merge request](gitlab-org/gitlab!62621))
- [fix: Update StoreReportService to better unique signature violations](gitlab-org/gitlab@2779305502de592a784a477a0d1768ffb4e3db2b) ([merge request](gitlab-org/gitlab!61269)) **GitLab Enterprise Edition**
- [Update startup css which fixes login pages](gitlab-org/gitlab@b609d6eb12395694cd51fed21944b5d4370d33f5) ([merge request](gitlab-org/gitlab!62486))
- [Make arrow on generic report section clickable](gitlab-org/gitlab@c5971a111941e2ce0b9a2d50923b427999627c7d) ([merge request](gitlab-org/gitlab!62429)) **GitLab Enterprise Edition**
- [Determine Jira deployment_type based on URL](gitlab-org/gitlab@28a4e491b5a7b058a51c8b5813ea5a511c7a3f8c) ([merge request](gitlab-org/gitlab!62040))
- [Fix ability for non project member to subscribe to an issue](gitlab-org/gitlab@b444b07ff8b666a6b53f2111166cfbeaa8c9c7df) ([merge request](gitlab-org/gitlab!61953))
- [Fix Releases page/GraphQL pagination](gitlab-org/gitlab@52341a0b230e5d09c2daa40448c1125419695950) ([merge request](gitlab-org/gitlab!62256))
- [Overhaul CSS in performance bar in Dark mode](gitlab-org/gitlab@47bee03e03651809cd7198b574265467746d962c) ([merge request](gitlab-org/gitlab!61552))
- [Fix `Security::FindingsFinder` for multiple report artifacts](gitlab-org/gitlab@d6e099293532827e3b2fa1da127fc87ab8aea112) ([merge request](gitlab-org/gitlab!62643)) **GitLab Enterprise Edition**
- [Stop using basic auth for GKE cluster creation](gitlab-org/gitlab@c1f0d4ada8ae360d58612c3282682e57d4d69360) ([merge request](gitlab-org/gitlab!62518))
- [Allow error-free deletion of orphaned group members](gitlab-org/gitlab@b5775a56be21c5c2597c70ad367473efa413cef0) ([merge request](gitlab-org/gitlab!62603))
- [Fix "Leave this group" button for subgroups listed in group overview](gitlab-org/gitlab@07765ef3740422208fb40a4630b0326e8d28a1e9) ([merge request](gitlab-org/gitlab!62488))
- [Adds a conditional to not uncheck an unchecked MR](gitlab-org/gitlab@4e5989253ccedc0e655afee37406d6efcfbfae4b) ([merge request](gitlab-org/gitlab!61759))
- [Fix alignment of global alerts](gitlab-org/gitlab@d5c248137c71af978b6c55dc6c4c60bc216bd1d9) ([merge request](gitlab-org/gitlab!62498))
- [Fix vuln scanner filter not working when report type has no scanner IDs](gitlab-org/gitlab@5fd9f9c9a150c31d8e77b7dc7a7e76cd7958e7ab) ([merge request](gitlab-org/gitlab!62565))
- [Call RedisHllUserEvent only when a user is set](gitlab-org/gitlab@95b4471661be21eca12160fd29702c92d8f95725) ([merge request](gitlab-org/gitlab!62560))
- [Fix Gitpod url in user preferences](gitlab-org/gitlab@85a3357a2518db44fba9b3541c41e947b3a89e61) ([merge request](gitlab-org/gitlab!62544))
- [Fix Jira issue fields not disabled when inheriting](gitlab-org/gitlab@0570f7362da2fb3629313a4c69adaa8ff3b4f6d4) ([merge request](gitlab-org/gitlab!62364))
- [Handle invalid project ID in reply-by-email](gitlab-org/gitlab@da6bd2eb0e47696bbbdbfac960801dbfb17b78ec) ([merge request](gitlab-org/gitlab!62530))
- [Fix tooltip positioning on job view list](gitlab-org/gitlab@57b32f6b93eea94c397a793627575b87335a9013) ([merge request](gitlab-org/gitlab!62504))
- [Fix typo showing error message after destroy page](gitlab-org/gitlab@115ab6ee52ce5924a187d735e85c96c8e1a9ec5d) ([merge request](gitlab-org/gitlab!62478))
- [Process emails for projects with not unique service desk keys](gitlab-org/gitlab@cf9290cab12080d87b699cd52aa880fa91d84fb9) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/62139))
- [Fix JavaScript initialization in readonly mode](gitlab-org/gitlab@cf425a12d9177b76a86a3928ad641e476c15f10e) ([merge request](gitlab-org/gitlab!62427))
- [Update Gitaly's binary path in init.d scripts](gitlab-org/gitlab@e2dbfb22e6f5a0d28006d4f1684200049a2b1cb0) ([merge request](gitlab-org/gitlab!62456))
- [Pin the GKE version to 1.18 for cluster creation](gitlab-org/gitlab@a5c82ceb7e13d3de00440ff252bcc8b142e857a7) ([merge request](gitlab-org/gitlab!62341))
- [Fix N+1 problem for ForksController#new](gitlab-org/gitlab@614a0c47aca587482810d54637eef5c9938b39ab) ([merge request](gitlab-org/gitlab!62323))
- [Fix missing system notes and system events on create issue](gitlab-org/gitlab@25b6738ccefc0717c04d6eba8548f6bbfbf80745) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/61746))
- [Avoid conflicting workers in `authorized_projects` namespace](gitlab-org/gitlab@2e11d9f55e3c730097cb19c07fee9181205fb9ff) ([merge request](gitlab-org/gitlab!62442))
- [Fix humanized size numbers for negative values](gitlab-org/gitlab@69f1f173d5634cfb24021b4f595a9759eb7545e5) ([merge request](gitlab-org/gitlab!62441))
- [Fix double render in project's git URL redirect](gitlab-org/gitlab@45512b2c5f3aec8034e961b09f10443911076d13) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/62053))
- [Fix issue with frames not loading in Safari](gitlab-org/gitlab@5341e159d714e973489c83daa383e9369c5f1423) ([merge request](gitlab-org/gitlab!62421))
- [Fix timeouts when destroying a project with many notes](gitlab-org/gitlab@3e5a944e4a2614fc4b829e6dd14f79ea8c2c4823) ([merge request](gitlab-org/gitlab!62389))
- [Check user permissions for pipeline operations](gitlab-org/gitlab@2424584193443b4666e7d41ba5e1d602d065c1b7) ([merge request](gitlab-org/gitlab!62137))
- [Include environments from current and descendant pipelines](gitlab-org/gitlab@6edd3da0b2c76a09bd986991b2d400007729a785) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/62080))
- [Render Discover link for `Security & Compliance`](gitlab-org/gitlab@74fb4d54fbf36223871cda48c9667b9ddb465f4d) ([merge request](gitlab-org/gitlab!62019)) **GitLab Enterprise Edition**
- [Avoid updating Elasticsearch when project is pending_delete](gitlab-org/gitlab@a574bbe0d8c95d9b656045536403796ffa9b25ed) ([merge request](gitlab-org/gitlab!61917))
- [Remove feature flag around policy alert creation](gitlab-org/gitlab@ec1712284b282e2fc82c22c60796ce6b2290f0c1) ([merge request](gitlab-org/gitlab!62319)) **GitLab Enterprise Edition**
- [Fix bulk edit vulnerability dropdown layering issue](gitlab-org/gitlab@b361a36073ecea89fdb89480afe86f7a3f4e769d) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/62317)) **GitLab Enterprise Edition**
- [Bump Cluster Applications version which includes:](gitlab-org/gitlab@5d05e470b6b4d81ba65f29a11122a17a11fcafea) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/62117))
- [Only check index status if modifying Advanced Search form](gitlab-org/gitlab@0b14d4f8e9ef58a99f61262c693c77324dd85957) ([merge request](gitlab-org/gitlab!62299))
- [Preserve epic labels association during Group Import/Export](gitlab-org/gitlab@2ffe53ed1779e7b96f89f9368e803593dcc00053) ([merge request](gitlab-org/gitlab!62299))
- [Hide billing plans with truthy hide_card attribute](gitlab-org/gitlab@2bd16f0afe9bf1b1e383ff69349b20ddfad8f69b) ([merge request](gitlab-org/gitlab!62299))
- [Check for credit card when playing manual jobs](gitlab-org/gitlab@6349060e62348f90211b988c53afc6fef4f1e76b) ([merge request](gitlab-org/gitlab!62299))
- [Ensure post-update actions are applied when assignees change](gitlab-org/gitlab@7b0078180b70b762aaa72c812fea5339d90ed755) ([merge request](gitlab-org/gitlab!62012))
- [Fix errors in instance and group-level integration pages for some integrations](gitlab-org/gitlab@4225a25961f403f267fbad55bb0e5d9a9d0ed5d6) ([merge request](gitlab-org/gitlab!62012))
- [Return 404 from branches API when repository does not exist](gitlab-org/gitlab@9f9fce8261e9da6832915fb44667e7048909765a) ([merge request](gitlab-org/gitlab!62012))
- [Fixed Rails Save Bang offenses in few spec/models/* files](gitlab-org/gitlab@baef3bca17f8c00301ec95c8626ce5dfa7d8aada) ([merge request](gitlab-org/gitlab!62012))
- [Fix blob preview error](gitlab-org/gitlab@7a5bbd2e4397e66429bcce4f4fa81be54c176e97) ([merge request](gitlab-org/gitlab!62012))
- [Fix atom feed with push events for multiple tags](gitlab-org/gitlab@c4769d7ea59c0f3687237d71a4ebc493a56bd668) ([merge request](gitlab-org/gitlab!62012))
- [Resolve Time tracking report is bugged on GraphQL boards](gitlab-org/gitlab@d7ae653b464937a957bac21621f48447b9204edc) ([merge request](gitlab-org/gitlab!62012))
- [Fixed Rails Save Bang offenses in few spec/models/* files](gitlab-org/gitlab@50b037b744fe6cd3271ffd38b985b318e62a3703) ([merge request](gitlab-org/gitlab!62012))
- [Properly process stale ongoing container repository cleanups](gitlab-org/gitlab@948413b6b3961a850bcdce2f9f1776741bbc0ea6) ([merge request](gitlab-org/gitlab!62012))
- [Execute member hooks only if an associated user is present](gitlab-org/gitlab@473656bab27d7227d48d85011d6bf25e9752a855) ([merge request](gitlab-org/gitlab!62012))
- [Fix `pry` debugging location with `pry-byebug` and `pry-shell` by updating the `pry-shell` gem](gitlab-org/gitlab@57dfda62eb0d94a35975bda5af9de1034c53a086) ([merge request](gitlab-org/gitlab!62012))
- [Fix permission check when setting issue/merge request subscription in GraphQL API.](gitlab-org/gitlab@77dea32e5921154fd6613021a73c751f626baaef) ([merge request](gitlab-org/gitlab!62012))
- [Fix pipeline graph undefined needs error](gitlab-org/gitlab@68ce1ff09a3f56a71d791f736db7ee26d492dcd1) ([merge request](gitlab-org/gitlab!62012))
- [Prevent overflows in WebHook#backoff_count](gitlab-org/gitlab@db0366a681a5cd35b13a2fa56370287c3543d7b4) ([merge request](gitlab-org/gitlab!62012))
- [Prevent overflows in WebHook#backoff_count](gitlab-org/gitlab@2ba4cab79d2c482aba89d31729466c75e64f7034) ([merge request](gitlab-org/gitlab!62202))
- [Ensure that we always run the update worker](gitlab-org/gitlab@185fea33cd8d1e39e96a104dccb20db818c97d90) ([merge request](gitlab-org/gitlab!61897))
- [Execute member hooks only if an associated user is present](gitlab-org/gitlab@37cbe23aa7076d74c12eb4210fc802a62d8ef294) ([merge request](gitlab-org/gitlab!62175))
- [Check for credit card when playing manual jobs](gitlab-org/gitlab@f65f4827115f90734c6f49fb578ee3952e884a4c) ([merge request](gitlab-org/gitlab!62124))
- [Added changelogfile](gitlab-org/gitlab@4caa2dfca72d5dfeeb9f8859718d0d8ae999124c) ([merge request](gitlab-org/gitlab!62165))
- [Fixed offenses in spec/models/* part 5](gitlab-org/gitlab@b4acc814eac0a235c38f86ced8a2d141eda9b718) ([merge request](gitlab-org/gitlab!62165))
- [Fix blob preview error](gitlab-org/gitlab@2b72facccc9a36ebe346797b643811fd722b4380) ([merge request](gitlab-org/gitlab!62128))
- [Return 404 from branches API when repository does not exist](gitlab-org/gitlab@5dba6b526e91d5b9e1ae611b38613ad7217a2e6f) ([merge request](gitlab-org/gitlab!62089))
- [Preserve epic labels association during Group Import/Export](gitlab-org/gitlab@f105ac61bc42098a9c02b40e82c613a7c9ece570) ([merge request](gitlab-org/gitlab!62074))
- [Fix atom feed with push events for multiple tags](gitlab-org/gitlab@cbf91d4bd789bafa23227ca19b5e1c893cd42532) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/62059))
- [Fixed offenses in spec/models/* part 2](gitlab-org/gitlab@17afb671c4e7b0cf95c762e2fb04fe20302db682) ([merge request](gitlab-org/gitlab!61961))
- [Fix UI bug overflowing the text in TODO list](gitlab-org/gitlab@0eb1b9d3ea9deb9ac09582ecacd23cadc5d7c9f5) ([merge request](gitlab-org/gitlab!61910))

### Changed (155 changes)

- [Move admin cohorts to separate controller](gitlab-org/gitlab@e6fb06fb73ab8a639bac04077c07f5b54670e2eb) ([merge request](gitlab-org/gitlab!64015))
- [Improve beta state communication of content editor](gitlab-org/gitlab@e36a419e2d4fad464bacb2ebcb15fe1c1dd6a02e) ([merge request](gitlab-org/gitlab!63775))
- [DA use dropdown for adding groups](gitlab-org/gitlab@8bd72f34f1c2f3568ed9f338041bd9b9f479026d) ([merge request](gitlab-org/gitlab!63746)) **GitLab Enterprise Edition**
- [Remove ci_register_job_service_one_by_one feature flag](gitlab-org/gitlab@564e6f2260286e5364303464fd23973eb04ccf07) ([merge request](gitlab-org/gitlab!64121))
- [Use database as SSOT for diffs whitespace](gitlab-org/gitlab@24135de77137981c82bcd7268c3875bf7f80a874) ([merge request](gitlab-org/gitlab!63927))
- [Namespace translations in view switcher for clarity](gitlab-org/gitlab@e7d63b3c8512fa486c8d785d7b4f1f5906ac8cc5) ([merge request](gitlab-org/gitlab!64102))
- [Show update branch message when MR branch diverged from target branch](gitlab-org/gitlab@7e3da6b74001c4f3661799c3eac06418e9221bbb) ([merge request](gitlab-org/gitlab!64090)) **GitLab Enterprise Edition**
- [Backend support for multi-select project search](gitlab-org/gitlab@40b38dd3675eddb06a3c43aca4e9c9dbbb180a5a) ([merge request](gitlab-org/gitlab!62606)) **GitLab Enterprise Edition**
- [Use GraphQL for Time tracking info on Issuables](gitlab-org/gitlab@ea7b1fa1ffe5c4d8cde14c146917ec62707a2736) ([merge request](gitlab-org/gitlab!63773))
- [Bump DAST to use version 2](gitlab-org/gitlab@322e7b3c13205f887449f8daac9fc4baf632f772) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/62597)) **GitLab Enterprise Edition**
- [Fix Helm version regexp to match unprefixed semver too](gitlab-org/gitlab@9ec76dc9a43ffb2032f9a276a314d270b96d5932) ([merge request](gitlab-org/gitlab!63967))
- [Add deprecation notice to Managed-Cluster-Applications.gitlab-ci.yml](gitlab-org/gitlab@1983d1f28dee21f029776bb41ee53aeaaee021e9) ([merge request](gitlab-org/gitlab!64050))
- [Hide tooltips and popovers with escape key](gitlab-org/gitlab@6dcc5b7b98b37aded59a4f217e39729002065fa0) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/63922))
- [Adds more identifiers to Seat Link](gitlab-org/gitlab@9dc094515375295ea01f49cf67f3c41847ec07d3) ([merge request](gitlab-org/gitlab!63909)) **GitLab Enterprise Edition**
- [Usage dictionary: update name, Group Overview](gitlab-org/gitlab@67c7f965a7a4293cb5b6329da915692b0c8a51c6) ([merge request](gitlab-org/gitlab!63780)) **GitLab Enterprise Edition**
- [Set PostgreSQL 12 as the minimum supported version](gitlab-org/gitlab@50fe067049b75b26b8223470803092a10a23cab1) ([merge request](gitlab-org/gitlab!63471))
- [Fix: update incident sidebar severity title margin](gitlab-org/gitlab@e0d2cfc76405f3083d227b5c42dbdadc03fc42ee) ([merge request](gitlab-org/gitlab!63998))
- [Add webhook rate-limit threshold for Free plan on gitlab.com](gitlab-org/gitlab@772754bc41547860405e55868758f0566c878c22) ([merge request](gitlab-org/gitlab!62918))
- [Update instructions how to initialize/clone git repository](gitlab-org/gitlab@c73781b1c180543c5083bb40796420f2cc613b7c) ([merge request](gitlab-org/gitlab!63985))
- [Add indices for created_at+id and contacted_at+id on ci_runners](gitlab-org/gitlab@53d0a6326a42e3dce9d040497440604b1f201d41) ([merge request](gitlab-org/gitlab!62310))
- [Update Diff UI settings to match style guides](gitlab-org/gitlab@0c95661892bb830056d7d3dee2996e9a192db3e1) ([merge request](gitlab-org/gitlab!62500))
- [Relate Test Reports and Requirement Issues](gitlab-org/gitlab@5927399c2175fdbba680b01690c1ff8c3029305e) ([merge request](gitlab-org/gitlab!63512))
- [Add verification for MR diffs using SSF](gitlab-org/gitlab@9d390d48b98be62beb953ce45fa3b437101cdf6c) ([merge request](gitlab-org/gitlab!63309)) **GitLab Enterprise Edition**
- [Make Alert details table attributes clickable](gitlab-org/gitlab@976d9cf0f0a0dd70e2af14858aff43efd404d006) ([merge request](gitlab-org/gitlab!63593))
- [Add migrations for adding verification for MR diffs](gitlab-org/gitlab@9fadd0b863d796b876ed0f627323e663602a9acb) ([merge request](gitlab-org/gitlab!60935))
- [Allow guest user to assign issue metadata on create](gitlab-org/gitlab@ae50169e7f121dd76ccc516ab2920ed4b829848f) ([merge request](gitlab-org/gitlab!62816))
- [Replace plugin.log with file_hook.log](gitlab-org/gitlab@9602f4cfcd1eb94c98455a07bb0586b30ad87633) ([merge request](gitlab-org/gitlab!57515))
- [Restore previous month perspective](gitlab-org/gitlab@478e20ce28fb7b9df789ea42d1ecf7ab9898327c) ([merge request](gitlab-org/gitlab!63217)) **GitLab Enterprise Edition**
- [Update Styling of MR-Widget](gitlab-org/gitlab@38842cbde3cf4ed7fcdbb871cc14e88cf33c1924) ([merge request](gitlab-org/gitlab!63736))
- [Enforce SSH key expiration by default](gitlab-org/gitlab@f023457f2203d08c0bce352c6422191d760d6e16) ([merge request](gitlab-org/gitlab!62432))
- [Tidy up language on access tokens UI page](gitlab-org/gitlab@a192f5d2ca5be0081203a6967ef77f73504c77b8) ([merge request](gitlab-org/gitlab!62939))
- [Move "Appearances" menu item into "Settings" in Admin Area](gitlab-org/gitlab@c08debbc2cad25b401507eebf48e9e45f2aa9718) ([merge request](gitlab-org/gitlab!62522))
- [Geo: Remove feature flag geo_terraform_state_version_verification](gitlab-org/gitlab@eb1a208ddccc1c1b09bf50663a9d9374907a19a3) ([merge request](gitlab-org/gitlab!63661)) **GitLab Enterprise Edition**
- [Retry pipelines in the background](gitlab-org/gitlab@0852bacfd11317532b79acedd6fe2c6b3cfe23d0) ([merge request](gitlab-org/gitlab!63789))
- [Remove feature flag `introduce_marker_ranges`](gitlab-org/gitlab@ce8ec7312bea6c31e84dce00eb6b2b33b41b9c85) ([merge request](gitlab-org/gitlab!59251))
- [Add input rules for creating links](gitlab-org/gitlab@87b4bb69e8796470e5d63e5b10d1d4dfdfe8519a) ([merge request](gitlab-org/gitlab!63664))
- [Add new way of encrypting tokens](gitlab-org/gitlab@1914a1e3493f8b87cc1948d5b29f755af7a72c20) ([merge request](gitlab-org/gitlab!58902))
- [Remove maven metadata CTE FF](gitlab-org/gitlab@f6b9d3ed06497eea3d39eb3cf3838965e1e28eb7) ([merge request](gitlab-org/gitlab!63657))
- [Bump major version of auto-deploy-image in Auto Deploy template](gitlab-org/gitlab@1051cc3ac6e0837aecc091159c632e06619838ee) ([merge request](gitlab-org/gitlab!62876))
- [Fix title, value spacing of various sidebar blocks](gitlab-org/gitlab@8914310b7b4b1e2961a16b49cffc642f74300120) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/61650)) **GitLab Enterprise Edition**
- [Expose include_ancestor_groups arg for epics query](gitlab-org/gitlab@87062904489597a8ab18b8fc96ca4d7231a27557) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/63374)) **GitLab Enterprise Edition**
- [Change vulnerability filters All option text to be "All <filter name>"](gitlab-org/gitlab@fd6379ae0eb88bbc97767371cdd697a75f8e8e28) ([merge request](gitlab-org/gitlab!63709)) **GitLab Enterprise Edition**
- [Replace work_in_progress with draft](gitlab-org/gitlab@05c9b9ed141d9a0ab037a407da26f9a976d25e42) ([merge request](gitlab-org/gitlab!63473))
- [Successful sync should cause verification](gitlab-org/gitlab@f9e904874082ecb3471a1309b93055c9009eda1c) ([merge request](gitlab-org/gitlab!63104)) **GitLab Enterprise Edition**
- [Wait until DB is ready to list data on legacy storage](gitlab-org/gitlab@d2eea674fd70f5874dcc19729e2916fa5e24ddb6) ([merge request](gitlab-org/gitlab!63692))
- [Add level four heading to text style dropdown](gitlab-org/gitlab@76f4d550751c6be3feb3ed0b82840453e5d5f1e8) ([merge request](gitlab-org/gitlab!63639))
- [Reintroduce DA group max requests](gitlab-org/gitlab@c441ef23d2107ea860d74baccdc867e8dfa36a51) ([merge request](gitlab-org/gitlab!63628)) **GitLab Enterprise Edition**
- [Remove env var restriction for Database load balancing](gitlab-org/gitlab@5548633db5395f78afa55535e67f5f6f75c150db) ([merge request](gitlab-org/gitlab!63627))
- [Hide scanner filter vendor header when there's only the GitLab vendor](gitlab-org/gitlab@b6a51e4cf99543174e80359db44c049a1e301156) ([merge request](gitlab-org/gitlab!63596)) **GitLab Enterprise Edition**
- [Add vulnerability activity filters in GraphQL](gitlab-org/gitlab@830c9f6346309aa82e08368088fc8174b26a3108) ([merge request](gitlab-org/gitlab!63311)) **GitLab Enterprise Edition**
- [Update the vendored cluster management Project Template](gitlab-org/gitlab@7d650079171513057435268d7fbc71eb6f7af941) ([merge request](gitlab-org/gitlab!63577))
- [Projects API show the project's squash option](gitlab-org/gitlab@631ee2c376f6423642ab6cff204f359afa002eec) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/63543))
- [Add git push counter to geo node status](gitlab-org/gitlab@70568e0a583f54e5c440cc56d37feb015e48dfec) ([merge request](gitlab-org/gitlab!63427)) **GitLab Enterprise Edition**
- [Adjust Button Sizes on Secure MR Widget](gitlab-org/gitlab@9c5f6b9e80467e8f02274e60b91991574b2a665b) ([merge request](gitlab-org/gitlab!63407))
- [Apply Slack's UI guide to channel placeholders](gitlab-org/gitlab@581a71f5e532dd5d05a49038fa277cfe13910af0) ([merge request](gitlab-org/gitlab!63046))
- [Remove DA max requests for groups](gitlab-org/gitlab@5acc14099db7e2741050222f123682381bbcadf0) ([merge request](gitlab-org/gitlab!63491)) **GitLab Enterprise Edition**
- [Rollout arel_package_scopes feature](gitlab-org/gitlab@edcaa59c6e1c57c119f4a32fe47ad74e4eb3e720) ([merge request](gitlab-org/gitlab!62614))
- [Allow iteration cadence argument on iteration creation](gitlab-org/gitlab@aecc475aa5e6d7bf8f7729f1f01f31984eb51a10) ([merge request](gitlab-org/gitlab!63505))
- [Migrate board label select to Vue](gitlab-org/gitlab@233554a8710d8267d372be1a9a6fc6e228c9e320) ([merge request](gitlab-org/gitlab!62626))
- [Remove old Advanced Search migrations](gitlab-org/gitlab@42eb2e7f830aa4b82413cb484450dfb2fce2f8df) ([merge request](gitlab-org/gitlab!63001)) **GitLab Enterprise Edition**
- [Added a check for user: null](gitlab-org/gitlab@198f25dfee0021b45181b7717002264782d60e70) ([merge request](gitlab-org/gitlab!63167))
- [Enable :disable_service_templates FF by default](gitlab-org/gitlab@f6c9bfb440831a2086ef8c756c771658f86f53e5) ([merge request](gitlab-org/gitlab!61312))
- [Remove load_balancing_atomic_replica feature flag](gitlab-org/gitlab@5bdb634f8ae2c24633fad3a50c5eaaa8683574b1) ([merge request](gitlab-org/gitlab!63380))
- [Replaces Klar by Trivy from the specs](gitlab-org/gitlab@a1e6576cf6513bc6b8a4b767cb1a221d69f77311) ([merge request](gitlab-org/gitlab!62328))
- [Add vulnerability scanner ID filter in GraphQL](gitlab-org/gitlab@b5336ba15ce135239201bab8ab3544ed453a2aae) ([merge request](gitlab-org/gitlab!63335)) **GitLab Enterprise Edition**
- [Right align action buttons on jobs index page](gitlab-org/gitlab@c0ecc3c392b58dce17ecef2e43f73de50c57b2cb) ([merge request](gitlab-org/gitlab!62869))
- [Move component and spec to static site editor](gitlab-org/gitlab@ead8cb57e15b21cbcc90c50026fc08742b0b94a1) ([merge request](gitlab-org/gitlab!55934))
- [Geo Node 2.0 - Remove geo_nodes_beta FF](gitlab-org/gitlab@35e5f26ab079c12af3286413d8ee5fa1442d6550) ([merge request](gitlab-org/gitlab!62309)) **GitLab Enterprise Edition**
- [Remove geo_lfs_object_replication feature flag](gitlab-org/gitlab@3fbea8278a43cb91415cf76d634a1da74a0fdbef) ([merge request](gitlab-org/gitlab!62039)) **GitLab Enterprise Edition**
- [Increase max groups fetched for DA](gitlab-org/gitlab@d0ea76aec56d87bac687ff85aa95737e5ab3262b) ([merge request](gitlab-org/gitlab!63415)) **GitLab Enterprise Edition**
- [Update breadcrumbs for project imports](gitlab-org/gitlab@8685b3538adb1b4b92034eb95b399c71a661d9a3) ([merge request](gitlab-org/gitlab!63089))
- [Revise UI phrasing around force pushes](gitlab-org/gitlab@162830f52299e8beb3d902b36bf14cf3d2eed897) ([merge request](gitlab-org/gitlab!63310)) **GitLab Enterprise Edition**
- [Upgrade to Mermaid v8.10.2](gitlab-org/gitlab@d886a3fb6390b22cfcf05d91bfba244412a0a869) ([merge request](gitlab-org/gitlab!63354))
- [Enable validate_import_decompressed_archive_size feature flag by default](gitlab-org/gitlab@a180695a5b50e8141f91dd3545ab4d8f2a952bd3) ([merge request](gitlab-org/gitlab!63025))
- [Improve VSM date tooltip](gitlab-org/gitlab@59fa8146ed11ddda9ee2c3bc7eef618e246abd8f) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/62194)) **GitLab Enterprise Edition**
- [Pass through escaped variable values to Runner](gitlab-org/gitlab@e5cf22fbcbf6d86a792a3748f29b73f1a7e33f0a) ([merge request](gitlab-org/gitlab!56603))
- [Update deprecated GlIcon size in IDE branch search](gitlab-org/gitlab@c9d6a5a5c80171ebd654b3a19eaadf8ca579f989) ([merge request](gitlab-org/gitlab!62782))
- [Use application/octet-stream as Content-Type for files in CI artifacts](gitlab-org/gitlab@c487ba4597d1ae9b3a283480c374d612d85e3e5c) ([merge request](gitlab-org/gitlab!63273))
- [Rename Browser Performance template jobs](gitlab-org/gitlab@eb7f75682911d87dbd42901c6f88715bd40c74d6) ([merge request](gitlab-org/gitlab!62727))
- [Rearrange 'Security & Compliance' menu items](gitlab-org/gitlab@7d95cdb47bc13ac6ffedb55feed5163b6745487d) ([merge request](gitlab-org/gitlab!62448)) **GitLab Enterprise Edition**
- [Enable prevent_retry_of_retried_jobs feature flag on by default](gitlab-org/gitlab@4b552ded173c95b8795b48c4a34f33999c01bb41) ([merge request](gitlab-org/gitlab!63112))
- [Simplify npm.gitlab-ci.yml using new CI variables](gitlab-org/gitlab@a945fb61276a3ef06f7a76afcc0db2cc44fb8523) ([merge request](gitlab-org/gitlab!56141))
- [Enable cross pipeline artifacts download](gitlab-org/gitlab@16da2f245ab8c801a1ea00b534f278997d6764d6) ([merge request](gitlab-org/gitlab!63074))
- [Rename read_vulnerability to read_security_resource policy](gitlab-org/gitlab@ee4fe811415971df46610f5b64f39bbcda848b3d) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/58704)) **GitLab Enterprise Edition**
- [Remove feature flag usage_data_p_terraform_state_api_unique_users](gitlab-org/gitlab@ca975e5303bb9eaa5a48148773d734288cd4b804) ([merge request](gitlab-org/gitlab!62975))
- [Remove feature flag create_cloud_run_clusters](gitlab-org/gitlab@b878883f6a80fc670b8112f91b0c82da4db2b965) ([merge request](gitlab-org/gitlab!62977))
- [Remove ci-trace-read-consistency feature flag](gitlab-org/gitlab@2d3a33230fba32f4046f0709a8142741f98db110) ([merge request](gitlab-org/gitlab!62840))
- [Added path navigation to project VSA](gitlab-org/gitlab@937099d47529ea384404eeacdd8c6aeb653d2d16) ([merge request](gitlab-org/gitlab!62630)) **GitLab Enterprise Edition**
- [Enable ci_fix_commit_status_retried by default](gitlab-org/gitlab@406ad6b0bbc450a757e7ca549a6df63d35a3b0f2) ([merge request](gitlab-org/gitlab!62907))
- [Change docs link style in group CI settings](gitlab-org/gitlab@b2cdff999c7e3f591c013a35e18106194500b966) ([merge request](gitlab-org/gitlab!62065))
- [Upgrade Sentry gem to 4.4.0](gitlab-org/gitlab@fa3e6a81fbc036f67a17d6236ddbf8dcf631aed0) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/62387))
- [Refactor performance bar cookie check](gitlab-org/gitlab@91490dca3a323e322fff16661065f50c899160d4) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/62675))
- [Database Load Balancing feature available in GitLab Free](gitlab-org/gitlab@064e9d3c5fbb65ee7cbca4eb54c9c58c77ab5c4d) ([merge request](gitlab-org/gitlab!62739))
- [Align titles and icons in Security pages](gitlab-org/gitlab@d98f9442f52b198bba31a7116665b54b915afc63) ([merge request](gitlab-org/gitlab!62841)) **GitLab Enterprise Edition**
- [Prevent projects with same slug from having same project key](gitlab-org/gitlab@85177b67e9b5ff8f3378b3f7b6ab8f251dd3d785) ([merge request](gitlab-org/gitlab!62240))
- [Allow reporters to read project statistics](gitlab-org/gitlab@af23428c618e5547c03646e6f674743c7971aa0a) ([merge request](gitlab-org/gitlab!62736))
- [Simplify network policy sidebar](gitlab-org/gitlab@b477ebde931c6f1624c6b26ab8eca432ec09ac85) ([merge request](gitlab-org/gitlab!62134)) **GitLab Enterprise Edition**
- [Rename instance_statistics_measurements_table](gitlab-org/gitlab@a29bffcdc0a319fe4f90555787755e6a490fcd06) ([merge request](gitlab-org/gitlab!62797))
- [Converted issuable id to string](gitlab-org/gitlab@52580c529627d29679bc4b784630fff55082c127) ([merge request](gitlab-org/gitlab!62804))
- [Fixed scroll on todos](gitlab-org/gitlab@bcd934db8c991d197ff5683942ab2fabc3d1a36d) ([merge request](gitlab-org/gitlab!62807))
- [Replace Flash with GlAlert in Boards](gitlab-org/gitlab@76c6c7538c0860ba0f34d2d1cd15e3daf458dac7) ([merge request](gitlab-org/gitlab!61969))
- [Improve fork error message](gitlab-org/gitlab@1d45ae6f9c8f681c34ad55dc5234b857e30929ca) ([merge request](gitlab-org/gitlab!62664))
- [Allow `extra` parameter for Snowplow events](gitlab-org/gitlab@b75c135b4b4c588dadfc9540f16c06e450406d91) ([merge request](!56869))
- [Import group epics via ndjson when using Bulk Import](gitlab-org/gitlab@03b2fe02d5c4d118382b4f9676d0def6ca990d88) ([merge request](gitlab-org/gitlab!62590)) **GitLab Enterprise Edition**
- [What's New content link opens in new tab](gitlab-org/gitlab@af59ed027df3fec6caba85f48247a148b5b57225) ([merge request](gitlab-org/gitlab!61954))
- [No Longer Send Legacy Feature Flags](gitlab-org/gitlab@d52208fc3e180de5f84ddb6906b1fdb1afc6f739) ([merge request](gitlab-org/gitlab!62484))
- [Strip out junit screenshot path](gitlab-org/gitlab@c13fdd442560d3d060b29fab2ad6f3b1eecd7523) ([merge request](gitlab-org/gitlab!62520))
- [Remove unused ProcessPrometheusAlertWorker worker](gitlab-org/gitlab@9ea5ec8d23b968d31c7e5709145505d9d8ce2ab9) ([merge request](gitlab-org/gitlab!62579))
- [Rename experiment_subjects group_id column](gitlab-org/gitlab@66f28b08867a6678b3168e28ca4459539dfd5a8f) ([merge request](gitlab-org/gitlab!62696))
- [Remove unused ProcessAlertWorker](gitlab-org/gitlab@f7a81d88c89f5ab0b3bc50ae32c41b10e8516dbf) ([merge request](gitlab-org/gitlab!62582))
- [Update pipeline failed notification emails to refer to jobs](gitlab-org/gitlab@c01132d844c88a0fab88d7a94679ccc6ff185d93) ([merge request](gitlab-org/gitlab!62671))
- [Improve approvers text](gitlab-org/gitlab@47478e05bfcce81704b44c09a4ca1f67dca2dfe6) ([merge request](gitlab-org/gitlab!62657)) **GitLab Enterprise Edition**
- [Update securityReportSummary to avoid expensive operation](gitlab-org/gitlab@a796af895c2332a6f19f14048f356d394f2c4010) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/61221)) **GitLab Enterprise Edition**
- [Redesign policy editor page](gitlab-org/gitlab@c81e65ff1e7a17946a4e4bc5688a975311e6ac67) ([merge request](gitlab-org/gitlab!62344)) **GitLab Enterprise Edition**
- [Enable builds queue on replicas by default](gitlab-org/gitlab@2a7b20d0911b8c7876f79047ddb9a98bb7abf0da) ([merge request](gitlab-org/gitlab!62619))
- [Update Unknown signin email timestamp to use 24 hour time](gitlab-org/gitlab@cc0a6c567bbaa677e64b2f98a67d303dfcd6539d) ([merge request](gitlab-org/gitlab!47748))
- [Move cluster management projects out of alpha](gitlab-org/gitlab@d4189c0846a401f3bb4c6bc9f25a66452f96306a) ([merge request](gitlab-org/gitlab!62255))
- [Update group creation UI](gitlab-org/gitlab@db58b29afcf18b46c5d844a1c086454e394d8079) ([merge request](gitlab-org/gitlab!61100))
- [Remove group timelog mandatory arguments](gitlab-org/gitlab@cfdedd479eeac7e319aabcf84635e248a518a2fc) ([merge request](gitlab-org/gitlab!61847))
- [Remove include_lfs_blobs_in_archive feature flag](gitlab-org/gitlab@c17834bb95399626e55a3b161e6bc0d9f019f84f) ([merge request](gitlab-org/gitlab!62539))
- [Add BulkImports NdjsonExtractor & update labels pipeline to use it](gitlab-org/gitlab@53ca7bd16d6f92610343d7da34e3f2f1a867dc1b) ([merge request](gitlab-org/gitlab!62409))
- [Remove @service from integrations contollers](gitlab-org/gitlab@3add719db257714bb462c580b7c83d89a20e7ad0) ([merge request](gitlab-org/gitlab!62551))
- [Allow url without .git suffix for import](gitlab-org/gitlab@b6981d9baaa8d5680cd7e5a267b8c1be84f22836) ([merge request](gitlab-org/gitlab!62552))
- [Enforce maximum attachment size in project API uploads by default](gitlab-org/gitlab@c8c13203828c8443487eb44f719856b6f12998e8) ([merge request](gitlab-org/gitlab!62542))
- [Added path navigation to project VSA](gitlab-org/gitlab@70abdb446166465578f8b90826ec3effab1d5949) ([merge request](gitlab-org/gitlab!61125)) **GitLab Enterprise Edition**
- [Enable builds queue limit by default](gitlab-org/gitlab@c853efd7f8f3813c318ef44beaa809a4ad12bf5c) ([merge request](gitlab-org/gitlab!62405))
- [Fix spacing for branch switcher in pipeline editor](gitlab-org/gitlab@ef1cbb855fa99d504f2ac954cfc5f083d89e9818) ([merge request](gitlab-org/gitlab!62534))
- [Updates authorization for lint](gitlab-org/gitlab@f8524e7f322db547e578b5c205252d97aa068db8) ([merge request](gitlab-org/gitlab!62004))
- [Separate adoption segment namespaces](gitlab-org/gitlab@212d28d988cbd9f8b6345236c77d2d49dad7cd28) ([merge request](gitlab-org/gitlab!61903))
- [Use :latest image tag in default Ruby CI template](gitlab-org/gitlab@58439fb1fa48fba378e86039a6b241f152cc7bd4) ([merge request](gitlab-org/gitlab!61283))
- [Globally enable better generic metrics comparison](gitlab-org/gitlab@d7c47fb1f98c27a064b662c6cee53aa40efcdeec) ([merge request](gitlab-org/gitlab!62335))
- [Upgrade CQ for updated Rubocop for Ruby 3](gitlab-org/gitlab@551f2cdd6ce94bd9b39f7afda4b57d1e8f1b278d) ([merge request](gitlab-org/gitlab!61833))
- [Remove Links header](gitlab-org/gitlab@47203a782e9f396add2f4c98e4dfc8c61b2a9a56) ([merge request](gitlab-org/gitlab!62388))
- [Reduce queries when ticking the runner queue by default](gitlab-org/gitlab@f4170c07a4c59fab0c0bf4cee9cc84721e2a04f2) ([merge request](gitlab-org/gitlab!62146))
- [Add codeowners to DevOps Adoption](gitlab-org/gitlab@c99eca0dfad287deee2c687266f930178cb32ebf) ([merge request](gitlab-org/gitlab!62072))
- [Prevent retried builds from being retried again](gitlab-org/gitlab@f932aea58ee5500651017ea40357d2779ca10ea8) ([merge request](gitlab-org/gitlab!62349))
- [Raise job rules without workflow warnings by default](gitlab-org/gitlab@bf779d0b1de98155c0472120db9e6ce967f23593) ([merge request](gitlab-org/gitlab!61945))
- [Better errors to users for CustomersDot API calls](gitlab-org/gitlab@48440e250df8edf3921b958069756fe9add4562b) ([merge request](gitlab-org/gitlab!62367))
- [Enable live consumption for all paid plans](gitlab-org/gitlab@acc183586a5eb8352e648540cfc78926872521a0) ([merge request](gitlab-org/gitlab!62178))
- [Remove webhooks_moved user callout](gitlab-org/gitlab@43a5b008f10481a807cbe84bf0e62490aedcfe56) ([merge request](gitlab-org/gitlab!61960))
- [Use new location for container-scanning analyzer](gitlab-org/gitlab@345978be218a53692196ee2adac531baf7a74363) ([merge request](gitlab-org/gitlab!62358))
- [Remove code owner ribbon move announcement from settings](gitlab-org/gitlab@b038f48d279a3640f5bdb38081c9212a5df498cf) ([merge request](gitlab-org/gitlab!62299))
- [Move gosec to alphabetical order](gitlab-org/gitlab@a08537d3bb3c530c51b27a625400d9df8f9a3865) ([merge request](gitlab-org/gitlab!62299))
- [Update Operations settings forms to be UX consistent](gitlab-org/gitlab@835bee362133230a73890d8c0e47daa94f85d3d1) ([merge request](gitlab-org/gitlab!62299))
- [Lock a newly created item card in boards](gitlab-org/gitlab@6fa9e817c5d6b4f45a71ea1f34aeab237035b6ca) ([merge request](gitlab-org/gitlab!62012))
- [Simplify error code handling for external pipeline validation](gitlab-org/gitlab@5a17b30dc1d5e50a01eda71bccd5aeeafc17c7c7) ([merge request](gitlab-org/gitlab!62012))
- [Backfill clusters_integration_prometheus.enabled](gitlab-org/gitlab@ccedc0a5f379bb5353ee950f1df251b564026070) ([merge request](gitlab-org/gitlab!62012))
- [Add ease score onboarding in-product marketing email](gitlab-org/gitlab@7e2699e16cb397b0e40a62af23c6ce460087530c) ([merge request](gitlab-org/gitlab!62012))
- [Allow issue type change for incidents](gitlab-org/gitlab@455192325b567617bf0bb5b809c1d23f6d7b7215) ([merge request](gitlab-org/gitlab!62012))
- [Observe secondary email addresses when adding a member](gitlab-org/gitlab@4b57957a23fbd72c812fbafc50abd567015cc583) ([merge request](gitlab-org/gitlab!62012))
- [Left-align certain application-wide cancel buttons to conform to the GitLab Pajamas style guide](gitlab-org/gitlab@ebf3df5f857dd5f0929ab1a110bc96f3f6db3286) ([merge request](gitlab-org/gitlab!62012))
- [Remove old redirect rule for the usage trends feature](gitlab-org/gitlab@2151cf64c3447a7e9f00c2cd5d394fb657395fff) ([merge request](gitlab-org/gitlab!62012))
- [Simplify error code handling for external pipeline validation](gitlab-org/gitlab@dd0cd8e32e3028276a994132c5840a0474dc6035) ([merge request](gitlab-org/gitlab!61190))
- [Set minimum Redis version to 5.0](gitlab-org/gitlab@2cfe54c0d75d4752978a2a2e20b8eb5ba8d59829) ([merge request](gitlab-org/gitlab!62156))
- [Observe secondary email addresses when adding a member](gitlab-org/gitlab@e77c72dcf38da384a73c47ebd6ce0e2d1b006f38) ([merge request](gitlab-org/gitlab!62024))

### Deprecated (3 changes)

- [Depreciate GMA from Logs view in Operations](gitlab-org/gitlab@71df6576657f8410fba8b4306eab5b15bbe87460) ([merge request](gitlab-org/gitlab!63517))
- [Deprecate related projects_with_prometheus_alerts metrics](gitlab-org/gitlab@c719c378dcf63da7b8bb9c5be0869b64537ee868) ([merge request](gitlab-org/gitlab!61872))
- [Remove OpenJDK-alpine Dockerfile template](gitlab-org/gitlab@8891a02665a0f316faefe802702f717fb0d4521f) ([merge request](gitlab-org/gitlab!61867))

### Removed (46 changes)

- [Remove metrics dashboard alert functionality](gitlab-org/gitlab@820924deb74368dd6263ddc4dcaa462b001acba9) ([merge request](gitlab-org/gitlab!63838))
- [Remove load_balancing_for_web_hook_worker FF](gitlab-org/gitlab@8608f495de805f392e474334b0f108b3cab92bbf) ([merge request](gitlab-org/gitlab!63988))
- [Drop license_management artifact](gitlab-org/gitlab@f385377cf38d187f138885af984a7d66f3628e0f) ([merge request](gitlab-org/gitlab!62302)) **GitLab Enterprise Edition**
- [Remove ssh_key_expiration_email_notification feature flag](gitlab-org/gitlab@35bc6dd82316fd03a46dfe42b85c6d890a5339b2) ([merge request](gitlab-org/gitlab!63877))
- [Remove support for creating/updating release notes via tags API](gitlab-org/gitlab@9bda56ad634f5088d2bbac2ad45420d7699fd4e1) ([merge request](gitlab-org/gitlab!63389))
- [Drop support of legacy feature flag](gitlab-org/gitlab@d416cf01f4cd5c5ae3eaa853b9cfdc64db3ada5b) ([merge request](gitlab-org/gitlab!63614))
- [Removes SAST_DEFAULT_ANALYZERS variable](gitlab-org/gitlab@aa31a30ac3b454b7d3723b71ef2b09a02768f324) ([merge request](gitlab-org/gitlab!63538))
- [Replace 'tag_list' with 'topic_list' attribute on project](gitlab-org/gitlab@2ff0b5e350ff77e0122adbe2b462636382828a86) ([merge request](gitlab-org/gitlab!63493))
- [Don't take fingerprints for the internal authorized_keys API](gitlab-org/gitlab@afeaa2e772e63b03ab235fed0f2abad9d5dbe014) ([merge request](gitlab-org/gitlab!63783))
- [Remove redundant key/value pair from the payload of DORA metrics API](gitlab-org/gitlab@9064c0fbbe7caaceb22fc3ac2ae394822094cb6a) ([merge request](gitlab-org/gitlab!62875))
- [Remove canary_ingress_weight_control feature flag](gitlab-org/gitlab@1b29140c696f1c3ba6d69031963069f092df9725) ([merge request](gitlab-org/gitlab!63710))
- [Remove allow_group_deploy_token feature flag](gitlab-org/gitlab@0317654a7b106644439ac5bc6f971f63ba4cfe09) ([merge request](gitlab-org/gitlab!63727))
- [Remove GitLab-managed applications UI](gitlab-org/gitlab@f770bce42385999dc5cfecd69a490911dacfc411) ([merge request](gitlab-org/gitlab!63348))
- [Remove GMAv1 Fluentd](gitlab-org/gitlab@2a21bfcda7f0d9c67529559f4c27395c4954f67d) ([merge request](gitlab-org/gitlab!63755))
- [Remove GraphQL deprecated fields](gitlab-org/gitlab@89009fc7e7c4830dbebec7ccd911fb4fcee17722) ([merge request](gitlab-org/gitlab!63293))
- [Remove GitLab WAF related models, services and workers](gitlab-org/gitlab@d1146081367b992ff33f9956ea32c7306cab900a) ([merge request](gitlab-org/gitlab!61556)) **GitLab Enterprise Edition**
- [Remove legacy profile routes](gitlab-org/gitlab@d7efa70a41956fcf8d13ce6079ac96b3f7efee31) ([merge request](gitlab-org/gitlab!63566))
- [Replace 'tags' with 'topics' association on project](gitlab-org/gitlab@784c5dabe6cbb2393a306b1331d4e648631f005b) ([merge request](gitlab-org/gitlab!62549))
- [Remove deprecated CI workers and arguments](gitlab-org/gitlab@5e2dbc0e2dc51e190fb04b3ad01ef056622ae2e3) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/63323))
- [Deprecate global usage of SAST_ANALYZER_IMAGE_TAG](gitlab-org/gitlab@422219bae6a101258826f96deca431072621f124) ([merge request](gitlab-org/gitlab!62724))
- [Remove BuildsEmailService records from services](gitlab-org/gitlab@272464a44b95f0f8edb25c01aa91a1e0b80a6431) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/63264))
- [Remove metrics for Web Application Firewall](gitlab-org/gitlab@d4c579847bfe75192270be221bbce169956fb809) ([merge request](gitlab-org/gitlab!61448))
- [Remove documentation for GitLab WAF](gitlab-org/gitlab@e5a771237f211bc339d663e1d94d1a4be6d6766c) ([merge request](gitlab-org/gitlab!61441))
- [Remove Unicorn support](gitlab-org/gitlab@e2fc284cc73dea159baacb38d655d8d6e2fc3530) ([merge request](gitlab-org/gitlab!61888))
- [Remove projects_with_prometheus_alerts and pod_logs_usages_total metrics](gitlab-org/gitlab@c90a373081c379b66ec1465ec62900280bd529e9) ([merge request](gitlab-org/gitlab!62962))
- [Remove code coverage tracking feature flag](gitlab-org/gitlab@757dd33a6303d33061975e8513286192636144e4) ([merge request](gitlab-org/gitlab!62595))
- [Remove pick_into_project feature flag](gitlab-org/gitlab@0ac685ba56d3367ff23c08a84c9647acfa6e0f20) ([merge request](gitlab-org/gitlab!62809))
- [Remove postgres hll batch counting ff](gitlab-org/gitlab@38f718f80b9257ce39f67e8649dfc063ac3e9101) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/62813))
- [Remove `trace` parameter from `PUT /api/jobs/:id`](gitlab-org/gitlab@4c8900c0417cec10ccbb9cdc6c0bc91ad9d74537) ([merge request](gitlab-org/gitlab!62758))
- [Remove CI_PROJECT_CONFIG_PATH variable](gitlab-org/gitlab@984218929c9c17f48b1b6ce44c57a826c40dba5d) ([merge request](gitlab-org/gitlab!61977))
- [Remove inherited_issuable_templates feature flag](gitlab-org/gitlab@f424d6e6f70dbf35fd3088c4937205f771d062d3) ([merge request](gitlab-org/gitlab!56747))
- [Remove deprecated `--experimental-queue-selector` flag for Sidekiq](gitlab-org/gitlab@f0dcc2d13e8271cfcc23265ac488e8b946ff7dac) ([merge request](gitlab-org/gitlab!62697))
- [Remove unused instance statistics workers](gitlab-org/gitlab@d07788c23502f53fe22dd2a7d0a6546181dc13a7) ([merge request](gitlab-org/gitlab!62583))
- [Remove Unicorn references from runtime logic](gitlab-org/gitlab@8c0ccaec331c0c8f9cea0ff11cf16ba6244281b6) ([merge request](gitlab-org/gitlab!62390))
- [Remove unicorn-worker-killer gem and relations](gitlab-org/gitlab@fdc7dad54ac3f5cdbb7ce93ac9b391bd2a065a02) ([merge request](gitlab-org/gitlab!62293))
- [Remove Unicorn detection in pid provider](gitlab-org/gitlab@6d875648769b638a1117617d7929b2ac21bbc9e3) ([merge request](gitlab-org/gitlab!62377))
- [Remove assigned open issue count background worker](gitlab-org/gitlab@0ac4bc765a2cd35dd0062899b536a1a166a350bf) ([merge request](gitlab-org/gitlab!62370))
- [Remove start-up scripts for Unicorn web server](gitlab-org/gitlab@74b58f507f910169e742a17b229547837975ad5e) ([merge request](gitlab-org/gitlab!62289))
- [Remove UnicornCheck service](gitlab-org/gitlab@83d53d02cf77cfd8ec26b30d389103d148dbd196) ([merge request](gitlab-org/gitlab!62012))
- [Remove support for /wip quick action](gitlab-org/gitlab@1842425ba033bb420e58a66aba40436800440cdc) ([merge request](gitlab-org/gitlab!62012))
- [Redirect some of deprecated repository routes](gitlab-org/gitlab@942adb32b60ac9329c061e34e9094cdf972bc19f) ([merge request](gitlab-org/gitlab!62012))
- [Remove some deprecated global routes](gitlab-org/gitlab@924890e647040a7dde8e200d9056edd38b90cfaa) ([merge request](gitlab-org/gitlab!62012))
- [Remove Unicorn Sampler](gitlab-org/gitlab@311703895118692216ad14af4ddf100c4d41f48b) ([merge request](gitlab-org/gitlab!62012))
- [Drop plugins directory support](gitlab-org/gitlab@dc87151f9f2ea5e3d3e307f361da4db3db406876) ([merge request](gitlab-org/gitlab!62012))
- [Remove UnicornCheck service](gitlab-org/gitlab@6cc7c1c91dafd3d2830406e99da5c8eb778db48a) ([merge request](gitlab-org/gitlab!62204))
- [Remove Unicorn Sampler and its dependencies](gitlab-org/gitlab@b30ae67d140973dcee5d292c13119d82f80182ad) ([merge request](gitlab-org/gitlab!62090))

### Security (12 changes)

- [Change button type so the form doesn't submit](gitlab-org/gitlab@9f96385312400a270d1b09f53b3a4e286505102a) ([merge request](gitlab-org/gitlab!63895))
- [Bump BinData version](gitlab-org/gitlab@49f41ecab3cfc8dc54dda314a440630726455828)
- [Use xpath search of Nokogiri instead of css search](gitlab-org/gitlab@66c21aca75fec6c8f9454f1b6fdda52c44e90db1)
- [Truncate all non-blob markdown to 1MB by default](gitlab-org/gitlab@de3ea3cb762bb8d08d4419e048a171b4719aaf5e)
- [Block access to GitLab for users with expired password](gitlab-org/gitlab@9abcdb766a3098f4191aab125ddfc04eea40ab44)
- [Adds redirect page to OAuth](gitlab-org/gitlab@5d9a9224b590fb2f77ae3fe78370ca982578d22b)
- [Opt in to Atlassians new context qsh](gitlab-org/gitlab@bd02953c891398513e69de00186b010a81f88f80)
- [Limit oncall projects shown to scope of source](gitlab-org/gitlab@bf65867e699a43fcf41661c554bd40fafdff3482) **GitLab Enterprise Edition**
- [Merge branch 'id-upgrade-rails-to-6.0.3.7' into 'master'](gitlab-org/gitlab@0d8d8c7ad7590b4c95ef89e3fd1ec43f89292372) ([merge request](gitlab-org/gitlab!62347))
- [Update users two factor required from group](gitlab-org/gitlab@b9a6117b87fdbff54999a2282f41b8f27d1cea7d)
- [Only verify commit signatures if the user email is verified](gitlab-org/gitlab@fe21bb58c79be0128530b02ef1db25ce3ea183ff)
- [Prevent XSS on notebooks](gitlab-org/gitlab@1f23ad420d1c1853eb03722cd183758f749a375f)

### Performance (45 changes)

- [Add post deployment migration for cleanup policies](gitlab-org/gitlab@00dca6deae3d6159763d296af55a8e32e786d4b2) ([merge request](gitlab-org/gitlab!63841))
- [Enable caching of PG typemap by default](gitlab-org/gitlab@ea9ae9731df199387d7d7a7abbc5072456afb462) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/64010))
- [Paginate diffs using Gitaly paths](gitlab-org/gitlab@b6e206b0ff7410abc28171aa0c53c80fd6acd1c3) ([merge request](gitlab-org/gitlab!62543))
- [Prevent refetching commit data](gitlab-org/gitlab@4829a69f027d0a5f68cd9b34194f066ebf86c4a2) ([merge request](gitlab-org/gitlab!63870))
- [Use title, not full_title for commit mentionables](gitlab-org/gitlab@d33a225801f62cf4d8ae39bed7fe718a9a542fdd) ([merge request](gitlab-org/gitlab!63869))
- [Add index for project_features.container_registry_access_level](gitlab-org/gitlab@78c5f2b321f4861a13e0cd8a2faed0dce7c348a3) ([merge request](gitlab-org/gitlab!55071))
- [Reduce number of gitaly calls in Snippet REST list Endpoints](gitlab-org/gitlab@913e8982efad68d4e759a4b1fa2176269e54904a) ([merge request](gitlab-org/gitlab!63735))
- [Improve cache sharing between cached markdown fields and mentionables](gitlab-org/gitlab@c0e6dd6af5e675c46d1eaf852123a5f8650c4877) ([merge request](gitlab-org/gitlab!63040))
- [Add protected pending build column and migrate data](gitlab-org/gitlab@8498d1089d98949716ac9cac21d64a5cf58ad7fb) ([merge request](gitlab-org/gitlab!63759))
- [Prevent fetching commits for next page](gitlab-org/gitlab@ce8bba1418be55e2b01186d0e1101f0c94f02dc7) ([merge request](gitlab-org/gitlab!63525))
- [Retry traversal_ids backfill jobs](gitlab-org/gitlab@a356b0ef27341ef89626bdf54bb783aa299920b4) ([merge request](gitlab-org/gitlab!62992))
- [Enable label reference caching](gitlab-org/gitlab@d21e5bcaad2bef045af250e80230942bde3c78a7) ([merge request](gitlab-org/gitlab!61648))
- [chore: Drop optimize_sql_query_for_security_report feature flag](gitlab-org/gitlab@d5e3be8a7be1f19e926a0faadad6365c1acfa1ea) ([merge request](gitlab-org/gitlab!63558)) **GitLab Enterprise Edition**
- [Add tracking of running shared runner builds](gitlab-org/gitlab@7204a4815b7b2d3e3041da7c0e32180b806c6a9d) ([merge request](gitlab-org/gitlab!62912))
- [Use specialized project_authorization workers](gitlab-org/gitlab@652c1ee874a8a699e3fd651fa3db1cc1cdc5f6c5) ([merge request](gitlab-org/gitlab!63637))
- [Enable 'use_distinct_in_shas_cte' FF by default](gitlab-org/gitlab@425bec5bc5b72c8d47eb1c99a60f55586953c864) ([merge request](gitlab-org/gitlab!63532))
- [Add background migration for unused expiration policies](gitlab-org/gitlab@eda4d6c1da822cc2120187ec1fd1c9bb301f59b5) ([merge request](gitlab-org/gitlab!61983))
- [Fix N+1 problem for fork controller](gitlab-org/gitlab@945abee15a2aca596f84e2ca48966d4df7c164e1) ([merge request](gitlab-org/gitlab!63436))
- [Preload blobs in repo view](gitlab-org/gitlab@b37b804c3fb448f4d68eb5798a2c212eb2542ea5) ([merge request](gitlab-org/gitlab!63066))
- [Utilize load balancing capabilities for UserRefreshOverUserRangeWorker](gitlab-org/gitlab@dd5830e7676bf5ee86d4cbd2777607f6811be842) ([merge request](gitlab-org/gitlab!63280))
- [Optimize queries that timeout in StuckCiJobsWorker](gitlab-org/gitlab@314b7edb776a04e66404dc94849733f6f7777184) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/62239))
- [Linear traversal query for Namespace#root_ancestor](gitlab-org/gitlab@fdf3d7f90ca040c3c41f8a1556387e5fc807411f) ([merge request](gitlab-org/gitlab!61799))
- [Cache open epics count in group sidebar](gitlab-org/gitlab@b763267d9ee39a851742218f188611a5e3b16a1e) ([merge request](gitlab-org/gitlab!62940)) **GitLab Enterprise Edition**
- [Cache sidebar merge requests count at group level](gitlab-org/gitlab@e57650e49ce6a63a2f792b5188432684c8e7bc27) ([merge request](gitlab-org/gitlab!62935))
- [Moves the pipelines.json endpoint to startup js](gitlab-org/gitlab@8d74b69a7ff174ea5b6343ef23e387b0da1f612d) ([merge request](gitlab-org/gitlab!62936))
- [Remove unreferenced lfs objects in batches](gitlab-org/gitlab@0b75859dedbee28bd0118f3354702b2555f199d7) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/56959))
- [Remove preloading of forks in projects API](gitlab-org/gitlab@2a3be447556fd31f32b024bfb72540216926f793) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/62602))
- [Enable pending builds parity by default](gitlab-org/gitlab@0b4c7bb40cb554702e6289101a1b6372c1d11c40) ([merge request](gitlab-org/gitlab!62195))
- [Refine linear queries in Namespace#all_projects](gitlab-org/gitlab@e254445f21f25bc6ad491211ab0a079c1380e1dc) ([merge request](gitlab-org/gitlab!62268))
- [Reinstate branches keyset pagination](gitlab-org/gitlab@a4bdb63bc00d90fed4dec1f3fe3ea91b4d35151e) ([merge request](gitlab-org/gitlab!62458))
- [Optimize Nokogiri search for post-processing pipeline](gitlab-org/gitlab@567685431f4f18ebc52ee6a1865b545addaa1b85) ([merge request](gitlab-org/gitlab!61994))
- [Removes unneeded preloading in Markdown rendering](gitlab-org/gitlab@c264427ea396ec74fcc989f88e1377c5ef76da79) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/62273))
- [Cache `branch_requires_code_owner_approval?`](gitlab-org/gitlab@0459ed2681f990f379ee7e8ced6d07dbf9635f16) ([merge request](gitlab-org/gitlab!56775)) **GitLab Enterprise Edition**
- [Switch group member max access to use bulk load](gitlab-org/gitlab@daa4c18ec4d53863ccdf3263037e34c86b6774de) ([merge request](gitlab-org/gitlab!62226))
- [Utilize load balancing capabilities for BuildHooksWorker](gitlab-org/gitlab@c8d86d0fc29c5b60e206240c6020d3609f57fd4f) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/61905))
- [Add viewer URL to StartupJS](gitlab-org/gitlab@1533d9ec085d503cac5229ebc1ac70babe6c006c) ([merge request](gitlab-org/gitlab!62068))
- [Advanced Search: Allow indexing workers to use replicas](gitlab-org/gitlab@7bc460926a334cda4f4ba4e0248d3647fd24aea8) ([merge request](gitlab-org/gitlab!62299))
- [Reduce memory consumption when an API exception goes to Sentry](gitlab-org/gitlab@1562bac71e71a316244bd762169267b3c6af04c2) ([merge request](gitlab-org/gitlab!62025))
- [Use cache for CI::Build runners check](gitlab-org/gitlab@7c8637c8059d95b9f4b7c3f4e3d64b652c22ecc2) ([merge request](gitlab-org/gitlab!62012))
- [Optimize query for loading artifacts in pipeline](gitlab-org/gitlab@2671124156243942eaab27283ca945896e9ea628) ([merge request](gitlab-org/gitlab!62012))
- [Accelerate builds queuing using a denormalized accelerated table](gitlab-org/gitlab@f4897e038ab01c3ab4f8bd7a30ea85e66837e92c) ([merge request](gitlab-org/gitlab!62012))
- [Remove the redundant update for API endpoint projects/:id/statuses/:sha](gitlab-org/gitlab@956958f2f08744bfedc5069196d772b2fdd3a88b) ([merge request](gitlab-org/gitlab!62012))
- [Contributes to https://gitlab.com/gitlab-org/gitlab/-/issues/325744](gitlab-org/gitlab@c1ba906d216942ce3df70bb3839787bab2954c85) ([merge request](gitlab-org/gitlab!62012))
- [Optimize query for loading artifacts in pipeline](gitlab-org/gitlab@e386fabed47af310f01f836e3f5ee666e61b3c9a) ([merge request](gitlab-org/gitlab!62249))
- [Remove feature flag for "runners_cached_states"](gitlab-org/gitlab@1ebf16062a5cf38e95cacb6451f56f6632c193e5) ([merge request](gitlab-org/gitlab!61998))

### Other (70 changes)

- [Update alert markup in runners page](gitlab-org/gitlab@3ca125ad4c1f216962664c86ae36345827978ccb) ([merge request](gitlab-org/gitlab!63157))
- [Use a new worker in lieu of UserRefreshWithLowUrgencyWorker as safeguard](gitlab-org/gitlab@f444387bc814b9775a89d08cc2c0c6da0ad5aadd) ([merge request](gitlab-org/gitlab!63840))
- [Update test_file_finder and Faraday](gitlab-org/gitlab@7cb2ad42696c1e560f884653e0aa7c5a24cfd51b) ([merge request](gitlab-org/gitlab!64017))
- [Remove notification_setting_recipient_refactor feature flag](gitlab-org/gitlab@379621f6c3fb1251142d0705becff156b4adb8d6) ([merge request](gitlab-org/gitlab!63827))
- [Add Atlassian referrer to Jira links inside GitLab](gitlab-org/gitlab@cb4de493193d3bde64463ce442f3f6f337a27646) ([merge request](gitlab-org/gitlab!63900))
- [Use the parent element to find elements to remove the child](gitlab-org/gitlab@1caa71c02bf05f460