=begin
#OpenBao API

#HTTP API that gives you full access to OpenBao. All API routes are prefixed with `/v1/`.

The version of the OpenAPI document: 2.0.0

Generated by: https://openapi-generator.tech
Generator version: 7.7.0

=end

require 'date'
require 'time'

module OpenbaoClient
  class SshWriteRoleRequest
    # [Not applicable for OTP type] [Optional for CA type] When supplied, this value specifies a signing algorithm for the key. Possible values: ssh-rsa, rsa-sha2-256, rsa-sha2-512, default, or the empty string.
    attr_accessor :algorithm_signer

    # [Not applicable for OTP type] [Optional for CA type] If set, host certificates that are requested are allowed to use the base domains listed in \"allowed_domains\", e.g. \"example.com\". This is a separate option as in some cases this can be considered a security threat.
    attr_accessor :allow_bare_domains

    # [Not applicable for OTP type] [Optional for CA type] If set, certificates are allowed to be signed for use as a 'host'.
    attr_accessor :allow_host_certificates

    # [Not applicable for OTP type] [Optional for CA type] If set, host certificates that are requested are allowed to use subdomains of those listed in \"allowed_domains\".
    attr_accessor :allow_subdomains

    # [Not applicable for OTP type] [Optional for CA type] If set, certificates are allowed to be signed for use as a 'user'.
    attr_accessor :allow_user_certificates

    # [Not applicable for OTP type] [Optional for CA type] If true, users can override the key ID for a signed certificate with the \"key_id\" field. When false, the key ID will always be the token display name. The key ID is logged by the SSH server and can be useful for auditing.
    attr_accessor :allow_user_key_ids

    # [Not applicable for OTP type] [Optional for CA type] A comma-separated list of critical options that certificates can have when signed. To allow any critical options, set this to an empty string.
    attr_accessor :allowed_critical_options

    # [Not applicable for OTP type] [Optional for CA type] If this option is not specified, client can request for a signed certificate for any valid host. If only certain domains are allowed, then this list enforces it.
    attr_accessor :allowed_domains

    # [Not applicable for OTP type] [Optional for CA type] If set, Allowed domains can be specified using identity template policies. Non-templated domains are also permitted.
    attr_accessor :allowed_domains_template

    # [Not applicable for OTP type] [Optional for CA type] A comma-separated list of extensions that certificates can have when signed. An empty list means that no extension overrides are allowed by an end-user; explicitly specify '*' to allow any extensions to be set.
    attr_accessor :allowed_extensions

    # [Not applicable for OTP type] [Optional for CA type] If set, allows the enforcement of key types and minimum key sizes to be signed.
    attr_accessor :allowed_user_key_lengths

    # [Optional for all types] [Works differently for CA type] If this option is not specified, or is '*', client can request a credential for any valid user at the remote host, including the admin user. If only certain usernames are to be allowed, then this list enforces it. If this field is set, then credentials can only be created for default_user and usernames present in this list. Setting this option will enable all the users with access to this role to fetch credentials for all other usernames in this list. Use with caution. N.B.: with the CA type, an empty list means that no users are allowed; explicitly specify '*' to allow any user.
    attr_accessor :allowed_users

    # [Not applicable for OTP type] [Optional for CA type] If set, Allowed users can be specified using identity template policies. Non-templated users are also permitted.
    attr_accessor :allowed_users_template

    # [Optional for OTP type] [Not applicable for CA type] Comma separated list of CIDR blocks for which the role is applicable for. CIDR blocks can belong to more than one role.
    attr_accessor :cidr_list

    # [Not applicable for OTP type] [Optional for CA type] Critical options certificates should have if none are provided when signing. This field takes in key value pairs in JSON format. Note that these are not restricted by \"allowed_critical_options\". Defaults to none.
    attr_accessor :default_critical_options

    # [Not applicable for OTP type] [Optional for CA type] Extensions certificates should have if none are provided when signing. This field takes in key value pairs in JSON format. Note that these are not restricted by \"allowed_extensions\". Defaults to none.
    attr_accessor :default_extensions

    # [Not applicable for OTP type] [Optional for CA type] If set, Default extension values can be specified using identity template policies. Non-templated extension values are also permitted.
    attr_accessor :default_extensions_template

    # [Required for OTP type] [Optional for CA type] Default username for which a credential will be generated. When the endpoint 'creds/' is used without a username, this value will be used as default username.
    attr_accessor :default_user

    # [Not applicable for OTP type] [Optional for CA type] If set, Default user can be specified using identity template policies. Non-templated users are also permitted.
    attr_accessor :default_user_template

    # [Optional for OTP type] [Not applicable for CA type] Comma separated list of CIDR blocks. IP addresses belonging to these blocks are not accepted by the role. This is particularly useful when big CIDR blocks are being used by the role and certain parts of it needs to be kept out.
    attr_accessor :exclude_cidr_list

    # [Not applicable for OTP type] [Optional for CA type] When supplied, this value specifies a custom format for the key id of a signed certificate. The following variables are available for use: '{{token_display_name}}' - The display name of the token used to make the request. '{{role_name}}' - The name of the role signing the request. '{{public_key_hash}}' - A SHA256 checksum of the public key that is being signed.
    attr_accessor :key_id_format

    # [Required for all types] Type of key used to login to hosts. It can be either 'otp' or 'ca'. 'otp' type requires agent to be installed in remote hosts.
    attr_accessor :key_type

    # [Not applicable for OTP type] [Optional for CA type] The maximum allowed lease duration
    attr_accessor :max_ttl

    # [Not applicable for OTP type] [Optional for CA type] The duration that the SSH certificate should be backdated by at issuance.
    attr_accessor :not_before_duration

    # [Optional for OTP type] [Not applicable for CA type] Port number for SSH connection. Default is '22'. Port number does not play any role in creation of OTP. For 'otp' type, this is just a way to inform client about the port number to use. Port number will be returned to client by OpenBao server along with OTP.
    attr_accessor :port

    # [Not applicable for OTP type] [Optional for CA type] The lease duration if no specific lease duration is requested. The lease duration controls the expiration of certificates issued by this backend. Defaults to the value of max_ttl.
    attr_accessor :ttl

    class EnumAttributeValidator
      attr_reader :datatype
      attr_reader :allowable_values

      def initialize(datatype, allowable_values)
        @allowable_values = allowable_values.map do |value|
          case datatype.to_s
          when /Integer/i
            value.to_i
          when /Float/i
            value.to_f
          else
            value
          end
        end
      end

      def valid?(value)
        !value || allowable_values.include?(value)
      end
    end

    # Attribute mapping from ruby-style variable name to JSON key.
    def self.attribute_map
      {
        :'algorithm_signer' => :'algorithm_signer',
        :'allow_bare_domains' => :'allow_bare_domains',
        :'allow_host_certificates' => :'allow_host_certificates',
        :'allow_subdomains' => :'allow_subdomains',
        :'allow_user_certificates' => :'allow_user_certificates',
        :'allow_user_key_ids' => :'allow_user_key_ids',
        :'allowed_critical_options' => :'allowed_critical_options',
        :'allowed_domains' => :'allowed_domains',
        :'allowed_domains_template' => :'allowed_domains_template',
        :'allowed_extensions' => :'allowed_extensions',
        :'allowed_user_key_lengths' => :'allowed_user_key_lengths',
        :'allowed_users' => :'allowed_users',
        :'allowed_users_template' => :'allowed_users_template',
        :'cidr_list' => :'cidr_list',
        :'default_critical_options' => :'default_critical_options',
        :'default_extensions' => :'default_extensions',
        :'default_extensions_template' => :'default_extensions_template',
        :'default_user' => :'default_user',
        :'default_user_template' => :'default_user_template',
        :'exclude_cidr_list' => :'exclude_cidr_list',
        :'key_id_format' => :'key_id_format',
        :'key_type' => :'key_type',
        :'max_ttl' => :'max_ttl',
        :'not_before_duration' => :'not_before_duration',
        :'port' => :'port',
        :'ttl' => :'ttl'
      }
    end

    # Returns all the JSON keys this model knows about
    def self.acceptable_attributes
      attribute_map.values
    end

    # Attribute type mapping.
    def self.openapi_types
      {
        :'algorithm_signer' => :'String',
        :'allow_bare_domains' => :'Boolean',
        :'allow_host_certificates' => :'Boolean',
        :'allow_subdomains' => :'Boolean',
        :'allow_user_certificates' => :'Boolean',
        :'allow_user_key_ids' => :'Boolean',
        :'allowed_critical_options' => :'String',
        :'allowed_domains' => :'String',
        :'allowed_domains_template' => :'Boolean',
        :'allowed_extensions' => :'String',
        :'allowed_user_key_lengths' => :'Object',
        :'allowed_users' => :'String',
        :'allowed_users_template' => :'Boolean',
        :'cidr_list' => :'String',
        :'default_critical_options' => :'Object',
        :'default_extensions' => :'Object',
        :'default_extensions_template' => :'Boolean',
        :'default_user' => :'String',
        :'default_user_template' => :'Boolean',
        :'exclude_cidr_list' => :'String',
        :'key_id_format' => :'String',
        :'key_type' => :'String',
        :'max_ttl' => :'Integer',
        :'not_before_duration' => :'Integer',
        :'port' => :'Integer',
        :'ttl' => :'Integer'
      }
    end

    # List of attributes with nullable: true
    def self.openapi_nullable
      Set.new([
      ])
    end

    # Initializes the object
    # @param [Hash] attributes Model attributes in the form of hash
    def initialize(attributes = {})
      if (!attributes.is_a?(Hash))
        fail ArgumentError, "The input argument (attributes) must be a hash in `OpenbaoClient::SshWriteRoleRequest` initialize method"
      end

      # check to see if the attribute exists and convert string to symbol for hash key
      attributes = attributes.each_with_object({}) { |(k, v), h|
        if (!self.class.attribute_map.key?(k.to_sym))
          fail ArgumentError, "`#{k}` is not a valid attribute in `OpenbaoClient::SshWriteRoleRequest`. Please check the name to make sure it's valid. List of attributes: " + self.class.attribute_map.keys.inspect
        end
        h[k.to_sym] = v
      }

      if attributes.key?(:'algorithm_signer')
        self.algorithm_signer = attributes[:'algorithm_signer']
      end

      if attributes.key?(:'allow_bare_domains')
        self.allow_bare_domains = attributes[:'allow_bare_domains']
      end

      if attributes.key?(:'allow_host_certificates')
        self.allow_host_certificates = attributes[:'allow_host_certificates']
      else
        self.allow_host_certificates = false
      end

      if attributes.key?(:'allow_subdomains')
        self.allow_subdomains = attributes[:'allow_subdomains']
      end

      if attributes.key?(:'allow_user_certificates')
        self.allow_user_certificates = attributes[:'allow_user_certificates']
      else
        self.allow_user_certificates = false
      end

      if attributes.key?(:'allow_user_key_ids')
        self.allow_user_key_ids = attributes[:'allow_user_key_ids']
      end

      if attributes.key?(:'allowed_critical_options')
        self.allowed_critical_options = attributes[:'allowed_critical_options']
      end

      if attributes.key?(:'allowed_domains')
        self.allowed_domains = attributes[:'allowed_domains']
      end

      if attributes.key?(:'allowed_domains_template')
        self.allowed_domains_template = attributes[:'allowed_domains_template']
      else
        self.allowed_domains_template = false
      end

      if attributes.key?(:'allowed_extensions')
        self.allowed_extensions = attributes[:'allowed_extensions']
      end

      if attributes.key?(:'allowed_user_key_lengths')
        self.allowed_user_key_lengths = attributes[:'allowed_user_key_lengths']
      end

      if attributes.key?(:'allowed_users')
        self.allowed_users = attributes[:'allowed_users']
      end

      if attributes.key?(:'allowed_users_template')
        self.allowed_users_template = attributes[:'allowed_users_template']
      else
        self.allowed_users_template = false
      end

      if attributes.key?(:'cidr_list')
        self.cidr_list = attributes[:'cidr_list']
      end

      if attributes.key?(:'default_critical_options')
        self.default_critical_options = attributes[:'default_critical_options']
      end

      if attributes.key?(:'default_extensions')
        self.default_extensions = attributes[:'default_extensions']
      end

      if attributes.key?(:'default_extensions_template')
        self.default_extensions_template = attributes[:'default_extensions_template']
      else
        self.default_extensions_template = false
      end

      if attributes.key?(:'default_user')
        self.default_user = attributes[:'default_user']
      end

      if attributes.key?(:'default_user_template')
        self.default_user_template = attributes[:'default_user_template']
      else
        self.default_user_template = false
      end

      if attributes.key?(:'exclude_cidr_list')
        self.exclude_cidr_list = attributes[:'exclude_cidr_list']
      end

      if attributes.key?(:'key_id_format')
        self.key_id_format = attributes[:'key_id_format']
      end

      if attributes.key?(:'key_type')
        self.key_type = attributes[:'key_type']
      end

      if attributes.key?(:'max_ttl')
        self.max_ttl = attributes[:'max_ttl']
      end

      if attributes.key?(:'not_before_duration')
        self.not_before_duration = attributes[:'not_before_duration']
      else
        self.not_before_duration = 30
      end

      if attributes.key?(:'port')
        self.port = attributes[:'port']
      end

      if attributes.key?(:'ttl')
        self.ttl = attributes[:'ttl']
      end
    end

    # Show invalid properties with the reasons. Usually used together with valid?
    # @return Array for valid properties with the reasons
    def list_invalid_properties
      warn '[DEPRECATED] the `list_invalid_properties` method is obsolete'
      invalid_properties = Array.new
      invalid_properties
    end

    # Check to see if the all the properties in the model are valid
    # @return true if the model is valid
    def valid?
      warn '[DEPRECATED] the `valid?` method is obsolete'
      algorithm_signer_validator = EnumAttributeValidator.new('String', ["", "default", "ssh-rsa", "rsa-sha2-256", "rsa-sha2-512"])
      return false unless algorithm_signer_validator.valid?(@algorithm_signer)
      key_type_validator = EnumAttributeValidator.new('String', ["otp", "ca"])
      return false unless key_type_validator.valid?(@key_type)
      true
    end

    # Custom attribute writer method checking allowed values (enum).
    # @param [Object] algorithm_signer Object to be assigned
    def algorithm_signer=(algorithm_signer)
      validator = EnumAttributeValidator.new('String', ["", "default", "ssh-rsa", "rsa-sha2-256", "rsa-sha2-512"])
      unless validator.valid?(algorithm_signer)
        fail ArgumentError, "invalid value for \"algorithm_signer\", must be one of #{validator.allowable_values}."
      end
      @algorithm_signer = algorithm_signer
    end

    # Custom attribute writer method checking allowed values (enum).
    # @param [Object] key_type Object to be assigned
    def key_type=(key_type)
      validator = EnumAttributeValidator.new('String', ["otp", "ca"])
      unless validator.valid?(key_type)
        fail ArgumentError, "invalid value for \"key_type\", must be one of #{validator.allowable_values}."
      end
      @key_type = key_type
    end

    # Checks equality by comparing each attribute.
    # @param [Object] Object to be compared
    def ==(o)
      return true if self.equal?(o)
      self.class == o.class &&
          algorithm_signer == o.algorithm_signer &&
          allow_bare_domains == o.allow_bare_domains &&
          allow_host_certificates == o.allow_host_certificates &&
          allow_subdomains == o.allow_subdomains &&
          allow_user_certificates == o.allow_user_certificates &&
          allow_user_key_ids == o.allow_user_key_ids &&
          allowed_critical_options == o.allowed_critical_options &&
          allowed_domains == o.allowed_domains &&
          allowed_domains_template == o.allowed_domains_template &&
          allowed_extensions == o.allowed_extensions &&
          allowed_user_key_lengths == o.allowed_user_key_lengths &&
          allowed_users == o.allowed_users &&
          allowed_users_template == o.allowed_users_template &&
          cidr_list == o.cidr_list &&
          default_critical_options == o.default_critical_options &&
          default_extensions == o.default_extensions &&
          default_extensions_template == o.default_extensions_template &&
          default_user == o.default_user &&
          default_user_template == o.default_user_template &&
          exclude_cidr_list == o.exclude_cidr_list &&
          key_id_format == o.key_id_format &&
          key_type == o.key_type &&
          max_ttl == o.max_ttl &&
          not_before_duration == o.not_before_duration &&
          port == o.port &&
          ttl == o.ttl
    end

    # @see the `==` method
    # @param [Object] Object to be compared
    def eql?(o)
      self == o
    end

    # Calculates hash code according to all attributes.
    # @return [Integer] Hash code
    def hash
      [algorithm_signer, allow_bare_domains, allow_host_certificates, allow_subdomains, allow_user_certificates, allow_user_key_ids, allowed_critical_options, allowed_domains, allowed_domains_template, allowed_extensions, allowed_user_key_lengths, allowed_users, allowed_users_template, cidr_list, default_critical_options, default_extensions, default_extensions_template, default_user, default_user_template, exclude_cidr_list, key_id_format, key_type, max_ttl, not_before_duration, port, ttl].hash
    end

    # Builds the object from hash
    # @param [Hash] attributes Model attributes in the form of hash
    # @return [Object] Returns the model itself
    def self.build_from_hash(attributes)
      return nil unless attributes.is_a?(Hash)
      attributes = attributes.transform_keys(&:to_sym)
      transformed_hash = {}
      openapi_types.each_pair do |key, type|
        if attributes.key?(attribute_map[key]) && attributes[attribute_map[key]].nil?
          transformed_hash["#{key}"] = nil
        elsif type =~ /\AArray<(.*)>/i
          # check to ensure the input is an array given that the attribute
          # is documented as an array but the input is not
          if attributes[attribute_map[key]].is_a?(Array)
            transformed_hash["#{key}"] = attributes[attribute_map[key]].map { |v| _deserialize($1, v) }
          end
        elsif !attributes[attribute_map[key]].nil?
          transformed_hash["#{key}"] = _deserialize(type, attributes[attribute_map[key]])
        end
      end
      new(transformed_hash)
    end

    # Deserializes the data based on type
    # @param string type Data type
    # @param string value Value to be deserialized
    # @return [Object] Deserialized data
    def self._deserialize(type, value)
      case type.to_sym
      when :Time
        Time.parse(value)
      when :Date
        Date.parse(value)
      when :String
        value.to_s
      when :Integer
        value.to_i
      when :Float
        value.to_f
      when :Boolean
        if value.to_s =~ /\A(true|t|yes|y|1)\z/i
          true
        else
          false
        end
      when :Object
        # generic object (usually a Hash), return directly
        value
      when /\AArray<(?<inner_type>.+)>\z/
        inner_type = Regexp.last_match[:inner_type]
        value.map { |v| _deserialize(inner_type, v) }
      when /\AHash<(?<k_type>.+?), (?<v_type>.+)>\z/
        k_type = Regexp.last_match[:k_type]
        v_type = Regexp.last_match[:v_type]
        {}.tap do |hash|
          value.each do |k, v|
            hash[_deserialize(k_type, k)] = _deserialize(v_type, v)
          end
        end
      else # model
        # models (e.g. Pet) or oneOf
        klass = OpenbaoClient.const_get(type)
        klass.respond_to?(:openapi_any_of) || klass.respond_to?(:openapi_one_of) ? klass.build(value) : klass.build_from_hash(value)
      end
    end

    # Returns the string representation of the object
    # @return [String] String presentation of the object
    def to_s
      to_hash.to_s
    end

    # to_body is an alias to to_hash (backward compatibility)
    # @return [Hash] Returns the object in the form of hash
    def to_body
      to_hash
    end

    # Returns the object in the form of hash
    # @return [Hash] Returns the object in the form of hash
    def to_hash
      hash = {}
      self.class.attribute_map.each_pair do |attr, param|
        value = self.send(attr)
        if value.nil?
          is_nullable = self.class.openapi_nullable.include?(attr)
          next if !is_nullable || (is_nullable && !instance_variable_defined?(:"@#{attr}"))
        end

        hash[param] = _to_hash(value)
      end
      hash
    end

    # Outputs non-array value in the form of hash
    # For object, use to_hash. Otherwise, just return the value
    # @param [Object] value Any valid value
    # @return [Hash] Returns the value in the form of hash
    def _to_hash(value)
      if value.is_a?(Array)
        value.compact.map { |v| _to_hash(v) }
      elsif value.is_a?(Hash)
        {}.tap do |hash|
          value.each { |k, v| hash[k] = _to_hash(v) }
        end
      elsif value.respond_to? :to_hash
        value.to_hash
      else
        value
      end
    end

  end

end
