/*
 * Copyright 2020 Andrey Kutejko <andy128k@gmail.com>
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 3 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, see <http://www.gnu.org/licenses/>.
 *
 * For more details see the file COPYING.
 */

using Gdk;

public Array<Cursor> make_cursors_for_display (Display display) {
    Array<Cursor> cursors = new Array<Cursor> ();
    cursors.append_val (make_cursor (display, cursor_up_left, 3, 3));
    cursors.append_val (make_cursor (display, cursor_up, 10, 3));
    cursors.append_val (make_cursor (display, cursor_up_right, 17, 3));
    cursors.append_val (make_cursor (display, cursor_left, 3, 10));
    cursors.append_val (make_cursor (display, cursor_hold, 10, 10));
    cursors.append_val (make_cursor (display, cursor_right, 17, 10));
    cursors.append_val (make_cursor (display, cursor_down_left, 3, 17));
    cursors.append_val (make_cursor (display, cursor_down, 10, 17));
    cursors.append_val (make_cursor (display, cursor_down_right, 17, 17));
    return cursors;
}

private Cursor make_cursor (Display display, string[] xpm, int hsx, int hsy) {
    var pixbuf = new Pixbuf.from_xpm_data (xpm);
    return new Cursor.from_pixbuf (display, pixbuf, hsx, hsy);
}

const string cursor_up_left[] = {
  /* width height num_colors chars_per_pixel */
  " 20 20 3 2",
  /* colors */
  ".. c none",
  "## c #ffffff",
  "** c #000000",
  /* pixels */
  "........................................",
  "..######################................",
  "..##****************##..................",
  "..##**************##....................",
  "..##************##......................",
  "..##**************##....................",
  "..##****************##..................",
  "..##******************##................",
  "..##****##**************##..............",
  "..##**##..##**************##............",
  "..####......##**********##..............",
  "..##..........##******##................",
  "................##**##..................",
  "..................##....................",
  "........................................",
  "........................................",
  "........................................",
  "........................................",
  "........................................",
  "........................................"
};

const string cursor_up[] = {
  /* width height num_colors chars_per_pixel */
  " 20 20 3 2",
  /* colors */
  ".. c none",
  "## c #ffffff",
  "** c #000000",
  /* pixels */
  "........................................",
  "....................##..................",
  "..................##**##................",
  "................##******##..............",
  "..............##**********##............",
  "............##**************##..........",
  "..........##******************##........",
  "........##**********************##......",
  "......########**************########....",
  "..............##**********##............",
  "..............##**********##............",
  "..............##**********##............",
  "..............##**********##............",
  "..............##**********##............",
  "..............##**********##............",
  "..............##**********##............",
  "..............##############............",
  "........................................",
  "........................................",
  "........................................"
};

const string cursor_up_right[] = {
  /* width height num_colors chars_per_pixel */
  " 20 20 3 2",
  /* colors */
  ".. c none",
  "## c #ffffff",
  "** c #000000",
  /* pixels */
  "........................................",
  "................######################..",
  "..................##****************##..",
  "....................##**************##..",
  "......................##************##..",
  "....................##**************##..",
  "..................##****************##..",
  "................##******************##..",
  "..............##**************##****##..",
  "............##**************##..##**##..",
  "..............##**********##......####..",
  "................##******##..........##..",
  "..................##**##................",
  "....................##..................",
  "........................................",
  "........................................",
  "........................................",
  "........................................",
  "........................................",
  "........................................"
};

const string cursor_left[] = {
  /* width height num_colors chars_per_pixel */
  " 20 20 3 2",
  /* colors */
  ".. c none",
  "## c #ffffff",
  "** c #000000",
  /* pixels */
  "........................................",
  "........................................",
  "................##......................",
  "..............####......................",
  "............##**##......................",
  "..........##****##......................",
  "........##********################......",
  "......##************************##......",
  "....##**************************##......",
  "..##****************************##......",
  "....##**************************##......",
  "......##************************##......",
  "........##********################......",
  "..........##****##......................",
  "............##**##......................",
  "..............####......................",
  "................##......................",
  "........................................",
  "........................................",
  "........................................"
};

const string cursor_hold[] = {
  /* width height num_colors chars_per_pixel */
  " 20 20 3 2",
  /* colors */
  ".. c none",
  "## c #ffffff",
  "** c #000000",
  /* pixels */
  "........................................",
  "........................................",
  "........................................",
  "........................................",
  "..............##########................",
  "..........####**********####............",
  "..........##**************##............",
  "........##******************##..........",
  "........##******************##..........",
  "........##******************##..........",
  "........##******************##..........",
  "........##******************##..........",
  "..........##**************##............",
  "..........####**********####............",
  "..............##########................",
  "........................................",
  "........................................",
  "........................................",
  "........................................",
  "........................................"
};

const string cursor_right[] = {
  /* width height num_colors chars_per_pixel */
  " 20 20 3 2",
  /* colors */
  ".. c none",
  "## c #ffffff",
  "** c #000000",
  /* pixels */
  "........................................",
  "........................................",
  "......................##................",
  "......................####..............",
  "......................##**##............",
  "......................##****##..........",
  "......################********##........",
  "......##************************##......",
  "......##**************************##....",
  "......##****************************##..",
  "......##**************************##....",
  "......##************************##......",
  "......################********##........",
  "......................##****##..........",
  "......................##**##............",
  "......................####..............",
  "......................##................",
  "........................................",
  "........................................",
  "........................................"
};

const string cursor_down_left[] = {
  /* width height num_colors chars_per_pixel */
  " 20 20 3 2",
  /* colors */
  ".. c none",
  "## c #ffffff",
  "** c #000000",
  /* pixels */
  "........................................",
  "........................................",
  "........................................",
  "........................................",
  "........................................",
  "........................................",
  "..................##....................",
  "................##**##..................",
  "..##..........##******##................",
  "..####......##**********##..............",
  "..##**##..##**************##............",
  "..##****##**************##..............",
  "..##******************##................",
  "..##****************##..................",
  "..##**************##....................",
  "..##************##......................",
  "..##**************##....................",
  "..##****************##..................",
  "..######################................",
  "........................................"
};

const string cursor_down[] = {
  /* width height num_colors chars_per_pixel */
  " 20 20 3 2",
  /* colors */
  ".. c none",
  "## c #ffffff",
  "** c #000000",
  /* pixels */
  "........................................",
  "........................................",
  "........................................",
  "..............##############............",
  "..............##**********##............",
  "..............##**********##............",
  "..............##**********##............",
  "..............##**********##............",
  "..............##**********##............",
  "..............##**********##............",
  "..............##**********##............",
  "......########**************########....",
  "........##**********************##......",
  "..........##******************##........",
  "............##**************##..........",
  "..............##**********##............",
  "................##******##..............",
  "..................##**##................",
  "....................##..................",
  "........................................"
};

const string cursor_down_right[] = {
  /* width height num_colors chars_per_pixel */
  " 20 20 3 2",
  /* colors */
  ".. c none",
  "## c #ffffff",
  "** c #000000",
  /* pixels */
  "........................................",
  "........................................",
  "........................................",
  "........................................",
  "........................................",
  "........................................",
  "....................##..................",
  "..................##**##................",
  "................##******##..........##..",
  "..............##**********##......####..",
  "............##**************##..##**##..",
  "..............##**************##****##..",
  "................##******************##..",
  "..................##****************##..",
  "....................##**************##..",
  "......................##************##..",
  "....................##**************##..",
  "..................##****************##..",
  "................######################..",
  "........................................"
};

