//Copyright 2013 Vastech SA (PTY) LTD
//
//   Licensed under the Apache License, Version 2.0 (the "License");
//   you may not use this file except in compliance with the License.
//   You may obtain a copy of the License at
//
//       http://www.apache.org/licenses/LICENSE-2.0
//
//   Unless required by applicable law or agreed to in writing, software
//   distributed under the License is distributed on an "AS IS" BASIS,
//   WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
//   See the License for the specific language governing permissions and
//   limitations under the License.

package golang

import (
	"bytes"
	"path"
	"text/template"

	"github.com/goccmack/gocc/internal/io"
)

func GenContext(pkg, outDir string) {
	tmpl, err := template.New("context").Parse(contextSrc[1:])
	if err != nil {
		panic(err)
	}
	wr := new(bytes.Buffer)
	if err := tmpl.Execute(wr, nil); err != nil {
		panic(err)
	}
	io.WriteFile(path.Join(outDir, "parser", "context.go"), wr.Bytes())
}

const contextSrc = `
// Code generated by gocc; DO NOT EDIT.

package parser

// Parser-specific user-defined and entirely-optional context,
// accessible as '$Context' in SDT actions.
type Context interface{}
`
