/*
 * This file is part of the libopencm3 project.
 *
 * Copyright (C) 2010 Gareth McMullin <gareth@blacksphere.co.nz>
 *
 * This library is free software: you can redistribute it and/or modify
 * it under the terms of the GNU Lesser General Public License as published by
 * the Free Software Foundation, either version 3 of the License, or
 * (at your option) any later version.
 *
 * This library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU Lesser General Public License for more details.
 *
 * You should have received a copy of the GNU Lesser General Public License
 * along with this library.  If not, see <http://www.gnu.org/licenses/>.
 */

#ifndef LIBOPENCM3_ETHERNET_H
#define LIBOPENCM3_ETHERNET_H

#include <libopencm3/stm32/memorymap.h>
#include <libopencm3/cm3/common.h>

/* Ethernet MAC registers */
#define ETH_MACCR			MMIO32(ETHERNET_BASE + 0x00)
#define ETH_MACFFR			MMIO32(ETHERNET_BASE + 0x04)
#define ETH_MACHTHR			MMIO32(ETHERNET_BASE + 0x08)
#define ETH_MACHTLR			MMIO32(ETHERNET_BASE + 0x0C)
#define ETH_MACMIIAR			MMIO32(ETHERNET_BASE + 0x10)
#define ETH_MACMIIDR			MMIO32(ETHERNET_BASE + 0x14)
#define ETH_MACFCR			MMIO32(ETHERNET_BASE + 0x18)
#define ETH_MACVLANTR			MMIO32(ETHERNET_BASE + 0x1C)
#define ETH_MACRWUFFR			MMIO32(ETHERNET_BASE + 0x28)
#define ETH_MACPMTCSR			MMIO32(ETHERNET_BASE + 0x2C)
#define ETH_MACSR			MMIO32(ETHERNET_BASE + 0x38)
#define ETH_MACIMR			MMIO32(ETHERNET_BASE + 0x3C)
#define ETH_MACA0HR			MMIO32(ETHERNET_BASE + 0x40)
#define ETH_MACA0LR			MMIO32(ETHERNET_BASE + 0x44)
#define ETH_MACA1HR			MMIO32(ETHERNET_BASE + 0x48)
#define ETH_MACA1LR			MMIO32(ETHERNET_BASE + 0x4C)
#define ETH_MACA2HR			MMIO32(ETHERNET_BASE + 0x50)
#define ETH_MACA2LR			MMIO32(ETHERNET_BASE + 0x54)
#define ETH_MACA3HR			MMIO32(ETHERNET_BASE + 0x58)
#define ETH_MACA3LR			MMIO32(ETHERNET_BASE + 0x5C)

/* Ethernet MMC registers */
#define ETH_MMCCR			MMIO32(ETHERNET_BASE + 0x100)
#define ETH_MMCRIR			MMIO32(ETHERNET_BASE + 0x104)
#define ETH_MMCTIR			MMIO32(ETHERNET_BASE + 0x108)
#define ETH_MMCRIMR			MMIO32(ETHERNET_BASE + 0x10C)
#define ETH_MMCTIMR			MMIO32(ETHERNET_BASE + 0x110)
#define ETH_MMCTGFSCCR			MMIO32(ETHERNET_BASE + 0x14C)
#define ETH_MMCTGFMSCCR			MMIO32(ETHERNET_BASE + 0x150)
#define ETH_MMCTGFCR			MMIO32(ETHERNET_BASE + 0x168)
#define ETH_MMCRFCECR			MMIO32(ETHERNET_BASE + 0x194)
#define ETH_MMCRFAECR			MMIO32(ETHERNET_BASE + 0x198)
#define ETH_MMCRGUFCR			MMIO32(ETHERNET_BASE + 0x1C4)

/* Ethrenet IEEE 1588 time stamp registers */
#define ETH_PTPTSCR			MMIO32(ETHERNET_BASE + 0x700)
#define ETH_PTPSSIR			MMIO32(ETHERNET_BASE + 0x704)
#define ETH_PTPTSHR			MMIO32(ETHERNET_BASE + 0x708)
#define ETH_PTPTSLR			MMIO32(ETHERNET_BASE + 0x70C)
#define ETH_PTPTSHUR			MMIO32(ETHERNET_BASE + 0x710)
#define ETH_PTPTSLUR			MMIO32(ETHERNET_BASE + 0x714)
#define ETH_PTPTSAR			MMIO32(ETHERNET_BASE + 0x718)
#define ETH_PTPTTHR			MMIO32(ETHERNET_BASE + 0x71C)
#define ETH_PTPTTLR			MMIO32(ETHERNET_BASE + 0x720)

/* Ethernet DMA registers */
#define ETH_DMABMR			MMIO32(ETHERNET_BASE + 0x1000)
#define ETH_DMATPDR			MMIO32(ETHERNET_BASE + 0x1004)
#define ETH_DMARPDR			MMIO32(ETHERNET_BASE + 0x1008)
#define ETH_DMARDLAR			MMIO32(ETHERNET_BASE + 0x100C)
#define ETH_DMATDLAR			MMIO32(ETHERNET_BASE + 0x1010)
#define ETH_DMATDLAR			MMIO32(ETHERNET_BASE + 0x1010)
#define ETH_DMASR			MMIO32(ETHERNET_BASE + 0x1014)
#define ETH_DMAOMR			MMIO32(ETHERNET_BASE + 0x1018)
#define ETH_DMAIER			MMIO32(ETHERNET_BASE + 0x101C)
#define ETH_DMAMFBOCR			MMIO32(ETHERNET_BASE + 0x1020)
#define ETH_DMACHTDR			MMIO32(ETHERNET_BASE + 0x1048)
#define ETH_DMACHRDR			MMIO32(ETHERNET_BASE + 0x104C)
#define ETH_DMACHTBAR			MMIO32(ETHERNET_BASE + 0x1050)
#define ETH_DMACHRBAR			MMIO32(ETHERNET_BASE + 0x1054)

/* Ethernet MAC Register bit definitions */
/* Ethernet MAC configuration register ETH_MACCR bits */
#define ETH_MACCR_RE			0x00000004
#define ETH_MACCR_TE			0x00000008
#define ETH_MACCR_DC			0x00000010
#define ETH_MACCR_BL			0x00000060
#define ETH_MACCR_APCS			0x00000080
#define ETH_MACCR_RD			0x00000200
#define ETH_MACCR_IPCO			0x00000400
#define ETH_MACCR_DM			0x00000800
#define ETH_MACCR_LM			0x00001000
#define ETH_MACCR_ROD			0x00002000
#define ETH_MACCR_FES			0x00004000
#define ETH_MACCR_CSD			0x00010000
#define ETH_MACCR_IFG			0x000E0000
#define ETH_MACCR_JD			0x00400000
#define ETH_MACCR_WD			0x00800000

/* Ethernet MAC frame filter register ETH_MACFFR bits */
#define ETH_MACFFR_PM			0x00000001
#define ETH_MACFFR_HU			0x00000002
#define ETH_MACFFR_HM			0x00000004
#define ETH_MACFFR_DAIF			0x00000008
#define ETH_MACFFR_PAM			0x00000010
#define ETH_MACFFR_BFD			0x00000020
#define ETH_MACFFR_PCF			0x000000C0
#define ETH_MACFFR_SAIF			0x00000100
#define ETH_MACFFR_SAF			0x00000200
#define ETH_MACFFR_HPF			0x00000400
#define ETH_MACFFR_PA			0x80000000

/* Ethernet MAC MII address register ETH_MACMIIAR bits */
#define ETH_MACMIIAR_MB			0x0001
#define ETH_MACMIIAR_MW			0x0002
/* Clock Range for MDC frequency */
#define ETH_MACMIIAR_CR_MASK		0x001C
#define ETH_MACMIIAR_CR_HCLK_DIV_42	0x0000 /* For HCLK 60-72 MHz */
#define ETH_MACMIIAR_CR_HCLK_DIV_16	0x0008 /* For HCLK 20-35 MHz */
#define ETH_MACMIIAR_CR_HCLK_DIV_24	0x000C /* For HCLK 35-60 MHz */
#define ETH_MACMIIAR_MR			0x07C0
#define ETH_MACMIIAR_PA			0xF800

/* Ethernet MAC flow control register ETH_MACFCR bits */
#define ETH_MACFCR_FCB			0x00000001
#define ETH_MACFCR_BPA			0x00000001
#define ETH_MACFCR_TFCE			0x00000002
#define ETH_MACFCR_RFCE			0x00000004
#define ETH_MACFCR_UPFD			0x00000008
#define ETH_MACFCR_PLT			0x00000030
#define ETH_MACFCR_ZQPD			0x00000080
#define ETH_MACFCR_PT			0xFFFF0000

/* Ethernet MAC interrupt status register ETH_MACSR bits */
#define ETH_MACSR_PMTS			0x0008
#define ETH_MACSR_MMCS			0x0010
#define ETH_MACSR_MMCRS			0x0020
#define ETH_MACSR_MMCTS			0x0040
#define ETH_MACSR_TSTS			0x0200

/* Ethernet MAC interrupt mask register ETH_MACIMR bits */
#define ETH_MACIMR_PMTIM		0x0008
#define ETH_MACIMR_TSTIM		0x0200

/* Ethernet DMA Register bit definitions */
/* Ethernet DMA bus mode register ETH_DMABMR bits */
#define ETH_DMABMR_SR			0x00000001
#define ETH_DMABMR_DA			0x00000002
#define ETH_DMABMR_DSL_MASK		0x0000007C
#define ETH_DMABMR_PBL_MASK		0x00003F00
#define ETH_DMABMR_RTPR_MASK		0x0000C000
#define ETH_DMABMR_RTPR_1TO1		0x00000000
#define ETH_DMABMR_RTPR_2TO1		0x00004000
#define ETH_DMABMR_RTPR_3TO1		0x00008000
#define ETH_DMABMR_RTPR_4TO1		0x0000C000
#define ETH_DMABMR_FB			0x00010000
#define ETH_DMABMR_RDP_MASK		0x007E0000
#define ETH_DMABMR_USP			0x00800000
#define ETH_DMABMR_FPM			0x01000000
#define ETH_DMABMR_AAB			0x02000000

/* Ethernet DMA operation mode register ETH_DMAOMR bits */
#define ETH_DMAOMR_SR			0x00000002
#define ETH_DMAOMR_OSF			0x00000004
#define ETH_DMAOMR_RTC_MASK		0x00000018
#define ETH_DMAOMR_RTC_64		0x00000000
#define ETH_DMAOMR_RTC_32		0x00000008
#define ETH_DMAOMR_RTC_96		0x00000010
#define ETH_DMAOMR_RTC_128		0x00000018
#define ETH_DMAOMR_FUGF			0x00000040
#define ETH_DMAOMR_FEF			0x00000080
#define ETH_DMAOMR_ST			0x00002000
#define ETH_DMAOMR_TTC_MASK		0x0001C000
#define ETH_DMAOMR_FTF			0x00100000
#define ETH_DMAOMR_TSF			0x00200000
#define ETH_DMAOMR_DFRF			0x01000000
#define ETH_DMAOMR_RSF			0x02000000
#define ETH_DMAOMR_DTCEFD		0x04000000

/* Ethernet DMA interrupt enable register ETH_DMAIER bits */
#define ETH_DMAIER_TIE			0x00000001
#define ETH_DMAIER_TPSIE		0x00000002
#define ETH_DMAIER_TBUIE		0x00000004
#define ETH_DMAIER_TJTIE		0x00000008
#define ETH_DMAIER_ROIE			0x00000010
#define ETH_DMAIER_TUIE			0x00000020
#define ETH_DMAIER_RIE			0x00000040
#define ETH_DMAIER_RBUIE		0x00000080
#define ETH_DMAIER_RPSIE		0x00000100
#define ETH_DMAIER_RWTIE		0x00000200
#define ETH_DMAIER_ETIE			0x00000400
#define ETH_DMAIER_FBEIE		0x00002000
#define ETH_DMAIER_ERIE			0x00004000
#define ETH_DMAIER_AISE			0x00008000
#define ETH_DMAIER_NSIE			0x00010000

BEGIN_DECLS

void eth_smi_write(uint8_t phy, uint8_t reg, uint16_t data);
uint16_t eth_smi_read(uint8_t phy, uint8_t reg);

END_DECLS

#endif
