package de.intarsys.tools.functor;

import java.util.ArrayList;
import java.util.List;


public class StandardFunctorOutlet implements IFunctorOutlet {

	private List<IFunctorFactory> factories = new ArrayList<IFunctorFactory>();

	public List<IFunctorFactory> getFunctorFactories() {
		return new ArrayList<IFunctorFactory>(factories);
	}

	public IFunctorFactory lookupFunctorFactory(String id) {
		if (id == null) {
			return null;
		}
		for (IFunctorFactory factory : factories) {
			if (factory.getId().equals(id)) {
				return factory;
			}
		}
		return null;
	}

	public void registerFunctorFactory(IFunctorFactory factory) {
		factories.add(factory);
	}

	public void unregisterFunctorFactory(IFunctorFactory factory) {
		factories.remove(factory);
	}

}
