# automatically generated file, don't edit



# Copyright 2023 David Cantrell, derived from data from libphonenumber
# http://code.google.com/p/libphonenumber/
#
# Licensed under the Apache License, Version 2.0 (the "License");
# you may not use this file except in compliance with the License.
# You may obtain a copy of the License at
#
#     http://www.apache.org/licenses/LICENSE-2.0
#
# Unless required by applicable law or agreed to in writing, software
# distributed under the License is distributed on an "AS IS" BASIS,
# WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
# See the License for the specific language governing permissions and
# limitations under the License.
package Number::Phone::StubCountry::CN;
use base qw(Number::Phone::StubCountry);

use strict;
use warnings;
use utf8;
our $VERSION = 1.20230307181418;

my $formatters = [
                {
                  'format' => '$1',
                  'intl_format' => 'NA',
                  'leading_digits' => '
            10|
            96
          ',
                  'pattern' => '(\\d{5,6})'
                },
                {
                  'format' => '$1 $2',
                  'leading_digits' => '
            10(?:
              10|
              9[56]
            )|
            2[0-57-9](?:
              100|
              9[56]
            )
          ',
                  'national_rule' => '0$1',
                  'pattern' => '(\\d{2})(\\d{5,6})'
                },
                {
                  'format' => '$1 $2',
                  'intl_format' => 'NA',
                  'leading_digits' => '
            1(?:
              0(?:
                [0-8]|
                9[0-47-9]
              )|
              [1-9]
            )|
            2(?:
              [0-57-9](?:
                [02-8]|
                1(?:
                  0[1-9]|
                  [1-9]
                )|
                9[0-47-9]
              )|
              6
            )|
            [3-9]
          ',
                  'pattern' => '(\\d{3})(\\d{4})'
                },
                {
                  'format' => '$1 $2',
                  'intl_format' => 'NA',
                  'leading_digits' => '16[08]',
                  'pattern' => '(\\d{4})(\\d{4})'
                },
                {
                  'format' => '$1 $2',
                  'leading_digits' => '
            85[23](?:
              100|
              95
            )|
            (?:
              3(?:
                [157]\\d|
                35|
                49|
                9[1-68]
              )|
              4(?:
                [17]\\d|
                2[179]|
                [35][1-9]|
                6[47-9]|
                8[23]
              )|
              5(?:
                [1357]\\d|
                2[37]|
                4[36]|
                6[1-46]|
                80|
                9[1-9]
              )|
              6(?:
                3[1-5]|
                6[0238]|
                9[12]
              )|
              7(?:
                01|
                [1579]\\d|
                2[248]|
                3[014-9]|
                4[3-6]|
                6[023689]
              )|
              8(?:
                1[236-8]|
                2[5-7]|
                [37]\\d|
                5[14-9]|
                8[36-8]|
                9[1-8]
              )|
              9(?:
                0[1-3689]|
                1[1-79]|
                [379]\\d|
                4[13]|
                5[1-5]
              )
            )(?:
              100|
              9[56]
            )
          ',
                  'national_rule' => '0$1',
                  'pattern' => '(\\d{3})(\\d{5,6})'
                },
                {
                  'format' => '$1 $2',
                  'intl_format' => 'NA',
                  'leading_digits' => '
            1(?:
              0[02-8]|
              [1-9]
            )|
            2(?:
              [0-57-9][0-8]|
              6
            )|
            3(?:
              [0268]|
              3[0-46-9]|
              4[0-8]|
              9[079]
            )|
            4(?:
              [049]|
              2[02-68]|
              [35]0|
              6[0-356]|
              8[014-9]
            )|
            5(?:
              0|
              2[0-24-689]|
              4[0-2457-9]|
              6[057-9]|
              90
            )|
            6(?:
              [0-24578]|
              3[06-9]|
              6[14-79]|
              9[03-9]
            )|
            7(?:
              0[02-9]|
              2[0135-79]|
              3[23]|
              4[0-27-9]|
              6[1457]|
              8
            )|
            8(?:
              [046]|
              1[01459]|
              2[0-489]|
              5(?:
                0|
                [23](?:
                  [02-8]|
                  1[1-9]|
                  9[0-46-9]
                )
              )|
              8[0-2459]|
              9[09]
            )|
            9(?:
              0[0457]|
              1[08]|
              [268]|
              4[024-9]|
              5[06-9]
            )|
            (?:
              10|
              2[0-57-9]
            )9[0-47-9]|
            (?:
              101|
              58|
              85[23]10
            )[1-9]|
            (?:
              3(?:
                [157]\\d|
                35|
                49|
                9[1-68]
              )|
              4(?:
                [17]\\d|
                2[179]|
                [35][1-9]|
                6[47-9]|
                8[23]
              )|
              5(?:
                [1357]\\d|
                2[37]|
                4[36]|
                6[1-46]|
                80|
                9[1-9]
              )|
              6(?:
                3[1-5]|
                6[0238]|
                9[12]
              )|
              7(?:
                01|
                [1579]\\d|
                2[248]|
                3[014-9]|
                4[3-6]|
                6[023689]
              )|
              8(?:
                1[236-8]|
                2[5-7]|
                [37]\\d|
                5[14-9]|
                8[36-8]|
                9[1-8]
              )|
              9(?:
                0[1-3689]|
                1[1-79]|
                [379]\\d|
                4[13]|
                5[1-5]
              )
            )(?:
              [02-8]|
              1(?:
                0[1-9]|
                [1-9]
              )|
              9[0-47-9]
            )
          ',
                  'pattern' => '(\\d{4})(\\d{4})'
                },
                {
                  'format' => '$1 $2 $3',
                  'leading_digits' => '
            (?:
              4|
              80
            )0
          ',
                  'pattern' => '(\\d{3})(\\d{3})(\\d{4})'
                },
                {
                  'format' => '$1 $2 $3',
                  'leading_digits' => '
            10[0-79]|
            2(?:
              [02-57-9]|
              1[1-79]
            )|
            (?:
              10|
              21
            )8(?:
              0[1-9]|
              [1-9]
            )
          ',
                  'national_rule' => '0$1',
                  'pattern' => '(\\d{2})(\\d{4})(\\d{4})'
                },
                {
                  'format' => '$1 $2 $3',
                  'leading_digits' => '
            3(?:
              [3-59]|
              7[02-68]
            )|
            4(?:
              [26-8]|
              3[3-9]|
              5[2-9]
            )|
            5(?:
              3[03-9]|
              [468]|
              7[028]|
              9[2-46-9]
            )|
            6|
            7(?:
              [0-247]|
              3[04-9]|
              5[0-4689]|
              6[2368]
            )|
            8(?:
              [1-358]|
              9[1-7]
            )|
            9(?:
              [013479]|
              5[1-5]
            )|
            (?:
              [34]1|
              55|
              79|
              87
            )[02-9]
          ',
                  'national_rule' => '0$1',
                  'pattern' => '(\\d{3})(\\d{3})(\\d{4})'
                },
                {
                  'format' => '$1 $2',
                  'leading_digits' => '9',
                  'pattern' => '(\\d{3})(\\d{7,8})'
                },
                {
                  'format' => '$1 $2 $3',
                  'leading_digits' => '80',
                  'national_rule' => '0$1',
                  'pattern' => '(\\d{4})(\\d{3})(\\d{4})'
                },
                {
                  'format' => '$1 $2 $3',
                  'leading_digits' => '[3-578]',
                  'national_rule' => '0$1',
                  'pattern' => '(\\d{3})(\\d{4})(\\d{4})'
                },
                {
                  'format' => '$1 $2 $3',
                  'leading_digits' => '1[3-9]',
                  'pattern' => '(\\d{3})(\\d{4})(\\d{4})'
                },
                {
                  'format' => '$1 $2 $3 $4',
                  'leading_digits' => '[12]',
                  'national_rule' => '0$1',
                  'pattern' => '(\\d{2})(\\d{3})(\\d{3})(\\d{4})'
                }
              ];

my $validators = {
                'fixed_line' => '
          (?:
            10(?:
              [02-79]\\d\\d|
              [18](?:
                0[1-9]|
                [1-9]\\d
              )
            )|
            21(?:
              [18](?:
                0[1-9]|
                [1-9]\\d
              )|
              [2-79]\\d\\d
            )
          )\\d{5}|
          (?:
            43[35]|
            754
          )\\d{7,8}|
          8(?:
            078\\d{7}|
            51\\d{7,8}
          )|
          (?:
            10|
            (?:
              2|
              85
            )1|
            43[35]|
            754
          )(?:
            100\\d\\d|
            95\\d{3,4}
          )|
          (?:
            2[02-57-9]|
            3(?:
              11|
              7[179]
            )|
            4(?:
              [15]1|
              3[12]
            )|
            5(?:
              1\\d|
              2[37]|
              3[12]|
              51|
              7[13-79]|
              9[15]
            )|
            7(?:
              [39]1|
              5[57]|
              6[09]
            )|
            8(?:
              71|
              98
            )
          )(?:
            [02-8]\\d{7}|
            1(?:
              0(?:
                0\\d\\d(?:
                  \\d{3}
                )?|
                [1-9]\\d{5}
              )|
              [1-9]\\d{6}
            )|
            9(?:
              [0-46-9]\\d{6}|
              5\\d{3}(?:
                \\d(?:
                  \\d{2}
                )?
              )?
            )
          )|
          (?:
            3(?:
              1[02-9]|
              35|
              49|
              5\\d|
              7[02-68]|
              9[1-68]
            )|
            4(?:
              1[02-9]|
              2[179]|
              3[46-9]|
              5[2-9]|
              6[47-9]|
              7\\d|
              8[23]
            )|
            5(?:
              3[03-9]|
              4[36]|
              5[02-9]|
              6[1-46]|
              7[028]|
              80|
              9[2-46-9]
            )|
            6(?:
              3[1-5]|
              6[0238]|
              9[12]
            )|
            7(?:
              01|
              [17]\\d|
              2[248]|
              3[04-9]|
              4[3-6]|
              5[0-3689]|
              6[2368]|
              9[02-9]
            )|
            8(?:
              1[236-8]|
              2[5-7]|
              3\\d|
              5[2-9]|
              7[02-9]|
              8[36-8]|
              9[1-7]
            )|
            9(?:
              0[1-3689]|
              1[1-79]|
              [379]\\d|
              4[13]|
              5[1-5]
            )
          )(?:
            [02-8]\\d{6}|
            1(?:
              0(?:
                0\\d\\d(?:
                  \\d{2}
                )?|
                [1-9]\\d{4}
              )|
              [1-9]\\d{5}
            )|
            9(?:
              [0-46-9]\\d{5}|
              5\\d{3,5}
            )
          )
        ',
                'geographic' => '
          (?:
            10(?:
              [02-79]\\d\\d|
              [18](?:
                0[1-9]|
                [1-9]\\d
              )
            )|
            21(?:
              [18](?:
                0[1-9]|
                [1-9]\\d
              )|
              [2-79]\\d\\d
            )
          )\\d{5}|
          (?:
            43[35]|
            754
          )\\d{7,8}|
          8(?:
            078\\d{7}|
            51\\d{7,8}
          )|
          (?:
            10|
            (?:
              2|
              85
            )1|
            43[35]|
            754
          )(?:
            100\\d\\d|
            95\\d{3,4}
          )|
          (?:
            2[02-57-9]|
            3(?:
              11|
              7[179]
            )|
            4(?:
              [15]1|
              3[12]
            )|
            5(?:
              1\\d|
              2[37]|
              3[12]|
              51|
              7[13-79]|
              9[15]
            )|
            7(?:
              [39]1|
              5[57]|
              6[09]
            )|
            8(?:
              71|
              98
            )
          )(?:
            [02-8]\\d{7}|
            1(?:
              0(?:
                0\\d\\d(?:
                  \\d{3}
                )?|
                [1-9]\\d{5}
              )|
              [1-9]\\d{6}
            )|
            9(?:
              [0-46-9]\\d{6}|
              5\\d{3}(?:
                \\d(?:
                  \\d{2}
                )?
              )?
            )
          )|
          (?:
            3(?:
              1[02-9]|
              35|
              49|
              5\\d|
              7[02-68]|
              9[1-68]
            )|
            4(?:
              1[02-9]|
              2[179]|
              3[46-9]|
              5[2-9]|
              6[47-9]|
              7\\d|
              8[23]
            )|
            5(?:
              3[03-9]|
              4[36]|
              5[02-9]|
              6[1-46]|
              7[028]|
              80|
              9[2-46-9]
            )|
            6(?:
              3[1-5]|
              6[0238]|
              9[12]
            )|
            7(?:
              01|
              [17]\\d|
              2[248]|
              3[04-9]|
              4[3-6]|
              5[0-3689]|
              6[2368]|
              9[02-9]
            )|
            8(?:
              1[236-8]|
              2[5-7]|
              3\\d|
              5[2-9]|
              7[02-9]|
              8[36-8]|
              9[1-7]
            )|
            9(?:
              0[1-3689]|
              1[1-79]|
              [379]\\d|
              4[13]|
              5[1-5]
            )
          )(?:
            [02-8]\\d{6}|
            1(?:
              0(?:
                0\\d\\d(?:
                  \\d{2}
                )?|
                [1-9]\\d{4}
              )|
              [1-9]\\d{5}
            )|
            9(?:
              [0-46-9]\\d{5}|
              5\\d{3,5}
            )
          )
        ',
                'mobile' => '
          1740[0-5]\\d{6}|
          1(?:
            [38]\\d|
            4[57]|
            [59][0-35-9]|
            6[25-7]|
            7[0-35-8]
          )\\d{8}
        ',
                'pager' => '',
                'personal_number' => '',
                'specialrate' => '(
          10(?:
            10\\d{4}|
            96\\d{3,4}
          )|
          400\\d{7}|
          950\\d{7,8}|
          (?:
            2[0-57-9]|
            3(?:
              [157]\\d|
              35|
              49|
              9[1-68]
            )|
            4(?:
              [17]\\d|
              2[179]|
              [35][1-9]|
              6[47-9]|
              8[23]
            )|
            5(?:
              [1357]\\d|
              2[37]|
              4[36]|
              6[1-46]|
              80|
              9[1-9]
            )|
            6(?:
              3[1-5]|
              6[0238]|
              9[12]
            )|
            7(?:
              01|
              [1579]\\d|
              2[248]|
              3[014-9]|
              4[3-6]|
              6[023689]
            )|
            8(?:
              1[236-8]|
              2[5-7]|
              [37]\\d|
              5[14-9]|
              8[36-8]|
              9[1-8]
            )|
            9(?:
              0[1-3689]|
              1[1-79]|
              [379]\\d|
              4[13]|
              5[1-5]
            )
          )96\\d{3,4}
        )|(16[08]\\d{5})',
                'toll_free' => '
          (?:
            (?:
              10|
              21
            )8|
            8
          )00\\d{7}
        ',
                'voip' => ''
              };
my %areanames = ();
$areanames{zh} = {"86180643", "陕西省西安市",
"861501502", "广东省江门市",
"861313791", "河南省焦作市",
"861855579", "安徽省淮北市",
"861786666", "山东省聊城市",
"861894751", "内蒙古通辽市",
"861365496", "辽宁省锦州市",
"861313389", "江西省景德镇市",
"861809951", "新疆伊犁哈萨克自治州",
"861351955", "宁夏吴忠市",
"861840326", "河北省廊坊市",
"861528722", "云南省德宏傣族景颇族自治州",
"861817408", "江西省赣州市",
"86188544", "山东省临沂市",
"861810470", "内蒙古呼伦贝尔市",
"861308848", "内蒙古巴彦淖尔市",
"861780778", "广西河池市",
"86147216", "四川省成都市",
"86187537", "山东省济宁市",
"861873998", "河南省开封市",
"861303303", "安徽省芜湖市",
"86183663", "山东省潍坊市",
"861554090", "内蒙古巴彦淖尔市",
"861552191", "广东省揭阳市",
"861840467", "黑龙江省鸡西市",
"861860676", "浙江省台州市",
"86151681", "浙江省宁波市",
"861387281", "湖北省十堰市",
"861476522", "河北省石家庄市",
"86151012", "甘肃省兰州市",
"861588903", "西藏山南地区",
"861803777", "河南省郑州市",
"86134809", "广东省深圳市",
"861871900", "广东省肇庆市",
"861562877", "山东省济南市",
"861346964", "宁夏固原市",
"861316359", "黑龙江省绥化市",
"86158128", "广东省东莞市",
"861452774", "广西梧州市",
"861881984", "广东省云浮市",
"861889908", "新疆乌鲁木齐市",
"86131323", "重庆市",
"861309350", "安徽省马鞍山市",
"861582576", "浙江省金华市",
"861815898", "安徽省蚌埠市",
"861590907", "新疆阿克苏地区",
"861870634", "山东省莱芜市",
"86156360", "黑龙江省哈尔滨市",
"861523366", "河北省廊坊市",
"861562266", "广东省云浮市",
"861760646", "山东省潍坊市",
"861555107", "安徽省马鞍山市",
"861351337", "河北省石家庄市",
"861561547", "山东省济宁市",
"861372233", "河北省张家口市",
"861816002", "四川省成都市",
"86152613", "江苏省连云港市",
"86178547", "山东省济宁市",
"861523427", "山西省长治市",
"861521968", "广东省江门市",
"861479037", "安徽省合肥市",
"861352583", "河南省安阳市",
"86177534", "山东省德州市",
"861303540", "安徽省合肥市",
"861309315", "江苏省常州市",
"861857859", "广东省汕尾市",
"86158306", "河北省石家庄市",
"86157730", "湖南省岳阳市",
"861333572", "浙江省湖州市",
"861327633", "山东省日照市",
"861865401", "安徽省亳州市",
"861560306", "广东省广州市",
"86185677", "河南省安阳市",
"861801110", "四川省绵阳市",
"861889491", "河北省秦皇岛市",
"861390080", "四川省成都市",
"861770457", "黑龙江省大兴安岭地区",
"861873401", "安徽省安庆市",
"861760514", "江苏省扬州市",
"861328881", "广东省广州市",
"861333893", "江苏省盐城市",
"861528875", "山东省聊城市",
"861809578", "青海省西宁市",
"861364441", "吉林省长春市",
"861556642", "辽宁省鞍山市",
"86156691", "浙江省宁波市",
"861764556", "黑龙江省黑河市",
"861560990", "新疆克拉玛依市",
"861589230", "四川省资阳市",
"861380425", "辽宁省大连市",
"861470550", "安徽省滁州市",
"861535044", "江西省赣州市",
"861819016", "四川省遂宁市",
"861332378", "河南省开封市",
"861853437", "山西省晋中市",
"861359151", "辽宁省丹东市",
"861571238", "辽宁省大连市",
"861341100", "广东省佛山市",
"86137080", "四川省成都市",
"861302734", "湖南省衡阳市",
"86181401", "四川省成都市",
"861353927", "广东省揭阳市",
"861880935", "甘肃省武威市",
"861343198", "广东省清远市",
"861512977", "陕西省宝鸡市",
"861591652", "广东省梅州市",
"861840338", "河北省邯郸市",
"861301166", "山东省潍坊市",
"861521455", "黑龙江省绥化市",
"861534919", "陕西省铜川市",
"86134852", "江苏省盐城市",
"861865998", "福建省南平市",
"861515249", "江苏省泰州市",
"861317906", "吉林省白城市",
"86131895", "广东省茂名市",
"861801403", "江苏省苏州市",
"86187767", "广西南宁市",
"861898692", "湖北省武汉市",
"861814552", "黑龙江省黑河市",
"861538302", "河北省保定市",
"861554520", "黑龙江省齐齐哈尔市",
"861331099", "陕西省榆林市",
"861569325", "甘肃省兰州市",
"861538684", "山西省晋中市",
"861775702", "浙江省衢州市",
"861811489", "江苏省无锡市",
"861709548", "江苏省无锡市",
"861707869", "云南省西双版纳傣族自治州",
"861818187", "四川省泸州市",
"861319060", "内蒙古呼和浩特市",
"861308564", "浙江省嘉兴市",
"861880357", "山西省临汾市",
"861522974", "陕西省安康市",
"861452667", "江西省赣州市",
"861341413", "广东省广州市",
"861301259", "山东省烟台市",
"861831603", "广东省汕尾市",
"86138440", "吉林省长春市",
"861308329", "安徽省池州市",
"861321297", "黑龙江省鹤岗市",
"861530997", "新疆阿克苏地区",
"861596562", "山东省济南市",
"861821861", "广东省肇庆市",
"861502976", "陕西省汉中市",
"861773441", "河北省石家庄市",
"861892470", "广东省珠海市",
"861354549", "湖北省黄石市",
"861809017", "四川省泸州市",
"861389476", "吉林省长春市",
"86137434", "吉林省四平市",
"86159121", "云南省昆明市",
"861328566", "安徽省宿州市",
"861310398", "河南省三门峡市",
"861379346", "山东省德州市",
"86159277", "湖北省荆州市",
"86138447", "吉林省延边朝鲜族自治州",
"861831673", "广东省揭阳市",
"861315220", "陕西省宝鸡市",
"86186330", "河北省石家庄市",
"861376586", "贵州省毕节地区",
"86156428", "辽宁省葫芦岛市",
"861551611", "河南省濮阳市",
"861870989", "安徽省亳州市",
"861569286", "四川省广安市",
"861508340", "河南省南阳市",
"861556113", "内蒙古鄂尔多斯市",
"861356236", "山东省日照市",
"861516084", "新疆吐鲁番地区",
"861550823", "四川省达州市",
"861336874", "云南省曲靖市",
"861866923", "云南省怒江傈僳族自治州",
"861538372", "河北省保定市",
"861334082", "四川省达州市",
"861576466", "黑龙江省大庆市",
"861334756", "广西桂林市",
"861550072", "青海省黄南藏族自治州",
"861564846", "内蒙古赤峰市",
"861317976", "江苏省扬州市",
"861366433", "吉林省长春市",
"861528486", "四川省广元市",
"86187760", "广西南宁市",
"861801473", "江苏省南京市",
"86137087", "云南省昆明市",
"861536863", "云南省西双版纳傣族自治州",
"861332308", "河北省衡水市",
"861581902", "广东省梅州市",
"861584547", "黑龙江省鹤岗市",
"861817249", "广西钦州市",
"861873565", "山西省运城市",
"86157567", "四川省乐山市",
"861323610", "江苏省盐城市",
"861881639", "山东省青岛市",
"861850761", "广东省河源市",
"861571696", "河北省廊坊市",
"861533166", "云南省普洱市",
"86138652", "安徽省合肥市",
"861453333", "浙江省杭州市",
"861889551", "安徽省阜阳市",
"861770597", "福建省龙岩市",
"861510342", "山西省大同市",
"86137671", "江西省南昌市",
"861560376", "河南省信阳市",
"861370790", "江西省新余市",
"861325711", "湖北省孝感市",
"861533259", "陕西省榆林市",
"861809508", "四川省雅安市",
"861556400", "山东省菏泽市",
"861521723", "广东省东莞市",
"86145386", "云南省昆明市",
"861318469", "江西省吉安市",
"861326396", "江西省吉安市",
"861538939", "陕西省汉中市",
"861322728", "湖北省宜昌市",
"861381441", "江苏省徐州市",
"861459687", "新疆石河子市",
"861380055", "安徽省滁州市",
"86178540", "山东省菏泽市",
"861502842", "河北省保定市",
"861838602", "贵州省铜仁地区",
"861869625", "湖北省鄂州市",
"861342661", "江西省九江市",
"861865471", "山东省潍坊市",
"861532870", "四川省内江市",
"861598392", "四川省广元市",
"86158744", "湖南省张家界市",
"861882183", "湖南省衡阳市",
"861515408", "山东省枣庄市",
"861345838", "四川省资阳市",
"861330268", "广东省汕尾市",
"86157737", "湖南省益阳市",
"86138609", "福建省莆田市",
"861590977", "青海省海西蒙古族藏族自治州",
"861816823", "江苏省徐州市",
"861832490", "安徽省宿州市",
"861814884", "广东省云浮市",
"861322178", "浙江省丽水市",
"861816072", "江西省九江市",
"861340189", "江苏省宿迁市",
"861535216", "甘肃省张掖市",
"861317842", "广东省韶关市",
"86151994", "新疆乌鲁木齐市",
"861361245", "广东省潮州市",
"861459071", "广东省河源市",
"86156367", "黑龙江省鹤岗市",
"861360691", "福建省厦门市",
"861335133", "黑龙江省牡丹江市",
"861555177", "安徽省马鞍山市",
"861866046", "山东省济南市",
"86153279", "湖北省十堰市",
"861564972", "河南省濮阳市",
"861872414", "江苏省徐州市",
"861860606", "福建省福州市",
"86182036", "河南省郑州市",
"861393803", "河南省漯河市",
"861839049", "湖南省郴州市",
"861367267", "广东省珠海市",
"861857107", "湖北省黄石市",
"861889978", "广东省潮州市",
"861562807", "贵州省毕节地区",
"861365556", "安徽省安庆市",
"86134204", "广东省中山市",
"861321627", "浙江省衢州市",
"86178789", "广西北海市",
"861700751", "广东省惠州市",
"861877131", "湖北省咸宁市",
"861824887", "江苏省镇江市",
"861880066", "江苏省淮安市",
"861855509", "安徽省黄山市",
"861329983", "青海省海东地区",
"86136140", "辽宁省沈阳市",
"86187530", "山东省菏泽市",
"861787770", "湖南省岳阳市",
"861829247", "陕西省宝鸡市",
"861531540", "山东省菏泽市",
"861356228", "山东省东营市",
"861817478", "广西柳州市",
"861810400", "辽宁省沈阳市",
"861800535", "山东省烟台市",
"861350659", "浙江省金华市",
"861567401", "湖南省岳阳市",
"86135340", "广东省深圳市",
"861554929", "湖北省宜昌市",
"86187341", "山西省太原市",
"861379987", "福建省泉州市",
"861700192", "广东省深圳市",
"861874269", "新疆博尔塔拉蒙古自治州",
"861528765", "云南省丽江市",
"861321796", "江西省吉安市",
"861880574", "浙江省宁波市",
"86132577", "广西南宁市",
"861576785", "广东省广州市",
"86145370", "湖北省武汉市",
"861572636", "山东省潍坊市",
"861882699", "广东省东莞市",
"861534510", "江苏省无锡市",
"861593667", "河南省安阳市",
"86152661", "山东省威海市",
"861536703", "湖南省岳阳市",
"861857238", "湖北省宜昌市",
"861583520", "山西省大同市",
"861476565", "海南省海口市",
"861534555", "安徽省马鞍山市",
"861300019", "天津市",
"861325890", "山东省滨州市",
"86132512", "重庆市",
"861370811", "四川省绵阳市",
"861368388", "河南省驻马店市",
"861550551", "安徽省合肥市",
"861327113", "河南省信阳市",
"861816978", "广西北海市",
"861565053", "山东省济宁市",
"861511361", "广东省湛江市",
"861452548", "山东省泰安市",
"861557685", "湖南省张家界市",
"861805234", "江苏省连云港市",
"86150593", "福建省宁德市",
"861350896", "山东省潍坊市",
"86158694", "浙江省温州市",
"86131736", "浙江省杭州市",
"86155167", "河南省周口市",
"861709667", "浙江省杭州市",
"861804686", "江西省赣州市",
"861880483", "内蒙古阿拉善盟",
"861591271", "云南省保山市",
"861780544", "山东省德州市",
"86183082", "四川省凉山彝族自治州",
"861320478", "内蒙古巴彦淖尔市",
"861539780", "江西省南昌市",
"861391285", "江苏省南通市",
"8618222", "天津市",
"86183611", "江苏省盐城市",
"861314538", "山东省泰安市",
"86139727", "湖北省黄冈市",
"861562674", "广东省茂名市",
"861317833", "福建省南平市",
"861533794", "甘肃省兰州市",
"861705527", "湖北省武汉市",
"861335142", "黑龙江省齐齐哈尔市",
"861333917", "安徽省亳州市",
"861340352", "山西省大同市",
"861560599", "福建省南平市",
"861303621", "江西省南昌市",
"861364250", "广东省梅州市",
"861834486", "江苏省盐城市",
"86155406", "内蒙古赤峰市",
"861580582", "浙江省湖州市",
"861826293", "江苏省宿迁市",
"861804395", "吉林省白山市",
"861559066", "吉林省长春市",
"861555385", "山东省东营市",
"861528063", "福建省漳州市",
"861318681", "浙江省温州市",
"861571727", "湖北省襄樊市",
"861829068", "新疆昌吉回族自治州",
"86131566", "安徽省池州市",
"861380462", "黑龙江省哈尔滨市",
"861768394", "湖北省十堰市",
"861832959", "陕西省铜川市",
"861344956", "山东省德州市",
"861538887", "云南省红河哈尼族彝族自治州",
"861820976", "青海省玉树藏族自治州",
"861318077", "吉林省松原市",
"861847502", "广东省云浮市",
"861846921", "云南省怒江傈僳族自治州",
"861831321", "云南省西双版纳傣族自治州",
"861510333", "河北省张家口市",
"861700895", "广东省惠州市",
"86147791", "江西省南昌市",
"861516801", "浙江省丽水市",
"861800904", "四川省凉山彝族自治州",
"861557900", "江西省新余市",
"861550978", "青海省西宁市",
"861452864", "青海省海南藏族自治州",
"861314526", "内蒙古包头市",
"861346431", "辽宁省锦州市",
"861478395", "河南省漯河市",
"861588349", "四川省凉山彝族自治州",
"861459552", "青海省海东地区",
"861824939", "黑龙江省七台河市",
"861530645", "山东省烟台市",
"861803276", "河北省石家庄市",
"861589084", "河南省驻马店市",
"86145901", "广东省深圳市",
"86151205", "甘肃省临夏回族自治州",
"861572628", "山东省滨州市",
"861366670", "浙江省舟山市",
"861782058", "广东省深圳市",
"861335845", "福建省南平市",
"861324429", "吉林省松原市",
"861315041", "新疆喀什地区",
"861855970", "福建省龙岩市",
"861458965", "广东省汕尾市",
"861569362", "甘肃省白银市",
"861859657", "福建省厦门市",
"861809744", "青海省西宁市",
"861561668", "湖南省衡阳市",
"86186541", "安徽省合肥市",
"861351519", "江苏省无锡市",
"861390234", "广东省韶关市",
"861867423", "湖北省孝感市",
"861527228", "湖北省十堰市",
"861571859", "贵州省黔西南布依族苗族自治州",
"861337731", "广西桂林市",
"86159988", "辽宁省沈阳市",
"861862682", "浙江省温州市",
"861890720", "湖北省宜昌市",
"861366442", "吉林省吉林市",
"861568537", "贵州省安顺市",
"861367933", "甘肃省平凉市",
"86137131", "广东省东莞市",
"86130705", "河北省保定市",
"861894944", "安徽省安庆市",
"86159424", "辽宁省大连市",
"861308006", "吉林省白城市",
"861329435", "吉林省通化市",
"861568880", "山东省德州市",
"861778930", "甘肃省临夏回族自治州",
"861596525", "山东省聊城市",
"86158553", "安徽省宿州市",
"861352397", "河南省信阳市",
"861772879", "广东省阳江市",
"86182474", "内蒙古兴安盟",
"861813866", "广东省江门市",
"861858743", "广西贺州市",
"86150938", "河南省平顶山市",
"861340223", "山东省菏泽市",
"861829746", "安徽省六安市",
"861775165", "江苏省苏州市",
"861388431", "浙江省舟山市",
"86180266", "广东省惠州市",
"861700944", "江苏省徐州市",
"861897178", "湖北省黄石市",
"861533838", "广东省东莞市",
"861509239", "山东省临沂市",
"861337313", "河北省张家口市",
"861855900", "福建省三明市",
"861862374", "河南省安阳市",
"86152397", "河南省焦作市",
"861843260", "河北省邯郸市",
"861582781", "湖北省鄂州市",
"861847572", "广东省中山市",
"861820906", "新疆阿勒泰地区",
"861535717", "安徽省六安市",
"861360040", "广东省深圳市",
"861893367", "广东省汕头市",
"861478140", "四川省达州市",
"861769918", "新疆喀什地区",
"861335994", "黑龙江省黑河市",
"861363468", "黑龙江省鹤岗市",
"861566558", "安徽省阜阳市",
"861550908", "新疆克孜勒苏柯尔克孜自治州",
"861536075", "广东省茂名市",
"861800974", "青海省海南藏族自治州",
"861313810", "广东省珠海市",
"861336081", "广东省汕头市",
"861361927", "陕西省宝鸡市",
"86150027", "湖北省武汉市",
"861893426", "广东省茂名市",
"861802041", "江苏省常州市",
"861804140", "辽宁省本溪市",
"86156741", "湖南省株洲市",
"861556633", "辽宁省营口市",
"861820390", "河南省焦作市",
"86182631", "山东省威海市",
"86135713", "陕西省渭南市",
"861313855", "广东省汕头市",
"861771549", "江苏省淮安市",
"861890413", "辽宁省抚顺市",
"86996", "新疆巴音郭楞蒙古自治州",
"861361411", "辽宁省大连市",
"861333051", "云南省昆明市",
"861894895", "广东省江门市",
"861518605", "贵州省毕节地区",
"861828919", "西藏拉萨市",
"861837198", "湖北省武汉市",
"8615927", "湖北省武汉市",
"861518980", "江苏省南京市",
"861327470", "内蒙古呼伦贝尔市",
"861830345", "山西省长治市",
"861320408", "辽宁省大连市",
"861372242", "河北省保定市",
"861559357", "甘肃省金昌市",
"861570416", "辽宁省锦州市",
"861377637", "江苏省镇江市",
"861824684", "黑龙江省大庆市",
"861336764", "广西梧州市",
"861821121", "广东省潮州市",
"861590512", "江苏省连云港市",
"861458598", "山东省临沂市",
"861398169", "四川省巴中市",
"861560459", "黑龙江省大庆市",
"861311759", "湖南省邵阳市",
"861861368", "山东省济宁市",
"861826623", "山东省青岛市",
"861327642", "山东省青岛市",
"861375468", "山东省滨州市",
"86155160", "河南省平顶山市",
"861471610", "广东省珠海市",
"861363337", "河北省沧州市",
"861569787", "江西省赣州市",
"861500982", "辽宁省锦州市",
"86158981", "辽宁省大连市",
"861350724", "湖北省宜昌市",
"861504695", "黑龙江省黑河市",
"861536773", "湖南省益阳市",
"86180793", "江西省上饶市",
"861527698", "新疆塔城地区",
"861816908", "宁夏银川市",
"861850871", "云南省昆明市",
"86130742", "广东省佛山市",
"861311827", "四川省南充市",
"861363910", "贵州省贵阳市",
"861305413", "湖南省株洲市",
"861818375", "云南省保山市",
"861450424", "辽宁省本溪市",
"86145312", "浙江省杭州市",
"861812170", "江苏省泰州市",
"861453890", "云南省大理白族自治州",
"861334257", "湖南省益阳市",
"861810633", "山东省日照市",
"861822088", "陕西省铜川市",
"86135347", "广东省江门市",
"861536123", "广东省揭阳市",
"861550491", "辽宁省朝阳市",
"861530813", "四川省乐山市",
"861572298", "江苏省无锡市",
"861319412", "辽宁省鞍山市",
"861814687", "陕西省西安市",
"861347464", "陕西省西安市",
"861552086", "四川省南充市",
"861870580", "浙江省舟山市",
"861304097", "湖北省宜昌市",
"86145377", "广西南宁市",
"861880504", "福建省莆田市",
"861533826", "广东省中山市",
"861363955", "宁夏吴忠市",
"861580854", "贵州省黔南布依族苗族自治州",
"861856711", "河南省漯河市",
"861584668", "黑龙江省绥化市",
"861596095", "福建省三明市",
"861347657", "湖北省黄冈市",
"861508562", "贵州省遵义市",
"861358991", "山东省德州市",
"861874056", "陕西省汉中市",
"861874782", "内蒙古巴彦淖尔市",
"861304264", "辽宁省抚顺市",
"86132502", "广东省广州市",
"861812000", "江苏省无锡市",
"86187905", "河南省新乡市",
"861475146", "江苏省无锡市",
"861843841", "河南省焦作市",
"861551315", "山西省忻州市",
"861852573", "辽宁省葫芦岛市",
"861322972", "广东省云浮市",
"861532511", "浙江省舟山市",
"861820743", "湖南省湘西土家族苗族自治州",
"861308482", "陕西省榆林市",
"86134422", "广东省广州市",
"861338304", "河北省石家庄市",
"861475975", "福建省厦门市",
"861585587", "安徽省亳州市",
"861535098", "辽宁省阜新市",
"861551350", "山西省忻州市",
"861350004", "广东省深圳市",
"861853049", "河南省商丘市",
"861362251", "广东省佛山市",
"861323351", "山西省太原市",
"861335042", "四川省雅安市",
"861889722", "青海省海东地区",
"861867561", "广东省珠海市",
"861899416", "江苏省南通市",
"861510560", "安徽省合肥市",
"861594710", "内蒙古呼伦贝尔市",
"861305070", "辽宁省阜新市",
"861360686", "浙江省台州市",
"861887271", "湖北省黄冈市",
"86183601", "江苏省宿迁市",
"861863832", "河南省新乡市",
"861865944", "福建省龙岩市",
"861528908", "西藏拉萨市",
"861310480", "广东省云浮市",
"861326381", "广西南宁市",
"861329541", "山东省济南市",
"861504273", "辽宁省营口市",
"86137538", "山西省吕梁市",
"861319820", "四川省自贡市",
"861829903", "新疆喀什地区",
"861768169", "浙江省湖州市",
"861317732", "湖北省黄石市",
"86185795", "湖南省永州市",
"861326799", "广东省珠海市",
"861879512", "宁夏石嘴山市",
"861761467", "黑龙江省鸡西市",
"861772911", "陕西省延安市",
"861594755", "内蒙古赤峰市",
"861314196", "湖南省邵阳市",
"861565153", "江苏省宿迁市",
"861382455", "广东省梅州市",
"86136338", "河南省郑州市",
"861876506", "山东省烟台市",
"86132228", "江苏省无锡市",
"861367148", "广东省湛江市",
"861576856", "广东省深圳市",
"861360395", "河南省漯河市",
"861571077", "广东省深圳市",
"861308894", "陕西省宝鸡市",
"861707599", "福建省莆田市",
"861325969", "宁夏中卫市",
"861304718", "湖北省荆门市",
"861560779", "广西北海市",
"861311479", "广西北海市",
"861573153", "四川省成都市",
"861322846", "四川省达州市",
"861327715", "湖北省咸宁市",
"861533574", "湖北省孝感市",
"861318177", "山东省泰安市",
"861895119", "江苏省宿迁市",
"861830520", "江苏省徐州市",
"86137768", "江苏省常州市",
"861579413", "浙江省宁波市",
"861869321", "甘肃省定西市",
"861821451", "云南省临沧市",
"861844708", "内蒙古通辽市",
"86157324", "河北省承德市",
"861571681", "河北省邯郸市",
"86159153", "广东省深圳市",
"861393862", "河南省开封市",
"861318727", "湖南省郴州市",
"861850919", "陕西省铜川市",
"861878418", "四川省广安市",
"861364904", "四川省泸州市",
"861313422", "辽宁省沈阳市",
"86130715", "广东省汕尾市",
"861569291", "四川省自贡市",
"861580931", "甘肃省兰州市",
"861318859", "辽宁省盘锦市",
"861334359", "湖北省十堰市",
"861535528", "浙江省台州市",
"861330147", "江苏省南通市",
"86135375", "广东省深圳市",
"861813932", "新疆哈密地区",
"861533483", "内蒙古阿拉善盟",
"861815844", "浙江省杭州市",
"86151831", "四川省宜宾市",
"861302995", "黑龙江省牡丹江市",
"861586414", "山东省济宁市",
"861306348", "安徽省合肥市",
"861869430", "甘肃省白银市",
"861583190", "河北省邢台市",
"861315141", "江苏省南京市",
"86158382", "河南省郑州市",
"861301504", "内蒙古包头市",
"861309588", "浙江省金华市",
"861503683", "河南省周口市",
"86170796", "浙江省台州市",
"86135678", "浙江省宁波市",
"861333563", "安徽省宣城市",
"861828230", "四川省自贡市",
"861536453", "山西省阳泉市",
"861880794", "江西省抚州市",
"861454116", "安徽省池州市",
"861806222", "湖北省黄冈市",
"861567192", "湖北省十堰市",
"861860527", "江苏省宿迁市",
"861583345", "河北省唐山市",
"861308726", "湖南省邵阳市",
"86189843", "贵州省贵阳市",
"861351858", "贵州省六盘水市",
"861573475", "内蒙古通辽市",
"861308945", "吉林省吉林市",
"861373481", "内蒙古呼和浩特市",
"861598730", "云南省怒江傈僳族自治州",
"861321506", "福建省泉州市",
"861581178", "广东省云浮市",
"861450585", "辽宁省辽阳市",
"86145359", "福建省福州市",
"861597119", "湖北省孝感市",
"861783980", "河南省三门峡市",
"861573561", "山西省太原市",
"861534761", "广东省河源市",
"861786915", "云南省红河哈尼族彝族自治州",
"861569949", "新疆伊犁哈萨克自治州",
"861536593", "江苏省淮安市",
"861308176", "辽宁省辽阳市",
"86592", "福建省厦门市",
"861889805", "西藏昌都地区",
"861579720", "湖北省孝感市",
"861873895", "河南省开封市",
"861564963", "河南省新乡市",
"86137993", "福建省福州市",
"861522441", "山东省青岛市",
"861458778", "湖南省怀化市",
"861536946", "河北省廊坊市",
"861303362", "浙江省温州市",
"861536725", "湖南省郴州市",
"861839437", "甘肃省平凉市",
"861333151", "吉林省延边朝鲜族自治州",
"861837528", "贵州省黔东南苗族侗族自治州",
"861301483", "广西北海市",
"861364974", "青海省海南藏族自治州",
"861309611", "四川省广元市",
"861370979", "青海省海西蒙古族藏族自治州",
"861339927", "陕西省宝鸡市",
"861358478", "江苏省盐城市",
"861804040", "四川省德阳市",
"861802141", "江苏省南京市",
"861453969", "广东省珠海市",
"861302844", "陕西省咸阳市",
"861896640", "浙江省衢州市",
"861536175", "广东省广州市",
"86188448", "吉林省松原市",
"861458128", "安徽省六安市",
"861360140", "江苏省南京市",
"861809637", "四川省成都市",
"861478040", "四川省成都市",
"861339411", "辽宁省大连市",
"861705264", "山东省济南市",
"861328896", "广东省茂名市",
"861359893", "河南省驻马店市",
"861533504", "江苏省宿迁市",
"861880826", "四川省广安市",
"861318107", "山东省聊城市",
"861560709", "江西省新余市",
"861865192", "江苏省镇江市",
"861526305", "山东省青岛市",
"861780922", "陕西省铜川市",
"861310344", "山西省太原市",
"861596573", "山东省济宁市",
"861500531", "山东省济南市",
"861813309", "安徽省阜阳市",
"861831662", "广东省深圳市",
"86170041", "辽宁省沈阳市",
"861840857", "贵州省毕节地区",
"861324877", "浙江省温州市",
"861302568", "广东省茂名市",
"86181861", "湖北省武汉市",
"861837536", "安徽省安庆市",
"86151433", "吉林省延边朝鲜族自治州",
"861829973", "新疆乌鲁木齐市",
"861845010", "福建省漳州市",
"861517568", "河北省廊坊市",
"861880838", "四川省德阳市",
"861332139", "甘肃省陇南市",
"861371980", "广东省云浮市",
"861887587", "浙江省嘉兴市",
"861801462", "江苏省连云港市",
"861538363", "山西省阳泉市",
"861502488", "内蒙古巴彦淖尔市",
"861387296", "湖北省武汉市",
"861536872", "云南省大理白族自治州",
"861320347", "山西省临汾市",
"86156858", "贵州省六盘水市",
"861590243", "辽宁省葫芦岛市",
"861599114", "陕西省安康市",
"861536023", "广东省汕尾市",
"861346545", "山东省烟台市",
"861308738", "湖南省娄底市",
"861534084", "山西省长治市",
"861776614", "江苏省淮安市",
"861380630", "山东省威海市",
"861338374", "河南省许昌市",
"861365481", "内蒙古呼和浩特市",
"86145302", "北京市",
"861812070", "福建省泉州市",
"861705718", "宁夏银川市",
"861313052", "辽宁省丹东市",
"861370332", "河北省保定市",
"861358249", "河北省邢台市",
"861313786", "河南省驻马店市",
"861840729", "湖北省武汉市",
"861473064", "河北省唐山市",
"861396564", "安徽省滁州市",
"86136846", "黑龙江省哈尔滨市",
"861324266", "广东省汕尾市",
"861855254", "江苏省镇江市",
"86155595", "福建省泉州市",
"86132926", "河北省廊坊市",
"861550486", "内蒙古赤峰市",
"861528072", "福建省三明市",
"861829828", "安徽省宣城市",
"861356847", "四川省巴中市",
"861348820", "陕西省安康市",
"86134819", "广西柳州市",
"861779947", "新疆阿克苏地区",
"86151002", "河北省保定市",
"861820488", "内蒙古赤峰市",
"861576229", "山东省青岛市",
"86159854", "贵州省毕节地区",
"861566444", "山东省泰安市",
"861892715", "广东省云浮市",
"861560869", "湖北省荆门市",
"861856969", "湖南省娄底市",
"861322517", "江苏省淮安市",
"86130967", "贵州省遵义市",
"861370343", "河南省新乡市",
"86138475", "内蒙古通辽市",
"861345574", "山东省枣庄市",
"861389756", "青海省玉树藏族自治州",
"861380473", "内蒙古阿拉善盟",
"861350566", "安徽省阜阳市",
"861367094", "广东省佛山市",
"861811365", "四川省眉山市",
"861533935", "甘肃省武威市",
"861534801", "甘肃省兰州市",
"861868378", "四川省成都市",
"861316988", "广东省中山市",
"861580464", "黑龙江省七台河市",
"861336526", "江苏省连云港市",
"86158316", "河北省廊坊市",
"861850555", "安徽省马鞍山市",
"861889765", "广西玉林市",
"861457202", "四川省成都市",
"861311356", "内蒙古赤峰市",
"861536387", "广东省惠州市",
"861325560", "山东省东营市",
"861770707", "江西省赣州市",
"861575031", "云南省普洱市",
"86152603", "福建省泉州市",
"86185659", "广东省东莞市",
"861850510", "江苏省无锡市",
"861313958", "宁夏银川市",
"86182578", "浙江省金华市",
"861769850", "河南省洛阳市",
"861454628", "宁夏固原市",
"861330439", "吉林省长春市",
"861459101", "广西防城港市",
"86170835", "山西省太原市",
"861815419", "安徽省六安市",
"861847151", "湖北省恩施土家族苗族自治州",
"861879977", "新疆伊犁哈萨克自治州",
"861876399", "山东省济南市",
"861533357", "山西省临汾市",
"861343528", "广东省清远市",
"861322008", "陕西省延安市",
"861537446", "甘肃省张掖市",
"86181411", "辽宁省大连市",
"861510969", "宁夏固原市",
"861804221", "浙江省金华市",
"861828084", "四川省南充市",
"861368550", "安徽省滁州市",
"861819116", "陕西省汉中市",
"861336538", "山东省泰安市",
"861362672", "浙江省湖州市",
"861333792", "江苏省无锡市",
"861362440", "吉林省长春市",
"861813456", "安徽省宣城市",
"861507646", "河北省廊坊市",
"861477819", "广东省广州市",
"861355980", "福建省莆田市",
"861586328", "山东省潍坊市",
"861872739", "湖北省荆州市",
"861768757", "广西柳州市",
"86158521", "江苏省徐州市",
"861831295", "浙江省宁波市",
"861336096", "广东省梅州市",
"861830641", "山东省济南市",
"86145963", "甘肃省酒泉市",
"86153250", "浙江省温州市",
"861866680", "广东省茂名市",
"861454636", "宁夏吴忠市",
"861705606", "广东省东莞市",
"861328659", "广东省清远市",
"861817758", "广西贵港市",
"861836001", "江苏省泰州市",
"861313465", "山西省长治市",
"861700565", "浙江省金华市",
"861308697", "贵州省六盘水市",
"861884049", "陕西省渭南市",
"861889063", "湖南省湘西土家族苗族自治州",
"861319160", "河北省邢台市",
"861452594", "福建省泉州市",
"861777161", "湖北省荆州市",
"861320986", "山西省临汾市",
"86182483", "内蒙古鄂尔多斯市",
"861780036", "河北省廊坊市",
"861514703", "内蒙古通辽市",
"861533748", "湖北省荆门市",
"861818671", "湖北省武汉市",
"861313571", "湖北省十堰市",
"861855799", "浙江省嘉兴市",
"861363858", "贵州省六盘水市",
"861504789", "内蒙古巴彦淖尔市",
"861869603", "湖北省十堰市",
"86185836", "四川省成都市",
"861538210", "辽宁省沈阳市",
"861508095", "湖南省岳阳市",
"861301066", "广东省广州市",
"861810715", "湖北省咸宁市",
"861313287", "广西贺州市",
"861332447", "吉林省长春市",
"861452454", "黑龙江省佳木斯市",
"861313501", "湖南省长沙市",
"861321064", "山东省日照市",
"86177297", "河南省郑州市",
"86159202", "广东省东莞市",
"861568678", "陕西省汉中市",
"861700401", "广东省深圳市",
"861594891", "吉林省白城市",
"861818601", "湖北省黄石市",
"861309131", "河北省张家口市",
"861837144", "湖北省黄石市",
"861324767", "广东省广州市",
"861813943", "新疆塔城地区",
"861595972", "福建省龙岩市",
"861787590", "广东省湛江市",
"861335735", "湖南省郴州市",
"861317045", "湖南省怀化市",
"861337841", "广东省深圳市",
"861523879", "河南省周口市",
"861302647", "陕西省延安市",
"861550722", "湖北省武汉市",
"861816875", "江苏省徐州市",
"861810750", "广东省江门市",
"861300984", "黑龙江省哈尔滨市",
"861531286", "江苏省盐城市",
"861576699", "广东省揭阳市",
"861886636", "山东省潍坊市",
"861882785", "江西省宜春市",
"861450609", "吉林省白山市",
"861338557", "贵州省毕节地区",
"861458544", "河南省驻马店市",
"86151045", "黑龙江省哈尔滨市",
"86136175", "海南省海口市",
"861537953", "宁夏吴忠市",
"861311067", "福建省漳州市",
"861454298", "辽宁省辽阳市",
"861323284", "广东省清远市",
"861536762", "湖南省娄底市",
"861705676", "陕西省西安市",
"861314764", "吉林省长春市",
"86147908", "安徽省阜阳市",
"861568217", "四川省南充市",
"861527644", "新疆喀什地区",
"861397188", "湖北省恩施土家族苗族自治州",
"861870358", "山西省吕梁市",
"86139334", "河北省唐山市",
"861571469", "黑龙江省双鸭山市",
"861808752", "云南省昆明市",
"861777553", "四川省广安市",
"861533066", "吉林省四平市",
"861562429", "山东省枣庄市",
"861362602", "福建省龙岩市",
"86139955", "湖北省武汉市",
"861371589", "广东省汕头市",
"861318696", "浙江省杭州市",
"861301748", "贵州省贵阳市",
"861503199", "河北省沧州市",
"861572244", "江苏省南通市",
"861770664", "浙江省温州市",
"861357375", "山东省济南市",
"861459171", "内蒙古呼和浩特市",
"86159528", "江苏省镇江市",
"861370570", "浙江省衢州市",
"861390646", "山东省潍坊市",
"861502743", "河北省石家庄市",
"861813026", "安徽省宣城市",
"861816172", "陕西省榆林市",
"861592969", "陕西省铜川市",
"861322078", "山东省枣庄市",
"861863843", "河南省商丘市",
"861772282", "广东省深圳市",
"861831625", "广东省肇庆市",
"861879907", "新疆石河子市",
"861386820", "浙江省舟山市",
"861776134", "四川省内江市",
"86138619", "江苏省南通市",
"861850495", "内蒙古通辽市",
"86182881", "云南省德宏傣族景颇族自治州",
"861374803", "内蒙古包头市",
"861776817", "江苏省宿迁市",
"861507180", "湖北省宜昌市",
"861810013", "浙江省宁波市",
"861707376", "河南省信阳市",
"861559794", "贵州省毕节地区",
"861550875", "云南省保山市",
"861816722", "浙江省宁波市",
"861859931", "新疆塔城地区",
"861350881", "云南省曲靖市",
"861534871", "云南省昆明市",
"861882083", "广东省湛江市",
"861518371", "四川省阿坝藏族羌族自治州",
"861595339", "山东省日照市",
"861380155", "江苏省苏州市",
"861770777", "广西钦州市",
"861535992", "福建省龙岩市",
"86155866", "湖北省恩施土家族苗族自治州",
"861339245", "广东省广州市",
"861317743", "湖北省咸宁市",
"861534230", "湖北省襄樊市",
"861569303", "甘肃省甘南藏族自治州",
"861870747", "湖南省永州市",
"861345504", "山东省日照市",
"861304606", "山东省淄博市",
"861847563", "广东省深圳市",
"861563350", "河北省衡水市",
"861880259", "广东省中山市",
"861301357", "山东省威海市",
"861332619", "浙江省温州市",
"86134214", "广东省中山市",
"861308227", "辽宁省抚顺市",
"861321399", "河南省开封市",
"86152778", "广西河池市",
"861839149", "陕西省铜川市",
"861820732", "湖南省湘潭市",
"861364535", "山东省烟台市",
"861563315", "河北省唐山市",
"861558041", "湖南省郴州市",
"86159259", "浙江省金华市",
"861554345", "吉林省长春市",
"861517419", "辽宁省辽阳市",
"861891205", "江苏省淮安市",
"861321781", "广西南宁市",
"861530341", "山西省太原市",
"861331468", "黑龙江省鹤岗市",
"861705517", "浙江省杭州市",
"861780638", "山东省泰安市",
"861333927", "安徽省亳州市",
"861506670", "山东省潍坊市",
"861884931", "河北省张家口市",
"861836890", "甘肃省天水市",
"86183081", "四川省宜宾市",
"861301816", "四川省内江市",
"861536642", "江苏省扬州市",
"861352378", "河南省开封市",
"86183612", "江苏省徐州市",
"861309362", "安徽省芜湖市",
"861380241", "广东省广州市",
"861817682", "广西钦州市",
"861770744", "湖南省张家界市",
"861454943", "福建省厦门市",
"861364225", "广东省肇庆市",
"861360445", "吉林省通化市",
"861452634", "江苏省徐州市",
"861301668", "广东省汕头市",
"861511926", "广东省河源市",
"861897197", "湖北省孝感市",
"861843601", "河南省周口市",
"861890053", "安徽省芜湖市",
"861536470", "山西省忻州市",
"861803637", "江苏省徐州市",
"861774920", "陕西省榆林市",
"861384917", "河南省郑州市",
"861786903", "云南省大理白族自治州",
"861860736", "湖南省常德市",
"86183677", "浙江省温州市",
"861889813", "河南省开封市",
"86156705", "河南省新乡市",
"86145959", "陕西省西安市",
"861300029", "江苏省南京市",
"86132511", "重庆市",
"861370821", "四川省成都市",
"861306498", "江苏省扬州市",
"861479781", "江西省鹰潭市",
"861558684", "湖北省襄樊市",
"86152662", "山东省青岛市",
"861870774", "广西梧州市",
"861476977", "山东省菏泽市",
"861583510", "山西省太原市",
"861566407", "河南省安阳市",
"861705008", "上海市",
"861811200", "江苏省徐州市",
"86189596", "福建省漳州市",
"861879895", "西藏昌都地区",
"861534520", "江苏省淮安市",
"861558302", "四川省南充市",
"86136020", "天津市",
"86185016", "上海市",
"8615316", "上海市",
"861519679", "四川省南充市",
"861813298", "河北省邯郸市",
"861524045", "江苏省无锡市",
"861329030", "山东省济宁市",
"861779904", "新疆和田地区",
"86187342", "山西省大同市",
"861302767", "河南省许昌市",
"861565720", "浙江省丽水市",
"861351364", "山西省太原市",
"86137825", "河南省新乡市",
"861857216", "湖北省武汉市",
"861596490", "山东省潍坊市",
"861346310", "河北省邯郸市",
"86137132", "广东省东莞市",
"861572866", "广东省中山市",
"861331910", "陕西省咸阳市",
"861773695", "河北省承德市",
"861351529", "江苏省宿迁市",
"861534090", "山西省临汾市",
"86186542", "安徽省阜阳市",
"86185663", "广东省佛山市",
"861332474", "广西贺州市",
"861867413", "湖北省咸宁市",
"861575949", "福建省泉州市",
"861870667", "山东省潍坊市",
"86189679", "浙江省金华市",
"861322606", "广东省中山市",
"86136236", "山西省太原市",
"8618889", "海南省海口市",
"861477394", "湖南省邵阳市",
"861806300", "安徽省淮南市",
"861881709", "湖南省常德市",
"861458577", "山东省菏泽市",
"861319786", "江西省宜春市",
"861320557", "安徽省宿州市",
"86145902", "广东省深圳市",
"861300599", "广西北海市",
"86147792", "广东省广州市",
"861357260", "陕西省汉中市",
"86130096", "新疆乌鲁木齐市",
"861831966", "广东省梅州市",
"861570056", "四川省广元市",
"86187773", "广西桂林市",
"861879192", "陕西省榆林市",
"861822691", "安徽省亳州市",
"861815382", "湖南省长沙市",
"861332583", "浙江省嘉兴市",
"861537509", "安徽省阜阳市",
"861831311", "云南省玉溪市",
"861317663", "山东省东营市",
"861346937", "湖南省永州市",
"861340924", "河南省新乡市",
"861371994", "广东省汕头市",
"861551373", "山西省阳泉市",
"861331337", "河北省沧州市",
"86155874", "湖北省恩施土家族苗族自治州",
"86132108", "山东省青岛市",
"861860728", "湖北省十堰市",
"861858440", "贵州省贵阳市",
"861840434", "吉林省四平市",
"86184313", "河北省张家口市",
"861304078", "浙江省绍兴市",
"861846427", "山东省滨州市",
"861508388", "江西省萍乡市",
"86151616", "江苏省无锡市",
"861306901", "吉林省长春市",
"861513849", "河南省郑州市",
"861470562", "安徽省铜陵市",
"861572581", "山东省淄博市",
"861309787", "广西钦州市",
"861869832", "福建省漳州市",
"86159263", "湖北省武汉市",
"861890423", "辽宁省抚顺市",
"861510721", "湖北省荆州市",
"861361421", "辽宁省朝阳市",
"861364695", "福建省宁德市",
"861893416", "广东省汕头市",
"861771257", "江苏省泰州市",
"861306971", "黑龙江省哈尔滨市",
"86156742", "湖南省常德市",
"861390933", "甘肃省平凉市",
"861394987", "河南省漯河市",
"861329351", "山西省太原市",
"86182632", "山东省枣庄市",
"86189415", "辽宁省丹东市",
"861769928", "新疆阿克苏地区",
"861552870", "四川省宜宾市",
"861396608", "安徽省蚌埠市",
"86131319", "河北省邢台市",
"861310494", "广东省江门市",
"861899156", "陕西省商洛市",
"861310185", "江苏省扬州市",
"861361917", "陕西省宝鸡市",
"861323541", "湖北省黄冈市",
"861781749", "广东省广州市",
"861812053", "湖北省十堰市",
"861570438", "吉林省松原市",
"861886026", "河南省安阳市",
"861458507", "河南省南阳市",
"861337323", "河北省沧州市",
"861551540", "河南省漯河市",
"861458281", "福建省宁德市",
"861361330", "河北省石家庄市",
"861375920", "云南省德宏傣族景颇族自治州",
"861322676", "广东省河源市",
"86157573", "浙江省嘉兴市",
"861372193", "山东省威海市",
"861829950", "新疆昌吉回族自治州",
"86187305", "河北省唐山市",
"861813628", "江苏省泰州市",
"861390048", "黑龙江省哈尔滨市",
"861596550", "山东省菏泽市",
"861841942", "甘肃省定西市",
"861535859", "江苏省镇江市",
"861302604", "安徽省淮北市",
"861320497", "湖南省永州市",
"861584838", "内蒙古呼和浩特市",
"861597029", "江西省新余市",
"86182806", "四川省凉山彝族自治州",
"861587533", "广东省广州市",
"86152629", "江苏省镇江市",
"861478531", "贵州省毕节地区",
"86187608", "云南省楚雄彝族自治州",
"861810289", "广东省汕尾市",
"86133761", "江苏省镇江市",
"861558372", "四川省内江市",
"861354756", "四川省南充市",
"861813636", "江苏省徐州市",
"861812710", "广东省江门市",
"861705078", "浙江省宁波市",
"861533816", "广东省珠海市",
"861310882", "云南省德宏傣族景颇族自治州",
"861856721", "河南省鹤壁市",
"861819932", "新疆乌鲁木齐市",
"86135975", "湖北省黄冈市",
"861522789", "河北省承德市",
"861335623", "山东省日照市",
"86151241", "辽宁省鞍山市",
"861857044", "湖南省张家界市",
"861802363", "广东省肇庆市",
"861454456", "江西省吉安市",
"86136027", "广东省广州市",
"861356874", "四川省雅安市",
"861530823", "四川省成都市",
"861811831", "江苏省徐州市",
"861319422", "辽宁省沈阳市",
"861519609", "四川省泸州市",
"861318098", "吉林省四平市",
"8613761", "上海市",
"86156373", "河南省新乡市",
"861339563", "安徽省宣城市",
"86130741", "辽宁省大连市",
"86158048", "内蒙古鄂尔多斯市",
"861311817", "四川省绵阳市",
"861305423", "黑龙江省大庆市",
"861450414", "辽宁省本溪市",
"86145311", "浙江省杭州市",
"861886943", "云南省昭通市",
"861509683", "云南省昭通市",
"861550997", "新疆阿克苏地区",
"861880780", "广西防城港市",
"861303588", "河北省石家庄市",
"86158982", "辽宁省葫芦岛市",
"861501411", "广东省深圳市",
"861589190", "云南省文山壮族苗族自治州",
"86180283", "广东省中山市",
"861870704", "江西省抚州市",
"861808688", "四川省乐山市",
"861579405", "广东省深圳市",
"861345547", "山东省济宁市",
"861334549", "新疆博尔塔拉蒙古自治州",
"861571198", "广东省深圳市",
"86186505", "福建省宁德市",
"861895459", "山东省烟台市",
"861539574", "浙江省宁波市",
"861886596", "山东省东营市",
"861348571", "安徽省合肥市",
"861471620", "广东省佛山市",
"861508235", "四川省眉山市",
"86183670", "浙江省衢州市",
"861590522", "江苏省徐州市",
"861398444", "贵州省黔南布依族苗族自治州",
"861348465", "陕西省延安市",
"86159796", "江西省吉安市",
"861787630", "广东省清远市",
"861886038", "河南省郑州市",
"861830761", "广东省深圳市",
"861380999", "新疆博尔塔拉蒙古自治州",
"861780296", "陕西省汉中市",
"861769936", "新疆阿克苏地区",
"861391961", "甘肃省庆阳市",
"861860963", "安徽省芜湖市",
"861805048", "福建省漳州市",
"861323290", "广东省江门市",
"86139934", "甘肃省庆阳市",
"861362390", "河南省新乡市",
"861572776", "江西省赣州市",
"861530978", "青海省西宁市",
"86139658", "安徽省淮北市",
"861368484", "江西省抚州市",
"86147308", "四川省成都市",
"861394346", "吉林省四平市",
"861810703", "江西省上饶市",
"86152083", "四川省成都市",
"861310377", "河南省南阳市",
"861309325", "湖北省恩施土家族苗族自治州",
"861768901", "西藏拉萨市",
"861800789", "广西梧州市",
"86189865", "湖北省黄冈市",
"861362906", "四川省达州市",
"86181459", "黑龙江省大庆市",
"861529157", "陕西省西安市",
"861870548", "山东省泰安市",
"861340360", "山西省大同市",
"86159646", "山东省菏泽市",
"86139355", "山西省长治市",
"861800391", "河南省焦作市",
"861335371", "河南省郑州市",
"861539066", "甘肃省兰州市",
"861535385", "陕西省汉中市",
"861822040", "陕西省咸阳市",
"861390267", "广东省汕尾市",
"861588274", "四川省巴中市",
"861394839", "内蒙古巴彦淖尔市",
"861350047", "辽宁省营口市",
"86159169", "广东省东莞市",
"86184690", "云南省曲靖市",
"86183130", "云南省德宏傣族景颇族自治州",
"861300306", "安徽省合肥市",
"861338347", "山西省临汾市",
"861368573", "浙江省宁波市",
"861458354", "山东省东营市",
"861303131", "新疆伊犁哈萨克自治州",
"86155173", "河南省新乡市",
"861837226", "湖北省襄樊市",
"861351920", "宁夏银川市",
"861518948", "江苏省徐州市",
"861787584", "广东省清远市",
"861320374", "河南省郑州市",
"861770578", "浙江省丽水市",
"86151682", "浙江省杭州市",
"861390876", "云南省文山壮族苗族自治州",
"861777500", "安徽省阜阳市",
"861357731", "云南省红河哈尼族彝族自治州",
"861814969", "福建省宁德市",
"861476512", "广东省广州市",
"861319501", "宁夏银川市",
"861513414", "辽宁省本溪市",
"86151011", "北京市",
"861319287", "广东省韶关市",
"861452837", "四川省阿坝藏族羌族自治州",
"861300990", "黑龙江省大庆市",
"861355845", "广西玉林市",
"861840316", "河北省廊坊市",
"861876278", "江苏省扬州市",
"861835970", "福建省厦门市",
"861839657", "福建省南平市",
"861805942", "福建省宁德市",
"861550645", "山东省聊城市",
"861586609", "山东省济宁市",
"861840961", "宁夏中卫市",
"861370493", "辽宁省抚顺市",
"861554555", "黑龙江省绥化市",
"861399702", "青海省海东地区",
"861308319", "安徽省合肥市",
"861530551", "安徽省合肥市",
"861830801", "西藏拉萨市",
"861810005", "上海市",
"861841933", "甘肃省白银市",
"861302266", "浙江省台州市",
"861517159", "湖北省咸宁市",
"86130360", "海南省海口市",
"861301547", "山西省太原市",
"86180850", "贵州省贵阳市",
"861807556", "湖南省怀化市",
"861778083", "四川省内江市",
"861470793", "江西省上饶市",
"86182117", "河南省信阳市",
"861479506", "宁夏中卫市",
"861590998", "新疆喀什地区",
"861888282", "四川省雅安市",
"861302159", "山东省枣庄市",
"86147450", "四川省成都市",
"861515557", "安徽省宣城市",
"861833149", "河北省衡水市",
"861454309", "黑龙江省大庆市",
"86183686", "浙江省金华市",
"86134851", "江苏省南通市",
"861769873", "河南省信阳市",
"861577603", "黑龙江省绥化市",
"861353917", "广东省梅州市",
"861364947", "广西南宁市",
"86185948", "重庆市",
"861873907", "河南省洛阳市",
"861348786", "湖南省郴州市",
"861559780", "贵州省安顺市",
"86156692", "浙江省宁波市",
"86185082", "四川省成都市",
"861864869", "内蒙古鄂尔多斯市",
"86185611", "山东省德州市",
"861819026", "四川省阿坝藏族羌族自治州",
"861770951", "宁夏银川市",
"861380415", "辽宁省丹东市",
"861812891", "广东省韶关市",
"861384893", "内蒙古通辽市",
"861870864", "贵州省铜仁地区",
"861524488", "四川省内江市",
"861325101", "浙江省杭州市",
"861525554", "安徽省合肥市",
"861760524", "江苏省连云港市",
"861459560", "陕西省渭南市",
"861392307", "广东省江门市",
"861895306", "山东省东营市",
"861891213", "江苏省扬州市",
"861537685", "山东省聊城市",
"861337671", "广东省湛江市",
"861523649", "河南省新乡市",
"861302877", "甘肃省临夏回族自治州",
"861470525", "江苏省扬州市",
"861801120", "四川省内江市",
"86180189", "辽宁省大连市",
"861330896", "西藏那曲地区",
"861817497", "广西百色市",
"861342831", "广东省汕头市",
"86170854", "安徽省合肥市",
"861521713", "广东省东莞市",
"861892703", "广东省河源市",
"861512401", "辽宁省锦州市",
"861450849", "江苏省常州市",
"86189139", "江苏省南京市",
"861862478", "河南省南阳市",
"861533547", "山东省济宁市",
"861318144", "山东省枣庄市",
"861356764", "浙江省丽水市",
"861815159", "江苏省苏州市",
"861571044", "陕西省西安市",
"86137672", "江西省九江市",
"861337601", "江苏省泰州市",
"861879751", "湖南省张家界市",
"861302807", "山西省长治市",
"861780797", "江西省赣州市",
"861847411", "湖南省益阳市",
"861576930", "甘肃省庆阳市",
"861325721", "湖北省荆州市",
"861535238", "甘肃省金昌市",
"861311546", "黑龙江省鸡西市",
"861539357", "甘肃省金昌市",
"861815266", "湖南省常德市",
"861873977", "河南省周口市",
"861347437", "陕西省西安市",
"86138651", "安徽省安庆市",
"861527196", "湖北省襄樊市",
"86150140", "广东省深圳市",
"861361572", "浙江省湖州市",
"861818841", "四川省绵阳市",
"861886309", "山东省滨州市",
"861857198", "湖北省荆门市",
"861345816", "四川省遂宁市",
"861328147", "四川省成都市",
"861315255", "广西柳州市",
"861815877", "浙江省温州市",
"86147457", "黑龙江省哈尔滨市",
"861311993", "新疆石河子市",
"861807496", "广西梧州市",
"86182110", "北京市",
"861773947", "河南省鹤壁市",
"861805194", "江苏省无锡市",
"861370553", "安徽省芜湖市",
"861805485", "福建省宁德市",
"861769803", "河南省许昌市",
"861454379", "山东省枣庄市",
"861823828", "河南省信阳市",
"861530491", "辽宁省鞍山市",
"861556123", "内蒙古兴安盟",
"86133347", "云南省普洱市",
"861866913", "云南省临沧市",
"861810075", "湖南省长沙市",
"861809027", "四川省广安市",
"861891924", "甘肃省天水市",
"861399772", "湖北省宜昌市",
"86159122", "云南省大理白族自治州",
"861539935", "陕西省汉中市",
"861334940", "黑龙江省哈尔滨市",
"861830871", "云南省昆明市",
"861582037", "广东省肇庆市",
"861597306", "湖南省常德市",
"861305891", "浙江省湖州市",
"86180857", "贵州省毕节地区",
"861336737", "湖南省益阳市",
"861868629", "内蒙古赤峰市",
"861391434", "江苏省常州市",
"861330724", "湖北省咸宁市",
"861501245", "广东省深圳市",
"861820663", "广东省揭阳市",
"861500691", "山东省日照市",
"861835900", "福建省莆田市",
"86135532", "广东省河源市",
"861883063", "河北省廊坊市",
"861343727", "湖北省武汉市",
"861829559", "宁夏银川市",
"861809597", "新疆昌吉回族自治州",
"861452580", "福建省福州市",
"861785893", "浙江省宁波市",
"861332397", "河南省信阳市",
"861368503", "福建省福州市",
"861595606", "安徽省合肥市",
"86183137", "云南省昆明市",
"861773262", "河北省廊坊市",
"861369858", "贵州省六盘水市",
"861770508", "福建省泉州市",
"861319571", "青海省海西蒙古族藏族自治州",
"861512998", "陕西省宝鸡市",
"861472871", "贵州省铜仁地区",
"861868941", "广东省广州市",
"861539748", "浙江省台州市",
"86185246", "辽宁省营口市",
"861339792", "江西省九江市",
"861361893", "西藏山南地区",
"861890891", "西藏拉萨市",
"861346889", "陕西省榆林市",
"861378835", "广西玉林市",
"861881869", "广东省深圳市",
"861535226", "甘肃省临夏回族自治州",
"861865977", "福建省龙岩市",
"861304339", "吉林省延边朝鲜族自治州",
"861380020", "广东省广州市",
"86188890", "西藏拉萨市",
"861590565", "安徽省合肥市",
"861816813", "江苏省连云港市",
"861828090", "四川省内江市",
"861471541", "广东省肇庆市",
"861381947", "浙江省杭州市",
"861514750", "内蒙古鄂尔多斯市",
"86130428", "湖北省武汉市",
"861355994", "福建省福州市",
"861556075", "内蒙古通辽市",
"861530908", "四川省泸州市",
"861309286", "四川省德阳市",
"861454932", "江苏省连云港市",
"861709989", "广东省珠海市",
"861343859", "四川省泸州市",
"861310307", "河北省沧州市",
"86181445", "北京市",
"861390485", "黑龙江省绥化市",
"86139349", "山西省朔州市",
"861590471", "内蒙古呼和浩特市",
"861810773", "广西桂林市",
"861338408", "河南省南阳市",
"861459333", "四川省宜宾市",
"861539166", "湖北省咸宁市",
"861815429", "安徽省阜阳市",
"861830919", "陕西省铜川市",
"861343518", "广东省江门市",
"861388651", "湖北省咸宁市",
"861571992", "新疆塔城地区",
"861598985", "广东省深圳市",
"861850520", "江苏省常州市",
"86147615", "江苏省无锡市",
"861315939", "福建省三明市",
"861510552", "安徽省蚌埠市",
"861374012", "北京市",
"861509099", "湖北省鄂州市",
"861780507", "江苏省常州市",
"861760485", "内蒙古兴安盟",
"861312524", "江西省抚州市",
"8613594", "重庆市",
"861879471", "甘肃省酒泉市",
"861845241", "江苏省无锡市",
"861370784", "广西梧州市",
"861518133", "四川省自贡市",
"861889341", "甘肃省庆阳市",
"861364789", "广西北海市",
"861454866", "河南省鹤壁市",
"861476243", "江苏省泰州市",
"861539259", "山西省运城市",
"861312369", "贵州省黔西南布依族苗族自治州",
"861769825", "河南省郑州市",
"861556105", "内蒙古通辽市",
"861477348", "湖南省湘西土家族苗族自治州",
"861336516", "江苏省淮安市",
"861561066", "山东省临沂市",
"861364391", "河南省焦作市",
"861801590", "江苏省南通市",
"86186930", "甘肃省兰州市",
"861858663", "贵州省铜仁地区",
"861532640", "吉林省长春市",
"861892175", "江苏省徐州市",
"861864306", "吉林省长春市",
"861383476", "山西省吕梁市",
"861369519", "广东省佛山市",
"86158208", "广东省东莞市",
"861348855", "内蒙古通辽市",
"861519054", "江苏省常州市",
"861808800", "云南省丽江市",
"861399452", "山西省阳泉市",
"86151001", "河北省石家庄市",
"86133375", "海南省海口市",
"86137455", "黑龙江省绥化市",
"861395947", "福建省龙岩市",
"861379556", "四川省自贡市",
"861317672", "山东省潍坊市",
"861864990", "福建省漳州市",
"86156384", "河南省郑州市",
"861303031", "河南省濮阳市",
"861508515", "贵州省黔南布依族苗族自治州",
"861470573", "浙江省嘉兴市",
"86180274", "广东省广州市",
"861563286", "河北省衡水市",
"861389940", "新疆阿勒泰地区",
"861532472", "河南省郑州市",
"861350147", "广东省广州市",
"861555528", "安徽省亳州市",
"861804088", "新疆喀什地区",
"86157584", "云南省迪庆藏族自治州",
"861572943", "河南省漯河市",
"861526841", "浙江省宁波市",
"861883978", "河南省郑州市",
"861708392", "河南省鹤壁市",
"861560639", "山东省青岛市",
"861552511", "山西省晋中市",
"861893658", "江苏省连云港市",
"861769122", "陕西省西安市",
"861322097", "山东省德州市",
"861825096", "福建省南平市",
"861575286", "云南省昆明市",
"861302059", "山东省聊城市",
"861860902", "新疆哈密地区",
"861809707", "青海省西宁市",
"861778183", "四川省成都市",
"861368793", "江西省上饶市",
"861584748", "内蒙古通辽市",
"861768819", "广东省珠海市",
"861392448", "广东省梅州市",
"861365346", "山西省晋城市",
"861823247", "河北省廊坊市",
"861761434", "吉林省四平市",
"861770798", "江西省景德镇市",
"861323983", "新疆阿克苏地区",
"861332299", "广东省深圳市",
"861871446", "黑龙江省双鸭山市",
"86188539", "山东省临沂市",
"861881376", "广东省梅州市",
"861700977", "浙江省绍兴市",
"861335589", "浙江省金华市",
"861339502", "福建省厦门市",
"86183795", "江西省宜春市",
"861590751", "广东省韶关市",
"861810453", "黑龙江省牡丹江市",
"861838906", "西藏那曲地区",
"861800947", "甘肃省嘉峪关市",
"861869742", "内蒙古锡林郭勒盟",
"861831843", "广东省揭阳市",
"861505669", "安徽省黄山市",
"86181477", "内蒙古鄂尔多斯市",
"861340533", "山东省淄博市",
"861300283", "四川省遂宁市",
"861453687", "陕西省宝鸡市",
"861472919", "陕西省铜川市",
"861520530", "山东省菏泽市",
"861477829", "广东省湛江市",
"861514470", "内蒙古呼伦贝尔市",
"861306444", "河南省安阳市",
"86158522", "江苏省徐州市",
"861384792", "内蒙古锡林郭勒盟",
"861300869", "云南省昆明市",
"861325001", "广东省江门市",
"86181412", "辽宁省鞍山市",
"86151394", "河南省周口市",
"86137600", "广东省肇庆市",
"861804211", "浙江省温州市",
"861598600", "广东省河源市",
"86185601", "山东省济南市",
"861535469", "吉林省松原市",
"861572596", "山东省临沂市",
"861327762", "湖北省随州市",
"861475648", "河北省衡水市",
"861842034", "广东省湛江市",
"86187784", "广西梧州市",
"861760942", "甘肃省酒泉市",
"861521812", "广东省汕尾市",
"861709747", "广东省中山市",
"86152436", "湖南省长沙市",
"861857098", "湖南省怀化市",
"861875295", "江苏省镇江市",
"86137607", "广东省广州市",
"861838145", "四川省眉山市",
"861525085", "江苏省淮安市",
"861310279", "河北省衡水市",
"861871953", "甘肃省甘南藏族自治州",
"861592552", "云南省昭通市",
"861529366", "甘肃省甘南藏族自治州",
"861802372", "广东省清远市",
"861810593", "福建省宁德市",
"86177555", "安徽省马鞍山市",
"861303350", "江苏省无锡市",
"861859368", "福建省漳州市",
"86181470", "内蒙古呼伦贝尔市",
"86155883", "山东省威海市",
"861339572", "浙江省湖州市",
"861520887", "云南省迪庆藏族自治州",
"861771406", "江苏省苏州市",
"861390369", "黑龙江省大庆市",
"86158906", "河南省郑州市",
"861303315", "安徽省铜陵市",
"861309540", "安徽省阜阳市",
"861598442", "四川省泸州市",
"86158739", "湖南省邵阳市",
"8614782", "上海市",
"861822686", "安徽省阜阳市",
"861396537", "安徽省马鞍山市",
"861527538", "山东省泰安市",
"861390524", "江苏省宿迁市",
"861529427", "甘肃省定西市",
"86153595", "福建省泉州市",
"861452246", "浙江省杭州市",
"861532853", "四川省遂宁市",
"861316549", "山东省临沂市",
"861315302", "山东省济南市",
"861362743", "湖南省湘西土家族苗族自治州",
"861807669", "广西北海市",
"861528645", "贵州省六盘水市",
"861319389", "河南省信阳市",
"861803951", "河南省郑州市",
"861378032", "河北省保定市",
"861769702", "青海省海东地区",
"861375199", "广东省梅州市",
"861338249", "江苏省镇江市",
"861550712", "湖北省鄂州市",
"861332941", "黑龙江省哈尔滨市",
"861777790", "广西北海市",
"861319791", "江西省南昌市",
"861458638", "湖北省孝感市",
"86188722", "湖北省武汉市",
"861386152", "江苏省无锡市",
"86131923", "广东省汕头市",
"861771885", "广东省湛江市",
"861510884", "云南省文山壮族苗族自治州",
"861589641", "江苏省扬州市",
"861554084", "内蒙古乌海市",
"861809777", "新疆阿克苏地区",
"861860972", "青海省海东地区",
"861881990", "广东省潮州市",
"861551787", "河南省安阳市",
"861315684", "山东省菏泽市",
"861328047", "山东省枣庄市",
"861879998", "新疆巴音郭楞蒙古自治州",
"861880547", "山东省济宁市",
"861760876", "云南省文山壮族苗族自治州",
"861517429", "辽宁省葫芦岛市",
"861317602", "山东省济南市",
"861458626", "湖北省黄冈市",
"861399592", "湖北省黄冈市",
"861898996", "西藏那曲地区",
"861776759", "新疆伊犁哈萨克自治州",
"861886618", "山东省潍坊市",
"861332629", "山东省滨州市",
"861525783", "浙江省丽水市",
"861532402", "河北省唐山市",
"861308217", "河北省沧州市",
"861839464", "甘肃省张掖市",
"861530765", "广东省佛山市",
"861454581", "甘肃省兰州市",
"861383406", "山西省晋城市",
"861808231", "江苏省宿迁市",
"861826033", "江苏省盐城市",
"861454207", "河南省洛阳市",
"861479796", "江西省吉安市",
"861589929", "新疆石河子市",
"86147479", "内蒙古鄂尔多斯市",
"861538690", "山西省忻州市",
"86184556", "安徽省安庆市",
"861302429", "浙江省杭州市",
"86137449", "吉林省长春市",
"861331858", "广东省韶关市",
"861808870", "黑龙江省哈尔滨市",
"861773789", "河南省南阳市",
"861561748", "河南省许昌市",
"861848581", "贵州省毕节地区",
"861801415", "江苏省淮安市",
"86131574", "浙江省宁波市",
"861390094", "甘肃省兰州市",
"861380770", "广西防城港市",
"861708840", "江西省萍乡市",
"861860339", "河北省秦皇岛市",
"861771182", "宁夏石嘴山市",
"861361792", "江西省九江市",
"861308678", "广西河池市",
"861831650", "广东省中山市",
"861834997", "四川省自贡市",
"861879401", "甘肃省甘南藏族自治州",
"861470340", "山西省忻州市",
"861362045", "广东省茂名市",
"861351683", "浙江省嘉兴市",
"861459711", "山东省德州市",
"861831615", "广东省阳江市",
"861898543", "贵州省安顺市",
"86186028", "四川省成都市",
"861776827", "江苏省徐州市",
"86182882", "云南省昆明市",
"861338478", "内蒙古巴彦淖尔市",
"861560984", "辽宁省大连市",
"861801450", "江苏省泰州市",
"861810023", "广东省东莞市",
"86176355", "山西省长治市",
"861780577", "浙江省温州市",
"861327387", "河南省许昌市",
"861596388", "山东省东营市",
"861860846", "湖南省永州市",
"861398901", "西藏拉萨市",
"861810872", "云南省大理白族自治州",
"86150175", "广东省广州市",
"861392209", "广东省湛江市",
"86158569", "安徽省合肥市",
"86133703", "天津市",
"861857528", "广东省东莞市",
"861319810", "四川省广安市",
"861309291", "陕西省宝鸡市",
"86156715", "湖北省武汉市",
"861850641", "山东省济南市",
"861369468", "黑龙江省牡丹江市",
"861356096", "广东省梅州市",
"861378745", "湖南省怀化市",
"861512192", "宁夏石嘴山市",
"86155250", "山西省太原市",
"861378926", "湖南省怀化市",
"8618210", "北京市",
"861879522", "宁夏石嘴山市",
"861325552", "山东省烟台市",
"861520939", "甘肃省陇南市",
"861772921", "陕西省延安市",
"861592071", "广东省佛山市",
"861890153", "江苏省无锡市",
"861376288", "湖南省邵阳市",
"861878436", "四川省阿坝藏族羌族自治州",
"861335980", "黑龙江省大庆市",
"861366653", "浙江省湖州市",
"861588499", "四川省巴中市",
"861820602", "福建省莆田市",
"861567243", "湖北省荆州市",
"861337305", "河北省唐山市",
"861594720", "内蒙古呼伦贝尔市",
"861772417", "广东省云浮市",
"86139493", "河南省南阳市",
"861890886", "云南省怒江傈僳族自治州",
"861339051", "辽宁省大连市",
"861356538", "新疆喀什地区",
"86183602", "江苏省宿迁市",
"861353792", "广东省云浮市",
"861399936", "新疆昌吉回族自治州",
"861569588", "浙江省杭州市",
"861561504", "山东省东营市",
"861898532", "贵州省安顺市",
"861373258", "浙江省嘉兴市",
"861882930", "陕西省西安市",
"861453492", "内蒙古锡林郭勒盟",
"86189024", "广东省深圳市",
"861363683", "陕西省咸阳市",
"86189442", "江苏省苏州市",
"861509920", "新疆伊犁哈萨克自治州",
"861889712", "青海省海东地区",
"861475567", "安徽省阜阳市",
"86183836", "四川省甘孜藏族自治州",
"861458797", "湖南省长沙市",
"861500395", "河南省漯河市",
"861819866", "贵州省黔南布依族苗族自治州",
"861558210", "山西省太原市",
"861524145", "辽宁省大连市",
"861329130", "江苏省常州市",
"86138898", "辽宁省沈阳市",
"861300779", "青海省西宁市",
"861532521", "浙江省绍兴市",
"861366392", "河南省鹤壁市",
"861705108", "浙江省温州市",
"861882317", "广东省深圳市",
"861454138", "河北省衡水市",
"861471983", "新疆石河子市",
"861323435", "吉林省通化市",
"861327872", "云南省昆明市",
"861814333", "湖南省娄底市",
"861599704", "青海省海南藏族自治州",
"861479627", "广西北海市",
"86150635", "山东省聊城市",
"861524976", "河南省商丘市",
"861826042", "江苏省苏州市",
"861551325", "山西省太原市",
"861810387", "河南省周口市",
"861539838", "云南省昆明市",
"8615696", "重庆市",
"86189657", "福建省泉州市",
"861881459", "黑龙江省大庆市",
"861508959", "广东省阳江市",
"861362732", "湖南省湘潭市",
"861459890", "广东省东莞市",
"861319152", "内蒙古赤峰市",
"861857992", "广西柳州市",
"861516641", "山东省济南市",
"861327593", "福建省宁德市",
"861454126", "河北省廊坊市",
"861597709", "广西桂林市",
"861500686", "山东省东营市",
"861827279", "河南省南阳市",
"86180156", "江苏省苏州市",
"861330566", "安徽省池州市",
"861378043", "河北省保定市",
"861580437", "吉林省辽源市",
"86158381", "河南省郑州市",
"861807481", "广西南宁市",
"861389549", "宁夏银川市",
"861454776", "山东省威海市",
"86151125", "广东省深圳市",
"861811954", "安徽省淮南市",
"861512895", "河北省保定市",
"861530486", "黑龙江省大庆市",
"861313412", "辽宁省鞍山市",
"861317251", "广东省汕头市",
"861870594", "福建省莆田市",
"861520372", "河南省安阳市",
"861700512", "江苏省苏州市",
"86181829", "云南省曲靖市",
"861368562", "安徽省铜陵市",
"861318717", "湖南省邵阳市",
"861305405", "湖南省衡阳市",
"86186496", "福建省厦门市",
"861564264", "辽宁省葫芦岛市",
"861760933", "甘肃省平凉市",
"861553357", "河北省唐山市",
"861570883", "云南省临沧市",
"861878428", "四川省南充市",
"861315530", "安徽省芜湖市",
"861830510", "江苏省盐城市",
"861895129", "江苏省宿迁市",
"86183659", "山东省聊城市",
"861579423", "江苏省无锡市",
"861350439", "吉林省长春市",
"861378938", "湖南省衡阳市",
"861535007", "江西省赣州市",
"861304728", "湖南省邵阳市",
"861559547", "宁夏中卫市",
"861327725", "湖北省宜昌市",
"861821957", "广东省云浮市",
"861568482", "新疆巴音郭楞蒙古自治州",
"861824690", "黑龙江省双鸭山市",
"861879092", "河南省漯河市",
"861529282", "新疆和田地区",
"861598433", "四川省眉山市",
"861818731", "云南省昆明市",
"861830555", "安徽省马鞍山市",
"861339421", "辽宁省朝阳市",
"861869733", "河南省郑州市",
"861831832", "广东省揭阳市",
"86183645", "山东省烟台市",
"861535681", "浙江省杭州市",
"861883072", "河北省沧州市",
"861340542", "山东省青岛市",
"861880816", "四川省雅安市",
"86153866", "四川省绵阳市",
"861800695", "福建省漳州市",
"861812153", "江苏省无锡市",
"861555992", "云南省保山市",
"861801241", "江苏省南通市",
"861760766", "广东省云浮市",
"861780354", "山西省晋中市",
"861839931", "新疆伊犁哈萨克自治州",
"86145094", "江苏省无锡市",
"861530875", "云南省保山市",
"861568738", "云南省昆明市",
"861536750", "湖南省永州市",
"861510071", "河北省廊坊市",
"861899782", "新疆昌吉回族自治州",
"861330881", "云南省西双版纳傣族自治州",
"861458118", "安徽省阜阳市",
"86189405", "辽宁省朝阳市",
"861354885", "湖南省常德市",
"861505481", "山东省青岛市",
"861309621", "四川省宜宾市",
"861348791", "湖南省常德市",
"86180665", "陕西省西安市",
"861512944", "陕西省西安市",
"86181224", "广东省广州市",
"861339917", "陕西省宝鸡市",
"86183348", "山西省吕梁市",
"86150846", "黑龙江省哈尔滨市",
"861539794", "江西省抚州市",
"861514633", "黑龙江省牡丹江市",
"861880668", "广东省茂名市",
"861535077", "河北省沧州市",
"861452358", "河南省三门峡市",
"861315887", "四川省绵阳市",
"861348389", "河北省承德市",
"861584504", "黑龙江省哈尔滨市",
"861884854", "贵州省铜仁地区",
"861533780", "广东省清远市",
"861579710", "湖北省十堰市",
"861339330", "河北省秦皇岛市",
"861538041", "江苏省南京市",
"86187618", "江苏省南京市",
"861518845", "河南省南阳市",
"861550341", "山西省运城市",
"861360531", "山东省济南市",
"861572932", "河南省漯河市",
"86182816", "四川省绵阳市",
"861776167", "河南省周口市",
"861454706", "浙江省台州市",
"86184775", "广西玉林市",
"861786925", "云南省丽江市",
"86187941", "甘肃省天水市",
"861872609", "安徽省安庆市",
"861585660", "安徽省池州市",
"861327453", "黑龙江省牡丹江市",
"861522947", "陕西省宝鸡市",
"861894512", "黑龙江省齐齐哈尔市",
"86187315", "河北省唐山市",
"861870454", "黑龙江省佳木斯市",
"861390148", "江苏省南通市",
"861520684", "山东省临沂市",
"861860517", "江苏省淮安市",
"861372093", "山西省吕梁市",
"861308716", "内蒙古通辽市",
"861810762", "广东省河源市",
"861355948", "福建省厦门市",
"861827209", "湖北省孝感市",
"861571528", "江苏省镇江市",
"861362488", "内蒙古巴彦淖尔市",
"861325884", "吉林省长春市",
"861853657", "山西省阳泉市",
"861563362", "河北省唐山市",
"861524906", "陕西省西安市",
"86155184", "河南省周口市",
"861890475", "内蒙古通辽市",
"861821288", "贵州省黔西南布依族苗族自治州",
"86180427", "辽宁省盘锦市",
"861316940", "广东省韶关市",
"861357841", "云南省西双版纳傣族自治州",
"86145301", "北京市",
"861868404", "四川省成都市",
"86189650", "福建省福州市",
"861374918", "河南省郑州市",
"861530722", "湖北省武汉市",
"86159685", "浙江省绍兴市",
"861856071", "山东省淄博市",
"861318198", "山东省东营市",
"861840719", "湖北省十堰市",
"861525448", "山东省日照市",
"861865243", "江苏省苏州市",
"861361563", "安徽省宣城市",
"861599124", "陕西省咸阳市",
"861890561", "安徽省淮北市",
"861593246", "河北省邯郸市",
"861770637", "山东省德州市",
"861857144", "湖北省襄樊市",
"861355735", "广西玉林市",
"861332754", "山西省晋中市",
"861452747", "湖南省衡阳市",
"861571536", "山东省潍坊市",
"8627", "湖北省武汉市",
"861881599", "福建省泉州市",
"861855446", "山东省济南市",
"86159388", "河南省南阳市",
"861705178", "浙江省杭州市",
"861782899", "四川省德阳市",
"861354182", "四川省广元市",
"861803744", "河南省商丘市",
"861816341", "广东省珠海市",
"861805148", "江苏省苏州市",
"861561574", "山东省泰安市",
"861888809", "江苏省徐州市",
"861588559", "贵州省黔南布依族苗族自治州",
"861337375", "河南省新乡市",
"861459342", "四川省乐山市",
"86188196", "广东省惠州市",
"861581264", "广东省珠海市",
"86134698", "湖北省宜昌市",
"861521635", "山东省聊城市",
"861518142", "四川省广元市",
"86170042", "辽宁省大连市",
"861309949", "云南省德宏傣族景颇族自治州",
"861768380", "湖北省孝感市",
"861399763", "湖北省荆州市",
"861394749", "内蒙古阿拉善盟",
"86170988", "广东省广州市",
"861780912", "陕西省榆林市",
"861331239", "贵州省六盘水市",
"861572379", "广西北海市",
"86177776", "广西百色市",
"861809867", "安徽省淮南市",
"861524097", "云南省丽江市",
"861773419", "河北省邢台市",
"86150570", "浙江省衢州市",
"861553331", "河北省邯郸市",
"861397249", "湖北省十堰市",
"861874287", "新疆巴音郭楞蒙古自治州",
"861805400", "安徽省淮南市",
"86170774", "湖南省长沙市",
"861321917", "四川省达州市",
"861827170", "湖北省武汉市",
"861863903", "河南省商丘市",
"861521794", "广东省广州市",
"861301062", "江西省鹰潭市",
"861593689", "河南省三门峡市",
"861879847", "贵州省六盘水市",
"861330550", "安徽省滁州市",
"86152742", "湖南省常德市",
"861821931", "广东省茂名市",
"861534299", "湖北省荆州市",
"86186632", "山东省枣庄市",
"861586979", "湖南省益阳市",
"861321421", "辽宁省朝阳市",
"861850583", "浙江省嘉兴市",
"861327234", "湖南省衡阳市",
"861320982", "山西省太原市",
"861898469", "贵州省黔西南布依族苗族自治州",
"861780032", "河北省保定市",
"86156629", "吉林省白山市",
"861813452", "安徽省合肥市",
"861507642", "河北省保定市",
"86186806", "广东省东莞市",
"861582792", "湖北省咸宁市",
"861865081", "福建省厦门市",
"861818829", "贵州省六盘水市",
"861335808", "江苏省南通市",
"861805113", "江苏省苏州市",
"861346798", "湖南省湘西土家族苗族自治州",
"86185372", "河南省安阳市",
"861374038", "河南省郑州市",
"861580451", "黑龙江省哈尔滨市",
"861360497", "辽宁省营口市",
"861336092", "广东省清远市",
"861890398", "河南省三门峡市",
"861705602", "广东省广州市",
"861454632", "宁夏银川市",
"861530608", "福建省泉州市",
"861537442", "甘肃省定西市",
"861705384", "内蒙古呼和浩特市",
"861325749", "湖南省湘潭市",
"861847164", "湖北省襄樊市",
"86188860", "贵州省贵阳市",
"861560255", "广东省江门市",
"86138350", "山西省忻州市",
"861345103", "湖北省恩施土家族苗族自治州",
"861536933", "河北省张家口市",
"861321330", "河南省周口市",
"861869950", "新疆吐鲁番地区",
"861819112", "陕西省西安市",
"861359781", "湖北省恩施土家族苗族自治州",
"861333796", "江苏省淮安市",
"861850474", "内蒙古乌兰察布市",
"861559775", "贵州省遵义市",
"861362676", "浙江省嘉兴市",
"861778120", "四川省南充市",
"861847627", "广东省梅州市",
"861823430", "山西省阳泉市",
"861787539", "广东省深圳市",
"861826897", "浙江省衢州市",
"861323920", "陕西省延安市",
"861458143", "浙江省台州市",
"861535370", "陕西省西安市",
"86152373", "河南省新乡市",
"861586332", "山东省德州市",
"861471529", "广东省中山市",
"861538869", "陕西省咸阳市",
"861576630", "广东省惠州市",
"861778770", "云南省玉溪市",
"861803263", "河北省廊坊市",
"861336522", "江苏省泰州市",
"861837543", "山东省滨州市",
"861311352", "内蒙古鄂尔多斯市",
"861457206", "四川省绵阳市",
"861516583", "山东省聊城市",
"861831204", "广东省东莞市",
"861839288", "陕西省西安市",
"861367703", "江西省上饶市",
"86153190", "陕西省咸阳市",
"86138408", "辽宁省大连市",
"86158837", "四川省绵阳市",
"861767347", "湖南省岳阳市",
"861350562", "安徽省蚌埠市",
"861816894", "江苏省常州市",
"861389752", "青海省海东地区",
"861500991", "新疆乌鲁木齐市",
"861820963", "宁夏吴忠市",
"861777154", "湖北省咸宁市",
"861368439", "四川省阿坝藏族羌族自治州",
"861334640", "广东省珠海市",
"861539635", "福建省漳州市",
"861878740", "云南省曲靖市",
"861452505", "山东省日照市",
"861361814", "四川省阿坝藏族羌族自治州",
"861550482", "内蒙古兴安盟",
"861559073", "吉林省松原市",
"861503130", "河北省承德市",
"861339037", "辽宁省锦州市",
"86185743", "湖南省湘西土家族苗族自治州",
"861773647", "河北省沧州市",
"861528076", "福建省南平市",
"861801083", "安徽省宣城市",
"861394884", "内蒙古乌兰察布市",
"861866613", "广东省珠海市",
"86132654", "广东省深圳市",
"861473572", "山西省朔州市",
"86187280", "四川省德阳市",
"861800734", "湖南省衡阳市",
"861304440", "山西省运城市",
"86135792", "新疆乌鲁木齐市",
"861509435", "江苏省徐州市",
"86135281", "广东省中山市",
"861597690", "广东省汕头市",
"861311693", "云南省怒江傈僳族自治州",
"861830378", "河南省开封市",
"861334402", "重庆市",
"861534629", "河南省鹤壁市",
"861700181", "广东省深圳市",
"86184391", "河南省焦作市",
"861820736", "湖南省常德市",
"861340827", "四川省巴中市",
"861324225", "广东省揭阳市",
"861306323", "安徽省宣城市",
"861590698", "云南省保山市",
"86187287", "四川省巴中市",
"861875973", "福建省三明市",
"861304384", "辽宁省铁岭市",
"861458612", "湖北省荆门市",
"861508074", "湖南省益阳市",
"861519570", "江苏省连云港市",
"861550738", "湖南省娄底市",
"861304602", "山东省济南市",
"861775038", "福建省龙岩市",
"86158830", "四川省泸州市",
"86178222", "天津市",
"861452575", "福建省泉州市",
"861872790", "湖北省鄂州市",
"861475133", "江苏省连云港市",
"861709934", "浙江省嘉兴市",
"861778700", "云南省昆明市",
"861337971", "新疆哈密地区",
"861816726", "浙江省湖州市",
"861513493", "内蒙古鄂尔多斯市",
"861556080", "内蒙古呼伦贝尔市",
"86132020", "广东省广州市",
"861816945", "湖南省怀化市",
"861831274", "广东省揭阳市",
"861367773", "广西桂林市",
"86153197", "陕西省西安市",
"861893389", "广东省阳江市",
"861390470", "内蒙古呼伦贝尔市",
"861535996", "福建省南平市",
"861770651", "浙江省杭州市",
"86155543", "山东省滨州市",
"861813022", "安徽省淮北市",
"861874958", "河南省许昌市",
"861390642", "山东省青岛市",
"861816176", "陕西省汉中市",
"861340759", "江苏省常州市",
"861364647", "山东省东营市",
"86136511", "北京市",
"861772286", "广东省广州市",
"861378507", "河北省秦皇岛市",
"861707372", "河南省安阳市",
"86138357", "山西省临汾市",
"86180770", "广西防城港市",
"861580591", "福建省厦门市",
"861360557", "安徽省宿州市",
"861533062", "吉林省松原市",
"86188867", "贵州省毕节地区",
"861453749", "湖南省长沙市",
"861880865", "湖北省武汉市",
"86189895", "浙江省绍兴市",
"86185310", "河北省邯郸市",
"86136326", "广东省深圳市",
"861362606", "福建省泉州市",
"861816738", "浙江省温州市",
"861500478", "内蒙古巴彦淖尔市",
"861364419", "辽宁省辽阳市",
"861318692", "浙江省台州市",
"86137311", "河北省石家庄市",
"861370414", "辽宁省本溪市",
"86182542", "山东省青岛市",
"86134771", "湖北省宜昌市",
"861335878", "辽宁省丹东市",
"861577168", "陕西省宝鸡市",
"861312400", "福建省福州市",
"861302535", "广东省清远市",
"86137945", "广东省惠州市",
"861800898", "西藏拉萨市",
"861536766", "湖南省张家界市",
"861705672", "山东省济南市",
"861322833", "四川省德阳市",
"86132593", "陕西省榆林市",
"861530678", "浙江省丽水市",
"861760750", "广东省江门市",
"86147975", "青海省西宁市",
"861342285", "广东省深圳市",
"86150512", "江苏省南通市",
"861586909", "浙江省衢州市",
"861569769", "广东省东莞市",
"861550945", "甘肃省金昌市",
"861520019", "河北省邢台市",
"861840661", "广东省广州市",
"861550726", "湖北省荆门市",
"861567081", "河南省驻马店市",
"861534941", "甘肃省庆阳市",
"861337558", "山东省青岛市",
"861810080", "四川省成都市",
"861859240", "陕西省榆林市",
"861886632", "山东省枣庄市",
"861300690", "广西防城港市",
"861318353", "四川省巴中市",
"86130661", "广东省东莞市",
"861839957", "新疆阿克苏地区",
"861820728", "湖北省十堰市",
"861595145", "江苏省宿迁市",
"86133918", "北京市",
"861308765", "陕西省铜川市",
"861862691", "吉林省长春市",
"86150577", "浙江省温州市",
"861814669", "江西省赣州市",
"861330490", "辽宁省铁岭市",
"86159199", "广东省深圳市",
"861863973", "河南省平顶山市",
"861333824", "福建省三明市",
"861380856", "福建省莆田市",
"861882010", "广东省广州市",
"861595976", "福建省南平市",
"861382483", "广东省湛江市",
"861811338", "四川省达州市",
"861550697", "福建省龙岩市",
"861538129", "浙江省湖州市",
"861531427", "山东省淄博市",
"861590737", "湖南省益阳市",
"861596724", "浙江省湖州市",
"861313367", "江西省吉安市",
"861355897", "四川省遂宁市",
"861509983", "广东省揭阳市",
"861886643", "山东省淄博市",
"861806226", "湖北省襄樊市",
"861893810", "广东省河源市",
"861454112", "安徽省蚌埠市",
"861567196", "湖北省孝感市",
"861313426", "辽宁省大连市",
"861840489", "内蒙古锡林郭勒盟",
"861538779", "江西省宜春市",
"861813936", "新疆喀什地区",
"861350095", "吉林省通化市",
"861310413", "辽宁省抚顺市",
"86133282", "福建省福州市",
"861334091", "四川省乐山市",
"861338395", "河南省漯河市",
"86183900", "湖南省岳阳市",
"861317728", "湖北省孝感市",
"861380699", "福建省龙岩市",
"861357407", "湖南省湘潭市",
"861781721", "广东省河源市",
"861877417", "湖南省湘潭市",
"861860663", "浙江省温州市",
"861372114", "安徽省淮南市",
"861393866", "河南省平顶山市",
"861879644", "江苏省连云港市",
"86159766", "广东省佛山市",
"861576852", "广东省惠州市",
"861802019", "江苏省南通市",
"861872811", "四川省内江市",
"861317178", "河北省邯郸市",
"861477731", "广西南宁市",
"861340294", "陕西省西安市",
"86135126", "黑龙江省佳木斯市",
"861771511", "江苏省扬州市",
"861322842", "陕西省铜川市",
"861889738", "青海省玉树藏族自治州",
"861361449", "吉林省白山市",
"861599513", "江苏省扬州市",
"861536485", "山西省长治市",
"861329858", "湖南省衡阳市",
"861558639", "湖北省襄樊市",
"861533410", "湖北省随州市",
"861536194", "广东省湛江市",
"861301723", "湖南省岳阳市",
"861336471", "新疆伊犁哈萨克自治州",
"861817445", "湖南省长沙市",
"861598799", "云南省普洱市",
"861863349", "河北省石家庄市",
"86188417", "辽宁省营口市",
"861503655", "河南省洛阳市",
"86159536", "山东省潍坊市",
"86183371", "河南省郑州市",
"86187451", "黑龙江省哈尔滨市",
"861328503", "福建省泉州市",
"861317736", "湖北省黄冈市",
"861769628", "山西省临汾市",
"861392170", "江苏省泰州市",
"861879516", "宁夏石嘴山市",
"861378912", "湖南省郴州市",
"861598381", "四川省德阳市",
"861314192", "甘肃省天水市",
"86135450", "湖北省武汉市",
"861502736", "湖北省咸宁市",
"861569809", "山东省济宁市",
"861390633", "山东省日照市",
"86188472", "内蒙古包头市",
"861889945", "新疆塔城地区",
"861889726", "青海省玉树藏族自治州",
"861335046", "四川省广安市",
"861832047", "广东省梅州市",
"861336565", "安徽省巢湖市",
"861301173", "山东省济南市",
"861350793", "江西省上饶市",
"861899412", "江苏省南京市",
"861821464", "云南省昆明市",
"861815974", "福建省南平市",
"861364995", "新疆吐鲁番地区",
"861782660", "江苏省连云港市",
"861323099", "河北省邢台市",
"86151527", "江苏省扬州市",
"861360682", "浙江省台州市",
"861450493", "辽宁省丹东市",
"861863836", "河南省洛阳市",
"861454815", "广东省深圳市",
"861303057", "江西省抚州市",
"861807333", "湖南省株洲市",
"861388637", "湖北省孝感市",
"861362718", "湖北省黄冈市",
"861847824", "湖南省娄底市",
"861334521", "山东省淄博市",
"861806238", "湖北省宜昌市",
"861842914", "陕西省商洛市",
"861308486", "陕西省延安市",
"861350525", "江苏省扬州市",
"861347771", "湖北省孝感市",
"861533103", "内蒙古呼和浩特市",
"86181720", "广西南宁市",
"861328340", "河北省邯郸市",
"861322145", "浙江省台州市",
"861885248", "江苏省无锡市",
"861517904", "江西省上饶市",
"861301595", "福建省厦门市",
"86180786", "广西百色市",
"861508566", "贵州省黔东南苗族侗族自治州",
"861811467", "江苏省泰州市",
"861859591", "河南省郑州市",
"861514148", "辽宁省铁岭市",
"861874786", "内蒙古通辽市",
"861813928", "新疆石河子市",
"861874052", "陕西省榆林市",
"861566260", "山东省潍坊市",
"86157019", "新疆阿克苏地区",
"861302904", "吉林省辽源市",
"861570820", "四川省德阳市",
"861880705", "江西省宜春市",
"861452689", "陕西省西安市",
"861856749", "河南省新乡市",
"861588035", "福建省龙岩市",
"861586570", "山东省济宁市",
"861321893", "江苏省宿迁市",
"861313438", "吉林省松原市",
"861700538", "山东省济宁市",
"861347121", "广西柳州市",
"861330959", "宁夏银川市",
"861322976", "广东省珠海市",
"861888611", "贵州省贵阳市",
"861521259", "安徽省黄山市",
"861560363", "黑龙江省牡丹江市",
"861373101", "河北省邯郸市",
"861302974", "黑龙江省齐齐哈尔市",
"861313782", "河南省开封市",
"861370336", "河北省保定市",
"86189909", "四川省宜宾市",
"861313056", "辽宁省营口市",
"861515445", "山东省潍坊市",
"861563921", "河南省鹤壁市",
"861528329", "四川省达州市",
"861572918", "河南省南阳市",
"86176861", "山东省济宁市",
"861324262", "广东省肇庆市",
"86189736", "湖南省常德市",
"861322906", "河北省邢台市",
"861763309", "河北省邯郸市",
"861707530", "山东省济南市",
"861528564", "贵州省贵阳市",
"861886850", "浙江省杭州市",
"861880775", "广西玉林市",
"861301410", "甘肃省嘉峪关市",
"861569157", "陕西省安康市",
"861536876", "云南省文山壮族苗族自治州",
"86177098", "辽宁省大连市",
"861387292", "湖北省荆门市",
"86156083", "重庆市",
"861811285", "江苏省盐城市",
"861870967", "宁夏银川市",
"861894538", "黑龙江省牡丹江市",
"861328484", "内蒙古鄂尔多斯市",
"86181727", "江西省赣州市",
"861859451", "福建省宁德市",
"861322390", "河南省商丘市",
"861777609", "广西桂林市",
"861534754", "广东省清远市",
"861300041", "广东省广州市",
"861831818", "广东省湛江市",
"861850397", "河南省平顶山市",
"861569879", "辽宁省葫芦岛市",
"861306601", "山东省济南市",
"861317963", "江苏省苏州市",
"861801466", "江苏省盐城市",
"861340624", "山东省滨州市",
"86133046", "黑龙江省哈尔滨市",
"861586343", "山东省潍坊市",
"861815904", "福建省漳州市",
"861587248", "湖北省宜昌市",
"861576473", "内蒙古乌海市",
"86151520", "江苏省徐州市",
"861502963", "陕西省渭南市",
"86188410", "辽宁省铁岭市",
"861360374", "河南省许昌市",
"861386658", "安徽省宿州市",
"861780926", "陕西省汉中市",
"861705251", "四川省成都市",
"861831666", "广东省广州市",
"861783913", "河南省许昌市",
"86130066", "广东省深圳市",
"861869499", "江苏省南京市",
"86135457", "湖北省宜昌市",
"861823673", "河南省三门峡市",
"861311189", "四川省成都市",
"861475613", "河北省石家庄市",
"861837532", "安徽省芜湖市",
"861533595", "湖北省咸宁市",
"861328573", "浙江省嘉兴市",
"861318487", "广东省汕尾市",
"861572460", "辽宁省鞍山市",
"861310170", "河南省商丘市",
"861459669", "新疆巴音郭楞蒙古自治州",
"861507633", "河北省石家庄市",
"861328892", "广东省清远市",
"861301968", "辽宁省本溪市",
"86130613", "山东省青岛市",
"861880822", "四川省自贡市",
"86187276", "湖北省荆门市",
"861593193", "河北省唐山市",
"861303427", "浙江省嘉兴市",
"861454643", "云南省西双版纳傣族自治州",
"861303366", "浙江省金华市",
"861536942", "河北省衡水市",
"861537433", "江西省上饶市",
"861816227", "江西省九江市",
"861357477", "湖南省衡阳市",
"861561420", "河北省保定市",
"86183907", "湖南省邵阳市",
"861310720", "湖南省岳阳市",
"861780938", "甘肃省天水市",
"861333627", "山东省德州市",
"861709461", "浙江省绍兴市",
"861335214", "辽宁省本溪市",
"861529350", "甘肃省金昌市",
"86147532", "山东省青岛市",
"86186172", "广东省东莞市",
"861303911", "吉林省长春市",
"861364568", "安徽省阜阳市",
"861858339", "四川省成都市",
"861768323", "四川省南充市",
"861308172", "辽宁省营口市",
"861898681", "湖北省宜昌市",
"86187853", "贵州省安顺市",
"861523303", "河北省张家口市",
"861562203", "广东省茂名市",
"861336998", "新疆喀什地区",
"861476081", "江苏省徐州市",
"861374932", "河南省濮阳市",
"86189566", "安徽省池州市",
"861370328", "河北省保定市",
"861367863", "山东省淄博市",
"861315019", "甘肃省酒泉市",
"86137363", "浙江省温州市",
"861308722", "湖南省湘潭市",
"861824869", "浙江省台州市",
"86152692", "山东省青岛市",
"861824283", "辽宁省辽阳市",
"861803310", "广东省江门市",
"861351541", "山东省济南市",
"86189952", "宁夏石嘴山市",
"861324947", "广东省东莞市",
"861396551", "安徽省黄山市",
"861813763", "河南省驻马店市",
"861473051", "河北省廊坊市",
"861321502", "福建省厦门市",
"861894526", "黑龙江省大庆市",
"86155754", "湖南省衡阳市",
"861332090", "四川省绵阳市",
"861356243", "山东省济宁市",
"86188649", "山东省聊城市",
"861301775", "浙江省嘉兴市",
"861569427", "辽宁省盘锦市",
"861880410", "辽宁省铁岭市",
"861350484", "黑龙江省哈尔滨市",
"86135318", "广东省中山市",
"861501781", "广东省梅州市",
"861365687", "浙江省温州市",
"861862686", "浙江省杭州市",
"861774983", "河北省沧州市",
"86137986", "广东省佛山市",
"861564833", "内蒙古兴安盟",
"861366446", "吉林省白城市",
"86158071", "湖北省武汉市",
"861560887", "云南省迪庆藏族自治州",
"861517250", "湖北省武汉市",
"861776924", "湖南省怀化市",
"861856987", "河南省郑州市",
"86130778", "广东省深圳市",
"861308002", "吉林省长春市",
"861501399", "广东省惠州市",
"861770937", "甘肃省酒泉市",
"861550564", "安徽省六安市",
"86135615", "山东省滨州市",
"861880455", "黑龙江省绥化市",
"861803272", "河北省沧州市",
"86151278", "河北省衡水市",
"861379333", "山东省淄博市",
"86158687", "浙江省温州市",
"861853957", "河南省郑州市",
"86152960", "广西河池市",
"861569366", "甘肃省张掖市",
"861538029", "江苏省连云港市",
"861818394", "云南省普洱市",
"861565085", "安徽省阜阳市",
"861812480", "广东省佛山市",
"861530537", "山东省济宁市",
"861350573", "浙江省嘉兴市",
"861453839", "四川省广元市",
"861820972", "青海省海东地区",
"86184855", "贵州省黔东南苗族侗族自治州",
"861847506", "广东省梅州市",
"861534583", "浙江省嘉兴市",
"861518224", "四川省眉山市",
"861317078", "云南省丽江市",
"861310000", "山西省太原市",
"86181892", "陕西省西安市",
"861521935", "广东省阳江市",
"861802119", "江苏省无锡市",
"861770355", "山西省长治市",
"861816848", "江苏省徐州市",
"861314522", "江苏省徐州市",
"861309649", "四川省绵阳市",
"861459556", "青海省玉树藏族自治州",
"861511354", "广东省阳江市",
"861576753", "广东省江门市",
"86188166", "上海市",
"861580586", "浙江省台州市",
"86134668", "山西省太原市",
"861781687", "浙江省杭州市",
"861380327", "河北省保定市",
"86184244", "辽宁省本溪市",
"861342109", "广东省潮州市",
"861770310", "河北省邯郸市",
"861339449", "吉林省长春市",
"86183910", "陕西省咸阳市",
"861533705", "甘肃省陇南市",
"861351435", "吉林省通化市",
"861539050", "甘肃省武威市",
"861809431", "江苏省盐城市",
"861880968", "宁夏银川市",
"861521748", "广东省东莞市",
"861330388", "河南省洛阳市",
"86180695", "浙江省绍兴市",
"861340356", "山西省晋城市",
"861335146", "黑龙江省黑河市",
"861301073", "湖南省岳阳市",
"86770", "广西防城港市",
"86182937", "甘肃省酒泉市",
"861571265", "浙江省台州市",
"861339617", "湖北省随州市",
"861834482", "江苏省扬州市",
"861512644", "云南省红河哈尼族彝族自治州",
"861778999", "西藏拉萨市",
"861582917", "陕西省商洛市",
"86177273", "广东省佛山市",
"861452851", "甘肃省酒泉市",
"861539015", "四川省德阳市",
"861350892", "山东省聊城市",
"861816564", "广东省江门市",
"861768305", "四川省雅安市",
"861535981", "福建省莆田市",
"86188407", "辽宁省营口市",
"861335975", "黑龙江省齐齐哈尔市",
"861523325", "河北省唐山市",
"861309417", "湖北省宜昌市",
"861804682", "江西省九江市",
"86180398", "福建省龙岩市",
"861855840", "浙江省嘉兴市",
"861800995", "新疆吐鲁番地区",
"861367387", "河南省周口市",
"861588135", "四川省宜宾市",
"861890344", "山西省晋中市",
"861339278", "广东省佛山市",
"861587759", "陕西省汉中市",
"861373071", "四川省绵阳市",
"86139861", "湖北省武汉市",
"861576010", "四川省乐山市",
"86182028", "四川省成都市",
"86186882", "广东省佛山市",
"861862395", "河南省漯河市",
"861868190", "陕西省榆林市",
"861346744", "湖南省张家界市",
"86189351", "山西省太原市",
"861786625", "湖北省随州市",
"861322045", "甘肃省兰州市",
"861700196", "广东省广州市",
"861775207", "甘肃省庆阳市",
"861321792", "江西省九江市",
"861820339", "河北省沧州市",
"861576055", "四川省南充市",
"861332520", "山东省淄博市",
"861572632", "山东省枣庄市",
"861872979", "陕西省铜川市",
"861313269", "广西北海市",
"861822758", "四川省雅安市",
"861300141", "河北省唐山市",
"861775277", "湖南省衡阳市",
"861324391", "辽宁省锦州市",
"861319416", "辽宁省锦州市",
"861313883", "广东省东莞市",
"861538459", "陕西省铜川市",
"861552082", "四川省成都市",
"861811654", "四川省攀枝花市",
"861369655", "安徽省宿州市",
"861324789", "江西省赣州市",
"861533822", "广东省汕头市",
"861836669", "山东省枣庄市",
"861339208", "广东省江门市",
"861500986", "辽宁省营口市",
"861569057", "河北省张家口市",
"861393379", "河北省秦皇岛市",
"861890480", "黑龙江省哈尔滨市",
"86158136", "广东省佛山市",
"861532549", "浙江省湖州市",
"861885827", "浙江省杭州市",
"861899820", "广东省汕头市",
"861853011", "河南省开封市",
"86189919", "陕西省西安市",
"861868345", "四川省凉山彝族自治州",
"861528697", "河南省安阳市",
"861705663", "湖北省恩施土家族苗族自治州",
"861557840", "广西梧州市",
"861369610", "四川省泸州市",
"861303809", "山西省大同市",
"861553635", "山西省晋中市",
"861768375", "湖北省鄂州市",
"861311089", "福建省福州市",
"86151976", "湖南省常德市",
"861327646", "山东省潍坊市",
"861362527", "江苏省苏州市",
"861335905", "安徽省马鞍山市",
"861478374", "河南省许昌市",
"861824990", "广西北海市",
"861571487", "内蒙古鄂尔多斯市",
"86188400", "辽宁省沈阳市",
"861873538", "山西省太原市",
"861834738", "内蒙古通辽市",
"861337380", "浙江省金华市",
"861891248", "江苏省无锡市",
"86137288", "广东省深圳市",
"861375983", "陕西省咸阳市",
"861333064", "四川省遂宁市",
"861554308", "吉林省松原市",
"861570412", "辽宁省鞍山市",
"861875247", "江苏省南通市",
"861372246", "河北省廊坊市",
"861894804", "广东省清远市",
"861518694", "贵州省黔东南苗族侗族自治州",
"861760633", "山东省日照市",
"861893422", "广东省湛江市",
"86145449", "湖北省武汉市",
"861882630", "广东省佛山市",
"861333399", "河南省许昌市",
"861590644", "浙江省丽水市",
"861898859", "广东省中山市",
"861305480", "山东省莱芜市",
"861592987", "陕西省咸阳市",
"86183917", "陕西省宝鸡市",
"861327514", "江苏省扬州市",
"861880723", "湖北省黄石市",
"86139463", "黑龙江省牡丹江市",
"861533775", "江西省南昌市",
"861328793", "山东省菏泽市",
"861333781", "江苏省南京市",
"86184849", "贵州省贵阳市",
"861342179", "广东省云浮市",
"86135479", "四川省成都市",
"861815250", "宁夏银川市",
"861582051", "广东省中山市",
"861870513", "江苏省连云港市",
"861505560", "安徽省蚌埠市",
"861457027", "江西省赣州市",
"861847576", "广东省中山市",
"861895141", "江苏省南通市",
"861593093", "河北省邢台市",
"861820902", "新疆哈密地区",
"861330235", "广东省清远市",
"861335680", "山东省威海市",
"861850941", "甘肃省甘南藏族自治州",
"861520639", "山东省临沂市",
"86183972", "湖南省郴州市",
"861530880", "云南省昆明市",
"861317008", "安徽省阜阳市",
"861533125", "河南省新乡市",
"861336751", "广西南宁市",
"86138504", "福建省漳州市",
"861310070", "湖北省武汉市",
"861800568", "安徽省阜阳市",
"861812344", "四川省甘孜藏族自治州",
"86152967", "山西省运城市",
"86188655", "山东省烟台市",
"86158680", "浙江省温州市",
"861479927", "新疆乌鲁木齐市",
"861317517", "浙江省宁波市",
"861560530", "山东省菏泽市",
"861315119", "江苏省苏州市",
"861348334", "河北省张家口市",
"861350340", "河南省商丘市",
"861580861", "云南省昭通市",
"861301705", "贵州省黔西南布依族苗族自治州",
"861859701", "青海省西宁市",
"861308823", "四川省内江市",
"861476181", "江苏省淮安市",
"861539331", "甘肃省平凉市",
"861338040", "广东省汕头市",
"861347451", "陕西省西安市",
"861534404", "内蒙古鄂尔多斯市",
"86188358", "山西省吕梁市",
"861813862", "广东省韶关市",
"861898727", "云南省昆明市",
"861880595", "福建省泉州市",
"861707363", "河南省郑州市",
"861823625", "河南省信阳市",
"861829742", "安徽省安庆市",
"861775706", "浙江省宁波市",
"861779059", "四川省内江市",
"86150926", "山东省济宁市",
"861335534", "山东省德州市",
"861572815", "广东省惠州市",
"861538990", "新疆阿勒泰地区",
"861857265", "湖北省荆门市",
"861301162", "山东省淄博市",
"861332929", "安徽省宣城市",
"861346951", "宁夏银川市",
"861844745", "内蒙古乌兰察布市",
"861331351", "山西省太原市",
"861337819", "四川省达州市",
"861316521", "山东省枣庄市",
"861585569", "安徽省淮南市",
"861500347", "山西省临汾市",
"86151980", "四川省成都市",
"861317902", "吉林省四平市",
"86181955", "宁夏中卫市",
"861829733", "安徽省蚌埠市",
"861572850", "广东省汕尾市",
"86176401", "辽宁省沈阳市",
"861898696", "湖北省荆门市",
"861524197", "辽宁省辽阳市",
"86153735", "河北省唐山市",
"861538306", "河北省廊坊市",
"861764552", "黑龙江省绥化市",
"861893287", "河北省承德市",
"861556646", "辽宁省葫芦岛市",
"861778590", "贵州省黔南布依族苗族自治州",
"861893501", "山西省忻州市",
"861819012", "四川省巴中市",
"861322488", "内蒙古巴彦淖尔市",
"861867209", "湖北省宜昌市",
"86158599", "福建省南平市",
"861582893", "四川省巴中市",
"861824459", "河北省邢台市",
"861831915", "广东省茂名市",
"861562947", "湖北省咸宁市",
"861826648", "山东省青岛市",
"861560684", "浙江省宁波市",
"861314565", "安徽省合肥市",
"861591656", "广东省佛山市",
"861897045", "江西省吉安市",
"861560302", "广东省深圳市",
"861367453", "黑龙江省牡丹江市",
"861583378", "河北省沧州市",
"861378797", "湖南省张家界市",
"861882473", "广东省中山市",
"861514194", "辽宁省辽阳市",
"861570060", "四川省成都市",
"86187821", "四川省成都市",
"861761489", "内蒙古呼和浩特市",
"86186816", "四川省绵阳市",
"861308978", "黑龙江省双鸭山市",
"861320531", "山东省济南市",
"861831950", "广东省河源市",
"861580701", "江西省鹰潭市",
"86180759", "湖南省邵阳市",
"861376854", "广西南宁市",
"861894218", "湖北省十堰市",
"861760470", "内蒙古呼伦贝尔市",
"861321563", "安徽省宣城市",
"861333576", "浙江省台州市",
"86139813", "四川省乐山市",
"861825243", "江苏省徐州市",
"86137977", "湖北省襄樊市",
"861582572", "浙江省嘉兴市",
"861341480", "广东省揭阳市",
"861346578", "山东省济宁市",
"861780835", "四川省雅安市",
"861592839", "四川省巴中市",
"861500758", "广东省肇庆市",
"861760642", "山东省青岛市",
"861562262", "广东省肇庆市",
"86137912", "山东省烟台市",
"861379890", "广东省东莞市",
"86158676", "浙江省台州市",
"861521483", "新疆乌鲁木齐市",
"861778020", "四川省绵阳市",
"861598970", "广东省汕头市",
"861816006", "四川省泸州市",
"861315984", "黑龙江省哈尔滨市",
"861860672", "浙江省湖州市",
"861884957", "河北省沧州市",
"861476526", "河南省郑州市",
"861858178", "四川省资阳市",
"861302441", "江苏省常州市",
"861389853", "辽宁省丹东市",
"86150545", "山东省烟台市",
"861339814", "四川省眉山市",
"861512847", "河北省保定市",
"861501506", "广东省韶关市",
"861340248", "河北省石家庄市",
"861396722", "浙江省舟山市",
"861361037", "广东省湛江市",
"861786662", "山东省青岛市",
"861858728", "云南省丽江市",
"861811109", "四川省眉山市",
"861365492", "辽宁省大连市",
"861458938", "广东省清远市",
"861587624", "广东省河源市",
"861470439", "吉林省白山市",
"861308551", "安徽省合肥市",
"86153565", "浙江省台州市",
"861370739", "湖南省邵阳市",
"861530319", "河北省邢台市",
"861528726", "云南省西双版纳傣族自治州",
"861844938", "新疆昌吉回族自治州",
"861840322", "河北省保定市",
"861364734", "湖南省衡阳市",
"861528945", "陕西省西安市",
"861558019", "湖南省湘潭市",
"861774435", "四川省宜宾市",
"86138418", "辽宁省阜新市",
"86185458", "黑龙江省哈尔滨市",
"861323683", "辽宁省鞍山市",
"861338691", "福建省莆田市",
"861811179", "四川省达州市",
"861700677", "浙江省宁波市",
"861345125", "湖北省十堰市",
"861508724", "云南省楚雄彝族自治州",
"861522995", "陕西省宝鸡市",
"861867448", "湖南省长沙市",
"861821854", "广东省深圳市",
"861808885", "广东省梅州市",
"861397347", "湖南省永州市",
"861533865", "贵州省黔东南苗族侗族自治州",
"861308491", "广西南宁市",
"861454460", "陕西省西安市",
"861769244", "河北省承德市",
"861321151", "广西柳州市",
"86137094", "重庆市",
"861893958", "河南省漯河市",
"861860602", "福建省福州市",
"86187423", "辽宁省盘锦市",
"861329468", "山西省临汾市",
"86152715", "湖北省黄冈市",
"861534397", "河南省信阳市",
"861572643", "山东省淄博市",
"861770889", "云南省丽江市",
"861589299", "四川省达州市",
"861365552", "安徽省蚌埠市",
"861560939", "甘肃省陇南市",
"861354760", "四川省攀枝花市",
"861828474", "四川省泸州市",
"861452093", "安徽省宣城市",
"861850754", "广东省汕头市",
"861331030", "内蒙古鄂尔多斯市",
"861308163", "山东省烟台市",
"861346508", "山东省滨州市",
"861341344", "广东省汕头市",
"86136501", "广东省东莞市",
"86151364", "河南省郑州市",
"861816076", "江西省吉安市",
"861889329", "甘肃省酒泉市",
"86180745", "湖南省怀化市",
"86156997", "北京市",
"861317846", "广东省清远市",
"861535212", "甘肃省武威市",
"861564976", "河南省三门峡市",
"861866042", "山东省济南市",
"861472619", "四川省成都市",
"861453987", "广东省清远市",
"861326392", "江西省九江市",
"861580771", "广西南宁市",
"86138379", "河南省洛阳市",
"861363435", "吉林省通化市",
"86147940", "广东省广州市",
"861502846", "河北省邯郸市",
"861380785", "广西玉林市",
"861317339", "山东省菏泽市",
"861773734", "河南省新乡市",
"86183765", "广西玉林市",
"86137970", "湖北省武汉市",
"861802984", "广东省肇庆市",
"861598396", "四川省巴中市",
"861359297", "广东省茂名市",
"861528894", "山东省淄博市",
"86185971", "青海省西宁市",
"861815441", "湖北省武汉市",
"861800647", "山东省东营市",
"861893465", "湖北省黄冈市",
"861510346", "山西省太原市",
"861560372", "河南省安阳市",
"861581390", "广东省汕尾市",
"861342654", "江西省赣州市",
"861329955", "宁夏中卫市",
"861899160", "陕西省汉中市",
"86135827", "河北省沧州市",
"861509541", "甘肃省兰州市",
"861800419", "辽宁省辽阳市",
"861475735", "浙江省嘉兴市",
"861555265", "山东省泰安市",
"861314401", "广东省中山市",
"861477841", "广东省东莞市",
"861315639", "山东省青岛市",
"861398671", "湖北省荆州市",
"861867279", "湖北省武汉市",
"861598685", "广东省汕头市",
"861364898", "西藏拉萨市",
"861893571", "新疆石河子市",
"86185300", "河南省郑州市",
"861848918", "西藏日喀则地区",
"861889848", "广东省中山市",
"861871840", "广东省广州市",
"861533162", "云南省临沧市",
"861340409", "四川省泸州市",
"861571692", "河北省保定市",
"86183535", "山东省烟台市",
"861452523", "山东省临沂市",
"861345073", "广东省梅州市",
"861830619", "江苏省无锡市",
"861368714", "湖北省咸宁市",
"861700764", "广东省中山市",
"861590847", "四川省南充市",
"861820078", "广东省中山市",
"861569282", "四川省南充市",
"86188799", "江西省萍乡市",
"861356232", "山东省滨州市",
"861395647", "安徽省淮北市",
"86139411", "辽宁省大连市",
"861538376", "河北省廊坊市",
"861334752", "广西柳州市",
"861576462", "黑龙江省齐齐哈尔市",
"861334086", "四川省德阳市",
"861771231", "江苏省常州市",
"861564842", "内蒙古巴彦淖尔市",
"861452795", "新疆乌鲁木齐市",
"86133908", "江苏省苏州市",
"861528482", "四川省自贡市",
"86151987", "云南省昆明市",
"861317972", "江苏省徐州市",
"861367725", "湖北省荆门市",
"861596566", "山东省菏泽市",
"861595045", "江苏省南京市",
"86136118", "上海市",
"861502972", "陕西省榆林市",
"861532940", "贵州省贵阳市",
"861389472", "吉林省吉林市",
"861380083", "四川省泸州市",
"861507013", "江西省新余市",
"861328562", "安徽省铜陵市",
"861571353", "山西省阳泉市",
"861567181", "湖北省咸宁市",
"861379342", "山东省日照市",
"86150502", "江苏省苏州市",
"86182496", "黑龙江省大庆市",
"861376582", "贵州省贵阳市",
"86184673", "青海省西宁市",
"861502718", "湖北省恩施土家族苗族自治州",
"861568486", "新疆喀什地区",
"861771521", "江苏省盐城市",
"86151376", "河南省信阳市",
"86155190", "贵州省贵阳市",
"861819165", "陕西省西安市",
"861810048", "吉林省长春市",
"861879096", "河南省濮阳市",
"861824984", "黑龙江省大庆市",
"86152428", "辽宁省鞍山市",
"861898528", "贵州省黔东南苗族侗族自治州",
"861558283", "山西省晋城市",
"861813460", "安徽省宿州市",
"861802029", "江苏省无锡市",
"861872821", "四川省阿坝藏族羌族自治州",
"861357901", "新疆巴音郭楞蒙古自治州",
"861529286", "新疆乌鲁木齐市",
"861368566", "安徽省六安市",
"861372124", "安徽省马鞍山市",
"861800767", "广东省汕尾市",
"861561595", "山东省烟台市",
"861595663", "安徽省池州市",
"861377937", "新疆哈密地区",
"86182330", "河北省邢台市",
"86170078", "广东省珠海市",
"861390863", "湖北省武汉市",
"861317718", "湖北省随州市",
"861881530", "山东省菏泽市",
"861877427", "湖南省郴州市",
"861781711", "广东省佛山市",
"861524339", "河北省承德市",
"861323519", "江苏省常州市",
"861879538", "宁夏银川市",
"861314243", "内蒙古包头市",
"861454772", "山东省枣庄市",
"861537730", "湖南省岳阳市",
"86133792", "陕西省西安市",
"861301050", "海南省海口市",
"861568805", "贵州省黔东南苗族侗族自治州",
"861310423", "辽宁省抚顺市",
"861335913", "陕西省渭南市",
"861850378", "河南省开封市",
"861319883", "四川省宜宾市",
"861313416", "辽宁省锦州市",
"861539073", "江西省赣州市",
"861530482", "黑龙江省齐齐哈尔市",
"861566087", "河南省焦作市",
"861810933", "甘肃省平凉市",
"86183743", "湖南省湘西土家族苗族自治州",
"861590874", "云南省曲靖市",
"861814987", "新疆和田地区",
"861532359", "广东省肇庆市",
"861365711", "湖北省鄂州市",
"861700516", "江苏省徐州市",
"861848772", "云南省玉溪市",
"861520376", "河南省信阳市",
"861319269", "广东省佛山市",
"861566671", "山东省枣庄市",
"861559635", "陕西省商洛市",
"861362736", "湖南省常德市",
"861363610", "湖北省黄冈市",
"861816608", "江西省赣州市",
"861857996", "广西百色市",
"861301015", "山东省淄博市",
"861319156", "内蒙古锡林郭勒盟",
"861890494", "辽宁省本溪市",
"86189319", "河北省邢台市",
"861454122", "河北省保定市",
"861806216", "湖北省恩施土家族苗族自治州",
"861452233", "浙江省湖州市",
"86180763", "广西南宁市",
"861500682", "山东省莱芜市",
"861527998", "江西省景德镇市",
"861330562", "安徽省铜陵市",
"861862445", "辽宁省阜新市",
"861531417", "山东省聊城市",
"861830583", "浙江省嘉兴市",
"861887158", "湖北省武汉市",
"861471468", "广东省江门市",
"861315459", "黑龙江省大庆市",
"861826046", "江苏省苏州市",
"861524972", "河南省新乡市",
"861320691", "黑龙江省绥化市",
"86152367", "河南省信阳市",
"861366900", "湖北省襄樊市",
"861350550", "安徽省滁州市",
"861813918", "新疆和田地区",
"861554299", "辽宁省铁岭市",
"86145080", "江苏省南京市",
"861818444", "贵州省毕节地区",
"861576120", "贵州省黔南布依族苗族自治州",
"86157689", "广东省广州市",
"861570810", "四川省遂宁市",
"861700644", "四川省成都市",
"86180296", "广东省江门市",
"861805863", "浙江省嘉兴市",
"86187647", "山东省潍坊市",
"86188634", "山东省莱芜市",
"861317264", "广东省肇庆市",
"861819862", "贵州省贵阳市",
"86188958", "云南省临沧市",
"861570855", "贵州省黔东南苗族侗族自治州",
"861778630", "湖北省鄂州市",
"861847137", "湖北省恩施土家族苗族自治州",
"861847814", "湖南省常德市",
"861334511", "山东省济南市",
"861533331", "河北省石家庄市",
"861508147", "河北省沧州市",
"861576770", "广东省梅州市",
"861366396", "河南省驻马店市",
"861501449", "广东省云浮市",
"86180533", "山东省淄博市",
"861337069", "山东省淄博市",
"861866301", "山东省聊城市",
"861869247", "湖南省益阳市",
"861305494", "山东省临沂市",
"861454825", "广东省湛江市",
"861339781", "广西南宁市",
"861890882", "云南省德宏傣族景颇族自治州",
"861898536", "贵州省毕节地区",
"861539775", "四川省雅安市",
"861517273", "湖北省咸宁市",
"861399932", "新疆石河子市",
"861518905", "江苏省宿迁市",
"861353796", "广东省阳江市",
"861830474", "内蒙古乌兰察布市",
"861453496", "内蒙古赤峰市",
"861864887", "广西柳州市",
"86188471", "内蒙古呼和浩特市",
"86132140", "内蒙古呼和浩特市",
"861339399", "河南省驻马店市",
"861860833", "四川省乐山市",
"861821149", "广东省中山市",
"86178637", "山东省枣庄市",
"861336977", "青海省海西蒙古族藏族自治州",
"861539125", "内蒙古鄂尔多斯市",
"86187452", "黑龙江省齐齐哈尔市",
"861802599", "广东省佛山市",
"861568102", "四川省德阳市",
"86183372", "河南省安阳市",
"861356092", "广东省肇庆市",
"861769618", "山西省临汾市",
"861879526", "宁夏中卫市",
"861854564", "黑龙江省黑河市",
"861378922", "湖南省永州市",
"861512196", "宁夏石嘴山市",
"861800674", "浙江省宁波市",
"861550608", "吉林省松原市",
"861557670", "湖南省衡阳市",
"861822557", "安徽省宿州市",
"861325556", "山东省青岛市",
"861533420", "湖北省仙桃市",
"861760387", "河南省郑州市",
"861572065", "江苏省苏州市",
"861301713", "湖南省株洲市",
"861302273", "山东省烟台市",
"861878432", "四川省内江市",
"861820606", "福建省厦门市",
"861355808", "广西河池市",
"861518146", "四川省达州市",
"861303649", "四川省宜宾市",
"861800604", "福建省泉州市",
"86131233", "福建省漳州市",
"861475623", "河北省保定市",
"861334688", "河南省驻马店市",
"861507289", "湖北省荆门市",
"861305554", "福建省三明市",
"861832659", "安徽省马鞍山市",
"861780916", "陕西省汉中市",
"861876245", "江苏省无锡市",
"861327485", "内蒙古通辽市",
"86183310", "河北省保定市",
"861318981", "广东省湛江市",
"861391200", "江苏省徐州市",
"861340614", "山东省东营市",
"861770545", "山东省烟台市",
"861505101", "江苏省宿迁市",
"861304488", "湖北省荆门市",
"861884861", "贵州省毕节地区",
"861301331", "云南省昆明市",
"861459346", "四川省凉山彝族自治州",
"86178630", "山东省威海市",
"861336907", "新疆巴音郭楞蒙古自治州",
"861831828", "广东省惠州市",
"86150733", "湖南省株洲市",
"861814258", "四川省自贡市",
"861886825", "浙江省温州市",
"861593242", "河北省衡水市",
"861815273", "湖南省怀化市",
"86187640", "山东省济南市",
"86137386", "浙江省台州市",
"861571532", "山东省青岛市",
"86189583", "浙江省宁波市",
"861367633", "山东省日照市",
"861332084", "四川省资阳市",
"861855442", "山东省菏泽市",
"86135918", "辽宁省朝阳市",
"861315599", "江西省赣州市",
"86156613", "内蒙古包头市",
"861354186", "四川省广安市",
"861769207", "河北省衡水市",
"861576700", "广东省深圳市",
"861870575", "浙江省绍兴市",
"861521547", "山东省济宁市",
"861885034", "福建省厦门市",
"861524902", "陕西省榆林市",
"861563366", "河北省石家庄市",
"86152360", "河南省南阳市",
"861859957", "福建省莆田市",
"861317197", "河北省秦皇岛市",
"861458665", "湖南省郴州市",
"86132885", "广东省揭阳市",
"861373333", "河北省唐山市",
"861310053", "广西桂林市",
"861880150", "江苏省常州市",
"861301420", "宁夏石嘴山市",
"861812494", "广东省广州市",
"861806044", "福建省莆田市",
"861818380", "云南省临沧市",
"861812185", "四川省德阳市",
"861530945", "甘肃省金昌市",
"86145087", "上海市",
"861824639", "黑龙江省佳木斯市",
"861530726", "湖北省恩施土家族苗族自治州",
"861708579", "江苏省淮安市",
"861572928", "河南省周口市",
"86176862", "山东省泰安市",
"86189951", "宁夏银川市",
"861588430", "四川省眉山市",
"861365333", "河北省邢台市",
"861379071", "广东省中山市",
"861894516", "黑龙江省黑河市",
"861566601", "山东省济南市",
"86759", "广东省湛江市",
"861308712", "内蒙古呼和浩特市",
"861333278", "广东省潮州市",
"861575911", "福建省漳州市",
"861520990", "新疆克拉玛依市",
"86188873", "云南省红河哈尼族彝族自治州",
"861810766", "广东省云浮市",
"86152691", "山东省济南市",
"861803320", "广东省佛山市",
"861857370", "湖南省益阳市",
"861500374", "河南省许昌市",
"861882999", "广东省广州市",
"861324441", "吉林省长春市",
"861572936", "河南省郑州市",
"861888291", "四川省阿坝藏族羌族自治州",
"861568875", "山东省莱芜市",
"861586061", "福建省漳州市",
"861454702", "浙江省宁波市",
"861530738", "湖南省娄底市",
"861370318", "河北省衡水市",
"861320221", "广东省揭阳市",
"861368881", "广东省深圳市",
"861315029", "新疆喀什地区",
"86184708", "江西省南昌市",
"861332761", "青海省海西蒙古族藏族自治州",
"861890554", "安徽省淮南市",
"861590804", "山东省菏泽市",
"861768313", "四川省自贡市",
"861394560", "黑龙江省大庆市",
"861588321", "四川省资阳市",
"86182337", "河北省沧州市",
"861843407", "山西省临汾市",
"861477323", "湖南省湘潭市",
"86186171", "广东省深圳市",
"861303921", "吉林省长春市",
"861831349", "云南省德宏傣族景颇族自治州",
"861788909", "西藏那曲地区",
"861803431", "河北省张家口市",
"861309157", "黑龙江省鸡西市",
"86131679", "重庆市",
"86138725", "湖北省宜昌市",
"861310710", "湖南省岳阳市",
"86130083", "重庆市",
"861831836", "广东省河源市",
"86155197", "贵州省毕节地区",
"861340546", "山东省东营市",
"861880812", "四川省广元市",
"861883076", "河北省保定市",
"861303417", "甘肃省平凉市",
"861457117", "湖北省随州市",
"861555996", "云南省曲靖市",
"861709967", "浙江省金华市",
"861760762", "广东省河源市",
"861310755", "青海省西宁市",
"861357971", "新疆伊犁哈萨克自治州",
"861338531", "山东省济南市",
"861513811", "河南省驻马店市",
"861557985", "江西省赣州市",
"861899786", "新疆阿克苏地区",
"861817040", "江西省南昌市",
"861572592", "山东省济宁市",
"861580957", "宁夏银川市",
"86156397", "河南省郑州市",
"861564672", "山东省济宁市",
"861819122", "陕西省榆林市",
"861327766", "湖北省荆门市",
"86134710", "广西南宁市",
"861388664", "湖北省荆州市",
"861590677", "浙江省温州市",
"861356565", "新疆喀什地区",
"861330793", "江西省上饶市",
"861355046", "四川省巴中市",
"861305307", "安徽省淮南市",
"861389870", "辽宁省盘锦市",
"861501814", "广东省阳江市",
"86185371", "河南省郑州市",
"861328235", "浙江省舟山市",
"861390075", "海南省海口市",
"86186474", "内蒙古乌兰察布市",
"861838902", "西藏日喀则地区",
"861339506", "福建省泉州市",
"861869925", "新疆哈密地区",
"861869746", "内蒙古乌海市",
"86137370", "广西南宁市",
"861556485", "山东省青岛市",
"861779734", "青海省海西蒙古族藏族自治州",
"861889217", "陕西省宝鸡市",
"861368004", "广东省清远市",
"86147340", "重庆市",
"861528880", "山东省日照市",
"861369435", "吉林省通化市",
"861556194", "黑龙江省牡丹江市",
"861811434", "江苏省宿迁市",
"86138979", "辽宁省沈阳市",
"861538639", "湖南省邵阳市",
"861802990", "广东省中山市",
"861818819", "贵州省黔西南布依族苗族自治州",
"861576860", "广东省茂名市",
"861384796", "内蒙古赤峰市",
"861805123", "江苏省苏州市",
"861321411", "辽宁省大连市",
"86992", "新疆伊犁哈萨克自治州",
"861477087", "江西省九江市",
"861345420", "浙江省台州市",
"861519061", "江苏省泰州市",
"861350959", "福建省宁德市",
"861365342", "山西省大同市",
"861898144", "四川省内江市",
"861580335", "河北省秦皇岛市",
"86152741", "湖南省郴州市",
"861395159", "江苏省宿迁市",
"861871442", "黑龙江省牡丹江市",
"86186631", "山东省威海市",
"861860390", "河南省平顶山市",
"861760453", "黑龙江省牡丹江市",
"861881372", "广东省中山市",
"861892267", "广东省揭阳市",
"861321927", "四川省广安市",
"861454165", "浙江省绍兴市",
"861323468", "黑龙江省鹤岗市",
"861708396", "河南省驻马店市",
"861769126", "陕西省汉中市",
"861773429", "河北省石家庄市",
"861825092", "福建省宁德市",
"861899958", "新疆伊犁哈萨克自治州",
"861302789", "贵州省安顺市",
"861860906", "新疆阿勒泰地区",
"861330525", "江苏省扬州市",
"86151387", "河南省洛阳市",
"861571543", "山东省滨州市",
"86135282", "广东省中山市",
"861317676", "山东省济宁市",
"861379552", "四川省眉山市",
"86187790", "江西省赣州市",
"861865236", "江苏省泰州市",
"861354091", "四川省乐山市",
"861563282", "河北省唐山市",
"861532476", "河南省南阳市",
"861866623", "广东省阳江市",
"861520459", "黑龙江省大庆市",
"861840200", "广东省广州市",
"861882450", "广东省中山市",
"861344899", "新疆乌鲁木齐市",
"861769138", "陕西省安康市",
"861864302", "吉林省通化市",
"861383472", "山西省运城市",
"861800877", "云南省玉溪市",
"861890307", "广东省广州市",
"861868919", "西藏拉萨市",
"86139445", "吉林省通化市",
"861530697", "福建省福州市",
"861360408", "辽宁省大连市",
"861367470", "内蒙古呼伦贝尔市",
"861810485", "内蒙古呼和浩特市",
"861390773", "广西桂林市",
"861874060", "陕西省西安市",
"861861771", "河北省沧州市",
"861399456", "山西省晋中市",
"861370054", "山西省太原市",
"861313334", "山西省忻州市",
"861571300", "河北省邯郸市",
"861893160", "河北省邯郸市",
"861454862", "河南省信阳市",
"86183554", "安徽省淮南市",
"861478347", "河南省南阳市",
"861323955", "宁夏中卫市",
"861785824", "浙江省台州市",
"861471519", "广东省东莞市",
"861573398", "河北省唐山市",
"861700847", "浙江省嘉兴市",
"861590764", "广东省中山市",
"861561062", "山东省潍坊市",
"861336512", "江苏省扬州市",
"861778155", "四川省成都市",
"861323910", "陕西省咸阳市",
"861512607", "云南省丽江市",
"861539162", "湖北省黄冈市",
"861572873", "广东省广州市",
"86157597", "福建省泉州市",
"861524008", "安徽省阜阳市",
"8615800", "上海市",
"861571996", "新疆克拉玛依市",
"861883848", "河南省平顶山市",
"861378965", "内蒙古通辽市",
"861510556", "安徽省安庆市",
"861800159", "江苏省南京市",
"861309769", "山西省大同市",
"861353627", "广东省惠州市",
"861880635", "山东省聊城市",
"86136512", "北京市",
"861365890", "西藏拉萨市",
"861524078", "广西桂林市",
"861399943", "新疆和田地区",
"861376368", "黑龙江省鹤岗市",
"861872553", "安徽省芜湖市",
"861894847", "广东省梅州市",
"86177794", "江西省抚州市",
"861860842", "湖南省郴州市",
"861560690", "福建省厦门市",
"861394969", "河南省焦作市",
"861810876", "云南省文山壮族苗族自治州",
"86185907", "陕西省宝鸡市",
"861304743", "山东省日照市",
"861361796", "江西省吉安市",
"861571370", "河南省商丘市",
"861771186", "宁夏固原市",
"861332230", "辽宁省营口市",
"861878443", "四川省眉山市",
"861532885", "四川省南充市",
"861514180", "辽宁省阜新市",
"861332871", "福建省漳州市",
"861383402", "山西省大同市",
"861345015", "广东省肇庆市",
"861500557", "安徽省宿州市",
"86181934", "甘肃省庆阳市",
"86181658", "广东省茂名市",
"861479792", "江西省九江市",
"861846303", "山东省日照市",
"86147713", "广东省广州市",
"861346777", "湖南省衡阳市",
"86153754", "安徽省合肥市",
"861390703", "江西省上饶市",
"8618622", "天津市",
"86150326", "河北省石家庄市",
"861803964", "河南省洛阳市",
"861360478", "内蒙古巴彦淖尔市",
"86183828", "四川省巴中市",
"861511778", "贵州省安顺市",
"861835261", "江苏省泰州市",
"861840831", "四川省内江市",
"861773059", "河北省邯郸市",
"861331541", "河北省保定市",
"861890377", "河南省南阳市",
"861760872", "云南省大理白族自治州",
"861340817", "四川省南充市",
"86134343", "广东省广州市",
"861358140", "湖北省随州市",
"861324215", "广东省江门市",
"861317606", "山东省潍坊市",
"86139459", "黑龙江省大庆市",
"86187797", "江西省赣州市",
"861378028", "河北省衡水市",
"86131865", "江苏省南通市",
"861458622", "湖北省十堰市",
"861898992", "西藏日喀则地区",
"86151380", "河南省焦作市",
"861399596", "湖北省黄石市",
"861345050", "广东省阳江市",
"861776089", "安徽省宣城市",
"861532406", "河北省承德市",
"86184392", "河南省安阳市",
"861316760", "安徽省池州市",
"861814839", "内蒙古呼和浩特市",
"861597255", "湖北省鄂州市",
"861839451", "甘肃省兰州市",
"861304045", "新疆巴音郭楞蒙古自治州",
"861518534", "贵州省遵义市",
"861386156", "江苏省淮安市",
"861826878", "浙江省绍兴市",
"861871600", "河北省秦皇岛市",
"861333814", "江苏省扬州市",
"861327048", "江苏省徐州市",
"861596047", "福建省宁德市",
"861315990", "黑龙江省双鸭山市",
"861760593", "福建省宁德市",
"861881684", "广东省汕头市",
"86183693", "山东省临沂市",
"861860976", "青海省玉树藏族自治州",
"861534447", "湖南省郴州市",
"861378598", "河北省邢台市",
"861355768", "广西南宁市",
"861366579", "浙江省台州市",
"86130662", "广东省江门市",
"861892194", "江苏省扬州市",
"861452242", "浙江省嘉兴市",
"861315306", "山东省枣庄市",
"861869068", "新疆巴音郭楞蒙古自治州",
"861860145", "江苏省苏州市",
"861769706", "青海省玉树藏族自治州",
"861386269", "江苏省常州市",
"861772031", "湖北省咸宁市",
"861550716", "湖北省荆州市",
"861396645", "安徽省淮南市",
"861866293", "江苏省南通市",
"861570791", "江西省南昌市",
"861339576", "浙江省台州市",
"861771402", "江苏省常州市",
"86134772", "湖北省恩施土家族苗族自治州",
"86182541", "山东省济南市",
"861808940", "甘肃省甘南藏族自治州",
"861598446", "四川省宜宾市",
"861822682", "安徽省滁州市",
"861806198", "江苏省泰州市",
"861815391", "甘肃省陇南市",
"86147347", "广东省广州市",
"86156390", "河南省郑州市",
"861364429", "辽宁省葫芦岛市",
"861760946", "甘肃省金昌市",
"861521816", "广东省阳江市",
"861341185", "广东省深圳市",
"861760725", "湖北省黄冈市",
"861529362", "甘肃省张掖市",
"861370424", "辽宁省本溪市",
"86137312", "河北省保定市",
"861592556", "云南省保山市",
"861802376", "广东省云浮市",
"861470724", "湖北省咸宁市",
"861864939", "山西省运城市",
"861830397", "河南省焦作市",
"86134717", "广西钦州市",
"861870934", "甘肃省庆阳市",
"86157023", "重庆市",
"861524963", "河南省安阳市",
"86187822", "四川省成都市",
"861562441", "山东省枣庄市",
"86187135", "河北省秦皇岛市",
"861818498", "西藏日喀则地区",
"861896549", "福建省南平市",
"861899389", "甘肃省兰州市",
"86155896", "山东省潍坊市",
"861858264", "四川省广安市",
"861700698", "广东省中山市",
"861470004", "福建省福州市",
"861866675", "广东省佛山市",
"861859631", "山东省威海市",
"86136545", "黑龙江省哈尔滨市",
"86596", "福建省漳州市",
"861519493", "河北省邢台市",
"861529949", "新疆乌鲁木齐市",
"861330892", "西藏日喀则地区",
"861559015", "吉林省白城市",
"861831925", "广东省梅州市",
"861337757", "广东省佛山市",
"861361506", "福建省漳州市",
"861599934", "新疆哈密地区",
"86189923", "陕西省渭南市",
"861894236", "江西省赣州市",
"861314977", "辽宁省营口市",
"861348782", "湖南省益阳市",
"86134700", "辽宁省丹东市",
"861567847", "广西玉林市",
"861534378", "河南省开封市",
"861587993", "江西省新余市",
"861868801", "广东省汕头市",
"861331435", "吉林省通化市",
"861390725", "湖北省黄冈市",
"861568551", "贵州省贵阳市",
"861780665", "广东省韶关市",
"861826534", "山东省德州市",
"861338088", "广东省中山市",
"861820527", "江苏省扬州市",
"861819022", "四川省甘孜藏族自治州",
"861592669", "湖北省荆门市",
"861350388", "河南省洛阳市",
"861316511", "山东省济南市",
"861888286", "四川省凉山彝族自治州",
"861479502", "宁夏石嘴山市",
"86176402", "辽宁省沈阳市",
"861352520", "河南省三门峡市",
"861520709", "江西省萍乡市",
"861890279", "广东省潮州市",
"861332919", "安徽省六安市",
"861390593", "福建省宁德市",
"861304390", "河南省南阳市",
"861861591", "山东省潍坊市",
"861337829", "四川省内江市",
"86139470", "内蒙古呼伦贝尔市",
"861766645", "广东省佛山市",
"86158240", "浙江省台州市",
"861840954", "宁夏固原市",
"861577915", "江西省上饶市",
"861572825", "广东省深圳市",
"861360758", "福建省漳州市",
"861589619", "江苏省淮安市",
"861335648", "广东省东莞市",
"861302262", "浙江省舟山市",
"861477187", "湖北省襄樊市",
"86130990", "山西省太原市",
"861810524", "江苏省宿迁市",
"861778753", "云南省保山市",
"86189574", "浙江省宁波市",
"861810094", "甘肃省兰州市",
"861530329", "河北省石家庄市",
"861576999", "云南省保山市",
"861478408", "河南省濮阳市",
"861833957", "河南省漯河市",
"861840312", "河北省保定市",
"861802283", "广东省茂名市",
"861589447", "云南省普洱市",
"861760703", "江西省上饶市",
"861805946", "福建省三明市",
"861858718", "云南省丽江市",
"861530564", "安徽省六安市",
"861587614", "广东省佛山市",
"861312453", "黑龙江省牡丹江市",
"861364877", "云南省玉溪市",
"861318543", "浙江省嘉兴市",
"861300302", "安徽省蚌埠市",
"861339824", "四川省乐山市",
"861390023", "广东省广州市",
"861813643", "江苏省苏州市",
"861380539", "山东省临沂市",
"861812209", "广东省深圳市",
"861891280", "江苏省镇江市",
"861818901", "西藏日喀则地区",
"861390872", "云南省大理白族自治州",
"86177267", "新疆乌鲁木齐市",
"861337348", "河北省衡水市",
"86133318", "上海市",
"861330484", "黑龙江省哈尔滨市",
"861870851", "贵州省贵阳市",
"861570501", "内蒙古兴安盟",
"861362902", "四川省自贡市",
"861770964", "安徽省淮南市",
"861454763", "山东省淄博市",
"861778010", "四川省泸州市",
"861820097", "广东省阳江市",
"86136926", "广东省茂名市",
"86185910", "陕西省咸阳市",
"8615801", "北京市",
"861539062", "甘肃省甘南藏族自治州",
"86138957", "黑龙江省哈尔滨市",
"861572772", "江西省新余市",
"86147375", "广东省广州市",
"861318300", "河南省郑州市",
"861394342", "吉林省白山市",
"86152858", "贵州省六盘水市",
"861360347", "河南省漯河市",
"861330573", "浙江省嘉兴市",
"861550537", "山东省济宁市",
"861364159", "江苏省泰州市",
"861370154", "江苏省苏州市",
"86157656", "黑龙江省鸡西市",
"861890448", "吉林省松原市",
"861894228", "江西省赣州市",
"861525561", "安徽省合肥市",
"861512181", "宁夏银川市",
"861830941", "甘肃省甘南藏族自治州",
"861334870", "湖南省岳阳市",
"861318370", "四川省攀枝花市",
"861570465", "黑龙江省黑河市",
"861454936", "江苏省苏州市",
"861309282", "四川省南充市",
"861835653", "安徽省合肥市",
"861550880", "云南省昆明市",
"861860743", "湖南省湘西土家族苗族自治州",
"861334231", "辽宁省营口市",
"861559420", "陕西省榆林市",
"861330503", "福建省宁德市",
"861350235", "广东省梅州市",
"861339796", "江西省吉安市",
"86187869", "贵州省遵义市",
"86150118", "广东省广州市",
"861815947", "福建省龙岩市",
"86137359", "浙江省丽水市",
"861535222", "甘肃省天水市",
"861312725", "山东省东营市",
"861570571", "浙江省杭州市",
"861805453", "山东省临沂市",
"861370585", "浙江省绍兴市",
"861471858", "广东省肇庆市",
"861315869", "四川省德阳市",
"861348367", "河北省石家庄市",
"861524178", "辽宁省营口市",
"861453481", "内蒙古包头市",
"861315283", "山西省阳泉市",
"86136502", "广东省东莞市",
"861873847", "河南省驻马店市",
"861599689", "江苏省徐州市",
"861869903", "新疆克拉玛依市",
"861595602", "安徽省宿州市",
"861886763", "浙江省宁波市",
"861366799", "江西省萍乡市",
"861312593", "黑龙江省牡丹江市",
"861330340", "山西省太原市",
"86177260", "天津",
"861773266", "河北省保定市",
"861521780", "广东省惠州市",
"861839701", "青海省西宁市",
"861373969", "河北省邢台市",
"861559331", "甘肃省平凉市",
"861369541", "山东省济南市",
"861805105", "江苏省扬州市",
"861584865", "内蒙古通辽市",
"861554404", "河南省安阳市",
"861320686", "黑龙江省牡丹江市",
"861504898", "内蒙古巴彦淖尔市",
"861760773", "广西桂林市",
"861478478", "内蒙古巴彦淖尔市",
"861450979", "新疆乌鲁木齐市",
"861363351", "山西省太原市",
"861328959", "宁夏固原市",
"861892369", "广东省河源市",
"861378778", "湖南省长沙市",
"861308997", "黑龙江省绥化市",
"861345115", "湖北省武汉市",
"861367750", "新疆伊犁哈萨克自治州",
"861857981", "广西南宁市",
"861568163", "四川省雅安市",
"861390453", "黑龙江省牡丹江市",
"861399776", "湖北省恩施土家族苗族自治州",
"861861451", "黑龙江省哈尔滨市",
"861816880", "江苏省常州市",
"861324904", "广东省中山市",
"861597302", "湖南省岳阳市",
"861774030", "河北省邢台市",
"86139477", "内蒙古鄂尔多斯市",
"861533635", "山东省聊城市",
"86150501", "江苏省苏州市",
"86158247", "河南省商丘市",
"861537840", "四川省凉山彝族自治州",
"861881210", "河北省邯郸市",
"86130997", "青海省西宁市",
"861362339", "河北省张家口市",
"861879218", "安徽省合肥市",
"86139412", "辽宁省鞍山市",
"861532756", "湖北省孝感市",
"861570958", "宁夏银川市",
"861394890", "内蒙古呼伦贝尔市",
"861520779", "广西北海市",
"861807492", "广西南宁市",
"861513500", "山西省忻州市",
"861367715", "湖北省咸宁市",
"861813850", "广东省佛山市",
"86188289", "四川省宜宾市",
"86136228", "广东省广州市",
"861597684", "广东省湛江市",
"861884021", "陕西省延安市",
"861365969", "广西玉林市",
"861509130", "陕西省渭南市",
"861848928", "西藏山南地区",
"861311542", "黑龙江省大庆市",
"86136559", "福建省泉州市",
"861815262", "湖南省岳阳市",
"861314907", "广东省韶关市",
"861527192", "湖北省武汉市",
"861519553", "江苏省盐城市",
"861819803", "甘肃省平凉市",
"861452513", "山东省烟台市",
"861361576", "浙江省台州市",
"861368724", "湖北省武汉市",
"861329920", "广西南宁市",
"861858197", "四川省成都市",
"861830629", "江苏省南通市",
"86137302", "河北省保定市",
"861313658", "浙江省台州市",
"861894698", "广东省汕头市",
"861345812", "四川省攀枝花市",
"861534308", "湖南省娄底市",
"861812448", "广东省河源市",
"861568491", "湖南省岳阳市",
"861513343", "河北省廊坊市",
"861508268", "四川省广安市",
"861800429", "辽宁省葫芦岛市",
"861529291", "新疆喀什地区",
"861300939", "辽宁省鞍山市",
"861866605", "广东省汕头市",
"861551879", "河南省安阳市",
"861380317", "河北省沧州市",
"861801219", "江苏省泰州市",
"861770320", "河北省邯郸市",
"861802779", "广东省茂名市",
"861311533", "黑龙江省牡丹江市",
"861563879", "河南省许昌市",
"861470566", "安徽省池州市",
"861874820", "内蒙古兴安盟",
"86181891", "陕西省西安市",
"861518214", "四川省内江市",
"861831962", "广东省惠州市",
"861539595", "福建省泉州市",
"861886803", "浙江省嘉兴市",
"86187419", "辽宁省辽阳市",
"861570052", "四川省广安市",
"861589139", "陕西省西安市",
"861810148", "江苏省南通市",
"861879196", "陕西省渭南市",
"861532988", "贵州省遵义市",
"861361064", "山西省晋中市",
"861815386", "湖南省郴州市",
"861839861", "四川省乐山市",
"861880331", "河北省石家庄市",
"861584705", "内蒙古赤峰市",
"861550319", "河北省邢台市",
"86158017", "上海市",
"86155565", "安徽省阜阳市",
"861454873", "四川省南充市",
"861770431", "吉林省长春市",
"861392153", "江苏省无锡市",
"861769309", "甘肃省陇南市",
"861366254", "广东省广州市",
"861890085", "广东省茂名市",
"861569921", "新疆乌鲁木齐市",
"861561073", "山东省德州市",
"861319056", "内蒙古通辽市",
"861319782", "江西省抚州市",
"861450500", "吉林省延边朝鲜族自治州",
"861576590", "黑龙江省大庆市",
"861871888", "广东省广州市",
"861380930", "甘肃省白银市",
"861857212", "湖北省孝感市",
"86139224", "广东省广州市",
"861359814", "河南省安阳市",
"861567644", "广西贺州市",
"861889880", "广东省佛山市",
"861853451", "山西省晋城市",
"861572862", "广东省肇庆市",
"861787699", "广东省深圳市",
"861301150", "河北省唐山市",
"861880420", "辽宁省大连市",
"861569417", "辽宁省营口市",
"861328490", "黑龙江省大庆市",
"861852439", "辽宁省丹东市",
"861399581", "湖北省鄂州市",
"861332510", "山东省济南市",
"861508047", "福建省福州市",
"861529303", "甘肃省临夏回族自治州",
"861558306", "四川省阿坝藏族羌族自治州",
"86155735", "湖南省郴州市",
"861786615", "甘肃省陇南市",
"861807001", "江西省鹰潭市",
"861513979", "河南省信阳市",
"861338445", "吉林省通化市",
"861351351", "山西省太原市",
"861357819", "云南省普洱市",
"86139862", "湖北省武汉市",
"861823843", "河南省南阳市",
"861362078", "吉林省长春市",
"861477305", "湖南省郴州市",
"861576020", "四川省广安市",
"86189352", "山西省大同市",
"861308645", "四川省乐山市",
"861887058", "江西省萍乡市",
"861344569", "山东省临沂市",
"861335567", "安徽省亳州市",
"861894737", "内蒙古鄂尔多斯市",
"861831247", "广东省深圳市",
"861523315", "河北省唐山市",
"861529540", "江苏省无锡市",
"861324535", "山东省烟台市",
"861816319", "湖北省十堰市",
"861309427", "湖北省十堰市",
"861310475", "广东省东莞市",
"861572165", "山西省长治市",
"86133820", "江苏省南京市",
"861599193", "陕西省渭南市",
"861511922", "广东省韶关市",
"861890783", "广西桂林市",
"861510481", "内蒙古赤峰市",
"861361781", "广西南宁市",
"861771191", "西藏拉萨市",
"861896940", "浙江省宁波市",
"861881363", "广东省湛江市",
"86131650", "山东省青岛市",
"861587134", "湖北省孝感市",
"861346383", "河北省保定市",
"861809937", "新疆昌吉回族自治州",
"861860732", "湖南省湘潭市",
"861539025", "四川省绵阳市",
"86156778", "广西河池市",
"861361399", "河南省南阳市",
"861364674", "浙江省温州市",
"861562250", "广东省东莞市",
"861339627", "山东省德州市",
"861370679", "浙江省金华市",
"861536646", "江苏省盐城市",
"861301812", "四川省南充市",
"86183307", "河北省沧州市",
"861817686", "广西南宁市",
"861309366", "安徽省蚌埠市",
"861305085", "辽宁省盘锦市",
"861329364", "山西省阳泉市",
"861370609", "福建省莆田市",
"861873644", "河南省漯河市",
"861707041", "浙江省湖州市",
"86185535", "山东省烟台市",
"861378544", "河北省承德市",
"861596439", "山东省聊城市",
"861862531", "河南省驻马店市",
"861575809", "云南省昭通市",
"861769932", "新疆和田地区",
"861329529", "江苏省宿迁市",
"861780292", "陕西省西安市",
"861882860", "四川省雅安市",
"86183300", "河北省邯郸市",
"861394333", "吉林省松原市",
"861300530", "广东省河源市",
"861860488", "内蒙古呼和浩特市",
"861568823", "湖南省邵阳市",
"861310405", "黑龙江省哈尔滨市",
"86133827", "江苏省扬州市",
"861867344", "湖南省衡阳市",
"861362517", "江苏省泰州市",
"861535265", "新疆克拉玛依市",
"861390387", "河南省周口市",
"861526444", "山东省潍坊市",
"861869828", "辽宁省辽阳市",
"861590526", "江苏省泰州市",
"86131657", "陕西省西安市",
"861892148", "江苏省南通市",
"861325669", "山东省济南市",
"861899810", "广东省惠州市",
"86170766", "广东省广州市",
"861853021", "河南省新乡市",
"861532257", "广东省汕头市",
"861369620", "四川省南充市",
"861319367", "河南省南阳市",
"861310153", "黑龙江省牡丹江市",
"861868761", "云南省昆明市",
"861302695", "广西玉林市",
"861539968", "安徽省阜阳市",
"861317097", "江西省赣州市",
"861885134", "江苏省徐州市",
"86186578", "浙江省丽水市",
"861365560", "安徽省合肥市",
"86181493", "陕西省西安市",
"861813632", "江苏省宿迁市",
"861354752", "四川省广安市",
"861709513", "江苏省无锡市",
"861533812", "广东省江门市",
"861899855", "广东省茂名市",
"861522059", "广东省惠州市",
"86135908", "广东省中山市",
"861551769", "河南省濮阳市",
"861580631", "山东省威海市",
"861332495", "云南省大理白族自治州",
"861807071", "广西南宁市",
"861515686", "安徽省安庆市",
"861454452", "江西省九江市",
"861341448", "广东省深圳市",
"861319426", "辽宁省大连市",
"861805387", "山东省烟台市",
"86139829", "四川省资阳市",
"861302386", "福建省莆田市",
"861539103", "内蒙古包头市",
"861516619", "山东省日照市",
"861708381", "河南省新乡市",
"861576450", "黑龙江省哈尔滨市",
"861334760", "广西南宁市",
"861315129", "江苏省常州市",
"861470881", "云南省西双版纳傣族自治州",
"861322440", "吉林省四平市",
"861708799", "江苏省淮安市",
"861308813", "四川省南充市",
"86187675", "浙江省绍兴市",
"861379721", "湖北省孝感市",
"861454803", "广东省清远市",
"861322672", "广东省佛山市",
"861389511", "宁夏银川市",
"861479917", "新疆克拉玛依市",
"861317527", "浙江省绍兴市",
"861328550", "安徽省滁州市",
"86183458", "黑龙江省双鸭山市",
"86187378", "河南省开封市",
"861870795", "江西省宜春市",
"861579494", "福建省福州市",
"861358691", "浙江省宁波市",
"861773767", "河南省许昌市",
"861841946", "甘肃省陇南市",
"861819928", "新疆昌吉回族自治州",
"861815225", "甘肃省平凉市",
"86185765", "广东省佛山市",
"861560141", "江苏省盐城市",
"861899152", "陕西省安康市",
"861772611", "湖南省常德市",
"861339297", "广东省珠海市",
"861533115", "辽宁省丹东市",
"861584775", "内蒙古呼和浩特市",
"861869349", "甘肃省酒泉市",
"861870523", "江苏省淮安市",
"861392475", "广东省汕头市",
"861457017", "山东省日照市",
"861539410", "陕西省咸阳市",
"861323858", "贵州省毕节地区",
"861886022", "河南省南阳市",
"861327524", "江苏省常州市",
"861590538", "山东省泰安市",
"861533150", "云南省楚雄彝族自治州",
"861360986", "辽宁省大连市",
"861391954", "甘肃省平凉市",
"861850447", "吉林省吉林市",
"861329099", "河南省信阳市",
"861347335", "河北省石家庄市",
"861893412", "广东省阳江市",
"861539455", "福建省福州市",
"861327369", "河北省邢台市",
"861830754", "广东省汕头市",
"861586493", "山东省聊城市",
"861356944", "河南省新乡市",
"861378868", "广西南宁市",
"861863559", "山西省太原市",
"861307939", "甘肃省武威市",
"86151879", "云南省曲靖市",
"861870769", "广东省韶关市",
"861807429", "浙江省舟山市",
"861818490", "西藏昌都地区",
"861700690", "福建省厦门市",
"861477074", "江西省吉安市",
"861471643", "广东省广州市",
"861534370", "河南省商丘市",
"861338080", "广东省茂名市",
"861853479", "山西省吕梁市",
"861880314", "河北省承德市",
"861350380", "河南省新乡市",
"861512939", "陕西省西安市",
"861829782", "安徽省池州市",
"86134007", "福建省厦门市",
"861780856", "贵州省铜仁地区",
"861830353", "山西省阳泉市",
"86188354", "山西省晋中市",
"861592947", "陕西省咸阳市",
"861304398", "河南省三门峡市",
"861590684", "浙江省宁波市",
"861363943", "山东省济宁市",
"861453225", "浙江省温州市",
"861760557", "安徽省宿州市",
"861327395", "河南省漯河市",
"861325386", "河南省焦作市",
"861800492", "辽宁省鞍山市",
"861863501", "山西省忻州市",
"86177311", "河北省石家庄市",
"861770414", "辽宁省本溪市",
"861329065", "河北省唐山市",
"861383897", "河南省南阳市",
"861577958", "江西省新余市",
"86183203", "广东省湛江市",
"861352528", "河南省濮阳市",
"861527779", "广西桂林市",
"861897209", "湖北省襄樊市",
"861335472", "内蒙古包头市",
"861335640", "广东省江门市",
"861529667", "山西省临汾市",
"861351932", "甘肃省定西市",
"86138508", "福建省三明市",
"861867045", "湖南省怀化市",
"861571619", "江苏省无锡市",
"861360750", "福建省莆田市",
"861776931", "湖南省长沙市",
"861820561", "安徽省淮北市",
"861388784", "云南省文山壮族苗族自治州",
"861858710", "云南省迪庆藏族自治州",
"861352536", "河南省平顶山市",
"861571447", "吉林省辽源市",
"86155841", "吉林省长春市",
"861478400", "河南省驻马店市",
"86152388", "河南省周口市",
"861535299", "青海省果洛藏族自治州",
"861581377", "广东省江门市",
"861327686", "浙江省台州市",
"861524413", "山东省泰安市",
"861594906", "江苏省扬州市",
"861814535", "黑龙江省鹤岗市",
"861803739", "河南省新乡市",
"86137284", "广东省东莞市",
"8618851", "江苏省南京市",
"861344455", "山东省菏泽市",
"861891288", "江苏省南通市",
"861370651", "浙江省杭州市",
"861820475", "内蒙古通辽市",
"861337340", "河北省邯郸市",
"861568970", "山东省济南市",
"861857139", "湖北省荆州市",
"861525097", "江苏省南京市",
"861767123", "湖北省黄石市",
"861562839", "广东省东莞市",
"861509706", "甘肃省平凉市",
"861772989", "四川省德阳市",
"86152685", "浙江省杭州市",
"86182650", "山东省菏泽市",
"861778507", "贵州省毕节地区",
"861313843", "广东省汕头市",
"861522001", "广东省广州市",
"861591635", "广东省惠州市",
"86137157", "广东省潮州市",
"861839624", "福建省泉州市",
"861300181", "河北省唐山市",
"861329763", "湖北省荆门市",
"861587111", "湖北省十堰市",
"861332469", "陕西省铜川市",
"861360013", "广东省汕头市",
"861880952", "宁夏石嘴山市",
"861890672", "浙江省湖州市",
"861351379", "河南省洛阳市",
"861363026", "陕西省汉中市",
"861778018", "四川省达州市",
"861552042", "四川省南充市",
"861500725", "湖北省黄冈市",
"861337503", "福建省漳州市",
"861809424", "江苏省南京市",
"861458327", "江西省吉安市",
"861532589", "浙江省金华市",
"861394734", "内蒙古乌海市",
"861890440", "吉林省长春市",
"861894220", "江西省南昌市",
"861500946", "甘肃省兰州市",
"861867743", "广西梧州市",
"861331244", "贵州省黔东南苗族侗族自治州",
"861309934", "甘肃省陇南市",
"861316975", "广东省清远市",
"861800884", "云南省昆明市",
"861589212", "福建省宁德市",
"861577465", "黑龙江省绥化市",
"861318308", "河南省洛阳市",
"86138222", "广东省广州市",
"861334808", "江苏省南通市",
"861475756", "浙江省绍兴市",
"861861356", "山西省晋城市",
"861862514", "江苏省苏州市",
"861323632", "江苏省连云港市",
"861559428", "陕西省安康市",
"861329936", "甘肃省武威市",
"861367347", "河南省信阳市",
"861337573", "浙江省嘉兴市",
"861538977", "内蒙古鄂尔多斯市",
"861514088", "辽宁省阜新市",
"861334878", "湖南省娄底市",
"86182442", "四川省成都市",
"86182024", "辽宁省沈阳市",
"861318378", "四川省绵阳市",
"861520944", "甘肃省金昌市",
"861837299", "湖北省宜昌市",
"861375456", "河北省廊坊市",
"861872457", "黑龙江省黑河市",
"861316905", "广东省潮州市",
"861858423", "四川省南充市",
"861550888", "云南省丽江市",
"861471850", "广东省揭阳市",
"861365419", "辽宁省辽阳市",
"861522071", "广东省惠州市",
"861524170", "辽宁省铁岭市",
"86137150", "广东省深圳市",
"861395552", "安徽省池州市",
"861829367", "甘肃省天水市",
"861322085", "山东省青岛市",
"8618910", "北京市",
"861827097", "江西省赣州市",
"861351309", "河北省秦皇岛市",
"861577501", "广东省深圳市",
"861343754", "广东省汕尾市",
"861576922", "陕西省榆林市",
"861530392", "河南省鹤壁市",
"861807059", "江西省南昌市",
"861330348", "山西省运城市",
"861529704", "青海省海南藏族自治州",
"861521788", "广东省珠海市",
"86159997", "广东省东莞市",
"861478642", "湖南省张家界市",
"86137889", "上海市",
"861594976", "山东省潍坊市",
"861774026", "四川省德阳市",
"86182657", "山东省滨州市",
"861834442", "广东省东莞市",
"861500453", "黑龙江省牡丹江市",
"861335186", "黑龙江省佳木斯市",
"861510947", "甘肃省庆阳市",
"86158965", "河南省洛阳市",
"86139501", "福建省厦门市",
"86150477", "内蒙古鄂尔多斯市",
"861335853", "福建省莆田市",
"861378770", "湖南省衡阳市",
"861580614", "江苏省常州市",
"86145068", "上海市",
"861893925", "河南省郑州市",
"861537564", "安徽省六安市",
"861819529", "宁夏石嘴山市",
"86150412", "辽宁省沈阳市",
"861385137", "江苏省宿迁市",
"861572199", "陕西省铜川市",
"861581307", "广东省阳江市",
"861503244", "河北省沧州市",
"86180394", "河南省洛阳市",
"861804642", "福建省厦门市",
"861767703", "广西桂林市",
"861478470", "内蒙古鄂尔多斯市",
"861509126", "陕西省宝鸡市",
"861393435", "山西省吕梁市",
"861534543", "山东省滨州市",
"861564377", "吉林省辽源市",
"861800552", "安徽省蚌埠市",
"861881218", "河北省衡水市",
"861474133", "辽宁省沈阳市",
"861882778", "江西省吉安市",
"861539324", "甘肃省定西市",
"861879210", "安徽省六安市",
"861367758", "新疆哈密地区",
"861309689", "贵州省黔西南布依族苗族自治州",
"861305602", "江苏省淮安市",
"861590372", "河南省安阳市",
"861570915", "陕西省安康市",
"861539569", "安徽省马鞍山市",
"861537848", "四川省南充市",
"861330829", "四川省巴中市",
"861319603", "吉林省长春市",
"861580546", "山东省东营市",
"86134664", "北京市",
"861598997", "广东省佛山市",
"861874973", "河南省洛阳市",
"861509138", "陕西省咸阳市",
"861897279", "湖北省黄石市",
"861570950", "宁夏银川市",
"861339489", "内蒙古呼和浩特市",
"861394898", "内蒙古巴彦淖尔市",
"861389534", "宁夏固原市",
"86184248", "辽宁省沈阳市",
"861813858", "广东省肇庆市",
"861453386", "内蒙古通辽市",
"861513508", "山西省太原市",
"861313650", "浙江省湖州市",
"86136411", "北京市",
"861365647", "山东省东营市",
"861501741", "广东省佛山市",
"861350444", "吉林省四平市",
"861354224", "广东省揭阳市",
"861853409", "山西省临汾市",
"861356869", "四川省甘孜藏族自治州",
"861894690", "广东省汕尾市",
"861787665", "广东省揭阳市",
"861373419", "山西省朔州市",
"86137426", "辽宁省大连市",
"861569233", "山东省淄博市",
"861558522", "贵州省遵义市",
"861534300", "湖南省岳阳市",
"861580993", "新疆石河子市",
"861891957", "四川省成都市",
"861763541", "山西省晋中市",
"861848920", "西藏拉萨市",
"86130774", "广东省佛山市",
"861881677", "广东省惠州市",
"86155443", "河南省信阳市",
"861366486", "内蒙古赤峰市",
"861528433", "河北省保定市",
"861774943", "河南省周口市",
"86138269", "广东省东莞市",
"861329928", "广西河池市",
"861337892", "湖南省怀化市",
"861839294", "陕西省渭南市",
"861397175", "湖北省黄石市",
"86153999", "湖南省长沙市",
"861597181", "湖北省恩施土家族苗族自治州",
"86151274", "河北省唐山市",
"861534996", "新疆阿勒泰地区",
"861812440", "广东省韶关市",
"861566566", "安徽省池州市",
"861363456", "黑龙江省黑河市",
"861380032", "山西省忻州市",
"861508260", "四川省宜宾市",
"861825129", "江苏省淮安市",
"86151427", "辽宁省盘锦市",
"861569242", "广东省广州市",
"861890251", "广东省茂名市",
"861320369", "湖南省益阳市",
"861590887", "云南省迪庆藏族自治州",
"861340335", "河北省唐山市",
"86188572", "浙江省湖州市",
"861528442", "云南省玉溪市",
"861857447", "湖南省张家界市",
"86177363", "河北省张家口市",
"861564882", "内蒙古赤峰市",
"861770328", "河北省承德市",
"861334046", "福建省泉州市",
"861842049", "广东省河源市",
"86187551", "安徽省合肥市",
"86159436", "吉林省白城市",
"861529864", "江苏省连云港市",
"861358267", "河北省沧州市",
"86136114", "广东省广州市",
"861318039", "河北省张家口市",
"861504711", "内蒙古呼和浩特市",
"861874828", "内蒙古包头市",
"861375309", "山西省朔州市",
"861379382", "山东省泰安市",
"861771913", "河南省漯河市",
"861810140", "江苏省淮安市",
"861380043", "吉林省长春市",
"86185065", "浙江省宁波市",
"861532980", "贵州省贵阳市",
"861329873", "黑龙江省佳木斯市",
"861534532", "山东省青岛市",
"861333312", "河北省保定市",
"861340957", "宁夏中卫市",
"861450508", "吉林省吉林市",
"861576598", "黑龙江省大庆市",
"861316534", "山东省德州市",
"861506341", "山东省莱芜市",
"861851571", "四川省泸州市",
"86158710", "湖北省襄樊市",
"861309575", "浙江省绍兴市",
"861329022", "山东省枣庄市",
"86153842", "广东省东莞市",
"861372787", "广东省珠海市",
"861846454", "山东省烟台市",
"86152201", "广东省深圳市",
"861886099", "江苏省无锡市",
"861531513", "山东省济南市",
"861598645", "广东省梅州市",
"861301158", "河北省石家庄市",
"861880428", "辽宁省大连市",
"861519867", "云南省西双版纳傣族自治州",
"861477881", "广东省广州市",
"861328498", "黑龙江省齐齐哈尔市",
"861808142", "四川省广安市",
"861871880", "广东省湛江市",
"861370272", "广东省湛江市",
"861380938", "甘肃省天水市",
"861889888", "广东省广州市",
"861309461", "浙江省绍兴市",
"861887015", "江西省鹰潭市",
"861870879", "云南省普洱市",
"861839827", "四川省雅安市",
"861800071", "江西省南昌市",
"861336984", "新疆克孜勒苏柯尔克孜自治州",
"861334923", "安徽省芜湖市",
"86131724", "广东省深圳市",
"861335091", "四川省广安市",
"861830487", "内蒙古赤峰市",
"861537076", "江苏省苏州市",
"861332518", "山东省济宁市",
"861364721", "湖北省武汉市",
"861834433", "广东省汕头市",
"86151368", "河南省许昌市",
"861380745", "湖南省怀化市",
"861708875", "广东省茂名市",
"861354897", "湖南省长沙市",
"861356709", "浙江省丽水市",
"861329592", "福建省厦门市",
"861380926", "广东省东莞市",
"861333954", "黑龙江省佳木斯市",
"861453947", "广东省惠州市",
"861317153", "河北省邯郸市",
"861760374", "河南省许昌市",
"861859993", "四川省成都市",
"861800687", "浙江省温州市",
"861815481", "新疆乌鲁木齐市",
"861595783", "浙江省丽水市",
"861508313", "河南省新乡市",
"861362070", "吉林省延边朝鲜族自治州",
"86151665", "山东省聊城市",
"861802944", "广东省江门市",
"86181846", "海南省海口市",
"861880436", "吉林省白城市",
"861896948", "浙江省衢州市",
"861770336", "河北省廊坊市",
"861358942", "山东省滨州市",
"86136861", "广东省东莞市",
"861459535", "西藏昌都地区",
"861597526", "广东省肇庆市",
"861323643", "江苏省无锡市",
"86185454", "黑龙江省佳木斯市",
"861521956", "广东省江门市",
"86186351", "山西省太原市",
"861877093", "江西省上饶市",
"861529548", "江苏省徐州市",
"861527283", "湖北省孝感市",
"861317405", "江苏省无锡市",
"861328901", "新疆和田地区",
"861500762", "广东省河源市",
"861569967", "黑龙江省鸡西市",
"861584899", "内蒙古赤峰市",
"86137098", "辽宁省沈阳市",
"861373995", "内蒙古乌兰察布市",
"86187983", "贵州省毕节地区",
"86134275", "广东省广州市",
"861479285", "安徽省安庆市",
"861332007", "江西省赣州市",
"861572683", "浙江省宁波市",
"861562258", "广东省韶关市",
"861822453", "河南省郑州市",
"861708486", "河南省三门峡市",
"861454364", "山东省淄博市",
"861334214", "辽宁省本溪市",
"86151156", "湖南省常德市",
"86147432", "广东省广州市",
"861315944", "福建省莆田市",
"861773721", "河南省周口市",
"861377679", "江苏省徐州市",
"861812251", "广东省河源市",
"861332077", "四川省南充市",
"861512887", "河北省邯郸市",
"861454529", "广西北海市",
"861589981", "广东省佛山市",
"861300096", "新疆乌鲁木齐市",
"861332681", "广东省江门市",
"86131148", "天津市",
"861580817", "四川省南充市",
"861869820", "辽宁省铁岭市",
"861532675", "内蒙古通辽市",
"86158343", "山西省吕梁市",
"861892140", "江苏省南京市",
"861450951", "江苏省连云港市",
"861822593", "安徽省宣城市",
"861352992", "云南省大理白族自治州",
"86138414", "辽宁省本溪市",
"861882616", "广东省江门市",
"861300538", "广东省云浮市",
"861479467", "黑龙江省鸡西市",
"861363379", "河南省洛阳市",
"861317475", "浙江省台州市",
"861860480", "内蒙古呼伦贝尔市",
"86180125", "江苏省盐城市",
"861330256", "广东省佛山市",
"861389146", "陕西省渭南市",
"861576965", "宁夏中卫市",
"861321719", "湖北省十堰市",
"861822946", "湖南省永州市",
"861539960", "安徽省安庆市",
"861340011", "河北省石家庄市",
"861845835", "浙江省嘉兴市",
"861808994", "西藏林芝地区",
"86150829", "河南省商丘市",
"861899818", "广东省珠海市",
"86180606", "福建省福州市",
"861470305", "河北省唐山市",
"861369628", "四川省绵阳市",
"861361322", "河北省保定市",
"861350819", "四川省宜宾市",
"861864804", "内蒙古锡林郭勒盟",
"861893962", "河南省周口市",
"861341440", "广东省东莞市",
"861870809", "西藏日喀则地区",
"861570559", "安徽省黄山市",
"86189466", "吉林省长春市",
"861555619", "安徽省蚌埠市",
"861365568", "安徽省阜阳市",
"861511999", "广东省汕头市",
"86562", "安徽省铜陵市",
"86153805", "江苏省盐城市",
"861329452", "山西省大同市",
"861322448", "吉林省松原市",
"861344062", "河北省邯郸市",
"861369636", "山东省潍坊市",
"861871537", "安徽省淮南市",
"86158772", "广西柳州市",
"861555447", "山东省威海市",
"861833034", "河北省唐山市",
"861560644", "山东省济南市",
"861868859", "广东省湛江市",
"861802192", "江苏省淮安市",
"861772837", "广东省中山市",
"861334768", "广西河池市",
"861576458", "黑龙江省伊春市",
"86157751", "四川省成都市",
"861351943", "甘肃省白银市",
"861325262", "吉林省长春市",
"861329803", "内蒙古赤峰市",
"861581185", "广东省广州市",
"861819920", "新疆巴音郭楞蒙古自治州",
"86135785", "吉林省吉林市",
"861761449", "吉林省白山市",
"861771224", "江苏省连云港市",
"861865141", "江苏省南通市",
"86158717", "湖北省武汉市",
"861309505", "新疆昌吉回族自治州",
"861328558", "安徽省阜阳市",
"86135557", "辽宁省沈阳市",
"861861479", "内蒙古锡林郭勒盟",
"861306439", "四川省自贡市",
"861558565", "吉林省通化市",
"861323850", "贵州省安顺市",
"861351596", "福建省厦门市",
"861539418", "陕西省西安市",
"861787622", "广东省深圳市",
"861806929", "浙江省舟山市",
"86150486", "内蒙古赤峰市",
"861479338", "甘肃省平凉市",
"861810395", "河南省漯河市",
"861858891", "广东省潮州市",
"861520751", "广东省韶关市",
"861323815", "辽宁省丹东市",
"86183152", "重庆市",
"861300526", "广东省揭阳市",
"861378860", "广西南宁市",
"86151420", "辽宁省沈阳市",
"861533158", "云南省曲靖市",
"861590530", "山东省菏泽市",
"861853067", "河南省南阳市",
"861303513", "湖北省武汉市",
"861882544", "广东省佛山市",
"861808613", "湖北省襄樊市",
"861522492", "河南省驻马店市",
"86181635", "湖北省武汉市",
"861813239", "河北省保定市",
"861458785", "湖南省衡阳市",
"86188507", "福建省福州市",
"86180241", "广东省佛山市",
"861810040", "辽宁省沈阳市",
"861380143", "江苏省泰州市",
"861531242", "江苏省徐州市",
"861534981", "安徽省安庆市",
"861594732", "内蒙古包头市",
"861334975", "湖北省荆州市",
"861550985", "辽宁省大连市",
"861813468", "安徽省安庆市",
"861317755", "江西省萍乡市",
"861339253", "广东省珠海市",
"861501831", "广东省珠海市",
"861597196", "湖北省荆门市",
"861350971", "山西省太原市",
"86155399", "河南省南阳市",
"861318139", "山东省德州市",
"861595494", "山东省聊城市",
"861868007", "广东省东莞市",
"861347546", "山东省东营市",
"861471918", "甘肃省甘南藏族自治州",
"86130783", "广东省阳江市",
"861560737", "湖南省益阳市",
"86134240", "广东省广州市",
"861322377", "河南省新乡市",
"861317710", "湖北省恩施土家族苗族自治州",
"86183261", "安徽省合肥市",
"861591713", "广东省汕尾市",
"861811411", "江苏省无锡市",
"861881538", "山东省泰安市",
"86151283", "河北省张家口市",
"861839409", "甘肃省酒泉市",
"86182139", "云南省昆明市",
"861879530", "宁夏银川市",
"86133914", "上海市",
"861555378", "山东省枣庄市",
"861533436", "云南省红河哈尼族彝族自治州",
"861586457", "山东省潍坊市",
"861366491", "广东省江门市",
"861888667", "四川省广元市",
"861395721", "浙江省舟山市",
"861708072", "湖南省长沙市",
"861470323", "河北省张家口市",
"861819683", "新疆喀什地区",
"86152122", "安徽省芜湖市",
"861329772", "广西柳州市",
"861821924", "广东省深圳市",
"86184008", "西藏拉萨市",
"861392264", "广东省肇庆市",
"86156766", "广西百色市",
"86152835", "四川省宜宾市",
"861321434", "吉林省四平市",
"861537738", "湖南省娄底市",
"861327221", "湖南省衡阳市",
"861453391", "内蒙古阿拉善盟",
"861301058", "广东省江门市",
"861353489", "广东省茂名市",
"861850370", "河南省商丘市",
"861890663", "浙江省温州市",
"861328819", "广东省阳江市",
"861398147", "四川省达州市",
"861875152", "江苏省徐州市",
"861569513", "江苏省南通市",
"861329122", "江苏省无锡市",
"861391449", "江苏省南京市",
"861354648", "山西省运城市",
"861342245", "广东省珠海市",
"861816600", "江西省抚州市",
"861778626", "湖北省随州市",
"861474042", "辽宁省沈阳市",
"861389768", "青海省海东地区",
"86156536", "山东省潍坊市",
"861366908", "湖北省咸宁市",
"861350558", "安徽省阜阳市",
"861537726", "湖北省十堰市",
"861813910", "新疆阿克苏地区",
"86185123", "重庆市",
"861368375", "河南省平顶山市",
"861576128", "贵州省黔东南苗族侗族自治州",
"861537945", "甘肃省金昌市",
"861846704", "青海省果洛藏族自治州",
"861570818", "四川省达州市",
"861317053", "云南省西双版纳傣族自治州",
"861762527", "江苏省宿迁市",
"861320806", "浙江省宁波市",
"861887150", "湖北省咸宁市",
"861800721", "湖北省荆州市",
"861471460", "广东省东莞市",
"861505674", "安徽省宿州市",
"861310197", "江苏省无锡市",
"861390304", "广东省汕头市",
"861568799", "云南省普洱市",
"861893349", "广东省潮州市",
"86156293", "湖北省宜昌市",
"861394995", "河南省周口市",
"861775983", "福建省莆田市",
"861778638", "湖北省武汉市",
"861390682", "浙江省湖州市",
"861576778", "广东省梅州市",
"861893836", "广东省茂名市",
"861828212", "四川省巴中市",
"861813955", "新疆喀什地区",
"861509379", "河南省平顶山市",
"861535474", "吉林省白城市",
"861360633", "山东省日照市",
"861335191", "黑龙江省哈尔滨市",
"86187158", "四川省泸州市",
"861309795", "广西玉林市",
"861771567", "江苏省无锡市",
"861887115", "湖北省武汉市",
"861319662", "江苏省苏州市",
"861835106", "江苏省宿迁市",
"861875855", "浙江省杭州市",
"861700141", "江苏省盐城市",
"861351706", "江西省吉安市",
"861514531", "黑龙江省齐齐哈尔市",
"861313311", "山西省朔州市",
"861520471", "内蒙古呼和浩特市",
"861309523", "云南省丽江市",
"861320485", "内蒙古鄂尔多斯市",
"861888124", "四川省攀枝花市",
"861500863", "宁夏中卫市",
"861533428", "湖北省黄石市",
"861782826", "四川省内江市",
"861387219", "湖北省咸宁市",
"861870057", "陕西省商洛市",
"861355800", "广西防城港市",
"861305663", "四川省乐山市",
"861520565", "安徽省合肥市",
"861769610", "山西省太原市",
"861861759", "河北省邯郸市",
"861535583", "浙江省嘉兴市",
"861557678", "湖南省永州市",
"861550600", "吉林省长春市",
"86186736", "湖南省常德市",
"86182865", "贵州省黔东南苗族侗族自治州",
"861332727", "湖南省益阳市",
"861835726", "浙江省湖州市",
"861389046", "四川省绵阳市",
"86152646", "山东省潍坊市",
"861575461", "黑龙江省哈尔滨市",
"861854653", "黑龙江省哈尔滨市",
"861313733", "河南省濮阳市",
"861504560", "黑龙江省黑河市",
"861550670", "广西来宾市",
"86668", "广东省茂名市",
"861807674", "广西柳州市",
"861320267", "广东省东莞市",
"861586027", "福建省福州市",
"861334680", "河南省鹤壁市",
"861773071", "陕西省渭南市",
"861867833", "山东省滨州市",
"86139563", "安徽省蚌埠市",
"861358524", "江苏省扬州市",
"86132658", "广东省深圳市",
"86183119", "贵州省六盘水市",
"86187366", "河南省南阳市",
"861351776", "广西百色市",
"861375581", "江西省赣州市",
"861831820", "广东省梅州市",
"86132934", "河北省沧州市",
"861394844", "内蒙古乌兰察布市",
"861332177", "广西贵港市",
"86137856", "河北省廊坊市",
"861324346", "河南省周口市",
"861814250", "四川省德阳市",
"861593417", "山西省晋城市",
"861391208", "江苏省淮安市",
"861304480", "湖北省孝感市",
"861362413", "辽宁省抚顺市",
"861585115", "江苏省宿迁市",
"861509309", "河南省郑州市",
"861537106", "江苏省无锡市",
"861588426", "四川省德阳市",
"86153815", "浙江省温州市",
"861840814", "四川省广安市",
"861576708", "广东省湛江市",
"861877505", "广西桂林市",
"861372291", "河北省邢台市",
"861803336", "广东省汕尾市",
"861709921", "浙江省衢州市",
"86730", "湖南省岳阳市",
"861458183", "浙江省湖州市",
"861599879", "山东省德州市",
"861535404", "河北省承德市",
"861707644", "山东省青岛市",
"861899499", "江苏省常州市",
"861538243", "浙江省宁波市",
"861818388", "云南省临沧市",
"861339322", "河北省保定市",
"861300804", "山西省大同市",
"86137273", "广东省佛山市",
"86180616", "江苏省南京市",
"86153231", "广东省清远市",
"861575193", "甘肃省白银市",
"861572920", "河南省商丘市",
"861346821", "山东省临沂市",
"861709417", "广东省珠海市",
"861516543", "山东省滨州市",
"861390374", "河南省许昌市",
"861327691", "福建省福州市",
"861303967", "黑龙江省伊春市",
"861332859", "福建省三明市",
"861880158", "江苏省南京市",
"861301428", "宁夏银川市",
"861320876", "云南省文山壮族苗族自治州",
"861768047", "湖南省岳阳市",
"861312304", "福建省三明市",
"861520998", "新疆喀什地区",
"861889433", "甘肃省兰州市",
"861865041", "福建省莆田市",
"861337562", "山东省泰安市",
"861380612", "江苏省常州市",
"861507682", "河北省衡水市",
"861803328", "广东省潮州市",
"861392197", "江苏省苏州市",
"861370355", "山西省临汾市",
"861897185", "湖北省荆门市",
"861588438", "四川省乐山市",
"861850996", "新疆巴音郭楞蒙古自治州",
"861709649", "山东省潍坊市",
"861348295", "河北省邢台市",
"861816442", "安徽省芜湖市",
"861532623", "辽宁省营口市",
"861325789", "广西玉林市",
"861537482", "内蒙古兴安盟",
"861857378", "湖南省株洲市",
"86133092", "陕西省西安市",
"861325391", "河南省漯河市",
"861344162", "河北省石家庄市",
"861780327", "河北省沧州市",
"861317423", "湖南省湘西土家族苗族自治州",
"861370310", "河北省邯郸市",
"861530730", "湖南省岳阳市",
"86137639", "江西省赣州市",
"861822773", "四川省自贡市",
"861397289", "湖北省荆门市",
"861839479", "甘肃省兰州市",
"861870427", "辽宁省盘锦市",
"861595554", "安徽省马鞍山市",
"861363581", "湖北省孝感市",
"86186566", "安徽省池州市",
"86134247", "广东省东莞市",
"861848199", "四川省巴中市",
"861310718", "湖南省娄底市",
"861363207", "广东省江门市",
"861330394", "河南省周口市",
"861593649", "河南省安阳市",
"861454199", "山西省运城市",
"861376924", "云南省大理白族自治州",
"86170778", "浙江省宁波市",
"861374983", "河南省三门峡市",
"861586597", "山东省临沂市",
"861350901", "广东省东莞市",
"861366551", "安徽省合肥市",
"861864526", "黑龙江省牡丹江市",
"861334905", "安徽省马鞍山市",
"86188500", "福建省厦门市",
"86139733", "湖南省株洲市",
"861817048", "江西省赣州市",
"861870911", "陕西省延安市",
"861320942", "甘肃省酒泉市",
"861850543", "山东省滨州市",
"86134017", "江苏省盐城市",
"861565906", "福建省泉州市",
"86157723", "贵州省安顺市",
"86182415", "辽宁省丹东市",
"861300764", "河南省开封市",
"861520092", "湖南省长沙市",
"861551461", "河南省周口市",
"861389878", "辽宁省葫芦岛市",
"861563689", "黑龙江省鸡西市",
"861882965", "陕西省安康市",
"86135746", "湖南省永州市",
"861576616", "广东省深圳市",
"861898641", "湖北省鄂州市",
"861351581", "浙江省杭州市",
"861820423", "辽宁省朝阳市",
"861528888", "山东省东营市",
"861809585", "新疆巴音郭楞蒙古自治州",
"86152263", "湖南省永州市",
"861477174", "湖北省黄冈市",
"861388493", "山东省烟台市",
"861872777", "湖北省咸宁市",
"861566659", "山东省泰安市",
"861802998", "广东省惠州市",
"861871217", "安徽省安庆市",
"861372303", "河南省南阳市",
"861781734", "广东省湛江市",
"861576868", "广东省肇庆市",
"86137179", "北京市",
"86134072", "湖北省武汉市",
"86155758", "湖南省长沙市",
"861320933", "甘肃省平凉市",
"861850532", "山东省青岛市",
"86189632", "山东省枣庄市",
"861829269", "陕西省商洛市",
"861390497", "辽宁省营口市",
"861388161", "四川省雅安市",
"861533952", "贵州省遵义市",
"861860398", "河南省三门峡市",
"861365734", "湖南省衡阳市",
"861867145", "湖北省武汉市",
"861889442", "甘肃省酒泉市",
"86159629", "江苏省南通市",
"861450637", "黑龙江省绥化市",
"861345428", "浙江省湖州市",
"861364492", "辽宁省鞍山市",
"861454683", "广东省深圳市",
"861378450", "河北省秦皇岛市",
"86150445", "吉林省通化市",
"861899950", "新疆克拉玛依市",
"861536982", "河北省沧州市",
"861509456", "黑龙江省伊春市",
"861895677", "安徽省亳州市",
"861500773", "广西桂林市",
"861816433", "安徽省宣城市",
"861537227", "浙江省丽水市",
"861478715", "云南省保山市",
"861392676", "广东省汕头市",
"861378415", "河北省沧州市",
"861768714", "云南省曲靖市",
"861590255", "贵州省黔东南苗族侗族自治州",
"861316923", "广东省梅州市",
"861858405", "四川省成都市",
"861323460", "黑龙江省齐齐哈尔市",
"861312557", "辽宁省丹东市",
"861587288", "湖北省荆门市",
"861586383", "山东省烟台市",
"861310606", "浙江省衢州市",
"861334534", "新疆喀什地区",
"861847831", "湖南省岳阳市",
"861533314", "河北省承德市",
"861780785", "广西玉林市",
"861367478", "内蒙古呼和浩特市",
"861874068", "陕西省榆林市",
"861840208", "广东省佛山市",
"861318447", "浙江省温州市",
"861882458", "广东省深圳市",
"861769130", "陕西省榆林市",
"861342411", "广东省广州市",
"86136803", "广东省珠海市",
"861308953", "黑龙江省七台河市",
"861516532", "山东省青岛市",
"861807807", "广西梧州市",
"861315471", "内蒙古呼和浩特市",
"861319625", "吉林省辽源市",
"861804013", "辽宁省大连市",
"861322554", "安徽省淮南市",
"861453273", "山西省太原市",
"861313742", "河南省许昌市",
"861573390", "河北省邢台市",
"861835697", "安徽省芜湖市",
"861329862", "湖南省益阳市",
"86152796", "江西省吉安市",
"861898929", "四川省绵阳市",
"861479179", "陕西省咸阳市",
"861458699", "山东省莱芜市",
"861571308", "河北省衡水市",
"861893168", "河北省廊坊市",
"861321961", "陕西省榆林市",
"861778118", "四川省内江市",
"861344003", "四川省广元市",
"861330477", "内蒙古鄂尔多斯市",
"86151857", "贵州省黔东南苗族侗族自治州",
"861817876", "广西钦州市",
"861550433", "吉林省延边朝鲜族自治州",
"861811245", "江苏省无锡市",
"861567690", "广西来宾市",
"861315565", "安徽省合肥市",
"861573906", "新疆塔城地区",
"861316046", "江苏省南京市",
"861302496", "福建省南平市",
"861810691", "福建省福州市",
"86177094", "甘肃省兰州市",
"861805497", "福建省漳州市",
"861520522", "江苏省徐州市",
"861323918", "陕西省延安市",
"861587011", "贵州省遵义市",
"861589996", "广东省广州市",
"861560236", "广东省肇庆市",
"861524000", "安徽省滁州市",
"861479729", "山西省晋中市",
"861896613", "浙江省台州市",
"86158499", "内蒙古赤峰市",
"861883840", "河南省安阳市",
"861370263", "广东省佛山市",
"861887635", "福建省泉州市",
"861573976", "新疆阿克苏地区",
"861807159", "湖北省荆门市",
"861560698", "福建省泉州市",
"861330407", "辽宁省营口市",
"86151850", "贵州省贵阳市",
"861344073", "上海市",
"86183435", "吉林省通化市",
"861555039", "山东省莱芜市",
"861322185", "浙江省温州市",
"8618911", "北京市",
"861365898", "西藏拉萨市",
"861524070", "广西南宁市",
"861808735", "云南省昆明市",
"86153620", "广东省东莞市",
"861376360", "黑龙江省牡丹江市",
"861338646", "山东省潍坊市",
"861595377", "山东省德州市",
"861363706", "安徽省合肥市",
"861707847", "云南省德宏傣族景颇族自治州",
"861597764", "广西百色市",
"861325273", "辽宁省沈阳市",
"861874746", "内蒙古锡林郭勒盟",
"861315401", "陕西省榆林市",
"861514188", "辽宁省铁岭市",
"861386662", "安徽省安庆市",
"861571378", "河南省开封市",
"861807266", "浙江省舟山市",
"861340631", "山东省威海市",
"861522721", "河北省沧州市",
"861770739", "湖南省邵阳市",
"861479109", "陕西省西安市",
"861708551", "安徽省合肥市",
"861332238", "辽宁省盘锦市",
"861452649", "江苏省宿迁市",
"861302556", "广东省肇庆市",
"861301314", "安徽省宣城市",
"861817194", "湖北省黄石市",
"861359954", "福建省厦门市",
"861509026", "河南省许昌市",
"861360470", "内蒙古呼伦贝尔市",
"861776854", "江苏省扬州市",
"861511770", "贵州省铜仁地区",
"861502891", "河北省邢台市",
"861537697", "山东省烟台市",
"861536445", "湖南省怀化市",
"861882036", "广东省肇庆市",
"86182596", "福建省漳州市",
"861572099", "江西省抚州市",
"86150402", "辽宁省沈阳市",
"861832671", "安徽省铜陵市",
"861598341", "四川省凉山彝族自治州",
"861802565", "广东省中山市",
"861306047", "陕西省宝鸡市",
"861324258", "广东省潮州市",
"861815496", "新疆喀什地区",
"861356306", "山东省滨州市",
"861877689", "广西南宁市",
"861339365", "广西玉林市",
"861889985", "广东省深圳市",
"861316768", "安徽省亳州市",
"861865690", "安徽省六安市",
"86151189", "广东省惠州市",
"86186323", "河北省张家口市",
"861885011", "福建省福州市",
"861358148", "湖北省宜昌市",
"86159662", "山东省聊城市",
"861378020", "河北省石家庄市",
"861337095", "山东省聊城市",
"861360642", "山东省青岛市",
"861564209", "辽宁省铁岭市",
"86186895", "海南省海口市",
"86139326", "河北省廊坊市",
"861568254", "四川省成都市",
"86187523", "江苏省淮安市",
"861500703", "江西省上饶市",
"861575934", "福建省宁德市",
"861337525", "江苏省盐城市",
"861535397", "陕西省延安市",
"861573842", "河南省郑州市",
"861826231", "江苏省泰州市",
"861364552", "安徽省蚌埠市",
"861355760", "广西南宁市",
"861378590", "河北省邢台市",
"861390557", "安徽省宿州市",
"861826870", "浙江省舟山市",
"861871608", "河北省唐山市",
"861820755", "广东省深圳市",
"861327040", "江苏省连云港市",
"861336019", "广东省云浮市",
"861561569", "山东省临沂市",
"861315998", "黑龙江省佳木斯市",
"861510391", "甘肃省张掖市",
"861359312", "山西省晋中市",
"861558895", "山东省莱芜市",
"86152041", "辽宁省锦州市",
"861351866", "山东省东营市",
"861361489", "内蒙古锡林郭勒盟",
"861883392", "河北省石家庄市",
"861510789", "广西钦州市",
"861357959", "新疆博尔塔拉蒙古自治州",
"861474033", "辽宁省鞍山市",
"86150459", "黑龙江省大庆市",
"861572529", "山东省临沂市",
"861596313", "山东省济南市",
"86182679", "浙江省金华市",
"861858561", "贵州省铜仁地区",
"861869060", "新疆阿勒泰地区",
"861808948", "甘肃省张掖市",
"861825029", "福建省泉州市",
"861531233", "江苏省淮安市",
"861375706", "浙江省湖州市",
"861309851", "贵州省贵阳市",
"861594743", "内蒙古通辽市",
"861814441", "广东省潮州市",
"861803414", "河北省石家庄市",
"86180011", "北京市",
"861565145", "江苏省宿迁市",
"861477104", "湖北省荆州市",
"861806190", "江苏省无锡市",
"861509943", "新疆伊犁哈萨克自治州",
"861452417", "辽宁省营口市",
"861884624", "黑龙江省鸡西市",
"861301952", "内蒙古呼伦贝尔市",
"861881181", "广东省云浮市",
"861389808", "辽宁省朝阳市",
"861515942", "福建省宁德市",
"861338514", "贵州省贵阳市",
"861337793", "湖北省仙桃市",
"86156199", "陕西省榆林市",
"86134010", "北京市",
"861597677", "广东省汕尾市",
"861532301", "广东省汕尾市",
"86136401", "广东省韶关市",
"861852731", "湖北省宜昌市",
"861761297", "陕西省汉中市",
"86184688", "江苏省南京市",
"86150861", "贵州省黔南布依族苗族自治州",
"861700363", "广东省深圳市",
"861517258", "湖北省襄樊市",
"861388909", "西藏拉萨市",
"861340451", "吉林省通化市",
"861332098", "四川省成都市",
"861472981", "陕西省延安市",
"8613817", "上海市",
"861814203", "浙江省宁波市",
"861531523", "山东省淄博市",
"861810531", "山东省济南市",
"861880418", "辽宁省阜新市",
"861458539", "河南省漯河市",
"861329012", "山东省泰安市",
"861360762", "河南省平顶山市",
"861309967", "云南省保山市",
"861381333", "江苏省淮安市",
"861804863", "四川省德阳市",
"86152202", "广东省深圳市",
"861812488", "广东省阳江市",
"861809849", "安徽省亳州市",
"861807568", "湖南省娄底市",
"861314459", "黑龙江省大庆市",
"861333322", "河北省保定市",
"861893499", "广西百色市",
"86147833", "河南省信阳市",
"861332536", "陕西省汉中市",
"861571754", "湖南省怀化市",
"861310008", "山西省吕梁市",
"861599921", "新疆阿克苏地区",
"861317070", "云南省曲靖市",
"86186309", "天津市",
"861816840", "江苏省南京市",
"861857941", "广西柳州市",
"861319733", "湖北省宜昌市",
"861337235", "浙江省台州市",
"86187552", "安徽省蚌埠市",
"861334694", "河南省郑州市",
"861827902", "江西省宜春市",
"861552589", "山西省运城市",
"861362153", "江苏省无锡市",
"861504721", "内蒙古包头市",
"861840576", "浙江省台州市",
"86188571", "浙江省杭州市",
"861452769", "广西南宁市",
"861882296", "广东省东莞市",
"861768881", "广东省东莞市",
"861572239", "青海省海西蒙古族藏族自治州",
"861770318", "河北省衡水市",
"861599417", "河南省周口市",
"861331379", "福建省南平市",
"861346979", "湖北省孝感市",
"861859624", "山东省临沂市",
"861304494", "江西省抚州市",
"86187966", "江苏省扬州市",
"861857629", "广东省潮州市",
"861776149", "四川省阿坝藏族羌族自治州",
"861328407", "黑龙江省佳木斯市",
"86182144", "云南省曲靖市",
"861850353", "山西省阳泉市",
"861321109", "河北省邢台市",
"861556531", "河南省许昌市",
"861859167", "陕西省延安市",
"861569575", "浙江省绍兴市",
"861366341", "山西省阳泉市",
"861539058", "甘肃省嘉峪关市",
"861880960", "宁夏银川市",
"861521740", "广东省佛山市",
"861330380", "河南省新乡市",
"861450597", "辽宁省盘锦市",
"861522969", "陕西省延安市",
"861506063", "福建省泉州市",
"861707874", "云南省红河哈尼族彝族自治州",
"86136862", "广东省东莞市",
"861308579", "广东省汕头市",
"861595344", "山东省德州市",
"86189881", "云南省西双版纳傣族自治州",
"861803679", "江苏省泰州市",
"861569461", "云南省文山壮族苗族自治州",
"86186352", "山西省晋中市",
"861866940", "山东省青岛市",
"861550840", "四川省宜宾市",
"861505995", "福建省南平市",
"861380361", "黑龙江省齐齐哈尔市",
"861576018", "四川省巴中市",
"861309242", "江苏省常州市",
"861339831", "四川省资阳市",
"861383923", "河南省鹤壁市",
"861890732", "湖南省湘潭市",
"861831422", "云南省普洱市",
"861868198", "陕西省咸阳市",
"861306074", "广东省梅州市",
"86159778", "广西河池市",
"861319035", "辽宁省葫芦岛市",
"86131515", "江苏省南京市",
"861864737", "内蒙古呼和浩特市",
"86152259", "河南省新乡市",
"861476939", "云南省普洱市",
"861331932", "江西省上饶市",
"861883433", "山西省长治市",
"861591775", "广东省惠州市",
"861380916", "陕西省汉中市",
"861860783", "广西桂林市",
"861339270", "广东省东莞市",
"861346332", "河北省张家口市",
"861705554", "四川省成都市",
"861370545", "山东省烟台市",
"861332528", "山东省泰安市",
"861364711", "湖北省鄂州市",
"861815987", "福建省三明市",
"861384954", "河南省平顶山市",
"861323702", "江西省九江市",
"861453441", "辽宁省沈阳市",
"861591125", "云南省文山壮族苗族自治州",
"861811563", "江苏省盐城市",
"861334913", "安徽省宣城市",
"86138630", "山东省威海市",
"861566439", "河南省三门峡市",
"86152245", "广西北海市",
"86136486", "海南省海口市",
"861361312", "河北省保定市",
"861350829", "四川省甘孜藏族自治州",
"861822750", "四川省内江市",
"86138637", "山东省济宁市",
"861369866", "山东省青岛市",
"861459789", "新疆克拉玛依市",
"861323772", "广西柳州市",
"861778922", "陕西省渭南市",
"861598072", "福建省福州市",
"861899828", "广东省茂名市",
"861560526", "江苏省泰州市",
"861318474", "河北省石家庄市",
"861518191", "四川省遂宁市",
"861527984", "江西省吉安市",
"86182728", "河南省周口市",
"86157709", "江西省宜春市",
"861369618", "四川省广安市",
"861557848", "广西南宁市",
"861580759", "广东省湛江市",
"861364333", "河北省张家口市",
"861339200", "广东省惠州市",
"861890488", "黑龙江省哈尔滨市",
"861591705", "广东省韶关市",
"861340021", "河北省石家庄市",
"861360387", "河南省周口市",
"86150463", "黑龙江省牡丹江市",
"861811151", "四川省德阳市",
"861898761", "云南省文山壮族苗族自治州",
"861518463", "黑龙江省鸡西市",
"861856215", "山东省德州市",
"861321729", "湖北省荆州市",
"86189578", "浙江省宁波市",
"861803609", "江苏省苏州市",
"861580827", "四川省巴中市",
"861333253", "湖南省株洲市",
"861819468", "青海省果洛藏族自治州",
"861300644", "四川省德阳市",
"861308509", "安徽省六安市",
"861302987", "黑龙江省哈尔滨市",
"861813683", "江苏省泰州市",
"861454519", "湖南省永州市",
"861328477", "内蒙古鄂尔多斯市",
"86134830", "河北省邯郸市",
"861350757", "福建省三明市",
"861539436", "浙江省金华市",
"861330444", "吉林省吉林市",
"861834730", "内蒙古鄂尔多斯市",
"861337388", "浙江省宁波市",
"861873530", "山西省阳泉市",
"861336869", "贵州省贵阳市",
"861891240", "江苏省南通市",
"861848519", "贵州省遵义市",
"86147431", "吉林省长春市",
"861569505", "宁夏中卫市",
"861311854", "贵州省黔南布依族苗族自治州",
"861554300", "吉林省长春市",
"861346909", "湖南省湘西土家族苗族自治州",
"861535139", "四川省资阳市",
"861303523", "湖北省襄樊市",
"861331309", "河北省邢台市",
"861808623", "湖北省宜昌市",
"861476302", "山东省烟台市",
"861475549", "安徽省六安市",
"861324496", "广东省东莞市",
"861550392", "河南省鹤壁市",
"861888246", "四川省绵阳市",
"86136829", "广东省汕头市",
"86188888", "北京市",
"861323825", "辽宁省丹东市",
"86183151", "重庆市",
"861587586", "广东省茂名市",
"861305488", "山东省淄博市",
"861502000", "山东省济南市",
"861313662", "黑龙江省齐齐哈尔市",
"861857299", "湖北省武汉市",
"861304554", "安徽省宣城市",
"861591003", "山东省烟台市",
"861530888", "云南省丽江市",
"861310078", "湖北省宜昌市",
"861705882", "广东省佛山市",
"861317000", "安徽省滁州市",
"861872744", "湖北省荆州市",
"861787612", "广东省汕头市",
"861335688", "山东省青岛市",
"861338933", "甘肃省兰州市",
"861550653", "山东省菏泽市",
"861362475", "内蒙古通辽市",
"861896589", "福建省莆田市",
"861772774", "广东省东莞市",
"861562481", "内蒙古呼和浩特市",
"861555941", "新疆和田地区",
"86157752", "四川省泸州市",
"861355853", "四川省达州市",
"861529989", "新疆吐鲁番地区",
"861878826", "云南省红河哈尼族彝族自治州",
"861525902", "福建省龙岩市",
"861869152", "陕西省西安市",
"861800560", "安徽省合肥市",
"86158771", "广西南宁市",
"86130078", "贵州省贵阳市",
"861348742", "湖南省湘西土家族苗族自治州",
"861863412", "河北省邯郸市",
"861867251", "湖北省黄冈市",
"861303795", "宁夏固原市",
"861398659", "湖北省黄石市",
"861893559", "青海省海西蒙古族藏族自治州",
"861362561", "安徽省淮北市",
"861570962", "宁夏石嘴山市",
"861560538", "山东省泰安市",
"861350348", "河南省开封市",
"861390986", "辽宁省大连市",
"861361954", "宁夏固原市",
"861338048", "广东省汕头市",
"86189483", "广东省深圳市",
"861571629", "江苏省南通市",
"86139545", "山东省烟台市",
"86599", "福建省南平市",
"861538998", "新疆塔城地区",
"861582009", "山东省济南市",
"861476530", "辽宁省沈阳市",
"861478075", "四川省南充市",
"861318397", "四川省宜宾市",
"861768074", "湖南省怀化市",
"861336709", "江西省南昌市",
"861345899", "四川省德阳市",
"861592441", "内蒙古呼和浩特市",
"861812743", "广东省广州市",
"861471702", "甘肃省定西市",
"861869389", "甘肃省陇南市",
"861353954", "广东省汕尾市",
"861774244", "陕西省榆林市",
"861898801", "云南省丽江市",
"861360725", "湖北省黄冈市",
"861865684", "安徽省宿州市",
"86182843", "四川省乐山市",
"861776437", "安徽省池州市",
"861850487", "内蒙古鄂尔多斯市",
"861572858", "广东省韶关市",
"86177312", "河北省保定市",
"861348733", "湖南省株洲市",
"861859827", "广东省深圳市",
"861569934", "新疆巴音郭楞蒙古自治州",
"86132892", "陕西省西安市",
"861705377", "北京市",
"861707764", "云南省昆明市",
"861804075", "新疆乌鲁木齐市",
"861808371", "江苏省泰州市",
"861597847", "河南省驻马店市",
"861826640", "山东省菏泽市",
"861360593", "福建省龙岩市",
"86150813", "河北省张家口市",
"861347409", "陕西省咸阳市",
"861708341", "山西省大同市",
"861859759", "福建省宁德市",
"861302346", "江苏省连云港市",
"861880569", "安徽省合肥市",
"861874274", "新疆塔城地区",
"861880324", "河北省承德市",
"861322480", "内蒙古乌海市",
"861860279", "湖北省恩施土家族苗族自治州",
"861328394", "河南省周口市",
"861583370", "河北省邢台市",
"861570068", "四川省自贡市",
"861308970", "黑龙江省哈尔滨市",
"861831958", "广东省汕尾市",
"861786883", "陕西省渭南市",
"861841986", "甘肃省武威市",
"861839546", "陕西省榆林市",
"861338942", "甘肃省定西市",
"861778036", "四川省甘孜藏族自治州",
"861369706", "江西省吉安市",
"86187374", "河南省许昌市",
"861806184", "江苏省南京市",
"861589222", "四川省自贡市",
"861806495", "四川省广安市",
"861564398", "吉林省白山市",
"861812045", "湖北省襄樊市",
"861316567", "湖北省黄石市",
"86138221", "广东省广州市",
"86183065", "山东省临沂市",
"861301656", "江苏省淮安市",
"861882797", "江西省赣州市",
"86186574", "浙江省宁波市",
"861478773", "云南省文山壮族苗族自治州",
"861310339", "河北省邢台市",
"861373059", "河北省沧州市",
"861458317", "江西省宜春市",
"861303851", "陕西省商洛市",
"861811792", "四川省达州市",
"861338267", "江苏省徐州市",
"861760478", "内蒙古巴彦淖尔市",
"861508601", "贵州省贵阳市",
"86133550", "山东省临沂市",
"86135904", "广东省深圳市",
"861596305", "山东省济宁市",
"861310846", "陕西省汉中市",
"861379898", "广东省珠海市",
"861837447", "湖南省长沙市",
"861331456", "黑龙江省黑河市",
"861360872", "云南省大理白族自治州",
"861778028", "四川省成都市",
"861304307", "福建省漳州市",
"861598978", "广东省珠海市",
"861394877", "内蒙古鄂尔多斯市",
"861341488", "广东省湛江市",
"861348035", "广东省云浮市",
"861346570", "山东省潍坊市",
"861587121", "湖北省黄石市",
"861899973", "新疆石河子市",
"861313295", "广西玉林市",
"861478123", "四川省雅安市",
"861332144", "吉林省延边朝鲜族自治州",
"861360023", "广东省云浮市",
"86131028", "河北省石家庄市",
"861500750", "广东省江门市",
"861767113", "湖北省十堰市",
"861824092", "新疆阿勒泰地区",
"861777263", "河北省邢台市",
"861867602", "广东省中山市",
"86137794", "新疆阿克苏地区",
"861858170", "四川省南充市",
"86139926", "陕西省汉中市",
"86155842", "吉林省长春市",
"861390347", "山西省临汾市",
"861844930", "新疆阿克苏地区",
"861860448", "吉林省吉林市",
"861452879", "宁夏银川市",
"861889392", "甘肃省定西市",
"861338876", "云南省文山壮族苗族自治州",
"861529837", "江苏省南京市",
"861858720", "云南省大理白族自治州",
"861364342", "山西省大同市",
"861885701", "浙江省衢州市",
"861554532", "黑龙江省牡丹江市",
"861361741", "湖南省株洲市",
"861890743", "湖南省湘西土家族苗族自治州",
"86150411", "辽宁省大连市",
"861505647", "安徽省芜湖市",
"861800969", "安徽省合肥市",
"861775130", "江苏省南通市",
"861764059", "辽宁省盘锦市",
"861514221", "辽宁省鞍山市",
"861509116", "陕西省渭南市",
"861831287", "广东省梅州市",
"861537319", "河北省邢台市",
"861377739", "浙江省杭州市",
"86131930", "重庆市",
"861300847", "陕西省宝鸡市",
"861331943", "江西省南昌市",
"861883442", "山西省忻州市",
"861586637", "山东省烟台市",
"861346343", "河北省廊坊市",
"861397013", "江西省赣州市",
"861329460", "山西省忻州市",
"861853034", "河南省三门峡市",
"861535447", "河北省沧州市",
"861354768", "四川省眉山市",
"86139502", "福建省福州市",
"861454468", "陕西省延安市",
"861817646", "广西百色市",
"861893950", "河南省郑州市",
"861555754", "浙江省绍兴市",
"861885121", "江苏省常州市",
"861372315", "河南省焦作市",
"861315232", "陕西省咸阳市",
"861788127", "新疆伊犁哈萨克自治州",
"861536686", "江苏省扬州市",
"861774016", "四川省南充市",
"861304377", "河南省南阳市",
"861865939", "福建省宁德市",
"861508087", "湖南省湘西土家族苗族自治州",
"861840399", "河南省驻马店市",
"861399541", "宁夏银川市",
"861576912", "陕西省榆林市",
"861772864", "广东省江门市",
"861338485", "内蒙古包头市",
"861331038", "内蒙古赤峰市",
"861365429", "辽宁省葫芦岛市",
"861899903", "新疆哈密地区",
"861538471", "内蒙古呼和浩特市",
"861346500", "山东省菏泽市",
"861871564", "安徽省六安市",
"861394807", "内蒙古呼伦贝尔市",
"86182441", "吉林省白城市",
"861378403", "河北省石家庄市",
"861843235", "河北省唐山市",
"861823269", "河北省廊坊市",
"861814391", "河南省焦作市",
"861858413", "四川省泸州市",
"861773342", "河北省秦皇岛市",
"861760408", "辽宁省大连市",
"861587701", "广西桂林市",
"861331596", "河北省石家庄市",
"861538565", "安徽省马鞍山市",
"861471825", "广东省河源市",
"861327531", "山东省济南市",
"861350256", "广东省揭阳市",
"861573384", "河北省张家口市",
"861392339", "广东省珠海市",
"861323862", "云南省曲靖市",
"861454955", "江苏省徐州市",
"861598163", "吉林省通化市",
"861360453", "黑龙江省牡丹江市",
"861891451", "江苏省泰州市",
"861319742", "湖北省咸宁市",
"861332992", "湖北省黄石市",
"861313625", "浙江省舟山市",
"861848910", "西藏拉萨市",
"86139228", "广东省深圳市",
"861308396", "浙江省杭州市",
"861871848", "广东省深圳市",
"861347479", "内蒙古锡林郭勒盟",
"861329918", "陕西省商洛市",
"86136412", "北京市",
"861378852", "广西柳州市",
"861860209", "广东省东莞市",
"861364890", "西藏拉萨市",
"861373429", "山西省运城市",
"861760991", "新疆乌鲁木齐市",
"861524053", "江苏省常州市",
"86155805", "湖南省张家界市",
"861898871", "广东省东莞市",
"861815839", "浙江省金华市",
"861310902", "新疆昌吉回族自治州",
"861330819", "四川省成都市",
"861454337", "内蒙古鄂尔多斯市",
"861705307", "上海市",
"861820070", "广东省深圳市",
"861381342", "江苏省盐城市",
"861532948", "贵州省六盘水市",
"861570746", "湖南省永州市",
"861582079", "广东省深圳市",
"861570925", "陕西省安康市",
"861536395", "广东省珠海市",
"861476887", "山东省滨州市",
"861344015", "四川省南充市",
"861818793", "云南省丽江市",
"861598491", "四川省德阳市",
"861559960", "新疆和田地区",
"861325250", "吉林省松原市",
"861336779", "广西北海市",
"861312347", "广西钦州市",
"861355191", "四川省南充市",
"86158365", "河南省许昌市",
"861560677", "浙江省温州市",
"861881847", "广东省清远市",
"861805408", "安徽省安庆市",
"861827178", "湖北省襄樊市",
"861831791", "江西省南昌市",
"861316913", "广东省湛江市",
"861862876", "吉林省四平市",
"861365877", "云南省玉溪市",
"861893274", "河北省石家庄市",
"861390991", "新疆乌鲁木齐市",
"86159397", "河南省信阳市",
"861471803", "广东省梅州市",
"861478725", "云南省普洱市",
"861537217", "浙江省舟山市",
"861518402", "辽宁省大连市",
"861318629", "陕西省安康市",
"86158668", "山东省青岛市",
"861348832", "陕西省西安市",
"861813529", "山西省大同市",
"861571397", "河南省洛阳市",
"861393130", "河北省张家口市",
"861330558", "安徽省阜阳市",
"861700939", "江苏省徐州市",
"861387183", "湖北省鄂州市",
"861843959", "河南省驻马店市",
"861847661", "广东省湛江市",
"861557945", "江西省宜春市",
"861899746", "青海省玉树藏族自治州",
"861527019", "江西省九江市",
"861865210", "江苏省连云港市",
"861365159", "江苏省盐城市",
"861778136", "四川省德阳市",
"86189631", "山东省威海市",
"861890390", "河南省平顶山市",
"861524561", "黑龙江省哈尔滨市",
"861530600", "福建省厦门市",
"861551967", "贵州省六盘水市",
"861304279", "湖北省襄樊市",
"861820413", "辽宁省抚顺市",
"861323936", "甘肃省张掖市",
"861840297", "陕西省渭南市",
"861473009", "河北省邢台市",
"861329632", "山东省枣庄市",
"86134071", "湖北省武汉市",
"861346790", "湖南省湘潭市",
"861824895", "江苏省连云港市",
"86170997", "广东省江门市",
"861377414", "湖北省随州市",
"861321338", "河南省许昌市",
"861324481", "广东省广州市",
"861869958", "新疆哈密地区",
"861771534", "江苏省常州市",
"861510535", "山东省烟台市",
"861576626", "广东省深圳市",
"86138159", "江苏省泰州市",
"861890906", "四川省遂宁市",
"861379647", "黑龙江省鹤岗市",
"861861546", "山东省东营市",
"861823367", "河北省沧州市",
"86134687", "陕西省西安市",
"861855106", "江苏省无锡市",
"861811572", "江苏省徐州市",
"861331706", "江西省吉安市",
"861367557", "安徽省宿州市",
"861477714", "广西梧州市",
"86184704", "江西省赣州市",
"861332044", "云南省怒江傈僳族自治州",
"861520512", "江苏省连云港市",
"861535378", "陕西省咸阳市",
"861593282", "江西省宜春市",
"861894684", "青海省西宁市",
"861321467", "黑龙江省鸡西市",
"861570903", "新疆和田地区",
"861896623", "浙江省宁波市",
"861479719", "山西省太原市",
"861328169", "四川省雅安市",
"861778128", "四川省南充市",
"861823438", "山西省阳泉市",
"861811893", "江苏省盐城市",
"861347759", "湖北省襄樊市",
"861379419", "广东省中山市",
"861354146", "四川省甘孜藏族自治州",
"861315977", "吉林省长春市",
"86137260", "广东省中山市",
"861504492", "内蒙古鄂尔多斯市",
"86135914", "辽宁省沈阳市",
"861777651", "广西桂林市",
"861898919", "四川省南充市",
"861450276", "内蒙古赤峰市",
"861804872", "四川省达州市",
"861390408", "辽宁省大连市",
"861839280", "陕西省渭南市",
"861360773", "广西桂林市",
"861373159", "河北省邢台市",
"861521587", "浙江省金华市",
"861369456", "黑龙江省黑河市",
"861554981", "湖北省鄂州市",
"861319615", "吉林省通化市",
"861321326", "河南省安阳市",
"861576638", "广东省湛江市",
"861530985", "辽宁省沈阳市",
"86132720", "湖南省长沙市",
"861834840", "河南省郑州市",
"861330971", "青海省西宁市",
"861534692", "甘肃省定西市",
"861336459", "吉林省吉林市",
"861533569", "内蒙古锡林郭勒盟",
"861705209", "黑龙江省哈尔滨市",
"861311464", "黑龙江省七台河市",
"861303689", "广西北海市",
"86147683", "山东省临沂市",
"861471452", "广东省广州市",
"86139570", "浙江省丽水市",
"861533324", "河北省廊坊市",
"861580356", "山西省晋城市",
"861813099", "新疆伊犁哈萨克自治州",
"861876285", "江苏省南通市",
"861579743", "湖北省荆州市",
"861459386", "贵州省黔西南布依族苗族自治州",
"86177359", "山西省运城市",
"861304448", "山西省吕梁市",
"861836203", "江苏省镇江市",
"861770585", "浙江省绍兴市",
"861326697", "广东省东莞市",
"861318941", "广东省江门市",
"861830370", "河南省商丘市",
"861534353", "山西省朔州市",
"86152005", "湖南省衡阳市",
"861474589", "黑龙江省齐齐哈尔市",
"861518853", "河南省许昌市",
"86184838", "四川省德阳市",
"861370964", "广东省茂名市",
"861884993", "云南省西双版纳傣族自治州",
"861890842", "湖南省邵阳市",
"86159661", "山东省潍坊市",
"86176926", "河北省廊坊市",
"861339741", "湖南省长沙市",
"861364969", "云南省普洱市",
"861569851", "山西省晋城市",
"861323065", "河北省廊坊市",
"861519578", "江苏省南京市",
"861550730", "湖南省岳阳市",
"861313673", "黑龙江省齐齐哈尔市",
"861336599", "福建省南平市",
"86177648", "重庆市",
"861597236", "湖北省黄石市",
"861864847", "内蒙古包头市",
"861471592", "广东省清远市",
"861830996", "新疆巴音郭楞蒙古自治州",
"861378055", "河北省唐山市",
"861705279", "山西省太原市",
"861802977", "广东省阳江市",
"86177345", "河北省石家庄市",
"861770154", "江苏省苏州市",
"861357562", "浙江省舟山市",
"861509016", "河南省洛阳市",
"861598765", "云南省文山壮族苗族自治州",
"861775030", "福建省福州市",
"861523667", "河南省洛阳市",
"861760347", "山西省临汾市",
"861351636", "山东省潍坊市",
"86150401", "辽宁省沈阳市",
"86139577", "浙江省温州市",
"861360703", "江西省上饶市",
"861308254", "江苏省南京市",
"861321285", "黑龙江省绥化市",
"861390478", "内蒙古巴彦淖尔市",
"861804802", "四川省成都市",
"861830543", "山东省滨州市",
"861860377", "河南省南阳市",
"861301324", "河北省保定市",
"86188335", "河北省秦皇岛市",
"861330901", "四川省绵阳市",
"861556088", "内蒙古通辽市",
"86132727", "重庆市",
"861354905", "西藏昌都地区",
"861301569", "福建省南平市",
"861805249", "江苏省无锡市",
"861350394", "河南省周口市",
"861570973", "青海省黄南藏族自治州",
"86188638", "山东省烟台市",
"86134136", "广东省湛江市",
"861338094", "广东省河源市",
"86133696", "新疆乌鲁木齐市",
"861700302", "广东省深圳市",
"861535308", "陕西省渭南市",
"861812906", "新疆阿勒泰地区",
"86136459", "福建省泉州市",
"861513664", "河南省商丘市",
"86137267", "广东省广州市",
"861780539", "山东省临沂市",
"861874950", "河南省商丘市",
"861840627", "辽宁省葫芦岛市",
"861857474", "湖南省湘西土家族苗族自治州",
"861314869", "广东省韶关市",
"861519951", "新疆阿勒泰地区",
"861890976", "青海省玉树藏族自治州",
"861458219", "安徽省池州市",
"861816730", "浙江省嘉兴市",
"861500470", "内蒙古呼伦贝尔市",
"861338369", "河北省邢台市",
"861362891", "西藏拉萨市",
"86136402", "广东省广州市",
"861524405", "山东省菏泽市",
"861314283", "江苏省南京市",
"861350069", "内蒙古呼和浩特市",
"861567255", "湖北省咸宁市",
"861331776", "广西百色市",
"86151643", "吉林省长春市",
"861338524", "湖北省荆门市",
"861323763", "江西省上饶市",
"86134680", "山东省泰安市",
"861566047", "山东省莱芜市",
"861319843", "四川省南充市",
"861332216", "辽宁省丹东市",
"861890145", "江苏省扬州市",
"861588334", "四川省眉山市",
"861530670", "浙江省衢州市",
"861335231", "辽宁省营口市",
"861525728", "浙江省嘉兴市",
"861760758", "广东省肇庆市",
"861452427", "辽宁省盘锦市",
"861478453", "黑龙江省牡丹江市",
"861305842", "广东省广州市",
"861303934", "吉林省长春市",
"861335870", "辽宁省辽阳市",
"861312408", "福建省厦门市",
"861862485", "河南省洛阳市",
"86170990", "贵州省贵阳市",
"861577160", "陕西省榆林市",
"861396579", "安徽省亳州市",
"861855945", "福建省龙岩市",
"86180681", "江苏省南通市",
"861500642", "山东省青岛市",
"861800890", "西藏拉萨市",
"861825019", "福建省福州市",
"861803424", "河北省石家庄市",
"86180012", "北京市",
"861567210", "湖北省十堰市",
"861768104", "安徽省六安市",
"861300698", "广西河池市",
"861572519", "山东省临沂市",
"861820720", "湖北省宜昌市",
"86152988", "江苏省苏州市",
"861388790", "云南省西双版纳傣族自治州",
"861857583", "广东省肇庆市",
"861320234", "广东省惠州市",
"861359322", "山西省忻州市",
"861558243", "山西省晋中市",
"86152424", "辽宁省沈阳市",
"861824944", "黑龙江省哈尔滨市",
"861337550", "山东省德州市",
"861810088", "云南省昆明市",
"861330498", "辽宁省阜新市",
"86170074", "湖南省长沙市",
"861336029", "广东省茂名市",
"861882018", "广东省深圳市",
"861560607", "福建省福州市",
"861390249", "广东省广州市",
"861337515", "江苏省苏州市",
"861893204", "贵州省黔南布依族苗族自治州",
"86155815", "湖南省怀化市",
"861818892", "湖南省永州市",
"861524153", "辽宁省锦州市",
"861472996", "陕西省西安市",
"861809739", "青海省海南藏族自治州",
"861380665", "浙江省宁波市",
"861363628", "湖北省恩施土家族苗族自治州",
"861372611", "广东省中山市",
"861341976", "河南省开封市",
"861778616", "湖北省黄冈市",
"861879141", "陕西省延安市",
"861326482", "湖北省黄冈市",
"86134599", "福建省南平市",
"861822642", "安徽省蚌埠市",
"861553314", "河北省承德市",
"861580479", "内蒙古锡林郭勒盟",
"861827237", "湖北省荆门市",
"861318754", "云南省昭通市",
"861569523", "江苏省泰州市",
"861570349", "山西省朔州市",
"861329112", "江苏省南通市",
"861360863", "河南省焦作市",
"861327211", "湖南省株洲市",
"861323452", "黑龙江省齐齐哈尔市",
"861376223", "湖南省湘潭市",
"861570836", "四川省甘孜藏族自治州",
"861821914", "广东省深圳市",
"86152121", "安徽省蚌埠市",
"861899962", "新疆巴音郭楞蒙古自治州",
"86189220", "广东省江门市",
"861592904", "陕西省渭南市",
"86152277", "河北省邢台市",
"86130536", "山东省潍坊市",
"861596087", "福建省漳州市",
"861856974", "湖南省湘西土家族苗族自治州",
"861311931", "甘肃省兰州市",
"86155627", "山东省菏泽市",
"861560874", "云南省曲靖市",
"861470313", "河北省张家口市",
"861308381", "河南省新乡市",
"861317720", "湖北省襄樊市",
"861810982", "辽宁省朝阳市",
"861811421", "江苏省南通市",
"861530433", "吉林省延边朝鲜族自治州",
"86183262", "安徽省六安市",
"861365674", "浙江省宁波市",
"861319832", "四川省宜宾市",
"86151793", "江西省上饶市",
"861350477", "吉林省吉林市",
"861308799", "广西南宁市",
"861305833", "广东省佛山市",
"861502720", "湖北省恩施土家族苗族自治州",
"861882912", "陕西省榆林市",
"861452282", "山西省晋中市",
"861471928", "甘肃省白银市",
"861369379", "河南省洛阳市",
"861892445", "广东省韶关市",
"861889730", "青海省海北藏族自治州",
"861500633", "山东省日照市",
"861874499", "贵州省黔西南布依族苗族自治州",
"86180242", "广东省中山市",
"861334567", "安徽省亳州市",
"861396685", "安徽省亳州市",
"861325535", "山东省烟台市",
"861591173", "云南省昆明市",
"861569795", "江西省宜春市",
"861860494", "辽宁省大连市",
"86186319", "河北省邢台市",
"86158943", "云南省西双版纳傣族自治州",
"861504687", "黑龙江省黑河市",
"861317170", "河北省沧州市",
"861520977", "青海省海西蒙古族藏族自治州",
"861838886", "云南省曲靖市",
"86153758", "福建省泉州市",
"861341842", "广东省佛山市",
"861882354", "广东省揭阳市",
"861814386", "西藏那曲地区",
"861830532", "山东省青岛市",
"861769620", "山西省吕梁市",
"861392178", "江苏省徐州市",
"86147062", "江苏省苏州市",
"86181654", "陕西省西安市",
"86181938", "甘肃省天水市",
"86130766", "广东省清远市",
"861826191", "江苏省南通市",
"86187519", "江苏省南京市",
"861533418", "湖北省咸宁市",
"861561058", "山东省潍坊市",
"861329850", "湖南省岳阳市",
"861367374", "河南省许昌市",
"86183824", "四川省成都市",
"861862766", "湖南省衡阳市",
"861782668", "江苏省南京市",
"861313321", "山西省晋中市",
"861310963", "陕西省咸阳市",
"861352385", "河南省新乡市",
"861309513", "新疆博尔塔拉蒙古自治州",
"861539158", "湖北省襄樊市",
"861840796", "江西省吉安市",
"861838153", "四川省乐山市",
"86151266", "云南省昭通市",
"861871945", "广东省深圳市",
"861379568", "四川省达州市",
"861377849", "四川省资阳市",
"861894887", "广东省中山市",
"861340701", "江西省鹰潭市",
"861771975", "陕西省渭南市",
"861770609", "福建省南平市",
"861806871", "江苏省徐州市",
"861869422", "河北省石家庄市",
"861838405", "四川省南充市",
"86181027", "广东省广州市",
"861328348", "河北省秦皇岛市",
"861510974", "青海省海南藏族自治州",
"861304783", "广西贺州市",
"861896301", "山东省德州市",
"861362710", "湖北省武汉市",
"861536691", "江苏省扬州市",
"861806230", "湖北省鄂州市",
"861556982", "甘肃省天水市",
"861860882", "云南省德宏傣族景颇族自治州",
"86177798", "江西省景德镇市",
"861300737", "湖南省益阳市",
"861369932", "新疆和田地区",
"86156783", "广西桂林市",
"861303505", "安徽省合肥市",
"861762517", "江苏省淮安市",
"861569093", "内蒙古呼伦贝尔市",
"861313430", "吉林省长春市",
"861571404", "辽宁省盘锦市",
"861700530", "山东省菏泽市",
"861771146", "四川省德阳市",
"861514140", "辽宁省本溪市",
"861319135", "内蒙古乌海市",
"861813920", "新疆伊犁哈萨克自治州",
"861532845", "四川省宜宾市",
"861537716", "湖北省咸宁市",
"86134676", "湖南省长沙市",
"861576118", "贵州省安顺市",
"861781767", "广东省湛江市",
"861570828", "四川省自贡市",
"86183558", "安徽省阜阳市",
"861709427", "广东省江门市",
"861571474", "内蒙古乌兰察布市",
"861707538", "山东省济宁市",
"861340121", "江苏省泰州市",
"861337959", "陕西省安康市",
"861314779", "吉林省辽源市",
"861301418", "甘肃省嘉峪关市",
"86157719", "陕西省西安市",
"861700887", "广东省深圳市",
"861339312", "河北省保定市",
"861579732", "湖北省宜昌市",
"86153232", "广东省阳江市",
"86145290", "广东省广州市",
"861323873", "云南省红河哈尼族彝族自治州",
"861572910", "河南省洛阳市",
"861331866", "广东省江门市",
"861598172", "新疆伊犁哈萨克自治州",
"861506551", "山东省威海市",
"86181020", "天津市",
"861510904", "新疆喀什地区",
"861771905", "河南省三门峡市",
"861322398", "河南省濮阳市",
"861326726", "广东省东莞市",
"861770679", "浙江省金华市",
"86138253", "广东省河源市",
"861340771", "广西南宁市",
"861572955", "宁夏中卫市",
"861598722", "云南省楚雄彝族自治州",
"861513867", "河南省郑州市",
"861588416", "四川省泸州市",
"861871894", "广东省梅州市",
"861896371", "安徽省巢湖市",
"861800333", "河北省秦皇岛市",
"861894530", "黑龙江省牡丹江市",
"861843490", "山西省运城市",
"861593427", "山西省忻州市",
"861303193", "河北省张家口市",
"86159613", "江苏省连云港市",
"861367682", "浙江省金华市",
"861571583", "浙江省绍兴市",
"861362423", "辽宁省抚顺市",
"861587240", "湖北省武汉市",
"861870649", "山东省滨州市",
"861831810", "广东省湛江市",
"86180205", "江苏省徐州市",
"861554212", "辽宁省朝阳市",
"861855227", "江苏省南京市",
"861321079", "山东省济宁市",
"86138876", "云南省文山壮族苗族自治州",
"861310736", "湖南省常德市",
"861520907", "新疆博尔塔拉蒙古自治州",
"861532994", "贵州省六盘水市",
"8613888", "云南省昆明市",
"861386650", "安徽省铜陵市",
"861332717", "内蒙古包头市",
"861367304", "河南省安阳市",
"861810445", "吉林省通化市",
"861593366", "河北省承德市",
"861531505", "山东省东营市",
"861331277", "云南省普洱市",
"861831855", "广东省云浮市",
"861865363", "山东省淄博市",
"861476255", "江苏省苏州市",
"861517749", "广西玉林市",
"861301960", "辽宁省鞍山市",
"861370431", "吉林省吉林市",
"86186951", "宁夏银川市",
"861310178", "河南省开封市",
"861470731", "湖南省长沙市",
"861572468", "辽宁省抚顺市",
"861329643", "山东省淄博市",
"861550261", "辽宁省沈阳市",
"861871482", "安徽省合肥市",
"861864516", "黑龙江省双鸭山市",
"861596601", "山东省泰安市",
"86756", "广东省珠海市",
"861841991", "甘肃省陇南市",
"86159066", "浙江省杭州市",
"86710", "湖北省襄樊市\、襄樊市",
"861780930", "甘肃省临夏回族自治州",
"861576797", "广东省惠州市",
"861529358", "甘肃省天水市",
"861705783", "浙江省杭州市",
"861860554", "安徽省淮南市",
"86155620", "山东省菏泽市",
"861383905", "河南省新乡市",
"861777202", "广西柳州市",
"86147029", "陕西省西安市",
"86187383", "河南省新乡市",
"861867663", "广东省广州市",
"86139586", "浙江省台州市",
"861302749", "湖南省长沙市",
"861859356", "福建省龙岩市",
"861870417", "辽宁省营口市",
"861535039", "江西省新余市",
"86185435", "吉林省通化市",
"861561428", "河北省邢台市",
"861310728", "湖南省娄底市",
"861780317", "河北省沧州市",
"861336990", "新疆克拉玛依市",
"861317413", "江苏省扬州市",
"861370320", "河北省邯郸市",
"861359365", "湖北省黄冈市",
"86152270", "河北省保定市",
"861364560", "安徽省合肥市",
"86189227", "广东省广州市",
"861355752", "广西柳州市",
"861592974", "陕西省咸阳市",
"86181593", "福建省泉州市",
"861812833", "广东省揭阳市",
"861772024", "湖北省孝感市",
"861532613", "辽宁省沈阳市",
"861591455", "广东省佛山市",
"861869052", "陕西省延安市",
"861348843", "陕西省渭南市",
"861869786", "青海省玉树藏族自治州",
"861341906", "四川省达州市",
"86186478", "内蒙古巴彦淖尔市",
"861884817", "内蒙古通辽市",
"861339954", "安徽省淮南市",
"861323592", "福建省厦门市",
"86181236", "广东省深圳市",
"861803318", "广东省韶关市",
"861556445", "山东省淄博市",
"861782865", "四川省绵阳市",
"861850528", "江苏省徐州市",
"86133003", "天津市",
"861581891", "广东省茂名市",
"861361857", "贵州省贵阳市",
"861817872", "广西桂林市",
"861319274", "广东省河源市",
"861324333", "河南省许昌市",
"861596444", "山东省菏泽市",
"861787577", "广东省梅州市",
"86135833", "山东省淄博市",
"861302492", "福建省宁德市",
"861316042", "江苏省苏州市",
"86186728", "湖北省武汉市",
"861338400", "河南省郑州市",
"861520526", "江苏省泰州市",
"86138789", "广西北海市",
"861560232", "广东省广州市",
"861300751", "河南省郑州市",
"861881565", "安徽省合肥市",
"861777117", "湖北省黄石市",
"861589992", "广东省东莞市",
"861378539", "河北省承德市",
"86181501", "福建省厦门市",
"861395669", "安徽省阜阳市",
"861343510", "广东省韶关市",
"861358289", "河北省唐山市",
"861862750", "湖南省岳阳市",
"861313746", "河南省周口市",
"86176140", "辽宁省沈阳市",
"861352981", "云南省红河哈尼族彝族自治州",
"861454655", "云南省德宏傣族景颇族自治州",
"86132486", "浙江省宁波市",
"861477340", "湖南省衡阳市",
"861365441", "吉林省长春市",
"861329866", "湖南省怀化市",
"861801598", "江苏省镇江市",
"861343555", "广东省潮州市",
"861399529", "宁夏银川市",
"86156245", "山东省济南市",
"861881471", "黑龙江省伊春市",
"861813435", "河北省唐山市",
"861885149", "江苏省连云港市",
"861771371", "四川省德阳市",
"86138540", "山东省菏泽市",
"861808808", "云南省丽江市",
"861829855", "甘肃省武威市",
"861532648", "吉林省松原市",
"861372769", "广东省汕头市",
"861509803", "湖北省黄冈市",
"861368477", "内蒙古赤峰市",
"861516536", "山东省潍坊市",
"861785857", "浙江省衢州市",
"861829810", "安徽省淮北市",
"861332353", "宁夏吴忠市",
"861389948", "新疆克孜勒苏柯尔克孜自治州",
"861339079", "江苏省南京市",
"861555520", "安徽省宣城市",
"861344794", "甘肃省陇南市",
"861803343", "广东省深圳市",
"861760691", "云南省西双版纳傣族自治州",
"861361729", "湖北省武汉市",
"861510429", "辽宁省葫芦岛市",
"861864998", "福建省厦门市",
"861301443", "江西省上饶市",
"861536986", "河北省衡水市",
"861392672", "广东省茂名市",
"861804080", "新疆克拉玛依市",
"86178652", "山东省德州市",
"861830469", "黑龙江省双鸭山市",
"861770790", "江西省新余市",
"861533956", "贵州省铜仁地区",
"86188022", "天津市",
"86177671", "浙江省杭州市",
"86188444", "吉林省四平市",
"86132829", "浙江省金华市",
"861336141", "山东省东营市",
"86187437", "吉林省辽源市",
"861889446", "甘肃省白银市",
"861800669", "浙江省温州市",
"86136949", "广东省东莞市",
"861392440", "广东省湛江市",
"861389735", "青海省西宁市",
"86181118", "贵州省贵阳市",
"861321954", "四川省宜宾市",
"861373441", "山东省泰安市",
"861520538", "山东省泰安市",
"861514478", "内蒙古巴彦淖尔市",
"861586310", "山东省威海市",
"861864401", "黑龙江省佳木斯市",
"861583385", "河北省保定市",
"861397369", "湖南省益阳市",
"861827251", "河南省鹤壁市",
"861850536", "山东省潍坊市",
"861322561", "安徽省淮北市",
"861565902", "福建省福州市",
"861554107", "辽宁省朝阳市",
"861539393", "云南省西双版纳傣族自治州",
"861475640", "河北省邯郸市",
"861520096", "湖南省永州市",
"861818714", "云南省丽江市",
"861317279", "广东省河源市",
"861522481", "河南省平顶山市",
"861322475", "内蒙古通辽市",
"861598608", "广东省佛山市",
"861576612", "广东省揭阳市",
"861515946", "福建省南平市",
"861839914", "新疆和田地区",
"86153921", "福建省泉州市",
"861565972", "福建省泉州市",
"861303358", "江苏省泰州市",
"861859360", "福建省漳州市",
"861334133", "湖南省株洲市",
"861870325", "河北省唐山市",
"861512869", "河北省廊坊市",
"861889953", "新疆石河子市",
"861857090", "湖南省衡阳市",
"861815884", "安徽省合肥市",
"861533443", "云南省曲靖市",
"861384857", "内蒙古鄂尔多斯市",
"861309548", "安徽省铜陵市",
"861315181", "江苏省宿迁市",
"861708564", "安徽省六安市",
"861527530", "山东省菏泽市",
"861379789", "湖北省荆门市",
"861347533", "山东省淄博市",
"861479489", "内蒙古鄂尔多斯市",
"861708329", "河北省沧州市",
"86157106", "福建省厦门市",
"861589144", "陕西省西安市",
"86135674", "浙江省宁波市",
"861301956", "内蒙古包头市",
"861379391", "山东省临沂市",
"861503643", "河南省周口市",
"86187430", "吉林省长春市",
"861370457", "黑龙江省七台河市",
"86135431", "广东省汕尾市",
"861351862", "山东省青岛市",
"861458630", "湖北省襄樊市",
"861333719", "内蒙古包头市",
"861883396", "河北省廊坊市",
"86157625", "山东省潍坊市",
"861776861", "江苏省泰州市",
"861359961", "福建省龙岩市",
"861854509", "黑龙江省佳木斯市",
"861801965", "江苏省南通市",
"861867902", "江西省九江市",
"861573846", "河南省信阳市",
"861881998", "广东省惠州市",
"86177080", "四川省成都市",
"861364556", "安徽省安庆市",
"861780425", "辽宁省丹东市",
"86182309", "贵州省毕节地区",
"861820085", "广东省东莞市",
"861571641", "河南省南阳市",
"86157328", "河北省衡水市",
"861357147", "陕西省汉中市",
"861339009", "辽宁省鞍山市",
"861893843", "广东省肇庆市",
"86132862", "广东省惠州市",
"861886610", "山东省济南市",
"86182352", "山西省大同市",
"861709350", "河南省南阳市",
"861529461", "河南省郑州市",
"861331815", "广东省梅州市",
"861809493", "新疆塔城地区",
"861354623", "山西省晋中市",
"861865984", "福建省泉州市",
"861303747", "湖南省永州市",
"861360646", "山东省潍坊市",
"86137534", "山西省晋中市",
"861329581", "浙江省杭州市",
"861313068", "辽宁省阜新市",
"861331850", "广东省茂名市",
"861808878", "黑龙江省哈尔滨市",
"861509022", "河南省濮阳市",
"86138547", "山东省济宁市",
"86130201", "上海市",
"861814734", "内蒙古乌海市",
"861561740", "河南省郑州市",
"861882032", "广东省东莞市",
"861571929", "陕西省西安市",
"861811037", "安徽省安庆市",
"861815492", "新疆乌鲁木齐市",
"861355549", "黑龙江省大庆市",
"861356302", "山东省聊城市",
"861538698", "山西省吕梁市",
"861477195", "湖北省宜昌市",
"861338642", "山东省青岛市",
"861470348", "山西省吕梁市",
"861363702", "安徽省滁州市",
"861874742", "内蒙古包头市",
"861346154", "河南省信阳市",
"861386666", "安徽省合肥市",
"861593350", "河北省秦皇岛市",
"861708848", "江西省景德镇市",
"861380778", "广西河池市",
"861881401", "广东省惠州市",
"861807262", "浙江省湖州市",
"861308670", "广西防城港市",
"861856059", "山东省聊城市",
"861831658", "广东省肇庆市",
"861593315", "河北省唐山市",
"861573972", "新疆石河子市",
"86156259", "广东省佛山市",
"861343184", "广东省梅州市",
"861787507", "广东省肇庆市",
"86147295", "陕西省渭南市",
"861839352", "甘肃省天水市",
"861596380", "山东省日照市",
"861500524", "江苏省宿迁市",
"861351165", "江苏省无锡市",
"861506537", "山东省济宁市",
"861820783", "广西桂林市",
"861529193", "陕西省渭南市",
"861338470", "内蒙古呼伦贝尔市",
"861585547", "安徽省阜阳市",
"861801458", "江苏省镇江市",
"861782822", "四川省成都市",
"861376280", "湖南省娄底市",
"861338633", "山东省日照市",
"861812527", "广东省肇庆市",
"861335988", "黑龙江省牡丹江市",
"861870787", "广西钦州市",
"861782073", "广东省深圳市",
"861319818", "四川省南充市",
"861369460", "黑龙江省大庆市",
"861576835", "广东省湛江市",
"861595405", "山东省威海市",
"861882938", "陕西省宝鸡市",
"861373250", "浙江省衢州市",
"861839189", "陕西省宝鸡市",
"861530799", "江西省萍乡市",
"861835102", "江苏省宿迁市",
"86152774", "广西梧州市",
"861319666", "江苏省盐城市",
"861509928", "新疆阿克苏地区",
"861351702", "江西省九江市",
"861308433", "四川省南充市",
"86155506", "山东省威海市",
"861330375", "河南省平顶山市",
"861594728", "内蒙古巴彦淖尔市",
"861530381", "河南省郑州市",
"861321741", "湖南省长沙市",
"861783549", "山西省长治市",
"861776701", "浙江省舟山市",
"861569580", "浙江省舟山市",
"861340049", "河北省保定市",
"861379203", "山东省日照市",
"861390686", "浙江省台州市",
"861388679", "湖北省恩施土家族苗族自治州",
"861828216", "四川省攀枝花市",
"861705100", "北京市",
"861893832", "广东省肇庆市",
"861454130", "河北省邯郸市",
"86159524", "江苏省苏州市",
"861895944", "福建省宁德市",
"861392251", "广东省东莞市",
"86186441", "天津市",
"861777637", "广西玉林市",
"861850144", "江苏省常州市",
"861329138", "江苏省扬州市",
"861334845", "福建省漳州市",
"861539830", "云南省文山壮族苗族自治州",
"86189148", "江苏省徐州市",
"861303014", "广东省韶关市",
"861314041", "河南省安阳市",
"861879459", "甘肃省武威市",
"861882043", "广东省湛江市",
"861318345", "四川省泸州市",
"861529689", "广西河池市",
"861537722", "湖北省恩施土家族苗族自治州",
"86135265", "河南省郑州市",
"861350841", "湖南省常德市",
"861595153", "江苏省宿迁市",
"861320802", "浙江省杭州市",
"861825939", "福建省宁德市",
"861763337", "河北省张家口市",
"861550953", "宁夏吴忠市",
"861512709", "河北省石家庄市",
"861539271", "湖北省黄冈市",
"861555641", "安徽省六安市",
"861323244", "广东省江门市",
"861590779", "广西北海市",
"861835805", "浙江省舟山市",
"861362344", "山西省运城市",
"861875156", "江苏省无锡市",
"861372157", "贵州省铜仁地区",
"861358123", "湖北省黄冈市",
"861867517", "广东省韶关市",
"861329126", "江苏省南京市",
"861877454", "湖南省张家界市",
"86139338", "河北省石家庄市",
"861527684", "新疆乌鲁木齐市",
"861390395", "河南省漯河市",
"861778622", "湖北省荆门市",
"86147904", "安徽省合肥市",
"861474046", "辽宁省葫芦岛市",
"861874035", "陕西省西安市",
"861830007", "广东省茂名市",
"861329776", "广西百色市",
"861320453", "黑龙江省牡丹江市",
"861538737", "湖南省益阳市",
"861865119", "江苏省宿迁市",
"861875883", "浙江省宁波市",
"861572284", "江苏省镇江市",
"861367531", "山东省济南市",
"861309704", "江西省抚州市",
"86139635", "山东省聊城市",
"861822094", "陕西省榆林市",
"861761411", "辽宁省大连市",
"861332487", "广西钦州市",
"861378930", "湖南省湘潭市",
"861313247", "河北省邢台市",
"861599291", "广东省东莞市",
"861837495", "湖南省长沙市",
"861533432", "云南省楚雄彝族自治州",
"861320105", "新疆喀什地区",
"861502085", "山东省莱芜市",
"861708076", "湖南省岳阳市",
"861304170", "江苏省常州市",
"861878420", "四川省广安市",
"861516144", "江苏省扬州市",
"861479661", "江西省鹰潭市",
"861315538", "安徽省六安市",
"861768235", "浙江省宁波市",
"861531246", "江苏省苏州市",
"86155969", "陕西省延安市",
"861594736", "内蒙古鄂尔多斯市",
"861302687", "广东省广州市",
"861805686", "安徽省合肥市",
"861844584", "黑龙江省伊春市",
"861337881", "云南省西双版纳傣族自治州",
"861375165", "广东省揭阳市",
"86159973", "湖北省黄冈市",
"861317085", "江西省宜春市",
"861597192", "湖北省随州市",
"861893135", "河北省秦皇岛市",
"861304720", "湖南省岳阳市",
"86150493", "内蒙古包头市",
"861804234", "浙江省温州市",
"861807695", "西藏昌都地区",
"861347542", "山东省青岛市",
"861882745", "湖北省荆州市",
"86153188", "山东省济南市",
"861816953", "宁夏吴忠市",
"861824698", "黑龙江省双鸭山市",
"86136892", "陕西省西安市",
"86182923", "陕西省渭南市",
"861536758", "湖南省怀化市",
"861529934", "新疆巴音郭楞蒙古自治州",
"861332265", "广东省梅州市",
"861864522", "黑龙江省齐齐哈尔市",
"861458110", "安徽省宿州市",
"861890527", "江苏省扬州市",
"861842011", "广东省韶关市",
"861575454", "黑龙江省佳木斯市",
"861896534", "福建省三明市",
"861320725", "湖北省襄樊市",
"86131100", "天津市",
"861320946", "甘肃省兰州市",
"861522669", "河北省廊坊市",
"861880660", "广东省汕尾市",
"861504749", "内蒙古通辽市",
"861452350", "河南省鹤壁市",
"861826549", "山东省临沂市",
"861533788", "广东省广州市",
"86177131", "河北省唐山市",
"861577883", "广西河池市",
"86170705", "江苏省镇江市",
"861599949", "新疆伊犁哈萨克自治州",
"861509763", "河北省廊坊市",
"861394974", "河南省濮阳市",
"861816446", "安徽省合肥市",
"861305097", "辽宁省葫芦岛市",
"861301432", "河北省唐山市",
"861351825", "四川省达州市",
"861310251", "河北省秦皇岛市",
"861519937", "新疆昌吉回族自治州",
"861358703", "浙江省衢州市",
"861879029", "河南省郑州市",
"861537486", "内蒙古锡林郭勒盟",
"861334613", "浙江省台州市",
"861585668", "安徽省淮南市",
"861339338", "河北省沧州市",
"861579718", "湖北省襄樊市",
"861535495", "内蒙古包头市",
"861458403", "河南省商丘市",
"861384654", "黑龙江省黑河市",
"861309774", "广西梧州市",
"861815687", "安徽省阜阳市",
"86130388", "广东省东莞市",
"861337566", "山东省枣庄市",
"861355940", "福建省泉州市",
"861898039", "四川省宜宾市",
"861507686", "河北省邢台市",
"861368394", "河南省周口市",
"861380616", "江苏省无锡市",
"861571520", "江苏省徐州市",
"861331632", "广东省佛山市",
"861590709", "江西省南昌市",
"861362480", "内蒙古呼伦贝尔市",
"861335257", "黑龙江省大兴安岭地区",
"861320593", "福建省宁德市",
"861850992", "新疆伊犁哈萨克自治州",
"861390140", "江苏省淮安市",
"861316948", "广东省汕尾市",
"861339326", "河北省廊坊市",
"861374910", "河南省郑州市",
"861888093", "四川省泸州市",
"861525672", "安徽省淮南市",
"861318190", "山东省淄博市",
"861309667", "山西省吕梁市",
"861536347", "广东省惠州市",
"861539201", "福建省福州市",
"861320872", "云南省大理白族自治州",
"861821280", "贵州省毕节地区",
"861539587", "浙江省绍兴市",
"861876741", "浙江省台州市",
"861374955", "河南省平顶山市",
"861472681", "四川省绵阳市",
"861705170", "北京市",
"861588422", "四川省资阳市",
"861537102", "江苏省南京市",
"861380544", "山东省济南市",
"861525440", "山东省菏泽市",
"861808214", "江苏省宿迁市",
"861339467", "黑龙江省鸡西市",
"861803332", "广东省韶关市",
"861500148", "新疆喀什地区",
"861353179", "广东省中山市",
"861305527", "福建省福州市",
"86158453", "黑龙江省鸡西市",
"86138331", "河北省石家庄市",
"861859924", "新疆巴音郭楞蒙古自治州",
"86155922", "陕西省渭南市",
"861351772", "广西柳州市",
"861569837", "山西省晋中市",
"861316033", "江苏省宿迁市",
"861459734", "湖南省衡阳市",
"861324342", "河南省郑州市",
"861805140", "江苏省镇江市",
"86159858", "福建省厦门市",
"861595561", "安徽省安庆市",
"861330305", "河北省唐山市",
"861827384", "湖南省怀化市",
"861534717", "湖北省黄冈市",
"861389042", "四川省达州市",
"861835722", "浙江省嘉兴市",
"861890097", "辽宁省大连市",
"861366329", "河北省唐山市",
"861370383", "河南省濮阳市",
"861595475", "山东省东营市",
"861700019", "广东省深圳市",
"861782003", "广东省湛江市",
"861768388", "湖北省荆门市",
"861845028", "福建省厦门市",
"861366564", "安徽省六安市",
"861563454", "山东省济宁市",
"861558181", "山西省太原市",
"861836898", "甘肃省武威市",
"861352370", "河南省商丘市",
"861379695", "黑龙江省黑河市",
"861874832", "内蒙古阿拉善盟",
"861867963", "江西省南昌市",
"861500766", "广东省云浮市",
"86155516", "安徽省阜阳市",
"861365904", "四川省泸州市",
"861563667", "黑龙江省双鸭山市",
"861331460", "黑龙江省哈尔滨市",
"86134208", "广东省佛山市",
"861890264", "广东省东莞市",
"861780630", "山东省威海市",
"861506678", "山东省烟台市",
"861770332", "河北省保定市",
"861774928", "陕西省西安市",
"861329943", "广西桂林市",
"861319499", "四川省成都市",
"861358946", "山东省聊城市",
"861871813", "广东省梅州市",
"861575774", "浙江省杭州市",
"861596901", "云南省昭通市",
"861597522", "广东省揭阳市",
"861521952", "广东省清远市",
"861301660", "广东省佛山市",
"861458425", "河南省新乡市",
"861810374", "河南省许昌市",
"861536478", "山西省吕梁市",
"861829501", "宁夏银川市",
"861529851", "江苏省泰州市",
"861502882", "河北省衡水市",
"861846461", "山东省潍坊市",
"861459647", "甘肃省白银市",
"861329596", "福建省漳州市",
"861380922", "广东省佛山市",
"861583518", "山西省吕梁市",
"861858279", "四川省阿坝藏族羌族自治州",
"861863056", "河北省秦皇岛市",
"86130041", "上海市",
"86158748", "湖南省长沙市",
"861306490", "江苏省淮安市",
"861880432", "吉林省吉林市",
"86136727", "广东省珠海市",
"861537823", "四川省绵阳市",
"861309454", "四川省凉山彝族自治州",
"86181563", "安徽省宣城市",
"861329038", "山东省莱芜市",
"861814844", "四川省宜宾市",
"861813290", "河北省邢台市",
"861507040", "江西省南昌市",
"861532913", "贵州省安顺市",
"86153581", "江苏省南京市",
"861881895", "广东省汕头市",
"86138756", "湖南省衡阳市",
"86151998", "新疆喀什地区",
"861705000", "北京市",
"861811208", "江苏省淮安市",
"861320703", "江西省上饶市",
"861452131", "河北省张家口市",
"861537072", "江苏省泰州市",
"86184040", "黑龙江省哈尔滨市",
"861820377", "河南省南阳市",
"861582954", "陕西省西安市",
"861340149", "江苏省常州市",
"861534528", "江苏省盐城市",
"861335359", "山西省运城市",
"861534098", "山西省运城市",
"861572655", "山东省烟台市",
"861580533", "山东省淄博市",
"861808146", "四川省巴中市",
"86138932", "甘肃省兰州市",
"861770979", "青海省海西蒙古族藏族自治州",
"861370276", "广东省珠海市",
"861518549", "贵州省黔南布依族苗族自治州",
"861346318", "河北省衡水市",
"8621", "上海市",
"861326645", "广东省江门市",
"861331918", "陕西省西安市",
"861782025", "广东省佛山市",
"86153953", "安徽省芜湖市",
"861459419", "云南省普洱市",
"861333316", "河北省廊坊市",
"86147914", "陕西省榆林市",
"861534536", "山东省潍坊市",
"86145260", "江苏省南京市",
"86181733", "湖南省长沙市",
"861333961", "贵州省贵阳市",
"861879709", "青海省西宁市",
"861329026", "山东省聊城市",
"861337659", "广东省韶关市",
"861372057", "陕西省渭南市",
"861815101", "江苏省南京市",
"861305264", "辽宁省朝阳市",
"861359719", "广西玉林市",
"861322891", "西藏拉萨市",
"861330323", "河北省石家庄市",
"861892304", "广东省梅州市",
"861354589", "湖北省武汉市",
"86131117", "河北省沧州市",
"861773481", "河南省郑州市",
"861325807", "山东省潍坊市",
"861530579", "浙江省金华市",
"8618421", "上海市",
"861812197", "四川省泸州市",
"861317185", "河北省邢台市",
"861517171", "湖北省黄冈市",
"861379386", "山东省滨州市",
"86137438", "吉林省松原市",
"861302171", "山东省济南市",
"861373904", "湖南省湘西土家族苗族自治州",
"861516044", "福建省泉州市",
"861508380", "江西省南昌市",
"861569246", "广东省东莞市",
"861864944", "广西梧州市",
"86155321", "河北省石家庄市",
"861528446", "云南省玉溪市",
"861370867", "云南省玉溪市",
"86189541", "山东省济南市",
"861564886", "内蒙古巴彦淖尔市",
"861334042", "福建省福州市",
"861860720", "湖北省宜昌市",
"861515289", "江苏省南通市",
"861848351", "四川省泸州市",
"861317554", "浙江省金华市",
"861300522", "广东省汕头市",
"86170715", "江苏省南京市",
"861342814", "广东省湛江市",
"861522496", "河南省周口市",
"861310663", "广东省湛江市",
"861454351", "山东省临沂市",
"861530509", "福建省泉州市",
"861830859", "贵州省黔西南布依族苗族自治州",
"861379225", "山东省滨州市",
"861818147", "四川省巴中市",
"861825255", "江苏省扬州市",
"861570430", "吉林省长春市",
"861325877", "吉林省通化市",
"861351592", "福建省莆田市",
"861779749", "青海省海西蒙古族藏族自治州",
"86131110", "山西省太原市",
"861821993", "甘肃省平凉市",
"861811449", "江苏省南京市",
"86151533", "山东省淄博市",
"861787626", "广东省茂名市",
"861769920", "新疆昌吉回族自治州",
"861450964", "新疆博尔塔拉蒙古自治州",
"861396600", "安徽省芜湖市",
"861552878", "四川省乐山市",
"861517101", "湖北省鄂州市",
"861856767", "河南省周口市",
"86130796", "黑龙江省齐齐哈尔市",
"86147092", "陕西省西安市",
"86145267", "陕西省西安市",
"861325266", "吉林省通化市",
"861813620", "江苏省泰州市",
"861390040", "内蒙古呼和浩特市",
"861863367", "河北省沧州市",
"86155495", "湖北省孝感市",
"861528953", "广西南宁市",
"861596558", "山东省青岛市",
"861393468", "山西省临汾市",
"861327557", "安徽省宿州市",
"861309024", "辽宁省沈阳市",
"861760395", "河南省漯河市",
"861364481", "内蒙古呼和浩特市",
"861815171", "江苏省无锡市",
"861551548", "河南省濮阳市",
"861806378", "福建省龙岩市",
"861361338", "河北省秦皇岛市",
"861328841", "广东省佛山市",
"861375928", "云南省西双版纳傣族自治州",
"861879779", "湖南省常德市",
"861891437", "江苏省南通市",
"861830727", "湖北省荆州市",
"861829958", "新疆阿克苏地区",
"861808905", "西藏昌都地区",
"861536991", "河北省衡水市",
"861853223", "河北省保定市",
"861860413", "辽宁省抚顺市",
"861344066", "安徽省宣城市",
"861832069", "广东省广州市",
"86999", "新疆伊犁哈萨克自治州",
"861570321", "河北省石家庄市",
"861573963", "新疆昌吉回族自治州",
"861315874", "四川省广元市",
"86177768", "海南省海口市",
"861535084", "河北省邢台市",
"861369632", "山东省枣庄市",
"861566793", "陕西省商洛市",
"861325159", "黑龙江省大庆市",
"86134739", "河北省石家庄市",
"86159741", "湖南省长沙市",
"861564561", "黑龙江省大庆市",
"861802196", "江苏省连云港市",
"861770909", "四川省德阳市",
"861458753", "广东省梅州市",
"861361326", "河北省廊坊市",
"861877124", "湖北省恩施土家族苗族自治州",
"861846505", "宁夏中卫市",
"86156286", "山东省德州市",
"861565963", "福建省三明市",
"861768959", "西藏拉萨市",
"861503460", "山西省晋城市",
"86136720", "天津市",
"86185716", "湖北省武汉市",
"86132445", "黑龙江省哈尔滨市",
"861893311", "广东省揭阳市",
"861812718", "广东省云浮市",
"861329456", "山西省晋城市",
"861561587", "山东省济宁市",
"861705070", "辽宁省大连市",
"861320773", "广西桂林市",
"861509165", "陕西省汉中市",
"861822942", "湖南省邵阳市",
"861880788", "广西河池市",
"86177538", "山东省泰安市",
"861343871", "四川省乐山市",
"861571190", "广东省广州市",
"861361467", "黑龙江省七台河市",
"861510767", "广东省云浮市",
"861318090", "吉林省延边朝鲜族自治州",
"861560512", "江苏省连云港市",
"861858209", "四川省达州市",
"861590459", "黑龙江省大庆市",
"86134569", "浙江省杭州市",
"861575704", "浙江省杭州市",
"861500933", "甘肃省平凉市",
"861596971", "山东省济南市",
"861504987", "内蒙古鄂尔多斯市",
"861352996", "云南省红河哈尼族彝族自治州",
"861882612", "广东省广州市",
"861330252", "广东省阳江市",
"86130263", "湖北省武汉市",
"86188548", "山东省泰安市",
"861367445", "吉林省通化市",
"861389142", "陕西省商洛市",
"861471628", "广东省广州市",
"861313349", "山西省朔州市",
"861366697", "福建省三明市",
"86183292", "陕西省榆林市",
"861814995", "新疆吐鲁番地区",
"86151763", "河北省保定市",
"861708482", "河南省新乡市",
"861387241", "湖北省荆州市",
"861868265", "四川省成都市",
"861358105", "山东省临沂市",
"861805040", "福建省福州市",
"861538516", "安徽省芜湖市",
"861566095", "河南省信阳市",
"86183781", "广西南宁市",
"861319559", "安徽省黄山市",
"861311631", "贵州省贵阳市",
"86158124", "广东省广州市",
"861569014", "河北省廊坊市",
"861886030", "河南省信阳市",
"861787638", "广东省茂名市",
"861520764", "广东省清远市",
"861300092", "辽宁省本溪市",
"861397194", "湖北省孝感市",
"861339857", "贵州省毕节地区",
"861817773", "广西南宁市",
"86170960", "山东省青岛市",
"861317307", "山东省临沂市",
"861569747", "湖南省衡阳市",
"861500942", "甘肃省兰州市",
"861323298", "广东省清远市",
"861454284", "辽宁省盘锦市",
"861362398", "河南省三门峡市",
"86139147", "江苏省南京市",
"861589216", "福建省南平市",
"861530970", "青海省海北藏族自治州",
"861386559", "安徽省黄山市",
"86158421", "辽宁省朝阳市",
"861366945", "广西玉林市",
"86181511", "江苏省苏州市",
"861814647", "新疆阿克苏地区",
"861777017", "江西省鹰潭市",
"861822048", "陕西省西安市",
"861880956", "宁夏石嘴山市",
"861597565", "广东省阳江市",
"861383589", "山西省运城市",
"861452611", "江苏省无锡市",
"861519651", "四川省攀枝花市",
"861890676", "浙江省台州市",
"861363022", "陕西省西安市",
"861764535", "黑龙江省鸡西市",
"861340368", "山西省忻州市",
"861870540", "山东省菏泽市",
"86133013", "北京市",
"86159360", "河南省周口市",
"861830385", "河南省开封市",
"861327304", "河南省开封市",
"861594902", "江苏省徐州市",
"861518940", "江苏省南通市",
"861453767", "广西防城港市",
"86183339", "河北省邢台市",
"861777508", "安徽省宿州市",
"861770570", "浙江省衢州市",
"861380965", "广东省汕头市",
"861563864", "河南省三门峡市",
"86139885", "云南省大理白族自治州",
"861802764", "广东省江门市",
"861774803", "四川省乐山市",
"861376817", "广西钦州市",
"861598319", "四川省自贡市",
"861509702", "甘肃省金昌市",
"861560907", "四川省南充市",
"861348499", "陕西省汉中市",
"861351928", "宁夏银川市",
"861505789", "浙江省丽水市",
"861372282", "河北省衡水市",
"86182583", "浙江省嘉兴市",
"861876831", "浙江省嘉兴市",
"861352532", "河南省驻马店市",
"861895401", "山东省东营市",
"861300998", "黑龙江省双鸭山市",
"861870303", "新疆乌鲁木齐市",
"861876270", "江苏省淮安市",
"861322423", "辽宁省沈阳市",
"861835978", "福建省福州市",
"861350313", "河北省张家口市",
"861370777", "广西钦州市",
"861339729", "湖北省十堰市",
"861327682", "浙江省宁波市",
"861827663", "广西百色市",
"861351936", "甘肃省张掖市",
"86181108", "安徽省宣城市",
"861337724", "广西来宾市",
"861453674", "陕西省渭南市",
"861336041", "广东省惠州市",
"86138575", "浙江省绍兴市",
"86130169", "江苏省南京市",
"861802677", "广东省江门市",
"861520804", "西藏林芝地区",
"861820554", "安徽省淮南市",
"861313973", "新疆巴音郭楞蒙古自治州",
"86752", "广东省惠州市",
"861555190", "安徽省蚌埠市",
"86155582", "浙江省宁波市",
"861590990", "新疆克拉玛依市",
"861884693", "黑龙江省哈尔滨市",
"861800496", "辽宁省锦州市",
"86133149", "福建省福州市",
"861832477", "安徽省阜阳市",
"861771589", "江苏省苏州市",
"861335476", "内蒙古赤峰市",
"861364669", "浙江省金华市",
"86135062", "江苏省苏州市",
"861300401", "安徽省阜阳市",
"861315607", "山东省东营市",
"861537163", "江苏省徐州市",
"86137297", "广东省云浮市",
"86181326", "河北省石家庄市",
"861814419", "福建省宁德市",
"861840927", "陕西省宝鸡市",
"861871997", "新疆和田地区",
"861524480", "四川省眉山市",
"861570673", "浙江省嘉兴市",
"861829786", "安徽省六安市",
"86150934", "河南省郑州市",
"861810557", "安徽省宿州市",
"861344483", "广西梧州市",
"861858783", "广西河池市",
"86182478", "内蒙古巴彦淖尔市",
"861554007", "内蒙古呼伦贝尔市",
"861780852", "贵州省遵义市",
"861840411", "辽宁省大连市",
"861531989", "陕西省铜川市",
"86156270", "广东省揭阳市",
"861801128", "四川省成都市",
"861338715", "湖北省十堰市",
"861504839", "内蒙古鄂尔多斯市",
"861459568", "陕西省汉中市",
"86180380", "广东省深圳市",
"86130646", "浙江省金华市",
"86150355", "山西省长治市",
"861300565", "广东省阳江市",
"861337896", "湖南省永州市",
"861354675", "山西省长治市",
"861810497", "辽宁省营口市",
"861805691", "安徽省安庆市",
"86156121", "河北省石家庄市",
"861525663", "安徽省铜陵市",
"861330671", "浙江省杭州市",
"86153369", "浙江省湖州市",
"86157116", "上海市",
"861589044", "河南省南阳市",
"861534992", "新疆哈密地区",
"86156277", "广东省佛山市",
"861530685", "浙江省绍兴市",
"861576938", "甘肃省甘南藏族自治州",
"861535230", "甘肃省兰州市",
"86180387", "广东省佛山市",
"861316994", "广东省深圳市",
"861566562", "安徽省铜陵市",
"861363452", "黑龙江省齐齐哈尔市",
"86131806", "吉林省通化市",
"861320863", "吉林省松原市",
"861380036", "山西省忻州市",
"861315081", "内蒙古乌兰察布市",
"861368829", "四川省宜宾市",
"861862470", "河南省新乡市",
"861476019", "福建省泉州市",
"861335885", "辽宁省沈阳市",
"86185291", "广东省广州市",
"86159984", "辽宁省大连市",
"861524344", "河北省唐山市",
"86156212", "山东省德州市",
"861773669", "广西桂林市",
"861809784", "新疆博尔塔拉蒙古自治州",
"861857190", "湖北省仙桃市",
"86150349", "内蒙古呼和浩特市",
"86185782", "广东省珠海市",
"86137290", "广东省湛江市",
"861558526", "贵州省黔东南苗族侗族自治州",
"861554077", "内蒙古鄂尔多斯市",
"86159428", "辽宁省大连市",
"861323628", "江苏省盐城市",
"861882835", "四川省乐山市",
"86132033", "湖南省株洲市",
"861366482", "内蒙古兴安盟",
"861570603", "陕西省西安市",
"861555345", "山东省烟台市",
"861365535", "山东省烟台市",
"861580542", "山东省青岛市",
"861313903", "青海省海西蒙古族藏族自治州",
"861576043", "四川省绵阳市",
"861351763", "广西桂林市",
"861823820", "河南省开封市",
"861820494", "内蒙古鄂尔多斯市",
"86182319", "河北省邢台市",
"861529795", "江西省宜春市",
"861306959", "河南省漯河市",
"861322053", "山东省临沂市",
"861813541", "山西省晋中市",
"86158823", "四川省成都市",
"861329379", "山西省运城市",
"861318641", "江苏省南京市",
"861453382", "内蒙古兴安盟",
"861800556", "安徽省安庆市",
"86133155", "河北省唐山市",
"861478514", "贵州省黔南布依族苗族自治州",
"861538847", "四川省达州市",
"861520874", "云南省曲靖市",
"861537551", "安徽省合肥市",
"861837801", "广西柳州市",
"861334948", "黑龙江省鹤岗市",
"861303989", "黑龙江省鸡西市",
"861590376", "河南省信阳市",
"86131632", "湖北省武汉市",
"861768515", "贵州省黔东南苗族侗族自治州",
"861377493", "山东省日照市",
"861818439", "贵州省六盘水市",
"861895471", "山东省烟台市",
"861700639", "山东省青岛市",
"861811137", "四川省达州市",
"861348559", "安徽省黄山市",
"861369815", "四川省泸州市",
"861452588", "福建省福州市",
"861370707", "江西省赣州市",
"86130211", "北京市",
"861804646", "福建省漳州市",
"861835908", "福建省三明市",
"86135029", "广东省汕头市",
"861509122", "陕西省榆林市",
"861870373", "河南省新乡市",
"86151711", "湖北省荆州市",
"861369850", "贵州省安顺市",
"861501434", "广东省江门市",
"861478646", "湖南省衡阳市",
"861770500", "福建省福州市",
"861350731", "湖南省长沙市",
"861878635", "贵州省黔南布依族苗族自治州",
"861512990", "陕西省商洛市",
"861325767", "广东省茂名市",
"861391245", "江苏省无锡市",
"861508819", "广东省云浮市",
"861334735", "湖南省郴州市",
"861539740", "浙江省温州市",
"86159367", "河南省濮阳市",
"861774022", "四川省成都市",
"861390691", "福建省福州市",
"861327374", "河南省许昌市",
"861780584", "浙江省宁波市",
"861594972", "山东省枣庄市",
"861834446", "广东省汕尾市",
"861342449", "广东省广州市",
"861311111", "山西省临汾市",
"86130122", "天津市",
"861560977", "青海省海西蒙古族藏族自治州",
"86158395", "河南省漯河市",
"861335182", "黑龙江省齐齐哈尔市",
"861363803", "贵州省黔南布依族苗族自治州",
"861821817", "广东省深圳市",
"861380028", "四川省成都市",
"861821134", "广东省茂名市",
"861379947", "福建省泉州市",
"861828098", "四川省广安市",
"861874843", "内蒙古乌兰察布市",
"861853189", "河北省衡水市",
"861879869", "贵州省遵义市",
"861576745", "广东省惠州市",
"861809061", "四川省成都市",
"861576926", "陕西省汉中市",
"861890606", "福建省漳州市",
"861530396", "河南省驻马店市",
"861323636", "江苏省镇江市",
"861780473", "内蒙古乌海市",
"861861352", "山西省晋中市",
"861322710", "湖北省鄂州市",
"861475752", "浙江省温州市",
"861551667", "河南省驻马店市",
"86152783", "广西玉林市",
"861770343", "山西省太原市",
"861329932", "甘肃省酒泉市",
"86170967", "湖南省长沙市",
"861859533", "河南省驻马店市",
"861514758", "内蒙古通辽市",
"861898447", "贵州省毕节地区",
"861321831", "江苏省淮安市",
"861530900", "四川省自贡市",
"861375452", "河北省保定市",
"861477095", "江西省宜春市",
"86139140", "江苏省苏州市",
"861860153", "江苏省连云港市",
"861318761", "云南省文山壮族苗族自治州",
"861771142", "四川省泸州市",
"861396653", "安徽省亳州市",
"86131578", "浙江省丽水市",
"86176654", "广东省广州市",
"861537712", "湖北省黄冈市",
"861351643", "安徽省淮南市",
"861869367", "甘肃省嘉峪关市",
"861356141", "山东省潍坊市",
"861560944", "甘肃省天水市",
"86186024", "辽宁省沈阳市",
"86186442", "上海市",
"861535090", "辽宁省锦州市",
"861551358", "山西省吕梁市",
"861850469", "黑龙江省双鸭山市",
"861898583", "贵州省黔东南苗族侗族自治州",
"861826988", "安徽省滁州市",
"861869426", "河北省唐山市",
"861304053", "新疆伊犁哈萨克自治州",
"861860886", "云南省怒江傈僳族自治州",
"861596348", "山东省临沂市",
"861556986", "甘肃省陇南市",
"861780999", "新疆伊犁哈萨克自治州",
"861327347", "河北省邢台市",
"861769239", "河北省石家庄市",
"861369936", "新疆乌鲁木齐市",
"861847179", "湖北省黄冈市",
"861868532", "贵州省黔南布依族苗族自治州",
"861312531", "江西省上饶市",
"861305078", "辽宁省辽阳市",
"861594718", "内蒙古包头市",
"861880587", "浙江省温州市",
"861840792", "江西省九江市",
"861336939", "甘肃省陇南市",
"86176027", "湖北省武汉市",
"861559393", "甘肃省陇南市",
"861510568", "安徽省阜阳市",
"861319828", "四川省德阳市",
"861341846", "广东省深圳市",
"861838882", "云南省丽江市",
"861806629", "浙江省温州市",
"861830536", "山东省潍坊市",
"861814382", "西藏日喀则地区",
"86170741", "辽宁省大连市",
"861454541", "新疆巴音郭楞蒙古自治州",
"86158809", "福建省泉州市",
"861848541", "贵州省黔南布依族苗族自治州",
"861317344", "山东省临沂市",
"861569704", "云南省昆明市",
"861528900", "西藏拉萨市",
"861310488", "广东省广州市",
"861773749", "河南省郑州市",
"861786501", "山东省菏泽市",
"861862762", "湖南省娄底市",
"861567709", "广西桂林市",
"861319349", "河南省鹤壁市",
"861304710", "湖北省荆州市",
"861528685", "河南省驻马店市",
"861775920", "福建省厦门市",
"861772193", "四川省南充市",
"861882916", "陕西省汉中市",
"861362783", "广西桂林市",
"861328671", "广东省河源市",
"86158852", "贵州省毕节地区",
"861576665", "广东省惠州市",
"861452286", "山西省晋城市",
"861365225", "广东省珠海市",
"861532975", "贵州省黔东南苗族侗族自治州",
"861367140", "广东省潮州市",
"861332981", "湖北省宜昌市",
"861846513", "宁夏吴忠市",
"861338289", "江苏省无锡市",
"861338863", "浙江省嘉兴市",
"861450651", "黑龙江省黑河市",
"861589077", "河南省安阳市",
"861314363", "河北省石家庄市",
"861700459", "黑龙江省大庆市",
"861844700", "内蒙古呼伦贝尔市",
"861818659", "湖北省武汉市",
"861554044", "内蒙古乌兰察布市",
"861806941", "浙江省杭州市",
"861313559", "安徽省黄山市",
"861878410", "四川省宜宾市",
"86135003", "重庆市",
"861830528", "江苏省镇江市",
"861810986", "辽宁省盘锦市",
"861319836", "四川省眉山市",
"861399955", "新疆昌吉回族自治州",
"861315644", "山东省济南市",
"861551747", "河南省商丘市",
"861872545", "云南省曲靖市",
"86131483", "浙江省杭州市",
"861865129", "江苏省镇江市",
"86180976", "新疆乌鲁木齐市",
"861323456", "黑龙江省黑河市",
"861570832", "四川省内江市",
"861761421", "辽宁省朝阳市",
"86894", "西藏林芝地区",
"861899966", "新疆阿克苏地区",
"861509460", "黑龙江省大兴安岭地区",
"861871875", "广东省中山市",
"861535520", "浙江省嘉兴市",
"861778612", "湖北省武汉市",
"861571495", "新疆巴音郭楞蒙古自治州",
"861341972", "河南省驻马店市",
"861808694", "四川省攀枝花市",
"861303594", "云南省德宏傣族景颇族自治州",
"861326486", "湖北省孝感市",
"861325647", "山东省东营市",
"861822646", "安徽省安庆市",
"861358113", "山东省泰安市",
"861869438", "甘肃省甘南藏族自治州",
"861306340", "安徽省宿州市",
"861309580", "浙江省舟山市",
"861558236", "山西省临汾市",
"861538874", "云南省曲靖市",
"861309837", "湖北省黄冈市",
"86151695", "山东省潍坊市",
"861831883", "广东省梅州市",
"861869782", "青海省海西蒙古族藏族自治州",
"861800987", "辽宁省葫芦岛市",
"861869056", "陕西省安康市",
"861309114", "河北省沧州市",
"861581170", "广东省湛江市",
"861341902", "四川省德阳市",
"861831269", "广东省梅州市",
"861802644", "广东省广州市",
"861335549", "山东省临沂市",
"861519431", "山东省威海市",
"861899733", "青海省西宁市",
"861306484", "江苏省盐城市",
"861351850", "贵州省贵阳市",
"861323596", "福建省漳州市",
"861453647", "江苏省南通市",
"861333654", "广东省深圳市",
"861571510", "江苏省盐城市",
"861579728", "湖北省荆州市",
"861506329", "山东省临沂市",
"861771994", "河南省郑州市",
"86151398", "河南省三门峡市",
"861510995", "新疆吐鲁番地区",
"86138193", "浙江省嘉兴市",
"861337147", "山东省聊城市",
"861871805", "广东省深圳市",
"861571555", "安徽省马鞍山市",
"861355756", "广西桂林市",
"861809811", "广东省潮州市",
"861334623", "山东省日照市",
"861303454", "山东省聊城市",
"861806299", "湖北省宜昌市",
"861567129", "湖北省襄樊市",
"86177132", "河北省保定市",
"861377909", "新疆伊犁哈萨克自治州",
"861526881", "浙江省杭州市",
"861705053", "山东省济南市",
"861826257", "江苏省扬州市",
"861572983", "四川省攀枝花市",
"86157588", "云南省文山壮族苗族自治州",
"861804048", "四川省巴中市",
"861777206", "广西钦州市",
"861358470", "江苏省南通市",
"861458770", "湖南省岳阳市",
"861859352", "福建省宁德市",
"861861533", "山东省淄博市",
"861306573", "浙江省杭州市",
"861390531", "山东省济南市",
"861837520", "贵州省黔南布依族苗族自治州",
"861842021", "广东省东莞市",
"861862387", "河南省商丘市",
"861573097", "甘肃省兰州市",
"861567779", "广西钦州市",
"861778143", "四川省凉山彝族自治州",
"861896648", "浙江省杭州市",
"861894459", "黑龙江省大庆市",
"861367395", "河南省漯河市",
"861871486", "安徽省淮南市",
"861452325", "河南省平顶山市",
"861532905", "贵州省黔东南苗族侗族自治州",
"861458120", "安徽省安庆市",
"861323943", "甘肃省白银市",
"861313499", "内蒙古锡林郭勒盟",
"861478048", "四川省绵阳市",
"861360148", "江苏省无锡市",
"861771613", "四川省成都市",
"861347205", "河北省石家庄市",
"861565097", "青海省西宁市",
"861302560", "广东省湛江市",
"861599611", "江苏省连云港市",
"861310732", "湖南省湘潭市",
"861532680", "内蒙古呼伦贝尔市",
"86186650", "广东省广州市",
"86156685", "辽宁省抚顺市",
"861845018", "福建省莆田市",
"861770821", "广东省汕头市",
"861534727", "湖北省十堰市",
"861593362", "河北省石家庄市",
"861569774", "广西梧州市",
"86158204", "广东省深圳市",
"861860475", "内蒙古通辽市",
"861366319", "河北省邢台市",
"861351112", "湖南省益阳市",
"86156388", "河南省郑州市",
"861837090", "江西省萍乡市",
"861383994", "河南省驻马店市",
"861560895", "西藏昌都地区",
"861553443", "山西省晋中市",
"861508394", "江西省赣州市",
"861367686", "浙江省绍兴市",
"86155921", "陕西省咸阳市",
"861517560", "河北省唐山市",
"861880830", "四川省泸州市",
"861814674", "江西省宜春市",
"861365695", "福建省宁德市",
"861860561", "安徽省淮北市",
"86180278", "广东省肇庆市",
"86176020", "广东省广州市",
"861786465", "山东省莱芜市",
"861554216", "辽宁省沈阳市",
"861379904", "福建省漳州市",
"861371988", "广东省阳江市",
"86150892", "广东省惠州市",
"861326722", "广东省深圳市",
"861308730", "湖南省岳阳市",
"861459159", "广西北海市",
"861877014", "江西省宜春市",
"861380638", "山东省烟台市",
"861824081", "陕西省延安市",
"86138332", "河北省保定市",
"861305517", "湖南省长沙市",
"861598726", "云南省临沧市",
"861588412", "四川省宜宾市",
"861705755", "广东省深圳市",
"861364749", "湖南省长沙市",
"861886541", "山东省济南市",
"861889381", "甘肃省兰州市",
"861511229", "广东省深圳市",
"86184826", "四川省广安市",
"861518359", "四川省达州市",
"861370744", "湖南省张家界市",
"861760445", "吉林省通化市",
"861339961", "安徽省淮北市",
"861534859", "贵州省黔西南布依族苗族自治州",
"861708537", "山东省济宁市",
"861889799", "江西省萍乡市",
"861339316", "河北省廊坊市",
"861579736", "湖北省咸宁市",
"861374920", "河南省鹤壁市",
"861453419", "辽宁省沈阳市",
"861331862", "广东省清远市",
"861476283", "江苏省镇江市",
"861369763", "山东省烟台市",
"861843147", "河北省沧州市",
"861459382", "贵州省六盘水市",
"861820480", "内蒙古兴安盟",
"861368971", "吉林省四平市",
"861323379", "河南省洛阳市",
"861362279", "广东省惠州市",
"861537341", "河北省石家庄市",
"861361719", "湖北省十堰市",
"861510419", "辽宁省辽阳市",
"86182919", "陕西省西安市",
"861829820", "安徽省马鞍山市",
"861338773", "广西桂林市",
"861800346", "山西省太原市",
"861558737", "山东省烟台市",
"861319903", "黑龙江省绥化市",
"86147550", "安徽省滁州市",
"861348828", "陕西省延安市",
"861814807", "四川省成都市",
"861887259", "湖北省襄樊市",
"861598697", "广东省惠州市",
"861370017", "辽宁省鞍山市",
"861305902", "黑龙江省哈尔滨市",
"861309989", "云南省玉溪市",
"861813351", "河北省秦皇岛市",
"861847654", "广东省深圳市",
"861471456", "广东省深圳市",
"861570615", "江苏省常州市",
"861840563", "安徽省宣城市",
"861580352", "山西省大同市",
"861459604", "宁夏石嘴山市",
"861310743", "湖南省湘西土家族苗族自治州",
"861450272", "内蒙古包头市",
"86566", "安徽省池州市",
"861821248", "贵州省铜仁地区",
"861399519", "宁夏银川市",
"861804876", "四川省宜宾市",
"861325568", "山东省济南市",
"861707998", "浙江省嘉兴市",
"86155188", "河南省安阳市",
"861369452", "黑龙江省齐齐哈尔市",
"86189930", "甘肃省兰州市",
"86153969", "江苏省淮安市",
"861868370", "四川省阿坝藏族羌族自治州",
"861583044", "河北省保定市",
"861321322", "河南省郑州市",
"861313915", "青海省果洛藏族自治州",
"861534696", "甘肃省张掖市",
"861316980", "广东省江门市",
"861881977", "广东省韶关市",
"861452787", "新疆阿克苏地区",
"861817013", "江西省赣州市",
"861700376", "河南省信阳市",
"861777127", "湖北省宜昌市",
"861809790", "新疆克拉玛依市",
"861593286", "江西省萍乡市",
"86138299", "广东省惠州市",
"86181502", "福建省宁德市",
"861322000", "陕西省咸阳市",
"861343520", "广东省湛江市",
"861850518", "江苏省连云港市",
"86150949", "山东省潍坊市",
"861538764", "四川省南充市",
"861803784", "河南省驻马店市",
"861354142", "四川省雅安市",
"861313950", "宁夏银川市",
"861580693", "山东省临沂市",
"861769858", "河南省周口市",
"86159384", "河南省南阳市",
"861350375", "河南省平顶山市",
"861336530", "山东省菏泽市",
"861368558", "安徽省阜阳市",
"861338075", "广东省肇庆市",
"86187614", "江苏省徐州市",
"861334371", "河南省郑州市",
"861318871", "山东省临沂市",
"861890902", "四川省德阳市",
"861576622", "广东省肇庆市",
"861825141", "江苏省连云港市",
"861534385", "河南省商丘市",
"861861542", "山东省济南市",
"86181559", "安徽省黄山市",
"861855102", "江苏省连云港市",
"861550799", "江西省萍乡市",
"861770553", "安徽省芜湖市",
"861373947", "四川省成都市",
"861818724", "云南省丽江市",
"861331702", "江西省九江市",
"861590639", "山东省青岛市",
"861369803", "江西省上饶市",
"861811576", "江苏省无锡市",
"861520644", "山东省枣庄市",
"861808897", "云南省丽江市",
"861778132", "四川省宜宾市",
"861876253", "江苏省盐城市",
"861522987", "陕西省宝鸡市",
"861866688", "广东省东莞市",
"861325844", "四川省绵阳市",
"861362448", "吉林省松原市",
"861323932", "甘肃省定西市",
"861763529", "山西省运城市",
"861355988", "福建省三明市",
"861586320", "山东省枣庄市",
"861538677", "山西省临汾市",
"861329636", "山东省潍坊市",
"861319168", "河北省保定市",
"861801281", "江苏省镇江市",
"86151745", "黑龙江省齐齐哈尔市",
"861530953", "宁夏吴忠市",
"861501857", "广东省湛江市",
"861871063", "陕西省渭南市",
"861535641", "浙江省温州市",
"861521899", "广东省汕头市",
"861348836", "陕西省宝鸡市",
"861354845", "四川省巴中市",
"861817750", "广西玉林市",
"86188021", "上海市",
"86177672", "浙江省杭州市",
"861580914", "陕西省商洛市",
"861363815", "贵州省毕节地区",
"861311451", "黑龙江省哈尔滨市",
"861366880", "山东省济南市",
"861380797", "江西省赣州市",
"861899742", "青海省海东地区",
"861310045", "广西玉林市",
"86178651", "山东省济南市",
"86183344", "浙江省温州市",
"86181228", "广东省东莞市",
"861512984", "陕西省渭南市",
"861889254", "贵州省安顺市",
"861510647", "山东省济宁市",
"86130245", "江苏省苏州市",
"86159967", "江苏省宿迁市",
"861862872", "吉林省松原市",
"861821479", "安徽省池州市",
"861586431", "山东省潍坊市",
"861348349", "河北省邢台市",
"861315847", "四川省凉山彝族自治州",
"861363850", "贵州省贵阳市",
"86183706", "江西省吉安市",
"861311591", "福建省福州市",
"861787598", "广东省江门市",
"861333179", "吉林省通化市",
"861527141", "湖北省十堰市",
"86151759", "河北省邢台市",
"861569864", "山西省忻州市",
"861818896", "湖南省衡阳市",
"861472992", "陕西省榆林市",
"861370951", "宁夏银川市",
"86159960", "江苏省泰州市",
"861333729", "湖南省邵阳市",
"861524882", "内蒙古阿拉善盟",
"861366537", "山东省济宁市",
"861556347", "山东省济宁市",
"861801577", "四川省阿坝藏族羌族自治州",
"861360524", "江苏省宿迁市",
"861880393", "河南省濮阳市",
"861707565", "安徽省合肥市",
"861359326", "山西省长治市",
"861360369", "黑龙江省佳木斯市",
"861810758", "广东省肇庆市",
"861848290", "四川省成都市",
"861516681", "山东省滨州市",
"861708319", "河北省沧州市",
"86181545", "广西南宁市",
"861774815", "四川省绵阳市",
"861802847", "广东省惠州市",
"861305846", "广东省潮州市",
"86134553", "山东省淄博市",
"861870350", "山西省忻州市",
"861397180", "湖北省咸宁市",
"86130528", "江苏省苏州市",
"861470819", "四川省甘孜藏族自治州",
"861354994", "广东省中山市",
"861500646", "山东省潍坊市",
"861333857", "福建省泉州市",
"861453844", "四川省巴中市",
"861302969", "浙江省温州市",
"861454290", "辽宁省沈阳市",
"861308261", "山东省东营市",
"861339434", "吉林省四平市",
"861890972", "青海省海东地区",
"861870315", "河北省唐山市",
"861334301", "河北省石家庄市",
"861301740", "贵州省遵义市",
"861513651", "河南省安阳市",
"861389589", "黑龙江省双鸭山市",
"861591935", "广东省惠州市",
"861331772", "广西柳州市",
"86153922", "福建省泉州市",
"861839924", "新疆和田地区",
"861336887", "云南省迪庆藏族自治州",
"861516077", "福建省泉州市",
"861880652", "浙江省杭州市",
"861332212", "辽宁省抚顺市",
"86138894", "辽宁省大连市",
"861322070", "山东省滨州市",
"861524494", "四川省遂宁市",
"861524185", "辽宁省阜新市",
"861386828", "浙江省湖州市",
"861700306", "广东省佛山市",
"861593325", "河北省唐山市",
"861370578", "浙江省温州市",
"861471943", "甘肃省兰州市",
"861812902", "新疆哈密地区",
"861857510", "广东省韶关市",
"861572435", "辽宁省铁岭市",
"861810347", "山西省临汾市",
"86180980", "陕西省榆林市",
"861393199", "河北省石家庄市",
"861804806", "四川省达州市",
"861700990", "新疆乌鲁木齐市",
"861450202", "河北省邯郸市",
"861534238", "湖北省黄冈市",
"861324721", "湖北省孝感市",
"861557805", "广西百色市",
"861894376", "吉林省白山市",
"861824874", "江苏省徐州市",
"86189937", "甘肃省酒泉市",
"861571919", "陕西省铜川市",
"861326765", "广东省江门市",
"861771133", "四川省巴中市",
"861830992", "新疆伊犁哈萨克自治州",
"861599131", "陕西省安康市",
"861346739", "湖南省邵阳市",
"861378785", "湖南省岳阳市",
"861768195", "浙江省杭州市",
"861850681", "浙江省杭州市",
"861514497", "内蒙古通辽市",
"861890339", "河北省石家庄市",
"861459674", "新疆阿克苏地区",
"861509012", "河南省南阳市",
"861357566", "浙江省衢州市",
"86130202", "上海市",
"861351632", "山东省枣庄市",
"861359338", "山西省吕梁市",
"861890846", "湖南省长沙市",
"861323309", "山西省临汾市",
"861820344", "山西省晋中市",
"86132861", "广东省江门市",
"861868543", "贵州省安顺市",
"86147557", "安徽省宿州市",
"861338703", "江西省上饶市",
"861597232", "湖北省孝感市",
"861893295", "河北省邢台市",
"86182351", "山西省太原市",
"861331825", "广东省中山市",
"861319973", "新疆喀什地区",
"861471596", "广东省深圳市",
"861590984", "辽宁省大连市",
"861354613", "山西省阳泉市",
"861311701", "湖北省黄石市",
"8613122", "上海市",
"86188439", "吉林省白山市",
"861810478", "内蒙古巴彦淖尔市",
"861817400", "江西省南昌市",
"861780770", "广西百色市",
"861308840", "内蒙古赤峰市",
"861787708", "广西河池市",
"861322413", "辽宁省抚顺市",
"861350323", "河北省秦皇岛市",
"861889396", "甘肃省张掖市",
"86151770", "广西百色市",
"86136934", "四川省成都市",
"861338872", "云南省大理白族自治州",
"86155953", "宁夏吴忠市",
"86136658", "浙江省金华市",
"861554536", "黑龙江省七台河市",
"861364346", "山西省太原市",
"861871908", "广东省惠州市",
"861824096", "新疆乌鲁木齐市",
"86130270", "山西省太原市",
"861376827", "广西南宁市",
"861315698", "山东省淄博市",
"861889900", "新疆阿勒泰地区",
"861598329", "四川省内江市",
"861873990", "河南省郑州市",
"86182736", "湖南省常德市",
"861867606", "广东省河源市",
"861470971", "青海省西宁市",
"861580205", "广东省汕头市",
"86156646", "陕西省西安市",
"861539443", "福建省泉州市",
"861452621", "江苏省苏州市",
"861310842", "四川省广安市",
"861360876", "云南省德宏傣族景颇族自治州",
"86133683", "重庆市",
"861331452", "黑龙江省齐齐哈尔市",
"86181512", "江苏省常州市",
"861309358", "安徽省宿州市",
"861328305", "河南省平顶山市",
"861893673", "江苏省连云港市",
"861815890", "安徽省阜阳市",
"861398573", "贵州省安顺市",
"86153321", "天津市",
"861373391", "河南省平顶山市",
"861589226", "四川省广元市",
"861583144", "河北省石家庄市",
"86158044", "吉林省长春市",
"86158422", "辽宁省鞍山市",
"861334589", "浙江省金华市",
"861345587", "山东省威海市",
"861521960", "广东省揭阳市",
"861811796", "四川省泸州市",
"861552694", "吉林省白城市",
"861386247", "江苏省南通市",
"86181577", "浙江省温州市",
"861303548", "安徽省铜陵市",
"861504669", "黑龙江省哈尔滨市",
"861550579", "浙江省金华市",
"861340931", "河南省平顶山市",
"861452949", "广东省梅州市",
"861303864", "云南省昭通市",
"861809570", "青海省海北藏族自治州",
"861365391", "河南省焦作市",
"861556478", "山东省莱芜市",
"861871491", "安徽省宿州市",
"861338946", "甘肃省庆阳市",
"861841982", "甘肃省庆阳市",
"861377790", "浙江省金华市",
"861839542", "陕西省榆林市",
"861331803", "广东省湛江市",
"861369702", "江西省九江市",
"861300907", "吉林省白山市",
"861338725", "湖北省宜昌市",
"861778032", "四川省内江市",
"861801118", "四川省遂宁市",
"861390088", "云南省西双版纳傣族自治州",
"861365789", "广西北海市",
"861777597", "湖南省郴州市",
"861888233", "四川省南充市",
"861857761", "广西柳州市",
"861343190", "广东省珠海市",
"861571871", "云南省昆明市",
"861302342", "江苏省南京市",
"861825041", "福建省泉州市",
"861589238", "四川省广安市",
"861560998", "新疆喀什地区",
"861814429", "四川省南充市",
"861470558", "安徽省阜阳市",
"861332370", "河南省商丘市",
"861571230", "辽宁省沈阳市",
"861840917", "陕西省宝鸡市",
"861341108", "广东省汕尾市",
"86153516", "江苏省徐州市",
"86159692", "云南省德宏傣族景颇族自治州",
"861828077", "四川省绵阳市",
"861894869", "广东省江门市",
"86187060", "福建省南平市",
"861890237", "广东省云浮市",
"861554528", "黑龙江省鸡西市",
"861894283", "四川省甘孜藏族自治州",
"861572541", "山东省济南市",
"861309747", "云南省曲靖市",
"861858344", "四川省资阳市",
"86137555", "江西省新余市",
"861840330", "河北省邯郸市",
"861557823", "广西柳州市",
"861877989", "江西省南昌市",
"861326551", "广东省广州市",
"861394947", "河南省平顶山市",
"861563634", "黑龙江省鸡西市",
"861475800", "浙江省舟山市",
"861552913", "陕西省渭南市",
"861333009", "江西省南昌市",
"86155581", "浙江省杭州市",
"861865990", "福建省泉州市",
"861310145", "福建省泉州市",
"861593303", "河北省张家口市",
"861323207", "广东省韶关市",
"861471706", "甘肃省兰州市",
"861709540", "江苏省徐州市",
"861362307", "广东省阳江市",
"861521418", "甘肃省白银市",
"86182566", "安徽省池州市",
"861319068", "内蒙古乌海市",
"861781789", "广东省湛江市",
"861338593", "福建省宁德市",
"861323581", "浙江省杭州市",
"861876661", "山东省东营市",
"861537997", "甘肃省白银市",
"861381346", "江苏省徐州市",
"861326491", "湖北省宜昌市",
"861570742", "湖南省怀化市",
"861310390", "河南省商丘市",
"861308653", "四川省阿坝藏族羌族自治州",
"86131631", "天津市",
"861768525", "贵州省黔东南苗族侗族自治州",
"861315228", "陕西省铜川市",
"861323277", "广东省河源市",
"861523505", "山西省朔州市",
"861332543", "陕西省渭南市",
"861478524", "贵州省黔东南苗族侗族自治州",
"861362377", "河南省南阳市",
"861816509", "陕西省西安市",
"861892478", "广东省汕头市",
"86147579", "浙江省金华市",
"861524783", "内蒙古巴彦淖尔市",
"86155878", "湖北省仙桃市",
"861520737", "湖南省益阳市",
"861310906", "新疆伊犁哈萨克自治州",
"861338453", "黑龙江省牡丹江市",
"86187067", "陕西省西安市",
"861333079", "四川省甘孜藏族自治州",
"861513889", "河南省安阳市",
"861527041", "江西省宜春市",
"861878865", "贵州省安顺市",
"861846233", "山东省临沂市",
"861508348", "河南省信阳市",
"86183716", "湖北省荆州市",
"861871551", "安徽省合肥市",
"861855072", "江苏省宿迁市",
"86744", "湖南省张家界市",
"861308392", "浙江省湖州市",
"86158469", "黑龙江省大庆市",
"86137780", "四川省绵阳市",
"86185292", "广东省广州市",
"861772851", "广东省惠州市",
"86156211", "山东省青岛市",
"861313274", "广西梧州市",
"861810991", "新疆乌鲁木齐市",
"86157226", "江苏省苏州市",
"861332300", "河北省邯郸市",
"861809500", "四川省巴中市",
"861452291", "山西省太原市",
"861556408", "山东省滨州市",
"861510734", "湖南省衡阳市",
"861806474", "浙江省绍兴市",
"861367221", "江西省南昌市",
"861819435", "甘肃省天水市",
"861361434", "吉林省四平市",
"861350252", "广东省梅州市",
"861768793", "江西省上饶市",
"861476029", "福建省龙岩市",
"86131474", "河北省石家庄市",
"861323866", "云南省昆明市",
"86156122", "河北省保定市",
"861300977", "黑龙江省佳木斯市",
"861319925", "黑龙江省伊春市",
"86152766", "新疆乌鲁木齐市",
"861370798", "江西省景德镇市",
"861319746", "湖北省随州市",
"861844999", "新疆石河子市",
"861332996", "湖北省鄂州市",
"861505535", "安徽省宿州市",
"861479741", "山西省吕梁市",
"861532878", "四川省眉山市",
"861320633", "山东省日照市",
"861515400", "山东省威海市",
"861836767", "浙江省台州市",
"861450310", "河北省邯郸市",
"86157030", "重庆市",
"861330260", "广东省东莞市",
"861345830", "四川省绵阳市",
"86181570", "浙江省衢州市",
"861322720", "湖北省咸宁市",
"861850859", "贵州省黔西南布依族苗族自治州",
"861476599", "北京市",
"86152293", "陕西省西安市",
"861586545", "山东省东营市",
"861331592", "河北省邢台市",
"861379441", "广东省广州市",
"861558644", "湖北省十堰市",
"861882665", "广东省佛山市",
"861576916", "陕西省汉中市",
"86177455", "黑龙江省大庆市",
"861898941", "浙江省金华市",
"861821827", "广东省茂名市",
"861874295", "新疆乌鲁木齐市",
"86152536", "山东省潍坊市",
"861832498", "安徽省安庆市",
"861533393", "河南省濮阳市",
"861322170", "浙江省衢州市",
"861328375", "河南省平顶山市",
"861893603", "江苏省南京市",
"861311121", "山西省吕梁市",
"861881232", "云南省普洱市",
"861560565", "安徽省合肥市",
"861889970", "广东省汕尾市",
"86130277", "河南省郑州市",
"861871978", "甘肃省兰州市",
"86151712", "湖北省孝感市",
"861503452", "山西省长治市",
"861817642", "广西桂林市",
"861470901", "新疆塔城地区",
"861380281", "广东省韶关市",
"861315236", "陕西省渭南市",
"861774012", "四川省泸州市",
"861536682", "江苏省常州市",
"861804094", "新疆和田地区",
"861787778", "湖南省长沙市",
"861896694", "陕西省西安市",
"86130212", "北京市",
"861531548", "山东省泰安市",
"861356220", "山东省枣庄市",
"86147696", "云南省文山壮族苗族自治州",
"861810408", "辽宁省大连市",
"861509112", "陕西省榆林市",
"861360485", "黑龙江省绥化市",
"861311771", "广西南宁市",
"861770784", "广西梧州市",
"861850727", "湖北省襄樊市",
"861560471", "内蒙古呼和浩特市",
"861883446", "山西省运城市",
"861392145", "江苏省南通市",
"861314302", "河北省石家庄市",
"86151777", "广西柳州市",
"861369825", "四川省自贡市",
"861346849", "山东省潍坊市",
"86133062", "江苏省苏州市",
"86134316", "广东省佛山市",
"861340464", "吉林省四平市",
"861333338", "河北省石家庄市",
"861534518", "江苏省南京市",
"861537813", "四川省乐山市",
"861323706", "江西省吉安市",
"861471581", "广东省广州市",
"861817633", "广西桂林市",
"861365273", "广东省江门市",
"861452303", "河南省安阳市",
"86153582", "江苏省盐城市",
"861532923", "贵州省安顺市",
"861571761", "河北省张家口市",
"861709949", "浙江省嘉兴市",
"861362494", "辽宁省大连市",
"861325898", "山东省聊城市",
"861309246", "江苏省宿迁市",
"861368380", "河南省郑州市",
"861857871", "广东省汕尾市",
"861303124", "新疆巴音郭楞蒙古自治州",
"861890736", "湖南省常德市",
"861831426", "云南省大理白族自治州",
"861816970", "广西贵港市",
"86159705", "江西省宜春市",
"86137776", "浙江省台州市",
"861520698", "山东省潍坊市",
"861552897", "四川省宜宾市",
"861390445", "吉林省通化市",
"861331936", "江西省宜春市",
"861857230", "湖北省恩施土家族苗族自治州",
"861346336", "河北省秦皇岛市",
"861583528", "山西省运城市",
"86130988", "湖北省武汉市",
"861380912", "陕西省榆林市",
"861855551", "安徽省合肥市",
"861570035", "四川省内江市",
"861774918", "陕西省渭南市",
"861452540", "山东省菏泽市",
"861840893", "西藏山南地区",
"861871823", "广东省揭阳市",
"861809979", "新疆博尔塔拉蒙古自治州",
"861870611", "江苏省常州市",
"861334605", "浙江省绍兴市",
"861370637", "山东省滨州市",
"86139020", "天津市",
"8623", "重庆市",
"861364258", "广东省韶关市",
"861596407", "山东省滨州市",
"861320470", "内蒙古呼伦贝尔市",
"861539788", "江西省抚州市",
"861575114", "江苏省泰州市",
"86186596", "福建省漳州市",
"861862863", "陕西省汉中市",
"861304405", "山东省临沂市",
"861314530", "山东省菏泽市",
"861519545", "江苏省徐州市",
"861760531", "山东省济南市",
"861780860", "贵州省毕节地区",
"861321489", "内蒙古巴彦淖尔市",
"86189542", "山东省青岛市",
"861882292", "广东省揭阳市",
"861829060", "新疆阿克苏地区",
"86135013", "北京市",
"861589727", "青海省海西蒙古族藏族自治州",
"861453734", "湖南省长沙市",
"86139593", "福建省宁德市",
"86187396", "河南省驻马店市",
"861554144", "辽宁省铁岭市",
"86155322", "河北省保定市",
"861569454", "黑龙江省佳木斯市",
"861860755", "广东省深圳市",
"86150727", "湖北省黄冈市",
"861550970", "青海省海北藏族自治州",
"861334980", "湖北省襄樊市",
"861521569", "安徽省合肥市",
"861359857", "河南省信阳市",
"861301271", "山东省淄博市",
"86139236", "广东省惠州市",
"861840572", "浙江省湖州市",
"861329016", "山东省日照市",
"861318184", "山东省泰安市",
"861533587", "湖北省荆州市",
"861705561", "陕西省西安市",
"861327991", "新疆乌鲁木齐市",
"861318495", "河北省邢台市",
"861358013", "广东省韶关市",
"861583098", "河北省石家庄市",
"861855978", "福建省厦门市",
"861359729", "广西南宁市",
"861303667", "四川省成都市",
"86170858", "福建省厦门市",
"86180520", "江苏省南京市",
"861330313", "河北省张家口市",
"861570733", "湖南省长沙市",
"861505904", "福建省三明市",
"861815333", "湖南省长沙市",
"861459429", "云南省怒江傈僳族自治州",
"861707944", "河南省濮阳市",
"861333326", "河北省廊坊市",
"861380354", "江西省南昌市",
"861571084", "广东省深圳市",
"861332532", "陕西省榆林市",
"86138931", "甘肃省兰州市",
"861836807", "浙江省舟山市",
"861583536", "山西省大同市",
"861782015", "广东省河源市",
"861709621", "山东省临沂市",
"861384961", "河南省驻马店市",
"861889509", "宁夏银川市",
"861474567", "黑龙江省七台河市",
"861561660", "湖南省常德市",
"861527220", "湖北省鄂州市",
"861525145", "江苏省徐州市",
"861890728", "湖北省十堰市",
"861818881", "广东省中山市",
"861865029", "福建省泉州市",
"86130005", "广东省广州市",
"861863416", "河北省唐山市",
"861348746", "湖南省永州市",
"861879119", "陕西省铜川市",
"861454435", "江苏省盐城市",
"861891931", "甘肃省兰州市",
"86159742", "湖南省长沙市",
"861323138", "河北省秦皇岛市",
"861532768", "湖北省荆州市",
"861595413", "山东省日照市",
"861570966", "宁夏吴忠市",
"861869269", "湖南省永州市",
"861457054", "新疆昌吉回族自治州",
"861390982", "辽宁省沈阳市",
"861864243", "辽宁省阜新市",
"86156263", "广东省阳江市",
"861860423", "辽宁省抚顺市",
"861778938", "甘肃省张掖市",
"861330731", "湖南省长沙市",
"861570311", "河北省石家庄市",
"861813655", "江苏省扬州市",
"861354735", "四川省泸州市",
"861559740", "青海省海北藏族自治州",
"861855908", "福建省南平市",
"861533271", "内蒙古呼和浩特市",
"86133029", "广东省深圳市",
"861830717", "湖北省宜昌市",
"861312445", "福建省厦门市",
"861878822", "云南省德宏傣族景颇族自治州",
"86186415", "辽宁省丹东市",
"861551634", "河南省三门峡市",
"861525906", "福建省宁德市",
"861536497", "山西省临汾市",
"861869156", "陕西省西安市",
"861591794", "广东省梅州市",
"861897170", "湖北省黄冈市",
"861533830", "广东省佛山市",
"861537645", "山东省烟台市",
"86178623", "山东省日照市",
"861769910", "新疆乌鲁木齐市",
"861478148", "四川省泸州市",
"861360048", "广东省广州市",
"86130286", "河北省石家庄市",
"861538538", "安徽省池州市",
"861363460", "黑龙江省哈尔滨市",
"861566550", "安徽省滁州市",
"861550900", "新疆昌吉回族自治州",
"861589107", "陕西省宝鸡市",
"861313818", "广东省深圳市",
"86150720", "湖北省黄石市",
"861379215", "山东省淄博市",
"861843268", "河北省衡水市",
"861787616", "广东省阳江市",
"861898754", "云南省保山市",
"861301201", "河北省唐山市",
"861311861", "广东省潮州市",
"861342824", "广东省汕尾市",
"861566515", "江苏省盐城市",
"861331065", "山东省聊城市",
"861476306", "山东省滨州市",
"861550396", "河南省驻马店市",
"861888242", "四川省广元市",
"861324492", "广东省江门市",
"861569594", "福建省莆田市",
"86151786", "安徽省安庆市",
"861804148", "辽宁省沈阳市",
"861818566", "贵州省遵义市",
"861587582", "广东省肇庆市",
"861705153", "广东省东莞市",
"861479954", "新疆喀什地区",
"861508169", "河北省廊坊市",
"861325734", "湖南省衡阳市",
"861820398", "河南省三门峡市",
"861833189", "河北省邯郸市",
"861473661", "云南省红河哈尼族彝族自治州",
"861534077", "山西省阳泉市",
"861477959", "江西省宜春市",
"86178898", "海南省海口市",
"861338387", "河南省洛阳市",
"86139027", "广东省汕头市",
"861539432", "浙江省宁波市",
"86132803", "山东省东营市",
"861593291", "江西省上饶市",
"861310833", "四川省乐山市",
"861350087", "吉林省辽源市",
"861532214", "广东省惠州市",
"861319247", "广东省惠州市",
"86183291", "浙江省杭州市",
"861304475", "河南省新乡市",
"861700779", "广东省东莞市",
"861596477", "山东省聊城市",
"861787544", "广东省汕头市",
"861518988", "江苏省扬州市",
"86183782", "广西柳州市",
"861320400", "辽宁省沈阳市",
"861327478", "内蒙古巴彦淖尔市",
"861894709", "内蒙古鄂尔多斯市",
"861375460", "山东省威海市",
"861524279", "辽宁省盘锦市",
"86189505", "福建省宁德市",
"861471618", "广东省潮州市",
"861334675", "河南省信阳市",
"86159373", "河南省新乡市",
"861776011", "四川省宜宾市",
"861534681", "甘肃省兰州市",
"861458590", "山东省潍坊市",
"861554992", "湖北省咸宁市",
"861861360", "山东省德州市",
"86155369", "山西省太原市",
"861809909", "新疆博尔塔拉蒙古自治州",
"861350671", "浙江省杭州市",
"861550685", "广西百色市",
"861816900", "宁夏银川市",
"861598076", "福建省厦门市",
"861778926", "陕西省延安市",
"861857801", "广东省江门市",
"861363918", "贵州省六盘水市",
"861560522", "江苏省徐州市",
"861320113", "新疆巴音郭楞蒙古自治州",
"86147304", "河北省石家庄市",
"861368444", "四川省遂宁市",
"861812178", "江苏省徐州市",
"861709291", "陕西省榆林市",
"861453898", "云南省曲靖市",
"86139938", "甘肃省天水市",
"861872431", "黑龙江省黑河市",
"861306525", "辽宁省盘锦市",
"861558847", "山东省枣庄市",
"861527690", "新疆哈密地区",
"861594527", "黑龙江省黑河市",
"861870588", "浙江省丽水市",
"861852407", "辽宁省营口市",
"861893321", "广东省珠海市",
"861812728", "广东省云浮市",
"861887574", "河北省邢台市",
"861303704", "山西省朔州市",
"861890963", "安徽省芜湖市",
"861800749", "湖南省长沙市",
"861584660", "黑龙江省哈尔滨市",
"861472717", "浙江省湖州市",
"861362554", "安徽省淮南市",
"861361316", "河北省廊坊市",
"861535345", "陕西省安康市",
"86170973", "广东省深圳市",
"86156796", "江西省吉安市",
"861331763", "广西桂林市",
"861867264", "湖北省随州市",
"861369862", "山东省济南市",
"861459059", "广东省肇庆市",
"861572290", "江苏省南京市",
"861323776", "广西百色市",
"861508976", "广东省潮州市",
"861821983", "甘肃省平凉市",
"861557258", "湖北省荆门市",
"861351582", "浙江省湖州市",
"861322566", "安徽省池州市",
"861850531", "山东省济南市",
"86182820", "四川省南充市",
"861317340", "山东省威海市",
"861528904", "西藏林芝地区",
"861569700", "云南省昭通市",
"861827256", "河南省安阳市",
"861800063", "河北省唐山市",
"861515299", "江苏省泰州市",
"861865948", "福建省莆田市",
"86132307", "河北省沧州市",
"861551462", "河南省周口市",
"861520091", "湖南省长沙市",
"861508145", "河北省唐山市",
"861570857", "贵州省毕节地区",
"861847135", "湖北省咸宁市",
"861553383", "河北省衡水市",
"861898642", "湖北省鄂州市",
"861814600", "福建省宁德市",
"861848759", "云南省怒江傈僳族自治州",
"861331049", "贵州省遵义市",
"86159812", "吉林省吉林市",
"861379970", "福建省漳州市",
"861522486", "河南省南阳市",
"861350008", "广东省汕尾市",
"861336975", "青海省海东地区",
"861536981", "河北省沧州市",
"861338308", "河北省邯郸市",
"861560940", "甘肃省临夏回族自治州",
"861459433", "西藏山南地区",
"861870018", "陕西省西安市",
"861535094", "辽宁省锦州市",
"86177769", "海南省海口市",
"861864885", "广西柳州市",
"861570729", "湖北省十堰市",
"861539777", "四川省绵阳市",
"861359733", "广西桂林市",
"861518907", "江苏省宿迁市",
"861454827", "广东省肇庆市",
"861566783", "陕西省榆林市",
"8614710", "四川省成都市",
"861869245", "湖南省郴州市",
"861336146", "山东省聊城市",
"861889441", "甘肃省临夏回族自治州",
"86180595", "福建省莆田市",
"861572067", "江苏省苏州市",
"861760385", "河南省郑州市",
"861537669", "山东省潍坊市",
"861533951", "贵州省贵阳市",
"861388162", "四川省雅安市",
"861333843", "福建省福州市",
"861304268", "辽宁省锦州市",
"861822555", "安徽省马鞍山市",
"861539127", "内蒙古鄂尔多斯市",
"861570179", "甘肃省白银市",
"861312469", "贵州省黔东南苗族侗族自治州",
"861347239", "河北省张家口市",
"861532939", "贵州省黔西南布依族苗族自治州",
"86177539", "山东省临沂市",
"861589188", "云南省曲靖市",
"861303590", "云南省红河哈尼族彝族自治州",
"861880798", "江西省景德镇市",
"861771376", "四川省泸州市",
"861847832", "湖南省岳阳市",
"861810353", "山西省阳泉市",
"861808690", "四川省南充市",
"861586418", "山东省德州市",
"861575753", "浙江省杭州市",
"861819167", "陕西省西安市",
"861516531", "山东省济南市",
"861306344", "安徽省合肥市",
"861301508", "内蒙古巴彦淖尔市",
"861309584", "浙江省湖州市",
"861342412", "广东省广州市",
"861538870", "云南省昭通市",
"86134568", "浙江省杭州市",
"861877425", "湖南省衡阳市",
"861328178", "四川省遂宁市",
"861815848", "浙江省宁波市",
"86158755", "广东省深圳市",
"861535524", "浙江省衢州市",
"861377935", "新疆石河子市",
"861760696", "云南省昆明市",
"861561597", "山东省济宁市",
"861800765", "广东省茂名市",
"861810692", "福建省福州市",
"86158587", "浙江省温州市",
"861364908", "四川省遂宁市",
"861814985", "新疆阿克苏地区",
"861878414", "四川省宜宾市",
"861871839", "广东省广州市",
"861844704", "内蒙古呼和浩特市",
"861566085", "河南省新乡市",
"861581896", "广东省珠海市",
"861554040", "内蒙古乌兰察布市",
"861315640", "山东省济南市",
"86134804", "广东省东莞市",
"86183175", "河南省洛阳市",
"861300756", "河南省洛阳市",
"861309473", "浙江省温州市",
"861568807", "贵州省毕节地区",
"861587012", "贵州省遵义市",
"861520521", "江苏省徐州市",
"861365446", "吉林省吉林市",
"861329861", "湖南省常德市",
"861531415", "山东省聊城市",
"861862447", "辽宁省铁岭市",
"861533578", "湖北省随州市",
"861304714", "湖北省武汉市",
"861313741", "河南省许昌市",
"861775924", "福建省福州市",
"861501650", "广东省潮州市",
"861352986", "云南省曲靖市",
"861315472", "内蒙古包头市",
"861308898", "陕西省西安市",
"861321962", "陕西省榆林市",
"861881476", "黑龙江省大庆市",
"861301017", "山东省济南市",
"861367144", "广东省潮州市",
"861894133", "辽宁省大连市",
"861559637", "陕西省商洛市",
"861339673", "浙江省嘉兴市",
"86188549", "山东省临沂市",
"861386661", "安徽省安庆市",
"861315402", "陕西省榆林市",
"861319489", "四川省成都市",
"861705268", "上海市",
"861533508", "江苏省南通市",
"861310829", "陕西省宝鸡市",
"861708552", "安徽省合肥市",
"861458124", "安徽省安庆市",
"861522722", "河北省保定市",
"86132971", "湖北省十堰市",
"861881406", "广东省中山市",
"861340632", "山东省枣庄市",
"861302848", "陕西省宝鸡市",
"86147816", "四川省绵阳市",
"861358474", "江苏省南通市",
"861364978", "青海省海东地区",
"861500919", "陕西省铜川市",
"861700133", "广东省深圳市",
"86180416", "辽宁省锦州市",
"86188555", "安徽省马鞍山市",
"86134209", "广东省深圳市",
"861837524", "贵州省黔南布依族苗族自治州",
"861309403", "新疆伊犁哈萨克自治州",
"861568877", "山东省莱芜市",
"861458774", "湖南省湘西土家族苗族自治州",
"86138060", "福建省厦门市",
"861771990", "河南省鹤壁市",
"861309155", "黑龙江省绥化市",
"861529466", "河南省安阳市",
"86138604", "福建省厦门市",
"86152446", "黑龙江省哈尔滨市",
"861590589", "浙江省金华市",
"861303450", "山东省淄博市",
"861360641", "山东省济南市",
"86153274", "湖北省武汉市",
"861365953", "西藏拉萨市",
"861885012", "福建省福州市",
"861843405", "山西省临汾市",
"86130503", "辽宁省丹东市",
"86170801", "北京市",
"861802640", "广东省广州市",
"86132458", "江苏省南京市",
"861390469", "黑龙江省大庆市",
"861557987", "江西省赣州市",
"861310757", "青海省海西蒙古族藏族自治州",
"861329586", "浙江省台州市",
"861581174", "广东省清远市",
"861309110", "河北省邯郸市",
"861709965", "浙江省台州市",
"861333650", "广东省湛江市",
"861529327", "甘肃省酒泉市",
"861457115", "湖北省鄂州市",
"861303415", "甘肃省白银市",
"861306480", "江苏省宿迁市",
"861598342", "四川省凉山彝族自治州",
"861351854", "贵州省黔南布依族苗族自治州",
"86158749", "湖南省长沙市",
"861370740", "湖南省岳阳市",
"861876247", "江苏省南通市",
"861860439", "吉林省白山市",
"861359311", "山西省晋中市",
"861510392", "甘肃省张掖市",
"861855258", "江苏省扬州市",
"861359966", "福建省漳州市",
"861858562", "贵州省贵阳市",
"861892353", "广东省揭阳市",
"861527567", "山东省聊城市",
"861396568", "安徽省合肥市",
"861776866", "江苏省镇江市",
"861473068", "河北省石家庄市",
"861883391", "河北省石家庄市",
"861776618", "江苏省无锡市",
"861877010", "江西省鹰潭市",
"861534088", "山西省晋城市",
"861886759", "浙江省金华市",
"861338378", "河南省开封市",
"861364551", "安徽省合肥市",
"861573841", "河南省郑州市",
"861826232", "江苏省泰州市",
"861599118", "陕西省安康市",
"861308734", "湖南省衡阳市",
"861336905", "新疆克拉玛依市",
"861503049", "河北省邢台市",
"861571646", "河南省新乡市",
"861770547", "山东省济宁市",
"861317573", "浙江省衢州市",
"861327487", "内蒙古鄂尔多斯市",
"861870577", "浙江省温州市",
"861839529", "宁夏银川市",
"861508390", "江西省赣州市",
"86134252", "广东省清远市",
"86132300", "河北省邯郸市",
"861383990", "河南省驻马店市",
"861515941", "福建省宁德市",
"86131295", "广东省深圳市",
"861315853", "四川省雅安市",
"861852732", "湖北省荆州市",
"861379900", "福建省莆田市",
"861886827", "浙江省温州市",
"861880834", "四川省凉山彝族自治州",
"861517564", "河北省唐山市",
"861814670", "江西省南昌市",
"861532302", "广东省梅州市",
"861814442", "广东省湛江市",
"86150795", "江西省宜春市",
"861309852", "贵州省遵义市",
"86186947", "福建省泉州市",
"861508906", "西藏那曲地区",
"861812187", "四川省成都市",
"861530947", "甘肃省酒泉市",
"861302564", "广东省阳江市",
"86182827", "四川省巴中市",
"86189003", "福建省泉州市",
"861310348", "山西省运城市",
"861379396", "山东省东营市",
"861458667", "湖南省郴州市",
"861569770", "广西防城港市",
"861881182", "广东省茂名市",
"861301951", "内蒙古呼伦贝尔市",
"86159870", "云南省昭通市",
"861317195", "河北省邢台市",
"861859955", "福建省泉州市",
"86137439", "吉林省白山市",
"861521545", "山东省烟台市",
"861504813", "内蒙古呼伦贝尔市",
"861322004", "陕西省渭南市",
"861343524", "广东省湛江市",
"86153665", "江苏省盐城市",
"86150348", "内蒙古兴安盟",
"861811412", "江苏省泰州市",
"86183846", "四川省乐山市",
"861805077", "福建省福州市",
"861479666", "江西省吉安市",
"861395722", "浙江省舟山市",
"861708071", "湖南省长沙市",
"86159429", "辽宁省葫芦岛市",
"861538760", "四川省南充市",
"861366492", "广东省江门市",
"861313954", "宁夏固原市",
"861599296", "广东省韶关市",
"861350972", "山西省大同市",
"861501832", "广东省珠海市",
"86150645", "山东省烟台市",
"86130356", "四川省绵阳市",
"861810487", "内蒙古巴彦淖尔市",
"861820573", "浙江省嘉兴市",
"861337886", "云南省怒江傈僳族自治州",
"86180866", "湖北省武汉市",
"861594731", "内蒙古呼和浩特市",
"861530695", "福建省泉州市",
"861534982", "安徽省安庆市",
"861531241", "江苏省南京市",
"861890305", "广东省广州市",
"861800875", "云南省保山市",
"861509931", "新疆阿勒泰地区",
"861316984", "广东省江门市",
"861580468", "黑龙江省鹤岗市",
"861453653", "江苏省扬州市",
"861881359", "广东省汕尾市",
"861888229", "四川省成都市",
"861868374", "四川省阿坝藏族羌族自治州",
"861583040", "河北省邯郸市",
"861329121", "江苏省无锡市",
"86182615", "江苏省无锡市",
"861778157", "四川省巴中市",
"861324608", "广东省汕头市",
"861477783", "广西河池市",
"861875151", "江苏省徐州市",
"861700845", "浙江省绍兴市",
"86158576", "浙江省台州市",
"861819759", "新疆博尔塔拉蒙古自治州",
"861474041", "辽宁省沈阳市",
"861345578", "山东省滨州市",
"861478345", "河南省南阳市",
"861323957", "宁夏中卫市",
"861367098", "广东省湛江市",
"861459600", "宁夏银川市",
"861572409", "广东省深圳市",
"861303999", "黑龙江省哈尔滨市",
"861566448", "山东省潍坊市",
"861826243", "江苏省扬州市",
"861804345", "吉林省四平市",
"86182318", "河北省衡水市",
"861820484", "内蒙古兴安盟",
"861329771", "广西南宁市",
"861761416", "辽宁省锦州市",
"861378967", "内蒙古鄂尔多斯市",
"861597988", "江西省新余市",
"861453392", "内蒙古阿拉善盟",
"861367536", "山东省潍坊市",
"86189432", "吉林省吉林市",
"861829824", "安徽省马鞍山市",
"861327222", "湖南省张家界市",
"861305305", "安徽省合肥市",
"861889250", "贵州省安顺市",
"861828211", "四川省巴中市",
"861356567", "新疆喀什地区",
"861390681", "浙江省杭州市",
"861590675", "浙江省绍兴市",
"861512980", "陕西省西安市",
"861560549", "山东省临沂市",
"861350339", "河北省邢台市",
"861363854", "贵州省黔南布依族苗族自治州",
"861580955", "宁夏中卫市",
"86159886", "浙江省宁波市",
"861392256", "广东省清远市",
"861335192", "黑龙江省齐齐哈尔市",
"861899338", "甘肃省白银市",
"861350846", "湖南省常德市",
"861369437", "吉林省辽源市",
"861314046", "河南省开封市",
"861452598", "福建省三明市",
"861556487", "山东省青岛市",
"861889215", "陕西省西安市",
"861555646", "安徽省合肥市",
"861598333", "四川省眉山市",
"861869927", "新疆哈密地区",
"861800722", "湖北省武汉市",
"861817754", "广西玉林市",
"861539276", "湖北省荆州市",
"861580910", "陕西省咸阳市",
"86135028", "广东省深圳市",
"861390077", "广西南宁市",
"861328237", "浙江省舟山市",
"861586569", "山东省菏泽市",
"861520640", "山东省菏泽市",
"861586324", "山东省菏泽市",
"861340643", "山东省烟台市",
"861580337", "河北省沧州市",
"861818170", "四川省宜宾市",
"861477085", "江西省宜春市",
"861325840", "四川省南充市",
"861828088", "四川省遂宁市",
"861336534", "山东省德州市",
"861535148", "四川省遂宁市",
"861379579", "四川省阿坝藏族羌族自治州",
"861330527", "江苏省扬州市",
"861700142", "江苏省盐城市",
"861319661", "江苏省苏州市",
"861321925", "四川省广安市",
"861454167", "浙江省温州市",
"861776706", "浙江省杭州市",
"861520472", "内蒙古包头市",
"861530386", "河南省洛阳市",
"861313312", "山西省大同市",
"861892265", "广东省云浮市",
"861321746", "湖南省永州市",
"86135937", "湖北省十堰市",
"861301744", "贵州省安顺市",
"861859519", "宁夏固原市",
"861770668", "浙江省宁波市",
"861572248", "江苏省盐城市",
"861534445", "湖南省怀化市",
"861339430", "吉林省长春市",
"861760859", "贵州省黔西南布依族苗族自治州",
"86150602", "福建省宁德市",
"86135930", "山西省大同市",
"861596045", "福建省宁德市",
"861595566", "安徽省池州市",
"861839920", "新疆吐鲁番地区",
"861304047", "新疆克孜勒苏柯尔克孜自治州",
"861597257", "湖北省十堰市",
"86187931", "甘肃省兰州市",
"86147100", "北京市",
"861575462", "黑龙江省齐齐哈尔市",
"861870354", "山西省晋中市",
"861397184", "湖北省荆门市",
"861527648", "新疆石河子市",
"861396647", "安徽省淮南市",
"861860147", "江苏省无锡市",
"861314768", "吉林省松原市",
"861773072", "陕西省渭南市",
"86159462", "黑龙江省齐齐哈尔市",
"861362388", "河南省洛阳市",
"861453840", "四川省甘孜藏族自治州",
"861454294", "辽宁省抚顺市",
"861323288", "广东省江门市",
"861354990", "广东省中山市",
"861458548", "河南省三门峡市",
"861360520", "江苏省徐州市",
"861339321", "河北省石家庄市",
"86183635", "山东省聊城市",
"861390007", "广东省广州市",
"861539206", "福建省南平市",
"861300988", "黑龙江省牡丹江市",
"861327692", "福建省莆田市",
"86153420", "天津市",
"861346822", "山东省莱芜市",
"861837148", "湖北省武汉市",
"861830395", "河南省漯河市",
"861700613", "江苏省南京市",
"86138396", "河南省驻马店市",
"861472686", "四川省广元市",
"861818413", "贵州省安顺市",
"861876746", "浙江省温州市",
"861709922", "浙江省衢州市",
"861760727", "湖北省襄樊市",
"861341187", "广东省深圳市",
"861372292", "河北省邢台市",
"861452458", "黑龙江省伊春市",
"861321068", "山东省潍坊市",
"861569860", "山西省长治市",
"861348489", "陕西省汉中市",
"861537481", "内蒙古兴安盟",
"861820340", "山西省忻州市",
"861310256", "河北省邢台市",
"861816441", "安徽省芜湖市",
"861804190", "辽宁省辽阳市",
"86180482", "内蒙古兴安盟",
"861894845", "广东省揭阳市",
"861884683", "黑龙江省哈尔滨市",
"861590980", "辽宁省鞍山市",
"861344161", "河北省邯郸市",
"861771599", "江苏省镇江市",
"861353625", "广东省惠州市",
"861880637", "山东省枣庄市",
"861380611", "江苏省常州市",
"861507681", "河北省衡水市",
"861532887", "四川省南充市",
"861337561", "山东省聊城市",
"861846229", "山东省聊城市",
"861865042", "福建省厦门市",
"86181109", "安徽省合肥市",
"861310169", "黑龙江省双鸭山市",
"86130168", "江苏省常州市",
"86153156", "山东省菏泽市",
"861568767", "云南省文山壮族苗族自治州",
"86147882", "河南省商丘市",
"861345508", "山东省聊城市",
"861870912", "陕西省榆林市",
"861890375", "河南省平顶山市",
"861820503", "江苏省无锡市",
"861520853", "贵州省安顺市",
"86151805", "江西省宜春市",
"861350902", "广东省东莞市",
"861366552", "安徽省蚌埠市",
"86188776", "广西百色市",
"8618878", "广西南宁市",
"861824870", "江苏省扬州市",
"861320941", "甘肃省甘南藏族自治州",
"861346775", "湖南省衡阳市",
"861345017", "广东省肇庆市",
"861842016", "广东省河源市",
"861334019", "江西省抚州市",
"861500555", "安徽省安庆市",
"861776138", "四川省攀枝花市",
"861363582", "湖北省孝感市",
"861559798", "贵州省黔西南布依族苗族自治州",
"861322074", "山东省潍坊市",
"861524490", "四川省遂宁市",
"861500510", "江苏省盐城市",
"86150659", "山东省临沂市",
"861476033", "福建省三明市",
"861519960", "新疆阿克苏地区",
"861324217", "广东省江门市",
"86182479", "内蒙古锡林郭勒盟",
"861340815", "四川省遂宁市",
"861302726", "江西省九江市",
"861504712", "内蒙古鄂尔多斯市",
"861773486", "河南省平顶山市",
"861807579", "湖南省永州市",
"86139292", "广东省东莞市",
"861880744", "湖南省张家界市",
"861479499", "内蒙古鄂尔多斯市",
"861589445", "云南省西双版纳傣族自治州",
"861833955", "河南省漯河市",
"861379381", "山东省泰安市",
"86182126", "贵州省毕节地区",
"861865613", "安徽省合肥市",
"861521964", "广东省云浮市",
"86139781", "广西南宁市",
"861552690", "吉林省辽源市",
"86184737", "湖南省益阳市",
"861501733", "广东省中山市",
"861890252", "广东省阳江市",
"861569241", "广东省广州市",
"861302176", "山东省德州市",
"86187332", "河北省保定市",
"861870638", "山东省泰安市",
"861564881", "内蒙古赤峰市",
"861528441", "云南省昆明市",
"861815894", "安徽省宣城市",
"861364875", "云南省保山市",
"861477882", "广东省惠州市",
"861889904", "新疆昌吉回族自治州",
"861881988", "广东省阳江市",
"861452778", "广西河池市",
"861346968", "宁夏银川市",
"861309462", "浙江省绍兴市",
"861820095", "广东省梅州市",
"861513428", "辽宁省葫芦岛市",
"86182308", "贵州省毕节地区",
"86157329", "河北省邢台市",
"861370271", "广东省江门市",
"861873994", "河南省郑州市",
"861808141", "四川省成都市",
"861780774", "广西梧州市",
"861308844", "内蒙古包头市",
"861707549", "福建省泉州市",
"861315463", "四川省自贡市",
"861534531", "山东省济南市",
"861333311", "河北省石家庄市",
"861360345", "河南省郑州市",
"861817404", "江西省南昌市",
"861550535", "山东省烟台市",
"861322896", "西藏那曲地区",
"861815106", "江苏省扬州市",
"861321973", "四川省眉山市",
"861329021", "山东省临沂市",
"861505509", "安徽省淮北市",
"861333966", "贵州省铜仁地区",
"86182605", "江苏省南通市",
"861506342", "山东省莱芜市",
"861851572", "四川省泸州市",
"861559017", "吉林省白城市",
"861329591", "福建省福州市",
"861846466", "山东省东营市",
"861572759", "江西省抚州市",
"861866677", "广东省肇庆市",
"861522978", "陕西省汉中市",
"861709544", "江苏省苏州市",
"861337710", "广西防城港市",
"861308568", "浙江省绍兴市",
"86181261", "广东省深圳市",
"861538688", "山西省太原市",
"861535933", "福建省厦门市",
"861815482", "新疆乌鲁木齐市",
"86131914", "内蒙古包头市",
"861335092", "四川省巴中市",
"861780667", "广东省珠海市",
"861820525", "江苏省扬州市",
"861809483", "新疆克拉玛依市",
"861800072", "江西省九江市",
"861331437", "吉林省吉林市",
"861390727", "湖北省襄樊市",
"861563630", "黑龙江省哈尔滨市",
"861567845", "广西贵港市",
"861562716", "广东省湛江市",
"861865994", "福建省泉州市",
"861364722", "湖北省武汉市",
"861314975", "辽宁省阜新市",
"861858340", "四川省雅安市",
"861840334", "河北省秦皇岛市",
"861532363", "广东省珠海市",
"861806113", "江苏省徐州市",
"861452136", "河北省沧州市",
"861800823", "四川省泸州市",
"861337755", "广东省深圳市",
"861319253", "广东省汕尾市",
"861831927", "广东省湛江市",
"861866081", "山东省济南市",
"861343194", "广东省珠海市",
"86156258", "广东省东莞市",
"861500761", "广东省中山市",
"861558186", "山西省晋城市",
"861820793", "江西省上饶市",
"86794", "江西省抚州市",
"861571234", "辽宁省沈阳市",
"861390859", "贵州省黔西南布依族苗族自治州",
"861302738", "湖南省娄底市",
"861535048", "江西省宜春市",
"86147172", "吉林省长春市",
"861332374", "河南省许昌市",
"86186532", "山东省青岛市",
"861517738", "广西河池市",
"861303860", "云南省迪庆藏族自治州",
"861809574", "青海省海南藏族自治州",
"861596906", "云南省文山壮族苗族自治州",
"861477185", "湖北省仙桃市",
"861324319", "河南省平顶山市",
"861760518", "江苏省连云港市",
"861358941", "山东省滨州市",
"86184567", "安徽省阜阳市",
"861328902", "新疆哈密地区",
"861529856", "江苏省盐城市",
"861829506", "宁夏中卫市",
"861572827", "广东省阳江市",
"86150670", "浙江省金华市",
"86152485", "内蒙古兴安盟",
"86182450", "黑龙江省哈尔滨市",
"861577917", "江西省吉安市",
"861766647", "广东省中山市",
"86184560", "安徽省阜阳市",
"861352991", "云南省红河哈尼族彝族自治州",
"861358299", "河北省保定市",
"861871749", "陕西省铜川市",
"861450952", "江苏省连云港市",
"861809504", "四川省自贡市",
"861818000", "四川省雅安市",
"861596976", "山东省德州市",
"86131092", "陕西省榆林市",
"861806470", "浙江省湖州市",
"861510730", "湖南省岳阳市",
"861332682", "广东省江门市",
"861361430", "吉林省长春市",
"861533637", "山东省枣庄市",
"861353673", "广东省梅州市",
"86182457", "黑龙江省大庆市",
"86150677", "浙江省温州市",
"86170863", "山东省临沂市",
"861773722", "河南省漯河市",
"86130561", "江苏省盐城市",
"861538511", "安徽省马鞍山市",
"861387246", "湖北省宜昌市",
"861836670", "山东省枣庄市",
"861313270", "广西河池市",
"861589982", "广东省佛山市",
"861332304", "河北省石家庄市",
"86138788", "广西南宁市",
"861367717", "湖北省宜昌市",
"86186729", "湖北省武汉市",
"86150612", "江苏省淮安市",
"861812252", "广东省河源市",
"861311636", "贵州省六盘水市",
"861551403", "河南省开封市",
"861362959", "宁夏银川市",
"861893961", "河南省周口市",
"861890323", "河北省张家口市",
"861361321", "河北省石家庄市",
"861858195", "四川省成都市",
"861516088", "新疆乌鲁木齐市",
"861329451", "山西省太原市",
"861344784", "广西钦州市",
"861336878", "云南省楚雄彝族自治州",
"86182642", "山东省枣庄市",
"861314905", "广东省韶关市",
"86156732", "湖南省湘潭市",
"861771129", "四川省成都市",
"861310394", "河南省周口市",
"861343876", "四川省南充市",
"861340012", "河北省保定市",
"861771779", "河北省沧州市",
"861819479", "青海省西宁市",
"861852906", "广东省深圳市",
"861531860", "山东省淄博市",
"861772219", "广东省湛江市",
"861478520", "贵州省黔南布依族苗族自治州",
"861356224", "山东省枣庄市",
"861350237", "广东省梅州市",
"86136611", "北京市",
"861770780", "广西防城港市",
"86137626", "湖南省常德市",
"861896690", "陕西省西安市",
"861325261", "吉林省长春市",
"861505579", "安徽省芜湖市",
"86181119", "贵州省贵阳市",
"86156562", "安徽省铜陵市",
"86155643", "山东省滨州市",
"861865142", "江苏省南通市",
"861570467", "黑龙江省鸡西市",
"861815176", "江苏省镇江市",
"861328846", "广东省广州市",
"861364486", "内蒙古赤峰市",
"861359843", "河南省郑州市",
"861344061", "河北省邯郸市",
"861570326", "河北省廊坊市",
"861889974", "广东省东莞市",
"861328339", "河北省承德市",
"861370587", "浙江省温州市",
"861312727", "山东省泰安市",
"861804090", "新疆乌鲁木齐市",
"861802191", "江苏省淮安市",
"861815945", "福建省龙岩市",
"861872418", "江苏省宿迁市",
"861333733", "湖南省株洲市",
"861539383", "云南省西双版纳傣族自治州",
"861536543", "江苏省徐州市",
"86184730", "湖南省岳阳市",
"861848356", "四川省雅安市",
"861520752", "广东省惠州市",
"861454356", "山东省枣庄市",
"861814888", "广东省阳江市",
"861503368", "河北省沧州市",
"861322174", "浙江省舟山市",
"861522491", "河南省驻马店市",
"861347519", "山东省德州市",
"861873845", "河南省驻马店市",
"861345117", "湖北省荆门市",
"861787621", "广东省茂名市",
"861450314", "河北省承德市",
"861305323", "安徽省宣城市",
"861308995", "黑龙江省绥化市",
"861345834", "四川省巴中市",
"861330264", "广东省东莞市",
"86130731", "河北省石家庄市",
"86158038", "河南省郑州市",
"861515404", "山东省威海市",
"861558640", "湖北省襄樊市",
"86151815", "四川省凉山彝族自治州",
"86518", "江苏省连云港市",
"861858892", "广东省广州市",
"861322724", "湖北省十堰市",
"861507859", "广西河池市",
"861338447", "吉林省长春市",
"861585570", "安徽省宿州市",
"86159802", "福建省福州市",
"861562678", "广东省汕头市",
"86134161", "广东省广州市",
"861533798", "新疆伊犁哈萨克自治州",
"86177897", "海南省海口市",
"86183140", "云南省红河哈尼族彝族自治州",
"861300406", "安徽省芜湖市",
"861786617", "甘肃省天水市",
"861508045", "福建省福州市",
"861314534", "山东省德州市",
"861827069", "江西省九江市",
"861780548", "山东省泰安市",
"861320474", "内蒙古乌兰察布市",
"86132317", "河北省沧州市",
"861829781", "安徽省淮北市",
"861575110", "江苏省盐城市",
"861308647", "四川省眉山市",
"861330606", "福建省漳州市",
"86180160", "上海市",
"861840416", "辽宁省锦州市",
"861843423", "山西省长治市",
"861477307", "湖南省益阳市",
"861452544", "山东省济南市",
"861805238", "江苏省淮安市",
"861539027", "四川省绵阳市",
"861303120", "新疆吐鲁番地区",
"861351931", "甘肃省兰州市",
"86151627", "江苏省南通市",
"861816974", "广西贵港市",
"86130389", "陕西省榆林市",
"861809935", "新疆昌吉回族自治州",
"86139944", "山西省大同市",
"861362490", "辽宁省铁岭市",
"861899109", "陕西省榆林市",
"861368384", "河南省洛阳市",
"861776932", "湖南省长沙市",
"861310477", "广东省东莞市",
"861320583", "浙江省嘉兴市",
"861309425", "湖北省武汉市",
"86155793", "江西省上饶市",
"861572167", "山西省临汾市",
"861857234", "湖北省恩施土家族苗族自治州",
"86153857", "安徽省宿州市",
"861593136", "河北省衡水市",
"861837876", "广西南宁市",
"861831245", "广东省深圳市",
"861324537", "山东省聊城市",
"861523317", "河北省沧州市",
"861335565", "安徽省巢湖市",
"861336046", "广东省东莞市",
"861786278", "山东省日照市",
"861894735", "内蒙古通辽市",
"861830691", "云南省西双版纳傣族自治州",
"861305087", "辽宁省盘锦市",
"861529229", "湖南省湘潭市",
"861340460", "吉林省四平市",
"86159636", "山东省潍坊市",
"8614711", "四川省成都市",
"861537496", "内蒙古通辽市",
"861880578", "浙江省丽水市",
"861303770", "四川省攀枝花市",
"861339625", "山东省聊城市",
"861335471", "内蒙古呼和浩特市",
"861863502", "山西省忻州市",
"861800491", "辽宁省朝阳市",
"861815697", "安徽省马鞍山市",
"86187894", "陕西省西安市",
"861370652", "浙江省湖州市",
"861894948", "安徽省滁州市",
"86150137", "广东省深圳市",
"86185938", "贵州省贵阳市",
"86182792", "江西省九江市",
"861390238", "广东省广州市",
"86189155", "江苏省苏州市",
"86159180", "广东省佛山市",
"861809748", "青海省海东地区",
"861886479", "河南省焦作市",
"861380315", "河北省唐山市",
"86182281", "四川省眉山市",
"861561664", "湖南省衡阳市",
"861859239", "陕西省宝鸡市",
"861876836", "浙江省湖州市",
"861895406", "山东省济宁市",
"861584707", "内蒙古鄂尔多斯市",
"861505900", "福建省三明市",
"861318180", "山东省泰安市",
"861888083", "四川省绵阳市",
"861820562", "安徽省铜陵市",
"861380350", "江西省南昌市",
"861571080", "广东省深圳市",
"861539597", "福建省龙岩市",
"861760469", "黑龙江省双鸭山市",
"861707940", "河南省洛阳市",
"861589088", "河南省南阳市",
"861569450", "黑龙江省哈尔滨市",
"861800908", "四川省绵阳市",
"861550974", "青海省海南藏族自治州",
"86185027", "湖北省武汉市",
"861336923", "陕西省汉中市",
"861890087", "广东省佛山市",
"861452868", "青海省西宁市",
"86181213", "上海市",
"861768398", "湖北省咸宁市",
"861589211", "福建省宁德市",
"861829064", "新疆乌鲁木齐市",
"861880951", "宁夏银川市",
"86134814", "广西梧州市",
"861300182", "河北省秦皇岛市",
"861569415", "辽宁省丹东市",
"861587112", "湖北省十堰市",
"861522002", "广东省广州市",
"86135505", "四川省眉山市",
"86159859", "福建省泉州市",
"861554140", "辽宁省本溪市",
"861552041", "四川省南充市",
"86151465", "黑龙江省绥化市",
"861475607", "河北省廊坊市",
"861853920", "河南省鹤壁市",
"861519656", "四川省雅安市",
"861452616", "江苏省苏州市",
"861361673", "浙江省嘉兴市",
"861453730", "湖南省株洲市",
"861890671", "浙江省杭州市",
"861454409", "福建省龙岩市",
"861321349", "河南省濮阳市",
"861395551", "安徽省池州市",
"861839199", "陕西省铜川市",
"861522072", "广东省惠州市",
"861342820", "广东省汕尾市",
"86134219", "广东省东莞市",
"86152592", "福建省厦门市",
"861454479", "陕西省铜川市",
"861530391", "河南省濮阳市",
"861325730", "湖南省岳阳市",
"861576921", "陕西省宝鸡市",
"861577502", "广东省茂名市",
"861569590", "福建省福州市",
"861805385", "山东省青岛市",
"861479950", "新疆阿克苏地区",
"861550904", "新疆和田地区",
"86136016", "上海市",
"861363464", "黑龙江省双鸭山市",
"861566554", "安徽省淮南市",
"86185020", "广东省广州市",
"86147806", "四川省凉山彝族自治州",
"861597406", "湖南省永州市",
"861773765", "河南省信阳市",
"861800978", "青海省西宁市",
"861316019", "江苏省盐城市",
"861870797", "江西省赣州市",
"861769914", "新疆喀什地区",
"86189666", "陕西省西安市",
"861335998", "黑龙江省哈尔滨市",
"86137021", "天津市",
"861323631", "江苏省连云港市",
"861479915", "新疆昌吉回族自治州",
"861317525", "浙江省绍兴市",
"861898750", "云南省保山市",
"861595104", "江苏省扬州市",
"861529699", "宁夏中卫市",
"861862378", "河南省开封市",
"86189149", "江苏省苏州市",
"861457015", "山东省威海市",
"86147632", "山东省枣庄市",
"861392477", "广东省汕头市",
"861895476", "山东省菏泽市",
"861584777", "内蒙古呼和浩特市",
"861533117", "辽宁省辽阳市",
"861700948", "重庆市",
"861591790", "广东省汕头市",
"861339295", "广东省珠海市",
"861317793", "江西省上饶市",
"861897174", "湖北省黄冈市",
"861533834", "广东省佛山市",
"861804641", "福建省福州市",
"861551630", "河南省三门峡市",
"86170811", "北京市",
"861815227", "甘肃省庆阳市",
"861390696", "福建省漳州市",
"86150130", "广东省广州市",
"861457050", "新疆乌鲁木齐市",
"861478641", "湖南省张家界市",
"861350736", "湖南省常德市",
"861539457", "福建省三明市",
"861347337", "河北省石家庄市",
"86138614", "江苏省无锡市",
"861850445", "吉林省通化市",
"86159187", "广东省广州市",
"861863893", "河南省郑州市",
"861834441", "广东省云浮市",
"861311116", "山西省晋城市",
"861580858", "贵州省六盘水市",
"861887570", "河北省衡水市",
"861303700", "山西省忻州市",
"861880508", "福建省三明市",
"861304439", "吉林省白山市",
"861584664", "黑龙江省绥化市",
"861898013", "四川省绵阳市",
"861347468", "陕西省西安市",
"861867260", "湖北省荆门市",
"861318646", "江苏省连云港市",
"861503149", "河北省石家庄市",
"861572294", "江苏省淮安市",
"861875893", "浙江省金华市",
"86150686", "浙江省台州市",
"861362550", "安徽省滁州市",
"861813546", "山西省太原市",
"861899179", "陕西省延安市",
"861368440", "四川省内江市",
"861334639", "山东省青岛市",
"861450428", "辽宁省大连市",
"86151620", "江苏省徐州市",
"861575473", "内蒙古乌海市",
"861816904", "宁夏石嘴山市",
"861800551", "安徽省合肥市",
"861570009", "浙江省杭州市",
"861535267", "新疆吐鲁番地区",
"861362515", "江苏省淮安市",
"861527694", "新疆喀什地区",
"861590371", "河南省郑州市",
"861310407", "黑龙江省哈尔滨市",
"86183885", "云南省曲靖市",
"861305601", "江苏省淮安市",
"86153850", "安徽省滁州市",
"861837806", "广西玉林市",
"861537556", "安徽省安庆市",
"861350728", "湖北省襄樊市",
"86155968", "陕西省西安市",
"861322659", "广东省清远市",
"861330676", "浙江省台州市",
"86180167", "福建省泉州市",
"861861529", "山东省菏泽市",
"861597182", "湖北省恩施土家族苗族自治州",
"861317095", "江西省宜春市",
"861337891", "湖南省长沙市",
"86189013", "北京市",
"861805696", "安徽省滁州市",
"861375464", "山东省威海市",
"861302697", "广西钦州市",
"861458594", "山东省泰安市",
"861861364", "山东省日照市",
"861319365", "河南省南阳市",
"861315086", "内蒙古鄂尔多斯市",
"861532255", "广东省汕头市",
"861576649", "广东省深圳市",
"861336768", "广西河池市",
"861380031", "河北省邯郸市",
"86153189", "山东省潍坊市",
"861567133", "湖北省襄樊市",
"861300476", "浙江省台州市",
"861763542", "山西省晋中市",
"861377259", "陕西省咸阳市",
"861309753", "山西省晋中市",
"861558521", "贵州省遵义市",
"861562608", "广东省韶关市",
"861332497", "云南省德宏傣族景颇族自治州",
"861501742", "广东省佛山市",
"861771283", "江苏省镇江市",
"861899857", "广东省肇庆市",
"861813993", "甘肃省庆阳市",
"861787540", "广东省汕头市",
"86132310", "河北省邯郸市",
"861320404", "辽宁省沈阳市",
"861532210", "广东省江门市",
"861394953", "河南省安阳市",
"861761426", "辽宁省大连市",
"861555524", "安徽省宣城市",
"86159863", "广东省广州市",
"861323451", "黑龙江省哈尔滨市",
"861806593", "福建省宁德市",
"86189431", "吉林省长春市",
"861327212", "湖南省株洲市",
"86155879", "湖北省宜昌市",
"86157556", "安徽省安庆市",
"861555369", "山东省烟台市",
"86427", "辽宁省盘锦市",
"861344790", "陕西省宝鸡市",
"861826895", "浙江省衢州市",
"861847625", "广东省肇庆市",
"861899961", "新疆巴音郭楞蒙古自治州",
"861326481", "湖北省黄冈市",
"861519058", "江苏省苏州市",
"861879142", "陕西省榆林市",
"86137548", "山西省太原市",
"861813479", "河南省洛阳市",
"861372612", "广东省中山市",
"861867375", "湖南省郴州市",
"861310380", "河南省新乡市",
"861587763", "陕西省安康市",
"861329111", "江苏省南通市",
"86152050", "福建省福州市",
"861822641", "安徽省蚌埠市",
"861477344", "湖南省衡阳市",
"861819817", "贵州省毕节地区",
"861452507", "山东省威海市",
"861452281", "山西省太原市",
"861314913", "陕西省渭南市",
"861882911", "陕西省延安市",
"861328676", "广东省梅州市",
"861888219", "四川省眉山市",
"861450656", "黑龙江省鹤岗市",
"861882366", "广东省深圳市",
"861332986", "湖北省襄樊市",
"861312528", "江西省景德镇市",
"861767345", "湖南省岳阳市",
"861370788", "广西南宁市",
"861596440", "山东省菏泽市",
"861308382", "河南省新乡市",
"861806946", "浙江省湖州市",
"861311932", "甘肃省定西市",
"861509437", "江苏省扬州市",
"861319270", "广东省河源市",
"861575999", "福建省南平市",
"86189674", "浙江省金华市",
"861343514", "广东省韶关市",
"861319831", "四川省达州市",
"861338404", "河南省郑州市",
"861811422", "江苏省南通市",
"861810981", "辽宁省朝阳市",
"861339035", "辽宁省本溪市",
"861879845", "贵州省六盘水市",
"861576769", "广东省茂名市",
"861818710", "云南省昆明市",
"861313322", "山西省大同市",
"861475644", "河北省承德市",
"861312536", "江西省赣州市",
"861874285", "新疆巴音郭楞蒙古自治州",
"861473559", "山西省长治市",
"861808363", "贵州省遵义市",
"861813248", "河北省唐山市",
"861533383", "河南省郑州市",
"861563999", "河南省平顶山市",
"861524095", "云南省大理白族自治州",
"861454546", "新疆伊犁哈萨克自治州",
"861306448", "河南省平顶山市",
"861389779", "青海省海南藏族自治州",
"861830531", "山东省济南市",
"861321950", "四川省宜宾市",
"861341841", "广东省佛山市",
"861476589", "新疆乌鲁木齐市",
"861786506", "山东省临沂市",
"86180883", "云南省临沧市",
"861537258", "浙江省杭州市",
"861848546", "贵州省黔东南苗族侗族自治州",
"861826192", "江苏省南京市",
"861364813", "四川省眉山市",
"861770794", "江西省抚州市",
"861360495", "辽宁省丹东市",
"861318766", "云南省楚雄彝族自治州",
"861356146", "山东省聊城市",
"861761438", "吉林省松原市",
"861392444", "广东省揭阳市",
"861339733", "湖南省株洲市",
"86156356", "山西省晋城市",
"861806872", "江苏省徐州市",
"861869421", "河北省保定市",
"861865675", "安徽省合肥市",
"861559777", "贵州省黔南布依族苗族自治州",
"861322439", "吉林省白山市",
"861340702", "江西省九江市",
"861369931", "新疆和田地区",
"86158327", "河北省沧州市",
"861560257", "广东省湛江市",
"861556981", "甘肃省天水市",
"861860881", "云南省西双版纳傣族自治州",
"861804084", "新疆伊犁哈萨克自治州",
"861896302", "山东省青岛市",
"861824086", "陕西省汉中市",
"861340772", "广西南宁市",
"86182908", "新疆乌鲁木齐市",
"861880867", "湖北省襄樊市",
"861315688", "山东省青岛市",
"861506552", "山东省聊城市",
"861559707", "青海省海东地区",
"861896372", "安徽省亳州市",
"861554088", "内蒙古包头市",
"861818423", "贵州省遵义市",
"861360555", "安徽省马鞍山市",
"861510888", "云南省丽江市",
"86158320", "河北省邯郸市",
"861598721", "云南省楚雄彝族自治州",
"861582666", "湖北省恩施土家族苗族自治州",
"861339966", "安徽省池州市",
"86188438", "吉林省松原市",
"86181151", "江苏省南京市",
"861342287", "广东省深圳市",
"861458634", "湖北省襄樊市",
"861889386", "甘肃省酒泉市",
"861340122", "江苏省泰州市",
"861886546", "山东省东营市",
"861598171", "新疆塔城地区",
"86136659", "福建省泉州市",
"861360510", "江苏省盐城市",
"861311309", "广东省东莞市",
"861302537", "广东省韶关市",
"861339311", "河北省石家庄市",
"861579731", "湖北省宜昌市",
"86159461", "黑龙江省绥化市",
"861595147", "江苏省淮安市",
"861390528", "江苏省镇江市",
"861770826", "广东省中山市",
"861527534", "山东省德州市",
"861839955", "新疆阿克苏地区",
"861886993", "浙江省金华市",
"861599616", "江苏省淮安市",
"861366969", "广西玉林市",
"861708560", "安徽省六安市",
"861389709", "青海省海西蒙古族藏族自治州",
"861373799", "广西河池市",
"861334599", "浙江省宁波市",
"861550947", "甘肃省嘉峪关市",
"861589140", "陕西省咸阳市",
"861367681", "浙江省金华市",
"861859364", "福建省厦门市",
"86132535", "河南省郑州市",
"861347199", "广西梧州市",
"861839910", "新疆喀什地区",
"86632", "山东省枣庄市",
"86187932", "甘肃省定西市",
"861815880", "安徽省芜湖市",
"861859529", "山东省泰安市",
"86156168", "湖南省郴州市",
"861554211", "辽宁省朝阳市",
"861308767", "陕西省咸阳市",
"861842038", "广东省揭阳市",
"861860566", "安徽省池州市",
"86150601", "福建省福州市",
"861857094", "湖南省衡阳市",
"861500520", "江苏省徐州市",
"861777201", "广西柳州市",
"861526886", "浙江省台州市",
"861324227", "广东省揭阳市",
"861859099", "陕西省铜川市",
"861343180", "广东省梅州市",
"86187756", "广西百色市",
"861340825", "四川省遂宁市",
"861596384", "山东省日照市",
"861560988", "辽宁省沈阳市",
"861338474", "内蒙古兴安盟",
"861390536", "山东省潍坊市",
"86152624", "江苏省苏州市",
"861896939", "浙江省金华市",
"861370432", "吉林省吉林市",
"86132765", "江苏省扬州市",
"861372143", "河南省郑州市",
"861842026", "广东省梅州市",
"861452577", "福建省泉州市",
"861308674", "广西百色市",
"861841992", "甘肃省定西市",
"861596602", "山东省泰安市",
"861871481", "安徽省合肥市",
"861550262", "辽宁省大连市",
"861365799", "江西省萍乡市",
"861390098", "辽宁省沈阳市",
"861470732", "湖南省湘潭市",
"86131314", "河北省承德市",
"861814730", "内蒙古乌海市",
"861561744", "河南省郑州市",
"861316869", "广东省珠海市",
"861813409", "河北省邢台市",
"861869051", "陕西省安康市",
"86147881", "河南省驻马店市",
"861331854", "广东省阳江市",
"861816947", "湖南省益阳市",
"86151443", "吉林省吉林市",
"861705659", "湖北省十堰市",
"861323591", "福建省福州市",
"861338583", "浙江省嘉兴市",
"861846219", "山东省烟台市",
"861781799", "广东省茂名市",
"861806453", "福建省三明市",
"861519436", "山东省烟台市",
"861839468", "甘肃省酒泉市",
"861894293", "湖北省武汉市",
"861886614", "山东省潍坊市",
"861364645", "山东省烟台市",
"861394579", "黑龙江省双鸭山市",
"861538463", "陕西省渭南市",
"861877999", "江西省宜春市",
"861803483", "新疆巴音郭楞蒙古自治州",
"861809816", "广东省佛山市",
"861865980", "福建省泉州市",
"861355751", "广西南宁市",
"861348831", "陕西省西安市",
"861576879", "广东省惠州市",
"861898703", "云南省昭通市",
"861539834", "云南省昭通市",
"861518401", "辽宁省大连市",
"861312144", "内蒙古鄂尔多斯市",
"861303010", "广东省韶关市",
"86133028", "广东省佛山市",
"861801286", "江苏省南通市",
"861580529", "江苏省镇江市",
"861503657", "河南省洛阳市",
"861311456", "黑龙江省黑河市",
"861847662", "广东省佛山市",
"861829278", "陕西省商洛市",
"861569473", "内蒙古乌海市",
"861599708", "青海省西宁市",
"86186703", "湖南省长沙市",
"861536487", "山西省临汾市",
"861330339", "河北省邢台市",
"861303055", "江西省新余市",
"861479903", "新疆吐鲁番地区",
"861454134", "河北省承德市",
"861454817", "广东省深圳市",
"861831792", "江西省九江市",
"861895940", "福建省宁德市",
"861355192", "四川省达州市",
"86131550", "安徽省滁州市",
"861364997", "新疆阿克苏地区",
"861775693", "安徽省宣城市",
"861384843", "内蒙古乌兰察布市",
"861586436", "山东省聊城市",
"861832045", "广东省惠州市",
"861390992", "新疆乌鲁木齐市",
"861336567", "安徽省亳州市",
"86170845", "黑龙江省大庆市",
"861889947", "新疆塔城地区",
"86181065", "浙江省杭州市",
"861815319", "贵州省黔西南布依族苗族自治州",
"861850140", "江苏省南京市",
"861318876", "山东省烟台市",
"861322147", "浙江省温州市",
"861825146", "江苏省扬州市",
"86159811", "吉林省吉林市",
"861334376", "河南省信阳市",
"861324482", "广东省广州市",
"861373254", "浙江省丽水市",
"861350527", "江苏省扬州市",
"861811571", "江苏省徐州市",
"861555148", "安徽省宿州市",
"861569584", "浙江省杭州市",
"861561508", "山东省烟台市",
"861388635", "湖北省孝感市",
"861457003", "山东省德州市",
"861524562", "黑龙江省佳木斯市",
"861376284", "湖南省娄底市",
"861380373", "河南省新乡市",
"861588037", "福建省龙岩市",
"861370443", "吉林省延边朝鲜族自治州",
"861880707", "江西省赣州市",
"861321559", "安徽省黄山市",
"861329631", "山东省威海市",
"861470743", "湖南省湘西土家族苗族自治州",
"861301597", "福建省莆田市",
"861811465", "江苏省徐州市",
"861369464", "黑龙江省牡丹江市",
"861844580", "黑龙江省伊春市",
"861301027", "山东省莱芜市",
"861804871", "四川省内江市",
"861355895", "四川省宜宾市",
"861313365", "江西省九江市",
"861874079", "陕西省铜川市",
"861590735", "湖南省郴州市",
"861534691", "甘肃省甘南藏族自治州",
"861330972", "青海省海东地区",
"861304724", "湖南省衡阳市",
"86357", "山西省临汾市",
"861550695", "福建省泉州市",
"86155368", "山西省太原市",
"861804230", "浙江省杭州市",
"861554982", "湖北省孝感市",
"861338397", "河南省信阳市",
"86178899", "海南省海口市",
"861378934", "湖南省张家界市",
"86852", "贵州省遵义市",
"861350097", "吉林省通化市",
"861832743", "湖北省恩施土家族苗族自治州",
"861593281", "江西省宜春市",
"861819993", "新疆石河子市",
"861357153", "陕西省渭南市",
"861520511", "江苏省盐城市",
"861593507", "山西省晋城市",
"861824463", "河北省张家口市",
"861564268", "辽宁省大连市",
"861855481", "山东省烟台市",
"861777652", "广西桂林市",
"86155665", "辽宁省锦州市",
"861504491", "内蒙古鄂尔多斯市",
"861878424", "四川省巴中市",
"861516140", "江苏省扬州市",
"86185846", "重庆市",
"861870598", "福建省三明市",
"861318942", "广东省江门市",
"861368976", "吉林省辽源市",
"861537346", "河北省邯郸市",
"861509149", "陕西省榆林市",
"86181454", "黑龙江省佳木斯市",
"861585553", "安徽省芜湖市",
"86188290", "陕西省西安市",
"861822090", "陕西省咸阳市",
"861877415", "湖南省湘潭市",
"861357405", "湖南省湘潭市",
"861572280", "江苏省泰州市",
"861800341", "山西省太原市",
"861811958", "安徽省宿州市",
"861309700", "江西省新余市",
"861471451", "广东省广州市",
"861779063", "黑龙江省齐齐哈尔市",
"861323240", "广东省江门市",
"86139939", "甘肃省陇南市",
"861453888", "云南省丽江市",
"861813356", "河北省唐山市",
"861362340", "山西省忻州市",
"86157775", "广西玉林市",
"86139706", "江西省吉安市",
"861479168", "陕西省咸阳市",
"861877450", "湖南省邵阳市",
"861774049", "河南省安阳市",
"861527680", "新疆克孜勒苏柯尔克孜自治州",
"861537839", "四川省南充市",
"861368390", "河南省南阳市",
"861571524", "江苏省宿迁市",
"86159413", "辽宁省抚顺市",
"861325888", "吉林省长春市",
"861362484", "内蒙古呼和浩特市",
"861850686", "浙江省嘉兴市",
"861599136", "陕西省咸阳市",
"86155156", "河南省郑州市",
"861303425", "浙江省金华市",
"861355944", "福建省福州市",
"86170802", "广东省深圳市",
"861552887", "四川省达州市",
"861870458", "黑龙江省伊春市",
"861520688", "山东省滨州市",
"861390144", "江苏省扬州市",
"861571369", "河南省郑州市",
"86130989", "海南省海口市",
"861357561", "浙江省舟山市",
"861307033", "新疆阿勒泰地区",
"861768209", "安徽省阜阳市",
"86189265", "广东省深圳市",
"861569852", "山西省长治市",
"861339742", "湖南省湘潭市",
"861361843", "湖南省株洲市",
"861890841", "湖南省常德市",
"861394970", "河南省濮阳市",
"861333625", "山东省聊城市",
"861384650", "黑龙江省黑河市",
"861471591", "广东省梅州市",
"861309770", "广西防城港市",
"861816225", "江西省九江市",
"861357475", "湖南省岳阳市",
"861700301", "广东省东莞市",
"86132917", "浙江省温州市",
"861316779", "安徽省六安市",
"861785843", "浙江省嘉兴市",
"861880664", "广东省深圳市",
"861452354", "河南省周口市",
"861362573", "浙江省嘉兴市",
"861884858", "贵州省黔东南苗族侗族自治州",
"861584508", "黑龙江省绥化市",
"861587803", "广西玉林市",
"861512948", "陕西省西安市",
"861539798", "江西省景德镇市",
"861324726", "湖北省十堰市",
"861458114", "安徽省宿州市",
"861804801", "四川省巴中市",
"861780358", "山西省吕梁市",
"86158818", "四川省达州市",
"861529930", "新疆吐鲁番地区",
"861324945", "广东省深圳市",
"861809547", "宁夏银川市",
"861515619", "安徽省淮北市",
"861575450", "黑龙江省哈尔滨市",
"861896530", "福建省三明市",
"861330902", "四川省德阳市",
"86186375", "河南省平顶山市",
"861880777", "广西钦州市",
"861569155", "陕西省安康市",
"861305841", "广东省广州市",
"861335232", "辽宁省阜新市",
"861308266", "山东省临沂市",
"861500641", "山东省济南市",
"861515447", "山东省潍坊市",
"861366560", "安徽省合肥市",
"861563450", "山东省济宁市",
"861772083", "福建省莆田市",
"861321499", "内蒙古呼伦贝尔市",
"861311943", "甘肃省兰州市",
"861362892", "西藏日喀则地区",
"861459730", "湖南省岳阳市",
"861308159", "内蒙古锡林郭勒盟",
"861513656", "河南省驻马店市",
"861859920", "新疆克拉玛依市",
"86186678", "浙江省宁波市",
"861328197", "四川省宜宾市",
"861334306", "河北省廊坊市",
"861581268", "广东省潮州市",
"861519952", "新疆阿勒泰地区",
"861839519", "宁夏银川市",
"861870965", "宁夏中卫市",
"861827380", "湖南省娄底市",
"861805144", "江苏省扬州市",
"861811287", "江苏省常州市",
"86134251", "广东省深圳市",
"861561578", "山东省泰安市",
"861527146", "湖北省宜昌市",
"861380540", "山东省济南市",
"861803748", "河南省郑州市",
"861311596", "福建省漳州市",
"861834789", "内蒙古巴彦淖尔市",
"861479973", "新疆乌鲁木齐市",
"86185338", "河北省唐山市",
"861857148", "湖北省武汉市",
"861370956", "宁夏石嘴山市",
"861770259", "江苏省徐州市",
"861850395", "河南省漯河市",
"861332758", "山西省吕梁市",
"861525444", "山东省淄博市",
"861808210", "江苏省镇江市",
"861818891", "湖南省常德市",
"861599128", "陕西省咸阳市",
"861318485", "广东省汕尾市",
"861374914", "河南省开封市",
"861868408", "四川省宜宾市",
"861311038", "陕西省汉中市",
"861576809", "广东省云浮市",
"861898773", "云南省玉溪市",
"861533597", "湖北省十堰市",
"861595439", "山东省枣庄市",
"861318194", "山东省淄博市",
"86170859", "福建省泉州市",
"861504978", "内蒙古乌海市",
"861569403", "四川省遂宁市",
"861821284", "贵州省六盘水市",
"86185635", "山东省聊城市",
"861359321", "山西省忻州市",
"861853239", "河北省保定市",
"861339615", "湖北省宜昌市",
"861572546", "山东省东营市",
"861571267", "浙江省台州市",
"861356808", "四川省宜宾市",
"861309450", "四川省达州市",
"86151399", "河南省洛阳市",
"861898802", "云南省丽江市",
"861814840", "四川省绵阳市",
"861813294", "河北省邢台市",
"861779908", "新疆克孜勒苏柯尔克孜自治州",
"861808372", "江苏省泰州市",
"861582950", "陕西省宝鸡市",
"861358139", "湖北省随州市",
"861351437", "吉林省辽源市",
"861531473", "浙江省台州市",
"86186713", "湖北省黄冈市",
"861800997", "新疆阿克苏地区",
"861831893", "广东省深圳市",
"861309415", "湖北省孝感市",
"861335977", "黑龙江省鹤岗市",
"861555933", "新疆昌吉回族自治州",
"86178537", "山东省济宁市",
"86155283", "四川省成都市",
"861523327", "河北省沧州市",
"861558688", "湖北省随州市",
"861870778", "广西河池市",
"861820959", "宁夏固原市",
"861323586", "浙江省台州市",
"861539017", "四川省广安市",
"861506171", "江苏省徐州市",
"861768307", "四川省阿坝藏族羌族自治州",
"861876666", "山东省枣庄市",
"861306494", "江苏省连云港市",
"861471701", "甘肃省临夏回族自治州",
"861592442", "内蒙古包头市",
"861501673", "广东省深圳市",
"86157740", "湖南省邵阳市",
"861582915", "陕西省渭南市",
"861859683", "福建省福州市",
"861365396", "河南省驻马店市",
"861575770", "浙江省杭州市",
"861862397", "河南省信阳市",
"861538853", "山西省阳泉市",
"86132371", "湖北省武汉市",
"86180633", "山东省日照市",
"861368743", "广东省佛山市",
"861843413", "山西省太原市",
"861340936", "河南省许昌市",
"861588137", "四川省宜宾市",
"861700589", "浙江省金华市",
"86187547", "山东省济宁市",
"861816203", "山东省济宁市",
"861770748", "湖南省娄底市",
"861313489", "内蒙古包头市",
"861338941", "甘肃省甘南藏族自治州",
"861301664", "广东省东莞市",
"861871496", "安徽省淮北市",
"861840426", "辽宁省盘锦市",
"861452638", "江苏省淮安市",
"86188534", "山东省德州市",
"861367385", "河南省周口市",
"861810370", "河南省商丘市",
"861571876", "云南省昆明市",
"861365900", "四川省内江市",
"861708342", "山西省大同市",
"861576057", "四川省南充市",
"861457103", "江苏省扬州市",
"861303403", "安徽省六安市",
"861572993", "新疆石河子市",
"86157589", "云南省德宏傣族景颇族自治州",
"861352374", "河南省许昌市",
"861775205", "甘肃省平凉市",
"861331464", "黑龙江省七台河市",
"861803166", "河北省秦皇岛市",
"86159801", "福建省福州市",
"86134162", "广东省广州市",
"86137069", "福建省福州市",
"861376610", "吉林省白城市",
"861786627", "湖北省咸宁市",
"861890260", "广东省东莞市",
"861322047", "甘肃省临夏回族自治州",
"861780634", "山东省莱芜市",
"861825046", "福建省福州市",
"861856985", "河南省郑州市",
"861560885", "云南省昆明市",
"861770935", "甘肃省武威市",
"861864940", "广西贵港市",
"861360871", "云南省昆明市",
"861452626", "江苏省南通市",
"861304074", "浙江省台州市",
"861840438", "吉林省松原市",
"861373900", "湖南省湘西土家族苗族自治州",
"861516040", "福建省泉州市",
"861508384", "江西省南昌市",
"861365685", "浙江省绍兴市",
"861301777", "浙江省嘉兴市",
"86132900", "重庆市",
"861860724", "湖北省咸宁市",
"861587122", "湖北省随州市",
"861569425", "辽宁省丹东市",
"861371998", "广东省梅州市",
"861340928", "河南省南阳市",
"861801303", "江苏省南京市",
"86180279", "广东省河源市",
"861808939", "甘肃省陇南市",
"861565087", "安徽省阜阳市",
"861892300", "广东省梅州市",
"861589221", "四川省自贡市",
"861811389", "四川省雅安市",
"861532690", "内蒙古包头市",
"861373396", "河南省漯河市",
"861308429", "河南省周口市",
"861508602", "贵州省贵阳市",
"861880457", "黑龙江省大兴安岭地区",
"861303852", "陕西省商洛市",
"861811791", "四川省成都市",
"861591493", "广东省揭阳市",
"86138430", "吉林省长春市",
"861889391", "甘肃省兰州市",
"861770357", "山西省临汾市",
"861521937", "广东省揭阳市",
"861311706", "湖北省荆门市",
"861560406", "辽宁省锦州市",
"861477398", "湖南省常德市",
"861305260", "辽宁省朝阳市",
"861889789", "广西柳州市",
"861554531", "黑龙江省牡丹江市",
"861364341", "山西省太原市",
"861885702", "浙江省衢州市",
"861530535", "山东省烟台市",
"861550203", "广东省深圳市",
"861898453", "贵州省安顺市",
"86182791", "江西省南昌市",
"861533707", "甘肃省甘南藏族自治州",
"861824091", "新疆伊犁哈萨克自治州",
"861380325", "河北省沧州市",
"86170870", "广西桂林市",
"861332478", "广西河池市",
"861504063", "辽宁省大连市",
"86182282", "四川省资阳市",
"86184573", "浙江省嘉兴市",
"861781685", "浙江省杭州市",
"861470976", "青海省海西蒙古族藏族自治州",
"861351368", "山西省晋中市",
"861867601", "广东省中山市",
"86170877", "江苏省盐城市",
"86138084", "湖南省长沙市",
"861315870", "四川省达州市",
"861535080", "河北省衡水市",
"861311126", "山西省晋城市",
"861533777", "安徽省黄山市",
"861898593", "贵州省六盘水市",
"861453433", "辽宁省铁岭市",
"86158564", "安徽省六安市",
"861592985", "陕西省延安市",
"861315231", "陕西省咸阳市",
"861885122", "江苏省常州市",
"861470906", "新疆阿勒泰地区",
"861380286", "广东省惠州市",
"861569753", "广东省梅州市",
"861311776", "广西百色市",
"861560476", "内蒙古赤峰市",
"861533127", "山东省济南市",
"861302608", "安徽省马鞍山市",
"861512133", "贵州省安顺市",
"861813624", "江苏省扬州市",
"861390044", "福建省福州市",
"86131579", "浙江省金华市",
"861514222", "辽宁省鞍山市",
"86170812", "天津市",
"861815217", "甘肃省白银市",
"861339843", "四川省广安市",
"861361742", "湖南省常德市",
"861334869", "湖南省长沙市",
"861330237", "广东省云浮市",
"861550273", "湖北省孝感市",
"8613533", "广东省广州市",
"861868758", "云南省保山市",
"861318369", "四川省内江市",
"861457025", "江西省宜春市",
"861883441", "山西省忻州市",
"86147631", "山东省威海市",
"861773341", "河北省秦皇岛市",
"861479925", "新疆伊犁哈萨克自治州",
"861814392", "河南省鹤壁市",
"861317515", "浙江省宁波市",
"86147474", "内蒙古兴安盟",
"86157313", "河北省张家口市",
"861570434", "吉林省四平市",
"861479746", "山西省运城市",
"861379446", "广东省深圳市",
"861310498", "广东省茂名市",
"86138437", "吉林省辽源市",
"861350264", "广东省河源市",
"86158808", "福建省泉州市",
"861587702", "广西桂林市",
"86137444", "吉林省吉林市",
"861769924", "新疆巴音郭楞蒙古自治州",
"861450960", "新疆博尔塔拉蒙古自治州",
"86137022", "广东省江门市",
"861396604", "安徽省蚌埠市",
"86152591", "福建省福州市",
"861399542", "宁夏石嘴山市",
"861576911", "陕西省延安市",
"861858388", "四川省凉山彝族自治州",
"861898946", "浙江省杭州市",
"861823627", "河南省信阳市",
"861880597", "福建省龙岩市",
"861898725", "云南省昆明市",
"861317550", "浙江省金华市",
"861328527", "江苏省宿迁市",
"861366333", "河北省张家口市",
"86180874", "云南省曲靖市",
"861556543", "河南省新乡市",
"861538472", "内蒙古包头市",
"861342810", "广东省湛江市",
"861301707", "贵州省六盘水市",
"861815678", "安徽省亳州市",
"861894589", "黑龙江省伊春市",
"861805044", "福建省福州市",
"861303473", "内蒙古乌海市",
"861871556", "安徽省安庆市",
"861369657", "安徽省黄山市",
"861569010", "河北省邯郸市",
"861886034", "河南省焦作市",
"861520760", "广东省中山市",
"861879948", "新疆伊犁哈萨克自治州",
"861810996", "新疆巴音郭楞蒙古自治州",
"861896363", "江苏省南京市",
"861308059", "湖南省益阳市",
"861775275", "湖南省郴州市",
"861772856", "广东省湛江市",
"861378851", "广西南宁市",
"861398448", "贵州省六盘水市",
"861316599", "浙江省杭州市",
"861553637", "山西省晋中市",
"861362793", "江西省上饶市",
"861772183", "四川省成都市",
"861528695", "河南省安阳市",
"86136130", "广东省深圳市",
"861367226", "江西省九江市",
"861882769", "湖北省黄石市",
"861868347", "四川省德阳市",
"861857933", "江西省上饶市",
"861452296", "山西省太原市",
"861575700", "浙江省杭州市",
"861327532", "山东省青岛市",
"861338299", "江苏省镇江市",
"861332991", "湖北省孝感市",
"861885825", "浙江省宁波市",
"861319741", "湖北省咸宁市",
"861861519", "山东省济南市",
"86189683", "浙江省宁波市",
"861891452", "江苏省泰州市",
"86187540", "山东省菏泽市",
"861539578", "浙江省丽水市",
"861323861", "云南省西双版纳傣族自治州",
"861870708", "江西省景德镇市",
"861571485", "内蒙古通辽市",
"861335907", "安徽省宿州市",
"861362525", "江苏省宿迁市",
"86178530", "山东省菏泽市",
"861571194", "广东省广州市",
"861326496", "湖北省荆门市",
"861381341", "江苏省盐城市",
"861450418", "辽宁省阜新市",
"861318094", "吉林省长春市",
"86131696", "广东省珠海市",
"861583188", "河北省沧州市",
"861598492", "四川省德阳市",
"86158734", "湖南省衡阳市",
"861768377", "湖北省随州市",
"861898872", "广东省东莞市",
"861310901", "新疆昌吉回族自治州",
"861804919", "陕西省铜川市",
"861592600", "湖北省鄂州市",
"861356878", "四川省阿坝藏族羌族自治州",
"861760992", "新疆伊犁哈萨克自治州",
"861877120", "湖北省恩施土家族苗族自治州",
"861857048", "湖南省湘潭市",
"861875245", "江苏省宿迁市",
"861531403", "山东省威海市",
"861898023", "四川省自贡市",
"861810543", "山东省滨州市",
"861527046", "江西省吉安市",
"86130258", "广东省江门市",
"861818153", "四川省乐山市",
"861360761", "河南省信阳市",
"861329011", "山东省淄博市",
"861327996", "新疆巴音郭楞蒙古自治州",
"861705566", "山东省济南市",
"86157697", "天津市",
"861876274", "江苏省连云港市",
"861880383", "河南省平顶山市",
"861839239", "陕西省西安市",
"861333321", "河北省石家庄市",
"86134223", "广东省广州市",
"861330963", "安徽省芜湖市",
"86131746", "福建省漳州市",
"861519158", "陕西省西安市",
"861770574", "浙江省宁波市",
"861563860", "河南省信阳市",
"861513418", "辽宁省锦州市",
"861327300", "河南省周口市",
"861320378", "河南省南阳市",
"861787588", "广东省茂名市",
"861518944", "江苏省南通市",
"86150246", "浙江省丽水市",
"861818886", "广东省佛山市",
"861458358", "山东省济南市",
"86151758", "河北省衡水市",
"861810532", "山东省青岛市",
"86138996", "新疆昌吉回族自治州",
"861802760", "广东省茂名市",
"861780837", "四川省阿坝藏族羌族自治州",
"861340452", "吉林省通化市",
"861472982", "陕西省榆林市",
"86187331", "河北省石家庄市",
"861869563", "福建省厦门市",
"861588278", "四川省绵阳市",
"861389599", "黑龙江省齐齐哈尔市",
"861768882", "广东省深圳市",
"861760536", "山东省潍坊市",
"861889273", "四川省广安市",
"861334709", "内蒙古包头市",
"861373509", "浙江省衢州市",
"861870544", "山东省潍坊市",
"861774437", "四川省德阳市",
"86186761", "广东省中山市",
"861857942", "广西柳州市",
"86139291", "广东省佛山市",
"861528947", "陕西省西安市",
"861848280", "四川省遂宁市",
"861327543", "山东省滨州市",
"861397190", "湖北省十堰市",
"86139782", "广西柳州市",
"861865623", "安徽省铜陵市",
"861599922", "新疆阿克苏地区",
"861770483", "内蒙古阿拉善盟",
"861590613", "江苏省苏州市",
"861504722", "内蒙古包头市",
"861827901", "江西省宜春市",
"861324848", "浙江省金华市",
"861454280", "辽宁省沈阳市",
"861866236", "江苏省扬州市",
"86183027", "湖北省武汉市",
"861301276", "山东省德州市",
"861530974", "青海省海南藏族自治州",
"861368488", "江西省景德镇市",
"861873623", "河南省周口市",
"861857267", "湖北省荆门市",
"861572817", "广东省东莞市",
"861855556", "安徽省安庆市",
"861847673", "广东省湛江市",
"861569462", "云南省丽江市",
"861870616", "江苏省无锡市",
"861760528", "江苏省扬州市",
"861525558", "安徽省阜阳市",
"861324329", "河南省新乡市",
"861870868", "贵州省六盘水市",
"861524195", "辽宁省辽阳市",
"86147227", "四川省成都市",
"861846930", "云南省玉溪市",
"861524484", "四川省眉山市",
"861831330", "云南省文山壮族苗族自治州",
"861399533", "宁夏吴忠市",
"861860659", "浙江省宁波市",
"86186531", "山东省济南市",
"861500345", "山西省长治市",
"861844747", "内蒙古乌兰察布市",
"861388713", "云南省昭通市",
"861351149", "浙江省温州市",
"861366342", "山西省大同市",
"861556532", "河南省许昌市",
"861314567", "安徽省亳州市",
"861364712", "湖北省孝感市",
"861582559", "浙江省宁波市",
"861567293", "湖北省十堰市",
"861562945", "湖北省荆州市",
"861831917", "广东省茂名市",
"861800813", "四川省自贡市",
"861453442", "辽宁省沈阳市",
"861590994", "新疆昌吉回族自治州",
"86189029", "广东省深圳市",
"861471586", "广东省江门市",
"861893285", "河北省承德市",
"861323701", "江西省鹰潭市",
"861337720", "广西柳州市",
"861890731", "湖南省长沙市",
"861806773", "浙江省台州市",
"861831421", "云南省普洱市",
"861453670", "陕西省宝鸡市",
"861510433", "吉林省延边朝鲜族自治州",
"86181262", "广东省深圳市",
"861339832", "四川省达州市",
"86155857", "贵州省毕节地区",
"861361733", "湖南省株洲市",
"861380362", "黑龙江省齐齐哈尔市",
"861309241", "江苏省无锡市",
"861524573", "黑龙江省齐齐哈尔市",
"861571766", "河北省廊坊市",
"861378795", "湖南省张家界市",
"861346331", "河北省张家口市",
"861520800", "西藏日喀则地区",
"861820550", "安徽省滁州市",
"861331931", "江西省上饶市",
"861555267", "山东省淄博市",
"861475737", "浙江省嘉兴市",
"86538", "山东省泰安市",
"861857806", "广东省韶关市",
"86155850", "贵州省遵义市",
"86185885", "广东省广州市",
"861518192", "四川省遂宁市",
"861329957", "宁夏中卫市",
"861772229", "广东省茂名市",
"861598071", "福建省福州市",
"861391438", "江苏省南通市",
"861778921", "陕西省渭南市",
"861330728", "湖北省十堰市",
"861478510", "贵州省贵阳市",
"861813759", "河南省平顶山市",
"861322268", "江苏省扬州市",
"861520870", "云南省昭通市",
"861872436", "黑龙江省绥化市",
"861893467", "湖北省黄石市",
"861891928", "甘肃省庆阳市",
"861823824", "河南省开封市",
"861337100", "山东省泰安市",
"861820490", "内蒙古鄂尔多斯市",
"861882879", "四川省泸州市",
"86182641", "山东省济南市",
"861805198", "江苏省南京市",
"86156731", "湖南省长沙市",
"861571933", "甘肃省兰州市",
"861537749", "湖南省长沙市",
"861323771", "广西南宁市",
"86182918", "陕西省西安市",
"861598687", "广东省汕头市",
"861890313", "河北省张家口市",
"861367859", "贵州省黔西南布依族苗族自治州",
"861361311", "河北省石家庄市",
"861593296", "江西省抚州市",
"861367727", "湖北省荆门市",
"86150082", "四川省成都市",
"861857194", "湖北省黄冈市",
"861551770", "河南省南阳市",
"861452797", "新疆乌鲁木齐市",
"861524340", "河北省唐山市",
"861473666", "云南省昭通市",
"86138298", "广东省阳江市",
"86147220", "天津市",
"86130562", "江苏省徐州市",
"861365579", "浙江省金华市",
"861347099", "安徽省合肥市",
"861590845", "四川省内江市",
"861589040", "河南省南阳市",
"861535234", "甘肃省庆阳市",
"861356768", "浙江省舟山市",
"861459653", "青海省黄南藏族自治州",
"861571048", "陕西省西安市",
"861898762", "云南省文山壮族苗族自治州",
"86155189", "河南省南阳市",
"861811152", "四川省雅安市",
"861862474", "河南省新乡市",
"861350676", "浙江省台州市",
"861318148", "山东省临沂市",
"861316990", "广东省深圳市",
"861776016", "四川省内江市",
"861534686", "甘肃省张掖市",
"861595047", "江苏省南京市",
"861508251", "四川省阿坝藏族羌族自治州",
"861502959", "陕西省安康市",
"861533867", "贵州省毕节地区",
"861808887", "广东省揭阳市",
"86170886", "云南省昆明市",
"861522997", "陕西省宝鸡市",
"861334129", "山东省潍坊市",
"861345127", "湖北省十堰市",
"861305313", "安徽省合肥市",
"86183020", "广东省广州市",
"861787611", "广东省佛山市",
"861301206", "河北省保定市",
"861530904", "四川省阿坝藏族羌族自治州",
"861700675", "浙江省宁波市",
"86147036", "四川省成都市",
"86130732", "江苏省南通市",
"861355998", "福建省龙岩市",
"861550391", "河南省焦作市",
"861476301", "山东省济南市",
"861534395", "河南省漯河市",
"861821130", "广东省深圳市",
"861347529", "山东省东营市",
"861550789", "广西南宁市",
"86181558", "安徽省阜阳市",
"861313661", "黑龙江省齐齐哈尔市",
"861317959", "江苏省连云港市",
"861334779", "江苏省泰州市",
"861512994", "陕西省宝鸡市",
"861570961", "宁夏银川市",
"86181229", "广东省东莞市",
"861362562", "安徽省淮南市",
"861539744", "浙江省绍兴市",
"861312717", "山东省潍坊市",
"861327370", "河南省商丘市",
"861780580", "浙江省舟山市",
"861891936", "甘肃省张掖市",
"861369854", "贵州省毕节地区",
"861867252", "湖北省黄冈市",
"861501430", "广东省汕头市",
"861863411", "河北省邯郸市",
"861348741", "湖南省湘西土家族苗族自治州",
"861770504", "福建省莆田市",
"861570316", "河北省廊坊市",
"861330736", "湖南省常德市",
"861560359", "山西省运城市",
"861555942", "新疆和田地区",
"861800645", "山东省烟台市",
"86156561", "安徽省淮北市",
"861863927", "河南省洛阳市",
"861533276", "内蒙古赤峰市",
"861359295", "广东省茂名市",
"861562482", "内蒙古兴安盟",
"861567623", "广西桂林市",
"861380787", "广西南宁市",
"86136612", "北京市",
"861363437", "吉林省辽源市",
"861525901", "福建省龙岩市",
"86157690", "新疆昌吉回族自治州",
"86131304", "辽宁省大连市",
"86189062", "江苏省苏州市",
"861453985", "广东省肇庆市",
"861870665", "山东省东营市",
"86183118", "贵州省铜仁地区",
"861320510", "江苏省常州市",
"861300186", "河北省邯郸市",
"86132659", "广东省广州市",
"861522006", "广东省深圳市",
"861535453", "吉林省延边朝鲜族自治州",
"861773697", "河北省沧州市",
"861311643", "贵州省黔南布依族苗族自治州",
"861363021", "陕西省西安市",
"861452612", "江苏省无锡市",
"861519652", "四川省广安市",
"86187887", "贵州省黔西南布依族苗族自治州",
"861859620", "山东省临沂市",
"861304490", "江西省南昌市",
"861816844", "江苏省连云港市",
"861500941", "甘肃省甘南藏族自治州",
"861810469", "黑龙江省双鸭山市",
"861511358", "广东省湛江市",
"861320555", "安徽省马鞍山市",
"861317074", "云南省普洱市",
"861518228", "四川省乐山市",
"861458575", "山东省菏泽市",
"861334690", "河南省驻马店市",
"861300853", "陕西省渭南市",
"861895402", "山东省东营市",
"86152168", "上海市",
"861876832", "浙江省嘉兴市",
"861818398", "云南省楚雄彝族自治州",
"861352531", "河南省驻马店市",
"861899489", "江苏省扬州市",
"861820566", "安徽省池州市",
"861517063", "江西省赣州市",
"861327681", "浙江省杭州市",
"861890829", "四川省巴中市",
"861571750", "湖南省长沙市",
"861360619", "江苏省无锡市",
"861550568", "安徽省阜阳市",
"861589758", "湖北省随州市",
"861776928", "湖南省怀化市",
"861327077", "江苏省泰州市",
"861370656", "浙江省台州市",
"86938", "甘肃省天水市",
"861594901", "江苏省徐州市",
"861846425", "山东省滨州市",
"861372281", "河北省衡水市",
"861378989", "山东省淄博市",
"861509701", "甘肃省金昌市",
"861350488", "黑龙江省七台河市",
"861302063", "山东省枣庄市",
"861331335", "河北省秦皇岛市",
"861346935", "湖南省怀化市",
"861569539", "青海省海西蒙古族藏族自治州",
"861384950", "河南省焦作市",
"861325799", "江西省萍乡市",
"86136765", "浙江省温州市",
"86189295", "广东省广州市",
"86137638", "福建省福州市",
"861705515", "江苏省无锡市",
"861333925", "安徽省铜陵市",
"861863506", "山西省晋中市",
"86137954", "上海市",
"861573819", "河南省平顶山市",
"861306070", "广东省梅州市",
"861346748", "湖南省永州市",
"86156624", "山东省济南市",
"861384915", "河南省开封市",
"86183501", "福建省福州市",
"861556469", "山东省枣庄市",
"861803635", "江苏省徐州市",
"86137335", "湖北省十堰市",
"861776936", "湖南省常德市",
"861890348", "山西省运城市",
"861782061", "广东省佛山市",
"861897195", "湖北省孝感市",
"861339274", "广东省东莞市",
"861705550", "上海市",
"861360447", "吉林省吉林市",
"861336042", "广东省惠州市",
"861364227", "广东省云浮市",
"861503288", "河北省邯郸市",
"861476975", "山东省菏泽市",
"861530429", "辽宁省葫芦岛市",
"861591739", "广东省广州市",
"861840412", "辽宁省鞍山市",
"861539263", "山西省太原市",
"861816568", "广东省清远市",
"861312353", "广西桂林市",
"861707870", "云南省红河哈尼族彝族自治州",
"861700808", "江苏省南通市",
"861319079", "内蒙古巴彦淖尔市",
"861595340", "山东省德州市",
"8613691", "北京市",
"861512648", "云南省临沧市",
"861397299", "湖北省随州市",
"861302765", "河南省焦作市",
"861524047", "江苏省徐州市",
"861300402", "安徽省阜阳市",
"861500629", "江苏省南通市",
"86170779", "浙江省宁波市",
"861780851", "贵州省贵阳市",
"861521744", "广东省广州市",
"861454189", "山西省运城市",
"861879897", "西藏那曲地区",
"861318113", "山东省威海市",
"861305829", "广东省汕头市",
"861880964", "宁夏固原市",
"861566405", "河南省郑州市",
"86158026", "湖南省长沙市",
"861897573", "湖南省郴州市",
"86132602", "北京市",
"861883877", "河南省商丘市",
"861763546", "山西省吕梁市",
"861894808", "广东省江门市",
"86182138", "云南省昆明市",
"861501746", "广东省珠海市",
"861518698", "贵州省贵阳市",
"861333068", "四川省资阳市",
"861311850", "贵州省贵阳市",
"861366481", "内蒙古呼和浩特市",
"861554304", "吉林省吉林市",
"861330440", "吉林省吉林市",
"861834734", "内蒙古赤峰市",
"861873534", "山西省阳泉市",
"86159194", "广东省深圳市",
"861891244", "江苏省南通市",
"861478378", "河南省开封市",
"861345545", "山东省菏泽市",
"861535023", "江西省九江市",
"861534991", "新疆乌鲁木齐市",
"861579407", "广东省深圳市",
"861330672", "浙江省湖州市",
"86176435", "吉林省通化市",
"86155398", "河南省三门峡市",
"86153701", "江苏省苏州市",
"861805692", "安徽省安庆市",
"861550995", "新疆吐鲁番地区",
"861315082", "内蒙古乌兰察布市",
"861311815", "四川省广元市",
"861300640", "四川省乐山市",
"861363451", "黑龙江省哈尔滨市",
"861566561", "安徽省淮北市",
"861892469", "广东省湛江市",
"861508237", "四川省攀枝花市",
"861318470", "河北省邯郸市",
"861527980", "江西省吉安市",
"861347983", "江西省景德镇市",
"861537552", "安徽省蚌埠市",
"861837802", "广西柳州市",
"861339204", "广东省惠州市",
"861580541", "山东省济南市",
"861889419", "甘肃省陇南市",
"861811658", "四川省成都市",
"86187102", "北京市",
"861318642", "江苏省南京市",
"861453381", "内蒙古兴安盟",
"861776763", "新疆昌吉回族自治州",
"861813542", "山西省吕梁市",
"861822754", "四川省内江市",
"861594971", "山东省烟台市",
"861390692", "福建省福州市",
"861774021", "四川省成都市",
"861394985", "河南省漯河市",
"861350732", "湖南省湘潭市",
"861771255", "江苏省泰州市",
"861452143", "河北省石家庄市",
"86184052", "江苏省苏州市",
"861335181", "黑龙江省哈尔滨市",
"861534408", "内蒙古通辽市",
"86133816", "上海市",
"861348338", "河北省秦皇岛市",
"861364697", "福建省南平市",
"861309785", "广西玉林市",
"861361950", "宁夏银川市",
"861311112", "山西省大同市",
"861771210", "江苏省镇江市",
"861800329", "河北省邢台市",
"861532869", "四川省德阳市",
"861812348", "四川省雅安市",
"861523999", "河南省濮阳市",
"861895472", "山东省烟台市",
"861337209", "江苏省南通市",
"861772770", "广东省东莞市",
"861310187", "江苏省宿迁市",
"861535946", "福建省泉州市",
"861361915", "陕西省安康市",
"86151921", "山东省聊城市",
"861509121", "陕西省延安市",
"861800564", "安徽省六安市",
"861568789", "云南省昆明市",
"861862929", "陕西省西安市",
"861520257", "青海省海西蒙古族藏族自治州",
"861317004", "安徽省阜阳市",
"861329931", "甘肃省兰州市",
"861815063", "福建省福州市",
"861390353", "山西省阳泉市",
"861475751", "浙江省温州市",
"861861351", "山西省太原市",
"861304550", "安徽省滁州市",
"861375451", "河北省石家庄市",
"861362439", "吉林省白山市",
"861321832", "江苏省淮安市",
"861872740", "湖北省荆州市",
"861458505", "河南省南阳市",
"861503335", "河北省秦皇岛市",
"861313719", "河南省安阳市",
"861522076", "广东省江门市",
"861551229", "河北省衡水市",
"861327518", "江苏省常州市",
"861558359", "四川省乐山市",
"861577506", "广东省湛江市",
"86187880", "云南省保山市",
"861809062", "四川省成都市",
"861320495", "湖南省永州市",
"861590648", "浙江省温州市",
"861521951", "广东省清远市",
"861597521", "广东省揭阳市",
"861308974", "黑龙江省齐齐哈尔市",
"861596902", "云南省昭通市",
"861301545", "山西省晋城市",
"861550419", "辽宁省辽阳市",
"861868040", "广东省东莞市",
"861583374", "河北省邯郸市",
"861514198", "辽宁省葫芦岛市",
"861770331", "河北省石家庄市",
"861810007", "上海市",
"861829502", "宁夏石嘴山市",
"86132795", "陕西省咸阳市",
"861529852", "江苏省泰州市",
"861328906", "新疆阿勒泰地区",
"861896639", "浙江省宁波市",
"86139152", "江苏省无锡市",
"861554557", "黑龙江省哈尔滨市",
"861321843", "江苏省南通市",
"861560688", "浙江省温州市",
"861874831", "内蒙古阿拉善盟",
"861826644", "山东省德州市",
"861804039", "四川省泸州市",
"861558182", "山西省太原市",
"861322484", "内蒙古通辽市",
"861880320", "河北省邯郸市",
"861515555", "安徽省马鞍山市",
"861328390", "河南省焦作市",
"861874270", "新疆昌吉回族自治州",
"86150300", "河北省邯郸市",
"861587636", "广东省湛江市",
"861380417", "辽宁省营口市",
"861774240", "陕西省西安市",
"861800076", "江西省吉安市",
"861865680", "安徽省宿州市",
"86138383", "河南省郑州市",
"861873905", "河南省洛阳市",
"861364726", "湖北省十堰市",
"861707760", "云南省昆明市",
"861353915", "广东省梅州市",
"86158621", "江苏省徐州市",
"861452132", "河北省张家口市",
"861537071", "江苏省泰州市",
"861364945", "广西玉林市",
"861569930", "新疆昌吉回族自治州",
"861380921", "广东省佛山市",
"861817495", "广西百色市",
"861508963", "广东省茂名市",
"861863399", "河北省唐山市",
"861833983", "河南省郑州市",
"861476534", "吉林省长春市",
"861470527", "江苏省扬州市",
"861817184", "湖北省荆州市",
"861572089", "江苏省苏州市",
"861302875", "甘肃省酒泉市",
"861846462", "山东省潍坊市",
"861894768", "内蒙古兴安盟",
"861537687", "山东省青岛市",
"861335538", "山东省泰安市",
"861502881", "河北省衡水市",
"86136917", "广东省深圳市",
"861880431", "吉林省长春市",
"861353950", "广东省清远市",
"861392305", "广东省江门市",
"861768070", "湖南省娄底市",
"861815486", "新疆昌吉回族自治州",
"861816419", "湖北省十堰市",
"861309327", "湖北省随州市",
"861310375", "河南省平顶山市",
"861364738", "湖南省娄底市",
"861844934", "新疆昌吉回族自治州",
"861587628", "广东省江门市",
"861819189", "陕西省西安市",
"861322892", "西藏日喀则地区",
"861510799", "江西省萍乡市",
"861361499", "辽宁省辽阳市",
"861815102", "江苏省南京市",
"86185559", "安徽省淮南市",
"86187876", "云南省丽江市",
"861358230", "河北省邯郸市",
"861529110", "陕西省西安市",
"861851576", "四川省德阳市",
"861881463", "黑龙江省牡丹江市",
"861333962", "贵州省遵义市",
"86182678", "浙江省温州市",
"861858724", "云南省昆明市",
"861535387", "陕西省榆林市",
"861339818", "四川省成都市",
"861477886", "广东省茂名市",
"861390265", "广东省惠州市",
"861378580", "河北省沧州市",
"861700923", "山东省济南市",
"861380649", "山东省潍坊市",
"861813533", "山西省晋中市",
"861858174", "四川省南充市",
"861309466", "浙江省金华市",
"86182375", "河南省平顶山市",
"86130446", "上海市",
"861315988", "黑龙江省鹤岗市",
"861529403", "甘肃省平凉市",
"861319285", "广东省韶关市",
"861337783", "湖北省孝感市",
"861890256", "广东省佛山市",
"861532709", "湖北省孝感市",
"86155745", "湖南省怀化市",
"861302172", "山东省济南市",
"861857750", "广西贵港市",
"861519830", "云南省普洱市",
"861332140", "吉林省长春市",
"861334041", "福建省福州市",
"861338345", "山西省长治市",
"86187253", "云南省保山市",
"861500754", "广东省汕头市",
"861350045", "辽宁省葫芦岛市",
"861320919", "陕西省铜川市",
"861346574", "山东省聊城市",
"861771363", "四川省成都市",
"861575229", "云南省红河哈尼族彝族自治州",
"861504716", "内蒙古通辽市",
"861773482", "河南省郑州市",
"861806180", "江苏省南通市",
"861550647", "山东省烟台市",
"861522848", "四川省德阳市",
"861839655", "福建省南平市",
"861376858", "广西南宁市",
"861809410", "福建省泉州市",
"861452835", "四川省雅安市",
"861355847", "广西钦州市",
"861565380", "山东省泰安市",
"861388483", "山东省聊城市",
"861809595", "新疆乌鲁木齐市",
"861528898", "山东省青岛市",
"861351591", "福建省龙岩市",
"86137178", "北京市",
"861399759", "湖北省荆州市",
"861343725", "湖北省武汉市",
"861802988", "广东省河源市",
"861829893", "甘肃省金昌市",
"861304959", "贵州省黔西南布依族苗族自治州",
"861858896", "广东省深圳市",
"861773738", "河南省驻马店市",
"86155759", "湖南省长沙市",
"86170925", "江苏省南京市",
"861772860", "广东省惠州市",
"861563699", "黑龙江省大庆市",
"861300521", "广东省汕头市",
"86182703", "江西省上饶市",
"861532779", "湖北省荆州市",
"861520756", "广东省珠海市",
"861848352", "四川省泸州市",
"861529473", "河南省信阳市",
"861454352", "山东省菏泽市",
"861346504", "山东省菏泽市",
"861871560", "安徽省合肥市",
"861341348", "广东省清远市",
"861568273", "甘肃省武威市",
"861828478", "四川省遂宁市",
"861850758", "广东省肇庆市",
"861332395", "河南省漯河市",
"86131432", "广东省东莞市",
"861381945", "浙江省杭州市",
"861369631", "山东省威海市",
"861361559", "安徽省黄山市",
"86185545", "山东省淄博市",
"861329464", "山西省晋城市",
"861570322", "河北省保定市",
"861853030", "河南省濮阳市",
"861536992", "河北省衡水市",
"861590567", "安徽省亳州市",
"861555750", "浙江省绍兴市",
"8615823", "重庆市",
"861378837", "广西南宁市",
"861865975", "福建省龙岩市",
"861564562", "黑龙江省大庆市",
"861596339", "山东省德州市",
"861769248", "河北省衡水市",
"86159325", "河北省唐山市",
"861893954", "河南省漯河市",
"861821858", "广东省佛山市",
"861877229", "湖北省黄石市",
"861390487", "黑龙江省鸡西市",
"861557969", "江西省上饶市",
"861860388", "河南省周口市",
"861310305", "河北省唐山市",
"861775134", "江苏省徐州市",
"861843279", "河北省邢台市",
"861865146", "江苏省徐州市",
"861508728", "云南省大理白族自治州",
"861556077", "内蒙古鄂尔多斯市",
"86159628", "江苏省南通市",
"861328842", "广东省佛山市",
"861815172", "江苏省常州市",
"861894923", "安徽省巢湖市",
"861593143", "河北省保定市",
"861454693", "广东省东莞市",
"861364482", "内蒙古包头市",
"861780795", "江西省宜春市",
"861340016", "河北省保定市",
"861343872", "四川省乐山市",
"861302805", "山西省晋城市",
"861822941", "湖南省岳阳市",
"861322503", "福建省厦门市",
"861533545", "山东省烟台市",
"861560511", "江苏省盐城市",
"86856", "贵州省铜仁地区",
"86185926", "陕西省西安市",
"86133100", "上海市",
"86159893", "广东省深圳市",
"861820074", "广东省广州市",
"861344054", "山东省莱芜市",
"861873975", "河南省周口市",
"861347435", "陕西省西安市",
"861700768", "广东省茂名市",
"861893312", "广东省揭阳市",
"861539355", "甘肃省金昌市",
"861327469", "黑龙江省双鸭山市",
"861773726", "河南省安阳市",
"861368718", "湖北省黄石市",
"861575699", "四川省阿坝藏族羌族自治州",
"861805487", "福建省龙岩市",
"861848914", "西藏林芝地区",
"861387242", "湖北省荆州市",
"861708481", "河南省郑州市",
"861773945", "河南省周口市",
"861589986", "广东省深圳市",
"86150307", "河北省沧州市",
"861300091", "吉林省长春市",
"861370899", "山东省青岛市",
"861770713", "湖北省黄冈市",
"86158498", "内蒙古巴彦淖尔市",
"861311632", "贵州省贵阳市",
"861328145", "四川省成都市",
"861815875", "浙江省绍兴市",
"861315257", "广西桂林市",
"861364894", "西藏林芝地区",
"861812256", "广东省茂名市",
"861450956", "江苏省宿迁市",
"861501247", "广东省深圳市",
"861336735", "湖南省郴州市",
"861596972", "山东省临沂市",
"861332686", "广东省东莞市",
"861573380", "河北省保定市",
"861458689", "湖南省岳阳市",
"861342658", "江西省九江市",
"861582035", "广东省梅州市",
"861389141", "陕西省商洛市",
"861330251", "广东省茂名市",
"861539937", "陕西省安康市",
"861882611", "广东省广州市",
"861809025", "四川省广元市",
"861810077", "广西南宁市",
"861776873", "江苏省泰州市",
"861809705", "青海省海东地区",
"861700146", "江苏省南通市",
"861317659", "山东省淄博市",
"86150310", "河北省邯郸市",
"861771530", "江苏省无锡市",
"8613522", "北京市",
"861351701", "江西省鹰潭市",
"861850478", "内蒙古巴彦淖尔市",
"861377410", "湖北省随州市",
"861835101", "江苏省泰州市",
"861322095", "山东省聊城市",
"861310323", "河北省张家口市",
"86151953", "江苏省淮安市",
"861532459", "安徽省宣城市",
"861520476", "内蒙古赤峰市",
"861776702", "浙江省舟山市",
"861477710", "广西南宁市",
"861321742", "湖南省湘潭市",
"861313316", "山西省晋城市",
"861530382", "河南省郑州市",
"861847168", "湖北省武汉市",
"86183733", "湖南省株洲市",
"861700975", "浙江省嘉兴市",
"861890394", "河南省周口市",
"861360039", "广东省茂名市",
"861530604", "福建省龙岩市",
"861538549", "安徽省亳州市",
"861782821", "四川省成都市",
"861837289", "湖北省黄冈市",
"861399479", "山西省临汾市",
"861868140", "广东省佛山市",
"861346794", "湖南省怀化市",
"861823245", "河北省廊坊市",
"861350842", "湖南省邵阳市",
"861537721", "湖北省恩施土家族苗族自治州",
"861453685", "陕西省渭南市",
"86189092", "陕西省西安市",
"861314042", "河南省鹤壁市",
"861327238", "湖南省郴州市",
"86145069", "上海市",
"86185512", "江苏省苏州市",
"861572189", "云南省昆明市",
"861855890", "福建省龙岩市",
"86156591", "福建省福州市",
"861555642", "安徽省六安市",
"861800945", "甘肃省金昌市",
"861800726", "湖北省恩施土家族苗族自治州",
"861539272", "湖北省黄冈市",
"861857113", "湖北省孝感市",
"861320801", "浙江省杭州市",
"86182340", "山西省太原市",
"861521798", "广东省惠州市",
"861893831", "广东省肇庆市",
"86137888", "福建省泉州市",
"861343703", "江西省上饶市",
"861893270", "河北省邯郸市",
"86133117", "上海市",
"861778949", "甘肃省天水市",
"861510579", "浙江省金华市",
"861392252", "广东省东莞市",
"86185577", "浙江省台州市",
"861335196", "黑龙江省鹤岗市",
"861780505", "江苏省南通市",
"861830374", "河南省许昌市",
"861592509", "云南省昭通市",
"861800738", "湖南省娄底市",
"861598987", "广东省深圳市",
"86132130", "河南省郑州市",
"861394888", "内蒙古巴彦淖尔市",
"861339499", "新疆伊犁哈萨克自治州",
"861576131", "贵州省黔东南苗族侗族自治州",
"861761412", "辽宁省鞍山市",
"86178647", "山东省济宁市",
"861322793", "陕西省渭南市",
"86152513", "江苏省南通市",
"861367532", "山东省青岛市",
"861453396", "内蒙古乌兰察布市",
"861348179", "广西柳州市",
"861571633", "河南省安阳市",
"86177958", "陕西省西安市",
"86184249", "辽宁省沈阳市",
"86177634", "山东省莱芜市",
"861311460", "黑龙江省哈尔滨市",
"861556107", "内蒙古包头市",
"861361818", "四川省乐山市",
"861769827", "河南省平顶山市",
"861850249", "辽宁省辽阳市",
"861816898", "江苏省苏州市",
"86458", "黑龙江省伊春市",
"861777158", "湖北省潜江市",
"86157391", "新疆喀什地区",
"861778621", "湖北省荆门市",
"861533320", "河北省邯郸市",
"861760487", "内蒙古鄂尔多斯市",
"861597191", "湖北省十堰市",
"861501836", "广东省汕头市",
"861350976", "山西省晋城市",
"861839284", "陕西省渭南市",
"861337882", "云南省德宏傣族景颇族自治州",
"861831208", "广东省揭阳市",
"861785818", "浙江省丽水市",
"861348857", "内蒙古呼和浩特市",
"861847903", "江西省上饶市",
"86131061", "浙江省温州市",
"861534986", "安徽省六安市",
"861890069", "江苏省苏州市",
"861315359", "山东省滨州市",
"86183563", "安徽省宣城市",
"861347541", "山东省济南市",
"861892177", "江苏省徐州市",
"861512913", "陕西省渭南市",
"86151581", "浙江省杭州市",
"86188644", "河南省濮阳市",
"861350145", "广东省清远市",
"86130592", "广东省江门市",
"861302823", "辽宁省盘锦市",
"86177471", "内蒙古呼和浩特市",
"861332040", "云南省红河哈尼族彝族自治州",
"86187637", "山东省临沂市",
"861811416", "江苏省徐州市",
"861508517", "贵州省黔南布依族苗族自治州",
"861894680", "青海省玉树藏族自治州",
"861479662", "江西省吉安市",
"86180543", "山东省滨州市",
"86138268", "广东省云浮市",
"861395945", "福建省龙岩市",
"861599292", "广东省东莞市",
"861533431", "云南省保山市",
"861366496", "广东省阳江市",
"8614733", "四川省成都市",
"861530767", "广东省潮州市",
"861338090", "广东省湛江市",
"86187630", "山东省滨州市",
"86135631", "山东省威海市",
"861350390", "河南省南阳市",
"861874954", "河南省商丘市",
"86182713", "湖北省宜昌市",
"861860959", "宁夏固原市",
"861880545", "山东省烟台市",
"861513660", "河南省商丘市",
"861870916", "陕西省汉中市",
"861373433", "山东省日照市",
"861864521", "黑龙江省齐齐哈尔市",
"861301320", "河北省邯郸市",
"861831278", "广东省梅州市",
"861308250", "江苏省常州市",
"86151878", "云南省曲靖市",
"861366556", "安徽省安庆市",
"861350906", "广东省汕尾市",
"861528419", "四川省宜宾市",
"861395106", "江苏省宿迁市",
"861454205", "河南省新乡市",
"861842012", "广东省湛江市",
"86134726", "上海市",
"861339559", "安徽省黄山市",
"861593043", "河北省保定市",
"861709938", "浙江省丽水市",
"861331631", "广东省佛山市",
"861865046", "福建省福州市",
"861362047", "广东省珠海市",
"86181292", "新疆乌鲁木齐市",
"861834995", "四川省自贡市",
"861775034", "福建省莆田市",
"86138509", "福建省南平市",
"861850991", "新疆乌鲁木齐市",
"861333836", "福建省厦门市",
"861770150", "江苏省常州市",
"861801417", "江苏省淮安市",
"86181781", "广西南宁市",
"861304388", "辽宁省葫芦岛市",
"861508078", "湖南省湘潭市",
"861310252", "河北省秦皇岛市",
"861556727", "吉林省松原市",
"861301431", "河北省唐山市",
"861550734", "湖南省衡阳市",
"861327385", "河南省许昌市",
"861780575", "浙江省绍兴市",
"861346838", "山东省聊城市",
"861370960", "广东省佛山市",
"86145022", "河北省石家庄市",
"861333349", "山西省朔州市",
"86184844", "贵州省黔东南苗族侗族自治州",
"861776825", "江苏省徐州市",
"86135474", "四川省雅安市",
"861800482", "内蒙古兴安盟",
"86150743", "湖南省湘西土家族苗族自治州",
"861359746", "湖北省襄樊市",
"861831617", "广东省肇庆市",
"86178640", "山东省菏泽市",
"86132137", "河南省南阳市",
"861328743", "山东省烟台市",
"861300463", "浙江省绍兴市",
"861537101", "江苏省南京市",
"861472682", "四川省绵阳市",
"861588421", "四川省资阳市",
"861876742", "浙江省台州市",
"86182347", "山西省临汾市",
"861333828", "福建省福州市",
"861810859", "贵州省黔西南布依族苗族自治州",
"861838147", "四川省宜宾市",
"861803331", "广东省清远市",
"861525087", "江苏省淮安市",
"861709745", "广东省东莞市",
"861875297", "江苏省镇江市",
"861372296", "河北省保定市",
"861893200", "贵州省贵阳市",
"861772999", "安徽省芜湖市",
"86137571", "浙江省杭州市",
"861525671", "安徽省淮南市",
"861500583", "浙江省嘉兴市",
"861529425", "甘肃省定西市",
"86136900", "广东省潮州市",
"861820724", "湖北省咸宁市",
"861320230", "广东省惠州市",
"861781433", "内蒙古赤峰市",
"861768100", "安徽省宿州市",
"86138552", "安徽省蚌埠市",
"861303317", "安徽省安庆市",
"861535289", "内蒙古包头市",
"861320871", "云南省昆明市",
"861824940", "黑龙江省双鸭山市",
"86152389", "河南省三门峡市",
"861337554", "山东省日照市",
"861539202", "福建省厦门市",
"861327696", "福建省厦门市",
"861346826", "山东省莱芜市",
"861535863", "江苏省泰州市",
"861575466", "黑龙江省黑河市",
"86150372", "河南省安阳市",
"861590913", "陕西省渭南市",
"861303930", "吉林省长春市",
"861835721", "浙江省嘉兴市",
"861588330", "四川省眉山市",
"861530674", "浙江省宁波市",
"861365433", "吉林省延边朝鲜族自治州",
"861389041", "四川省泸州市",
"861528647", "贵州省六盘水市",
"861800894", "西藏林芝地区",
"861773076", "陕西省汉中市",
"86155712", "湖北省孝感市",
"861803420", "河北省邯郸市",
"86139261", "广东省广州市",
"86186791", "江西省南昌市",
"861335874", "辽宁省营口市",
"86186282", "四川省成都市",
"861399409", "山西省忻州市",
"861577164", "陕西省渭南市",
"86189914", "陕西省商洛市",
"861868395", "四川省成都市",
"861328045", "山东省聊城市",
"861324341", "河南省鹤壁市",
"861358919", "山东省潍坊市",
"861370418", "辽宁省阜新市",
"861857470", "湖南省衡阳市",
"861850408", "辽宁省大连市",
"861551785", "河南省平顶山市",
"861809775", "新疆吐鲁番地区",
"861816734", "浙江省绍兴市",
"861500474", "内蒙古乌兰察布市",
"86150317", "河北省沧州市",
"861351771", "广西南宁市",
"861833620", "河南省驻马店市",
"861595562", "安徽省安庆市",
"861338520", "湖北省武汉市",
"861470718", "湖北省鄂州市",
"861771887", "广东省江门市",
"86186918", "陕西省西安市",
"861365442", "吉林省吉林市",
"861889734", "青海省果洛藏族自治州",
"86131149", "天津市",
"861580435", "吉林省通化市",
"861352982", "云南省红河哈尼族彝族自治州",
"861327859", "吉林省松原市",
"861340298", "陕西省西安市",
"861315476", "内蒙古赤峰市",
"86186641", "广东省东莞市",
"861321966", "四川省自贡市",
"861860490", "辽宁省铁岭市",
"861333973", "湖北省荆州市",
"861760353", "山西省阳泉市",
"861317174", "河北省衡水市",
"861881472", "黑龙江省齐齐哈尔市",
"86152731", "湖南省长沙市",
"86170757", "安徽省合肥市",
"861857633", "广东省清远市",
"861316041", "江苏省扬州市",
"861879648", "江苏省常州市",
"861302491", "福建省宁德市",
"861372118", "安徽省蚌埠市",
"861881640", "江西省九江市",
"861581892", "广东省茂名市",
"861817871", "广西桂林市",
"861856970", "湖南省湘西土家族苗族自治州",
"861560870", "云南省昭通市",
"861512897", "河北省保定市",
"861587016", "贵州省安顺市",
"861560231", "广东省深圳市",
"861369957", "江西省上饶市",
"861300752", "河南省郑州市",
"861589991", "广东省东莞市",
"861317724", "湖北省襄樊市",
"861365670", "浙江省衢州市",
"861535005", "江西省宜春市",
"861302163", "山东省威海市",
"861553355", "河北省唐山市",
"861592900", "陕西省安康市",
"861305407", "湖南省岳阳市",
"861760692", "云南省德宏傣族景颇族自治州",
"861821910", "广东省湛江市",
"861318715", "湖南省怀化市",
"861478619", "贵州省遵义市",
"861830557", "安徽省宿州市",
"861325579", "浙江省金华市",
"861453509", "山东省日照市",
"861847836", "湖南省湘西土家族苗族自治州",
"86131666", "辽宁省沈阳市",
"861771372", "四川省德阳市",
"86176203", "广东省深圳市",
"86183326", "河北省唐山市",
"861821955", "广东省阳江市",
"86170585", "北京市",
"861834419", "广东省梅州市",
"861318750", "云南省保山市",
"861327727", "湖北省襄樊市",
"861342416", "广东省深圳市",
"861596728", "浙江省丽水市",
"861825293", "江苏省镇江市",
"861553310", "河北省邯郸市",
"861354530", "湖北省襄樊市",
"861559545", "宁夏固原市",
"861571400", "辽宁省沈阳市",
"861700534", "山东省淄博市",
"861336142", "山东省枣庄市",
"861531539", "山东省临沂市",
"861557711", "广西崇左市",
"861388166", "四川省巴中市",
"861313434", "吉林省四平市",
"86131013", "重庆市",
"861834647", "黑龙江省牡丹江市",
"861302908", "吉林省延边朝鲜族自治州",
"86187170", "重庆市",
"861514144", "辽宁省本溪市",
"861378747", "湖南省益阳市",
"86135171", "湖北省恩施土家族苗族自治州",
"861813924", "新疆伊犁哈萨克自治州",
"86151322", "河北省保定市",
"861392671", "广东省茂名市",
"861517908", "江西省赣州市",
"861510970", "青海省海北藏族自治州",
"86150693", "山东省淄博市",
"861806234", "湖北省荆州市",
"861393993", "河南省洛阳市",
"861381329", "江苏省徐州市",
"861566053", "河南省周口市",
"861772415", "广东省江门市",
"861814953", "福建省福州市",
"861362714", "湖北省武汉市",
"861847828", "湖南省邵阳市",
"861337307", "河北省沧州市",
"861802182", "江苏省徐州市",
"861458523", "河南省焦作市",
"861323437", "吉林省辽源市",
"861551466", "河南省驻马店市",
"861318013", "河北省秦皇岛市",
"86132081", "四川省成都市",
"861565901", "福建省龙岩市",
"861576611", "广东省梅州市",
"861898646", "湖北省孝感市",
"86152561", "安徽省阜阳市",
"861821468", "云南省保山市",
"861561263", "河北省廊坊市",
"861524147", "辽宁省大连市",
"861520359", "山西省运城市",
"861458795", "湖南省株洲市",
"8613690", "广东省佛山市",
"861475565", "安徽省芜湖市",
"861500397", "河南省信阳市",
"861535703", "安徽省芜湖市",
"861522482", "河南省平顶山市",
"861846473", "山东省济宁市",
"861319179", "河北省张家口市",
"8613311", "北京市",
"861864402", "黑龙江省大庆市",
"8618557", "浙江省杭州市",
"861882350", "广东省潮州市",
"861351586", "浙江省台州市",
"861373442", "山东省泰安市",
"861769624", "山西省运城市",
"861367370", "河南省商丘市",
"86181339", "陕西省西安市",
"861322562", "安徽省铜陵市",
"861551327", "山西省太原市",
"861890407", "辽宁省营口市",
"861558257", "山西省晋城市",
"861827252", "河南省鹤壁市",
"861329854", "湖南省株洲市",
"86139435", "吉林省通化市",
"861536198", "广东省梅州市",
"861814446", "广东省江门市",
"86132670", "广东省深圳市",
"861309856", "贵州省铜仁地区",
"861315182", "江苏省宿迁市",
"861343863", "四川省广安市",
"861846403", "山东省菏泽市",
"86177174", "上海市",
"861881186", "广东省潮州市",
"86153711", "江苏省盐城市",
"861379392", "山东省临沂市",
"861813213", "河北省张家口市",
"861808639", "湖北省孝感市",
"861890477", "内蒙古鄂尔多斯市",
"861532990", "贵州省贵阳市",
"861386654", "安徽省宿州市",
"861360378", "河南省开封市",
"861367300", "河南省驻马店市",
"861853655", "山西省朔州市",
"861535123", "四川省绵阳市",
"861565971", "福建省泉州市",
"86188794", "江西省抚州市",
"861587244", "湖北省襄樊市",
"861815908", "福建省福州市",
"86134333", "广东省汕头市",
"861306413", "江西省南昌市",
"861340628", "山东省济宁市",
"861852736", "湖北省武汉市",
"861355737", "广西玉林市",
"861535773", "安徽省马鞍山市",
"861452745", "湖南省怀化市",
"861770635", "山东省聊城市",
"861367996", "新疆博尔塔拉蒙古自治州",
"861532306", "广东省惠州市",
"861831814", "广东省揭阳市",
"861309183", "黑龙江省牡丹江市",
"861534758", "广东省肇庆市",
"861886089", "江苏省泰州市",
"861328488", "内蒙古通辽市",
"861826236", "江苏省盐城市",
"861510900", "新疆乌鲁木齐市",
"861337377", "河南省洛阳市",
"861367543", "山东省滨州市",
"861871890", "广东省广州市",
"861571642", "河南省开封市",
"86178797", "江西省赣州市",
"86182761", "广西南宁市",
"861894534", "黑龙江省绥化市",
"86187112", "湖南省岳阳市",
"861825623", "安徽省六安市",
"861379653", "黑龙江省黑河市",
"861528568", "贵州省毕节地区",
"861809865", "安徽省芜湖市",
"861596963", "山东省德州市",
"861351861", "山东省济南市",
"861589478", "新疆昌吉回族自治州",
"861571470", "内蒙古呼伦贝尔市",
"861858566", "贵州省黔南布依族苗族自治州",
"861359962", "福建省龙岩市",
"86155786", "广西百色市",
"861572914", "河南省鹤壁市",
"861776862", "江苏省泰州市",
"861829563", "宁夏吴忠市",
"861878343", "四川省凉山彝族自治州",
"86187177", "上海市",
"861521637", "山东省枣庄市",
"861302978", "黑龙江省佳木斯市",
"86138374", "河南省许昌市",
"861882031", "广东省东莞市",
"861354887", "湖南省常德市",
"861325509", "福建省三明市",
"861509021", "河南省濮阳市",
"861329582", "浙江省湖州市",
"861530877", "云南省玉溪市",
"861356301", "山东省聊城市",
"86139213", "江苏省无锡市",
"861815491", "新疆乌鲁木齐市",
"861800697", "福建省龙岩市",
"861570489", "内蒙古鄂尔多斯市",
"86182531", "山东省济南市",
"861339950", "安徽省滁州市",
"861820659", "山东省滨州市",
"861598346", "四川省广安市",
"861566423", "河南省平顶山市",
"861555633", "安徽省滁州市",
"861336994", "新疆昌吉回族自治州",
"861529462", "河南省郑州市",
"861370324", "河北省唐山市",
"861335081", "四川省泸州市",
"861535075", "河北省沧州市",
"86135036", "黑龙江省哈尔滨市",
"861364329", "河北省邢台市",
"861315885", "四川省乐山市",
"861370569", "安徽省合肥市",
"861339915", "陕西省安康市",
"861885016", "福建省厦门市",
"86151369", "河南省平顶山市",
"861364564", "安徽省六安市",
"861592970", "陕西省榆林市",
"861772020", "湖北省武汉市",
"861860550", "安徽省滁州市",
"861856900", "湖南省株洲市",
"861584889", "内蒙古赤峰市",
"861839351", "甘肃省天水市",
"861786927", "云南省丽江市",
"86133632", "河北省唐山市",
"861780934", "甘肃省庆阳市",
"861335218", "辽宁省锦州市",
"861573971", "新疆克拉玛依市",
"86134192", "四川省宜宾市",
"861321733", "湖南省株洲市",
"861365600", "福建省厦门市",
"861776165", "河南省焦作市",
"861589249", "四川省绵阳市",
"861518847", "河南省南阳市",
"861564573", "黑龙江省黑河市",
"861530159", "江苏省南京市",
"861572693", "浙江省嘉兴市",
"861315406", "陕西省商洛市",
"861874741", "内蒙古包头市",
"861363701", "安徽省滁州市",
"861301964", "辽宁省鞍山市",
"861338641", "山东省济南市",
"861860515", "江苏省盐城市",
"86150554", "安徽省安庆市",
"861877083", "江西省上饶市",
"86170750", "江苏省南京市",
"861708556", "安徽省安庆市",
"861807261", "浙江省湖州市",
"861333903", "安徽省芜湖市",
"861522945", "陕西省安康市",
"861881402", "广东省惠州市",
"861528877", "山东省烟台市",
"861810528", "江苏省镇江市",
"861872788", "湖北省鄂州市",
"861339836", "四川省绵阳市",
"861857872", "广东省汕尾市",
"861335644", "广东省江门市",
"861380366", "黑龙江省佳木斯市",
"861571762", "河北省廊坊市",
"861857023", "湖南省株洲市",
"861770455", "黑龙江省绥化市",
"861380911", "陕西省延安市",
"86137500", "广东省珠海市",
"861360754", "福建省莆田市",
"861308203", "河北省邢台市",
"861840958", "宁夏银川市",
"861536469", "山西省朔州市",
"861333559", "安徽省黄山市",
"861590680", "浙江省舟山市",
"861512975", "陕西省延安市",
"861884983", "云南省保山市",
"861364716", "湖北省荆州市",
"861318863", "辽宁省辽阳市",
"86158622", "江苏省徐州市",
"861353925", "广东省揭阳市",
"861880937", "甘肃省酒泉市",
"861454213", "河南省平顶山市",
"861334363", "河南省濮阳市",
"861339349", "山西省朔州市",
"861336589", "湖南省邵阳市",
"861471582", "广东省惠州市",
"861453446", "辽宁省葫芦岛市",
"861380427", "辽宁省盘锦市",
"861853435", "山西省临汾市",
"861506669", "山东省济南市",
"861770410", "辽宁省沈阳市",
"86188639", "山东省青岛市",
"861569327", "甘肃省兰州市",
"861880310", "河北省邯郸市",
"861534374", "河南省许昌市",
"861338084", "广东省汕尾市",
"861826538", "山东省泰安市",
"861528159", "四川省甘孜藏族自治州",
"861501499", "广东省阳江市",
"861521457", "黑龙江省佳木斯市",
"861599938", "新疆和田地区",
"861366346", "山西省晋城市",
"861321295", "黑龙江省齐齐哈尔市",
"861479733", "山西省长治市",
"86139151", "江苏省淮安市",
"861879923", "新疆克拉玛依市",
"861855552", "安徽省蚌埠市",
"861366839", "四川省达州市",
"8613510", "广东省深圳市",
"861880355", "山西省长治市",
"861325953", "宁夏吴忠市",
"86132285", "重庆市",
"861452665", "江西省宜春市",
"861559889", "内蒙古呼伦贝尔市",
"861569466", "云南省昆明市",
"861818494", "西藏林芝地区",
"861870612", "江苏省常州市",
"861891309", "江苏省苏州市",
"861470008", "福建省厦门市",
"861858268", "四川省内江市",
"861700694", "广东省东莞市",
"861477070", "江西省南昌市",
"861550429", "辽宁省葫芦岛市",
"861857946", "广西南宁市",
"861394730", "内蒙古乌海市",
"861370158", "江苏省南京市",
"861890444", "吉林省四平市",
"86189314", "河北省唐山市",
"86159492", "江苏省无锡市",
"861894224", "江西省南昌市",
"861393409", "山西省运城市",
"861331240", "贵州省安顺市",
"861809420", "江苏省南京市",
"861367487", "内蒙古赤峰市",
"861857725", "广西来宾市",
"861599926", "新疆伊犁哈萨克自治州",
"861351957", "宁夏银川市",
"86188273", "湖北省武汉市",
"861840571", "浙江省杭州市",
"861504726", "内蒙古巴彦淖尔市",
"861309930", "甘肃省甘南藏族自治州",
"861557884", "广西百色市",
"861800880", "云南省昆明市",
"861301272", "山东省滨州市",
"861803125", "河北省秦皇岛市",
"861893253", "河北省石家庄市",
"861567567", "湖南省郴州市",
"861882291", "广东省揭阳市",
"861768886", "广东省广州市",
"861362881", "云南省西双版纳傣族自治州",
"861839620", "福建省泉州市",
"861760532", "山东省青岛市",
"861320929", "陕西省延安市",
"861770968", "安徽省阜阳市",
"861814579", "广东省佛山市",
"861803775", "河南省商丘市",
"861587277", "湖北省咸宁市",
"861840465", "黑龙江省七台河市",
"861820439", "吉林省白山市",
"861709622", "山东省济宁市",
"861337344", "河北省秦皇岛市",
"861330488", "黑龙江省双鸭山市",
"86186827", "四川省巴中市",
"861351335", "河北省秦皇岛市",
"861561545", "山东省烟台市",
"861555105", "安徽省马鞍山市",
"861339828", "四川省泸州市",
"861818882", "广东省佛山市",
"861810536", "山东省潍坊市",
"86188856", "贵州省铜仁地区",
"861590905", "新疆昌吉回族自治州",
"861472986", "陕西省西安市",
"861340456", "吉林省松原市",
"86138366", "黑龙江省佳木斯市",
"861700913", "陕西省榆林市",
"861384962", "河南省驻马店市",
"861300688", "广东省广州市",
"861587618", "广东省汕头市",
"861316939", "广东省云浮市",
"86147515", "江苏省无锡市",
"861388780", "云南省保山市",
"86152989", "海南省海口市",
"861705562", "天津市",
"861327992", "新疆伊犁哈萨克自治州",
"861530568", "安徽省阜阳市",
"861858714", "云南省丽江市",
"861309317", "江苏省常州市",
"861332531", "陕西省延安市",
"86187404", "陕西省西安市",
"861810098", "西藏拉萨市",
"861479035", "安徽省芜湖市",
"861478404", "河南省驻马店市",
"86136300", "广东省佛山市",
"861523425", "山西省太原市",
"861555946", "新疆阿克苏地区",
"861595388", "山东省威海市",
"861537560", "安徽省滁州市",
"861533272", "内蒙古包头市",
"861562486", "内蒙古赤峰市",
"861894913", "安徽省滁州市",
"86158669", "山东省临沂市",
"861580610", "江苏省镇江市",
"861378774", "湖南省郴州市",
"861869627", "湖北省黄石市",
"861380057", "浙江省杭州市",
"861478474", "内蒙古乌兰察布市",
"861809713", "青海省黄南藏族自治州",
"861387193", "湖北省孝感市",
"861459685", "新疆克拉玛依市",
"861552869", "四川省资阳市",
"861808029", "四川省广安市",
"861503240", "河北省邯郸市",
"861867169", "湖北省恩施土家族苗族自治州",
"861878821", "云南省德宏傣族景颇族自治州",
"861362566", "安徽省安庆市",
"861555175", "安徽省马鞍山市",
"861361247", "广东省佛山市",
"861554408", "河南省郑州市",
"861572533", "山东省淄博市",
"861867256", "湖北省荆州市",
"86135816", "北京市",
"861529700", "青海省海北藏族自治州",
"861891932", "甘肃省定西市",
"86186820", "广东省深圳市",
"861329149", "浙江省金华市",
"861570312", "河北省保定市",
"861330732", "湖南省湘潭市",
"861590975", "青海省果洛藏族自治州",
"861846999", "云南省普洱市",
"861390981", "辽宁省沈阳市",
"861882949", "陕西省西安市",
"861524174", "辽宁省盘锦市",
"861324491", "广东省江门市",
"861888241", "四川省宜宾市",
"861562805", "贵州省毕节地区",
"861471854", "广东省肇庆市",
"86151353", "山西省临汾市",
"861311862", "广东省潮州市",
"861367265", "广东省珠海市",
"861343750", "广东省汕尾市",
"861825033", "福建省福州市",
"861538359", "山西省运城市",
"861587581", "广东省肇庆市",
"86830", "四川省泸州市",
"861478583", "贵州省安顺市",
"861319961", "黑龙江省鹤岗市",
"861514859", "内蒙古呼伦贝尔市",
"861800537", "山东省济宁市",
"86158146", "广东省深圳市",
"861340943", "河南省商丘市",
"861555593", "安徽省宿州市",
"86177400", "辽宁省沈阳市",
"861862510", "江苏省苏州市",
"861458233", "安徽省淮南市",
"861890380", "河南省新乡市",
"861804583", "黑龙江省大庆市",
"861301202", "河北省沧州市",
"861824885", "江苏省南通市",
"861520940", "甘肃省甘南藏族自治州",
"861783526", "山西省吕梁市",
"861839290", "陕西省商洛市",
"861809015", "四川省泸州市",
"861882621", "广东省珠海市",
"861898766", "云南省红河哈尼族彝族自治州",
"861350672", "浙江省湖州市",
"861554991", "湖北省咸宁市",
"861812444", "广东省茂名市",
"861534682", "甘肃省定西市",
"861776012", "四川省德阳市",
"86153398", "甘肃省兰州市",
"86180896", "贵州省遵义市",
"861508264", "四川省宜宾市",
"861530995", "新疆吐鲁番地区",
"861894694", "广东省梅州市",
"861539431", "浙江省宁波市",
"861809050", "四川省广安市",
"861593292", "江西省上饶市",
"861534304", "湖南省衡阳市",
"861770723", "湖北省武汉市",
"861313654", "浙江省湖州市",
"861354220", "广东省揭阳市",
"861473662", "云南省大理白族自治州",
"86153695", "河北省唐山市",
"861368728", "湖北省襄樊市",
"861848924", "西藏林芝地区",
"861770595", "福建省泉州市",
"86177358", "山西省吕梁市",
"861893322", "广东省广州市",
"861873567", "山西省运城市",
"861597688", "广东省深圳市",
"86184839", "四川省广元市",
"861474599", "黑龙江省大庆市",
"861389530", "宁夏银川市",
"861564959", "河南省驻马店市",
"861369861", "山东省济南市",
"861570954", "宁夏固原市",
"86187025", "江西省南昌市",
"861539320", "甘肃省定西市",
"861879214", "安徽省合肥市",
"861518196", "四川省泸州市",
"861560521", "江苏省徐州市",
"861857802", "广东省江门市",
"861303699", "广西北海市",
"861813089", "新疆乌鲁木齐市",
"861324908", "广东省深圳市",
"861872432", "黑龙江省黑河市",
"861308273", "山东省济南市",
"86137507", "浙江省嘉兴市",
"861571725", "湖北省黄冈市",
"861518677", "贵州省黔东南苗族侗族自治州",
"861567648", "广西百色市",
"861555387", "山东省威海市",
"861359818", "河南省洛阳市",
"861470972", "青海省海东地区",
"86176123", "重庆市",
"861340379", "河南省洛阳市",
"861871884", "广东省广州市",
"861367353", "河南省新乡市",
"861328663", "广东省江门市",
"861890819", "四川省成都市",
"861478397", "河南省新乡市",
"861366258", "广东省深圳市",
"861338230", "江苏省淮安市",
"861360629", "江苏省南通市",
"861311702", "湖北省黄石市",
"86130057", "广东省惠州市",
"861846450", "山东省烟台市",
"861700897", "广东省惠州市",
"861889059", "湖南省娄底市",
"86151506", "江苏省南京市",
"861885706", "浙江省舟山市",
"861538885", "云南省昭通市",
"861316530", "山东省菏泽市",
"861318075", "吉林省吉林市",
"861338871", "云南省昆明市",
"861859655", "福建省泉州市",
"861309539", "云南省保山市",
"861458967", "广东省汕尾市",
"861529860", "江苏省连云港市",
"861361068", "山西省临汾市",
"861335847", "福建省宁德市",
"861373392", "河南省平顶山市",
"86150765", "河北省唐山市",
"861508606", "贵州省遵义市",
"861810144", "江苏省扬州市",
"86183228", "江西省景德镇市",
"861532984", "贵州省黔南布依族苗族自治州",
"861844967", "新疆博尔塔拉蒙古自治州",
"861303856", "陕西省延安市",
"861518218", "四川省成都市",
"861530647", "山东省东营市",
"861303183", "河北省衡水市",
"86131265", "北京市",
"861331451", "黑龙江省哈尔滨市",
"861568535", "贵州省安顺市",
"861310841", "四川省德阳市",
"861452622", "江苏省苏州市",
"861571593", "福建省福州市",
"861357783", "云南省楚雄彝族自治州",
"861320520", "江苏省常州市",
"861587126", "湖北省孝感市",
"861510953", "宁夏吴忠市",
"86138523", "江苏省淮安市",
"86189557", "安徽省宿州市",
"861571872", "云南省大理白族自治州",
"861593665", "河南省安阳市",
"861302341", "江苏省南京市",
"861576787", "广东省广州市",
"861708346", "山西省长治市",
"861318123", "山东省临沂市",
"861857762", "广西柳州市",
"86147028", "四川省成都市",
"861528767", "云南省普洱市",
"861583249", "河北省石家庄市",
"86132601", "北京市",
"861379985", "福建省泉州市",
"861825042", "福建省泉州市",
"86150535", "山东省烟台市",
"861364678", "浙江省丽水市",
"861500619", "江苏省无锡市",
"861587138", "湖北省武汉市",
"861365392", "河南省鹤壁市",
"861318773", "云南省玉溪市",
"861470339", "河北省邢台市",
"861339903", "新疆和田地区",
"861340932", "河南省平顶山市",
"861534557", "安徽省宿州市",
"861476567", "广西南宁市",
"861860340", "山西省晋中市",
"861778031", "四川省宜宾市",
"861369701", "江西省赣州市",
"861841981", "甘肃省兰州市",
"861839541", "陕西省渭南市",
"861530419", "辽宁省辽阳市",
"861871492", "安徽省阜阳市",
"861333950", "黑龙江省大庆市",
"861709665", "浙江省宁波市",
"861760370", "河南省商丘市",
"86186479", "内蒙古锡林郭勒盟",
"861876662", "山东省东营市",
"861573829", "河南省信阳市",
"861802940", "广东省江门市",
"861837013", "江西省九江市",
"861323582", "浙江省湖州市",
"861592446", "内蒙古赤峰市",
"861459579", "陕西省咸阳市",
"861853983", "河南省焦作市",
"86183502", "福建省厦门市",
"861362074", "吉林省吉林市",
"86138974", "青海省西宁市",
"861557687", "湖南省张家界市",
"861565348", "山东省菏泽市",
"861572542", "山东省青岛市",
"861864870", "内蒙古呼和浩特市",
"861891943", "甘肃省白银市",
"861705525", "江苏省南京市",
"861333915", "安徽省巢湖市",
"86159750", "广东省江门市",
"861365653", "浙江省温州市",
"86189785", "广西贵港市",
"861336980", "新疆昌吉回族自治州",
"861898806", "云南省昆明市",
"861330743", "湖南省湘西土家族苗族自治州",
"861355096", "四川省广元市",
"861808376", "江苏省扬州市",
"861391287", "江苏省南通市",
"861560853", "贵州省安顺市",
"861860503", "福建省三明市",
"86159757", "广东省佛山市",
"861880263", "广东省河源市",
"861898876", "广东省深圳市",
"861341444", "广东省东莞市",
"861773678", "河北省沧州市",
"861389939", "新疆塔城地区",
"861360299", "广东省肇庆市",
"861880889", "云南省丽江市",
"861864800", "内蒙古鄂尔多斯市",
"861760996", "新疆巴音郭楞蒙古自治州",
"861502439", "浙江省金华市",
"861830347", "山西省临汾市",
"861860573", "浙江省嘉兴市",
"86187101", "北京市",
"861889429", "甘肃省陇南市",
"86180735", "湖南省郴州市",
"861527042", "江西省宜春市",
"861885138", "江苏省南通市",
"861363335", "河北省秦皇岛市",
"861570741", "湖南省怀化市",
"86134598", "福建省三明市",
"861326492", "湖北省恩施土家族苗族自治州",
"86183926", "陕西省西安市",
"861539964", "安徽省安庆市",
"861532639", "吉林省松原市",
"861812819", "广东省阳江市",
"861808990", "西藏拉萨市",
"861598496", "四川省凉山彝族自治州",
"861334255", "湖南省郴州市",
"861818377", "云南省西双版纳傣族自治州",
"861350251", "广东省揭阳市",
"861311825", "四川省广安市",
"861869824", "辽宁省铁岭市",
"861367222", "江西省南昌市",
"861339973", "新疆塔城地区",
"861327536", "山东省潍坊市",
"861892144", "江苏省南京市",
"861452292", "山西省晋中市",
"861535013", "江西省九江市",
"861874489", "贵州省铜仁地区",
"861526448", "山东省临沂市",
"861504697", "黑龙江省黑河市",
"861891456", "江苏省镇江市",
"86153702", "江苏省无锡市",
"86186318", "河北省衡水市",
"861860484", "内蒙古乌兰察布市",
"861569785", "江西省宜春市",
"861867348", "湖南省娄底市",
"861327098", "江苏省苏州市",
"861596097", "福建省南平市",
"861363957", "宁夏银川市",
"861315940", "福建省福州市",
"861760543", "山东省滨州市",
"861308391", "浙江省湖州市",
"861304095", "湖北省宜昌市",
"861454360", "山东省济南市",
"861855071", "江苏省淮安市",
"861592953", "陕西省安康市",
"86159585", "浙江省绍兴市",
"86189550", "安徽省滁州市",
"861334210", "辽宁省鞍山市",
"861871552", "安徽省蚌埠市",
"861814685", "陕西省安康市",
"861810992", "新疆伊犁哈萨克自治州",
"86186615", "山东省菏泽市",
"861378548", "河北省沧州市",
"861772852", "广东省惠州市",
"861308789", "贵州省遵义市",
"861329368", "山西省朔州市",
"861873648", "河南省三门峡市",
"86139065", "浙江省台州市",
"861356948", "河南省许昌市",
"861378864", "广西玉林市",
"861898942", "浙江省金华市",
"861399546", "宁夏石嘴山市",
"86139454", "黑龙江省佳木斯市",
"861352395", "河南省漯河市",
"861830758", "广东省肇庆市",
"861304525", "黑龙江省伊春市",
"861590534", "山东省德州市",
"861327528", "江苏省南通市",
"861596527", "山东省东营市",
"861882540", "广东省佛山市",
"861538476", "内蒙古赤峰市",
"861391958", "甘肃省庆阳市",
"861329437", "吉林省辽源市",
"861814396", "河南省驻马店市",
"861323854", "贵州省六盘水市",
"861520549", "山东省临沂市",
"86181939", "甘肃省陇南市",
"861772403", "广东省广州市",
"861479742", "山西省吕梁市",
"861862919", "陕西省西安市",
"86181706", "江西省吉安市",
"861379442", "广东省广州市",
"86187518", "江苏省南京市",
"861331591", "河北省邢台市",
"861587706", "广西玉林市",
"861775167", "江苏省连云港市",
"861571453", "黑龙江省牡丹江市",
"861867829", "山东省济南市",
"861569083", "河南省信阳市",
"861560472", "内蒙古包头市",
"861311772", "广西柳州市",
"86151922", "山东省烟台市",
"86130050", "海南省海口市",
"861819924", "新疆巴音郭楞蒙古自治州",
"861509111", "陕西省延安市",
"861536077", "广东省茂名市",
"861514226", "辽宁省朝阳市",
"861361746", "湖南省永州市",
"861535715", "安徽省六安市",
"861893365", "广东省清远市",
"861579498", "福建省厦门市",
"861319434", "吉林省四平市",
"861800319", "河北省邢台市",
"861583408", "山西省忻州市",
"861882303", "广东省梅州市",
"861314301", "河北省石家庄市",
"861537969", "宁夏中卫市",
"861878493", "四川省广元市",
"861894897", "广东省江门市",
"861518607", "贵州省毕节地区",
"861881231", "云南省普洱市",
"861313857", "广东省汕头市",
"861311122", "山西省大同市",
"861774011", "四川省广安市",
"861536681", "江苏省常州市",
"86183545", "山东省烟台市",
"861885126", "江苏省淮安市",
"861304793", "江西省上饶市",
"861380282", "广东省湛江市",
"861881870", "广东省深圳市",
"861470902", "新疆哈密地区",
"861817641", "广西桂林市",
"86177799", "江西省萍乡市",
"861503451", "山西省长治市",
"861560640", "山东省济南市",
"861833030", "河北省唐山市",
"86182729", "河南省驻马店市",
"861834429", "广东省深圳市",
"861327717", "湖北省宜昌市",
"861886533", "山东省淄博市",
"861318175", "山东省莱芜市",
"861813352", "河北省秦皇岛市",
"861305901", "黑龙江省哈尔滨市",
"861889159", "陕西省商洛市",
"86157708", "江西省赣州市",
"86151516", "江苏省苏州市",
"861890498", "辽宁省阜新市",
"861334939", "黑龙江省大庆市",
"861360397", "河南省信阳市",
"861580351", "山西省太原市",
"861571075", "广东省深圳市",
"861816604", "江西省南昌市",
"86187269", "安徽省六安市",
"861318946", "广东省湛江市",
"861392260", "广东省清远市",
"861869576", "福建省漳州市",
"861537342", "河北省石家庄市",
"861311803", "四川省泸州市",
"861318725", "湖南省郴州市",
"861368972", "吉林省四平市",
"861821920", "广东省深圳市",
"861459381", "贵州省六盘水市",
"861590878", "云南省楚雄彝族自治州",
"861500308", "新疆喀什地区",
"86188426", "辽宁省大连市",
"861850374", "河南省许昌市",
"861321430", "吉林省长春市",
"861459799", "新疆乌鲁木齐市",
"861879534", "宁夏固原市",
"861813693", "江苏省泰州市",
"861317714", "湖北省荆门市",
"861339068", "江苏省盐城市",
"861777656", "广西南宁市",
"86177860", "湖北省武汉市",
"861330145", "江苏省扬州市",
"861384973", "河南省信阳市",
"861337398", "河南省三门峡市",
"861818279", "黑龙江省双鸭山市",
"861372128", "安徽省宿州市",
"861354141", "四川省遂宁市",
"861303083", "福建省莆田市",
"86185563", "安徽省合肥市",
"86186642", "广东省佛山市",
"861369451", "黑龙江省哈尔滨市",
"861705573", "河南省郑州市",
"86189579", "浙江省金华市",
"861810044", "黑龙江省哈尔滨市",
"86152732", "湖南省湘潭市",
"861824988", "黑龙江省伊春市",
"861576949", "甘肃省陇南市",
"861313009", "辽宁省鞍山市",
"861450271", "内蒙古呼和浩特市",
"861330976", "青海省玉树藏族自治州",
"86136693", "甘肃省兰州市",
"861328251", "浙江省金华市",
"861306053", "广东省潮州市",
"861322959", "广东省惠州市",
"86155998", "新疆喀什地区",
"861321321", "河南省郑州市",
"861302997", "黑龙江省佳木斯市",
"861595490", "山东省济南市",
"861571773", "广西桂林市",
"861355804", "广西梧州市",
"861551317", "山西省忻州市",
"86152956", "江苏省苏州市",
"861778131", "四川省甘孜藏族自治州",
"861572213", "贵州省贵阳市",
"861806766", "浙江省绍兴市",
"861800678", "浙江省杭州市",
"861854568", "黑龙江省黑河市",
"861550604", "吉林省松原市",
"861323931", "甘肃省兰州市",
"861558549", "吉林省白山市",
"86189696", "浙江省台州市",
"861769614", "山西省临汾市",
"861361903", "四川省宜宾市",
"861825142", "江苏省盐城市",
"861576621", "广东省梅州市",
"861552459", "辽宁省大连市",
"86153770", "湖北省武汉市",
"861318872", "山东省临沂市",
"861890901", "四川省绵阳市",
"86152562", "安徽省合肥市",
"861334372", "河南省安阳市",
"861527613", "新疆喀什地区",
"861324486", "广东省深圳市",
"86185733", "湖南省株洲市",
"861475977", "福建省厦门市",
"861331701", "江西省鹰潭市",
"861320190", "陕西省咸阳市",
"86188889", "浙江省杭州市",
"861888120", "四川省攀枝花市",
"861830478", "内蒙古巴彦淖尔市",
"861855101", "江苏省连云港市",
"861390543", "山东省滨州市",
"861305498", "山东省济宁市",
"861861541", "山东省济南市",
"86178280", "四川省成都市",
"861306710", "福建省福州市",
"861831796", "江西省吉安市",
"86135117", "江苏省扬州市",
"861355196", "四川省广安市",
"861847818", "湖南省益阳市",
"86183577", "浙江省温州市",
"861458513", "河南省开封市",
"861317268", "河北省邢台市",
"861390996", "新疆巴音郭楞蒙古自治州",
"86188150", "浙江省温州市",
"86158185", "广东省深圳市",
"861586432", "山东省潍坊市",
"861587943", "江西省赣州市",
"861535470", "吉林省长春市",
"861316363", "黑龙江省绥化市",
"861862871", "吉林省松原市",
"861382457", "广东省梅州市",
"861594757", "内蒙古乌兰察布市",
"861818448", "贵州省遵义市",
"861896599", "福建省南平市",
"861535642", "浙江省湖州市",
"861846700", "青海省海北藏族自治州",
"86135172", "湖北省武汉市",
"86151321", "河北省石家庄市",
"861813914", "新疆阿克苏地区",
"861801282", "江苏省镇江市",
"861551930", "贵州省安顺市",
"861390300", "广东省广州市",
"861529999", "新疆克拉玛依市",
"861899741", "青海省西宁市",
"861519443", "河南省洛阳市",
"861311452", "黑龙江省齐齐哈尔市",
"861887154", "湖北省武汉市",
"861847666", "广东省湛江市",
"86131683", "广东省广州市",
"861471464", "广东省汕头市",
"861505670", "安徽省宿州市",
"861300800", "山西省运城市",
"861555289", "山东省济南市",
"861572924", "河南省濮阳市",
"861324875", "浙江省温州市",
"861812498", "广东省中山市",
"861806048", "福建省福州市",
"861707640", "山东省济南市",
"861524881", "内蒙古阿拉善盟",
"861840855", "贵州省黔东南苗族侗族自治州",
"861893489", "广西贵港市",
"861397308", "湖南省怀化市",
"861390370", "河南省商丘市",
"861885038", "福建省福州市",
"861304573", "浙江省嘉兴市",
"861526307", "山东省泰安市",
"861840810", "四川省成都市",
"861527142", "湖北省十堰市",
"86184689", "江苏省南京市",
"86182762", "广西柳州市",
"861473673", "云南省普洱市",
"86187111", "湖南省长沙市",
"86135110", "北京市",
"861311592", "福建省福州市",
"861834059", "辽宁省朝阳市",
"861887585", "浙江省丽水市",
"861370952", "宁夏石嘴山市",
"861535400", "河北省邯郸市",
"861472991", "陕西省延安市",
"861332088", "四川省绵阳市",
"86474", "内蒙古乌兰察布市",
"861816767", "新疆阿勒泰地区",
"86188157", "安徽省池州市",
"861513652", "河南省安阳市",
"861814254", "四川省绵阳市",
"86151495", "内蒙古鄂尔多斯市",
"861362896", "西藏那曲地区",
"861334302", "河北省保定市",
"86186605", "山东省烟台市",
"861358520", "江苏省南京市",
"861346547", "山东省济宁市",
"86153777", "广东省东莞市",
"861831824", "广东省阳江市",
"861361973", "青海省黄南藏族自治州",
"861519956", "新疆哈密地区",
"861394840", "内蒙古呼伦贝尔市",
"861890971", "青海省西宁市",
"861304484", "湖北省恩施土家族苗族自治州",
"861338919", "陕西省铜川市",
"861332211", "辽宁省鞍山市",
"861880651", "浙江省杭州市",
"861320345", "山西省长治市",
"861331771", "广西南宁市",
"861340618", "山东省滨州市",
"86186308", "天津市",
"861813223", "河北省邯郸市",
"861335236", "辽宁省朝阳市",
"861571703", "江西省上饶市",
"861305558", "福建省宁德市",
"861552599", "山西省长治市",
"861308262", "山东省济宁市",
"861334684", "河南省周口市",
"861800608", "福建省三明市",
"861807670", "广西柳州市",
"861324722", "湖北省恩施土家族苗族自治州",
"861313079", "辽宁省铁岭市",
"86152529", "江苏省镇江市",
"861450201", "河北省邯郸市",
"861450587", "辽宁省铁岭市",
"861775067", "福建省三明市",
"861552029", "四川省达州市",
"861808283", "新疆伊犁哈萨克自治州",
"861705503", "海南省海口市",
"861533263", "陕西省榆林市",
"86181716", "湖北省黄石市",
"86187508", "福建省三明市",
"861308947", "吉林省吉林市",
"861507543", "河北省张家口市",
"861848533", "贵州省安顺市",
"861573477", "内蒙古鄂尔多斯市",
"861330906", "四川省遂宁市",
"861318453", "江西省赣州市",
"861860525", "江苏省镇江市",
"861509288", "山东省临沂市",
"861583347", "河北省唐山市",
"861366749", "湖南省益阳市",
"861312543", "辽宁省沈阳市",
"861873897", "河南省开封市",
"861536859", "云南省普洱市",
"861595550", "安徽省滁州市",
"861889807", "西藏阿里地区",
"861330390", "河南省平顶山市",
"861786917", "云南省红河哈尼族彝族自治州",
"861812901", "新疆塔城地区",
"861826677", "山东省济宁市",
"861376920", "云南省大理白族自治州",
"86137354", "浙江省杭州市",
"861590808", "山东省济南市",
"861890558", "安徽省阜阳市",
"861311873", "云南省红河哈尼族彝族自治州",
"861869506", "湖北省宜昌市",
"861339925", "陕西省安康市",
"861569856", "山西省太原市",
"861339746", "湖南省永州市",
"86186450", "黑龙江省哈尔滨市",
"86156485", "内蒙古通辽市",
"861370314", "河北省承德市",
"861530734", "湖南省衡阳市",
"861839435", "甘肃省平凉市",
"861536727", "湖南省郴州市",
"861597231", "湖北省鄂州市",
"861563539", "山西省太原市",
"861500378", "河南省开封市",
"861364319", "河北省邢台市",
"86155763", "湖南省娄底市",
"861850682", "浙江省杭州市",
"86182532", "山东省青岛市",
"86159779", "广西玉林市",
"861830991", "新疆乌鲁木齐市",
"861318105", "山东省聊城市",
"861599132", "陕西省安康市",
"861312300", "福建省泉州市",
"86137935", "山东省烟台市",
"861351631", "山东省威海市",
"861809635", "四川省巴中市",
"86152258", "河南省焦作市",
"861509011", "河南省南阳市",
"861860793", "江西省上饶市",
"861536177", "广东省广州市",
"861899954", "新疆昌吉回族自治州",
"861806876", "江苏省常州市",
"86159925", "广东省揭阳市",
"861340706", "江西省吉安市",
"861571863", "贵州省安顺市",
"861307046", "新疆克拉玛依市",
"861868531", "贵州省黔南布依族苗族自治州",
"86132016", "陕西省西安市",
"861323464", "黑龙江省齐齐哈尔市",
"861896306", "山东省济南市",
"861768710", "云南省昆明市",
"861599143", "陕西省西安市",
"86185511", "江苏省苏州市",
"861365730", "湖南省岳阳市",
"86133227", "广东省汕头市",
"861771141", "四川省南充市",
"861562823", "新疆和田地区",
"86133171", "湖北省武汉市",
"861831297", "浙江省宁波市",
"861318762", "云南省文山壮族苗族自治州",
"86137510", "广东省深圳市",
"861356142", "山东省潍坊市",
"861768755", "广西玉林市",
"861898148", "四川省达州市",
"861361349", "山西省朔州市",
"861537711", "湖北省黄冈市",
"861803723", "河南省周口市",
"861512046", "甘肃省临夏回族自治州",
"86184023", "重庆市",
"861454542", "新疆昌吉回族自治州",
"86183586", "浙江省台州市",
"861781730", "广东省江门市",
"861779738", "青海省海南藏族自治州",
"861814381", "西藏拉萨市",
"861477170", "湖北省鄂州市",
"861368008", "广东省韶关市",
"861556198", "黑龙江省七台河市",
"861838881", "云南省丽江市",
"861811438", "江苏省南通市",
"861308695", "贵州省黔东南苗族侗族自治州",
"861862761", "湖南省娄底市",
"861786502", "山东省菏泽市",
"861700567", "浙江省金华市",
"861313467", "山西省临汾市",
"861814799", "内蒙古锡林郭勒盟",
"861826196", "江苏省镇江市",
"861848542", "贵州省黔南布依族苗族自治州",
"861311928", "陕西省榆林市",
"861300760", "河南省郑州市",
"861508097", "湖南省岳阳市",
"861785836", "浙江省湖州市",
"861501818", "广东省珠海市",
"861477720", "广西柳州市",
"861388668", "湖北省宜昌市",
"861313326", "山西省临汾市",
"861528059", "福建省三明市",
"861312532", "江西省抚州市",
"861840389", "黑龙江省哈尔滨市",
"861523473", "山西省运城市",
"861310313", "河北省张家口市",
"861840791", "江西省南昌市",
"861308386", "河南省安阳市",
"861322515", "江苏省盐城市",
"86139229", "广东省东莞市",
"861872660", "安徽省阜阳市",
"861806942", "浙江省杭州市",
"861892717", "广东省云浮市",
"861311936", "甘肃省张掖市",
"861521707", "广东省东莞市",
"86150907", "湖北省荆州市",
"861524004", "安徽省芜湖市",
"861779945", "新疆巴音郭楞蒙古自治州",
"861883844", "河南省商丘市",
"861356845", "四川省巴中市",
"86130591", "广东省广州市",
"86177472", "内蒙古包头市",
"861811426", "江苏省宿迁市",
"861787649", "广东省深圳市",
"861470963", "宁夏吴忠市",
"861573394", "河北省承德市",
"861590768", "广东省潮州市",
"861565069", "安徽省宿州市",
"861533937", "甘肃省酒泉市",
"861328672", "广东省河源市",
"861811367", "四川省眉山市",
"861768053", "湖南省郴州市",
"861322550", "安徽省滁州市",
"86151582", "浙江省绍兴市",
"861450652", "黑龙江省黑河市",
"86184590", "福建省泉州市",
"861785828", "浙江省台州市",
"86177417", "辽宁省营口市",
"861332982", "湖北省恩施土家族苗族自治州",
"861370058", "山西省临汾市",
"86131062", "浙江省金华市",
"861596676", "山东省临沂市",
"861313338", "山西省吕梁市",
"861348719", "湖北省孝感市",
"861863449", "山西省运城市",
"861770705", "江西省宜春市",
"861879146", "陕西省汉中市",
"861341971", "河南省驻马店市",
"86157392", "新疆阿克苏地区",
"861778611", "湖北省武汉市",
"861536385", "广东省惠州市",
"861334530", "新疆塔城地区",
"861533310", "河北省邯郸市",
"861372616", "广东省江门市",
"86187414", "辽宁省本溪市",
"861850557", "安徽省宿州市",
"861550807", "四川省泸州市",
"861889767", "广西钦州市",
"86159546", "山东省东营市",
"861769134", "陕西省西安市",
"861761422", "辽宁省鞍山市",
"861533355", "山西省长治市",
"861570831", "四川省宜宾市",
"8618019", "上海市",
"861879975", "新疆石河子市",
"861527133", "湖北省随州市",
"861327216", "湖南省益阳市",
"86139558", "安徽省阜阳市",
"86132663", "广东省佛山市",
"861776815", "江苏省宿迁市",
"861850497", "内蒙古呼和浩特市",
"861329049", "河北省邢台市",
"861808779", "云南省玉溪市",
"861831627", "广东省阳江市",
"861879905", "新疆昌吉回族自治州",
"861474129", "辽宁省锦州市",
"861809812", "广东省潮州市",
"86188098", "辽宁省沈阳市",
"86145021", "河北省石家庄市",
"861384836", "内蒙古赤峰市",
"861378024", "河北省保定市",
"861586443", "山东省菏泽市",
"861339247", "广东省广州市",
"86181291", "新疆喀什地区",
"861808129", "四川省遂宁市",
"861341901", "四川省德阳市",
"861817190", "湖北省宜昌市",
"861359950", "福建省厦门市",
"861770775", "广西玉林市",
"861803968", "河南省南阳市",
"861869781", "青海省海西蒙古族藏族自治州",
"861380157", "江苏省苏州市",
"861360474", "内蒙古呼伦贝尔市",
"86136317", "广东省东莞市",
"86181782", "广西柳州市",
"861776850", "江苏省无锡市",
"861511774", "贵州省铜仁地区",
"861345889", "四川省内江市",
"861839983", "新疆石河子市",
"861869399", "甘肃省兰州市",
"861519432", "山东省枣庄市",
"861550877", "云南省玉溪市",
"861370436", "吉林省长春市",
"861528429", "河北省邢台市",
"861311763", "广西桂林市",
"861560463", "黑龙江省牡丹江市",
"861842022", "广东省阳江市",
"861597760", "广西百色市",
"861596606", "山东省济南市",
"861841996", "甘肃省天水市",
"86177410", "辽宁省沈阳市",
"861301310", "安徽省马鞍山市",
"861786893", "云南省玉溪市",
"86189746", "湖南省永州市",
"86184597", "福建省龙岩市",
"861550266", "辽宁省锦州市",
"861870745", "湖南省怀化市",
"861779106", "陕西省汉中市",
"861470736", "湖南省常德市",
"861360583", "浙江省嘉兴市",
"861891207", "江苏省淮安市",
"861526882", "浙江省杭州市",
"86139824", "四川省泸州市",
"861563317", "河北省沧州市",
"861364537", "山东省济宁市",
"861554347", "吉林省辽源市",
"861585679", "安徽省阜阳市",
"861376364", "黑龙江省鸡西市",
"861390532", "山东省青岛市",
"861308225", "辽宁省鞍山市",
"86135632", "山东省枣庄市",
"861859351", "福建省宁德市",
"861524074", "广西河池市",
"861708749", "湖南省邵阳市",
"861335737", "湖南省益阳市",
"861324765", "广东省广州市",
"861870938", "甘肃省天水市",
"861470728", "湖北省十堰市",
"861338510", "贵州省贵阳市",
"861370428", "辽宁省大连市",
"861860562", "安徽省铜陵市",
"86131029", "河北省保定市",
"861313285", "广西玉林市",
"861863208", "河北省邢台市",
"861810717", "湖北省宜昌市",
"861332445", "吉林省通化市",
"861770822", "广东省汕头市",
"86155711", "湖北省襄樊市",
"861587379", "湖南省邵阳市",
"861776112", "四川省宜宾市",
"861803410", "河北省邯郸市",
"861338555", "贵州省黔东南苗族侗族自治州",
"861310731", "湖南省长沙市",
"86186792", "江西省九江市",
"861806194", "江苏省苏州市",
"86139262", "广东省广州市",
"861477100", "湖北省襄樊市",
"861599612", "江苏省连云港市",
"861882787", "江西省赣州市",
"86186281", "四川省成都市",
"861884620", "黑龙江省齐齐哈尔市",
"861351111", "湖南省益阳市",
"86150371", "河南省郑州市",
"861775409", "安徽省合肥市",
"861816877", "江苏省徐州市",
"861590923", "陕西省宝鸡市",
"861302645", "四川省德阳市",
"861593361", "河北省石家庄市",
"861317047", "湖南省长沙市",
"861339962", "安徽省铜陵市",
"86137517", "广东省广州市",
"861568215", "四川省南充市",
"861340126", "江苏省连云港市",
"86133220", "海南省海口市",
"861889382", "甘肃省兰州市",
"861886542", "山东省青岛市",
"861813189", "河北省承德市",
"861321673", "浙江省嘉兴市",
"861397039", "江西省景德镇市",
"861331861", "广东省清远市",
"861311065", "福建省漳州市",
"861869064", "新疆阿勒泰地区",
"86138551", "安徽省合肥市",
"861892198", "江苏省苏州市",
"861824082", "陕西省榆林市",
"861357377", "山东省济南市",
"861340776", "广西河池市",
"861816159", "宁夏银川市",
"861378594", "河北省衡水市",
"861355764", "广西梧州市",
"861568250", "四川省遂宁市",
"861326721", "广东省深圳市",
"861575930", "福建省宁德市",
"861857703", "广西南宁市",
"86137572", "浙江省湖州市",
"861896376", "安徽省六安市",
"861327044", "江苏省南京市",
"861881688", "广东省深圳市",
"861518538", "贵州省安顺市",
"861826874", "浙江省舟山市",
"861588411", "四川省宜宾市",
"861333818", "江苏省常州市",
"861589075", "河南省安阳市",
"861890490", "辽宁省铁岭市",
"861500996", "新疆吐鲁番地区",
"861532977", "贵州省毕节地区",
"861365227", "广东省佛山市",
"86189918", "陕西省西安市",
"861576667", "广东省茂名市",
"861820313", "河北省张家口市",
"861852423", "辽宁省抚顺市",
"861528687", "河南省驻马店市",
"86183401", "辽宁省沈阳市",
"861894853", "广东省阳江市",
"861872547", "云南省曲靖市",
"861537734", "湖南省衡阳市",
"861321438", "吉林省松原市",
"861399957", "新疆伊犁哈萨克自治州",
"861528071", "福建省三明市",
"86188302", "河北省保定市",
"861301054", "广东省深圳市",
"861355363", "广东省韶关市",
"861392268", "广东省揭阳市",
"861821928", "广东省佛山市",
"861324799", "江西省萍乡市",
"861597808", "广西百色市",
"861590870", "云南省昭通市",
"861459102", "广西防城港市",
"861871877", "广东省深圳市",
"861372120", "安徽省芜湖市",
"861304829", "广东省梅州市",
"86137289", "广东省深圳市",
"861831489", "浙江省杭州市",
"861847152", "湖北省黄石市",
"861881534", "山东省德州市",
"86134622", "河南省新乡市",
"861534802", "甘肃省定西市",
"861325645", "山东省烟台市",
"861595498", "山东省烟台市",
"861500543", "山东省滨州市",
"86181016", "上海市",
"861813464", "安徽省阜阳市",
"861571497", "新疆乌鲁木齐市",
"861824980", "黑龙江省伊春市",
"861457201", "四川省成都市",
"861535249", "甘肃省张掖市",
"861869365", "甘肃省武威市",
"861854560", "黑龙江省齐齐哈尔市",
"861800670", "浙江省宁波市",
"861557674", "湖南省衡阳市",
"861336359", "山西省运城市",
"861587030", "贵州省六盘水市",
"861593083", "河北省衡水市",
"86181663", "重庆市",
"861311529", "江苏省常州市",
"86153681", "云南省昆明市",
"861830642", "山东省青岛市",
"861580456", "黑龙江省黑河市",
"86153012", "北京市",
"861533424", "湖北省襄樊市",
"861589773", "湖北省孝感市",
"861333389", "河南省洛阳市",
"861888128", "四川省广元市",
"861596053", "福建省莆田市",
"861830470", "内蒙古呼伦贝尔市",
"861327345", "河北省邢台市",
"861453813", "四川省成都市",
"861305490", "山东省临沂市",
"861333791", "江苏省无锡市",
"861362671", "浙江省杭州市",
"861359786", "湖北省十堰市",
"861534453", "黑龙江省牡丹江市",
"861802133", "江苏省扬州市",
"861804222", "浙江省金华市",
"86135478", "四川省成都市",
"86184848", "贵州省黔西南布依族苗族自治州",
"86135951", "贵州省贵阳市",
"861317260", "广东省肇庆市",
"861313572", "湖北省十堰市",
"861700472", "内蒙古包头市",
"861553336", "河北省石家庄市",
"861535478", "吉林省松原市",
"861818672", "湖北省武汉市",
"861859309", "甘肃省兰州市",
"861880585", "浙江省绍兴市",
"86188359", "山西省运城市",
"86182062", "江苏省苏州市",
"861778634", "湖北省荆州市",
"861847810", "湖南省常德市",
"861576774", "广东省梅州市",
"861390308", "广东省揭阳市",
"861357663", "江西省吉安市",
"86151874", "云南省曲靖市",
"861511373", "广东省清远市",
"861860407", "辽宁省营口市",
"861821936", "广东省梅州市",
"861505678", "安徽省阜阳市",
"861576124", "贵州省黔南布依族苗族自治州",
"861818440", "贵州省毕节地区",
"861846708", "青海省西宁市",
"861700640", "山东省青岛市",
"861570814", "四川省自贡市",
"861366904", "湖北省黄石市",
"861350554", "安徽省淮南市",
"86155616", "黑龙江省黑河市",
"861321426", "辽宁省沈阳市",
"861777162", "湖北省荆州市",
"861551938", "贵州省铜仁地区",
"861534946", "甘肃省天水市",
"861550721", "湖北省荆州市",
"861860477", "内蒙古鄂尔多斯市",
"861567086", "河南省焦作市",
"861880154", "江苏省苏州市",
"86188345", "山西省长治市",
"861301424", "宁夏吴忠市",
"861840666", "广东省深圳市",
"861337842", "广东省深圳市",
"861511303", "广东省佛山市",
"86153994", "陕西省西安市",
"861390378", "河南省开封市",
"861885030", "福建省厦门市",
"861315133", "江苏省淮安市",
"861534725", "湖北省荆州市",
"86151279", "河北省邢台市",
"861300808", "山西省大同市",
"86150123", "云南省昭通市",
"861812490", "广东省广州市",
"861565095", "青海省果洛藏族自治州",
"861806040", "福建省宁德市",
"861707648", "山东省临沂市",
"861347207", "河北省承德市",
"86187957", "江苏省南通市",
"861818602", "湖北省黄冈市",
"861594892", "吉林省白城市",
"86134146", "广东省惠州市",
"861700402", "广东省广州市",
"861580943", "甘肃省白银市",
"861332080", "四川省自贡市",
"861786467", "山东省莱芜市",
"861535408", "河北省衡水市",
"861365697", "福建省南平市",
"861313502", "湖南省湘潭市",
"86135319", "广东省揭阳市",
"861840818", "四川省德阳市",
"861595971", "福建省龙岩市",
"861576704", "广东省云浮市",
"86138264", "广东省广州市",
"861309132", "河北省张家口市",
"86130779", "江西省南昌市",
"861560897", "西藏阿里地区",
"86188911", "陕西省延安市",
"861705757", "广东省佛山市",
"86134669", "山西省运城市",
"861580596", "福建省泉州市",
"861870539", "山东省临沂市",
"861391204", "江苏省徐州市",
"861340610", "山东省东营市",
"86185033", "河北省秦皇岛市",
"861305515", "湖南省湘潭市",
"86177954", "宁夏固原市",
"861520613", "江苏省苏州市",
"861358528", "江苏省连云港市",
"86183803", "四川省成都市",
"861362601", "福建省三明市",
"861394848", "内蒙古乌兰察布市",
"861536761", "湖南省娄底市",
"861888708", "云南省西双版纳傣族自治州",
"86189216", "江苏省南通市",
"861534593", "福建省莆田市",
"861708535", "山东省烟台市",
"861807678", "广西桂林市",
"861800600", "福建省厦门市",
"861850863", "湖北省武汉市",
"861589703", "青海省黄南藏族自治州",
"861760447", "吉林省辽源市",
"86177335", "河北省秦皇岛市",
"861305550", "福建省厦门市",
"861814063", "湖北省黄石市",
"861518372", "四川省阿坝藏族羌族自治州",
"86136213", "北京市",
"861852710", "湖北省武汉市",
"861453645", "江苏省苏州市",
"861534872", "云南省大理白族自治州",
"861350882", "云南省大理白族自治州",
"861329533", "山东省淄博市",
"861337976", "新疆巴音郭楞蒙古自治州",
"861358536", "江苏省徐州市",
"861859932", "新疆哈密地区",
"861816721", "浙江省宁波市",
"86155241", "辽宁省沈阳市",
"861817044", "江西省抚州市",
"861535991", "福建省龙岩市",
"861800985", "辽宁省盘锦市",
"861309835", "湖北省咸宁市",
"861816171", "陕西省延安市",
"861571557", "安徽省宿州市",
"861871807", "广东省揭阳市",
"861330398", "河南省三门峡市",
"861811673", "四川省遂宁市",
"861770656", "浙江省绍兴市",
"861562970", "湖北省黄石市",
"861459172", "内蒙古呼和浩特市",
"861376928", "云南省楚雄彝族自治州",
"861337145", "山东省潍坊市",
"861510997", "新疆阿克苏地区",
"861310714", "湖南省张家界市",
"861568839", "新疆伊犁哈萨克自治州",
"861772281", "广东省深圳市",
"861595558", "安徽省阜阳市",
"861820731", "湖南省长沙市",
"861857374", "湖南省郴州市",
"861594573", "黑龙江省牡丹江市",
"861500370", "河南省商丘市",
"861338469", "黑龙江省双鸭山市",
"861700186", "北京市",
"861826255", "江苏省镇江市",
"861804353", "吉林省长春市",
"861890550", "安徽省滁州市",
"861590800", "山东省潍坊市",
"861530342", "山西省大同市",
"861321782", "广西来宾市",
"86151633", "山东省日照市",
"861558042", "湖南省郴州市",
"861532907", "贵州省毕节地区",
"861478353", "河南省焦作市",
"861452327", "河南省平顶山市",
"861367397", "河南省郑州市",
"861538589", "安徽省合肥市",
"861588434", "四川省眉山市",
"86157008", "湖南省岳阳市",
"86138135", "江苏省常州市",
"861803324", "广东省佛山市",
"861700853", "贵州省安顺市",
"861573095", "甘肃省平凉市",
"86138822", "四川省成都市",
"861312308", "福建省龙岩市",
"861862385", "河南省商丘市",
"86182029", "陕西省西安市",
"861520994", "新疆昌吉回族自治州",
"861837249", "湖北省十堰市",
"86133952", "江苏省徐州市",
"861470413", "辽宁省抚顺市",
"861308481", "陕西省安康市",
"861373945", "四川省成都市",
"861823009", "河北省邢台市",
"861334526", "山东省潍坊市",
"861314988", "辽宁省大连市",
"86130546", "山东省东营市",
"861768718", "云南省丽江市",
"861850703", "江西省上饶市",
"861534387", "河南省平顶山市",
"861558033", "湖南省衡阳市",
"861338077", "广东省梅州市",
"861347776", "湖北省咸宁市",
"861530333", "河北省张家口市",
"861589289", "四川省德阳市",
"861350377", "河南省南阳市",
"861770899", "西藏拉萨市",
"86150558", "安徽省阜阳市",
"861323693", "辽宁省大连市",
"861338681", "辽宁省盘锦市",
"86185459", "黑龙江省大庆市",
"861369479", "内蒙古锡林郭勒盟",
"861373176", "河北省秦皇岛市",
"861898140", "四川省内江市",
"861538675", "山西省朔州市",
"861874781", "内蒙古巴彦淖尔市",
"861380523", "江苏省淮安市",
"861358992", "山东省德州市",
"861345424", "浙江省台州市",
"861508561", "贵州省遵义市",
"861322971", "广东省云浮市",
"861888616", "贵州省安顺市",
"861860394", "河南省周口市",
"86158933", "河南省南阳市",
"861365738", "湖南省娄底市",
"861390039", "辽宁省辽阳市",
"861347126", "广西桂林市",
"861522985", "陕西省榆林市",
"861376873", "广西桂林市",
"86180232", "广东省汕头市",
"861843842", "河南省漯河市",
"861808895", "云南省文山壮族苗族自治州",
"861877043", "江西省上饶市",
"861329542", "山东省青岛市",
"861310047", "广西贵港市",
"861326382", "广西柳州市",
"86159591", "福建省福州市",
"861859943", "新疆乌鲁木齐市",
"86136043", "吉林省长春市",
"861336476", "新疆乌鲁木齐市",
"86151173", "贵州省黔西南布依族苗族自治州",
"861398527", "贵州省黔东南苗族侗族自治州",
"861380795", "江西省宜春市",
"861354847", "四川省广元市",
"861521553", "安徽省芜湖市",
"861821803", "广东省东莞市",
"86138378", "河南省开封市",
"861363817", "贵州省毕节地区",
"86150229", "新疆乌鲁木齐市",
"861598386", "四川省达州市",
"861802994", "广东省揭阳市",
"861558948", "山东省聊城市",
"861772912", "陕西省榆林市",
"861781738", "广东省湛江市",
"861576864", "广东省惠州市",
"86176910", "陕西省西安市",
"861879511", "宁夏银川市",
"861779730", "青海省海东地区",
"861368000", "广东省清远市",
"861317731", "湖北省黄石市",
"861477178", "湖北省恩施土家族苗族自治州",
"861501855", "广东省湛江市",
"861528884", "山东省济南市",
"86155682", "吉林省吉林市",
"861556190", "黑龙江省双鸭山市",
"861811430", "江苏省常州市",
"86139907", "四川省南充市",
"86155011", "北京市",
"861580379", "河南省洛阳市",
"861817717", "广西崇左市",
"861315845", "四川省绵阳市",
"861452083", "安徽省芜湖市",
"861889721", "青海省西宁市",
"861867562", "广东省珠海市",
"86138675", "浙江省绍兴市",
"861335041", "四川省乐山市",
"861323352", "山西省大同市",
"861362252", "广东省佛山市",
"861300768", "河南省漯河市",
"861510645", "山东省烟台市",
"861887272", "湖北省黄冈市",
"861501810", "广东省潮州市",
"861389874", "辽宁省营口市",
"861863831", "河南省新乡市",
"861388660", "湖北省荆州市",
"861814805", "四川省广安市",
"861370015", "辽宁省丹东市",
"861598695", "广东省惠州市",
"861869322", "甘肃省定西市",
"861781726", "广东省韶关市",
"861323914", "陕西省商洛市",
"861558735", "山东省烟台市",
"861872668", "安徽省亳州市",
"861393861", "河南省开封市",
"861516703", "浙江省绍兴市",
"861862859", "陕西省咸阳市",
"861805039", "福建省南平市",
"861843145", "河北省唐山市",
"861571682", "河北省邯郸市",
"861821452", "云南省临沧市",
"86182683", "浙江省嘉兴市",
"861571304", "河北省承德市",
"861872816", "四川省雅安市",
"861477736", "广西百色市",
"861893164", "河北省廊坊市",
"861785820", "浙江省衢州市",
"861370050", "山西省太原市",
"861313330", "山西省晋中市",
"861570617", "江苏省镇江市",
"861590760", "广东省中山市",
"861322558", "安徽省阜阳市",
"86136119", "上海市",
"861557877", "广西河池市",
"861337833", "四川省乐山市",
"861315142", "江苏省南京市",
"861313917", "青海省海西蒙古族藏族自治州",
"861840204", "广东省佛山市",
"861567191", "湖北省十堰市",
"861806221", "湖北省黄冈市",
"861367474", "内蒙古呼和浩特市",
"86130925", "江苏省常州市",
"86181082", "四川省成都市",
"861874064", "陕西省西安市",
"861380093", "甘肃省临夏回族自治州",
"861533318", "河北省衡水市",
"861334538", "新疆和田地区",
"86185402", "辽宁省沈阳市",
"86133736", "江苏省无锡市",
"86145721", "陕西省西安市",
"86188798", "江西省景德镇市",
"861569292", "四川省乐山市",
"861580932", "甘肃省定西市",
"861313421", "辽宁省朝阳市",
"861334096", "四川省成都市",
"861309143", "黑龙江省哈尔滨市",
"861777125", "湖北省宜昌市",
"86133909", "江苏省南通市",
"861452785", "新疆吐鲁番地区",
"861813931", "新疆吐鲁番地区",
"861362323", "河北省张家口市",
"861573562", "山西省太原市",
"861534762", "广东省汕尾市",
"861358144", "湖北省襄樊市",
"861593327", "河北省沧州市",
"861570208", "广东省茂名市",
"861855159", "江苏省镇江市",
"861522442", "山东省青岛市",
"861880679", "浙江省金华市",
"861316764", "安徽省黄山市",
"861476086", "江苏省南通市",
"861459063", "广东省肇庆市",
"861331759", "湖北省随州市",
"861524187", "辽宁省阜新市",
"861898686", "湖北省恩施土家族苗族自治州",
"861373482", "内蒙古兴安盟",
"861351546", "山东省东营市",
"861557807", "广西南宁市",
"861359958", "福建省漳州市",
"861817198", "湖北省荆门市",
"861538980", "内蒙古呼和浩特市",
"861572437", "辽宁省盘锦市",
"861473056", "河北省保定市",
"861810345", "山西省长治市",
"861396556", "安徽省阜阳市",
"861776858", "江苏省连云港市",
"861332234", "辽宁省辽阳市",
"861301318", "安徽省安庆市",
"861351993", "新疆石河子市",
"861571374", "河南省许昌市",
"861514495", "内蒙古通辽市",
"861865191", "江苏省盐城市",
"861830633", "山东省日照市",
"861768197", "浙江省温州市",
"861514184", "辽宁省阜新市",
"861378787", "湖南省常德市",
"861510813", "四川省资阳市",
"861326767", "广东省江门市",
"861339412", "辽宁省鞍山市",
"861597768", "广西南宁市",
"86152801", "福建省福州市",
"86139371", "河南省郑州市",
"861477963", "江西省抚州市",
"861778580", "贵州省贵阳市",
"861893297", "河北省邢台市",
"861333152", "吉林省松原市",
"861300923", "辽宁省本溪市",
"861331827", "广东省中山市",
"86158598", "福建省三明市",
"861582883", "四川省内江市",
"861303361", "浙江省杭州市",
"861314257", "湖南省邵阳市",
"861365894", "西藏林芝地区",
"861802142", "江苏省无锡市",
"861303916", "吉林省吉林市",
"861800433", "吉林省延边朝鲜族自治州",
"861309612", "四川省绵阳市",
"861560694", "福建省福州市",
"86188963", "云南省文山壮族苗族自治州",
"861370420", "辽宁省鞍山市",
"86131532", "山东省青岛市",
"861809158", "陕西省西安市",
"861833618", "河南省驻马店市",
"861705169", "山东省济南市",
"861870930", "甘肃省临夏回族自治州",
"861338518", "贵州省黔南布依族苗族自治州",
"861801461", "江苏省连云港市",
"861470720", "湖北省宜昌市",
"861511949", "广东省阳江市",
"861521493", "新疆和田地区",
"861884628", "黑龙江省大庆市",
"861705256", "河北省石家庄市",
"861821873", "广东省湛江市",
"861500532", "山东省青岛市",
"861305959", "广东省清远市",
"861780921", "陕西省延安市",
"861707567", "安徽省阜阳市",
"86139900", "四川省自贡市",
"861366535", "山东省烟台市",
"861803418", "河北省衡水市",
"861477108", "湖北省荆门市",
"861556345", "山东省青岛市",
"861801575", "四川省泸州市",
"861808944", "甘肃省天水市",
"86181246", "广东省深圳市",
"861831661", "广东省广州市",
"861563926", "河南省郑州市",
"861333855", "福建省南平市",
"861370331", "河北省石家庄市",
"86189791", "江西省南昌市",
"861313051", "辽宁省丹东市",
"86189282", "广东省东莞市",
"861373106", "河北省邢台市",
"861365482", "内蒙古兴安盟",
"861892190", "江苏省扬州市",
"861560913", "陕西省渭南市",
"861802845", "广东省惠州市",
"86138419", "辽宁省辽阳市",
"861774817", "四川省南充市",
"861376803", "广西桂林市",
"861328209", "浙江省衢州市",
"861823079", "贵州省毕节地区",
"861315994", "黑龙江省大庆市",
"861881680", "广东省广州市",
"861518530", "贵州省遵义市",
"861336885", "云南省昆明市",
"86132716", "河南省周口市",
"861516075", "福建省泉州市",
"861591937", "广东省惠州市",
"861871604", "河北省秦皇岛市",
"861536871", "云南省昆明市",
"861333810", "江苏省无锡市",
"861300046", "北京市",
"861568258", "四川省凉山彝族自治州",
"861575938", "福建省莆田市",
"861850773", "广西桂林市",
"861859456", "福建省龙岩市",
"861870317", "河北省沧州市",
"861877143", "湖北省随州市",
"861866639", "广东省佛山市",
"861300905", "吉林省松原市",
"861855429", "山东省威海市",
"861338727", "湖北省宜昌市",
"861301679", "江苏省南通市",
"861840950", "宁夏吴忠市",
"861810520", "江苏省徐州市",
"861355939", "福建省莆田市",
"861550552", "安徽省蚌埠市",
"861373076", "四川省内江市",
"861370812", "四川省绵阳市",
"861593229", "河北省邢台市",
"86187725", "湖北省黄冈市",
"861352524", "河南省三门峡市",
"861331479", "内蒙古锡林郭勒盟",
"861840915", "陕西省安康市",
"861700191", "广东省深圳市",
"861770418", "辽宁省阜新市",
"861590688", "浙江省丽水市",
"86132344", "吉林省长春市",
"861352369", "河南省周口市",
"861777595", "湖南省永州市",
"861368413", "四川省资阳市",
"861304394", "河南省周口市",
"861506947", "山东省枣庄市",
"861700463", "上海市",
"861599930", "新疆喀什地区",
"861394945", "河南省平顶山市",
"861313563", "湖北省孝感市",
"861809436", "江苏省南通市",
"861591272", "云南省文山壮族苗族自治州",
"86139972", "青海省西宁市",
"861880318", "河北省衡水市",
"861309745", "云南省昭通市",
"86177571", "浙江省杭州市",
"861303622", "江西省鹰潭市",
"86130492", "广东省揭阳市",
"861340351", "山西省太原市",
"861335141", "黑龙江省哈尔滨市",
"861826530", "山东省菏泽市",
"861452183", "吉林省吉林市",
"861890235", "广东省清远市",
"861828075", "四川省绵阳市",
"86183463", "黑龙江省牡丹江市",
"86139917", "陕西省宝鸡市",
"86155001", "吉林省四平市",
"861537995", "甘肃省甘南藏族自治州",
"861323205", "广东省韶关市",
"861452856", "甘肃省兰州市",
"861477078", "江西省抚州市",
"861858260", "四川省广安市",
"861470000", "福建省福州市",
"861787513", "广东省梅州市",
"86151481", "内蒙古赤峰市",
"861533609", "甘肃省陇南市",
"861777173", "湖北省武汉市",
"861535986", "福建省厦门市",
"861314359", "广东省佛山市",
"861310147", "福建省宁德市",
"861318304", "河南省商丘市",
"861831322", "云南省西双版纳傣族自治州",
"861847501", "广东省江门市",
"861309938", "甘肃省张掖市",
"861508423", "辽宁省朝阳市",
"861800888", "云南省丽江市",
"861380461", "黑龙江省哈尔滨市",
"861370150", "江苏省常州市",
"861394738", "内蒙古巴彦淖尔市",
"861459551", "青海省西宁市",
"861346432", "辽宁省锦州市",
"861331248", "贵州省毕节地区",
"86134185", "广东省深圳市",
"861556520", "河南省鹤壁市",
"861347943", "江西省抚州市",
"861809428", "江苏省苏州市",
"861516802", "浙江省丽水市",
"861770960", "安徽省滁州市",
"861805139", "江苏省盐城市",
"861580207", "广东省汕头市",
"861778014", "四川省自贡市",
"861580581", "浙江省杭州市",
"861538623", "湖南省株洲市",
"86188386", "河南省南阳市",
"86138640", "山东省济南市",
"86150151", "广东省东莞市",
"86176371", "河南省郑州市",
"861376825", "广西玉林市",
"861318682", "浙江省温州市",
"861839628", "福建省漳州市",
"861501786", "广东省东莞市",
"861339820", "四川省宜宾市",
"861862681", "浙江省温州市",
"86182134", "云南省昆明市",
"861337732", "广西桂林市",
"861850453", "黑龙江省牡丹江市",
"86133919", "北京市",
"86185477", "内蒙古鄂尔多斯市",
"861328307", "河南省信阳市",
"861891284", "江苏省镇江市",
"86159198", "广东省深圳市",
"861330480", "黑龙江省哈尔滨市",
"861366441", "吉林省长春市",
"861347038", "辽宁省辽阳市",
"86155394", "河南省周口市",
"861386245", "江苏省镇江市",
"861810090", "陕西省西安市",
"861396669", "安徽省合肥市",
"861345585", "山东省威海市",
"861773433", "河北省邯郸市",
"861587610", "广东省佛山市",
"861569361", "甘肃省张掖市",
"861388788", "云南省楚雄彝族自治州",
"861315042", "新疆阿克苏地区",
"86136109", "辽宁省大连市",
"861530560", "安徽省合肥市",
"861534289", "湖北省武汉市",
"86180841", "贵州省六盘水市",
"861586547", "山东省淄博市",
"861518363", "四川省凉山彝族自治州",
"861503248", "河北省保定市",
"861537568", "安徽省芜湖市",
"861836765", "浙江省台州市",
"861850593", "福建省宁德市",
"86138452", "黑龙江省齐齐哈尔市",
"861505537", "安徽省宿州市",
"861580618", "江苏省无锡市",
"86185470", "内蒙古呼伦贝尔市",
"861707913", "浙江省宁波市",
"861347456", "陕西省延安市",
"861328377", "河南省南阳市",
"861459163", "广西崇左市",
"861539336", "甘肃省酒泉市",
"86183861", "贵州省毕节地区",
"861874297", "新疆乌鲁木齐市",
"861580866", "云南省玉溪市",
"86151883", "河南省郑州市",
"861476186", "江苏省南京市",
"861859706", "青海省玉树藏族自治州",
"86133351", "山东省济南市",
"86137471", "内蒙古呼和浩特市",
"861821825", "广东省湛江市",
"861340030", "河北省邯郸市",
"86178268", "浙江省杭州市",
"861554400", "河南省安阳市",
"861330344", "山西省晋中市",
"861801523", "江苏省南通市",
"861454149", "吉林省白山市",
"861882667", "广东省湛江市",
"861521784", "广东省惠州市",
"861529708", "青海省西宁市",
"861343758", "广东省茂名市",
"861783530", "山西省阳泉市",
"861356549", "新疆和田地区",
"861802042", "江苏省常州市",
"86156325", "河北省唐山市",
"861832070", "广东省广州市",
"861361412", "辽宁省鞍山市",
"861333052", "云南省昆明市",
"861374586", "黑龙江省绥化市",
"861333786", "江苏省连云港市",
"861560567", "安徽省亳州市",
"86138647", "山东省东营市",
"861369827", "四川省巴中市",
"86135923", "河南省商丘市",
"86152811", "四川省绵阳市",
"861895146", "江苏省徐州市",
"861392147", "江苏省南通市",
"86156628", "吉林省辽源市",
"861550884", "云南省昆明市",
"861346788", "湖南省娄底市",
"861334874", "湖南省张家界市",
"861847571", "广东省佛山市",
"861318374", "四川省雅安市",
"861582056", "广东省珠海市",
"861520948", "甘肃省天水市",
"861865091", "福建省泉州市",
"861879760", "湖南省怀化市",
"861559424", "陕西省渭南市",
"861336082", "广东省汕头市",
"861850725", "湖北省黄冈市",
"861336756", "广西百色市",
"861360487", "黑龙江省大兴安岭地区",
"861364433", "吉林省延边朝鲜族自治州",
"86157946", "天津市",
"861862518", "江苏省南京市",
"861890388", "河南省洛阳市",
"861850946", "甘肃省庆阳市",
"861575143", "江苏省徐州市",
"861803899", "广东省茂名市",
"861590511", "江苏省盐城市",
"861523507", "山西省朔州市",
"861323275", "广东省河源市",
"861899449", "江苏省镇江市",
"861362375", "河南省平顶山市",
"861821122", "广东省广州市",
"861538293", "广东省汕头市",
"86139910", "陕西省咸阳市",
"86859", "贵州省黔西南布依族苗族自治州",
"86546", "山东省东营市",
"861768527", "贵州省毕节地区",
"861894463", "黑龙江省哈尔滨市",
"861839298", "陕西省西安市",
"861777103", "湖北省襄樊市",
"861327641", "山东省济南市",
"861562799", "广东省汕尾市",
"86157525", "云南省红河哈尼族彝族自治州",
"86156893", "山东省枣庄市",
"861508053", "福建省南平市",
"861368720", "湖北省十堰市",
"861329924", "广西玉林市",
"861878867", "贵州省安顺市",
"861705069", "重庆市",
"861520735", "湖南省郴州市",
"861503479", "内蒙古呼和浩特市",
"861378949", "内蒙古赤峰市",
"861354228", "广东省韶关市",
"861372241", "河北省承德市",
"861801093", "安徽省阜阳市",
"861319411", "辽宁省大连市",
"861389538", "宁夏银川市",
"861324396", "辽宁省辽阳市",
"861513504", "山西省运城市",
"861550492", "辽宁省鞍山市",
"861813854", "广东省佛山市",
"86183114", "北京市",
"861300146", "河北省邯郸市",
"861394894", "内蒙古乌兰察布市",
"861331409", "辽宁省葫芦岛市",
"861509817", "山东省潍坊市",
"861856712", "河南省漯河市",
"861509134", "陕西省咸阳市",
"86132706", "江苏省南通市",
"861311683", "浙江省嘉兴市",
"861597680", "广东省湛江市",
"861324900", "广东省中山市",
"861774034", "河北省邯郸市",
"86138409", "辽宁省大连市",
"861537844", "四川省内江市",
"861319927", "黑龙江省伊春市",
"861367754", "新疆石河子市",
"861300975", "黑龙江省齐齐哈尔市",
"861500981", "辽宁省锦州市",
"861816884", "江苏省常州市",
"861539328", "甘肃省陇南市",
"861853016", "河南省焦作市",
"861850872", "云南省曲靖市",
"861881214", "河北省承德市",
"86158191", "广东省阳江市",
"861380934", "甘肃省庆阳市",
"861567640", "广西梧州市",
"861359810", "河南省安阳市",
"861889884", "广东省清远市",
"861387282", "湖北省十堰市",
"861476521", "河北省石家庄市",
"861302446", "江苏省泰州市",
"861843488", "山西省运城市",
"86151250", "云南省大理白族自治州",
"86181285", "广东省东莞市",
"861815953", "福建省漳州市",
"861552192", "广东省揭阳市",
"86414", "辽宁省本溪市",
"861347309", "河北省邢台市",
"861589725", "青海省海南藏族自治州",
"861322380", "河南省开封市",
"86188312", "河北省保定市",
"861880424", "辽宁省鞍山市",
"861301154", "河北省邯郸市",
"86158494", "内蒙古乌兰察布市",
"861328494", "黑龙江省双鸭山市",
"861846458", "山东省威海市",
"86183411", "辽宁省大连市",
"861530969", "安徽省合肥市",
"861894752", "内蒙古通辽市",
"861871059", "陕西省铜川市",
"861316538", "山东省泰安市",
"861359855", "河南省信阳市",
"86189908", "四川省南充市",
"861501501", "广东省江门市",
"861313792", "河南省焦作市",
"861450504", "吉林省延边朝鲜族自治州",
"861803656", "江苏省连云港市",
"861366250", "广东省广州市",
"861528721", "云南省大理白族自治州",
"861308556", "安徽省安庆市",
"86188377", "河南省南阳市",
"861860757", "广东省佛山市",
"86130750", "安徽省阜阳市",
"861809952", "新疆伊犁哈萨克自治州",
"861860829", "四川省宜宾市",
"861876883", "河南省许昌市",
"861874824", "内蒙古包头市",
"861580706", "江西省吉安市",
"861518210", "四川省内江市",
"861390619", "江苏省无锡市",
"86139535", "山东省烟台市",
"861303665", "四川省达州市",
"861865402", "安徽省六安市",
"861869489", "浙江省金华市",
"861318497", "河北省衡水市",
"861333571", "浙江省杭州市",
"861527549", "山东省临沂市",
"861361060", "山西省忻州市",
"861529868", "江苏省淮安市",
"861525147", "江苏省徐州市",
"86152461", "黑龙江省大庆市",
"861558613", "湖北省荆州市",
"861534703", "湖北省恩施土家族苗族自治州",
"86182833", "四川省乐山市",
"861770324", "河北省承德市",
"861782017", "广东省河源市",
"861816001", "四川省成都市",
"861836805", "浙江省舟山市",
"861770569", "安徽省合肥市",
"861562254", "广东省东莞市",
"86186295", "陕西省西安市",
"861359152", "辽宁省丹东市",
"861893506", "山西省运城市",
"861364670", "浙江省衢州市",
"861556641", "辽宁省大连市",
"861589023", "河南省漯河市",
"861591651", "广东省梅州市",
"86138797", "江西省赣州市",
"86153002", "北京市",
"861867195", "湖北省襄樊市",
"861889492", "河北省秦皇岛市",
"86155125", "河北省唐山市",
"861390447", "吉林省延边朝鲜族自治州",
"861529544", "江苏省无锡市",
"861552895", "四川省宜宾市",
"861320536", "山东省潍坊市",
"861364442", "吉林省吉林市",
"861587130", "湖北省孝感市",
"861328882", "广东省广州市",
"861896944", "浙江省宁波市",
"861873402", "安徽省宿州市",
"861802948", "广东省茂名市",
"86185829", "四川省宜宾市",
"861334607", "浙江省丽水市",
"861378373", "河南省新乡市",
"86155606", "内蒙古乌兰察布市",
"861775701", "浙江省衢州市",
"861570037", "四川省内江市",
"861565340", "山东省德州市",
"861840559", "安徽省黄山市",
"861333958", "黑龙江省鹤岗市",
"861760378", "河南省开封市",
"861310439", "吉林省白山市",
"86147144", "广东省广州市",
"861809314", "甘肃省白银市",
"861332514", "山东省烟台市",
"861331356", "山西省晋城市",
"861519547", "江苏省徐州市",
"861346956", "宁夏石嘴山市",
"861304407", "山东省济宁市",
"861596405", "山东省德州市",
"861452229", "浙江省杭州市",
"861538301", "河北省石家庄市",
"861898691", "湖北省十堰市",
"861316526", "山东省潍坊市",
"861336988", "新疆阿克苏地区",
"861370635", "山东省聊城市",
"861887263", "湖北省武汉市",
"861840499", "山西省吕梁市",
"861596475", "山东省济宁市",
"861567853", "广西玉林市",
"861365564", "安徽省安庆市",
"861304477", "河南省漯河市",
"86156194", "陕西省西安市",
"861319245", "广东省惠州市",
"861337743", "广西玉林市",
"861551612", "河南省濮阳市",
"86159050", "福建省泉州市",
"861771236", "江苏省无锡市",
"861550071", "青海省黄南藏族自治州",
"861334081", "四川省自贡市",
"861864808", "内蒙古锡林郭勒盟",
"861365329", "河北省邢台市",
"861564558", "黑龙江省七台河市",
"861538371", "河北省石家庄市",
"861534075", "山西省大同市",
"86152863", "贵州省黔东南苗族侗族自治州",
"861550687", "广西防城港市",
"861369624", "四川省南充市",
"861382493", "广东省清远市",
"861858313", "四川省宜宾市",
"861773442", "河北省石家庄市",
"861806140", "江苏省盐城市",
"861378303", "河南省鹤壁市",
"861899814", "广东省江门市",
"86182431", "吉林省长春市",
"861821862", "广东省揭阳市",
"861808998", "西藏拉萨市",
"861596561", "山东省济南市",
"861862469", "辽宁省辽阳市",
"861830013", "广东省清远市",
"861334677", "河南省开封市",
"861885130", "江苏省南通市",
"861315033", "新疆乌鲁木齐市",
"861567186", "湖北省荆门市",
"861324509", "江苏省苏州市",
"861509993", "广东省深圳市",
"861325712", "湖北省孝感市",
"861558845", "山东省枣庄市",
"861526440", "山东省菏泽市",
"861306527", "辽宁省盘锦市",
"861510341", "山西省太原市",
"861300534", "广东省汕头市",
"861867340", "湖南省岳阳市",
"861501958", "广东省汕尾市",
"86182674", "浙江省宁波市",
"861314406", "广东省潮州市",
"861509546", "甘肃省定西市",
"861819149", "陕西省渭南市",
"861346443", "辽宁省抚顺市",
"861364600", "福建省厦门市",
"86183813", "四川省自贡市",
"861581901", "广东省梅州市",
"861893576", "新疆伊犁哈萨克自治州",
"861378540", "河北省邯郸市",
"861329360", "山西省忻州市",
"861873640", "河南省漯河市",
"861472715", "浙江省湖州市",
"861477846", "广东省广州市",
"861535347", "陕西省汉中市",
"861315948", "福建省漳州市",
"86138790", "江西省新余市",
"861889552", "安徽省阜阳市",
"861850762", "广东省河源市",
"861454368", "山东省枣庄市",
"861852405", "辽宁省朝阳市",
"861334218", "辽宁省锦州市",
"861534773", "广西桂林市",
"861354737", "四川省泸州市",
"861813657", "江苏省连云港市",
"86151184", "广东省东莞市",
"861327520", "江苏省常州市",
"861533154", "云南省玉溪市",
"861882548", "广东省梅州市",
"861350783", "广西桂林市",
"861391950", "甘肃省平凉市",
"861356940", "河南省新乡市",
"861564971", "河南省濮阳市",
"861459072", "广东省河源市",
"861450483", "辽宁省大连市",
"861360692", "福建省厦门市",
"861317841", "广东省韶关市",
"861475639", "河北省秦皇岛市",
"861566008", "河南省商丘市",
"861454437", "江苏省宿迁市",
"861783939", "河南省平顶山市",
"861830750", "广东省江门市",
"861816071", "江西省南昌市",
"861502841", "河北省张家口市",
"861537647", "山东省临沂市",
"861536495", "山西省长治市",
"861580776", "广西百色市",
"861381442", "江苏省徐州市",
"861598789", "云南省德宏傣族景颇族自治州",
"861830715", "湖北省咸宁市",
"861815446", "湖北省孝感市",
"861539414", "陕西省商洛市",
"861312447", "福建省泉州市",
"861598391", "四川省广元市",
"861865472", "山东省潍坊市",
"861342662", "江西省九江市",
"861838601", "贵州省铜仁地区",
"861302953", "内蒙古乌兰察布市",
"86130585", "广东省东莞市",
"861771228", "江苏省扬州市",
"861392439", "广东省阳江市",
"861328554", "安徽省淮南市",
"861338696", "福建省漳州市",
"861379217", "山东省淄博市",
"86157018", "上海市",
"861589105", "陕西省延安市",
"861321883", "江苏省南通市",
"861567402", "湖南省常德市",
"86188370", "河南省商丘市",
"86130757", "浙江省温州市",
"861452699", "陕西省铜川市",
"861581498", "广东省韶关市",
"861360353", "山西省太原市",
"861321269", "湖南省衡阳市",
"861579490", "福建省福州市",
"86185862", "内蒙古呼和浩特市",
"861576454", "黑龙江省佳木斯市",
"86151257", "云南省楚雄彝族自治州",
"861334764", "广西梧州市",
"861881878", "广东省深圳市",
"861321156", "广西玉林市",
"861308496", "广西玉林市",
"861833038", "河北省秦皇岛市",
"861560648", "山东省青岛市",
"861700752", "广东省惠州市",
"861373329", "河北省邢台市",
"861566517", "江苏省宿迁市",
"861331067", "山东省青岛市",
"861322444", "吉林省四平市",
"861898531", "贵州省安顺市",
"861353791", "广东省云浮市",
"86150119", "广东省广州市",
"86187868", "贵州省遵义市",
"861339786", "广西百色市",
"861501820", "广东省云浮市",
"861339052", "辽宁省大连市",
"861477718", "广西河池市",
"861705380", "辽宁省大连市",
"861866306", "山东省枣庄市",
"861778667", "湖北省荆州市",
"861847160", "湖北省随州市",
"86137358", "浙江省杭州市",
"861869954", "新疆吐鲁番地区",
"86156925", "海南省海口市",
"861771538", "江苏省苏州市",
"861850470", "内蒙古呼伦贝尔市",
"861857408", "河南省新乡市",
"861321334", "河南省周口市",
"861377418", "湖北省襄樊市",
"861564256", "辽宁省朝阳市",
"861315293", "山西省朔州市",
"861453491", "内蒙古锡林郭勒盟",
"861592072", "广东省佛山市",
"861325551", "山东省烟台市",
"861772922", "陕西省延安市",
"861879521", "宁夏银川市",
"861391349", "江苏省徐州市",
"861512191", "宁夏银川市",
"861514090", "辽宁省阜新市",
"86137655", "贵州省黔东南苗族侗族自治州",
"86954", "宁夏固原市",
"861850642", "山东省青岛市",
"861389737", "青海省海西蒙古族藏族自治州",
"86155012", "北京市",
"861309292", "陕西省宝鸡市",
"861820601", "福建省莆田市",
"861893617", "江苏省南通市",
"86177507", "福建省泉州市",
"86159592", "福建省厦门市",
"861592823", "四川省广元市",
"861361152", "江苏省盐城市",
"86187504", "福建省泉州市",
"861826041", "江苏省南京市",
"861320696", "黑龙江省鸡西市",
"861330554", "安徽省淮南市",
"86153616", "广东省深圳市",
"861533849", "广东省茂名市",
"861327871", "云南省昆明市",
"861337663", "广东省揭阳市",
"861509248", "山东省枣庄市",
"861583387", "河北省保定市",
"86147415", "辽宁省沈阳市",
"861327230", "湖南省衡阳市",
"861380513", "江苏省连云港市",
"861479156", "陕西省西安市",
"861893278", "河北省沧州市",
"861839309", "甘肃省白银市",
"86182149", "江西省赣州市",
"86180815", "四川省南充市",
"86134230", "广东省东莞市",
"861322477", "内蒙古鄂尔多斯市",
"861312583", "吉林省四平市",
"861366789", "广西玉林市",
"861776199", "江苏省扬州市",
"861370723", "湖北省黄石市",
"861341793", "广东省珠海市",
"861559739", "青海省西宁市",
"861827174", "湖北省孝感市",
"86133951", "江苏省无锡市",
"861470423", "辽宁省抚顺市",
"861521790", "广东省佛山市",
"861533336", "河北省廊坊市",
"861334516", "山东省烟台市",
"861366391", "河南省焦作市",
"861554105", "辽宁省朝阳市",
"861532522", "浙江省绍兴市",
"861805404", "安徽省宣城市",
"861589633", "江苏省宿迁市",
"861394880", "内蒙古呼伦贝尔市",
"861881567", "安徽省阜阳市",
"861777115", "湖北省黄石市",
"86181677", "新疆昌吉回族自治州",
"861807482", "广西柳州市",
"861520371", "河南省郑州市",
"86132339", "河南省洛阳市",
"861700511", "江苏省镇江市",
"861787575", "广东省佛山市",
"86870", "云南省昭通市",
"861365716", "湖北省荆州市",
"861377960", "新疆克孜勒苏柯尔克孜自治州",
"861317252", "广东省汕头市",
"861361855", "贵州省黔东南苗族侗族自治州",
"861335363", "河南省安阳市",
"861800730", "湖南省岳阳市",
"861383538", "山西省临汾市",
"861313411", "辽宁省大连市",
"861782867", "四川省绵阳市",
"861304444", "山西省朔州市",
"861816890", "江苏省无锡市",
"86137400", "辽宁省沈阳市",
"861516642", "山东省青岛市",
"86181081", "四川省成都市",
"861813437", "河北省沧州市",
"861319151", "内蒙古赤峰市",
"861857991", "广西南宁市",
"861777150", "湖北省咸宁市",
"86181612", "四川省成都市",
"861829729", "青海省海西蒙古族藏族自治州",
"86185401", "辽宁省沈阳市",
"861343557", "广东省潮州市",
"861362731", "湖南省长沙市",
"861533328", "河北省唐山市",
"861566676", "山东省泰安市",
"86186304", "河北省廊坊市",
"861311468", "黑龙江省鹤岗市",
"861595069", "江苏省徐州市",
"861361810", "四川省德阳市",
"861454657", "云南省怒江傈僳族自治州",
"861332933", "黑龙江省双鸭山市",
"86134026", "江苏省苏州市",
"861368475", "内蒙古呼和浩特市",
"861576634", "广东省梅州市",
"861570627", "江苏省南通市",
"861539679", "江苏省连云港市",
"861568481", "新疆阿克苏地区",
"861555249", "山东省滨州市",
"861872826", "四川省资阳市",
"86139310", "河北省邯郸市",
"86135895", "山东省淄博市",
"861529281", "新疆和田地区",
"861818732", "云南省昆明市",
"861357906", "新疆喀什地区",
"861893449", "贵州省毕节地区",
"861831200", "广东省深圳市",
"861829857", "甘肃省张掖市",
"861840973", "青海省海东地区",
"861879091", "河南省漯河市",
"861509479", "山东省泰安市",
"861778124", "四川省乐山市",
"861368561", "安徽省淮北市",
"861370025", "陕西省安康市",
"861781716", "广东省惠州市",
"861785855", "浙江省衢州市",
"861332048", "云南省西双版纳傣族自治州",
"861535374", "陕西省西安市",
"861894688", "青海省海南藏族自治州",
"861303926", "吉林省吉林市",
"861309622", "四川省宜宾市",
"861348792", "湖南省常德市",
"861303745", "湖南省怀化市",
"861314549", "山东省临沂市",
"861588326", "四川省内江市",
"861513668", "河南省南阳市",
"861505482", "山东省青岛市",
"861803436", "河北省廊坊市",
"86139372", "河南省安阳市",
"861338098", "广东省江门市",
"861319563", "安徽省宣城市",
"861331817", "广东省揭阳市",
"861300913", "吉林省长春市",
"861350398", "河南省三门峡市",
"861357145", "陕西省安康市",
"86147596", "福建省漳州市",
"861801242", "江苏省南通市",
"861452539", "山东省临沂市",
"861555991", "云南省昆明市",
"861340541", "山东省济南市",
"861883071", "河北省沧州市",
"861899399", "甘肃省白银市",
"861811035", "安徽省宣城市",
"861535682", "浙江省湖州市",
"861831831", "广东省东莞市",
"861556084", "内蒙古包头市",
"86152802", "福建省厦门市",
"861339422", "辽宁省抚顺市",
"861581169", "广东省珠海市",
"861301328", "河北省唐山市",
"861840903", "新疆和田地区",
"861513816", "河南省三门峡市",
"861831270", "广东省湛江市",
"861330882", "云南省德宏傣族景颇族自治州",
"861899781", "新疆昌吉回族自治州",
"861510072", "河北省廊坊市",
"861308258", "江苏省宿迁市",
"861519483", "河北省石家庄市",
"861839932", "新疆吐鲁番地区",
"86139317", "河北省沧州市",
"861390474", "内蒙古乌兰察布市",
"861338536", "山东省潍坊市",
"861357976", "新疆石河子市",
"86152636", "山东省潍坊市",
"861566606", "山东省潍坊市",
"861325908", "陕西省渭南市",
"8618062", "湖北省武汉市",
"861379076", "广东省惠州市",
"861894511", "黑龙江省哈尔滨市",
"86186746", "湖南省永州市",
"861770158", "江苏省南京市",
"861709930", "浙江省台州市",
"861810761", "广东省阳江市",
"861590463", "黑龙江省牡丹江市",
"861575916", "福建省南平市",
"861477197", "湖北省宜昌市",
"861586066", "福建省宁德市",
"861458769", "广东省东莞市",
"861320226", "广东省深圳市",
"861368886", "广东省广州市",
"861360532", "山东省青岛市",
"861324446", "吉林省白城市",
"861572931", "河南省周口市",
"861550342", "山西省运城市",
"861888296", "四川省甘孜藏族自治州",
"861768963", "福建省龙岩市",
"86132944", "吉林省吉林市",
"861538042", "江苏省南京市",
"861304380", "辽宁省阜新市",
"861390583", "浙江省嘉兴市",
"861351167", "江苏省常州市",
"861362313", "河北省张家口市",
"861519574", "江苏省连云港市",
"861508070", "湖南省益阳市",
"861323213", "广东省云浮市",
"861506535", "山东省烟台市",
"86136824", "广东省深圳市",
"861787505", "广东省梅州市",
"861370968", "广东省珠海市",
"861593317", "河北省沧州市",
"861517579", "河北省石家庄市",
"861384855", "内蒙古通辽市",
"86134237", "广东省深圳市",
"861807176", "湖北省襄樊市",
"861890562", "安徽省铜陵市",
"861893208", "贵州省黔西南布依族苗族自治州",
"861839379", "甘肃省陇南市",
"861870327", "河北省沧州市",
"861515727", "浙江省台州市",
"861303043", "内蒙古兴安盟",
"861882014", "广东省广州市",
"861354181", "四川省达州市",
"861325163", "黑龙江省牡丹江市",
"86133319", "上海市",
"861330494", "辽宁省本溪市",
"861333820", "福建省宁德市",
"861824948", "黑龙江省鸡西市",
"86139743", "湖南省湘西土家族苗族自治州",
"861810084", "贵州省贵阳市",
"861563361", "河北省唐山市",
"861856072", "山东省淄博市",
"86152180", "广东省梅州市",
"86182155", "四川省成都市",
"861302579", "广东省珠海市",
"861530721", "湖北省荆州市",
"861320238", "广东省佛山市",
"86189792", "江西省九江市",
"861597224", "湖北省襄樊市",
"86189281", "广东省中山市",
"861357842", "云南省临沧市",
"861300694", "广西梧州市",
"861768108", "安徽省阜阳市",
"86157704", "云南省丽江市",
"861801967", "江苏省常州市",
"861845233", "江苏省扬州市",
"861830863", "贵州省安顺市",
"861803428", "河北省衡水市",
"861312404", "福建省龙岩市",
"861453551", "安徽省芜湖市",
"861889333", "甘肃省平凉市",
"861518141", "四川省泸州市",
"861301849", "广东省珠海市",
"86152859", "贵州省贵阳市",
"861303938", "吉林省白山市",
"86177500", "福建省泉州市",
"861370455", "黑龙江省绥化市",
"861780911", "陕西省延安市",
"861554593", "黑龙江省鹤岗市",
"861588338", "四川省乐山市",
"861760754", "广东省汕头市",
"86183033", "河北省邯郸市",
"861459341", "四川省乐山市",
"861301336", "云南省大理白族自治州",
"861505106", "江苏省盐城市",
"86176971", "青海省西宁市",
"861884866", "贵州省六盘水市",
"861820087", "广东省茂名市",
"861318986", "广东省江门市",
"861338528", "湖北省武汉市",
"861816342", "广东省珠海市",
"86155070", "江西省赣州市",
"861317323", "山东省青岛市",
"861780427", "辽宁省盘锦市",
"861370410", "辽宁省铁岭市",
"861857478", "湖南省长沙市",
"86131531", "山东省济南市",
"861310659", "广东省佛山市",
"861860498", "辽宁省阜新市",
"861874037", "陕西省宝鸡市",
"861889342", "甘肃省庆阳市",
"861390397", "河南省信阳市",
"86170050", "福建省福州市",
"861845242", "江苏省常州市",
"861879472", "甘肃省酒泉市",
"861364392", "河南省鹤壁市",
"861867515", "广东省东莞市",
"861372155", "贵州省安顺市",
"86134621", "河南省许昌市",
"861340290", "陕西省延安市",
"861332806", "江苏省南通市",
"861835807", "浙江省舟山市",
"861571991", "新疆石河子市",
"861388652", "湖北省咸宁市",
"861537159", "江苏省泰州市",
"861365678", "浙江省宁波市",
"86150435", "吉林省通化市",
"86137799", "福建省厦门市",
"861879640", "江苏省泰州市",
"861372110", "安徽省合肥市",
"861538735", "湖南省郴州市",
"861510551", "安徽省合肥市",
"861830005", "广东省中山市",
"861560878", "云南省楚雄彝族自治州",
"861856978", "湖南省怀化市",
"861567800", "广西来宾市",
"861592908", "陕西省渭南市",
"861354096", "四川省眉山市",
"861768237", "浙江省宁波市",
"861317671", "山东省潍坊市",
"861502087", "山东省莱芜市",
"86135909", "广东省中山市",
"861320107", "新疆哈密地区",
"861821918", "广东省汕尾市",
"861377569", "江苏省泰州市",
"861837497", "湖南省长沙市",
"861332485", "广西玉林市",
"86135736", "山东省潍坊市",
"861313245", "河北省邢台市",
"86151167", "湖南省益阳市",
"861532471", "河南省郑州市",
"861303032", "河南省濮阳市",
"86188301", "河北省石家庄市",
"861503993", "河南省周口市",
"86139693", "山东省淄博市",
"861318758", "云南省临沧市",
"861868369", "四川省成都市",
"861882747", "湖北省宜昌市",
"861596720", "浙江省湖州市",
"861820323", "河北省石家庄市",
"861807697", "西藏阿里地区",
"861852413", "辽宁省抚顺市",
"86183402", "辽宁省朝阳市",
"861553318", "河北省衡水市",
"861317087", "江西省南昌市",
"861375167", "广东省揭阳市",
"861357833", "云南省临沧市",
"861893137", "河北省石家庄市",
"861399451", "山西省阳泉市",
"861861776", "河北省保定市",
"86186579", "浙江省金华市",
"861472703", "浙江省宁波市",
"86151406", "辽宁省大连市",
"861302900", "吉林省长春市",
"861576837", "广东省湛江市",
"861570824", "四川省德阳市",
"861595407", "山东省临沂市",
"861519066", "江苏省徐州市",
"861321416", "辽宁省锦州市",
"86186696", "山东省临沂市",
"86155086", "山东省济南市",
"861571408", "辽宁省阜新市",
"861870785", "广西玉林市",
"86187379", "河南省洛阳市",
"861812525", "广东省肇庆市",
"86183459", "黑龙江省大庆市",
"86135566", "广东省东莞市",
"861853207", "河北省邯郸市",
"861708391", "河南省焦作市",
"861830703", "江西省上饶市",
"861302396", "福建省漳州市",
"86139828", "四川省达州市",
"861526842", "浙江省宁波市",
"86184719", "湖北省武汉市",
"861330377", "河南省南阳市",
"861360543", "山东省滨州市",
"861847820", "湖南省娄底市",
"86135952", "贵州省遵义市",
"861860901", "新疆塔城地区",
"861328344", "河北省邯郸市",
"861510978", "青海省西宁市",
"861517900", "江西省上饶市",
"861769121", "陕西省西安市",
"861552512", "山西省晋中市",
"861327761", "湖北省随州市",
"861589113", "陕西省榆林市",
"861821460", "云南省昆明市",
"86155205", "四川省绵阳市",
"861345336", "山西省运城市",
"861777635", "广西玉林市",
"861804212", "浙江省温州市",
"861329089", "福建省福州市",
"86138423", "辽宁省抚顺市",
"861325002", "广东省江门市",
"86152176", "广东省广州市",
"86188094", "甘肃省兰州市",
"861453823", "四川省雅安市",
"861782664", "江苏省常州市",
"861367378", "河南省开封市",
"861538948", "陕西省渭南市",
"861869741", "内蒙古包头市",
"861311519", "江苏省扬州市",
"86153682", "云南省昆明市",
"861590752", "广东省惠州市",
"861763335", "河北省秦皇岛市",
"861801233", "江苏省扬州市",
"861339501", "福建省厦门市",
"86153011", "北京市",
"861533414", "湖北省黄冈市",
"861536190", "广东省湛江市",
"861384791", "内蒙古锡林郭勒盟",
"861392174", "江苏省泰州市",
"861839943", "新疆伊犁哈萨克自治州",
"86181130", "四川省成都市",
"861386563", "安徽省宣城市",
"861318347", "四川省宜宾市",
"861882358", "广东省东莞市",
"861345849", "四川省德阳市",
"861334847", "福建省漳州市",
"86187418", "辽宁省阜新市",
"861539585", "浙江省绍兴市",
"861536345", "广东省惠州市",
"861339571", "浙江省杭州市",
"861532998", "贵州省黔东南苗族侗族自治州",
"861879186", "陕西省宝鸡市",
"861863489", "山西省吕梁市",
"861367308", "河南省信阳市",
"861880739", "湖南省邵阳市",
"861570796", "江西省吉安市",
"861360370", "河南省商丘市",
"861309665", "山西省晋城市",
"861815396", "甘肃省兰州市",
"861312397", "浙江省温州市",
"861598441", "四川省绵阳市",
"861592551", "云南省昭通市",
"861866459", "广东省深圳市",
"861305525", "福建省福州市",
"861760941", "甘肃省甘南藏族自治州",
"861521811", "广东省梅州市",
"861339465", "黑龙江省大庆市",
"86132292", "广东省佛山市",
"861374957", "河南省平顶山市",
"86189126", "江苏省苏州市",
"861802371", "广东省清远市",
"86139554", "安徽省淮南市",
"861333160", "吉林省吉林市",
"861340620", "山东省泰安市",
"861871898", "广东省云浮市",
"861330307", "河北省沧州市",
"861705819", "江苏省南京市",
"861589642", "江苏省徐州市",
"861308346", "安徽省淮南市",
"86188912", "陕西省榆林市",
"861839456", "甘肃省武威市",
"861830773", "广西桂林市",
"861386151", "江苏省无锡市",
"861534750", "广东省揭阳市",
"86147865", "湖南省怀化市",
"861787689", "广东省广州市",
"861328480", "内蒙古包头市",
"86189605", "福建省三明市",
"861510908", "新疆阿克苏地区",
"861391973", "甘肃省张掖市",
"861322394", "河南省周口市",
"861569835", "山西省晋中市",
"861860971", "青海省西宁市",
"861803952", "河南省周口市",
"86180465", "北京市",
"861315301", "山东省济南市",
"861306108", "山东省聊城市",
"861348563", "安徽省宣城市",
"861595477", "山东省德州市",
"861516633", "山东省日照市",
"861302970", "黑龙江省哈尔滨市",
"861319792", "江西省九江市",
"861528560", "贵州省贵阳市",
"861332942", "黑龙江省齐齐哈尔市",
"861890095", "辽宁省大连市",
"861301414", "甘肃省兰州市",
"861550711", "湖北省鄂州市",
"861308839", "四川省乐山市",
"861772036", "湖北省荆门市",
"861769701", "青海省西宁市",
"861707534", "山东省烟台市",
"861571478", "内蒙古巴彦淖尔市",
"861534715", "湖北省恩施土家族苗族自治州",
"861378031", "河北省石家庄市",
"861803314", "广东省江门市",
"861320727", "湖北省荆州市",
"86138821", "四川省成都市",
"861339958", "安徽省阜阳市",
"861808232", "江苏省淮安市",
"861890525", "江苏省扬州市",
"861454582", "甘肃省天水市",
"861331546", "河北省石家庄市",
"861848582", "贵州省毕节地区",
"861332267", "广东省汕尾市",
"861840836", "四川省甘孜藏族自治州",
"861835266", "江苏省南通市",
"861399591", "湖北省黄冈市",
"861835159", "江苏省宿迁市",
"861317601", "山东省济南市",
"861351759", "广西北海市",
"861592978", "陕西省咸阳市",
"861772028", "湖北省荆门市",
"861322069", "山东省淄博市",
"861306963", "黑龙江省齐齐哈尔市",
"86151160", "湖南省株洲市",
"861532401", "河北省邯郸市",
"861815685", "安徽省阜阳市",
"861561424", "河北省保定市",
"861310724", "湖南省衡阳市",
"861593539", "山西省阳泉市",
"861535497", "内蒙古包头市",
"861567870", "广西柳州市",
"861860558", "安徽省阜阳市",
"861351827", "四川省德阳市",
"86136123", "广东省汕头市",
"861398902", "西藏日喀则地区",
"861810871", "云南省昆明市",
"861305095", "辽宁省葫芦岛市",
"861335210", "辽宁省鞍山市",
"86189450", "黑龙江省哈尔滨市",
"86159485", "吉林省吉林市",
"861529354", "甘肃省金昌市",
"861879402", "甘肃省甘南藏族自治州",
"861850633", "山东省日照市",
"86155242", "辽宁省沈阳市",
"861760629", "山东省枣庄市",
"861361791", "江西省南昌市",
"861890793", "江西省上饶市",
"861572464", "辽宁省鞍山市",
"861310174", "河南省南阳市",
"861599183", "陕西省汉中市",
"861332876", "福建省厦门市",
"861459712", "山东省烟台市",
"861335255", "黑龙江省绥化市",
"861320859", "贵州省毕节地区",
"861852720", "湖北省宜昌市",
"86156779", "广西北海市",
"861331993", "新疆石河子市",
"861361389", "河南省洛阳市",
"861346393", "河北省邢台市",
"861596413", "山东省济宁市",
"861326647", "河北省邢台市",
"861782027", "广东省揭阳市",
"861870856", "贵州省铜仁地区",
"86177354", "山西省晋中市",
"861859628", "山东省烟台市",
"861768902", "西藏日喀则地区",
"861304498", "江西省景德镇市",
"861335372", "河南省安阳市",
"86152462", "黑龙江省鸡西市",
"861301739", "湖南省长沙市",
"861572657", "山东省烟台市",
"861800392", "河南省鹤壁市",
"861770314", "河北省承德市",
"861855568", "安徽省合肥市",
"86177935", "甘肃省武威市",
"861334698", "河南省洛阳市",
"861397353", "湖南省郴州市",
"861860819", "四川省南充市",
"861866129", "江苏省无锡市",
"861511350", "广东省汕尾市",
"861518220", "四川省眉山市",
"861780769", "广东省东莞市",
"861310004", "山西省朔州市",
"861390629", "江苏省南通市",
"861813049", "安徽省阜阳市",
"861305503", "湖南省常德市",
"861571758", "湖南省衡阳市",
"861521979", "广东省中山市",
"861317187", "河北省保定市",
"861550560", "安徽省安庆市",
"861840962", "宁夏石嘴山市",
"861812195", "四川省成都市",
"86183412", "辽宁省鞍山市",
"861818390", "云南省普洱市",
"861812484", "广东省茂名市",
"861805941", "福建省宁德市",
"86188311", "河北省石家庄市",
"861880414", "辽宁省本溪市",
"861350480", "黑龙江省哈尔滨市",
"861303132", "新疆石河子市",
"861332094", "四川省成都市",
"861534470", "海南省海口市",
"861370865", "云南省保山市",
"861315589", "江西省抚州市",
"86137867", "湖南省益阳市",
"861517254", "湖北省武汉市",
"86181795", "江西省宜春市",
"861776920", "湖南省张家界市",
"861319502", "宁夏石嘴山市",
"861830453", "黑龙江省牡丹江市",
"861357732", "云南省红河哈尼族彝族自治州",
"861818906", "西藏日喀则地区",
"86183477", "内蒙古鄂尔多斯市",
"861354196", "四川省广元市",
"86187357", "山西省临汾市",
"86188526", "江苏省泰州市",
"861332369", "河南省南阳市",
"861888281", "四川省雅安市",
"861316516", "山东省青岛市",
"861882989", "陕西省西安市",
"861351479", "内蒙古锡林郭勒盟",
"86186557", "安徽省宿州市",
"861332524", "山东省潍坊市",
"861563665", "黑龙江省双鸭山市",
"861384958", "河南省平顶山市",
"86184709", "江西省南昌市",
"861379697", "黑龙江省绥化市",
"861861596", "山东省烟台市",
"861538133", "浙江省丽水市",
"861890340", "山西省太原市",
"861363067", "吉林省延边朝鲜族自治州",
"861335939", "甘肃省酒泉市",
"861530552", "安徽省蚌埠市",
"861830802", "西藏日喀则地区",
"861705558", "四川省成都市",
"861458427", "河南省新乡市",
"861318408", "山东省菏泽市",
"861520980", "安徽省六安市",
"861306078", "广东省佛山市",
"861868194", "陕西省西安市",
"861346740", "湖南省怀化市",
"861810919", "陕西省铜川市",
"86151416", "辽宁省锦州市",
"861807848", "广西柳州市",
"861576014", "四川省乐山市",
"861809569", "安徽省宿州市",
"861816560", "广东省珠海市",
"861562446", "山东省日照市",
"861707878", "云南省丽江市",
"861595348", "山东省济宁市",
"86153001", "北京市",
"86185463", "黑龙江省牡丹江市",
"861323533", "山东省淄博市",
"861859636", "山东省济南市",
"86155831", "四川省宜宾市",
"861337672", "广东省湛江市",
"861459645", "甘肃省甘南藏族自治州",
"861344355", "山东省菏泽市",
"861820375", "河南省平顶山市",
"86138287", "广东省深圳市",
"861539054", "甘肃省天水市",
"861881897", "广东省云浮市",
"861590853", "贵州省安顺市",
"861890503", "福建省宁德市",
"861390941", "甘肃省甘南藏族自治州",
"86434", "吉林省四平市",
"861325102", "浙江省杭州市",
"861512640", "云南省红河哈尼族彝族自治州",
"86155215", "广东省中山市",
"861812892", "广东省韶关市",
"86131678", "重庆市",
"861770952", "宁夏石嘴山市",
"86156750", "湖南省岳阳市",
"86186785", "山东省菏泽市",
"861868806", "广东省揭阳市",
"861804370", "吉林省辽源市",
"861361571", "浙江省杭州市",
"86158726", "湖北省宜昌市",
"861333060", "四川省雅安市",
"861509167", "陕西省西安市",
"861890573", "浙江省嘉兴市",
"861561585", "山东省烟台市",
"861311858", "贵州省六盘水市",
"861330448", "吉林省延边朝鲜族自治州",
"861337384", "浙江省金华市",
"86138280", "广东省江门市",
"86156757", "湖南省郴州市",
"861507629", "河北省保定市",
"861846507", "宁夏吴忠市",
"861818842", "四川省南充市",
"861894800", "广东省湛江市",
"861518690", "贵州省黔东南苗族侗族自治州",
"861500353", "山西省阳泉市",
"861512402", "辽宁省锦州市",
"861361465", "黑龙江省大庆市",
"861300648", "四川省绵阳市",
"861568496", "湖南省永州市",
"861342832", "广东省汕头市",
"861510765", "广东省清远市",
"861478370", "河南省商丘市",
"86152429", "辽宁省葫芦岛市",
"861847412", "湖南省益阳市",
"861325722", "湖北省随州市",
"861879752", "湖南省张家界市",
"861537429", "江西省南昌市",
"861337602", "江苏省泰州市",
"861529296", "新疆和田地区",
"86187408", "辽宁省阜新市",
"861305892", "浙江省湖州市",
"861366695", "福建省三明市",
"861367447", "吉林省白城市",
"861830872", "云南省大理白族自治州",
"861399771", "湖北省宜昌市",
"86189318", "河北省石家庄市",
"861890484", "黑龙江省牡丹江市",
"861857986", "广西玉林市",
"861500692", "山东省日照市",
"861369614", "四川省乐山市",
"861557844", "广西南宁市",
"861504985", "内蒙古鄂尔多斯市",
"86182432", "吉林省吉林市",
"861899824", "广东省汕头市",
"861318478", "河北省沧州市",
"861527988", "江西省宜春市",
"86189615", "江苏省无锡市",
"861365319", "河北省邢台市",
"86133574", "北京市",
"861566097", "河南省南阳市",
"861358107", "山东省临沂市",
"861530492", "辽宁省营口市",
"86150203", "山东省临沂市",
"861811650", "四川省甘孜藏族自治州",
"861884026", "陕西省汉中市",
"861351409", "福建省福州市",
"86156585", "浙江省温州市",
"86186550", "安徽省滁州市",
"861814997", "新疆阿克苏地区",
"861533739", "湖北省鄂州市",
"861373319", "河南省郑州市",
"861338044", "广东省中山市",
"861534400", "内蒙古鄂尔多斯市",
"861560534", "山东省德州市",
"861350344", "河南省新乡市",
"861348330", "河北省张家口市",
"861361958", "宁夏银川市",
"861853309", "河北省石家庄市",
"86183470", "内蒙古呼伦贝尔市",
"86157385", "河南省焦作市",
"86187350", "山西省忻州市",
"86185861", "内蒙古包头市",
"861559336", "甘肃省白银市",
"861868942", "广东省广州市",
"861472872", "贵州省铜仁地区",
"861369546", "山东省东营市",
"861839706", "青海省玉树藏族自治州",
"86137860", "湖南省岳阳市",
"861319572", "青海省海西蒙古族藏族自治州",
"86155433", "吉林省松原市",
"861773261", "河北省廊坊市",
"861367619", "广东省江门市",
"861521909", "广东省清远市",
"861897829", "广西河池市",
"861554289", "辽宁省阜新市",
"86152886", "云南省文山壮族苗族自治州",
"861812340", "四川省巴中市",
"861363356", "山西省晋城市",
"861325875", "吉林省通化市",
"861825257", "江苏省淮安市",
"861330279", "广东省潮州市",
"861379227", "山东省滨州市",
"861772778", "广东省云浮市",
"861891435", "江苏省南通市",
"861830725", "湖北省荆州市",
"861808907", "西藏阿里地区",
"861454931", "江苏省淮安市",
"861802589", "广东省汕头市",
"861335684", "山东省德州市",
"861872748", "湖北省孝感市",
"861512186", "宁夏石嘴山市",
"861830946", "甘肃省兰州市",
"86130194", "辽宁省大连市",
"861590472", "内蒙古包头市",
"86133923", "广东省东莞市",
"861760397", "河南省洛阳市",
"861530884", "云南省昆明市",
"861327555", "安徽省马鞍山市",
"861310074", "湖北省黄冈市",
"861334236", "辽宁省朝阳市",
"861863365", "河北省邯郸市",
"861304558", "安徽省宣城市",
"861305484", "山东省莱芜市",
"861570576", "浙江省台州市",
"861318249", "江苏省南通市",
"861884943", "河北省张家口市",
"861890892", "西藏日喀则地区",
"861339791", "江西省南昌市",
"861590640", "浙江省丽水市",
"86151595", "福建省泉州市",
"861512853", "河北省秦皇岛市",
"861889969", "新疆巴音郭楞蒙古自治州",
"861864897", "广西崇左市",
"861812503", "广东省茂名市",
"861866709", "浙江省温州市",
"861453486", "内蒙古乌海市",
"861471542", "广东省清远市",
"861336549", "山东省临沂市",
"861327510", "江苏省无锡市",
"861369993", "新疆阿勒泰地区",
"861339389", "河南省焦作市",
"861380233", "广东省汕头市",
"861510486", "内蒙古乌兰察布市",
"861771196", "西藏那曲地区",
"861361786", "广西桂林市",
"861802675", "广东省江门市",
"861843602", "河南省驻马店市",
"86184490", "新疆乌鲁木齐市",
"861569043", "河北省保定市",
"86153125", "江苏省常州市",
"861831954", "广东省广州市",
"861514190", "辽宁省辽阳市",
"861787523", "广东省广州市",
"86145890", "广东省东莞市",
"861570064", "四川省成都市",
"861816969", "广西桂林市",
"861832475", "安徽省阜阳市",
"861884932", "河北省张家口市",
"861880328", "河北省衡水市",
"86177572", "浙江省湖州市",
"86130491", "广东省佛山市",
"861328398", "河南省三门峡市",
"861377899", "四川省资阳市",
"86138853", "贵州省安顺市",
"861874278", "新疆喀什地区",
"861560680", "浙江省舟山市",
"861817681", "广西钦州市",
"861309361", "安徽省宣城市",
"861380242", "广东省广州市",
"861536641", "江苏省扬州市",
"861471533", "广东省佛山市",
"86139971", "青海省西宁市",
"861554005", "内蒙古通辽市",
"861558301", "四川省南充市",
"861320469", "黑龙江省双鸭山市",
"86139458", "黑龙江省鸡西市",
"861707768", "云南省玉溪市",
"861399586", "湖北省孝感市",
"861569938", "新疆伊犁哈萨克自治州",
"861810555", "安徽省马鞍山市",
"861368423", "四川省达州市",
"861351356", "山西省晋城市",
"861840925", "陕西省安康市",
"861871995", "新疆和田地区",
"861776099", "四川省成都市",
"861774248", "陕西省渭南市",
"861840746", "湖南省永州市",
"861865688", "安徽省阜阳市",
"861315605", "山东省青岛市",
"861572854", "广东省广州市",
"861770428", "辽宁省葫芦岛市",
"861875253", "江苏省扬州市",
"861810510", "江苏省盐城市",
"86181659", "广东省汕头市",
"861479782", "江西省九江市",
"861475709", "浙江省台州市",
"861353958", "广东省珠海市",
"861520589", "浙江省金华市",
"86159446", "吉林省白城市",
"86138276", "广东省阳江市",
"861370822", "四川省成都市",
"86147405", "辽宁省丹东市",
"861593219", "河北省邢台市",
"861768078", "湖南省邵阳市",
"861821643", "湖南省长沙市",
"86183829", "四川省南充市",
"861538994", "新疆和田地区",
"86153606", "广东省广州市",
"861855419", "山东省泰安市",
"861338717", "湖北省咸宁市",
"861375409", "内蒙古呼和浩特市",
"861370073", "河南省新乡市",
"861335530", "山东省菏泽市",
"861366947", "广西南宁市",
"861587620", "广东省河源市",
"861341573", "广东省佛山市",
"861879463", "甘肃省平凉市",
"861529118", "陕西省西安市",
"861358238", "河北省保定市",
"861770436", "吉林省白城市",
"861569745", "湖南省怀化市",
"861364730", "湖南省岳阳市",
"86186314", "河北省承德市",
"86156492", "河南省郑州市",
"861550969", "宁夏银川市",
"86137410", "辽宁省铁岭市",
"861521570", "浙江省衢州市",
"861569926", "新疆巴音郭楞蒙古自治州",
"861339855", "贵州省黔东南苗族侗族自治州",
"861853456", "山西省太原市",
"861764537", "黑龙江省鸡西市",
"861760583", "浙江省嘉兴市",
"861315980", "黑龙江省哈尔滨市",
"861776529", "广东省深圳市",
"861339810", "四川省内江市",
"861597567", "广东省阳江市",
"861777015", "江西省鹰潭市",
"861308749", "云南省保山市",
"861829079", "新疆阿克苏地区",
"861814645", "新疆昌吉回族自治州",
"861880849", "四川省巴中市",
"861561679", "湖南省益阳市",
"861332148", "吉林省松原市",
"86150152", "广东省东莞市",
"861560905", "四川省内江市",
"861376815", "广西玉林市",
"861341484", "广东省揭阳市",
"86176372", "河南省安阳市",
"861470561", "安徽省淮北市",
"86152870", "云南省昭通市",
"861778024", "四川省德阳市",
"861306902", "吉林省四平市",
"861818833", "四川省乐山市",
"861598974", "广东省汕头市",
"861380967", "广东省汕头市",
"86189827", "四川省泸州市",
"861453765", "广西河池市",
"861379894", "广东省东莞市",
"861830387", "河南省开封市",
"861879191", "陕西省榆林市",
"861370775", "广西玉林市",
"861376850", "广西南宁市",
"86134594", "福建省福州市",
"861760474", "内蒙古乌兰察布市",
"861556510", "河南省开封市",
"86139300", "河北省邯郸市",
"86183486", "黑龙江省哈尔滨市",
"861831312", "云南省玉溪市",
"861880336", "河北省廊坊市",
"861570399", "河南省濮阳市",
"861815381", "湖南省长沙市",
"861839866", "四川省成都市",
"861806188", "江苏省南京市",
"861822692", "安徽省合肥市",
"86139307", "河北省沧州市",
"861772616", "湖南省衡阳市",
"861773730", "河南省郑州市",
"861560146", "江苏省南通市",
"861862528", "江苏省常州市",
"861321658", "浙江省舟山市",
"861370705", "江西省宜春市",
"861369817", "四川省阿坝藏族羌族自治州",
"86138978", "辽宁省锦州市",
"861528890", "山东省泰安市",
"861811135", "四川省广元市",
"861323542", "湖北省黄冈市",
"861802980", "广东省肇庆市",
"861327919", "陕西省宝鸡市",
"861336940", "甘肃省武威市",
"861341340", "广东省汕头市",
"861871568", "安徽省淮南市",
"861361422", "辽宁省鞍山市",
"861561609", "湖南省张家界市",
"861828470", "四川省泸州市",
"861869831", "福建省漳州市",
"861560975", "青海省果洛藏族自治州",
"861510722", "湖北省武汉市",
"861850750", "广东省江门市",
"861331034", "内蒙古鄂尔多斯市",
"861322829", "陕西省渭南市",
"861572582", "山东省淄博市",
"861334737", "湖南省益阳市",
"861772868", "广东省潮州市",
"861329352", "山西省大同市",
"861391247", "江苏省无锡市",
"861325765", "广东省阳江市",
"861306972", "黑龙江省哈尔滨市",
"86189820", "四川省成都市",
"861878637", "贵州省黔南布依族苗族自治州",
"86152877", "云南省昭通市",
"861330783", "广西桂林市",
"861555758", "浙江省温州市",
"861583289", "河北省承德市",
"86147024", "辽宁省沈阳市",
"861708386", "河南省郑州市",
"861769240", "河北省石家庄市",
"861454464", "陕西省西安市",
"861576747", "广东省广州市",
"861707923", "浙江省嘉兴市",
"861354764", "四川省攀枝花市",
"861379726", "湖北省荆州市",
"86183862", "贵州省毕节地区",
"861379945", "福建省泉州市",
"861478532", "贵州省毕节地区",
"86137472", "内蒙古包头市",
"861853038", "河南省三门峡市",
"861821815", "广东省湛江市",
"861470886", "云南省怒江傈僳族自治州",
"861477097", "江西省上饶市",
"861508720", "云南省昭通市",
"861389516", "宁夏石嘴山市",
"86131138", "广东省深圳市",
"861517799", "广西钦州市",
"861458282", "福建省宁德市",
"86138451", "黑龙江省哈尔滨市",
"861580628", "江苏省南通市",
"861898445", "贵州省毕节地区",
"861821850", "广东省江门市",
"86137417", "辽宁省营口市",
"861841941", "甘肃省平凉市",
"861551665", "河南省鹤壁市",
"861358696", "浙江省金华市",
"861363479", "内蒙古兴安盟",
"861329693", "内蒙古包头市",
"861860380", "河南省新乡市",
"861539318", "甘肃省陇南市",
"861335887", "辽宁省沈阳市",
"861853026", "河南省商丘市",
"861861379", "河南省洛阳市",
"861306339", "安徽省亳州市",
"861344263", "河北省邯郸市",
"861530687", "浙江省温州市",
"861814813", "四川省成都市",
"861375479", "山东省淄博市",
"861532944", "贵州省黔南布依族苗族自治州",
"861319917", "黑龙江省鸡西市",
"861501412", "广东省深圳市",
"86181348", "新疆喀什地区",
"861354677", "山西省忻州市",
"861300567", "广东省茂名市",
"861810495", "辽宁省丹东市",
"861534633", "河南省濮阳市",
"861868766", "云南省昆明市",
"861856722", "河南省鹤壁市",
"861819931", "新疆乌鲁木齐市",
"86130628", "上海市",
"861475129", "江苏省宿迁市",
"861310881", "云南省西双版纳傣族自治州",
"861882837", "四川省乐山市",
"861325063", "广东省惠州市",
"861700760", "广东省中山市",
"861558371", "四川省内江市",
"861303143", "河北省秦皇岛市",
"861319421", "辽宁省朝阳市",
"861811832", "江苏省徐州市",
"861807076", "广西钦州市",
"861500487", "内蒙古赤峰市",
"86151866", "贵州省遵义市",
"861870699", "甘肃省白银市",
"861580636", "山东省潍坊市",
"861707046", "浙江省金华市",
"861830762", "广东省河源市",
"861871844", "广东省肇庆市",
"861529797", "江西省赣州市",
"861368710", "湖北省襄樊市",
"86185813", "重庆市",
"861329914", "陕西省商洛市",
"861555347", "山东省聊城市",
"861365537", "山东省济宁市",
"861862536", "河南省平顶山市",
"861768517", "贵州省毕节地区",
"861348572", "安徽省合肥市",
"861376643", "江西省宜春市",
"861342650", "江西省上饶市",
"86145897", "广东省深圳市",
"861538845", "四川省阿坝藏族羌族自治州",
"861590521", "江苏省徐州市",
"861872483", "云南省玉溪市",
"861573388", "河北省衡水市",
"861582958", "陕西省西安市",
"861817543", "安徽省阜阳市",
"861331352", "山西省大同市",
"861346952", "宁夏石嘴山市",
"861534524", "江苏省苏州市",
"861859165", "陕西省渭南市",
"861539343", "甘肃省庆阳市",
"861811204", "江苏省徐州市",
"861569577", "浙江省温州市",
"86151190", "广东省惠州市",
"86155376", "河南省信阳市",
"861301161", "山东省淄博市",
"861534369", "甘肃省定西市",
"86187089", "海南省海口市",
"86184182", "甘肃省兰州市",
"861309458", "四川省宜宾市",
"861328405", "黑龙江省绥化市",
"861329034", "山东省菏泽市",
"861814848", "四川省泸州市",
"861317901", "吉林省长春市",
"861316522", "山东省枣庄市",
"861779900", "新疆阿克苏地区",
"861533553", "内蒙古鄂尔多斯市",
"861399049", "四川省甘孜藏族自治州",
"861508209", "四川省泸州市",
"861373491", "四川省眉山市",
"861836106", "江苏省盐城市",
"861583514", "山西省长治市",
"86145358", "福建省福州市",
"861558680", "湖北省咸宁市",
"861870770", "广西防城港市",
"861450595", "辽宁省盘锦市",
"861322313", "河北省邯郸市",
"861354243", "广东省云浮市",
"861350423", "辽宁省抚顺市",
"861536474", "山西省晋中市",
"861889496", "河北省沧州市",
"861591777", "广东省惠州市",
"861770740", "湖南省岳阳市",
"861560301", "广东省广州市",
"861452630", "江苏省扬州市",
"86188449", "安徽省阜阳市",
"861373163", "河北省廊坊市",
"861810378", "河南省开封市",
"861895133", "江苏省南通市",
"86132824", "浙江省温州市",
"861575778", "浙江省温州市",
"861760929", "陕西省铜川市",
"861320532", "山东省青岛市",
"861364446", "吉林省延边朝鲜族自治州",
"861319037", "辽宁省葫芦岛市",
"861328886", "广东省东莞市",
"861850933", "甘肃省平凉市",
"861774924", "陕西省汉中市",
"861376866", "广西柳州市",
"861873406", "安徽省阜阳市",
"861505997", "福建省南平市",
"861506674", "山东省泰安市",
"861598429", "四川省内江市",
"861893502", "山西省忻州市",
"861301493", "广西柳州市",
"861819011", "四川省巴中市",
"861527760", "广西玉林市",
"861359156", "辽宁省抚顺市",
"861817996", "江西省赣州市",
"861591127", "云南省普洱市",
"861890268", "广东省汕尾市",
"861764551", "黑龙江省绥化市",
"861887027", "江西省新余市",
"86158487", "内蒙古巴彦淖尔市",
"861365908", "四川省南充市",
"86156636", "黑龙江省哈尔滨市",
"861836894", "甘肃省甘南藏族自治州",
"861575128", "江苏省泰州市",
"861773953", "河南省驻马店市",
"861370547", "山东省济宁市",
"86182746", "湖南省永州市",
"86186155", "山东省济南市",
"861355459", "湖北省荆州市",
"861371990", "广东省汕头市",
"861340920", "河南省新乡市",
"861582571", "浙江省嘉兴市",
"861310550", "浙江省嘉兴市",
"86145400", "北京市",
"861840430", "吉林省长春市",
"861761295", "陕西省宝鸡市",
"861373908", "湖南省长沙市",
"861516048", "福建省莆田市",
"861568969", "山东省济南市",
"861760641", "山东省济南市",
"861562261", "广东省清远市",
"861580702", "江西省九江市",
"86134327", "广东省汕尾市",
"861865406", "安徽省安庆市",
"861892308", "广东省江门市",
"861593403", "山西省阳泉市",
"861309965", "云南省普洱市",
"861477390", "湖南省邵阳市",
"861305268", "辽宁省葫芦岛市",
"861365491", "辽宁省大连市",
"861894756", "内蒙古呼伦贝尔市",
"861786661", "山东省济南市",
"861313796", "河南省漯河市",
"861396721", "浙江省舟山市",
"861337237", "浙江省台州市",
"86180495", "陕西省西安市",
"861397044", "江西省吉安市",
"861840321", "河北省石家庄市",
"861809956", "新疆喀什地区",
"861308552", "安徽省蚌埠市",
"861346314", "河北省承德市",
"86156859", "贵州省黔西南布依族苗族自治州",
"861302442", "江苏省常州市",
"86147895", "湖南省长沙市",
"861387286", "湖北省随州市",
"861331914", "陕西省商洛市",
"861327039", "江苏省常州市",
"861552196", "广东省河源市",
"861860671", "浙江省杭州市",
"861351360", "山西省太原市",
"861517670", "河北省唐山市",
"861599415", "河南省周口市",
"86178060", "山东省菏泽市",
"86188607", "云南省昆明市",
"86138784", "广西梧州市",
"861814329", "西藏拉萨市",
"861534094", "山西省吕梁市",
"861332470", "广西防城港市",
"861529143", "陕西省渭南市",
"861860601", "福建省福州市",
"861323827", "辽宁省营口市",
"861321152", "广西柳州市",
"86156254", "广东省佛山市",
"861308492", "广西柳州市",
"861315878", "四川省资阳市",
"861700756", "广东省珠海市",
"861535088", "河北省秦皇岛市",
"861585597", "安徽省芜湖市",
"861365551", "安徽省合肥市",
"86188600", "福建省厦门市",
"861826990", "安徽省池州市",
"861375924", "云南省德宏傣族景颇族自治州",
"86152925", "新疆阿克苏地区",
"861829954", "新疆吐鲁番地区",
"861587199", "湖北省荆门市",
"861565104", "江苏省扬州市",
"861338692", "福建省莆田市",
"861551544", "河南省开封市",
"861361334", "河北省秦皇岛市",
"86139016", "上海市",
"86156845", "山东省威海市",
"861596554", "山东省淄博市",
"861567406", "湖南省郴州市",
"861302600", "安徽省安庆市",
"861310490", "广东省湛江市",
"861839643", "福建省宁德市",
"86131641", "湖北省武汉市",
"861580772", "广西柳州市",
"86137539", "山西省运城市",
"861478469", "黑龙江省双鸭山市",
"861381446", "江苏省泰州市",
"861450968", "新疆克孜勒苏柯尔克孜自治州",
"861326391", "江西省南昌市",
"861552874", "四川省宜宾市",
"861815442", "湖北省武汉市",
"86134320", "广东省广州市",
"861326789", "广东省湛江市",
"861362477", "内蒙古鄂尔多斯市",
"861342666", "江西省鹰潭市",
"861865476", "山东省德州市",
"861582501", "云南省临沧市",
"861314853", "广东省中山市",
"861338353", "山西省阳泉市",
"861809443", "江苏省常州市",
"861342818", "广东省茂名市",
"861350053", "安徽省马鞍山市",
"861360696", "福建省漳州市",
"8615721", "上海市",
"861459076", "广东省揭阳市",
"861866041", "山东省济南市",
"861323759", "江西省萍乡市",
"861535211", "甘肃省武威市",
"861858380", "四川省德阳市",
"861303797", "宁夏银川市",
"86145407", "上海市",
"861317558", "浙江省嘉兴市",
"86180321", "河北省石家庄市",
"861897260", "湖北省宜昌市",
"861569018", "河北省衡水市",
"861787634", "广东省广州市",
"861515543", "安徽省淮南市",
"86137769", "江苏省南通市",
"861893572", "新疆昌吉回族自治州",
"861520768", "广东省潮州市",
"861477842", "广东省广州市",
"861398672", "湖北省荆州市",
"861533161", "云南省临沧市",
"861571691", "河北省石家庄市",
"861850766", "广东省云浮市",
"861889556", "安徽省马鞍山市",
"861868013", "广东省揭阳市",
"861869729", "青海省西宁市",
"861576193", "贵州省贵阳市",
"86180516", "江苏省南通市",
"861325716", "湖北省荆州市",
"861360385", "河南省漯河市",
"861560371", "河南省郑州市",
"861471624", "广东省佛山市",
"861591707", "广东省阳江市",
"861539570", "浙江省衢州市",
"861398440", "贵州省贵阳市",
"861514629", "黑龙江省哈尔滨市",
"861314402", "广东省中山市",
"861509542", "甘肃省兰州市",
"861301553", "河南省郑州市",
"861575708", "浙江省衢州市",
"861302985", "黑龙江省哈尔滨市",
"861450410", "辽宁省铁岭市",
"861502971", "陕西省渭南市",
"861773446", "河北省廊坊市",
"861508279", "四川省南充市",
"86157040", "吉林省辽源市",
"861821866", "广东省肇庆市",
"861583180", "河北省衡水市",
"861580825", "四川省遂宁市",
"861870700", "江西省新余市",
"861376581", "贵州省贵阳市",
"861379341", "山东省日照市",
"86139663", "安徽省合肥市",
"861503693", "河南省驻马店市",
"861567182", "湖北省咸宁市",
"861856217", "山东省烟台市",
"861880784", "广西梧州市",
"861328561", "安徽省淮北市",
"861389471", "吉林省吉林市",
"861569507", "宁夏吴忠市",
"861356231", "山东省滨州市",
"861569281", "四川省达州市",
"861364953", "宁夏固原市",
"861551616", "河南省郑州市",
"861812714", "广东省佛山市",
"861317971", "江苏省徐州市",
"861350755", "福建省三明市",
"861528481", "四川省自贡市",
"861564841", "内蒙古巴彦淖尔市",
"861356870", "四川省遂宁市",
"861775657", "安徽省合肥市",
"861328475", "内蒙古通辽市",
"861771232", "江苏省常州市",
"861334751", "广西南宁市",
"861576461", "黑龙江省哈尔滨市",
"861877128", "湖北省咸宁市",
"86152546", "山东省东营市",
"861857040", "湖南省岳阳市",
"861835974", "福建省厦门市",
"86136292", "陕西省西安市",
"861531296", "江苏省南京市",
"861803271", "河北省沧州市",
"861300994", "黑龙江省黑河市",
"861338265", "江苏省徐州市",
"86136781", "四川省成都市",
"861458315", "江西省宜春市",
"861882795", "江西省宜春市",
"861576689", "广东省揭阳市",
"861806497", "四川省成都市",
"861315046", "新疆乌鲁木齐市",
"861812047", "湖北省黄冈市",
"861316565", "湖北省黄冈市",
"861567359", "湖南省邵阳市",
"861528669", "贵州省六盘水市",
"861458350", "山东省东营市",
"86181371", "河南省郑州市",
"861501782", "广东省汕头市",
"861351924", "宁夏中卫市",
"861313297", "广西桂林市",
"861337736", "广西贵港市",
"861348037", "广东省云浮市",
"861802768", "广东省佛山市",
"86137196", "广东省惠州市",
"861394875", "内蒙古通辽市",
"861777504", "安徽省合肥市",
"861304305", "福建省三明市",
"861308001", "吉林省长春市",
"861563868", "河南省平顶山市",
"861513410", "辽宁省抚顺市",
"861378809", "广西钦州市",
"861596307", "山东省滨州市",
"861837445", "湖南省长沙市",
"861787580", "广东省肇庆市",
"861320370", "河南省郑州市",
"861327308", "河南省三门峡市",
"861771243", "江苏省徐州市",
"861340364", "山西省大同市",
"861568560", "贵州省贵阳市",
"861477833", "广东省惠州市",
"861822044", "陕西省商洛市",
"861588270", "四川省巴中市",
"861503189", "河北省沧州市",
"861318686", "浙江省宁波市",
"86130032", "上海市",
"861831326", "云南省普洱市",
"86147736", "湖南省常德市",
"861820971", "青海省西宁市",
"861323294", "广东省江门市",
"861529835", "江苏省南京市",
"861362394", "河南省周口市",
"861454288", "辽宁省盘锦市",
"86183720", "湖北省武汉市",
"861368480", "江西省赣州市",
"86176601", "山东省济宁市",
"861314521", "江苏省徐州市",
"861346436", "辽宁省鞍山市",
"861397198", "湖北省鄂州市",
"861516806", "浙江省舟山市",
"861390345", "山西省长治市",
"86155387", "河南省南阳市",
"861350891", "山东省威海市",
"861452852", "甘肃省酒泉市",
"861362069", "山西省运城市",
"861330413", "辽宁省抚顺市",
"86147952", "广西玉林市",
"861525550", "安徽省马鞍山市",
"861760520", "江苏省徐州市",
"86131282", "广东省广州市",
"861318395", "四川省资阳市",
"861459564", "陕西省渭南市",
"861801124", "四川省达州市",
"861478077", "四川省广元市",
"86138315", "河北省唐山市",
"861804681", "江西省南昌市",
"861815433", "湖北省武汉市",
"861459329", "四川省泸州市",
"861535982", "福建省泉州市",
"86178396", "河南省驻马店市",
"861597845", "河南省驻马店市",
"861804077", "新疆乌鲁木齐市",
"86159529", "江苏省镇江市",
"861705375", "广西南宁市",
"861478681", "湖南省常德市",
"86138941", "吉林省松原市",
"861859825", "广东省深圳市",
"861809432", "江苏省盐城市",
"861591276", "云南省玉溪市",
"861870860", "贵州省铜仁地区",
"861834481", "江苏省镇江市",
"861831338", "云南省普洱市",
"861518129", "四川省攀枝花市",
"861303626", "江西省宜春市",
"861776435", "安徽省宣城市",
"861850485", "内蒙古通辽市",
"86138618", "江苏省无锡市",
"861511427", "辽宁省葫芦岛市",
"861360727", "湖北省襄樊市",
"86185349", "山西省朔州市",
"861530749", "湖南省长沙市",
"86152779", "广西玉林市",
"861321389", "河南省信阳市",
"86189532", "山东省青岛市",
"861572631", "山东省威海市",
"86159258", "浙江省绍兴市",
"861827490", "湖南省永州市",
"861321791", "江西省南昌市",
"86132123", "重庆市",
"861820558", "安徽省阜阳市",
"861520808", "西藏昌都地区",
"861373823", "浙江省湖州市",
"861337728", "广西来宾市",
"861872050", "江西省宜春市",
"861550556", "安徽省安庆市",
"861846043", "江西省萍乡市",
"861589766", "湖北省孝感市",
"861370816", "四川省眉山市",
"861373072", "四川省资阳市",
"86139246", "广东省深圳市",
"861313627", "浙江省舟山市",
"861332633", "山东省日照市",
"861520878", "云南省楚雄彝族自治州",
"861891920", "甘肃省天水市",
"861334944", "黑龙江省佳木斯市",
"861454957", "江苏省盐城市",
"861850876", "云南省文山壮族苗族自治州",
"861453608", "江苏省无锡市",
"861853012", "河南省开封市",
"86181907", "四川省成都市",
"861478518", "贵州省六盘水市",
"861330720", "湖北省宜昌市",
"861391430", "江苏省常州市",
"861550496", "辽宁省锦州市",
"861324392", "辽宁省锦州市",
"861300142", "河北省秦皇岛市",
"86134818", "广西河池市",
"861856716", "河南省南阳市",
"861533821", "广东省惠州市",
"861820498", "内蒙古通辽市",
"861805190", "江苏省苏州市",
"86180582", "浙江省宁波市",
"861554180", "辽宁省阜新市",
"861552081", "四川省成都市",
"86185934", "湖南省衡阳市",
"86185658", "广东省深圳市",
"861454335", "内蒙古乌兰察布市",
"861705305", "北京市",
"86182579", "浙江省金华市",
"861524348", "河北省秦皇岛市",
"861860323", "河北省张家口市",
"861879549", "江苏省苏州市",
"861570411", "辽宁省大连市",
"86135865", "浙江省宁波市",
"861312345", "广西玉林市",
"861318140", "山东省东营市",
"861324653", "广东省湛江市",
"861821126", "广东省肇庆市",
"861316998", "广东省佛山市",
"861476885", "山东省滨州市",
"86155380", "河南省郑州市",
"861840673", "广西桂林市",
"861335019", "四川省宜宾市",
"861344017", "四川省阿坝藏族羌族自治州",
"86185355", "山西省长治市",
"861589048", "河南省濮阳市",
"861810039", "山东省济南市",
"861536397", "广东省珠海市",
"861576934", "甘肃省兰州市",
"861896607", "浙江省绍兴市",
"861539979", "湖南省常德市",
"861570927", "陕西省宝鸡市",
"861356760", "浙江省丽水市",
"861571040", "陕西省西安市",
"86183727", "湖北省咸宁市",
"861820901", "新疆塔城地区",
"861895142", "江苏省南通市",
"861586635", "山东省烟台市",
"861514754", "内蒙古鄂尔多斯市",
"861300845", "陕西省汉中市",
"861355990", "福建省宁德市",
"861582052", "广东省中山市",
"861336752", "广西柳州市",
"86139611", "江苏省常州市",
"861831285", "广东省梅州市",
"861320543", "山东省滨州市",
"861850942", "甘肃省定西市",
"861505645", "安徽省芜湖市",
"861788125", "新疆石河子市",
"861594566", "黑龙江省哈尔滨市",
"861372317", "河南省焦作市",
"861893421", "广东省湛江市",
"861802046", "江苏省盐城市",
"861333782", "江苏省南京市",
"86182696", "广西玉林市",
"861380024", "辽宁省沈阳市",
"861333056", "云南省楚雄彝族自治州",
"861361416", "辽宁省锦州市",
"861452473", "黑龙江省鸡西市",
"861535445", "河北省唐山市",
"861821138", "广东省惠州市",
"861828094", "四川省内江市",
"861347452", "陕西省西安市",
"861539332", "甘肃省平凉市",
"861859702", "青海省海东地区",
"861476182", "江苏省宿迁市",
"861504799", "内蒙古呼和浩特市",
"861580862", "云南省昭通市",
"861338487", "内蒙古呼和浩特市",
"861829741", "安徽省安庆市",
"861320300", "湖南省岳阳市",
"861780588", "浙江省丽水市",
"861327378", "河南省开封市",
"861378879", "广西柳州市",
"861813861", "广东省汕尾市",
"861508085", "湖南省湘西土家族苗族自治州",
"861501438", "广东省茂名市",
"861872420", "黑龙江省哈尔滨市",
"861304375", "河南省平顶山市",
"861471827", "广东省河源市",
"86156176", "河南省郑州市",
"861337963", "贵州省黔东南苗族侗族自治州",
"86131046", "黑龙江省哈尔滨市",
"861538567", "安徽省亳州市",
"861835904", "福建省莆田市",
"8618480", "福建省福州市",
"861452584", "福建省莆田市",
"861556039", "内蒙古赤峰市",
"861369089", "广东省梅州市",
"861843237", "河北省沧州市",
"8615618", "上海市",
"861315975", "吉林省长春市",
"861864994", "福建省泉州市",
"86156429", "辽宁省葫芦岛市",
"86151896", "江苏省淮安市",
"861580936", "甘肃省张掖市",
"861870999", "新疆伊犁哈萨克自治州",
"861841929", "甘肃省武威市",
"861569296", "四川省甘孜藏族自治州",
"861389944", "新疆博尔塔拉蒙古自治州",
"861334092", "四川省乐山市",
"861811559", "江苏省镇江市",
"861321465", "黑龙江省绥化市",
"861530987", "辽宁省沈阳市",
"861501883", "广东省中山市",
"861315146", "江苏省苏州市",
"86152757", "山东省济宁市",
"861705323", "广东省东莞市",
"861534933", "甘肃省平凉市",
"861319617", "吉林省通化市",
"861532644", "吉林省通化市",
"861519050", "江苏省常州市",
"861454111", "安徽省合肥市",
"861521585", "浙江省金华市",
"86157200", "河北省保定市",
"86158162", "广东省清远市",
"861310388", "河南省许昌市",
"861477732", "广西桂林市",
"861872812", "四川省内江市",
"86147919", "陕西省延安市",
"861312520", "江西省九江市",
"86182550", "安徽省滁州市",
"861876287", "江苏省苏州市",
"861522953", "陕西省渭南市",
"86152585", "浙江省绍兴市",
"861370780", "广西柳州市",
"861576851", "广东省深圳市",
"861513003", "河北省邯郸市",
"861771512", "江苏省扬州市",
"861322841", "四川省德阳市",
"861801594", "江苏省南通市",
"86132065", "黑龙江省哈尔滨市",
"861325319", "河北省承德市",
"861503089", "河北省邢台市",
"861781722", "广东省湛江市",
"861869326", "甘肃省兰州市",
"86186432", "吉林省吉林市",
"861861", "北京市",
"861596448", "山东省淄博市",
"861326695", "广东省东莞市",
"861850524", "江苏省镇江市",
"861770587", "浙江省温州市",
"861319278", "广东省清远市",
"861821456", "云南省昆明市",
"861571686", "河北省沧州市",
"861590549", "山东省临沂市",
"861519713", "湖南省岳阳市",
"861899411", "江苏省南京市",
"861478727", "云南省普洱市",
"861452753", "湖南省株洲市",
"86156886", "山东省烟台市",
"861867566", "广东省汕头市",
"86138608", "福建省漳州市",
"861365875", "云南省保山市",
"861362256", "广东省江门市",
"861598604", "广东省河源市",
"861323356", "山西省晋城市",
"861818718", "云南省西双版纳傣族自治州",
"861327619", "江苏省镇江市",
"861887276", "湖北省黄石市",
"861360681", "浙江省杭州市",
"861378427", "河北省保定市",
"861560675", "浙江省绍兴市",
"861329546", "山东省东营市",
"861557947", "江西省赣州市",
"861326386", "广西梧州市",
"861471479", "广东省揭阳市",
"861336472", "新疆阿克苏地区",
"861571395", "河南省漯河市",
"86138305", "甘肃省武威市",
"861314191", "江苏省盐城市",
"861882193", "湖南省衡阳市",
"861514474", "内蒙古乌兰察布市",
"861772916", "陕西省汉中市",
"861598382", "四川省德阳市",
"861306440", "河南省安阳市",
"861378911", "湖南省郴州市",
"861372219", "内蒙古鄂尔多斯市",
"861321958", "四川省内江市",
"861520534", "山东省德州市",
"861824897", "江苏省宿迁市",
"861761430", "吉林省长春市",
"861874051", "陕西省延安市",
"861319449", "福建省龙岩市",
"86181910", "陕西省西安市",
"861859592", "河南省郑州市",
"861358996", "山东省东营市",
"861888612", "贵州省贵阳市",
"861347122", "广西柳州市",
"861314463", "黑龙江省牡丹江市",
"861843846", "河南省平顶山市",
"86180353", "山西省阳泉市",
"861367555", "安徽省黄山市",
"861330000", "广西南宁市",
"861700359", "山西省临汾市",
"861823365", "河北省沧州市",
"861334522", "山东省淄博市",
"861510537", "山东省济宁市",
"86178788", "广西河池市",
"861347772", "湖北省孝感市",
"861514583", "黑龙江省伊春市",
"861554080", "内蒙古巴彦淖尔市",
"861398663", "湖北省咸宁市",
"861566045", "山东省济宁市",
"86177142", "江苏省苏州市",
"86181972", "青海省海东地区",
"861387291", "湖北省荆门市",
"861510880", "云南省文山壮族苗族自治州",
"861567257", "湖北省荆州市",
"861893563", "青海省黄南藏族自治州",
"861524407", "山东省日照市",
"861300042", "广东省广州市",
"86134808", "广东省深圳市",
"861881994", "广东省汕头市",
"861859452", "福建省宁德市",
"86158129", "广东省梅州市",
"861315680", "山东省东营市",
"861563922", "河南省鹤壁市",
"861550669", "山东省聊城市",
"861504579", "黑龙江省鸡西市",
"861352946", "云南省红河哈尼族彝族自治州",
"861855947", "福建省泉州市",
"861313781", "河南省开封市",
"861373102", "河北省邯郸市",
"861862487", "河南省洛阳市",
"861365486", "内蒙古赤峰市",
"86138773", "广西桂林市",
"861777794", "广西河池市",
"861452425", "辽宁省大连市",
"861313399", "江西省萍乡市",
"861890147", "江苏省南通市",
"861324261", "广东省肇庆市",
"861894359", "吉林省通化市",
"861705252", "天津市",
"861500536", "山东省潍坊市",
"861589148", "陕西省西安市",
"861335119", "黑龙江省大庆市",
"861390520", "江苏省徐州市",
"86134564", "浙江省台州市",
"861837531", "安徽省芜湖市",
"861888143", "四川省内江市",
"861318040", "河北省唐山市",
"861309544", "安徽省黄山市",
"861708568", "安徽省合肥市",
"861815888", "安徽省合肥市",
"861306602", "山东省济南市",
"861380667", "浙江省宁波市",
"861842030", "广东省湛江市",
"861538913", "陕西省渭南市",
"861337517", "江苏省苏州市",
"861561979", "陕西省汉中市",
"861560605", "福建省漳州市",
"861804107", "辽宁省沈阳市",
"861303354", "江苏省徐州市",
"861839918", "新疆哈密地区",
"861864845", "内蒙古兴安盟",
"861560980", "辽宁省鞍山市",
"861333156", "吉林省辽源市",
"861801454", "江苏省泰州市",
"861536941", "河北省石家庄市",
"861303912", "吉林省长春市",
"861500528", "江苏省镇江市",
"861802146", "江苏省苏州市",
"861323067", "河北省廊坊市",
"86188393", "河南省濮阳市",
"861336853", "贵州省安顺市",
"861566743", "陕西省宝鸡市",
"861309616", "四川省资阳市",
"861709462", "浙江省衢州市",
"861343188", "广东省惠州市",
"861831654", "广东省佛山市",
"861523665", "河南省洛阳市",
"861760345", "山西省长治市",
"86182557", "安徽省宿州市",
"86147351", "山西省太原市",
"86139601", "福建省漳州市",
"861380774", "广西梧州市",
"861708844", "江西省新余市",
"861390090", "四川省阿坝藏族羌族自治州",
"861816669", "陕西省榆林市",
"861598767", "云南省文山壮族苗族自治州",
"861378057", "河北省沧州市",
"861880821", "四川省眉山市",
"861470344", "山西省晋中市",
"861339416", "辽宁省锦州市",
"861328891", "广东省清远市",
"861333883", "江苏省南通市",
"861351542", "山东省青岛市",
"861373486", "内蒙古赤峰市",
"861821943", "广东省湛江市",
"861811499", "江苏省徐州市",
"861538694", "山西省晋中市",
"86182785", "广西玉林市",
"86152750", "山东省菏泽市",
"861580763", "广东省清远市",
"861559553", "宁夏吴忠市",
"861308721", "湖南省湘潭市",
"861860375", "河南省平顶山市",
"861591383", "广东省东莞市",
"861321501", "福建省厦门市",
"861396552", "安徽省黄山市",
"861473052", "河北省廊坊市",
"861321287", "黑龙江省鸡西市",
"861808874", "黑龙江省哈尔滨市",
"861553343", "河北省廊坊市",
"861840625", "辽宁省盘锦市",
"861308171", "辽宁省营口市",
"861534766", "广东省梅州市",
"861868633", "吉林省延边朝鲜族自治州",
"861865988", "福建省三明市",
"861573566", "山西省晋城市",
"861522446", "山东省枣庄市",
"861374931", "河南省濮阳市",
"861476082", "江苏省泰州市",
"861839460", "甘肃省庆阳市",
"861331089", "广东省广州市",
"861898682", "湖北省宜昌市",
"861351533", "山东省淄博市",
"86176663", "广东省佛山市",
"861821932", "广东省肇庆市",
"861599700", "青海省海北藏族自治州",
"861780031", "河北省石家庄市",
"861367919", "陕西省铜川市",
"86131206", "上海市",
"861320981", "山西省太原市",
"86189940", "江苏省南京市",
"861520975", "青海省果洛藏族自治州",
"861303018", "广东省湛江市",
"861777166", "湖北省恩施土家族苗族自治州",
"861321422", "辽宁省大连市",
"861871947", "广东省广州市",
"861329134", "江苏省常州市",
"86150706", "江西省吉安市",
"861313576", "湖北省荆州市",
"861553332", "河北省邯郸市",
"86137890", "湖南省岳阳市",
"861850148", "江苏省盐城市",
"861818676", "湖北省襄樊市",
"861895948", "福建省龙岩市",
"861352387", "河南省新乡市",
"861361658", "浙江省宁波市",
"86150939", "河南省安阳市",
"861889669", "江苏省常州市",
"86151565", "安徽省合肥市",
"861575028", "云南省普洱市",
"861510319", "河北省邢台市",
"861300735", "湖南省郴州市",
"861561500", "山东省菏泽市",
"861594724", "内蒙古赤峰市",
"861323479", "内蒙古锡林郭勒盟",
"861537441", "甘肃省白银市",
"861355709", "广西北海市",
"861509924", "新疆巴音郭楞蒙古自治州",
"861838407", "四川省南充市",
"861819111", "陕西省西安市",
"861359782", "湖北省随州市",
"861771977", "陕西省渭南市",
"861804226", "浙江省衢州市",
"861882934", "陕西省西安市",
"86135405", "四川省乐山市",
"861884643", "黑龙江省哈尔滨市",
"861894885", "广东省中山市",
"861869009", "陕西省商洛市",
"861781765", "广东省佛山市",
"861582791", "湖北省咸宁市",
"861319814", "四川省巴中市",
"861532847", "四川省宜宾市",
"861507641", "河北省石家庄市",
"861813451", "安徽省合肥市",
"861319137", "内蒙古鄂尔多斯市",
"861454631", "宁夏银川市",
"861705601", "上海市",
"861335984", "黑龙江省哈尔滨市",
"861336091", "广东省韶关市",
"86130164", "湖北省武汉市",
"861830646", "山东省潍坊市",
"861303507", "安徽省阜阳市",
"861762515", "江苏省盐城市",
"861580452", "黑龙江省齐齐哈尔市",
"861336521", "江苏省泰州市",
"86153980", "陕西省西安市",
"861827235", "湖北省随州市",
"861824694", "黑龙江省大庆市",
"861534806", "甘肃省张掖市",
"861804238", "浙江省台州市",
"86151735", "湖南省郴州市",
"861458588", "山东省潍坊市",
"861844588", "黑龙江省哈尔滨市",
"86130811", "河北省唐山市",
"861553979", "河南省平顶山市",
"861317819", "福建省莆田市",
"861311351", "内蒙古鄂尔多斯市",
"861365063", "广东省汕尾市",
"861459106", "广西柳州市",
"861564260", "辽宁省鞍山市",
"861516148", "江苏省南京市",
"861315534", "安徽省芜湖市",
"861880553", "安徽省芜湖市",
"861837188", "湖北省随州市",
"861586331", "山东省德州市",
"861348449", "陕西省咸阳市",
"861847156", "湖北省武汉市",
"86184810", "四川省成都市",
"86130235", "江苏省南通市",
"861822098", "陕西省商洛市",
"8618446", "黑龙江省哈尔滨市",
"861350475", "吉林省吉林市",
"861572288", "江苏省徐州市",
"86188617", "江苏省无锡市",
"861550481", "内蒙古呼和浩特市",
"861309708", "江西省上饶市",
"861811950", "安徽省淮南市",
"861870590", "福建省福州市",
"86187651", "山东省潍坊市",
"861596085", "福建省漳州市",
"86135650", "新疆巴音郭楞蒙古自治州",
"86136095", "福建省福州市",
"861473571", "山西省朔州市",
"861328710", "山东省莱芜市",
"861504685", "黑龙江省七台河市",
"861389751", "青海省西宁市",
"861569797", "江西省赣州市",
"861500992", "新疆伊犁哈萨克自治州",
"861350561", "安徽省合肥市",
"86177021", "上海市",
"86188672", "湖南省湘西土家族苗族自治州",
"861877458", "湖南省怀化市",
"861325537", "山东省济宁市",
"861396687", "安徽省亳州市",
"861527688", "新疆塔城地区",
"861334565", "安徽省巢湖市",
"861892447", "广东省梅州市",
"861323248", "广东省清远市",
"861362348", "山西省朔州市",
"861770393", "河南省濮阳市",
"861534267", "湖北省十堰市",
"861530839", "四川省资阳市",
"861870450", "黑龙江省哈尔滨市",
"861520680", "山东省临沂市",
"861304601", "山东省济南市",
"86181535", "山东省烟台市",
"861810619", "江苏省无锡市",
"861309128", "河北省邢台市",
"861368398", "河南省南阳市",
"861335639", "山东省青岛市",
"861325880", "吉林省四平市",
"861476257", "江苏省南通市",
"861340683", "山东省济宁市",
"861384658", "黑龙江省大兴安岭地区",
"861309778", "广西河池市",
"861524069", "广西南宁市",
"86188610", "江苏省泰州市",
"861579714", "湖北省襄樊市",
"861339334", "河北省秦皇岛市",
"861870415", "辽宁省丹东市",
"861700182", "上海市",
"861334401", "重庆市",
"861473501", "山西省运城市",
"861585664", "安徽省池州市",
"861321786", "广西百色市",
"861305439", "黑龙江省绥化市",
"861383907", "河南省新乡市",
"861530346", "山西省晋城市",
"861458611", "湖北省荆门市",
"861529043", "河南省郑州市",
"861394978", "河南省三门峡市",
"861576795", "广东省惠州市",
"861580873", "云南省红河哈尼族彝族自治州",
"861512940", "陕西省西安市",
"86132151", "广东省东莞市",
"861539790", "江西省新余市",
"861390641", "山东省济南市",
"861813021", "安徽省淮北市",
"86139285", "广东省佛山市",
"86554", "安徽省淮南市",
"861459176", "内蒙古鄂尔多斯市",
"861359367", "湖北省黄冈市",
"861770652", "浙江省杭州市",
"861350153", "广东省广州市",
"861707371", "河南省郑州市",
"861533784", "广东省广州市",
"861780315", "河北省唐山市",
"86184817", "四川省南充市",
"861560589", "浙江省金华市",
"861584500", "黑龙江省哈尔滨市",
"861884850", "贵州省铜仁地区",
"861556447", "山东省淄博市",
"861534876", "云南省文山壮族苗族自治州",
"861575458", "黑龙江省伊春市",
"861350886", "云南省怒江傈僳族自治州",
"861896538", "福建省南平市",
"861859936", "新疆巴音郭楞蒙古自治州",
"861337972", "新疆伊犁哈萨克自治州",
"861884815", "内蒙古赤峰市",
"86135442", "广东省深圳市",
"861360469", "黑龙江省佳木斯市",
"861332013", "江西省上饶市",
"86184872", "云南省昆明市",
"86180969", "新疆阿克苏地区",
"861780350", "山西省忻州市",
"861328423", "辽宁省大连市",
"861536754", "湖南省永州市",
"861529938", "新疆阿勒泰地区",
"861880493", "内蒙古呼和浩特市",
"861591457", "广东省佛山市",
"861768384", "湖北省荆门市",
"861563458", "山东省潍坊市",
"861366568", "安徽省亳州市",
"861700885", "广东省深圳市",
"861477743", "广西梧州市",
"861869079", "贵州省黔西南布依族苗族自治州",
"861831729", "河南省焦作市",
"861890439", "吉林省白山市",
"861705671", "辽宁省大连市",
"861709425", "广东省江门市",
"861576093", "陕西省宝鸡市",
"861323409", "辽宁省大连市",
"86180506", "福建省漳州市",
"86152492", "陕西省西安市",
"86182314", "河北省承德市",
"861827388", "湖南省岳阳市",
"861533061", "吉林省长春市",
"861561570", "山东省菏泽市",
"861826283", "江苏省连云港市",
"861513865", "河南省郑州市",
"861804385", "吉林省松原市",
"861572957", "宁夏银川市",
"861580592", "福建省厦门市",
"861318691", "浙江省台州市",
"861459738", "湖南省长沙市",
"861771907", "河南省平顶山市",
"861859928", "新疆喀什地区",
"861581260", "广东省珠海市",
"861355779", "广西北海市",
"86181765", "广西玉林市",
"861594896", "吉林省辽源市",
"861818606", "湖北省武汉市",
"861857140", "湖北省荆州市",
"86150344", "山西省忻州市",
"861332750", "山西省忻州市",
"861700406", "广东省佛山市",
"861313506", "湖南省常德市",
"861862692", "吉林省长春市",
"86159989", "重庆市",
"861808218", "江苏省盐城市",
"861599120", "陕西省榆林市",
"86130413", "吉林省吉林市",
"861380548", "山东省泰安市",
"861803740", "河南省驻马店市",
"861309136", "河北省秦皇岛市",
"861337339", "河北省邢台市",
"861534942", "甘肃省定西市",
"861840662", "广东省佛山市",
"861567082", "河南省焦作市",
"861831857", "广东省广州市",
"861331275", "云南省怒江傈僳族自治州",
"861800953", "宁夏吴忠市",
"861764063", "辽宁省葫芦岛市",
"861531507", "山东省临沂市",
"861332715", "内蒙古赤峰市",
"861337846", "广东省广州市",
"861810447", "吉林省吉林市",
"861708647", "江苏省盐城市",
"861520905", "新疆阿勒泰地区",
"861583080", "河北省沧州市",
"861868400", "四川省成都市",
"861316944", "广东省清远市",
"861886631", "山东省威海市",
"861500859", "贵州省黔西南布依族苗族自治州",
"861800509", "福建省南平市",
"861314511", "江苏省苏州市",
"861303544", "安徽省马鞍山市",
"861581375", "广东省江门市",
"861570051", "四川省广安市",
"861831961", "广东省惠州市",
"861571445", "吉林省通化市",
"861552698", "吉林省松原市",
"86130031", "上海市",
"861831316", "云南省大理白族自治州",
"86158738", "湖南省娄底市",
"861305659", "四川省雅安市",
"861880332", "河北省保定市",
"861839862", "四川省乐山市",
"861780621", "山东省日照市",
"861822696", "安徽省池州市",
"861778505", "贵州省黔东南苗族侗族自治州",
"861870630", "山东省青岛市",
"86139670", "浙江省丽水市",
"861309354", "安徽省合肥市",
"861525095", "江苏省南京市",
"861810583", "浙江省嘉兴市",
"861820477", "内蒙古鄂尔多斯市",
"861335459", "黑龙江省大庆市",
"861306906", "吉林省松原市",
"861344457", "山东省临沂市",
"861587239", "湖北省武汉市",
"861814537", "黑龙江省双鸭山市",
"861853452", "山西省晋城市",
"861572861", "广东省湛江市",
"861857211", "湖北省孝感市",
"861598568", "贵州省六盘水市",
"861768833", "广东省惠州市",
"86177225", "广东省深圳市",
"861894549", "黑龙江省七台河市",
"861452770", "广西南宁市",
"861881980", "广东省广州市",
"861879988", "新疆喀什地区",
"861871904", "广东省深圳市",
"86157120", "广东省深圳市",
"861591637", "广东省惠州市",
"861346960", "宁夏银川市",
"861560613", "江苏省苏州市",
"861577467", "黑龙江省鸡西市",
"861770432", "吉林省吉林市",
"861316977", "广东省茂名市",
"861317069", "云南省德宏傣族景颇族自治州",
"861365813", "四川省绵阳市",
"861709860", "浙江省金华市",
"861319781", "江西省鹰潭市",
"861500727", "湖北省襄樊市",
"861569922", "新疆乌鲁木齐市",
"861537273", "浙江省衢州市",
"86181317", "河北省沧州市",
"861810474", "内蒙古乌兰察布市",
"861458325", "江西省吉安市",
"861479786", "江西省吉安市",
"861342973", "陕西省渭南市",
"861308560", "浙江省嘉兴市",
"861319064", "内蒙古乌兰察布市",
"861370826", "四川省资阳市",
"861538680", "山西省忻州市",
"86147478", "内蒙古巴彦淖尔市",
"86137448", "吉林省长春市",
"86158804", "福建省福州市",
"861522970", "陕西省咸阳市",
"861563638", "黑龙江省牡丹江市",
"86156032", "河北省保定市",
"861880979", "青海省海西蒙古族藏族自治州",
"861858348", "四川省遂宁市",
"861399582", "湖北省鄂州市",
"861351352", "山西省大同市",
"86132213", "浙江省嘉兴市",
"861554524", "黑龙江省齐齐哈尔市",
"861556583", "河南省商丘市",
"861369533", "山东省淄博市",
"86189531", "山东省济南市",
"861884936", "河北省秦皇岛市",
"86150292", "陕西省西安市",
"861341104", "广东省佛山市",
"861302730", "湖南省岳阳市",
"861383895", "河南省南阳市",
"861560994", "新疆昌吉回族自治州",
"861589234", "四川省资阳市",
"86186029", "陕西省西安市",
"861329067", "河北省沧州市",
"861470554", "安徽省淮南市",
"861535040", "江西省南昌市",
"86150781", "广西梧州市",
"86138088", "广东省广州市",
"861780949", "甘肃省陇南市",
"861327397", "河南省信阳市",
"861300623", "江西省鹰潭市",
"861453227", "浙江省金华市",
"861380246", "广东省佛山市",
"861760555", "安徽省马鞍山市",
"86138942", "吉林省吉林市",
"861592945", "陕西省安康市",
"86158568", "安徽省阜阳市",
"861301811", "四川省攀枝花市",
"861361782", "广西柳州市",
"861771192", "西藏日喀则地区",
"861339883", "云南省临沧市",
"861801114", "四川省绵阳市",
"861510482", "内蒙古兴安盟",
"861511921", "广东省韶关市",
"861830933", "甘肃省平凉市",
"861390084", "湖南省岳阳市",
"861843606", "河南省许昌市",
"86181743", "湖南省湘西土家族苗族自治州",
"861459319", "四川省遂宁市",
"861867047", "湖南省衡阳市",
"86134755", "山东省淄博市",
"861303868", "云南省曲靖市",
"861860731", "湖南省长沙市",
"86147951", "广西玉林市",
"861330423", "辽宁省抚顺市",
"861760510", "江苏省无锡市",
"861529665", "山西省长治市",
"86131281", "广东省东莞市",
"861841801", "甘肃省临夏回族自治州",
"861348576", "安徽省滁州市",
"861370794", "江西省抚州市",
"861570917", "陕西省宝鸡市",
"861364799", "江西省萍乡市",
"861863467", "山西省临汾市",
"861556404", "山东省济宁市",
"861889749", "湖南省邵阳市",
"861510738", "湖南省娄底市",
"861806478", "浙江省温州市",
"861361438", "吉林省松原市",
"861335029", "四川省达州市",
"861506898", "浙江省绍兴市",
"861872968", "陕西省商洛市",
"861313278", "广西河池市",
"861707042", "浙江省湖州市",
"861830766", "广东省云浮市",
"861860313", "河北省张家口市",
"861570421", "辽宁省朝阳市",
"861598995", "广东省佛山市",
"861579881", "云南省曲靖市",
"861769931", "新疆喀什地区",
"861780291", "陕西省延安市",
"861862532", "河南省驻马店市",
"861509089", "湖北省宜昌市",
"86159731", "湖南省长沙市",
"861856726", "河南省南阳市",
"861508344", "河南省南阳市",
"861516080", "新疆塔城地区",
"861533811", "广东省江门市",
"861336870", "云南省昭通市",
"861813631", "江苏省宿迁市",
"861881675", "广东省东莞市",
"861354751", "四川省广安市",
"861880909", "新疆博尔塔拉蒙古自治州",
"86180581", "浙江省杭州市",
"861891955", "四川省巴中市",
"861787667", "广东省珠海市",
"861807072", "广西南宁市",
"861454451", "江西省南昌市",
"861580632", "山东省枣庄市",
"861365645", "山东省烟台市",
"861811349", "四川省广安市",
"861892474", "广东省惠州市",
"86151543", "山东省滨州市",
"861853022", "河南省新乡市",
"861478528", "贵州省铜仁地区",
"86134580", "四川省绵阳市",
"86158209", "广东省东莞市",
"861315224", "陕西省宝鸡市",
"861501416", "广东省广州市",
"861868762", "云南省迪庆藏族自治州",
"861397177", "湖北省黄石市",
"86180953", "宁夏吴忠市",
"861872455", "黑龙江省绥化市",
"861389512", "宁夏石嘴山市",
"861322671", "广东省佛山市",
"861368783", "广西桂林市",
"861778193", "四川省达州市",
"861458286", "福建省莆田市",
"861804536", "黑龙江省哈尔滨市",
"86188538", "山东省泰安市",
"861367345", "河南省信阳市",
"861471817", "广东省梅州市",
"861538975", "内蒙古通辽市",
"861810404", "辽宁省本溪市",
"86181310", "河北省邯郸市",
"861332289", "广东省江门市",
"861856738", "河南省新乡市",
"861323993", "新疆石河子市",
"861770788", "广西河池市",
"861700549", "山东省青岛市",
"861358692", "浙江省宁波市",
"861332863", "福建省龙岩市",
"861896698", "陕西省榆林市",
"861787774", "湖南省邵阳市",
"861531544", "山东省德州市",
"861804098", "新疆喀什地区",
"861812659", "广东省肇庆市",
"861708382", "河南省新乡市",
"861872410", "江苏省扬州市",
"861827095", "江西省宜春市",
"861322087", "山东省青岛市",
"86157127", "山东省青岛市",
"861379722", "湖北省咸宁市",
"861478536", "贵州省六盘水市",
"86133233", "天津市",
"861470882", "云南省德宏傣族景颇族自治州",
"861832494", "安徽省宿州市",
"861814880", "广东省中山市",
"861510945", "甘肃省金昌市",
"861510726", "湖北省荆门市",
"86139677", "浙江省温州市",
"861361426", "辽宁省大连市",
"861572586", "山东省东营市",
"861329356", "山西省晋城市",
"86132435", "重庆市",
"861306976", "黑龙江省佳木斯市",
"861893411", "广东省清远市",
"861558648", "湖北省荆州市",
"86139612", "江苏省常州市",
"861899151", "陕西省安康市",
"861393437", "山西省运城市",
"861772612", "湖南省湘潭市",
"861560142", "江苏省泰州市",
"861800579", "浙江省金华市",
"861562433", "山东省德州市",
"861385135", "江苏省宿迁市",
"86186062", "江苏省苏州市",
"861453697", "陕西省渭南市",
"86138905", "四川省内江市",
"861590359", "山西省运城市",
"861859643", "福建省厦门市",
"861886021", "河南省商丘市",
"86159561", "安徽省淮北市",
"861893927", "河南省鹤壁市",
"861597623", "广东省惠州市",
"861532874", "四川省眉山市",
"861323546", "湖北省恩施土家族苗族自治州",
"861348781", "湖南省益阳市",
"861780540", "山东省菏泽市",
"861539784", "江西省上饶市",
"861575118", "江苏省宿迁市",
"86183349", "山西省朔州市",
"861325106", "浙江省台州市",
"861598419", "四川省自贡市",
"861364254", "广东省清远市",
"861812896", "广东省阳江市",
"861562670", "广东省茂名市",
"861819021", "四川省甘孜藏族自治州",
"861770956", "宁夏中卫市",
"861533790", "陕西省西安市",
"861887017", "江西省鹰潭市",
"861868802", "广东省汕头市",
"861568552", "贵州省遵义市",
"861811973", "安徽省蚌埠市",
"861370259", "广东省江门市",
"861760919", "陕西省铜川市",
"861521849", "广东省清远市",
"861562442", "山东省德州市",
"86180369", "江苏省宿迁市",
"861800685", "浙江省绍兴市",
"861805230", "江苏省连云港市",
"861330891", "西藏拉萨市",
"861453945", "广东省江门市",
"86153387", "广东省深圳市",
"861322323", "河北省保定市",
"86131308", "辽宁省朝阳市",
"861350413", "辽宁省抚顺市",
"861337676", "广东省潮州市",
"861354895", "湖南省长沙市",
"861859632", "山东省枣庄市",
"861708877", "广东省茂名市",
"861380747", "湖南省衡阳市",
"861317407", "江苏省南京市",
"86130180", "湖北省武汉市",
"861830806", "西藏那曲地区",
"861530556", "安徽省安庆市",
"861583524", "山西省大同市",
"861775049", "福建省泉州市",
"861786270", "山东省威海市",
"861303128", "新疆喀什地区",
"861372083", "福建省福州市",
"861459537", "西藏阿里地区",
"861325894", "山东省日照市",
"86139137", "江苏省苏州市",
"861362498", "辽宁省大连市",
"861302261", "浙江省湖州市",
"861884803", "内蒙古通辽市",
"86187619", "江苏省苏州市",
"861332005", "江西省宜春市",
"86184181", "甘肃省天水市",
"861479287", "安徽省亳州市",
"861316512", "山东省济南市",
"861479501", "宁夏银川市",
"861373997", "内蒙古包头市",
"861340468", "吉林省吉林市",
"861534514", "江苏省扬州市",
"861569965", "黑龙江省大庆市",
"861861592", "山东省济宁市",
"86131126", "广东省惠州市",
"86181554", "安徽省淮南市",
"861880570", "浙江省衢州市",
"861550749", "湖南省长沙市",
"861390230", "广东省广州市",
"86138294", "广东省汕头市",
"861774693", "河南省鹤壁市",
"861346569", "山东省潍坊市",
"861303136", "新疆伊犁哈萨克自治州",
"861890724", "湖北省咸宁市",
"861595671", "安徽省淮北市",
"861518639", "贵州省黔西南布依族苗族自治州",
"861300301", "安徽省蚌埠市",
"861857445", "湖南省永州市",
"861809740", "青海省西宁市",
"861814319", "吉林省白山市",
"861580643", "山东省淄博市",
"861590885", "云南省昆明市",
"861340337", "河北省沧州市",
"861818902", "西藏日喀则地区",
"861894940", "安徽省芜湖市",
"86159389", "河南省平顶山市",
"861357736", "云南省曲靖市",
"861390871", "云南省昆明市",
"861319506", "宁夏石嘴山市",
"86150944", "河北省邢台市",
"86131450", "江苏省苏州市",
"861344383", "广西桂林市",
"861782889", "四川省达州市",
"861380358", "江西省赣州市",
"861571088", "广东省广州市",
"861310793", "福建省福州市",
"861840311", "河北省石家庄市",
"861589080", "河南省驻马店市",
"861707948", "河南省郑州市",
"86155527", "山东省东营市",
"861855974", "福建省龙岩市",
"861840966", "宁夏石嘴山市",
"86130636", "江苏省无锡市",
"861505908", "福建省龙岩市",
"861358265", "河北省唐山市",
"861318188", "山东省威海市",
"861551296", "河北省衡水市",
"86153964", "福建省泉州市",
"861566663", "山东省滨州市",
"861394341", "吉林省通化市",
"861768390", "湖北省襄樊市",
"861372785", "广东省珠海市",
"861572771", "江西省鹰潭市",
"861868453", "湖南省株洲市",
"861309577", "浙江省温州市",
"86137721", "陕西省西安市",
"861863079", "河北省廊坊市",
"861525562", "安徽省合肥市",
"861340955", "宁夏中卫市",
"861569458", "黑龙江省伊春市",
"861800900", "四川省凉山彝族自治州",
"86136716", "上海市",
"861452860", "青海省海北藏族自治州",
"861554148", "辽宁省葫芦岛市",
"861520913", "陕西省渭南市",
"861870852", "贵州省遵义市",
"861453738", "湖南省长沙市",
"861570502", "内蒙古兴安盟",
"861362901", "四川省资阳市",
"861768906", "西藏那曲地区",
"861519865", "云南省丽江市",
"861862543", "河南省鹤壁市",
"861335376", "河南省信阳市",
"861539061", "甘肃省临夏回族自治州",
"861598647", "广东省梅州市",
"861709770", "浙江省台州市",
"861340910", "陕西省咸阳市",
"86182914", "陕西省西安市",
"861332703", "内蒙古乌海市",
"861800396", "河南省驻马店市",
"861772835", "广东省汕头市",
"861325738", "湖南省娄底市",
"861820394", "河南省周口市",
"861535221", "甘肃省天水市",
"861570572", "浙江省湖州市",
"861569598", "福建省三明市",
"861804144", "辽宁省本溪市",
"86180322", "河北省石家庄市",
"861890896", "西藏那曲地区",
"861479958", "新疆博尔塔拉蒙古自治州",
"861329479", "内蒙古锡林郭勒盟",
"861471546", "广东省云浮市",
"861453482", "内蒙古包头市",
"861871535", "安徽省淮南市",
"861332773", "江苏省南京市",
"861342828", "广东省江门市",
"861335306", "广东省汕头市",
"861868593", "贵州省遵义市",
"861309507", "新疆哈密地区",
"861811168", "四川省甘孜藏族自治州",
"861309281", "四川省攀枝花市",
"861898758", "云南省昆明市",
"861843264", "河北省沧州市",
"861830942", "甘肃省定西市",
"861512182", "宁夏石嘴山市",
"861590476", "内蒙古赤峰市",
"86131642", "北京市",
"861581187", "广东省广州市",
"861800970", "青海省海北藏族自治州",
"861313814", "广东省珠海市",
"861334232", "辽宁省阜新市",
"861360044", "广东省深圳市",
"861332123", "甘肃省庆阳市",
"861478144", "四川省广元市",
"861335990", "黑龙江省大兴安岭地区",
"861376298", "湖南省永州市",
"861591798", "广东省揭阳市",
"861700940", "广东省佛山市",
"86139686", "浙江省台州市",
"861551638", "河南省洛阳市",
"861536039", "广东省云浮市",
"861810397", "河南省商丘市",
"861558567", "吉林省通化市",
"861862370", "河南省开封市",
"861357963", "新疆昌吉回族自治州",
"861363352", "山西省大同市",
"86155520", "山东省菏泽市",
"861855904", "福建省龙岩市",
"861458787", "湖南省衡阳市",
"861396333", "山东省日照市",
"86150339", "河北省唐山市",
"861595601", "安徽省宿州市",
"861762503", "江苏省无锡市",
"86182092", "陕西省西安市",
"861328000", "山东省济南市",
"861853065", "河南省南阳市",
"861778934", "甘肃省武威市",
"86131457", "广东省广州市",
"861840733", "湖南省长沙市",
"861369542", "山东省青岛市",
"861457058", "新疆克孜勒苏柯尔克孜自治州",
"861868946", "广东省深圳市",
"861472876", "贵州省黔西南布依族苗族自治州",
"861559332", "甘肃省平凉市",
"861323817", "辽宁省鞍山市",
"861319576", "青海省西宁市",
"861839702", "青海省海东地区",
"861561553", "山东省淄博市",
"861835789", "浙江省丽水市",
"861867268", "湖北省武汉市",
"861301790", "浙江省湖州市",
"861807491", "广西南宁市",
"861332075", "四川省广元市",
"861362558", "安徽省阜阳市",
"861884873", "云南省文山壮族苗族自治州",
"861880500", "福建省福州市",
"861303708", "山西省吕梁市",
"861887578", "河北省沧州市",
"861580850", "贵州省贵阳市",
"861530496", "辽宁省本溪市",
"861884022", "陕西省榆林市",
"861347460", "陕西省咸阳市",
"861870584", "浙江省宁波市",
"861305896", "浙江省金华市",
"861576967", "宁夏银川市",
"861597301", "湖南省岳阳市",
"861317477", "浙江省台州市",
"86186683", "浙江省嘉兴市",
"861830876", "云南省文山壮族苗族自治州",
"861350720", "湖北省宜昌市",
"861857982", "广西柳州市",
"861522509", "河南省郑州市",
"861479465", "黑龙江省鸡西市",
"861368448", "四川省巴中市",
"861450420", "辽宁省大连市",
"861812174", "江苏省泰州市",
"861453894", "云南省大理白族自治州",
"861532677", "内蒙古鄂尔多斯市",
"861352633", "河南省商丘市",
"861363914", "贵州省贵阳市",
"861580815", "四川省雅安市",
"861512406", "辽宁省朝阳市",
"861470307", "河北省沧州市",
"861559979", "新疆昌吉回族自治州",
"86130254", "广东省深圳市",
"861818339", "四川省泸州市",
"861895371", "山东省枣庄市",
"861336760", "广西梧州市",
"861845837", "浙江省嘉兴市",
"861568492", "湖南省邵阳市",
"861342836", "广东省佛山市",
"861325726", "湖北省恩施土家族苗族自治州",
"861847416", "湖南省娄底市",
"861870473", "内蒙古乌海市",
"861337606", "江苏省南京市",
"86133865", "浙江省台州市",
"861529292", "新疆喀什地区",
"86183355", "山西省长治市",
"861880343", "山西省阳泉市",
"86187475", "内蒙古通辽市",
"861807163", "江苏省盐城市",
"861787548", "广东省广州市",
"861518984", "江苏省南京市",
"861327474", "内蒙古兴安盟",
"861527191", "湖北省武汉市",
"861815261", "湖南省岳阳市",
"861532218", "广东省云浮市",
"861820069", "广东省江门市",
"861311541", "黑龙江省哈尔滨市",
"861569028", "河北省沧州市",
"861811903", "新疆哈密地区",
"86183658", "山东省聊城市",
"861345811", "四川省攀枝花市",
"861325176", "吉林省白城市",
"861818846", "四川省攀枝花市",
"861838901", "西藏拉萨市",
"861310195", "江苏省扬州市",
"861302653", "山东省青岛市",
"861590756", "广东省珠海市",
"86138530", "山东省菏泽市",
"861569708", "云南省楚雄彝族自治州",
"861317348", "山东省泰安市",
"86189703", "江西省上饶市",
"86131318", "河北省衡水市",
"861762525", "江苏省苏州市",
"861310484", "河北省邢台市",
"861338543", "山东省滨州市",
"861368377", "河南省南阳市",
"861537947", "甘肃省武威市",
"861319824", "四川省广元市",
"861833643", "河南省安阳市",
"861887117", "湖北省武汉市",
"861564671", "山东省济宁市",
"861572591", "山东省济宁市",
"861309797", "广西钦州市",
"861510564", "安徽省六安市",
"861804216", "浙江省台州市",
"861329759", "湖北省黄冈市",
"861325006", "广东省珠海市",
"861510329", "河北省邢台市",
"861813957", "新疆喀什地区",
"861865940", "福建省泉州市",
"861803443", "河北省秦皇岛市",
"861594714", "内蒙古赤峰市",
"861305074", "辽宁省阜新市",
"861877577", "广西北海市",
"861852480", "辽宁省辽阳市",
"861394997", "河南省周口市",
"86184473", "内蒙古兴安盟",
"861310573", "浙江省嘉兴市",
"861320487", "内蒙古鄂尔多斯市",
"86135843", "江苏省常州市",
"861526846", "浙江省绍兴市",
"861324433", "吉林省延边朝鲜族自治州",
"861350000", "广东省广州市",
"861875857", "浙江省杭州市",
"86185892", "广东省广州市",
"861357078", "广东省韶关市",
"86152628", "江苏省南通市",
"86156811", "四川省绵阳市",
"861329827", "河南省三门峡市",
"861338300", "河北省邯郸市",
"861825091", "福建省宁德市",
"861560948", "甘肃省酒泉市",
"861551354", "山西省晋中市",
"861824923", "黑龙江省佳木斯市",
"861552516", "山西省长治市",
"861505063", "江苏省南通市",
"86145873", "广东省广州市",
"86187609", "云南省大理白族自治州",
"861452999", "内蒙古鄂尔多斯市",
"861304260", "辽宁省鞍山市",
"861365341", "山西省太原市",
"861372183", "河南省南阳市",
"861520567", "安徽省阜阳市",
"861519062", "江苏省泰州市",
"861362819", "四川省乐山市",
"861303028", "广东省云浮市",
"861577109", "湖北省十堰市",
"861321412", "辽宁省鞍山市",
"861881371", "广东省中山市",
"861775149", "江苏省无锡市",
"861867439", "湖南省长沙市",
"86152325", "河北省唐山市",
"861871441", "黑龙江省牡丹江市",
"861560735", "湖南省郴州市",
"861586410", "山东省济宁市",
"861869434", "甘肃省兰州市",
"86158049", "辽宁省朝阳市",
"861383471", "山西省运城市",
"861868005", "广东省东莞市",
"861301500", "内蒙古呼和浩特市",
"861864301", "吉林省四平市",
"861538878", "云南省普洱市",
"861861772", "河北省沧州市",
"861317757", "江西省宜春市",
"861839873", "四川省自贡市",
"861880790", "江西省新余市",
"861303598", "云南省西双版纳傣族自治州",
"86177022", "天津市",
"86188671", "浙江省杭州市",
"861550987", "辽宁省沈阳市",
"861334977", "湖北省宜昌市",
"861808698", "四川省广安市",
"861354092", "四川省乐山市",
"861888665", "四川省广元市",
"861379551", "四川省眉山市",
"86187652", "山东省青岛市",
"861773970", "河南省三门峡市",
"861539493", "云南省曲靖市",
"861586455", "山东省济宁市",
"861303036", "河南省三门峡市",
"861563281", "河北省唐山市",
"861322375", "河南省新乡市",
"861815840", "浙江省杭州市",
"861315648", "山东省青岛市",
"861388656", "湖北省荆州市",
"86182904", "重庆市",
"861301343", "云南省楚雄彝族自治州",
"861830524", "江苏省宿迁市",
"86178084", "贵州省铜仁地区",
"861539161", "湖北省黄冈市",
"861889839", "广东省中山市",
"861380989", "广东省深圳市",
"861364900", "四川省内江市",
"861830369", "河南省洛阳市",
"861554048", "内蒙古呼伦贝尔市",
"86136706", "广东省佛山市",
"861308890", "陕西省宝鸡市",
"861454861", "河南省平顶山市",
"861889346", "甘肃省兰州市",
"861845246", "江苏省扬州市",
"861342247", "广东省汕头市",
"861870753", "广东省梅州市",
"86188434", "吉林省四平市",
"861317829", "福建省三明市",
"861879476", "甘肃省兰州市",
"861336511", "江苏省扬州市",
"861561061", "山东省潍坊市",
"861533570", "湖北省宜昌市",
"861364396", "河南省驻马店市",
"861501658", "广东省云浮市",
"861398145", "四川省达州市",
"861348297", "河北省秦皇岛市",
"861879406", "甘肃省临夏回族自治州",
"86135441", "广东省深圳市",
"86184871", "云南省昆明市",
"861360144", "江苏省扬州市",
"861478044", "四川省成都市",
"86187440", "吉林省长春市",
"861328413", "辽宁省抚顺市",
"861302840", "陕西省西安市",
"861896644", "浙江省舟山市",
"861897187", "湖北省恩施土家族苗族自治州",
"861370357", "山西省临汾市",
"861459716", "山东省威海市",
"861392195", "江苏省苏州市",
"861332872", "福建省漳州市",
"86156413", "辽宁省抚顺市",
"861705260", "黑龙江省哈尔滨市",
"861768045", "湖南省岳阳市",
"861533500", "江苏省常州市",
"861779953", "新疆阿克苏地区",
"861356853", "四川省资阳市",
"861780325", "河北省唐山市",
"861576513", "黑龙江省佳木斯市",
"86132152", "广东省东莞市",
"861826639", "山东省青岛市",
"861398906", "西藏那曲地区",
"86186265", "吉林省通化市",
"861804044", "四川省南充市",
"86139795", "江西省宜春市",
"861860841", "湖南省长沙市",
"861364970", "青海省海北藏族自治州",
"861773900", "河南省商丘市",
"861898991", "西藏拉萨市",
"861303458", "山东省威海市",
"861458621", "湖北省十堰市",
"861859460", "福建省漳州市",
"861760871", "云南省昆明市",
"861771998", "河南省焦作市",
"861363205", "广东省江门市",
"861533343", "山西省太原市",
"86188080", "四川省成都市",
"86147923", "安徽省合肥市",
"861579724", "湖北省荆州市",
"861870425", "辽宁省盘锦市",
"861333658", "广东省阳江市",
"86145958", "陕西省西安市",
"861301570", "福建省宁德市",
"861479791", "江西省鹰潭市",
"861306488", "江苏省扬州市",
"861454586", "甘肃省酒泉市",
"861383401", "山西省吕梁市",
"861808236", "江苏省泰州市",
"861848586", "贵州省六盘水市",
"861331542", "河北省保定市",
"861802648", "广东省惠州市",
"861840832", "四川省内江市",
"861835262", "江苏省泰州市",
"861334907", "安徽省安庆市",
"861345909", "福建省莆田市",
"861708429", "云南省文山壮族苗族自治州",
"861539553", "安徽省芜湖市",
"861476549", "福建省福州市",
"861309118", "河北省衡水市",
"861810629", "江苏省南通市",
"861803956", "河南省洛阳市",
"861768743", "广西桂林市",
"861335869", "辽宁省抚顺市",
"861320265", "广东省东莞市",
"861586025", "福建省福州市",
"861473060", "河北省唐山市",
"861396560", "安徽省马鞍山市",
"861452241", "浙江省杭州市",
"861458949", "广东省中山市",
"86189375", "河南省平顶山市",
"861319796", "江西省吉安市",
"861370748", "湖南省长沙市",
"86825", "四川省遂宁市",
"861844949", "新疆吐鲁番地区",
"861332946", "黑龙江省黑河市",
"861772032", "湖北省咸宁市",
"861332725", "湖南省怀化市",
"861587519", "广东省揭阳市",
"861855250", "江苏省镇江市",
"861585117", "江苏省宿迁市",
"861589646", "江苏省无锡市",
"861839452", "甘肃省兰州市",
"861877018", "江西省抚州市",
"861534080", "山西省晋中市",
"861776610", "江苏省南京市",
"861810941", "甘肃省甘南藏族自治州",
"861380634", "山东省莱芜市",
"861338370", "河南省商丘市",
"861332175", "广西玉林市",
"86189678", "浙江省宁波市",
"861599110", "陕西省延安市",
"861815653", "安徽省合肥市",
"861529361", "甘肃省张掖市",
"861379908", "福建省龙岩市",
"861371984", "广东省云浮市",
"861809393", "甘肃省甘南藏族自治州",
"861814678", "江西省南昌市",
"861381900", "浙江省衢州市",
"861877507", "广西玉林市",
"861508398", "江西省景德镇市",
"861868123", "四川省攀枝花市",
"861357517", "湖南省常德市",
"861383998", "河南省开封市",
"861569778", "广西河池市",
"861771401", "江苏省常州市",
"861310340", "山西省大同市",
"86138537", "山东省济宁市",
"861599403", "河南省平顶山市",
"861570792", "江西省九江市",
"861709415", "广东省珠海市",
"861815392", "甘肃省定西市",
"861822681", "安徽省滁州市",
"86147574", "浙江省杭州市",
"861556629", "辽宁省抚顺市",
"861845014", "福建省漳州市",
"861390919", "陕西省铜川市",
"861332593", "浙江省嘉兴市",
"861769854", "河南省洛阳市",
"861873549", "山西省朔州市",
"861891239", "江苏省无锡市",
"861538768", "四川省阿坝藏族羌族自治州",
"861850514", "江苏省扬州市",
"861781712", "广东省广州市",
"861772938", "陕西省西安市",
"861312555", "辽宁省本溪市",
"86156863", "陕西省商洛市",
"86186431", "吉林省长春市",
"86185334", "河北省唐山市",
"861771522", "江苏省镇江市",
"861580460", "黑龙江省哈尔滨市",
"861533979", "甘肃省陇南市",
"86189138", "江苏省南京市",
"861824808", "内蒙古鄂尔多斯市",
"861318445", "浙江省绍兴市",
"861583048", "河北省衡水市",
"86185955", "河南省郑州市",
"861818736", "云南省红河哈尼族彝族自治州",
"861357902", "新疆巴音郭楞蒙古自治州",
"86155980", "内蒙古呼和浩特市",
"861872822", "四川省阿坝藏族羌族自治州",
"861780787", "广西河池市",
"861554806", "内蒙古通辽市",
"86152194", "广东省深圳市",
"861325564", "山东省威海市",
"861516646", "山东省潍坊市",
"861345570", "山东省东营市",
"861454121", "河北省石家庄市",
"86181307", "安徽省阜阳市",
"861367090", "广东省佛山市",
"861459608", "宁夏中卫市",
"86158161", "广东省潮州市",
"861317169", "河北省保定市",
"861566672", "山东省东营市",
"861772043", "湖北省恩施土家族苗族自治州",
"861847658", "广东省中山市",
"861330561", "安徽省淮北市",
"861835695", "安徽省合肥市",
"86170732", "河北省保定市",
"861705313", "重庆市",
"861500681", "山东省莱芜市",
"861319627", "吉林省四平市",
"861301909", "黑龙江省齐齐哈尔市",
"861348824", "陕西省延安市",
"861887637", "福建省泉州市",
"861308333", "安徽省滁州市",
"86186674", "浙江省宁波市",
"861807486", "广西百色市",
"861311983", "广东省汕尾市",
"861454771", "山东省枣庄市",
"861566440", "山东省德州市",
"861315567", "安徽省亳州市",
"861848771", "云南省玉溪市",
"861805495", "福建省三明市",
"861811247", "江苏省无锡市",
"861365712", "湖北省孝感市",
"86131820", "江苏省扬州市",
"861330475", "内蒙古通辽市",
"861317256", "广东省潮州市",
"861530481", "黑龙江省哈尔滨市",
"861841919", "甘肃省天水市",
"861332387", "河南省周口市",
"861819861", "贵州省贵阳市",
"861588253", "四川省遂宁市",
"861785883", "浙江省杭州市",
"86132203", "重庆市",
"861882967", "陕西省宝鸡市",
"861889258", "贵州省黔南布依族苗族自治州",
"86183891", "山东省威海市",
"861334512", "山东省济南市",
"861533332", "河北省保定市",
"861512988", "陕西省西安市",
"861532526", "浙江省嘉兴市",
"861363089", "河北省邢台市",
"861320692", "黑龙江省绥化市",
"861524971", "河南省新乡市",
"861580918", "陕西省西安市",
"861871215", "安徽省安庆市",
"86170956", "江苏省徐州市",
"861319164", "河北省保定市",
"861452590", "福建省福州市",
"861331533", "河北省张家口市",
"861840843", "宁夏吴忠市",
"861809587", "新疆阿克苏地区",
"861772926", "陕西省商洛市",
"861355984", "福建省南平市",
"86578", "浙江省丽水市",
"861378921", "湖南省永州市",
"861850646", "山东省东营市",
"861362444", "吉林省四平市",
"861709999", "广东省广州市",
"861450635", "黑龙江省绥化市",
"861356091", "广东省肇庆市",
"861325848", "四川省遂宁市",
"861568101", "四川省德阳市",
"861394813", "内蒙古通辽市",
"861867147", "湖北省襄樊市",
"861866684", "广东省茂名市",
"861878431", "四川省内江市",
"861520648", "山东省菏泽市",
"861390495", "辽宁省丹东市",
"861399931", "新疆克拉玛依市",
"861858407", "四川省成都市",
"861590257", "贵州省毕节地区",
"861346899", "陕西省渭南市",
"861335709", "浙江省丽水市",
"861339056", "辽宁省沈阳市",
"861890881", "云南省西双版纳傣族自治州",
"861361883", "云南省临沧市",
"861339782", "广西柳州市",
"861361269", "广东省东莞市",
"861320353", "山西省阳泉市",
"861378417", "河北省衡水市",
"86135144", "吉林省长春市",
"861866302", "山东省聊城市",
"861828080", "四川省南充市",
"861368554", "安徽省淮南市",
"861535140", "四川省广元市",
"86159356", "山西省晋中市",
"86139645", "山东省烟台市",
"861478717", "云南省玉溪市",
"861895675", "安徽省亳州市",
"86181458", "广东省深圳市",
"861301332", "云南省昆明市",
"861509189", "陕西省西安市",
"861800799", "江西省萍乡市",
"861884862", "贵州省毕节地区",
"86188131", "北京市",
"861505102", "江苏省宿迁市",
"861820757", "广东省佛山市",
"861318982", "广东省湛江市",
"861839928", "新疆伊犁哈萨克自治州",
"861390555", "安徽省马鞍山市",
"861816346", "广东省揭阳市",
"861335779", "江苏省泰州市",
"861506419", "山东省泰安市",
"861770660", "浙江省宁波市",
"861572240", "江苏省徐州市",
"861339438", "吉林省松原市",
"861535395", "陕西省渭南市",
"861458303", "江西省鹰潭市",
"861337527", "江苏省扬州市",
"86147309", "四川省成都市",
"861503533", "山西省阳泉市",
"861304313", "河北省秦皇岛市",
"861390510", "江苏省盐城市",
"861335129", "黑龙江省大庆市",
"861818108", "四川省南充市",
"861453848", "四川省南充市",
"861323280", "广东省清远市",
"861354998", "广东省佛山市",
"861347643", "湖北省襄樊市",
"861558897", "山东省青岛市",
"861527640", "新疆阿克苏地区",
"861314760", "吉林省白城市",
"861452415", "辽宁省丹东市",
"861810754", "广东省汕头市",
"861300980", "黑龙江省哈尔滨市",
"861524901", "陕西省榆林市",
"861565147", "江苏省淮安市",
"861458540", "河南省漯河市",
"861856076", "山东省济南市",
"86155364", "山西省吕梁市",
"861360528", "江苏省镇江市",
"86186833", "四川省乐山市",
"861357846", "云南省怒江傈僳族自治州",
"861571531", "山东省济南市",
"861593241", "河北省承德市",
"86159168", "广东省东莞市",
"861890566", "安徽省池州市",
"861452450", "黑龙江省哈尔滨市",
"861569868", "山西省吕梁市",
"861321060", "山东省莱芜市",
"861826119", "江苏省常州市",
"861837140", "湖北省黄石市",
"861597675", "广东省汕尾市",
"86137753", "江苏省镇江市",
"861787594", "广东省阳江市",
"86177141", "江苏省连云港市",
"861855441", "山东省菏泽市",
"861320222", "广东省揭阳市",
"861368882", "广东省深圳市",
"861454701", "浙江省杭州市",
"861586062", "福建省漳州市",
"861550346", "山西省太原市",
"861888292", "四川省阿坝藏族羌族自治州",
"861590988", "辽宁省沈阳市",
"861808737", "云南省昆明市",
"861324442", "吉林省长春市",
"861360536", "山东省潍坊市",
"861538046", "江苏省常州市",
"861322187", "浙江省宁波市",
"861570563", "安徽省宣城市",
"861820348", "山西省吕梁市",
"86131827", "江苏省无锡市",
"861555188", "安徽省阜阳市",
"861332762", "青海省海东地区",
"861566602", "山东省淄博市",
"861370483", "黑龙江省牡丹江市",
"861379072", "广东省中山市",
"861360098", "福建省龙岩市",
"861345500", "山东省日照市",
"86181300", "安徽省合肥市",
"861550839", "四川省广元市",
"861301979", "黑龙江省七台河市",
"861563354", "河北省衡水市",
"8613876", "海南省海口市",
"861778093", "四川省广安市",
"861470783", "广西桂林市",
"861707845", "云南省德宏傣族景颇族自治州",
"861575912", "福建省漳州市",
"861595375", "山东省德州市",
"861308711", "内蒙古呼和浩特市",
"86133024", "广东省深圳市",
"861801246", "江苏省无锡市",
"861760761", "广东省深圳市",
"861306045", "陕西省汉中市",
"861802567", "广东省中山市",
"861881623", "江苏省盐城市",
"861824878", "江苏省南京市",
"861535686", "浙江省台州市",
"861872003", "江西省宜春市",
"861880811", "四川省绵阳市",
"86138915", "陕西省安康市",
"861339426", "辽宁省丹东市",
"861536447", "湖南省永州市",
"861534234", "湖北省武汉市",
"86183493", "四川省成都市",
"861537695", "山东省烟台市",
"86139602", "福建省泉州市",
"86147352", "山西省大同市",
"86180188", "上海市",
"861330886", "云南省怒江傈僳族自治州",
"861513812", "河南省驻马店市",
"861357972", "新疆伊犁哈萨克自治州",
"86155987", "内蒙古鄂尔多斯市",
"861338532", "山东省青岛市",
"861839936", "新疆喀什地区",
"86185949", "广东省广州市",
"861364579", "浙江省金华市",
"861303922", "吉林省长春市",
"861372699", "广东省清远市",
"861330153", "江苏省无锡市",
"861337097", "山东省聊城市",
"861348796", "湖南省邵阳市",
"861309626", "四川省甘孜藏族自治州",
"861370574", "浙江省宁波市",
"861505486", "山东省济宁市",
"861521739", "广东省佛山市",
"861588322", "四川省资阳市",
"861803432", "河北省张家口市",
"861818963", "甘肃省张掖市",
"861776130", "四川省成都市",
"861386824", "浙江省舟山市",
"861889987", "广东省佛山市",
"861559790", "贵州省铜仁地区",
"861524498", "四川省凉山彝族自治州",
"861384883", "内蒙古包头市",
"861760604", "福建省宁德市",
"861866074", "山东省济南市",
"861890887", "云南省迪庆藏族自治州",
"861301034", "江苏省南京市",
"861321458", "黑龙江省伊春市",
"861590251", "贵州省贵阳市",
"861858401", "四川省内江市",
"861399937", "新疆伊犁哈萨克自治州",
"861869242", "湖南省湘潭市",
"861559614", "陕西省咸阳市",
"861774609", "福建省福州市",
"861378411", "河北省廊坊市",
"86181427", "辽宁省盘锦市",
"861768549", "山东省烟台市",
"861772416", "广东省肇庆市",
"861897538", "湖南省益阳市",
"861478711", "云南省昆明市",
"861588594", "贵州省六盘水市",
"861336972", "青海省海东地区",
"861864882", "广西来宾市",
"86158572", "浙江省湖州市",
"861310709", "湖南省邵阳市",
"861780064", "内蒙古赤峰市",
"861352953", "云南省德宏傣族景颇族自治州",
"861378927", "湖南省怀化市",
"861788910", "西藏拉萨市",
"861813744", "河南省商丘市",
"861822552", "安徽省蚌埠市",
"861323570", "浙江省衢州市",
"861829864", "甘肃省甘南藏族自治州",
"86189436", "吉林省长春市",
"861356097", "广东省梅州市",
"86157551", "安徽省合肥市",
"861878437", "四川省攀枝花市",
"861832980", "陕西省延安市",
"86158517", "江苏省淮安市",
"861871139", "湖南省株洲市",
"861388165", "四川省巴中市",
"861760382", "河南省开封市",
"861454664", "广东省中山市",
"861524977", "河南省商丘市",
"861479626", "广西北海市",
"861450858", "江苏省盐城市",
"861538720", "湖北省黄冈市",
"86135757", "浙江省杭州市",
"86182201", "陕西省延安市",
"861809581", "新疆喀什地区",
"861351585", "浙江省绍兴市",
"861328878", "广东省潮州市",
"86183842", "四川省成都市",
"861815148", "江苏省无锡市",
"861806341", "山东省济南市",
"86188710", "湖北省襄樊市",
"861819867", "贵州省黔南布依族苗族自治州",
"861898645", "湖北省孝感市",
"861580428", "辽宁省朝阳市",
"861882961", "陕西省延安市",
"861314963", "黑龙江省牡丹江市",
"861888269", "四川省广安市",
"861586099", "福建省南平市",
"861458796", "湖南省株洲市",
"861475566", "安徽省池州市",
"861363679", "陕西省榆林市",
"861882316", "广东省深圳市",
"861881554", "安徽省淮南市",
"861551465", "河南省驻马店市",
"861332799", "江苏省盐城市",
"861766044", "山东省青岛市",
"861329493", "云南省昆明市",
"861847132", "湖北省黄冈市",
"861508142", "河北省保定市",
"861333143", "吉林省辽源市",
"861317944", "江苏省无锡市",
"861887631", "福建省漳州市",
"861454777", "山东省青岛市",
"86133628", "浙江省宁波市",
"861474313", "吉林省延边朝鲜族自治州",
"861596033", "福建省龙岩市",
"86130309", "福建省宁德市",
"861570879", "云南省普洱市",
"861587015", "贵州省安顺市",
"86181368", "江苏省南京市",
"861811241", "江苏省扬州市",
"861814982", "新疆昌吉回族自治州",
"861534433", "吉林省延边朝鲜族自治州",
"861586529", "山东省济南市",
"861802153", "江苏省南京市",
"861315561", "安徽省淮北市",
"861479638", "江西省景德镇市",
"861530487", "黑龙江省鸡西市",
"86131858", "浙江省温州市",
"861566082", "河南省鹤壁市",
"861559993", "新疆和田地区",
"861341939", "四川省遂宁市",
"861454127", "河北省沧州市",
"861336339", "河北省唐山市",
"861576719", "广东省湛江市",
"861321965", "四川省自贡市",
"861379374", "山东省枣庄市",
"861580436", "吉林省白城市",
"861330567", "安徽省宿州市",
"861531412", "山东省济南市",
"86180224", "广东省广州市",
"861858998", "广西柳州市",
"861502944", "陕西省咸阳市",
"86181665", "重庆市",
"861876028", "福建省三明市",
"861315475", "内蒙古通辽市",
"861808313", "贵州省黔南布依族苗族自治州",
"861319621", "吉林省吉林市",
"861500687", "山东省东营市",
"86156351", "山西省太原市",
"861342415", "广东省深圳市",
"86155454", "黑龙江省哈尔滨市",
"861821956", "广东省东莞市",
"86159882", "浙江省绍兴市",
"861559546", "宁夏中卫市",
"861528543", "贵州省铜仁地区",
"861560344", "山西省晋中市",
"861356527", "新疆塔城地区",
"861350534", "山东省德州市",
"861348540", "山西省忻州市",
"861829548", "宁夏银川市",
"861391219", "江苏省泰州市",
"861780781", "广西南宁市",
"861847835", "湖南省湘西土家族苗族自治州",
"861377932", "新疆巴音郭楞蒙古自治州",
"861370284", "广东省江门市",
"861553356", "河北省唐山市",
"861800762", "广东省河源市",
"861884899", "河南省洛阳市",
"861318716", "湖南省衡阳市",
"861387278", "湖北省十堰市",
"861877422", "湖南省衡阳市",
"861872683", "安徽省黄山市",
"861535006", "江西省吉安市",
"861367568", "安徽省阜阳市",
"861369849", "江西省萍乡市",
"861337091", "山东省烟台市",
"86131524", "陕西省西安市",
"861380270", "广东省深圳市",
"861339916", "陕西省汉中市",
"861387208", "湖北省黄石市",
"861843402", "山西省太原市",
"861885015", "福建省厦门市",
"861816212", "江西省九江市",
"861889981", "广东省中山市",
"861360560", "安徽省合肥市",
"861309152", "黑龙江省黑河市",
"861315886", "四川省绵阳市",
"861535076", "河北省沧州市",
"861457112", "湖北省武汉市",
"861802561", "广东省汕头市",
"861709962", "浙江省舟山市",
"861760767", "广东省深圳市",
"861598345", "四川省广安市",
"86156919", "陕西省西安市",
"861880817", "四川省南充市",
"861569820", "山东省威海市",
"861303412", "甘肃省天水市",
"86150832", "河南省濮阳市",
"861536441", "湖南省湘西土家族苗族自治州",
"861311780", "江西省南昌市",
"86150125", "广东省深圳市",
"861560480", "黑龙江省哈尔滨市",
"861708555", "安徽省合肥市",
"861386540", "安徽省芜湖市",
"861379304", "山东省菏泽市",
"861522946", "陕西省汉中市",
"861305530", "福建省莆田市",
"861314178", "内蒙古巴彦淖尔市",
"861770628", "江苏省南通市",
"861822884", "四川省广元市",
"861315405", "陕西省安康市",
"861525283", "江苏省连云港市",
"861865488", "山东省潍坊市",
"861308717", "内蒙古通辽市",
"861875093", "福建省厦门市",
"861860516", "江苏省徐州市",
"86180829", "云南省昆明市",
"861570809", "西藏昌都地区",
"86159466", "黑龙江省鹤岗市",
"861870559", "安徽省黄山市",
"861808731", "云南省红河哈尼族彝族自治州",
"861454707", "浙江省温州市",
"861776166", "河南省郑州市",
"861322181", "浙江省杭州市",
"861366919", "陕西省西安市",
"861528370", "四川省阿坝藏族羌族自治州",
"86183805", "四川省绵阳市",
"86134174", "广东省深圳市",
"861379682", "黑龙江省哈尔滨市",
"861348373", "河北省沧州市",
"861848707", "云南省昆明市",
"861773289", "河北省承德市",
"861561248", "河北省承德市",
"861811999", "安徽省合肥市",
"861314728", "湖北省十堰市",
"861855619", "江苏省南京市",
"861770636", "山东省潍坊市",
"861593247", "河北省石家庄市",
"861571537", "山东省济宁市",
"861452746", "湖南省永州市",
"861852735", "湖北省武汉市",
"861323343", "山西省阳泉市",
"861362243", "广东省清远市",
"861532305", "广东省梅州市",
"861876458", "山东省东营市",
"861874649", "黑龙江省七台河市",
"861868509", "贵州省黔南布依族苗族自治州",
"861338749", "湖南省长沙市",
"861860644", "山东省日照市",
"861855447", "山东省济南市",
"861309810", "陕西省咸阳市",
"86188772", "广西柳州市",
"861317192", "河北省保定市",
"861859952", "福建省南平市",
"86135750", "湖南省岳阳市",
"861519920", "新疆阿克苏地区",
"861329553", "安徽省芜湖市",
"861881185", "广东省清远市",
"861521542", "山东省青岛市",
"861853656", "山西省晋中市",
"861524907", "陕西省宝鸡市",
"861767101", "湖北省武汉市",
"86187751", "广西柳州市",
"861309855", "贵州省黔东南苗族侗族自治州",
"86188717", "湖北省宜昌市",
"861814445", "广东省佛山市",
"86177192", "河南省洛阳市",
"861565141", "江苏省南通市",
"861572383", "广西桂林市",
"86417", "辽宁省营口市",
"861323500", "福建省厦门市",
"861858565", "贵州省毕节地区",
"861310779", "浙江省温州市",
"861886664", "山东省潍坊市",
"861538413", "浙江省绍兴市",
"861321598", "福建省福州市",
"861836188", "江苏省连云港市",
"861558891", "山东省临沂市",
"861809866", "安徽省芜湖市",
"861700833", "浙江省杭州市",
"86151338", "河北省承德市",
"861843853", "河南省安阳市",
"86158510", "江苏省盐城市",
"861771394", "四川省乐山市",
"861514904", "内蒙古兴安盟",
"861316819", "广东省阳江市",
"861302148", "河北省沧州市",
"861568727", "云南省丽江市",
"861760674", "浙江省宁波市",
"86147886", "河南省南阳市",
"861820751", "广东省韶关市",
"861800387", "河南省周口市",
"86151635", "山东省聊城市",
"861471909", "甘肃省张掖市",
"861337521", "江苏省淮安市",
"861336902", "新疆哈密地区",
"861582544", "浙江省温州市",
"861826235", "江苏省盐城市",
"861890530", "山东省菏泽市",
"861570769", "广东省东莞市",
"86181879", "云南省普洱市",
"861330648", "山东省青岛市",
"861450239", "河北省邢台市",
"861454867", "河南省周口市",
"861478342", "河南省安阳市",
"861342241", "广东省惠州市",
"861700842", "四川省成都市",
"861773703", "河南省信阳市",
"861561067", "山东省临沂市",
"861336517", "江苏省淮安市",
"861853899", "河南省南阳市",
"861365758", "新疆阿克苏地区",
"86158935", "河南省南阳市",
"861390059", "福建省泉州市",
"861580314", "河北省承德市",
"861300448", "江苏省盐城市",
"861395593", "安徽省铜陵市",
"861818870", "广东省佛山市",
"86145038", "辽宁省沈阳市",
"861539167", "湖北省咸宁市",
"861312429", "辽宁省营口市",
"861303060", "安徽省淮北市",
"861453395", "内蒙古乌兰察布市",
"861530353", "山西省阳泉市",
"86158354", "山西省晋中市",
"861780506", "江苏省南通市",
"86152405", "江苏省南通市",
"861804342", "吉林省吉林市",
"861470589", "浙江省金华市",
"861525709", "浙江省嘉兴市",
"861558053", "湖南省湘西土家族苗族自治州",
"861537629", "山东省滨州市",
"861323332", "山西省晋城市",
"861379557", "四川省自贡市",
"861890684", "浙江省宁波市",
"861366495", "广东省阳江市",
"86138673", "浙江省嘉兴市",
"861776794", "吉林省延边朝鲜族自治州",
"861586920", "浙江省丽水市",
"861395946", "福建省龙岩市",
"861350146", "广东省清远市",
"861318678", "浙江省舟山市",
"861813578", "河南省郑州市",
"86130574", "江苏省苏州市",
"861563287", "河北省衡水市",
"861369414", "辽宁省丹东市",
"861811415", "江苏省徐州市",
"861521533", "山东省淄博市",
"861864307", "吉林省长春市",
"861383477", "山西省长治市",
"861800872", "云南省大理白族自治州",
"86151175", "贵州省毕节地区",
"86145927", "重庆市",
"861335892", "辽宁省朝阳市",
"861364773", "广西桂林市",
"861550981", "辽宁省沈阳市",
"861800023", "江西省九江市",
"861811450", "江苏省无锡市",
"861350975", "山西省长治市",
"861501835", "广东省汕头市",
"861317751", "江西省上饶市",
"861336008", "广东省深圳市",
"861351609", "辽宁省沈阳市",
"861827129", "湖北省宜昌市",
"861534985", "安徽省巢湖市",
"861890302", "广东省深圳市",
"861871619", "四川省宜宾市",
"861830840", "四川省德阳市",
"861334971", "湖北省武汉市",
"861781758", "广东省肇庆市",
"861530692", "福建省厦门市",
"861370030", "河北省邯郸市",
"861823246", "河北省廊坊市",
"861365347", "山西省晋城市",
"861335573", "浙江省嘉兴市",
"861895448", "山东省聊城市",
"861800593", "福建省宁德市",
"861375154", "广东省佛山市",
"86147870", "云南省昭通市",
"861477082", "江西省赣州市",
"861520561", "安徽省淮北市",
"861534600", "河南省漯河市",
"861322538", "山东省泰安市",
"861300279", "山东省临沂市",
"861700976", "浙江省嘉兴市",
"861881377", "广东省梅州市",
"86182388", "河南省洛阳市",
"86138239", "广东省中山市",
"861871447", "黑龙江省双鸭山市",
"861321922", "四川省遂宁市",
"861520475", "内蒙古通辽市",
"861320481", "内蒙古通辽市",
"861367419", "辽宁省辽阳市",
"861316380", "福建省南平市",
"861319540", "安徽省亳州市",
"861308044", "河北省邯郸市",
"861313315", "山西省长治市",
"861892262", "广东省肇庆市",
"861707398", "河南省三门峡市",
"86182685", "浙江省宁波市",
"86152650", "山东省菏泽市",
"861575287", "云南省昆明市",
"861700145", "江苏省扬州市",
"861875851", "浙江省绍兴市",
"861809706", "青海省海东地区",
"861775964", "福建省泉州市",
"861322096", "山东省聊城市",
"86180470", "内蒙古呼伦贝尔市",
"861825097", "福建省南平市",
"861580952", "宁夏石嘴山市",
"861309791", "广西北海市",
"861572597", "山东省临沂市",
"861591011", "山东省潍坊市",
"861471570", "广东省广州市",
"861779013", "四川省德阳市",
"861887111", "湖北省鄂州市",
"861335195", "黑龙江省鹤岗市",
"861335484", "内蒙古赤峰市",
"861328768", "山东省潍坊市",
"861813951", "新疆伊犁哈萨克自治州",
"861768940", "福建省福州市",
"861305302", "安徽省六安市",
"861376788", "江西省萍乡市",
"861394991", "河南省商丘市",
"861590672", "浙江省湖州市",
"861567743", "广西梧州市",
"861800946", "甘肃省兰州市",
"861778179", "四川省雅安市",
"861882434", "广东省东莞市",
"861509424", "云南省保山市",
"861838907", "西藏昌都地区",
"861337853", "贵州省安顺市",
"861800725", "湖北省黄冈市",
"861537941", "甘肃省甘南藏族自治州",
"861334558", "安徽省阜阳市",
"861535329", "陕西省延安市",
"861368371", "河南省郑州市",
"861323979", "新疆伊犁哈萨克自治州",
"861562180", "山东省德州市",
"861500884", "云南省文山壮族苗族自治州",
"861889212", "陕西省榆林市",
"861453686", "陕西省渭南市",
"86130923", "江苏省徐州市",
"861788519", "贵州省安顺市",
"861520886", "云南省怒江傈僳族自治州",
"861304698", "福建省泉州市",
"861771407", "江苏省苏州市",
"861597448", "湖南省常德市",
"861346825", "山东省莱芜市",
"861590384", "河南省商丘市",
"861327695", "福建省宁德市",
"861319373", "河南省驻马店市",
"861324234", "广东省广州市",
"861778109", "四川省凉山彝族自治州",
"861822687", "安徽省阜阳市",
"861776838", "江苏省常州市",
"861359938", "福建省福州市",
"861529426", "甘肃省定西市",
"86152024", "陕西省西安市",
"861820944", "甘肃省庆阳市",
"86152442", "山东省青岛市",
"861323909", "新疆博尔塔拉蒙古自治州",
"861335340", "山西省忻州市",
"8615910", "北京市",
"861529367", "甘肃省平凉市",
"861890939", "甘肃省陇南市",
"861345034", "广东省韶关市",
"86155151", "河南省安阳市",
"861372295", "河北省保定市",
"861709746", "广东省东莞市",
"861830392", "河南省鹤壁市",
"861390429", "辽宁省葫芦岛市",
"861571319", "河北省邢台市",
"861331739", "湖南省邵阳市",
"861877501", "广西梧州市",
"861310869", "云南省昆明市",
"861596042", "福建省泉州市",
"861585111", "江苏省盐城市",
"861504470", "内蒙古包头市",
"861302094", "浙江省温州市",
"861333132", "河北省张家口市",
"861868900", "西藏拉萨市",
"86136002", "广东省东莞市",
"861829704", "青海省海南藏族自治州",
"86180477", "内蒙古鄂尔多斯市",
"861515669", "安徽省合肥市",
"86188965", "江苏省苏州市",
"861810947", "甘肃省酒泉市",
"861328046", "山东省聊城市",
"861811020", "安徽省蚌埠市",
"861705228", "广东省深圳市",
"861800453", "黑龙江省牡丹江市",
"861809776", "新疆乌鲁木齐市",
"861551786", "河南省平顶山市",
"861534442", "湖南省衡阳市",
"86152657", "山东省济宁市",
"861812302", "四川省成都市",
"861534670", "甘肃省临夏回族自治州",
"861773075", "陕西省汉中市",
"861880614", "江苏省常州市",
"861377038", "江苏省淮安市",
"861332254", "西藏林芝地区",
"861452247", "浙江省丽水市",
"861350680", "浙江省舟山市",
"861575465", "黑龙江省黑河市",
"86150394", "河南省周口市",
"861804890", "四川省绵阳市",
"86180412", "辽宁省鞍山市",
"86137847", "河北省沧州市",
"861395105", "江苏省扬州市",
"861364703", "江西省上饶市",
"861346772", "湖南省株洲市",
"86145920", "四川省成都市",
"861383407", "山西省临汾市",
"861500552", "安徽省蚌埠市",
"861305939", "广东省肇庆市",
"861581218", "云南省大理白族自治州",
"861479797", "江西省赣州市",
"861834543", "黑龙江省大庆市",
"861454206", "河南省新乡市",
"861839569", "河北省保定市",
"861334901", "安徽省合肥市",
"861870915", "陕西省安康市",
"861890372", "河南省安阳市",
"861366555", "安徽省马鞍山市",
"861350905", "广东省韶关市",
"861336078", "广东省揭阳市",
"86134256", "广东省佛山市",
"861351679", "浙江省金华市",
"861823014", "河北省承德市",
"861472653", "四川省内江市",
"861458627", "湖北省咸宁市",
"861809138", "陕西省西安市",
"861898997", "西藏阿里地区",
"861760877", "云南省玉溪市",
"861880546", "山东省东营市",
"861340812", "四川省攀枝花市",
"861513858", "河南省商丘市",
"861847143", "湖北省孝感市",
"861308216", "河北省沧州市",
"861708919", "陕西省榆林市",
"861870950", "宁夏银川市",
"861597279", "湖北省黄冈市",
"861835629", "安徽省铜陵市",
"861302524", "广东省汕头市",
"861869233", "湖南省湘潭市",
"861529438", "甘肃省天水市",
"861880993", "新疆石河子市",
"861894842", "广东省江门市",
"861818800", "贵州省贵阳市",
"861518550", "贵州省黔南布依族苗族自治州",
"861776826", "江苏省徐州市",
"861473028", "河北省承德市",
"861353622", "广东省江门市",
"861360969", "广东省东莞市",
"86135492", "广东省东莞市",
"861554730", "内蒙古包头市",
"861568238", "四川省资阳市",
"861536250", "广东省江门市",
"861860847", "湖南省益阳市",
"861780576", "浙江省台州市",
"861327386", "河南省许昌市",
"861348291", "河北省沧州市",
"861834996", "四川省自贡市",
"861342999", "湖北省武汉市",
"861370351", "山西省太原市",
"861897181", "湖北省咸宁市",
"86183999", "新疆昌吉回族自治州",
"861337640", "山东省济南市",
"861760159", "江苏省苏州市",
"861773773", "河南省洛阳市",
"861533280", "内蒙古呼伦贝尔市",
"861865045", "福建省福州市",
"86138708", "江西省南昌市",
"86147187", "海南省海口市",
"861529156", "陕西省商洛市",
"861593903", "河南省郑州市",
"861558153", "湖南省邵阳市",
"861309465", "浙江省金华市",
"861820092", "广东省云浮市",
"861362907", "四川省巴中市",
"86187723", "湖北省黄石市",
"861598641", "广东省广州市",
"861539067", "甘肃省张掖市",
"861317998", "新疆喀什地区",
"861390266", "广东省惠州市",
"861477885", "广东省汕头市",
"861325040", "广东省湛江市",
"861394347", "吉林省四平市",
"861390159", "江苏省南京市",
"861373408", "山西省临汾市",
"861840930", "甘肃省临夏回族自治州",
"861858944", "西藏林芝地区",
"861572777", "江西省赣州市",
"861309571", "浙江省杭州市",
"861853418", "山西省晋中市",
"861471790", "山西省晋城市",
"861851575", "四川省德阳市",
"861828888", "云南省丽江市",
"861520423", "辽宁省朝阳市",
"86182263", "安徽省阜阳市",
"861529269", "新疆和田地区",
"861340420", "江苏省南通市",
"86159632", "山东省青岛市",
"861310376", "河南省信阳市",
"861360342", "河南省驻马店市",
"861550532", "山东省青岛市",
"861475104", "江苏省常州市",
"861332970", "湖北省武汉市",
"861589442", "云南省德宏傣族景颇族自治州",
"861560398", "河南省三门峡市",
"86137875", "湖南省怀化市",
"861839656", "福建省南平市",
"861452836", "四川省甘孜藏族自治州",
"861381453", "江苏省南京市",
"86183465", "黑龙江省哈尔滨市",
"861833952", "河南省新乡市",
"861840317", "河北省沧州市",
"861504715", "内蒙古通辽市",
"861338839", "四川省宜宾市",
"861331414", "辽宁省本溪市",
"86159806", "福建省福州市",
"86189629", "江苏省南通市",
"861800773", "广西桂林市",
"861837227", "湖北省襄樊市",
"861338346", "山西省晋城市",
"861843463", "山西省晋城市",
"861881209", "河北省邢台市",
"861350046", "辽宁省锦州市",
"861335793", "江苏省徐州市",
"861364872", "云南省大理白族自治州",
"861300307", "安徽省淮南市",
"861526800", "浙江省舟山市",
"861390877", "云南省玉溪市",
"861890255", "广东省江门市",
"861340331", "河北省石家庄市",
"861319286", "广东省韶关市",
"861571678", "河南省驻马店市",
"861301614", "湖南省益阳市",
"861452349", "河南省漯河市",
"861557039", "江西省景德镇市",
"861515556", "安徽省安庆市",
"861588548", "贵州省六盘水市",
"861479507", "宁夏银川市",
"861479281", "安徽省阜阳市",
"861308144", "山东省潍坊市",
"861889543", "安徽省阜阳市",
"861373991", "内蒙古呼和浩特市",
"861452828", "四川省眉山市",
"861887288", "湖北省鄂州市",
"861317401", "江苏省淮安市",
"861309958", "宁夏银川市",
"861328905", "新疆昌吉回族自治州",
"861326378", "广西南宁市",
"861807557", "湖南省怀化市",
"861477182", "湖北省咸宁市",
"861507807", "广西河池市",
"86151140", "四川省成都市",
"86134183", "广东省东莞市",
"861302267", "浙江省丽水市",
"861780824", "四川省遂宁市",
"861301546", "山西省长治市",
"861459531", "西藏拉萨市",
"861527264", "湖北省荆州市",
"861392306", "广东省江门市",
"86182796", "江西省吉安市",
"861815485", "新疆阿克苏地区",
"861365408", "辽宁省大连市",
"861815194", "江苏省南通市",
"861876544", "山东省德州市",
"861593168", "河北省石家庄市",
"861817496", "广西百色市",
"861301993", "辽宁省朝阳市",
"861871308", "河北省沧州市",
"861330897", "西藏阿里地区",
"861708871", "广东省江门市",
"861380741", "湖南省株洲市",
"861351318", "河北省衡水市",
"861889300", "甘肃省白银市",
"861302876", "甘肃省定西市",
"861778079", "四川省宜宾市",
"861395123", "江苏省常州市",
"861364725", "湖北省荆州市",
"861873906", "河南省洛阳市",
"861314972", "辽宁省鞍山市",
"861348787", "湖南省郴州市",
"861567842", "广西玉林市",
"861774424", "四川省成都市",
"86136994", "四川省成都市",
"86155262", "湖南省郴州市",
"861337752", "广东省惠州市",
"861850433", "吉林省延边朝鲜族自治州",
"861479018", "安徽省宣城市",
"86181857", "贵州省毕节地区",
"861760429", "辽宁省葫芦岛市",
"861364946", "广西玉林市",
"861353916", "广东省梅州市",
"861779113", "陕西省榆林市",
"86183627", "江苏省苏州市",
"861350923", "广东省东莞市",
"861536974", "河北省秦皇岛市",
"861887011", "江西省赣州市",
"861820522", "江苏省徐州市",
"861819027", "四川省资阳市",
"861800075", "江西省宜春市",
"861527197", "湖北省襄樊市",
"861858192", "四川省自贡市",
"86181850", "贵州省贵阳市",
"861860698", "福建省泉州市",
"861311547", "黑龙江省鸡西市",
"861539356", "甘肃省金昌市",
"86131360", "海南省海口市",
"861507159", "湖北省十堰市",
"861347436", "陕西省西安市",
"861873976", "河南省周口市",
"861398940", "浙江省金华市",
"861815267", "湖南省常德市",
"861314902", "广东省清远市",
"861345817", "四川省达州市",
"861334819", "江苏省常州市",
"861318319", "河南省漯河市",
"861345134", "内蒙古呼和浩特市",
"861454383", "贵州省安顺市",
"861824070", "河南省周口市",
"86147636", "山东省济南市",
"861585288", "江苏省扬州市",
"861395703", "浙江省衢州市",
"861470301", "河北省邯郸市",
"861533546", "山东省东营市",
"861365478", "内蒙古巴彦淖尔市",
"861845831", "浙江省杭州市",
"861889370", "甘肃省兰州市",
"861302806", "山西省长治市",
"861340015", "河北省邢台市",
"861708801", "四川省成都市",
"861780796", "江西省吉安市",
"861879440", "甘肃省白银市",
"861525599", "安徽省黄山市",
"861845270", "江苏省南通市",
"86152596", "福建省漳州市",
"861582036", "广东省阳江市",
"861522863", "四川省自贡市",
"861597307", "湖南省益阳市",
"86180402", "辽宁省沈阳市",
"861326308", "江西省抚州市",
"861576961", "宁夏银川市",
"861809026", "四川省广元市",
"861533993", "山东省聊城市",
"86135925", "河南省郑州市",
"861771348", "四川省内江市",
"861317471", "浙江省嘉兴市",
"861450955", "江苏省宿迁市",
"861364453", "黑龙江省牡丹江市",
"861342860", "广东省东莞市",
"861332685", "广东省东莞市",
"861532671", "内蒙古呼和浩特市",
"86151147", "内蒙古通辽市",
"861336736", "湖南省常德市",
"861807497", "广西梧州市",
"86156323", "河北省石家庄市",
"861811120", "四川省泸州市",
"861589985", "广东省深圳市",
"861812255", "广东省茂名市",
"861815876", "浙江省嘉兴市",
"861346592", "山东省济南市",
"861328146", "四川省成都市",
"861343738", "广东省东莞市",
"86136012", "北京市",
"86147802", "四川省巴中市",
"861354169", "四川省自贡市",
"861773725", "河南省安阳市",
"86136681", "四川省成都市",
"861360890", "山东省临沂市",
"861773946", "河南省周口市",
"861373249", "浙江省绍兴市",
"861475724", "浙江省金华市",
"861861324", "四川省巴中市",
"861346873", "陕西省商洛市",
"861458781", "湖南省永州市",
"86147859", "贵州省黔东南苗族侗族自治州",
"861508033", "福建省厦门市",
"861332396", "河南省驻马店市",
"861873842", "河南省洛阳市",
"86157523", "云南省西双版纳傣族自治州",
"861800703", "江西省上饶市",
"861772658", "四川省乐山市",
"861595607", "安徽省合肥市",
"86156895", "山东省德州市",
"861868254", "四川省遂宁市",
"861365249", "广东省东莞市",
"861458399", "福建省南平市",
"861571608", "福建省南平市",
"861520755", "广东省深圳市",
"861526870", "浙江省湖州市",
"861323811", "辽宁省阜新市",
"861375424", "浙江省湖州市",
"861858895", "广东省深圳市",
"861336178", "江西省景德镇市",
"861810391", "河南省焦作市",
"861332900", "安徽省滁州市",
"861308992", "黑龙江省大兴安岭地区",
"861897218", "湖北省武汉市",
"861569060", "河南省安阳市",
"861809596", "新疆乌鲁木齐市",
"861558561", "吉林省松原市",
"86152679", "浙江省金华市",
"86180459", "黑龙江省大庆市",
"861343726", "湖北省武汉市",
"861519199", "陕西省榆林市",
"861810789", "广西北海市",
"86155558", "安徽省阜阳市",
"861383348", "河北省保定市",
"861309287", "四川省内江市",
"86150011", "北京市",
"861894743", "内蒙古阿拉善盟",
"861865145", "江苏省苏州市",
"861309501", "新疆乌鲁木齐市",
"861831233", "广东省茂名市",
"86150682", "浙江省温州市",
"861373478", "内蒙古赤峰市",
"861508948", "广东省梅州市",
"861774054", "湖北省武汉市",
"861581181", "广东省深圳市",
"861347428", "陕西省渭南市",
"861310306", "河北省廊坊市",
"861809943", "新疆和田地区",
"861899769", "新疆克孜勒苏柯尔克孜自治州",
"861349537", "广西梧州市",
"861535227", "甘肃省甘南藏族自治州",
"861865976", "福建省龙岩市",
"861371550", "广东省佛山市",
"861533614", "陕西省渭南市",
"861773023", "安徽省合肥市",
"861350768", "河南省周口市",
"861815942", "福建省莆田市",
"861381946", "浙江省杭州市",
"861509154", "陕西省西安市",
"861592691", "湖北省黄石市",
"861309422", "湖北省荆州市",
"86185399", "河南省郑州市",
"861854692", "黑龙江省黑河市",
"861897196", "湖北省孝感市",
"861511927", "广东省湛江市",
"861513468", "黑龙江省黑河市",
"861316558", "河北省石家庄市",
"861776935", "湖南省郴州市",
"861335562", "安徽省铜陵市",
"861894732", "内蒙古赤峰市",
"861867041", "湖南省株洲市",
"861846438", "山东省滨州市",
"861831242", "广东省广州市",
"86150241", "广东省东莞市",
"86158507", "江苏省南京市",
"861809932", "新疆塔城地区",
"861860737", "湖南省益阳市",
"861338258", "江苏省泰州市",
"86138991", "新疆喀什地区",
"861331328", "河北省承德市",
"861803636", "江苏省徐州市",
"861384916", "河南省开封市",
"861346928", "湖南省邵阳市",
"861700488", "广东省广州市",
"861539409", "甘肃省武威市",
"861339622", "山东省聊城市",
"86152139", "甘肃省定西市",
"861581538", "广东省惠州市",
"861863505", "山西省晋中市",
"861329061", "河北省石家庄市",
"861333926", "安徽省安庆市",
"861313588", "湖北省襄樊市",
"861705516", "上海市",
"861519683", "四川省资阳市",
"861453221", "浙江省宁波市",
"861315423", "辽宁省抚顺市",
"861327391", "河南省焦作市",
"861390674", "浙江省宁波市",
"861330913", "陕西省渭南市",
"861301817", "四川省宜宾市",
"861308098", "陕西省榆林市",
"861452168", "河北省秦皇岛市",
"861508042", "福建省泉州市",
"86182835", "四川省雅安市",
"86139296", "广东省汕头市",
"861566406", "河南省安阳市",
"86182122", "贵州省黔东南苗族侗族自治州",
"861302766", "河南省新乡市",
"861550370", "河南省商丘市",
"861884960", "云南省西双版纳傣族自治州",
"861318880", "山东省济宁市",
"861538070", "江苏省泰州市",
"861334380", "河南省新乡市",
"86187336", "河北省廊坊市",
"861815048", "福建省泉州市",
"86139533", "山东省淄博市",
"86188700", "江西省南昌市",
"86159110", "北京市",
"861827990", "江西省吉安市",
"861476976", "山东省菏泽市",
"861832293", "江西省宜春市",
"861458576", "山东省菏泽市",
"861856040", "山东省淄博市",
"86155123", "河北省张家口市",
"861316971", "广东省佛山市",
"86147176", "山东省临沂市",
"861350808", "四川省南充市",
"861322607", "广东省中山市",
"86186536", "山东省潍坊市",
"861868799", "云南省丽江市",
"861330694", "福建省漳州市",
"861500721", "湖北省荆州市",
"861332579", "浙江省金华市",
"861351424", "辽宁省大连市",
"861320556", "安徽省安庆市",
"861587150", "湖北省鄂州市",
"861319787", "江西省宜春市",
"861857217", "湖北省武汉市",
"861572867", "广东省深圳市",
"86135779", "云南省普洱市",
"861324514", "内蒙古兴安盟",
"86186293", "陕西省西安市",
"861865833", "浙江省台州市",
"861303820", "四川省南充市",
"861300185", "河北省邢台市",
"861569412", "辽宁省鞍山市",
"861870666", "山东省东营市",
"861300494", "福建省南平市",
"861333043", "云南省昆明市",
"861522005", "广东省深圳市",
"861591631", "广东省珠海市",
"861323790", "江西省新余市",
"861308528", "湖北省襄樊市",
"861380312", "河北省保定市",
"861346936", "湖南省永州市",
"861331336", "河北省廊坊市",
"861803628", "江苏省盐城市",
"861321708", "江西省新余市",
"861329784", "广西梧州市",
"861370655", "浙江省台州市",
"861858751", "广西柳州市",
"861588124", "四川省雅安市",
"861709349", "广东省中山市",
"861820471", "内蒙古呼和浩特市",
"861846426", "山东省滨州市",
"861814531", "黑龙江省牡丹江市",
"861776748", "新疆哈密地区",
"861570057", "四川省广元市",
"861532323", "广东省汕尾市",
"861800863", "湖北省武汉市",
"861831967", "广东省广州市",
"861310459", "黑龙江省大庆市",
"861476842", "山东省泰安市",
"861331849", "广东省珠海市",
"861333938", "黑龙江省伊春市",
"861820565", "安徽省合肥市",
"86137669", "黑龙江省哈尔滨市",
"861840539", "山东省临沂市",
"861588774", "云南省红河哈尼族彝族自治州",
"861370610", "江苏省镇江市",
"861554653", "黑龙江省哈尔滨市",
"861339292", "广东省中山市",
"861899157", "陕西省宝鸡市",
"861393431", "山西省晋城市",
"861452973", "广东省清远市",
"861361916", "陕西省汉中市",
"86132380", "辽宁省大连市",
"86182646", "山东省潍坊市",
"86152865", "贵州省毕节地区",
"86156736", "湖南省常德市",
"861771169", "湖南省邵阳市",
"86187848", "四川省达州市",
"861321128", "广东省江门市",
"861893921", "河南省南阳市",
"861886027", "河南省驻马店市",
"861885150", "江苏省无锡市",
"861890363", "黑龙江省牡丹江市",
"861457012", "山东省临沂市",
"861315053", "云南省曲靖市",
"861804560", "黑龙江省黑河市",
"861850670", "浙江省衢州市",
"861850442", "吉林省吉林市",
"861553624", "山西省晋中市",
"861310599", "福建省南平市",
"861531820", "山东省滨州市",
"861309786", "广西百色市",
"861312674", "内蒙古兴安盟",
"861478560", "贵州省贵阳市",
"861363318", "河北省衡水市",
"861394986", "河南省漯河市",
"861816300", "湖北省黄冈市",
"86139998", "新疆乌鲁木齐市",
"861771256", "江苏省泰州市",
"861893417", "广东省汕头市",
"861321778", "广西河池市",
"86189083", "重庆市",
"861537474", "内蒙古乌兰察布市",
"861577505", "广东省茂名市",
"861805382", "山东省泰安市",
"861320496", "湖南省永州市",
"861899879", "广东省湛江市",
"861522075", "广东省江门市",
"861322081", "山东省济宁市",
"861503336", "河北省沧州市",
"861350878", "云南省楚雄彝族自治州",
"861322677", "广东省肇庆市",
"861385219", "江苏省扬州市",
"861501938", "广东省河源市",
"861479912", "新疆喀什地区",
"86150616", "江苏省盐城市",
"861317522", "浙江省湖州市",
"86182169", "贵州省六盘水市",
"861458506", "河南省南阳市",
"861599499", "广东省潮州市",
"861773762", "河南省安阳市",
"861555678", "安徽省阜阳市",
"861477359", "湖南省岳阳市",
"861332509", "山东省临沂市",
"861862749", "湖南省永州市",
"861539248", "福建省福州市",
"861532252", "广东省湛江市",
"861319362", "河南省周口市",
"861820998", "新疆喀什地区",
"861311816", "四川省绵阳市",
"86188707", "江西省赣州市",
"86130583", "广东省湛江市",
"861302933", "辽宁省锦州市",
"861304644", "山东省威海市",
"86136205", "广东省清远市",
"861345546", "山东省东营市",
"861347314", "河北省承德市",
"861597494", "云南省西双版纳傣族自治州",
"861397171", "湖北省黄冈市",
"861786989", "云南省西双版纳傣族自治州",
"861550996", "新疆巴音郭楞蒙古自治州",
"861317092", "江西省九江市",
"861533817", "广东省珠海市",
"86159172", "广东省中山市",
"861897874", "广西玉林市",
"861533134", "四川省成都市",
"861450519", "吉林省通化市",
"86170881", "四川省成都市",
"861354757", "四川省南充市",
"861813637", "江苏省徐州市",
"861334444", "北京市",
"861454457", "江西省赣州市",
"861783959", "河南省平顶山市",
"861830730", "湖南省岳阳市",
"861787661", "广东省云浮市",
"861763545", "山西省吕梁市",
"861501745", "广东省珠海市",
"86873", "云南省红河哈尼族彝族自治州",
"861475659", "河北省秦皇岛市",
"86156566", "安徽省池州市",
"861570427", "辽宁省盘锦市",
"861539479", "内蒙古锡林郭勒盟",
"861595804", "浙江省杭州市",
"861354829", "四川省达州市",
"861316498", "浙江省宁波市",
"861302048", "内蒙古巴彦淖尔市",
"861780297", "陕西省宝鸡市",
"861310029", "湖南省常德市",
"861325221", "浙江省湖州市",
"861769937", "新疆伊犁哈萨克自治州",
"861893649", "江苏省扬州市",
"861570911", "陕西省延安市",
"861362512", "江苏省徐州市",
"861823634", "河南省周口市",
"86158500", "江苏省苏州市",
"861836088", "江苏省苏州市",
"861328534", "山东省德州市",
"861803298", "河北省唐山市",
"861886597", "山东省东营市",
"861392459", "广东省深圳市",
"861360333", "河北省沧州市",
"861550543", "山东省滨州市",
"861894488", "江苏省宿迁市",
"861801200", "江苏省徐州市",
"861364387", "河南省洛阳市",
"86134289", "广东省深圳市",
"861575060", "内蒙古乌兰察布市",
"861800013", "江苏省宿迁市",
"861350567", "安徽省阜阳市",
"861569791", "江西省南昌市",
"861389757", "青海省海西蒙古族藏族自治州",
"861836140", "江苏省南通市",
"861840699", "云南省德宏傣族景颇族自治州",
"86137653", "贵州省安顺市",
"861396681", "安徽省阜阳市",
"861767342", "湖南省永州市",
"861325531", "山东省济南市",
"861773470", "河南省商丘市",
"861566549", "安徽省宿州市",
"861356339", "山东省东营市",
"861892441", "广东省清远市",
"861340003", "江苏省无锡市",
"861356846", "四川省巴中市",
"861779946", "新疆阿克苏地区",
"861572508", "山东省滨州市",
"861550487", "内蒙古鄂尔多斯市",
"861339032", "辽宁省鞍山市",
"861811425", "江苏省泰州市",
"861374889", "河南省郑州市",
"861353143", "广东省佛山市",
"861302180", "河北省石家庄市",
"861322516", "江苏省徐州市",
"861308385", "河南省安阳市",
"861520000", "河北省石家庄市",
"86135628", "山东省泰安市",
"861473577", "山西省临汾市",
"861869934", "新疆石河子市",
"861311935", "甘肃省武威市",
"861580569", "安徽省合肥市",
"861559759", "青海省海西蒙古族藏族自治州",
"86132278", "陕西省西安市",
"861847622", "广东省河源市",
"86180813", "四川省乐山市",
"861779593", "陕西省西安市",
"861526640", "山东省菏泽市",
"861537619", "山东省济南市",
"861826892", "浙江省丽水市",
"861560279", "广东省潮州市",
"861879976", "新疆石河子市",
"861580324", "河北省承德市",
"861533356", "山西省晋城市",
"861783503", "山西省忻州市",
"861372650", "广东省汕头市",
"86139759", "湖南省邵阳市",
"861327215", "湖南省益阳市",
"861312419", "辽宁省辽阳市",
"861330534", "山东省德州市",
"861336527", "江苏省连云港市",
"861507419", "湖南省郴州市",
"861380489", "黑龙江省鸡西市",
"861458208", "安徽省黄山市",
"861870068", "陕西省铜川市",
"861363739", "湖南省邵阳市",
"86157374", "河南省许昌市",
"861770706", "江西省吉安市",
"861879145", "陕西省安康市",
"861372615", "广东省江门市",
"861311357", "内蒙古赤峰市",
"861822560", "安徽省合肥市",
"861536386", "广东省惠州市",
"861389829", "辽宁省葫芦岛市",
"861535319", "陕西省榆林市",
"86153065", "浙江省杭州市",
"861893769", "河南省信阳市",
"861768756", "广西柳州市",
"861813457", "安徽省淮北市",
"861319131", "内蒙古呼伦贝尔市",
"861479778", "广西河池市",
"861507647", "河北省沧州市",
"861788529", "贵州省黔东南苗族侗族自治州",
"861532841", "四川省南充市",
"86133585", "福建省泉州市",
"861332953", "黑龙江省牡丹江市",
"861705607", "广东省东莞市",
"861379478", "广东省阳江市",
"861454637", "宁夏固原市",
"861360492", "辽宁省沈阳市",
"861303501", "安徽省蚌埠市",
"861381470", "江苏省南通市",
"86156574", "浙江省宁波市",
"861336097", "广东省深圳市",
"86139702", "江西省九江市",
"861561280", "河北省衡水市",
"861537447", "甘肃省甘南藏族自治州",
"861896305", "山东省菏泽市",
"861310984", "辽宁省大连市",
"861800750", "广东省江门市",
"861771971", "陕西省汉中市",
"861819117", "陕西省汉中市",
"861838401", "四川省泸州市",
"861779023", "四川省乐山市",
"861806875", "江苏省常州市",
"861557754", "广西贵港市",
"861539614", "福建省厦门市",
"861340705", "江西省宜春市",
"861573684", "河南省许昌市",
"861871941", "广东省广州市",
"861874282", "新疆喀什地区",
"861524092", "云南省临沧市",
"861352381", "河南省商丘市",
"861399964", "新疆喀什地区",
"861301067", "广东省佛山市",
"861558170", "山西省忻州市",
"861879842", "贵州省黔南布依族苗族自治州",
"861567602", "广西防城港市",
"861367429", "辽宁省葫芦岛市",
"861313325", "山西省长治市",
"861452499", "内蒙古赤峰市",
"861564228", "辽宁省朝阳市",
"861311748", "湖南省娄底市",
"861308696", "贵州省六盘水市",
"861826195", "江苏省镇江市",
"861324933", "河北省石家庄市",
"861854532", "黑龙江省鹤岗市",
"861780037", "河北省沧州市",
"86135893", "山东省青岛市",
"861818752", "云南省昆明市",
"861320987", "山西省晋城市",
"861531501", "山东省青岛市",
"861831851", "广东省广州市",
"861531287", "江苏省盐城市",
"861348588", "安徽省安庆市",
"861500969", "宁夏中卫市",
"861810441", "吉林省长春市",
"86180411", "辽宁省大连市",
"861590743", "湖南省湘西土家族苗族自治州",
"861302646", "陕西省渭南市",
"861452559", "山东省青岛市",
"861839952", "新疆和田地区",
"861338556", "贵州省铜仁地区",
"861886637", "山东省枣庄市",
"861328694", "广东省中山市",
"861332446", "吉林省长春市",
"861705218", "江苏省无锡市",
"861313286", "广西百色市",
"861324766", "广东省广州市",
"861470948", "甘肃省兰州市",
"861558100", "湖南省长沙市",
"86147811", "四川省乐山市",
"86136001", "广东省深圳市",
"86170806", "广东省深圳市",
"861504703", "内蒙古呼伦贝尔市",
"861775263", "湖南省湘西土家族苗族自治州",
"861896375", "安徽省芜湖市",
"861571329", "河北省邢台市",
"861390419", "辽宁省辽阳市",
"861565939", "福建省莆田市",
"861572951", "宁夏银川市",
"861360552", "安徽省蚌埠市",
"861357521", "湖南省常德市",
"861775889", "黑龙江省伊春市",
"861705081", "广东省深圳市",
"861898908", "西藏拉萨市",
"861309160", "黑龙江省伊春市",
"861533067", "吉林省四平市",
"861394557", "黑龙江省七台河市",
"861571564", "安徽省六安市",
"861340775", "广西河池市",
"861318697", "浙江省杭州市",
"86137594", "云南省昆明市",
"86155152", "河南省开封市",
"861599903", "新疆和田地区",
"861771901", "河南省商丘市",
"861383498", "山西省朔州市",
"861311066", "福建省漳州市",
"861479708", "青海省西宁市",
"861471784", "山西省阳泉市",
"861568216", "四川省南充市",
"86150059", "福建省福州市",
"861887701", "广西防城港市",
"861303571", "广东省河源市",
"861705677", "云南省昆明市",
"861808671", "江苏省苏州市",
"861340125", "江苏省盐城市",
"861364470", "内蒙古呼伦贝尔市",
"861556441", "山东省德州市",
"86139745", "湖南省怀化市",
"861591451", "广东省广州市",
"861898163", "四川省雅安市",
"861320258", "广东省揭阳市",
"861782049", "广东省中山市",
"861770776", "广西百色市",
"86182153", "甘肃省平凉市",
"861813027", "安徽省宣城市",
"861390647", "山东省东营市",
"86155109", "天津市",
"861571848", "广东省深圳市",
"861573939", "新疆巴音郭楞蒙古自治州",
"861359361", "湖北省恩施土家族苗族自治州",
"861705764", "湖南省长沙市",
"861707377", "河南省南阳市",
"86187490", "河南省南阳市",
"861328913", "陕西省渭南市",
"861473018", "河北省衡水市",
"861396518", "安徽省芜湖市",
"861776816", "江苏省宿迁市",
"86135491", "广东省梅州市",
"861364642", "山东省青岛市",
"861879906", "新疆哈密地区",
"86131967", "江苏省常州市",
"861308226", "辽宁省鞍山市",
"861708929", "广东省湛江市",
"861572578", "山东省临沂市",
"861388643", "湖北省黄冈市",
"861564698", "新疆吐鲁番地区",
"861345409", "浙江省舟山市",
"861824053", "河南省信阳市",
"86184514", "江苏省宿迁市",
"861301356", "山东省东营市",
"861383901", "河南省许昌市",
"861310639", "浙江省丽水市",
"861306988", "黑龙江省哈尔滨市",
"861520070", "湖南省衡阳市",
"861527008", "江西省上饶市",
"861340822", "四川省资阳市",
"861786454", "山东省临沂市",
"861889353", "甘肃省武威市",
"861841995", "甘肃省天水市",
"861596605", "山东省济南市",
"861470735", "湖南省郴州市",
"861805419", "甘肃省兰州市",
"861882079", "广东省广州市",
"861870746", "湖南省永州市",
"861779105", "陕西省渭南市",
"861550265", "辽宁省锦州市",
"861304607", "山东省淄博市",
"861823024", "河北省唐山市",
"861845253", "江苏省宿迁市",
"861832948", "陕西省西安市",
"861760734", "湖南省衡阳市",
"861367059", "广东省揭阳市",
"861839314", "甘肃省陇南市",
"861370435", "吉林省通化市",
"861581228", "云南省文山壮族苗族自治州",
"861476251", "江苏省淮安市",
"861303958", "内蒙古包头市",
"861773400", "河北省邯郸市",
"86150433", "吉林省延边朝鲜族自治州",
"861883532", "山西省阳泉市",
"861312568", "辽宁省辽阳市",
"861388632", "湖北省鄂州市",
"861537139", "江苏省宿迁市",
"861803309", "广东省深圳市",
"861867530", "广东省梅州市",
"861580418", "辽宁省阜新市",
"861510531", "山东省济南市",
"861300344", "江苏省镇江市",
"861324485", "广东省深圳市",
"861315000", "甘肃省张掖市",
"861813383", "河北省石家庄市",
"86182202", "陕西省榆林市",
"86184350", "山西省忻州市",
"861824891", "江苏省淮安市",
"86134860", "浙江省宁波市",
"861811462", "江苏省苏州市",
"861855299", "江苏省南通市",
"86183841", "四川省成都市",
"861874057", "陕西省宝鸡市",
"861337688", "浙江省宁波市",
"861593499", "内蒙古通辽市",
"861871754", "陕西省西安市",
"861475147", "江苏省无锡市",
"861509849", "山东省烟台市",
"861354558", "湖北省咸宁市",
"861555329", "山东省聊城市",
"861557941", "江西省上饶市",
"861459691", "新疆吐鲁番地区",
"861318738", "湖南省邵阳市",
"86156309", "河北省邢台市",
"861847665", "广东省深圳市",
"86139695", "山东省聊城市",
"861361612", "江苏省常州市",
"86138667", "安徽省合肥市",
"8613441", "上海市",
"861314197", "湖南省邵阳市",
"86132980", "内蒙古通辽市",
"86157552", "安徽省蚌埠市",
"861390995", "新疆吐鲁番地区",
"861832042", "广东省湛江市",
"861478721", "云南省大理白族自治州",
"861899417", "江苏省南通市",
"86139398", "河南省三门峡市",
"86158571", "浙江省杭州市",
"861831795", "江西省宜春市",
"861364633", "山东省日照市",
"861709499", "浙江省温州市",
"861303052", "江西省吉安市",
"861355195", "四川省广安市",
"861360687", "浙江省温州市",
"861877412", "湖南省岳阳市",
"861550353", "山西省阳泉市",
"86152144", "黑龙江省齐齐哈尔市",
"86184408", "云南省昆明市",
"861357402", "湖南省岳阳市",
"86145808", "浙江省宁波市",
"861318945", "广东省湛江市",
"861533479", "内蒙古锡林郭勒盟",
"861580960", "宁夏银川市",
"861318726", "湖南省郴州市",
"861770581", "浙江省杭州市",
"861311574", "浙江省宁波市",
"861869575", "福建省漳州市",
"861555848", "浙江省台州市",
"861356517", "新疆阿勒泰地区",
"86157509", "福建省泉州市",
"86182528", "江苏省南通市",
"861876507", "山东省烟台市",
"861576857", "广东省惠州市",
"861772438", "广东省梅州市",
"861876281", "江苏省无锡市",
"861571076", "广东省深圳市",
"86156352", "山西省晋中市",
"861318176", "山东省莱芜市",
"861350648", "山东省青岛市",
"861322847", "陕西省宝鸡市",
"86159881", "浙江省杭州市",
"861814040", "四川省凉山彝族自治州",
"86189778", "广西河池市",
"861530981", "辽宁省大连市",
"861590732", "湖南省湘潭市",
"861330975", "青海省果洛藏族自治州",
"861507844", "广西玉林市",
"861777610", "广西梧州市",
"861808323", "贵州省铜仁地区",
"861319611", "吉林省松原市",
"861550692", "福建省厦门市",
"861705804", "上海市",
"861454834", "广东省广州市",
"861560783", "广西桂林市",
"861576729", "广东省清远市",
"861869193", "陕西省铜川市",
"861454117", "安徽省宿州市",
"861583433", "山西省晋城市",
"861597480", "云南省昆明市",
"861313362", "江西省鹰潭市",
"861355892", "四川省自贡市",
"861301409", "安徽省阜阳市",
"861501622", "广东省河源市",
"86138425", "辽宁省丹东市",
"861586519", "山东省滨州市",
"86180114", "四川省成都市",
"861330146", "江苏省南通市",
"86155203", "四川省乐山市",
"861777655", "广西南宁市",
"861763310", "河北省邯郸市",
"861479544", "广西河池市",
"861892250", "广东省东莞市",
"861539134", "云南省昆明市",
"861335388", "河南省驻马店市",
"861308177", "辽宁省辽阳市",
"861334394", "河南省周口市",
"861390568", "安徽省阜阳市",
"861450199", "山西省朔州市",
"861576109", "贵州省遵义市",
"861318894", "山东省济南市",
"861880759", "广东省湛江市",
"861857848", "广东省深圳市",
"861770618", "江苏省无锡市",
"861827984", "江西省景德镇市",
"861331679", "广东省惠州市",
"861308727", "湖南省益阳市",
"861860526", "江苏省宿迁市",
"861330905", "四川省内江市",
"86182854", "贵州省黔南布依族苗族自治州",
"861859324", "广西南宁市",
"861321281", "黑龙江省哈尔滨市",
"861324942", "广东省佛山市",
"861590488", "内蒙古呼和浩特市",
"861898823", "云南省德宏傣族景颇族自治州",
"861321507", "福建省泉州市",
"86187936", "甘肃省张掖市",
"86437", "吉林省辽源市",
"861524998", "安徽省滁州市",
"861809636", "四川省广安市",
"861805844", "浙江省杭州市",
"86138391", "河南省焦作市",
"861700663", "山东省烟台市",
"861598761", "云南省大理白族自治州",
"861803932", "河南省信阳市",
"86180463", "福建省泉州市",
"861457122", "黑龙江省鸡西市",
"861707554", "安徽省芜湖市",
"861378051", "河北省石家庄市",
"861308859", "内蒙古乌兰察布市",
"861895480", "山东省枣庄市",
"861328897", "广东省茂名市",
"861519468", "河南省驻马店市",
"861357640", "江西省景德镇市",
"861569810", "山东省莱芜市",
"861318106", "山东省聊城市",
"861880827", "四川省巴中市",
"861303422", "浙江省温州市",
"861816222", "江西省宜春市",
"861839436", "甘肃省平凉市",
"861357472", "湖南省益阳市",
"861386131", "江苏省苏州市",
"861536947", "河北省廊坊市",
"861854300", "吉林省长春市",
"861339926", "陕西省汉中市",
"861311504", "江苏省南京市",
"861319588", "甘肃省庆阳市",
"861569855", "山西省太原市",
"861323061", "河北省保定市",
"86189603", "福建省泉州市",
"861316348", "黑龙江省绥化市",
"861333622", "山东省聊城市",
"861533409", "湖北省孝感市",
"861534730", "湖南省岳阳市",
"861339745", "湖南省怀化市",
"861573530", "山西省阳泉市",
"86147863", "湖南省永州市",
"861850392", "河南省鹤壁市",
"861515258", "江苏省淮安市",
"861380661", "浙江省温州市",
"861351739", "湖南省邵阳市",
"861508623", "贵州省黔东南苗族侗族自治州",
"861337511", "江苏省徐州市",
"861835139", "江苏省宿迁市",
"861323784", "广西贺州市",
"861809628", "四川省凉山彝族自治州",
"861848798", "云南省临沧市",
"861355340", "广东省惠州市",
"861354498", "广东省江门市",
"861316829", "广东省河源市",
"861314264", "内蒙古包头市",
"861887586", "浙江省丽水市",
"86158888", "浙江省杭州市",
"861830888", "云南省丽江市",
"861339938", "甘肃省天水市",
"861837537", "安徽省安庆市",
"861839428", "甘肃省兰州市",
"861318482", "广东省揭阳市",
"86138660", "安徽省安庆市",
"861840856", "贵州省铜仁地区",
"861572744", "湖南省衡阳市",
"861324876", "浙江省温州市",
"861313787", "河南省驻马店市",
"861855941", "福建省宁德市",
"86134867", "浙江省温州市",
"86177191", "河南省驻马店市",
"861767333", "湖南省益阳市",
"861862481", "河南省南阳市",
"861525639", "安徽省亳州市",
"861315070", "云南省昆明市",
"861599349", "河南省驻马店市",
"86184357", "山西省临汾市",
"861500560", "安徽省合肥市",
"861452950", "广东省汕头市",
"861569152", "陕西省宝鸡市",
"861320839", "四川省广元市",
"861324267", "广东省珠海市",
"861890141", "江苏省盐城市",
"861330680", "浙江省舟山市",
"861829989", "新疆喀什地区",
"861355503", "黑龙江省双鸭山市",
"86187752", "广西柳州市",
"861335235", "辽宁省铁岭市",
"861870962", "宁夏石嘴山市",
"861339043", "辽宁省抚顺市",
"861593559", "山西省运城市",
"861552187", "广东省揭阳市",
"861390844", "湖南省衡阳市",
"86130919", "浙江省温州市",
"861387297", "湖北省武汉市",
"861567251", "湖北省宜昌市",
"861320346", "山西省晋城市",
"86188771", "广西南宁市",
"861309820", "陕西省汉中市",
"861554442", "河南省商丘市",
"861362895", "西藏昌都地区",
"86159483", "吉林省长春市",
"861529334", "甘肃省平凉市",
"861524401", "山东省威海市",
"861325188", "吉林省松原市",
"86136125", "广东省佛山市",
"861519955", "新疆哈密地区",
"861334069", "四川省内江市",
"861860538", "山东省泰安市",
"86177933", "甘肃省平凉市",
"861367382", "河南省漯河市",
"861515749", "浙江省丽水市",
"861870349", "山西省朔州市",
"861869523", "宁夏石嘴山市",
"861508980", "广东省江门市",
"861373304", "安徽省六安市",
"861822890", "四川省遂宁市",
"861880479", "内蒙古锡林郭勒盟",
"861511330", "广东省惠州市",
"861315100", "江苏省无锡市",
"861379986", "福建省泉州市",
"861775202", "甘肃省定西市",
"861522470", "河南省信阳市",
"861453088", "安徽省六安市",
"861356963", "河南省鹤壁市",
"861708345", "山西省长治市",
"861593666", "河南省安阳市",
"861301759", "河南省许昌市",
"86159220", "天津市",
"861572637", "山东省枣庄市",
"861774849", "四川省成都市",
"861321797", "江西省赣州市",
"86139786", "广西南宁市",
"861865663", "安徽省合肥市",
"86182121", "贵州省遵义市",
"861804071", "新疆和田地区",
"861802170", "江苏省南通市",
"861315413", "辽宁省抚顺市",
"861808375", "江苏省宿迁市",
"861377298", "陕西省安康市",
"861556974", "甘肃省金昌市",
"86185627", "山东省青岛市",
"861860874", "云南省曲靖市",
"861834487", "江苏省淮安市",
"861339612", "湖北省襄樊市",
"861898805", "云南省昭通市",
"861360721", "湖北省荆州市",
"86181793", "江西省上饶市",
"861830433", "吉林省延边朝鲜族自治州",
"861333916", "安徽省池州市",
"861705526", "湖南省长沙市",
"861592445", "内蒙古乌兰察布市",
"861589730", "湖南省岳阳市",
"861384745", "内蒙古通辽市",
"861770379", "河南省洛阳市",
"861350897", "山东省济宁市",
"861322698", "广东省佛山市",
"86138992", "新疆阿克苏地区",
"861571738", "湖南省娄底市",
"861331318", "河北省衡水市",
"861582912", "陕西省榆林市",
"861346918", "湖南省常德市",
"861804687", "江西省赣州市",
"861587073", "江西省赣州市",
"861309412", "湖北省襄樊市",
"861709666", "浙江省宁波市",
"861511917", "广东省韶关市",
"861478071", "四川省泸州市",
"861560494", "辽宁省本溪市",
"86156319", "河北省邢台市",
"861311794", "江西省抚州市",
"861800633", "山东省日照市",
"86150242", "广东省佛山市",
"86151938", "甘肃省天水市",
"861885705", "浙江省舟山市",
"861335959", "黑龙江省大庆市",
"861530532", "山东省青岛市",
"861344957", "山东省青岛市",
"861454508", "湖南省长沙市",
"86183758", "重庆市",
"861318076", "吉林省吉林市",
"861538886", "云南省红河哈尼族彝族自治州",
"861820977", "青海省海西蒙古族藏族自治州",
"861771380", "四川省南充市",
"861314527", "内蒙古包头市",
"861521693", "广东省河源市",
"861329500", "福建省泉州市",
"861833418", "贵州省毕节地区",
"861786548", "山东省泰安市",
"861326474", "湖北省武汉市",
"861839158", "陕西省渭南市",
"861559067", "吉林省长春市",
"861781682", "浙江省温州市",
"861337760", "广东省中山市",
"86181266", "广东省佛山市",
"861308518", "湖北省荆门市",
"861380322", "河北省廊坊市",
"861571726", "湖北省恩施土家族苗族自治州",
"861803618", "江苏省南通市",
"861303810", "四川省自贡市",
"86151027", "湖北省武汉市",
"861810974", "青海省海南藏族自治州",
"861313291", "广西南宁市",
"861590833", "四川省广安市",
"861587125", "湖北省随州市",
"861369609", "四川省广元市",
"861569422", "辽宁省鞍山市",
"861539034", "四川省宜宾市",
"861365682", "浙江省舟山市",
"861760568", "安徽省亳州市",
"861348031", "广东省揭阳市",
"861568536", "贵州省安顺市",
"861856982", "河南省焦作市",
"861308007", "吉林省松原市",
"861560882", "云南省德宏傣族景颇族自治州",
"861770932", "甘肃省定西市",
"861355793", "广西桂林市",
"861780278", "湖北省黄石市",
"86180104", "北京市",
"86155213", "广东省广州市",
"861596301", "山东省青岛市",
"86159036", "河南省郑州市",
"861508605", "贵州省遵义市",
"861869093", "新疆博尔塔拉蒙古自治州",
"861351414", "辽宁省本溪市",
"861303855", "陕西省咸阳市",
"861803277", "河北省石家庄市",
"861352970", "云南省楚雄彝族自治州",
"861859656", "福建省泉州市",
"861876118", "江苏省常州市",
"861323553", "湖北省武汉市",
"861365304", "广东省茂名市",
"861452274", "山西省晋中市",
"86158178", "广东省佛山市",
"861812041", "湖北省武汉市",
"861806491", "四川省攀枝花市",
"861538561", "安徽省淮北市",
"861587705", "广西玉林市",
"861881344", "广东省茂名市",
"861471821", "广东省河源市",
"861470613", "江苏省苏州市",
"861871474", "黑龙江省齐齐哈尔市",
"861385229", "江苏省南京市",
"861872910", "陕西省西安市",
"861356178", "山东省泰安市",
"861479922", "新疆阿克苏地区",
"861317512", "浙江省杭州市",
"861814395", "河南省漯河市",
"861365374", "河南省许昌市",
"861843231", "河北省石家庄市",
"86187719", "湖北省武汉市",
"861787831", "广西梧州市",
"86133546", "云南省昆明市",
"86184379", "河南省洛阳市",
"861304526", "黑龙江省大兴安岭地区",
"861313949", "甘肃省酒泉市",
"861311838", "四川省乐山市",
"861323493", "黑龙江省齐齐哈尔市",
"861338481", "内蒙古赤峰市",
"861576009", "四川省宜宾市",
"861538475", "内蒙古通辽市",
"86151020", "广东省广州市",
"861506801", "浙江省舟山市",
"861369679", "安徽省合肥市",
"861399545", "宁夏吴忠市",
"861500333", "河北省张家口市",
"861829747", "安徽省六安市",
"861780208", "广东省韶关市",
"861352396", "河南省驻马店市",
"861898722", "云南省大理白族自治州",
"861813867", "广东省江门市",
"861372311", "河南省信阳市",
"861363328", "河北省衡水市",
"861887240", "湖北省荆门市",
"861885125", "江苏省连云港市",
"861592982", "陕西省榆林市",
"86189613", "江苏省连云港市",
"861893427", "广东省阳江市",
"86156583", "浙江省宁波市",
"86150205", "山东省菏泽市",
"861588580", "贵州省黔东南苗族侗族自治州",
"861570649", "山东省临沂市",
"861893911", "河南省许昌市",
"861820907", "新疆阿勒泰地区",
"861454578", "四川省雅安市",
"861457022", "江西省九江市",
"861388460", "山东省淄博市",
"861329570", "浙江省衢州市",
"861893366", "广东省汕头市",
"861819744", "青海省黄南藏族自治州",
"861535716", "安徽省六安市",
"861361745", "湖南省怀化市",
"861832994", "陕西省西安市",
"861771444", "江苏省苏州市",
"861514225", "辽宁省朝阳市",
"86153229", "广东省东莞市",
"86134799", "江西省赣州市",
"861344011", "四川省资阳市",
"861770309", "广东省湛江市",
"861598495", "四川省凉山彝族自治州",
"861817749", "广西贺州市",
"861362522", "江苏省南通市",
"861570921", "陕西省延安市",
"861363336", "河北省唐山市",
"861571482", "内蒙古兴安盟",
"861536391", "广东省茂名市",
"861587003", "江西省南昌市",
"861872468", "黑龙江省鹤岗市",
"861573363", "河北省石家庄市",
"861363849", "湖南省邵阳市",
"861361938", "甘肃省天水市",
"861470994", "新疆昌吉回族自治州",
"861806978", "浙江省杭州市",
"861560554", "安徽省淮南市",
"86185620", "山东省东营市",
"861860804", "四川省成都市",
"86137621", "湖南省湘西土家族苗族自治州",
"861310019", "山西省运城市",
"861533759", "福建省南平市",
"86155435", "吉林省长春市",
"861898875", "广东省深圳市",
"861760995", "新疆吐鲁番地区",
"861570417", "辽宁省营口市",
"861875242", "江苏省淮安市",
"86176398", "河南省三门峡市",
"86157383", "河南省郑州市",
"861769320", "甘肃省定西市",
"861814686", "陕西省汉中市",
"861325088", "浙江省温州市",
"861473638", "广西梧州市",
"86130736", "浙江省杭州市",
"861775272", "湖南省常德市",
"861380253", "广东省广州市",
"861533827", "广东省中山市",
"861450529", "吉林省辽源市",
"86151593", "福建省宁德市",
"861552087", "四川省南充市",
"861815234", "宁夏吴忠市",
"86159227", "重庆市",
"861708190", "福建省厦门市",
"86170882", "海南省海口市",
"861304096", "湖北省宜昌市",
"86182270", "四川省绵阳市",
"86156478", "内蒙古巴彦淖尔市",
"861313621", "浙江省嘉兴市",
"861361043", "广东省惠州市",
"861885822", "浙江省宁波市",
"861569786", "江西省吉安市",
"861454951", "江苏省无锡市",
"861891455", "江苏省镇江市",
"861383444", "山西省朔州市",
"861528692", "河南省濮阳市",
"861304538", "黑龙江省七台河市",
"861503318", "河北省衡水市",
"861334256", "湖南省常德市",
"861373374", "河南省许昌市",
"861327535", "山东省烟台市",
"861347569", "山东省潍坊市",
"861311826", "四川省南充市",
"861836221", "江苏省苏州市",
"861803776", "河南省商丘市",
"86138855", "贵州省黔东南苗族侗族自治州",
"861302080", "河北省保定市",
"861840466", "黑龙江省哈尔滨市",
"861860677", "浙江省丽水市",
"861707448", "浙江省绍兴市",
"861700384", "河南省郑州市",
"861812690", "广东省汕头市",
"861471553", "广东省中山市",
"861320749", "湖南省长沙市",
"861593274", "河北省沧州市",
"86189397", "上海市",
"861562876", "山东省济南市",
"861768885", "广东省广州市",
"861504725", "内蒙古赤峰市",
"861513529", "山西省吕梁市",
"861365497", "辽宁省沈阳市",
"86188668", "山东省济南市",
"861331424", "辽宁省沈阳市",
"861803126", "河北省石家庄市",
"861390734", "湖南省衡阳市",
"86134166", "广东省东莞市",
"861337231", "浙江省嘉兴市",
"861894440", "江苏省南通市",
"861786667", "山东省潍坊市",
"861804884", "四川省内江市",
"861836040", "江苏省无锡市",
"86137237", "广东省深圳市",
"861857945", "广西南宁市",
"861806823", "江苏省宿迁市",
"861599925", "新疆伊犁哈萨克自治州",
"861831934", "广东省湛江市",
"861575160", "江苏省盐城市",
"86138244", "广东省广州市",
"861840327", "河北省沧州市",
"861337870", "云南省昭通市",
"861855583", "安徽省马鞍山市",
"861590390", "河南省平顶山市",
"86134649", "辽宁省鞍山市",
"861523426", "山西省太原市",
"861351849", "四川省内江市",
"861353938", "广东省潮州市",
"861479036", "安徽省合肥市",
"861313373", "江西省抚州市",
"861568144", "四川省广安市",
"861335550", "安徽省滁州市",
"861590906", "新疆阿勒泰地区",
"861810535", "山东省烟台市",
"861800400", "辽宁省沈阳市",
"861807478", "广西河池市",
"861569958", "吉林省延边朝鲜族自治州",
"861582577", "浙江省金华市",
"861340455", "吉林省松原市",
"861472985", "陕西省安康市",
"861572834", "广东省云浮市",
"861887591", "广东省深圳市",
"86150070", "江西省赣州市",
"86180803", "四川省南充市",
"861760647", "山东省东营市",
"861562267", "广东省揭阳市",
"861555106", "安徽省马鞍山市",
"861523367", "河北省廊坊市",
"861561546", "山东省东营市",
"861351336", "河北省秦皇岛市",
"861870903", "新疆和田地区",
"861893282", "河北省衡水市",
"861350913", "陕西省渭南市",
"861764557", "黑龙江省黑河市",
"861591121", "云南省大理白族自治州",
"861853436", "山西省临汾市",
"861453445", "辽宁省朝阳市",
"861819017", "四川省遂宁市",
"861820512", "江苏省连云港市",
"861886744", "湖南省岳阳市",
"861364715", "湖北省荆州市",
"861395113", "江苏省苏州市",
"861512976", "陕西省汉中市",
"861559409", "甘肃省张掖市",
"861370541", "山东省济南市",
"861562942", "湖北省荆门市",
"86155261", "湖南省怀化市",
"861459140", "广西百色市",
"861523438", "山西省吕梁市",
"861760419", "辽宁省辽阳市",
"861353926", "广东省揭阳市",
"861811473", "江苏省苏州市",
"861591771", "广东省东莞市",
"861539280", "湖北省仙桃市",
"861821201", "贵州省贵阳市",
"861779773", "河南省郑州市",
"861770456", "黑龙江省黑河市",
"861351328", "河北省保定市",
"861560307", "广东省广州市",
"86139777", "广西钦州市",
"861339835", "四川省绵阳市",
"86183399", "河南省郑州市",
"861534840", "湖南省岳阳市",
"861533294", "内蒙古赤峰市",
"861319031", "辽宁省盘锦市",
"861327904", "新疆巴音郭楞蒙古自治州",
"861876638", "山东省烟台市",
"861505991", "福建省龙岩市",
"861378792", "湖南省湘西土家族苗族自治州",
"861380365", "黑龙江省佳木斯市",
"86182286", "四川省达州市",
"861818186", "四川省泸州市",
"861338669", "浙江省舟山市",
"861860764", "广东省汕尾市",
"861569465", "云南省保山市",
"861376830", "广西南宁市",
"861508589", "贵州省黔西南布依族苗族自治州",
"861340968", "湖北省黄冈市",
"861879743", "湖南省株洲市",
"861321296", "黑龙江省齐齐哈尔市",
"861452666", "江西省吉安市",
"86145320", "浙江省杭州市",
"861880356", "山西省晋城市",
"861376271", "湖南省益阳市",
"861308469", "浙江省丽水市",
"861530370", "河南省商丘市",
"861362998", "新疆喀什地区",
"861301167", "山东省潍坊市",
"861366345", "山西省长治市",
"861569571", "浙江省杭州市",
"861354380", "广东省中山市",
"861819508", "宁夏银川市",
"861452818", "四川省达州市",
"861811584", "江苏省苏州市",
"861524192", "辽宁省本溪市",
"861818853", "贵州省安顺市",
"861317907", "吉林省白山市",
"861500342", "山西省大同市",
"861803138", "河北省张家口市",
"86147801", "四川省眉山市",
"861850730", "湖南省岳阳市",
"86136011", "北京市",
"861331054", "湖北省恩施土家族苗族自治州",
"861819578", "青海省西宁市",
"861569287", "四川省凉山彝族自治州",
"861776780", "吉林省吉林市",
"86136682", "四川省成都市",
"861350224", "广东省广州市",
"861536273", "广东省中山市",
"861869851", "浙江省嘉兴市",
"861356237", "山东省日照市",
"861569501", "宁夏银川市",
"861890690", "福建省福州市",
"861590842", "四川省广元市",
"86875", "云南省保山市",
"861537378", "河北省邯郸市",
"861530300", "广东省清远市",
"861584993", "内蒙古锡林郭勒盟",
"861368948", "甘肃省张掖市",
"861857482", "湖南省娄底市",
"861564847", "内蒙古赤峰市",
"861528487", "四川省广元市",
"861811110", "四川省成都市",
"861317977", "江苏省扬州市",
"861576467", "黑龙江省鸡西市",
"861454744", "浙江省宁波市",
"861334757", "广西贵港市",
"861770943", "甘肃省白银市",
"861502977", "陕西省汉中市",
"861301294", "山东省青岛市",
"861530996", "新疆巴音郭楞蒙古自治州",
"861773750", "河南省郑州市",
"861572798", "浙江省衢州市",
"861379347", "山东省德州市",
"86132520", "浙江省湖州市",
"861376587", "贵州省毕节地区",
"861898765", "云南省红河哈尼族彝族自治州",
"861809016", "四川省泸州市",
"861389477", "吉林省长春市",
"861328567", "安徽省亳州市",
"861856211", "山东省东营市",
"861530543", "山东省滨州市",
"861560377", "河南省南阳市",
"86158335", "河北省唐山市",
"861779703", "青海省黄南藏族自治州",
"861811403", "江苏省南京市",
"861591701", "广东省佛山市",
"861505249", "江苏省连云港市",
"861327974", "新疆伊犁哈萨克自治州",
"861831689", "广东省云浮市",
"86139770", "广西防城港市",
"861821830", "广东省清远市",
"861518195", "四川省泸州市",
"861584546", "黑龙江省鹤岗市",
"861318329", "河南省商丘市",
"861870973", "青海省黄南藏族自治州",
"86158954", "江苏省苏州市",
"861472670", "四川省泸州市",
"861705181", "海南省海口市",
"861571697", "河北省沧州市",
"861533167", "云南省大理白族自治州",
"861770596", "福建省漳州市",
"861390898", "西藏拉萨市",
"861813664", "江苏省常州市",
"861559479", "陕西省汉中市",
"86170816", "江苏省无锡市",
"861801489", "江苏省苏州市",
"861588989", "广东省中山市",
"861318848", "辽宁省辽阳市",
"861800470", "内蒙古呼伦贝尔市",
"861807408", "浙江省嘉兴市",
"861473118", "河北省保定市",
"861590976", "青海省玉树藏族自治州",
"861303389", "河南省鹤壁市",
"861535217", "甘肃省嘉峪关市",
"861555176", "安徽省马鞍山市",
"861362565", "安徽省合肥市",
"861866047", "山东省济宁市",
"861533624", "陕西省榆林市",
"86134655", "山东省烟台市",
"861303791", "宁夏石嘴山市",
"861867255", "湖北省荆州市",
"86155119", "河北省唐山市",
"86130323", "重庆市",
"861459686", "新疆石河子市",
"861306359", "江苏省南通市",
"861347418", "陕西省渭南市",
"861326397", "江西省赣州市",
"861453982", "广东省深圳市",
"861329979", "青海省海东地区",
"861379758", "湖北省襄樊市",
"861867210", "湖北省宜昌市",
"861479458", "黑龙江省伊春市",
"861813777", "河南省郑州市",
"861857894", "广西河池市",
"861503424", "山西省大同市",
"861359292", "广东省揭阳市",
"861534653", "河南省驻马店市",
"86150012", "北京市",
"86184868", "贵州省贵阳市",
"861800642", "山东省青岛市",
"86150681", "浙江省杭州市",
"861555945", "新疆阿克苏地区",
"861562194", "内蒙古呼伦贝尔市",
"861362471", "内蒙古呼和浩特市",
"861815080", "福建省福州市",
"861562485", "内蒙古兴安盟",
"861313303", "山西省朔州市",
"86134358", "广东省肇庆市",
"861535678", "浙江省丽水市",
"861880067", "江苏省淮安市",
"861471493", "广东省东莞市",
"861700672", "浙江省温州市",
"861520720", "湖北省宜昌市",
"861894384", "吉林省四平市",
"86182988", "甘肃省庆阳市",
"861824886", "江苏省镇江市",
"861510088", "河北省邢台市",
"861330878", "云南省楚雄彝族自治州",
"861337800", "湖南省岳阳市",
"86182424", "辽宁省丹东市",
"861858243", "四川省乐山市",
"861532260", "广东省汕头市",
"861319350", "河南省安阳市",
"861554888", "内蒙古兴安盟",
"861860607", "福建省福州市",
"861582018", "广东省茂名市",
"861594939", "广西百色市",
"861375414", "内蒙古乌兰察布市",
"861323821", "辽宁省阜新市",
"861562806", "贵州省毕节地区",
"861365557", "安徽省宿州市",
"861313540", "安徽省合肥市",
"861367266", "广东省珠海市",
"861593204", "河北省邯郸市",
"861518892", "河北省邯郸市",
"86189390", "河南省三门峡市",
"86185815", "四川省成都市",
"861336718", "湖北省恩施土家族苗族自治州",
"861534392", "河南省濮阳市",
"861454889", "四川省绵阳市",
"861879197", "陕西省宝鸡市",
"861318813", "辽宁省锦州市",
"861454263", "西藏山南地区",
"86138690", "山东省威海市",
"861334313", "河北省张家口市",
"861533533", "山东省淄博市",
"861894178", "辽宁省葫芦岛市",
"861339638", "山东省烟台市",
"861459249", "四川省攀枝花市",
"861895405", "山东省济宁市",
"861876835", "浙江省湖州市",
"861506619", "山东省青岛市",
"861815387", "湖南省郴州市",
"861770460", "福建省福州市",
"861572272", "江苏省苏州市",
"861809928", "新疆吐鲁番地区",
"861347443", "陕西省延安市",
"86182774", "广西梧州市",
"861346932", "湖南省怀化市",
"861380316", "河北省廊坊市",
"861707170", "江西省吉安市",
"861830799", "江西省萍乡市",
"861539189", "安徽省宿州市",
"861331332", "河北省保定市",
"861380961", "广东省东莞市",
"861329054", "河北省保定市",
"861470567", "安徽省亳州市",
"861309438", "云南省文山壮族苗族自治州",
"861830381", "河南省安阳市",
"861846422", "山东省青岛市",
"861536419", "湖南省邵阳市",
"86189524", "江苏省苏州市",
"861328133", "四川省乐山市",
"861764531", "黑龙江省牡丹江市",
"861595944", "福建省厦门市",
"86139156", "江苏省苏州市",
"861708754", "江西省抚州市",
"86135413", "四川省成都市",
"861853740", "河南省焦作市",
"861452615", "江苏省苏州市",
"861519655", "四川省巴中市",
"861773933", "河南省许昌市",
"861569416", "辽宁省锦州市",
"861870662", "山东省滨州市",
"861597561", "广东省广州市",
"861550144", "江苏省徐州市",
"861452650", "江西省鹰潭市",
"861519610", "四川省广元市",
"861880360", "河南省濮阳市",
"861895153", "江苏省宿迁市",
"861554970", "湖北省黄石市",
"861366941", "广西南宁市",
"861458572", "山东省济宁市",
"861829689", "江西省赣州市",
"861330980", "辽宁省鞍山市",
"861839830", "四川省达州市",
"86159148", "广东省韶关市",
"861336743", "湖南省湘西土家族苗族自治州",
"861850953", "宁夏吴忠市",
"861319057", "内蒙古锡林郭勒盟",
"861320552", "安徽省蚌埠市",
"861368913", "陕西省渭南市",
"861517762", "广西百色市",
"861890779", "广西北海市",
"861770918", "陕西省西安市",
"861338711", "湖北省黄冈市",
"861359128", "辽宁省锦州市",
"861476972", "山东省济南市",
"861840415", "辽宁省丹东市",
"861331979", "新疆和田地区",
"86177814", "四川省成都市",
"861826147", "江苏省无锡市",
"861577454", "黑龙江省佳木斯市",
"86139420", "辽宁省大连市",
"861459478", "陕西省西安市",
"861508046", "福建省福州市",
"861558307", "四川省阿坝藏族羌族自治州",
"861566402", "河南省郑州市",
"861370683", "浙江省嘉兴市",
"861302762", "河南省郑州市",
"861522094", "广东省河源市",
"861840450", "黑龙江省哈尔滨市",
"861300405", "安徽省芜湖市",
"861310530", "山东省菏泽市",
"861565119", "江苏省宿迁市",
"861359778", "湖北省恩施土家族苗族自治州",
"861339626", "山东省德州市",
"86187872", "云南省大理白族自治州",
"86147893", "湖南省衡阳市",
"861705512", "浙江省温州市",
"861300153", "山东省潍坊市",
"861881423", "广东省湛江市",
"861333922", "安徽省阜阳市",
"861858764", "广西百色市",
"861816144", "四川省南充市",
"861309367", "安徽省蚌埠市",
"861817687", "广西南宁市",
"861536647", "江苏省盐城市",
"861897192", "湖北省十堰市",
"861567008", "河南省鹤壁市",
"861309426", "湖北省武汉市",
"861357940", "新疆乌鲁木齐市",
"861894736", "内蒙古赤峰市",
"86130442", "广东省广州市",
"861503909", "河南省郑州市",
"861336045", "广东省东莞市",
"86187817", "四川省南充市",
"86185969", "福建省莆田市",
"861335566", "安徽省池州市",
"86130024", "辽宁省沈阳市",
"861831246", "广东省深圳市",
"861809936", "新疆昌吉回族自治州",
"861524698", "黑龙江省黑河市",
"861308532", "云南省普洱市",
"861472799", "陕西省汉中市",
"86188851", "贵州省贵阳市",
"861803632", "江苏省盐城市",
"86557", "安徽省宿州市",
"86180493", "陕西省榆林市",
"861504234", "辽宁省鞍山市",
"861700963", "安徽省合肥市",
"86138361", "黑龙江省哈尔滨市",
"861384912", "河南省开封市",
"861378449", "河北省秦皇岛市",
"861361354", "山西省晋中市",
"861362516", "江苏省淮安市",
"861768511", "贵州省贵阳市",
"86187810", "四川省德阳市",
"86152923", "新疆阿克苏地区",
"861537555", "安徽省马鞍山市",
"861837805", "广西玉林市",
"861320884", "云南省昆明市",
"861567078", "河南省安阳市",
"861822669", "安徽省宣城市",
"861329424", "湖北省宜昌市",
"861596534", "山东省德州市",
"861395148", "江苏省盐城市",
"86156843", "山东省潍坊市",
"861478749", "云南省昆明市",
"861590527", "江苏省扬州市",
"861874588", "黑龙江省伊春市",
"861537510", "安徽省巢湖市",
"861526549", "山东省临沂市",
"86135235", "河南省郑州市",
"861529389", "甘肃省临夏回族自治州",
"861318645", "江苏省盐城市",
"861894963", "安徽省马鞍山市",
"861804749", "内蒙古呼和浩特市",
"861813545", "山西省运城市",
"861899949", "新疆塔城地区",
"861529791", "江西省南昌市",
"861365531", "山东省济南市",
"861555341", "山东省德州市",
"861877883", "广西桂林市",
"861867119", "湖北省十堰市",
"86158141", "广东省东莞市",
"861509821", "山东省菏泽市",
"86130650", "山东省济南市",
"861338333", "河北省张家口市",
"86139427", "辽宁省盘锦市",
"861459408", "云南省昭通市",
"861882831", "四川省成都市",
"861359708", "广西河池市",
"861351784", "广西梧州市",
"861319427", "辽宁省盘锦市",
"861528044", "福建省福州市",
"861323739", "湖南省邵阳市",
"861324400", "吉林省吉林市",
"861452843", "甘肃省白银市",
"861532256", "广东省汕头市",
"861315085", "内蒙古鄂尔多斯市",
"861890709", "江西省南昌市",
"861865008", "福建省福州市",
"861335881", "辽宁省葫芦岛市",
"861319366", "河南省南阳市",
"861598039", "福建省宁德市",
"861311812", "四川省德阳市",
"861889528", "宁夏银川市",
"861331909", "新疆博尔塔拉蒙古自治州",
"861330675", "浙江省绍兴市",
"861345542", "山东省东营市",
"861530681", "浙江省杭州市",
"861550992", "新疆伊犁哈萨克自治州",
"861805695", "安徽省宣城市",
"861300561", "广东省湛江市",
"861566640", "山东省济南市",
"861354671", "山西省太原市",
"861317096", "江西省吉安市",
"861477091", "江西省赣州市",
"861317526", "浙江省绍兴市",
"861479916", "新疆克拉玛依市",
"861554900", "湖北省荆州市",
"861458502", "河南省信阳市",
"861841947", "甘肃省天水市",
"861773766", "河南省信阳市",
"861301533", "山西省晋中市",
"861889098", "新疆哈密地区",
"861866573", "广东省广州市",
"861811219", "江苏省泰州市",
"86134890", "福建省福州市",
"861883859", "河南省商丘市",
"86152574", "浙江省宁波市",
"861805386", "山东省青岛市",
"861576741", "广东省广州市",
"861787654", "广东省梅州市",
"861320492", "湖南省怀化市",
"86188453", "黑龙江省牡丹江市",
"861800148", "江苏省南通市",
"861577024", "云南省怒江傈僳族自治州",
"861508214", "四川省资阳市",
"86180891", "陕西省西安市",
"861825440", "山东省滨州市",
"86155706", "湖北省襄樊市",
"86159724", "湖北省恩施土家族苗族自治州",
"861362644", "山东省淄博市",
"861850446", "吉林省白城市",
"861364933", "甘肃省平凉市",
"861309782", "广西贵港市",
"861311115", "山西省长治市",
"86185922", "陕西省西安市",
"861391241", "江苏省南通市",
"861394982", "河南省许昌市",
"86139368", "黑龙江省大庆市",
"861334731", "湖南省长沙市",
"861390695", "福建省漳州市",
"861771252", "江苏省盐城市",
"861878631", "贵州省遵义市",
"861350735", "湖南省郴州市",
"86138697", "山东省菏泽市",
"861597153", "湖北省黄石市",
"861339296", "广东省珠海市",
"86135164", "安徽省六安市",
"861361912", "陕西省榆林市",
"86133429", "广东省深圳市",
"861700728", "山东省临沂市",
"861327429", "辽宁省葫芦岛市",
"861863454", "山西省运城市",
"861369811", "四川省达州市",
"861895475", "山东省菏泽市",
"86139665", "安徽省阜阳市",
"861457016", "山东省威海市",
"861314976", "辽宁省锦州市",
"861873902", "河南省南阳市",
"861890869", "湖北省荆门市",
"861894237", "江西省赣州市",
"86187460", "黑龙江省哈尔滨市",
"861831747", "河南省濮阳市",
"861562715", "广东省湛江市",
"861567846", "广西贵港市",
"861881891", "广东省广州市",
"861361507", "福建省漳州市",
"861337756", "广东省珠海市",
"861353912", "广东省河源市",
"861458330", "江西省上饶市",
"861452135", "河北省沧州市",
"861890283", "广东省深圳市",
"861550528", "江苏省无锡市",
"86136364", "上海市",
"861364942", "广西柳州市",
"861347788", "湖北省恩施土家族苗族自治州",
"86151501", "江苏省苏州市",
"861390947", "甘肃省酒泉市",
"861806880", "江苏省南京市",
"861517023", "江西省南昌市",
"861820526", "江苏省泰州市",
"86156728", "湖北省荆门市",
"861392302", "广东省梅州市",
"861332840", "福建省厦门市",
"86138747", "湖南省永州市",
"861373188", "安徽省宣城市",
"86137734", "江苏省扬州市",
"861803850", "广东省河源市",
"86177113", "四川省成都市",
"861503500", "山西省忻州市",
"861357549", "浙江省杭州市",
"861776968", "浙江省湖州市",
"861817492", "广西河池市",
"86186245", "辽宁省盘锦市",
"861302872", "甘肃省白银市",
"861846465", "山东省东营市",
"861336488", "新疆喀什地区",
"861829505", "宁夏中卫市",
"861508808", "广东省广州市",
"861529855", "江苏省盐城市",
"861859660", "福建省厦门市",
"861458421", "河南省安阳市",
"861303658", "四川省乐山市",
"861477186", "湖北省随州市",
"861509553", "甘肃省平凉市",
"861596905", "云南省德宏傣族景颇族自治州",
"861598378", "四川省南充市",
"861832648", "安徽省六安市",
"861301542", "山西省临汾市",
"861385700", "浙江省衢州市",
"861855520", "安徽省滁州市",
"861819889", "广东省广州市",
"861515552", "安徽省淮北市",
"861888287", "四川省凉山彝族自治州",
"861536568", "江苏省盐城市",
"861477853", "广东省惠州市",
"861529810", "四川省达州市",
"861708629", "山东省临沂市",
"861814249", "陕西省铜川市",
"861564998", "河南省周口市",
"86176857", "山东省青岛市",
"861810429", "辽宁省葫芦岛市",
"861518268", "四川省广安市",
"861558185", "山西省太原市",
"861503343", "河北省石家庄市",
"861379691", "黑龙江省双鸭山市",
"861338342", "山西省大同市",
"86136987", "云南省昆明市",
"861470648", "山东省青岛市",
"861364876", "云南省文山壮族苗族自治州",
"861350042", "辽宁省鞍山市",
"861319282", "广东省惠州市",
"861817884", "广西柳州市",
"861302175", "山东省聊城市",
"861530469", "黑龙江省大庆市",
"861308370", "河南省商丘市",
"861504080", "辽宁省抚顺市",
"861589446", "云南省普洱市",
"861839652", "福建省福州市",
"86137808", "山东省潍坊市",
"861369790", "江西省赣州市",
"861328994", "新疆昌吉回族自治州",
"861452832", "四川省内江市",
"86158444", "吉林省四平市",
"861317181", "河北省唐山市",
"861857712", "广西崇左市",
"86139274", "广东省深圳市",
"861833956", "河南省漯河市",
"86158022", "天津市",
"861886937", "云南省昆明市",
"86132606", "湖北省武汉市",
"861330589", "浙江省金华市",
"861302725", "江西省九江市",
"86177049", "新疆乌鲁木齐市",
"861805947", "福建省三明市",
"861776410", "湖北省荆门市",
"86151118", "重庆市",
"861708941", "广东省肇庆市",
"861773485", "河南省平顶山市",
"86138313", "河北省张家口市",
"861380434", "吉林省四平市",
"861554579", "黑龙江省双鸭山市",
"861356384", "山东省泰安市",
"86132832", "河北省沧州市",
"861815105", "江苏省扬州市",
"861569334", "甘肃省兰州市",
"861322895", "西藏昌都地区",
"861820538", "山东省泰安市",
"861333965", "贵州省黔东南苗族侗族自治州",
"861354323", "广东省梅州市",
"86132125", "重庆市",
"861302593", "广西柳州市",
"861310372", "河南省安阳市",
"861550536", "山东省潍坊市",
"861360346", "河南省安阳市",
"861776103", "四川省绵阳市",
"861820096", "广东省惠州市",
"861782021", "广东省深圳市",
"861326641", "广东省湛江市",
"8613489", "福建省泉州市",
"861839393", "甘肃省平凉市",
"861321143", "广西桂林市",
"86157084", "四川省成都市",
"861476008", "福建省宁德市",
"861390262", "广东省惠州市",
"861335004", "四川省德阳市",
"861514898", "内蒙古阿拉善盟",
"861538398", "河北省秦皇岛市",
"861572651", "山东省聊城市",
"861865972", "福建省泉州市",
"861310684", "广东省珠海市",
"861339797", "江西省赣州市",
"861815946", "福建省龙岩市",
"861539914", "陕西省商洛市",
"86183921", "陕西省西安市",
"861335074", "四川省乐山市",
"861898678", "湖北省宜昌市",
"861381942", "浙江省宁波市",
"861589953", "广东省惠州市",
"861570325", "河北省唐山市",
"861348366", "河北省石家庄市",
"861800094", "广东省揭阳市",
"861454937", "江苏省苏州市",
"861760789", "广西南宁市",
"861808901", "西藏拉萨市",
"861332653", "广东省韶关市",
"861814408", "福建省厦门市",
"861364485", "内蒙古通辽市",
"861450983", "新疆塔城地区",
"861328845", "广东省广州市",
"861815175", "江苏省镇江市",
"861803643", "江苏省南通市",
"861391450", "江苏省泰州市",
"861760391", "河南省焦作市",
"861310302", "河北省保定市",
"861308543", "湖南省永州市",
"861889144", "陕西省西安市",
"86139879", "云南省普洱市",
"86185353", "山西省阳泉市",
"861324633", "广东省佛山市",
"86135863", "浙江省嘉兴市",
"861320687", "黑龙江省牡丹江市",
"861454310", "黑龙江省鸡西市",
"861809592", "新疆和田地区",
"861554509", "黑龙江省大庆市",
"861308996", "黑龙江省绥化市",
"861576954", "宁夏固原市",
"861329318", "河北省秦皇岛市",
"861343722", "湖北省荆州市",
"861379221", "山东省德州市",
"861825251", "江苏省南通市",
"861810059", "福建省莆田市",
"861454355", "山东省威海市",
"861873846", "河南省驻马店市",
"861332392", "河南省鹤壁市",
"861581998", "广东省中山市",
"861567902", "江西省鹰潭市",
"86187328", "河北省衡水市",
"861535063", "河北省唐山市",
"861308300", "安徽省合肥市",
"861773267", "河北省秦皇岛市",
"861848355", "四川省雅安市",
"861867639", "广东省深圳市",
"86152309", "河北省唐山市",
"861315279", "山西省运城市",
"86152352", "山西省大同市",
"861311635", "贵州省遵义市",
"861328142", "四川省达州市",
"861586610", "山东省菏泽市",
"861815872", "浙江省湖州市",
"861532757", "湖北省孝感市",
"861821158", "广东省揭阳市",
"861358101", "山东省淄博市",
"861566091", "河南省商丘市",
"861808498", "四川省达州市",
"861773942", "河南省南阳市",
"861814991", "新疆乌鲁木齐市",
"86138589", "浙江省金华市",
"861565984", "福建省三明市",
"861387245", "湖北省宜昌市",
"86186528", "江苏省镇江市",
"86176850", "贵州省贵阳市",
"861367441", "吉林省吉林市",
"861378814", "广西梧州市",
"861582032", "广东省清远市",
"861514734", "内蒙古赤峰市",
"861861740", "河北省邢台市",
"861809022", "四川省阿坝藏族羌族自治州",
"861399777", "湖北省恩施土家族苗族自治州",
"861558554", "吉林省白城市",
"86156144", "河北省保定市",
"861598308", "四川省遂宁市",
"861551269", "河北省衡水市",
"861336732", "湖南省湘潭市",
"861809873", "安徽省宿州市",
"861840999", "新疆伊犁哈萨克自治州",
"861871929", "广东省阳江市",
"861596975", "山东省德州市",
"861533542", "山东省青岛市",
"86133812", "北京市",
"861315448", "四川省德阳市",
"861709843", "浙江省金华市",
"86138740", "湖南省岳阳市",
"861302802", "山西省临汾市",
"861343875", "四川省南充市",
"861774061", "湖北省荆门市",
"861780792", "江西省九江市",
"861346943", "湖南省长沙市",
"861520783", "广西桂林市",
"861509161", "陕西省汉中市",
"861858196", "四川省成都市",
"861800524", "江苏省宿迁市",
"86131990", "黑龙江省大庆市",
"861331343", "山西省太原市",
"861361577", "浙江省温州市",
"861539352", "甘肃省武威市",
"861896380", "新疆乌鲁木齐市",
"861524737", "内蒙古鄂尔多斯市",
"861873972", "河南省安阳市",
"861314906", "广东省韶关市",
"86186259", "河南省新乡市",
"861347432", "陕西省汉中市",
"861899540", "宁夏固原市",
"86187467", "黑龙江省鸡西市",
"861501458", "广东省揭阳市",
"861800369", "黑龙江省大庆市",
"861532829", "四川省巴中市",
"861526940", "山东省济宁市",
"861537919", "甘肃省平凉市",
"861846501", "宁夏银川市",
"86184898", "海南省海口市",
"861555645", "安徽省合肥市",
"861869747", "内蒙古呼伦贝尔市",
"861800942", "甘肃省白银市",
"861534953", "宁夏吴忠市",
"861339507", "福建省厦门市",
"861539275", "湖北省荆州市",
"861350845", "湖南省益阳市",
"86188421", "辽宁省朝阳市",
"861384797", "内蒙古鄂尔多斯市",
"861334841", "福建省宁德市",
"861889216", "陕西省汉中市",
"861837908", "江西省宜春市",
"861329679", "浙江省嘉兴市",
"861830970", "青海省海北藏族自治州",
"86145498", "浙江省湖州市",
"861453682", "陕西省西安市",
"861314045", "河南省开封市",
"861318341", "四川省达州市",
"861363493", "辽宁省朝阳市",
"861325374", "河南省许昌市",
"861580956", "宁夏中卫市",
"861522048", "广东省河源市",
"86183322", "河北省石家庄市",
"861327767", "湖北省武汉市",
"861392255", "广东省清远市",
"86151511", "江苏省宿迁市",
"861570540", "山东省菏泽市",
"861355047", "四川省巴中市",
"861305306", "安徽省合肥市",
"861301213", "河北省邢台市",
"861588689", "新疆喀什地区",
"86131662", "上海市",
"861376058", "广东省揭阳市",
"861590676", "浙江省台州市",
"861776705", "浙江省杭州市",
"861551438", "河南省郑州市",
"861321926", "四川省广安市",
"86139850", "贵州省贵阳市",
"861366404", "内蒙古乌兰察布市",
"861708397", "河南省信阳市",
"861330371", "河南省郑州市",
"861321745", "湖南省怀化市",
"861892266", "广东省云浮市",
"861818940", "甘肃省武威市",
"861530385", "河南省洛阳市",
"861809702", "青海省海东地区",
"861860907", "新疆阿克苏地区",
"861769127", "陕西省宝鸡市",
"861594639", "黑龙江省哈尔滨市",
"861345360", "山西省晋城市",
"861322092", "山东省烟台市",
"861595401", "山东省日照市",
"861576831", "广东省汕头市",
"861823242", "河北省承德市",
"86152583", "浙江省宁波市",
"861317764", "江西省萍乡市",
"861339018", "辽宁省本溪市",
"861477086", "江西省九江市",
"861585049", "江苏省南通市",
"861535978", "福建省莆田市",
"861700972", "浙江省嘉兴市",
"861323328", "山西省晋城市",
"861892159", "江苏省镇江市",
"861882741", "湖北省武汉市",
"86138303", "甘肃省平凉市",
"86133187", "广东省广州市",
"861800876", "云南省文山壮族苗族自治州",
"86151108", "山西省朔州市",
"861807691", "西藏拉萨市",
"861337885", "云南省昆明市",
"861820804", "西藏林芝地区",
"861520554", "安徽省淮南市",
"861399457", "山西省晋中市",
"861893131", "河北省张家口市",
"861779080", "辽宁省鞍山市",
"861375161", "广东省阳江市",
"861323849", "内蒙古锡林郭勒盟",
"861317081", "江西省赣州市",
"861890306", "广东省广州市",
"86137818", "河南省平顶山市",
"861530696", "福建省泉州市",
"861319769", "广西北海市",
"861869358", "甘肃省兰州市",
"861865237", "江苏省泰州市",
"86185582", "浙江省嘉兴市",
"861502081", "山东省泰安市",
"861317677", "山东省济宁市",
"861572889", "广东省惠州市",
"861479665", "江西省吉安市",
"861768231", "浙江省杭州市",
"861599295", "广东省韶关市",
"861837491", "湖南省岳阳市",
"86152951", "江苏省常州市",
"86170937", "河南省郑州市",
"861770643", "浙江省杭州市",
"861395942", "福建省宁德市",
"861857813", "广东省湛江市",
"861320101", "新疆昌吉回族自治州",
"861331790", "江西省新余市",
"861452733", "湖南省株洲市",
"861532477", "河南省南阳市",
"861350142", "广东省潮州市",
"861450620", "黑龙江省齐齐哈尔市",
"861890990", "新疆克拉玛依市",
"86189691", "浙江省杭州市",
"861333708", "内蒙古巴彦淖尔市",
"861371714", "广东省深圳市",
"861700339", "河北省邯郸市",
"861335104", "黑龙江省双鸭山市",
"861571997", "新疆巴音郭楞蒙古自治州",
"861761415", "辽宁省丹东市",
"861367535", "山东省烟台市",
"86151326", "河北省廊坊市",
"861476108", "江苏省常州市",
"861595998", "福建省泉州市",
"861780502", "江苏省镇江市",
"861321043", "山东省临沂市",
"861804346", "吉林省吉林市",
"86180658", "福建省三明市",
"86180934", "甘肃省庆阳市",
"861510557", "安徽省宿州市",
"861776003", "四川省成都市",
"861374017", "上海市",
"861804839", "内蒙古鄂尔多斯市",
"861874031", "陕西省延安市",
"861381369", "江苏省常州市",
"861478346", "河南省南阳市",
"86186270", "湖北省武汉市",
"861761450", "黑龙江省哈尔滨市",
"861846389", "山东省临沂市",
"86170028", "四川省成都市",
"861327674", "浙江省宁波市",
"861861393", "湖南省张家界市",
"861831989", "广东省清远市",
"861390391", "河南省焦作市",
"861458563", "山东省枣庄市",
"86159337", "河北省保定市",
"861700846", "浙江省绍兴市",
"861375493", "山西省大同市",
"86150380", "河南省郑州市",
"861844563", "黑龙江省黑河市",
"861381524", "江苏省南通市",
"86180355", "山西省长治市",
"861835801", "浙江省金华市",
"861390789", "广西北海市",
"861562400", "山东省青岛市",
"861840860", "宁夏中卫市",
"861327604", "福建省福州市",
"86186277", "湖北省武汉市",
"861834992", "四川省成都市",
"861335724", "湖南省衡阳市",
"86187116", "湖南省常德市",
"861889044", "湖南省岳阳市",
"86183369", "河南省商丘市",
"861561914", "陕西省商洛市",
"861361797", "江西省赣州市",
"861562470", "内蒙古呼伦贝尔市",
"861894339", "吉林省松原市",
"861370099", "四川省宜宾市",
"86138775", "广西玉林市",
"86150387", "河南省南阳市",
"861567237", "湖北省咸宁市",
"861372204", "内蒙古呼和浩特市",
"861375553", "江西省萍乡市",
"86180349", "山西省朔州市",
"861509784", "河北省邯郸市",
"861776822", "江苏省盐城市",
"861829523", "宁夏吴忠市",
"861894846", "广东省梅州市",
"861335174", "黑龙江省大庆市",
"861535491", "内蒙古包头市",
"861763508", "山西省晋城市",
"861353626", "广东省惠州市",
"86189984", "广东省广州市",
"861810877", "云南省玉溪市",
"861310255", "河北省邢台市",
"861528528", "贵州省黔东南苗族侗族自治州",
"861351821", "四川省成都市",
"861327382", "河南省商丘市",
"861780572", "浙江省湖州市",
"861594984", "山东省威海市",
"861350613", "江苏省苏州市",
"86152319", "河北省邢台市",
"861842050", "广东省汕头市",
"86170930", "山西省太原市",
"861399597", "湖北省黄石市",
"861876043", "福建省福州市",
"861880542", "山东省青岛市",
"861340816", "四川省绵阳市",
"861377873", "四川省遂宁市",
"861317607", "山东省临沂市",
"861362698", "福建省宁德市",
"861333778", "江苏省泰州市",
"861513541", "山西省晋中市",
"861768800", "广东省汕头市",
"861532407", "河北省张家口市",
"861346776", "湖南省衡阳市",
"861810159", "江苏省南京市",
"861500556", "安徽省安庆市",
"86133180", "广东省汕头市",
"861842015", "广东省深圳市",
"861454202", "河南省郑州市",
"861530238", "广东省广州市",
"861705232", "重庆市",
"861320721", "湖北省宜昌市",
"861332261", "广东省东莞市",
"861890376", "河南省信阳市",
"861344854", "山东省济南市",
"861537801", "甘肃省武威市",
"861853830", "河南省郑州市",
"861315307", "山东省菏泽市",
"861348809", "陕西省汉中市",
"861595471", "山东省济宁市",
"861831634", "广东省阳江市",
"861550717", "湖北省黄冈市",
"86150964", "云南省楚雄彝族自治州",
"86188698", "云南省大理白族自治州",
"861570373", "河南省新乡市",
"861350994", "广东省广州市",
"861535908", "福建省三明市",
"861700902", "山西省太原市",
"861769707", "青海省海西蒙古族藏族自治州",
"86133636", "河北省廊坊市",
"86134196", "湖北省武汉市",
"861561693", "湖南省娄底市",
"861595565", "安徽省合肥市",
"861596046", "福建省宁德市",
"861839740", "湖南省衡阳市",
"861808819", "云南省德宏傣族景颇族自治州",
"861330301", "河北省石家庄市",
"861386157", "江苏省淮安市",
"861366474", "内蒙古呼和浩特市",
"861801434", "江苏省常州市",
"861770850", "贵州省贵阳市",
"861369500", "福建省厦门市",
"86181711", "湖北省武汉市",
"861328042", "山东省临沂市",
"861860977", "青海省海西蒙古族藏族自治州",
"861809772", "新疆石河子市",
"86188395", "河南省漯河市",
"861301924", "吉林省吉林市",
"861534446", "湖南省永州市",
"861551782", "河南省开封市",
"861868653", "吉林省长春市",
"861592557", "云南省保山市",
"861521134", "湖南省常德市",
"861760947", "甘肃省嘉峪关市",
"861521817", "广东省阳江市",
"861709742", "广东省广州市",
"861363553", "安徽省芜湖市",
"861826268", "江苏省苏州市",
"86130139", "江苏省徐州市",
"861830396", "河南省驻马店市",
"861780893", "西藏山南地区",
"861876745", "浙江省温州市",
"861802377", "广东省云浮市",
"861374951", "河南省焦作市",
"861472685", "四川省广元市",
"861577548", "四川省南充市",
"861829093", "新疆阿勒泰地区",
"861370529", "江苏省镇江市",
"861339577", "浙江省温州市",
"861539205", "福建省福州市",
"86182783", "广西桂林市",
"861364524", "江苏省宿迁市",
"861887049", "江西省赣州市",
"861842713", "湖北省黄冈市",
"861591149", "云南省丽江市",
"861529422", "甘肃省兰州市",
"86133802", "广东省佛山市",
"861830900", "新疆巴音郭楞蒙古自治州",
"861598447", "四川省宜宾市",
"861353638", "广东省湛江市",
"861364369", "山西省太原市",
"86185516", "江苏省南京市",
"861377936", "新疆哈密地区",
"86136520", "天津市",
"86145237", "重庆市",
"861553352", "河北省秦皇岛市",
"861800766", "广东省云浮市",
"861875124", "江苏省连云港市",
"861368567", "安徽省阜阳市",
"861760695", "云南省德宏傣族景颇族自治州",
"861329154", "浙江省嘉兴市",
"861536898", "云南省大理白族自治州",
"861858181", "四川省达州市",
"861318712", "湖南省永州市",
"861877426", "湖南省郴州市",
"861539089", "江西省南昌市",
"861319879", "四川省内江市",
"861535002", "江西省九江市",
"861361638", "山东省聊城市",
"861700008", "上海市",
"861590264", "贵州省安顺市",
"861821952", "广东省深圳市",
"861568487", "新疆喀什地区",
"861351553", "安徽省芜湖市",
"861773148", "河北省唐山市",
"861571813", "广东省东莞市",
"86177738", "湖南省娄底市",
"861559542", "宁夏银川市",
"861829851", "甘肃省临夏回族自治州",
"86132682", "广东省广州市",
"861888810", "江苏省盐城市",
"86134769", "湖北省咸宁市",
"861529287", "新疆乌鲁木齐市",
"861323414", "辽宁省本溪市",
"861396543", "安徽省合肥市",
"861510374", "河南省许昌市",
"861328948", "陕西省榆林市",
"861879097", "河南省濮阳市",
"861771375", "四川省泸州市",
"861857997", "广西北海市",
"86130679", "浙江省杭州市",
"861881475", "黑龙江省佳木斯市",
"861319157", "内蒙古乌兰察布市",
"861813431", "河北省保定市",
"861806217", "湖北省十堰市",
"861343551", "广东省河源市",
"861362737", "湖南省益阳市",
"861847128", "湖北省荆门市",
"861580432", "吉林省吉林市",
"861531416", "山东省聊城市",
"861365445", "吉林省吉林市",
"861558279", "山西省吕梁市",
"861454651", "云南省昆明市",
"861352985", "云南省曲靖市",
"861310363", "河南省濮阳市",
"86183581", "浙江省杭州市",
"861807040", "江西省南昌市",
"861550044", "吉林省四平市",
"861890599", "福建省南平市",
"861385241", "江苏省泰州市",
"86151563", "安徽省宣城市",
"861538344", "山西省晋中市",
"861892674", "广东省茂名市",
"861881561", "安徽省淮北市",
"861300755", "河南省洛阳市",
"861814986", "新疆巴音郭楞蒙古自治州",
"861396300", "山东省聊城市",
"861700517", "江苏省淮安市",
"861520377", "河南省南阳市",
"861782861", "四川省广安市",
"861313417", "辽宁省营口市",
"86181998", "新疆乌鲁木齐市",
"861471849", "广东省肇庆市",
"861581895", "广东省珠海市",
"861566086", "河南省新乡市",
"861880533", "山东省淄博市",
"861836249", "江苏省宿迁市",
"861827210", "湖北省孝感市",
"861522485", "河南省南阳市",
"861475562", "安徽省合肥市",
"861458792", "湖南省张家界市",
"861322471", "内蒙古包头市",
"861884587", "黑龙江省哈尔滨市",
"86130233", "江苏省无锡市",
"861847136", "湖北省咸宁市",
"861369979", "广东省深圳市",
"861313649", "浙江省台州市",
"861366397", "河南省信阳市",
"861514568", "黑龙江省黑河市",
"861508146", "河北省廊坊市",
"861804258", "浙江省金华市",
"86151733", "湖南省株洲市",
"861322565", "安徽省合肥市",
"861826047", "江苏省无锡市",
"86177804", "四川省成都市",
"861342539", "广东省肇庆市",
"861827255", "河南省安阳市",
"861379140", "山东省枣庄市",
"86183953", "安徽省宣城市",
"861865178", "江苏省徐州市",
"86130596", "浙江省丽水市",
"861583381", "河北省唐山市",
"861314488", "广东省东莞市",
"861308981", "黑龙江省双鸭山市",
"861470913", "陕西省渭南市",
"861512197", "宁夏银川市",
"861879527", "宁夏银川市",
"861830579", "浙江省金华市",
"861822556", "安徽省安庆市",
"861877438", "湖南省常德市",
"861325557", "山东省青岛市",
"861389731", "青海省海东地区",
"861305599", "福建省南平市",
"861805273", "江苏省常州市",
"861552558", "山西省晋中市",
"861336145", "山东省潍坊市",
"861820607", "福建省厦门市",
"861377928", "新疆和田地区",
"86187807", "四川省南充市",
"861760386", "河南省郑州市",
"861567108", "湖北省荆门市",
"86185321", "河北省石家庄市",
"861564944", "河南省开封市",
"86186424", "辽宁省本溪市",
"861353797", "广东省阳江市",
"861348769", "湖南省益阳市",
"861537084", "江苏省南通市",
"861898537", "贵州省六盘水市",
"86177568", "安徽省阜阳市",
"861317874", "广东省梅州市",
"861570949", "甘肃省陇南市",
"861869246", "湖南省益阳市",
"861772412", "广东省揭阳市",
"861816044", "新疆喀什地区",
"86137320", "浙江省温州市",
"861802494", "广东省佛山市",
"86186988", "辽宁省沈阳市",
"861560720", "湖北省宜昌市",
"861336976", "青海省西宁市",
"86138929", "陕西省咸阳市",
"86136093", "甘肃省兰州市",
"861327159", "河南省郑州市",
"861864886", "广西柳州市",
"86134539", "山西省运城市",
"861859443", "福建省宁德市",
"861453497", "内蒙古赤峰市",
"86181296", "广东省惠州市",
"861815863", "浙江省台州市",
"86137327", "云南省曲靖市",
"861867019", "江西省萍乡市",
"861459347", "四川省凉山彝族自治州",
"861339354", "山西省晋中市",
"861571645", "河南省三门峡市",
"861853393", "河北省邯郸市",
"861803918", "河南省焦作市",
"861317804", "福建省泉州市",
"861820081", "广东省阳江市",
"86134722", "河北省保定市",
"861780421", "辽宁省朝阳市",
"861336906", "新疆阿勒泰地区",
"86181533", "湖南省永州市",
"861776865", "江苏省镇江市",
"861360749", "湖南省长沙市",
"861521993", "广东省中山市",
"861801961", "江苏省盐城市",
"861359965", "福建省漳州市",
"861870430", "吉林省长春市",
"861518147", "四川省南充市",
"861333544", "陕西省汉中市",
"861830509", "浙江省湖州市",
"861530859", "贵州省黔西南布依族苗族自治州",
"861476237", "江苏省泰州市",
"861567178", "湖北省黄石市",
"861809862", "安徽省芜湖市",
"861341990", "河南省南阳市",
"86187800", "四川省成都市",
"86145026", "内蒙古包头市",
"861780917", "陕西省宝鸡市",
"861335659", "广东省江门市",
"861859956", "福建省漳州市",
"861317196", "河北省秦皇岛市",
"861379395", "山东省东营市",
"861896558", "福建省莆田市",
"861853652", "山西省晋中市",
"861521546", "山东省东营市",
"861563367", "河北省石家庄市",
"861529958", "新疆阿克苏地区",
"861536734", "湖南省衡阳市",
"861530727", "湖北省襄樊市",
"861780330", "河北省邯郸市",
"861315494", "四川省眉山市",
"861856304", "山东省潍坊市",
"861865108", "江苏省南通市",
"861770632", "山东省枣庄市",
"861398688", "湖北省十堰市",
"861528144", "四川省宜宾市",
"86139283", "广东省惠州市",
"861452742", "湖南省湘潭市",
"861870321", "河北省石家庄市",
"861311713", "湖北省恩施土家族苗族自治州",
"861560413", "辽宁省抚顺市",
"861893588", "新疆伊犁哈萨克自治州",
"861708474", "内蒙古呼和浩特市",
"861354187", "四川省广安市",
"86189741", "湖南省株洲市",
"861812599", "广东省清远市",
"861866793", "浙江省杭州市",
"861538480", "内蒙古呼伦贝尔市",
"86155716", "湖北省荆州市",
"861572937", "河南省郑州市",
"861306800", "山西省太原市",
"861812029", "湖北省孝感市",
"861803460", "甘肃省庆阳市",
"861776162", "河南省南阳市",
"861840770", "广西南宁市",
"861800048", "河北省张家口市",
"86150376", "河南省信阳市",
"861351161", "江苏省苏州市",
"86183878", "云南省楚雄彝族自治州",
"861356663", "浙江省宁波市",
"861593311", "河北省石家庄市",
"86137468", "黑龙江省佳木斯市",
"861894517", "黑龙江省鹤岗市",
"861823233", "河北省张家口市",
"861338560", "安徽省合肥市",
"861580788", "广西河池市",
"861881405", "广东省惠州市",
"861522942", "陕西省榆林市",
"861558209", "山西省吕梁市",
"861890459", "黑龙江省大庆市",
"861860512", "江苏省苏州市",
"861477191", "湖北省荆州市",
"861588193", "四川省遂宁市",
"861810767", "广东省汕尾市",
"861353118", "广东省汕头市",
"861885780", "浙江省丽水市",
"861309269", "江苏省镇江市",
"861457116", "湖北省黄冈市",
"861555997", "云南省曲靖市",
"861355714", "广西梧州市",
"861709966", "浙江省金华市",
"861875704", "浙江省衢州市",
"861831837", "广东省云浮市",
"861800933", "甘肃省平凉市",
"861883077", "河北省保定市",
"861303416", "甘肃省白银市",
"861340547", "山东省济宁市",
"86158548", "山东省泰安市",
"861329585", "浙江省绍兴市",
"861300423", "浙江省嘉兴市",
"861311050", "福建省福州市",
"861346618", "云南省普洱市",
"861899787", "新疆阿克苏地区",
"861304243", "辽宁省沈阳市",
"861339912", "陕西省榆林市",
"861332730", "湖南省岳阳市",
"861843406", "山西省临汾市",
"861529465", "河南省安阳市",
"861337359", "河北省唐山市",
"861331811", "广东省肇庆市",
"861820764", "广东省广州市",
"861351493", "安徽省阜阳市",
"861309156", "黑龙江省绥化市",
"861535072", "河北省承德市",
"861315882", "四川省自贡市",
"86188124", "河南省新乡市",
"86130415", "江苏省常州市",
"86138556", "安徽省安庆市",
"861319809", "四川省绵阳市",
"861304401", "山东省泰安市",
"861810419", "辽宁省辽阳市",
"861519541", "江苏省淮安市",
"861309334", "安徽省阜阳市",
"861339778", "广西河池市",
"861520480", "内蒙古鄂尔多斯市",
"861855510", "安徽省滁州市",
"861898697", "湖北省荆门市",
"861538307", "河北省沧州市",
"861340483", "内蒙古呼和浩特市",
"861524196", "辽宁省辽阳市",
"861500346", "山西省太原市",
"861529820", "四川省南充市",
"861335439", "吉林省白山市",
"861870615", "江苏省无锡市",
"861358711", "浙江省衢州市",
"861320560", "安徽省合肥市",
"861334601", "浙江省嘉兴市",
"861386649", "安徽省宿州市",
"861570031", "四川省广安市",
"861775707", "浙江省宁波市",
"861351979", "青海省海西蒙古族藏族自治州",
"861321292", "黑龙江省哈尔滨市",
"861372068", "陕西省榆林市",
"861761473", "内蒙古乌海市",
"861880352", "山西省大同市",
"861452662", "江西省九江市",
"861855555", "安徽省马鞍山市",
"861585464", "山东省威海市",
"86150987", "山东省济南市",
"861770452", "黑龙江省齐齐哈尔市",
"861521248", "安徽省六安市",
"861390441", "吉林省吉林市",
"861883044", "河北省承德市",
"861378796", "湖南省张家界市",
"86183969", "贵州省毕节地区",
"861337940", "陕西省咸阳市",
"861571765", "河北省廊坊市",
"861340574", "江苏省南通市",
"86159930", "河南省新乡市",
"861380009", "广东省广州市",
"861768853", "广东省深圳市",
"86177223", "广东省东莞市",
"86151502", "江苏省苏州市",
"861556647", "辽宁省葫芦岛市",
"861893286", "河北省承德市",
"861517013", "江西省新余市",
"861471585", "广东省江门市",
"861853432", "山西省运城市",
"861370858", "贵州省六盘水市",
"861594990", "山东省淄博市",
"861591657", "广东省佛山市",
"861512972", "陕西省榆林市",
"861880693", "云南省迪庆藏族自治州",
"861374664", "黑龙江省绥化市",
"861769508", "宁夏银川市",
"861842003", "广东省东莞市",
"861562946", "湖北省荆州市",
"861550518", "江苏省徐州市",
"861360669", "浙江省丽水市",
"861353922", "广东省惠州市",
"861525141", "江苏省无锡市",
"861573869", "河南省许昌市",
"861590902", "新疆哈密地区",
"86157614", "贵州省毕节地区",
"861818885", "广东省深圳市",
"861556419", "山东省烟台市",
"861563658", "黑龙江省七台河市",
"86183506", "福建省漳州市",
"861890639", "山东省青岛市",
"861369553", "安徽省芜湖市",
"861816007", "四川省泸州市",
"861782011", "广东省茂名市",
"861850799", "江西省萍乡市",
"86151559", "安徽省合肥市",
"861555102", "安徽省滁州市",
"861351332", "河北省保定市",
"861377643", "江苏省扬州市",
"86132215", "浙江省绍兴市",
"861561542", "山东省青岛市",
"861566688", "山东省潍坊市",
"861399798", "湖北省武汉市",
"861323609", "江苏省南通市",
"861523422", "山西省大同市",
"861479032", "安徽省六安市",
"861820644", "山东省潍坊市",
"86132831", "河北省邯郸市",
"861705565", "辽宁省大连市",
"861327995", "新疆吐鲁番地区",
"861553533", "山西省阳泉市",
"861322243", "江苏省南京市",
"861374777", "内蒙古鄂尔多斯市",
"861318491", "河北省唐山市",
"861333577", "浙江省温州市",
"861363343", "山西省临汾市",
"861821899", "广东省惠州市",
"861830953", "宁夏吴忠市",
"861501507", "广东省韶关市",
"861301275", "山东省莱芜市",
"86181745", "湖南省怀化市",
"861534970", "青海省西宁市",
"861318163", "山东省烟台市",
"861860751", "广东省韶关市",
"861350980", "广东省东莞市",
"861528727", "云南省丽江市",
"86158021", "上海市",
"86130728", "四川省成都市",
"861880914", "陕西省商洛市",
"861586290", "江苏省连云港市",
"861805441", "山东省潍坊市",
"861470534", "山东省德州市",
"861476527", "河南省郑州市",
"861361598", "福建省莆田市",
"861803772", "河南省商丘市",
"861515969", "福建省漳州市",
"861302750", "河南省郑州市",
"861530144", "江苏省扬州市",
"861840462", "黑龙江省七台河市",
"861782288", "贵州省六盘水市",
"861816518", "陕西省渭南市",
"861521479", "浙江省台州市",
"861760535", "山东省烟台市",
"861803702", "河南省焦作市",
"86153706", "江苏省南通市",
"861562802", "贵州省黔南布依族苗族自治州",
"86181759", "湖南省邵阳市",
"861367262", "广东省云浮市",
"861331061", "山东省济南市",
"861566511", "江苏省镇江市",
"861363570", "湖北省十堰市",
"861534396", "河南省驻马店市",
"861700676", "浙江省宁波市",
"861301205", "河北省保定市",
"861379211", "山东省泰安市",
"861824882", "江苏省常州市",
"861510758", "广东省肇庆市",
"861361458", "黑龙江省伊春市",
"861454320", "内蒙古呼和浩特市",
"861580393", "河南省濮阳市",
"861534900", "甘肃省嘉峪关市",
"861327844", "吉林省四平市",
"861829242", "陕西省榆林市",
"861459682", "新疆克拉玛依市",
"861570350", "山西省忻州市",
"861537641", "山东省济南市",
"861502847", "河北省邯郸市",
"861323679", "辽宁省葫芦岛市",
"861453986", "广东省清远市",
"86151545", "山东省烟台市",
"861359296", "广东省茂名市",
"861376899", "广西玉林市",
"861533275", "内蒙古通辽市",
"861312441", "河南省安阳市",
"861341119", "广东省广州市",
"861800646", "山东省潍坊市",
"86133164", "广东省深圳市",
"86135429", "广东省肇庆市",
"861598397", "四川省巴中市",
"861768640", "山东省济南市",
"861813651", "江苏省南通市",
"861354731", "四川省巴中市",
"861368878", "云南省丽江市",
"861330735", "湖南省郴州市",
"861570315", "河北省唐山市",
"861590972", "青海省海东地区",
"861317847", "广东省清远市",
"861801109", "四川省凉山彝族自治州",
"861564977", "河南省三门峡市",
"861555172", "安徽省芜湖市",
"861816077", "江西省赣州市",
"861770873", "云南省红河哈尼族彝族自治州",
"861454431", "江苏省苏州市",
"86183922", "陕西省榆林市",
"861459304", "四川省自贡市",
"861539924", "陕西省咸阳市",
"861891935", "甘肃省武威市",
"861807188", "湖北省荆州市",
"861532819", "四川省成都市",
"861537929", "甘肃省武威市",
"861535341", "陕西省延安市",
"861824494", "广东省广州市",
"861388244", "四川省雅安市",
"86151926", "山东省青岛市",
"861819964", "新疆阿勒泰地区",
"861770592", "福建省厦门市",
"861834238", "辽宁省葫芦岛市",
"861804556", "黑龙江省哈尔滨市",
"86180955", "宁夏中卫市",
"861510347", "山西省临汾市",
"861306521", "辽宁省铁岭市",
"861872435", "黑龙江省绥化市",
"86159937", "河南省焦作市",
"861380079", "江西省新余市",
"861778741", "云南省曲靖市",
"86133811", "北京市",
"861857805", "广东省韶关市",
"861313769", "河南省周口市",
"861350675", "浙江省绍兴市",
"861351909", "甘肃省陇南市",
"861550681", "广西南宁市",
"861329849", "河南省三门峡市",
"861334671", "河南省平顶山市",
"861327568", "安徽省阜阳市",
"861773080", "河南省安阳市",
"861596567", "山东省菏泽市",
"861530992", "新疆伊犁哈萨克自治州",
"861534685", "甘肃省武威市",
"861776015", "四川省巴中市",
"861871919", "广东省惠州市",
"861378824", "广西梧州市",
"861777529", "安徽省芜湖市",
"861809012", "四川省甘孜藏族自治州",
"86135886", "浙江省金华市",
"861779094", "辽宁省沈阳市",
"86138903", "四川省眉山市",
"861339708", "江西省南昌市",
"861331784", "广西梧州市",
"86181702", "江西省九江市",
"861520344", "山西省晋中市",
"861590846", "四川省泸州市",
"861304471", "河南省郑州市",
"861375570", "江西省新余市",
"86159028", "四川省成都市",
"861890984", "辽宁省大连市",
"86152351", "山西省太原市",
"861593295", "江西省抚州市",
"861538377", "河北省沧州市",
"861568543", "贵州省安顺市",
"861586620", "山东省临沂市",
"861473665", "云南省昭通市",
"861334087", "四川省德阳市",
"861350589", "浙江省金华市",
"861847018", "江西省赣州市",
"861805250", "江苏省常州市",
"861534579", "浙江省金华市",
"861398463", "贵州省六盘水市",
"861560153", "江苏省无锡市",
"861519620", "四川省阿坝藏族羌族自治州",
"861569367", "甘肃省白银市",
"861315480", "内蒙古呼和浩特市",
"861859652", "福建省泉州市",
"861373395", "河南省漯河市",
"861853956", "河南省郑州市",
"861569426", "辽宁省锦州市",
"861307008", "新疆和田地区",
"861340748", "湖南省娄底市",
"861365686", "浙江省台州市",
"861862687", "浙江省杭州市",
"861550469", "黑龙江省双鸭山市",
"861328301", "河南省周口市",
"861860944", "甘肃省兰州市",
"86156024", "广东省深圳市",
"861899588", "湖北省宜昌市",
"861568532", "贵州省遵义市",
"861770936", "甘肃省张掖市",
"861560886", "云南省怒江傈僳族自治州",
"861856986", "河南省郑州市",
"861364234", "广东省深圳市",
"861879963", "新疆博尔塔拉蒙古自治州",
"861366447", "吉林省白城市",
"861897243", "湖北省恩施土家族苗族自治州",
"861452625", "江苏省南通市",
"861471609", "广东省中山市",
"861580587", "浙江省温州市",
"861508913", "广东省汕头市",
"861470975", "青海省西宁市",
"861580201", "广东省广州市",
"861781686", "浙江省杭州市",
"861536429", "湖南省郴州市",
"861558398", "四川省眉山市",
"861802344", "广东省中山市",
"861810568", "安徽省阜阳市",
"861825743", "浙江省宁波市",
"86134544", "浙江省杭州市",
"861859393", "广西桂林市",
"861760974", "青海省海南藏族自治州",
"861380326", "河北省保定市",
"861333354", "山西省晋中市",
"861571722", "湖北省武汉市",
"86137927", "山东省威海市",
"861847507", "广东省肇庆市",
"861598474", "四川省甘孜藏族自治州",
"86156657", "山东省济南市",
"8618996", "重庆市",
"861530536", "山东省潍坊市",
"861538882", "云南省德宏傣族景颇族自治州",
"861318072", "吉林省白山市",
"861341984", "河南省三门峡市",
"861459557", "青海省海西蒙古族藏族自治州",
"861339544", "山东省德州市",
"861318823", "辽宁省本溪市",
"86158626", "江苏省苏州市",
"861311705", "湖北省荆门市",
"861828900", "西藏拉萨市",
"861861788", "河北省唐山市",
"861334323", "河北省石家庄市",
"861339868", "河北省承德市",
"861337549", "山东省临沂市",
"861876665", "山东省泰安市",
"86188852", "贵州省遵义市",
"861323585", "浙江省绍兴市",
"861582916", "陕西省商洛市",
"86138362", "黑龙江省齐齐哈尔市",
"861867709", "广西南宁市",
"861380338", "河北省秦皇岛市",
"861384922", "河南省鹤壁市",
"861709662", "浙江省嘉兴市",
"861309416", "湖北省宜昌市",
"861310141", "福建省福州市",
"86130441", "上海市",
"861816469", "云南省楚雄彝族自治州",
"861390250", "广东省湛江市",
"861572545", "山东省烟台市",
"86187871", "云南省昆明市",
"861324703", "江西省上饶市",
"861339616", "湖北省荆门市",
"86184440", "吉林省吉林市",
"861306853", "广东省茂名市",
"86135870", "浙江省舟山市",
"861881413", "广东省广州市",
"861335147", "黑龙江省大兴安岭地区",
"861705522", "天津市",
"861530528", "江苏省镇江市",
"861340357", "山西省临汾市",
"861333912", "安徽省铜陵市",
"861775206", "甘肃省平凉市",
"86157788", "广西南宁市",
"861700197", "广东省广州市",
"861379982", "福建省漳州市",
"861375909", "云南省玉溪市",
"861825045", "福建省福州市",
"861538494", "新疆喀什地区",
"861803165", "河北省秦皇岛市",
"861811699", "新疆石河子市",
"861565129", "江苏省宿迁市",
"861835520", "安徽省阜阳市",
"861301089", "广东省深圳市",
"86159496", "江西省吉安市",
"861894264", "河北省石家庄市",
"861571875", "云南省保山市",
"861593662", "河南省漯河市",
"861353458", "广东省佛山市",
"861809460", "浙江省嘉兴市",
"861338721", "湖北省襄樊市",
"861868433", "吉林省延边朝鲜族自治州",
"861367386", "河南省周口市",
"861871495", "安徽省黄山市",
"8614775", "广东省广州市",
"861368923", "陕西省渭南市",
"861569438", "吉林省松原市",
"861351570", "浙江省衢州市",
"861814374", "甘肃省庆阳市",
"861365395", "河南省漯河市",
"861340935", "河南省许昌市",
"861320969", "宁夏银川市",
"861700264", "广东省深圳市",
"861885826", "浙江省杭州市",
"86771", "广西南宁市",
"861588513", "贵州省黔东南苗族侗族自治州",
"861311073", "福建省泉州市",
"861353598", "广东省清远市",
"861500987", "辽宁省营口市",
"861569782", "江西省九江市",
"861319921", "黑龙江省双鸭山市",
"861565709", "浙江省舟山市",
"861528696", "河南省安阳市",
"861334252", "湖南省湘潭市",
"86184652", "宁夏银川市",
"861351500", "福建省福州市",
"861452295", "山西省长治市",
"861538554", "安徽省淮南市",
"861889518", "宁夏银川市",
"861311822", "四川省遂宁市",
"861367225", "江西省九江市",
"861381234", "江苏省连云港市",
"861810995", "新疆吐鲁番地区",
"86181398", "甘肃省张掖市",
"86177129", "江苏省徐州市",
"861814682", "陕西省西安市",
"861532444", "安徽省淮南市",
"861319417", "辽宁省营口市",
"861325758", "广东省肇庆市",
"861772855", "广东省江门市",
"861775276", "湖南省衡阳市",
"861879728", "青海省海南藏族自治州",
"86158142", "广东省东莞市",
"861317644", "山东省济南市",
"861871555", "安徽省马鞍山市",
"861304092", "湖北省荆州市",
"861872983", "陕西省渭南市",
"861778954", "甘肃省平凉市",
"861808069", "四川省达州市",
"86145847", "山东省青岛市",
"861527045", "江西省吉安市",
"861557919", "江西省上饶市",
"861506299", "江苏省泰州市",
"861878861", "贵州省遵义市",
"861533089", "辽宁省丹东市",
"861351343", "河北省保定市",
"86135877", "浙江省温州市",
"861561533", "山东省淄博市",
"861875246", "江苏省南通市",
"861372247", "河北省沧州市",
"861324773", "江西省上饶市",
"861457038", "广东省汕头市",
"861840753", "广东省梅州市",
"861523501", "山西省忻州市",
"861362526", "江苏省镇江市",
"861571486", "内蒙古赤峰市",
"861768521", "贵州省遵义市",
"861363332", "河北省保定市",
"861327647", "山东省东营市",
"861326495", "湖北省荆门市",
"861318002", "河北省张家口市",
"86131778", "江西省南昌市",
"861392141", "江苏省南京市",
"861511399", "广东省潮州市",
"86156650", "黑龙江省绥化市",
"861598404", "四川省泸州市",
"86186685", "浙江省宁波市",
"861369821", "四川省攀枝花市",
"861847577", "广东省梅州市",
"861457026", "江西省吉安市",
"861360481", "黑龙江省哈尔滨市",
"861560475", "内蒙古通辽市",
"861311775", "广西玉林市",
"861869774", "河南省信阳市",
"861375332", "山西省阳泉市",
"861535712", "安徽省滁州市",
"861893362", "广东省梅州市",
"861700718", "湖北省荆州市",
"861336440", "吉林省吉林市",
"861327419", "辽宁省辽阳市",
"861802480", "广东省中山市",
"861808394", "新疆石河子市",
"861524218", "辽宁省朝阳市",
"861592986", "陕西省咸阳市",
"861853443", "山西省太原市",
"861355074", "四川省宜宾市",
"861362538", "山东省泰安市",
"86138329", "河北省唐山市",
"861380285", "广东省肇庆市",
"86186388", "河南省洛阳市",
"861470905", "新疆阿勒泰地区",
"861773234", "河北省张家口市",
"861760904", "新疆乌鲁木齐市",
"86150278", "河北省保定市",
"861306640", "广东省江门市",
"861560561", "安徽省淮北市",
"861311125", "山西省长治市",
"861580830", "四川省泸州市",
"86185921", "陕西省西安市",
"861774909", "陕西省铜川市",
"861319649", "江苏省扬州市",
"861328371", "河南省郑州市",
"861363979", "青海省海西蒙古族藏族自治州",
"861806848", "江苏省徐州市",
"861300000", "山东省济南市",
"86180892", "陕西省西安市",
"861508224", "四川省乐山市",
"861874291", "新疆石河子市",
"861898945", "浙江省杭州市",
"861885838", "浙江省舟山市",
"861352392", "河南省鹤壁市",
"861342183", "广东省深圳市",
"861882661", "广东省清远市",
"861898726", "云南省昆明市",
"861534509", "福建省龙岩市",
"861818359", "云南省曲靖市",
"861379445", "广东省深圳市",
"861586541", "山东省滨州市",
"861707423", "浙江省杭州市",
"86184609", "江西省南昌市",
"86183353", "山西省阳泉市",
"86187473", "内蒙古通辽市",
"861373140", "河北省承德市",
"861454964", "黑龙江省齐齐哈尔市",
"861317516", "浙江省宁波市",
"861479926", "新疆乌鲁木齐市",
"861770763", "广东省清远市",
"861479745", "山西省运城市",
"861505531", "安徽省芜湖市",
"861332888", "福建省泉州市",
"861589799", "湖北省襄樊市",
"861315344", "山东省枣庄市",
"861332433", "吉林省延边朝鲜族自治州",
"861329739", "湖南省邵阳市",
"861330142", "江苏省泰州市",
"861700527", "江苏省宿迁市",
"861313427", "辽宁省盘锦市",
"86183582", "浙江省宁波市",
"861362874", "云南省曲靖市",
"861813937", "新疆伊犁哈萨克自治州",
"861857491", "湖南省常德市",
"861351790", "江西省新余市",
"861300170", "山东省济南市",
"86189705", "江西省宜春市",
"861313911", "青海省海东地区",
"861516970", "山东省济宁市",
"861590736", "湖南省常德市",
"861531426", "山东省淄博市",
"861377460", "福建省福州市",
"861840584", "浙江省宁波市",
"861864070", "辽宁省辽阳市",
"861550696", "福建省漳州市",
"861557230", "湖北省武汉市",
"86135187", "云南省昆明市",
"861806227", "湖北省黄石市",
"861477760", "广西玉林市",
"861567197", "湖北省孝感市",
"861399744", "青海省海南藏族自治州",
"861313366", "江西省九江市",
"861355896", "四川省宜宾市",
"861820698", "云南省大理白族自治州",
"861594779", "内蒙古通辽市",
"86132681", "广东省广州市",
"86188819", "四川省宜宾市",
"861888820", "山东省德州市",
"86132012", "新疆乌鲁木齐市",
"861323424", "辽宁省辽阳市",
"861571072", "广东省广州市",
"861318172", "山东省济南市",
"86135254", "河南省洛阳市",
"86152323", "河北省秦皇岛市",
"861570611", "江苏省常州市",
"861571823", "广东省韶关市",
"861764040", "辽宁省大连市",
"861813355", "河北省唐山市",
"861877416", "湖南省湘潭市",
"861840473", "内蒙古乌海市",
"861538783", "江西省上饶市",
"861357406", "湖南省湘潭市",
"86184475", "内蒙古呼和浩特市",
"861803763", "河南省周口市",
"861390904", "四川省阿坝藏族羌族自治州",
"86135845", "江苏省常州市",
"861361544", "山东省烟台市",
"861366308", "河南省三门峡市",
"861839788", "江西省景德镇市",
"861537345", "河北省石家庄市",
"861368975", "吉林省白城市",
"861318722", "湖南省湘潭市",
"861393867", "河南省平顶山市",
"861335047", "四川省巴中市",
"861832046", "广东省茂名市",
"861311410", "云南省玉溪市",
"861586435", "山东省聊城市",
"861889727", "青海省玉树藏族自治州",
"861347393", "河北省唐山市",
"861361868", "湖北省宜昌市",
"861502737", "湖北省咸宁市",
"86159542", "山东省青岛市",
"861863837", "河南省信阳市",
"861303056", "江西省萍乡市",
"861895720", "浙江省舟山市",
"861310041", "广西南宁市",
"861325249", "浙江省台州市",
"861893621", "江苏省南通市",
"861377918", "新疆哈密地区",
"861363811", "贵州省铜仁地区",
"861850970", "青海省海北藏族自治州",
"861566870", "辽宁省盘锦市",
"861857908", "江西省抚州市",
"861354841", "四川省绵阳市",
"86180727", "浙江省杭州市",
"861869454", "浙江省嘉兴市",
"861311455", "黑龙江省绥化市",
"861879517", "宁夏银川市",
"861801285", "江苏省南通市",
"861317737", "湖北省鄂州市",
"861870733", "湖南省株洲市",
"86150520", "江苏省徐州市",
"86177476", "内蒙古赤峰市",
"861508567", "贵州省黔东南苗族侗族自治州",
"861811466", "江苏省徐州市",
"861874787", "内蒙古通辽市",
"861879008", "河南省信阳市",
"861501638", "广东省肇庆市",
"861872620", "安徽省安庆市",
"861322977", "广东省珠海市",
"861311103", "山西省晋中市",
"86170724", "辽宁省沈阳市",
"861308487", "陕西省汉中市",
"861534799", "江西省萍乡市",
"861785868", "浙江省台州市",
"861388636", "湖北省孝感市",
"861338071", "广东省清远市",
"861334375", "河南省平顶山市",
"861531438", "山东省临沂市",
"861590728", "湖北省十堰市",
"861565029", "山东省潍坊市",
"861825145", "江苏省盐城市",
"861534381", "河南省郑州市",
"861827220", "湖北省荆州市",
"861318875", "山东省聊城市",
"861350371", "河南省郑州市",
"86155339", "河北省石家庄市",
"861889859", "广东省深圳市",
"861589509", "江苏省淮安市",
"861512963", "陕西省商洛市",
"86151586", "浙江省温州市",
"861870966", "宁夏中卫市",
"86155944", "陕西省延安市",
"86189742", "湖南省常德市",
"861356833", "四川省自贡市",
"861536877", "云南省玉溪市",
"861591931", "广东省广州市",
"861569883", "辽宁省沈阳市",
"861779933", "新疆和田地区",
"861320342", "山西省大同市",
"861513655", "河南省驻马店市",
"861859740", "福建省三明市",
"861589579", "江苏省连云港市",
"861870311", "河北省石家庄市",
"861311723", "湖北省襄樊市",
"86186263", "江苏省无锡市",
"861560423", "辽宁省抚顺市",
"86139793", "江西省上饶市",
"861576489", "内蒙古乌兰察布市",
"861824448", "四川省广元市",
"861564243", "辽宁省朝阳市",
"861334305", "河北省唐山市",
"861313057", "辽宁省营口市",
"861370337", "河北省唐山市",
"861308265", "山东省临沂市",
"861330994", "新疆昌吉回族自治州",
"86135636", "山东省潍坊市",
"86150527", "江苏省宿迁市",
"861805974", "福建省莆田市",
"861573459", "黑龙江省大庆市",
"861569156", "陕西省安康市",
"861823689", "河南省焦作市",
"861322907", "河北省邢台市",
"861328589", "浙江省金华市",
"861774811", "四川省泸州市",
"861879078", "河南省安阳市",
"86156415", "辽宁省丹东市",
"86180720", "浙江省温州市",
"861866550", "广东省汕头市",
"86135802", "广东省揭阳市",
"861850900", "新疆博尔塔拉蒙古自治州",
"861838538", "贵州省安顺市",
"86137699", "云南省普洱市",
"861370910", "陕西省咸阳市",
"861779048", "四川省南充市",
"861707561", "安徽省芜湖市",
"861780927", "陕西省宝鸡市",
"861333638", "山东省烟台市",
"861786934", "云南省临沧市",
"861598754", "云南省文山壮族苗族自治州",
"86136376", "海南省海口市",
"861318486", "广东省汕尾市",
"861816238", "湖北省荆门市",
"861831667", "广东省清远市",
"861840852", "贵州省遵义市",
"861324872", "浙江省宁波市",
"86134721", "河北省石家庄市",
"861850396", "河南省驻马店市",
"861370955", "宁夏吴忠市",
"861520398", "河南省三门峡市",
"861867029", "湖南省郴州市",
"861533189", "黑龙江省齐齐哈尔市",
"861808169", "四川省成都市",
"861527145", "湖北省宜昌市",
"86147925", "安徽省阜阳市",
"861887582", "浙江省温州市",
"861801467", "江苏省盐城市",
"861869594", "河南省新乡市",
"86181786", "广西南宁市",
"861311595", "福建省泉州市",
"861331821", "广东省佛山市",
"861357476", "湖南省岳阳市",
"861816226", "江西省九江市",
"861839432", "甘肃省白银市",
"861390974", "青海省海南藏族自治州",
"861893291", "河北省石家庄市",
"861869024", "新疆哈密地区",
"861867599", "广东省湛江市",
"861330613", "江苏省苏州市",
"861303367", "浙江省嘉兴市",
"861339922", "陕西省榆林市",
"861366378", "河南省开封市",
"861333626", "山东省德州市",
"861380654", "浙江省温州市",
"861355174", "四川省攀枝花市",
"861384868", "内蒙古巴彦淖尔市",
"86159505", "江苏省南京市",
"861378399", "河南省开封市",
"861809632", "四川省遂宁市",
"861346628", "云南省红河哈尼族彝族自治州",
"861593430", "山西省忻州市",
"861594709", "内蒙古锡林郭勒盟",
"861850685", "浙江省杭州市",
"861378781", "湖南省株洲市",
"861768191", "浙江省金华市",
"861324593", "内蒙古巴彦淖尔市",
"86185369", "山西省晋中市",
"861355724", "广西梧州市",
"861326761", "广东省中山市",
"861303426", "浙江省绍兴市",
"86189373", "河南省新乡市",
"861599135", "陕西省咸阳市",
"861318102", "山东省滨州市",
"86137576", "浙江省台州市",
"86135859", "上海市",
"861358969", "山东省临沂市",
"861370468", "黑龙江省鸡西市",
"861860522", "江苏省扬州市",
"861557801", "广西南宁市",
"861373040", "河北省邯郸市",
"861894527", "黑龙江省大庆市",
"861324725", "湖北省荆门市",
"86135180", "海南省海口市",
"861324946", "广东省深圳市",
"861572431", "辽宁省辽阳市",
"861500749", "湖南省邵阳市",
"861590963", "宁夏吴忠市",
"861593321", "河北省石家庄市",
"861570588", "浙江省丽水市",
"86186796", "江西省吉安市",
"86139266", "广东省清远市",
"861521624", "江西省吉安市",
"861577114", "湖北省荆州市",
"861524181", "辽宁省沈阳市",
"861453478", "黑龙江省双鸭山市",
"861786505", "山东省临沂市",
"861841974", "甘肃省天水市",
"861308692", "贵州省黔南布依族苗族自治州",
"861510478", "内蒙古巴彦淖尔市",
"861848545", "贵州省黔东南苗族侗族自治州",
"861517400", "辽宁省本溪市",
"86158439", "吉林省白山市",
"861361778", "广西河池市",
"861454545", "新疆克拉玛依市",
"861339028", "辽宁省铁岭市",
"86181770", "广西防城港市",
"86152909", "河南省许昌市",
"861874286", "新疆巴音郭楞蒙古自治州",
"861589900", "新疆巴音郭楞蒙古自治州",
"861524096", "云南省丽江市",
"861769834", "河南省安阳市",
"861571908", "新疆巴音郭楞蒙古自治州",
"86186646", "广东省广州市",
"861321916", "四川省达州市",
"861856249", "山东省临沂市",
"861879846", "贵州省六盘水市",
"861810898", "西藏拉萨市",
"86152736", "湖南省常德市",
"861312535", "江西省吉安市",
"86156865", "陕西省汉中市",
"861302400", "安徽省淮南市",
"861505088", "江苏省镇江市",
"86131661", "上海市",
"861839443", "甘肃省兰州市",
"861308353", "江苏省徐州市",
"861310690", "广东省肇庆市",
"861598299", "四川省达州市",
"861822749", "四川省甘孜藏族自治州",
"861800080", "广东省潮州市",
"86183321", "河北省石家庄市",
"861834469", "江苏省淮安市",
"861362677", "浙江省温州市",
"861557084", "湖南省娄底市",
"861333797", "江苏省淮安市",
"86151512", "江苏省连云港市",
"86188422", "辽宁省鞍山市",
"861815470", "广西南宁市",
"86188044", "吉林省松原市",
"861356145", "山东省聊城市",
"861768752", "广西柳州市",
"861586983", "湖南省郴州市",
"861809643", "安徽省淮南市",
"861804669", "江西省赣州市",
"861850579", "浙江省金华市",
"86151577", "浙江省温州市",
"861580740", "湖南省怀化市",
"861318765", "云南省楚雄彝族自治州",
"861360496", "辽宁省锦州市",
"861821960", "甘肃省临夏回族自治州",
"861847638", "广东省湛江市",
"861338884", "云南省昆明市",
"861509570", "甘肃省天水市",
"861381514", "江苏省无锡市",
"861518074", "贵州省贵阳市",
"861770702", "江西省九江市",
"86147779", "广东省广州市",
"861867376", "湖南省常德市",
"861457207", "四川省绵阳市",
"861536382", "广东省佛山市",
"861571491", "新疆克孜勒苏柯尔克孜自治州",
"861871871", "广东省佛山市",
"861559089", "黑龙江省哈尔滨市",
"861816107", "四川省宜宾市",
"861847626", "广东省茂名市",
"861708308", "河北省石家庄市",
"861826896", "浙江省衢州市",
"861893540", "山西省晋中市",
"86183516", "江苏省苏州市",
"861340794", "江西省抚州市",
"861371724", "广东省肇庆市",
"861879972", "新疆塔城地区",
"861761425", "辽宁省丹东市",
"861533352", "山西省大同市",
"86131390", "青海省西宁市",
"861398640", "湖北省鄂州市",
"861503161", "河北省廊坊市",
"861477870", "广东省佛山市",
"861860998", "新疆喀什地区",
"861510249", "辽宁省辽阳市",
"861872541", "云南省玉溪市",
"861356842", "四川省绵阳市",
"86133403", "重庆市",
"861779942", "新疆伊犁哈萨克自治州",
"861339036", "辽宁省丹东市",
"861399951", "新疆克拉玛依市",
"861528077", "福建省南平市",
"86189692", "浙江省舟山市",
"861773646", "河北省沧州市",
"861565990", "福建省南平市",
"861806945", "浙江省湖州市",
"86185581", "浙江省杭州市",
"861475550", "安徽省马鞍山市",
"861322512", "江苏省苏州市",
"86152952", "江苏省泰州市",
"861577989", "江西省赣州市",
"86139643", "山东省淄博市",
"861368534", "山东省德州市",
"861802398", "广东省茂名市",
"861558344", "四川省成都市",
"86137580", "浙江省舟山市",
"861318063", "吉林省四平市",
"861339598", "福建省三明市",
"861450655", "黑龙江省鹤岗市",
"861826104", "江苏省泰州市",
"861365221", "广东省中山市",
"861532971", "贵州省遵义市",
"861767346", "湖南省岳阳市",
"861332985", "湖北省十堰市",
"861576661", "广东省惠州市",
"861837997", "江西省南昌市",
"861533693", "浙江省金华市",
"861528681", "河南省郑州市",
"861328675", "广东省梅州市",
"861893303", "广东省云浮市",
"861592408", "浙江省衢州市",
"861367391", "河南省焦作市",
"861538209", "辽宁省沈阳市",
"861452321", "河南省郑州市",
"861532901", "贵州省贵阳市",
"861870742", "湖南省永州市",
"861893373", "广东省河源市",
"861309658", "山西省大同市",
"86156139", "河北省邢台市",
"861367789", "广西玉林市",
"861777199", "湖北省黄冈市",
"861816859", "江苏省镇江市",
"861842025", "广东省梅州市",
"861831864", "广东省清远市",
"861390535", "山东省烟台市",
"861308222", "辽宁省盘锦市",
"861506583", "山东省泰安市",
"861820737", "湖南省益阳市",
"861504524", "黑龙江省齐齐哈尔市",
"861558480", "吉林省通化市",
"861526885", "浙江省台州市",
"86137587", "浙江省温州市",
"861339458", "黑龙江省伊春市",
"861340826", "四川省广安市",
"861708378", "河南省郑州市",
"861596913", "云南省曲靖市",
"861809815", "广东省佛山市",
"861816177", "陕西省宝鸡市",
"86188469", "黑龙江省双鸭山市",
"861555072", "山东省济宁市",
"861871801", "广东省惠州市",
"861536674", "江苏省泰州市",
"861571551", "安徽省合肥市",
"86155781", "广西南宁市",
"86136964", "重庆市",
"861776812", "江苏省南京市",
"861510991", "新疆乌鲁木齐市",
"861572964", "四川省内江市",
"861470878", "云南省楚雄彝族自治州",
"861829513", "宁夏吴忠市",
"861477800", "广东省湛江市",
"861806894", "江苏省宿迁市",
"861364646", "山东省潍坊市",
"861772287", "广东省广州市",
"86137755", "江苏省镇江市",
"861879902", "新疆阿勒泰地区",
"861816727", "浙江省湖州市",
"861519435", "山东省烟台市",
"861598629", "广东省阳江市",
"861810734", "湖南省衡阳市",
"861535997", "福建省泉州市",
"861379188", "山东省潍坊市",
"86186835", "四川省雅安市",
"861770772", "广西柳州市",
"861311062", "福建省龙岩市",
"86133801", "广东省东莞市",
"861536767", "湖南省张家界市",
"861815400", "安徽省淮南市",
"861858644", "贵州省铜仁地区",
"861840630", "山东省威海市",
"861568212", "四川省成都市",
"861760441", "吉林省长春市",
"861339965", "安徽省巢湖市",
"86318", "河北省衡水市",
"86182293", "湖南省郴州市",
"861886545", "山东省烟台市",
"861550859", "贵州省黔西南布依族苗族自治州",
"861850509", "福建省龙岩市",
"861587748", "陕西省西安市",
"861889385", "甘肃省白银市",
"86151570", "浙江省衢州市",
"861380729", "湖北省孝感市",
"861317698", "山东省临沂市",
"861592249", "安徽省宿州市",
"861360556", "安徽省安庆市",
"861399508", "宁夏银川市",
"861705751", "山东省青岛市",
"861824085", "陕西省安康市",
"861359354", "山西省临汾市",
"86182536", "山东省潍坊市",
"861362607", "福建省泉州市",
"861786461", "山东省滨州市",
"861521759", "广东省惠州市",
"861571978", "青海省西宁市",
"861301914", "吉林省松原市",
"861313282", "广西柳州市",
"861589970", "广东省江门市",
"861332442", "吉林省吉林市",
"861860565", "安徽省合肥市",
"861365691", "福建省三明市",
"861324762", "广东省深圳市",
"861595977", "福建省南平市",
"861817890", "江西省南昌市",
"861552069", "四川省遂宁市",
"861533223", "陕西省渭南市",
"861380857", "福建省莆田市",
"861560891", "西藏拉萨市",
"86136387", "云南省楚雄彝族自治州",
"86181712", "湖北省武汉市",
"86138913", "陕西省渭南市",
"861860471", "内蒙古呼和浩特市",
"861550727", "湖北省襄樊市",
"861510408", "辽宁省大连市",
"861517470", "内蒙古乌海市",
"861361708", "江西省南昌市",
"861841904", "甘肃省临夏回族自治州",
"861831548", "山东省泰安市",
"861596694", "山东省青岛市",
"861340838", "四川省德阳市",
"861302642", "陕西省汉中市",
"861376960", "云南省文山壮族苗族自治州",
"861776115", "四川省广安市",
"861338552", "贵州省遵义市",
"861839956", "新疆阿克苏地区",
"861770825", "广东省中山市",
"861773180", "河北省邯郸市",
"861347201", "河北省邯郸市",
"86183495", "四川省绵阳市",
"861599615", "江苏省淮安市",
"861570837", "四川省阿坝藏族羌族自治州",
"861847155", "湖北省武汉市",
"861576824", "广东省惠州市",
"861454739", "浙江省金华市",
"86157341", "辽宁省大连市",
"861705709", "广东省广州市",
"861560264", "广东省东莞市",
"86155686", "吉林省松原市",
"861351798", "江西省景德镇市",
"861300178", "山东省济宁市",
"861582699", "湖北省鄂州市",
"86139520", "江苏省南京市",
"861459105", "广西柳州市",
"861580574", "浙江省宁波市",
"861845893", "浙江省台州市",
"861366543", "山东省滨州市",
"861556333", "山东省日照市",
"86178697", "云南省昆明市",
"861847110", "湖北省十堰市",
"86182661", "山东省德州市",
"861778617", "湖北省黄冈市",
"861820690", "云南省西双版纳傣族自治州",
"861339999", "新疆伊犁哈萨克自治州",
"861341977", "河南省开封市",
"861369383", "河南省洛阳市",
"861476891", "山东省青岛市",
"861827236", "湖北省荆门市",
"861889761", "广西百色市",
"861850551", "安徽省合肥市",
"861377468", "福建省厦门市",
"861591189", "云南省临沧市",
"86711", "湖北省鄂州市",
"861887089", "江西省鹰潭市",
"861534805", "甘肃省武威市",
"861325642", "山东省聊城市",
"861533931", "甘肃省兰州市",
"86180593", "福建省宁德市",
"861764048", "辽宁省营口市",
"8615776", "黑龙江省哈尔滨市",
"861811361", "四川省德阳市",
"861504686", "黑龙江省黑河市",
"861888828", "山东省泰安市",
"861589072", "河南省驻马店市",
"861580483", "内蒙古兴安盟",
"861334566", "安徽省池州市",
"861892711", "广东省潮州市",
"861459453", "陕西省商洛市",
"861366300", "河南省郑州市",
"86153611", "广东省湛江市",
"8615222", "天津市",
"861839780", "江西省新余市",
"861596086", "福建省漳州市",
"861337613", "江苏省南通市",
"861847403", "湖南省常德市",
"861860599", "福建省南平市",
"86153948", "云南省红河哈尼族彝族自治州",
"86132770", "湖北省武汉市",
"861380563", "安徽省宣城市",
"861350476", "吉林省吉林市",
"861862674", "吉林省吉林市",
"861359753", "湖北省襄樊市",
"86181086", "湖北省武汉市",
"861874024", "辽宁省营口市",
"861880582", "浙江省湖州市",
"861508091", "湖南省邵阳市",
"861399979", "新疆阿勒泰地区",
"861311418", "云南省西双版纳傣族自治州",
"861595019", "江苏省苏州市",
"861313575", "湖北省荆州市",
"861840797", "江西省赣州市",
"861818675", "湖北省襄樊市",
"861700475", "内蒙古包头市",
"86134021", "上海市",
"861810333", "河北省秦皇岛市",
"861777165", "湖北省恩施土家族苗族自治州",
"861520976", "青海省玉树藏族自治州",
"861838887", "云南省临沧市",
"861814387", "西藏日喀则地区",
"861532959", "贵州省黔西南布依族苗族自治州",
"861700561", "浙江省温州市",
"861862767", "湖南省衡阳市",
"861566878", "辽宁省葫芦岛市",
"861857900", "江西省新余市",
"861850978", "青海省西宁市",
"861500904", "新疆和田地区",
"86180020", "天津市",
"861335313", "吉林省延边朝鲜族自治州",
"861313461", "山西省朔州市",
"861771147", "四川省宜宾市",
"861879000", "河南省焦作市",
"861501630", "广东省汕尾市",
"861889084", "新疆巴音郭楞蒙古自治州",
"861762516", "江苏省徐州市",
"861831291", "浙江省温州市",
"861524939", "甘肃省天水市",
"861830645", "山东省烟台市",
"861869362", "甘肃省张掖市",
"861781766", "广东省云浮市",
"86182390", "河南省焦作市",
"861537717", "湖北省咸宁市",
"86189988", "广东省广州市",
"861531430", "山东省东营市",
"861590720", "湖北省宜昌市",
"861871859", "广东省佛山市",
"861571509", "福建省莆田市",
"861827228", "湖北省宜昌市",
"861894886", "广东省中山市",
"861804225", "浙江省绍兴市",
"861594944", "内蒙古通辽市",
"861327342", "河北省石家庄市",
"86189424", "广东省佛山市",
"861300736", "湖南省常德市",
"86183173", "河南省安阳市",
"86155130", "山西省太原市",
"86135513", "四川省成都市",
"86153246", "河南省洛阳市",
"86188553", "安徽省芜湖市",
"861357371", "山东省威海市",
"861305512", "湖南省株洲市",
"861700153", "江苏省无锡市",
"861868880", "广东省佛山市",
"861326727", "广东省东莞市",
"861824440", "四川省凉山彝族自治州",
"861320734", "湖南省衡阳市",
"86180938", "甘肃省天水市",
"861897019", "江西省鹰潭市",
"86180654", "福建省泉州市",
"861804386", "吉林省松原市",
"861513866", "河南省郑州市",
"86152474", "内蒙古乌兰察布市",
"861588417", "四川省泸州市",
"861831949", "广东省广州市",
"86170024", "辽宁省沈阳市",
"861709426", "广东省江门市",
"861879070", "河南省三门峡市",
"86182397", "河南省平顶山市",
"861390749", "湖南省长沙市",
"861319513", "贵州省安顺市",
"861331867", "广东省汕尾市",
"861708532", "山东省青岛市",
"86147591", "福建省福州市",
"861700886", "广东省深圳市",
"861310737", "湖南省益阳市",
"861520906", "新疆喀什地区",
"86151104", "山西省运城市",
"861568139", "四川省南充市",
"861768913", "西藏山南地区",
"861565092", "青海省海东地区",
"861882781", "江西省宜春市",
"861314783", "辽宁省沈阳市",
"861500974", "青海省海南藏族自治州",
"86180027", "广东省东莞市",
"861331276", "云南省文山壮族苗族自治州",
"861351834", "四川省雅安市",
"861816871", "江苏省苏州市",
"86137814", "河南省商丘市",
"861866558", "广东省广州市",
"861323263", "广东省河源市",
"861850908", "新疆克孜勒苏柯尔克孜自治州",
"861317041", "湖南省长沙市",
"86133529", "广东省深圳市",
"861779040", "四川省广元市",
"861573522", "山西省太原市",
"861370918", "陕西省西安市",
"861534722", "湖北省武汉市",
"861333630", "山东省威海市",
"861593367", "河北省承德市",
"861337845", "广东省广州市",
"861844719", "内蒙古兴安盟",
"861332716", "内蒙古赤峰市",
"86152631", "山东省威海市",
"861766629", "广东省深圳市",
"861520390", "河南省焦作市",
"861770683", "浙江省嘉兴市",
"861335731", "湖南省长沙市",
"861399909", "新疆喀什地区",
"861894561", "黑龙江省大庆市",
"861760258", "江苏省南通市",
"861572849", "广东省广州市",
"861309135", "河北省承德市",
"861516491", "内蒙古通辽市",
"861593426", "山西省忻州市",
"861700405", "广东省东莞市",
"86130505", "辽宁省大连市",
"861818605", "湖北省武汉市",
"86136283", "重庆市",
"861365933", "甘肃省白银市",
"861855226", "江苏省南京市",
"861594895", "吉林省辽源市",
"861340393", "河南省濮阳市",
"861810711", "湖北省鄂州市",
"861590413", "辽宁省抚顺市",
"861313505", "湖南省郴州市",
"861530345", "山西省长治市",
"861891201", "江苏省徐州市",
"861321785", "广西玉林市",
"861826252", "江苏省南通市",
"861521771", "广东省广州市",
"861576796", "广东省湛江市",
"861366370", "河南省商丘市",
"861554341", "吉林省长春市",
"861364531", "山东省济南市",
"861528919", "西藏拉萨市",
"861563311", "河北省石家庄市",
"861384860", "内蒙古呼伦贝尔市",
"861350406", "辽宁省锦州市",
"861862604", "江苏省徐州市",
"86132777", "广西南宁市",
"86189286", "广东省佛山市",
"861847473", "湖南省怀化市",
"861373933", "甘肃省平凉市",
"861859357", "福建省龙岩市",
"861870416", "辽宁省锦州市",
"861573092", "甘肃省陇南市",
"861860459", "黑龙江省大庆市",
"861890512", "江苏省连云港市",
"861524684", "黑龙江省鹤岗市",
"861862382", "河南省安阳市",
"861892333", "广东省中山市",
"861346620", "云南省昭通市",
"86132712", "河南省许昌市",
"861585089", "江苏省泰州市",
"861318799", "云南省怒江傈僳族自治州",
"861341907", "四川省达州市",
"861827698", "广西河池市",
"861884816", "内蒙古兴安盟",
"861339241", "广东省深圳市",
"86150793", "江西省上饶市",
"861309832", "湖北省武汉市",
"861380151", "江苏省无锡市",
"861869787", "青海省海西蒙古族藏族自治州",
"861800982", "辽宁省朝阳市",
"86184894", "西藏拉萨市",
"861453642", "江苏省苏州市",
"861534875", "云南省保山市",
"861370460", "黑龙江省牡丹江市",
"861847584", "广东省清远市",
"861550871", "云南省昆明市",
"86135389", "广东省广州市",
"861859935", "新疆伊犁哈萨克自治州",
"86131536", "山东省潍坊市",
"861373048", "河北省邢台市",
"861350885", "云南省楚雄彝族自治州",
"861780316", "河北省廊坊市",
"861850491", "内蒙古呼和浩特市",
"861705779", "陕西省西安市",
"861522088", "广东省中山市",
"86181242", "广东省广州市",
"861831621", "广东省肇庆市",
"861510633", "山东省日照市",
"861453470", "黑龙江省哈尔滨市",
"861880854", "贵州省黔南布依族苗族自治州",
"861337142", "山东省枣庄市",
"861459175", "内蒙古包头市",
"861355087", "四川省泸州市",
"861315833", "贵州省安顺市",
"86131293", "广东省广州市",
"861570580", "浙江省舟山市",
"86139527", "江苏省扬州市",
"861309843", "湖北省荆门市",
"861772915", "陕西省安康市",
"861594751", "内蒙古呼和浩特市",
"861382451", "广东省佛山市",
"861339020", "辽宁省锦州市",
"861501852", "广东省深圳市",
"86150643", "山东省淄博市",
"861326385", "广西来宾市",
"861304283", "湖北省襄樊市",
"86157537", "山东省济宁市",
"861899747", "青海省海西蒙古族藏族自治州",
"861323310", "山西省临汾市",
"861329545", "山东省烟台市",
"861517408", "辽宁省锦州市",
"861453633", "江苏省南京市",
"861510470", "内蒙古呼伦贝尔市",
"86158544", "山东省潍坊市",
"861571396", "河南省驻马店市",
"861361770", "广西防城港市",
"861881339", "广东省中山市",
"861380792", "江西省九江市",
"861304869", "江苏省连云港市",
"861887275", "湖北省黄石市",
"861567891", "广西南宁市",
"861813424", "河北省唐山市",
"86181012", "北京市",
"861810890", "西藏拉萨市",
"861510642", "山东省淄博市",
"861772950", "陕西省西安市",
"861560676", "浙江省台州市",
"86153663", "江苏省南通市",
"861302408", "安徽省蚌埠市",
"861505080", "江苏省淮安市",
"861881846", "广东省清远市",
"861867565", "广东省云浮市",
"861313934", "甘肃省庆阳市",
"861337133", "山东省滨州市",
"86188128", "天津市",
"861581984", "广东省珠海市",
"861315842", "四川省达州市",
"861589908", "新疆昌吉回族自治州",
"861566768", "陕西省榆林市",
"861323355", "山西省长治市",
"86134626", "河南省南阳市",
"861362255", "广东省潮州市",
"861862877", "吉林省四平市",
"861365876", "云南省文山壮族苗族自治州",
"861571900", "新疆阿克苏地区",
"861890907", "四川省南充市",
"861570634", "山东省莱芜市",
"861576627", "广东省湛江市",
"861475971", "福建省福州市",
"861334004", "江西省赣州市",
"86137464", "黑龙江省牡丹江市",
"861373942", "四川省资阳市",
"861367556", "安徽省安庆市",
"861331707", "江西省赣州市",
"861861547", "山东省菏泽市",
"86183874", "云南省曲靖市",
"861379646", "黑龙江省鹤岗市",
"861310698", "广东省江门市",
"861855107", "江苏省常州市",
"86186360", "山西省忻州市",
"861823366", "河北省沧州市",
"861846973", "云南省红河哈尼族彝族自治州",
"861551311", "山西省长治市",
"861522982", "陕西省榆林市",
"861580748", "湖南省永州市",
"861819739", "青海省海南藏族自治州",
"861821968", "甘肃省天水市",
"861808892", "云南省玉溪市",
"861843845", "河南省平顶山市",
"86182613", "江苏省连云港市",
"861778137", "四川省德阳市",
"861847630", "广东省湛江市",
"86135731", "山东省济南市",
"861538672", "山西省运城市",
"861840296", "陕西省汉中市",
"861815478", "广西桂林市",
"861532550", "浙江省温州市",
"861358995", "山东省东营市",
"86187730", "湖南省岳阳市",
"861323937", "甘肃省酒泉市",
"861521586", "浙江省金华市",
"861369457", "黑龙江省黑河市",
"86155677", "吉林省长春市",
"861450277", "内蒙古鄂尔多斯市",
"861303673", "湖南省邵阳市",
"861315145", "江苏省无锡市",
"861509578", "甘肃省白银市",
"861859504", "宁夏固原市",
"861591223", "云南省丽江市",
"861598353", "四川省雅安市",
"861302991", "黑龙江省绥化市",
"861321327", "河南省安阳市",
"861893548", "山西省朔州市",
"86151401", "辽宁省沈阳市",
"86176980", "河南省郑州市",
"861452782", "新疆伊犁哈萨克自治州",
"861477878", "广东省深圳市",
"861398648", "湖北省孝感市",
"861835044", "福建省莆田市",
"861321466", "黑龙江省黑河市",
"861860990", "新疆克拉玛依市",
"861777122", "湖北省孝感市",
"86155081", "四川省南充市",
"86187560", "安徽省合肥市",
"861357623", "江西省九江市",
"861315976", "吉林省白城市",
"861338059", "广东省揭阳市",
"861569295", "四川省绵阳市",
"861889871", "广东省东莞市",
"861580935", "甘肃省金昌市",
"861354147", "四川省甘孜藏族自治州",
"86135561", "广东省广州市",
"861350359", "山西省运城市",
"861565998", "福建省厦门市",
"861815249", "宁夏银川市",
"861326696", "广东省深圳市",
"861311569", "黑龙江省双鸭山市",
"861475558", "安徽省宣城市",
"861843142", "河北省保定市",
"861571685", "河北省沧州市",
"861821455", "云南省昆明市",
"861459387", "贵州省黔西南布依族苗族自治州",
"86153016", "上海市",
"861336554", "安徽省淮南市",
"861802390", "广东省潮州市",
"8618516", "上海市",
"861869325", "甘肃省兰州市",
"861854520", "黑龙江省齐齐哈尔市",
"861814802", "四川省绵阳市",
"861598692", "广东省肇庆市",
"861370012", "辽宁省鞍山市",
"861558732", "山东省济宁市",
"861589163", "陕西省汉中市",
"861327711", "湖北省襄樊市",
"861333584", "浙江省宁波市",
"861503664", "河南省新乡市",
"861383439", "山西省运城市",
"861360789", "广西北海市",
"861592400", "浙江省舟山市",
"861339590", "福建省福州市",
"861360391", "河南省焦作市",
"861580357", "山西省临汾市",
"86156337", "河北省保定市",
"861309650", "山西省阳泉市",
"861514492", "内蒙古兴安盟",
"861870334", "河北省承德市",
"861568619", "陕西省汉中市",
"861339415", "辽宁省丹东市",
"861830997", "新疆阿克苏地区",
"861760346", "山西省晋城市",
"86156330", "河北省石家庄市",
"861523666", "河南省洛阳市",
"86189277", "广东省佛山市",
"861351637", "山东省枣庄市",
"86132786", "云南省昭通市",
"861336494", "新疆哈密地区",
"861536171", "广东省肇庆市",
"861509017", "河南省洛阳市",
"861558488", "吉林省白城市",
"861339450", "黑龙江省哈尔滨市",
"861760839", "四川省广元市",
"861802145", "江苏省常州市",
"86177564", "安徽省六安市",
"861537044", "江苏省无锡市",
"86186428", "辽宁省大连市",
"861564984", "河南省许昌市",
"861309615", "四川省资阳市",
"861814023", "四川省成都市",
"861536721", "湖南省湘西土家族苗族自治州",
"861333155", "吉林省四平市",
"861597237", "湖北省黄石市",
"861501473", "广东省佛山市",
"861864846", "内蒙古包头市",
"86189212", "江苏省无锡市",
"861327333", "河北省衡水市",
"86186984", "内蒙古呼和浩特市",
"861843613", "河南省商丘市",
"861522445", "山东省青岛市",
"861477808", "广东省中山市",
"861470870", "云南省昭通市",
"861836289", "江苏省镇江市",
"861873891", "河南省平顶山市",
"861708370", "河南省商丘市",
"861313689", "黑龙江省牡丹江市",
"861889801", "西藏拉萨市",
"861452438", "辽宁省营口市",
"861840626", "辽宁省葫芦岛市",
"86187567", "安徽省亳州市",
"861812907", "新疆阿克苏地区",
"861573565", "山西省太原市",
"861786911", "云南省保山市",
"861534765", "广东省潮州市",
"861450581", "辽宁省阜新市",
"861379180", "山东省青岛市",
"861860376", "河南省信阳市",
"86183633", "山东省日照市",
"861508853", "浙江省绍兴市",
"861705283", "四川省成都市",
"861810342", "山西省太原市",
"86155670", "吉林省长春市",
"861777702", "广西防城港市",
"861573471", "内蒙古呼和浩特市",
"861373194", "安徽省六安市",
"86134142", "广东省东莞市",
"861780434", "吉林省四平市",
"861373485", "内蒙古赤峰市",
"861308941", "吉林省长春市",
"861314448", "广东省汕尾市",
"861583341", "河北省邯郸市",
"861316659", "河北省邢台市",
"861809858", "安徽省黄山市",
"86797", "江西省赣州市",
"861802842", "广东省湛江市",
"861840638", "山东省泰安市",
"861452426", "辽宁省锦州市",
"861587740", "陕西省咸阳市",
"86187737", "湖南省益阳市",
"861306913", "吉林省长春市",
"861333852", "福建省莆田市",
"861365485", "内蒙古兴安盟",
"86188744", "湖南省张家界市",
"861815408", "安徽省黄山市",
"861775784", "浙江省宁波市",
"861338429", "辽宁省葫芦岛市",
"861538384", "河北省秦皇岛市",
"861385281", "江苏省宿迁市",
"861334074", "四川省泸州市",
"861890977", "青海省海西蒙古族藏族自治州",
"86138826", "四川省广安市",
"861550084", "宁夏固原市",
"861346541", "山东省济南市",
"861566046", "山东省泰安市",
"86183279", "湖北省荆州市",
"86186367", "山西省临汾市",
"861831303", "云南省大理白族自治州",
"861519244", "山东省济宁市",
"861332217", "辽宁省丹东市",
"86181994", "新疆阿克苏地区",
"861317690", "山东省烟台市",
"86136857", "浙江省杭州市",
"861308629", "青海省西宁市",
"861331777", "广西钦州市",
"861336882", "云南省德宏傣族景颇族自治州",
"861399500", "宁夏银川市",
"861516072", "福建省厦门市",
"861302478", "浙江省台州市",
"861534063", "山西省忻州市",
"86152036", "海南省海口市",
"861560606", "福建省福州市",
"861817898", "江西省赣州市",
"861572414", "广东省茂名市",
"861472997", "陕西省商洛市",
"861571970", "青海省海北藏族自治州",
"861589978", "广东省深圳市",
"861476053", "宁夏吴忠市",
"861539049", "四川省南充市",
"861366532", "山东省青岛市",
"861855859", "福建省泉州市",
"861556342", "山东省莱芜市",
"861801572", "四川省泸州市",
"86177734", "湖南省衡阳市",
"86151803", "江西省上饶市",
"861577131", "内蒙古乌海市",
"861500535", "山东省烟台市",
"861517478", "内蒙古兴安盟",
"861510400", "辽宁省沈阳市",
"861361700", "江西省南昌市",
"861325633", "山东省日照市",
"861396583", "安徽省安庆市",
"861526301", "山东省滨州市",
"861831540", "山东省菏泽市",
"861340830", "四川省泸州市",
"86157530", "山东省菏泽市",
"861376968", "云南省曲靖市",
"861303625", "江西省上饶市",
"861855518", "安徽省亳州市",
"861309742", "云南省红河哈尼族彝族自治州",
"861890232", "广东省广州市",
"861529828", "四川省泸州市",
"861828072", "四川省自贡市",
"861850486", "内蒙古赤峰市",
"861362684", "浙江省宁波市",
"86159728", "湖北省黄冈市",
"861776436", "安徽省铜陵市",
"861705376", "黑龙江省哈尔滨市",
"86185482", "内蒙古兴安盟",
"861860869", "湖北省荆门市",
"861556969", "甘肃省平凉市",
"861597846", "河南省驻马店市",
"861866444", "广东省汕头市",
"861380893", "山东省济南市",
"861591275", "云南省玉溪市",
"861859826", "广东省深圳市",
"861339770", "广西南宁市",
"861391281", "江苏省镇江市",
"861394942", "河南省开封市",
"861597339", "湖南省衡阳市",
"861372060", "陕西省西安市",
"861770529", "江苏省镇江市",
"86189245", "广东省佛山市",
"861323202", "广东省阳江市",
"861320568", "安徽省阜阳市",
"861537992", "甘肃省临夏回族自治州",
"86133989", "海南省海口市",
"861557681", "湖南省益阳市",
"861318396", "四川省宜宾市",
"861770364", "黑龙江省哈尔滨市",
"86188316", "河北省廊坊市",
"861880464", "黑龙江省七台河市",
"861550555", "安徽省马鞍山市",
"861886849", "浙江省金华市",
"861534551", "安徽省合肥市",
"861347504", "山东省菏泽市",
"861337948", "陕西省宝鸡市",
"861573751", "河南省周口市",
"861370815", "四川省自贡市",
"861369707", "江西省赣州市",
"861300902", "吉林省四平市",
"861778037", "四川省阿坝藏族羌族自治州",
"861476561", "湖北省武汉市",
"861521240", "安徽省淮南市",
"861841987", "甘肃省定西市",
"861869373", "甘肃省酒泉市",
"861839547", "陕西省宝鸡市",
"861370850", "贵州省遵义市",
"861594998", "山东省日照市",
"861576781", "广东省惠州市",
"861302347", "江苏省连云港市",
"86152578", "浙江省宁波市",
"86134115", "广东省珠海市",
"861769500", "宁夏银川市",
"86147050", "福建省龙岩市",
"861777592", "湖南省怀化市",
"861528761", "云南省临沧市",
"861808793", "云南省西双版纳傣族自治州",
"861550510", "江苏省淮安市",
"86155659", "河南省驻马店市",
"861840912", "陕西省榆林市",
"861450309", "河北省衡水市",
"861331457", "黑龙江省大兴安岭地区",
"861304306", "福建省漳州市",
"861837446", "湖南省长沙市",
"861310847", "陕西省渭南市",
"86130930", "江苏省无锡市",
"861337735", "广西玉林市",
"86139987", "辽宁省盘锦市",
"861840354", "山西省晋中市",
"861528084", "福建省龙岩市",
"861835144", "江苏省南京市",
"86155602", "河南省新乡市",
"861394876", "内蒙古赤峰市",
"861810969", "安徽省合肥市",
"861351744", "湖南省张家界市",
"86151411", "辽宁省大连市",
"861576064", "四川省广安市",
"861452269", "浙江省舟山市",
"86188521", "江苏省徐州市",
"86378", "河南省开封市",
"861458961", "广东省阳江市",
"861882796", "江西省吉安市",
"861332319", "河北省邢台市",
"861301657", "江苏省淮安市",
"861335841", "福建省三明市",
"861316566", "湖北省孝感市",
"861315045", "新疆乌鲁木齐市",
"861452883", "云南省临沧市",
"86183250", "重庆市",
"861566680", "山东省滨州市",
"861399790", "湖北省荆门市",
"861530641", "山东省济南市",
"861458316", "江西省宜春市",
"861345582", "山东省泰安市",
"861338266", "江苏省徐州市",
"861320844", "黑龙江省大庆市",
"861346435", "辽宁省鞍山市",
"861478391", "河南省焦作市",
"861534978", "青海省海南藏族自治州",
"861350988", "广东省汕头市",
"861516805", "浙江省舟山市",
"861390346", "山西省太原市",
"861378489", "河北省邢台市",
"86152483", "内蒙古通辽市",
"861700891", "北京市",
"861831325", "云南省普洱市",
"861338877", "云南省玉溪市",
"861529836", "江苏省南京市",
"861782280", "贵州省黔东南苗族侗族自治州",
"861363508", "广西梧州市",
"861816510", "陕西省西安市",
"861318685", "浙江省宁波市",
"861529349", "甘肃省酒泉市",
"861526589", "山东省临沂市",
"861376822", "广西柳州市",
"861804391", "吉林省长春市",
"861555381", "山东省泰安市",
"861302758", "河南省焦作市",
"86155836", "四川省南充市",
"861518601", "贵州省铜仁地区",
"861894891", "广东省河源市",
"861771714", "河北省廊坊市",
"861885652", "安徽省芜湖市",
"861313851", "广东省肇庆市",
"861535446", "河北省唐山市",
"861361415", "辽宁省丹东市",
"861333055", "云南省大理白族自治州",
"861363578", "湖北省襄樊市",
"861774017", "四川省成都市",
"861536687", "江苏省扬州市",
"861537144", "江苏省连云港市",
"861788126", "新疆塔城地区",
"861802045", "江苏省盐城市",
"861817647", "广西玉林市",
"861510750", "广东省江门市",
"86158721", "湖北省荆州市",
"861536071", "广东省湛江市",
"861831286", "广东省汕尾市",
"861509117", "陕西省宝鸡市",
"861361450", "黑龙江省哈尔滨市",
"861333010", "江西省南昌市",
"861867751", "广西贵港市",
"861850722", "湖北省武汉市",
"861505646", "安徽省芜湖市",
"861823879", "河南省新乡市",
"861534908", "甘肃省白银市",
"861454328", "内蒙古鄂尔多斯市",
"86170865", "山东省潍坊市",
"861300846", "陕西省汉中市",
"861586636", "山东省烟台市",
"861836762", "浙江省嘉兴市",
"861365369", "山西省临汾市",
"861871469", "黑龙江省双鸭山市",
"861331597", "河北省石家庄市",
"861570358", "山西省吕梁市",
"861365524", "江苏省宿迁市",
"86183257", "安徽省宿州市",
"861775161", "江苏省泰州市",
"861370643", "山东省淄博市",
"86130937", "浙江省杭州市",
"861304376", "河南省信阳市",
"861508086", "湖南省湘西土家族苗族自治州",
"861362939", "甘肃省陇南市",
"861768648", "山东省烟台市",
"861575843", "云南省临沧市",
"861369664", "安徽省六安市",
"861803199", "河北省邢台市",
"861329431", "吉林省长春市",
"861368870", "云南省昆明市",
"861821822", "广东省广州市",
"861596521", "山东省德州市",
"861324304", "河南省焦作市",
"861862429", "辽宁省葫芦岛市",
"86139980", "辽宁省鞍山市",
"861328359", "山西省运城市",
"861363951", "宁夏银川市",
"861596091", "福建省龙岩市",
"861856715", "河南省南阳市",
"861595984", "福建省三明市",
"86189528", "江苏省镇江市",
"861308397", "浙江省杭州市",
"861807180", "湖北省黄冈市",
"86152881", "云南省昆明市",
"861550495", "辽宁省大连市",
"86155348", "山西省运城市",
"861554813", "内蒙古包头市",
"861818371", "云南省昆明市",
"861387009", "江西省南昌市",
"86159144", "广东省广州市",
"861347574", "山东省聊城市",
"861856750", "河南省信阳市",
"861350257", "广东省惠州市",
"861850875", "云南省保山市",
"861559931", "贵州省安顺市",
"861834230", "辽宁省盘锦市",
"861869303", "甘肃省临夏回族自治州",
"861334724", "湖南省衡阳市",
"861336783", "广西桂林市",
"861300972", "黑龙江省哈尔滨市",
"86135356", "广东省佛山市",
"861504691", "黑龙江省双鸭山市",
"86155645", "山东省烟台市",
"861454849", "广东省深圳市",
"861570747", "湖南省永州市",
"861312346", "广西百色市",
"861561049", "山东省青岛市",
"861327560", "安徽省合肥市",
"861476886", "山东省滨州市",
"861773088", "河南省新乡市",
"861323272", "广东省湛江市",
"861821125", "广东省河源市",
"861362372", "河南省安阳市",
"861375578", "江西省南昌市",
"861520732", "湖南省湘潭市",
"861539149", "云南省曲靖市",
"86182778", "广西河池市",
"861347483", "内蒙古呼和浩特市",
"861586628", "山东省淄博市",
"861339700", "江西省南昌市",
"861830341", "山西省太原市",
"861817419", "广西桂林市",
"861705306", "上海市",
"86189259", "广东省佛山市",
"861454336", "内蒙古赤峰市",
"861869540", "宁夏固原市",
"861887189", "湖北省荆州市",
"861865405", "安徽省安庆市",
"861303662", "四川省达州市",
"861315488", "内蒙古呼和浩特市",
"86130496", "广东省广州市",
"861309966", "云南省普洱市",
"861847010", "江西省鹰潭市",
"861805258", "江苏省扬州市",
"861552573", "山西省运城市",
"861332537", "陕西省宝鸡市",
"861818623", "湖北省武汉市",
"861309311", "江苏省无锡市",
"861313523", "湖南省张家界市",
"861836802", "浙江省杭州市",
"861899580", "湖北省黄石市",
"861331383", "福建省泉州市",
"861361999", "新疆克拉玛依市",
"861520743", "湖南省湘西土家族苗族自治州",
"861458434", "河南省许昌市",
"861761296", "陕西省宝鸡市",
"861307000", "新疆巴音郭楞蒙古自治州",
"861340740", "湖南省郴州市",
"861314554", "安徽省淮南市",
"861398694", "湖北省武汉市",
"861816919", "宁夏固原市",
"861599416", "河南省周口市",
"861810560", "安徽省合肥市",
"86138127", "江苏省苏州市",
"861767904", "江西省抚州市",
"86138271", "广东省湛江市",
"86159441", "吉林省长春市",
"861593269", "河北省石家庄市",
"861882297", "广东省东莞市",
"861387285", "湖北省随州市",
"861565944", "福建省福州市",
"86153601", "广东省惠州市",
"861338767", "湖北省孝感市",
"861558390", "四川省广元市",
"861552195", "广东省揭阳市",
"861320419", "辽宁省辽阳市",
"861352329", "河南省许昌市",
"861351951", "宁夏银川市",
"861828908", "西藏昌都地区",
"861861780", "河北省保定市",
"861809955", "新疆喀什地区",
"861840577", "浙江省温州市",
"861894755", "内蒙古呼伦贝尔市",
"861352564", "河南省濮阳市",
"861865153", "江苏省盐城市",
"86155795", "江西省宜春市",
"861359852", "河南省焦作市",
"86137252", "广东省广州市",
"861304599", "福建省南平市",
"861313795", "河南省漯河市",
"861529903", "新疆伊犁哈萨克自治州",
"86156148", "河北省衡水市",
"86131078", "福建省泉州市",
"861304029", "江苏省苏州市",
"861782034", "广东省梅州市",
"861450596", "辽宁省盘锦市",
"861322984", "广东省清远市",
"861398913", "四川省泸州市",
"861339860", "河北省保定市",
"861860779", "广西北海市",
"861380330", "河北省唐山市",
"861879413", "甘肃省陇南市",
"861370632", "山东省枣庄市",
"861529168", "陕西省西安市",
"861328406", "黑龙江省黑河市",
"861595119", "江苏省宿迁市",
"861530520", "江苏省徐州市",
"86136420", "天津市",
"861459703", "宁夏吴忠市",
"861550919", "陕西省铜川市",
"86189153", "江苏省无锡市",
"861596402", "山东省济南市",
"861308474", "内蒙古乌兰察布市",
"861859166", "陕西省延安市",
"861575832", "云南省楚雄彝族自治州",
"861769909", "新疆博尔塔拉蒙古自治州",
"861390258", "广东省江门市",
"86187324", "河北省承德市",
"861521451", "黑龙江省绥化市",
"861573944", "新疆乌鲁木齐市",
"86135503", "四川省成都市",
"861556560", "河南省焦作市",
"861353450", "广东省揭阳市",
"861809468", "浙江省绍兴市",
"861310644", "浙江省绍兴市",
"86177327", "河北省张家口市",
"861880931", "甘肃省兰州市",
"861813609", "江苏省苏州市",
"86183481", "河南省洛阳市",
"86181831", "重庆市",
"861336209", "浙江省丽水市",
"861359155", "辽宁省抚顺市",
"861380421", "辽宁省沈阳市",
"86188382", "河南省郑州市",
"861360225", "广东省东莞市",
"861328885", "广东省东莞市",
"861364445", "吉林省通化市",
"861351578", "浙江省丽水市",
"861569430", "吉林省长春市",
"861313093", "辽宁省盘锦市",
"861528871", "山东省菏泽市",
"861873405", "安徽省亳州市",
"861760749", "湖南省永州市",
"861470511", "江苏省盐城市",
"861889495", "河北省沧州市",
"861580794", "江西省抚州市",
"861889184", "陕西省安康市",
"861308583", "广东省珠海市",
"861380917", "陕西省宝鸡市",
"861864736", "内蒙古呼伦贝尔市",
"861552892", "四川省巴中市",
"861803683", "江苏省苏州市",
"861871518", "安徽省蚌埠市",
"861351508", "福建省南平市",
"861560527", "江苏省扬州市",
"861889510", "宁夏银川市",
"861558842", "山东省威海市",
"861360386", "河南省郑州市",
"861325715", "湖北省咸宁市",
"861353590", "广东省茂名市",
"861321183", "云南省西双版纳傣族自治州",
"861889555", "安徽省马鞍山市",
"861813679", "江苏省镇江市",
"861850765", "广东省云浮市",
"86177320", "河北省邯郸市",
"861318579", "浙江省金华市",
"861852402", "辽宁省辽阳市",
"861873561", "山西省晋城市",
"861369867", "山东省青岛市",
"861516063", "福建省三明市",
"861325750", "广东省江门市",
"861472712", "浙江省杭州市",
"861328476", "内蒙古赤峰市",
"861350756", "福建省三明市",
"861539437", "浙江省金华市",
"861534072", "山西省大同市",
"861457030", "广东省广州市",
"86138456", "黑龙江省黑河市",
"861397250", "湖北省十堰市",
"861596472", "山东省济宁市",
"861308404", "安徽省六安市",
"861319242", "广东省韶关市",
"861459773", "新疆乌鲁木齐市",
"861551615", "河南省郑州市",
"861518323", "四川省资阳市",
"86136427", "广东省广州市",
"861534823", "四川省南充市",
"861317141", "内蒙古呼和浩特市",
"86139278", "广东省韶关市",
"86158448", "吉林省松原市",
"861596640", "山东省临沂市",
"861454414", "福建省厦门市",
"861860709", "江西省南昌市",
"861773445", "河北省廊坊市",
"86151114", "湖南省长沙市",
"861459123", "广西梧州市",
"861354714", "四川省绵阳市",
"861568039", "四川省宜宾市",
"861302986", "黑龙江省哈尔滨市",
"861848414", "贵州省贵阳市",
"861363744", "湖南省张家界市",
"861533854", "贵州省黔东南苗族侗族自治州",
"861580826", "四川省广安市",
"861330549", "山东省临沂市",
"861821865", "广东省深圳市",
"861589102", "陕西省榆林市",
"861567405", "湖南省怀化市",
"86132702", "江苏省徐州市",
"861800531", "山东省济南市",
"861325013", "广东省佛山市",
"861804203", "浙江省杭州市",
"861336448", "吉林省长春市",
"861334659", "广东省云浮市",
"861529973", "新疆博尔塔拉蒙古自治州",
"861507258", "湖北省孝感市",
"86183883", "云南省曲靖市",
"86151861", "贵州省毕节地区",
"861539368", "甘肃省甘南藏族自治州",
"861888247", "四川省绵阳市",
"861700755", "广东省深圳市",
"861324497", "广东省东莞市",
"86138120", "江苏省无锡市",
"861304459", "福建省福州市",
"861580838", "四川省德阳市",
"861802488", "广东省河源市",
"861814863", "广东省广州市",
"861503383", "河北省保定市",
"861524210", "辽宁省鞍山市",
"861362530", "山东省菏泽市",
"861587587", "广东省茂名市",
"861361241", "广东省汕头市",
"861459075", "广东省揭阳市",
"861360695", "福建省漳州市",
"86186858", "贵州省六盘水市",
"861309733", "江西省赣州市",
"861806840", "江苏省苏州市",
"861390987", "辽宁省盘锦市",
"861300008", "湖北省武汉市",
"861571799", "江西省萍乡市",
"86137738", "江苏省南通市",
"861893454", "江苏省南通市",
"861373148", "河北省保定市",
"861830712", "湖北省孝感市",
"861869621", "湖北省襄樊市",
"861342665", "江西省上饶市",
"861865475", "山东省德州市",
"861332880", "福建省漳州市",
"861322639", "广东省阳江市",
"861536492", "山西省太原市",
"861567153", "湖北省恩施土家族苗族自治州",
"861329964", "广西柳州市",
"861380051", "江苏省无锡市",
"86185595", "福建省泉州市",
"861878827", "云南省红河哈尼族彝族自治州",
"861705029", "江西省南昌市",
"861381445", "江苏省泰州市",
"86135732", "山东省青岛市",
"861871216", "安徽省安庆市",
"861830978", "青海省西宁市",
"861837900", "江西省新余市",
"861872776", "湖北省咸宁市",
"861355313", "山东省烟台市",
"861379094", "广东省茂名市",
"861551321", "山西省忻州市",
"861843293", "河北省秦皇岛市",
"861818033", "四川省乐山市",
"861454679", "广东省东莞市",
"86182083", "四川省泸州市",
"861510703", "江西省上饶市",
"861868564", "贵州省遵义市",
"86139380", "河南省周口市",
"861570548", "山东省泰安市",
"861323431", "吉林省长春市",
"861376050", "广东省江门市",
"861554102", "辽宁省营口市",
"86151459", "黑龙江省大庆市",
"861532525", "浙江省绍兴市",
"861565907", "福建省泉州市",
"861809199", "陕西省榆林市",
"86159865", "广东省惠州市",
"861500789", "广西北海市",
"86158897", "广东省深圳市",
"861888274", "四川省自贡市",
"861522040", "广东省东莞市",
"861524141", "辽宁省本溪市",
"861868329", "四川省成都市",
"861576617", "广东省肇庆市",
"86130337", "河南省信阳市",
"861500391", "河南省焦作市",
"86183406", "辽宁省营口市",
"861471964", "甘肃省武威市",
"861895676", "安徽省亳州市",
"861537226", "浙江省丽水市",
"861392677", "广东省汕头市",
"861509457", "黑龙江省伊春市",
"861529499", "河南省周口市",
"861846204", "山东省青岛市",
"861532793", "湖北省襄樊市",
"861345368", "山西省临汾市",
"861369578", "浙江省丽水市",
"861551430", "河南省濮阳市",
"861339055", "辽宁省沈阳市",
"861813414", "河北省邯郸市",
"86181011", "北京市",
"861337301", "河北省石家庄市",
"861818948", "甘肃省酒泉市",
"861568299", "甘肃省陇南市",
"861862734", "湖南省衡阳市",
"861535970", "福建省宁德市",
"861819154", "陕西省渭南市",
"861361155", "江苏省连云港市",
"861390496", "辽宁省锦州市",
"861557717", "广西崇左市",
"861306214", "福建省莆田市",
"861829879", "甘肃省白银市",
"861772925", "陕西省安康市",
"861780079", "青海省海西蒙古族藏族自治州",
"861450636", "黑龙江省绥化市",
"861378741", "湖南省长沙市",
"861850645", "山东省潍坊市",
"861779088", "辽宁省锦州市",
"861830551", "安徽省合肥市",
"861321930", "四川省巴中市",
"861818735", "云南省红河哈尼族彝族自治州",
"861304639", "广东省珠海市",
"861869350", "甘肃省武威市",
"861572054", "安徽省淮南市",
"861327721", "湖北省黄冈市",
"861856703", "河南省开封市",
"861368472", "内蒙古包头市",
"861479183", "陕西省西安市",
"861807806", "广西梧州市",
"86150850", "贵州省遵义市",
"861536333", "广东省肇庆市",
"861318446", "浙江省台州市",
"861776899", "江苏省连云港市",
"861359999", "福建省泉州市",
"861817159", "湖北省襄樊市",
"861312556", "辽宁省丹东市",
"861450628", "黑龙江省牡丹江市",
"861785852", "浙江省绍兴市",
"861890998", "新疆喀什地区",
"861333700", "内蒙古巴彦淖尔市",
"86152117", "湖南省郴州市",
"861305401", "湖南省郴州市",
"861310607", "浙江省衢州市",
"861855198", "江苏省南京市",
"861533149", "云南省楚雄彝族自治州",
"8613820", "天津市",
"861331798", "江西省景德镇市",
"861787572", "广东省茂名市",
"861595990", "福建省南平市",
"861357613", "江西省南昌市",
"861569843", "山西省阳泉市",
"861302497", "福建省龙岩市",
"861805496", "福建省漳州市",
"861893634", "江苏省盐城市",
"861573907", "新疆乌鲁木齐市",
"861316047", "江苏省南京市",
"861322459", "黑龙江省大庆市",
"86155948", "陕西省西安市",
"861817877", "广西钦州市",
"861339753", "湖南省株洲市",
"861317255", "广东省潮州市",
"861398534", "贵州省铜仁地区",
"86135562", "广东省惠州市",
"861361852", "贵州省遵义市",
"861330476", "内蒙古赤峰市",
"86151402", "辽宁省沈阳市",
"861824488", "湖南省常德市",
"861512891", "河北省邯郸市",
"861570864", "贵州省黔南布依族苗族自治州",
"861389714", "青海省海南藏族自治州",
"861807485", "广西玉林市",
"861586379", "山东省济南市",
"861589997", "广东省广州市",
"861777112", "湖北省襄樊市",
"861560237", "广东省云浮市",
"861566224", "吉林省长春市",
"861807194", "湖北省十堰市",
"861835696", "安徽省合肥市",
"86135956", "贵州省铜仁地区",
"86138075", "海南省海口市",
"861317210", "广东省广州市",
"861562408", "山东省济宁市",
"861328549", "山东省临沂市",
"86150189", "广东省深圳市",
"861516645", "山东省日照市",
"861823649", "河南省驻马店市",
"861761458", "黑龙江省伊春市",
"861863373", "河北省沧州市",
"861874747", "内蒙古乌兰察布市",
"8617792", "陕西省西安市",
"861562478", "内蒙古巴彦淖尔市",
"86159139", "广东省汕头市",
"861595376", "山东省德州市",
"861338647", "山东省东营市",
"861707846", "云南省德宏傣族景颇族自治州",
"861363707", "安徽省合肥市",
"861840868", "宁夏固原市",
"861320674", "黑龙江省哈尔滨市",
"861302557", "广东省肇庆市",
"86170728", "四川省成都市",
"861322599", "福建省福州市",
"86188916", "陕西省汉中市",
"861807267", "浙江省丽水市",
"861528520", "贵州省遵义市",
"861330406", "辽宁省锦州市",
"861506532", "山东省青岛市",
"861301149", "河北省邯郸市",
"861573977", "新疆阿克苏地区",
"861787502", "广东省云浮市",
"861786921", "云南省德宏傣族景颇族自治州",
"861360535", "山东省烟台市",
"861550345", "山西省太原市",
"861843623", "河南省焦作市",
"861763500", "山西省忻州市",
"861534341", "山西省太原市",
"861538045", "江苏省常州市",
"861518841", "河南省漯河市",
"861362690", "福建省莆田市",
"861333770", "江苏省南京市",
"86152110", "湖南省长沙市",
"86132533", "河南省郑州市",
"861357142", "陕西省安康市",
"86189211", "江苏省无锡市",
"861515877", "浙江省衢州市",
"861768808", "广东省湛江市",
"861575603", "安徽省铜陵市",
"861850813", "四川省自贡市",
"861856123", "山东省东营市",
"861842058", "广东省清远市",
"861777643", "广西玉林市",
"861303742", "湖南省湘西土家族苗族自治州",
"861505485", "山东省济宁市",
"861348795", "湖南省邵阳市",
"861310677", "广东省阳江市",
"861309625", "四川省眉山市",
"861537696", "山东省烟台市",
"861882037", "广东省潮州市",
"861354881", "湖南省娄底市",
"861325863", "黑龙江省大庆市",
"86132296", "广东省汕头市",
"861839935", "新疆喀什地区",
"861530871", "云南省昆明市",
"86189122", "江苏省南通市",
"861330885", "云南省昆明市",
"861509027", "河南省许昌市",
"861800691", "福建省福州市",
"861815497", "新疆喀什地区",
"861306046", "陕西省汉中市",
"861801245", "江苏省无锡市",
"861520663", "山东省日照市",
"861356307", "山东省滨州市",
"86150857", "贵州省毕节地区",
"861339425", "辽宁省丹东市",
"861530230", "广东省佛山市",
"861811032", "安徽省淮北市",
"861535685", "浙江省绍兴市",
"861351867", "山东省济宁市",
"861372389", "湖南省长沙市",
"861535900", "福建省福州市",
"861593334", "河北省邢台市",
"861896959", "浙江省丽水市",
"861370452", "黑龙江省齐齐哈尔市",
"861853838", "河南省信阳市",
"861521631", "山东省威海市",
"861538743", "湖南省湘西土家族苗族自治州",
"861867907", "江西省赣州市",
"861368853", "贵州省安顺市",
"861535396", "陕西省渭南市",
"86155246", "辽宁省大连市",
"861839748", "湖南省常德市",
"861568941", "山东省济南市",
"861337371", "河南省安阳市",
"861760669", "广东省东莞市",
"861816345", "广东省东莞市",
"861770858", "贵州省六盘水市",
"861390556", "安徽省安庆市",
"861572424", "浙江省温州市",
"861369508", "福建省南平市",
"861361584", "浙江省丽水市",
"861597676", "广东省汕尾市",
"861308619", "江西省萍乡市",
"861590891", "山东省烟台市",
"86139387", "河南省新乡市",
"861577540", "四川省凉山彝族自治州",
"861384852", "内蒙古包头市",
"861355731", "广西南宁市",
"861890565", "安徽省巢湖市",
"861888204", "四川省自贡市",
"861826260", "江苏省南京市",
"861375707", "浙江省湖州市",
"861306923", "吉林省延边朝鲜族自治州",
"861840544", "山东省德州市",
"861830908", "新疆克孜勒苏柯尔克孜自治州",
"861869031", "新疆乌鲁木齐市",
"861856075", "山东省济南市",
"861357845", "云南省楚雄彝族自治州",
"861338419", "辽宁省辽阳市",
"861353630", "广东省惠州市",
"861890471", "内蒙古呼和浩特市",
"861510773", "广西桂林市",
"861361473", "内蒙古乌海市",
"861452416", "辽宁省锦州市",
"861454609", "青海省海西蒙古族藏族自治州",
"861399784", "湖北省十堰市",
"86151445", "吉林省通化市",
"861566694", "山东省泰安市",
"861772068", "福建省南平市",
"861337623", "江苏省无锡市",
"861584931", "内蒙古乌海市",
"861361630", "山东省威海市",
"861325703", "江西省上饶市",
"861332482", "广西柳州市",
"861700000", "北京市",
"861313242", "河北省衡水市",
"86184540", "山东省菏泽市",
"861322376", "河南省新乡市",
"861330359", "山西省运城市",
"861303035", "河南省三门峡市",
"861345149", "河北省石家庄市",
"861508511", "贵州省遵义市",
"86133561", "浙江省温州市",
"861512423", "辽宁省营口市",
"861888666", "四川省广元市",
"86170843", "吉林省长春市",
"861586456", "山东省潍坊市",
"861533437", "云南省红河哈尼族彝族自治州",
"861302304", "安徽省芜湖市",
"861536890", "云南省西双版纳傣族自治州",
"861470463", "黑龙江省牡丹江市",
"861888818", "江苏省苏州市",
"861597197", "湖北省武汉市",
"861839504", "宁夏固原市",
"861328940", "陕西省咸阳市",
"861348851", "内蒙古呼和浩特市",
"86186705", "湖南省郴州市",
"861347547", "山东省济宁市",
"861868006", "广东省东莞市",
"86153677", "湖南省常德市",
"861560736", "湖南省常德市",
"861773140", "河北省石家庄市",
"861892171", "江苏省泰州市",
"861370763", "河南省南阳市",
"861556101", "内蒙古呼和浩特市",
"861372152", "贵州省毕节地区",
"861364395", "河南省漯河市",
"861867512", "广东省韶关市",
"861398146", "四川省达州市",
"861769821", "河南省新乡市",
"861889345", "甘肃省兰州市",
"861879475", "甘肃省兰州市",
"861760481", "内蒙古呼和浩特市",
"861570774", "广西梧州市",
"86182662", "山东省枣庄市",
"861778627", "湖北省随州市",
"861845245", "江苏省镇江市",
"861396308", "山东省滨州市",
"86159596", "福建省漳州市",
"861830002", "广东省清远市",
"861598981", "广东省汕头市",
"861538732", "湖南省湘潭市",
"861397203", "湖北省宜昌市",
"861576814", "广东省深圳市",
"861807048", "江西省赣州市",
"861388655", "湖北省荆州市",
"86157342", "辽宁省鞍山市",
"861819679", "安徽省马鞍山市",
"86155016", "江苏省苏州市",
"861356554", "新疆石河子市",
"861553464", "山西省晋城市",
"861893837", "广东省茂名市",
"861817674", "广西河池市",
"861378954", "内蒙古乌兰察布市",
"861514560", "黑龙江省黑河市",
"861303733", "湖南省株洲市",
"86159679", "浙江省金华市",
"861827218", "湖北省咸宁市",
"861771566", "江苏省南京市",
"861325005", "广东省珠海市",
"86136968", "福建省福州市",
"861804215", "浙江省台州市",
"861777632", "广西柳州市",
"861865170", "江苏省连云港市",
"861332894", "福建省宁德市",
"861314480", "广东省深圳市",
"861537727", "湖北省十堰市",
"861804250", "浙江省宁波市",
"861811043", "安徽省宿州市",
"861778164", "四川省自贡市",
"861762526", "江苏省苏州市",
"861393811", "河南省三门峡市",
"861320807", "浙江省宁波市",
"861590755", "广东省深圳市",
"861310196", "江苏省无锡市",
"861763332", "河北省保定市",
"861379148", "山东省菏泽市",
"861899454", "江苏省连云港市",
"861535579", "浙江省金华市",
"86731", "湖南省长沙市\、湘潭市\、株州市",
"861812522", "广东省中山市",
"86157773", "广西桂林市",
"861552550", "山西省晋城市",
"861870056", "陕西省商洛市",
"861377920", "新疆石河子市",
"861870782", "广西柳州市",
"861300264", "浙江省衢州市",
"861335323", "吉林省白城市",
"861782827", "四川省内江市",
"861537859", "四川省广安市",
"861877430", "湖南省湘西土家族苗族自治州",
"861881527", "浙江省宁波市",
"861367749", "湖南省长沙市",
"861560728", "湖北省十堰市",
"861351707", "江西省赣州市",
"861824743", "内蒙古乌兰察布市",
"861506543", "山东省滨州市",
"861552515", "山西省长治市",
"861835107", "江苏省苏州市",
"861813849", "广东省佛山市",
"861458109", "安徽省宣城市",
"861874014", "辽宁省本溪市",
"86181616", "宁夏吴忠市",
"861310804", "陕西省宝鸡市",
"861808388", "云南省普洱市",
"861829769", "安徽省黄山市",
"861526845", "浙江省绍兴市",
"861832463", "黑龙江省牡丹江市",
"861332176", "广西百色市",
"861324347", "河南省驻马店市",
"861351777", "广西钦州市",
"86189263", "广东省阳江市",
"861569832", "山西省太原市",
"861590423", "辽宁省阜新市",
"86152632", "山东省枣庄市",
"861558384", "四川省德阳市",
"861766619", "广东省佛山市",
"861577949", "江西省景德镇市",
"861771881", "广东省汕头市",
"861803910", "河南省郑州市",
"861310874", "云南省曲靖市",
"861589645", "江苏省南京市",
"861593416", "山西省晋城市",
"861890092", "辽宁省沈阳市",
"861332945", "黑龙江省绥化市",
"861523903", "河南省焦作市",
"861567170", "湖北省黄冈市",
"861337293", "辽宁省铁岭市",
"861319795", "江西省宜春市",
"861534712", "湖北省恩施土家族苗族自治州",
"861827607", "广西百色市",
"861341998", "河南省信阳市",
"861374332", "吉林省长春市",
"861358429", "江苏省苏州市",
"861389047", "四川省内江市",
"861844729", "内蒙古锡林郭勒盟",
"861332726", "湖南省永州市",
"861835727", "浙江省湖州市",
"86159415", "辽宁省丹东市",
"861586026", "福建省福州市",
"8615313", "北京市",
"861320266", "广东省东莞市",
"861803955", "河南省郑州市",
"861528641", "贵州省铜仁地区",
"861870438", "吉林省松原市",
"861768923", "福建省莆田市",
"861858939", "云南省昭通市",
"86139376", "河南省信阳市",
"861529950", "新疆克拉玛依市",
"861500203", "广东省广州市",
"86187573", "浙江省嘉兴市",
"861319523", "贵州省安顺市",
"861780338", "河北省承德市",
"861303311", "安徽省马鞍山市",
"861504531", "黑龙江省牡丹江市",
"861865100", "江苏省无锡市",
"86147592", "福建省厦门市",
"861338844", "浙江省舟山市",
"861536342", "广东省佛山市",
"861303966", "黑龙江省伊春市",
"861320877", "云南省玉溪市",
"861539582", "浙江省杭州市",
"861709416", "广东省珠海市",
"861309662", "山西省临汾市",
"861817604", "广西钦州市",
"861452334", "河南省南阳市",
"861588427", "四川省德阳市",
"861559049", "吉林省松原市",
"861899594", "湖北省十堰市",
"861537107", "江苏省无锡市",
"861838141", "四川省资阳市",
"861525081", "江苏省无锡市",
"861803337", "广东省云浮市",
"861398680", "湖北省宜昌市",
"86157608", "海南省海口市",
"861305522", "福建省厦门市",
"861510863", "云南省德宏傣族景颇族自治州",
"861875291", "江苏省盐城市",
"861893580", "新疆塔城地区",
"861339462", "黑龙江省齐齐哈尔市",
"861822789", "四川省乐山市",
"861398905", "西藏昌都地区",
"861839483", "甘肃省定西市",
"861308139", "辽宁省本溪市",
"861305092", "辽宁省朝阳市",
"861780326", "河北省廊坊市",
"861538488", "内蒙古鄂尔多斯市",
"861803468", "甘肃省定西市",
"861306808", "山西省太原市",
"861815682", "安徽省合肥市",
"861374979", "河南省南阳市",
"861840778", "广西河池市",
"861831611", "广东省肇庆市",
"861800040", "河北省邯郸市",
"86181241", "广东省深圳市",
"861809683", "新疆昌吉回族自治州",
"861459715", "山东省烟台市",
"861392196", "江苏省苏州市",
"861335252", "黑龙江省齐齐哈尔市",
"861815304", "河南省驻马店市",
"861768046", "湖南省岳阳市",
"86188048", "内蒙古兴安盟",
"86186373", "河南省新乡市",
"861353110", "广东省湛江市",
"861362041", "广东省广州市",
"861556171", "黑龙江省双鸭山市",
"861879405", "甘肃省临夏回族自治州",
"86150283", "河北省张家口市",
"861319093", "内蒙古赤峰市",
"861801411", "江苏省盐城市",
"861338568", "安徽省六安市",
"861580780", "广西南宁市",
"86188982", "海南省海口市",
"861850997", "新疆阿克苏地区",
"861351664", "广东省佛山市",
"861864527", "黑龙江省佳木斯市",
"861879153", "陕西省渭南市",
"861322990", "河北省唐山市",
"861848585", "贵州省六盘水市",
"86134069", "山东省济南市",
"861311058", "福建省三明市",
"861586596", "山东省临沂市",
"861876539", "山东省临沂市",
"861346610", "云南省曲靖市",
"861333860", "江苏省南京市",
"861885788", "浙江省杭州市",
"86185633", "山东省日照市",
"86177038", "河南省郑州市",
"861808235", "江苏省泰州市",
"861890522", "江苏省徐州市",
"861454585", "甘肃省金昌市",
"861530761", "广东省中山市",
"861363206", "广东省江门市",
"86189796", "江西省吉安市",
"86136266", "浙江省台州市",
"86184547", "山东省济宁市",
"861806600", "江苏省泰州市",
"861870426", "辽宁省盘锦市",
"86187488", "贵州省黔西南布依族苗族自治州",
"861523168", "河北省承德市",
"861856863", "河南省新乡市",
"861560963", "安徽省芜湖市",
"861528929", "陕西省铜川市",
"861332738", "湖南省娄底市",
"861820939", "甘肃省陇南市",
"861339630", "山东省威海市",
"8615210", "北京市",
"861840965", "宁夏中卫市",
"861773040", "安徽省芜湖市",
"861812192", "四川省南充市",
"86155285", "四川省绵阳市",
"86185250", "辽宁省沈阳市",
"861329889", "吉林省四平市",
"861550641", "山东省菏泽市",
"86137251", "广东省广州市",
"86186715", "湖北省咸宁市",
"861770468", "福建省厦门市",
"861358266", "河北省廊坊市",
"861320429", "辽宁省葫芦岛市",
"861324249", "广东省江门市",
"861352319", "河南省焦作市",
"861707728", "江西省宜春市",
"861355841", "广西南宁市",
"861319505", "宁夏吴忠市",
"861357735", "云南省曲靖市",
"861855144", "江苏省连云港市",
"861590886", "云南省怒江傈僳族自治州",
"861309430", "云南省玉溪市",
"861867243", "湖北省荆门市",
"861331744", "湖南省张家界市",
"861303135", "新疆博尔塔拉蒙古自治州",
"861334047", "福建省宁德市",
"86159442", "吉林省吉林市",
"861370862", "云南省德宏傣族景颇族自治州",
"86138272", "广东省东莞市",
"861707178", "江西省鹰潭市",
"861857446", "湖南省永州市",
"861478904", "西藏林芝地区",
"861335375", "河南省平顶山市",
"86155006", "青海省西宁市",
"861535381", "陕西省宝鸡市",
"861858210", "四川省广安市",
"861519866", "云南省丽江市",
"861800395", "河南省漯河市",
"861787563", "广东省东莞市",
"86180338", "河北省石家庄市",
"86151486", "内蒙古锡林郭勒盟",
"861511312", "广东省汕头市",
"861807148", "湖北省黄石市",
"861816929", "湖南省怀化市",
"861780654", "广东省肇庆市",
"861535799", "安徽省淮南市",
"861768905", "西藏昌都地区",
"861864718", "内蒙古鄂尔多斯市",
"861853748", "河南省漯河市",
"861700413", "辽宁省鞍山市",
"861340956", "宁夏石嘴山市",
"86180635", "山东省聊城市",
"861309321", "湖北省荆门市",
"861538833", "四川省宜宾市",
"861313513", "湖南省株洲市",
"861519618", "四川省凉山彝族自治州",
"861452658", "江西省景德镇市",
"861880368", "河南省南阳市",
"86150420", "辽宁省铁岭市",
"861554978", "湖北省荆门市",
"86177576", "浙江省台州市",
"861330988", "辽宁省沈阳市",
"861372786", "广东省珠海市",
"861839838", "四川省甘孜藏族自治州",
"861770910", "陕西省西安市",
"861470521", "江苏省徐州市",
"8617638", "河南省郑州市",
"861359120", "辽宁省鞍山市",
"861453946", "广东省江门市",
"861380927", "广东省东莞市",
"861537681", "山东省淄博市",
"861811143", "四川省自贡市",
"861354896", "湖南省长沙市",
"861337675", "广东省潮州市",
"861459642", "甘肃省陇南市",
"861808959", "四川省攀枝花市",
"86188381", "河南省郑州市",
"861880437", "吉林省辽源市",
"86150156", "广东省佛山市",
"86133168", "广东省深圳市",
"861800686", "浙江省台州市",
"86176376", "河南省信阳市",
"861527279", "湖北省孝感市",
"861897709", "广西南宁市",
"861536969", "河北省秦皇岛市",
"861812895", "广东省河源市",
"86183482", "河南省焦作市",
"86181832", "四川省内江市",
"861840458", "黑龙江省伊春市",
"861325105", "浙江省温州市",
"861839826", "四川省雅安市",
"86181125", "江苏省苏州市",
"861310538", "山东省泰安市",
"861359770", "湖北省黄石市",
"861770955", "宁夏中卫市",
"861380411", "辽宁省大连市",
"861459470", "陕西省安康市",
"861820372", "河南省安阳市",
"861572679", "西藏拉萨市",
"861537077", "江苏省苏州市",
"861870883", "云南省临沧市",
"861866829", "浙江省宁波市",
"861563662", "黑龙江省绥化市",
"861550929", "陕西省安康市",
"861396619", "安徽省宣城市",
"86181606", "新疆乌鲁木齐市",
"86151829", "四川省南充市",
"861818994", "西藏林芝地区",
"861569966", "黑龙江省哈尔滨市",
"861332006", "江西省吉安市",
"861587660", "广东省云浮市",
"861884574", "黑龙江省大兴安岭地区",
"861879423", "甘肃省兰州市",
"861530510", "江苏省盐城市",
"86184575", "浙江省绍兴市",
"861595129", "江苏省宿迁市",
"861398923", "四川省凉山彝族自治州",
"861524690", "黑龙江省双鸭山市",
"861597527", "广东省肇庆市",
"861521957", "广东省茂名市",
"861770337", "河北省沧州市",
"861501999", "广东省东莞市",
"861530555", "安徽省马鞍山市",
"861830805", "西藏昌都地区",
"861304019", "江苏省淮安市",
"861567000", "河南省安阳市",
"861810001", "北京市",
"861854801", "内蒙古巴彦淖尔市",
"861357948", "新疆巴音郭楞蒙古自治州",
"861554551", "黑龙江省绥化市",
"861344693", "西藏日喀则地区",
"861776569", "广东省珠海市",
"861325593", "福建省宁德市",
"861504982", "内蒙古巴彦淖尔市",
"861501241", "广东省广州市",
"861512153", "贵州省毕节地区",
"861354724", "四川省达州市",
"861459113", "广西来宾市",
"86183866", "贵州省黔东南苗族侗族自治州",
"861580816", "四川省绵阳市",
"861583072", "河北省邢台市",
"861569733", "湖南省株洲市",
"86137476", "内蒙古赤峰市",
"861395140", "江苏省镇江市",
"861389147", "陕西省咸阳市",
"86130724", "辽宁省沈阳市",
"861305895", "浙江省金华市",
"861366692", "福建省莆田市",
"861479466", "黑龙江省鸡西市",
"861454424", "江苏省扬州市",
"861810071", "湖北省武汉市",
"861882617", "广东省江门市",
"861599782", "湖北省十堰市",
"861539931", "陕西省渭南市",
"861830875", "云南省保山市",
"861450244", "河北省承德市",
"861330257", "广东省湛江市",
"861595709", "浙江省舟山市",
"861567070", "河南省洛阳市",
"861530495", "辽宁省丹东市",
"861814633", "青海省海东地区",
"861839794", "江西省抚州市",
"86180846", "海南省海口市",
"86354", "山西省晋中市",
"861354174", "四川省绵阳市",
"86150665", "山东省德州市",
"861708487", "河南省信阳市",
"861534813", "四川省乐山市",
"861805481", "福建省厦门市",
"861537518", "安徽省安庆市",
"861874580", "黑龙江省伊春市",
"861300097", "黑龙江省佳木斯市",
"861315251", "广西南宁市",
"861332076", "四川省南充市",
"861453453", "安徽省合肥市",
"86152816", "四川省绵阳市",
"861359700", "广西南宁市",
"861818845", "四川省雅安市",
"86157618", "贵州省贵阳市",
"861554163", "辽宁省锦州市",
"861324408", "吉林省四平市",
"861561582", "山东省东营市",
"861559149", "陕西省安康市",
"861572609", "山东省德州市",
"861366353", "山西省阳泉市",
"86157941", "浙江省杭州市",
"861459400", "云南省红河哈尼族彝族自治州",
"861570454", "黑龙江省佳木斯市",
"861337605", "江苏省南京市",
"861847415", "湖南省娄底市",
"861325725", "湖北省恩施土家族苗族自治州",
"861822947", "湖南省长沙市",
"861566648", "山东省青岛市",
"861333999", "湖北省武汉市",
"861865000", "福建省厦门市",
"861512405", "辽宁省朝阳市",
"861871528", "安徽省芜湖市",
"861527209", "湖北省荆门市",
"861361462", "黑龙江省齐齐哈尔市",
"861342835", "广东省佛山市",
"861510762", "广东省河源市",
"861889520", "宁夏银川市",
"861390481", "黑龙江省哈尔滨市",
"861861483", "内蒙古包头市",
"861529204", "湖南省岳阳市",
"861772349", "四川省成都市",
"861327552", "安徽省蚌埠市",
"861590475", "内蒙古通辽市",
"861846499", "山东省日照市",
"861319193", "河北省沧州市",
"861889090", "新疆塔城地区",
"861899774", "新疆喀什地区",
"861863362", "河北省保定市",
"861705019", "福建省厦门市",
"861556071", "内蒙古呼和浩特市",
"86159650", "山东省潍坊市",
"861891432", "江苏省常州市",
"86189685", "浙江省台州市",
"861830722", "湖北省随州市",
"861883084", "河北省衡水市",
"861871536", "安徽省淮南市",
"861369637", "山东省济宁市",
"861800140", "江苏省淮安市",
"861471545", "广东省揭阳市",
"861557144", "湖北省荆州市",
"861590561", "安徽省淮北市",
"861862844", "陕西省渭南市",
"861825448", "山东省枣庄市",
"861378831", "广西南宁市",
"861894413", "江苏省南京市",
"861308039", "山西省朔州市",
"861772836", "广东省中山市",
"861890895", "西藏昌都地区",
"86189388", "广东省深圳市",
"861868945", "广东省东莞市",
"861472875", "贵州省黔西南布依族苗族自治州",
"861300527", "广东省揭阳市",
"861319575", "青海省西宁市",
"861306534", "辽宁省阜新市",
"86182074", "湖南省长沙市",
"861853066", "河南省南阳市",
"861340443", "吉林省白城市",
"86158196", "广东省揭阳市",
"861351597", "福建省厦门市",
"861386689", "安徽省淮北市",
"86151862", "贵州省六盘水市",
"861453802", "四川省德阳市",
"86132701", "江苏省无锡市",
"861700720", "湖南省长沙市",
"861882449", "广东省东莞市",
"861871992", "新疆阿勒泰地区",
"861347780", "湖北省荆州市",
"861840922", "陕西省榆林市",
"86183416", "辽宁省锦州市",
"861530919", "陕西省铜川市",
"861315602", "山东省枣庄市",
"861806888", "江苏省盐城市",
"861363597", "江西省九江市",
"861319689", "江苏省宿迁市",
"861524041", "江苏省苏州市",
"861879891", "西藏拉萨市",
"861554002", "内蒙古兴安盟",
"861780857", "贵州省毕节地区",
"861339403", "福建省漳州市",
"861810552", "安徽省蚌埠市",
"861550520", "江苏省宿迁市",
"861458338", "江西省赣州市",
"861803858", "广东省梅州市",
"861818133", "四川省凉山彝族自治州",
"861776960", "浙江省嘉兴市",
"861332848", "福建省龙岩市",
"86134225", "广东省江门市",
"86138040", "辽宁省沈阳市",
"861479785", "江西省宜春市",
"861373180", "安徽省阜阳市",
"861309603", "四川省攀枝花市",
"861370825", "四川省内江市",
"86152466", "黑龙江省哈尔滨市",
"861598370", "四川省阿坝藏族羌族自治州",
"861832640", "安徽省宣城市",
"861529666", "山西省晋城市",
"861843605", "河南省安阳市",
"861802672", "广东省揭阳市",
"861336480", "新疆伊犁哈萨克自治州",
"861508800", "广东省佛山市",
"861364221", "广东省汕头市",
"86188208", "广东省佛山市",
"861891443", "江苏省泰州市",
"861360441", "吉林省长春市",
"861303650", "四川省宜宾市",
"86185481", "内蒙古呼和浩特市",
"861760556", "安徽省安庆市",
"861564990", "河南省商丘市",
"861380245", "广东省东莞市",
"861853483", "山西省晋中市",
"861518260", "四川省自贡市",
"861592946", "陕西省咸阳市",
"861390669", "浙江省宁波市",
"86133503", "重庆市",
"861855528", "安徽省六安市",
"861832472", "安徽省合肥市",
"86158769", "广东省东莞市",
"861884935", "河北省秦皇岛市",
"861325387", "河南省焦作市",
"861529818", "四川省宜宾市",
"861536560", "江苏省泰州市",
"861383896", "河南省南阳市",
"861306905", "吉林省松原市",
"861860639", "山东省临沂市",
"861338734", "湖南省衡阳市",
"8613821", "天津市",
"861308378", "河南省开封市",
"861594907", "江苏省扬州市",
"861874634", "黑龙江省佳木斯市",
"86187584", "浙江省宁波市",
"861872943", "陕西省渭南市",
"861453762", "广西南宁市",
"861846950", "云南省文山壮族苗族自治州",
"861504088", "辽宁省朝阳市",
"861560902", "四川省德阳市",
"861509707", "甘肃省平凉市",
"861470640", "山东省济南市",
"861778506", "贵州省铜仁地区",
"861525096", "江苏省南京市",
"861351383", "河南省安阳市",
"861376812", "广西柳州市",
"861352537", "河南省平顶山市",
"861532573", "浙江省嘉兴市",
"861831315", "云南省大理白族自治州",
"861822695", "安徽省池州市",
"861581376", "广东省江门市",
"861327687", "浙江省温州市",
"861370772", "广西柳州市",
"86158539", "山东省临沂市",
"861369798", "江西省景德镇市",
"861571446", "吉林省白城市",
"86151477", "内蒙古鄂尔多斯市",
"861332564", "新疆乌鲁木齐市",
"861569742", "湖南省常德市",
"861500947", "甘肃省酒泉市",
"861531843", "山东省枣庄市",
"861458326", "江西省吉安市",
"861339852", "贵州省遵义市",
"86188522", "江苏省徐州市",
"861332329", "河北省唐山市",
"861820530", "山东省菏泽市",
"861887213", "湖北省恩施土家族苗族自治州",
"861777012", "江西省赣州市",
"861476000", "福建省厦门市",
"861807094", "广西南宁市",
"861582539", "宁夏固原市",
"861343799", "江西省萍乡市",
"86155601", "河南省新乡市",
"861814642", "新疆乌鲁木齐市",
"861773691", "河北省石家庄市",
"86151412", "辽宁省鞍山市",
"86186967", "重庆市",
"861538390", "河北省石家庄市",
"861363027", "陕西省汉中市",
"861317684", "山东省德州市",
"861571953", "宁夏吴忠市",
"861898670", "湖北省荆州市",
"861821812", "广东省河源市",
"861899864", "广东省阳江市",
"861397262", "湖北省武汉市",
"86182436", "吉林省白城市",
"861596511", "山东省枣庄市",
"861379942", "福建省福州市",
"86157784", "广西梧州市",
"861478535", "贵州省六盘水市",
"861830063", "河南省焦作市",
"861862419", "辽宁省辽阳市",
"861367839", "四川省广元市",
"861772903", "陕西省渭南市",
"861768534", "贵州省贵阳市",
"861510593", "福建省莆田市",
"861827096", "江西省吉安市",
"861301049", "福建省宁德市",
"861329937", "甘肃省酒泉市",
"861391458", "江苏省镇江市",
"861538976", "内蒙古赤峰市",
"861367346", "河南省信阳市",
"86185883", "广东省深圳市",
"861861357", "山西省临汾市",
"861365514", "江苏省连云港市",
"861475757", "浙江省绍兴市",
"861551662", "河南省新乡市",
"861375457", "河北省沧州市",
"861872456", "黑龙江省黑河市",
"861399161", "陕西省汉中市",
"86188739", "湖南省邵阳市",
"861898442", "贵州省六盘水市",
"861813739", "河南省新乡市",
"861354659", "山西省运城市",
"861458285", "福建省莆田市",
"861507669", "河北省沧州市",
"861811132", "四川省阿坝藏族羌族自治州",
"861387434", "湖南省益阳市",
"861323545", "湖北省恩施土家族苗族自治州",
"861329310", "河北省邢台市",
"86183595", "福建省泉州市",
"861535254", "新疆塔城地区",
"861337589", "浙江省金华市",
"861399493", "山西省朔州市",
"86158722", "湖北省襄樊市",
"861509127", "陕西省渭南市",
"861771174", "湖南省张家界市",
"861310181", "江苏省泰州市",
"861385136", "江苏省宿迁市",
"861454318", "黑龙江省鹤岗市",
"861370702", "江西省赣州市",
"861303843", "陕西省渭南市",
"861325762", "广东省河源市",
"861774027", "四川省南充市",
"861308308", "安徽省合肥市",
"861594977", "山东省临沂市",
"861537469", "内蒙古乌兰察布市",
"861329355", "山西省长治市",
"861856023", "山东省济南市",
"861810884", "云南省曲靖市",
"861306975", "黑龙江省佳木斯市",
"861766039", "山东省枣庄市",
"861327001", "江苏省扬州市",
"861510946", "甘肃省庆阳市",
"861335187", "黑龙江省鸡西市",
"861581990", "广东省江门市",
"861572585", "山东省泰安市",
"861361425", "辽宁省丹东市",
"861364691", "福建省三明市",
"861856872", "河南省新乡市",
"861560972", "青海省海东地区",
"861510725", "湖北省黄冈市",
"861598996", "广东省佛山市",
"861821150", "广东省茂名市",
"86137487", "黑龙江省牡丹江市",
"861808490", "四川省广安市",
"861817429", "湖南省常德市",
"861580547", "山东省济宁市",
"861830765", "广东省肇庆市",
"861539464", "江苏省连云港市",
"86150879", "云南省普洱市",
"861453387", "内蒙古通辽市",
"861470853", "贵州省安顺市",
"86134548", "浙江省温州市",
"861832402", "新疆喀什地区",
"861317939", "江苏省镇江市",
"861505524", "安徽省六安市",
"86156937", "甘肃省酒泉市",
"861538842", "四川省宜宾市",
"861598300", "四川省泸州市",
"861889929", "新疆和田地区",
"861564376", "吉林省辽源市",
"861374790", "内蒙古锡林郭勒盟",
"861508231", "四川省甘孜藏族自治州",
"861502939", "陕西省铜川市",
"861861748", "河北省保定市",
"861475348", "山东省青岛市",
"861348575", "安徽省滁州市",
"861341944", "四川省乐山市",
"861339584", "浙江省宁波市",
"861336344", "山西省太原市",
"861579401", "广东省广州市",
"861772168", "江苏省常州市",
"861534997", "新疆克孜勒苏柯尔克孜自治州",
"861810492", "辽宁省鞍山市",
"861878614", "贵州省贵阳市",
"861501415", "广东省广州市",
"861350549", "山东省临沂市",
"861592453", "内蒙古赤峰市",
"861566567", "安徽省亳州市",
"861363457", "黑龙江省大庆市",
"861315440", "四川省阿坝藏族羌族自治州",
"861322129", "浙江省金华市",
"861501450", "广东省中山市",
"86156028", "广东省佛山市",
"86152882", "云南省昆明市",
"861860984", "辽宁省大连市",
"861891956", "四川省成都市",
"861369834", "四川省雅安市",
"861862647", "江苏省淮安市",
"861365646", "山东省潍坊市",
"861554823", "内蒙古兴安盟",
"861897283", "湖北省咸宁市",
"861366487", "内蒙古包头市",
"86188569", "安徽省合肥市",
"861339473", "内蒙古乌海市",
"861856725", "河南省南阳市",
"861896388", "新疆阿克苏地区",
"861881676", "广东省深圳市",
"861899548", "宁夏中卫市",
"861508988", "广东省韶关市",
"861890737", "湖南省益阳市",
"861831427", "云南省大理白族自治州",
"861505633", "安徽省宣城市",
"861320535", "山东省烟台市",
"861822898", "四川省泸州市",
"861865494", "山东省济南市",
"861306301", "福建省漳州市",
"861894783", "内蒙古阿拉善盟",
"861315108", "江苏省南京市",
"861514481", "内蒙古通辽市",
"861309247", "江苏省宿迁市",
"861331937", "江西省景德镇市",
"861809983", "新疆伊犁哈萨克自治州",
"861586643", "山东省临沂市",
"861340324", "河北省承德市",
"861346337", "河北省秦皇岛市",
"861552896", "四川省宜宾市",
"861882563", "广东省珠海市",
"861819909", "新疆阿克苏地区",
"861314561", "安徽省淮北市",
"861360674", "浙江省宁波市",
"861459094", "广东省茂名市",
"861838779", "云南省玉溪市",
"861535433", "河北省秦皇岛市",
"861831911", "广东省汕头市",
"861362599", "福建省泉州市",
"86130036", "浙江省杭州市",
"861522478", "河南省商丘市",
"861453080", "安徽省合肥市",
"861323707", "江西省赣州市",
"861475313", "山东省济南市",
"861893505", "山西省临汾市",
"861560663", "浙江省温州市",
"861370636", "山东省东营市",
"861316525", "山东省东营市",
"86153900", "四川省成都市",
"861328402", "黑龙江省齐齐哈尔市",
"861346955", "宁夏吴忠市",
"861317019", "安徽省六安市",
"86136296", "云南省昆明市",
"861365863", "山东省济南市",
"861802178", "江苏省淮安市",
"861709810", "浙江省台州市",
"861844741", "内蒙古通辽市",
"861331355", "山西省长治市",
"861859162", "陕西省汉中市",
"861567554", "安徽省淮南市",
"861596406", "山东省滨州市",
"8618883", "重庆市",
"861477994", "江西省赣州市",
"861580003", "广东省广州市",
"861572811", "广东省深圳市",
"861857261", "湖北省荆州市",
"861450592", "辽宁省朝阳市",
"86187143", "黑龙江省齐齐哈尔市",
"861576502", "黑龙江省牡丹江市",
"86155554", "安徽省合肥市",
"861589738", "湖南省娄底市",
"861810749", "湖南省长沙市",
"861313704", "河南省洛阳市",
"861331310", "河北省邯郸市",
"861571730", "湖南省岳阳市",
"86134099", "湖北省黄冈市",
"86137192", "广东省广州市",
"861346910", "湖南省衡阳市",
"86158417", "辽宁省营口市",
"861528941", "陕西省榆林市",
"861898799", "云南省昆明市",
"861774431", "四川省绵阳市",
"861308555", "安徽省马鞍山市",
"861833410", "贵州省安顺市",
"861329508", "河南省开封市",
"861786540", "山东省菏泽市",
"861768623", "山东省日照市",
"86135485", "湖南省长沙市",
"861454500", "湖南省湘潭市",
"861705530", "河南省南阳市",
"861359856", "河南省信阳市",
"86153371", "湖北省武汉市",
"861370628", "江苏省南通市",
"86189536", "山东省潍坊市",
"861599412", "河南省安阳市",
"861359183", "辽宁省大连市",
"861337768", "广东省潮州市",
"861521464", "黑龙江省七台河市",
"861308510", "湖北省荆州市",
"861589726", "青海省海南藏族自治州",
"861384930", "河南省濮阳市",
"86139242", "广东省广州市",
"861569559", "安徽省黄山市",
"86158472", "内蒙古包头市",
"861561631", "湖南省衡阳市",
"861302445", "江苏省泰州市",
"861373289", "吉林省通化市",
"86189293", "广东省深圳市",
"861583537", "山西省大同市",
"861836806", "浙江省舟山市",
"861801164", "四川省泸州市",
"861321473", "内蒙古乌海市",
"861780270", "湖北省武汉市",
"861459369", "贵州省黔东南苗族侗族自治州",
"861761292", "陕西省渭南市",
"861339219", "广东省深圳市",
"86151720", "湖北省黄石市",
"861303818", "四川省内江市",
"861457099", "江苏省宿迁市",
"861454343", "山东省青岛市",
"86147956", "广西南宁市",
"861362029", "广东省揭阳市",
"861760560", "安徽省合肥市",
"861315963", "吉林省延边朝鲜族自治州",
"86131286", "广东省广州市",
"861780831", "四川省宜宾市",
"861459524", "云南省玉溪市",
"86157978", "江西省南昌市",
"861352978", "云南省玉溪市",
"861876110", "江苏省宿迁市",
"86130220", "广东省广州市",
"861591759", "广东省湛江市",
"86187019", "上海市",
"861303666", "四川省成都市",
"861329017", "山东省威海市",
"861533586", "湖北省荆门市",
"861309962", "云南省西双版纳傣族自治州",
"86150786", "广西河池市",
"861333327", "河北省沧州市",
"86178392", "河南省郑州市",
"861889404", "甘肃省兰州市",
"861580705", "江西省宜春市",
"861872918", "陕西省西安市",
"861356170", "山东省莱芜市",
"861815445", "湖北省襄樊市",
"861380399", "河南省郑州市",
"86159909", "山东省菏泽市",
"861830716", "湖北省荆州市",
"86176433", "吉林省延边朝鲜族自治州",
"861860363", "黑龙江省牡丹江市",
"861821259", "贵州省毕节地区",
"861869157", "陕西省西安市",
"861363431", "吉林省长春市",
"861580775", "广西玉林市",
"861536496", "山西省太原市",
"861380781", "广西南宁市",
"861812737", "广东省韶关市",
"861525907", "福建省宁德市",
"86159736", "湖南省常德市",
"861780200", "广东省广州市",
"861570967", "宁夏银川市",
"86136998", "广东省深圳市",
"861356720", "浙江省绍兴市",
"861348747", "湖南省永州市",
"861863417", "河北省唐山市",
"86155693", "新疆阿克苏地区",
"861589894", "山东省潍坊市",
"861573804", "河南省濮阳市",
"861311830", "四川省攀枝花市",
"861833173", "河北省廊坊市",
"861597833", "河南省三门峡市",
"861869879", "辽宁省盘锦市",
"861476307", "山东省滨州市",
"861479241", "安徽省宿州市",
"861550397", "河南省驻马店市",
"861588588", "贵州省毕节地区",
"861845824", "浙江省杭州市",
"861531818", "山东省济宁市",
"861363320", "河北省邯郸市",
"861887248", "湖北省武汉市",
"86181520", "甘肃省兰州市",
"861818567", "贵州省黔西南布依族苗族自治州",
"861308495", "广西贵港市",
"861321155", "广西玉林市",
"861308184", "河北省秦皇岛市",
"861388468", "山东省德州市",
"861808881", "广东省潮州市",
"861533861", "贵州省黔东南苗族侗族自治州",
"861329578", "浙江省丽水市",
"861589106", "陕西省汉中市",
"861522991", "陕西省咸阳市",
"86158410", "辽宁省铁岭市",
"861826069", "江苏省扬州市",
"861321110", "广东省清远市",
"861454570", "四川省成都市",
"861787617", "广东省佛山市",
"861345121", "湖北省荆门市",
"861569499", "河北省邯郸市",
"861338695", "福建省漳州市",
"861589482", "内蒙古呼伦贝尔市",
"861567185", "湖北省荆门市",
"861872460", "黑龙江省哈尔滨市",
"861314153", "江苏省连云港市",
"861302982", "黑龙江省大庆市",
"86157276", "江西省南昌市",
"861313774", "河南省平顶山市",
"861580822", "四川省自贡市",
"861595041", "江苏省无锡市",
"861452791", "新疆塔城地区",
"861771235", "江苏省扬州市",
"861328472", "内蒙古包头市",
"861367721", "湖北省随州市",
"861350752", "福建省龙岩市",
"861534076", "山西省阳泉市",
"861361930", "甘肃省白银市",
"861806970", "浙江省湖州市",
"86156172", "河南省许昌市",
"861348358", "河北省秦皇岛市",
"861596476", "山东省济宁市",
"861332813", "江苏省扬州市",
"861319246", "广东省惠州市",
"861368549", "山东省临沂市",
"861558339", "四川省德阳市",
"861819979", "新疆哈密地区",
"861852406", "辽宁省锦州市",
"861708198", "福建省漳州市",
"861863649", "山西省晋城市",
"861893575", "新疆巴音郭楞蒙古自治州",
"861769328", "甘肃省天水市",
"861323777", "广西贺州市",
"861587899", "广西北海市",
"861361317", "河北省沧州市",
"861473630", "广西桂林市",
"861325080", "浙江省杭州市",
"861477845", "广东省广州市",
"861700783", "广东省汕头市",
"861472716", "浙江省湖州市",
"86147529", "江苏省盐城市",
"861598681", "广东省深圳市",
"861390333", "河北省秦皇岛市",
"861315178", "江苏省徐州市",
"861475731", "浙江省宁波市",
"861503310", "河北省邯郸市",
"861304530", "黑龙江省牡丹江市",
"861509545", "甘肃省金昌市",
"861864488", "吉林省通化市",
"861555261", "山东省德州市",
"861314405", "广东省潮州市",
"861778927", "陕西省宝鸡市",
"861858984", "广西梧州市",
"86182692", "广西玉林市",
"861874093", "甘肃省定西市",
"861380064", "北京市",
"861329951", "宁夏银川市",
"861598077", "福建省厦门市",
"86185754", "广东省东莞市",
"861558846", "山东省枣庄市",
"861594526", "黑龙江省黑河市",
"861529843", "江苏省无锡市",
"861360382", "河南省郑州市",
"861321852", "江苏省盐城市",
"861893461", "湖北省襄樊市",
"86159952", "江苏省无锡市",
"861362459", "黑龙江省大庆市",
"861375431", "浙江省杭州市",
"861707440", "浙江省温州市",
"861812698", "广东省梅州市",
"861533701", "甘肃省天水市",
"861376826", "广西百色市",
"86180570", "浙江省衢州市",
"861824097", "新疆乌鲁木齐市",
"861893689", "江苏省南京市",
"861350463", "黑龙江省牡丹江市",
"861527170", "湖北省鄂州市",
"861302088", "河北省唐山市",
"861398589", "贵州省毕节地区",
"861867607", "广东省韶关市",
"861770351", "山西省太原市",
"861886979", "云南省怒江傈僳族自治州",
"861889397", "甘肃省酒泉市",
"861836048", "江苏省苏州市",
"86156632", "黑龙江省齐齐哈尔市",
"861390342", "山西省大同市",
"861521931", "广东省汕尾市",
"861337878", "云南省楚雄彝族自治州",
"86134571", "广西南宁市",
"86182742", "湖南省株洲市",
"861373773", "广西桂林市",
"861334573", "浙江省嘉兴市",
"861364347", "山西省太原市",
"861554537", "黑龙江省鹤岗市",
"861360159", "江苏省常州市",
"861896659", "陕西省延安市",
"861895390", "山东省聊城市",
"861894448", "江苏省扬州市",
"861550583", "浙江省嘉兴市",
"86132793", "陕西省西安市",
"861529832", "江苏省宿迁市",
"861887067", "江西省鹰潭市",
"861505113", "江苏省镇江市",
"861534329", "湖南省邵阳市",
"861335558", "安徽省阜阳市",
"861454909", "湖北省宜昌市",
"861565081", "安徽省宿州市",
"861518829", "河南省信阳市",
"86184186", "甘肃省兰州市",
"861882792", "江西省九江市",
"861517211", "湖北省黄石市",
"861476554", "浙江省杭州市",
"861507890", "广西北海市",
"861589227", "四川省广元市",
"861316562", "湖北省荆门市",
"86150712", "湖北省武汉市",
"861386246", "江苏省镇江市",
"861340418", "江苏省连云港市",
"861590398", "河南省三门峡市",
"86131277", "上海市",
"861534564", "安徽省六安市",
"86131121", "广东省揭阳市",
"861345586", "山东省威海市",
"861353930", "广东省佛山市",
"861458312", "江西省萍乡市",
"861811797", "四川省泸州市",
"8618417", "海南省海口市",
"86155372", "河南省安阳市",
"861338262", "江苏省盐城市",
"861880451", "黑龙江省哈尔滨市",
"861360877", "云南省玉溪市",
"86138385", "河南省郑州市",
"86150777", "广西玉林市",
"861304302", "河南省洛阳市",
"86158860", "吉林省四平市",
"861837442", "湖南省张家界市",
"861550474", "内蒙古乌兰察布市",
"86155317", "河北省沧州市",
"861301771", "浙江省绍兴市",
"861583319", "河北省邢台市",
"861336423", "辽宁省抚顺市",
"861807470", "广西南宁市",
"861800408", "辽宁省大连市",
"861569950", "吉林省长春市",
"861501785", "广东省东莞市",
"861394872", "内蒙古包头市",
"861308919", "吉林省通化市",
"861576051", "四川省绵阳市",
"861459148", "广西钦州市",
"861777596", "湖南省永州市",
"861523430", "山西省阳泉市",
"861872012", "江西省赣州市",
"861840916", "陕西省汉中市",
"86130631", "福建省漳州市",
"861322041", "甘肃省白银市",
"86182373", "河南省新乡市",
"861786621", "湖北省武汉市",
"861813553", "山西省太原市",
"861534848", "湖南省怀化市",
"861320974", "青海省海南藏族自治州",
"861346519", "山东省德州市",
"861862391", "河南省焦作市",
"861876630", "山东省威海市",
"861838869", "云南省昭通市",
"861814369", "吉林省白山市",
"861373075", "四川省宜宾市",
"861588131", "四川省自贡市",
"861300906", "吉林省白城市",
"86183190", "广东省深圳市",
"86177847", "重庆市",
"861351320", "河北省邯郸市",
"861458954", "广东省湛江市",
"861338947", "甘肃省酒泉市",
"861781773", "广东省深圳市",
"861520963", "宁夏吴忠市",
"861378109", "河南省平顶山市",
"861800991", "新疆乌鲁木齐市",
"861303274", "湖北省宜昌市",
"861535985", "福建省泉州市",
"861568929", "山东省淄博市",
"861523321", "河北省石家庄市",
"861335971", "黑龙江省哈尔滨市",
"86132266", "广东省广州市",
"861452855", "甘肃省兰州市",
"861323206", "广东省韶关市",
"861471707", "甘肃省平凉市",
"861768301", "四川省绵阳市",
"861537996", "甘肃省白银市",
"861539011", "四川省巴中市",
"861318392", "四川省自贡市",
"861376838", "广西河池市",
"861340960", "湖北省荆门市",
"861365773", "广西桂林市",
"861571261", "浙江省嘉兴市",
"861309746", "云南省曲靖市",
"861566613", "山东省青岛市",
"861828076", "四川省绵阳市",
"861890236", "广东省肇庆市",
"86155743", "湖南省长沙市",
"861803130", "河北省张家口市",
"861776432", "安徽省芜湖市",
"861850482", "内蒙古兴安盟",
"86137726", "陕西省宝鸡市",
"861530378", "河南省洛阳市",
"861705372", "海南省海口市",
"861362990", "新疆乌鲁木齐市",
"861597842", "河南省郑州市",
"861859822", "广东省江门市",
"861558078", "湖南省邵阳市",
"861809435", "江苏省南通市",
"861351431", "吉林省长春市",
"86157280", "浙江省宁波市",
"861575903", "福建省龙岩市",
"861500734", "湖南省衡阳市",
"861816474", "云南省红河哈尼族彝族自治州",
"861354388", "广东省珠海市",
"86136711", "北京市",
"861394946", "河南省平顶山市",
"861452810", "四川省成都市",
"861819500", "宁夏银川市",
"861520736", "湖南省常德市",
"861859003", "陕西省宝鸡市",
"861811118", "四川省泸州市",
"86182705", "江西省宜春市",
"861310907", "新疆伊犁哈萨克自治州",
"8615611", "北京市",
"861850738", "湖南省娄底市",
"861776788", "吉林省白城市",
"861819570", "青海省海东地区",
"861808074", "四川省广元市",
"861890698", "福建省三明市",
"861478429", "河南省周口市",
"861454332", "内蒙古包头市",
"861450928", "江苏省无锡市",
"861537370", "河北省衡水市",
"861329744", "湖南省张家界市",
"861368940", "甘肃省天水市",
"861705302", "上海市",
"861399739", "青海省海西蒙古族藏族自治州",
"861705684", "福建省厦门市",
"861335901", "安徽省合肥市",
"861378179", "河南省南阳市",
"861381347", "江苏省徐州市",
"86187249", "云南省临沧市",
"861312342", "广西柳州市",
"861365703", "江西省上饶市",
"86170923", "重庆市",
"861768371", "湖北省宜昌市",
"861331263", "云南省曲靖市",
"861476882", "山东省德州市",
"861773758", "河南省鹤壁市",
"861362376", "河南省信阳市",
"861323276", "广东省河源市",
"861775154", "江苏省盐城市",
"861553631", "山西省太原市",
"861320904", "新疆巴音郭楞蒙古自治州",
"861856080", "山东省济南市",
"861821838", "广东省梅州市",
"861868341", "四川省凉山彝族自治州",
"861813493", "山西省太原市",
"861853015", "河南省焦作市",
"861372334", "宁夏中卫市",
"861567307", "湖南省怀化市",
"861319747", "湖北省荆州市",
"861781703", "广东省韶关市",
"861332997", "湖北省鄂州市",
"86184637", "山东省济宁市",
"861323867", "云南省昆明市",
"86177840", "重庆市",
"861336053", "广东省深圳市",
"861593389", "河北省邯郸市",
"861300976", "黑龙江省佳木斯市",
"86183197", "广东省茂名市",
"861853050", "河南省三门峡市",
"861393424", "山西省太原市",
"86139012", "北京市",
"861472678", "四川省宜宾市",
"861894209", "湖南省永州市",
"86139681", "浙江省杭州市",
"861390890", "西藏拉萨市",
"861369651", "安徽省合肥市",
"861806579", "福建省三明市",
"861551349", "山西省运城市",
"861361539", "山东省临沂市",
"86185543", "山东省滨州市",
"861566142", "内蒙古赤峰市",
"861333083", "四川省达州市",
"86159323", "河北省张家口市",
"861324395", "辽宁省辽阳市",
"861306293", "江苏省镇江市",
"861357913", "新疆阿克苏地区",
"86135592", "福建省厦门市",
"861300145", "河北省邢台市",
"861823621", "河南省漯河市",
"861395249", "江苏省无锡市",
"861576917", "陕西省宝鸡市",
"86158867", "河南省平顶山市",
"861376794", "江西省景德镇市",
"861304372", "河南省安阳市",
"861508082", "湖南省娄底市",
"861880591", "福建省福州市",
"86150770", "广西南宁市",
"861539335", "甘肃省酒泉市",
"861347455", "陕西省咸阳市",
"861318840", "辽宁省铁岭市",
"861807400", "浙江省绍兴市",
"861821826", "广东省云浮市",
"861800478", "内蒙古巴彦淖尔市",
"861473110", "河北省石家庄市",
"861859705", "青海省果洛藏族自治州",
"861476185", "江苏省无锡市",
"861363964", "河南省驻马店市",
"86155310", "河北省邯郸市",
"861580865", "云南省玉溪市",
"86159895", "广东省深圳市",
"861301701", "贵州省黔东南苗族侗族自治州",
"861479450", "黑龙江省哈尔滨市",
"861867218", "湖北省荆门市",
"861836766", "浙江省台州市",
"86132968", "浙江省宁波市",
"861552659", "吉林省四平市",
"861877168", "湖北省孝感市",
"861815088", "福建省厦门市",
"86152542", "山东省青岛市",
"86131270", "山东省青岛市",
"861311393", "广东省中山市",
"861807113", "湖北省武汉市",
"861337808", "湖南省株洲市",
"861831282", "广东省茂名市",
"861330870", "云南省昭通市",
"861336755", "广西玉林市",
"861533121", "河南省洛阳市",
"861850726", "湖北省荆门市",
"861850945", "甘肃省金昌市",
"861505642", "安徽省六安市",
"861869769", "安徽省阜阳市",
"861319358", "河南省濮阳市",
"861535670", "浙江省衢州市",
"861895145", "江苏省宿迁市",
"861520728", "湖北省十堰市",
"861330231", "广东省深圳市",
"861300842", "陕西省西安市",
"861582055", "广东省珠海市",
"861883447", "山西省运城市",
"86134888", "北京市",
"861586632", "山东省淄博市",
"861334503", "山东省东营市",
"861514669", "黑龙江省齐齐哈尔市",
"86180577", "浙江省温州市",
"861313548", "安徽省铜陵市",
"861533771", "浙江省宁波市",
"861336710", "湖北省襄樊市",
"861333785", "江苏省宿迁市",
"861707384", "河南省商丘市",
"861535442", "河北省保定市",
"861315237", "陕西省渭南市",
"861788122", "新疆博尔塔拉蒙古自治州",
"861582010", "广东省韶关市",
"86189199", "甘肃省兰州市",
"861591294", "云南省楚雄彝族自治州",
"861355069", "四川省资阳市",
"861519643", "四川省乐山市",
"861773478", "河南省郑州市",
"861471457", "广东省深圳市",
"861360059", "浙江省金华市",
"861477735", "广西桂林市",
"861872815", "四川省雅安市",
"861836148", "江苏省连云港市",
"861382464", "广东省肇庆市",
"861502639", "新疆阿克苏地区",
"861594764", "内蒙古赤峰市",
"861326692", "广东省东莞市",
"861302188", "河北省石家庄市",
"861520008", "河北省保定市",
"861843146", "河北省廊坊市",
"8615840", "辽宁省沈阳市",
"861865279", "江苏省扬州市",
"861317639", "山东省青岛市",
"861347073", "安徽省芜湖市",
"861781725", "广东省惠州市",
"861582584", "甘肃省平凉市",
"86183735", "湖南省郴州市",
"861788803", "西藏山南地区",
"861370016", "辽宁省锦州市",
"861598696", "广东省惠州市",
"861814806", "四川省绵阳市",
"861572500", "山东省威海市",
"861381249", "江苏省泰州市",
"861529733", "河北省张家口市",
"861800347", "山西省临汾市",
"861558736", "山东省烟台市",
"861532439", "河北省衡水市",
"861585294", "江苏省南京市",
"861567209", "湖北省十堰市",
"86188599", "福建省泉州市",
"86131202", "北京市",
"861334095", "四川省眉山市",
"861372658", "广东省韶关市",
"861323383", "河南省新乡市",
"861338391", "河南省焦作市",
"861700377", "河南省南阳市",
"861452786", "新疆巴音郭楞蒙古自治州",
"861593287", "江西省萍乡市",
"861777126", "湖北省宜昌市",
"86155307", "河北省沧州市",
"861321462", "黑龙江省齐齐哈尔市",
"861350091", "吉林省延边朝鲜族自治州",
"861315972", "吉林省通化市",
"861860684", "浙江省嘉兴市",
"861526648", "山东省淄博市",
"861309973", "青海省黄南藏族自治州",
"861521582", "浙江省台州市",
"861822568", "安徽省阜阳市",
"861804877", "四川省宜宾市",
"861326353", "黑龙江省牡丹江市",
"86150702", "江西省九江市",
"861534697", "甘肃省酒泉市",
"861364408", "辽宁省大连市",
"861458200", "安徽省淮北市",
"861522986", "陕西省安康市",
"861347125", "广西桂林市",
"861888615", "贵州省安顺市",
"861379470", "广东省河源市",
"861559861", "内蒙古赤峰市",
"861386580", "安徽省合肥市",
"861880701", "江西省鹰潭市",
"86150759", "河北省邢台市",
"861381478", "江苏省常州市",
"861588031", "福建省莆田市",
"861538676", "山西省晋城市",
"861329637", "山东省枣庄市",
"861525243", "江苏省宿迁市",
"861479770", "广西防城港市",
"861301591", "福建省厦门市",
"861800758", "广东省肇庆市",
"861528404", "四川省绵阳市",
"861322141", "浙江省杭州市",
"861347775", "湖北省黄石市",
"861373946", "四川省成都市",
"86147989", "海南省海口市",
"861367552", "安徽省蚌埠市",
"861821483", "安徽省合肥市",
"861561288", "河北省唐山市",
"861811577", "江苏省无锡市",
"861569204", "广东省珠海市",
"861350521", "江苏省徐州市",
"861773249", "河北省张家口市",
"861571653", "河南省平顶山市",
"86176012", "上海市",
"86152515", "江苏省无锡市",
"86134178", "广东省珠海市",
"861823362", "河北省廊坊市",
"861576151", "贵州省六盘水市",
"861334525", "山东省潍坊市",
"86136701", "广东省深圳市",
"861389503", "宁夏吴忠市",
"861454811", "广东省广州市",
"861558178", "山西省太原市",
"861510646", "山东省烟台市",
"861364991", "新疆阿勒泰地区",
"861560672", "浙江省湖州市",
"861803030", "福建省厦门市",
"861336561", "安徽省淮北市",
"861859173", "陕西省宝鸡市",
"861315846", "四川省广安市",
"861334793", "江苏省徐州市",
"861365872", "云南省大理白族自治州",
"861319634", "陕西省宝鸡市",
"861889941", "新疆克孜勒苏柯尔克孜自治州",
"861315339", "山东省淄博市",
"861348837", "陕西省延安市",
"861598385", "四川省达州市",
"861558728", "云南省大理白族自治州",
"861501856", "广东省湛江市",
"861817441", "湖南省长沙市",
"861597743", "广西桂林市",
"861503651", "河南省焦作市",
"861311740", "湖南省岳阳市",
"861536481", "山西省太原市",
"861571392", "河南省鹤壁市",
"861380796", "江西省吉安市",
"861830319", "河北省邢台市",
"861336475", "新疆昌吉回族自治州",
"861859723", "青海省海东地区",
"861556346", "山东省济宁市",
"861801576", "四川省阿坝藏族羌族自治州",
"861533591", "湖北省襄樊市",
"861808724", "云南省昆明市",
"861366536", "山东省潍坊市",
"861576563", "黑龙江省黑河市",
"861373453", "黑龙江省佳木斯市",
"861511179", "青海省海东地区",
"86180559", "安徽省黄山市",
"86155458", "黑龙江省鹤岗市",
"861378079", "山东省东营市",
"861521854", "广东省潮州市",
"861813061", "安徽省芜湖市",
"861705255", "北京市",
"861348580", "安徽省淮南市",
"861827243", "湖北省荆州市",
"861560384", "河南省安阳市",
"861359327", "山西省长治市",
"861364249", "广东省河源市",
"861470940", "甘肃省临夏回族自治州",
"86135446", "广东省东莞市",
"861360429", "辽宁省葫芦岛市",
"861560602", "福建省福州市",
"86184876", "云南省昭通市",
"861328463", "黑龙江省哈尔滨市",
"861370244", "广东省佛山市",
"861808174", "四川省攀枝花市",
"861379113", "山东省济南市",
"861889299", "新疆石河子市",
"861860939", "甘肃省陇南市",
"861705210", "上海市",
"861872643", "安徽省宿州市",
"86182715", "湖北省黄冈市",
"861818897", "湖南省衡阳市",
"8618488", "云南省昆明市",
"861300045", "北京市",
"861882502", "广东省中山市",
"86133624", "浙江省宁波市",
"861346858", "陕西省延安市",
"861859455", "福建省莆田市",
"861317984", "新疆乌鲁木齐市",
"861566042", "山东省济宁市",
"861802339", "广东省云浮市",
"86186997", "新疆阿克苏地区",
"861569274", "贵州省贵阳市",
"86150745", "湖南省怀化市",
"861811281", "江苏省镇江市",
"861898900", "西藏拉萨市",
"861516076", "福建省泉州市",
"861336886", "云南省怒江傈僳族自治州",
"861309168", "黑龙江省大庆市",
"861452422", "辽宁省鞍山市",
"861802846", "广东省惠州市",
"861305847", "广东省潮州市",
"861336153", "山东省潍坊市",
"861880771", "广西南宁市",
"861339539", "山东省临沂市",
"861376574", "贵州省六盘水市",
"861383490", "山西省晋城市",
"86155971", "青海省西宁市",
"861515441", "山东省青岛市",
"861500647", "山东省济宁市",
"861479700", "青海省西宁市",
"861333856", "福建省泉州市",
"861380824", "四川省达州市",
"861563925", "河南省郑州市",
"861524029", "江苏省镇江市",
"861502984", "陕西省榆林市",
"861373105", "河北省保定市",
"86153765", "山东省济宁市",
"861804807", "四川省德阳市",
"861860372", "河南省安阳市",
"861309903", "山西省忻州市",
"861396555", "安徽省阜阳市",
"861473055", "河北省秦皇岛市",
"861810346", "山西省太原市",
"861320250", "广东省广州市",
"861351545", "山东省烟台市",
"861500419", "辽宁省辽阳市",
"861364478", "内蒙古巴彦淖尔市",
"861337534", "山东省德州市",
"861358974", "山东省滨州市",
"861894377", "吉林省辽源市",
"861476085", "江苏省连云港市",
"86155300", "河北省邯郸市",
"861335819", "江苏省常州市",
"861700307", "广东省惠州市",
"861396510", "安徽省合肥市",
"861473010", "河北省邯郸市",
"861888843", "广西桂林市",
"861898685", "湖北省恩施土家族苗族自治州",
"861530619", "江苏省无锡市",
"86153535", "陕西省西安市",
"861840622", "辽宁省本溪市",
"861571840", "广东省佛山市",
"861814267", "湖南省常德市",
"861355169", "四川省甘孜藏族自治州",
"861887294", "湖北省荆州市",
"861816754", "新疆塔城地区",
"861306980", "黑龙江省鸡西市",
"861527000", "江西省南昌市",
"861303915", "吉林省吉林市",
"861520078", "湖南省湘西土家族苗族自治州",
"861890847", "湖南省长沙市",
"86181987", "广东省惠州市",
"861864842", "内蒙古巴彦淖尔市",
"861572570", "山东省菏泽市",
"861471597", "广东省中山市",
"861564690", "新疆博尔塔拉蒙古自治州",
"861390969", "安徽省合肥市",
"861300743", "湖南省长沙市",
"861514496", "内蒙古通辽市",
"861303950", "内蒙古呼和浩特市",
"861581220", "云南省大理白族自治州",
"861773408", "河北省衡水市",
"861523662", "河南省新乡市",
"861824264", "辽宁省铁岭市",
"861760342", "山西省晋中市",
"86180502", "福建省福州市",
"861847699", "广东省深圳市",
"861357567", "浙江省衢州市",
"861807013", "江西省南昌市",
"861510180", "甘肃省定西市",
"861832940", "陕西省西安市",
"861359785", "湖北省十堰市",
"861867538", "广东省东莞市",
"861869427", "河北省秦皇岛市",
"861559771", "贵州省贵阳市",
"861580410", "辽宁省铁岭市",
"861894882", "广东省韶关市",
"861834474", "江苏省连云港市",
"861327346", "河北省邢台市",
"86188071", "湖北省武汉市",
"861860887", "云南省迪庆藏族自治州",
"861817250", "广西梧州市",
"861556987", "甘肃省陇南市",
"861560251", "广东省茂名市",
"861300732", "湖南省湘潭市",
"861369937", "新疆乌鲁木齐市",
"861312560", "辽宁省锦州市",
"861864833", "内蒙古阿拉善盟",
"861337680", "浙江省舟山市",
"861327839", "吉林省辽源市",
"86181278", "广东省广州市",
"861762512", "江苏省苏州市",
"861850564", "安徽省六安市",
"861580455", "黑龙江省绥化市",
"861804674", "江西省新余市",
"86138704", "江西省抚州市",
"861315008", "甘肃省陇南市",
"861534894", "西藏林芝地区",
"861781762", "广东省河源市",
"861869366", "甘肃省庆阳市",
"86182960", "贵州省黔西南布依族苗族自治州",
"861822419", "四川省雅安市",
"861760333", "河北省唐山市",
"86188687", "浙江省杭州市",
"861839713", "青海省海东地区",
"86186436", "吉林省白城市",
"861520972", "青海省海东地区",
"86156100", "山东省青岛市",
"861324691", "广东省揭阳市",
"861341847", "广东省深圳市",
"861321425", "辽宁省沈阳市",
"861836524", "安徽省淮北市",
"861830537", "山东省济宁市",
"861821935", "广东省深圳市",
"861318730", "湖南省衡阳市",
"86151892", "江苏省盐城市",
"861837888", "广西河池市",
"861841969", "甘肃省陇南市",
"86176205", "广东省东莞市",
"861880586", "浙江省台州市",
"861802078", "福建省三明市",
"86158166", "广东省汕头市",
"861898579", "贵州省黔南布依族苗族自治州",
"86833", "四川省乐山市",
"861330511", "江苏省盐城市",
"861508359", "江西省赣州市",
"861705363", "江苏省无锡市",
"861501229", "云南省昭通市",
"861553335", "河北省唐山市",
"861847183", "湖北省荆州市",
"861310243", "河北省沧州市",
"861882421", "广东省东莞市",
"861314423", "广东省江门市",
"861316484", "福建省漳州市",
"861580968", "宁夏银川市",
"861596082", "福建省厦门市",
"861509431", "江苏省南京市",
"86170951", "江苏省苏州市",
"86152937", "甘肃省酒泉市",
"861319114", "山西省晋中市",
"861566033", "新疆阿克苏地区",
"861810987", "辽宁省盘锦市",
"86150695", "山东省聊城市",
"861350472", "吉林省延边朝鲜族自治州",
"861319837", "四川省凉山彝族自治州",
"861348634", "浙江省嘉兴市",
"861350640", "山东省济南市",
"861452287", "山西省临汾市",
"861313454", "黑龙江省佳木斯市",
"861452501", "山东省济南市",
"861894494", "湖南省怀化市",
"861531559", "山东省济南市",
"861831809", "广东省湛江市",
"861882917", "陕西省宝鸡市",
"861500995", "新疆吐鲁番地区",
"861555840", "浙江省宁波市",
"86150398", "河南省三门峡市",
"861589076", "河南省安阳市",
"861504682", "黑龙江省双鸭山市",
"861772430", "广东省东莞市",
"861334562", "安徽省铜陵市",
"86158407", "辽宁省营口市",
"861590344", "山西省晋中市",
"861326487", "湖北省孝感市",
"861362779", "广西北海市",
"861597488", "云南省昭通市",
"86159351", "山西省太原市",
"861827232", "湖北省十堰市",
"861814048", "四川省资阳市",
"86139433", "吉林省延边朝鲜族自治州",
"86152028", "四川省成都市",
"861558237", "山西省临汾市",
"861777618", "广西河池市",
"86187009", "陕西省西安市",
"861325646", "山东省潍坊市",
"861822647", "安徽省安庆市",
"861816299", "湖北省荆门市",
"861572909", "河南省洛阳市",
"861892258", "广东省韶关市",
"861377983", "新疆阿克苏地区",
"861335380", "河南省郑州市",
"861323457", "黑龙江省大兴安岭地区",
"861457199", "浙江省衢州市",
"861394863", "内蒙古赤峰市",
"861520339", "河北省邢台市",
"861899967", "新疆阿克苏地区",
"861763318", "河北省衡水市",
"86134335", "广东省惠州市",
"861304363", "湖南省娄底市",
"861335444", "山东省青岛市",
"861780312", "河北省保定市",
"861390560", "安徽省合肥市",
"861881833", "广东省河源市",
"861572979", "四川省凉山彝族自治州",
"861536669", "江苏省连云港市",
"861337146", "山东省聊城市",
"861770655", "浙江省绍兴市",
"861355757", "广西南宁市",
"861838459", "四川省广元市",
"861309349", "安徽省池州市",
"86130483", "重庆市",
"861884812", "内蒙古包头市",
"861832549", "山东省临沂市",
"861305644", "四川省达州市",
"86134638", "河北省石家庄市",
"861309836", "湖北省黄冈市",
"861362709", "江西省南昌市",
"861590480", "内蒙古呼伦贝尔市",
"861869057", "陕西省咸阳市",
"861800986", "辽宁省盘锦市",
"86133198", "新疆乌鲁木齐市",
"861386634", "安徽省淮南市",
"861303559", "贵州省黔西南布依族苗族自治州",
"861453646", "江苏省苏州市",
"861380627", "江苏省南通市",
"861857840", "广东省佛山市",
"861770610", "江苏省镇江市",
"861816941", "湖南省常德市",
"861808659", "湖北省黄冈市",
"861337975", "新疆喀什地区",
"861323597", "福建省龙岩市",
"861537981", "甘肃省酒泉市",
"861573096", "甘肃省临夏回族自治州",
"861883039", "河北省秦皇岛市",
"861895488", "山东省泰安市",
"861831879", "广东省中山市",
"861452571", "福建省福州市",
"861519460", "河南省开封市",
"861862386", "河南省商丘市",
"861569818", "山东省烟台市",
"861357648", "江西省上饶市",
"861365387", "河南省洛阳市",
"861871487", "安徽省马鞍山市",
"861524990", "安徽省池州市",
"861868813", "广东省中山市",
"86181976", "新疆喀什地区",
"861355829", "广西北海市",
"861319580", "甘肃省陇南市",
"861777207", "广西梧州市",
"861316340", "黑龙江省齐齐哈尔市",
"861826256", "江苏省镇江市",
"861576792", "广东省惠州市",
"861534738", "湖南省娄底市",
"861324221", "广东省中山市",
"86156466", "山东省济南市",
"861379633", "黑龙江省齐齐哈尔市",
"861313594", "湖北省咸宁市",
"861700185", "上海市",
"861818694", "湖北省孝感市",
"861531499", "浙江省金华市",
"861700494", "北京市",
"861870412", "辽宁省鞍山市",
"861355348", "广东省湛江市",
"861809620", "四川省德阳市",
"861367687", "浙江省绍兴市",
"861354490", "广东省珠海市",
"861898509", "贵州省黔西南布依族苗族自治州",
"861890644", "山东省济南市",
"861554217", "辽宁省沈阳市",
"86130578", "浙江省温州市",
"861515250", "江苏省徐州市",
"861580723", "湖北省黄石市",
"86153917", "安徽省阜阳市",
"861308761", "陕西省渭南市",
"861350853", "贵州省安顺市",
"861520902", "新疆哈密地区",
"861839420", "甘肃省临夏回族自治州",
"861595141", "江苏省南通市",
"861570513", "江苏省连云港市",
"861314053", "河南省平顶山市",
"861565096", "青海省西宁市",
"861882051", "广东省云浮市",
"861840665", "广东省梅州市",
"861567085", "河南省焦作市",
"861331272", "云南省德宏傣族景颇族自治州",
"86153972", "浙江省宁波市",
"861555653", "安徽省合肥市",
"861830880", "云南省曲靖市",
"861339930", "甘肃省临夏回族自治州",
"861534945", "甘肃省酒泉市",
"861820639", "山东省临沂市",
"861534726", "湖北省荆州市",
"861476279", "江苏省南通市",
"861332712", "内蒙古呼和浩特市",
"861550941", "甘肃省甘南藏族自治州",
"861554678", "广东省潮州市",
"861342281", "广东省中山市",
"861500568", "安徽省阜阳市",
"861452958", "广东省中山市",
"861503202", "河北省邯郸市",
"861709422", "广东省惠州市",
"861330688", "浙江省丽水市",
"86158655", "山东省青岛市",
"86138346", "山西省太原市",
"86182967", "江西省赣州市",
"861708536", "山东省潍坊市",
"861700882", "广东省广州市",
"861315078", "云南省文山壮族苗族自治州",
"861339317", "河北省沧州市",
"861579737", "湖北省黄冈市",
"861302531", "广东省潮州市",
"861834404", "广东省肇庆市",
"861839331", "甘肃省平凉市",
"86145034", "辽宁省沈阳市",
"861305516", "湖南省长沙市",
"861325180", "吉林省长春市",
"861780954", "宁夏固原市",
"861880861", "湖北省荆州市",
"861860530", "山东省菏泽市",
"861478604", "贵州省铜仁地区",
"861708098", "广东省佛山市",
"861470549", "山东省临沂市",
"861804382", "吉林省吉林市",
"861513862", "河南省南阳市",
"861816629", "湖南省益阳市",
"861580595", "福建省泉州市",
"861598727", "云南省临沧市",
"861321753", "广东省梅州市",
"86158358", "山西省吕梁市",
"86181964", "新疆伊犁哈萨克自治州",
"861303168", "山东省潍坊市",
"861336413", "辽宁省抚顺市",
"861317990", "新疆克拉玛依市",
"861583329", "河北省邢台市",
"861777016", "江西省鹰潭市",
"861859150", "陕西省安康市",
"861880957", "宁夏银川市",
"861325048", "广东省中山市",
"861814646", "新疆石河子市",
"861308929", "吉林省通化市",
"861853455", "山西省忻州市",
"861583564", "山西省大同市",
"861808439", "贵州省黔西南布依族苗族自治州",
"861890677", "浙江省温州市",
"86133485", "福建省泉州市",
"861340428", "江苏省无锡市",
"861317306", "山东省枣庄市",
"861569746", "湖南省永州市",
"861569925", "新疆巴音郭楞蒙古自治州",
"861890081", "广东省湛江市",
"86131122", "广东省广州市",
"861339856", "贵州省铜仁地区",
"861361083", "辽宁省沈阳市",
"861458322", "江西省九江市",
"86156474", "内蒙古乌兰察布市",
"86155371", "河南省郑州市",
"861333539", "陕西省西安市",
"861534319", "河北省邢台市",
"861374739", "河南省周口市",
"861518819", "云南省玉溪市",
"861373400", "山西省太原市",
"861840938", "甘肃省天水市",
"861360734", "湖南省衡阳市",
"861853410", "山西省长治市",
"861838639", "贵州省黔西南布依族苗族自治州",
"861517221", "湖北省孝感市",
"861471798", "山西省忻州市",
"861770435", "吉林省通化市",
"861589217", "福建省南平市",
"861828880", "云南省怒江傈僳族自治州",
"86150711", "湖北省武汉市",
"86138018", "上海市",
"861817789", "广西河池市",
"861880335", "河北省秦皇岛市",
"861584701", "内蒙古呼伦贝尔市",
"861366859", "贵州省黔西南布依族苗族自治州",
"861536749", "湖南省长沙市",
"861819061", "四川省南充市",
"861376668", "黑龙江省双鸭山市",
"861839865", "四川省成都市",
"861332978", "湖北省荆门市",
"861581372", "广东省深圳市",
"861370776", "广西百色市",
"861560390", "河南省郑州市",
"86156631", "黑龙江省齐齐哈尔市",
"861348594", "安徽省宣城市",
"861571442", "吉林省吉林市",
"861539591", "福建省福州市",
"86182741", "湖南省岳阳市",
"86134572", "广西柳州市",
"861526808", "浙江省衢州市",
"861322363", "山西省阳泉市",
"861571670", "河南省开封市",
"861453766", "广西北海市",
"861504758", "内蒙古赤峰市",
"861560906", "四川省遂宁市",
"86134517", "江苏省苏州市",
"861778502", "贵州省贵阳市",
"861525092", "江苏省徐州市",
"861359219", "河南省平顶山市",
"861376816", "广西百色市",
"861760552", "安徽省蚌埠市",
"86157790", "江西省赣州市",
"861305081", "辽宁省铁岭市",
"861592942", "陕西省汉中市",
"86145219", "吉林省长春市",
"86130806", "湖北省武汉市",
"861871543", "安徽省阜阳市",
"86136712", "北京市",
"861893233", "江苏省淮安市",
"861306994", "黑龙江省鹤岗市",
"861887280", "湖北省恩施土家族苗族自治州",
"861452820", "四川省宜宾市",
"86181387", "广东省广州市",
"861820459", "黑龙江省大庆市",
"861566623", "山东省潍坊市",
"861832476", "安徽省阜阳市",
"861335477", "内蒙古鄂尔多斯市",
"86177594", "福建省泉州市",
"861800497", "辽宁省营口市",
"861772843", "广东省汕头市",
"861383892", "河南省焦作市",
"861500877", "云南省玉溪市",
"861351937", "甘肃省酒泉市",
"861539021", "四川省乐山市",
"861529662", "山西省大同市",
"861802676", "广东省江门市",
"861572161", "山西省朔州市",
"861310471", "广东省珠海市",
"861361785", "广西玉林市",
"861771195", "西藏昌都地区",
"861309950", "宁夏银川市",
"861510485", "内蒙古兴安盟",
"86188275", "湖北省襄樊市",
"861523311", "河北省石家庄市",
"861324531", "山东省济南市",
"861768133", "安徽省芜湖市",
"861326370", "广西南宁市",
"861346364", "河北省廊坊市",
"86153554", "浙江省杭州市",
"861308641", "四川省绵阳市",
"861871300", "河北省廊坊市",
"861331964", "湖南省张家界市",
"861351310", "河北省邯郸市",
"861889308", "甘肃省天水市",
"861881384", "广东省中山市",
"861316959", "广东省惠州市",
"861346529", "山东省东营市",
"861572493", "浙江省金华市",
"861303903", "吉林省四平市",
"861332551", "新疆阿克苏地区",
"861477301", "湖南省长沙市",
"861347050", "辽宁省本溪市",
"861871996", "新疆和田地区",
"861840926", "陕西省汉中市",
"861781113", "宁夏吴忠市",
"861351355", "山西省长治市",
"861809351", "甘肃省金昌市",
"861338441", "吉林省吉林市",
"861313989", "新疆乌鲁木齐市",
"861315606", "山东省东营市",
"861786611", "甘肃省临夏回族自治州",
"861826971", "安徽省安庆市",
"861840745", "湖南省怀化市",
"861500159", "新疆巴音郭楞蒙古自治州",
"861554006", "内蒙古呼伦贝尔市",
"861479010", "安徽省滁州市",
"861527053", "江西省上饶市",
"861810556", "安徽省安庆市",
"861829787", "安徽省六安市",
"86155900", "吉林省长春市",
"861771573", "四川省泸州市",
"861399585", "湖北省孝感市",
"861807075", "广西钦州市",
"861572553", "山东省烟台市",
"861558527", "贵州省贵阳市",
"861575204", "云南省昆明市",
"86187590", "福建省龙岩市",
"861891952", "四川省成都市",
"861365642", "山东省青岛市",
"86135591", "福建省福州市",
"861824078", "河南省商丘市",
"861332491", "云南省曲靖市",
"861580635", "山东省聊城市",
"861585280", "江苏省无锡市",
"861393414", "山西省太原市",
"86139011", "北京市",
"861771503", "江苏省南通市",
"86139682", "浙江省宁波市",
"861899851", "广东省汕尾市",
"861329383", "山西省阳泉市",
"861860690", "福建省莆田市",
"861881672", "广东省梅州市",
"861398948", "浙江省杭州市",
"861889378", "甘肃省天水市",
"861881440", "广东省梅州市",
"861302691", "广西南宁市",
"861868765", "云南省文山壮族苗族自治州",
"861810496", "辽宁省锦州市",
"861879448", "甘肃省临夏回族自治州",
"861399154", "陕西省渭南市",
"861337897", "湖南省张家界市",
"86158174", "广东省深圳市",
"861365470", "内蒙古呼伦贝尔市",
"861588373", "四川省达州市",
"861303973", "黑龙江省鹤岗市",
"861520264", "宁夏固原市",
"861380037", "河南省商丘市",
"861853025", "河南省商丘市",
"861538846", "四川省德阳市",
"861458253", "安徽省合肥市",
"861342868", "广东省深圳市",
"861800557", "安徽省宿州市",
"86151934", "甘肃省张掖市",
"861590377", "河南省南阳市",
"861326300", "江西省南昌市",
"861535261", "新疆阿勒泰地区",
"861320273", "广东省东莞市",
"861398033", "四川省广安市",
"86153828", "广东省东莞市",
"861771340", "四川省成都市",
"861310401", "黑龙江省哈尔滨市",
"86151355", "山西省长治市",
"86131646", "湖北省武汉市",
"861598992", "广东省东莞市",
"86181380", "广东省江门市",
"861471834", "广东省河源市",
"861360898", "山东省青岛市",
"86157797", "江西省赣州市",
"861862535", "河南省信阳市",
"861877274", "湖北省荆门市",
"861478419", "河南省信阳市",
"861332163", "广西桂林市",
"861538339", "河北省石家庄市",
"861707045", "浙江省金华市",
"861825053", "福建省莆田市",
"861858709", "云南省迪庆藏族自治州",
"861343730", "广东省江门市",
"861325766", "广东省云浮市",
"861581684", "广东省东莞市",
"861589608", "江苏省宿迁市",
"861379593", "四川省巴中市",
"861571600", "福建省三明市",
"861853173", "河北省唐山市",
"861526878", "浙江省丽水市",
"861539451", "福建省福州市",
"861478647", "湖南省永州市",
"861809030", "四川省内江市",
"861510942", "甘肃省甘南藏族自治州",
"861778572", "贵州省贵阳市",
"861845449", "山东省聊城市",
"861336720", "湖北省仙桃市",
"861834447", "广东省深圳市",
"861560976", "青海省玉树藏族自治州",
"861807773", "广西钦州市",
"861772650", "四川省德阳市",
"861569068", "河南省漯河市",
"861811136", "四川省广元市",
"861321860", "江苏省盐城市",
"861584771", "内蒙古鄂尔多斯市",
"861392471", "广东省珠海市",
"861509651", "云南省文山壮族苗族自治州",
"861453933", "广东省佛山市",
"861807123", "湖北省黄石市",
"861772615", "湖南省衡阳市",
"861533111", "黑龙江省哈尔滨市",
"861336170", "江西省新余市",
"861370706", "江西省吉安市",
"861815221", "甘肃省定西市",
"861385132", "江苏省盐城市",
"861332908", "安徽省阜阳市",
"861560145", "江苏省扬州市",
"861804647", "福建省龙岩市",
"861367342", "河南省周口市",
"861538972", "内蒙古包头市",
"861347420", "陕西省安康市",
"861323637", "江苏省镇江市",
"861358695", "浙江省金华市",
"861870791", "江西省南昌市",
"861812764", "广东省梅州市",
"861551666", "河南省鹤壁市",
"861383340", "河北省承德市",
"861389515", "宁夏吴忠市",
"861872452", "黑龙江省齐齐哈尔市",
"861373470", "内蒙古呼伦贝尔市",
"861898446", "贵州省毕节地区",
"861508940", "广东省河源市",
"86152541", "山东省济南市",
"861379725", "湖北省咸宁市",
"86137494", "河南省周口市",
"861821816", "广东省茂名市",
"861470885", "云南省曲靖市",
"861379946", "福建省泉州市",
"861570934", "甘肃省庆阳市",
"86187023", "重庆市",
"861890607", "福建省龙岩市",
"861576927", "陕西省宝鸡市",
"861760884", "云南省昆明市",
"861371558", "广东省中山市",
"861816039", "新疆哈密地区",
"861530397", "河南省商丘市",
"861523035", "河北省秦皇岛市",
"861827092", "江西省九江市",
"861564939", "河南省南阳市",
"861350760", "河南省信阳市",
"861708385", "河南省安阳市",
"861551204", "河北省唐山市",
"861338250", "江苏省苏州市",
"861331320", "河北省邯郸市",
"86182984", "甘肃省兰州市",
"861894344", "吉林省通化市",
"86137191", "广东省广州市",
"861367333", "河南省安阳市",
"861358947", "山东省聊城市",
"861346920", "湖南省郴州市",
"861572821", "广东省梅州市",
"861316550", "河北省邯郸市",
"861858283", "四川省达州市",
"861766641", "广东省东莞市",
"861846430", "山东省淄博市",
"861577911", "江西省抚州市",
"861317029", "安徽省黄山市",
"861472894", "西藏林芝地区",
"861563666", "黑龙江省双鸭山市",
"861308090", "陕西省西安市",
"861319594", "甘肃省酒泉市",
"861861595", "山东省烟台市",
"861569962", "黑龙江省齐齐哈尔市",
"861500767", "广东省东莞市",
"861452160", "河北省廊坊市",
"86176125", "江苏省南京市",
"861332002", "江西省九江市",
"861700480", "福建省泉州市",
"861581530", "广东省汕头市",
"861316515", "山东省青岛市",
"861313580", "湖北省宜昌市",
"861303349", "山西省大同市",
"861550378", "河南省开封市",
"86147731", "湖南省长沙市",
"861868805", "广东省潮州市",
"86131263", "广东省惠州市",
"861318888", "山东省济南市",
"861331431", "吉林省长春市",
"861390721", "湖北省荆州市",
"861538078", "江苏省南京市",
"861334388", "河南省洛阳市",
"861780661", "广东省韶关市",
"86138525", "江苏省扬州市",
"86176606", "山东省青岛市",
"861820376", "河南省信阳市",
"861768994", "福建省厦门市",
"861801617", "四川省宜宾市",
"861890874", "云南省曲靖市",
"861510933", "甘肃省平凉市",
"861831921", "广东省茂名市",
"861329597", "福建省福州市",
"861310092", "黑龙江省齐齐哈尔市",
"861340314", "河北省承德市",
"861453942", "广东省江门市",
"861590494", "辽宁省大连市",
"861559011", "吉林省松原市",
"861516608", "山东省淄博市",
"861354892", "湖南省岳阳市",
"861459646", "甘肃省白银市",
"861866671", "广东省湛江市",
"861859635", "山东省聊城市",
"861309559", "安徽省黄山市",
"86134354", "广东省佛山市",
"861863057", "河北省秦皇岛市",
"861562445", "山东省日照市",
"861815040", "福建省厦门市",
"861800682", "浙江省湖州市",
"861838119", "四川省眉山市",
"86184864", "贵州省毕节地区",
"861333317", "河北省沧州市",
"861340952", "宁夏石嘴山市",
"861534537", "山东省济宁市",
"86477", "内蒙古鄂尔多斯市",
"861470359", "山西省运城市",
"86138946", "吉林省白城市",
"861530583", "浙江省嘉兴市",
"861505863", "浙江省台州市",
"86187689", "河南省平顶山市",
"86145055", "黑龙江省哈尔滨市",
"861831649", "广东省佛山市",
"861329027", "山东省滨州市",
"861350800", "四川省德阳市",
"861372056", "陕西省渭南市",
"861372782", "广东省茂名市",
"86158958", "江苏省南京市",
"861519862", "云南省文山壮族苗族自治州",
"861362019", "广东省江门市",
"861325194", "浙江省嘉兴市",
"861459514", "云南省保山市",
"861812804", "广东省东莞市",
"86150533", "山东省淄博市",
"861801449", "江苏省南京市",
"86130110", "北京市",
"861808147", "四川省雅安市",
"861370277", "广东省珠海市",
"861870855", "贵州省黔东南苗族侗族自治州",
"861818905", "西藏昌都地区",
"861365633", "山东省日照市",
"86189783", "广西桂林市",
"86153317", "云南省昆明市",
"861321700", "江西省南昌市",
"861530474", "内蒙古乌兰察布市",
"861368988", "吉林省吉林市",
"861590882", "云南省德宏傣族景颇族自治州",
"861805171", "江苏省盐城市",
"861776740", "新疆乌鲁木齐市",
"861569247", "广东省佛山市",
"861323798", "江西省景德镇市",
"861454784", "山东省德州市",
"861856933", "湖南省娄底市",
"861308520", "湖北省黄石市",
"861319024", "辽宁省丹东市",
"861395682", "安徽省阜阳市",
"861370866", "云南省大理白族自治州",
"861528447", "云南省丽江市",
"861564887", "内蒙古巴彦淖尔市",
"86158471", "内蒙古呼和浩特市",
"861857442", "湖南省岳阳市",
"86139241", "广东省广州市",
"861803620", "江苏省南通市",
"861325806", "山东省潍坊市",
"861708727", "江西省宜春市",
"861812196", "四川省成都市",
"861333930", "黑龙江省哈尔滨市",
"861502599", "甘肃省金昌市",
"861358262", "河北省保定市",
"86153372", "湖北省武汉市",
"861370618", "江苏省无锡市",
"861554329", "吉林省松原市",
"861355558", "黑龙江省佳木斯市",
"861379387", "山东省滨州市",
"861847539", "广东省深圳市",
"861787627", "广东省梅州市",
"86132189", "江苏省扬州市",
"861345111", "湖北省咸宁市",
"861317459", "福建省龙岩市",
"861325876", "吉林省通化市",
"861885158", "江苏省无锡市",
"861804568", "黑龙江省黑河市",
"861363355", "山西省长治市",
"861532659", "黑龙江省大庆市",
"861879783", "江西省上饶市",
"861369545", "山东省烟台市",
"861811544", "江苏省扬州市",
"861471637", "广东省佛山市",
"861363310", "河北省邯郸市",
"861559335", "甘肃省白银市",
"861389959", "新疆克拉玛依市",
"861816308", "湖北省武汉市",
"861321770", "广西防城港市",
"861530404", "辽宁省大连市",
"861839705", "青海省海东地区",
"861522497", "河南省周口市",
"861853062", "河南省安阳市",
"861478568", "贵州省遵义市",
"86159583", "浙江省嘉兴市",
"861592933", "陕西省渭南市",
"861453485", "内蒙古乌海市",
"86157640", "山东省菏泽市",
"861871532", "安徽省芜湖市",
"861453194", "山西省晋中市",
"861594644", "黑龙江省七台河市",
"861363937", "甘肃省酒泉市",
"861507171", "湖北省黄冈市",
"861307494", "河南省信阳市",
"861344067", "福建省南平市",
"861335069", "四川省资阳市",
"861802197", "江苏省常州市",
"861570575", "浙江省绍兴市",
"861312721", "山东省枣庄市",
"861772832", "广东省佛山市",
"861370581", "浙江省杭州市",
"86186613", "山东省泰安市",
"861863427", "山西省晋城市",
"861886784", "浙江省丽水市",
"861327556", "安徽省安庆市",
"861350231", "广东省河源市",
"861863366", "河北省邯郸市",
"86182360", "河南省濮阳市",
"861325267", "吉林省通化市",
"861334235", "辽宁省铁岭市",
"861539240", "福建省南平市",
"861337694", "福建省宁德市",
"861350870", "云南省昭通市",
"861830726", "湖北省荆州市",
"861891436", "江苏省南通市",
"861830945", "甘肃省武威市",
"861512185", "宁夏中卫市",
"861506044", "福建省福州市",
"861570461", "黑龙江省哈尔滨市",
"861855543", "安徽省淮北市",
"861529295", "新疆和田地区",
"861355901", "福建省宁德市",
"861571433", "吉林省延边朝鲜族自治州",
"861510766", "广东省云浮市",
"86182691", "广西南宁市",
"861568495", "湖南省长沙市",
"861339699", "浙江省温州市",
"861361466", "黑龙江省大庆市",
"861820990", "新疆克拉玛依市",
"86158873", "云南省大理白族自治州",
"861568184", "四川省自贡市",
"86188000", "北京市",
"861830738", "湖南省娄底市",
"861335394", "河南省周口市",
"861582999", "陕西省延安市",
"861800374", "河南省许昌市",
"861361327", "河北省沧州市",
"861329457", "山西省临汾市",
"861561586", "山东省潍坊市",
"86139616", "江苏省无锡市",
"861590554", "安徽省淮南市",
"861309499", "江苏省镇江市",
"86156171", "河南省新乡市",
"861316490", "浙江省温州市",
"861337913", "陕西省渭南市",
"861302040", "内蒙古呼伦贝尔市",
"86152337", "河北省保定市",
"86156227", "广东省广州市",
"86133592", "陕西省西安市",
"861862974", "吉林省白城市",
"861478844", "河南省洛阳市",
"861884025", "陕西省渭南市",
"861367711", "湖北省鄂州市",
"861811868", "江苏省盐城市",
"86183543", "山东省滨州市",
"861320789", "广西贵港市",
"86158256", "浙江省温州市",
"861332072", "四川省攀枝花市",
"861700344", "广东省深圳市",
"861504986", "内蒙古鄂尔多斯市",
"861894480", "江苏省泰州市",
"861352997", "云南省玉溪市",
"861356053", "广东省湛江市",
"861801208", "江苏省淮安市",
"861580812", "四川省攀枝花市",
"86159478", "吉林省长春市",
"861366696", "福建省三明市",
"861533631", "山东省威海市",
"861857985", "广西玉林市",
"861803290", "河北省石家庄市",
"861836080", "江苏省无锡市",
"861479462", "黑龙江省齐齐哈尔市",
"861804844", "四川省遂宁市",
"861319454", "黑龙江省佳木斯市",
"86180563", "安徽省宣城市",
"86184518", "江苏省宿迁市",
"861330521", "江苏省徐州市",
"861388683", "湖北省十堰市",
"861501219", "云南省文山壮族苗族自治州",
"861319667", "江苏省盐城市",
"861302395", "福建省漳州市",
"861454161", "浙江省杭州市",
"861321450", "黑龙江省哈尔滨市",
"861780253", "江苏省泰州市",
"86147168", "广东省广州市",
"861812526", "广东省肇庆市",
"861832988", "陕西省商洛市",
"861563499", "山西省太原市",
"861510148", "甘肃省甘南藏族自治州",
"861870786", "广西百色市",
"861707833", "云南省西双版纳傣族自治州",
"86151891", "江苏省镇江市",
"861317779", "江西省赣州市",
"861580331", "河北省石家庄市",
"861788918", "西藏日喀则地区",
"861323578", "浙江省丽水市",
"861321415", "辽宁省丹东市",
"861334959", "黑龙江省大庆市",
"861519065", "江苏省徐州市",
"861370309", "广东省江门市",
"861556481", "山东省泰安市",
"86185565", "安徽省合肥市",
"861328870", "广东省云浮市",
"861850319", "河北省邢台市",
"861369431", "吉林省长春市",
"861815140", "江苏省镇江市",
"86188017", "上海市",
"86187051", "江苏省南京市",
"861450850", "江苏省扬州市",
"861328231", "浙江省嘉兴市",
"861306033", "陕西省渭南市",
"861390071", "湖北省武汉市",
"861322939", "广东省韶关市",
"861538728", "湖北省恩施土家族苗族自治州",
"861762522", "江苏省常州市",
"861869921", "新疆伊犁哈萨克自治州",
"861310192", "江苏省镇江市",
"861763336", "河北省秦皇岛市",
"86136695", "广东省惠州市",
"86135050", "福建省泉州市",
"861356561", "新疆昌吉回族自治州",
"861828217", "四川省攀枝花市",
"861867644", "广东省中山市",
"861579804", "江西省抚州市",
"861390687", "浙江省温州市",
"861325524", "江苏省南通市",
"861580420", "辽宁省辽阳市",
"861454493", "湖北省荆门市",
"86136398", "河南省三门峡市",
"861777636", "广西玉林市",
"86185735", "湖南省郴州市",
"861829303", "甘肃省临夏回族自治州",
"861830006", "广东省韶关市",
"861763328", "河北省沧州市",
"861329777", "广西钦州市",
"86813", "四川省自贡市",
"861864663", "黑龙江省齐齐哈尔市",
"861538736", "湖南省常德市",
"861869649", "湖北省武汉市",
"861378961", "内蒙古呼和浩特市",
"861372269", "河北省邯郸市",
"861813979", "甘肃省酒泉市",
"861875157", "江苏省无锡市",
"861372156", "贵州省铜仁地区",
"86159352", "山西省大同市",
"86156881", "河南省南阳市",
"861778151", "四川省凉山彝族自治州",
"861858990", "广西崇左市",
"861867516", "广东省佛山市",
"861329127", "江苏省南京市",
"861876020", "福建省宁德市",
"861777628", "广西桂林市",
"861523843", "河南省三门峡市",
"861471744", "江西省南昌市",
"861398142", "四川省内江市",
"861343840", "四川省绵阳市",
"861323951", "宁夏银川市",
"861327669", "江苏省徐州市",
"861474047", "辽宁省葫芦岛市",
"861361229", "广东省江门市",
"861514749", "内蒙古乌兰察布市",
"861302686", "广东省广州市",
"861551950", "贵州省六盘水市",
"861810481", "内蒙古鄂尔多斯市",
"861590783", "广西桂林市",
"861805687", "安徽省合肥市",
"861811922", "新疆伊犁哈萨克自治州",
"861861775", "河北省保定市",
"861554697", "广东省潮州市",
"861319774", "广西梧州市",
"861348548", "山西省晋中市",
"861829540", "宁夏银川市",
"861531247", "江苏省镇江市",
"861575499", "内蒙古乌海市",
"861594737", "内蒙古鄂尔多斯市",
"86186778", "广西河池市",
"861868002", "广东省佛山市",
"861560732", "湖南省湘潭市",
"86131685", "广东省佛山市",
"861313246", "河北省邢台市",
"861332486", "广西贵港市",
"86170952", "江苏省无锡市",
"861322372", "河南省安阳市",
"861319124", "山西省运城市",
"861367560", "安徽省合肥市",
"861888662", "四川省成都市",
"861708077", "湖南省岳阳市",
"861354095", "四川省南充市",
"861314413", "广东省佛山市",
"861458489", "山东省淄博市",
"861586452", "山东省济南市",
"86158183", "广东省东莞市",
"86153307", "吉林省吉林市",
"861387270", "湖北省恩施土家族苗族自治州",
"86155535", "山东省烟台市",
"861360568", "安徽省亳州市",
"861363202", "广东省潮州市",
"861871981", "甘肃省兰州市",
"861870422", "辽宁省锦州市",
"861355819", "广西南宁市",
"861477980", "江西省景德镇市",
"86153300", "北京市",
"861387200", "湖北省黄冈市",
"861778563", "贵州省铜仁地区",
"861377284", "陕西省汉中市",
"861324211", "广东省佛山市",
"861840835", "四川省甘孜藏族自治州",
"861835265", "江苏省南通市",
"861570093", "新疆哈密地区",
"861331545", "河北省石家庄市",
"861319704", "湖北省黄石市",
"861311788", "江西省赣州市",
"861338974", "青海省海南藏族自治州",
"861560488", "黑龙江省鹤岗市",
"861320947", "甘肃省嘉峪关市",
"861322684", "广东省汕头市",
"861890526", "江苏省泰州市",
"861345011", "广东省茂名市",
"861569828", "山东省临沂市",
"861506144", "江苏省徐州市",
"861532881", "四川省宜宾市",
"861507687", "河北省邢台市",
"861380617", "江苏省无锡市",
"861314170", "湖南省郴州市",
"861335256", "黑龙江省黑河市",
"861392192", "江苏省扬州市",
"861332875", "福建省厦门市",
"861865480", "山东省烟台市",
"861768042", "湖南省湘西土家族苗族自治州",
"861538963", "陕西省渭南市",
"861337567", "山东省枣庄市",
"86156578", "浙江省宁波市",
"861450643", "黑龙江省大庆市",
"861386548", "安徽省宣城市",
"861839968", "新疆乌鲁木齐市",
"861519936", "新疆昌吉回族自治州",
"86186603", "山东省威海市",
"861537487", "内蒙古包头市",
"861814234", "陕西省汉中市",
"86151493", "内蒙古包头市",
"861561240", "河北省廊坊市",
"861305096", "辽宁省葫芦岛市",
"861816447", "安徽省合肥市",
"861314720", "湖北省鄂州市",
"861577879", "广西玉林市",
"861780322", "河北省保定市",
"861335169", "黑龙江省大庆市",
"861815686", "安徽省阜阳市",
"861880631", "山东省威海市",
"861453094", "山西省阳泉市",
"861324088", "内蒙古呼和浩特市",
"861813909", "新疆巴音郭楞蒙古自治州",
"861310944", "甘肃省定西市",
"861876450", "山东省菏泽市",
"861579874", "云南省曲靖市",
"861536839", "云南省曲靖市",
"86139606", "福建省南平市",
"86147356", "山西省晋城市",
"861816619", "湖南省长沙市",
"86132274", "湖北省恩施土家族苗族自治州",
"861309818", "陕西省铜川市",
"861398994", "西藏林芝地区",
"861333219", "辽宁省锦州市",
"861341181", "广东省佛山市",
"861760721", "湖北省荆州市",
"861305526", "福建省福州市",
"86133446", "山东省德州市",
"861339466", "黑龙江省大庆市",
"861361699", "福建省南平市",
"86188010", "北京市",
"861815395", "甘肃省兰州市",
"861364374", "河南省许昌市",
"861454553", "新疆伊犁哈萨克自治州",
"861380449", "吉林省白山市",
"861370379", "河南省洛阳市",
"861339327", "河北省沧州市",
"861318433", "浙江省宁波市",
"86130466", "上海市",
"861536346", "广东省惠州市",
"861539586", "浙江省绍兴市",
"861390001", "辽宁省沈阳市",
"861879494", "甘肃省庆阳市",
"861309666", "山西省长治市",
"861570795", "江西省宜春市",
"861709412", "广东省深圳市",
"86157378", "河南省开封市",
"861396641", "安徽省安庆市",
"86153971", "浙江省杭州市",
"861890096", "辽宁省大连市",
"861564363", "吉林省长春市",
"861321590", "福建省三明市",
"861836180", "江苏省南通市",
"861534716", "湖北省黄冈市",
"861860141", "江苏省徐州市",
"861772035", "湖北省荆门市",
"86155765", "湖南省怀化市",
"861332722", "湖南省湘潭市",
"861517140", "湖北省十堰市",
"861320262", "广东省肇庆市",
"861586022", "福建省漳州市",
"861323508", "福建省莆田市",
"861839410", "甘肃省临夏回族自治州",
"861317709", "湖北省宜昌市",
"861570523", "江苏省淮安市",
"861332172", "广西柳州市",
"861569836", "山西省阳泉市",
"86139125", "江苏省盐城市",
"861890538", "山东省泰安市",
"861366469", "黑龙江省双鸭山市",
"861863809", "河南省周口市",
"861360844", "河南省驻马店市",
"861530754", "广东省汕头市",
"861839455", "甘肃省武威市",
"861597251", "湖北省咸宁市",
"861313014", "辽宁省本溪市",
"861302140", "河北省保定市",
"861304041", "浙江省宁波市",
"86185896", "海南省海口市",
"861835692", "安徽省黄山市",
"861596549", "山东省临沂市",
"861862441", "辽宁省沈阳市",
"861329867", "湖南省永州市",
"861855981", "福建省厦门市",
"861313747", "河南省周口市",
"861365750", "新疆喀什地区",
"861346199", "河南省鹤壁市",
"861599791", "湖北省随州市",
"861819493", "新疆伊犁哈萨克自治州",
"86177230", "重庆市",
"861301011", "北京市",
"861330640", "山东省济南市",
"861559631", "陕西省渭南市",
"861566675", "山东省济宁市",
"861365715", "湖北省荆门市",
"861867847", "山东省临沂市",
"861787576", "广东省揭阳市",
"861775414", "安徽省六安市",
"861805492", "福建省南平市",
"861390884", "云南省昆明市",
"861899934", "新疆昌吉回族自治州",
"861330472", "内蒙古包头市",
"86159923", "广东省潮州市",
"861361856", "贵州省铜仁地区",
"861367969", "四川省泸州市",
"86131201", "北京市",
"861300440", "江苏省常州市",
"861520527", "江苏省扬州市",
"861818878", "广东省惠州市",
"861526534", "山东省德州市",
"861303068", "安徽省阜阳市",
"861777116", "湖北省黄石市",
"861781715", "广东省云浮市",
"861323744", "湖南省张家界市",
"861528039", "福建省龙岩市",
"861312552", "辽宁省抚顺市",
"861370026", "陕西省汉中市",
"861820709", "江西省南昌市",
"861318670", "浙江省衢州市",
"861319864", "四川省南充市",
"86136759", "福建省泉州市",
"861813570", "河南省商丘市",
"861785856", "浙江省衢州市",
"861373013", "河北省邢台市",
"86158884", "浙江省温州市",
"861561591", "山东省聊城市",
"861471951", "甘肃省酒泉市",
"861586928", "浙江省金华市",
"86187839", "四川省南充市",
"861357905", "新疆喀什地区",
"861872825", "四川省资阳市",
"861336000", "广东省广州市",
"86132427", "广东省广州市",
"86184025", "江苏省南京市",
"861830848", "四川省绵阳市",
"861781750", "广东省江门市",
"86188240", "广东省江门市",
"861516537", "山东省济宁市",
"861353699", "广东省肇庆市",
"861368476", "内蒙古赤峰市",
"861510524", "江苏省宿迁市",
"861318442", "浙江省湖州市",
"861322530", "山东省菏泽市",
"861768033", "湖南省长沙市",
"861889447", "甘肃省金昌市",
"861502283", "新疆博尔塔拉蒙古自治州",
"86170895", "宁夏银川市",
"861390492", "辽宁省鞍山市",
"861533957", "贵州省毕节地区",
"861830329", "河北省沧州市",
"86159574", "浙江省宁波市",
"861572061", "江苏省南京市",
"861370038", "河北省沧州市",
"861364497", "辽宁省沈阳市",
"861895440", "山东省淄博市",
"861830564", "安徽省六安市",
"861539121", "内蒙古包头市",
"861450632", "黑龙江省佳木斯市",
"861536987", "河北省衡水市",
"861707390", "河南省焦作市",
"861895672", "安徽省阜阳市",
"86136702", "广东省深圳市",
"861454821", "广东省佛山市",
"861317283", "广东省揭阳市",
"861339785", "广西贵港市",
"861518901", "江苏省连云港市",
"861539771", "四川省资阳市",
"861316388", "福建省福州市",
"861866305", "山东省日照市",
"861319548", "安徽省阜阳市",
"861348774", "湖南省株洲市",
"86835", "四川省雅安市",
"861520097", "湖南省永州市",
"861369964", "四川省广安市",
"861328760", "山东省泰安市",
"86155910", "陕西省咸阳市",
"861768948", "福建省泉州市",
"861527153", "湖北省宜昌市",
"86177026", "广东省东莞市",
"861350511", "江苏省盐城市",
"861570851", "贵州省贵阳市",
"861554106", "辽宁省朝阳市",
"861334515", "山东省烟台市",
"861533335", "河北省秦皇岛市",
"861471578", "广东省深圳市",
"861362639", "山东省青岛市",
"86132665", "广东省深圳市",
"861334550", "安徽省滁州市",
"861871212", "安徽省宿州市",
"86152724", "湖北省荆州市",
"861562188", "山东省济南市",
"861320695", "黑龙江省鸡西市",
"861505593", "安徽省淮南市",
"86187656", "山东省潍坊市",
"861850537", "山东省济宁市",
"86182858", "贵州省六盘水市",
"861850880", "云南省昭通市",
"861535653", "浙江省温州市",
"86155972", "青海省海东地区",
"861776830", "江苏省无锡市",
"861359930", "福建省南平市",
"861524019", "安徽省合肥市",
"861380814", "四川省攀枝花市",
"861530941", "甘肃省甘南藏族自治州",
"861459234", "四川省成都市",
"86189774", "广西梧州市",
"861812181", "四川省南充市",
"861452412", "辽宁省鞍山市",
"861330853", "贵州省安顺市",
"861301957", "内蒙古鄂尔多斯市",
"861304690", "福建省莆田市",
"861458661", "湖南省邵阳市",
"861597440", "湖南省张家界市",
"861560743", "湖南省湘西土家族苗族自治州",
"861311443", "湖北省黄冈市",
"861597672", "广东省河源市",
"861870571", "浙江省杭州市",
"861515947", "福建省南平市",
"86180118", "广东省广州市",
"86139001", "上海市",
"86155917", "陕西省宝鸡市",
"861335348", "山西省运城市",
"861384856", "内蒙古赤峰市",
"861886821", "浙江省湖州市",
"861471508", "广东省深圳市",
"861364557", "安徽省宿州市",
"861474714", "内蒙古乌兰察布市",
"86184404", "新疆乌鲁木齐市",
"861825153", "江苏省宿迁市",
"861811028", "安徽省芜湖市",
"861705220", "云南省昆明市",
"861569903", "新疆和田地区",
"861700398", "河南省三门峡市",
"861573847", "河南省南阳市",
"861535392", "陕西省安康市",
"861884865", "贵州省六盘水市",
"861348704", "湖北省黄冈市",
"861770541", "山东省济南市",
"861505105", "江苏省盐城市",
"861301335", "云南省昆明市",
"861332063", "四川省遂宁市",
"861360419", "辽宁省辽阳市",
"861390552", "安徽省蚌埠市",
"861327481", "内蒙古呼和浩特市",
"861318985", "广东省江门市",
"861868908", "西藏拉萨市",
"86145804", "江苏省扬州市",
"861876241", "江苏省苏州市",
"861804898", "四川省宜宾市",
"861370456", "黑龙江省黑河市",
"861479473", "内蒙古鄂尔多斯市",
"861778792", "云南省普洱市",
"861534678", "甘肃省天水市",
"861883397", "河北省秦皇岛市",
"861377030", "江苏省南京市",
"861350688", "浙江省宁波市",
"86180501", "福建省福州市",
"861537692", "山东省临沂市",
"86132420", "广东省深圳市",
"861357975", "新疆石河子市",
"861338535", "山东省烟台市",
"861310751", "青海省海东地区",
"861336070", "广东省湛江市",
"861358203", "河北省石家庄市",
"861557981", "江西省上饶市",
"861807023", "江西省九江市",
"861513815", "河南省三门峡市",
"861306042", "陕西省西安市",
"861309274", "湖北省黄冈市",
"861581210", "云南省昆明市",
"861811036", "安徽省宣城市",
"86135198", "海南省海口市",
"861569168", "陕西省铜川市",
"861813500", "山西省忻州市",
"861513850", "河南省濮阳市",
"86134500", "广东省东莞市",
"861556669", "辽宁省葫芦岛市",
"861803435", "河北省唐山市",
"86139394", "河南省周口市",
"861820779", "广西北海市",
"861357146", "陕西省安康市",
"861870958", "宁夏银川市",
"861853073", "河南省新乡市",
"861360647", "山东省潍坊市",
"861303925", "吉林省吉林市",
"861588325", "四川省内江市",
"861362984", "河南省郑州市",
"861303746", "湖南省永州市",
"861506536", "山东省潍坊市",
"861530629", "江苏省南通市",
"86182973", "安徽省亳州市",
"861568230", "四川省泸州市",
"861536258", "广东省汕头市",
"861816139", "四川省内江市",
"861787506", "广东省梅州市",
"861888295", "四川省甘孜藏族自治州",
"861568871", "山东省威海市",
"861324445", "吉林省通化市",
"861529430", "甘肃省金昌市",
"861518558", "贵州省黔东南苗族侗族自治州",
"861320225", "广东省深圳市",
"861368885", "广东省广州市",
"861818808", "贵州省六盘水市",
"861586065", "福建省宁德市",
"861473020", "河北省沧州市",
"861396520", "安徽省铜陵市",
"861554738", "内蒙古乌海市",
"861397059", "江西省萍乡市",
"861500429", "辽宁省葫芦岛市",
"861386667", "安徽省马鞍山市",
"861575915", "福建省南平市",
"861595372", "山东省济宁市",
"861813343", "安徽省铜陵市",
"861533288", "内蒙古巴彦淖尔市",
"861707842", "云南省保山市",
"861379075", "广东省惠州市",
"861566605", "山东省烟台市",
"861337648", "山东省青岛市",
"861301618", "湖南省衡阳市",
"861816005", "四川省达州市",
"861559038", "吉林省白山市",
"861836801", "浙江省杭州市",
"861571674", "河南省周口市",
"861780836", "四川省甘孜藏族自治州",
"861769713", "青海省黄南藏族自治州",
"86182403", "辽宁省沈阳市",
"861707169", "河南省郑州市",
"861818887", "广东省深圳市",
"861889863", "广东省广州市",
"861512959", "陕西省延安市",
"861768029", "湖南省益阳市",
"861518251", "四川省泸州市",
"861331418", "辽宁省阜新市",
"861333575", "浙江省绍兴市",
"861780349", "山西省朔州市",
"861705567", "云南省昆明市",
"861327997", "新疆阿克苏地区",
"861596998", "山东省滨州市",
"861307959", "宁夏银川市",
"861303661", "四川省眉山市",
"86170820", "广东省东莞市",
"86180558", "安徽省阜阳市",
"861770479", "内蒙古锡林郭勒盟",
"861309312", "江苏省无锡市",
"861475108", "江苏省南京市",
"861398709", "云南省普洱市",
"8613919", "甘肃省兰州市",
"861560394", "河南省周口市",
"861348590", "安徽省阜阳市",
"86177943", "甘肃省白银市",
"861528725", "云南省西双版纳傣族自治州",
"861351952", "宁夏石嘴山市",
"861362623", "江苏省无锡市",
"86189591", "福建省福州市",
"861559943", "贵州省黔南布依族苗族自治州",
"861774436", "四川省达州市",
"861528946", "陕西省渭南市",
"861853414", "山西省临汾市",
"861360730", "湖南省岳阳市",
"861880379", "河南省洛阳市",
"861301277", "山东省日照市",
"86156092", "陕西省西安市",
"861501505", "广东省江门市",
"86185682", "河南省新乡市",
"861828884", "云南省迪庆藏族自治州",
"861866237", "江苏省扬州市",
"861359851", "河南省焦作市",
"861373404", "山西省太原市",
"86137010", "北京市",
"86180229", "广东省江门市",
"861858948", "西藏拉萨市",
"861760537", "山东省济宁市",
"861317994", "新疆昌吉回族自治州",
"86183205", "广东省揭阳市",
"861476525", "河南省郑州市",
"861583560", "山西省晋城市",
"861324469", "黑龙江省大庆市",
"861536978", "河北省沧州市",
"861370631", "山东省威海市",
"861538305", "河北省唐山市",
"861898695", "湖北省武汉市",
"86713", "湖北省黄冈市",
"861814555", "黑龙江省绥化市",
"861803759", "河南省平顶山市",
"861521452", "黑龙江省绥化市",
"861479014", "安徽省芜湖市",
"86152683", "浙江省嘉兴市",
"861562859", "西藏拉萨市",
"861575831", "云南省楚雄彝族自治州",
"861596401", "山东省济南市",
"861816703", "浙江省金华市",
"861844746", "内蒙古乌兰察布市",
"861332749", "山西省朔州市",
"861774428", "四川省德阳市",
"861319999", "新疆伊犁哈萨克自治州",
"861351314", "河北省承德市",
"861855557", "安徽省宿州市",
"861881380", "广东省江门市",
"861806789", "浙江省衢州市",
"861876548", "山东省泰安市",
"861857266", "湖北省荆门市",
"861346360", "河北省廊坊市",
"861524589", "黑龙江省伊春市",
"86147005", "北京市",
"861331960", "湖南省长沙市",
"861871304", "河北省廊坊市",
"861572816", "广东省惠州市",
"861815198", "江苏省常州市",
"861561628", "湖南省湘潭市",
"861775705", "浙江省宁波市",
"861527268", "湖北省咸宁市",
"861870617", "江苏省无锡市",
"861374073", "辽宁省营口市",
"861317613", "山东省泰安市",
"861780828", "四川省广元市",
"861571767", "河北省邢台市",
"861528872", "山东省菏泽市",
"861822600", "安徽省宿州市",
"86131562", "山东省青岛市",
"861532413", "河北省张家口市",
"861847689", "广东省广州市",
"86155402", "内蒙古包头市",
"861552891", "四川省雅安市",
"861326374", "广西梧州市",
"861897046", "江西省吉安市",
"86151611", "江苏省常州市",
"861510190", "甘肃省庆阳市",
"86151082", "四川省成都市",
"861309954", "宁夏固原市",
"861470512", "江苏省连云港市",
"861880932", "甘肃省定西市",
"861306990", "黑龙江省双鸭山市",
"861887284", "湖北省咸宁市",
"861452824", "四川省南充市",
"861831916", "广东省茂名市",
"86158798", "江西省抚州市",
"861852471", "辽宁省阜新市",
"861314566", "安徽省池州市",
"861591655", "广东省佛山市",
"861308148", "山东省菏泽市",
"86147286", "贵州省毕节地区",
"861380422", "辽宁省鞍山市",
"861471587", "广东省湛江市",
"861556645", "辽宁省朝阳市",
"861502613", "新疆和田地区",
"861846961", "云南省临沧市",
"861877270", "湖北省荆门市",
"861873562", "山西省晋城市",
"861852401", "辽宁省辽阳市",
"861590959", "宁夏中卫市",
"861471830", "广东省揭阳市",
"861762549", "江苏省常州市",
"861365583", "浙江省嘉兴市",
"861598686", "广东省汕头市",
"861807039", "江西省南昌市",
"861343734", "广东省江门市",
"861472711", "浙江省杭州市",
"861857807", "广东省肇庆市",
"861329956", "宁夏吴忠市",
"861555266", "山东省淄博市",
"861475736", "浙江省嘉兴市",
"86132495", "广东省汕头市",
"861510345", "山西省长治市",
"861893466", "湖北省黄石市",
"861872437", "黑龙江省绥化市",
"861771344", "四川省遂宁市",
"861326304", "江西省上饶市",
"861558841", "山东省威海市",
"861340889", "云南省临沧市",
"861399150", "陕西省商洛市",
"861317142", "内蒙古呼和浩特市",
"861335833", "福建省漳州市",
"86182801", "四川省成都市",
"861534687", "甘肃省张掖市",
"861776017", "四川省遂宁市",
"861520260", "宁夏银川市",
"861595046", "江苏省南京市",
"861596565", "山东省菏泽市",
"861350677", "浙江省温州市",
"86183242", "浙江省温州市",
"861365474", "内蒙古乌兰察布市",
"861530633", "山东省日照市",
"861334085", "四川省德阳市",
"861362293", "广东省清远市",
"861538375", "河北省唐山市",
"861534071", "山西省太原市",
"861473667", "云南省文山壮族苗族自治州",
"86188598", "福建省三明市",
"861882883", "四川省攀枝花市",
"861585284", "江苏省无锡市",
"861367726", "湖北省荆门市",
"861593297", "江西省抚州市",
"861452796", "新疆阿勒泰地区",
"861575200", "云南省昆明市",
"861345138", "内蒙古巴彦淖尔市",
"861536908", "河北省承德市",
"861338799", "江西省萍乡市",
"861860694", "福建省福州市",
"861319241", "广东省韶关市",
"861862579", "河南省洛阳市",
"861393410", "山西省运城市",
"86180262", "广东省广州市",
"861500433", "吉林省延边朝鲜族自治州",
"861596471", "山东省德州市",
"861509158", "陕西省西安市",
"86130746", "浙江省温州市",
"86145316", "上海市",
"86147988", "海南省海口市",
"861350764", "河南省驻马店市",
"861808153", "四川省达州市",
"861570930", "甘肃省临夏回族自治州",
"861760880", "云南省昆明市",
"861533618", "陕西省汉中市",
"861347424", "陕西省渭南市",
"861522996", "陕西省渭南市",
"861812760", "广东省云浮市",
"861533866", "贵州省黔南布依族苗族自治州",
"861800532", "山东省青岛市",
"861589101", "陕西省延安市",
"86138051", "江苏省南京市",
"86150758", "河北省衡水市",
"861808886", "广东省茂名市",
"861521873", "广东省深圳市",
"861373474", "内蒙古乌兰察布市",
"86137017", "上海市",
"86151246", "黑龙江省哈尔滨市",
"861508944", "广东省揭阳市",
"86180824", "甘肃省张掖市",
"861774058", "湖北省襄樊市",
"861383344", "河北省廊坊市",
"861301207", "河北省保定市",
"861802313", "广东省河源市",
"861345126", "湖北省十堰市",
"861880309", "河北省邢台市",
"861770409", "广东省肇庆市",
"86170827", "湖北省武汉市",
"861598395", "四川省巴中市",
"86156914", "陕西省西安市",
"861869622", "湖北省襄樊市",
"86159791", "江西省南昌市",
"861830711", "湖北省鄂州市",
"861522543", "河南省洛阳市",
"861533277", "内蒙古鄂尔多斯市",
"861573463", "黑龙江省牡丹江市",
"861380052", "江苏省泰州市",
"861860913", "陕西省渭南市",
"861502845", "河北省邯郸市",
"861556813", "吉林省白山市",
"861380786", "广西百色市",
"861363436", "吉林省白城市",
"861536491", "山西省太原市",
"861336174", "江西省萍乡市",
"861891937", "甘肃省酒泉市",
"861571604", "福建省龙岩市",
"861816075", "江西省宜春市",
"861375428", "浙江省丽水市",
"861581680", "广东省东莞市",
"861564975", "河南省三门峡市",
"861317845", "广东省清远市",
"861312716", "山东省潍坊市",
"861361242", "广东省揭阳市",
"861348450", "陕西省宝鸡市",
"861330737", "湖南省益阳市",
"861570317", "河北省沧州市",
"861550773", "广西桂林市",
"861772654", "四川省德阳市",
"861528453", "云南省昭通市",
"861868258", "四川省南充市",
"861836230", "江苏省泰州市",
"861475728", "浙江省温州市",
"86155445", "河北省石家庄市",
"861861328", "四川省资阳市",
"861826663", "山东省青岛市",
"861334783", "江苏省南京市",
"861523326", "河北省廊坊市",
"861335976", "黑龙江省佳木斯市",
"861318059", "河北省秦皇岛市",
"861800996", "新疆巴音郭楞蒙古自治州",
"861340310", "河北省邯郸市",
"861590490", "辽宁省盘锦市",
"86153401", "北京市",
"861700573", "浙江省嘉兴市",
"861520313", "河北省张家口市",
"861557682", "湖南省益阳市",
"861537991", "甘肃省临夏回族自治州",
"861876667", "山东省滨州市",
"861768306", "四川省甘孜藏族自治州",
"861313473", "内蒙古乌海市",
"861323587", "浙江省温州市",
"861539016", "四川省甘孜藏族自治州",
"861815044", "福建省莆田市",
"861323201", "广东省阳江市",
"86158302", "河北省保定市",
"861335145", "黑龙江省绥化市",
"861340355", "山西省长治市",
"861337220", "江苏省徐州市",
"861890231", "广东省深圳市",
"861828071", "四川省自贡市",
"861572547", "山东省济宁市",
"861309741", "云南省玉溪市",
"861571266", "浙江省台州市",
"861394941", "河南省开封市",
"861391282", "江苏省镇江市",
"861890870", "云南省昭通市",
"861351436", "吉林省白城市",
"86177365", "河北省唐山市",
"861768990", "福建省莆田市",
"86130696", "黑龙江省大庆市",
"861308094", "陕西省延安市",
"861319590", "甘肃省嘉峪关市",
"861528762", "云南省临沧市",
"861777591", "湖南省怀化市",
"861452164", "河北省衡水市",
"861472890", "西藏拉萨市",
"861571877", "云南省玉溪市",
"861576782", "广东省湛江市",
"86147212", "上海市",
"861390678", "浙江省丽水市",
"861576056", "四川省南充市",
"861581534", "广东省汕头市",
"861322046", "甘肃省兰州市",
"861313584", "湖北省恩施土家族苗族自治州",
"861380958", "福建省南平市",
"861825047", "福建省福州市",
"861786626", "湖北省武汉市",
"861707348", "河北省唐山市",
"861700484", "广东省深圳市",
"861531489", "浙江省丽水市",
"861840911", "陕西省延安市",
"861700195", "广东省广州市",
"861331324", "河北省保定市",
"861800543", "山东省滨州市",
"861894340", "吉林省四平市",
"86147277", "陕西省西安市",
"861534552", "安徽省蚌埠市",
"861340937", "河南省许昌市",
"861573752", "河南省周口市",
"861346924", "湖南省岳阳市",
"861551200", "河北省唐山市",
"861365397", "河南省郑州市",
"861344983", "广西北海市",
"861862396", "河南省驻马店市",
"861338254", "江苏省苏州市",
"861835249", "江苏省连云港市",
"861846434", "山东省淄博市",
"86138234", "广东省佛山市",
"861331569", "河北省秦皇岛市",
"861566019", "河南省南阳市",
"861871497", "安徽省铜陵市",
"861840427", "辽宁省盘锦市",
"861476562", "湖南省长沙市",
"861814919", "陕西省西安市",
"861316554", "河北省石家庄市",
"86137247", "广东省湛江市",
"86151016", "北京市",
"861859679", "福建省福州市",
"861300901", "吉林省长春市",
"861588136", "四川省宜宾市",
"861333934", "黑龙江省双鸭山市",
"861317133", "内蒙古巴彦淖尔市",
"861373397", "河南省漯河市",
"861335842", "福建省泉州市",
"861588778", "云南省楚雄彝族自治州",
"861565086", "安徽省阜阳市",
"861458962", "广东省阳江市",
"861569365", "甘肃省白银市",
"861889773", "广西桂林市",
"861880456", "黑龙江省黑河市",
"861345581", "山东省泰安市",
"86183681", "浙江省杭州市",
"861530642", "山东省青岛市",
"861366445", "吉林省通化市",
"861452627", "江苏省南通市",
"861776744", "新疆和田地区",
"861308369", "河南省郑州市",
"861321704", "江西省抚州市",
"861329788", "广西河池市",
"861530470", "内蒙古呼伦贝尔市",
"861588128", "四川省攀枝花市",
"86130579", "浙江省温州市",
"861834453", "广东省湛江市",
"861862685", "浙江省杭州市",
"861454780", "山东省济南市",
"861308524", "湖北省随州市",
"861319020", "辽宁省丹东市",
"861301776", "浙江省嘉兴市",
"86735", "湖南省郴州市",
"861376821", "广西南宁市",
"861325190", "浙江省宁波市",
"86187985", "贵州省黔东南苗族侗族自治州",
"861707757", "江西省景德镇市",
"86132582", "四川省成都市",
"861459510", "云南省临沧市",
"861812800", "广东省东莞市",
"861533706", "甘肃省甘南藏族自治州",
"861327813", "吉林省四平市",
"861300498", "福建省龙岩市",
"861324518", "内蒙古乌兰察布市",
"861760319", "河北省邢台市",
"86152062", "江苏省苏州市",
"861822433", "四川省内江市",
"86158359", "山西省运城市",
"86134273", "广东省江门市",
"861555382", "山东省东营市",
"861580585", "浙江省绍兴市",
"861804392", "吉林省吉林市",
"861470977", "青海省海西蒙古族藏族自治州",
"861559309", "甘肃省白银市",
"861521936", "广东省揭阳市",
"861560407", "辽宁省营口市",
"861311707", "湖北省黄冈市",
"861811373", "四川省广元市",
"861459555", "青海省果洛藏族自治州",
"86181874", "云南省曲靖市",
"861330698", "福建省三明市",
"861478392", "河南省鹤壁市",
"861770356", "山西省晋城市",
"861853849", "河南省信阳市",
"86136620", "天津市",
"861350804", "四川省资阳市",
"861700892", "山东省青岛市",
"861847505", "广东省梅州市",
"86181279", "广东省广州市",
"861815216", "甘肃省白银市",
"861539244", "福建省泉州市",
"861337690", "福建省漳州市",
"861850721", "湖北省荆州市",
"861560477", "内蒙古鄂尔多斯市",
"861533126", "河南省开封市",
"86158345", "吉林省通化市",
"861867752", "广西贵港市",
"861311777", "广西钦州市",
"861536072", "广东省湛江市",
"861342949", "浙江省绍兴市",
"861847575", "广东省佛山市",
"861506040", "福建省福州市",
"861350874", "云南省曲靖市",
"86136627", "广东省东莞市",
"861330236", "广东省肇庆市",
"861300558", "广东省肇庆市",
"86158648", "山东省临沂市",
"861313852", "广东省肇庆市",
"861533776", "江苏省南京市",
"861311127", "山西省临汾市",
"861885651", "安徽省芜湖市",
"861880943", "甘肃省白银市",
"861453190", "山西省晋中市",
"861894892", "广东省河源市",
"861594640", "黑龙江省七台河市",
"861518602", "贵州省铜仁地区",
"861318429", "浙江省温州市",
"861380287", "广东省惠州市",
"861470907", "新疆博尔塔拉蒙古自治州",
"861559379", "甘肃省嘉峪关市",
"861886780", "浙江省丽水市",
"861818939", "甘肃省陇南市",
"861880596", "福建省漳州市",
"861570539", "山东省临沂市",
"861537478", "内蒙古巴彦淖尔市",
"861321774", "广西梧州市",
"861530400", "辽宁省沈阳市",
"861363314", "河北省承德市",
"861811540", "江苏省无锡市",
"861898947", "浙江省杭州市",
"861823626", "河南省信阳市",
"861301706", "贵州省毕节地区",
"861596522", "山东省德州市",
"861821821", "广东省清远市",
"86153803", "江苏省扬州市",
"861329432", "吉林省吉林市",
"861820613", "江苏省苏州市",
"861553628", "山西省运城市",
"861780973", "青海省黄南藏族自治州",
"86155033", "河北省唐山市",
"861479747", "山西省运城市",
"861519049", "江苏省南京市",
"861836761", "浙江省嘉兴市",
"861550289", "四川省乐山市",
"861775162", "江苏省泰州市",
"861379447", "广东省深圳市",
"861334279", "广东省潮州市",
"861889703", "青海省西宁市",
"861868346", "四川省德阳市",
"86135783", "云南省丽江市",
"861367227", "江西省宜春市",
"861452297", "山西省吕梁市",
"861553636", "山西省晋中市",
"861894484", "江苏省泰州市",
"861818372", "云南省大理白族自治州",
"861504692", "黑龙江省双鸭山市",
"86137240", "广东省广州市",
"861803294", "河北省石家庄市",
"861859609", "山东省济南市",
"861300971", "黑龙江省哈尔滨市",
"861804840", "四川省南充市",
"861836084", "江苏省盐城市",
"861328538", "山东省泰安市",
"861319450", "黑龙江省哈尔滨市",
"861500985", "辽宁省营口市",
"861823638", "河南省商丘市",
"861835991", "福建省福州市",
"861390608", "福建省三明市",
"861862970", "吉林省松原市",
"861478840", "河南省洛阳市",
"861369656", "安徽省芜湖市",
"861871557", "安徽省宿州市",
"861596092", "福建省龙岩市",
"861316494", "浙江省杭州市",
"861363952", "宁夏石嘴山市",
"86136465", "浙江省温州市",
"861302044", "内蒙古鄂尔多斯市",
"861772857", "广东省汕尾市",
"861595808", "浙江省舟山市",
"861868839", "广东省广州市",
"861700340", "安徽省合肥市",
"861319415", "辽宁省丹东市",
"861810997", "新疆阿克苏地区",
"861800370", "河南省商丘市",
"861894573", "黑龙江省黑河市",
"861372245", "河北省石家庄市",
"861303489", "湖南省怀化市",
"861457189", "浙江省台州市",
"861335390", "河南省洛阳市",
"861520731", "湖南省长沙市",
"861813259", "河北省保定市",
"861527047", "江西省吉安市",
"86181633", "湖北省武汉市",
"861830342", "山西省大同市",
"861533138", "四川省成都市",
"861897878", "广西贵港市",
"861590550", "安徽省滁州市",
"861772179", "江苏省徐州市",
"861347318", "河北省衡水市",
"861597498", "云南省玉溪市",
"861333689", "浙江省宁波市",
"861326497", "湖北省武汉市",
"861327645", "山东省烟台市",
"861838589", "贵州省铜仁地区",
"861304648", "山东省潍坊市",
"861503569", "山西省太原市",
"861335906", "安徽省阜阳市",
"861362371", "河南省郑州市",
"861537249", "浙江省台州市",
"86152029", "陕西省西安市",
"861323271", "广东省湛江市",
"861820994", "新疆昌吉回族自治州",
"861568180", "四川省甘孜藏族自治州",
"861768376", "湖北省鄂州市",
"861313403", "江西省抚州市",
"861816863", "江苏省连云港市",
"861816289", "湖北省黄冈市",
"86187008", "陕西省西安市",
"861579800", "江西省抚州市",
"861364996", "新疆塔城地区",
"861325520", "江苏省无锡市",
"861510641", "山东省淄博市",
"861881558", "安徽省阜阳市",
"861766048", "山东省潍坊市",
"861867640", "广东省中山市",
"861567892", "广西南宁市",
"861454816", "广东省深圳市",
"861863835", "河南省洛阳市",
"861889946", "新疆塔城地区",
"861312319", "福建省福州市",
"861315841", "四川省阿坝藏族羌族自治州",
"861580424", "辽宁省大连市",
"861336566", "安徽省池州市",
"86158312", "河北省保定市",
"861335045", "四川省甘孜藏族自治州",
"861586437", "山东省聊城市",
"861889725", "青海省果洛藏族自治州",
"861501851", "广东省深圳市",
"861317735", "湖北省黄冈市",
"86159908", "浙江省丽水市",
"861801287", "江苏省南通市",
"861328874", "河北省石家庄市",
"861815144", "江苏省扬州市",
"861594752", "内蒙古包头市",
"861382452", "广东省佛山市",
"861830969", "宁夏银川市",
"861879515", "宁夏中卫市",
"86130785", "贵州省贵阳市",
"86158377", "河南省南阳市",
"861380791", "江西省南昌市",
"861311457", "黑龙江省大兴安岭地区",
"861536486", "山西省晋城市",
"861454668", "广东省深圳市",
"861503656", "河南省洛阳市",
"861318159", "山东省菏泽市",
"861450854", "江苏省扬州市",
"86151006", "河北省廊坊市",
"861588036", "福建省龙岩市",
"861808891", "云南省玉溪市",
"861818210", "湖南省长沙市",
"861880706", "江西省吉安市",
"861322975", "广东省珠海市",
"861576883", "广东省潮州市",
"861560829", "四川省巴中市",
"861856929", "湖南省邵阳市",
"861551312", "山西省长治市",
"861522981", "陕西省延安市",
"86155486", "内蒙古鄂尔多斯市",
"861874785", "内蒙古通辽市",
"861508565", "贵州省黔东南苗族侗族自治州",
"861829868", "甘肃省白银市",
"86183059", "福建省福州市",
"861301596", "福建省莆田市",
"861780068", "内蒙古呼和浩特市",
"861569489", "河北省石家庄市",
"86130557", "福建省福州市",
"861813748", "河南省商丘市",
"861538671", "山西省朔州市",
"861365629", "江苏省南通市",
"86152833", "四川省乐山市",
"861475972", "福建省福州市",
"861322146", "浙江省台州市",
"861825147", "江苏省镇江市",
"861318877", "山东省烟台市",
"861334377", "河南省南阳市",
"861364543", "山东省滨州市",
"861588598", "贵州省黔西南布依族苗族自治州",
"861369569", "安徽省合肥市",
"861559618", "陕西省西安市",
"861866078", "山东省济南市",
"861760608", "福建省三明市",
"861889593", "云南省保山市",
"861301038", "福建省福州市",
"861350526", "江苏省泰州市",
"861321454", "黑龙江省佳木斯市",
"861308485", "陕西省延安市",
"861373941", "四川省资阳市",
"861889023", "湖南省长沙市",
"861319120", "山西省忻州市",
"861350096", "吉林省四平市",
"861777121", "湖北省孝感市",
"861593506", "山西省晋城市",
"861452781", "新疆乌鲁木齐市",
"86131989", "海南省海口市",
"861813935", "新疆伊犁哈萨克自治州",
"861367564", "安徽省六安市",
"861338396", "河南省驻马店市",
"86156295", "湖北省孝感市",
"861367329", "河北省唐山市",
"861313425", "辽宁省鞍山市",
"861387274", "湖北省恩施土家族苗族自治州",
"861452399", "西藏拉萨市",
"861370288", "广东省湛江市",
"861360653", "浙江省杭州市",
"861347679", "湖北省武汉市",
"861829544", "宁夏固原市",
"86185832", "四川省成都市",
"861567195", "湖北省孝感市",
"861806225", "湖北省襄樊市",
"86185125", "江苏省南京市",
"861560348", "山西省运城市",
"861319770", "广西防城港市",
"861350538", "山东省泰安市",
"86183002", "山东省青岛市",
"861552561", "山西省阳泉市",
"861302992", "黑龙江省绥化市",
"861893183", "河北省衡水市",
"861317033", "湖南省衡阳市",
"861813357", "河北省张家口市",
"861876024", "福建省宁德市",
"861471740", "江西省南昌市",
"861535419", "河北省邢台市",
"86185606", "山东省青岛市",
"861327712", "湖北省孝感市",
"861858994", "广西桂林市",
"861502948", "陕西省西安市",
"86155829", "山西省运城市",
"861360392", "河南省鹤壁市",
"861344290", "陕西省渭南市",
"861379378", "山东省济宁市",
"861537347", "河北省邯郸市",
"861393865", "河南省平顶山市",
"861368977", "吉林省白城市",
"861843141", "河北省石家庄市",
"861505619", "安徽省淮北市",
"861558731", "山东省日照市",
"861370011", "辽宁省大连市",
"861598691", "广东省揭阳市",
"86147528", "江苏省镇江市",
"86138590", "福建省福州市",
"861814801", "四川省绵阳市",
"861317948", "江苏省镇江市",
"861700793", "江西省九江市",
"861325090", "浙江省嘉兴市",
"861587889", "广西柳州市",
"861561244", "河北省廊坊市",
"861314724", "湖北省咸宁市",
"861362589", "浙江省金华市",
"86139565", "安徽省安庆市",
"86158901", "河南省郑州市",
"861390319", "河北省邢台市",
"861571429", "辽宁省葫芦岛市",
"861453090", "山西省阳泉市",
"861303365", "浙江省台州市",
"86138597", "福建省泉州市",
"861846719", "青海省果洛藏族自治州",
"861536722", "湖南省湘西土家族苗族自治州",
"861599137", "陕西省咸阳市",
"861313753", "河南省平顶山市",
"86152431", "吉林省长春市",
"861383398", "河北省沧州市",
"861506140", "江苏省连云港市",
"861894793", "内蒙古兴安盟",
"861514491", "内蒙古兴安盟",
"861314174", "江苏省南通市",
"861850687", "浙江省嘉兴市",
"86182863", "贵州省安顺市",
"861865484", "山东省枣庄市",
"861822888", "四川省巴中市",
"861840879", "云南省普洱市",
"861379308", "山东省聊城市",
"861809993", "新疆石河子市",
"861536172", "广东省肇庆市",
"861859318", "云南省曲靖市",
"861552886", "四川省资阳市",
"861319700", "湖北省黄石市",
"861338970", "青海省海北藏族自治州",
"861777701", "广西防城港市",
"861810341", "山西省太原市",
"86137275", "广东省韶关市",
"861324727", "湖北省襄樊市",
"861837419", "湖南省永州市",
"861894525", "黑龙江省大庆市",
"861450582", "辽宁省阜新市",
"86180454", "黑龙江省佳木斯市",
"861322680", "广东省汕头市",
"861519149", "陕西省铜川市",
"861583342", "河北省保定市",
"861332839", "福建省南平市",
"861308942", "吉林省长春市",
"86134098", "湖北省黄冈市",
"86159206", "广东省东莞市",
"861573472", "内蒙古包头市",
"86152674", "浙江省杭州市",
"86147854", "贵州省贵阳市",
"861873892", "河南省平顶山市",
"861377280", "陕西省汉中市",
"861786912", "云南省文山壮族苗族自治州",
"861381543", "江苏省南京市",
"861387204", "湖北省黄冈市",
"861889802", "西藏日喀则地区",
"861365299", "广东省汕尾市",
"861458349", "江西省景德镇市",
"861334307", "河北省沧州市",
"861345309", "山西省朔州市",
"861346542", "山东省青岛市",
"861328196", "四川省宜宾市",
"861582548", "浙江省台州市",
"861359193", "辽宁省辽阳市",
"86181184", "江苏省苏州市",
"861385282", "江苏省宿迁市",
"861513657", "河南省驻马店市",
"86184551", "安徽省合肥市",
"861530750", "广东省江门市",
"861811286", "江苏省常州市",
"861516071", "福建省厦门市",
"861313010", "辽宁省本溪市",
"861336881", "云南省西双版纳傣族自治州",
"861302144", "河北省沧州市",
"861760678", "浙江省丽水市",
"861536875", "云南省保山市",
"861514908", "内蒙古赤峰市",
"861360840", "河南省商丘市",
"861847523", "广东省梅州市",
"86180065", "浙江省金华市",
"861898789", "云南省昆明市",
"861533943", "甘肃省白银市",
"861771398", "四川省成都市",
"861872049", "江西省萍乡市",
"861889453", "甘肃省临夏回族自治州",
"861880776", "广西百色市",
"861321594", "福建省厦门市",
"861836184", "江苏省连云港市",
"861802841", "广东省湛江市",
"861886668", "山东省东营市",
"861308267", "山东省威海市",
"861333851", "福建省莆田市",
"861515446", "山东省潍坊市",
"861313055", "辽宁省营口市",
"861370335", "河北省秦皇岛市",
"86187018", "上海市",
"861577132", "内蒙古乌海市",
"861831665", "广东省揭阳市",
"86157979", "江西省南昌市",
"861533596", "湖北省十堰市",
"861801571", "四川省自贡市",
"861556341", "山东省莱芜市",
"861364370", "河南省商丘市",
"861366531", "山东省济南市",
"861879490", "甘肃省张掖市",
"861780925", "陕西省安康市",
"861525549", "安徽省阜阳市",
"861526302", "山东省枣庄市",
"86158370", "河南省商丘市",
"861860648", "山东省日照市",
"861801465", "江苏省盐城市",
"861311597", "福建省宁德市",
"861398990", "西藏拉萨市",
"861527147", "湖北省宜昌市",
"861876454", "山东省滨州市",
"86181257", "广东省佛山市",
"86155862", "湖北省孝感市",
"861579870", "云南省临沧市",
"861457089", "江苏省淮安市",
"861351158", "江苏省南通市",
"861370957", "宁夏银川市",
"861457205", "四川省绵阳市",
"861781754", "广东省汕头市",
"861566639", "山东省临沂市",
"861555429", "山东省枣庄市",
"861577143", "内蒙古赤峰市",
"861336004", "广东省广州市",
"86152265", "河北省石家庄市",
"861331899", "广东省河源市",
"861325641", "山东省济南市",
"861893229", "江苏省盐城市",
"861775103", "江苏省南京市",
"861850552", "安徽省蚌埠市",
"861889762", "广西柳州市",
"861844973", "新疆巴音郭楞蒙古自治州",
"861320953", "宁夏吴忠市",
"861510520", "江苏省徐州市",
"861319860", "四川省攀枝花市",
"861768129", "安徽省黄山市",
"861813574", "河南省商丘市",
"861707069", "辽宁省沈阳市",
"861323740", "湖南省岳阳市",
"86182413", "辽宁省抚顺市",
"861761427", "辽宁省盘锦市",
"861709781", "浙江省台州市",
"86157725", "贵州省黔东南苗族侗族自治州",
"861318674", "浙江省丽水市",
"861776798", "吉林省松原市",
"861890688", "浙江省丽水市",
"861509436", "江苏省扬州市",
"861390880", "云南省昆明市",
"861816453", "浙江省丽水市",
"861899930", "新疆克拉玛依市",
"861346533", "山东省淄博市",
"86150443", "吉林省长春市",
"861775410", "安徽省阜阳市",
"861806947", "浙江省舟山市",
"861892712", "广东省潮州市",
"86135774", "云南省曲靖市",
"861528075", "福建省南平市",
"861526530", "山东省菏泽市",
"861333093", "四川省眉山市",
"861803409", "河北省邢台市",
"861580318", "河北省衡水市",
"861300444", "江苏省泰州市",
"861819668", "安徽省阜阳市",
"86137000", "辽宁省沈阳市",
"861328677", "广东省梅州市",
"861811362", "四川省德阳市",
"86183831", "四川省宜宾市",
"861539636", "福建省漳州市",
"861365754", "新疆喀什地区",
"861452506", "山东省日照市",
"861533932", "甘肃省定西市",
"86153463", "河南省驻马店市",
"861332987", "湖北省襄樊市",
"861338509", "福建省三明市",
"86396", "河南省驻马店市",
"861882367", "广东省深圳市",
"861593399", "河北省石家庄市",
"861589071", "河南省驻马店市",
"861330644", "山东省济南市",
"861450657", "黑龙江省鹤岗市",
"861303253", "江苏省苏州市",
"861581923", "广东省韶关市",
"861833609", "河南省新乡市",
"861808423", "贵州省黔南布依族苗族自治州",
"861500888", "云南省玉溪市",
"861334554", "安徽省淮南市",
"861454547", "新疆吐鲁番地区",
"861836919", "山东省威海市",
"861308933", "吉林省延边朝鲜族自治州",
"861313462", "山西省大同市",
"861848547", "贵州省黔东南苗族侗族自治州",
"861509428", "云南省昭通市",
"86136805", "广东省阳江市",
"86134150", "广东省汕头市",
"861459801", "湖北省黄石市",
"861583333", "河北省保定市",
"861786507", "山东省临沂市",
"861700562", "浙江省温州市",
"861882438", "广东省茂名市",
"861857059", "湖南省岳阳市",
"861312537", "江西省赣州市",
"861508092", "湖南省邵阳市",
"861880581", "浙江省杭州市",
"861301309", "安徽省合肥市",
"861369960", "四川省绵阳市",
"861328764", "山东省泰安市",
"861386700", "浙江省衢州市",
"861333523", "山东省淄博市",
"861505139", "江苏省淮安市",
"861335488", "内蒙古呼和浩特市",
"86180151", "江苏省淮安市",
"86158386", "河南省周口市",
"86155477", "内蒙古鄂尔多斯市",
"861362675", "浙江省绍兴市",
"861559776", "贵州省遵义市",
"861707394", "河南省周口市",
"861333795", "江苏省徐州市",
"861550453", "黑龙江省牡丹江市",
"861308048", "河北省唐山市",
"861879959", "新疆和田地区",
"861560256", "广东省佛山市",
"861325929", "陕西省汉中市",
"861327341", "河北省石家庄市",
"86189198", "甘肃省兰州市",
"861533379", "河南省洛阳市",
"861528123", "四川省攀枝花市",
"861831292", "浙江省温州市",
"86151601", "福建省宁德市",
"861318767", "云南省楚雄彝族自治州",
"86185394", "河南省郑州市",
"861322534", "山东省德州市",
"86186491", "天津市",
"861398459", "贵州省毕节地区",
"861805880", "浙江省杭州市",
"86155412", "辽宁省鞍山市",
"861830560", "安徽省亳州市",
"861895444", "山东省淄博市",
"861476573", "福建省福州市",
"861375158", "广东省惠州市",
"861356147", "山东省聊城市",
"861869361", "甘肃省张掖市",
"86134889", "四川省成都市",
"861889387", "甘肃省天水市",
"861818363", "云南省红河哈尼族彝族自治州",
"861886547", "山东省济宁市",
"861592520", "云南省昆明市",
"861339967", "安徽省亳州市",
"861342286", "广东省深圳市",
"86150841", "辽宁省锦州市",
"861880618", "江苏省无锡市",
"861302536", "广东省韶关市",
"861377034", "江苏省南京市",
"861770759", "广东省湛江市",
"861708531", "山东省济南市",
"86134284", "广东省东莞市",
"861332258", "西藏拉萨市",
"861536765", "湖南省邵阳市",
"861550593", "福建省宁德市",
"861839849", "四川省凉山彝族自治州",
"861476503", "北京市",
"861705224", "内蒙古包头市",
"861555059", "山东省聊城市",
"86183433", "吉林省延边朝鲜族自治州",
"861362605", "福建省泉州市",
"861880866", "湖北省随州市",
"861305511", "湖南省株洲市",
"86153861", "湖南省常德市",
"861824087", "陕西省宝鸡市",
"861474710", "内蒙古呼和浩特市",
"861357372", "山东省威海市",
"861807139", "湖北省荆门市",
"86155470", "内蒙古呼伦贝尔市",
"861533309", "山西省运城市",
"861808755", "云南省昆明市",
"861582667", "湖北省恩施土家族苗族自治州",
"861829708", "青海省海东地区",
"861348700", "湖北省随州市",
"861398599", "贵州省黔西南布依族苗族自治州",
"861302098", "浙江省金华市",
"861853739", "河南省开封市",
"86186325", "河北省唐山市",
"861516492", "内蒙古通辽市",
"86139896", "浙江省台州市",
"861301379", "江苏省苏州市",
"861595975", "福建省南平市",
"861894562", "黑龙江省大庆市",
"861335732", "湖南省湘潭市",
"861476340", "山东省莱芜市",
"861860567", "安徽省宿州市",
"861308766", "陕西省咸阳市",
"861345038", "广东省广州市",
"861810712", "湖北省孝感市",
"861479580", "广西南宁市",
"861882782", "江西省宜春市",
"861599617", "江苏省淮安市",
"861579760", "江西省新余市",
"861820948", "甘肃省天水市",
"861565091", "青海省海南藏族自治州",
"861459230", "四川省成都市",
"861814084", "新疆哈密地区",
"86186628", "江苏省南通市",
"861770827", "广东省中山市",
"861776834", "江苏省无锡市",
"861595146", "江苏省徐州市",
"861816023", "新疆吐鲁番地区",
"86138689", "浙江省金华市",
"86182811", "四川省泸州市",
"861776117", "四川省广元市",
"861359934", "福建省龙岩市",
"861380810", "四川省德阳市",
"861597444", "湖南省张家界市",
"861550946", "甘肃省张掖市",
"861590388", "河南省新乡市",
"861573521", "山西省太原市",
"861534721", "湖北省黄冈市",
"861562518", "广东省揭阳市",
"861317042", "湖南省湘潭市",
"861324238", "广东省清远市",
"861304694", "福建省宁德市",
"861550725", "湖北省黄冈市",
"861816872", "江苏省苏州市",
"861862381", "河南省安阳市",
"861452576", "福建省泉州市",
"861361513", "江苏省徐州市",
"861890511", "江苏省盐城市",
"861842027", "广东省茂名市",
"861857429", "河南省驻马店市",
"861573091", "甘肃省甘南藏族自治州",
"861875143", "江苏省盐城市",
"861539298", "湖北省宜昌市",
"861357939", "新疆阿克苏地区",
"861338579", "浙江省金华市",
"861324226", "广东省揭阳市",
"861364532", "山东省青岛市",
"861563312", "河北省保定市",
"861554342", "吉林省吉林市",
"86132922", "河北省衡水市",
"861808053", "四川省成都市",
"861826251", "江苏省南通市",
"861891202", "江苏省徐州市",
"86186893", "广东省中山市",
"861568234", "四川省巴中市",
"861526887", "浙江省台州市",
"86145306", "上海市",
"861820735", "湖南省郴州市",
"861529434", "甘肃省金昌市",
"861390537", "山东省济宁市",
"861840769", "广东省东莞市",
"861473024", "河北省沧州市",
"861831622", "广东省河源市",
"861772285", "广东省广州市",
"861398029", "四川省巴中市",
"861302528", "广东省梅州市",
"861813504", "山西省忻州市",
"861513854", "河南省濮阳市",
"861850492", "内蒙古包头市",
"861310549", "山东省临沂市",
"861362980", "河南省洛阳市",
"861337141", "山东省东营市",
"861816175", "陕西省安康市",
"86177771", "广西南宁市",
"861809817", "广东省佛山市",
"861550023", "吉林省白山市",
"861800981", "辽宁省朝阳市",
"861336074", "广东省茂名市",
"861768709", "云南省普洱市",
"861380152", "江苏省无锡市",
"861309831", "湖北省荆州市",
"861823018", "河北省衡水市",
"861339242", "广东省深圳市",
"861538323", "河北省石家庄市",
"861535995", "福建省南平市",
"861514823", "内蒙古包头市",
"861309270", "湖北省鄂州市",
"861581214", "云南省昆明市",
"86188191", "广东省广州市",
"861550872", "云南省大理白族自治州",
"861519437", "山东省泰安市",
"861816725", "浙江省湖州市",
"861775173", "江苏省徐州市",
"861816946", "湖南省永州市",
"861453641", "江苏省镇江市",
"86184383", "河南省商丘市",
"861330607", "福建省龙岩市",
"861566029", "湖南省永州市",
"861840417", "辽宁省营口市",
"86151686", "浙江省台州市",
"861560498", "辽宁省阜新市",
"861458559", "山东省日照市",
"861311798", "江西省景德镇市",
"861308646", "四川省乐山市",
"861331314", "河北省承德市",
"861571734", "湖南省衡阳市",
"861477306", "湖南省常德市",
"861346914", "湖南省常德市",
"861320579", "浙江省金华市",
"861314439", "吉林省白山市",
"861313700", "河南省商丘市",
"861524042", "江苏省苏州市",
"861786616", "甘肃省庆阳市",
"861300407", "安徽省蚌埠市",
"861315601", "山东省济南市",
"861338446", "吉林省白城市",
"861837159", "湖北省武汉市",
"861871991", "新疆阿勒泰地区",
"861840921", "陕西省延安市",
"861860878", "云南省楚雄彝族自治州",
"861567550", "安徽省滁州市",
"861556978", "甘肃省酒泉市",
"861810551", "安徽省合肥市",
"861477990", "江西省新余市",
"861452449", "黑龙江省佳木斯市",
"86150620", "江苏省徐州市",
"861554001", "内蒙古兴安盟",
"861558305", "四川省阿坝藏族羌族自治州",
"861879892", "西藏日喀则地区",
"86715", "湖北省咸宁市",
"86147211", "上海市",
"861537497", "内蒙古通辽市",
"861536645", "江苏省盐城市",
"861305086", "辽宁省盘锦市",
"861802087", "福建省福州市",
"861309365", "安徽省蚌埠市",
"861817685", "广西南宁市",
"861360670", "浙江省杭州市",
"861459090", "广东省韶关市",
"86158301", "河北省石家庄市",
"861378843", "广西桂林市",
"861832471", "安徽省合肥市",
"861453084", "安徽省合肥市",
"86153402", "上海市",
"861865490", "山东省烟台市",
"861520323", "河北省张家口市",
"861527659", "新疆和田地区",
"861896720", "浙江省舟山市",
"861539026", "四川省绵阳市",
"861803993", "河南省三门峡市",
"861373308", "安徽省宿州市",
"861324536", "山东省日照市",
"861360442", "吉林省长春市",
"861523316", "河北省廊坊市",
"86156579", "浙江省金华市",
"861336047", "广东省东莞市",
"861364222", "广东省汕头市",
"861593137", "河北省衡水市",
"861837877", "广西玉林市",
"861319753", "广西贺州市",
"861340320", "河北省邯郸市",
"861572166", "山西省晋城市",
"861310476", "广东省东莞市",
"86159642", "山东省青岛市",
"861802671", "广东省揭阳市",
"86156696", "浙江省金华市",
"861815385", "湖南省郴州市",
"861864829", "内蒙古赤峰市",
"861365308", "广东省云浮市",
"861452278", "山西省吕梁市",
"861895407", "山东省济宁市",
"861584706", "内蒙古赤峰市",
"861876837", "浙江省湖州市",
"861876114", "江苏省宿迁市",
"861873490", "山西省太原市",
"861539596", "福建省漳州市",
"861351418", "辽宁省阜新市",
"861889400", "甘肃省兰州市",
"86157379", "河南省洛阳市",
"861370771", "广西南宁市",
"861879195", "陕西省渭南市",
"861780274", "湖北省荆州市",
"861453761", "广西南宁市",
"861801160", "四川省绵阳市",
"861470565", "安徽省芜湖市",
"861530703", "江西省上饶市",
"861376811", "广西南宁市",
"861760564", "安徽省六安市",
"86139754", "湖南省衡阳市",
"861322913", "广东省江门市",
"86132581", "四川省成都市",
"861459520", "云南省德宏傣族景颇族自治州",
"861306019", "四川省绵阳市",
"861810978", "青海省西宁市",
"861361689", "浙江省金华市",
"861327823", "吉林省延边朝鲜族自治州",
"861560901", "四川省绵阳市",
"861539038", "四川省自贡市",
"861773692", "河北省石家庄市",
"861814641", "新疆乌鲁木齐市",
"861521460", "黑龙江省大庆市",
"861308514", "湖北省武汉市",
"861777011", "江西省赣州市",
"861519657", "四川省雅安市",
"861452617", "江苏省苏州市",
"861592230", "安徽省芜湖市",
"861475606", "河北省廊坊市",
"861886483", "山东省泰安市",
"861840649", "山西省运城市",
"861833414", "贵州省安顺市",
"861339851", "贵州省贵阳市",
"861890086", "广东省佛山市",
"861786544", "山东省德州市",
"86183682", "浙江省宁波市",
"861326478", "湖北省襄樊市",
"861569741", "湖南省株洲市",
"861454504", "湖南省常德市",
"861705534", "广东省中山市",
"861551661", "河南省新乡市",
"861580739", "湖南省邵阳市",
"861870796", "江西省吉安市",
"861819748", "青海省玉树藏族自治州",
"861771448", "江苏省扬州市",
"861832998", "陕西省商洛市",
"861597407", "湖南省永州市",
"861841945", "甘肃省武威市",
"861520252", "青海省海东地区",
"861898441", "贵州省六盘水市",
"861399162", "陕西省汉中市",
"861454574", "四川省巴中市",
"861364353", "山西省阳泉市",
"861845820", "浙江省杭州市",
"861379941", "福建省福州市",
"861596512", "山东省枣庄市",
"86184519", "江苏省镇江市",
"861821811", "广东省肇庆市",
"861397261", "湖北省武汉市",
"86152243", "山东省聊城市",
"861388693", "湖北省荆门市",
"861363569", "安徽省合肥市",
"86159126", "云南省大理白族自治州",
"861302385", "福建省莆田市",
"861308180", "河北省衡水市",
"861363324", "河北省承德市",
"86170908", "北京市",
"86147169", "广东省广州市",
"861879503", "宁夏吴忠市",
"86132878", "山东省威海市",
"861530773", "广西桂林市",
"861350737", "湖南省益阳市",
"86158912", "陕西省榆林市",
"861539456", "福建省漳州市",
"861589890", "山东省济南市",
"86137676", "江西省抚州市",
"861390697", "福建省龙岩市",
"861780204", "广东省中山市",
"861325761", "广东省汕尾市",
"861856871", "河南省新乡市",
"86136399", "新疆乌鲁木齐市",
"861560971", "青海省西宁市",
"861311834", "四川省眉山市",
"861454483", "湖北省武汉市",
"861364692", "福建省龙岩市",
"861360985", "辽宁省大连市",
"861311117", "山西省临汾市",
"861318419", "山东省威海市",
"861573800", "河南省濮阳市",
"861392476", "广东省汕头市",
"861895477", "山东省菏泽市",
"861584776", "内蒙古呼和浩特市",
"861356174", "山东省莱芜市",
"86150465", "黑龙江省绥化市",
"861811131", "四川省甘孜藏族自治州",
"861365378", "河南省开封市",
"861871478", "黑龙江省伊春市",
"861370701", "江西省鹰潭市",
"861815226", "甘肃省庆阳市",
"861533116", "辽宁省锦州市",
"861310182", "江苏省徐州市",
"861881348", "广东省惠州市",
"861333233", "辽宁省辽阳市",
"861858980", "广西南宁市",
"861373378", "河南省平顶山市",
"861508232", "四川省眉山市",
"861590525", "江苏省扬州市",
"861383448", "山西省运城市",
"861503314", "河北省承德市",
"861304534", "黑龙江省牡丹江市",
"861538841", "四川省雅安市",
"861837807", "广西桂林市",
"861537557", "安徽省宿州市",
"861310406", "黑龙江省双鸭山市",
"861338953", "宁夏吴忠市",
"861344284", "广西柳州市",
"861535266", "新疆哈密地区",
"861815238", "宁夏中卫市",
"861535159", "江苏省泰州市",
"861813547", "山西省太原市",
"861473634", "广西防城港市",
"861325084", "浙江省杭州市",
"861771279", "江苏省常州市",
"86181160", "上海市",
"861832401", "新疆乌鲁木齐市",
"861318647", "江苏省连云港市",
"861772719", "广东省东莞市",
"86137599", "陕西省西安市",
"861893539", "山西省临汾市",
"861332496", "云南省昭通市",
"861358799", "浙江省温州市",
"861871249", "安徽省蚌埠市",
"861319425", "辽宁省鞍山市",
"861300477", "浙江省台州市",
"861515685", "安徽省马鞍山市",
"86159450", "黑龙江省哈尔滨市",
"861552170", "广东省广州市",
"86131389", "海南省海口市",
"861806974", "浙江省绍兴市",
"861899856", "广东省茂名市",
"86150627", "江苏省南通市",
"861470998", "新疆乌鲁木齐市",
"861860808", "四川省绵阳市",
"861560558", "安徽省阜阳市",
"861458499", "山东省烟台市",
"861590793", "江西省上饶市",
"861810491", "辽宁省朝阳市",
"861805697", "安徽省阜阳市",
"861302696", "广西百色市",
"861872464", "黑龙江省七台河市",
"861550633", "山东省日照市",
"861579402", "广东省广州市",
"861330677", "浙江省温州市",
"861313770", "河南省郑州市",
"86186779", "广西北海市",
"861320509", "福建省泉州市",
"86135293", "云南省昆明市",
"861355833", "广西桂林市",
"861315087", "内蒙古鄂尔多斯市",
"86152666", "山东省临沂市",
"861348753", "湖南省郴州市",
"861302177", "山东省泰安市",
"86182845", "四川省成都市",
"861572838", "广东省阳江市",
"86180119", "广东省广州市",
"861476515", "广东省广州市",
"861598531", "贵州省安顺市",
"861300069", "广西南宁市",
"861370861", "云南省西双版纳傣族自治州",
"861550470", "内蒙古呼伦贝尔市",
"861807474", "广西梧州市",
"861569954", "吉林省通化市",
"86186925", "湖南省怀化市",
"861476550", "福建省福州市",
"861773487", "河南省许昌市",
"861805945", "福建省莆田市",
"86185681", "河南省洛阳市",
"861550642", "山东省菏泽市",
"861812191", "四川省南充市",
"86187346", "山西省大同市",
"861568148", "四川省达州市",
"86139543", "山东省滨州市",
"861302727", "江西省九江市",
"86182254", "重庆市",
"861353934", "广东省佛山市",
"861304680", "广东省汕头市",
"861355842", "广西柳州市",
"861362613", "江苏省泰州市",
"861321989", "四川省德阳市",
"86189592", "福建省厦门市",
"861869143", "陕西省商洛市",
"861573760", "河南省南阳市",
"861534560", "安徽省合肥市",
"861833849", "河南省濮阳市",
"861831938", "广东省深圳市",
"86183616", "江苏省盐城市",
"861309322", "湖北省荆门市",
"861508243", "四川省内江市",
"861804888", "四川省成都市",
"86157504", "内蒙古通辽市",
"861331428", "辽宁省大连市",
"861390738", "湖南省娄底市",
"861807583", "湖南省湘西土家族苗族自治州",
"86177700", "江西省九江市",
"861302859", "陕西省西安市",
"861333967", "贵州省毕节地区",
"861350698", "福建省福州市",
"861322897", "西藏阿里地区",
"861815107", "江苏省苏州市",
"861511311", "广东省汕头市",
"861535382", "陕西省铜川市",
"86150815", "河北省唐山市",
"861707444", "浙江省嘉兴市",
"861539309", "甘肃省天水市",
"861593278", "河北省邯郸市",
"86131731", "山东省潍坊市",
"861380412", "辽宁省鞍山市",
"861780666", "广东省梅州市",
"861331436", "吉林省吉林市",
"861803134", "河北省石家庄市",
"861390726", "湖北省恩施土家族苗族自治州",
"86151677", "浙江省温州市",
"861502623", "新疆石河子市",
"861390945", "甘肃省武威市",
"861452137", "河北省沧州市",
"861816470", "云南省昭通市",
"861500730", "湖南省岳阳市",
"861819504", "宁夏固原市",
"861831926", "广东省梅州市",
"861811588", "江苏省南京市",
"861452814", "四川省绵阳市",
"861362994", "新疆乌鲁木齐市",
"861820371", "河南省郑州市",
"861459641", "甘肃省天水市",
"86156304", "河北省石家庄市",
"861532423", "河北省张家口市",
"861846467", "山东省东营市",
"86155401", "内蒙古包头市",
"861866676", "广东省云浮市",
"861537682", "山东省淄博市",
"86151612", "江苏省宿迁市",
"861559016", "吉林省白城市",
"861303270", "湖北省宜昌市",
"861470522", "江苏省徐州市",
"861317623", "山东省日照市",
"861340964", "湖北省随州市",
"861829018", "广西钦州市",
"861860768", "广东省潮州市",
"861310359", "山西省运城市",
"861373039", "河北省邢台市",
"86131561", "山东省济南市",
"861855249", "江苏省徐州市",
"861351569", "安徽省阜阳市",
"86186546", "山东省东营市",
"86134267", "广东省江门市",
"861533298", "内蒙古通辽市",
"861320970", "青海省海北藏族自治州",
"861327908", "新疆克孜勒苏柯尔克孜自治州",
"861870627", "江苏省南通市",
"861596907", "云南省文山壮族苗族自治州",
"861876634", "山东省莱芜市",
"861577916", "江西省吉安市",
"861351324", "河北省承德市",
"861854802", "内蒙古巴彦淖尔市",
"861458950", "广东省中山市",
"861766646", "广东省佛山市",
"861554552", "黑龙江省绥化市",
"861529857", "江苏省盐城市",
"861829507", "宁夏银川市",
"861810002", "北京市",
"861593449", "山西省朔州市",
"86137136", "广东省深圳市",
"861572826", "广东省惠州市",
"861523434", "山西省阳泉市",
"861558187", "山西省晋城市",
"861886748", "湖南省衡阳市",
"861809479", "浙江省金华市",
"861563661", "黑龙江省绥化市",
"86132322", "广东省珠海市",
"861888285", "四川省凉山彝族自治州",
"861813668", "江苏省南京市",
"861805482", "福建省厦门市",
"861387247", "湖北省宜昌市",
"861809409", "福建省泉州市",
"861393420", "山西省太原市",
"86180261", "广东省肇庆市",
"861390894", "西藏林芝地区",
"861311637", "贵州省六盘水市",
"861315252", "广西柳州市",
"861375960", "陕西省铜川市",
"861367716", "湖北省荆州市",
"861343159", "广东省珠海市",
"86182802", "四川省成都市",
"861320900", "新疆伊犁哈萨克自治州",
"861327978", "新疆巴音郭楞蒙古自治州",
"861596977", "山东省德州市",
"861518488", "云南省楚雄彝族自治州",
"861377759", "浙江省杭州市",
"861583071", "河北省邢台市",
"861816113", "四川省广安市",
"861775150", "江苏省无锡市",
"86134260", "北京市",
"861501242", "广东省广州市",
"861504981", "内蒙古巴彦淖尔市",
"86183241", "重庆市",
"861399775", "湖北省恩施土家族苗族自治州",
"861539932", "陕西省渭南市",
"861599781", "湖北省十堰市",
"861819483", "新疆乌鲁木齐市",
"861810072", "湖北省武汉市",
"861372330", "宁夏银川市",
"861366691", "福建省莆田市",
"861533636", "山东省潍坊市",
"861557249", "湖北省荆门市",
"86156746", "湖南省永州市",
"86187838", "四川省德阳市",
"861705680", "湖北省孝感市",
"86182636", "山东省潍坊市",
"861866606", "广东省汕尾市",
"861343877", "四川省南充市",
"861301298", "山东省济南市",
"861510761", "广东省中山市",
"861890463", "黑龙江省哈尔滨市",
"861361461", "黑龙江省齐齐哈尔市",
"861858589", "贵州省安顺市",
"861852907", "广东省深圳市",
"861454748", "浙江省丽水市",
"86136758", "浙江省杭州市",
"861537374", "河北省衡水市",
"861368944", "甘肃省白银市",
"861331058", "湖北省荆州市",
"861361575", "浙江省绍兴市",
"861819574", "青海省海南藏族自治州",
"861808070", "四川省遂宁市",
"861561581", "山东省威海市",
"861507738", "广西河池市",
"861570327", "河北省石家庄市",
"861539379", "河南省许昌市",
"861336714", "湖北省黄石市",
"861593208", "河北省唐山市",
"861707380", "河南省郑州市",
"861590562", "安徽省铜陵市",
"861475718", "浙江省宁波市",
"861817579", "湖南省常德市",
"861591290", "云南省楚雄彝族自治州",
"861317293", "广东省清远市",
"861339795", "江西省宜春市",
"861375418", "内蒙古巴彦淖尔市",
"861370586", "浙江省台州市",
"861582014", "广东省潮州市",
"861316398", "福建省漳州市",
"861378832", "广西柳州市",
"861312726", "山东省莱芜市",
"861863361", "河北省廊坊市",
"861392359", "广东省汕尾市",
"861350236", "广东省汕尾市",
"861860923", "陕西省渭南市",
"861330874", "云南省曲靖市",
"861327551", "安徽省合肥市",
"861390482", "黑龙江省齐齐哈尔市",
"861328847", "广东省广州市",
"861570466", "黑龙江省黑河市",
"861815177", "江苏省苏州市",
"861364487", "内蒙古包头市",
"86159792", "江西省萍乡市",
"861535674", "浙江省宁波市",
"861830721", "湖北省襄樊市",
"861891431", "江苏省常州市",
"861894388", "吉林省白山市",
"861556072", "内蒙古包头市",
"861454935", "江苏省南通市",
"861562198", "内蒙古锡林郭勒盟",
"861453801", "四川省德阳市",
"861479454", "黑龙江省佳木斯市",
"861345116", "湖北省荆门市",
"861503428", "山西省吕梁市",
"861530863", "湖北省武汉市",
"861347414", "陕西省渭南市",
"86182859", "贵州省黔西南布依族苗族自治州",
"861584618", "黑龙江省大庆市",
"861335663", "山东省东营市",
"861815859", "浙江省舟山市",
"861515509", "安徽省安庆市",
"86158986", "山东省济宁市",
"861773265", "河北省保定市",
"861848357", "四川省雅安市",
"861524033", "江苏省连云港市",
"861805106", "江苏省扬州市",
"86137071", "湖北省武汉市",
"861533628", "陕西省安康市",
"861376790", "江西省景德镇市",
"861807404", "浙江省绍兴市",
"861344030", "江苏省泰州市",
"861473114", "河北省秦皇岛市",
"861363960", "河南省商丘市",
"861454357", "山东省日照市",
"861318844", "辽宁省铁岭市",
"861869043", "陕西省汉中市",
"861348852", "内蒙古包头市",
"861477779", "广西南宁市",
"861399455", "山西省晋中市",
"861337887", "云南省迪庆藏族自治州",
"861810486", "内蒙古呼和浩特市",
"86181482", "内蒙古兴安盟",
"861892172", "江苏省泰州市",
"86183832", "四川省内江市",
"861458204", "安徽省淮北市",
"86183125", "广东省深圳市",
"861377479", "福建省宁德市",
"861330538", "山东省泰安市",
"861700959", "广东省佛山市",
"861508512", "贵州省遵义市",
"861327063", "内蒙古通辽市",
"861585290", "江苏省南京市",
"861313241", "河北省衡水市",
"861332481", "广西南宁市",
"861580328", "河北省衡水市",
"86158363", "河南省安阳市",
"861300169", "山东省青岛市",
"861532475", "河南省洛阳市",
"861355743", "广西桂林市",
"861599297", "广东省韶关市",
"861479667", "江西省萍乡市",
"861805076", "福建省福州市",
"861860680", "浙江省舟山市",
"861317675", "山东省济宁市",
"861329393", "山西省忻州市",
"861510555", "安徽省马鞍山市",
"861538731", "湖南省长沙市",
"861598982", "广东省汕头市",
"861869938", "新疆喀什地区",
"861830001", "广东省梅州市",
"861367537", "山东省济宁市",
"861572504", "山东省日照市",
"861378966", "内蒙古赤峰市",
"861582580", "甘肃省天水市",
"861761417", "辽宁省营口市",
"861571995", "新疆伊犁哈萨克自治州",
"861893219", "湖南省怀化市",
"861815007", "福建省厦门市",
"861769822", "河南省新乡市",
"861820589", "浙江省金华市",
"861778156", "四川省广元市",
"861867511", "广东省韶关市",
"861372151", "贵州省毕节地区",
"861556102", "内蒙古呼和浩特市",
"86151659", "山东省德州市",
"861510510", "江苏省盐城市",
"861382460", "广东省肇庆市",
"861594760", "内蒙古赤峰市",
"861760482", "内蒙古兴安盟",
"861323956", "宁夏石嘴山市",
"86183606", "江苏省连云港市",
"861521643", "山东省淄博市",
"861373139", "河北省秦皇岛市",
"861314047", "河南省洛阳市",
"861369436", "吉林省白城市",
"861556486", "山东省青岛市",
"861384795", "内蒙古通辽市",
"861350847", "湖南省长沙市",
"861322648", "广东省珠海市",
"861869926", "新疆阿勒泰地区",
"861539277", "湖北省襄樊市",
"861339505", "福建省厦门市",
"861763331", "河北省保定市",
"861390076", "海南省海口市",
"86151602", "福建省莆田市",
"861576658", "广东省清远市",
"861328236", "浙江省舟山市",
"861393812", "河南省三门峡市",
"86186492", "天津市",
"861474100", "辽宁省铁岭市",
"86156314", "河北省邯郸市",
"861555647", "安徽省合肥市",
"861869745", "内蒙古乌海市",
"86155411", "辽宁省大连市",
"861311744", "湖南省张家界市",
"861379583", "四川省宜宾市",
"861376343", "黑龙江省哈尔滨市",
"861399968", "新疆哈密地区",
"861325919", "陕西省铜川市",
"861356566", "新疆喀什地区",
"861777631", "广西柳州市",
"861304768", "江苏省宿迁市",
"861319630", "陕西省咸阳市",
"861529079", "河南省平顶山市",
"861392257", "广东省韶关市",
"861327765", "湖北省荆门市",
"861573688", "河南省开封市",
"861897567", "湖南省娄底市",
"861347739", "湖北省荆门市",
"861539618", "福建省三明市",
"861769125", "陕西省安康市",
"861330526", "江苏省泰州市",
"861310988", "辽宁省沈阳市",
"861860905", "新疆伊犁哈萨克自治州",
"861528400", "四川省绵阳市",
"861580849", "四川省泸州市",
"861819838", "贵州省六盘水市",
"861321747", "湖南省怀化市",
"861348403", "浙江省杭州市",
"861530387", "河南省洛阳市",
"861708395", "河南省漯河市",
"86152003", "湖南省湘潭市",
"86159827", "四川省巴中市",
"861534333", "湖南省株洲市",
"86182870", "云南省昭通市",
"861776707", "浙江省杭州市",
"861569200", "广东省广州市",
"861454166", "浙江省台州市",
"86147685", "山东省聊城市",
"861515799", "浙江省舟山市",
"861870781", "广西南宁市",
"861336439", "吉林省白山市",
"861812521", "广东省中山市",
"861379474", "广东省河源市",
"861479774", "广西梧州市",
"861539866", "云南省普洱市",
"861580336", "河北省廊坊市",
"861870399", "河南省郑州市",
"86153486", "贵州省遵义市",
"861597169", "湖北省恩施土家族苗族自治州",
"861534711", "湖北省武汉市",
"861860146", "江苏省无锡市",
"861769705", "青海省果洛藏族自治州",
"861376570", "贵州省六盘水市",
"861396646", "安徽省淮南市",
"861550715", "湖北省荆州市",
"861890091", "辽宁省沈阳市",
"861502980", "陕西省西安市",
"861564913", "河南省郑州市",
"861383494", "山西省运城市",
"86138019", "上海市",
"861528642", "贵州省铜仁地区",
"861816013", "四川省绵阳市",
"86182812", "四川省攀枝花市",
"861479704", "青海省西宁市",
"861471788", "山西省长治市",
"86177343", "河北省保定市",
"861380820", "四川省成都市",
"861315305", "山东省枣庄市",
"861569831", "山西省太原市",
"861317980", "新疆乌鲁木齐市",
"861860975", "青海省果洛藏族自治州",
"861810722", "湖北省随州市",
"861571568", "安徽省阜阳市",
"86182877", "云南省玉溪市",
"861569270", "贵州省黔南布依族苗族自治州",
"861898904", "西藏林芝地区",
"861386155", "江苏省淮安市",
"861304046", "新疆阿克苏地区",
"861771882", "广东省揭阳市",
"861597256", "湖北省十堰市",
"861595567", "安徽省阜阳市",
"861348473", "内蒙古鄂尔多斯市",
"861370240", "广东省江门市",
"861823036", "河北省承德市",
"861472687", "四川省南充市",
"861453919", "广东省江门市",
"861876747", "浙江省温州市",
"861802375", "广东省云浮市",
"861808170", "四川省攀枝花市",
"861363899", "西藏拉萨市",
"861470944", "甘肃省庆阳市",
"861521815", "广东省阳江市",
"861760945", "甘肃省金昌市",
"861705214", "江苏省淮安市",
"861339461", "黑龙江省哈尔滨市",
"861875292", "江苏省盐城市",
"861780559", "安徽省黄山市",
"861305521", "福建省厦门市",
"861592555", "云南省怒江傈僳族自治州",
"861525082", "江苏省无锡市",
"861838142", "四川省资阳市",
"861760726", "湖北省恩施土家族苗族自治州",
"861341186", "广东省深圳市",
"861880628", "江苏省南通市",
"861598445", "四川省广元市",
"86188333", "河北省唐山市",
"861328698", "广东省湛江市",
"861303312", "安徽省黄山市",
"861504532", "黑龙江省牡丹江市",
"861808720", "云南省大理白族自治州",
"861348584", "安徽省宿州市",
"861560380", "河南省新乡市",
"861309661", "山西省运城市",
"861539581", "浙江省杭州市",
"861539207", "福建省泉州市",
"861339575", "浙江省绍兴市",
"861521850", "广东省清远市",
"861536341", "广东省佛山市",
"861362042", "广东省广州市",
"861556172", "黑龙江省双鸭山市",
"861303954", "内蒙古通辽市",
"86188192", "广东省广州市",
"861581224", "云南省丽江市",
"861478433", "河南省许昌市",
"861335251", "黑龙江省哈尔滨市",
"861760738", "湖南省娄底市",
"861532886", "四川省南充市",
"861839318", "甘肃省天水市",
"861815077", "福建省福州市",
"86138143", "江苏省盐城市",
"861568766", "云南省文山壮族苗族自治州",
"861771185", "宁夏中卫市",
"861361795", "江西省宜春市",
"861801412", "江苏省盐城市",
"86151348", "内蒙古鄂尔多斯市",
"861832944", "陕西省商洛市",
"861823028", "河北省秦皇岛市",
"86153224", "广东省东莞市",
"861824260", "辽宁省铁岭市",
"861538313", "河北省张家口市",
"861378733", "湖南省株洲市",
"861305091", "辽宁省朝阳市",
"861786458", "山东省济宁市",
"861887290", "湖北省十堰市",
"86177772", "广西柳州市",
"861816750", "新疆阿克苏地区",
"861306984", "黑龙江省七台河市",
"861527004", "江西省南昌市",
"861810875", "云南省昆明市",
"861367880", "山东省济南市",
"861310257", "河北省邢台市",
"861831612", "广东省阳江市",
"861570699", "云南省德宏傣族景颇族自治州",
"861398019", "四川省达州市",
"861880636", "山东省潍坊市",
"86181866", "湖北省武汉市",
"861815681", "安徽省六安市",
"86151645", "黑龙江省大庆市",
"861572574", "山东省淄博市",
"861564694", "新疆阿克苏地区",
"861313999", "新疆伊犁哈萨克自治州",
"861532405", "河北省唐山市",
"861705768", "上海市",
"861530762", "广东省河源市",
"861344130", "江苏省淮安市",
"86184374", "河南省许昌市",
"861396514", "安徽省合肥市",
"861473014", "河北省石家庄市",
"861809759", "新疆博尔塔拉蒙古自治州",
"861317605", "山东省菏泽市",
"861884679", "黑龙江省哈尔滨市",
"861324216", "广东省江门市",
"861766080", "山东省德州市",
"861867688", "广东省广州市",
"861524133", "辽宁省抚顺市",
"861399595", "湖北省黄石市",
"86132921", "河北省邢台市",
"86155813", "湖南省娄底市",
"861372563", "广东省阳江市",
"861571844", "广东省广州市",
"861320254", "广东省广州市",
"861477709", "广西北海市",
"861881394", "广东省梅州市",
"861337530", "山东省菏泽市",
"861822653", "安徽省芜湖市",
"861358970", "山东省滨州市",
"861572483", "江苏省徐州市",
"86187714", "湖北省襄樊市",
"861361523", "江苏省南通市",
"861345016", "广东省肇庆市",
"861377409", "湖北省随州市",
"861842017", "广东省茂名市",
"861890521", "江苏省徐州市",
"861857419", "河南省南阳市",
"861366395", "河南省漯河市",
"861559628", "陕西省商洛市",
"861554101", "辽宁省铁岭市",
"861570856", "贵州省铜仁地区",
"861323432", "吉林省吉林市",
"861768639", "山东省滨州市",
"861500392", "河南省鹤壁市",
"861522487", "河南省南阳市",
"86182462", "黑龙江省齐齐哈尔市",
"861524142", "辽宁省本溪市",
"861508977", "广东省潮州市",
"861836520", "安徽省淮南市",
"861365619", "江苏省无锡市",
"861376909", "云南省普洱市",
"861318734", "湖南省衡阳市",
"861827257", "河南省安阳市",
"861879793", "江西省上饶市",
"861811350", "四川省广安市",
"861856919", "湖南省张家界市",
"861304878", "河北省石家庄市",
"861560819", "四川省成都市",
"861322567", "安徽省亳州市",
"861826045", "江苏省苏州市",
"861551322", "山西省忻州市",
"861593037", "河北省衡水市",
"861572066", "江苏省苏州市",
"861850560", "安徽省合肥市",
"861804670", "江西省南昌市",
"861821979", "甘肃省嘉峪关市",
"861362033", "广东省佛山市",
"861337684", "浙江省丽水市",
"861871758", "陕西省商洛市",
"861820605", "福建省厦门市",
"861336147", "山东省聊城市",
"8615982", "四川省成都市",
"861378742", "湖南省湘潭市",
"86158945", "云南省大理白族自治州",
"861539126", "内蒙古鄂尔多斯市",
"861815469", "广西贵港市",
"861325555", "山东省青岛市",
"86183394", "河南省周口市",
"861534890", "西藏拉萨市",
"861500653", "山东省淄博市",
"861512195", "宁夏中卫市",
"861518390", "四川省宜宾市",
"861879525", "宁夏中卫市",
"861312329", "福建省莆田市",
"861453495", "内蒙古赤峰市",
"861834470", "江苏省南通市",
"86158311", "河北省石家庄市",
"861580414", "辽宁省本溪市",
"861300348", "江苏省盐城市",
"86153477", "广西柳州市",
"86157357", "山西省临汾市",
"861312564", "辽宁省营口市",
"861337302", "河北省保定市",
"861325510", "江苏省无锡市",
"861530453", "黑龙江省牡丹江市",
"861353795", "广东省阳江市",
"861518906", "江苏省宿迁市",
"861539776", "四川省凉山彝族自治州",
"86151795", "江西省宜春市",
"861898535", "贵州省毕节地区",
"861454826", "广东省揭阳市",
"861582989", "陕西省铜川市",
"861785851", "浙江省绍兴市",
"861539138", "云南省普洱市",
"861335384", "河南省周口市",
"861477869", "广东省茂名市",
"861479548", "广西南宁市",
"861370021", "陕西省延安市",
"86158526", "江苏省无锡市",
"861300829", "辽宁省阜新市",
"861760697", "云南省昆明市",
"861561596", "山东省潍坊市",
"861368565", "安徽省合肥市",
"861309489", "浙江省嘉兴市",
"861305402", "湖南省常德市",
"861505629", "安徽省宣城市",
"86156557", "安徽省宿州市",
"861771377", "四川省成都市",
"861879095", "河南省濮阳市",
"861705808", "上海市",
"861529285", "新疆乌鲁木齐市",
"861319403", "福建省宁德市",
"861830552", "安徽省蚌埠市",
"861454838", "广东省潮州市",
"861590340", "山西省太原市",
"861507848", "广西柳州市",
"861509569", "甘肃省天水市",
"86181416", "辽宁省锦州市",
"861510919", "陕西省铜川市",
"861819166", "陕西省西安市",
"861535429", "河北省邢台市",
"861368471", "内蒙古呼和浩特市",
"861327722", "湖北省随州市",
"861339689", "浙江省金华市",
"861568485", "新疆阿勒泰地区",
"861352987", "云南省曲靖市",
"861894490", "湖南省邵阳市",
"861350644", "山东省淄博市",
"861348630", "浙江省嘉兴市",
"861365447", "吉林省长春市",
"861313450", "黑龙江省哈尔滨市",
"861862446", "辽宁省辽阳市",
"861772434", "广东省东莞市",
"86159479", "吉林省吉林市",
"861362735", "湖南省郴州市",
"861559636", "陕西省商洛市",
"861555844", "浙江省宁波市",
"86155463", "黑龙江省哈尔滨市",
"861881477", "黑龙江省牡丹江市",
"861319155", "内蒙古锡林郭勒盟",
"861301016", "山东省烟台市",
"861857995", "广西玉林市",
"861890853", "贵州省安顺市",
"861361851", "贵州省贵阳市",
"861367319", "河北省邢台市",
"861581897", "广东省珠海市",
"861316480", "福建省福州市",
"861313415", "辽宁省丹东市",
"861311578", "浙江省丽水市",
"861520375", "河南省平顶山市",
"861700515", "江苏省盐城市",
"861787571", "广东省广州市",
"861319110", "山西省忻州市",
"861889013", "湖南省郴州市",
"86186750", "广东省江门市",
"861777111", "湖北省襄樊市",
"861300757", "河南省洛阳市",
"861512892", "河北省邯郸市",
"861320799", "江西省萍乡市",
"861786922", "云南省德宏傣族景颇族自治州",
"861787501", "广东省湛江市",
"86138255", "广东省佛山市",
"861319584", "甘肃省庆阳市",
"861311508", "江苏省无锡市",
"861316344", "黑龙江省哈尔滨市",
"861590573", "浙江省嘉兴市",
"861506531", "山东省济南市",
"861818690", "湖北省武汉市",
"861800353", "山西省阳泉市",
"861518842", "河南省漯河市",
"861534342", "山西省太原市",
"861700490", "上海市",
"861313590", "湖北省黄冈市",
"861568876", "山东省莱芜市",
"861572935", "河南省漯河市",
"86186757", "广东省佛山市",
"861810765", "广东省茂名市",
"861853679", "山西省晋中市",
"861519464", "河南省开封市",
"861707558", "安徽省阜阳市",
"861337939", "陕西省榆林市",
"861805848", "浙江省金华市",
"861881407", "广东省梅州市",
"861371743", "广东省东莞市",
"861837429", "湖南省张家界市",
"86182429", "辽宁省葫芦岛市",
"861894515", "黑龙江省鸡西市",
"861524994", "安徽省阜阳市",
"86138844", "浙江省宁波市",
"861557986", "江西省赣州市",
"861899785", "新疆喀什地区",
"861590484", "内蒙古乌兰察布市",
"86159318", "河北省保定市",
"861319473", "四川省广元市",
"861329587", "浙江省温州市",
"861310082", "黑龙江省齐齐哈尔市",
"861530872", "云南省大理白族自治州",
"861310756", "青海省海西蒙古族藏族自治州",
"861354882", "湖南省娄底市",
"861859328", "广西桂林市",
"861305640", "四川省乐山市",
"861811031", "安徽省马鞍山市",
"861883075", "河北省保定市",
"861827988", "江西省景德镇市",
"861340545", "山东省烟台市",
"86152432", "吉林省吉林市",
"861831835", "广东省揭阳市",
"861386630", "安徽省淮南市",
"861558323", "四川省内江市",
"861857844", "广东省佛山市",
"861770614", "江苏省常州市",
"861555995", "云南省曲靖市",
"861800692", "福建省福州市",
"861529326", "甘肃省酒泉市",
"861357141", "陕西省铜川市",
"861334398", "河南省三门峡市",
"861588577", "贵州省铜仁地区",
"86159615", "江苏省无锡市",
"861390564", "安徽省六安市",
"861335440", "山东省淄博市",
"861529467", "河南省安阳市",
"861318898", "山东省青岛市",
"86186585", "浙江省绍兴市",
"86156550", "安徽省滁州市",
"86180203", "江苏省南通市",
"861303741", "湖南省湘西土家族苗族自治州",
"86155114", "河北省石家庄市",
"861390329", "河北省邢台市",
"861571419", "辽宁省辽阳市",
"861860534", "山东省德州市",
"86158959", "江苏省南京市",
"861529338", "甘肃省陇南市",
"861834400", "广东省清远市",
"861325184", "吉林省四平市",
"861780950", "宁夏银川市",
"861327486", "内蒙古包头市",
"861453510", "山东省济南市",
"861459345", "四川省凉山彝族自治州",
"861337372", "河南省安阳市",
"861571647", "河南省新乡市",
"861568942", "山东省济南市",
"86187385", "河南省新乡市",
"86157350", "山西省太原市",
"861770546", "山东省东营市",
"861478600", "贵州省铜仁地区",
"861390848", "湖南省长沙市",
"861370451", "黑龙江省哈尔滨市",
"861780915", "陕西省安康市",
"861344655", "山东省菏泽市",
"861707971", "浙江省丽水市",
"861821909", "广东省阳江市",
"861530593", "福建省宁德市",
"861592919", "陕西省榆林市",
"861876246", "江苏省无锡市",
"861857568", "广东省深圳市",
"861518145", "四川省绵阳市",
"861521632", "山东省枣庄市",
"861359967", "福建省漳州市",
"86182886", "云南省昆明市",
"861776867", "江苏省镇江市",
"861810063", "江苏省南通市",
"861527566", "山东省聊城市",
"861530946", "甘肃省张掖市",
"861812186", "四川省成都市",
"861572748", "湖南省永州市",
"861869032", "新疆乌鲁木齐市",
"861502589", "甘肃省张掖市",
"861508907", "西藏昌都地区",
"861839424", "甘肃省定西市",
"861307503", "安徽省亳州市",
"861530725", "湖北省黄冈市",
"861563365", "河北省衡水市",
"861517469", "黑龙江省牡丹江市",
"861379397", "山东省东营市",
"861830884", "云南省临沧市",
"861458666", "湖南省郴州市",
"861339934", "甘肃省庆阳市",
"861890472", "内蒙古包头市",
"861890640", "山东省济南市",
"86184552", "安徽省蚌埠市",
"861302469", "浙江省丽水市",
"861368998", "新疆克拉玛依市",
"861809624", "四川省达州市",
"861870576", "浙江省台州市",
"861354494", "广东省珠海市",
"861354185", "四川省广安市",
"861847513", "广东省梅州市",
"861314268", "江苏省南通市",
"861886826", "浙江省温州市",
"861770993", "新疆石河子市",
"861323788", "广西河池市",
"861355732", "广西柳州市",
"861515254", "江苏省连云港市",
"861384851", "内蒙古呼和浩特市",
"861317589", "浙江省台州市",
"861819150", "陕西省渭南市",
"861336095", "广东省汕尾市",
"861762511", "江苏省镇江市",
"861306210", "福建省三明市",
"86130029", "陕西省西安市",
"861831296", "浙江省宁波市",
"861862730", "湖南省岳阳市",
"861705605", "广东省深圳市",
"861454635", "宁夏吴忠市",
"861535974", "福建省福州市",
"86183527", "江苏省扬州市",
"861390813", "四川省乐山市",
"861507645", "河北省唐山市",
"861317768", "江西省抚州市",
"861813455", "安徽省蚌埠市",
"861512047", "甘肃省临夏回族自治州",
"861876689", "山东省潍坊市",
"861323569", "湖北省襄樊市",
"861781761", "广东省清远市",
"861472749", "贵州省黔西南布依族苗族自治州",
"861307047", "新疆伊犁哈萨克自治州",
"861340707", "江西省赣州市",
"861894881", "广东省梅州市",
"861846200", "山东省青岛市",
"86135835", "山东省烟台市",
"861471960", "甘肃省武威市",
"86135122", "天津市",
"861559772", "贵州省贵阳市",
"861806877", "江苏省常州市",
"86151371", "河南省郑州市",
"861840373", "河南省新乡市",
"861819115", "陕西省汉中市",
"86133005", "上海市",
"861537445", "甘肃省武威市",
"861896307", "山东省济南市",
"861560252", "广东省阳江市",
"861551434", "河南省周口市",
"861300731", "湖南省长沙市",
"861378559", "河北省廊坊市",
"861813410", "河北省邯郸市",
"861366408", "内蒙古兴安盟",
"861376054", "广东省江门市",
"861313327", "山西省临汾市",
"861785837", "浙江省湖州市",
"861572713", "湖北省黄冈市",
"861508096", "湖南省岳阳市",
"861803189", "河北省衡水市",
"861325378", "河南省周口市",
"861888270", "四川省自贡市",
"861330512", "江苏省连云港市",
"861522044", "广东省汕头市",
"86153720", "浙江省杭州市",
"861837904", "江西省新余市",
"861320985", "山西省长治市",
"861520971", "青海省西宁市",
"861335963", "黑龙江省佳木斯市",
"86133286", "福建省福州市",
"861780035", "河北省唐山市",
"861313466", "山西省晋城市",
"861331587", "河北省承德市",
"861826197", "江苏省镇江市",
"861379090", "广东省茂名市",
"861501667", "广东省清远市",
"861582523", "云南省红河哈尼族彝族自治州",
"861700566", "浙江省金华市",
"861319219", "广东省汕头市",
"861811366", "四川省眉山市",
"861452502", "山东省济南市",
"861381528", "江苏省苏州市",
"86185387", "河南省郑州市",
"861533936", "甘肃省张掖市",
"861327678", "浙江省宁波市",
"861839909", "新疆吐鲁番地区",
"861334561", "安徽省淮北市",
"861596677", "山东省菏泽市",
"861504681", "黑龙江省哈尔滨市",
"861350565", "安徽省合肥市",
"861336793", "江西省上饶市",
"86134290", "浙江省金华市",
"861389755", "青海省果洛藏族自治州",
"861311937", "甘肃省酒泉市",
"861509432", "江苏省泰州市",
"861596081", "福建省厦门市",
"861398530", "贵州省安顺市",
"86189529", "江苏省镇江市",
"861308387", "河南省安阳市",
"861882422", "广东省东莞市",
"861347161", "广西河池市",
"861595994", "福建省南平市",
"861892716", "广东省云浮市",
"861893630", "江苏省盐城市",
"861350471", "吉林省松原市",
"86155349", "山西省朔州市",
"86180782", "广西柳州市",
"861389710", "青海省海北藏族自治州",
"861811427", "江苏省连云港市",
"861372278", "河北省石家庄市",
"861550485", "内蒙古通辽市",
"861807190", "湖北省宜昌市",
"861566220", "吉林省长春市",
"861371718", "广东省东莞市",
"861335108", "黑龙江省伊春市",
"86180291", "广东省东莞市",
"861570860", "贵州省贵阳市",
"86182779", "广西北海市",
"86159532", "山东省青岛市",
"861830749", "湖南省永州市",
"861327217", "湖南省益阳市",
"861333704", "内蒙古通辽市",
"861356959", "河南省平顶山市",
"861347493", "内蒙古呼伦贝尔市",
"861301763", "河南省洛阳市",
"86189258", "广东省东莞市",
"861372617", "广东省江门市",
"861869354", "甘肃省兰州市",
"861311355", "内蒙古赤峰市",
"861520558", "安徽省阜阳市",
"861820808", "西藏昌都地区",
"861879147", "陕西省宝鸡市",
"86188476", "内蒙古赤峰市",
"861780733", "湖南省长沙市",
"861889766", "广西钦州市",
"861572050", "安徽省滁州市",
"861850556", "安徽省安庆市",
"861336525", "江苏省宿迁市",
"86151900", "江苏省苏州市",
"861827231", "湖北省十堰市",
"86133424", "辽宁省沈阳市",
"861317923", "吉林省吉林市",
"861380156", "江苏省苏州市",
"86131591", "福建省漳州市",
"861339246", "广东省广州市",
"861884811", "内蒙古呼和浩特市",
"86135169", "浙江省金华市",
"861537982", "甘肃省酒泉市",
"86151907", "江苏省徐州市",
"861530234", "广东省佛山市",
"861550876", "云南省文山壮族苗族自治州",
"861816942", "湖南省长沙市",
"861360579", "浙江省金华市",
"861334153", "吉林省延边朝鲜族自治州",
"861831626", "广东省云浮市",
"861707375", "河南省平顶山市",
"86159729", "湖北省武汉市",
"861362694", "福建省南平市",
"861333774", "江苏省镇江市",
"861850496", "内蒙古呼和浩特市",
"861374574", "黑龙江省大兴安岭地区",
"861780311", "河北省石家庄市",
"86150582", "浙江省宁波市",
"861384837", "内蒙古鄂尔多斯市",
"861380269", "广东省中山市",
"861526029", "福建省莆田市",
"861889933", "新疆喀什地区",
"861813025", "安徽省宣城市",
"861380883", "广东省深圳市",
"861390645", "山东省烟台市",
"86189732", "湖南省湘潭市",
"861324222", "广东省中山市",
"86152579", "浙江省金华市",
"861554346", "吉林省白城市",
"861576791", "广东省深圳市",
"861594988", "山东省烟台市",
"861563316", "河北省廊坊市",
"861364536", "山东省潍坊市",
"861528524", "贵州省遵义市",
"861808783", "云南省昆明市",
"861533763", "浙江省嘉兴市",
"86155934", "甘肃省庆阳市",
"861891206", "江苏省淮安市",
"861870411", "辽宁省大连市",
"861763504", "山西省朔州市",
"861335178", "黑龙江省哈尔滨市",
"861372208", "内蒙古鄂尔多斯市",
"861567659", "广西来宾市",
"86185380", "河南省郑州市",
"86155355", "山西省长治市",
"861458650", "湖北省荆州市",
"861452572", "福建省福州市",
"861370437", "吉林省白城市",
"86137381", "浙江省杭州市",
"861554839", "内蒙古赤峰市",
"861304605", "山东省淄博市",
"861550267", "辽宁省锦州市",
"861561918", "陕西省宝鸡市",
"861345873", "四川省泸州市",
"861470737", "湖南省益阳市",
"861779107", "陕西省汉中市",
"861327608", "福建省福州市",
"861841997", "甘肃省陇南市",
"861839979", "新疆巴音郭楞蒙古自治州",
"861320670", "黑龙江省黑河市",
"86157623", "山东省日照市",
"861818709", "云南省临沧市",
"861596607", "山东省潍坊市",
"861335728", "湖南省永州市",
"861889048", "湖南省邵阳市",
"861510039", "河北省邢台市",
"861882052", "广东省肇庆市",
"861362913", "陕西省渭南市",
"861882786", "江西省赣州市",
"861886635", "山东省聊城市",
"861353634", "广东省惠州市",
"861452893", "云南省红河哈尼族彝族自治州",
"861595142", "江苏省南通市",
"861520901", "新疆塔城地区",
"861840540", "山东省菏泽市",
"86189562", "安徽省铜陵市",
"861321689", "浙江省丽水市",
"861367823", "四川省绵阳市",
"861550942", "甘肃省张掖市",
"861364528", "江苏省镇江市",
"861332711", "内蒙古呼和浩特市",
"861566690", "山东省烟台市",
"861317046", "湖南省永州市",
"861331271", "云南省临沧市",
"861816876", "江苏省徐州市",
"861399780", "湖北省十堰市",
"86189956", "湖北省武汉市",
"861813723", "河南省南阳市",
"861577544", "四川省成都市",
"861335736", "湖南省常德市",
"861308762", "陕西省渭南市",
"861521138", "湖南省衡阳市",
"861325308", "河南省濮阳市",
"861888200", "四川省自贡市",
"861826264", "江苏省南京市",
"86152696", "山东省潍坊市",
"861810716", "湖北省荆州市",
"861301928", "吉林省辽源市",
"861840303", "河北省张家口市",
"861555789", "浙江省宁波市",
"861880862", "湖北省武汉市",
"86187272", "湖北省宜昌市",
"86147293", "陕西省渭南市",
"861357376", "山东省济南市",
"861839332", "甘肃省定西市",
"861318695", "浙江省杭州市",
"861340777", "广西河池市",
"861366478", "内蒙古呼和浩特市",
"861533065", "吉林省四平市",
"861801438", "江苏省南通市",
"861572420", "浙江省温州市",
"861361580", "浙江省舟山市",
"861804381", "吉林省长春市",
"861513861", "河南省南阳市",
"861396703", "浙江省衢州市",
"861459629", "甘肃省张掖市",
"861896377", "安徽省淮南市",
"861535904", "福建省莆田市",
"86183520", "江苏省盐城市",
"861340127", "江苏省徐州市",
"861593330", "河北省邯郸市",
"861705675", "山西省太原市",
"861709421", "广东省惠州市",
"861586288", "江苏省扬州市",
"861838567", "贵州省黔东南苗族侗族自治州",
"86147536", "山东省潍坊市",
"861378499", "河北省保定市",
"861503201", "河北省邯郸市",
"86186176", "河北省邢台市",
"861350998", "广东省肇庆市",
"861342282", "广东省中山市",
"861302532", "广东省汕头市",
"861700881", "广东省广州市",
"861766023", "山东省青岛市",
"86188251", "广东省广州市",
"861561460", "山东省潍坊市",
"86185376", "河南省信阳市",
"861839343", "甘肃省平凉市",
"861308453", "河北省秦皇岛市",
"861321193", "云南省临沧市",
"861834524", "黑龙江省鹤岗市",
"861517543", "河北省邯郸市",
"861318947", "广东省湛江市",
"861326691", "河北省石家庄市",
"861538348", "山西省吕梁市",
"861818283", "黑龙江省牡丹江市",
"861892678", "广东省深圳市",
"861356550", "新疆博尔塔拉蒙古自治州",
"86186802", "广东省广州市",
"861384989", "河南省许昌市",
"861553460", "山西省晋城市",
"86157089", "海南省海口市",
"861576810", "广东省惠州市",
"861550048", "吉林省白山市",
"861303079", "辽宁省铁岭市",
"861808209", "江苏省镇江市",
"861338653", "浙江省杭州市",
"861533803", "广东省东莞市",
"861815370", "湖南省益阳市",
"861327716", "湖北省荆州市",
"861322845", "四川省南充市",
"861577708", "广西北海市",
"861360396", "河南省洛阳市",
"861570770", "广西防城港市",
"861576855", "广东省清远市",
"861510378", "河南省开封市",
"861328944", "陕西省汉中市",
"861595133", "江苏省南通市",
"86158449", "吉林省白山市",
"86139279", "广东省汕尾市",
"861391303", "江苏省南京市",
"861521581", "浙江省台州市",
"861454115", "安徽省亳州市",
"861323418", "辽宁省阜新市",
"861839500", "宁夏银川市",
"861302996", "黑龙江省牡丹江市",
"861773144", "河北省石家庄市",
"86177422", "天津市",
"86132758", "安徽省六安市",
"861550933", "甘肃省平凉市",
"861379929", "福建省厦门市",
"861330977", "青海省海西蒙古族藏族自治州",
"861301873", "广东省中山市",
"861321461", "黑龙江省哈尔滨市",
"861350092", "吉林省延边朝鲜族自治州",
"861590268", "贵州省贵阳市",
"861338392", "河南省鹤壁市",
"861361634", "山东省莱芜市",
"861700004", "北京市",
"86152746", "湖南省永州市",
"861875128", "江苏省淮安市",
"861329158", "浙江省金华市",
"861302300", "安徽省合肥市",
"861536894", "云南省保山市",
"86186636", "山东省潍坊市",
"861777657", "广西河池市",
"861315971", "吉林省松原市",
"86188487", "云南省红河哈尼族彝族自治州",
"861324487", "广东省深圳市",
"861475976", "福建省厦门市",
"861322142", "浙江省宁波市",
"86147199", "新疆阿克苏地区",
"861320433", "吉林省延边朝鲜族自治州",
"861576152", "贵州省六盘水市",
"861823361", "河北省廊坊市",
"861816048", "新疆昌吉回族自治州",
"861802498", "广东省湛江市",
"861388993", "广东省佛山市",
"861350522", "江苏省徐州市",
"861367551", "安徽省合肥市",
"861564948", "河南省平顶山市",
"861537088", "江苏省无锡市",
"861874010", "辽宁省本溪市",
"861317878", "广东省汕头市",
"861310800", "四川省宜宾市",
"861300260", "浙江省嘉兴市",
"861588032", "福建省莆田市",
"861880702", "江西省九江市",
"861806767", "浙江省绍兴市",
"861502878", "河北省衡水市",
"861552554", "山西省晋城市",
"861551316", "山西省忻州市",
"861377924", "新疆巴音郭楞蒙古自治州",
"861832698", "安徽省宿州市",
"861874055", "陕西省安康市",
"861893403", "广东省湛江市",
"861301592", "福建省厦门市",
"861877434", "湖南省常德市",
"861857273", "湖北省随州市",
"861323960", "甘肃省庆阳市",
"86159975", "湖北省宜昌市",
"86137739", "江苏省宿迁市",
"861571789", "湖北省宜昌市",
"861865174", "江苏省盐城市",
"861382456", "广东省梅州市",
"861314195", "湖南省邵阳市",
"861594756", "内蒙古赤峰市",
"861332890", "福建省三明市",
"861314484", "广东省深圳市",
"861816933", "湖南省长沙市",
"861778160", "四川省雅安市",
"861847667", "广东省湛江市",
"861899450", "江苏省连云港市",
"861571391", "河南省焦作市",
"861536482", "山西省大同市",
"86150495", "内蒙古呼伦贝尔市",
"861804254", "浙江省宁波市",
"861503652", "河南省焦作市",
"861817442", "湖南省长沙市",
"861360685", "浙江省绍兴市",
"861817670", "广西柳州市",
"861378950", "内蒙古呼伦贝尔市",
"861810608", "福建省厦门市",
"861881841", "广东省广州市",
"861560671", "浙江省杭州市",
"86136369", "福建省泉州市",
"861364992", "新疆博尔塔拉蒙古自治州",
"861355197", "四川省广安市",
"86133121", "天津市",
"861831797", "江西省赣州市",
"861454812", "广东省广州市",
"86186859", "贵州省黔西南布依族苗族自治州",
"861315558", "安徽省阜阳市",
"861889942", "新疆哈密地区",
"861538829", "四川省自贡市",
"861365871", "云南省昆明市",
"861899415", "江苏省南通市",
"86158607", "福建省厦门市",
"861390997", "新疆阿克苏地区",
"861336562", "安徽省铜陵市",
"861322613", "广东省潮州市",
"861899590", "湖北省宜昌市",
"861560601", "福建省福州市",
"861346993", "湖北省黄冈市",
"861708478", "内蒙古包头市",
"861357459", "湖南省怀化市",
"861817600", "广西钦州市",
"861361989", "河南省周口市",
"861452330", "河南省信阳市",
"861331393", "福建省龙岩市",
"86158600", "福建省莆田市",
"861893584", "新疆阿克苏地区",
"86170703", "广东省广州市",
"861528148", "四川省德阳市",
"861398684", "湖北省恩施土家族苗族自治州",
"861309719", "江西省萍乡市",
"861315498", "四川省乐山市",
"861709893", "广东省东莞市",
"861856308", "山东省潍坊市",
"861865104", "江苏省扬州市",
"861887199", "湖北省恩施土家族苗族自治州",
"861338840", "浙江省衢州市",
"86182925", "陕西省安康市",
"861529954", "新疆哈密地区",
"861536738", "湖南省娄底市",
"861308023", "内蒙古兴安盟",
"861857203", "湖北省随州市",
"861837535", "安徽省安庆市",
"861533592", "湖北省襄樊市",
"861526306", "山东省泰安市",
"861394919", "河南省信阳市",
"861335237", "辽宁省盘锦市",
"861324265", "广东省汕尾市",
"861880772", "广西柳州市",
"861567174", "湖北省黄冈市",
"861452421", "辽宁省朝阳市",
"861333548", "陕西省宝鸡市",
"861840949", "甘肃省兰州市",
"861893473", "广西南宁市",
"86156149", "河北省唐山市",
"861313785", "河南省驻马店市",
"861515442", "山东省青岛市",
"861346546", "山东省东营市",
"861515670", "安徽省马鞍山市",
"86130683", "重庆市",
"861452917", "广东省汕尾市",
"861473689", "云南省怒江傈僳族自治州",
"861325039", "广东省茂名市",
"861519957", "新疆石河子市",
"861882501", "广东省中山市",
"861362897", "西藏阿里地区",
"86176257", "江苏省苏州市",
"861811282", "江苏省镇江市",
"861803914", "河南省商丘市",
"861317808", "福建省泉州市",
"86150321", "河北省石家庄市",
"861310870", "云南省昆明市",
"86138584", "浙江省绍兴市",
"861387295", "湖北省武汉市",
"861558380", "四川省德阳市",
"861566041", "山东省济宁市",
"861339358", "山西省吕梁市",
"8618721", "上海市",
"861873896", "河南省开封市",
"861556678", "辽宁省朝阳市",
"861820768", "广东省潮州市",
"86150516", "江苏省苏州市",
"861786916", "云南省红河哈尼族彝族自治州",
"86158455", "黑龙江省绥化市",
"861569729", "湖北省咸宁市",
"861826676", "山东省济宁市",
"86152304", "河北省保定市",
"861889806", "西藏那曲地区",
"861308175", "辽宁省辽阳市",
"861568013", "四川省绵阳市",
"861840621", "辽宁省本溪市",
"861521277", "安徽省合肥市",
"861321505", "福建省莆田市",
"861346614", "云南省保山市",
"861351660", "广东省佛山市",
"86139874", "云南省曲靖市",
"861860371", "河南省郑州市",
"861450586", "辽宁省辽阳市",
"861875708", "浙江省温州市",
"861308725", "湖南省郴州市",
"861330907", "四川省南充市",
"861583346", "河北省唐山市",
"861308946", "吉林省吉林市",
"861573476", "内蒙古赤峰市",
"861355718", "广西河池市",
"861880825", "四川省遂宁市",
"861815300", "河南省商丘市",
"86136322", "广东省广州市",
"861328895", "广东省茂名市",
"861353114", "广东省湛江市",
"861808279", "云南省普洱市",
"86187040", "辽宁省沈阳市",
"861370149", "江苏省常州市",
"861536176", "广东省广州市",
"861308593", "甘肃省庆阳市",
"86156013", "北京市",
"861556217", "山东省临沂市",
"861580784", "广西梧州市",
"861591529", "广东省茂名市",
"861760341", "山西省太原市",
"861523661", "河南省新乡市",
"861570700", "江西省抚州市",
"861339747", "湖南省衡阳市",
"861316053", "广东省阳江市",
"861869507", "湖北省宜昌市",
"861569857", "山西省太原市",
"86181197", "安徽省六安市",
"86182546", "山东省东营市",
"861536945", "河北省沧州市",
"861800044", "河北省保定市",
"861864841", "内蒙古巴彦淖尔市",
"861536726", "湖南省郴州市",
"861828481", "四川省乐山市",
"861345763", "广西玉林市",
"861532398", "广东省珠海市",
"861521932", "广东省汕尾市",
"861529270", "新疆和田地区",
"861390341", "山西省太原市",
"86186877", "云南省玉溪市",
"861770352", "山西省大同市",
"861478396", "河南省驻马店市",
"861303729", "江西省九江市",
"861314525", "内蒙古通辽市",
"861820975", "青海省果洛藏族自治州",
"861529831", "江苏省宿迁市",
"861344955", "山东省菏泽市",
"861700896", "广东省惠州市",
"861375443", "河北省张家口市",
"861592619", "湖北省十堰市",
"861885707", "浙江省舟山市",
"861550148", "江苏省苏州市",
"861303179", "山东省淄博市",
"861524913", "陕西省渭南市",
"861478900", "西藏拉萨市",
"861533702", "甘肃省庆阳市",
"86180706", "广西梧州市",
"861868890", "广东省广州市",
"86155891", "山东省德州市",
"861708758", "江西省南昌市",
"86180939", "甘肃省陇南市",
"861555386", "山东省威海市",
"861595948", "福建省漳州市",
"861780650", "广东省江门市",
"861321093", "山东省烟台市",
"861804396", "吉林省长春市",
"861837441", "湖南省张家界市",
"861770693", "福建省宁德市",
"861331740", "湖南省岳阳市",
"861329058", "河北省衡水市",
"861304301", "河南省郑州市",
"861308005", "吉林省通化市",
"861855140", "江苏省南京市",
"861810319", "河北省邢台市",
"861309434", "云南省红河哈尼族彝族自治州",
"861584643", "黑龙江省鸡西市",
"861394871", "内蒙古呼和浩特市",
"86131050", "福建省漳州市",
"861340383", "河南省安阳市",
"861301772", "浙江省绍兴市",
"86150922", "山东省青岛市",
"861587127", "湖北省孝感市",
"861316561", "湖北省宜昌市",
"861335846", "福建省南平市",
"861314793", "辽宁省营口市",
"861376679", "黑龙江省大庆市",
"861882791", "江西省南昌市",
"861565082", "安徽省宿州市",
"861339634", "山东省莱芜市",
"861773044", "安徽省合肥市",
"861458966", "广东省汕尾市",
"861569009", "河北省承德市",
"861338261", "江苏省盐城市",
"861880452", "黑龙江省齐齐哈尔市",
"861844966", "新疆博尔塔拉蒙古自治州",
"861332969", "贵州省黔西南布依族苗族自治州",
"861803275", "河北省石家庄市",
"861303857", "陕西省延安市",
"861530646", "山东省潍坊市",
"861458311", "江西省萍乡市",
"861508607", "贵州省遵义市",
"861595033", "江苏省盐城市",
"86133528", "广东省广州市",
"861323899", "辽宁省鞍山市",
"861504238", "辽宁省抚顺市",
"86181735", "湖南省郴州市",
"861534556", "安徽省安庆市",
"861524694", "黑龙江省伊春市",
"861862392", "河南省鹤壁市",
"86183980", "四川省成都市",
"861327880", "湖南省岳阳市",
"861567004", "河南省安阳市",
"861588132", "四川省自贡市",
"861337639", "山东省青岛市",
"861559763", "青海省海南藏族自治州",
"861872011", "江西省赣州市",
"861580553", "安徽省芜湖市",
"861321795", "江西省宜春市",
"861818990", "西藏昌都地区",
"861528766", "云南省普洱市",
"861816148", "四川省成都市",
"86139257", "广东省东莞市",
"861572635", "山东省聊城市",
"861576052", "四川省绵阳市",
"861708347", "山西省长治市",
"861576786", "广东省茂名市",
"861344468", "福建省福州市",
"861786622", "湖北省十堰市",
"861858768", "广西南宁市",
"861322042", "甘肃省平凉市",
"861884570", "黑龙江省大兴安岭地区",
"861850481", "内蒙古呼和浩特市",
"861776431", "安徽省阜阳市",
"86158617", "江苏省淮安市",
"861898807", "云南省昆明市",
"861359774", "湖北省黄石市",
"861834485", "江苏省连云港市",
"861522098", "广东省佛山市",
"861571262", "浙江省嘉兴市",
"861391286", "江苏省南通市",
"861351432", "吉林省吉林市",
"861859821", "广东省潮州市",
"861308703", "河南省南阳市",
"861597841", "河南省郑州市",
"861808377", "江苏省扬州市",
"861459474", "陕西省铜川市",
"861355097", "四川省广元市",
"861705371", "河南省郑州市",
"861335972", "黑龙江省哈尔滨市",
"86137916", "山东省潍坊市",
"861523322", "河北省邯郸市",
"861577458", "黑龙江省伊春市",
"861770914", "陕西省商洛市",
"86158672", "浙江省宁波市",
"861359124", "辽宁省鞍山市",
"861454713", "浙江省杭州市",
"861800992", "新疆伊犁哈萨克自治州",
"861804685", "江西省宜春市",
"86136921", "广东省深圳市",
"861557686", "湖南省张家界市",
"86133202", "重庆市",
"861363443", "吉林省延边朝鲜族自治州",
"861318391", "四川省广安市",
"861539012", "四川省达州市",
"861350895", "山东省淄博市",
"861768302", "四川省内江市",
"86135388", "广东省广州市",
"861886420", "河南省漯河市",
"861592447", "内蒙古通辽市",
"861510619", "江苏省无锡市",
"861845883", "浙江省温州市",
"86151535", "山东省烟台市",
"861889369", "甘肃省张掖市",
"861341549", "广东省佛山市",
"861369393", "河南省濮阳市",
"861570450", "黑龙江省哈尔滨市",
"861335902", "安徽省蚌埠市",
"861830839", "四川省广元市",
"861845269", "江苏省淮安市",
"861315819", "贵州省黔西南布依族苗族自治州",
"861598497", "四川省凉山彝族自治州",
"861874473", "贵州省安顺市",
"861889524", "宁夏固原市",
"861768372", "湖北省荆州市",
"861476881", "山东省德州市",
"861308123", "辽宁省鞍山市",
"861865004", "福建省厦门市",
"861887099", "江西省萍乡市",
"861312341", "广西南宁市",
"861528048", "福建省泉州市",
"861570415", "辽宁省丹东市",
"861760997", "新疆阿克苏地区",
"86170713", "上海市",
"861505929", "福建省宁德市",
"861824069", "河南省新乡市",
"861898877", "广东省深圳市",
"86158610", "江苏省泰州市",
"861351788", "广西南宁市",
"861359704", "广西玉林市",
"861705301", "北京市",
"861454331", "内蒙古呼和浩特市",
"861459404", "云南省红河哈尼族彝族自治州",
"861582689", "湖北省武汉市",
"861830346", "山西省晋城市",
"861308773", "广西桂林市",
"861354170", "四川省德阳市",
"861566141", "内蒙古赤峰市",
"861552085", "四川省南充市",
"86139250", "广东省广州市",
"861369652", "安徽省合肥市",
"861561643", "湖南省常德市",
"861596096", "福建省三明市",
"861839790", "江西省新余市",
"861880873", "云南省红河哈尼族彝族自治州",
"861363956", "宁夏石嘴山市",
"861533825", "广东省中山市",
"861860589", "浙江省金华市",
"861329428", "湖北省荆门市",
"861868342", "四川省成都市",
"861528933", "陕西省渭南市",
"861596538", "山东省泰安市",
"861395144", "江苏省扬州市",
"861327537", "山东省济宁市",
"86155493", "湖北省宜昌市",
"861553632", "山西省太原市",
"861354720", "四川省乐山市",
"861818376", "云南省文山壮族苗族自治州",
"861891457", "江苏省镇江市",
"861829938", "新疆石河子市",
"861454420", "江苏省南京市",
"861504696", "黑龙江省黑河市",
"861373919", "江苏省南京市",
"861450240", "河北省邢台市",
"861320888", "云南省丽江市",
"861567074", "河南省洛阳市",
"86150969", "云南省大理白族自治州",
"861361358", "山西省吕梁市",
"861569079", "河南省新乡市",
"861863458", "山西省吕梁市",
"861814397", "河南省郑州市",
"861775166", "江苏省苏州市",
"861700724", "山东省济南市",
"861590439", "吉林省白山市",
"861365919", "陕西省西安市",
"861587707", "广西玉林市",
"861813865", "广东省江门市",
"861880592", "福建省厦门市",
"861508081", "湖南省娄底市",
"861304371", "河南省郑州市",
"861768939", "福建省莆田市",
"861306530", "辽宁省阜新市",
"861829745", "安徽省宿州市",
"86152314", "河北省承德市",
"861399547", "宁夏银川市",
"861823622", "河南省漯河市",
"861596526", "山东省滨州市",
"861538477", "内蒙古鄂尔多斯市",
"861301702", "贵州省黔南布依族苗族自治州",
"861329436", "吉林省白城市",
"861362648", "山东省青岛市",
"861535441", "河北省石家庄市",
"861508218", "四川省绵阳市",
"86189989", "广东省深圳市",
"861533772", "上海市",
"861862840", "陕西省渭南市",
"861313856", "广东省汕头市",
"861800144", "江苏省扬州市",
"861518606", "贵州省毕节地区",
"861557140", "湖北省十堰市",
"861577028", "云南省保山市",
"86151765", "河北省唐山市",
"861894896", "广东省江门市",
"861893425", "广东省茂名市",
"861787658", "广东省河源市",
"861788121", "新疆克孜勒苏柯尔克孜自治州",
"861319539", "安徽省六安市",
"861885127", "江苏省镇江市",
"86133245", "陕西省西安市",
"861514227", "辽宁省朝阳市",
"861505641", "安徽省六安市",
"861361747", "湖南省衡阳市",
"861500953", "宁夏吴忠市",
"861529200", "湖南省岳阳市",
"861533122", "山东省济南市",
"86186870", "云南省昆明市",
"861831281", "广东省揭阳市",
"861536076", "广东省茂名市",
"861452563", "贵州省安顺市",
"861899770", "新疆伊犁哈萨克自治州",
"861889094", "新疆喀什地区",
"861586631", "山东省威海市",
"861300841", "陕西省西安市",
"861330232", "广东省广州市",
"86159947", "广东省深圳市",
"861820905", "新疆石河子市",
"861883080", "河北省衡水市",
"861880936", "甘肃省张掖市",
"861570999", "新疆伊犁哈萨克自治州",
"861518264", "四川省自贡市",
"861831912", "广东省湛江市",
"861383413", "山西省太原市",
"861558498", "吉林省辽源市",
"861564994", "河南省商丘市",
"861314562", "安徽省铜陵市",
"86186429", "辽宁省葫芦岛市",
"861364717", "湖北省宜昌市",
"86134534", "山西省太原市",
"861819015", "四川省遂宁市",
"861304623", "广东省湛江市",
"861380426", "辽宁省大连市",
"861536564", "江苏省泰州市",
"861453447", "辽宁省葫芦岛市",
"861764555", "黑龙江省哈尔滨市",
"861519631", "四川省甘孜藏族自治州",
"86138924", "陕西省宝鸡市",
"861598374", "四川省甘孜藏族自治州",
"861305549", "福建省南平市",
"861380367", "黑龙江省佳木斯市",
"861306302", "福建省漳州市",
"861832644", "安徽省宣城市",
"861514482", "内蒙古兴安盟",
"86182757", "广西南宁市",
"861528876", "山东省烟台市",
"861339837", "四川省绵阳市",
"861375788", "浙江省温州市",
"861560305", "广东省广州市",
"861303654", "四川省泸州市",
"861336484", "新疆巴音郭楞蒙古自治州",
"861819050", "四川省德阳市",
"861508804", "广东省佛山市",
"861576501", "黑龙江省牡丹江市",
"86137982", "广东省深圳市",
"86152550", "安徽省滁州市",
"86182585", "浙江省绍兴市",
"861822953", "湖南省湘西土家族苗族自治州",
"861450591", "辽宁省朝阳市",
"861857262", "湖北省荆州市",
"861572812", "广东省东莞市",
"861776964", "浙江省嘉兴市",
"861373184", "安徽省黄山市",
"861569467", "云南省玉溪市",
"861315380", "山东省聊城市",
"861328401", "黑龙江省哈尔滨市",
"86156432", "吉林省吉林市",
"86139883", "云南省临沧市",
"861317905", "吉林省松原市",
"861347784", "湖北省宜昌市",
"861538069", "江苏省连云港市",
"861807520", "安徽省亳州市",
"861521456", "黑龙江省黑河市",
"861550524", "江苏省苏州市",
"861301165", "山东省潍坊市",
"861313699", "黑龙江省佳木斯市",
"861336573", "安徽省芜湖市",
"861366347", "山西省临汾市",
"861859161", "陕西省汉中市",
"861844742", "内蒙古通辽市",
"861561632", "湖南省衡阳市",
"861335008", "四川省成都市",
"861768887", "广东省广州市",
"861538394", "河北省沧州市",
"861818029", "四川省泸州市",
"861567566", "湖南省郴州市",
"86186886", "广东省东莞市",
"861476004", "福建省厦门市",
"861807090", "广西南宁市",
"861599411", "河南省安阳市",
"861819713", "青海省西宁市",
"861890549", "山东省临沂市",
"861317680", "山东省威海市",
"861860675", "浙江省绍兴市",
"861471899", "西藏拉萨市",
"86183278", "湖北省黄石市",
"861587276", "湖北省咸宁市",
"861367486", "内蒙古赤峰市",
"861840325", "河北省唐山市",
"861599927", "新疆伊犁哈萨克自治州",
"861351956", "宁夏石嘴山市",
"861774432", "四川省南充市",
"861332560", "新疆乌鲁木齐市",
"86130674", "福建省福州市",
"861857947", "广西南宁市",
"861528942", "陕西省榆林市",
"861820534", "山东省德州市",
"861786665", "山东省烟台市",
"86177852", "贵州省遵义市",
"861356388", "山东省菏泽市",
"861504727", "内蒙古巴彦淖尔市",
"86138573", "浙江省嘉兴市",
"861365495", "辽宁省沈阳市",
"861504859", "内蒙古巴彦淖尔市",
"861309961", "云南省临沧市",
"86151910", "陕西省西安市",
"86831", "四川省宜宾市",
"861310511", "山东省枣庄市",
"861380438", "吉林省松原市",
"861396593", "安徽省池州市",
"86150353", "山西省吕梁市",
"861328998", "新疆喀什地区",
"861309316", "江苏省常州市",
"861761291", "陕西省咸阳市",
"861874630", "黑龙江省牡丹江市",
"861760645", "山东省烟台市",
"861562265", "广东省云浮市",
"861536848", "云南省保山市",
"861338730", "湖南省岳阳市",
"861366758", "新疆和田地区",
"86153892", "陕西省西安市",
"861817888", "广西河池市",
"86184430", "吉林省长春市",
"861780832", "四川省内江市",
"861582575", "浙江省金华市",
"861472987", "陕西省榆林市",
"861453619", "江苏省扬州市",
"861340457", "吉林省松原市",
"861470644", "山东省烟台市",
"861810537", "山东省济宁市",
"861587867", "广西河池市",
"86145837", "山东省济南市",
"86151972", "湖南省湘潭市",
"861810880", "云南省丽江市",
"861867257", "湖北省荆州市",
"861319930", "黑龙江省黑河市",
"861866045", "山东省潍坊市",
"861362567", "安徽省安庆市",
"861505090", "江苏省连云港市",
"861361246", "广东省佛山市",
"861535215", "甘肃省张掖市",
"861581994", "广东省江门市",
"86188129", "天津市",
"861819420", "甘肃省武威市",
"861351443", "吉林省延边朝鲜族自治州",
"86184437", "吉林省辽源市",
"861334053", "福建省南平市",
"861562487", "内蒙古兴安盟",
"861576958", "宁夏银川市",
"861329314", "河北省邢台市",
"861535250", "新疆乌鲁木齐市",
"861869626", "湖北省鄂州市",
"861393483", "山西省朔州市",
"861387430", "湖南省益阳市",
"861555947", "新疆阿克苏地区",
"861850669", "广东省茂名市",
"861804579", "黑龙江省鸡西市",
"86151917", "陕西省宝鸡市",
"86186462", "黑龙江省哈尔滨市",
"861326395", "江西省宜春市",
"861304293", "甘肃省庆阳市",
"861380782", "广西柳州市",
"861380056", "安徽省淮北市",
"861771170", "湖南省湘西土家族苗族自治州",
"861363432", "吉林省吉林市",
"861365510", "江苏省盐城市",
"861889148", "陕西省西安市",
"861510139", "甘肃省金昌市",
"861522992", "陕西省榆林市",
"861533862", "贵州省遵义市",
"861800536", "山东省潍坊市",
"861808882", "广东省珠海市",
"861588143", "四川省绵阳市",
"861345122", "湖北省荆州市",
"861899860", "广东省清远市",
"86170761", "山东省济南市",
"861800098", "广东省江门市",
"861705623", "陕西省西安市",
"861385949", "福建省南平市",
"861335078", "四川省达州市",
"861898674", "湖北省黄冈市",
"861365555", "安徽省合肥市",
"861806429", "湖北省武汉市",
"861539918", "陕西省西安市",
"86158132", "广东省清远市",
"861306939", "河南省新乡市",
"861860605", "福建省泉州市",
"861310688", "广东省东莞市",
"861768530", "贵州省贵阳市",
"861334755", "广西玉林市",
"861576465", "黑龙江省大庆市",
"861501454", "广东省韶关市",
"861528485", "四川省广元市",
"861350751", "福建省龙岩市",
"861317975", "江苏省扬州市",
"861884909", "河北省衡水市",
"861860980", "辽宁省鞍山市",
"861367722", "湖北省荆州市",
"861328471", "内蒙古包头市",
"861369830", "四川省内江市",
"861564845", "内蒙古赤峰市",
"861452792", "新疆哈密地区",
"861336503", "福建省宁德市",
"861356235", "山东省日照市",
"86158393", "河南省濮阳市",
"861569285", "四川省眉山市",
"861800528", "江苏省镇江市",
"861328565", "安徽省合肥市",
"861589481", "内蒙古呼伦贝尔市",
"861878610", "贵州省贵阳市",
"861898767", "云南省昆明市",
"861348539", "山西省忻州市",
"861389475", "吉林省长春市",
"861783527", "山西省吕梁市",
"86152557", "安徽省宿州市",
"861376585", "贵州省毕节地区",
"861700659", "山东省青岛市",
"861379345", "山东省德州市",
"861315444", "四川省绵阳市",
"861580821", "四川省自贡市",
"861595042", "江苏省无锡市",
"861308863", "浙江省台州市",
"861308289", "浙江省丽水市",
"861581613", "广东省湛江市",
"861302981", "黑龙江省大庆市",
"861502975", "陕西省西安市",
"861859553", "河南省周口市",
"861374794", "河南省信阳市",
"861880763", "广东省清远市",
"861518197", "四川省泸州市",
"86152785", "广西玉林市",
"86182750", "贵州省贵阳市",
"861329952", "宁夏石嘴山市",
"861360799", "江西省萍乡市",
"861760813", "四川省自贡市",
"861511499", "陕西省铜川市",
"861555262", "山东省德州市",
"861598304", "四川省泸州市",
"861475732", "浙江省宁波市",
"861375432", "浙江省杭州市",
"861893462", "湖北省黄冈市",
"861339580", "浙江省舟山市",
"861341940", "四川省乐山市",
"861336340", "山西省大同市",
"86187207", "江西省赣州市",
"861321851", "江苏省盐城市",
"861558558", "吉林省延边朝鲜族自治州",
"861360381", "河南省三门峡市",
"861378818", "广西河池市",
"861560375", "河南省平顶山市",
"861568633", "陕西省渭南市",
"861873566", "山西省运城市",
"861565988", "福建省泉州市",
"861821154", "广东省梅州市",
"861808494", "四川省泸州市",
"86183976", "湖南省邵阳市",
"861571695", "河北省保定市",
"861533165", "云南省普洱市",
"861598682", "广东省深圳市",
"861539460", "江苏省徐州市",
"86153349", "内蒙古通辽市",
"861330471", "内蒙古呼和浩特市",
"861839784", "江西省抚州市",
"861530485", "黑龙江省绥化市",
"861805491", "福建省南平市",
"861551338", "山西省晋城市",
"861361548", "山东省泰安市",
"861366304", "河南省周口市",
"861511973", "广东省茂名市",
"861587017", "贵州省安顺市",
"861868552", "贵州省六盘水市",
"861300087", "甘肃省兰州市",
"861454775", "山东省淄博市",
"861390908", "四川省泸州市",
"861862670", "吉林省长春市",
"861512896", "河北省保定市",
"861304033", "吉林省松原市",
"861773469", "陕西省渭南市",
"861855982", "福建省厦门市",
"861500685", "山东省东营市",
"861354561", "湖北省咸宁市",
"861325583", "浙江省嘉兴市",
"86177421", "辽宁省朝阳市",
"861315477", "内蒙古鄂尔多斯市",
"861862442", "辽宁省大连市",
"861379919", "福建省三明市",
"861835691", "安徽省黄山市",
"861821849", "广东省广州市",
"861356793", "浙江省宁波市",
"861330565", "安徽省巢湖市",
"861559632", "陕西省渭南市",
"861454125", "河北省唐山市",
"861321967", "四川省乐山市",
"861301012", "北京市",
"861323428", "辽宁省盘锦市",
"86159713", "湖北省黄冈市",
"86183387", "河南省商丘市",
"861399748", "青海省西宁市",
"861847837", "湖南省湘西土家族苗族自治州",
"861820694", "云南省西双版纳傣族自治州",
"861830556", "安徽省安庆市",
"861840588", "浙江省丽水市",
"861322293", "江苏省无锡市",
"861318441", "浙江省杭州市",
"861363393", "河南省濮阳市",
"861333989", "湖北省随州市",
"861342417", "广东省深圳市",
"861327726", "湖北省十堰市",
"861560260", "广东省东莞市",
"861823043", "河北省秦皇岛市",
"861362878", "云南省楚雄彝族自治州",
"861576820", "广东省汕头市",
"861584803", "内蒙古乌兰察布市",
"861312551", "辽宁省抚顺市",
"861884553", "黑龙江省绥化市",
"861850749", "湖南省长沙市",
"861580570", "浙江省衢州市",
"861561592", "山东省东营市",
"861305406", "湖南省衡阳市",
"861336959", "宁夏银川市",
"861313539", "湖南省邵阳市",
"861895671", "安徽省阜阳市",
"861818639", "湖北省黄石市",
"861590724", "湖北省咸宁市",
"861531434", "山东省东营市",
"861700439", "江苏省苏州市",
"861309109", "河北省石家庄市",
"861337306", "河北省廊坊市",
"86133122", "贵州省贵阳市",
"861539772", "四川省广元市",
"861594940", "内蒙古鄂尔多斯市",
"86189389", "广东省深圳市",
"861518902", "江苏省连云港市",
"861399935", "新疆昌吉回族自治州",
"861454822", "广东省珠海市",
"861880643", "山东省淄博市",
"861890885", "云南省昆明市",
"861889080", "新疆伊犁哈萨克自治州",
"861319183", "河北省秦皇岛市",
"861572062", "江苏省南京市",
"861861493", "河南省焦作市",
"861388167", "四川省巴中市",
"861390491", "辽宁省朝阳市",
"86159347", "贵州省毕节地区",
"861879004", "河南省焦作市",
"861878435", "四川省阿坝藏族羌族自治州",
"861501634", "广东省阳江市",
"861450631", "黑龙江省佳木斯市",
"861378746", "湖南省永州市",
"861356095", "广东省梅州市",
"861539122", "内蒙古乌兰察布市",
"8613262", "上海市",
"861834646", "黑龙江省牡丹江市",
"86133211", "北京市",
"86185527", "江苏省宿迁市",
"861378925", "湖南省娄底市",
"861386699", "安徽省芜湖市",
"861351587", "浙江省温州市",
"861866663", "广东省江门市",
"861821328", "云南省丽江市",
"861871211", "安徽省宿州市",
"861890406", "辽宁省锦州市",
"861857904", "江西省南昌市",
"86155720", "湖北省荆州市",
"861500900", "新疆乌鲁木齐市",
"861869458", "浙江省杭州市",
"861355963", "福建省泉州市",
"86135286", "广东省东莞市",
"861551326", "山西省太原市",
"861524975", "河南省商丘市",
"86170947", "内蒙古呼和浩特市",
"861570852", "贵州省遵义市",
"861558169", "湖南省常德市",
"861350512", "江苏省泰州市",
"861780673", "广东省梅州市",
"861323436", "吉林省白城市",
"861874020", "辽宁省辽阳市",
"861820913", "陕西省渭南市",
"861551467", "河南省鹤壁市",
"861500396", "河南省驻马店市",
"861352333", "河南省安阳市",
"861898647", "湖北省孝感市",
"861524146", "辽宁省大连市",
"861819865", "贵州省黔南布依族苗族自治州",
"86150322", "河北省保定市",
"861803924", "河南省洛阳市",
"86138195", "浙江省绍兴市",
"861855445", "山东省济南市",
"861869598", "河南省南阳市",
"861597671", "广东省河源市",
"861870572", "浙江省湖州市",
"861520394", "河南省周口市",
"86170940", "辽宁省大连市",
"861886822", "浙江省湖州市",
"86130013", "天津市",
"861367997", "新疆博尔塔拉蒙古自治州",
"861532307", "广东省惠州市",
"861571535", "山东省烟台市",
"861852737", "湖北省黄冈市",
"861355736", "广西桂林市",
"861593245", "河北省邯郸市",
"861812182", "四川省南充市",
"861530942", "甘肃省酒泉市",
"86184396", "河南省驻马店市",
"861598758", "云南省德宏傣族景颇族自治州",
"861814447", "广东省江门市",
"861309857", "贵州省毕节地区",
"86151693", "山东省淄博市",
"861524905", "陕西省渭南市",
"861779044", "四川省巴中市",
"861333634", "山东省莱芜市",
"861786938", "云南省怒江傈僳族自治州",
"861500970", "青海省海北藏族自治州",
"861458662", "湖南省邵阳市",
"861881187", "广东省深圳市",
"861351830", "四川省绵阳市",
"861890476", "内蒙古赤峰市",
"861899753", "新疆和田地区",
"861452411", "辽宁省大连市",
"86155727", "湖北省宜昌市",
"861879074", "河南省三门峡市",
"861876242", "江苏省苏州市",
"861309729", "江西省九江市",
"861377223", "陕西省安康市",
"86185520", "江苏省无锡市",
"86136516", "上海市",
"861805978", "福建省龙岩市",
"861521636", "山东省潍坊市",
"861858567", "贵州省黔南布依族苗族自治州",
"861308013", "河南省漯河市",
"861778791", "云南省玉溪市",
"861330998", "新疆喀什地区",
"861826237", "江苏省盐城市",
"86177823", "重庆市",
"861535391", "陕西省商洛市",
"86152092", "陕西省西安市",
"861705033", "重庆市",
"861824444", "四川省达州市",
"861320730", "湖南省岳阳市",
"86180339", "福建省宁德市",
"861535789", "安徽省芜湖市",
"861322623", "广东省湛江市",
"861327482", "内蒙古兴安盟",
"861390551", "安徽省合肥市",
"861337376", "河南省新乡市",
"861770542", "山东省青岛市",
"861309179", "黑龙江省双鸭山市",
"86134776", "湖北省黄冈市",
"861521628", "江西省吉安市",
"861577118", "湖北省黄石市",
"861362808", "四川省绵阳市",
"861453474", "黑龙江省鸡西市",
"86145017", "山西省临汾市",
"861354153", "四川省内江市",
"861885017", "福建省厦门市",
"861570584", "浙江省宁波市",
"86132815", "四川省绵阳市",
"861564589", "黑龙江省伊春市",
"861880850", "贵州省贵阳市",
"861522859", "四川省攀枝花市",
"861557982", "江西省宜春市",
"86135988", "河南省郑州市",
"861310752", "青海省海东地区",
"861530876", "云南省文山壮族苗族自治州",
"861556227", "山东省济宁市",
"861310086", "黑龙江省黑河市",
"86156683", "山东省济南市",
"861369443", "吉林省延边朝鲜族自治州",
"861354886", "湖南省常德市",
"861537691", "山东省临沂市",
"86136321", "广东省广州市",
"861880815", "四川省凉山彝族自治州",
"861598347", "四川省广安市",
"861364469", "黑龙江省大庆市",
"861376849", "广西南宁市",
"861760765", "广东省东莞市",
"861800696", "福建省漳州市",
"86133169", "广东省深圳市",
"861370464", "黑龙江省鹤岗市",
"86137316", "河北省保定市",
"861328243", "浙江省杭州市",
"861847580", "广东省清远市",
"861306041", "陕西省西安市",
"861707841", "云南省保山市",
"861534839", "湖南省邵阳市",
"861518339", "四川省乐山市",
"861595371", "山东省济宁市",
"861308715", "内蒙古通辽市",
"861524680", "黑龙江省哈尔滨市",
"861315407", "陕西省商洛市",
"86139406", "辽宁省锦州市",
"861355728", "广西河池市",
"861814619", "福建省南平市",
"861346624", "云南省昭通市",
"86133646", "吉林省长春市",
"861580343", "山西省太原市",
"86183380", "河南省濮阳市",
"861882060", "广东省东莞市",
"861570473", "内蒙古乌海市",
"861708557", "安徽省阜阳市",
"861344683", "广西百色市",
"861380658", "浙江省台州市",
"861366374", "河南省许昌市",
"861355178", "四川省巴中市",
"861569719", "湖北省十堰市",
"861786926", "云南省丽江市",
"861384864", "内蒙古乌兰察布市",
"861568023", "四川省自贡市",
"861459139", "广西贵港市",
"86151828", "四川省达州市",
"861507163", "湖北省随州市",
"861518846", "河南省南阳市",
"86130666", "辽宁省沈阳市",
"861534346", "山西省晋中市",
"861454705", "浙江省绍兴市",
"86153658", "江苏省徐州市",
"861862600", "江苏省徐州市",
"861390978", "青海省西宁市",
"861568872", "山东省威海市",
"861871445", "黑龙江省双鸭山市",
"861847634", "广东省广州市",
"861582513", "云南省玉溪市",
"861881375", "广东省广州市",
"861800859", "贵州省黔西南布依族苗族自治州",
"861572173", "贵州省铜仁地区",
"861580332", "河北省保定市",
"861535203", "甘肃省定西市",
"861365345", "山西省长治市",
"86188738", "湖南省娄底市",
"861825095", "福建省南平市",
"861334000", "江西省新余市",
"861700147", "江苏省南通市",
"861330522", "江苏省徐州市",
"861570630", "山东省潍坊市",
"861557088", "湖南省长沙市",
"861313317", "山西省临汾市",
"861887239", "湖北省荆门市",
"861572723", "湖北省荆州市",
"861893860", "广东省清远市",
"861454162", "浙江省湖州市",
"861520477", "内蒙古鄂尔多斯市",
"861510583", "浙江省嘉兴市",
"861772954", "陕西省延安市",
"861594549", "黑龙江省牡丹江市",
"861505084", "江苏省徐州市",
"861813420", "河北省邯郸市",
"861802069", "福建省漳州市",
"861356562", "新疆昌吉回族自治州",
"861810894", "西藏林芝地区",
"861335197", "黑龙江省鸡西市",
"861769838", "河南省南阳市",
"86135277", "广东省广州市",
"861571904", "新疆哈密地区",
"86187120", "安徽省滁州市",
"861313930", "甘肃省临夏回族自治州",
"86135121", "上海市",
"861572595", "山东省临沂市",
"861581980", "广东省珠海市",
"86151372", "河南省安阳市",
"861369432", "吉林省吉林市",
"861390823", "四川省成都市",
"861556482", "山东省泰安市",
"861339024", "辽宁省沈阳市",
"861337599", "福建省泉州市",
"861860613", "江苏省南通市",
"861310191", "江苏省淮安市",
"861838905", "西藏昌都地区",
"86151317", "河北省沧州市",
"861510474", "内蒙古乌兰察布市",
"861361774", "广西梧州市",
"861595623", "安徽省池州市",
"861869922", "新疆伊犁哈萨克自治州",
"861800727", "湖北省襄樊市",
"861762521", "江苏省南通市",
"861328232", "浙江省嘉兴市",
"861399483", "山西省吕梁市",
"861390072", "江西省吉安市",
"861388759", "云南省红河哈尼族彝族自治州",
"86159761", "广东省惠州市",
"861841978", "甘肃省陇南市",
"861769826", "河南省平顶山市",
"861503660", "河南省新乡市",
"861398141", "四川省内江市",
"861876233", "江苏省泰州市",
"861592404", "浙江省舟山市",
"861561065", "山东省临沂市",
"861336515", "江苏省宿迁市",
"861778152", "四川省凉山彝族自治州",
"861333580", "浙江省舟山市",
"861556106", "内蒙古通辽市",
"861760486", "内蒙古赤峰市",
"861454865", "河南省焦作市",
"861323952", "宁夏石嘴山市",
"861339594", "福建省莆田市",
"861826108", "江苏省宿迁市",
"861368538", "山东省泰安市",
"861336550", "安徽省滁州市",
"861802394", "广东省潮州市",
"861558348", "四川省凉山彝族自治州",
"861598986", "广东省深圳市",
"861580979", "青海省海西蒙古族藏族自治州",
"86159531", "山东省济南市",
"86134549", "浙江省金华市",
"861539165", "湖北省黄石市",
"86187456", "黑龙江省黑河市",
"86183376", "河南省信阳市",
"861453397", "内蒙古巴彦淖尔市",
"86150878", "云南省临沧市",
"861770533", "山东省淄博市",
"861378962", "内蒙古包头市",
"861361667", "浙江省台州市",
"861597323", "湖南省湘潭市",
"86180781", "广西南宁市",
"861563285", "河北省衡水市",
"861811417", "江苏省常州市",
"861835040", "福建省莆田市",
"861508516", "贵州省黔南布依族苗族自治州",
"86158993", "新疆阿克苏地区",
"861860994", "新疆昌吉回族自治州",
"86156029", "广东省深圳市",
"861322371", "河南省郑州市",
"861818119", "四川省凉山彝族自治州",
"861371728", "广东省江门市",
"861340798", "江西省景德镇市",
"861874999", "河南省驻马店市",
"86180292", "广东省佛山市",
"86188568", "安徽省阜阳市",
"861366497", "广东省阳江市",
"861586451", "山东省济南市",
"861897293", "湖北省武汉市",
"86130243", "江苏省扬州市",
"861888661", "四川省成都市",
"861379555", "四川省自贡市",
"86134780", "辽宁省鞍山市",
"861348856", "内蒙古赤峰市",
"861534987", "安徽省六安市",
"86151743", "湖南省湘西土家族苗族自治州",
"861350977", "山西省临汾市",
"861530933", "甘肃省平凉市",
"861811921", "新疆伊犁哈萨克自治州",
"861501837", "广东省汕头市",
"861810482", "内蒙古兴安盟",
"861892176", "江苏省徐州市",
"861338888", "云南省丽江市",
"861311431", "湖北省荆州市",
"861383475", "山西省吕梁市",
"861560731", "湖南省长沙市",
"861381518", "江苏省镇江市",
"861518078", "贵州省黔南布依族苗族自治州",
"861859500", "宁夏中卫市",
"861559850", "内蒙古兴安盟",
"861868001", "广东省佛山市",
"861864305", "吉林省白城市",
"861819003", "四川省泸州市",
"861350907", "广东省惠州市",
"861366557", "安徽省宿州市",
"861870917", "陕西省宝鸡市",
"861379184", "山东省青岛市",
"86134787", "辽宁省大连市",
"861584763", "内蒙古包头市",
"861479795", "江西省宜春市",
"8614501", "天津市",
"861589749", "湖南省永州市",
"861810738", "湖南省娄底市",
"861383405", "山西省长治市",
"861345012", "广东省茂名市",
"861518008", "江西省鹰潭市",
"861373190", "安徽省宣城市",
"861780430", "吉林省长春市",
"861870421", "辽宁省朝阳市",
"861560313", "河北省张家口市",
"861871982", "甘肃省兰州市",
"861530766", "广东省云浮市",
"861363201", "广东省潮州市",
"861319699", "江苏省淮安市",
"861572968", "四川省乐山市",
"861806898", "江苏省南通市",
"86176866", "山东省济南市",
"861470874", "云南省曲靖市",
"861324212", "广东省佛山市",
"86189731", "湖南省长沙市",
"861760875", "云南省保山市",
"861536678", "江苏省徐州市",
"861708374", "河南省许昌市",
"861898995", "西藏昌都地区",
"861458625", "湖北省黄冈市",
"861860845", "湖南省怀化市",
"86138324", "河北省承德市",
"861502913", "陕西省渭南市",
"86150581", "浙江省杭州市",
"861537040", "江苏省无锡市",
"861564980", "河南省许昌市",
"861580909", "新疆博尔塔拉蒙古自治州",
"861339454", "黑龙江省佳木斯市",
"861507823", "广西百色市",
"861556726", "吉林省松原市",
"86158768", "广东省潮州市",
"861359747", "湖北省襄樊市",
"861831616", "广东省阳江市",
"86130061", "湖北省武汉市",
"861880632", "山东省枣庄市",
"861780321", "河北省石家庄市",
"86134555", "山东省烟台市",
"861870330", "河北省邯郸市",
"861865047", "福建省福州市",
"861362046", "广东省珠海市",
"861847989", "江西省景德镇市",
"861831868", "广东省茂名市",
"861768041", "湖南省衡阳市",
"861309654", "山西省大同市",
"861511349", "广东省梅州市",
"861392191", "江苏省扬州市",
"861532882", "四川省宜宾市",
"861333837", "福建省龙岩市",
"86184060", "辽宁省沈阳市",
"861317913", "吉林省长春市",
"861336490", "新疆昌吉回族自治州",
"861801416", "江苏省淮安市",
"86131592", "福建省厦门市",
"86188209", "广东省深圳市",
"861534258", "湖北省鄂州市",
"861766013", "山东省济南市",
"861303316", "安徽省安庆市",
"86188252", "广东省深圳市",
"861479093", "安徽省滁州市",
"8613916", "上海市",
"86150953", "甘肃省兰州市",
"861822685", "安徽省阜阳市",
"861841908", "甘肃省陇南市",
"861831544", "山东省潍坊市",
"861327697", "福建省漳州市",
"861596698", "山东省淄博市",
"861340834", "四川省凉山彝族自治州",
"861709411", "广东省深圳市",
"861346827", "山东省东营市",
"861771405", "江苏省苏州市",
"861390002", "辽宁省沈阳市",
"861510404", "辽宁省沈阳市",
"86151310", "河北省邯郸市",
"861361704", "江西省抚州市",
"86158538", "山东省泰安市",
"861572410", "广东省深圳市",
"86145240", "辽宁省沈阳市",
"861459619", "甘肃省庆阳市",
"861875296", "江苏省镇江市",
"861372297", "河北省保定市",
"861301918", "吉林省延边朝鲜族自治州",
"86187271", "湖北省襄樊市",
"861529365", "甘肃省甘南藏族自治州",
"86135270", "广东省肇庆市",
"861571974", "青海省海南藏族自治州",
"86187127", "河北省秦皇岛市",
"861351393", "河南省濮阳市",
"861341182", "广东省佛山市",
"861760722", "湖北省仙桃市",
"861525086", "江苏省淮安市",
"861838146", "四川省宜宾市",
"861550080", "宁夏银川市",
"86132620", "河南省南阳市",
"861343789", "广东省湛江市",
"861810945", "甘肃省武威市",
"861538380", "河北省邯郸市",
"861359358", "山西省运城市",
"861334070", "四川省内江市",
"861332171", "广西南宁市",
"861597252", "湖北省黄石市",
"861771886", "广东省江门市",
"861399504", "宁夏固原市",
"861304042", "浙江省宁波市",
"861519240", "山东省烟台市",
"861317694", "山东省烟台市",
"861862433", "辽宁省沈阳市",
"86156062", "江苏省苏州市",
"861500579", "浙江省金华市",
"861332721", "湖南省长沙市",
"861860142", "江苏省苏州市",
"861587744", "陕西省西安市",
"861858648", "贵州省六盘水市",
"861575467", "黑龙江省鸡西市",
"861396642", "安徽省安庆市",
"861535273", "新疆石河子市",
"861452245", "浙江省宁波市",
"86136582", "重庆市",
"861362923", "陕西省渭南市",
"861775780", "浙江省丽水市",
"861773077", "陕西省汉中市",
"861528646", "贵州省六盘水市",
"861559643", "陕西省西安市",
"861586021", "福建省漳州市",
"86189561", "安徽省淮北市",
"861320261", "广东省肇庆市",
"861315069", "云南省昭通市",
"861890359", "山西省运城市",
"861569961", "黑龙江省哈尔滨市",
"861364859", "贵州省黔西南布依族苗族自治州",
"861550514", "江苏省苏州市",
"861370854", "贵州省黔南布依族苗族自治州",
"861591239", "云南省玉溪市",
"861573549", "山西省晋中市",
"861534749", "广东省汕头市",
"861769504", "宁夏固原市",
"86136353", "重庆市",
"861539763", "四川省成都市",
"86156431", "吉林省长春市",
"861479505", "宁夏中卫市",
"86186863", "吉林省长春市",
"861332001", "江西省南昌市",
"861883048", "河北省秦皇岛市",
"861340578", "江苏省无锡市",
"861347500", "山东省菏泽市",
"861302265", "浙江省金华市",
"861506758", "浙江省金华市",
"861572073", "江苏省南通市",
"86170729", "陕西省西安市",
"861577912", "江西省抚州市",
"86137981", "广东省广州市",
"861554556", "黑龙江省哈尔滨市",
"861521244", "安徽省合肥市",
"861766642", "广东省东莞市",
"861328907", "新疆和田地区",
"861810006", "上海市",
"861572822", "广东省佛山市",
"86155955", "宁夏银川市",
"86185980", "广东省深圳市",
"861322589", "安徽省合肥市",
"861866672", "广东省湛江市",
"861354891", "湖南省岳阳市",
"861585468", "山东省枣庄市",
"86188161", "山东省淄博市",
"861537686", "山东省菏泽市",
"861453941", "广东省茂名市",
"861330895", "西藏昌都地区",
"861559012", "吉林省松原市",
"861470526", "江苏省泰州市",
"861372064", "陕西省榆林市",
"86151307", "河北省沧州市",
"861815487", "新疆博尔塔拉蒙古自治州",
"861770360", "黑龙江省哈尔滨市",
"861800681", "浙江省杭州市",
"861895305", "山东省东营市",
"861458603", "湖北省鄂州市",
"861780662", "广东省阳江市",
"861304613", "广东省汕尾市",
"861380416", "辽宁省锦州市",
"861800077", "江西省赣州市",
"861819025", "四川省阿坝藏族羌族自治州",
"861362680", "浙江省宁波市",
"861331432", "吉林省吉林市",
"861390722", "湖北省武汉市",
"861344099", "新疆克拉玛依市",
"861587637", "广东省湛江市",
"861347343", "河北省石家庄市",
"861831922", "广东省云浮市",
"861339774", "广西贺州市",
"861802169", "江苏省南通市",
"861383423", "山西省太原市",
"861348785", "湖南省郴州市",
"861309338", "安徽省阜阳市",
"861866440", "广东省中山市",
"861364727", "湖北省宜昌市",
"861772200", "广东省阳江市",
"861881323", "广东省中山市",
"861453629", "江苏省泰州市",
"861782284", "贵州省黔东南苗族侗族自治州",
"861888253", "四川省成都市",
"861477887", "广东省江门市",
"861314959", "黑龙江省大庆市",
"861519861", "云南省怒江傈僳族自治州",
"861535386", "陕西省榆林市",
"861816514", "陕西省渭南市",
"861539065", "甘肃省天水市",
"861362905", "四川省南充市",
"861530148", "江苏省南通市",
"861470538", "山东省泰安市",
"861309467", "浙江省嘉兴市",
"861589258", "四川省攀枝花市",
"861372399", "山东省淄博市",
"86130432", "天津市",
"861880918", "陕西省西安市",
"861320840", "黑龙江省佳木斯市",
"861309326", "湖北省恩施土家族苗族自治州",
"861337129", "山东省临沂市",
"861340951", "宁夏银川市",
"861388409", "甘肃省金昌市",
"861372781", "广东省茂名市",
"861572775", "江西省赣州市",
"861851577", "四川省德阳市",
"86135259", "河南省洛阳市",
"861394345", "吉林省白城市",
"861352969", "云南省玉溪市",
"86177851", "贵州省贵阳市",
"861358261", "河北省石家庄市",
"861550646", "山东省聊城市",
"861504717", "内蒙古锡林郭勒盟",
"861399794", "湖北省荆门市",
"861819173", "陕西省渭南市",
"861840315", "河北省唐山市",
"861355846", "广西南宁市",
"861820648", "山东省潍坊市",
"861566684", "山东省菏泽市",
"861355339", "广东省汕头市",
"861805172", "江苏省盐城市",
"861590881", "云南省西双版纳傣族自治州",
"861390875", "云南省保山市",
"861890257", "广东省湛江市",
"861300305", "安徽省合肥市",
"861857441", "湖南省张家界市",
"861351740", "湖南省长沙市",
"86139866", "湖北省荆州市",
"861818019", "四川省达州市",
"861576060", "四川省广元市",
"861395681", "安徽省阜阳市",
"86137553", "江西省上饶市",
"861840350", "山西省忻州市",
"861835140", "江苏省镇江市",
"861528080", "福建省龙岩市",
"861338433", "吉林省延边朝鲜族自治州",
"861868721", "云南省昆明市",
"861539928", "陕西省榆林市",
"861459308", "四川省绵阳市",
"861520757", "广东省佛山市",
"861500799", "江西省萍乡市",
"86158131", "广东省中山市",
"861595605", "安徽省合肥市",
"861368874", "云南省文山壮族苗族自治州",
"86170762", "山东省济南市",
"861853061", "河南省安阳市",
"861324300", "河南省安阳市",
"861705613", "四川省成都市",
"861369660", "安徽省淮北市",
"861806419", "湖北省黄石市",
"861308633", "四川省达州市",
"861345112", "湖北省武汉市",
"8614500", "北京市",
"861365520", "江苏省徐州市",
"861843283", "河北省张家口市",
"86178810", "新疆喀什地区",
"86132999", "天津市",
"861346409", "辽宁省铁岭市",
"861858897", "广东省深圳市",
"861388479", "山东省威海市",
"861327848", "吉林省辽源市",
"861329569", "安徽省合肥市",
"861510754", "广东省汕头市",
"861350232", "广东省河源市",
"861361454", "黑龙江省佳木斯市",
"861390486", "黑龙江省大庆市",
"86139482", "内蒙古兴安盟",
"861570462", "黑龙江省齐齐哈尔市",
"86135854", "江苏省常州市",
"861324543", "山东省滨州市",
"861309285", "四川省达州市",
"86186461", "黑龙江省哈尔滨市",
"861865147", "江苏省淮安市",
"861556076", "内蒙古赤峰市",
"861771710", "河北省邯郸市",
"861867549", "广东省揭阳市",
"861590566", "安徽省池州市",
"861325629", "山东省滨州市",
"861532783", "湖北省武汉市",
"861871531", "安徽省芜湖市",
"861529489", "河南省新乡市",
"861370582", "浙江省湖州市",
"861772831", "广东省佛山市",
"861535225", "甘肃省临夏回族自治州",
"861312722", "山东省枣庄市",
"861537140", "江苏省淮安市",
"861378836", "广西南宁市",
"861870563", "安徽省宣城市",
"861890988", "辽宁省沈阳市",
"861850346", "山西省太原市",
"861345815", "四川省遂宁市",
"861855188", "江苏省连云港市",
"861815265", "湖南省常德市",
"861869544", "宁夏固原市",
"861311545", "黑龙江省哈尔滨市",
"861339704", "江西省九江市",
"861331788", "广西柳州市",
"861520348", "山西省运城市",
"861527195", "湖北省襄樊市",
"86137694", "云南省红河哈尼族彝族自治州",
"861779098", "辽宁省沈阳市",
"861378828", "广西河池市",
"861340017", "河北省沧州市",
"861327564", "安徽省六安市",
"861814039", "四川省凉山彝族自治州",
"861458673", "湖南省娄底市",
"861359989", "福建省莆田市",
"861760823", "四川省成都市",
"861850839", "四川省广元市",
"861315169", "江苏省镇江市",
"861580811", "四川省攀枝花市",
"861332687", "广东省东莞市",
"861450957", "江苏省宿迁市",
"861347570", "山东省聊城市",
"861501246", "广东省深圳市",
"861539936", "陕西省安康市",
"86185987", "重庆市",
"861479461", "黑龙江省哈尔滨市",
"861810076", "广西南宁市",
"861707313", "河北省保定市",
"861533632", "山东省枣庄市",
"861834234", "辽宁省盘锦市",
"861597305", "湖南省常德市",
"861334720", "湖南省岳阳市",
"861805486", "福建省漳州市",
"861595980", "福建省三明市",
"861773727", "河南省新乡市",
"861819968", "新疆石河子市",
"86155949", "陕西省西安市",
"861332071", "四川省攀枝花市",
"861315256", "广西柳州市",
"861824498", "广东省深圳市",
"861812257", "广东省茂名市",
"861388248", "四川省阿坝藏族羌族自治州",
"861807184", "湖北省黄冈市",
"861367712", "湖北省孝感市",
"861589987", "广东省深圳市",
"861807495", "广西梧州市",
"861861784", "河北省秦皇岛市",
"861337283", "辽宁省沈阳市",
"861319785", "江西省宜春市",
"86159703", "江西省上饶市",
"861458321", "江西省九江市",
"861899473", "江苏省泰州市",
"861890082", "广东省湛江市",
"861337869", "广东省广州市",
"861339548", "山东省泰安市",
"861341988", "河南省新乡市",
"861575179", "江苏省常州市",
"861533643", "山东省淄博市",
"861598478", "四川省达州市",
"861857250", "湖北省十堰市",
"861568703", "云南省昭通市",
"861517222", "湖北省孝感市",
"861352560", "河南省濮阳市",
"861760978", "青海省西宁市",
"861767900", "江西省南昌市",
"861333358", "山西省吕梁市",
"861522007", "广东省深圳市",
"861773696", "河北省沧州市",
"861810564", "安徽省六安市",
"86150921", "山东省青岛市",
"861300187", "河北省保定市",
"861378973", "内蒙古赤峰市",
"861558394", "四川省资阳市",
"861802348", "广东省广州市",
"861572865", "广东省中山市",
"861565940", "福建省漳州市",
"861810329", "河北省邢台市",
"861857215", "湖北省武汉市",
"861364238", "广东省东莞市",
"861458430", "河南省许昌市",
"861899584", "湖北省荆州市",
"861370657", "浙江省台州市",
"861327076", "江苏省泰州市",
"861314550", "安徽省滁州市",
"861398690", "湖北省十堰市",
"861525091", "江苏省徐州市",
"861860948", "甘肃省兰州市",
"86187826", "四川省广安市",
"861307004", "新疆喀什地区",
"861778501", "贵州省贵阳市",
"86186811", "广东省东莞市",
"861340744", "湖南省张家界市",
"86155892", "山东省枣庄市",
"86137744", "上海市",
"861820567", "安徽省亳州市",
"861584702", "内蒙古呼伦贝尔市",
"861357119", "陕西省宝鸡市",
"86138737", "湖南省益阳市",
"861539592", "福建省厦门市",
"861831965", "广东省阳江市",
"861571441", "吉林省长春市",
"86182325", "河北省唐山市",
"861847014", "江西省上饶市",
"861570055", "四川省广元市",
"861581371", "广东省深圳市",
"861529661", "山西省太原市",
"861350243", "广东省惠州市",
"861539022", "四川省泸州市",
"861301850", "广东省茂名市",
"861569434", "吉林省四平市",
"861814378", "甘肃省兰州市",
"861860735", "湖南省郴州市",
"861523312", "河北省保定市",
"861360446", "吉林省吉林市",
"861324532", "山东省青岛市",
"861364226", "广东省肇庆市",
"861707260", "湖北省咸宁市",
"86158671", "浙江省杭州市",
"861454723", "浙江省温州市",
"861580790", "江西省新余市",
"861776937", "湖南省益阳市",
"861889180", "陕西省咸阳市",
"861310472", "广东省珠海市",
"861572162", "山西省大同市",
"861319083", "内蒙古鄂尔多斯市",
"86136922", "广东省深圳市",
"861511925", "广东省河源市",
"861539873", "云南省红河哈尼族彝族自治州",
"861353454", "广东省揭阳市",
"861839493", "甘肃省庆阳市",
"861310640", "浙江省金华市",
"86138567", "安徽省阜阳市",
"861301815", "四川省泸州市",
"861822799", "四川省广安市",
"861592941", "陕西省延安市",
"86157652", "黑龙江省绥化市",
"861305082", "辽宁省铁岭市",
"861894268", "河北省秦皇岛市",
"861760551", "安徽省合肥市",
"861383891", "河南省焦作市",
"861863507", "山西省晋中市",
"861538498", "新疆喀什地区",
"861454173", "浙江省嘉兴市",
"86139595", "福建省莆田市",
"861333747", "湖北省荆门市",
"861524046", "江苏省无锡市",
"861826972", "安徽省安庆市",
"861786612", "甘肃省兰州市",
"861356573", "新疆石河子市",
"861530524", "江苏省宿迁市",
"861338442", "吉林省吉林市",
"861809352", "甘肃省金昌市",
"861530369", "黑龙江省大庆市",
"861308470", "内蒙古呼伦贝尔市",
"861573940", "新疆阿克苏地区",
"86187489", "贵州省黔西南布依族苗族自治州",
"861316000", "江苏省淮安市",
"861879896", "西藏那曲地区",
"861570753", "广东省梅州市",
"86158434", "吉林省四平市",
"861322980", "广东省清远市",
"861308642", "四川省自贡市",
"861782030", "广东省中山市",
"861477302", "湖南省湘潭市",
"861332552", "新疆喀什地区",
"861380334", "河北省石家庄市",
"861338670", "辽宁省本溪市",
"861339864", "河北省保定市",
"861390063", "山东省济南市",
"861454410", "福建省福州市",
"861302692", "广西柳州市",
"861579406", "广东省深圳市",
"861533850", "贵州省贵阳市",
"861873439", "山西省忻州市",
"86186413", "辽宁省抚顺市",
"861354710", "四川省绵阳市",
"861848410", "贵州省贵阳市",
"861332492", "云南省红河哈尼族彝族自治州",
"861457034", "广东省广州市",
"861501747", "广东省惠州市",
"861365641", "山东省济南市",
"861763547", "山西省吕梁市",
"861891951", "四川省泸州市",
"86130003", "江苏省无锡市",
"861454455", "江西省宜春市",
"861881671", "广东省茂名市",
"861813635", "江苏省徐州市",
"861354755", "四川省南充市",
"86156265", "广东省深圳市",
"861899852", "广东省汕尾市",
"861778958", "甘肃省白银市",
"861526639", "山东省临沂市",
"861533815", "广东省珠海市",
"861308400", "安徽省宿州市",
"861769935", "新疆昌吉回族自治州",
"861780295", "陕西省安康市",
"861472669", "四川省甘孜藏族自治州",
"861598991", "广东省东莞市",
"861317648", "山东省青岛市",
"86392", "河南省鹤壁市",
"86138560", "安徽省合肥市",
"861325754", "广东省汕头市",
"861381238", "江苏省泰州市",
"861454103", "安徽省芜湖市",
"861833343", "河北省沧州市",
"86158080", "重庆市",
"86185976", "福建省宁德市",
"861532448", "安徽省合肥市",
"861508236", "四川省攀枝花市",
"861315829", "贵州省黔西南布依族苗族自治州",
"861538558", "安徽省阜阳市",
"861566530", "安徽省安庆市",
"861889514", "宁夏固原市",
"86178625", "山东省聊城市",
"861353594", "广东省茂名市",
"861310402", "黑龙江省齐齐哈尔市",
"861510629", "江苏省南通市",
"861839553", "安徽省宣城市",
"861535262", "新疆乌鲁木齐市",
"861700268", "广东省广州市",
"86897", "西藏阿里地区\、普兰县\、扎达县",
"86137306", "四川省成都市",
"86189503", "福建省福州市",
"861315348", "山东省德州市",
"861332884", "福建省莆田市",
"86138730", "湖南省岳阳市",
"861509652", "云南省文山壮族苗族自治州",
"861584772", "内蒙古鄂尔多斯市",
"861392472", "广东省潮州市",
"861886025", "河南省新乡市",
"861893450", "江苏省南通市",
"861454968", "黑龙江省黑河市",
"861385131", "江苏省盐城市",
"861815222", "甘肃省定西市",
"861535947", "福建省泉州市",
"861310186", "江苏省宿迁市",
"861533112", "辽宁省大连市",
"861899155", "陕西省安康市",
"86159375", "河南省平顶山市",
"861329960", "广西柳州市",
"861830669", "广东省深圳市",
"861539452", "福建省福州市",
"86132805", "山东省临沂市",
"861310853", "云南省昆明市",
"861893415", "广东省东莞市",
"861331443", "贵州省遵义市",
"861364696", "福建省南平市",
"861508228", "四川省凉山彝族自治州",
"861778571", "贵州省毕节地区",
"86159678", "浙江省宁波市",
"86136969", "福建省厦门市",
"861800469", "黑龙江省双鸭山市",
"861510941", "甘肃省甘南藏族自治州",
"861806844", "江苏省苏州市",
"861760908", "新疆克孜勒苏柯尔克孜自治州",
"861522077", "广东省江门市",
"861858913", "西藏山南地区",
"861568123", "四川省绵阳市",
"861827091", "江西省南昌市",
"861773238", "河北省承德市",
"86170975", "广东省东莞市",
"86182491", "黑龙江省哈尔滨市",
"861524214", "辽宁省鞍山市",
"861808398", "新疆巴音郭楞蒙古自治州",
"861577507", "广东省湛江市",
"861355078", "四川省遂宁市",
"861362534", "山东省德州市",
"861870792", "江西省九江市",
"861575109", "江苏省宿迁市",
"861538971", "内蒙古呼和浩特市",
"861367341", "河南省周口市",
"861869778", "河南省开封市",
"86139416", "辽宁省锦州市",
"861568773", "云南省玉溪市",
"861872451", "黑龙江省哈尔滨市",
"86156134", "河北省唐山市",
"861850258", "江苏省常州市",
"861598408", "四川省广元市",
"861322675", "广东省汕尾市",
"861800495", "辽宁省丹东市",
"861329062", "河北省保定市",
"86183665", "山东省潍坊市",
"861335475", "内蒙古通辽市",
"861339621", "山东省菏泽市",
"861804813", "四川省乐山市",
"86131325", "天津市",
"861594994", "山东省枣庄市",
"861327392", "河南省鹤壁市",
"861453222", "浙江省宁波市",
"86183368", "河南省焦作市",
"861831241", "广东省广州市",
"861867042", "湖南省常德市",
"861894731", "内蒙古乌海市",
"861335561", "安徽省淮北市",
"86150866", "重庆市",
"861771197", "西藏日喀则地区",
"861361787", "广西南宁市",
"861510487", "内蒙古呼伦贝尔市",
"861505681", "安徽省铜陵市",
"861520573", "浙江省嘉兴市",
"861700313", "河北省保定市",
"86180645", "福建省漳州市",
"861854691", "黑龙江省黑河市",
"861309421", "湖北省荆州市",
"861883040", "河北省承德市",
"861337944", "陕西省渭南市",
"861347508", "山东省滨州市",
"861340570", "江苏省南通市",
"861880468", "黑龙江省鹤岗市",
"861809931", "新疆塔城地区",
"861370089", "河南省许昌市",
"861351935", "甘肃省武威市",
"861452719", "湖北省十堰市",
"86188576", "浙江省台州市",
"861770368", "黑龙江省鹤岗市",
"861599467", "广西桂林市",
"861320564", "安徽省六安市",
"86152615", "江苏省无锡市",
"86135960", "吉林省长春市",
"861872409", "江苏省扬州市",
"861585460", "山东省东营市",
"861764528", "黑龙江省双鸭山市",
"861338716", "湖北省咸宁市",
"86187961", "江苏省南通市",
"861399587", "湖北省孝感市",
"86152318", "河北省邯郸市",
"861829785", "安徽省合肥市",
"861508041", "福建省泉州市",
"861866448", "广东省汕头市",
"861309330", "安徽省滁州市",
"861529824", "四川省南充市",
"86159432", "吉林省吉林市",
"861372253", "河北省唐山市",
"86136883", "四川省成都市",
"861362688", "浙江省绍兴市",
"861855514", "安徽省滁州市",
"861351357", "山西省临汾市",
"861890675", "浙江省绍兴市",
"861302754", "河南省洛阳市",
"861530140", "江苏省淮安市",
"861522919", "陕西省铜川市",
"861470530", "山东省菏泽市",
"861853457", "山西省太原市",
"861764536", "黑龙江省鸡西市",
"861330709", "江西省南昌市",
"861591632", "广东省珠海市",
"861597566", "广东省阳江市",
"861880955", "宁夏中卫市",
"86189886", "广东省佛山市",
"861569411", "辽宁省大连市",
"861860549", "山东省临沂市",
"861770437", "吉林省辽源市",
"861589215", "福建省南平市",
"861316972", "广东省佛山市",
"861366946", "广西桂林市",
"861525648", "安徽省阜阳市",
"861577462", "黑龙江省齐齐哈尔市",
"861350984", "广东省东莞市",
"861569927", "新疆巴音郭楞蒙古自治州",
"861500722", "湖北省武汉市",
"861880910", "陕西省咸阳市",
"861320848", "黑龙江省大庆市",
"861450280", "内蒙古鄂尔多斯市",
"86183427", "辽宁省盘锦市",
"861534974", "青海省西宁市",
"861820640", "山东省菏泽市",
"861339949", "甘肃省白银市",
"861341589", "广东省东莞市",
"861845843", "浙江省杭州市",
"861839867", "四川省成都市",
"861476841", "山东省临沂市",
"861334963", "湖南省湘西土家族苗族自治州",
"861880337", "河北省沧州市",
"861351748", "湖南省长沙市",
"861576068", "四川省达州市",
"861380311", "河北省石家庄市",
"86170062", "江苏省无锡市",
"861760579", "浙江省金华市",
"861840358", "山西省吕梁市",
"861835148", "江苏省盐城市",
"861528088", "福建省泉州市",
"861507799", "安徽省淮北市",
"861830386", "河南省开封市",
"861814532", "黑龙江省齐齐哈尔市",
"86130138", "江苏省苏州市",
"861820472", "内蒙古包头市",
"861459370", "贵州省铜仁地区",
"861780269", "江苏省盐城市",
"861858752", "广西柳州市",
"861380966", "广东省惠州市",
"86131893", "广东省肇庆市",
"86180602", "福建省漳州市",
"861834445", "广东省韶关市",
"861760509", "福建省厦门市",
"861324308", "河南省洛阳市",
"861768644", "山东省青岛市",
"861369668", "安徽省阜阳市",
"861850441", "吉林省长春市",
"861366453", "黑龙江省牡丹江市",
"861878636", "贵州省黔南布依族苗族自治州",
"861478645", "湖南省衡阳市",
"861459300", "四川省自贡市",
"861539920", "陕西省铜川市",
"861334736", "湖南省常德市",
"861391246", "江苏省无锡市",
"861564359", "吉林省吉林市",
"861365528", "江苏省镇江市",
"861804645", "福建省泉州市",
"861560147", "江苏省南通市",
"86184899", "海南省海口市",
"861318749", "云南省怒江傈僳族自治州",
"861570354", "山西省晋中市",
"861772617", "湖南省益阳市",
"861339291", "广东省中山市",
"861393432", "山西省晋城市",
"86135384", "广东省东莞市",
"861457011", "山东省临沂市",
"861363483", "黑龙江省齐齐哈尔市",
"86145499", "广东省深圳市",
"861369816", "四川省泸州市",
"861893922", "河南省南阳市",
"861380733", "湖南省株洲市",
"86189462", "黑龙江省齐齐哈尔市",
"86153635", "广东省珠海市",
"861454569", "四川省泸州市",
"861317521", "浙江省湖州市",
"861477096", "江西省上饶市",
"861479911", "新疆喀什地区",
"861389517", "宁夏银川市",
"861358697", "浙江省金华市",
"86183420", "辽宁省大连市",
"861454324", "内蒙古乌海市",
"861534904", "甘肃省陇南市",
"861327840", "吉林省四平市",
"861323635", "江苏省镇江市",
"861459543", "青海省黄南藏族自治州",
"86151152", "湖南省怀化市",
"86147436", "广东省广州市",
"861773761", "河南省郑州市",
"861576746", "广东省惠州市",
"861708387", "河南省鹤壁市",
"861518413", "辽宁省铁岭市",
"861805381", "山东省泰安市",
"861530395", "河南省漯河市",
"861576925", "陕西省安康市",
"861537148", "江苏省苏州市",
"861771718", "河北省石家庄市",
"861470887", "云南省迪庆藏族自治州",
"861453353", "辽宁省大连市",
"861363574", "湖北省恩施土家族苗族自治州",
"861322082", "山东省威海市",
"861379727", "湖北省荆州市",
"861502521", "云南省红河哈尼族彝族自治州",
"861330779", "广西北海市",
"861806969", "浙江省嘉兴市",
"861822063", "陕西省渭南市",
"861882836", "四川省乐山市",
"861572899", "西藏拉萨市",
"86150482", "内蒙古兴安盟",
"861331780", "广西南宁市",
"861520340", "山西省太原市",
"861335153", "吉林省通化市",
"861580637", "山东省枣庄市",
"861340343", "山西省太原市",
"861586624", "山东省枣庄市",
"861375574", "江西省上饶市",
"861558525", "贵州省黔东南苗族侗族自治州",
"861890980", "辽宁省鞍山市",
"861787662", "广东省阳江市",
"861500486", "内蒙古赤峰市",
"861807077", "广西钦州市",
"861584683", "黑龙江省双鸭山市",
"86151109", "青海省西宁市",
"861380035", "山西省忻州市",
"861853027", "河南省商丘市",
"861773084", "河南省信阳市",
"861319361", "河南省周口市",
"861335886", "辽宁省沈阳市",
"861532251", "广东省湛江市",
"861538959", "陕西省榆林市",
"861317091", "江西省南昌市",
"86133524", "辽宁省沈阳市",
"861779090", "辽宁省大连市",
"861319916", "黑龙江省鸡西市",
"861868767", "云南省文山壮族苗族自治州",
"861882349", "广东省佛山市",
"861354676", "山西省忻州市",
"861337895", "湖南省怀化市",
"86183156", "山东省临沂市",
"861300566", "广东省茂名市",
"861397172", "湖北省黄冈市",
"861378820", "广西防城港市",
"861530686", "浙江省台州市",
"86137819", "河南省新乡市",
"86135967", "吉林省白山市",
"861820853", "贵州省安顺市",
"861475783", "浙江省台州市",
"861768516", "贵州省铜仁地区",
"861831999", "广东省深圳市",
"86170029", "陕西省西安市",
"861590375", "河南省平顶山市",
"861570912", "陕西省榆林市",
"861362511", "江苏省常州市",
"861334728", "湖南省娄底市",
"861800555", "安徽省马鞍山市",
"861350639", "山东省青岛市",
"861390799", "江西省萍乡市",
"861347578", "山东省济宁市",
"861824490", "广东省广州市",
"861388240", "四川省巴中市",
"861707047", "浙江省衢州市",
"86152479", "内蒙古锡林郭勒盟",
"861365536", "山东省潍坊市",
"861862537", "河南省平顶山市",
"861555346", "山东省聊城市",
"861595988", "福建省泉州市",
"861529796", "江西省吉安市",
"861819960", "新疆阿勒泰地区",
"861800510", "江苏省盐城市",
"861598470", "四川省阿坝藏族羌族自治州",
"861521983", "广东省韶关市",
"861329025", "山东省聊城市",
"861309572", "浙江省湖州市",
"861770149", "江苏省常州市",
"861352568", "河南省南阳市",
"861886960", "云南省昭通市",
"86152820", "四川省广元市",
"861828904", "西藏林芝地区",
"861891343", "江苏省镇江市",
"861550531", "山东省济南市",
"861360341", "河南省南阳市",
"861708593", "福建省福州市",
"861341980", "河南省三门峡市",
"861339540", "山东省菏泽市",
"861534535", "山东省烟台市",
"861333315", "河北省唐山市",
"861554203", "辽宁省锦州市",
"86187913", "陕西省渭南市",
"861370275", "广东省佛山市",
"861870857", "贵州省毕节地区",
"861808145", "四川省广元市",
"861802340", "广东省中山市",
"861527169", "湖北省孝感市",
"861815299", "新疆喀什地区",
"861565948", "福建省泉州市",
"861782026", "广东省揭阳市",
"861820091", "广东省揭阳市",
"861326646", "广东省江门市",
"861767908", "江西省南昌市",
"861572656", "山东省烟台市",
"861760970", "青海省海北藏族自治州",
"861315573", "江西省九江市",
"861333350", "山西省忻州市",
"86189812", "四川省广元市",
"861598642", "广东省广州市",
"861314558", "安徽省阜阳市",
"861564885", "内蒙古巴彦淖尔市",
"861398698", "湖北省荆门市",
"861860940", "甘肃省兰州市",
"861364871", "云南省昆明市",
"861528445", "云南省玉溪市",
"86145707", "江苏省无锡市",
"861893598", "新疆喀什地区",
"861364230", "广东省广州市",
"861569245", "广东省深圳市",
"861339303", "河北省石家庄市",
"861470939", "甘肃省酒泉市",
"861354197", "四川省广元市",
"861458438", "河南省平顶山市",
"861340332", "河北省保定市",
"861818907", "西藏日喀则地区",
"861786219", "山东省菏泽市",
"861870729", "湖北省孝感市",
"861317853", "广东省佛山市",
"861379385", "山东省滨州市",
"861833951", "河南省新乡市",
"861317186", "河北省邯郸市",
"861805254", "江苏省常州市",
"861802503", "广东省清远市",
"86150595", "福建省泉州市",
"861502853", "河北省承德市",
"861589441", "云南省德宏傣族景颇族自治州",
"861565033", "山东省淄博市",
"861315484", "内蒙古赤峰市",
"86138030", "天津市",
"86184088", "云南省临沧市",
"861458426", "河南省新乡市",
"861510353", "山西省阳泉市",
"861363066", "吉林省延边朝鲜族自治州",
"861580798", "江西省景德镇市",
"861889188", "陕西省渭南市",
"861317402", "江苏省盐城市",
"861358945", "山东省东营市",
"861459532", "西藏日喀则地区",
"861346451", "辽宁省葫芦岛市",
"861329723", "湖北省黄石市",
"861301858", "广东省湛江市",
"861332429", "辽宁省葫芦岛市",
"861351574", "浙江省宁波市",
"861875753", "浙江省绍兴市",
"861477181", "湖北省咸宁市",
"861814370", "甘肃省天水市",
"861479282", "安徽省阜阳市",
"861538490", "新疆和田地区",
"861316517", "山东省济宁市",
"86138226", "广东省肇庆市",
"861500765", "广东省东莞市",
"861861597", "山东省烟台市",
"861310648", "浙江省台州市",
"86183879", "云南省普洱市",
"861809464", "浙江省嘉兴市",
"861379696", "黑龙江省黑河市",
"86137469", "黑龙江省佳木斯市",
"861302629", "江西省宜春市",
"861373992", "内蒙古包头市",
"861894260", "河北省邯郸市",
"861308478", "内蒙古巴彦淖尔市",
"861390254", "广东省茂名市",
"861573948", "新疆喀什地区",
"861571839", "广东省云浮市",
"861337751", "广东省韶关市",
"861881896", "广东省云浮市",
"861567841", "广西玉林市",
"861882973", "陕西省渭南市",
"86188587", "浙江省温州市",
"861314971", "辽宁省营口市",
"861820521", "江苏省徐州市",
"861351483", "内蒙古阿拉善盟",
"861887012", "江西省赣州市",
"861868807", "广东省汕尾市",
"861367953", "广东省清远市",
"86151203", "贵州省遵义市",
"861393443", "山西省忻州市",
"861709719", "广东省佛山市",
"861824959", "黑龙江省黑河市",
"861562447", "山东省日照市",
"86158549", "山东省临沂市",
"861859637", "山东省济宁市",
"861322988", "广东省珠海市",
"861380742", "湖南省常德市",
"861708872", "广东省江门市",
"861782038", "广东省肇庆市",
"86139921", "陕西省延安市",
"861329595", "福建省泉州市",
"861533858", "贵州省六盘水市",
"861568497", "湖南省永州市",
"861845832", "浙江省杭州市",
"861354718", "四川省广元市",
"861815629", "安徽省阜阳市",
"861470302", "河北省唐山市",
"86177739", "湖南省邵阳市",
"861848418", "贵州省安顺市",
"861529297", "新疆和田地区",
"861454418", "福建省漳州市",
"86134768", "湖北省武汉市",
"861708802", "四川省成都市",
"861509259", "山东省威海市",
"861819569", "青海省海南藏族自治州",
"86188580", "浙江省宁波市",
"861314901", "广东省清远市",
"86150416", "辽宁省锦州市",
"861800919", "陕西省铜川市",
"861536888", "云南省丽江市",
"861858191", "四川省自贡市",
"861509166", "陕西省榆林市",
"861778950", "甘肃省临夏回族自治州",
"861308408", "安徽省蚌埠市",
"861329455", "山西省长治市",
"861846506", "宁夏石嘴山市",
"861361325", "河北省唐山市",
"861890589", "浙江省金华市",
"861346591", "山东省济南市",
"861381230", "江苏省宿迁市",
"86158787", "广西南宁市",
"86130375", "河南省商丘市",
"861532440", "安徽省巢湖市",
"861884027", "陕西省宝鸡市",
"86136250", "福建省福州市",
"861814996", "新疆巴音郭楞蒙古自治州",
"861591643", "广东省阳江市",
"861329103", "江苏省徐州市",
"861566096", "河南省南阳市",
"861806560", "福建省泉州市",
"861358106", "山东省临沂市",
"861317640", "山东省济南市",
"861317472", "浙江省嘉兴市",
"861857987", "广西南宁市",
"86130678", "浙江省杭州市",
"861700260", "广东省东莞市",
"861576962", "宁夏石嘴山市",
"861367446", "吉林省白城市",
"861532672", "内蒙古包头市",
"861351504", "福建省泉州市",
"861538550", "安徽省滁州市",
"861352995", "云南省红河哈尼族彝族自治州",
"861810392", "河南省鹤壁市",
"861560439", "吉林省白山市",
"861311739", "湖南省邵阳市",
"861802573", "广东省潮州市",
"861329968", "广西玉林市",
"861825256", "江苏省扬州市",
"861363357", "山西省临汾市",
"861315340", "山东省威海市",
"861379226", "山东省滨州市",
"861356829", "四川省甘孜藏族自治州",
"861893458", "江苏省苏州市",
"861787625", "广东省肇庆市",
"861373144", "河北省承德市",
"861454960", "黑龙江省鸡西市",
"86137422", "辽宁省鞍山市",
"861558562", "吉林省松原市",
"861308991", "黑龙江省大兴安岭地区",
"861508220", "四川省乐山市",
"861873841", "河南省洛阳市",
"861458782", "湖南省永州市",
"861522495", "河南省周口市",
"861323812", "辽宁省辽阳市",
"861839707", "青海省海东地区",
"861332059", "云南省保山市",
"861366387", "河南省洛阳市",
"861369547", "山东省济宁市",
"861339373", "河南省郑州市",
"861559337", "甘肃省天水市",
"861815941", "福建省莆田市",
"861505469", "山东省菏泽市",
"861773230", "河北省石家庄市",
"861802484", "广东省清远市",
"861808390", "新疆石河子市",
"861802195", "江苏省连云港市",
"861570577", "浙江省温州市",
"861355070", "四川省宜宾市",
"86138928", "陕西省西安市",
"861344065", "安徽省安庆市",
"861580834", "四川省凉山彝族自治州",
"86186989", "辽宁省葫芦岛市",
"861363935", "甘肃省武威市",
"861592692", "湖北省咸宁市",
"861453487", "内蒙古呼伦贝尔市",
"861760900", "新疆乌鲁木齐市",
"86134538", "山西省吕梁市",
"861801843", "江苏省南通市",
"861830947", "甘肃省兰州市",
"861512187", "宁夏银川市",
"861808906", "西藏那曲地区",
"861309502", "新疆乌鲁木齐市",
"86180795", "江西省宜春市",
"861598400", "四川省泸州市",
"861305589", "福建省漳州市",
"861330869", "湖北省荆门市",
"861334237", "辽宁省盘锦市",
"861554273", "辽宁省鞍山市",
"861336444", "吉林省吉林市",
"861325265", "吉林省通化市",
"861760396", "河南省驻马店市",
"861581182", "广东省深圳市",
"86152827", "四川省巴中市",
"861869770", "河南省信阳市",
"86159003", "天津市",
"861862678", "吉林省白城市",
"861390900", "四川省自贡市",
"861500163", "新疆石河子市",
"861899577", "湖北省黄石市",
"861329775", "广西玉林市",
"861877893", "广西桂林市",
"861361540", "山东省菏泽市",
"861804341", "吉林省四平市",
"861342242", "广东省惠州市",
"86187903", "河南省驻马店市",
"861390396", "河南省驻马店市",
"86150160", "广东省惠州市",
"861577473", "内蒙古乌海市",
"861874036", "陕西省汉中市",
"861474045", "辽宁省葫芦岛市",
"861478341", "河南省安阳市",
"861888824", "山东省德州市",
"861323420", "辽宁省铁岭市",
"861764044", "辽宁省沈阳市",
"861332807", "江苏省南通市",
"861835806", "浙江省舟山市",
"861329125", "江苏省盐城市",
"861700841", "贵州省贵阳市",
"861875155", "江苏省无锡市",
"861377464", "福建省南平市",
"861807696", "西藏那曲地区",
"861321649", "浙江省台州市",
"861840580", "浙江省舟山市",
"861335891", "辽宁省盘锦市",
"861800871", "云南省昆明市",
"86135742", "湖南省株洲市",
"86181627", "湖北省武汉市",
"861882746", "湖北省黄冈市",
"861870079", "陕西省西安市",
"861776609", "江苏省南京市",
"861399740", "青海省海北藏族自治州",
"861594735", "内蒙古通辽市",
"86133367", "浙江省台州市",
"861530691", "福建省福州市",
"861565133", "江苏省南通市",
"861334972", "湖北省武汉市",
"861890301", "广东省广州市",
"861531245", "江苏省苏州市",
"861317752", "江西省上饶市",
"861893136", "河北省石家庄市",
"861861777", "河北省保定市",
"861317086", "江西省南昌市",
"86183857", "贵州省黔东南苗族侗族自治州",
"861375166", "广东省揭阳市",
"861550982", "辽宁省沈阳市",
"861580578", "浙江省丽水市",
"861320106", "新疆哈密地区",
"861837496", "湖南省长沙市",
"861354097", "四川省泸州市",
"861768236", "浙江省宁波市",
"861368939", "甘肃省陇南市",
"861323331", "山西省晋城市",
"861708075", "湖南省岳阳市",
"861502086", "山东省莱芜市",
"861820463", "黑龙江省牡丹江市",
"861560268", "广东省汕尾市",
"861351794", "江西省抚州市",
"861300174", "山东省济南市",
"861362870", "云南省昭通市",
"861576828", "广东省梅州市",
"86145717", "浙江省杭州市",
"86134076", "山东省临沂市",
"861868429", "吉林省四平市",
"861322359", "山西省运城市",
"861892261", "广东省清远市",
"86155938", "甘肃省天水市",
"861808743", "云南省昆明市",
"861330376", "河南省信阳市",
"86180137", "江苏省苏州市",
"861320482", "内蒙古兴安盟",
"861329073", "福建省福州市",
"861594948", "内蒙古包头市",
"861321921", "四川省遂宁市",
"86152281", "四川省南充市",
"861319665", "江苏省盐城市",
"861509748", "河北省石家庄市",
"861586479", "山东省济南市",
"861875852", "浙江省绍兴市",
"86159155", "广东省汕头市",
"861827224", "湖北省荆州市",
"86152792", "江西省九江市",
"861519067", "江苏省徐州市",
"861520562", "安徽省池州市",
"861477081", "江西省赣州市",
"861863403", "河北省唐山市",
"861366863", "山东省淄博市",
"861321417", "辽宁省营口市",
"861479769", "青海省海南藏族自治州",
"861595406", "山东省威海市",
"861576836", "广东省深圳市",
"861889088", "新疆昌吉回族自治州",
"861379469", "广东省韶关市",
"861853206", "河北省邯郸市",
"861773919", "河南省新乡市",
"861850974", "青海省海南藏族自治州",
"861566874", "辽宁省丹东市",
"861500908", "新疆阿克苏地区",
"861869450", "浙江省嘉兴市",
"86133428", "广东省广州市",
"861536433", "湖南省娄底市",
"861584529", "黑龙江省大庆市",
"861318346", "四川省自贡市",
"861889211", "陕西省延安市",
"861334846", "福建省漳州市",
"861368372", "河南省安阳市",
"861537942", "甘肃省白银市",
"861345337", "山西省运城市",
"861334339", "河北省承德市",
"861318839", "辽宁省丹东市",
"861311414", "云南省昆明市",
"861887112", "湖北省随州市",
"86130713", "广东省东莞市",
"861580951", "宁夏银川市",
"861309792", "广西贵港市",
"861591012", "山东省菏泽市",
"861390685", "浙江省绍兴市",
"861590671", "浙江省杭州市",
"861506633", "山东省日照市",
"86139369", "黑龙江省大庆市",
"861394992", "河南省商丘市",
"861305301", "安徽省宿州市",
"861787603", "广东省阳江市",
"86181465", "北京市",
"861874028", "辽宁省大连市",
"86135373", "广东省东莞市",
"861828215", "四川省攀枝花市",
"861813952", "新疆伊犁哈萨克自治州",
"861539199", "安徽省马鞍山市",
"861830789", "广西河池市",
"861374956", "河南省平顶山市",
"861774259", "湖南省邵阳市",
"86189254", "广东省东莞市",
"861869590", "河南省郑州市",
"861787673", "广东省汕头市",
"861877502", "广西梧州市",
"86137995", "福建省泉州市",
"861830391", "河南省焦作市",
"86182592", "福建省厦门市",
"861879187", "陕西省宝鸡市",
"861370914", "陕西省西安市",
"86159666", "山东省济南市",
"86176921", "河北省石家庄市",
"861570797", "江西省赣州市",
"861786930", "云南省楚雄彝族自治州",
"86147629", "江苏省南京市",
"861364919", "陕西省铜川市",
"861500978", "青海省西宁市",
"861351838", "四川省泸州市",
"861850904", "新疆和田地区",
"861866554", "广东省佛山市",
"861339325", "河北省唐山市",
"861895104", "江苏省扬州市",
"861815397", "甘肃省兰州市",
"861598750", "云南省保山市",
"861312396", "新疆喀什地区",
"861595476", "山东省泰安市",
"861805970", "福建省福州市",
"861863473", "山西省临汾市",
"86134131", "广东省惠州市",
"86133691", "陕西省渭南市",
"861330990", "新疆克拉玛依市",
"861812301", "四川省成都市",
"861829699", "江西省赣州市",
"861772037", "湖北省荆门市",
"861868059", "广东省中山市",
"861504641", "黑龙江省七台河市",
"861887643", "福建省厦门市",
"861333131", "河北省张家口市",
"861839457", "甘肃省甘南藏族自治州",
"861308347", "安徽省阜阳市",
"861585112", "江苏省盐城市",
"861330306", "河北省沧州市",
"861596041", "福建省泉州市",
"861534441", "湖南省长沙市",
"861563893", "河南省郑州市",
"861811233", "江苏省常州市",
"861320738", "湖南省娄底市",
"861301519", "内蒙古赤峰市",
"861586409", "山东省烟台市",
"861340811", "四川省绵阳市",
"861370693", "福建省宁德市",
"861332159", "吉林省白山市",
"861857749", "广西北海市",
"861880858", "贵州省六盘水市",
"861521620", "江西省宜春市",
"861577110", "湖北省襄樊市",
"86180686", "江苏省南通市",
"861825069", "福建省漳州市",
"861458269", "安徽省芜湖市",
"861320726", "湖北省十堰市",
"861776679", "四川省自贡市",
"861500551", "安徽省合肥市",
"861338319", "河北省邢台市",
"861373044", "河北省保定市",
"861320945", "甘肃省金昌市",
"861346771", "湖南省长沙市",
"861847588", "广东省茂名市",
"861350019", "广东省汕头市",
"86151435", "吉林省通化市",
"86183850", "贵州省遵义市",
"861890371", "河南省郑州市",
"861331547", "河北省石家庄市",
"861361373", "河南省新乡市",
"86133360", "浙江省杭州市",
"861332266", "广东省梅州市",
"861840837", "四川省阿坝藏族羌族自治州",
"861334902", "安徽省蚌埠市",
"861835267", "江苏省南通市",
"861370352", "山西省大同市",
"861897182", "湖北省咸宁市",
"861561529", "山东省临沂市",
"861348292", "河北省衡水市",
"861472789", "陕西省商洛市",
"86139322", "河北省保定市",
"861337565", "山东省枣庄市",
"861876649", "山东省滨州市",
"861524688", "黑龙江省双鸭山市",
"861332877", "福建省厦门市",
"861380615", "江苏省无锡市",
"861507685", "河北省衡水市",
"861355720", "广西柳州市",
"861535496", "内蒙古包头市",
"861572569", "山东省枣庄市",
"861353621", "广东省江门市",
"861894841", "广东省江门市",
"861862608", "江苏省无锡市",
"861390970", "青海省海北藏族自治州",
"861869020", "新疆哈密地区",
"861380650", "浙江省杭州市",
"861816445", "安徽省安庆市",
"861355170", "四川省资阳市",
"861537485", "内蒙古通辽市",
"861351826", "四川省德阳市",
"861360813", "四川省乐山市",
"861760799", "江西省萍乡市",
"861389736", "青海省西宁市",
"861822551", "安徽省合肥市",
"861450993", "新疆石河子市",
"861815474", "广西南宁市",
"86138473", "内蒙古乌海市",
"86159243", "浙江省宁波市",
"86152126", "安徽省淮北市",
"861821964", "甘肃省庆阳市",
"861760381", "河南省南阳市",
"861533955", "贵州省黔东南苗族侗族自治州",
"861889445", "甘肃省天水市",
"861893616", "江苏省南通市",
"861580744", "湖南省张家界市",
"861310694", "广东省揭阳市",
"861869241", "湖南省株洲市",
"861378412", "河北省廊坊市",
"861778666", "湖北省荆州市",
"861866307", "山东省滨州市",
"861590252", "贵州省遵义市",
"861366773", "广西桂林市",
"861858402", "四川省泸州市",
"861312579", "吉林省白山市",
"861339787", "广西柳州市",
"861564257", "辽宁省朝阳市",
"861334008", "江西省上饶市",
"861864881", "广西南宁市",
"861336971", "青海省西宁市",
"861478712", "云南省大理白族自治州",
"861570638", "山东省烟台市",
"861536985", "河北省衡水市",
"861557080", "湖南省娄底市",
"86157332", "河北省保定市",
"861322476", "内蒙古通辽市",
"86184530", "山东省菏泽市",
"861769830", "河南省安阳市",
"861330459", "黑龙江省大庆市",
"861882962", "陕西省榆林市",
"861311849", "四川省宜宾市",
"861313938", "甘肃省天水市",
"86147083", "四川省成都市",
"861581988", "广东省惠州市",
"861589904", "新疆巴音郭楞蒙古自治州",
"86188920", "陕西省西安市",
"861769271", "河北省邢台市",
"861533337", "河北省沧州市",
"861345519", "山东省德州市",
"861508141", "河北省石家庄市",
"861334517", "山东省济宁市",
"861302404", "安徽省芜湖市",
"861847131", "湖北省黄冈市",
"86187329", "河北省邢台市",
"86152308", "河北省石家庄市",
"861813428", "河北省石家庄市",
"86170833", "河北省唐山市",
"861520095", "湖南省永州市",
"861850535", "山东省烟台市",
"861300659", "山东省济南市",
"861517404", "辽宁省本溪市",
"861306228", "福建省南平市",
"86139878", "云南省楚雄彝族自治州",
"86137204", "陕西省西安市",
"861841970", "甘肃省兰州市",
"861320697", "黑龙江省佳木斯市",
"86152605", "福建省漳州市",
"861806342", "山东省济南市",
"861809582", "新疆喀什地区",
"861479157", "陕西省西安市",
"861583386", "河北省保定市",
"861539683", "江苏省徐州市",
"861335423", "辽宁省沈阳市",
"861343556", "广东省潮州市",
"861566677", "山东省济南市",
"861872759", "湖北省荆门市",
"861310913", "陕西省渭南市",
"861309563", "浙江省嘉兴市",
"861813436", "河北省唐山市",
"861826100", "江苏省苏州市",
"86184760", "广东省中山市",
"861454656", "云南省丽江市",
"861503668", "河南省商丘市",
"861304549", "黑龙江省大庆市",
"861313745", "河南省周口市",
"861319622", "吉林省吉林市",
"861835933", "福建省龙岩市",
"861840989", "新疆昌吉回族自治州",
"861329865", "湖南省长沙市",
"86151261", "云南省红河哈尼族彝族自治州",
"861531411", "山东省济南市",
"861333588", "浙江省杭州市",
"861881566", "安徽省池州市",
"861509483", "山东省日照市",
"861520525", "江苏省扬州市",
"861473649", "云南省昆明市",
"861887632", "福建省漳州市",
"86158068", "山东省德州市",
"86130761", "广东省河源市",
"861808488", "四川省绵阳市",
"861566081", "河南省安阳市",
"861368530", "山东省菏泽市",
"861782866", "四川省绵阳市",
"861336558", "安徽省阜阳市",
"861558340", "四川省成都市",
"861506113", "江苏省常州市",
"86186529", "江苏省南京市",
"861315562", "安徽省铜陵市",
"861565994", "福建省龙岩市",
"86138588", "浙江省温州市",
"861365717", "湖北省宜昌市",
"861814981", "新疆昌吉回族自治州",
"861811242", "江苏省徐州市",
"861475554", "安徽省马鞍山市",
"861361949", "云南省普洱市",
"861520793", "江西省上饶市",
"861800761", "广东省阳江市",
"86186258", "河南省安阳市",
"861843471", "山西省忻州市",
"861377931", "新疆巴音郭楞蒙古自治州",
"861896390", "湖北省恩施土家族苗族自治州",
"86156532", "山东省青岛市",
"861398644", "湖北省随州市",
"861835048", "福建省龙岩市",
"861477874", "广东省中山市",
"861566218", "吉林省延边朝鲜族自治州",
"86134671", "山西省临汾市",
"861893544", "山西省晋中市",
"861371720", "广东省肇庆市",
"861340790", "江西省新余市",
"861390509", "福建省南平市",
"861877421", "湖南省衡阳市",
"861781717", "广东省茂名市",
"861516535", "山东省烟台市",
"861338880", "云南省昆明市",
"861381510", "江苏省无锡市",
"861518070", "贵州省贵阳市",
"861509574", "甘肃省陇南市",
"86134087", "云南省曲靖市",
"861780782", "广西柳州市",
"86182485", "浙江省金华市",
"86152450", "黑龙江省哈尔滨市",
"86180670", "浙江省嘉兴市",
"861357907", "新疆喀什地区",
"861872827", "四川省资阳市",
"861829856", "甘肃省张掖市",
"861303411", "甘肃省天水市",
"861810730", "湖南省岳阳市",
"861571749", "湖南省长沙市",
"86871", "云南省昆明市",
"861709961", "浙江省舟山市",
"861373198", "安徽省马鞍山市",
"861802562", "广东省汕头市",
"861780438", "吉林省松原市",
"861457111", "湖北省武汉市",
"861513817", "河南省三门峡市",
"861338537", "山东省济宁市",
"861357977", "新疆石河子市",
"861537933", "甘肃省武威市",
"861536442", "湖南省湘西土家族苗族自治州",
"86152457", "黑龙江省大兴安岭地区",
"86134080", "四川省成都市",
"861843401", "山西省忻州市",
"861588327", "四川省内江市",
"861536670", "江苏省泰州市",
"861303927", "吉林省吉林市",
"861337092", "山东省烟台市",
"861360645", "山东省烟台市",
"861390579", "浙江省金华市",
"861339362", "广西来宾市",
"861347798", "湖北省十堰市",
"86180612", "江苏省南京市",
"861309151", "黑龙江省鹤岗市",
"861803437", "河北省沧州市",
"861889982", "广东省江门市",
"861331816", "广东省梅州市",
"861572960", "四川省南充市",
"861816211", "江西省南昌市",
"861477804", "广东省佛山市",
"861806890", "江苏省泰州市",
"861504520", "黑龙江省齐齐哈尔市",
"861590323", "河北省保定市",
"861322182", "浙江省杭州市",
"861320227", "广东省深圳市",
"86138871", "云南省曲靖市",
"861368887", "广东省广州市",
"861586067", "福建省宁德市",
"861808732", "云南省昆明市",
"861888297", "四川省甘孜藏族自治州",
"861324447", "吉林省辽源市",
"861597659", "广东省潮州市",
"86186732", "湖南省湘潭市",
"861537048", "江苏省南通市",
"861564988", "河南省漯河市",
"861593316", "河北省廊坊市",
"861379681", "黑龙江省哈尔滨市",
"861558484", "吉林省通化市",
"86152642", "山东省青岛市",
"861816088", "安徽省合肥市",
"861471713", "甘肃省酒泉市",
"861351166", "江苏省常州市",
"861336498", "新疆石河子市",
"861351259", "江苏省盐城市",
"861566607", "山东省济宁市",
"861379077", "广东省惠州市",
"861870338", "河北省衡水市",
"861575917", "福建省南平市",
"861831860", "广东省阳江市",
"861477196", "湖北省宜昌市",
"861519479", "河北省保定市",
"86137852", "河北省保定市",
"861386665", "安徽省芜湖市",
"86137809", "山东省烟台市",
"861841900", "甘肃省甘南藏族自治州",
"861767102", "湖北省武汉市",
"861596690", "山东省青岛市",
"861305293", "江苏省镇江市",
"861521541", "山东省济南市",
"861376964", "云南省文山壮族苗族自治州",
"861317191", "河北省保定市",
"861859951", "福建省南平市",
"861517474", "内蒙古乌海市",
"861301955", "内蒙古包头市",
"86135692", "河南省南阳市",
"861369780", "山东省临沂市",
"861476260", "江苏省宿迁市",
"86139581", "浙江省杭州市",
"861330599", "福建省南平市",
"861870467", "黑龙江省鸡西市",
"861565142", "江苏省南通市",
"86151119", "重庆市",
"861301910", "吉林省长春市",
"861589974", "广东省江门市",
"861807177", "湖北省襄樊市",
"861870326", "河北省廊坊市",
"861335053", "四川省眉山市",
"86184537", "山东省济宁市",
"861817894", "江西省宜春市",
"861572418", "广东省汕尾市",
"861515945", "福建省南平市",
"861515726", "浙江省台州市",
"861318987", "广东省江门市",
"861820752", "广东省惠州市",
"861820086", "广东省湛江市",
"861366703", "江西省上饶市",
"861301337", "云南省玉溪市",
"861836543", "江西省赣州市",
"861884867", "贵州省六盘水市",
"861519248", "山东省青岛市",
"861839383", "甘肃省天水市",
"861505107", "江苏省盐城市",
"861550088", "宁夏银川市",
"861573845", "河南省许昌市",
"861336901", "新疆塔城地区",
"86181231", "四川省凉山彝族自治州",
"861337522", "江苏省淮安市",
"861384949", "河南省漯河市",
"861780426", "辽宁省丹东市",
"861818243", "陕西省西安市",
"861538388", "河北省秦皇岛市",
"861364555", "安徽省马鞍山市",
"861334078", "四川省泸州市",
"861359350", "山西省临汾市",
"861815404", "安徽省安庆市",
"8618918", "上海市",
"861775788", "浙江省丽水市",
"861883395", "河北省唐山市",
"861801966", "江苏省南通市",
"861317463", "福建省宁德市",
"861364510", "江苏省盐城市",
"861558892", "山东省莱芜市",
"861532663", "黑龙江省鸡西市",
"861840634", "山东省莱芜市",
"861858640", "贵州省遵义市",
"861786539", "山东省临沂市",
"861330984", "辽宁省大连市",
"861568478", "山东省德州市",
"861839834", "四川省攀枝花市",
"861337232", "浙江省嘉兴市",
"861452654", "江西省抚州市",
"861519614", "四川省广元市",
"861880364", "河南省信阳市",
"861554974", "湖北省随州市",
"86156703", "河南省洛阳市",
"861860756", "广东省珠海市",
"861308557", "安徽省宿州市",
"86150184", "广东省广州市",
"861328599", "福建省泉州市",
"861803657", "江苏省连云港市",
"861880529", "江苏省镇江市",
"861708750", "江西省抚州市",
"861350709", "江西省南昌市",
"861853744", "河南省信阳市",
"861595940", "福建省莆田市",
"861569893", "辽宁省抚顺市",
"861780658", "广东省湛江市",
"861302447", "江苏省盐城市",
"861550140", "江苏省盐城市",
"86151065", "山东省烟台市",
"861576499", "内蒙古乌兰察布市",
"861478908", "西藏拉萨市",
"861450409", "辽宁省大连市",
"861707174", "江西省吉安市",
"86137395", "宁夏中卫市",
"86189811", "四川省绵阳市",
"861525146", "江苏省徐州市",
"861533199", "黑龙江省大庆市",
"861571669", "河南省新乡市",
"861331748", "湖南省长沙市",
"861782016", "广东省梅州市",
"861861508", "山东省潍坊市",
"861329050", "河北省邯郸市",
"861855148", "江苏省南通市",
"861887592", "广东省深圳市",
"861580707", "江西省赣州市",
"86132896", "陕西省延安市",
"861597439", "湖南省株洲市",
"861354963", "湖南省常德市",
"861333325", "河北省唐山市",
"86137698", "云南省曲靖市",
"861318496", "河北省衡水市",
"861776849", "江苏省盐城市",
"861359949", "福建省莆田市",
"86177316", "河北省廊坊市",
"861770464", "福建省泉州市",
"861329015", "山东省潍坊市",
"86150257", "重庆市",
"861357944", "新疆哈密地区",
"861390446", "吉林省延边朝鲜族自治州",
"861346335", "河北省秦皇岛市",
"861821202", "贵州省贵阳市",
"861331935", "江西省宜春市",
"86139922", "陕西省榆林市",
"861591772", "广东省东莞市",
"861504230", "辽宁省盘锦市",
"86185368", "山西省太原市",
"861309245", "江苏省连云港市",
"861378791", "湖南省湘西土家族苗族自治州",
"861505992", "福建省龙岩市",
"86135858", "上海市",
"861320537", "山东省济宁市",
"861319032", "辽宁省盘锦市",
"861890735", "湖南省郴州市",
"861831425", "云南省大理白族自治州",
"861893507", "山西省运城市",
"861820511", "江苏省盐城市",
"861591122", "云南省大理白族自治州",
"861519993", "新疆巴音郭楞蒙古自治州",
"861893281", "河北省衡水市",
"861323705", "江西省宜春市",
"861858760", "广西防城港市",
"861362853", "贵州省遵义市",
"86137823", "河南省许昌市",
"86155846", "吉林省延边朝鲜族自治州",
"861818998", "西藏日喀则地区",
"861568249", "四川省乐山市",
"861562941", "湖北省荆门市",
"861370542", "山东省青岛市",
"861816140", "四川省内江市",
"86185665", "广东省东莞市",
"86151454", "黑龙江省佳木斯市",
"861809149", "陕西省宝鸡市",
"861569572", "浙江省湖州市",
"861787843", "广西南宁市",
"861331357", "山西省临汾市",
"861519546", "江苏省徐州市",
"861304406", "山东省临沂市",
"861346957", "宁夏银川市",
"861310534", "山东省德州市",
"861500341", "山西省太原市",
"861316527", "山东省临沂市",
"861522090", "广东省中山市",
"861524191", "辽宁省本溪市",
"861840454", "黑龙江省佳木斯市",
"86184315", "河北省唐山市",
"861585803", "浙江省温州市",
"86158290", "陕西省西安市",
"86187775", "广西玉林市",
"86133960", "湖北省武汉市",
"861880099", "四川省巴中市",
"861570036", "四川省内江市",
"861334606", "浙江省丽水市",
"861329713", "湖北省荆门市",
"861305948", "广东省肇庆市",
"861332419", "辽宁省辽阳市",
"861360063", "浙江省绍兴市",
"861593179", "河北省保定市",
"861376272", "湖南省益阳市",
"861577450", "黑龙江省哈尔滨市",
"861843243", "河北省邯郸市",
"861334676", "河南省信阳市",
"861550686", "广西百色市",
"86189413", "辽宁省抚顺市",
"861567187", "湖北省恩施土家族苗族自治州",
"861856212", "山东省德州市",
"861566644", "山东省济南市",
"861812033", "湖北省黄冈市",
"861570458", "黑龙江省伊春市",
"861593109", "河北省石家庄市",
"861304476", "河南省安阳市",
"861380673", "浙江省嘉兴市",
"861355153", "四川省内江市",
"861862564", "河南省濮阳市",
"861590841", "四川省资阳市",
"86159265", "湖北省荆州市",
"861869852", "浙江省嘉兴市",
"861569502", "宁夏石嘴山市",
"861528040", "福建省福州市",
"86158297", "陕西省西安市",
"861324404", "吉林省吉林市",
"861390953", "宁夏吴忠市",
"861351780", "广西柳州市",
"861857481", "湖南省娄底市",
"861771237", "江苏省无锡市",
"861535346", "陕西省咸阳市",
"861361315", "河北省唐山市",
"861477847", "广东省中山市",
"861323775", "广西贵港市",
"861537514", "安徽省巢湖市",
"861538793", "江西省上饶市",
"861893577", "新疆伊犁哈萨克自治州",
"861354178", "四川省巴中市",
"861839798", "江西省景德镇市",
"861705182", "上海市",
"861591702", "广东省佛山市",
"861330639", "山东省青岛市",
"861306526", "辽宁省盘锦市",
"861454428", "江苏省泰州市",
"861450248", "河北省石家庄市",
"86188818", "四川省达州市",
"861320880", "云南省昆明市",
"861361350", "山西省忻州市",
"861329420", "湖北省荆州市",
"861596530", "山东省菏泽市",
"861778925", "陕西省商洛市",
"861598075", "福建省厦门市",
"861314407", "广东省揭阳市",
"86187303", "河北省张家口市",
"861354728", "四川省资阳市",
"861509547", "甘肃省定西市",
"86139506", "福建省南平市",
"861525905", "福建省宁德市",
"861336169", "江西省上饶市",
"861453981", "广东省深圳市",
"861537646", "山东省潍坊市",
"861869155", "陕西省西安市",
"86156375", "河南省平顶山市",
"861580777", "广西钦州市",
"86186503", "福建省福州市",
"86180285", "广东省广州市",
"86150250", "云南省保山市",
"861362472", "内蒙古包头市",
"861800641", "山东省济南市",
"861815447", "湖北省黄冈市",
"861312446", "福建省泉州市",
"861863450", "山西省忻州市",
"861359291", "广东省揭阳市",
"86131750", "浙江省杭州市",
"861347383", "河北省衡水市",
"861354736", "四川省泸州市",
"861362640", "山东省济南市",
"861813656", "江苏省连云港市",
"861303792", "宁夏吴忠市",
"861306538", "辽宁省辽阳市",
"861454436", "江苏省镇江市",
"861348745", "湖南省怀化市",
"861863415", "河北省唐山市",
"861570965", "宁夏中卫市",
"8613880", "四川省成都市",
"861323822", "辽宁省辽阳市",
"861321157", "广西贵港市",
"861818565", "贵州省遵义市",
"861787650", "广东省佛山市",
"861308497", "广西钦州市",
"861328459", "黑龙江省大庆市",
"861350779", "广西北海市",
"861301199", "河北省沧州市",
"861566516", "江苏省徐州市",
"861331066", "山东省青岛市",
"861534391", "河南省焦作市",
"861508210", "四川省资阳市",
"861518891", "河北省邯郸市",
"861825444", "山东省临沂市",
"861862848", "陕西省咸阳市",
"861550395", "河南省漯河市",
"861557148", "湖北省黄石市",
"861476305", "山东省滨州市",
"861577020", "云南省怒江傈僳族自治州",
"86136416", "上海市",
"861338697", "福建省漳州市",
"861356819", "四川省达州市",
"861379216", "山东省淄博市",
"861787615", "广东省江门市",
"861598773", "云南省玉溪市",
"861874797", "内蒙古呼和浩特市",
"86159134", "广东省中山市",
"861373469", "青海省海西蒙古族藏族自治州",
"86137421", "广东省广州市",
"861700671", "浙江省温州市",
"861883088", "河北省邯郸市",
"861322549", "山东省临沂市",
"86155635", "山东省聊城市",
"861529208", "湖南省益阳市",
"861869403", "湖北省恩施土家族苗族自治州",
"861899778", "新疆阿勒泰地区",
"86187556", "安徽省安庆市",
"86185879", "广西南宁市",
"86139353", "山西省阳泉市",
"86159431", "吉林省长春市",
"861529814", "四川省达州市",
"86189863", "湖北省襄樊市",
"861855524", "安徽省宣城市",
"861775201", "甘肃省定西市",
"861394859", "内蒙古乌兰察布市",
"861771963", "陕西省榆林市",
"861813899", "广东省江门市",
"861452179", "吉林省白山市",
"861338945", "甘肃省金昌市",
"861367381", "河南省许昌市",
"861320319", "湖南省娄底市",
"86132565", "山东省临沂市",
"861338726", "湖北省宜昌市",
"86187962", "江苏省徐州市",
"861452729", "湖北省武汉市",
"861373077", "四川省内江市",
"861367799", "江西省萍乡市",
"86156138", "河北省唐山市",
"861301683", "江苏省镇江市",
"861582911", "陕西省延安市",
"861452857", "甘肃省兰州市",
"861332844", "福建省漳州市",
"861471705", "甘肃省兰州市",
"861310146", "福建省泉州市",
"861535987", "福建省厦门市",
"861803854", "广东省河源市",
"861478072", "四川省泸州市",
"861700323", "河北省保定市",
"861309411", "湖北省襄樊市",
"861331483", "内蒙古呼伦贝尔市",
"86188468", "黑龙江省鹤岗市",
"861458334", "江西省上饶市",
"861809437", "江苏省南通市",
"86155175", "河南省郑州市",
"861506946", "山东省枣庄市",
"861804072", "新疆伊犁哈萨克自治州",
"861806884", "江苏省南京市",
"861360722", "湖北省武汉市",
"861309927", "甘肃省白银市",
"86159674", "浙江省温州市",
"861339611", "湖北省襄樊市",
"861772297", "广东省揭阳市",
"86152206", "广东省惠州市",
"861867605", "广东省东莞市",
"861317688", "山东省青岛市",
"861781681", "浙江省温州市",
"861580206", "广东省汕头市",
"861335000", "四川省绵阳市",
"861513248", "河北省石家庄市",
"861863999", "河南省漯河市",
"861833383", "河北省衡水市",
"861824095", "新疆阿克苏地区",
"861508363", "江西省新余市",
"861473809", "河南省周口市",
"861380321", "河北省石家庄市",
"861807098", "广西玉林市",
"861705359", "山东省济南市",
"861811523", "江苏省泰州市",
"861530531", "山东省济南市",
"861356380", "山东省泰安市",
"861364345", "山西省太原市",
"861554535", "黑龙江省双鸭山市",
"86150883", "浙江省湖州市",
"86134607", "河南省开封市",
"861332568", "新疆克拉玛依市",
"861889395", "甘肃省武威市",
"861841953", "甘肃省平凉市",
"861517139", "湖北省十堰市",
"861328990", "新疆克拉玛依市",
"861369794", "江西省抚州市",
"861811795", "四川省泸州市",
"861589225", "四川省广元市",
"861806492", "四川省广元市",
"861812042", "湖北省武汉市",
"861776414", "湖北省荆州市",
"861348032", "广东省揭阳市",
"86136866", "广东省东莞市",
"861328306", "河南省平顶山市",
"86132735", "河北省唐山市",
"861345199", "江苏省苏州市",
"861365681", "浙江省杭州市",
"861501787", "广东省东莞市",
"861569421", "辽宁省朝阳市",
"861313292", "广西柳州市",
"86186356", "山西省晋城市",
"861596302", "山东省菏泽市",
"861874638", "黑龙江省哈尔滨市",
"861308374", "河南省许昌市",
"861504084", "辽宁省抚顺市",
"861338738", "湖南省娄底市",
"861770931", "甘肃省兰州市",
"861856981", "河南省信阳市",
"861560881", "云南省西双版纳傣族自治州",
"86188327", "河北省沧州市",
"861860257", "江苏省常州市",
"861817880", "广西柳州市",
"861360875", "云南省文山壮族苗族自治州",
"861476187", "江苏省南京市",
"861859707", "青海省海西蒙古族藏族自治州",
"861580867", "云南省红河哈尼族彝族自治州",
"861874296", "新疆乌鲁木齐市",
"861338482", "内蒙古兴安盟",
"86152908", "河南省郑州市",
"861328376", "河南省信阳市",
"861347457", "陕西省延安市",
"861539337", "甘肃省酒泉市",
"861882666", "广东省佛山市",
"86188320", "河北省邯郸市",
"861898721", "云南省大理白族自治州",
"861518423", "辽宁省朝阳市",
"861810888", "云南省丽江市",
"861321769", "广东省东莞市",
"861576915", "陕西省安康市",
"861308304", "安徽省池州市",
"861586546", "山东省东营市",
"861454314", "黑龙江省七台河市",
"86151151", "湖南省怀化市",
"861471822", "广东省湛江市",
"86158438", "吉林省松原市",
"861771178", "湖南省长沙市",
"861538562", "安徽省铜陵市",
"861576950", "宁夏银川市",
"861535258", "新疆喀什地区",
"861843232", "河北省保定市",
"861505536", "安徽省宿州市",
"861317511", "浙江省杭州市",
"861387438", "湖南省永州市",
"861479921", "新疆阿克苏地区",
"861815139", "江苏省盐城市",
"86136482", "重庆市",
"861534273", "湖北省武汉市",
"861457021", "江西省南昌市",
"861350869", "湖北省孝感市",
"861582057", "广东省珠海市",
"861883445", "山西省运城市",
"861586993", "湖南省怀化市",
"861369826", "四川省凉山彝族自治州",
"861314069", "河南省驻马店市",
"861893912", "河南省许昌市",
"86189461", "黑龙江省哈尔滨市",
"861895147", "江苏省淮安市",
"861392146", "江苏省南通市",
"861365518", "江苏省南京市",
"861555669", "安徽省马鞍山市",
"861319043", "辽宁省锦州市",
"861889140", "陕西省咸阳市",
"86134600", "河南省周口市",
"861850947", "甘肃省嘉峪关市",
"861336757", "广西贵港市",
"861391454", "江苏省泰州市",
"861360486", "黑龙江省佳木斯市",
"861539910", "陕西省咸阳市",
"861592981", "陕西省延安市",
"861310680", "广东省珠海市",
"861768538", "贵州省黔南布依族苗族自治州",
"861372312", "河南省信阳市",
"861315235", "陕西省渭南市",
"861333787", "江苏省连云港市",
"861899868", "广东省阳江市",
"861897549", "湖南省邵阳市",
"861560566", "安徽省池州市",
"86180601", "福建省三明市",
"861800090", "广东省茂名市",
"861335070", "四川省眉山市",
"861370533", "山东省淄博市",
"86157756", "四川省达州市",
"861896384", "新疆阿克苏地区",
"861878866", "贵州省安顺市",
"861559099", "黑龙江省绥化市",
"861899544", "宁夏固原市",
"861800520", "江苏省徐州市",
"861875241", "江苏省淮安市",
"861860988", "辽宁省沈阳市",
"861310905", "新疆伊犁哈萨克自治州",
"861369838", "四川省乐山市",
"861523506", "山西省朔州市",
"861344012", "四川省乐山市",
"86137748", "福建省泉州市",
"861596939", "云南省丽江市",
"861381345", "江苏省徐州市",
"861878618", "贵州省遵义市",
"86147778", "广西玉林市",
"861536392", "广东省茂名市",
"861829539", "宁夏银川市",
"861571481", "内蒙古呼和浩特市",
"861768526", "贵州省黔南布依族苗族自治州",
"861362521", "江苏省扬州市",
"861334718", "内蒙古包头市",
"861570922", "陕西省榆林市",
"861319926", "黑龙江省伊春市",
"861339588", "浙江省丽水市",
"861341948", "四川省内江市",
"861336348", "山西省运城市",
"861323865", "云南省保山市",
"861558550", "吉林省白城市",
"861454952", "江苏省无锡市",
"86131492", "陕西省西安市",
"861332995", "湖北省黄冈市",
"861885821", "浙江省宁波市",
"861513409", "辽宁省辽阳市",
"861313622", "浙江省嘉兴市",
"861378810", "广西防城港市",
"861319745", "湖北省武汉市",
"861337243", "浙江省嘉兴市",
"861861744", "河北省沧州市",
"861853017", "河南省焦作市",
"86181443", "四川省成都市",
"861528691", "河南省濮阳市",
"861533683", "浙江省舟山市",
"861300147", "河北省衡水市",
"861775271", "湖南省益阳市",
"861304359", "福建省龙岩市",
"861378855", "广西玉林市",
"861539468", "江苏省盐城市",
"861324397", "辽宁省葫芦岛市",
"86133715", "山东省东营市",
"861452109", "河北省邢台市",
"861565980", "福建省厦门市",
"861317760", "江西省吉安市",
"861811461", "江苏省苏州市",
"861591763", "广东省清远市",
"86183266", "安徽省合肥市",
"861453543", "江苏省泰州市",
"861524640", "黑龙江省七台河市",
"861329635", "山东省聊城市",
"861824892", "江苏省淮安市",
"861373177", "河北省秦皇岛市",
"861819158", "陕西省西安市",
"861306218", "福建省宁德市",
"861888617", "贵州省安顺市",
"861862738", "湖南省娄底市",
"861539239", "福建省南平市",
"86187697", "山东省济南市",
"861347127", "广西桂林市",
"86180246", "广东省东莞市",
"861334527", "山东省泰安市",
"861388631", "湖北省鄂州市",
"86151824", "四川省绵阳市",
"861818944", "甘肃省白银市",
"861883531", "山西省阳泉市",
"861811575", "江苏省无锡市",
"861459353", "贵州省遵义市",
"861813418", "河北省沧州市",
"861366400", "内蒙古通辽市",
"861347777", "湖北省咸宁市",
"861846208", "山东省淄博市",
"861350376", "河南省信阳市",
"861345364", "山西省晋城市",
"861510532", "山东省青岛市",
"861534386", "河南省商丘市",
"861315959", "吉林省白城市",
"861471968", "甘肃省庆阳市",
"86181758", "湖南省衡阳市",
"861338076", "广东省肇庆市",
"86147613", "江苏省连云港市",
"861888278", "四川省巴中市",
"861325370", "河南省许昌市",
"861478722", "云南省大理白族自治州",
"861832041", "广东省广州市",
"86157331", "河北省石家庄市",
"86137453", "黑龙江省牡丹江市",
"861569563", "安徽省宣城市",
"861354339", "广东省茂名市",
"861303051", "江西省景德镇市",
"861570544", "山东省潍坊市",
"861589273", "四川省眉山市",
"861336477", "新疆乌鲁木齐市",
"861363816", "贵州省毕节地区",
"861354846", "四川省广元市",
"861459692", "新疆吐鲁番地区",
"86132190", "四川省成都市",
"861369483", "江西省上饶市",
"861310046", "广西百色市",
"861379098", "广东省湛江市",
"86156761", "广西南宁市",
"861557942", "江西省上饶市",
"861847540", "广东省阳江市",
"86153027", "广东省深圳市",
"861830974", "青海省西宁市",
"861328283", "浙江省杭州市",
"861360823", "四川省成都市",
"861376889", "广西柳州市",
"861348835", "陕西省西安市",
"861598387", "四川省达州市",
"861361611", "江苏省常州市",
"86135428", "广东省汕头市",
"861890613", "江苏省苏州市",
"861761454", "黑龙江省佳木斯市",
"861876282", "江苏省常州市",
"861517039", "江西省上饶市",
"86134617", "河南省濮阳市",
"861327670", "浙江省宁波市",
"861477737", "广西百色市",
"861872817", "四川省雅安市",
"861570616", "江苏省常州市",
"861471455", "广东省深圳市",
"861381520", "江苏省南通市",
"861357401", "湖南省岳阳市",
"861389718", "青海省西宁市",
"86156531", "山东省聊城市",
"861800345", "山西省长治市",
"861807198", "湖北省武汉市",
"861566228", "吉林省延边朝鲜族自治州",
"86134672", "山西省运城市",
"861371710", "广东省深圳市",
"861877411", "湖南省岳阳市",
"861335100", "黑龙江省哈尔滨市",
"861781727", "广东省茂名市",
"861570868", "贵州省六盘水市",
"861365859", "贵州省黔西南布依族苗族自治州",
"861770582", "浙江省湖州市",
"861398538", "贵州省六盘水市",
"861302039", "辽宁省铁岭市",
"861893638", "江苏省淮安市",
"861393830", "河南省濮阳市",
"861531917", "陕西省宝鸡市",
"861500813", "四川省自贡市",
"861331794", "江西省抚州市",
"861501621", "广东省河源市",
"861593285", "江西省萍乡市",
"861450624", "黑龙江省齐齐哈尔市",
"861890994", "新疆昌吉回族自治州",
"86159029", "陕西省西安市",
"86147066", "广东省广州市",
"861334097", "四川省凉山彝族自治州",
"86130762", "广东省韶关市",
"861340553", "江苏省泰州市",
"861550691", "福建省福州市",
"861319612", "吉林省松原市",
"86185857", "贵州省遵义市",
"86183793", "江西省上饶市",
"861590731", "湖南省长沙市",
"861810433", "吉林省延边朝鲜族自治州",
"861572058", "安徽省阜阳市",
"86151262", "云南省红河哈尼族彝族自治州",
"861557876", "广西河池市",
"861534695", "甘肃省武威市",
"861313916", "青海省玉树藏族自治州",
"861530982", "辽宁省大连市",
"861355891", "四川省自贡市",
"861804875", "四川省凉山彝族自治州",
"861335413", "辽宁省抚顺市",
"861313361", "江西省上饶市",
"86138810", "四川省德阳市",
"861820800", "西藏拉萨市",
"861520550", "安徽省滁州市",
"861779084", "辽宁省大连市",
"86187361", "河南省周口市",
"86185850", "贵州省贵阳市",
"86155885", "山东省泰安市",
"861506703", "浙江省衢州市",
"861557806", "广西崇左市",
"86137851", "河北省石家庄市",
"861351547", "山东省济宁市",
"861354902", "西藏日喀则地区",
"86135360", "广东省江门市",
"861473057", "河北省衡水市",
"86138817", "四川省成都市",
"861396557", "安徽省阜阳市",
"861527558", "山东省临沂市",
"861321282", "黑龙江省齐齐哈尔市",
"861324941", "广东省佛山市",
"861572436", "辽宁省盘锦市",
"861362463", "黑龙江省牡丹江市",
"861330019", "上海市",
"861804805", "四川省成都市",
"861871933", "广东省韶关市",
"86186731", "湖南省长沙市",
"861593326", "河北省廊坊市",
"86152641", "山东省济南市",
"861582879", "四川省凉山彝族自治州",
"861842054", "广东省茂名市",
"861303330", "云南省文山壮族苗族自治州",
"861524186", "辽宁省阜新市",
"861590313", "河北省张家口市",
"861340493", "云南省文山壮族苗族自治州",
"861768804", "广东省东莞市",
"86177553", "安徽省芜湖市",
"861898687", "湖北省十堰市",
"86138872", "云南省大理白族自治州",
"861700305", "广东省佛山市",
"86152918", "陕西省西安市",
"861476087", "江苏省常州市",
"861335170", "黑龙江省哈尔滨市",
"861372200", "内蒙古呼伦贝尔市",
"861471595", "广东省汕头市",
"861357471", "湖南省益阳市",
"861331826", "广东省中山市",
"861386132", "江苏省苏州市",
"861893296", "河北省邢台市",
"861816221", "江西省宜春市",
"861890845", "湖南省长沙市",
"861880683", "浙江省嘉兴市",
"861594980", "山东省泰安市",
"861333621", "山东省菏泽市",
"861303917", "吉林省吉林市",
"86155147", "河南省焦作市",
"861323062", "河北省保定市",
"861357565", "浙江省衢州市",
"861803931", "河南省南阳市",
"861598762", "云南省大理白族自治州",
"861561910", "陕西省咸阳市",
"861532833", "四川省泸州市",
"861320678", "黑龙江省双鸭山市",
"86134610", "河南省洛阳市",
"861840864", "宁夏固原市",
"861327600", "福建省泉州市",
"861335720", "湖南省株洲市",
"861846449", "山东省莱芜市",
"861319143", "内蒙古呼和浩特市",
"861889040", "湖南省岳阳市",
"861314169", "江苏省南京市",
"861303421", "浙江省杭州市",
"861326766", "广东省江门市",
"861562474", "内蒙古乌兰察布市",
"861378052", "河北省保定市",
"861768196", "浙江省湖州市",
"861457121", "黑龙江省鸡西市",
"86183968", "山东省济南市",
"861378786", "湖南省常德市",
"861359325", "山西省长治市",
"861707566", "安徽省安庆市",
"861566698", "山东省德州市",
"861364520", "江苏省徐州市",
"861508887", "浙江省舟山市",
"861705257", "重庆市",
"861399788", "湖北省随州市",
"861333949", "黑龙江省大庆市",
"861318481", "广东省揭阳市",
"86153020", "天津市",
"861830904", "新疆伊犁哈萨克自治州",
"861840548", "山东省泰安市",
"861818895", "湖南省郴州市",
"861521130", "湖南省常德市",
"861785588", "浙江省金华市",
"861888208", "四川省凉山彝族自治州",
"861337512", "江苏省徐州市",
"86181232", "四川省成都市",
"861380662", "浙江省温州市",
"861850391", "河南省焦作市",
"861589203", "福建省漳州市",
"861559199", "陕西省渭南市",
"861341133", "广东省阳江市",
"861776739", "浙江省衢州市",
"86151558", "安徽省阜阳市",
"861850789", "广西北海市",
"861366470", "内蒙古呼伦贝尔市",
"861801430", "江苏省常州市",
"861572428", "浙江省宁波市",
"861770854", "贵州省黔西南布依族苗族自治州",
"861567252", "湖北省宜昌市",
"861369504", "福建省厦门市",
"861361588", "浙江省宁波市",
"861591936", "广东省惠州市",
"861839744", "湖南省常德市",
"861870961", "宁夏银川市",
"861301920", "吉林省长春市",
"86133705", "山东省济南市",
"861859457", "福建省龙岩市",
"861870316", "河北省廊坊市",
"86176353", "山西省太原市",
"861524402", "山东省菏泽市",
"861300047", "北京市",
"861867623", "广东省中山市",
"861821889", "广东省茂名市",
"86139582", "浙江省宁波市",
"861373107", "河北省石家庄市",
"861831630", "广东省云浮市",
"861862482", "河南省开封市",
"861325543", "山东省滨州市",
"861853834", "河南省濮阳市",
"861563927", "河南省郑州市",
"861500645", "山东省烟台市",
"861855942", "福建省南平市",
"86186561", "安徽省淮北市",
"861860359", "山西省运城市",
"861892433", "广东省东莞市",
"86159062", "江苏省苏州市",
"861593338", "河北省邢台市",
"86187690", "山东省菏泽市",
"861774816", "四川省绵阳市",
"861890142", "江苏省泰州市",
"8614739", "广东省广州市",
"861569151", "陕西省宝鸡市",
"86130729", "陕西省西安市",
"861350990", "广东省湛江市",
"861305845", "广东省揭阳市",
"86135691", "河南省焦作市",
"861399956", "新疆昌吉回族自治州",
"861319835", "四川省眉山市",
"861339031", "辽宁省鞍山市",
"861538340", "山西省太原市",
"861356558", "新疆吐鲁番地区",
"861892670", "广东省茂名市",
"861553468", "山西省长治市",
"861810985", "辽宁省盘锦市",
"861576818", "广东省茂名市",
"861807044", "江西省抚州市",
"861868419", "贵州省安顺市",
"861550040", "吉林省四平市",
"861872546", "云南省曲靖市",
"86138467", "黑龙江省绥化市",
"861831473", "湖北省黄石市",
"861519280", "山东省威海市",
"861778903", "西藏山南地区",
"861829219", "陕西省商洛市",
"861373238", "浙江省湖州市",
"861396304", "山东省日照市",
"861520959", "宁夏吴忠市",
"861767341", "湖南省永州市",
"861325532", "山东省青岛市",
"861396682", "安徽省阜阳市",
"861570778", "广西河池市",
"861855933", "福建省莆田市",
"861532976", "贵州省铜仁地区",
"861365226", "广东省佛山市",
"861569792", "江西省九江市",
"861500997", "新疆阿克苏地区",
"861771339", "黑龙江省大庆市",
"861894187", "辽宁省葫芦岛市",
"861882915", "陕西省安康市",
"86187740", "湖南省长沙市",
"861528686", "河南省驻马店市",
"861366633", "山东省日照市",
"861892442", "广东省清远市",
"86135741", "湖南省长沙市",
"861452285", "山西省长治市",
"861576666", "广东省湛江市",
"861822645", "安徽省阜阳市",
"86150633", "山东省济南市",
"861393393", "河北省廊坊市",
"86177306", "陕西省西安市",
"861814353", "贵州省黔东南苗族侗族自治州",
"861510370", "河南省商丘市",
"86158534", "山东省德州市",
"861571496", "新疆昌吉回族自治州",
"861881439", "广东省中山市",
"861326485", "湖北省孝感市",
"861888814", "江苏省苏州市",
"861839508", "宁夏银川市",
"861323410", "辽宁省铁岭市",
"861826891", "浙江省丽水市",
"861875120", "江苏省常州市",
"861872993", "陕西省渭南市",
"861329150", "浙江省嘉兴市",
"861302308", "安徽省合肥市",
"861847621", "广东省广州市",
"861899965", "新疆和田地区",
"861533099", "辽宁省葫芦岛市",
"861871876", "广东省阳江市",
"861323455", "黑龙江省绥化市",
"861590260", "贵州省贵阳市",
"861318669", "江苏省常州市",
"861813569", "河南省郑州市",
"861816040", "新疆乌鲁木齐市",
"861386143", "江苏省连云港市",
"861802490", "广东省佛山市",
"86151123", "广东省深圳市",
"861369935", "新疆乌鲁木齐市",
"861564940", "河南省开封市",
"861874018", "辽宁省阜新市",
"861537080", "江苏省南通市",
"861310808", "四川省自贡市",
"86138328", "河北省唐山市",
"861556985", "甘肃省白银市",
"861860885", "云南省大理白族自治州",
"861317870", "广东省梅州市",
"86150279", "河北省邯郸市",
"861533529", "江苏省苏州市",
"861869425", "河北省唐山市",
"861838402", "四川省泸州市",
"861560724", "湖北省咸宁市",
"861771972", "陕西省商洛市",
"861359787", "湖北省十堰市",
"86158764", "广东省东莞市",
"861584519", "黑龙江省佳木斯市",
"861532842", "四川省南充市",
"861383339", "河北省石家庄市",
"861319132", "内蒙古呼伦贝尔市",
"861821310", "云南省丽江市",
"861508939", "广东省揭阳市",
"861300268", "浙江省温州市",
"861303502", "安徽省蚌埠市",
"861580457", "黑龙江省大兴安岭地区",
"861360491", "辽宁省鞍山市",
"86156347", "山东省淄博市",
"861860406", "辽宁省锦州市",
"861778168", "四川省成都市",
"861379144", "山东省枣庄市",
"861821937", "广东省惠州市",
"861899458", "江苏省淮安市",
"86184608", "江西省南昌市",
"861593079", "河北省沧州市",
"861773929", "河南省南阳市",
"861598453", "四川省雅安市",
"861818751", "云南省昆明市",
"861830535", "山东省烟台市",
"861321427", "辽宁省盘锦市",
"861341845", "广东省深圳市",
"861332898", "福建省泉州市",
"861589789", "湖北省黄冈市",
"861804063", "湖北省荆州市",
"861760953", "宁夏吴忠市",
"86152282", "四川省泸州市",
"861553337", "河北省石家庄市",
"861333373", "河南省新乡市",
"86136160", "福建省厦门市",
"861524091", "云南省临沧市",
"861874281", "新疆喀什地区",
"861871942", "广东省湛江市",
"861592543", "云南省德宏傣族景颇族自治州",
"86152791", "江西省南昌市",
"861827214", "湖北省黄冈市",
"861378958", "内蒙古巴彦淖尔市",
"861817678", "广西梧州市",
"861567601", "广西防城港市",
"861350459", "黑龙江省大庆市",
"861879841", "贵州省黔南布依族苗族自治州",
"861352382", "河南省商丘市",
"861809049", "四川省雅安市",
"861365696", "福建省南平市",
"861301529", "内蒙古赤峰市",
"86180663", "浙江省温州市",
"861528140", "四川省宜宾市",
"861786466", "山东省莱芜市",
"861554215", "辽宁省沈阳市",
"861333303", "河北省张家口市",
"861560896", "西藏那曲地区",
"861899598", "湖北省武汉市",
"861708470", "内蒙古呼和浩特市",
"861367685", "浙江省绍兴市",
"86188564", "安徽省六安市",
"861817608", "广西北海市",
"861452338", "河南省濮阳市",
"861593009", "河北省承德市",
"861810442", "吉林省吉林市",
"861534947", "甘肃省甘南藏族自治州",
"861567087", "河南省焦作市",
"861860476", "内蒙古赤峰市",
"861840667", "广东省茂名市",
"861531502", "山东省青岛市",
"861869753", "安徽省淮南市",
"86183643", "山东省淄博市",
"861831852", "广东省韶关市",
"86189403", "辽宁省抚顺市",
"861314348", "河北省石家庄市",
"861315490", "四川省攀枝花市",
"861347206", "河北省承德市",
"861856300", "山东省滨州市",
"861338848", "浙江省丽水市",
"861536730", "湖南省岳阳市",
"861568758", "云南省德宏傣族景颇族自治州",
"86134132", "广东省佛山市",
"86137039", "河南省郑州市",
"861780334", "河北省秦皇岛市",
"861839951", "新疆和田地区",
"861870434", "吉林省四平市",
"86187313", "河北省张家口市",
"861339315", "河北省唐山市",
"861579735", "湖北省咸宁市",
"861333540", "陕西省咸阳市",
"86139516", "江苏省南京市",
"861552663", "吉林省长春市",
"861808672", "江苏省苏州市",
"861341994", "河南省南阳市",
"86176922", "河北省保定市",
"861303572", "广东省河源市",
"861760446", "吉林省白城市",
"86156340", "山东省济南市",
"86135096", "广东省深圳市",
"861861798", "河北省石家庄市",
"861705756", "广东省深圳市",
"861310878", "云南省楚雄彝族自治州",
"861317800", "福建省漳州市",
"861705082", "山东省青岛市",
"861357522", "湖南省常德市",
"861360551", "安徽省合肥市",
"861572952", "宁夏石嘴山市",
"861580597", "福建省泉州市",
"861598725", "云南省临沧市",
"861558388", "四川省凉山彝族自治州",
"861339350", "山西省忻州市",
"86182591", "福建省福州市",
"861771902", "河南省商丘市",
"861327433", "吉林省延边朝鲜族自治州",
"86150874", "云南省曲靖市",
"86184773", "广西桂林市",
"861859383", "贵州省安顺市",
"861355755", "广西玉林市",
"861571556", "安徽省安庆市",
"861332734", "湖南省衡阳市",
"861871806", "广东省清远市",
"861359362", "湖北省恩施土家族苗族自治州",
"861770657", "浙江省台州市",
"86152046", "黑龙江省哈尔滨市",
"861594589", "黑龙江省佳木斯市",
"861364641", "山东省济南市",
"861510996", "新疆巴音郭楞蒙古自治州",
"861820760", "广东省中山市",
"861869010", "新疆塔城地区",
"861323595", "福建省泉州市",
"86139321", "河北省石家庄市",
"861875700", "浙江省衢州市",
"861337977", "新疆乌鲁木齐市",
"861358537", "江苏省徐州市",
"861885784", "浙江省温州市",
"861556442", "山东省德州市",
"86177744", "湖南省张家界市",
"86186513", "江苏省南通市",
"861355710", "广西防城港市",
"861869055", "陕西省安康市",
"861311054", "福建省福州市",
"86157540", "辽宁省大连市",
"861303893", "陕西省西安市",
"86159683", "浙江省嘉兴市",
"861591452", "广东省广州市",
"861336069", "广东省韶关市",
"861561519", "山东省日照市",
"861351668", "广东省惠州市",
"861338564", "安徽省六安市",
"861323723", "湖北省黄石市",
"861532906", "贵州省铜仁地区",
"861452326", "河南省平顶山市",
"861871485", "安徽省淮南市",
"861367396", "河南省驻马店市",
"86188734", "湖南省衡阳市",
"861815308", "河南省信阳市",
"861476252", "江苏省淮安市",
"861338329", "河北省石家庄市",
"86187747", "湖南省怀化市",
"86136406", "广东省广州市",
"861350029", "广东省清远市",
"861577120", "内蒙古巴彦淖尔市",
"861700187", "北京市",
"861840774", "广西梧州市",
"86157789", "海南省海口市",
"861811689", "新疆伊犁哈萨克自治州",
"861538484", "内蒙古包头市",
"861306804", "山西省太原市",
"861803464", "甘肃省陇南市",
"86180016", "上海市",
"861510543", "山东省滨州市",
"861599719", "湖北省襄樊市",
"861340821", "四川省宜宾市",
"861452467", "黑龙江省鸡西市",
"861777205", "广西钦州市",
"86138460", "黑龙江省鸡西市",
"861383902", "河南省许昌市",
"861559541", "宁夏银川市",
"861850419", "辽宁省辽阳市",
"861370409", "辽宁省大连市",
"861330530", "山东省菏泽市",
"861821951", "广东省肇庆市",
"86134301", "广东省梅州市",
"861554807", "内蒙古通辽市",
"861780786", "广西河池市",
"861556799", "吉林省白山市",
"861470709", "江西省萍乡市",
"861822564", "安徽省六安市",
"861596639", "山东省滨州市",
"861818737", "云南省红河哈尼族彝族自治州",
"861829852", "甘肃省临夏回族自治州",
"861858182", "四川省达州市",
"861318711", "湖南省永州市",
"861526644", "山东省枣庄市",
"861553351", "河北省秦皇岛市",
"861311979", "青海省海西蒙古族藏族自治州",
"861860688", "浙江省金华市",
"86180300", "福建省厦门市",
"861585298", "江苏省泰州市",
"861457049", "广东省中山市",
"861535001", "江西省南昌市",
"861580320", "河北省邯郸市",
"861454393", "贵州省安顺市",
"861372654", "广东省汕头市",
"861560235", "广东省清远市",
"861881562", "安徽省铜陵市",
"861589995", "广东省广州市",
"861479949", "新疆喀什地区",
"861385242", "江苏省宿迁市",
"86181188", "江苏省南京市",
"861807487", "广西玉林市",
"861887636", "福建省泉州市",
"861582588", "甘肃省陇南市",
"86170746", "黑龙江省哈尔滨市",
"861520004", "河北省石家庄市",
"861817875", "广西钦州市",
"861317257", "广东省潮州市",
"861384809", "内蒙古呼伦贝尔市",
"861869930", "新疆石河子市",
"861782862", "四川省广安市",
"861302495", "福建省南平市",
"861316045", "江苏省盐城市",
"861315566", "安徽省池州市",
"861302184", "河北省唐山市",
"861811246", "江苏省无锡市",
"86155502", "山东省滨州市",
"861836144", "江苏省苏州市",
"861594768", "内蒙古乌兰察布市",
"861382468", "广东省云浮市",
"861343552", "广东省河源市",
"861522299", "安徽省黄山市",
"861898749", "云南省昆明市",
"861516647", "山东省济宁市",
"861813432", "河北省保定市",
"861557013", "江西省南昌市",
"86145395", "广东省广州市",
"861454652", "云南省玉溪市",
"861319626", "吉林省辽源市",
"861773474", "河南省洛阳市",
"86177017", "上海市",
"861580431", "吉林省长春市",
"861516419", "辽宁省锦州市",
"86152678", "浙江省宁波市",
"861809586", "新疆阿勒泰地区",
"861308982", "黑龙江省双鸭山市",
"861583382", "河北省衡水市",
"861810799", "江西省萍乡市",
"861322472", "内蒙古包头市",
"861475561", "安徽省合肥市",
"861458791", "湖南省张家界市",
"861319638", "陕西省汉中市",
"861882966", "陕西省汉中市",
"861361879", "云南省普洱市",
"861787559", "广东省茂名市",
"861576615", "广东省揭阳市",
"861509103", "陕西省渭南市",
"861573680", "河南省许昌市",
"861458389", "福建省龙岩市",
"861532527", "浙江省嘉兴市",
"861565905", "福建省泉州市",
"861399960", "新疆巴音郭楞蒙古自治州",
"861338813", "四川省德阳市",
"86152375", "河南省平顶山市",
"861381583", "江苏省扬州市",
"861558174", "山西省晋中市",
"861314313", "广东省珠海市",
"861772411", "广东省揭阳市",
"861316743", "湖南省株洲市",
"861785879", "浙江省嘉兴市",
"861378416", "河北省沧州市",
"861362549", "山东省临沂市",
"86185745", "湖南省怀化市",
"861858406", "四川省成都市",
"861590256", "贵州省铜仁地区",
"861569208", "广东省深圳市",
"861829403", "甘肃省平凉市",
"861561284", "河北省衡水市",
"861339057", "辽宁省沈阳市",
"861539610", "福建省福州市",
"861392675", "广东省汕头市",
"861478716", "云南省西双版纳傣族自治州",
"861800754", "广东省汕头市",
"861310980", "辽宁省大连市",
"861528408", "四川省泸州市",
"861363073", "吉林省白山市",
"861850647", "山东省潍坊市",
"861389732", "青海省海东地区",
"861772927", "陕西省铜川市",
"861557715", "广西崇左市",
"861381474", "江苏省南通市",
"861368459", "黑龙江省大庆市",
"861502988", "陕西省西安市",
"861775058", "福建省厦门市",
"861801962", "江苏省盐城市",
"861471780", "山西省太原市",
"861380828", "四川省泸州市",
"861376578", "贵州省黔南布依族苗族自治州",
"86185759", "广东省湛江市",
"861351865", "山东省济宁市",
"861809861", "安徽省马鞍山市",
"861558896", "山东省莱芜市",
"861569278", "贵州省六盘水市",
"861829473", "甘肃省陇南市",
"861820082", "广东省河源市",
"861820756", "广东省珠海市",
"86152703", "江西省上饶市",
"861309164", "黑龙江省佳木斯市",
"861816347", "广东省清远市",
"861831219", "广东省揭阳市",
"861368599", "福建省龙岩市",
"861587849", "广西百色市",
"861337526", "江苏省盐城市",
"861317988", "新疆阿克苏地区",
"861867905", "江西省南昌市",
"86147524", "江苏省苏州市",
"861868273", "四川省成都市",
"861528478", "四川省雅安市",
"861780422", "辽宁省锦州市",
"861571560", "安徽省合肥市",
"861346854", "陕西省延安市",
"861509173", "陕西省汉中市",
"861890567", "安徽省亳州市",
"861340739", "湖南省邵阳市",
"861768243", "浙江省湖州市",
"861870322", "河北省保定市",
"861452741", "湖南省长沙市",
"86155545", "山东省菏泽市",
"861522629", "宁夏吴忠市",
"861335783", "江苏省南京市",
"861770631", "山东省威海市",
"86136896", "四川省德阳市",
"861370248", "广东省佛山市",
"861808178", "四川省内江市",
"86131429", "江苏省南通市",
"86176815", "浙江省嘉兴市",
"861560388", "河南省许昌市",
"861853651", "山西省晋中市",
"861509723", "甘肃省酒泉市",
"861521858", "广东省云浮市",
"861357847", "云南省迪庆藏族自治州",
"861328690", "广东省中山市",
"861774073", "西藏山南地区",
"86189628", "江苏省南通市",
"861808728", "云南省大理白族自治州",
"861565146", "江苏省徐州市",
"861856077", "山东省济南市",
"861522941", "陕西省延安市",
"861807265", "浙江省舟山市",
"861528249", "四川省凉山彝族自治州",
"861576843", "广东省惠州市",
"861823020", "河北省邯郸市",
"86137943", "广东省广州市",
"861824268", "辽宁省营口市",
"86886", "云南省怒江傈僳族自治州",
"86155926", "陕西省宝鸡市",
"861363705", "安徽省合肥市",
"861338645", "山东省烟台市",
"861860511", "江苏省镇江市",
"861773404", "河北省石家庄市",
"86177010", "北京市",
"861477192", "湖北省荆州市",
"861760730", "湖南省岳阳市",
"861839310", "甘肃省兰州市",
"861874745", "内蒙古锡林郭勒盟",
"861771663", "贵州省铜仁地区",
"861364583", "浙江省嘉兴市",
"861538047", "江苏省常州市",
"861322186", "浙江省温州市",
"861776161", "河南省南阳市",
"861360537", "山东省济宁市",
"861550347", "山西省太原市",
"86139842", "贵州省遵义市",
"861808736", "云南省昆明市",
"861373981", "河北省邢台市",
"861786450", "山东省枣庄市",
"861593312", "河北省保定市",
"861573975", "新疆伊犁哈萨克自治州",
"861887298", "湖北省随州市",
"861366369", "山西省朔州市",
"861816758", "新疆哈密地区",
"86189893", "浙江省宁波市",
"861520074", "湖南省衡阳市",
"861384879", "内蒙古鄂尔多斯市",
"861351162", "江苏省苏州市",
"861311909", "新疆博尔塔拉蒙古自治州",
"861309627", "四川省雅安市",
"861348797", "湖南省邵阳市",
"86184821", "四川省成都市",
"861505487", "山东省济宁市",
"861337096", "山东省聊城市",
"861339911", "陕西省延安市",
"861315881", "四川省自贡市",
"86188498", "云南省昭通市",
"861535071", "河北省廊坊市",
"861705760", "辽宁省沈阳市",
"86180307", "四川省成都市",
"861453469", "黑龙江省鸡西市",
"861369713", "湖北省孝感市",
"861331812", "广东省梅州市",
"861889986", "广东省梅州市",
"861358978", "山东省烟台市",
"861337538", "山东省泰安市",
"861535687", "浙江省温州市",
"86130820", "河北省廊坊市",
"861339427", "辽宁省盘锦市",
"861370479", "内蒙古兴安盟",
"861356305", "山东省滨州市",
"861801247", "江苏省无锡市",
"861815495", "新疆喀什地区",
"861364474", "内蒙古乌兰察布市",
"861802566", "广东省中山市",
"86159904", "浙江省丽水市",
"861330887", "云南省迪庆藏族自治州",
"861301983", "辽宁省锦州市",
"861509025", "河南省许昌市",
"861839937", "新疆和田地区",
"861470779", "广西北海市",
"861882035", "广东省肇庆市",
"861318333", "河南省平顶山市",
"861536446", "湖南省永州市",
"861334833", "福建省三明市",
"861310589", "浙江省金华市",
"861804217", "浙江省台州市",
"861325007", "广东省珠海市",
"861887116", "湖北省武汉市",
"861309796", "广西百色市",
"861840513", "江苏省常州市",
"861394996", "河南省周口市",
"861813956", "新疆喀什地区",
"861893835", "广东省茂名市",
"86139999", "新疆乌鲁木齐市",
"861590757", "广东省佛山市",
"861805653", "安徽省芜湖市",
"861320805", "浙江省宁波市",
"861811358", "四川省德阳市",
"861800941", "甘肃省甘南藏族自治州",
"861453681", "陕西省西安市",
"861318342", "四川省德阳市",
"861537725", "湖北省十堰市",
"861836528", "安徽省滁州市",
"86135603", "广东省广州市",
"861334842", "福建省宁德市",
"861537946", "甘肃省金昌市",
"861368376", "河南省信阳市",
"861520566", "安徽省池州市",
"861588753", "云南省德宏傣族景颇族自治州",
"861315004", "甘肃省临夏回族自治州",
"861599489", "广东省江门市",
"861534898", "西藏拉萨市",
"861576832", "广东省惠州市",
"861823241", "河北省承德市",
"861595402", "山东省日照市",
"861395629", "安徽省滁州市",
"86182168", "贵州省六盘水市",
"861782825", "四川省雅安市",
"861804678", "江西省景德镇市",
"861850568", "安徽省亳州市",
"861537593", "福建省宁德市",
"861700971", "青海省西宁市",
"861871750", "陕西省延安市",
"861590829", "四川省宜宾市",
"861526847", "浙江省绍兴市",
"861330372", "河南省安阳市",
"861320486", "内蒙古呼伦贝尔市",
"861322091", "山东省烟台市",
"861835105", "江苏省扬州市",
"861834478", "江苏省连云港市",
"861552517", "山西省长治市",
"86132482", "上海市",
"861351705", "江西省宜春市",
"861867534", "广东省中山市",
"861875856", "浙江省杭州市",
"861809701", "青海省海东地区",
"861300340", "江苏省南京市",
"861320102", "新疆昌吉回族自治州",
"861395941", "福建省宁德市",
"861763314", "河北省承德市",
"861837492", "湖南省岳阳市",
"86158267", "湖北省随州市",
"861533435", "云南省迪庆藏族自治州",
"861322521", "江苏省连云港市",
"861768232", "浙江省杭州市",
"861502082", "山东省泰安市",
"861390653", "浙江省杭州市",
"861539130", "云南省楚雄彝族自治州",
"861303037", "河南省三门峡市",
"861312840", "广东省潮州市",
"861380973", "广东省湛江市",
"861479540", "广西梧州市",
"861350141", "广东省汕头市",
"861892254", "广东省东莞市",
"861777614", "广西玉林市",
"861507840", "广西玉林市",
"861807692", "西藏日喀则地区",
"861814044", "四川省凉山彝族自治州",
"861329838", "河南省焦作市",
"861558659", "湖北省鄂州市",
"861347545", "山东省烟台市",
"861882742", "湖北省武汉市",
"861334976", "湖北省宜昌市",
"861375162", "广东省阳江市",
"861317082", "江西省九江市",
"86131870", "湖南省长沙市",
"861705800", "北京市",
"861597195", "湖北省荆门市",
"861893132", "河北省张家口市",
"861317756", "江西省宜春市",
"861454830", "广东省广州市",
"861590348", "山西省运城市",
"861550986", "辽宁省大连市",
"861597484", "云南省昆明市",
"861390392", "河南省鹤壁市",
"861778625", "湖北省随州市",
"861845247", "江苏省泰州市",
"86178656", "山东省潍坊市",
"861342246", "广东省珠海市",
"861830429", "辽宁省葫芦岛市",
"861879477", "甘肃省兰州市",
"861815919", "福建省福州市",
"861874032", "陕西省榆林市",
"861889347", "甘肃省兰州市",
"861895340", "山东省莱芜市",
"861894498", "湖南省衡阳市",
"861835802", "浙江省金华市",
"861330939", "甘肃省陇南市",
"86134288", "广东省广州市",
"861364397", "河南省周口市",
"861348638", "浙江省杭州市",
"861313458", "黑龙江省伊春市",
"861800629", "江苏省南通市",
"861319118", "山西省吕梁市",
"861388657", "湖北省荆州市",
"861316488", "福建省厦门市",
"861580964", "宁夏固原市",
"861311570", "浙江省衢州市",
"861780501", "江苏省镇江市",
"861818698", "湖北省神农架林区",
"86152138", "甘肃省庆阳市",
"861894558", "黑龙江省七台河市",
"861700498", "广东省深圳市",
"861535492", "内蒙古鄂尔多斯市",
"861313598", "湖北省荆门市",
"86775", "广西玉林市",
"861776821", "江苏省盐城市",
"86185695", "湖南省长沙市",
"861327381", "河南省郑州市",
"861780571", "浙江省杭州市",
"861534734", "湖南省衡阳市",
"861519693", "四川省遂宁市",
"861854304", "吉林省白城市",
"861311500", "江苏省南京市",
"86136565", "浙江省台州市",
"861351822", "四川省乐山市",
"861398907", "西藏阿里地区",
"861360319", "河北省邢台市",
"861805840", "浙江省杭州市",
"86183701", "江西省鹰潭市",
"861850995", "新疆吐鲁番地区",
"861897186", "湖北省荆门市",
"861370356", "山西省晋城市",
"861348296", "河北省邢台市",
"861879407", "甘肃省陇南市",
"861834991", "四川省成都市",
"861569814", "山东省青岛市",
"861357644", "江西省萍乡市",
"861707550", "安徽省合肥市",
"861479373", "甘肃省定西市",
"861459717", "山东省威海市",
"861895484", "山东省青岛市",
"861320722", "湖北省宜昌市",
"861827980", "江西省吉安市",
"861705231", "四川省成都市",
"861454201", "河南省郑州市",
"861808237", "江苏省连云港市",
"861454587", "甘肃省嘉峪关市",
"861386638", "安徽省芜湖市",
"861450533", "辽宁省营口市",
"861311343", "广东省珠海市",
"861537802", "甘肃省临夏回族自治州",
"861848587", "贵州省六盘水市",
"861334906", "安徽省安庆市",
"861864525", "黑龙江省牡丹江市",
"861332262", "广东省惠州市",
"861859320", "广西玉林市",
"861305648", "四川省巴中市",
"861583159", "河北省邯郸市",
"86157102", "天津市",
"861880541", "山东省济南市",
"86158260", "重庆市",
"861470869", "贵州省安顺市",
"861513542", "山西省晋中市",
"861334390", "河南省平顶山市",
"861380903", "江苏省南京市",
"861335448", "山东省枣庄市",
"861302919", "吉林省通化市",
"861318890", "山东省滨州市",
"861551399", "山西省晋中市",
"861589647", "江苏省无锡市",
"861537453", "湖北省黄石市",
"861330302", "河北省保定市",
"861585116", "江苏省宿迁市",
"861390840", "湖南省岳阳市",
"861478608", "贵州省黔西南布依族苗族自治州",
"861551781", "河南省开封市",
"861351775", "广西玉林市",
"861809771", "新疆博尔塔拉蒙古自治州",
"861328041", "山东省滨州市",
"861834408", "广东省广州市",
"861324345", "河南省焦作市",
"861306243", "福建省厦门市",
"861529330", "甘肃省平凉市",
"861780958", "宁夏银川市",
"861595472", "山东省菏泽市",
"861315074", "云南省昆明市",
"861813443", "河南省驻马店市",
"861803957", "河南省郑州市",
"861500329", "河北省邢台市",
"861389045", "四川省绵阳市",
"861835725", "浙江省湖州市",
"861700901", "山西省太原市",
"861330684", "浙江省宁波市",
"861868789", "云南省楚雄彝族自治州",
"861500564", "安徽省六安市",
"86130615", "山东省菏泽市",
"861319797", "江西省赣州市",
"861452954", "广东省珠海市",
"861332947", "黑龙江省大庆市",
"861577183", "陕西省渭南市",
"86187244", "黑龙江省绥化市",
"861320875", "云南省保山市",
"86188237", "广东省深圳市",
"861568221", "四川省广元市",
"861562929", "湖北省武汉市",
"861335279", "广东省惠州市",
"861572740", "湖南省怀化市",
"861835593", "安徽省亳州市",
"86182356", "山西省晋城市",
"861529421", "甘肃省兰州市",
"86137668", "黑龙江省哈尔滨市",
"861325681", "山东省威海市",
"861354663", "山西省晋中市",
"861571969", "甘肃省陇南市",
"861709741", "广东省广州市",
"861323780", "广西南宁市",
"861830059", "山东省菏泽市",
"861803335", "广东省河源市",
"861374952", "河南省焦作市",
"861890648", "山东省青岛市",
"861588425", "四川省德阳市",
"86137365", "浙江省台州市",
"861537105", "江苏省无锡市",
"861357516", "湖南省常德市",
"86187855", "贵州省黔东南苗族侗族自治州",
"861355344", "广东省惠州市",
"861877506", "广西桂林市",
"861314260", "江苏省镇江市",
"861327509", "福建省南平市",
"86135613", "山东省菏泽市",
"861880435", "吉林省通化市",
"861589734", "湖南省衡阳市",
"86156918", "陕西省西安市",
"861392301", "广东省梅州市",
"861313708", "河南省南阳市",
"861302871", "甘肃省兰州市",
"861337677", "广东省河源市",
"861708876", "广东省茂名市",
"861380746", "湖南省永州市",
"861372079", "陕西省榆林市",
"86182731", "湖南省长沙市",
"861817491", "广西河池市",
"861380925", "广东省佛山市",
"861560490", "辽宁省铁岭市",
"86156641", "河南省郑州市",
"861311790", "江西省新余市",
"861364941", "广西南宁市",
"861556970", "甘肃省平凉市",
"861567558", "安徽省阜阳市",
"861860870", "云南省昭通市",
"861353911", "广东省河源市",
"861537075", "江苏省苏州市",
"861881892", "广东省汕头市",
"861477998", "江西省萍乡市",
"861322463", "黑龙江省牡丹江市",
"861802174", "江苏省扬州市",
"861339769", "湖南省邵阳市",
"861873901", "河南省南阳市",
"861334743", "陕西省西安市",
"861517230", "湖北省十堰市",
"861770957", "宁夏吴忠市",
"861887016", "江西省鹰潭市",
"861391233", "江苏省常州市",
"861325107", "浙江省台州市",
"861878643", "贵州省黔东南苗族侗族自治州",
"8618428", "上海市",
"861812897", "广东省阳江市",
"861479286", "安徽省池州市",
"861515551", "安徽省合肥市",
"86138490", "河南省郑州市",
"861576733", "广东省清远市",
"861583429", "山西省忻州市",
"861336313", "河北省张家口市",
"861522474", "河南省信阳市",
"861341913", "四川省南充市",
"861778673", "湖北省随州市",
"861379692", "黑龙江省鸡西市",
"861373996", "内蒙古呼伦贝尔市",
"86147984", "重庆市",
"861811989", "安徽省芜湖市",
"861459098", "广东省梅州市",
"861360678", "浙江省宁波市",
"861458422", "河南省安阳市",
"861453859", "甘肃省酒泉市",
"861340328", "河北省衡水市",
"861830807", "西藏阿里地区",
"861530557", "安徽省宿州市",
"861317406", "江苏省无锡市",
"861865498", "山东省临沂市",
"861822894", "四川省遂宁市",
"861459536", "西藏那曲地区",
"861708267", "湖北省武汉市",
"861301541", "山西省运城市",
"861770335", "河北省秦皇岛市",
"861315104", "江苏省无锡市",
"861521955", "广东省江门市",
"861508984", "广东省江门市",
"861534419", "内蒙古锡林郭勒盟",
"861373300", "安徽省六安市",
"86153326", "陕西省安康市",
"861597525", "广东省肇庆市",
"861351410", "辽宁省铁岭市",
"861889408", "甘肃省酒泉市",
"861317182", "河北省秦皇岛市",
"861452831", "四川省资阳市",
"861839651", "福建省福州市",
"86177275", "广东省深圳市",
"861537123", "江苏省盐城市",
"861551297", "河北省衡水市",
"861452270", "山西省忻州市",
"861365300", "广东省清远市",
"861708942", "广东省中山市",
"861588403", "四川省凉山彝族自治州",
"861840967", "宁夏中卫市",
"861352974", "云南省曲靖市",
"861572393", "广西柳州市",
"86153511", "辽宁省沈阳市",
"861534647", "河南省平顶山市",
"861573878", "河南省漯河市",
"861350041", "辽宁省朝阳市",
"861459528", "云南省文山壮族苗族自治州",
"861817908", "江西省赣州市",
"861303814", "四川省资阳市",
"86188594", "福建省泉州市",
"861882843", "四川省泸州市",
"861810970", "青海省海北藏族自治州",
"86130642", "云南省昆明市",
"861539030", "四川省内江市",
"861334045", "福建省泉州市",
"861303137", "新疆伊犁哈萨克自治州",
"861338341", "山西省太原市",
"861526698", "山东省威海市",
"861319281", "广东省惠州市",
"861340336", "河北省保定市",
"861801168", "四川省南充市",
"861319507", "宁夏吴忠市",
"861357737", "云南省曲靖市",
"86180693", "浙江省台州市",
"861762589", "江苏省常州市",
"861768907", "西藏阿里地区",
"861326642", "广东省湛江市",
"861782022", "广东省河源市",
"8617700", "北京市",
"861835703", "浙江省杭州市",
"861572652", "山东省聊城市",
"861800397", "河南省信阳市",
"861820359", "山西省运城市",
"861390261", "广东省东莞市",
"861521468", "黑龙江省鸡西市",
"86182561", "安徽省淮北市",
"861337764", "广东省深圳市",
"861555333", "山东省淄博市",
"86178597", "福建省厦门市",
"861782873", "四川省成都市",
"861598646", "广东省梅州市",
"861335377", "河南省南阳市",
"861365543", "山东省滨州市",
"861894819", "广东省深圳市",
"86139620", "江苏省盐城市",
"861309576", "浙江省台州市",
"861364629", "江苏省南通市",
"86135066", "浙江省温州市",
"861329504", "河南省许昌市",
"861326470", "湖北省武汉市",
"861771384", "四川省宜宾市",
"86151339", "河北省唐山市",
"861310371", "河南省郑州市",
"86155586", "浙江省台州市",
"861587739", "陕西省西安市",
"86130450", "山东省青岛市",
"86139627", "江苏省南通市",
"861309506", "新疆昌吉回族自治州",
"861808902", "西藏日喀则地区",
"861569037", "河北省邢台市",
"861835123", "江苏省常州市",
"861819740", "青海省海南藏族自治州",
"861832990", "陕西省延安市",
"861310301", "河北省石家庄市",
"861771440", "江苏省南京市",
"861590477", "内蒙古鄂尔多斯市",
"861388464", "山东省烟台市",
"861760392", "河南省鹤壁市",
"861329574", "浙江省宁波市",
"861847649", "广东省深圳市",
"861581186", "广东省广州市",
"86183711", "湖北省荆门市",
"861478319", "河南省郑州市",
"86184451", "黑龙江省哈尔滨市",
"861890897", "西藏阿里地区",
"861308188", "河北省秦皇岛市",
"861887244", "湖北省荆门市",
"861865971", "福建省泉州市",
"861588584", "贵州省黔东南苗族侗族自治州",
"861845828", "浙江省湖州市",
"861335307", "广东省汕头市",
"861700819", "浙江省台州市",
"861300793", "宁夏吴忠市",
"861381941", "浙江省嘉兴市",
"86147360", "广西百色市",
"861538439", "广东省汕尾市",
"861471547", "广东省佛山市",
"861369635", "山东省聊城市",
"861567901", "江西省鹰潭市",
"861332391", "河南省焦作市",
"86131802", "河北省保定市",
"861320823", "四川省南充市",
"861368283", "广东省揭阳市",
"861458786", "湖南省衡阳市",
"861368869", "山东省烟台市",
"861586089", "福建省三明市",
"861573808", "河南省南阳市",
"861300525", "广东省汕尾市",
"861319577", "青海省西宁市",
"861329483", "内蒙古阿拉善盟",
"861323816", "辽宁省锦州市",
"861589898", "山东省日照市",
"861332789", "江苏省常州市",
"861760653", "浙江省杭州市",
"861767329", "湖南省衡阳市",
"86157112", "北京市",
"86152761", "新疆巴音郭楞蒙古自治州",
"861868947", "广东省深圳市",
"861472877", "贵州省黔西南布依族苗族自治州",
"861810396", "河南省驻马店市",
"861871470", "黑龙江省哈尔滨市",
"861583059", "河北省张家口市",
"861323668", "辽宁省本溪市",
"861806749", "浙江省温州市",
"861881340", "广东省汕头市",
"861825252", "江苏省扬州市",
"861343721", "湖北省荆州市",
"861379222", "山东省德州市",
"86156216", "山东省潍坊市",
"861872914", "陕西省商洛市",
"861351595", "福建省漳州市",
"86185786", "广东省广州市",
"861558566", "吉林省通化市",
"861365370", "河南省商丘市",
"861588473", "四川省达州市",
"861809591", "新疆阿克苏地区",
"861830877", "云南省玉溪市",
"861330255", "广东省江门市",
"861317476", "浙江省台州市",
"861809021", "四川省巴中市",
"861882615", "广东省江门市",
"861325859", "黑龙江省七台河市",
"861576966", "宁夏吴忠市",
"861305897", "浙江省金华市",
"861367442", "吉林省吉林市",
"861389145", "陕西省渭南市",
"861582031", "广东省汕尾市",
"861858988", "广西南宁市",
"861373370", "河南省许昌市",
"861855633", "安徽省芜湖市",
"861336731", "湖南省长沙市",
"861380068", "浙江省杭州市",
"861532676", "内蒙古赤峰市",
"86152531", "山东省济南市",
"861383440", "山西省朔州市",
"861815871", "浙江省杭州市",
"861898839", "云南省普洱市",
"861328141", "陕西省渭南市",
"861764543", "黑龙江省佳木斯市",
"861300095", "内蒙古包头市",
"86133629", "浙江省金华市",
"861815230", "宁夏银川市",
"861708194", "福建省厦门市",
"861814992", "新疆伊犁哈萨克自治州",
"861773941", "河南省焦作市",
"861708485", "河南省漯河市",
"861566092", "河南省商丘市",
"86131859", "浙江省宁波市",
"861530497", "辽宁省朝阳市",
"861358102", "山东省淄博市",
"86139465", "黑龙江省七台河市",
"861347431", "陕西省汉中市",
"861873971", "河南省安阳市",
"861370294", "广东省珠海市",
"86178023", "重庆市",
"861539351", "甘肃省武威市",
"86147691", "云南省昭通市",
"861509162", "陕西省西安市",
"861470990", "新疆克拉玛依市",
"861867878", "山东省济南市",
"861560550", "安徽省滁州市",
"861860800", "四川省成都市",
"861846502", "宁夏石嘴山市",
"861872693", "安徽省铜陵市",
"861864573", "黑龙江省大兴安岭地区",
"861818847", "四川省遂宁市",
"861325177", "吉林省白城市",
"86180554", "安徽省淮南市",
"861313778", "河南省南阳市",
"861845836", "浙江省嘉兴市",
"86130126", "山东省济宁市",
"861342837", "广东省佛山市",
"861533541", "山东省济南市",
"861327579", "安徽省合肥市",
"861470306", "河北省保定市",
"861512407", "辽宁省朝阳市",
"861822945", "湖南省永州市",
"86170785", "贵州省贵阳市",
"861325727", "湖北省襄樊市",
"861847417", "湖南省娄底市",
"861780791", "江西省南昌市",
"861302801", "山西省运城市",
"861774062", "湖北省黄冈市",
"861337607", "江苏省南京市",
"861331331", "河北省石家庄市",
"861346931", "湖南省湘潭市",
"861303449", "湖北省黄冈市",
"861550478", "内蒙古巴彦淖尔市",
"861800404", "辽宁省本溪市",
"86180310", "河北省邯郸市",
"861509705", "甘肃省平凉市",
"861572271", "江苏省苏州市",
"86137771", "浙江省宁波市",
"86153733", "河北省沧州市",
"861830382", "河南省安阳市",
"861846421", "山东省青岛市",
"861814536", "黑龙江省鹤岗市",
"861594905", "江苏省扬州市",
"861829753", "安徽省芜湖市",
"861572830", "广东省江门市",
"861820476", "内蒙古赤峰市",
"861832459", "黑龙江省大庆市",
"861306907", "吉林省通化市",
"861380962", "广东省东莞市",
"86181953", "宁夏吴忠市",
"86138752", "湖南省湘潭市",
"861838549", "贵州省黔南布依族苗族自治州",
"861368709", "江西省南昌市",
"861327685", "浙江省绍兴市",
"861779039", "四川省广安市",
"861590394", "河南省周口市",
"86134311", "广东省东莞市",
"861534568", "安徽省阜阳市",
"861476558", "湖北省武汉市",
"861537863", "四川省眉山市",
"86187004", "陕西省西安市",
"861822697", "安徽省池州市",
"861816249", "湖北省咸宁市",
"861352535", "河南省平顶山市",
"861831317", "云南省大理白族自治州",
"861335554", "安徽省淮南市",
"861568140", "四川省内江市",
"861390730", "湖南省岳阳市",
"861331420", "辽宁省沈阳市",
"861894444", "江苏省南通市",
"861316976", "广东省茂名市",
"861367433", "吉林省延边朝鲜族自治州",
"86187660", "山东省德州市",
"861366942", "广西柳州市",
"86135661", "浙江省温州市",
"861458571", "山东省济宁市",
"861577466", "黑龙江省鹤岗市",
"861320551", "安徽省合肥市",
"861831930", "广东省梅州市",
"861500726", "湖北省荆门市",
"861337874", "云南省曲靖市",
"86186591", "福建省福州市",
"861500945", "甘肃省金昌市",
"861836044", "江苏省苏州市",
"861804880", "四川省乐山市",
"86155512", "安徽省芜湖市",
"861302084", "河北省石家庄市",
"861855470", "山东省济南市",
"86152340", "山西省太原市",
"861764532", "黑龙江省牡丹江市",
"861363025", "陕西省西安市",
"86155577", "浙江省温州市",
"861810579", "浙江省金华市",
"861591636", "广东省惠州市",
"861700380", "河南省洛阳市",
"861870661", "山东省滨州市",
"861812694", "广东省潮州市",
"861597562", "广东省广州市",
"861824439", "四川省绵阳市",
"861593270", "河北省沧州市",
"861816478", "云南省楚雄彝族自治州",
"861500738", "湖南省娄底市",
"861354384", "广东省中山市",
"861811580", "江苏省常州市",
"861566401", "河南省商丘市",
"861530374", "河南省许昌市",
"861780855", "贵州省黔东南苗族侗族自治州",
"861509003", "河南省安阳市",
"86139231", "广东省佛山市",
"86182513", "江苏省南通市",
"861302761", "河南省郑州市",
"861376834", "广西柳州市",
"861339879", "云南省普洱市",
"861370827", "四川省南充市",
"861517761", "广西百色市",
"861479787", "江西省赣州市",
"861860760", "广东省中山市",
"86187391", "河南省焦作市",
"861554429", "河南省新乡市",
"86139815", "四川省凉山彝族自治州",
"86135390", "广东省东莞市",
"861303278", "湖北省恩施土家族苗族自治州",
"861476971", "山东省济南市",
"861338712", "湖北省黄冈市",
"861470459", "黑龙江省大庆市",
"86138936", "甘肃省兰州市",
"861867046", "湖南省永州市",
"861348507", "江苏省宿迁市",
"861458958", "广东省汕头市",
"86183998", "新疆哈密地区",
"861843607", "河南省洛阳市",
"861897191", "湖北省十堰市",
"86133083", "重庆市",
"86181581", "浙江省杭州市",
"861384911", "河南省郑州市",
"861803631", "江苏省盐城市",
"86138709", "江西省南昌市",
"861534844", "湖南省张家界市",
"861533290", "内蒙古呼伦贝尔市",
"861327900", "新疆昌吉回族自治州",
"861308531", "云南省普洱市",
"861320978", "青海省西宁市",
"86153563", "浙江省台州市",
"861333921", "安徽省淮北市",
"861389833", "辽宁省抚顺市",
"861329066", "河北省廊坊市",
"861705511", "浙江省宁波市",
"86157637", "山东省济宁市",
"861358063", "广东省肇庆市",
"861884937", "河北省秦皇岛市",
"86132406", "广东省东莞市",
"861303617", "湖北省咸宁市",
"861330363", "黑龙江省牡丹江市",
"861363723", "安徽省宣城市",
"861459144", "广西百色市",
"861327396", "河南省驻马店市",
"861886740", "湖南省长沙市",
"86150543", "山东省滨州市",
"861556579", "河南省新乡市",
"861801349", "江苏省苏州市",
"861380247", "广东省惠州市",
"861453226", "浙江省金华市",
"861453385", "内蒙古通辽市",
"86157630", "山东省潍坊市",
"86145039", "辽宁省沈阳市",
"861830767", "广东省深圳市",
"861813660", "江苏省扬州市",
"861580545", "山东省烟台市",
"861555342", "山东省烟台市",
"861365532", "山东省青岛市",
"861560959", "宁夏固原市",
"861556509", "河南省郑州市",
"861472674", "四川省自贡市",
"861393428", "山西省阳泉市",
"861529792", "江西省九江市",
"86187425", "辽宁省大连市",
"861879169", "陕西省渭南市",
"861863466", "山西省晋城市",
"86181878", "云南省楚雄彝族自治州",
"861531278", "江苏省泰州市",
"861372338", "宁夏银川市",
"861768512", "贵州省遵义市",
"861348577", "安徽省滁州市",
"861570916", "陕西省汉中市",
"861327970", "新疆喀什地区",
"861363103", "广东省潮州市",
"861853263", "河北省张家口市",
"861320908", "新疆克孜勒苏柯尔克孜自治州",
"861821834", "广东省广州市",
"861832029", "广东省湛江市",
"861775158", "江苏省常州市",
"861301290", "山东省东营市",
"861311811", "四川省德阳市",
"861773754", "河南省平顶山市",
"86184280", "四川省成都市",
"861363455", "黑龙江省绥化市",
"861566565", "安徽省芜湖市",
"861335882", "辽宁省葫芦岛市",
"861339809", "西藏拉萨市",
"86151781", "安徽省阜阳市",
"861501417", "广东省广州市",
"861300562", "广东省湛江市",
"861397176", "湖北省黄石市",
"861354672", "山西省太原市",
"86135397", "广东省广州市",
"861550991", "新疆乌鲁木齐市",
"861530682", "浙江省湖州市",
"861708933", "广东省湛江市",
"861345541", "山东省聊城市",
"86183763", "广西桂林市",
"86151292", "陕西省西安市",
"861534995", "新疆和田地区",
"861882832", "四川省成都市",
"861890694", "福建省漳州市",
"86130281", "四川省成都市",
"861850734", "湖南省衡阳市",
"861331050", "湖北省荆门市",
"861509822", "山东省菏泽市",
"861808078", "四川省攀枝花市",
"861856727", "河南省南阳市",
"86130792", "辽宁省沈阳市",
"861776784", "吉林省吉林市",
"861366485", "内蒙古乌海市",
"861454740", "浙江省温州市",
"86180743", "湖南省湘西土家族苗族自治州",
"861811114", "四川省宜宾市",
"861787666", "广东省广州市",
"861320491", "湖南省郴州市",
"861576742", "广东省深圳市",
"861591298", "云南省普洱市",
"861375410", "内蒙古呼伦贝尔市",
"861855400", "山东省济南市",
"861316390", "福建省厦门市",
"861554059", "内蒙古呼伦贝尔市",
"86183533", "山东省淄博市",
"861478537", "贵州省黔西南布依族苗族自治州",
"861593200", "河北省唐山市",
"861531449", "山东省烟台市",
"861575297", "云南省昆明市",
"861707388", "河南省平顶山市",
"861322086", "山东省青岛市",
"861313544", "安徽省马鞍山市",
"86155570", "浙江省宁波市",
"8613962", "江苏省苏州市",
"861510859", "贵州省黔西南布依族苗族自治州",
"861804537", "黑龙江省哈尔滨市",
"861458287", "福建省莆田市",
"861458501", "河南省信阳市",
"861316906", "广东省潮州市",
"861375455", "河北省唐山市",
"861477092", "江西省赣州市",
"86187667", "山东省东营市",
"861520724", "湖北省咸宁市",
"861894380", "吉林省松原市",
"861800583", "浙江省嘉兴市",
"86183296", "陕西省汉中市",
"861319354", "河南省安阳市",
"861861355", "山西省长治市",
"861501649", "广东省云浮市",
"861475755", "浙江省绍兴市",
"861471816", "广东省湛江市",
"86138238", "广东省梅州市",
"861337804", "湖南省衡阳市",
"86182389", "河南省周口市",
"861329935", "甘肃省武威市",
"861368779", "广西北海市",
"861361911", "陕西省延安市",
"861890913", "陕西省渭南市",
"861393436", "山西省吕梁市",
"861510177", "甘肃省定西市",
"861509125", "陕西省延安市",
"861562190", "内蒙古呼和浩特市",
"86132160", "浙江省温州市",
"861815084", "福建省福州市",
"861323547", "湖北省孝感市",
"861565923", "福建省泉州市",
"861867214", "湖北省襄樊市",
"861369812", "四川省绵阳市",
"861571333", "河北省张家口市",
"86156791", "江西省南昌市",
"861453696", "陕西省咸阳市",
"861503420", "山西省大同市",
"86185712", "湖北省恩施土家族苗族自治州",
"861893926", "河南省郑州市",
"861800474", "内蒙古乌兰察布市",
"86180317", "河北省沧州市",
"861361427", "辽宁省盘锦市",
"861344038", "辽宁省铁岭市",
"861510727", "湖北省襄樊市",
"861309781", "广西北海市",
"861572587", "山东省东营市",
"861363968", "河南省濮阳市",
"861550408", "辽宁省大连市",
"861470029", "安徽省宿州市",
"861335185", "黑龙江省大庆市",
"86185777", "广西钦州市",
"861306977", "黑龙江省绥化市",
"861878632", "贵州省遵义市",
"861771251", "江苏省盐城市",
"861334732", "湖南省湘潭市",
"861774025", "四川省内江市",
"861329357", "山西省临汾市",
"861594975", "山东省潍坊市",
"861391242", "江苏省南通市",
"861376798", "江西省南昌市",
"861394981", "河南省许昌市",
"861533620", "陕西省汉中市",
"86184378", "河南省开封市",
"861840795", "江西省宜春市",
"861818677", "湖北省神农架林区",
"86132481", "上海市",
"861871946", "广东省广州市",
"861782850", "四川省阿坝藏族羌族自治州",
"861313577", "湖北省荆州市",
"861323483", "内蒙古鄂尔多斯市",
"861579808", "江西省萍乡市",
"861325528", "江苏省南京市",
"861881550", "安徽省滁州市",
"861867648", "广东省珠海市",
"861766040", "山东省济南市",
"861352386", "河南省新乡市",
"861538724", "湖北省黄石市",
"861523563", "山西省晋城市",
"861454660", "广东省广州市",
"86184675", "贵州省贵阳市",
"86153559", "浙江省温州市",
"861862765", "湖南省衡阳市",
"861308691", "贵州省黔南布依族苗族自治州",
"861364308", "广东省梅州市",
"861814385", "西藏林芝地区",
"861777167", "湖北省宜昌市",
"861838885", "云南省临沧市",
"86187718", "湖北省宜昌市",
"861572443", "辽宁省丹东市",
"861395619", "安徽省芜湖市",
"861323574", "浙江省宁波市",
"861537715", "湖北省咸宁市",
"861532846", "四川省宜宾市",
"861452253", "浙江省绍兴市",
"861829860", "甘肃省天水市",
"861319136", "内蒙古鄂尔多斯市",
"861780060", "内蒙古阿拉善盟",
"861768751", "广西南宁市",
"861788914", "西藏拉萨市",
"861813740", "河南省驻马店市",
"86131413", "北京市",
"861830647", "山东省东营市",
"861303506", "安徽省合肥市",
"861535969", "福建省漳州市",
"86153228", "广东省东莞市",
"861832984", "陕西省榆林市",
"86151344", "吉林省四平市",
"861771145", "四川省达州市",
"86180765", "广西南宁市",
"861559610", "陕西省榆林市",
"861871593", "河北省承德市",
"86147960", "广西桂林市",
"861760600", "福建省泉州市",
"861301030", "安徽省合肥市",
"861804227", "浙江省湖州市",
"861772893", "广东省梅州市",
"86177599", "福建省南平市",
"861810953", "宁夏吴忠市",
"861838406", "四川省南充市",
"86183745", "湖南省怀化市",
"861588590", "贵州省六盘水市",
"861771976", "陕西省渭南市",
"861459107", "广西柳州市",
"861871872", "广东省佛山市",
"861370280", "广东省阳江市",
"86159557", "安徽省宿州市",
"861319128", "山西省大同市",
"861800619", "江苏省无锡市",
"86180535", "山东省烟台市",
"861503162", "河北省廊坊市",
"861882603", "广东省中山市",
"861533351", "山西省太原市",
"861570835", "四川省雅安市",
"861879971", "新疆塔城地区",
"861847157", "湖北省武汉市",
"861534807", "甘肃省嘉峪关市",
"861887138", "湖北省武汉市",
"861778615", "湖北省黄冈市",
"861340609", "山东省东营市",
"861571492", "新疆博尔塔拉蒙古自治州",
"861536381", "广东省佛山市",
"861341975", "河南省开封市",
"861830419", "辽宁省辽阳市",
"861815929", "福建省厦门市",
"861319778", "广西河池市",
"861560340", "山西省太原市",
"861770701", "江西省鹰潭市",
"861350530", "山东省菏泽市",
"861348544", "山西省吕梁市",
"861396686", "安徽省亳州市",
"861325536", "山东省潍坊市",
"861365222", "广东省中山市",
"861532972", "贵州省遵义市",
"861346049", "河南省新乡市",
"86156479", "内蒙古锡林郭勒盟",
"861379370", "山东省枣庄市",
"861569796", "江西省吉安市",
"861864490", "吉林省四平市",
"861471748", "江西省赣州市",
"861528682", "河南省郑州市",
"861892446", "广东省肇庆市",
"861576662", "广东省汕尾市",
"861502940", "陕西省榆林市",
"861399952", "新疆克拉玛依市",
"86189750", "湖南省岳阳市",
"86159785", "河南省信阳市",
"861779941", "新疆昌吉回族自治州",
"86181969", "新疆伊犁哈萨克自治州",
"861317940", "江苏省苏州市",
"861872542", "云南省玉溪市",
"861356841", "四川省德阳市",
"861860853", "贵州省安顺市",
"861556953", "新疆伊犁哈萨克自治州",
"861560503", "福建省三明市",
"861322511", "江苏省镇江市",
"861859355", "福建省龙岩市",
"861453098", "山西省长治市",
"861324084", "内蒙古呼伦贝尔市",
"86137499", "河南省洛阳市",
"861302929", "辽宁省葫芦岛市",
"861308221", "辽宁省朝阳市",
"86150735", "湖南省郴州市",
"86157101", "上海市",
"861589429", "云南省玉溪市",
"861383906", "河南省新乡市",
"861560573", "浙江省嘉兴市",
"861530347", "山西省临汾市",
"861321787", "广西柳州市",
"861847809", "湖南省郴州市",
"861379300", "山东省菏泽市",
"861870741", "湖南省永州市",
"861452322", "河南省郑州市",
"861532902", "贵州省遵义市",
"861367392", "河南省鹤壁市",
"861864515", "黑龙江省鹤岗市",
"861386544", "安徽省六安市",
"861476256", "江苏省常州市",
"861506148", "江苏省镇江市",
"861822880", "四川省广元市",
"861322688", "广东省汕尾市",
"86132883", "广东省佛山市",
"861310033", "湖南省株洲市",
"861350887", "云南省迪庆藏族自治州",
"861569824", "山东省德州市",
"861859937", "新疆伊犁哈萨克自治州",
"861556446", "山东省淄博市",
"861354833", "四川省内江市",
"861534877", "云南省玉溪市",
"861319708", "湖北省黄冈市",
"861801950", "安徽省芜湖市",
"861311784", "江西省上饶市",
"861869785", "青海省果洛藏族自治州",
"861567348", "湖南省永州市",
"861357538", "浙江省丽水市",
"86183702", "江西省九江市",
"861560484", "黑龙江省牡丹江市",
"861770771", "广西南宁市",
"861338978", "青海省西宁市",
"86156318", "河北省衡水市",
"861591456", "广东省佛山市",
"861340679", "山东省德州市",
"861341905", "四川省达州市",
"861377288", "陕西省延安市",
"861871802", "广东省肇庆市",
"861328363", "山西省阳泉市",
"861571552", "安徽省蚌埠市",
"86189585", "浙江省台州市",
"86159550", "安徽省滁州市",
"861555071", "山东省济宁市",
"861359366", "湖北省黄冈市",
"861459177", "内蒙古鄂尔多斯市",
"86135436", "广东省佛山市",
"861360329", "河北省唐山市",
"861879901", "新疆阿勒泰地区",
"861882673", "广东省茂名市",
"861510992", "新疆伊犁哈萨克自治州",
"861776811", "江苏省南京市",
"86156615", "内蒙古包头市",
"861360564", "安徽省六安市",
"861588415", "四川省泸州市",
"861530758", "广东省肇庆市",
"861313018", "辽宁省鞍山市",
"861705752", "江苏省苏州市",
"861760670", "浙江省衢州市",
"861572956", "宁夏石嘴山市",
"861514900", "内蒙古呼和浩特市",
"86145819", "浙江省金华市",
"86147967", "江西省赣州市",
"861360848", "河南省许昌市",
"861326725", "广东省东莞市",
"861771906", "河南省平顶山市",
"861582540", "浙江省温州市",
"861890534", "山东省德州市",
"86151939", "甘肃省陇南市",
"861886660", "山东省菏泽市",
"861820549", "山东省临沂市",
"861331865", "广东省江门市",
"86183759", "重庆市",
"861311061", "福建省龙岩市",
"861323504", "福建省漳州市",
"861365353", "山西省阳泉市",
"861567829", "广西柳州市",
"861808676", "江苏省扬州市",
"861871453", "黑龙江省牡丹江市",
"861771390", "四川省广元市",
"86188875", "云南省保山市",
"861760442", "吉林省吉林市",
"861568211", "四川省成都市",
"86157518", "江苏省南京市",
"861302641", "陕西省渭南市",
"861593365", "河北省承德市",
"861879498", "甘肃省定西市",
"861810446", "吉林省白城市",
"861337847", "广东省佛山市",
"861708646", "江苏省盐城市",
"861831856", "广东省韶关市",
"861531506", "山东省东营市",
"861567757", "广西玉林市",
"861869083", "新疆克孜勒苏柯尔克孜自治州",
"861860472", "内蒙古包头市",
"861837969", "江西省吉安市",
"861347202", "河北省邯郸市",
"861310735", "湖南省郴州市",
"861500319", "河北省邢台市",
"861364378", "河南省开封市",
"86158179", "广东省汕头市",
"86150565", "安徽省滁州市",
"861338551", "贵州省贵阳市",
"861365692", "福建省龙岩市",
"861313507", "湖南省益阳市",
"861332441", "吉林省吉林市",
"861313281", "广西南宁市",
"861470639", "山东省青岛市",
"861818607", "湖北省武汉市",
"861594897", "吉林省辽源市",
"861826279", "江苏省连云港市",
"861700407", "广东省佛山市",
"861786462", "山东省滨州市",
"861309137", "河北省秦皇岛市",
"861860640", "山东省德州市",
"86138723", "湖北省荆州市",
"861560892", "西藏日喀则地区",
"861398998", "西藏拉萨市",
"861309814", "陕西省渭南市",
"861453528", "山东省潍坊市",
"861579878", "云南省楚雄彝族自治州",
"861324761", "广东省深圳市",
"861355783", "广西桂林市",
"861321325", "河南省安阳市",
"861319616", "吉林省通化市",
"86135997", "福建省泉州市",
"861572788", "浙江省台州市",
"861315147", "江苏省苏州市",
"861530986", "辽宁省沈阳市",
"861510528", "江苏省镇江市",
"861313912", "青海省海东地区",
"861899043", "四川省阿坝藏族羌族自治州",
"86155501", "山东省菏泽市",
"861333809", "江苏省南通市",
"861830844", "四川省德阳市",
"861450275", "内蒙古通辽市",
"861369455", "黑龙江省哈尔滨市",
"861538659", "四川省泸州市",
"861557023", "江西省九江市",
"861354145", "四川省广元市",
"861580937", "甘肃省酒泉市",
"861776790", "吉林省白山市",
"861569297", "四川省德阳市",
"861586924", "浙江省丽水市",
"861330141", "江苏省盐城市",
"861584983", "内蒙古兴安盟",
"861890680", "浙江省舟山市",
"861319868", "四川省绵阳市",
"861317549", "浙江省台州市",
"861528497", "四川省资阳市",
"861323748", "湖南省长沙市",
"861818874", "广东省佛山市",
"861526538", "山东省泰安市",
"861303064", "安徽省亳州市",
"861869327", "甘肃省兰州市",
"861804738", "内蒙古鄂尔多斯市",
"861580310", "河北省邯郸市",
"86158639", "山东省临沂市",
"861770586", "浙江省台州市",
"861390888", "云南省丽江市",
"861318721", "湖南省长沙市",
"861571687", "河北省沧州市",
"861899938", "新疆伊犁哈萨克自治州",
"861459385", "贵州省黔西南布依族苗族自治州",
"861821457", "云南省昆明市",
"861801499", "江苏省镇江市",
"861775418", "安徽省淮北市",
"861876286", "江苏省苏州市",
"861571071", "广东省广州市",
"861859889", "湖南省岳阳市",
"86134302", "广东省广州市",
"861580355", "山西省长治市",
"86137707", "江苏省南京市",
"861760433", "吉林省延边朝鲜族自治州",
"86186446", "上海市",
"861850429", "辽宁省葫芦岛市",
"861558268", "山西省临汾市",
"861570612", "江苏省常州市",
"86187684", "浙江省杭州市",
"861395139", "江苏省宿迁市",
"861318171", "山东省济南市",
"861831699", "广东省深圳市",
"861509420", "云南省保山市",
"861354842", "四川省绵阳市",
"86133603", "广东省佛山市",
"861363812", "贵州省铜仁地区",
"861329547", "山东省济宁市",
"861310042", "广西柳州市",
"861326387", "广西来宾市",
"861557946", "江西省赣州市",
"861899745", "青海省果洛藏族自治州",
"861882430", "广东省深圳市",
"861500880", "云南省普洱市",
"86180972", "青海省西宁市",
"86184869", "贵州省贵阳市",
"86134359", "广东省云浮市",
"86139443", "吉林省延边朝鲜族自治州",
"861772917", "陕西省宝鸡市",
"861815090", "福建省厦门市",
"861562184", "山东省枣庄市",
"861335480", "内蒙古呼伦贝尔市",
"861323357", "山西省临汾市",
"861362257", "广东省江门市",
"861862875", "吉林省四平市",
"861478726", "云南省普洱市",
"861303399", "河南省濮阳市",
"861471574", "广东省汕头市",
"861867567", "广东省清远市",
"861520439", "吉林省白山市",
"861369968", "四川省南充市",
"86155118", "河北省石家庄市",
"861514579", "黑龙江省鸡西市",
"861887277", "湖北省黄石市",
"861768944", "福建省福州市",
"86180917", "陕西省宝鸡市",
"861855105", "江苏省无锡市",
"861316384", "河南省三门峡市",
"861319544", "安徽省芜湖市",
"861308040", "河北省邯郸市",
"861861545", "山东省济南市",
"861338823", "四川省南充市",
"86156827", "甘肃省兰州市",
"861331705", "江西省南昌市",
"861882321", "广东省深圳市",
"861775960", "福建省漳州市",
"861350372", "河南省安阳市",
"86158856", "贵州省遵义市",
"861890905", "四川省内江市",
"861576625", "广东省肇庆市",
"861534382", "河南省郑州市",
"861510536", "山东省潍坊市",
"861338072", "广东省韶关市",
"861830568", "安徽省亳州市",
"861323935", "甘肃省金昌市",
"861375150", "广东省佛山市",
"861364039", "广东省梅州市",
"861471483", "广东省广州市",
"861358997", "山东省东营市",
"861824896", "江苏省连云港市",
"861370034", "河北省廊坊市",
"861843847", "河南省洛阳市",
"861778135", "四川省宜宾市",
"861516429", "辽宁省葫芦岛市",
"861479611", "广西玉林市",
"861880610", "江苏省镇江市",
"86188669", "山东省临沂市",
"861594913", "江苏省盐城市",
"861862486", "河南省洛阳市",
"861365487", "内蒙古包头市",
"861332250", "西藏拉萨市",
"861350684", "浙江省宁波市",
"861534674", "甘肃省庆阳市",
"861352947", "云南省红河哈尼族彝族自治州",
"861855946", "福建省漳州市",
"861774812", "四川省攀枝花市",
"861804894", "四川省乐山市",
"861890146", "江苏省南通市",
"861517090", "江西省新余市",
"861509713", "甘肃省白银市",
"861320341", "山西省太原市",
"861829700", "青海省西宁市",
"861868904", "西藏林芝地区",
"86156820", "四川省成都市",
"861591932", "广东省广州市",
"861331775", "广西玉林市",
"861567256", "湖北省咸宁市",
"861332215", "辽宁省本溪市",
"861348708", "湖北省武汉市",
"861302090", "浙江省温州市",
"861811024", "安徽省蚌埠市",
"861561983", "陕西省汉中市",
"861890975", "青海省果洛藏族自治州",
"861870312", "河北省石家庄市",
"861524406", "山东省菏泽市",
"861474718", "内蒙古巴彦淖尔市",
"861345030", "广东省韶关市",
"861337516", "江苏省苏州市",
"861471504", "广东省梅州市",
"861380666", "浙江省宁波市",
"86134345", "广东省东莞市",
"86131863", "陕西省汉中市",
"861335344", "山西省晋中市",
"861472995", "陕西省安康市",
"861582949", "陕西省宝鸡市",
"861887207", "湖北省孝感市",
"86180910", "陕西省西安市",
"861887581", "浙江省温州市",
"861393899", "河南省南阳市",
"861804106", "辽宁省沈阳市",
"861831229", "广东省肇庆市",
"86134648", "辽宁省阜新市",
"861707562", "安徽省芜湖市",
"861590380", "河南省商丘市",
"861324230", "广东省广州市",
"86147715", "广东省广州市",
"861334663", "河南省安阳市",
"861500537", "山东省济宁市",
"861324871", "浙江省宁波市",
"861339649", "山东省滨州市",
"861820940", "甘肃省临夏回族自治州",
"861840851", "贵州省贵阳市",
"861459238", "四川省资阳市",
"861380818", "四川省成都市",
"861598766", "云南省文山壮族苗族自治州",
"861509015", "河南省洛阳市",
"861337644", "山东省济南市",
"861809631", "四川省广元市",
"861501809", "广东省惠州市",
"861351635", "山东省聊城市",
"86132257", "安徽省安庆市",
"861318101", "山东省滨州市",
"861830995", "新疆吐鲁番地区",
"861326762", "广东省中山市",
"861533284", "内蒙古鄂尔多斯市",
"861834682", "黑龙江省伊春市",
"861339417", "辽宁省营口市",
"86137700", "江苏省盐城市",
"861378782", "湖南省株洲市",
"861768192", "浙江省金华市",
"86138336", "河北省廊坊市",
"861378056", "河北省秦皇岛市",
"861554734", "内蒙古包头市",
"861374960", "河南省驻马店市",
"86145422", "重庆市",
"861839431", "甘肃省白银市",
"861597235", "湖北省黄石市",
"861818804", "贵州省黔南布依族苗族自治州",
"861333157", "吉林省白城市",
"86145044", "辽宁省大连市",
"861518554", "贵州省黔南布依族苗族自治州",
"861893292", "河北省石家庄市",
"861331822", "广东省佛山市",
"861369723", "湖北省荆州市",
"86135074", "湖南省长沙市",
"861309617", "四川省绵阳市",
"86184822", "四川省成都市",
"861331073", "贵州省安顺市",
"86773", "广西桂林市",
"861802147", "江苏省盐城市",
"861511883", "广东省深圳市",
"861536254", "广东省江门市",
"86183695", "山东省临沂市",
"861323066", "河北省廊坊市",
"861339921", "陕西省延安市",
"861362988", "河南省许昌市",
"861534767", "广东省梅州市",
"861573567", "山西省晋城市",
"861812905", "新疆阿勒泰地区",
"861593322", "河北省保定市",
"861870954", "宁夏固原市",
"861524182", "辽宁省沈阳市",
"86157025", "山西省晋中市",
"861302520", "广东省汕头市",
"861516059", "福建省宁德市",
"861522447", "山东省日照市",
"861864959", "山西省运城市",
"86139841", "贵州省贵阳市",
"86177680", "江苏省苏州市",
"861309278", "湖北省黄石市",
"861557802", "广西南宁市",
"86135990", "福建省福州市",
"861860521", "江苏省扬州市",
"86187991", "新疆乌鲁木齐市",
"861373487", "内蒙古鄂尔多斯市",
"861321286", "黑龙江省黑河市",
"861572432", "辽宁省朝阳市",
"861823010", "河北省邯郸市",
"861333879", "江苏省常州市",
"861348036", "广东省云浮市",
"861871863", "广东省茂名市",
"861328302", "河南省濮阳市",
"861313296", "广西百色市",
"861337737", "广西钦州市",
"861557773", "广西柳州市",
"86189925", "陕西省安康市",
"861596306", "山东省济宁市",
"861310845", "四川省遂宁市",
"861301610", "湖南省郴州市",
"861526804", "浙江省舟山市",
"861331455", "黑龙江省绥化市",
"861568531", "贵州省贵阳市",
"861531297", "江苏省南京市",
"86187133", "河北省张家口市",
"861475100", "江苏省苏州市",
"861332974", "湖北省仙桃市",
"86186592", "福建省厦门市",
"86155511", "安徽省宿州市",
"861348598", "安徽省宣城市",
"861315047", "新疆乌鲁木齐市",
"861812046", "湖北省孝感市",
"861331410", "辽宁省铁岭市",
"861806496", "四川省成都市",
"861596990", "山东省日照市",
"861859651", "福建省泉州市",
"86135662", "浙江省温州市",
"861777409", "浙江省台州市",
"861318071", "吉林省白山市",
"861360738", "湖南省娄底市",
"861538881", "云南省西双版纳傣族自治州",
"861471794", "山西省吕梁市",
"861383488", "山西省临汾市",
"861338875", "云南省保山市",
"861831327", "云南省普洱市",
"86137717", "江苏省苏州市",
"861858940", "西藏昌都地区",
"861840934", "甘肃省庆阳市",
"861532963", "贵州省安顺市",
"86138751", "湖南省常德市",
"861778733", "云南省红河哈尼族彝族自治州",
"861576673", "广东省揭阳市",
"861516807", "浙江省舟山市",
"86133066", "浙江省宁波市",
"86134312", "广东省东莞市",
"861340424", "江苏省苏州市",
"861346437", "辽宁省葫芦岛市",
"86137772", "浙江省宁波市",
"861580202", "广东省广州市",
"8617783", "重庆市",
"861583568", "山西省晋城市",
"861535333", "陕西省宝鸡市",
"861571721", "湖北省荆州市",
"86134377", "广东省惠州市",
"861318687", "浙江省宁波市",
"861325044", "广东省揭阳市",
"861363713", "安徽省芜湖市",
"861459469", "陕西省安康市",
"86180907", "四川省德阳市",
"861354743", "四川省遂宁市",
"86155108", "天津市",
"861591277", "云南省楚雄彝族自治州",
"861804076", "新疆乌鲁木齐市",
"861774420", "四川省成都市",
"861333911", "安徽省六安市",
"861705521", "上海市",
"861536970", "河北省秦皇岛市",
"861360726", "湖北省荆门市",
"861511426", "辽宁省葫芦岛市",
"861303627", "江西省宜春市",
"861454443", "江西省上饶市",
"861380559", "安徽省黄山市",
"861384921", "河南省鹤壁市",
"86181582", "浙江省宁波市",
"861537633", "山东省日照市",
"861815190", "江苏省镇江市",
"861527260", "湖北省荆州市",
"861865069", "福建省漳州市",
"861312433", "吉林省延边朝鲜族自治州",
"861889304", "甘肃省白银市",
"861881388", "广东省深圳市",
"861310142", "福建省福州市",
"861876540", "山东省菏泽市",
"861346368", "河北省保定市",
"861478076", "四川省广元市",
"86133613", "山东省烟台市",
"861709661", "浙江省嘉兴市",
"861331968", "湖南省娄底市",
"861841985", "甘肃省陇南市",
"861839545", "陕西省西安市",
"86187392", "河南省鹤壁市",
"86147373", "广东省广州市",
"861369705", "江西省宜春市",
"861776570", "广东省珠海市",
"86155326", "河北省廊坊市",
"861338722", "湖北省襄樊市",
"861853964", "河南省周口市",
"861778035", "四川省雅安市",
"861370817", "四川省成都市",
"861780820", "四川省泸州市",
"86184797", "江西省赣州市",
"86189546", "山东省东营市",
"861589767", "湖北省孝感市",
"861550557", "安徽省宿州市",
"861587679", "广东省中山市",
"86139232", "广东省佛山市",
"861379981", "福建省漳州市",
"861800039", "河北省邢台市",
"861306998", "黑龙江省齐齐哈尔市",
"86170904", "北京市",
"861308140", "山东省东营市",
"861302345", "江苏省镇江市",
"861593661", "河南省漯河市",
"861597959", "江西省抚州市",
"861508779", "云南省昭通市",
"861814681", "陕西省宝鸡市",
"861550497", "辽宁省营口市",
"861877278", "湖北省十堰市",
"861855075", "江苏省宿迁市",
"861308395", "浙江省杭州市",
"861304091", "湖北省荆州市",
"861374899", "河南省郑州市",
"86130791", "四川省泸州市",
"861856717", "河南省南阳市",
"86158098", "辽宁省辽阳市",
"861471838", "广东省茂名市",
"86135629", "山东省临沂市",
"861360894", "山东省淄博市",
"86151782", "安徽省宿州市",
"861319922", "黑龙江省双鸭山市",
"861454956", "江苏省盐城市",
"861569781", "江西省南昌市",
"861517190", "湖北省宜昌市",
"861313626", "浙江省舟山市",
"861567069", "河南省南阳市",
"861840689", "云南省西双版纳傣族自治州",
"861311821", "四川省遂宁市",
"8622", "天津市",
"861342864", "广东省东莞市",
"861850877", "云南省玉溪市",
"861350255", "广东省潮州市",
"861539983", "湖南省怀化市",
"861334251", "湖南省长沙市",
"861523502", "山西省忻州市",
"861821127", "广东省湛江市",
"861520268", "宁夏银川市",
"861860463", "黑龙江省牡丹江市",
"861344016", "四川省眉山市",
"861380499", "辽宁省沈阳市",
"861322870", "江苏省宿迁市",
"861879444", "甘肃省张掖市",
"861570745", "湖南省怀化市",
"861399158", "陕西省铜川市",
"86159746", "云南省曲靖市",
"861845274", "江苏省无锡市",
"861889374", "甘肃省天水市",
"861768522", "贵州省六盘水市",
"861363331", "河北省石家庄市",
"861536396", "广东省珠海市",
"861322231", "江苏省扬州市",
"861570926", "陕西省汉中市",
"861896606", "浙江省绍兴市",
"861878862", "贵州省遵义市",
"861398944", "浙江省金华市",
"861393418", "山西省晋中市",
"86180900", "四川省德阳市",
"861824074", "河南省周口市",
"861361649", "山东省临沂市",
"861575208", "云南省曲靖市",
"86139758", "湖南省长沙市",
"861345130", "内蒙古呼伦贝尔市",
"861817645", "广西玉林市",
"861802047", "江苏省泰州市",
"861774015", "四川省南充市",
"861536685", "江苏省扬州市",
"861570938", "甘肃省天水市",
"861760888", "云南省丽江市",
"861371554", "广东省佛山市",
"861372316", "河南省焦作市",
"861533610", "陕西省咸阳市",
"861594567", "黑龙江省哈尔滨市",
"861361417", "辽宁省营口市",
"861333057", "云南省曲靖市",
"861509150", "陕西省榆林市",
"861560562", "安徽省铜陵市",
"861470019", "江苏省盐城市",
"861877449", "湖南省邵阳市",
"861774050", "湖北省武汉市",
"86156281", "新疆伊犁哈萨克自治州",
"861390433", "吉林省长春市",
"86156792", "江西省九江市",
"861331723", "湖北省黄石市",
"861867224", "湖北省恩施土家族苗族自治州",
"861369822", "四川省宜宾市",
"861318001", "河北省衡水市",
"861392142", "江苏省南京市",
"86132633", "北京市",
"861893361", "广东省梅州市",
"861812768", "广东省韶关市",
"861375331", "山西省阳泉市",
"861362359", "山西省运城市",
"861535711", "安徽省滁州市",
"861576603", "广东省清远市",
"86180371", "河南省郑州市",
"861509115", "陕西省西安市",
"861360482", "黑龙江省齐齐哈尔市",
"861586542", "山东省滨州市",
"861332904", "安徽省合肥市",
"861471826", "广东省揭阳市",
"861570043", "四川省内江市",
"861538566", "安徽省池州市",
"86183786", "广西百色市",
"861331595", "河北省石家庄市",
"861777479", "广西北海市",
"861473621", "广西梧州市",
"861843236", "河北省廊坊市",
"861505532", "安徽省芜湖市",
"861300959", "内蒙古乌海市",
"861569064", "河南省洛阳市",
"861874292", "新疆石河子市",
"861557703", "广西来宾市",
"861338486", "内蒙古包头市",
"86152975", "河北省邯郸市",
"861868250", "四川省遂宁市",
"861475720", "浙江省台州市",
"861861320", "四川省成都市",
"861328372", "河南省新乡市",
"861882662", "广东省清远市",
"861526874", "浙江省湖州市",
"861375420", "浙江省湖州市",
"861352391", "河南省焦作市",
"861581688", "广东省深圳市",
"861452489", "内蒙古阿拉善盟",
"861589159", "陕西省咸阳市",
"86181516", "江苏省南京市",
"861570032", "四川省广安市",
"861334602", "浙江省绍兴市",
"861534429", "内蒙古巴彦淖尔市",
"861586533", "山东省淄博市",
"861358712", "浙江省衢州市",
"861530249", "广东省广州市",
"86152729", "湖北省恩施土家族苗族自治州",
"861359879", "河南省开封市",
"861452661", "江西省南昌市",
"861776979", "浙江省舟山市",
"861880351", "山西省太原市",
"861836107", "江苏省盐城市",
"861505543", "安徽省淮南市",
"861340318", "河北省衡水市",
"861590498", "辽宁省阜新市",
"861321291", "黑龙江省哈尔滨市",
"861890878", "云南省楚雄彝族自治州",
"861569576", "浙江省台州市",
"861311553", "黑龙江省牡丹江市",
"861519542", "江苏省盐城市",
"861768998", "福建省福州市",
"861304402", "山东省泰安市",
"861841433", "内蒙古乌兰察布市",
"861318884", "山东省潍坊市",
"861538074", "江苏省泰州市",
"861450189", "山西省长治市",
"861550374", "河南省许昌市",
"861370993", "新疆伊犁哈萨克自治州",
"86158426", "辽宁省大连市",
"861853431", "山西省运城市",
"861359157", "辽宁省抚顺市",
"861591126", "云南省普洱市",
"861817997", "江西省赣州市",
"861353921", "广东省惠州市",
"861338063", "广东省珠海市",
"861319598", "甘肃省酒泉市",
"861370546", "山东省东营市",
"861472898", "西藏拉萨市",
"861518279", "四川省巴中市",
"861512971", "陕西省榆林市",
"86145204", "天津市",
"861390670", "浙江省衢州市",
"861390442", "吉林省吉林市",
"861524988", "安徽省马鞍山市",
"861876949", "山东省德州市",
"86159579", "浙江省金华市",
"86182732", "湖南省长沙市",
"861770451", "黑龙江省哈尔滨市",
"861380915", "陕西省西安市",
"861889497", "河北省沧州市",
"861591776", "广东省惠州市",
"861894348", "吉林省松原市",
"86131403", "重庆市",
"861505996", "福建省南平市",
"861376867", "广西柳州市",
"861873407", "安徽省阜阳市",
"861551208", "河北省秦皇岛市",
"861364447", "吉林省吉林市",
"861319036", "辽宁省葫芦岛市",
"86135083", "重庆市",
"86150197", "广东省汕头市",
"861328887", "河北省廊坊市",
"861479031", "安徽省六安市",
"861523421", "山西省大同市",
"861332535", "陕西省安康市",
"861318492", "河北省秦皇岛市",
"861887038", "江西省景德镇市",
"861858549", "贵州省黔西南布依族苗族自治州",
"861370614", "江苏省常州市",
"861588770", "云南省红河哈尼族彝族自治州",
"861865407", "安徽省宿州市",
"861364619", "江苏省南通市",
"861353649", "广东省汕尾市",
"86155733", "湖南省株洲市",
"861323794", "江西省抚州市",
"86182562", "安徽省铜陵市",
"861454788", "山东省济宁市",
"861319028", "辽宁省阜新市",
"861590901", "新疆塔城地区",
"861525142", "江苏省无锡市",
"861852459", "辽宁省营口市",
"86183770", "广西防城港市",
"861561541", "山东省济南市",
"861351331", "河北省石家庄市",
"861555101", "安徽省滁州市",
"861530478", "内蒙古巴彦淖尔市",
"861329780", "广西南宁市",
"861588120", "四川省雅安市",
"861782012", "广东省中山市",
"86158889", "浙江省金华市",
"861577539", "四川省遂宁市",
"861840461", "黑龙江省双鸭山市",
"861552197", "广东省梅州市",
"861324510", "内蒙古呼和浩特市",
"861803771", "河南省南阳市",
"861387287", "湖北省随州市",
"861325198", "浙江省丽水市",
"861882295", "广东省东莞市",
"861459518", "云南省德宏傣族景颇族自治州",
"861812808", "广东省肇庆市",
"86158150", "广东省汕头市",
"86188185", "广东省深圳市",
"8613771", "江苏省无锡市",
"861300490", "福建省三明市",
"861814469", "广东省云浮市",
"861313797", "河南省三门峡市",
"861337236", "浙江省台州市",
"861535890", "江苏省盐城市",
"861840575", "浙江省绍兴市",
"861894757", "内蒙古呼伦贝尔市",
"861809957", "新疆喀什地区",
"861860752", "广东省惠州市",
"861819443", "甘肃省张掖市",
"861829999", "新疆阿克苏地区",
"861330690", "福建省福州市",
"861304853", "贵州省黔南布依族苗族自治州",
"861824881", "江苏省无锡市",
"861855863", "福建省三明市",
"86185296", "广东省珠海市",
"861379212", "山东省泰安市",
"861506048", "福建省泉州市",
"86157222", "天津市",
"861337698", "福建省厦门市",
"861567407", "湖南省郴州市",
"861326773", "广东省汕尾市",
"861587585", "广东省茂名市",
"861551449", "河南省驻马店市",
"861323826", "辽宁省营口市",
"86185533", "山东省淄博市",
"861525613", "安徽省淮北市",
"861803701", "河南省洛阳市",
"861886788", "浙江省宁波市",
"86157111", "北京市",
"86152762", "新疆巴音郭楞蒙古自治州",
"861566512", "江苏省连云港市",
"861331062", "山东省聊城市",
"86158157", "广东省江门市",
"861367261", "广东省云浮市",
"861320813", "四川省自贡市",
"861700757", "广东省佛山市",
"861888245", "四川省绵阳市",
"861324495", "广东省东莞市",
"861476069", "内蒙古鄂尔多斯市",
"861596459", "山东省潍坊市",
"861453198", "山西省晋城市",
"861594648", "黑龙江省齐齐哈尔市",
"861585596", "安徽省芜湖市",
"861562801", "贵州省安顺市",
"861590971", "青海省西宁市",
"86183777", "广西钦州市",
"861390985", "辽宁省大连市",
"861478564", "贵州省黔南布依族苗族自治州",
"861813652", "江苏省南通市",
"861354732", "四川省巴中市",
"861553620", "山西省晋中市",
"861709489", "浙江省杭州市",
"861478329", "河南省焦作市",
"861303796", "宁夏银川市",
"861530408", "辽宁省阜新市",
"861537470", "内蒙古呼伦贝尔市",
"861454432", "江苏省南京市",
"861585943", "福建省福州市",
"861811548", "江苏省苏州市",
"861555171", "安徽省芜湖市",
"861360697", "福建省漳州市",
"861459077", "广东省揭阳市",
"861816304", "湖北省黄冈市",
"861835113", "江苏省苏州市",
"861381447", "江苏省泰州市",
"861878825", "云南省红河哈尼族彝族自治州",
"861837890", "广西北海市",
"861388149", "四川省凉山彝族自治州",
"861537642", "山东省青岛市",
"86188840", "四川省成都市",
"86183712", "湖北省孝感市",
"86156308", "河北省保定市",
"861459681", "新疆伊犁哈萨克自治州",
"861885154", "江苏省盐城市",
"861362476", "内蒙古赤峰市",
"861865477", "山东省济宁市",
"861342667", "江西省新余市",
"861804564", "黑龙江省哈尔滨市",
"861312442", "河南省安阳市",
"861306522", "辽宁省铁岭市",
"86151716", "湖北省黄冈市",
"86157508", "福建省福州市",
"861591706", "广东省河源市",
"861328530", "山东省菏泽市",
"861804848", "四川省成都市",
"861319458", "黑龙江省伊春市",
"861508283", "四川省广元市",
"861823630", "河南省周口市",
"861325717", "湖北省黄冈市",
"86150190", "广东省东莞市",
"861801204", "江苏省徐州市",
"861560525", "江苏省扬州市",
"861551278", "河北省沧州市",
"861778742", "云南省文山壮族苗族自治州",
"861807543", "安徽省亳州市",
"861595800", "浙江省杭州市",
"861700348", "山西省太原市",
"861573897", "河南省信阳市",
"861535342", "陕西省铜川市",
"86184409", "云南省昆明市",
"861369865", "山东省青岛市",
"861862978", "吉林省白山市",
"861478848", "河南省新乡市",
"86187673", "浙江省嘉兴市",
"861518209", "四川省巴中市",
"86145809", "浙江省宁波市",
"86147692", "云南省文山壮族苗族自治州",
"861770591", "福建省福州市",
"861889557", "安徽省马鞍山市",
"861850767", "广东省云浮市",
"86156450", "黑龙江省哈尔滨市",
"86186485", "内蒙古通辽市",
"861322760", "湖北省十堰市",
"861304472", "河南省洛阳市",
"861551617", "河南省郑州市",
"861569506", "宁夏石嘴山市",
"861897870", "广西玉林市",
"861590558", "安徽省阜阳市",
"861533130", "重庆市",
"861800378", "河南省开封市",
"861550304", "河北省承德市",
"861539435", "浙江省金华市",
"861335398", "河南省三门峡市",
"861830734", "湖南省衡阳市",
"861368639", "山东省临沂市",
"861821867", "广东省广州市",
"861397217", "湖北省武汉市",
"861530991", "新疆乌鲁木齐市",
"861568188", "四川省达州市",
"861334672", "河南省平顶山市",
"86152532", "山东省青岛市",
"86189779", "广西北海市",
"861479350", "甘肃省陇南市",
"861550682", "广西柳州市",
"861773447", "河北省沧州市",
"86185763", "广东省东莞市",
"861597490", "云南省临沧市",
"861856216", "山东省烟台市",
"861347310", "河北省邯郸市",
"861560793", "江西省上饶市",
"861321949", "四川省广元市",
"861809011", "四川省雅安市",
"861304640", "山东省烟台市",
"86182258", "安徽省合肥市",
"861317683", "山东省泰安市",
"861512609", "云南省丽江市",
"86151941", "山东省济南市",
"861700336", "河北省唐山市",
"861833388", "河北省唐山市",
"86135275", "重庆市",
"861508368", "江西省鹰潭市",
"861537622", "山东省泰安市",
"86151618", "江苏省扬州市",
"861807093", "广西南宁市",
"861819710", "青海省西宁市",
"861470582", "浙江省湖州市",
"861800157", "江苏省苏州市",
"861572405", "广东省广州市",
"861846386", "山东省聊城市",
"86180983", "安徽省滁州市",
"861303995", "黑龙江省绥化市",
"861887214", "湖北省恩施土家族苗族自治州",
"861831986", "广东省潮州市",
"861811528", "江苏省泰州市",
"86158791", "江西省南昌市",
"861570762", "广东省河源市",
"861450232", "河北省张家口市",
"86184454", "黑龙江省佳木斯市",
"861478349", "河南省南阳市",
"861381366", "江苏省常州市",
"861853892", "河南省郑州市",
"86151315", "河北省唐山市",
"861471517", "广东省肇庆市",
"861390786", "广西南宁市",
"861390052", "江苏省镇江市",
"861332563", "新疆乌鲁木齐市",
"861700849", "浙江省杭州市",
"861531844", "山东省枣庄市",
"861841958", "甘肃省白银市",
"861396590", "安徽省池州市",
"86139051", "江苏省南京市",
"861321641", "浙江省衢州市",
"86136238", "河南省郑州市",
"861888225", "四川省成都市",
"861776601", "江苏省泰州市",
"861881355", "广东省清远市",
"861800879", "云南省普洱市",
"861890309", "广东省潮州市",
"861871612", "四川省泸州市",
"861868917", "西藏阿里地区",
"861319766", "广西贵港市",
"861530699", "福建省福州市",
"861323846", "内蒙古兴安盟",
"861532574", "浙江省宁波市",
"861351602", "辽宁省鞍山市",
"861359308", "山西省晋中市",
"861351384", "河南省洛阳市",
"861368931", "甘肃省临夏回族自治州",
"861572886", "广东省清远市",
"861874633", "黑龙江省牡丹江市",
"861872944", "陕西省商洛市",
"861338733", "湖南省株洲市",
"861868421", "吉林省吉林市",
"861520457", "黑龙江省大兴安岭地区",
"861304620", "广东省湛江市",
"861367412", "辽宁省鞍山市",
"861322351", "山西省太原市",
"861892269", "广东省汕尾市",
"86189598", "福建省泉州市",
"861321929", "四川省巴中市",
"861773427", "河北省保定市",
"861853484", "山西省晋中市",
"861586471", "山东省青岛市",
"861771968", "陕西省西安市",
"861383410", "山西省运城市",
"86152534", "山东省德州市",
"861302787", "贵州省遵义市",
"861379575", "四川省遂宁市",
"86159963", "江苏省南京市",
"861330240", "广东省广州市",
"861891444", "江苏省泰州市",
"861477089", "江西省九江市",
"861350957", "福建省宁德市",
"861479761", "青海省海北藏族自治州",
"861892156", "江苏省镇江市",
"861395157", "江苏省无锡市",
"861379461", "广东省佛山市",
"861585046", "江苏省镇江市",
"861773911", "河南省新乡市",
"861586565", "山东省淄博市",
"861300272", "山东省烟台市",
"861309604", "四川省绵阳市",
"86147694", "广东省广州市",
"861778172", "四川省遂宁市",
"861315383", "山东省莱芜市",
"861889219", "陕西省榆林市",
"861822950", "湖南省湘西土家族苗族自治州",
"861538637", "湖南省益阳市",
"86132467", "广东省深圳市",
"861535322", "陕西省铜川市",
"861700328", "河北省石家庄市",
"861323972", "新疆喀什地区",
"861818817", "贵州省毕节地区",
"861818134", "四川省成都市",
"86184065", "山西省太原市",
"861331488", "内蒙古呼和浩特市",
"861339404", "福建省厦门市",
"861318831", "辽宁省阜新市",
"861807523", "安徽省黄山市",
"861336570", "安徽省滁州市",
"861533511", "江苏省徐州市",
"861334331", "河北省石家庄市",
"861778722", "云南省大理白族自治州",
"861580959", "宁夏固原市",
"86180551", "安徽省合肥市",
"861560545", "山东省烟台市",
"861350335", "河北省秦皇岛市",
"861590679", "浙江省金华市",
"861588686", "新疆巴音郭楞蒙古自治州",
"861305309", "安徽省合肥市",
"861348485", "陕西省汉中市",
"861336500", "福建省漳州市",
"861897284", "湖北省咸宁市",
"86159798", "江西省赣州市",
"861830781", "广西南宁市",
"861339474", "内蒙古兴安盟",
"861890932", "甘肃省定西市",
"861539191", "安徽省安庆市",
"861774251", "湖南省长沙市",
"861864937", "山西省临汾市",
"861554824", "内蒙古兴安盟",
"86182734", "湖南省衡阳市",
"861830399", "河南省濮阳市",
"861860983", "辽宁省沈阳市",
"861571312", "河北省保定市",
"861390422", "辽宁省鞍山市",
"861331732", "湖南省湘潭市",
"861369833", "四川省广元市",
"86145202", "北京市",
"861308860", "浙江省台州市",
"861581610", "广东省湛江市",
"861592454", "内蒙古通辽市",
"861370526", "江苏省泰州市",
"861364911", "陕西省延安市",
"861878613", "贵州省贵阳市",
"86132460", "广东省中山市",
"861364366", "山西省太原市",
"861323902", "新疆伊犁哈萨克自治州",
"861339583", "浙江省嘉兴市",
"861341943", "四川省乐山市",
"861336343", "山西省太原市",
"861366577", "浙江省台州市",
"861829691", "江西省萍乡市",
"861337248", "浙江省丽水市",
"86134785", "辽宁省大连市",
"861348806", "陕西省咸阳市",
"861880760", "广东省中山市",
"86147981", "吉林省长春市",
"86131251", "湖北省武汉市",
"861760810", "四川省眉山市",
"861521940", "广东省肇庆市",
"861533688", "浙江省杭州市",
"861505523", "安徽省六安市",
"861310862", "云南省楚雄彝族自治州",
"861539463", "江苏省扬州市",
"861596049", "福建省宁德市",
"86138058", "浙江省宁波市",
"86150751", "河北省石家庄市",
"861808816", "云南省德宏傣族景颇族自治州",
"861470854", "贵州省黔南布依族苗族自治州",
"861379505", "辽宁省盘锦市",
"861534449", "湖南省永州市",
"861760855", "贵州省黔东南苗族侗族自治州",
"861568630", "陕西省渭南市",
"861586401", "山东省济南市",
"861515662", "安徽省淮南市",
"861301511", "内蒙古呼伦贝尔市",
"861340819", "四川省达州市",
"861857741", "广西贺州市",
"861359378", "湖北省荆门市",
"861334050", "福建省南平市",
"861332151", "吉林省延边朝鲜族自治州",
"861593560", "山西省晋城市",
"861856024", "山东省济南市",
"861776087", "安徽省安庆市",
"861518428", "辽宁省盘锦市",
"861810883", "云南省临沧市",
"861597272", "湖北省宜昌市",
"861835622", "安徽省芜湖市",
"86187606", "福建省漳州市",
"86147553", "安徽省芜湖市",
"861825061", "福建省泉州市",
"861814837", "内蒙古鄂尔多斯市",
"861338311", "河北省石家庄市",
"861334015", "江西省宜春市",
"861305932", "广东省云浮市",
"861500559", "安徽省黄山市",
"861458261", "安徽省马鞍山市",
"861776671", "四川省雅安市",
"86188591", "福建省福州市",
"861452969", "广东省肇庆市",
"861304290", "甘肃省白银市",
"861303844", "陕西省延安市",
"861350011", "广东省潮州市",
"861399494", "山西省朔州市",
"861810156", "江苏省苏州市",
"861346779", "湖南省邵阳市",
"861771173", "湖南省长沙市",
"861535253", "新疆伊犁哈萨克自治州",
"861351672", "浙江省杭州市",
"861839562", "河北省石家庄市",
"861773057", "河北省保定市",
"861393480", "山西省大同市",
"861387433", "湖南省益阳市",
"861890379", "河南省洛阳市",
"861534278", "湖北省武汉市",
"861588140", "四川省泸州市",
"861586998", "湖南省永州市",
"861310165", "黑龙江省佳木斯市",
"861561521", "山东省聊城市",
"861342992", "湖北省孝感市",
"861365513", "江苏省连云港市",
"861876641", "山东省济南市",
"861760152", "江苏省南通市",
"861824834", "内蒙古通辽市",
"86189933", "甘肃省平凉市",
"861370096", "四川省绵阳市",
"861319048", "辽宁省本溪市",
"86182564", "安徽省六安市",
"861472781", "陕西省榆林市",
"861846225", "山东省聊城市",
"86136752", "江苏省连云港市",
"861360962", "广东省深圳市",
"861353629", "广东省惠州市",
"861309767", "山西省忻州市",
"861572561", "山东省威海市",
"861510594", "福建省莆田市",
"861771595", "江苏省常州市",
"861772904", "陕西省渭南市",
"861894849", "广东省潮州市",
"861768533", "贵州省黔南布依族苗族自治州",
"861899863", "广东省阳江市",
"861830064", "河南省焦作市",
"86187832", "四川省内江市",
"861394967", "河南省焦作市",
"861571954", "宁夏固原市",
"861705620", "福建省厦门市",
"86187125", "安徽省阜阳市",
"861370538", "山东省泰安市",
"861312465", "贵州省黔东南苗族侗族自治州",
"861570175", "甘肃省兰州市",
"861305596", "福建省漳州市",
"861802597", "广东省佛山市",
"861347235", "河北省廊坊市",
"861760791", "江西省南昌市",
"861459580", "陕西省咸阳市",
"861310702", "湖南省株洲市",
"86130157", "福建省福州市",
"861830576", "浙江省台州市",
"86186653", "广东省深圳市",
"861361629", "江苏省扬州市",
"861327883", "湖南省常德市",
"861822559", "安徽省黄山市",
"861871132", "湖南省湘潭市",
"861537665", "山东省枣庄市",
"861760389", "河南省濮阳市",
"861398924", "四川省凉山彝族自治州",
"86177390", "河南省洛阳市",
"861337067", "山东省淄博市",
"861869249", "湖南省邵阳市",
"861570946", "甘肃省临夏回族自治州",
"861519998", "新疆伊犁哈萨克自治州",
"861774602", "福建省泉州市",
"86185946", "福建省福州市",
"861768542", "山东省济南市",
"861532748", "湖北省黄冈市",
"861362858", "贵州省六盘水市",
"861312571", "吉林省吉林市",
"861570725", "湖北省恩施土家族苗族自治州",
"861884573", "黑龙江省大兴安岭地区",
"861348766", "湖南省常德市",
"861879424", "甘肃省兰州市",
"861559760", "青海省玉树藏族自治州",
"86132810", "四川省成都市",
"861580550", "安徽省滁州市",
"861864889", "广西柳州市",
"861327156", "河南省郑州市",
"861818993", "西藏山南地区",
"861870884", "云南省普洱市",
"861339397", "河南省驻马店市",
"86176023", "重庆市",
"861821147", "广东省广州市",
"861336979", "青海省海西蒙古族藏族自治州",
"861888262", "四川省内江市",
"861330451", "黑龙江省哈尔滨市",
"861586092", "福建省泉州市",
"861308700", "河南省开封市",
"861787848", "广西柳州市",
"861331045", "贵州省黔东南苗族侗族自治州",
"861836246", "江苏省盐城市",
"861311841", "四川省资阳市",
"861369976", "广东省深圳市",
"861847139", "湖北省恩施土家族苗族自治州",
"861508149", "河北省邢台市",
"861313646", "浙江省台州市",
"861862650", "吉林省松原市",
"86183688", "浙江省杭州市",
"861363672", "陕西省延安市",
"861515295", "江苏省泰州市",
"861332792", "江苏省无锡市",
"861501447", "广东省揭阳市",
"86151784", "安徽省滁州市",
"861585808", "浙江省舟山市",
"861319942", "黑龙江省鸡西市",
"861363440", "吉林省长春市",
"861315457", "黑龙江省大兴安岭地区",
"861300651", "山东省青岛市",
"861360068", "浙江省温州市",
"861342536", "广东省肇庆市",
"861811144", "四川省乐山市",
"861554297", "辽宁省铁岭市",
"861454710", "浙江省衢州市",
"861843248", "河北省石家庄市",
"86183385", "河南省驻马店市",
"861598708", "云南省玉溪市",
"861375440", "河北省邯郸市",
"861341932", "四川省攀枝花市",
"861336332", "河北省衡水市",
"861576712", "广东省深圳市",
"861558276", "山西省吕梁市",
"861519401", "山东省聊城市",
"861538834", "四川省遂宁市",
"861304541", "黑龙江省佳木斯市",
"861313514", "湖南省湘西土家族苗族自治州",
"861869478", "福建省南平市",
"861531419", "山东省聊城市",
"861840981", "新疆伊犁哈萨克自治州",
"86170945", "黑龙江省哈尔滨市",
"861570872", "云南省大理白族自治州",
"861569898", "辽宁省丹东市",
"861321090", "山东省威海市",
"861780653", "广东省广州市",
"861890596", "福建省漳州市",
"861473641", "云南省曲靖市",
"86138190", "浙江省嘉兴市",
"861524910", "陕西省西安市",
"861787564", "广东省茂名市",
"861871835", "广东省茂名市",
"861566089", "河南省商丘市",
"861471846", "广东省揭阳市",
"861532357", "广东省肇庆市",
"861342528", "广东省肇庆市",
"861814989", "新疆乌鲁木齐市",
"861478903", "西藏山南地区",
"861586522", "山东省滨州市",
"861319267", "广东省佛山市",
"861584640", "黑龙江省七台河市",
"861800769", "广东省东莞市",
"861884892", "河南省平顶山市",
"861890943", "甘肃省白银市",
"861361941", "云南省西双版纳傣族自治州",
"861377939", "新疆阿勒泰地区",
"861843479", "山西省临汾市",
"861340380", "河南省安阳市",
"86159648", "山东省临沂市",
"861770690", "福建省福州市",
"86131487", "广东省深圳市",
"86156794", "江西省抚州市",
"861331743", "湖南省湘西土家族苗族自治州",
"861867244", "湖北省恩施土家族苗族自治州",
"861369842", "江西省九江市",
"861319876", "四川省自贡市",
"861323517", "江苏省常州市",
"861390501", "福建省福州市",
"861524337", "河北省承德市",
"861877429", "湖南省郴州市",
"86135007", "辽宁省大连市",
"861855143", "江苏省南京市",
"861390287", "广东省珠海市",
"861368464", "黑龙江省牡丹江市",
"86159345", "山西省临汾市",
"861354968", "湖南省长沙市",
"861595030", "江苏省盐城市",
"861391212", "江苏省扬州市",
"861314790", "辽宁省锦州市",
"861532935", "贵州省黔东南苗族侗族自治州",
"861303419", "甘肃省庆阳市",
"861457119", "湖北省武汉市",
"861709969", "浙江省杭州市",
"861571741", "湖南省长沙市",
"86137774", "浙江省杭州市",
"861347388", "河北省石家庄市",
"86134314", "广东省东莞市",
"861340444", "吉林省白城市",
"861843409", "山西省晋中市",
"861346869", "陕西省汉中市",
"861590585", "浙江省绍兴市",
"861319806", "四川省乐山市",
"861861573", "四川省泸州市",
"861831347", "云南省德宏傣族景颇族自治州",
"861306533", "辽宁省阜新市",
"861390571", "浙江省杭州市",
"86159359", "山西省运城市",
"861337356", "河北省廊坊市",
"861788907", "西藏阿里地区",
"86187001", "陕西省延安市",
"861309159", "黑龙江省鸡西市",
"86131480", "河南省商丘市",
"86138197", "浙江省温州市",
"86135664", "浙江省台州市",
"861366912", "陕西省榆林市",
"861570802", "西藏日喀则地区",
"861870552", "安徽省蚌埠市",
"861882997", "广东省惠州市",
"861894414", "江苏省南京市",
"861315027", "新疆阿克苏地区",
"861812026", "湖北省襄樊市",
"861811992", "安徽省宣城市",
"861500915", "陕西省安康市",
"861855612", "江苏省泰州市",
"861862843", "陕西省渭南市",
"86185248", "辽宁省铁岭市",
"861557143", "湖北省十堰市",
"861320662", "黑龙江省齐齐哈尔市",
"861598778", "云南省红河哈尼族彝族自治州",
"861310825", "四川省遂宁市",
"861883083", "河北省衡水市",
"861351251", "江苏省南京市",
"86170959", "福建省福州市",
"861500950", "宁夏银川市",
"861319485", "四川省德阳市",
"861529203", "湖南省岳阳市",
"861869408", "湖北省宜昌市",
"861861484", "内蒙古包头市",
"861890456", "黑龙江省黑河市",
"861452560", "贵州省黔南布依族苗族自治州",
"861899773", "新疆石河子市",
"861319194", "河北省沧州市",
"86155725", "湖北省孝感市",
"861521549", "山东省临沂市",
"861874470", "贵州省安顺市",
"861308120", "辽宁省鞍山市",
"86170902", "广东省惠州市",
"861317199", "河北省沧州市",
"861859959", "福建省宁德市",
"861330591", "福建省福州市",
"861845880", "浙江省温州市",
"861824637", "黑龙江省佳木斯市",
"861369390", "河南省开封市",
"86139234", "广东省深圳市",
"861812038", "湖北省荆门市",
"861570453", "黑龙江省牡丹江市",
"861708577", "江苏省淮安市",
"861380678", "浙江省金华市",
"861366354", "山西省晋中市",
"861355158", "四川省雅安市",
"861831758", "河南省新乡市",
"861308770", "广西防城港市",
"861338742", "湖南省常德市",
"861812596", "广东省揭阳市",
"861315597", "江西省萍乡市",
"861554164", "辽宁省锦州市",
"86187394", "河南省周口市",
"861390958", "宁夏银川市",
"861769209", "河北省衡水市",
"861839525", "宁夏中卫市",
"861453454", "安徽省合肥市",
"861867016", "江西省萍乡市",
"86177397", "河南省郑州市",
"861479801", "黑龙江省哈尔滨市",
"861538798", "江西省景德镇市",
"861316812", "广东省湛江市",
"86159302", "河北省保定市",
"861354173", "四川省绵阳市",
"861336909", "新疆博尔塔拉蒙古自治州",
"861503045", "河北省廊坊市",
"861534814", "四川省广安市",
"861886755", "浙江省金华市",
"861814634", "青海省果洛藏族自治州",
"861561640", "湖南省邵阳市",
"861817295", "江西省宜春市",
"861839793", "江西省上饶市",
"86132817", "四川省达州市",
"861880870", "云南省昭通市",
"861580490", "辽宁省葫芦岛市",
"861454423", "江苏省常州市",
"861303647", "四川省达州市",
"861310772", "浙江省杭州市",
"861450243", "河北省承德市",
"861530856", "贵州省铜仁地区",
"861830506", "浙江省湖州市",
"861360746", "湖南省永州市",
"86132872", "山东省济宁市",
"86158918", "云南省楚雄彝族自治州",
"861569734", "湖南省衡阳市",
"861528930", "陕西省咸阳市",
"861335656", "广东省江门市",
"861832657", "安徽省马鞍山市",
"861860435", "吉林省通化市",
"861325594", "福建省厦门市",
"861786531", "山东省济南市",
"861459114", "广西来宾市",
"861512154", "贵州省毕节地区",
"861354723", "四川省达州市",
"861832464", "黑龙江省佳木斯市",
"861388990", "广东省广州市",
"861370677", "浙江省温州市",
"861339629", "山东省滨州市",
"861539402", "甘肃省甘南藏族自治州",
"86132800", "山东省济宁市",
"861874013", "辽宁省本溪市",
"861310803", "四川省内江市",
"861506544", "山东省德州市",
"861529225", "湖南省湘潭市",
"861320430", "吉林省长春市",
"861335569", "安徽省合肥市",
"861503906", "河南省郑州市",
"861894739", "内蒙古锡林郭勒盟",
"861831249", "广东省深圳市",
"861893400", "广东省湛江市",
"861309429", "湖北省武汉市",
"861816317", "湖北省孝感市",
"86138735", "湖南省郴州市",
"861300263", "浙江省绍兴市",
"86159370", "河南省商丘市",
"861335324", "吉林省长春市",
"86182327", "河北省沧州市",
"861370081", "河南省洛阳市",
"86147521", "江苏省徐州市",
"861809939", "新疆阿克苏地区",
"861472796", "陕西省汉中市",
"861361397", "河南省信阳市",
"861778163", "四川省攀枝花市",
"861816930", "湖南省岳阳市",
"861890776", "广西百色市",
"861452711", "湖北省鄂州市",
"861899453", "江苏省连云港市",
"861888789", "云南省丽江市",
"861811044", "安徽省宿州市",
"861857270", "湖北省襄樊市",
"861598458", "四川省攀枝花市",
"861872401", "江苏省南京市",
"861331976", "新疆阿勒泰地区",
"861332893", "福建省宁德市",
"861320321", "湖南省湘潭市",
"861760958", "宁夏银川市",
"861804068", "湖北省荆门市",
"861333378", "河南省开封市",
"861852437", "辽宁省丹东市",
"861508049", "福建省福州市",
"861303734", "湖南省衡阳市",
"861827065", "江西省九江市",
"861592548", "云南省临沧市",
"861378953", "内蒙古赤峰市",
"861817673", "广西柳州市",
"86170970", "广西南宁市",
"861565116", "江苏省泰州市",
"861513977", "河南省信阳市",
"861357817", "云南省普洱市",
"861454405", "福建省宁德市",
"861818280", "黑龙江省哈尔滨市",
"861553463", "山西省晋城市",
"861356553", "新疆和田地区",
"861576813", "广东省深圳市",
"861522911", "陕西省延安市",
"861831478", "湖北省十堰市",
"86132182", "江苏省南通市",
"861787697", "广东省湛江市",
"861839340", "甘肃省临夏回族自治州",
"861308450", "河北省沧州市",
"861397204", "湖北省宜昌市",
"86156260", "广东省广州市",
"861330701", "江西省鹰潭市",
"861778908", "西藏林芝地区",
"861321190", "云南省大理白族自治州",
"861860541", "山东省临沂市",
"861569419", "辽宁省辽阳市",
"861517540", "河北省邯郸市",
"861550317", "河北省沧州市",
"861570773", "广西桂林市",
"861829686", "江西省赣州市",
"861855938", "福建省莆田市",
"861769307", "甘肃省酒泉市",
"861332572", "浙江省湖州市",
"861801678", "福建省宁德市",
"86158206", "广东省佛山市",
"861366638", "山东省聊城市",
"861338650", "浙江省杭州市",
"861868792", "云南省普洱市",
"861593342", "河北省唐山市",
"861533800", "广东省东莞市",
"861815373", "湖南省益阳市",
"86178620", "山东省滨州市",
"861760465", "黑龙江省大庆市",
"861341581", "广东省茂名市",
"861339941", "甘肃省甘南藏族自治州",
"86145988", "广东省东莞市",
"861370764", "河南省三门峡市",
"861393398", "河北省沧州市",
"861550930", "甘肃省临夏回族自治州",
"861301870", "广东省清远市",
"861589137", "陕西省商洛市",
"861814358", "贵州省六盘水市",
"86150723", "湖北省武汉市",
"861331842", "广东省中山市",
"861506616", "山东省青岛市",
"861595130", "江苏省南通市",
"86145424", "海南省海口市",
"861840532", "山东省青岛市",
"861391300", "江苏省南京市",
"861470464", "黑龙江省七台河市",
"861866271", "江苏省南京市",
"861310452", "黑龙江省齐齐哈尔市",
"861839503", "宁夏吴忠市",
"861459246", "四川省攀枝花市",
"861830796", "江西省吉安市",
"86130179", "浙江省金华市",
"86135017", "上海市",
"86159901", "浙江省杭州市",
"861380319", "河北省邢台市",
"861886475", "河南省焦作市",
"86138565", "安徽省合肥市",
"861872998", "陕西省西安市",
"861801217", "江苏省连云港市",
"861302303", "安徽省芜湖市",
"861539186", "安徽省宿州市",
"861512424", "辽宁省营口市",
"861802777", "广东省茂名市",
"861760571", "浙江省杭州市",
"861563877", "河南省许昌市",
"861507791", "安徽省合肥市",
"861536416", "湖南省常德市",
"86139597", "福建省泉州市",
"861337624", "江苏省无锡市",
"861709342", "广东省深圳市",
"861325704", "江西省赣州市",
"861780261", "江苏省苏州市",
"861760501", "福建省福州市",
"86187682", "浙江省湖州市",
"861841810", "甘肃省陇南市",
"861568010", "四川省德阳市",
"861850449", "吉林省白山市",
"86135010", "北京市",
"861560964", "安徽省六安市",
"861310592", "福建省龙岩市",
"86186026", "天津市",
"861856864", "河南省开封市",
"861329097", "河南省濮阳市",
"861327367", "河北省邢台市",
"86139590", "福建省龙岩市",
"861588691", "新疆昌吉回族自治州",
"861863557", "山西省太原市",
"86184229", "上海市",
"861327426", "辽宁省锦州市",
"861771162", "湖南省长沙市",
"861339299", "广东省珠海市",
"861318741", "云南省昆明市",
"861869347", "甘肃省张掖市",
"861457019", "山东省聊城市",
"861399448", "山西省阳泉市",
"861351663", "广东省佛山市",
"861879154", "陕西省榆林市",
"861529695", "宁夏中卫市",
"861454561", "四川省成都市",
"861308590", "甘肃省白银市",
"861319094", "内蒙古赤峰市",
"861599492", "广东省汕头市",
"861323728", "湖北省荆门市",
"861479919", "新疆克拉玛依市",
"861317529", "浙江省绍兴市",
"86184558", "安徽省阜阳市",
"861862742", "湖南省常德市",
"861811216", "江苏省连云港市",
"861815303", "河南省周口市",
"861773769", "河南省洛阳市",
"861809684", "新疆巴音郭楞蒙古自治州",
"861332502", "山东省青岛市",
"861516617", "山东省日照市",
"861883856", "河南省许昌市",
"861830824", "四川省内江市",
"861454475", "陕西省安康市",
"861345760", "广西玉林市",
"861510548", "山东省泰安市",
"861315127", "江苏省常州市",
"861899872", "广东省湛江市",
"861330771", "广西南宁市",
"861316050", "广东省阳江市",
"861831408", "云南省临沧市",
"861839484", "甘肃省庆阳市",
"861321345", "河南省驻马店市",
"861510864", "云南省德宏傣族景颇族自治州",
"861572891", "西藏拉萨市",
"861806961", "浙江省绍兴市",
"861450512", "吉林省四平市",
"861333308", "河北省衡水市",
"861522057", "广东省惠州市",
"861475652", "河北省唐山市",
"861322610", "广东省潮州市",
"861323736", "湖南省常德市",
"861899593", "湖北省十堰市",
"861551767", "河南省漯河市",
"86170977", "浙江省金华市",
"861346990", "湖北省黄冈市",
"861783952", "河南省漯河市",
"86134091", "陕西省榆林市",
"861817603", "广西钦州市",
"861806316", "山东省临沂市",
"861331390", "福建省南平市",
"861452333", "河南省南阳市",
"861355058", "四川省南充市",
"861377255", "陕西省咸阳市",
"861576645", "广东省深圳市",
"861538951", "陕西省安康市",
"861890706", "江西省吉安市",
"861532259", "广东省汕头市",
"861598036", "福建省莆田市",
"861869758", "安徽省宿州市",
"861319369", "河南省南阳市",
"861786982", "云南省昆明市",
"861709890", "广东省广州市",
"861338843", "浙江省杭州市",
"861317099", "江西省上饶市",
"861319524", "贵州省黔南布依族苗族自治州",
"8613524", "上海市",
"861308020", "内蒙古呼和浩特市",
"861331906", "新疆阿勒泰地区",
"861500204", "广东省广州市",
"861857200", "湖北省黄石市",
"861322655", "广东省清远市",
"861768924", "福建省漳州市",
"861362519", "江苏省泰州市",
"861378446", "河北省廊坊市",
"861893470", "广西南宁市",
"861552668", "吉林省白城市",
"861831991", "广东省阳江市",
"861877159", "湖北省黄冈市",
"861390389", "河南省焦作市",
"861570005", "浙江省杭州市",
"861555270", "山东省滨州市",
"861478746", "云南省昆明市",
"861350631", "山东省威海市",
"861325667", "山东省济南市",
"861822666", "安徽省滁州市",
"861523904", "河南省焦作市",
"86182320", "河北省邯郸市",
"861337294", "辽宁省辽阳市",
"86159377", "河南省南阳市",
"861334635", "山东省聊城市",
"861390791", "江西省南昌市",
"861539472", "内蒙古包头市",
"861370607", "福建省莆田市",
"86132807", "山东省潍坊市",
"861310873", "云南省红河哈尼族彝族自治州",
"86152438", "湖南省娄底市",
"861558383", "四川省德阳市",
"861526546", "山东省东营市",
"861503145", "河北省秦皇岛市",
"861596437", "山东省聊城市",
"861590424", "辽宁省大连市",
"861575807", "云南省昭通市",
"86159312", "河北省保定市",
"861327438", "吉林省松原市",
"861329527", "江苏省宿迁市",
"861867116", "湖北省咸宁市",
"861310022", "湖南省永州市",
"861778551", "贵州省黔东南苗族侗族自治州",
"861893642", "江苏省南通市",
"861509440", "河北省沧州市",
"861304435", "吉林省通化市",
"861354822", "四川省眉山市",
"861899946", "新疆吐鲁番地区",
"861505505", "安徽省阜阳市",
"861770141", "江苏省盐城市",
"861568462", "山东省临沂市",
"861390152", "江苏省无锡市",
"861336790", "江西省新余市",
"86151305", "河北省唐山市",
"86157033", "河北省秦皇岛市",
"86133071", "湖北省武汉市",
"861360349", "河南省驻马店市",
"86181573", "浙江省嘉兴市",
"861364157", "江苏省泰州市",
"861550539", "山东省临沂市",
"86152290", "陕西省西安市",
"861707545", "福建省泉州市",
"86189191", "甘肃省兰州市",
"861389713", "青海省黄南藏族自治州",
"861527161", "湖北省黄冈市",
"861566223", "吉林省长春市",
"861807193", "湖北省恩施土家族苗族自治州",
"86186498", "福建省福州市",
"86183704", "江西省赣州市",
"861570863", "贵州省安顺市",
"861815291", "新疆克拉玛依市",
"861820099", "广东省广州市",
"86132116", "云南省昆明市",
"861398533", "贵州省铜仁地区",
"861339754", "湖南省郴州市",
"861357614", "江西省南昌市",
"861569844", "山西省运城市",
"861893633", "江苏省盐城市",
"861881202", "河北省保定市",
"861500818", "四川省绵阳市",
"861364879", "云南省普洱市",
"861301760", "河南省新乡市",
"861370874", "云南省曲靖市",
"861380537", "山东省济宁市",
"861470931", "甘肃省兰州市",
"861452342", "河南省洛阳市",
"861870721", "湖北省荆州市",
"861812207", "广东省深圳市",
"861347490", "内蒙古呼伦贝尔市",
"861536334", "广东省肇庆市",
"861340558", "江苏省镇江市",
"861530327", "河北省沧州市",
"861780730", "湖南省岳阳市",
"861576997", "云南省保山市",
"861833959", "河南省漯河市",
"861880511", "江苏省盐城市",
"861479495", "内蒙古通辽市",
"861810438", "吉林省松原市",
"861589449", "云南省普洱市",
"861572053", "安徽省芜湖市",
"861479184", "陕西省西安市",
"861807575", "湖南省长沙市",
"861856704", "河南省开封市",
"86888", "云南省丽江市",
"861554576", "黑龙江省佳木斯市",
"861335418", "辽宁省阜新市",
"86180158", "江苏省常州市",
"861310928", "陕西省安康市",
"861330586", "浙江省台州市",
"861338832", "四川省自贡市",
"86155957", "海南省海口市",
"861390810", "四川省德阳市",
"86139689", "浙江省温州市",
"861591768", "广东省东莞市",
"861589617", "江苏省淮安市",
"861819153", "陕西省渭南市",
"861306213", "福建省莆田市",
"861324315", "河南省南阳市",
"861862733", "湖南省株洲市",
"861477189", "湖北省襄樊市",
"861332421", "辽宁省朝阳市",
"86131162", "云南省昆明市",
"8618623", "重庆市",
"86150336", "河北省张家口市",
"86183838", "四川省德阳市",
"861805152", "江苏省苏州市",
"861884562", "黑龙江省哈尔滨市",
"861459358", "贵州省安顺市",
"861819886", "广东省广州市",
"861520707", "江西省赣州市",
"861813413", "河北省张家口市",
"861390855", "贵州省黔东南苗族侗族自治州",
"861890277", "广东省河源市",
"86138896", "辽宁省大连市",
"861332917", "安徽省宿州市",
"861846203", "山东省青岛市",
"861814246", "陕西省汉中市",
"861471963", "甘肃省武威市",
"861840370", "河南省商丘市",
"861337827", "四川省宜宾市",
"861302621", "江西省南昌市",
"861810426", "辽宁省大连市",
"861337759", "广东省湛江市",
"861571831", "广东省茂名市",
"861760422", "辽宁省鞍山市",
"861888273", "四川省自贡市",
"861890866", "湖北省随州市",
"861314979", "辽宁省辽阳市",
"861567849", "广西梧州市",
"861569568", "安徽省六安市",
"86137783", "四川省达州市",
"861820529", "江苏省镇江市",
"861868563", "贵州省遵义市",
"861592667", "湖北省荆门市",
"861572710", "湖北省襄樊市",
"861589278", "四川省南充市",
"86145270", "湖北省武汉市",
"861818034", "四川省凉山彝族自治州",
"861556438", "山东省淄博市",
"861510704", "江西省抚州市",
"861369488", "江西省南昌市",
"861824951", "黑龙江省哈尔滨市",
"861379093", "广东省茂名市",
"861896547", "福建省漳州市",
"861582520", "云南省红河哈尼族彝族自治州",
"861843294", "河北省秦皇岛市",
"861328288", "浙江省温州市",
"861360828", "四川省泸州市",
"861355314", "山东省烟台市",
"861357546", "浙江省杭州市",
"861335960", "黑龙江省大庆市",
"861529947", "新疆乌鲁木齐市",
"861890618", "江苏省无锡市",
"861566693", "山东省泰安市",
"861510774", "广西梧州市",
"861815621", "安徽省铜陵市",
"861819475", "青海省玉树藏族自治州",
"861800427", "辽宁省盘锦市",
"861361474", "内蒙古乌兰察布市",
"861399783", "湖北省十堰市",
"861771775", "河北省唐山市",
"861362910", "陕西省咸阳市",
"86170986", "浙江省宁波市",
"861452890", "云南省昭通市",
"861300937", "辽宁省鞍山市",
"86136719", "上海市",
"861306924", "吉林省长春市",
"86177778", "北京市",
"861551877", "河南省安阳市",
"861367820", "四川省攀枝花市",
"861840543", "山东省滨州市",
"86145212", "河北省保定市",
"861800911", "陕西省延安市",
"861771125", "四川省达州市",
"86151342", "辽宁省营口市",
"861888203", "四川省自贡市",
"861819561", "青海省西宁市",
"861314909", "广东省清远市",
"861537361", "河北省秦皇岛市",
"861858199", "四川省成都市",
"861830627", "江苏省南通市",
"861589208", "福建省莆田市",
"861813720", "河南省焦作市",
"86133136", "黑龙江省哈尔滨市",
"861800366", "黑龙江省哈尔滨市",
"861334812", "江苏省扬州市",
"861341138", "广东省珠海市",
"861362955", "宁夏中卫市",
"861532826", "四川省巴中市",
"861318312", "河南省焦作市",
"861572423", "浙江省温州市",
"861396700", "浙江省衢州市",
"861361583", "浙江省嘉兴市",
"861520777", "广西钦州市",
"861890581", "浙江省杭州市",
"861840300", "河北省邯郸市",
"86159386", "河南省周口市",
"861368854", "贵州省黔南布依族苗族自治州",
"861373242", "浙江省金华市",
"861365967", "广西南宁市",
"861354162", "四川省内江市",
"861538744", "湖南省张家界市",
"861766020", "山东省莱芜市",
"861867628", "广东省东莞市",
"861325548", "山东省泰安市",
"861561463", "山东省威海市",
"861892438", "广东省茂名市",
"861593333", "河北省张家口市",
"86130639", "江苏省常州市",
"861871926", "广东省广州市",
"861840996", "新疆巴音郭楞蒙古自治州",
"861871745", "陕西省安康市",
"861362337", "河北省衡水市",
"861551266", "河北省衡水市",
"861311731", "湖南省长沙市",
"861507855", "广西河池市",
"861560431", "吉林省长春市",
"861450977", "新疆和田地区",
"861520664", "山东省聊城市",
"86151773", "广西桂林市",
"861356821", "四川省德阳市",
"86737", "湖南省益阳市",
"86155950", "宁夏银川市",
"861519192", "陕西省汉中市",
"86185985", "重庆市",
"861328957", "宁夏中卫市",
"861810782", "广西柳州市",
"861317920", "吉林省松原市",
"861810056", "福建省厦门市",
"861892367", "广东省汕头市",
"861308999", "黑龙江省哈尔滨市",
"861554506", "黑龙江省黑河市",
"861325864", "黑龙江省大庆市",
"861362468", "黑龙江省鹤岗市",
"861599687", "江苏省徐州市",
"861873849", "河南省驻马店市",
"861347515", "山东省德州市",
"861871938", "广东省广州市",
"86187616", "江苏省南京市",
"861850814", "四川省广安市",
"861889930", "新疆哈密地区",
"861366797", "江西省赣州市",
"86182818", "四川省达州市",
"861856124", "山东省东营市",
"861507810", "广西河池市",
"861777644", "广西柳州市",
"861380880", "广东省深圳市",
"861590318", "河北省衡水市",
"861340498", "云南省大理白族自治州",
"861332051", "云南省昆明市",
"861334150", "吉林省吉林市",
"861315276", "山西省晋城市",
"861575604", "安徽省铜陵市",
"861867636", "广东省深圳市",
"861365242", "广东省深圳市",
"861458392", "福建省三明市",
"86131129", "广东省中山市",
"861505461", "山东省临沂市",
"861815949", "福建省福州市",
"86134579", "广西南宁市",
"86183346", "山西省晋城市",
"861843624", "河南省三门峡市",
"86133680", "重庆市",
"86150848", "湖南省长沙市",
"861880688", "浙江省丽水市",
"861315867", "四川省德阳市",
"861328335", "河北省承德市",
"861348369", "河北省石家庄市",
"861808780", "云南省楚雄彝族自治州",
"861533760", "浙江省衢州市",
"861345870", "四川省泸州市",
"861535661", "浙江省嘉兴市",
"861532838", "四川省自贡市",
"861320673", "黑龙江省齐齐哈尔市",
"861305581", "福建省泉州市",
"861505575", "安徽省芜湖市",
"86180366", "江苏省连云港市",
"861760786", "广西百色市",
"861458653", "湖北省荆州市",
"861899762", "新疆巴音郭楞蒙古自治州",
"861330861", "湖北省荆州市",
"861863374", "河北省沧州市",
"861510358", "山西省吕梁市",
"861811469", "江苏省常州市",
"861707263", "湖北省咸宁市",
"861803684", "江苏省宿迁市",
"861580793", "江西省上饶市",
"861454720", "浙江省舟山市",
"861319080", "内蒙古鄂尔多斯市",
"861308584", "河北省邢台市",
"861889183", "陕西省渭南市",
"861321555", "安徽省马鞍山市",
"861539870", "云南省昭通市",
"861350240", "广东省广州市",
"861452687", "陕西省西安市",
"861509842", "山东省聊城市",
"86130794", "辽宁省营口市",
"861856747", "河南省新乡市",
"861329728", "湖北省宜昌市",
"861330957", "宁夏银川市",
"861593492", "内蒙古包头市",
"861539231", "福建省三明市",
"861313094", "辽宁省盘锦市",
"861875758", "浙江省杭州市",
"86183018", "上海市",
"861388639", "湖北省孝感市",
"861537132", "江苏省扬州市",
"861454170", "浙江省衢州市",
"861534796", "江西省吉安市",
"861310643", "浙江省绍兴市",
"861839490", "甘肃省武威市",
"861889856", "广东省深圳市",
"861565026", "山东省潍坊市",
"861803302", "广东省东莞市",
"861315951", "吉林省长春市",
"861308473", "内蒙古乌海市",
"861815315", "贵州省黔东南苗族侗族自治州",
"861569807", "山东省东营市",
"861573943", "新疆乌鲁木齐市",
"861832049", "广东省湛江市",
"861882978", "陕西省西安市",
"861459704", "宁夏吴忠市",
"861323097", "河北省邢台市",
"861351488", "内蒙古巴彦淖尔市",
"861354331", "广东省深圳市",
"861367958", "广东省肇庆市",
"861356570", "新疆哈密地区",
"861709492", "浙江省金华市",
"861330335", "河北省秦皇岛市",
"861303059", "江西省抚州市",
"861558637", "湖北省宜昌市",
"861338673", "辽宁省葫芦岛市",
"861393448", "山西省阳泉市",
"861398914", "四川省巴中市",
"861555322", "山东省青岛市",
"861390060", "福建省厦门市",
"861863347", "河北省石家庄市",
"861598797", "云南省普洱市",
"861580525", "江苏省扬州市",
"861325246", "浙江省台州市",
"861570750", "广东省湛江市",
"861576875", "广东省湛江市",
"861322983", "广东省清远市",
"861782033", "广东省湛江市",
"86159977", "湖北省恩施土家族苗族自治州",
"861533640", "山东省济南市",
"861537835", "四川省自贡市",
"86182920", "陕西省西安市",
"861521988", "广东省茂名市",
"861529904", "新疆伊犁哈萨克自治州",
"861568700", "云南省昭通市",
"861517031", "江西省景德镇市",
"861774045", "河南省周口市",
"861865154", "江苏省盐城市",
"861352563", "河南省濮阳市",
"861594776", "内蒙古呼伦贝尔市",
"86158308", "河北省保定市",
"861337280", "辽宁省铁岭市",
"861891348", "江苏省徐州市",
"86131103", "陕西省渭南市",
"861899470", "江苏省泰州市",
"86150497", "内蒙古呼伦贝尔市",
"861554208", "辽宁省朝阳市",
"861361447", "吉林省长春市",
"861378970", "内蒙古呼伦贝尔市",
"861380697", "福建省三明市",
"861560651", "浙江省杭州市",
"861503440", "山西省太原市",
"861357409", "湖南省湘潭市",
"861565943", "福建省福州市",
"86156284", "河南省南阳市",
"861877419", "湖南省株洲市",
"861767903", "江西省上饶市",
"861302031", "辽宁省沈阳市",
"861509145", "陕西省安康市",
"861315578", "江西省景德镇市",
"861365851", "贵州省贵阳市",
"86158605", "福建省泉州市",
"861533472", "内蒙古包头市",
"861314553", "安徽省芜湖市",
"861398693", "湖北省武汉市",
"86132473", "广东省广州市",
"861840487", "内蒙古乌兰察布市",
"861538777", "江西省吉安市",
"861301402", "安徽省六安市",
"861329736", "湖南省常德市",
"861331384", "福建省厦门市",
"861339308", "河北省衡水市",
"861520744", "湖南省张家界市",
"861458433", "河南省许昌市",
"861367571", "浙江省衢州市",
"861317858", "广东省湛江市",
"861550699", "福建省莆田市",
"861313524", "湖南省娄底市",
"861802508", "广东省珠海市",
"861502858", "河北省秦皇岛市",
"861531429", "山东省淄博市",
"861590739", "湖南省邵阳市",
"861565038", "山东省济宁市",
"861552574", "山西省运城市",
"861818624", "湖北省武汉市",
"861313369", "江西省吉安市",
"861874075", "陕西省安康市",
"861355899", "四川省绵阳市",
"861576722", "广东省汕头市",
"86147218", "上海市",
"861824867", "浙江省台州市",
"861815031", "福建省龙岩市",
"861802578", "广东省汕尾市",
"861880752", "广东省惠州市",
"861358966", "山东省临沂市",
"861329963", "广西桂林市",
"861515615", "安徽省合肥市",
"861882491", "广东省广州市",
"861324949", "广东省汕头市",
"861893453", "江苏省南通市",
"861330011", "北京市",
"86155514", "安徽省阜阳市",
"861858337", "四川省成都市",
"861500746", "湖南省永州市",
"86182038", "河南省南阳市",
"861582871", "四川省内江市",
"86176255", "江苏省苏州市",
"861310850", "云南省昆明市",
"861316775", "安徽省宣城市",
"861309734", "江西省赣州市",
"861450192", "山西省运城市",
"86159094", "江西省宜春市",
"861354050", "四川省攀枝花市",
"861339378", "河南省平顶山市",
"861331440", "贵州省遵义市",
"861315017", "甘肃省金昌市",
"861867596", "广东省广州市",
"861858910", "西藏日喀则地区",
"86156889", "吉林省吉林市",
"861568120", "四川省绵阳市",
"861816229", "江西省九江市",
"861357479", "湖南省衡阳市",
"861814864", "广东省广州市",
"861503384", "河北省保定市",
"86187002", "陕西省榆林市",
"861533402", "湖北省荆门市",
"861333629", "山东省滨州市",
"861768205", "安徽省马鞍山市",
"86138754", "湖南省娄底市",
"861801848", "江苏省徐州市",
"861594706", "内蒙古赤峰市",
"86182927", "陕西省宝鸡市",
"861568770", "云南省玉溪市",
"861459667", "新疆昌吉回族自治州",
"861378396", "河南省驻马店市",
"861529974", "新疆博尔塔拉蒙古自治州",
"861571365", "河南省驻马店市",
"861846441", "山东省聊城市",
"861325014", "广东省佛山市",
"861554278", "辽宁省盘锦市",
"86150490", "内蒙古呼伦贝尔市",
"861804204", "浙江省杭州市",
"861314161", "湖南省湘西土家族苗族自治州",
"861303429", "浙江省台州市",
"86186847", "湖南省长沙市",
"861330288", "广东省江门市",
"86132871", "山东省临沂市",
"861533853", "贵州省安顺市",
"861853235", "河北省衡水市",
"86147916", "陕西省汉中市",
"861354713", "四川省绵阳市",
"861709552", "江苏省盐城市",
"861459124", "广西梧州市",
"861848413", "贵州省贵阳市",
"861363743", "湖南省湘西土家族苗族自治州",
"86158642", "山东省青岛市",
"861454413", "福建省厦门市",
"861869497", "江苏省南京市",
"861311187", "四川省成都市",
"861576805", "广东省汕尾市",
"86145388", "云南省昆明市",
"861318489", "广东省汕尾市",
"861333941", "黑龙江省哈尔滨市",
"861459774", "新疆喀什地区",
"861518324", "四川省资阳市",
"861534824", "四川省达州市",
"861835132", "江苏省南通市",
"861536883", "云南省临沧市",
"861850399", "河南省漯河市",
"861770255", "江苏省连云港市",
"861351732", "湖南省湘潭市",
"861308403", "安徽省六安市",
"861569877", "辽宁省盘锦市",
"861834785", "内蒙古巴彦淖尔市",
"861533186", "黑龙江省牡丹江市",
"861850781", "广西南宁市",
"861867026", "湖南省郴州市",
"861776731", "浙江省宁波市",
"861316822", "广东省汕尾市",
"861559191", "陕西省铜川市",
"861808166", "四川省自贡市",
"86159301", "河北省石家庄市",
"861870969", "宁夏吴忠市",
"861569266", "西藏那曲地区",
"86151899", "江苏省泰州市",
"861454100", "安徽省淮北市",
"861833340", "河北省张家口市",
"861516064", "福建省三明市",
"861839515", "宁夏中卫市",
"86158457", "黑龙江省齐齐哈尔市",
"861334062", "四川省广安市",
"861777607", "广西柳州市",
"861321184", "云南省昭通市",
"861302350", "江苏省徐州市",
"861329108", "江苏省苏州市",
"861591648", "广东省潮州市",
"861308155", "内蒙古鄂尔多斯市",
"861839550", "安徽省宣城市",
"861821881", "广东省深圳市",
"861599342", "河南省商丘市",
"861860351", "山西省太原市",
"861528327", "四川省内江市",
"861320832", "四川省内江市",
"861763307", "河北省邯郸市",
"86467", "黑龙江省鸡西市",
"861566533", "安徽省安庆市",
"861829982", "新疆巴音郭楞蒙古自治州",
"861308110", "河北省石家庄市",
"861328586", "浙江省台州市",
"86170901", "北京市",
"861823686", "河南省焦作市",
"861569159", "陕西省安康市",
"861573456", "黑龙江省黑河市",
"861339039", "辽宁省朝阳市",
"861773649", "河北省石家庄市",
"861561688", "湖南省长沙市",
"86159986", "辽宁省大连市",
"861575995", "福建省南平市",
"861577986", "江西省赣州市",
"861881320", "广东省阳江市",
"861888250", "四川省成都市",
"861374882", "黑龙江省牡丹江市",
"861827112", "湖北省咸宁市",
"861840692", "云南省德宏傣族景颇族自治州",
"861520951", "宁夏银川市",
"861767349", "湖南省岳阳市",
"86157114", "北京市",
"861771331", "黑龙江省哈尔滨市",
"861368437", "四川省凉山彝族自治州",
"861888215", "四川省眉山市",
"861320843", "黑龙江省牡丹江市",
"861569382", "甘肃省兰州市",
"86131804", "河北省石家庄市",
"861356332", "山东省日照市",
"861819170", "陕西省渭南市",
"861507412", "湖南省长沙市",
"861471527", "广东省揭阳市",
"861380482", "黑龙江省牡丹江市",
"861538867", "陕西省咸阳市",
"861363732", "湖南省湘潭市",
"86183525", "江苏省无锡市",
"861845848", "浙江省温州市",
"861813475", "河南省平顶山市",
"861881431", "广东省茂名市",
"86158792", "江西省九江市",
"861389822", "辽宁省铁岭市",
"861452884", "云南省昆明市",
"861334968", "湖南省娄底市",
"861847629", "广东省湛江市",
"861537612", "山东省菏泽市",
"86180509", "福建省泉州市",
"861787537", "广东省汕头市",
"861351743", "湖南省湘西土家族苗族自治州",
"861576063", "四川省广安市",
"86135837", "山东省济宁市",
"861826899", "浙江省衢州市",
"861559086", "黑龙江省哈尔滨市",
"861771420", "江苏省南京市",
"861580562", "安徽省铜陵市",
"861840353", "山西省阳泉市",
"861835143", "江苏省常州市",
"861533091", "辽宁省营口市",
"861528083", "福建省龙岩市",
"86133007", "广西南宁市",
"861318661", "江苏省连云港市",
"861312412", "辽宁省鞍山市",
"861510246", "辽宁省辽阳市",
"861813561", "河南省驻马店市",
"86151942", "山东省青岛市",
"861539760", "四川省成都市",
"861325747", "湖南省益阳市",
"861822746", "四川省甘孜藏族自治州",
"861598296", "四川省绵阳市",
"861804818", "四川省绵阳市",
"861808794", "云南省昆明市",
"861533521", "江苏省无锡市",
"861322435", "吉林省通化市",
"86180552", "安徽省蚌埠市",
"861834466", "江苏省南京市",
"861869374", "甘肃省兰州市",
"861584511", "黑龙江省哈尔滨市",
"861788522", "贵州省安顺市",
"861535312", "陕西省西安市",
"861818827", "贵州省六盘水市",
"861520578", "浙江省丽水市",
"861700318", "河北省唐山市",
"861893762", "河南省郑州市",
"861508931", "广东省惠州市",
"861360499", "辽宁省辽阳市",
"86180966", "安徽省合肥市",
"861347503", "山东省菏泽市",
"86131738", "浙江省金华市",
"861850576", "浙江省台州市",
"861572070", "江苏省南通市",
"861804666", "江西省赣州市",
"86187433", "吉林省延边朝鲜族自治州",
"861770363", "黑龙江省七台河市",
"861773921", "河南省郑州市",
"861586977", "湖南省益阳市",
"86185385", "河南省郑州市",
"86155350", "山西省忻州市",
"861476585", "宁夏银川市",
"861458600", "湖北省恩施土家族苗族自治州",
"861818759", "云南省文山壮族苗族自治州",
"861334410", "北京市",
"861898467", "贵州省铜仁地区",
"861563995", "河南省平顶山市",
"861380894", "山东省淄博市",
"861524099", "云南省丽江市",
"861773417", "河北省邢台市",
"86185688", "河南省安阳市",
"861383420", "山西省太原市",
"86177083", "重庆市",
"861473555", "山西省长治市",
"861397247", "湖北省十堰市",
"861874289", "新疆塔城地区",
"861866443", "广东省中山市",
"861350451", "黑龙江省哈尔滨市",
"861367422", "辽宁省鞍山市",
"861304610", "广东省汕尾市",
"861372258", "河北省邯郸市",
"861452492", "内蒙古包头市",
"861362683", "浙江省宁波市",
"861576765", "广东省广州市",
"861809041", "四川省攀枝花市",
"861321919", "四川省达州市",
"861879849", "贵州省六盘水市",
"861347340", "河北省石家庄市",
"861877568", "广西柳州市",
"861856246", "山东省临沂市",
"861593687", "河南省三门峡市",
"861822068", "陕西省西安市",
"861521756", "广东省惠州市",
"861301521", "内蒙古呼和浩特市",
"861814667", "江西省赣州市",
"861859525", "山东省济南市",
"861347484", "内蒙古赤峰市",
"861335158", "吉林省四平市",
"861552066", "四川省资阳市",
"861870560", "安徽省合肥市",
"861340348", "山西省运城市",
"861347195", "广西梧州市",
"86150752", "河北省保定市",
"861584688", "黑龙江省鹤岗市",
"861586907", "浙江省衢州市",
"86155357", "山西省临汾市",
"861479190", "陕西省铜川市",
"861569767", "广东省汕尾市",
"861500962", "宁夏石嘴山市",
"861458670", "湖南省娄底市",
"86147982", "吉林省松原市",
"861452552", "山东省莱芜市",
"861593001", "河北省邯郸市",
"861520017", "河北省邢台市",
"861373795", "广西河池市",
"861334595", "浙江省宁波市",
"861760820", "四川省资阳市",
"861366965", "广西玉林市",
"86134295", "浙江省绍兴市",
"86147048", "广东省广州市",
"861389705", "青海省海西蒙古族藏族自治州",
"861839959", "新疆喀什地区",
"861320650", "黑龙江省齐齐哈尔市",
"861573379", "河北省唐山市",
"861336784", "广西贺州市",
"861707310", "河北省邯郸市",
"861527570", "山东省德州市",
"861820858", "贵州省六盘水市",
"861475788", "浙江省金华市",
"861311305", "广东省东莞市",
"861334723", "湖南省株洲市",
"86145201", "北京市",
"861850506", "福建省莆田市",
"861550856", "贵州省铜仁地区",
"861347573", "山东省聊城市",
"861565932", "福建省宁德市",
"861360559", "安徽省芜湖市",
"861775882", "黑龙江省哈尔滨市",
"861554814", "内蒙古包头市",
"861380726", "湖北省荆门市",
"861453747", "湖南省衡阳市",
"861592246", "安徽省宿州市",
"861390412", "辽宁省鞍山市",
"861571322", "河北省保定市",
"861364417", "辽宁省营口市",
"861595983", "福建省三明市",
"86187831", "四川省宜宾市",
"861324303", "河南省焦作市",
"861594581", "黑龙江省鹤岗市",
"861705610", "江苏省南京市",
"86135830", "山东省菏泽市",
"861394575", "黑龙江省鹤岗市",
"861369663", "安徽省池州市",
"861340757", "江苏省常州市",
"861573932", "新疆石河子市",
"861877995", "江西省吉安市",
"861366458", "黑龙江省伊春市",
"861338430", "吉林省长春市",
"861364649", "山东省临沂市",
"861378509", "河北省唐山市",
"861370644", "山东省济南市",
"861858519", "贵州省贵阳市",
"861843280", "河北省邯郸市",
"861365523", "江苏省淮安市",
"861598626", "广东省阳江市",
"861705655", "广东省深圳市",
"861781795", "广东省深圳市",
"861846215", "山东省烟台市",
"86136751", "江苏省南京市",
"861893387", "广东省阳江市",
"861308630", "四川省雅安市",
"861782042", "广东省湛江市",
"861316865", "广东省珠海市",
"861363488", "黑龙江省哈尔滨市",
"861813405", "河北省唐山市",
"861336061", "广东省珠海市",
"861561511", "山东省威海市",
"861380738", "湖南省娄底市",
"861882072", "广东省东莞市",
"861805412", "甘肃省酒泉市",
"86138543", "山东省滨州市",
"861365795", "江西省宜春市",
"861324540", "山东省济南市",
"86180268", "广东省江门市",
"86153725", "浙江省绍兴市",
"861538206", "辽宁省朝阳市",
"86131209", "上海市",
"861338321", "河北省石家庄市",
"861806109", "江苏省南通市",
"86188592", "福建省厦门市",
"861777196", "湖北省黄冈市",
"861367786", "广西桂林市",
"861350021", "广东省阳江市",
"861459548", "青海省西宁市",
"861367052", "广东省汕头市",
"861896935", "浙江省金华市",
"861816856", "江苏省泰州市",
"861534627", "河南省鹤壁市",
"861345402", "浙江省衢州市",
"861588531", "贵州省毕节地区",
"861518418", "辽宁省阜新市",
"86150709", "江西省南昌市",
"86181324", "河北省石家庄市",
"861811681", "新疆博尔塔拉蒙古自治州",
"861537143", "江苏省连云港市",
"86183248", "安徽省阜阳市",
"861771713", "河北省张家口市",
"861340829", "四川省攀枝花市",
"861599711", "湖北省黄石市",
"861301091", "吉林省长春市",
"861859095", "陕西省安康市",
"861453358", "辽宁省锦州市",
"861532780", "湖北省咸宁市",
"86150936", "河南省开封市",
"861539688", "江苏省盐城市",
"861335428", "辽宁省大连市",
"86182587", "浙江省宁波市",
"861361039", "广东省湛江市",
"861310918", "陕西省汉中市",
"861513522", "山西省大同市",
"861811107", "四川省凉山彝族自治州",
"861470437", "吉林省辽源市",
"861309568", "浙江省绍兴市",
"861821896", "广东省惠州市",
"86170798", "浙江省绍兴市",
"861503663", "河南省新乡市",
"861530317", "河北省沧州市",
"861370737", "湖南省益阳市",
"861876230", "江苏省扬州市",
"861835938", "福建省宁德市",
"861880521", "江苏省徐州市",
"861558017", "湖南省湘潭市",
"861589164", "陕西省延安市",
"861827012", "江西省鹰潭市",
"861328591", "福建省福州市",
"861333583", "浙江省嘉兴市",
"861859340", "湖南省长沙市",
"861509488", "山东省淄博市",
"861770530", "山东省菏泽市",
"861350701", "江西省鹰潭市",
"861884959", "河北省沧州市",
"861334705", "内蒙古通辽市",
"861515966", "福建省漳州市",
"861373505", "浙江省衢州市",
"861597320", "湖南省湘潭市",
"861521476", "浙江省台州市",
"861336553", "安徽省芜湖市",
"861389595", "黑龙江省齐齐哈尔市",
"861506118", "江苏省盐城市",
"861512849", "河北省保定市",
"86152549", "山东省临沂市",
"861320742", "湖南省长沙市",
"86137766", "江苏省南京市",
"861520798", "江西省景德镇市",
"861897290", "湖北省荆门市",
"861592837", "四川省内江市",
"861573866", "河南省新乡市",
"861357624", "江西省九江市",
"861533191", "黑龙江省牡丹江市",
"861835043", "福建省莆田市",
"86133017", "上海市",
"861850796", "江西省吉安市",
"861890636", "山东省潍坊市",
"86155418", "辽宁省葫芦岛市",
"86136336", "黑龙江省哈尔滨市",
"861598354", "四川省雅安市",
"86132226", "江苏省镇江市",
"861351842", "四川省凉山彝族自治州",
"86152780", "广西南宁市",
"86182755", "贵州省遵义市",
"861559853", "内蒙古兴安盟",
"861859503", "宁夏吴忠市",
"861839235", "陕西省西安市",
"861597431", "湖南省湘西土家族苗族自治州",
"861359941", "福建省福州市",
"861776841", "江苏省苏州市",
"861303674", "湖南省邵阳市",
"861530930", "甘肃省临夏回族自治州",
"861360818", "四川省成都市",
"861572170", "贵州省黔南布依族苗族自治州",
"861450998", "新疆喀什地区",
"86189333", "广东省中山市",
"861576908", "新疆伊犁哈萨克自治州",
"861890628", "江苏省南通市",
"86137536", "山西省晋城市",
"861535200", "甘肃省白银市",
"861378799", "湖南省岳阳市",
"861380006", "辽宁省沈阳市",
"861582510", "云南省曲靖市",
"861761487", "内蒙古赤峰市",
"861893289", "河北省承德市",
"861846974", "云南省红河哈尼族彝族自治州",
"861366778", "广西河池市",
"861572720", "湖北省宜昌市",
"861867581", "广东省汕尾市",
"861510580", "浙江省舟山市",
"86137293", "广东省揭阳市",
"861562949", "湖北省黄冈市",
"861824457", "河北省唐山市",
"861334003", "江西省上饶市",
"861568241", "四川省南充市",
"861582555", "浙江省宁波市",
"861760412", "辽宁省鞍山市",
"861360666", "浙江省台州市",
"86132030", "湖南省衡阳市",
"861570633", "山东省日照市",
"86187242", "黑龙江省佳木斯市",
"861559402", "甘肃省陇南市",
"861332927", "安徽省亳州市",
"861351145", "浙江省台州市",
"861308462", "浙江省温州市",
"861313933", "甘肃省平凉市",
"861337134", "山东省滨州市",
"861337817", "四川省广元市",
"861581983", "广东省珠海市",
"861810416", "辽宁省锦州市",
"861860655", "浙江省金华市",
"861335436", "吉林省白城市",
"861500349", "山西省朔州市",
"861888904", "西藏林芝地区",
"86158820", "四川省成都市",
"861813423", "河北省张家口市",
"861524199", "辽宁省辽阳市",
"861508582", "贵州省黔南布依族苗族自治州",
"861880091", "四川省遂宁市",
"861453634", "江苏省南京市",
"861595620", "安徽省铜陵市",
"861386646", "安徽省池州市",
"861324325", "河南省商丘市",
"861399480", "山西省吕梁市",
"861779057", "四川省阿坝藏族羌族自治州",
"86131161", "天津市",
"861332411", "辽宁省大连市",
"861587169", "湖北省武汉市",
"861390820", "四川省成都市",
"86139019", "上海市",
"861309844", "湖北省随州市",
"861882486", "广东省惠州市",
"86186669", "广东省珠海市",
"861860610", "江苏省泰州市",
"861329846", "河南省焦作市",
"861305298", "江苏省泰州市",
"861871916", "广东省湛江市",
"861351906", "甘肃省张掖市",
"86132484", "浙江省杭州市",
"861313766", "河南省周口市",
"861325634", "山东省莱芜市",
"861766010", "山东省济南市",
"86132928", "河北省石家庄市",
"861593101", "河北省邯郸市",
"861777526", "安徽省芜湖市",
"861479090", "安徽省合肥市",
"861316062", "广东省潮州市",
"861590849", "四川省宜宾市",
"86156856", "贵州省铜仁地区",
"861476054", "宁夏固原市",
"861347095", "安徽省马鞍山市",
"861351390", "河南省濮阳市",
"861335058", "四川省德阳市",
"861365575", "浙江省绍兴市",
"861395649", "安徽省安庆市",
"861572413", "广东省揭阳市",
"861534064", "山西省忻州市",
"861315637", "山东省青岛市",
"861311252", "广东省潮州市",
"861867277", "湖北省武汉市",
"861367855", "贵州省黔东南苗族侗族自治州",
"861537926", "甘肃省庆阳市",
"861366708", "江西省南昌市",
"861836548", "江西省宜春市",
"861532816", "四川省雅安市",
"861519243", "山东省济宁市",
"861839388", "甘肃省酒泉市",
"861537745", "湖南省怀化市",
"861318322", "河南省周口市",
"861550083", "宁夏吴忠市",
"861882875", "四川省泸州市",
"861538383", "河北省石家庄市",
"861818248", "陕西省榆林市",
"861340407", "四川省眉山市",
"86184435", "吉林省通化市",
"861334073", "四川省广元市",
"861830617", "江苏省无锡市",
"861535270", "新疆伊犁哈萨克自治州",
"861330631", "山东省威海市",
"861775783", "浙江省宁波市",
"86156273", "广东省惠州市",
"861306914", "吉林省长春市",
"861559640", "陕西省西安市",
"86151915", "陕西省安康市",
"86717", "湖北省宜昌市",
"86145211", "河北省石家庄市",
"861772225", "广东省揭阳市",
"861831682", "广东省云浮市",
"861862430", "辽宁省沈阳市",
"861505242", "江苏省无锡市",
"861380076", "广东省中山市",
"861532668", "黑龙江省齐齐哈尔市",
"861800417", "辽宁省营口市",
"86180383", "广东省东莞市",
"861336161", "江西省南昌市",
"861472617", "四川省成都市",
"861453989", "广东省东莞市",
"86152787", "广西钦州市",
"861329972", "青海省海东地区",
"86170963", "黑龙江省哈尔滨市",
"86188446", "吉林省白城市",
"861373193", "安徽省宣城市",
"861317337", "山东省枣庄市",
"861780433", "吉林省延边朝鲜族自治州",
"861323676", "辽宁省朝阳市",
"861306352", "江苏省徐州市",
"861819000", "四川省绵阳市",
"861705284", "广东省深圳市",
"861808504", "贵州省黔南布依族苗族自治州",
"861508854", "浙江省绍兴市",
"86187205", "江西省上饶市",
"861321871", "江苏省泰州市",
"861537938", "甘肃省天水市",
"861376896", "广西玉林市",
"861359299", "广东省茂名市",
"861584760", "内蒙古赤峰市",
"861560355", "山西省长治市",
"861800649", "山东省临沂市",
"861341116", "广东省广州市",
"861588982", "广东省茂名市",
"86156639", "黑龙江省双鸭山市",
"861889327", "甘肃省酒泉市",
"861560310", "河北省邯郸市",
"86182749", "湖南省长沙市",
"86133010", "北京市",
"861801106", "四川省德阳市",
"861334775", "江苏省镇江市",
"86159363", "河南省许昌市",
"861327334", "河北省衡水市",
"861590328", "河北省衡水市",
"86155379", "河南省洛阳市",
"861501474", "广东省佛山市",
"861350771", "广西南宁市",
"861301191", "河北省保定市",
"861317955", "江苏省宿迁市",
"861550785", "广西玉林市",
"861328451", "黑龙江省哈尔滨市",
"861347525", "山东省东营市",
"861502910", "陕西省咸阳市",
"861882722", "湖北省黄冈市",
"861537043", "江苏省无锡市",
"861564983", "河南省许昌市",
"861534399", "河南省三门峡市",
"861814024", "四川省成都市",
"86150719", "湖北省荆门市",
"861770887", "云南省迪庆藏族自治州",
"861560937", "甘肃省酒泉市",
"861589297", "四川省达州市",
"861471718", "甘肃省甘南藏族自治州",
"861507820", "广西百色市",
"861356811", "四川省宜宾市",
"861553870", "河南省郑州市",
"861336493", "新疆哈密地区",
"861317910", "吉林省长春市",
"861811177", "四川省广元市",
"86182580", "浙江省绍兴市",
"861700679", "浙江省宁波市",
"861334125", "山东省淄博市",
"861373461", "青海省西宁市",
"861870333", "河北省张家口市",
"861322541", "山东省济南市",
"861397349", "湖南省永州市",
"861502955", "陕西省西安市",
"861565126", "江苏省淮安市",
"861811696", "新疆吐鲁番地区",
"861329078", "福建省厦门市",
"861775209", "甘肃省庆阳市",
"861594943", "内蒙古赤峰市",
"861375906", "云南省玉溪市",
"86136723", "广东省肇庆市",
"861880640", "山东省济南市",
"86181567", "安徽省阜阳市",
"861394851", "内蒙古呼和浩特市",
"861820337", "河北省沧州市",
"86185838", "四川省眉山市",
"861452171", "吉林省四平市",
"861813891", "广东省佛山市",
"861301752", "河南省安阳市",
"86183008", "贵州省贵阳市",
"861774842", "四川省泸州市",
"861301086", "云南省昆明市",
"86156179", "河南省郑州市",
"861367389", "河南省南阳市",
"861863408", "河北省衡水市",
"861366868", "山东省泰安市",
"861313485", "内蒙古鄂尔多斯市",
"861376659", "黑龙江省牡丹江市",
"861700585", "浙江省绍兴市",
"86791", "江西省南昌市",
"861319180", "河北省秦皇岛市",
"861889083", "新疆巴音郭楞蒙古自治州",
"861880472", "内蒙古包头市",
"861587757", "陕西省榆林市",
"861367791", "江西省南昌市",
"861861490", "河南省平顶山市",
"861320966", "宁夏石嘴山市",
"861452721", "湖北省荆州市",
"861870342", "山西省大同市",
"861582919", "陕西省渭南市",
"861335314", "吉林省长春市",
"861867706", "广西南宁市",
"861500903", "新疆和田地区",
"86186875", "云南省昆明市",
"86147522", "江苏省徐州市",
"861355960", "福建省宁德市",
"861337546", "山东省东营市",
"861770372", "河南省安阳市",
"861536438", "湖南省张家界市",
"861820955", "宁夏中卫市",
"861309419", "湖北省咸宁市",
"861810334", "河北省秦皇岛市",
"861866660", "广东省惠州市",
"86151760", "河北省邯郸市",
"861303159", "河北省沧州市",
"861352330", "河南省安阳市",
"861358135", "湖北省荆门市",
"861816466", "云南省保山市",
"86133240", "辽宁省沈阳市",
"861506638", "山东省烟台市",
"861780670", "广东省广州市",
"861787608", "广东省揭阳市",
"861820910", "陕西省咸阳市",
"861874023", "辽宁省辽阳市",
"861845482", "山东省泰安市",
"861339619", "湖北省恩施土家族苗族自治州",
"86182699", "安徽省阜阳市",
"861778997", "西藏那曲地区",
"861511970", "广东省茂名市",
"86158615", "江苏省无锡市",
"861380564", "安徽省六安市",
"861536426", "湖南省衡阳市",
"861862673", "吉林省吉林市",
"86182576", "浙江省台州市",
"861471606", "广东省肇庆市",
"861847404", "湖南省常德市",
"861304030", "吉林省四平市",
"861781689", "浙江省杭州市",
"861380329", "河北省邯郸市",
"86159902", "浙江省宁波市",
"861500168", "新疆昌吉回族自治州",
"861473801", "河南省南阳市",
"86177997", "新疆乌鲁木齐市",
"861863991", "河南省焦作市",
"861342107", "广东省潮州市",
"861339447", "吉林省长春市",
"861459454", "陕西省商洛市",
"861877898", "广西南宁市",
"861705351", "山西省太原市",
"861374279", "江西省南昌市",
"861335952", "黑龙江省齐齐哈尔市",
"861530539", "山东省临沂市",
"861453837", "四川省广元市",
"861577478", "内蒙古巴彦淖尔市",
"86131113", "河北省邯郸市",
"86158318", "河北省邯郸市",
"86151530", "山东省菏泽市",
"861889785", "广西玉林市",
"861325580", "浙江省舟山市",
"861396630", "安徽省六安市",
"861802117", "江苏省无锡市",
"861517131", "湖北省孝感市",
"861309647", "四川省广元市",
"86135071", "湖北省武汉市",
"861356790", "浙江省宁波市",
"86181737", "湖南省益阳市",
"861322290", "江苏省无锡市",
"861363390", "河南省新乡市",
"861534576", "浙江省台州市",
"861350586", "浙江省台州市",
"861308425", "河南省漯河市",
"861366544", "山东省烟台市",
"861565138", "江苏省南通市",
"861556334", "山东省日照市",
"861853959", "河南省洛阳市",
"861369384", "河南省南阳市",
"861538027", "江苏省连云港市",
"861845894", "浙江省台州市",
"861808935", "甘肃省武威市",
"86132181", "江苏省苏州市",
"861345191", "江苏省南京市",
"86189726", "湖北省孝感市",
"861580573", "浙江省嘉兴市",
"86187994", "新疆和田地区",
"86139255", "广东省东莞市",
"861569429", "辽宁省葫芦岛市",
"861369602", "四川省南充市",
"861365689", "浙江省台州市",
"861820468", "黑龙江省鹤岗市",
"861560263", "广东省河源市",
"861823040", "河北省邯郸市",
"861576823", "广东省湛江市",
"861884550", "黑龙江省绥化市",
"861501397", "广东省惠州市",
"861856989", "河南省商丘市",
"861584800", "内蒙古呼伦贝尔市",
"861560889", "云南省昆明市",
"861770939", "甘肃省陇南市",
"861313942", "甘肃省定西市",
"861576002", "四川省成都市",
"861354150", "四川省内江市",
"861315117", "江苏省苏州市",
"861315834", "贵州省黔南布依族苗族自治州",
"861369672", "安徽省淮南市",
"86152776", "广西百色市",
"861319646", "江苏省扬州市",
"861363976", "青海省西宁市",
"861880853", "贵州省安顺市",
"861898729", "云南省昆明市",
"861510634", "山东省莱芜市",
"861321761", "广东省河源市",
"86155504", "山东省济南市",
"86183985", "四川省广安市",
"86153950", "安徽省合肥市",
"861534506", "福建省漳州市",
"861818356", "云南省曲靖市",
"861847583", "广东省中山市",
"861328240", "浙江省杭州市",
"86181730", "湖南省岳阳市",
"861589796", "湖北省襄樊市",
"861815131", "江苏省徐州市",
"861369440", "吉林省四平市",
"861385222", "江苏省徐州市",
"86139249", "广东省中山市",
"861361378", "河南省开封市",
"86158479", "内蒙古锡林郭勒盟",
"861479929", "新疆乌鲁木齐市",
"861317519", "浙江省宁波市",
"861892334", "广东省中山市",
"86151537", "山东省济宁市",
"861580340", "山西省太原市",
"861457029", "江西省萍乡市",
"861350861", "湖北省荆州市",
"861511396", "广东省江门市",
"861570470", "内蒙古呼伦贝尔市",
"861314061", "河南省信阳市",
"861318365", "四川省眉山市",
"861334865", "湖南省郴州市",
"861524683", "黑龙江省鹤岗市",
"861555661", "安徽省安庆市",
"861327416", "辽宁省锦州市",
"861520637", "山东省济宁市",
"86903", "新疆和田地区",
"861847474", "湖南省怀化市",
"86159526", "江苏省泰州市",
"861373934", "甘肃省庆阳市",
"86178399", "河南省郑州市",
"861333397", "河南省信阳市",
"861898857", "广东省中山市",
"861862603", "江苏省徐州市",
"861592989", "陕西省西安市",
"86187681", "浙江省杭州市",
"861570642", "山东省青岛市",
"861774906", "陕西省榆林市",
"86135680", "四川省内江市",
"861568020", "四川省内江市",
"86185346", "山西省太原市",
"861342177", "广东省云浮市",
"861507160", "湖北省十堰市",
"861568590", "贵州省贵阳市",
"861340394", "河南省周口市",
"861590414", "辽宁省本溪市",
"86159311", "河北省石家庄市",
"861533086", "辽宁省本溪市",
"861310012", "山西省大同市",
"861533752", "福建省厦门市",
"861478950", "湖南省岳阳市",
"861363842", "湖南省湘潭市",
"861365934", "甘肃省武威市",
"86151767", "河北省承德市",
"861875249", "江苏省泰州市",
"861787678", "广东省阳江市",
"861804915", "陕西省安康市",
"861770684", "浙江省金华市",
"861770302", "广东省江门市",
"861817742", "广西梧州市",
"861596931", "云南省玉溪市",
"861500973", "青海省黄南藏族自治州",
"861311087", "福建省福州市",
"861351833", "四川省广元市",
"861323264", "广东省河源市",
"861899750", "新疆克孜勒苏柯尔克孜自治州",
"861768914", "西藏林芝地区",
"861314784", "辽宁省大连市",
"86159945", "广西玉林市",
"861362529", "江苏省苏州市",
"86147906", "安徽省安庆市",
"86130267", "广东省佛山市",
"861571489", "内蒙古包头市",
"861829531", "宁夏银川市",
"861377220", "陕西省汉中市",
"861569059", "河北省张家口市",
"861393377", "河北省张家口市",
"86170911", "北京市",
"861863478", "山西省吕梁市",
"861532547", "浙江省湖州市",
"861308010", "河南省濮阳市",
"861319514", "贵州省黔南布依族苗族自治州",
"861338295", "江苏省连云港市",
"861885829", "浙江省杭州市",
"861343270", "广东省清远市",
"861347562", "山东省淄博市",
"861528699", "河南省安阳市",
"861316595", "浙江省杭州市",
"861303807", "山西省阳泉市",
"861313267", "广西钦州市",
"861322620", "广东省梅州市",
"861887648", "福建省泉州市",
"86181560", "安徽省合肥市",
"861775279", "湖南省长沙市",
"861806326", "山东省潍坊市",
"861479641", "江西省吉安市",
"86131055", "浙江省宁波市",
"861538457", "陕西省宝鸡市",
"861811238", "江苏省无锡市",
"861705030", "陕西省西安市",
"861563898", "河南省南阳市",
"861320733", "湖南省株洲市",
"861324787", "江西省赣州市",
"861836667", "山东省枣庄市",
"861700154", "江苏省无锡市",
"861450522", "吉林省白城市",
"861308930", "吉林省延边朝鲜族自治州",
"861327501", "福建省福州市",
"861392309", "广东省广州市",
"861505594", "安徽省六安市",
"861583330", "河北省邯郸市",
"861372071", "陕西省榆林市",
"86152150", "重庆市",
"8618520", "广东省广州市",
"861808420", "贵州省遵义市",
"861572085", "江苏省常州市",
"861302879", "甘肃省兰州市",
"861523647", "河南省新乡市",
"861863395", "河北省唐山市",
"86189251", "广东省广州市",
"861357542", "浙江省温州市",
"86186038", "河南省郑州市",
"861817499", "广西百色市",
"861353919", "广东省梅州市",
"861364949", "广西玉林市",
"861760426", "辽宁省大连市",
"861873909", "河南省洛阳市",
"861339761", "湖南省长沙市",
"86150817", "河北省邯郸市",
"861890862", "湖北省武汉市",
"861864867", "内蒙古鄂尔多斯市",
"861369963", "四川省绵阳市",
"861386703", "浙江省衢州市",
"861333520", "山东省淄博市",
"86133694", "甘肃省兰州市",
"861348773", "湖南省株洲市",
"861302157", "山东省临沂市",
"861338828", "四川省泸州市",
"861819882", "广东省东莞市",
"861317284", "广东省揭阳市",
"861583421", "山西省晋城市",
"86188956", "安徽省蚌埠市",
"861515559", "安徽省宣城市",
"861833147", "河北省衡水市",
"861454307", "黑龙江省哈尔滨市",
"861550450", "黑龙江省哈尔滨市",
"861814242", "陕西省西安市",
"861811981", "安徽省滁州市",
"861810422", "辽宁省鞍山市",
"86186927", "湖南省益阳市",
"861476570", "四川省成都市",
"861830563", "安徽省宣城市",
"86188562", "安徽省铜陵市",
"861471488", "广东省深圳市",
"861308317", "安徽省安庆市",
"861453851", "甘肃省临夏回族自治州",
"861389780", "辽宁省葫芦岛市",
"861528120", "四川省攀枝花市",
"861550415", "辽宁省丹东市",
"861301549", "山西省大同市",
"861768034", "湖南省衡阳市",
"861534411", "内蒙古呼和浩特市",
"861502284", "新疆克孜勒苏柯尔克孜自治州",
"861452839", "四川省广元市",
"861775100", "江苏省南京市",
"861844970", "新疆巴音郭楞蒙古自治州",
"861320950", "宁夏银川市",
"861839659", "福建省南平市",
"861510523", "江苏省淮安市",
"86131933", "陕西省西安市",
"861899048", "四川省甘孜藏族自治州",
"861586607", "山东省济宁市",
"861554572", "黑龙江省鸡西市",
"861330582", "浙江省湖州市",
"861338836", "四川省内江市",
"861577140", "内蒙古赤峰市",
"861557028", "江西省萍乡市",
"861575225", "云南省红河哈尼族彝族自治州",
"861881206", "河北省廊坊市",
"861350049", "辽宁省辽阳市",
"861320915", "陕西省安康市",
"861373014", "河北省承德市",
"861338349", "山西省朔州市",
"86188732", "湖南省湘潭市",
"861319863", "四川省凉山彝族自治州",
"861530462", "黑龙江省齐齐哈尔市",
"861452346", "河南省焦作市",
"86184344", "山西省太原市",
"861323743", "湖南省湘西土家族苗族自治州",
"861319289", "广东省韶关市",
"861800787", "广西桂林市",
"861526533", "山东省淄博市",
"86151675", "浙江省绍兴市",
"861762581", "江苏省无锡市",
"861333090", "四川省绵阳市",
"86158729", "湖北省荆门市",
"861529159", "陕西省西安市",
"861390883", "云南省临沧市",
"861380645", "山东省烟台市",
"861816450", "浙江省衢州市",
"861899933", "新疆石河子市",
"861346530", "山东省菏泽市",
"861775413", "安徽省宿州市",
"861820351", "山西省太原市",
"861394837", "内蒙古鄂尔多斯市",
"861390269", "广东省东莞市",
"861894811", "广东省茂名市",
"861390156", "江苏省苏州市",
"861510795", "江西省宜春市",
"861361495", "辽宁省丹东市",
"861364621", "江苏省苏州市",
"861819494", "新疆伊犁哈萨克自治州",
"861581920", "广东省韶关市",
"86151378", "河南省开封市",
"861303250", "江苏省常州市",
"861819185", "陕西省西安市",
"861760438", "吉林省松原市",
"86152426", "辽宁省大连市",
"861587731", "陕西省延安市",
"861310379", "河南省洛阳市",
"861816415", "湖北省黄冈市",
"861529266", "新疆和田地区",
"86181051", "江苏省南京市",
"86180996", "新疆乌鲁木齐市",
"861760782", "广西来宾市",
"861709987", "广东省珠海市",
"861843275", "河北省唐山市",
"861343857", "四川省达州市",
"861310309", "河北省邢台市",
"861813344", "安徽省马鞍山市",
"861361510", "江苏省徐州市",
"861899766", "新疆阿克苏地区",
"861847641", "广东省茂名市",
"861875140", "江苏省连云港市",
"86189476", "内蒙古赤峰市",
"861478311", "河南省三门峡市",
"861596335", "山东省临沂市",
"861346887", "陕西省延安市",
"861865979", "福建省龙岩市",
"861881867", "广东省惠州市",
"861369728", "湖北省宜昌市",
"861304337", "吉林省延边朝鲜族自治州",
"86158532", "山东省青岛市",
"861700811", "江苏省盐城市",
"86188258", "广东省东莞市",
"861331078", "贵州省六盘水市",
"861511888", "广东省广州市",
"861538431", "广东省阳江市",
"861361555", "安徽省马鞍山市",
"861808050", "四川省巴中市",
"861381949", "浙江省杭州市",
"86136588", "云南省昆明市",
"861332399", "河南省许昌市",
"861362983", "河南省安阳市",
"86188529", "江苏省苏州市",
"861853074", "河南省新乡市",
"861586081", "福建省福州市",
"861368861", "山东省济南市",
"86184706", "江西省吉安市",
"861332781", "江苏省南京市",
"861867632", "广东省清远市",
"861563695", "黑龙江省齐齐哈尔市",
"861315272", "山西省大同市",
"861365246", "广东省东莞市",
"861458396", "福建省南平市",
"861309273", "湖北省黄冈市",
"861304955", "贵州省黔东南苗族侗族自治州",
"861775170", "江苏省苏州市",
"861806741", "浙江省宁波市",
"861519196", "陕西省宝鸡市",
"861399755", "湖北省荆州市",
"861358204", "河北省石家庄市",
"861343729", "湖北省武汉市",
"861550020", "吉林省白山市",
"861807024", "江西省九江市",
"861829557", "宁夏银川市",
"861810052", "福建省泉州市",
"861810786", "广西百色市",
"861809599", "新疆乌鲁木齐市",
"861458900", "广东省广州市",
"861538320", "河北省邯郸市",
"861554502", "黑龙江省齐齐哈尔市",
"861514820", "内蒙古包头市",
"861551947", "贵州省六盘水市",
"861809029", "四川省广安市",
"861325851", "黑龙江省牡丹江市",
"861594918", "江苏省淮安市",
"861479474", "内蒙古乌兰察布市",
"86155651", "河南省安阳市",
"861550590", "福建省福州市",
"861582039", "广东省梅州市",
"861476500", "北京市",
"861458685", "湖南省湘潭市",
"861336739", "湖南省邵阳市",
"861592523", "云南省昆明市",
"861818360", "云南省临沧市",
"861840992", "新疆伊犁哈萨克自治州",
"861871922", "广东省佛山市",
"861868627", "内蒙古通辽市",
"861509718", "甘肃省陇南市",
"861551262", "河北省廊坊市",
"86152284", "四川省绵阳市",
"861328149", "四川省成都市",
"861815879", "浙江省金华市",
"861898831", "云南省临沧市",
"86182840", "四川省广元市",
"861370895", "山东省青岛市",
"861348703", "湖北省黄冈市",
"86137388", "浙江省宁波市",
"861332064", "四川省遂宁市",
"861773949", "河南省焦作市",
"861569904", "新疆昌吉回族自治州",
"86135916", "辽宁省沈阳市",
"861561988", "陕西省延安市",
"86186920", "湖南省衡阳市",
"861373246", "浙江省绍兴市",
"861454377", "山东省潍坊市",
"861354166", "四川省自贡市",
"861575695", "四川省攀枝花市",
"861474713", "内蒙古乌海市",
"861825154", "江苏省无锡市",
"861539359", "甘肃省白银市",
"861327465", "黑龙江省大庆市",
"861873979", "河南省周口市",
"86150810", "河北省邯郸市",
"861347439", "陕西省榆林市",
"861479583", "广西南宁市",
"861884881", "河南省安阳市",
"861886307", "山东省滨州市",
"861334816", "江苏省常州市",
"861800362", "黑龙江省齐齐哈尔市",
"861318316", "河南省安阳市",
"861532822", "四川省绵阳市",
"861504588", "黑龙江省大庆市",
"861560744", "湖南省张家界市",
"861878768", "云南省迪庆藏族自治州",
"861311444", "湖北省十堰市",
"861855598", "安徽省宣城市",
"861869445", "陕西省榆林市",
"861330854", "贵州省黔南布依族苗族自治州",
"861450847", "江苏省常州市",
"861334668", "河南省新乡市",
"861533549", "山东省临沂市",
"861815157", "江苏省苏州市",
"861459233", "四川省成都市",
"86177705", "江西省宜春市",
"861816020", "新疆乌鲁木齐市",
"861302809", "山西省大同市",
"861556052", "内蒙古巴彦淖尔市",
"86152157", "浙江省丽水市",
"861780799", "江西省萍乡市",
"861380813", "四川省乐山市",
"861346939", "湖南省永州市",
"861830792", "江西省九江市",
"861539182", "安徽省安庆市",
"861331339", "河北省邢台市",
"861360650", "浙江省杭州市",
"861314414", "广东省佛山市",
"861303441", "湖北省黄石市",
"861378985", "山东省青岛市",
"861319123", "山西省阳泉市",
"861889020", "湖南省长沙市",
"861846429", "山东省滨州市",
"861882608", "广东省广州市",
"861536412", "湖南省岳阳市",
"861832451", "黑龙江省哈尔滨市",
"861513847", "河南省郑州市",
"861709346", "广东省深圳市",
"861360615", "江苏省无锡市",
"86133128", "广东省广州市",
"861893180", "河北省衡水市",
"861779031", "四川省达州市",
"861890825", "重庆市",
"861317030", "湖南省长沙市",
"861368701", "江西省鹰潭市",
"861816241", "湖北省武汉市",
"861331846", "广东省东莞市",
"86180084", "湖南省长沙市",
"861840536", "山东省潍坊市",
"861899485", "江苏省扬州市",
"861590784", "广西桂林市",
"861319773", "广西桂林市",
"861459242", "四川省眉山市",
"861537507", "安徽省宿州市",
"861310456", "黑龙江省黑河市",
"861829682", "江西省景德镇市",
"86170087", "云南省昆明市",
"86138874", "云南省曲靖市",
"861881707", "湖南省常德市",
"861458579", "山东省菏泽市",
"861332576", "浙江省台州市",
"861471743", "江西省南昌市",
"861524290", "辽宁省丹东市",
"861523844", "河南省三门峡市",
"861320559", "安徽省黄山市",
"861810465", "黑龙江省大庆市",
"861868796", "云南省丽江市",
"861300597", "广西梧州市",
"861700790", "江西省九江市",
"861860858", "贵州省六盘水市",
"861560508", "福建省福州市",
"861556958", "新疆喀什地区",
"861810571", "浙江省杭州市",
"861864664", "黑龙江省哈尔滨市",
"861351527", "江苏省常州市",
"861824431", "四川省眉山市",
"861575947", "福建省泉州市",
"861870669", "山东省潍坊市",
"86159455", "黑龙江省绥化市",
"861829304", "甘肃省定西市",
"861305825", "广东省汕尾市",
"861566409", "河南省新乡市",
"861454185", "山西省长治市",
"861323488", "内蒙古巴彦淖尔市",
"861579803", "江西省抚州市",
"861519677", "四川省南充市",
"861325523", "江苏省南通市",
"861565112", "江苏省苏州市",
"861397295", "湖北省鄂州市",
"861302769", "河南省安阳市",
"86893", "西藏山南地区",
"861867643", "广东省中山市",
"86139584", "浙江省金华市",
"861306034", "陕西省咸阳市",
"861300027", "山东省烟台市",
"861339871", "云南省昆明市",
"861890772", "广西柳州市",
"861523568", "山西省运城市",
"861331972", "新疆伊犁哈萨克自治州",
"861530425", "辽宁省本溪市",
"861591735", "广东省广州市",
"861476979", "山东省菏泽市",
"861572448", "辽宁省阜新市",
"861554421", "河南省洛阳市",
"86150460", "黑龙江省哈尔滨市",
"861503902", "河南省开封市",
"861452258", "浙江省金华市",
"861470451", "黑龙江省哈尔滨市",
"861897199", "湖北省鄂州市",
"861803639", "江苏省苏州市",
"861556465", "山东省潍坊市",
"861384919", "河南省郑州市",
"861576880", "广东省云浮市",
"861573815", "河南省平顶山市",
"861707834", "云南省昭通市",
"861472792", "陕西省榆林市",
"861780254", "江苏省宿迁市",
"861871598", "河北省张家口市",
"861705519", "安徽省合肥市",
"861333929", "安徽省合肥市",
"861889590", "云南省保山市",
"861539406", "甘肃省天水市",
"861325795", "江西省宜春市",
"861573850", "河南省郑州市",
"861388684", "湖北省十堰市",
"861772898", "广东省茂名市",
"861810958", "宁夏银川市",
"86159600", "福建省福州市",
"861364540", "山东省菏泽市",
"861801341", "江苏省无锡市",
"861556571", "河南省安阳市",
"861569535", "青海省果洛藏族自治州",
"861530753", "广东省梅州市",
"861313013", "辽宁省本溪市",
"861539476", "内蒙古赤峰市",
"861526542", "山东省青岛市",
"861847520", "广东省惠州市",
"861360843", "河南省许昌市",
"861556501", "河南省商丘市",
"861380997", "新疆和田地区",
"861560951", "宁夏银川市",
"86135982", "河南省南阳市",
"861557922", "江西省九江市",
"861893646", "江苏省扬州市",
"861359190", "辽宁省辽阳市",
"861889415", "甘肃省白银市",
"861867112", "湖北省鄂州市",
"861310026", "湖南省衡阳市",
"86159607", "福建省泉州市",
"861354826", "四川省德阳市",
"861899942", "新疆乌鲁木齐市",
"861570524", "江苏省宿迁市",
"861895457", "山东省烟台市",
"861378442", "河北省保定市",
"86150467", "黑龙江省哈尔滨市",
"861365358", "山西省吕梁市",
"86158975", "湖北省宜昌市",
"861871458", "黑龙江省伊春市",
"86183489", "河北省保定市",
"861533940", "甘肃省武威市",
"861478742", "云南省曲靖市",
"861889450", "甘肃省金昌市",
"861564364", "吉林省长春市",
"861879493", "甘肃省庆阳市",
"861311819", "四川省绵阳市",
"861318434", "浙江省宁波市",
"861339801", "西藏拉萨市",
"861890702", "江西省九江市",
"86153652", "江苏省无锡市",
"861598032", "福建省泉州市",
"861869088", "新疆乌鲁木齐市",
"861550999", "新疆伊犁哈萨克自治州",
"861786986", "云南省西双版纳傣族自治州",
"861331902", "新疆哈密地区",
"861364373", "河南省新乡市",
"861334547", "新疆克拉玛依市",
"861454554", "新疆博尔塔拉蒙古自治州",
"861345549", "山东省莱芜市",
"86137201", "湖北省武汉市",
"86130534", "山东省德州市",
"861450516", "吉林省通化市",
"861323732", "湖南省湘潭市",
"861475656", "河北省衡水市",
"861398993", "西藏山南地区",
"861524620", "黑龙江省绥化市",
"861783956", "河南省南阳市",
"86138633", "山东省日照市",
"861579873", "云南省红河哈尼族彝族自治州",
"861519607", "四川省泸州市",
"861806312", "山东省威海市",
"861355788", "广西河池市",
"861453093", "山西省阳泉市",
"861320499", "湖南省怀化市",
"861583502", "山西省大同市",
"86180430", "吉林省长春市",
"861597027", "江西省宜春市",
"86189487", "广东省深圳市",
"861814233", "陕西省渭南市",
"861552150", "广东省广州市",
"861558355", "四川省攀枝花市",
"861510851", "贵州省贵阳市",
"861899876", "广东省河源市",
"86150625", "江苏省苏州市",
"861560578", "浙江省丽水市",
"861867850", "山东省聊城市",
"861810287", "广东省汕尾市",
"86130764", "广东省潮州市",
"861458509", "河南省南阳市",
"861809990", "新疆克拉玛依市",
"861599496", "广东省潮州市",
"861385216", "江苏省扬州市",
"86170080", "重庆市",
"86159449", "吉林省白山市",
"86138279", "广东省韶关市",
"861362435", "吉林省通化市",
"861450644", "黑龙江省大庆市",
"861862746", "湖南省永州市",
"86153609", "广东省惠州市",
"861811212", "江苏省扬州市",
"861313750", "河南省平顶山市",
"86150328", "河北省石家庄市",
"861365747", "湖南省衡阳市",
"86183826", "四川省广安市",
"861538964", "陕西省宝鸡市",
"861506143", "江苏省盐城市",
"861835281", "江苏省连云港市",
"861894790", "内蒙古锡林郭勒盟",
"86147830", "河南省平顶山市",
"861862925", "陕西省西安市",
"861332506", "山东省东营市",
"861322683", "广东省汕头市",
"861310038", "湖南省郴州市",
"861368771", "广西南宁市",
"861771166", "湖南省常德市",
"861327422", "辽宁省朝阳市",
"861568785", "云南省昆明市",
"861354838", "四川省阿坝藏族羌族自治州",
"861361919", "陕西省铜川市",
"861337205", "江苏省宿迁市",
"861319703", "湖北省黄石市",
"86152098", "安徽省合肥市",
"861781747", "广东省惠州市",
"861338973", "青海省黄南藏族自治州",
"861523995", "河南省濮阳市",
"861566248", "山东省潍坊市",
"861570094", "新疆吐鲁番地区",
"861800325", "河北省唐山市",
"861309789", "广西北海市",
"861377283", "陕西省汉中市",
"861328368", "山西省大同市",
"861381540", "江苏省南京市",
"861310596", "福建省宁德市",
"861470021", "安徽省六安市",
"861377869", "四川省阿坝藏族羌族自治州",
"861309391", "陕西省汉中市",
"861771259", "江苏省泰州市",
"861882678", "广东省汕头市",
"861394989", "河南省漯河市",
"861850411", "辽宁省大连市",
"861889770", "广西钦州市",
"861557868", "广西南宁市",
"861559549", "宁夏中卫市",
"861821959", "广东省惠州市",
"861834415", "广东省梅州市",
"861470701", "江西省鹰潭市",
"861391216", "江苏省连云港市",
"861317130", "内蒙古兴安盟",
"86158947", "新疆乌鲁木齐市",
"861325575", "浙江省绍兴市",
"86157658", "黑龙江省大庆市",
"861453505", "山东省东营市",
"861596631", "山东省济南市",
"861884896", "河南省洛阳市",
"861834450", "广东省肇庆市",
"861318719", "湖南省邵阳市",
"861856934", "湖南省娄底市",
"861311971", "青海省西宁市",
"86188989", "海南省海口市",
"861454783", "山东省淄博市",
"86155623", "山东省济宁市",
"861319023", "辽宁省丹东市",
"861553359", "河北省唐山市",
"86136928", "广东省惠州市",
"86187380", "河南省商丘市",
"861895127", "江苏省镇江市",
"86157355", "山西省长治市",
"861369846", "江西省吉安市",
"861530473", "内蒙古乌海市",
"861365634", "山东省莱芜市",
"861319872", "四川省乐山市",
"86151797", "江西省赣州市",
"861350437", "吉林省辽源市",
"86135381", "广东省深圳市",
"861535009", "江西省萍乡市",
"86136484", "重庆市",
"861389547", "宁夏银川市",
"861479941", "新疆阿克苏地区",
"861822430", "四川省内江市",
"861570876", "云南省文山壮族苗族自治州",
"861890592", "福建省厦门市",
"86152273", "河北省邢台市",
"861325193", "浙江省嘉兴市",
"861471842", "广东省茂名市",
"861812803", "广东省东莞市",
"86181590", "福建省莆田市",
"861459513", "云南省临沧市",
"861384801", "内蒙古包头市",
"861327810", "吉林省长春市",
"86133316", "吉林省长春市",
"861586526", "山东省济南市",
"861508957", "广东省阳江市",
"861505864", "浙江省台州市",
"861341936", "四川省遂宁市",
"861898741", "云南省曲靖市",
"861522291", "安徽省合肥市",
"861336336", "河北省唐山市",
"861576716", "广东省云浮市",
"861597707", "广西桂林市",
"861558272", "山西省临汾市",
"861827277", "河南省南阳市",
"861327855", "吉林省通化市",
"861530584", "浙江省宁波市",
"861811370", "四川省广元市",
"861819448", "甘肃省白银市",
"861580439", "吉林省白山市",
"861304858", "贵州省遵义市",
"861520310", "河北省邯郸市",
"861700570", "浙江省杭州市",
"86152639", "山东省临沂市",
"861479629", "广西北海市",
"861516411", "辽宁省铁岭市",
"861313470", "内蒙古呼伦贝尔市",
"861586538", "山东省泰安市",
"861810389", "河南省焦作市",
"861342532", "广东省汕头市",
"86186749", "湖南省岳阳市",
"861575789", "浙江省嘉兴市",
"86185272", "湖北省恩施土家族苗族自治州",
"86145293", "广东省深圳市",
"861340313", "河北省张家口市",
"861810791", "江西省南昌市",
"861590493", "辽宁省盘锦市",
"861881457", "黑龙江省大兴安岭地区",
"861319175", "河北省唐山市",
"861890873", "云南省红河哈尼族彝族自治州",
"861888266", "四川省广安市",
"86181023", "重庆市",
"861510934", "甘肃省庆阳市",
"861361871", "云南省昆明市",
"861475569", "安徽省安庆市",
"861458799", "湖南省长沙市",
"861311558", "黑龙江省伊春市",
"861586096", "福建省南平市",
"86138250", "广东省广州市",
"861565012", "山东省威海市",
"861520355", "山西省长治市",
"861768993", "福建省漳州市",
"861787551", "广东省梅州市",
"861841438", "内蒙古阿拉善盟",
"861836242", "江苏省扬州市",
"861337223", "江苏省徐州市",
"861369972", "广东省广州市",
"861300777", "青海省西宁市",
"86156787", "广西来宾市",
"861458381", "福建省漳州市",
"861313642", "浙江省舟山市",
"861890022", "福建省厦门市",
"86131494", "河北省石家庄市",
"861332796", "江苏省淮安市",
"861882319", "广东省深圳市",
"861363676", "陕西省宝鸡市",
"861370998", "新疆喀什地区",
"861774606", "福建省南平市",
"861570942", "甘肃省金昌市",
"861362541", "山东省济南市",
"861772419", "广东省珠海市",
"861768546", "山东省东营市",
"86159610", "江苏省泰州市",
"861381325", "江苏省徐州市",
"861348762", "湖南省邵阳市",
"861327152", "河南省洛阳市",
"861338068", "广东省惠州市",
"861319593", "甘肃省武威市",
"86147599", "福建省南平市",
"861472893", "西藏山南地区",
"861592689", "湖北省襄樊市",
"86186580", "浙江省舟山市",
"86156555", "安徽省马鞍山市",
"861305592", "福建省厦门市",
"861830572", "浙江省湖州市",
"861310706", "湖南省郴州市",
"861899369", "甘肃省甘南藏族自治州",
"861520937", "甘肃省酒泉市",
"86182622", "江苏省无锡市",
"861858284", "四川省达州市",
"86155898", "山东省青岛市",
"861800540", "山东省菏泽市",
"861871136", "湖南省株洲市",
"861894343", "吉林省通化市",
"861367334", "河南省安阳市",
"861551203", "河北省唐山市",
"861368451", "黑龙江省哈尔滨市",
"861588497", "四川省巴中市",
"861531535", "山东省烟台市",
"861804843", "四川省攀枝花市",
"861508288", "四川省达州市",
"861319453", "黑龙江省牡丹江市",
"861830502", "浙江省衢州市",
"861310776", "浙江省温州市",
"861530852", "贵州省遵义市",
"861360742", "湖南省株洲市",
"861309947", "云南省德宏傣族景颇族自治州",
"861356054", "广东省湛江市",
"861335652", "广东省湛江市",
"861331237", "贵州省黔南布依族苗族自治州",
"861572377", "广西钦州市",
"861809869", "安徽省淮南市",
"861807548", "安徽省黄山市",
"861700343", "重庆市",
"861588557", "贵州省黔南布依族苗族自治州",
"861368591", "福建省泉州市",
"86159617", "江苏省无锡市",
"861888807", "江苏省扬州市",
"861831211", "广东省阳江市",
"861316816", "广东省云浮市",
"861785801", "浙江省金华市",
"861478843", "河南省洛阳市",
"86186587", "浙江省温州市",
"861862973", "吉林省松原市",
"861886085", "江苏省扬州市",
"861337914", "陕西省商洛市",
"86138257", "广东省东莞市",
"861340731", "湖南省长沙市",
"861522621", "宁夏银川市",
"861770639", "山东省青岛市",
"861590553", "安徽省芜湖市",
"861881597", "福建省泉州市",
"861452749", "湖南省长沙市",
"861800373", "河南省新乡市",
"861377990", "福建省漳州市",
"861894570", "黑龙江省大兴安岭地区",
"861338746", "湖南省永州市",
"861812592", "广东省湛江市",
"86136226", "广东省东莞市",
"86132336", "山西省太原市",
"861782897", "四川省自贡市",
"861335393", "河南省濮阳市",
"861868506", "贵州省黔南布依族苗族自治州",
"86186755", "广东省深圳市",
"86156780", "广西柳州市",
"861853659", "山西省阳泉市",
"861857961", "江西省吉安市",
"861568183", "四川省广安市",
"861816860", "江苏省镇江市",
"861313400", "江西省宜春市",
"861571434", "吉林省四平市",
"861808635", "湖北省荆州市",
"861560798", "江西省景德镇市",
"861855544", "安徽省六安市",
"86137835", "河南省郑州市",
"861840717", "湖北省宜昌市",
"86136030", "广东省深圳市",
"861855868", "福建省泉州市",
"861506043", "福建省福州市",
"861528241", "四川省达州市",
"861522949", "陕西省咸阳市",
"861860519", "江苏省常州市",
"861337693", "福建省宁德市",
"861827207", "湖北省襄樊市",
"861326778", "广东省汕头市",
"861890452", "黑龙江省齐齐哈尔市",
"861530155", "江苏省苏州市",
"861366916", "陕西省汉中市",
"861886783", "浙江省丽水市",
"861552050", "四川省甘孜藏族自治州",
"861870556", "安徽省安庆市",
"861570806", "西藏昌都地区",
"861776169", "河南省濮阳市",
"861589245", "四川省南充市",
"861811996", "安徽省阜阳市",
"861855616", "江苏省徐州市",
"86189223", "广东省广州市",
"861872607", "安徽省安庆市",
"861592934", "陕西省延安市",
"86181597", "福建省漳州市",
"861384871", "内蒙古呼和浩特市",
"861366361", "山西省太原市",
"861837009", "江西省吉安市",
"861453193", "山西省晋中市",
"861594643", "黑龙江省七台河市",
"861584885", "内蒙古通辽市",
"86150116", "广东省佛山市",
"861311901", "新疆塔城地区",
"861339919", "陕西省铜川市",
"861820610", "江苏省镇江市",
"86182669", "浙江省金华市",
"861370565", "安徽省合肥市",
"861780970", "青海省海北藏族自治州",
"861535079", "河北省沧州市",
"861315889", "四川省绵阳市",
"861364325", "河北省沧州市",
"861530403", "辽宁省大连市",
"861348387", "河北省承德市",
"861319802", "四川省内江市",
"861585948", "福建省泉州市",
"861811543", "江苏省常州市",
"861337352", "河北省保定市",
"861453461", "黑龙江省大兴安岭地区",
"86187387", "河南省南阳市",
"861315263", "广西桂林市",
"861370471", "内蒙古呼和浩特市",
"86157349", "山西省朔州市",
"861835118", "江苏省苏州市",
"861570485", "内蒙古兴安盟",
"861879784", "江西省抚州市",
"861820655", "山东省滨州市",
"861889700", "青海省海北藏族自治州",
"861325505", "福建省福州市",
"861453575", "福建省漳州市",
"86158940", "新疆喀什地区",
"861470771", "广西南宁市",
"861510575", "浙江省绍兴市",
"861527054", "江西省上饶市",
"861363718", "安徽省宿州市",
"861310581", "浙江省杭州市",
"861816700", "浙江省衢州市",
"861771574", "四川省泸州市",
"861535467", "吉林省辽源市",
"861778945", "甘肃省陇南市",
"86151640", "辽宁省大连市",
"86134683", "山东省日照市",
"861450228", "河北省保定市",
"861781114", "宁夏固原市",
"861454448", "江西省景德镇市",
"861335587", "浙江省温州市",
"861537638", "山东省泰安市",
"861572185", "云南省玉溪市",
"861778176", "四川省甘孜藏族自治州",
"861800949", "甘肃省兰州市",
"861374070", "江西省南昌市",
"861572494", "浙江省丽水市",
"8618521", "上海市",
"861303904", "吉林省长春市",
"861312438", "吉林省松原市",
"861881383", "广东省梅州市",
"861472917", "陕西省西安市",
"861453689", "陕西省延安市",
"861346363", "河北省廊坊市",
"861477827", "广东省梅州市",
"861323976", "新疆和田地区",
"861535326", "陕西省安康市",
"861300867", "云南省昆明市",
"861331963", "湖南省湘西土家族苗族自治州",
"86156776", "广西百色市",
"861532410", "河北省邯郸市",
"861768817", "广东省珠海市",
"861768134", "安徽省芜湖市",
"861395621", "安徽省芜湖市",
"861399475", "山西省临汾市",
"861823249", "河北省廊坊市",
"861599481", "广东省深圳市",
"861317610", "山东省菏泽市",
"861332297", "广东省肇庆市",
"861892152", "江苏省无锡市",
"861538545", "安徽省宣城市",
"86183271", "湖北省武汉市",
"861300276", "山东省莱芜市",
"861590821", "四川省绵阳市",
"861585042", "江苏省扬州市",
"861822603", "安徽省宿州市",
"861700979", "浙江省绍兴市",
"861360035", "广东省江门市",
"861367416", "辽宁省锦州市",
"861772844", "广东省汕头市",
"861502610", "新疆哈密地区",
"861566624", "山东省济宁市",
"861532455", "安徽省安庆市",
"861560637", "山东省枣庄市",
"861871544", "安徽省阜阳市",
"861893234", "江苏省淮安市",
"861306993", "黑龙江省佳木斯市",
"86159393", "河南省濮阳市",
"861322099", "山东省德州市",
"861302057", "山东省聊城市",
"861809709", "青海省玉树藏族自治州",
"861317655", "山东省淄博市",
"861395949", "福建省龙岩市",
"861871868", "广东省深圳市",
"861807704", "广西南宁市",
"861566167", "内蒙古通辽市",
"86147071", "湖北省武汉市",
"861572882", "广东省揭阳市",
"861889860", "广东省广州市",
"861557778", "广西柳州市",
"861550700", "江西省宜春市",
"86159132", "广东省珠海市",
"86185040", "辽宁省沈阳市",
"86159825", "四川省遂宁市",
"861322364", "山西省太原市",
"861350149", "广东省阳江市",
"86147687", "山东省济宁市",
"861558651", "湖北省黄冈市",
"861348593", "安徽省宣城市",
"861871616", "四川省宜宾市",
"861369517", "广东省佛山市",
"861890065", "江苏省常州市",
"861315355", "山东省东营市",
"861319762", "广西柳州市",
"861775000", "福建省厦门市",
"861351606", "辽宁省锦州市",
"861323842", "内蒙古呼和浩特市",
"861360733", "湖南省株洲市",
"861846382", "山东省德州市",
"861830421", "辽宁省朝阳市",
"861831982", "广东省潮州市",
"861570766", "广东省云浮市",
"861850245", "辽宁省铁岭市",
"861815911", "福建省莆田市",
"861381362", "江苏省南通市",
"86138481", "内蒙古呼和浩特市",
"861364787", "广西南宁市",
"861532968", "贵州省六盘水市",
"861450236", "河北省沧州市",
"861539257", "山西省临汾市",
"861330931", "甘肃省兰州市",
"861853896", "河南省南阳市",
"861521800", "广东省河源市",
"861361084", "辽宁省大连市",
"861576678", "广东省梅州市",
"861390056", "安徽省合肥市",
"861312367", "贵州省毕节地区",
"861390782", "广西柳州市",
"861362620", "江苏省盐城市",
"861559940", "贵州省黔南布依族苗族自治州",
"861348175", "广西柳州市",
"861815427", "安徽省池州市",
"861830917", "陕西省宝鸡市",
"861339495", "新疆吐鲁番地区",
"861583563", "山西省大同市",
"861535338", "陕西省榆林市",
"861525706", "浙江省舟山市",
"861315937", "福建省三明市",
"861537626", "山东省滨州市",
"861780509", "江苏省淮安市",
"861509097", "湖北省襄樊市",
"861336414", "辽宁省本溪市",
"86189129", "江苏省南京市",
"861470586", "浙江省台州市",
"861360966", "广东省东莞市",
"861821490", "江西省新余市",
"861808150", "四川省达州市",
"861570933", "甘肃省平凉市",
"861760883", "云南省临沧市",
"861776829", "江苏省淮安市",
"861333345", "山西省长治市",
"861780579", "浙江省金华市",
"861327389", "河南省平顶山市",
"86743", "湖南省湘西土家族苗族自治州",
"861360311", "河北省石家庄市",
"861378888", "福建省福州市",
"86137263", "广东省佛山市",
"861392207", "广东省湛江市",
"861860337", "河北省秦皇岛市",
"861331728", "湖北省十堰市",
"861802310", "广东省河源市",
"861390438", "吉林省松原市",
"861521231", "安徽省黄山市",
"861834999", "四川省自贡市",
"861342996", "湖北省十堰市",
"861370092", "四川省达州市",
"861760156", "江苏省南京市",
"861592461", "云南省红河哈尼族彝族自治州",
"861812763", "广东省梅州市",
"861576608", "广东省深圳市",
"861339555", "安徽省马鞍山市",
"861521870", "广东省深圳市",
"861305936", "广东省肇庆市",
"861454209", "河南省漯河市",
"86151409", "辽宁省辽阳市",
"861573460", "黑龙江省哈尔滨市",
"86186699", "山东省临沂市",
"861810152", "江苏省无锡市",
"86155089", "海南省海口市",
"861807124", "湖北省黄石市",
"861528415", "四川省宜宾市",
"861556810", "吉林省白山市",
"861589927", "新疆昌吉回族自治州",
"861860910", "陕西省咸阳市",
"861570048", "四川省自贡市",
"86147680", "山东省菏泽市",
"86187376", "河南省信阳市",
"861351676", "浙江省台州市",
"86183456", "黑龙江省鹤岗市",
"861302427", "浙江省杭州市",
"86139573", "浙江省嘉兴市",
"861453934", "广东省佛山市",
"861773787", "河南省平顶山市",
"861839566", "河北省保定市",
"86135569", "广东省江门市",
"861522540", "河南省洛阳市",
"86131191", "陕西省西安市",
"861880549", "山东省临沂市",
"861557708", "广西玉林市",
"861550770", "广西防城港市",
"861860955", "宁夏中卫市",
"86150182", "广东省揭阳市",
"861807774", "广西玉林市",
"861528450", "云南省昭通市",
"861826660", "山东省潍坊市",
"861334780", "江苏省南京市",
"86182875", "云南省保山市",
"861776757", "新疆伊犁哈萨克自治州",
"861586181", "江苏省南京市",
"861853174", "河北省唐山市",
"861332627", "山东省德州市",
"861597276", "湖北省随州市",
"861835626", "安徽省池州市",
"861308219", "河北省沧州市",
"861581683", "广东省东莞市",
"861302911", "吉林省长春市",
"861708916", "陕西省榆林市",
"861379594", "四川省巴中市",
"861825054", "福建省莆田市",
"861365580", "浙江省舟山市",
"861551391", "山西省朔州市",
"861310866", "云南省昆明市",
"861808812", "云南省昆明市",
"86135906", "广东省佛山市",
"861809779", "新疆博尔塔拉蒙古自治州",
"861877273", "湖北省荆门市",
"861886448", "河南省信阳市",
"861332164", "广西贺州市",
"86135739", "山东省临沂市",
"861551789", "河南省鹤壁市",
"861515666", "安徽省阜阳市",
"861471833", "广东省湛江市",
"861328049", "山东省济宁市",
"861358915", "山东省潍坊市",
"861398034", "四川省攀枝花市",
"861320274", "广东省东莞市",
"861399405", "山西省忻州市",
"86170768", "广东省广州市",
"861316547", "山东省济宁市",
"861500321", "河北省石家庄市",
"861807667", "广西钦州市",
"861348802", "陕西省榆林市",
"861319387", "河南省信阳市",
"861539988", "湖南省娄底市",
"86178581", "浙江省绍兴市",
"861375197", "广东省梅州市",
"861338247", "江苏省盐城市",
"861458254", "安徽省合肥市",
"861809129", "陕西省西安市",
"86186576", "浙江省台州市",
"86151452", "黑龙江省齐齐哈尔市",
"861556152", "黑龙江省七台河市",
"861372101", "安徽省滁州市",
"861303974", "黑龙江省齐齐哈尔市",
"861778106", "四川省广安市",
"861860468", "黑龙江省鹤岗市",
"861520263", "宁夏吴忠市",
"861567811", "广西崇左市",
"861370522", "江苏省徐州市",
"861335271", "广东省揭阳市",
"861568229", "四川省达州市",
"861535285", "内蒙古呼和浩特市",
"861530630", "山东省威海市",
"861390367", "黑龙江省牡丹江市",
"861399153", "陕西省安康市",
"861323906", "新疆巴音郭楞蒙古自治州",
"861364362", "山西省大同市",
"861396539", "安徽省马鞍山市",
"86471", "内蒙古呼和浩特市",
"861529429", "甘肃省定西市",
"861335830", "福建省漳州市",
"861772995", "安徽省宣城市",
"861329384", "山西省吕梁市",
"861709749", "广东省佛山市",
"861571961", "甘肃省兰州市",
"861393413", "山西省太原市",
"861816770", "新疆巴音郭楞蒙古自治州",
"861500430", "吉林省长春市",
"861779588", "陕西省渭南市",
"861771504", "江苏省南通市",
"861310277", "河北省衡水市",
"861810855", "贵州省黔东南苗族侗族自治州",
"861890936", "甘肃省张掖市",
"86139924", "陕西省商洛市",
"861362290", "广东省茂名市",
"86137796", "新疆巴音郭楞蒙古自治州",
"861882880", "四川省阿坝藏族羌族自治州",
"86150800", "福建省福州市",
"861390426", "辽宁省大连市",
"861331736", "湖南省常德市",
"861571316", "河北省廊坊市",
"86151647", "内蒙古乌兰察布市",
"861575203", "云南省昆明市",
"861572554", "山东省烟台市",
"86136460", "福建省漳州市",
"861351517", "江苏省宿迁市",
"861394864", "内蒙古赤峰市",
"861369606", "四川省内江市",
"861571857", "贵州省毕节地区",
"86132709", "江苏省常州市",
"861380978", "广东省茂名市",
"861324911", "广东省江门市",
"861568539", "贵州省安顺市",
"861370232", "广东省珠海市",
"861377984", "新疆喀什地区",
"86138406", "辽宁省锦州市",
"86147275", "贵州省贵阳市",
"861534572", "浙江省湖州市",
"861350582", "浙江省湖州市",
"861324427", "吉林省长春市",
"861319400", "福建省三明市",
"861777401", "浙江省杭州市",
"86137245", "广东省东莞市",
"861590343", "山西省太原市",
"861859659", "福建省厦门市",
"861504540", "黑龙江省佳木斯市",
"861832957", "陕西省西安市",
"861335956", "黑龙江省牡丹江市",
"861538889", "云南省昆明市",
"861318079", "吉林省长春市",
"86180614", "江苏省南京市",
"861514791", "内蒙古巴彦淖尔市",
"861894493", "湖南省怀化市",
"861700553", "安徽省芜湖市",
"861348633", "浙江省嘉兴市",
"861588347", "四川省凉山彝族自治州",
"861313453", "黑龙江省牡丹江市",
"861890815", "四川省凉山彝族自治州",
"861889010", "湖南省郴州市",
"861319113", "山西省阳泉市",
"861340375", "河南省平顶山市",
"861566034", "新疆阿克苏地区",
"861536422", "湖南省长沙市",
"861471602", "广东省深圳市",
"86151423", "辽宁省大连市",
"861890850", "贵州省贵阳市",
"861316483", "福建省漳州市",
"86482", "内蒙古兴安盟",
"861571729", "湖北省孝感市",
"861310244", "河北省沧州市",
"86177367", "河北省廊坊市",
"86133218", "上海市",
"8613681", "北京市",
"861314424", "广东省江门市",
"861705364", "云南省昆明市",
"861594592", "黑龙江省大庆市",
"86187987", "贵州省贵阳市",
"861847184", "湖北省襄樊市",
"861459461", "陕西省延安市",
"861816462", "云南省昆明市",
"861840518", "江苏省无锡市",
"861705529", "陕西省西安市",
"861333919", "安徽省合肥市",
"861380551", "安徽省合肥市",
"861560597", "福建省龙岩市",
"861805658", "安徽省芜湖市",
"86158340", "山西省太原市",
"86186808", "重庆市",
"861867702", "广西防城港市",
"861337542", "山东省青岛市",
"861879790", "江西省新余市",
"861459575", "陕西省铜川市",
"861865061", "福建省漳州市",
"861573825", "河南省信阳市",
"861770376", "河南省信阳市",
"861836523", "安徽省淮北市",
"861709669", "浙江省杭州市",
"861760334", "河北省唐山市",
"861817068", "江西省赣州市",
"861839714", "青海省海东地区",
"861588758", "云南省怒江傈僳族自治州",
"861530415", "辽宁省丹东市",
"861534893", "西藏山南地区",
"861563441", "山东省威海市",
"861500650", "山东省烟台市",
"861880476", "内蒙古赤峰市",
"861804673", "江西省上饶市",
"861850563", "安徽省宣城市",
"861300017", "山东省济南市",
"861537598", "福建省莆田市",
"861320962", "宁夏石嘴山市",
"861470335", "河北省秦皇岛市",
"861362030", "广东省佛山市",
"861870346", "山西省太原市",
"86186564", "安徽省六安市",
"861500615", "江苏省无锡市",
"861864834", "内蒙古阿拉善盟",
"861554927", "湖北省宜昌市",
"861587671", "广东省梅州市",
"861565122", "江苏省常州市",
"861800031", "河北省石家庄市",
"861530450", "黑龙江省哈尔滨市",
"861379989", "福建省泉州市",
"861874267", "新疆克孜勒苏柯尔克孜自治州",
"861375902", "云南省普洱市",
"861583245", "河北省保定市",
"861834473", "江苏省泰州市",
"861301082", "辽宁省辽阳市",
"861882697", "广东省东莞市",
"861774846", "四川省南充市",
"861597951", "江西省宜春市",
"861301756", "河南省平顶山市",
"861593669", "河南省安阳市",
"861508771", "云南省玉溪市",
"86133916", "北京市",
"861375972", "陕西省咸阳市",
"861537458", "湖北省咸宁市",
"861321754", "广东省汕头市",
"861453513", "山东省济南市",
"861478603", "贵州省铜仁地区",
"861814689", "陕西省西安市",
"861806322", "山东省枣庄市",
"861374891", "黑龙江省牡丹江市",
"861304099", "湖北省宜昌市",
"86137202", "湖北省武汉市",
"861834403", "广东省深圳市",
"861306248", "福建省三明市",
"861450526", "吉林省辽源市",
"861780953", "宁夏吴忠市",
"861569789", "江西省赣州市",
"861813448", "河南省安阳市",
"861874485", "贵州省铜仁地区",
"861567061", "河南省郑州市",
"861531262", "江苏省南通市",
"861810060", "江苏省南京市",
"861569391", "甘肃省兰州市",
"861311829", "四川省南充市",
"861347566", "山东省潍坊市",
"861530590", "福建省福州市",
"86153651", "江苏省南京市",
"861334259", "湖南省邵阳市",
"86157334", "河北省邯郸市",
"861770306", "广东省珠海市",
"861577188", "陕西省商洛市",
"861817746", "广西贺州市",
"861812815", "广东省梅州市",
"861380491", "辽宁省鞍山市",
"861398167", "四川省巴中市",
"861532635", "吉林省通化市",
"861560457", "黑龙江省大兴安岭地区",
"86158347", "吉林省延边朝鲜族自治州",
"861311757", "湖南省益阳市",
"861828421", "四川省南充市",
"861570514", "江苏省连云港市",
"861835598", "安徽省黄山市",
"861314054", "河南省商丘市",
"861350854", "贵州省黔南布依族苗族自治州",
"861300578", "广东省珠海市",
"861354668", "山西省吕梁市",
"861363339", "河北省张家口市",
"861828917", "西藏那曲地区",
"861533756", "福建省漳州市",
"861580724", "湖北省咸宁市",
"861310016", "山西省晋城市",
"861889425", "甘肃省金昌市",
"861770990", "新疆克拉玛依市",
"861533082", "辽宁省大连市",
"861363846", "湖南省常德市",
"86187980", "贵州省贵阳市",
"861890643", "山东省淄博市",
"86136328", "广东省深圳市",
"861880885", "云南省迪庆藏族自治州",
"86132238", "河南省驻马店市",
"861559359", "甘肃省金昌市",
"861361641", "山东省济南市",
"861389935", "新疆哈密地区",
"86188389", "河南省郑州市",
"861360295", "广东省肇庆市",
"861377639", "江苏省常州市",
"861847510", "广东省揭阳市",
"861800350", "山西省忻州市",
"861818693", "湖北省武汉市",
"861700493", "北京市",
"861379634", "黑龙江省齐齐哈尔市",
"861313593", "湖北省黄石市",
"861771547", "江苏省南通市",
"86177360", "河北省石家庄市",
"861774902", "陕西省西安市",
"861570646", "山东省潍坊市",
"861519698", "四川省宜宾市",
"861590570", "浙江省衢州市",
"86137528", "重庆市",
"861470011", "江苏省淮安市",
"861868814", "广东省中山市",
"861877441", "湖南省益阳市",
"861371740", "广东省东莞市",
"861537965", "宁夏吴忠市",
"861868137", "四川省成都市",
"861511392", "广东省汕头市",
"86135553", "黑龙江省绥化市",
"861800315", "河北省唐山市",
"86156534", "山东省潍坊市",
"861362351", "山西省太原市",
"861535719", "安徽省六安市",
"861893369", "广东省揭阳市",
"861323251", "广东省珠海市",
"861327412", "辽宁省鞍山市",
"86176730", "湖南省长沙市",
"861479378", "甘肃省白银市",
"861864798", "内蒙古包头市",
"861867825", "山东省枣庄市",
"861534502", "福建省漳州市",
"861558320", "四川省成都市",
"861386633", "安徽省淮南市",
"861862915", "陕西省西安市",
"861818352", "云南省昆明市",
"861589792", "湖北省黄冈市",
"861300951", "内蒙古呼和浩特市",
"861509237", "山东省临沂市",
"861319470", "四川省雅安市",
"861777471", "广西桂林市",
"861311348", "广东省汕头市",
"861385226", "江苏省淮安市",
"861520545", "山东省烟台市",
"86134432", "广东省深圳市",
"861305643", "四川省南充市",
"861576006", "四川省宜宾市",
"861313946", "甘肃省庆阳市",
"861369676", "安徽省合肥市",
"861319642", "江苏省无锡市",
"861304529", "黑龙江省绥化市",
"86137259", "广东省江门市",
"861363972", "青海省海东地区",
"861352399", "河南省信阳市",
"861772877", "广东省阳江市",
"861380908", "江苏省南通市",
"861304364", "湖南省娄底市",
"861335443", "山东省德州市",
"861881834", "广东省潮州市",
"861452481", "内蒙古呼伦贝尔市",
"86180788", "广东省广州市",
"861386642", "安徽省马鞍山市",
"861811487", "江苏省无锡市",
"861508586", "贵州省六盘水市",
"861550425", "辽宁省大连市",
"861351972", "青海省海东地区",
"861566280", "吉林省延边朝鲜族自治州",
"861589151", "陕西省延安市",
"861859724", "青海省海南藏族自治州",
"861707867", "云南省楚雄彝族自治州",
"861597744", "广西桂林市",
"861891305", "江苏省苏州市",
"861818189", "四川省泸州市",
"861530241", "广东省佛山市",
"861534421", "内蒙古呼伦贝尔市",
"86187976", "湖南省永州市",
"861776971", "浙江省绍兴市",
"861880359", "山西省运城市",
"86188561", "安徽省淮北市",
"861559885", "内蒙古巴彦淖尔市",
"861452669", "江西省赣州市",
"861301257", "山东省烟台市",
"861366835", "四川省内江市",
"861359871", "河南省新乡市",
"861321299", "黑龙江省佳木斯市",
"861308327", "安徽省蚌埠市",
"861334794", "江苏省徐州市",
"861319633", "陕西省渭南市",
"861534917", "陕西省宝鸡市",
"86178353", "山西省运城市",
"861501495", "广东省惠州市",
"861308466", "浙江省金华市",
"861859174", "陕西省宝鸡市",
"861509108", "陕西省宝鸡市",
"861810412", "辽宁省鞍山市",
"861528155", "四川省甘孜藏族自治州",
"861515247", "江苏省扬州市",
"86895", "西藏昌都地区",
"861379580", "四川省宜宾市",
"861335432", "吉林省吉林市",
"861450181", "山西省吕梁市",
"86183207", "广东省深圳市",
"861376340", "黑龙江省哈尔滨市",
"861338818", "四川省成都市",
"861389504", "宁夏固原市",
"861381588", "江苏省南京市",
"861331097", "陕西省西安市",
"861314318", "广东省佛山市",
"861348400", "浙江省杭州市",
"861316748", "江苏省南通市",
"861506665", "山东省济南市",
"861853439", "山西省太原市",
"861336585", "湖南省郴州市",
"861821484", "安徽省蚌埠市",
"861829408", "甘肃省庆阳市",
"861569203", "广东省珠海市",
"861534330", "湖南省岳阳市",
"861339345", "山西省长治市",
"861571654", "河南省平顶山市",
"86134003", "河北省保定市",
"861360662", "浙江省杭州市",
"861353929", "广东省揭阳市",
"861760416", "辽宁省锦州市",
"861528403", "四川省绵阳市",
"861559406", "甘肃省张掖市",
"861512979", "陕西省咸阳市",
"861518271", "四川省攀枝花市",
"86182594", "福建省厦门市",
"8613816", "上海市",
"861363078", "吉林省松原市",
"861525244", "江苏省连云港市",
"861333555", "安徽省马鞍山市",
"861536465", "山西省长治市",
"861876941", "山东省烟台市",
"86189252", "广东省深圳市",
"861770459", "黑龙江省大庆市",
"86159538", "山东省泰安市",
"86150871", "云南省昆明市",
"861342692", "广东省潮州市",
"861351846", "四川省自贡市",
"861523429", "山西省长治市",
"861479039", "安徽省池州市",
"861857857", "广东省汕尾市",
"861869040", "陕西省宝鸡市",
"861858541", "贵州省贵阳市",
"861326354", "黑龙江省哈尔滨市",
"861353641", "广东省湛江市",
"861364611", "江苏省常州市",
"86135128", "天津市",
"861581910", "广东省汕尾市",
"861316935", "广东省肇庆市",
"861355740", "广西桂林市",
"861573862", "河南省周口市",
"86137153", "广东省深圳市",
"861590909", "新疆博尔塔拉蒙古自治州",
"861870258", "江西省抚州市",
"861329390", "山西省太原市",
"86139324", "河北省承德市",
"861860683", "浙江省嘉兴市",
"861850792", "江西省九江市",
"861555109", "安徽省马鞍山市",
"861351339", "河北省唐山市",
"861327060", "江苏省连云港市",
"861561549", "山东省临沂市",
"861890632", "山东省枣庄市",
"861577531", "四川省成都市",
"861585293", "江苏省南京市",
"861454398", "贵州省六盘水市",
"861323384", "河南省新乡市",
"861820435", "吉林省通化市",
"861529734", "河北省张家口市",
"861568930", "山东省淄博市",
"861840469", "黑龙江省双鸭山市",
"861347074", "安徽省芜湖市",
"861788804", "西藏拉萨市",
"861582583", "甘肃省平凉市",
"861515962", "福建省福州市",
"861803779", "河南省郑州市",
"861521472", "浙江省金华市",
"861320925", "陕西省汉中市",
"861562879", "山东省济南市",
"861316357", "黑龙江省绥化市",
"861373024", "河北省承德市",
"861320746", "湖南省永州市",
"86188731", "湖南省长沙市",
"861594763", "内蒙古鄂尔多斯市",
"861382463", "广东省肇庆市",
"86136817", "上海市",
"861533988", "甘肃省酒泉市",
"861513526", "山西省吕梁市",
"86147007", "广西河池市",
"861821892", "广东省汕头市",
"861521640", "山东省济南市",
"861557018", "江西省抚州市",
"861313387", "江西省萍乡市",
"861393405", "山西省长治市",
"861829991", "新疆哈密地区",
"861510513", "江苏省连云港市",
"86155609", "内蒙古呼和浩特市",
"861824889", "江苏省苏州市",
"861576848", "广东省茂名市",
"861807014", "江西省南昌市",
"861538310", "河北省邯郸市",
"861378730", "湖南省岳阳市",
"861824263", "辽宁省铁岭市",
"861855507", "安徽省宿州市",
"861478430", "河南省许昌市",
"861364588", "浙江省丽水市",
"861771668", "贵州省贵阳市",
"861514855", "内蒙古呼伦贝尔市",
"861538355", "山西省长治市",
"861300744", "湖南省湘潭市",
"861839047", "湖南省郴州市",
"861898661", "湖北省咸宁市",
"861857109", "湖北省黄石市",
"861367269", "广东省珠海市",
"86150473", "内蒙古鄂尔多斯市",
"861304920", "广东省云浮市",
"86135744", "湖南省张家界市",
"861887293", "湖北省荆州市",
"861562809", "贵州省黔东南苗族侗族自治州",
"861816753", "新疆阿克苏地区",
"861882945", "陕西省安康市",
"861367883", "山东省淄博市",
"861321629", "浙江省衢州市",
"86189568", "安徽省亳州市",
"861700821", "贵州省贵阳市",
"861524130", "辽宁省抚顺市",
"861329145", "浙江省绍兴市",
"861590979", "青海省海西蒙古族藏族自治州",
"861846995", "云南省德宏傣族景颇族自治州",
"861588986", "广东省珠海市",
"861372560", "广东省阳江市",
"861888844", "广西梧州市",
"861340187", "江苏省宿迁市",
"861478321", "河南省漯河市",
"861709481", "浙江省宁波市",
"861801102", "四川省泸州市",
"861369718", "湖北省恩施土家族苗族自治州",
"86158531", "山东省济南市",
"861555179", "安徽省马鞍山市",
"861358973", "山东省滨州市",
"861337533", "山东省淄博市",
"861822650", "安徽省淮北市",
"861867165", "湖北省黄冈市",
"861572480", "江苏省镇江市",
"861538937", "陕西省渭南市",
"861808025", "四川省绵阳市",
"861804321", "吉林省长春市",
"861361520", "江苏省南通市",
"861329976", "青海省西宁市",
"861552865", "四川省雅安市",
"861459689", "新疆石河子市",
"86132497", "广东省广州市",
"861306356", "江苏省南通市",
"861388141", "四川省自贡市",
"861323672", "辽宁省营口市",
"861301988", "辽宁省辽阳市",
"86187278", "湖北省咸宁市",
"861318338", "河南省驻马店市",
"861376892", "广西桂林市",
"861341112", "广东省韶关市",
"861334838", "福建省厦门市",
"86170825", "江苏省南通市",
"861502983", "陕西省渭南市",
"86150588", "浙江省宁波市",
"861564910", "河南省郑州市",
"86185489", "北京市",
"861816010", "四川省攀枝花市",
"861380823", "四川省成都市",
"861533257", "陕西省延安市",
"861831686", "广东省汕头市",
"86130068", "广东省东莞市",
"861376573", "贵州省六盘水市",
"861303695", "广西玉林市",
"861380072", "湖北省随州市",
"861505246", "江苏省淮安市",
"861361090", "辽宁省铁岭市",
"861318467", "江西省宜春市",
"861336154", "山东省潍坊市",
"861829478", "甘肃省甘南藏族自治州",
"861537922", "甘肃省定西市",
"861569273", "贵州省安顺市",
"861564955", "河南省驻马店市",
"861318326", "河南省开封市",
"861817247", "广西钦州市",
"861584549", "黑龙江省七台河市",
"861532812", "四川省广元市",
"861348470", "内蒙古呼伦贝尔市",
"861518201", "四川省广安市",
"861317983", "新疆乌鲁木齐市",
"861801486", "江苏省苏州市",
"861881637", "山东省东营市",
"86155447", "河北省邯郸市",
"861770599", "福建省南平市",
"861872644", "安徽省蚌埠市",
"861509178", "陕西省榆林市",
"861768248", "浙江省杭州市",
"861870987", "安徽省亳州市",
"861379114", "山东省济南市",
"861335788", "江苏省常州市",
"861552162", "广东省潮州市",
"861328464", "黑龙江省七台河市",
"861370243", "广东省佛山市",
"861808173", "四川省攀枝花市",
"86183200", "广东省广州市",
"861368631", "山东省威海市",
"861827244", "湖北省宜昌市",
"861329842", "河南省郑州市",
"86152794", "江西省抚州市",
"861560383", "河南省安阳市",
"861530999", "新疆伊犁哈萨克自治州",
"861871912", "广东省茂名市",
"861313762", "河南省信阳市",
"861351902", "甘肃省定西市",
"861509728", "甘肃省天水市",
"861521853", "广东省潮州市",
"861373454", "黑龙江省佳木斯市",
"86189738", "湖南省娄底市",
"861321941", "四川省达州市",
"861809019", "四川省泸州市",
"861590332", "河北省保定市",
"861774078", "西藏拉萨市",
"86155652", "河南省新乡市",
"861808723", "云南省昆明市",
"861777522", "安徽省淮南市",
"86187520", "江苏省南京市",
"861816473", "云南省红河哈尼族彝族自治州",
"861500733", "湖南省株洲市",
"861575904", "福建省龙岩市",
"861855797", "浙江省宁波市",
"861509008", "河南省新乡市",
"861528055", "福建省三明市",
"861367426", "辽宁省大连市",
"861840385", "黑龙江省黑河市",
"861502620", "新疆博尔塔拉蒙古自治州",
"861452496", "内蒙古通辽市",
"861566614", "山东省德州市",
"861856242", "山东省济宁市",
"861317620", "山东省菏泽市",
"861328657", "广东省清远市",
"861365774", "广西梧州市",
"86183272", "湖北省武汉市",
"861308699", "贵州省铜仁地区",
"861884047", "陕西省宝鸡市",
"861532420", "河北省邯郸市",
"861395611", "安徽省六安市",
"86182026", "天津市",
"861520964", "宁夏固原市",
"861303273", "湖北省宜昌市",
"861788526", "贵州省黔南布依族苗族自治州",
"861781774", "广东省清远市",
"861458953", "广东省湛江市",
"861893766", "河南省信阳市",
"861477817", "广东省广州市",
"861535316", "陕西省榆林市",
"86152267", "河北省沧州市",
"861768759", "广西北海市",
"861812918", "新疆克孜勒苏柯尔克孜自治州",
"861804662", "江西省上饶市",
"861850572", "浙江省湖州市",
"86180396", "河南省驻马店市",
"86153898", "内蒙古鄂尔多斯市",
"861320973", "青海省黄南藏族自治州",
"861389838", "辽宁省锦州市",
"861598292", "四川省德阳市",
"861813554", "山西省长治市",
"861822742", "四川省资阳市",
"861358068", "广东省云浮市",
"86134013", "江苏省常州市",
"86157727", "贵州省毕节地区",
"861330368", "黑龙江省佳木斯市",
"861363728", "安徽省合肥市",
"861510967", "宁夏银川市",
"861834462", "江苏省常州市",
"86155475", "内蒙古通辽市",
"861537616", "山东省济南市",
"861330437", "吉林省辽源市",
"861559756", "青海省黄南藏族自治州",
"86134666", "北京市",
"861336424", "辽宁省铁岭市",
"861580566", "安徽省池州市",
"861550473", "内蒙古乌海市",
"861559082", "黑龙江省鸡西市",
"861801072", "安徽省安庆市",
"861555009", "山东省日照市",
"861510242", "辽宁省丹东市",
"861312416", "辽宁省锦州市",
"861348750", "湖南省郴州市",
"861800611", "江苏省常州市",
"861815417", "安徽省淮北市",
"861808705", "云南省昆明市",
"86153623", "广东省汕头市",
"861829758", "安徽省宣城市",
"861560276", "广东省揭阳市",
"861879979", "新疆伊犁哈萨克自治州",
"861876397", "山东省济南市",
"861533359", "山西省运城市",
"861380486", "黑龙江省绥化市",
"861507416", "湖南省郴州市",
"861363736", "湖南省常德市",
"861362610", "江苏省南京市",
"861869140", "陕西省商洛市",
"861534563", "安徽省宣城市",
"861537868", "四川省雅安市",
"861476553", "浙江省杭州市",
"861830411", "辽宁省大连市",
"861389826", "辽宁省辽阳市",
"861536389", "广东省惠州市",
"861863445", "山西省长治市",
"861505114", "江苏省镇江市",
"861770709", "江西省南昌市",
"861479139", "陕西省榆林市",
"86138482", "内蒙古包头市",
"861840696", "云南省保山市",
"861807580", "湖南省永州市",
"861346041", "河南省郑州市",
"861367438", "吉林省松原市",
"861550584", "浙江省宁波市",
"861334574", "浙江省宁波市",
"861373774", "广西桂林市",
"86151276", "河北省廊坊市",
"86156438", "吉林省松原市",
"86136807", "广东省惠州市",
"861508240", "四川省达州市",
"861356336", "山东省东营市",
"861566546", "安徽省安庆市",
"861565065", "安徽省安庆市",
"86137424", "辽宁省本溪市",
"86134149", "广东省湛江市",
"86159131", "广东省广州市",
"861787645", "广东省河源市",
"861356849", "四川省巴中市",
"861501761", "广东省深圳市",
"86186320", "河北省邯郸市",
"86135316", "广东省惠州市",
"861350464", "黑龙江省双鸭山市",
"861779949", "新疆伊犁哈萨克自治州",
"861577982", "江西省景德镇市",
"86137988", "广东省东莞市",
"861576227", "山东省青岛市",
"861374886", "河南省郑州市",
"861856967", "湖南省怀化市",
"86130776", "广西桂林市",
"861560867", "湖北省襄樊市",
"861322519", "江苏省常州市",
"86186327", "河北省沧州市",
"861880257", "广东省湛江市",
"861345406", "浙江省舟山市",
"861591293", "云南省楚雄彝族自治州",
"861301359", "山东省日照市",
"861317290", "广东省清远市",
"861519644", "四川省乐山市",
"861332617", "浙江省湖州市",
"861321397", "河南省开封市",
"861308229", "辽宁省营口市",
"861302921", "辽宁省丹东市",
"861839147", "陕西省宝鸡市",
"86188356", "山西省晋城市",
"861517417", "辽宁省丹东市",
"861707383", "河南省商丘市",
"861870749", "湖南省长沙市",
"861805416", "甘肃省兰州市",
"861882076", "广东省广州市",
"861334504", "山东省东营市",
"861847801", "湖南省衡阳市",
"861538202", "辽宁省葫芦岛市",
"86131192", "陕西省延安市",
"861800588", "浙江省杭州市",
"86134155", "广东省佛山市",
"861807114", "湖北省武汉市",
"861367056", "广东省揭阳市",
"861528425", "河北省唐山市",
"861860920", "陕西省咸阳市",
"861367782", "广西柳州市",
"861777192", "湖北省十堰市",
"861816852", "江苏省苏州市",
"861598622", "广东省茂名市",
"861311394", "广东省中山市",
"861869395", "甘肃省陇南市",
"861890918", "陕西省西安市",
"861345885", "四川省雅安市",
"861335660", "山东省东营市",
"861770779", "广西北海市",
"861565928", "福建省厦门市",
"861782046", "广东省清远市",
"861332278", "广东省潮州市",
"861571338", "河北省衡水市",
"861530860", "湖北省宜昌市",
"861339520", "江苏省淮安市",
"861555079", "山东省临沂市",
"861363963", "河南省新乡市",
"861360321", "河北省石家庄市",
"861573936", "新疆巴音郭楞蒙古自治州",
"861592967", "陕西省渭南市",
"861808775", "云南省昆明市",
"861879909", "新疆巴音郭楞蒙古自治州",
"861329045", "河北省唐山市",
"861524030", "江苏省连云港市",
"861359919", "福建省宁德市",
"861776819", "江苏省宿迁市",
"861376793", "江西省景德镇市",
"861775886", "黑龙江省齐齐哈尔市",
"86157720", "贵州省遵义市",
"861565936", "福建省南平市",
"86137286", "广东省深圳市",
"861380722", "湖北省武汉市",
"861306294", "江苏省镇江市",
"861333084", "四川省资阳市",
"861571326", "河北省廊坊市",
"861390416", "辽宁省锦州市",
"8614724", "浙江省杭州市",
"861357914", "新疆阿克苏地区",
"861592242", "安徽省合肥市",
"861562427", "山东省德州市",
"861371587", "广东省汕头市",
"861816155", "宁夏中卫市",
"861393423", "山西省太原市",
"861503197", "河北省保定市",
"861339090", "江苏省南京市",
"861863982", "河南省南阳市",
"86186468", "黑龙江省鹤岗市",
"861336054", "广东省深圳市",
"86152260", "河南省开封市",
"861819480", "新疆乌鲁木齐市",
"86136182", "重庆市",
"861372333", "宁夏中卫市",
"861311069", "福建省莆田市",
"861781704", "广东省茂名市",
"861820541", "山东省济南市",
"861363108", "广东省清远市",
"861853268", "河北省保定市",
"861320903", "新疆和田地区",
"861813185", "河北省邢台市",
"86151978", "湖南省娄底市",
"86181019", "上海市",
"861813494", "山西省太原市",
"861550852", "贵州省遵义市",
"861850502", "福建省南平市",
"861567821", "广西来宾市",
"861816110", "四川省宜宾市",
"861775153", "江苏省盐城市",
"861370512", "江苏省连云港市",
"861568219", "四川省南充市",
"861571467", "黑龙江省大兴安岭地区",
"861500966", "宁夏银川市",
"861331264", "云南省玉溪市",
"861890460", "黑龙江省哈尔滨市",
"861452556", "山东省青岛市",
"861302649", "四川省绵阳市",
"861523877", "河南省周口市",
"861365704", "江西省抚州市",
"86158138", "广东省深圳市",
"861310628", "浙江省丽水市",
"861809119", "陕西省西安市",
"86151451", "黑龙江省哈尔滨市",
"861775405", "安徽省滁州市",
"861837961", "江西省九江市",
"861576697", "广东省湛江市",
"861450607", "吉林省白山市",
"861338559", "贵州省黔西南布依族苗族自治州",
"861500311", "河北省石家庄市",
"861708938", "广东省肇庆市",
"861705683", "福建省福州市",
"861587375", "湖南省邵阳市",
"861470631", "山东省威海市",
"861313289", "广西贵港市",
"861332449", "吉林省白山市",
"861329743", "湖南省湘西土家族苗族自治州",
"861521752", "广东省东莞市",
"861808073", "四川省广元市",
"861826271", "江苏省淮安市",
"86187527", "江苏省扬州市",
"861552062", "四川省宜宾市",
"861324769", "广东省广州市",
"861859004", "陕西省宝鸡市",
"861808822", "云南省丽江市",
"861889403", "甘肃省兰州市",
"861313005", "辽宁省鞍山市",
"861537128", "江苏省扬州市",
"861576945", "甘肃省金昌市",
"861588408", "四川省阿坝藏族羌族自治州",
"861572398", "广西桂林市",
"86138416", "辽宁省锦州市",
"861576726", "广东省江门市",
"861315964", "吉林省长春市",
"861322910", "广东省中山市",
"86151154", "湖南省衡阳市",
"861459523", "云南省玉溪市",
"861882848", "四川省南充市",
"86183040", "辽宁省沈阳市",
"861818275", "黑龙江省绥化市",
"861327820", "吉林省吉林市",
"861318857", "辽宁省盘锦市",
"861301406", "安徽省阜阳市",
"861334357", "湖北省襄樊市",
"861454344", "山东省淄博市",
"86132719", "重庆市",
"861329732", "湖南省湘潭市",
"861330149", "江苏省常州市",
"861317541", "浙江省金华市",
"861801163", "四川省泸州市",
"861321474", "内蒙古兴安盟",
"861530700", "江西省南昌市",
"861459795", "新疆巴音郭楞蒙古自治州",
"86189464", "黑龙江省佳木斯市",
"861895117", "江苏省泰州市",
"8614701", "北京市",
"86151287", "河北省沧州市",
"861845002", "福建省厦门市",
"86135382", "广东省深圳市",
"861886480", "山东省泰安市",
"861835708", "浙江省衢州市",
"861318729", "湖南省邵阳市",
"86158678", "浙江省宁波市",
"861850917", "陕西省宝鸡市",
"861521463", "黑龙江省牡丹江市",
"861782878", "四川省南充市",
"861555338", "山东省滨州市",
"861533476", "内蒙古赤峰市",
"861801491", "江苏省苏州市",
"861365548", "山东省泰安市",
"861571079", "广东省深圳市",
"861594772", "内蒙古鄂尔多斯市",
"861334935", "黑龙江省绥化市",
"861325967", "宁夏中卫市",
"861707597", "福建省福州市",
"86139730", "湖南省岳阳市",
"86158375", "河南省平顶山市",
"86130787", "云南省昆明市",
"861850421", "辽宁省朝阳市",
"861560777", "广西钦州市",
"861311477", "广西钦州市",
"861889155", "陕西省安康市",
"861834425", "广东省深圳市",
"861831691", "广东省河源市",
"861395131", "江苏省南通市",
"861318179", "山东省泰安市",
"861555326", "山东省聊城市",
"861325242", "浙江省宁波市",
"861313703", "河南省商丘市",
"861580004", "广东省广州市",
"861761469", "黑龙江省双鸭山市",
"86186818", "陕西省西安市",
"861326797", "广东省珠海市",
"8618321", "上海市",
"86182621", "江苏省苏州市",
"861896595", "福建省泉州市",
"86139560", "安徽省合肥市",
"861567553", "安徽省芜湖市",
"861477993", "江西省赣州市",
"861344042", "辽宁省鞍山市",
"861322468", "黑龙江省鹤岗市",
"861365864", "山东省济南市",
"861334748", "陕西省榆林市",
"861520431", "吉林省长春市",
"861391238", "江苏省无锡市",
"861560664", "浙江省温州市",
"861878648", "贵州省毕节地区",
"861709496", "浙江省台州市",
"861475314", "山东省济南市",
"861537136", "江苏省宿迁市",
"861378840", "广西南宁市",
"861881951", "广东省东莞市",
"861336318", "河北省衡水市",
"861576738", "广东省中山市",
"86133522", "辽宁省大连市",
"861534792", "江西省九江市",
"861341918", "四川省泸州市",
"86156297", "湖北省荆门市",
"861778678", "湖北省襄樊市",
"861585589", "安徽省亳州市",
"861889852", "广东省湛江市",
"861803306", "广东省深圳市",
"861565022", "山东省临沂市",
"861552455", "辽宁省大连市",
"861853047", "河南省焦作市",
"861882564", "广东省珠海市",
"861459093", "广东省茂名市",
"861535434", "河北省秦皇岛市",
"861360673", "浙江省嘉兴市",
"861855296", "江苏省南通市",
"861347659", "湖北省黄冈市",
"861364031", "广东省广州市",
"86185271", "湖北省孝感市",
"861558545", "吉林省四平市",
"86137270", "广东省珠海市",
"86185127", "湖北省武汉市",
"861340323", "河北省张家口市",
"86150928", "山东省泰安市",
"861319750", "广西南宁市",
"861809984", "新疆喀什地区",
"861586644", "山东省临沂市",
"861865493", "山东省济南市",
"861894784", "内蒙古乌兰察布市",
"861520320", "河北省邯郸市",
"861509846", "山东省烟台市",
"861896723", "浙江省舟山市",
"861479619", "广西柳州市",
"861593496", "内蒙古赤峰市",
"861505634", "安徽省宣城市",
"861803990", "河南省许昌市",
"86150484", "内蒙古乌兰察布市",
"861525636", "安徽省亳州市",
"861338950", "宁夏银川市",
"86137277", "广东省茂名市",
"86136116", "上海市",
"861599346", "河南省驻马店市",
"86185120", "广东省惠州市",
"861358247", "河北省沧州市",
"861529844", "江苏省无锡市",
"86159434", "吉林省四平市",
"861840727", "湖北省武汉市",
"861858983", "广西桂林市",
"861380063", "山东省聊城市",
"861874094", "甘肃省平凉市",
"861320836", "四川省巴中市",
"861328582", "浙江省湖州市",
"861829986", "新疆喀什地区",
"861390334", "河北省秦皇岛市",
"861573452", "黑龙江省齐齐哈尔市",
"861823682", "河南省许昌市",
"86156290", "湖北省武汉市",
"86133739", "河南省郑州市",
"861764548", "黑龙江省大庆市",
"861320349", "山西省朔州市",
"861593556", "山西省运城市",
"861304199", "江苏省连云港市",
"861569262", "西藏日喀则地区",
"861338915", "陕西省安康市",
"861576482", "内蒙古兴安盟",
"861334066", "四川省宜宾市",
"861826652", "山东省泰安市",
"86133906", "江苏省扬州市",
"86150030", "新疆阿克苏地区",
"861332814", "江苏省扬州市",
"861332137", "甘肃省酒泉市",
"861835136", "江苏省徐州市",
"861582941", "陕西省延安市",
"86139567", "安徽省阜阳市",
"861351736", "湖南省常德市",
"861834055", "辽宁省朝阳市",
"861887589", "浙江省嘉兴市",
"861864578", "黑龙江省牡丹江市",
"86138595", "福建省龙岩市",
"861867022", "湖南省湘潭市",
"861533182", "黑龙江省黑河市",
"861808162", "四川省凉山彝族自治州",
"861831221", "广东省揭阳市",
"861393891", "河南省许昌市",
"861316826", "广东省潮州市",
"861313773", "河南省郑州市",
"861893485", "广西玉林市",
"861314154", "湖南省益阳市",
"861355830", "广西防城港市",
"861840859", "贵州省黔西南布依族苗族自治州",
"861773031", "安徽省芜湖市",
"861324879", "浙江省温州市",
"861339641", "山东省济南市",
"861590790", "江西省新余市",
"86159671", "浙江省杭州市",
"861550630", "山东省滨州市",
"861555285", "山东省济南市",
"86139737", "湖南省益阳市",
"861594702", "内蒙古包头市",
"861378392", "河南省鹤壁市",
"861501801", "广东省中山市",
"861364350", "山西省忻州市",
"861809639", "四川省阿坝藏族羌族自治州",
"861835128", "江苏省盐城市",
"8618223", "重庆市",
"861318109", "山东省聊城市",
"86130780", "广西柳州市",
"861560707", "江西省赣州市",
"861509902", "新疆喀什地区",
"861308856", "内蒙古包头市",
"86134243", "广东省深圳市",
"861867592", "广东省江门市",
"861364315", "河北省唐山市",
"861308183", "河北省张家口市",
"86745", "湖南省怀化市",
"86181255", "广东省梅州市",
"86151280", "河北省邯郸市",
"861839439", "甘肃省武威市",
"861879500", "宁夏银川市",
"861533406", "湖北省宜昌市",
"861845823", "浙江省杭州市",
"861300798", "宁夏银川市",
"861351178", "江苏省宿迁市",
"861370977", "青海省海西蒙古族藏族自治州",
"861339929", "陕西省铜川市",
"861388690", "湖北省荆门市",
"861597117", "湖北省鄂州市",
"861454480", "湖北省十堰市",
"861855626", "江苏省宿迁市",
"861320828", "四川省绵阳市",
"861368288", "广东省汕头市",
"861597834", "河南省三门峡市",
"861833174", "河北省廊坊市",
"861500742", "湖南省湘西土家族苗族自治州",
"861569947", "新疆喀什地区",
"861573803", "河南省濮阳市",
"861329488", "内蒙古巴彦淖尔市",
"861321404", "内蒙古兴安盟",
"861530770", "广西防城港市",
"861516051", "福建省漳州市",
"861589893", "山东省潍坊市",
"861760658", "浙江省宁波市",
"861536855", "云南省楚雄彝族自治州",
"861366745", "湖南省衡阳市",
"861450196", "山西省朔州市",
"861864951", "山西省太原市",
"861860529", "江苏省淮安市",
"86133569", "山东省烟台市",
"861358962", "山东省枣庄市",
"861880756", "广东省珠海市",
"86158703", "贵州省黔西南布依族苗族自治州",
"861333230", "辽宁省营口市",
"861860364", "黑龙江省佳木斯市",
"861552025", "四川省雅安市",
"861513081", "河北省沧州市",
"86153089", "海南省海口市",
"861333871", "江苏省苏州市",
"861588478", "四川省泸州市",
"861818854", "贵州省黔南布依族苗族自治州",
"861509000", "河南省安阳市",
"861502628", "新疆阿克苏地区",
"861510649", "山东省临沂市",
"86183690", "山东省菏泽市",
"861312311", "福建省泉州市",
"861811583", "江苏省南通市",
"861821477", "安徽省宣城市",
"861348347", "河北省秦皇岛市",
"861315849", "四川省资阳市",
"86132249", "重庆市",
"861532428", "河北省衡水市",
"861580375", "河南省平顶山市",
"861501859", "广东省湛江市",
"861315336", "山东省淄博市",
"861879744", "湖南省湘西土家族苗族自治州",
"861521897", "广东省汕头市",
"861830961", "宁夏银川市",
"86137705", "江苏省南京市",
"861317628", "山东省滨州市",
"861881332", "广东省湛江市",
"861830316", "河北省廊坊市",
"861304862", "江苏省淮安市",
"861380799", "江西省萍乡市",
"861318151", "山东省烟台市",
"861860763", "广东省清远市",
"86152526", "江苏省泰州市",
"861522989", "陕西省西安市",
"861560821", "四川省成都市",
"861533293", "内蒙古包头市",
"861856921", "湖南省张家界市",
"861819732", "青海省海东地区",
"861327903", "新疆和田地区",
"861390035", "山西省太原市",
"861763527", "山西省临汾市",
"861369475", "内蒙古赤峰市",
"861811474", "江苏省苏州市",
"861538679", "山西省运城市",
"861779774", "河南省郑州市",
"861569481", "河北省沧州市",
"861589285", "四川省德阳市",
"861363720", "安徽省黄山市",
"861770895", "西藏昌都地区",
"86156393", "河南省濮阳市",
"861886743", "湖南省岳阳市",
"861395114", "江苏省泰州市",
"861389830", "辽宁省抚顺市",
"861350914", "陕西省商洛市",
"861369561", "安徽省淮南市",
"861823005", "河北省秦皇岛市",
"861358060", "广东省肇庆市",
"861550797", "江西省赣州市",
"861373949", "四川省成都市",
"861773246", "河北省张家口市",
"861870904", "新疆伊犁哈萨克自治州",
"861330360", "黑龙江省哈尔滨市",
"86157020", "广东省广州市",
"861590637", "山东省枣庄市",
"861452789", "新疆博尔塔拉蒙古自治州",
"861881979", "广东省韶关市",
"86156132", "河北省保定市",
"861777129", "湖北省宜昌市",
"861348758", "湖南省长沙市",
"861829750", "安徽省芜湖市",
"861567206", "湖北省恩施土家族苗族自治州",
"861572833", "广东省惠州市",
"861452391", "西藏拉萨市",
"861367321", "河北省石家庄市",
"861350352", "山西省大同市",
"86187968", "江苏省苏州市",
"861338052", "广东省佛山市",
"86152945", "福建省泉州市",
"861537860", "四川省内江市",
"861399517", "宁夏银川市",
"86152311", "河北省石家庄市",
"861829715", "青海省玉树藏族自治州",
"861568143", "四川省广安市",
"861313374", "江西省赣州市",
"861362618", "江苏省淮安市",
"861855584", "安徽省马鞍山市",
"861869148", "陕西省西安市",
"861383432", "山西省晋城市",
"861806824", "江苏省宿迁市",
"861831933", "广东省湛江市",
"861360056", "浙江省嘉兴市",
"861309987", "云南省曲靖市",
"861360782", "广西柳州市",
"861508248", "四川省南充市",
"86155299", "陕西省榆林市",
"861804883", "四川省南充市",
"861535411", "河北省石家庄市",
"861502636", "新疆阿克苏地区",
"861390733", "湖南省株洲市",
"861331423", "辽宁省沈阳市",
"861807588", "湖南省衡阳市",
"861367430", "吉林省长春市",
"86183361", "河南省周口市",
"861843149", "河北省邢台市",
"861805035", "福建省宁德市",
"86134340", "广东省东莞市",
"86184686", "江苏省南京市",
"861317636", "山东省潍坊市",
"861323377", "河南省信阳市",
"861865276", "江苏省扬州市",
"861862855", "陕西省渭南市",
"861362277", "广东省肇庆市",
"861815242", "宁夏吴忠市",
"861361717", "湖北省宜昌市",
"861505611", "安徽省滁州市",
"861471554", "广东省佛山市",
"861510417", "辽宁省营口市",
"861700383", "河南省信阳市",
"861311562", "黑龙江省黑河市",
"86151383", "河南省周口市",
"861593273", "河北省沧州市",
"861381246", "江苏省镇江市",
"861532436", "河北省邯郸市",
"861558739", "山东省济宁市",
"861587881", "广西南宁市",
"861887257", "湖北省襄樊市",
"861814809", "四川省凉山彝族自治州",
"861598699", "广东省惠州市",
"861370019", "辽宁省葫芦岛市",
"86180915", "陕西省安康市",
"861593203", "河北省邯郸市",
"86147772", "广西南宁市",
"86134347", "广东省深圳市",
"861390311", "河北省石家庄市",
"861571421", "辽宁省朝阳市",
"861323307", "山西省临汾市",
"86187793", "江西省上饶市",
"861355166", "四川省泸州市",
"861760832", "四川省内江市",
"861362581", "浙江省杭州市",
"861390966", "安徽省安庆市",
"861317298", "广东省韶关市",
"861375413", "内蒙古赤峰市",
"86137742", "上海市",
"861846711", "青海省西宁市",
"86155894", "山东省菏泽市",
"861858244", "四川省雅安市",
"861571917", "陕西省宝鸡市",
"861562461", "内蒙古锡林郭勒盟",
"861346737", "湖南省益阳市",
"861860928", "陕西省西安市",
"861514499", "内蒙古通辽市",
"861890337", "河北省唐山市",
"861840871", "云南省昆明市",
"861360438", "吉林省松原市",
"861471494", "广东省佛山市",
"861894383", "吉林省吉林市",
"861847696", "广东省中山市",
"861306701", "福建省三明市",
"861800580", "浙江省舟山市",
"861562193", "内蒙古呼和浩特市",
"861810349", "山西省朔州市",
"861565920", "福建省泉州市",
"861313304", "山西省晋中市",
"861571330", "河北省邯郸市",
"861393197", "河北省石家庄市",
"861503423", "山西省大同市",
"861857893", "广西河池市",
"861534654", "河南省驻马店市",
"861530868", "湖北省鄂州市",
"861837411", "湖南省娄底市",
"86152959", "广西桂林市",
"861316652", "河北省廊坊市",
"861332831", "福建省厦门市",
"86189699", "浙江省杭州市",
"861890910", "陕西省咸阳市",
"861500416", "辽宁省锦州市",
"861335668", "山东省济南市",
"861836282", "江苏省扬州市",
"861331755", "湖北省襄樊市",
"861335816", "江苏省常州市",
"861524038", "江苏省宿迁市",
"861881909", "广东省东莞市",
"861880675", "浙江省绍兴市",
"861533623", "陕西省榆林市",
"86188886", "浙江省宁波市",
"861890955", "宁夏中卫市",
"86131498", "辽宁省沈阳市",
"861458341", "江西省抚州市",
"861530616", "江苏省无锡市",
"861365291", "广东省佛山市",
"861813663", "江苏省扬州市",
"861389587", "黑龙江省双鸭山市",
"86134713", "广西桂林市",
"861870974", "青海省海南藏族自治州",
"86157027", "山西省忻州市",
"861308622", "青海省海西蒙古族藏族自治州",
"861337368", "江苏省扬州市",
"861336889", "云南省玉溪市",
"861516079", "福建省泉州市",
"861823075", "贵州省毕节地区",
"86158432", "吉林省吉林市",
"861802336", "广东省云浮市",
"861853260", "河北省廊坊市",
"861327973", "新疆喀什地区",
"861363100", "广东省潮州市",
"861708317", "河北省沧州市",
"861328205", "浙江省衢州市",
"861898781", "云南省楚雄彝族自治州",
"861339536", "山东省潍坊市",
"861816118", "四川省成都市",
"861802849", "广东省惠州市",
"86137373", "广西桂林市",
"86189576", "浙江省台州市",
"861872041", "江西省南昌市",
"861779704", "青海省果洛藏族自治州",
"86147343", "重庆市",
"861470817", "四川省眉山市",
"861811404", "江苏省南京市",
"861819488", "新疆昌吉回族自治州",
"86152902", "河南省信阳市",
"861338422", "辽宁省鞍山市",
"861530544", "山东省德州市",
"861524026", "江苏省淮安市",
"861302967", "新疆乌鲁木齐市",
"861333859", "福建省泉州市",
"861333727", "湖南省益阳市",
"861511176", "青海省海南藏族自治州",
"86182726", "河南省商丘市",
"861366539", "山东省临沂市",
"861855852", "福建省三明市",
"86151519", "江苏省常州市",
"861708930", "广东省湛江市",
"861801579", "四川省甘孜藏族自治州",
"861556349", "山东省济宁市",
"861301293", "山东省济宁市",
"861525541", "安徽省淮南市",
"861890468", "黑龙江省鹤岗市",
"86157654", "黑龙江省佳木斯市",
"861378076", "山东省东营市",
"86136924", "广东省湛江市",
"861511945", "广东省阳江市",
"861454743", "浙江省温州市",
"86187266", "安徽省滁州市",
"861364246", "广东省揭阳市",
"861705165", "山东省青岛市",
"861333177", "吉林省长春市",
"861360426", "辽宁省大连市",
"86136488", "云南省昆明市",
"861457081", "江苏省南京市",
"86188429", "辽宁省葫芦岛市",
"86132844", "河北省石家庄市",
"861539042", "四川省成都市",
"861331053", "湖北省恩施土家族苗族自治州",
"86184137", "浙江省杭州市",
"861536274", "广东省中山市",
"86183697", "山东省济宁市",
"861860936", "甘肃省张掖市",
"861889296", "新疆乌鲁木齐市",
"861537120", "江苏省盐城市",
"861323554", "湖北省武汉市",
"861535245", "甘肃省天水市",
"861588400", "四川省凉山彝族自治州",
"861452273", "山西省太原市",
"861365303", "广东省韶关市",
"86153789", "宁夏银川市",
"861339992", "新疆伊犁哈萨克自治州",
"861566631", "山东省威海市",
"861362776", "广西百色市",
"861572390", "广西南宁市",
"861869094", "新疆博尔塔拉蒙古自治州",
"861351413", "辽宁省抚顺市",
"861591182", "云南省昭通市",
"861816296", "湖北省咸宁市",
"861893221", "江苏省南通市",
"86188870", "云南省昭通市",
"861331891", "广东省云浮市",
"861325649", "山东省滨州市",
"861865127", "江苏省镇江市",
"861355794", "广西梧州市",
"861768121", "安徽省淮北市",
"861457196", "浙江省绍兴市",
"861572906", "河南省焦作市",
"861530708", "江西省景德镇市",
"861705702", "广东省深圳市",
"861831485", "浙江省杭州市",
"861520336", "河北省廊坊市",
"861304825", "广东省梅州市",
"861322918", "广东省揭阳市",
"861882840", "四川省凉山彝族自治州",
"861810973", "青海省黄南藏族自治州",
"861327828", "吉林省白城市",
"86183747", "湖南省衡阳市",
"861582692", "湖北省武汉市",
"861590834", "四川省巴中市",
"86139928", "陕西省西安市",
"861539033", "四川省雅安市",
"861835700", "浙江省杭州市",
"861324795", "江西省宜春市",
"861818657", "湖北省荆州市",
"861782870", "四川省成都市",
"861555330", "山东省淄博市",
"861365540", "山东省菏泽市",
"861313557", "安徽省宿州市",
"861803401", "河北省石家庄市",
"861886488", "山东省聊城市",
"861860592", "福建省厦门市",
"86131026", "河北省唐山市",
"861319347", "河南省鹤壁市",
"861831806", "广东省深圳市",
"861531556", "山东省济南市",
"861567707", "广西桂林市",
"861326473", "湖北省武汉市",
"86184677", "贵州省贵阳市",
"861521694", "广东省潮州市",
"86150560", "安徽省合肥市",
"861833601", "河南省郑州市",
"861589079", "河南省安阳市",
"861532952", "贵州省遵义市",
"861806627", "浙江省温州市",
"861800634", "山东省莱芜市",
"861587074", "江西省赣州市",
"861597790", "广西河池市",
"861560493", "辽宁省抚顺市",
"861311793", "江西省上饶市",
"861841966", "甘肃省张掖市",
"861773747", "河南省洛阳市",
"86189749", "湖南省长沙市",
"861898576", "贵州省黔南布依族苗族自治州",
"861334740", "陕西省西安市",
"861399972", "新疆伊犁哈萨克自治州",
"861830434", "吉林省四平市",
"86183313", "河北省张家口市",
"86159787", "河南省焦作市",
"861857051", "湖南省娄底市",
"861391230", "江苏省常州市",
"861505131", "江苏省宿迁市",
"861878640", "贵州省黔东南苗族侗族自治州",
"861859305", "甘肃省嘉峪关市",
"861301301", "安徽省滁州市",
"861880589", "浙江省金华市",
"86177201", "天津市",
"861860873", "云南省红河哈尼族彝族自治州",
"86178633", "山东省日照市",
"861556973", "甘肃省庆阳市",
"861501226", "云南省昭通市",
"861336937", "甘肃省酒泉市",
"861595012", "江苏省无锡市",
"861322460", "黑龙江省哈尔滨市",
"861508356", "江西省赣州市",
"861315414", "辽宁省本溪市",
"86150730", "湖南省岳阳市",
"86951", "宁夏银川市",
"861850467", "黑龙江省鸡西市",
"86187643", "山东省淄博市",
"861871852", "广东省深圳市",
"861571502", "福建省宁德市",
"86189580", "浙江省杭州市",
"86135809", "广东省东莞市",
"86180537", "山东省济宁市",
"861378848", "广西柳州市",
"861356964", "河南省鹤壁市",
"86156610", "内蒙古呼和浩特市",
"861533371", "河南省郑州市",
"861325921", "陕西省宝鸡市",
"861336310", "河北省邯郸市",
"861780997", "新疆阿克苏地区",
"861576730", "广东省中山市",
"861327349", "河北省邢台市",
"861341910", "四川省南充市",
"861778670", "湖北省随州市",
"861834577", "黑龙江省七台河市",
"861520328", "河北省衡水市",
"86152363", "河南省驻马店市",
"861869524", "宁夏石嘴山市",
"861311525", "江苏省淮安市",
"861398451", "贵州省遵义市",
"861803998", "河南省三门峡市",
"861373303", "安徽省六安市",
"861817160", "湖北省孝感市",
"861327836", "吉林省白城市",
"861822416", "四川省雅安市",
"861336355", "山西省长治市",
"861319758", "广西梧州市",
"861869369", "甘肃省兰州市",
"861855630", "安徽省芜湖市",
"861364747", "湖南省衡阳市",
"861373373", "河南省许昌市",
"861511227", "广东省深圳市",
"861383443", "山西省朔州市",
"861518357", "四川省达州市",
"861831942", "广东省深圳市",
"861534857", "贵州省毕节地区",
"861708539", "山东省临沂市",
"86138921", "陕西省延安市",
"861770751", "广东省韶关市",
"861338958", "宁夏银川市",
"861889797", "江西省赣州市",
"861559980", "新疆和田地区",
"86156672", "陕西省咸阳市",
"861390742", "湖南省常德市",
"86145083", "江苏省镇江市",
"861839841", "四川省绵阳市",
"861824679", "黑龙江省大庆市",
"861453417", "辽宁省沈阳市",
"861361044", "广东省惠州市",
"86134531", "山西省太原市",
"861815233", "宁夏吴忠市",
"86189587", "浙江省温州市",
"861459157", "广西北海市",
"861807131", "湖北省宜昌市",
"861380254", "广东省广州市",
"861305519", "湖南省长沙市",
"861816626", "湖南省常德市",
"861870535", "山东省烟台市",
"861470546", "山东省东营市",
"861533301", "山西省太原市",
"861764540", "黑龙江省佳木斯市",
"861853731", "河南省新乡市",
"861398591", "贵州省六盘水市",
"86156617", "内蒙古鄂尔多斯市",
"861897012", "江西省赣州市",
"86180530", "山东省菏泽市",
"861872690", "安徽省淮北市",
"861864570", "黑龙江省大兴安岭地区",
"861301371", "江苏省扬州市",
"861572842", "广东省中山市",
"861898506", "贵州省黔南布依族苗族自治州",
"86189755", "湖南省郴州市",
"861399902", "新疆巴音郭楞蒙古自治州",
"86159780", "广西桂林市",
"86150737", "湖南省益阳市",
"861304702", "广东省阳江市",
"861470993", "新疆石河子市",
"861860803", "四川省成都市",
"861560553", "安徽省芜湖市",
"861556903", "新疆和田地区",
"861590798", "江西省景德镇市",
"861587004", "江西省赣州市",
"861565099", "青海省西宁市",
"86131237", "河南省驻马店市",
"861573364", "河北省石家庄市",
"861550638", "山东省烟台市",
"86155332", "河北省保定市",
"861534729", "湖北省黄石市",
"86724", "湖北省荆门市",
"861844712", "内蒙古包头市",
"861476276", "江苏省镇江市",
"861366317", "河北省沧州市",
"861820636", "山东省潍坊市",
"861355838", "广西河池市",
"861835120", "江苏省常州市",
"861819743", "青海省黄南藏族自治州",
"861771443", "江苏省苏州市",
"86183589", "浙江省金华市",
"861862389", "河南省焦作市",
"861832993", "陕西省西安市",
"861883036", "河北省秦皇岛市",
"861573099", "甘肃省庆阳市",
"86130087", "甘肃省兰州市",
"861831876", "广东省中山市",
"861857421", "河南省信阳市",
"861567777", "广西钦州市",
"86155193", "贵州省毕节地区",
"861860452", "黑龙江省齐齐哈尔市",
"861585082", "江苏省苏州市",
"861894457", "黑龙江省大庆市",
"861538585", "安徽省蚌埠市",
"861364358", "山西省吕梁市",
"861357931", "新疆喀什地区",
"861338571", "浙江省杭州市",
"861567127", "湖北省襄樊市",
"861806297", "湖北省荆州市",
"861528912", "西藏日喀则地区",
"86130671", "福建省泉州市",
"861300790", "宁夏石嘴山市",
"861377907", "新疆伊犁哈萨克自治州",
"861820628", "江苏省南通市",
"86182333", "河北省保定市",
"861355826", "广西百色市",
"861826259", "江苏省泰州市",
"861388698", "湖北省武汉市",
"861531496", "浙江省金华市",
"861338465", "黑龙江省哈尔滨市",
"861840761", "广东省中山市",
"861879508", "宁夏银川市",
"861530778", "广西河池市",
"861329480", "内蒙古呼和浩特市",
"861705772", "山西省太原市",
"861398021", "四川省内江市",
"861760650", "浙江省杭州市",
"861572976", "四川省广元市",
"861568835", "新疆昌吉回族自治州",
"861500334", "河北省秦皇岛市",
"86147965", "江西省宜春市",
"861310541", "山东省济南市",
"861323494", "黑龙江省齐齐哈尔市",
"86132019", "陕西省渭南市",
"861337149", "山东省青岛市",
"861454488", "湖北省武汉市",
"86134761", "湖北省武汉市",
"861838456", "四川省广元市",
"861309346", "安徽省宣城市",
"86183740", "湖南省长沙市",
"861368280", "广东省揭阳市",
"861320820", "四川省攀枝花市",
"861536666", "江苏省连云港市",
"86130434", "广东省深圳市",
"861362706", "江西省九江市",
"861309839", "湖北省黄石市",
"861800989", "辽宁省葫芦岛市",
"861768701", "云南省昭通市",
"861318792", "云南省普洱市",
"861831267", "广东省广州市",
"861832546", "山东省东营市",
"861588470", "四川省南充市",
"861335547", "山东省济宁市",
"861365373", "河南省新乡市",
"861470614", "江苏省常州市",
"861808656", "湖北省黄冈市",
"86180760", "贵州省毕节地区",
"861871473", "黑龙江省齐齐哈尔市",
"86188877", "云南省玉溪市",
"861453649", "江苏省南通市",
"861303556", "贵州省黔东南苗族侗族自治州",
"861881343", "广东省茂名市",
"861333238", "辽宁省盘锦市",
"861459366", "贵州省黔东南苗族侗族自治州",
"861361992", "新疆乌鲁木齐市",
"861539133", "云南省昆明市",
"861339216", "广东省深圳市",
"861380970", "广东省佛山市",
"861770565", "安徽省合肥市",
"861836809", "浙江省舟山市",
"861479543", "广西梧州市",
"861889507", "宁夏银川市",
"86184836", "四川省成都市",
"861474569", "黑龙江省佳木斯市",
"861816912", "宁夏石嘴山市",
"861457096", "江苏省南通市",
"861512951", "陕西省延安市",
"861362026", "广东省揭阳市",
"861390650", "浙江省杭州市",
"861707161", "河南省焦作市",
"861533589", "湖北省武汉市",
"861780341", "山西省晋城市",
"861527545", "山东省烟台市",
"861705803", "上海市",
"861887182", "湖北省恩施土家族苗族自治州",
"861319408", "福建省厦门市",
"861560784", "广西贺州市",
"861770471", "内蒙古呼和浩特市",
"861454833", "广东省广州市",
"861303669", "四川省成都市",
"861869194", "陕西省铜川市",
"861591756", "广东省湛江市",
"861307951", "宁夏银川市",
"861390615", "江苏省无锡市",
"861507843", "广西玉林市",
"861808324", "贵州省铜仁地区",
"861459427", "云南省楚雄彝族自治州",
"86150195", "广东省中山市",
"861860825", "四川省遂宁市",
"861398701", "云南省临沧市",
"86138322", "河北省保定市",
"86155931", "甘肃省兰州市",
"861320412", "辽宁省鞍山市",
"861898796", "云南省迪庆藏族自治州",
"86176030", "广东省深圳市",
"861521567", "安徽省阜阳市",
"861352322", "河南省新乡市",
"86152288", "四川省成都市",
"861554961", "湖北省孝感市",
"861359859", "河南省信阳市",
"861304592", "福建省厦门市",
"861880371", "河南省郑州市",
"861530965", "安徽省马鞍山市",
"861874221", "辽宁省朝阳市",
"861890858", "贵州省六盘水市",
"86137384", "浙江省宁波市",
"861593262", "河北省廊坊市",
"861569556", "安徽省安庆市",
"861311573", "浙江省嘉兴市",
"861321487", "内蒙古赤峰市",
"86156455", "黑龙江省绥化市",
"861889018", "湖南省邵阳市",
"861347305", "河北省邢台市",
"861373286", "吉林省通化市",
"86184602", "江西省吉安市",
"861550354", "山西省晋中市",
"86184659", "江西省南昌市",
"861370639", "山东省德州市",
"861840510", "江苏省常州市",
"86153575", "安徽省宣城市",
"861595112", "江苏省苏州市",
"861803751", "河南省郑州市",
"861364634", "山东省莱芜市",
"86136584", "重庆市",
"861396622", "安徽省宣城市",
"861596409", "山东省临沂市",
"861562851", "西藏拉萨市",
"861769902", "新疆哈密地区",
"86188187", "广东省佛山市",
"861319991", "新疆乌鲁木齐市",
"861317016", "安徽省池州市",
"861332741", "山西省太原市",
"861550912", "陕西省榆林市",
"861806781", "浙江省嘉兴市",
"86158149", "广东省潮州市",
"861310435", "吉林省通化市",
"861840555", "安徽省马鞍山市",
"861524581", "黑龙江省齐齐哈尔市",
"86177122", "江苏省南通市",
"861805650", "安徽省芜湖市",
"861860772", "广西柳州市",
"861809977", "新疆巴音郭楞蒙古自治州",
"861879798", "江西省景德镇市",
"861810746", "湖南省永州市",
"861709947", "浙江省嘉兴市",
"861760742", "湖南省常德市",
"861537590", "福建省福州市",
"861362038", "广东省中山市",
"861355574", "辽宁省辽阳市",
"861871753", "陕西省延安市",
"86158666", "山东省济南市",
"861552899", "四川省宜宾市",
"861588750", "云南省保山市",
"861847681", "广东省湛江市",
"861867199", "湖北省荆门市",
"861813384", "河北省石家庄市",
"861500658", "山东省青岛市",
"861362596", "福建省泉州市",
"86181490", "陕西省西安市",
"861813602", "江苏省徐州市",
"861346847", "山东省潍坊市",
"86156600", "河南省南阳市",
"861838776", "云南省玉溪市",
"86135819", "北京市",
"86137967", "黑龙江省哈尔滨市",
"861300343", "江苏省镇江市",
"861819906", "新疆阿勒泰地区",
"861530458", "黑龙江省伊春市",
"861831369", "云南省文山壮族苗族自治州",
"861336202", "浙江省衢州市",
"86137960", "黑龙江省哈尔滨市",
"861590951", "宁夏银川市",
"861318572", "浙江省湖州市",
"86183775", "广西玉林市",
"861852409", "辽宁省葫芦岛市",
"861819976", "新疆哈密地区",
"86156607", "广东省广州市",
"86181497", "上海市",
"861529333", "甘肃省平凉市",
"861813672", "江苏省常州市",
"861306240", "福建省漳州市",
"861762541", "江苏省泰州市",
"86185961", "山东省烟台市",
"861558336", "四川省达州市",
"861800747", "湖南省衡阳市",
"861368546", "山东省东营市",
"861472719", "浙江省湖州市",
"86188859", "贵州省黔西南布依族苗族自治州",
"861587896", "广西钦州市",
"86132052", "江苏省无锡市",
"861807031", "江西省上饶市",
"861537450", "湖北省鄂州市",
"861459057", "广东省佛山市",
"861339044", "辽宁省本溪市",
"86138369", "黑龙江省大庆市",
"861390843", "湖南省株洲市",
"86151374", "河南省许昌市",
"861355504", "黑龙江省鸡西市",
"861530598", "福建省三明市",
"861813440", "河南省郑州市",
"861362456", "黑龙江省黑河市",
"861558849", "山东省枣庄市",
"861810068", "江苏省苏州市",
"861594529", "黑龙江省鹤岗市",
"861767334", "湖南省益阳市",
"861894707", "内蒙古鄂尔多斯市",
"861835590", "安徽省亳州市",
"861572743", "湖南省邵阳市",
"861524277", "辽宁省盘锦市",
"861324505", "江苏省苏州市",
"86133823", "江苏省南通市",
"861354660", "山西省忻州市",
"861577180", "陕西省西安市",
"861330542", "山东省青岛市",
"861860702", "江西省九江市",
"861809907", "新疆阿克苏地区",
"861568032", "四川省广安市",
"861365325", "河北省唐山市",
"861477957", "江西省宜春市",
"861534079", "山西省晋中市",
"861584948", "内蒙古包头市",
"861338389", "河南省洛阳市",
"861847518", "广东省阳江市",
"861314263", "内蒙古包头市",
"861319249", "广东省惠州市",
"86158155", "广东省深圳市",
"86188180", "上海市",
"861770998", "新疆喀什地区",
"861338791", "江西省南昌市",
"861323783", "广西桂林市",
"86184348", "山西省临汾市",
"861700777", "广东省肇庆市",
"861596479", "山东省聊城市",
"861840495", "山西省长治市",
"861862571", "河南省周口市",
"861508624", "贵州省黔东南苗族侗族自治州",
"8614770", "广东省广州市",
"86186487", "内蒙古巴彦淖尔市",
"861304452", "福建省漳州市",
"861519690", "四川省遂宁市",
"86188636", "山东省潍坊市",
"86134138", "广东省肇庆市",
"861869876", "辽宁省辽阳市",
"861311503", "江苏省南京市",
"861590578", "浙江省丽水市",
"861373325", "河北省唐山市",
"861800358", "山西省吕梁市",
"861508167", "河北省廊坊市",
"861833187", "河北省邯郸市",
"861321265", "湖南省怀化市",
"861334652", "广东省韶关市",
"861826066", "江苏省扬州市",
"861707553", "安徽省芜湖市",
"861479370", "甘肃省临夏回族自治州",
"861452695", "陕西省安康市",
"861589109", "陕西省商洛市",
"861858298", "四川省广元市",
"861700664", "山东省烟台市",
"861805843", "浙江省杭州市",
"861371748", "广东省佛山市",
"861556068", "内蒙古呼伦贝尔市",
"861569496", "河北省唐山市",
"861880301", "河北省石家庄市",
"861301589", "福建省宁德市",
"861392435", "广东省东莞市",
"861898824", "云南省德宏傣族景颇族自治州",
"861821256", "贵州省毕节地区",
"861319478", "四川省资阳市",
"861311340", "广东省惠州市",
"861322632", "广东省惠州市",
"861571792", "江西省九江市",
"861830719", "湖北省十堰市",
"861380396", "河南省驻马店市",
"861859323", "广西桂林市",
"861827983", "江西省吉安市",
"861705022", "河北省石家庄市",
"86186034", "山西省太原市",
"861450530", "辽宁省锦州市",
"861536499", "山西省运城市",
"861558328", "四川省资阳市",
"861879117", "陕西省宝鸡市",
"861475635", "河北省承德市",
"861380900", "江苏省南京市",
"861334393", "河南省濮阳市",
"861318893", "山东省济南市",
"861318051", "河北省邯郸市",
"861314355", "广东省佛山市",
"861770522", "江苏省徐州市",
"861324934", "河北省石家庄市",
"861533605", "甘肃省白银市",
"86189038", "河南省郑州市",
"861378106", "河南省平顶山市",
"86431", "吉林省长春市",
"86134678", "湖南省郴州市",
"861323209", "广东省韶关市",
"861362309", "广东省潮州市",
"861781787", "广东省韶关市",
"861537999", "甘肃省白银市",
"861379588", "四川省遂宁市",
"861890239", "广东省广州市",
"861894867", "广东省肇庆市",
"861828079", "四川省绵阳市",
"861376348", "黑龙江省齐齐哈尔市",
"861338810", "四川省绵阳市",
"861399963", "新疆喀什地区",
"861381580", "江苏省扬州市",
"861309749", "云南省大理白族自治州",
"861314310", "广东省珠海市",
"861877987", "江西省南昌市",
"861394949", "河南省平顶山市",
"861860862", "湖北省孝感市",
"861556962", "甘肃省定西市",
"861333007", "江西省南昌市",
"861573683", "河南省许昌市",
"861509100", "陕西省咸阳市",
"86177796", "江西省吉安市",
"861539613", "福建省南平市",
"861777599", "湖南省长沙市",
"861310983", "辽宁省大连市",
"861352365", "河南省南阳市",
"861779024", "四川省乐山市",
"861557753", "广西贵港市",
"86189927", "陕西省宝鸡市",
"861348408", "浙江省金华市",
"861814427", "四川省遂宁市",
"861316740", "湖南省株洲市",
"861840919", "陕西省铜川市",
"86151268", "云南省文山壮族苗族自治州",
"861534338", "湖南省娄底市",
"861829400", "甘肃省临夏回族自治州",
"861450302", "河北省廊坊市",
"861331475", "内蒙古通辽市",
"861593225", "河北省唐山市",
"861814366", "吉林省白城市",
"861332954", "黑龙江省佳木斯市",
"861452947", "广东省惠州市",
"861355935", "福建省福州市",
"86181936", "甘肃省张掖市",
"861346516", "山东省德州市",
"861886842", "浙江省杭州市",
"86130768", "广东省广州市",
"861363070", "吉林省四平市",
"861566011", "河南省焦作市",
"861331561", "河北省廊坊市",
"86181709", "江西省南昌市",
"861866635", "广东省佛山市",
"861300909", "吉林省延边朝鲜族自治州",
"861859671", "福建省泉州市",
"861855425", "山东省滨州市",
"86138581", "浙江省杭州市",
"861365787", "广西南宁市",
"861814911", "陕西省西安市",
"861803944", "河南省商丘市",
"861869048", "陕西省榆林市",
"861454906", "湖北省襄樊市",
"861534326", "湖南省永州市",
"86181752", "安徽省滁州市",
"861332312", "河北省保定市",
"861518826", "河南省信阳市",
"861345589", "山东省莱芜市",
"861334587", "浙江省温州市",
"861396665", "安徽省合肥市",
"86184795", "江西省宜春市",
"86152301", "河北省石家庄市",
"861386249", "江苏省南通市",
"861330533", "山东省淄博市",
"861550577", "浙江省温州市",
"861504667", "黑龙江省哈尔滨市",
"861375070", "浙江省衢州市",
"86130538", "山东省泰安市",
"86139871", "云南省昆明市",
"861454390", "贵州省贵阳市",
"861580323", "河北省张家口市",
"861308361", "河南省许昌市",
"861783504", "山西省忻州市",
"861355748", "广西河池市",
"861810962", "安徽省蚌埠市",
"861308916", "吉林省吉林市",
"861779594", "陕西省延安市",
"861583316", "河北省廊坊市",
"861329398", "山西省朔州市",
"861360883", "云南省红河哈尼族彝族自治州",
"86180905", "四川省南充市",
"861869933", "新疆石河子市",
"861526582", "山东省枣庄市",
"861376829", "广西北海市",
"861598327", "四川省内江市",
"86135044", "吉林省长春市",
"861353144", "广东省佛山市",
"861398586", "贵州省铜仁地区",
"86177263", "四川省南充市",
"861760311", "河北省石家庄市",
"861340004", "江苏省无锡市",
"861893686", "江苏省南京市",
"861805135", "江苏省徐州市",
"861378482", "河北省廊坊市",
"861896656", "陕西省咸阳市",
"861853841", "河南省郑州市",
"861360156", "江苏省苏州市",
"861800014", "江苏省宿迁市",
"861557010", "江西省赣州市",
"861521648", "山东省青岛市",
"861399108", "陕西省榆林市",
"861823872", "河南省商丘市",
"861478438", "河南省开封市",
"861869766", "安徽省阜阳市",
"861342941", "浙江省嘉兴市",
"861760733", "湖南省株洲市",
"86151552", "安徽省蚌埠市",
"861839313", "甘肃省陇南市",
"86186476", "内蒙古赤峰市",
"861850729", "湖北省孝感市",
"861399178", "陕西省延安市",
"861576840", "广东省深圳市",
"861823023", "河北省邯郸市",
"861845254", "江苏省南京市",
"86181238", "广东省深圳市",
"861889354", "甘肃省武威市",
"861378738", "湖南省娄底市",
"861538318", "河北省衡水市",
"86151966", "四川省成都市",
"861786453", "山东省临沂市",
"861318421", "浙江省杭州市",
"861514666", "黑龙江省齐齐哈尔市",
"861824054", "河南省信阳市",
"861364580", "浙江省舟山市",
"861771660", "贵州省黔西南布依族苗族自治州",
"861356545", "新疆克拉玛依市",
"861818931", "甘肃省兰州市",
"861388644", "湖北省黄冈市",
"861362932", "甘肃省定西市",
"861570531", "山东省济南市",
"861454145", "吉林省通化市",
"861705763", "新疆乌鲁木齐市",
"861395246", "江苏省无锡市",
"86185913", "陕西省渭南市",
"861369710", "湖北省襄樊市",
"861328914", "陕西省商洛市",
"861877258", "湖北省荆州市",
"86139588", "浙江省温州市",
"861867683", "广东省广州市",
"861832034", "广东省茂名市",
"861821829", "广东省茂名市",
"861524138", "辽宁省营口市",
"861862422", "辽宁省鞍山市",
"861372568", "广东省河源市",
"861803192", "河北省石家庄市",
"861301980", "辽宁省丹东市",
"861898164", "四川省雅安市",
"861365362", "山西省大同市",
"861318330", "河南省南阳市",
"861519041", "江苏省扬州市",
"861836769", "浙江省台州市",
"861334830", "福建省莆田市",
"861822658", "安徽省蚌埠市",
"861850857", "贵州省毕节地区",
"861572488", "江苏省南京市",
"861476597", "吉林省长春市",
"861361528", "江苏省镇江市",
"861550281", "四川省成都市",
"861871462", "黑龙江省鹤岗市",
"861387002", "江西省鹰潭市",
"86152912", "陕西省榆林市",
"861476027", "福建省龙岩市",
"861361098", "辽宁省鞍山市",
"861829642", "江西省上饶市",
"861564918", "河南省信阳市",
"861300979", "黑龙江省牡丹江市",
"861593386", "河北省邯郸市",
"861816018", "四川省南充市",
"861471783", "山西省大同市",
"861844997", "新疆石河子市",
"861361536", "山东省潍坊市",
"861599904", "新疆和田地区",
"861806576", "福建省南平市",
"86189920", "陕西省咸阳市",
"86152977", "江西省赣州市",
"861894206", "湖南省常德市",
"861328352", "山西省大同市",
"861571563", "安徽省宣城市",
"86134703", "辽宁省阜新市",
"861829470", "甘肃省陇南市",
"861868831", "广东省惠州市",
"861331405", "辽宁省辽阳市",
"861504704", "内蒙古呼伦贝尔市",
"861775264", "湖南省张家界市",
"861348478", "内蒙古巴彦淖尔市",
"861378945", "内蒙古通辽市",
"861303481", "湖南省娄底市",
"861539142", "云南省曲靖市",
"861520739", "湖南省邵阳市",
"861457181", "浙江省杭州市",
"861478426", "河南省周口市",
"861333077", "四川省南充市",
"861817412", "广西南宁市",
"861509170", "陕西省宝鸡市",
"861513887", "河南省安阳市",
"861768240", "浙江省台州市",
"861705065", "江苏省南京市",
"861335780", "江苏省南京市",
"86158243", "浙江省嘉兴市",
"861893140", "河北省承德市",
"86183556", "安徽省安庆市",
"861378176", "河南省南阳市",
"861562795", "广东省潮州市",
"861328693", "广东省中山市",
"861333681", "浙江省绍兴市",
"861772171", "江苏省常州市",
"861774070", "西藏日喀则地区",
"86135469", "广东省东莞市",
"861399736", "青海省玉树藏族自治州",
"861838581", "贵州省黔东南苗族侗族自治州",
"861561042", "山东省临沂市",
"861590744", "湖南省张家界市",
"86151509", "江苏省连云港市",
"861323279", "广东省河源市",
"861882730", "湖北省咸宁市",
"861362379", "河南省洛阳市",
"861537241", "浙江省杭州市",
"861803895", "广东省茂名市",
"861816507", "陕西省宝鸡市",
"861509720", "甘肃省陇南市",
"861816281", "湖北省襄樊市",
"861317138", "内蒙古锡林郭勒盟",
"86158134", "广东省佛山市",
"861588773", "云南省红河哈尼族彝族自治州",
"861302689", "广东省广州市",
"861889778", "广西钦州市",
"861812099", "福建省莆田市",
"86130610", "山东省滨州市",
"861800864", "湖北省武汉市",
"861700951", "宁夏银川市",
"861868365", "四川省绵阳市",
"861377471", "福建省三明市",
"861330352", "山西省大同市",
"861345142", "河北省邯郸市",
"861329783", "广西桂林市",
"861300161", "山东省烟台市",
"861588123", "四川省雅安市",
"861332489", "广西北海市",
"861313249", "河北省邢台市",
"861377565", "江苏省泰州市",
"861458486", "山东省淄博市",
"86184082", "四川省成都市",
"861834458", "广东省广州市",
"861830009", "广东省东莞市",
"861333044", "云南省昆明市",
"861538739", "湖南省邵阳市",
"861858309", "四川省遂宁市",
"861327818", "吉林省白城市",
"861300493", "福建省宁德市",
"8613980", "四川省成都市",
"861865117", "江苏省泰州市",
"86186464", "黑龙江省七台河市",
"86187850", "贵州省贵阳市",
"86177528", "湖南省长沙市",
"861324513", "内蒙古包头市",
"861865834", "浙江省台州市",
"861822438", "四川省广安市",
"86135851", "江苏省南京市",
"861869646", "湖北省荆州市",
"861813976", "甘肃省酒泉市",
"86137360", "浙江省宁波市",
"861537155", "江苏省泰州市",
"861820581", "浙江省杭州市",
"861590777", "广西钦州市",
"861893211", "湖南省衡阳市",
"861811378", "四川省宜宾市",
"861330693", "福建省福州市",
"861372159", "贵州省毕节地区",
"861819440", "甘肃省天水市",
"861304850", "贵州省遵义市",
"861867519", "广东省佛山市",
"861361226", "广东省江门市",
"86152386", "河南省郑州市",
"861514746", "内蒙古乌兰察布市",
"861832294", "江西省宜春市",
"86151974", "湖南省衡阳市",
"861345845", "四川省广元市",
"861879457", "甘肃省武威市",
"861373131", "河北省张家口市",
"861850316", "河北省廊坊市",
"86134729", "河北省唐山市",
"861529687", "广西河池市",
"861370306", "广东省佛山市",
"86189818", "四川省成都市",
"861505540", "安徽省淮南市",
"861825937", "福建省宁德市",
"86138506", "福建省龙岩市",
"861322936", "广东省韶关市",
"861700578", "浙江省丽水市",
"861763339", "河北省邯郸市",
"861520318", "河北省衡水市",
"861512707", "河北省石家庄市",
"861535572", "浙江省湖州市",
"861311515", "江苏省连云港市",
"861586530", "山东省菏泽市",
"861313478", "内蒙古巴彦淖尔市",
"861340047", "河北省沧州市",
"86185690", "湖南省长沙市",
"86156080", "四川省成都市",
"861388677", "湖北省恩施土家族苗族自治州",
"861325911", "陕西省延安市",
"861341920", "四川省广元市",
"861370990", "新疆克拉玛依市",
"86137691", "云南省昆明市",
"86136560", "福建省漳州市",
"861529071", "河南省漯河市",
"861311550", "黑龙江省哈尔滨市",
"861777639", "广西玉林市",
"861329085", "福建省泉州市",
"861347731", "湖北省十堰市",
"861841430", "内蒙古呼伦贝尔市",
"861501216", "云南省西双版纳傣族自治州",
"861330914", "陕西省商洛市",
"861839187", "陕西省宝鸡市",
"861530797", "江西省赣州市",
"861338060", "广东省珠海市",
"86158265", "湖北省荆州市",
"861775972", "福建省龙岩市",
"861519684", "四川省资阳市",
"861580841", "四川省南充市",
"861315424", "辽宁省锦州市",
"861390673", "浙江省嘉兴市",
"861829762", "安徽省淮南市",
"861783547", "山西省长治市",
"861458102", "安徽省亳州市",
"861813842", "广东省深圳市",
"861815934", "福建省漳州市",
"86151523", "江苏省淮安市",
"861800548", "山东省泰安市",
"86188413", "辽宁省抚顺市",
"861864784", "内蒙古呼和浩特市",
"861558679", "湖北省咸宁市",
"861563496", "山西省太原市",
"861812529", "广东省河源市",
"861336431", "吉林省长春市",
"861870789", "广西北海市",
"861334956", "黑龙江省鸡西市",
"861367742", "湖南省邵阳市",
"861317776", "江西省赣州市",
"861537852", "四川省凉山彝族自治州",
"861870391", "河南省焦作市",
"861534719", "湖北省襄樊市",
"861358422", "江苏省无锡市",
"861308835", "四川省乐山市",
"861597161", "湖北省荆州市",
"861844722", "内蒙古包头市",
"861890099", "辽宁省大连市",
"861360334", "河北省承德市",
"861550544", "山东省德州市",
"861366327", "河北省沧州市",
"861807540", "安徽省马鞍山市",
"861328533", "山东省淄博市",
"861508280", "四川省广元市",
"861858932", "云南省德宏傣族景颇族自治州",
"861317706", "湖北省宜昌市",
"861823633", "河南省周口市",
"861700017", "广东省广州市",
"86156434", "吉林省四平市",
"86135453", "湖北省武汉市",
"861569839", "山西省晋中市",
"861775902", "福建省莆田市",
"861787685", "广东省深圳市",
"86137428", "辽宁省大连市",
"861595803", "浙江省杭州市",
"861863806", "河南省周口市",
"861366466", "黑龙江省大庆市",
"861766612", "广东省深圳市",
"861705815", "广东省深圳市",
"86137984", "广东省深圳市",
"861577942", "江西省九江市",
"861816616", "湖南省怀化市",
"861894578", "黑龙江省双鸭山市",
"861453911", "广东省广州市",
"86188164", "江西省赣州市",
"861363891", "西藏拉萨市",
"861780551", "安徽省合肥市",
"861361696", "福建省三明市",
"861339469", "黑龙江省双鸭山市",
"861333216", "辽宁省丹东市",
"861533133", "西藏拉萨市",
"861897873", "广西玉林市",
"86184246", "辽宁省锦州市",
"86181723", "广西南宁市",
"861866455", "广东省深圳市",
"861353177", "广东省中山市",
"861305529", "福建省福州市",
"86138922", "陕西省榆林市",
"861597493", "云南省西双版纳傣族自治州",
"861347313", "河北省张家口市",
"861370376", "河南省信阳市",
"861560790", "江西省新余市",
"86156671", "陕西省咸阳市",
"861302934", "辽宁省锦州市",
"861380446", "吉林省长春市",
"861304643", "山东省威海市",
"86134532", "山西省晋中市",
"861880735", "湖南省郴州市",
"861309669", "山西省大同市",
"861313408", "江西省萍乡市",
"861816868", "江苏省镇江市",
"861863485", "山西省晋中市",
"861536349", "广东省惠州市",
"861700508", "福建省厦门市",
"861539589", "浙江省台州市",
"861320855", "贵州省黔东南苗族侗族自治州",
"861898037", "四川省眉山市",
"86145066", "上海市",
"861590707", "江西省赣州市",
"861344257", "山东省日照市",
"861326770", "广东省汕尾市",
"861335259", "黑龙江省大庆市",
"861855860", "福建省福州市",
"86153894", "陕西省西安市",
"861536828", "云南省昭通市",
"861760625", "山东省威海市",
"861308132", "辽宁省抚顺市",
"86134762", "湖北省武汉市",
"86188811", "四川省绵阳市",
"861305099", "辽宁省葫芦岛市",
"861822782", "四川省眉山市",
"861519939", "新疆巴音郭楞蒙古自治州",
"861879027", "河南省郑州市",
"861374972", "河南省信阳市",
"861813906", "新疆巴音郭楞蒙古自治州",
"861570691", "云南省西双版纳傣族自治州",
"861593535", "山西省临汾市",
"861398011", "四川省德阳市",
"86137367", "浙江省温州市",
"861525610", "安徽省淮北市",
"861335166", "黑龙江省佳木斯市",
"86187857", "贵州省毕节地区",
"861819602", "新疆克拉玛依市",
"861815689", "安徽省阜阳市",
"86183903", "湖南省怀化市",
"861504747", "内蒙古通辽市",
"861537473", "内蒙古乌海市",
"861313991", "新疆乌鲁木齐市",
"861585940", "福建省福州市",
"861826547", "山东省济宁市",
"86177854", "贵州省贵阳市",
"861322065", "山东省临沂市",
"861528922", "陕西省榆林市",
"861884671", "黑龙江省鸡西市",
"86130672", "福建省福州市",
"861351755", "广西玉林市",
"861809751", "新疆阿勒泰地区",
"861820618", "江苏省无锡市",
"861599947", "新疆伊犁哈萨克自治州",
"861355816", "广西柳州市",
"861553623", "山西省晋中市",
"861780978", "青海省西宁市",
"861835155", "江苏省盐城市",
"861876532", "山东省青岛市",
"861890364", "黑龙江省佳木斯市",
"861315054", "云南省曲靖市",
"861477701", "广西南宁市",
"861835110", "江苏省苏州市",
"861890529", "江苏省镇江市",
"86130617", "上海市",
"861837893", "广西北海市",
"861554654", "黑龙江省绥化市",
"861351710", "湖北省武汉市",
"861889708", "青海省西宁市",
"861452974", "广东省云浮市",
"861522667", "河北省廊坊市",
"861554109", "辽宁省葫芦岛市",
"86180773", "广西桂林市",
"861779114", "陕西省榆林市",
"861536973", "河北省秦皇岛市",
"861350924", "广东省东莞市",
"861500782", "广西柳州市",
"861454440", "江西省新余市",
"861363710", "安徽省马鞍山市",
"86185313", "河北省张家口市",
"861850434", "吉林省四平市",
"861317277", "广东省河源市",
"861354740", "四川省自贡市",
"861865637", "安徽省合肥市",
"861559735", "青海省海南藏族自治州",
"861362636", "山东省潍坊市",
"861366785", "广西玉林市",
"861768631", "山东省威海市",
"861816708", "浙江省丽水市",
"861776195", "江苏省南通市",
"861395124", "江苏省宿迁市",
"861774423", "四川省成都市",
"861312430", "吉林省吉林市",
"861876543", "山东省滨州市",
"861365611", "江苏省常州市",
"861301994", "辽宁省盘锦市",
"861533845", "广东省云浮市",
"86145397", "广东省深圳市",
"861454672", "广东省深圳市",
"861537630", "山东省济宁市",
"861397367", "湖南省益阳市",
"86132590", "陕西省咸阳市",
"861376901", "云南省丽江市",
"861815193", "江苏省南京市",
"861527263", "湖北省荆州市",
"861560811", "四川省绵阳市",
"861374078", "辽宁省营口市",
"861317618", "山东省济宁市",
"861780823", "四川省遂宁市",
"861830326", "河北省沧州市",
"861821971", "甘肃省兰州市",
"861532418", "河北省衡水市",
"861815461", "广西南宁市",
"861800667", "浙江省绍兴市",
"861780072", "青海省海东地区",
"86170068", "浙江省杭州市",
"861391345", "江苏省徐州市",
"861776573", "广东省珠海市",
"86181848", "云南省昆明市",
"861312321", "福建省南平市",
"861529492", "河南省驻马店市",
"861876300", "山东省青岛市",
"861889544", "安徽省阜阳市",
"861308143", "山东省潍坊市",
"861502618", "新疆昌吉回族自治州",
"861830467", "黑龙江省鸡西市",
"861301613", "湖南省益阳市",
"861785859", "浙江省衢州市",
"861582981", "陕西省延安市",
"861300821", "辽宁省阜新市",
"861528036", "福建省龙岩市",
"861820706", "江西省宜春市",
"861477861", "广东省湛江市",
"861339077", "江苏省南京市",
"86183362", "河南省信阳市",
"861843464", "山西省朔州市",
"861335794", "江苏省徐州市",
"861533142", "云南省文山壮族苗族自治州",
"861871860", "广东省揭阳市",
"861361727", "湖北省宜昌市",
"861800774", "广西梧州市",
"861510427", "辽宁省盘锦市",
"861505621", "安徽省铜陵市",
"861889868", "广东省湛江市",
"861557770", "广西来宾市",
"861309481", "浙江省杭州市",
"86188461", "黑龙江省哈尔滨市",
"861885147", "江苏省淮安市",
"861331413", "辽宁省抚顺市",
"861304632", "广东省中山市",
"861893445", "贵州省黔南布依族苗族自治州",
"861453282", "山西省忻州市",
"861555245", "山东省烟台市",
"861776892", "江苏省宿迁市",
"861510911", "陕西省西安市",
"861359992", "福建省厦门市",
"861817152", "湖北省襄樊市",
"86155789", "广西南宁市",
"861381454", "江苏省南京市",
"861509561", "甘肃省金昌市",
"861372767", "广东省汕头市",
"861475103", "江苏省无锡市",
"861339681", "浙江省杭州市",
"861368479", "内蒙古锡林郭勒盟",
"861353696", "广东省肇庆市",
"861535421", "河北省石家庄市",
"861539675", "江苏省扬州市",
"861778730", "云南省红河哈尼族彝族自治州",
"86159438", "吉林省松原市",
"861358287", "河北省唐山市",
"861576670", "广东省湛江市",
"861362628", "江苏省南通市",
"861559948", "贵州省铜仁地区",
"861596546", "山东省东营市",
"861595065", "江苏省徐州市",
"861823642", "河南省郑州市",
"861399527", "宁夏银川市",
"86152312", "河北省保定市",
"861520424", "辽宁省朝阳市",
"861829725", "青海省果洛藏族自治州",
"861328542", "山东省青岛市",
"861532960", "贵州省贵阳市",
"861858943", "西藏山南地区",
"861322452", "黑龙江省齐齐哈尔市",
"861367311", "河北省石家庄市",
"861361859", "贵州省贵阳市",
"86155540", "山东省菏泽市",
"861787579", "广东省阳江市",
"861777119", "湖北省黄石市",
"86156131", "河北省石家庄市",
"861378537", "河北省承德市",
"861320791", "江西省南昌市",
"86152377", "河南省南阳市",
"861593904", "河南省郑州市",
"861535330", "陕西省商洛市",
"861367966", "四川省眉山市",
"861509153", "陕西省西安市",
"861787509", "广东省广州市",
"86155547", "山东省济宁市",
"861506539", "山东省临沂市",
"861301142", "河北省沧州市",
"861773024", "安徽省淮北市",
"86152370", "河南省商丘市",
"861585549", "安徽省阜阳市",
"861500367", "青海省海西蒙古族藏族自治州",
"861458765", "广东省珠海市",
"861855770", "浙江省温州市",
"861533613", "陕西省渭南市",
"86176817", "浙江省温州市",
"861809944", "新疆阿克苏地区",
"86150924", "山东省青岛市",
"861576600", "广东省深圳市",
"861337931", "陕西省延安市",
"861500426", "辽宁省大连市",
"861521878", "广东省东莞市",
"861322592", "福建省厦门市",
"86181336", "安徽省合肥市",
"86150488", "内蒙古巴彦淖尔市",
"86185589", "福建省泉州市",
"861774053", "湖北省武汉市",
"861390430", "吉林省长春市",
"861802318", "广东省汕尾市",
"861331720", "湖北省宜昌市",
"861894744", "内蒙古兴安盟",
"861831234", "广东省深圳市",
"86153193", "陕西省汉中市",
"861837421", "湖南省益阳市",
"861581165", "广东省珠海市",
"861522548", "河南省开封市",
"861571927", "陕西省宝鸡市",
"86186814", "广东省深圳市",
"861573468", "黑龙江省鹤岗市",
"861899395", "甘肃省白银市",
"861811039", "安徽省六安市",
"861860918", "陕西省榆林市",
"861556818", "吉林省辽源市",
"861355547", "黑龙江省鸡西市",
"861570040", "四川省遂宁市",
"861452535", "山东省烟台市",
"861357149", "陕西省西安市",
"861820776", "广西百色市",
"861339007", "辽宁省鞍山市",
"861344756", "山东省菏泽市",
"86185740", "河南省洛阳市",
"861375423", "浙江省湖州市",
"861556666", "辽宁省大连市",
"861303749", "湖南省永州市",
"861314545", "山东省东营市",
"861508034", "福建省厦门市",
"861550778", "广西河池市",
"861557700", "广西柳州市",
"86187283", "四川省眉山市",
"861800704", "江西省抚州市",
"861868253", "四川省遂宁市",
"861528458", "云南省保山市",
"861390321", "河北省石家庄市",
"861571411", "辽宁省大连市",
"861475723", "浙江省金华市",
"861861323", "四川省成都市",
"861346874", "陕西省榆林市",
"861826668", "山东省枣庄市",
"861334788", "江苏省常州市",
"86150573", "浙江省温州市",
"861365588", "浙江省宁波市",
"861535051", "河北省邯郸市",
"86158674", "浙江省宁波市",
"86180305", "四川省成都市",
"861360416", "辽宁省锦州市",
"861760662", "广东省阳江市",
"861821901", "广东省中山市",
"861539980", "湖南省怀化市",
"861370459", "黑龙江省大庆市",
"861592911", "陕西省延安市",
"861364454", "黑龙江省佳木斯市",
"861372382", "湖南省衡阳市",
"86131669", "吉林省吉林市",
"861333717", "内蒙古包头市",
"861829802", "安徽省合肥市",
"86180608", "福建省福州市",
"861533994", "山东省聊城市",
"86183329", "河北省唐山市",
"861522864", "四川省自贡市",
"861854507", "黑龙江省大庆市",
"86156076", "海南省海口市",
"861338412", "辽宁省鞍山市",
"86152901", "河南省驻马店市",
"861335838", "福建省厦门市",
"861502581", "甘肃省临夏回族自治州",
"861379787", "湖北省随州市",
"861524016", "安徽省六安市",
"861708327", "河北省沧州市",
"861479487", "内蒙古鄂尔多斯市",
"861860460", "黑龙江省哈尔滨市",
"861705632", "云南省昆明市",
"86145390", "广东省广州市",
"861454602", "青海省海东地区",
"86132597", "陕西省西安市",
"861863048", "河北省衡水市",
"861530638", "山东省烟台市",
"861308612", "江西省上饶市",
"861362298", "广东省韶关市",
"861454384", "贵州省黔南布依族苗族自治州",
"861302461", "浙江省绍兴市",
"861882888", "四川省自贡市",
"86188863", "贵州省铜仁地区",
"86151158", "湖南省娄底市",
"86138353", "山西省阳泉市",
"86158431", "吉林省长春市",
"861345133", "内蒙古赤峰市",
"861839375", "甘肃省武威市",
"861512867", "河北省廊坊市",
"861317581", "浙江省舟山市",
"861500438", "吉林省松原市",
"861517575", "河北省保定市",
"861384859", "内蒙古锡林郭勒盟",
"861566021", "湖南省岳阳市",
"861500883", "云南省文山壮族苗族自治州",
"861808428", "贵州省六盘水市",
"861316956", "广东省惠州市",
"861375405", "内蒙古通辽市",
"861855415", "山东省潍坊市",
"861458551", "山东省聊城市",
"86138582", "浙江省宁波市",
"861504837", "内蒙古赤峰市",
"86152359", "山西省运城市",
"861593215", "河北省唐山市",
"861308938", "吉林省白山市",
"861320571", "浙江省杭州市",
"861520585", "浙江省绍兴市",
"861509423", "云南省保山市",
"861337854", "贵州省黔南布依族苗族自治州",
"861311388", "河北省石家庄市",
"861567744", "广西贺州市",
"861475705", "浙江省嘉兴市",
"861583338", "河北省邢台市",
"861882433", "广东省东莞市",
"861346526", "山东省东营市",
"86158062", "江苏省苏州市",
"861314431", "吉林省长春市",
"861315609", "山东省威海市",
"861814417", "福建省宁德市",
"861319682", "江苏省徐州市",
"861855450", "山东省威海市",
"861840929", "陕西省榆林市",
"861871999", "新疆和田地区",
"861837151", "湖北省咸宁市",
"861776095", "四川省乐山市",
"861313986", "新疆阿克苏地区",
"861333528", "山东省泰安市",
"861530912", "陕西省榆林市",
"861452441", "黑龙江省齐齐哈尔市",
"861810559", "安徽省黄山市",
"861470248", "辽宁省大连市",
"861335483", "内蒙古阿拉善盟",
"861500156", "新疆巴音郭楞蒙古自治州",
"861554009", "内蒙古呼伦贝尔市",
"861779014", "四川省凉山彝族自治州",
"861809092", "四川省达州市",
"861775963", "福建省泉州市",
"861390662", "浙江省宁波市",
"861550458", "黑龙江省伊春市",
"861572251", "江苏省南通市",
"861308043", "河北省张家口市",
"861338820", "四川省达州市",
"861820456", "黑龙江省黑河市",
"861771587", "江苏省扬州市",
"861832479", "安徽省阜阳市",
"86133819", "上海市",
"86156538", "山东省烟台市",
"861532899", "四川省攀枝花市",
"861816965", "广西桂林市",
"861528128", "四川省雅安市",
"861800594", "福建省莆田市",
"861375153", "广东省佛山市",
"861770512", "江苏省连云港市",
"861471480", "广东省云浮市",
"861802679", "广东省江门市",
"861335574", "浙江省宁波市",
"86186252", "江苏省苏州市",
"86132165", "浙江省湖州市",
"861899040", "四川省阿坝藏族羌族自治州",
"861536746", "湖南省永州市",
"861864821", "内蒙古兴安盟",
"861361077", "吉林省延边朝鲜族自治州",
"861800024", "江西省九江市",
"861570395", "河南省漯河市",
"861817786", "广西河池市",
"861588762", "云南省西双版纳傣族自治州",
"861366856", "贵州省铜仁地区",
"861577148", "内蒙古巴彦淖尔市",
"861557020", "江西省九江市",
"861775108", "江苏省宿迁市",
"861364774", "广西梧州市",
"861521534", "山东省德州市",
"861844978", "新疆伊犁哈萨克自治州",
"861320958", "宁夏银川市",
"861339727", "湖北省孝感市",
"861370779", "广西北海市",
"861453769", "广西桂林市",
"86157635", "山东省聊城市",
"861860632", "山东省枣庄市",
"86156768", "广西河池市",
"861306011", "四川省德阳市",
"86187420", "辽宁省大连市",
"861776793", "吉林省延边朝鲜族自治州",
"861376819", "广西北海市",
"861359216", "河南省平顶山市",
"861561675", "湖南省益阳市",
"861560909", "四川省宜宾市",
"861348497", "陕西省延安市",
"861584980", "内蒙古兴安盟",
"861598317", "四川省自贡市",
"861361681", "浙江省杭州市",
"86132234", "河北省石家庄市",
"86135421", "广东省江门市",
"861880845", "四川省广安市",
"86136324", "广东省广州市",
"861890683", "浙江省嘉兴市",
"861505787", "浙江省丽水市",
"861814649", "新疆乌鲁木齐市",
"861816458", "浙江省金华市",
"861308926", "吉林省松原市",
"861829075", "新疆石河子市",
"861777019", "江西省鹰潭市",
"861583326", "河北省承德市",
"861530354", "山西省晋中市",
"861346538", "山东省泰安市",
"861308745", "云南省红河哈尼族彝族自治州",
"861582532", "宁夏石嘴山市",
"861343792", "江西省九江市",
"861379291", "山东省青岛市",
"861776525", "广东省广州市",
"861383587", "山西省运城市",
"861333098", "四川省成都市",
"86139872", "云南省大理白族自治州",
"861808436", "贵州省贵阳市",
"861580313", "河北省张家口市",
"861395594", "安徽省铜陵市",
"861339859", "贵州省黔西南布依族苗族自治州",
"861760430", "吉林省长春市",
"861840641", "山西省临汾市",
"86152302", "河北省保定市",
"861550965", "宁夏中卫市",
"86147943", "吉林省长春市",
"861569749", "湖南省长沙市",
"861317309", "山东省临沂市",
"86411", "辽宁省大连市",
"861773704", "河南省商丘市",
"86176800", "湖南省长沙市",
"86153931", "甘肃省兰州市",
"86137973", "湖北省荆州市",
"861374736", "内蒙古乌海市",
"861534316", "河北省廊坊市",
"861333536", "陕西省汉中市",
"86139817", "四川省成都市",
"861386557", "安徽省宿州市",
"86181751", "湖南省长沙市",
"861303258", "江苏省宿迁市",
"861332322", "河北省保定市",
"861581928", "广东省河源市",
"861518816", "云南省玉溪市",
"861773774", "河南省南阳市",
"861580731", "湖南省长沙市",
"861551669", "河南省驻马店市",
"861361518", "江苏省泰州市",
"861363475", "内蒙古通辽市",
"861875148", "江苏省扬州市",
"861898449", "贵州省黔东南苗族侗族自治州",
"861813732", "河南省开封市",
"861517795", "广西玉林市",
"86139810", "四川省德阳市",
"861821819", "广东省肇庆市",
"861379949", "福建省泉州市",
"861862412", "辽宁省鞍山市",
"861331070", "贵州省毕节地区",
"861808058", "四川省雅安市",
"861511880", "广东省珠海市",
"861363561", "安徽省淮北市",
"861853187", "河北省衡水市",
"861564936", "河南省南阳市",
"861879867", "贵州省遵义市",
"861394588", "黑龙江省伊春市",
"861301042", "浙江省嘉兴市",
"861880994", "新疆昌吉回族自治州",
"861374963", "河南省驻马店市",
"861869234", "湖南省衡阳市",
"861367832", "四川省内江市",
"86158029", "陕西省西安市",
"861369720", "湖北省襄樊市",
"861816036", "新疆伊犁哈萨克自治州",
"86135698", "河南省新乡市",
"861766032", "山东省菏泽市",
"861302523", "广东省汕头市",
"861508817", "广东省云浮市",
"861847144", "湖北省宜昌市",
"861325769", "广东省东莞市",
"861537462", "内蒙古呼伦贝尔市",
"861342447", "广东省广州市",
"861322825", "四川省南充市",
"861845446", "山东省聊城市",
"861561605", "湖南省怀化市",
"861560979", "青海省海西蒙古族藏族自治州",
"861318411", "山东省德州市",
"861472654", "四川省内江市",
"861327915", "陕西省渭南市",
"861550028", "吉林省白城市",
"861818437", "贵州省遵义市",
"861700637", "山东省济南市",
"861337582", "浙江省湖州市",
"861823013", "河北省张家口市",
"86186804", "广东省广州市",
"861538328", "河北省衡水市",
"861811139", "四川省广安市",
"861458908", "广东省韶关市",
"861348557", "安徽省宿州市",
"861514828", "内蒙古兴安盟",
"861370709", "江西省南昌市",
"861834544", "黑龙江省大庆市",
"861775178", "江苏省南京市",
"861364704", "江西省抚州市",
"86151551", "安徽省合肥市",
"861818368", "云南省文山壮族苗族自治州",
"861502932", "陕西省榆林市",
"861538849", "四川省攀枝花市",
"861509710", "甘肃省庆阳市",
"861889922", "新疆阿克苏地区",
"861880613", "江苏省苏州市",
"861594910", "江苏省盐城市",
"861332253", "西藏山南地区",
"861550598", "福建省三明市",
"86180941", "福建省南平市",
"861476508", "北京市",
"861800454", "黑龙江省佳木斯市",
"861817422", "湖南省邵阳市",
"86180315", "河北省唐山市",
"861478416", "河南省信阳市",
"861561980", "陕西省汉中市",
"86185775", "广西玉林市",
"861306957", "河南省漯河市",
"86151983", "云南省大理白族自治州",
"861317932", "江苏省盐城市",
"861858706", "云南省临沧市",
"861829703", "青海省海东地区",
"861771271", "江苏省宿迁市",
"861329377", "山西省临汾市",
"861772711", "广东省佛山市",
"861302093", "浙江省温州市",
"861538336", "河北省廊坊市",
"86183961", "福建省福州市",
"86132656", "广东省深圳市",
"861871241", "安徽省安庆市",
"86152345", "山西省长治市",
"86187368", "河南省商丘市",
"861358791", "浙江省湖州市",
"861870695", "甘肃省陇南市",
"861893531", "山西省阳泉市",
"86137858", "河北省衡水市",
"861773667", "广西桂林市",
"861554079", "内蒙古鄂尔多斯市",
"861345033", "广东省韶关市",
"861897862", "广西百色市",
"861458491", "山东省淄博市",
"86186738", "湖南省娄底市",
"861810499", "辽宁省辽阳市",
"861820943", "甘肃省白银市",
"861350542", "山东省青岛市",
"86152648", "山东省泰安市",
"861375475", "山东省淄博市",
"861379621", "黑龙江省哈尔滨市",
"86187665", "山东省烟台市",
"861816028", "新疆巴音郭楞蒙古自治州",
"861590383", "河南省商丘市",
"861319374", "河南省驻马店市",
"861861375", "河南省平顶山市",
"861322122", "浙江省湖州市",
"861306335", "安徽省淮北市",
"861324233", "广东省广州市",
"861878760", "云南省文山壮族苗族自治州",
"861368827", "四川省资阳市",
"86135823", "河北省石家庄市",
"86152911", "陕西省延安市",
"861476017", "福建省泉州市",
"861320501", "福建省福州市",
"861334660", "河南省商丘市",
"861889028", "湖南省衡阳市",
"861882600", "广东省中山市",
"861870947", "甘肃省酒泉市",
"86184601", "江西省宜春市",
"861315585", "江西省吉安市",
"861872684", "安徽省淮北市",
"86139460", "黑龙江省哈尔滨市",
"861370869", "云南省玉溪市",
"861300061", "湖北省荆门市",
"861370283", "广东省佛山市",
"861360658", "浙江省宁波市",
"861354587", "湖北省武汉市",
"861502596", "甘肃省陇南市",
"86130600", "四川省成都市",
"861820932", "甘肃省定西市",
"861325809", "山东省潍坊市",
"861560343", "山西省太原市",
"861530577", "浙江省温州市",
"861812199", "四川省泸州市",
"861350533", "山东省淄博市",
"861329882", "吉林省松原市",
"86155932", "甘肃省定西市",
"861528544", "贵州省铜仁地区",
"861320422", "辽宁省鞍山市",
"861554326", "吉林省松原市",
"861521975", "广东省茂名市",
"86189734", "湖南省衡阳市",
"861317038", "湖南省娄底市",
"861352312", "河南省周口市",
"861324242", "广东省深圳市",
"861321981", "四川省攀枝花市",
"861813045", "安徽省安庆市",
"861470356", "山西省晋城市",
"861808314", "贵州省安顺市",
"861459417", "云南省迪庆藏族自治州",
"861780765", "广东省深圳市",
"861866125", "江苏省连云港市",
"86150584", "浙江省宁波市",
"86138321", "河北省石家庄市",
"861502943", "陕西省渭南市",
"861860815", "四川省绵阳市",
"861302851", "陕西省西安市",
"861879707", "青海省海东地区",
"861337657", "广东省肇庆市",
"861372059", "陕西省咸阳市",
"86170780", "四川省成都市",
"861559994", "新疆喀什地区",
"86185929", "陕西省西安市",
"86158683", "浙江省嘉兴市",
"861831646", "广东省云浮市",
"861359717", "广西南宁市",
"861379373", "山东省枣庄市",
"861556950", "新疆吐鲁番地区",
"861560500", "福建省泉州市",
"861860850", "贵州省贵阳市",
"861301735", "湖南省郴州市",
"861816922", "湖南省永州市",
"861539301", "甘肃省临夏回族自治州",
"861802154", "江苏省南京市",
"861534434", "吉林省通化市",
"861587268", "湖北省十堰市",
"861770977", "青海省海西蒙古族藏族自治州",
"861596034", "福建省龙岩市",
"861474314", "吉林省四平市",
"861801446", "江苏省南京市",
"861333144", "吉林省通化市",
"861518547", "贵州省黔南布依族苗族自治州",
"861317943", "江苏省泰州市",
"861700798", "江西省南昌市",
"86133422", "辽宁省大连市",
"861303346", "山西省长治市",
"861881553", "安徽省芜湖市",
"861766043", "山东省青岛市",
"861329494", "云南省昆明市",
"861314964", "黑龙江省七台河市",
"861572672", "西藏日喀则地区",
"86147365", "云南省昆明市",
"861820379", "河南省洛阳市",
"861323480", "内蒙古包头市",
"861335357", "山西省临汾市",
"861529721", "青海省西宁市",
"861309556", "安徽省安庆市",
"861459649", "甘肃省白银市",
"861808952", "四川省成都市",
"861557999", "江西省赣州市",
"861572440", "辽宁省本溪市",
"861838116", "四川省眉山市",
"861527272", "湖北省咸宁市",
"861858277", "四川省眉山市",
"861523560", "山西省晋城市",
"861373031", "河北省张家口市",
"861454663", "广东省江门市",
"861310351", "山西省太原市",
"861351561", "安徽省淮北市",
"861319497", "四川省成都市",
"86177121", "江苏省徐州市",
"861809565", "安徽省合肥市",
"861501992", "广东省珠海市",
"861855241", "江苏省无锡市",
"861810915", "陕西省安康市",
"861576888", "广东省广州市",
"86155756", "湖南省郴州市",
"861452250", "浙江省绍兴市",
"861519210", "山东省枣庄市",
"861829863", "甘肃省陇南市",
"861776562", "广东省佛山市",
"861335935", "甘肃省武威市",
"861780063", "内蒙古巴彦淖尔市",
"861352954", "云南省保山市",
"861813743", "河南省驻马店市",
"861593441", "山西省晋中市",
"86188403", "陕西省西安市",
"861873508", "山西省大同市",
"861772890", "广东省东莞市",
"861810950", "宁夏银川市",
"861317026", "安徽省宣城市",
"861364548", "山东省泰安市",
"861351475", "内蒙古通辽市",
"861866822", "浙江省杭州市",
"861809471", "浙江省杭州市",
"861550922", "陕西省榆林市",
"861563669", "黑龙江省双鸭山市",
"861588593", "贵州省六盘水市",
"861871590", "河北省承德市",
"86189564", "安徽省六安市",
"861882985", "陕西省商洛市",
"861559613", "陕西省安康市",
"86182933", "甘肃省平凉市",
"861595122", "江苏省常州市",
"86135748", "湖南省长沙市",
"861332365", "河南省开封市",
"861889598", "云南省曲靖市",
"861760603", "福建省泉州市",
"861301033", "江苏省无锡市",
"861351405", "福建省莆田市",
"861809401", "福建省福州市",
"861582543", "浙江省温州市",
"861359198", "辽宁省葫芦岛市",
"861834778", "内蒙古通辽市",
"861365315", "河北省唐山市",
"861319557", "安徽省宿州市",
"861320786", "广西百色市",
"861760673", "浙江省嘉兴市",
"861343151", "广东省东莞市",
"861514903", "内蒙古兴安盟",
"861847528", "广东省肇庆市",
"861700834", "浙江省台州市",
"861871450", "黑龙江省哈尔滨市",
"86177270", "广东省江门市",
"861583079", "河北省保定市",
"861843854", "河南省安阳市",
"861533948", "甘肃省酒泉市",
"861377751", "浙江省金华市",
"861771393", "四川省凉山彝族自治州",
"861889458", "甘肃省天水市",
"861504989", "内蒙古鄂尔多斯市",
"861538414", "浙江省绍兴市",
"861886663", "山东省淄博市",
"861595702", "浙江省衢州市",
"861365350", "山西省忻州市",
"861366699", "福建省三明市",
"861313347", "山西省临汾市",
"861572384", "广西梧州市",
"861557241", "湖北省恩施土家族苗族自治州",
"861537425", "江西省上饶市",
"861361469", "黑龙江省佳木斯市",
"86187879", "云南省西双版纳傣族自治州",
"86185556", "安徽省安庆市",
"861339696", "浙江省温州市",
"861510769", "广东省东莞市",
"86135124", "天津市",
"861590457", "黑龙江省大兴安岭地区",
"861333992", "湖北省黄石市",
"861858207", "四川省遂宁市",
"861329554", "安徽省淮南市",
"861869080", "新疆克孜勒苏柯尔克孜自治州",
"861527202", "湖北省黄冈市",
"861860643", "山东省淄博市",
"86139328", "河北省衡水市",
"86132051", "江苏省苏州市",
"861768957", "西藏阿里地区",
"861582996", "陕西省商洛市",
"861507625", "河北省保定市",
"861355780", "广西南宁市",
"861323344", "山西省晋中市",
"86159764", "广东省江门市",
"861362244", "广东省云浮市",
"861309496", "江苏省镇江市",
"861561589", "山东省临沂市",
"861559142", "陕西省商洛市",
"861878870", "贵州省黔东南苗族侗族自治州",
"861572602", "山东省菏泽市",
"861339385", "河南省焦作市",
"861335066", "四川省南充市",
"861336545", "山东省烟台市",
"861539371", "河南省郑州市",
"861889965", "新疆昌吉回族自治州",
"861866705", "浙江省温州市",
"861560570", "浙江省衢州市",
"861348374", "河北省唐山市",
"861318245", "江苏省泰州市",
"861325157", "黑龙江省大兴安岭地区",
"861308032", "山西省大同市",
"861770907", "四川省德阳市",
"861875094", "福建省厦门市",
"861392351", "广东省潮州市",
"861863369", "河北省邢台市",
"861313758", "河南省开封市",
"861705012", "天津市",
"861558318", "四川省广元市",
"861894798", "内蒙古乌海市",
"861327559", "安徽省黄山市",
"861772342", "四川省达州市",
"861846492", "山东省临沂市",
"861525284", "江苏省连云港市",
"861822883", "四川省广元市",
"86182598", "福建省三明市",
"861379303", "山东省菏泽市",
"861809998", "新疆喀什地区",
"86152963", "广西南宁市",
"861802585", "广东省深圳市",
"861879777", "湖南省常德市",
"861891439", "江苏省南通市",
"861830729", "湖北省武汉市",
"861830857", "贵州省毕节地区",
"861330275", "广东省揭阳市",
"86131840", "山东省烟台市",
"861801953", "安徽省芜湖市",
"861530507", "福建省漳州市",
"861317456", "福建省莆田市",
"861818149", "四川省巴中市",
"861779747", "青海省海西蒙古族藏族自治州",
"861847536", "广东省深圳市",
"861554285", "辽宁省营口市",
"861811447", "江苏省南京市",
"861386682", "安徽省池州市",
"86180784", "广西桂林市",
"861373350", "湖北省孝感市",
"861532656", "黑龙江省双鸭山市",
"861310030", "湖南省岳阳市",
"861882442", "广东省东莞市",
"861521905", "广东省肇庆市",
"861856769", "河南省安阳市",
"861367615", "广东省江门市",
"861354830", "四川省内江市",
"861515287", "江苏省南通市",
"861815851", "浙江省杭州市",
"861882670", "广东省阳江市",
"861389956", "新疆克拉玛依市",
"861328360", "山西省忻州市",
"861367650", "浙江省丽水市",
"861381548", "江苏省镇江市",
"86183913", "陕西省渭南市",
"861373315", "河南省郑州市",
"86139467", "黑龙江省鹤岗市",
"861533735", "湖北省十堰市",
"861390349", "山西省朔州市",
"861876238", "江苏省盐城市",
"861893304", "广东省潮州市",
"861835930", "福建省龙岩市",
"86155112", "河北省保定市",
"861452877", "宁夏石嘴山市",
"861551890", "河南省信阳市",
"861896652", "陕西省渭南市",
"861539680", "江苏省徐州市",
"861335420", "辽宁省沈阳市",
"861529839", "江苏省南京市",
"861310910", "陕西省渭南市",
"861360152", "江苏省无锡市",
"861592611", "湖北省恩施土家族苗族自治州",
"861309560", "浙江省嘉兴市",
"861826103", "江苏省泰州市",
"86180978", "新疆伊犁哈萨克自治州",
"861368533", "山东省淄博市",
"861303171", "山东省济南市",
"86150019", "上海市",
"86155177", "河南省焦作市",
"861506110", "江苏省常州市",
"861526586", "山东省东营市",
"861558343", "四川省成都市",
"86187786", "广西百色市",
"861859348", "湖南省邵阳市",
"861398582", "贵州省黔东南苗族侗族自治州",
"861770538", "山东省泰安市",
"861509480", "山东省泰安市",
"861893682", "江苏省泰州市",
"86189498", "安徽省合肥市",
"861597328", "湖南省邵阳市",
"86138842", "甘肃省白银市",
"86133710", "山东省潍坊市",
"861837449", "湖南省长沙市",
"861378805", "广西玉林市",
"861810311", "河北省石家庄市",
"861340793", "江西省上饶市",
"861371723", "广东省肇庆市",
"861304309", "福建省漳州市",
"861810966", "安徽省安庆市",
"86152671", "浙江省杭州市",
"861520790", "江西省新余市",
"861394879", "内蒙古锡林郭勒盟",
"861897298", "湖北省随州市",
"861308912", "吉林省长春市",
"861583312", "河北省保定市",
"86180451", "黑龙江省哈尔滨市",
"861896393", "湖北省十堰市",
"861567355", "湖南省邵阳市",
"861528665", "贵州省六盘水市",
"861316569", "湖北省咸宁市",
"86145360", "江苏省南京市",
"861569001", "河北省邯郸市",
"86132567", "山东省济南市",
"861534322", "湖南省湘潭市",
"861530938", "甘肃省天水市",
"861576685", "广东省湛江市",
"861518822", "河南省南阳市",
"861332316", "河北省廊坊市",
"861882799", "江西省萍乡市",
"861376671", "黑龙江省鹤岗市",
"861310337", "河北省沧州市",
"861458319", "江西省宜春市",
"861373057", "河北省沧州市",
"861332961", "贵州省贵阳市",
"861338269", "江苏省徐州市",
"861323891", "辽宁省朝阳市",
"861338883", "云南省临沧市",
"861381513", "江苏省无锡市",
"861518073", "贵州省贵阳市",
"861814362", "吉林省吉林市",
"86181181", "江苏省苏州市",
"861582518", "云南省红河哈尼族彝族自治州",
"861346512", "山东省威海市",
"861886846", "浙江省金华市",
"861360810", "四川省德阳市",
"86136689", "广东省广州市",
"86188628", "江苏省南通市",
"861809644", "安徽省马鞍山市",
"861586984", "湖南省郴州市",
"861572178", "贵州省六盘水市",
"861310468", "黑龙江省鹤岗市",
"861337631", "山东省威海市",
"861450990", "新疆克拉玛依市",
"861535208", "甘肃省庆阳市",
"86184554", "安徽省淮南市",
"861880567", "安徽省阜阳市",
"861557083", "湖南省娄底市",
"861530745", "湖南省怀化市",
"861308354", "江苏省徐州市",
"861839444", "甘肃省天水市",
"861366770", "广西防城港市",
"861572728", "湖北省武汉市",
"861450306", "河北省衡水市",
"86188325", "河北省唐山市",
"861860277", "湖北省襄樊市",
"861510588", "浙江省丽水市",
"861776439", "安徽省六安市",
"861850489", "内蒙古锡林郭勒盟",
"861518125", "四川省攀枝花市",
"861859829", "广东省中山市",
"861769833", "河南省安阳市",
"861556966", "甘肃省定西市",
"861860866", "湖北省武汉市",
"861705379", "吉林省长春市",
"861597849", "河南省驻马店市",
"861390828", "四川省广安市",
"861770526", "江苏省泰州市",
"861571627", "江苏省南通市",
"861459325", "四川省泸州市",
"861582007", "山东省济宁市",
"86131576", "浙江省台州市",
"861378102", "河南省三门峡市",
"861860618", "江苏省徐州市",
"861318399", "四川省德阳市",
"861837278", "湖北省鄂州市",
"861595628", "安徽省宣城市",
"861336707", "江西省赣州市",
"861345897", "四川省德阳市",
"861399488", "山西省运城市",
"86134605", "河南省许昌市",
"861362065", "山西省长治市",
"861841973", "甘肃省平凉市",
"861869387", "甘肃省酒泉市",
"861378172", "河南省漯河市",
"86184828", "四川省南充市",
"861510611", "江苏省常州市",
"861582077", "广东省深圳市",
"861399732", "青海省海东地区",
"861539975", "湖南省邵阳市",
"861830831", "四川省泸州市",
"861845261", "江苏省无锡市",
"861810035", "山西省太原市",
"861479098", "安徽省马鞍山市",
"861341541", "广东省中山市",
"861476889", "山东省滨州市",
"861841903", "甘肃省天水市",
"861596693", "山东省青岛市",
"861335015", "四川省内江市",
"861561046", "山东省青岛市",
"86130363", "重庆市",
"861315811", "贵州省遵义市",
"861305290", "江苏省镇江市",
"86188491", "河北省石家庄市",
"86180853", "贵州省安顺市",
"861336777", "广西钦州市",
"861591191", "云南省保山市",
"861312349", "广西北海市",
"861887091", "江西省南昌市",
"861369783", "山东省东营市",
"861476263", "江苏省宿迁市",
"861879545", "江苏省南通市",
"86183392", "河南省郑州市",
"861533224", "陕西省渭南市",
"86147453", "广东省广州市",
"861539146", "云南省昭通市",
"861505921", "福建省漳州市",
"861815837", "浙江省金华市",
"861824061", "河南省安阳市",
"861330817", "四川省成都市",
"861301913", "吉林省长春市",
"861817416", "广西桂林市",
"861478422", "河南省郑州市",
"861454339", "内蒙古锡林郭勒盟",
"861705309", "海南省海口市",
"86133343", "广东省佛山市",
"861335050", "四川省乐山市",
"861351398", "河南省驻马店市",
"861361532", "山东省青岛市",
"861328356", "山西省晋城市",
"861818240", "陕西省西安市",
"861894202", "湖南省衡阳市",
"861347477", "内蒙古鄂尔多斯市",
"861359353", "山西省临汾市",
"861366700", "江西省南昌市",
"861860581", "浙江省杭州市",
"861373427", "山西省运城市",
"861836540", "江西省赣州市",
"861839380", "甘肃省甘南藏族自治州",
"861862438", "辽宁省大连市",
"861364513", "江苏省连云港市",
"861387006", "江西省南昌市",
"861858643", "贵州省安顺市",
"861392337", "广东省珠海市",
"861532660", "黑龙江省黑河市",
"861373911", "江苏省无锡市",
"861535278", "新疆喀什地区",
"861559648", "陕西省铜川市",
"861369085", "广东省梅州市",
"861819008", "四川省德阳市",
"861556035", "内蒙古赤峰市",
"861569071", "河南省平顶山市",
"861823267", "河北省廊坊市",
"86398", "河南省三门峡市",
"86132560", "山东省日照市",
"861365366", "山西省太原市",
"861454972", "浙江省嘉兴市",
"861537930", "甘肃省临夏回族自治州",
"861584768", "内蒙古呼和浩特市",
"861392468", "广东省江门市",
"861810733", "湖南省长沙市",
"861590431", "吉林省长春市",
"861871466", "黑龙江省鹤岗市",
"861365911", "陕西省西安市",
"861768931", "福建省宁德市",
"861560318", "河北省衡水市",
"861304379", "河南省洛阳市",
"861378875", "广西玉林市",
"861362936", "甘肃省张掖市",
"861508089", "湖南省湘西土家族苗族自治州",
"861865937", "福建省宁德市",
"861840397", "河南省信阳市",
"861572963", "四川省绵阳市",
"86157586", "云南省临沧市",
"861806893", "江苏省宿迁市",
"861829514", "宁夏固原市",
"861857796", "广西南宁市",
"86133717", "北京市",
"861365427", "辽宁省辽阳市",
"861862426", "辽宁省大连市",
"861536673", "江苏省泰州市",
"861596914", "云南省曲靖市",
"86137066", "浙江省温州市",
"861803196", "河北省秦皇岛市",
"861394809", "内蒙古呼伦贝尔市",
"861502918", "陕西省西安市",
"861327742", "湖北省黄冈市",
"86184693", "云南省楚雄彝族自治州",
"86183133", "云南省红河哈尼族彝族自治州",
"861535449", "河北省石家庄市",
"86155170", "河南省商丘市",
"861514662", "黑龙江省哈尔滨市",
"86151396", "河南省驻马店市",
"861471710", "甘肃省庆阳市",
"861507828", "广西柳州市",
"861504523", "黑龙江省齐齐哈尔市",
"86134642", "辽宁省朝阳市",
"861590320", "河北省邯郸市",
"861319531", "安徽省芜湖市",
"861506584", "山东省泰安市",
"861788129", "新疆阿克苏地区",
"861865355", "山东省临沂市",
"861505649", "安徽省马鞍山市",
"861823876", "河南省新乡市",
"861869762", "安徽省六安市",
"861800967", "安徽省亳州市",
"861764057", "辽宁省朝阳市",
"861831863", "广东省广州市",
"861893374", "广东省河源市",
"861831289", "广东省中山市",
"861377737", "浙江省杭州市",
"861537317", "河北省沧州市",
"861300849", "陕西省宝鸡市",
"861586639", "山东省菏泽市",
"861317918", "吉林省四平市",
"86150844", "重庆市",
"86184743", "湖南省湘西土家族苗族自治州",
"861813606", "江苏省苏州市",
"861512964", "陕西省安康市",
"86137397", "河北省石家庄市",
"86181226", "广东省揭阳市",
"861570991", "新疆乌鲁木齐市",
"861362592", "福建省漳州市",
"861815989", "福建省厦门市",
"861819902", "新疆哈密地区",
"86134792", "江西省九江市",
"861329070", "河南省焦作市",
"861811801", "江苏省常州市",
"861880648", "山东省青岛市",
"861598425", "四川省内江市",
"861336206", "浙江省丽水市",
"861760746", "湖南省永州市",
"861319188", "河北省石家庄市",
"86156370", "河南省商丘市",
"861861498", "河南省郑州市",
"86189237", "广东省深圳市",
"86153864", "湖南省长沙市",
"861305541", "福建省福州市",
"861760925", "陕西省安康市",
"861864739", "内蒙古呼和浩特市",
"861366860", "山东省菏泽市",
"861863400", "河北省唐山市",
"861476937", "云南省普洱市",
"86180280", "广东省广州市",
"86150255", "重庆市",
"861870734", "湖南省衡阳市",
"861536430", "湖南省益阳市",
"861450599", "辽宁省葫芦岛市",
"861522967", "陕西省宝鸡市",
"861866668", "广东省汕头市",
"86170889", "广东省汕头市",
"861860776", "广西百色市",
"86183673", "浙江省嘉兴市",
"861508205", "四川省泸州市",
"861869453", "浙江省嘉兴市",
"861308577", "广东省汕头市",
"861529258", "新疆昌吉回族自治州",
"861355968", "福建省漳州市",
"86155630", "山东省滨州市",
"861810742", "湖南省常德市",
"86147039", "四川省成都市",
"861803677", "江苏省淮安市",
"861399045", "四川省甘孜藏族自治州",
"861380840", "湖南省岳阳市",
"861884971", "云南省楚雄彝族自治州",
"86182814", "四川省绵阳市",
"861776147", "四川省雅安市",
"861506630", "山东省威海市",
"861595116", "江苏省泰州市",
"861328409", "黑龙江省大庆市",
"861787600", "广东省中山市",
"861780678", "广东省茂名市",
"861820918", "陕西省西安市",
"861534365", "甘肃省武威市",
"861321107", "河北省邢台市",
"861859169", "陕西省延安市",
"86151067", "山东省济宁市",
"861313691", "黑龙江省绥化市",
"861365282", "广东省潮州市",
"861769906", "新疆阿勒泰地区",
"861317012", "安徽省铜陵市",
"861352338", "河南省周口市",
"861550916", "陕西省汉中市",
"861814325", "西藏昌都地区",
"861452767", "广西柳州市",
"861500160", "新疆伊犁哈萨克自治州",
"86159260", "湖北省武汉市",
"861572237", "青海省海西蒙古族藏族自治州",
"861569552", "安徽省蚌埠市",
"861593266", "河北省石家庄市",
"861890541", "山东省济南市",
"861331377", "福建省福州市",
"861361543", "山东省滨州市",
"861599419", "河南省周口市",
"861877890", "广西玉林市",
"861346977", "湖北省荆门市",
"86182161", "湖南省常德市",
"861511978", "广东省清远市",
"861471891", "西藏拉萨市",
"861538784", "江西省赣州市",
"861803764", "河南省商丘市",
"861327035", "江苏省徐州市",
"861390903", "四川省眉山市",
"861373282", "吉林省辽源市",
"861840474", "内蒙古乌兰察布市",
"86184317", "河北省沧州市",
"861304038", "吉林省四平市",
"861571824", "广东省深圳市",
"86187777", "广西钦州市",
"861325588", "浙江省台州市",
"86155186", "河南省商丘市",
"861898792", "云南省普洱市",
"861320416", "辽宁省锦州市",
"861352326", "河南省平顶山市",
"861356798", "浙江省湖州市",
"86184372", "河南省安阳市",
"861304596", "福建省漳州市",
"861552587", "山西省运城市",
"861577470", "内蒙古呼伦贝尔市",
"86130959", "浙江省宁波市",
"861323423", "辽宁省葫芦岛市",
"861565130", "江苏省南通市",
"861458537", "河南省漯河市",
"861399743", "青海省黄南藏族自治州",
"861309969", "云南省文山壮族苗族自治州",
"861887186", "湖北省武汉市",
"861591752", "广东省肇庆市",
"861840583", "浙江省嘉兴市",
"86181030", "广东省东莞市",
"861809847", "安徽省马鞍山市",
"861314457", "黑龙江省齐齐哈尔市",
"86177774", "广西梧州市",
"861322298", "江苏省苏州市",
"861363398", "河南省三门峡市",
"861337111", "山东省枣庄市",
"861893497", "广西南宁市",
"861568965", "山东省日照市",
"861459362", "贵州省黔南布依族苗族自治州",
"861820460", "黑龙江省哈尔滨市",
"861361996", "新疆昌吉回族自治州",
"861761299", "陕西省榆林市",
"861339212", "广东省广州市",
"861823048", "河北省衡水市",
"86136597", "广东省湛江市",
"861362873", "云南省红河哈尼族彝族自治州",
"86153222", "广东省广州市",
"861584808", "内蒙古乌海市",
"861884558", "黑龙江省哈尔滨市",
"861805168", "江苏省盐城市",
"861453611", "江苏省无锡市",
"861388907", "西藏阿里地区",
"861816916", "宁夏吴忠市",
"861355455", "湖北省荆州市",
"861457092", "江苏省连云港市",
"86185667", "广东省深圳市",
"861332434", "吉林省四平市",
"86188194", "广东省广州市",
"861362022", "广东省深圳市",
"861584878", "内蒙古呼伦贝尔市",
"861521623", "江西省吉安市",
"861577113", "湖北省孝感市",
"8613445", "上海市",
"861398657", "湖北省黄石市",
"861323755", "江西省新余市",
"86157512", "江苏省连云港市",
"861893557", "青海省海西蒙古族藏族自治州",
"861354158", "四川省泸州市",
"86185660", "广东省佛山市",
"861370690", "福建省南平市",
"86137661", "吉林省通化市",
"861590964", "宁夏固原市",
"861769842", "河南省商丘市",
"861326785", "广东省湛江市",
"861322636", "广东省云浮市",
"861896587", "福建省泉州市",
"861821252", "贵州省铜仁地区",
"861369448", "吉林省松原市",
"861850661", "广东省阳江市",
"861804571", "黑龙江省鸡西市",
"861361370", "河南省商丘市",
"861571796", "江西省吉安市",
"861380392", "河南省鹤壁市",
"861705026", "湖南省长沙市",
"861529987", "新疆吐鲁番地区",
"861478465", "黑龙江省绥化市",
"86135771", "云南省昆明市",
"861334656", "广东省肇庆市",
"861826062", "江苏省镇江市",
"861510131", "甘肃省兰州市",
"861324594", "内蒙古赤峰市",
"86187770", "广西防城港市",
"861355723", "广西桂林市",
"86133965", "浙江省杭州市",
"86130311", "北京市",
"861580348", "山西省运城市",
"861587195", "湖北省咸宁市",
"861569492", "河北省衡水市",
"861570478", "内蒙古巴彦淖尔市",
"861535137", "四川省内江市",
"861380653", "浙江省温州市",
"861346907", "湖南省长沙市",
"861304456", "福建省泉州市",
"861355173", "四川省泸州市",
"861331307", "河北省沧州市",
"861568028", "四川省宜宾市",
"861869872", "辽宁省大连市",
"86159267", "湖北省黄冈市",
"861806421", "湖北省荆州市",
"861475547", "安徽省六安市",
"86183834", "四川省凉山彝族自治州",
"861385941", "福建省三明市",
"861507168", "湖北省黄冈市",
"86184310", "河北省邯郸市",
"861330614", "江苏省常州市",
"861390973", "青海省黄南藏族自治州",
"861306931", "河南省开封市",
"861787670", "广东省河源市",
"861454517", "湖南省湘西土家族苗族自治州",
"861869593", "河南省新乡市",
"861328479", "内蒙古巴彦淖尔市",
"861708700", "广西南宁市",
"86131580", "贵州省贵阳市",
"861350759", "福建省三明市",
"861336867", "贵州省毕节地区",
"861848517", "贵州省遵义市",
"86151060", "福建省泉州市",
"861598753", "云南省文山壮族苗族自治州",
"861843631", "河南省平顶山市",
"861700651", "江苏省无锡市",
"861321727", "湖北省宜昌市",
"861580829", "四川省凉山彝族自治州",
"861330546", "山东省东营市",
"86180154", "江苏省苏州市",
"861786933", "云南省楚雄彝族自治州",
"86155637", "山东省济宁市",
"861860706", "江西省吉安市",
"861508275", "四川省南充市",
"861308507", "安徽省淮北市",
"861302989", "黑龙江省鸡西市",
"861568036", "四川省眉山市",
"861899758", "新疆伊犁哈萨克自治州",
"861511491", "陕西省延安市",
"86153269", "内蒙古鄂尔多斯市",
"861514625", "黑龙江省哈尔滨市",
"86156377", "河南省南阳市",
"861580757", "广东省佛山市",
"861360791", "江西省南昌市",
"861377228", "陕西省延安市",
"86180287", "广东省深圳市",
"861805973", "福建省宁德市",
"861362452", "黑龙江省齐齐哈尔市",
"861863470", "山西省临汾市",
"861308018", "河南省许昌市",
"86131749", "浙江省金华市",
"861360389", "河南省焦作市",
"861330993", "新疆石河子市",
"861566437", "河南省驻马店市",
"861869725", "青海省西宁市",
"861819972", "新疆克孜勒苏柯尔克孜自治州",
"861311724", "湖北省武汉市",
"86156312", "河北省保定市",
"861560424", "辽宁省本溪市",
"861318576", "浙江省台州市",
"86183708", "江西省赣州市",
"861563890", "河南省郑州市",
"861811230", "江苏省常州市",
"861564244", "辽宁省朝阳市",
"86185391", "河南省焦作市",
"86150249", "内蒙古呼和浩特市",
"861813676", "江苏省苏州市",
"861368542", "山东省青岛市",
"861558332", "四川省眉山市",
"86136023", "广东省东莞市",
"861356834", "四川省达州市",
"861587892", "广西河池市",
"86138999", "新疆乌鲁木齐市",
"861322628", "广东省茂名市",
"861350827", "四川省南充市",
"861887640", "福建省厦门市",
"861569884", "辽宁省沈阳市",
"861779934", "新疆和田地区",
"861459787", "新疆乌鲁木齐市",
"861762519", "江苏省常州市",
"861350248", "广东省汕头市",
"861329720", "湖北省武汉市",
"861327832", "吉林省松原市",
"861875750", "浙江省绍兴市",
"861814373", "甘肃省白银市",
"861822412", "四川省巴中市",
"861510350", "山西省忻州市",
"861472741", "贵州省黔南布依族苗族自治州",
"861868434", "吉林省四平市",
"861454728", "浙江省丽水市",
"86182568", "安徽省阜阳市",
"861869005", "陕西省延安市",
"861323561", "湖北省荆州市",
"861781769", "广东省东莞市",
"861319088", "内蒙古通辽市",
"861539878", "云南省楚雄彝族自治州",
"861377847", "四川省阿坝藏族羌族自治州",
"861839498", "甘肃省甘南藏族自治州",
"861894889", "广东省中山市",
"861770607", "福建省泉州市",
"861894263", "河北省石家庄市",
"861355705", "广西玉林市",
"861571506", "福建省漳州市",
"861871856", "广东省深圳市",
"861323475", "内蒙古通辽市",
"861538493", "新疆阿克苏地区",
"861454178", "浙江省丽水市",
"861889665", "江苏省镇江市",
"861557229", "湖北省武汉市",
"861300739", "湖南省邵阳市",
"861510315", "河北省唐山市",
"861306854", "广东省阳江市",
"861399976", "新疆博尔塔拉蒙古自治州",
"861351480", "内蒙古呼伦贝尔市",
"861898572", "贵州省安顺市",
"861881414", "广东省广州市",
"861317112", "内蒙古通辽市",
"861356578", "新疆塔城地区",
"861367950", "广东省清远市",
"86187759", "广西南宁市",
"861888839", "山东省菏泽市",
"861324704", "江西省抚州市",
"861501222", "云南省丽江市",
"861803181", "河北省衡水市",
"861857399", "湖南省湘西土家族苗族自治州",
"861595016", "江苏省苏州市",
"861882970", "陕西省西安市",
"86153518", "江苏省连云港市",
"86182804", "四川省成都市",
"861520979", "青海省海西蒙古族藏族自治州",
"861570758", "广东省肇庆市",
"861532956", "贵州省铜仁地区",
"861367915", "陕西省安康市",
"861393440", "山西省朔州市",
"861841962", "甘肃省定西市",
"861319211", "广东省潮州市",
"861390068", "浙江省嘉兴市",
"86130912", "河北省保定市",
"861318824", "辽宁省本溪市",
"861531552", "山东省青岛市",
"861831802", "广东省广州市",
"861337288", "辽宁省本溪市",
"861891340", "江苏省镇江市",
"861334324", "河北省石家庄市",
"861899478", "江苏省宿迁市",
"861708590", "福建省福州市",
"861593059", "河北省秦皇岛市",
"861339543", "山东省滨州市",
"861341983", "河南省三门峡市",
"861369377", "河南省南阳市",
"861554200", "辽宁省锦州市",
"861533648", "山东省青岛市",
"861874497", "贵州省黔西南布依族苗族自治州",
"861598473", "四川省甘孜藏族自治州",
"861839901", "新疆和田地区",
"861334569", "安徽省黄山市",
"861521980", "广东省韶关市",
"861568708", "云南省昆明市",
"861504689", "黑龙江省大庆市",
"861859394", "广西玉林市",
"861760973", "青海省黄南藏族自治州",
"861304138", "吉林省长春市",
"861333353", "山西省阳泉市",
"861315570", "江西省九江市",
"861596089", "福建省龙岩市",
"861825744", "浙江省宁波市",
"861378978", "内蒙古巴彦淖尔市",
"86187702", "江西省九江市",
"861350479", "吉林省长春市",
"861802343", "广东省中山市",
"861508914", "广东省汕头市",
"861860596", "福建省漳州市",
"861308797", "广西南宁市",
"861879964", "新疆哈密地区",
"861339300", "河北省邯郸市",
"861364233", "广东省广州市",
"861830741", "湖南省怀化市",
"86159794", "江西省萍乡市",
"861457192", "浙江省嘉兴市",
"861897244", "湖北省恩施土家族苗族自治州",
"861356951", "河南省开封市",
"861572902", "河南省三门峡市",
"86156911", "陕西省延安市",
"861705706", "上海市",
"861348445", "陕西省汉中市",
"861317850", "广东省佛山市",
"861520332", "河北省保定市",
"861860943", "甘肃省白银市",
"861582696", "湖北省黄石市",
"861865651", "安徽省马鞍山市",
"861872639", "安徽省合肥市",
"86156648", "陕西省西安市",
"861317815", "福建省龙岩市",
"861339996", "新疆巴音郭楞蒙古自治州",
"861553975", "河南省许昌市",
"86138627", "江苏省南通市",
"86133499", "湖北省武汉市",
"861362772", "广西柳州市",
"861591186", "云南省怒江傈僳族自治州",
"861580477", "内蒙古鄂尔多斯市",
"861398464", "贵州省六盘水市",
"861560154", "江苏省苏州市",
"861827239", "湖北省仙桃市",
"861502850", "河北省张家口市",
"861802500", "广东省阳江市",
"861565030", "山东省德州市",
"861570347", "山西省临汾市",
"861315343", "山东省枣庄市",
"861362702", "江西省九江市",
"86147698", "山东省德州市",
"861360465", "黑龙江省大庆市",
"861318796", "云南省红河哈尼族彝族自治州",
"861832542", "山东省青岛市",
"861884819", "内蒙古巴彦淖尔市",
"861454963", "黑龙江省七台河市",
"861770764", "广东省阳江市",
"861808652", "湖北省武汉市",
"861802570", "广东省潮州市",
"861707424", "浙江省杭州市",
"861303552", "贵州省遵义市",
"861342184", "广东省深圳市",
"861705776", "北京市",
"861560585", "浙江省绍兴市",
"861310858", "云南省昭通市",
"861572972", "四川省资阳市",
"861360571", "浙江省杭州市",
"86156359", "山西省运城市",
"861780319", "河北省邢台市",
"861339370", "河南省郑州市",
"861354058", "四川省南充市",
"861331448", "贵州省黔南布依族苗族自治州",
"86157502", "云南省大理白族自治州",
"861508223", "四川省乐山市",
"861526021", "福建省厦门市",
"861838452", "四川省广安市",
"861309342", "安徽省六安市",
"861380261", "广东省江门市",
"861536662", "江苏省淮安市",
"861528916", "西藏那曲地区",
"861576799", "广东省惠州市",
"861355822", "广西柳州市",
"86136165", "浙江省杭州市",
"861305435", "黑龙江省七台河市",
"861760903", "新疆和田地区",
"86182252", "重庆市",
"861858918", "西藏林芝地区",
"861531492", "浙江省嘉兴市",
"861568128", "四川省攀枝花市",
"861302747", "湖南省岳阳市",
"861773233", "河北省唐山市",
"861870419", "辽宁省辽阳市",
"86152538", "山东省泰安市",
"861567651", "广西百色市",
"861708450", "黑龙江省哈尔滨市",
"861350409", "辽宁省大连市",
"861528361", "四川省甘孜藏族自治州",
"861524065", "广西南宁市",
"861378908", "湖南省株洲市",
"861535037", "江西省赣州市",
"861808393", "新疆伊犁哈萨克自治州",
"861355073", "四川省宜宾市",
"861853444", "山西省晋中市",
"861517747", "广西南宁市",
"861554270", "辽宁省大连市",
"861883032", "河北省张家口市",
"861860456", "黑龙江省黑河市",
"861335635", "山东省聊城市",
"861869773", "河南省信阳市",
"861831872", "广东省深圳市",
"861810615", "江苏省无锡市",
"861801840", "江苏省南通市",
"861554831", "内蒙古阿拉善盟",
"861585086", "江苏省泰州市",
"861568778", "云南省昆明市",
"861510031", "河北省石家庄市",
"861818701", "云南省昆明市",
"861766638", "广东省中山市",
"861598403", "四川省泸州市",
"861839971", "新疆阿克苏地区",
"861530835", "四川省资阳市",
"86155253", "山西省长治市",
"861321681", "浙江省杭州市",
"861520909", "新疆博尔塔拉蒙古自治州",
"861476272", "江苏省淮安市",
"861844716", "内蒙古赤峰市",
"861332719", "内蒙古包头市",
"861886728", "湖南省张家界市",
"861331279", "云南省保山市",
"861820632", "山东省枣庄市",
"861572846", "广东省佛山市",
"861337335", "河北省秦皇岛市",
"861324774", "江西省抚州市",
"861593429", "山西省忻州市",
"861840754", "广东省汕头市",
"86139490", "河南省郑州市",
"861351344", "河北省唐山市",
"861399906", "新疆阿克苏地区",
"861561534", "山东省德州市",
"861814540", "黑龙江省七台河市",
"861870647", "山东省东营市",
"861872984", "陕西省渭南市",
"861778953", "甘肃省平凉市",
"861855229", "江苏省南通市",
"861321077", "山东省枣庄市",
"861355775", "广西玉林市",
"861555781", "浙江省丽水市",
"861770677", "浙江省温州市",
"86155876", "湖北省恩施土家族苗族自治州",
"861329100", "江苏省徐州市",
"86157559", "安徽省黄山市",
"861591640", "广东省惠州市",
"861317643", "山东省淄博市",
"861470542", "山东省青岛市",
"861513869", "河南省郑州市",
"861816622", "湖南省怀化市",
"861897016", "江西省鹰潭市",
"861381233", "江苏省连云港市",
"861454108", "安徽省阜阳市",
"861323405", "辽宁省大连市",
"861833348", "河北省邢台市",
"86156302", "河北省保定市",
"861532443", "安徽省池州市",
"86183718", "湖北省恩施土家族苗族自治州",
"861709429", "广东省汕头市",
"861538553", "安徽省芜湖市",
"861337957", "陕西省榆林市",
"861831725", "河南省焦作市",
"861890435", "吉林省通化市",
"86130094", "辽宁省大连市",
"861831946", "广东省深圳市",
"861378491", "河北省邢台市",
"861314777", "吉林省吉林市",
"861869075", "贵州省贵阳市",
"861311074", "福建省泉州市",
"861588514", "贵州省铜仁地区",
"861839558", "安徽省马鞍山市",
"861700889", "广东省深圳市",
"861390746", "湖南省永州市",
"861700263", "广东省江门市",
"86145858", "山东省德州市",
"861881328", "广东省河源市",
"861865272", "江苏省泰州市",
"861317632", "山东省枣庄市",
"861326699", "广东省深圳市",
"861888258", "四川省遂宁市",
"861815246", "宁夏中卫市",
"861311566", "黑龙江省齐齐哈尔市",
"861381242", "江苏省宿迁市",
"861384981", "河南省三门峡市",
"861530143", "江苏省泰州市",
"861561680", "湖南省益阳市",
"861804152", "辽宁省丹东市",
"861532432", "河北省唐山市",
"861474587", "黑龙江省齐齐哈尔市",
"861303071", "辽宁省抚顺市",
"861470533", "山东省淄博市",
"861533567", "内蒙古鄂尔多斯市",
"861336457", "吉林省白城市",
"861318164", "山东省烟台市",
"861808201", "江苏省淮安市",
"861705581", "贵州省贵阳市",
"861383436", "山西省吕梁市",
"861880913", "陕西省渭南市",
"861360786", "广西南宁市",
"861705207", "贵州省贵阳市",
"861360052", "浙江省杭州市",
"861450283", "内蒙古鄂尔多斯市",
"861303687", "广西贺州市",
"86153025", "广东省揭阳市",
"861830954", "宁夏固原市",
"861502632", "新疆喀什地区",
"8618430", "安徽省合肥市",
"861813097", "新疆阿克苏地区",
"861860309", "广东省佛山市",
"861898917", "四川省达州市",
"861322244", "江苏省南京市",
"861553534", "山西省阳泉市",
"861363344", "山西省太原市",
"861811510", "江苏省扬州市",
"861334960", "湖南省长沙市",
"861521589", "浙江省金华市",
"861373157", "河北省邢台市",
"861819178", "陕西省宝鸡市",
"86136051", "江苏省南京市",
"86139238", "广东省深圳市",
"861820643", "山东省淄博市",
"86777", "广西钦州市",
"861379921", "福建省泉州市",
"861845840", "浙江省杭州市",
"86187695", "山东省聊城市",
"861377644", "江苏省宿迁市",
"861321469", "黑龙江省双鸭山市",
"861567202", "湖北省黄石市",
"861369554", "安徽省淮南市",
"861459373", "贵州省铜仁地区",
"861479717", "山西省太原市",
"861581298", "广东省韶关市",
"8613862", "江苏省苏州市",
"861347757", "湖北省荆门市",
"861870995", "新疆吐鲁番地区",
"861841925", "甘肃省定西市",
"861379417", "广东省中山市",
"861350356", "山西省晋城市",
"86187398", "河南省三门峡市",
"861315979", "吉林省白山市",
"861338056", "广东省揭阳市",
"86133700", "上海市",
"861338782", "辽宁省朝阳市",
"861842004", "广东省汕尾市",
"86135668", "浙江省台州市",
"861374663", "黑龙江省绥化市",
"861880694", "云南省临沧市",
"861379649", "黑龙江省伊春市",
"86185244", "辽宁省沈阳市",
"861539768", "四川省泸州市",
"861823369", "河北省沧州市",
"861517014", "江西省新余市",
"861768854", "广东省深圳市",
"861804810", "四川省广安市",
"861367559", "安徽省黄山市",
"861365157", "江苏省盐城市",
"861883043", "河北省承德市",
"861340573", "江苏省南通市",
"86135365", "广东省珠海市",
"861819736", "青海省海北藏族自治州",
"86185855", "贵州省黔东南苗族侗族自治州",
"86155880", "山东省临沂市",
"861572078", "江苏省徐州市",
"861551969", "贵州省六盘水市",
"861304277", "湖北省咸宁市",
"861319445", "福建省福州市",
"861473007", "河北省沧州市",
"861700310", "河北省邯郸市",
"861520570", "浙江省衢州市",
"861571781", "湖北省随州市",
"861761474", "内蒙古乌兰察布市",
"86134615", "河南省漯河市",
"861327650", "江苏省淮安市",
"861318627", "陕西省安康市",
"861585463", "山东省日照市",
"861334418", "上海市",
"861315332", "山东省枣庄市",
"861372215", "内蒙古通辽市",
"86155159", "河南省郑州市",
"861881336", "广东省茂名市",
"86137778", "浙江省杭州市",
"861571399", "河南省驻马店市",
"861700937", "江苏省徐州市",
"861304866", "江苏省连云港市",
"861830312", "河北省保定市",
"861843957", "河南省驻马店市",
"861471475", "广东省茂名市",
"861527017", "江西省九江市",
"861458608", "湖北省随州市",
"86130986", "重庆市",
"86131920", "广东省东莞市",
"861304618", "广东省韶关市",
"861560679", "浙江省金华市",
"861372250", "河北省唐山市",
"861327615", "江苏省镇江市",
"861340484", "内蒙古呼和浩特市",
"861347348", "河北省石家庄市",
"861365879", "云南省普洱市",
"861383428", "山西省阳泉市",
"861471561", "广东省佛山市",
"861590545", "山东省烟台市",
"861309333", "安徽省铜陵市",
"861537219", "浙江省衢州市",
"861335150", "吉林省长春市",
"861568544", "贵州省黔东南苗族侗族自治州",
"861870568", "安徽省阜阳市",
"861340340", "山西省太原市",
"861336027", "广东省肇庆市",
"861364242", "广东省阳江市",
"861361981", "河南省开封市",
"861890983", "辽宁省沈阳市",
"861357451", "湖南省娄底市",
"861560609", "福建省厦门市",
"861584680", "黑龙江省哈尔滨市",
"861360422", "辽宁省鞍山市",
"861822060", "陕西省咸阳市",
"861539046", "四川省乐山市",
"861815014", "福建省漳州市",
"861331783", "广西桂林市",
"86156798", "江西省景德镇市",
"861520343", "山西省太原市",
"86155145", "河南省郑州市",
"861889292", "新疆博尔塔拉蒙古自治州",
"861860932", "甘肃省定西市",
"861864328", "吉林省延边朝鲜族自治州",
"861809737", "青海省海西蒙古族藏族自治州",
"86153404", "重庆市",
"861511172", "青海省海东地区",
"861779093", "辽宁省盘锦市",
"861572517", "山东省济宁市",
"861309711", "江西省抚州市",
"861855856", "福建省泉州市",
"861378823", "广西桂林市",
"861335115", "黑龙江省绥化市",
"86139936", "甘肃省张掖市",
"861458678", "湖南省益阳市",
"86139709", "江西省南昌市",
"861525858", "浙江省台州市",
"861760828", "四川省成都市",
"861378072", "山东省聊城市",
"861394911", "河南省郑州市",
"861344231", "江苏省苏州市",
"86155887", "山东省济宁市",
"861339532", "山东省青岛市",
"861452429", "辽宁省葫芦岛市",
"861313395", "江西省宜春市",
"86131038", "河南省郑州市",
"861840941", "甘肃省甘南藏族自治州",
"861338426", "辽宁省锦州市",
"86138815", "四川省凉山彝族自治州",
"861396577", "安徽省亳州市",
"861820850", "贵州省贵阳市",
"861527578", "山东省临沂市",
"861534661", "湖北省十堰市",
"861707318", "河北省石家庄市",
"861475780", "浙江省台州市",
"861825017", "福建省福州市",
"861550665", "山东省烟台市",
"861504575", "黑龙江省双鸭山市",
"861524022", "江苏省南京市",
"861473681", "云南省楚雄彝族自治州",
"861314867", "广东省阳江市",
"861325031", "广东省广州市",
"861458217", "安徽省池州市",
"86137603", "广东省深圳市",
"861338367", "河北省廊坊市",
"861819963", "新疆阿勒泰地区",
"861350067", "内蒙古鄂尔多斯市",
"861800513", "江苏省连云港市",
"861308626", "青海省西宁市",
"861824493", "广东省湛江市",
"861388243", "四川省雅安市",
"86185849", "四川省成都市",
"861566049", "山东省威海市",
"861802332", "广东省清远市",
"861338438", "吉林省松原市",
"861366450", "黑龙江省哈尔滨市",
"861770874", "云南省曲靖市",
"861836286", "江苏省盐城市",
"861539923", "陕西省咸阳市",
"861459303", "四川省自贡市",
"861331085", "广东省深圳市",
"861335812", "江苏省扬州市",
"86151788", "重庆市",
"86133707", "重庆市",
"861569721", "湖北省荆州市",
"861530612", "江苏省常州市",
"86183684", "浙江省宁波市",
"861780537", "山东省济宁市",
"861313686", "黑龙江省牡丹江市",
"861705618", "辽宁省大连市",
"861840629", "辽宁省葫芦岛市",
"86130288", "广东省深圳市",
"861308638", "四川省遂宁市",
"861363480", "黑龙江省哈尔滨市",
"86158092", "陕西省西安市",
"861380730", "湖南省岳阳市",
"861860379", "河南省洛阳市",
"861843288", "河北省衡水市",
"861316656", "河北省沧州市",
"861811495", "江苏省连云港市",
"861500412", "辽宁省鞍山市",
"861805247", "江苏省无锡市",
"861580394", "河南省周口市",
"86186933", "甘肃省平凉市",
"861327843", "吉林省四平市",
"861459540", "青海省海北藏族自治州",
"861370141", "江苏省苏州市",
"861705277", "广东省广州市",
"861802979", "广东省潮州市",
"86139752", "湖南省湘潭市",
"861523669", "河南省洛阳市",
"861760349", "山西省朔州市",
"861324548", "山东省莱芜市",
"861808830", "云南省昆明市",
"861847692", "广东省湛江市",
"861591521", "广东省佛山市",
"8613482", "上海市",
"861453350", "辽宁省大连市",
"861355162", "四川省广安市",
"861532788", "湖北省黄石市",
"861364967", "云南省昭通市",
"861760836", "四川省甘孜藏族自治州",
"861390962", "安徽省蚌埠市",
"861336597", "福建省泉州市",
"861518410", "辽宁省铁岭市",
"861568868", "山东省威海市",
"861864849", "内蒙古包头市",
"861859444", "福建省宁德市",
"861550745", "湖南省怀化市",
"861396616", "安徽省宣城市",
"861870266", "江西省吉安市",
"861364851", "贵州省贵阳市",
"861569969", "黑龙江省双鸭山市",
"861584897", "内蒙古赤峰市",
"861317022", "安徽省蚌埠市",
"861573541", "山西省吕梁市",
"861534741", "广东省广州市",
"861550926", "陕西省安康市",
"861866826", "浙江省宁波市",
"861320438", "吉林省松原市",
"861595126", "江苏省淮安市",
"861386140", "江苏省盐城市",
"861816043", "新疆乌鲁木齐市",
"861802493", "广东省佛山市",
"861388998", "广东省东莞市",
"861332009", "江西省萍乡市",
"861564943", "河南省开封市",
"861537083", "江苏省南通市",
"86139723", "湖北省荆州市",
"861317873", "广东省梅州市",
"861501996", "广东省东莞市",
"861805274", "江苏省常州市",
"86150597", "福建省泉州市",
"861775045", "福建省龙岩市",
"861893408", "广东省茂名市",
"861776566", "广东省茂名市",
"861821313", "云南省怒江傈僳族自治州",
"861857278", "湖北省孝感市",
"861598450", "四川省雅安市",
"861808956", "四川省广元市",
"861354899", "湖南省怀化市",
"861470914", "陕西省商洛市",
"861309552", "安徽省蚌埠市",
"86180790", "江西省新余市",
"861310099", "黑龙江省齐齐哈尔市",
"861453949", "广东省惠州市",
"86137629", "湖南省怀化市",
"861527276", "湖北省孝感市",
"861816938", "湖南省娄底市",
"861800689", "浙江省金华市",
"861838112", "四川省广安市",
"86181116", "四川省成都市",
"861760915", "陕西省安康市",
"861870877", "云南省玉溪市",
"861370255", "广东省佛山市",
"861839829", "四川省阿坝藏族羌族自治州",
"86134791", "江西省南昌市",
"861303342", "山西省临汾市",
"861598415", "四川省自贡市",
"861572676", "西藏那曲地区",
"861802161", "江苏省苏州市",
"861804060", "湖北省襄樊市",
"861760950", "宁夏银川市",
"861333370", "河南省商丘市",
"861830489", "内蒙古赤峰市",
"861880534", "山东省德州市",
"861592540", "云南省西双版纳傣族自治州",
"861831470", "湖北省襄樊市",
"861453621", "江苏省盐城市",
"86156902", "河北省保定市",
"861308458", "河北省张家口市",
"861839348", "甘肃省陇南市",
"861886097", "江苏省南通市",
"861816926", "湖南省常德市",
"861328034", "山东省潍坊市",
"861321198", "云南省普洱市",
"861778900", "西藏拉萨市",
"86188585", "浙江省绍兴市",
"861517548", "河北省衡水市",
"86158550", "安徽省滁州市",
"861314951", "黑龙江省哈尔滨市",
"861519869", "云南省西双版纳傣族自治州",
"861538343", "山西省太原市",
"861818288", "黑龙江省伊春市",
"861892673", "广东省茂名市",
"861801442", "江苏省连云港市",
"861550043", "吉林省四平市",
"861535796", "安徽省马鞍山市",
"861470352", "山西省大同市",
"861366630", "山东省威海市",
"861310364", "河南省濮阳市",
"861372391", "山东省德州市",
"861388401", "甘肃省临夏回族自治州",
"861340959", "宁夏银川市",
"861533808", "广东省广州市",
"861855930", "福建省厦门市",
"861372789", "广东省珠海市",
"861831642", "广东省阳江市",
"861510373", "河南省新乡市",
"86184371", "河南省郑州市",
"861595138", "江苏省南通市",
"861396544", "安徽省合肥市",
"861502592", "甘肃省定西市",
"861358269", "河北省邢台市",
"861391308", "江苏省苏州市",
"86132488", "浙江省金华市",
"861352961", "云南省临沧市",
"861820936", "甘肃省张掖市",
"861318037", "河北省廊坊市",
"861329886", "吉林省通化市",
"861323413", "辽宁省抚顺市",
"861571814", "广东省广州市",
"861393390", "河北省秦皇岛市",
"86132924", "河北省唐山市",
"861550938", "甘肃省天水市",
"861320426", "辽宁省本溪市",
"861301878", "广东省梅州市",
"861352316", "河南省商丘市",
"861324246", "广东省佛山市",
"861351554", "安徽省淮南市",
"861814350", "贵州省贵阳市",
"861590263", "贵州省安顺市",
"861782885", "四川省达州市",
"861355331", "广东省佛山市",
"861320367", "湖南省益阳市",
"861590889", "云南省昆明市",
"861818011", "四川省攀枝花市",
"86135710", "陕西省咸阳市",
"861814315", "吉林省通化市",
"861875123", "江苏省连云港市",
"861329153", "浙江省嘉兴市",
"861872990", "陕西省西安市",
"861857449", "湖南省张家界市",
"861346565", "山东省潍坊市",
"861842047", "广东省湛江市",
"861518635", "贵州省黔西南布依族苗族自治州",
"86187711", "湖北省武汉市",
"86182162", "湖南省常德市",
"861395689", "安徽省池州市",
"861835785", "浙江省丽水市",
"861820763", "广东省清远市",
"861500791", "江西省南昌市",
"861389952", "新疆石河子市",
"86130377", "四川省凉山彝族自治州",
"861351494", "安徽省宿州市",
"86158785", "广西玉林市",
"8618180", "四川省成都市",
"861853069", "河南省南阳市",
"861806411", "湖北省武汉市",
"861568018", "四川省遂宁市",
"86135717", "陕西省宝鸡市",
"861813237", "河北省唐山市",
"861861477", "内蒙古鄂尔多斯市",
"861300424", "浙江省嘉兴市",
"861317452", "福建省福州市",
"861306437", "四川省资阳市",
"861304244", "辽宁省沈阳市",
"861303890", "陕西省安康市",
"861847532", "广东省汕尾市",
"861386686", "安徽省宿州市",
"86135772", "云南省大理白族自治州",
"861532652", "黑龙江省齐齐哈尔市",
"861800934", "甘肃省庆阳市",
"86150023", "重庆市",
"861875703", "浙江省衢州市",
"861882446", "广东省肇庆市",
"861536035", "广东省云浮市",
"861346401", "辽宁省沈阳市",
"861355713", "广西桂林市",
"861705016", "辽宁省大连市",
"861313088", "辽宁省盘锦市",
"861329561", "安徽省淮北市",
"861388471", "山东省潍坊市",
"861588194", "四川省遂宁市",
"861772346", "四川省攀枝花市",
"861846496", "山东省日照市",
"86152393", "河南省濮阳市",
"861308598", "甘肃省天水市",
"861823234", "河北省张家口市",
"861761447", "吉林省辽源市",
"861323720", "湖北省黄冈市",
"86158557", "安徽省蚌埠市",
"861510540", "山东省菏泽市",
"861356664", "浙江省宁波市",
"861335062", "四川省遂宁市",
"86137662", "江西省吉安市",
"861316058", "广东省清远市",
"861529481", "河南省信阳市",
"861871539", "安徽省滁州市",
"861893249", "湖南省永州市",
"861325621", "山东省菏泽市",
"861329475", "内蒙古通辽市",
"861555449", "山东省威海市",
"861868857", "广东省云浮市",
"861772839", "广东省揭阳市",
"861345768", "广西桂林市",
"861308036", "山西省晋城市",
"861562989", "湖北省鄂州市",
"861322618", "广东省揭阳市",
"861350817", "四川省自贡市",
"86135343", "广东省佛山市",
"861866794", "浙江省杭州市",
"861708473", "内蒙古呼和浩特市",
"861346998", "湖北省武汉市",
"861582992", "陕西省西安市",
"861570557", "安徽省宿州市",
"861331398", "福建省福州市",
"861870807", "西藏那曲地区",
"861311714", "湖北省恩施土家族苗族自治州",
"861555617", "安徽省亳州市",
"86156311", "河北省石家庄市",
"861560414", "辽宁省本溪市",
"861820065", "广东省中山市",
"861309492", "江苏省淮安市",
"86185392", "河南省郑州市",
"861559146", "陕西省汉中市",
"861572606", "山东省潍坊市",
"861528143", "四川省宜宾市",
"86157326", "河北省廊坊市",
"861333300", "河北省邯郸市",
"861315493", "陕西省安康市",
"861709898", "广东省深圳市",
"861856303", "山东省滨州市",
"861536733", "湖南省长沙市",
"86180797", "江西省赣州市",
"861308028", "内蒙古巴彦淖尔市",
"861857208", "湖北省荆州市",
"861339692", "浙江省台州市",
"861814031", "四川省宜宾市",
"861850831", "四川省宜宾市",
"861333996", "湖北省黄冈市",
"861527206", "湖北省咸宁市",
"861359981", "福建省宁德市",
"86152825", "四川省遂宁市",
"861869750", "安徽省滁州市",
"861580819", "四川省达州市",
"861315161", "江苏省扬州市",
"861522505", "河南省郑州市",
"861333543", "陕西省咸阳市",
"861363377", "河南省南阳市",
"861479469", "黑龙江省双鸭山市",
"861595706", "浙江省舟山市",
"861893478", "广西桂林市",
"861552660", "吉林省通化市",
"86182129", "贵州省六盘水市",
"861521994", "广东省中山市",
"861321717", "湖北省宜昌市",
"861327430", "吉林省长春市",
"861377677", "江苏省徐州市",
"861320782", "广西柳州市",
"861317803", "福建省福州市",
"861332079", "四川省甘孜藏族自治州",
"861454527", "广西钦州市",
"861512889", "河北省邯郸市",
"861815864", "浙江省台州市",
"861339353", "山西省阳泉市",
"861853394", "河北省邯郸市",
"8615317", "上海市",
"861458329", "江西省吉安市",
"861532587", "浙江省温州市",
"861375494", "山西省大同市",
"861575171", "江苏省淮安市",
"861381523", "江苏省南通市",
"861337861", "广东省东莞市",
"86152617", "江苏省淮安市",
"861317065", "云南省玉溪市",
"86178543", "山东省滨州市",
"861861394", "湖南省常德市",
"861327673", "浙江省嘉兴市",
"861458564", "山东省枣庄市",
"861333532", "陕西省榆林市",
"86153186", "山东省烟台市",
"861374732", "内蒙古乌海市",
"861534312", "河北省保定市",
"861336798", "江西省景德镇市",
"861518812", "云南省曲靖市",
"861332326", "河北省廊坊市",
"86152672", "浙江省台州市",
"861809526", "宁夏固原市",
"861776004", "四川省绵阳市",
"861308922", "吉林省四平市",
"861583322", "河北省保定市",
"861321044", "山东省德州市",
"861332467", "陕西省商洛市",
"86180452", "黑龙江省齐齐哈尔市",
"861343796", "江西省吉安市",
"861582536", "宁夏石嘴山市",
"86138841", "甘肃省庆阳市",
"861894545", "黑龙江省伊春市",
"861808432", "贵州省黔东南苗族侗族自治州",
"861351377", "河南省南阳市",
"861371713", "广东省深圳市",
"861810321", "河北省石家庄市",
"861335103", "黑龙江省牡丹江市",
"861305610", "江苏省宿迁市",
"861587235", "湖北省武汉市",
"86183667", "山东省济宁市",
"861335455", "黑龙江省绥化市",
"861860636", "山东省潍坊市",
"861347498", "内蒙古包头市",
"861393833", "河南省濮阳市",
"86150689", "浙江省衢州市",
"861770644", "浙江省杭州市",
"861500810", "四川省自贡市",
"861525099", "江苏省南京市",
"86187296", "陕西省汉中市",
"861857137", "湖北省荆州市",
"861857814", "广东省湛江市",
"861359212", "河南省开封市",
"861452734", "湖南省衡阳市",
"861867290", "湖北省宜昌市",
"861301768", "河南省郑州市",
"861562837", "广东省东莞市",
"861772987", "四川省成都市",
"861778509", "贵州省黔西南布依族苗族自治州",
"861536742", "湖南省长沙市",
"861335410", "辽宁省铁岭市",
"861817782", "广西百色市",
"861520553", "安徽省芜湖市",
"861820803", "西藏山南地区",
"861855539", "安徽省六安市",
"861305655", "四川省广安市",
"861366852", "贵州省遵义市",
"86139336", "河北省秦皇岛市",
"861571449", "吉林省白山市",
"861340550", "江苏省淮安市",
"86187533", "山东省淄博市",
"861780738", "湖南省娄底市",
"8618875", "重庆市",
"861535297", "青海省海北藏族自治州",
"86155111", "河北省石家庄市",
"861581379", "广东省江门市",
"861810430", "吉林省长春市",
"861500855", "贵州省黔东南苗族侗族自治州",
"861800505", "福建省泉州市",
"86189146", "江苏省盐城市",
"861529669", "山西省朔州市",
"861390818", "四川省成都市",
"861317763", "江西省景德镇市",
"861571617", "江苏省无锡市",
"861568912", "山东省青岛市",
"861591760", "广东省清远市",
"861459315", "四川省遂宁市",
"861453540", "江苏省常州市",
"86186333", "河北省唐山市",
"861592949", "陕西省榆林市",
"861822791", "四川省资阳市",
"861390666", "浙江省温州市",
"861760559", "安徽省黄山市",
"861840378", "河南省开封市",
"861780945", "甘肃省武威市",
"861383899", "河南省南阳市",
"861459350", "贵州省遵义市",
"861820452", "黑龙江省齐齐哈尔市",
"861527777", "广西钦州市",
"861366403", "内蒙古包头市",
"861344472", "湖北省黄石市",
"861897207", "湖北省襄樊市",
"86187763", "广西玉林市",
"861839169", "陕西省咸阳市",
"861319686", "江苏省镇江市",
"86134216", "广东省惠州市",
"861572718", "湖北省恩施土家族苗族自治州",
"861853477", "山西省吕梁市",
"861581932", "广东省肇庆市",
"861530916", "陕西省汉中市",
"861301214", "河北省石家庄市",
"861313982", "新疆塔城地区",
"861589270", "四川省眉山市",
"861512937", "陕西省宝鸡市",
"86155508", "山东省泰安市",
"861530361", "黑龙江省哈尔滨市",
"861500152", "新疆和田地区",
"861325373", "河南省许昌市",
"861856291", "山东省青岛市",
"861880975", "青海省果洛藏族自治州",
"861558061", "湖南省张家界市",
"861569560", "安徽省阜阳市",
"861328280", "浙江省杭州市",
"861360820", "四川省成都市",
"86185673", "河南省许昌市",
"861307937", "甘肃省武威市",
"86136019", "上海市",
"861363494", "辽宁省锦州市",
"86147809", "四川省广元市",
"861316952", "广东省东莞市",
"86153630", "广东省佛山市",
"861335968", "黑龙江省牡丹江市",
"861890610", "江苏省镇江市",
"861870767", "广东省韶关市",
"86181182", "江苏省扬州市",
"861369480", "江西省上饶市",
"861807427", "浙江省衢州市",
"861582528", "云南省昆明市",
"861346522", "山东省威海市",
"86183425", "辽宁省丹东市",
"861347901", "江西省上饶市",
"861534954", "宁夏固原市",
"861362918", "陕西省咸阳市",
"861373921", "安徽省滁州市",
"86153637", "广东省珠海市",
"861350546", "山东省东营市",
"861452898", "云南省昆明市",
"861842714", "湖北省黄石市",
"861367828", "四川省南充市",
"861873431", "山西省阳泉市",
"861364523", "江苏省淮安市",
"861322126", "浙江省金华市",
"861825127", "江苏省连云港市",
"861811345", "四川省遂宁市",
"86139848", "贵州省贵阳市",
"861365649", "山东省临沂市",
"861813728", "河南省安阳市",
"861589200", "福建省漳州市",
"861829094", "新疆阿勒泰地区",
"861356867", "四川省甘孜藏族自治州",
"86187998", "新疆巴音郭楞蒙古自治州",
"861780894", "西藏林芝地区",
"861341130", "广东省阳江市",
"861373417", "山西省朔州市",
"86137083", "重庆市",
"861891959", "青海省海西蒙古族藏族自治州",
"861521133", "湖南省常德市",
"861881679", "广东省广州市",
"86159856", "贵州省铜仁地区",
"861363554", "安徽省淮南市",
"861880905", "新疆昌吉回族自治州",
"861526631", "山东省威海市",
"861868654", "吉林省长春市",
"86157563", "四川省成都市",
"861301923", "吉林省延边朝鲜族自治州",
"861840308", "河北省衡水市",
"861330827", "重庆市",
"861478412", "河南省商丘市",
"861817426", "湖南省常德市",
"861509085", "湖北省宜昌市",
"861472661", "四川省巴中市",
"861598999", "广东省佛山市",
"861858702", "云南省西双版纳傣族自治州",
"861366473", "内蒙古包头市",
"861317936", "江苏省泰州市",
"861801433", "江苏省常州市",
"861897277", "湖北省黄石市",
"86183391", "河南省焦作市",
"861339487", "内蒙古巴彦淖尔市",
"861561694", "湖南省娄底市",
"861538332", "河北省保定市",
"861889745", "湖南省怀化市",
"861892430", "广东省广州市",
"861564379", "吉林省辽源市",
"86158314", "河北省承德市",
"861335025", "四川省南充市",
"86188492", "河北省保定市",
"861502936", "陕西省汉中市",
"861315821", "贵州省遵义市",
"861570374", "河南省许昌市",
"861350993", "广东省湛江市",
"861889926", "新疆和田地区",
"861766028", "山东省淄博市",
"861867620", "广东省河源市",
"861309687", "贵州省毕节地区",
"861364795", "江西省宜春市",
"86138443", "吉林省延边朝鲜族自治州",
"861325540", "山东省菏泽市",
"861539567", "安徽省亳州市",
"861836131", "江苏省扬州市",
"86180640", "湖北省武汉市",
"861337586", "浙江省台州市",
"861317928", "吉林省辽源市",
"861877171", "湖北省孝感市",
"861362460", "黑龙江省哈尔滨市",
"861590355", "山西省长治市",
"861819527", "宁夏吴忠市",
"861800575", "浙江省绍兴市",
"861385139", "江苏省连云港市",
"861581309", "广东省阳江市",
"861506700", "浙江省衢州市",
"861830661", "广东省佛山市",
"86159639", "山东省临沂市",
"86134641", "辽宁省铁岭市",
"861334158", "吉林省长春市",
"861340490", "云南省文山壮族苗族自治州",
"861590310", "河北省邯郸市",
"86183660", "山东省菏泽市",
"861766036", "山东省滨州市",
"861537466", "内蒙古赤峰市",
"861871930", "广东省云浮市",
"861845442", "山东省淄博市",
"861377874", "四川省遂宁市",
"861510949", "甘肃省陇南市",
"861889938", "新疆克拉玛依市",
"861800461", "黑龙江省哈尔滨市",
"86131320", "天津市",
"861876044", "福建省福州市",
"861507818", "广西百色市",
"861880680", "浙江省舟山市",
"861594983", "山东省淄博市",
"861862416", "辽宁省锦州市",
"861365417", "辽宁省营口市",
"861350614", "江苏省常州市",
"861829369", "甘肃省天水市",
"861808788", "云南省楚雄彝族自治州",
"861533768", "浙江省丽水市",
"86183004", "山东省临沂市",
"861301046", "浙江省绍兴市",
"861335173", "黑龙江省牡丹江市",
"861564932", "河南省郑州市",
"861827099", "江西省萍乡市",
"861351307", "河北省唐山市",
"861372203", "内蒙古呼伦贝尔市",
"861367836", "四川省甘孜藏族自治州",
"861812655", "广东省肇庆市",
"861816032", "新疆喀什地区",
"861807057", "江西省赣州市",
"861829524", "宁夏固原市",
"86152610", "江苏省泰州市",
"861700545", "山东省威海市",
"861575101", "江苏省镇江市",
"861332285", "广东省佛山市",
"861367349", "河南省信阳市",
"861532271", "广东省潮州市",
"861538979", "内蒙古锡林郭勒盟",
"861561913", "陕西省渭南市",
"861345878", "四川省凉山彝族自治州",
"86133771", "广西南宁市",
"86157733", "湖南省株洲市",
"861813736", "河南省周口市",
"861327603", "福建省宁德市",
"861532830", "四川省泸州市",
"861474788", "内蒙古呼和浩特市",
"86135965", "吉林省延边朝鲜族自治州",
"861335723", "湖南省湘西土家族苗族自治州",
"861872459", "黑龙江省哈尔滨市",
"861889043", "湖南省岳阳市",
"861319140", "内蒙古呼和浩特市",
"861335003", "四川省广元市",
"861841915", "甘肃省兰州市",
"861322456", "黑龙江省黑河市",
"861833380", "河北省衡水市",
"861508360", "江西省新余市",
"861330479", "内蒙古锡林郭勒盟",
"861771418", "江苏省南京市",
"861819718", "青海省海东地区",
"861805499", "福建省龙岩市",
"861586376", "山东省德州市",
"861839394", "甘肃省武威市",
"861321144", "广西贺州市",
"861776104", "四川省南充市",
"861479727", "山西省阳泉市",
"861367962", "四川省乐山市",
"861301905", "黑龙江省牡丹江市",
"861773461", "陕西省宝鸡市",
"861302594", "广西桂林市",
"861835699", "安徽省芜湖市",
"861821841", "广东省深圳市",
"861841950", "甘肃省临夏回族自治州",
"861596542", "山东省青岛市",
"861379911", "福建省南平市",
"861595309", "山东省日照市",
"861317165", "河北省张家口市",
"86152607", "福建省泉州市",
"861898927", "四川省绵阳市",
"861823646", "河南省驻马店市",
"861354324", "广东省梅州市",
"861811520", "江苏省连云港市",
"861479177", "陕西省榆林市",
"861458697", "山东省莱芜市",
"861328546", "山东省东营市",
"861356383", "山东省泰安市",
"86137436", "吉林省白城市",
"861569333", "甘肃省兰州市",
"861304636", "广东省珠海市",
"861822571", "安徽省安庆市",
"86130963", "四川省成都市",
"861453286", "山西省忻州市",
"861776896", "江苏省盐城市",
"861396598", "安徽省滁州市",
"861333981", "湖北省襄樊市",
"861318449", "浙江省金华市",
"861328993", "新疆石河子市",
"86181810", "四川省广元市",
"861533975", "甘肃省武威市",
"861858592", "贵州省黔西南布依族苗族自治州",
"861817156", "湖北省恩施土家族苗族自治州",
"861359996", "福建省福州市",
"861353692", "广东省汕头市",
"861807809", "广西梧州市",
"861528032", "福建省宁德市",
"861312559", "辽宁省丹东市",
"861820702", "江西省宜春市",
"861817883", "广西柳州市",
"861814588", "广东省东莞市",
"861850741", "湖南省株洲市",
"861533146", "云南省红河哈尼族彝族自治州",
"861891235", "江苏省无锡市",
"861336951", "宁夏银川市",
"861873545", "山西省朔州市",
"861529496", "河南省周口市",
"861313531", "湖南省长沙市",
"861503344", "河北省石家庄市",
"861383418", "山西省晋中市",
"861771960", "陕西省宝鸡市",
"861843451", "山西省阳泉市",
"861537229", "浙江省丽水市",
"861895679", "安徽省亳州市",
"861865545", "安徽省合肥市",
"86138758", "湖南省长沙市",
"86150051", "江苏省南京市",
"861477854", "广东省深圳市",
"861304628", "广东省茂名市",
"86151996", "新疆昌吉回族自治州",
"861361265", "广东省东莞市",
"861309101", "河北省石家庄市",
"861346895", "陕西省西安市",
"861335705", "浙江省金华市",
"861390499", "辽宁省辽阳市",
"861830322", "河北省邯郸市",
"861509554", "甘肃省平凉市",
"861780076", "青海省海南藏族自治州",
"86134085", "四川省成都市",
"861709995", "广东省佛山市",
"861450639", "黑龙江省绥化市",
"86158746", "湖南省永州市",
"861822958", "湖南省邵阳市",
"861566657", "山东省济宁市",
"861872779", "湖北省咸宁市",
"861386691", "安徽省滁州市",
"861871219", "安徽省安庆市",
"861700320", "河北省邯郸市",
"861454676", "广东省佛山市",
"861301680", "江苏省镇江市",
"861829267", "陕西省西安市",
"86136009", "福建省厦门市",
"86145967", "新疆伊犁哈萨克自治州",
"86147819", "上海市",
"861363085", "河北省保定市",
"861517024", "江西省南昌市",
"861500786", "广西百色市",
"86180419", "辽宁省葫芦岛市",
"86155518", "安徽省滁州市",
"861563687", "黑龙江省鸡西市",
"861362632", "山东省枣庄市",
"861331480", "内蒙古呼伦贝尔市",
"861890284", "广东省深圳市",
"861336578", "安徽省阜阳市",
"86134206", "广东省佛山市",
"861308616", "江西省吉安市",
"861318208", "江苏省无锡市",
"861826115", "江苏省常州市",
"861597679", "广东省汕尾市",
"861346944", "湖南省长沙市",
"861336508", "福建省龙岩市",
"861520784", "广西梧州市",
"861331344", "山西省晋中市",
"861800523", "江苏省淮安市",
"86184765", "广东省茂名市",
"861338416", "辽宁省锦州市",
"861707328", "河北省石家庄市",
"861825027", "福建省泉州市",
"861524012", "安徽省宣城市",
"86147214", "四川省成都市",
"861709844", "浙江省宁波市",
"861321992", "四川省广元市",
"861308868", "浙江省温州市",
"86188546", "山东省东营市",
"861452419", "辽宁省辽阳市",
"86153253", "浙江省嘉兴市",
"861454606", "青海省玉树藏族自治州",
"861303560", "四川省自贡市",
"861880768", "广东省潮州市",
"861836031", "江苏省扬州市",
"86177536", "山东省潍坊市",
"861896956", "浙江省丽水市",
"861809874", "安徽省六安市",
"861760818", "四川省达州市",
"861372386", "湖南省长沙市",
"861533680", "浙江省舟山市",
"861361487", "内蒙古鄂尔多斯市",
"861510787", "广西钦州市",
"861357957", "新疆克孜勒苏柯尔克孜自治州",
"86180675", "浙江省宁波市",
"861558553", "吉林省白城市",
"861309721", "江西省南昌市",
"86182480", "内蒙古赤峰市",
"861378813", "广西桂林市",
"86152455", "黑龙江省绥化市",
"861337240", "浙江省杭州市",
"861514733", "内蒙古赤峰市",
"861335125", "黑龙江省绥化市",
"86177293", "陕西省宝鸡市",
"861815024", "福建省漳州市",
"861565983", "福建省厦门市",
"861535399", "陕西省延安市",
"86156288", "山东省济南市",
"86185718", "湖北省武汉市",
"861595932", "福建省宁德市",
"861390559", "安徽省黄山市",
"861335775", "江苏省镇江市",
"861535781", "安徽省铜陵市",
"861800795", "江西省宜春市",
"861561567", "山东省济宁市",
"861336017", "广东省汕头市",
"861309171", "黑龙江省哈尔滨市",
"861760666", "广东省佛山市",
"86180378", "河南省郑州市",
"861360412", "辽宁省鞍山市",
"861509185", "陕西省西安市",
"861820772", "广西柳州市",
"861518420", "辽宁省朝阳市",
"86177766", "广西南宁市",
"861535064", "河北省唐山市",
"861521735", "广东省东莞市",
"86181872", "云南省大理白族自治州",
"861564581", "黑龙江省鸡西市",
"861364575", "浙江省绍兴市",
"861564207", "辽宁省铁岭市",
"861334058", "福建省龙岩市",
"861372695", "广东省清远市",
"861576953", "宁夏吴忠市",
"861522851", "四川省广安市",
"861393488", "山西省运城市",
"86551", "安徽省合肥市\、巢湖市",
"861537699", "山东省烟台市",
"861572097", "江西省九江市",
"861364461", "黑龙江省哈尔滨市",
"8613570", "广东省广州市",
"861304298", "甘肃省天水市",
"86181817", "四川省绵阳市",
"861306049", "陕西省宝鸡市",
"861324634", "广东省佛山市",
"86139751", "湖南省长沙市",
"861376841", "广西南宁市",
"861518331", "四川省眉山市",
"861889143", "陕西省渭南市",
"861595379", "山东省德州市",
"861308544", "湖南省永州市",
"861319040", "辽宁省锦州市",
"861534831", "湖南省长沙市",
"861707849", "云南省文山壮族苗族自治州",
"861803644", "江苏省南通市",
"861814611", "福建省宁德市",
"861501981", "广东省惠州市",
"861550835", "四川省雅安市",
"861500422", "辽宁省锦州市",
"861301975", "黑龙江省佳木斯市",
"861534270", "湖北省十堰市",
"861322596", "福建省厦门市",
"861588148", "四川省南充市",
"861450984", "新疆塔城地区",
"861770737", "湖南省益阳市",
"861586990", "湖南省怀化市",
"86130798", "辽宁省大连市",
"861479107", "陕西省宝鸡市",
"861332654", "广东省清远市",
"861452647", "江苏省泰州市",
"86152600", "福建省漳州市",
"861589954", "广东省惠州市",
"861807157", "湖北省宜昌市",
"861569711", "湖北省鄂州市",
"861800093", "广东省茂名市",
"861330409", "辽宁省大连市",
"861705628", "山西省太原市",
"861301146", "河北省秦皇岛市",
"861459131", "广西玉林市",
"861335073", "四川省乐山市",
"861555037", "山东省莱芜市",
"861370530", "山东省菏泽市",
"86184535", "山东省烟台市",
"861539913", "陕西省渭南市",
"861310683", "广东省珠海市",
"861504233", "辽宁省鞍山市",
"861531969", "陕西省安康市",
"861700964", "安徽省合肥市",
"861800851", "贵州省贵阳市",
"86188779", "广西北海市",
"86181625", "湖北省武汉市",
"861867435", "湖南省湘潭市",
"861387217", "湖北省咸宁市",
"861870059", "陕西省西安市",
"861577105", "湖北省咸宁市",
"861334952", "黑龙江省齐齐哈尔市",
"861367746", "湖南省常德市",
"861362815", "四川省雅安市",
"861317772", "江西省九江市",
"861537856", "四川省巴中市",
"861861757", "河北省邯郸市",
"86153880", "湖南省长沙市",
"86183855", "贵州省黔南布依族苗族自治州",
"86151430", "吉林省长春市",
"861559768", "青海省西宁市",
"86183244", "浙江省杭州市",
"86181328", "安徽省阜阳市",
"861501212", "云南省西双版纳傣族自治州",
"861580558", "安徽省阜阳市",
"861479238", "安徽省宿州市",
"861816143", "四川省达州市",
"861829766", "安徽省宿州市",
"861519990", "新疆巴音郭楞蒙古自治州",
"861881424", "广东省中山市",
"861300154", "山东省潍坊市",
"86150656", "山东省潍坊市",
"861887231", "湖北省黄石市",
"861858763", "广西百色市",
"861458106", "安徽省宣城市",
"861813846", "广东省佛山市",
"861362850", "贵州省贵阳市",
"86182476", "内蒙古赤峰市",
"86145715", "上海市",
"861594541", "黑龙江省佳木斯市",
"861522093", "广东省中山市",
"861802061", "福建省莆田市",
"861510325", "河北省唐山市",
"861585800", "浙江省温州市",
"861509377", "河南省平顶山市",
"861787840", "广西梧州市",
"861329755", "湖北省孝感市",
"861308708", "河南省驻马店市",
"861370684", "浙江省宁波市",
"861771569", "江苏省无锡市",
"861364689", "浙江省金华市",
"861850312", "河北省保定市",
"861577453", "黑龙江省牡丹江市",
"86181106", "安徽省六安市",
"861370302", "广东省佛山市",
"861454718", "浙江省丽水市",
"861843240", "河北省邯郸市",
"861337591", "福建省福州市",
"861322932", "河北省唐山市",
"861762529", "江苏省苏州市",
"861535576", "浙江省台州市",
"861310199", "江苏省南通市",
"861363448", "吉林省松原市",
"861368914", "陕西省商洛市",
"861329710", "湖北省恩施土家族苗族自治州",
"861360060", "浙江省丽水市",
"861893347", "广东省惠州市",
"861568797", "云南省普洱市",
"861388751", "云南省文山壮族苗族自治州",
"86153159", "山东省日照市",
"86189840", "贵州省贵阳市",
"861850954", "宁夏固原市",
"86155025", "湖南省娄底市",
"861398149", "四川省达州市",
"861336744", "湖南省张家界市",
"861391447", "江苏省南京市",
"861317825", "福建省厦门市",
"861361222", "广东省珠海市",
"861514742", "内蒙古乌海市",
"861375448", "河北省邯郸市",
"861895154", "江苏省盐城市",
"861550143", "江苏省徐州市",
"861524918", "陕西省西安市",
"861773934", "河南省濮阳市",
"861380985", "广东省佛山市",
"861889835", "广东省深圳市",
"861580971", "青海省西宁市",
"861708753", "江西省抚州市",
"861819676", "安徽省马鞍山市",
"861869642", "湖北省黄冈市",
"861595943", "福建省莆田市",
"861328134", "四川省乐山市",
"86185991", "新疆乌鲁木齐市",
"861321098", "山东省德州市",
"861569890", "辽宁省鞍山市",
"861353487", "广东省茂名市",
"86156912", "陕西省榆林市",
"861328817", "广东省惠州市",
"861813972", "甘肃省武威市",
"861322379", "河南省开封市",
"861770698", "福建省三明市",
"861345146", "河北省邯郸市",
"861330356", "山西省晋城市",
"86180135", "江苏省苏州市",
"861329053", "河北省唐山市",
"861874991", "河南省濮阳市",
"86180822", "陕西省西安市",
"861839407", "甘肃省临夏回族自治州",
"861818111", "四川省南充市",
"861584648", "黑龙江省牡丹江市",
"861458482", "山东省青岛市",
"861586459", "山东省潍坊市",
"861888669", "四川省广元市",
"86159157", "广东省广州市",
"861340388", "河南省周口市",
"861347444", "陕西省榆林市",
"861314798", "辽宁省盘锦市",
"861318814", "辽宁省锦州市",
"861454264", "西藏林芝地区",
"861533534", "山东省德州市",
"861318137", "山东省德州市",
"861334314", "河北省承德市",
"861868009", "广东省东莞市",
"861354960", "湖南省常德市",
"86147044", "广东省广州市",
"861560739", "湖南省邵阳市",
"861595038", "江苏省淮安市",
"861595456", "山东省聊城市",
"861476545", "安徽省合肥市",
"861876536", "山东省潍坊市",
"861586599", "山东省日照市",
"861708425", "云南省怒江傈僳族自治州",
"861863453", "山西省阳泉市",
"861345905", "福建省莆田市",
"861589741", "湖南省怀化市",
"861597154", "湖北省黄石市",
"86130302", "广东省肇庆市",
"861397287", "湖北省荆门市",
"861839477", "甘肃省酒泉市",
"861870429", "辽宁省葫芦岛市",
"86185684", "河南省安阳市",
"861550612", "江苏省宿迁市",
"861363209", "广东省江门市",
"861876098", "云南省丽江市",
"861844738", "内蒙古巴彦淖尔市",
"861347380", "河北省衡水市",
"861593647", "河南省安阳市",
"861528926", "陕西省汉中市",
"861454197", "山西省临汾市",
"86159150", "广东省肇庆市",
"861809081", "四川省遂宁市",
"861362643", "山东省淄博市",
"861355812", "广西柳州市",
"86182251", "重庆市",
"861364934", "甘肃省庆阳市",
"86157501", "云南省昭通市",
"861308136", "辽宁省本溪市",
"861580901", "新疆塔城地区",
"861508213", "四川省资阳市",
"861822786", "四川省乐山市",
"861325787", "广西玉林市",
"861577023", "云南省怒江傈僳族自治州",
"861826635", "山东省聊城市",
"86181460", "福建省泉州市",
"861813902", "新疆昌吉回族自治州",
"861374976", "河南省信阳市",
"86159889", "浙江省台州市",
"861787653", "广东省阳江市",
"86137997", "福建省厦门市",
"861780329", "河北省邢台市",
"861335162", "黑龙江省齐齐哈尔市",
"861768049", "湖南省邵阳市",
"861500958", "宁夏银川市",
"861869400", "湖北省恩施土家族苗族自治州",
"861392199", "江苏省苏州市",
"861511341", "广东省韶关市",
"861452568", "贵州省六盘水市",
"861301534", "山西省太原市",
"861866574", "广东省广州市",
"86189847", "贵州省毕节地区",
"861709647", "山东省烟台市",
"861598770", "云南省玉溪市",
"86158696", "浙江省温州市",
"861899497", "江苏省宿迁市",
"861845888", "浙江省杭州市",
"861390915", "陕西省安康市",
"861370372", "河南省安阳市",
"861369398", "河南省三门峡市",
"86158579", "浙江省金华市",
"861556625", "辽宁省鞍山市",
"861812030", "湖北省孝感市",
"86150165", "广东省揭阳市",
"861380442", "吉林省吉林市",
"861709419", "广东省汕头市",
"861874478", "贵州省黔南布依族苗族自治州",
"861308128", "辽宁省锦州市",
"861452844", "甘肃省庆阳市",
"861303969", "黑龙江省伊春市",
"861528043", "福建省福州市",
"861509307", "河南省郑州市",
"86151084", "四川省成都市",
"861351783", "广西桂林市",
"861390950", "宁夏银川市",
"86153145", "浙江省宁波市",
"86156301", "河北省石家庄市",
"861338334", "河北省唐山市",
"861380670", "浙江省嘉兴市",
"861355150", "四川省内江市",
"861361692", "福建省龙岩市",
"861333212", "辽宁省抚顺市",
"861308778", "广西河池市",
"861780848", "贵州省毕节地区",
"861599877", "山东省德州市",
"861824811", "内蒙古呼和浩特市",
"861877884", "广西梧州市",
"861343781", "广东省广州市",
"861561648", "湖南省常德市",
"861332179", "广西北海市",
"86183849", "四川省内江市",
"861880878", "云南省楚雄彝族自治州",
"861894964", "安徽省马鞍山市",
"86159426", "辽宁省大连市",
"861593419", "山西省晋城市",
"861766616", "广东省佛山市",
"861366462", "黑龙江省齐齐哈尔市",
"861863802", "河南省郑州市",
"861538790", "江西省新余市",
"861577946", "江西省萍乡市",
"861587515", "广东省阳江市",
"861329423", "湖北省黄石市",
"861528938", "陕西省西安市",
"861500571", "浙江省杭州市",
"861844726", "内蒙古赤峰市",
"861596533", "山东省淄博市",
"861332729", "湖南省邵阳市",
"861358426", "江苏省苏州市",
"861886718", "浙江省金华市",
"86157118", "广东省广州市",
"861844945", "新疆和田地区",
"86151437", "吉林省辽源市",
"861580498", "辽宁省辽阳市",
"861858936", "云南省玉溪市",
"86131808", "吉林省长春市",
"861317702", "湖北省荆州市",
"861569342", "甘肃省兰州市",
"861458945", "广东省中山市",
"861320883", "云南省临沧市",
"861320269", "广东省东莞市",
"861890351", "山西省太原市",
"861315061", "云南省红河哈尼族彝族自治州",
"861586029", "福建省福州市",
"861361353", "山西省阳泉市",
"86156358", "山西省吕梁市",
"861470955", "宁夏中卫市",
"861560595", "福建省泉州市",
"861303738", "湖南省娄底市",
"861880530", "山东省菏泽市",
"861592544", "云南省德宏傣族景颇族自治州",
"861860861", "湖北省荆州市",
"861556961", "甘肃省临夏回族自治州",
"861827213", "湖北省黄冈市",
"861391289", "江苏省南通市",
"86182522", "江苏省盐城市",
"861760954", "宁夏固原市",
"861804064", "湖北省宜昌市",
"861333374", "河南省许昌市",
"86137925", "山东省烟台市",
"86145802", "江苏省南通市",
"861598454", "四川省雅安市",
"86186680", "浙江省杭州市",
"861770521", "江苏省徐州市",
"861470910", "陕西省咸阳市",
"86147699", "山东省临沂市",
"861318052", "河北省邯郸市",
"861507200", "湖北省荆门市",
"861573827", "河南省信阳市",
"86159510", "江苏省南京市",
"861459577", "陕西省咸阳市",
"86139133", "江苏省南京市",
"861811048", "安徽省六安市",
"861379143", "山东省枣庄市",
"86184402", "新疆乌鲁木齐市",
"861557689", "湖南省张家界市",
"861886841", "浙江省杭州市",
"861805270", "江苏省常州市",
"861470337", "河北省沧州市",
"86133621", "浙江省杭州市",
"861534559", "安徽省黄山市",
"861335328", "吉林省吉林市",
"861834809", "河南省平顶山市",
"861300015", "山东省淄博市",
"86181361", "江苏省苏州市",
"861476569", "江西省南昌市",
"861814912", "陕西省榆林市",
"861337636", "山东省潍坊市",
"861859672", "福建省泉州市",
"861530417", "辽宁省营口市",
"86131851", "浙江省金华市",
"861331562", "河北省廊坊市",
"861566012", "河南省新乡市",
"861882695", "广东省东莞市",
"861560723", "湖北省黄石市",
"861576789", "广东省梅州市",
"861859440", "福建省南平市",
"861506548", "山东省泰安市",
"861583247", "河北省石家庄市",
"861528769", "云南省普洱市",
"86152539", "山东省临沂市",
"86189772", "广西柳州市",
"861811933", "甘肃省平凉市",
"861874265", "新疆阿勒泰地区",
"861450301", "河北省廊坊市",
"861533363", "山西省阳泉市",
"861500617", "江苏省无锡市",
"861832468", "黑龙江省伊春市",
"86155974", "青海省西宁市",
"861308362", "河南省洛阳市",
"861337628", "江苏省常州市",
"861325708", "江西省南昌市",
"861810316", "河北省廊坊市",
"861512428", "辽宁省盘锦市",
"86182208", "陕西省西安市",
"861571855", "贵州省黔东南苗族侗族自治州",
"861351515", "江苏省泰州市",
"861810961", "安徽省淮北市",
"861872994", "陕西省榆林市",
"861376676", "黑龙江省绥化市",
"861309537", "云南省普洱市",
"861332311", "河北省石家庄市",
"861470468", "黑龙江省鹤岗市",
"861458969", "广东省深圳市",
"861888813", "江苏省连云港市",
"861569006", "河北省秦皇岛市",
"861396540", "安徽省宣城市",
"861335849", "福建省宁德市",
"861324425", "吉林省通化市",
"861323896", "辽宁省盘锦市",
"861351550", "安徽省滁州市",
"861814354", "贵州省黔南布依族苗族自治州",
"861571810", "广东省广州市",
"861844969", "新疆巴音郭楞蒙古自治州",
"861332966", "贵州省铜仁地区",
"861370768", "河南省焦作市",
"861393394", "河北省廊坊市",
"861530649", "山东省滨州市",
"8614758", "广东省广州市",
"861890817", "四川省成都市",
"86184459", "黑龙江省哈尔滨市",
"86189343", "广东省佛山市",
"861303726", "江西省九江市",
"861478399", "河南省新乡市",
"861588345", "四川省凉山彝族自治州",
"861378481", "河北省廊坊市",
"861360627", "江苏省南通市",
"861366634", "山东省莱芜市",
"861310360", "河南省商丘市",
"861592616", "湖北省十堰市",
"861889057", "湖南省娄底市",
"861700899", "海南省海口市",
"86139392", "河南省鹤壁市",
"86147576", "浙江省台州市",
"861853842", "河南省郑州市",
"86155523", "山东省菏泽市",
"861855934", "福建省南平市",
"861396303", "山东省日照市",
"861303176", "山东省莱芜市",
"861831474", "湖北省黄石市",
"861518679", "贵州省黔东南苗族侗族自治州",
"861526581", "山东省潍坊市",
"861397208", "湖北省襄樊市",
"86157558", "安徽省阜阳市",
"861778904", "西藏林芝地区",
"861807043", "江西省上饶市",
"861555389", "山东省东营市",
"86183719", "湖北省十堰市",
"861760312", "河北省保定市",
"861340377", "河南省南阳市",
"861397278", "湖北省黄石市",
"861894899", "广东省汕头市",
"861839488", "甘肃省陇南市",
"861518609", "贵州省毕节地区",
"861318422", "浙江省杭州市",
"86145845", "山东省青岛市",
"861510544", "山东省潍坊市",
"861356660", "浙江省宁波市",
"861313859", "广东省汕头市",
"861771545", "江苏省常州市",
"861538483", "内蒙古阿拉善盟",
"86184445", "吉林省长春市",
"861803463", "甘肃省平凉市",
"861818932", "甘肃省定西市",
"861306803", "山西省晋中市",
"86135875", "浙江省温州市",
"861319536", "安徽省宣城市",
"861840773", "广西桂林市",
"86151331", "河北省石家庄市",
"861809688", "新疆巴音郭楞蒙古自治州",
"861536079", "广东省茂名市",
"861342942", "浙江省嘉兴市",
"86158882", "浙江省温州市",
"861588190", "四川省遂宁市",
"861823871", "河南省商丘市",
"861800317", "河北省沧州市",
"861868135", "四川省成都市",
"861537967", "宁夏固原市",
"861319098", "内蒙古呼伦贝尔市",
"861823230", "河北省张家口市",
"861338563", "安徽省宣城市",
"86182569", "安徽省合肥市",
"861323724", "湖北省黄石市",
"861879158", "陕西省安康市",
"86156407", "辽宁省营口市",
"861519042", "江苏省扬州市",
"861520547", "山东省济宁市",
"861311053", "福建省福州市",
"861569076", "河南省商丘市",
"861300420", "浙江省嘉兴市",
"861365361", "山西省临汾市",
"861304240", "辽宁省沈阳市",
"861885783", "浙江省温州市",
"861862917", "陕西省宝鸡市",
"861365916", "陕西省汉中市",
"861526618", "山东省枣庄市",
"861871461", "黑龙江省哈尔滨市",
"861550282", "四川省成都市",
"861800930", "甘肃省临夏回族自治州",
"861775169", "江苏省连云港市",
"861590436", "吉林省白城市",
"861867827", "山东省枣庄市",
"861351490", "安徽省滁州市",
"861570532", "山东省青岛市",
"861362931", "甘肃省甘南藏族自治州",
"861829929", "新疆吐鲁番地区",
"861772875", "广东省云浮市",
"861768936", "福建省泉州市",
"86187758", "广西河池市",
"861803191", "河北省石家庄市",
"861856868", "河南省开封市",
"861560968", "安徽省合肥市",
"861862421", "辽宁省朝阳市",
"86153519", "江苏省常州市",
"861596529", "山东省东营市",
"861332733", "湖南省株洲市",
"861329439", "吉林省白山市",
"861596099", "福建省南平市",
"861328351", "山西省太原市",
"861363959", "宁夏银川市",
"861367661", "浙江省衢州市",
"861327434", "吉林省四平市",
"861590428", "辽宁省朝阳市",
"861815860", "浙江省台州市",
"861853390", "河北省唐山市",
"86152722", "湖北省恩施土家族苗族自治州",
"861308787", "贵州省遵义市",
"861860586", "浙江省台州市",
"861868832", "广东省惠州市",
"861534499", "甘肃省兰州市",
"861829641", "江西省宜春市",
"86178205", "广东省广州市",
"861523908", "河南省驻马店市",
"861337298", "辽宁省丹东市",
"861818379", "云南省普洱市",
"861387001", "江西省鹰潭市",
"861559939", "贵州省黔西南布依族苗族自治州",
"861341993", "河南省南阳市",
"861370923", "陕西省渭南市",
"861708580", "福建省泉州市",
"861552664", "吉林省长春市",
"861521990", "广东省茂名市",
"861874487", "贵州省铜仁地区",
"861504699", "黑龙江省黑河市",
"86157262", "山东省青岛市",
"861512058", "甘肃省天水市",
"861870433", "吉林省延边朝鲜族自治州",
"861768928", "福建省三明市",
"861373916", "江苏省苏州市",
"861838582", "贵州省黔东南苗族侗族自治州",
"86188436", "吉林省白城市",
"861500208", "广东省深圳市",
"861507270", "湖北省孝感市",
"861341546", "广东省佛山市",
"861319528", "贵州省六盘水市",
"861780333", "河北省秦皇岛市",
"86186687", "浙江省温州市",
"86130183", "重庆市",
"861845266", "江苏省扬州市",
"861830836", "四川省广元市",
"861889366", "甘肃省庆阳市",
"861772172", "江苏省淮安市",
"86133498", "湖北省武汉市",
"861333682", "浙江省绍兴市",
"861510616", "江苏省无锡市",
"86136704", "广东省汕头市",
"861816282", "湖北省孝感市",
"861887096", "江西省吉安市",
"861398165", "四川省巴中市",
"861532637", "吉林省松原市",
"861560455", "黑龙江省绥化市",
"861311755", "湖南省郴州市",
"861869754", "安徽省淮南市",
"861812817", "广东省潮州市",
"861315816", "贵州省黔南布依族苗族自治州",
"861537242", "浙江省杭州市",
"86159517", "江苏省南京市",
"861561041", "山东省泰安市",
"861457182", "浙江省温州市",
"861824066", "河南省新乡市",
"861505926", "福建省宁德市",
"86178086", "贵州省黔西南布依族苗族自治州",
"861539141", "云南省文山壮族苗族自治州",
"861360297", "广东省肇庆市",
"861389937", "新疆塔城地区",
"861880887", "云南省迪庆藏族自治州",
"86186071", "湖北省武汉市",
"861303482", "湖南省娄底市",
"861866790", "浙江省杭州市",
"86159572", "浙江省湖州市",
"86182739", "湖南省邵阳市",
"861830349", "山西省朔州市",
"861333304", "河北省石家庄市",
"861311710", "湖北省十堰市",
"86156649", "陕西省西安市",
"861828915", "西藏昌都地区",
"861889427", "甘肃省临夏回族自治州",
"861560410", "辽宁省铁岭市",
"861510868", "云南省曲靖市",
"861817411", "广西南宁市",
"861307952", "宁夏石嘴山市",
"86150985", "山东省烟台市",
"861316937", "广东省云浮市",
"861770472", "内蒙古包头市",
"861779083", "辽宁省营口市",
"861887181", "湖北省恩施土家族苗族自治州",
"861335414", "辽宁省本溪市",
"861780342", "山西省晋城市",
"86139708", "江西省南昌市",
"861398702", "云南省德宏傣族景颇族自治州",
"861309319", "江苏省常州市",
"861857855", "广东省肇庆市",
"86181313", "河北省张家口市",
"861810434", "吉林省四平市",
"861856708", "河南省焦作市",
"861479188", "陕西省商洛市",
"861536338", "广东省潮州市",
"861340554", "江苏省泰州市",
"861450623", "黑龙江省齐齐哈尔市",
"861890993", "新疆石河子市",
"861361991", "新疆乌鲁木齐市",
"861370878", "云南省楚雄彝族自治州",
"861707162", "河南省周口市",
"861512952", "陕西省榆林市",
"861816911", "宁夏银川市",
"861770640", "浙江省杭州市",
"861500814", "四川省自贡市",
"861857810", "广东省湛江市",
"861453616", "江苏省南通市",
"86156799", "江西省萍乡市",
"861331793", "江西省上饶市",
"861452730", "湖南省岳阳市",
"861357618", "江西省宜春市",
"861569848", "山西省临汾市",
"861321040", "山东省滨州市",
"861567569", "湖南省郴州市",
"861890546", "山东省东营市",
"861316355", "黑龙江省大庆市",
"861593261", "河北省廊坊市",
"861818026", "四川省广安市",
"861339758", "湖南省娄底市",
"861326934", "甘肃省张掖市",
"861320927", "陕西省汉中市",
"861587279", "湖北省咸宁市",
"861814577", "广东省佛山市",
"861564288", "辽宁省锦州市",
"86182381", "河南省南阳市",
"861820437", "吉林省辽源市",
"861471896", "西藏那曲地区",
"86185848", "四川省成都市",
"861375490", "山西省大同市",
"861352321", "河南省焦作市",
"861844560", "黑龙江省黑河市",
"861320411", "辽宁省大连市",
"861393407", "山西省临汾市",
"861367489", "内蒙古锡林郭勒盟",
"861313385", "江西省宜春市",
"861351959", "宁夏银川市",
"86953", "宁夏吴忠市",
"861874222", "辽宁省鞍山市",
"861761453", "黑龙江省牡丹江市",
"861880372", "河南省安阳市",
"861861390", "湖南省岳阳市",
"86155366", "山西省太原市",
"861304591", "福建省福州市",
"861458560", "山东省枣庄市",
"861554962", "湖北省孝感市",
"861524582", "黑龙江省齐齐哈尔市",
"86130289", "浙江省宁波市",
"861308325", "安徽省铜陵市",
"86178070", "江西省南昌市",
"861890614", "江苏省常州市",
"861360824", "四川省巴中市",
"861830973", "青海省黄南藏族自治州",
"861328284", "浙江省杭州市",
"861366837", "四川省乐山市",
"86181747", "广西南宁市",
"861363490", "辽宁省朝阳市",
"861355318", "山东省济南市",
"861559887", "内蒙古巴彦淖尔市",
"861806782", "浙江省湖州市",
"861891307", "江苏省苏州市",
"861534950", "宁夏银川市",
"861843298", "河北省唐山市",
"861860771", "广西南宁市",
"861550427", "辽宁省盘锦市",
"861818038", "四川省德阳市",
"861510708", "江西省景德镇市",
"861361408", "辽宁省大连市",
"861369484", "江西省抚州市",
"861811485", "江苏省无锡市",
"861331095", "陕西省安康市",
"861570543", "山东省滨州市",
"861589274", "四川省眉山市",
"861803752", "河南省濮阳市",
"861301210", "河北省邯郸市",
"861595111", "江苏省苏州市",
"861528157", "四川省甘孜藏族自治州",
"861550911", "陕西省延安市",
"861517120", "湖北省荆州市",
"861515245", "江苏省徐州市",
"861332742", "山西省大同市",
"861501497", "广东省惠州市",
"86151789", "重庆市",
"861569564", "安徽省六安市",
"861319992", "新疆伊犁哈萨克自治州",
"861521459", "黑龙江省大庆市",
"861534915", "陕西省安康市",
"861769901", "新疆塔城地区",
"861562852", "西藏日喀则地区",
"861313696", "黑龙江省鸡西市",
"861396621", "安徽省宣城市",
"861813601", "江苏省徐州市",
"861774550", "黑龙江省绥化市",
"861570996", "新疆巴音郭楞蒙古自治州",
"8618971", "湖北省武汉市",
"861880939", "甘肃省陇南市",
"8615810", "北京市",
"861345363", "山西省晋城市",
"861459354", "贵州省遵义市",
"861339347", "山西省临汾市",
"861336201", "浙江省衢州市",
"861336587", "湖南省益阳市",
"861380429", "辽宁省葫芦岛市",
"861506667", "山东省济南市",
"861818943", "甘肃省白银市",
"861528879", "山东省烟台市",
"861305546", "福建省泉州市",
"861760741", "湖南省株洲市",
"861847682", "广东省湛江市",
"861591764", "广东省清远市",
"861453544", "江苏省无锡市",
"861333557", "安徽省宿州市",
"861536467", "山西省临汾市",
"861511496", "陕西省汉中市",
"861570370", "河南省商丘市",
"861360796", "江西省吉安市",
"861318465", "江西省上饶市",
"861892434", "广东省东莞市",
"86151547", "山东省济宁市",
"861303697", "广西钦州市",
"861813087", "新疆乌鲁木齐市",
"861325544", "山东省德州市",
"861853833", "河南省濮阳市",
"861533255", "陕西省延安市",
"861867624", "广东省中山市",
"86188074", "湖南省长沙市",
"861881635", "山东省聊城市",
"861813671", "江苏省常州市",
"861762542", "江苏省苏州市",
"861538748", "湖南省长沙市",
"861368858", "贵州省六盘水市",
"861873569", "山西省运城市",
"861590952", "宁夏石嘴山市",
"861318571", "浙江省杭州市",
"861474597", "黑龙江省双鸭山市",
"861561690", "湖南省永州市",
"86185336", "河北省廊坊市",
"86132210", "浙江省杭州市",
"861817245", "广西玉林市",
"861839743", "湖南省衡阳市",
"861564957", "河南省驻马店市",
"861807032", "江西省上饶市",
"861770853", "贵州省安顺市",
"861369503", "福建省厦门市",
"86138701", "江西省鹰潭市",
"861780890", "西藏拉萨市",
"861341134", "广东省阳江市",
"86186676", "浙江省台州市",
"861589204", "福建省漳州市",
"861829090", "新疆阿勒泰地区",
"861862572", "河南省周口市",
"861874692", "黑龙江省绥化市",
"861870985", "安徽省合肥市",
"861868650", "吉林省长春市",
"861338792", "江西省九江市",
"861363550", "安徽省滁州市",
"861700656", "山东省烟台市",
"861317149", "内蒙古鄂尔多斯市",
"861306928", "吉林省四平市",
"861830903", "新疆和田地区",
"861842710", "湖北省襄樊市",
"861843636", "河南省洛阳市",
"861517700", "广西北海市",
"861568031", "四川省南充市",
"861510778", "广西河池市",
"861361478", "内蒙古巴彦淖尔市",
"861559530", "宁夏银川市",
"86139239", "广东省汕头市",
"861308286", "浙江省舟山市",
"861860701", "江西省鹰潭市",
"861366580", "浙江省舟山市",
"861330541", "山东省济南市",
"861863378", "河北省廊坊市",
"861800539", "山东省临沂市",
"861562473", "内蒙古乌海市",
"861510136", "甘肃省金昌市",
"861334651", "广东省韶关市",
"86158816", "四川省绵阳市",
"861840863", "宁夏吴忠市",
"861532834", "四川省泸州市",
"861855505", "安徽省马鞍山市",
"861880302", "河北省保定市",
"861385946", "福建省南平市",
"861882947", "陕西省宝鸡市",
"86139673", "浙江省嘉兴市",
"861806426", "湖北省十堰市",
"861880684", "浙江省宁波市",
"861304451", "河南省郑州市",
"86135669", "浙江省金华市",
"861839045", "湖南省郴州市",
"861350610", "江苏省镇江市",
"861375550", "江西省萍乡市",
"861843628", "河南省商丘市",
"861829520", "宁夏银川市",
"861306936", "河南省新乡市",
"86147580", "浙江省宁波市",
"861538357", "山西省临汾市",
"861514857", "内蒙古呼伦贝尔市",
"861587209", "湖北省荆州市",
"86135146", "黑龙江省齐齐哈尔市",
"861361249", "广东省佛山市",
"861340494", "云南省文山壮族苗族自治州",
"861590314", "河北省承德市",
"861768803", "广东省东莞市",
"861575608", "安徽省淮北市",
"861850818", "四川省达州市",
"861856128", "山东省威海市",
"8615640", "辽宁省沈阳市",
"861842053", "广东省茂名市",
"861876040", "福建省福州市",
"861777648", "广西南宁市",
"861871934", "广东省梅州市",
"861329147", "浙江省温州市",
"861846997", "云南省德宏傣族景颇族自治州",
"861377870", "四川省遂宁市",
"86159354", "山西省晋中市",
"861362464", "黑龙江省七台河市",
"861325868", "黑龙江省齐齐哈尔市",
"861571791", "江西省南昌市",
"861804576", "黑龙江省鸡西市",
"861850666", "广东省揭阳市",
"861322631", "广东省惠州市",
"86155158", "河南省郑州市",
"861869629", "湖北省黄石市",
"86159935", "河南省平顶山市",
"861380059", "福建省厦门市",
"861552867", "四川省巴中市",
"86137779", "浙江省宁波市",
"861520668", "山东省淄博市",
"861808027", "四川省广安市",
"861705021", "海南省海口市",
"861538935", "陕西省咸阳市",
"861867167", "湖北省十堰市",
"861705701", "广东省深圳市",
"861876395", "山东省德州市",
"861454731", "浙江省杭州市",
"861356956", "河南省平顶山市",
"861830746", "湖南省永州市",
"861308373", "河南省新乡市",
"861815415", "安徽省滁州市",
"861768122", "安徽省蚌埠市",
"861872948", "陕西省西安市",
"861504083", "辽宁省抚顺市",
"861330435", "吉林省四平市",
"861582691", "湖北省武汉市",
"861351388", "河南省三门峡市",
"86184829", "四川省宜宾市",
"861566632", "山东省济南市",
"861863447", "山西省临汾市",
"861532578", "浙江省丽水市",
"861339991", "新疆乌鲁木齐市",
"861776413", "湖北省十堰市",
"86181303", "安徽省芜湖市",
"861550809", "四川省广元市",
"861850559", "安徽省黄山市",
"861889769", "广西钦州市",
"86151575", "浙江省绍兴市",
"861331892", "广东省潮州市",
"861369793", "江西省上饶市",
"861893222", "江苏省南通市",
"861591181", "云南省昭通市",
"861302590", "广西南宁市",
"861565067", "安徽省宿州市",
"861841954", "甘肃省陇南市",
"861533939", "甘肃省陇南市",
"861531848", "山东省菏泽市",
"861811369", "四川省广元市",
"86183490", "四川省宜宾市",
"861833602", "河南省商丘市",
"861354320", "广东省梅州市",
"861839906", "新疆伊犁哈萨克自治州",
"861887218", "湖北省黄石市",
"861811524", "江苏省镇江市",
"861560865", "湖北省武汉市",
"861856965", "湖南省邵阳市",
"861892719", "广东省云浮市",
"861576225", "山东省青岛市",
"861833384", "河北省衡水市",
"861508364", "江西省新余市",
"861521709", "广东省东莞市",
"861860591", "福建省福州市",
"861803402", "河北省保定市",
"861787647", "广东省茂名市",
"86156867", "陕西省榆林市",
"861839390", "甘肃省临夏回族自治州",
"861321140", "广西柳州市",
"861508099", "湖南省岳阳市",
"861301302", "安徽省滁州市",
"861804824", "内蒙古鄂尔多斯市",
"861505132", "江苏省盐城市",
"861806883", "江苏省南京市",
"861857052", "湖南省娄底市",
"861528057", "福建省三明市",
"861517020", "江西省南昌市",
"861399971", "新疆伊犁哈萨克自治州",
"861840387", "黑龙江省大兴安岭地区",
"861595011", "江苏省无锡市",
"86188662", "山东省青岛市",
"861855795", "浙江省宁波市",
"861339408", "福建省南平市",
"861803186", "河北省石家庄市",
"861331484", "内蒙古包头市",
"861890280", "广东省佛山市",
"861458333", "江西省上饶市",
"861803853", "广东省河源市",
"861700324", "河北省唐山市",
"861818138", "四川省巴中市",
"861532951", "贵州省遵义市",
"861884045", "陕西省西安市",
"861319216", "广东省汕头市",
"86133594", "甘肃省兰州市",
"861332843", "福建省泉州市",
"861700569", "安徽省合肥市",
"861313469", "山西省运城市",
"861328655", "广东省肇庆市",
"861309608", "四川省内江市",
"86131421", "湖南省长沙市",
"861509550", "甘肃省定西市",
"861398452", "贵州省遵义市",
"86170099", "浙江省宁波市",
"861385703", "浙江省衢州市",
"861831299", "浙江省宁波市",
"861323566", "湖北省十堰市",
"861472746", "贵州省黔西南布依族苗族自治州",
"861477815", "广东省阳江市",
"86186830", "四川省泸州市",
"861891448", "江苏省南京市",
"861871851", "广东省深圳市",
"861571501", "福建省宁德市",
"861510965", "宁夏中卫市",
"861853488", "山西省吕梁市",
"86415", "辽宁省丹东市",
"861503340", "河北省张家口市",
"861771964", "陕西省榆林市",
"861855523", "安徽省宣城市",
"8615811", "北京市",
"86137750", "江苏省常州市",
"861325922", "陕西省宝鸡市",
"861533372", "河南省安阳市",
"861529813", "四川省达州市",
"861477850", "广东省河源市",
"86185751", "广东省东莞市",
"86150018", "上海市",
"861357379", "山东省济南市",
"861816157", "宁夏银川市",
"86180979", "新疆喀什地区",
"86184862", "贵州省黔南布依族苗族自治州",
"861807132", "湖北省宜昌市",
"861555786", "浙江省宁波市",
"861371585", "广东省汕头市",
"861562425", "山东省德州市",
"861509490", "山东省威海市",
"861398592", "贵州省六盘水市",
"861897011", "江西省赣州市",
"861470858", "贵州省六盘水市",
"861853732", "河南省新乡市",
"86145462", "宁夏银川市",
"861533302", "山西省大同市",
"86189499", "安徽省宿州市",
"86137757", "江苏省泰州市",
"861378496", "河北省保定市",
"861571465", "黑龙江省伊春市",
"861831941", "广东省深圳市",
"861533684", "浙江省舟山市",
"861813187", "河北省承德市",
"861809870", "安徽省宿州市",
"861899300", "甘肃省临夏回族自治州",
"861588929", "广东省深圳市",
"861861743", "河北省邢台市",
"861337244", "浙江省宁波市",
"861839842", "四川省遂宁市",
"861390741", "湖南省株洲市",
"861770752", "广东省惠州市",
"861303329", "江西省吉安市",
"861587377", "湖南省邵阳市",
"861321686", "浙江省丽水市",
"861882789", "江西省萍乡市",
"861450605", "吉林省白山市",
"861775407", "安徽省六安市",
"861592458", "内蒙古鄂尔多斯市",
"861816879", "江苏省徐州市",
"861844711", "内蒙古呼和浩特市",
"861523875", "河南省周口市",
"861709840", "浙江省杭州市",
"861317049", "湖南省邵阳市",
"861399901", "新疆巴音郭楞蒙古自治州",
"86157065", "海南省海口市",
"861335739", "湖南省邵阳市",
"861301372", "江苏省扬州市",
"861572841", "广东省广州市",
"861554828", "内蒙古巴彦淖尔市",
"861346940", "湖南省益阳市",
"861897288", "湖北省荆门市",
"86137585", "浙江省绍兴市",
"861520780", "广西北海市",
"861339478", "内蒙古巴彦淖尔市",
"861331340", "山西省忻州市",
"861896383", "新疆昌吉回族自治州",
"861304701", "广东省潮州市",
"861810719", "湖北省十堰市",
"86155551", "安徽省合肥市",
"861899543", "宁夏固原市",
"86178059", "福建省福州市",
"861521779", "广东省东莞市",
"861786510", "山东省滨州市",
"861571958", "宁夏银川市",
"861891209", "江苏省泰州市",
"861370534", "山东省德州市",
"861589950", "广东省惠州市",
"861517415", "辽宁省丹东市",
"861364539", "山东省临沂市",
"861563319", "河北省邢台市",
"861528911", "西藏拉萨市",
"861554349", "吉林省长春市",
"861830068", "河南省郑州市",
"861839145", "陕西省西安市",
"86153374", "湖北省宜昌市",
"861772908", "陕西省西安市",
"861567656", "广西来宾市",
"861840762", "广东省河源市",
"86156860", "陕西省西安市",
"861510598", "福建省厦门市",
"861332615", "浙江省湖州市",
"861880255", "广东省江门市",
"861708747", "湖南省邵阳市",
"861380877", "云南省红河哈尼族彝族自治州",
"861803640", "江苏省宿迁市",
"861860451", "黑龙江省哈尔滨市",
"861391453", "江苏省泰州市",
"861857422", "河南省信阳市",
"861528427", "河北省沧州市",
"861308540", "湖南省张家界市",
"861319044", "辽宁省锦州市",
"861818706", "云南省昆明市",
"861586994", "湖南省怀化市",
"861357932", "新疆喀什地区",
"86188629", "江苏省南通市",
"86155983", "内蒙古包头市",
"861338572", "浙江省湖州市",
"861839976", "新疆乌鲁木齐市",
"861332650", "广东省湛江市",
"861510036", "河北省廊坊市",
"86136688", "山东省青岛市",
"86158806", "福建省龙岩市",
"861534274", "湖北省武汉市",
"86183497", "四川省德阳市",
"861585081", "江苏省苏州市",
"861554836", "内蒙古呼和浩特市",
"861450980", "新疆塔城地区",
"861339249", "广东省广州市",
"861808127", "四川省遂宁市",
"861318791", "云南省普洱市",
"861768702", "云南省大理白族自治州",
"861380159", "江苏省南京市",
"861399498", "山西省运城市",
"861345887", "四川省内江市",
"861324630", "广东省佛山市",
"861454313", "黑龙江省七台河市",
"861869397", "甘肃省酒泉市",
"861550879", "云南省普洱市",
"861303848", "陕西省宝鸡市",
"861850499", "内蒙古呼和浩特市",
"861535060", "河北省保定市",
"861310542", "山东省青岛市",
"861329047", "河北省沧州市",
"861308303", "安徽省芜湖市",
"861856028", "山东省淄博市",
"861808777", "云南省玉溪市",
"861831629", "广东省云浮市",
"861360576", "浙江省台州市",
"861518424", "辽宁省朝阳市",
"861705771", "福建省厦门市",
"861398022", "四川省自贡市",
"861592965", "陕西省商洛市",
"861474127", "辽宁省抚顺市",
"861526026", "福建省莆田市",
"86131823", "江苏省徐州市",
"861380266", "广东省中山市",
"861594759", "内蒙古鄂尔多斯市",
"861382459", "广东省梅州市",
"861896597", "福建省龙岩市",
"861830962", "宁夏石嘴山市",
"861843244", "河北省石家庄市",
"861326795", "广东省珠海市",
"861811148", "四川省宜宾市",
"86159500", "江苏省苏州市",
"861571786", "湖北省襄樊市",
"861368910", "陕西省咸阳市",
"861318152", "山东省烟台市",
"861360064", "浙江省温州市",
"861529997", "新疆昌吉回族自治州",
"861304861", "江苏省淮安市",
"861881331", "广东省梅州市",
"861840453", "黑龙江省牡丹江市",
"861567899", "广西南宁市",
"861585804", "浙江省温州市",
"86132075", "天津市",
"861310533", "山东省淄博市",
"86184477", "内蒙古呼和浩特市",
"86151932", "甘肃省定西市",
"861471566", "广东省汕尾市",
"861312312", "福建省泉州市",
"861787844", "广西南宁市",
"861370680", "浙江省舟山市",
"861853045", "河南省焦作市",
"861870888", "云南省丽江市",
"861552457", "辽宁省大连市",
"86158172", "广东省深圳市",
"861475979", "福建省厦门市",
"861362854", "贵州省黔南布依族苗族自治州",
"861879428", "甘肃省定西市",
"861369562", "安徽省宿州市",
"861519994", "新疆巴音郭楞蒙古自治州",
"861300150", "山东省淄博市",
"861881420", "广东省云浮市",
"861398928", "四川省绵阳市",
"86189707", "江西省赣州市",
"861560822", "四川省成都市",
"861819731", "青海省海东地区",
"861856922", "湖南省张家界市",
"861551319", "山西省忻州市",
"86139684", "浙江省台州市",
"861700960", "安徽省合肥市",
"861393169", "河北省保定市",
"861453598", "福建省厦门市",
"861569482", "河北省沧州市",
"861357943", "新疆乌鲁木齐市",
"861558547", "吉林省白城市",
"86157151", "江苏省南京市",
"86187443", "吉林省延边朝鲜族自治州",
"861313007", "辽宁省鞍山市",
"861576947", "甘肃省酒泉市",
"861770463", "福建省泉州市",
"861379926", "福建省厦门市",
"86156410", "辽宁省铁岭市",
"861354964", "湖南省长沙市",
"861318810", "辽宁省锦州市",
"861454260", "西藏拉萨市",
"86137492", "河南省安阳市",
"861302999", "黑龙江省哈尔滨市",
"861533530", "山东省菏泽市",
"861368468", "黑龙江省鹤岗市",
"861334310", "河北省邯郸市",
"86433", "吉林省延边朝鲜族自治州\、珲春市\、延吉市",
"861867248", "湖北省鄂州市",
"861338051", "广东省佛山市",
"861334355", "湖北省恩施土家族苗族自治州",
"861818277", "黑龙江省鸡西市",
"861318855", "辽宁省盘锦市",
"861347440", "陕西省延安市",
"861350351", "山西省太原市",
"861367322", "河北省保定市",
"861707173", "江西省吉安市",
"861452392", "西藏日喀则地区",
"861773930", "河南省周口市",
"861311561", "黑龙江省哈尔滨市",
"861850915", "陕西省安康市",
"861505612", "安徽省滁州市",
"86183709", "江西省赣州市",
"861815241", "宁夏中卫市",
"861787568", "广东省茂名市",
"86150248", "内蒙古兴安盟",
"861328130", "四川省乐山市",
"861569894", "辽宁省抚顺市",
"86147920", "陕西省西安市",
"861303076", "辽宁省盘锦市",
"86138998", "新疆乌鲁木齐市",
"861587882", "广西河池市",
"861895115", "江苏省泰州市",
"861384986", "河南省许昌市",
"861459797", "新疆巴音郭楞蒙古自治州",
"86183936", "甘肃省庆阳市",
"861853743", "河南省驻马店市",
"861535412", "河北省保定市",
"861336740", "湖南省岳阳市",
"861834427", "广东省茂名市",
"861327719", "湖北省十堰市",
"861360781", "广西南宁市",
"86153268", "内蒙古赤峰市",
"861850950", "宁夏中卫市",
"861538838", "四川省达州市",
"861560775", "广西玉林市",
"86180725", "浙江省台州市",
"861313518", "湖南省衡阳市",
"861889157", "陕西省宝鸡市",
"861808206", "江苏省泰州市",
"861383431", "山西省晋城市",
"861311475", "广西玉林市",
"861519613", "四川省广元市",
"861707595", "福建省福州市",
"861325965", "宁夏中卫市",
"861452653", "江西省上饶市",
"861895150", "江苏省无锡市",
"861880363", "河南省信阳市",
"861554973", "湖北省随州市",
"861334937", "黑龙江省大兴安岭地区",
"861330983", "辽宁省沈阳市",
"861360399", "河南省郑州市",
"86152897", "海南省海口市",
"86131748", "天津市",
"861839833", "四川省内江市",
"861560705", "江西省宜春市",
"861861488", "内蒙古巴彦淖尔市",
"861869404", "湖北省武汉市",
"861301530", "山西省太原市",
"861866570", "广东省广州市",
"861370146", "江苏省南京市",
"861319198", "河北省廊坊市",
"861562462", "内蒙古锡林郭勒盟",
"86176392", "河南省鹤壁市",
"861598774", "云南省玉溪市",
"861591526", "广东省茂名市",
"861554903", "湖北省荆州市",
"861840872", "云南省大理白族自治州",
"861536179", "广东省广州市",
"861362582", "浙江省湖州市",
"86134574", "广西梧州市",
"861760831", "四川省宜宾市",
"861390312", "河北省保定市",
"861571422", "辽宁省鞍山市",
"861815999", "福建省泉州市",
"861825443", "山东省临沂市",
"861846712", "青海省海西蒙古族藏族自治州",
"861894418", "江苏省无锡市",
"861536729", "湖南省邵阳市",
"86147927", "安徽省阜阳市",
"861364317", "河北省沧州市",
"861563537", "山西省太原市",
"861366747", "湖南省郴州市",
"861873899", "河南省开封市",
"861536857", "云南省普洱市",
"861836281", "江苏省宿迁市",
"861803091", "四川省甘孜藏族自治州",
"861889809", "西藏林芝地区",
"861365292", "广东省佛山市",
"86181556", "安徽省安庆市",
"86156472", "内蒙古包头市",
"861458342", "江西省抚州市",
"861364930", "甘肃省白银市",
"861569945", "新疆喀什地区",
"86131124", "广东省梅州市",
"861347384", "河北省秦皇岛市",
"861786919", "云南省文山壮族苗族自治州",
"861569726", "湖北省恩施土家族苗族自治州",
"861340448", "吉林省松原市",
"861826679", "山东省济宁市",
"861705861", "广东省广州市",
"861313077", "辽宁省铁岭市",
"861837412", "湖南省娄底市",
"861775069", "福建省漳州市",
"861450589", "辽宁省铁岭市",
"861552027", "四川省达州市",
"86150525", "江苏省扬州市",
"86170888", "广东省汕头市",
"861308949", "吉林省吉林市",
"861597150", "湖北省武汉市",
"861573479", "内蒙古锡林郭勒盟",
"86147038", "四川省成都市",
"861316651", "河北省秦皇岛市",
"861583349", "河北省邢台市",
"861332832", "福建省厦门市",
"86181962", "新疆巴音郭楞蒙古自治州",
"86156417", "辽宁省营口市",
"861325598", "福建省厦门市",
"861707968", "浙江省温州市",
"861872042", "江西省九江市",
"861512158", "贵州省黔西南布依族苗族自治州",
"861459118", "广西桂林市",
"861569738", "湖南省娄底市",
"86138533", "山东省淄博市",
"861898782", "云南省楚雄彝族自治州",
"86189700", "江西省南昌市",
"86153966", "福建省泉州市",
"861840725", "湖北省荆门市",
"861358245", "河北省秦皇岛市",
"861338421", "辽宁省朝阳市",
"861868733", "云南省昆明市",
"861534666", "湖北省武汉市",
"861840946", "甘肃省定西市",
"861814638", "青海省黄南藏族自治州",
"861346549", "山东省临沂市",
"861325036", "广东省佛山市",
"861877880", "广西防城港市",
"861534818", "四川省成都市",
"86138296", "广东省汕头市",
"861473686", "云南省德宏傣族景颇族自治州",
"861338917", "陕西省宝鸡市",
"861537513", "安徽省阜阳市",
"861538794", "江西省抚州市",
"86150946", "黑龙江省鸡西市",
"861894960", "安徽省马鞍山市",
"861308621", "青海省海西蒙古族藏族自治州",
"861357456", "湖南省郴州市",
"86135840", "江苏省南京市",
"861390954", "宁夏固原市",
"861361986", "河南省濮阳市",
"861834057", "辽宁省朝阳市",
"861554168", "辽宁省朝阳市",
"861324403", "吉林省吉林市",
"86182916", "陕西省汉中市",
"861338330", "河北省邯郸市",
"861380674", "浙江省绍兴市",
"861366358", "山西省吕梁市",
"861539041", "四川省成都市",
"861816769", "新疆克拉玛依市",
"861332135", "甘肃省武威市",
"861862563", "河南省濮阳市",
"861355154", "四川省内江市",
"86145870", "广东省广州市",
"861457082", "江苏省南京市",
"86159507", "江苏省连云港市",
"861555287", "山东省济南市",
"861812034", "湖北省荆门市",
"861855851", "福建省三明市",
"861566643", "山东省淄博市",
"861309716", "江西省赣州市",
"861452840", "甘肃省临夏回族自治州",
"861363388", "河南省洛阳市",
"861394916", "河南省信阳市",
"861592922", "陕西省榆林市",
"86139991", "新疆乌鲁木齐市",
"861893487", "广西玉林市",
"861525542", "安徽省淮南市",
"861526309", "山东省泰安市",
"861329881", "吉林省白山市",
"861575227", "云南省红河哈尼族彝族自治州",
"861820931", "甘肃省兰州市",
"861586605", "山东省济宁市",
"861352966", "云南省红河哈尼族彝族自治州",
"861550649", "山东省烟台市",
"861303678", "湖南省长沙市",
"861321982", "陕西省渭南市",
"861352311", "河南省周口市",
"861324241", "广东省深圳市",
"861509573", "甘肃省陇南市",
"861320421", "辽宁省朝阳市",
"861598358", "四川省攀枝花市",
"861355849", "广西北海市",
"861893543", "山西省吕梁市",
"861532707", "湖北省孝感市",
"861355336", "广东省汕头市",
"861477873", "广东省深圳市",
"861398643", "湖北省随州市",
"861357628", "江西省南昌市",
"86176855", "山东省青岛市",
"861520794", "江西省抚州市",
"861818016", "四川省绵阳市",
"861320917", "陕西省宝鸡市",
"86156289", "山东省济南市",
"861535389", "陕西省榆林市",
"861314956", "黑龙江省黑河市",
"861565993", "福建省福州市",
"861394835", "内蒙古通辽市",
"861539302", "甘肃省临夏回族自治州",
"861475553", "安徽省池州市",
"861816921", "湖南省郴州市",
"86131995", "黑龙江省哈尔滨市",
"861453626", "江苏省泰州市",
"861380647", "山东省潍坊市",
"861506114", "江苏省常州市",
"86180379", "河南省洛阳市",
"861509484", "山东省日照市",
"861800785", "广西贵港市",
"861816417", "湖北省宜昌市",
"861309329", "湖北省武汉市",
"861589168", "陕西省延安市",
"861388406", "甘肃省甘南藏族自治州",
"86138745", "湖南省怀化市",
"861337126", "山东省临沂市",
"861533690", "浙江省金华市",
"861376728", "江西省新余市",
"861372396", "山东省烟台市",
"861893300", "广东省佛山市",
"861835934", "福建省龙岩市",
"861310914", "陕西省宝鸡市",
"861819187", "陕西省西安市",
"861510797", "江西省赣州市",
"861318060", "吉林省白城市",
"861309564", "浙江省嘉兴市",
"861361497", "辽宁省营口市",
"861539684", "江苏省徐州市",
"861335424", "辽宁省沈阳市",
"86134566", "浙江省台州市",
"861302852", "陕西省渭南市",
"861309848", "湖北省孝感市",
"86132271", "湖北省孝感市",
"861863397", "河北省唐山市",
"861470529", "江苏省镇江市",
"861572087", "江苏省苏州市",
"861808951", "四川省成都市",
"861523645", "河南省新乡市",
"861537689", "山东省青岛市",
"86132127", "湖北省武汉市",
"861310352", "山西省大同市",
"861373032", "河北省张家口市",
"861517403", "辽宁省本溪市",
"861453638", "江苏省无锡市",
"86145032", "辽宁省鞍山市",
"861527271", "湖北省咸宁市",
"861380419", "辽宁省辽阳市",
"861302403", "安徽省阜阳市",
"861864865", "内蒙古乌兰察布市",
"86134736", "河北省廊坊市",
"861337138", "山东省烟台市",
"861589903", "新疆巴音郭楞蒙古自治州",
"861802166", "江苏省南通市",
"861572671", "西藏拉萨市",
"861866821", "浙江省杭州市",
"861550921", "陕西省榆林市",
"861809472", "浙江省湖州市",
"86763", "广东省清远市",
"861534746", "广东省惠州市",
"861573546", "山西省晋中市",
"861364856", "贵州省铜仁地区",
"861454305", "黑龙江省哈尔滨市",
"861852468", "辽宁省阜新市",
"861833145", "河北省衡水市",
"861366774", "广西梧州市",
"861595121", "江苏省常州市",
"861310693", "广东省揭阳市",
"861302155", "山东省潍坊市",
"861308350", "江苏省无锡市",
"861839440", "甘肃省定西市",
"861846978", "云南省大理白族自治州",
"861580743", "湖南省湘西土家族苗族自治州",
"861550417", "辽宁省营口市",
"861821963", "甘肃省平凉市",
"861855242", "江苏省无锡市",
"861501991", "广东省中山市",
"86155383", "河南省郑州市",
"861351562", "安徽省铜陵市",
"8614732", "四川省成都市",
"861810009", "上海市",
"861593442", "山西省晋中市",
"861450994", "新疆昌吉回族自治州",
"861815473", "广西南宁市",
"86187620", "江苏省淮安市",
"861308315", "安徽省铜陵市",
"861776561", "广东省佛山市",
"861360814", "四川省凉山彝族自治州",
"86135621", "山东省威海市",
"86130799", "新疆乌鲁木齐市",
"861809640", "安徽省合肥市",
"861554559", "黑龙江省哈尔滨市",
"861586980", "湖南省郴州市",
"861840633", "山东省日照市",
"861532664", "黑龙江省哈尔滨市",
"861501249", "广东省深圳市",
"861315166", "江苏省苏州市",
"861868625", "内蒙古鄂尔多斯市",
"861377752", "浙江省金华市",
"861458687", "湖南省湘潭市",
"861317464", "河南省信阳市",
"861306918", "吉林省吉林市",
"861595701", "浙江省衢州市",
"861815403", "安徽省宣城市",
"861539939", "陕西省商洛市",
"861810079", "江西省南昌市",
"861818244", "陕西省西安市",
"861454375", "山东省潍坊市",
"861575697", "四川省甘孜藏族自治州",
"8618601", "北京市",
"861805489", "福建省南平市",
"861809402", "福建省龙岩市",
"861836544", "江西省九江市",
"861839384", "甘肃省白银市",
"861370897", "山东省青岛市",
"861321445", "吉林省通化市",
"861343152", "广东省东莞市",
"861551738", "河南省许昌市",
"861366704", "江西省赣州市",
"861315259", "广西桂林市",
"861850349", "山西省朔州市",
"861534068", "山西省太原市",
"861886305", "山东省威海市",
"861817893", "江西省上饶市",
"861533220", "陕西省咸阳市",
"86138702", "江西省九江市",
"861572601", "山东省菏泽市",
"861335054", "四川省攀枝花市",
"861898658", "湖北省黄石市",
"861559141", "陕西省商洛市",
"861589973", "广东省江门市",
"861327467", "黑龙江省鸡西市",
"861476058", "宁夏银川市",
"86132120", "天津市",
"861557242", "湖北省恩施土家族苗族自治州",
"86181903", "四川省资阳市",
"861359986", "福建省莆田市",
"861527201", "湖北省黄冈市",
"861517473", "内蒙古乌海市",
"861850836", "四川省甘孜藏族自治州",
"861333991", "湖北省黄石市",
"861325638", "山东省烟台市",
"861814036", "四川省绵阳市",
"861869447", "陕西省宝鸡市",
"86135498", "广东省中山市",
"861305294", "江苏省镇江市",
"861376963", "云南省文山壮族苗族自治州",
"861893370", "广东省韶关市",
"861846491", "山东省临沂市",
"861877227", "湖北省黄石市",
"86132456", "浙江省宁波市",
"861772341", "四川省巴中市",
"861390489", "黑龙江省大庆市",
"861388476", "山东省泰安市",
"861705011", "广东省深圳市",
"861329566", "安徽省池州市",
"861392352", "广东省潮州市",
"86186240", "辽宁省沈阳市",
"861843277", "河北省沧州市",
"861343855", "四川省达州市",
"861556079", "内蒙古呼和浩特市",
"861558483", "吉林省通化市",
"861471714", "甘肃省天水市",
"86133875", "湖北省武汉市",
"861529486", "河南省新乡市",
"861361557", "安徽省宿州市",
"861337706", "广西桂林市",
"861581591", "广东省江门市",
"861539372", "河南省洛阳市",
"86156884", "山东省济南市",
"86187465", "黑龙江省绥化市",
"861590569", "安徽省合肥市",
"861814028", "四川省宜宾市",
"861501478", "广东省东莞市",
"861304335", "吉林省延边朝鲜族自治州",
"861308031", "山西省太原市",
"861506580", "山东省泰安市",
"861378839", "广西钦州市",
"86138759", "湖南省长沙市",
"861596337", "山东省德州市",
"861590324", "河北省承德市",
"861327338", "河北省秦皇岛市",
"861867993", "江西省南昌市",
"861500796", "江西省吉安市",
"861843618", "河南省南阳市",
"861477803", "广东省汕尾市",
"861829510", "宁夏银川市",
"861563697", "黑龙江省大庆市",
"861815852", "浙江省杭州市",
"86155519", "安徽省亳州市",
"861532777", "湖北省荆州市",
"86180418", "辽宁省阜新市",
"861596910", "云南省曲靖市",
"861806416", "湖北省孝感市",
"861386681", "安徽省池州市",
"861829555", "宁夏中卫市",
"861508858", "浙江省温州市",
"861399757", "湖北省荆州市",
"86183723", "湖北省宜昌市",
"861537934", "甘肃省武威市",
"861301690", "江苏省连云港市",
"861346406", "辽宁省朝阳市",
"861304957", "贵州省毕节地区",
"861882441", "广东省东莞市",
"861324999", "广东省佛山市",
"86147818", "四川省达州市",
"86136008", "福建省福州市",
"86189771", "广西南宁市",
"861787604", "广东省湛江市",
"861530911", "陕西省延安市",
"861397297", "湖北省鄂州市",
"861837152", "湖北省咸宁市",
"861380844", "湖南省郴州市",
"861524049", "江苏省徐州市",
"861876088", "云南省迪庆藏族自治州",
"861319681", "江苏省徐州市",
"861506634", "山东省莱芜市",
"861895723", "浙江省舟山市",
"861500627", "江苏省南通市",
"861519675", "四川省南充市",
"861809091", "四川省达州市",
"861311413", "云南省楚雄彝族自治州",
"861454187", "山西省临汾市",
"861879899", "西藏日喀则地区",
"861347390", "河北省唐山市",
"861530366", "黑龙江省哈尔滨市",
"86158483", "内蒙古乌海市",
"861305827", "广东省汕头市",
"861452442", "黑龙江省齐齐哈尔市",
"861810338", "河北省衡水市",
"861458552", "山东省聊城市",
"861536434", "湖南省娄底市",
"86131852", "浙江省湖州市",
"861530427", "辽宁省盘锦市",
"861591737", "广东省广州市",
"861566022", "湖南省长沙市",
"861314432", "吉林省吉林市",
"861566873", "辽宁省盘锦市",
"861850973", "青海省黄南藏族自治州",
"86133622", "浙江省湖州市",
"861335318", "吉林省辽源市",
"861319077", "内蒙古呼伦贝尔市",
"861300025", "江苏省南京市",
"861320572", "浙江省湖州市",
"861573817", "河南省平顶山市",
"86184401", "新疆乌鲁木齐市",
"861556467", "山东省枣庄市",
"86145801", "江苏省苏州市",
"861870730", "湖南省岳阳市",
"861360449", "吉林省白山市",
"86877", "云南省玉溪市",
"86135026", "广东省揭阳市",
"861366864", "山东省淄博市",
"861770511", "江苏省盐城市",
"861863404", "河北省唐山市",
"861364229", "广东省揭阳市",
"861569537", "青海省海西蒙古族藏族自治州",
"861572252", "江苏省南通市",
"861827223", "湖北省荆州市",
"86182521", "江苏省徐州市",
"86372", "河南省安阳市",
"861390661", "浙江省宁波市",
"86130400", "河北省唐山市",
"861325797", "江西省赣州市",
"861822796", "四川省广安市",
"861512960", "陕西省榆林市",
"861329074", "福建省福州市",
"86159888", "浙江省杭州市",
"861808744", "云南省昆明市",
"861513845", "河南省郑州市",
"861327079", "江苏省泰州市",
"861860631", "山东省威海市",
"86135230", "河南省郑州市",
"86182316", "河北省廊坊市",
"861820464", "黑龙江省七台河市",
"861351793", "江西省上饶市",
"861300173", "山东省济南市",
"861361682", "浙江省温州市",
"861378987", "山东省青岛市",
"861332430", "吉林省长春市",
"861306012", "四川省德阳市",
"861537505", "安徽省巢湖市",
"861588761", "云南省西双版纳傣族自治州",
"861899487", "江苏省扬州市",
"861845898", "浙江省绍兴市",
"861357116", "陕西省宝鸡市",
"861477763", "广西玉林市",
"86139391", "河南省焦作市",
"861565134", "江苏省徐州市",
"861366548", "山东省泰安市",
"861864822", "内蒙古兴安盟",
"861556338", "山东省临沂市",
"86187815", "四川省凉山彝族自治州",
"86158578", "浙江省丽水市",
"861369388", "河南省南阳市",
"861890827", "重庆市",
"861377463", "福建省南平市",
"861360617", "江苏省无锡市",
"86130358", "广东省茂名市",
"861575176", "江苏省南京市",
"861810467", "黑龙江省鸡西市",
"861300595", "广西桂林市",
"861337866", "广东省深圳市",
"86955", "宁夏中卫市",
"86180868", "四川省成都市",
"861764043", "辽宁省沈阳市",
"861571820", "广东省中山市",
"861840642", "山西省临汾市",
"86153366", "浙江省宁波市",
"861332321", "河北省石家庄市",
"861580488", "内蒙古呼和浩特市",
"861888823", "山东省德州市",
"861881705", "湖南省衡阳市",
"86134323", "广东省茂名市",
"861577474", "内蒙古乌兰察布市",
"861459458", "陕西省汉中市",
"861343791", "江西省南昌市",
"861582531", "宁夏银川市",
"861877894", "广西梧州市",
"861575945", "福建省泉州市",
"861562860", "山东省日照市",
"861351525", "江苏省常州市",
"86130655", "浙江省绍兴市",
"86150346", "山西省晋中市",
"861500164", "新疆石河子市",
"86183848", "四川省达州市",
"861773699", "河北省沧州市",
"861840470", "内蒙古呼伦贝尔市",
"861847408", "湖南省怀化市",
"861810326", "河北省廊坊市",
"861538780", "江西省新余市",
"861803760", "河南省信阳市",
"861380568", "安徽省阜阳市",
"861810285", "广东省汕尾市",
"861313717", "河南省焦作市",
"861363562", "安徽省铜陵市",
"86177198", "河南省郑州市",
"861862411", "辽宁省大连市",
"861558357", "四川省乐山市",
"86139425", "辽宁省丹东市",
"86150704", "江西省抚州市",
"861597025", "江西省宜春市",
"861367831", "四川省宜宾市",
"861847478", "湖南省永州市",
"861373938", "甘肃省天水市",
"861330610", "江苏省镇江市",
"861862927", "陕西省宝鸡市",
"861324590", "内蒙古鄂尔多斯市",
"861526628", "山东省枣庄市",
"861575106", "江苏省宿迁市",
"861580732", "湖南省湘潭市",
"861365745", "湖南省怀化市",
"86188778", "广西河池市",
"861362437", "吉林省辽源市",
"86131204", "北京市",
"861892338", "广东省珠海市",
"861813731", "河南省焦作市",
"861593433", "山西省阳泉市",
"861354651", "山西省长治市",
"861800327", "河北省沧州市",
"861361374", "河南省许昌市",
"861337581", "浙江省杭州市",
"861523997", "河南省濮阳市",
"861337207", "江苏省南通市",
"861781745", "广东省珠海市",
"861310189", "江苏省南京市",
"861830666", "广东省深圳市",
"86153158", "山东省德州市",
"86158881", "浙江省宁波市",
"861568787", "云南省昆明市",
"861373043", "河北省张家口市",
"861537461", "内蒙古呼伦贝尔市",
"861766031", "山东省菏泽市",
"86151332", "河北省保定市",
"861510638", "山东省烟台市",
"861800466", "黑龙江省哈尔滨市",
"861590960", "宁夏银川市",
"861318412", "山东省德州市",
"861364699", "福建省莆田市",
"861315838", "贵州省六盘水市",
"86130407", "浙江省金华市",
"86159571", "浙江省杭州市",
"86183336", "河北省廊坊市",
"861700158", "江苏省南京市",
"861472666", "四川省达州市",
"861311720", "湖北省鄂州市",
"86138398", "河南省三门峡市",
"861560420", "辽宁省鞍山市",
"861889417", "甘肃省武威市",
"861811234", "江苏省常州市",
"861380995", "新疆乌鲁木齐市",
"861563894", "河南省郑州市",
"861564240", "辽宁省辽阳市",
"86151193", "广东省梅州市",
"861817421", "湖南省邵阳市",
"861772712", "广东省佛山市",
"861356830", "四川省眉山市",
"861887644", "福建省厦门市",
"861771272", "江苏省宿迁市",
"861569880", "辽宁省沈阳市",
"861348469", "陕西省安康市",
"861317931", "江苏省常州市",
"861779930", "新疆乌鲁木齐市",
"86138695", "山东省聊城市",
"861889921", "新疆阿克苏地区",
"861315826", "贵州省铜仁地区",
"861502931", "陕西省延安市",
"861508239", "四川省攀枝花市",
"86186017", "上海市",
"861863474", "山西省吕梁市",
"861319518", "贵州省六盘水市",
"861895455", "山东省烟台市",
"86139667", "安徽省合肥市",
"861334545", "新疆巴音郭楞蒙古自治州",
"861575482", "内蒙古兴安盟",
"86176014", "江苏省苏州市",
"861379622", "黑龙江省哈尔滨市",
"861579409", "广东省深圳市",
"861350541", "山东省济南市",
"86157261", "山东省济南市",
"861768918", "西藏拉萨市",
"861314788", "辽宁省鞍山市",
"861320502", "福建省福州市",
"861362368", "山西省临汾市",
"861866553", "广东省佛山市",
"861850903", "新疆和田地区",
"861323268", "广东省湛江市",
"861322121", "浙江省湖州市",
"861370913", "陕西省渭南市",
"861873436", "山西省忻州市",
"861883879", "河南省商丘市",
"861519605", "四川省泸州市",
"861770688", "浙江省宁波市",
"861893532", "山西省阳泉市",
"86152721", "湖北省宜昌市",
"861358792", "浙江省湖州市",
"861787674", "广东省深圳市",
"861871242", "安徽省阜阳市",
"861458492", "山东省淄博市",
"861365938", "甘肃省天水市",
"861526636", "山东省潍坊市",
"861897861", "广西百色市",
"861590418", "辽宁省阜新市",
"861340398", "河南省三门峡市",
"861319177", "河北省唐山市",
"861881455", "黑龙江省绥化市",
"861365612", "江苏省常州市",
"861386696", "安徽省宣城市",
"861398918", "四川省南充市",
"861560812", "四川省广元市",
"86186664", "广东省东莞市",
"861551329", "山西省太原市",
"861376902", "云南省丽江市",
"861558259", "山西省晋城市",
"861890409", "辽宁省大连市",
"861454671", "广东省深圳市",
"861393444", "山西省忻州市",
"861323439", "吉林省白山市",
"86156256", "广东省揭阳市",
"861324700", "江西省南昌市",
"861306850", "广东省茂名市",
"861351484", "内蒙古乌兰察布市",
"861500781", "广西南宁市",
"861881410", "广东省广州市",
"861300775", "青海省海北藏族自治州",
"861367954", "广东省清远市",
"861459708", "宁夏固原市",
"861882974", "陕西省商洛市",
"861524149", "辽宁省大连市",
"861520357", "山西省临汾市",
"861768632", "山东省枣庄市",
"86158171", "广东省广州市",
"861500399", "河南省郑州市",
"861390253", "广东省珠海市",
"86151931", "甘肃省兰州市",
"861313536", "湖南省常德市",
"861809463", "浙江省嘉兴市",
"86183751", "贵州省黔南布依族苗族自治州",
"861529491", "河南省驻马店市",
"861312322", "福建省南平市",
"86130410", "北京市",
"861381327", "江苏省徐州市",
"861562999", "湖北省随州市",
"861309106", "河北省唐山市",
"861337309", "河北省邢台市",
"86413", "辽宁省抚顺市",
"861821972", "甘肃省定西市",
"861329724", "湖北省黄石市",
"861351573", "浙江省嘉兴市",
"861313098", "辽宁省葫芦岛市",
"86156873", "云南省红河哈尼族彝族自治州",
"861875754", "浙江省绍兴市",
"861588495", "四川省巴中市",
"861531537", "山东省济宁市",
"861520935", "甘肃省金昌市",
"861834649", "黑龙江省牡丹江市",
"861868430", "吉林省长春市",
"861308588", "广东省中山市",
"861538668", "四川省德阳市",
"861510354", "山西省晋中市",
"861378749", "湖南省邵阳市",
"861780071", "青海省西宁市",
"861851299", "陕西省榆林市",
"861803688", "江苏省无锡市",
"861815462", "广西南宁市",
"861453281", "山西省晋中市",
"861830559", "安徽省黄山市",
"861315483", "内蒙古阿拉善盟",
"861325577", "浙江省温州市",
"861453507", "山东省济南市",
"861304631", "广东省中山市",
"861351892", "西藏日喀则地区",
"861535422", "河北省保定市",
"861502854", "河北省承德市",
"861805253", "江苏省常州市",
"861802504", "广东省清远市",
"861834417", "广东省湛江市",
"861552578", "山西省吕梁市",
"861565034", "山东省淄博市",
"861327729", "湖北省襄樊市",
"861339682", "浙江省湖州市",
"86187805", "四川省绵阳市",
"861818628", "湖北省襄樊市",
"861509562", "甘肃省金昌市",
"861359991", "福建省厦门市",
"861817151", "湖北省武汉市",
"861333986", "湖北省十堰市",
"861313528", "湖南省长沙市",
"861776891", "江苏省宿迁市",
"861510912", "陕西省榆林市",
"861560150", "江苏省常州市",
"861398460", "贵州省六盘水市",
"861477862", "广东省湛江市",
"861350435", "吉林省四平市",
"86188613", "江苏省连云港市",
"861317854", "广东省佛山市",
"861300822", "辽宁省盘锦市",
"861879960", "新疆博尔塔拉蒙古自治州",
"861339304", "河北省石家庄市",
"861331388", "福建省泉州市",
"861582982", "陕西省榆林市",
"861520748", "湖南省长沙市",
"861895125", "江苏省连云港市",
"861346988", "湖北省黄冈市",
"861897240", "湖北省恩施土家族苗族自治州",
"861309482", "浙江省宁波市",
"861336956", "宁夏石嘴山市",
"861505622", "安徽省合肥市",
"861305409", "湖南省益阳市",
"86182306", "湖南省邵阳市",
"861327179", "河南省南阳市",
"861533141", "云南省文山壮族苗族自治州",
"861850746", "湖南省永州市",
"861825740", "浙江省宁波市",
"861859390", "广西防城港市",
"861315574", "江西省景德镇市",
"861367312", "河北省保定市",
"861322451", "黑龙江省哈尔滨市",
"861512899", "河北省保定市",
"861508910", "广东省汕头市",
"861320792", "江西省九江市",
"861369959", "江西省抚州市",
"861584530", "黑龙江省牡丹江市",
"861389545", "宁夏吴忠市",
"861379916", "福建省三明市",
"861821846", "广东省广州市",
"861779219", "陕西省汉中市",
"861554204", "辽宁省锦州市",
"861827275", "河南省南阳市",
"861318820", "辽宁省本溪市",
"861327857", "吉林省辽源市",
"861828903", "西藏山南地区",
"861773466", "陕西省榆林市",
"861597705", "广西玉林市",
"861891344", "江苏省镇江市",
"861334320", "河北省邯郸市",
"86157109", "河北省秦皇岛市",
"861865158", "江苏省无锡市",
"861328541", "山东省济南市",
"861521984", "广东省河源市",
"861529908", "新疆乌鲁木齐市",
"861508955", "广东省茂名市",
"861823641", "河南省郑州市",
"861337932", "陕西省榆林市",
"861814616", "福建省龙岩市",
"861827205", "湖北省襄樊市",
"861325018", "广东省汕头市",
"861534836", "湖南省常德市",
"861554274", "辽宁省鞍山市",
"86158036", "重庆市",
"861804208", "浙江省宁波市",
"861336443", "吉林省延边朝鲜族自治州",
"861518336", "四川省乐山市",
"86181961", "新疆昌吉回族自治州",
"861529978", "新疆哈密地区",
"861837422", "湖南省益阳市",
"86159178", "广东省江门市",
"861801844", "江苏省无锡市",
"861322591", "福建省福州市",
"86155374", "河南省许昌市",
"861301141", "河北省保定市",
"861459136", "广西贵港市",
"86156471", "内蒙古呼和浩特市",
"861872605", "安徽省安庆市",
"861786929", "云南省迪庆藏族自治州",
"861569716", "湖北省武汉市",
"861306643", "广东省江门市",
"861580833", "四川省乐山市",
"861802483", "广东省惠州市",
"86150714", "湖北省武汉市",
"861814868", "广东省茂名市",
"861503388", "河北省邯郸市",
"861589247", "四川省德阳市",
"86184813", "四川省自贡市",
"861853440", "山西省忻州市",
"861518849", "河南省南阳市",
"861530157", "江苏省苏州市",
"861339374", "河南省郑州市",
"861342180", "广东省深圳市",
"861309738", "江西省上饶市",
"861364327", "河北省沧州市",
"861555060", "山东省滨州市",
"861370567", "安徽省阜阳市",
"86182744", "湖南省邵阳市",
"861564586", "黑龙江省鸡西市",
"861390322", "河北省保定市",
"861571412", "辽宁省鞍山市",
"86156634", "黑龙江省哈尔滨市",
"86135653", "新疆昌吉回族自治州",
"86132826", "浙江省台州市",
"861354889", "湖南省邵阳市",
"861373143", "河北省承德市",
"861770760", "广东省中山市",
"861522856", "四川省巴中市",
"861325507", "福建省南平市",
"861453577", "福建省龙岩市",
"861310089", "黑龙江省大庆市",
"861530879", "云南省普洱市",
"861376846", "广西百色市",
"861800699", "福建省泉州市",
"861570487", "内蒙古鄂尔多斯市",
"861820657", "山东省滨州市",
"86176391", "河南省焦作市",
"861364466", "黑龙江省黑河市",
"861802574", "广东省潮州市",
"861707420", "浙江省杭州市",
"861372381", "湖南省娄底市",
"861572375", "广西玉林市",
"861592912", "陕西省榆林市",
"861351503", "福建省泉州市",
"86139992", "新疆乌鲁木齐市",
"861821902", "广东省韶关市",
"861599730", "湖北省襄樊市",
"86177591", "福建省福州市",
"861588510", "贵州省贵阳市",
"861311070", "福建省泉州市",
"861309726", "江西省九江市",
"86189943", "江苏省苏州市",
"861829801", "安徽省合肥市",
"861521639", "山东省青岛市",
"861321188", "云南省曲靖市",
"861329104", "甘肃省白银市",
"861591644", "广东省阳江市",
"861886087", "江苏省镇江市",
"86136525", "广东省东莞市",
"861760661", "广东省东莞市",
"861337379", "河南省洛阳市",
"861818298", "云南省楚雄彝族自治州",
"861568949", "山东省威海市",
"861516068", "福建省龙岩市",
"861309176", "黑龙江省黑河市",
"861888805", "江苏省南通市",
"861588555", "贵州省黔南布依族苗族自治州",
"861535052", "河北省邯郸市",
"861535786", "安徽省阜阳市",
"86130417", "江苏省镇江市",
"861300705", "山西省晋中市",
"861782895", "四川省攀枝花市",
"861351340", "河北省保定市",
"861561530", "山东省菏泽市",
"861302462", "浙江省绍兴市",
"861324770", "江西省南昌市",
"861308611", "江西省上饶市",
"861840750", "广东省江门市",
"86153551", "浙江省宁波市",
"861355739", "广西南宁市",
"86138786", "广西南宁市",
"861872980", "陕西省西安市",
"861881595", "福建省泉州市",
"861317582", "浙江省舟山市",
"861459778", "新疆阿克苏地区",
"861518328", "四川省内江市",
"861534828", "四川省广安市",
"86132489", "浙江省温州市",
"861502582", "甘肃省临夏回族自治州",
"861840715", "湖北省咸宁市",
"861338411", "辽宁省大连市",
"861329896", "西藏那曲地区",
"861454601", "青海省西宁市",
"861705631", "广西南宁市",
"861459128", "广西贺州市",
"861890479", "内蒙古锡林郭勒盟",
"861808637", "湖北省宜昌市",
"861818116", "四川省泸州市",
"861369550", "安徽省滁州市",
"861874996", "河南省驻马店市",
"861300162", "山东省烟台市",
"861508519", "贵州省六盘水市",
"861345141", "河北省衡水市",
"861330351", "山西省太原市",
"861377640", "江苏省南京市",
"86187999", "新疆阿克苏地区",
"86435", "吉林省通化市\、梅河口市",
"86188390", "河南省焦作市",
"861334964", "湖南省张家界市",
"861348859", "内蒙古赤峰市",
"861322240", "江苏省无锡市",
"861553530", "山西省阳泉市",
"861452888", "云南省丽江市",
"861363340", "山西省长治市",
"861315357", "山东省威海市",
"861890067", "江苏省南京市",
"861369515", "广东省佛山市",
"861377472", "福建省三明市",
"861845844", "浙江省杭州市",
"86139849", "贵州省遵义市",
"861892179", "江苏省徐州市",
"861556109", "内蒙古包头市",
"861534973", "青海省西宁市",
"861312365", "贵州省黔东南苗族侗族自治州",
"861318160", "山东省烟台市",
"861893212", "湖南省株洲市",
"861769829", "河南省濮阳市",
"861350983", "广东省东莞市",
"861539255", "山西省长治市",
"861820582", "浙江省湖州市",
"861850247", "辽宁省铁岭市",
"861364785", "广西玉林市",
"86155268", "吉林省长春市",
"861830950", "宁夏银川市",
"861760489", "内蒙古包头市",
"861580976", "青海省玉树藏族自治州",
"861315935", "福建省宁德市",
"861592507", "云南省昭通市",
"861598989", "广东省深圳市",
"861339497", "新疆阿克苏地区",
"861830915", "陕西省安康市",
"861348177", "广西柳州市",
"861302753", "河南省洛阳市",
"861815425", "安徽省芜湖市",
"861802066", "福建省漳州市",
"861855513", "安徽省芜湖市",
"861340480", "内蒙古呼和浩特市",
"861325912", "陕西省榆林市",
"861763558", "山西省运城市",
"861594546", "黑龙江省哈尔滨市",
"861529823", "四川省南充市",
"861372254", "河北省秦皇岛市",
"86185752", "广东省惠州市",
"861535465", "吉林省通化市",
"861882535", "广东省江门市",
"861778947", "甘肃省酒泉市",
"86182694", "广西玉林市",
"861347732", "湖北省十堰市",
"861380898", "山东省青岛市",
"861510577", "浙江省温州市",
"861529072", "河南省漯河市",
"861520483", "内蒙古阿拉善盟",
"861344196", "重庆市",
"8615822", "天津市",
"861337596", "福建省漳州市",
"861300865", "云南省昆明市",
"861477825", "广东省肇庆市",
"861761470", "内蒙古呼伦贝尔市",
"861373132", "河北省张家口市",
"861472915", "陕西省安康市",
"86159335", "河北省保定市",
"861388756", "云南省红河哈尼族彝族自治州",
"86138770", "广西防城港市",
"86180357", "山西省临汾市",
"861320563", "安徽省宣城市",
"861572187", "云南省昆明市",
"861535571", "浙江省杭州市",
"861335585", "浙江省绍兴市",
"861360037", "广东省湛江市",
"861800856", "贵州省铜仁地区",
"861336432", "吉林省吉林市",
"86131044", "吉林省长春市",
"861538547", "安徽省池州市",
"861337943", "陕西省渭南市",
"86131422", "湖南省长沙市",
"861332295", "广东省云浮市",
"861870392", "河南省鹤壁市",
"861700314", "河北省保定市",
"861520574", "浙江省宁波市",
"861537851", "四川省凉山彝族自治州",
"861399477", "山西省临汾市",
"861367741", "湖南省娄底市",
"861768815", "广东省深圳市",
"861869378", "甘肃省兰州市",
"861594993", "山东省枣庄市",
"861317657", "山东省淄博市",
"861580842", "四川省南充市",
"861302055", "山东省聊城市",
"861775971", "福建省龙岩市",
"861880690", "云南省临沧市",
"861842000", "广东省湛江市",
"86170935", "河南省洛阳市",
"861808798", "云南省普洱市",
"861768850", "广东省江门市",
"861560635", "山东省聊城市",
"861532457", "安徽省六安市",
"861804814", "四川省凉山彝族自治州",
"861813841", "广东省深圳市",
"861458101", "安徽省亳州市",
"861887236", "湖北省荆门市",
"861517010", "江西省鹰潭市",
"861829761", "安徽省淮南市",
"861358917", "山东省潍坊市",
"86137194", "广东省广州市",
"86182981", "安徽省阜阳市",
"861343786", "广东省湛江市",
"861775901", "福建省莆田市",
"861824816", "内蒙古包头市",
"861577941", "江西省九江市",
"861766611", "广东省深圳市",
"8618600", "北京市",
"861771889", "广东省惠州市",
"861554818", "内蒙古鄂尔多斯市",
"86155966", "陕西省西安市",
"861338245", "江苏省徐州市",
"861844721", "内蒙古锡林郭勒盟",
"861500576", "浙江省台州市",
"861375195", "广东省梅州市",
"861358421", "江苏省无锡市",
"861807665", "广西钦州市",
"861475784", "浙江省台州市",
"861528649", "贵州省六盘水市",
"861319385", "河南省信阳市",
"861315066", "云南省丽江市",
"861890356", "山西省晋城市",
"861316545", "山东省烟台市",
"861399407", "山西省忻州市",
"861858931", "云南省昆明市",
"861824668", "黑龙江省齐齐哈尔市",
"861336788", "广西河池市",
"861820854", "贵州省黔南布依族苗族自治州",
"86186275", "湖南省长沙市",
"86181913", "陕西省渭南市",
"861303319", "安徽省安庆市",
"861535287", "内蒙古呼和浩特市",
"861390365", "黑龙江省哈尔滨市",
"86130860", "海南省海口市",
"861773083", "河南省信阳市",
"86150385", "河南省洛阳市",
"86138777", "广西钦州市",
"86180350", "山西省忻州市",
"861363892", "西藏日喀则地区",
"861375573", "江西省上饶市",
"861584684", "黑龙江省双鸭山市",
"861335154", "吉林省长春市",
"861568540", "贵州省黔南布依族苗族自治州",
"861347488", "内蒙古鄂尔多斯市",
"861586623", "山东省枣庄市",
"861340344", "山西省晋中市",
"861453912", "广东省广州市",
"861810857", "贵州省毕节地区",
"861310275", "河北省衡水市",
"86184861", "贵州省安顺市",
"861525089", "江苏省淮安市",
"861838149", "四川省达州市",
"86150688", "浙江省杭州市",
"861875299", "江苏省苏州市",
"861822064", "陕西省汉中市",
"861772997", "安徽省六安市",
"861780552", "安徽省蚌埠市",
"861556729", "吉林省松原市",
"861392205", "广东省茂名市",
"861822781", "四川省眉山市",
"86178394", "河南省周口市",
"861580906", "新疆阿勒泰地区",
"861308131", "辽宁省抚顺市",
"861363573", "湖北省随州市",
"861333347", "山西省临汾市",
"861453354", "辽宁省鞍山市",
"861819601", "新疆克拉玛依市",
"861831619", "广东省肇庆市",
"861518414", "辽宁省铁岭市",
"8618549", "北京市",
"861398012", "四川省绵阳市",
"861570692", "云南省德宏傣族景颇族自治州",
"861374971", "河南省南阳市",
"861339557", "安徽省宿州市",
"861459544", "青海省海南藏族自治州",
"861511346", "广东省梅州市",
"861362049", "广东省惠州市",
"86158631", "山东省济南市",
"861580390", "河南省平顶山市",
"861534903", "甘肃省白银市",
"861454323", "内蒙古包头市",
"861808834", "云南省昆明市",
"86157203", "河北省沧州市",
"861801419", "江苏省无锡市",
"861860335", "河北省秦皇岛市",
"861477702", "广西南宁市",
"86147808", "四川省宜宾市",
"861363484", "黑龙江省齐齐哈尔市",
"86136018", "上海市",
"861773785", "河南省许昌市",
"861380734", "湖南省衡阳市",
"86189668", "陕西省西安市",
"86182553", "安徽省芜湖市",
"861876531", "山东省济南市",
"861302425", "浙江省湖州市",
"861570353", "山西省阳泉市",
"86158474", "内蒙古乌兰察布市",
"861528417", "四川省宜宾市",
"861589746", "湖南省永州市",
"861370648", "山东省青岛市",
"861319696", "江苏省淮安市",
"86189365", "江苏省淮安市",
"861530769", "广东省东莞市",
"861313992", "新疆伊犁哈萨克自治州",
"861366454", "黑龙江省佳木斯市",
"86139855", "贵州省贵阳市",
"861770870", "云南省昭通市",
"861332625", "山东省聊城市",
"861776755", "新疆喀什地区",
"861768643", "山东省青岛市",
"861786520", "山东省济宁市",
"86155509", "山东省临沂市",
"861860957", "宁夏中卫市",
"861809752", "新疆阿勒泰地区",
"86188397", "河南省安阳市",
"861884672", "黑龙江省鸡西市",
"861528921", "陕西省延安市",
"861510745", "湖南省怀化市",
"861361445", "吉林省通化市",
"861354578", "湖北省荆州市",
"861535416", "河