# automatically generated file, don't edit



# Copyright 2023 David Cantrell, derived from data from libphonenumber
# http://code.google.com/p/libphonenumber/
#
# Licensed under the Apache License, Version 2.0 (the "License");
# you may not use this file except in compliance with the License.
# You may obtain a copy of the License at
#
#     http://www.apache.org/licenses/LICENSE-2.0
#
# Unless required by applicable law or agreed to in writing, software
# distributed under the License is distributed on an "AS IS" BASIS,
# WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
# See the License for the specific language governing permissions and
# limitations under the License.
package Number::Phone::StubCountry::NZ;
use base qw(Number::Phone::StubCountry);

use strict;
use warnings;
use utf8;
our $VERSION = 1.20230307181421;

my $formatters = [
                {
                  'format' => '$1 $2',
                  'leading_digits' => '8[1-579]',
                  'national_rule' => '0$1',
                  'pattern' => '(\\d{2})(\\d{3,8})'
                },
                {
                  'format' => '$1 $2 $3',
                  'leading_digits' => '
            50(?:
              [0367]|
              88
            )|
            [89]0
          ',
                  'national_rule' => '0$1',
                  'pattern' => '(\\d{3})(\\d{2})(\\d{2,3})'
                },
                {
                  'format' => '$1 $2 $3',
                  'leading_digits' => '
            24|
            [346]|
            7[2-57-9]|
            9[2-9]
          ',
                  'national_rule' => '0$1',
                  'pattern' => '(\\d)(\\d{3})(\\d{4})'
                },
                {
                  'format' => '$1 $2 $3',
                  'leading_digits' => '
            2(?:
              10|
              74
            )|
            [59]|
            80
          ',
                  'national_rule' => '0$1',
                  'pattern' => '(\\d{3})(\\d{3})(\\d{3,4})'
                },
                {
                  'format' => '$1 $2 $3',
                  'leading_digits' => '
            1|
            2[028]
          ',
                  'national_rule' => '0$1',
                  'pattern' => '(\\d{2})(\\d{3,4})(\\d{4})'
                },
                {
                  'format' => '$1 $2 $3',
                  'leading_digits' => '
            2(?:
              [169]|
              7[0-35-9]
            )|
            7|
            86
          ',
                  'national_rule' => '0$1',
                  'pattern' => '(\\d{2})(\\d{3})(\\d{3,5})'
                }
              ];

my $validators = {
                'fixed_line' => '
          24099\\d{3}|
          (?:
            3[2-79]|
            [49][2-9]|
            6[235-9]|
            7[2-57-9]
          )\\d{6}
        ',
                'geographic' => '
          24099\\d{3}|
          (?:
            3[2-79]|
            [49][2-9]|
            6[235-9]|
            7[2-57-9]
          )\\d{6}
        ',
                'mobile' => '
          2[0-27-9]\\d{7,8}|
          21\\d{6}
        ',
                'pager' => '[28]6\\d{6,7}',
                'personal_number' => '70\\d{7}',
                'specialrate' => '(
          (?:
            11\\d{5}|
            50(?:
              0[08]|
              30|
              66|
              77|
              88
            )
          )\\d{3}|
          90\\d{6,8}
        )|(
          8(?:
            1[6-9]|
            22|
            3\\d|
            4[045]|
            5[459]|
            7[0-3579]|
            90
          )\\d{2,7}
        )',
                'toll_free' => '
          508\\d{6,7}|
          80\\d{6,8}
        ',
                'voip' => ''
              };
my %areanames = ();
$areanames{en} = {"649554", "Hibiscus\ Coast",
"6468889", "Levin",
"6473994", "Rotorua",
"6499630", "Pukekohe",
"6448880", "Paraparaumu",
"6469302", "Napier",
"6435527", "Alexandra",
"6439072", "Ashburton",
"644577", "Wellington",
"6463997", "Palmerston\ North",
"6432813", "Geraldine",
"6436527", "Haast",
"647885", "Putaruru\/Tokoroa",
"6449741", "Paraparaumu",
"6499068", "Pukekohe",
"6472140", "Putaruru\/Tokoroa",
"644204", "Wellington",
"6439003", "Ashburton",
"6468817", "Stratford",
"6478075", "Te\ Kuiti",
"6479243", "Rotorua\/Whakatane\/Tauranga",
"6434245", "Culverden",
"6436615", "Ashburton",
"6436583", "Te\ Anau",
"643338", "Christchurch",
"6432225", "Greymouth",
"6474653", "Putaruru\/Tokoroa",
"6479008", "Rotorua",
"6472118", "Taumarunui",
"6467779", "Masterton",
"6479021", "Te\ Awamutu",
"643453", "Dunedin",
"6432647", "Fairlie",
"6439090", "Rangiora",
"6434359", "Twizel",
"6435558", "Waimate",
"6447770", "Paraparaumu",
"6472818", "Rotorua",
"646374", "Dannevirke",
"6469579", "Pahiatua",
"6435688", "Queenstown",
"6439328", "South\ Island",
"6432608", "Dunedin",
"646962", "Wanganui\/New\ Plymouth",
"6432621", "Oamaru",
"6436599", "Blenheim",
"6492226", "Helensville",
"6498881", "Hibiscus\ Coast",
"6437472", "Lawrence",
"6465624", "Featherston",
"6468800", "Napier\/Hastings",
"6432444", "Nelson",
"6478133", "Putaruru\/Tokoroa",
"6436688", "Waitangi\ \(Chatham\ Is\.\)",
"6498901", "Pukekohe",
"6439744", "Queenstown",
"647822", "Hamilton\/Huntly",
"6475627", "Taupo",
"6436653", "Edendale",
"64998", "Whangarei",
"6499472", "Great\ Barrier\ Island",
"6432737", "Palmerston",
"6463913", "Hawera",
"6436997", "Motueka",
"647463", "Whakatane",
"647217", "Taupo",
"6472603", "Hamilton",
"6434280", "Queenstown",
"6499718", "Whangarei",
"6462163", "New\ Plymouth",
"64429", "Paraparaumu",
"6435997", "Amberley",
"64378", "Westport",
"643957", "Timaru",
"6474442", "Morrinsville",
"643392", "South\ Island",
"64371", "South\ Island",
"6497771", "Kaikohe",
"6435541", "Te\ Anau",
"643390", "Christchurch",
"6437487", "Winton",
"643751", "Fox\ Glacier",
"6435676", "Kurow",
"6497778", "Pukekohe",
"646375", "Pahiatua",
"646849", "Napier\ City",
"6435548", "Westport",
"6432657", "Motueka",
"6499423", "Great\ Barrier\ Island",
"646327", "Marton",
"6466552", "New\ Plymouth",
"6472623", "Tauranga",
"6436548", "Waimate",
"644551", "Paraparaumu",
"6434297", "Westport",
"647820", "Hamilton\/Huntly",
"6478994", "Tauranga",
"6439769", "Roxburgh",
"6475607", "Morrinsville",
"6434404", "Alexandra",
"6435510", "Darfield",
"647986", "Hamilton",
"647884", "Morrinsville",
"6436681", "Dunedin",
"6433996", "Edendale",
"644205", "Wellington",
"6466526", "Waiouru",
"6465604", "Ohakune",
"6468997", "Napier",
"6468820", "Palmerston\ North",
"646960", "Wanganui\/New\ Plymouth",
"6468262", "Napier",
"6435681", "Invercargill",
"6439321", "Amberley",
"647334", "Rotorua",
"647315", "Opotiki",
"6475950", "Hamilton",
"6499554", "Kaitaia",
"6475825", "Hamilton",
"6432628", "Ranfurly",
"6434234", "Darfield",
"6496514", "Whangarei",
"6432993", "Balclutha",
"6469242", "Levin",
"6439283", "Rangiora",
"6498853", "Whangarei",
"6432712", "Amberley",
"6439735", "Lumsden",
"6439347", "Christchurch",
"6498815", "Helensville",
"6434229", "Winton",
"6462419", "Masterton",
"6435889", "Timaru",
"6479001", "Hamilton",
"6432809", "Hokitika",
"6499012", "Kawakawa",
"6439857", "Akaroa",
"64373", "Greymouth",
"6435551", "Franz\ Josef",
"6472811", "Tauranga",
"6439019", "Roxburgh",
"6439299", "Murchison",
"6466996", "Stratford",
"647923", "Whakatane",
"64732", "Whakatane",
"649439", "Dargaville",
"6472220", "Tauranga",
"646590", "Palmerston\ North",
"6466014", "Napier",
"6439023", "Te\ Anau",
"6439754", "Darfield",
"6436507", "Kaikoura",
"6499061", "Hibiscus\ Coast",
"6436643", "Balclutha",
"6462423", "Gisborne",
"647869", "Thames",
"643527", "Motueka",
"6495533", "Whangarei",
"649458", "Dargaville",
"6475610", "Putaruru\/Tokoroa",
"6479746", "Opotiki",
"6439274", "Queenstown",
"6468250", "Stratford",
"643241", "Tokanui\/Lumsden\/Te\ Anau",
"6462602", "Palmerston\ North",
"6435507", "Ashburton",
"6439536", "Waimate",
"6434232", "Ashburton",
"6434998", "Dunedin",
"6496512", "Whangarei",
"6432714", "Cheviot",
"6463900", "Gisborne",
"6465602", "Palmerston\ North",
"6499725", "Hibiscus\ Coast",
"6436519", "Takaka",
"6472610", "Morrinsville",
"6432643", "Haast",
"6468264", "Palmerston\ North",
"6434266", "Palmerston",
"6499552", "Dargaville",
"6469271", "Pahiatua",
"6437448", "Haast",
"6439881", "Greymouth",
"6479107", "Whakatane",
"6473933", "Rotorua",
"6439760", "Twizel",
"6479247", "Hamilton",
"6436587", "Gore",
"6435519", "Twizel",
"6478992", "Paeroa",
"6434402", "Alexandra",
"6474657", "Thames",
"6479851", "Waihi",
"64423", "Wellington",
"6432817", "Christchurch",
"6463993", "Pahiatua",
"6436523", "Hokitika",
"643332", "Christchurch",
"6466554", "Hawera",
"6498", "Auckland",
"6439007", "Dunedin",
"6468813", "Taihape",
"646955", "Palmerston\ North\/New\ Plymouth",
"6495561", "Whangarei",
"6469286", "Dannevirke",
"6439876", "Roxburgh",
"6432889", "Blenheim",
"6439315", "Tokanui",
"646651", "Napier",
"6462138", "Palmerston\ North",
"6475619", "Hamilton",
"644210", "Wellington",
"6435993", "Mt\ Cook",
"6468259", "Levin",
"6462167", "Mokau",
"6493943", "Helensville",
"6498821", "Dargaville",
"644280", "Wellington",
"646968", "New\ Plymouth\ W100",
"6439272", "Timaru",
"6437451", "Blenheim",
"6462604", "Ohakune",
"6472125", "Huntly",
"6499875", "Dargaville",
"6432733", "Geraldine",
"6439752", "Cheviot",
"6439525", "Milton",
"6463917", "Wanganui",
"6439048", "Lawrence",
"6436993", "Kaikoura",
"644590", "Wellington",
"6436628", "Ashburton",
"6472607", "Paeroa",
"647828", "Huntly",
"6478137", "Thames",
"6439290", "Christchurch",
"6479848", "Te\ Kuiti",
"6479500", "Whakatane",
"6499451", "Warkworth",
"6432426", "Blenheim",
"6436657", "Franz\ Josef",
"6475623", "Tauranga",
"6439726", "Timaru",
"6434220", "Invercargill",
"6462410", "New\ Plymouth",
"643466", "Dunedin",
"6473337", "Rotorua",
"6435880", "Dunedin",
"6432800", "Te\ Anau",
"6472198", "Opotiki",
"6469710", "New\ Plymouth",
"6439010", "Queenstown",
"6499014", "Dargaville",
"6435695", "Fox\ Glacier",
"646954", "Palmerston\ North\ W100",
"6468993", "Taihape",
"64347", "Dunedin",
"6467770", "Gisborne",
"6472191", "Whakatane",
"6498019", "Pukekohe",
"6432997", "Edendale",
"64730", "Whakatane",
"647903", "Hamilton",
"6498857", "Dargaville",
"6439099", "Kaikoura",
"6439287", "Oamaru",
"6434350", "Twizel",
"6439706", "Nelson",
"6493207", "Hibiscus\ Coast",
"6475603", "Hamilton",
"6479841", "Huntly",
"6469006", "Gisborne",
"6499458", "Kawakawa",
"649431", "Maungaturoto",
"64379", "South\ Island",
"6462816", "Gisborne",
"6472627", "Rotorua",
"6439041", "Ashburton",
"646763", "Opunake",
"6436621", "Culverden",
"643944", "Christchurch",
"6439074", "Ashburton",
"6434293", "Haast",
"6479295", "Whakatane",
"6472149", "Whangamata",
"647861", "Paeroa\/Waihi\/Thames\/Whangamata",
"6462624", "Opunake",
"6468880", "Napier\/Hastings",
"6469304", "Wairoa",
"643249", "Te\ Anau",
"64331", "Rangiora\/Amberley\/Culverden\/Darfield\/Cheviot\/Kaikoura",
"6437483", "Otautau",
"643983", "Christchurch",
"6472805", "Morrinsville",
"6473992", "Opotiki",
"643979", "Christchurch",
"6437458", "Kaikoura",
"6432653", "Wanaka",
"644212", "Wellington",
"64338", "Christchurch",
"6474444", "Hamilton",
"6434289", "Wanaka",
"6432615", "Amberley",
"6495568", "Kawakawa",
"6435503", "Christchurch",
"643759", "Hokitika\/Franz\ Josef\ Glacier\/Fox\ Glacier\/Haast",
"646841", "Napier\ City",
"643926", "Christchurch",
"6472424", "Tauranga",
"6479858", "Whakatane",
"6439027", "Winton",
"6499474", "Helensville",
"6469616", "Featherston",
"6436503", "Ashburton",
"6436647", "Te\ Anau",
"6439083", "Cheviot",
"649959", "Hibiscus\ Coast",
"6439742", "Christchurch",
"6492006", "Helensville",
"6432442", "Christchurch",
"6433916", "Hokitika",
"64757", "Tauranga",
"6439343", "Waimate",
"6469570", "Palmerston\ North",
"649452", "Auckland",
"6434991", "Cromwell",
"6437474", "Oamaru",
"6492839", "Whangarei",
"6465622", "Stratford",
"6468249", "Opunake",
"6436590", "Nelson",
"6463920", "Palmerston\ North",
"6439853", "Amberley",
"643417", "Milton",
"6469278", "Gisborne",
"6437441", "Motueka",
"6468809", "Masterton",
"6439888", "Christchurch\/Blenheim\/Nelson",
"6474448", "Taumarunui",
"6439719", "Waimate",
"647981", "Hamilton",
"6469019", "Pahiatua",
"6495564", "Whangarei",
"6462109", "Waiouru",
"6435560", "Mt\ Cook",
"6435996", "Akaroa",
"6462809", "Napier\/Hastings",
"6472428", "Taupo",
"6479854", "Rotorua",
"6432736", "Dunedin",
"6499478", "Pukekohe",
"6436996", "Takaka",
"6466551", "New\ Plymouth",
"6469299", "Napier\/Hastings",
"6436560", "Palmerston",
"6499469", "Maungaturoto",
"6436682", "Dunedin",
"6432423", "Dunedin",
"6496010", "Kaitaia",
"643590", "Christchurch",
"643756", "Hokitika",
"6439723", "Blenheim",
"6475626", "Taupo",
"6469241", "Napier",
"6437478", "Twizel",
"6433980", "Milton",
"643224", "Invercargill",
"6437469", "Alexandra",
"6432711", "Akaroa",
"643690", "Waimate",
"6492227", "Whangarei",
"6472457", "Rotorua",
"6435682", "Riverton",
"6468261", "Masterton",
"6439322", "Culverden",
"6469274", "New\ Plymouth",
"6439884", "Franz\ Josef",
"6435552", "Queenstown",
"646838", "Wairoa",
"6472812", "Tauranga",
"6439330", "Westport",
"6479002", "Matamata",
"6434263", "Lawrence",
"6432646", "Timaru",
"6499011", "Kaitaia",
"6439450", "Invercargill",
"643246", "Tokanui",
"6499454", "Whangarei",
"6466548", "Ruatoria",
"646388", "Taihape",
"6432750", "Invercargill",
"6433945", "Cheviot",
"6436526", "Fox\ Glacier",
"6499062", "Hibiscus\ Coast",
"6463996", "Palmerston\ North",
"643741", "Christchurch",
"6439078", "Ashburton",
"6439069", "Haast",
"6468816", "Hawera",
"643415", "Balclutha",
"6462628", "Wanganui",
"6469308", "Opunake",
"6439873", "Wanaka",
"6469283", "Opunake",
"6498824", "Kawakawa",
"6496007", "Helensville",
"6435526", "Kurow",
"643485", "Lawrence",
"6437454", "Ashburton",
"6496995", "Maungaturoto",
"6462601", "Palmerston\ North",
"643232", "Riverton\/Winton",
"643225", "Otautau",
"6479747", "Te\ Kuiti",
"6462621", "New\ Plymouth",
"643230", "Invercargill",
"6469301", "Ruatoria",
"643538", "Nelson",
"6435506", "Amberley",
"6439537", "Dunedin\/Timaru",
"6462608", "Dannevirke",
"643469", "Dunedin",
"6478093", "Rotorua",
"6474639", "Opotiki",
"6499040", "Helensville",
"643947", "Invercargill",
"6439044", "Milton",
"6436506", "Darfield",
"6436624", "Darfield",
"6469613", "Levin",
"6439071", "Motueka",
"6435665", "Waimate",
"643277", "South\ Island",
"6499298", "Pukekohe",
"6466997", "New\ Plymouth",
"6479844", "Otorohanga",
"6469468", "Featherston",
"6466005", "Mokau",
"6462155", "Hawera",
"649403", "Kawakawa",
"64396", "Christchurch",
"6433913", "Murchison",
"6432630", "Christchurch",
"6479022", "Morrinsville",
"644810", "Wellington",
"6439346", "Christchurch",
"6492808", "Great\ Barrier\ Island",
"6472194", "Whakatane",
"6439856", "Darfield",
"6499018", "Maungaturoto",
"643420", "Christchurch",
"6432622", "Balclutha",
"6434994", "Palmerston",
"643414", "Balclutha\/Milton",
"6498882", "Whangarei",
"643435", "Oamaru\/Mount\ Cook\/Twizel\/Kurow",
"6468996", "Napier",
"6437471", "Kurow",
"6432718", "Rangiora",
"6468268", "New\ Plymouth",
"647878", "Te\ Kuiti",
"643212", "Invercargill",
"6437444", "Takaka",
"6433955", "Mt\ Cook",
"6475606", "Matamata",
"6439703", "Takaka",
"64483", "Wellington",
"6469003", "Napier\/Hastings",
"643443", "Wanaka",
"6477885", "Tauranga",
"6466527", "Taihape",
"6462813", "Wanganui",
"6492", "Auckland",
"6433997", "Gore",
"6436639", "Oamaru",
"649907", "Warkworth",
"64369", "Geraldine",
"6462225", "Levin",
"6499471", "Hibiscus\ Coast",
"6466558", "Opunake",
"64328", "South\ Island",
"6432740", "Lawrence",
"6434296", "Greymouth",
"6474441", "Waihi",
"6497772", "Kaitaia",
"6465615", "Wanganui",
"6435542", "Riverton",
"6479708", "Thames",
"64795", "Hamilton",
"6493930", "Whangarei",
"6437486", "Tokanui",
"6462129", "Waiouru",
"6442820", "Wellington",
"6437779", "Invercargill",
"6432656", "Nelson",
"6435677", "Ranfurly",
"64361", "Timaru",
"6479753", "Taupo",
"6432639", "Edendale",
"64329", "South\ Island",
"64368", "Timaru",
"6462615", "Gisborne",
"6472192", "Whakatane",
"6478136", "Te\ Awamutu",
"647866", "Thames",
"6432427", "Greymouth",
"6479842", "Matamata",
"6449", "Wellington",
"6473949", "Taupo",
"6442197", "Paraparaumu",
"6436656", "Hokitika",
"6434275", "Milton",
"6439727", "Dunedin",
"6495", "Auckland",
"6466018", "Napier",
"6436622", "Cheviot",
"643682", "Timaru\/Waimate\/Fairlie",
"6499049", "Great\ Barrier\ Island",
"6463916", "Mokau",
"6439865", "Murchison",
"643749", "Christchurch",
"6439758", "Ashburton",
"6472606", "Huntly",
"6439042", "Oamaru",
"6469853", "Waiouru",
"647870", "Te\ Awamutu",
"6439269", "Dunedin",
"6473991", "Whakatane",
"6442608", "Paraparaumu",
"6439278", "Invercargill",
"6462166", "Opunake",
"64944", "Auckland",
"6496", "Auckland",
"6442129", "Paraparaumu",
"6469287", "Ohakune",
"646832", "Napier\/Wairoa",
"647989", "Taupo",
"644888", "Wellington",
"6439877", "Christchurch\/Blenheim\/Nelson",
"64737", "Taupo",
"6462120", "Palmerston\ North",
"6493939", "Auckland",
"643954", "Dunedin\/Timaru",
"6478080", "Hamilton",
"6497774", "Warkworth",
"644818", "Wellington",
"64936", "Auckland",
"6437770", "Nelson",
"6435544", "Winton",
"64340", "South\ Island",
"647220", "Tauranga",
"6436630", "Takaka",
"644890", "Wellington",
"6432816", "Waimate",
"646382", "Taihape",
"6439006", "Nelson",
"6432749", "Wanaka",
"6432441", "Christchurch",
"6478998", "Hamilton",
"6479246", "Thames",
"6432665", "South\ Island",
"6434408", "Queenstown\/Cromwell\/Alexandra\/Wanaka\/Ranfurly\/Roxburgh",
"6436586", "Edendale",
"64683", "Napier\/Hastings",
"6439741", "Christchurch",
"6474656", "Te\ Awamutu",
"646846", "Napier\ City",
"643921", "Blenheim",
"6465608", "Dannevirke",
"644777", "Wellington",
"64638", "Taihape\/Ohakune\/Waiouru",
"649347", "Auckland",
"6437442", "Murchison",
"6499558", "Great\ Barrier\ Island",
"6434992", "Ranfurly",
"6479420", "Tauranga",
"6432624", "Milton",
"6434238", "Waitangi\ \(Chatham\ Is\.\)",
"6496518", "Kawakawa",
"6465621", "New\ Plymouth",
"6434267", "Ranfurly",
"6479715", "Paeroa",
"643238", "Riverton\/Winton",
"643525", "Takaka",
"6465601", "Palmerston\ North",
"6433989", "Waimate",
"6477775", "Huntly",
"6435684", "Winton",
"6439324", "Darfield",
"6437460", "Waitangi\ \(Chatham\ Is\.\)",
"6439882", "Westport",
"6499551", "Whangarei",
"6469272", "Featherston",
"6434231", "Christchurch",
"6496511", "Whangarei",
"6469203", "New\ Plymouth",
"6432448", "Dunedin",
"6478991", "Whangamata",
"6466993", "Waiouru",
"6434401", "Cromwell",
"647887", "Morrinsville",
"6436684", "Dunedin",
"6492007", "Warkworth",
"6439748", "Dunedin",
"646656", "Levin",
"6439052", "Mt\ Cook",
"6479230", "Opotiki",
"6433917", "Franz\ Josef",
"6439026", "Riverton",
"6472133", "Taupo",
"6478097", "Whakatane",
"644892", "Paraparaumu",
"6469290", "Napier\/Hastings",
"6479852", "Whangamata",
"6436569", "Alexandra",
"6469617", "Wanganui\/New\ Plymouth",
"6462426", "Levin",
"6499460", "Whangarei",
"6436646", "Roxburgh",
"6436578", "Wanaka",
"64363", "South\ Island",
"6439710", "Timaru",
"6462100", "Levin",
"6469010", "Taihape",
"646830", "Napier",
"6439533", "Geraldine",
"6495562", "Whangarei",
"6462800", "Palmerston\ North",
"6432725", "Hokitika",
"6498822", "Kaikohe",
"6437452", "Akaroa",
"6439271", "Westport",
"6473998", "Taumarunui",
"643288", "Christchurch",
"6499100", "Pukekohe",
"643524", "Takaka",
"643218", "Invercargill",
"647872", "Te\ Awamutu",
"6435673", "Lawrence",
"643461", "Dunedin\/Palmerston",
"6472626", "Rotorua",
"6466011", "Marton",
"6435535", "Invercargill",
"6439751", "Culverden",
"643680", "Fairlie",
"6499064", "Helensville",
"6439060", "Greymouth",
"644906", "Paraparaumu",
"6493206", "Pukekohe",
"647215", "Rotorua",
"6439707", "Takaka",
"6499733", "Warkworth",
"6469007", "Masterton",
"6439459", "Tokanui",
"6466523", "Palmerston\ North",
"6478140", "Rotorua",
"6432759", "South\ Island",
"6433993", "Te\ Anau",
"6499452", "Warkworth",
"6462817", "Napier",
"643651", "Nelson",
"6479004", "Te\ Awamutu",
"6469315", "Taihape",
"649423", "Warkworth",
"6432996", "Riverton",
"643955", "Dunedin",
"6498856", "Maungaturoto",
"6435554", "Cromwell",
"6473925", "Putaruru\/Tokoroa",
"6439286", "Cromwell",
"6439339", "South\ Island",
"6472814", "Putaruru\/Tokoroa",
"6472614", "Otorohanga",
"6468260", "Featherston",
"643450", "Queenstown",
"6469025", "Mokau",
"6439725", "Christchurch",
"6496519", "Maungaturoto",
"6434277", "Ranfurly",
"6468822", "Masterton",
"6434239", "Christchurch",
"64933", "Auckland",
"6499559", "Whangarei",
"6463904", "Napier",
"6432710", "Christchurch",
"6433981", "Twizel",
"6469240", "Gisborne",
"6465609", "Pahiatua",
"6432425", "Invercargill",
"6462617", "Masterton",
"6435512", "Rangiora",
"646847", "Napier\/Hastings",
"6435696", "Haast",
"647922", "Whakatane",
"643576", "Nelson",
"6434409", "Queenstown\/Cromwell\/Alexandra\/Wanaka\/Ranfurly\/Roxburgh",
"6478999", "Hamilton",
"6439764", "Lawrence",
"6432748", "Cromwell",
"6499007", "Kaikohe",
"6469893", "Ruatoria",
"6466550", "New\ Plymouth",
"6472126", "Otorohanga",
"643411", "Balclutha\/Milton",
"6436561", "Oamaru",
"643660", "Christchurch",
"64686", "Gisborne",
"6472826", "Matamata",
"6493938", "Auckland",
"6499876", "Kaikohe",
"6435561", "Dunedin",
"643268", "South\ Island",
"6439526", "Twizel",
"6439867", "Christchurch\/Blenheim\/Nelson",
"6442128", "Paraparaumu",
"6462600", "Palmerston\ North",
"6468252", "Dannevirke",
"6475612", "Te\ Kuiti",
"6433943", "Amberley",
"6442609", "Paraparaumu",
"6439279", "Christchurch",
"6439268", "Dunedin",
"64784", "Hamilton",
"6472222", "Hamilton",
"647460", "Rotorua",
"6439316", "Edendale",
"6439759", "Cromwell",
"6496993", "Whangarei",
"6499048", "Pukekohe",
"6466019", "Napier",
"649470", "Whangarei",
"6469285", "Hawera",
"6439875", "Ranfurly",
"6473948", "Opotiki",
"6499726", "Kawakawa",
"6432751", "Riverton",
"643905", "Ashburton",
"6434265", "Milton",
"6479717", "Otorohanga",
"6439451", "Invercargill",
"6492426", "Whangarei",
"643529", "Nelson",
"647867", "Thames",
"646768", "New\ Plymouth",
"6439294", "Dunedin",
"6439331", "Greymouth",
"649398", "Auckland\/Waiheke\ Island",
"6439014", "Ashburton",
"6499010", "Kaitaia",
"6469714", "Hawera",
"6432667", "South\ Island",
"646376", "Pahiatua",
"6435884", "Dunedin",
"6432804", "Riverton",
"6434224", "Te\ Anau",
"6462414", "Napier",
"6432638", "Tokanui",
"6439338", "Queenstown",
"6462153", "New\ Plymouth",
"6433915", "Greymouth",
"6439092", "Rangiora",
"6467774", "Dannevirke",
"64636", "Levin",
"64947", "Auckland",
"6466003", "Ruatoria",
"646963", "Wanganui\/New\ Plymouth",
"6432631", "Gore",
"647552", "Tauranga",
"6432758", "Otautau",
"647823", "Hamilton",
"6477777", "Hamilton",
"6439458", "Edendale",
"6432727", "Fox\ Glacier",
"6439070", "Motueka",
"6499041", "Helensville",
"6432616", "Ashburton",
"647462", "Taupo",
"6472142", "Te\ Awamutu",
"6469615", "Masterton",
"64938", "Auckland\/Waiheke\ Island",
"6435663", "Twizel",
"64931", "Auckland\/Waiheke\ Island",
"643393", "Christchurch",
"6478095", "Taupo",
"6473999", "Taupo",
"64399", "South\ Island",
"6462620", "New\ Plymouth",
"6468884", "Palmerston\ North",
"6469300", "Gisborne",
"646213", "Wanganui",
"6472420", "Hamilton",
"6493931", "Whangarei",
"646949", "Levin\ W100",
"6479296", "Tauranga",
"643938", "South\ Island",
"6434282", "Queenstown",
"6442821", "Wellington",
"6474440", "Paeroa",
"6462223", "Palmerston\ North",
"6435537", "Winton",
"6432741", "Milton",
"6436579", "Wanaka",
"6472806", "Matamata",
"6499470", "Hibiscus\ Coast",
"643221", "Invercargill",
"6436568", "Roxburgh",
"6465613", "Wairoa",
"646657", "Masterton",
"6439749", "Christchurch",
"6473927", "Te\ Kuiti",
"647920", "Rotorua",
"6469317", "Pahiatua",
"643959", "Dunedin\/Timaru",
"647886", "Putaruru\/Tokoroa",
"6432449", "Queenstown",
"6468242", "Ruatoria",
"6477883", "Hamilton",
"6436594", "Waimate",
"6462815", "Wairoa",
"6492832", "Dargaville",
"6463924", "Marton",
"64734", "Rotorua",
"6439705", "Motueka",
"6468802", "New\ Plymouth",
"6433953", "Geraldine",
"6469574", "Taihape",
"6462115", "Wairoa",
"643452", "Wanaka",
"6433988", "Wanaka",
"6437470", "Balclutha",
"6469005", "Wanganui",
"646860", "Gisborne\/Ruatoria",
"647589", "Hamilton",
"6468882", "Napier\/Hastings",
"6473990", "Te\ Awamutu",
"6439863", "Motueka",
"6462629", "Levin",
"6469309", "Mokau",
"6499003", "Warkworth",
"6472144", "Matamata",
"643654", "Timaru",
"6439068", "Fox\ Glacier",
"647928", "Tauranga",
"6439079", "Murchison",
"6462613", "Waipukurau",
"6492225", "Pukekohe",
"643977", "Christchurch",
"6466549", "Ruatoria",
"643521", "Nelson",
"643247", "Tokanui\/Lumsden\/Te\ Anau",
"6467772", "Hawera",
"6439094", "Ashburton",
"6434273", "Lawrence",
"643464", "Dunedin",
"643930", "Christchurch",
"643925", "Christchurch",
"6468804", "Napier",
"6465620", "New\ Plymouth",
"6479421", "Tauranga",
"6469572", "Palmerston\ North",
"6432226", "Timaru",
"6478076", "Te\ Awamutu",
"6468244", "Waipukurau",
"6432663", "Christchurch",
"646321", "Marton",
"6434246", "Waitangi\ \(Chatham\ Is\.\)",
"6437468", "Wanaka",
"6436616", "Geraldine",
"6492834", "Kawakawa",
"6437479", "Edendale",
"6436592", "Nelson",
"6463922", "Palmerston\ North",
"6469040", "Wairoa",
"643757", "Hokitika\/Franz\ Josef\ Glacier\/Fox\ Glacier\/Haast",
"6479713", "Morrinsville",
"6439740", "Christchurch",
"64391", "South\ Island",
"6432440", "Christchurch",
"6445", "Wellington\/Hutt\ Valley",
"6499468", "Kawakawa",
"64790", "Taupo",
"6499", "Auckland",
"6469298", "Masterton",
"643419", "Balclutha",
"6499479", "Pukekohe",
"6496997", "Hibiscus\ Coast",
"646762", "Stratford",
"6436631", "Motueka",
"6462808", "Napier\/Hastings",
"6478081", "Rotorua",
"6472429", "Whakatane",
"6437771", "Blenheim",
"649392", "Auckland",
"6462121", "Palmerston\ North",
"6433947", "Darfield",
"6462108", "Ohakune",
"649957", "Pukekohe",
"644213", "Wellington",
"6439718", "Mt\ Cook",
"643982", "Christchurch",
"6474449", "Opotiki",
"6434284", "Wanaka",
"6462801", "Palmerston\ North",
"643980", "Christchurch",
"6437778", "Greymouth",
"6462128", "Ohakune",
"643465", "Palmerston",
"6435667", "Waitangi\ \(Chatham\ Is\.\)",
"6479709", "Matamata",
"6462101", "Levin",
"643924", "Christchurch",
"6439711", "Geraldine",
"649390", "Auckland",
"6499461", "Whangarei",
"6439535", "Fairlie",
"646760", "New\ Plymouth\/Opunake\/Stratford",
"6496100", "Pukekohe",
"6432723", "Takaka",
"6466559", "Mokau",
"6469291", "Gisborne",
"6436638", "Kurow",
"643655", "Dunedin",
"6439762", "Oamaru",
"6439736", "Riverton",
"6435514", "Palmerston",
"6477773", "Taupo",
"6498816", "Great\ Barrier\ Island",
"643951", "Dunedin",
"6478990", "Thames",
"6434400", "Alexandra",
"6462157", "Stratford",
"6463902", "Gisborne",
"6468269", "New\ Plymouth",
"6434230", "Christchurch",
"6496510", "Whangarei",
"647211", "Hamilton",
"6432719", "Waitangi\ \(Chatham\ Is\.\)",
"6472612", "Te\ Awamutu",
"6466995", "Opunake",
"6437461", "Fairlie",
"6465600", "Palmerston\ North",
"6469249", "Masterton",
"6468824", "Wanganui",
"6466007", "Stratford",
"6444887", "Paraparaumu",
"6477887", "Te\ Awamutu",
"6499019", "Maungaturoto",
"6432802", "Gore",
"6435882", "Dunedin",
"643260", "Christchurch",
"6462412", "Gisborne",
"6434222", "Gore",
"6433995", "Tokanui",
"646956", "Palmerston\ North\/New\ Plymouth",
"6466525", "Marton",
"6439012", "Queenstown",
"644571", "Wellington",
"6492809", "Maungaturoto",
"6433957", "Palmerston",
"6469712", "New\ Plymouth",
"6478141", "Taupo",
"6475826", "Hamilton",
"644245", "Wellington",
"6473923", "Otorohanga",
"6439292", "Timaru",
"644975", "Paraparaumu",
"6469313", "Marton",
"6499299", "Whangarei",
"6439061", "Greymouth",
"6439750", "Kaikoura",
"6435675", "Twizel",
"6496507", "Helensville",
"643276", "South\ Island",
"6474638", "Opotiki",
"6472224", "Taupo",
"6466010", "Taihape",
"643946", "Invercargill",
"6465617", "Mokau",
"6462609", "Pahiatua",
"6499101", "Pukekohe",
"6468304", "Napier\/Wairoa",
"6439270", "Greymouth",
"6468254", "Ohakune",
"6462227", "Napier",
"643458", "Dunedin\/Queenstown",
"6435533", "Murchison",
"6475614", "Thames",
"6439091", "Rangiora",
"6447771", "Paraparaumu",
"6479020", "Te\ Awamutu",
"6432632", "Lumsden",
"6474655", "Te\ Kuiti",
"643279", "South\ Island",
"6432223", "Akaroa",
"6436613", "Wanaka",
"6472199", "Opotiki",
"6479245", "Matamata",
"6434243", "Akaroa",
"6432666", "South\ Island",
"643213", "Invercargill",
"6478073", "Putaruru\/Tokoroa",
"643467", "Dunedin",
"643949", "Dunedin",
"6436585", "Tokanui",
"6499727", "Whangarei",
"6479716", "Waihi",
"64735", "Rotorua",
"6466579", "Featherston",
"6492427", "Warkworth",
"6479849", "Thames",
"643442", "Queenstown",
"6472141", "Te\ Kuiti",
"6499042", "Hibiscus\ Coast",
"6436629", "Christchurch",
"646959", "Palmerston\ North\/New\ Plymouth",
"6439317", "Gore",
"6449740", "Paraparaumu",
"6439049", "Palmerston",
"643657", "Queenstown",
"6435", "South\ Island",
"649428", "Hibiscus\ Coast",
"6439005", "Invercargill",
"643436", "Kurow",
"6499631", "Pukekohe",
"6468258", "Waiouru",
"6475618", "Opotiki",
"6462139", "Palmerston\ North",
"6432815", "Fairlie",
"6478084", "Hamilton",
"64336", "South\ Island",
"6497770", "Whangarei",
"6435540", "Edendale",
"6437774", "Queenstown",
"6462124", "Marton",
"6432888", "Nelson",
"6472605", "Thames",
"6499877", "Maungaturoto",
"6434281", "Queenstown",
"6439527", "Kurow",
"6493932", "Dargaville",
"6463915", "Opunake",
"647881", "Matamata",
"6439866", "Christchurch\/Blenheim\/Nelson",
"6499006", "Whangarei",
"6472127", "Paeroa",
"6432742", "Twizel",
"6472827", "Tauranga",
"64754", "Tauranga",
"6436634", "Mt\ Cook",
"6462165", "Stratford",
"6494312", "Warkworth",
"6462616", "Ruatoria",
"6435697", "Westport",
"6498900", "Pukekohe",
"6435518", "Milton",
"649402", "Kawakawa",
"643754", "Hokitika\/Franz\ Josef\ Glacier\/Fox\ Glacier\/Haast",
"6468801", "Wanganui",
"6437449", "Hokitika",
"6436518", "Murchison",
"6432620", "Palmerston",
"6436655", "Westport",
"6434276", "Palmerston",
"6498880", "Helensville",
"643226", "Otautau",
"6468241", "Gisborne",
"6478135", "Te\ Kuiti",
"6475958", "Taupo",
"6492831", "Maungaturoto",
"6434999", "Dunedin",
"6468808", "Palmerston\ North",
"6469279", "Levin",
"6439889", "Christchurch\/Blenheim\/Nelson",
"6463943", "Masterton",
"643416", "Balclutha\/Milton",
"6433982", "Kurow",
"6439320", "Akaroa",
"6435680", "Dunedin",
"6468248", "New\ Plymouth",
"6437464", "Timaru",
"6492838", "Pukekohe",
"6468821", "Featherston",
"649400", "Kaikohe",
"6432995", "Winton",
"6475823", "Hamilton",
"6499748", "Whangarei",
"6498855", "Kawakawa",
"6473926", "Taumarunui",
"6439285", "Invercargill",
"6436680", "Akaroa",
"6435511", "Kaikoura",
"6469316", "Dannevirke",
"6496012", "Kawakawa",
"6499464", "Whangarei",
"6472807", "Te\ Awamutu",
"643245", "Tokanui\/Lumsden\/Te\ Anau",
"6469294", "Palmerston\ North",
"6479859", "Tauranga",
"6436562", "Balclutha",
"6462804", "Palmerston\ North",
"64785", "Hamilton",
"6435562", "Invercargill",
"644260", "Wellington",
"6479297", "Tauranga",
"6462104", "Marton",
"643571", "Nelson",
"6472625", "Opotiki",
"6467525", "Mokau",
"6469014", "Dannevirke",
"643233", "Riverton\/Winton",
"6495569", "Maungaturoto",
"6439714", "Waimate",
"6435536", "Invercargill",
"6434288", "Cromwell",
"6437459", "Rangiora",
"6462425", "Masterton",
"6436645", "Ranfurly",
"6439025", "Otautau",
"6468251", "Wanganui",
"644555", "Wellington",
"6475611", "Taumarunui",
"6472148", "Waihi",
"6499060", "Warkworth",
"6439064", "Ashburton",
"6432726", "Franz\ Josef",
"646371", "Masterton\/Dannevirke\/Pahiatua",
"6432617", "Cheviot",
"643755", "Hokitika",
"6472221", "Tauranga",
"6478144", "Tauranga",
"6439452", "Gore",
"6479229", "Opotiki",
"6499459", "Maungaturoto",
"6432752", "Te\ Anau",
"6477776", "Whangamata",
"6439733", "Te\ Anau",
"6439098", "Akaroa",
"6435550", "Fox\ Glacier",
"6472810", "Tauranga",
"6498018", "Whangarei",
"6479000", "Hamilton",
"6439332", "Hokitika",
"6462102", "Levin",
"6469012", "Waiouru",
"6439712", "Fairlie",
"6468815", "Pahiatua",
"647391", "Hamilton",
"6495560", "Whangarei",
"6462802", "Palmerston\ North",
"647873", "Otorohanga",
"6433946", "Culverden",
"6499719", "Whangarei",
"6436525", "Franz\ Josef",
"647889", "Morrinsville",
"6463995", "Marton",
"643956", "Timaru",
"644905", "Paraparaumu",
"6496996", "Warkworth",
"647216", "Rotorua",
"6439313", "Te\ Anau",
"6436564", "Milton",
"6499462", "Whangarei",
"6479850", "Tokoroa",
"6469292", "Ruatoria",
"643448", "Alexandra",
"646946", "Masterton",
"6432645", "Greymouth",
"6496014", "Dargaville",
"6436689", "Christchurch",
"6439050", "Geraldine",
"643206", "Edendale",
"646844", "Napier\/Hastings",
"6439761", "Kurow",
"6472611", "Matamata",
"6469270", "Marton",
"649422", "Warkworth",
"6439880", "Greymouth",
"6437462", "Geraldine",
"6436598", "Wanaka",
"6463928", "Pahiatua",
"6432227", "Queenstown",
"6434247", "Kaikoura",
"6473935", "Rotorua",
"6436617", "Cromwell",
"6478077", "Waihi",
"6435689", "Otautau",
"6463901", "Gisborne",
"6439329", "South\ Island",
"6432609", "Mt\ Cook",
"6469578", "Marton",
"6433984", "Roxburgh",
"6439334", "Fox\ Glacier",
"6472819", "Rotorua",
"6439011", "Queenstown",
"6435559", "Haast",
"6469711", "New\ Plymouth",
"6475625", "Rotorua",
"6472119", "Thames",
"6467778", "Wairoa",
"6435881", "Dunedin",
"6479009", "Hamilton",
"6432801", "Lumsden",
"643941", "Christchurch",
"6462411", "New\ Plymouth",
"6434221", "Invercargill",
"6432754", "Tokanui",
"6435693", "Nelson",
"647864", "Thames",
"6479045", "Taumarunui",
"6479501", "Opotiki",
"6439454", "Lumsden",
"6478142", "Whakatane",
"6499450", "Warkworth",
"64923", "Pukekohe",
"6439291", "Dunedin",
"6499069", "Pukekohe",
"6472123", "Morrinsville",
"646951", "Palmerston\ North",
"6439062", "Ashburton",
"644576", "Wellington",
"6472823", "Whakatane",
"644893", "Wellington",
"649408", "Kaitaia",
"6435995", "Darfield",
"6437450", "Westport",
"6436995", "Westport",
"6498820", "Whangarei",
"647970", "Hamilton",
"6432735", "Mt\ Cook",
"6499873", "Kaitaia",
"6439523", "Balclutha",
"6468888", "Masterton",
"6479293", "Hamilton",
"6434295", "Fox\ Glacier",
"643526", "Motueka",
"64376", "Greymouth",
"6462226", "Napier",
"6468881", "Napier\/Hastings",
"6472803", "Waihi",
"6437485", "Te\ Anau",
"6432655", "Nelson",
"6436620", "Kaikoura",
"6499044", "Hibiscus\ Coast",
"646845", "Napier\/Hastings",
"64698", "Gisborne",
"64456", "Wellington",
"6439040", "Balclutha",
"6465616", "Hawera",
"6473944", "Tauranga",
"6475827", "Hamilton",
"644904", "Paraparaumu",
"6468995", "Napier",
"6439298", "Motueka",
"6439018", "Ranfurly",
"6477886", "Rotorua",
"6434351", "Mt\ Cook",
"6479029", "Waihi",
"6467771", "New\ Plymouth",
"6433956", "Dunedin",
"644209", "Wellington",
"6435888", "Timaru",
"6472190", "Whakatane",
"6475605", "Huntly",
"6432808", "Westport",
"6462418", "Palmerston\ North",
"6432634", "Invercargill",
"6434228", "Tokanui",
"6462156", "Hawera",
"6437440", "Nelson",
"6436591", "Nelson",
"6463921", "Palmerston\ North",
"6432629", "Roxburgh",
"644393", "Paraparaumu",
"6463908", "Wairoa",
"6439085", "Waitangi\ \(Chatham\ Is\.\)",
"6469571", "Palmerston\ North",
"6434990", "Queenstown",
"6479422", "Tauranga",
"649420", "Helensville",
"6466006", "Opunake",
"6439855", "Rangiora",
"6424", "Scott\ Base",
"646654", "Gisborne",
"6494314", "Warkworth",
"6439737", "Tokanui",
"6498817", "Hibiscus\ Coast",
"6439345", "Christchurch",
"647987", "Tauranga",
"6439768", "Ranfurly",
"6432744", "Ranfurly",
"647865", "Whangamata",
"6436632", "Murchison",
"6432613", "Waitangi\ \(Chatham\ Is\.\)",
"649349", "Auckland",
"6436549", "Mt\ Cook",
"6435505", "Akaroa",
"6435549", "Hokitika",
"6436505", "Culverden",
"6497779", "Great\ Barrier\ Island",
"6435666", "Oamaru",
"6443", "Wellington",
"6493934", "Kaitaia",
"6478082", "Tauranga",
"6437772", "Timaru",
"6462122", "Palmerston\ North",
"6435990", "Hokitika",
"6433944", "Ashburton",
"643236", "Winton",
"6434287", "Queenstown",
"6439521", "Dunedin",
"6479298", "Taupo",
"6435532", "Motueka",
"6442420", "Wellington",
"6479018", "Putaruru\/Tokoroa",
"6432730", "Blenheim",
"6472821", "Hamilton",
"646848", "Napier\ City",
"6439029", "Tokanui",
"6436649", "Gore",
"6472808", "Putaruru\/Tokoroa",
"6498825", "Maungaturoto",
"6472121", "Te\ Kuiti",
"6436566", "Kurow",
"6436990", "Cheviot",
"6496994", "Dargaville",
"6437455", "Cheviot",
"643444", "Ranfurly",
"644219", "Wellington",
"6439293", "Blenheim",
"6473922", "Morrinsville",
"6475620", "Tauranga",
"6469312", "Ohakune",
"6435691", "Murchison",
"6499747", "Dargaville",
"6496016", "Warkworth",
"6449031", "Paraparaumu",
"6468247", "Mokau",
"643483", "Dunedin\/Lawrence\/Mosgiel",
"6435883", "Dunedin",
"6432803", "Otautau",
"6499455", "Dargaville",
"6492837", "Hibiscus\ Coast",
"6434223", "Otautau",
"6462413", "Gisborne",
"6433986", "Queenstown",
"644816", "Wellington",
"6479040", "Otorohanga",
"643267", "South\ Island",
"6439013", "Ashburton",
"6468807", "Gisborne",
"643413", "Balclutha",
"644886", "Wellington",
"6469713", "Stratford",
"6463903", "Ruatoria",
"6439055", "Fairlie",
"6472613", "Putaruru\/Tokoroa",
"6439289", "Akaroa",
"6498859", "Kaitaia",
"6432640", "Hokitika",
"6439097", "Darfield",
"6439336", "Cromwell",
"6498017", "Hibiscus\ Coast",
"6432999", "Invercargill",
"649404", "Kawakawa",
"643752", "Franz\ Josef",
"6439456", "Riverton",
"6473930", "Waihi",
"6439763", "Palmerston",
"6493209", "Great\ Barrier\ Island",
"6432756", "Gore",
"6477772", "Rotorua",
"6439885", "Fox\ Glacier",
"6469275", "Wanganui",
"6463990", "Featherston",
"6432618", "Culverden",
"6436520", "Greymouth",
"6472629", "Taupo",
"6432722", "Murchison",
"6495565", "Dargaville",
"6467529", "Mokau",
"647868", "Thames",
"6472147", "Paeroa",
"649459", "Whangarei",
"6468810", "Ohakune",
"6474649", "Matamata",
"646767", "New\ Plymouth\/Opunake\/Stratford",
"6439311", "Invercargill",
"649397", "Auckland\/Waiheke\ Island",
"6479855", "Taupo",
"6462144", "Ruatoria",
"6468307", "Napier\/Wairoa",
"6462169", "Featherston",
"6435500", "Christchurch",
"6468257", "Taihape",
"6462224", "Masterton",
"6439266", "Dunedin",
"647821", "Hamilton\/Huntly",
"6475617", "Whakatane",
"643445", "Cromwell",
"6499046", "Pukekohe",
"6432611", "Kaikoura",
"6465614", "Wanganui",
"6472609", "Whangamata",
"644908", "Paraparaumu",
"6439318", "Lumsden",
"6436500", "Christchurch",
"644650", "Wellington",
"6434995", "Te\ Anau",
"6492428", "Hibiscus\ Coast",
"6478139", "Whangamata",
"6479712", "Te\ Awamutu",
"6499728", "Dargaville",
"6473946", "Taupo",
"6436659", "Haast",
"6437445", "Fox\ Glacier",
"643750", "Haast",
"643339", "Christchurch",
"6473339", "Taupo",
"6433954", "Lawrence",
"6439340", "Mt\ Cook",
"6469573", "Palmerston\ North",
"643216", "Invercargill",
"6432636", "Te\ Anau",
"6432662", "Christchurch",
"6477884", "Tauranga",
"6436593", "Nelson",
"6463923", "Ohakune",
"644550", "Wellington",
"6439850", "Ashburton",
"6479845", "Paeroa",
"6467773", "Wanganui",
"6466004", "Waipukurau",
"6434272", "Alexandra",
"6468990", "Ruatoria",
"6468827", "New\ Plymouth",
"643937", "South\ Island",
"6462154", "New\ Plymouth",
"6434353", "Twizel",
"6436517", "Motueka",
"643240", "Tokanui\/Lumsden\/Te\ Anau",
"6435517", "Lawrence",
"6436589", "Otautau",
"6475600", "Hamilton",
"6479249", "Huntly",
"6472195", "Rotorua",
"6479109", "Opotiki",
"6474659", "Whangamata",
"6435698", "Hokitika",
"646211", "Napier",
"649405", "Kaikohe",
"6432819", "Christchurch",
"6472828", "Tauranga",
"647533", "Tauranga",
"6472801", "Huntly",
"6439009", "Greymouth",
"6434290", "Greymouth",
"6432746", "Alexandra",
"6472128", "Waihi",
"6499878", "Warkworth",
"6439045", "Twizel",
"6439528", "Lawrence",
"6468883", "Palmerston\ North",
"6436625", "Rangiora",
"6432650", "Christchurch",
"6493936", "Maungaturoto",
"6479291", "Hamilton",
"6439862", "Nelson",
"6437480", "Gore",
"6432887", "Nelson",
"6435664", "Timaru",
"6477882", "Hamilton",
"647245", "Hamilton",
"6432664", "Christchurch",
"6468243", "Napier",
"6432807", "Tokanui",
"6435887", "Invercargill",
"6492833", "Warkworth",
"6435650", "Greymouth",
"6462417", "Wanganui",
"6434227", "Riverton",
"6439349", "South\ Island",
"6439017", "Cromwell",
"6468803", "Gisborne",
"6433952", "Fairlie",
"6439859", "Christchurch\/Blenheim\/Nelson",
"649424", "Hibiscus\ Coast",
"6498690", "Kawakawa",
"6478130", "Morrinsville",
"646842", "Napier\/Hastings",
"6439297", "Takaka",
"647927", "Tauranga",
"6436650", "Otautau",
"646650", "Napier",
"6432625", "Twizel",
"6475828", "Hamilton",
"6479714", "Huntly",
"643978", "Christchurch",
"6472600", "Hamilton",
"649451", "Auckland",
"6435545", "Gore",
"6436509", "Waitangi\ \(Chatham\ Is\.\)",
"6497775", "Helensville",
"643248", "Lumsden",
"6465612", "Waipukurau",
"6462160", "Masterton",
"6435509", "Culverden",
"643523", "Murchison",
"6434283", "Cromwell",
"6462222", "Ohakune",
"644250", "Wellington",
"6439864", "Takaka",
"6435662", "Geraldine",
"6432659", "Takaka",
"6437776", "Cromwell",
"6478086", "Hamilton",
"6437489", "South\ Island",
"6462126", "Pahiatua",
"643758", "Hokitika\/Franz\ Josef\ Glacier\/Fox\ Glacier\/Haast",
"6432810", "Franz\ Josef",
"6436636", "Waimate",
"6472143", "Morrinsville",
"6499004", "Hibiscus\ Coast",
"6434299", "Haast",
"6439000", "Christchurch",
"6436580", "Invercargill",
"6439738", "Winton",
"644211", "Wellington",
"6439767", "Alexandra",
"6479240", "Taupo",
"6475609", "Paeroa",
"6479100", "Rotorua",
"6462614", "Wairoa",
"6474650", "Morrinsville",
"6479025", "Huntly",
"647862", "Paeroa",
"644281", "Wellington",
"64943", "Whangarei",
"6436611", "Rangiora",
"6434241", "Rangiora",
"6462152", "New\ Plymouth",
"6478071", "Otorohanga",
"6463907", "Waipukurau",
"6468999", "Napier",
"6439093", "Ashburton",
"649958", "Helensville",
"6434274", "Kurow",
"6466002", "Napier",
"6432221", "Nelson",
"6436618", "Blenheim",
"6434248", "Cheviot",
"6437466", "Cromwell",
"6478078", "Whangamata",
"6469577", "Ohakune",
"6479049", "Te\ Kuiti",
"6436597", "Cromwell",
"6432228", "Wanaka",
"6463927", "Dannevirke",
"647557", "Tauranga",
"6439731", "Gore",
"6469314", "Waiouru",
"6472115", "Taumarunui",
"6479005", "Tauranga",
"647860", "Paeroa\/Waihi\/Thames\/Whangamata",
"6493991", "Pukekohe",
"644902", "Paraparaumu",
"6472815", "Whakatane",
"6473924", "Paeroa",
"6435555", "Timaru",
"64634", "Wanganui",
"6442429", "Paraparaumu",
"6472223", "Hamilton",
"6432739", "Balclutha",
"6439020", "Gore",
"6496992", "Kawakawa",
"647213", "Hamilton",
"6436640", "Palmerston",
"6499466", "Kaikohe",
"6462420", "Palmerston\ North",
"6469296", "Levin",
"647949", "Hamilton",
"6436999", "Nelson",
"6469016", "Ohakune",
"6468253", "Marton",
"6435999", "Christchurch",
"6462106", "Pahiatua",
"64335", "Christchurch",
"6495530", "Great\ Barrier\ Island",
"6435534", "Takaka",
"647876", "Te\ Kuiti",
"6475613", "Te\ Awamutu",
"6439716", "Geraldine",
"6433942", "Akaroa",
"647974", "Hamilton",
"6462806", "Napier\/Hastings",
"649425", "Warkworth",
"6499065", "Helensville",
"644619", "Wellington",
"6468887", "Gisborne",
"647829", "Hamilton",
"6435529", "Roxburgh",
"644896", "Wellington",
"6436529", "Westport",
"646969", "New\ Plymouth",
"6463999", "Palmerston\ North",
"644589", "Wellington",
"6499420", "Pukekohe",
"6472620", "Tauranga",
"64948", "Auckland",
"6439066", "Hokitika",
"6468819", "Mokau",
"6443990", "Paraparaumu",
"643667", "Christchurch",
"6432724", "Greymouth",
"64941", "Auckland",
"6435513", "Waitangi\ \(Chatham\ Is\.\)",
"6477774", "Thames",
"64736", "Rotorua",
"64364", "South\ Island",
"6439325", "Kaikoura",
"6435685", "Tokanui",
"6475821", "Hamilton",
"646840", "Napier\ City",
"64937", "Auckland",
"643331", "Christchurch",
"6467777", "Napier",
"6468823", "Napier\/Hastings",
"6439280", "Nelson",
"6463941", "Masterton",
"6436685", "Nelson",
"6432649", "Waimate",
"6498850", "Great\ Barrier\ Island",
"6432990", "Lumsden",
"64354", "Nelson",
"643457", "Dunedin",
"643396", "South\ Island",
"6478083", "Hamilton",
"643468", "Dunedin",
"6437773", "Dunedin",
"6462123", "Palmerston\ North",
"643211", "Invercargill",
"6436633", "Geraldine",
"6432612", "Rangiora",
"6472146", "Otorohanga",
"643539", "Nelson",
"6432728", "Haast",
"6462119", "Wairoa",
"6439457", "Winton",
"6477778", "Te\ Awamutu",
"6469009", "Palmerston\ North",
"647980", "Hamilton",
"647826", "Huntly",
"6439709", "Motueka",
"6462819", "Levin",
"646365", "Palmerston\ North",
"6432757", "Lumsden",
"6479711", "Whangamata",
"6465625", "Gisborne",
"646966", "Wanganui\/New\ Plymouth",
"644586", "Wellington",
"6432661", "Christchurch",
"643250", "Christchurch",
"6432445", "Greymouth",
"649427", "Hibiscus\ Coast",
"6439745", "Greymouth",
"6439337", "Wanaka",
"6439096", "Ashburton",
"6498016", "Hibiscus\ Coast",
"646864", "Ruatoria",
"6469045", "Waipukurau",
"6436614", "Timaru",
"6434244", "Amberley",
"6468246", "Hawera",
"6478074", "Taumarunui",
"6492836", "Kaitaia",
"6479750", "Tauranga",
"6433987", "Cromwell",
"6468806", "New\ Plymouth",
"64793", "Tauranga",
"6434271", "Balclutha",
"6432224", "Invercargill",
"643740", "Christchurch",
"647883", "Putaruru\/Tokoroa",
"647879", "Te\ Awamutu\/Otorohanga\/Te\ Kuiti",
"6469318", "Levin",
"6499819", "Helensville",
"6462611", "Napier",
"6433919", "Haast",
"6446509", "Paraparaumu",
"6492009", "Pukekohe",
"6473928", "Te\ Awamutu",
"6499746", "Kawakawa",
"6496017", "Great\ Barrier\ Island",
"6472802", "Paeroa",
"646750", "Mokau",
"6473995", "Putaruru\/Tokoroa",
"6469619", "Wanganui\/New\ Plymouth",
"6436567", "Ranfurly",
"643455", "Dunedin",
"6439861", "Nelson",
"6479292", "Hamilton",
"6469850", "Napier",
"6434286", "Christchurch",
"6435538", "Lumsden",
"64932", "Auckland\/Waiheke\ Island",
"6466015", "Napier",
"6439879", "Christchurch\/Blenheim\/Nelson",
"6469289", "Taihape",
"6439868", "Blenheim",
"6435531", "Nelson",
"6442127", "Paraparaumu",
"6439755", "Rangiora",
"6435670", "Palmerston",
"6439522", "Dunedin",
"6493937", "Warkworth",
"6444", "Wellington",
"647464", "Hamilton",
"6472122", "Te\ Awamutu",
"6439275", "Nelson",
"647925", "Tauranga",
"6499008", "Pukekohe",
"6432747", "Queenstown",
"6439063", "Westport",
"6472822", "Rotorua",
"6498814", "Pukekohe",
"6439734", "Edendale",
"6435516", "Balclutha",
"643231", "Invercargill",
"6435692", "Takaka",
"6469311", "Palmerston\ North",
"649320", "Auckland",
"6466520", "Palmerston\ North",
"6478143", "Opotiki",
"6462618", "Masterton",
"6433990", "South\ Island",
"6473921", "Matamata",
"643742", "Dunedin",
"64675", "New\ Plymouth",
"6468826", "Levin",
"6434269", "Twizel",
"6434278", "Roxburgh",
"643689", "Waimate",
"6495588", "Hibiscus\ Coast",
"64697", "Napier",
"6434405", "Alexandra",
"6432668", "Blenheim",
"643454", "Dunedin",
"6478995", "Matamata",
"6437463", "Mt\ Cook",
"6432637", "Winton",
"6443708", "Paraparaumu",
"6463944", "Featherston",
"6469200", "Gisborne",
"6477771", "Whakatane",
"6432429", "Timaru",
"6465605", "Marton",
"6499555", "Kawakawa",
"6466990", "Mokau",
"6439729", "Fox\ Glacier",
"6496515", "Dargaville",
"6442199", "Paraparaumu",
"6475824", "Hamilton",
"6434235", "Akaroa",
"6473947", "Whakatane",
"647982", "Hamilton",
"6479718", "Taumarunui",
"6469029", "Opunake",
"64325", "South\ Island",
"6499047", "Pukekohe",
"6472130", "Tauranga",
"644203", "Wellington",
"6472226", "Te\ Kuiti",
"643421", "Christchurch",
"6439312", "Riverton",
"6499463", "Whangarei",
"6432721", "Motueka",
"6469293", "New\ Plymouth",
"6462103", "Levin",
"6468256", "Palmerston\ North",
"6468306", "Napier\/Wairoa",
"6439267", "Dunedin",
"6475616", "Whangamata",
"6439713", "Mt\ Cook",
"6462803", "Palmerston\ North",
"643409", "Queenstown",
"6439530", "Timaru",
"6463906", "Napier",
"6499295", "Kaikohe",
"6466008", "Ohakune",
"6444888", "Paraparaumu",
"6439333", "Franz\ Josef",
"6434260", "Oamaru",
"643462", "Dunedin\/Palmerston",
"6472616", "Taumarunui",
"6462158", "Opunake",
"6439453", "Te\ Anau",
"647871", "Te\ Awamutu",
"6439766", "Balclutha",
"6433999", "Otautau",
"6439732", "Otautau",
"6466529", "Pahiatua",
"6432753", "Winton",
"6435694", "Franz\ Josef",
"6478128", "Huntly",
"6499015", "Dargaville",
"643447", "Alexandra",
"64930", "Auckland",
"6436637", "Twizel",
"6472124", "Matamata",
"6462605", "Marton",
"6496991", "Kaikohe",
"6439870", "Queenstown",
"6469280", "Waipukurau",
"6433941", "Blenheim",
"6499874", "Kawakawa",
"643552", "Dunedin",
"6439524", "Oamaru",
"6435679", "Alexandra",
"6437777", "Christchurch",
"6462127", "Dannevirke",
"6435668", "Kurow",
"643984", "Blenheim",
"6435563", "Queenstown",
"6462228", "Wanganui",
"6466555", "Hawera",
"643920", "Rangiora",
"643935", "South\ Island",
"6439539", "Dunedin\/Timaru",
"649394", "Auckland",
"646764", "Stratford",
"643943", "Christchurch",
"643336", "Christchurch",
"6474637", "Opotiki",
"64334", "Christchurch",
"643219", "Invercargill",
"6465618", "Masterton",
"6496508", "Hibiscus\ Coast",
"6439314", "Winton",
"6436563", "Lawrence",
"6432420", "Christchurch",
"6466999", "New\ Plymouth",
"6432715", "Culverden",
"6439296", "Invercargill",
"6439720", "Blenheim",
"6469020", "Stratford",
"649407", "Kaikohe",
"6496013", "Whangarei",
"6432806", "Edendale",
"6435886", "Invercargill",
"6433958", "Oamaru",
"644891", "Wellington",
"6463942", "Masterton",
"6433983", "Ranfurly",
"6462416", "Waipukurau",
"6434226", "Lumsden",
"6477888", "Taupo",
"646953", "Palmerston\ North\ W100",
"6439016", "Alexandra",
"6469716", "Opunake",
"64635", "Palmerston\ North",
"6467776", "Levin",
"6433951", "Timaru",
"6477881", "Hamilton",
"6469000", "New\ Plymouth",
"6494313", "Warkworth",
"6437475", "Palmerston",
"6439700", "Nelson",
"6462810", "Gisborne",
"644240", "Wellington",
"6432614", "South\ Island",
"6474445", "Hamilton",
"6465611", "Napier",
"6432743", "Kurow",
"6439067", "Franz\ Josef",
"6468886", "Wanganui",
"643922", "Nelson",
"6462221", "Gisborne",
"6499475", "Hibiscus\ Coast",
"6493933", "Kaikohe",
"6496009", "Pukekohe",
"6433948", "Kaikoura",
"6462107", "Dannevirke",
"6469017", "Marton",
"6439717", "Fairlie",
"6439075", "Takaka",
"6462807", "Napier\/Hastings",
"6479294", "Hamilton",
"6435661", "Fairlie",
"6499043", "Hibiscus\ Coast",
"6469305", "New\ Plymouth",
"6462625", "Hawera",
"6479014", "Matamata",
"6478090", "Thames",
"644819", "Wellington",
"6472804", "Whangamata",
"6499467", "Kaitaia",
"64685", "Waipukurau",
"6469297", "Masterton",
"647988", "Rotorua",
"644889", "Wellington",
"6496998", "Helensville",
"6469610", "Wanganui",
"646765", "Stratford",
"643239", "Invercargill",
"6499810", "Hibiscus\ Coast",
"6466509", "Napier\/Waipukurau",
"643908", "Ashburton",
"6433910", "Nelson",
"6437467", "Queenstown",
"6466001", "Napier",
"6432633", "Otautau",
"6469576", "Dannevirke",
"6432222", "Christchurch",
"643460", "Dunedin\/Palmerston",
"6434242", "Darfield",
"6436612", "Akaroa",
"6478072", "Paeroa",
"6462151", "New\ Plymouth",
"649395", "Auckland\/Waiheke\ Island",
"6463926", "Taihape",
"6472459", "Rotorua",
"6492229", "Hibiscus\ Coast",
"6436596", "Queenstown",
"643410", "Balclutha\/Milton",
"6439342", "Geraldine",
"6479026", "Paeroa",
"6465623", "Opunake",
"6477889", "Whakatane",
"6499017", "Kaikohe",
"643480", "Dunedin\/Lawrence\/Mosgiel",
"6439852", "Cheviot",
"6433959", "Balclutha",
"6492807", "Helensville",
"6432660", "Christchurch",
"6439082", "Culverden",
"6479710", "Putaruru\/Tokoroa",
"6439743", "Christchurch",
"6436654", "Tokanui",
"649406", "Kaitaia",
"6432443", "Christchurch",
"6499297", "Hibiscus\ Coast",
"6478134", "Taumarunui",
"6466998", "New\ Plymouth",
"6437775", "Wanaka",
"6496509", "Pukekohe",
"6478085", "Tauranga",
"643451", "Queenstown",
"6472604", "Hamilton",
"6462125", "Taihape",
"6465619", "Masterton",
"6436502", "Amberley",
"643337", "Christchurch",
"6463914", "Stratford",
"6439538", "Dunedin\/Timaru",
"6462607", "Taihape",
"6435502", "Christchurch",
"6479748", "Taumarunui",
"6462164", "New\ Plymouth",
"6436635", "Fairlie",
"6435669", "Wanaka",
"643215", "Invercargill",
"643234", "Riverton",
"6435546", "Greymouth",
"6497776", "Hibiscus\ Coast",
"6435678", "Roxburgh",
"6469851", "Napier",
"6439860", "Nelson",
"6437482", "Lumsden",
"647551", "Tauranga",
"6473993", "Te\ Awamutu",
"6432652", "Cromwell",
"6466557", "Stratford",
"6439004", "Gore",
"6436546", "Fairlie",
"643595", "Christchurch",
"6432814", "Mt\ Cook",
"643939", "South\ Island",
"6434292", "Hokitika",
"64343", "Oamaru",
"6475602", "Hamilton",
"6478129", "Matamata",
"6462610", "Napier",
"6466528", "Dannevirke",
"6474654", "Taumarunui",
"643446", "Roxburgh",
"6433998", "Lumsden",
"6479244", "Tauranga",
"6436584", "Winton",
"647218", "Tauranga",
"6468992", "Wairoa",
"6434270", "Oamaru",
"6432626", "Kurow",
"6462159", "Mokau",
"643958", "Dunedin\/Timaru",
"6444889", "Paraparaumu",
"6466009", "Waiouru",
"6469247", "Wanganui",
"6479751", "Tauranga",
"6432717", "Kaikoura",
"6472458", "Rotorua",
"6492228", "Warkworth",
"6437477", "Roxburgh",
"6432606", "Dunedin",
"6435686", "Gore",
"6439326", "Rangiora",
"6436686", "Invercargill",
"6473920", "Huntly",
"6466521", "Palmerston\ North",
"6433991", "Invercargill",
"6443333", "Paraparaumu",
"643753", "Hokitika",
"6466508", "Napier\/Wairoa",
"6469310", "Wanganui",
"6475622", "Tauranga",
"64360", "South\ Island",
"6439753", "Amberley",
"6432732", "Fairlie",
"6499477", "Pukekohe",
"643269", "South\ Island",
"6436644", "Alexandra",
"6462424", "Wanganui",
"6436992", "Greymouth",
"6466013", "Featherston",
"6439024", "Lumsden",
"6439065", "Ashburton",
"643430", "Mt\ Cook",
"643425", "Dunedin",
"6435992", "Fox\ Glacier",
"6472427", "Rotorua",
"6435671", "Oamaru",
"6493942", "Great\ Barrier\ Island",
"6499716", "Helensville",
"6474447", "Te\ Kuiti",
"6435530", "Nelson",
"64935", "Auckland",
"6439273", "Blenheim",
"6433949", "Rangiora",
"6496008", "Hibiscus\ Coast",
"644815", "Wellington",
"644834", "Paraparaumu",
"6499465", "Dargaville",
"6439531", "Timaru",
"6469295", "Wanganui",
"6462149", "Ruatoria",
"6469307", "Stratford",
"6462627", "Wanganui",
"647921", "Rotorua",
"6432720", "Nelson",
"6439077", "Ashburton",
"6462805", "Napier\/Hastings",
"6463992", "Levin",
"6436522", "Greymouth",
"6499066", "Helensville",
"6472131", "Rotorua",
"64348", "Dunedin",
"6472624", "Whakatane",
"6462105", "Taihape",
"6439715", "Timaru",
"6468812", "Waiouru",
"64630", "Featherston",
"6473932", "Rotorua",
"64337", "Christchurch",
"646903", "Palmerston\ North",
"643989", "Nelson",
"6449008", "Paraparaumu",
"649399", "Auckland",
"643243", "Tokanui\/Lumsden\/Te\ Anau",
"6478993", "Waihi",
"6437465", "Waimate",
"6466991", "Wanganui",
"6434403", "Queenstown\/Cromwell\/Alexandra\/Wanaka\/Ranfurly\/Roxburgh",
"6477770", "Tauranga",
"6434233", "Rangiora",
"643235", "Invercargill",
"6469201", "Ruatoria",
"6496513", "Whangarei",
"643528", "Motueka",
"643214", "Invercargill",
"6432994", "Otautau",
"6472816", "Morrinsville",
"646769", "New\ Plymouth",
"6435556", "Fairlie",
"6439284", "Blenheim",
"6498854", "Hibiscus\ Coast",
"6465603", "Palmerston\ North",
"6432642", "Fox\ Glacier",
"6472116", "Thames",
"643412", "Balclutha",
"6499553", "Kaikohe",
"6495532", "Warkworth",
"6462603", "Palmerston\ North",
"6435539", "Otautau",
"6439871", "Queenstown",
"6435994", "Ashburton",
"6469281", "Wairoa",
"64796", "Hamilton",
"643520", "Blenheim",
"6433940", "Westport",
"6495566", "Kaikohe",
"6493944", "Hibiscus\ Coast",
"6436994", "Murchison",
"6439022", "Ashburton",
"6496990", "Kaitaia",
"6469618", "Wanganui\/New\ Plymouth",
"644572", "Wellington",
"6436577", "Cromwell",
"6432734", "Waimate",
"6479856", "Tauranga",
"6462422", "Napier\/Hastings",
"6436642", "Milton",
"6473929", "Thames",
"646653", "Wanganui",
"6439747", "Wanaka",
"6439335", "Haast",
"6492008", "Hibiscus\ Coast",
"6475624", "Rotorua",
"644895", "Paraparaumu",
"6433918", "Fox\ Glacier",
"6499818", "Great\ Barrier\ Island",
"6432447", "Timaru",
"6469319", "Masterton",
"64377", "South\ Island",
"6432755", "Edendale",
"6439886", "Christchurch\/Blenheim\/Nelson",
"6434261", "Balclutha",
"6469276", "Wanganui",
"6465627", "Levin",
"64349", "South\ Island",
"6499013", "Kawakawa",
"6439455", "Otautau",
"643669", "Christchurch",
"647875", "Te\ Awamutu\/Otorohanga\/Te\ Kuiti",
"6496015", "Maungaturoto",
"6468263", "Napier",
"6432644", "Westport",
"644587", "Wellington",
"646967", "New\ Plymouth",
"6469243", "New\ Plymouth",
"649426", "Hibiscus\ Coast",
"6432992", "Gore",
"6498852", "Warkworth",
"643438", "Kurow",
"6432713", "Ashburton",
"6439282", "Christchurch",
"6462818", "New\ Plymouth",
"6439721", "Blenheim",
"6473934", "Rotorua",
"6439708", "Murchison",
"6499456", "Kaikohe",
"647827", "Hamilton",
"6469008", "Palmerston\ North",
"6432421", "Tokanui\/Lumsden\/Te\ Anau",
"6433985", "Alexandra",
"6467556", "New\ Plymouth\/Mokau",
"6462118", "Waipukurau",
"6477779", "Putaruru\/Tokoroa",
"6499422", "Helensville",
"6432729", "Westport",
"6466553", "New\ Plymouth",
"6472622", "Tauranga",
"643459", "Dunedin\/Queenstown",
"6468814", "Dannevirke",
"646320", "Palmerston\ North\/Marton",
"6463994", "Dannevirke",
"6436524", "Hokitika",
"64694", "Masterton\/Levin",
"6498826", "Warkworth",
"6436565", "Twizel",
"6437456", "Culverden",
"64627", "Hawera",
"6473997", "Te\ Kuiti",
"643397", "South\ Island",
"64320", "Gore",
"6432745", "Roxburgh",
"6462162", "Masterton",
"6474443", "Matamata",
"647590", "Hamilton",
"6462220", "New\ Plymouth",
"643950", "Dunedin",
"6439277", "Invercargill",
"6435504", "Christchurch",
"6499473", "Helensville",
"646322", "Marton",
"6439757", "Waitangi\ \(Chatham\ Is\.\)",
"647210", "Hamilton",
"6436626", "Akaroa",
"6436504", "Cheviot",
"644894", "Wellington",
"6493935", "Kawakawa",
"6463912", "New\ Plymouth",
"646869", "Gisborne\/Ruatoria",
"6465610", "Napier",
"6466017", "Napier",
"6439046", "Kurow",
"6442125", "Paraparaumu",
"6472602", "Hamilton",
"6479719", "Te\ Kuiti",
"6478132", "Paeroa",
"6442198", "Paraparaumu",
"6462811", "New\ Plymouth",
"6439728", "Franz\ Josef",
"643981", "Christchurch",
"6479846", "Taumarunui",
"6439084", "Amberley",
"649391", "Auckland",
"643685", "Fairlie",
"6439701", "Nelson",
"6436652", "Winton",
"6469001", "New\ Plymouth",
"6432428", "Queenstown",
"647863", "Waihi",
"6439854", "Waitangi\ \(Chatham\ Is\.\)",
"6477880", "Hamilton",
"6473332", "Rotorua",
"646761", "Opunake",
"6439344", "Timaru",
"6443709", "Paraparaumu",
"6494315", "Warkworth",
"6437473", "Milton",
"6472196", "Taupo",
"64632", "Palmerston\ North",
"6433950", "Waitangi\ \(Chatham\ Is\.\)",
"6432669", "Rangiora",
"6434237", "Culverden",
"6495589", "Pukekohe",
"6473945", "Tauranga",
"64362", "South\ Island",
"6496517", "Kaitaia",
"6434279", "Twizel",
"6437446", "Franz\ Josef",
"6434268", "Roxburgh",
"6462150", "New\ Plymouth",
"6466000", "Napier",
"6468994", "Waipukurau",
"6465607", "Taihape",
"6434996", "Roxburgh",
"6499557", "Warkworth",
"6479102", "Rotorua",
"646843", "Napier\/Hastings",
"6479242", "Rotorua",
"644666", "Wellington",
"6436582", "Riverton",
"646385", "Ohakune",
"6462619", "Featherston",
"6433911", "Nelson",
"6478997", "Morrinsville",
"6475604", "Hamilton",
"6499811", "Hibiscus\ Coast",
"6434407", "Queenstown\/Cromwell\/Alexandra\/Wanaka\/Ranfurly\/Roxburgh",
"6432635", "Riverton",
"6465950", "Palmerston\ North",
"6474652", "Paeroa",
"6469611", "Wanganui",
"6439073", "Motueka",
"6432812", "Haast",
"6434294", "Franz\ Josef",
"6478091", "Matamata",
"6439002", "Rangiora",
"644570", "Wellington",
"6437484", "Riverton",
"643522", "Nelson",
"647874", "Te\ Awamutu\/Otorohanga\/Te\ Kuiti",
"6435660", "Haast",
"6432654", "Blenheim",
"6462623", "Stratford",
"6439869", "Blenheim",
"6469303", "Waipukurau",
"6499045", "Hibiscus\ Coast",
"6439878", "Christchurch\/Blenheim\/Nelson",
"64480", "Wellington",
"6469288", "Waiouru",
"643418", "Balclutha",
"64783", "Hamilton",
"6432627", "Alexandra",
"6434264", "Kurow",
"6468998", "Napier",
"6469246", "Palmerston\ North",
"6432716", "Darfield",
"6439295", "Nelson",
"6435690", "Motueka",
"6439015", "Wanaka",
"6449030", "Paraparaumu",
"64731", "Whakatane\/Opotiki",
"6475621", "Tauranga",
"6469715", "Mokau",
"6432805", "Winton",
"6475608", "Otorohanga",
"6435885", "Invercargill",
"647983", "Hamilton",
"64738", "Taupo",
"6439739", "Invercargill",
"6466522", "Palmerston\ North",
"6434225", "Edendale",
"6433992", "Riverton",
"6499453", "Warkworth",
"6472120", "Putaruru\/Tokoroa",
"6466556", "Stratford",
"649652", "Warkworth",
"6436991", "Culverden",
"644202", "Wellington",
"6434298", "Hokitika",
"6472820", "Hamilton",
"6432731", "Timaru",
"64330", "Ashburton\/Akaroa\/Chatham\ Islands",
"6436547", "Geraldine",
"643903", "Christchurch",
"64637", "Masterton",
"6498823", "Kaitaia",
"6437488", "South\ Island",
"6497777", "Auckland",
"6437453", "Amberley",
"6432658", "Murchison",
"6435547", "Blenheim",
"646214", "Gisborne",
"647312", "Whakatane",
"6439520", "Dunedin",
"6439874", "Cromwell",
"649552", "Pukekohe",
"6435991", "Franz\ Josef",
"6469284", "Stratford",
"6435672", "Balclutha",
"6462606", "Waiouru",
"646837", "Wairoa",
"6439532", "Timaru",
"6495563", "Whangarei",
"64357", "Blenheim",
"6435508", "Cheviot",
"6472132", "Taupo",
"6439310", "Invercargill",
"64367", "South\ Island",
"6436508", "Rangiora",
"6468811", "Marton",
"6479853", "Putaruru",
"646387", "Waiouru",
"64934", "Auckland\/Waiheke\ Island",
"6463991", "Masterton",
"6436521", "Greymouth",
"647824", "Hamilton",
"6472615", "Te\ Kuiti",
"6466992", "Hawera",
"6475829", "Hamilton",
"6439724", "Blenheim",
"6463905", "Napier",
"647880", "Matamata",
"6499296", "Kaitaia",
"6473931", "Whangamata",
"6432424", "Nelson",
"647926", "Tauranga",
"6479027", "Paeroa",
"6439858", "Kaikoura",
"646964", "Wanganui",
"6432641", "Franz\ Josef",
"6499016", "Kaikohe",
"6469273", "New\ Plymouth",
"6439883", "Hokitika",
"647325", "Opotiki",
"643743", "Christchurch",
"6439348", "South\ Island",
"646866", "Gisborne\/Ruatoria",
"6469202", "Levin",
"6439765", "Milton",
"6439851", "Culverden",
"6435557", "Geraldine",
"6432648", "Geraldine",
"6437443", "Nelson",
"643456", "Dunedin",
"6472817", "Taupo",
"6439341", "Fairlie",
"647332", "Rotorua",
"6434993", "Alexandra",
"64687", "Napier\/Hastings",
"6479007", "Whakatane",
"647882", "Putaruru\/Tokoroa",
"6463925", "Waiouru",
"643948", "Invercargill",
"6462814", "Hawera",
"6436595", "Mt\ Cook",
"6439704", "Murchison",
"6469004", "Napier\/Hastings",
"647812", "Hamilton",
"6462114", "Waipukurau",
"643278", "South\ Island",
"6469575", "Waiouru",
"6439076", "Ashburton",
"6436501", "Akaroa",
"643666", "Christchurch",
"64733", "Rotorua\/Taupo",
"6499067", "Pukekohe",
"6468818", "Opunake",
"644897", "Wellington",
"649429", "Great\ Barrier\ Island",
"64452", "Wellington",
"6463998", "Palmerston\ North",
"6436528", "Westport",
"6432610", "Darfield",
"6435528", "Ranfurly",
"649401", "Kaikohe",
"6469306", "Hawera",
"6462626", "Mokau",
"64372", "South\ Island",
"646958", "Palmerston\ North\/New\ Plymouth",
"6435501", "Christchurch",
"6469852", "Napier",
"6479290", "Hamilton",
"6437481", "Invercargill",
"643441", "Queenstown",
"6432651", "Queenstown",
"646965", "Wanganui\ W100",
"6474446", "Otorohanga",
"6499717", "Whangarei",
"6435998", "Rangiora",
"647877", "Te\ Kuiti",
"647466", "Tauranga",
"6436998", "Blenheim",
"6436623", "Amberley",
"6469614", "Levin",
"647825", "Hamilton",
"6472800", "Thames",
"6434291", "Westport",
"6478094", "Tauranga",
"6432738", "Oamaru",
"6468885", "New\ Plymouth",
"6479010", "Thames",
"6439043", "Ashburton",
"6436687", "Nelson",
"6475628", "Tauranga",
"6433914", "Takaka",
"6475601", "Hamilton",
"6467775", "Palmerston\ North",
"6479843", "Morrinsville",
"6432229", "Dunedin",
"6479752", "Rotorua",
"6437476", "Ranfurly",
"6468991", "Gisborne",
"6432607", "Dunedin",
"6439327", "Ashburton",
"6478079", "Hamilton",
"6435687", "Lumsden",
"6436619", "Cheviot",
"6472193", "Whakatane",
"6434249", "Kaikoura",
"6437457", "Darfield",
"6497773", "Dargaville",
"6435543", "Tokanui",
"649396", "Auckland\/Waiheke\ Island",
"6462161", "Masterton",
"6473996", "Otorohanga",
"6474648", "Huntly",
"646766", "New\ Plymouth",
"643334", "Christchurch",
"6472601", "Hamilton",
"6499428", "Warkworth",
"6472628", "Taupo",
"6463911", "New\ Plymouth",
"6432619", "Christchurch",
"6434285", "Cheviot",
"6439702", "Nelson",
"6468805", "Wanganui",
"647390", "Hamilton",
"6436651", "Riverton",
"6469002", "Hawera",
"6478131", "Otorohanga",
"6493208", "Helensville",
"644595", "Wellington",
"6468245", "Wairoa",
"6498691", "Maungaturoto",
"6499457", "Kaitaia",
"6492835", "Kaikohe",
"6462812", "Napier\/Hastings",
"6469869", "Ruatoria",
"6432623", "Lawrence",
"6432998", "Tokanui",
"6498883", "Whangarei",
"6439288", "Ashburton",
"6498858", "Kaikohe",
"6473331", "Rotorua",
"646950", "Palmerston\ North\/New\ Plymouth",
"6432220", "Dunedin",
"6439887", "Christchurch\/Blenheim\/Nelson",
"644887", "Wellington",
"6469277", "Gisborne",
"6465626", "Ruatoria",
"6479754", "Tauranga",
"6436610", "Kaikoura",
"6434240", "Ashburton",
"644817", "Wellington",
"6478070", "Morrinsville",
"6439746", "Dunedin",
"6439095", "Ashburton",
"6474651", "Otorohanga",
"64789", "Taumarunui",
"6479241", "Whakatane",
"6479101", "Rotorua",
"6432446", "Blenheim",
"6436581", "Invercargill",
"6439057", "Waimate",
"6433912", "Motueka",
"6478092", "Huntly",
"643270", "Christchurch",
"6436576", "Cromwell",
"6436648", "Lumsden",
"6472809", "Otorohanga",
"6439001", "Christchurch",
"6479857", "Opotiki",
"643940", "Christchurch",
"6469612", "Wanganui\/New\ Plymouth",
"6439028", "Edendale",
"6479019", "Whangamata",
"6432811", "Fox\ Glacier",
"643923", "Nelson",
"6472145", "Huntly",
"6479299", "Rotorua",
"649348", "Auckland",
"64332", "Christchurch",
"6469854", "Waipukurau",
"6495567", "Kaitaia",
"643237", "Riverton\/Winton",
"6469282", "Mokau",
"6439872", "Alexandra",
"643449", "Alexandra",
"6435674", "Milton",
"6495531", "Helensville",
"6439529", "Palmerston",
"6499879", "Warkworth",
"6472225", "Rotorua",
"6472129", "Whangamata",
"6499063", "Hibiscus\ Coast",
"6436641", "Lawrence",
"647888", "Matamata",
"643942", "Christchurch",
"6439008", "Timaru",
"6462421", "New\ Plymouth",
"6468255", "Pahiatua",
"6472829", "Tauranga",
"6439021", "Ashburton",
"6468305", "Napier\/Wairoa",
"6475615", "Waihi",
"6432818", "Christchurch",
"6435699", "Amberley",
"6466524", "Ohakune",
"643335", "Christchurch",
"6493990", "Great\ Barrier\ Island",
"6433994", "Winton",
"6474658", "Waihi",
"6434406", "Queenstown\/Cromwell\/Alexandra\/Wanaka\/Ranfurly\/Roxburgh",
"6478996", "Huntly",
"6479248", "Rotorua\/Whakatane\/Tauranga",
"6479108", "Whakatane",
"6436588", "Lumsden",
"6439730", "Invercargill",
"6496516", "Kaikohe",
"6434236", "Amberley",
"6435553", "Wanaka",
"6472813", "Waihi",
"6437447", "Greymouth",
"6434997", "Lawrence",
"6465606", "Waiouru",
"6499556", "Maungaturoto",
"6479003", "Thames",
"6434262", "Alexandra",
"646952", "Palmerston\ North\ W100",
"643936", "South\ Island",
"6432991", "Milton",
"6463940", "Levin",
"6439281", "Christchurch",
"6498851", "Pukekohe",
"6435515", "Oamaru",
"6473338", "Rotorua",
"6439323", "Cheviot",
"6435683", "Te\ Anau",
"6472197", "Tauranga",
"643217", "Invercargill",
"643463", "Palmerston",
"6436683", "Rangiora",
"6436658", "Fox\ Glacier",
"6432422", "Tokanui\/Lumsden\/Te\ Anau",
"6475820", "Hamilton",
"6478138", "Waihi",
"6469022", "Hawera",
"6479847", "Te\ Awamutu",
"6466994", "Ohakune",
"6492429", "Pukekohe",
"6439722", "Blenheim",
"6468825", "Gisborne",
"6439319", "Otautau",
"64370", "South\ Island",
"6439756", "Akaroa",
"6436627", "Waitangi\ \(Chatham\ Is\.\)",
"649902", "Warkworth",
"6472608", "Waihi",
"6499421", "Hibiscus\ Coast",
"649421", "Hibiscus\ Coast",
"6466016", "Napier",
"643653", "Blenheim",
"6472621", "Tauranga",
"6463918", "Wanganui",
"6439047", "Alexandra",
"6439534", "Mt\ Cook",
"649409", "Kaitaia",
"6462137", "Palmerston\ North",
"6462168", "Featherston",
"6439276", "Nelson",};

    sub new {
      my $class = shift;
      my $number = shift;
      $number =~ s/(^\+64|\D)//g;
      my $self = bless({ country_code => '64', number => $number, formatters => $formatters, validators => $validators, areanames => \%areanames}, $class);
      return $self if ($self->is_valid());
      $number =~ s/^(?:0)//;
      $self = bless({ country_code => '64', number => $number, formatters => $formatters, validators => $validators, areanames => \%areanames}, $class);
      return $self->is_valid() ? $self : undef;
    }
1;