#ifndef DNOTIFY_OPEN_FILE_H
#define DNOTIFY_OPEN_FILE_H

#include <sys/types.h>

#include <set>

// Represents an open file
// Iff two open_file objects are equal do their fds refer to the same file
class open_file
{
  public:
	open_file(int fd);
	open_file(const open_file& of);

  private:
	dev_t dev;
	ino_t ino;

	friend bool operator==(const open_file& x, const open_file& y);
	friend bool operator<(const open_file& x, const open_file& y);
};

bool operator==(const open_file& x, const open_file& y);
bool operator<(const open_file& x, const open_file& y);

#endif // DNOTIFY_OPEN_FILE_H
