#ifndef _RECALC_H
#define _RECALC_H

#include "tv_chip.h"

#define BT_CALC_CHARCLK8	(1 << 0)
#define BT_CALC_CHARCLK9	(1 << 1)
#define BT_CALC_RATIO32		(1 << 2)

typedef void (*RecalcFindRes) (double hoc, double voc, double badness,
  double aspect, int flag);

int recalc_main (int argc, char *argv []);

void recalc_bt_find (TVSystem system, int hres, int vres, 
  double hoc_min, double hoc_max, double voc_min, double voc_max,
  RecalcFindRes callback);

void recalc_bt_custom (TVSystem system, int hres, int vres, 
  double hoc, double voc, TVRegs *r);

void recalc_cx_find (TVSystem system, int hres, int vres, 
  double hoc_min, double hoc_max, double voc_min, double voc_max,
  RecalcFindRes callback);

void recalc_cx_custom (TVSystem system, int hres, int vres, 
  double hoc, double voc, TVRegs *r);

void calc_nv_btcx (int hres, int vres, TVRegs *r);

#endif /* _RECALC_H */
