/***************************************************************************
 *   copyright           : (C) 2002 by Hendrik Sattler                     *
 *   mail                : post@hendrik-sattler.de                         *
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 ***************************************************************************/

#include "scmxx.h"
#include "helper.h"
#include "atcommand.h"
#include "ttyaccess.h"
#include "tty_bluetooth.h"
#include "gtincl.h"
#include "options.h"
#include "scmxx_opt.h"
#include "config.h"

#include <locale.h>
#include <string.h>
#include <stdlib.h>

int main (int argc, char** argv) {
  char* supported_phones[] = {
    "S25",
    "S35i", "M35i", "MC35i", "C35i", "TC35",
    "SL42", "SLIN", "SL45", "SLIK",
    "C45",  "ME45", "S45",  "S45i",
    "M50",  "MT50", "M50I",
    "S55",
    //there are even some phones from north america
    "S46",
    NULL
  };

  unsigned int i = 0;
  char* vendor;
  char* model;

  int cfargc = 0;
  char** files;
  struct args_t* args;
  struct tty_access* tty_funcs;
  char* temp;

  //start setup
  //init global vars	
  helper_init();

  //init local vars    
  vendor = NULL;
  model = NULL;

  //setting locale of this program
  setlocale(LC_ALL,"");

  //init the gettext stuff
  scmxx_gettext_init();

  //the arguments must be parsed early...
  args_init();
  scmxx_use_envvars();
  cfargc = scmxx_conffile_parse("config");
  files = scmxx_args_parse(argc,argv);
  args = scmxx_get_args();
  verbosity_set(args->verbose);
  if (argc <= 1 && cfargc <= 0) args->help = 1;

  //...because we must set the output charset as early as possible
  //It also configures gettext to the new value.
  charset_init(args->system_charset,!(args->help||args->version));

  if (args->help || args->version) {
    if (args->help) {
      help(argv[0],args_type_list,args_list,_("[files...]"));
    }
    if (args->version) {
      printf("%s\n",PACKAGE_VERSION);
    }
    exit(EXIT_SUCCESS);
  }

  /* maybe the user wants bluetooth  */
  if (strncmp(args->port.device,"bt://",5) == 0 ||
      strncmp(args->port.device,"bluetooth://",12) == 0) {
    if (strncmp(args->port.device,"bt://[",6) != 0 &&
	strncmp(args->port.device,"bluetooth://[",13) != 0)
      errexit("%s\n",_("Malformed bluetooth address"));
    args->port.type = TTY_TYPE_BLUETOOTH;
    args->port.device = strchr(args->port.device,(int)'[')+1;
    temp = strchr(args->port.device,(int)']');
    if (temp == NULL) errexit("%s\n",_("Malformed bluetooth address"));
    args->port.channel = BTCHAN_RFCOMM;
    *temp = 0;
    if (*(temp+1) == ':') {
      temp += 2;
      if (str_len(temp)) args->port.channel = atoi(temp);
    }
    args->reset = 0;
  }

  //now open the port
  tty_funcs = tty_open(&args->port);

  at_init((struct at_hw_access*)tty_funcs,args->pin);

  /* Now perform initial phone setup
   */
  //testing the device
  if (phone_init(args->reset,tty_funcs)) {
    print_verbose(0,"%s\n",_("OK, a modem device is present."));
  } else {
    errexit("%s\n",_("cannot communicate with device."));
  }
  //disabling command echo
  command_echo(0);
  
  //enabling advanced error response
  //not needed everywhere but this reduces code duplication
  verbose_errors(1);
  
  //changing to GSM charset
  set_charset("GSM");

  /* Check for registered phones and print a warning on unknown ones
   */
  if (!args->info) {
    vendor = at_get_vendor();
    model = at_get_model();
    if (vendor!=NULL) {
      if (!strcasecmp(vendor,"SIEMENS")) {
	print_verbose(0,_("Detected %s %s\n"),vendor,model);
	for (i=0; supported_phones[i] != NULL; ++i) {
	  print_verbose(3,_("Comparing to registered model %s\n"),supported_phones[i]);
	  if (!strcmp(model,supported_phones[i])) {
	    break;
	  }
	}
	if (supported_phones[i] == NULL) {
	  print_warning("%s\n",
			_("this model was not confirmed to be working with this software."));
	}
      } else {
	print_warning("%s\n",
		      _("phones from this vendor were not confirmed to be working with this software!"));
      }
    }
    mem_realloc(vendor,0);
    mem_realloc(model,0);
  }

  if (args->time || args->smsc || args->dial || args->hangup ||
      args->info || args->meminfo || args->lockinfo ||
      args->lock != NULL) {
    if ((args->smsc || args->dial) &&
	str_len(args->myparams.number) == 0)
      errexit("%s\n",_("you must define a number with the --number option."));      
    if (args->time) set_time();
    if (args->smsc) set_smsc(args->myparams.number);
    if (args->lock != NULL) {
      if (args->state_change > 0) lock_enable(args->lock,args->pin);
      else if (args->state_change < 0) lock_disable(args->lock,args->pin);
    }
    if (args->info || args->meminfo || args->lockinfo)
      info(args->myFILE,args->info,args->meminfo,args->lockinfo);
    if (args->dial) dial(args->myparams.number,1);
    if (args->hangup) hangup();
    exit(EXIT_SUCCESS);
  }

  switch(args->scmxx_ftype) {
  default:
    errexit("%s\n",_("you must specifiy a valid memory type."));
    break;
  case SCMXX_FTYPE_BINARY:
    file_transfer_manage(args->scmxx_action,files,
			 args->myFILE,args->myPIPE,
			 args->myparams.mem,
			 args->myparams.slot);
    break;
  case SCMXX_FTYPE_PBOOK:
    pbook_manage(args->scmxx_action,args->myFILE,
		 files,&args->myparams);
    break;
  case SCMXX_FTYPE_SMS:
    sms_manage(args->scmxx_action,files,
	       args->myFILE,args->myPIPE,
	       &args->myparams,&args->mysmsopts);
    break;
  }
  tty_funcs->close();
  exit(EXIT_SUCCESS);
}
