# Contributing

All contributions are welcome. Specifically, if you found a bug or have a
suggestion for a new feature or markdown extension, you can always open an
[issue] or [pull request].

## Issues

If you open an issue please give a short description of your bug or feature
along with a code example. If there is a relevant spec like the [CommonMark
Spec][commonmark] or the [GitHub Flavored Markdown Spec][gfm] please link it in
the issue.

Any feature suggestions are welcome. The grammar should by default only support
very common syntax, but any extension can be implemented behind a compile time
flag. (See below)

Some bug reports belong in other repositories if they only concern the
implementation of the grammar in a specific context like `nvim-treesitter`, but
you can always open an issue here and I will point you in the right direction.

## Code Overview

Please refer to the [tree-sitter spec] for more details on how to write a tree-
sitter grammar.

This parse is split into two grammars. One for block structure, which can be
found in the `tree-sitter-markdown` folder, and one for inline structure, which
can be found in the `tree-sitter-markdown-inline` folder. Components that are
parts of either grammar can be found in the `common` folder.

For either of the grammar the most important files are the `grammar.js` which
defines most nodes and the `src/scanner.c` which defines nodes that cannot
be parsed with normal tree-sitter rules. All other files in the `src` subfolder
are auto-generated by running `tree-sitter generate`. (You need to install the
[tree-sitter cli tool][tree-sitter-cli] and [Node.js][nodejs] first.)

Some syntactical components can be enabled or disabled by environment variables
at compile time. The logic for this can be found in the `common/grammar.js`
file.

Tests are located in the `test/corpus` subfolder:
* `spec.txt` is taken from the examples in the [GFM spec][gfm].
* `failing.txt` are those examples from the spec that do not pass yet.
* `issues.txt` are test cases covering solved issues.
* `extension_<>.txt` are covering specific extensions. Some of these are also
  taken from the GFM spec.

## Pull Requests

I will happily accept any pull requests.

Before submitting any code please check the following:

* You ran `tree-sitter generate` in the `tree-sitter-markdown` or
  `tree-sitter-markdown-inline` directories respectively after modifying any
  `grammar.js` file.
* When running `tree-sitter test` only the cases defined in `failing.txt` or
  `extension_<>.txt` for not activated extensions fail for **both** grammars.
* If you implemented new behavior please add tests. (In most cases these belong
  in a `extension_<>.txt`.)
* You deleted any auto-generated bindings and files for debugging purposes
  like `log.html`

## Tests

To run the tests, first install the development dependencies (see above), then
execute:

```sh
ALL_EXTENSIONS=1 node scripts/build.js
node scripts/test.js
```

[issue]: https://github.com/tree-sitter-grammars/tree-sitter-markdown/issues/new
[pull request]: https://github.com/tree-sitter-grammars/tree-sitter-markdown/compare
[gfm]: https://github.github.com/gfm/
[commonmark]: https://spec.commonmark.org/
[tree-sitter spec]: https://tree-sitter.github.io/tree-sitter/
[tree-sitter-cli]: https://github.com/tree-sitter/tree-sitter/blob/master/cli/README.md
[nodejs]: https://nodejs.org/
