// Copyright 2015, VIXL authors
// All rights reserved.
//
// Redistribution and use in source and binary forms, with or without
// modification, are permitted provided that the following conditions are met:
//
//   * Redistributions of source code must retain the above copyright notice,
//     this list of conditions and the following disclaimer.
//   * Redistributions in binary form must reproduce the above copyright notice,
//     this list of conditions and the following disclaimer in the documentation
//     and/or other materials provided with the distribution.
//   * Neither the name of ARM Limited nor the names of its contributors may be
//     used to endorse or promote products derived from this software without
//     specific prior written permission.
//
// THIS SOFTWARE IS PROVIDED BY THE COPYRIGHT HOLDERS CONTRIBUTORS "AS IS" AND
// ANY EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE IMPLIED
// WARRANTIES OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE ARE
// DISCLAIMED. IN NO EVENT SHALL THE COPYRIGHT OWNER OR CONTRIBUTORS BE LIABLE
// FOR ANY DIRECT, INDIRECT, INCIDENTAL, SPECIAL, EXEMPLARY, OR CONSEQUENTIAL
// DAMAGES (INCLUDING, BUT NOT LIMITED TO, PROCUREMENT OF SUBSTITUTE GOODS OR
// SERVICES; LOSS OF USE, DATA, OR PROFITS; OR BUSINESS INTERRUPTION) HOWEVER
// CAUSED AND ON ANY THEORY OF LIABILITY, WHETHER IN CONTRACT, STRICT LIABILITY,
// OR TORT (INCLUDING NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY OUT OF THE USE
// OF THIS SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF SUCH DAMAGE.


// ---------------------------------------------------------------------
// This file is auto generated using tools/generate_simulator_traces.py.
//
// PLEASE DO NOT EDIT.
// ---------------------------------------------------------------------

#ifndef VIXL_ASSEMBLER_COND_RD_RN_RM_SMUSDX_A32_H_
#define VIXL_ASSEMBLER_COND_RD_RN_RM_SMUSDX_A32_H_

const byte kInstruction_smusdx_hi_r1_r9_r5[] = {
  0x79, 0xf5, 0x01, 0x87 // smusdx hi r1 r9 r5
};
const byte kInstruction_smusdx_pl_r8_r6_r2[] = {
  0x76, 0xf2, 0x08, 0x57 // smusdx pl r8 r6 r2
};
const byte kInstruction_smusdx_hi_r5_r8_r2[] = {
  0x78, 0xf2, 0x05, 0x87 // smusdx hi r5 r8 r2
};
const byte kInstruction_smusdx_vc_r9_r2_r7[] = {
  0x72, 0xf7, 0x09, 0x77 // smusdx vc r9 r2 r7
};
const byte kInstruction_smusdx_lt_r4_r6_r3[] = {
  0x76, 0xf3, 0x04, 0xb7 // smusdx lt r4 r6 r3
};
const byte kInstruction_smusdx_le_r11_r6_r2[] = {
  0x76, 0xf2, 0x0b, 0xd7 // smusdx le r11 r6 r2
};
const byte kInstruction_smusdx_cc_r8_r14_r4[] = {
  0x7e, 0xf4, 0x08, 0x37 // smusdx cc r8 r14 r4
};
const byte kInstruction_smusdx_le_r5_r14_r6[] = {
  0x7e, 0xf6, 0x05, 0xd7 // smusdx le r5 r14 r6
};
const byte kInstruction_smusdx_lt_r6_r1_r0[] = {
  0x71, 0xf0, 0x06, 0xb7 // smusdx lt r6 r1 r0
};
const byte kInstruction_smusdx_lt_r5_r0_r9[] = {
  0x70, 0xf9, 0x05, 0xb7 // smusdx lt r5 r0 r9
};
const byte kInstruction_smusdx_le_r8_r12_r7[] = {
  0x7c, 0xf7, 0x08, 0xd7 // smusdx le r8 r12 r7
};
const byte kInstruction_smusdx_eq_r7_r14_r6[] = {
  0x7e, 0xf6, 0x07, 0x07 // smusdx eq r7 r14 r6
};
const byte kInstruction_smusdx_cs_r7_r4_r6[] = {
  0x74, 0xf6, 0x07, 0x27 // smusdx cs r7 r4 r6
};
const byte kInstruction_smusdx_gt_r9_r6_r9[] = {
  0x76, 0xf9, 0x09, 0xc7 // smusdx gt r9 r6 r9
};
const byte kInstruction_smusdx_ne_r13_r9_r1[] = {
  0x79, 0xf1, 0x0d, 0x17 // smusdx ne r13 r9 r1
};
const byte kInstruction_smusdx_ge_r13_r1_r13[] = {
  0x71, 0xfd, 0x0d, 0xa7 // smusdx ge r13 r1 r13
};
const byte kInstruction_smusdx_ls_r8_r10_r2[] = {
  0x7a, 0xf2, 0x08, 0x97 // smusdx ls r8 r10 r2
};
const byte kInstruction_smusdx_hi_r0_r13_r5[] = {
  0x7d, 0xf5, 0x00, 0x87 // smusdx hi r0 r13 r5
};
const byte kInstruction_smusdx_pl_r13_r7_r8[] = {
  0x77, 0xf8, 0x0d, 0x57 // smusdx pl r13 r7 r8
};
const byte kInstruction_smusdx_ge_r4_r13_r11[] = {
  0x7d, 0xfb, 0x04, 0xa7 // smusdx ge r4 r13 r11
};
const byte kInstruction_smusdx_cs_r5_r10_r5[] = {
  0x7a, 0xf5, 0x05, 0x27 // smusdx cs r5 r10 r5
};
const byte kInstruction_smusdx_cs_r5_r4_r3[] = {
  0x74, 0xf3, 0x05, 0x27 // smusdx cs r5 r4 r3
};
const byte kInstruction_smusdx_ls_r6_r14_r8[] = {
  0x7e, 0xf8, 0x06, 0x97 // smusdx ls r6 r14 r8
};
const byte kInstruction_smusdx_vs_r3_r8_r6[] = {
  0x78, 0xf6, 0x03, 0x67 // smusdx vs r3 r8 r6
};
const byte kInstruction_smusdx_vc_r7_r12_r3[] = {
  0x7c, 0xf3, 0x07, 0x77 // smusdx vc r7 r12 r3
};
const byte kInstruction_smusdx_ge_r1_r4_r1[] = {
  0x74, 0xf1, 0x01, 0xa7 // smusdx ge r1 r4 r1
};
const byte kInstruction_smusdx_cc_r4_r7_r10[] = {
  0x77, 0xfa, 0x04, 0x37 // smusdx cc r4 r7 r10
};
const byte kInstruction_smusdx_cc_r2_r0_r13[] = {
  0x70, 0xfd, 0x02, 0x37 // smusdx cc r2 r0 r13
};
const byte kInstruction_smusdx_vs_r9_r6_r8[] = {
  0x76, 0xf8, 0x09, 0x67 // smusdx vs r9 r6 r8
};
const byte kInstruction_smusdx_cs_r14_r11_r13[] = {
  0x7b, 0xfd, 0x0e, 0x27 // smusdx cs r14 r11 r13
};
const byte kInstruction_smusdx_pl_r5_r8_r4[] = {
  0x78, 0xf4, 0x05, 0x57 // smusdx pl r5 r8 r4
};
const byte kInstruction_smusdx_pl_r2_r3_r7[] = {
  0x73, 0xf7, 0x02, 0x57 // smusdx pl r2 r3 r7
};
const byte kInstruction_smusdx_cs_r7_r12_r14[] = {
  0x7c, 0xfe, 0x07, 0x27 // smusdx cs r7 r12 r14
};
const byte kInstruction_smusdx_hi_r6_r6_r1[] = {
  0x76, 0xf1, 0x06, 0x87 // smusdx hi r6 r6 r1
};
const byte kInstruction_smusdx_cc_r6_r9_r6[] = {
  0x79, 0xf6, 0x06, 0x37 // smusdx cc r6 r9 r6
};
const byte kInstruction_smusdx_ne_r12_r12_r0[] = {
  0x7c, 0xf0, 0x0c, 0x17 // smusdx ne r12 r12 r0
};
const byte kInstruction_smusdx_cc_r9_r3_r8[] = {
  0x73, 0xf8, 0x09, 0x37 // smusdx cc r9 r3 r8
};
const byte kInstruction_smusdx_mi_r13_r6_r1[] = {
  0x76, 0xf1, 0x0d, 0x47 // smusdx mi r13 r6 r1
};
const byte kInstruction_smusdx_lt_r4_r8_r6[] = {
  0x78, 0xf6, 0x04, 0xb7 // smusdx lt r4 r8 r6
};
const byte kInstruction_smusdx_hi_r11_r5_r9[] = {
  0x75, 0xf9, 0x0b, 0x87 // smusdx hi r11 r5 r9
};
const byte kInstruction_smusdx_cc_r6_r10_r6[] = {
  0x7a, 0xf6, 0x06, 0x37 // smusdx cc r6 r10 r6
};
const byte kInstruction_smusdx_eq_r10_r10_r5[] = {
  0x7a, 0xf5, 0x0a, 0x07 // smusdx eq r10 r10 r5
};
const byte kInstruction_smusdx_al_r5_r4_r11[] = {
  0x74, 0xfb, 0x05, 0xe7 // smusdx al r5 r4 r11
};
const byte kInstruction_smusdx_pl_r11_r11_r2[] = {
  0x7b, 0xf2, 0x0b, 0x57 // smusdx pl r11 r11 r2
};
const byte kInstruction_smusdx_ls_r6_r14_r12[] = {
  0x7e, 0xfc, 0x06, 0x97 // smusdx ls r6 r14 r12
};
const byte kInstruction_smusdx_vc_r7_r7_r2[] = {
  0x77, 0xf2, 0x07, 0x77 // smusdx vc r7 r7 r2
};
const byte kInstruction_smusdx_eq_r10_r8_r4[] = {
  0x78, 0xf4, 0x0a, 0x07 // smusdx eq r10 r8 r4
};
const byte kInstruction_smusdx_al_r14_r7_r2[] = {
  0x77, 0xf2, 0x0e, 0xe7 // smusdx al r14 r7 r2
};
const byte kInstruction_smusdx_cs_r3_r11_r10[] = {
  0x7b, 0xfa, 0x03, 0x27 // smusdx cs r3 r11 r10
};
const byte kInstruction_smusdx_ls_r11_r4_r0[] = {
  0x74, 0xf0, 0x0b, 0x97 // smusdx ls r11 r4 r0
};
const byte kInstruction_smusdx_hi_r11_r8_r9[] = {
  0x78, 0xf9, 0x0b, 0x87 // smusdx hi r11 r8 r9
};
const byte kInstruction_smusdx_vs_r2_r14_r13[] = {
  0x7e, 0xfd, 0x02, 0x67 // smusdx vs r2 r14 r13
};
const byte kInstruction_smusdx_al_r1_r13_r9[] = {
  0x7d, 0xf9, 0x01, 0xe7 // smusdx al r1 r13 r9
};
const byte kInstruction_smusdx_eq_r3_r9_r13[] = {
  0x79, 0xfd, 0x03, 0x07 // smusdx eq r3 r9 r13
};
const byte kInstruction_smusdx_ge_r10_r3_r13[] = {
  0x73, 0xfd, 0x0a, 0xa7 // smusdx ge r10 r3 r13
};
const byte kInstruction_smusdx_pl_r8_r5_r10[] = {
  0x75, 0xfa, 0x08, 0x57 // smusdx pl r8 r5 r10
};
const byte kInstruction_smusdx_vc_r8_r11_r6[] = {
  0x7b, 0xf6, 0x08, 0x77 // smusdx vc r8 r11 r6
};
const byte kInstruction_smusdx_eq_r0_r0_r5[] = {
  0x70, 0xf5, 0x00, 0x07 // smusdx eq r0 r0 r5
};
const byte kInstruction_smusdx_ne_r6_r5_r8[] = {
  0x75, 0xf8, 0x06, 0x17 // smusdx ne r6 r5 r8
};
const byte kInstruction_smusdx_hi_r5_r13_r3[] = {
  0x7d, 0xf3, 0x05, 0x87 // smusdx hi r5 r13 r3
};
const byte kInstruction_smusdx_ne_r11_r14_r14[] = {
  0x7e, 0xfe, 0x0b, 0x17 // smusdx ne r11 r14 r14
};
const byte kInstruction_smusdx_mi_r1_r0_r6[] = {
  0x70, 0xf6, 0x01, 0x47 // smusdx mi r1 r0 r6
};
const byte kInstruction_smusdx_le_r14_r8_r2[] = {
  0x78, 0xf2, 0x0e, 0xd7 // smusdx le r14 r8 r2
};
const byte kInstruction_smusdx_eq_r9_r6_r5[] = {
  0x76, 0xf5, 0x09, 0x07 // smusdx eq r9 r6 r5
};
const byte kInstruction_smusdx_eq_r11_r0_r13[] = {
  0x70, 0xfd, 0x0b, 0x07 // smusdx eq r11 r0 r13
};
const byte kInstruction_smusdx_pl_r4_r5_r14[] = {
  0x75, 0xfe, 0x04, 0x57 // smusdx pl r4 r5 r14
};
const byte kInstruction_smusdx_cs_r13_r5_r13[] = {
  0x75, 0xfd, 0x0d, 0x27 // smusdx cs r13 r5 r13
};
const byte kInstruction_smusdx_mi_r0_r13_r8[] = {
  0x7d, 0xf8, 0x00, 0x47 // smusdx mi r0 r13 r8
};
const byte kInstruction_smusdx_lt_r2_r13_r3[] = {
  0x7d, 0xf3, 0x02, 0xb7 // smusdx lt r2 r13 r3
};
const byte kInstruction_smusdx_ls_r8_r1_r11[] = {
  0x71, 0xfb, 0x08, 0x97 // smusdx ls r8 r1 r11
};
const byte kInstruction_smusdx_vc_r14_r11_r8[] = {
  0x7b, 0xf8, 0x0e, 0x77 // smusdx vc r14 r11 r8
};
const byte kInstruction_smusdx_lt_r4_r13_r12[] = {
  0x7d, 0xfc, 0x04, 0xb7 // smusdx lt r4 r13 r12
};
const byte kInstruction_smusdx_eq_r2_r1_r14[] = {
  0x71, 0xfe, 0x02, 0x07 // smusdx eq r2 r1 r14
};
const byte kInstruction_smusdx_eq_r9_r4_r14[] = {
  0x74, 0xfe, 0x09, 0x07 // smusdx eq r9 r4 r14
};
const byte kInstruction_smusdx_hi_r10_r6_r13[] = {
  0x76, 0xfd, 0x0a, 0x87 // smusdx hi r10 r6 r13
};
const byte kInstruction_smusdx_ge_r12_r9_r4[] = {
  0x79, 0xf4, 0x0c, 0xa7 // smusdx ge r12 r9 r4
};
const byte kInstruction_smusdx_le_r9_r11_r14[] = {
  0x7b, 0xfe, 0x09, 0xd7 // smusdx le r9 r11 r14
};
const byte kInstruction_smusdx_ls_r0_r9_r5[] = {
  0x79, 0xf5, 0x00, 0x97 // smusdx ls r0 r9 r5
};
const byte kInstruction_smusdx_mi_r2_r3_r8[] = {
  0x73, 0xf8, 0x02, 0x47 // smusdx mi r2 r3 r8
};
const byte kInstruction_smusdx_ne_r14_r10_r14[] = {
  0x7a, 0xfe, 0x0e, 0x17 // smusdx ne r14 r10 r14
};
const byte kInstruction_smusdx_eq_r6_r2_r10[] = {
  0x72, 0xfa, 0x06, 0x07 // smusdx eq r6 r2 r10
};
const byte kInstruction_smusdx_lt_r11_r0_r12[] = {
  0x70, 0xfc, 0x0b, 0xb7 // smusdx lt r11 r0 r12
};
const byte kInstruction_smusdx_ne_r1_r12_r10[] = {
  0x7c, 0xfa, 0x01, 0x17 // smusdx ne r1 r12 r10
};
const byte kInstruction_smusdx_cc_r1_r0_r2[] = {
  0x70, 0xf2, 0x01, 0x37 // smusdx cc r1 r0 r2
};
const byte kInstruction_smusdx_al_r5_r5_r7[] = {
  0x75, 0xf7, 0x05, 0xe7 // smusdx al r5 r5 r7
};
const byte kInstruction_smusdx_hi_r7_r13_r1[] = {
  0x7d, 0xf1, 0x07, 0x87 // smusdx hi r7 r13 r1
};
const byte kInstruction_smusdx_cs_r4_r4_r9[] = {
  0x74, 0xf9, 0x04, 0x27 // smusdx cs r4 r4 r9
};
const byte kInstruction_smusdx_eq_r14_r4_r14[] = {
  0x74, 0xfe, 0x0e, 0x07 // smusdx eq r14 r4 r14
};
const byte kInstruction_smusdx_vs_r10_r5_r14[] = {
  0x75, 0xfe, 0x0a, 0x67 // smusdx vs r10 r5 r14
};
const byte kInstruction_smusdx_gt_r4_r3_r11[] = {
  0x73, 0xfb, 0x04, 0xc7 // smusdx gt r4 r3 r11
};
const byte kInstruction_smusdx_ne_r14_r10_r12[] = {
  0x7a, 0xfc, 0x0e, 0x17 // smusdx ne r14 r10 r12
};
const byte kInstruction_smusdx_vs_r2_r11_r0[] = {
  0x7b, 0xf0, 0x02, 0x67 // smusdx vs r2 r11 r0
};
const byte kInstruction_smusdx_ge_r5_r12_r7[] = {
  0x7c, 0xf7, 0x05, 0xa7 // smusdx ge r5 r12 r7
};
const byte kInstruction_smusdx_mi_r7_r14_r6[] = {
  0x7e, 0xf6, 0x07, 0x47 // smusdx mi r7 r14 r6
};
const byte kInstruction_smusdx_gt_r8_r3_r8[] = {
  0x73, 0xf8, 0x08, 0xc7 // smusdx gt r8 r3 r8
};
const byte kInstruction_smusdx_hi_r9_r14_r3[] = {
  0x7e, 0xf3, 0x09, 0x87 // smusdx hi r9 r14 r3
};
const byte kInstruction_smusdx_vc_r2_r11_r2[] = {
  0x7b, 0xf2, 0x02, 0x77 // smusdx vc r2 r11 r2
};
const byte kInstruction_smusdx_hi_r11_r7_r12[] = {
  0x77, 0xfc, 0x0b, 0x87 // smusdx hi r11 r7 r12
};
const byte kInstruction_smusdx_cs_r6_r4_r11[] = {
  0x74, 0xfb, 0x06, 0x27 // smusdx cs r6 r4 r11
};
const byte kInstruction_smusdx_cs_r12_r5_r9[] = {
  0x75, 0xf9, 0x0c, 0x27 // smusdx cs r12 r5 r9
};
const byte kInstruction_smusdx_ls_r5_r10_r5[] = {
  0x7a, 0xf5, 0x05, 0x97 // smusdx ls r5 r10 r5
};
const byte kInstruction_smusdx_ls_r0_r9_r13[] = {
  0x79, 0xfd, 0x00, 0x97 // smusdx ls r0 r9 r13
};
const byte kInstruction_smusdx_lt_r3_r3_r5[] = {
  0x73, 0xf5, 0x03, 0xb7 // smusdx lt r3 r3 r5
};
const byte kInstruction_smusdx_mi_r0_r12_r8[] = {
  0x7c, 0xf8, 0x00, 0x47 // smusdx mi r0 r12 r8
};
const byte kInstruction_smusdx_pl_r3_r12_r12[] = {
  0x7c, 0xfc, 0x03, 0x57 // smusdx pl r3 r12 r12
};
const byte kInstruction_smusdx_eq_r8_r12_r5[] = {
  0x7c, 0xf5, 0x08, 0x07 // smusdx eq r8 r12 r5
};
const byte kInstruction_smusdx_cc_r7_r8_r1[] = {
  0x78, 0xf1, 0x07, 0x37 // smusdx cc r7 r8 r1
};
const byte kInstruction_smusdx_hi_r2_r13_r10[] = {
  0x7d, 0xfa, 0x02, 0x87 // smusdx hi r2 r13 r10
};
const byte kInstruction_smusdx_al_r7_r10_r10[] = {
  0x7a, 0xfa, 0x07, 0xe7 // smusdx al r7 r10 r10
};
const byte kInstruction_smusdx_vc_r1_r12_r2[] = {
  0x7c, 0xf2, 0x01, 0x77 // smusdx vc r1 r12 r2
};
const byte kInstruction_smusdx_cc_r8_r5_r8[] = {
  0x75, 0xf8, 0x08, 0x37 // smusdx cc r8 r5 r8
};
const byte kInstruction_smusdx_ls_r3_r7_r9[] = {
  0x77, 0xf9, 0x03, 0x97 // smusdx ls r3 r7 r9
};
const byte kInstruction_smusdx_al_r8_r10_r8[] = {
  0x7a, 0xf8, 0x08, 0xe7 // smusdx al r8 r10 r8
};
const byte kInstruction_smusdx_lt_r4_r12_r10[] = {
  0x7c, 0xfa, 0x04, 0xb7 // smusdx lt r4 r12 r10
};
const byte kInstruction_smusdx_ge_r10_r5_r11[] = {
  0x75, 0xfb, 0x0a, 0xa7 // smusdx ge r10 r5 r11
};
const byte kInstruction_smusdx_ls_r3_r14_r4[] = {
  0x7e, 0xf4, 0x03, 0x97 // smusdx ls r3 r14 r4
};
const byte kInstruction_smusdx_hi_r3_r6_r12[] = {
  0x76, 0xfc, 0x03, 0x87 // smusdx hi r3 r6 r12
};
const byte kInstruction_smusdx_hi_r6_r0_r4[] = {
  0x70, 0xf4, 0x06, 0x87 // smusdx hi r6 r0 r4
};
const byte kInstruction_smusdx_al_r11_r6_r0[] = {
  0x76, 0xf0, 0x0b, 0xe7 // smusdx al r11 r6 r0
};
const byte kInstruction_smusdx_mi_r3_r1_r9[] = {
  0x71, 0xf9, 0x03, 0x47 // smusdx mi r3 r1 r9
};
const byte kInstruction_smusdx_mi_r12_r13_r0[] = {
  0x7d, 0xf0, 0x0c, 0x47 // smusdx mi r12 r13 r0
};
const byte kInstruction_smusdx_le_r1_r2_r5[] = {
  0x72, 0xf5, 0x01, 0xd7 // smusdx le r1 r2 r5
};
const byte kInstruction_smusdx_hi_r4_r3_r14[] = {
  0x73, 0xfe, 0x04, 0x87 // smusdx hi r4 r3 r14
};
const byte kInstruction_smusdx_eq_r6_r11_r11[] = {
  0x7b, 0xfb, 0x06, 0x07 // smusdx eq r6 r11 r11
};
const byte kInstruction_smusdx_cc_r14_r11_r14[] = {
  0x7b, 0xfe, 0x0e, 0x37 // smusdx cc r14 r11 r14
};
const byte kInstruction_smusdx_hi_r4_r10_r0[] = {
  0x7a, 0xf0, 0x04, 0x87 // smusdx hi r4 r10 r0
};
const byte kInstruction_smusdx_cc_r7_r11_r1[] = {
  0x7b, 0xf1, 0x07, 0x37 // smusdx cc r7 r11 r1
};
const byte kInstruction_smusdx_mi_r14_r6_r10[] = {
  0x76, 0xfa, 0x0e, 0x47 // smusdx mi r14 r6 r10
};
const byte kInstruction_smusdx_eq_r2_r0_r11[] = {
  0x70, 0xfb, 0x02, 0x07 // smusdx eq r2 r0 r11
};
const byte kInstruction_smusdx_mi_r13_r5_r12[] = {
  0x75, 0xfc, 0x0d, 0x47 // smusdx mi r13 r5 r12
};
const byte kInstruction_smusdx_eq_r2_r12_r5[] = {
  0x7c, 0xf5, 0x02, 0x07 // smusdx eq r2 r12 r5
};
const byte kInstruction_smusdx_le_r12_r0_r2[] = {
  0x70, 0xf2, 0x0c, 0xd7 // smusdx le r12 r0 r2
};
const byte kInstruction_smusdx_vc_r10_r10_r9[] = {
  0x7a, 0xf9, 0x0a, 0x77 // smusdx vc r10 r10 r9
};
const byte kInstruction_smusdx_ls_r11_r11_r8[] = {
  0x7b, 0xf8, 0x0b, 0x97 // smusdx ls r11 r11 r8
};
const byte kInstruction_smusdx_hi_r10_r11_r9[] = {
  0x7b, 0xf9, 0x0a, 0x87 // smusdx hi r10 r11 r9
};
const byte kInstruction_smusdx_vs_r7_r12_r14[] = {
  0x7c, 0xfe, 0x07, 0x67 // smusdx vs r7 r12 r14
};
const byte kInstruction_smusdx_gt_r11_r14_r12[] = {
  0x7e, 0xfc, 0x0b, 0xc7 // smusdx gt r11 r14 r12
};
const byte kInstruction_smusdx_vs_r0_r12_r8[] = {
  0x7c, 0xf8, 0x00, 0x67 // smusdx vs r0 r12 r8
};
const byte kInstruction_smusdx_al_r0_r5_r7[] = {
  0x75, 0xf7, 0x00, 0xe7 // smusdx al r0 r5 r7
};
const byte kInstruction_smusdx_hi_r5_r13_r8[] = {
  0x7d, 0xf8, 0x05, 0x87 // smusdx hi r5 r13 r8
};
const byte kInstruction_smusdx_le_r9_r9_r7[] = {
  0x79, 0xf7, 0x09, 0xd7 // smusdx le r9 r9 r7
};
const byte kInstruction_smusdx_cc_r4_r9_r5[] = {
  0x79, 0xf5, 0x04, 0x37 // smusdx cc r4 r9 r5
};
const byte kInstruction_smusdx_vs_r8_r1_r3[] = {
  0x71, 0xf3, 0x08, 0x67 // smusdx vs r8 r1 r3
};
const byte kInstruction_smusdx_cc_r0_r10_r12[] = {
  0x7a, 0xfc, 0x00, 0x37 // smusdx cc r0 r10 r12
};
const byte kInstruction_smusdx_eq_r7_r14_r0[] = {
  0x7e, 0xf0, 0x07, 0x07 // smusdx eq r7 r14 r0
};
const byte kInstruction_smusdx_vs_r12_r9_r11[] = {
  0x79, 0xfb, 0x0c, 0x67 // smusdx vs r12 r9 r11
};
const byte kInstruction_smusdx_gt_r5_r9_r11[] = {
  0x79, 0xfb, 0x05, 0xc7 // smusdx gt r5 r9 r11
};
const byte kInstruction_smusdx_cs_r14_r13_r7[] = {
  0x7d, 0xf7, 0x0e, 0x27 // smusdx cs r14 r13 r7
};
const byte kInstruction_smusdx_mi_r11_r3_r10[] = {
  0x73, 0xfa, 0x0b, 0x47 // smusdx mi r11 r3 r10
};
const byte kInstruction_smusdx_hi_r11_r8_r12[] = {
  0x78, 0xfc, 0x0b, 0x87 // smusdx hi r11 r8 r12
};
const byte kInstruction_smusdx_cs_r3_r8_r13[] = {
  0x78, 0xfd, 0x03, 0x27 // smusdx cs r3 r8 r13
};
const byte kInstruction_smusdx_pl_r10_r12_r6[] = {
  0x7c, 0xf6, 0x0a, 0x57 // smusdx pl r10 r12 r6
};
const byte kInstruction_smusdx_vc_r7_r3_r2[] = {
  0x73, 0xf2, 0x07, 0x77 // smusdx vc r7 r3 r2
};
const byte kInstruction_smusdx_mi_r9_r0_r8[] = {
  0x70, 0xf8, 0x09, 0x47 // smusdx mi r9 r0 r8
};
const byte kInstruction_smusdx_eq_r2_r13_r7[] = {
  0x7d, 0xf7, 0x02, 0x07 // smusdx eq r2 r13 r7
};
const byte kInstruction_smusdx_ne_r2_r14_r0[] = {
  0x7e, 0xf0, 0x02, 0x17 // smusdx ne r2 r14 r0
};
const byte kInstruction_smusdx_vs_r4_r10_r0[] = {
  0x7a, 0xf0, 0x04, 0x67 // smusdx vs r4 r10 r0
};
const byte kInstruction_smusdx_ls_r0_r2_r2[] = {
  0x72, 0xf2, 0x00, 0x97 // smusdx ls r0 r2 r2
};
const byte kInstruction_smusdx_cc_r1_r6_r0[] = {
  0x76, 0xf0, 0x01, 0x37 // smusdx cc r1 r6 r0
};
const byte kInstruction_smusdx_lt_r12_r0_r8[] = {
  0x70, 0xf8, 0x0c, 0xb7 // smusdx lt r12 r0 r8
};
const byte kInstruction_smusdx_cc_r9_r3_r14[] = {
  0x73, 0xfe, 0x09, 0x37 // smusdx cc r9 r3 r14
};
const byte kInstruction_smusdx_vs_r7_r9_r1[] = {
  0x79, 0xf1, 0x07, 0x67 // smusdx vs r7 r9 r1
};
const byte kInstruction_smusdx_eq_r11_r9_r14[] = {
  0x79, 0xfe, 0x0b, 0x07 // smusdx eq r11 r9 r14
};
const byte kInstruction_smusdx_pl_r6_r10_r4[] = {
  0x7a, 0xf4, 0x06, 0x57 // smusdx pl r6 r10 r4
};
const byte kInstruction_smusdx_ne_r8_r5_r6[] = {
  0x75, 0xf6, 0x08, 0x17 // smusdx ne r8 r5 r6
};
const byte kInstruction_smusdx_cs_r0_r6_r2[] = {
  0x76, 0xf2, 0x00, 0x27 // smusdx cs r0 r6 r2
};
const byte kInstruction_smusdx_eq_r11_r12_r4[] = {
  0x7c, 0xf4, 0x0b, 0x07 // smusdx eq r11 r12 r4
};
const byte kInstruction_smusdx_lt_r14_r3_r14[] = {
  0x73, 0xfe, 0x0e, 0xb7 // smusdx lt r14 r3 r14
};
const byte kInstruction_smusdx_le_r7_r12_r14[] = {
  0x7c, 0xfe, 0x07, 0xd7 // smusdx le r7 r12 r14
};
const byte kInstruction_smusdx_hi_r2_r9_r9[] = {
  0x79, 0xf9, 0x02, 0x87 // smusdx hi r2 r9 r9
};
const byte kInstruction_smusdx_ne_r8_r1_r0[] = {
  0x71, 0xf0, 0x08, 0x17 // smusdx ne r8 r1 r0
};
const byte kInstruction_smusdx_cc_r5_r11_r2[] = {
  0x7b, 0xf2, 0x05, 0x37 // smusdx cc r5 r11 r2
};
const byte kInstruction_smusdx_hi_r0_r1_r2[] = {
  0x71, 0xf2, 0x00, 0x87 // smusdx hi r0 r1 r2
};
const byte kInstruction_smusdx_al_r4_r9_r4[] = {
  0x79, 0xf4, 0x04, 0xe7 // smusdx al r4 r9 r4
};
const byte kInstruction_smusdx_cs_r12_r7_r14[] = {
  0x77, 0xfe, 0x0c, 0x27 // smusdx cs r12 r7 r14
};
const byte kInstruction_smusdx_cc_r4_r12_r10[] = {
  0x7c, 0xfa, 0x04, 0x37 // smusdx cc r4 r12 r10
};
const byte kInstruction_smusdx_al_r3_r5_r10[] = {
  0x75, 0xfa, 0x03, 0xe7 // smusdx al r3 r5 r10
};
const byte kInstruction_smusdx_mi_r5_r3_r7[] = {
  0x73, 0xf7, 0x05, 0x47 // smusdx mi r5 r3 r7
};
const byte kInstruction_smusdx_ls_r10_r6_r2[] = {
  0x76, 0xf2, 0x0a, 0x97 // smusdx ls r10 r6 r2
};
const byte kInstruction_smusdx_mi_r0_r12_r11[] = {
  0x7c, 0xfb, 0x00, 0x47 // smusdx mi r0 r12 r11
};
const byte kInstruction_smusdx_vc_r12_r5_r6[] = {
  0x75, 0xf6, 0x0c, 0x77 // smusdx vc r12 r5 r6
};
const byte kInstruction_smusdx_cs_r3_r9_r4[] = {
  0x79, 0xf4, 0x03, 0x27 // smusdx cs r3 r9 r4
};
const byte kInstruction_smusdx_ls_r4_r9_r11[] = {
  0x79, 0xfb, 0x04, 0x97 // smusdx ls r4 r9 r11
};
const byte kInstruction_smusdx_le_r14_r8_r13[] = {
  0x78, 0xfd, 0x0e, 0xd7 // smusdx le r14 r8 r13
};
const byte kInstruction_smusdx_gt_r4_r10_r8[] = {
  0x7a, 0xf8, 0x04, 0xc7 // smusdx gt r4 r10 r8
};
const byte kInstruction_smusdx_al_r6_r9_r9[] = {
  0x79, 0xf9, 0x06, 0xe7 // smusdx al r6 r9 r9
};
const byte kInstruction_smusdx_ne_r8_r5_r12[] = {
  0x75, 0xfc, 0x08, 0x17 // smusdx ne r8 r5 r12
};
const byte kInstruction_smusdx_ne_r0_r4_r8[] = {
  0x74, 0xf8, 0x00, 0x17 // smusdx ne r0 r4 r8
};
const byte kInstruction_smusdx_mi_r7_r13_r3[] = {
  0x7d, 0xf3, 0x07, 0x47 // smusdx mi r7 r13 r3
};
const byte kInstruction_smusdx_cc_r11_r7_r0[] = {
  0x77, 0xf0, 0x0b, 0x37 // smusdx cc r11 r7 r0
};
const byte kInstruction_smusdx_hi_r1_r0_r12[] = {
  0x70, 0xfc, 0x01, 0x87 // smusdx hi r1 r0 r12
};
const byte kInstruction_smusdx_lt_r8_r9_r3[] = {
  0x79, 0xf3, 0x08, 0xb7 // smusdx lt r8 r9 r3
};
const byte kInstruction_smusdx_al_r0_r2_r1[] = {
  0x72, 0xf1, 0x00, 0xe7 // smusdx al r0 r2 r1
};
const byte kInstruction_smusdx_vs_r4_r3_r14[] = {
  0x73, 0xfe, 0x04, 0x67 // smusdx vs r4 r3 r14
};
const byte kInstruction_smusdx_ge_r2_r11_r1[] = {
  0x7b, 0xf1, 0x02, 0xa7 // smusdx ge r2 r11 r1
};
const byte kInstruction_smusdx_lt_r12_r9_r6[] = {
  0x79, 0xf6, 0x0c, 0xb7 // smusdx lt r12 r9 r6
};
const byte kInstruction_smusdx_ls_r8_r2_r7[] = {
  0x72, 0xf7, 0x08, 0x97 // smusdx ls r8 r2 r7
};
const byte kInstruction_smusdx_le_r8_r13_r3[] = {
  0x7d, 0xf3, 0x08, 0xd7 // smusdx le r8 r13 r3
};
const byte kInstruction_smusdx_eq_r11_r13_r14[] = {
  0x7d, 0xfe, 0x0b, 0x07 // smusdx eq r11 r13 r14
};
const byte kInstruction_smusdx_lt_r1_r6_r13[] = {
  0x76, 0xfd, 0x01, 0xb7 // smusdx lt r1 r6 r13
};
const byte kInstruction_smusdx_cs_r3_r8_r11[] = {
  0x78, 0xfb, 0x03, 0x27 // smusdx cs r3 r8 r11
};
const byte kInstruction_smusdx_pl_r12_r5_r4[] = {
  0x75, 0xf4, 0x0c, 0x57 // smusdx pl r12 r5 r4
};
const byte kInstruction_smusdx_eq_r8_r7_r2[] = {
  0x77, 0xf2, 0x08, 0x07 // smusdx eq r8 r7 r2
};
const byte kInstruction_smusdx_ls_r2_r12_r2[] = {
  0x7c, 0xf2, 0x02, 0x97 // smusdx ls r2 r12 r2
};
const byte kInstruction_smusdx_le_r14_r2_r3[] = {
  0x72, 0xf3, 0x0e, 0xd7 // smusdx le r14 r2 r3
};
const byte kInstruction_smusdx_ge_r10_r11_r6[] = {
  0x7b, 0xf6, 0x0a, 0xa7 // smusdx ge r10 r11 r6
};
const byte kInstruction_smusdx_hi_r0_r2_r2[] = {
  0x72, 0xf2, 0x00, 0x87 // smusdx hi r0 r2 r2
};
const byte kInstruction_smusdx_ge_r2_r0_r2[] = {
  0x70, 0xf2, 0x02, 0xa7 // smusdx ge r2 r0 r2
};
const byte kInstruction_smusdx_vs_r11_r14_r0[] = {
  0x7e, 0xf0, 0x0b, 0x67 // smusdx vs r11 r14 r0
};
const byte kInstruction_smusdx_lt_r2_r0_r1[] = {
  0x70, 0xf1, 0x02, 0xb7 // smusdx lt r2 r0 r1
};
const byte kInstruction_smusdx_cs_r2_r5_r11[] = {
  0x75, 0xfb, 0x02, 0x27 // smusdx cs r2 r5 r11
};
const byte kInstruction_smusdx_ls_r7_r14_r5[] = {
  0x7e, 0xf5, 0x07, 0x97 // smusdx ls r7 r14 r5
};
const byte kInstruction_smusdx_pl_r0_r0_r3[] = {
  0x70, 0xf3, 0x00, 0x57 // smusdx pl r0 r0 r3
};
const byte kInstruction_smusdx_ge_r6_r8_r8[] = {
  0x78, 0xf8, 0x06, 0xa7 // smusdx ge r6 r8 r8
};
const byte kInstruction_smusdx_le_r11_r1_r10[] = {
  0x71, 0xfa, 0x0b, 0xd7 // smusdx le r11 r1 r10
};
const byte kInstruction_smusdx_vs_r5_r2_r7[] = {
  0x72, 0xf7, 0x05, 0x67 // smusdx vs r5 r2 r7
};
const byte kInstruction_smusdx_ne_r4_r4_r8[] = {
  0x74, 0xf8, 0x04, 0x17 // smusdx ne r4 r4 r8
};
const byte kInstruction_smusdx_cc_r9_r14_r13[] = {
  0x7e, 0xfd, 0x09, 0x37 // smusdx cc r9 r14 r13
};
const byte kInstruction_smusdx_hi_r14_r6_r3[] = {
  0x76, 0xf3, 0x0e, 0x87 // smusdx hi r14 r6 r3
};
const byte kInstruction_smusdx_al_r0_r8_r0[] = {
  0x78, 0xf0, 0x00, 0xe7 // smusdx al r0 r8 r0
};
const byte kInstruction_smusdx_lt_r6_r11_r1[] = {
  0x7b, 0xf1, 0x06, 0xb7 // smusdx lt r6 r11 r1
};
const byte kInstruction_smusdx_ge_r7_r6_r12[] = {
  0x76, 0xfc, 0x07, 0xa7 // smusdx ge r7 r6 r12
};
const byte kInstruction_smusdx_cs_r4_r6_r14[] = {
  0x76, 0xfe, 0x04, 0x27 // smusdx cs r4 r6 r14
};
const byte kInstruction_smusdx_cs_r7_r6_r7[] = {
  0x76, 0xf7, 0x07, 0x27 // smusdx cs r7 r6 r7
};
const byte kInstruction_smusdx_cs_r3_r7_r10[] = {
  0x77, 0xfa, 0x03, 0x27 // smusdx cs r3 r7 r10
};
const byte kInstruction_smusdx_ne_r0_r2_r1[] = {
  0x72, 0xf1, 0x00, 0x17 // smusdx ne r0 r2 r1
};
const byte kInstruction_smusdx_vs_r9_r10_r13[] = {
  0x7a, 0xfd, 0x09, 0x67 // smusdx vs r9 r10 r13
};
const byte kInstruction_smusdx_vc_r11_r14_r12[] = {
  0x7e, 0xfc, 0x0b, 0x77 // smusdx vc r11 r14 r12
};
const byte kInstruction_smusdx_ge_r14_r8_r7[] = {
  0x78, 0xf7, 0x0e, 0xa7 // smusdx ge r14 r8 r7
};
const byte kInstruction_smusdx_lt_r13_r0_r11[] = {
  0x70, 0xfb, 0x0d, 0xb7 // smusdx lt r13 r0 r11
};
const byte kInstruction_smusdx_lt_r14_r13_r4[] = {
  0x7d, 0xf4, 0x0e, 0xb7 // smusdx lt r14 r13 r4
};
const byte kInstruction_smusdx_al_r1_r10_r9[] = {
  0x7a, 0xf9, 0x01, 0xe7 // smusdx al r1 r10 r9
};
const byte kInstruction_smusdx_ge_r11_r14_r11[] = {
  0x7e, 0xfb, 0x0b, 0xa7 // smusdx ge r11 r14 r11
};
const byte kInstruction_smusdx_cs_r11_r4_r11[] = {
  0x74, 0xfb, 0x0b, 0x27 // smusdx cs r11 r4 r11
};
const byte kInstruction_smusdx_ge_r0_r14_r7[] = {
  0x7e, 0xf7, 0x00, 0xa7 // smusdx ge r0 r14 r7
};
const byte kInstruction_smusdx_mi_r1_r2_r9[] = {
  0x72, 0xf9, 0x01, 0x47 // smusdx mi r1 r2 r9
};
const byte kInstruction_smusdx_eq_r5_r12_r3[] = {
  0x7c, 0xf3, 0x05, 0x07 // smusdx eq r5 r12 r3
};
const byte kInstruction_smusdx_ge_r1_r5_r12[] = {
  0x75, 0xfc, 0x01, 0xa7 // smusdx ge r1 r5 r12
};
const byte kInstruction_smusdx_lt_r10_r11_r4[] = {
  0x7b, 0xf4, 0x0a, 0xb7 // smusdx lt r10 r11 r4
};
const byte kInstruction_smusdx_le_r1_r1_r5[] = {
  0x71, 0xf5, 0x01, 0xd7 // smusdx le r1 r1 r5
};
const byte kInstruction_smusdx_al_r9_r1_r8[] = {
  0x71, 0xf8, 0x09, 0xe7 // smusdx al r9 r1 r8
};
const byte kInstruction_smusdx_ne_r6_r8_r4[] = {
  0x78, 0xf4, 0x06, 0x17 // smusdx ne r6 r8 r4
};
const byte kInstruction_smusdx_ge_r12_r2_r9[] = {
  0x72, 0xf9, 0x0c, 0xa7 // smusdx ge r12 r2 r9
};
const byte kInstruction_smusdx_pl_r4_r3_r10[] = {
  0x73, 0xfa, 0x04, 0x57 // smusdx pl r4 r3 r10
};
const byte kInstruction_smusdx_eq_r14_r4_r11[] = {
  0x74, 0xfb, 0x0e, 0x07 // smusdx eq r14 r4 r11
};
const byte kInstruction_smusdx_cc_r9_r7_r6[] = {
  0x77, 0xf6, 0x09, 0x37 // smusdx cc r9 r7 r6
};
const byte kInstruction_smusdx_ge_r12_r4_r5[] = {
  0x74, 0xf5, 0x0c, 0xa7 // smusdx ge r12 r4 r5
};
const byte kInstruction_smusdx_hi_r2_r3_r4[] = {
  0x73, 0xf4, 0x02, 0x87 // smusdx hi r2 r3 r4
};
const byte kInstruction_smusdx_cs_r0_r3_r1[] = {
  0x73, 0xf1, 0x00, 0x27 // smusdx cs r0 r3 r1
};
const byte kInstruction_smusdx_hi_r6_r2_r8[] = {
  0x72, 0xf8, 0x06, 0x87 // smusdx hi r6 r2 r8
};
const byte kInstruction_smusdx_cc_r3_r14_r13[] = {
  0x7e, 0xfd, 0x03, 0x37 // smusdx cc r3 r14 r13
};
const byte kInstruction_smusdx_gt_r11_r4_r7[] = {
  0x74, 0xf7, 0x0b, 0xc7 // smusdx gt r11 r4 r7
};
const byte kInstruction_smusdx_hi_r5_r0_r12[] = {
  0x70, 0xfc, 0x05, 0x87 // smusdx hi r5 r0 r12
};
const byte kInstruction_smusdx_gt_r0_r14_r14[] = {
  0x7e, 0xfe, 0x00, 0xc7 // smusdx gt r0 r14 r14
};
const byte kInstruction_smusdx_hi_r9_r0_r10[] = {
  0x70, 0xfa, 0x09, 0x87 // smusdx hi r9 r0 r10
};
const byte kInstruction_smusdx_vc_r7_r11_r8[] = {
  0x7b, 0xf8, 0x07, 0x77 // smusdx vc r7 r11 r8
};
const byte kInstruction_smusdx_pl_r11_r9_r6[] = {
  0x79, 0xf6, 0x0b, 0x57 // smusdx pl r11 r9 r6
};
const byte kInstruction_smusdx_al_r3_r3_r7[] = {
  0x73, 0xf7, 0x03, 0xe7 // smusdx al r3 r3 r7
};
const byte kInstruction_smusdx_mi_r5_r7_r9[] = {
  0x77, 0xf9, 0x05, 0x47 // smusdx mi r5 r7 r9
};
const byte kInstruction_smusdx_cc_r11_r2_r4[] = {
  0x72, 0xf4, 0x0b, 0x37 // smusdx cc r11 r2 r4
};
const byte kInstruction_smusdx_cc_r9_r13_r10[] = {
  0x7d, 0xfa, 0x09, 0x37 // smusdx cc r9 r13 r10
};
const byte kInstruction_smusdx_al_r5_r2_r6[] = {
  0x72, 0xf6, 0x05, 0xe7 // smusdx al r5 r2 r6
};
const byte kInstruction_smusdx_ge_r9_r4_r6[] = {
  0x74, 0xf6, 0x09, 0xa7 // smusdx ge r9 r4 r6
};
const byte kInstruction_smusdx_ls_r3_r3_r4[] = {
  0x73, 0xf4, 0x03, 0x97 // smusdx ls r3 r3 r4
};
const byte kInstruction_smusdx_ge_r14_r1_r8[] = {
  0x71, 0xf8, 0x0e, 0xa7 // smusdx ge r14 r1 r8
};
const byte kInstruction_smusdx_ls_r7_r12_r7[] = {
  0x7c, 0xf7, 0x07, 0x97 // smusdx ls r7 r12 r7
};
const byte kInstruction_smusdx_al_r11_r10_r5[] = {
  0x7a, 0xf5, 0x0b, 0xe7 // smusdx al r11 r10 r5
};
const byte kInstruction_smusdx_al_r7_r4_r6[] = {
  0x74, 0xf6, 0x07, 0xe7 // smusdx al r7 r4 r6
};
const byte kInstruction_smusdx_vs_r12_r4_r10[] = {
  0x74, 0xfa, 0x0c, 0x67 // smusdx vs r12 r4 r10
};
const byte kInstruction_smusdx_eq_r4_r4_r4[] = {
  0x74, 0xf4, 0x04, 0x07 // smusdx eq r4 r4 r4
};
const byte kInstruction_smusdx_vs_r6_r6_r12[] = {
  0x76, 0xfc, 0x06, 0x67 // smusdx vs r6 r6 r12
};
const byte kInstruction_smusdx_pl_r9_r3_r5[] = {
  0x73, 0xf5, 0x09, 0x57 // smusdx pl r9 r3 r5
};
const byte kInstruction_smusdx_eq_r6_r5_r13[] = {
  0x75, 0xfd, 0x06, 0x07 // smusdx eq r6 r5 r13
};
const byte kInstruction_smusdx_cc_r8_r2_r12[] = {
  0x72, 0xfc, 0x08, 0x37 // smusdx cc r8 r2 r12
};
const byte kInstruction_smusdx_le_r4_r2_r0[] = {
  0x72, 0xf0, 0x04, 0xd7 // smusdx le r4 r2 r0
};
const byte kInstruction_smusdx_lt_r7_r9_r8[] = {
  0x79, 0xf8, 0x07, 0xb7 // smusdx lt r7 r9 r8
};
const byte kInstruction_smusdx_le_r4_r7_r11[] = {
  0x77, 0xfb, 0x04, 0xd7 // smusdx le r4 r7 r11
};
const byte kInstruction_smusdx_eq_r5_r7_r5[] = {
  0x77, 0xf5, 0x05, 0x07 // smusdx eq r5 r7 r5
};
const byte kInstruction_smusdx_vc_r10_r7_r12[] = {
  0x77, 0xfc, 0x0a, 0x77 // smusdx vc r10 r7 r12
};
const byte kInstruction_smusdx_eq_r7_r10_r6[] = {
  0x7a, 0xf6, 0x07, 0x07 // smusdx eq r7 r10 r6
};
const byte kInstruction_smusdx_pl_r1_r12_r2[] = {
  0x7c, 0xf2, 0x01, 0x57 // smusdx pl r1 r12 r2
};
const byte kInstruction_smusdx_le_r14_r6_r6[] = {
  0x76, 0xf6, 0x0e, 0xd7 // smusdx le r14 r6 r6
};
const byte kInstruction_smusdx_ne_r3_r8_r8[] = {
  0x78, 0xf8, 0x03, 0x17 // smusdx ne r3 r8 r8
};
const byte kInstruction_smusdx_eq_r4_r12_r8[] = {
  0x7c, 0xf8, 0x04, 0x07 // smusdx eq r4 r12 r8
};
const byte kInstruction_smusdx_ge_r11_r2_r3[] = {
  0x72, 0xf3, 0x0b, 0xa7 // smusdx ge r11 r2 r3
};
const byte kInstruction_smusdx_hi_r12_r6_r11[] = {
  0x76, 0xfb, 0x0c, 0x87 // smusdx hi r12 r6 r11
};
const byte kInstruction_smusdx_cs_r4_r5_r10[] = {
  0x75, 0xfa, 0x04, 0x27 // smusdx cs r4 r5 r10
};
const byte kInstruction_smusdx_ge_r10_r2_r10[] = {
  0x72, 0xfa, 0x0a, 0xa7 // smusdx ge r10 r2 r10
};
const byte kInstruction_smusdx_ge_r5_r14_r6[] = {
  0x7e, 0xf6, 0x05, 0xa7 // smusdx ge r5 r14 r6
};
const byte kInstruction_smusdx_gt_r13_r7_r5[] = {
  0x77, 0xf5, 0x0d, 0xc7 // smusdx gt r13 r7 r5
};
const byte kInstruction_smusdx_ge_r13_r4_r12[] = {
  0x74, 0xfc, 0x0d, 0xa7 // smusdx ge r13 r4 r12
};
const byte kInstruction_smusdx_lt_r8_r10_r14[] = {
  0x7a, 0xfe, 0x08, 0xb7 // smusdx lt r8 r10 r14
};
const byte kInstruction_smusdx_le_r4_r3_r13[] = {
  0x73, 0xfd, 0x04, 0xd7 // smusdx le r4 r3 r13
};
const byte kInstruction_smusdx_pl_r0_r9_r0[] = {
  0x79, 0xf0, 0x00, 0x57 // smusdx pl r0 r9 r0
};
const byte kInstruction_smusdx_eq_r2_r3_r1[] = {
  0x73, 0xf1, 0x02, 0x07 // smusdx eq r2 r3 r1
};
const byte kInstruction_smusdx_vc_r0_r0_r3[] = {
  0x70, 0xf3, 0x00, 0x77 // smusdx vc r0 r0 r3
};
const byte kInstruction_smusdx_mi_r10_r8_r11[] = {
  0x78, 0xfb, 0x0a, 0x47 // smusdx mi r10 r8 r11
};
const byte kInstruction_smusdx_mi_r5_r14_r14[] = {
  0x7e, 0xfe, 0x05, 0x47 // smusdx mi r5 r14 r14
};
const byte kInstruction_smusdx_gt_r5_r11_r2[] = {
  0x7b, 0xf2, 0x05, 0xc7 // smusdx gt r5 r11 r2
};
const byte kInstruction_smusdx_al_r4_r7_r11[] = {
  0x77, 0xfb, 0x04, 0xe7 // smusdx al r4 r7 r11
};
const TestResult kReferencesmusdx[] = {
  {
    ARRAY_SIZE(kInstruction_smusdx_hi_r1_r9_r5),
    kInstruction_smusdx_hi_r1_r9_r5,
  },
  {
    ARRAY_SIZE(kInstruction_smusdx_pl_r8_r6_r2),
    kInstruction_smusdx_pl_r8_r6_r2,
  },
  {
    ARRAY_SIZE(kInstruction_smusdx_hi_r5_r8_r2),
    kInstruction_smusdx_hi_r5_r8_r2,
  },
  {
    ARRAY_SIZE(kInstruction_smusdx_vc_r9_r2_r7),
    kInstruction_smusdx_vc_r9_r2_r7,
  },
  {
    ARRAY_SIZE(kInstruction_smusdx_lt_r4_r6_r3),
    kInstruction_smusdx_lt_r4_r6_r3,
  },
  {
    ARRAY_SIZE(kInstruction_smusdx_le_r11_r6_r2),
    kInstruction_smusdx_le_r11_r6_r2,
  },
  {
    ARRAY_SIZE(kInstruction_smusdx_cc_r8_r14_r4),
    kInstruction_smusdx_cc_r8_r14_r4,
  },
  {
    ARRAY_SIZE(kInstruction_smusdx_le_r5_r14_r6),
    kInstruction_smusdx_le_r5_r14_r6,
  },
  {
    ARRAY_SIZE(kInstruction_smusdx_lt_r6_r1_r0),
    kInstruction_smusdx_lt_r6_r1_r0,
  },
  {
    ARRAY_SIZE(kInstruction_smusdx_lt_r5_r0_r9),
    kInstruction_smusdx_lt_r5_r0_r9,
  },
  {
    ARRAY_SIZE(kInstruction_smusdx_le_r8_r12_r7),
    kInstruction_smusdx_le_r8_r12_r7,
  },
  {
    ARRAY_SIZE(kInstruction_smusdx_eq_r7_r14_r6),
    kInstruction_smusdx_eq_r7_r14_r6,
  },
  {
    ARRAY_SIZE(kInstruction_smusdx_cs_r7_r4_r6),
    kInstruction_smusdx_cs_r7_r4_r6,
  },
  {
    ARRAY_SIZE(kInstruction_smusdx_gt_r9_r6_r9),
    kInstruction_smusdx_gt_r9_r6_r9,
  },
  {
    ARRAY_SIZE(kInstruction_smusdx_ne_r13_r9_r1),
    kInstruction_smusdx_ne_r13_r9_r1,
  },
  {
    ARRAY_SIZE(kInstruction_smusdx_ge_r13_r1_r13),
    kInstruction_smusdx_ge_r13_r1_r13,
  },
  {
    ARRAY_SIZE(kInstruction_smusdx_ls_r8_r10_r2),
    kInstruction_smusdx_ls_r8_r10_r2,
  },
  {
    ARRAY_SIZE(kInstruction_smusdx_hi_r0_r13_r5),
    kInstruction_smusdx_hi_r0_r13_r5,
  },
  {
    ARRAY_SIZE(kInstruction_smusdx_pl_r13_r7_r8),
    kInstruction_smusdx_pl_r13_r7_r8,
  },
  {
    ARRAY_SIZE(kInstruction_smusdx_ge_r4_r13_r11),
    kInstruction_smusdx_ge_r4_r13_r11,
  },
  {
    ARRAY_SIZE(kInstruction_smusdx_cs_r5_r10_r5),
    kInstruction_smusdx_cs_r5_r10_r5,
  },
  {
    ARRAY_SIZE(kInstruction_smusdx_cs_r5_r4_r3),
    kInstruction_smusdx_cs_r5_r4_r3,
  },
  {
    ARRAY_SIZE(kInstruction_smusdx_ls_r6_r14_r8),
    kInstruction_smusdx_ls_r6_r14_r8,
  },
  {
    ARRAY_SIZE(kInstruction_smusdx_vs_r3_r8_r6),
    kInstruction_smusdx_vs_r3_r8_r6,
  },
  {
    ARRAY_SIZE(kInstruction_smusdx_vc_r7_r12_r3),
    kInstruction_smusdx_vc_r7_r12_r3,
  },
  {
    ARRAY_SIZE(kInstruction_smusdx_ge_r1_r4_r1),
    kInstruction_smusdx_ge_r1_r4_r1,
  },
  {
    ARRAY_SIZE(kInstruction_smusdx_cc_r4_r7_r10),
    kInstruction_smusdx_cc_r4_r7_r10,
  },
  {
    ARRAY_SIZE(kInstruction_smusdx_cc_r2_r0_r13),
    kInstruction_smusdx_cc_r2_r0_r13,
  },
  {
    ARRAY_SIZE(kInstruction_smusdx_vs_r9_r6_r8),
    kInstruction_smusdx_vs_r9_r6_r8,
  },
  {
    ARRAY_SIZE(kInstruction_smusdx_cs_r14_r11_r13),
    kInstruction_smusdx_cs_r14_r11_r13,
  },
  {
    ARRAY_SIZE(kInstruction_smusdx_pl_r5_r8_r4),
    kInstruction_smusdx_pl_r5_r8_r4,
  },
  {
    ARRAY_SIZE(kInstruction_smusdx_pl_r2_r3_r7),
    kInstruction_smusdx_pl_r2_r3_r7,
  },
  {
    ARRAY_SIZE(kInstruction_smusdx_cs_r7_r12_r14),
    kInstruction_smusdx_cs_r7_r12_r14,
  },
  {
    ARRAY_SIZE(kInstruction_smusdx_hi_r6_r6_r1),
    kInstruction_smusdx_hi_r6_r6_r1,
  },
  {
    ARRAY_SIZE(kInstruction_smusdx_cc_r6_r9_r6),
    kInstruction_smusdx_cc_r6_r9_r6,
  },
  {
    ARRAY_SIZE(kInstruction_smusdx_ne_r12_r12_r0),
    kInstruction_smusdx_ne_r12_r12_r0,
  },
  {
    ARRAY_SIZE(kInstruction_smusdx_cc_r9_r3_r8),
    kInstruction_smusdx_cc_r9_r3_r8,
  },
  {
    ARRAY_SIZE(kInstruction_smusdx_mi_r13_r6_r1),
    kInstruction_smusdx_mi_r13_r6_r1,
  },
  {
    ARRAY_SIZE(kInstruction_smusdx_lt_r4_r8_r6),
    kInstruction_smusdx_lt_r4_r8_r6,
  },
  {
    ARRAY_SIZE(kInstruction_smusdx_hi_r11_r5_r9),
    kInstruction_smusdx_hi_r11_r5_r9,
  },
  {
    ARRAY_SIZE(kInstruction_smusdx_cc_r6_r10_r6),
    kInstruction_smusdx_cc_r6_r10_r6,
  },
  {
    ARRAY_SIZE(kInstruction_smusdx_eq_r10_r10_r5),
    kInstruction_smusdx_eq_r10_r10_r5,
  },
  {
    ARRAY_SIZE(kInstruction_smusdx_al_r5_r4_r11),
    kInstruction_smusdx_al_r5_r4_r11,
  },
  {
    ARRAY_SIZE(kInstruction_smusdx_pl_r11_r11_r2),
    kInstruction_smusdx_pl_r11_r11_r2,
  },
  {
    ARRAY_SIZE(kInstruction_smusdx_ls_r6_r14_r12),
    kInstruction_smusdx_ls_r6_r14_r12,
  },
  {
    ARRAY_SIZE(kInstruction_smusdx_vc_r7_r7_r2),
    kInstruction_smusdx_vc_r7_r7_r2,
  },
  {
    ARRAY_SIZE(kInstruction_smusdx_eq_r10_r8_r4),
    kInstruction_smusdx_eq_r10_r8_r4,
  },
  {
    ARRAY_SIZE(kInstruction_smusdx_al_r14_r7_r2),
    kInstruction_smusdx_al_r14_r7_r2,
  },
  {
    ARRAY_SIZE(kInstruction_smusdx_cs_r3_r11_r10),
    kInstruction_smusdx_cs_r3_r11_r10,
  },
  {
    ARRAY_SIZE(kInstruction_smusdx_ls_r11_r4_r0),
    kInstruction_smusdx_ls_r11_r4_r0,
  },
  {
    ARRAY_SIZE(kInstruction_smusdx_hi_r11_r8_r9),
    kInstruction_smusdx_hi_r11_r8_r9,
  },
  {
    ARRAY_SIZE(kInstruction_smusdx_vs_r2_r14_r13),
    kInstruction_smusdx_vs_r2_r14_r13,
  },
  {
    ARRAY_SIZE(kInstruction_smusdx_al_r1_r13_r9),
    kInstruction_smusdx_al_r1_r13_r9,
  },
  {
    ARRAY_SIZE(kInstruction_smusdx_eq_r3_r9_r13),
    kInstruction_smusdx_eq_r3_r9_r13,
  },
  {
    ARRAY_SIZE(kInstruction_smusdx_ge_r10_r3_r13),
    kInstruction_smusdx_ge_r10_r3_r13,
  },
  {
    ARRAY_SIZE(kInstruction_smusdx_pl_r8_r5_r10),
    kInstruction_smusdx_pl_r8_r5_r10,
  },
  {
    ARRAY_SIZE(kInstruction_smusdx_vc_r8_r11_r6),
    kInstruction_smusdx_vc_r8_r11_r6,
  },
  {
    ARRAY_SIZE(kInstruction_smusdx_eq_r0_r0_r5),
    kInstruction_smusdx_eq_r0_r0_r5,
  },
  {
    ARRAY_SIZE(kInstruction_smusdx_ne_r6_r5_r8),
    kInstruction_smusdx_ne_r6_r5_r8,
  },
  {
    ARRAY_SIZE(kInstruction_smusdx_hi_r5_r13_r3),
    kInstruction_smusdx_hi_r5_r13_r3,
  },
  {
    ARRAY_SIZE(kInstruction_smusdx_ne_r11_r14_r14),
    kInstruction_smusdx_ne_r11_r14_r14,
  },
  {
    ARRAY_SIZE(kInstruction_smusdx_mi_r1_r0_r6),
    kInstruction_smusdx_mi_r1_r0_r6,
  },
  {
    ARRAY_SIZE(kInstruction_smusdx_le_r14_r8_r2),
    kInstruction_smusdx_le_r14_r8_r2,
  },
  {
    ARRAY_SIZE(kInstruction_smusdx_eq_r9_r6_r5),
    kInstruction_smusdx_eq_r9_r6_r5,
  },
  {
    ARRAY_SIZE(kInstruction_smusdx_eq_r11_r0_r13),
    kInstruction_smusdx_eq_r11_r0_r13,
  },
  {
    ARRAY_SIZE(kInstruction_smusdx_pl_r4_r5_r14),
    kInstruction_smusdx_pl_r4_r5_r14,
  },
  {
    ARRAY_SIZE(kInstruction_smusdx_cs_r13_r5_r13),
    kInstruction_smusdx_cs_r13_r5_r13,
  },
  {
    ARRAY_SIZE(kInstruction_smusdx_mi_r0_r13_r8),
    kInstruction_smusdx_mi_r0_r13_r8,
  },
  {
    ARRAY_SIZE(kInstruction_smusdx_lt_r2_r13_r3),
    kInstruction_smusdx_lt_r2_r13_r3,
  },
  {
    ARRAY_SIZE(kInstruction_smusdx_ls_r8_r1_r11),
    kInstruction_smusdx_ls_r8_r1_r11,
  },
  {
    ARRAY_SIZE(kInstruction_smusdx_vc_r14_r11_r8),
    kInstruction_smusdx_vc_r14_r11_r8,
  },
  {
    ARRAY_SIZE(kInstruction_smusdx_lt_r4_r13_r12),
    kInstruction_smusdx_lt_r4_r13_r12,
  },
  {
    ARRAY_SIZE(kInstruction_smusdx_eq_r2_r1_r14),
    kInstruction_smusdx_eq_r2_r1_r14,
  },
  {
    ARRAY_SIZE(kInstruction_smusdx_eq_r9_r4_r14),
    kInstruction_smusdx_eq_r9_r4_r14,
  },
  {
    ARRAY_SIZE(kInstruction_smusdx_hi_r10_r6_r13),
    kInstruction_smusdx_hi_r10_r6_r13,
  },
  {
    ARRAY_SIZE(kInstruction_smusdx_ge_r12_r9_r4),
    kInstruction_smusdx_ge_r12_r9_r4,
  },
  {
    ARRAY_SIZE(kInstruction_smusdx_le_r9_r11_r14),
    kInstruction_smusdx_le_r9_r11_r14,
  },
  {
    ARRAY_SIZE(kInstruction_smusdx_ls_r0_r9_r5),
    kInstruction_smusdx_ls_r0_r9_r5,
  },
  {
    ARRAY_SIZE(kInstruction_smusdx_mi_r2_r3_r8),
    kInstruction_smusdx_mi_r2_r3_r8,
  },
  {
    ARRAY_SIZE(kInstruction_smusdx_ne_r14_r10_r14),
    kInstruction_smusdx_ne_r14_r10_r14,
  },
  {
    ARRAY_SIZE(kInstruction_smusdx_eq_r6_r2_r10),
    kInstruction_smusdx_eq_r6_r2_r10,
  },
  {
    ARRAY_SIZE(kInstruction_smusdx_lt_r11_r0_r12),
    kInstruction_smusdx_lt_r11_r0_r12,
  },
  {
    ARRAY_SIZE(kInstruction_smusdx_ne_r1_r12_r10),
    kInstruction_smusdx_ne_r1_r12_r10,
  },
  {
    ARRAY_SIZE(kInstruction_smusdx_cc_r1_r0_r2),
    kInstruction_smusdx_cc_r1_r0_r2,
  },
  {
    ARRAY_SIZE(kInstruction_smusdx_al_r5_r5_r7),
    kInstruction_smusdx_al_r5_r5_r7,
  },
  {
    ARRAY_SIZE(kInstruction_smusdx_hi_r7_r13_r1),
    kInstruction_smusdx_hi_r7_r13_r1,
  },
  {
    ARRAY_SIZE(kInstruction_smusdx_cs_r4_r4_r9),
    kInstruction_smusdx_cs_r4_r4_r9,
  },
  {
    ARRAY_SIZE(kInstruction_smusdx_eq_r14_r4_r14),
    kInstruction_smusdx_eq_r14_r4_r14,
  },
  {
    ARRAY_SIZE(kInstruction_smusdx_vs_r10_r5_r14),
    kInstruction_smusdx_vs_r10_r5_r14,
  },
  {
    ARRAY_SIZE(kInstruction_smusdx_gt_r4_r3_r11),
    kInstruction_smusdx_gt_r4_r3_r11,
  },
  {
    ARRAY_SIZE(kInstruction_smusdx_ne_r14_r10_r12),
    kInstruction_smusdx_ne_r14_r10_r12,
  },
  {
    ARRAY_SIZE(kInstruction_smusdx_vs_r2_r11_r0),
    kInstruction_smusdx_vs_r2_r11_r0,
  },
  {
    ARRAY_SIZE(kInstruction_smusdx_ge_r5_r12_r7),
    kInstruction_smusdx_ge_r5_r12_r7,
  },
  {
    ARRAY_SIZE(kInstruction_smusdx_mi_r7_r14_r6),
    kInstruction_smusdx_mi_r7_r14_r6,
  },
  {
    ARRAY_SIZE(kInstruction_smusdx_gt_r8_r3_r8),
    kInstruction_smusdx_gt_r8_r3_r8,
  },
  {
    ARRAY_SIZE(kInstruction_smusdx_hi_r9_r14_r3),
    kInstruction_smusdx_hi_r9_r14_r3,
  },
  {
    ARRAY_SIZE(kInstruction_smusdx_vc_r2_r11_r2),
    kInstruction_smusdx_vc_r2_r11_r2,
  },
  {
    ARRAY_SIZE(kInstruction_smusdx_hi_r11_r7_r12),
    kInstruction_smusdx_hi_r11_r7_r12,
  },
  {
    ARRAY_SIZE(kInstruction_smusdx_cs_r6_r4_r11),
    kInstruction_smusdx_cs_r6_r4_r11,
  },
  {
    ARRAY_SIZE(kInstruction_smusdx_cs_r12_r5_r9),
    kInstruction_smusdx_cs_r12_r5_r9,
  },
  {
    ARRAY_SIZE(kInstruction_smusdx_ls_r5_r10_r5),
    kInstruction_smusdx_ls_r5_r10_r5,
  },
  {
    ARRAY_SIZE(kInstruction_smusdx_ls_r0_r9_r13),
    kInstruction_smusdx_ls_r0_r9_r13,
  },
  {
    ARRAY_SIZE(kInstruction_smusdx_lt_r3_r3_r5),
    kInstruction_smusdx_lt_r3_r3_r5,
  },
  {
    ARRAY_SIZE(kInstruction_smusdx_mi_r0_r12_r8),
    kInstruction_smusdx_mi_r0_r12_r8,
  },
  {
    ARRAY_SIZE(kInstruction_smusdx_pl_r3_r12_r12),
    kInstruction_smusdx_pl_r3_r12_r12,
  },
  {
    ARRAY_SIZE(kInstruction_smusdx_eq_r8_r12_r5),
    kInstruction_smusdx_eq_r8_r12_r5,
  },
  {
    ARRAY_SIZE(kInstruction_smusdx_cc_r7_r8_r1),
    kInstruction_smusdx_cc_r7_r8_r1,
  },
  {
    ARRAY_SIZE(kInstruction_smusdx_hi_r2_r13_r10),
    kInstruction_smusdx_hi_r2_r13_r10,
  },
  {
    ARRAY_SIZE(kInstruction_smusdx_al_r7_r10_r10),
    kInstruction_smusdx_al_r7_r10_r10,
  },
  {
    ARRAY_SIZE(kInstruction_smusdx_vc_r1_r12_r2),
    kInstruction_smusdx_vc_r1_r12_r2,
  },
  {
    ARRAY_SIZE(kInstruction_smusdx_cc_r8_r5_r8),
    kInstruction_smusdx_cc_r8_r5_r8,
  },
  {
    ARRAY_SIZE(kInstruction_smusdx_ls_r3_r7_r9),
    kInstruction_smusdx_ls_r3_r7_r9,
  },
  {
    ARRAY_SIZE(kInstruction_smusdx_al_r8_r10_r8),
    kInstruction_smusdx_al_r8_r10_r8,
  },
  {
    ARRAY_SIZE(kInstruction_smusdx_lt_r4_r12_r10),
    kInstruction_smusdx_lt_r4_r12_r10,
  },
  {
    ARRAY_SIZE(kInstruction_smusdx_ge_r10_r5_r11),
    kInstruction_smusdx_ge_r10_r5_r11,
  },
  {
    ARRAY_SIZE(kInstruction_smusdx_ls_r3_r14_r4),
    kInstruction_smusdx_ls_r3_r14_r4,
  },
  {
    ARRAY_SIZE(kInstruction_smusdx_hi_r3_r6_r12),
    kInstruction_smusdx_hi_r3_r6_r12,
  },
  {
    ARRAY_SIZE(kInstruction_smusdx_hi_r6_r0_r4),
    kInstruction_smusdx_hi_r6_r0_r4,
  },
  {
    ARRAY_SIZE(kInstruction_smusdx_al_r11_r6_r0),
    kInstruction_smusdx_al_r11_r6_r0,
  },
  {
    ARRAY_SIZE(kInstruction_smusdx_mi_r3_r1_r9),
    kInstruction_smusdx_mi_r3_r1_r9,
  },
  {
    ARRAY_SIZE(kInstruction_smusdx_mi_r12_r13_r0),
    kInstruction_smusdx_mi_r12_r13_r0,
  },
  {
    ARRAY_SIZE(kInstruction_smusdx_le_r1_r2_r5),
    kInstruction_smusdx_le_r1_r2_r5,
  },
  {
    ARRAY_SIZE(kInstruction_smusdx_hi_r4_r3_r14),
    kInstruction_smusdx_hi_r4_r3_r14,
  },
  {
    ARRAY_SIZE(kInstruction_smusdx_eq_r6_r11_r11),
    kInstruction_smusdx_eq_r6_r11_r11,
  },
  {
    ARRAY_SIZE(kInstruction_smusdx_cc_r14_r11_r14),
    kInstruction_smusdx_cc_r14_r11_r14,
  },
  {
    ARRAY_SIZE(kInstruction_smusdx_hi_r4_r10_r0),
    kInstruction_smusdx_hi_r4_r10_r0,
  },
  {
    ARRAY_SIZE(kInstruction_smusdx_cc_r7_r11_r1),
    kInstruction_smusdx_cc_r7_r11_r1,
  },
  {
    ARRAY_SIZE(kInstruction_smusdx_mi_r14_r6_r10),
    kInstruction_smusdx_mi_r14_r6_r10,
  },
  {
    ARRAY_SIZE(kInstruction_smusdx_eq_r2_r0_r11),
    kInstruction_smusdx_eq_r2_r0_r11,
  },
  {
    ARRAY_SIZE(kInstruction_smusdx_mi_r13_r5_r12),
    kInstruction_smusdx_mi_r13_r5_r12,
  },
  {
    ARRAY_SIZE(kInstruction_smusdx_eq_r2_r12_r5),
    kInstruction_smusdx_eq_r2_r12_r5,
  },
  {
    ARRAY_SIZE(kInstruction_smusdx_le_r12_r0_r2),
    kInstruction_smusdx_le_r12_r0_r2,
  },
  {
    ARRAY_SIZE(kInstruction_smusdx_vc_r10_r10_r9),
    kInstruction_smusdx_vc_r10_r10_r9,
  },
  {
    ARRAY_SIZE(kInstruction_smusdx_ls_r11_r11_r8),
    kInstruction_smusdx_ls_r11_r11_r8,
  },
  {
    ARRAY_SIZE(kInstruction_smusdx_hi_r10_r11_r9),
    kInstruction_smusdx_hi_r10_r11_r9,
  },
  {
    ARRAY_SIZE(kInstruction_smusdx_vs_r7_r12_r14),
    kInstruction_smusdx_vs_r7_r12_r14,
  },
  {
    ARRAY_SIZE(kInstruction_smusdx_gt_r11_r14_r12),
    kInstruction_smusdx_gt_r11_r14_r12,
  },
  {
    ARRAY_SIZE(kInstruction_smusdx_vs_r0_r12_r8),
    kInstruction_smusdx_vs_r0_r12_r8,
  },
  {
    ARRAY_SIZE(kInstruction_smusdx_al_r0_r5_r7),
    kInstruction_smusdx_al_r0_r5_r7,
  },
  {
    ARRAY_SIZE(kInstruction_smusdx_hi_r5_r13_r8),
    kInstruction_smusdx_hi_r5_r13_r8,
  },
  {
    ARRAY_SIZE(kInstruction_smusdx_le_r9_r9_r7),
    kInstruction_smusdx_le_r9_r9_r7,
  },
  {
    ARRAY_SIZE(kInstruction_smusdx_cc_r4_r9_r5),
    kInstruction_smusdx_cc_r4_r9_r5,
  },
  {
    ARRAY_SIZE(kInstruction_smusdx_vs_r8_r1_r3),
    kInstruction_smusdx_vs_r8_r1_r3,
  },
  {
    ARRAY_SIZE(kInstruction_smusdx_cc_r0_r10_r12),
    kInstruction_smusdx_cc_r0_r10_r12,
  },
  {
    ARRAY_SIZE(kInstruction_smusdx_eq_r7_r14_r0),
    kInstruction_smusdx_eq_r7_r14_r0,
  },
  {
    ARRAY_SIZE(kInstruction_smusdx_vs_r12_r9_r11),
    kInstruction_smusdx_vs_r12_r9_r11,
  },
  {
    ARRAY_SIZE(kInstruction_smusdx_gt_r5_r9_r11),
    kInstruction_smusdx_gt_r5_r9_r11,
  },
  {
    ARRAY_SIZE(kInstruction_smusdx_cs_r14_r13_r7),
    kInstruction_smusdx_cs_r14_r13_r7,
  },
  {
    ARRAY_SIZE(kInstruction_smusdx_mi_r11_r3_r10),
    kInstruction_smusdx_mi_r11_r3_r10,
  },
  {
    ARRAY_SIZE(kInstruction_smusdx_hi_r11_r8_r12),
    kInstruction_smusdx_hi_r11_r8_r12,
  },
  {
    ARRAY_SIZE(kInstruction_smusdx_cs_r3_r8_r13),
    kInstruction_smusdx_cs_r3_r8_r13,
  },
  {
    ARRAY_SIZE(kInstruction_smusdx_pl_r10_r12_r6),
    kInstruction_smusdx_pl_r10_r12_r6,
  },
  {
    ARRAY_SIZE(kInstruction_smusdx_vc_r7_r3_r2),
    kInstruction_smusdx_vc_r7_r3_r2,
  },
  {
    ARRAY_SIZE(kInstruction_smusdx_mi_r9_r0_r8),
    kInstruction_smusdx_mi_r9_r0_r8,
  },
  {
    ARRAY_SIZE(kInstruction_smusdx_eq_r2_r13_r7),
    kInstruction_smusdx_eq_r2_r13_r7,
  },
  {
    ARRAY_SIZE(kInstruction_smusdx_ne_r2_r14_r0),
    kInstruction_smusdx_ne_r2_r14_r0,
  },
  {
    ARRAY_SIZE(kInstruction_smusdx_vs_r4_r10_r0),
    kInstruction_smusdx_vs_r4_r10_r0,
  },
  {
    ARRAY_SIZE(kInstruction_smusdx_ls_r0_r2_r2),
    kInstruction_smusdx_ls_r0_r2_r2,
  },
  {
    ARRAY_SIZE(kInstruction_smusdx_cc_r1_r6_r0),
    kInstruction_smusdx_cc_r1_r6_r0,
  },
  {
    ARRAY_SIZE(kInstruction_smusdx_lt_r12_r0_r8),
    kInstruction_smusdx_lt_r12_r0_r8,
  },
  {
    ARRAY_SIZE(kInstruction_smusdx_cc_r9_r3_r14),
    kInstruction_smusdx_cc_r9_r3_r14,
  },
  {
    ARRAY_SIZE(kInstruction_smusdx_vs_r7_r9_r1),
    kInstruction_smusdx_vs_r7_r9_r1,
  },
  {
    ARRAY_SIZE(kInstruction_smusdx_eq_r11_r9_r14),
    kInstruction_smusdx_eq_r11_r9_r14,
  },
  {
    ARRAY_SIZE(kInstruction_smusdx_pl_r6_r10_r4),
    kInstruction_smusdx_pl_r6_r10_r4,
  },
  {
    ARRAY_SIZE(kInstruction_smusdx_ne_r8_r5_r6),
    kInstruction_smusdx_ne_r8_r5_r6,
  },
  {
    ARRAY_SIZE(kInstruction_smusdx_cs_r0_r6_r2),
    kInstruction_smusdx_cs_r0_r6_r2,
  },
  {
    ARRAY_SIZE(kInstruction_smusdx_eq_r11_r12_r4),
    kInstruction_smusdx_eq_r11_r12_r4,
  },
  {
    ARRAY_SIZE(kInstruction_smusdx_lt_r14_r3_r14),
    kInstruction_smusdx_lt_r14_r3_r14,
  },
  {
    ARRAY_SIZE(kInstruction_smusdx_le_r7_r12_r14),
    kInstruction_smusdx_le_r7_r12_r14,
  },
  {
    ARRAY_SIZE(kInstruction_smusdx_hi_r2_r9_r9),
    kInstruction_smusdx_hi_r2_r9_r9,
  },
  {
    ARRAY_SIZE(kInstruction_smusdx_ne_r8_r1_r0),
    kInstruction_smusdx_ne_r8_r1_r0,
  },
  {
    ARRAY_SIZE(kInstruction_smusdx_cc_r5_r11_r2),
    kInstruction_smusdx_cc_r5_r11_r2,
  },
  {
    ARRAY_SIZE(kInstruction_smusdx_hi_r0_r1_r2),
    kInstruction_smusdx_hi_r0_r1_r2,
  },
  {
    ARRAY_SIZE(kInstruction_smusdx_al_r4_r9_r4),
    kInstruction_smusdx_al_r4_r9_r4,
  },
  {
    ARRAY_SIZE(kInstruction_smusdx_cs_r12_r7_r14),
    kInstruction_smusdx_cs_r12_r7_r14,
  },
  {
    ARRAY_SIZE(kInstruction_smusdx_cc_r4_r12_r10),
    kInstruction_smusdx_cc_r4_r12_r10,
  },
  {
    ARRAY_SIZE(kInstruction_smusdx_al_r3_r5_r10),
    kInstruction_smusdx_al_r3_r5_r10,
  },
  {
    ARRAY_SIZE(kInstruction_smusdx_mi_r5_r3_r7),
    kInstruction_smusdx_mi_r5_r3_r7,
  },
  {
    ARRAY_SIZE(kInstruction_smusdx_ls_r10_r6_r2),
    kInstruction_smusdx_ls_r10_r6_r2,
  },
  {
    ARRAY_SIZE(kInstruction_smusdx_mi_r0_r12_r11),
    kInstruction_smusdx_mi_r0_r12_r11,
  },
  {
    ARRAY_SIZE(kInstruction_smusdx_vc_r12_r5_r6),
    kInstruction_smusdx_vc_r12_r5_r6,
  },
  {
    ARRAY_SIZE(kInstruction_smusdx_cs_r3_r9_r4),
    kInstruction_smusdx_cs_r3_r9_r4,
  },
  {
    ARRAY_SIZE(kInstruction_smusdx_ls_r4_r9_r11),
    kInstruction_smusdx_ls_r4_r9_r11,
  },
  {
    ARRAY_SIZE(kInstruction_smusdx_le_r14_r8_r13),
    kInstruction_smusdx_le_r14_r8_r13,
  },
  {
    ARRAY_SIZE(kInstruction_smusdx_gt_r4_r10_r8),
    kInstruction_smusdx_gt_r4_r10_r8,
  },
  {
    ARRAY_SIZE(kInstruction_smusdx_al_r6_r9_r9),
    kInstruction_smusdx_al_r6_r9_r9,
  },
  {
    ARRAY_SIZE(kInstruction_smusdx_ne_r8_r5_r12),
    kInstruction_smusdx_ne_r8_r5_r12,
  },
  {
    ARRAY_SIZE(kInstruction_smusdx_ne_r0_r4_r8),
    kInstruction_smusdx_ne_r0_r4_r8,
  },
  {
    ARRAY_SIZE(kInstruction_smusdx_mi_r7_r13_r3),
    kInstruction_smusdx_mi_r7_r13_r3,
  },
  {
    ARRAY_SIZE(kInstruction_smusdx_cc_r11_r7_r0),
    kInstruction_smusdx_cc_r11_r7_r0,
  },
  {
    ARRAY_SIZE(kInstruction_smusdx_hi_r1_r0_r12),
    kInstruction_smusdx_hi_r1_r0_r12,
  },
  {
    ARRAY_SIZE(kInstruction_smusdx_lt_r8_r9_r3),
    kInstruction_smusdx_lt_r8_r9_r3,
  },
  {
    ARRAY_SIZE(kInstruction_smusdx_al_r0_r2_r1),
    kInstruction_smusdx_al_r0_r2_r1,
  },
  {
    ARRAY_SIZE(kInstruction_smusdx_vs_r4_r3_r14),
    kInstruction_smusdx_vs_r4_r3_r14,
  },
  {
    ARRAY_SIZE(kInstruction_smusdx_ge_r2_r11_r1),
    kInstruction_smusdx_ge_r2_r11_r1,
  },
  {
    ARRAY_SIZE(kInstruction_smusdx_lt_r12_r9_r6),
    kInstruction_smusdx_lt_r12_r9_r6,
  },
  {
    ARRAY_SIZE(kInstruction_smusdx_ls_r8_r2_r7),
    kInstruction_smusdx_ls_r8_r2_r7,
  },
  {
    ARRAY_SIZE(kInstruction_smusdx_le_r8_r13_r3),
    kInstruction_smusdx_le_r8_r13_r3,
  },
  {
    ARRAY_SIZE(kInstruction_smusdx_eq_r11_r13_r14),
    kInstruction_smusdx_eq_r11_r13_r14,
  },
  {
    ARRAY_SIZE(kInstruction_smusdx_lt_r1_r6_r13),
    kInstruction_smusdx_lt_r1_r6_r13,
  },
  {
    ARRAY_SIZE(kInstruction_smusdx_cs_r3_r8_r11),
    kInstruction_smusdx_cs_r3_r8_r11,
  },
  {
    ARRAY_SIZE(kInstruction_smusdx_pl_r12_r5_r4),
    kInstruction_smusdx_pl_r12_r5_r4,
  },
  {
    ARRAY_SIZE(kInstruction_smusdx_eq_r8_r7_r2),
    kInstruction_smusdx_eq_r8_r7_r2,
  },
  {
    ARRAY_SIZE(kInstruction_smusdx_ls_r2_r12_r2),
    kInstruction_smusdx_ls_r2_r12_r2,
  },
  {
    ARRAY_SIZE(kInstruction_smusdx_le_r14_r2_r3),
    kInstruction_smusdx_le_r14_r2_r3,
  },
  {
    ARRAY_SIZE(kInstruction_smusdx_ge_r10_r11_r6),
    kInstruction_smusdx_ge_r10_r11_r6,
  },
  {
    ARRAY_SIZE(kInstruction_smusdx_hi_r0_r2_r2),
    kInstruction_smusdx_hi_r0_r2_r2,
  },
  {
    ARRAY_SIZE(kInstruction_smusdx_ge_r2_r0_r2),
    kInstruction_smusdx_ge_r2_r0_r2,
  },
  {
    ARRAY_SIZE(kInstruction_smusdx_vs_r11_r14_r0),
    kInstruction_smusdx_vs_r11_r14_r0,
  },
  {
    ARRAY_SIZE(kInstruction_smusdx_lt_r2_r0_r1),
    kInstruction_smusdx_lt_r2_r0_r1,
  },
  {
    ARRAY_SIZE(kInstruction_smusdx_cs_r2_r5_r11),
    kInstruction_smusdx_cs_r2_r5_r11,
  },
  {
    ARRAY_SIZE(kInstruction_smusdx_ls_r7_r14_r5),
    kInstruction_smusdx_ls_r7_r14_r5,
  },
  {
    ARRAY_SIZE(kInstruction_smusdx_pl_r0_r0_r3),
    kInstruction_smusdx_pl_r0_r0_r3,
  },
  {
    ARRAY_SIZE(kInstruction_smusdx_ge_r6_r8_r8),
    kInstruction_smusdx_ge_r6_r8_r8,
  },
  {
    ARRAY_SIZE(kInstruction_smusdx_le_r11_r1_r10),
    kInstruction_smusdx_le_r11_r1_r10,
  },
  {
    ARRAY_SIZE(kInstruction_smusdx_vs_r5_r2_r7),
    kInstruction_smusdx_vs_r5_r2_r7,
  },
  {
    ARRAY_SIZE(kInstruction_smusdx_ne_r4_r4_r8),
    kInstruction_smusdx_ne_r4_r4_r8,
  },
  {
    ARRAY_SIZE(kInstruction_smusdx_cc_r9_r14_r13),
    kInstruction_smusdx_cc_r9_r14_r13,
  },
  {
    ARRAY_SIZE(kInstruction_smusdx_hi_r14_r6_r3),
    kInstruction_smusdx_hi_r14_r6_r3,
  },
  {
    ARRAY_SIZE(kInstruction_smusdx_al_r0_r8_r0),
    kInstruction_smusdx_al_r0_r8_r0,
  },
  {
    ARRAY_SIZE(kInstruction_smusdx_lt_r6_r11_r1),
    kInstruction_smusdx_lt_r6_r11_r1,
  },
  {
    ARRAY_SIZE(kInstruction_smusdx_ge_r7_r6_r12),
    kInstruction_smusdx_ge_r7_r6_r12,
  },
  {
    ARRAY_SIZE(kInstruction_smusdx_cs_r4_r6_r14),
    kInstruction_smusdx_cs_r4_r6_r14,
  },
  {
    ARRAY_SIZE(kInstruction_smusdx_cs_r7_r6_r7),
    kInstruction_smusdx_cs_r7_r6_r7,
  },
  {
    ARRAY_SIZE(kInstruction_smusdx_cs_r3_r7_r10),
    kInstruction_smusdx_cs_r3_r7_r10,
  },
  {
    ARRAY_SIZE(kInstruction_smusdx_ne_r0_r2_r1),
    kInstruction_smusdx_ne_r0_r2_r1,
  },
  {
    ARRAY_SIZE(kInstruction_smusdx_vs_r9_r10_r13),
    kInstruction_smusdx_vs_r9_r10_r13,
  },
  {
    ARRAY_SIZE(kInstruction_smusdx_vc_r11_r14_r12),
    kInstruction_smusdx_vc_r11_r14_r12,
  },
  {
    ARRAY_SIZE(kInstruction_smusdx_ge_r14_r8_r7),
    kInstruction_smusdx_ge_r14_r8_r7,
  },
  {
    ARRAY_SIZE(kInstruction_smusdx_lt_r13_r0_r11),
    kInstruction_smusdx_lt_r13_r0_r11,
  },
  {
    ARRAY_SIZE(kInstruction_smusdx_lt_r14_r13_r4),
    kInstruction_smusdx_lt_r14_r13_r4,
  },
  {
    ARRAY_SIZE(kInstruction_smusdx_al_r1_r10_r9),
    kInstruction_smusdx_al_r1_r10_r9,
  },
  {
    ARRAY_SIZE(kInstruction_smusdx_ge_r11_r14_r11),
    kInstruction_smusdx_ge_r11_r14_r11,
  },
  {
    ARRAY_SIZE(kInstruction_smusdx_cs_r11_r4_r11),
    kInstruction_smusdx_cs_r11_r4_r11,
  },
  {
    ARRAY_SIZE(kInstruction_smusdx_ge_r0_r14_r7),
    kInstruction_smusdx_ge_r0_r14_r7,
  },
  {
    ARRAY_SIZE(kInstruction_smusdx_mi_r1_r2_r9),
    kInstruction_smusdx_mi_r1_r2_r9,
  },
  {
    ARRAY_SIZE(kInstruction_smusdx_eq_r5_r12_r3),
    kInstruction_smusdx_eq_r5_r12_r3,
  },
  {
    ARRAY_SIZE(kInstruction_smusdx_ge_r1_r5_r12),
    kInstruction_smusdx_ge_r1_r5_r12,
  },
  {
    ARRAY_SIZE(kInstruction_smusdx_lt_r10_r11_r4),
    kInstruction_smusdx_lt_r10_r11_r4,
  },
  {
    ARRAY_SIZE(kInstruction_smusdx_le_r1_r1_r5),
    kInstruction_smusdx_le_r1_r1_r5,
  },
  {
    ARRAY_SIZE(kInstruction_smusdx_al_r9_r1_r8),
    kInstruction_smusdx_al_r9_r1_r8,
  },
  {
    ARRAY_SIZE(kInstruction_smusdx_ne_r6_r8_r4),
    kInstruction_smusdx_ne_r6_r8_r4,
  },
  {
    ARRAY_SIZE(kInstruction_smusdx_ge_r12_r2_r9),
    kInstruction_smusdx_ge_r12_r2_r9,
  },
  {
    ARRAY_SIZE(kInstruction_smusdx_pl_r4_r3_r10),
    kInstruction_smusdx_pl_r4_r3_r10,
  },
  {
    ARRAY_SIZE(kInstruction_smusdx_eq_r14_r4_r11),
    kInstruction_smusdx_eq_r14_r4_r11,
  },
  {
    ARRAY_SIZE(kInstruction_smusdx_cc_r9_r7_r6),
    kInstruction_smusdx_cc_r9_r7_r6,
  },
  {
    ARRAY_SIZE(kInstruction_smusdx_ge_r12_r4_r5),
    kInstruction_smusdx_ge_r12_r4_r5,
  },
  {
    ARRAY_SIZE(kInstruction_smusdx_hi_r2_r3_r4),
    kInstruction_smusdx_hi_r2_r3_r4,
  },
  {
    ARRAY_SIZE(kInstruction_smusdx_cs_r0_r3_r1),
    kInstruction_smusdx_cs_r0_r3_r1,
  },
  {
    ARRAY_SIZE(kInstruction_smusdx_hi_r6_r2_r8),
    kInstruction_smusdx_hi_r6_r2_r8,
  },
  {
    ARRAY_SIZE(kInstruction_smusdx_cc_r3_r14_r13),
    kInstruction_smusdx_cc_r3_r14_r13,
  },
  {
    ARRAY_SIZE(kInstruction_smusdx_gt_r11_r4_r7),
    kInstruction_smusdx_gt_r11_r4_r7,
  },
  {
    ARRAY_SIZE(kInstruction_smusdx_hi_r5_r0_r12),
    kInstruction_smusdx_hi_r5_r0_r12,
  },
  {
    ARRAY_SIZE(kInstruction_smusdx_gt_r0_r14_r14),
    kInstruction_smusdx_gt_r0_r14_r14,
  },
  {
    ARRAY_SIZE(kInstruction_smusdx_hi_r9_r0_r10),
    kInstruction_smusdx_hi_r9_r0_r10,
  },
  {
    ARRAY_SIZE(kInstruction_smusdx_vc_r7_r11_r8),
    kInstruction_smusdx_vc_r7_r11_r8,
  },
  {
    ARRAY_SIZE(kInstruction_smusdx_pl_r11_r9_r6),
    kInstruction_smusdx_pl_r11_r9_r6,
  },
  {
    ARRAY_SIZE(kInstruction_smusdx_al_r3_r3_r7),
    kInstruction_smusdx_al_r3_r3_r7,
  },
  {
    ARRAY_SIZE(kInstruction_smusdx_mi_r5_r7_r9),
    kInstruction_smusdx_mi_r5_r7_r9,
  },
  {
    ARRAY_SIZE(kInstruction_smusdx_cc_r11_r2_r4),
    kInstruction_smusdx_cc_r11_r2_r4,
  },
  {
    ARRAY_SIZE(kInstruction_smusdx_cc_r9_r13_r10),
    kInstruction_smusdx_cc_r9_r13_r10,
  },
  {
    ARRAY_SIZE(kInstruction_smusdx_al_r5_r2_r6),
    kInstruction_smusdx_al_r5_r2_r6,
  },
  {
    ARRAY_SIZE(kInstruction_smusdx_ge_r9_r4_r6),
    kInstruction_smusdx_ge_r9_r4_r6,
  },
  {
    ARRAY_SIZE(kInstruction_smusdx_ls_r3_r3_r4),
    kInstruction_smusdx_ls_r3_r3_r4,
  },
  {
    ARRAY_SIZE(kInstruction_smusdx_ge_r14_r1_r8),
    kInstruction_smusdx_ge_r14_r1_r8,
  },
  {
    ARRAY_SIZE(kInstruction_smusdx_ls_r7_r12_r7),
    kInstruction_smusdx_ls_r7_r12_r7,
  },
  {
    ARRAY_SIZE(kInstruction_smusdx_al_r11_r10_r5),
    kInstruction_smusdx_al_r11_r10_r5,
  },
  {
    ARRAY_SIZE(kInstruction_smusdx_al_r7_r4_r6),
    kInstruction_smusdx_al_r7_r4_r6,
  },
  {
    ARRAY_SIZE(kInstruction_smusdx_vs_r12_r4_r10),
    kInstruction_smusdx_vs_r12_r4_r10,
  },
  {
    ARRAY_SIZE(kInstruction_smusdx_eq_r4_r4_r4),
    kInstruction_smusdx_eq_r4_r4_r4,
  },
  {
    ARRAY_SIZE(kInstruction_smusdx_vs_r6_r6_r12),
    kInstruction_smusdx_vs_r6_r6_r12,
  },
  {
    ARRAY_SIZE(kInstruction_smusdx_pl_r9_r3_r5),
    kInstruction_smusdx_pl_r9_r3_r5,
  },
  {
    ARRAY_SIZE(kInstruction_smusdx_eq_r6_r5_r13),
    kInstruction_smusdx_eq_r6_r5_r13,
  },
  {
    ARRAY_SIZE(kInstruction_smusdx_cc_r8_r2_r12),
    kInstruction_smusdx_cc_r8_r2_r12,
  },
  {
    ARRAY_SIZE(kInstruction_smusdx_le_r4_r2_r0),
    kInstruction_smusdx_le_r4_r2_r0,
  },
  {
    ARRAY_SIZE(kInstruction_smusdx_lt_r7_r9_r8),
    kInstruction_smusdx_lt_r7_r9_r8,
  },
  {
    ARRAY_SIZE(kInstruction_smusdx_le_r4_r7_r11),
    kInstruction_smusdx_le_r4_r7_r11,
  },
  {
    ARRAY_SIZE(kInstruction_smusdx_eq_r5_r7_r5),
    kInstruction_smusdx_eq_r5_r7_r5,
  },
  {
    ARRAY_SIZE(kInstruction_smusdx_vc_r10_r7_r12),
    kInstruction_smusdx_vc_r10_r7_r12,
  },
  {
    ARRAY_SIZE(kInstruction_smusdx_eq_r7_r10_r6),
    kInstruction_smusdx_eq_r7_r10_r6,
  },
  {
    ARRAY_SIZE(kInstruction_smusdx_pl_r1_r12_r2),
    kInstruction_smusdx_pl_r1_r12_r2,
  },
  {
    ARRAY_SIZE(kInstruction_smusdx_le_r14_r6_r6),
    kInstruction_smusdx_le_r14_r6_r6,
  },
  {
    ARRAY_SIZE(kInstruction_smusdx_ne_r3_r8_r8),
    kInstruction_smusdx_ne_r3_r8_r8,
  },
  {
    ARRAY_SIZE(kInstruction_smusdx_eq_r4_r12_r8),
    kInstruction_smusdx_eq_r4_r12_r8,
  },
  {
    ARRAY_SIZE(kInstruction_smusdx_ge_r11_r2_r3),
    kInstruction_smusdx_ge_r11_r2_r3,
  },
  {
    ARRAY_SIZE(kInstruction_smusdx_hi_r12_r6_r11),
    kInstruction_smusdx_hi_r12_r6_r11,
  },
  {
    ARRAY_SIZE(kInstruction_smusdx_cs_r4_r5_r10),
    kInstruction_smusdx_cs_r4_r5_r10,
  },
  {
    ARRAY_SIZE(kInstruction_smusdx_ge_r10_r2_r10),
    kInstruction_smusdx_ge_r10_r2_r10,
  },
  {
    ARRAY_SIZE(kInstruction_smusdx_ge_r5_r14_r6),
    kInstruction_smusdx_ge_r5_r14_r6,
  },
  {
    ARRAY_SIZE(kInstruction_smusdx_gt_r13_r7_r5),
    kInstruction_smusdx_gt_r13_r7_r5,
  },
  {
    ARRAY_SIZE(kInstruction_smusdx_ge_r13_r4_r12),
    kInstruction_smusdx_ge_r13_r4_r12,
  },
  {
    ARRAY_SIZE(kInstruction_smusdx_lt_r8_r10_r14),
    kInstruction_smusdx_lt_r8_r10_r14,
  },
  {
    ARRAY_SIZE(kInstruction_smusdx_le_r4_r3_r13),
    kInstruction_smusdx_le_r4_r3_r13,
  },
  {
    ARRAY_SIZE(kInstruction_smusdx_pl_r0_r9_r0),
    kInstruction_smusdx_pl_r0_r9_r0,
  },
  {
    ARRAY_SIZE(kInstruction_smusdx_eq_r2_r3_r1),
    kInstruction_smusdx_eq_r2_r3_r1,
  },
  {
    ARRAY_SIZE(kInstruction_smusdx_vc_r0_r0_r3),
    kInstruction_smusdx_vc_r0_r0_r3,
  },
  {
    ARRAY_SIZE(kInstruction_smusdx_mi_r10_r8_r11),
    kInstruction_smusdx_mi_r10_r8_r11,
  },
  {
    ARRAY_SIZE(kInstruction_smusdx_mi_r5_r14_r14),
    kInstruction_smusdx_mi_r5_r14_r14,
  },
  {
    ARRAY_SIZE(kInstruction_smusdx_gt_r5_r11_r2),
    kInstruction_smusdx_gt_r5_r11_r2,
  },
  {
    ARRAY_SIZE(kInstruction_smusdx_al_r4_r7_r11),
    kInstruction_smusdx_al_r4_r7_r11,
  },
};

#endif  // VIXL_ASSEMBLER_COND_RD_RN_RM_SMUSDX_A32_H_
