#!/bin/sh
# SPDX-License-Identifier: BSD-2-Clause
# SPDX-FileCopyrightText: © 2021 Antoine Le Gonidec <vv221@dotslashplay.it>
set -o errexit

###
# Resonance
# send your bug reports to bugs@dotslashplay.it
###

script_version=20240915.1

PLAYIT_COMPATIBILITY_LEVEL='2.30'

GAME_ID='resonance'
GAME_NAME='Resonance'

ARCHIVE_BASE_1_NAME='resonance_3_0_66305.sh'
ARCHIVE_BASE_1_MD5='87786f1035c3dbe8ebc35d1fb54f6d1a'
ARCHIVE_BASE_1_SIZE='1100000'
ARCHIVE_BASE_1_VERSION='3.0-gog66305'
ARCHIVE_BASE_1_URL='https://www.gog.com/game/resonance'

ARCHIVE_BASE_0_NAME='resonance_2_2_53439.sh'
ARCHIVE_BASE_0_MD5='5c86f3f82974b65ad3d2852c6a9338ed'
ARCHIVE_BASE_0_SIZE='1200000'
ARCHIVE_BASE_0_VERSION='2.2-gog53439'

## Optional icons pack
ARCHIVE_OPTIONAL_ICONS_NAME='resonance_icons.tar.gz'
ARCHIVE_OPTIONAL_ICONS_MD5='0a24712adffd9f5f2998bf355fc161b7'
ARCHIVE_OPTIONAL_ICONS_URL='https://downloads.dotslashplay.it/games/resonance/'
CONTENT_ICONS_PATH='.'
CONTENT_ICONS_FILES='
16x16
24x24
32x32
48x48
256x256'

CONTENT_PATH_DEFAULT='data/noarch/game'
CONTENT_GAME_MAIN_FILES='
ENGV.tmp
Music
Sounds
*.ags
*.cfg
*.exe
*.ogv
*.tra
*.vox'
CONTENT_DOC_MAIN_FILES='
licenses'

APP_MAIN_SCUMMID='ags:resonance'
APP_MAIN_ICON='../support/icon.png'
APP_MAIN_ICON_0='Resonance.exe'

# Load common functions

PLAYIT_LIB_PATHS="
$PWD
${XDG_DATA_HOME:="${HOME}/.local/share"}/play.it
/usr/local/share/games/play.it
/usr/local/share/play.it
/usr/share/games/play.it
/usr/share/play.it"

if [ -z "$PLAYIT_LIB2" ]; then
	for playit_lib_path in $PLAYIT_LIB_PATHS; do
		if [ -e "${playit_lib_path}/libplayit2.sh" ]; then
			PLAYIT_LIB2="${playit_lib_path}/libplayit2.sh"
			break
		fi
	done
fi
if [ -z "$PLAYIT_LIB2" ]; then
	printf '\n\033[1;31mError:\033[0m\n'
	printf 'libplayit2.sh not found.\n'
	exit 1
fi
# shellcheck source=libplayit2.sh
. "$PLAYIT_LIB2"

# Extract game data

archive_extraction_default

# Include game data

content_inclusion_icons
content_inclusion_default

# Write launchers

launchers_generation

# Build packages

packages_generation
print_instructions

# Clean up

rm --recursive "$PLAYIT_WORKDIR"

exit 0
