We're proud to announce the new bug-fix release of darktable, 5.0.1!

The github release is here: [https://github.com/darktable-org/darktable/releases/tag/release-5.0.1](https://github.com/darktable-org/darktable/releases/tag/release-5.0.1).

To build from source, do not use the autogenerated tarball provided by GitHub on the release page, download our tar.xz file instead. If you're just building for yourself without creating a package for some distribution, then using source code cloning in git is an even more convenient way.

The checksums are:

```
$ sha256sum darktable-5.0.1.tar.xz
??? darktable-5.0.1.tar.xz

$ sha256sum darktable-5.0.1-x86_64.dmg
??? darktable-5.0.1-x86_64.dmg

$ sha256sum darktable-5.0.1-arm64.dmg
??? darktable-5.0.1-arm64.dmg

$ sha256sum darktable-5.0.1-arm64-13.5.dmg
??? darktable-5.0.1-arm64-13.5.dmg

$ sha256sum darktable-5.0.1-win64.exe
??? darktable-5.0.1-win64.exe

$ sha256sum darktable-5.0.1-x86_64.AppImage
???  darktable-5.0.1-x86_64.AppImage
```

When updating from the stable 4.8 series, please bear in mind that your edits will be preserved during this process, but the new library and configuration will no longer be usable with 4.8.

You are strongly advised to take a backup first.

#### Important note: to make sure that Darktable can keep on supporting the raw file format for your camera, *please* read [this post](https://discuss.pixls.us/t/raw-samples-wanted/5420?u=lebedevri) on how/what raw samples you can contribute to ensure that we have the *full* raw sample set for your camera under CC0 license!

Since Darktable 5.0.0:

- 105 commits to Darktable+rawspeed
-  57 pull requests handled
-  15 issues closed

_Please note that the Darktable documentation is not currently complete for release 5.0
and contributions are greatly appreciated. Please see the
[project documentation](https://github.com/darktable-org/dtdocs#contributing)
for more information on how to contribute._

## The Big Ones

The following is a summary of the main features added to Darktable
5.0.1. Please see the user manual for more details of the individual
changes (where available).

- N/A

## UI/UX Improvements

- N/A

## Performance Improvements

- Improved performance of discarding history of selected images.

## Other Changes

- Harmonized style selection in print settings with the update made in
  the export module for release 5.0.

- Darktable now includes the Lensfun database into the AppImage.

- Center collapsible module section labels.

## Bug Fixes

- Fixed a scrolling bug in the collections module where the collection
  tree was not scrolled to the previous position when returning from
  darkroom.

- Fix crash when attempting to move up the top or only shape in a
  group in the mask manager.

- Fix collection module when using the "module" filter which was
  listing none of the processing modules.

- Fix iop-order user presets use. It was not possible to get a user's
  iop-order preset to be applied as the Darktable internal presets
  where always picked up first.

- Fixed a crash in variable expansion for $(SEQUENCE[n,m]).

- Fixed handling on click from filmstrip when in map and print
  view. On map we now properly center the image on the map. On the
  print view, we use the selected image as content of the main print
  area.

- Fixed a regression introduced in 5.0.0 where we lost the ability to
  read 2-channel TIFF files and files with more than 4 channels. This
  fix allows them to be read by the TIFF loader, whereas previously
  the TIFF loader rejected such files and they were loaded by a
  fallback loader (GraphicsMagick or ImageMagick).

- Fixed not being able to pan with a mouse in the zoomable layout.

- Fixed possibly collapsing the module header when restoring defaults.

- Fixed a case of XMP being written without actual image modification.

- Fixed a crash of Darktable when reimporting XMP having overlay
  images referenced.

- Fixed the support for single lib module opened at a time when in
  darkroom.

- Fixed xmp sidecar writing while working as a gimp plugin.

- Fixed issues when applying a style in darkroom using the Styles
  module.

- Fixed a possible crash when using <kbd>Ctrl+z</kbd> reproduced on
  macOS.

- Fixed Darktable crashing in enlarge-canvas module.

- Fixed Darktable crashing using details mask due to bad tiling.

- Fixed a hash calculation bug leading to pixelpipe instabilities.

- Fixed issue to handle auto-presets when the focal length is greater
  then 1000.

- Fixed crash on macOS when closing the darkroom's second window.

- Fixed possible jump in filmstrip when entering darkroom from full
  preview.

- Fixed a performance regression in haze removal module.

- Fixed reading palette-based PNG with transparency.

- Fixed possible crash in lens correction module when changing camera
  and/or lens model.

- Fixed crash after deleting style or preset that was selected in
  shortcuts dialog.

- Fixed a crash when the currently active module instance is being
  deleted.

- We now support the correct orientation for JPEG XL if it was
  specified in the format's metadata but not in Exif (or Exif is
  missing). We also avoid over-transformation if it is specified in
  both the basic data and Exif.

## Lua

### API Version

- API version is now 9.4.0

### New Features

- N/A

### Bug Fixes

- N/A

### Add action support for Lua

### Other Lua changes

- N/A

## Notes

- When exporting to AVIF, EXR, JPEG XL, or XCF, selecting specific
  metadata (e.g. geo-tag or creator) is not currently possible. For
  AVIF, EXR, JPEG XL, and XCF formats, Darktable will not include any
  metadata fields unless the user selects all of the checkboxes in the
  export module's preference options.

- Starting with release 4.8, macOS versions older than 13.5 are not
  supported.

## Changed Dependencies

### Mandatory

- Bump SQLite requirement to 3.26

### Optional

- N/A

## RawSpeed changes

- Fujifilm GFX cameras now use the vendor supplied crop

## Camera support, compared to 5.0.1

### Base Support

- Leica SL3-S (DNG)
- Minolta DiMAGE 5
- Panasonic DC-S5D (3:2)

### White Balance Presets

- N/A

### Noise Profiles

- Fujifilm GFX100 II
- Fujifilm X-S20
- Fujifilm X100VI

### Missing Compression Mode Support

- Apple ProRAW DNGs
- CinemaDNG lossless (Blackmagic, some DJI, etc.) and lossy (Blackmagic)
- DNG 1.7 using JPEG XL (Adobe enhanced, Samsung Expert RAW)
- Fujifilm lossy RAFs
- Nikon high efficiency NEFs
- OM System 14-bit high resolution ORFs
- Sony downsized lossless ARWs ("M" for full-frame, "S" for full-frame & APS-C)

### Suspended Support

Support for the following cameras is suspended because no samples are available on https://raw.pixls.us:

- Creo/Leaf Aptus 22(LF3779)/Hasselblad H1
- Fujifilm IS-1
- Kodak EasyShare Z980
- Leaf Aptus-II 5(LI300059)/Mamiya 645 AFD
- Leaf Credo 60
- Leaf Credo 80
- Olympus SP320
- Phase One IQ250
- Sinar Hy6/ Sinarback eXact
- ST Micro STV680

## Translations

- Albanian
- Brazilian Portuguese
- Chinese (Simplified)
- Chinese (Traditional)
- Czech
- Dutch
- European Spanish
- Finnish
- French
- German
- Hungarian
- Japanese
- Polish
- Slovenian
- Swedish
- Ukrainian
